/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.18-master-97a1616
 */
goog.provide("ngmaterial.components.datepicker"),goog.require("ngmaterial.components.icon"),goog.require("ngmaterial.components.virtualRepeat"),goog.require("ngmaterial.core"),angular.module("material.components.datepicker",["material.core","material.components.icon","material.components.virtualRepeat"]),function(){"use strict";e.$inject=["$element","$scope","$$mdDateUtil","$mdUtil","$mdConstant","$mdTheming","$$rAF","$attrs","$mdDateLocale"],angular.module("material.components.datepicker").directive("mdCalendar",function(){return{template:function(e,t){return'<div ng-switch="calendarCtrl.currentView" '+(t.hasOwnProperty("ngIf")?"":'ng-if="calendarCtrl.isInitialized"')+'><md-calendar-year ng-switch-when="year"></md-calendar-year><md-calendar-month ng-switch-default></md-calendar-month></div>'},scope:{minDate:"=mdMinDate",maxDate:"=mdMaxDate",dateFilter:"=mdDateFilter",_mode:"@mdMode",_currentView:"@mdCurrentView"},require:["ngModel","mdCalendar"],controller:e,controllerAs:"calendarCtrl",bindToController:!0,link:function(e,t,a,n){var i=n[0];n[1].configureNgModel(i)}}});var h=0,t={day:"month",month:"year"};function e(e,t,a,n,i,r,l,s,o){r(e),this.$element=e,this.$scope=t,this.dateUtil=a,this.$mdUtil=n,this.keyCode=i.KEY_CODE,this.$$rAF=l,this.$mdDateLocale=o,this.today=this.dateUtil.createDateAtMidnight(),this.ngModelCtrl=null,this.SELECTED_DATE_CLASS="md-calendar-selected-date",this.TODAY_CLASS="md-calendar-date-today",this.FOCUSED_DATE_CLASS="md-focus",this.id=h++,this.displayDate=null,this.selectedDate=null,this.firstRenderableDate=null,this.lastRenderableDate=null,this.isInitialized=!1,this.width=0,this.scrollbarWidth=0,s.tabindex||e.attr("tabindex","-1");var d,c=angular.bind(this,this.handleKeyEvent);(d=e.parent().hasClass("md-datepicker-calendar")?angular.element(document.body):e).on("keydown",c),t.$on("$destroy",function(){d.off("keydown",c)}),1===angular.version.major&&angular.version.minor<=4&&this.$onInit()}e.prototype.$onInit=function(){this._mode&&t.hasOwnProperty(this._mode)?(this.currentView=t[this._mode],this.mode=this._mode):(this.currentView=this._currentView||"month",this.mode=null);var e=this.$mdDateLocale;this.minDate&&this.minDate>e.firstRenderableDate?this.firstRenderableDate=this.minDate:this.firstRenderableDate=e.firstRenderableDate,this.maxDate&&this.maxDate<e.lastRenderableDate?this.lastRenderableDate=this.maxDate:this.lastRenderableDate=e.lastRenderableDate},e.prototype.configureNgModel=function(e){var t=this;t.ngModelCtrl=e,t.$mdUtil.nextTick(function(){t.isInitialized=!0}),e.$render=function(){var e=this.$viewValue;t.$scope.$broadcast("md-calendar-parent-changed",e),t.selectedDate||(t.selectedDate=e),t.displayDate||(t.displayDate=t.selectedDate||t.today)}},e.prototype.setNgModelValue=function(e){var t=this.dateUtil.createDateAtMidnight(e);return this.focus(t),this.$scope.$emit("md-calendar-change",t),this.ngModelCtrl.$setViewValue(t),this.ngModelCtrl.$render(),t},e.prototype.setCurrentView=function(e,t){var a=this;a.$mdUtil.nextTick(function(){a.currentView=e,t&&(a.displayDate=angular.isDate(t)?t:new Date(t))})},e.prototype.focus=function(e){if(this.dateUtil.isValidDate(e)){var t=this.$element[0].querySelector("."+this.FOCUSED_DATE_CLASS);t&&t.classList.remove(this.FOCUSED_DATE_CLASS);var a=this.getDateId(e,this.currentView),n=document.getElementById(a);n&&(n.classList.add(this.FOCUSED_DATE_CLASS),n.focus(),this.displayDate=e)}else{var i=this.$element[0].querySelector("[ng-switch]");i&&i.focus()}},e.prototype.changeSelectedDate=function(e){var t=this.SELECTED_DATE_CLASS,a=this.$element[0].querySelector("."+t);if(a&&(a.classList.remove(t),a.setAttribute("aria-selected","false")),e){var n=document.getElementById(this.getDateId(e,this.currentView));n&&(n.classList.add(t),n.setAttribute("aria-selected","true"))}this.selectedDate=e},e.prototype.getActionFromKeyEvent=function(e){var t=this.keyCode;switch(e.which){case t.ENTER:return"select";case t.RIGHT_ARROW:return"move-right";case t.LEFT_ARROW:return"move-left";case t.DOWN_ARROW:return e.metaKey?"move-page-down":"move-row-down";case t.UP_ARROW:return e.metaKey?"move-page-up":"move-row-up";case t.PAGE_DOWN:return"move-page-down";case t.PAGE_UP:return"move-page-up";case t.HOME:return"start";case t.END:return"end";default:return null}},e.prototype.handleKeyEvent=function(t){var a=this;this.$scope.$apply(function(){if(t.which==a.keyCode.ESCAPE||t.which==a.keyCode.TAB)return a.$scope.$emit("md-calendar-close"),void(t.which==a.keyCode.TAB&&t.preventDefault());var e=a.getActionFromKeyEvent(t);e&&(t.preventDefault(),t.stopPropagation(),a.$scope.$broadcast("md-calendar-parent-action",e))})},e.prototype.hideVerticalScrollbar=function(n){var i=this,t=n.$element[0],r=t.querySelector(".md-calendar-scroll-mask");function a(){var e=i.width||340,t=i.scrollbarWidth,a=n.calendarScroller;r.style.width=e+"px",a.style.width=e+t+"px",a.style.paddingRight=t+"px"}0<i.width?a():i.$$rAF(function(){var e=n.calendarScroller;i.scrollbarWidth=e.offsetWidth-e.clientWidth,i.width=t.querySelector("table").offsetWidth,a()})},e.prototype.getDateId=function(e,t){if(!t)throw new Error("A namespace for the date id has to be specified.");return["md",this.id,t,e.getFullYear(),e.getMonth(),e.getDate()].join("-")},e.prototype.updateVirtualRepeat=function(){var e=this.$scope,t=e.$on("$md-resize-enable",function(){e.$$phase||e.$apply(),t()})}}(),function(){"use strict";t.$inject=["$element","$scope","$animate","$q","$$mdDateUtil","$mdDateLocale"],angular.module("material.components.datepicker").directive("mdCalendarMonth",function(){return{template:'<table aria-hidden="true" class="md-calendar-day-header"><thead></thead></table><div class="md-calendar-scroll-mask"><md-virtual-repeat-container class="md-calendar-scroll-container" md-offset-size="'+(e-a)+'"><table role="grid" tabindex="0" class="md-calendar" aria-readonly="true"><tbody md-calendar-month-body role="rowgroup" md-virtual-repeat="i in monthCtrl.items" md-month-offset="$index" class="md-calendar-month" md-start-index="monthCtrl.getSelectedMonthIndex()" md-item-size="'+a+'"><tr aria-hidden="true" md-force-height="\''+a+"px'\"></tr></tbody></table></md-virtual-repeat-container></div>",require:["^^mdCalendar","mdCalendarMonth"],controller:t,controllerAs:"monthCtrl",bindToController:!0,link:function(e,t,a,n){var i=n[0];n[1].initialize(i)}}});var a=265,e=45;function t(e,t,a,n,i,r){this.$element=e,this.$scope=t,this.$animate=a,this.$q=n,this.dateUtil=i,this.dateLocale=r,this.calendarScroller=e[0].querySelector(".md-virtual-repeat-scroller"),this.isInitialized=!1,this.isMonthTransitionInProgress=!1;var l=this;this.cellClickHandler=function(){var e=i.getTimestampFromNode(this);l.$scope.$apply(function(){l.calendarCtrl.setNgModelValue(e)})},this.headerClickHandler=function(){l.calendarCtrl.setCurrentView("year",i.getTimestampFromNode(this))}}t.prototype.initialize=function(e){this.items={length:this.dateUtil.getMonthDistance(e.firstRenderableDate,e.lastRenderableDate)+2},this.calendarCtrl=e,this.attachScopeListeners(),e.updateVirtualRepeat(),e.ngModelCtrl&&e.ngModelCtrl.$render()},t.prototype.getSelectedMonthIndex=function(){var e=this.calendarCtrl;return this.dateUtil.getMonthDistance(e.firstRenderableDate,e.displayDate||e.selectedDate||e.today)},t.prototype.changeDisplayDate=function(e){if(!this.isInitialized)return this.buildWeekHeader(),this.calendarCtrl.hideVerticalScrollbar(this),this.isInitialized=!0,this.$q.when();if(!this.dateUtil.isValidDate(e)||this.isMonthTransitionInProgress)return this.$q.when();this.isMonthTransitionInProgress=!0;var t=this.animateDateChange(e);this.calendarCtrl.displayDate=e;var a=this;return t.then(function(){a.isMonthTransitionInProgress=!1}),t},t.prototype.animateDateChange=function(e){if(this.dateUtil.isValidDate(e)){var t=this.dateUtil.getMonthDistance(this.calendarCtrl.firstRenderableDate,e);this.calendarScroller.scrollTop=t*a}return this.$q.when()},t.prototype.buildWeekHeader=function(){for(var e=this.dateLocale.firstDayOfWeek,t=this.dateLocale.shortDays,a=document.createElement("tr"),n=0;n<7;n++){var i=document.createElement("th");i.textContent=t[(n+e)%7],a.appendChild(i)}this.$element.find("thead").append(a)},t.prototype.attachScopeListeners=function(){var a=this;a.$scope.$on("md-calendar-parent-changed",function(e,t){a.calendarCtrl.changeSelectedDate(t),a.changeDisplayDate(t)}),a.$scope.$on("md-calendar-parent-action",angular.bind(this,this.handleKeyEvent))},t.prototype.handleKeyEvent=function(e,t){var a=this.calendarCtrl,n=a.displayDate;if("select"===t)a.setNgModelValue(n);else{var i=null,r=this.dateUtil;switch(t){case"move-right":i=r.incrementDays(n,1);break;case"move-left":i=r.incrementDays(n,-1);break;case"move-page-down":i=r.incrementMonths(n,1);break;case"move-page-up":i=r.incrementMonths(n,-1);break;case"move-row-down":i=r.incrementDays(n,7);break;case"move-row-up":i=r.incrementDays(n,-7);break;case"start":i=r.getFirstDateOfMonth(n);break;case"end":i=r.getLastDateOfMonth(n)}i&&(i=this.dateUtil.clampDate(i,a.minDate,a.maxDate),this.changeDisplayDate(i).then(function(){a.focus(i)}))}}}(),function(){"use strict";function e(e,t){var s=e('<md-icon md-svg-src="'+t.mdTabsArrow+'"></md-icon>')({})[0];return{require:["^^mdCalendar","^^mdCalendarMonth","mdCalendarMonthBody"],scope:{offset:"=mdMonthOffset"},controller:a,controllerAs:"mdMonthBodyCtrl",bindToController:!0,link:function(e,t,a,n){var i=n[0],r=n[1],l=n[2];l.calendarCtrl=i,l.monthCtrl=r,l.arrowIcon=s.cloneNode(!0),e.$watch(function(){return l.offset},function(e){angular.isNumber(e)&&l.generateContent()})}}}function a(e,t,a){this.$element=e,this.dateUtil=t,this.dateLocale=a,this.monthCtrl=null,this.calendarCtrl=null,this.offset=null,this.focusAfterAppend=null}e.$inject=["$compile","$$mdSvgRegistry"],a.$inject=["$element","$$mdDateUtil","$mdDateLocale"],angular.module("material.components.datepicker").directive("mdCalendarMonthBody",e),a.prototype.generateContent=function(){var e=this.dateUtil.incrementMonths(this.calendarCtrl.firstRenderableDate,this.offset);this.$element.empty().append(this.buildCalendarForMonth(e)),this.focusAfterAppend&&(this.focusAfterAppend.classList.add(this.calendarCtrl.FOCUSED_DATE_CLASS),this.focusAfterAppend.focus(),this.focusAfterAppend=null)},a.prototype.buildDateCell=function(e){var t=this.monthCtrl,a=this.calendarCtrl,n=document.createElement("td");if(n.tabIndex=-1,n.classList.add("md-calendar-date"),n.setAttribute("role","gridcell"),e){n.setAttribute("tabindex","-1"),n.setAttribute("aria-label",this.dateLocale.longDateFormatter(e)),n.id=a.getDateId(e,"month"),n.setAttribute("data-timestamp",e.getTime()),this.dateUtil.isSameDay(e,a.today)&&n.classList.add(a.TODAY_CLASS),this.dateUtil.isValidDate(a.selectedDate)&&this.dateUtil.isSameDay(e,a.selectedDate)&&(n.classList.add(a.SELECTED_DATE_CLASS),n.setAttribute("aria-selected","true"));var i=this.dateLocale.dates[e.getDate()];if(this.isDateEnabled(e)){var r=document.createElement("span");r.classList.add("md-calendar-date-selection-indicator"),r.textContent=i,n.appendChild(r),n.addEventListener("click",t.cellClickHandler),a.displayDate&&this.dateUtil.isSameDay(e,a.displayDate)&&(this.focusAfterAppend=n)}else n.classList.add("md-calendar-date-disabled"),n.textContent=i}return n},a.prototype.isDateEnabled=function(e){return this.dateUtil.isDateWithinRange(e,this.calendarCtrl.minDate,this.calendarCtrl.maxDate)&&(!angular.isFunction(this.calendarCtrl.dateFilter)||this.calendarCtrl.dateFilter(e))},a.prototype.buildDateRow=function(e){var t=document.createElement("tr");return t.setAttribute("role","row"),t.setAttribute("aria-label",this.dateLocale.weekNumberFormatter(e)),t},a.prototype.buildCalendarForMonth=function(e){var t=this.dateUtil.isValidDate(e)?e:new Date,a=this.dateUtil.getFirstDateOfMonth(t),n=this.getLocaleDay_(a),i=this.dateUtil.getNumberOfDaysInMonth(t),r=document.createDocumentFragment(),l=1,s=this.buildDateRow(l);r.appendChild(s);var o=this.offset===this.monthCtrl.items.length-1,d=0,c=document.createElement("td"),h=document.createElement("span"),u=this.calendarCtrl;if(h.textContent=this.dateLocale.monthHeaderFormatter(t),c.appendChild(h),c.classList.add("md-calendar-month-label"),u.maxDate&&a>u.maxDate?c.classList.add("md-calendar-month-label-disabled"):u.mode||(c.addEventListener("click",this.monthCtrl.headerClickHandler),c.setAttribute("data-timestamp",a.getTime()),c.setAttribute("aria-label",this.dateLocale.monthFormatter(t)),c.classList.add("md-calendar-label-clickable"),c.appendChild(this.arrowIcon.cloneNode(!0))),n<=2){c.setAttribute("colspan","7");var m=this.buildDateRow();if(m.appendChild(c),r.insertBefore(m,s),o)return r}else d=3,c.setAttribute("colspan","3"),s.appendChild(c);for(var p=d;p<n;p++)s.appendChild(this.buildDateCell());for(var g=n,f=a,D=1;D<=i;D++){if(7===g){if(o)return r;g=0,l++,s=this.buildDateRow(l),r.appendChild(s)}f.setDate(D);var C=this.buildDateCell(f);s.appendChild(C),g++}for(;s.childNodes.length<7;)s.appendChild(this.buildDateCell());for(;r.childNodes.length<6;){for(var y=this.buildDateRow(),v=0;v<7;v++)y.appendChild(this.buildDateCell());r.appendChild(y)}return r},a.prototype.getLocaleDay_=function(e){return(e.getDay()+(7-this.dateLocale.firstDayOfWeek))%7}}(),function(){"use strict";e.$inject=["$element","$scope","$animate","$q","$$mdDateUtil","$mdUtil"],angular.module("material.components.datepicker").directive("mdCalendarYear",function(){return{template:'<div class="md-calendar-scroll-mask"><md-virtual-repeat-container class="md-calendar-scroll-container"><table role="grid" tabindex="0" class="md-calendar" aria-readonly="true"><tbody md-calendar-year-body role="rowgroup" md-virtual-repeat="i in yearCtrl.items" md-year-offset="$index" class="md-calendar-year" md-start-index="yearCtrl.getFocusedYearIndex()" md-item-size="'+a+'"><tr aria-hidden="true" md-force-height="\''+a+"px'\"></tr></tbody></table></md-virtual-repeat-container></div>",require:["^^mdCalendar","mdCalendarYear"],controller:e,controllerAs:"yearCtrl",bindToController:!0,link:function(e,t,a,n){var i=n[0];n[1].initialize(i)}}});var a=88;function e(e,t,a,n,i,r){this.$element=e,this.$scope=t,this.$animate=a,this.$q=n,this.dateUtil=i,this.calendarScroller=e[0].querySelector(".md-virtual-repeat-scroller"),this.isInitialized=!1,this.isMonthTransitionInProgress=!1,this.$mdUtil=r;var l=this;this.cellClickHandler=function(){l.onTimestampSelected(i.getTimestampFromNode(this))}}e.prototype.initialize=function(e){this.items={length:this.dateUtil.getYearDistance(e.firstRenderableDate,e.lastRenderableDate)+1},this.calendarCtrl=e,this.attachScopeListeners(),e.updateVirtualRepeat(),e.ngModelCtrl&&e.ngModelCtrl.$render()},e.prototype.getFocusedYearIndex=function(){var e=this.calendarCtrl;return this.dateUtil.getYearDistance(e.firstRenderableDate,e.displayDate||e.selectedDate||e.today)},e.prototype.changeDate=function(e){if(!this.isInitialized)return this.calendarCtrl.hideVerticalScrollbar(this),this.isInitialized=!0,this.$q.when();if(this.dateUtil.isValidDate(e)&&!this.isMonthTransitionInProgress){var t=this,a=this.animateDateChange(e);return t.isMonthTransitionInProgress=!0,t.calendarCtrl.displayDate=e,a.then(function(){t.isMonthTransitionInProgress=!1})}},e.prototype.animateDateChange=function(e){if(this.dateUtil.isValidDate(e)){var t=this.dateUtil.getYearDistance(this.calendarCtrl.firstRenderableDate,e);this.calendarScroller.scrollTop=t*a}return this.$q.when()},e.prototype.handleKeyEvent=function(e,t){var a=this,n=a.calendarCtrl,i=n.displayDate;if("select"===t)a.changeDate(i).then(function(){a.onTimestampSelected(i)});else{var r=null,l=a.dateUtil;switch(t){case"move-right":r=l.incrementMonths(i,1);break;case"move-left":r=l.incrementMonths(i,-1);break;case"move-row-down":r=l.incrementMonths(i,6);break;case"move-row-up":r=l.incrementMonths(i,-6)}if(r){var s=n.minDate?l.getFirstDateOfMonth(n.minDate):null,o=n.maxDate?l.getFirstDateOfMonth(n.maxDate):null;r=l.getFirstDateOfMonth(a.dateUtil.clampDate(r,s,o)),a.changeDate(r).then(function(){n.focus(r)})}}},e.prototype.attachScopeListeners=function(){var a=this;a.$scope.$on("md-calendar-parent-changed",function(e,t){a.calendarCtrl.changeSelectedDate(t?a.dateUtil.getFirstDateOfMonth(t):t),a.changeDate(t)}),a.$scope.$on("md-calendar-parent-action",angular.bind(a,a.handleKeyEvent))},e.prototype.onTimestampSelected=function(e){var t=this.calendarCtrl;t.mode?this.$mdUtil.nextTick(function(){t.setNgModelValue(e)}):t.setCurrentView("month",e)}}(),function(){"use strict";function e(e,t,a){this.$element=e,this.dateUtil=t,this.dateLocale=a,this.calendarCtrl=null,this.yearCtrl=null,this.offset=null,this.focusAfterAppend=null}e.$inject=["$element","$$mdDateUtil","$mdDateLocale"],angular.module("material.components.datepicker").directive("mdCalendarYearBody",function(){return{require:["^^mdCalendar","^^mdCalendarYear","mdCalendarYearBody"],scope:{offset:"=mdYearOffset"},controller:e,controllerAs:"mdYearBodyCtrl",bindToController:!0,link:function(e,t,a,n){var i=n[0],r=n[1],l=n[2];l.calendarCtrl=i,l.yearCtrl=r,e.$watch(function(){return l.offset},function(e){angular.isNumber(e)&&l.generateContent()})}}}),e.prototype.generateContent=function(){var e=this.dateUtil.incrementYears(this.calendarCtrl.firstRenderableDate,this.offset);this.$element.empty().append(this.buildCalendarForYear(e)),this.focusAfterAppend&&(this.focusAfterAppend.classList.add(this.calendarCtrl.FOCUSED_DATE_CLASS),this.focusAfterAppend.focus(),this.focusAfterAppend=null)},e.prototype.buildMonthCell=function(e,t){var a=this.calendarCtrl,n=this.yearCtrl,i=this.buildBlankCell(),r=new Date(e,t,1);i.setAttribute("aria-label",this.dateLocale.monthFormatter(r)),i.id=a.getDateId(r,"year"),i.setAttribute("data-timestamp",String(r.getTime())),this.dateUtil.isSameMonthAndYear(r,a.today)&&i.classList.add(a.TODAY_CLASS),this.dateUtil.isValidDate(a.selectedDate)&&this.dateUtil.isSameMonthAndYear(r,a.selectedDate)&&(i.classList.add(a.SELECTED_DATE_CLASS),i.setAttribute("aria-selected","true"));var l=this.dateLocale.shortMonths[t];if(!this.dateUtil.isMonthWithinRange(r,a.minDate,a.maxDate)||angular.isFunction(this.calendarCtrl.dateFilter)&&!this.calendarCtrl.dateFilter(r))i.classList.add("md-calendar-date-disabled"),i.textContent=l;else{var s=document.createElement("span");s.classList.add("md-calendar-date-selection-indicator"),s.textContent=l,i.appendChild(s),i.addEventListener("click",n.cellClickHandler),a.displayDate&&this.dateUtil.isSameMonthAndYear(r,a.displayDate)&&(this.focusAfterAppend=i)}return i},e.prototype.buildBlankCell=function(){var e=document.createElement("td");return e.tabIndex=-1,e.classList.add("md-calendar-date"),e.setAttribute("role","gridcell"),e.setAttribute("tabindex","-1"),e},e.prototype.buildCalendarForYear=function(e){var t,a=e.getFullYear(),n=document.createDocumentFragment(),i=document.createElement("tr"),r=document.createElement("td");for(r.className="md-calendar-month-label",r.textContent=a,i.appendChild(r),t=0;t<6;t++)i.appendChild(this.buildMonthCell(a,t));n.appendChild(i);var l=document.createElement("tr");for(l.appendChild(this.buildBlankCell()),t=6;t<12;t++)l.appendChild(this.buildMonthCell(a,t));return n.appendChild(l),n}}(),function(){"use strict";angular.module("material.components.datepicker").config(["$provide",function(e){function t(){this.months=null,this.shortMonths=null,this.days=null,this.shortDays=null,this.dates=null,this.firstDayOfWeek=0,this.formatDate=null,this.parseDate=null,this.monthHeaderFormatter=null,this.weekNumberFormatter=null,this.longDateFormatter=null,this.isDateComplete=null,this.msgCalendar="",this.msgOpenCalendar=""}(t.prototype.$get=function(e,i){for(var t=e.DATETIME_FORMATS.SHORTDAY.map(function(e){return e.substring(0,1)}),a=Array(32),n=1;n<=31;n++)a[n]=n;var r=new Date(1880,0,1),l=new Date(r.getFullYear()+250,0,1),s={months:this.months||e.DATETIME_FORMATS.MONTH,shortMonths:this.shortMonths||e.DATETIME_FORMATS.SHORTMONTH,days:this.days||e.DATETIME_FORMATS.DAY,shortDays:this.shortDays||t,dates:this.dates||a,firstDayOfWeek:this.firstDayOfWeek||0,formatDate:this.formatDate||function(e,t){if(!e)return"";var a=e.toLocaleTimeString(),n=e;return 0!==e.getHours()||-1===a.indexOf("11:")&&-1===a.indexOf("23:")||(n=new Date(e.getFullYear(),e.getMonth(),e.getDate(),1,0,0)),i("date")(n,"M/d/yyyy",t)},parseDate:this.parseDate||function(e){return new Date(e)},isDateComplete:this.isDateComplete||function(e){return e=e.trim(),/^(([a-zA-Z]{3,}|[0-9]{1,4})([ .,]+|[/-])){2}([a-zA-Z]{3,}|[0-9]{1,4})$/.test(e)},monthHeaderFormatter:this.monthHeaderFormatter||function(e){return s.shortMonths[e.getMonth()]+" "+e.getFullYear()},monthFormatter:this.monthFormatter||function(e){return s.months[e.getMonth()]+" "+e.getFullYear()},weekNumberFormatter:this.weekNumberFormatter||function(e){return"Week "+e},longDateFormatter:this.longDateFormatter||function(e){return[s.days[e.getDay()],s.months[e.getMonth()],s.dates[e.getDate()],e.getFullYear()].join(" ")},msgCalendar:this.msgCalendar||"Calendar",msgOpenCalendar:this.msgOpenCalendar||"Open calendar",firstRenderableDate:this.firstRenderableDate||r,lastRenderableDate:this.lastRenderableDate||l};return s}).$inject=["$locale","$filter"],e.provider("$mdDateLocale",new t)}])}(),function(){"use strict";angular.module("material.components.datepicker").factory("$$mdDateUtil",function(){return{getFirstDateOfMonth:a,getNumberOfDaysInMonth:i,getDateInNextMonth:n,getDateInPreviousMonth:r,isInNextMonth:function(e,t){return l(n(e),t)},isInPreviousMonth:function(e,t){var a=r(e);return l(t,a)},getDateMidpoint:function(e,t){return c((e.getTime()+t.getTime())/2)},isSameMonthAndYear:l,getWeekOfMonth:function(e){var t=a(e);return Math.floor((t.getDay()+e.getDate()-1)/7)},incrementDays:function(e,t){return new Date(e.getFullYear(),e.getMonth(),e.getDate()+t)},incrementMonths:s,getLastDateOfMonth:function(e){return new Date(e.getFullYear(),e.getMonth(),i(e))},isSameDay:function(e,t){return e.getDate()==t.getDate()&&l(e,t)},getMonthDistance:function(e,t){return 12*(t.getFullYear()-e.getFullYear())+(t.getMonth()-e.getMonth())},isValidDate:o,setDateTimeToMidnight:d,createDateAtMidnight:c,isDateWithinRange:function(e,t,a){var n=c(e),i=o(t)?c(t):null,r=o(a)?c(a):null;return(!i||i<=n)&&(!r||n<=r)},incrementYears:function(e,t){return s(e,12*t)},getYearDistance:function(e,t){return t.getFullYear()-e.getFullYear()},clampDate:function(e,t,a){var n=e;t&&e<t&&(n=new Date(t.getTime()));a&&a<e&&(n=new Date(a.getTime()));return n},getTimestampFromNode:function(e){if(e&&e.hasAttribute("data-timestamp"))return Number(e.getAttribute("data-timestamp"))},isMonthWithinRange:function(e,t,a){var n=e.getMonth(),i=e.getFullYear();return(!t||t.getFullYear()<i||t.getMonth()<=n)&&(!a||a.getFullYear()>i||a.getMonth()>=n)}};function a(e){return new Date(e.getFullYear(),e.getMonth(),1)}function i(e){return new Date(e.getFullYear(),e.getMonth()+1,0).getDate()}function n(e){return new Date(e.getFullYear(),e.getMonth()+1,1)}function r(e){return new Date(e.getFullYear(),e.getMonth()-1,1)}function l(e,t){return e.getFullYear()===t.getFullYear()&&e.getMonth()===t.getMonth()}function s(e,t){var a=new Date(e.getFullYear(),e.getMonth()+t,1),n=i(a);return n<e.getDate()?a.setDate(n):a.setDate(e.getDate()),a}function o(e){return e&&e.getTime&&!isNaN(e.getTime())}function d(e){o(e)&&e.setHours(0,0,0,0)}function c(e){var t;return d(t=angular.isUndefined(e)?new Date:new Date(e)),t}})}(),function(){"use strict";function e(l,h,u,m){return{template:function(e,t){var a=t.mdHideIcons,n=t.ariaLabel||t.mdPlaceholder,i="all"===a||"calendar"===a?"":'<md-button class="md-datepicker-button md-icon-button" type="button" tabindex="-1" aria-hidden="true" ng-click="ctrl.openCalendarPane($event)"><md-icon class="md-datepicker-calendar-icon" aria-label="md-calendar" md-svg-src="'+l.mdCalendar+'"></md-icon></md-button>',r="";return"all"!==a&&"triangle"!==a&&(r='<md-button type="button" md-no-ink class="md-datepicker-triangle-button md-icon-button" ng-click="ctrl.openCalendarPane($event)" aria-label="{{::ctrl.locale.msgOpenCalendar}}"><div class="md-datepicker-expand-triangle"></div></md-button>',e.addClass(s)),i+'<div class="md-datepicker-input-container" ng-class="{\'md-datepicker-focused\': ctrl.isFocused}"><input '+(n?'aria-label="'+n+'" ':"")+'class="md-datepicker-input" aria-haspopup="true" aria-expanded="{{ctrl.isCalendarOpen}}" ng-focus="ctrl.setFocused(true)" ng-blur="ctrl.setFocused(false)"> '+r+'</div><div class="md-datepicker-calendar-pane md-whiteframe-z1" id="{{::ctrl.calendarPaneId}}"><div class="md-datepicker-input-mask"><div class="md-datepicker-input-mask-opaque"></div></div><div class="md-datepicker-calendar"><md-calendar role="dialog" aria-label="{{::ctrl.locale.msgCalendar}}" md-current-view="{{::ctrl.currentView}}" md-mode="{{::ctrl.mode}}" md-min-date="ctrl.minDate" md-max-date="ctrl.maxDate" md-date-filter="ctrl.dateFilter" ng-model="ctrl.date" ng-if="ctrl.isCalendarOpen"></md-calendar></div></div>'},require:["ngModel","mdDatepicker","?^mdInputContainer","?^form"],scope:{minDate:"=mdMinDate",maxDate:"=mdMaxDate",placeholder:"@mdPlaceholder",currentView:"@mdCurrentView",mode:"@mdMode",dateFilter:"=mdDateFilter",isOpen:"=?mdIsOpen",debounceInterval:"=mdDebounceInterval",dateLocale:"=mdDateLocale"},controller:t,controllerAs:"ctrl",bindToController:!0,link:function(e,t,a,n){var i=n[0],r=n[1],l=n[2],s=n[3],o=h.parseAttributeBoolean(a.mdNoAsterisk);if(r.configureNgModel(i,l,m),l){var d=t[0].querySelector(".md-errors-spacer");d&&t.after(angular.element("<div>").append(d)),l.setHasPlaceholder(a.mdPlaceholder),l.input=t,l.element.addClass(p).toggleClass(g,"calendar"!==a.mdHideIcons&&"all"!==a.mdHideIcons),l.label?o||a.$observe("required",function(e){l.label.toggleClass("md-required",!!e)}):u.expect(t,"aria-label",a.mdPlaceholder),e.$watch(l.isErrorGetter||function(){return i.$invalid&&(i.$touched||s&&s.$submitted)},l.setInvalid)}else if(s)var c=e.$watch(function(){return s.$submitted},function(e){e&&(r.updateErrorState(),c())})}}}t.$inject=["$scope","$element","$attrs","$window","$mdConstant","$mdTheming","$mdUtil","$mdDateLocale","$$mdDateUtil","$$rAF","$filter","$timeout"],e.$inject=["$$mdSvgRegistry","$mdUtil","$mdAria","inputDirective"],angular.module("material.components.datepicker").directive("mdDatepicker",e);var l="md-datepicker-invalid",h="md-datepicker-open",p="_md-datepicker-floating-label",g="_md-datepicker-has-calendar-icon",s="_md-datepicker-has-triangle-icon",m=/ipad|iphone|ipod|android/i;function t(e,t,a,n,i,r,l,s,o,d,c,h){this.$window=n,this.dateUtil=o,this.$mdConstant=i,this.$mdUtil=l,this.$$rAF=d,this.$mdDateLocale=s,this.$timeout=h,this.documentElement=angular.element(document.documentElement),this.ngModelCtrl=null,this.inputElement=t[0].querySelector("input"),this.ngInputElement=angular.element(this.inputElement),this.inputContainer=t[0].querySelector(".md-datepicker-input-container"),this.calendarPane=t[0].querySelector(".md-datepicker-calendar-pane"),this.calendarButton=t[0].querySelector(".md-datepicker-button"),this.inputMask=angular.element(t[0].querySelector(".md-datepicker-input-mask-opaque")),this.$element=t,this.$attrs=a,this.$scope=e,this.date=null,this.isFocused=!1,this.isDisabled,this.setDisabled(t[0].disabled||angular.isString(a.disabled)),this.isCalendarOpen=!1,this.openOnFocus=a.hasOwnProperty("mdOpenOnFocus"),this.mdInputContainer=null,this.calendarPaneOpenedFrom=null,this.calendarPaneId="md-date-pane-"+l.nextUid(),this.bodyClickHandler=angular.bind(this,this.handleBodyClick),this.windowEventName=m.test(navigator.userAgent||navigator.vendor||window.opera)?"orientationchange":"resize",this.windowEventHandler=l.debounce(angular.bind(this,this.closeCalendarPane),100),this.windowBlurHandler=angular.bind(this,this.handleWindowBlur),this.ngDateFilter=c("date"),this.leftMargin=20,this.topMargin=null,a.tabindex?(this.ngInputElement.attr("tabindex",a.tabindex),a.$set("tabindex",null)):a.$set("tabindex","-1"),a.$set("aria-owns",this.calendarPaneId),r(t),r(angular.element(this.calendarPane));var u=this;e.$on("$destroy",function(){u.detachCalendarPane()}),a.mdIsOpen&&e.$watch("ctrl.isOpen",function(e){e?u.openCalendarPane({target:u.inputElement}):u.closeCalendarPane()}),1===angular.version.major&&angular.version.minor<=4&&this.$onInit()}t.prototype.$onInit=function(){this.locale=this.dateLocale?angular.extend({},this.$mdDateLocale,this.dateLocale):this.$mdDateLocale,this.installPropertyInterceptors(),this.attachChangeListeners(),this.attachInteractionListeners()},t.prototype.configureNgModel=function(e,t,a){this.ngModelCtrl=e,this.mdInputContainer=t,this.$attrs.$set("type","date"),a[0].link.pre(this.$scope,{on:angular.noop,val:angular.noop,0:{}},this.$attrs,[e]);var n=this;n.ngModelCtrl.$formatters.push(function(e){var t=angular.isDefined(e)?e:null;if(!(e instanceof Date)&&(t=Date.parse(e),!isNaN(t)&&angular.isNumber(t)&&(e=new Date(t)),e&&!(e instanceof Date)))throw Error("The ng-model for md-datepicker must be a Date instance or a value that can be parsed into a date. Currently the model is of type: "+typeof e);return n.onExternalChange(e),e}),e.$viewChangeListeners.unshift(angular.bind(this,this.updateErrorState));var i=n.$mdUtil.getModelOption(e,"updateOn");i&&this.ngInputElement.on(i,angular.bind(this.$element,this.$element.triggerHandler,i))},t.prototype.attachChangeListeners=function(){var a=this;a.$scope.$on("md-calendar-change",function(e,t){a.setModelValue(t),a.onExternalChange(t),a.closeCalendarPane()}),a.ngInputElement.on("input",angular.bind(a,a.resizeInputElement));var e=angular.isDefined(this.debounceInterval)?this.debounceInterval:500;a.ngInputElement.on("input",a.$mdUtil.debounce(a.handleInputEvent,e,a))},t.prototype.attachInteractionListeners=function(){var t=this,a=this.$scope,n=this.$mdConstant.KEY_CODE;t.ngInputElement.on("keydown",function(e){e.altKey&&e.keyCode===n.DOWN_ARROW&&(t.openCalendarPane(e),a.$digest())}),t.openOnFocus&&(t.ngInputElement.on("focus",angular.bind(t,t.openCalendarPane)),t.ngInputElement.on("click",function(e){e.stopPropagation()}),t.ngInputElement.on("pointerdown",function(e){e.target&&e.target.setPointerCapture&&e.target.setPointerCapture(e.pointerId)}),angular.element(t.$window).on("blur",t.windowBlurHandler),a.$on("$destroy",function(){angular.element(t.$window).off("blur",t.windowBlurHandler)})),a.$on("md-calendar-close",function(){t.closeCalendarPane()})},t.prototype.installPropertyInterceptors=function(){var t=this;if(this.$attrs.ngDisabled){var e=this.$scope.$parent;e&&e.$watch(this.$attrs.ngDisabled,function(e){t.setDisabled(e)})}Object.defineProperty(this,"placeholder",{get:function(){return t.inputElement.placeholder},set:function(e){t.inputElement.placeholder=e||""}})},t.prototype.setDisabled=function(e){this.isDisabled=e,this.inputElement.disabled=e,this.calendarButton&&(this.calendarButton.disabled=e)},t.prototype.updateErrorState=function(e){var t=e||this.date;if(this.clearErrorState(),this.dateUtil.isValidDate(t)){if(t=this.dateUtil.createDateAtMidnight(t),this.dateUtil.isValidDate(this.minDate)){var a=this.dateUtil.createDateAtMidnight(this.minDate);this.ngModelCtrl.$setValidity("mindate",a<=t)}if(this.dateUtil.isValidDate(this.maxDate)){var n=this.dateUtil.createDateAtMidnight(this.maxDate);this.ngModelCtrl.$setValidity("maxdate",t<=n)}angular.isFunction(this.dateFilter)&&this.ngModelCtrl.$setValidity("filtered",this.dateFilter(t))}else this.ngModelCtrl.$setValidity("valid",null==t);var i=this.inputElement.value,r=this.locale.parseDate(i);!this.isInputValid(i,r)&&this.ngModelCtrl.$valid&&this.ngModelCtrl.$setValidity("valid",null==t),angular.element(this.inputContainer).toggleClass(l,!this.ngModelCtrl.$valid)},t.prototype.isInputValid=function(e,t){return""===e||this.dateUtil.isValidDate(t)&&this.locale.isDateComplete(e)&&this.isDateEnabled(t)},t.prototype.clearErrorState=function(){this.inputContainer.classList.remove(l),["mindate","maxdate","filtered","valid"].forEach(function(e){this.ngModelCtrl.$setValidity(e,!0)},this)},t.prototype.resizeInputElement=function(){this.inputElement.size=this.inputElement.value.length+3},t.prototype.handleInputEvent=function(){var e=this.inputElement.value,t=e?this.locale.parseDate(e):null;this.dateUtil.setDateTimeToMidnight(t),this.isInputValid(e,t)&&(this.setModelValue(t),this.date=t),this.updateErrorState(t)},t.prototype.isDateEnabled=function(e){return this.dateUtil.isDateWithinRange(e,this.minDate,this.maxDate)&&(!angular.isFunction(this.dateFilter)||this.dateFilter(e))},t.prototype.attachCalendarPane=function(){var e=this.calendarPane,t=document.body;e.style.transform="",this.$element.addClass(h),this.mdInputContainer&&this.mdInputContainer.element.addClass(h),angular.element(t).addClass("md-datepicker-is-showing");var a=this.inputContainer.getBoundingClientRect(),n=t.getBoundingClientRect();(!this.topMargin||this.topMargin<0)&&(this.topMargin=(this.inputMask.parent().prop("clientHeight")-this.ngInputElement.prop("clientHeight"))/2);var i=a.top-n.top-this.topMargin,r=a.left-n.left-this.leftMargin,l=n.top<0&&0==document.body.scrollTop?-n.top:document.body.scrollTop,s=n.left<0&&0==document.body.scrollLeft?-n.left:document.body.scrollLeft,o=l+this.$window.innerHeight,d=s+this.$window.innerWidth;if(this.inputMask.css({position:"absolute",left:this.leftMargin+"px",top:this.topMargin+"px",width:a.width-1+"px",height:a.height-2+"px"}),d<r+360){if(0<d-360)r=d-360;else{r=s;var c=this.$window.innerWidth/360;e.style.transform="scale("+c+")"}e.classList.add("md-datepicker-pos-adjusted")}o<i+368&&l<o-368&&(i=o-368,e.classList.add("md-datepicker-pos-adjusted")),e.style.left=r+"px",e.style.top=i+"px",document.body.appendChild(e),this.$$rAF(function(){e.classList.add("md-pane-open")})},t.prototype.detachCalendarPane=function(){this.$element.removeClass(h),this.mdInputContainer&&this.mdInputContainer.element.removeClass(h),angular.element(document.body).removeClass("md-datepicker-is-showing"),this.calendarPane.classList.remove("md-pane-open"),this.calendarPane.classList.remove("md-datepicker-pos-adjusted"),this.isCalendarOpen&&this.$mdUtil.enableScrolling(),this.calendarPane.parentNode&&this.calendarPane.parentNode.removeChild(this.calendarPane)},t.prototype.openCalendarPane=function(e){if(!this.isCalendarOpen&&!this.isDisabled&&!this.inputFocusedOnWindowBlur){this.isCalendarOpen=this.isOpen=!0,this.calendarPaneOpenedFrom=e.target,this.$mdUtil.disableScrollAround(this.calendarPane),this.attachCalendarPane(),this.focusCalendar(),this.evalAttr("ngFocus");var t=this;this.$mdUtil.nextTick(function(){t.documentElement.on("click touchstart",t.bodyClickHandler)},!1),window.addEventListener(this.windowEventName,this.windowEventHandler)}},t.prototype.closeCalendarPane=function(){if(this.isCalendarOpen){var e=this;e.detachCalendarPane(),e.ngModelCtrl.$setTouched(),e.evalAttr("ngBlur"),e.documentElement.off("click touchstart",e.bodyClickHandler),window.removeEventListener(e.windowEventName,e.windowEventHandler),e.calendarPaneOpenedFrom.focus(),e.calendarPaneOpenedFrom=null,e.openOnFocus?e.$timeout(t):t()}function t(){e.isCalendarOpen=e.isOpen=!1}},t.prototype.getCalendarCtrl=function(){return angular.element(this.calendarPane.querySelector("md-calendar")).controller("mdCalendar")},t.prototype.focusCalendar=function(){var e=this;this.$mdUtil.nextTick(function(){e.getCalendarCtrl().focus()},!1)},t.prototype.setFocused=function(e){e||this.ngModelCtrl.$setTouched(),this.openOnFocus||this.evalAttr(e?"ngFocus":"ngBlur"),this.isFocused=e},t.prototype.handleBodyClick=function(e){this.isCalendarOpen&&(this.$mdUtil.getClosest(e.target,"md-calendar")||this.closeCalendarPane(),this.$scope.$digest())},t.prototype.handleWindowBlur=function(){this.inputFocusedOnWindowBlur=document.activeElement===this.inputElement},t.prototype.evalAttr=function(e){this.$attrs[e]&&this.$scope.$parent.$eval(this.$attrs[e])},t.prototype.setModelValue=function(e){var t=this.$mdUtil.getModelOption(this.ngModelCtrl,"timezone");this.ngModelCtrl.$setViewValue(this.ngDateFilter(e,"yyyy-MM-dd",t))},t.prototype.onExternalChange=function(e){var t=this.$mdUtil.getModelOption(this.ngModelCtrl,"timezone");this.date=e,this.inputElement.value=this.locale.formatDate(e,t),this.mdInputContainer&&this.mdInputContainer.setHasValue(!!e),this.resizeInputElement(),this.updateErrorState()}}(),ngmaterial.components.datepicker=angular.module("material.components.datepicker");