/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.0-master-d099bec
 */
goog.provide("ngmaterial.components.input"),goog.require("ngmaterial.core"),mdInputContainerDirective.$inject=["$mdTheming","$parse","$$rAF"],inputTextareaDirective.$inject=["$mdUtil","$window","$mdAria","$timeout","$mdGesture"],mdMaxlengthDirective.$inject=["$animate","$mdUtil"],placeholderDirective.$inject=["$compile"],ngMessageDirective.$inject=["$mdUtil"],mdSelectOnFocusDirective.$inject=["$document","$timeout"],mdInputInvalidMessagesAnimation.$inject=["$$AnimateRunner","$animateCss","$mdUtil"],ngMessagesAnimation.$inject=["$$AnimateRunner","$animateCss","$mdUtil"],ngMessageAnimation.$inject=["$$AnimateRunner","$animateCss","$mdUtil","$log"];var inputModule=angular.module("material.components.input",["material.core"]).directive("mdInputContainer",mdInputContainerDirective).directive("label",labelDirective).directive("input",inputTextareaDirective).directive("textarea",inputTextareaDirective).directive("mdMaxlength",mdMaxlengthDirective).directive("placeholder",placeholderDirective).directive("ngMessages",ngMessagesDirective).directive("ngMessage",ngMessageDirective).directive("ngMessageExp",ngMessageDirective).directive("mdSelectOnFocus",mdSelectOnFocusDirective).animation(".md-input-invalid",mdInputInvalidMessagesAnimation).animation(".md-input-messages-animation",ngMessagesAnimation).animation(".md-input-message-animation",ngMessageAnimation);function mdInputContainerDirective(a,r,s){t.$inject=["$scope","$element","$attrs","$animate"];var e=["INPUT","TEXTAREA","SELECT","MD-SELECT"],n=e.reduce(function(e,n){return e.concat(["md-icon ~ "+n,".md-icon ~ "+n])},[]).join(","),o=e.reduce(function(e,n){return e.concat([n+" ~ md-icon",n+" ~ .md-icon"])},[]).join(",");return{restrict:"E",compile:function(e){var t=e[0].querySelector(n),i=e[0].querySelector(o);return function(e,n){a(n),(t||i)&&s(function(){var e=n[0].querySelector("md-icon")||n[0].querySelector(".md-icon");t&&e&&n.addClass("md-icon-left"),i&&e&&n.addClass("md-icon-right")})}},controller:t};function t(e,n,t,i){var a=this;n.addClass("md-auto-horizontal-margin"),a.isErrorGetter=t.mdIsError&&r(t.mdIsError),a.delegateClick=function(){a.input.focus()},a.element=n,a.setFocused=function(e){n.toggleClass("md-input-focused",!!e)},a.setHasValue=function(e){n.toggleClass("md-input-has-value",!!e)},a.setHasPlaceholder=function(e){n.toggleClass("md-input-has-placeholder",!!e)},a.setInvalid=function(e){e?i.addClass(n,"md-input-invalid"):i.removeClass(n,"md-input-invalid")},e.$watch(function(){return a.label&&a.input},function(e){e&&!a.label.attr("for")&&a.label.attr("for",a.input.attr("id"))})}}function labelDirective(){return{restrict:"E",require:"^?mdInputContainer",link:function(e,n,t,i){!i||t.mdNoFloat||n.hasClass("md-container-ignore")||(i.label=n,e.$on("$destroy",function(){i.label=null}))}}}function inputTextareaDirective(v,h,$,M,C){return{restrict:"E",require:["^?mdInputContainer","?ngModel","?^form"],link:function(d,c,m,e){var g=e[0],f=!!e[1],p=e[1]||v.fakeNgModel(),n=e[2],t=angular.isDefined(m.readonly),i=v.parseAttributeBoolean(m.mdNoAsterisk),a=c[0].tagName.toLowerCase();if(!g)return;{if("hidden"===m.type)return void c.attr("aria-hidden","true");if(g.input){if(g.input[0].contains(c[0]))return;throw new Error("<md-input-container> can only have *one* <input>, <textarea> or <md-select> child element!")}}g.input=c,g.label&&m.$observe("required",function(e){g.label.toggleClass("md-required",e&&!i)});var r=angular.element('<div class="md-errors-spacer">');c.after(r);var s=angular.isString(m.placeholder)?m.placeholder.trim():"";g.label||s.length||$.expect(c,"aria-label");c.addClass("md-input"),c.attr("id")||c.attr("id","input_"+v.nextUid());"input"===a&&"number"===m.type&&m.min&&m.max&&!m.step?c.attr("step","any"):"textarea"===a&&function(){var n=!m.hasOwnProperty("mdNoAutogrow");if(function(){if(m.hasOwnProperty("mdNoResize"))return;var e=angular.element('<div class="md-resize-handle"></div>'),n=!1,t=0,i=g.element,a=C.register(e,"drag",{horizontal:!1});function r(e){e.preventDefault(),n=!0,e.clientY,t=parseFloat(c.css("height"))||c.prop("offsetHeight")}function s(e){n&&(e.preventDefault(),l(),i.addClass("md-input-resized"))}function o(e){n&&c.css("height",t+e.pointer.distanceY+"px")}function u(e){n&&(n=!1,i.removeClass("md-input-resized"))}c.wrap('<div class="md-resize-wrapper">').after(e),e.on("mousedown",r),i.on("$md.dragstart",s).on("$md.drag",o).on("$md.dragend",u),d.$on("$destroy",function(){e.off("mousedown",r).remove(),i.off("$md.dragstart",s).off("$md.drag",o).off("$md.dragend",u),a(),a=i=e=null})}(),!n)return;var i=m.hasOwnProperty("rows")?parseInt(m.rows):NaN,a=m.hasOwnProperty("maxRows")?parseInt(m.maxRows):NaN,t=d.$on("md-resize-textarea",o),r=null,s=c[0];M(function(){v.nextTick(o)},10,!1),c.on("input",o),f&&p.$formatters.push(u);i||c.attr("rows",1);function o(){c.attr("rows",1).css("height","auto").addClass("md-no-flex");var e=function(){var e=s.offsetHeight,n=s.scrollHeight-e;return e+Math.max(n,0)}();if(!r){var n=c[0].style.padding||"";r=c.css("padding",0).prop("offsetHeight"),c[0].style.padding=n}if(i&&r&&(e=Math.max(e,r*i)),a&&r){var t=r*a;t<e?(c.attr("md-no-autogrow",""),e=t):c.removeAttr("md-no-autogrow")}r&&c.attr("rows",Math.round(e/r)),c.css("height",e+"px").removeClass("md-no-flex")}function u(e){return v.nextTick(o),e}function l(){if(n&&(n=!1,angular.element(h).off("resize",o),t&&t(),c.attr("md-no-autogrow","").off("input",o),f)){var e=p.$formatters.indexOf(u);-1<e&&p.$formatters.splice(e,1)}}if(angular.element(h).on("resize",o),d.$on("$destroy",l),m.hasOwnProperty("mdDetectHidden")){var e=function(){var n=!1;return function(){var e=0===s.offsetHeight;!1==e&&!0===n&&o(),n=e}}();d.$watch(function(){return v.nextTick(e,!1),!0})}}();f||l();var o=g.isErrorGetter||function(){return p.$invalid&&(p.$touched||n&&n.$submitted)};d.$watch(o,g.setInvalid),m.ngValue&&m.$observe("value",l);p.$parsers.push(u),p.$formatters.push(u),c.on("input",l),t||c.on("focus",function(e){v.nextTick(function(){g.setFocused(!0)})}).on("blur",function(e){v.nextTick(function(){g.setFocused(!1),l()})});function u(e){return g.setHasValue(!p.$isEmpty(e)),e}function l(){g.setHasValue(0<c.val().length||(c[0].validity||{}).badInput)}d.$on("$destroy",function(){g.setFocused(!1),g.setHasValue(!1),g.input=null})}}}function mdMaxlengthDirective(g,f){return{restrict:"A",require:["ngModel","^mdInputContainer"],link:function(e,i,n,t){var a=parseInt(n.mdMaxlength);isNaN(a)&&(a=-1);var r,s,o=t[0],u=t[1],l=!angular.isDefined(n.ngTrim)||f.parseAttributeBoolean(n.ngTrim),d="password"===n.type;function c(e){return null==(e=l&&!d&&angular.isString(e)?e.trim():e)&&(e=""),String(e).length}function m(){r&&r.parent()&&r.text(c(i.val())+" / "+a)}e.$watch(n.mdMaxlength,function(e){a=e}),o.$validators["md-maxlength"]=function(e,n){if(!angular.isNumber(a)||a<0)return!0;m();var t=i.val()||n;return null==t&&(t=""),t=l&&!d&&angular.isString(t)?t.trim():t,String(t).length<=a},o.$isEmpty=function(e){return 0===c(e)},f.nextTick(function(){s=angular.element(u.element[0].querySelector(".md-errors-spacer")),r=angular.element('<div class="md-char-counter">'),s.append(r),n.$observe("ngTrim",function(e){l=!angular.isDefined(e)||f.parseAttributeBoolean(e)}),e.$watch(n.mdMaxlength,function(e){angular.isNumber(e)&&0<e?(r.parent().length||g.enter(r,s),m()):g.leave(r)})})}}}function placeholderDirective(o){return{restrict:"A",require:"^^?mdInputContainer",priority:200,link:{pre:function(e,n,t,i){if(!i)return;var a=i.element.find("label"),r=i.element.attr("md-no-float");if(a&&a.length||""===r||e.$eval(r))return void i.setHasPlaceholder(!0);if("MD-SELECT"!==n[0].nodeName){var s=angular.element('<label ng-click="delegateClick()" tabindex="-1" aria-hidden="true">'+t.placeholder+"</label>");t.$set("placeholder",null),i.element.addClass("md-icon-float").prepend(s),o(s)(e)}}}}}function mdSelectOnFocusDirective(s,o){return{restrict:"A",link:function(e,n,t){if("INPUT"!==n[0].nodeName&&"TEXTAREA"!==n[0].nodeName)return;var i=!1;function a(){o(function(){s[0].activeElement===n[0]&&n[0].select(),i=!1},1,!(i=!0))}function r(e){i&&e.preventDefault()}n.on("focus",a).on("mouseup",r),e.$on("$destroy",function(){n.off("focus",a).off("mouseup",r)})}}}window._mdMocksIncluded&&inputModule.service("$$mdInput",function(){return{messages:{getElement:getMessagesElement}}}).service("mdInputInvalidAnimation",mdInputInvalidMessagesAnimation).service("mdInputMessagesAnimation",ngMessagesAnimation).service("mdInputMessageAnimation",ngMessageAnimation);var $$AnimateRunner,$animateCss,$mdUtil,visibilityDirectives=["ngIf","ngShow","ngHide","ngSwitchWhen","ngSwitchDefault"];function ngMessagesDirective(){return{restrict:"EA",link:function(e,n,t,i){if(!i)return;n.toggleClass("md-input-messages-animation",!0),n.toggleClass("md-auto-hide",!0),"false"!=t.mdAutoHide&&!function(n){return visibilityDirectives.some(function(e){return n[e]})}(t)||n.toggleClass("md-auto-hide",!1)},require:"^^?mdInputContainer"}}function ngMessageDirective(n){return{restrict:"EA",compile:function(t){if(i(t))a(t);else if(function(){var e=t[0];for(;e=e.parentNode;)if(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE)return!0;return!1}())return function(e,n){i(n)&&a(t)};function i(e){return!!n.getClosest(e,"md-input-container")}function a(e){e.toggleClass("md-input-message-animation",!0)}},priority:100}}function mdInputInvalidMessagesAnimation(e,n,t){return saveSharedServices(e,n,t),{addClass:function(e,n,t){showInputMessages(e,t)}}}function ngMessagesAnimation(e,n,t){return saveSharedServices(e,n,t),{enter:function(e,n){showInputMessages(e,n)},leave:function(e,n){hideInputMessages(e,n)},addClass:function(e,n,t){"ng-hide"==n?hideInputMessages(e,t):t()},removeClass:function(e,n,t){"ng-hide"==n?showInputMessages(e,t):t()}}}function ngMessageAnimation(e,n,t,i){return saveSharedServices(e,n,t,i),{enter:function(e,n){showMessage(e).start().done(n)},leave:function(e,n){hideMessage(e).start().done(n)}}}function showInputMessages(e,n){var t,i=[],a=getMessagesElement(e),r=a.children();0!=a.length&&0!=r.length?(angular.forEach(r,function(e){t=showMessage(angular.element(e)),i.push(t.start())}),$$AnimateRunner.all(i,n)):n()}function hideInputMessages(e,n){var t,i=[],a=getMessagesElement(e),r=a.children();0!=a.length&&0!=r.length?(angular.forEach(r,function(e){t=hideMessage(angular.element(e)),i.push(t.start())}),$$AnimateRunner.all(i,n)):n()}function showMessage(e){var n=parseInt(window.getComputedStyle(e[0]).height),t=parseInt(window.getComputedStyle(e[0]).marginTop),i=getMessagesElement(e),a=getInputElement(e);return-n<t||i.hasClass("md-auto-hide")&&!a.hasClass("md-input-invalid")?$animateCss(e,{}):$animateCss(e,{event:"enter",structural:!0,from:{opacity:0,"margin-top":-n+"px"},to:{opacity:1,"margin-top":"0"},duration:.3})}function hideMessage(e){var n=e[0].offsetHeight,t=window.getComputedStyle(e[0]);return 0===parseInt(t.opacity)?$animateCss(e,{}):$animateCss(e,{event:"leave",structural:!0,from:{opacity:1,"margin-top":0},to:{opacity:0,"margin-top":-n+"px"},duration:.3})}function getInputElement(e){return e.controller("mdInputContainer").element}function getMessagesElement(e){return e.hasClass("md-input-messages-animation")?e:e.hasClass("md-input-message-animation")?angular.element($mdUtil.getClosest(e,function(e){return e.classList.contains("md-input-messages-animation")})):angular.element(e[0].querySelector(".md-input-messages-animation"))}function saveSharedServices(e,n,t){$$AnimateRunner=e,$animateCss=n,$mdUtil=t}ngmaterial.components.input=angular.module("material.components.input");