/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.0-master-d099bec
 */
!function(n,h){"use strict";function t(t,e,i,n,s){this.$scope=t,this.$element=e,this.$mdConstant=i,this.$timeout=n,this.$mdUtil=s,this.isEditing=!1,this.parentController=void 0,this.enableChipEdit=!1}function e(p,t,e,a){return{restrict:"E",require:["^?mdChips","mdChip"],link:function(t,e,i,n){var s=n.shift(),o=n.shift(),r=h.element(e[0].querySelector(".md-chip-content"));p(e),s&&(o.init(s),r.on("blur",function(){s.resetSelectedChip(),s.$scope.$applyAsync()}));a(function(){s&&s.shouldFocusLastChip&&s.focusLastChipThenInput()})},controller:"MdChipCtrl"}}function i(s){return{restrict:"A",require:"^mdChips",scope:!1,link:function(t,e,i,n){e.on("click",function(){t.$apply(function(){n.removeChip(t.$$replacedScope.$index)})}),s(function(){e.attr({tabindex:"-1","aria-hidden":"true"}),e.find("button").attr("tabindex","-1")})}}}function s(r){return{restrict:"EA",terminal:!0,link:function(t,e,i){var n=t.$parent.$mdChipsCtrl,s=n.parent.$new(!1,n.parent);s.$$replacedScope=t,s.$chip=t.$chip,s.$index=t.$index;var o=(s.$mdChipsCtrl=n).$scope.$eval(i.mdChipTransclude);e.html(o),r(e.contents())(s)},scope:!1}}h.module("material.components.chips",["material.core","material.components.autocomplete"]),t.$inject=["$scope","$element","$mdConstant","$timeout","$mdUtil"],h.module("material.components.chips").controller("MdChipCtrl",t),t.prototype.init=function(t){this.parentController=t,this.enableChipEdit=this.parentController.enableChipEdit,this.enableChipEdit&&(this.$element.on("keydown",this.chipKeyDown.bind(this)),this.$element.on("dblclick",this.chipMouseDoubleClick.bind(this)),this.getChipContent().addClass("_md-chip-content-edit-is-enabled"))},t.prototype.getChipContent=function(){var t=this.$element[0].getElementsByClassName("md-chip-content");return h.element(t[0])},t.prototype.getContentElement=function(){var t=h.element(this.getChipContent().children()[0]);return t&&0!==t.length||(t=h.element(this.getChipContent().contents()[0])),t},t.prototype.getChipIndex=function(){return parseInt(this.$element.attr("index"))},t.prototype.goOutOfEditMode=function(){if(this.isEditing){this.isEditing=!1,this.$element.removeClass("_md-chip-editing"),this.getChipContent()[0].contentEditable="false";var t=this.getChipIndex(),e=this.getContentElement().text();e?(this.parentController.updateChipContents(t,e),this.$mdUtil.nextTick(function(){this.parentController.selectedChip===t&&this.parentController.focusChip(t)}.bind(this))):this.parentController.removeChipAndFocusInput(t)}},t.prototype.selectNodeContents=function(t){var e,i;document.body.createTextRange?((e=document.body.createTextRange()).moveToElementText(t),e.select()):n.getSelection&&(i=n.getSelection(),(e=document.createRange()).selectNodeContents(t),i.removeAllRanges(),i.addRange(e))},t.prototype.goInEditMode=function(){this.isEditing=!0,this.$element.addClass("_md-chip-editing"),this.getChipContent()[0].contentEditable="true",this.getChipContent().on("blur",function(){this.goOutOfEditMode()}.bind(this)),this.selectNodeContents(this.getChipContent()[0])},t.prototype.chipKeyDown=function(t){this.isEditing||t.keyCode!==this.$mdConstant.KEY_CODE.ENTER&&t.keyCode!==this.$mdConstant.KEY_CODE.SPACE?this.isEditing&&t.keyCode===this.$mdConstant.KEY_CODE.ENTER&&(t.preventDefault(),this.goOutOfEditMode()):(t.preventDefault(),this.goInEditMode())},t.prototype.chipMouseDoubleClick=function(){this.enableChipEdit&&!this.isEditing&&this.goInEditMode()},e.$inject=["$mdTheming","$mdUtil","$compile","$timeout"],h.module("material.components.chips").directive("mdChip",e),i.$inject=["$timeout"],h.module("material.components.chips").directive("mdChipRemove",i),s.$inject=["$compile"],h.module("material.components.chips").directive("mdChipTransclude",s),o.$inject=["$scope","$attrs","$mdConstant","$log","$element","$timeout","$mdUtil","$mdLiveAnnouncer","$exceptionHandler"];var l=300;function o(t,e,i,n,s,o,r,p,a){this.$timeout=o,this.$mdConstant=i,this.$scope=t,this.parent=t.$parent,this.$mdUtil=r,this.$log=n,this.$mdLiveAnnouncer=p,this.$exceptionHandler=a,this.$element=s,this.$attrs=e,this.ngModelCtrl=null,this.userInputNgModelCtrl=null,this.autocompleteCtrl=null,this.userInputElement=null,this.items=[],this.selectedChip=-1,this.enableChipEdit=r.parseAttributeBoolean(e.mdEnableChipEdit),this.addOnBlur=r.parseAttributeBoolean(e.mdAddOnBlur),this.inputClass="",this.inputAriaLabel="Chips input.",this.containerHint="Chips container. Use arrow keys to select chips.",this.containerEmptyHint="Chips container. Enter the text area, then type text, and press enter to add a chip.",this.deleteHint="Press delete to remove this chip.",this.deleteButtonLabel="Remove",this.chipBuffer="",this.useTransformChip=!1,this.useOnAdd=!1,this.useOnRemove=!1,this.wrapperId="",this.contentIds=[],this.ariaTabIndex=null,this.chipAppendDelay=l,this.deRegister=[],this.addedMessage="added",this.removedMessage="removed",this.init()}h.module("material.components.chips").controller("MdChipsCtrl",o),o.prototype.init=function(){var e=this;this.wrapperId="_md-chips-wrapper-"+this.$mdUtil.nextUid(),this.$element.attr("ng-model")||this.setupStaticChips(),this.deRegister.push(this.$scope.$watchCollection("$mdChipsCtrl.items",function(){e.setupInputAria(),e.setupWrapperAria()})),this.deRegister.push(this.$attrs.$observe("mdChipAppendDelay",function(t){e.chipAppendDelay=parseInt(t)||l}))},o.prototype.$onDestroy=function(){for(var t;t=this.deRegister.pop();)t.call(this)},o.prototype.setupInputAria=function(){var t=this.$element.find("input");t&&(t.attr("role","textbox"),t.attr("aria-multiline",!0),this.inputAriaDescribedBy&&t.attr("aria-describedby",this.inputAriaDescribedBy),this.inputAriaLabelledBy?(t.attr("aria-labelledby",this.inputAriaLabelledBy),t.removeAttr("aria-label")):t.attr("aria-label",this.inputAriaLabel))},o.prototype.setupWrapperAria=function(){var t=this,e=this.$element.find("md-chips-wrap");this.items&&this.items.length?(e.attr("role","listbox"),this.contentIds=this.items.map(function(){return t.wrapperId+"-chip-"+t.$mdUtil.nextUid()}),e.attr("aria-owns",this.contentIds.join(" ")),e.attr("aria-label",this.containerHint)):(e.removeAttr("role"),e.removeAttr("aria-owns"),e.attr("aria-label",this.containerEmptyHint))},o.prototype.setupStaticChips=function(){var t,e,i=this,n=this.$element.find("md-chips-wrap");this.$timeout(function(){for(n.attr("role","list"),e=n[0].children,t=0;t<e.length;t++)e[t].setAttribute("role","listitem"),e[t].setAttribute("aria-setsize",e.length);i.inputAriaDescribedBy&&n.attr("aria-describedby",i.inputAriaDescribedBy),i.inputAriaLabelledBy?(n.attr("aria-labelledby",i.inputAriaLabelledBy),n.removeAttr("aria-label")):n.attr("aria-label",i.inputAriaLabel)},10)},o.prototype.inputKeydown=function(t){var e=this.getChipBuffer();if(!(this.autocompleteCtrl&&t.isDefaultPrevented&&t.isDefaultPrevented())){if(t.keyCode===this.$mdConstant.KEY_CODE.BACKSPACE){if(0!==this.getCursorPosition(t.target))return;return t.preventDefault(),t.stopPropagation(),void(this.items.length&&this.selectAndFocusChipSafe(this.items.length-1))}if((!this.separatorKeys||this.separatorKeys.length<1)&&(this.separatorKeys=[this.$mdConstant.KEY_CODE.ENTER]),-1!==this.separatorKeys.indexOf(t.keyCode)){if(this.autocompleteCtrl&&this.requireMatch||!e)return;if(t.preventDefault(),this.hasMaxChipsReached())return;return this.appendChip(e.trim()),this.resetChipBuffer(),!1}}},o.prototype.getCursorPosition=function(e){try{if(e.selectionStart===e.selectionEnd)return e.selectionStart}catch(t){if(!e.value)return 0}},o.prototype.updateChipContents=function(t,e){0<=t&&t<this.items.length&&(this.items[t]=e,this.updateNgModel(!0))},o.prototype.isEditingChip=function(){return!!this.$element[0].querySelector("._md-chip-editing")},o.prototype._isChipObject=function(t){return h.isObject(t)},o.prototype.isRemovable=function(){return!!this.ngModelCtrl&&(this.readonly?this.removable:!h.isDefined(this.removable)||this.removable)},o.prototype.chipKeydown=function(t){if(!this.getChipBuffer()&&!this.isEditingChip())switch(t.keyCode){case this.$mdConstant.KEY_CODE.BACKSPACE:case this.$mdConstant.KEY_CODE.DELETE:if(this.selectedChip<0)return;if(t.preventDefault(),!this.isRemovable())return;this.removeAndSelectAdjacentChip(this.selectedChip,t);break;case this.$mdConstant.KEY_CODE.LEFT_ARROW:t.preventDefault(),(this.selectedChip<0||this.readonly&&0===this.selectedChip)&&(this.selectedChip=this.items.length),this.items.length&&this.selectAndFocusChipSafe(this.selectedChip-1);break;case this.$mdConstant.KEY_CODE.RIGHT_ARROW:t.preventDefault(),this.selectAndFocusChipSafe(this.selectedChip+1);break;case this.$mdConstant.KEY_CODE.ESCAPE:case this.$mdConstant.KEY_CODE.TAB:if(this.selectedChip<0)return;t.preventDefault(),this.onFocus()}},o.prototype.getPlaceholder=function(){return this.items&&this.items.length&&(""===this.secondaryPlaceholder||this.secondaryPlaceholder)?this.secondaryPlaceholder:this.placeholder},o.prototype.removeAndSelectAdjacentChip=function(t,e){var i=this,n=i.getAdjacentChipIndex(t);this.$element[0].querySelector("md-chips-wrap"),this.$element[0].querySelector('md-chip[index="'+t+'"]');i.removeChip(t,e),i.$timeout(function(){i.$timeout(function(){i.selectAndFocusChipSafe(n)})})},o.prototype.resetSelectedChip=function(){this.selectedChip=-1,this.ariaTabIndex=null},o.prototype.getAdjacentChipIndex=function(t){var e=this.items.length-1;return 0==e?-1:t===e?t-1:t},o.prototype.appendChip=function(e){if(this.shouldFocusLastChip=!this.addOnBlur,this.useTransformChip&&this.transformChip){var t=this.transformChip({$chip:e});h.isDefined(t)&&(e=t)}if(h.isObject(e)&&this.items.some(function(t){return h.equals(e,t)}))return;if(!(null==e||this.items.indexOf(e)+1)){var i=this.items.push(e)-1;this.updateNgModel();var n=h.isObject(e)?"":e;this.$mdLiveAnnouncer.announce(n+" "+this.addedMessage,"assertive"),this.useOnAdd&&this.onAdd&&this.onAdd({$chip:e,$index:i})}},o.prototype.useTransformChipExpression=function(){this.useTransformChip=!0},o.prototype.useOnAddExpression=function(){this.useOnAdd=!0},o.prototype.useOnRemoveExpression=function(){this.useOnRemove=!0},o.prototype.useOnSelectExpression=function(){this.useOnSelect=!0},o.prototype.getChipBuffer=function(){var t=this.userInputElement?this.userInputNgModelCtrl?this.userInputNgModelCtrl.$viewValue:this.userInputElement[0].value:this.chipBuffer;return h.isString(t)?t:""},o.prototype.resetChipBuffer=function(){this.userInputElement?this.userInputNgModelCtrl?(this.userInputNgModelCtrl.$setViewValue(""),this.userInputNgModelCtrl.$render()):this.userInputElement[0].value="":this.chipBuffer=""},o.prototype.hasMaxChipsReached=function(){return h.isString(this.maxChips)&&(this.maxChips=parseInt(this.maxChips,10)||0),0<this.maxChips&&this.items.length>=this.maxChips},o.prototype.validateModel=function(){this.ngModelCtrl.$setValidity("md-max-chips",!this.hasMaxChipsReached()),this.ngModelCtrl.$validate()},o.prototype.updateNgModel=function(t){t||this.validateModel(),h.forEach(this.ngModelCtrl.$viewChangeListeners,function(t){try{t()}catch(t){this.$exceptionHandler(t)}})},o.prototype.removeChip=function(t,e){var i=this.items.splice(t,1);this.updateNgModel(),this.ngModelCtrl.$setDirty();var n=h.isObject(i[0])?"":i[0];this.$mdLiveAnnouncer.announce(n+" "+this.removedMessage,"assertive"),i&&i.length&&this.useOnRemove&&this.onRemove&&this.onRemove({$chip:i[0],$index:t,$event:e})},o.prototype.removeChipAndFocusInput=function(t,e){this.removeChip(t,e),this.autocompleteCtrl?(this.autocompleteCtrl.hidden=!0,this.$mdUtil.nextTick(this.onFocus.bind(this))):this.onFocus()},o.prototype.selectAndFocusChipSafe=function(t){if(!this.items.length||-1===t)return this.focusInput();if(t>=this.items.length){if(!this.readonly)return this.onFocus();t=0}t=Math.max(t,0),t=Math.min(t,this.items.length-1),this.selectChip(t),this.focusChip(t)},o.prototype.focusLastChipThenInput=function(){var t=this;t.shouldFocusLastChip=!1,t.focusChip(this.items.length-1),t.$timeout(function(){t.focusInput()},t.chipAppendDelay)},o.prototype.focusInput=function(){this.selectChip(-1),this.onFocus()},o.prototype.selectChip=function(t){-1<=t&&t<=this.items.length?(this.selectedChip=t,this.useOnSelect&&this.onSelect&&this.onSelect({$chip:this.items[t]})):this.$log.warn("Selected Chip index out of bounds; ignoring.")},o.prototype.focusChip=function(t){var e=this.$element[0].querySelector('md-chip[index="'+t+'"] .md-chip-content');this.ariaTabIndex=t,e.focus()},o.prototype.configureNgModel=function(t){this.ngModelCtrl=t;var e=this;t.$isEmpty=function(t){return!t||0===t.length},t.$render=function(){e.items=e.ngModelCtrl.$viewValue}},o.prototype.onFocus=function(){var t=this.$element[0].querySelector("input");t&&t.focus(),this.resetSelectedChip()},o.prototype.onInputFocus=function(){this.inputHasFocus=!0,this.setupInputAria(),this.resetSelectedChip()},o.prototype.onInputBlur=function(){this.inputHasFocus=!1,this.shouldAddOnBlur()&&(this.appendChip(this.getChipBuffer().trim()),this.resetChipBuffer())},o.prototype.configureInput=function(t){var e=t.controller("ngModel"),i=this;e&&(this.deRegister.push(this.$scope.$watch(function(){return e.$touched},function(t){t&&i.ngModelCtrl.$setTouched()})),this.deRegister.push(this.$scope.$watch(function(){return e.$dirty},function(t){t&&i.ngModelCtrl.$setDirty()})))},o.prototype.configureUserInput=function(t){var e=(this.userInputElement=t).controller("ngModel");e!==this.ngModelCtrl&&(this.userInputNgModelCtrl=e);function i(t,e){n.$evalAsync(h.bind(s,e,t))}var n=this.$scope,s=this;t.attr({tabindex:0}).on("keydown",function(t){i(t,s.inputKeydown)}).on("focus",function(t){i(t,s.onInputFocus)}).on("blur",function(t){i(t,s.onInputBlur)})},o.prototype.configureAutocomplete=function(t){t&&(this.autocompleteCtrl=t,this.$element.attr("container-empty-hint")||(this.containerEmptyHint="Chips container with autocompletion. Enter the text area, type text to search, and then use the up and down arrow keys to select an option. Press enter to add the selected option as a chip.",this.setupWrapperAria()),t.registerSelectedItemWatcher(h.bind(this,function(t){if(t){if(this.hasMaxChipsReached())return;this.appendChip(t),this.resetChipBuffer()}})),this.$element.find("input").on("focus",h.bind(this,this.onInputFocus)).on("blur",h.bind(this,this.onInputBlur)))},o.prototype.shouldAddOnBlur=function(){this.validateModel();var t=this.getChipBuffer().trim(),e=this.ngModelCtrl.$isEmpty(this.ngModelCtrl.$modelValue)||this.ngModelCtrl.$valid,i=this.autocompleteCtrl&&!this.autocompleteCtrl.hidden;return this.userInputNgModelCtrl&&(e=e&&this.userInputNgModelCtrl.$valid),this.addOnBlur&&!this.requireMatch&&t&&e&&!i},o.prototype.hasFocus=function(){return this.inputHasFocus||0<=this.selectedChip},o.prototype.contentIdFor=function(t){return this.contentIds[t]},c.$inject=["$mdTheming","$mdUtil","$compile","$log","$timeout","$$mdSvgRegistry"],h.module("material.components.chips").directive("mdChips",c);var r='      <md-chips-wrap          id="{{$mdChipsCtrl.wrapperId}}"          tabindex="{{$mdChipsCtrl.readonly ? 0 : -1}}"          ng-keydown="$mdChipsCtrl.chipKeydown($event)"          ng-class="{ \'md-focused\': $mdChipsCtrl.hasFocus(),                       \'md-readonly\': !$mdChipsCtrl.ngModelCtrl || $mdChipsCtrl.readonly,                      \'md-removable\': $mdChipsCtrl.isRemovable() }"          class="md-chips">        <md-chip ng-repeat="$chip in $mdChipsCtrl.items"            index="{{$index}}"             ng-class="{\'md-focused\': $mdChipsCtrl.selectedChip == $index, \'md-readonly\': !$mdChipsCtrl.ngModelCtrl || $mdChipsCtrl.readonly}">          <div class="md-chip-content"              tabindex="{{$mdChipsCtrl.ariaTabIndex === $index ? 0 : -1}}"              id="{{$mdChipsCtrl.contentIdFor($index)}}"              role="option"              aria-selected="{{$mdChipsCtrl.selectedChip === $index}}"              aria-setsize="{{$mdChipsCtrl.items.length}}"              aria-posinset="{{$index+1}}"              ng-click="!$mdChipsCtrl.readonly && $mdChipsCtrl.focusChip($index)"              aria-label="{{$mdChipsCtrl._isChipObject($chip) ? \'\' : $chip + \'. \'}}{{$mdChipsCtrl.isRemovable() ? \'\' + $mdChipsCtrl.deleteHint : \'\'}}"               ng-focus="!$mdChipsCtrl.readonly && $mdChipsCtrl.selectChip($index)"              md-chip-transclude="$mdChipsCtrl.chipContentsTemplate"></div>          <div ng-if="$mdChipsCtrl.isRemovable()"               class="md-chip-remove-container"               tabindex="-1"               md-chip-transclude="$mdChipsCtrl.chipRemoveTemplate"></div>        </md-chip>        <div class="md-chip-input-container" ng-if="!$mdChipsCtrl.readonly && $mdChipsCtrl.ngModelCtrl">          <div md-chip-transclude="$mdChipsCtrl.chipInputTemplate"></div>        </div>      </md-chips-wrap>',p='        <input            class="md-input{{ $mdChipsCtrl.inputClass ? \' \' + $mdChipsCtrl.inputClass: \'\'}}"            tabindex="0"            aria-label="{{$mdChipsCtrl.inputAriaLabel}}"            placeholder="{{$mdChipsCtrl.getPlaceholder()}}"            ng-model="$mdChipsCtrl.chipBuffer"            ng-focus="$mdChipsCtrl.onInputFocus()"            ng-blur="$mdChipsCtrl.onInputBlur()"            ng-keydown="$mdChipsCtrl.inputKeydown($event)">',a="      <span>{{$chip}}</span>",d='      <button          class="md-chip-remove"          ng-if="$mdChipsCtrl.isRemovable()"          ng-click="$mdChipsCtrl.removeChipAndFocusInput($$replacedScope.$index, $event)"          type="button"          tabindex="-1"          aria-label="{{$mdChipsCtrl.deleteButtonLabel}}{{$mdChipsCtrl._isChipObject($chip) ? \'\' : \' \' + $chip}}">        <md-icon md-svg-src="{{$mdChipsCtrl.mdCloseIcon}}" aria-hidden="true"></md-icon>      </button>';function c(c,m,u,n,C,$){var f={chips:m.processTemplate(r),input:m.processTemplate(p),default:m.processTemplate(a),remove:m.processTemplate(d)};return{template:function(t,e){return e.$mdUserTemplate=t.clone(),f.chips},require:["mdChips"],restrict:"E",controller:"MdChipsCtrl",controllerAs:"$mdChipsCtrl",bindToController:!0,compile:function(t,r){var i=r.$mdUserTemplate;r.$mdUserTemplate=null;var p=e("md-chips>md-chip-template"),a=e(m.prefixer().buildList("md-chip-remove").map(function(t){return"md-chips>*["+t+"]"}).join(","))||f.remove,h=p||f.default,l=e("md-chips>md-autocomplete")||e("md-chips>input")||f.input,d=i.find("md-chip");i[0].querySelector("md-chip-template>*[md-chip-remove]")&&n.warn("invalid placement of md-chip-remove within md-chip-template.");function e(t){if(r.ngModel){var e=i[0].querySelector(t);return e&&e.outerHTML}}return function(t,e,i,n){m.initOptionalProperties(t,r),c(e);var s=n[0];if(p&&(s.enableChipEdit=!1),s.chipContentsTemplate=h,s.chipRemoveTemplate=a,s.chipInputTemplate=l,s.mdCloseIcon=$.mdCancel,e.attr({tabindex:-1}).on("focus",function(){s.onFocus()}).on("click",function(){s.readonly||-1!==s.selectedChip||s.onFocus()}),r.ngModel&&(s.configureNgModel(e.controller("ngModel")),i.mdTransformChip&&s.useTransformChipExpression(),i.mdOnAdd&&s.useOnAddExpression(),i.mdOnRemove&&s.useOnRemoveExpression(),i.mdOnSelect&&s.useOnSelectExpression(),l!==f.input&&t.$watch("$mdChipsCtrl.readonly",function(t){t||m.nextTick(function(){if(0===l.indexOf("<md-autocomplete")){var t=e.find("md-autocomplete");s.configureAutocomplete(t.controller("mdAutocomplete"))}s.configureUserInput(e.find("input"))})}),m.nextTick(function(){var t=e.find("input");t&&(s.configureInput(t),t.toggleClass("md-input",!0))})),0<d.length){var o=u(d.clone())(t.$parent);C(function(){e.find("md-chips-wrap").prepend(o)})}}},scope:{readonly:"=?readonly",removable:"=?mdRemovable",placeholder:"@?",secondaryPlaceholder:"@?",maxChips:"@?mdMaxChips",transformChip:"&mdTransformChip",onAdd:"&?mdOnAdd",onRemove:"&?mdOnRemove",addedMessage:"@?mdAddedMessage",removedMessage:"@?mdRemovedMessage",onSelect:"&?mdOnSelect",inputClass:"@?mdInputClass",inputAriaDescribedBy:"@?inputAriaDescribedby",inputAriaLabelledBy:"@?inputAriaLabelledby",inputAriaLabel:"@?",containerHint:"@?",containerEmptyHint:"@?",deleteHint:"@?",deleteButtonLabel:"@?",separatorKeys:"=?mdSeparatorKeys",requireMatch:"=?mdRequireMatch",chipAppendDelayString:"@?mdChipAppendDelay",ngChange:"&?"}}}function m(t,e,i){this.$element=e,this.$attrs=t,this.$timeout=i,this.selectedItem=null,this.searchText="",this.deRegister=[],this.init()}m.$inject=["$attrs","$element","$timeout"],h.module("material.components.chips").controller("MdContactChipsCtrl",m),m.prototype.init=function(){var t=this,e=this.deRegister,i=this.$element;this.$timeout(function(){e.push(i.find("md-chips").controller("mdChips").$scope.$watchCollection("$mdChipsCtrl.items",function(){t.setupChipsAria(),t.setupAutocompleteAria()}))})},m.prototype.setupChipsAria=function(){var t=this.$element.find("md-chips"),e=t.controller("mdChips");this.removedMessage&&(e.removedMessage=this.removedMessage),this.containerHint&&(e.containerHint=this.containerHint),this.containerEmptyHint&&(t.attr("container-empty-hint",this.containerEmptyHint),e.containerEmptyHint=this.containerEmptyHint),this.deleteHint&&(e.deleteHint=this.deleteHint),this.inputAriaLabel&&(e.inputAriaLabel=this.inputAriaLabel),this.inputClass&&(e.inputClass=this.inputClass)},m.prototype.setupAutocompleteAria=function(){var t=this.$element.find("md-chips-wrap").find("md-autocomplete").find("input");this.inputAriaDescribedBy&&t.attr("aria-describedby",this.inputAriaDescribedBy),this.inputAriaLabelledBy&&(t.removeAttr("aria-label"),t.attr("aria-labelledby",this.inputAriaLabelledBy))},m.prototype.queryContact=function(t){return this.contactQuery({$query:t})},m.prototype.inputKeydown=function(t){if(this.separatorKeys&&!(this.separatorKeys.indexOf(t.keyCode)<0)){t.stopPropagation(),t.preventDefault();var e=h.element(t.target).controller("mdAutocomplete");e.select(e.index)}},m.prototype.itemName=function(t){return t[this.contactName]},m.prototype.$onDestroy=function(){for(var t;t=this.deRegister.pop();)t.call(this)},C.$inject=["$mdTheming","$mdUtil"],h.module("material.components.chips").directive("mdContactChips",C);var u='      <md-chips class="md-contact-chips"          ng-model="$mdContactChipsCtrl.contacts"          ng-change="$mdContactChipsCtrl.ngChange($mdContactChipsCtrl.contacts)"          md-require-match="$mdContactChipsCtrl.requireMatch"          md-chip-append-delay="{{$mdContactChipsCtrl.chipAppendDelay}}"          md-separator-keys="$mdContactChipsCtrl.separatorKeys"          md-autocomplete-snap>          <md-autocomplete              md-menu-class="md-contact-chips-suggestions"              md-selected-item="$mdContactChipsCtrl.selectedItem"              md-search-text="$mdContactChipsCtrl.searchText"              md-items="item in $mdContactChipsCtrl.queryContact($mdContactChipsCtrl.searchText)"              md-item-text="$mdContactChipsCtrl.itemName(item)"              md-no-cache="true"              md-min-length="$mdContactChipsCtrl.minLength"              md-autoselect              ng-attr-md-input-class="{{$mdContactChipsCtrl.inputClass}}"              ng-keydown="$mdContactChipsCtrl.inputKeydown($event)"              placeholder="{{$mdContactChipsCtrl.contacts.length === 0 ?                  $mdContactChipsCtrl.placeholder : $mdContactChipsCtrl.secondaryPlaceholder}}">            <div class="md-contact-suggestion">              <img                   ng-src="{{item[$mdContactChipsCtrl.contactImage]}}"                  alt="{{item[$mdContactChipsCtrl.contactName]}}"                  ng-if="item[$mdContactChipsCtrl.contactImage]" />              <span class="md-contact-name" md-highlight-text="$mdContactChipsCtrl.searchText"                    md-highlight-flags="{{$mdContactChipsCtrl.highlightFlags}}">                {{item[$mdContactChipsCtrl.contactName]}}              </span>              <span class="md-contact-email" >{{item[$mdContactChipsCtrl.contactEmail]}}</span>            </div>          </md-autocomplete>          <md-chip-template>            <div class="md-contact-avatar">              <img                   ng-src="{{$chip[$mdContactChipsCtrl.contactImage]}}"                  alt="{{$chip[$mdContactChipsCtrl.contactName]}}"                  ng-if="$chip[$mdContactChipsCtrl.contactImage]" />            </div>            <div class="md-contact-name">              {{$chip[$mdContactChipsCtrl.contactName]}}            </div>          </md-chip-template>      </md-chips>';function C(r,p){return{template:function(t,e){return u},restrict:"E",controller:"MdContactChipsCtrl",controllerAs:"$mdContactChipsCtrl",bindToController:!0,compile:function(t,o){return function(t,e,i,n){var s=n;p.initOptionalProperties(t,o),r(e),e.attr("tabindex","-1"),i.$observe("mdChipAppendDelay",function(t){s.chipAppendDelay=t})}},scope:{contactQuery:"&mdContacts",placeholder:"@?",secondaryPlaceholder:"@?",contactName:"@mdContactName",contactImage:"@mdContactImage",contactEmail:"@mdContactEmail",contacts:"=ngModel",ngChange:"&?",requireMatch:"=?mdRequireMatch",minLength:"=?mdMinLength",highlightFlags:"@?mdHighlightFlags",chipAppendDelay:"@?mdChipAppendDelay",separatorKeys:"=?mdSeparatorKeys",removedMessage:"@?mdRemovedMessage",inputClass:"@?mdInputClass",inputAriaDescribedBy:"@?inputAriaDescribedby",inputAriaLabelledBy:"@?inputAriaLabelledby",inputAriaLabel:"@?",containerHint:"@?",containerEmptyHint:"@?",deleteHint:"@?"}}}}(window,window.angular);