/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.0-master-93518bb
 */
goog.provide("ngmaterial.components.menuBar"),goog.require("ngmaterial.components.icon"),goog.require("ngmaterial.components.menu"),goog.require("ngmaterial.core"),angular.module("material.components.menuBar",["material.core","material.components.icon","material.components.menu"]),MenuBarController.$inject=["$scope","$rootScope","$element","$attrs","$mdConstant","$document","$mdUtil","$timeout"],angular.module("material.components.menuBar").controller("MenuBarController",MenuBarController);var BOUND_MENU_METHODS=["handleKeyDown","handleMenuHover","scheduleOpenHoveredMenu","cancelScheduledOpen"];function MenuBarController(e,n,t,r,o,i,a,l){this.$element=t,this.$attrs=r,this.$mdConstant=o,this.$mdUtil=a,this.$document=i,this.$scope=e,this.$rootScope=n,this.$timeout=l;var u=this;angular.forEach(BOUND_MENU_METHODS,function(e){u[e]=angular.bind(u,u[e])})}function MenuBarDirective(t,o){return{restrict:"E",require:"mdMenuBar",controller:"MenuBarController",compile:function(e,n){return n.ariaRole||e[0].setAttribute("role","menubar"),angular.forEach(e[0].children,function(e){if("MD-MENU"==e.nodeName){e.hasAttribute("md-position-mode")||(e.setAttribute("md-position-mode","left bottom"),e.querySelector("button, a, md-button").setAttribute("role","menuitem"));var n=t.nodesToArray(e.querySelectorAll("md-menu-content"));angular.forEach(n,function(e){e.classList.add("md-menu-bar-menu"),e.classList.add("md-dense"),e.hasAttribute("width")||e.setAttribute("width",5)})}}),e.find("md-menu-item").addClass("md-in-menu-bar"),function(e,n,t,r){n.addClass("_md"),o(e,n),r.init()}}}}function MenuDividerDirective(){return{restrict:"E",compile:function(e,n){n.role||e[0].setAttribute("role","separator")}}}function MenuItemController(e,n,t){this.$element=n,this.$attrs=t,this.$scope=e}function MenuItemDirective(d,e,c){return{controller:"MenuItemController",require:["mdMenuItem","?ngModel"],priority:e.BEFORE_NG_ARIA,compile:function(r,e){var n,t,o=e.type,i="md-in-menu-bar";if("checkbox"!==o&&"radio"!==o||!r.hasClass(i))s("role","menuitem",r[0].querySelector("md-button, button, a"));else{var a=r[0].textContent,l=angular.element('<md-button type="button"></md-button>'),u='<md-icon md-svg-src="'+c.mdChecked+'"></md-icon>';l.html(a),l.attr("tabindex","0"),angular.isDefined(e.mdPreventMenuClose)&&l.attr("md-prevent-menu-close",e.mdPreventMenuClose),r.html(""),r.append(angular.element(u)),r.append(l),r.addClass("md-indent").removeClass(i),s("role","checkbox"===o?"menuitemcheckbox":"menuitemradio",l),n="ng-disabled",t=d.prefixer(n),angular.forEach(t,function(e){if(r[0].hasAttribute(e)){var n=r[0].getAttribute(e);l[0].setAttribute(e,n),r[0].removeAttribute(e)}})}return function(e,n,t,r){var o=r[0],i=r[1];o.init(i)};function s(e,n,t){(t=t||r)instanceof angular.element&&(t=t[0]),t.hasAttribute(e)||t.setAttribute(e,n)}}}}MenuBarController.prototype.init=function(){var a=this.$element,l=this.$mdUtil,e=this.$scope,u=this,n=[];a.on("keydown",this.handleKeyDown),this.parentToolbar=l.getClosest(a,"MD-TOOLBAR"),n.push(this.$rootScope.$on("$mdMenuOpen",function(e,n){-1!=u.getMenus().indexOf(n[0])&&(a[0].classList.add("md-open"),n[0].classList.add("md-open"),u.currentlyOpenMenu=n.controller("mdMenu"),u.currentlyOpenMenu.registerContainerProxy(u.handleKeyDown),u.enableOpenOnHover())})),n.push(this.$rootScope.$on("$mdMenuClose",function(e,n,t){var r=u.getMenus();-1!=r.indexOf(n[0])&&(a[0].classList.remove("md-open"),n[0].classList.remove("md-open"));var o=angular.element(n[0]).controller("mdMenu");if(o.isInMenuBar&&o.mdMenuBarCtrl===u){for(var i=n[0];i&&-1==r.indexOf(i);)i=l.getClosest(i,"MD-MENU",!0);i&&(t.skipFocus||i.querySelector("button:not([disabled])").focus(),u.currentlyOpenMenu=void 0),u.disableOpenOnHover(),u.setKeyboardMode(!0)}})),e.$on("$destroy",function(){for(u.disableOpenOnHover();n.length;)n.shift()()}),this.setKeyboardMode(!0)},MenuBarController.prototype.setKeyboardMode=function(e){e?this.$element[0].classList.add("md-keyboard-mode"):this.$element[0].classList.remove("md-keyboard-mode")},MenuBarController.prototype.enableOpenOnHover=function(){if(!this.openOnHoverEnabled){var e=this;e.openOnHoverEnabled=!0,e.parentToolbar&&(e.parentToolbar.classList.add("md-has-open-menu"),e.$mdUtil.nextTick(function(){angular.element(e.parentToolbar).on("click",e.handleParentClick)},!1)),angular.element(e.getMenus()).on("mouseenter",e.handleMenuHover)}},MenuBarController.prototype.handleMenuHover=function(e){this.setKeyboardMode(!1),this.openOnHoverEnabled&&this.scheduleOpenHoveredMenu(e)},MenuBarController.prototype.disableOpenOnHover=function(){this.openOnHoverEnabled&&(this.openOnHoverEnabled=!1,this.parentToolbar&&(this.parentToolbar.classList.remove("md-has-open-menu"),angular.element(this.parentToolbar).off("click",this.handleParentClick)),angular.element(this.getMenus()).off("mouseenter",this.handleMenuHover))},MenuBarController.prototype.scheduleOpenHoveredMenu=function(e){var n=angular.element(e.currentTarget).controller("mdMenu");this.setKeyboardMode(!1),this.scheduleOpenMenu(n)},MenuBarController.prototype.scheduleOpenMenu=function(e){var n=this,t=this.$timeout;e!=n.currentlyOpenMenu&&(t.cancel(n.pendingMenuOpen),n.pendingMenuOpen=t(function(){n.pendingMenuOpen=void 0,n.currentlyOpenMenu&&n.currentlyOpenMenu.close(!0,{closeAll:!0}),e.open()},200,!1))},MenuBarController.prototype.handleKeyDown=function(e){var n,t,r,o=this.$mdConstant.KEY_CODE,i=this.currentlyOpenMenu,a=i&&i.isOpen;switch(this.setKeyboardMode(!0),e.keyCode){case o.DOWN_ARROW:i?i.focusMenuContainer():this.openFocusedMenu(),n=!0;break;case o.UP_ARROW:i&&i.close(),n=!0;break;case o.LEFT_ARROW:t=this.focusMenu(-1),a&&(r=angular.element(t).controller("mdMenu"),this.scheduleOpenMenu(r)),n=!0;break;case o.RIGHT_ARROW:t=this.focusMenu(1),a&&(r=angular.element(t).controller("mdMenu"),this.scheduleOpenMenu(r)),n=!0}n&&(e&&e.preventDefault&&e.preventDefault(),e&&e.stopImmediatePropagation&&e.stopImmediatePropagation())},MenuBarController.prototype.focusMenu=function(e){var n=this.getMenus(),t=this.getFocusedMenuIndex();-1==t&&(t=this.getOpenMenuIndex());var r=!1;if(-1==t?r=!(t=0):(e<0&&0<t||0<e&&t<n.length-e)&&(t+=e,r=!0),r)return n[t].querySelector("button").focus(),n[t]},MenuBarController.prototype.openFocusedMenu=function(){var e=this.getFocusedMenu();e&&angular.element(e).controller("mdMenu").open()},MenuBarController.prototype.getMenus=function(){var e=this.$element;return this.$mdUtil.nodesToArray(e[0].children).filter(function(e){return"MD-MENU"==e.nodeName})},MenuBarController.prototype.getFocusedMenu=function(){return this.getMenus()[this.getFocusedMenuIndex()]},MenuBarController.prototype.getFocusedMenuIndex=function(){var e=this.$mdUtil.getClosest(this.$document[0].activeElement,"MD-MENU");return e?this.getMenus().indexOf(e):-1},MenuBarController.prototype.getOpenMenuIndex=function(){for(var e=this.getMenus(),n=0;n<e.length;++n)if(e[n].classList.contains("md-open"))return n;return-1},MenuBarController.prototype.handleParentClick=function(e){var n=this.querySelector("md-menu.md-open");n&&!n.contains(e.target)&&angular.element(n).controller("mdMenu").close(!0,{closeAll:!0})},MenuBarDirective.$inject=["$mdUtil","$mdTheming"],angular.module("material.components.menuBar").directive("mdMenuBar",MenuBarDirective),angular.module("material.components.menuBar").directive("mdMenuDivider",MenuDividerDirective),MenuItemController.$inject=["$scope","$element","$attrs"],angular.module("material.components.menuBar").controller("MenuItemController",MenuItemController),MenuItemController.prototype.init=function(e){var n=this.$element,t=this.$attrs;this.ngModel=e,"checkbox"!=t.type&&"radio"!=t.type||(this.mode=t.type,this.iconEl=n[0].children[0],this.buttonEl=n[0].children[1],e&&this.initClickListeners())},MenuItemController.prototype.clearNgAria=function(){var n=this.$element[0];angular.forEach(["role","tabindex","aria-invalid","aria-checked"],function(e){n.removeAttribute(e)})},MenuItemController.prototype.initClickListeners=function(){var e=this,n=this.ngModel,t=this.$scope,r=this.$attrs,o=(this.$element,this.mode);this.handleClick=angular.bind(this,this.handleClick);var i=this.iconEl,a=angular.element(this.buttonEl),l=this.handleClick;function u(e){e?a.off("click",l):a.on("click",l)}r.$observe("disabled",u),u(r.disabled),n.$render=function(){e.clearNgAria(),!function(){{if("radio"!=o)return n.$modelValue;var e=r.ngValue?t.$eval(r.ngValue):r.value;return n.$modelValue==e}}()?(i.style.display="none",a.attr("aria-checked","false")):(i.style.display="",a.attr("aria-checked","true"))},t.$$postDigest(n.$render)},MenuItemController.prototype.handleClick=function(e){var n,t=this.mode,r=this.ngModel,o=this.$attrs;"checkbox"==t?n=!r.$modelValue:"radio"==t&&(n=o.ngValue?this.$scope.$eval(o.ngValue):o.value),r.$setViewValue(n),r.$render()},MenuItemDirective.$inject=["$mdUtil","$mdConstant","$$mdSvgRegistry"],angular.module("material.components.menuBar").directive("mdMenuItem",MenuItemDirective),ngmaterial.components.menuBar=angular.module("material.components.menuBar");