module.exports = function(config) {
  config.set({

    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: '../',

    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['jasmine'],

    // list of files / patterns to load in the browser
    files: [
      //  Dependencies
      'bower_components/angular/angular.min.js',
      'bower_components/angular-mocks/angular-mocks.js',
      //  Our source
      'src/angular-modal-service.js',
      //  Our specs
      'test/**/*.spec.js'
    ],

    // list of files to exclude
    exclude: [],

    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
      'src/angular-modal-service.js': ['coverage']
    },

    // test results reporter to use
    reporters: ['progress', 'coverage', 'junit'],

    // tell karma how you want the coverage results
    coverageReporter: {
    	reporters: [{
	    		type: 'lcov',
	      	dir: 'build/coverage/'
    		},{
          type: 'html', 
          dir:'build/coverage/'
        }
    	]
    },

		// junit output is used by jenkins	
		junitReporter: {
		  outputFile: 'build/test-results.xml'
		},

    // web server port
    port: 9876,

    // enable / disable colors in the output (reporters and logs)
    colors: true,

    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,

    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: false,

    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['PhantomJS'],

    // if true, Karma captures browsers, runs the tests and exits
    singleRun: true,

    background: false

  });
};
