import { Http } from '@angular/http';
import { Observable } from 'rxjs';
export declare class OAuthService {
    private http;
    clientId: string;
    redirectUri: string;
    loginUrl: string;
    scope: string;
    resource: string;
    rngUrl: string;
    oidc: boolean;
    options: any;
    state: string;
    issuer: string;
    validationHandler: any;
    logoutUrl: string;
    clearHashAfterLogin: boolean;
    tokenEndpoint: string;
    userinfoEndpoint: string;
    dummyClientSecret: string;
    discoveryDocumentLoaded: boolean;
    discoveryDocumentLoaded$: Observable<any>;
    private discoveryDocumentLoadedSender;
    private grantTypesSupported;
    setStorage(storage: Storage): void;
    private _storage;
    constructor(http: Http);
    loadDiscoveryDocument(fullUrl?: string): Promise<any>;
    fetchTokenUsingPasswordFlowAndLoadUserProfile(userName: string, password: string): Promise<{}>;
    loadUserProfile(): Promise<{}>;
    fetchTokenUsingPasswordFlow(userName: string, password: string): Promise<{}>;
    refreshToken(): Promise<{}>;
    createLoginUrl(state: any): Promise<string>;
    initImplicitFlow(additionalState?: string): void;
    callEventIfExists(options: any): void;
    private storeAccessTokenResponse(accessToken, refreshToken, expiresIn);
    tryLogin(options: any): boolean;
    processIdToken(idToken: any, accessToken: any): boolean;
    getIdentityClaims(): any;
    getIdToken(): string;
    padBase64(base64data: any): any;
    tryLoginWithIFrame(): void;
    tryRefresh(timeoutInMsec: any): void;
    getAccessToken(): string;
    hasValidAccessToken(): boolean;
    hasValidIdToken(): boolean;
    authorizationHeader(): string;
    logOut(noRedirectToLogoutUrl?: boolean): void;
    createAndSaveNonce(): Promise<any>;
    createNonce(): Promise<{}>;
    getFragment(): {};
    parseQueryString(queryString: any): {};
    checkAtHash(accessToken: any, idClaims: any): boolean;
}
