NG_DOCS={
  "sections": {
    "api": "API Documentation"
  },
  "pages": [
    {
      "section": "api",
      "id": "patternfly.autofocus:pfFocused",
      "shortName": "pfFocused",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "The focus on element is evaluated from given expression. If the expression provided as an attribute to this directive",
      "keywords": "api attribute autofocus box checkbox checking class col-sm-10 col-sm-2 control-label directive element evaluated expression focus focused form-control form-group form-horizontal html i1 i2 input isfocus module ng-model patternfly pf-focused pffocused placeholder provided selected true type"
    },
    {
      "section": "api",
      "id": "patternfly.card.directive:pfAggregateStatusCard",
      "shortName": "pfAggregateStatusCard",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Directive for easily displaying status information",
      "keywords": "$scope adipiscing aggregate aggstatusalt alt-layout alternate alternative angular api array border card carddemoctrl class clicks col-md-10 configuration controller count counts depreciated directive display displaying displays easily equals fa fa-shield false function hides href html icon iconclass iconimage icons image img js layout layouts left list-style-type main mini miniaggstatus miniaggstatus2 module navigate ng-controller nodes normal note notification notifications number object param patternfly pf-aggregate-status-card pficon pficon-cluster pficon-container-node pficon-error-circle-o pficon-ok pficon-warning-triangle-o providers script show-top-border single status statuses style svg tall title top true"
    },
    {
      "section": "api",
      "id": "patternfly.card.directive:pfCard - Timeframe Filters",
      "shortName": "pfCard - Timeframe Filters",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Directive for easily displaying a card with html content",
      "keywords": "$scope alert angular api array based blue border bottom call callback callbackfn called card chartctrl charts class clicked configuration content contents controller days defaultfilter defined demo directive displaying drop easily events fa fa-flag false filter filterconfig filterconfigheader filters fn footer footerconfig function grey head-title header headtitle hides href html icon iconclass integer items js label label-title left link list-style-type module navigate ng-controller panel patternfly pf-card position properties script selected show-top-border showtitlesseparator showtopborder style sub-title subtitle text timeframe title today top true user view width"
    },
    {
      "section": "api",
      "id": "patternfly.card.directive:pfCard - Trends",
      "shortName": "pfCard - Trends",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Directive for easily displaying a card with html content",
      "keywords": "$scope actionbarconfig actual add alert angular api array based blue border bottom call callback callbackfn called capacity card chart-data chartctrl chartid charts class clicked cluster compact config configmemory configphysical configsingle configuration configvirtual content controller d-- datamemory dataphysical datasingle datavirtual dates days defaultfilter defined demo directive disk displaying drop easily events example2trendschart fa fa-flag fa-plus-circle false filter filterconfig filters fn footer footerconfig function gb gettime grey head-title headtitle hides href html icon iconclass inline integer items js label label-title layout left link list-style-type memory memorytrendschart mhz module multiple navigate ng-controller panel patternfly percentage performance pf-card pf-trends-chart physical physicaltrendschart properties push script selected show-titles-separator show-top-border showtitlesseparator showtopborder single storage style sub-title subtitle tb text title today tooltiptype top total trend trendlabel trends true units user utilization valuetype var view virtual virtualtrendschart width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.card.directive:pfCard - Utilization",
      "shortName": "pfCard - Utilization",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Directive for easily displaying a card with html content",
      "keywords": "$scope angular api array bars based blue border bottom call callbackfn called card chart-data chart-title chartctrl charts class clicked configuration content controller cpu data2 data3 data4 data5 days defaultfilter defined demo directive disk displaying drop easily false filter filters footer function gb grey head-title headtitle hides href html icon iconclass inline integer items js label-title layout layoutinline left link list-style-type memory mhz module multiple navigate ng-controller panel patternfly pf-card pf-utilization-bar-chart properties resources script selected show-top-border showtitlesseparator showtopborder style sub-title subtitle system tb text threshold-error threshold-warning title title2 title3 title4 title5 today top total true type units units2 units3 units4 units5 usage user utilization width"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfC3Chart",
      "shortName": "pfC3Chart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for wrapping c3 library",
      "keywords": "$scope add angular api application bind button c3 c3chartdefaults callback called chart chartconfig chartctrl chartid charts class columns config configuration container controller data default dependency directive donut focus focusused form form-control form-group function generated get-chart-callback getchart getchartcallback getdefaultdonutconfig groups html js library mhz module newused ng-click ng-controller ng-model note null object options order patternfly pf-c3-chart role script set style submitform text total type updateavailable user val width wrapping"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfDonutPctChart",
      "shortName": "pfDonutPctChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a percentage used donut/radial chart.  The Used Percentage fill starts at 12 o’clock and",
      "keywords": "$scope alert amount angular api arc availchart availconfig availdata availlabel blue c3 calculate calculated center center-label centerlabelfn chart chart-height chartctrl charterr chartheight chartid chartnothresh chartok charts chartwarn checkbox checkbox-inline class click clicked clockwise col-md-12 col-md-3 color colors config configerr confignothresh configok configuration configwarn container-fluid contents controller custchart custchartheight custconfig custdata customize data dataavailable dataerr datanothresh dataok datawarn default defined dependent determine directive display displays donut donut-tooltip-pf error exist fill flag form form-group full function gb gray grey handle handling height html http indicator js label legend list list-style-type mhz module moves ng-controller ng-model nolabel nonechart noneconfig nonedata nowrap number onclickfn options orange org patternfly pctchart pctconfig pctdata pctlabel percent percentage pf-donut-pct-chart portion properties radial red rendered rendering represented representing return role row script specifies starts style surpassed text text-center three threshold thresholds tool tooltip tooltipfn total true type unique unit units usage usedchart usedconfig useddata usedlabel user values warning white-space width"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfHeatMap",
      "shortName": "pfHeatMap",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a heatmap chart.",
      "keywords": "$scope angular api block block-padding blockpadding blocks call ce0000 chart chart-data-available chart-title chartctrl chartdataavailable charts charttitle checkbox checkbox-inline class click-action clickaction clicked col-md-3 col-md-5 colors console controller correspond d4f0fa data dataavailable default defaults directive displayed ec7a08 example-heatmap-container f00 f9d67a flag form form-group function heapmap heatmap heatmap-color-pattern heatmapcolorpattern height highlight highlighting hightest hover html js kubernetes labels legend legend-labels legendlabels legends list-style-type log m8y max-block-size maxblocksize maximum measurement memory message minblocksize minimum module ng-controller ng-model node nodes openshift overriding padding patternfly pf-heatmap pixels provider range range-tooltips rangehoversize rangeonhover rangetooltips rendering role row script show-legend showlegend showlegends size small style threshold thresholds title titlealt titlesmall tooltip tooltips total true type units utilization values var"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfLineChart",
      "shortName": "pfLineChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a line chart.",
      "keywords": "$scope adddatapoint angular api area array arrays axis bind blue c3 chart chart-data chartctrl chartdata chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 color colorpalette config configuration container contents controller created custareachart custshowxaxis custshowyaxis d-- data dataavailable dates default deleted directive display element elements exampleline exist false form form-group full function functions gb generation gettime green grid html http js label legend length list list-style-type markup mhz module ng-click ng-controller ng-model optional options org override overrides patternfly pf-line-chart pfutils point points properties push random rendering resetdata return role round row script second set-area-chart setareachart setting settings show-x-axis show-y-axis showing showxaxis showyaxis size style today tooltip tooltipfn tooltiptype true type unit units values var width xdata ydata ydata0 ydata1"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfSparklineChart",
      "shortName": "pfSparklineChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a sparkline chart.",
      "keywords": "$scope adddatapoint amount angular api area array axis bind c3 chart chart-data chart-height chartctrl chartdata chartheight chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 color config configuration container contents controller current custchartheight custshowxaxis custshowyaxis d-- data dataavailable dates day default determining directive display element examplesparkline false flag form form-group full function functions gb generation gettime height html http js label legend length list list-style-type markup mhz module ng-click ng-controller ng-model number options org override overrides patternfly percent percentage percentages pf-sparkline-chart point points properties push radio radio-inline random rendering return role round row script set setting settings show-x-axis show-y-axis showing showxaxis showyaxis size sparkline style today tooltip tooltipfn tooltiptype total true type unit units usageperday valid valueperday values var width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfTrendsChart",
      "shortName": "pfTrendsChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a trend chart. The trend chart combines overall data with a",
      "keywords": "$scope $watch actual add adddatapoint alert amount angular api array axis c3 callback callbackfn called card chart chart-data chartctrl chartdata chartheight chartid charts checkbox checkbox-inline class cluster col-md-12 col-md-2 col-md-3 col-md-4 col-md-6 combines compact config configuration controller custshowxaxis custshowyaxis d-- data dataavailable dates days default demo directive disk display element exampletrendschart fa fa-plus-circle false filter filterconfig filters flag fn footer footerconfig form form-group format frame full function gb gettime height html http iconclass inline js label large latest layout length list list-style-type mhz minutes module network newvalue ng-click ng-controller ng-hide ng-model ng-selected number options org override patternfly percentage pf-select pf-select-sm pf-trends-chart pfsparklinechart point points push random rendering representing role round row script selected settings show-x-axis show-y-axis showing showxaxis showyaxis sizes small sparkline style text time timeframe title titles today tooltiptype total trend trendlabel trends true type unique unit units utilization values valuetype var virtual width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfUtilizationBarChart",
      "shortName": "pfUtilizationBarChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a utilization bar chart",
      "keywords": "$scope actual alternative amount angular api arc auto-format automatic bar blue card chart chart-data chart-footer chart-title chartctrl chartdata charts checkbox checkbox-inline class col-md-6 colors controller cpu custom data data1 data2 data3 data4 data5 dataavailable default denotes dependent directive disk displayed displays donut error example examples exist fill flag footer-label-format footer1 footer2 footerlabelwidth form form-group function gb html indicator inline js label label-title labels layout layoutinline layouts left-hand list-style-type mb memory mhz module ng-controller ng-model number orange patternfly percent percentage pf-utilization-bar-chart ram reached red regular rendering representing right-hand role row script side smaller standard style surpassed tb three threshold threshold-error threshold-warning thresholds title title1 title2 title3 title4 title5 titlelabelwidth total true type units units1 units2 units3 units4 units5 usage utilization valid values warning width"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfUtilizationTrendChart",
      "shortName": "pfUtilizationTrendChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Directive for rendering a utilization trend chart. The utilization trend chart combines overall",
      "keywords": "$scope add adddatapoint amount angular api array axis c3 center center-label centerlabel chart chart-data charta chartctrl chartdata chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 combines config configuration contents controller custchartheight custshowxaxis custshowyaxis d-- data dataavailable dates day default directive display displays donut donut-config donutcenterlabel donutconfig element error examplesparkline false flag form form-group full function gb gettime height html http js label length list list-style-type math memory mhz module newdata newdate ng-change ng-click ng-controller ng-model number options org override parameter patternfly pct percent percentage pf-utilization-trend-chart pfdonutchart pfdonutpctchart pfsparklinechart point points push radio radio-inline random rendering representing role round row script settings show-sparkline-x-axis show-sparkline-y-axis showing showsparklinexaxis showsparklineyaxis sparkline sparkline-chart-height sparkline-config sparklinechartheight sparklineconfig specifics specifies style thresholds title today tooltip tooltiptype total trend true type unit units updatedataavailable usage usageperday utilization valueperday values var warning width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.filters.directive:pfFilter",
      "shortName": "pfFilter",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for a filter bar",
      "keywords": "$scope address allitems angular api apple applied appliedfilters applyfilters april august bar bedrock birth birthmonth boulevard box call cfme-row-column changes cincinatti class col-md-12 col-md-2 col-md-3 col-md-7 comparisons config configuration controller current currently december deps dinosaur directive display east elm entered events-label example-container examplefilter false february field fields filter filterable filterchange filterconfig filters filterstext filtertype filtervalues flintstone foreach frank fred function green html input item items january john js judy july june length list list-style-type livingston main march match matches matchesfilter matchesfilters module month ng-controller ng-repeat norfolk november null number october ohio onfilterchange optional pat patternfly pennsylvania pf-filter pittsburgh placeholder push regexp resultscount return returned row rows script second select september settings single smith street style text thomas title true type unique valid values var viewctrl virginia washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.filters.directive:pfFilterFields",
      "shortName": "pfFilterFields",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for the filter bar&#39;s filter entry components",
      "keywords": "api applied appliedfilters bar box comparisons components config configuration currently directive display entered entry field fields filter filterable filters filtertype filtervalues html input list list-style-type optional patternfly placeholder select settings style text title type unique valid values"
    },
    {
      "section": "api",
      "id": "patternfly.filters.directive:pfFilterResults",
      "shortName": "pfFilterResults",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for the filter results components",
      "keywords": "api applied appliedfilters box call changes comparisons components config configuration current currently directive display entered field fields filter filterable filters filtertype filtervalues function html input list list-style-type number onfilterchange optional patternfly placeholder resultscount returned select settings style text title type unique valid values"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfDatepicker",
      "shortName": "pfDatepicker",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Angular directive to wrap the bootstrap datepicker http://bootstrap-datepicker.readthedocs.org/en/latest/",
      "keywords": "$scope angular api autoclose bootstrap class configuration controller datepicker directive form form-horizontal formdemoctrl function html http js linked mm model module ng-bind ng-click ng-controller options org patternfly pf-datepicker picker readthedocs script settoday today todaybtn todayhighlight true wrap"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfDateTimepicker",
      "shortName": "pfDateTimepicker",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Angular directive to wrap the bootstrap datetimepicker http://eonasdan.github.io/bootstrap-datetimepicker/",
      "keywords": "$scope angular api bootstrap class configuration controller datetimepicker directive form format formdemoctrl function github hh html http io js module moment ng-bind ng-controller object options patternfly pf-date-timepicker picker script time wrap"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfFormButtons",
      "shortName": "pfFormButtons",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Encapsulates the standard structure and styling for create and cancel buttons",
      "keywords": "$scope $timeout angular api button buttons call cancel cancelled class clicks col-sm-2 col-sm-5 container control-label controller create creates directive encapsulates false form form-control form-group formbuttonctrl function html input item js model module ng-controller ng-model null patternfly pf-form-buttons pf-on-cancel pf-on-save pf-working pfbuttonclass pfhandlecancel pfhandlesave pfworking save saved scope script standard status store structure styling text true type user working"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfFormGroup",
      "shortName": "pfFormGroup",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Encapsulates the structure and styling for a label + input used within a",
      "keywords": "$scope angular api based bootstrap3 class col-sm-2 col-sm-5 col-sm-9 controller creates default description directive doh donuts duff element encapsulates field form form-horizontal formdemoctrl function homer html input item js label module ng-controller ng-model patternfly pf-form-group pf-input-class pf-label pffieldid pfinputclass pflabel pflabelclass required scope script simpson structure styling text type"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfRemainingCharsCount",
      "shortName": "pfRemainingCharsCount",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Directive for showing a characters remaining count and triggering warning and error",
      "keywords": "$on $scope additional additionally allow angular api applied area behavior block block-input-at-max-limit btn btn-default button character characters characters-remaining charremainingcntfld_1 charremainingcntfld_2 charremainingcntfld_3 chars-max-limit chars-remaining-pf chars-warn-remaining chars-warn-remaining-pf charsmaxlimitexceeded class col-md-4 color container controller count count-fld css default democtrl directive disable dispatched dispatching display emptly entered equal error event example falls false field form form-control form-group function greater html initial input input_3 js limit max maximum message messagearea messagearea1text messagearea2text messagearea_1 messagearea_2 messageinput3text model module negative ng-controller ng-disabled ng-model number overcharsmaxlimit padding-left passed passing paste patternfly pf-remaining-chars-count placeholder postbtn_1 postbtn_2 pull-left pull-right reached red remaining removed representing required resize right-click row rows scope script setting showing string style submit text textarea tfid threshold thresholds trigger triggered triggering true turns type undercharsmaxlimit variable warn warning width"
    },
    {
      "section": "api",
      "id": "patternfly.modals.directive:pfAboutModal",
      "shortName": "pfAboutModal",
      "type": "directive",
      "moduleName": "patternfly.modals",
      "shortDescription": "Directive for rendering modal windows.",
      "keywords": "$scope additional-info additionalinfo admin administrator alt angular ante api bibendum btn btn-default call class closed commodo consequat controller copyright corner data dignissim directive donec egestas explaining false feugiat flag function fusce grahpic html iaculis img img-alt img-src imgalt imgsrc indicating interdum ipsum is-open isopen js label laoreet lectus list-style-type localhost lorem modal modalctrl modals module neque ng-click ng-controller nulla odio on-close onclose open opened patternfly pf-about-modal placerat product product-info productinfo quam rendering risus role script sed semper server source style suscipit suspendisse svg symbol tempus text title trademark tristique true urna user ut vel version vestibulum windows"
    },
    {
      "section": "api",
      "id": "patternfly.navigation.directive:pfVerticalNavigation - Basic",
      "shortName": "pfVerticalNavigation - Basic",
      "type": "directive",
      "moduleName": "patternfly.navigation",
      "shortDescription": "Directive for vertical navigation. This sets up the nav bar header with the collapse button (hamburger) and the",
      "keywords": "$scope absolutely accumsan active add add_content addclass additional adipiscing adipscing aeque aliquam allow amet angular api application aria-expanded aria-haspopup aria-labelledby badge badgeclass badges bar based basic brand brand-alt brandalt brandsrc btn btn-primary button callback card-pf card-pf-accented card-pf-aggregate-status card-pf-aggregate-status-count card-pf-aggregate-status-mini card-pf-aggregate-status-notification card-pf-aggregate-status-notifications card-pf-body card-pf-heading card-pf-title caret change children class classes click col-md-3 col-sm-6 col-xs-12 collapse conjunction container container-cards-pf container-fluid container-pf-nav-pf-vertical content contentcontainer controller convenire copiosae corrumpit count current dashboard data-placement data-toggle default delenit delicatissimi demo deps deserunt detracto directive display displayed dolor dropdown dropdown-menu dropdown-toggle dropdownmenu1 dropdownmenu2 element error example-error-background example-info-text example-page-container example-warning-background exerci exit fa fa-dashboard fa-gamepad fa-graduation-cap fa-paper-plane fa-rebel fa-shield fa-space-shuttle false faux-layout filters flag function gb getelementbyid gubergren handlenavigateclick header height help hidden hiddenicons hide-show hide-vertical-nav hideverticalnav href html icon iconclass icons ignored ignoremobile image includedcontent innerhtml intellegam invoked ipsum item itemclickcallback items js layout-pf layout-pf-fixed level link list list-style-type location lorem main marked mediocrem menu menus method mhz mobile mock module nav nav-item-iconic navbar navbar-iconic navbar-nav navbar-right navigate navigate-callback navigatecallback navigation navigationitems ng-controller nonumy novum number onclick option options parts patrioque patternfly pericula persistent persistentsecondary pf-vertical-navigation pficon pficon-add-circle-o pficon-cluster pficon-error-circle-o pficon-help pficon-image pficon-ok pficon-user pficon-warning-triangle-o pinnable-menus pinning primary principes product progress progress-bar progress-bar-danger progress-bar-remaining progress-bar-success progress-bar-warning progress-container progress-description progress-description-left progress-label-right progress-label-top-right progressbar quaeque qualisque queryselector quotas ready recteque remaining removeclass return role row row-cards-pf script secondary selector set sets show-badges showbadges showing showverticalnav sort sr-only src structure style suavitate submenu submenus supports tertiary text tha title tooltip top total transcluded true update-active-items-on-click updateactiveitemsonclick urbanitas username utilized utils utroque vertical verticalnavlayout vertnavcontroller views vituperatoribus warning width works"
    },
    {
      "section": "api",
      "id": "patternfly.navigation.directive:pfVerticalNavigation - Router",
      "shortName": "pfVerticalNavigation - Router",
      "type": "directive",
      "moduleName": "patternfly.navigation",
      "shortDescription": "This example shows how to use pfVerticalNavigation with angular-ui-router&#39;s $states and uiSrefs.",
      "keywords": "$scope $state $stateprovider $states $urlrouterprovider absolutely active add addclass additional angular angular-ui-router api aria-expanded aria-haspopup aria-labelledby badge badgeclass badges bar brand brand-alt brandalt brandsrc btn btn-primary callback card-pf card-pf-accented card-pf-aggregate-status card-pf-aggregate-status-notifications card-pf-body caret change children class classes click config container container-cards-pf container-fluid container-pf-nav-pf-vertical content contentcontainer controller count dashboard data-toggle default defined demo deps directive display displayed dolor dropdown dropdown-menu dropdown-toggle dropdownmenu1 dropdownmenu2 element example example-info-text example-page-container exit fa fa-dashboard fa-shield fa-space-shuttle false faux-layout filters flag function getelementbyid handlenavigateclickrouter height help hidden hiddenicons hide-show hide-vertical-nav hideverticalnavwithrouter href html icon iconclass icons ignored ignoremobile image invoked ipsum item itemclickcallback items js layout-pf layout-pf-fixed level link list list-style-type marked menu menus method mobile mock module myapp nav nav-item-iconic navbar-iconic navbar-nav navbar-right navigate navigate-callback navigatecallback navigation navigationitems ng-controller object onclick optional passed patternfly persistent persistentsecondary pf-vertical-navigation pficon-help pficon-user pfverticalnavigation pinnable-menus primary product queryselector ready removeclass return router script secondary show-badges showbadges showing showverticalnavwithrouter somekey somevalue sort src structure style submenu submenus template text title tooltip top true ui uirouter uisref uisrefoptions uisrefs update-active-items-on-click updateactiveitemsonclick url username utils versa vertical verticalnavwithrouterlayout vertnavwithroutercontroller vice views"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfInlineNotification",
      "shortName": "pfInlineNotification",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "The main visual element of the notification message.",
      "keywords": "$scope allowed angular api button checkbox class close closed col-sm-10 col-sm-2 control-label controller danger default delay directive disappear element false form-control form-group form-horizontal function header html info ispersistent js main manually message module ng-controller ng-model ng-options notification notificationdemoctrl notifications patternfly pf-notification-header pf-notification-message pf-notification-persistent pf-notification-type pf-select pfnotificationheader pfnotificationmessage pfnotificationpersistent pfnotificationtype script success text timeout type types visual warning won"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfNotificationDrawer",
      "shortName": "pfNotificationDrawer",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Directive for rendering a notification drawer. This provides a common mechanism to handle how the notification",
      "keywords": "$scope access accessed action action-button-callback action-button-title actionbuttoncallback actionbuttoncb actionbuttontitle actions actions-label actionstext add allow-expand allowexpand angular api area aria-expanded aria-haspopup aria-labelledby array behave blank body bold bottom btn btn-block btn-link button callback called capability class clear clearall clicked col-md-12 col-sm-6 collapse common container-fluid content controller create currently currenttime custom-scope customize customscope data-toggle default define deps desire directive disabled display divider drawer drawer-hidden drawer-pf-notification-info drawer-pf-notification-message drawer-pf-trigger drawer-pf-trigger-icon drawer-title drawerctrl drawerexpanded drawerhidden drawertitle drawexpanded dropdown dropdown-kebab-pf dropdown-menu dropdown-menu-right dropdown-toggle dropdownkebabright error event events example-container expand expanded fa fa-bell fa-ellipsis-v false files filter filters find flag footer foreach function getnotficationstatusiconclass gettime group grouped groups handle handleaction handler hanlders heading heading-include headinginclude hidden hidedrawer html huzzah include included indicator info isdisabled isloading isseparator js layout-pf-fixed length lower mandating mark markread mechanism menuactions menuitem message method mm module nav nav-item-iconic navbar-collapse navbar-iconic navbar-left navbar-nav navbar-pf-vertical newtext nextnotification ng-class ng-click ng-controller ng-if ng-repeat notification notification-body notification-body-include notification-footer notification-footer-include notification-groups notification-message notificationbodyinclude notificationfooterinclude notificationgroup notificationgroups notifications notificaton object optional pass passed patternfly perform pf-notification-drawer pficon pficon-close pficon-error-circle-o pficon-info pficon-ok pficon-warning-triangle-o pre-demo-text provide provided pull-left pull-right read remove rendering retclass return role row rows scope script secondary-action separator sort source src status sub-heading subheading subheading-include subheadinginclude tab text time timestamp title titleinclude toggleshowdrawer tooltip tooltip-append-to-body tooltip-placement tooltip-popup-delay true type unavailable unread utils valid var variables views warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfNotificationList",
      "shortName": "pfNotificationList",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Using this directive automatically creates a list of notifications generated by the notification service.",
      "keywords": "$scope angular api automatically class click col-sm-10 col-sm-12 col-sm-2 control-label controller creates danger default directive error form-control form-group form-horizontal function generated html info js list message module ng-click ng-controller ng-model ng-options notification notificationdemoctrl notifications notify object patternfly pf-select script service success text times type typemap types var warn warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfToastNotification",
      "shortName": "pfToastNotification",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Toast notifications are used to notify users of a system occurence. Toast notifications should be transient and stay on the screen for 8 seconds,",
      "keywords": "$scope $watch action action-callback action-title actioncallback actionfn actions actions-label actiontext actiontitle add allow allowed allows angular api block button callbacks capabilities checkbox class close close-callback closecallback col-md-12 col-sm-10 col-sm-2 col-sm-3 control-label controller currently danger data default directive disable disabled displayed example-container false flag form-control form-group form-horizontal function grouped handleaction header html info invoke isdisabled isseparator item js kebab list list-style-type long main menu menu-actions menuaction menuactions message module needed ng-controller ng-model ng-options note notification notification-type notifications notificationtype notify occurence optional patternfly perform performaction pf-select pf-toast-notification pftoastnotification place placehodler primary primaryaction read row rows screen script seconds selected separator set show-close showclose showmenu status stay style success supported system text title toast toastnotificationdemoctrl transient true type types unavailable undefined updateviewing user users var viewing warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.directive:pfToastNotificationList",
      "shortName": "pfToastNotificationList",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Using this directive displayes a list of toast notifications",
      "keywords": "$rootscope $scope action actioncallback actionfn actions actions-label actiontext actiontitle allowed angular api button buttons checkbox class click close close-callback closecallback closed closes col-md-12 col-sm-1 col-sm-10 col-sm-12 col-sm-2 col-sm-3 control-label controller current danger data default directive disable disabled display displayed displayes example-container false flag form-control form-group form-horizontal function grouped handleaction handleclose header html info invoke isdisabled ispersistent isseparator js kebab list list-style-type main menu menuaction menuactions message module ng-click ng-controller ng-model ng-options notifcations notification notifications notify object optional patternfly perform performaction persistent pf-select pf-toast-notification-list pftoastnotification place placehodler primary primaryaction remove row rows script selected separator set setviewing show-close showclose showmenu style success text times title toast toastnotificationlistdemoctrl true type typemap types unavailable undefined update-viewing updateviewing user var viewing warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.Notification",
      "shortName": "patternfly.notification.Notification",
      "type": "service",
      "moduleName": "patternfly.notification",
      "shortDescription": "Notification service used to notify user about important events in the application.",
      "keywords": "$log $rootscope $scope angular api application argument button class close closed col-sm-10 col-sm-12 col-sm-2 config configuration configure configuring console control-label controller danger default delay dismissed error events example expects form-control form-group form-horizontal format function html httperror info input js manually message method miliseconds mode modes module ms myapp ng-click ng-controller ng-model ng-options notification notificationdemoctrl notifications notificationsprovider notify object option patternfly persist persistent persistvalue pf-select printed script service set setdelay setpersist sets setverbose success text true type typemap types user var verbose warn warning won"
    },
    {
      "section": "api",
      "id": "patternfly.select:pfSelect",
      "shortName": "pfSelect",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "An AngularJS wrapper for the Bootstrap-select jQuery plugin which is used",
      "keywords": "$scope angular angularjs api apple attribute banana binding bootstrap-select cat chicken class coffee col-sm-10 col-sm-2 control-label controller decorator default directive dog drink drinks dynamically element elements form-group form-horizontal fruit function generate github html http https io jquery js list mandatory model module ng-controller ng-model ng-options ng-selected ngmodel ngmodelcontroller ngoptions noneselectedtext orange org patternfly pet pets pf-select plugin preferred script select selectdemoctrl selected tea true water wrapper"
    },
    {
      "section": "api",
      "id": "patternfly.sort.directive:pfSort",
      "shortName": "pfSort",
      "type": "directive",
      "moduleName": "patternfly.sort",
      "shortDescription": "Directive for a  sort component",
      "keywords": "$scope alpha alright angular api ascending beautiful call cfme-row-column change cheap class col-md-12 col-md-3 comparefn component compvalue config configuration controller count current currentfield currently descending description direction directive display events-label example-container examplesort excellent false fantastic field fields forever function good horrible html isascending item item1 item2 items js lasts list list-style-type localecompare module ng-controller ng-repeat nice numeric onsortchange params patternfly pf-sort return row script selected settings sort sortable sortchange sortconfig sortdirection sorttype stuff style title true type unique var viewctrl"
    },
    {
      "section": "api",
      "id": "patternfly.toolbars.directive:pfToolbar",
      "shortName": "pfToolbar",
      "type": "directive",
      "moduleName": "patternfly.toolbars",
      "shortDescription": "Directive for standard toolbar. Includes filtering and view selection capabilities",
      "keywords": "$scope action actionfn actions actions-label actionsconfig actionsinclude actionstext add address age allitems alpha angular api apple appliedfilters applyfilters april august bedrock birth birthmonth boulevard btn btn-default button buttons call capabilities card-view-container cardview caret checkdisabled cincinatti class col-md-12 comparefn comparisons compvalue config configuration controller currentfield currently currentview custom december deps dinosaur directive disable disabled display displayed doadd dropdown dropdown-menu dropdown-toggle east elm events-label example-container exampletoolbar fa fa-plus false february fields filter filterchange filterconfig filtering filters filterstext filtertype filtervalues flintstone foreach frank fred function getcardview getlistview green grouped html icon iconclass includes invoke isascending isdisabled isseparator item item1 item2 items january john js judy july june length list list-group-item-heading list-group-item-text list-style-type list-view-container list-view-pf-additional-info list-view-pf-additional-info-item list-view-pf-description listconfig listview livingston localecompare main march match matches matchesfilter matchesfilters menu menuitem module month monthvals moreactions ng-click ng-controller ng-if norfolk november null numeric october ohio onfilterchange onsortchange onviewselect option optional options optionselected parseint pat patternfly pennsylvania perform performaction pf-card-view pf-list-view pf-toolbar pfsimplefilter pfsort pfviewutils pittsburgh placehodler placeholder primary primary-action primaryactions pulldown push regexp resultscount return role row rows script second secondary secondary-action select selected selection selectionmatchprop selector separator september set settings smith sort sortchange sortconfig sorttype standard street style text thing thomas title toolbar toolbarconfig toolbars tooltip transclude true type unavailable undefined unique var view viewctrl viewid views viewsconfig viewselected viewtype virginia vm washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.utils.directive:pfTransclude",
      "shortName": "pfTransclude",
      "type": "directive",
      "moduleName": "patternfly.utils",
      "shortDescription": "Directive for transcluding in directives and setting up scope of children of parent directives. This is a workaround",
      "keywords": "$delegate $id $provide angular api child children class config content contents controller decorator directive directives display element function html https js list-style-type module ng-controller ngtranscludedirective original parent patternfly pf-transclude pf-transclude-example pftransclude remove restrict return row scope script setting shift sibling specifies style template transclude transcludechild transcluded transcludeparent transcludesibling transcluding transclusion true type utilctrl utils width workaround"
    },
    {
      "section": "api",
      "id": "patternfly.utils:pfFixedAccordion",
      "shortName": "pfFixedAccordion",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "Directive for setting a ui-bootstrap uib-accordion to use a fixed height (collapse elements scroll when necessary)",
      "keywords": "ac accordioncntrl accumsan ad adipiscing adipisicing aenean aliqua aliquam aliquet aliquip amet angular anim ante api arcu area augue aute bibendum blandit bootstrap cillum class close-others col-md-4 collapse commodo congue consectetuer consectetur consequat controller convallis cras cubilia culpa cupidatat curabitur curae cursus dapibus default deps deserunt diam dictum dignissim directive dolor dolore donec dui duis ea egestas eget eiusmod eleifend element elements elementum elit enim entire erat eros esse est etiam eu euismod example-container excepteur exercitation false faucibus felis fermentum feugiat find fixed fringilla fugiat function fusce gravida group group-height groupclass groupheight heading height hendrerit html iaculis imperdiet incididunt integer interdum ipsum irure is-open js justo labore laboris laborum lacinia lacus laoreet lectus leo libero ligula lobortis lorem luctus maecenas magna malesuada massa mattis mauris metus mi minim module molestie mollis mollit morbi nam nec neque nibh nisi nisl nonummy nostrud nulla nunc occaecat odio officia orci ornare pariatur patternfly pede pellentesque pf-fixed-accordion pharetra placerat porta porttitor posuere praesent pretium primis proident proin pulvinar purus quam qui quis reprehenderit rhoncus risus row rutrum sagittis sapien scelerisque script scroll scrolls scrollselector sed selector sem semper set setting sint sit sodales sollicitudin specifies sunt suscipit suspendisse tellus tempor tempus tincidunt tortor tristique true turpis ui ui-bootstrap uib-accordion ullamco ullamcorper ultrices ultricies urna ut utils varius vehicula vel velit venenatis veniam vestibulum vitae vivamus viverra voluptate volutpat vulputate"
    },
    {
      "section": "api",
      "id": "patternfly.validation:pfValidation",
      "shortName": "pfValidation",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "Directive used for input validation based on custom function.",
      "keywords": "$scope angular api based change checkbox class col-sm-10 col-sm-2 control-label controller custom directive disabled enabled false form-control form-group form-horizontal function help-block html input isnumber isvalidationdisabled js message module myvalue myvaluevalid ng-controller ng-model number patternfly pf-validation pf-validation-disabled pfvalidationdisabled return script text true type typed valid validation validationdemoctrl"
    },
    {
      "section": "api",
      "id": "patternfly.views.directive:pfCardView",
      "shortName": "pfCardView",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Directive for rendering cards in a view",
      "keywords": "$scope address allow angular api apple applicable bedrock block border border-top boulevard boxes call called card cards change changes checkbox checkbox-inline checkdisabled checkdisableditem checked cincinatti city class click clicked clicking col-md-12 config configuration controller current data dblclick default deps determine determining dinosaur directive disabled display dlbclick double east elm event events-label eventtext examplecardview false flintstone form form-group frank fred function green handle handlecheckboxchange handleclick handledblclick handleselect handleselectionchange height hr html item items john js judy length list-style-type livingston main margin matching module multiple multiselect ng-change ng-controller ng-disabled ng-model norfolk notify ohio oncheckboxchange onclick ondblclick onselect onselectionchange padding pat patternfly pennsylvania pf-card-view pittsburgh property radio radio-inline remains rendering return role row rows script second select selected selecteditems selection selectionmatchprop selections selectitems selecttype set settings showdisabled showselectbox smith solid street style thomas true type updateselectiontype utils uuid var view viewctrl views virginia washingstone width york"
    },
    {
      "section": "api",
      "id": "patternfly.views.directive:pfListView",
      "shortName": "pfListView",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Directive for rendering a list view.",
      "keywords": "$parent $scope $templatecache access accessed action action-buttons actionbuttons actionfn actions ad add adding address adipisicing aliqua aliquip allow amet angular anim api applicable array aute based bedrock behavior body boston bourbon boxes brown btn-primary button buttoninclude buttons california call called center-label change changes chartid checkbox checkbox-inline checkdisabled checkdisableditem checked cillum city class click clicked clicking col-md-12 col-md-3 col-md-9 colorado commodo config configuration consectetur consequat content controller cross culpa cupidatat current custom customscope data dblclick default denver deps deserunt determine determining dinosaur directive disable disabled disablerowexpansion display displayed div dl-horizontal dlbclick dolor dolore double drag dragenabled dragend dragitem dragmoved dragstart drop dropdown dropdowns duis ea east edwards eiusmod element elit elm enable enable-button-for-item-fn enablebuttonforitemfn enabled ended enim error esse est eu event eventtext example-container example-list-view examplechartconfig examplelistview excepteur exercitation expandable expanding expansion fa fa-plus false field flintstone font-weight form form-group frank fred fugiat function gb getmenuclass grouped handle handlecheckboxchange handleclick handledblclick handleselect handleselectionchange hide hide-menu-for-item-fn hidemenuactions hidemenuforitemfn hmtl holly hollywood html incididunt include includeclass inside invoke ipsum irure isdisabled isseparator isvisible item items jim john js jump kebab labore laboris laborum layouts length linda list list-expanded-content list-group-item-heading list-group-item-text list-style-type list-view-container list-view-pf-additional-info list-view-pf-additional-info-item list-view-pf-description livingston lorem magna main marie massachusetts matching mcgovern menu menu-actions menu-class-for-item-fn menuactions menuclass menuclassforitemfn minim module mollit moved multiple multiselect my-button-template nashville ng-change ng-controller ng-disabled ng-model nichols nisi norfolk nostrud note notify nulla oak object occaecat officia oncheckboxchange onclick ondblclick onselect onselectionchange operation optional pariatur pass pat patternfly pctchart pennsylvania percent perform performaction performed pf-donut-pct-chart pf-list-view pittsburgh placeholder proident property qui quis radio radio-inline red relevant remains rendering reprehenderit return role row rowclass rows scope script second sed select selected selecteditems selection selectionmatchprop selections selectitems selecttype sentence separator server set setting settings showdisabled showselectbox sint sit smith source special splice src start start-button-template startbuttoninclude started starting startserver street style sunt tempor tennessee thomas thresholds title tooltip total transcluded true type ullamco unavailable units update update-menu-action-for-item-fn updatemenuactionforitemfn updateselectiontype useexpandingrows user ut utils uuid var variables velit veniam view viewctrl views virginia voluptate warning washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.directive:pfWizard",
      "shortName": "pfWizard",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Directive for rendering a Wizard modal.  Each wizard dynamically creates the step navigation both in the header and the left-hand side based on nested steps.",
      "keywords": "$emit $on $parent $rootscope $scope $timeout $uibmodal ac additional amet angular animation api back-callback backcallback backdrop backtitle based basic blank-slate-pf blank-slate-pf-icon blank-slate-pf-main-action blank-slate-pf-secondary-action boolean btn btn-default btn-lg btn-primary button buttons call called cancel canceldeploymentwizard canceled canceltitle changed class clicked close closewizard command complete configuration consistently content content-height contentheight controller creates current currentstep data default defaults define deploy deploycomplete deployinprogress deployment deploymentcomplete deploymentcontroller deployproviderready deployready deps description descriptive desired detail-page details details-extra details-general detailsgeneralcomplete detailsgeneralcontroller detailsreviewcontroller directive dismiss display displayed dolor dynamically eget embedded embedinpage example externally extra false final find finish finishedwizard footer form form-horizontal function general glyphicon glyphicon-ok-circle group hand header height hideindicators hides html indicate indicates indicators individual initializewizard instance ipsum isdefined isundefined js left left-hand length lg loading loading-secondary-information loadingsecondaryinformation loadingwizardtitle logical lorem modal modalinstance module moves navigation nested new-description new-ipsum new-lorem new-name next-callback next-enabled next-title nextbuttontitle nextcallback nexttitle ng-change ng-click ng-controller ng-if ng-include ng-model notify nunc ok-to-nav-away on-cancel on-finish on-show oncancel onfinish onshow open openwizardmodel operation pageshown parameters patternfly pf-form-group pf-label pf-wizard pf-wizard-review-page pf-wizard-step pf-wizard-substep pf-wizardstep pf-wizardsteps pf-wizardsubstep porta portions prev-enabled progress property ready reason removes rendering required result return returns review review-progress review-second-template review-summary review-template reviewtemplate script second secondary secondaryloadinformation set setting show-review show-review-details side sit size sociosqu spinner spinner-lg startdeploy static step step-id step-priority step-title stepid steps strict structure substeps successful summary summarycontroller supplied suspendisse switch tab templateurl text time title true type updatename updates ut var vivamus wisi wizard wizard-container wizard-data wizard-done wizard-pf-complete wizard-pf-contents wizard-pf-process wizard-pf-review-item wizard-pf-review-item-label wizard-pf-review-item-value wizard-pf-success-icon wizard-ready wizardcontroller wizarddata wizarddone wizarddonelistener wizardmodalcontroller wizardready wz-disabled"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.directive:pfWizardReviewPage",
      "shortName": "pfWizardReviewPage",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Directive for rendering a Wizard Review Page - should only be used within a wizard.",
      "keywords": "api apply content data directive internal internally patternfly rendering review sets templates visible watched wizard wizarddata"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.directive:pfWizardStep",
      "shortName": "pfWizardStep",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Directive for rendering a Wizard step.  Each step can stand alone or have substeps.  This directive can only be used as a child of pf-wizard.",
      "keywords": "allowclicknav api button called child click data default description details directive directly disables display displayed enabled entire expanded function header identifier indicates indicators leave navigate nextenabled nexttooltip numbered numeric oktonavaway onshow order passed patternfly pf-wizard prevenabled prevtooltip priority reached relative rendering review reviewtemplate screen sequentially sets shared showreview showreviewdetails stand step stepid steppriority steps steptitle substeps template text title tooltip user viewed wizard wizarddata wzdisabled"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.directive:pfWizardSubstep",
      "shortName": "pfWizardSubstep",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Directive for rendering a Wizard substep.  Each substep must be a child of a pf-wizardstep in a pf-wizard directive.",
      "keywords": "allowclicknav api button called child click data default description details directive directly disables displayed enabled entire expanded function header identifier indicators leave navigate nextenabled numbered numeric oktonavaway onshow order passed patternfly pf-wizard pf-wizardstep prevenabled priority reached relative rendering review reviewtemplate screen sequentially sets shared showreviewdetails step stepid steppriority steps steptitle substep template text title user viewed wizard wizarddata wzdisabled"
    }
  ],
  "apis": {
    "api": true
  },
  "html5Mode": false,
  "editExample": true,
  "startPage": "/api",
  "scripts": [
    "jquery.js",
    "bootstrap.js",
    "bootstrap-combobox.js",
    "bootstrap-datepicker.js",
    "moment.js",
    "bootstrap-datetimepicker.js",
    "bootstrap-select.js",
    "bootstrap-treeview.js",
    "c3.js",
    "d3.js",
    "patternfly.js",
    "angular.js",
    "angular-sanitize.js",
    "angular-animate.js",
    "ui-bootstrap-tpls.js",
    "angular-bootstrap-prettify.js",
    "lodash.min.js",
    "angular-patternfly.js",
    "angular-ui-router.min.js",
    "angular-drag-and-drop-lists.js"
  ]
};