"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var toKey = function (val) {
    return val ? val.toString() : '';
};
var computeKey = function (selector, transformer, comparator) {
    return "s:" + toKey(selector) + ":t:" + toKey(transformer) + ":c:" + toKey(comparator);
};
/**
 * Used to pool Observables created by @select and @select$. This
 * avoids memory leaks and improves efficiency.
 * @hidden
 */
var SelectionMap = (function () {
    function SelectionMap() {
        this._map = {};
    }
    SelectionMap.prototype.set = function (selector, transformer, comparator, selection) {
        var key = computeKey(selector, transformer, comparator);
        this._map[key] = selection;
    };
    SelectionMap.prototype.get = function (selector, transformer, comparator) {
        var key = computeKey(selector, transformer, comparator);
        return this._map[key];
    };
    SelectionMap.prototype.reset = function () {
        this._map = {};
    };
    return SelectionMap;
}());
exports.SelectionMap = SelectionMap;
/** @hidden */
exports.selectionMap = new SelectionMap();
//# sourceMappingURL=selection-map.js.map