import { Observable } from 'rxjs/Observable';
import { Selector, Comparator, Transformer } from '../components/selectors';
/**
 * Used to pool Observables created by @select and @select$. This
 * avoids memory leaks and improves efficiency.
 * @hidden
 */
export declare class SelectionMap {
    private _map;
    set(selector: Selector<any, any>, transformer: Transformer<any, any>, comparator: Comparator, selection: Observable<any>): void;
    get(selector: Selector<any, any>, transformer: Transformer<any, any>, comparator: Comparator): Observable<any>;
    reset(): void;
}
/** @hidden */
export declare const selectionMap: SelectionMap;
