import { ChangeDetectorRef, ElementRef, SimpleChanges, EventEmitter, Renderer, OnDestroy, OnChanges } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Subject } from 'rxjs/Subject';
import 'rxjs/add/operator/debounceTime';
import { SplitAreaDirective } from './splitArea.directive';
export interface IAreaData {
    component: SplitAreaDirective;
    sizeUser: number | null;
    size: number;
    orderUser: number | null;
    order: number;
    minPixel: number;
}
export declare class SplitComponent implements OnChanges, OnDestroy {
    private cdRef;
    private elementRef;
    private renderer;
    direction: string;
    width: number;
    height: number;
    gutterSize: number;
    disabled: boolean;
    visibleTransition: boolean;
    dragStart: EventEmitter<number[]>;
    dragProgress: EventEmitter<number[]>;
    dragEnd: EventEmitter<number[]>;
    visibleTransitionEndInternal: Subject<number[]>;
    visibleTransitionEnd: Observable<number[]>;
    readonly styleFlexDirection: boolean;
    readonly styleFlexDirectionStyle: string;
    readonly dragging: boolean;
    readonly styleWidth: string;
    readonly styleHeight: string;
    private readonly visibleAreas;
    private readonly nbGutters;
    areas: Array<IAreaData>;
    private minPercent;
    private isDragging;
    private containerSize;
    private areaASize;
    private areaBSize;
    private eventsDragFct;
    constructor(cdRef: ChangeDetectorRef, elementRef: ElementRef, renderer: Renderer);
    ngOnChanges(changes: SimpleChanges): void;
    addArea(component: SplitAreaDirective, orderUser: number | null, sizeUser: number | null, minPixel: number): void;
    updateArea(component: SplitAreaDirective, orderUser: number | null, sizeUser: number | null, minPixel: number): void;
    removeArea(area: SplitAreaDirective): void;
    hideArea(area: SplitAreaDirective): void;
    showArea(area: SplitAreaDirective): void;
    isLastVisibleArea(area: IAreaData): boolean;
    private refresh();
    private refreshStyleSizes();
    startDragging(startEvent: MouseEvent | TouchEvent, gutterOrder: number): void;
    private dragEvent(event, start, areaA, areaB);
    private drag(start, end, areaA, areaB);
    private stopDragging();
    notify(type: string): void;
    ngOnDestroy(): void;
}
