import { ElementRef } from '@angular/core';
import { IArea, IPoint, IAreaSnapshot, ISplitSideAbsorptionCapacity, IAreaAbsorptionCapacity } from './interface';
export declare function getPointFromEvent(event: MouseEvent | TouchEvent | KeyboardEvent): IPoint;
export declare function pointDeltaEquals(lhs: IPoint, rhs: IPoint, deltaPx: number): boolean;
export declare function getKeyboardEndpoint(event: KeyboardEvent, direction: 'horizontal' | 'vertical'): IPoint | null;
export declare function getElementPixelSize(elRef: ElementRef, direction: 'horizontal' | 'vertical'): number;
export declare function getInputBoolean(v: any): boolean;
export declare function getInputPositiveNumber<T>(v: any, defaultValue: T): number | T;
export declare function isUserSizesValid(unit: 'percent' | 'pixel', sizes: Array<number | null>): boolean;
export declare function getAreaMinSize(a: IArea): null | number;
export declare function getAreaMaxSize(a: IArea): null | number;
export declare function getGutterSideAbsorptionCapacity(unit: 'percent' | 'pixel', sideAreas: Array<IAreaSnapshot>, pixels: number, allAreasSizePixel: number): ISplitSideAbsorptionCapacity;
export declare function updateAreaSize(unit: 'percent' | 'pixel', item: IAreaAbsorptionCapacity): void;
