(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs'), require('rxjs/operators'), require('@angular/common'), require('@angular/platform-browser')) :
    typeof define === 'function' && define.amd ? define('angular-split', ['exports', '@angular/core', 'rxjs', 'rxjs/operators', '@angular/common', '@angular/platform-browser'], factory) :
    (factory((global['angular-split'] = {}),global.ng.core,global.rxjs,global.rxjs.operators,global.ng.common,global.ng.platformBrowser));
}(this, (function (exports,core,rxjs,operators,common,platformBrowser) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    /**
     * @param {?} event
     * @return {?}
     */
    function getPointFromEvent(event) {
        // TouchEvent
        if ((( /** @type {?} */(event))).touches !== undefined && (( /** @type {?} */(event))).touches.length > 0) {
            return {
                x: (( /** @type {?} */(event))).touches[0].clientX,
                y: (( /** @type {?} */(event))).touches[0].clientY,
            };
        }
        // MouseEvent
        else if ((( /** @type {?} */(event))).clientX !== undefined && (( /** @type {?} */(event))).clientY !== undefined) {
            return {
                x: (( /** @type {?} */(event))).clientX,
                y: (( /** @type {?} */(event))).clientY,
            };
        }
        return null;
    }
    /**
     * @param {?} elRef
     * @param {?} direction
     * @return {?}
     */
    function getPixelSize(elRef, direction) {
        return elRef.nativeElement[(direction === 'horizontal') ? 'offsetWidth' : 'offsetHeight'];
    }
    /**
     * @param {?} v
     * @return {?}
     */
    function getInputBoolean(v) {
        return (typeof (v) === 'boolean') ? v : (v === 'false' ? false : true);
    }
    /**
     * @param {?} total
     * @return {?}
     */
    function isValidTotalSize(total) {
        return total > .999 && total < 1.001;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    /**
     * angular-split
     *
     * Areas size are set in percentage of the split container.
     * Gutters size are set in pixels.
     *
     * So we set css 'flex-basis' property like this (where 0 <= area.size <= 1):
     *  calc( { area.size * 100 }% - { area.size * nbGutter * gutterSize }px );
     *
     * Examples with 3 visible areas and 2 gutters:
     *
     * |                     10px                   10px                                  |
     * |---------------------[]---------------------[]------------------------------------|
     * |  calc(20% - 4px)          calc(20% - 4px)              calc(60% - 12px)          |
     *
     *
     * |                          10px                        10px                        |
     * |--------------------------[]--------------------------[]--------------------------|
     * |  calc(33.33% - 6.667px)      calc(33.33% - 6.667px)      calc(33.33% - 6.667px)  |
     *
     *
     * |10px                                                  10px                        |
     * |[]----------------------------------------------------[]--------------------------|
     * |0                 calc(66.66% - 13.333px)                  calc(33%% - 6.667px)   |
     *
     *
     *  10px 10px                                                                         |
     * |[][]------------------------------------------------------------------------------|
     * |0 0                               calc(100% - 20px)                               |
     *
     */
    var SplitComponent = /** @class */ (function () {
        function SplitComponent(ngZone, elRef, cdRef, renderer) {
            this.ngZone = ngZone;
            this.elRef = elRef;
            this.cdRef = cdRef;
            this.renderer = renderer;
            this._direction = 'horizontal';
            ////
            this._gutterSize = 11;
            ////
            this._useTransition = false;
            ////
            this._disabled = false;
            ////
            this._dir = 'ltr';
            this.dragProgressSubject = new rxjs.Subject();
            this.dragProgress$ = this.dragProgressSubject.asObservable();
            ////
            this.isDragging = false;
            this.currentGutterNum = 0;
            this.startPoint = null;
            this.endPoint = null;
            this.displayedAreas = [];
            this.hidedAreas = [];
            this.dragListeners = [];
            this.dragStartValues = {
                sizePixelContainer: 0,
                sizePixelA: 0,
                sizePixelB: 0,
                sizePercentA: 0,
                sizePercentB: 0,
            };
            // To force adding default class, could be override by user @Input() or not
            this.direction = this._direction;
        }
        Object.defineProperty(SplitComponent.prototype, "direction", {
            get: /**
             * @return {?}
             */ function () {
                return this._direction;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                this._direction = (v === 'vertical') ? 'vertical' : 'horizontal';
                this.renderer.addClass(this.elRef.nativeElement, "is-" + this._direction);
                this.renderer.removeClass(this.elRef.nativeElement, "is-" + ((this._direction === 'vertical') ? 'horizontal' : 'vertical'));
                this.build(false, false);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "gutterSize", {
            get: /**
             * @return {?}
             */ function () {
                return this._gutterSize;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                v = Number(v);
                this._gutterSize = (!isNaN(v) && v > 0) ? v : 11;
                this.build(false, false);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "useTransition", {
            get: /**
             * @return {?}
             */ function () {
                return this._useTransition;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                this._useTransition = getInputBoolean(v);
                if (this._useTransition)
                    this.renderer.addClass(this.elRef.nativeElement, 'is-transition');
                else
                    this.renderer.removeClass(this.elRef.nativeElement, 'is-transition');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "disabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                this._disabled = getInputBoolean(v);
                if (this._disabled)
                    this.renderer.addClass(this.elRef.nativeElement, 'is-disabled');
                else
                    this.renderer.removeClass(this.elRef.nativeElement, 'is-disabled');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "dir", {
            get: /**
             * @return {?}
             */ function () {
                return this._dir;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                v = (v === 'rtl') ? 'rtl' : 'ltr';
                this._dir = v;
                this.renderer.setAttribute(this.elRef.nativeElement, 'dir', this._dir);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "dragStart", {
            get: /**
             * @return {?}
             */ function () {
                var _this = this;
                return new rxjs.Observable(function (subscriber) { return _this.dragStartSubscriber = subscriber; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "dragEnd", {
            get: /**
             * @return {?}
             */ function () {
                var _this = this;
                return new rxjs.Observable(function (subscriber) { return _this.dragEndSubscriber = subscriber; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "gutterClick", {
            get: /**
             * @return {?}
             */ function () {
                var _this = this;
                return new rxjs.Observable(function (subscriber) { return _this.gutterClickSubscriber = subscriber; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitComponent.prototype, "transitionEnd", {
            get: /**
             * @return {?}
             */ function () {
                var _this = this;
                return new rxjs.Observable(function (subscriber) { return _this.transitionEndSubscriber = subscriber; }).pipe(operators.debounceTime(20));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        SplitComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.ngZone.runOutsideAngular(function () {
                    // To avoid transition at first rendering
                    setTimeout(function () { return _this.renderer.addClass(_this.elRef.nativeElement, 'is-init'); });
                });
            };
        /**
         * @return {?}
         */
        SplitComponent.prototype.getNbGutters = /**
         * @return {?}
         */
            function () {
                return (this.displayedAreas.length === 0) ? 0 : this.displayedAreas.length - 1;
            };
        /**
         * @param {?} component
         * @return {?}
         */
        SplitComponent.prototype.addArea = /**
         * @param {?} component
         * @return {?}
         */
            function (component) {
                /** @type {?} */
                var newArea = {
                    component: component,
                    order: 0,
                    size: 0,
                };
                if (component.visible === true) {
                    this.displayedAreas.push(newArea);
                    this.build(true, true);
                }
                else {
                    this.hidedAreas.push(newArea);
                }
            };
        /**
         * @param {?} component
         * @return {?}
         */
        SplitComponent.prototype.removeArea = /**
         * @param {?} component
         * @return {?}
         */
            function (component) {
                if (this.displayedAreas.some(function (a) { return a.component === component; })) {
                    /** @type {?} */
                    var area = this.displayedAreas.find(function (a) { return a.component === component; });
                    this.displayedAreas.splice(this.displayedAreas.indexOf(area), 1);
                    this.build(true, true);
                }
                else if (this.hidedAreas.some(function (a) { return a.component === component; })) {
                    /** @type {?} */
                    var area = this.hidedAreas.find(function (a) { return a.component === component; });
                    this.hidedAreas.splice(this.hidedAreas.indexOf(area), 1);
                }
            };
        /**
         * @param {?} component
         * @param {?} resetOrders
         * @param {?} resetSizes
         * @return {?}
         */
        SplitComponent.prototype.updateArea = /**
         * @param {?} component
         * @param {?} resetOrders
         * @param {?} resetSizes
         * @return {?}
         */
            function (component, resetOrders, resetSizes) {
                // Only refresh if area is displayed (No need to check inside 'hidedAreas')
                /** @type {?} */
                var area = this.displayedAreas.find(function (a) { return a.component === component; });
                if (!area) {
                    return;
                }
                this.build(resetOrders, resetSizes);
            };
        /**
         * @param {?} component
         * @return {?}
         */
        SplitComponent.prototype.showArea = /**
         * @param {?} component
         * @return {?}
         */
            function (component) {
                var _a;
                /** @type {?} */
                var area = this.hidedAreas.find(function (a) { return a.component === component; });
                if (!area) {
                    return;
                }
                /** @type {?} */
                var areas = this.hidedAreas.splice(this.hidedAreas.indexOf(area), 1);
                (_a = this.displayedAreas).push.apply(_a, __spread(areas));
                this.build(true, true);
            };
        /**
         * @param {?} comp
         * @return {?}
         */
        SplitComponent.prototype.hideArea = /**
         * @param {?} comp
         * @return {?}
         */
            function (comp) {
                var _a;
                /** @type {?} */
                var area = this.displayedAreas.find(function (a) { return a.component === comp; });
                if (!area) {
                    return;
                }
                /** @type {?} */
                var areas = this.displayedAreas.splice(this.displayedAreas.indexOf(area), 1);
                areas.forEach(function (area) {
                    area.order = 0;
                    area.size = 0;
                });
                (_a = this.hidedAreas).push.apply(_a, __spread(areas));
                this.build(true, true);
            };
        /**
         * @return {?}
         */
        SplitComponent.prototype.getVisibleAreaSizes = /**
         * @return {?}
         */
            function () {
                return this.displayedAreas.map(function (a) { return a.size * 100; });
            };
        /**
         * @param {?} sizes
         * @return {?}
         */
        SplitComponent.prototype.setVisibleAreaSizes = /**
         * @param {?} sizes
         * @return {?}
         */
            function (sizes) {
                if (sizes.length !== this.displayedAreas.length) {
                    return false;
                }
                sizes = sizes.map(function (s) { return s / 100; });
                /** @type {?} */
                var total = sizes.reduce(function (total, v) { return total + v; }, 0);
                if (!isValidTotalSize(total)) {
                    return false;
                }
                this.displayedAreas.forEach(function (area, i) {
                    // @ts-ignore
                    area.component._size = sizes[i];
                });
                this.build(false, true);
                return true;
            };
        /**
         * @param {?} resetOrders
         * @param {?} resetSizes
         * @return {?}
         */
        SplitComponent.prototype.build = /**
         * @param {?} resetOrders
         * @param {?} resetSizes
         * @return {?}
         */
            function (resetOrders, resetSizes) {
                var _this = this;
                this.stopDragging();
                // ¤ AREAS ORDER
                if (resetOrders === true) {
                    // If user provided 'order' for each area, use it to sort them.
                    if (this.displayedAreas.every(function (a) { return a.component.order !== null; })) {
                        this.displayedAreas.sort(function (a, b) { return (( /** @type {?} */(a.component.order))) - (( /** @type {?} */(b.component.order))); });
                    }
                    // Then set real order with multiples of 2, numbers between will be used by gutters.
                    this.displayedAreas.forEach(function (area, i) {
                        area.order = i * 2;
                        area.component.setStyleOrder(area.order);
                    });
                }
                // ¤ AREAS SIZE PERCENT
                if (resetSizes === true) {
                    /** @type {?} */
                    var totalUserSize = ( /** @type {?} */(this.displayedAreas.reduce(function (total, s) { return s.component.size ? total + s.component.size : total; }, 0)));
                    // If user provided 'size' for each area and total == 1, use it.
                    if (this.displayedAreas.every(function (a) { return a.component.size !== null; }) && isValidTotalSize(totalUserSize)) {
                        this.displayedAreas.forEach(function (area) {
                            area.size = ( /** @type {?} */(area.component.size));
                        });
                    }
                    // Else set equal sizes for all areas.
                    else {
                        /** @type {?} */
                        var size_1 = 1 / this.displayedAreas.length;
                        this.displayedAreas.forEach(function (area) {
                            area.size = size_1;
                        });
                    }
                }
                // ¤ 
                // If some real area sizes are less than gutterSize, 
                // set them to zero and dispatch size to others.
                /** @type {?} */
                var percentToDispatch = 0;
                // Get container pixel size
                /** @type {?} */
                var containerSizePixel = getPixelSize(this.elRef, this.direction);
                this.displayedAreas.forEach(function (area) {
                    if (area.size * containerSizePixel < _this.gutterSize) {
                        percentToDispatch += area.size;
                        area.size = 0;
                    }
                });
                if (percentToDispatch > 0 && this.displayedAreas.length > 0) {
                    /** @type {?} */
                    var nbAreasNotZero = this.displayedAreas.filter(function (a) { return a.size !== 0; }).length;
                    if (nbAreasNotZero > 0) {
                        /** @type {?} */
                        var percentToAdd_1 = percentToDispatch / nbAreasNotZero;
                        this.displayedAreas.filter(function (a) { return a.size !== 0; }).forEach(function (area) {
                            area.size += percentToAdd_1;
                        });
                    }
                    // All area sizes (container percentage) are less than guterSize,
                    // It means containerSize < ngGutters * gutterSize
                    else {
                        this.displayedAreas[this.displayedAreas.length - 1].size = 1;
                    }
                }
                this.refreshStyleSizes();
                this.cdRef.markForCheck();
            };
        /**
         * @return {?}
         */
        SplitComponent.prototype.refreshStyleSizes = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var sumGutterSize = this.getNbGutters() * this.gutterSize;
                this.displayedAreas.forEach(function (area) {
                    area.component.setStyleFlexbasis("calc( " + area.size * 100 + "% - " + area.size * sumGutterSize + "px )");
                });
            };
        /**
         * @param {?} event
         * @param {?} gutterNum
         * @return {?}
         */
        SplitComponent.prototype.clickGutter = /**
         * @param {?} event
         * @param {?} gutterNum
         * @return {?}
         */
            function (event, gutterNum) {
                event.preventDefault();
                event.stopPropagation();
                if (this.startPoint && this.startPoint.x === event.clientX && this.startPoint.y === event.clientY) {
                    this.currentGutterNum = gutterNum;
                    this.notify('click');
                }
            };
        /**
         * @param {?} event
         * @param {?} gutterOrder
         * @param {?} gutterNum
         * @return {?}
         */
        SplitComponent.prototype.startDragging = /**
         * @param {?} event
         * @param {?} gutterOrder
         * @param {?} gutterNum
         * @return {?}
         */
            function (event, gutterOrder, gutterNum) {
                var _this = this;
                event.preventDefault();
                event.stopPropagation();
                this.startPoint = getPointFromEvent(event);
                if (!this.startPoint || this.disabled) {
                    return;
                }
                /** @type {?} */
                var areaA = this.displayedAreas.find(function (a) { return a.order === gutterOrder - 1; });
                /** @type {?} */
                var areaB = this.displayedAreas.find(function (a) { return a.order === gutterOrder + 1; });
                if (!areaA || !areaB) {
                    return;
                }
                this.dragStartValues.sizePixelContainer = getPixelSize(this.elRef, this.direction);
                this.dragStartValues.sizePixelA = getPixelSize(areaA.component.elRef, this.direction);
                this.dragStartValues.sizePixelB = getPixelSize(areaB.component.elRef, this.direction);
                this.dragStartValues.sizePercentA = areaA.size;
                this.dragStartValues.sizePercentB = areaB.size;
                this.currentGutterNum = gutterNum;
                this.ngZone.runOutsideAngular(function () {
                    _this.dragListeners.push(_this.renderer.listen('document', 'mouseup', _this.stopDragging.bind(_this)));
                    _this.dragListeners.push(_this.renderer.listen('document', 'touchend', _this.stopDragging.bind(_this)));
                    _this.dragListeners.push(_this.renderer.listen('document', 'touchcancel', _this.stopDragging.bind(_this)));
                    _this.dragListeners.push(_this.renderer.listen('document', 'mousemove', function (e) { return _this.dragEvent(e, areaA, areaB); }));
                    _this.dragListeners.push(_this.renderer.listen('document', 'touchmove', function (e) { return _this.dragEvent(e, areaA, areaB); }));
                });
                areaA.component.lockEvents();
                areaB.component.lockEvents();
                this.isDragging = true;
                this.renderer.addClass(this.elRef.nativeElement, 'is-dragging');
                this.renderer.addClass(this.gutterEls.toArray()[this.currentGutterNum - 1].nativeElement, 'is-dragged');
                this.notify('start');
            };
        /**
         * @param {?} event
         * @param {?} areaA
         * @param {?} areaB
         * @return {?}
         */
        SplitComponent.prototype.dragEvent = /**
         * @param {?} event
         * @param {?} areaA
         * @param {?} areaB
         * @return {?}
         */
            function (event, areaA, areaB) {
                event.preventDefault();
                event.stopPropagation();
                if (!this.isDragging) {
                    return;
                }
                this.endPoint = getPointFromEvent(event);
                if (!this.endPoint) {
                    return;
                }
                // ¤ AREAS SIZE PIXEL
                /** @type {?} */
                var offsetPixel = (this.direction === 'horizontal') ? (this.startPoint.x - this.endPoint.x) : (this.startPoint.y - this.endPoint.y);
                if (this.dir === 'rtl') {
                    offsetPixel = -offsetPixel;
                }
                /** @type {?} */
                var newSizePixelA = this.dragStartValues.sizePixelA - offsetPixel;
                /** @type {?} */
                var newSizePixelB = this.dragStartValues.sizePixelB + offsetPixel;
                if (newSizePixelA < this.gutterSize && newSizePixelB < this.gutterSize) {
                    // WTF.. get out of here!
                    return;
                }
                else if (newSizePixelA < this.gutterSize) {
                    newSizePixelB += newSizePixelA;
                    newSizePixelA = 0;
                }
                else if (newSizePixelB < this.gutterSize) {
                    newSizePixelA += newSizePixelB;
                    newSizePixelB = 0;
                }
                // ¤ AREAS SIZE PERCENT
                if (newSizePixelA === 0) {
                    areaB.size += areaA.size;
                    areaA.size = 0;
                }
                else if (newSizePixelB === 0) {
                    areaA.size += areaB.size;
                    areaB.size = 0;
                }
                else {
                    // NEW_PERCENT = START_PERCENT / START_PIXEL * NEW_PIXEL;
                    if (this.dragStartValues.sizePercentA === 0) {
                        areaB.size = this.dragStartValues.sizePercentB / this.dragStartValues.sizePixelB * newSizePixelB;
                        areaA.size = this.dragStartValues.sizePercentB - areaB.size;
                    }
                    else if (this.dragStartValues.sizePercentB === 0) {
                        areaA.size = this.dragStartValues.sizePercentA / this.dragStartValues.sizePixelA * newSizePixelA;
                        areaB.size = this.dragStartValues.sizePercentA - areaA.size;
                    }
                    else {
                        areaA.size = this.dragStartValues.sizePercentA / this.dragStartValues.sizePixelA * newSizePixelA;
                        areaB.size = (this.dragStartValues.sizePercentA + this.dragStartValues.sizePercentB) - areaA.size;
                    }
                }
                this.refreshStyleSizes();
                // If moved from starting point, notify progress
                if (this.startPoint.x !== this.endPoint.x || this.startPoint.y !== this.endPoint.y) {
                    this.notify('progress');
                }
            };
        /**
         * @param {?=} event
         * @return {?}
         */
        SplitComponent.prototype.stopDragging = /**
         * @param {?=} event
         * @return {?}
         */
            function (event) {
                var _this = this;
                if (event) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                if (this.isDragging === false) {
                    return;
                }
                this.displayedAreas.forEach(function (area) {
                    area.component.unlockEvents();
                });
                while (this.dragListeners.length > 0) {
                    /** @type {?} */
                    var fct = this.dragListeners.pop();
                    if (fct) {
                        fct();
                    }
                }
                // If moved from starting point, notify end
                if (event && this.endPoint && (this.startPoint.x !== this.endPoint.x || this.startPoint.y !== this.endPoint.y)) {
                    this.notify('end');
                }
                this.isDragging = false;
                this.renderer.removeClass(this.elRef.nativeElement, 'is-dragging');
                this.renderer.removeClass(this.gutterEls.toArray()[this.currentGutterNum - 1].nativeElement, 'is-dragged');
                // Needed to let (click)="clickGutter(...)" event run and verify if mouse moved or not
                this.ngZone.runOutsideAngular(function () {
                    setTimeout(function () {
                        _this.startPoint = null;
                        _this.endPoint = null;
                    });
                });
            };
        /**
         * @param {?} type
         * @return {?}
         */
        SplitComponent.prototype.notify = /**
         * @param {?} type
         * @return {?}
         */
            function (type) {
                var _this = this;
                /** @type {?} */
                var sizes = this.displayedAreas.map(function (a) { return a.size * 100; });
                if (type === 'start') {
                    if (this.dragStartSubscriber) {
                        this.ngZone.run(function () { return _this.dragStartSubscriber.next({ gutterNum: _this.currentGutterNum, sizes: sizes }); });
                    }
                }
                else if (type === 'end') {
                    if (this.dragEndSubscriber) {
                        this.ngZone.run(function () { return _this.dragEndSubscriber.next({ gutterNum: _this.currentGutterNum, sizes: sizes }); });
                    }
                }
                else if (type === 'click') {
                    if (this.gutterClickSubscriber) {
                        this.ngZone.run(function () { return _this.gutterClickSubscriber.next({ gutterNum: _this.currentGutterNum, sizes: sizes }); });
                    }
                }
                else if (type === 'transitionEnd') {
                    if (this.transitionEndSubscriber) {
                        this.ngZone.run(function () { return _this.transitionEndSubscriber.next(sizes); });
                    }
                }
                else if (type === 'progress') {
                    // Stay outside zone to allow users do what they want about change detection mechanism.
                    this.dragProgressSubject.next({ gutterNum: this.currentGutterNum, sizes: sizes });
                }
            };
        /**
         * @return {?}
         */
        SplitComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.stopDragging();
            };
        SplitComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'as-split',
                        changeDetection: core.ChangeDetectionStrategy.OnPush,
                        template: "\n        <ng-content></ng-content>\n        <ng-template ngFor [ngForOf]=\"displayedAreas\" let-index=\"index\" let-last=\"last\">\n            <div *ngIf=\"last === false\" \n                 #gutterEls\n                 class=\"as-split-gutter\"\n                 [style.flex-basis.px]=\"gutterSize\"\n                 [style.order]=\"index*2+1\"\n                 (as-split-undetected.click)=\"clickGutter($event, index+1)\"\n                 (as-split-undetected.mousedown)=\"startDragging($event, index*2+1, index+1)\"\n                 (as-split-undetected.touchstart)=\"startDragging($event, index*2+1, index+1)\">\n                <div class=\"as-split-gutter-icon\"></div>\n            </div>\n        </ng-template>",
                        styles: [":host{display:flex;flex-wrap:nowrap;justify-content:flex-start;align-items:stretch;overflow:hidden;width:100%;height:100%}:host>.as-split-gutter{flex-grow:0;flex-shrink:0;background-color:#eee;display:flex;align-items:center;justify-content:center}:host>.as-split-gutter>.as-split-gutter-icon{width:100%;height:100%;background-position:center center;background-repeat:no-repeat}:host ::ng-deep>.as-split-area{flex-grow:0;flex-shrink:0;overflow-x:hidden;overflow-y:auto}:host ::ng-deep>.as-split-area.is-hided{flex-basis:0!important;overflow-x:hidden;overflow-y:hidden}:host.is-horizontal{flex-direction:row}:host.is-horizontal>.as-split-gutter{flex-direction:row;cursor:col-resize;height:100%}:host.is-horizontal>.as-split-gutter>.as-split-gutter-icon{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAAIklEQVQoU2M4c+bMfxAGAgYYmwGrIIiDjrELjpo5aiZeMwF+yNnOs5KSvgAAAABJRU5ErkJggg==)}:host.is-horizontal ::ng-deep>.as-split-area{height:100%}:host.is-vertical{flex-direction:column}:host.is-vertical>.as-split-gutter{flex-direction:column;cursor:row-resize;width:100%}:host.is-vertical>.as-split-gutter .as-split-gutter-icon{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAFCAMAAABl/6zIAAAABlBMVEUAAADMzMzIT8AyAAAAAXRSTlMAQObYZgAAABRJREFUeAFjYGRkwIMJSeMHlBkOABP7AEGzSuPKAAAAAElFTkSuQmCC)}:host.is-vertical ::ng-deep>.as-split-area{width:100%}:host.is-vertical ::ng-deep>.as-split-area.is-hided{max-width:0}:host.is-disabled>.as-split-gutter{cursor:default}:host.is-disabled>.as-split-gutter .as-split-gutter-icon{background-image:url(\"\")}:host.is-transition.is-init:not(.is-dragging) ::ng-deep>.as-split-area,:host.is-transition.is-init:not(.is-dragging)>.as-split-gutter{transition:flex-basis .3s}"]
                    }] }
        ];
        /** @nocollapse */
        SplitComponent.ctorParameters = function () {
            return [
                { type: core.NgZone },
                { type: core.ElementRef },
                { type: core.ChangeDetectorRef },
                { type: core.Renderer2 }
            ];
        };
        SplitComponent.propDecorators = {
            direction: [{ type: core.Input }],
            gutterSize: [{ type: core.Input }],
            useTransition: [{ type: core.Input }],
            disabled: [{ type: core.Input }],
            dir: [{ type: core.Input }],
            dragStart: [{ type: core.Output }],
            dragEnd: [{ type: core.Output }],
            gutterClick: [{ type: core.Output }],
            transitionEnd: [{ type: core.Output }],
            gutterEls: [{ type: core.ViewChildren, args: ['gutterEls',] }]
        };
        return SplitComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    var SplitAreaDirective = /** @class */ (function () {
        function SplitAreaDirective(ngZone, elRef, renderer, split) {
            this.ngZone = ngZone;
            this.elRef = elRef;
            this.renderer = renderer;
            this.split = split;
            this._order = null;
            ////
            this._size = null;
            ////
            this._visible = true;
            this.lockListeners = [];
            this.renderer.addClass(this.elRef.nativeElement, 'as-split-area');
        }
        Object.defineProperty(SplitAreaDirective.prototype, "order", {
            get: /**
             * @return {?}
             */ function () {
                return this._order;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                v = Number(v);
                this._order = !isNaN(v) ? v : null;
                this.split.updateArea(this, true, false);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitAreaDirective.prototype, "size", {
            get: /**
             * @return {?}
             */ function () {
                return this._size;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                v = Number(v);
                this._size = (!isNaN(v) && v >= 0 && v <= 100) ? (v / 100) : null;
                this.split.updateArea(this, false, true);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SplitAreaDirective.prototype, "visible", {
            get: /**
             * @return {?}
             */ function () {
                return this._visible;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                this._visible = getInputBoolean(v);
                if (this._visible) {
                    this.split.showArea(this);
                    this.renderer.removeClass(this.elRef.nativeElement, 'is-hided');
                }
                else {
                    this.split.hideArea(this);
                    this.renderer.addClass(this.elRef.nativeElement, 'is-hided');
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        SplitAreaDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.split.addArea(this);
                this.ngZone.runOutsideAngular(function () {
                    _this.transitionListener = _this.renderer.listen(_this.elRef.nativeElement, 'transitionend', function (event) {
                        // Limit only flex-basis transition to trigger the event
                        if (event.propertyName === 'flex-basis') {
                            _this.split.notify('transitionEnd');
                        }
                    });
                });
            };
        /**
         * @param {?} value
         * @return {?}
         */
        SplitAreaDirective.prototype.setStyleOrder = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.renderer.setStyle(this.elRef.nativeElement, 'order', value);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        SplitAreaDirective.prototype.setStyleFlexbasis = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.renderer.setStyle(this.elRef.nativeElement, 'flex-basis', value);
            };
        /**
         * @return {?}
         */
        SplitAreaDirective.prototype.lockEvents = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.ngZone.runOutsideAngular(function () {
                    _this.lockListeners.push(_this.renderer.listen(_this.elRef.nativeElement, 'selectstart', function (e) { return false; }));
                    _this.lockListeners.push(_this.renderer.listen(_this.elRef.nativeElement, 'dragstart', function (e) { return false; }));
                });
            };
        /**
         * @return {?}
         */
        SplitAreaDirective.prototype.unlockEvents = /**
         * @return {?}
         */
            function () {
                while (this.lockListeners.length > 0) {
                    /** @type {?} */
                    var fct = this.lockListeners.pop();
                    if (fct) {
                        fct();
                    }
                }
            };
        /**
         * @return {?}
         */
        SplitAreaDirective.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.unlockEvents();
                if (this.transitionListener) {
                    this.transitionListener();
                }
                this.split.removeArea(this);
            };
        SplitAreaDirective.decorators = [
            { type: core.Directive, args: [{
                        selector: 'as-split-area, [as-split-area]'
                    },] }
        ];
        /** @nocollapse */
        SplitAreaDirective.ctorParameters = function () {
            return [
                { type: core.NgZone },
                { type: core.ElementRef },
                { type: core.Renderer2 },
                { type: SplitComponent }
            ];
        };
        SplitAreaDirective.propDecorators = {
            order: [{ type: core.Input }],
            size: [{ type: core.Input }],
            visible: [{ type: core.Input }]
        };
        return SplitAreaDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    /**
     * Credit to Michael Strobel from:
     * https://github.com/kryops/ng2-events
     */
    var UndetectedEventPlugin = /** @class */ (function () {
        function UndetectedEventPlugin() {
        }
        /**
         * @param {?} eventName
         * @return {?}
         */
        UndetectedEventPlugin.prototype.supports = /**
         * @param {?} eventName
         * @return {?}
         */
            function (eventName) {
                return eventName.indexOf('as-split-undetected.') === 0;
            };
        /**
         * @param {?} element
         * @param {?} eventName
         * @param {?} handler
         * @return {?}
         */
        UndetectedEventPlugin.prototype.addEventListener = /**
         * @param {?} element
         * @param {?} eventName
         * @param {?} handler
         * @return {?}
         */
            function (element, eventName, handler) {
                var _this = this;
                /** @type {?} */
                var realEventName = eventName.slice(20);
                return this.manager.getZone().runOutsideAngular(function () { return _this.manager.addEventListener(element, realEventName, handler); });
            };
        UndetectedEventPlugin.decorators = [
            { type: core.Injectable }
        ];
        return UndetectedEventPlugin;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    var AngularSplitModule = /** @class */ (function () {
        function AngularSplitModule() {
        }
        /**
         * @return {?}
         */
        AngularSplitModule.forRoot = /**
         * @return {?}
         */
            function () {
                return {
                    ngModule: AngularSplitModule,
                    providers: [{
                            provide: platformBrowser.EVENT_MANAGER_PLUGINS,
                            useClass: UndetectedEventPlugin,
                            multi: true
                        }]
                };
            };
        /**
         * @return {?}
         */
        AngularSplitModule.forChild = /**
         * @return {?}
         */
            function () {
                return {
                    ngModule: AngularSplitModule,
                    providers: []
                };
            };
        AngularSplitModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [
                            common.CommonModule
                        ],
                        declarations: [
                            SplitComponent,
                            SplitAreaDirective,
                        ],
                        exports: [
                            SplitComponent,
                            SplitAreaDirective,
                        ]
                    },] }
        ];
        return AngularSplitModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */

    exports.AngularSplitModule = AngularSplitModule;
    exports.SplitComponent = SplitComponent;
    exports.SplitAreaDirective = SplitAreaDirective;
    exports.ɵa = UndetectedEventPlugin;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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