/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
/**
 * Credit to Michael Strobel from:
 * https://github.com/kryops/ng2-events
 */
export class UndetectedEventPlugin {
    /**
     * @param {?} eventName
     * @return {?}
     */
    supports(eventName) {
        return eventName.indexOf('as-split-undetected.') === 0;
    }
    /**
     * @param {?} element
     * @param {?} eventName
     * @param {?} handler
     * @return {?}
     */
    addEventListener(element, eventName, handler) {
        /** @type {?} */
        const realEventName = eventName.slice(20);
        return this.manager.getZone().runOutsideAngular(() => this.manager.addEventListener(element, realEventName, handler));
    }
}
UndetectedEventPlugin.decorators = [
    { type: Injectable }
];
if (false) {
    /** @type {?} */
    UndetectedEventPlugin.prototype.manager;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiVW5kZXRlY3RlZEV2ZW50UGx1Z2luLmpzIiwic291cmNlUm9vdCI6Im5nOi8vYW5ndWxhci1zcGxpdC8iLCJzb3VyY2VzIjpbImxpYi9zZXJ2aWNlL1VuZGV0ZWN0ZWRFdmVudFBsdWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQzs7Ozs7QUFRM0MsTUFBTSxPQUFPLHFCQUFxQjs7Ozs7SUFHOUIsUUFBUSxDQUFDLFNBQWlCO1FBQ3RCLE9BQU8sU0FBUyxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMzRCxDQUFDOzs7Ozs7O0lBRUQsZ0JBQWdCLENBQUMsT0FBb0IsRUFBRSxTQUFpQixFQUFFLE9BQWlCOztjQUNqRSxhQUFhLEdBQUcsU0FBUyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7UUFFekMsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFDLGlCQUFpQixDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLGFBQWEsRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzFILENBQUM7OztZQVpKLFVBQVU7Ozs7SUFFUCx3Q0FBc0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IEV2ZW50TWFuYWdlciB9IGZyb20gJ0Bhbmd1bGFyL3BsYXRmb3JtLWJyb3dzZXInO1xyXG5cclxuLyoqXHJcbiAqIENyZWRpdCB0byBNaWNoYWVsIFN0cm9iZWwgZnJvbTpcclxuICogaHR0cHM6Ly9naXRodWIuY29tL2tyeW9wcy9uZzItZXZlbnRzXHJcbiAqL1xyXG5ASW5qZWN0YWJsZSgpXHJcbmV4cG9ydCBjbGFzcyBVbmRldGVjdGVkRXZlbnRQbHVnaW4ge1xyXG4gICAgbWFuYWdlcjogRXZlbnRNYW5hZ2VyO1xyXG5cclxuICAgIHN1cHBvcnRzKGV2ZW50TmFtZTogc3RyaW5nKTogYm9vbGVhbiB7XHJcbiAgICAgICAgcmV0dXJuIGV2ZW50TmFtZS5pbmRleE9mKCdhcy1zcGxpdC11bmRldGVjdGVkLicpID09PSAwO1xyXG4gICAgfVxyXG5cclxuICAgIGFkZEV2ZW50TGlzdGVuZXIoZWxlbWVudDogSFRNTEVsZW1lbnQsIGV2ZW50TmFtZTogc3RyaW5nLCBoYW5kbGVyOiBGdW5jdGlvbik6IEZ1bmN0aW9uIHtcclxuICAgICAgICBjb25zdCByZWFsRXZlbnROYW1lID0gZXZlbnROYW1lLnNsaWNlKDIwKTtcclxuXHJcbiAgICAgICAgcmV0dXJuIHRoaXMubWFuYWdlci5nZXRab25lKCkucnVuT3V0c2lkZUFuZ3VsYXIoKCkgPT4gdGhpcy5tYW5hZ2VyLmFkZEV2ZW50TGlzdGVuZXIoZWxlbWVudCwgcmVhbEV2ZW50TmFtZSwgaGFuZGxlcikpO1xyXG4gICAgfVxyXG59Il19