/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */
/**
 * @param {?} event
 * @return {?}
 */
export function getPointFromEvent(event) {
    // TouchEvent
    if (((/** @type {?} */ (event))).touches !== undefined && ((/** @type {?} */ (event))).touches.length > 0) {
        return {
            x: ((/** @type {?} */ (event))).touches[0].clientX,
            y: ((/** @type {?} */ (event))).touches[0].clientY,
        };
    }
    // MouseEvent
    else if (((/** @type {?} */ (event))).clientX !== undefined && ((/** @type {?} */ (event))).clientY !== undefined) {
        return {
            x: ((/** @type {?} */ (event))).clientX,
            y: ((/** @type {?} */ (event))).clientY,
        };
    }
    return null;
}
/**
 * @param {?} elRef
 * @param {?} direction
 * @return {?}
 */
export function getPixelSize(elRef, direction) {
    return elRef.nativeElement[(direction === 'horizontal') ? 'offsetWidth' : 'offsetHeight'];
}
/**
 * @param {?} v
 * @return {?}
 */
export function getInputBoolean(v) {
    return (typeof (v) === 'boolean') ? v : (v === 'false' ? false : true);
}
/**
 * @param {?} total
 * @return {?}
 */
export function isValidTotalSize(total) {
    return total > .999 && total < 1.001;
}
//# sourceMappingURL=data:application/json;base64,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