/*!
 * angular-translate - v2.11.0 - 2016-03-20
 * 
 * Copyright (c) 2016 The angular-translate team, Pascal Precht; Licensed MIT
 */
!function(a,b){"function"==typeof define&&define.amd?
// AMD. Register as an anonymous module unless amdModuleId is set
define([],function(){return b()}):"object"==typeof exports?
// Node. Does not work with strict CommonJS, but
// only CommonJS-like environments that support module.exports,
// like Node.
module.exports=b():b()}(this,function(){function a(){"use strict";/**
   * @constructor
   * @name Part
   *
   * @description
   * Represents Part object to add and set parts at runtime.
   */
function a(a,b){this.name=a,this.isActive=!0,this.tables={},this.priority=b||0}function b(a){return Object.prototype.hasOwnProperty.call(g,a)}function c(a){return angular.isString(a)&&""!==a}function d(a){if(!c(a))throw new TypeError("Invalid type of a first argument, a non-empty string expected.");return b(a)&&g[a].isActive}function e(a,b){for(var c in b)b[c]&&b[c].constructor&&b[c].constructor===Object?(a[c]=a[c]||{},e(a[c],b[c])):a[c]=b[c];return a}function f(){var a=[];for(var b in g)g[b].isActive&&a.push(g[b]);return a.sort(function(a,b){return a.priority-b.priority}),a}/**
   * @name parseUrl
   * @method
   *
   * @description
   * Returns a parsed url template string and replaces given target lang
   * and part name it.
   *
   * @param {string|function} urlTemplate - Either a string containing an url pattern (with
   *                                        '{part}' and '{lang}') or a function(part, lang)
   *                                        returning a string.
   * @param {string} targetLang - Language key for language to be used.
   * @return {string} Parsed url template string
   */
a.prototype.parseUrl=function(a,b){return angular.isFunction(a)?a(this.name,b):a.replace(/\{part\}/g,this.name).replace(/\{lang\}/g,b)},a.prototype.getTable=function(a,b,c,d,e,f){if(this.tables[a])return b.when(this.tables[a]);var g=this;return c(angular.extend({method:"GET",url:this.parseUrl(e,a)},d)).then(function(b){return g.tables[a]=b.data,b.data},function(){return f?f(g.name,a).then(function(b){return g.tables[a]=b,b},function(){return b.reject(g.name)}):b.reject(g.name)})};var g={};/**
   * @ngdoc function
   * @name pascalprecht.translate.$translatePartialLoaderProvider#addPart
   * @methodOf pascalprecht.translate.$translatePartialLoaderProvider
   *
   * @description
   * Registers a new part of the translation table to be loaded once the
   * `angular-translate` gets into runtime phase. It does not actually load any
   * translation data, but only registers a part to be loaded in the future.
   *
   * @param {string} name A name of the part to add
   * @param {int} [priority=0] Sets the load priority of this part.
   *
   * @returns {object} $translatePartialLoaderProvider, so this method is chainable
   * @throws {TypeError} The method could throw a **TypeError** if you pass the param
   * of the wrong type. Please, note that the `name` param has to be a
   * non-empty **string**.
   */
this.addPart=function(d,e){if(!c(d))throw new TypeError("Couldn't add part, part name has to be a string!");return b(d)||(g[d]=new a(d,e)),g[d].isActive=!0,this},/**
   * @ngdocs function
   * @name pascalprecht.translate.$translatePartialLoaderProvider#setPart
   * @methodOf pascalprecht.translate.$translatePartialLoaderProvider
   *
   * @description
   * Sets a translation table to the specified part. This method does not make the
   * specified part available, but only avoids loading this part from the server.
   *
   * @param {string} lang A language of the given translation table
   * @param {string} part A name of the target part
   * @param {object} table A translation table to set to the specified part
   *
   * @return {object} $translatePartialLoaderProvider, so this method is chainable
   * @throws {TypeError} The method could throw a **TypeError** if you pass params
   * of the wrong type. Please, note that the `lang` and `part` params have to be a
   * non-empty **string**s and the `table` param has to be an object.
   */
this.setPart=function(d,e,f){if(!c(d))throw new TypeError("Couldn't set part.`lang` parameter has to be a string!");if(!c(e))throw new TypeError("Couldn't set part.`part` parameter has to be a string!");if("object"!=typeof f||null===f)throw new TypeError("Couldn't set part. `table` parameter has to be an object!");return b(e)||(g[e]=new a(e),g[e].isActive=!1),g[e].tables[d]=f,this},/**
   * @ngdoc function
   * @name pascalprecht.translate.$translatePartialLoaderProvider#deletePart
   * @methodOf pascalprecht.translate.$translatePartialLoaderProvider
   *
   * @description
   * Removes the previously added part of the translation data. So, `angular-translate` will not
   * load it at the startup.
   *
   * @param {string} name A name of the part to delete
   *
   * @returns {object} $translatePartialLoaderProvider, so this method is chainable
   *
   * @throws {TypeError} The method could throw a **TypeError** if you pass the param of the wrong
   * type. Please, note that the `name` param has to be a non-empty **string**.
   */
this.deletePart=function(a){if(!c(a))throw new TypeError("Couldn't delete part, first arg has to be string.");return b(a)&&(g[a].isActive=!1),this},/**
   * @ngdoc function
   * @name pascalprecht.translate.$translatePartialLoaderProvider#isPartAvailable
   * @methodOf pascalprecht.translate.$translatePartialLoaderProvider
   *
   * @description
   * Checks if the specific part is available. A part becomes available after it was added by the
   * `addPart` method. Available parts would be loaded from the server once the `angular-translate`
   * asks the loader to that.
   *
   * @param {string} name A name of the part to check
   *
   * @returns {boolean} Returns **true** if the part is available now and **false** if not.
   *
   * @throws {TypeError} The method could throw a **TypeError** if you pass the param of the wrong
   * type. Please, note that the `name` param has to be a non-empty **string**.
   */
this.isPartAvailable=d,/**
   * @ngdoc object
   * @name pascalprecht.translate.$translatePartialLoader
   *
   * @requires $q
   * @requires $http
   * @requires $injector
   * @requires $rootScope
   * @requires $translate
   *
   * @description
   *
   * @param {object} options Options object
   *
   * @throws {TypeError}
   */
this.$get=["$rootScope","$injector","$q","$http",function(h,i,j,k){/**
     * @ngdoc event
     * @name pascalprecht.translate.$translatePartialLoader#$translatePartialLoaderStructureChanged
     * @eventOf pascalprecht.translate.$translatePartialLoader
     * @eventType broadcast on root scope
     *
     * @description
     * A $translatePartialLoaderStructureChanged event is called when a state of the loader was
     * changed somehow. It could mean either some part is added or some part is deleted. Anyway when
     * you get this event the translation table is not longer current and has to be updated.
     *
     * @param {string} name A name of the part which is a reason why the event was fired
     */
var l=function(a){if(!c(a.key))throw new TypeError("Unable to load data, a key is not a non-empty string.");if(!c(a.urlTemplate)&&!angular.isFunction(a.urlTemplate))throw new TypeError("Unable to load data, a urlTemplate is not a non-empty string or not a function.");var b=a.loadFailureHandler;if(void 0!==b){if(!angular.isString(b))throw new Error("Unable to load data, a loadFailureHandler is not a string.");b=i.get(b)}var d=[],g=f();return angular.forEach(g,function(c){d.push(c.getTable(a.key,j,k,a.$http,a.urlTemplate,b)),c.urlTemplate=a.urlTemplate}),j.all(d).then(function(){var b={};return g=f(),angular.forEach(g,function(c){e(b,c.tables[a.key])}),b},function(){return j.reject(a.key)})};/**
     * @ngdoc function
     * @name pascalprecht.translate.$translatePartialLoader#addPart
     * @methodOf pascalprecht.translate.$translatePartialLoader
     *
     * @description
     * Registers a new part of the translation table. This method does not actually perform any xhr
     * requests to get translation data. The new parts will be loaded in order of priority from the server next time
     * `angular-translate` asks the loader to load translations.
     *
     * @param {string} name A name of the part to add
     * @param {int} [priority=0] Sets the load priority of this part.
     *
     * @returns {object} $translatePartialLoader, so this method is chainable
     *
     * @fires {$translatePartialLoaderStructureChanged} The $translatePartialLoaderStructureChanged
     * event would be fired by this method in case the new part affected somehow on the loaders
     * state. This way it means that there are a new translation data available to be loaded from
     * the server.
     *
     * @throws {TypeError} The method could throw a **TypeError** if you pass the param of the wrong
     * type. Please, note that the `name` param has to be a non-empty **string**.
     */
/**
     * @ngdoc function
     * @name pascalprecht.translate.$translatePartialLoader#deletePart
     * @methodOf pascalprecht.translate.$translatePartialLoader
     *
     * @description
     * Deletes the previously added part of the translation data. The target part could be deleted
     * either logically or physically. When the data is deleted logically it is not actually deleted
     * from the browser, but the loader marks it as not active and prevents it from affecting on the
     * translations. If the deleted in such way part is added again, the loader will use the
     * previously loaded data rather than loading it from the server once more time. But if the data
     * is deleted physically, the loader will completely remove all information about it. So in case
     * of recycling this part will be loaded from the server again.
     *
     * @param {string} name A name of the part to delete
     * @param {boolean=} [removeData=false] An indicator if the loader has to remove a loaded
     * translation data physically. If the `removeData` if set to **false** the loaded data will not be
     * deleted physically and might be reused in the future to prevent an additional xhr requests.
     *
     * @returns {object} $translatePartialLoader, so this method is chainable
     *
     * @fires {$translatePartialLoaderStructureChanged} The $translatePartialLoaderStructureChanged
     * event would be fired by this method in case a part deletion process affects somehow on the
     * loaders state. This way it means that some part of the translation data is now deprecated and
     * the translation table has to be recompiled with the remaining translation parts.
     *
     * @throws {TypeError} The method could throw a **TypeError** if you pass some param of the
     * wrong type. Please, note that the `name` param has to be a non-empty **string** and
     * the `removeData` param has to be either **undefined** or **boolean**.
     */
/**
     * @ngdoc function
     * @name pascalprecht.translate.$translatePartialLoader#isPartLoaded
     * @methodOf pascalprecht.translate.$translatePartialLoader
     *
     * @description
     * Checks if the registered translation part is loaded into the translation table.
     *
     * @param {string} name A name of the part
     * @param {string} lang A key of the language
     *
     * @returns {boolean} Returns **true** if the translation of the part is loaded to the translation table and **false** if not.
     *
     * @throws {TypeError} The method could throw a **TypeError** if you pass the param of the wrong
     * type. Please, note that the `name` and `lang` params have to be non-empty **string**.
     */
/**
     * @ngdoc function
     * @name pascalprecht.translate.$translatePartialLoader#getRegisteredParts
     * @methodOf pascalprecht.translate.$translatePartialLoader
     *
     * @description
     * Gets names of the parts that were added with the `addPart`.
     *
     * @returns {array} Returns array of registered parts, if none were registered then an empty array is returned.
     */
/**
     * @ngdoc function
     * @name pascalprecht.translate.$translatePartialLoader#isPartAvailable
     * @methodOf pascalprecht.translate.$translatePartialLoader
     *
     * @description
     * Checks if a target translation part is available. The part becomes available just after it was
     * added by the `addPart` method. Part's availability does not mean that it was loaded from the
     * server, but only that it was added to the loader. The available part might be loaded next
     * time the loader is called.
     *
     * @param {string} name A name of the part to delete
     *
     * @returns {boolean} Returns **true** if the part is available now and **false** if not.
     *
     * @throws {TypeError} The method could throw a **TypeError** if you pass the param of the wrong
     * type. Please, note that the `name` param has to be a non-empty **string**.
     */
return l.addPart=function(d,e){if(!c(d))throw new TypeError("Couldn't add part, first arg has to be a string");return b(d)?g[d].isActive||(g[d].isActive=!0,h.$emit("$translatePartialLoaderStructureChanged",d)):(g[d]=new a(d,e),h.$emit("$translatePartialLoaderStructureChanged",d)),l},l.deletePart=function(a,d){if(!c(a))throw new TypeError("Couldn't delete part, first arg has to be string");if(void 0===d)d=!1;else if("boolean"!=typeof d)throw new TypeError("Invalid type of a second argument, a boolean expected.");if(b(a)){var e=g[a].isActive;if(d){var f=i.get("$translate"),j=f.loaderCache();"string"==typeof j&&(
// getting on-demand instance of loader
j=i.get(j)),
// Purging items from cache...
"object"==typeof j&&angular.forEach(g[a].tables,function(b,c){j.remove(g[a].parseUrl(g[a].urlTemplate,c))}),delete g[a]}else g[a].isActive=!1;e&&h.$emit("$translatePartialLoaderStructureChanged",a)}return l},l.isPartLoaded=function(a,b){return angular.isDefined(g[a])&&angular.isDefined(g[a].tables[b])},l.getRegisteredParts=function(){var a=[];return angular.forEach(g,function(b){b.isActive&&a.push(b.name)}),a},l.isPartAvailable=d,l}]}return angular.module("pascalprecht.translate").provider("$translatePartialLoader",a),a.displayName="$translatePartialLoader","pascalprecht.translate"});