import { Renderer } from '@angular/core';
import { TreeNode } from './tree-node.model';
import { TreeOptions } from './tree-options.model';
import { TreeVirtualScroll } from './tree-virtual-scroll.model';
import { ITreeModel } from '../defs/api';
export declare class TreeModel implements ITreeModel {
    renderer: Renderer;
    static focusedTree: any;
    options: TreeOptions;
    nodes: any[];
    roots: TreeNode[];
    expandedNodeIds: {
        [id: string]: boolean;
    };
    activeNodeIds: {
        [id: string]: boolean;
    };
    hiddenNodeIds: {
        [id: string]: boolean;
    };
    focusedNodeId: string;
    virtualRoot: TreeNode;
    firstUpdate: boolean;
    virtualScroll: TreeVirtualScroll;
    eventNames: string[];
    private _treeNodeContentComponent;
    private _loadingComponent;
    private events;
    constructor(renderer: Renderer);
    setData({nodes, options, events}: {
        nodes: any;
        options: any;
        events: any;
    }): void;
    update(): void;
    private _calculateExpandedNodes(startNode?);
    fireEvent(event: any): void;
    subscribe(eventName: any, fn: any): void;
    getFocusedNode(): TreeNode;
    setFocusedNode(node: any): void;
    getActiveNode(): TreeNode;
    getActiveNodes(): TreeNode[];
    getVisibleRoots(): TreeNode[];
    getFirstRoot(skipHidden?: boolean): any;
    getLastRoot(skipHidden?: boolean): any;
    readonly isFocused: boolean;
    isNodeFocused(node: any): boolean;
    setFocus(value: any): void;
    isEmptyTree(): boolean;
    readonly focusedNode: any;
    readonly expandedNodes: any;
    readonly activeNodes: any;
    getNodeByPath(path: any[], startNode?: any): TreeNode;
    getNodeById(id: any): any;
    getNodeBy(predicate: any, startNode?: any): any;
    doForAll(fn: any): void;
    focusNextNode(): void;
    focusPreviousNode(): void;
    focusDrillDown(): void;
    focusDrillUp(): void;
    isActive(node: any): boolean;
    setActiveNode(node: any, value: any, multi?: boolean): void;
    _setActiveNodeSingle(node: any, value: any): void;
    _setActiveNodeMulti(node: any, value: any): void;
    isExpanded(node: any): boolean;
    setExpandedNode(node: any, value: any): void;
    expandAll(): void;
    collapseAll(): void;
    isHidden(node: any): boolean;
    setIsHidden(node: any, value: any): void;
    performKeyAction(node: any, $event: any): boolean;
    filterNodes(filter: any, autoShow?: boolean): void;
    private _filterNode(ids, node, filterFn, autoShow);
    clearFilter(): void;
    private _canMoveNode(node, fromIndex, to);
    moveNode(node: any, to: any): void;
}
