/*!
 * ui-grid - v4.12.2 - 2023-01-23
* http://ui-grid.info/
 * Copyright (c) 2023 ; License: MIT 
 */
!function(){"use strict";var e=angular.module("ui.grid.importer",["ui.grid"]);e.constant("uiGridImporterConstants",{featureName:"importer"}),e.service("uiGridImporterService",["$q","uiGridConstants","uiGridImporterConstants","gridUtil","$compile","$interval","i18nService","$window",function(e,i,r,o,t,n,a,l){var s={initializeGrid:function(e,r){r.importer={$scope:e},this.defaultGridOptions(r.options);var e={importer:{}},t={importer:{importFile:function(e){s.importThisFile(r,e)}}};r.api.registerEventsFromObject(e),r.api.registerMethodsFromObject(t),r.options.enableImporter&&r.options.importerShowMenu&&(r.api.core.addToGridMenu?s.addToMenu(r):n(function(){r.api.core.addToGridMenu&&s.addToMenu(r)},100,1))},defaultGridOptions:function(e){e.enableImporter||void 0===e.enableImporter?l.hasOwnProperty("File")&&l.hasOwnProperty("FileReader")&&l.hasOwnProperty("FileList")&&l.hasOwnProperty("Blob")?e.enableImporter=!0:(o.logError("The File APIs are not fully supported in this browser, grid importer cannot be used."),e.enableImporter=!1):e.enableImporter=!1,e.importerProcessHeaders=e.importerProcessHeaders||s.processHeaders,e.importerHeaderFilter=e.importerHeaderFilter||function(e){return e},e.importerErrorCallback&&"function"==typeof e.importerErrorCallback||delete e.importerErrorCallback,!0!==e.enableImporter||e.importerDataAddCallback||(o.logError("You have not set an importerDataAddCallback, importer is disabled"),e.enableImporter=!1),e.importerShowMenu=!1!==e.importerShowMenu,e.importerObjectCallback=e.importerObjectCallback||function(e,r){return r}},addToMenu:function(e){e.api.core.addToGridMenu(e,[{title:a.getSafeText("gridMenu.importerTitle"),order:150},{templateUrl:"ui-grid/importerMenuItemContainer",action:function(){this.grid.api.importer.importAFile(e)},order:151}])},importThisFile:function(e,r){var t;r?(t=new FileReader,"application/json"===r.type?t.onload=s.importJsonClosure(e):t.onload=s.importCsvClosure(e),t.readAsText(r)):o.logError("No file object provided to importThisFile, should be impossible, aborting")},importJsonClosure:function(i){return function(e){var r,t=[],e=s.parseJson(i,e);null!==e&&(e.forEach(function(e){r=s.newObject(i),angular.extend(r,e),r=i.options.importerObjectCallback(i,r),t.push(r)}),s.addObjects(i,t))}},parseJson:function(r,t){var e;try{e=JSON.parse(t.target.result)}catch(e){return void s.alertError(r,"importer.invalidJson","File could not be processed, is it valid json? Content was: ",t.target.result)}return Array.isArray(e)?e:(s.alertError(r,"importer.jsonNotarray","Import failed, file is not an array, file was: ",t.target.result),[])},importCsvClosure:function(t){return function(e){var r=s.parseCsv(e);!r||r.length<1?s.alertError(t,"importer.invalidCsv","File could not be processed, is it valid csv? Content was: ",e.target.result):(r=s.createCsvObjects(t,r))&&0!==r.length?s.addObjects(t,r):s.alertError(t,"importer.noObjects","Objects were not able to be derived, content was: ",e.target.result)}},parseCsv:function(e){e=e.target.result;return CSV.parse(e)},createCsvObjects:function(r,e){var t,i,o=r.options.importerProcessHeaders(r,e.shift());return o&&0!==o.length?(t=[],e.forEach(function(e){i=s.newObject(r),null!==e&&e.forEach(function(e,r){null!==o[r]&&(i[o[r]]=e)}),i=r.options.importerObjectCallback(r,i),t.push(i)}),t):(s.alertError(r,"importer.noHeaders","Column names could not be derived, content was: ",e),[])},processHeaders:function(e,r){var t,i=[];return e.options.columnDefs&&0!==e.options.columnDefs.length?(t=s.flattenColumnDefs(e,e.options.columnDefs),r.forEach(function(e){t[e]?i.push(t[e]):t[e.toLowerCase()]?i.push(t[e.toLowerCase()]):i.push(null)})):r.forEach(function(e){i.push(e.replace(/[^0-9a-zA-Z\-_]/g,"_"))}),i},flattenColumnDefs:function(r,e){var t={};return e.forEach(function(e){e.name&&(t[e.name]=e.field||e.name,t[e.name.toLowerCase()]=e.field||e.name),e.field&&(t[e.field]=e.field||e.name,t[e.field.toLowerCase()]=e.field||e.name),e.displayName&&(t[e.displayName]=e.field||e.name,t[e.displayName.toLowerCase()]=e.field||e.name),e.displayName&&r.options.importerHeaderFilter&&(t[r.options.importerHeaderFilter(e.displayName)]=e.field||e.name,t[r.options.importerHeaderFilter(e.displayName).toLowerCase()]=e.field||e.name)}),t},addObjects:function(e,r){var t;e.api.rowEdit&&(t=e.registerDataChangeCallback(function(){e.api.rowEdit.setRowsDirty(r),t()},[i.dataChange.ROW]),e.importer.$scope.$on("$destroy",t)),e.importer.$scope.$apply(e.options.importerDataAddCallback(e,r))},newObject:function(e){return void 0!==e.options&&void 0!==e.options.importerNewObject?new e.options.importerNewObject:{}},alertError:function(e,r,t,i){e.options.importerErrorCallback?e.options.importerErrorCallback(e,r,t,i):(l.alert(a.getSafeText(r)),o.logError(t+i))}};return s}]),e.directive("uiGridImporter",["uiGridImporterConstants","uiGridImporterService","gridUtil","$compile",function(e,o,r,t){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(e,r,t,i){o.initializeGrid(e,i.grid)}}}]),e.directive("uiGridImporterMenuItem",["uiGridImporterConstants","uiGridImporterService","gridUtil","$compile",function(e,n,a,r){return{replace:!0,priority:0,require:"?^uiGrid",scope:!1,templateUrl:"ui-grid/importerMenuItem",link:function(e,r,t,i){var o;r=r[0].querySelectorAll(".ui-grid-importer-file-chooser");1!==r.length?a.logError("Found > 1 or < 1 file choosers within the menu item, error, cannot continue"):r[0].addEventListener("change",function(e){var r;(e=e.srcElement||e.target)&&e.files&&1===e.files.length&&(r=e.files[0],void 0!==i&&i?(o=i.grid,n.importThisFile(o,r),e.form.reset()):a.logError("Could not import file because UI Grid was not found."))},!1)}}}])}(),angular.module("ui.grid.importer").run(["$templateCache",function(e){"use strict";e.put("ui-grid/importerMenuItem",'<li class="ui-grid-menu-item"><form><input class="ui-grid-importer-file-chooser" type="file" id="files" name="files[]"></form></li>'),e.put("ui-grid/importerMenuItemContainer","<div ui-grid-importer-menu-item></div>")}]);