/*!
 * ui-grid - v4.12.7 - 2024-04-12
* http://ui-grid.info/
 * Copyright (c) 2024 ; License: MIT 
 */
!function(){"use strict";var e=angular.module("ui.grid.cellNav",["ui.grid"]);e.constant("uiGridCellNavConstants",{FEATURE_NAME:"gridCellNav",CELL_NAV_EVENT:"cellNav",direction:{LEFT:0,RIGHT:1,UP:2,DOWN:3,PG_UP:4,PG_DOWN:5},EVENT_TYPE:{KEYDOWN:0,CLICK:1,CLEAR:2}}),e.factory("uiGridCellNavFactory",["uiGridCellNavConstants","GridRowColumn",function(i,r){function e(e,l,o,i){this.rows=e.visibleRowCache,this.columns=l.visibleColumnCache,this.leftColumns=o?o.visibleColumnCache:[],this.rightColumns=i?i.visibleColumnCache:[],this.bodyContainer=e}return e.prototype.getFocusableCols=function(){return this.leftColumns.concat(this.columns,this.rightColumns).filter(function(e){return e.colDef.allowCellFocus})},e.prototype.getFocusableRows=function(){return this.rows.filter(function(e){return!1!==e.allowCellFocus})},e.prototype.getNextRowCol=function(e,l,o){switch(e){case i.direction.LEFT:return this.getRowColLeft(l,o);case i.direction.RIGHT:return this.getRowColRight(l,o);case i.direction.UP:return this.getRowColUp(l,o);case i.direction.DOWN:return this.getRowColDown(l,o);case i.direction.PG_UP:return this.getRowColPageUp(l,o);case i.direction.PG_DOWN:return this.getRowColPageDown(l,o)}},e.prototype.initializeSelection=function(){var e=this.getFocusableCols(),l=this.getFocusableRows();return 0===e.length||0===l.length?null:new r(l[0],e[0])},e.prototype.getRowColLeft=function(e,l){var o=this.getFocusableCols(),i=this.getFocusableRows(),l=o.indexOf(l),n=i.indexOf(e),t=0===(l=-1===l?1:l)?o.length-1:l-1;return new r(!(l<=t)||0===n?e:i[n-1],o[t])},e.prototype.getRowColRight=function(e,l){var o=this.getFocusableCols(),i=this.getFocusableRows(),l=o.indexOf(l),n=i.indexOf(e),t=(l=-1===l?0:l)===o.length-1?0:l+1;return!(t<=l)||n===i.length-1?new r(e,o[t]):new r(i[n+1],o[t])},e.prototype.getRowColDown=function(e,l){var o=this.getFocusableCols(),i=this.getFocusableRows(),l=o.indexOf(l),n=i.indexOf(e);return-1===l&&(l=0),n===i.length-1?new r(e,o[l]):new r(i[n+1],o[l])},e.prototype.getRowColPageDown=function(e,l){var o=this.getFocusableCols(),i=this.getFocusableRows(),l=o.indexOf(l),e=i.indexOf(e),n=(-1===l&&(l=0),this.bodyContainer.minRowsToRender());return e>=i.length-n?new r(i[i.length-1],o[l]):new r(i[e+n],o[l])},e.prototype.getRowColUp=function(e,l){var o=this.getFocusableCols(),i=this.getFocusableRows(),l=o.indexOf(l),n=i.indexOf(e);return new r(0===n?e:i[n-1],o[l=-1===l?0:l])},e.prototype.getRowColPageUp=function(e,l){var o=this.getFocusableCols(),i=this.getFocusableRows(),l=o.indexOf(l),e=i.indexOf(e),n=(-1===l&&(l=0),this.bodyContainer.minRowsToRender());return new r(e-n<0?i[0]:i[e-n],o[l])},e}]),e.service("uiGridCellNavService",["uiGridConstants","uiGridCellNavConstants","$q","uiGridCellNavFactory",function(l,o,i,n){var t={initializeGrid:function(i){i.registerColumnBuilder(t.cellNavColumnBuilder),i.cellNav={},i.cellNav.lastRowCol=null,i.cellNav.focusedCells=[],t.defaultGridOptions(i.options);var e={cellNav:{navigate:function(e,l){},viewPortKeyDown:function(e,l){},viewPortKeyPress:function(e,l){}}},l={cellNav:{scrollToFocus:function(e,l){return t.scrollToFocus(i,e,l)},getFocusedCell:function(){return i.cellNav.lastRowCol},getCurrentSelection:function(){return i.cellNav.focusedCells},rowColSelectIndex:function(e){for(var l=-1,o=0;o<i.cellNav.focusedCells.length;o++)if(i.cellNav.focusedCells[o].col.uid===e.col.uid&&i.cellNav.focusedCells[o].row.uid===e.row.uid){l=o;break}return l}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(l)},defaultGridOptions:function(e){e.modifierKeysToMultiSelectCells=!0===e.modifierKeysToMultiSelectCells,e.keyDownOverrides=e.keyDownOverrides||[]},decorateRenderContainers:function(e){var l=e.hasRightContainer()?e.renderContainers.right:null,o=e.hasLeftContainer()?e.renderContainers.left:null;null!==o&&(e.renderContainers.left.cellNav=new n(e.renderContainers.body,o,l,e.renderContainers.body)),null!==l&&(e.renderContainers.right.cellNav=new n(e.renderContainers.body,l,e.renderContainers.body,o)),e.renderContainers.body.cellNav=new n(e.renderContainers.body,e.renderContainers.body,o,l)},getDirection:function(e){return e.keyCode===l.keymap.LEFT||e.keyCode===l.keymap.TAB&&e.shiftKey?o.direction.LEFT:e.keyCode===l.keymap.RIGHT||e.keyCode===l.keymap.TAB?o.direction.RIGHT:e.keyCode===l.keymap.UP||e.keyCode===l.keymap.ENTER&&e.shiftKey?o.direction.UP:e.keyCode===l.keymap.PG_UP?o.direction.PG_UP:e.keyCode===l.keymap.DOWN||e.keyCode===l.keymap.ENTER&&!e.ctrlKey&&!e.altKey?o.direction.DOWN:e.keyCode===l.keymap.PG_DOWN?o.direction.PG_DOWN:null},cellNavColumnBuilder:function(e,l,o){return e.allowCellFocus=void 0===e.allowCellFocus||e.allowCellFocus,i.all([])},scrollToFocus:function(l,e,o){var i=null,n=null;return null!=e&&(i=l.getRow(e)),null!=o&&(n=l.getColumn(o.name||o.field)),l.api.core.scrollToIfNecessary(i,n).then(function(){var e={row:i,col:n};null!==i&&null!==n&&l.cellNav.broadcastCellNav(e,null,null)})},getLeftWidth:function(e,l){var o,i=0;return l&&(o=e.renderContainers.body.visibleColumnCache.indexOf(l),e.renderContainers.body.visibleColumnCache.forEach(function(e,l){l<o&&(i+=e.drawnWidth)}),e=0===o?0:(o+1)/e.renderContainers.body.visibleColumnCache.length,i+=l.drawnWidth*e),i}};return t}]),e.directive("uiGridCellnav",["uiGridCellNavService","uiGridCellNavConstants","uiGridConstants","GridRowColumn","$compile","i18nService",function(c,u,s,d,t,C){return{replace:!0,priority:-150,require:"^uiGrid",scope:!1,controller:function(){},compile:function(){return{pre:function(e,l,o,r){var i=e,a=r.grid;c.initializeGrid(a),r.cellNav={},r.cellNav.makeRowCol=function(e){return e=e instanceof d?e:new d(e.row,e.col)},r.cellNav.getActiveCell=function(){var e=l[0].getElementsByClassName("ui-grid-cell-focus");if(0<e.length)return e[0]},r.cellNav.broadcastCellNav=a.cellNav.broadcastCellNav=function(e,l,o){l=!(void 0===l||!l),e=r.cellNav.makeRowCol(e),r.cellNav.broadcastFocus(e,l,o),i.$broadcast(u.CELL_NAV_EVENT,e,l,o)},r.cellNav.clearFocus=a.cellNav.clearFocus=function(){a.cellNav.focusedCells=[],i.$broadcast(u.CELL_NAV_EVENT)},r.cellNav.broadcastFocus=function(e,l,o){l=!(void 0===l||!l);var i=(e=r.cellNav.makeRowCol(e)).row,n=e.col,t=r.grid.api.cellNav.rowColSelectIndex(e);null===a.cellNav.lastRowCol||-1===t||a.cellNav.lastRowCol.col===n&&a.cellNav.lastRowCol.row===i?(i=new d(i,n),null!==a.cellNav.lastRowCol&&a.cellNav.lastRowCol.row===i.row&&a.cellNav.lastRowCol.col===i.col&&!a.options.enableCellEditOnFocus||(a.api.cellNav.raise.navigate(i,a.cellNav.lastRowCol,o),a.cellNav.lastRowCol=i),r.grid.options.modifierKeysToMultiSelectCells&&l?a.cellNav.focusedCells.push(e):a.cellNav.focusedCells=[e]):a.options.modifierKeysToMultiSelectCells&&l&&0<=t&&a.cellNav.focusedCells.splice(t,1)},r.cellNav.handleKeyDown=function(e){var l,o,i,n,t=c.getDirection(e);return null===t?null:(i="body",e.uiGridTargetRenderContainerId&&(i=e.uiGridTargetRenderContainerId),(l=r.grid.api.cellNav.getFocusedCell())?(o=r.grid.renderContainers[i].cellNav.getNextRowCol(t,l.row,l.col),i=r.grid.renderContainers[i].cellNav.getFocusableCols(),n=r.grid.api.cellNav.rowColSelectIndex(o),(t!==u.direction.LEFT||o.col!==i[i.length-1]||o.row!==l.row||e.keyCode!==s.keymap.TAB||!e.shiftKey)&&(t!==u.direction.RIGHT||o.col!==i[0]||o.row!==l.row||e.keyCode!==s.keymap.TAB||e.shiftKey)?(a.scrollToIfNecessary(o.row,o.col).then(function(){r.cellNav.broadcastCellNav(o,null,e)}),e.stopPropagation(),e.preventDefault(),!1):(a.cellNav.focusedCells.splice(n,1),r.cellNav.clearFocus(),!0)):void 0)}},post:function(l,o,e,i){var d=i.grid,i=!0;try{angular.module("ngAria")}catch(e){i=!1}function n(){var e='<div id="'+d.id+'-aria-speakable" class="ui-grid-a11y-ariascreenreader-speakable ui-grid-offscreen" aria-live="assertive" role="alert" aria-atomic="true" aria-hidden="false" aria-relevant="additions" >&nbsp;</div>',s=t(e)(l);o.prepend(s),l.$on(u.CELL_NAV_EVENT,function(e,l,o,i){if(!i||"focus"!==i.type){for(var n,t=[],r=d.api.cellNav.getCurrentSelection(),a=0;a<r.length;a++){c=r[a],n="";var c=(n="selectionRowHeaderCol"===c.col.field?(c.row.isSelected?C.getSafeText("search.aria.selected"):C.getSafeText("search.aria.notSelected"))+", ":n)+d.getCellDisplayValue(c.row,c.col)+(n=r[a].col,", "+C.getSafeText("headerCell.aria.column")+" "+n.displayName);t.push(c)}(i=t.toString())!==s.text().trim()&&(s[0].style.clip="rect(0px,0px,0px,0px)",s[0].innerHTML="",s[0].style.visibility="hidden",s[0].style.visibility="visible",""!==i)&&(s[0].style.clip="auto",s[0].appendChild(document.createTextNode(i+" ")),s[0].style.visibility="hidden",s[0].style.visibility="visible")}})}i&&n()}}}}}]),e.directive("uiGridRenderContainer",["$timeout","gridUtil","uiGridCellNavService","$compile","uiGridCellNavConstants",function(s,d,u,C,v){return{replace:!0,priority:-99999,require:["^uiGrid","uiGridRenderContainer","?^uiGridCellnav"],scope:!1,compile:function(){return{post:function(e,l,o,i){var n,t,r,a=i[0],c=i[1],i=i[2];a.grid.api.cellNav&&(n=c.containerId,c=a.grid,u.decorateRenderContainers(c),"body"===n)&&(a.grid.options.modifierKeysToMultiSelectCells?l.attr("aria-multiselectable",!0):l.attr("aria-multiselectable",!1),t=C('<div class="ui-grid-focuser" role="region" aria-live="assertive" aria-atomic="false" tabindex="0" aria-controls="'+c.id+"-aria-speakable "+c.id+'-grid-container" aria-owns="'+c.id+'-grid-container"></div>')(e),l.append(t),t.on("focus",function(e){e.uiGridTargetRenderContainerId=n,null===a.grid.api.cellNav.getFocusedCell()&&(e=a.grid.renderContainers[n].cellNav.getNextRowCol(v.direction.DOWN,null,null)).row&&e.col&&a.cellNav.broadcastCellNav(e)}),i.setAriaActivedescendant=function(e){l.attr("aria-activedescendant",e)},i.removeAriaActivedescendant=function(e){l.attr("aria-activedescendant")===e&&l.attr("aria-activedescendant","")},a.focus=function(){d.focus.byElement(t[0])},r=null,t.on("keydown",function(o){o.uiGridTargetRenderContainerId=n;var e=a.grid.api.cellNav.getFocusedCell();null===(a.grid.options.keyDownOverrides.some(function(l){return Object.keys(l).every(function(e){return l[e]===o[e]})})?null:a.cellNav.handleKeyDown(o))&&(a.grid.api.cellNav.raise.viewPortKeyDown(o,e,a.cellNav.handleKeyDown),r=e)}),t.on("keypress",function(e){r&&(s(function(){a.grid.api.cellNav.raise.viewPortKeyPress(e,r)},4),r=null)}),e.$on("$destroy",function(){t.off()}))}}}}}]),e.directive("uiGridViewport",function(){return{replace:!0,priority:-99999,require:["^uiGrid","^uiGridRenderContainer","?^uiGridCellnav"],scope:!1,compile:function(){return{pre:function(e,l,o,i){},post:function(e,l,o,i){var n=i[0],t=i[1];n.grid.api.cellNav&&"body"===t.containerId&&((i=n.grid).api.core.on.scrollBegin(e,function(){var e=n.grid.api.cellNav.getFocusedCell();null!==e&&t.colContainer.containsColumn(e.col)&&n.cellNav.clearFocus()}),i.api.core.on.scrollEnd(e,function(e){var l=n.grid.api.cellNav.getFocusedCell();null!==l&&t.colContainer.containsColumn(l.col)&&n.cellNav.broadcastCellNav(l)}),i.api.cellNav.on.navigate(e,function(){n.focus()}))}}}}}),e.directive("uiGridCell",["uiGridCellNavConstants","uiGridConstants","GridRowColumn",function(u,C,v){return{priority:-150,restrict:"A",require:["^uiGrid","?^uiGridCellnav"],scope:!1,link:function(o,e,l,i){var n,t,r=i[0],a=i[1];function c(e){e.preventDefault()}function s(){n.cellNav.focusedCells.some(function(e,l){return e.row===o.row&&e.col===o.col})?o.focused||(e.find("div").addClass("ui-grid-cell-focus"),e.attr("aria-selected",!0),a.setAriaActivedescendant(e.attr("id")),o.focused=!0):d()}function d(){o.focused&&(e.find("div").removeClass("ui-grid-cell-focus"),e.attr("aria-selected",!1),a.removeAriaActivedescendant(e.attr("id")),o.focused=!1)}r.grid.api.cellNav&&o.col.colDef.allowCellFocus&&(n=r.grid,o.focused=!1,e.attr("tabindex",-1),e.find("div").on("click",function(e){r.cellNav.broadcastCellNav(new v(o.row,o.col),e.ctrlKey||e.metaKey,e),e.stopPropagation(),o.$apply()}),e.on("mousedown",c),r.grid.api.edit&&(r.grid.api.edit.on.beginCellEdit(o,function(){e.off("mousedown",c)}),r.grid.api.edit.on.afterCellEdit(o,function(){e.on("mousedown",c)}),r.grid.api.edit.on.cancelCellEdit(o,function(){e.on("mousedown",c)})),s(),e.on("focus",function(e){r.cellNav.broadcastCellNav(new v(o.row,o.col),!1,e),e.stopPropagation(),o.$apply()}),o.$on(u.CELL_NAV_EVENT,s),t=r.grid.registerDataChangeCallback(function(e){d(),o.$applyAsync(s)},[C.dataChange.ROW]),o.$on("$destroy",function(){t(),e.find("div").off(),e.off()}))}}}])}();