/*!
 * ui-grid - v4.12.7 - 2024-04-12
* http://ui-grid.info/
 * Copyright (c) 2024 ; License: MIT 
 */
!function(){"use strict";angular.module("ui.grid.i18n",[]),angular.module("ui.grid",["ui.grid.i18n"])}(),function(){"use strict";angular.module("ui.grid").constant("uiGridConstants",{LOG_DEBUG_MESSAGES:!0,LOG_WARN_MESSAGES:!0,LOG_ERROR_MESSAGES:!0,CUSTOM_FILTERS:/CUSTOM_FILTERS/g,COL_FIELD:/COL_FIELD/g,MODEL_COL_FIELD:/MODEL_COL_FIELD/g,TOOLTIP:/title=\"TOOLTIP\"/g,DISPLAY_CELL_TEMPLATE:/DISPLAY_CELL_TEMPLATE/g,TEMPLATE_REGEXP:/<.+>/,FUNC_REGEXP:/(\([^)]*\))?$/,DOT_REGEXP:/\./g,APOS_REGEXP:/'/g,BRACKET_REGEXP:/^(.*)((?:\s*\[\s*\d+\s*\]\s*)|(?:\s*\[\s*"(?:[^"\\]|\\.)*"\s*\]\s*)|(?:\s*\[\s*'(?:[^'\\]|\\.)*'\s*\]\s*))(.*)$/,COL_CLASS_PREFIX:"ui-grid-col",ENTITY_BINDING:"$$this",events:{GRID_SCROLL:"uiGridScroll",COLUMN_MENU_SHOWN:"uiGridColMenuShown",ITEM_DRAGGING:"uiGridItemDragStart",COLUMN_HEADER_CLICK:"uiGridColumnHeaderClick"},keymap:{TAB:9,STRG:17,CAPSLOCK:20,CTRL:17,CTRLRIGHT:18,CTRLR:18,SHIFT:16,RETURN:13,ENTER:13,BACKSPACE:8,BCKSP:8,ALT:18,ALTR:17,ALTRIGHT:17,SPACE:32,WIN:91,MAC:91,FN:null,PG_UP:33,PG_DOWN:34,UP:38,DOWN:40,LEFT:37,RIGHT:39,ESC:27,DEL:46,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123},ASC:"asc",DESC:"desc",filter:{STARTS_WITH:2,ENDS_WITH:4,EXACT:8,CONTAINS:16,GREATER_THAN:32,GREATER_THAN_OR_EQUAL:64,LESS_THAN:128,LESS_THAN_OR_EQUAL:256,NOT_EQUAL:512,SELECT:"select",INPUT:"input"},aggregationTypes:{sum:2,count:4,avg:8,min:16,max:32},CURRENCY_SYMBOLS:["¤","؋","Ar","Ƀ","฿","B/.","Br","Bs.","Bs.F.","GH₵","¢","c","Ch.","₡","C$","D","ден","دج",".د.ب","د.ع","JD","د.ك","ل.د","дин","د.ت","د.م.","د.إ","Db","$","₫","Esc","€","ƒ","Ft","FBu","FCFA","CFA","Fr","FRw","G","gr","₲","h","₴","₭","Kč","kr","kn","MK","ZK","Kz","K","L","Le","лв","E","lp","M","KM","MT","₥","Nfk","₦","Nu.","UM","T$","MOP$","₱","Pt.","£","ج.م.","LL","LS","P","Q","q","R","R$","ر.ع.","ر.ق","ر.س","៛","RM","p","Rf.","₹","₨","SRe","Rp","₪","Ksh","Sh.So.","USh","S/","SDR","сом","৳\t","WS$","₮","VT","₩","¥","zł"],scrollDirection:{UP:"up",DOWN:"down",LEFT:"left",RIGHT:"right",NONE:"none"},dataChange:{ALL:"all",EDIT:"edit",ROW:"row",COLUMN:"column",OPTIONS:"options"},scrollbars:{NEVER:0,ALWAYS:1,WHEN_NEEDED:2}})}(),angular.module("ui.grid").directive("uiGridCell",["$compile","$parse","gridUtil","uiGridConstants",function(n,e,o,s){return{priority:0,scope:!1,require:"?^uiGrid",compile:function(){return{pre:function(t,r,e,i){i&&t.col.compiledElementFn?(0,t.col.compiledElementFn)(t,function(e,t){r.append(e)}):i&&!t.col.compiledElementFn?t.col.getCompiledElementFn().then(function(e){e(t,function(e,t){r.append(e)})}).catch(angular.noop):(i=t.col.cellTemplate.replace(s.MODEL_COL_FIELD,"row.entity."+o.preEval(t.col.field)).replace(s.COL_FIELD,"grid.getCellValue(row, col)"),i=n(i)(t),r.append(i))},post:function(r,i){var n,o=r.col.getColClass(!1);function l(e){var t=i;n&&(t.removeClass(n),n=null),n=angular.isFunction(r.col.cellClass)?r.col.cellClass(r.grid,r.row,r.col,r.rowRenderIndex,r.colRenderIndex):r.col.cellClass,t.addClass(n)}i.addClass(o),r.col.cellClass&&l();var e=r.grid.registerDataChangeCallback(l,[s.dataChange.COLUMN,s.dataChange.EDIT]);var t=r.$watch("row",function(e,t){e!==t&&((n||r.col.cellClass)&&l(),(e=r.col.getColClass(!1))!==o)&&(i.removeClass(o),i.addClass(e),o=e)});function a(){e(),t()}r.$on("$destroy",a),i.on("$destroy",a)}}}}}]),angular.module("ui.grid").service("uiGridColumnMenuService",["i18nService","uiGridConstants","gridUtil",function(e,r,c){var i={initialize:function(e,t){e.grid=t.grid,(t.columnMenuScope=e).menuShown=!1},setColMenuItemWatch:function(t){var e=t.$watch("col.menuItems",function(e){void 0!==e&&e&&angular.isArray(e)?(e.forEach(function(e){void 0!==e.context&&e.context||(e.context={}),e.context.col=t.col}),t.menuItems=t.defaultMenuItems.concat(e)):t.menuItems=t.defaultMenuItems});t.$on("$destroy",e)},getGridOption:function(e,t){return void 0!==e.grid&&e.grid&&e.grid.options&&e.grid.options[t]},sortable:function(e){return Boolean(this.getGridOption(e,"enableSorting")&&void 0!==e.col&&e.col&&e.col.enableSorting)},isActiveSort:function(e,t){return Boolean(void 0!==e.col&&void 0!==e.col.sort&&void 0!==e.col.sort.direction&&e.col.sort.direction===t)},suppressRemoveSort:function(e){return Boolean(e.col&&e.col.suppressRemoveSort)},hideable:function(e){return Boolean(this.getGridOption(e,"enableHiding")&&void 0!==e.col&&e.col&&(e.col.colDef&&!1!==e.col.colDef.enableHiding||!e.col.colDef)||!this.getGridOption(e,"enableHiding")&&e.col&&e.col.colDef&&e.col.colDef.enableHiding)},getDefaultMenuItems:function(t){return[{title:function(){return e.getSafeText("sort.ascending")},icon:"ui-grid-icon-sort-alt-up",action:function(e){e.stopPropagation(),t.sortColumn(e,r.ASC)},shown:function(){return i.sortable(t)},active:function(){return i.isActiveSort(t,r.ASC)}},{title:function(){return e.getSafeText("sort.descending")},icon:"ui-grid-icon-sort-alt-down",action:function(e){e.stopPropagation(),t.sortColumn(e,r.DESC)},shown:function(){return i.sortable(t)},active:function(){return i.isActiveSort(t,r.DESC)}},{title:function(){return e.getSafeText("sort.remove")},icon:"ui-grid-icon-cancel",action:function(e){e.stopPropagation(),t.unsortColumn()},shown:function(){return i.sortable(t)&&void 0!==t.col&&void 0!==t.col.sort&&void 0!==t.col.sort.direction&&null!==t.col.sort.direction&&!i.suppressRemoveSort(t)}},{title:function(){return e.getSafeText("column.hide")},icon:"ui-grid-icon-cancel",shown:function(){return i.hideable(t)},action:function(e){e.stopPropagation(),t.hideColumn()}}]},getColumnElementPosition:function(e,t,r){var i={};return i.left=r[0].offsetLeft,i.top=r[0].offsetTop,i.parentLeft=r[0].offsetParent.offsetLeft,i.offset=0,t.grid.options.offsetLeft&&(i.offset=t.grid.options.offsetLeft),i.height=c.elementHeight(r,!0),i.width=c.elementWidth(r,!0),i},repositionMenu:function(e,t,r,i,n){var o=i[0].querySelectorAll(".ui-grid-menu"),n=c.closestElm(n,".ui-grid-render-container"),l=n.getBoundingClientRect().left-e.grid.element[0].getBoundingClientRect().left,n=n.querySelectorAll(".ui-grid-viewport")[0].scrollLeft,a=c.elementWidth(o,!0),s=t.lastMenuPaddingRight||e.lastMenuPaddingRight||10,o=(0!==o.length&&0!==o[0].querySelectorAll(".ui-grid-menu-mid").length&&(s=parseInt(c.getStyles(angular.element(o)[0]).paddingRight,10),e.lastMenuPaddingRight=s,t.lastMenuPaddingRight=s),r.left+l-n+r.parentLeft+r.width+s);o<r.offset+a&&(o=Math.max(r.left-n+r.parentLeft-s+a,r.offset+a)),i.css("left",o+"px"),i.css("top",r.top+r.height+"px")}};return i}]).directive("uiGridColumnMenu",["$timeout","gridUtil","uiGridConstants","uiGridColumnMenuService","$document",function(n,l,a,s,c){return{priority:0,scope:!0,require:"^uiGrid",templateUrl:"ui-grid/uiGridColumnMenu",replace:!0,link:function(o,r,e,t){function i(e){o.col&&(o.col.menuShown=e)}s.initialize(o,t),o.defaultMenuItems=s.getDefaultMenuItems(o),o.menuItems=o.defaultMenuItems,s.setColMenuItemWatch(o),o.showMenu=function(e,t,r){i(!1),o.col=e,i(!0);e=s.getColumnElementPosition(o,e,t);o.menuShown?(o.colElement=t,o.colElementPosition=e,o.hideThenShow=!0,o.$broadcast("hide-menu",{originalEvent:r})):(o.menuShown=!0,o.colElement=t,o.colElementPosition=e,o.$broadcast("show-menu",{originalEvent:r}))},o.hideMenu=function(e){o.menuShown=!1,i(!1),e||o.$broadcast("hide-menu")},o.$on("menu-hidden",function(){var e=angular.element(r[0].querySelector(".ui-grid-menu-items"))[0];r[0].removeAttribute("style"),o.hideThenShow?(delete o.hideThenShow,o.$broadcast("show-menu"),o.menuShown=!0):(o.hideMenu(!0),o.col&&o.col.visible&&l.focus.bySelector(c,".ui-grid-header-cell."+o.col.getColClass()+" .ui-grid-column-menu-button",o.col.grid,!1).catch(angular.noop)),e&&(e.onkeydown=null,angular.forEach(e.children,function(e){e.onkeydown=null}))}),o.$on("menu-shown",function(){n(function(){var e,n;function t(e,t,r,i){e.keyCode===a.keymap.TAB&&(t?e.preventDefault():r&&(e.preventDefault(),n[i].focus()))}s.repositionMenu(o,o.col,o.colElementPosition,r,o.colElement),o.menuItems.some(function(e){return e.shown()})&&l.focus.bySelector(c,".ui-grid-menu-items .ui-grid-menu-item:not(.ng-hide)",!0).catch(angular.noop),delete o.colElementPosition,delete o.columnElement,e=angular.element(r[0].querySelector(".ui-grid-menu-items"))[0],n=[],e&&(e.onkeydown=function(e){e.keyCode===a.keymap.ESC&&(e.preventDefault(),o.hideMenu())},e=e.querySelectorAll(".ui-grid-menu-item:not(.ng-hide)"),angular.forEach(e,function(e){null!==e.offsetParent&&this.push(e)},n),n.length)&&(1===n.length?n[0].onkeydown=function(e){t(e,!0)}:(n[0].onkeydown=function(e){t(e,!1,e.shiftKey,n.length-1)},n[n.length-1].onkeydown=function(e){t(e,!1,!e.shiftKey,0)}))})}),o.sortColumn=function(e,t){e.stopPropagation(),o.grid.sortColumn(o.col,t,!0).then(function(){o.grid.refresh(),o.hideMenu()}).catch(angular.noop)},o.unsortColumn=function(){o.col.unsort(),o.grid.refresh(),o.hideMenu()};o.hideColumn=function(){o.col.colDef.visible=!1,o.col.visible=!1,o.grid.queueGridRefresh(),o.hideMenu(),o.grid.api.core.notifyDataChange(a.dataChange.COLUMN),o.grid.api.core.raise.columnVisibilityChanged(o.col),n(function(){function t(){return l.focus.byId("grid-menu",o.grid)}var r,i,e;o.grid.columns.some(function(e,t){if(angular.equals(e,o.col))return r=t,!0}),o.grid.columns.some(function(e,t){return!!e.visible&&(t<r?void(i=e):r<t&&!i?(i=e,!0):!!(r<t&&i)||void 0)}),i?(e=i.getColClass(),l.focus.bySelector(c,".ui-grid-header-cell."+e+" .ui-grid-header-cell-primary-focus",!0).then(angular.noop,function(e){if("canceled"!==e)return t()}).catch(angular.noop)):t()})}},controller:["$scope",function(e){var t=this;e.$watch("menuItems",function(e){t.menuItems=e})}]}}]),function(){"use strict";angular.module("ui.grid").directive("uiGridFilter",["$compile","$templateCache","i18nService","gridUtil",function(n,e,t,i){return{compile:function(){return{pre:function(r,i){r.col.updateFilters=function(e){var t;i.children().remove(),e&&(void 0===(t=r.col.filterHeaderTemplate)&&""!==r.col.providedFilterHeaderTemplate?r.col.filterHeaderTemplatePromise&&r.col.filterHeaderTemplatePromise.then(function(){t=r.col.filterHeaderTemplate,i.append(n(t)(r))}):i.append(n(t)(r)))},r.$on("$destroy",function(){delete r.col.filterable,delete r.col.updateFilters})},post:function(e,r){e.aria=t.getSafeText("headerCell.aria"),e.removeFilter=function(e,t){e.term=null,i.focus.bySelector(r,".ui-grid-filter-input-"+t)}}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridFooterCell",["$timeout","gridUtil","uiGridConstants","$compile",function(e,t,l,i){return{priority:0,scope:{col:"=",row:"=",renderIndex:"="},replace:!0,require:"^uiGrid",compile:function(){return{pre:function(e,t){var r=e.col.footerCellTemplate;void 0===r&&""!==e.col.providedFooterCellTemplate?e.col.footerCellTemplatePromise&&e.col.footerCellTemplatePromise.then(function(){r=e.col.footerCellTemplate,t.append(i(r)(e))}):t.append(i(r)(e))},post:function(t,r,e,i){t.grid=i.grid;function n(){var e=r;o&&(e.removeClass(o),o=null),o=angular.isFunction(t.col.footerCellClass)?t.col.footerCellClass(t.grid,t.row,t.col,t.rowRenderIndex,t.colRenderIndex):t.col.footerCellClass,e.addClass(o)}var o,i=t.col.getColClass(!1),i=(r.addClass(i),t.col.footerCellClass&&n(),t.col.updateAggregationValue(),t.grid.registerDataChangeCallback(n,[l.dataChange.COLUMN]));t.grid.api.core.on.rowsRendered(t,t.col.updateAggregationValue),t.grid.api.core.on.rowsRendered(t,n),t.$on("$destroy",i)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridFooter",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout",function(e,l,t,a,r){return{restrict:"EA",replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:!0,compile:function(e,t){return{pre:function(t,r,e,i){var n=i[0],o=i[1],i=(t.grid=n.grid,t.colContainer=o.colContainer,o.footer=r,t.grid.options.footerTemplate);a.getTemplate(i).then(function(e){var e=angular.element(e),e=l(e)(t);r.append(e),o&&(e=r[0].getElementsByClassName("ui-grid-footer-viewport")[0])&&(o.footerViewport=e)}).catch(angular.noop)},post:function(e,t,r,i){var n=i[0],i=i[1],n=(n.grid,a.disableAnimations(t),(i.footer=t)[0].getElementsByClassName("ui-grid-footer-viewport")[0]);n&&(i.footerViewport=n)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridGridFooter",["$templateCache","$compile","uiGridConstants","gridUtil",function(e,n,t,o){return{restrict:"EA",replace:!0,require:"^uiGrid",scope:!0,compile:function(){return{pre:function(t,r,e,i){t.grid=i.grid;i=t.grid.options.gridFooterTemplate;o.getTemplate(i).then(function(e){e=angular.element(e),e=n(e)(t);r.append(e)}).catch(angular.noop)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridHeaderCell",["$compile","$timeout","$window","$document","gridUtil","uiGridConstants","ScrollEvent","i18nService","$rootScope",function(i,d,e,g,t,h,r,p,f){return{priority:0,scope:{col:"=",row:"=",renderIndex:"="},require:["^uiGrid","^uiGridRenderContainer"],replace:!0,compile:function(){return{pre:function(e,t){var r=e.col.headerCellTemplate;void 0===r&&""!==e.col.providedHeaderCellTemplate?e.col.headerCellTemplatePromise&&e.col.headerCellTemplatePromise.then(function(){r=e.col.headerCellTemplate,t.append(i(r)(e))}):t.append(i(r)(e))},post:function(r,t,e,i){function n(e){e&&(void 0!==r.col.updateFilters&&r.col.updateFilters(r.col.filterable),r.col.filterable?(r.col.filters.forEach(function(e,t){u.push(r.$watch("col.filters["+t+"].term",function(e,t){e!==t&&(s.grid.api.core.raise.filterChanged(r.col),s.grid.api.core.notifyDataChange(h.dataChange.COLUMN),s.grid.queueGridRefresh())}))}),r.$on("$destroy",function(){u.forEach(function(e){e()})})):u.forEach(function(e){e()}))}function o(){var e=t,e=(l&&(e.removeClass(l),l=null),l=angular.isFunction(r.col.headerCellClass)?r.col.headerCellClass(r.grid,r.row,r.col,r.rowRenderIndex,r.colRenderIndex):r.col.headerCellClass,e.addClass(l),r.$applyAsync(function(){var e=r.grid.renderContainers.right&&r.grid.renderContainers.right.visibleColumnCache.length?r.grid.renderContainers.right:r.grid.renderContainers.body;r.isLastCol=s.grid.options&&s.grid.options.enableGridMenu&&r.col===e.visibleColumnCache[e.visibleColumnCache.length-1]}),r.sortable=Boolean(r.col.enableSorting),r.col.filterable);r.col.filterable=Boolean(s.grid.options.enableFiltering&&r.col.enableFiltering),n(e!==r.col.filterable),r.colMenu=r.col.grid.options&&!1!==r.col.grid.options.enableColumnMenus&&r.col.colDef&&!1!==r.col.colDef.enableColumnMenu,r.offAllEvents(),(r.sortable||r.colMenu)&&(r.onDownEvents(),r.$on("$destroy",function(){r.offAllEvents()}))}var l,a,s=i[0],i=i[1],i=(r.i18n={headerCell:p.getSafeText("headerCell"),sort:p.getSafeText("sort")},r.isSortPriorityVisible=function(){return r.col&&r.col.sort&&angular.isNumber(r.col.sort.priority)&&r.grid.columns.some(function(e,t){return angular.isNumber(e.sort.priority)&&e!==r.col})},r.getSortDirectionAriaLabel=function(){var e=r.col,t=e.sort&&e.sort.direction===h.ASC?r.i18n.sort.ascending:e.sort&&e.sort.direction===h.DESC?r.i18n.sort.descending:r.i18n.sort.none;return t=r.isSortPriorityVisible()?t+". "+r.i18n.headerCell.priority+" "+(e.sort.priority+1):t},r.grid=s.grid,r.renderContainer=s.grid.renderContainers[i.containerId],r.col.getColClass(!1)),c=(t.addClass(i),r.menuShown=!1,r.col.menuShown=!1,r.asc=h.ASC,r.desc=h.DESC,angular.element(t[0].querySelectorAll(".ui-grid-cell-contents"))),u=[],i=(r.downFn=function(e){e.stopPropagation(),(e=void 0!==e.originalEvent&&void 0!==e.originalEvent?e.originalEvent:e).button&&0!==e.button||(a=e.pageX,r.mousedownStartTime=(new Date).getTime(),r.mousedownTimeout=d(function(){},500),r.mousedownTimeout.then(function(){r.colMenu&&s.columnMenuScope.showMenu(r.col,t,e)}).catch(angular.noop),s.fireEvent(h.events.COLUMN_HEADER_CLICK,{event:e,columnName:r.col.colDef.name}),r.offAllEvents(),"touchstart"===e.type?(g.on("touchend",r.upFn),g.on("touchmove",r.moveFn)):"mousedown"===e.type&&(g.on("mouseup",r.upFn),g.on("mousemove",r.moveFn)))},r.upFn=function(e){e.stopPropagation(),d.cancel(r.mousedownTimeout),r.offAllEvents(),r.onDownEvents(e.type),500<(new Date).getTime()-r.mousedownStartTime||r.sortable&&r.handleClick(e)},r.handleKeyDown=function(e){32!==e.keyCode&&13!==e.keyCode||(e.preventDefault(),r.handleClick(e))},r.moveFn=function(e){0!=e.pageX-a&&(d.cancel(r.mousedownTimeout),r.offAllEvents(),r.onDownEvents(e.type))},r.clickFn=function(e){e.stopPropagation(),c.off("click",r.clickFn)},r.offAllEvents=function(){c.off("touchstart",r.downFn),c.off("mousedown",r.downFn),g.off("touchend",r.upFn),g.off("mouseup",r.upFn),g.off("touchmove",r.moveFn),g.off("mousemove",r.moveFn),c.off("click",r.clickFn)},r.onDownEvents=function(e){switch(e){case"touchmove":case"touchend":c.on("click",r.clickFn),c.on("touchstart",r.downFn),d(function(){c.on("mousedown",r.downFn)},500);break;case"mousemove":case"mouseup":c.on("click",r.clickFn),c.on("mousedown",r.downFn),d(function(){c.on("touchstart",r.downFn)},500);break;default:c.on("click",r.clickFn),c.on("touchstart",r.downFn),c.on("mousedown",r.downFn)}},o(),"columnMenu"===r.col.filterContainer&&r.col.filterable&&f.$on("menu-shown",function(){r.$applyAsync(function(){n(r.col.filterable)})}),r.grid.registerDataChangeCallback(o,[h.dataChange.COLUMN]));r.$on("$destroy",i),r.handleClick=function(e){s.grid.sortColumn(r.col,e.shiftKey).then(function(){s.columnMenuScope&&s.columnMenuScope.hideMenu(),s.grid.refresh()}).catch(angular.noop)},r.headerCellArrowKeyDown=function(e){e.keyCode!==h.keymap.SPACE&&e.keyCode!==h.keymap.ENTER||(e.preventDefault(),r.toggleMenu(e))},r.toggleMenu=function(e){e.stopPropagation(),s.columnMenuScope.menuShown&&s.columnMenuScope.col===r.col?s.columnMenuScope.hideMenu():s.columnMenuScope.showMenu(r.col,t)}}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridHeader",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout","ScrollEvent",function(e,s,t,c,r,u){return{restrict:"EA",replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:!0,compile:function(){return{pre:function(r,i,e,t){var n=t[0],o=t[1];function l(){var e=(o.header=o.colContainer.header=i)[0].getElementsByClassName("ui-grid-header-canvas");0<e.length?o.headerCanvas=o.colContainer.headerCanvas=e[0]:o.headerCanvas=null}function a(){var e,t,r;n.grid.isScrollingHorizontally||(e=c.normalizeScrollLeft(o.headerViewport,n.grid),t=o.colContainer.scrollHorizontal(e),(r=new u(n.grid,null,o.colContainer,u.Sources.ViewPortScroll)).newScrollLeft=e,-1<t&&(r.x={percentage:t}),n.grid.scrollContainers(null,r))}r.grid=n.grid,r.colContainer=o.colContainer,l(),t=r.grid.options.showHeader?r.grid.options.headerTemplate||"ui-grid/ui-grid-header":"ui-grid/ui-grid-no-header",c.getTemplate(t).then(function(e){var t,e=angular.element(e),e=s(e)(r);i.replaceWith(e),i=e,l(),o&&(t=i[0].getElementsByClassName("ui-grid-header-viewport")[0])&&(o.headerViewport=t,angular.element(t).on("scroll",a),r.$on("$destroy",function(){angular.element(t).off("scroll",a)})),r.grid.queueRefresh()}).catch(angular.noop)},post:function(e,t,r,i){var n=i[0],o=i[1];n.grid;c.disableAnimations(t);i=(o.header=t)[0].getElementsByClassName("ui-grid-header-viewport")[0];i&&(o.headerViewport=i),n&&n.grid.registerStyleComputation({priority:15,func:function(){var e=o.colContainer.visibleColumnCache,t="",r=0;return e.forEach(function(e){t+=e.getColClassDefinition(),r+=e.drawnWidth}),o.colContainer.canvasWidth=r,t}})}}}}}])}(),angular.module("ui.grid").service("uiGridGridMenuService",["gridUtil","i18nService","uiGridConstants",function(n,o,t){var l={initialize:function(e,t){(t.gridMenuScope=e).grid=t,e.registeredMenuItems=[],e.$on("$destroy",function(){e.grid&&e.grid.gridMenuScope&&(e.grid.gridMenuScope=null),e.grid&&(e.grid=null),e.registeredMenuItems&&(e.registeredMenuItems=null)}),e.registeredMenuItems=[],t.api.registerMethod("core","addToGridMenu",l.addToGridMenu),t.api.registerMethod("core","removeFromGridMenu",l.removeFromGridMenu)},addToGridMenu:function(e,t){angular.isArray(t)?e.gridMenuScope?(e.gridMenuScope.registeredMenuItems=e.gridMenuScope.registeredMenuItems||[],e.gridMenuScope.registeredMenuItems=e.gridMenuScope.registeredMenuItems.concat(t)):n.logError("Asked to addToGridMenu, but gridMenuScope not present.  Timing issue?  Please log issue with ui-grid"):n.logError("addToGridMenu: menuItems must be an array, and is not, not adding any items")},removeFromGridMenu:function(e,r){var i=-1;e&&e.gridMenuScope&&e.gridMenuScope.registeredMenuItems.forEach(function(e,t){e.id===r&&(-1<i?n.logError("removeFromGridMenu: found multiple items with the same id, removing only the last"):i=t)}),-1<i&&e.gridMenuScope.registeredMenuItems.splice(i,1)},getMenuItems:function(t){var e=[],r=(t.grid.options.gridMenuCustomItems&&(angular.isArray(t.grid.options.gridMenuCustomItems)?e=e.concat(t.grid.options.gridMenuCustomItems):n.logError("gridOptions.gridMenuCustomItems must be an array, and is not")),[{title:o.getSafeText("gridMenu.clearAllFilters"),action:function(e){t.grid.clearAllFilters()},shown:function(){return t.grid.options.enableFiltering},order:100}]);return e=(e=e.concat(r)).concat(t.registeredMenuItems),(e=!1!==t.grid.options.gridMenuShowHideColumns?e.concat(l.showHideColumns(t)):e).sort(function(e,t){return e.order-t.order}),e},showHideColumns:function(r){var i=[];return r.grid.options.columnDefs&&0!==r.grid.options.columnDefs.length&&0!==r.grid.columns.length&&(r.grid.options.gridMenuTitleFilter=r.grid.options.gridMenuTitleFilter||function(e){return e},r.grid.options.columnDefs.forEach(function(e,t){(!1!==r.grid.options.enableHiding&&!1!==e.enableHiding||e.enableHiding)&&(t={icon:n(e),action:function(e){e.stopPropagation(),l.toggleColumnVisibility(this.context.gridCol),e.target&&e.target.firstChild&&("I"===angular.element(e.target)[0].nodeName?e.target.className=n(this.context.gridCol.colDef):e.target.firstChild.className=n(this.context.gridCol.colDef))},shown:function(){return!1!==this.context.gridCol.colDef.enableHiding},context:{gridCol:r.grid.getColumn(e.name||e.field)},leaveOpen:!0,order:301+t},l.setMenuItemTitle(t,e,r.grid),i.push(t))}),i.length)&&i.unshift({title:o.getSafeText("gridMenu.columns"),order:300,templateUrl:"ui-grid/ui-grid-menu-header-item"}),i;function n(e){return!0===(e=e).visible||void 0===e.visible?"ui-grid-icon-ok":"ui-grid-icon-cancel"}},setMenuItemTitle:function(t,e,r){r=r.options.gridMenuTitleFilter(e.displayName||n.readableColumnName(e.name)||e.field);"string"==typeof r?t.title=r:r.then?(t.title="",r.then(function(e){t.title=e},function(e){t.title=e}).catch(angular.noop)):(n.logError("Expected gridMenuTitleFilter to return a string or a promise, it has returned neither, bad config"),t.title="badconfig")},toggleColumnVisibility:function(e){e.colDef.visible=!(!0===e.colDef.visible||void 0===e.colDef.visible),e.grid.refresh(),e.grid.api.core.notifyDataChange(t.dataChange.COLUMN),e.grid.api.core.raise.columnVisibilityChanged(e)}};return l}]).directive("uiGridMenuButton",["gridUtil","uiGridConstants","uiGridGridMenuService","i18nService",function(n,o,l,a){return{priority:0,scope:!0,require:["^uiGrid"],templateUrl:"ui-grid/ui-grid-menu-button",replace:!0,link:function(t,e,r,i){i=i[0];t.i18n={aria:a.getSafeText("gridMenu.aria")},l.initialize(t,i.grid),t.shown=!1,t.toggleOnKeydown=function(e){(e.keyCode===o.keymap.ENTER||e.keyCode===o.keymap.SPACE||e.keyCode===o.keymap.ESC&&t.shown)&&t.toggleMenu()},t.toggleMenu=function(){t.shown?(t.$broadcast("hide-menu"),t.shown=!1):(t.menuItems=l.getMenuItems(t),t.$broadcast("show-menu"),t.shown=!0)},t.$on("menu-hidden",function(){t.shown=!1,n.focus.bySelector(e,".ui-grid-icon-container")})}}}]),angular.module("ui.grid").directive("uiGridMenu",["$compile","$timeout","$window","$document","gridUtil","uiGridConstants","i18nService",function(a,s,c,e,u,d,g){return{priority:0,scope:{menuItems:"=",autoHide:"=?",col:"=?"},require:"?^uiGrid",templateUrl:"ui-grid/uiGridMenu",replace:!1,link:function(n,o,e,r){function l(e){e=e-r.grid.headerHeight-20,n.dynamicStyles=[".grid"+r.grid.id+" .ui-grid-menu-mid {","max-height: "+e+"px;","}"].join(" ")}n.dynamicStyles="",r&&r.grid&&r.grid.options&&r.grid.options.gridMenuTemplate&&(t=r.grid.options.gridMenuTemplate,u.getTemplate(t).then(function(e){e=angular.element(e),e=a(e)(n);o.replaceWith(e)}).catch(angular.noop));r&&(l(r.grid.gridHeight),r.grid.api.core.on.gridDimensionChanged(n,function(e,t,r,i){l(r)})),n.i18n={close:g.getSafeText("columnMenu.close")},n.showMenu=function(e,t){n.shown?n.shownMid||(n.shownMid=!0,n.$emit("menu-shown")):(n.shown=!0,s(function(){n.shownMid=!0,n.$emit("menu-shown")}));var r="click";t&&t.originalEvent&&t.originalEvent.type&&"touchstart"===t.originalEvent.type&&(r=t.originalEvent.type),angular.element(document).off("click touchstart",i),s(function(){angular.element(document).on(r,i)})},n.hideMenu=function(e){n.shown&&(n.shownMid=!1,s(function(){n.shownMid||(n.shown=!1,n.$emit("menu-hidden"))},40)),angular.element(document).off("click touchstart",i)},n.$on("hide-menu",function(e,t){n.hideMenu(e,t)}),n.$on("show-menu",function(e,t){n.showMenu(e,t)});var t,i=function(e){if(n.shown){var t=r&&r.grid&&r.grid.options?r.grid.options.disableGridMenuHideOnScroll:null;if("scroll"!==e.type||!t){if(n.col&&"columnMenu"===n.col.filterContainer){t=document.querySelector(".ui-grid-column-menu").querySelector("[ui-grid-filter]");if(t&&t.contains(e.target))return!1}n.$apply(function(){n.hideMenu()})}}};n.checkKeyDown=function(t){function e(e){e.focus(),t.preventDefault()}var r,i;t.keyCode===d.keymap.ESC?n.hideMenu():t.keyCode===d.keymap.TAB&&0<(i=o[0].querySelectorAll("button:not(.ng-hide)")).length&&(r=i[0],i=i[i.length-1],t.target.parentElement.id!==i.parentElement.id||t.shiftKey?t.target.parentElement.id===r.parentElement.id&&t.shiftKey&&e(i):e(r))},void 0!==n.autoHide&&void 0!==n.autoHide||(n.autoHide=!0),n.autoHide&&angular.element(c).on("resize",i),n.$on("$destroy",function(){angular.element(c).off("resize",i),angular.element(document).off("click touchstart",i)}),r&&n.$on("$destroy",r.grid.api.core.on.scrollBegin(n,i)),n.$on("$destroy",n.$on(d.events.ITEM_DRAGGING,i))}}}]).directive("uiGridMenuItem",["gridUtil","$compile","i18nService",function(o,i,l){return{priority:0,scope:{name:"=",active:"=",action:"=",icon:"=",shown:"=",context:"=",templateUrl:"=",leaveOpen:"=",screenReaderOnly:"="},require:["?^uiGrid"],templateUrl:"ui-grid/uiGridMenuItem",replace:!1,compile:function(){return{pre:function(t,r){t.templateUrl&&o.getTemplate(t.templateUrl).then(function(e){e=angular.element(e),e=i(e)(t);r.replaceWith(e)}).catch(angular.noop)},post:function(i,e,t,r){var n=r[0];void 0!==i.shown&&null!==i.shown||(i.shown=function(){return!0}),i.itemShown=function(){var e={};return i.context&&(e.context=i.context),void 0!==n&&n&&(e.grid=n.grid),i.shown.call(e)},i.itemAction=function(e,t){var r;e.stopPropagation(),"function"==typeof i.action&&(r={},i.context&&(r.context=i.context),void 0!==n&&n&&(r.grid=n.grid),i.action.call(r,e,t),i.leaveOpen?(r=e.target.parentElement,"I"===angular.element(e.target)[0].nodeName&&(r=r.parentElement),o.focus.bySelector(r,"button[type=button]",!0)):i.$emit("hide-menu"))},i.label=function(){var e=i.name;return e="function"==typeof i.name?i.name.call():e},i.i18n=l.get()}}}}}]),function(){"use strict";var t=angular.module("ui.grid");angular.forEach([{tag:"Src",method:"attr"},{tag:"Text",method:"text"},{tag:"Href",method:"attr"},{tag:"Class",method:"addClass"},{tag:"Html",method:"html"},{tag:"Alt",method:"attr"},{tag:"Style",method:"css"},{tag:"Value",method:"attr"},{tag:"Id",method:"attr"},{tag:"Id",directiveName:"IdGrid",method:"attr",appendGridId:!0},{tag:"Title",method:"attr"},{tag:"Label",method:"attr",aria:!0},{tag:"Labelledby",method:"attr",aria:!0},{tag:"Labelledby",directiveName:"LabelledbyGrid",appendGridId:!0,method:"attr",aria:!0},{tag:"Describedby",method:"attr",aria:!0},{tag:"Describedby",directiveName:"DescribedbyGrid",appendGridId:!0,method:"attr",aria:!0}],function(c){var e="uiGridOneBind",u=(c.aria?e+"Aria":e)+(c.directiveName||c.tag);t.directive(u,["gridUtil",function(s){return{restrict:"A",require:["?uiGrid","?^uiGrid"],link:function(n,o,e,l){var a=n.$watch(e[u],function(e){if(e){var t;switch(c.appendGridId&&(t=null,angular.forEach(e.split(" "),function(e){t=(t?t+" ":"")+function(e){var t;if(n.grid)t=n.grid;else if(n.col&&n.col.grid)t=n.col.grid;else if(!l.some(function(e){if(e&&e.grid)return t=e.grid,!0}))throw s.logError("["+u+"] A valid grid could not be found to bind id. Are you using this directive within the correct scope? Trying to generate id: [gridID]-"+e),new Error("No valid grid could be found");return e=t&&!new RegExp(t.id.toString()).test(e)?t.id.toString()+"-"+e:e}(e)}),e=t),c.method){case"attr":c.aria?o[c.method]("aria-"+c.tag.toLowerCase(),e):o[c.method](c.tag.toLowerCase(),e);break;case"addClass":if(angular.isObject(e)&&!angular.isArray(e)){var r=[],i=!1;if(angular.forEach(e,function(e,t){null!=e&&(i=!0,e)&&r.push(t)}),!i)return;e=r}if(!e)return;o.addClass(angular.isArray(e)?e.join(" "):e);break;default:o[c.method](e)}a()}},!0)}}}])})}(),function(){"use strict";var e=angular.module("ui.grid");e.directive("uiGridRenderContainer",["$timeout","$document","uiGridConstants","gridUtil","ScrollEvent",function(e,t,r,h,p){return{replace:!0,transclude:!0,templateUrl:"ui-grid/uiGridRenderContainer",require:["^uiGrid","uiGridRenderContainer"],scope:{containerId:"=",rowContainerName:"=",colContainerName:"=",bindScrollHorizontal:"=",bindScrollVertical:"=",enableVerticalScrollbar:"=",enableHorizontalScrollbar:"="},controller:"uiGridRenderContainer as RenderContainer",compile:function(){return{pre:function(e,t,r,i){var n,o=i[0],i=i[1],o=e.grid=o.grid;if(!e.rowContainerName)throw new Error("No row render container name specified");if(!e.colContainerName)throw new Error("No column render container name specified");if(!o.renderContainers[e.rowContainerName])throw new Error('Row render container "'+e.rowContainerName+'" is not registered.');if(!o.renderContainers[e.colContainerName])throw new Error('Column render container "'+e.colContainerName+'" is not registered.');n=e.rowContainer=o.renderContainers[e.rowContainerName],o=e.colContainer=o.renderContainers[e.colContainerName],i.containerId=e.containerId,i.rowContainer=n,i.colContainer=o},post:function(a,t,e,r){var s=r[0],n=r[1],c=s.grid,u=n.rowContainer,d=n.colContainer,o=null,l=null,g=c.renderContainers[a.containerId];t.addClass("ui-grid-render-container-"+a.containerId),h.on.mousewheel(t,function(e){var t,r,i=new p(c,u,d,p.Sources.RenderContainerMouseWheel);0!==e.deltaY&&(r=-1*e.deltaY*e.deltaFactor,o=n.viewport[0].scrollTop,i.verticalScrollLength=u.getVerticalScrollLength(),1<=(t=(o+r)/i.verticalScrollLength)&&o<i.verticalScrollLength&&(n.viewport[0].scrollTop=i.verticalScrollLength),t<0?t=0:1<t&&(t=1),i.y={percentage:t,pixels:r}),0!==e.deltaX&&(t=e.deltaX*e.deltaFactor,l=h.normalizeScrollLeft(n.viewport,c),i.horizontalScrollLength=d.getCanvasWidth()-d.getViewportWidth(),(r=(l+t)/i.horizontalScrollLength)<0?r=0:1<r&&(r=1),i.x={percentage:r,pixels:t}),0!==e.deltaY&&(i.atTop(o)||i.atBottom(o))||0!==e.deltaX&&(i.atLeft(l)||i.atRight(l))||(e.preventDefault(),e.stopPropagation(),i.fireThrottledScrollingEvent("",i))}),t.bind("$destroy",function(){t.unbind("keydown"),["touchstart","touchmove","touchend","keydown","wheel","mousewheel","DomMouseScroll","MozMousePixelScroll"].forEach(function(e){t.unbind(e)})}),s.grid.registerStyleComputation({priority:6,func:function(){var e,t,r="",i=d.canvasWidth,n=d.getViewportWidth(),o=u.getCanvasHeight(),l=u.getViewportHeight();return d.needsHScrollbarPlaceholder()&&(l-=c.scrollbarHeight),e=t=d.getHeaderViewportWidth(),r=(r+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-canvas { width: "+i+"px; height: "+o+"px; }")+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-header-canvas { width: "+(i+c.scrollbarWidth)+"px; }"),g.explicitHeaderCanvasHeight?((o=document.querySelector(".grid"+s.grid.id+" .ui-grid-render-container-body .ui-grid-header-canvas"))&&(g.explicitHeaderCanvasHeight=o.offsetHeight),r+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-header-canvas { height: "+g.explicitHeaderCanvasHeight+"px; }"):r+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-header-canvas { height: inherit; }",r=(r=(r=(r+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-viewport { width: "+n+"px; height: "+l+"px; }")+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-header-viewport { width: "+e+"px; }"))+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-footer-canvas { width: "+(i+c.scrollbarWidth)+"px; }"))+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+a.containerId+" .ui-grid-footer-viewport { width: "+t+"px; }")}})}}}}}]),e.controller("uiGridRenderContainer",["$scope","gridUtil",function(e,t){}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridRow",function(){return{replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:{row:"=uiGridRow",rowRenderIndex:"="},compile:function(){return{pre:function(t,i,e,r){var n,o,l=r[0],r=r[1];function a(){t.row.getRowTemplateFn.then(function(e){var r=t.$new();e(r,function(e,t){n&&(n.remove(),o.$destroy()),i.empty().append(e),n=e,o=r})}).catch(angular.noop)}t.grid=l.grid,t.colContainer=r.colContainer,a(),t.$watch("row.getRowTemplateFn",function(e,t){e!==t&&a()})},post:function(e,t){e.row.element=t}}}}})}(),angular.module("ui.grid").directive("uiGridStyle",["gridUtil","$interpolate",function(e,i){return{link:function(e,r){var t=i(r.text(),!0);t&&e.$watch(t,function(e){for(var t=0;t<r.length;t++)r[t].textContent=e})}}}]),function(){"use strict";angular.module("ui.grid").directive("uiGridViewport",["gridUtil","ScrollEvent",function(u,d){return{replace:!0,scope:{},controllerAs:"Viewport",templateUrl:"ui-grid/uiGridViewport",require:["^uiGrid","^uiGridRenderContainer"],link:function(o,l,e,t){var r=t[0],i=t[1],a=(o.containerCtrl=i).rowContainer,s=i.colContainer,c=r.grid;o.grid=r.grid,o.rowContainer=i.rowContainer,o.colContainer=i.colContainer,i.viewport=l,c&&c.options&&c.options.customScroller?c.options.customScroller(l,n):l.on("scroll",n);function n(){var e=l[0].scrollTop,t=u.normalizeScrollLeft(l,c),r=a.scrollVertical(e),i=s.scrollHorizontal(t),n=new d(c,a,s,d.Sources.ViewPortScroll);n.newScrollLeft=t,n.newScrollTop=e,-1<i&&(n.x={percentage:i}),-1<r&&(n.y={percentage:r}),c.scrollContainers(o.$parent.containerId,n)}o.$parent.bindScrollVertical&&c.addVerticalScrollSync(o.$parent.containerId,function(e){i.prevScrollArgs=e,l[0].scrollTop=e.getNewScrollTop(a,i.viewport)}),o.$parent.bindScrollHorizontal&&(c.addHorizontalScrollSync(o.$parent.containerId,function(e){e=(i.prevScrollArgs=e).getNewScrollLeft(s,i.viewport);l[0].scrollLeft=u.denormalizeScrollLeft(i.viewport,e,c)}),c.addHorizontalScrollSync(o.$parent.containerId+"header",function(e){e=e.getNewScrollLeft(s,i.viewport);i.headerViewport&&(i.headerViewport.scrollLeft=u.denormalizeScrollLeft(i.viewport,e,c))}),c.addHorizontalScrollSync(o.$parent.containerId+"footer",function(e){e=e.getNewScrollLeft(s,i.viewport);i.footerViewport&&(i.footerViewport.scrollLeft=u.denormalizeScrollLeft(i.viewport,e,c))})),o.$on("$destroy",function(){l.off()})},controller:["$scope",function(i){this.rowStyle=function(){var e=i.rowContainer,t=i.colContainer,r={};return 0!==e.currentTopRow&&(e="translateY("+e.currentTopRow*e.grid.options.rowHeight+"px)",r.transform=e,r["-webkit-transform"]=e,r["-ms-transform"]=e),0!==t.currentFirstColumn&&(t.grid.isRTL()?r["margin-right"]=t.columnOffset+"px":r["margin-left"]=t.columnOffset+"px"),r}}]}}])}(),angular.module("ui.grid").directive("uiGridVisible",function(){return function(e,t,r){e.$watch(r.uiGridVisible,function(e){t[e?"removeClass":"addClass"]("ui-grid-invisible")})}}),function(){"use strict";function e(g,h,p){return{templateUrl:"ui-grid/ui-grid",scope:{uiGrid:"="},replace:!0,transclude:!0,controller:"uiGridController",compile:function(){return{post:function(o,l,e,a){var t,r,s=a.grid,i=(a.scrollbars=[],s.element=l,100),n=20,c=0;function u(){var e,t,r,i,n;s.gridWidth=o.gridWidth=h.elementWidth(l),s.canvasWidth=a.grid.gridWidth,s.gridHeight=o.gridHeight=h.elementHeight(l),s.gridHeight-s.scrollbarHeight<=s.options.rowHeight&&s.options.enableMinHeightCheck&&(e=s.options.minRowsToShow*s.options.rowHeight,t=s.options.showHeader?s.options.headerRowHeight:0,r=s.calcFooterHeight(),i=0,s.options.enableHorizontalScrollbar===p.scrollbars.ALWAYS&&(i=h.getScrollbarWidth()),n=0,angular.forEach(s.options.columnDefs,function(e){e.hasOwnProperty("filter")?n<1&&(n=1):e.hasOwnProperty("filters")&&n<e.filters.length&&(n=e.filters.length)}),!s.options.enableFiltering||n||s.options.columnDefs.length&&s.options.columnDefs.every(function(e){return!1===e.enableFiltering})||(n=1),e=t+e+r+i+n*t,l.css("height",e+"px"),s.gridHeight=o.gridHeight=h.elementHeight(l)),s.refreshCanvas(!0)}function d(){h.isVisible(l)&&(s.gridWidth=o.gridWidth=h.elementWidth(l),s.gridHeight=o.gridHeight=h.elementHeight(l),s.refreshCanvas(!0))}angular.element(g).on("resize",d),l.on("$destroy",function(){angular.element(g).off("resize",d),t(),r()}),t=o.$watch(function(){return s.hasLeftContainer()},function(e,t){e!==t&&s.refreshCanvas(!0)}),r=o.$watch(function(){return s.hasRightContainer()},function(e,t){e!==t&&s.refreshCanvas(!0)}),u(),s.renderingComplete(),function e(){l[0].offsetWidth<=0&&c<n?(setTimeout(e,i),c++):o.$applyAsync(u)}()}}}}}angular.module("ui.grid").controller("uiGridController",["$scope","$element","$attrs","gridUtil","$q","uiGridConstants","gridClassFactory","$parse","$compile",function(i,e,n,t,o,l,r,a,s){var c,u=this,d=[];function g(e){return e?e.length:0}function h(e,t){e&&e!==t&&(u.grid.options.columnDefs=i.uiGrid.columnDefs,u.grid.callDataChangeCallbacks(l.dataChange.COLUMN,{orderByColumnDefs:!0,preCompileCellTemplates:!0}))}function p(e){var t,r=[];u.grid.options.fastWatch&&(e=angular.isString(i.uiGrid.data)?u.grid.appScope.$eval(i.uiGrid.data):i.uiGrid.data),(c=e)&&(!(t=u.grid.columns.length>(u.grid.rowHeaderColumns?u.grid.rowHeaderColumns.length:0))&&!n.uiGridColumns&&0===u.grid.options.columnDefs.length&&0<e.length&&u.grid.buildColumnDefsFromData(e),!t&&(0<u.grid.options.columnDefs.length||0<e.length)&&r.push(u.grid.buildColumns().then(function(){u.grid.preCompileCellTemplates()}).catch(angular.noop)),o.all(r).then(function(){u.grid.modifyRows(c).then(function(){u.grid.redrawInPlace(!0),i.$evalAsync(function(){u.grid.refreshCanvas(!0),u.grid.callDataChangeCallbacks(l.dataChange.ROW)})}).catch(angular.noop)}).catch(angular.noop))}u.grid=r.createGrid(i.uiGrid),u.grid.appScope=u.grid.appScope||i.$parent,e.addClass("grid"+u.grid.id),u.grid.rtl="rtl"===t.getStyles(e[0]).direction,i.grid=u.grid,n.uiGridColumns&&d.push(n.$observe("uiGridColumns",function(e){u.grid.options.columnDefs=angular.isString(e)?angular.fromJson(e):e,u.grid.buildColumns().then(function(){u.grid.preCompileCellTemplates(),u.grid.refreshCanvas(!0)}).catch(angular.noop)})),u.grid.options.fastWatch?(u.uiGrid=i.uiGrid,angular.isString(i.uiGrid.data)?(d.push(i.$parent.$watch(i.uiGrid.data,p)),d.push(i.$parent.$watch(function(){if(u.grid.appScope[i.uiGrid.data])return u.grid.appScope[i.uiGrid.data].length},p))):(d.push(i.$parent.$watch(function(){return i.uiGrid.data},p)),d.push(i.$parent.$watch(function(){return g(i.uiGrid.data)},function(){p(i.uiGrid.data)}))),d.push(i.$parent.$watch(function(){return i.uiGrid.columnDefs},h)),d.push(i.$parent.$watch(function(){return g(i.uiGrid.columnDefs)},function(){h(i.uiGrid.columnDefs)}))):(angular.isString(i.uiGrid.data)?d.push(i.$parent.$watchCollection(i.uiGrid.data,p)):d.push(i.$parent.$watchCollection(function(){return i.uiGrid.data},p)),d.push(i.$parent.$watchCollection(function(){return i.uiGrid.columnDefs},h)));var f=i.$watch(function(){return u.grid.styleComputations},function(){u.grid.refreshCanvas(!0)});i.$on("$destroy",function(){d.forEach(function(e){e()}),f()}),u.fireEvent=function(e,t){t=t||{},angular.isUndefined(t.grid)&&(t.grid=u.grid),i.$broadcast(e,t)},u.innerCompile=function(e){s(e)(i)}}]),angular.module("ui.grid").directive("uiGrid",e),e.$inject=["$window","gridUtil","uiGridConstants"]}(),function(){"use strict";angular.module("ui.grid").directive("uiGridPinnedContainer",["gridUtil",function(e){return{restrict:"EA",replace:!0,template:'<div class="ui-grid-pinned-container"><div ui-grid-render-container container-id="side" row-container-name="\'body\'" col-container-name="side" bind-scroll-vertical="true" class="{{ side }} ui-grid-render-container-{{ side }}"></div></div>',scope:{side:"=uiGridPinnedContainer"},require:"^uiGrid",compile:function(){return{post:function(n,t,e,r){var o=r.grid,i=0;function l(){if("left"===n.side||"right"===n.side){for(var e=o.renderContainers[n.side].visibleColumnCache,t=0,r=0;r<e.length;r++){var i=e[r];t+=i.drawnWidth||i.width||0}return t}}t.addClass("ui-grid-pinned-container-"+n.side),"left"!==n.side&&"right"!==n.side||(o.renderContainers[n.side].getViewportWidth=function(){var t=0,e=(this.visibleColumnCache.forEach(function(e){t+=e.drawnWidth}),this.getViewportAdjustment());return t+=e.width}),o.renderContainers.body.registerViewportAdjuster(function(e){return i=l(),e.width-=i,e.side=n.side,e}),o.registerStyleComputation({priority:15,func:function(){var e="";return"left"!==n.side&&"right"!==n.side||(i=l(),t.attr("style",null),e+=".grid"+o.id+" .ui-grid-pinned-container-"+n.side+", .grid"+o.id+" .ui-grid-pinned-container-"+n.side+" .ui-grid-render-container-"+n.side+" .ui-grid-viewport { width: "+i+"px; } "),e}})}}}}}])}(),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("en",{headerCell:{aria:{defaultFilterLabel:"Filter for column",removeFilter:"Remove Filter",columnMenuButtonLabel:"Column Menu",column:"Column"},priority:"Priority:",filterLabel:"Filter for column: "},aggregate:{label:"items"},groupPanel:{description:"Drag a column header here and drop it to group by that column."},search:{aria:{selected:"Row selected",notSelected:"Row not selected"},placeholder:"Search...",showingItems:"Showing Items:",selectedItems:"Selected Items:",totalItems:"Total Items:",size:"Page Size:",first:"First Page",next:"Next Page",previous:"Previous Page",last:"Last Page"},selection:{aria:{row:"Row"},selectAll:"Select All",displayName:"Row Selection Checkbox"},menu:{text:"Choose Columns:"},sort:{ascending:"Sort Ascending",descending:"Sort Descending",none:"Sort None",remove:"Remove Sort"},column:{hide:"Hide Column"},aggregation:{count:"total rows: ",sum:"total: ",avg:"avg: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Pin Left",pinRight:"Pin Right",unpin:"Unpin"},columnMenu:{close:"Close"},gridMenu:{aria:{buttonLabel:"Grid Menu"},columns:"Columns:",importerTitle:"Import file",exporterAllAsCsv:"Export all data as csv",exporterVisibleAsCsv:"Export visible data as csv",exporterSelectedAsCsv:"Export selected data as csv",exporterAllAsPdf:"Export all data as pdf",exporterVisibleAsPdf:"Export visible data as pdf",exporterSelectedAsPdf:"Export selected data as pdf",exporterAllAsExcel:"Export all data as excel",exporterVisibleAsExcel:"Export visible data as excel",exporterSelectedAsExcel:"Export selected data as excel",clearAllFilters:"Clear all filters"},importer:{noHeaders:"Column names were unable to be derived, does the file have a header?",noObjects:"Objects were not able to be derived, was there data in the file other than headers?",invalidCsv:"File was unable to be processed, is it valid CSV?",invalidJson:"File was unable to be processed, is it valid Json?",jsonNotArray:"Imported json file must contain an array, aborting."},pagination:{aria:{pageToFirst:"Page to first",pageBack:"Page back",pageSelected:"Selected page",pageForward:"Page forward",pageToLast:"Page to last"},sizes:"items per page",totalItems:"items",through:"through",of:"of"},grouping:{group:"Group",ungroup:"Ungroup",aggregate_count:"Agg: Count",aggregate_sum:"Agg: Sum",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Avg",aggregate_remove:"Agg: Remove"},validate:{error:"Error:",minLength:"Value should be at least THRESHOLD characters long.",maxLength:"Value should be at most THRESHOLD characters long.",required:"A value is needed."}}),e}])}]),angular.module("ui.grid").factory("Grid",["$q","$compile","$parse","gridUtil","uiGridConstants","GridOptions","GridColumn","GridRow","GridApi","rowSorter","rowSearcher","GridRenderContainer","$timeout","ScrollEvent",function(v,r,n,h,s,c,u,d,g,p,t,f,i,C){function e(e){var r=this;if(void 0===e||void 0===e.id||!e.id)throw new Error("No ID provided. An ID must be given when creating a grid.");if(!/^[_a-zA-Z0-9-]+$/.test(e.id))throw new Error("Grid id '"+e.id+'" is invalid. It must follow CSS selector syntax rules.');function t(e){r.isScrollingVertically=!1,r.api.core.raise.scrollEnd(e),r.scrollDirection=s.scrollDirection.NONE}r.id=e.id,delete e.id,r.options=c.initialize(e),r.appScope=r.options.appScopeProvider,r.headerHeight=r.options.headerRowHeight,r.footerHeight=r.calcFooterHeight(),r.columnFooterHeight=r.calcColumnFooterHeight(),r.rtl=!1,r.gridHeight=0,r.gridWidth=0,r.columnBuilders=[],r.rowBuilders=[],r.rowsProcessors=[],r.columnsProcessors=[],r.styleComputations=[],r.viewportAdjusters=[],r.rowHeaderColumns=[],r.dataChangeCallbacks={},r.verticalScrollSyncCallBackFns={},r.horizontalScrollSyncCallBackFns={},r.renderContainers={},r.renderContainers.body=new f("body",r),r.cellValueGetterCache={},r.getRowTemplateFn=null,r.rows=[],r.columns=[],r.isScrollingVertically=!1,r.isScrollingHorizontally=!1,r.scrollDirection=s.scrollDirection.NONE,r.disableScrolling=!1;var i=h.debounce(t,r.options.scrollDebounce),n=h.debounce(t,0);function o(e){r.isScrollingHorizontally=!1,r.api.core.raise.scrollEnd(e),r.scrollDirection=s.scrollDirection.NONE}var l=h.debounce(o,r.options.scrollDebounce),a=h.debounce(o,0);r.flagScrollingVertically=function(e){r.isScrollingVertically||r.isScrollingHorizontally||r.api.core.raise.scrollBegin(e),r.isScrollingVertically=!0,(0!==r.options.scrollDebounce&&e.withDelay?i:n)(e)},r.flagScrollingHorizontally=function(e){r.isScrollingVertically||r.isScrollingHorizontally||r.api.core.raise.scrollBegin(e),r.isScrollingHorizontally=!0,(0!==r.options.scrollDebounce&&e.withDelay?l:a)(e)},r.scrollbarHeight=0,r.scrollbarWidth=0,r.options.enableHorizontalScrollbar!==s.scrollbars.NEVER&&(r.scrollbarHeight=h.getScrollbarWidth()),r.options.enableVerticalScrollbar!==s.scrollbars.NEVER&&(r.scrollbarWidth=h.getScrollbarWidth()),r.api=new g(r),r.api.registerMethod("core","refresh",this.refresh),r.api.registerMethod("core","queueGridRefresh",this.queueGridRefresh),r.api.registerMethod("core","refreshRows",this.refreshRows),r.api.registerMethod("core","queueRefresh",this.queueRefresh),r.api.registerMethod("core","handleWindowResize",this.handleWindowResize),r.api.registerMethod("core","addRowHeaderColumn",this.addRowHeaderColumn),r.api.registerMethod("core","scrollToIfNecessary",function(e,t){return r.scrollToIfNecessary(e,t)}),r.api.registerMethod("core","scrollTo",function(e,t){return r.scrollTo(e,t)}),r.api.registerMethod("core","registerRowsProcessor",this.registerRowsProcessor),r.api.registerMethod("core","registerColumnsProcessor",this.registerColumnsProcessor),r.api.registerMethod("core","sortHandleNulls",p.handleNulls),r.api.registerEvent("core","sortChanged"),r.api.registerEvent("core","columnVisibilityChanged"),r.api.registerMethod("core","notifyDataChange",this.notifyDataChange),r.api.registerMethod("core","clearAllFilters",this.clearAllFilters),r.registerDataChangeCallback(r.columnRefreshCallback,[s.dataChange.COLUMN]),r.registerDataChangeCallback(r.processRowsCallback,[s.dataChange.EDIT]),r.registerDataChangeCallback(r.updateFooterHeightCallback,[s.dataChange.OPTIONS]),r.registerStyleComputation({priority:10,func:r.getFooterStyles})}e.prototype.calcFooterHeight=function(){var e;return this.hasFooter()?(e=0,this.options.showGridFooter&&(e+=this.options.gridFooterHeight),e+this.calcColumnFooterHeight()):0},e.prototype.calcColumnFooterHeight=function(){var e=0;return this.options.showColumnFooter&&(e+=this.options.columnFooterHeight),e},e.prototype.getFooterStyles=function(){var e=".grid"+this.id+" .ui-grid-footer-aggregates-row { height: "+this.options.columnFooterHeight+"px; }";return e+=" .grid"+this.id+" .ui-grid-footer-info { height: "+this.options.gridFooterHeight+"px; }"},e.prototype.hasFooter=function(){return this.options.showGridFooter||this.options.showColumnFooter},e.prototype.isRTL=function(){return this.rtl},e.prototype.registerColumnBuilder=function(e){this.columnBuilders.push(e)},e.prototype.buildColumnDefsFromData=function(e){this.options.columnDefs=h.getColumnsFromData(e,this.options.excludeProperties)},e.prototype.registerRowBuilder=function(e){this.rowBuilders.push(e)},e.prototype.registerDataChangeCallback=function(e,t,r){var i=this,n=h.nextUid();return t=t||[s.dataChange.ALL],Array.isArray(t)||h.logError("Expected types to be an array or null in registerDataChangeCallback, value passed was: "+t),this.dataChangeCallbacks[n]={callback:e,types:t,_this:r},function(){delete i.dataChangeCallbacks[n]}},e.prototype.callDataChangeCallbacks=function(r,i){angular.forEach(this.dataChangeCallbacks,function(e,t){-1===e.types.indexOf(s.dataChange.ALL)&&-1===e.types.indexOf(r)&&r!==s.dataChange.ALL||(e._this?e.callback.apply(e._this,this,i):e.callback(this,i))},this)},e.prototype.notifyDataChange=function(e){var t=s.dataChange;e===t.ALL||e===t.COLUMN||e===t.EDIT||e===t.ROW||e===t.OPTIONS?this.callDataChangeCallbacks(e):h.logError("Notified of a data change, but the type was not recognised, so no action taken, type was: "+e)},e.prototype.columnRefreshCallback=function(e,t){e.buildColumns(t),e.queueGridRefresh()},e.prototype.processRowsCallback=function(e){e.queueGridRefresh()},e.prototype.updateFooterHeightCallback=function(e){e.footerHeight=e.calcFooterHeight(),e.columnFooterHeight=e.calcColumnFooterHeight()},e.prototype.getColumn=function(t){return o(this.columns,function(e){return e.colDef.name===t})},e.prototype.getColDef=function(t){return o(this.options.columnDefs,function(e){return e.name===t})},e.prototype.assignTypes=function(){var i=this;i.options.columnDefs.forEach(function(e,t){var r;e.type||(t=new u(e,t,i),r=0<i.rows.length?i.rows[0]:null,e.type=r?h.guessType(i.getCellValue(r,t)):"string")})},e.prototype.isRowHeaderColumn=function(e){return-1!==this.rowHeaderColumns.indexOf(e)},e.prototype.addRowHeaderColumn=function(e,t,r){var i=this,n=(void 0===t&&(t=0),new u(e,h.nextUid(),i));n.isRowHeader=!0,i.isRTL()?(i.createRightContainer(),n.renderContainer="right"):(i.createLeftContainer(),n.renderContainer="left"),i.columnBuilders[0](e,n,i.options).then(function(){n.enableFiltering=!1,n.enableSorting=!1,n.enableHiding=!1,n.headerPriority=t,i.rowHeaderColumns.push(n),i.rowHeaderColumns=i.rowHeaderColumns.sort(function(e,t){return e.headerPriority-t.headerPriority}),r||i.buildColumns().then(function(){i.preCompileCellTemplates(),i.queueGridRefresh()}).catch(angular.noop)}).catch(angular.noop)},e.prototype.getOnlyDataColumns=function(){var t=this,r=[];return t.columns.forEach(function(e){-1===t.rowHeaderColumns.indexOf(e)&&r.push(e)}),r},e.prototype.buildColumns=function(e){var t={orderByColumnDefs:!1},i=(angular.extend(t,e),this),n=[],o=i.rowHeaderColumns.length;for(s=0;s<i.columns.length;s++)i.getColDef(i.columns[s].name)||(i.columns.splice(s,1),s--);for(var r=i.rowHeaderColumns.length-1;0<=r;r--)i.columns.unshift(i.rowHeaderColumns[r]);if(i.options.columnDefs.forEach(function(t,e){i.preprocessColDef(t);var r=i.getColumn(t.name);r?r.updateColumnDef(t,!1):(r=new u(t,h.nextUid(),i),i.columns.splice(e+o,0,r)),i.columnBuilders.forEach(function(e){n.push(e.call(i,t,r,i.options))})}),t.orderByColumnDefs){for(var l=i.columns.slice(0),a=Math.min(i.options.columnDefs.length,i.columns.length),s=0;s<a;s++)i.columns[s+o].name!==i.options.columnDefs[s].name?l[s+o]=i.getColumn(i.options.columnDefs[s].name):l[s+o]=i.columns[s+o];i.columns.length=0,Array.prototype.splice.apply(i.columns,[0,0].concat(l))}return v.all(n).then(function(){0<i.rows.length&&i.assignTypes(),t.preCompileCellTemplates&&i.preCompileCellTemplates()}).catch(angular.noop)},e.prototype.preCompileCellTemplate=function(e){var t=(t=e.cellTemplate.replace(s.MODEL_COL_FIELD,this.getQualifiedColField(e))).replace(s.COL_FIELD,"grid.getCellValue(row, col)");e.compiledElementFn=r(t),e.compiledElementFnDefer&&e.compiledElementFnDefer.resolve(e.compiledElementFn)},e.prototype.preCompileCellTemplates=function(){var t=this;t.columns.forEach(function(e){e.cellTemplate?t.preCompileCellTemplate(e):e.cellTemplatePromise&&e.cellTemplatePromise.then(function(){t.preCompileCellTemplate(e)}).catch(angular.noop)})},e.prototype.getQualifiedColField=function(e){var t="row.entity";return e.field===s.ENTITY_BINDING?t:h.preEval(t+"."+e.field)},e.prototype.createLeftContainer=function(){this.hasLeftContainer()||(this.renderContainers.left=new f("left",this,{disableColumnOffset:!0}))},e.prototype.createRightContainer=function(){this.hasRightContainer()||(this.renderContainers.right=new f("right",this,{disableColumnOffset:!0}))},e.prototype.hasLeftContainer=function(){return void 0!==this.renderContainers.left},e.prototype.hasRightContainer=function(){return void 0!==this.renderContainers.right},e.prototype.preprocessColDef=function(e){if(!e.field&&!e.name)throw new Error("colDef.name or colDef.field property is required");if(void 0===e.name&&void 0!==e.field){for(var t=e.field,r=2;this.getColumn(t);)t=e.field+r.toString(),r++;e.name=t}},e.prototype.newInN=function(e,t,r,i){for(var n=[],o=0;o<t.length;o++){for(var l=i?t[o][i]:t[o],a=!1,s=0;s<e.length;s++){var c=r?e[s][r]:e[s];if(this.options.rowEquality(l,c)){a=!0;break}}a||n.push(l)}return n};var o=function(e,t){var r;return e&&e.length?angular.isFunction(e.find)?e.find(t)||null:(r=null,e.every(function(e){return!t(e)||(r=e,!1)}),r):null},l=(e.prototype.getRow=function(t,e){var r=this;return e=null==e?this.rows:e,o(e,function(e){return r.options.rowEquality(e.entity,t)})},e.prototype.getRowsByKey=function(e,t,r,i){return null==t?null:(i=null==i?this.rows:i).filter(e?function(e){return null!=e.entity&&e.entity.hasOwnProperty(t)&&e.entity[t]===r}:function(e){return e.hasOwnProperty(t)&&e[t]===r})},e.prototype.findRowByKey=function(e,t,r,i){var n=null;return null!=t&&(i=null==i?this.rows:i).every(e?function(e){return null==e.entity||!e.entity.hasOwnProperty(t)||e.entity[t]!==r||(n=e,!1)}:function(e){return!e.hasOwnProperty(t)||e[t]!==r||(n=e,!1)}),n},e.prototype.modifyRows=function(e){var n=this,o=n.rows.slice(0),l=n.rowHashMap||n.createRowHashMap(),a=!0,e=(n.rowHashMap=n.createRowHashMap(),n.rows.length=0,e.forEach(function(e,t){var r,i=n.options.enableRowHashing?l.get(e):n.getRow(e,o);i&&((r=i).entity=e,r.index!==t)&&(r.index=t),r=r||n.processRowBuilders(new d(e,t,n)),n.rows.push(r),n.rowHashMap.put(e,r),r.isSelected||(a=!1)}),n.selection&&n.rows.length&&(n.selection.selectAll=a),n.assignTypes(),v.when(n.processRowsProcessors(n.rows)).then(function(e){return n.setVisibleRows(e)}).catch(angular.noop)),t=v.when(n.processColumnsProcessors(n.columns)).then(function(e){return n.setVisibleColumns(e)}).catch(angular.noop);return v.all([e,t])},e.prototype.addRows=function(e){for(var t=this,r=t.rows.length,i=0;i<e.length;i++){var n,o=t.processRowBuilders(new d(e[i],i+r,t));t.options.enableRowHashing&&(n=t.rowHashMap.get(o.entity))&&(n.row=o),t.rows.push(o)}},e.prototype.processRowBuilders=function(t){var r=this;return r.rowBuilders.forEach(function(e){e.call(r,t,r.options)}),t},e.prototype.registerStyleComputation=function(e){this.styleComputations.push(e)},e.prototype.registerRowsProcessor=function(e,t){if(!angular.isFunction(e))throw"Attempt to register non-function rows processor: "+e;this.rowsProcessors.push({processor:e,priority:t}),this.rowsProcessors.sort(function(e,t){return e.priority-t.priority})},e.prototype.removeRowsProcessor=function(r){var i=-1;this.rowsProcessors.forEach(function(e,t){e.processor===r&&(i=t)}),-1!==i&&this.rowsProcessors.splice(i,1)},e.prototype.processRowsProcessors=function(e){var n,o=this,e=e.slice(0);return 0===o.rowsProcessors.length?v.when(e):(n=v.defer(),function t(r,e){var i=o.rowsProcessors[r].processor;return v.when(i.call(o,e,o.columns)).then(function(e){if(!e)throw"Processor at index "+r+" did not return a set of renderable rows";if(!angular.isArray(e))throw"Processor at index "+r+" did not return an array";if(++r<=o.rowsProcessors.length-1)return t(r,e);n.resolve(e)}).catch(function(e){throw e})}(0,e),n.promise)},e.prototype.setVisibleRows=function(e){var t,r=this;for(t in r.renderContainers){var i=r.renderContainers[t];i.canvasHeightShouldUpdate=!0,void 0===i.visibleRowCache?i.visibleRowCache=[]:i.visibleRowCache.length=0}for(var n=0;n<e.length;n++){var o=e[n],l=void 0!==o.renderContainer&&o.renderContainer?o.renderContainer:"body";o.visible&&r.renderContainers[l].visibleRowCache.push(o)}r.api.core.raise.rowsVisibleChanged(this.api),r.api.core.raise.rowsRendered(this.api)},e.prototype.registerColumnsProcessor=function(e,t){if(!angular.isFunction(e))throw"Attempt to register non-function rows processor: "+e;this.columnsProcessors.push({processor:e,priority:t}),this.columnsProcessors.sort(function(e,t){return e.priority-t.priority})},e.prototype.removeColumnsProcessor=function(e){e=this.columnsProcessors.indexOf(e);void 0!==e&&this.columnsProcessors.splice(e,1)},e.prototype.processColumnsProcessors=function(e){var n,o=this,l=e.slice(0);return 0===o.columnsProcessors.length?v.when(l):(n=v.defer(),function t(r,e){var i=o.columnsProcessors[r].processor;return v.when(i.call(o,e,o.rows)).then(function(e){if(!e)throw"Processor at index "+r+" did not return a set of renderable rows";if(!angular.isArray(e))throw"Processor at index "+r+" did not return an array";if(++r<=o.columnsProcessors.length-1)return t(r,l);n.resolve(l)}).catch(angular.noop)}(0,l),n.promise)},e.prototype.setVisibleColumns=function(e){for(var t in this.renderContainers)this.renderContainers[t].visibleColumnCache.length=0;for(var r=0;r<e.length;r++){var i=e[r];i.visible&&(void 0!==i.renderContainer&&i.renderContainer?this.renderContainers[i.renderContainer]:this.renderContainers.body).visibleColumnCache.push(i)}},e.prototype.handleWindowResize=function(e){var t=this;return t.gridWidth=h.elementWidth(t.element),t.gridHeight=h.elementHeight(t.element),t.queueRefresh()},e.prototype.queueRefresh=function(){var e=this;return e.refreshCanceller&&i.cancel(e.refreshCanceller),e.refreshCanceller=i(function(){e.refreshCanvas(!0)}),e.refreshCanceller.then(function(){e.refreshCanceller=null}).catch(angular.noop),e.refreshCanceller},e.prototype.queueGridRefresh=function(){var e=this;return e.gridRefreshCanceller&&i.cancel(e.gridRefreshCanceller),e.gridRefreshCanceller=i(function(){e.refresh(!0)}),e.gridRefreshCanceller.then(function(){e.gridRefreshCanceller=null}).catch(angular.noop),e.gridRefreshCanceller},e.prototype.updateCanvasHeight=function(){for(var e in this.renderContainers)this.renderContainers.hasOwnProperty(e)&&(this.renderContainers[e].canvasHeightShouldUpdate=!0)},e.prototype.buildStyles=function(){var t=this;t.customStyles="",t.styleComputations.sort(function(e,t){return null===e.priority?1:null===t.priority?-1:null===e.priority&&null===t.priority?0:e.priority-t.priority}).forEach(function(e){e=e.func.call(t);angular.isString(e)&&(t.customStyles+="\n"+e)})},e.prototype.minColumnsToRender=function(){var n=this,o=this.getViewportWidth(),l=0,a=0;return n.columns.forEach(function(e,t){if(a<o)a+=e.drawnWidth,l++;else{for(var r=0,i=t;t-l<=i;i--)r+=n.columns[i].drawnWidth;r<o&&l++}}),l},e.prototype.getBodyHeight=function(){return this.getViewportHeight()},e.prototype.getViewportHeight=function(){var e=this.gridHeight-this.headerHeight-this.footerHeight;return 0<(e+=this.getViewportAdjustment().height)?e:0},e.prototype.getViewportWidth=function(){var e=this.gridWidth;return e+=this.getViewportAdjustment().width},e.prototype.getHeaderViewportWidth=function(){return this.getViewportWidth()},e.prototype.addVerticalScrollSync=function(e,t){this.verticalScrollSyncCallBackFns[e]=t},e.prototype.addHorizontalScrollSync=function(e,t){this.horizontalScrollSyncCallBackFns[e]=t},e.prototype.scrollContainers=function(e,t){if(t.y){var r=["body","left","right"];this.flagScrollingVertically(t),"body"===e?r=["left","right"]:"left"===e?r=["body","right"]:"right"===e&&(r=["body","left"]);for(var i=0;i<r.length;i++){var n=r[i];this.verticalScrollSyncCallBackFns[n]&&this.verticalScrollSyncCallBackFns[n](t)}}if(t.x){var o=["body","bodyheader","bodyfooter"];this.flagScrollingHorizontally(t),"body"===e&&(o=["bodyheader","bodyfooter"]);for(var l=0;l<o.length;l++){var a=o[l];this.horizontalScrollSyncCallBackFns[a]&&this.horizontalScrollSyncCallBackFns[a](t)}}},e.prototype.registerViewportAdjuster=function(e){this.viewportAdjusters.push(e)},e.prototype.removeViewportAdjuster=function(e){e=this.viewportAdjusters.indexOf(e);void 0!==e&&this.viewportAdjusters.splice(e,1)},e.prototype.getViewportAdjustment=function(){var t={height:0,width:0};return this.viewportAdjusters.forEach(function(e){t=e.call(this,t)}),t},e.prototype.getVisibleRowCount=function(){return this.renderContainers.body.visibleRowCache.length},e.prototype.getVisibleRows=function(){return this.renderContainers.body.visibleRowCache},e.prototype.getVisibleColumnCount=function(){return this.renderContainers.body.visibleColumnCache.length},e.prototype.searchRows=function(e){return t.search(this,e,this.columns)},e.prototype.sortByColumn=function(e){return p.sort(this,e,this.columns)},e.prototype.getCellValue=function(e,t){return void 0!==e.entity["$$"+t.uid]?e.entity["$$"+t.uid].rendered:this.options.flatEntityAccess&&void 0!==t.field?e.entity[t.field]:(t.cellValueGetterCache||(t.cellValueGetterCache=n(e.getEntityQualifiedColField(t))),t.cellValueGetterCache(e))},e.prototype.getCellDisplayValue=function(e,t){t.cellDisplayGetterCache||(r=t.cellFilter?" | "+t.cellFilter:"",void 0!==e.entity["$$"+t.uid]?t.cellDisplayGetterCache=n(e.entity["$$"+t.uid].rendered+r):this.options.flatEntityAccess&&void 0!==t.field?(i=t.field.replace(/(')|(\\)/g,"\\$&"),t.cellDisplayGetterCache=n("entity['"+i+"']"+r)):t.cellDisplayGetterCache=n(e.getEntityQualifiedColField(t)+r));var r,i=angular.extend({},e,{col:t});return t.cellDisplayGetterCache(i)},e.prototype.getNextColumnSortPriority=function(){var t=0;return this.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>=t&&(t=e.sort.priority+1)}),t},e.prototype.resetColumnSorting=function(t){this.columns.forEach(function(e){e===t||e.suppressRemoveSort||(e.sort={})})},e.prototype.getColumnSorting=function(){var t=[];return this.columns.slice(0).sort(p.prioritySort).forEach(function(e){e.sort&&void 0!==e.sort.direction&&e.sort.direction&&(e.sort.direction===s.ASC||e.sort.direction===s.DESC)&&t.push(e)}),t},e.prototype.sortColumn=function(e,t,r){var i=this,n=null;if(void 0!==e&&e)return"boolean"==typeof t?r=t:n=t,!r||i.options&&i.options.suppressMultiSort?(i.resetColumnSorting(e),e.sort.priority=void 0,e.sort.priority=i.getNextColumnSortPriority()):void 0===e.sort.priority&&(e.sort.priority=i.getNextColumnSortPriority()),n?e.sort.direction=n:(t=((t=e.sortDirectionCycle.indexOf(e.sort&&e.sort.direction?e.sort.direction:null))+1)%e.sortDirectionCycle.length,e.colDef&&e.suppressRemoveSort&&!e.sortDirectionCycle[t]&&(t=(t+1)%e.sortDirectionCycle.length),e.sortDirectionCycle[t]?e.sort.direction=e.sortDirectionCycle[t]:l(e,i)),i.api.core.raise.sortChanged(i,i.getColumnSorting()),v.when(e);throw new Error("No column parameter provided")},function(t,e){e.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>t.sort.priority&&--e.sort.priority}),t.sort={}});function a(e,t){return e||0<t?t:null}function m(e,t){e/=t;return e<=1?e:1}function w(e,t,r){if(m(e,t)!==r)return{percentage:m(e,t)}}function y(e,t,r){e/=t;if((e=1<e?1:e)!==r)return{percentage:e}}function b(){}return e.prototype.renderingComplete=function(){angular.isFunction(this.options.onRegisterApi)&&this.options.onRegisterApi(this.api),this.api.core.raise.renderingComplete(this.api)},e.prototype.createRowHashMap=function(){var e=new b;return e.grid=this,e},e.prototype.refresh=function(e){var t=this,r=t.processRowsProcessors(t.rows).then(function(e){t.setVisibleRows(e)}).catch(angular.noop),i=t.processColumnsProcessors(t.columns).then(function(e){t.setVisibleColumns(e)}).catch(angular.noop);return v.all([r,i]).then(function(){t.refreshCanvas(!0),t.redrawInPlace(e)}).catch(angular.noop)},e.prototype.refreshRows=function(){var t=this;return t.processRowsProcessors(t.rows).then(function(e){t.setVisibleRows(e),t.redrawInPlace(),t.refreshCanvas(!0)}).catch(angular.noop)},e.prototype.refreshCanvas=function(c){var e,t,u=this,d=v.defer(),g=[];for(e in u.renderContainers)!u.renderContainers.hasOwnProperty(e)||null===(t=u.renderContainers[e]).canvasWidth||isNaN(t.canvasWidth)||(t.header||t.headerCanvas)&&(t.explicitHeaderHeight=t.explicitHeaderHeight||null,t.explicitHeaderCanvasHeight=t.explicitHeaderCanvasHeight||null,g.push(t));return c&&u.buildStyles(),i(0<g.length?function(){function e(e,t){return e!==t&&(o=!0),t}for(var t,r,i,n,o=!1,l=0,a=0,s=0;s<g.length;s++)null===(n=g[s]).canvasWidth||isNaN(n.canvasWidth)||(n.header&&(r=n.headerHeight=e(n.headerHeight,h.outerElementHeight(n.header)),i=h.getBorderSize(n.header,"top"),t=h.getBorderSize(n.header,"bottom"),r=parseInt(r-i-t,10),n.innerHeaderHeight=r=r<0?0:r,!n.explicitHeaderHeight)&&l<r&&(l=r),n.headerCanvas&&(i=n.headerCanvasHeight=e(n.headerCanvasHeight,parseInt(h.outerElementHeight(n.headerCanvas),10)),!n.explicitHeaderCanvasHeight)&&a<i&&(a=i));for(s=0;s<g.length;s++)n=g[s],0<l&&void 0!==n.headerHeight&&null!==n.headerHeight&&(n.explicitHeaderHeight||n.headerHeight<l)&&(n.explicitHeaderHeight=e(n.explicitHeaderHeight,l)),0<a&&void 0!==n.headerCanvasHeight&&null!==n.headerCanvasHeight&&(n.explicitHeaderCanvasHeight||n.headerCanvasHeight<a)&&(n.explicitHeaderCanvasHeight=e(n.explicitHeaderCanvasHeight,a));c&&o&&u.buildStyles(),d.resolve()}:function(){d.resolve()}),d.promise},e.prototype.redrawInPlace=function(e){for(var t in this.renderContainers){var t=this.renderContainers[t],r=a(e,t.prevScrollTop),i=a(e,t.prevScrollLeft),n=e||0<r?null:t.prevScrolltopPercentage;t.adjustRows(r,n),t.adjustColumns(i)}},e.prototype.hasLeftContainerColumns=function(){return this.hasLeftContainer()&&0<this.renderContainers.left.renderedColumns.length},e.prototype.hasRightContainerColumns=function(){return this.hasRightContainer()&&0<this.renderContainers.right.renderedColumns.length},e.prototype.scrollToIfNecessary=function(e,t){var r,i=this,n=new C(i,"uiGrid.scrollToIfNecessary"),o=i.renderContainers.body.visibleRowCache,l=i.renderContainers.body.visibleColumnCache,a=(a=i.renderContainers.body.prevScrollTop)<0?0:a,s=i.renderContainers.body.prevScrollLeft,c=i.renderContainers.body.prevScrollTop+i.gridHeight-i.renderContainers.body.headerHeight-i.footerHeight-i.scrollbarHeight,u=i.renderContainers.body.prevScrollLeft+Math.ceil(i.renderContainers.body.getViewportWidth());if(null!==e&&(o=o.indexOf(e),e=i.renderContainers.body.getCanvasHeight()-i.renderContainers.body.getViewportHeight(),(o=(o=o*i.options.rowHeight)<0?0:o)<Math.floor(a)?(r=i.renderContainers.body.prevScrollTop-(a-o),t&&t.colDef&&t.colDef.enableCellEditOnFocus&&(r=r-i.footerHeight-i.scrollbarHeight),n.y=w(r,e,i.renderContainers.body.prevScrolltopPercentage)):o+i.options.rowHeight>Math.ceil(c)&&(r=o+i.options.rowHeight-c+i.renderContainers.body.prevScrollTop,n.y=w(r,e,i.renderContainers.body.prevScrolltopPercentage))),null!==t){for(var d=l.indexOf(t),a=i.renderContainers.body.getCanvasWidth()-i.renderContainers.body.getViewportWidth(),g=0,h=0;h<d;h++)g+=l[h].drawnWidth;var p,o=(o=(g=g<0?0:g)+t.drawnWidth)<0?0:o;g<s?(p=i.renderContainers.body.prevScrollLeft-(s-g),n.x=y(p,a,i.renderContainers.body.prevScrollleftPercentage)):u<o&&(p=o-u+i.renderContainers.body.prevScrollLeft,n.x=y(p,a,i.renderContainers.body.prevScrollleftPercentage))}var f,m=v.defer();return n.y||n.x?(n.withDelay=!1,i.scrollContainers("",n),f=i.api.core.on.scrollEnd(null,function(){m.resolve(n),f()})):m.resolve(),m.promise},e.prototype.scrollTo=function(e,t){var r=null,i=null;return null!=e&&(r=this.getRow(e)),null!=t&&(i=this.getColumn(t.name||t.field)),this.scrollToIfNecessary(r,i)},e.prototype.clearAllFilters=function(e,t,r){if(void 0===e&&(e=!0),void 0===t&&(t=!1),void 0===r&&(r=!1),this.columns.forEach(function(e){e.filters.forEach(function(e){e.term=void 0,t&&(e.condition=void 0),r&&(e.flags=void 0)})}),e)return this.refreshRows()},b.prototype={put:function(e,t){this[this.grid.options.rowIdentity(e)]=t},get:function(e){return this[this.grid.options.rowIdentity(e)]},remove:function(e){var t=this[e=this.grid.options.rowIdentity(e)];return delete this[e],t}},e}]),angular.module("ui.grid").factory("GridApi",["$q","$rootScope","gridUtil","uiGridConstants","GridRow",function(e,t,c,r,i){function n(e){this.grid=e,this.listeners=[],this.registerEvent("core","renderingComplete"),this.registerEvent("core","filterChanged"),this.registerMethod("core","setRowInvisible",i.prototype.setRowInvisible),this.registerMethod("core","clearRowInvisible",i.prototype.clearRowInvisible),this.registerMethod("core","getVisibleRows",this.grid.getVisibleRows),this.registerEvent("core","rowsVisibleChanged"),this.registerEvent("core","rowsRendered"),this.registerEvent("core","scrollBegin"),this.registerEvent("core","scrollEnd"),this.registerEvent("core","canvasHeightChanged"),this.registerEvent("core","gridDimensionChanged")}function u(e,r,i,n){return t.$on(e,function(e){var t=Array.prototype.slice.call(arguments);t.splice(0,1),r.apply(n||i.api,t)})}return n.prototype.suppressEvents=function(e,t){var r=this,i=angular.isArray(e)?e:[e],e=r.listeners.filter(function(t){return i.some(function(e){return t.handler===e})});e.forEach(function(e){e.dereg()}),t(),e.forEach(function(e){e.dereg=u(e.eventId,e.handler,r.grid,e._this)})},n.prototype.registerEvent=function(o,l){var a=this,e=(a[o]||(a[o]={}),a[o]),s=(e.on||(e.on={},e.raise={}),a.grid.id+o+l);e.raise[l]=function(){t.$emit.apply(t,[s].concat(Array.prototype.slice.call(arguments)))},e.on[l]=function(e,t,r){var i,n;if(null===e||void 0!==e.$on)return i={handler:t,dereg:u(s,t,a.grid,r),eventId:s,scope:e,_this:r},a.listeners.push(i),n=function(){i.dereg();var e=a.listeners.indexOf(i);a.listeners.splice(e,1)},e&&e.$on("$destroy",function(){n()}),n;c.logError("asked to listen on "+o+".on."+l+" but scope wasn't passed in the input parameters.  It is legitimate to pass null, but you've passed something else, so you probably forgot to provide scope rather than did it deliberately, not registering")}},n.prototype.registerEventsFromObject=function(e){var r=this,i=[];angular.forEach(e,function(e,t){var r={name:t,events:[]};angular.forEach(e,function(e,t){r.events.push(t)}),i.push(r)}),i.forEach(function(t){t.events.forEach(function(e){r.registerEvent(t.name,e)})})},n.prototype.registerMethod=function(e,t,r,i){this[e]||(this[e]={}),this[e][t]=c.createBoundedWrapper(i||this.grid,r)},n.prototype.registerMethodsFromObject=function(e,r){var i=this,n=[];angular.forEach(e,function(e,t){var r={name:t,methods:[]};angular.forEach(e,function(e,t){r.methods.push({name:t,fn:e})}),n.push(r)}),n.forEach(function(t){t.methods.forEach(function(e){i.registerMethod(t.name,e.name,e.fn,r)})})},n}]),angular.module("ui.grid").factory("GridColumn",["gridUtil","uiGridConstants","i18nService",function(s,c,e){function t(e,t,r){var i=this;i.grid=r,i.uid=t,i.updateColumnDef(e,!0),i.aggregationValue=void 0,i.updateAggregationValue=function(){var t,e,r;i.aggregationType?(t=0,e=i.grid.getVisibleRows(),r=function(){var t=[];return e.forEach(function(e){e=i.grid.getCellValue(e,i),e=Number(e);isNaN(e)||t.push(e)}),t},angular.isFunction(i.aggregationType)?i.aggregationValue=i.aggregationType(e,i):i.aggregationType===c.aggregationTypes.count?i.aggregationValue=i.grid.getVisibleRowCount():i.aggregationType===c.aggregationTypes.sum?(r().forEach(function(e){t+=e}),i.aggregationValue=t):i.aggregationType===c.aggregationTypes.avg?(r().forEach(function(e){t+=e}),t/=r().length,i.aggregationValue=t):i.aggregationType===c.aggregationTypes.min?i.aggregationValue=Math.min.apply(null,r()):i.aggregationType===c.aggregationTypes.max?i.aggregationValue=Math.max.apply(null,r()):i.aggregationValue=" "):i.aggregationValue=void 0},this.getAggregationValue=function(){return i.aggregationValue}}function u(e){return void 0===e.displayName?s.readableColumnName(e.name):e.displayName}return t.prototype.hideColumn=function(){this.colDef.visible=!1},t.prototype.setPropertyOrDefault=function(e,t,r){var i=this;void 0!==e[t]&&e[t]?i[t]=e[t]:void 0!==i[t]?i[t]=i[t]:i[t]=r||{}},t.prototype.updateColumnDef=function(i,e){var n=this;if(void 0===(n.colDef=i).name)throw new Error("colDef.name is required for column at index "+n.grid.options.columnDefs.indexOf(i));if(n.displayName=u(i),!angular.isNumber(n.width)||!n.hasCustomWidth||i.allowCustomWidthOverride){var t=i.width,r="Cannot parse column width '"+t+"' for column named '"+i.name+"'";if(n.hasCustomWidth=!1,angular.isString(t)||angular.isNumber(t))if(angular.isString(t))if(s.endsWith(t,"%")){var o=t.replace(/%/g,""),o=parseInt(o,10);if(isNaN(o))throw new Error(r);n.width=t}else if(t.match(/^(\d+)$/))n.width=parseInt(t.match(/^(\d+)$/)[1],10);else{if(!t.match(/^\*+$/))throw new Error(r);n.width=t}else n.width=t;else n.width="*"}function l(e){return angular.isString(e)||angular.isNumber(e)}["minWidth","maxWidth"].forEach(function(e){var t=i[e],r="Cannot parse column "+e+" '"+t+"' for column named '"+i.name+"'";if("minWidth"===e&&!l(t)&&angular.isDefined(n.grid.options.minimumColumnSize)&&(t=n.grid.options.minimumColumnSize),l(t))if(angular.isString(t)){if(!t.match(/^(\d+)$/))throw new Error(r);n[e]=parseInt(t.match(/^(\d+)$/)[1],10)}else n[e]=t;else n[e]="minWidth"===e?30:9e3}),n.field=void 0===i.field?i.name:i.field,"string"!=typeof n.field&&s.logError("Field is not a string, this is likely to break the code, Field is: "+n.field),n.name=i.name,n.displayName=u(i),n.aggregationType=angular.isDefined(i.aggregationType)?i.aggregationType:null,n.footerCellTemplate=angular.isDefined(i.footerCellTemplate)?i.footerCellTemplate:null,void 0===i.cellTooltip||!1===i.cellTooltip?n.cellTooltip=!1:!0===i.cellTooltip?n.cellTooltip=function(e,t){return n.grid.getCellValue(e,t)}:"function"==typeof i.cellTooltip?n.cellTooltip=i.cellTooltip:n.cellTooltip=function(e,t){return t.colDef.cellTooltip},void 0===i.headerTooltip||!1===i.headerTooltip?n.headerTooltip=!1:!0===i.headerTooltip?n.headerTooltip=function(e){return e.displayName}:"function"==typeof i.headerTooltip?n.headerTooltip=i.headerTooltip:n.headerTooltip=function(e){return e.colDef.headerTooltip},n.footerCellClass=i.footerCellClass,n.cellClass=i.cellClass,n.headerCellClass=i.headerCellClass,n.cellFilter=i.cellFilter||"",n.sortCellFiltered=!!i.sortCellFiltered,n.filterCellFiltered=!!i.filterCellFiltered,n.headerCellFilter=i.headerCellFilter||"",n.footerCellFilter=i.footerCellFilter||"",n.visible=s.isNullOrUndefined(i.visible)||i.visible,n.headerClass=i.headerClass,n.enableSorting=(void 0!==i.enableSorting?i:n.grid.options).enableSorting,n.sortingAlgorithm=i.sortingAlgorithm,n.sortDirectionCycle=void 0!==i.sortDirectionCycle?i.sortDirectionCycle:[null,c.ASC,c.DESC],void 0===n.suppressRemoveSort&&(n.suppressRemoveSort=void 0!==i.suppressRemoveSort&&i.suppressRemoveSort),n.enableFiltering=void 0===i.enableFiltering||i.enableFiltering,n.filterContainer=(void 0!==i.filterContainer?i:n.grid.options).filterContainer,n.setPropertyOrDefault(i,"menuItems",[]),e&&n.setPropertyOrDefault(i,"sort"),n.setPropertyOrDefault(i,"defaultSort");var a=[];i.filter?a.push(i.filter):i.filters?a=i.filters:a.push({}),e?(n.setPropertyOrDefault(i,"filter"),n.setPropertyOrDefault(i,"extraStyle"),n.setPropertyOrDefault(i,"filters",a)):n.filters.length===a.length&&n.filters.forEach(function(e,t){void 0!==a[t].placeholder&&(e.placeholder=a[t].placeholder),void 0!==a[t].ariaLabel&&(e.ariaLabel=a[t].ariaLabel),void 0!==a[t].flags&&(e.flags=a[t].flags),void 0!==a[t].type&&(e.type=a[t].type),void 0!==a[t].selectOptions&&(e.selectOptions=a[t].selectOptions)})},t.prototype.unsort=function(){var t=this.sort.priority;this.grid.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>t&&--e.sort.priority}),this.sort={},this.grid.api.core.raise.sortChanged(this.grid,this.grid.getColumnSorting())},t.prototype.getColClass=function(e){var t=c.COL_CLASS_PREFIX+this.uid;return e?"."+t:t},t.prototype.isPinnedLeft=function(){return"left"===this.renderContainer},t.prototype.isPinnedRight=function(){return"right"===this.renderContainer},t.prototype.getColClassDefinition=function(){return" .grid"+this.grid.id+" "+this.getColClass(!0)+" { min-width: "+this.drawnWidth+"px; max-width: "+this.drawnWidth+"px; }"},t.prototype.getRenderContainer=function(){var e=this.renderContainer;return this.grid.renderContainers[e=null!==e&&""!==e&&void 0!==e?e:"body"]},t.prototype.showColumn=function(){this.colDef.visible=!0},t.prototype.getAggregationText=function(){if(this.colDef.aggregationHideLabel)return"";if(this.colDef.aggregationLabel)return this.colDef.aggregationLabel;switch(this.colDef.aggregationType){case c.aggregationTypes.count:return e.getSafeText("aggregation.count");case c.aggregationTypes.sum:return e.getSafeText("aggregation.sum");case c.aggregationTypes.avg:return e.getSafeText("aggregation.avg");case c.aggregationTypes.min:return e.getSafeText("aggregation.min");case c.aggregationTypes.max:return e.getSafeText("aggregation.max");default:return""}},t.prototype.getCellTemplate=function(){return this.cellTemplatePromise},t.prototype.getCompiledElementFn=function(){return this.compiledElementFnDefer.promise},t}]),angular.module("ui.grid").factory("GridOptions",["gridUtil","uiGridConstants",function(t,r){return{initialize:function(e){return e.onRegisterApi=e.onRegisterApi||angular.noop(),e.data=e.data||[],e.columnDefs=e.columnDefs||[],e.excludeProperties=e.excludeProperties||["$$hashKey"],e.enableRowHashing=!1!==e.enableRowHashing,e.rowIdentity=e.rowIdentity||function(e){return t.hashKey(e)},e.getRowIdentity=e.getRowIdentity||function(e){return e.$$hashKey},e.flatEntityAccess=!0===e.flatEntityAccess,e.showHeader=void 0===e.showHeader||e.showHeader,e.showHeader?e.headerRowHeight=void 0!==e.headerRowHeight?e.headerRowHeight:30:e.headerRowHeight=0,"string"==typeof e.rowHeight?e.rowHeight=parseInt(e.rowHeight)||30:e.rowHeight=e.rowHeight||30,e.minRowsToShow=void 0!==e.minRowsToShow?e.minRowsToShow:10,e.showGridFooter=!0===e.showGridFooter,e.showColumnFooter=!0===e.showColumnFooter,e.columnFooterHeight=void 0!==e.columnFooterHeight?e.columnFooterHeight:30,e.gridFooterHeight=void 0!==e.gridFooterHeight?e.gridFooterHeight:30,e.columnWidth=void 0!==e.columnWidth?e.columnWidth:50,e.maxVisibleColumnCount=void 0!==e.maxVisibleColumnCount?e.maxVisibleColumnCount:200,e.virtualizationThreshold=void 0!==e.virtualizationThreshold?e.virtualizationThreshold:20,e.columnVirtualizationThreshold=void 0!==e.columnVirtualizationThreshold?e.columnVirtualizationThreshold:10,e.excessRows=void 0!==e.excessRows?e.excessRows:4,e.scrollThreshold=void 0!==e.scrollThreshold?e.scrollThreshold:4,e.excessColumns=void 0!==e.excessColumns?e.excessColumns:4,e.aggregationCalcThrottle=void 0!==e.aggregationCalcThrottle?e.aggregationCalcThrottle:500,e.wheelScrollThrottle=void 0!==e.wheelScrollThrottle?e.wheelScrollThrottle:70,e.scrollDebounce=void 0!==e.scrollDebounce?e.scrollDebounce:300,e.enableHiding=!1!==e.enableHiding,e.enableSorting=!1!==e.enableSorting,e.suppressMultiSort=!0===e.suppressMultiSort,e.enableFiltering=!0===e.enableFiltering,e.filterContainer=void 0!==e.filterContainer?e.filterContainer:"headerCell",e.enableColumnMenus=!1!==e.enableColumnMenus,e.enableVerticalScrollbar=void 0!==e.enableVerticalScrollbar?e.enableVerticalScrollbar:r.scrollbars.ALWAYS,e.enableHorizontalScrollbar=void 0!==e.enableHorizontalScrollbar?e.enableHorizontalScrollbar:r.scrollbars.ALWAYS,e.enableMinHeightCheck=!1!==e.enableMinHeightCheck,e.minimumColumnSize=void 0!==e.minimumColumnSize?e.minimumColumnSize:30,e.rowEquality=e.rowEquality||function(e,t){return e===t},e.headerTemplate=e.headerTemplate||null,e.footerTemplate=e.footerTemplate||"ui-grid/ui-grid-footer",e.gridFooterTemplate=e.gridFooterTemplate||"ui-grid/ui-grid-grid-footer",e.rowTemplate=e.rowTemplate||"ui-grid/ui-grid-row",e.gridMenuTemplate=e.gridMenuTemplate||"ui-grid/uiGridMenu",e.disableGridMenuHideOnScroll=e.disableGridMenuHideOnScroll||!1,e.menuButtonTemplate=e.menuButtonTemplate||"ui-grid/ui-grid-menu-button",e.menuItemTemplate=e.menuItemTemplate||"ui-grid/uiGridMenuItem",e.appScopeProvider=e.appScopeProvider||null,e}}}]),angular.module("ui.grid").factory("GridRenderContainer",["gridUtil","uiGridConstants",function(y,i){function e(e,t,r){var i=this;i.name=e,i.grid=t,i.visibleRowCache=[],i.visibleColumnCache=[],i.renderedRows=[],i.renderedColumns=[],i.prevScrollTop=0,i.prevScrolltopPercentage=0,i.prevRowScrollIndex=0,i.prevScrollLeft=0,i.prevScrollleftPercentage=0,i.prevColumnScrollIndex=0,i.columnStyles="",i.viewportAdjusters=[],i.hasHScrollbar=!1,i.hasVScrollbar=!1,i.canvasHeightShouldUpdate=!0,i.$$canvasHeight=0,r&&angular.isObject(r)&&angular.extend(i,r),t.registerStyleComputation({priority:5,func:function(){return i.updateColumnWidths(),i.columnStyles}})}return e.prototype.reset=function(){this.visibleColumnCache.length=0,this.visibleRowCache.length=0,this.renderedRows.length=0,this.renderedColumns.length=0},e.prototype.containsColumn=function(e){return-1!==this.visibleColumnCache.indexOf(e)},e.prototype.minRowsToRender=function(){for(var e=0,t=0,r=this.getViewportHeight(),i=this.visibleRowCache.length-1;t<r&&0<=i;i--)t+=this.visibleRowCache[i].height,e++;return e},e.prototype.minColumnsToRender=function(){for(var e=this.getViewportWidth(),t=0,r=0,i=0;i<this.visibleColumnCache.length;i++){var n=this.visibleColumnCache[i];if(r<e)r+=n.drawnWidth||0,t++;else{for(var o=0,l=i;i-t<=l;l--)o+=this.visibleColumnCache[l].drawnWidth||0;o<e&&t++}}return t},e.prototype.getVisibleRowCount=function(){return this.visibleRowCache.length},e.prototype.registerViewportAdjuster=function(e){this.viewportAdjusters.push(e)},e.prototype.removeViewportAdjuster=function(e){e=this.viewportAdjusters.indexOf(e);-1<e&&this.viewportAdjusters.splice(e,1)},e.prototype.getViewportAdjustment=function(){var t={height:0,width:0};return this.viewportAdjusters.forEach(function(e){t=e.call(this,t)}),t},e.prototype.getMargin=function(t){var r=0;return this.viewportAdjusters.forEach(function(e){e=e.call(this,{height:0,width:0});e.side&&e.side===t&&(r+=-1*e.width)}),r},e.prototype.getViewportHeight=function(){var e=this,t=e.headerHeight||e.grid.headerHeight,t=e.grid.gridHeight-t-e.grid.footerHeight;return 0<(t+=e.getViewportAdjustment().height)?t:0},e.prototype.getViewportWidth=function(){var e=this.grid.gridWidth;return e+=this.getViewportAdjustment().width},e.prototype.getHeaderViewportWidth=function(){return this.getViewportWidth()},e.prototype.getCanvasHeight=function(){var e,t=this;return t.canvasHeightShouldUpdate&&(e=t.$$canvasHeight,t.$$canvasHeight=0,t.visibleRowCache.forEach(function(e){t.$$canvasHeight+=e.height}),t.canvasHeightShouldUpdate=!1,t.grid.api.core.raise.canvasHeightChanged(e,t.$$canvasHeight)),t.$$canvasHeight},e.prototype.getVerticalScrollLength=function(){return this.getCanvasHeight()-this.getViewportHeight()+this.grid.scrollbarHeight!==0?this.getCanvasHeight()-this.getViewportHeight()+this.grid.scrollbarHeight:-1},e.prototype.getHorizontalScrollLength=function(){return this.getCanvasWidth()-this.getViewportWidth()+this.grid.scrollbarWidth!==0?this.getCanvasWidth()-this.getViewportWidth()+this.grid.scrollbarWidth:-1},e.prototype.getCanvasWidth=function(){return this.canvasWidth},e.prototype.setRenderedRows=function(e){this.renderedRows.length=e.length;for(var t=0;t<e.length;t++)this.renderedRows[t]=e[t]},e.prototype.setRenderedColumns=function(e){this.renderedColumns.length=e.length;for(var t=0;t<e.length;t++)this.renderedColumns[t]=e[t];this.updateColumnOffset()},e.prototype.updateColumnOffset=function(){for(var e=0,t=0;t<this.currentFirstColumn;t++)e+=this.visibleColumnCache[t].drawnWidth;this.columnOffset=e},e.prototype.scrollVertical=function(e){var t,r=-1;if(e!==this.prevScrollTop)return 0<(t=e-this.prevScrollTop)&&(this.grid.scrollDirection=i.scrollDirection.DOWN),t<0&&(this.grid.scrollDirection=i.scrollDirection.UP),r=e/this.getVerticalScrollLength(),this.adjustScrollVertical(e,r=(r=1<r?1:r)<0?0:r),r},e.prototype.scrollHorizontal=function(e){var t,r=-1;if(e!==this.prevScrollLeft)return 0<(t=e-this.prevScrollLeft)&&(this.grid.scrollDirection=i.scrollDirection.RIGHT),t<0&&(this.grid.scrollDirection=i.scrollDirection.LEFT),t=this.getHorizontalScrollLength(),this.adjustScrollHorizontal(e,r=0!==t?e/t:0),r},e.prototype.adjustScrollVertical=function(e,t,r){this.prevScrollTop===e&&!r||(null==e&&(e=(this.getCanvasHeight()-this.getViewportHeight())*t),this.adjustRows(e,t,!1),this.prevScrollTop=e,this.prevScrolltopPercentage=t,this.grid.queueRefresh())},e.prototype.adjustScrollHorizontal=function(e,t,r){this.prevScrollLeft===e&&!r||(null==e&&(e=(this.getCanvasWidth()-this.getViewportWidth())*t),this.adjustColumns(e),this.prevScrollLeft=e,this.prevScrollleftPercentage=t,this.grid.queueRefresh())},e.prototype.adjustRows=function(e,t,r){var i=this,n=i.minRowsToRender(),o=i.visibleRowCache,l=o.length-n,t=(null==t&&e&&(t=e/i.getVerticalScrollLength()),Math.ceil(Math.min(l,l*t))),a=(l<t&&(t=l),[]);if(o.length>i.grid.options.virtualizationThreshold){if(null!=e){if(!i.grid.suppressParentScrollDown&&i.prevScrollTop<e&&t<i.prevRowScrollIndex+i.grid.options.scrollThreshold&&t<l)return;if(!i.grid.suppressParentScrollUp&&i.prevScrollTop>e&&t>i.prevRowScrollIndex-i.grid.options.scrollThreshold&&t<l)return}a=[Math.max(0,t-i.grid.options.excessRows),Math.min(o.length,t+n+i.grid.options.excessRows)]}else{e=i.visibleRowCache.length;a=[0,Math.max(e,n+i.grid.options.excessRows)]}i.updateViewableRowRange(a),i.prevRowScrollIndex=t},e.prototype.adjustColumns=function(e){var t=this,r=t.minColumnsToRender(),i=t.visibleColumnCache,n=i.length-r,n=Math.min(n,t.getLeftIndex(e)),e=[];e=i.length>t.grid.options.columnVirtualizationThreshold&&t.getCanvasWidth()>t.getViewportWidth()?[Math.max(0,n-t.grid.options.excessColumns),Math.min(i.length,n+r+t.grid.options.excessColumns)]:(i=t.visibleColumnCache.length,[0,Math.max(i,r+t.grid.options.excessColumns)]),t.updateViewableColumnRange(e),t.prevColumnScrollIndex=n},e.prototype.getLeftIndex=function(e){for(var t=0,r=0;r<this.visibleColumnCache.length&&!(this.visibleColumnCache[r]&&this.visibleColumnCache[r].visible&&e<=(t+=this.visibleColumnCache[r].drawnWidth));r++);return r},e.prototype.updateViewableRowRange=function(e){var t=this.visibleRowCache.slice(e[0],e[1]);this.currentTopRow=e[0],this.setRenderedRows(t)},e.prototype.updateViewableColumnRange=function(e){var t=this.visibleColumnCache.slice(e[0],e[1]);this.currentFirstColumn=e[0],this.setRenderedColumns(t)},e.prototype.headerCellWrapperStyle=function(){var e;return 0!==this.currentFirstColumn?(e=this.columnOffset,this.grid.isRTL()?{"margin-right":e+"px"}:{"margin-left":e+"px"}):null},e.prototype.updateColumnWidths=function(){var r,e,i=this,n=[],o=0,l=0,t="",a=!1,s=[],c=[],u=0,d=i.grid.getViewportWidth()-i.grid.scrollbarWidth,g=[],h=(angular.forEach(i.grid.renderContainers,function(e){g=g.concat(e.visibleColumnCache)}),g.forEach(function(e){var t,r=0;e.visible&&((a=!a&&e.colDef.pinnedRight?!0:a)&&(d+=i.grid.scrollbarWidth),angular.isNumber(e.width)?(r=e.colDef.allowFloatWidth?parseFloat(e.width):parseInt(e.width,10),l+=r,e.drawnWidth=r,s.push(e)):y.endsWith(e.width,"%")?(t=parseInt(e.width.replace(/%/g,""),10),(r=(r=e.colDef.allowFloatWidth?parseFloat(t/100*d):parseInt(t/100*d,10))>e.maxWidth?e.maxWidth:r)<e.minWidth&&(r=e.minWidth),l+=r,e.drawnWidth=r,u+=t,c.push(e)):angular.isString(e.width)&&-1!==e.width.indexOf("*")&&(o+=e.width.length,n.push(e)))}),d-l);if(0<n.length&&(r=h/o,n.forEach(function(e){var t=parseInt(e.width.length*r,10);(t=(t=e.colDef.allowFloatWidth?parseFloat(e.width.length*r):t)>e.maxWidth?e.maxWidth:t)<e.minWidth&&(t=e.minWidth),l+=t,e.drawnWidth=t})),0<n.length?e=n:0<c.length&&0===s.length&&100===u&&(e=c),!angular.isUndefined(e)){function p(e){e.drawnWidth<e.maxWidth&&0<f&&(e.drawnWidth++,l++,f--,m=!0)}for(var f=d-l,m=!0;0<f&&m;)m=!1,e.forEach(p);function v(e){e.drawnWidth>e.minWidth&&0<C&&(e.drawnWidth--,l--,C--,m=!0)}for(var C=l-d,m=!0;0<C&&m;)m=!1,e.forEach(v)}var w=0;i.visibleColumnCache.forEach(function(e){e.visible&&(w+=e.drawnWidth)}),g.forEach(function(e){t+=e.getColClassDefinition()}),i.canvasWidth=w,this.columnStyles=t},e.prototype.needsHScrollbarPlaceholder=function(){var e;return("left"===this.name||"right"===this.name&&!this.hasHScrollbar&&!this.grid.disableScrolling)&&(this.grid.options.enableHorizontalScrollbar===i.scrollbars.ALWAYS||(e=this.grid.element[0].querySelector(".ui-grid-render-container-body .ui-grid-viewport")).scrollWidth>e.offsetWidth)},e.prototype.getViewportStyle=function(){var e=this,t={},r={};return r[i.scrollbars.ALWAYS]="scroll",r[i.scrollbars.WHEN_NEEDED]="auto",e.hasHScrollbar=!1,e.hasVScrollbar=!1,e.grid.disableScrolling?(t["overflow-x"]="hidden",t["overflow-y"]="hidden"):("body"===e.name?(e.hasHScrollbar=e.grid.options.enableHorizontalScrollbar!==i.scrollbars.NEVER,e.grid.isRTL()?e.grid.hasLeftContainerColumns()||(e.hasVScrollbar=e.grid.options.enableVerticalScrollbar!==i.scrollbars.NEVER):e.grid.hasRightContainerColumns()||(e.hasVScrollbar=e.grid.options.enableVerticalScrollbar!==i.scrollbars.NEVER)):"left"===e.name?e.hasVScrollbar=!!e.grid.isRTL()&&e.grid.options.enableVerticalScrollbar!==i.scrollbars.NEVER:e.hasVScrollbar=!e.grid.isRTL()&&e.grid.options.enableVerticalScrollbar!==i.scrollbars.NEVER,t["overflow-x"]=e.hasHScrollbar?r[e.grid.options.enableHorizontalScrollbar]:"hidden",t["overflow-y"]=e.hasVScrollbar?r[e.grid.options.enableVerticalScrollbar]:"hidden"),t},e}]),angular.module("ui.grid").factory("GridRow",["gridUtil","uiGridConstants",function(i,t){function e(e,t,r){this.grid=r,this.entity=e,this.index=t,this.uid=i.nextUid(),this.visible=!0,this.isSelected=!1,this.$$height=r.options.rowHeight}return Object.defineProperty(e.prototype,"height",{get:function(){return this.$$height},set:function(e){e!==this.$$height&&(this.grid.updateCanvasHeight(),this.$$height=e)}}),e.prototype.getQualifiedColField=function(e){return"row."+this.getEntityQualifiedColField(e)},e.prototype.getEntityQualifiedColField=function(e){return e.field===t.ENTITY_BINDING?"entity":i.preEval("entity."+e.field)},e.prototype.setRowInvisible=function(e){e&&e.setThisRowInvisible&&e.setThisRowInvisible("user")},e.prototype.clearRowInvisible=function(e){e&&e.clearThisRowInvisible&&e.clearThisRowInvisible("user")},e.prototype.setThisRowInvisible=function(e,t){this.invisibleReason||(this.invisibleReason={}),this.invisibleReason[e]=!0,this.evaluateRowVisibility(t)},e.prototype.clearThisRowInvisible=function(e,t){void 0!==this.invisibleReason&&delete this.invisibleReason[e],this.evaluateRowVisibility(t)},e.prototype.evaluateRowVisibility=function(e){var r=!0;void 0!==this.invisibleReason&&angular.forEach(this.invisibleReason,function(e,t){e&&(r=!1)}),void 0!==this.visible&&this.visible===r||(this.visible=r,e)||(this.grid.queueGridRefresh(),this.grid.api.core.raise.rowsVisibleChanged(this))},e}]),function(){"use strict";angular.module("ui.grid").factory("GridRowColumn",["$parse","$filter",function(e,t){function r(e,t){if(!(this instanceof r))throw"Using GridRowColumn as a function insead of as a constructor. Must be called with `new` keyword";this.row=e,this.col=t}return r.prototype.getIntersectionValueRaw=function(){return e(this.row.getEntityQualifiedColField(this.col))(this.row)},r}])}(),angular.module("ui.grid").factory("ScrollEvent",["gridUtil",function(o){function e(e,t,r,i){var n=this;if(!e)throw new Error("grid argument is required");n.grid=e,n.source=i,n.withDelay=!0,n.sourceRowContainer=t,n.sourceColContainer=r,n.newScrollLeft=null,n.newScrollTop=null,n.x=null,n.y=null,n.verticalScrollLength=-9999999,n.horizontalScrollLength=-999999,n.type="scroll",n.fireThrottledScrollingEvent=o.throttle(function(e){n.grid.scrollContainers(e,n)},n.grid.options.wheelScrollThrottle,{trailing:!0})}return e.prototype.getNewScrollLeft=function(e,t){var r=this;if(r.newScrollLeft)return r.newScrollLeft;var i,e=e.getCanvasWidth()-e.getViewportWidth(),t=o.normalizeScrollLeft(t,r.grid);if(void 0!==r.x.percentage&&void 0!==r.x.percentage)i=r.x.percentage;else{if(void 0===r.x.pixels||void 0===r.x.pixels)throw new Error("No percentage or pixel value provided for scroll event X axis");i=r.x.percentage=(t+r.x.pixels)/e}return Math.max(0,i*e)},e.prototype.getNewScrollTop=function(e,t){var r=this;if(r.newScrollTop)return r.newScrollTop;var i,e=e.getVerticalScrollLength(),t=t[0].scrollTop;if(void 0!==r.y.percentage&&void 0!==r.y.percentage)i=r.y.percentage;else{if(void 0===r.y.pixels||void 0===r.y.pixels)throw new Error("No percentage or pixel value provided for scroll event Y axis");i=r.y.percentage=(t+r.y.pixels)/e}return Math.max(0,i*e)},e.prototype.atTop=function(e){return this.y&&(0===this.y.percentage||this.verticalScrollLength<0)&&0===e},e.prototype.atBottom=function(e){return this.y&&(1===this.y.percentage||0===this.verticalScrollLength)&&0<e},e.prototype.atLeft=function(e){return this.x&&(0===this.x.percentage||this.horizontalScrollLength<0)&&0===e},e.prototype.atRight=function(e){return this.x&&(1===this.x.percentage||0===this.horizontalScrollLength)&&0<e},e.Sources={ViewPortScroll:"ViewPortScroll",RenderContainerMouseWheel:"RenderContainerMouseWheel",RenderContainerTouchMove:"RenderContainerTouchMove",Other:99},e}]),function(){"use strict";angular.module("ui.grid").service("gridClassFactory",["gridUtil","$q","$compile","$templateCache","uiGridConstants","Grid","GridColumn","GridRow",function(s,i,n,e,c,o,t,r){var l={createGrid:function(e){(e=void 0!==e?e:{}).id=s.newId();var t,r=new o(e);return r.options.rowTemplate&&(t=i.defer(),r.getRowTemplateFn=t.promise,s.getTemplate(r.options.rowTemplate).then(function(e){e=n(e);t.resolve(e)},function(){throw new Error("Couldn't fetch/use row template '"+r.options.rowTemplate+"'")}).catch(angular.noop)),r.registerColumnBuilder(l.defaultColumnBuilder),r.registerRowBuilder(l.rowTemplateAssigner),r.registerRowsProcessor(function(e){return e.forEach(function(e){e.evaluateRowVisibility(!0)}),e},50),r.registerColumnsProcessor(function(e){return e.forEach(function(e){e.visible=!angular.isDefined(e.colDef.visible)||e.colDef.visible}),e},50),r.registerRowsProcessor(r.searchRows,100),r.options.externalSort&&angular.isFunction(r.options.externalSort)?r.registerRowsProcessor(r.options.externalSort,200):r.registerRowsProcessor(r.sortByColumn,200),r},defaultColumnBuilder:function(o,l,e){function t(r,e,t,i,n){return o[r]?l[e]=o[r]:l[e]=t,t=s.getTemplate(l[e]).then(function(e){angular.isFunction(e)&&(e=e());var t="cellTooltip"===n?"col.cellTooltip(row,col)":"col.headerTooltip(col)";return n&&!1===l[n]?e=e.replace(c.TOOLTIP,""):n&&l[n]&&(e=e.replace(c.TOOLTIP,'title="{{'+t+' CUSTOM_FILTERS }}"')),i&&(e=e.replace(c.CUSTOM_FILTERS,function(){return l[i]?"|"+l[i]:""})),s.postProcessTemplate(e).then(function(e){l[r]=e})},function(){throw new Error("Couldn't fetch/use colDef."+r+" '"+o[r]+"'")}).catch(angular.noop),a.push(t),t}var a=[];return l.cellTemplatePromise=t("cellTemplate","providedCellTemplate","ui-grid/uiGridCell","cellFilter","cellTooltip"),l.headerCellTemplatePromise=t("headerCellTemplate","providedHeaderCellTemplate","ui-grid/uiGridHeaderCell","headerCellFilter","headerTooltip"),l.footerCellTemplatePromise=t("footerCellTemplate","providedFooterCellTemplate","ui-grid/uiGridFooterCell","footerCellFilter"),l.filterHeaderTemplatePromise=t("filterHeaderTemplate","providedFilterHeaderTemplate","ui-grid/ui-grid-filter"),l.compiledElementFnDefer=i.defer(),i.all(a)},rowTemplateAssigner:function(e){var t;return e.rowTemplate?(t=i.defer(),e.getRowTemplateFn=t.promise,s.getTemplate(e.rowTemplate).then(function(e){e=n(e);t.resolve(e)},function(){throw new Error("Couldn't fetch/use row template '"+e.rowTemplate+"'")})):(e.rowTemplate=this.options.rowTemplate,e.getRowTemplateFn=this.getRowTemplateFn),e.getRowTemplateFn}};return l}])}(),function(){function i(e){return e.replace(/[|\\{}()[\]^$+?*.]/g,"\\$&").replace(/-/g,"\\x2d")}angular.module("ui.grid").service("rowSearcher",["gridUtil","uiGridConstants",function(s,a){var r=a.filter.CONTAINS,c={getTerm:function(e){return void 0===e.term?e.term:"string"==typeof(e=e.term)?e.trim():e},stripTerm:function(e){e=c.getTerm(e);return"string"==typeof e?i(e.replace(/(^\*|\*$)/g,"")):e},guessCondition:function(e){var t;return void 0!==e.term&&e.term&&(t=c.getTerm(e),/\*/.test(t))?(e=e.flags&&e.flags.caseSensitive?"":"i",t=(t=i(t)).replace(/\\\*/g,".*?"),new RegExp("^"+t+"$",e)):r},setupFilters:function(e){for(var t=[],r=0;r<e.length;r++){var i=e[r];if(i.noTerm||!s.isNullOrUndefined(i.term)){var n={},o="";switch(i.flags&&i.flags.caseSensitive||(o+="i"),s.isNullOrUndefined(i.term)||(i.rawTerm?n.term=i.term:n.term=c.stripTerm(i)),n.noTerm=i.noTerm,n.condition=i.condition||c.guessCondition(i),n.flags=angular.extend({caseSensitive:!1,date:!1},i.flags),n.condition){case a.filter.STARTS_WITH:n.startswithRE=new RegExp("^"+n.term,o);break;case a.filter.ENDS_WITH:n.endswithRE=new RegExp(n.term+"$",o);break;case a.filter.EXACT:n.exactRE=new RegExp("^"+n.term+"$",o);break;case a.filter.CONTAINS:n.containsRE=new RegExp(n.term,o)}t.push(n)}}return t},runColumnFilter:function(e,t,r,i){var n=typeof i.condition,o=i.term,l=r.filterCellFiltered?e.getCellDisplayValue(t,r):e.getCellValue(t,r);if(null==l&&(l=""),i.condition instanceof RegExp)return i.condition.test(l);if("function"==n)return i.condition(o,l,t,r);if(i.startswithRE)return i.startswithRE.test(l);if(i.endswithRE)return i.endswithRE.test(l);if(i.containsRE)return i.containsRE.test(l);if(i.exactRE)return i.exactRE.test(l);if(i.condition===a.filter.NOT_EQUAL)return!new RegExp("^"+o+"$").test(l);switch("number"==typeof l&&"string"==typeof o&&(e=parseFloat(o.replace(/\\\./,".").replace(/\\\-/,"-")),isNaN(e)||(o=e)),!0===i.flags.date&&(l=new Date(l),o=new Date(o.replace(/\\/g,""))),i.condition){case a.filter.GREATER_THAN:return o<l;case a.filter.GREATER_THAN_OR_EQUAL:return o<=l;case a.filter.LESS_THAN:return l<o;case a.filter.LESS_THAN_OR_EQUAL:return l<=o}return!0},searchColumn:function(e,t,r,i){if(!e.options.useExternalFiltering)for(var n=0;n<i.length;n++){var o=i[n];if((!s.isNullOrUndefined(o.term)&&""!==o.term||o.noTerm)&&!c.runColumnFilter(e,t,r,o))return!1}return!0}};return c.search=function(e,a,t){if(a){if(e.options.enableFiltering){for(var r=[],i=0;i<t.length;i++){var n=t[i];void 0!==n.filters&&function(e){var t=!1;return e.forEach(function(e){(!s.isNullOrUndefined(e.term)&&""!==e.term||e.noTerm)&&(t=!0)}),t}(n.filters)&&r.push({col:n,filters:c.setupFilters(n.filters)})}if(0<r.length){function o(e,t){for(var r,i,n,o,l=0;l<a.length;l++)r=e,i=a[l],n=t.col,o=t.filters,i.visible&&!c.searchColumn(r,i,n,o)&&(i.visible=!1)}for(var l=0;l<r.length;l++)o(e,r[l]);e.api.core.raise.rowsVisibleChanged&&e.api.core.raise.rowsVisibleChanged()}}return a}},c}])}(),angular.module("ui.grid").service("rowSorter",["uiGridConstants",function(u){var d={colSortFnCache:{}};function n(e){return/^\s*-?Infinity\s*$/.test(e)?parseFloat(e):parseFloat(e.replace(/[^0-9.eE-]/g,""))}return d.guessSortFn=function(e){switch(e){case"number":return d.sortNumber;case"numberStr":return d.sortNumberStr;case"boolean":return d.sortBool;case"string":return d.sortAlpha;case"date":return d.sortDate;case"object":return d.basicSort;default:throw new Error("No sorting function found for type: "+e)}},d.handleNulls=function(e,t){return null==e||null==t?null==e&&null==t?0:null==e?1:-1:null},d.basicSort=function(e,t){var r=d.handleNulls(e,t);return null!==r?r:e===t?0:e<t?-1:1},d.sortNumber=function(e,t){var r=d.handleNulls(e,t);return null!==r?r:e-t},d.sortNumberStr=function(e,t){var r,i=d.handleNulls(e,t);return null!==i?i:(i=n(e),e=n(t),t=isNaN(i),r=isNaN(e),t||r?t&&r?0:t?1:-1:i-e)},d.sortAlpha=function(e,t){var r=d.handleNulls(e,t);return null!==r?r:(r=e.toString().toLowerCase())===(e=t.toString().toLowerCase())?0:r.localeCompare(e)},d.sortDate=function(e,t){var r=d.handleNulls(e,t);return null!==r?r:(r=(e instanceof Date?e:new Date(e)).getTime())===(e=(t instanceof Date?t:new Date(t)).getTime())?0:r<e?-1:1},d.sortBool=function(e,t){var r=d.handleNulls(e,t);return null!==r?r:e&&t||!e&&!t?0:e?1:-1},d.getSortFn=function(e){var t;return d.colSortFnCache[e.colDef.name]||(null!=e.sortingAlgorithm?(d.colSortFnCache[e.colDef.name]=e.sortingAlgorithm,e.sortingAlgorithm):e.sortCellFiltered&&e.cellFilter?(d.colSortFnCache[e.colDef.name]=d.sortAlpha,d.sortAlpha):(t=d.guessSortFn(e.colDef.type))?d.colSortFnCache[e.colDef.name]=t:d.sortAlpha)},d.prioritySort=function(e,t){return e.sort&&void 0!==e.sort.priority&&t.sort&&void 0!==t.sort.priority?e.sort.priority<t.sort.priority?-1:e.sort.priority===t.sort.priority?0:1:e.sort&&void 0!==e.sort.priority?-1:t.sort&&void 0!==t.sort.priority?1:0},d.sort=function(l,e,t){if(e){if(l.options.useExternalSorting)return e;var a,s,c=[],r=[];if(t.forEach(function(e){!e.sort||e.sort.ignoreSort||!e.sort.direction||e.sort.direction!==u.ASC&&e.sort.direction!==u.DESC?e.defaultSort&&e.defaultSort.direction&&(e.defaultSort.direction===u.ASC||e.defaultSort.direction===u.DESC)&&r.push({col:e,sort:e.defaultSort}):c.push({col:e,sort:e.sort})}),c=c.sort(d.prioritySort),r=r.sort(d.prioritySort),0===(c=c.concat(r)).length)return e;e.forEach(function(e,t){e.entity.$$uiGridIndex=t});t=e.sort(function(e,t){for(var r=0,i=0;0===r&&i<c.length;){a=c[i].col,s=c[i].sort.direction;var n=d.getSortFn(a),o=function(e,t,r,i){var n;t=i.sortCellFiltered?(n=e.getCellDisplayValue(t,i),e.getCellDisplayValue(r,i)):(n=e.getCellValue(t,i),e.getCellValue(r,i));return[n,t]}(l,e,t,a),r=n(o[0],o[1],e,t,s,a);i++}return 0===r?e.entity.$$uiGridIndex-t.entity.$$uiGridIndex:s===u.ASC?r:0-r});return e.forEach(function(e,t){delete e.entity.$$uiGridIndex}),t}},d}]),function(){var C,e=angular.module("ui.grid");function w(e){var t=e;return(t=void 0!==t.length&&t.length?e[0]:t).ownerDocument.defaultView.getComputedStyle(t,null)}"function"!=typeof Function.prototype.bind&&(C=function(){var i=Array.prototype.slice;return function(e){var t=this,r=i.call(arguments,1);return r.length?function(){return arguments.length?t.apply(e,r.concat(i.call(arguments))):t.apply(e,r)}:function(){return arguments.length?t.apply(e,arguments):t.call(e)}}});var a=new RegExp("^("+/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source+")(?!px)[a-z%]+$","i"),y=/^(block|none|table(?!-c[ea]).+)/,b={position:"absolute",visibility:"hidden",display:"block"};function S(e,t,r,i,n){for(var o=r===(i?"border":"content")?4:"width"===t?1:0,l=0,a=["Top","Right","Bottom","Left"];o<4;o+=2){var s,c,u=a[o];"margin"===r&&(s=parseFloat(n[r+u]),isNaN(s)||(l+=s)),i?("content"===r&&(s=parseFloat(n["padding"+u]),isNaN(s)||(l-=s)),"margin"!==r&&(c=parseFloat(n["border"+u+"Width"]),isNaN(c)||(l-=c))):(c=parseFloat(n["padding"+u]),isNaN(c)||(l+=c),"padding"!==r&&(u=parseFloat(n["border"+u+"Width"]),isNaN(u)||(l+=u)))}return l}function E(e,t,r){var i,n=!0,o=w(e),l="border-box"===o.boxSizing;if(i<=0||null==i){if(((i=o[t])<0||null==i)&&(i=e.style[t]),a.test(i))return i;n=l&&!0,i=parseFloat(i)||0}return i+S(0,t,r||(l?"border":"content"),n,o)}var T=["0","0","0","0"],R="uiGrid-";e.service("gridUtil",["$log","$window","$document","$http","$templateCache","$timeout","$interval","$injector","$q","$interpolate","uiGridConstants",function(t,n,r,e,i,s,c,o,l,a,u){var d,g,h,p={augmentWidthOrHeight:S,getStyles:w,createBoundedWrapper:function(e,t){return function(){return t.apply(e,arguments)}},readableColumnName:function(e){return null==e?e:(e="string"!=typeof e?String(e):e).replace(/_+/g," ").replace(/^[A-Z]+$/,function(e){return e.toLowerCase()}).replace(/([\w\u00C0-\u017F]+)/g,function(e){return e.charAt(0).toUpperCase()+e.slice(1)}).replace(/(\w+?(?=[A-Z]))/g,"$1 ")},getColumnsFromData:function(e,r){var i=[];if(!e||void 0===e[0]||void 0===e[0])return[];angular.isUndefined(r)&&(r=[]);e=e[0];return angular.forEach(e,function(e,t){-1===r.indexOf(t)&&i.push({name:t})}),i},newId:(d=(new Date).getTime(),function(){return d+=1}),getTemplate:function(t){if(i.get(t))return p.postProcessTemplate(i.get(t));if(angular.isFunction(t.then))return t.then(p.postProcessTemplate).catch(angular.noop);try{if(0<angular.element(t).length)return l.when(t).then(p.postProcessTemplate).catch(angular.noop)}catch(e){}return e({method:"GET",url:t}).then(function(e){e=e.data.trim();return i.put(t,e),e},function(e){throw new Error("Could not get template "+t+": "+e)}).then(p.postProcessTemplate).catch(angular.noop)},postProcessTemplate:function(e){var t=a.startSymbol(),r=a.endSymbol();return"{{"===t&&"}}"===r||(e=(e=e.replace(/\{\{/g,t)).replace(/\}\}/g,r)),l.when(e)},guessType:function(e){var t=typeof e;switch(t){case"number":case"boolean":case"string":return t;default:return angular.isDate(e)?"date":"object"}},elementWidth:function(e){},elementHeight:function(e){},isVisible:function(e){return!!(e[0].offsetWidth||e[0].offsetHeight||e[0].getClientRects().length)},getScrollbarWidth:function(){var e=document.createElement("div"),t=(e.style.visibility="hidden",e.style.width="100px",e.style.msOverflowStyle="scrollbar",document.body.appendChild(e),e.offsetWidth),r=(e.style.overflow="scroll",e.style.position="absolute",document.createElement("div")),r=(r.style.width="100%",e.appendChild(r),r.offsetWidth);return e.parentNode.removeChild(e),t-r},swap:function(e,t,r,i){var n,o={};for(n in t)o[n]=e.style[n],e.style[n]=t[n];for(n in r=r.apply(e,i||[]),t)e.style[n]=o[n];return r},fakeElement:function(e,t,r,i){var n,o=angular.element(e).clone()[0];for(n in t)o.style[n]=t[n];return angular.element(document.body).append(o),e=r.call(o,o),angular.element(o).remove(),e},normalizeWheelEvent:function(e){var t,r,i=e||window.event,n=([].slice.call(arguments,1),0),o=0,l=0;return(i=i.originalEvent?i.originalEvent:i).wheelDelta&&(n=i.wheelDelta),l=n=i.detail?-1*i.detail:n,void 0!==i.axis&&i.axis===i.HORIZONTAL_AXIS&&(l=0,o=-1*n),i.deltaY&&(n=l=-1*i.deltaY),i.deltaX&&(n=-1*(o=i.deltaX)),void 0!==i.wheelDeltaY&&(l=i.wheelDeltaY),void 0!==i.wheelDeltaX&&(o=i.wheelDeltaX),i=Math.abs(n),(!t||i<t)&&(t=i),i=Math.max(Math.abs(l),Math.abs(o)),(!r||i<r)&&(r=i),i=0<n?"floor":"ceil",{delta:n=Math[i](n/t),deltaX:o=Math[i](o/r),deltaY:l=Math[i](l/r)}},isTouchEnabled:function(){var e;return e="ontouchstart"in n||n.DocumentTouch&&r instanceof DocumentTouch?!0:e},isNullOrUndefined:function(e){return null==e},endsWith:function(e,t){return!(!e||!t||"string"!=typeof e)&&-1!==e.indexOf(t,e.length-t.length)},arrayContainsObjectWithProperty:function(e,t,r){var i=!1;return angular.forEach(e,function(e){e[t]===r&&(i=!0)}),i},numericAndNullSort:function(e,t){return null===e?1:null===t?-1:null===e&&null===t?0:e-t},disableAnimations:function(e){var t;try{t=o.get("$animate"),1<angular.version.major||1===angular.version.major&&4<=angular.version.minor?t.enabled(e,!1):t.enabled(!1,e)}catch(e){}},enableAnimations:function(e){var t;try{return t=o.get("$animate"),1<angular.version.major||1===angular.version.major&&4<=angular.version.minor?t.enabled(e,!0):t.enabled(!0,e),t}catch(e){}},nextUid:function(){for(var e,t=T.length;t;){if(57===(e=T[--t].charCodeAt(0)))return T[t]="A",R+T.join("");if(90!==e)return T[t]=String.fromCharCode(e+1),R+T.join("");T[t]="0"}return T.unshift("0"),R+T.join("")},hashKey:function(e){var t,r=typeof e;return"object"==r&&null!==e?"function"==typeof(t=e.$$hashKey)?t=e.$$hashKey():void 0!==e.$$hashKey&&e.$$hashKey?t=e.$$hashKey:void 0===t&&(t=e.$$hashKey=p.nextUid()):t=e,r+": "+t},resetUids:function(){T=["0","0","0"]},logError:function(e){u.LOG_ERROR_MESSAGES&&t.error(e)},logWarn:function(e){u.LOG_WARN_MESSAGES&&t.warn(e)},logDebug:function(){u.LOG_DEBUG_MESSAGES&&t.debug.apply(t,arguments)}},f=(p.focus={queue:[],byId:function(r,i){this._purgeQueue();var e=s(function(){var e=(i&&i.id?i.id+"-":"")+r,t=n.document.getElementById(e);t?t.focus():p.logWarn("[focus.byId] Element id "+e+" was not found.")},0,!1);return this.queue.push(e),e},byElement:function(e){if(!angular.isElement(e))return p.logWarn("Trying to focus on an element that isn't an element."),l.reject("not-element");e=angular.element(e),this._purgeQueue();var t=s(function(){e&&e[0].focus()},0,!1);return this.queue.push(t),t},bySelector:function(t,r,e){var i=this;if(!angular.isElement(t))throw new Error("The parent element is not an element.");t=angular.element(t);function n(){var e=t[0].querySelector(r);return i.byElement(e)}return this._purgeQueue(),e?(e=s(n,0,!1),this.queue.push(e),e):n()},_purgeQueue:function(){this.queue.forEach(function(e){s.cancel(e)}),this.queue=[]}},["width","height"].forEach(function(i){var r=i.charAt(0).toUpperCase()+i.substr(1);p["element"+r]=function(e,t){var r=e;return(r=r&&void 0!==r.length&&r.length?e[0]:r)&&null!==r?(e=w(r),0===r.offsetWidth&&y.test(e.display)?p.swap(r,b,function(){return E(r,i,t)}):E(r,i,t)):null},p["outerElement"+r]=function(e,t){return e?p["element"+r].call(this,e,t?"margin":"border"):null}}),p.closestElm=function(e,t){var r,i;for(void 0!==e.length&&e.length&&(e=e[0]),["matches","webkitMatchesSelector","mozMatchesSelector","msMatchesSelector","oMatchesSelector"].some(function(e){return"function"==typeof document.body[e]&&(r=e,!0)});null!==e;){if(null!==(i=e.parentElement)&&i[r](t))return i;e=i}return null},p.type=function(e){return Function.prototype.toString.call(e.constructor).match(/function (.*?)\(/)[1]},p.getBorderSize=function(e,t){e=w(e=void 0!==e.length&&e.length?e[0]:e),t=t?"border"+t.charAt(0).toUpperCase()+t.slice(1):"border",t+="Width",e=parseInt(e[t],10);return isNaN(e)?0:e},p.detectBrowser=function(){var e,t=n.navigator.userAgent,r={chrome:/chrome/i,safari:/safari/i,firefox:/firefox/i,ie:/internet explorer|trident\//i};for(e in r)if(r[e].test(t))return e;return"unknown"},p.rtlScrollType=function e(){var t,r;return e.type||(t=angular.element('<div dir="rtl" style="width: 1px; height: 1px; position: fixed; top: 0px; left: 0px; overflow: hidden"><div style="width: 2px"><span style="display: inline-block; width: 1px"></span><span style="display: inline-block; width: 1px"></span></div></div>')[0],r="reverse",document.body.appendChild(t),0<t.scrollLeft?r="default":"undefined"!=typeof Element&&Element.prototype.scrollIntoView?(t.children[0].children[1].scrollIntoView(),t.scrollLeft<0&&(r="negative")):(t.scrollLeft=1,0===t.scrollLeft&&(r="negative")),angular.element(t).remove(),e.type=r)},p.normalizeScrollLeft=function(e,t){var r=(e=void 0!==e.length&&e.length?e[0]:e).scrollLeft;if(t.isRTL())switch(p.rtlScrollType()){case"default":return e.scrollWidth-r-e.clientWidth;case"negative":return Math.abs(r);case"reverse":return r}return r},p.denormalizeScrollLeft=function(e,t,r){if(void 0!==e.length&&e.length&&(e=e[0]),r.isRTL())switch(p.rtlScrollType()){case"default":return e.scrollWidth-e.clientWidth-t;case"negative":return-1*t;case"reverse":return t}return t},p.preEval=function(e){var t,r=u.BRACKET_REGEXP.exec(e);return r?(r[1]&&p.preEval(r[1]))+r[2]+(r[3]&&p.preEval(r[3])):(r=(e=e.replace(u.APOS_REGEXP,"\\'")).split(u.DOT_REGEXP),t=[r.shift()],angular.forEach(r,function(e){t.push(e.replace(u.FUNC_REGEXP,"']$1"))}),t.join("['"))},p.debounce=function(t,r,i){var n,o,l,a;function e(){l=this,o=arguments;var e=i&&!n;return n&&s.cancel(n),n=s(function(){n=null,i||(a=t.apply(l,o))},r,!1),a=e?t.apply(l,o):a}return e.cancel=function(){s.cancel(n),n=null},e},p.throttle=function(t,r,i){i=i||{};var n,o,l=0,a=null;function s(e){l=+new Date,t.apply(n,o),c(function(){a=null},0,1,!1)}return function(){var e;n=this,o=arguments,null===a&&(e=+new Date-l,r<e?s():i.trailing&&(a=c(s,r-e,1,!1)))}},p.on={},p.off={},p._events={},p.addOff=function(r){p.off[r]=function(e,t){t=p._events[r].indexOf(t);0<t&&p._events[r].removeAt(t)}},"onwheel"in document||9<=document.documentMode?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"]);function m(e,t){var r,i=angular.element(this),n=0,o=0,l=0;"detail"in(t=t.originalEvent?t.originalEvent:t)&&(l=-1*t.detail),"wheelDelta"in t&&(l=t.wheelDelta),"wheelDeltaY"in t&&(l=t.wheelDeltaY),"wheelDeltaX"in t&&(o=-1*t.wheelDeltaX),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(o=-1*l,l=0),n=0===l?o:l,"deltaY"in t&&(n=l=-1*t.deltaY),"deltaX"in t&&(o=t.deltaX,0===l)&&(n=-1*o),0===l&&0===o||(1===t.deltaMode?(n*=r=i.data("mousewheel-line-height"),l*=r,o*=r):2===t.deltaMode&&(n*=r=i.data("mousewheel-page-height"),l*=r,o*=r),r=Math.max(Math.abs(l),Math.abs(o)),(!h||r<h)&&(r=h=r,"mousewheel"===t.type)&&r%120==0&&(h/=40),n=Math[1<=n?"floor":"ceil"](n/h),o=Math[1<=o?"floor":"ceil"](o/h),l=Math[1<=l?"floor":"ceil"](l/h),n={originalEvent:t,deltaX:o,deltaY:l,deltaFactor:h,preventDefault:function(){t.preventDefault()},stopPropagation:function(){t.stopPropagation()}},g&&clearTimeout(g),g=setTimeout(v,200),e.call(i[0],n))}function v(){h=null}return p.on.mousewheel=function(e,t){if(e&&t){var r,i=angular.element(e),n=(i.data("mousewheel-line-height",(e=i,r=(r=(e=angular.element(e)[0]).parentElement)||document.getElementsByTagName("body")[0],parseInt(w(r).fontSize)||parseInt(w(e).fontSize)||16)),i.data("mousewheel-page-height",p.elementHeight(i)),i.data("mousewheel-callbacks")||i.data("mousewheel-callbacks",{}),i.data("mousewheel-callbacks"));n[t]=(Function.prototype.bind||C).call(m,i[0],t);for(var o=f.length;o;)i.on(f[--o],n[t]);i.on("$destroy",function(){for(var e=f.length;e;)i.off(f[--e],n[t])})}},p.off.mousewheel=function(e,t){var r=angular.element(e),e=r.data("mousewheel-callbacks"),i=e[t];if(i)for(var n=f.length;n;)r.off(f[--n],i);delete e[t],0===Object.keys(e).length&&(r.removeData("mousewheel-line-height"),r.removeData("mousewheel-page-height"),r.removeData("mousewheel-callbacks"))},p}]),e.filter("px",function(){return function(e){return e.match(/^[\d\.]+$/)?e+"px":e}})}(),function(){var d=["uiT","uiTranslate"],t=angular.module("ui.grid.i18n");function r(c,u){return{restrict:"EA",compile:function(){return{pre:function(e,t,r){var i,n,o=d[0],l=d[1],a=r[o]||r[l]||t.html();function s(e){e=c.getSafeText(e);t.html(e)}r.$$observers&&(n=r[o]?o:l,i=r.$observe(n,function(e){e&&s(e)})),n=e.$on(u.UPDATE_EVENT,function(){i?i(r[o]||r[l]):s(a)}),e.$on("$destroy",n),s(a)}}}}}function i(r){return function(e,t){return r.getSafeText(e,t)}}t.constant("i18nConstants",{MISSING:"[MISSING]",UPDATE_EVENT:"$uiI18n",LOCALE_DIRECTIVE_ALIAS:"uiI18n",DEFAULT_LANG:"en"}),t.service("i18nService",["$log","$parse","i18nConstants","$rootScope",function(t,i,r,n){var o={_langs:{},current:null,fallback:r.DEFAULT_LANG,get:function(e){var t=this,r=t.getFallbackLang();return e!==t.fallback?angular.extend({},t._langs[r],t._langs[e.toLowerCase()]):t._langs[e.toLowerCase()]},add:function(e,t){e=e.toLowerCase();this._langs[e]||(this._langs[e]={}),angular.merge(this._langs[e],t)},getAllLangs:function(){var e=[];if(this._langs)for(var t in this._langs)e.push(t);return e},setCurrent:function(e){this.current=e.toLowerCase()},setFallback:function(e){this.fallback=e.toLowerCase()},getCurrentLang:function(){return this.current},getFallbackLang:function(){return this.fallback.toLowerCase()}};function l(e){return t.warn(r.MISSING+e),""}var a={add:function(e,t){"object"==typeof e?angular.forEach(e,function(e){e&&o.add(e,t)}):o.add(e,t)},getAllLangs:function(){return o.getAllLangs()},get:function(e){e=e||a.getCurrentLang();return o.get(e)},getSafeText:function(e,t){var t=t||a.getCurrentLang(),t=o.get(t),r=i(e);return t&&r(t)||l(e)},setCurrentLang:function(e){e&&(o.setCurrent(e),n.$broadcast(r.UPDATE_EVENT))},setFallbackLang:function(e){e&&o.setFallback(e)},getCurrentLang:function(){var e=o.getCurrentLang();return e||(e=r.DEFAULT_LANG,o.setCurrent(e)),e},getFallbackLang:function(){return o.getFallbackLang()}};return a}]),t.directive("uiI18n",["i18nService","i18nConstants",function(o,l){return{compile:function(){return{pre:function(e,t,r){var i=l.LOCALE_DIRECTIVE_ALIAS,n=e.$eval(r[i]);n?e.$watch(r[i],function(){o.setCurrentLang(n)}):r.$$observers&&r.$observe(i,function(){o.setCurrentLang(r[i]||l.DEFAULT_LANG)})}}}}}]),angular.forEach(d,function(e){t.directive(e,["i18nService","i18nConstants",r])}),angular.forEach(["t","uiTranslate"],function(e){t.filter(e,["i18nService",i])})}(),angular.module("ui.grid").run(["$templateCache",function(e){"use strict";e.put("ui-grid/ui-grid-filter",'<div class="ui-grid-filter-container" ng-style="col.extraStyle" ng-repeat="colFilter in col.filters" ng-class="{\'ui-grid-filter-cancel-button-hidden\' : colFilter.disableCancelFilterButton === true }"><div ng-if="colFilter.type !== \'select\'"><input type="text" class="ui-grid-filter-input ui-grid-filter-input-{{$index}}" ng-model="colFilter.term" ng-attr-placeholder="{{colFilter.placeholder || \'\'}}" aria-label="{{colFilter.ariaLabel || aria.defaultFilterLabel}}"><div role="button" class="ui-grid-filter-button" ng-click="removeFilter(colFilter, $index)" ng-if="!colFilter.disableCancelFilterButton" ng-disabled="colFilter.term === undefined || colFilter.term === null || colFilter.term === \'\'" ng-show="colFilter.term !== undefined && colFilter.term !== null && colFilter.term !== \'\'"><i class="ui-grid-icon-cancel" ui-grid-one-bind-aria-label="aria.removeFilter">&nbsp;</i></div></div><div ng-if="colFilter.type === \'select\'"><select class="ui-grid-filter-select ui-grid-filter-input-{{$index}}" ng-model="colFilter.term" ng-show="colFilter.selectOptions.length > 0" ng-attr-placeholder="{{colFilter.placeholder || aria.defaultFilterLabel}}" aria-label="{{colFilter.ariaLabel || \'\'}}" ng-options="option.value as option.label for option in colFilter.selectOptions"><option value=""></option></select><div role="button" class="ui-grid-filter-button-select" ng-click="removeFilter(colFilter, $index)" ng-if="!colFilter.disableCancelFilterButton" ng-disabled="colFilter.term === undefined || colFilter.term === null || colFilter.term === \'\'" ng-show="colFilter.term !== undefined && colFilter.term != null"><i class="ui-grid-icon-cancel" ui-grid-one-bind-aria-label="aria.removeFilter">&nbsp;</i></div></div></div>'),e.put("ui-grid/ui-grid-footer",'<div class="ui-grid-footer-panel ui-grid-footer-aggregates-row">\x3c!-- tfooter --\x3e<div class="ui-grid-footer ui-grid-footer-viewport"><div class="ui-grid-footer-canvas"><div class="ui-grid-footer-cell-wrapper" ng-style="colContainer.headerCellWrapperStyle()"><div role="row" class="ui-grid-footer-cell-row"><div ui-grid-footer-cell role="gridcell" ng-repeat="col in colContainer.renderedColumns track by col.uid" col="col" render-index="$index" class="ui-grid-footer-cell ui-grid-clearfix"></div></div></div></div></div></div>'),e.put("ui-grid/ui-grid-grid-footer",'<div class="ui-grid-footer-info ui-grid-grid-footer"><span>{{\'search.totalItems\' | t}} {{grid.rows.length}}</span> <span ng-if="grid.renderContainers.body.visibleRowCache.length !== grid.rows.length" class="ngLabel">({{"search.showingItems" | t}} {{grid.renderContainers.body.visibleRowCache.length}})</span></div>'),e.put("ui-grid/ui-grid-header",'<div role="rowgroup" class="ui-grid-header">\x3c!-- theader --\x3e<div class="ui-grid-top-panel"><div class="ui-grid-header-viewport"><div class="ui-grid-header-canvas"><div class="ui-grid-header-cell-wrapper" ng-style="colContainer.headerCellWrapperStyle()"><div role="row" class="ui-grid-header-cell-row"><div role="columnheader" class="ui-grid-header-cell ui-grid-clearfix" ng-repeat="col in colContainer.renderedColumns track by col.uid" ui-grid-header-cell col="col" render-index="$index"></div></div></div></div></div></div></div>'),e.put("ui-grid/ui-grid-menu-button",'<div class="ui-grid-menu-button"><div role="button" ui-grid-one-bind-id-grid="\'grid-menu\'" ui-grid-one-bind-aria-label="i18n.aria.buttonLabel" tabindex="0" class="ui-grid-icon-container" ng-click="toggleMenu()" ng-keydown="toggleOnKeydown($event)" aria-expanded="{{shown}}" aria-haspopup="true"><i class="ui-grid-icon-menu" ui-grid-one-bind-aria-label="i18n.aria.buttonLabel">&nbsp;</i></div><div ui-grid-menu menu-items="menuItems"></div></div>'),e.put("ui-grid/ui-grid-menu-header-item",'<li role="menuitem"><div class="ui-grid-menu-item" role="heading" aria-level="2" ng-show="itemShown()"><i aria-hidden="true">&nbsp; </i><span ng-bind="label()"></span></div></li>'),e.put("ui-grid/ui-grid-no-header",'<div class="ui-grid-top-panel"></div>'),e.put("ui-grid/ui-grid-row","<div ng-repeat=\"(colRenderIndex, col) in colContainer.renderedColumns track by col.uid\" ui-grid-one-bind-id-grid=\"rowRenderIndex + '-' + col.uid + '-cell'\" class=\"ui-grid-cell\" ng-class=\"{ 'ui-grid-row-header-cell': col.isRowHeader }\" role=\"{{col.isRowHeader ? 'rowheader' : 'gridcell'}}\" ui-grid-cell></div>"),e.put("ui-grid/ui-grid",'<div ui-i18n="en" class="ui-grid">\x3c!-- TODO (c0bra): add "scoped" attr here, eventually? --\x3e<style ui-grid-style>.grid{{ grid.id }} {\n      /* Styles for the grid */\n    }\n\n    .grid{{ grid.id }} .ui-grid-row, .grid{{ grid.id }} .ui-grid-cell, .grid{{ grid.id }} .ui-grid-cell .ui-grid-vertical-bar {\n      height: {{ grid.options.rowHeight }}px;\n    }\n\n    .grid{{ grid.id }} .ui-grid-row:last-child .ui-grid-cell {\n      border-bottom-width: {{ (((grid.getVisibleRowCount() * grid.options.rowHeight) < grid.getViewportHeight()) && \'1\') || \'0\' }}px;\n    }\n\n    {{ grid.verticalScrollbarStyles }}\n    {{ grid.horizontalScrollbarStyles }}\n\n    /*\n    .ui-grid[dir=rtl] .ui-grid-viewport {\n      padding-left: {{ grid.verticalScrollbarWidth }}px;\n    }\n    */\n\n    {{ grid.customStyles }}</style><div class="ui-grid-contents-wrapper" role="grid"><div ui-grid-menu-button ng-if="grid.options.enableGridMenu"></div><div ng-if="grid.hasLeftContainer()" style="width: 0" ui-grid-pinned-container="\'left\'"></div><div ui-grid-render-container container-id="\'body\'" col-container-name="\'body\'" row-container-name="\'body\'" bind-scroll-horizontal="true" bind-scroll-vertical="true" enable-horizontal-scrollbar="grid.options.enableHorizontalScrollbar" enable-vertical-scrollbar="grid.options.enableVerticalScrollbar"></div><div ng-if="grid.hasRightContainer()" style="width: 0" ui-grid-pinned-container="\'right\'"></div><div ui-grid-grid-footer ng-if="grid.options.showGridFooter"></div><div ui-grid-column-menu ng-if="grid.options.enableColumnMenus"></div><div ng-transclude></div></div></div>'),e.put("ui-grid/uiGridCell",'<div class="ui-grid-cell-contents" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div>'),e.put("ui-grid/uiGridColumnMenu",'<div class="ui-grid-column-menu"><div ui-grid-menu menu-items="menuItems" col="col">\x3c!-- <div class="ui-grid-column-menu">\n    <div class="inner" ng-show="menuShown">\n      <ul>\n        <div ng-show="grid.options.enableSorting">\n          <li ng-click="sortColumn($event, asc)" ng-class="{ \'selected\' : col.sort.direction == asc }"><i class="ui-grid-icon-sort-alt-up"></i> Sort Ascending</li>\n          <li ng-click="sortColumn($event, desc)" ng-class="{ \'selected\' : col.sort.direction == desc }"><i class="ui-grid-icon-sort-alt-down"></i> Sort Descending</li>\n          <li ng-show="col.sort.direction" ng-click="unsortColumn()"><i class="ui-grid-icon-cancel"></i> Remove Sort</li>\n        </div>\n      </ul>\n    </div>\n  </div> --\x3e</div></div>'),e.put("ui-grid/uiGridFooterCell",'<div class="ui-grid-cell-contents" col-index="renderIndex"><div>{{ col.getAggregationText() + ( col.getAggregationValue() CUSTOM_FILTERS ) }}</div></div>'),e.put("ui-grid/uiGridHeaderCell",'<div role="columnheader" ng-class="{ \'sortable\': sortable, \'ui-grid-header-cell-last-col\': isLastCol }" ui-grid-one-bind-aria-labelledby-grid="col.uid + \'-header-text \' + col.uid + \'-sortdir-text\'" aria-sort="{{col.sort.direction == asc ? \'ascending\' : ( col.sort.direction == desc ? \'descending\' : (!col.sort.direction ? \'none\' : \'other\'))}}"><div role="button" tabindex="0" ng-keydown="handleKeyDown($event)" class="ui-grid-cell-contents ui-grid-header-cell-primary-focus" col-index="renderIndex" title="TOOLTIP"><span class="ui-grid-header-cell-label" ui-grid-one-bind-id-grid="col.uid + \'-header-text\'">{{ col.displayName CUSTOM_FILTERS }}</span> <span ui-grid-one-bind-id-grid="col.uid + \'-sortdir-text\'" ui-grid-visible="col.sort.direction" aria-label="{{getSortDirectionAriaLabel()}}"><i ng-class="{ \'ui-grid-icon-up-dir\': col.sort.direction == asc, \'ui-grid-icon-down-dir\': col.sort.direction == desc, \'ui-grid-icon-blank\': !col.sort.direction }" title="{{isSortPriorityVisible() ? i18n.headerCell.priority + \' \' + ( col.sort.priority + 1 )  : null}}" aria-hidden="true"></i> <sub ui-grid-visible="isSortPriorityVisible()" class="ui-grid-sort-priority-number">{{col.sort.priority + 1}}</sub></span></div><div role="button" tabindex="0" ui-grid-one-bind-id-grid="col.uid + \'-menu-button\'" class="ui-grid-column-menu-button" ng-if="grid.options.enableColumnMenus && !col.isRowHeader  && col.colDef.enableColumnMenu !== false" ng-click="toggleMenu($event)" ng-keydown="headerCellArrowKeyDown($event)" ui-grid-one-bind-aria-label="i18n.headerCell.aria.columnMenuButtonLabel" aria-expanded="{{col.menuShown}}" aria-haspopup="true"><i class="ui-grid-icon-angle-down" aria-hidden="true">&nbsp;</i></div><div ui-grid-filter ng-hide="col.filterContainer === \'columnMenu\'"></div></div>'),e.put("ui-grid/uiGridMenu",'<div class="ui-grid-menu" ng-keydown="checkKeyDown($event)" ng-show="shown"><style ui-grid-style>{{dynamicStyles}}</style><div class="ui-grid-menu-mid" ng-show="shownMid"><div class="ui-grid-menu-inner" ng-if="shown"><ul role="menu" class="ui-grid-menu-items"><li ng-repeat="item in menuItems" role="menuitem" ui-grid-menu-item ui-grid-one-bind-id="\'menuitem-\'+$index" action="item.action" name="item.title" active="item.active" icon="item.icon" shown="item.shown" context="item.context" template-url="item.templateUrl" leave-open="item.leaveOpen" screen-reader-only="item.screenReaderOnly"></li><li ng-if="col.filterable && col.filterContainer === \'columnMenu\'"><div ui-grid-filter></div></li></ul></div></div></div>'),e.put("ui-grid/uiGridMenuItem",'<button type="button" class="ui-grid-menu-item" ng-click="itemAction($event, title)" ng-show="itemShown()" ng-class="{ \'ui-grid-menu-item-active\': active(), \'ui-grid-sr-only\': (!focus && screenReaderOnly) }" aria-pressed="{{active()}}" tabindex="0" ng-focus="focus=true" ng-blur="focus=false"><i ng-class="icon" aria-hidden="true">&nbsp; </i>{{ label() }}</button>'),e.put("ui-grid/uiGridRenderContainer","<div role=\"presentation\" ui-grid-one-bind-id-grid=\"containerId + '-grid-container'\" class=\"ui-grid-render-container\" ng-style=\"{ 'margin-left': colContainer.getMargin('left') + 'px', 'margin-right': colContainer.getMargin('right') + 'px' }\">\x3c!-- All of these dom elements are replaced in place --\x3e<div ui-grid-header></div><div ui-grid-viewport></div><div ng-if=\"colContainer.needsHScrollbarPlaceholder()\" class=\"ui-grid-scrollbar-placeholder\" ng-style=\"{height: colContainer.grid.scrollbarHeight + 'px'}\"></div><ui-grid-footer ng-if=\"grid.options.showColumnFooter\"></ui-grid-footer></div>"),e.put("ui-grid/uiGridViewport",'<div role="rowgroup" class="ui-grid-viewport" ng-style="colContainer.getViewportStyle()">\x3c!-- tbody --\x3e<div class="ui-grid-canvas"><div ng-repeat="(rowRenderIndex, row) in rowContainer.renderedRows track by $index" class="ui-grid-row" ng-style="Viewport.rowStyle(rowRenderIndex)"><div role="row" ui-grid-row="row" row-render-index="rowRenderIndex"></div></div></div></div>')}]);