/*!
 * ui-grid - v4.12.7 - 2024-04-12
* http://ui-grid.info/
 * Copyright (c) 2024 ; License: MIT 
 */
!function(){"use strict";var e=angular.module("ui.grid.exporter",["ui.grid"]);e.constant("uiGridExporterConstants",{featureName:"exporter",rowHeaderColName:"treeBaseRowHeaderCol",selectionRowHeaderColName:"selectionRowHeaderCol",ALL:"all",VISIBLE:"visible",SELECTED:"selected",CSV_CONTENT:"CSV_CONTENT",BUTTON_LABEL:"BUTTON_LABEL",FILE_NAME:"FILE_NAME"}),e.service("uiGridExporterService",["$filter","$q","uiGridExporterConstants","gridUtil","$compile","$interval","i18nService",function(a,o,u,d,e,n,t){var c={delay:100,type:null,initializeGrid:function(r){r.exporter={},this.defaultGridOptions(r.options);var e={exporter:{}},t={exporter:{csvExport:function(e,t){c.csvExport(r,e,t)},pdfExport:function(e,t){c.pdfExport(r,e,t)},excelExport:function(e,t){c.excelExport(r,e,t)}}};r.api.registerEventsFromObject(e),r.api.registerMethodsFromObject(t),r.api.core.addToGridMenu?c.addToMenu(r):n(function(){r.api.core.addToGridMenu&&c.addToMenu(r)},this.delay,1)},defaultGridOptions:function(e){e.exporterSuppressMenu=!0===e.exporterSuppressMenu,e.exporterMenuLabel=e.exporterMenuLabel||"Export",e.exporterSuppressColumns=e.exporterSuppressColumns||[],e.exporterCsvColumnSeparator=e.exporterCsvColumnSeparator||",",e.exporterCsvFilename=e.exporterCsvFilename||"download.csv",e.exporterPdfFilename=e.exporterPdfFilename||"download.pdf",e.exporterExcelFilename=e.exporterExcelFilename||"download.xlsx",e.exporterExcelSheetName=e.exporterExcelSheetName||"Sheet1",e.exporterOlderExcelCompatibility=!0===e.exporterOlderExcelCompatibility,e.exporterIsExcelCompatible=!0===e.exporterIsExcelCompatible,e.exporterMenuItemOrder=e.exporterMenuItemOrder||200,e.exporterPdfDefaultStyle=e.exporterPdfDefaultStyle||{fontSize:11},e.exporterPdfTableStyle=e.exporterPdfTableStyle||{margin:[0,5,0,15]},e.exporterPdfTableHeaderStyle=e.exporterPdfTableHeaderStyle||{bold:!0,fontSize:12,color:"black"},e.exporterPdfHeader=e.exporterPdfHeader||null,e.exporterPdfFooter=e.exporterPdfFooter||null,e.exporterPdfOrientation=e.exporterPdfOrientation||"landscape",e.exporterPdfPageSize=e.exporterPdfPageSize||"A4",e.exporterPdfMaxGridWidth=e.exporterPdfMaxGridWidth||720,e.exporterMenuAllData=void 0===e.exporterMenuAllData||e.exporterMenuAllData,e.exporterMenuVisibleData=void 0===e.exporterMenuVisibleData||e.exporterMenuVisibleData,e.exporterMenuSelectedData=void 0===e.exporterMenuSelectedData||e.exporterMenuSelectedData,e.exporterMenuCsv=void 0===e.exporterMenuCsv||e.exporterMenuCsv,e.exporterMenuPdf=void 0===e.exporterMenuPdf||e.exporterMenuPdf,e.exporterMenuExcel=void 0===e.exporterMenuExcel||e.exporterMenuExcel,e.exporterPdfCustomFormatter=e.exporterPdfCustomFormatter&&"function"==typeof e.exporterPdfCustomFormatter?e.exporterPdfCustomFormatter:function(e){return e},e.exporterHeaderFilterUseName=!0===e.exporterHeaderFilterUseName,e.exporterFieldCallback=e.exporterFieldCallback||r,e.exporterFieldFormatCallback=e.exporterFieldFormatCallback||function(e,t,r,o){return null},e.exporterExcelCustomFormatters=e.exporterExcelCustomFormatters||function(e,t,r){return r},e.exporterExcelHeader=e.exporterExcelHeader||function(e,t,r,o){return null},e.exporterColumnScaleFactor=e.exporterColumnScaleFactor||3.5,e.exporterFieldApplyFilters=!0===e.exporterFieldApplyFilters,e.exporterAllDataFn=e.exporterAllDataFn||null,null===e.exporterAllDataFn&&e.exporterAllDataPromise&&(e.exporterAllDataFn=e.exporterAllDataPromise)},addToMenu:function(e){e.api.core.addToGridMenu(e,[{title:t.getSafeText("gridMenu.exporterAllAsCsv"),action:function(){e.api.exporter.csvExport(u.ALL,u.ALL)},shown:function(){return e.options.exporterMenuCsv&&e.options.exporterMenuAllData},order:e.options.exporterMenuItemOrder},{title:t.getSafeText("gridMenu.exporterVisibleAsCsv"),action:function(){e.api.exporter.csvExport(u.VISIBLE,u.VISIBLE)},shown:function(){return e.options.exporterMenuCsv&&e.options.exporterMenuVisibleData},order:e.options.exporterMenuItemOrder+1},{title:t.getSafeText("gridMenu.exporterSelectedAsCsv"),action:function(){e.api.exporter.csvExport(u.SELECTED,u.VISIBLE)},shown:function(){return e.options.exporterMenuCsv&&e.options.exporterMenuSelectedData&&e.api.selection&&0<e.api.selection.getSelectedRows().length},order:e.options.exporterMenuItemOrder+2},{title:t.getSafeText("gridMenu.exporterAllAsPdf"),action:function(){e.api.exporter.pdfExport(u.ALL,u.ALL)},shown:function(){return e.options.exporterMenuPdf&&e.options.exporterMenuAllData},order:e.options.exporterMenuItemOrder+3},{title:t.getSafeText("gridMenu.exporterVisibleAsPdf"),action:function(){e.api.exporter.pdfExport(u.VISIBLE,u.VISIBLE)},shown:function(){return e.options.exporterMenuPdf&&e.options.exporterMenuVisibleData},order:e.options.exporterMenuItemOrder+4},{title:t.getSafeText("gridMenu.exporterSelectedAsPdf"),action:function(){e.api.exporter.pdfExport(u.SELECTED,u.VISIBLE)},shown:function(){return e.options.exporterMenuPdf&&e.options.exporterMenuSelectedData&&e.api.selection&&0<e.api.selection.getSelectedRows().length},order:e.options.exporterMenuItemOrder+5},{title:t.getSafeText("gridMenu.exporterAllAsExcel"),action:function(){e.api.exporter.excelExport(u.ALL,u.ALL)},shown:function(){return e.options.exporterMenuExcel&&e.options.exporterMenuAllData},order:e.options.exporterMenuItemOrder+6},{title:t.getSafeText("gridMenu.exporterVisibleAsExcel"),action:function(){e.api.exporter.excelExport(u.VISIBLE,u.VISIBLE)},shown:function(){return e.options.exporterMenuExcel&&e.options.exporterMenuVisibleData},order:e.options.exporterMenuItemOrder+7},{title:t.getSafeText("gridMenu.exporterSelectedAsExcel"),action:function(){e.api.exporter.excelExport(u.SELECTED,u.VISIBLE)},shown:function(){return e.options.exporterMenuExcel&&e.options.exporterMenuSelectedData&&e.api.selection&&0<e.api.selection.getSelectedRows().length},order:e.options.exporterMenuItemOrder+8}])},csvExport:function(r,o,n){var i=this;i.type="csv",this.loadAllDataIfNeeded(r,o,n).then(function(){var e=r.options.showHeader?i.getColumnHeaders(r,n):[],t=i.getData(r,o,n),e=i.formatAsCsv(e,t,r.options.exporterCsvColumnSeparator),t=angular.isFunction(r.options.exporterCsvFilename)?r.options.exporterCsvFilename(r,o,n):r.options.exporterCsvFilename;i.downloadFile(t,e,r.options.exporterCsvColumnSeparator,r.options.exporterOlderExcelCompatibility,r.options.exporterIsExcelCompatible)})},loadAllDataIfNeeded:function(t,e,r){return e===u.ALL&&t.rows.length!==t.options.totalItems&&t.options.exporterAllDataFn?t.options.exporterAllDataFn().then(function(e){t.modifyRows(e)}):((e=o.defer()).resolve(),e.promise)},getColumnHeaders:function(t,e){var r,o,n=[];return(e===u.ALL?t.columns:(e=t.renderContainers.left?t.renderContainers.left.visibleColumnCache.filter(function(e){return e.visible}):[],r=t.renderContainers.body?t.renderContainers.body.visibleColumnCache.filter(function(e){return e.visible}):[],o=t.renderContainers.right?t.renderContainers.right.visibleColumnCache.filter(function(e){return e.visible}):[],e.concat(r,o))).forEach(function(e){!0!==e.colDef.exporterSuppressExport&&"$$hashKey"!==e.field&&-1===t.options.exporterSuppressColumns.indexOf(e.name)&&(e={name:e.field,displayName:function(e,t){if(e.options.exporterHeaderFilter)return e.options.exporterHeaderFilterUseName?e.options.exporterHeaderFilter(t.name):e.options.exporterHeaderFilter(t.displayName);return t.headerCellFilter?a(t.headerCellFilter)(t.displayName):t.displayName}(t,e),width:e.drawnWidth||e.width,align:e.colDef.align||("number"===e.colDef.type?"right":"left")},n.push(e))}),n},getRowsFromNode:function(e){var t=[],r=e?Object.keys(e):["children"];if((1<r.length||"children"!=r[0])&&t.push(e),e&&e.children&&0<e.children.length)for(var o=0;o<e.children.length;o++)t=t.concat(this.getRowsFromNode(e.children[o]));return t},getDataSorted:function(e){if(!e.treeBase||0===e.treeBase.numberLevels)return e.rows;for(var t=[],r=0;r<e.treeBase.tree.length;r++)for(var o=this.getRowsFromNode(e.treeBase.tree[r]),n=0;n<o.length;n++)t.push(o[n].row);return t},getData:function(i,e,a,l){var t,r,o,n,p,s=[];switch(e){case u.ALL:t=this.getDataSorted(i,e,a,l);break;case u.VISIBLE:t=i.getVisibleRows();break;case u.SELECTED:i.api.selection?t=i.api.selection.getSelectedGridRows():d.logError("selection feature must be enabled to allow selected rows to be exported")}return p=a===u.ALL?i.columns:(r=i.renderContainers.left?i.renderContainers.left.visibleColumnCache.filter(function(e){return e.visible}):[],o=i.renderContainers.body?i.renderContainers.body.visibleColumnCache.filter(function(e){return e.visible}):[],n=i.renderContainers.right?i.renderContainers.right.visibleColumnCache.filter(function(e){return e.visible}):[],r.concat(o,n)),t.forEach(function(o){var n;!1!==o.exporterEnableExporting&&(n=[],p.forEach(function(e){var t,r;!e.visible&&a!==u.ALL||!0===e.colDef.exporterSuppressExport||"$$hashKey"===e.field||-1!==i.options.exporterSuppressColumns.indexOf(e.name)||(r=l?i.getCellDisplayValue(o,e):i.getCellValue(o,e),t={value:i.options.exporterFieldCallback(i,o,e,r,c.type)},(r=i.options.exporterFieldFormatCallback(i,o,e,r,c.type))&&Object.assign(t,r),e.colDef.exporterPdfAlign&&(t.alignment=e.colDef.exporterPdfAlign),n.push(t))}),s.push(n))}),s},formatAsCsv:function(e,t,r){e=e.map(function(e){return{value:e.displayName}}),e=0<e.length?this.formatRowAsCsv(this,r)(e)+"\n":"";return e+=t.map(this.formatRowAsCsv(this,r)).join("\n")},formatRowAsCsv:function(t,r){return function(e){return e.map(t.formatFieldAsCsv).join(r)}},formatFieldAsCsv:function(e){return null==e.value?"":"number"==typeof e.value?e.value:"boolean"==typeof e.value?e.value?"TRUE":"FALSE":"string"==typeof e.value?'"'+e.value.replace(/"/g,'""')+'"':"object"!=typeof e.value||e.value instanceof Date?JSON.stringify(e.value):'"'+JSON.stringify(e.value).replace(/"/g,'""')+'"'},isIE:function(){return-1!==navigator.userAgent.search(/(?:Edge|MSIE|Trident\/.*; rv:)/)?!0:!1},downloadFile:function(e,t,r,o,n){var i,a=document,l=a.createElement("a"),p="application/octet-stream;charset=utf-8",s=this.isIE();return n&&(t="sep="+r+"\r\n"+t),navigator.msSaveBlob?navigator.msSaveOrOpenBlob(new Blob([o?"\ufeff":"",t],{type:p}),e):s?(n=a.createElement("iframe"),document.body.appendChild(n),n.contentWindow.document.open("text/html","replace"),n.contentWindow.document.write(t),n.contentWindow.document.close(),n.contentWindow.focus(),n.contentWindow.document.execCommand("SaveAs",!0,e),document.body.removeChild(n),!0):("download"in l?(r=new Blob([o?"\ufeff":"",t],{type:p}),i=URL.createObjectURL(r),l.setAttribute("download",e)):(i="data: "+p+","+encodeURIComponent(t),l.setAttribute("target","_blank")),l.href=i,l.setAttribute("style","display:none;"),a.body.appendChild(l),void setTimeout(function(){var e;l.click?l.click():document.createEvent&&((e=document.createEvent("MouseEvents")).initEvent("click",!0,!0),l.dispatchEvent(e)),a.body.removeChild(l)},this.delay))},pdfExport:function(r,o,n){var i=this;i.type="pdf",this.loadAllDataIfNeeded(r,o,n).then(function(){var e=i.getColumnHeaders(r,n),t=i.getData(r,o,n),e=i.prepareAsPdf(r,e,t);i.isIE()||-1!==navigator.appVersion.indexOf("Edge")?(t=angular.isFunction(r.options.exporterPdfFilename)?r.options.exporterPdfFilename(r,o,n):r.options.exporterPdfFilename,i.downloadPDF(t,e)):pdfMake.createPdf(e).open()})},downloadPDF:function(t,e){var r,o=document,n=(o.createElement("a"),this.isIE());pdfMake.createPdf(e).getBuffer(function(e){return r=new Blob([e]),navigator.msSaveBlob?navigator.msSaveBlob(r,t):n?(e=o.createElement("iframe"),document.body.appendChild(e),e.contentWindow.document.open("text/html","replace"),e.contentWindow.document.write(r),e.contentWindow.document.close(),e.contentWindow.focus(),e.contentWindow.document.execCommand("SaveAs",!0,t),document.body.removeChild(e),!0):void 0})},prepareAsPdf:function(e,t,r){var o=this.calculatePdfHeaderWidths(e,t),t=t.map(function(e){return{text:e.displayName,style:"tableHeader"}}),r=r.map(this.formatRowAsPdf(this)),t=[t].concat(r),r={pageOrientation:e.options.exporterPdfOrientation,pageSize:e.options.exporterPdfPageSize,content:[{style:"tableStyle",table:{headerRows:1,widths:o,body:t}}],styles:{tableStyle:e.options.exporterPdfTableStyle,tableHeader:e.options.exporterPdfTableHeaderStyle},defaultStyle:e.options.exporterPdfDefaultStyle};return e.options.exporterPdfLayout&&(r.layout=e.options.exporterPdfLayout),e.options.exporterPdfHeader&&(r.header=e.options.exporterPdfHeader),e.options.exporterPdfFooter&&(r.footer=e.options.exporterPdfFooter),r=e.options.exporterPdfCustomFormatter?e.options.exporterPdfCustomFormatter(r):r},calculatePdfHeaderWidths:function(t,e){var r=0,o=(e.forEach(function(e){"number"==typeof e.width&&(r+=e.width)}),0),n=(e.forEach(function(e){var t;"*"===e.width&&(o+=100),"string"==typeof e.width&&e.width.match(/(\d)*%/)&&(t=parseInt(e.width.match(/(\d)*%/)[0]),e.width=r*t/100,o+=e.width)}),r+o);return e.map(function(e){return"*"===e.width?e.width:e.width*t.options.exporterPdfMaxGridWidth/n})},formatRowAsPdf:function(t){return function(e){return e.map(t.formatFieldAsPdfString)}},formatFieldAsPdfString:function(e){var t=null==e.value?"":"number"==typeof e.value?e.value.toString():"boolean"==typeof e.value?e.value?"TRUE":"FALSE":"string"==typeof e.value?e.value.replace(/"/g,'""'):!(e.value instanceof Date)&&"object"==typeof e.value?e.value:JSON.stringify(e.value).replace(/^"/,"").replace(/"$/,"");return t=e.alignment&&"string"==typeof e.alignment?{text:t,alignment:e.alignment}:t},formatAsExcel:function(e,t,r,o,n){for(var i=e.map(function(e){return{value:e.displayName}}),a=[],l=[],p=0;p<i.length;p++){var s="header";switch(e[p].align){case"center":s="headerCenter";break;case"right":s="headerRight"}var d=n.styles&&n.styles[s]?{style:n.styles[s].id}:null;l.push({value:i[p].value,metadata:d})}a.push(l);for(var u=t.map(this.formatRowAsExcel(this,r,o)),c=0;c<u.length;c++)a.push(u[c]);return a},formatRowAsExcel:function(n,i,a){return function(e){for(var t=[],r=0;r<e.length;r++){var o=n.formatFieldAsExcel(e[r],i,a);t.push({value:o,metadata:e[r].metadata})}return t}},formatFieldAsExcel:function(e,t,r,o){return null==e.value?"":"number"==typeof e.value||"string"==typeof e.value?e.value:"boolean"==typeof e.value?e.value?"TRUE":"FALSE":JSON.stringify(e.value)},prepareAsExcel:function(e,t,r){var o={styles:{}};return e.options.exporterExcelCustomFormatters&&(o=e.options.exporterExcelCustomFormatters(e,t,o)),e.options.exporterExcelHeader&&(angular.isFunction(e.options.exporterExcelHeader)?e.options.exporterExcelHeader(e,t,r,o):(t=e.options.exporterExcelHeader.text,e=e.options.exporterExcelHeader.style,r.data.push([{value:t,metadata:{style:o.styles[e].id}}]))),o},excelExport:function(l,p,s){var d=this;d.type="excel",this.loadAllDataIfNeeded(l,p,s).then(function(){for(var e=l.options.showHeader?d.getColumnHeaders(l,s):[],t="Sheet1",t=(l.options.exporterExcelSheetName&&(t=angular.isFunction(l.options.exporterExcelSheetName)?l.options.exporterExcelSheetName(l,p,s):l.options.exporterExcelSheetName),new ExcelBuilder.Worksheet({name:t})),r=new ExcelBuilder.Workbook,o=(r.addWorksheet(t),d.prepareAsExcel(l,r,t)),n=[],i=l.treeBase?l.treeBase.numberLevels:l.enableRowSelection?1:0;i<l.columns.length;i++)l.columns[i].field!==u.rowHeaderColName&&l.columns[i].field!==u.selectionRowHeaderColName&&n.push({width:l.columns[i].drawnWidth/l.options.exporterColumnScaleFactor});t.setColumns(n);var a=d.getData(l,p,s,l.options.exporterFieldApplyFilters),e=d.formatAsExcel(e,a,r,t,o);t.setData(t.data.concat(e)),ExcelBuilder.Builder.createFile(r,{type:"blob"}).then(function(e){var t=angular.isFunction(l.options.exporterExcelFilename)?l.options.exporterExcelFilename(l,p,s):l.options.exporterExcelFilename;d.downloadFile(t,e,l.options.exporterCsvColumnSeparator,l.options.exporterOlderExcelCompatibility)})})}};function r(e,t,r,o){var n,i;return r.cellFilter?(n=(r=r.cellFilter.match(/(?:[^:"]+|"[^"]*")+/g))[0]?r[0].replace(/[\'\"\s]/g,""):null,i=r[1]?r[1].replace(/[\'\"]/g,"").trim():null,r=r[2]?r[2].replace(/[\'\"\s]/g,""):null,a(n)(o,i,r)):o}return c}]),e.directive("uiGridExporter",["uiGridExporterConstants","uiGridExporterService","gridUtil","$compile",function(e,n,t,r){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(e,t,r,o){n.initializeGrid(o.grid),o.grid.exporter.$scope=e}}}])}(),angular.module("ui.grid.exporter").run(["$templateCache",function(e){"use strict";e.put("ui-grid/csvLink",'<span class="ui-grid-exporter-csv-link-span"><a href="data:text/csv;charset=UTF-8,CSV_CONTENT" download="FILE_NAME">LINK_LABEL</a></span>')}]);