/*!
 * ui-grid - v4.12.7 - 2024-04-12
* http://ui-grid.info/
 * Copyright (c) 2024 ; License: MIT 
 */
!function(){"use strict";angular.module("ui.grid.i18n",[]),angular.module("ui.grid",["ui.grid.i18n"])}(),function(){"use strict";angular.module("ui.grid.autoResize",["ui.grid"]).directive("uiGridAutoResize",["gridUtil",function(r){return{require:"uiGrid",scope:!1,link:function(e,n,t,o){var i;i=r.debounce(function(e,t,i,r){null!==n[0].offsetParent&&(o.grid.gridWidth=i,o.grid.gridHeight=r,o.grid.queueGridRefresh().then(function(){o.grid.api.core.raise.gridDimensionChanged(t,e,r,i)}))},400),e.$watchCollection(function(){return{width:r.elementWidth(n),height:r.elementHeight(n)}},function(e,t){angular.equals(e,t)||i(t.width,t.height,e.width,e.height)})}}}])}(),function(){"use strict";var e=angular.module("ui.grid.cellNav",["ui.grid"]);e.constant("uiGridCellNavConstants",{FEATURE_NAME:"gridCellNav",CELL_NAV_EVENT:"cellNav",direction:{LEFT:0,RIGHT:1,UP:2,DOWN:3,PG_UP:4,PG_DOWN:5},EVENT_TYPE:{KEYDOWN:0,CLICK:1,CLEAR:2}}),e.factory("uiGridCellNavFactory",["uiGridCellNavConstants","GridRowColumn",function(r,a){function e(e,t,i,r){this.rows=e.visibleRowCache,this.columns=t.visibleColumnCache,this.leftColumns=i?i.visibleColumnCache:[],this.rightColumns=r?r.visibleColumnCache:[],this.bodyContainer=e}return e.prototype.getFocusableCols=function(){return this.leftColumns.concat(this.columns,this.rightColumns).filter(function(e){return e.colDef.allowCellFocus})},e.prototype.getFocusableRows=function(){return this.rows.filter(function(e){return!1!==e.allowCellFocus})},e.prototype.getNextRowCol=function(e,t,i){switch(e){case r.direction.LEFT:return this.getRowColLeft(t,i);case r.direction.RIGHT:return this.getRowColRight(t,i);case r.direction.UP:return this.getRowColUp(t,i);case r.direction.DOWN:return this.getRowColDown(t,i);case r.direction.PG_UP:return this.getRowColPageUp(t,i);case r.direction.PG_DOWN:return this.getRowColPageDown(t,i)}},e.prototype.initializeSelection=function(){var e=this.getFocusableCols(),t=this.getFocusableRows();return 0===e.length||0===t.length?null:new a(t[0],e[0])},e.prototype.getRowColLeft=function(e,t){var i=this.getFocusableCols(),r=this.getFocusableRows(),t=i.indexOf(t),n=r.indexOf(e),o=0===(t=-1===t?1:t)?i.length-1:t-1;return new a(!(t<=o)||0===n?e:r[n-1],i[o])},e.prototype.getRowColRight=function(e,t){var i=this.getFocusableCols(),r=this.getFocusableRows(),t=i.indexOf(t),n=r.indexOf(e),o=(t=-1===t?0:t)===i.length-1?0:t+1;return!(o<=t)||n===r.length-1?new a(e,i[o]):new a(r[n+1],i[o])},e.prototype.getRowColDown=function(e,t){var i=this.getFocusableCols(),r=this.getFocusableRows(),t=i.indexOf(t),n=r.indexOf(e);return-1===t&&(t=0),n===r.length-1?new a(e,i[t]):new a(r[n+1],i[t])},e.prototype.getRowColPageDown=function(e,t){var i=this.getFocusableCols(),r=this.getFocusableRows(),t=i.indexOf(t),e=r.indexOf(e),n=(-1===t&&(t=0),this.bodyContainer.minRowsToRender());return e>=r.length-n?new a(r[r.length-1],i[t]):new a(r[e+n],i[t])},e.prototype.getRowColUp=function(e,t){var i=this.getFocusableCols(),r=this.getFocusableRows(),t=i.indexOf(t),n=r.indexOf(e);return new a(0===n?e:r[n-1],i[t=-1===t?0:t])},e.prototype.getRowColPageUp=function(e,t){var i=this.getFocusableCols(),r=this.getFocusableRows(),t=i.indexOf(t),e=r.indexOf(e),n=(-1===t&&(t=0),this.bodyContainer.minRowsToRender());return new a(e-n<0?r[0]:r[e-n],i[t])},e}]),e.service("uiGridCellNavService",["uiGridConstants","uiGridCellNavConstants","$q","uiGridCellNavFactory",function(t,i,r,n){var o={initializeGrid:function(r){r.registerColumnBuilder(o.cellNavColumnBuilder),r.cellNav={},r.cellNav.lastRowCol=null,r.cellNav.focusedCells=[],o.defaultGridOptions(r.options);var e={cellNav:{navigate:function(e,t){},viewPortKeyDown:function(e,t){},viewPortKeyPress:function(e,t){}}},t={cellNav:{scrollToFocus:function(e,t){return o.scrollToFocus(r,e,t)},getFocusedCell:function(){return r.cellNav.lastRowCol},getCurrentSelection:function(){return r.cellNav.focusedCells},rowColSelectIndex:function(e){for(var t=-1,i=0;i<r.cellNav.focusedCells.length;i++)if(r.cellNav.focusedCells[i].col.uid===e.col.uid&&r.cellNav.focusedCells[i].row.uid===e.row.uid){t=i;break}return t}}};r.api.registerEventsFromObject(e),r.api.registerMethodsFromObject(t)},defaultGridOptions:function(e){e.modifierKeysToMultiSelectCells=!0===e.modifierKeysToMultiSelectCells,e.keyDownOverrides=e.keyDownOverrides||[]},decorateRenderContainers:function(e){var t=e.hasRightContainer()?e.renderContainers.right:null,i=e.hasLeftContainer()?e.renderContainers.left:null;null!==i&&(e.renderContainers.left.cellNav=new n(e.renderContainers.body,i,t,e.renderContainers.body)),null!==t&&(e.renderContainers.right.cellNav=new n(e.renderContainers.body,t,e.renderContainers.body,i)),e.renderContainers.body.cellNav=new n(e.renderContainers.body,e.renderContainers.body,i,t)},getDirection:function(e){return e.keyCode===t.keymap.LEFT||e.keyCode===t.keymap.TAB&&e.shiftKey?i.direction.LEFT:e.keyCode===t.keymap.RIGHT||e.keyCode===t.keymap.TAB?i.direction.RIGHT:e.keyCode===t.keymap.UP||e.keyCode===t.keymap.ENTER&&e.shiftKey?i.direction.UP:e.keyCode===t.keymap.PG_UP?i.direction.PG_UP:e.keyCode===t.keymap.DOWN||e.keyCode===t.keymap.ENTER&&!e.ctrlKey&&!e.altKey?i.direction.DOWN:e.keyCode===t.keymap.PG_DOWN?i.direction.PG_DOWN:null},cellNavColumnBuilder:function(e,t,i){return e.allowCellFocus=void 0===e.allowCellFocus||e.allowCellFocus,r.all([])},scrollToFocus:function(t,e,i){var r=null,n=null;return null!=e&&(r=t.getRow(e)),null!=i&&(n=t.getColumn(i.name||i.field)),t.api.core.scrollToIfNecessary(r,n).then(function(){var e={row:r,col:n};null!==r&&null!==n&&t.cellNav.broadcastCellNav(e,null,null)})},getLeftWidth:function(e,t){var i,r=0;return t&&(i=e.renderContainers.body.visibleColumnCache.indexOf(t),e.renderContainers.body.visibleColumnCache.forEach(function(e,t){t<i&&(r+=e.drawnWidth)}),e=0===i?0:(i+1)/e.renderContainers.body.visibleColumnCache.length,r+=t.drawnWidth*e),r}};return o}]),e.directive("uiGridCellnav",["uiGridCellNavService","uiGridCellNavConstants","uiGridConstants","GridRowColumn","$compile","i18nService",function(s,u,d,c,o,g){return{replace:!0,priority:-150,require:"^uiGrid",scope:!1,controller:function(){},compile:function(){return{pre:function(e,t,i,a){var r=e,l=a.grid;s.initializeGrid(l),a.cellNav={},a.cellNav.makeRowCol=function(e){return e=e instanceof c?e:new c(e.row,e.col)},a.cellNav.getActiveCell=function(){var e=t[0].getElementsByClassName("ui-grid-cell-focus");if(0<e.length)return e[0]},a.cellNav.broadcastCellNav=l.cellNav.broadcastCellNav=function(e,t,i){t=!(void 0===t||!t),e=a.cellNav.makeRowCol(e),a.cellNav.broadcastFocus(e,t,i),r.$broadcast(u.CELL_NAV_EVENT,e,t,i)},a.cellNav.clearFocus=l.cellNav.clearFocus=function(){l.cellNav.focusedCells=[],r.$broadcast(u.CELL_NAV_EVENT)},a.cellNav.broadcastFocus=function(e,t,i){t=!(void 0===t||!t);var r=(e=a.cellNav.makeRowCol(e)).row,n=e.col,o=a.grid.api.cellNav.rowColSelectIndex(e);null===l.cellNav.lastRowCol||-1===o||l.cellNav.lastRowCol.col===n&&l.cellNav.lastRowCol.row===r?(r=new c(r,n),null!==l.cellNav.lastRowCol&&l.cellNav.lastRowCol.row===r.row&&l.cellNav.lastRowCol.col===r.col&&!l.options.enableCellEditOnFocus||(l.api.cellNav.raise.navigate(r,l.cellNav.lastRowCol,i),l.cellNav.lastRowCol=r),a.grid.options.modifierKeysToMultiSelectCells&&t?l.cellNav.focusedCells.push(e):l.cellNav.focusedCells=[e]):l.options.modifierKeysToMultiSelectCells&&t&&0<=o&&l.cellNav.focusedCells.splice(o,1)},a.cellNav.handleKeyDown=function(e){var t,i,r,n,o=s.getDirection(e);return null===o?null:(r="body",e.uiGridTargetRenderContainerId&&(r=e.uiGridTargetRenderContainerId),(t=a.grid.api.cellNav.getFocusedCell())?(i=a.grid.renderContainers[r].cellNav.getNextRowCol(o,t.row,t.col),r=a.grid.renderContainers[r].cellNav.getFocusableCols(),n=a.grid.api.cellNav.rowColSelectIndex(i),(o!==u.direction.LEFT||i.col!==r[r.length-1]||i.row!==t.row||e.keyCode!==d.keymap.TAB||!e.shiftKey)&&(o!==u.direction.RIGHT||i.col!==r[0]||i.row!==t.row||e.keyCode!==d.keymap.TAB||e.shiftKey)?(l.scrollToIfNecessary(i.row,i.col).then(function(){a.cellNav.broadcastCellNav(i,null,e)}),e.stopPropagation(),e.preventDefault(),!1):(l.cellNav.focusedCells.splice(n,1),a.cellNav.clearFocus(),!0)):void 0)}},post:function(t,i,e,r){var c=r.grid,r=!0;try{angular.module("ngAria")}catch(e){r=!1}function n(){var e='<div id="'+c.id+'-aria-speakable" class="ui-grid-a11y-ariascreenreader-speakable ui-grid-offscreen" aria-live="assertive" role="alert" aria-atomic="true" aria-hidden="false" aria-relevant="additions" >&nbsp;</div>',d=o(e)(t);i.prepend(d),t.$on(u.CELL_NAV_EVENT,function(e,t,i,r){if(!r||"focus"!==r.type){for(var n,o=[],a=c.api.cellNav.getCurrentSelection(),l=0;l<a.length;l++){s=a[l],n="";var s=(n="selectionRowHeaderCol"===s.col.field?(s.row.isSelected?g.getSafeText("search.aria.selected"):g.getSafeText("search.aria.notSelected"))+", ":n)+c.getCellDisplayValue(s.row,s.col)+(n=a[l].col,", "+g.getSafeText("headerCell.aria.column")+" "+n.displayName);o.push(s)}(r=o.toString())!==d.text().trim()&&(d[0].style.clip="rect(0px,0px,0px,0px)",d[0].innerHTML="",d[0].style.visibility="hidden",d[0].style.visibility="visible",""!==r)&&(d[0].style.clip="auto",d[0].appendChild(document.createTextNode(r+" ")),d[0].style.visibility="hidden",d[0].style.visibility="visible")}})}r&&n()}}}}}]),e.directive("uiGridRenderContainer",["$timeout","gridUtil","uiGridCellNavService","$compile","uiGridCellNavConstants",function(d,c,u,g,p){return{replace:!0,priority:-99999,require:["^uiGrid","uiGridRenderContainer","?^uiGridCellnav"],scope:!1,compile:function(){return{post:function(e,t,i,r){var n,o,a,l=r[0],s=r[1],r=r[2];l.grid.api.cellNav&&(n=s.containerId,s=l.grid,u.decorateRenderContainers(s),"body"===n)&&(l.grid.options.modifierKeysToMultiSelectCells?t.attr("aria-multiselectable",!0):t.attr("aria-multiselectable",!1),o=g('<div class="ui-grid-focuser" role="region" aria-live="assertive" aria-atomic="false" tabindex="0" aria-controls="'+s.id+"-aria-speakable "+s.id+'-grid-container" aria-owns="'+s.id+'-grid-container"></div>')(e),t.append(o),o.on("focus",function(e){e.uiGridTargetRenderContainerId=n,null===l.grid.api.cellNav.getFocusedCell()&&(e=l.grid.renderContainers[n].cellNav.getNextRowCol(p.direction.DOWN,null,null)).row&&e.col&&l.cellNav.broadcastCellNav(e)}),r.setAriaActivedescendant=function(e){t.attr("aria-activedescendant",e)},r.removeAriaActivedescendant=function(e){t.attr("aria-activedescendant")===e&&t.attr("aria-activedescendant","")},l.focus=function(){c.focus.byElement(o[0])},a=null,o.on("keydown",function(i){i.uiGridTargetRenderContainerId=n;var e=l.grid.api.cellNav.getFocusedCell();null===(l.grid.options.keyDownOverrides.some(function(t){return Object.keys(t).every(function(e){return t[e]===i[e]})})?null:l.cellNav.handleKeyDown(i))&&(l.grid.api.cellNav.raise.viewPortKeyDown(i,e,l.cellNav.handleKeyDown),a=e)}),o.on("keypress",function(e){a&&(d(function(){l.grid.api.cellNav.raise.viewPortKeyPress(e,a)},4),a=null)}),e.$on("$destroy",function(){o.off()}))}}}}}]),e.directive("uiGridViewport",function(){return{replace:!0,priority:-99999,require:["^uiGrid","^uiGridRenderContainer","?^uiGridCellnav"],scope:!1,compile:function(){return{pre:function(e,t,i,r){},post:function(e,t,i,r){var n=r[0],o=r[1];n.grid.api.cellNav&&"body"===o.containerId&&((r=n.grid).api.core.on.scrollBegin(e,function(){var e=n.grid.api.cellNav.getFocusedCell();null!==e&&o.colContainer.containsColumn(e.col)&&n.cellNav.clearFocus()}),r.api.core.on.scrollEnd(e,function(e){var t=n.grid.api.cellNav.getFocusedCell();null!==t&&o.colContainer.containsColumn(t.col)&&n.cellNav.broadcastCellNav(t)}),r.api.cellNav.on.navigate(e,function(){n.focus()}))}}}}}),e.directive("uiGridCell",["uiGridCellNavConstants","uiGridConstants","GridRowColumn",function(u,g,p){return{priority:-150,restrict:"A",require:["^uiGrid","?^uiGridCellnav"],scope:!1,link:function(i,e,t,r){var n,o,a=r[0],l=r[1];function s(e){e.preventDefault()}function d(){n.cellNav.focusedCells.some(function(e,t){return e.row===i.row&&e.col===i.col})?i.focused||(e.find("div").addClass("ui-grid-cell-focus"),e.attr("aria-selected",!0),l.setAriaActivedescendant(e.attr("id")),i.focused=!0):c()}function c(){i.focused&&(e.find("div").removeClass("ui-grid-cell-focus"),e.attr("aria-selected",!1),l.removeAriaActivedescendant(e.attr("id")),i.focused=!1)}a.grid.api.cellNav&&i.col.colDef.allowCellFocus&&(n=a.grid,i.focused=!1,e.attr("tabindex",-1),e.find("div").on("click",function(e){a.cellNav.broadcastCellNav(new p(i.row,i.col),e.ctrlKey||e.metaKey,e),e.stopPropagation(),i.$apply()}),e.on("mousedown",s),a.grid.api.edit&&(a.grid.api.edit.on.beginCellEdit(i,function(){e.off("mousedown",s)}),a.grid.api.edit.on.afterCellEdit(i,function(){e.on("mousedown",s)}),a.grid.api.edit.on.cancelCellEdit(i,function(){e.on("mousedown",s)})),d(),e.on("focus",function(e){a.cellNav.broadcastCellNav(new p(i.row,i.col),!1,e),e.stopPropagation(),i.$apply()}),i.$on(u.CELL_NAV_EVENT,d),o=a.grid.registerDataChangeCallback(function(e){c(),i.$applyAsync(d)},[g.dataChange.ROW]),i.$on("$destroy",function(){o(),e.find("div").off(),e.off()}))}}}])}(),function(){"use strict";angular.module("ui.grid").constant("uiGridConstants",{LOG_DEBUG_MESSAGES:!0,LOG_WARN_MESSAGES:!0,LOG_ERROR_MESSAGES:!0,CUSTOM_FILTERS:/CUSTOM_FILTERS/g,COL_FIELD:/COL_FIELD/g,MODEL_COL_FIELD:/MODEL_COL_FIELD/g,TOOLTIP:/title=\"TOOLTIP\"/g,DISPLAY_CELL_TEMPLATE:/DISPLAY_CELL_TEMPLATE/g,TEMPLATE_REGEXP:/<.+>/,FUNC_REGEXP:/(\([^)]*\))?$/,DOT_REGEXP:/\./g,APOS_REGEXP:/'/g,BRACKET_REGEXP:/^(.*)((?:\s*\[\s*\d+\s*\]\s*)|(?:\s*\[\s*"(?:[^"\\]|\\.)*"\s*\]\s*)|(?:\s*\[\s*'(?:[^'\\]|\\.)*'\s*\]\s*))(.*)$/,COL_CLASS_PREFIX:"ui-grid-col",ENTITY_BINDING:"$$this",events:{GRID_SCROLL:"uiGridScroll",COLUMN_MENU_SHOWN:"uiGridColMenuShown",ITEM_DRAGGING:"uiGridItemDragStart",COLUMN_HEADER_CLICK:"uiGridColumnHeaderClick"},keymap:{TAB:9,STRG:17,CAPSLOCK:20,CTRL:17,CTRLRIGHT:18,CTRLR:18,SHIFT:16,RETURN:13,ENTER:13,BACKSPACE:8,BCKSP:8,ALT:18,ALTR:17,ALTRIGHT:17,SPACE:32,WIN:91,MAC:91,FN:null,PG_UP:33,PG_DOWN:34,UP:38,DOWN:40,LEFT:37,RIGHT:39,ESC:27,DEL:46,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123},ASC:"asc",DESC:"desc",filter:{STARTS_WITH:2,ENDS_WITH:4,EXACT:8,CONTAINS:16,GREATER_THAN:32,GREATER_THAN_OR_EQUAL:64,LESS_THAN:128,LESS_THAN_OR_EQUAL:256,NOT_EQUAL:512,SELECT:"select",INPUT:"input"},aggregationTypes:{sum:2,count:4,avg:8,min:16,max:32},CURRENCY_SYMBOLS:["¤","؋","Ar","Ƀ","฿","B/.","Br","Bs.","Bs.F.","GH₵","¢","c","Ch.","₡","C$","D","ден","دج",".د.ب","د.ع","JD","د.ك","ل.د","дин","د.ت","د.م.","د.إ","Db","$","₫","Esc","€","ƒ","Ft","FBu","FCFA","CFA","Fr","FRw","G","gr","₲","h","₴","₭","Kč","kr","kn","MK","ZK","Kz","K","L","Le","лв","E","lp","M","KM","MT","₥","Nfk","₦","Nu.","UM","T$","MOP$","₱","Pt.","£","ج.م.","LL","LS","P","Q","q","R","R$","ر.ع.","ر.ق","ر.س","៛","RM","p","Rf.","₹","₨","SRe","Rp","₪","Ksh","Sh.So.","USh","S/","SDR","сом","৳\t","WS$","₮","VT","₩","¥","zł"],scrollDirection:{UP:"up",DOWN:"down",LEFT:"left",RIGHT:"right",NONE:"none"},dataChange:{ALL:"all",EDIT:"edit",ROW:"row",COLUMN:"column",OPTIONS:"options"},scrollbars:{NEVER:0,ALWAYS:1,WHEN_NEEDED:2}})}(),angular.module("ui.grid").directive("uiGridCell",["$compile","$parse","gridUtil","uiGridConstants",function(n,e,o,s){return{priority:0,scope:!1,require:"?^uiGrid",compile:function(){return{pre:function(t,i,e,r){r&&t.col.compiledElementFn?(0,t.col.compiledElementFn)(t,function(e,t){i.append(e)}):r&&!t.col.compiledElementFn?t.col.getCompiledElementFn().then(function(e){e(t,function(e,t){i.append(e)})}).catch(angular.noop):(r=t.col.cellTemplate.replace(s.MODEL_COL_FIELD,"row.entity."+o.preEval(t.col.field)).replace(s.COL_FIELD,"grid.getCellValue(row, col)"),r=n(r)(t),i.append(r))},post:function(i,r){var n,o=i.col.getColClass(!1);function a(e){var t=r;n&&(t.removeClass(n),n=null),n=angular.isFunction(i.col.cellClass)?i.col.cellClass(i.grid,i.row,i.col,i.rowRenderIndex,i.colRenderIndex):i.col.cellClass,t.addClass(n)}r.addClass(o),i.col.cellClass&&a();var e=i.grid.registerDataChangeCallback(a,[s.dataChange.COLUMN,s.dataChange.EDIT]);var t=i.$watch("row",function(e,t){e!==t&&((n||i.col.cellClass)&&a(),(e=i.col.getColClass(!1))!==o)&&(r.removeClass(o),r.addClass(e),o=e)});function l(){e(),t()}i.$on("$destroy",l),r.on("$destroy",l)}}}}}]),angular.module("ui.grid").service("uiGridColumnMenuService",["i18nService","uiGridConstants","gridUtil",function(e,i,d){var r={initialize:function(e,t){e.grid=t.grid,(t.columnMenuScope=e).menuShown=!1},setColMenuItemWatch:function(t){var e=t.$watch("col.menuItems",function(e){void 0!==e&&e&&angular.isArray(e)?(e.forEach(function(e){void 0!==e.context&&e.context||(e.context={}),e.context.col=t.col}),t.menuItems=t.defaultMenuItems.concat(e)):t.menuItems=t.defaultMenuItems});t.$on("$destroy",e)},getGridOption:function(e,t){return void 0!==e.grid&&e.grid&&e.grid.options&&e.grid.options[t]},sortable:function(e){return Boolean(this.getGridOption(e,"enableSorting")&&void 0!==e.col&&e.col&&e.col.enableSorting)},isActiveSort:function(e,t){return Boolean(void 0!==e.col&&void 0!==e.col.sort&&void 0!==e.col.sort.direction&&e.col.sort.direction===t)},suppressRemoveSort:function(e){return Boolean(e.col&&e.col.suppressRemoveSort)},hideable:function(e){return Boolean(this.getGridOption(e,"enableHiding")&&void 0!==e.col&&e.col&&(e.col.colDef&&!1!==e.col.colDef.enableHiding||!e.col.colDef)||!this.getGridOption(e,"enableHiding")&&e.col&&e.col.colDef&&e.col.colDef.enableHiding)},getDefaultMenuItems:function(t){return[{title:function(){return e.getSafeText("sort.ascending")},icon:"ui-grid-icon-sort-alt-up",action:function(e){e.stopPropagation(),t.sortColumn(e,i.ASC)},shown:function(){return r.sortable(t)},active:function(){return r.isActiveSort(t,i.ASC)}},{title:function(){return e.getSafeText("sort.descending")},icon:"ui-grid-icon-sort-alt-down",action:function(e){e.stopPropagation(),t.sortColumn(e,i.DESC)},shown:function(){return r.sortable(t)},active:function(){return r.isActiveSort(t,i.DESC)}},{title:function(){return e.getSafeText("sort.remove")},icon:"ui-grid-icon-cancel",action:function(e){e.stopPropagation(),t.unsortColumn()},shown:function(){return r.sortable(t)&&void 0!==t.col&&void 0!==t.col.sort&&void 0!==t.col.sort.direction&&null!==t.col.sort.direction&&!r.suppressRemoveSort(t)}},{title:function(){return e.getSafeText("column.hide")},icon:"ui-grid-icon-cancel",shown:function(){return r.hideable(t)},action:function(e){e.stopPropagation(),t.hideColumn()}}]},getColumnElementPosition:function(e,t,i){var r={};return r.left=i[0].offsetLeft,r.top=i[0].offsetTop,r.parentLeft=i[0].offsetParent.offsetLeft,r.offset=0,t.grid.options.offsetLeft&&(r.offset=t.grid.options.offsetLeft),r.height=d.elementHeight(i,!0),r.width=d.elementWidth(i,!0),r},repositionMenu:function(e,t,i,r,n){var o=r[0].querySelectorAll(".ui-grid-menu"),n=d.closestElm(n,".ui-grid-render-container"),a=n.getBoundingClientRect().left-e.grid.element[0].getBoundingClientRect().left,n=n.querySelectorAll(".ui-grid-viewport")[0].scrollLeft,l=d.elementWidth(o,!0),s=t.lastMenuPaddingRight||e.lastMenuPaddingRight||10,o=(0!==o.length&&0!==o[0].querySelectorAll(".ui-grid-menu-mid").length&&(s=parseInt(d.getStyles(angular.element(o)[0]).paddingRight,10),e.lastMenuPaddingRight=s,t.lastMenuPaddingRight=s),i.left+a-n+i.parentLeft+i.width+s);o<i.offset+l&&(o=Math.max(i.left-n+i.parentLeft-s+l,i.offset+l)),r.css("left",o+"px"),r.css("top",i.top+i.height+"px")}};return r}]).directive("uiGridColumnMenu",["$timeout","gridUtil","uiGridConstants","uiGridColumnMenuService","$document",function(n,a,l,s,d){return{priority:0,scope:!0,require:"^uiGrid",templateUrl:"ui-grid/uiGridColumnMenu",replace:!0,link:function(o,i,e,t){function r(e){o.col&&(o.col.menuShown=e)}s.initialize(o,t),o.defaultMenuItems=s.getDefaultMenuItems(o),o.menuItems=o.defaultMenuItems,s.setColMenuItemWatch(o),o.showMenu=function(e,t,i){r(!1),o.col=e,r(!0);e=s.getColumnElementPosition(o,e,t);o.menuShown?(o.colElement=t,o.colElementPosition=e,o.hideThenShow=!0,o.$broadcast("hide-menu",{originalEvent:i})):(o.menuShown=!0,o.colElement=t,o.colElementPosition=e,o.$broadcast("show-menu",{originalEvent:i}))},o.hideMenu=function(e){o.menuShown=!1,r(!1),e||o.$broadcast("hide-menu")},o.$on("menu-hidden",function(){var e=angular.element(i[0].querySelector(".ui-grid-menu-items"))[0];i[0].removeAttribute("style"),o.hideThenShow?(delete o.hideThenShow,o.$broadcast("show-menu"),o.menuShown=!0):(o.hideMenu(!0),o.col&&o.col.visible&&a.focus.bySelector(d,".ui-grid-header-cell."+o.col.getColClass()+" .ui-grid-column-menu-button",o.col.grid,!1).catch(angular.noop)),e&&(e.onkeydown=null,angular.forEach(e.children,function(e){e.onkeydown=null}))}),o.$on("menu-shown",function(){n(function(){var e,n;function t(e,t,i,r){e.keyCode===l.keymap.TAB&&(t?e.preventDefault():i&&(e.preventDefault(),n[r].focus()))}s.repositionMenu(o,o.col,o.colElementPosition,i,o.colElement),o.menuItems.some(function(e){return e.shown()})&&a.focus.bySelector(d,".ui-grid-menu-items .ui-grid-menu-item:not(.ng-hide)",!0).catch(angular.noop),delete o.colElementPosition,delete o.columnElement,e=angular.element(i[0].querySelector(".ui-grid-menu-items"))[0],n=[],e&&(e.onkeydown=function(e){e.keyCode===l.keymap.ESC&&(e.preventDefault(),o.hideMenu())},e=e.querySelectorAll(".ui-grid-menu-item:not(.ng-hide)"),angular.forEach(e,function(e){null!==e.offsetParent&&this.push(e)},n),n.length)&&(1===n.length?n[0].onkeydown=function(e){t(e,!0)}:(n[0].onkeydown=function(e){t(e,!1,e.shiftKey,n.length-1)},n[n.length-1].onkeydown=function(e){t(e,!1,!e.shiftKey,0)}))})}),o.sortColumn=function(e,t){e.stopPropagation(),o.grid.sortColumn(o.col,t,!0).then(function(){o.grid.refresh(),o.hideMenu()}).catch(angular.noop)},o.unsortColumn=function(){o.col.unsort(),o.grid.refresh(),o.hideMenu()};o.hideColumn=function(){o.col.colDef.visible=!1,o.col.visible=!1,o.grid.queueGridRefresh(),o.hideMenu(),o.grid.api.core.notifyDataChange(l.dataChange.COLUMN),o.grid.api.core.raise.columnVisibilityChanged(o.col),n(function(){function t(){return a.focus.byId("grid-menu",o.grid)}var i,r,e;o.grid.columns.some(function(e,t){if(angular.equals(e,o.col))return i=t,!0}),o.grid.columns.some(function(e,t){return!!e.visible&&(t<i?void(r=e):i<t&&!r?(r=e,!0):!!(i<t&&r)||void 0)}),r?(e=r.getColClass(),a.focus.bySelector(d,".ui-grid-header-cell."+e+" .ui-grid-header-cell-primary-focus",!0).then(angular.noop,function(e){if("canceled"!==e)return t()}).catch(angular.noop)):t()})}},controller:["$scope",function(e){var t=this;e.$watch("menuItems",function(e){t.menuItems=e})}]}}]),function(){"use strict";angular.module("ui.grid").directive("uiGridFilter",["$compile","$templateCache","i18nService","gridUtil",function(n,e,t,r){return{compile:function(){return{pre:function(i,r){i.col.updateFilters=function(e){var t;r.children().remove(),e&&(void 0===(t=i.col.filterHeaderTemplate)&&""!==i.col.providedFilterHeaderTemplate?i.col.filterHeaderTemplatePromise&&i.col.filterHeaderTemplatePromise.then(function(){t=i.col.filterHeaderTemplate,r.append(n(t)(i))}):r.append(n(t)(i)))},i.$on("$destroy",function(){delete i.col.filterable,delete i.col.updateFilters})},post:function(e,i){e.aria=t.getSafeText("headerCell.aria"),e.removeFilter=function(e,t){e.term=null,r.focus.bySelector(i,".ui-grid-filter-input-"+t)}}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridFooterCell",["$timeout","gridUtil","uiGridConstants","$compile",function(e,t,a,r){return{priority:0,scope:{col:"=",row:"=",renderIndex:"="},replace:!0,require:"^uiGrid",compile:function(){return{pre:function(e,t){var i=e.col.footerCellTemplate;void 0===i&&""!==e.col.providedFooterCellTemplate?e.col.footerCellTemplatePromise&&e.col.footerCellTemplatePromise.then(function(){i=e.col.footerCellTemplate,t.append(r(i)(e))}):t.append(r(i)(e))},post:function(t,i,e,r){t.grid=r.grid;function n(){var e=i;o&&(e.removeClass(o),o=null),o=angular.isFunction(t.col.footerCellClass)?t.col.footerCellClass(t.grid,t.row,t.col,t.rowRenderIndex,t.colRenderIndex):t.col.footerCellClass,e.addClass(o)}var o,r=t.col.getColClass(!1),r=(i.addClass(r),t.col.footerCellClass&&n(),t.col.updateAggregationValue(),t.grid.registerDataChangeCallback(n,[a.dataChange.COLUMN]));t.grid.api.core.on.rowsRendered(t,t.col.updateAggregationValue),t.grid.api.core.on.rowsRendered(t,n),t.$on("$destroy",r)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridFooter",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout",function(e,a,t,l,i){return{restrict:"EA",replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:!0,compile:function(e,t){return{pre:function(t,i,e,r){var n=r[0],o=r[1],r=(t.grid=n.grid,t.colContainer=o.colContainer,o.footer=i,t.grid.options.footerTemplate);l.getTemplate(r).then(function(e){var e=angular.element(e),e=a(e)(t);i.append(e),o&&(e=i[0].getElementsByClassName("ui-grid-footer-viewport")[0])&&(o.footerViewport=e)}).catch(angular.noop)},post:function(e,t,i,r){var n=r[0],r=r[1],n=(n.grid,l.disableAnimations(t),(r.footer=t)[0].getElementsByClassName("ui-grid-footer-viewport")[0]);n&&(r.footerViewport=n)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridGridFooter",["$templateCache","$compile","uiGridConstants","gridUtil",function(e,n,t,o){return{restrict:"EA",replace:!0,require:"^uiGrid",scope:!0,compile:function(){return{pre:function(t,i,e,r){t.grid=r.grid;r=t.grid.options.gridFooterTemplate;o.getTemplate(r).then(function(e){e=angular.element(e),e=n(e)(t);i.append(e)}).catch(angular.noop)}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridHeaderCell",["$compile","$timeout","$window","$document","gridUtil","uiGridConstants","ScrollEvent","i18nService","$rootScope",function(r,u,e,g,t,p,i,f,m){return{priority:0,scope:{col:"=",row:"=",renderIndex:"="},require:["^uiGrid","^uiGridRenderContainer"],replace:!0,compile:function(){return{pre:function(e,t){var i=e.col.headerCellTemplate;void 0===i&&""!==e.col.providedHeaderCellTemplate?e.col.headerCellTemplatePromise&&e.col.headerCellTemplatePromise.then(function(){i=e.col.headerCellTemplate,t.append(r(i)(e))}):t.append(r(i)(e))},post:function(i,t,e,r){function n(e){e&&(void 0!==i.col.updateFilters&&i.col.updateFilters(i.col.filterable),i.col.filterable?(i.col.filters.forEach(function(e,t){c.push(i.$watch("col.filters["+t+"].term",function(e,t){e!==t&&(s.grid.api.core.raise.filterChanged(i.col),s.grid.api.core.notifyDataChange(p.dataChange.COLUMN),s.grid.queueGridRefresh())}))}),i.$on("$destroy",function(){c.forEach(function(e){e()})})):c.forEach(function(e){e()}))}function o(){var e=t,e=(a&&(e.removeClass(a),a=null),a=angular.isFunction(i.col.headerCellClass)?i.col.headerCellClass(i.grid,i.row,i.col,i.rowRenderIndex,i.colRenderIndex):i.col.headerCellClass,e.addClass(a),i.$applyAsync(function(){var e=i.grid.renderContainers.right&&i.grid.renderContainers.right.visibleColumnCache.length?i.grid.renderContainers.right:i.grid.renderContainers.body;i.isLastCol=s.grid.options&&s.grid.options.enableGridMenu&&i.col===e.visibleColumnCache[e.visibleColumnCache.length-1]}),i.sortable=Boolean(i.col.enableSorting),i.col.filterable);i.col.filterable=Boolean(s.grid.options.enableFiltering&&i.col.enableFiltering),n(e!==i.col.filterable),i.colMenu=i.col.grid.options&&!1!==i.col.grid.options.enableColumnMenus&&i.col.colDef&&!1!==i.col.colDef.enableColumnMenu,i.offAllEvents(),(i.sortable||i.colMenu)&&(i.onDownEvents(),i.$on("$destroy",function(){i.offAllEvents()}))}var a,l,s=r[0],r=r[1],r=(i.i18n={headerCell:f.getSafeText("headerCell"),sort:f.getSafeText("sort")},i.isSortPriorityVisible=function(){return i.col&&i.col.sort&&angular.isNumber(i.col.sort.priority)&&i.grid.columns.some(function(e,t){return angular.isNumber(e.sort.priority)&&e!==i.col})},i.getSortDirectionAriaLabel=function(){var e=i.col,t=e.sort&&e.sort.direction===p.ASC?i.i18n.sort.ascending:e.sort&&e.sort.direction===p.DESC?i.i18n.sort.descending:i.i18n.sort.none;return t=i.isSortPriorityVisible()?t+". "+i.i18n.headerCell.priority+" "+(e.sort.priority+1):t},i.grid=s.grid,i.renderContainer=s.grid.renderContainers[r.containerId],i.col.getColClass(!1)),d=(t.addClass(r),i.menuShown=!1,i.col.menuShown=!1,i.asc=p.ASC,i.desc=p.DESC,angular.element(t[0].querySelectorAll(".ui-grid-cell-contents"))),c=[],r=(i.downFn=function(e){e.stopPropagation(),(e=void 0!==e.originalEvent&&void 0!==e.originalEvent?e.originalEvent:e).button&&0!==e.button||(l=e.pageX,i.mousedownStartTime=(new Date).getTime(),i.mousedownTimeout=u(function(){},500),i.mousedownTimeout.then(function(){i.colMenu&&s.columnMenuScope.showMenu(i.col,t,e)}).catch(angular.noop),s.fireEvent(p.events.COLUMN_HEADER_CLICK,{event:e,columnName:i.col.colDef.name}),i.offAllEvents(),"touchstart"===e.type?(g.on("touchend",i.upFn),g.on("touchmove",i.moveFn)):"mousedown"===e.type&&(g.on("mouseup",i.upFn),g.on("mousemove",i.moveFn)))},i.upFn=function(e){e.stopPropagation(),u.cancel(i.mousedownTimeout),i.offAllEvents(),i.onDownEvents(e.type),500<(new Date).getTime()-i.mousedownStartTime||i.sortable&&i.handleClick(e)},i.handleKeyDown=function(e){32!==e.keyCode&&13!==e.keyCode||(e.preventDefault(),i.handleClick(e))},i.moveFn=function(e){0!=e.pageX-l&&(u.cancel(i.mousedownTimeout),i.offAllEvents(),i.onDownEvents(e.type))},i.clickFn=function(e){e.stopPropagation(),d.off("click",i.clickFn)},i.offAllEvents=function(){d.off("touchstart",i.downFn),d.off("mousedown",i.downFn),g.off("touchend",i.upFn),g.off("mouseup",i.upFn),g.off("touchmove",i.moveFn),g.off("mousemove",i.moveFn),d.off("click",i.clickFn)},i.onDownEvents=function(e){switch(e){case"touchmove":case"touchend":d.on("click",i.clickFn),d.on("touchstart",i.downFn),u(function(){d.on("mousedown",i.downFn)},500);break;case"mousemove":case"mouseup":d.on("click",i.clickFn),d.on("mousedown",i.downFn),u(function(){d.on("touchstart",i.downFn)},500);break;default:d.on("click",i.clickFn),d.on("touchstart",i.downFn),d.on("mousedown",i.downFn)}},o(),"columnMenu"===i.col.filterContainer&&i.col.filterable&&m.$on("menu-shown",function(){i.$applyAsync(function(){n(i.col.filterable)})}),i.grid.registerDataChangeCallback(o,[p.dataChange.COLUMN]));i.$on("$destroy",r),i.handleClick=function(e){s.grid.sortColumn(i.col,e.shiftKey).then(function(){s.columnMenuScope&&s.columnMenuScope.hideMenu(),s.grid.refresh()}).catch(angular.noop)},i.headerCellArrowKeyDown=function(e){e.keyCode!==p.keymap.SPACE&&e.keyCode!==p.keymap.ENTER||(e.preventDefault(),i.toggleMenu(e))},i.toggleMenu=function(e){e.stopPropagation(),s.columnMenuScope.menuShown&&s.columnMenuScope.col===i.col?s.columnMenuScope.hideMenu():s.columnMenuScope.showMenu(i.col,t)}}}}}}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridHeader",["$templateCache","$compile","uiGridConstants","gridUtil","$timeout","ScrollEvent",function(e,s,t,d,i,c){return{restrict:"EA",replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:!0,compile:function(){return{pre:function(i,r,e,t){var n=t[0],o=t[1];function a(){var e=(o.header=o.colContainer.header=r)[0].getElementsByClassName("ui-grid-header-canvas");0<e.length?o.headerCanvas=o.colContainer.headerCanvas=e[0]:o.headerCanvas=null}function l(){var e,t,i;n.grid.isScrollingHorizontally||(e=d.normalizeScrollLeft(o.headerViewport,n.grid),t=o.colContainer.scrollHorizontal(e),(i=new c(n.grid,null,o.colContainer,c.Sources.ViewPortScroll)).newScrollLeft=e,-1<t&&(i.x={percentage:t}),n.grid.scrollContainers(null,i))}i.grid=n.grid,i.colContainer=o.colContainer,a(),t=i.grid.options.showHeader?i.grid.options.headerTemplate||"ui-grid/ui-grid-header":"ui-grid/ui-grid-no-header",d.getTemplate(t).then(function(e){var t,e=angular.element(e),e=s(e)(i);r.replaceWith(e),r=e,a(),o&&(t=r[0].getElementsByClassName("ui-grid-header-viewport")[0])&&(o.headerViewport=t,angular.element(t).on("scroll",l),i.$on("$destroy",function(){angular.element(t).off("scroll",l)})),i.grid.queueRefresh()}).catch(angular.noop)},post:function(e,t,i,r){var n=r[0],o=r[1];n.grid;d.disableAnimations(t);r=(o.header=t)[0].getElementsByClassName("ui-grid-header-viewport")[0];r&&(o.headerViewport=r),n&&n.grid.registerStyleComputation({priority:15,func:function(){var e=o.colContainer.visibleColumnCache,t="",i=0;return e.forEach(function(e){t+=e.getColClassDefinition(),i+=e.drawnWidth}),o.colContainer.canvasWidth=i,t}})}}}}}])}(),angular.module("ui.grid").service("uiGridGridMenuService",["gridUtil","i18nService","uiGridConstants",function(n,o,t){var a={initialize:function(e,t){(t.gridMenuScope=e).grid=t,e.registeredMenuItems=[],e.$on("$destroy",function(){e.grid&&e.grid.gridMenuScope&&(e.grid.gridMenuScope=null),e.grid&&(e.grid=null),e.registeredMenuItems&&(e.registeredMenuItems=null)}),e.registeredMenuItems=[],t.api.registerMethod("core","addToGridMenu",a.addToGridMenu),t.api.registerMethod("core","removeFromGridMenu",a.removeFromGridMenu)},addToGridMenu:function(e,t){angular.isArray(t)?e.gridMenuScope?(e.gridMenuScope.registeredMenuItems=e.gridMenuScope.registeredMenuItems||[],e.gridMenuScope.registeredMenuItems=e.gridMenuScope.registeredMenuItems.concat(t)):n.logError("Asked to addToGridMenu, but gridMenuScope not present.  Timing issue?  Please log issue with ui-grid"):n.logError("addToGridMenu: menuItems must be an array, and is not, not adding any items")},removeFromGridMenu:function(e,i){var r=-1;e&&e.gridMenuScope&&e.gridMenuScope.registeredMenuItems.forEach(function(e,t){e.id===i&&(-1<r?n.logError("removeFromGridMenu: found multiple items with the same id, removing only the last"):r=t)}),-1<r&&e.gridMenuScope.registeredMenuItems.splice(r,1)},getMenuItems:function(t){var e=[],i=(t.grid.options.gridMenuCustomItems&&(angular.isArray(t.grid.options.gridMenuCustomItems)?e=e.concat(t.grid.options.gridMenuCustomItems):n.logError("gridOptions.gridMenuCustomItems must be an array, and is not")),[{title:o.getSafeText("gridMenu.clearAllFilters"),action:function(e){t.grid.clearAllFilters()},shown:function(){return t.grid.options.enableFiltering},order:100}]);return e=(e=e.concat(i)).concat(t.registeredMenuItems),(e=!1!==t.grid.options.gridMenuShowHideColumns?e.concat(a.showHideColumns(t)):e).sort(function(e,t){return e.order-t.order}),e},showHideColumns:function(i){var r=[];return i.grid.options.columnDefs&&0!==i.grid.options.columnDefs.length&&0!==i.grid.columns.length&&(i.grid.options.gridMenuTitleFilter=i.grid.options.gridMenuTitleFilter||function(e){return e},i.grid.options.columnDefs.forEach(function(e,t){(!1!==i.grid.options.enableHiding&&!1!==e.enableHiding||e.enableHiding)&&(t={icon:n(e),action:function(e){e.stopPropagation(),a.toggleColumnVisibility(this.context.gridCol),e.target&&e.target.firstChild&&("I"===angular.element(e.target)[0].nodeName?e.target.className=n(this.context.gridCol.colDef):e.target.firstChild.className=n(this.context.gridCol.colDef))},shown:function(){return!1!==this.context.gridCol.colDef.enableHiding},context:{gridCol:i.grid.getColumn(e.name||e.field)},leaveOpen:!0,order:301+t},a.setMenuItemTitle(t,e,i.grid),r.push(t))}),r.length)&&r.unshift({title:o.getSafeText("gridMenu.columns"),order:300,templateUrl:"ui-grid/ui-grid-menu-header-item"}),r;function n(e){return!0===(e=e).visible||void 0===e.visible?"ui-grid-icon-ok":"ui-grid-icon-cancel"}},setMenuItemTitle:function(t,e,i){i=i.options.gridMenuTitleFilter(e.displayName||n.readableColumnName(e.name)||e.field);"string"==typeof i?t.title=i:i.then?(t.title="",i.then(function(e){t.title=e},function(e){t.title=e}).catch(angular.noop)):(n.logError("Expected gridMenuTitleFilter to return a string or a promise, it has returned neither, bad config"),t.title="badconfig")},toggleColumnVisibility:function(e){e.colDef.visible=!(!0===e.colDef.visible||void 0===e.colDef.visible),e.grid.refresh(),e.grid.api.core.notifyDataChange(t.dataChange.COLUMN),e.grid.api.core.raise.columnVisibilityChanged(e)}};return a}]).directive("uiGridMenuButton",["gridUtil","uiGridConstants","uiGridGridMenuService","i18nService",function(n,o,a,l){return{priority:0,scope:!0,require:["^uiGrid"],templateUrl:"ui-grid/ui-grid-menu-button",replace:!0,link:function(t,e,i,r){r=r[0];t.i18n={aria:l.getSafeText("gridMenu.aria")},a.initialize(t,r.grid),t.shown=!1,t.toggleOnKeydown=function(e){(e.keyCode===o.keymap.ENTER||e.keyCode===o.keymap.SPACE||e.keyCode===o.keymap.ESC&&t.shown)&&t.toggleMenu()},t.toggleMenu=function(){t.shown?(t.$broadcast("hide-menu"),t.shown=!1):(t.menuItems=a.getMenuItems(t),t.$broadcast("show-menu"),t.shown=!0)},t.$on("menu-hidden",function(){t.shown=!1,n.focus.bySelector(e,".ui-grid-icon-container")})}}}]),angular.module("ui.grid").directive("uiGridMenu",["$compile","$timeout","$window","$document","gridUtil","uiGridConstants","i18nService",function(l,s,d,e,c,u,g){return{priority:0,scope:{menuItems:"=",autoHide:"=?",col:"=?"},require:"?^uiGrid",templateUrl:"ui-grid/uiGridMenu",replace:!1,link:function(n,o,e,i){function a(e){e=e-i.grid.headerHeight-20,n.dynamicStyles=[".grid"+i.grid.id+" .ui-grid-menu-mid {","max-height: "+e+"px;","}"].join(" ")}n.dynamicStyles="",i&&i.grid&&i.grid.options&&i.grid.options.gridMenuTemplate&&(t=i.grid.options.gridMenuTemplate,c.getTemplate(t).then(function(e){e=angular.element(e),e=l(e)(n);o.replaceWith(e)}).catch(angular.noop));i&&(a(i.grid.gridHeight),i.grid.api.core.on.gridDimensionChanged(n,function(e,t,i,r){a(i)})),n.i18n={close:g.getSafeText("columnMenu.close")},n.showMenu=function(e,t){n.shown?n.shownMid||(n.shownMid=!0,n.$emit("menu-shown")):(n.shown=!0,s(function(){n.shownMid=!0,n.$emit("menu-shown")}));var i="click";t&&t.originalEvent&&t.originalEvent.type&&"touchstart"===t.originalEvent.type&&(i=t.originalEvent.type),angular.element(document).off("click touchstart",r),s(function(){angular.element(document).on(i,r)})},n.hideMenu=function(e){n.shown&&(n.shownMid=!1,s(function(){n.shownMid||(n.shown=!1,n.$emit("menu-hidden"))},40)),angular.element(document).off("click touchstart",r)},n.$on("hide-menu",function(e,t){n.hideMenu(e,t)}),n.$on("show-menu",function(e,t){n.showMenu(e,t)});var t,r=function(e){if(n.shown){var t=i&&i.grid&&i.grid.options?i.grid.options.disableGridMenuHideOnScroll:null;if("scroll"!==e.type||!t){if(n.col&&"columnMenu"===n.col.filterContainer){t=document.querySelector(".ui-grid-column-menu").querySelector("[ui-grid-filter]");if(t&&t.contains(e.target))return!1}n.$apply(function(){n.hideMenu()})}}};n.checkKeyDown=function(t){function e(e){e.focus(),t.preventDefault()}var i,r;t.keyCode===u.keymap.ESC?n.hideMenu():t.keyCode===u.keymap.TAB&&0<(r=o[0].querySelectorAll("button:not(.ng-hide)")).length&&(i=r[0],r=r[r.length-1],t.target.parentElement.id!==r.parentElement.id||t.shiftKey?t.target.parentElement.id===i.parentElement.id&&t.shiftKey&&e(r):e(i))},void 0!==n.autoHide&&void 0!==n.autoHide||(n.autoHide=!0),n.autoHide&&angular.element(d).on("resize",r),n.$on("$destroy",function(){angular.element(d).off("resize",r),angular.element(document).off("click touchstart",r)}),i&&n.$on("$destroy",i.grid.api.core.on.scrollBegin(n,r)),n.$on("$destroy",n.$on(u.events.ITEM_DRAGGING,r))}}}]).directive("uiGridMenuItem",["gridUtil","$compile","i18nService",function(o,r,a){return{priority:0,scope:{name:"=",active:"=",action:"=",icon:"=",shown:"=",context:"=",templateUrl:"=",leaveOpen:"=",screenReaderOnly:"="},require:["?^uiGrid"],templateUrl:"ui-grid/uiGridMenuItem",replace:!1,compile:function(){return{pre:function(t,i){t.templateUrl&&o.getTemplate(t.templateUrl).then(function(e){e=angular.element(e),e=r(e)(t);i.replaceWith(e)}).catch(angular.noop)},post:function(r,e,t,i){var n=i[0];void 0!==r.shown&&null!==r.shown||(r.shown=function(){return!0}),r.itemShown=function(){var e={};return r.context&&(e.context=r.context),void 0!==n&&n&&(e.grid=n.grid),r.shown.call(e)},r.itemAction=function(e,t){var i;e.stopPropagation(),"function"==typeof r.action&&(i={},r.context&&(i.context=r.context),void 0!==n&&n&&(i.grid=n.grid),r.action.call(i,e,t),r.leaveOpen?(i=e.target.parentElement,"I"===angular.element(e.target)[0].nodeName&&(i=i.parentElement),o.focus.bySelector(i,"button[type=button]",!0)):r.$emit("hide-menu"))},r.label=function(){var e=r.name;return e="function"==typeof r.name?r.name.call():e},r.i18n=a.get()}}}}}]),function(){"use strict";var t=angular.module("ui.grid");angular.forEach([{tag:"Src",method:"attr"},{tag:"Text",method:"text"},{tag:"Href",method:"attr"},{tag:"Class",method:"addClass"},{tag:"Html",method:"html"},{tag:"Alt",method:"attr"},{tag:"Style",method:"css"},{tag:"Value",method:"attr"},{tag:"Id",method:"attr"},{tag:"Id",directiveName:"IdGrid",method:"attr",appendGridId:!0},{tag:"Title",method:"attr"},{tag:"Label",method:"attr",aria:!0},{tag:"Labelledby",method:"attr",aria:!0},{tag:"Labelledby",directiveName:"LabelledbyGrid",appendGridId:!0,method:"attr",aria:!0},{tag:"Describedby",method:"attr",aria:!0},{tag:"Describedby",directiveName:"DescribedbyGrid",appendGridId:!0,method:"attr",aria:!0}],function(d){var e="uiGridOneBind",c=(d.aria?e+"Aria":e)+(d.directiveName||d.tag);t.directive(c,["gridUtil",function(s){return{restrict:"A",require:["?uiGrid","?^uiGrid"],link:function(n,o,e,a){var l=n.$watch(e[c],function(e){if(e){var t;switch(d.appendGridId&&(t=null,angular.forEach(e.split(" "),function(e){t=(t?t+" ":"")+function(e){var t;if(n.grid)t=n.grid;else if(n.col&&n.col.grid)t=n.col.grid;else if(!a.some(function(e){if(e&&e.grid)return t=e.grid,!0}))throw s.logError("["+c+"] A valid grid could not be found to bind id. Are you using this directive within the correct scope? Trying to generate id: [gridID]-"+e),new Error("No valid grid could be found");return e=t&&!new RegExp(t.id.toString()).test(e)?t.id.toString()+"-"+e:e}(e)}),e=t),d.method){case"attr":d.aria?o[d.method]("aria-"+d.tag.toLowerCase(),e):o[d.method](d.tag.toLowerCase(),e);break;case"addClass":if(angular.isObject(e)&&!angular.isArray(e)){var i=[],r=!1;if(angular.forEach(e,function(e,t){null!=e&&(r=!0,e)&&i.push(t)}),!r)return;e=i}if(!e)return;o.addClass(angular.isArray(e)?e.join(" "):e);break;default:o[d.method](e)}l()}},!0)}}}])})}(),function(){"use strict";var e=angular.module("ui.grid");e.directive("uiGridRenderContainer",["$timeout","$document","uiGridConstants","gridUtil","ScrollEvent",function(e,t,i,p,f){return{replace:!0,transclude:!0,templateUrl:"ui-grid/uiGridRenderContainer",require:["^uiGrid","uiGridRenderContainer"],scope:{containerId:"=",rowContainerName:"=",colContainerName:"=",bindScrollHorizontal:"=",bindScrollVertical:"=",enableVerticalScrollbar:"=",enableHorizontalScrollbar:"="},controller:"uiGridRenderContainer as RenderContainer",compile:function(){return{pre:function(e,t,i,r){var n,o=r[0],r=r[1],o=e.grid=o.grid;if(!e.rowContainerName)throw new Error("No row render container name specified");if(!e.colContainerName)throw new Error("No column render container name specified");if(!o.renderContainers[e.rowContainerName])throw new Error('Row render container "'+e.rowContainerName+'" is not registered.');if(!o.renderContainers[e.colContainerName])throw new Error('Column render container "'+e.colContainerName+'" is not registered.');n=e.rowContainer=o.renderContainers[e.rowContainerName],o=e.colContainer=o.renderContainers[e.colContainerName],r.containerId=e.containerId,r.rowContainer=n,r.colContainer=o},post:function(l,t,e,i){var s=i[0],n=i[1],d=s.grid,c=n.rowContainer,u=n.colContainer,o=null,a=null,g=d.renderContainers[l.containerId];t.addClass("ui-grid-render-container-"+l.containerId),p.on.mousewheel(t,function(e){var t,i,r=new f(d,c,u,f.Sources.RenderContainerMouseWheel);0!==e.deltaY&&(i=-1*e.deltaY*e.deltaFactor,o=n.viewport[0].scrollTop,r.verticalScrollLength=c.getVerticalScrollLength(),1<=(t=(o+i)/r.verticalScrollLength)&&o<r.verticalScrollLength&&(n.viewport[0].scrollTop=r.verticalScrollLength),t<0?t=0:1<t&&(t=1),r.y={percentage:t,pixels:i}),0!==e.deltaX&&(t=e.deltaX*e.deltaFactor,a=p.normalizeScrollLeft(n.viewport,d),r.horizontalScrollLength=u.getCanvasWidth()-u.getViewportWidth(),(i=(a+t)/r.horizontalScrollLength)<0?i=0:1<i&&(i=1),r.x={percentage:i,pixels:t}),0!==e.deltaY&&(r.atTop(o)||r.atBottom(o))||0!==e.deltaX&&(r.atLeft(a)||r.atRight(a))||(e.preventDefault(),e.stopPropagation(),r.fireThrottledScrollingEvent("",r))}),t.bind("$destroy",function(){t.unbind("keydown"),["touchstart","touchmove","touchend","keydown","wheel","mousewheel","DomMouseScroll","MozMousePixelScroll"].forEach(function(e){t.unbind(e)})}),s.grid.registerStyleComputation({priority:6,func:function(){var e,t,i="",r=u.canvasWidth,n=u.getViewportWidth(),o=c.getCanvasHeight(),a=c.getViewportHeight();return u.needsHScrollbarPlaceholder()&&(a-=d.scrollbarHeight),e=t=u.getHeaderViewportWidth(),i=(i+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-canvas { width: "+r+"px; height: "+o+"px; }")+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-header-canvas { width: "+(r+d.scrollbarWidth)+"px; }"),g.explicitHeaderCanvasHeight?((o=document.querySelector(".grid"+s.grid.id+" .ui-grid-render-container-body .ui-grid-header-canvas"))&&(g.explicitHeaderCanvasHeight=o.offsetHeight),i+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-header-canvas { height: "+g.explicitHeaderCanvasHeight+"px; }"):i+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-header-canvas { height: inherit; }",i=(i=(i=(i+="\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-viewport { width: "+n+"px; height: "+a+"px; }")+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-header-viewport { width: "+e+"px; }"))+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-footer-canvas { width: "+(r+d.scrollbarWidth)+"px; }"))+("\n .grid"+s.grid.id+" .ui-grid-render-container-"+l.containerId+" .ui-grid-footer-viewport { width: "+t+"px; }")}})}}}}}]),e.controller("uiGridRenderContainer",["$scope","gridUtil",function(e,t){}])}(),function(){"use strict";angular.module("ui.grid").directive("uiGridRow",function(){return{replace:!0,require:["^uiGrid","^uiGridRenderContainer"],scope:{row:"=uiGridRow",rowRenderIndex:"="},compile:function(){return{pre:function(t,r,e,i){var n,o,a=i[0],i=i[1];function l(){t.row.getRowTemplateFn.then(function(e){var i=t.$new();e(i,function(e,t){n&&(n.remove(),o.$destroy()),r.empty().append(e),n=e,o=i})}).catch(angular.noop)}t.grid=a.grid,t.colContainer=i.colContainer,l(),t.$watch("row.getRowTemplateFn",function(e,t){e!==t&&l()})},post:function(e,t){e.row.element=t}}}}})}(),angular.module("ui.grid").directive("uiGridStyle",["gridUtil","$interpolate",function(e,r){return{link:function(e,i){var t=r(i.text(),!0);t&&e.$watch(t,function(e){for(var t=0;t<i.length;t++)i[t].textContent=e})}}}]),function(){"use strict";angular.module("ui.grid").directive("uiGridViewport",["gridUtil","ScrollEvent",function(c,u){return{replace:!0,scope:{},controllerAs:"Viewport",templateUrl:"ui-grid/uiGridViewport",require:["^uiGrid","^uiGridRenderContainer"],link:function(o,a,e,t){var i=t[0],r=t[1],l=(o.containerCtrl=r).rowContainer,s=r.colContainer,d=i.grid;o.grid=i.grid,o.rowContainer=r.rowContainer,o.colContainer=r.colContainer,r.viewport=a,d&&d.options&&d.options.customScroller?d.options.customScroller(a,n):a.on("scroll",n);function n(){var e=a[0].scrollTop,t=c.normalizeScrollLeft(a,d),i=l.scrollVertical(e),r=s.scrollHorizontal(t),n=new u(d,l,s,u.Sources.ViewPortScroll);n.newScrollLeft=t,n.newScrollTop=e,-1<r&&(n.x={percentage:r}),-1<i&&(n.y={percentage:i}),d.scrollContainers(o.$parent.containerId,n)}o.$parent.bindScrollVertical&&d.addVerticalScrollSync(o.$parent.containerId,function(e){r.prevScrollArgs=e,a[0].scrollTop=e.getNewScrollTop(l,r.viewport)}),o.$parent.bindScrollHorizontal&&(d.addHorizontalScrollSync(o.$parent.containerId,function(e){e=(r.prevScrollArgs=e).getNewScrollLeft(s,r.viewport);a[0].scrollLeft=c.denormalizeScrollLeft(r.viewport,e,d)}),d.addHorizontalScrollSync(o.$parent.containerId+"header",function(e){e=e.getNewScrollLeft(s,r.viewport);r.headerViewport&&(r.headerViewport.scrollLeft=c.denormalizeScrollLeft(r.viewport,e,d))}),d.addHorizontalScrollSync(o.$parent.containerId+"footer",function(e){e=e.getNewScrollLeft(s,r.viewport);r.footerViewport&&(r.footerViewport.scrollLeft=c.denormalizeScrollLeft(r.viewport,e,d))})),o.$on("$destroy",function(){a.off()})},controller:["$scope",function(r){this.rowStyle=function(){var e=r.rowContainer,t=r.colContainer,i={};return 0!==e.currentTopRow&&(e="translateY("+e.currentTopRow*e.grid.options.rowHeight+"px)",i.transform=e,i["-webkit-transform"]=e,i["-ms-transform"]=e),0!==t.currentFirstColumn&&(t.grid.isRTL()?i["margin-right"]=t.columnOffset+"px":i["margin-left"]=t.columnOffset+"px"),i}}]}}])}(),angular.module("ui.grid").directive("uiGridVisible",function(){return function(e,t,i){e.$watch(i.uiGridVisible,function(e){t[e?"removeClass":"addClass"]("ui-grid-invisible")})}}),function(){"use strict";function e(g,p,f){return{templateUrl:"ui-grid/ui-grid",scope:{uiGrid:"="},replace:!0,transclude:!0,controller:"uiGridController",compile:function(){return{post:function(o,a,e,l){var t,i,s=l.grid,r=(l.scrollbars=[],s.element=a,100),n=20,d=0;function c(){var e,t,i,r,n;s.gridWidth=o.gridWidth=p.elementWidth(a),s.canvasWidth=l.grid.gridWidth,s.gridHeight=o.gridHeight=p.elementHeight(a),s.gridHeight-s.scrollbarHeight<=s.options.rowHeight&&s.options.enableMinHeightCheck&&(e=s.options.minRowsToShow*s.options.rowHeight,t=s.options.showHeader?s.options.headerRowHeight:0,i=s.calcFooterHeight(),r=0,s.options.enableHorizontalScrollbar===f.scrollbars.ALWAYS&&(r=p.getScrollbarWidth()),n=0,angular.forEach(s.options.columnDefs,function(e){e.hasOwnProperty("filter")?n<1&&(n=1):e.hasOwnProperty("filters")&&n<e.filters.length&&(n=e.filters.length)}),!s.options.enableFiltering||n||s.options.columnDefs.length&&s.options.columnDefs.every(function(e){return!1===e.enableFiltering})||(n=1),e=t+e+i+r+n*t,a.css("height",e+"px"),s.gridHeight=o.gridHeight=p.elementHeight(a)),s.refreshCanvas(!0)}function u(){p.isVisible(a)&&(s.gridWidth=o.gridWidth=p.elementWidth(a),s.gridHeight=o.gridHeight=p.elementHeight(a),s.refreshCanvas(!0))}angular.element(g).on("resize",u),a.on("$destroy",function(){angular.element(g).off("resize",u),t(),i()}),t=o.$watch(function(){return s.hasLeftContainer()},function(e,t){e!==t&&s.refreshCanvas(!0)}),i=o.$watch(function(){return s.hasRightContainer()},function(e,t){e!==t&&s.refreshCanvas(!0)}),c(),s.renderingComplete(),function e(){a[0].offsetWidth<=0&&d<n?(setTimeout(e,r),d++):o.$applyAsync(c)}()}}}}}angular.module("ui.grid").controller("uiGridController",["$scope","$element","$attrs","gridUtil","$q","uiGridConstants","gridClassFactory","$parse","$compile",function(r,e,n,t,o,a,i,l,s){var d,c=this,u=[];function g(e){return e?e.length:0}function p(e,t){e&&e!==t&&(c.grid.options.columnDefs=r.uiGrid.columnDefs,c.grid.callDataChangeCallbacks(a.dataChange.COLUMN,{orderByColumnDefs:!0,preCompileCellTemplates:!0}))}function f(e){var t,i=[];c.grid.options.fastWatch&&(e=angular.isString(r.uiGrid.data)?c.grid.appScope.$eval(r.uiGrid.data):r.uiGrid.data),(d=e)&&(!(t=c.grid.columns.length>(c.grid.rowHeaderColumns?c.grid.rowHeaderColumns.length:0))&&!n.uiGridColumns&&0===c.grid.options.columnDefs.length&&0<e.length&&c.grid.buildColumnDefsFromData(e),!t&&(0<c.grid.options.columnDefs.length||0<e.length)&&i.push(c.grid.buildColumns().then(function(){c.grid.preCompileCellTemplates()}).catch(angular.noop)),o.all(i).then(function(){c.grid.modifyRows(d).then(function(){c.grid.redrawInPlace(!0),r.$evalAsync(function(){c.grid.refreshCanvas(!0),c.grid.callDataChangeCallbacks(a.dataChange.ROW)})}).catch(angular.noop)}).catch(angular.noop))}c.grid=i.createGrid(r.uiGrid),c.grid.appScope=c.grid.appScope||r.$parent,e.addClass("grid"+c.grid.id),c.grid.rtl="rtl"===t.getStyles(e[0]).direction,r.grid=c.grid,n.uiGridColumns&&u.push(n.$observe("uiGridColumns",function(e){c.grid.options.columnDefs=angular.isString(e)?angular.fromJson(e):e,c.grid.buildColumns().then(function(){c.grid.preCompileCellTemplates(),c.grid.refreshCanvas(!0)}).catch(angular.noop)})),c.grid.options.fastWatch?(c.uiGrid=r.uiGrid,angular.isString(r.uiGrid.data)?(u.push(r.$parent.$watch(r.uiGrid.data,f)),u.push(r.$parent.$watch(function(){if(c.grid.appScope[r.uiGrid.data])return c.grid.appScope[r.uiGrid.data].length},f))):(u.push(r.$parent.$watch(function(){return r.uiGrid.data},f)),u.push(r.$parent.$watch(function(){return g(r.uiGrid.data)},function(){f(r.uiGrid.data)}))),u.push(r.$parent.$watch(function(){return r.uiGrid.columnDefs},p)),u.push(r.$parent.$watch(function(){return g(r.uiGrid.columnDefs)},function(){p(r.uiGrid.columnDefs)}))):(angular.isString(r.uiGrid.data)?u.push(r.$parent.$watchCollection(r.uiGrid.data,f)):u.push(r.$parent.$watchCollection(function(){return r.uiGrid.data},f)),u.push(r.$parent.$watchCollection(function(){return r.uiGrid.columnDefs},p)));var m=r.$watch(function(){return c.grid.styleComputations},function(){c.grid.refreshCanvas(!0)});r.$on("$destroy",function(){u.forEach(function(e){e()}),m()}),c.fireEvent=function(e,t){t=t||{},angular.isUndefined(t.grid)&&(t.grid=c.grid),r.$broadcast(e,t)},c.innerCompile=function(e){s(e)(r)}}]),angular.module("ui.grid").directive("uiGrid",e),e.$inject=["$window","gridUtil","uiGridConstants"]}(),function(){"use strict";angular.module("ui.grid").directive("uiGridPinnedContainer",["gridUtil",function(e){return{restrict:"EA",replace:!0,template:'<div class="ui-grid-pinned-container"><div ui-grid-render-container container-id="side" row-container-name="\'body\'" col-container-name="side" bind-scroll-vertical="true" class="{{ side }} ui-grid-render-container-{{ side }}"></div></div>',scope:{side:"=uiGridPinnedContainer"},require:"^uiGrid",compile:function(){return{post:function(n,t,e,i){var o=i.grid,r=0;function a(){if("left"===n.side||"right"===n.side){for(var e=o.renderContainers[n.side].visibleColumnCache,t=0,i=0;i<e.length;i++){var r=e[i];t+=r.drawnWidth||r.width||0}return t}}t.addClass("ui-grid-pinned-container-"+n.side),"left"!==n.side&&"right"!==n.side||(o.renderContainers[n.side].getViewportWidth=function(){var t=0,e=(this.visibleColumnCache.forEach(function(e){t+=e.drawnWidth}),this.getViewportAdjustment());return t+=e.width}),o.renderContainers.body.registerViewportAdjuster(function(e){return r=a(),e.width-=r,e.side=n.side,e}),o.registerStyleComputation({priority:15,func:function(){var e="";return"left"!==n.side&&"right"!==n.side||(r=a(),t.attr("style",null),e+=".grid"+o.id+" .ui-grid-pinned-container-"+n.side+", .grid"+o.id+" .ui-grid-pinned-container-"+n.side+" .ui-grid-render-container-"+n.side+" .ui-grid-viewport { width: "+r+"px; } "),e}})}}}}}])}(),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("en",{headerCell:{aria:{defaultFilterLabel:"Filter for column",removeFilter:"Remove Filter",columnMenuButtonLabel:"Column Menu",column:"Column"},priority:"Priority:",filterLabel:"Filter for column: "},aggregate:{label:"items"},groupPanel:{description:"Drag a column header here and drop it to group by that column."},search:{aria:{selected:"Row selected",notSelected:"Row not selected"},placeholder:"Search...",showingItems:"Showing Items:",selectedItems:"Selected Items:",totalItems:"Total Items:",size:"Page Size:",first:"First Page",next:"Next Page",previous:"Previous Page",last:"Last Page"},selection:{aria:{row:"Row"},selectAll:"Select All",displayName:"Row Selection Checkbox"},menu:{text:"Choose Columns:"},sort:{ascending:"Sort Ascending",descending:"Sort Descending",none:"Sort None",remove:"Remove Sort"},column:{hide:"Hide Column"},aggregation:{count:"total rows: ",sum:"total: ",avg:"avg: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Pin Left",pinRight:"Pin Right",unpin:"Unpin"},columnMenu:{close:"Close"},gridMenu:{aria:{buttonLabel:"Grid Menu"},columns:"Columns:",importerTitle:"Import file",exporterAllAsCsv:"Export all data as csv",exporterVisibleAsCsv:"Export visible data as csv",exporterSelectedAsCsv:"Export selected data as csv",exporterAllAsPdf:"Export all data as pdf",exporterVisibleAsPdf:"Export visible data as pdf",exporterSelectedAsPdf:"Export selected data as pdf",exporterAllAsExcel:"Export all data as excel",exporterVisibleAsExcel:"Export visible data as excel",exporterSelectedAsExcel:"Export selected data as excel",clearAllFilters:"Clear all filters"},importer:{noHeaders:"Column names were unable to be derived, does the file have a header?",noObjects:"Objects were not able to be derived, was there data in the file other than headers?",invalidCsv:"File was unable to be processed, is it valid CSV?",invalidJson:"File was unable to be processed, is it valid Json?",jsonNotArray:"Imported json file must contain an array, aborting."},pagination:{aria:{pageToFirst:"Page to first",pageBack:"Page back",pageSelected:"Selected page",pageForward:"Page forward",pageToLast:"Page to last"},sizes:"items per page",totalItems:"items",through:"through",of:"of"},grouping:{group:"Group",ungroup:"Ungroup",aggregate_count:"Agg: Count",aggregate_sum:"Agg: Sum",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Avg",aggregate_remove:"Agg: Remove"},validate:{error:"Error:",minLength:"Value should be at least THRESHOLD characters long.",maxLength:"Value should be at most THRESHOLD characters long.",required:"A value is needed."}}),e}])}]),angular.module("ui.grid").factory("Grid",["$q","$compile","$parse","gridUtil","uiGridConstants","GridOptions","GridColumn","GridRow","GridApi","rowSorter","rowSearcher","GridRenderContainer","$timeout","ScrollEvent",function(v,i,n,p,s,d,c,u,g,f,t,m,r,C){function e(e){var i=this;if(void 0===e||void 0===e.id||!e.id)throw new Error("No ID provided. An ID must be given when creating a grid.");if(!/^[_a-zA-Z0-9-]+$/.test(e.id))throw new Error("Grid id '"+e.id+'" is invalid. It must follow CSS selector syntax rules.');function t(e){i.isScrollingVertically=!1,i.api.core.raise.scrollEnd(e),i.scrollDirection=s.scrollDirection.NONE}i.id=e.id,delete e.id,i.options=d.initialize(e),i.appScope=i.options.appScopeProvider,i.headerHeight=i.options.headerRowHeight,i.footerHeight=i.calcFooterHeight(),i.columnFooterHeight=i.calcColumnFooterHeight(),i.rtl=!1,i.gridHeight=0,i.gridWidth=0,i.columnBuilders=[],i.rowBuilders=[],i.rowsProcessors=[],i.columnsProcessors=[],i.styleComputations=[],i.viewportAdjusters=[],i.rowHeaderColumns=[],i.dataChangeCallbacks={},i.verticalScrollSyncCallBackFns={},i.horizontalScrollSyncCallBackFns={},i.renderContainers={},i.renderContainers.body=new m("body",i),i.cellValueGetterCache={},i.getRowTemplateFn=null,i.rows=[],i.columns=[],i.isScrollingVertically=!1,i.isScrollingHorizontally=!1,i.scrollDirection=s.scrollDirection.NONE,i.disableScrolling=!1;var r=p.debounce(t,i.options.scrollDebounce),n=p.debounce(t,0);function o(e){i.isScrollingHorizontally=!1,i.api.core.raise.scrollEnd(e),i.scrollDirection=s.scrollDirection.NONE}var a=p.debounce(o,i.options.scrollDebounce),l=p.debounce(o,0);i.flagScrollingVertically=function(e){i.isScrollingVertically||i.isScrollingHorizontally||i.api.core.raise.scrollBegin(e),i.isScrollingVertically=!0,(0!==i.options.scrollDebounce&&e.withDelay?r:n)(e)},i.flagScrollingHorizontally=function(e){i.isScrollingVertically||i.isScrollingHorizontally||i.api.core.raise.scrollBegin(e),i.isScrollingHorizontally=!0,(0!==i.options.scrollDebounce&&e.withDelay?a:l)(e)},i.scrollbarHeight=0,i.scrollbarWidth=0,i.options.enableHorizontalScrollbar!==s.scrollbars.NEVER&&(i.scrollbarHeight=p.getScrollbarWidth()),i.options.enableVerticalScrollbar!==s.scrollbars.NEVER&&(i.scrollbarWidth=p.getScrollbarWidth()),i.api=new g(i),i.api.registerMethod("core","refresh",this.refresh),i.api.registerMethod("core","queueGridRefresh",this.queueGridRefresh),i.api.registerMethod("core","refreshRows",this.refreshRows),i.api.registerMethod("core","queueRefresh",this.queueRefresh),i.api.registerMethod("core","handleWindowResize",this.handleWindowResize),i.api.registerMethod("core","addRowHeaderColumn",this.addRowHeaderColumn),i.api.registerMethod("core","scrollToIfNecessary",function(e,t){return i.scrollToIfNecessary(e,t)}),i.api.registerMethod("core","scrollTo",function(e,t){return i.scrollTo(e,t)}),i.api.registerMethod("core","registerRowsProcessor",this.registerRowsProcessor),i.api.registerMethod("core","registerColumnsProcessor",this.registerColumnsProcessor),i.api.registerMethod("core","sortHandleNulls",f.handleNulls),i.api.registerEvent("core","sortChanged"),i.api.registerEvent("core","columnVisibilityChanged"),i.api.registerMethod("core","notifyDataChange",this.notifyDataChange),i.api.registerMethod("core","clearAllFilters",this.clearAllFilters),i.registerDataChangeCallback(i.columnRefreshCallback,[s.dataChange.COLUMN]),i.registerDataChangeCallback(i.processRowsCallback,[s.dataChange.EDIT]),i.registerDataChangeCallback(i.updateFooterHeightCallback,[s.dataChange.OPTIONS]),i.registerStyleComputation({priority:10,func:i.getFooterStyles})}e.prototype.calcFooterHeight=function(){var e;return this.hasFooter()?(e=0,this.options.showGridFooter&&(e+=this.options.gridFooterHeight),e+this.calcColumnFooterHeight()):0},e.prototype.calcColumnFooterHeight=function(){var e=0;return this.options.showColumnFooter&&(e+=this.options.columnFooterHeight),e},e.prototype.getFooterStyles=function(){var e=".grid"+this.id+" .ui-grid-footer-aggregates-row { height: "+this.options.columnFooterHeight+"px; }";return e+=" .grid"+this.id+" .ui-grid-footer-info { height: "+this.options.gridFooterHeight+"px; }"},e.prototype.hasFooter=function(){return this.options.showGridFooter||this.options.showColumnFooter},e.prototype.isRTL=function(){return this.rtl},e.prototype.registerColumnBuilder=function(e){this.columnBuilders.push(e)},e.prototype.buildColumnDefsFromData=function(e){this.options.columnDefs=p.getColumnsFromData(e,this.options.excludeProperties)},e.prototype.registerRowBuilder=function(e){this.rowBuilders.push(e)},e.prototype.registerDataChangeCallback=function(e,t,i){var r=this,n=p.nextUid();return t=t||[s.dataChange.ALL],Array.isArray(t)||p.logError("Expected types to be an array or null in registerDataChangeCallback, value passed was: "+t),this.dataChangeCallbacks[n]={callback:e,types:t,_this:i},function(){delete r.dataChangeCallbacks[n]}},e.prototype.callDataChangeCallbacks=function(i,r){angular.forEach(this.dataChangeCallbacks,function(e,t){-1===e.types.indexOf(s.dataChange.ALL)&&-1===e.types.indexOf(i)&&i!==s.dataChange.ALL||(e._this?e.callback.apply(e._this,this,r):e.callback(this,r))},this)},e.prototype.notifyDataChange=function(e){var t=s.dataChange;e===t.ALL||e===t.COLUMN||e===t.EDIT||e===t.ROW||e===t.OPTIONS?this.callDataChangeCallbacks(e):p.logError("Notified of a data change, but the type was not recognised, so no action taken, type was: "+e)},e.prototype.columnRefreshCallback=function(e,t){e.buildColumns(t),e.queueGridRefresh()},e.prototype.processRowsCallback=function(e){e.queueGridRefresh()},e.prototype.updateFooterHeightCallback=function(e){e.footerHeight=e.calcFooterHeight(),e.columnFooterHeight=e.calcColumnFooterHeight()},e.prototype.getColumn=function(t){return o(this.columns,function(e){return e.colDef.name===t})},e.prototype.getColDef=function(t){return o(this.options.columnDefs,function(e){return e.name===t})},e.prototype.assignTypes=function(){var r=this;r.options.columnDefs.forEach(function(e,t){var i;e.type||(t=new c(e,t,r),i=0<r.rows.length?r.rows[0]:null,e.type=i?p.guessType(r.getCellValue(i,t)):"string")})},e.prototype.isRowHeaderColumn=function(e){return-1!==this.rowHeaderColumns.indexOf(e)},e.prototype.addRowHeaderColumn=function(e,t,i){var r=this,n=(void 0===t&&(t=0),new c(e,p.nextUid(),r));n.isRowHeader=!0,r.isRTL()?(r.createRightContainer(),n.renderContainer="right"):(r.createLeftContainer(),n.renderContainer="left"),r.columnBuilders[0](e,n,r.options).then(function(){n.enableFiltering=!1,n.enableSorting=!1,n.enableHiding=!1,n.headerPriority=t,r.rowHeaderColumns.push(n),r.rowHeaderColumns=r.rowHeaderColumns.sort(function(e,t){return e.headerPriority-t.headerPriority}),i||r.buildColumns().then(function(){r.preCompileCellTemplates(),r.queueGridRefresh()}).catch(angular.noop)}).catch(angular.noop)},e.prototype.getOnlyDataColumns=function(){var t=this,i=[];return t.columns.forEach(function(e){-1===t.rowHeaderColumns.indexOf(e)&&i.push(e)}),i},e.prototype.buildColumns=function(e){var t={orderByColumnDefs:!1},r=(angular.extend(t,e),this),n=[],o=r.rowHeaderColumns.length;for(s=0;s<r.columns.length;s++)r.getColDef(r.columns[s].name)||(r.columns.splice(s,1),s--);for(var i=r.rowHeaderColumns.length-1;0<=i;i--)r.columns.unshift(r.rowHeaderColumns[i]);if(r.options.columnDefs.forEach(function(t,e){r.preprocessColDef(t);var i=r.getColumn(t.name);i?i.updateColumnDef(t,!1):(i=new c(t,p.nextUid(),r),r.columns.splice(e+o,0,i)),r.columnBuilders.forEach(function(e){n.push(e.call(r,t,i,r.options))})}),t.orderByColumnDefs){for(var a=r.columns.slice(0),l=Math.min(r.options.columnDefs.length,r.columns.length),s=0;s<l;s++)r.columns[s+o].name!==r.options.columnDefs[s].name?a[s+o]=r.getColumn(r.options.columnDefs[s].name):a[s+o]=r.columns[s+o];r.columns.length=0,Array.prototype.splice.apply(r.columns,[0,0].concat(a))}return v.all(n).then(function(){0<r.rows.length&&r.assignTypes(),t.preCompileCellTemplates&&r.preCompileCellTemplates()}).catch(angular.noop)},e.prototype.preCompileCellTemplate=function(e){var t=(t=e.cellTemplate.replace(s.MODEL_COL_FIELD,this.getQualifiedColField(e))).replace(s.COL_FIELD,"grid.getCellValue(row, col)");e.compiledElementFn=i(t),e.compiledElementFnDefer&&e.compiledElementFnDefer.resolve(e.compiledElementFn)},e.prototype.preCompileCellTemplates=function(){var t=this;t.columns.forEach(function(e){e.cellTemplate?t.preCompileCellTemplate(e):e.cellTemplatePromise&&e.cellTemplatePromise.then(function(){t.preCompileCellTemplate(e)}).catch(angular.noop)})},e.prototype.getQualifiedColField=function(e){var t="row.entity";return e.field===s.ENTITY_BINDING?t:p.preEval(t+"."+e.field)},e.prototype.createLeftContainer=function(){this.hasLeftContainer()||(this.renderContainers.left=new m("left",this,{disableColumnOffset:!0}))},e.prototype.createRightContainer=function(){this.hasRightContainer()||(this.renderContainers.right=new m("right",this,{disableColumnOffset:!0}))},e.prototype.hasLeftContainer=function(){return void 0!==this.renderContainers.left},e.prototype.hasRightContainer=function(){return void 0!==this.renderContainers.right},e.prototype.preprocessColDef=function(e){if(!e.field&&!e.name)throw new Error("colDef.name or colDef.field property is required");if(void 0===e.name&&void 0!==e.field){for(var t=e.field,i=2;this.getColumn(t);)t=e.field+i.toString(),i++;e.name=t}},e.prototype.newInN=function(e,t,i,r){for(var n=[],o=0;o<t.length;o++){for(var a=r?t[o][r]:t[o],l=!1,s=0;s<e.length;s++){var d=i?e[s][i]:e[s];if(this.options.rowEquality(a,d)){l=!0;break}}l||n.push(a)}return n};var o=function(e,t){var i;return e&&e.length?angular.isFunction(e.find)?e.find(t)||null:(i=null,e.every(function(e){return!t(e)||(i=e,!1)}),i):null},a=(e.prototype.getRow=function(t,e){var i=this;return e=null==e?this.rows:e,o(e,function(e){return i.options.rowEquality(e.entity,t)})},e.prototype.getRowsByKey=function(e,t,i,r){return null==t?null:(r=null==r?this.rows:r).filter(e?function(e){return null!=e.entity&&e.entity.hasOwnProperty(t)&&e.entity[t]===i}:function(e){return e.hasOwnProperty(t)&&e[t]===i})},e.prototype.findRowByKey=function(e,t,i,r){var n=null;return null!=t&&(r=null==r?this.rows:r).every(e?function(e){return null==e.entity||!e.entity.hasOwnProperty(t)||e.entity[t]!==i||(n=e,!1)}:function(e){return!e.hasOwnProperty(t)||e[t]!==i||(n=e,!1)}),n},e.prototype.modifyRows=function(e){var n=this,o=n.rows.slice(0),a=n.rowHashMap||n.createRowHashMap(),l=!0,e=(n.rowHashMap=n.createRowHashMap(),n.rows.length=0,e.forEach(function(e,t){var i,r=n.options.enableRowHashing?a.get(e):n.getRow(e,o);r&&((i=r).entity=e,i.index!==t)&&(i.index=t),i=i||n.processRowBuilders(new u(e,t,n)),n.rows.push(i),n.rowHashMap.put(e,i),i.isSelected||(l=!1)}),n.selection&&n.rows.length&&(n.selection.selectAll=l),n.assignTypes(),v.when(n.processRowsProcessors(n.rows)).then(function(e){return n.setVisibleRows(e)}).catch(angular.noop)),t=v.when(n.processColumnsProcessors(n.columns)).then(function(e){return n.setVisibleColumns(e)}).catch(angular.noop);return v.all([e,t])},e.prototype.addRows=function(e){for(var t=this,i=t.rows.length,r=0;r<e.length;r++){var n,o=t.processRowBuilders(new u(e[r],r+i,t));t.options.enableRowHashing&&(n=t.rowHashMap.get(o.entity))&&(n.row=o),t.rows.push(o)}},e.prototype.processRowBuilders=function(t){var i=this;return i.rowBuilders.forEach(function(e){e.call(i,t,i.options)}),t},e.prototype.registerStyleComputation=function(e){this.styleComputations.push(e)},e.prototype.registerRowsProcessor=function(e,t){if(!angular.isFunction(e))throw"Attempt to register non-function rows processor: "+e;this.rowsProcessors.push({processor:e,priority:t}),this.rowsProcessors.sort(function(e,t){return e.priority-t.priority})},e.prototype.removeRowsProcessor=function(i){var r=-1;this.rowsProcessors.forEach(function(e,t){e.processor===i&&(r=t)}),-1!==r&&this.rowsProcessors.splice(r,1)},e.prototype.processRowsProcessors=function(e){var n,o=this,e=e.slice(0);return 0===o.rowsProcessors.length?v.when(e):(n=v.defer(),function t(i,e){var r=o.rowsProcessors[i].processor;return v.when(r.call(o,e,o.columns)).then(function(e){if(!e)throw"Processor at index "+i+" did not return a set of renderable rows";if(!angular.isArray(e))throw"Processor at index "+i+" did not return an array";if(++i<=o.rowsProcessors.length-1)return t(i,e);n.resolve(e)}).catch(function(e){throw e})}(0,e),n.promise)},e.prototype.setVisibleRows=function(e){var t,i=this;for(t in i.renderContainers){var r=i.renderContainers[t];r.canvasHeightShouldUpdate=!0,void 0===r.visibleRowCache?r.visibleRowCache=[]:r.visibleRowCache.length=0}for(var n=0;n<e.length;n++){var o=e[n],a=void 0!==o.renderContainer&&o.renderContainer?o.renderContainer:"body";o.visible&&i.renderContainers[a].visibleRowCache.push(o)}i.api.core.raise.rowsVisibleChanged(this.api),i.api.core.raise.rowsRendered(this.api)},e.prototype.registerColumnsProcessor=function(e,t){if(!angular.isFunction(e))throw"Attempt to register non-function rows processor: "+e;this.columnsProcessors.push({processor:e,priority:t}),this.columnsProcessors.sort(function(e,t){return e.priority-t.priority})},e.prototype.removeColumnsProcessor=function(e){e=this.columnsProcessors.indexOf(e);void 0!==e&&this.columnsProcessors.splice(e,1)},e.prototype.processColumnsProcessors=function(e){var n,o=this,a=e.slice(0);return 0===o.columnsProcessors.length?v.when(a):(n=v.defer(),function t(i,e){var r=o.columnsProcessors[i].processor;return v.when(r.call(o,e,o.rows)).then(function(e){if(!e)throw"Processor at index "+i+" did not return a set of renderable rows";if(!angular.isArray(e))throw"Processor at index "+i+" did not return an array";if(++i<=o.columnsProcessors.length-1)return t(i,a);n.resolve(a)}).catch(angular.noop)}(0,a),n.promise)},e.prototype.setVisibleColumns=function(e){for(var t in this.renderContainers)this.renderContainers[t].visibleColumnCache.length=0;for(var i=0;i<e.length;i++){var r=e[i];r.visible&&(void 0!==r.renderContainer&&r.renderContainer?this.renderContainers[r.renderContainer]:this.renderContainers.body).visibleColumnCache.push(r)}},e.prototype.handleWindowResize=function(e){var t=this;return t.gridWidth=p.elementWidth(t.element),t.gridHeight=p.elementHeight(t.element),t.queueRefresh()},e.prototype.queueRefresh=function(){var e=this;return e.refreshCanceller&&r.cancel(e.refreshCanceller),e.refreshCanceller=r(function(){e.refreshCanvas(!0)}),e.refreshCanceller.then(function(){e.refreshCanceller=null}).catch(angular.noop),e.refreshCanceller},e.prototype.queueGridRefresh=function(){var e=this;return e.gridRefreshCanceller&&r.cancel(e.gridRefreshCanceller),e.gridRefreshCanceller=r(function(){e.refresh(!0)}),e.gridRefreshCanceller.then(function(){e.gridRefreshCanceller=null}).catch(angular.noop),e.gridRefreshCanceller},e.prototype.updateCanvasHeight=function(){for(var e in this.renderContainers)this.renderContainers.hasOwnProperty(e)&&(this.renderContainers[e].canvasHeightShouldUpdate=!0)},e.prototype.buildStyles=function(){var t=this;t.customStyles="",t.styleComputations.sort(function(e,t){return null===e.priority?1:null===t.priority?-1:null===e.priority&&null===t.priority?0:e.priority-t.priority}).forEach(function(e){e=e.func.call(t);angular.isString(e)&&(t.customStyles+="\n"+e)})},e.prototype.minColumnsToRender=function(){var n=this,o=this.getViewportWidth(),a=0,l=0;return n.columns.forEach(function(e,t){if(l<o)l+=e.drawnWidth,a++;else{for(var i=0,r=t;t-a<=r;r--)i+=n.columns[r].drawnWidth;i<o&&a++}}),a},e.prototype.getBodyHeight=function(){return this.getViewportHeight()},e.prototype.getViewportHeight=function(){var e=this.gridHeight-this.headerHeight-this.footerHeight;return 0<(e+=this.getViewportAdjustment().height)?e:0},e.prototype.getViewportWidth=function(){var e=this.gridWidth;return e+=this.getViewportAdjustment().width},e.prototype.getHeaderViewportWidth=function(){return this.getViewportWidth()},e.prototype.addVerticalScrollSync=function(e,t){this.verticalScrollSyncCallBackFns[e]=t},e.prototype.addHorizontalScrollSync=function(e,t){this.horizontalScrollSyncCallBackFns[e]=t},e.prototype.scrollContainers=function(e,t){if(t.y){var i=["body","left","right"];this.flagScrollingVertically(t),"body"===e?i=["left","right"]:"left"===e?i=["body","right"]:"right"===e&&(i=["body","left"]);for(var r=0;r<i.length;r++){var n=i[r];this.verticalScrollSyncCallBackFns[n]&&this.verticalScrollSyncCallBackFns[n](t)}}if(t.x){var o=["body","bodyheader","bodyfooter"];this.flagScrollingHorizontally(t),"body"===e&&(o=["bodyheader","bodyfooter"]);for(var a=0;a<o.length;a++){var l=o[a];this.horizontalScrollSyncCallBackFns[l]&&this.horizontalScrollSyncCallBackFns[l](t)}}},e.prototype.registerViewportAdjuster=function(e){this.viewportAdjusters.push(e)},e.prototype.removeViewportAdjuster=function(e){e=this.viewportAdjusters.indexOf(e);void 0!==e&&this.viewportAdjusters.splice(e,1)},e.prototype.getViewportAdjustment=function(){var t={height:0,width:0};return this.viewportAdjusters.forEach(function(e){t=e.call(this,t)}),t},e.prototype.getVisibleRowCount=function(){return this.renderContainers.body.visibleRowCache.length},e.prototype.getVisibleRows=function(){return this.renderContainers.body.visibleRowCache},e.prototype.getVisibleColumnCount=function(){return this.renderContainers.body.visibleColumnCache.length},e.prototype.searchRows=function(e){return t.search(this,e,this.columns)},e.prototype.sortByColumn=function(e){return f.sort(this,e,this.columns)},e.prototype.getCellValue=function(e,t){return void 0!==e.entity["$$"+t.uid]?e.entity["$$"+t.uid].rendered:this.options.flatEntityAccess&&void 0!==t.field?e.entity[t.field]:(t.cellValueGetterCache||(t.cellValueGetterCache=n(e.getEntityQualifiedColField(t))),t.cellValueGetterCache(e))},e.prototype.getCellDisplayValue=function(e,t){t.cellDisplayGetterCache||(i=t.cellFilter?" | "+t.cellFilter:"",void 0!==e.entity["$$"+t.uid]?t.cellDisplayGetterCache=n(e.entity["$$"+t.uid].rendered+i):this.options.flatEntityAccess&&void 0!==t.field?(r=t.field.replace(/(')|(\\)/g,"\\$&"),t.cellDisplayGetterCache=n("entity['"+r+"']"+i)):t.cellDisplayGetterCache=n(e.getEntityQualifiedColField(t)+i));var i,r=angular.extend({},e,{col:t});return t.cellDisplayGetterCache(r)},e.prototype.getNextColumnSortPriority=function(){var t=0;return this.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>=t&&(t=e.sort.priority+1)}),t},e.prototype.resetColumnSorting=function(t){this.columns.forEach(function(e){e===t||e.suppressRemoveSort||(e.sort={})})},e.prototype.getColumnSorting=function(){var t=[];return this.columns.slice(0).sort(f.prioritySort).forEach(function(e){e.sort&&void 0!==e.sort.direction&&e.sort.direction&&(e.sort.direction===s.ASC||e.sort.direction===s.DESC)&&t.push(e)}),t},e.prototype.sortColumn=function(e,t,i){var r=this,n=null;if(void 0!==e&&e)return"boolean"==typeof t?i=t:n=t,!i||r.options&&r.options.suppressMultiSort?(r.resetColumnSorting(e),e.sort.priority=void 0,e.sort.priority=r.getNextColumnSortPriority()):void 0===e.sort.priority&&(e.sort.priority=r.getNextColumnSortPriority()),n?e.sort.direction=n:(t=((t=e.sortDirectionCycle.indexOf(e.sort&&e.sort.direction?e.sort.direction:null))+1)%e.sortDirectionCycle.length,e.colDef&&e.suppressRemoveSort&&!e.sortDirectionCycle[t]&&(t=(t+1)%e.sortDirectionCycle.length),e.sortDirectionCycle[t]?e.sort.direction=e.sortDirectionCycle[t]:a(e,r)),r.api.core.raise.sortChanged(r,r.getColumnSorting()),v.when(e);throw new Error("No column parameter provided")},function(t,e){e.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>t.sort.priority&&--e.sort.priority}),t.sort={}});function l(e,t){return e||0<t?t:null}function h(e,t){e/=t;return e<=1?e:1}function w(e,t,i){if(h(e,t)!==i)return{percentage:h(e,t)}}function b(e,t,i){e/=t;if((e=1<e?1:e)!==i)return{percentage:e}}function y(){}return e.prototype.renderingComplete=function(){angular.isFunction(this.options.onRegisterApi)&&this.options.onRegisterApi(this.api),this.api.core.raise.renderingComplete(this.api)},e.prototype.createRowHashMap=function(){var e=new y;return e.grid=this,e},e.prototype.refresh=function(e){var t=this,i=t.processRowsProcessors(t.rows).then(function(e){t.setVisibleRows(e)}).catch(angular.noop),r=t.processColumnsProcessors(t.columns).then(function(e){t.setVisibleColumns(e)}).catch(angular.noop);return v.all([i,r]).then(function(){t.refreshCanvas(!0),t.redrawInPlace(e)}).catch(angular.noop)},e.prototype.refreshRows=function(){var t=this;return t.processRowsProcessors(t.rows).then(function(e){t.setVisibleRows(e),t.redrawInPlace(),t.refreshCanvas(!0)}).catch(angular.noop)},e.prototype.refreshCanvas=function(d){var e,t,c=this,u=v.defer(),g=[];for(e in c.renderContainers)!c.renderContainers.hasOwnProperty(e)||null===(t=c.renderContainers[e]).canvasWidth||isNaN(t.canvasWidth)||(t.header||t.headerCanvas)&&(t.explicitHeaderHeight=t.explicitHeaderHeight||null,t.explicitHeaderCanvasHeight=t.explicitHeaderCanvasHeight||null,g.push(t));return d&&c.buildStyles(),r(0<g.length?function(){function e(e,t){return e!==t&&(o=!0),t}for(var t,i,r,n,o=!1,a=0,l=0,s=0;s<g.length;s++)null===(n=g[s]).canvasWidth||isNaN(n.canvasWidth)||(n.header&&(i=n.headerHeight=e(n.headerHeight,p.outerElementHeight(n.header)),r=p.getBorderSize(n.header,"top"),t=p.getBorderSize(n.header,"bottom"),i=parseInt(i-r-t,10),n.innerHeaderHeight=i=i<0?0:i,!n.explicitHeaderHeight)&&a<i&&(a=i),n.headerCanvas&&(r=n.headerCanvasHeight=e(n.headerCanvasHeight,parseInt(p.outerElementHeight(n.headerCanvas),10)),!n.explicitHeaderCanvasHeight)&&l<r&&(l=r));for(s=0;s<g.length;s++)n=g[s],0<a&&void 0!==n.headerHeight&&null!==n.headerHeight&&(n.explicitHeaderHeight||n.headerHeight<a)&&(n.explicitHeaderHeight=e(n.explicitHeaderHeight,a)),0<l&&void 0!==n.headerCanvasHeight&&null!==n.headerCanvasHeight&&(n.explicitHeaderCanvasHeight||n.headerCanvasHeight<l)&&(n.explicitHeaderCanvasHeight=e(n.explicitHeaderCanvasHeight,l));d&&o&&c.buildStyles(),u.resolve()}:function(){u.resolve()}),u.promise},e.prototype.redrawInPlace=function(e){for(var t in this.renderContainers){var t=this.renderContainers[t],i=l(e,t.prevScrollTop),r=l(e,t.prevScrollLeft),n=e||0<i?null:t.prevScrolltopPercentage;t.adjustRows(i,n),t.adjustColumns(r)}},e.prototype.hasLeftContainerColumns=function(){return this.hasLeftContainer()&&0<this.renderContainers.left.renderedColumns.length},e.prototype.hasRightContainerColumns=function(){return this.hasRightContainer()&&0<this.renderContainers.right.renderedColumns.length},e.prototype.scrollToIfNecessary=function(e,t){var i,r=this,n=new C(r,"uiGrid.scrollToIfNecessary"),o=r.renderContainers.body.visibleRowCache,a=r.renderContainers.body.visibleColumnCache,l=(l=r.renderContainers.body.prevScrollTop)<0?0:l,s=r.renderContainers.body.prevScrollLeft,d=r.renderContainers.body.prevScrollTop+r.gridHeight-r.renderContainers.body.headerHeight-r.footerHeight-r.scrollbarHeight,c=r.renderContainers.body.prevScrollLeft+Math.ceil(r.renderContainers.body.getViewportWidth());if(null!==e&&(o=o.indexOf(e),e=r.renderContainers.body.getCanvasHeight()-r.renderContainers.body.getViewportHeight(),(o=(o=o*r.options.rowHeight)<0?0:o)<Math.floor(l)?(i=r.renderContainers.body.prevScrollTop-(l-o),t&&t.colDef&&t.colDef.enableCellEditOnFocus&&(i=i-r.footerHeight-r.scrollbarHeight),n.y=w(i,e,r.renderContainers.body.prevScrolltopPercentage)):o+r.options.rowHeight>Math.ceil(d)&&(i=o+r.options.rowHeight-d+r.renderContainers.body.prevScrollTop,n.y=w(i,e,r.renderContainers.body.prevScrolltopPercentage))),null!==t){for(var u=a.indexOf(t),l=r.renderContainers.body.getCanvasWidth()-r.renderContainers.body.getViewportWidth(),g=0,p=0;p<u;p++)g+=a[p].drawnWidth;var f,o=(o=(g=g<0?0:g)+t.drawnWidth)<0?0:o;g<s?(f=r.renderContainers.body.prevScrollLeft-(s-g),n.x=b(f,l,r.renderContainers.body.prevScrollleftPercentage)):c<o&&(f=o-c+r.renderContainers.body.prevScrollLeft,n.x=b(f,l,r.renderContainers.body.prevScrollleftPercentage))}var m,h=v.defer();return n.y||n.x?(n.withDelay=!1,r.scrollContainers("",n),m=r.api.core.on.scrollEnd(null,function(){h.resolve(n),m()})):h.resolve(),h.promise},e.prototype.scrollTo=function(e,t){var i=null,r=null;return null!=e&&(i=this.getRow(e)),null!=t&&(r=this.getColumn(t.name||t.field)),this.scrollToIfNecessary(i,r)},e.prototype.clearAllFilters=function(e,t,i){if(void 0===e&&(e=!0),void 0===t&&(t=!1),void 0===i&&(i=!1),this.columns.forEach(function(e){e.filters.forEach(function(e){e.term=void 0,t&&(e.condition=void 0),i&&(e.flags=void 0)})}),e)return this.refreshRows()},y.prototype={put:function(e,t){this[this.grid.options.rowIdentity(e)]=t},get:function(e){return this[this.grid.options.rowIdentity(e)]},remove:function(e){var t=this[e=this.grid.options.rowIdentity(e)];return delete this[e],t}},e}]),angular.module("ui.grid").factory("GridApi",["$q","$rootScope","gridUtil","uiGridConstants","GridRow",function(e,t,d,i,r){function n(e){this.grid=e,this.listeners=[],this.registerEvent("core","renderingComplete"),this.registerEvent("core","filterChanged"),this.registerMethod("core","setRowInvisible",r.prototype.setRowInvisible),this.registerMethod("core","clearRowInvisible",r.prototype.clearRowInvisible),this.registerMethod("core","getVisibleRows",this.grid.getVisibleRows),this.registerEvent("core","rowsVisibleChanged"),this.registerEvent("core","rowsRendered"),this.registerEvent("core","scrollBegin"),this.registerEvent("core","scrollEnd"),this.registerEvent("core","canvasHeightChanged"),this.registerEvent("core","gridDimensionChanged")}function c(e,i,r,n){return t.$on(e,function(e){var t=Array.prototype.slice.call(arguments);t.splice(0,1),i.apply(n||r.api,t)})}return n.prototype.suppressEvents=function(e,t){var i=this,r=angular.isArray(e)?e:[e],e=i.listeners.filter(function(t){return r.some(function(e){return t.handler===e})});e.forEach(function(e){e.dereg()}),t(),e.forEach(function(e){e.dereg=c(e.eventId,e.handler,i.grid,e._this)})},n.prototype.registerEvent=function(o,a){var l=this,e=(l[o]||(l[o]={}),l[o]),s=(e.on||(e.on={},e.raise={}),l.grid.id+o+a);e.raise[a]=function(){t.$emit.apply(t,[s].concat(Array.prototype.slice.call(arguments)))},e.on[a]=function(e,t,i){var r,n;if(null===e||void 0!==e.$on)return r={handler:t,dereg:c(s,t,l.grid,i),eventId:s,scope:e,_this:i},l.listeners.push(r),n=function(){r.dereg();var e=l.listeners.indexOf(r);l.listeners.splice(e,1)},e&&e.$on("$destroy",function(){n()}),n;d.logError("asked to listen on "+o+".on."+a+" but scope wasn't passed in the input parameters.  It is legitimate to pass null, but you've passed something else, so you probably forgot to provide scope rather than did it deliberately, not registering")}},n.prototype.registerEventsFromObject=function(e){var i=this,r=[];angular.forEach(e,function(e,t){var i={name:t,events:[]};angular.forEach(e,function(e,t){i.events.push(t)}),r.push(i)}),r.forEach(function(t){t.events.forEach(function(e){i.registerEvent(t.name,e)})})},n.prototype.registerMethod=function(e,t,i,r){this[e]||(this[e]={}),this[e][t]=d.createBoundedWrapper(r||this.grid,i)},n.prototype.registerMethodsFromObject=function(e,i){var r=this,n=[];angular.forEach(e,function(e,t){var i={name:t,methods:[]};angular.forEach(e,function(e,t){i.methods.push({name:t,fn:e})}),n.push(i)}),n.forEach(function(t){t.methods.forEach(function(e){r.registerMethod(t.name,e.name,e.fn,i)})})},n}]),angular.module("ui.grid").factory("GridColumn",["gridUtil","uiGridConstants","i18nService",function(s,d,e){function t(e,t,i){var r=this;r.grid=i,r.uid=t,r.updateColumnDef(e,!0),r.aggregationValue=void 0,r.updateAggregationValue=function(){var t,e,i;r.aggregationType?(t=0,e=r.grid.getVisibleRows(),i=function(){var t=[];return e.forEach(function(e){e=r.grid.getCellValue(e,r),e=Number(e);isNaN(e)||t.push(e)}),t},angular.isFunction(r.aggregationType)?r.aggregationValue=r.aggregationType(e,r):r.aggregationType===d.aggregationTypes.count?r.aggregationValue=r.grid.getVisibleRowCount():r.aggregationType===d.aggregationTypes.sum?(i().forEach(function(e){t+=e}),r.aggregationValue=t):r.aggregationType===d.aggregationTypes.avg?(i().forEach(function(e){t+=e}),t/=i().length,r.aggregationValue=t):r.aggregationType===d.aggregationTypes.min?r.aggregationValue=Math.min.apply(null,i()):r.aggregationType===d.aggregationTypes.max?r.aggregationValue=Math.max.apply(null,i()):r.aggregationValue=" "):r.aggregationValue=void 0},this.getAggregationValue=function(){return r.aggregationValue}}function c(e){return void 0===e.displayName?s.readableColumnName(e.name):e.displayName}return t.prototype.hideColumn=function(){this.colDef.visible=!1},t.prototype.setPropertyOrDefault=function(e,t,i){var r=this;void 0!==e[t]&&e[t]?r[t]=e[t]:void 0!==r[t]?r[t]=r[t]:r[t]=i||{}},t.prototype.updateColumnDef=function(r,e){var n=this;if(void 0===(n.colDef=r).name)throw new Error("colDef.name is required for column at index "+n.grid.options.columnDefs.indexOf(r));if(n.displayName=c(r),!angular.isNumber(n.width)||!n.hasCustomWidth||r.allowCustomWidthOverride){var t=r.width,i="Cannot parse column width '"+t+"' for column named '"+r.name+"'";if(n.hasCustomWidth=!1,angular.isString(t)||angular.isNumber(t))if(angular.isString(t))if(s.endsWith(t,"%")){var o=t.replace(/%/g,""),o=parseInt(o,10);if(isNaN(o))throw new Error(i);n.width=t}else if(t.match(/^(\d+)$/))n.width=parseInt(t.match(/^(\d+)$/)[1],10);else{if(!t.match(/^\*+$/))throw new Error(i);n.width=t}else n.width=t;else n.width="*"}function a(e){return angular.isString(e)||angular.isNumber(e)}["minWidth","maxWidth"].forEach(function(e){var t=r[e],i="Cannot parse column "+e+" '"+t+"' for column named '"+r.name+"'";if("minWidth"===e&&!a(t)&&angular.isDefined(n.grid.options.minimumColumnSize)&&(t=n.grid.options.minimumColumnSize),a(t))if(angular.isString(t)){if(!t.match(/^(\d+)$/))throw new Error(i);n[e]=parseInt(t.match(/^(\d+)$/)[1],10)}else n[e]=t;else n[e]="minWidth"===e?30:9e3}),n.field=void 0===r.field?r.name:r.field,"string"!=typeof n.field&&s.logError("Field is not a string, this is likely to break the code, Field is: "+n.field),n.name=r.name,n.displayName=c(r),n.aggregationType=angular.isDefined(r.aggregationType)?r.aggregationType:null,n.footerCellTemplate=angular.isDefined(r.footerCellTemplate)?r.footerCellTemplate:null,void 0===r.cellTooltip||!1===r.cellTooltip?n.cellTooltip=!1:!0===r.cellTooltip?n.cellTooltip=function(e,t){return n.grid.getCellValue(e,t)}:"function"==typeof r.cellTooltip?n.cellTooltip=r.cellTooltip:n.cellTooltip=function(e,t){return t.colDef.cellTooltip},void 0===r.headerTooltip||!1===r.headerTooltip?n.headerTooltip=!1:!0===r.headerTooltip?n.headerTooltip=function(e){return e.displayName}:"function"==typeof r.headerTooltip?n.headerTooltip=r.headerTooltip:n.headerTooltip=function(e){return e.colDef.headerTooltip},n.footerCellClass=r.footerCellClass,n.cellClass=r.cellClass,n.headerCellClass=r.headerCellClass,n.cellFilter=r.cellFilter||"",n.sortCellFiltered=!!r.sortCellFiltered,n.filterCellFiltered=!!r.filterCellFiltered,n.headerCellFilter=r.headerCellFilter||"",n.footerCellFilter=r.footerCellFilter||"",n.visible=s.isNullOrUndefined(r.visible)||r.visible,n.headerClass=r.headerClass,n.enableSorting=(void 0!==r.enableSorting?r:n.grid.options).enableSorting,n.sortingAlgorithm=r.sortingAlgorithm,n.sortDirectionCycle=void 0!==r.sortDirectionCycle?r.sortDirectionCycle:[null,d.ASC,d.DESC],void 0===n.suppressRemoveSort&&(n.suppressRemoveSort=void 0!==r.suppressRemoveSort&&r.suppressRemoveSort),n.enableFiltering=void 0===r.enableFiltering||r.enableFiltering,n.filterContainer=(void 0!==r.filterContainer?r:n.grid.options).filterContainer,n.setPropertyOrDefault(r,"menuItems",[]),e&&n.setPropertyOrDefault(r,"sort"),n.setPropertyOrDefault(r,"defaultSort");var l=[];r.filter?l.push(r.filter):r.filters?l=r.filters:l.push({}),e?(n.setPropertyOrDefault(r,"filter"),n.setPropertyOrDefault(r,"extraStyle"),n.setPropertyOrDefault(r,"filters",l)):n.filters.length===l.length&&n.filters.forEach(function(e,t){void 0!==l[t].placeholder&&(e.placeholder=l[t].placeholder),void 0!==l[t].ariaLabel&&(e.ariaLabel=l[t].ariaLabel),void 0!==l[t].flags&&(e.flags=l[t].flags),void 0!==l[t].type&&(e.type=l[t].type),void 0!==l[t].selectOptions&&(e.selectOptions=l[t].selectOptions)})},t.prototype.unsort=function(){var t=this.sort.priority;this.grid.columns.forEach(function(e){e.sort&&void 0!==e.sort.priority&&e.sort.priority>t&&--e.sort.priority}),this.sort={},this.grid.api.core.raise.sortChanged(this.grid,this.grid.getColumnSorting())},t.prototype.getColClass=function(e){var t=d.COL_CLASS_PREFIX+this.uid;return e?"."+t:t},t.prototype.isPinnedLeft=function(){return"left"===this.renderContainer},t.prototype.isPinnedRight=function(){return"right"===this.renderContainer},t.prototype.getColClassDefinition=function(){return" .grid"+this.grid.id+" "+this.getColClass(!0)+" { min-width: "+this.drawnWidth+"px; max-width: "+this.drawnWidth+"px; }"},t.prototype.getRenderContainer=function(){var e=this.renderContainer;return this.grid.renderContainers[e=null!==e&&""!==e&&void 0!==e?e:"body"]},t.prototype.showColumn=function(){this.colDef.visible=!0},t.prototype.getAggregationText=function(){if(this.colDef.aggregationHideLabel)return"";if(this.colDef.aggregationLabel)return this.colDef.aggregationLabel;switch(this.colDef.aggregationType){case d.aggregationTypes.count:return e.getSafeText("aggregation.count");case d.aggregationTypes.sum:return e.getSafeText("aggregation.sum");case d.aggregationTypes.avg:return e.getSafeText("aggregation.avg");case d.aggregationTypes.min:return e.getSafeText("aggregation.min");case d.aggregationTypes.max:return e.getSafeText("aggregation.max");default:return""}},t.prototype.getCellTemplate=function(){return this.cellTemplatePromise},t.prototype.getCompiledElementFn=function(){return this.compiledElementFnDefer.promise},t}]),angular.module("ui.grid").factory("GridOptions",["gridUtil","uiGridConstants",function(t,i){return{initialize:function(e){return e.onRegisterApi=e.onRegisterApi||angular.noop(),e.data=e.data||[],e.columnDefs=e.columnDefs||[],e.excludeProperties=e.excludeProperties||["$$hashKey"],e.enableRowHashing=!1!==e.enableRowHashing,e.rowIdentity=e.rowIdentity||function(e){return t.hashKey(e)},e.getRowIdentity=e.getRowIdentity||function(e){return e.$$hashKey},e.flatEntityAccess=!0===e.flatEntityAccess,e.showHeader=void 0===e.showHeader||e.showHeader,e.showHeader?e.headerRowHeight=void 0!==e.headerRowHeight?e.headerRowHeight:30:e.headerRowHeight=0,"string"==typeof e.rowHeight?e.rowHeight=parseInt(e.rowHeight)||30:e.rowHeight=e.rowHeight||30,e.minRowsToShow=void 0!==e.minRowsToShow?e.minRowsToShow:10,e.showGridFooter=!0===e.showGridFooter,e.showColumnFooter=!0===e.showColumnFooter,e.columnFooterHeight=void 0!==e.columnFooterHeight?e.columnFooterHeight:30,e.gridFooterHeight=void 0!==e.gridFooterHeight?e.gridFooterHeight:30,e.columnWidth=void 0!==e.columnWidth?e.columnWidth:50,e.maxVisibleColumnCount=void 0!==e.maxVisibleColumnCount?e.maxVisibleColumnCount:200,e.virtualizationThreshold=void 0!==e.virtualizationThreshold?e.virtualizationThreshold:20,e.columnVirtualizationThreshold=void 0!==e.columnVirtualizationThreshold?e.columnVirtualizationThreshold:10,e.excessRows=void 0!==e.excessRows?e.excessRows:4,e.scrollThreshold=void 0!==e.scrollThreshold?e.scrollThreshold:4,e.excessColumns=void 0!==e.excessColumns?e.excessColumns:4,e.aggregationCalcThrottle=void 0!==e.aggregationCalcThrottle?e.aggregationCalcThrottle:500,e.wheelScrollThrottle=void 0!==e.wheelScrollThrottle?e.wheelScrollThrottle:70,e.scrollDebounce=void 0!==e.scrollDebounce?e.scrollDebounce:300,e.enableHiding=!1!==e.enableHiding,e.enableSorting=!1!==e.enableSorting,e.suppressMultiSort=!0===e.suppressMultiSort,e.enableFiltering=!0===e.enableFiltering,e.filterContainer=void 0!==e.filterContainer?e.filterContainer:"headerCell",e.enableColumnMenus=!1!==e.enableColumnMenus,e.enableVerticalScrollbar=void 0!==e.enableVerticalScrollbar?e.enableVerticalScrollbar:i.scrollbars.ALWAYS,e.enableHorizontalScrollbar=void 0!==e.enableHorizontalScrollbar?e.enableHorizontalScrollbar:i.scrollbars.ALWAYS,e.enableMinHeightCheck=!1!==e.enableMinHeightCheck,e.minimumColumnSize=void 0!==e.minimumColumnSize?e.minimumColumnSize:30,e.rowEquality=e.rowEquality||function(e,t){return e===t},e.headerTemplate=e.headerTemplate||null,e.footerTemplate=e.footerTemplate||"ui-grid/ui-grid-footer",e.gridFooterTemplate=e.gridFooterTemplate||"ui-grid/ui-grid-grid-footer",e.rowTemplate=e.rowTemplate||"ui-grid/ui-grid-row",e.gridMenuTemplate=e.gridMenuTemplate||"ui-grid/uiGridMenu",e.disableGridMenuHideOnScroll=e.disableGridMenuHideOnScroll||!1,e.menuButtonTemplate=e.menuButtonTemplate||"ui-grid/ui-grid-menu-button",e.menuItemTemplate=e.menuItemTemplate||"ui-grid/uiGridMenuItem",e.appScopeProvider=e.appScopeProvider||null,e}}}]),angular.module("ui.grid").factory("GridRenderContainer",["gridUtil","uiGridConstants",function(b,r){function e(e,t,i){var r=this;r.name=e,r.grid=t,r.visibleRowCache=[],r.visibleColumnCache=[],r.renderedRows=[],r.renderedColumns=[],r.prevScrollTop=0,r.prevScrolltopPercentage=0,r.prevRowScrollIndex=0,r.prevScrollLeft=0,r.prevScrollleftPercentage=0,r.prevColumnScrollIndex=0,r.columnStyles="",r.viewportAdjusters=[],r.hasHScrollbar=!1,r.hasVScrollbar=!1,r.canvasHeightShouldUpdate=!0,r.$$canvasHeight=0,i&&angular.isObject(i)&&angular.extend(r,i),t.registerStyleComputation({priority:5,func:function(){return r.updateColumnWidths(),r.columnStyles}})}return e.prototype.reset=function(){this.visibleColumnCache.length=0,this.visibleRowCache.length=0,this.renderedRows.length=0,this.renderedColumns.length=0},e.prototype.containsColumn=function(e){return-1!==this.visibleColumnCache.indexOf(e)},e.prototype.minRowsToRender=function(){for(var e=0,t=0,i=this.getViewportHeight(),r=this.visibleRowCache.length-1;t<i&&0<=r;r--)t+=this.visibleRowCache[r].height,e++;return e},e.prototype.minColumnsToRender=function(){for(var e=this.getViewportWidth(),t=0,i=0,r=0;r<this.visibleColumnCache.length;r++){var n=this.visibleColumnCache[r];if(i<e)i+=n.drawnWidth||0,t++;else{for(var o=0,a=r;r-t<=a;a--)o+=this.visibleColumnCache[a].drawnWidth||0;o<e&&t++}}return t},e.prototype.getVisibleRowCount=function(){return this.visibleRowCache.length},e.prototype.registerViewportAdjuster=function(e){this.viewportAdjusters.push(e)},e.prototype.removeViewportAdjuster=function(e){e=this.viewportAdjusters.indexOf(e);-1<e&&this.viewportAdjusters.splice(e,1)},e.prototype.getViewportAdjustment=function(){var t={height:0,width:0};return this.viewportAdjusters.forEach(function(e){t=e.call(this,t)}),t},e.prototype.getMargin=function(t){var i=0;return this.viewportAdjusters.forEach(function(e){e=e.call(this,{height:0,width:0});e.side&&e.side===t&&(i+=-1*e.width)}),i},e.prototype.getViewportHeight=function(){var e=this,t=e.headerHeight||e.grid.headerHeight,t=e.grid.gridHeight-t-e.grid.footerHeight;return 0<(t+=e.getViewportAdjustment().height)?t:0},e.prototype.getViewportWidth=function(){var e=this.grid.gridWidth;return e+=this.getViewportAdjustment().width},e.prototype.getHeaderViewportWidth=function(){return this.getViewportWidth()},e.prototype.getCanvasHeight=function(){var e,t=this;return t.canvasHeightShouldUpdate&&(e=t.$$canvasHeight,t.$$canvasHeight=0,t.visibleRowCache.forEach(function(e){t.$$canvasHeight+=e.height}),t.canvasHeightShouldUpdate=!1,t.grid.api.core.raise.canvasHeightChanged(e,t.$$canvasHeight)),t.$$canvasHeight},e.prototype.getVerticalScrollLength=function(){return this.getCanvasHeight()-this.getViewportHeight()+this.grid.scrollbarHeight!==0?this.getCanvasHeight()-this.getViewportHeight()+this.grid.scrollbarHeight:-1},e.prototype.getHorizontalScrollLength=function(){return this.getCanvasWidth()-this.getViewportWidth()+this.grid.scrollbarWidth!==0?this.getCanvasWidth()-this.getViewportWidth()+this.grid.scrollbarWidth:-1},e.prototype.getCanvasWidth=function(){return this.canvasWidth},e.prototype.setRenderedRows=function(e){this.renderedRows.length=e.length;for(var t=0;t<e.length;t++)this.renderedRows[t]=e[t]},e.prototype.setRenderedColumns=function(e){this.renderedColumns.length=e.length;for(var t=0;t<e.length;t++)this.renderedColumns[t]=e[t];this.updateColumnOffset()},e.prototype.updateColumnOffset=function(){for(var e=0,t=0;t<this.currentFirstColumn;t++)e+=this.visibleColumnCache[t].drawnWidth;this.columnOffset=e},e.prototype.scrollVertical=function(e){var t,i=-1;if(e!==this.prevScrollTop)return 0<(t=e-this.prevScrollTop)&&(this.grid.scrollDirection=r.scrollDirection.DOWN),t<0&&(this.grid.scrollDirection=r.scrollDirection.UP),i=e/this.getVerticalScrollLength(),this.adjustScrollVertical(e,i=(i=1<i?1:i)<0?0:i),i},e.prototype.scrollHorizontal=function(e){var t,i=-1;if(e!==this.prevScrollLeft)return 0<(t=e-this.prevScrollLeft)&&(this.grid.scrollDirection=r.scrollDirection.RIGHT),t<0&&(this.grid.scrollDirection=r.scrollDirection.LEFT),t=this.getHorizontalScrollLength(),this.adjustScrollHorizontal(e,i=0!==t?e/t:0),i},e.prototype.adjustScrollVertical=function(e,t,i){this.prevScrollTop===e&&!i||(null==e&&(e=(this.getCanvasHeight()-this.getViewportHeight())*t),this.adjustRows(e,t,!1),this.prevScrollTop=e,this.prevScrolltopPercentage=t,this.grid.queueRefresh())},e.prototype.adjustScrollHorizontal=function(e,t,i){this.prevScrollLeft===e&&!i||(null==e&&(e=(this.getCanvasWidth()-this.getViewportWidth())*t),this.adjustColumns(e),this.prevScrollLeft=e,this.prevScrollleftPercentage=t,this.grid.queueRefresh())},e.prototype.adjustRows=function(e,t,i){var r=this,n=r.minRowsToRender(),o=r.visibleRowCache,a=o.length-n,t=(null==t&&e&&(t=e/r.getVerticalScrollLength()),Math.ceil(Math.min(a,a*t))),l=(a<t&&(t=a),[]);if(o.length>r.grid.options.virtualizationThreshold){if(null!=e){if(!r.grid.suppressParentScrollDown&&r.prevScrollTop<e&&t<r.prevRowScrollIndex+r.grid.options.scrollThreshold&&t<a)return;if(!r.grid.suppressParentScrollUp&&r.prevScrollTop>e&&t>r.prevRowScrollIndex-r.grid.options.scrollThreshold&&t<a)return}l=[Math.max(0,t-r.grid.options.excessRows),Math.min(o.length,t+n+r.grid.options.excessRows)]}else{e=r.visibleRowCache.length;l=[0,Math.max(e,n+r.grid.options.excessRows)]}r.updateViewableRowRange(l),r.prevRowScrollIndex=t},e.prototype.adjustColumns=function(e){var t=this,i=t.minColumnsToRender(),r=t.visibleColumnCache,n=r.length-i,n=Math.min(n,t.getLeftIndex(e)),e=[];e=r.length>t.grid.options.columnVirtualizationThreshold&&t.getCanvasWidth()>t.getViewportWidth()?[Math.max(0,n-t.grid.options.excessColumns),Math.min(r.length,n+i+t.grid.options.excessColumns)]:(r=t.visibleColumnCache.length,[0,Math.max(r,i+t.grid.options.excessColumns)]),t.updateViewableColumnRange(e),t.prevColumnScrollIndex=n},e.prototype.getLeftIndex=function(e){for(var t=0,i=0;i<this.visibleColumnCache.length&&!(this.visibleColumnCache[i]&&this.visibleColumnCache[i].visible&&e<=(t+=this.visibleColumnCache[i].drawnWidth));i++);return i},e.prototype.updateViewableRowRange=function(e){var t=this.visibleRowCache.slice(e[0],e[1]);this.currentTopRow=e[0],this.setRenderedRows(t)},e.prototype.updateViewableColumnRange=function(e){var t=this.visibleColumnCache.slice(e[0],e[1]);this.currentFirstColumn=e[0],this.setRenderedColumns(t)},e.prototype.headerCellWrapperStyle=function(){var e;return 0!==this.currentFirstColumn?(e=this.columnOffset,this.grid.isRTL()?{"margin-right":e+"px"}:{"margin-left":e+"px"}):null},e.prototype.updateColumnWidths=function(){var i,e,r=this,n=[],o=0,a=0,t="",l=!1,s=[],d=[],c=0,u=r.grid.getViewportWidth()-r.grid.scrollbarWidth,g=[],p=(angular.forEach(r.grid.renderContainers,function(e){g=g.concat(e.visibleColumnCache)}),g.forEach(function(e){var t,i=0;e.visible&&((l=!l&&e.colDef.pinnedRight?!0:l)&&(u+=r.grid.scrollbarWidth),angular.isNumber(e.width)?(i=e.colDef.allowFloatWidth?parseFloat(e.width):parseInt(e.width,10),a+=i,e.drawnWidth=i,s.push(e)):b.endsWith(e.width,"%")?(t=parseInt(e.width.replace(/%/g,""),10),(i=(i=e.colDef.allowFloatWidth?parseFloat(t/100*u):parseInt(t/100*u,10))>e.maxWidth?e.maxWidth:i)<e.minWidth&&(i=e.minWidth),a+=i,e.drawnWidth=i,c+=t,d.push(e)):angular.isString(e.width)&&-1!==e.width.indexOf("*")&&(o+=e.width.length,n.push(e)))}),u-a);if(0<n.length&&(i=p/o,n.forEach(function(e){var t=parseInt(e.width.length*i,10);(t=(t=e.colDef.allowFloatWidth?parseFloat(e.width.length*i):t)>e.maxWidth?e.maxWidth:t)<e.minWidth&&(t=e.minWidth),a+=t,e.drawnWidth=t})),0<n.length?e=n:0<d.length&&0===s.length&&100===c&&(e=d),!angular.isUndefined(e)){function f(e){e.drawnWidth<e.maxWidth&&0<m&&(e.drawnWidth++,a++,m--,h=!0)}for(var m=u-a,h=!0;0<m&&h;)h=!1,e.forEach(f);function v(e){e.drawnWidth>e.minWidth&&0<C&&(e.drawnWidth--,a--,C--,h=!0)}for(var C=a-u,h=!0;0<C&&h;)h=!1,e.forEach(v)}var w=0;r.visibleColumnCache.forEach(function(e){e.visible&&(w+=e.drawnWidth)}),g.forEach(function(e){t+=e.getColClassDefinition()}),r.canvasWidth=w,this.columnStyles=t},e.prototype.needsHScrollbarPlaceholder=function(){var e;return("left"===this.name||"right"===this.name&&!this.hasHScrollbar&&!this.grid.disableScrolling)&&(this.grid.options.enableHorizontalScrollbar===r.scrollbars.ALWAYS||(e=this.grid.element[0].querySelector(".ui-grid-render-container-body .ui-grid-viewport")).scrollWidth>e.offsetWidth)},e.prototype.getViewportStyle=function(){var e=this,t={},i={};return i[r.scrollbars.ALWAYS]="scroll",i[r.scrollbars.WHEN_NEEDED]="auto",e.hasHScrollbar=!1,e.hasVScrollbar=!1,e.grid.disableScrolling?(t["overflow-x"]="hidden",t["overflow-y"]="hidden"):("body"===e.name?(e.hasHScrollbar=e.grid.options.enableHorizontalScrollbar!==r.scrollbars.NEVER,e.grid.isRTL()?e.grid.hasLeftContainerColumns()||(e.hasVScrollbar=e.grid.options.enableVerticalScrollbar!==r.scrollbars.NEVER):e.grid.hasRightContainerColumns()||(e.hasVScrollbar=e.grid.options.enableVerticalScrollbar!==r.scrollbars.NEVER)):"left"===e.name?e.hasVScrollbar=!!e.grid.isRTL()&&e.grid.options.enableVerticalScrollbar!==r.scrollbars.NEVER:e.hasVScrollbar=!e.grid.isRTL()&&e.grid.options.enableVerticalScrollbar!==r.scrollbars.NEVER,t["overflow-x"]=e.hasHScrollbar?i[e.grid.options.enableHorizontalScrollbar]:"hidden",t["overflow-y"]=e.hasVScrollbar?i[e.grid.options.enableVerticalScrollbar]:"hidden"),t},e}]),angular.module("ui.grid").factory("GridRow",["gridUtil","uiGridConstants",function(r,t){function e(e,t,i){this.grid=i,this.entity=e,this.index=t,this.uid=r.nextUid(),this.visible=!0,this.isSelected=!1,this.$$height=i.options.rowHeight}return Object.defineProperty(e.prototype,"height",{get:function(){return this.$$height},set:function(e){e!==this.$$height&&(this.grid.updateCanvasHeight(),this.$$height=e)}}),e.prototype.getQualifiedColField=function(e){return"row."+this.getEntityQualifiedColField(e)},e.prototype.getEntityQualifiedColField=function(e){return e.field===t.ENTITY_BINDING?"entity":r.preEval("entity."+e.field)},e.prototype.setRowInvisible=function(e){e&&e.setThisRowInvisible&&e.setThisRowInvisible("user")},e.prototype.clearRowInvisible=function(e){e&&e.clearThisRowInvisible&&e.clearThisRowInvisible("user")},e.prototype.setThisRowInvisible=function(e,t){this.invisibleReason||(this.invisibleReason={}),this.invisibleReason[e]=!0,this.evaluateRowVisibility(t)},e.prototype.clearThisRowInvisible=function(e,t){void 0!==this.invisibleReason&&delete this.invisibleReason[e],this.evaluateRowVisibility(t)},e.prototype.evaluateRowVisibility=function(e){var i=!0;void 0!==this.invisibleReason&&angular.forEach(this.invisibleReason,function(e,t){e&&(i=!1)}),void 0!==this.visible&&this.visible===i||(this.visible=i,e)||(this.grid.queueGridRefresh(),this.grid.api.core.raise.rowsVisibleChanged(this))},e}]),function(){"use strict";angular.module("ui.grid").factory("GridRowColumn",["$parse","$filter",function(e,t){function i(e,t){if(!(this instanceof i))throw"Using GridRowColumn as a function insead of as a constructor. Must be called with `new` keyword";this.row=e,this.col=t}return i.prototype.getIntersectionValueRaw=function(){return e(this.row.getEntityQualifiedColField(this.col))(this.row)},i}])}(),angular.module("ui.grid").factory("ScrollEvent",["gridUtil",function(o){function e(e,t,i,r){var n=this;if(!e)throw new Error("grid argument is required");n.grid=e,n.source=r,n.withDelay=!0,n.sourceRowContainer=t,n.sourceColContainer=i,n.newScrollLeft=null,n.newScrollTop=null,n.x=null,n.y=null,n.verticalScrollLength=-9999999,n.horizontalScrollLength=-999999,n.type="scroll",n.fireThrottledScrollingEvent=o.throttle(function(e){n.grid.scrollContainers(e,n)},n.grid.options.wheelScrollThrottle,{trailing:!0})}return e.prototype.getNewScrollLeft=function(e,t){var i=this;if(i.newScrollLeft)return i.newScrollLeft;var r,e=e.getCanvasWidth()-e.getViewportWidth(),t=o.normalizeScrollLeft(t,i.grid);if(void 0!==i.x.percentage&&void 0!==i.x.percentage)r=i.x.percentage;else{if(void 0===i.x.pixels||void 0===i.x.pixels)throw new Error("No percentage or pixel value provided for scroll event X axis");r=i.x.percentage=(t+i.x.pixels)/e}return Math.max(0,r*e)},e.prototype.getNewScrollTop=function(e,t){var i=this;if(i.newScrollTop)return i.newScrollTop;var r,e=e.getVerticalScrollLength(),t=t[0].scrollTop;if(void 0!==i.y.percentage&&void 0!==i.y.percentage)r=i.y.percentage;else{if(void 0===i.y.pixels||void 0===i.y.pixels)throw new Error("No percentage or pixel value provided for scroll event Y axis");r=i.y.percentage=(t+i.y.pixels)/e}return Math.max(0,r*e)},e.prototype.atTop=function(e){return this.y&&(0===this.y.percentage||this.verticalScrollLength<0)&&0===e},e.prototype.atBottom=function(e){return this.y&&(1===this.y.percentage||0===this.verticalScrollLength)&&0<e},e.prototype.atLeft=function(e){return this.x&&(0===this.x.percentage||this.horizontalScrollLength<0)&&0===e},e.prototype.atRight=function(e){return this.x&&(1===this.x.percentage||0===this.horizontalScrollLength)&&0<e},e.Sources={ViewPortScroll:"ViewPortScroll",RenderContainerMouseWheel:"RenderContainerMouseWheel",RenderContainerTouchMove:"RenderContainerTouchMove",Other:99},e}]),function(){"use strict";angular.module("ui.grid").service("gridClassFactory",["gridUtil","$q","$compile","$templateCache","uiGridConstants","Grid","GridColumn","GridRow",function(s,r,n,e,d,o,t,i){var a={createGrid:function(e){(e=void 0!==e?e:{}).id=s.newId();var t,i=new o(e);return i.options.rowTemplate&&(t=r.defer(),i.getRowTemplateFn=t.promise,s.getTemplate(i.options.rowTemplate).then(function(e){e=n(e);t.resolve(e)},function(){throw new Error("Couldn't fetch/use row template '"+i.options.rowTemplate+"'")}).catch(angular.noop)),i.registerColumnBuilder(a.defaultColumnBuilder),i.registerRowBuilder(a.rowTemplateAssigner),i.registerRowsProcessor(function(e){return e.forEach(function(e){e.evaluateRowVisibility(!0)}),e},50),i.registerColumnsProcessor(function(e){return e.forEach(function(e){e.visible=!angular.isDefined(e.colDef.visible)||e.colDef.visible}),e},50),i.registerRowsProcessor(i.searchRows,100),i.options.externalSort&&angular.isFunction(i.options.externalSort)?i.registerRowsProcessor(i.options.externalSort,200):i.registerRowsProcessor(i.sortByColumn,200),i},defaultColumnBuilder:function(o,a,e){function t(i,e,t,r,n){return o[i]?a[e]=o[i]:a[e]=t,t=s.getTemplate(a[e]).then(function(e){angular.isFunction(e)&&(e=e());var t="cellTooltip"===n?"col.cellTooltip(row,col)":"col.headerTooltip(col)";return n&&!1===a[n]?e=e.replace(d.TOOLTIP,""):n&&a[n]&&(e=e.replace(d.TOOLTIP,'title="{{'+t+' CUSTOM_FILTERS }}"')),r&&(e=e.replace(d.CUSTOM_FILTERS,function(){return a[r]?"|"+a[r]:""})),s.postProcessTemplate(e).then(function(e){a[i]=e})},function(){throw new Error("Couldn't fetch/use colDef."+i+" '"+o[i]+"'")}).catch(angular.noop),l.push(t),t}var l=[];return a.cellTemplatePromise=t("cellTemplate","providedCellTemplate","ui-grid/uiGridCell","cellFilter","cellTooltip"),a.headerCellTemplatePromise=t("headerCellTemplate","providedHeaderCellTemplate","ui-grid/uiGridHeaderCell","headerCellFilter","headerTooltip"),a.footerCellTemplatePromise=t("footerCellTemplate","providedFooterCellTemplate","ui-grid/uiGridFooterCell","footerCellFilter"),a.filterHeaderTemplatePromise=t("filterHeaderTemplate","providedFilterHeaderTemplate","ui-grid/ui-grid-filter"),a.compiledElementFnDefer=r.defer(),r.all(l)},rowTemplateAssigner:function(e){var t;return e.rowTemplate?(t=r.defer(),e.getRowTemplateFn=t.promise,s.getTemplate(e.rowTemplate).then(function(e){e=n(e);t.resolve(e)},function(){throw new Error("Couldn't fetch/use row template '"+e.rowTemplate+"'")})):(e.rowTemplate=this.options.rowTemplate,e.getRowTemplateFn=this.getRowTemplateFn),e.getRowTemplateFn}};return a}])}(),function(){function r(e){return e.replace(/[|\\{}()[\]^$+?*.]/g,"\\$&").replace(/-/g,"\\x2d")}angular.module("ui.grid").service("rowSearcher",["gridUtil","uiGridConstants",function(s,l){var i=l.filter.CONTAINS,d={getTerm:function(e){return void 0===e.term?e.term:"string"==typeof(e=e.term)?e.trim():e},stripTerm:function(e){e=d.getTerm(e);return"string"==typeof e?r(e.replace(/(^\*|\*$)/g,"")):e},guessCondition:function(e){var t;return void 0!==e.term&&e.term&&(t=d.getTerm(e),/\*/.test(t))?(e=e.flags&&e.flags.caseSensitive?"":"i",t=(t=r(t)).replace(/\\\*/g,".*?"),new RegExp("^"+t+"$",e)):i},setupFilters:function(e){for(var t=[],i=0;i<e.length;i++){var r=e[i];if(r.noTerm||!s.isNullOrUndefined(r.term)){var n={},o="";switch(r.flags&&r.flags.caseSensitive||(o+="i"),s.isNullOrUndefined(r.term)||(r.rawTerm?n.term=r.term:n.term=d.stripTerm(r)),n.noTerm=r.noTerm,n.condition=r.condition||d.guessCondition(r),n.flags=angular.extend({caseSensitive:!1,date:!1},r.flags),n.condition){case l.filter.STARTS_WITH:n.startswithRE=new RegExp("^"+n.term,o);break;case l.filter.ENDS_WITH:n.endswithRE=new RegExp(n.term+"$",o);break;case l.filter.EXACT:n.exactRE=new RegExp("^"+n.term+"$",o);break;case l.filter.CONTAINS:n.containsRE=new RegExp(n.term,o)}t.push(n)}}return t},runColumnFilter:function(e,t,i,r){var n=typeof r.condition,o=r.term,a=i.filterCellFiltered?e.getCellDisplayValue(t,i):e.getCellValue(t,i);if(null==a&&(a=""),r.condition instanceof RegExp)return r.condition.test(a);if("function"==n)return r.condition(o,a,t,i);if(r.startswithRE)return r.startswithRE.test(a);if(r.endswithRE)return r.endswithRE.test(a);if(r.containsRE)return r.containsRE.test(a);if(r.exactRE)return r.exactRE.test(a);if(r.condition===l.filter.NOT_EQUAL)return!new RegExp("^"+o+"$").test(a);switch("number"==typeof a&&"string"==typeof o&&(e=parseFloat(o.replace(/\\\./,".").replace(/\\\-/,"-")),isNaN(e)||(o=e)),!0===r.flags.date&&(a=new Date(a),o=new Date(o.replace(/\\/g,""))),r.condition){case l.filter.GREATER_THAN:return o<a;case l.filter.GREATER_THAN_OR_EQUAL:return o<=a;case l.filter.LESS_THAN:return a<o;case l.filter.LESS_THAN_OR_EQUAL:return a<=o}return!0},searchColumn:function(e,t,i,r){if(!e.options.useExternalFiltering)for(var n=0;n<r.length;n++){var o=r[n];if((!s.isNullOrUndefined(o.term)&&""!==o.term||o.noTerm)&&!d.runColumnFilter(e,t,i,o))return!1}return!0}};return d.search=function(e,l,t){if(l){if(e.options.enableFiltering){for(var i=[],r=0;r<t.length;r++){var n=t[r];void 0!==n.filters&&function(e){var t=!1;return e.forEach(function(e){(!s.isNullOrUndefined(e.term)&&""!==e.term||e.noTerm)&&(t=!0)}),t}(n.filters)&&i.push({col:n,filters:d.setupFilters(n.filters)})}if(0<i.length){function o(e,t){for(var i,r,n,o,a=0;a<l.length;a++)i=e,r=l[a],n=t.col,o=t.filters,r.visible&&!d.searchColumn(i,r,n,o)&&(r.visible=!1)}for(var a=0;a<i.length;a++)o(e,i[a]);e.api.core.raise.rowsVisibleChanged&&e.api.core.raise.rowsVisibleChanged()}}return l}},d}])}(),angular.module("ui.grid").service("rowSorter",["uiGridConstants",function(c){var u={colSortFnCache:{}};function n(e){return/^\s*-?Infinity\s*$/.test(e)?parseFloat(e):parseFloat(e.replace(/[^0-9.eE-]/g,""))}return u.guessSortFn=function(e){switch(e){case"number":return u.sortNumber;case"numberStr":return u.sortNumberStr;case"boolean":return u.sortBool;case"string":return u.sortAlpha;case"date":return u.sortDate;case"object":return u.basicSort;default:throw new Error("No sorting function found for type: "+e)}},u.handleNulls=function(e,t){return null==e||null==t?null==e&&null==t?0:null==e?1:-1:null},u.basicSort=function(e,t){var i=u.handleNulls(e,t);return null!==i?i:e===t?0:e<t?-1:1},u.sortNumber=function(e,t){var i=u.handleNulls(e,t);return null!==i?i:e-t},u.sortNumberStr=function(e,t){var i,r=u.handleNulls(e,t);return null!==r?r:(r=n(e),e=n(t),t=isNaN(r),i=isNaN(e),t||i?t&&i?0:t?1:-1:r-e)},u.sortAlpha=function(e,t){var i=u.handleNulls(e,t);return null!==i?i:(i=e.toString().toLowerCase())===(e=t.toString().toLowerCase())?0:i.localeCompare(e)},u.sortDate=function(e,t){var i=u.handleNulls(e,t);return null!==i?i:(i=(e instanceof Date?e:new Date(e)).getTime())===(e=(t instanceof Date?t:new Date(t)).getTime())?0:i<e?-1:1},u.sortBool=function(e,t){var i=u.handleNulls(e,t);return null!==i?i:e&&t||!e&&!t?0:e?1:-1},u.getSortFn=function(e){var t;return u.colSortFnCache[e.colDef.name]||(null!=e.sortingAlgorithm?(u.colSortFnCache[e.colDef.name]=e.sortingAlgorithm,e.sortingAlgorithm):e.sortCellFiltered&&e.cellFilter?(u.colSortFnCache[e.colDef.name]=u.sortAlpha,u.sortAlpha):(t=u.guessSortFn(e.colDef.type))?u.colSortFnCache[e.colDef.name]=t:u.sortAlpha)},u.prioritySort=function(e,t){return e.sort&&void 0!==e.sort.priority&&t.sort&&void 0!==t.sort.priority?e.sort.priority<t.sort.priority?-1:e.sort.priority===t.sort.priority?0:1:e.sort&&void 0!==e.sort.priority?-1:t.sort&&void 0!==t.sort.priority?1:0},u.sort=function(a,e,t){if(e){if(a.options.useExternalSorting)return e;var l,s,d=[],i=[];if(t.forEach(function(e){!e.sort||e.sort.ignoreSort||!e.sort.direction||e.sort.direction!==c.ASC&&e.sort.direction!==c.DESC?e.defaultSort&&e.defaultSort.direction&&(e.defaultSort.direction===c.ASC||e.defaultSort.direction===c.DESC)&&i.push({col:e,sort:e.defaultSort}):d.push({col:e,sort:e.sort})}),d=d.sort(u.prioritySort),i=i.sort(u.prioritySort),0===(d=d.concat(i)).length)return e;e.forEach(function(e,t){e.entity.$$uiGridIndex=t});t=e.sort(function(e,t){for(var i=0,r=0;0===i&&r<d.length;){l=d[r].col,s=d[r].sort.direction;var n=u.getSortFn(l),o=function(e,t,i,r){var n;t=r.sortCellFiltered?(n=e.getCellDisplayValue(t,r),e.getCellDisplayValue(i,r)):(n=e.getCellValue(t,r),e.getCellValue(i,r));return[n,t]}(a,e,t,l),i=n(o[0],o[1],e,t,s,l);r++}return 0===i?e.entity.$$uiGridIndex-t.entity.$$uiGridIndex:s===c.ASC?i:0-i});return e.forEach(function(e,t){delete e.entity.$$uiGridIndex}),t}},u}]),function(){var C,e=angular.module("ui.grid");function w(e){var t=e;return(t=void 0!==t.length&&t.length?e[0]:t).ownerDocument.defaultView.getComputedStyle(t,null)}"function"!=typeof Function.prototype.bind&&(C=function(){var r=Array.prototype.slice;return function(e){var t=this,i=r.call(arguments,1);return i.length?function(){return arguments.length?t.apply(e,i.concat(r.call(arguments))):t.apply(e,i)}:function(){return arguments.length?t.apply(e,arguments):t.call(e)}}});var l=new RegExp("^("+/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source+")(?!px)[a-z%]+$","i"),b=/^(block|none|table(?!-c[ea]).+)/,y={position:"absolute",visibility:"hidden",display:"block"};function S(e,t,i,r,n){for(var o=i===(r?"border":"content")?4:"width"===t?1:0,a=0,l=["Top","Right","Bottom","Left"];o<4;o+=2){var s,d,c=l[o];"margin"===i&&(s=parseFloat(n[i+c]),isNaN(s)||(a+=s)),r?("content"===i&&(s=parseFloat(n["padding"+c]),isNaN(s)||(a-=s)),"margin"!==i&&(d=parseFloat(n["border"+c+"Width"]),isNaN(d)||(a-=d))):(d=parseFloat(n["padding"+c]),isNaN(d)||(a+=d),"padding"!==i&&(c=parseFloat(n["border"+c+"Width"]),isNaN(c)||(a+=c)))}return a}function x(e,t,i){var r,n=!0,o=w(e),a="border-box"===o.boxSizing;if(r<=0||null==r){if(((r=o[t])<0||null==r)&&(r=e.style[t]),l.test(r))return r;n=a&&!0,r=parseFloat(r)||0}return r+S(0,t,i||(a?"border":"content"),n,o)}var E=["0","0","0","0"],A="uiGrid-";e.service("gridUtil",["$log","$window","$document","$http","$templateCache","$timeout","$interval","$injector","$q","$interpolate","uiGridConstants",function(t,n,i,e,r,s,d,o,a,l,c){var u,g,p,f={augmentWidthOrHeight:S,getStyles:w,createBoundedWrapper:function(e,t){return function(){return t.apply(e,arguments)}},readableColumnName:function(e){return null==e?e:(e="string"!=typeof e?String(e):e).replace(/_+/g," ").replace(/^[A-Z]+$/,function(e){return e.toLowerCase()}).replace(/([\w\u00C0-\u017F]+)/g,function(e){return e.charAt(0).toUpperCase()+e.slice(1)}).replace(/(\w+?(?=[A-Z]))/g,"$1 ")},getColumnsFromData:function(e,i){var r=[];if(!e||void 0===e[0]||void 0===e[0])return[];angular.isUndefined(i)&&(i=[]);e=e[0];return angular.forEach(e,function(e,t){-1===i.indexOf(t)&&r.push({name:t})}),r},newId:(u=(new Date).getTime(),function(){return u+=1}),getTemplate:function(t){if(r.get(t))return f.postProcessTemplate(r.get(t));if(angular.isFunction(t.then))return t.then(f.postProcessTemplate).catch(angular.noop);try{if(0<angular.element(t).length)return a.when(t).then(f.postProcessTemplate).catch(angular.noop)}catch(e){}return e({method:"GET",url:t}).then(function(e){e=e.data.trim();return r.put(t,e),e},function(e){throw new Error("Could not get template "+t+": "+e)}).then(f.postProcessTemplate).catch(angular.noop)},postProcessTemplate:function(e){var t=l.startSymbol(),i=l.endSymbol();return"{{"===t&&"}}"===i||(e=(e=e.replace(/\{\{/g,t)).replace(/\}\}/g,i)),a.when(e)},guessType:function(e){var t=typeof e;switch(t){case"number":case"boolean":case"string":return t;default:return angular.isDate(e)?"date":"object"}},elementWidth:function(e){},elementHeight:function(e){},isVisible:function(e){return!!(e[0].offsetWidth||e[0].offsetHeight||e[0].getClientRects().length)},getScrollbarWidth:function(){var e=document.createElement("div"),t=(e.style.visibility="hidden",e.style.width="100px",e.style.msOverflowStyle="scrollbar",document.body.appendChild(e),e.offsetWidth),i=(e.style.overflow="scroll",e.style.position="absolute",document.createElement("div")),i=(i.style.width="100%",e.appendChild(i),i.offsetWidth);return e.parentNode.removeChild(e),t-i},swap:function(e,t,i,r){var n,o={};for(n in t)o[n]=e.style[n],e.style[n]=t[n];for(n in i=i.apply(e,r||[]),t)e.style[n]=o[n];return i},fakeElement:function(e,t,i,r){var n,o=angular.element(e).clone()[0];for(n in t)o.style[n]=t[n];return angular.element(document.body).append(o),e=i.call(o,o),angular.element(o).remove(),e},normalizeWheelEvent:function(e){var t,i,r=e||window.event,n=([].slice.call(arguments,1),0),o=0,a=0;return(r=r.originalEvent?r.originalEvent:r).wheelDelta&&(n=r.wheelDelta),a=n=r.detail?-1*r.detail:n,void 0!==r.axis&&r.axis===r.HORIZONTAL_AXIS&&(a=0,o=-1*n),r.deltaY&&(n=a=-1*r.deltaY),r.deltaX&&(n=-1*(o=r.deltaX)),void 0!==r.wheelDeltaY&&(a=r.wheelDeltaY),void 0!==r.wheelDeltaX&&(o=r.wheelDeltaX),r=Math.abs(n),(!t||r<t)&&(t=r),r=Math.max(Math.abs(a),Math.abs(o)),(!i||r<i)&&(i=r),r=0<n?"floor":"ceil",{delta:n=Math[r](n/t),deltaX:o=Math[r](o/i),deltaY:a=Math[r](a/i)}},isTouchEnabled:function(){var e;return e="ontouchstart"in n||n.DocumentTouch&&i instanceof DocumentTouch?!0:e},isNullOrUndefined:function(e){return null==e},endsWith:function(e,t){return!(!e||!t||"string"!=typeof e)&&-1!==e.indexOf(t,e.length-t.length)},arrayContainsObjectWithProperty:function(e,t,i){var r=!1;return angular.forEach(e,function(e){e[t]===i&&(r=!0)}),r},numericAndNullSort:function(e,t){return null===e?1:null===t?-1:null===e&&null===t?0:e-t},disableAnimations:function(e){var t;try{t=o.get("$animate"),1<angular.version.major||1===angular.version.major&&4<=angular.version.minor?t.enabled(e,!1):t.enabled(!1,e)}catch(e){}},enableAnimations:function(e){var t;try{return t=o.get("$animate"),1<angular.version.major||1===angular.version.major&&4<=angular.version.minor?t.enabled(e,!0):t.enabled(!0,e),t}catch(e){}},nextUid:function(){for(var e,t=E.length;t;){if(57===(e=E[--t].charCodeAt(0)))return E[t]="A",A+E.join("");if(90!==e)return E[t]=String.fromCharCode(e+1),A+E.join("");E[t]="0"}return E.unshift("0"),A+E.join("")},hashKey:function(e){var t,i=typeof e;return"object"==i&&null!==e?"function"==typeof(t=e.$$hashKey)?t=e.$$hashKey():void 0!==e.$$hashKey&&e.$$hashKey?t=e.$$hashKey:void 0===t&&(t=e.$$hashKey=f.nextUid()):t=e,i+": "+t},resetUids:function(){E=["0","0","0"]},logError:function(e){c.LOG_ERROR_MESSAGES&&t.error(e)},logWarn:function(e){c.LOG_WARN_MESSAGES&&t.warn(e)},logDebug:function(){c.LOG_DEBUG_MESSAGES&&t.debug.apply(t,arguments)}},m=(f.focus={queue:[],byId:function(i,r){this._purgeQueue();var e=s(function(){var e=(r&&r.id?r.id+"-":"")+i,t=n.document.getElementById(e);t?t.focus():f.logWarn("[focus.byId] Element id "+e+" was not found.")},0,!1);return this.queue.push(e),e},byElement:function(e){if(!angular.isElement(e))return f.logWarn("Trying to focus on an element that isn't an element."),a.reject("not-element");e=angular.element(e),this._purgeQueue();var t=s(function(){e&&e[0].focus()},0,!1);return this.queue.push(t),t},bySelector:function(t,i,e){var r=this;if(!angular.isElement(t))throw new Error("The parent element is not an element.");t=angular.element(t);function n(){var e=t[0].querySelector(i);return r.byElement(e)}return this._purgeQueue(),e?(e=s(n,0,!1),this.queue.push(e),e):n()},_purgeQueue:function(){this.queue.forEach(function(e){s.cancel(e)}),this.queue=[]}},["width","height"].forEach(function(r){var i=r.charAt(0).toUpperCase()+r.substr(1);f["element"+i]=function(e,t){var i=e;return(i=i&&void 0!==i.length&&i.length?e[0]:i)&&null!==i?(e=w(i),0===i.offsetWidth&&b.test(e.display)?f.swap(i,y,function(){return x(i,r,t)}):x(i,r,t)):null},f["outerElement"+i]=function(e,t){return e?f["element"+i].call(this,e,t?"margin":"border"):null}}),f.closestElm=function(e,t){var i,r;for(void 0!==e.length&&e.length&&(e=e[0]),["matches","webkitMatchesSelector","mozMatchesSelector","msMatchesSelector","oMatchesSelector"].some(function(e){return"function"==typeof document.body[e]&&(i=e,!0)});null!==e;){if(null!==(r=e.parentElement)&&r[i](t))return r;e=r}return null},f.type=function(e){return Function.prototype.toString.call(e.constructor).match(/function (.*?)\(/)[1]},f.getBorderSize=function(e,t){e=w(e=void 0!==e.length&&e.length?e[0]:e),t=t?"border"+t.charAt(0).toUpperCase()+t.slice(1):"border",t+="Width",e=parseInt(e[t],10);return isNaN(e)?0:e},f.detectBrowser=function(){var e,t=n.navigator.userAgent,i={chrome:/chrome/i,safari:/safari/i,firefox:/firefox/i,ie:/internet explorer|trident\//i};for(e in i)if(i[e].test(t))return e;return"unknown"},f.rtlScrollType=function e(){var t,i;return e.type||(t=angular.element('<div dir="rtl" style="width: 1px; height: 1px; position: fixed; top: 0px; left: 0px; overflow: hidden"><div style="width: 2px"><span style="display: inline-block; width: 1px"></span><span style="display: inline-block; width: 1px"></span></div></div>')[0],i="reverse",document.body.appendChild(t),0<t.scrollLeft?i="default":"undefined"!=typeof Element&&Element.prototype.scrollIntoView?(t.children[0].children[1].scrollIntoView(),t.scrollLeft<0&&(i="negative")):(t.scrollLeft=1,0===t.scrollLeft&&(i="negative")),angular.element(t).remove(),e.type=i)},f.normalizeScrollLeft=function(e,t){var i=(e=void 0!==e.length&&e.length?e[0]:e).scrollLeft;if(t.isRTL())switch(f.rtlScrollType()){case"default":return e.scrollWidth-i-e.clientWidth;case"negative":return Math.abs(i);case"reverse":return i}return i},f.denormalizeScrollLeft=function(e,t,i){if(void 0!==e.length&&e.length&&(e=e[0]),i.isRTL())switch(f.rtlScrollType()){case"default":return e.scrollWidth-e.clientWidth-t;case"negative":return-1*t;case"reverse":return t}return t},f.preEval=function(e){var t,i=c.BRACKET_REGEXP.exec(e);return i?(i[1]&&f.preEval(i[1]))+i[2]+(i[3]&&f.preEval(i[3])):(i=(e=e.replace(c.APOS_REGEXP,"\\'")).split(c.DOT_REGEXP),t=[i.shift()],angular.forEach(i,function(e){t.push(e.replace(c.FUNC_REGEXP,"']$1"))}),t.join("['"))},f.debounce=function(t,i,r){var n,o,a,l;function e(){a=this,o=arguments;var e=r&&!n;return n&&s.cancel(n),n=s(function(){n=null,r||(l=t.apply(a,o))},i,!1),l=e?t.apply(a,o):l}return e.cancel=function(){s.cancel(n),n=null},e},f.throttle=function(t,i,r){r=r||{};var n,o,a=0,l=null;function s(e){a=+new Date,t.apply(n,o),d(function(){l=null},0,1,!1)}return function(){var e;n=this,o=arguments,null===l&&(e=+new Date-a,i<e?s():r.trailing&&(l=d(s,i-e,1,!1)))}},f.on={},f.off={},f._events={},f.addOff=function(i){f.off[i]=function(e,t){t=f._events[i].indexOf(t);0<t&&f._events[i].removeAt(t)}},"onwheel"in document||9<=document.documentMode?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"]);function h(e,t){var i,r=angular.element(this),n=0,o=0,a=0;"detail"in(t=t.originalEvent?t.originalEvent:t)&&(a=-1*t.detail),"wheelDelta"in t&&(a=t.wheelDelta),"wheelDeltaY"in t&&(a=t.wheelDeltaY),"wheelDeltaX"in t&&(o=-1*t.wheelDeltaX),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(o=-1*a,a=0),n=0===a?o:a,"deltaY"in t&&(n=a=-1*t.deltaY),"deltaX"in t&&(o=t.deltaX,0===a)&&(n=-1*o),0===a&&0===o||(1===t.deltaMode?(n*=i=r.data("mousewheel-line-height"),a*=i,o*=i):2===t.deltaMode&&(n*=i=r.data("mousewheel-page-height"),a*=i,o*=i),i=Math.max(Math.abs(a),Math.abs(o)),(!p||i<p)&&(i=p=i,"mousewheel"===t.type)&&i%120==0&&(p/=40),n=Math[1<=n?"floor":"ceil"](n/p),o=Math[1<=o?"floor":"ceil"](o/p),a=Math[1<=a?"floor":"ceil"](a/p),n={originalEvent:t,deltaX:o,deltaY:a,deltaFactor:p,preventDefault:function(){t.preventDefault()},stopPropagation:function(){t.stopPropagation()}},g&&clearTimeout(g),g=setTimeout(v,200),e.call(r[0],n))}function v(){p=null}return f.on.mousewheel=function(e,t){if(e&&t){var i,r=angular.element(e),n=(r.data("mousewheel-line-height",(e=r,i=(i=(e=angular.element(e)[0]).parentElement)||document.getElementsByTagName("body")[0],parseInt(w(i).fontSize)||parseInt(w(e).fontSize)||16)),r.data("mousewheel-page-height",f.elementHeight(r)),r.data("mousewheel-callbacks")||r.data("mousewheel-callbacks",{}),r.data("mousewheel-callbacks"));n[t]=(Function.prototype.bind||C).call(h,r[0],t);for(var o=m.length;o;)r.on(m[--o],n[t]);r.on("$destroy",function(){for(var e=m.length;e;)r.off(m[--e],n[t])})}},f.off.mousewheel=function(e,t){var i=angular.element(e),e=i.data("mousewheel-callbacks"),r=e[t];if(r)for(var n=m.length;n;)i.off(m[--n],r);delete e[t],0===Object.keys(e).length&&(i.removeData("mousewheel-line-height"),i.removeData("mousewheel-page-height"),i.removeData("mousewheel-callbacks"))},f}]),e.filter("px",function(){return function(e){return e.match(/^[\d\.]+$/)?e+"px":e}})}(),function(){var u=["uiT","uiTranslate"],t=angular.module("ui.grid.i18n");function i(d,c){return{restrict:"EA",compile:function(){return{pre:function(e,t,i){var r,n,o=u[0],a=u[1],l=i[o]||i[a]||t.html();function s(e){e=d.getSafeText(e);t.html(e)}i.$$observers&&(n=i[o]?o:a,r=i.$observe(n,function(e){e&&s(e)})),n=e.$on(c.UPDATE_EVENT,function(){r?r(i[o]||i[a]):s(l)}),e.$on("$destroy",n),s(l)}}}}}function r(i){return function(e,t){return i.getSafeText(e,t)}}t.constant("i18nConstants",{MISSING:"[MISSING]",UPDATE_EVENT:"$uiI18n",LOCALE_DIRECTIVE_ALIAS:"uiI18n",DEFAULT_LANG:"en"}),t.service("i18nService",["$log","$parse","i18nConstants","$rootScope",function(t,r,i,n){var o={_langs:{},current:null,fallback:i.DEFAULT_LANG,get:function(e){var t=this,i=t.getFallbackLang();return e!==t.fallback?angular.extend({},t._langs[i],t._langs[e.toLowerCase()]):t._langs[e.toLowerCase()]},add:function(e,t){e=e.toLowerCase();this._langs[e]||(this._langs[e]={}),angular.merge(this._langs[e],t)},getAllLangs:function(){var e=[];if(this._langs)for(var t in this._langs)e.push(t);return e},setCurrent:function(e){this.current=e.toLowerCase()},setFallback:function(e){this.fallback=e.toLowerCase()},getCurrentLang:function(){return this.current},getFallbackLang:function(){return this.fallback.toLowerCase()}};function a(e){return t.warn(i.MISSING+e),""}var l={add:function(e,t){"object"==typeof e?angular.forEach(e,function(e){e&&o.add(e,t)}):o.add(e,t)},getAllLangs:function(){return o.getAllLangs()},get:function(e){e=e||l.getCurrentLang();return o.get(e)},getSafeText:function(e,t){var t=t||l.getCurrentLang(),t=o.get(t),i=r(e);return t&&i(t)||a(e)},setCurrentLang:function(e){e&&(o.setCurrent(e),n.$broadcast(i.UPDATE_EVENT))},setFallbackLang:function(e){e&&o.setFallback(e)},getCurrentLang:function(){var e=o.getCurrentLang();return e||(e=i.DEFAULT_LANG,o.setCurrent(e)),e},getFallbackLang:function(){return o.getFallbackLang()}};return l}]),t.directive("uiI18n",["i18nService","i18nConstants",function(o,a){return{compile:function(){return{pre:function(e,t,i){var r=a.LOCALE_DIRECTIVE_ALIAS,n=e.$eval(i[r]);n?e.$watch(i[r],function(){o.setCurrentLang(n)}):i.$$observers&&i.$observe(r,function(){o.setCurrentLang(i[r]||a.DEFAULT_LANG)})}}}}}]),angular.forEach(u,function(e){t.directive(e,["i18nService","i18nConstants",i])}),angular.forEach(["t","uiTranslate"],function(e){t.filter(e,["i18nService",r])})}(),function(){"use strict";var e=angular.module("ui.grid.edit",["ui.grid"]);e.constant("uiGridEditConstants",{EDITABLE_CELL_TEMPLATE:/EDITABLE_CELL_TEMPLATE/g,EDITABLE_CELL_DIRECTIVE:/editable_cell_directive/g,events:{BEGIN_CELL_EDIT:"uiGridEventBeginCellEdit",END_CELL_EDIT:"uiGridEventEndCellEdit",CANCEL_CELL_EDIT:"uiGridEventCancelCellEdit"}}),e.service("uiGridEditService",["$q","uiGridConstants","gridUtil",function(n,t,o){var i={initializeGrid:function(e){i.defaultGridOptions(e.options),e.registerColumnBuilder(i.editColumnBuilder),e.edit={};e.api.registerEventsFromObject({edit:{afterCellEdit:function(e,t,i,r){},beginCellEdit:function(e,t,i){},cancelCellEdit:function(e,t){}}})},defaultGridOptions:function(e){e.cellEditableCondition=void 0===e.cellEditableCondition||e.cellEditableCondition,e.enableCellEditOnFocus=void 0!==e.enableCellEditOnFocus&&e.enableCellEditOnFocus},editColumnBuilder:function(t,i,e){var r=[];return t.enableCellEdit=void 0===t.enableCellEdit?void 0===e.enableCellEdit?"object"!==t.type:e.enableCellEdit:t.enableCellEdit,t.cellEditableCondition=(void 0===t.cellEditableCondition?e:t).cellEditableCondition,t.enableCellEdit&&(t.editableCellTemplate=t.editableCellTemplate||e.editableCellTemplate||"ui-grid/cellEditor",r.push(o.getTemplate(t.editableCellTemplate).then(function(e){i.editableCellTemplate=e},function(e){throw new Error("Couldn't fetch/use colDef.editableCellTemplate '"+t.editableCellTemplate+"'")}))),t.enableCellEditOnFocus=(void 0===t.enableCellEditOnFocus?e:t).enableCellEditOnFocus,n.all(r)},isStartEditKey:function(e){return!(e.metaKey||e.keyCode===t.keymap.ESC||e.keyCode===t.keymap.SHIFT||e.keyCode===t.keymap.CTRL||e.keyCode===t.keymap.ALT||e.keyCode===t.keymap.WIN||e.keyCode===t.keymap.CAPSLOCK||e.keyCode===t.keymap.LEFT||e.keyCode===t.keymap.TAB&&e.shiftKey||e.keyCode===t.keymap.RIGHT||e.keyCode===t.keymap.TAB||e.keyCode===t.keymap.UP||e.keyCode===t.keymap.ENTER&&e.shiftKey||e.keyCode===t.keymap.DOWN||e.keyCode===t.keymap.ENTER)}};return i}]),e.directive("uiGridEdit",["gridUtil","uiGridEditService",function(e,n){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){n.initializeGrid(r.grid)},post:function(e,t,i,r){}}}}}]),e.directive("uiGridViewport",["uiGridEditConstants",function(o){return{replace:!0,priority:-99998,require:["^uiGrid","^uiGridRenderContainer"],scope:!1,compile:function(){return{post:function(e,t,i,r){var n=r[0];n.grid.api.edit&&n.grid.api.cellNav&&"body"===r[1].containerId&&(e.$on(o.events.CANCEL_CELL_EDIT,function(){n.focus()}),e.$on(o.events.END_CELL_EDIT,function(){n.focus()}))}}}}}]),e.directive("uiGridCell",["$compile","$injector","$timeout","uiGridConstants","uiGridEditConstants","gridUtil","$parse","uiGridEditService","$rootScope","$q",function(y,e,S,x,E,A,R,F,T,P){return e.has("uiGridCellNavService")&&e.get("uiGridCellNavService"),{priority:-100,restrict:"A",scope:!1,require:"?^uiGrid",link:function(l,s,e,r){var d,c,u,t,g,i,n,o,a,p=!1;function f(){s.on("dblclick",w),s.on("touchstart",m),r&&r.grid.api.cellNav&&(n=r.grid.api.cellNav.on.viewPortKeyDown(l,function(e,t){null===t||t.row!==l.row||t.col!==l.col||l.col.colDef.enableCellEditOnFocus||C(e)}),i=r.grid.api.cellNav.on.navigate(l,function(e,t,i){!l.col.colDef.enableCellEditOnFocus||e.row!==l.row||e.col!==l.col||null!==i&&(!i||"click"!==i.type&&"keydown"!==i.type)||S(function(){w(i)})})),l.beginEditEventsWired=!0}function m(e){void 0!==e.originalEvent&&void 0!==e.originalEvent&&(e=e.originalEvent),s.on("touchend",h),(t=S(function(){},500)).then(function(){setTimeout(w,0),s.off("touchend",h)}).catch(angular.noop)}function h(){S.cancel(t),s.off("touchend",h)}function v(){s.off("dblclick",w),s.off("keydown",C),s.off("touchstart",m),i(),n(),l.beginEditEventsWired=!1}function C(e){F.isStartEditKey(e)&&w(e)}function w(a){l.grid.api.core.scrollToIfNecessary(l.row,l.col).then(function(){var e=a;if(!p&&function(e,t,i){return!t.isSaving&&(angular.isFunction(e.colDef.cellEditableCondition)?e.colDef.cellEditableCondition(l,i):e.colDef.cellEditableCondition)}(l.col,l.row,e)){var t=l.row.getQualifiedColField(l.col),t=(l.col.colDef.editModelField&&(t=A.preEval("row.entity."+l.col.colDef.editModelField)),u=R(t),c=u(l),d=(d=(d=l.col.editableCellTemplate).replace(x.MODEL_COL_FIELD,t)).replace(x.COL_FIELD,"grid.getCellValue(row, col)"),l.col.colDef.editDropdownFilter?"|"+l.col.colDef.editDropdownFilter:""),i=(d=d.replace(x.CUSTOM_FILTERS,t),"text");switch(l.col.colDef.type){case"boolean":i="checkbox";break;case"number":i="number";break;case"date":i="date"}d=d.replace("INPUT_TYPE",i);var t=l.col.colDef.editDropdownOptionsFunction,t=(t?P.when(t(l.row.entity,l.col.colDef)).then(function(e){l.editDropdownOptionsArray=e}):(t=l.col.colDef.editDropdownRowEntityOptionsArrayPath,l.editDropdownOptionsArray=t?function(e,t){var i=(t=(t=t.replace(/\[(\w+)\]/g,".$1")).replace(/^\./,"")).split(".");for(;i.length;){var r=i.shift();if(!(r in e))return;e=e[r]}return e}(l.row.entity,t):l.col.colDef.editDropdownOptionsArray),l.editDropdownIdLabel=l.col.colDef.editDropdownIdLabel||"id",l.editDropdownValueLabel=l.col.colDef.editDropdownValueLabel||"value",function(){p=!0,v();var e=angular.element(d);s.append(e),g=l.$new(),y(e)(g),angular.element(s.children()[0]).addClass("ui-grid-cell-contents-hidden")}),r=(T.$$phase?t():l.$apply(t),l.col.grid.api.core.on.scrollBegin(l,function(){l.grid.disableScrolling||(b(),l.grid.api.edit.raise.afterCellEdit(l.row.entity,l.col.colDef,u(l),c),r(),n(),o())})),n=l.$on(E.events.END_CELL_EDIT,function(){b(),l.grid.api.edit.raise.afterCellEdit(l.row.entity,l.col.colDef,u(l),c),n(),r(),o()}),o=l.$on(E.events.CANCEL_CELL_EDIT,function(){l.grid.disableScrolling=!1,p&&(u.assign(l,c),l.$apply(),l.grid.api.edit.raise.cancelCellEdit(l.row.entity,l.col.colDef),b()),o(),r(),n()});l.$broadcast(E.events.BEGIN_CELL_EDIT,e),S(function(){l.grid.api.edit.raise.beginCellEdit(l.row.entity,l.col.colDef,e)})}})}function b(){if(l.grid.disableScrolling=!1,p){r&&r.grid.api.cellNav&&r.focus();for(var e=angular.element(s.children()[0]),t=(g.$destroy(),s.children()),i=1;i<t.length;i++)angular.element(t[i]).remove();e.removeClass("ui-grid-cell-contents-hidden"),p=!1,f(),l.grid.api.core.notifyDataChange(x.dataChange.EDIT)}}l.col.colDef.enableCellEdit&&(i=function(){},n=function(){},(o=function(){l.col.colDef.enableCellEdit&&!1!==l.row.enableCellEdit?l.beginEditEventsWired||f():l.beginEditEventsWired&&v()})(),a=l.$watch("row",function(e,t){e!==t&&o()}),l.$on("$destroy",function(){a(),s.off()}))}}}]),e.directive("uiGridEditor",["gridUtil","uiGridConstants","uiGridEditConstants","$timeout","uiGridEditService",function(e,l,s,d,c){return{scope:!0,require:["?^uiGrid","?^uiGridRenderContainer","ngModel"],compile:function(){return{pre:function(e,t,i){},post:function(t,i,e,r){var n,o,a;r[0]&&(n=r[0]),r[1]&&(o=r[1]),r[2]&&(a=r[2]),t.$on(s.events.BEGIN_CELL_EDIT,function(){var r;d(function(){if(i[0].focus(),!i[0].select||!t.col.colDef.enableCellEditOnFocus&&n&&n.grid.api.cellNav)try{i[0].setSelectionRange(i[0].value.length,i[0].value.length)}catch(e){}else i[0].select()}),n&&n.grid.api.cellNav&&(r=n.grid.api.cellNav.on.viewPortKeyPress(t,function(e,t){var i;c.isStartEditKey(e)&&0<(i="number"==typeof e.which?e.which:e.keyCode)&&(a.$setViewValue(String.fromCharCode(i),e),a.$render()),r()})),i.on("mousedown",function(e){"checkbox"===i[0].type&&(i.off("blur",t.stopEdit),d(function(){i[0].focus(),i.on("blur",t.stopEdit)}))}),i[0]&&i[0].focus(),i.on("blur",t.stopEdit)}),t.deepEdit=!1,t.stopEdit=function(e){t.inputForm&&!t.inputForm.$valid?(e.stopPropagation(),t.$emit(s.events.CANCEL_CELL_EDIT)):t.$emit(s.events.END_CELL_EDIT),t.deepEdit=!1},i.on("click",function(e){"checkbox"!==i[0].type&&(t.deepEdit=!0,t.$applyAsync(function(){t.grid.disableScrolling=!0}))}),i.on("keydown",function(e){if(e.keyCode===l.keymap.ESC&&(e.stopPropagation(),t.$emit(s.events.CANCEL_CELL_EDIT)),!t.deepEdit||e.keyCode!==l.keymap.LEFT&&e.keyCode!==l.keymap.RIGHT&&e.keyCode!==l.keymap.UP&&e.keyCode!==l.keymap.DOWN)if(n&&n.grid.api.cellNav)e.uiGridTargetRenderContainerId=o.containerId,null!==n.cellNav.handleKeyDown(e)&&t.stopEdit(e);else switch(e.keyCode){case l.keymap.ENTER:case l.keymap.TAB:e.stopPropagation(),e.preventDefault(),t.stopEdit(e)}else e.stopPropagation();return!0}),t.$on("$destroy",function(){i.off()})}}}}}]),e.directive("uiGridEditor",["$filter",function(n){return{priority:-100,require:"?ngModel",link:function(e,t,i,r){2===angular.version.minor&&i.type&&"date"===i.type&&r&&(r.$formatters.push(function(e){return r.$setValidity(null,!e||!isNaN(e.getTime())),n("date")(e,"yyyy-MM-dd")}),r.$parsers.push(function(e){var t,i;return e&&0<e.length?(t=void 0===(e=e)||""===e||3!==(e=e.split("-")).length||(t=parseInt(e[0],10),i=parseInt(e[1],10),e=parseInt(e[2],10),i<1)||t<1||e<1?null:new Date(t,i-1,e),r.$setValidity(null,t&&!isNaN(t.getTime())),t):(r.$setValidity(null,!0),null)}))}}}]),e.directive("uiGridEditDropdown",["uiGridConstants","uiGridEditConstants","$timeout",function(a,l,s){return{require:["?^uiGrid","?^uiGridRenderContainer"],scope:!0,compile:function(){return{pre:function(e,t,i){},post:function(t,e,i,r){var n=r[0],o=r[1];t.$on(l.events.BEGIN_CELL_EDIT,function(){s(function(){e[0].focus()}),e[0].style.width=e[0].parentElement.offsetWidth-1+"px",e.on("blur",function(e){t.stopEdit(e)})}),t.stopEdit=function(e){t.$emit(l.events.END_CELL_EDIT)},e.on("keydown",function(e){if(e.keyCode===a.keymap.ESC&&(e.stopPropagation(),t.$emit(l.events.CANCEL_CELL_EDIT)),n&&n.grid.api.cellNav)e.uiGridTargetRenderContainerId=o.containerId,null!==n.cellNav.handleKeyDown(e)&&t.stopEdit(e);else switch(e.keyCode){case a.keymap.ENTER:case a.keymap.TAB:e.stopPropagation(),e.preventDefault(),t.stopEdit(e)}return!0}),t.$on("$destroy",function(){e.off()})}}}}}]),e.directive("uiGridEditFileChooser",["gridUtil","uiGridConstants","uiGridEditConstants",function(n,e,o){return{scope:!0,require:["?^uiGrid","?^uiGridRenderContainer"],compile:function(){return{pre:function(e,t,i){},post:function(i,r){r[0].addEventListener("change",function e(t){t=t.srcElement||t.target;t&&t.files&&0<t.files.length?("function"==typeof i.col.colDef.editFileChooserCallback?i.col.colDef.editFileChooserCallback(i.row,i.col,t.files):n.logError("You need to set colDef.editFileChooserCallback to use the file chooser"),t.form.reset(),i.$emit(o.events.END_CELL_EDIT)):i.$emit(o.events.CANCEL_CELL_EDIT),r[0].removeEventListener("change",e,!1)},!1),i.$on(o.events.BEGIN_CELL_EDIT,function(){r[0].focus(),r[0].select(),r.on("blur",function(){i.$emit(o.events.END_CELL_EDIT),r.off()})})}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.emptyBaseLayer",["ui.grid"]);e.service("uiGridBaseLayerService",["gridUtil","$compile",function(e,t){return{initializeGrid:function(e,t){!(e.baseLayer={emptyRows:[]})!==e.options.enableEmptyGridBaseLayer&&(e.options.enableEmptyGridBaseLayer=!t)},setNumberOfEmptyRows:function(e,t){var i=t.options.rowHeight,r=Math.ceil(e/i);if(0<r){t.baseLayer.emptyRows=[];for(var n=0;n<r;n++)t.baseLayer.emptyRows.push({})}}}}]),e.directive("uiGridEmptyBaseLayer",["gridUtil","uiGridBaseLayerService","$parse",function(e,a,n){return{require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){i=!1===n(i.uiGridEmptyBaseLayer)(e);a.initializeGrid(r.grid,i)},post:function(e,t,i,r){var n,o;r.grid.options.enableEmptyGridBaseLayer&&(n=r.grid.renderContainers.body,o=n.getViewportHeight(),r.grid.registerStyleComputation({func:function(){var e;return(e=n.getViewportHeight())!==o&&(o=e,1)&&a.setNumberOfEmptyRows(o,r.grid),e=o,".grid"+r.grid.id+" .ui-grid-render-container .ui-grid-empty-base-layer-container.ui-grid-canvas { height: "+e+"px; }"}}))}}}}}]),e.directive("uiGridViewport",["$compile","gridUtil","$templateCache",function(e,t,i){return{priority:-200,scope:!1,compile:function(e){var t=i.get("ui-grid/emptyBaseLayerContainer");return e.prepend(t),{pre:function(e,t,i,r){},post:function(e,t,i,r){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.expandable",["ui.grid"]);e.service("uiGridExpandableService",["gridUtil",function(r){var n={initializeGrid:function(i){i.expandable={},i.expandable.expandedAll=!1,i.options.enableOnDblClickExpand=!1!==i.options.enableOnDblClickExpand,i.options.enableExpandable=!1!==i.options.enableExpandable,i.options.showExpandAllButton=!1!==i.options.showExpandAllButton,i.options.expandableRowHeight=i.options.expandableRowHeight||150,i.options.expandableRowHeaderWidth=i.options.expandableRowHeaderWidth||40,i.options.enableExpandable&&!i.options.expandableRowTemplate&&(r.logError("You have not set the expandableRowTemplate, disabling expandable module"),i.options.enableExpandable=!1);var e={expandable:{rowExpandedBeforeStateChanged:function(e,t,i){},rowExpandedStateChanged:function(e,t,i){},rowExpandedRendered:function(e,t,i){}}},t={expandable:{toggleRowExpansion:function(e,t){e=i.getRow(e);null!==e&&n.toggleRowExpansion(i,e,t)},expandAllRows:function(){n.expandAllRows(i)},collapseAllRows:function(){n.collapseAllRows(i)},toggleAllRows:function(){n.toggleAllRows(i)},expandRow:function(e){e=i.getRow(e);null===e||e.isExpanded||n.toggleRowExpansion(i,e)},collapseRow:function(e){e=i.getRow(e);null!==e&&e.isExpanded&&n.toggleRowExpansion(i,e)},getExpandedRows:function(){return n.getExpandedRows(i).map(function(e){return e.entity})}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(t)},toggleRowExpansion:function(t,i,r){t.api.expandable.raise.rowExpandedBeforeStateChanged(i),i.isExpanded=!i.isExpanded,angular.isUndefined(i.expandedRowHeight)&&(i.expandedRowHeight=t.options.expandableRowHeight),i.isExpanded?(i.height=i.grid.options.rowHeight+i.expandedRowHeight,t.expandable.expandedAll=n.getExpandedRows(t).length===t.rows.length):(i.height=i.grid.options.rowHeight,t.expandable.expandedAll=!1),t.api.expandable.raise.rowExpandedStateChanged(i,r),function e(){i.expandedRendered?t.api.expandable.raise.rowExpandedRendered(i,r):window.setTimeout(e,100)}()},expandAllRows:function(t){t.renderContainers.body.visibleRowCache.forEach(function(e){e.isExpanded||e.entity.subGridOptions&&e.entity.subGridOptions.disableRowExpandable||n.toggleRowExpansion(t,e)}),t.expandable.expandedAll=!0,t.queueGridRefresh()},collapseAllRows:function(t){t.renderContainers.body.visibleRowCache.forEach(function(e){e.isExpanded&&n.toggleRowExpansion(t,e)}),t.expandable.expandedAll=!1,t.queueGridRefresh()},toggleAllRows:function(e){e.expandable.expandedAll?n.collapseAllRows(e):n.expandAllRows(e)},getExpandedRows:function(e){return e.rows.filter(function(e){return e.isExpanded})}};return n}]),e.directive("uiGridExpandable",["uiGridExpandableService","$templateCache",function(o,a){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){var n;o.initializeGrid(r.grid),r.grid.options.enableExpandable&&!1!==r.grid.options.enableExpandableRowHeader&&((n={name:"expandableButtons",displayName:"",exporterSuppressExport:!0,enableColumnResizing:!1,enableColumnMenu:!1,width:r.grid.options.expandableRowHeaderWidth||30}).cellTemplate=a.get("ui-grid/expandableRowHeader"),n.headerCellTemplate=a.get("ui-grid/expandableTopRowHeader"),r.grid.addRowHeaderColumn(n,-90))},post:function(e,t,i,r){}}}}}]),e.directive("uiGrid",function(){return{replace:!0,priority:599,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){r.grid.api.core.on.renderingComplete(e,function(){e.row&&e.row.grid&&e.row.grid.options&&e.row.grid.options.enableExpandable&&(r.grid.parentRow=e.row)})},post:function(e,t,i,r){}}}}}),e.directive("uiGridExpandableRow",["uiGridExpandableService","$compile","uiGridConstants","gridUtil",function(e,o,t,i){return{replace:!1,priority:0,scope:!1,compile:function(){return{pre:function(r,n){i.getTemplate(r.grid.options.expandableRowTemplate).then(function(e){if(r.grid.options.expandableRowScope){var t,i=r.grid.options.expandableRowScope;for(t in i)i.hasOwnProperty(t)&&(r[t]=i[t])}e=angular.element(e),e=o(e)(r);n.append(e),r.row.element=n,r.row.expandedRendered=!0})},post:function(e,t){e.row.element=t,e.$on("$destroy",function(){e.row.expandedRendered=!1})}}}}}]),e.directive("uiGridRow",function(){return{priority:-200,scope:!1,compile:function(){return{pre:function(t,e){t.grid.options.enableExpandable&&(t.expandableRow={},t.expandableRow.shouldRenderExpand=function(){return"body"===t.colContainer.name&&!1!==t.grid.options.enableExpandable&&t.row.isExpanded&&(!t.grid.isScrollingVertically||t.row.expandedRendered)},t.expandableRow.shouldRenderFiller=function(){return t.row.isExpanded&&("body"!==t.colContainer.name||t.grid.isScrollingVertically&&!t.row.expandedRendered)},t.grid.options.enableOnDblClickExpand)&&e.on("dblclick",function(e){t.grid.api.expandable.toggleRowExpansion(t.row.entity,e)})},post:function(e,t,i,r){}}}}}),e.directive("uiGridViewport",["$compile","gridUtil","$templateCache",function(e,t,r){return{priority:-200,scope:!1,compile:function(e){var e=angular.element(e.children().children()[0]),t=r.get("ui-grid/expandableScrollFiller"),i=r.get("ui-grid/expandableRow");return e.append(i),e.append(t),{pre:function(e,t,i,r){},post:function(e,t,i,r){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.exporter",["ui.grid"]);e.constant("uiGridExporterConstants",{featureName:"exporter",rowHeaderColName:"treeBaseRowHeaderCol",selectionRowHeaderColName:"selectionRowHeaderCol",ALL:"all",VISIBLE:"visible",SELECTED:"selected",CSV_CONTENT:"CSV_CONTENT",BUTTON_LABEL:"BUTTON_LABEL",FILE_NAME:"FILE_NAME"}),e.service("uiGridExporterService",["$filter","$q","uiGridExporterConstants","gridUtil","$compile","$interval","i18nService",function(a,r,u,c,e,n,t){var g={delay:100,type:null,initializeGrid:function(i){i.exporter={},this.defaultGridOptions(i.options);var e={exporter:{}},t={exporter:{csvExport:function(e,t){g.csvExport(i,e,t)},pdfExport:function(e,t){g.pdfExport(i,e,t)},excelExport:function(e,t){g.excelExport(i,e,t)}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(t),i.api.core.addToGridMenu?g.addToMenu(i):n(function(){i.api.core.addToGridMenu&&g.addToMenu(i)},this.delay,1)},defaultGridOptions:function(e){e.exporterSuppressMenu=!0===e.exporterSuppressMenu,e.exporterMenuLabel=e.exporterMenuLabel||"Export",e.exporterSuppressColumns=e.exporterSuppressColumns||[],e.exporterCsvColumnSeparator=e.exporterCsvColumnSeparator||",",e.exporterCsvFilename=e.exporterCsvFilename||"download.csv",e.exporterPdfFilename=e.exporterPdfFilename||"download.pdf",e.exporterExcelFilename=e.exporterExcelFilename||"download.xlsx",e.exporterExcelSheetName=e.exporterExcelSheetName||"Sheet1",e.exporterOlderExcelCompatibility=!0===e.exporterOlderExcelCompatibility,e.exporterIsExcelCompatible=!0===e.exporterIsExcelCompatible,e.exporterMenuItemOrder=e.exporterMenuItemOrder||200,e.exporterPdfDefaultStyle=e.exporterPdfDefaultStyle||{fontSize:11},e.exporterPdfTableStyle=e.exporterPdfTableStyle||{margin:[0,5,0,15]},e.exporterPdfTableHeaderStyle=e.exporterPdfTableHeaderStyle||{bold:!0,fontSize:12,color:"black"},e.exporterPdfHeader=e.exporterPdfHeader||null,e.exporterPdfFooter=e.exporterPdfFooter||null,e.exporterPdfOrientation=e.exporterPdfOrientation||"landscape",e.exporterPdfPageSize=e.exporterPdfPageSize||"A4",e.exporterPdfMaxGridWidth=e.exporterPdfMaxGridWidth||720,e.exporterMenuAllData=void 0===e.exporterMenuAllData||e.exporterMenuAllData,e.exporterMenuVisibleData=void 0===e.exporterMenuVisibleData||e.exporterMenuVisibleData,e.exporterMenuSelectedData=void 0===e.exporterMenuSelectedData||e.exporterMenuSelectedData,e.exporterMenuCsv=void 0===e.exporterMenuCsv||e.exporterMenuCsv,e.exporterMenuPdf=void 0===e.exporterMenuPdf||e.exporterMenuPdf,e.exporterMenuExcel=void 0===e.exporterMenuExcel||e.exporterMenuExcel,e.exporterPdfCustomFormatter=e.exporterPdfCustomFormatter&&"function"==typeof e.exporterPdfCustomFormatter?e.exporterPdfCustomFormatter:function(e){return e},e.exporterHeaderFilterUseName=!0===e.exporterHeaderFilterUseName,e.exporterFieldCallback=e.exporterFieldCallback||i,e.exporterFieldFormatCallback=e.exporterFieldFormatCallback||function(e,t,i,r){return null},e.exporterExcelCustomFormatters=e.exporterExcelCustomFormatters||function(e,t,i){return i},e.exporterExcelHeader=e.exporterExcelHeader||function(e,t,i,r){return null},e.exporterColumnScaleFactor=e.exporterColumnScaleFactor||3.5,e.exporterFieldApplyFilters=!0===e.exporterFieldApplyFilters,e.exporterAllDataFn=e.exporterAllDataFn||null,null===e.exporterAllDataFn&&e.exporterAllDataPromise&&(e.exporterAllDataFn=e.exporterAllDataPromise)},addToMenu:function(e){e.api.core.addToGridMenu(e,[{title:t.getSafeText("gridMenu.exporterAllAsCsv"),action:function(){e.api.exporter.csvExport(u.ALL,u.ALL)},shown:function(){return e.options.exporterMenuCsv&&e.options.exporterMenuAllData},order:e.options.exporterMenuItemOrder},{title:t.getSafeText("gridMenu.exporterVisibleAsCsv"),action:function(){e.api.exporter.csvExport(u.VISIBLE,u.VISIBLE)},shown:function(){return e.options.exporterMenuCsv&&e.options.exporterMenuVisibleData},order:e.options.exporterMenuItemOrder+1},{title:t.getSafeText("gridMenu.exporterSelectedAsCsv"),action:function(){e.api.exporter.csvExport(u.SELECTED,u.VISIBLE)},shown:function(){return e.options.exporterMenuCsv&&e.options.exporterMenuSelectedData&&e.api.selection&&0<e.api.selection.getSelectedRows().length},order:e.options.exporterMenuItemOrder+2},{title:t.getSafeText("gridMenu.exporterAllAsPdf"),action:function(){e.api.exporter.pdfExport(u.ALL,u.ALL)},shown:function(){return e.options.exporterMenuPdf&&e.options.exporterMenuAllData},order:e.options.exporterMenuItemOrder+3},{title:t.getSafeText("gridMenu.exporterVisibleAsPdf"),action:function(){e.api.exporter.pdfExport(u.VISIBLE,u.VISIBLE)},shown:function(){return e.options.exporterMenuPdf&&e.options.exporterMenuVisibleData},order:e.options.exporterMenuItemOrder+4},{title:t.getSafeText("gridMenu.exporterSelectedAsPdf"),action:function(){e.api.exporter.pdfExport(u.SELECTED,u.VISIBLE)},shown:function(){return e.options.exporterMenuPdf&&e.options.exporterMenuSelectedData&&e.api.selection&&0<e.api.selection.getSelectedRows().length},order:e.options.exporterMenuItemOrder+5},{title:t.getSafeText("gridMenu.exporterAllAsExcel"),action:function(){e.api.exporter.excelExport(u.ALL,u.ALL)},shown:function(){return e.options.exporterMenuExcel&&e.options.exporterMenuAllData},order:e.options.exporterMenuItemOrder+6},{title:t.getSafeText("gridMenu.exporterVisibleAsExcel"),action:function(){e.api.exporter.excelExport(u.VISIBLE,u.VISIBLE)},shown:function(){return e.options.exporterMenuExcel&&e.options.exporterMenuVisibleData},order:e.options.exporterMenuItemOrder+7},{title:t.getSafeText("gridMenu.exporterSelectedAsExcel"),action:function(){e.api.exporter.excelExport(u.SELECTED,u.VISIBLE)},shown:function(){return e.options.exporterMenuExcel&&e.options.exporterMenuSelectedData&&e.api.selection&&0<e.api.selection.getSelectedRows().length},order:e.options.exporterMenuItemOrder+8}])},csvExport:function(i,r,n){var o=this;o.type="csv",this.loadAllDataIfNeeded(i,r,n).then(function(){var e=i.options.showHeader?o.getColumnHeaders(i,n):[],t=o.getData(i,r,n),e=o.formatAsCsv(e,t,i.options.exporterCsvColumnSeparator),t=angular.isFunction(i.options.exporterCsvFilename)?i.options.exporterCsvFilename(i,r,n):i.options.exporterCsvFilename;o.downloadFile(t,e,i.options.exporterCsvColumnSeparator,i.options.exporterOlderExcelCompatibility,i.options.exporterIsExcelCompatible)})},loadAllDataIfNeeded:function(t,e,i){return e===u.ALL&&t.rows.length!==t.options.totalItems&&t.options.exporterAllDataFn?t.options.exporterAllDataFn().then(function(e){t.modifyRows(e)}):((e=r.defer()).resolve(),e.promise)},getColumnHeaders:function(t,e){var i,r,n=[];return(e===u.ALL?t.columns:(e=t.renderContainers.left?t.renderContainers.left.visibleColumnCache.filter(function(e){return e.visible}):[],i=t.renderContainers.body?t.renderContainers.body.visibleColumnCache.filter(function(e){return e.visible}):[],r=t.renderContainers.right?t.renderContainers.right.visibleColumnCache.filter(function(e){return e.visible}):[],e.concat(i,r))).forEach(function(e){!0!==e.colDef.exporterSuppressExport&&"$$hashKey"!==e.field&&-1===t.options.exporterSuppressColumns.indexOf(e.name)&&(e={name:e.field,displayName:function(e,t){if(e.options.exporterHeaderFilter)return e.options.exporterHeaderFilterUseName?e.options.exporterHeaderFilter(t.name):e.options.exporterHeaderFilter(t.displayName);return t.headerCellFilter?a(t.headerCellFilter)(t.displayName):t.displayName}(t,e),width:e.drawnWidth||e.width,align:e.colDef.align||("number"===e.colDef.type?"right":"left")},n.push(e))}),n},getRowsFromNode:function(e){var t=[],i=e?Object.keys(e):["children"];if((1<i.length||"children"!=i[0])&&t.push(e),e&&e.children&&0<e.children.length)for(var r=0;r<e.children.length;r++)t=t.concat(this.getRowsFromNode(e.children[r]));return t},getDataSorted:function(e){if(!e.treeBase||0===e.treeBase.numberLevels)return e.rows;for(var t=[],i=0;i<e.treeBase.tree.length;i++)for(var r=this.getRowsFromNode(e.treeBase.tree[i]),n=0;n<r.length;n++)t.push(r[n].row);return t},getData:function(o,e,a,l){var t,i,r,n,s,d=[];switch(e){case u.ALL:t=this.getDataSorted(o,e,a,l);break;case u.VISIBLE:t=o.getVisibleRows();break;case u.SELECTED:o.api.selection?t=o.api.selection.getSelectedGridRows():c.logError("selection feature must be enabled to allow selected rows to be exported")}return s=a===u.ALL?o.columns:(i=o.renderContainers.left?o.renderContainers.left.visibleColumnCache.filter(function(e){return e.visible}):[],r=o.renderContainers.body?o.renderContainers.body.visibleColumnCache.filter(function(e){return e.visible}):[],n=o.renderContainers.right?o.renderContainers.right.visibleColumnCache.filter(function(e){return e.visible}):[],i.concat(r,n)),t.forEach(function(r){var n;!1!==r.exporterEnableExporting&&(n=[],s.forEach(function(e){var t,i;!e.visible&&a!==u.ALL||!0===e.colDef.exporterSuppressExport||"$$hashKey"===e.field||-1!==o.options.exporterSuppressColumns.indexOf(e.name)||(i=l?o.getCellDisplayValue(r,e):o.getCellValue(r,e),t={value:o.options.exporterFieldCallback(o,r,e,i,g.type)},(i=o.options.exporterFieldFormatCallback(o,r,e,i,g.type))&&Object.assign(t,i),e.colDef.exporterPdfAlign&&(t.alignment=e.colDef.exporterPdfAlign),n.push(t))}),d.push(n))}),d},formatAsCsv:function(e,t,i){e=e.map(function(e){return{value:e.displayName}}),e=0<e.length?this.formatRowAsCsv(this,i)(e)+"\n":"";return e+=t.map(this.formatRowAsCsv(this,i)).join("\n")},formatRowAsCsv:function(t,i){return function(e){return e.map(t.formatFieldAsCsv).join(i)}},formatFieldAsCsv:function(e){return null==e.value?"":"number"==typeof e.value?e.value:"boolean"==typeof e.value?e.value?"TRUE":"FALSE":"string"==typeof e.value?'"'+e.value.replace(/"/g,'""')+'"':"object"!=typeof e.value||e.value instanceof Date?JSON.stringify(e.value):'"'+JSON.stringify(e.value).replace(/"/g,'""')+'"'},isIE:function(){return-1!==navigator.userAgent.search(/(?:Edge|MSIE|Trident\/.*; rv:)/)?!0:!1},downloadFile:function(e,t,i,r,n){var o,a=document,l=a.createElement("a"),s="application/octet-stream;charset=utf-8",d=this.isIE();return n&&(t="sep="+i+"\r\n"+t),navigator.msSaveBlob?navigator.msSaveOrOpenBlob(new Blob([r?"\ufeff":"",t],{type:s}),e):d?(n=a.createElement("iframe"),document.body.appendChild(n),n.contentWindow.document.open("text/html","replace"),n.contentWindow.document.write(t),n.contentWindow.document.close(),n.contentWindow.focus(),n.contentWindow.document.execCommand("SaveAs",!0,e),document.body.removeChild(n),!0):("download"in l?(i=new Blob([r?"\ufeff":"",t],{type:s}),o=URL.createObjectURL(i),l.setAttribute("download",e)):(o="data: "+s+","+encodeURIComponent(t),l.setAttribute("target","_blank")),l.href=o,l.setAttribute("style","display:none;"),a.body.appendChild(l),void setTimeout(function(){var e;l.click?l.click():document.createEvent&&((e=document.createEvent("MouseEvents")).initEvent("click",!0,!0),l.dispatchEvent(e)),a.body.removeChild(l)},this.delay))},pdfExport:function(i,r,n){var o=this;o.type="pdf",this.loadAllDataIfNeeded(i,r,n).then(function(){var e=o.getColumnHeaders(i,n),t=o.getData(i,r,n),e=o.prepareAsPdf(i,e,t);o.isIE()||-1!==navigator.appVersion.indexOf("Edge")?(t=angular.isFunction(i.options.exporterPdfFilename)?i.options.exporterPdfFilename(i,r,n):i.options.exporterPdfFilename,o.downloadPDF(t,e)):pdfMake.createPdf(e).open()})},downloadPDF:function(t,e){var i,r=document,n=(r.createElement("a"),this.isIE());pdfMake.createPdf(e).getBuffer(function(e){return i=new Blob([e]),navigator.msSaveBlob?navigator.msSaveBlob(i,t):n?(e=r.createElement("iframe"),document.body.appendChild(e),e.contentWindow.document.open("text/html","replace"),e.contentWindow.document.write(i),e.contentWindow.document.close(),e.contentWindow.focus(),e.contentWindow.document.execCommand("SaveAs",!0,t),document.body.removeChild(e),!0):void 0})},prepareAsPdf:function(e,t,i){var r=this.calculatePdfHeaderWidths(e,t),t=t.map(function(e){return{text:e.displayName,style:"tableHeader"}}),i=i.map(this.formatRowAsPdf(this)),t=[t].concat(i),i={pageOrientation:e.options.exporterPdfOrientation,pageSize:e.options.exporterPdfPageSize,content:[{style:"tableStyle",table:{headerRows:1,widths:r,body:t}}],styles:{tableStyle:e.options.exporterPdfTableStyle,tableHeader:e.options.exporterPdfTableHeaderStyle},defaultStyle:e.options.exporterPdfDefaultStyle};return e.options.exporterPdfLayout&&(i.layout=e.options.exporterPdfLayout),e.options.exporterPdfHeader&&(i.header=e.options.exporterPdfHeader),e.options.exporterPdfFooter&&(i.footer=e.options.exporterPdfFooter),i=e.options.exporterPdfCustomFormatter?e.options.exporterPdfCustomFormatter(i):i},calculatePdfHeaderWidths:function(t,e){var i=0,r=(e.forEach(function(e){"number"==typeof e.width&&(i+=e.width)}),0),n=(e.forEach(function(e){var t;"*"===e.width&&(r+=100),"string"==typeof e.width&&e.width.match(/(\d)*%/)&&(t=parseInt(e.width.match(/(\d)*%/)[0]),e.width=i*t/100,r+=e.width)}),i+r);return e.map(function(e){return"*"===e.width?e.width:e.width*t.options.exporterPdfMaxGridWidth/n})},formatRowAsPdf:function(t){return function(e){return e.map(t.formatFieldAsPdfString)}},formatFieldAsPdfString:function(e){var t=null==e.value?"":"number"==typeof e.value?e.value.toString():"boolean"==typeof e.value?e.value?"TRUE":"FALSE":"string"==typeof e.value?e.value.replace(/"/g,'""'):!(e.value instanceof Date)&&"object"==typeof e.value?e.value:JSON.stringify(e.value).replace(/^"/,"").replace(/"$/,"");return t=e.alignment&&"string"==typeof e.alignment?{text:t,alignment:e.alignment}:t},formatAsExcel:function(e,t,i,r,n){for(var o=e.map(function(e){return{value:e.displayName}}),a=[],l=[],s=0;s<o.length;s++){var d="header";switch(e[s].align){case"center":d="headerCenter";break;case"right":d="headerRight"}var c=n.styles&&n.styles[d]?{style:n.styles[d].id}:null;l.push({value:o[s].value,metadata:c})}a.push(l);for(var u=t.map(this.formatRowAsExcel(this,i,r)),g=0;g<u.length;g++)a.push(u[g]);return a},formatRowAsExcel:function(n,o,a){return function(e){for(var t=[],i=0;i<e.length;i++){var r=n.formatFieldAsExcel(e[i],o,a);t.push({value:r,metadata:e[i].metadata})}return t}},formatFieldAsExcel:function(e,t,i,r){return null==e.value?"":"number"==typeof e.value||"string"==typeof e.value?e.value:"boolean"==typeof e.value?e.value?"TRUE":"FALSE":JSON.stringify(e.value)},prepareAsExcel:function(e,t,i){var r={styles:{}};return e.options.exporterExcelCustomFormatters&&(r=e.options.exporterExcelCustomFormatters(e,t,r)),e.options.exporterExcelHeader&&(angular.isFunction(e.options.exporterExcelHeader)?e.options.exporterExcelHeader(e,t,i,r):(t=e.options.exporterExcelHeader.text,e=e.options.exporterExcelHeader.style,i.data.push([{value:t,metadata:{style:r.styles[e].id}}]))),r},excelExport:function(l,s,d){var c=this;c.type="excel",this.loadAllDataIfNeeded(l,s,d).then(function(){for(var e=l.options.showHeader?c.getColumnHeaders(l,d):[],t="Sheet1",t=(l.options.exporterExcelSheetName&&(t=angular.isFunction(l.options.exporterExcelSheetName)?l.options.exporterExcelSheetName(l,s,d):l.options.exporterExcelSheetName),new ExcelBuilder.Worksheet({name:t})),i=new ExcelBuilder.Workbook,r=(i.addWorksheet(t),c.prepareAsExcel(l,i,t)),n=[],o=l.treeBase?l.treeBase.numberLevels:l.enableRowSelection?1:0;o<l.columns.length;o++)l.columns[o].field!==u.rowHeaderColName&&l.columns[o].field!==u.selectionRowHeaderColName&&n.push({width:l.columns[o].drawnWidth/l.options.exporterColumnScaleFactor});t.setColumns(n);var a=c.getData(l,s,d,l.options.exporterFieldApplyFilters),e=c.formatAsExcel(e,a,i,t,r);t.setData(t.data.concat(e)),ExcelBuilder.Builder.createFile(i,{type:"blob"}).then(function(e){var t=angular.isFunction(l.options.exporterExcelFilename)?l.options.exporterExcelFilename(l,s,d):l.options.exporterExcelFilename;c.downloadFile(t,e,l.options.exporterCsvColumnSeparator,l.options.exporterOlderExcelCompatibility)})})}};function i(e,t,i,r){var n,o;return i.cellFilter?(n=(i=i.cellFilter.match(/(?:[^:"]+|"[^"]*")+/g))[0]?i[0].replace(/[\'\"\s]/g,""):null,o=i[1]?i[1].replace(/[\'\"]/g,"").trim():null,i=i[2]?i[2].replace(/[\'\"\s]/g,""):null,a(n)(r,o,i)):r}return g}]),e.directive("uiGridExporter",["uiGridExporterConstants","uiGridExporterService","gridUtil","$compile",function(e,n,t,i){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(e,t,i,r){n.initializeGrid(r.grid),r.grid.exporter.$scope=e}}}])}(),function(){"use strict";var e=angular.module("ui.grid.grouping",["ui.grid","ui.grid.treeBase"]);e.constant("uiGridGroupingConstants",{featureName:"grouping",rowHeaderColName:"treeBaseRowHeaderCol",EXPANDED:"expanded",COLLAPSED:"collapsed",aggregation:{COUNT:"count",SUM:"sum",MAX:"max",MIN:"min",AVG:"avg"}}),e.service("uiGridGroupingService",["$q","uiGridGroupingConstants","gridUtil","rowSorter","GridRow","gridClassFactory","i18nService","uiGridConstants","uiGridTreeBaseService",function(e,a,l,s,u,g,d,r,c){var p={initializeGrid:function(r,e){c.initializeGrid(r,e),r.grouping={},r.grouping.groupHeaderCache={},p.defaultGridOptions(r.options),r.registerRowsProcessor(p.groupRows,400),r.registerColumnBuilder(p.groupingColumnBuilder),r.registerColumnsProcessor(p.groupingColumnProcessor,400);var t={grouping:{aggregationChanged:{},groupingChanged:{}}},i={grouping:{getGrouping:function(e){var t=p.getGrouping(r);return t.grouping.forEach(function(e){e.colName=e.col.name,delete e.col}),t.aggregations.forEach(function(e){e.colName=e.col.name,delete e.col}),t.aggregations=t.aggregations.filter(function(e){return!e.aggregation.source||"grouping"!==e.aggregation.source}),e&&(t.rowExpandedStates=p.getRowExpandedStates(r.grouping.groupingHeaderCache)),t},setGrouping:function(e){p.setGrouping(r,e)},groupColumn:function(e){e=r.getColumn(e);p.groupColumn(r,e)},ungroupColumn:function(e){e=r.getColumn(e);p.ungroupColumn(r,e)},clearGrouping:function(){p.clearGrouping(r)},aggregateColumn:function(e,t,i){e=r.getColumn(e);p.aggregateColumn(r,e,t,i)}}};r.api.registerEventsFromObject(t),r.api.registerMethodsFromObject(i),r.api.core.on.sortChanged(e,p.tidyPriorities)},defaultGridOptions:function(e){e.enableGrouping=!1!==e.enableGrouping,e.groupingShowCounts=!1!==e.groupingShowCounts,e.groupingNullLabel=void 0===e.groupingNullLabel?"Null":e.groupingNullLabel,e.enableGroupHeaderSelection=!0===e.enableGroupHeaderSelection},groupingColumnBuilder:function(e,i,t){var r,n,o;!1!==e.enableGrouping&&(void 0===i.grouping&&void 0!==e.grouping?(i.grouping=angular.copy(e.grouping),void 0!==i.grouping.groupPriority&&-1<i.grouping.groupPriority&&(i.treeAggregationFn=c.nativeAggregations()[a.aggregation.COUNT].aggregationFn,i.treeAggregationFinalizerFn=p.groupedFinalizerFn)):void 0===i.grouping&&(i.grouping={}),void 0!==i.grouping&&void 0!==i.grouping.groupPriority&&0<=i.grouping.groupPriority&&(i.suppressRemoveSort=!0),e={name:"ui.grid.grouping.group",title:d.get().grouping.group,icon:"ui-grid-icon-indent-right",shown:function(){return void 0===this.context.col.grouping||void 0===this.context.col.grouping.groupPriority||this.context.col.grouping.groupPriority<0},action:function(){p.groupColumn(this.context.col.grid,this.context.col)}},r={name:"ui.grid.grouping.ungroup",title:d.get().grouping.ungroup,icon:"ui-grid-icon-indent-left",shown:function(){return void 0!==this.context.col.grouping&&void 0!==this.context.col.grouping.groupPriority&&0<=this.context.col.grouping.groupPriority},action:function(){p.ungroupColumn(this.context.col.grid,this.context.col)}},n={name:"ui.grid.grouping.aggregateRemove",title:d.get().grouping.aggregate_remove,shown:function(){return void 0!==this.context.col.treeAggregationFn},action:function(){p.aggregateColumn(this.context.col.grid,this.context.col,null)}},!(o=function(e,t){t=t||d.get().grouping["aggregate_"+e]||e;t={name:"ui.grid.grouping.aggregate"+e,title:t,shown:function(){return void 0===this.context.col.treeAggregation||void 0===this.context.col.treeAggregation.type||this.context.col.treeAggregation.type!==e},action:function(){p.aggregateColumn(this.context.col.grid,this.context.col,e)}};l.arrayContainsObjectWithProperty(i.menuItems,"name","ui.grid.grouping.aggregate"+e)||i.menuItems.push(t)})!==i.colDef.groupingShowGroupingMenu&&(l.arrayContainsObjectWithProperty(i.menuItems,"name","ui.grid.grouping.group")||i.menuItems.push(e),l.arrayContainsObjectWithProperty(i.menuItems,"name","ui.grid.grouping.ungroup")||i.menuItems.push(r)),!1!==i.colDef.groupingShowAggregationMenu)&&(angular.forEach(c.nativeAggregations(),function(e,t){o(t)}),angular.forEach(t.treeCustomAggregations,function(e,t){o(t,e.menuTitle)}),l.arrayContainsObjectWithProperty(i.menuItems,"name","ui.grid.grouping.aggregateRemove")||i.menuItems.push(n))},groupingColumnProcessor:function(e,t){return e=p.moveGroupColumns(this,e,t)},groupedFinalizerFn:function(e){void 0!==e.groupVal?(e.rendered=e.groupVal,this.grid.options.groupingShowCounts&&"date"!==this.colDef.type&&"object"!==this.colDef.type&&(e.rendered+=" ("+e.value+")")):e.rendered=null},moveGroupColumns:function(e,t){return!1!==e.options.moveGroupColumns&&(t.forEach(function(e,t){e.groupingPosition=t}),t.sort(function(e,t){var i=e.isRowHeader?e.headerPriority:void 0===e.grouping||void 0===e.grouping.groupPriority||e.grouping.groupPriority<0?null:e.grouping.groupPriority,r=t.isRowHeader?t.headerPriority:void 0===t.grouping||void 0===t.grouping.groupPriority||t.grouping.groupPriority<0?null:t.grouping.groupPriority;return null!==i&&null===r?-1:null!==r&&null===i?1:null!==i&&null!==r?i-r:e.groupingPosition-t.groupingPosition}),t.forEach(function(e){delete e.groupingPosition})),t},groupColumn:function(e,t){void 0===t.grouping&&(t.grouping={});var i=p.getGrouping(e);t.grouping.groupPriority=i.grouping.length,t.previousSort=angular.copy(t.sort),t.sort?void 0!==t.sort.direction&&null!==t.sort.direction||(t.sort.direction=r.ASC):t.sort={direction:r.ASC},t.treeAggregation={type:a.aggregation.COUNT,source:"grouping"},t.colDef&&angular.isFunction(t.colDef.customTreeAggregationFn)?t.treeAggregationFn=t.colDef.customTreeAggregationFn:t.treeAggregationFn=c.nativeAggregations()[a.aggregation.COUNT].aggregationFn,t.treeAggregationFinalizerFn=p.groupedFinalizerFn,e.api.grouping.raise.groupingChanged(t),e.api.core.raise.sortChanged(e,e.getColumnSorting()),e.queueGridRefresh()},ungroupColumn:function(e,t){void 0!==t.grouping&&(delete t.grouping.groupPriority,delete t.treeAggregation,delete t.customTreeAggregationFinalizer,t.previousSort&&(t.sort=t.previousSort,delete t.previousSort),p.tidyPriorities(e),e.api.grouping.raise.groupingChanged(t),e.api.core.raise.sortChanged(e,e.getColumnSorting()),e.queueGridRefresh())},aggregateColumn:function(e,t,i,r){void 0!==t.grouping&&void 0!==t.grouping.groupPriority&&0<=t.grouping.groupPriority&&p.ungroupColumn(e,t);var n={};void 0!==e.options.treeCustomAggregations[i]?n=e.options.treeCustomAggregations[i]:void 0!==c.nativeAggregations()[i]&&(n=c.nativeAggregations()[i]),t.treeAggregation={type:i,label:"string"==typeof r?r:d.get().aggregation[n.label]||n.label},t.treeAggregationFn=n.aggregationFn,t.treeAggregationFinalizerFn=n.finalizerFn,e.api.grouping.raise.aggregationChanged(t),e.queueGridRefresh()},setGrouping:function(i,e){void 0!==e&&(p.clearGrouping(i),e.grouping&&e.grouping.length&&0<e.grouping.length&&e.grouping.forEach(function(e){e=i.getColumn(e.colName);e&&p.groupColumn(i,e)}),e.aggregations&&e.aggregations.length&&e.aggregations.forEach(function(e){var t=i.getColumn(e.colName);t&&p.aggregateColumn(i,t,e.aggregation.type)}),e.rowExpandedStates)&&p.applyRowExpandedStates(i.grouping.groupingHeaderCache,e.rowExpandedStates)},clearGrouping:function(t){var e=p.getGrouping(t);0<e.grouping.length&&e.grouping.forEach(function(e){e.col||(e.col=t.getColumn(e.colName)),p.ungroupColumn(t,e.col)}),0<e.aggregations.length&&e.aggregations.forEach(function(e){e.col||(e.col=t.getColumn(e.colName)),p.aggregateColumn(t,e.col,null)})},tidyPriorities:function(e){void 0!==e&&void 0===e.grid||void 0===this.grid||(e=this.grid);var i=[],r=[],t=(e.columns.forEach(function(e,t){void 0!==e.grouping&&void 0!==e.grouping.groupPriority&&0<=e.grouping.groupPriority?i.push(e):void 0!==e.sort&&void 0!==e.sort.priority&&0<=e.sort.priority&&r.push(e)}),i.sort(function(e,t){return e.grouping.groupPriority-t.grouping.groupPriority}),i.forEach(function(e,t){e.grouping.groupPriority=t,e.suppressRemoveSort=!0,void 0===e.sort&&(e.sort={}),e.sort.priority=t}),i.length);r.sort(function(e,t){return e.sort.priority-t.sort.priority}),r.forEach(function(e){e.sort.priority=t,e.suppressRemoveSort=e.colDef.suppressRemoveSort,t++})},groupRows:function(r){if(0!==r.length){for(var n=this,o=(n.grouping.oldGroupingHeaderCache=n.grouping.groupingHeaderCache||{},n.grouping.groupingHeaderCache={},p.initialiseProcessingState(n)),e=function(e,t){var i=n.getCellValue(l,e.col);e.initialised&&0===s.getSortFn(e.col)(i,e.currentValue)||(p.insertGroupHeader(n,r,a,o,t),a++)},a=0;a<r.length;a++){var l=r[a];l.visible&&o.forEach(e)}delete n.grouping.oldGroupingHeaderCache}return r},initialiseProcessingState:function(e){var i=[];return p.getGrouping(e).grouping.forEach(function(e,t){i.push({fieldName:e.field,col:e.col,initialised:!1,currentValue:null,currentRow:null})}),i},getGrouping:function(e){var t=[],i=[];return e.columns.forEach(function(e){e.grouping&&void 0!==e.grouping.groupPriority&&0<=e.grouping.groupPriority&&t.push({field:e.field,col:e,groupPriority:e.grouping.groupPriority,grouping:e.grouping}),e.treeAggregation&&e.treeAggregation.type&&i.push({field:e.field,col:e,aggregation:e.treeAggregation})}),t.sort(function(e,t){return e.groupPriority-t.groupPriority}),t.forEach(function(e,t){e.grouping.groupPriority=t,e.groupPriority=t,delete e.grouping}),{grouping:t,aggregations:i}},insertGroupHeader:function(e,t,i,r,n){var o=r[n].col,o=e.getCellValue(t[i],o),a=o;function l(e){return angular.isObject(e)?JSON.stringify(e):e}null==o&&(a=e.options.groupingNullLabel);for(var s,d=e.grouping.oldGroupingHeaderCache,c=0;c<n;c++)d&&d[l(r[c].currentValue)]&&(d=d[l(r[c].currentValue)].children);for(d&&d[l(o)]?(s=d[l(o)].row).entity={}:(s=new u({},null,e),g.rowTemplateAssigner.call(e,s)),s.entity["$$"+r[n].col.uid]={groupVal:a},s.treeLevel=n,s.groupHeader=!0,s.internalRow=!0,s.enableCellEdit=!1,s.enableSelection=e.options.enableGroupHeaderSelection,r[n].initialised=!0,r[n].currentValue=o,r[n].currentRow=s,p.finaliseProcessingState(r,n+1),t.splice(i,0,s),d=e.grouping.groupingHeaderCache,c=0;c<n;c++)d=d[l(r[c].currentValue)].children;d[l(o)]={row:s,children:{}}},finaliseProcessingState:function(e,t){for(var i=t;i<e.length;i++)e[i].initialised=!1,e[i].currentRow=null,e[i].currentValue=null},getRowExpandedStates:function(e){var i;return void 0===e?{}:(i={},angular.forEach(e,function(e,t){i[t]={state:e.row.treeNode.state},e.children?i[t].children=p.getRowExpandedStates(e.children):i[t].children={}}),i)},applyRowExpandedStates:function(i,e){void 0!==e&&angular.forEach(e,function(e,t){i[t]&&(i[t].row.treeNode.state=e.state,e.children)&&i[t].children&&p.applyRowExpandedStates(i[t].children,e.children)})}};return p}]),e.directive("uiGridGrouping",["uiGridGroupingConstants","uiGridGroupingService",function(e,n){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){!1!==r.grid.options.enableGrouping&&n.initializeGrid(r.grid,e)},post:function(e,t,i,r){}}}}}])}(),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ar",{headerCell:{aria:{defaultFilterLabel:"التصفيه بالعمود",removeFilter:"محو التصفيه",columnMenuButtonLabel:"قاءمه الاعمده"},priority:"أولويه : ",filterLabel:"تصفيه بالاعمده :"},aggregate:{label:"العناصر"},groupPanel:{description:"اسحب رأس العمود هنا وأسقطه لإنشاء مجموعه"},search:{placeholder:"بحث  ...",showingItems:"العناصر الظاهره :",selectedItems:"العناصر المحدده :",totalItems:"عدد العناصر :",size:"حجم الصفحه :",first:"اول صفحه",next:"الصفحه التاليه",previous:"الصفحه الصابقه",last:"الصفحه الاخيره"},menu:{text:"اختيار العمود :"},sort:{ascending:"ترتيب تصاعدى",descending:"ترتيب تنازلى",none:"عدم التحديد",remove:"حذف الترتيب"},column:{hide:"إخفاء عمود"},aggregation:{count:"عدد الصفوف: ",sum:"جمع: ",avg:"المتوسط الحسابى: ",min:"الادنى: ",max:"الاقصى: "},pinning:{pinLeft:"تثبيت لليسار",pinRight:"تثبيت لليمين",unpin:"فك التثبيت"},columnMenu:{close:"غلق"},gridMenu:{aria:{buttonLabel:"قائمه الجدول"},columns:"الاعمده:",importerTitle:"إدخال ملف",exporterAllAsCsv:"إخراج كل البيانات ك(csv)",exporterVisibleAsCsv:"إخراج كل البيانات الواضحه ك (csv)",exporterSelectedAsCsv:"إخراج كل البيانات المحدده ك (csv)",exporterAllAsPdf:"إخراج كل البيانات ك(pdf)",exporterVisibleAsPdf:"إخراج كل البيانات الواضحه ك (pdf)",exporterSelectedAsPdf:"إخراج كل البيانات المحدده ك (pdf)",clearAllFilters:"محو كل الترشيح"},importer:{noHeaders:"اسماء هؤلاء الاعمده غير واضحه، هل يوجد رأس للملف؟",noObjects:"Objects were not able to be derived, was there data in the file other than headers?",invalidCsv:"الملف غير قادر على الاتمام ، هل ال (CSV) صحيح؟",invalidJson:"الملف غير قادر على الاتمام ، هل ال (JSON) صحيح؟",jsonNotArray:"Imported json file must contain an array, aborting."},pagination:{aria:{pageToFirst:"الصفحه الاولى",pageBack:"الصفه السابقه",pageSelected:"الصفحه المحدده",pageForward:"الصفحه التاليه",pageToLast:"الصفحه الاخيره"},sizes:"عدد العناصر فى الصفحه",totalItems:"عناصر",through:"إلى",of:"من"},grouping:{group:"جمع",ungroup:"فك الجمع",aggregate_count:"جمله : العدد",aggregate_sum:"جمله : الحاصل",aggregate_max:"جمله : الاقصى",aggregate_min:"جمله : الاقل",aggregate_avg:"جمله :المتوسط ",aggregate_remove:"جمله : حذف"},validate:{error:"خطأ :",minLength:"القيمه لابد ان لا تقل عن THRESHOLD حرف.",maxLength:"القيمه لابد ان لا تزيد عن THRESHOLD حرف.",required:"مطلوب قيمه"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("bg",{headerCell:{aria:{defaultFilterLabel:"Филттър за колоната",removeFilter:"Премахни филтър",columnMenuButtonLabel:"Меню на колоната"},priority:"Приоритет:",filterLabel:"Филтър за колоната: "},aggregate:{label:"обекти"},search:{placeholder:"Търсене...",showingItems:"Показани обекти:",selectedItems:"избрани обекти:",totalItems:"Общо:",size:"Размер на страницата:",first:"Първа страница",next:"Следваща страница",previous:"Предишна страница",last:"Последна страница"},menu:{text:"Избери колони:"},sort:{ascending:"Сортиране по възходящ ред",descending:"Сортиране по низходящ ред",none:"Без сортиране",remove:"Премахни сортирането"},column:{hide:"Скрий колоната"},aggregation:{count:"Общо редове: ",sum:"общо: ",avg:"средно: ",min:"най-малко: ",max:"най-много: "},pinning:{pinLeft:"Прикрепи вляво",pinRight:"Прикрепи вдясно",unpin:"Премахване"},columnMenu:{close:"Затвори"},gridMenu:{aria:{buttonLabel:"Меню на таблицата"},columns:"Колони:",importerTitle:"Импортиране на файл",exporterAllAsCsv:"Експортиране на данните като csv",exporterVisibleAsCsv:"Експортиране на видимите данни като csv",exporterSelectedAsCsv:"Експортиране на избраните данни като csv",exporterAllAsPdf:"Експортиране на данните като pdf",exporterVisibleAsPdf:"Експортиране на видимите данни като pdf",exporterSelectedAsPdf:"Експортиране на избраните данни като pdf",clearAllFilters:"Премахни всички филтри"},importer:{noHeaders:"Имената на колоните не успяха да бъдат извлечени, файлът има ли хедър?",noObjects:"Обектите не успяха да бъдат извлечени, файлът съдържа ли данни, различни от хедър?",invalidCsv:"Файлът не може да бъде обработеб, уверете се, че е валиден CSV файл",invalidJson:"Файлът не може да бъде обработеб, уверете се, че е валиден JSON файл",jsonNotArray:"Импортираният JSON файл трябва да съдържа масив, прекратяване."},pagination:{aria:{pageToFirst:"Към първа страница",pageBack:"Страница назад",pageSelected:"Избрана страница",pageForward:"Страница напред",pageToLast:"Към последна страница"},sizes:"обекта на страница",totalItems:"обекта",through:"до",of:"от"},grouping:{group:"Групиране",ungroup:"Премахване на групирането",aggregate_count:"Сбор: Брой",aggregate_sum:"Сбор: Сума",aggregate_max:"Сбор: Максимум",aggregate_min:"Сбор: Минимум",aggregate_avg:"Сбор: Средно",aggregate_remove:"Сбор: Премахване"},validate:{error:"Грешка:",minLength:"Стойността трябва да съдържа поне THRESHOLD символа.",maxLength:"Стойността не трябва да съдържа повече от THRESHOLD символа.",required:"Необходима е стойност."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){var t={aggregate:{label:"položky"},groupPanel:{description:"Přesuňte záhlaví zde pro vytvoření skupiny dle sloupce."},search:{placeholder:"Hledat...",showingItems:"Zobrazuji položky:",selectedItems:"Vybrané položky:",totalItems:"Celkem položek:",size:"Velikost strany:",first:"První strana",next:"Další strana",previous:"Předchozí strana",last:"Poslední strana"},menu:{text:"Vyberte sloupec:"},sort:{ascending:"Seřadit od A-Z",descending:"Seřadit od Z-A",remove:"Odebrat seřazení"},column:{hide:"Schovat sloupec"},aggregation:{count:"celkem řádků: ",sum:"celkem: ",avg:"avg: ",min:"min.: ",max:"max.: "},pinning:{pinLeft:"Zamknout vlevo",pinRight:"Zamknout vpravo",unpin:"Odemknout"},gridMenu:{columns:"Sloupce:",importerTitle:"Importovat soubor",exporterAllAsCsv:"Exportovat všechna data do csv",exporterVisibleAsCsv:"Exportovat viditelná data do csv",exporterSelectedAsCsv:"Exportovat vybraná data do csv",exporterAllAsPdf:"Exportovat všechna data do pdf",exporterVisibleAsPdf:"Exportovat viditelná data do pdf",exporterSelectedAsPdf:"Exportovat vybraná data do pdf",exporterAllAsExcel:"Exportovat všechna data do excel",exporterVisibleAsExcel:"Exportovat viditelná data do excel",exporterSelectedAsExcel:"Exportovat vybraná data do excel",clearAllFilters:"Odstranit všechny filtry"},importer:{noHeaders:"Názvy sloupců se nepodařilo získat, obsahuje soubor záhlaví?",noObjects:"Data se nepodařilo zpracovat, obsahuje soubor řádky mimo záhlaví?",invalidCsv:"Soubor nelze zpracovat, jedná se o CSV?",invalidJson:"Soubor nelze zpracovat, je to JSON?",jsonNotArray:"Soubor musí obsahovat json. Ukončuji.."},pagination:{sizes:"položek na stránku",totalItems:"položek"},grouping:{group:"Seskupit",ungroup:"Odebrat seskupení",aggregate_count:"Agregace: Count",aggregate_sum:"Agregace: Sum",aggregate_max:"Agregace: Max",aggregate_min:"Agregace: Min",aggregate_avg:"Agregace: Avg",aggregate_remove:"Agregace: Odebrat"}};return e.add("cs",t),e.add("cz",t),e.add("cs-cz",t),e.add("cs-CZ",t),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("da",{aggregate:{label:"artikler"},groupPanel:{description:"Grupér rækker udfra en kolonne ved at trække dens overskift hertil."},search:{placeholder:"Søg...",showingItems:"Viste rækker:",selectedItems:"Valgte rækker:",totalItems:"Rækker totalt:",size:"Side størrelse:",first:"Første side",next:"Næste side",previous:"Forrige side",last:"Sidste side"},menu:{text:"Vælg kolonner:"},sort:{ascending:"Sorter stigende",descending:"Sorter faldende",none:"Sorter ingen",remove:"Fjern sortering"},column:{hide:"Skjul kolonne"},aggregation:{count:"antal rækker: ",sum:"sum: ",avg:"gns: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Fastgør til venstre",pinRight:"Fastgør til højre",unpin:"Frigør"},gridMenu:{columns:"Kolonner:",importerTitle:"Importer fil",exporterAllAsCsv:"Eksporter alle data som csv",exporterVisibleAsCsv:"Eksporter synlige data som csv",exporterSelectedAsCsv:"Eksporter markerede data som csv",exporterAllAsPdf:"Eksporter alle data som pdf",exporterVisibleAsPdf:"Eksporter synlige data som pdf",exporterSelectedAsPdf:"Eksporter markerede data som pdf",exporterAllAsExcel:"Eksporter alle data som excel",exporterVisibleAsExcel:"Eksporter synlige data som excel",exporterSelectedAsExcel:"Eksporter markerede data som excel",clearAllFilters:"Clear all filters"},importer:{noHeaders:"Column names were unable to be derived, does the file have a header?",noObjects:"Objects were not able to be derived, was there data in the file other than headers?",invalidCsv:"File was unable to be processed, is it valid CSV?",invalidJson:"File was unable to be processed, is it valid Json?",jsonNotArray:"Imported json file must contain an array, aborting."},pagination:{aria:{pageToFirst:"Gå til første",pageBack:"Gå tilbage",pageSelected:"Valgte side",pageForward:"Gå frem",pageToLast:"Gå til sidste"},sizes:"genstande per side",totalItems:"genstande",through:"gennem",of:"af"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("de",{headerCell:{aria:{defaultFilterLabel:"Filter für Spalte",removeFilter:"Filter löschen",columnMenuButtonLabel:"Spaltenmenü",column:"Spalte"},priority:"Priorität:",filterLabel:"Filter für Spalte: "},aggregate:{label:"Eintrag"},groupPanel:{description:"Ziehen Sie eine Spaltenüberschrift hierhin, um nach dieser Spalte zu gruppieren."},search:{aria:{selected:"Zeile markiert",notSelected:"Zeile nicht markiert"},placeholder:"Suche...",showingItems:"Zeige Einträge:",selectedItems:"Ausgewählte Einträge:",totalItems:"Einträge gesamt:",size:"Einträge pro Seite:",first:"Erste Seite",next:"Nächste Seite",previous:"Vorherige Seite",last:"Letzte Seite"},selection:{aria:{row:"Zeile"},selectAll:"Alle auswählen",displayName:"Zeilenauswahlkasten"},menu:{text:"Spalten auswählen:"},sort:{ascending:"aufsteigend sortieren",descending:"absteigend sortieren",none:"keine Sortierung",remove:"Sortierung zurücksetzen"},column:{hide:"Spalte ausblenden"},aggregation:{count:"Zeilen insgesamt: ",sum:"gesamt: ",avg:"Durchschnitt: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Links anheften",pinRight:"Rechts anheften",unpin:"Lösen"},columnMenu:{close:"Schließen"},gridMenu:{aria:{buttonLabel:"Tabellenmenü"},columns:"Spalten:",importerTitle:"Datei importieren",exporterAllAsCsv:"Alle Daten als CSV exportieren",exporterVisibleAsCsv:"Sichtbare Daten als CSV exportieren",exporterSelectedAsCsv:"Markierte Daten als CSV exportieren",exporterAllAsPdf:"Alle Daten als PDF exportieren",exporterVisibleAsPdf:"Sichtbare Daten als PDF exportieren",exporterSelectedAsPdf:"Markierte Daten als PDF exportieren",exporterAllAsExcel:"Alle Daten als Excel exportieren",exporterVisibleAsExcel:"Sichtbare Daten als Excel exportieren",exporterSelectedAsExcel:"Markierte Daten als Excel exportieren",clearAllFilters:"Alle Filter zurücksetzen"},importer:{noHeaders:"Es konnten keine Spaltennamen ermittelt werden. Sind in der Datei Spaltendefinitionen enthalten?",noObjects:"Es konnten keine Zeileninformationen gelesen werden, Sind in der Datei außer den Spaltendefinitionen auch Daten enthalten?",invalidCsv:"Die Datei konnte nicht eingelesen werden, ist es eine gültige CSV-Datei?",invalidJson:"Die Datei konnte nicht eingelesen werden. Enthält sie gültiges JSON?",jsonNotArray:"Die importierte JSON-Datei muß ein Array enthalten. Breche Import ab."},pagination:{aria:{pageToFirst:"Zum Anfang",pageBack:"Seite zurück",pageSelected:"Ausgewählte Seite",pageForward:"Seite vor",pageToLast:"Zum Ende"},sizes:"Einträge pro Seite",totalItems:"Einträgen",through:"bis",of:"von"},grouping:{group:"Gruppieren",ungroup:"Gruppierung aufheben",aggregate_count:"Agg: Anzahl",aggregate_sum:"Agg: Summe",aggregate_max:"Agg: Maximum",aggregate_min:"Agg: Minimum",aggregate_avg:"Agg: Mittelwert",aggregate_remove:"Aggregation entfernen"},validate:{error:"Fehler:",minLength:"Der Wert sollte mindestens THRESHOLD Zeichen lang sein.",maxLength:"Der Wert sollte maximal THRESHOLD Zeichen lang sein.",required:"Ein Wert wird benötigt."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("es-ct",{headerCell:{aria:{defaultFilterLabel:"Filtre per columna",removeFilter:"Elimina el filtre",columnMenuButtonLabel:"Menú de Columna",column:"Columna"},priority:"Priority:",filterLabel:"Filtre per columna: "},aggregate:{label:"items"},groupPanel:{description:"Arrossegueu una capçalera de columna aquí i deixeu-lo anar per agrupar per aquesta columna."},search:{aria:{selected:"Fila seleccionada",notSelected:"Fila no seleccionada"},placeholder:"Cerca...",showingItems:"Ítems Mostrats:",selectedItems:"Ítems Seleccionats:",totalItems:"Ítems Totals:",size:"Mida de la pàgina:",first:"Primera Pàgina",next:"Propera Pàgina",previous:"Pàgina Anterior",last:"Última Pàgina"},selection:{aria:{row:"Fila"},selectAll:"Seleccionar Todo",displayName:"Seleccionar Fila"},menu:{text:"Triar Columnes:"},sort:{ascending:"Ordena Ascendent",descending:"Ordena Descendent",none:"Sense Ordre",remove:"Eliminar Ordre"},column:{hide:"Amaga la Columna"},aggregation:{count:"Files Totals: ",sum:"total: ",avg:"mitjà: ",min:"mín: ",max:"màx: "},pinning:{pinLeft:"Fixar a l'Esquerra",pinRight:"Fixar a la Dreta",unpin:"Treure Fixació"},columnMenu:{close:"Tanca"},gridMenu:{aria:{buttonLabel:"Menú de Quadrícula"},columns:"Columnes:",importerTitle:"Importa el fitxer",exporterAllAsCsv:"Exporta tot com CSV",exporterVisibleAsCsv:"Exporta les dades visibles com a CSV",exporterSelectedAsCsv:"Exporta les dades seleccionades com a CSV",exporterAllAsPdf:"Exporta tot com PDF",exporterVisibleAsPdf:"Exporta les dades visibles com a PDF",exporterSelectedAsPdf:"Exporta les dades seleccionades com a PDF",exporterAllAsExcel:"Exporta tot com Excel",exporterVisibleAsExcel:"Exporta les dades visibles com Excel",exporterSelectedAsExcel:"Exporta les dades seleccionades com Excel",clearAllFilters:"Netejar tots els filtres"},importer:{noHeaders:"No va ser possible derivar els noms de les columnes, té encapçalats l'arxiu?",noObjects:"No va ser possible obtenir registres, conté dades l'arxiu, a part de les capçaleres?",invalidCsv:"No va ser possible processar l'arxiu, ¿és un CSV vàlid?",invalidJson:"No va ser possible processar l'arxiu, ¿és un JSON vàlid?",jsonNotArray:"El fitxer json importat ha de contenir una matriu, avortant."},pagination:{aria:{pageToFirst:"Page to first",pageBack:"Page back",pageSelected:"Selected page",pageForward:"Page forward",pageToLast:"Page to last"},sizes:"ítems per pàgina",totalItems:"ítems",through:"a",of:"de"},grouping:{group:"Agrupar",ungroup:"Desagrupar",aggregate_count:"Agr: Compte",aggregate_sum:"Agr: Sum",aggregate_max:"Agr: Máx",aggregate_min:"Agr: Mín",aggregate_avg:"Agr: Mitjà",aggregate_remove:"Agr: Treure"},validate:{error:"Error:",minLength:"El valor ha de tenir almenys caràcters THRESHOLD.",maxLength:"El valor ha de tenir com a màxim caràcters THRESHOLD.",required:"Un valor és necessari."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("es",{aggregate:{label:"Artículos"},groupPanel:{description:"Arrastre un encabezado de columna aquí y suéltelo para agrupar por esa columna."},search:{placeholder:"Buscar...",showingItems:"Artículos Mostrados:",selectedItems:"Artículos Seleccionados:",totalItems:"Artículos Totales:",size:"Tamaño de Página:",first:"Primera Página",next:"Página Siguiente",previous:"Página Anterior",last:"Última Página"},selection:{aria:{row:"Fila"},selectAll:"Seleccionar Todo",displayName:"Seleccionar Fila"},menu:{text:"Elegir columnas:"},sort:{ascending:"Orden Ascendente",descending:"Orden Descendente",remove:"Sin Ordenar"},column:{hide:"Ocultar la columna"},aggregation:{count:"filas totales: ",sum:"total: ",avg:"media: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Fijar a la Izquierda",pinRight:"Fijar a la Derecha",unpin:"Quitar Fijación"},gridMenu:{columns:"Columnas:",importerTitle:"Importar archivo",exporterAllAsCsv:"Exportar todo como csv",exporterVisibleAsCsv:"Exportar vista como csv",exporterSelectedAsCsv:"Exportar selección como csv",exporterAllAsPdf:"Exportar todo como pdf",exporterVisibleAsPdf:"Exportar vista como pdf",exporterSelectedAsPdf:"Exportar selección como pdf",exporterAllAsExcel:"Exportar todo como excel",exporterVisibleAsExcel:"Exportar vista como excel",exporterSelectedAsExcel:"Exportar selección como excel",clearAllFilters:"Limpiar todos los filtros"},importer:{noHeaders:"No fue posible derivar los nombres de las columnas, ¿tiene encabezados el archivo?",noObjects:"No fue posible obtener registros, ¿contiene datos el archivo, aparte de los encabezados?",invalidCsv:"No fue posible procesar el archivo, ¿es un CSV válido?",invalidJson:"No fue posible procesar el archivo, ¿es un Json válido?",jsonNotArray:"El archivo json importado debe contener un array, abortando."},pagination:{aria:{pageToFirst:"Página para primero",pageBack:"Página atrás",pageSelected:"Página seleccionada",pageForward:"Avance de página",pageToLast:"Página para durar"},through:"mediante",sizes:"registros por página",totalItems:"registros",of:"de"},grouping:{group:"Agrupar",ungroup:"Desagrupar",aggregate_count:"Agr: Cont",aggregate_sum:"Agr: Sum",aggregate_max:"Agr: Máx",aggregate_min:"Agr: Min",aggregate_avg:"Agr: Prom",aggregate_remove:"Agr: Quitar"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("fa",{aggregate:{label:"قلم"},groupPanel:{description:"عنوان یک ستون را بگیر و به گروهی از آن ستون رها کن."},search:{placeholder:"جستجو...",showingItems:"نمایش اقلام:",selectedItems:"قلم‌های انتخاب شده:",totalItems:"مجموع اقلام:",size:"اندازه‌ی صفحه:",first:"اولین صفحه",next:"صفحه‌ی‌بعدی",previous:"صفحه‌ی‌ قبلی",last:"آخرین صفحه"},menu:{text:"ستون‌های انتخابی:"},sort:{ascending:"ترتیب صعودی",descending:"ترتیب نزولی",remove:"حذف مرتب کردن"},column:{hide:"پنهان‌کردن ستون"},aggregation:{count:"تعداد: ",sum:"مجموع: ",avg:"میانگین: ",min:"کمترین: ",max:"بیشترین: "},pinning:{pinLeft:"پین کردن سمت چپ",pinRight:"پین کردن سمت راست",unpin:"حذف پین"},gridMenu:{columns:"ستون‌ها:",importerTitle:"وارد کردن فایل",exporterAllAsCsv:"خروجی تمام داده‌ها در فایل csv",exporterVisibleAsCsv:"خروجی داده‌های قابل مشاهده در فایل csv",exporterSelectedAsCsv:"خروجی داده‌های انتخاب‌شده در فایل csv",exporterAllAsPdf:"خروجی تمام داده‌ها در فایل pdf",exporterVisibleAsPdf:"خروجی داده‌های قابل مشاهده در فایل pdf",exporterSelectedAsPdf:"خروجی داده‌های انتخاب‌شده در فایل pdf",clearAllFilters:"پاک کردن تمام فیلتر"},importer:{noHeaders:"نام ستون قابل استخراج نیست. آیا فایل عنوان دارد؟",noObjects:"اشیا قابل استخراج نیستند. آیا به جز عنوان‌ها در فایل داده وجود دارد؟",invalidCsv:"فایل قابل پردازش نیست. آیا فرمت  csv  معتبر است؟",invalidJson:"فایل قابل پردازش نیست. آیا فرمت json   معتبر است؟",jsonNotArray:"فایل json وارد شده باید حاوی آرایه باشد. عملیات ساقط شد."},pagination:{sizes:"اقلام در هر صفحه",totalItems:"اقلام",of:"از"},grouping:{group:"گروه‌بندی",ungroup:"حذف گروه‌بندی",aggregate_count:"Agg: تعداد",aggregate_sum:"Agg: جمع",aggregate_max:"Agg: بیشینه",aggregate_min:"Agg: کمینه",aggregate_avg:"Agg: میانگین",aggregate_remove:"Agg: حذف"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("fi",{aggregate:{label:"rivit"},groupPanel:{description:"Raahaa ja pudota otsikko tähän ryhmittääksesi sarakkeen mukaan."},search:{placeholder:"Hae...",showingItems:"Näytetään rivejä:",selectedItems:"Valitut rivit:",totalItems:"Rivejä yht.:",size:"Näytä:",first:"Ensimmäinen sivu",next:"Seuraava sivu",previous:"Edellinen sivu",last:"Viimeinen sivu"},menu:{text:"Valitse sarakkeet:"},sort:{ascending:"Järjestä nouseva",descending:"Järjestä laskeva",remove:"Poista järjestys"},column:{hide:"Piilota sarake"},aggregation:{count:"Rivejä yht.: ",sum:"Summa: ",avg:"K.a.: ",min:"Min: ",max:"Max: "},pinning:{pinLeft:"Lukitse vasemmalle",pinRight:"Lukitse oikealle",unpin:"Poista lukitus"},gridMenu:{columns:"Sarakkeet:",importerTitle:"Tuo tiedosto",exporterAllAsCsv:"Vie tiedot csv-muodossa",exporterVisibleAsCsv:"Vie näkyvä tieto csv-muodossa",exporterSelectedAsCsv:"Vie valittu tieto csv-muodossa",exporterAllAsPdf:"Vie tiedot pdf-muodossa",exporterVisibleAsPdf:"Vie näkyvä tieto pdf-muodossa",exporterSelectedAsPdf:"Vie valittu tieto pdf-muodossa",exporterAllAsExcel:"Vie tiedot excel-muodossa",exporterVisibleAsExcel:"Vie näkyvä tieto excel-muodossa",exporterSelectedAsExcel:"Vie valittu tieto excel-muodossa",clearAllFilters:"Puhdista kaikki suodattimet"},importer:{noHeaders:"Sarakkeen nimiä ei voitu päätellä, onko tiedostossa otsikkoriviä?",noObjects:"Tietoja ei voitu lukea, onko tiedostossa muuta kuin otsikkot?",invalidCsv:"Tiedostoa ei voitu käsitellä, oliko se CSV-muodossa?",invalidJson:"Tiedostoa ei voitu käsitellä, oliko se JSON-muodossa?",jsonNotArray:"Tiedosto ei sisältänyt taulukkoa, lopetetaan."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("fr",{headerCell:{aria:{defaultFilterLabel:"Filtre de la colonne",removeFilter:"Supprimer le filtre",columnMenuButtonLabel:"Menu de la colonne"},priority:"Priorité:",filterLabel:"Filtre de la colonne: "},aggregate:{label:"éléments"},groupPanel:{description:"Faites glisser une en-tête de colonne ici pour créer un groupe de colonnes."},search:{placeholder:"Recherche...",showingItems:"Affichage des éléments :",selectedItems:"Éléments sélectionnés :",totalItems:"Nombre total d'éléments:",size:"Taille de page:",first:"Première page",next:"Page Suivante",previous:"Page précédente",last:"Dernière page"},selection:{aria:{row:"Ligne"},selectAll:"Tout Sélectionner",displayName:"Sélectionnez la ligne"},menu:{text:"Choisir des colonnes :"},sort:{ascending:"Trier par ordre croissant",descending:"Trier par ordre décroissant",none:"Aucun tri",remove:"Enlever le tri"},column:{hide:"Cacher la colonne"},aggregation:{count:"lignes totales: ",sum:"total: ",avg:"moy: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Épingler à gauche",pinRight:"Épingler à droite",unpin:"Détacher"},columnMenu:{close:"Fermer"},gridMenu:{aria:{buttonLabel:"Menu du tableau"},columns:"Colonnes:",importerTitle:"Importer un fichier",exporterAllAsCsv:"Exporter toutes les données en CSV",exporterVisibleAsCsv:"Exporter les données visibles en CSV",exporterSelectedAsCsv:"Exporter les données sélectionnées en CSV",exporterAllAsPdf:"Exporter toutes les données en PDF",exporterVisibleAsPdf:"Exporter les données visibles en PDF",exporterSelectedAsPdf:"Exporter les données sélectionnées en PDF",exporterAllAsExcel:"Exporter toutes les données en Excel",exporterVisibleAsExcel:"Exporter les données visibles en Excel",exporterSelectedAsExcel:"Exporter les données sélectionnées en Excel",clearAllFilters:"Nettoyez tous les filtres"},importer:{noHeaders:"Impossible de déterminer le nom des colonnes, le fichier possède-t-il une en-tête ?",noObjects:"Aucun objet trouvé, le fichier possède-t-il des données autres que l'en-tête ?",invalidCsv:"Le fichier n'a pas pu être traité, le CSV est-il valide ?",invalidJson:"Le fichier n'a pas pu être traité, le JSON est-il valide ?",jsonNotArray:"Le fichier JSON importé doit contenir un tableau, abandon."},pagination:{aria:{pageToFirst:"Aller à la première page",pageBack:"Page précédente",pageSelected:"Page sélectionnée",pageForward:"Page suivante",pageToLast:"Aller à la dernière page"},sizes:"éléments par page",totalItems:"éléments",through:"à",of:"sur"},grouping:{group:"Grouper",ungroup:"Dégrouper",aggregate_count:"Agg: Compter",aggregate_sum:"Agg: Somme",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Moy",aggregate_remove:"Agg: Retirer"},validate:{error:"Erreur:",minLength:"La valeur doit être supérieure ou égale à THRESHOLD caractères.",maxLength:"La valeur doit être inférieure ou égale à THRESHOLD caractères.",required:"Une valeur est nécéssaire."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("he",{aggregate:{label:"items"},groupPanel:{description:"גרור עמודה לכאן ושחרר בכדי לקבץ עמודה זו."},search:{placeholder:"חפש...",showingItems:"מציג:",selectedItems:'סה"כ נבחרו:',totalItems:'סה"כ רשומות:',size:"תוצאות בדף:",first:"דף ראשון",next:"דף הבא",previous:"דף קודם",last:"דף אחרון"},menu:{text:"בחר עמודות:"},sort:{ascending:"סדר עולה",descending:"סדר יורד",remove:"בטל"},column:{hide:"טור הסתר"},aggregation:{count:"total rows: ",sum:"total: ",avg:"avg: ",min:"min: ",max:"max: "},gridMenu:{columns:"Columns:",importerTitle:"Import file",exporterAllAsCsv:"Export all data as csv",exporterVisibleAsCsv:"Export visible data as csv",exporterSelectedAsCsv:"Export selected data as csv",exporterAllAsPdf:"Export all data as pdf",exporterVisibleAsPdf:"Export visible data as pdf",exporterSelectedAsPdf:"Export selected data as pdf",exporterAllAsExcel:"Export all data as excel",exporterVisibleAsExcel:"Export visible data as excel",exporterSelectedAsExcel:"Export selected data as excel",clearAllFilters:"Clean all filters"},importer:{noHeaders:"Column names were unable to be derived, does the file have a header?",noObjects:"Objects were not able to be derived, was there data in the file other than headers?",invalidCsv:"File was unable to be processed, is it valid CSV?",invalidJson:"File was unable to be processed, is it valid Json?",jsonNotArray:"Imported json file must contain an array, aborting."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("hy",{aggregate:{label:"տվյալներ"},groupPanel:{description:"Ըստ սյան խմբավորելու համար քաշեք և գցեք վերնագիրն այստեղ։"},search:{placeholder:"Փնտրում...",showingItems:"Ցուցադրված տվյալներ՝",selectedItems:"Ընտրված:",totalItems:"Ընդամենը՝",size:"Տողերի քանակը էջում՝",first:"Առաջին էջ",next:"Հաջորդ էջ",previous:"Նախորդ էջ",last:"Վերջին էջ"},menu:{text:"Ընտրել սյուները:"},sort:{ascending:"Աճման կարգով",descending:"Նվազման կարգով",remove:"Հանել "},column:{hide:"Թաքցնել սյունը"},aggregation:{count:"ընդամենը տող՝ ",sum:"ընդամենը՝ ",avg:"միջին՝ ",min:"մին՝ ",max:"մաքս՝ "},pinning:{pinLeft:"Կպցնել ձախ կողմում",pinRight:"Կպցնել աջ կողմում",unpin:"Արձակել"},gridMenu:{columns:"Սյուներ:",importerTitle:"Ներմուծել ֆայլ",exporterAllAsCsv:"Արտահանել ամբողջը CSV",exporterVisibleAsCsv:"Արտահանել երևացող տվյալները CSV",exporterSelectedAsCsv:"Արտահանել ընտրված տվյալները CSV",exporterAllAsPdf:"Արտահանել PDF",exporterVisibleAsPdf:"Արտահանել երևացող տվյալները PDF",exporterSelectedAsPdf:"Արտահանել ընտրված տվյալները PDF",exporterAllAsExcel:"Արտահանել excel",exporterVisibleAsExcel:"Արտահանել երևացող տվյալները excel",exporterSelectedAsExcel:"Արտահանել ընտրված տվյալները excel",clearAllFilters:"Մաքրել բոլոր ֆիլտրերը"},importer:{noHeaders:"Հնարավոր չեղավ որոշել սյան վերնագրերը։ Արդյո՞ք ֆայլը ունի վերնագրեր։",noObjects:"Հնարավոր չեղավ կարդալ տվյալները։ Արդյո՞ք ֆայլում կան տվյալներ։",invalidCsv:"Հնարավոր չեղավ մշակել ֆայլը։ Արդյո՞ք այն վավեր CSV է։",invalidJson:"Հնարավոր չեղավ մշակել ֆայլը։ Արդյո՞ք այն վավեր Json է։",jsonNotArray:"Ներմուծված json ֆայլը պետք է պարունակի զանգված, կասեցվում է։"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("is",{headerCell:{aria:{defaultFilterLabel:"Sía fyrir dálk",removeFilter:"Fjarlægja síu",columnMenuButtonLabel:"Dálkavalmynd"},priority:"Forgangsröðun:",filterLabel:"Sía fyrir dálka: "},aggregate:{label:"hlutir"},groupPanel:{description:"Dragðu dálkhaus hingað til að flokka saman eftir þeim dálki."},search:{placeholder:"Leita...",showingItems:"Sýni hluti:",selectedItems:"Valdir hlutir:",totalItems:"Hlutir alls:",size:"Stærð síðu:",first:"Fyrsta síða",next:"Næsta síða",previous:"Fyrri síða",last:"Síðasta síða"},menu:{text:"Veldu dálka:"},sort:{ascending:"Raða hækkandi",descending:"Raða lækkandi",none:"Engin röðun",remove:"Fjarlægja röðun"},column:{hide:"Fela dálk"},aggregation:{count:"fjöldi raða: ",sum:"summa: ",avg:"meðaltal: ",min:"lágmark: ",max:"hámark: "},pinning:{pinLeft:"Festa til vinstri",pinRight:"Festa til hægri",unpin:"Losa"},columnMenu:{close:"Loka"},gridMenu:{aria:{buttonLabel:"Töflu valmynd"},columns:"Dálkar:",importerTitle:"Flytja inn skjal",exporterAllAsCsv:"Flytja út gögn sem csv",exporterVisibleAsCsv:"Flytja út sýnileg gögn sem csv",exporterSelectedAsCsv:"Flytja út valin gögn sem csv",exporterAllAsPdf:"Flytja út öll gögn sem pdf",exporterVisibleAsPdf:"Flytja út sýnileg gögn sem pdf",exporterSelectedAsPdf:"Flytja út valin gögn sem pdf",clearAllFilters:"Hreinsa allar síur"},importer:{noHeaders:"Ekki hægt að vinna dálkanöfn úr skjalinu, er skjalið örugglega með haus?",noObjects:"Ekki hægt að vinna hluti úr skjalinu, voru örugglega gögn í skjalinu önnur en hausinn?",invalidCsv:"Tókst ekki að vinna skjal, er það örggulega gilt CSV?",invalidJson:"Tókst ekki að vinna skjal, er það örugglega gilt Json?",jsonNotArray:"Innflutt json skjal verður að innihalda fylki, hætti við."},pagination:{aria:{pageToFirst:"Fletta að fyrstu",pageBack:"Fletta til baka",pageSelected:"Valin síða",pageForward:"Fletta áfram",pageToLast:"Fletta að síðustu"},sizes:"hlutir á síðu",totalItems:"hlutir",through:"gegnum",of:"af"},grouping:{group:"Flokka",ungroup:"Sundurliða",aggregate_count:"Fjöldi: ",aggregate_sum:"Summa: ",aggregate_max:"Hámark: ",aggregate_min:"Lágmark: ",aggregate_avg:"Meðaltal: ",aggregate_remove:"Fjarlægja: "},validate:{error:"Villa:",minLength:"Gildi ætti að vera a.m.k. THRESHOLD stafa langt.",maxLength:"Gildi ætti að vera í mesta lagi THRESHOLD stafa langt.",required:"Þarf að hafa gildi."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("it",{aggregate:{label:"elementi"},groupPanel:{description:"Trascina un'intestazione all'interno del gruppo della colonna."},search:{placeholder:"Ricerca...",showingItems:"Mostra:",selectedItems:"Selezionati:",totalItems:"Totali:",size:"Tot Pagine:",first:"Prima",next:"Prossima",previous:"Precedente",last:"Ultima"},selection:{aria:{row:"Riga"},selectAll:"Seleccionar Todo",displayName:"Seleziona Riga"},menu:{text:"Scegli le colonne:"},sort:{ascending:"Asc.",descending:"Desc.",remove:"Annulla ordinamento"},column:{hide:"Nascondi"},aggregation:{count:"righe totali: ",sum:"tot: ",avg:"media: ",min:"minimo: ",max:"massimo: "},pinning:{pinLeft:"Blocca a sx",pinRight:"Blocca a dx",unpin:"Blocca in alto"},gridMenu:{columns:"Colonne:",importerTitle:"Importa",exporterAllAsCsv:"Esporta tutti i dati in CSV",exporterVisibleAsCsv:"Esporta i dati visibili in CSV",exporterSelectedAsCsv:"Esporta i dati selezionati in CSV",exporterAllAsPdf:"Esporta tutti i dati in PDF",exporterVisibleAsPdf:"Esporta i dati visibili in PDF",exporterSelectedAsPdf:"Esporta i dati selezionati in PDF",exporterAllAsExcel:"Esporta tutti i dati in excel",exporterVisibleAsExcel:"Esporta i dati visibili in excel",exporterSelectedAsExcel:"Esporta i dati selezionati in excel",clearAllFilters:"Pulire tutti i filtri"},importer:{noHeaders:"Impossibile reperire i nomi delle colonne, sicuro che siano indicati all'interno del file?",noObjects:"Impossibile reperire gli oggetti, sicuro che siano indicati all'interno del file?",invalidCsv:"Impossibile elaborare il file, sicuro che sia un CSV?",invalidJson:"Impossibile elaborare il file, sicuro che sia un JSON valido?",jsonNotArray:"Errore! Il file JSON da importare deve contenere un array."},pagination:{aria:{pageToFirst:"Prima",pageBack:"Indietro",pageSelected:"Pagina selezionata",pageForward:"Avanti",pageToLast:"Ultima"},sizes:"elementi per pagina",totalItems:"elementi",through:"a",of:"di"},grouping:{group:"Raggruppa",ungroup:"Separa",aggregate_count:"Agg: N. Elem.",aggregate_sum:"Agg: Somma",aggregate_max:"Agg: Massimo",aggregate_min:"Agg: Minimo",aggregate_avg:"Agg: Media",aggregate_remove:"Agg: Rimuovi"},validate:{error:"Errore:",minLength:"Lunghezza minima pari a THRESHOLD caratteri.",maxLength:"Lunghezza massima pari a THRESHOLD caratteri.",required:"Necessario inserire un valore."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ja",{headerCell:{aria:{defaultFilterLabel:"列のフィルター",removeFilter:"フィルターの解除",columnMenuButtonLabel:"列のメニュー"},priority:"優先度:",filterLabel:"列フィルター: "},aggregate:{label:"項目"},groupPanel:{description:"ここに列ヘッダをドラッグアンドドロップして、その列でグループ化します。"},search:{placeholder:"検索...",showingItems:"表示中の項目:",selectedItems:"選択した項目:",totalItems:"項目の総数:",size:"ページサイズ:",first:"最初のページ",next:"次のページ",previous:"前のページ",last:"前のページ"},menu:{text:"列の選択:"},sort:{ascending:"昇順に並べ替え",descending:"降順に並べ替え",none:"並べ替え無し",remove:"並べ替えの解除"},column:{hide:"列の非表示"},aggregation:{count:"行数: ",sum:"合計: ",avg:"平均: ",min:"最小: ",max:"最大: "},pinning:{pinLeft:"左に固定",pinRight:"右に固定",unpin:"固定解除"},columnMenu:{close:"閉じる"},gridMenu:{aria:{buttonLabel:"グリッドメニュー"},columns:"列の表示/非表示:",importerTitle:"ファイルのインポート",exporterAllAsCsv:"すべてのデータをCSV形式でエクスポート",exporterVisibleAsCsv:"表示中のデータをCSV形式でエクスポート",exporterSelectedAsCsv:"選択したデータをCSV形式でエクスポート",exporterAllAsPdf:"すべてのデータをPDF形式でエクスポート",exporterVisibleAsPdf:"表示中のデータをPDF形式でエクスポート",exporterSelectedAsPdf:"選択したデータをPDF形式でエクスポート",clearAllFilters:"すべてのフィルタをクリア"},importer:{noHeaders:"列名を取得できません。ファイルにヘッダが含まれていることを確認してください。",noObjects:"オブジェクトを取得できません。ファイルにヘッダ以外のデータが含まれていることを確認してください。",invalidCsv:"ファイルを処理できません。ファイルが有効なCSV形式であることを確認してください。",invalidJson:"ファイルを処理できません。ファイルが有効なJSON形式であることを確認してください。",jsonNotArray:"インポートしたJSONファイルには配列が含まれている必要があります。処理を中止します。"},pagination:{aria:{pageToFirst:"最初のページ",pageBack:"前のページ",pageSelected:"現在のページ",pageForward:"次のページ",pageToLast:"最後のページ"},sizes:"件/ページ",totalItems:"件",through:"から",of:"件/全"},grouping:{group:"グループ化",ungroup:"グループ化の解除",aggregate_count:"集計表示: 行数",aggregate_sum:"集計表示: 合計",aggregate_max:"集計表示: 最大",aggregate_min:"集計表示: 最小",aggregate_avg:"集計表示: 平均",aggregate_remove:"集計表示: 解除"},validate:{error:"Error:",minLength:"THRESHOLD 文字以上で入力してください。",maxLength:"THRESHOLD 文字以下で入力してください。",required:"値が必要です。"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ko",{aggregate:{label:"아이템"},groupPanel:{description:"컬럼으로 그룹핑하기 위해서는 컬럼 헤더를 끌어 떨어뜨려 주세요."},search:{placeholder:"검색...",showingItems:"항목 보여주기:",selectedItems:"선택 항목:",totalItems:"전체 항목:",size:"페이지 크기:",first:"첫번째 페이지",next:"다음 페이지",previous:"이전 페이지",last:"마지막 페이지"},menu:{text:"컬럼을 선택하세요:"},sort:{ascending:"오름차순 정렬",descending:"내림차순 정렬",remove:"소팅 제거"},column:{hide:"컬럼 제거"},aggregation:{count:"전체 갯수: ",sum:"전체: ",avg:"평균: ",min:"최소: ",max:"최대: "},pinning:{pinLeft:"왼쪽 핀",pinRight:"오른쪽 핀",unpin:"핀 제거"},gridMenu:{columns:"컬럼:",importerTitle:"파일 가져오기",exporterAllAsCsv:"csv로 모든 데이터 내보내기",exporterVisibleAsCsv:"csv로 보이는 데이터 내보내기",exporterSelectedAsCsv:"csv로 선택된 데이터 내보내기",exporterAllAsPdf:"pdf로 모든 데이터 내보내기",exporterVisibleAsPdf:"pdf로 보이는 데이터 내보내기",exporterSelectedAsPdf:"pdf로 선택 데이터 내보내기",clearAllFilters:"모든 필터를 청소"},importer:{noHeaders:"컬럼명이 지정되어 있지 않습니다. 파일에 헤더가 명시되어 있는지 확인해 주세요.",noObjects:"데이터가 지정되어 있지 않습니다. 데이터가 파일에 있는지 확인해 주세요.",invalidCsv:"파일을 처리할 수 없습니다. 올바른 csv인지 확인해 주세요.",invalidJson:"파일을 처리할 수 없습니다. 올바른 json인지 확인해 주세요.",jsonNotArray:"json 파일은 배열을 포함해야 합니다."},pagination:{sizes:"페이지당 항목",totalItems:"전체 항목"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("nl",{aggregate:{label:"items"},groupPanel:{description:"Sleep hier een kolomnaam heen om op te groeperen."},search:{placeholder:"Zoeken...",showingItems:"Getoonde items:",selectedItems:"Geselecteerde items:",totalItems:"Totaal aantal items:",size:"Items per pagina:",first:"Eerste pagina",next:"Volgende pagina",previous:"Vorige pagina",last:"Laatste pagina"},menu:{text:"Kies kolommen:"},sort:{ascending:"Sorteer oplopend",descending:"Sorteer aflopend",remove:"Verwijder sortering"},column:{hide:"Verberg kolom"},aggregation:{count:"Aantal rijen: ",sum:"Som: ",avg:"Gemiddelde: ",min:"Min: ",max:"Max: "},pinning:{pinLeft:"Zet links vast",pinRight:"Zet rechts vast",unpin:"Maak los"},gridMenu:{columns:"Kolommen:",importerTitle:"Importeer bestand",exporterAllAsCsv:"Exporteer alle data als csv",exporterVisibleAsCsv:"Exporteer zichtbare data als csv",exporterSelectedAsCsv:"Exporteer geselecteerde data als csv",exporterAllAsPdf:"Exporteer alle data als pdf",exporterVisibleAsPdf:"Exporteer zichtbare data als pdf",exporterSelectedAsPdf:"Exporteer geselecteerde data als pdf",exporterAllAsExcel:"Exporteer alle data als excel",exporterVisibleAsExcel:"Exporteer zichtbare data als excel",exporterSelectedAsExcel:"Exporteer alle data als excel",clearAllFilters:"Alle filters wissen"},importer:{noHeaders:"Kolomnamen kunnen niet worden afgeleid. Heeft het bestand een header?",noObjects:"Objecten kunnen niet worden afgeleid. Bevat het bestand data naast de headers?",invalidCsv:"Het bestand kan niet verwerkt worden. Is het een valide csv bestand?",invalidJson:"Het bestand kan niet verwerkt worden. Is het valide json?",jsonNotArray:"Het json bestand moet een array bevatten. De actie wordt geannuleerd."},pagination:{sizes:"items per pagina",totalItems:"items",of:"van de"},grouping:{group:"Groepeer",ungroup:"Groepering opheffen",aggregate_count:"Agg: Aantal",aggregate_sum:"Agg: Som",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Gem",aggregate_remove:"Agg: Verwijder"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("no",{headerCell:{aria:{defaultFilterLabel:"Filter for kolonne",removeFilter:"Fjern filter",columnMenuButtonLabel:"Kolonnemeny"},priority:"Prioritet:",filterLabel:"Filter for kolonne: "},aggregate:{label:"elementer"},groupPanel:{description:"Trekk en kolonneoverskrift hit og slipp den for å gruppere etter den kolonnen."},search:{placeholder:"Søk...",showingItems:"Viste elementer:",selectedItems:"Valgte elementer:",totalItems:"Antall elementer:",size:"Sidestørrelse:",first:"Første side",next:"Neste side",previous:"Forrige side",last:"Siste side"},menu:{text:"Velg kolonner:"},sort:{ascending:"Sortere stigende",descending:"Sortere fallende",none:"Ingen sortering",remove:"Fjern sortering"},column:{hide:"Skjul kolonne"},aggregation:{count:"antall rader: ",sum:"total: ",avg:"gjennomsnitt: ",min:"minimum: ",max:"maksimum: "},pinning:{pinLeft:"Fest til venstre",pinRight:"Fest til høyre",unpin:"Løsne"},columnMenu:{close:"Lukk"},gridMenu:{aria:{buttonLabel:"Grid Menu"},columns:"Kolonner:",importerTitle:"Importer fil",exporterAllAsCsv:"Eksporter alle data som csv",exporterVisibleAsCsv:"Eksporter synlige data som csv",exporterSelectedAsCsv:"Eksporter utvalgte data som csv",exporterAllAsPdf:"Eksporter alle data som pdf",exporterVisibleAsPdf:"Eksporter synlige data som pdf",exporterSelectedAsPdf:"Eksporter utvalgte data som pdf",exporterAllAsExcel:"Eksporter alle data som excel",exporterVisibleAsExcel:"Eksporter synlige data som excel",exporterSelectedAsExcel:"Eksporter utvalgte data som excel",clearAllFilters:"Clear all filters"},importer:{noHeaders:"Kolonnenavn kunne ikke avledes. Har filen en overskrift?",noObjects:"Objekter kunne ikke avledes. Er der andre data i filen enn overskriften?",invalidCsv:"Filen kunne ikke behandles. Er den gyldig CSV?",invalidJson:"Filen kunne ikke behandles. Er den gyldig JSON?",jsonNotArray:"Importert JSON-fil må inneholde en liste. Avbryter."},pagination:{aria:{pageToFirst:"Gå til første side",pageBack:"Gå til forrige side",pageSelected:"Valgte side",pageForward:"Gå til neste side",pageToLast:"Gå til siste side"},sizes:"elementer per side",totalItems:"elementer",through:"til",of:"av"},grouping:{group:"Gruppere",ungroup:"Fjerne gruppering",aggregate_count:"Agr: Antall",aggregate_sum:"Agr: Sum",aggregate_max:"Agr: Maksimum",aggregate_min:"Agr: Minimum",aggregate_avg:"Agr: Gjennomsnitt",aggregate_remove:"Agr: Fjern"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("pl",{headerCell:{aria:{defaultFilterLabel:"Filtr dla kolumny",removeFilter:"Usuń filtr",columnMenuButtonLabel:"Opcje kolumny",column:"Kolumna"},priority:"Priorytet:",filterLabel:"Filtr dla kolumny: "},aggregate:{label:"pozycji"},groupPanel:{description:"Przeciągnij nagłówek kolumny tutaj, aby pogrupować według niej."},search:{aria:{selected:"Wiersz zaznaczony",notSelected:"Wiersz niezaznaczony"},placeholder:"Szukaj...",showingItems:"Widoczne pozycje:",selectedItems:"Zaznaczone pozycje:",totalItems:"Wszystkich pozycji:",size:"Rozmiar strony:",first:"Pierwsza strona",next:"Następna strona",previous:"Poprzednia strona",last:"Ostatnia strona"},menu:{text:"Wybierz kolumny:"},sort:{ascending:"Sortuj rosnąco",descending:"Sortuj malejąco",none:"Brak sortowania",remove:"Wyłącz sortowanie"},column:{hide:"Ukryj kolumnę"},aggregation:{count:"Razem pozycji: ",sum:"Razem: ",avg:"Średnia: ",min:"Min: ",max:"Max: "},pinning:{pinLeft:"Przypnij do lewej",pinRight:"Przypnij do prawej",unpin:"Odepnij"},columnMenu:{close:"Zamknij"},gridMenu:{aria:{buttonLabel:"Opcje tabeli"},columns:"Kolumny:",importerTitle:"Importuj plik",exporterAllAsCsv:"Eksportuj wszystkie dane do csv",exporterVisibleAsCsv:"Eksportuj widoczne dane do csv",exporterSelectedAsCsv:"Eksportuj zaznaczone dane do csv",exporterAllAsPdf:"Eksportuj wszystkie dane do pdf",exporterVisibleAsPdf:"Eksportuj widoczne dane do pdf",exporterSelectedAsPdf:"Eksportuj zaznaczone dane do pdf",exporterAllAsExcel:"Eksportuj wszystkie dane do excel",exporterVisibleAsExcel:"Eksportuj widoczne dane do excel",exporterSelectedAsExcel:"Eksportuj zaznaczone dane do excel",clearAllFilters:"Wyczyść filtry"},importer:{noHeaders:"Nie udało się wczytać nazw kolumn. Czy plik posiada nagłówek?",noObjects:"Nie udalo się wczytać pozycji. Czy plik zawiera dane?",invalidCsv:"Nie udało się przetworzyć pliku. Czy to prawidłowy plik CSV?",invalidJson:"Nie udało się przetworzyć pliku. Czy to prawidłowy plik JSON?",jsonNotArray:"Importowany plik JSON musi zawierać tablicę. Importowanie przerwane."},pagination:{aria:{pageToFirst:"Pierwsza strona",pageBack:"Poprzednia strona",pageSelected:"Wybrana strona",pageForward:"Następna strona",pageToLast:"Ostatnia strona"},sizes:"pozycji na stronę",totalItems:"pozycji",through:"do",of:"z"},grouping:{group:"Grupuj",ungroup:"Rozgrupuj",aggregate_count:"Zbiorczo: Razem",aggregate_sum:"Zbiorczo: Suma",aggregate_max:"Zbiorczo: Max",aggregate_min:"Zbiorczo: Min",aggregate_avg:"Zbiorczo: Średnia",aggregate_remove:"Zbiorczo: Usuń"},validate:{error:"Błąd:",minLength:"Wartość powinna składać się z co najmniej THRESHOLD znaków.",maxLength:"Wartość powinna składać się z przynajmniej THRESHOLD znaków.",required:"Wartość jest wymagana."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("pt-br",{headerCell:{aria:{defaultFilterLabel:"Filtro por coluna",removeFilter:"Remover filtro",columnMenuButtonLabel:"Menu coluna",column:"Coluna"},priority:"Prioridade:",filterLabel:"Filtro por coluna: "},aggregate:{label:"itens"},groupPanel:{description:"Arraste e solte uma coluna aqui para agrupar por essa coluna"},search:{aria:{selected:"Linha selecionada",notSelected:"Linha não está selecionada"},placeholder:"Procurar...",showingItems:"Mostrando os Itens:",selectedItems:"Items Selecionados:",totalItems:"Total de Itens:",size:"Tamanho da Página:",first:"Primeira Página",next:"Próxima Página",previous:"Página Anterior",last:"Última Página"},selection:{aria:{row:"Linha"},selectAll:"Selecionar Tudo",displayName:"Caixa de Seleção da Linha"},menu:{text:"Selecione as colunas:"},sort:{ascending:"Ordenar Ascendente",descending:"Ordenar Descendente",none:"Nenhuma Ordem",remove:"Remover Ordenação"},column:{hide:"Esconder coluna"},aggregation:{count:"total de linhas: ",sum:"total: ",avg:"med: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Fixar Esquerda",pinRight:"Fixar Direita",unpin:"Desprender"},columnMenu:{close:"Fechar"},gridMenu:{aria:{buttonLabel:"Menu Grid"},columns:"Colunas:",importerTitle:"Importar arquivo",exporterAllAsCsv:"Exportar todos os dados como csv",exporterVisibleAsCsv:"Exportar dados visíveis como csv",exporterSelectedAsCsv:"Exportar dados selecionados como csv",exporterAllAsPdf:"Exportar todos os dados como pdf",exporterVisibleAsPdf:"Exportar dados visíveis como pdf",exporterSelectedAsPdf:"Exportar dados selecionados como pdf",exporterAllAsExcel:"Exportar todos os dados como excel",exporterVisibleAsExcel:"Exportar dados visíveis como excel",exporterSelectedAsExcel:"Exportar dados selecionados como excel",clearAllFilters:"Limpar todos os filtros"},importer:{noHeaders:"Nomes de colunas não puderam ser derivados. O arquivo tem um cabeçalho?",noObjects:"Objetos não puderam ser derivados. Havia dados no arquivo, além dos cabeçalhos?",invalidCsv:"Arquivo não pode ser processado. É um CSV válido?",invalidJson:"Arquivo não pode ser processado. É um Json válido?",jsonNotArray:"Arquivo json importado tem que conter um array. Abortando."},pagination:{aria:{pageToFirst:"Primeira página",pageBack:"Página anterior",pageSelected:"Página Selecionada",pageForward:"Proxima",pageToLast:"Anterior"},sizes:"itens por página",totalItems:"itens",through:"através dos",of:"de"},grouping:{group:"Agrupar",ungroup:"Desagrupar",aggregate_count:"Agr: Contar",aggregate_sum:"Agr: Soma",aggregate_max:"Agr: Max",aggregate_min:"Agr: Min",aggregate_avg:"Agr: Med",aggregate_remove:"Agr: Remover"},validate:{error:"Erro:",minLength:"O valor deve ter, no minimo, THRESHOLD caracteres.",maxLength:"O valor deve ter, no máximo, THRESHOLD caracteres.",required:"Um valor é necessário."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("pt",{headerCell:{aria:{defaultFilterLabel:"Filtro por coluna",removeFilter:"Remover filtro",columnMenuButtonLabel:"Menu coluna",column:"Coluna"},priority:"Prioridade:",filterLabel:"Filtro por coluna: "},aggregate:{label:"itens"},groupPanel:{description:"Arraste e solte uma coluna aqui para agrupar por essa coluna"},search:{aria:{selected:"Linha selecionada",notSelected:"Linha não está selecionada"},placeholder:"Procurar...",showingItems:"Mostrando os Itens:",selectedItems:"Itens Selecionados:",totalItems:"Total de Itens:",size:"Tamanho da Página:",first:"Primeira Página",next:"Próxima Página",previous:"Página Anterior",last:"Última Página"},selection:{aria:{row:"Linha"},selectAll:"Selecionar Tudo",displayName:"Caixa de Seleção da Linha"},menu:{text:"Selecione as colunas:"},sort:{ascending:"Ordenar Ascendente",descending:"Ordenar Descendente",none:"Nenhuma Ordem",remove:"Remover Ordenação"},column:{hide:"Esconder coluna"},aggregation:{count:"total de linhas: ",sum:"total: ",avg:"med: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Fixar Esquerda",pinRight:"Fixar Direita",unpin:"Desprender"},columnMenu:{close:"Fechar"},gridMenu:{aria:{buttonLabel:"Menu Grid"},columns:"Colunas:",importerTitle:"Importar ficheiro",exporterAllAsCsv:"Exportar todos os dados como csv",exporterVisibleAsCsv:"Exportar dados visíveis como csv",exporterSelectedAsCsv:"Exportar dados selecionados como csv",exporterAllAsPdf:"Exportar todos os dados como pdf",exporterVisibleAsPdf:"Exportar dados visíveis como pdf",exporterSelectedAsPdf:"Exportar dados selecionados como pdf",exporterAllAsExcel:"Exportar todos os dados como excel",exporterVisibleAsExcel:"Exportar dados visíveis como excel",exporterSelectedAsExcel:"Exportar dados selecionados como excel",clearAllFilters:"Limpar todos os filtros"},importer:{noHeaders:"Nomes de colunas não puderam ser derivados. O ficheiro tem um cabeçalho?",noObjects:"Objetos não puderam ser derivados. Havia dados no ficheiro, além dos cabeçalhos?",invalidCsv:"Ficheiro não pode ser processado. É um CSV válido?",invalidJson:"Ficheiro não pode ser processado. É um Json válido?",jsonNotArray:"Ficheiro json importado tem que conter um array. Interrompendo."},pagination:{aria:{pageToFirst:"Primeira página",pageBack:"Página anterior",pageSelected:"Página Selecionada",pageForward:"Próxima",pageToLast:"Anterior"},sizes:"itens por página",totalItems:"itens",through:"a",of:"de"},grouping:{group:"Agrupar",ungroup:"Desagrupar",aggregate_count:"Agr: Contar",aggregate_sum:"Agr: Soma",aggregate_max:"Agr: Max",aggregate_min:"Agr: Min",aggregate_avg:"Agr: Med",aggregate_remove:"Agr: Remover"},validate:{error:"Erro:",minLength:"O valor deve ter, no minimo, THRESHOLD caracteres.",maxLength:"O valor deve ter, no máximo, THRESHOLD caracteres.",required:"Um valor é necessário."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ro",{headerCell:{aria:{defaultFilterLabel:"Filtru pentru coloana",removeFilter:"Sterge filtru",columnMenuButtonLabel:"Column Menu"},priority:"Prioritate:",filterLabel:"Filtru pentru coloana:"},aggregate:{label:"Elemente"},groupPanel:{description:"Trage un cap de coloana aici pentru a grupa elementele dupa coloana respectiva"},search:{placeholder:"Cauta...",showingItems:"Arata elementele:",selectedItems:"Elementele selectate:",totalItems:"Total elemente:",size:"Marime pagina:",first:"Prima pagina",next:"Pagina urmatoare",previous:"Pagina anterioara",last:"Ultima pagina"},menu:{text:"Alege coloane:"},sort:{ascending:"Ordoneaza crescator",descending:"Ordoneaza descrescator",none:"Fara ordonare",remove:"Sterge ordonarea"},column:{hide:"Ascunde coloana"},aggregation:{count:"total linii: ",sum:"total: ",avg:"medie: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Pin la stanga",pinRight:"Pin la dreapta",unpin:"Sterge pinul"},columnMenu:{close:"Inchide"},gridMenu:{aria:{buttonLabel:"Grid Menu"},columns:"Coloane:",importerTitle:"Incarca fisier",exporterAllAsCsv:"Exporta toate datele ca csv",exporterVisibleAsCsv:"Exporta datele vizibile ca csv",exporterSelectedAsCsv:"Exporta datele selectate ca csv",exporterAllAsPdf:"Exporta toate datele ca pdf",exporterVisibleAsPdf:"Exporta datele vizibile ca pdf",exporterSelectedAsPdf:"Exporta datele selectate ca csv pdf",clearAllFilters:"Sterge toate filtrele"},importer:{noHeaders:"Numele coloanelor nu a putut fi incarcat, acest fisier are un header?",noObjects:"Datele nu au putut fi incarcate, exista date in fisier in afara numelor de coloane?",invalidCsv:"Fisierul nu a putut fi procesat, ati incarcat un CSV valid ?",invalidJson:"Fisierul nu a putut fi procesat, ati incarcat un Json valid?",jsonNotArray:"Json-ul incarcat trebuie sa contina un array, inchidere."},pagination:{aria:{pageToFirst:"Prima pagina",pageBack:"O pagina inapoi",pageSelected:"Pagina selectata",pageForward:"O pagina inainte",pageToLast:"Ultima pagina"},sizes:"Elemente per pagina",totalItems:"elemente",through:"prin",of:"of"},grouping:{group:"Grupeaza",ungroup:"Opreste gruparea",aggregate_count:"Agg: Count",aggregate_sum:"Agg: Sum",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Avg",aggregate_remove:"Agg: Remove"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("rs-lat",{headerCell:{aria:{defaultFilterLabel:"Filter za kolonu",removeFilter:"Ukloni Filter",columnMenuButtonLabel:"Meni Kolone",column:"Kolona"},priority:"Prioritet:",filterLabel:"Filter za kolonu: "},aggregate:{label:"stavke"},groupPanel:{description:"Ovde prevuci zaglavlje kolone i spusti do grupe pored te kolone."},search:{aria:{selected:"Red odabran",notSelected:"Red nije odabran"},placeholder:"Pretraga...",showingItems:"Prikazane Stavke:",selectedItems:"Odabrane Stavke:",totalItems:"Ukupno Stavki:",size:"Veličina Stranice:",first:"Prva Stranica",next:"Sledeća Stranica",previous:"Prethodna Stranica",last:"Poslednja Stranica"},menu:{text:"Odaberite kolonu:"},sort:{ascending:"Sortiraj po rastućem redosledu",descending:"Sortiraj po opadajućem redosledu",none:"Bez Sortiranja",remove:"Ukloni Sortiranje"},column:{hide:"Sakrij Kolonu"},aggregation:{count:"ukupno redova: ",sum:"ukupno: ",avg:"prosecno: ",min:"minimum: ",max:"maksimum: "},pinning:{pinLeft:"Zakači Levo",pinRight:"Zakači Desno",unpin:"Otkači"},columnMenu:{close:"Zatvori"},gridMenu:{aria:{buttonLabel:"Rešetkasti Meni"},columns:"Kolone:",importerTitle:"Importuj fajl",exporterAllAsCsv:"Eksportuj sve podatke kao csv",exporterVisibleAsCsv:"Eksportuj vidljive podatke kao csv",exporterSelectedAsCsv:"Eksportuj obeležene podatke kao csv",exporterAllAsPdf:"Eksportuj sve podatke kao pdf",exporterVisibleAsPdf:"Eksportuj vidljive podake kao pdf",exporterSelectedAsPdf:"Eksportuj odabrane podatke kao pdf",exporterAllAsExcel:"Eksportuj sve podatke kao excel",exporterVisibleAsExcel:"Eksportuj vidljive podatke kao excel",exporterSelectedAsExcel:"Eksportuj odabrane podatke kao excel",clearAllFilters:"Obriši sve filtere"},importer:{noHeaders:"Kolone se nisu mogle podeliti, da li fajl poseduje heder?",noObjects:"Objecti nisu mogli biti podeljeni, da li je bilo i drugih podataka sem hedera?",invalidCsv:"Fajl nije bilo moguće procesirati, da li je ispravni CSV?",invalidJson:"Fajl nije bilo moguće procesirati, da li je ispravni JSON",jsonNotArray:"Importovani json fajl mora da sadrži niz, prekidam operaciju."},pagination:{aria:{pageToFirst:"Prva stranica",pageBack:"Stranica pre",pageSelected:"Odabrana stranica",pageForward:"Sledeća stranica",pageToLast:"Poslednja stranica"},sizes:"stavki po stranici",totalItems:"stavke",through:"kroz",of:"od"},grouping:{group:"Grupiši",ungroup:"Odrupiši",aggregate_count:"Agg: Broj",aggregate_sum:"Agg: Suma",aggregate_max:"Agg: Maksimum",aggregate_min:"Agg: Minimum",aggregate_avg:"Agg: Prosečna",aggregate_remove:"Agg: Ukloni"},validate:{error:"Greška:",minLength:"Vrednost bi trebala da bude duga bar THRESHOLD karaktera.",maxLength:"Vrednost bi trebalo da bude najviše duga THRESHOLD karaktera.",required:"Portreba je vrednost."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ru",{headerCell:{aria:{defaultFilterLabel:"Фильтр столбца",removeFilter:"Удалить фильтр",columnMenuButtonLabel:"Меню столбца"},priority:"Приоритет:",filterLabel:"Фильтр столбца: "},aggregate:{label:"элементы"},groupPanel:{description:"Для группировки по столбцу перетащите сюда его название."},search:{placeholder:"Поиск...",showingItems:"Показать элементы:",selectedItems:"Выбранные элементы:",totalItems:"Всего элементов:",size:"Размер страницы:",first:"Первая страница",next:"Следующая страница",previous:"Предыдущая страница",last:"Последняя страница"},menu:{text:"Выбрать столбцы:"},sort:{ascending:"По возрастанию",descending:"По убыванию",none:"Без сортировки",remove:"Убрать сортировку"},column:{hide:"Спрятать столбец"},aggregation:{count:"всего строк: ",sum:"итого: ",avg:"среднее: ",min:"мин: ",max:"макс: "},pinning:{pinLeft:"Закрепить слева",pinRight:"Закрепить справа",unpin:"Открепить"},columnMenu:{close:"Закрыть"},gridMenu:{aria:{buttonLabel:"Меню"},columns:"Столбцы:",importerTitle:"Импортировать файл",exporterAllAsCsv:"Экспортировать всё в CSV",exporterVisibleAsCsv:"Экспортировать видимые данные в CSV",exporterSelectedAsCsv:"Экспортировать выбранные данные в CSV",exporterAllAsPdf:"Экспортировать всё в PDF",exporterVisibleAsPdf:"Экспортировать видимые данные в PDF",exporterSelectedAsPdf:"Экспортировать выбранные данные в PDF",exporterAllAsExcel:"Экспортировать всё в Excel",exporterVisibleAsExcel:"Экспортировать видимые данные в Excel",exporterSelectedAsExcel:"Экспортировать выбранные данные в Excel",clearAllFilters:"Очистить все фильтры"},importer:{noHeaders:"Не удалось получить названия столбцов, есть ли в файле заголовок?",noObjects:"Не удалось получить данные, есть ли в файле строки кроме заголовка?",invalidCsv:"Не удалось обработать файл, это правильный CSV-файл?",invalidJson:"Не удалось обработать файл, это правильный JSON?",jsonNotArray:"Импортируемый JSON-файл должен содержать массив, операция отменена."},pagination:{aria:{pageToFirst:"Первая страница",pageBack:"Предыдущая страница",pageSelected:"Выбранная страница",pageForward:"Следующая страница",pageToLast:"Последняя страница"},sizes:"строк на страницу",totalItems:"строк",through:"по",of:"из"},grouping:{group:"Группировать",ungroup:"Разгруппировать",aggregate_count:"Группировать: Количество",aggregate_sum:"Для группы: Сумма",aggregate_max:"Для группы: Максимум",aggregate_min:"Для группы: Минимум",aggregate_avg:"Для группы: Среднее",aggregate_remove:"Для группы: Пусто"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("sk",{headerCell:{aria:{defaultFilterLabel:"Filter pre stĺpec",removeFilter:"Odstrániť filter",columnMenuButtonLabel:"Menu pre stĺpec",column:"Stĺpec"},priority:"Priorita:",filterLabel:"Filter pre stĺpec: "},aggregate:{label:"položky"},groupPanel:{description:"Pretiahni sem názov stĺpca pre zoskupenie podľa toho stĺpca."},search:{aria:{selected:"Označený riadok",notSelected:"Neoznačený riadok"},placeholder:"Hľadaj...",showingItems:"Zobrazujem položky:",selectedItems:"Vybraté položky:",totalItems:"Počet položiek:",size:"Počet:",first:"Prvá strana",next:"Ďalšia strana",previous:"Predchádzajúca strana",last:"Posledná strana"},menu:{text:"Vyberte stĺpce:"},sort:{ascending:"Zotriediť vzostupne",descending:"Zotriediť zostupne",none:"Nezotriediť",remove:"Vymazať triedenie"},column:{hide:"Skryť stĺpec"},aggregation:{count:"počet riadkov: ",sum:"spolu: ",avg:"avg: ",min:"min: ",max:"max: "},pinning:{pinLeft:"Pripnúť vľavo",pinRight:"Pripnúť vpravo",unpin:"Odopnúť"},columnMenu:{close:"Zavrieť"},gridMenu:{aria:{buttonLabel:"Grid Menu"},columns:"Stĺpce:",importerTitle:"Importovať súbor",exporterAllAsCsv:"Exportovať všetky údaje ako CSV",exporterVisibleAsCsv:"Exportovť viditeľné údaje ako CSV",exporterSelectedAsCsv:"Exportovať označené údaje ako CSV",exporterAllAsPdf:"Exportovať všetky údaje ako pdf",exporterVisibleAsPdf:"Exportovať viditeľné údaje ako pdf",exporterSelectedAsPdf:"Exportovať označené údaje ako pdf",exporterAllAsExcel:"Exportovať všetky údaje ako excel",exporterVisibleAsExcel:"Exportovať viditeľné údaje ako excel",exporterSelectedAsExcel:"Exportovať označené údaje ako excel",clearAllFilters:"Zrušiť všetky filtre"},importer:{noHeaders:"Názvy stĺpcov sa nedali odvodiť, má súbor hlavičku?",noObjects:"Objekty nebolo možné odvodiť, existovali iné údaje v súbore ako hlavičky?",invalidCsv:"Súbor sa nepodarilo spracovať, je to platný súbor CSV?",invalidJson:"Súbor nebolo možné spracovať, je to platný súbor typu Json?",jsonNotArray:"Importovaný súbor json musí obsahovať pole, ukončujem."},pagination:{aria:{pageToFirst:"Strana na začiatok",pageBack:"Strana dozadu",pageSelected:"Označená strana",pageForward:"Strana dopredu",pageToLast:"Strana na koniec"},sizes:"položky na stranu",totalItems:"položky spolu",through:"do konca",of:"z"},grouping:{group:"Zoskupiť",ungroup:"Zrušiť zoskupenie",aggregate_count:"Agg: Počet",aggregate_sum:"Agg: Suma",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Avg",aggregate_remove:"Agg: Zrušiť"},validate:{error:"Chyba:",minLength:"Hodnota by mala mať aspoň THRESHOLD znakov dlhá.",maxLength:"Hodnota by mala byť maximálne THRESHOLD znakov dlhá.",required:"Vyžaduje sa hodnota."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("sv",{headerCell:{aria:{defaultFilterLabel:"Kolumnfilter",removeFilter:"Ta bort filter",columnMenuButtonLabel:"Kolumnmeny",column:"Kolumn"},priority:"Prioritet:",filterLabel:"Filter för kolumn: "},aggregate:{label:"Poster"},groupPanel:{description:"Dra en kolumnrubrik hit och släpp den för att gruppera efter den kolumnen."},search:{aria:{selected:"Rad är vald",notSelected:"Rad är inte vald"},placeholder:"Sök...",showingItems:"Visar:",selectedItems:"Valda:",totalItems:"Antal:",size:"Sidstorlek:",first:"Första sidan",next:"Nästa sida",previous:"Föregående sida",last:"Sista sidan"},menu:{text:"Välj kolumner:"},sort:{ascending:"Sortera stigande",descending:"Sortera fallande",none:"Ingen sortering",remove:"Inaktivera sortering"},column:{hide:"Göm kolumn"},aggregation:{count:"Antal rader: ",sum:"Summa: ",avg:"Genomsnitt: ",min:"Min: ",max:"Max: "},pinning:{pinLeft:"Fäst vänster",pinRight:"Fäst höger",unpin:"Lösgör"},columnMenu:{close:"Stäng"},gridMenu:{aria:{buttonLabel:"Meny"},columns:"Kolumner:",importerTitle:"Importera fil",exporterAllAsCsv:"Exportera all data som CSV",exporterVisibleAsCsv:"Exportera synlig data som CSV",exporterSelectedAsCsv:"Exportera markerad data som CSV",exporterAllAsPdf:"Exportera all data som PDF",exporterVisibleAsPdf:"Exportera synlig data som PDF",exporterSelectedAsPdf:"Exportera markerad data som PDF",exporterAllAsExcel:"Exportera all data till Excel",exporterVisibleAsExcel:"Exportera synlig data till Excel",exporterSelectedAsExcel:"Exportera markerad data till Excel",clearAllFilters:"Nollställ alla filter"},importer:{noHeaders:"Kolumnnamn kunde inte härledas. Har filen ett sidhuvud?",noObjects:"Objekt kunde inte härledas. Har filen data undantaget sidhuvud?",invalidCsv:"Filen kunde inte behandlas, är den en giltig CSV?",invalidJson:"Filen kunde inte behandlas, är den en giltig JSON?",jsonNotArray:"Importerad JSON-fil måste innehålla ett fält. Import avbruten."},pagination:{aria:{pageToFirst:"Gå till första sidan",pageBack:"Gå en sida bakåt",pageSelected:"Vald sida",pageForward:"Gå en sida framåt",pageToLast:"Gå till sista sidan"},sizes:"Poster per sida",totalItems:"Poster",through:"genom",of:"av"},grouping:{group:"Gruppera",ungroup:"Dela upp",aggregate_count:"Agg: Antal",aggregate_sum:"Agg: Summa",aggregate_max:"Agg: Max",aggregate_min:"Agg: Min",aggregate_avg:"Agg: Genomsnitt",aggregate_remove:"Agg: Ta bort"},validate:{error:"Error:",minLength:"Värdet borde vara minst THRESHOLD tecken långt.",maxLength:"Värdet borde vara max THRESHOLD tecken långt.",required:"Ett värde krävs."}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ta",{aggregate:{label:"உருப்படிகள்"},groupPanel:{description:"ஒரு பத்தியை குழுவாக அமைக்க அப்பத்தியின் தலைப்பை இங்கே  இழுத்து வரவும் "},search:{placeholder:"தேடல் ...",showingItems:"உருப்படிகளை காண்பித்தல்:",selectedItems:"தேர்ந்தெடுக்கப்பட்ட  உருப்படிகள்:",totalItems:"மொத்த உருப்படிகள்:",size:"பக்க அளவு: ",first:"முதல் பக்கம்",next:"அடுத்த பக்கம்",previous:"முந்தைய பக்கம் ",last:"இறுதி பக்கம்"},menu:{text:"பத்திகளை தேர்ந்தெடு:"},sort:{ascending:"மேலிருந்து கீழாக",descending:"கீழிருந்து மேலாக",remove:"வரிசையை நீக்கு"},column:{hide:"பத்தியை மறைத்து வை "},aggregation:{count:"மொத்த வரிகள்:",sum:"மொத்தம்: ",avg:"சராசரி: ",min:"குறைந்தபட்ச: ",max:"அதிகபட்ச: "},pinning:{pinLeft:"இடதுபுறமாக தைக்க ",pinRight:"வலதுபுறமாக தைக்க",unpin:"பிரி"},gridMenu:{columns:"பத்திகள்:",importerTitle:"கோப்பு : படித்தல்",exporterAllAsCsv:"எல்லா தரவுகளையும் கோப்பாக்கு: csv",exporterVisibleAsCsv:"இருக்கும் தரவுகளை கோப்பாக்கு: csv",exporterSelectedAsCsv:"தேர்ந்தெடுத்த தரவுகளை கோப்பாக்கு: csv",exporterAllAsPdf:"எல்லா தரவுகளையும் கோப்பாக்கு: pdf",exporterVisibleAsPdf:"இருக்கும் தரவுகளை கோப்பாக்கு: pdf",exporterSelectedAsPdf:"தேர்ந்தெடுத்த தரவுகளை கோப்பாக்கு: pdf",clearAllFilters:"Clear all filters"},importer:{noHeaders:"பத்தியின் தலைப்புகளை பெற இயலவில்லை, கோப்பிற்கு தலைப்பு உள்ளதா?",noObjects:"இலக்குகளை உருவாக்க முடியவில்லை, கோப்பில் தலைப்புகளை தவிர தரவு ஏதேனும் உள்ளதா? ",invalidCsv:"சரிவர நடைமுறை படுத்த இயலவில்லை, கோப்பு சரிதானா? - csv",invalidJson:"சரிவர நடைமுறை படுத்த இயலவில்லை, கோப்பு சரிதானா? - json",jsonNotArray:"படித்த கோப்பில் வரிசைகள் உள்ளது, நடைமுறை ரத்து செய் : json"},pagination:{sizes:"உருப்படிகள் / பக்கம்",totalItems:"உருப்படிகள் "},grouping:{group:"குழு",ungroup:"பிரி",aggregate_count:"மதிப்பீட்டு : எண்ணு",aggregate_sum:"மதிப்பீட்டு : கூட்டல்",aggregate_max:"மதிப்பீட்டு : அதிகபட்சம்",aggregate_min:"மதிப்பீட்டு : குறைந்தபட்சம்",aggregate_avg:"மதிப்பீட்டு : சராசரி",aggregate_remove:"மதிப்பீட்டு : நீக்கு"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("tr",{headerCell:{aria:{defaultFilterLabel:"Sütun için filtre",removeFilter:"Filtreyi Kaldır",columnMenuButtonLabel:"Sütun Menüsü"},priority:"Öncelik:",filterLabel:"Sütun için filtre: "},aggregate:{label:"kayıtlar"},groupPanel:{description:"Sütuna göre gruplamak için sütun başlığını buraya sürükleyin ve bırakın."},search:{placeholder:"Arama...",showingItems:"Gösterilen Kayıt:",selectedItems:"Seçili Kayıt:",totalItems:"Toplam Kayıt:",size:"Sayfa Boyutu:",first:"İlk Sayfa",next:"Sonraki Sayfa",previous:"Önceki Sayfa",last:"Son Sayfa"},menu:{text:"Sütunları Seç:"},sort:{ascending:"Artan Sırada Sırala",descending:"Azalan Sırada Sırala",none:"Sıralama Yapma",remove:"Sıralamayı Kaldır"},column:{hide:"Sütunu Gizle"},aggregation:{count:"toplam satır: ",sum:"toplam: ",avg:"ort: ",min:"min: ",max:"maks: "},pinning:{pinLeft:"Sola Sabitle",pinRight:"Sağa Sabitle",unpin:"Sabitlemeyi Kaldır"},columnMenu:{close:"Kapat"},gridMenu:{aria:{buttonLabel:"Tablo Menü"},columns:"Sütunlar:",importerTitle:"Dosya içeri aktar",exporterAllAsCsv:"Bütün veriyi CSV olarak dışarı aktar",exporterVisibleAsCsv:"Görünen veriyi CSV olarak dışarı aktar",exporterSelectedAsCsv:"Seçili veriyi CSV olarak dışarı aktar",exporterAllAsPdf:"Bütün veriyi PDF olarak dışarı aktar",exporterVisibleAsPdf:"Görünen veriyi PDF olarak dışarı aktar",exporterSelectedAsPdf:"Seçili veriyi PDF olarak dışarı aktar",clearAllFilters:"Bütün filtreleri kaldır"},importer:{noHeaders:"Sütun isimleri üretilemiyor, dosyanın bir başlığı var mı?",noObjects:"Nesneler üretilemiyor, dosyada başlıktan başka bir veri var mı?",invalidCsv:"Dosya işlenemedi, geçerli bir CSV dosyası mı?",invalidJson:"Dosya işlenemedi, geçerli bir Json dosyası mı?",jsonNotArray:"Alınan Json dosyasında bir dizi bulunmalıdır, işlem iptal ediliyor."},pagination:{aria:{pageToFirst:"İlk sayfaya",pageBack:"Geri git",pageSelected:"Seçili sayfa",pageForward:"İleri git",pageToLast:"Sona git"},sizes:"Sayfadaki nesne sayısı",totalItems:"kayıtlar",through:"",of:""},grouping:{group:"Grupla",ungroup:"Gruplama",aggregate_count:"Yekun: Sayı",aggregate_sum:"Yekun: Toplam",aggregate_max:"Yekun: Maks",aggregate_min:"Yekun: Min",aggregate_avg:"Yekun: Ort",aggregate_remove:"Yekun: Sil"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("ua",{headerCell:{aria:{defaultFilterLabel:"Фільтр стовпчика",removeFilter:"Видалити фільтр",columnMenuButtonLabel:"Меню ствпчика"},priority:"Пріоритет:",filterLabel:"Фільтр стовпчика: "},aggregate:{label:"елементи"},groupPanel:{description:"Для групування за стовпчиком перетягніть сюди його назву."},search:{placeholder:"Пошук...",showingItems:"Показати елементи:",selectedItems:"Обрані елементи:",totalItems:"Усього елементів:",size:"Розмір сторінки:",first:"Перша сторінка",next:"Наступна сторінка",previous:"Попередня сторінка",last:"Остання сторінка"},menu:{text:"Обрати ствпчики:"},sort:{ascending:"За зростанням",descending:"За спаданням",none:"Без сортування",remove:"Прибрати сортування"},column:{hide:"Приховати стовпчик"},aggregation:{count:"усього рядків: ",sum:"ітого: ",avg:"середнє: ",min:"мін: ",max:"макс: "},pinning:{pinLeft:"Закріпити ліворуч",pinRight:"Закріпити праворуч",unpin:"Відкріпити"},columnMenu:{close:"Закрити"},gridMenu:{aria:{buttonLabel:"Меню"},columns:"Стовпчики:",importerTitle:"Імпортувати файл",exporterAllAsCsv:"Експортувати все в CSV",exporterVisibleAsCsv:"Експортувати видимі дані в CSV",exporterSelectedAsCsv:"Експортувати обрані дані в CSV",exporterAllAsPdf:"Експортувати все в PDF",exporterVisibleAsPdf:"Експортувати видимі дані в PDF",exporterSelectedAsPdf:"Експортувати обрані дані в PDF",clearAllFilters:"Очистити всі фільтри"},importer:{noHeaders:"Не вдалося отримати назви стовпчиків, чи є в файлі заголовок?",noObjects:"Не вдалося отримати дані, чи є в файлі рядки окрім заголовка?",invalidCsv:"Не вдалося обробити файл, чи це коректний CSV-файл?",invalidJson:"Не вдалося обробити файл, чи це коректний JSON?",jsonNotArray:"JSON-файл що імпортується повинен містити масив, операцію скасовано."},pagination:{aria:{pageToFirst:"Перша сторінка",pageBack:"Попередня сторінка",pageSelected:"Обрана сторінка",pageForward:"Наступна сторінка",pageToLast:"Остання сторінка"},sizes:"рядків на сторінку",totalItems:"рядків",through:"по",of:"з"},grouping:{group:"Групувати",ungroup:"Розгрупувати",aggregate_count:"Групувати: Кількість",aggregate_sum:"Для групи: Сума",aggregate_max:"Для групи: Максимум",aggregate_min:"Для групи: Мінімум",aggregate_avg:"Для групи: Серднє",aggregate_remove:"Для групи: Пусто"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("zh-cn",{headerCell:{aria:{defaultFilterLabel:"列过滤器",removeFilter:"移除过滤器",columnMenuButtonLabel:"列菜单"},priority:"优先级:",filterLabel:"列过滤器: "},aggregate:{label:"行"},groupPanel:{description:"拖曳表头到此处进行分组"},search:{placeholder:"查找",showingItems:"已显示行数：",selectedItems:"已选择行数：",totalItems:"总行数：",size:"每页显示行数：",first:"首页",next:"下一页",previous:"上一页",last:"末页"},menu:{text:"选择列："},sort:{ascending:"升序",descending:"降序",none:"无序",remove:"取消排序"},column:{hide:"隐藏列"},aggregation:{count:"计数：",sum:"求和：",avg:"均值：",min:"最小值：",max:"最大值："},pinning:{pinLeft:"左侧固定",pinRight:"右侧固定",unpin:"取消固定"},columnMenu:{close:"关闭"},gridMenu:{aria:{buttonLabel:"表格菜单"},columns:"列：",importerTitle:"导入文件",exporterAllAsCsv:"导出全部数据到CSV",exporterVisibleAsCsv:"导出可见数据到CSV",exporterSelectedAsCsv:"导出已选数据到CSV",exporterAllAsPdf:"导出全部数据到PDF",exporterVisibleAsPdf:"导出可见数据到PDF",exporterSelectedAsPdf:"导出已选数据到PDF",clearAllFilters:"清除所有过滤器"},importer:{noHeaders:"无法获取列名，确定文件包含表头？",noObjects:"无法获取数据，确定文件包含数据？",invalidCsv:"无法处理文件，确定是合法的CSV文件？",invalidJson:"无法处理文件，确定是合法的JSON文件？",jsonNotArray:"导入的文件不是JSON数组！"},pagination:{aria:{pageToFirst:"第一页",pageBack:"上一页",pageSelected:"当前页",pageForward:"下一页",pageToLast:"最后一页"},sizes:"行每页",totalItems:"行",through:"至",of:"共"},grouping:{group:"分组",ungroup:"取消分组",aggregate_count:"合计: 计数",aggregate_sum:"合计: 求和",aggregate_max:"合计: 最大",aggregate_min:"合计: 最小",aggregate_avg:"合计: 平均",aggregate_remove:"合计: 移除"}}),e}])}]),angular.module("ui.grid").config(["$provide",function(e){e.decorator("i18nService",["$delegate",function(e){return e.add("zh-tw",{aggregate:{label:"行"},groupPanel:{description:"拖曳表頭到此處進行分組"},search:{placeholder:"查找",showingItems:"已顯示行數：",selectedItems:"已選擇行數：",totalItems:"總行數：",size:"每頁顯示行數：",first:"首頁",next:"下壹頁",previous:"上壹頁",last:"末頁"},menu:{text:"選擇列："},sort:{ascending:"升序",descending:"降序",remove:"取消排序"},column:{hide:"隱藏列"},aggregation:{count:"計數：",sum:"求和：",avg:"均值：",min:"最小值：",max:"最大值："},pinning:{pinLeft:"左側固定",pinRight:"右側固定",unpin:"取消固定"},gridMenu:{columns:"列：",importerTitle:"導入文件",exporterAllAsCsv:"導出全部數據到CSV",exporterVisibleAsCsv:"導出可見數據到CSV",exporterSelectedAsCsv:"導出已選數據到CSV",exporterAllAsPdf:"導出全部數據到PDF",exporterVisibleAsPdf:"導出可見數據到PDF",exporterSelectedAsPdf:"導出已選數據到PDF",clearAllFilters:"清除所有过滤器"},importer:{noHeaders:"無法獲取列名，確定文件包含表頭？",noObjects:"無法獲取數據，確定文件包含數據？",invalidCsv:"無法處理文件，確定是合法的CSV文件？",invalidJson:"無法處理文件，確定是合法的JSON文件？",jsonNotArray:"導入的文件不是JSON數組！"},pagination:{sizes:"行每頁",totalItems:"行"}}),e}])}]),function(){"use strict";var e=angular.module("ui.grid.importer",["ui.grid"]);e.constant("uiGridImporterConstants",{featureName:"importer"}),e.service("uiGridImporterService",["$q","uiGridConstants","uiGridImporterConstants","gridUtil","$compile","$interval","i18nService","$window",function(e,r,t,n,i,o,a,l){var s={initializeGrid:function(e,t){t.importer={$scope:e},this.defaultGridOptions(t.options);var e={importer:{}},i={importer:{importFile:function(e){s.importThisFile(t,e)}}};t.api.registerEventsFromObject(e),t.api.registerMethodsFromObject(i),t.options.enableImporter&&t.options.importerShowMenu&&(t.api.core.addToGridMenu?s.addToMenu(t):o(function(){t.api.core.addToGridMenu&&s.addToMenu(t)},100,1))},defaultGridOptions:function(e){e.enableImporter||void 0===e.enableImporter?l.hasOwnProperty("File")&&l.hasOwnProperty("FileReader")&&l.hasOwnProperty("FileList")&&l.hasOwnProperty("Blob")?e.enableImporter=!0:(n.logError("The File APIs are not fully supported in this browser, grid importer cannot be used."),e.enableImporter=!1):e.enableImporter=!1,e.importerProcessHeaders=e.importerProcessHeaders||s.processHeaders,e.importerHeaderFilter=e.importerHeaderFilter||function(e){return e},e.importerErrorCallback&&"function"==typeof e.importerErrorCallback||delete e.importerErrorCallback,!0!==e.enableImporter||e.importerDataAddCallback||(n.logError("You have not set an importerDataAddCallback, importer is disabled"),e.enableImporter=!1),e.importerShowMenu=!1!==e.importerShowMenu,e.importerObjectCallback=e.importerObjectCallback||function(e,t){return t}},addToMenu:function(e){e.api.core.addToGridMenu(e,[{title:a.getSafeText("gridMenu.importerTitle"),order:150},{templateUrl:"ui-grid/importerMenuItemContainer",action:function(){this.grid.api.importer.importAFile(e)},order:151}])},importThisFile:function(e,t){var i;t?(i=new FileReader,"application/json"===t.type?i.onload=s.importJsonClosure(e):i.onload=s.importCsvClosure(e),i.readAsText(t)):n.logError("No file object provided to importThisFile, should be impossible, aborting")},importJsonClosure:function(r){return function(e){var t,i=[],e=s.parseJson(r,e);null!==e&&(e.forEach(function(e){t=s.newObject(r),angular.extend(t,e),t=r.options.importerObjectCallback(r,t),i.push(t)}),s.addObjects(r,i))}},parseJson:function(t,i){var e;try{e=JSON.parse(i.target.result)}catch(e){return void s.alertError(t,"importer.invalidJson","File could not be processed, is it valid json? Content was: ",i.target.result)}return Array.isArray(e)?e:(s.alertError(t,"importer.jsonNotarray","Import failed, file is not an array, file was: ",i.target.result),[])},importCsvClosure:function(i){return function(e){var t=s.parseCsv(e);!t||t.length<1?s.alertError(i,"importer.invalidCsv","File could not be processed, is it valid csv? Content was: ",e.target.result):(t=s.createCsvObjects(i,t))&&0!==t.length?s.addObjects(i,t):s.alertError(i,"importer.noObjects","Objects were not able to be derived, content was: ",e.target.result)}},parseCsv:function(e){e=e.target.result;return CSV.parse(e)},createCsvObjects:function(t,e){var i,r,n=t.options.importerProcessHeaders(t,e.shift());return n&&0!==n.length?(i=[],e.forEach(function(e){r=s.newObject(t),null!==e&&e.forEach(function(e,t){null!==n[t]&&(r[n[t]]=e)}),r=t.options.importerObjectCallback(t,r),i.push(r)}),i):(s.alertError(t,"importer.noHeaders","Column names could not be derived, content was: ",e),[])},processHeaders:function(e,t){var i,r=[];return e.options.columnDefs&&0!==e.options.columnDefs.length?(i=s.flattenColumnDefs(e,e.options.columnDefs),t.forEach(function(e){i[e]?r.push(i[e]):i[e.toLowerCase()]?r.push(i[e.toLowerCase()]):r.push(null)})):t.forEach(function(e){r.push(e.replace(/[^0-9a-zA-Z\-_]/g,"_"))}),r},flattenColumnDefs:function(t,e){var i={};return e.forEach(function(e){e.name&&(i[e.name]=e.field||e.name,i[e.name.toLowerCase()]=e.field||e.name),e.field&&(i[e.field]=e.field||e.name,i[e.field.toLowerCase()]=e.field||e.name),e.displayName&&(i[e.displayName]=e.field||e.name,i[e.displayName.toLowerCase()]=e.field||e.name),e.displayName&&t.options.importerHeaderFilter&&(i[t.options.importerHeaderFilter(e.displayName)]=e.field||e.name,i[t.options.importerHeaderFilter(e.displayName).toLowerCase()]=e.field||e.name)}),i},addObjects:function(e,t){var i;e.api.rowEdit&&(i=e.registerDataChangeCallback(function(){e.api.rowEdit.setRowsDirty(t),i()},[r.dataChange.ROW]),e.importer.$scope.$on("$destroy",i)),e.importer.$scope.$apply(e.options.importerDataAddCallback(e,t))},newObject:function(e){return void 0!==e.options&&void 0!==e.options.importerNewObject?new e.options.importerNewObject:{}},alertError:function(e,t,i,r){e.options.importerErrorCallback?e.options.importerErrorCallback(e,t,i,r):(l.alert(a.getSafeText(t)),n.logError(i+r))}};return s}]),e.directive("uiGridImporter",["uiGridImporterConstants","uiGridImporterService","gridUtil","$compile",function(e,n,t,i){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(e,t,i,r){n.initializeGrid(e,r.grid)}}}]),e.directive("uiGridImporterMenuItem",["uiGridImporterConstants","uiGridImporterService","gridUtil","$compile",function(e,o,a,t){return{replace:!0,priority:0,require:"?^uiGrid",scope:!1,templateUrl:"ui-grid/importerMenuItem",link:function(e,t,i,r){var n;t=t[0].querySelectorAll(".ui-grid-importer-file-chooser");1!==t.length?a.logError("Found > 1 or < 1 file choosers within the menu item, error, cannot continue"):t[0].addEventListener("change",function(e){var t;(e=e.srcElement||e.target)&&e.files&&1===e.files.length&&(t=e.files[0],void 0!==r&&r?(n=r.grid,o.importThisFile(n,t),e.form.reset()):a.logError("Could not import file because UI Grid was not found."))},!1)}}}])}(),function(){"use strict";var e=angular.module("ui.grid.infiniteScroll",["ui.grid"]);e.service("uiGridInfiniteScrollService",["gridUtil","$compile","$rootScope","uiGridConstants","ScrollEvent","$q",function(e,t,a,l,o,i){var s={initializeGrid:function(i,e){s.defaultGridOptions(i.options),i.options.enableInfiniteScroll&&(i.infiniteScroll={dataLoading:!1},s.setScrollDirections(i,i.options.infiniteScrollUp,i.options.infiniteScrollDown),i.api.core.on.scrollEnd(e,s.handleScroll),e={infiniteScroll:{dataLoaded:function(e,t){return s.setScrollDirections(i,e,t),s.adjustScroll(i).then(function(){i.infiniteScroll.dataLoading=!1})},resetScroll:function(e,t){s.setScrollDirections(i,e,t),s.adjustInfiniteScrollPosition(i,0)},saveScrollPercentage:function(){i.infiniteScroll.prevScrollTop=i.renderContainers.body.prevScrollTop,i.infiniteScroll.previousVisibleRows=i.getVisibleRowCount()},dataRemovedTop:function(e,t){s.dataRemovedTop(i,e,t)},dataRemovedBottom:function(e,t){s.dataRemovedBottom(i,e,t)},setScrollDirections:function(e,t){s.setScrollDirections(i,e,t)}}},i.api.registerEventsFromObject({infiniteScroll:{needLoadMoreData:function(e,t){},needLoadMoreDataTop:function(e,t){}}}),i.api.registerMethodsFromObject(e))},defaultGridOptions:function(e){e.enableInfiniteScroll=!1!==e.enableInfiniteScroll,e.infiniteScrollRowsFromEnd=e.infiniteScrollRowsFromEnd||20,e.infiniteScrollUp=!0===e.infiniteScrollUp,e.infiniteScrollDown=!1!==e.infiniteScrollDown},setScrollDirections:function(e,t,i){e.infiniteScroll.scrollUp=!0===t,e.suppressParentScrollUp=!0===t,e.infiniteScroll.scrollDown=!1!==i,e.suppressParentScrollDown=!1!==i},handleScroll:function(e){var t;e.grid.infiniteScroll&&e.grid.infiniteScroll.dataLoading||"ui.grid.adjustInfiniteScrollPosition"===e.source||e.y&&(0===e.y.percentage?(e.grid.scrollDirection=l.scrollDirection.UP,s.loadData(e.grid)):1===e.y.percentage?(e.grid.scrollDirection=l.scrollDirection.DOWN,s.loadData(e.grid)):(t=e.grid.options.infiniteScrollRowsFromEnd/e.grid.renderContainers.body.visibleRowCache.length,e.grid.scrollDirection===l.scrollDirection.UP?e.y.percentage<=t&&s.loadData(e.grid):e.grid.scrollDirection===l.scrollDirection.DOWN&&1-e.y.percentage<=t&&s.loadData(e.grid)))},loadData:function(e){e.infiniteScroll.previousVisibleRows=e.renderContainers.body.visibleRowCache.length,e.infiniteScroll.direction=e.scrollDirection,delete e.infiniteScroll.prevScrollTop,e.scrollDirection===l.scrollDirection.UP&&e.infiniteScroll.scrollUp?(e.infiniteScroll.dataLoading=!0,e.api.infiniteScroll.raise.needLoadMoreDataTop()):e.scrollDirection!==l.scrollDirection.DOWN||!e.infiniteScroll.scrollDown||e.cellNav&&e.cellNav.lastRowCol&&e.cellNav.lastRowCol.row.index===e.infiniteScroll.previousVisibleRows-1||(e.infiniteScroll.dataLoading=!0,e.api.infiniteScroll.raise.needLoadMoreData())},adjustScroll:function(n){var o=i.defer();return a.$applyAsync(function(){var e,t=n.getViewportHeight()+n.headerHeight-n.renderContainers.body.headerHeight-n.scrollbarHeight,i=n.options.rowHeight,r=(void 0===n.infiniteScroll.direction&&s.adjustInfiniteScrollPosition(n,0),n.getVisibleRowCount());n.infiniteScroll.scrollDown&&i*r<t&&n.api.infiniteScroll.raise.needLoadMoreData(),n.infiniteScroll.direction===l.scrollDirection.UP&&(e=(n.infiniteScroll.prevScrollTop||0)+(r-n.infiniteScroll.previousVisibleRows)*i,s.adjustInfiniteScrollPosition(n,e),a.$applyAsync(function(){o.resolve()})),n.infiniteScroll.direction===l.scrollDirection.DOWN&&(e=n.infiniteScroll.prevScrollTop||n.infiniteScroll.previousVisibleRows*i-t,s.adjustInfiniteScrollPosition(n,e),a.$applyAsync(function(){o.resolve()}))},0),o.promise},adjustInfiniteScrollPosition:function(e,t){var i=new o(e,null,null,"ui.grid.adjustInfiniteScrollPosition"),r=e.getVisibleRowCount(),n=e.getViewportHeight()+e.headerHeight-e.renderContainers.body.headerHeight-e.scrollbarHeight,r=r*e.options.rowHeight-n;0===t&&e.infiniteScroll.scrollUp?i.y={pixels:1}:i.y={percentage:t/r},e.scrollContainers("",i)},dataRemovedTop:function(e,t,i){var r;s.setScrollDirections(e,t,i),t=e.renderContainers.body.visibleRowCache.length,i=e.infiniteScroll.prevScrollTop,r=e.options.rowHeight,i=i-(e.infiniteScroll.previousVisibleRows-t)*r,s.adjustInfiniteScrollPosition(e,i)},dataRemovedBottom:function(e,t,i){s.setScrollDirections(e,t,i),t=e.infiniteScroll.prevScrollTop,s.adjustInfiniteScrollPosition(e,t)}};return s}]),e.directive("uiGridInfiniteScroll",["uiGridInfiniteScrollService",function(n){return{priority:-200,scope:!1,require:"^uiGrid",compile:function(){return{pre:function(e,t,i,r){n.initializeGrid(r.grid,e)},post:function(e,t,i){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.moveColumns",["ui.grid"]);e.service("uiGridMoveColumnService",["$q","$rootScope","$log","ScrollEvent","uiGridConstants","gridUtil",function(r,d,e,t,c,s){var u={initializeGrid:function(e){this.registerPublicApi(e),this.defaultGridOptions(e.options),e.moveColumns={orderCache:[]},e.registerColumnBuilder(this.movableColumnBuilder),e.registerDataChangeCallback(this.verifyColumnOrder,[c.dataChange.COLUMN])},registerPublicApi:function(a){var l=this,e={colMovable:{columnPositionChanged:function(e,t,i){}}},t={colMovable:{moveColumn:function(e,t){var r=a.columns;if(angular.isNumber(e)&&angular.isNumber(t)){for(var i,n=0,o=0;o<r.length;o++)(angular.isDefined(r[o].colDef.visible)&&!1===r[o].colDef.visible||!0===r[o].isRowHeader)&&n++;e>=r.length-n||t>=r.length-n?s.logError("MoveColumn: Invalid values for originalPosition, finalPosition"):l.redrawColumnAtPosition(a,(i=function(e){for(var t=e,i=0;i<=t;i++)angular.isDefined(r[i])&&(angular.isDefined(r[i].colDef.visible)&&!1===r[i].colDef.visible||!0===r[i].isRowHeader)&&t++;return t})(e),i(t))}else s.logError("MoveColumn: Please provide valid values for originalPosition and finalPosition")}}};a.api.registerEventsFromObject(e),a.api.registerMethodsFromObject(t)},defaultGridOptions:function(e){e.enableColumnMoving=!1!==e.enableColumnMoving},movableColumnBuilder:function(e,t,i){return e.enableColumnMoving=(void 0===e.enableColumnMoving?i:e).enableColumnMoving,r.all([])},updateColumnCache:function(e){e.moveColumns.orderCache=e.getOnlyDataColumns()},verifyColumnOrder:function(i){var r,n=i.rowHeaderColumns.length;angular.forEach(i.moveColumns.orderCache,function(e,t){-1!==(r=i.columns.indexOf(e))&&r-n!==t&&(e=i.columns.splice(r,1)[0],i.columns.splice(t+n,0,e))})},redrawColumnAtPosition:function(e,t,i){var r=e.columns;if(t!==i){for(var n=t<i?t+1:t-1,o=Math.min(n,i);o<=Math.max(n,i)&&!r[o].visible;o++);if(!(o>Math.max(n,i))){var a=r[t];if(a.colDef.enableColumnMoving){if(i<t)for(var l=t;i<l;l--)r[l]=r[l-1];else if(t<i)for(var s=t;s<i;s++)r[s]=r[s+1];r[i]=a,u.updateColumnCache(e),e.queueGridRefresh(),d.$applyAsync(function(){e.api.core.notifyDataChange(c.dataChange.COLUMN),e.api.colMovable.raise.columnPositionChanged(a.colDef,t,i)})}}}}};return u}]),e.directive("uiGridMoveColumns",["uiGridMoveColumnService",function(n){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){n.initializeGrid(r.grid)},post:function(e,t,i,r){}}}}}]),e.directive("uiGridHeaderCell",["$q","gridUtil","uiGridMoveColumnService","$document","$log","uiGridConstants","ScrollEvent",function(e,t,b,y,i,r,S){return{priority:-10,require:"^uiGrid",compile:function(){return{post:function(d,r,e,c){var t,u,i,g,p,f,m,h,v,n,o,a,C,w,l,s;d.col.colDef.enableColumnMoving&&(t=angular.element(r[0].querySelectorAll(".ui-grid-cell-contents")),v=f=!1,n=function(e){u=d.grid.element[0].getBoundingClientRect().left,d.grid.hasLeftContainer()&&(u+=d.grid.renderContainers.left.header[0].getBoundingClientRect().width),i=e.pageX||(e.originalEvent?e.originalEvent.pageX:0),g=0,p=u+d.grid.getViewportWidth(),"mousedown"===e.type?(y.on("mousemove",o),y.on("mouseup",a)):"touchstart"===e.type&&(y.on("touchmove",o),y.on("touchend",a))},o=function(e){var e=e.pageX||(e.originalEvent?e.originalEvent.pageX:0),t=e-i;0!=t&&(document.onselectstart=function(){return!1},v=!0,f?(s(t),i=e):l())},a=function(e){if(document.onselectstart=null,m&&(m.remove(),f=!1),w(),C(),v){for(var t,i=d.grid.columns,r=0,n=0;n<i.length&&i[n].colDef.name!==d.col.colDef.name;n++)r++;if(g<0){var o,a=0;if(d.grid.isRTL()){for(o=r+1;o<i.length;o++)if((angular.isUndefined(i[o].colDef.visible)||!0===i[o].colDef.visible)&&(a+=i[o].drawnWidth||i[o].width||i[o].colDef.width)>Math.abs(g)){b.redrawColumnAtPosition(d.grid,r,o-1);break}}else for(o=r-1;0<=o;o--)if((angular.isUndefined(i[o].colDef.visible)||!0===i[o].colDef.visible)&&(a+=i[o].drawnWidth||i[o].width||i[o].colDef.width)>Math.abs(g)){b.redrawColumnAtPosition(d.grid,r,o+1);break}a<Math.abs(g)&&(t=0,d.grid.isRTL()&&(t=i.length-1),b.redrawColumnAtPosition(d.grid,r,t))}else if(0<g){var l,s=0;if(d.grid.isRTL()){for(l=r-1;0<l;l--)if((angular.isUndefined(i[l].colDef.visible)||!0===i[l].colDef.visible)&&(s+=i[l].drawnWidth||i[l].width||i[l].colDef.width,g<s)){b.redrawColumnAtPosition(d.grid,r,l);break}}else for(l=r+1;l<i.length;l++)if((angular.isUndefined(i[l].colDef.visible)||!0===i[l].colDef.visible)&&(s+=i[l].drawnWidth||i[l].width||i[l].colDef.width,g<s)){b.redrawColumnAtPosition(d.grid,r,l-1);break}s<g&&(t=i.length-1,d.grid.isRTL()&&(t=0),b.redrawColumnAtPosition(d.grid,r,t))}}},w=function(){t.off("touchstart",n),t.off("mousedown",n),y.off("mousemove",o),y.off("touchmove",o),y.off("mouseup",a),y.off("touchend",a)},(C=function(){t.on("touchstart",n),t.on("mousedown",n)})(),l=function(){f=!0,m=r.clone(),r.parent().append(m),m.addClass("movingColumn");var e={},t=(e.left=r[0].offsetLeft+"px",d.grid.element[0].getBoundingClientRect().right),i=r[0].getBoundingClientRect().right;t<i&&(h=d.col.drawnWidth+(t-i),e.width=h+"px"),m.css(e)},s=function(e){for(var t=d.grid.columns,i=0,r=0;r<t.length;r++)!angular.isUndefined(t[r].colDef.visible)&&!0!==t[r].colDef.visible||(i+=t[r].drawnWidth||t[r].width||t[r].colDef.width);var n=m[0].getBoundingClientRect().left-1,o=m[0].getBoundingClientRect().right,a=n-u+e;a=a<p?a:p,(u<=n||0<e)&&(o<=p||e<0)?m.css({visibility:"visible",left:m[0].offsetLeft+(a<p?e:p-n)+"px"}):i>Math.ceil(c.grid.gridWidth)&&(e*=8,(o=new S(d.col.grid,null,null,"uiGridHeaderCell.moveElement")).x={pixels:e},o.grid.scrollContainers("",o));for(var l=0,s=0;s<t.length;s++)if(angular.isUndefined(t[s].colDef.visible)||!0===t[s].colDef.visible){if(t[s].colDef.name===d.col.colDef.name)break;l+=t[s].drawnWidth||t[s].width||t[s].colDef.width}void 0===d.newScrollLeft?g+=e:g=d.newScrollLeft+a-l,h<d.col.drawnWidth&&(h+=Math.abs(e),m.css({width:h+"px"}))},d.$on("$destroy",w))}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.pagination",["ng","ui.grid"]);e.service("uiGridPaginationService",["gridUtil",function(t){var e={initializeGrid:function(n){e.defaultGridOptions(n.options);var o={events:{pagination:{paginationChanged:function(e,t){}}},methods:{pagination:{getPage:function(){return n.options.enablePagination?n.options.paginationCurrentPage:null},getFirstRowIndex:function(){return n.options.useCustomPagination?n.options.paginationPageSizes.reduce(function(e,t,i){return i<n.options.paginationCurrentPage-1?e+t:e},0):(n.options.paginationCurrentPage-1)*n.options.paginationPageSize},getLastRowIndex:function(){return n.options.useCustomPagination?o.methods.pagination.getFirstRowIndex()+n.options.paginationPageSizes[n.options.paginationCurrentPage-1]-1:Math.min(n.options.paginationCurrentPage*n.options.paginationPageSize,n.options.totalItems)-1},getTotalPages:function(){return n.options.enablePagination?n.options.useCustomPagination?n.options.paginationPageSizes.length:0===n.options.totalItems?1:Math.ceil(n.options.totalItems/n.options.paginationPageSize):null},nextPage:function(){n.options.enablePagination&&(0<n.options.totalItems?n.options.paginationCurrentPage=Math.min(n.options.paginationCurrentPage+1,o.methods.pagination.getTotalPages()):n.options.paginationCurrentPage++)},previousPage:function(){n.options.enablePagination&&(n.options.paginationCurrentPage=Math.max(n.options.paginationCurrentPage-1,1))},seek:function(e){if(n.options.enablePagination){if(!angular.isNumber(e)||e<1)throw"Invalid page number: "+e;n.options.paginationCurrentPage=Math.min(e,o.methods.pagination.getTotalPages())}}}}};n.api.registerEventsFromObject(o.events),n.api.registerMethodsFromObject(o.methods);n.registerRowsProcessor(function(e){var t,i,r;return n.options.useExternalPagination||!n.options.enablePagination?e:(t=parseInt(n.options.paginationPageSize,10),parseInt(n.options.paginationCurrentPage,10),e=e.filter(function(e){return e.visible}),n.options.totalItems=e.length,i=o.methods.pagination.getFirstRowIndex(),r=o.methods.pagination.getLastRowIndex(),i>e.length&&(n.options.paginationCurrentPage=1,i=0*t),e.slice(i,r+1))},900)},defaultGridOptions:function(e){e.enablePagination=!1!==e.enablePagination,e.enablePaginationControls=!1!==e.enablePaginationControls,e.useExternalPagination=!0===e.useExternalPagination,e.useCustomPagination=!0===e.useCustomPagination,t.isNullOrUndefined(e.totalItems)&&(e.totalItems=0),t.isNullOrUndefined(e.paginationPageSizes)&&(e.paginationPageSizes=[250,500,1e3]),t.isNullOrUndefined(e.paginationPageSize)&&(0<e.paginationPageSizes.length?e.paginationPageSize=e.paginationPageSizes[0]:e.paginationPageSize=0),t.isNullOrUndefined(e.paginationCurrentPage)&&(e.paginationCurrentPage=1),t.isNullOrUndefined(e.paginationTemplate)&&(e.paginationTemplate="ui-grid/pagination")},onPaginationChanged:function(e,t,i){e.api.pagination.raise.paginationChanged(t,i),e.options.useExternalPagination||e.queueGridRefresh()}};return e}]),e.directive("uiGridPagination",["gridUtil","uiGridPaginationService",function(n,o){return{priority:-200,scope:!1,require:"uiGrid",link:{pre:function(e,t,i,r){o.initializeGrid(r.grid),n.getTemplate(r.grid.options.paginationTemplate).then(function(e){e=angular.element(e);t.append(e),r.innerCompile(e)})}}}}]),e.directive("uiGridPager",["uiGridPaginationService","uiGridConstants","gridUtil","i18nService","i18nConstants",function(d,c,u,g,p){return{priority:-200,scope:!0,require:"^uiGrid",link:function(i,t,e,r){function n(){i.paginationApi=r.grid.api.pagination,i.sizesLabel=g.getSafeText("pagination.sizes"),i.totalItemsLabel=g.getSafeText("pagination.totalItems"),i.paginationOf=g.getSafeText("pagination.of"),i.paginationThrough=g.getSafeText("pagination.through")}i.aria=g.getSafeText("pagination.aria");function o(e){e&&u.focus.bySelector(t,".ui-grid-pager-control-input")}n(),i.$on(p.UPDATE_EVENT,n);var a=r.grid.options,l=(r.grid.renderContainers.body.registerViewportAdjuster(function(e){return a.enablePaginationControls&&(e.height=e.height-u.elementHeight(t,"padding")),e}),r.grid.registerDataChangeCallback(function(e){e.options.useExternalPagination||(e.options.totalItems=e.rows.length)},[c.dataChange.ROW])),s=(i.$on("$destroy",l),i.$watch("grid.options.paginationCurrentPage + grid.options.paginationPageSize",function(e,t){e!==t&&void 0!==t&&(!angular.isNumber(a.paginationCurrentPage)||a.paginationCurrentPage<1?a.paginationCurrentPage=1:0<a.totalItems&&a.paginationCurrentPage>i.paginationApi.getTotalPages()?a.paginationCurrentPage=i.paginationApi.getTotalPages():d.onPaginationChanged(i.grid,a.paginationCurrentPage,a.paginationPageSize))}));i.$on("$destroy",function(){s()}),i.cantPageForward=function(){return i.paginationApi.getTotalPages()?i.cantPageToLast():a.data.length<1},i.cantPageToLast=function(){var e=i.paginationApi.getTotalPages();return!e||a.paginationCurrentPage>=e},i.cantPageBackward=function(){return a.paginationCurrentPage<=1};i.pageFirstPageClick=function(){i.paginationApi.seek(1),o(i.cantPageBackward())},i.pagePreviousPageClick=function(){i.paginationApi.previousPage(),o(i.cantPageBackward())},i.pageNextPageClick=function(){i.paginationApi.nextPage(),o(i.cantPageForward())},i.pageLastPageClick=function(){i.paginationApi.seek(i.paginationApi.getTotalPages()),o(i.cantPageToLast())}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.pinning",["ui.grid"]);e.constant("uiGridPinningConstants",{container:{LEFT:"left",RIGHT:"right",NONE:""}}),e.service("uiGridPinningService",["gridUtil","GridRenderContainer","i18nService","uiGridPinningConstants",function(o,e,a,l){var s={initializeGrid:function(i){s.defaultGridOptions(i.options),i.registerColumnBuilder(s.pinningColumnBuilder);var e={pinning:{columnPinned:function(e,t){}}},t={pinning:{pinColumn:function(e,t){s.pinColumn(i,e,t)}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(t)},defaultGridOptions:function(e){e.enablePinning=!1!==e.enablePinning,e.hidePinLeft=e.enablePinning&&e.hidePinLeft,e.hidePinRight=e.enablePinning&&e.hidePinRight},pinningColumnBuilder:function(e,t,i){var r,n;e.enablePinning=(void 0===e.enablePinning?i:e).enablePinning,e.hidePinLeft=(void 0===e.hidePinLeft?i:e).hidePinLeft,e.hidePinRight=(void 0===e.hidePinRight?i:e).hidePinRight,e.pinnedLeft?(t.renderContainer="left",t.grid.createLeftContainer()):e.pinnedRight&&(t.renderContainer="right",t.grid.createRightContainer()),e.enablePinning&&(i={name:"ui.grid.pinning.pinLeft",title:a.get().pinning.pinLeft,icon:"ui-grid-icon-left-open",shown:function(){return void 0===this.context.col.renderContainer||!this.context.col.renderContainer||"left"!==this.context.col.renderContainer},action:function(){s.pinColumn(this.context.col.grid,this.context.col,l.container.LEFT)}},r={name:"ui.grid.pinning.pinRight",title:a.get().pinning.pinRight,icon:"ui-grid-icon-right-open",shown:function(){return void 0===this.context.col.renderContainer||!this.context.col.renderContainer||"right"!==this.context.col.renderContainer},action:function(){s.pinColumn(this.context.col.grid,this.context.col,l.container.RIGHT)}},n={name:"ui.grid.pinning.unpin",title:a.get().pinning.unpin,icon:"ui-grid-icon-cancel",shown:function(){return void 0!==this.context.col.renderContainer&&null!==this.context.col.renderContainer&&"body"!==this.context.col.renderContainer},action:function(){s.pinColumn(this.context.col.grid,this.context.col,l.container.NONE)}},e.hidePinLeft||o.arrayContainsObjectWithProperty(t.menuItems,"name","ui.grid.pinning.pinLeft")||t.menuItems.push(i),e.hidePinRight||o.arrayContainsObjectWithProperty(t.menuItems,"name","ui.grid.pinning.pinRight")||t.menuItems.push(r),o.arrayContainsObjectWithProperty(t.menuItems,"name","ui.grid.pinning.unpin")||t.menuItems.push(n))},pinColumn:function(e,t,i){i===l.container.NONE?(t.renderContainer=null,t.colDef.pinnedLeft=t.colDef.pinnedRight=!1):(t.renderContainer=i)===l.container.LEFT?e.createLeftContainer():i===l.container.RIGHT&&e.createRightContainer(),e.refresh().then(function(){e.api.pinning.raise.columnPinned(t.colDef,i)})}};return s}]),e.directive("uiGridPinning",["gridUtil","uiGridPinningService",function(e,n){return{require:"uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){n.initializeGrid(r.grid)},post:function(e,t,i,r){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.resizeColumns",["ui.grid"]);e.service("uiGridResizeColumnsService",["gridUtil","$q","$rootScope",function(r,n,o){return{defaultGridOptions:function(e){e.enableColumnResizing=!1!==e.enableColumnResizing,!1===e.enableColumnResize&&(e.enableColumnResizing=!1)},colResizerColumnBuilder:function(e,t,i){return e.enableColumnResizing=(void 0===e.enableColumnResizing?i:e).enableColumnResizing,!1===e.enableColumnResize&&(e.enableColumnResizing=!1),n.all([])},registerPublicApi:function(e){e.api.registerEventsFromObject({colResizable:{columnSizeChanged:function(e,t){}}})},fireColumnSizeChanged:function(e,t,i){o.$applyAsync(function(){e.api.colResizable?e.api.colResizable.raise.columnSizeChanged(t,i):r.logError("The resizeable api is not registered, this may indicate that you've included the module but not added the 'ui-grid-resize-columns' directive to your grid definition.  Cannot raise any events.")})},findTargetCol:function(e,t,i){var r=e.getRenderContainer();return"left"===t?0===(t=r.visibleColumnCache.indexOf(e))?r.visibleColumnCache[0]:r.visibleColumnCache[t-+i]:e}}}]),e.directive("uiGridResizeColumns",["gridUtil","uiGridResizeColumnsService",function(e,n){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){n.defaultGridOptions(r.grid.options),r.grid.registerColumnBuilder(n.colResizerColumnBuilder),n.registerPublicApi(r.grid)},post:function(e,t,i,r){}}}}}]),e.directive("uiGridHeaderCell",["gridUtil","$templateCache","$compile","$q","uiGridResizeColumnsService","uiGridConstants",function(e,r,s,t,d,c){return{priority:-10,require:"^uiGrid",compile:function(){return{post:function(n,o,e,t){var a,l,i,t=t.grid;t.options.enableColumnResizing&&(a=r.get("ui-grid/columnResizer"),l=1,t.isRTL()&&(n.position="left",l=-1),(i=function(){for(var e=o[0].getElementsByClassName("ui-grid-column-resizer"),t=0;t<e.length;t++)angular.element(e[t]).remove();var i=d.findTargetCol(n.col,"left",l),r=n.col.getRenderContainer();i&&0!==r.visibleColumnCache.indexOf(n.col)&&!1!==i.colDef.enableColumnResizing&&((r=angular.element(a).clone()).attr("position","left"),o.prepend(r),s(r)(n)),!1!==n.col.colDef.enableColumnResizing&&((i=angular.element(a).clone()).attr("position","right"),o.append(i),s(i)(n))})(),t=t.registerDataChangeCallback(function(){n.$applyAsync(i)},[c.dataChange.COLUMN]),n.$on("$destroy",t))}}}}}]),e.directive("uiGridColumnResizer",["$document","gridUtil","uiGridConstants","uiGridResizeColumnsService",function(h,v,C,w){var b=angular.element('<div class="ui-grid-resize-overlay"></div>');return{priority:0,scope:{col:"=",position:"@",renderIndex:"="},require:"?^uiGrid",link:function(o,a,e,l){var r=0,n=0,s=0,d=1;function c(){l.grid.refreshCanvas(!0).then(function(){l.grid.queueGridRefresh()})}function u(e,t){return e.minWidth&&t<e.minWidth?t=e.minWidth:e.maxWidth&&t>e.maxWidth&&(t=e.maxWidth),t}function i(e,t){(e=e.originalEvent?e.originalEvent:e).preventDefault(),(n=(e.targetTouches?e.targetTouches[0]:e).clientX-s)<0?n=0:n>l.grid.gridWidth&&(n=l.grid.gridWidth);var i,e=w.findTargetCol(o.col,o.position,d);!1!==e.colDef.enableColumnResizing&&(l.grid.element.hasClass("column-resizing")||l.grid.element.addClass("column-resizing"),i=n-r,i=parseInt(e.drawnWidth+i*d,10),n+=(u(e,i)-i)*d,b.css({left:n+"px"}),l.fireEvent(C.events.ITEM_DRAGGING))}function g(e){(e=e.originalEvent?e.originalEvent:e).preventDefault(),l.grid.element.removeClass("column-resizing"),b.remove();var t,i,e=(n=(e.changedTouches?e.changedTouches[0]:e).clientX-s)-r;0==e?(m(),f()):!1!==(t=w.findTargetCol(o.col,o.position,d)).colDef.enableColumnResizing&&(i=parseInt(t.drawnWidth+e*d,10),t.width=u(t,i),t.hasCustomWidth=!0,c(),w.fireColumnSizeChanged(l.grid,t.colDef,e),m(),f())}l.grid.isRTL()&&(o.position="left",d=-1),"left"===o.position?a.addClass("left"):"right"===o.position&&a.addClass("right");function t(e,t){var i,r,n;e.stopPropagation(),!1!==(e=w.findTargetCol(o.col,o.position,d)).colDef.enableColumnResizing&&(i=0,r=v.closestElm(a,".ui-grid-render-container").querySelectorAll("."+C.COL_CLASS_PREFIX+e.uid+" .ui-grid-cell-contents"),Array.prototype.forEach.call(r,function(e){var t;angular.element(e).parent().hasClass("ui-grid-header-cell")&&(t=angular.element(e).parent()[0].querySelectorAll(".ui-grid-column-menu-button")),v.fakeElement(e,{},function(e){e=angular.element(e),e.attr("style","float: left"),e=v.elementWidth(e)+2;t&&(e+=v.elementWidth(t)),i<e&&(i=e)})}),n=(r=u(e,i))-e.drawnWidth,e.width=r,e.hasCustomWidth=!0,c(),w.fireColumnSizeChanged(l.grid,e.colDef,n))}var p=function(e,t){(e=e.originalEvent?e.originalEvent:e).stopPropagation(),s=l.grid.element[0].getBoundingClientRect().left,r=(e.targetTouches?e.targetTouches[0]:e).clientX-s,l.grid.element.append(b),b.css({left:r}),"touchstart"===e.type?(h.on("touchend",g),h.on("touchmove",i),a.off("mousedown",p)):(h.on("mouseup",g),h.on("mousemove",i),a.off("touchstart",p))},f=function(){a.on("mousedown",p),a.on("touchstart",p)},m=function(){h.off("mouseup",g),h.off("touchend",g),h.off("mousemove",i),h.off("touchmove",i),a.off("mousedown",p),a.off("touchstart",p)};f();a.on("dblclick",t),a.on("$destroy",function(){a.off("dblclick",t),m()})}}}])}(),function(){"use strict";var e=angular.module("ui.grid.rowEdit",["ui.grid","ui.grid.edit","ui.grid.cellNav"]);e.constant("uiGridRowEditConstants",{}),e.service("uiGridRowEditService",["$interval","$q","uiGridConstants","uiGridRowEditConstants","gridUtil",function(r,e,t,i,o){var a={initializeGrid:function(t,i){i.rowEdit={};var e={rowEdit:{saveRow:function(e){}}},r={rowEdit:{setSavePromise:function(e,t){a.setSavePromise(i,e,t)},getDirtyRows:function(){return i.rowEdit.dirtyRows||[]},getErrorRows:function(){return i.rowEdit.errorRows||[]},flushDirtyRows:function(){return a.flushDirtyRows(i)},setRowsDirty:function(e){a.setRowsDirty(i,e)},setRowsClean:function(e){a.setRowsClean(i,e)}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(r),i.api.core.on.renderingComplete(t,function(e){i.api.edit.on.afterCellEdit(t,a.endEditCell),i.api.edit.on.beginCellEdit(t,a.beginEditCell),i.api.edit.on.cancelCellEdit(t,a.cancelEditCell),i.api.cellNav&&i.api.cellNav.on.navigate(t,a.navigate)})},defaultGridOptions:function(e){},saveRow:function(t,i){var r=this;return function(){var e;return i.isSaving=!0,i.rowEditSavePromise||(e=t.api.rowEdit.raise.saveRow(i.entity),i.rowEditSavePromise?i.rowEditSavePromise.then(r.processSuccessPromise(t,i),r.processErrorPromise(t,i)):o.logError("A promise was not returned when saveRow event was raised, either nobody is listening to event, or event handler did not return a promise"),e)}},setSavePromise:function(e,t,i){e.getRow(t).rowEditSavePromise=i},processSuccessPromise:function(e,t){var i=this;return function(){delete t.isSaving,delete t.isDirty,delete t.isError,delete t.rowEditSaveTimer,delete t.rowEditSavePromise,i.removeRow(e.rowEdit.errorRows,t),i.removeRow(e.rowEdit.dirtyRows,t)}},processErrorPromise:function(e,t){return function(){delete t.isSaving,delete t.rowEditSaveTimer,delete t.rowEditSavePromise,t.isError=!0,e.rowEdit.errorRows||(e.rowEdit.errorRows=[]),a.isRowPresent(e.rowEdit.errorRows,t)||e.rowEdit.errorRows.push(t)}},removeRow:function(i,r){null!=i&&i.forEach(function(e,t){e.uid===r.uid&&i.splice(t,1)})},isRowPresent:function(e,i){var r=!1;return e.forEach(function(e,t){e.uid===i.uid&&(r=!0)}),r},flushDirtyRows:function(t){var i=[];return t.api.rowEdit.getDirtyRows().forEach(function(e){a.cancelTimer(t,e),a.saveRow(t,e)(),i.push(e.rowEditSavePromise)}),e.all(i)},endEditCell:function(e,t,i,r){var n=this.grid,e=n.getRow(e);e?i===r&&!e.isDirty||(n.rowEdit.dirtyRows||(n.rowEdit.dirtyRows=[]),e.isDirty||(e.isDirty=!0,n.rowEdit.dirtyRows.push(e)),delete e.isError,a.considerSetTimer(n,e)):o.logError("Unable to find rowEntity in grid data, dirty flag cannot be set")},beginEditCell:function(e,t){var i=this.grid,e=i.getRow(e);e?a.cancelTimer(i,e):o.logError("Unable to find rowEntity in grid data, timer cannot be cancelled")},cancelEditCell:function(e,t){var i=this.grid,e=i.getRow(e);e?a.considerSetTimer(i,e):o.logError("Unable to find rowEntity in grid data, timer cannot be set")},navigate:function(e,t){var i=this.grid;e.row.rowEditSaveTimer&&a.cancelTimer(i,e.row),t&&t.row&&t.row!==e.row&&a.considerSetTimer(i,t.row)},considerSetTimer:function(e,t){var i;a.cancelTimer(e,t),t.isDirty&&!t.isSaving&&-1!==e.options.rowEditWaitInterval&&(i=e.options.rowEditWaitInterval||2e3,t.rowEditSaveTimer=r(a.saveRow(e,t),i,1))},cancelTimer:function(e,t){t.rowEditSaveTimer&&!t.isSaving&&(r.cancel(t.rowEditSaveTimer),delete t.rowEditSaveTimer)},setRowsDirty:function(i,e){var r;e.forEach(function(e,t){(r=i.getRow(e))?(i.rowEdit.dirtyRows||(i.rowEdit.dirtyRows=[]),r.isDirty||(r.isDirty=!0,i.rowEdit.dirtyRows.push(r)),delete r.isError,a.considerSetTimer(i,r)):o.logError("requested row not found in rowEdit.setRowsDirty, row was: "+e)})},setRowsClean:function(i,e){var r;e.forEach(function(e,t){(r=i.getRow(e))?(delete r.isDirty,a.removeRow(i.rowEdit.dirtyRows,r),a.cancelTimer(i,r),delete r.isError,a.removeRow(i.rowEdit.errorRows,r)):o.logError("requested row not found in rowEdit.setRowsClean, row was: "+e)})}};return a}]),e.directive("uiGridRowEdit",["gridUtil","uiGridRowEditService","uiGridEditConstants",function(e,n,t){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){n.initializeGrid(e,r.grid)},post:function(e,t,i,r){}}}}}]),e.directive("uiGridViewport",["$compile","uiGridConstants","gridUtil","$parse",function(e,t,i,r){return{priority:-200,scope:!1,compile:function(e,t){var e=angular.element(e.children().children()[0]),i=e.attr("ng-class"),r="",r=i?i.slice(0,-1)+", 'ui-grid-row-dirty': row.isDirty, 'ui-grid-row-saving': row.isSaving, 'ui-grid-row-error': row.isError}":"{'ui-grid-row-dirty': row.isDirty, 'ui-grid-row-saving': row.isSaving, 'ui-grid-row-error': row.isError}";return e.attr("ng-class",r),{pre:function(e,t,i,r){},post:function(e,t,i,r){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.saveState",["ui.grid","ui.grid.selection","ui.grid.cellNav","ui.grid.grouping","ui.grid.pinning","ui.grid.treeView"]);e.constant("uiGridSaveStateConstants",{featureName:"saveState"}),e.service("uiGridSaveStateService",function(){var a={initializeGrid:function(i){i.saveState={},this.defaultGridOptions(i.options);var e={saveState:{}},t={saveState:{save:function(){return a.save(i)},restore:function(e,t){return a.restore(i,e,t)}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(t)},defaultGridOptions:function(e){e.saveWidths=!1!==e.saveWidths,e.saveOrder=!1!==e.saveOrder,e.saveScroll=!0===e.saveScroll,e.saveFocus=!0!==e.saveScroll&&!1!==e.saveFocus,e.saveVisible=!1!==e.saveVisible,e.saveSort=!1!==e.saveSort,e.saveFilter=!1!==e.saveFilter,e.saveSelection=!1!==e.saveSelection,e.saveGrouping=!1!==e.saveGrouping,e.saveGroupingExpandedStates=!0===e.saveGroupingExpandedStates,e.savePinning=!1!==e.savePinning,e.saveTreeView=!1!==e.saveTreeView},save:function(e){var t={};return t.columns=a.saveColumns(e),t.scrollFocus=a.saveScrollFocus(e),t.selection=a.saveSelection(e),t.grouping=a.saveGrouping(e),t.treeView=a.saveTreeView(e),t.pagination=a.savePagination(e),t},restore:function(e,t,i){return i.columns&&a.restoreColumns(e,i.columns),i.scrollFocus&&a.restoreScrollFocus(e,t,i.scrollFocus),i.selection&&a.restoreSelection(e,i.selection),i.grouping&&a.restoreGrouping(e,i.grouping),i.treeView&&a.restoreTreeView(e,i.treeView),i.pagination&&a.restorePagination(e,i.pagination),e.refresh()},saveColumns:function(i){var r=[];return i.getOnlyDataColumns().forEach(function(e){var t={};t.name=e.name,i.options.saveVisible&&(t.visible=e.visible),i.options.saveWidths&&(t.width=e.width),i.options.saveSort&&(t.sort=angular.copy(e.sort)),i.options.saveFilter&&(t.filters=[],e.filters.forEach(function(e){var i={};angular.forEach(e,function(e,t){"condition"!==t&&"$$hashKey"!==t&&"placeholder"!==t&&(i[t]=e)}),t.filters.push(i)})),i.api.pinning&&i.options.savePinning&&(t.pinned=e.renderContainer||""),r.push(t)}),r},saveScrollFocus:function(e){var t,i;return e.api.cellNav?(t={},e.options.saveFocus&&(t.focus=!0,null!==(i=e.api.cellNav.getFocusedCell()))&&(null!==i.col&&(t.colName=i.col.colDef.name),null!==i.row)&&(t.rowVal=a.getRowVal(e,i.row)),(e.options.saveScroll||e.options.saveFocus&&!t.colName&&!t.rowVal)&&(t.focus=!1,e.renderContainers.body.prevRowScrollIndex&&(t.rowVal=a.getRowVal(e,e.renderContainers.body.visibleRowCache[e.renderContainers.body.prevRowScrollIndex])),e.renderContainers.body.prevColScrollIndex)&&(t.colName=e.renderContainers.body.visibleColumnCache[e.renderContainers.body.prevColScrollIndex].name),t):{}},saveSelection:function(t){return t.api.selection&&t.options.saveSelection?t.api.selection.getSelectedGridRows().map(function(e){return a.getRowVal(t,e)}):[]},saveGrouping:function(e){return e.api.grouping&&e.options.saveGrouping?e.api.grouping.getGrouping(e.options.saveGroupingExpandedStates):{}},savePagination:function(e){return e.api.pagination&&e.options.paginationPageSize?{paginationCurrentPage:e.options.paginationCurrentPage,paginationPageSize:e.options.paginationPageSize}:{}},saveTreeView:function(e){return e.api.treeView&&e.options.saveTreeView?e.api.treeView.getTreeView():{}},getRowVal:function(e,t){var i;return t?(i={},e.options.saveRowIdentity?(i.identity=!0,i.row=e.options.saveRowIdentity(t.entity)):(i.identity=!1,i.row=e.renderContainers.body.visibleRowCache.indexOf(t)),i):null},restoreColumns:function(r,e){var n=!1;e.forEach(function(e,t){var i=r.getColumn(e.name);i&&!r.isRowHeaderColumn(i)&&(!r.options.saveVisible||i.visible===e.visible&&i.colDef.visible===e.visible||(i.visible=e.visible,i.colDef.visible=e.visible,r.api.core.raise.columnVisibilityChanged(i)),r.options.saveWidths&&i.width!==e.width&&(i.width=e.width,i.hasCustomWidth=!0),!r.options.saveSort||angular.equals(i.sort,e.sort)||void 0===i.sort&&angular.isEmpty(e.sort)||(i.sort=angular.copy(e.sort),n=!0),r.options.saveFilter&&!angular.equals(i.filters,e.filters)&&(e.filters.forEach(function(e,t){angular.extend(i.filters[t],e),void 0!==e.term&&null!==e.term||delete i.filters[t].term}),r.api.core.raise.filterChanged(i)),r.api.pinning&&r.options.savePinning&&i.renderContainer!==e.pinned&&r.api.pinning.pinColumn(i,e.pinned),-1!==(e=r.getOnlyDataColumns().indexOf(i)))&&r.options.saveOrder&&e!==t&&(e=r.columns.splice(e+r.rowHeaderColumns.length,1)[0],r.columns.splice(t+r.rowHeaderColumns.length,0,e))}),n&&r.api.core.raise.sortChanged(r,r.getColumnSorting())},restoreScrollFocus:function(e,t,i){var r,n,o;e.api.cellNav&&(i.colName&&0<(o=e.options.columnDefs.filter(function(e){return e.name===i.colName})).length&&(r=o[0]),o=(n=i.rowVal&&i.rowVal.row?i.rowVal.identity?a.findRowByIdentity(e,i.rowVal):e.renderContainers.body.visibleRowCache[i.rowVal.row]:n)&&n.entity?n.entity:null,r||o)&&(i.focus?e.api.cellNav.scrollToFocus(o,r):e.scrollTo(o,r))},restoreSelection:function(i,e){i.api.selection&&(i.api.selection.clearSelectedRows(),e.forEach(function(e){var t;e.identity?(t=a.findRowByIdentity(i,e))&&i.api.selection.selectRow(t.entity):i.api.selection.selectRowByVisibleIndex(e.row)}))},restoreGrouping:function(e,t){e.api.grouping&&null!=t&&!angular.equals(t,{})&&e.api.grouping.setGrouping(t)},restoreTreeView:function(e,t){e.api.treeView&&null!=t&&!angular.equals(t,{})&&e.api.treeView.setTreeView(t)},restorePagination:function(e,t){e.api.pagination&&e.options.paginationPageSize&&(e.options.paginationCurrentPage=t.paginationCurrentPage,e.options.paginationPageSize=t.paginationPageSize)},findRowByIdentity:function(t,i){var e;return t.options.saveRowIdentity&&0<(e=t.rows.filter(function(e){return t.options.saveRowIdentity(e.entity)===i.row})).length?e[0]:null}};return a}),e.directive("uiGridSaveState",["uiGridSaveStateConstants","uiGridSaveStateService","gridUtil","$compile",function(e,n,t,i){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,link:function(e,t,i,r){n.initializeGrid(r.grid)}}}])}(),function(){"use strict";var e=angular.module("ui.grid.selection",["ui.grid"]);e.constant("uiGridSelectionConstants",{featureName:"selection",selectionRowHeaderColName:"selectionRowHeaderCol"}),angular.module("ui.grid").config(["$provide",function(e){e.decorator("GridRow",["$delegate",function(e){return e.prototype.setSelected=function(e){e!==this.isSelected&&(this.isSelected=e,this.grid.selection.selectedCount+=e?1:-1)},e.prototype.setFocused=function(e){e!==this.isFocused&&(this.grid.selection.focusedRow&&(this.grid.selection.focusedRow.isFocused=!1),this.grid.selection.focusedRow=e?this:null,this.isFocused=e)},e}])}]),e.service("uiGridSelectionService",function(){var s={initializeGrid:function(o){o.selection={lastSelectedRow:null,focusedRow:null,selectAll:!1},o.selection.selectedCount=0,s.defaultGridOptions(o.options);var e={selection:{rowFocusChanged:function(e,t,i){},rowSelectionChanged:function(e,t,i){},rowSelectionChangedBatch:function(e,t,i){}}},t={selection:{toggleRowSelection:function(e,t){e=o.getRow(e);null!=e&&null!==e&&s.toggleRowSelection(o,e,t,o.options.multiSelect,o.options.noUnselect,!0)},selectRow:function(e,t){e=o.getRow(e);null==e||null===e||e.isSelected||s.toggleRowSelection(o,e,t,o.options.multiSelect,o.options.noUnselect,!0)},selectRowByVisibleIndex:function(e,t){e=o.renderContainers.body.visibleRowCache[e];null==e||e.isSelected||s.toggleRowSelection(o,e,t,o.options.multiSelect,o.options.noUnselect,!1)},selectRowByKey:function(e,t,i,r,n){e=o.findRowByKey(e,t,i,n);null==e||e.isSelected||s.toggleRowSelection(o,e,r,o.options.multiSelect,o.options.noUnselect,!1)},unSelectRow:function(e,t){e=o.getRow(e);null!=e&&null!==e&&e.isSelected&&s.toggleRowSelection(o,e,t,o.options.multiSelect,o.options.noUnselect,!0)},unSelectRowByVisibleIndex:function(e,t){e=o.renderContainers.body.visibleRowCache[e];null!=e&&null!=e&&e.isSelected&&s.toggleRowSelection(o,e,t,o.options.multiSelect,o.options.noUnselect,!1)},unSelectRowByKey:function(e,t,i,r,n){e=o.findRowByKey(e,t,i,n);null!=e&&null!=e&&e.isSelected&&s.toggleRowSelection(o,e,r,o.options.multiSelect,o.options.noUnselect,!1)},selectAllRows:function(t){var i;!1!==o.options.multiSelect&&(i=[],o.rows.forEach(function(e){e.isSelected||!1===e.enableSelection||!1===o.options.isRowSelectable(e)||(e.setSelected(!0),s.decideRaiseSelectionEvent(o,e,i,t))}),o.selection.selectAll=!0,s.decideRaiseSelectionBatchEvent(o,i,t))},selectAllVisibleRows:function(t){var i;!1!==o.options.multiSelect&&(i=[],o.rows.forEach(function(e){e.visible?e.isSelected||!1===e.enableSelection||!1===o.options.isRowSelectable(e)||(e.setSelected(!0),s.decideRaiseSelectionEvent(o,e,i,t)):e.isSelected&&(e.setSelected(!1),s.decideRaiseSelectionEvent(o,e,i,t))}),o.selection.selectAll=!0,s.decideRaiseSelectionBatchEvent(o,i,t))},clearSelectedRows:function(e){s.clearSelectedRows(o,e)},getSelectedRows:function(){return s.mapAndFilterRowsByEntity(s.getSelectedRows(o))},getUnSelectedRows:function(){return s.mapAndFilterRowsByEntity(s.getUnSelectedRows(o))},getSelectedGridRows:function(){return s.getSelectedRows(o)},getUnSelectedGridRows:function(){return s.getUnSelectedRows(o)},getSelectedCount:function(){return o.selection.selectedCount},setMultiSelect:function(e){o.options.multiSelect=e},setModifierKeysToMultiSelect:function(e){o.options.modifierKeysToMultiSelect=e},getSelectAllState:function(){return o.selection.selectAll}}};o.api.registerEventsFromObject(e),o.api.registerMethodsFromObject(t)},defaultGridOptions:function(e){e.enableRowSelection=!1!==e.enableRowSelection,e.multiSelect=!1!==e.multiSelect,e.noUnselect=!0===e.noUnselect,e.modifierKeysToMultiSelect=!0===e.modifierKeysToMultiSelect,e.enableRowHeaderSelection=!1!==e.enableRowHeaderSelection,void 0===e.enableFullRowSelection&&(e.enableFullRowSelection=!e.enableRowHeaderSelection),e.enableFocusRowOnRowHeaderClick=!1!==e.enableFocusRowOnRowHeaderClick||!e.enableRowHeaderSelection,e.enableSelectRowOnFocus=!1!==e.enableSelectRowOnFocus,e.enableSelectAll=!1!==e.enableSelectAll,e.enableSelectionBatchEvent=!1!==e.enableSelectionBatchEvent,e.selectionRowHeaderWidth=angular.isDefined(e.selectionRowHeaderWidth)?e.selectionRowHeaderWidth:30,e.enableFooterTotalSelected=!1!==e.enableFooterTotalSelected,e.isRowSelectable=angular.isDefined(e.isRowSelectable)?e.isRowSelectable:angular.noop},toggleRowSelection:function(e,t,i,r,n,o){var a;!1===t.enableSelection||(void 0===o&&(o=!0),a=t.isSelected,r||(a?1<s.getSelectedRows(e).length&&(a=!1,s.clearSelectedRows(e,i)):s.clearSelectedRows(e,i)),a&&n)||!o&&!t.visible||(t.setSelected(!a),!0===t.isSelected&&(e.selection.lastSelectedRow=t),e.selection.selectAll=e.rows.length===s.getSelectedRows(e).length,e.api.selection.raise.rowSelectionChanged(t,i))},shiftSelect:function(e,t,i,r){if(r){for(var r=0<s.getSelectedRows(e).length?e.renderContainers.body.visibleRowCache.indexOf(e.selection.lastSelectedRow):0,n=e.renderContainers.body.visibleRowCache.indexOf(t),o=(n<r&&(t=r,r=n,n=t),[]),a=r;a<=n;a++){var l=e.renderContainers.body.visibleRowCache[a];!l||l.isSelected||!1===l.enableSelection||(l.setSelected(!0),e.selection.lastSelectedRow=l,s.decideRaiseSelectionEvent(e,l,o,i))}s.decideRaiseSelectionBatchEvent(e,o,i)}},getSelectedRows:function(e){return e.rows.filter(function(e){return e.isSelected})},getUnSelectedRows:function(e){return e.rows.filter(function(e){return!e.isSelected})},mapAndFilterRowsByEntity:function(e){return"function"==typeof e.reduce?e.reduce(function(e,t){return!t.entity.hasOwnProperty("$$hashKey")&&angular.isObject(t.entity)||e.push(t.entity),e},[]):e.filter(function(e){return e.entity.hasOwnProperty("$$hashKey")||!angular.isObject(e.entity)}).map(function(e){return e.entity})},clearSelectedRows:function(t,i){var r=[];s.getSelectedRows(t).forEach(function(e){e.isSelected&&!1!==e.enableSelection&&(e.setSelected(!1),s.decideRaiseSelectionEvent(t,e,r,i))}),t.selection.selectAll=!1,t.selection.selectedCount=0,s.decideRaiseSelectionBatchEvent(t,r,i)},decideRaiseSelectionEvent:function(e,t,i,r){e.options.enableSelectionBatchEvent?i.push(t):e.api.selection.raise.rowSelectionChanged(t,r)},decideRaiseSelectionBatchEvent:function(e,t,i){0<t.length&&e.api.selection.raise.rowSelectionChangedBatch(t,i)}};return s}),e.directive("uiGridSelection",["i18nService","uiGridSelectionConstants","uiGridSelectionService","uiGridConstants",function(s,d,c,u){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){function n(e){return e.forEach(function(e){e.enableSelection=r.grid.options.isRowSelectable(e)}),e}function o(){r.grid.options.isRowSelectable!==angular.noop&&!0!==a&&(r.grid.registerRowsProcessor(n,500),a=!0)}c.initializeGrid(r.grid),r.grid.options.enableRowHeaderSelection&&(l={name:d.selectionRowHeaderColName,displayName:s.getSafeText("selection.displayName"),width:r.grid.options.selectionRowHeaderWidth,minWidth:10,cellTemplate:"ui-grid/selectionRowHeader",headerCellTemplate:"ui-grid/selectionHeaderCell",enableColumnResizing:!1,enableColumnMenu:!1,exporterSuppressExport:!0,allowCellFocus:!0},r.grid.addRowHeaderColumn(l,0));var a=!1,l=(o(),r.grid.registerDataChangeCallback(o,[u.dataChange.OPTIONS]));e.$on("$destroy",l)},post:function(e,t,i,r){}}}}}]),e.directive("uiGridSelectionRowHeaderButtons",["$templateCache","uiGridSelectionService","gridUtil",function(e,a,l){return{replace:!0,restrict:"E",template:e.get("ui-grid/selectionRowHeaderButtons"),scope:!0,require:"^uiGrid",link:function(e,t,i,r){var n=r.grid;function o(e,t){if(t.stopPropagation(),t.shiftKey)a.shiftSelect(n,e,t,n.options.multiSelect);else if(t.ctrlKey||t.metaKey)a.toggleRowSelection(n,e,t,n.options.multiSelect,n.options.noUnselect,!1);else if(e.groupHeader){a.toggleRowSelection(n,e,t,n.options.multiSelect,n.options.noUnselect,!1);for(var i=0;i<e.treeNode.children.length;i++)a.toggleRowSelection(n,e.treeNode.children[i].row,t,n.options.multiSelect,n.options.noUnselect,!1)}else a.toggleRowSelection(n,e,t,n.options.multiSelect&&!n.options.modifierKeysToMultiSelect,n.options.noUnselect,!1);n.options.enableFocusRowOnRowHeaderClick&&e.setFocused(!e.isFocused)&&n.api.selection.raise.rowFocusChanged(e,t)}e.selectButtonClick=o,e.selectButtonKeyDown=function(e,t){32!==t.keyCode&&13!==t.keyCode||(t.preventDefault(),o(e,t))},"ie"===l.detectBrowser()&&t.on("mousedown",function(e){(e.ctrlKey||e.shiftKey)&&(e.target.onselectstart=function(){return!1},window.setTimeout(function(){e.target.onselectstart=null},0))}),e.$on("$destroy",function(){t.off()})}}}]),e.directive("uiGridSelectionSelectAllButtons",["$templateCache","uiGridSelectionService",function(e,r){return{replace:!0,restrict:"E",template:e.get("ui-grid/selectionSelectAllButtons"),scope:!1,link:function(t){var i=t.col.grid;t.headerButtonKeyDown=function(e){32!==e.keyCode&&13!==e.keyCode||(e.preventDefault(),t.headerButtonClick(e))},t.headerButtonClick=function(e){i.selection.selectAll?(r.clearSelectedRows(i,e),i.options.noUnselect&&i.api.selection.selectRowByVisibleIndex(0,e),i.selection.selectAll=!1):i.options.multiSelect&&(i.api.selection.selectAllVisibleRows(e),i.selection.selectAll=!0)}}}}]),e.directive("uiGridViewport",function(){return{priority:-200,scope:!1,compile:function(e){var e=angular.element(e[0].querySelector(".ui-grid-canvas:not(.ui-grid-empty-base-layer-container)").children[0]),t="'ui-grid-row-selected': row.isSelected, 'ui-grid-row-focused': row.isFocused}",i=e.attr("ng-class"),t=i?i.slice(0,-1)+","+t:"{"+t;return e.attr("ng-class",t),{pre:function(e,t,i,r){},post:function(e,t,i,r){}}}}}),e.directive("uiGridCell",["uiGridConstants","uiGridSelectionService",function(g,p){return{priority:-200,restrict:"A",require:"?^uiGrid",scope:!1,link:function(i,n,e,t){function r(e){o=(new Date).getTime(),a=e.changedTouches[0],n.off("click",d)}var o=0,a={},l=300,s=100,d=(t.grid.api.cellNav&&t.grid.api.cellNav.on.viewPortKeyDown(i,function(e,t){null!==t&&t.row===i.row&&t.col===i.col&&e.keyCode===g.keymap.SPACE&&"selectionRowHeaderCol"===i.col.colDef.name&&(e.preventDefault(),p.toggleRowSelection(i.grid,i.row,e,i.grid.options.multiSelect&&!i.grid.options.modifierKeysToMultiSelect,i.grid.options.noUnselect,!1),i.$apply())}),function(e){"ui-grid-icon-minus-squared"!==e.target.className&&"ui-grid-icon-plus-squared"!==e.target.className&&(n.off("touchend",c),e.shiftKey?p.shiftSelect(i.grid,i.row,e,i.grid.options.multiSelect):e.ctrlKey||e.metaKey?p.toggleRowSelection(i.grid,i.row,e,i.grid.options.multiSelect,i.grid.options.noUnselect,!1):i.grid.options.enableSelectRowOnFocus&&p.toggleRowSelection(i.grid,i.row,e,i.grid.options.multiSelect&&!i.grid.options.modifierKeysToMultiSelect,i.grid.options.noUnselect,!1),i.row.setFocused(!i.row.isFocused),i.grid.api.selection.raise.rowFocusChanged(i.row,e),i.$apply(),window.setTimeout(function(){n.on("touchend",c)},l))}),c=function(e){var t=(new Date).getTime(),i=e.changedTouches[0],t=t-o,r=Math.abs(a.clientX-i.clientX),i=Math.abs(a.clientY-i.clientY);r<s&&i<s&&t<l&&d(e),window.setTimeout(function(){n.on("click",d)},l)};function u(){i.grid.options.enableRowSelection&&i.grid.options.enableFullRowSelection&&"selectionRowHeaderCol"!==i.col.colDef.name&&(n.addClass("ui-grid-disable-selection"),n.on("touchstart",r),n.on("touchend",c),n.on("click",d),i.registered=!0)}u();t=i.grid.registerDataChangeCallback(function(){i.grid.options.enableRowSelection&&i.grid.options.enableFullRowSelection&&!i.registered?u():i.grid.options.enableRowSelection&&i.grid.options.enableFullRowSelection||!i.registered||i.registered&&(n.removeClass("ui-grid-disable-selection"),n.off("touchstart",r),n.off("touchend",c),n.off("click",d),i.registered=!1)},[g.dataChange.OPTIONS]);n.on("$destroy",t)}}}]),e.directive("uiGridGridFooter",["$compile","gridUtil",function(n,o){return{restrict:"EA",replace:!0,priority:-1e3,require:"^uiGrid",scope:!0,compile:function(){return{pre:function(t,i,e,r){r.grid.options.showGridFooter&&o.getTemplate("ui-grid/gridFooterSelectedItems").then(function(e){e=angular.element(e),e=n(e)(t);angular.element(i[0].getElementsByClassName("ui-grid-grid-footer")[0]).append(e)})},post:function(e,t,i,r){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.treeBase",["ui.grid"]);e.constant("uiGridTreeBaseConstants",{featureName:"treeBase",rowHeaderColName:"treeBaseRowHeaderCol",EXPANDED:"expanded",COLLAPSED:"collapsed",aggregation:{COUNT:"count",SUM:"sum",MAX:"max",MIN:"min",AVG:"avg"}}),e.service("uiGridTreeBaseService",["$q","uiGridTreeBaseConstants","gridUtil","GridRow","gridClassFactory","i18nService","uiGridConstants","rowSorter",function(e,l,t,i,r,n,o,a){var s={initializeGrid:function(i){i.treeBase={},i.treeBase.numberLevels=0,i.treeBase.expandAll=!1,i.treeBase.tree=[],s.defaultGridOptions(i.options),i.registerRowsProcessor(s.treeRows,410),i.registerColumnBuilder(s.treeBaseColumnBuilder),s.createRowHeader(i);var e={treeBase:{rowExpanded:{},rowCollapsed:{}}},t={treeBase:{expandAllRows:function(){s.expandAllRows(i)},collapseAllRows:function(){s.collapseAllRows(i)},toggleRowTreeState:function(e){s.toggleRowTreeState(i,e)},expandRow:function(e,t){s.expandRow(i,e,t)},expandRowChildren:function(e){s.expandRowChildren(i,e)},collapseRow:function(e){s.collapseRow(i,e)},collapseRowChildren:function(e){s.collapseRowChildren(i,e)},getTreeExpandedState:function(){return{expandedState:s.getTreeState(i)}},setTreeState:function(e){s.setTreeState(i,e)},getRowChildren:function(e){return e.treeNode.children.map(function(e){return e.row})}}};i.api.registerEventsFromObject(e),i.api.registerMethodsFromObject(t)},defaultGridOptions:function(e){e.treeRowHeaderBaseWidth=e.treeRowHeaderBaseWidth||30,e.treeIndent=null!=e.treeIndent?e.treeIndent:10,e.showTreeRowHeader=!1!==e.showTreeRowHeader,e.showTreeExpandNoChildren=!1!==e.showTreeExpandNoChildren,e.treeRowHeaderAlwaysVisible=!1!==e.treeRowHeaderAlwaysVisible,e.treeCustomAggregations=e.treeCustomAggregations||{},e.enableExpandAll=!1!==e.enableExpandAll},treeBaseColumnBuilder:function(e,t,i){void 0!==e.customTreeAggregationFn&&(t.treeAggregationFn=e.customTreeAggregationFn),void 0!==e.treeAggregationType&&(t.treeAggregation={type:e.treeAggregationType},void 0!==i.treeCustomAggregations[e.treeAggregationType]?(t.treeAggregationFn=i.treeCustomAggregations[e.treeAggregationType].aggregationFn,t.treeAggregationFinalizerFn=i.treeCustomAggregations[e.treeAggregationType].finalizerFn,t.treeAggregation.label=i.treeCustomAggregations[e.treeAggregationType].label):void 0!==s.nativeAggregations()[e.treeAggregationType]&&(t.treeAggregationFn=s.nativeAggregations()[e.treeAggregationType].aggregationFn,t.treeAggregation.label=s.nativeAggregations()[e.treeAggregationType].label)),void 0!==e.treeAggregationLabel&&(void 0===t.treeAggregation&&(t.treeAggregation={}),t.treeAggregation.label=e.treeAggregationLabel),t.treeAggregationUpdateEntity=!1!==e.treeAggregationUpdateEntity,void 0===t.customTreeAggregationFinalizerFn&&(t.customTreeAggregationFinalizerFn=e.customTreeAggregationFinalizerFn)},createRowHeader:function(e){var t={name:l.rowHeaderColName,displayName:"",width:e.options.treeRowHeaderBaseWidth,minWidth:10,cellTemplate:"ui-grid/treeBaseRowHeader",headerCellTemplate:"ui-grid/treeBaseHeaderCell",enableColumnResizing:!1,enableColumnMenu:!1,exporterSuppressExport:!0,allowCellFocus:!0};t.visible=e.options.treeRowHeaderAlwaysVisible,e.addRowHeaderColumn(t,-100)},expandAllRows:function(t){t.treeBase.tree.forEach(function(e){s.setAllNodes(t,e,l.EXPANDED)}),t.treeBase.expandAll=!0,t.queueGridRefresh()},collapseAllRows:function(t){t.treeBase.tree.forEach(function(e){s.setAllNodes(t,e,l.COLLAPSED)}),t.treeBase.expandAll=!1,t.queueGridRefresh()},setAllNodes:function(t,e,i){void 0!==e.state&&e.state!==i&&((e.state=i)===l.EXPANDED?t.api.treeBase.raise.rowExpanded(e.row):t.api.treeBase.raise.rowCollapsed(e.row)),e.children&&e.children.forEach(function(e){s.setAllNodes(t,e,i)})},toggleRowTreeState:function(e,t){void 0===t.treeLevel||null===t.treeLevel||t.treeLevel<0||(t.treeNode.state===l.EXPANDED?s.collapseRow(e,t):s.expandRow(e,t,!1),e.queueGridRefresh())},expandRow:function(e,t,i){if(i){for(var r=[];t&&void 0!==t.treeLevel&&null!==t.treeLevel&&0<=t.treeLevel&&t.treeNode.state!==l.EXPANDED;)r.push(t),t=t.treeNode.parentRow;if(0<r.length){for(t=r.pop();t;)t.treeNode.state=l.EXPANDED,e.api.treeBase.raise.rowExpanded(t),t=r.pop();e.treeBase.expandAll=s.allExpanded(e.treeBase.tree),e.queueGridRefresh()}}else void 0===t.treeLevel||null===t.treeLevel||t.treeLevel<0||t.treeNode.state!==l.EXPANDED&&(t.treeNode.state=l.EXPANDED,e.api.treeBase.raise.rowExpanded(t),e.treeBase.expandAll=s.allExpanded(e.treeBase.tree),e.queueGridRefresh())},expandRowChildren:function(e,t){void 0===t.treeLevel||null===t.treeLevel||t.treeLevel<0||(s.setAllNodes(e,t.treeNode,l.EXPANDED),e.treeBase.expandAll=s.allExpanded(e.treeBase.tree),e.queueGridRefresh())},collapseRow:function(e,t){void 0===t.treeLevel||null===t.treeLevel||t.treeLevel<0||t.treeNode.state!==l.COLLAPSED&&(t.treeNode.state=l.COLLAPSED,e.treeBase.expandAll=!1,e.api.treeBase.raise.rowCollapsed(t),e.queueGridRefresh())},collapseRowChildren:function(e,t){void 0===t.treeLevel||null===t.treeLevel||t.treeLevel<0||(s.setAllNodes(e,t.treeNode,l.COLLAPSED),e.treeBase.expandAll=!1,e.queueGridRefresh())},allExpanded:function(e){var t=!0;return e.forEach(function(e){s.allExpandedInternal(e)||(t=!1)}),t},allExpandedInternal:function(e){var t;return!(e.children&&0<e.children.length)||e.state!==l.COLLAPSED&&(t=!0,e.children.forEach(function(e){s.allExpandedInternal(e)||(t=!1)}),t)},treeRows:function(e){return 0===e.length?(s.updateRowHeaderWidth(this),e):(this.treeBase.tree=s.createTree(this,e),s.updateRowHeaderWidth(this),s.sortTree(this),s.fixFilter(this),s.renderTree(this.treeBase.tree))},updateRowHeaderWidth:function(e){var t=e.getColumn(l.rowHeaderColName),i=e.options.treeRowHeaderBaseWidth+e.options.treeIndent*Math.max(e.treeBase.numberLevels-1,0),i=(t&&i!==t.width&&(t.width=i,e.queueRefresh()),!0);!1===e.options.showTreeRowHeader&&(i=!1),!1===e.options.treeRowHeaderAlwaysVisible&&e.treeBase.numberLevels<=0&&(i=!1),t&&t.visible!==i&&(t.visible=i,t.colDef.visible=i,e.queueGridRefresh())},renderTree:function(e){var t=[];return e.forEach(function(e){e.row.visible&&t.push(e.row),e.state===l.EXPANDED&&e.children&&0<e.children.length&&(t=t.concat(s.renderTree(e.children)))}),t},createTree:function(i,e){var r=-1,n={},o=[],a=(i.treeBase.tree=[],i.treeBase.numberLevels=0,s.getAggregations(i));for(e.forEach(function(e){if(e.internalRow||e.treeLevel===e.entity.$$treeLevel||(e.treeLevel=e.entity.$$treeLevel),e.treeLevel<=r){for(;e.treeLevel<=r;){var t=o.pop();s.finaliseAggregations(t),r--}0<o.length?s.setCurrentState(o):l.EXPANDED}void 0!==e.treeLevel&&null!==e.treeLevel&&0<=e.treeLevel&&n.hasOwnProperty(e.uid)&&o.push(n[e.uid]),(void 0===e.treeLevel||null===e.treeLevel||e.treeLevel<0)&&e.visible&&s.aggregate(i,e,o),n.hasOwnProperty(e.uid)||s.addOrUseNode(i,e,o,a),void 0!==e.treeLevel&&null!==e.treeLevel&&0<=e.treeLevel&&(n.hasOwnProperty(e.uid)||(n[e.uid]=e,o.push(e)),r++,s.setCurrentState(o)),i.treeBase.numberLevels<e.treeLevel+1&&(i.treeBase.numberLevels=e.treeLevel+1)});0<o.length;){var t=o.pop();s.finaliseAggregations(t)}return i.treeBase.tree},addOrUseNode:function(e,t,i,r){var n=[],r=(r.forEach(function(e){n.push(s.buildAggregationObject(e.col))}),{state:l.COLLAPSED,row:t,parentRow:null,aggregations:n,children:[]});t.treeNode&&(r.state=t.treeNode.state),0<i.length&&(r.parentRow=i[i.length-1]),t.treeNode=r,(0===i.length?e.treeBase.tree:i[i.length-1].treeNode.children).push(r)},setCurrentState:function(e){var t=l.EXPANDED;return e.forEach(function(e){e.treeNode.state===l.COLLAPSED&&(t=l.COLLAPSED)}),t},sortTree:function(e){e.columns.forEach(function(e){e.sort&&e.sort.ignoreSort&&delete e.sort.ignoreSort}),e.treeBase.tree=s.sortInternal(e,e.treeBase.tree)},sortInternal:function(t,e){e=e.map(function(e){return e.row}),e=(e=a.sort(t,e,t.columns)).map(function(e){return e.treeNode});return e.forEach(function(e){e.state===l.EXPANDED&&e.children&&0<e.children.length&&(e.children=s.sortInternal(t,e.children))}),e},fixFilter:function(e){var t;e.treeBase.tree.forEach(function(e){e.children&&0<e.children.length&&(t=e.row.visible,s.fixFilterInternal(e.children,t))})},fixFilterInternal:function(e,t){return e.forEach(function(e){e.row.visible&&!t&&(s.setParentsVisible(e),t=!0),e.children&&0<e.children.length&&s.fixFilterInternal(e.children,t&&e.row.visible)&&(t=!0)}),t},setParentsVisible:function(e){for(;e.parentRow;)e.parentRow.visible=!0,e=e.parentRow.treeNode},buildAggregationObject:function(e){var t={col:e};return e.treeAggregation&&e.treeAggregation.type&&(t.type=e.treeAggregation.type),e.treeAggregation&&e.treeAggregation.label&&(t.label=e.treeAggregation.label),t},getAggregations:function(t){var i=[];return t.columns.forEach(function(e){void 0!==e.treeAggregationFn&&(i.push(s.buildAggregationObject(e)),t.options.showColumnFooter)&&void 0===e.colDef.aggregationType&&e.treeAggregation&&(e.treeFooterAggregation=s.buildAggregationObject(e),e.aggregationType=s.treeFooterAggregationType)}),i},aggregate:function(n,o,e){0===e.length&&o.treeNode&&o.treeNode.aggregations&&o.treeNode.aggregations.forEach(function(e){var t,i;void 0!==e.col.treeFooterAggregation&&(t=n.getCellValue(o,e.col),i=Number(t),e.col.treeAggregationFn?e.col.treeAggregationFn(e.col.treeFooterAggregation,t,i,o):e.col.treeFooterAggregation.value=void 0)}),e.forEach(function(e,r){e.treeNode.aggregations&&e.treeNode.aggregations.forEach(function(e){var t=n.getCellValue(o,e.col),i=Number(t);e.col.treeAggregationFn(e,t,i,o),0===r&&void 0!==e.col.treeFooterAggregation&&(e.col.treeAggregationFn?e.col.treeAggregationFn(e.col.treeFooterAggregation,t,i,o):e.col.treeFooterAggregation.value=void 0)})})},nativeAggregations:function(){return{count:{label:n.get().aggregation.count,menuTitle:n.get().grouping.aggregate_count,aggregationFn:function(e,t,i){void 0===e.value?e.value=1:e.value++}},sum:{label:n.get().aggregation.sum,menuTitle:n.get().grouping.aggregate_sum,aggregationFn:function(e,t,i){isNaN(i)||(void 0===e.value?e.value=i:e.value+=i)}},min:{label:n.get().aggregation.min,menuTitle:n.get().grouping.aggregate_min,aggregationFn:function(e,t,i){(void 0===e.value||null!=t&&(t<e.value||null===e.value))&&(e.value=t)}},max:{label:n.get().aggregation.max,menuTitle:n.get().grouping.aggregate_max,aggregationFn:function(e,t,i){(void 0===e.value||null!=t&&(t>e.value||null===e.value))&&(e.value=t)}},avg:{label:n.get().aggregation.avg,menuTitle:n.get().grouping.aggregate_avg,aggregationFn:function(e,t,i){void 0===e.count?e.count=1:e.count++,isNaN(i)||(void 0===e.value||void 0===e.sum?(e.value=i,e.sum=i):(e.sum+=i,e.value=e.sum/e.count))}}}},finaliseAggregation:function(e,t){t.col.treeAggregationUpdateEntity&&void 0!==e&&void 0!==e.entity["$$"+t.col.uid]&&angular.extend(t,e.entity["$$"+t.col.uid]),"function"==typeof t.col.treeAggregationFinalizerFn&&t.col.treeAggregationFinalizerFn(t),"function"==typeof t.col.customTreeAggregationFinalizerFn&&t.col.customTreeAggregationFinalizerFn(t),void 0===t.rendered&&(t.rendered=t.label?t.label+t.value:t.value)},finaliseAggregations:function(e){null!=e&&void 0!==e.treeNode.aggregations&&e.treeNode.aggregations.forEach(function(i){var r;s.finaliseAggregation(e,i),i.col.treeAggregationUpdateEntity&&(r={},angular.forEach(i,function(e,t){i.hasOwnProperty(t)&&"col"!==t&&(r[t]=e)}),e.entity["$$"+i.col.uid]=r)})},treeFooterAggregationType:function(e,t){return s.finaliseAggregation(void 0,t.treeFooterAggregation),void 0===t.treeFooterAggregation.value||null===t.treeFooterAggregation.rendered?"":t.treeFooterAggregation.rendered}};return s}]),e.directive("uiGridTreeBaseRowHeaderButtons",["$templateCache","uiGridTreeBaseService",function(e,o){return{replace:!0,restrict:"E",template:e.get("ui-grid/treeBaseRowHeaderButtons"),scope:!0,require:"^uiGrid",link:function(i,e,t,r){var n=r.grid;i.treeButtonClass=function(e){if(n.options.showTreeExpandNoChildren&&-1<e.treeLevel||e.treeNode.children&&0<e.treeNode.children.length)return"expanded"===e.treeNode.state?"ui-grid-icon-minus-squared":"collapsed"===e.treeNode.state?"ui-grid-icon-plus-squared":void 0},i.treeButtonClick=function(e,t){t.stopPropagation(),o.toggleRowTreeState(n,e,t)},i.treeButtonKeyDown=function(e,t){32!==t.keyCode&&13!==t.keyCode||i.treeButtonClick(e,t)}}}}]),e.directive("uiGridTreeBaseExpandAllButtons",["$templateCache","uiGridTreeBaseService",function(e,r){return{replace:!0,restrict:"E",template:e.get("ui-grid/treeBaseExpandAllButtons"),scope:!1,link:function(t){var i=t.col.grid;t.headerButtonClass=function(){return 0<i.treeBase.numberLevels&&i.treeBase.expandAll?"ui-grid-icon-minus-squared":0<i.treeBase.numberLevels&&!i.treeBase.expandAll?"ui-grid-icon-plus-squared":void 0},t.headerButtonClick=function(e,t){i.treeBase.expandAll?r.collapseAllRows(i,t):r.expandAllRows(i,t)},t.headerButtonKeyDown=function(e){32!==e.keyCode&&13!==e.keyCode||t.headerButtonClick(i,e)}}}}]),e.directive("uiGridViewport",function(){return{priority:-200,scope:!1,compile:function(e){var e=angular.element(e.children().children()[0]),t=e.attr("ng-class"),i="",i=t?t.slice(0,-1)+",'ui-grid-tree-header-row': row.treeLevel > -1}":"{'ui-grid-tree-header-row': row.treeLevel > -1}";return e.attr("ng-class",i),{pre:function(e,t,i,r){},post:function(e,t,i,r){}}}}})}(),function(){"use strict";var e=angular.module("ui.grid.treeView",["ui.grid","ui.grid.treeBase"]);e.constant("uiGridTreeViewConstants",{featureName:"treeView",rowHeaderColName:"treeBaseRowHeaderCol",EXPANDED:"expanded",COLLAPSED:"collapsed",aggregation:{COUNT:"count",SUM:"sum",MAX:"max",MIN:"min",AVG:"avg"}}),e.service("uiGridTreeViewService",["$q","uiGridTreeViewConstants","uiGridTreeBaseConstants","uiGridTreeBaseService","gridUtil","GridRow","gridClassFactory","i18nService","uiGridConstants",function(e,t,i,r,n,o,a,l,s){var d={initializeGrid:function(e,t){r.initializeGrid(e,t),e.treeView={},e.registerRowsProcessor(d.adjustSorting,60);var t={treeView:{}},i={treeView:{}};e.api.registerEventsFromObject(t),e.api.registerMethodsFromObject(i)},defaultGridOptions:function(e){e.enableTreeView=!1!==e.enableTreeView},adjustSorting:function(e){return this.columns.forEach(function(e){e.sort&&(e.sort.ignoreSort=!0)}),e}};return d}]),e.directive("uiGridTreeView",["uiGridTreeViewConstants","uiGridTreeViewService","$templateCache",function(e,n,t){return{replace:!0,priority:0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){!1!==r.grid.options.enableTreeView&&n.initializeGrid(r.grid,e)},post:function(e,t,i,r){}}}}}])}(),function(){"use strict";var e=angular.module("ui.grid.validate",["ui.grid"]);e.service("uiGridValidateService",["$sce","$q","$http","i18nService","uiGridConstants",function(r,s,e,n,t){var d={validatorFactories:{},setExternalFactoryFunction:function(e){d.externalFactoryFunction=e},clearExternalFactory:function(){delete d.externalFactoryFunction},getValidatorFromExternalFactory:function(e,t){return d.externalFactoryFunction(e,t).validatorFactory(t)},getMessageFromExternalFactory:function(e,t){return d.externalFactoryFunction(e,t).messageFunction(t)},setValidator:function(e,t,i){d.validatorFactories[e]={validatorFactory:t,messageFunction:i}},getValidator:function(e,t){if(d.externalFactoryFunction){var i=d.getValidatorFromExternalFactory(e,t);if(i)return i}if(d.validatorFactories[e])return d.validatorFactories[e].validatorFactory(t);throw"Invalid validator name: "+e},getMessage:function(e,t){if(d.externalFactoryFunction){var i=d.getMessageFromExternalFactory(e,t);if(i)return i}return d.validatorFactories[e].messageFunction(t)},isInvalid:function(e,t){return e["$$invalid"+t.name]},setInvalid:function(e,t){e["$$invalid"+t.name]=!0},setValid:function(e,t){delete e["$$invalid"+t.name]},setError:function(e,t,i){e["$$errors"+t.name]||(e["$$errors"+t.name]={}),e["$$errors"+t.name][i]=!0},clearError:function(e,t,i){e["$$errors"+t.name]&&i in e["$$errors"+t.name]&&delete e["$$errors"+t.name][i]},getErrorMessages:function(e,t){var i=[];return e["$$errors"+t.name]&&0!==Object.keys(e["$$errors"+t.name]).length&&Object.keys(e["$$errors"+t.name]).sort().forEach(function(e){i.push(d.getMessage(e,t.validators[e]))}),i},getFormattedErrors:function(e,t){var i="",e=d.getErrorMessages(e,t);if(e.length)return e.forEach(function(e){i+=e+"<br/>"}),r.trustAsHtml("<p><b>"+n.getSafeText("validate.error")+"</b></p>"+i)},getTitleFormattedErrors:function(e,t){var i="",e=d.getErrorMessages(e,t);if(e.length)return e.forEach(function(e){i+=e+"\n"}),r.trustAsHtml(n.getSafeText("validate.error")+"\n"+i)},runValidators:function(e,t,n,o,a){if(n!==o){if(void 0===t.name||!t.name)throw new Error("colDef.name is required to perform validation");d.setValid(e,t);var i,r=[];for(i in t.validators){d.clearError(e,t,i);var l=d.getValidator(i,t.validators[i]),l=s.when(l(o,n,e,t)).then(function(t,i,r){return function(e){e||(d.setInvalid(t,i),d.setError(t,i,r),a&&a.api.validate.raise.validationFailed(t,i,n,o))}}(e,t,i));r.push(l)}return s.all(r)}},createDefaultValidators:function(){d.setValidator("minLength",function(i){return function(e,t){return null==t||""===t||t.length>=i}},function(e){return n.getSafeText("validate.minLength").replace("THRESHOLD",e)}),d.setValidator("maxLength",function(i){return function(e,t){return null==t||""===t||t.length<=i}},function(e){return n.getSafeText("validate.maxLength").replace("THRESHOLD",e)}),d.setValidator("required",function(i){return function(e,t){return!i||!(null==t||""===t)}},function(){return n.getSafeText("validate.required")})},initializeGrid:function(e,n){n.validate={isInvalid:d.isInvalid,getErrorMessages:d.getErrorMessages,getFormattedErrors:d.getFormattedErrors,getTitleFormattedErrors:d.getTitleFormattedErrors,runValidators:d.runValidators};var t={validate:{validationFailed:function(e,t,i,r){}}},i={validate:{isInvalid:function(e,t){return n.validate.isInvalid(e,t)},getErrorMessages:function(e,t){return n.validate.getErrorMessages(e,t)},getFormattedErrors:function(e,t){return n.validate.getFormattedErrors(e,t)},getTitleFormattedErrors:function(e,t){return n.validate.getTitleFormattedErrors(e,t)}}};n.api.registerEventsFromObject(t),n.api.registerMethodsFromObject(i),n.edit&&n.api.edit.on.afterCellEdit(e,function(e,t,i,r){n.validate.runValidators(e,t,i,r,n)}),d.createDefaultValidators()}};return d}]),e.directive("uiGridValidate",["gridUtil","uiGridValidateService",function(e,n){return{priority:0,replace:!0,require:"^uiGrid",scope:!1,compile:function(){return{pre:function(e,t,i,r){n.initializeGrid(e,r.grid)},post:function(e,t,i,r){}}}}}])}(),angular.module("ui.grid").run(["$templateCache",function(e){"use strict";e.put("ui-grid/ui-grid-filter",'<div class="ui-grid-filter-container" ng-style="col.extraStyle" ng-repeat="colFilter in col.filters" ng-class="{\'ui-grid-filter-cancel-button-hidden\' : colFilter.disableCancelFilterButton === true }"><div ng-if="colFilter.type !== \'select\'"><input type="text" class="ui-grid-filter-input ui-grid-filter-input-{{$index}}" ng-model="colFilter.term" ng-attr-placeholder="{{colFilter.placeholder || \'\'}}" aria-label="{{colFilter.ariaLabel || aria.defaultFilterLabel}}"><div role="button" class="ui-grid-filter-button" ng-click="removeFilter(colFilter, $index)" ng-if="!colFilter.disableCancelFilterButton" ng-disabled="colFilter.term === undefined || colFilter.term === null || colFilter.term === \'\'" ng-show="colFilter.term !== undefined && colFilter.term !== null && colFilter.term !== \'\'"><i class="ui-grid-icon-cancel" ui-grid-one-bind-aria-label="aria.removeFilter">&nbsp;</i></div></div><div ng-if="colFilter.type === \'select\'"><select class="ui-grid-filter-select ui-grid-filter-input-{{$index}}" ng-model="colFilter.term" ng-show="colFilter.selectOptions.length > 0" ng-attr-placeholder="{{colFilter.placeholder || aria.defaultFilterLabel}}" aria-label="{{colFilter.ariaLabel || \'\'}}" ng-options="option.value as option.label for option in colFilter.selectOptions"><option value=""></option></select><div role="button" class="ui-grid-filter-button-select" ng-click="removeFilter(colFilter, $index)" ng-if="!colFilter.disableCancelFilterButton" ng-disabled="colFilter.term === undefined || colFilter.term === null || colFilter.term === \'\'" ng-show="colFilter.term !== undefined && colFilter.term != null"><i class="ui-grid-icon-cancel" ui-grid-one-bind-aria-label="aria.removeFilter">&nbsp;</i></div></div></div>'),e.put("ui-grid/ui-grid-footer",'<div class="ui-grid-footer-panel ui-grid-footer-aggregates-row">\x3c!-- tfooter --\x3e<div class="ui-grid-footer ui-grid-footer-viewport"><div class="ui-grid-footer-canvas"><div class="ui-grid-footer-cell-wrapper" ng-style="colContainer.headerCellWrapperStyle()"><div role="row" class="ui-grid-footer-cell-row"><div ui-grid-footer-cell role="gridcell" ng-repeat="col in colContainer.renderedColumns track by col.uid" col="col" render-index="$index" class="ui-grid-footer-cell ui-grid-clearfix"></div></div></div></div></div></div>'),e.put("ui-grid/ui-grid-grid-footer",'<div class="ui-grid-footer-info ui-grid-grid-footer"><span>{{\'search.totalItems\' | t}} {{grid.rows.length}}</span> <span ng-if="grid.renderContainers.body.visibleRowCache.length !== grid.rows.length" class="ngLabel">({{"search.showingItems" | t}} {{grid.renderContainers.body.visibleRowCache.length}})</span></div>'),e.put("ui-grid/ui-grid-header",'<div role="rowgroup" class="ui-grid-header">\x3c!-- theader --\x3e<div class="ui-grid-top-panel"><div class="ui-grid-header-viewport"><div class="ui-grid-header-canvas"><div class="ui-grid-header-cell-wrapper" ng-style="colContainer.headerCellWrapperStyle()"><div role="row" class="ui-grid-header-cell-row"><div role="columnheader" class="ui-grid-header-cell ui-grid-clearfix" ng-repeat="col in colContainer.renderedColumns track by col.uid" ui-grid-header-cell col="col" render-index="$index"></div></div></div></div></div></div></div>'),e.put("ui-grid/ui-grid-menu-button",'<div class="ui-grid-menu-button"><div role="button" ui-grid-one-bind-id-grid="\'grid-menu\'" ui-grid-one-bind-aria-label="i18n.aria.buttonLabel" tabindex="0" class="ui-grid-icon-container" ng-click="toggleMenu()" ng-keydown="toggleOnKeydown($event)" aria-expanded="{{shown}}" aria-haspopup="true"><i class="ui-grid-icon-menu" ui-grid-one-bind-aria-label="i18n.aria.buttonLabel">&nbsp;</i></div><div ui-grid-menu menu-items="menuItems"></div></div>'),e.put("ui-grid/ui-grid-menu-header-item",'<li role="menuitem"><div class="ui-grid-menu-item" role="heading" aria-level="2" ng-show="itemShown()"><i aria-hidden="true">&nbsp; </i><span ng-bind="label()"></span></div></li>'),e.put("ui-grid/ui-grid-no-header",'<div class="ui-grid-top-panel"></div>'),e.put("ui-grid/ui-grid-row","<div ng-repeat=\"(colRenderIndex, col) in colContainer.renderedColumns track by col.uid\" ui-grid-one-bind-id-grid=\"rowRenderIndex + '-' + col.uid + '-cell'\" class=\"ui-grid-cell\" ng-class=\"{ 'ui-grid-row-header-cell': col.isRowHeader }\" role=\"{{col.isRowHeader ? 'rowheader' : 'gridcell'}}\" ui-grid-cell></div>"),e.put("ui-grid/ui-grid",'<div ui-i18n="en" class="ui-grid">\x3c!-- TODO (c0bra): add "scoped" attr here, eventually? --\x3e<style ui-grid-style>.grid{{ grid.id }} {\n      /* Styles for the grid */\n    }\n\n    .grid{{ grid.id }} .ui-grid-row, .grid{{ grid.id }} .ui-grid-cell, .grid{{ grid.id }} .ui-grid-cell .ui-grid-vertical-bar {\n      height: {{ grid.options.rowHeight }}px;\n    }\n\n    .grid{{ grid.id }} .ui-grid-row:last-child .ui-grid-cell {\n      border-bottom-width: {{ (((grid.getVisibleRowCount() * grid.options.rowHeight) < grid.getViewportHeight()) && \'1\') || \'0\' }}px;\n    }\n\n    {{ grid.verticalScrollbarStyles }}\n    {{ grid.horizontalScrollbarStyles }}\n\n    /*\n    .ui-grid[dir=rtl] .ui-grid-viewport {\n      padding-left: {{ grid.verticalScrollbarWidth }}px;\n    }\n    */\n\n    {{ grid.customStyles }}</style><div class="ui-grid-contents-wrapper" role="grid"><div ui-grid-menu-button ng-if="grid.options.enableGridMenu"></div><div ng-if="grid.hasLeftContainer()" style="width: 0" ui-grid-pinned-container="\'left\'"></div><div ui-grid-render-container container-id="\'body\'" col-container-name="\'body\'" row-container-name="\'body\'" bind-scroll-horizontal="true" bind-scroll-vertical="true" enable-horizontal-scrollbar="grid.options.enableHorizontalScrollbar" enable-vertical-scrollbar="grid.options.enableVerticalScrollbar"></div><div ng-if="grid.hasRightContainer()" style="width: 0" ui-grid-pinned-container="\'right\'"></div><div ui-grid-grid-footer ng-if="grid.options.showGridFooter"></div><div ui-grid-column-menu ng-if="grid.options.enableColumnMenus"></div><div ng-transclude></div></div></div>'),e.put("ui-grid/uiGridCell",'<div class="ui-grid-cell-contents" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div>'),e.put("ui-grid/uiGridColumnMenu",'<div class="ui-grid-column-menu"><div ui-grid-menu menu-items="menuItems" col="col">\x3c!-- <div class="ui-grid-column-menu">\n    <div class="inner" ng-show="menuShown">\n      <ul>\n        <div ng-show="grid.options.enableSorting">\n          <li ng-click="sortColumn($event, asc)" ng-class="{ \'selected\' : col.sort.direction == asc }"><i class="ui-grid-icon-sort-alt-up"></i> Sort Ascending</li>\n          <li ng-click="sortColumn($event, desc)" ng-class="{ \'selected\' : col.sort.direction == desc }"><i class="ui-grid-icon-sort-alt-down"></i> Sort Descending</li>\n          <li ng-show="col.sort.direction" ng-click="unsortColumn()"><i class="ui-grid-icon-cancel"></i> Remove Sort</li>\n        </div>\n      </ul>\n    </div>\n  </div> --\x3e</div></div>'),e.put("ui-grid/uiGridFooterCell",'<div class="ui-grid-cell-contents" col-index="renderIndex"><div>{{ col.getAggregationText() + ( col.getAggregationValue() CUSTOM_FILTERS ) }}</div></div>'),e.put("ui-grid/uiGridHeaderCell",'<div role="columnheader" ng-class="{ \'sortable\': sortable, \'ui-grid-header-cell-last-col\': isLastCol }" ui-grid-one-bind-aria-labelledby-grid="col.uid + \'-header-text \' + col.uid + \'-sortdir-text\'" aria-sort="{{col.sort.direction == asc ? \'ascending\' : ( col.sort.direction == desc ? \'descending\' : (!col.sort.direction ? \'none\' : \'other\'))}}"><div role="button" tabindex="0" ng-keydown="handleKeyDown($event)" class="ui-grid-cell-contents ui-grid-header-cell-primary-focus" col-index="renderIndex" title="TOOLTIP"><span class="ui-grid-header-cell-label" ui-grid-one-bind-id-grid="col.uid + \'-header-text\'">{{ col.displayName CUSTOM_FILTERS }}</span> <span ui-grid-one-bind-id-grid="col.uid + \'-sortdir-text\'" ui-grid-visible="col.sort.direction" aria-label="{{getSortDirectionAriaLabel()}}"><i ng-class="{ \'ui-grid-icon-up-dir\': col.sort.direction == asc, \'ui-grid-icon-down-dir\': col.sort.direction == desc, \'ui-grid-icon-blank\': !col.sort.direction }" title="{{isSortPriorityVisible() ? i18n.headerCell.priority + \' \' + ( col.sort.priority + 1 )  : null}}" aria-hidden="true"></i> <sub ui-grid-visible="isSortPriorityVisible()" class="ui-grid-sort-priority-number">{{col.sort.priority + 1}}</sub></span></div><div role="button" tabindex="0" ui-grid-one-bind-id-grid="col.uid + \'-menu-button\'" class="ui-grid-column-menu-button" ng-if="grid.options.enableColumnMenus && !col.isRowHeader  && col.colDef.enableColumnMenu !== false" ng-click="toggleMenu($event)" ng-keydown="headerCellArrowKeyDown($event)" ui-grid-one-bind-aria-label="i18n.headerCell.aria.columnMenuButtonLabel" aria-expanded="{{col.menuShown}}" aria-haspopup="true"><i class="ui-grid-icon-angle-down" aria-hidden="true">&nbsp;</i></div><div ui-grid-filter ng-hide="col.filterContainer === \'columnMenu\'"></div></div>'),e.put("ui-grid/uiGridMenu",'<div class="ui-grid-menu" ng-keydown="checkKeyDown($event)" ng-show="shown"><style ui-grid-style>{{dynamicStyles}}</style><div class="ui-grid-menu-mid" ng-show="shownMid"><div class="ui-grid-menu-inner" ng-if="shown"><ul role="menu" class="ui-grid-menu-items"><li ng-repeat="item in menuItems" role="menuitem" ui-grid-menu-item ui-grid-one-bind-id="\'menuitem-\'+$index" action="item.action" name="item.title" active="item.active" icon="item.icon" shown="item.shown" context="item.context" template-url="item.templateUrl" leave-open="item.leaveOpen" screen-reader-only="item.screenReaderOnly"></li><li ng-if="col.filterable && col.filterContainer === \'columnMenu\'"><div ui-grid-filter></div></li></ul></div></div></div>'),e.put("ui-grid/uiGridMenuItem",'<button type="button" class="ui-grid-menu-item" ng-click="itemAction($event, title)" ng-show="itemShown()" ng-class="{ \'ui-grid-menu-item-active\': active(), \'ui-grid-sr-only\': (!focus && screenReaderOnly) }" aria-pressed="{{active()}}" tabindex="0" ng-focus="focus=true" ng-blur="focus=false"><i ng-class="icon" aria-hidden="true">&nbsp; </i>{{ label() }}</button>'),e.put("ui-grid/uiGridRenderContainer","<div role=\"presentation\" ui-grid-one-bind-id-grid=\"containerId + '-grid-container'\" class=\"ui-grid-render-container\" ng-style=\"{ 'margin-left': colContainer.getMargin('left') + 'px', 'margin-right': colContainer.getMargin('right') + 'px' }\">\x3c!-- All of these dom elements are replaced in place --\x3e<div ui-grid-header></div><div ui-grid-viewport></div><div ng-if=\"colContainer.needsHScrollbarPlaceholder()\" class=\"ui-grid-scrollbar-placeholder\" ng-style=\"{height: colContainer.grid.scrollbarHeight + 'px'}\"></div><ui-grid-footer ng-if=\"grid.options.showColumnFooter\"></ui-grid-footer></div>"),e.put("ui-grid/uiGridViewport",'<div role="rowgroup" class="ui-grid-viewport" ng-style="colContainer.getViewportStyle()">\x3c!-- tbody --\x3e<div class="ui-grid-canvas"><div ng-repeat="(rowRenderIndex, row) in rowContainer.renderedRows track by $index" class="ui-grid-row" ng-style="Viewport.rowStyle(rowRenderIndex)"><div role="row" ui-grid-row="row" row-render-index="rowRenderIndex"></div></div></div></div>'),e.put("ui-grid/cellEditor",'<div><form name="inputForm"><input type="INPUT_TYPE" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'),e.put("ui-grid/dropdownEditor",'<div><form name="inputForm"><select ng-class="\'colt\' + col.uid" ui-grid-edit-dropdown ng-model="MODEL_COL_FIELD" ng-options="field[editDropdownIdLabel] as field[editDropdownValueLabel] CUSTOM_FILTERS for field in editDropdownOptionsArray"></select></form></div>'),e.put("ui-grid/fileChooserEditor",'<div><form name="inputForm"><input ng-class="\'colt\' + col.uid" ui-grid-edit-file-chooser type="file" id="files" name="files[]" ng-model="MODEL_COL_FIELD"></form></div>'),e.put("ui-grid/emptyBaseLayerContainer",'<div class="ui-grid-empty-base-layer-container ui-grid-canvas"><div class="ui-grid-row" ng-repeat="(rowRenderIndex, row) in grid.baseLayer.emptyRows track by $index" ng-style="Viewport.rowStyle(rowRenderIndex)"><div><div><div ng-repeat="(colRenderIndex, col) in colContainer.renderedColumns track by col.colDef.name" class="ui-grid-cell {{ col.getColClass(false) }}"></div></div></div></div></div>'),e.put("ui-grid/expandableRow",'<div ui-grid-expandable-row ng-if="expandableRow.shouldRenderExpand()" class="expandableRow" style="float:left; margin-top: 1px; margin-bottom: 1px" ng-style="{width: (grid.renderContainers.body.getCanvasWidth()) + \'px\', height: row.expandedRowHeight + \'px\'}"></div>'),e.put("ui-grid/expandableRowHeader",'<div class="ui-grid-row-header-cell ui-grid-expandable-buttons-cell"><div class="ui-grid-cell-contents"><i class="clickable" ng-if="!(row.groupHeader==true || row.entity.subGridOptions.disableRowExpandable)" ng-class="{ \'ui-grid-icon-plus-squared\' : !row.isExpanded, \'ui-grid-icon-minus-squared\' : row.isExpanded }" ng-click="grid.api.expandable.toggleRowExpansion(row.entity, $event)" aria-expanded="{{!!row.isExpanded}}"></i></div></div>'),e.put("ui-grid/expandableScrollFiller","<div ng-if=\"expandableRow.shouldRenderFiller()\" ng-class=\"{scrollFiller: true, scrollFillerClass:(colContainer.name === 'body')}\" ng-style=\"{ width: (grid.getViewportWidth()) + 'px', height: row.expandedRowHeight + 2 + 'px', 'margin-left': grid.options.rowHeader.rowHeaderWidth + 'px' }\">&nbsp;</div>"),e.put("ui-grid/expandableTopRowHeader",'<div class="ui-grid-row-header-cell ui-grid-expandable-buttons-cell"><div class="ui-grid-cell-contents"><span class="ui-grid-cell-empty" ng-if="!grid.options.showExpandAllButton"></span> <button type="button" class="ui-grid-icon-button clickable" ng-if="grid.options.showExpandAllButton" ng-class="{ \'ui-grid-icon-plus-squared\' : !grid.expandable.expandedAll, \'ui-grid-icon-minus-squared\' : grid.expandable.expandedAll }" ng-click="grid.api.expandable.toggleAllRows()" aria-expanded="{{grid.expandable.expandedAll}}"></button></div></div>'),e.put("ui-grid/csvLink",'<span class="ui-grid-exporter-csv-link-span"><a href="data:text/csv;charset=UTF-8,CSV_CONTENT" download="FILE_NAME">LINK_LABEL</a></span>'),e.put("ui-grid/importerMenuItem",'<li class="ui-grid-menu-item"><form><input class="ui-grid-importer-file-chooser" type="file" id="files" name="files[]"></form></li>'),e.put("ui-grid/importerMenuItemContainer","<div ui-grid-importer-menu-item></div>"),e.put("ui-grid/pagination",'<div class="ui-grid-pager-panel" ui-grid-pager ng-show="grid.options.enablePaginationControls"><div role="navigation" class="ui-grid-pager-container"><div class="ui-grid-pager-control"><button type="button" class="ui-grid-pager-first" ui-grid-one-bind-title="aria.pageToFirst" ui-grid-one-bind-aria-label="aria.pageToFirst" ng-click="pageFirstPageClick()" ng-disabled="cantPageBackward()"><div ng-class="grid.isRTL() ? \'last-triangle\' : \'first-triangle\'"><div ng-class="grid.isRTL() ? \'last-bar-rtl\' : \'first-bar\'"></div></div></button> <button type="button" class="ui-grid-pager-previous" ui-grid-one-bind-title="aria.pageBack" ui-grid-one-bind-aria-label="aria.pageBack" ng-click="pagePreviousPageClick()" ng-disabled="cantPageBackward()"><div ng-class="grid.isRTL() ? \'last-triangle prev-triangle\' : \'first-triangle prev-triangle\'"></div></button> <input type="number" ui-grid-one-bind-title="aria.pageSelected" ui-grid-one-bind-aria-label="aria.pageSelected" class="ui-grid-pager-control-input" ng-model="grid.options.paginationCurrentPage" min="1" max="{{ paginationApi.getTotalPages() }}" step="1" required> <span class="ui-grid-pager-max-pages-number" ng-show="paginationApi.getTotalPages() > 0"><abbr ui-grid-one-bind-title="paginationOf">/ </abbr>{{ paginationApi.getTotalPages() }} </span><button type="button" class="ui-grid-pager-next" ui-grid-one-bind-title="aria.pageForward" ui-grid-one-bind-aria-label="aria.pageForward" ng-click="pageNextPageClick()" ng-disabled="cantPageForward()"><div ng-class="grid.isRTL() ? \'first-triangle next-triangle\' : \'last-triangle next-triangle\'"></div></button> <button type="button" class="ui-grid-pager-last" ui-grid-one-bind-title="aria.pageToLast" ui-grid-one-bind-aria-label="aria.pageToLast" ng-click="pageLastPageClick()" ng-disabled="cantPageToLast()"><div ng-class="grid.isRTL() ? \'first-triangle\' : \'last-triangle\'"><div ng-class="grid.isRTL() ? \'first-bar-rtl\' : \'last-bar\'"></div></div></button></div><div class="ui-grid-pager-row-count-picker" ng-if="grid.options.paginationPageSizes.length > 1 && !grid.options.useCustomPagination"><select ui-grid-one-bind-aria-labelledby-grid="\'items-per-page-label\'" ng-model="grid.options.paginationPageSize" ng-options="o as o for o in grid.options.paginationPageSizes"></select> <span ui-grid-one-bind-id-grid="\'items-per-page-label\'" class="ui-grid-pager-row-count-label">&nbsp;{{sizesLabel}}</span></div><span ng-if="grid.options.paginationPageSizes.length <= 1" class="ui-grid-pager-row-count-label">{{grid.options.paginationPageSize}}&nbsp;{{sizesLabel}}</span></div><div class="ui-grid-pager-count-container"><div class="ui-grid-pager-count"><span ng-show="grid.options.totalItems > 0">{{ 1 + paginationApi.getFirstRowIndex() }} <abbr ui-grid-one-bind-title="paginationThrough">- </abbr>{{ 1 + paginationApi.getLastRowIndex() }} {{paginationOf}} {{grid.options.totalItems}} {{totalItemsLabel}}</span></div></div></div>'),e.put("ui-grid/columnResizer",'<div ui-grid-column-resizer ng-if="grid.options.enableColumnResizing" class="ui-grid-column-resizer" col="col" position="right" render-index="renderIndex" unselectable="on"></div>'),e.put("ui-grid/gridFooterSelectedItems",'<span ng-if="grid.selection.selectedCount !== 0 && grid.options.enableFooterTotalSelected">({{"search.selectedItems" | t}} {{grid.selection.selectedCount}})</span>'),e.put("ui-grid/selectionHeaderCell",'<div>\x3c!-- <div class="ui-grid-vertical-bar">&nbsp;</div> --\x3e<div class="ui-grid-cell-contents" col-index="renderIndex"><ui-grid-selection-select-all-buttons ng-if="grid.options.enableSelectAll" role="checkbox" ng-model="grid.selection.selectAll"></ui-grid-selection-select-all-buttons></div></div>'),e.put("ui-grid/selectionRowHeader",'<div class="ui-grid-cell-contents ui-grid-disable-selection clickable"><ui-grid-selection-row-header-buttons></ui-grid-selection-row-header-buttons></div>'),e.put("ui-grid/selectionRowHeaderButtons",'<div class="ui-grid-selection-row-header-buttons ui-grid-icon-ok clickable" ng-class="{\'ui-grid-row-selected\': row.isSelected}" tabindex="0" ng-click="selectButtonClick(row, $event)" ng-keydown="selectButtonKeyDown(row, $event)" ng-attr-aria-label="{{(\'selection.aria.row\' | t) + \' \' + (row.index + 1) + \', \' + col.displayName}}" aria-checked="{{row.isSelected}}" role="checkbox" ng-model="row.isSelected">&nbsp;</div>'),e.put("ui-grid/selectionSelectAllButtons",'<div role="checkbox" tabindex="0" class="ui-grid-selection-row-header-buttons ui-grid-icon-ok" ui-grid-one-bind-aria-label="\'selection.selectAll\' | t" aria-checked="{{grid.selection.selectAll}}" ng-class="{\'ui-grid-all-selected\': grid.selection.selectAll}" ng-click="headerButtonClick($event)" ng-keydown="headerButtonKeyDown($event)"></div>'),e.put("ui-grid/treeBaseExpandAllButtons",'<div class="ui-grid-tree-base-row-header-buttons" tabindex="0" ng-class="headerButtonClass()" ng-click="headerButtonClick($event)" ng-keydown="headerButtonKeyDown($event)"></div>'),e.put("ui-grid/treeBaseHeaderCell",'<div><div class="ui-grid-cell-contents" col-index="renderIndex"><ui-grid-tree-base-expand-all-buttons ng-if="grid.options.enableExpandAll"></ui-grid-tree-base-expand-all-buttons></div></div>'),e.put("ui-grid/treeBaseRowHeader",'<div class="ui-grid-cell-contents"><ui-grid-tree-base-row-header-buttons></ui-grid-tree-base-row-header-buttons></div>'),e.put("ui-grid/treeBaseRowHeaderButtons",'<div class="ui-grid-tree-base-row-header-buttons" ng-class="{\'ui-grid-tree-base-header\': row.treeLevel > -1 }" tabindex="0" ng-keydown="treeButtonKeyDown(row, $event)" ng-click="treeButtonClick(row, $event)"><i ng-class="treeButtonClass(row)" ng-style="{\'padding-left\': grid.options.treeIndent * row.treeLevel + \'px\'}"></i> &nbsp;</div>'),e.put("ui-grid/cellTitleValidator",'<div class="ui-grid-cell-contents" ng-class="{invalid:grid.validate.isInvalid(row.entity,col.colDef)}" title="{{grid.validate.getTitleFormattedErrors(row.entity,col.colDef)}}">{{COL_FIELD CUSTOM_FILTERS}}</div>'),e.put("ui-grid/cellTooltipValidator",'<div class="ui-grid-cell-contents" ng-class="{invalid:grid.validate.isInvalid(row.entity,col.colDef)}" tooltip-html-unsafe="{{grid.validate.getFormattedErrors(row.entity,col.colDef)}}" tooltip-enable="grid.validate.isInvalid(row.entity,col.colDef)" tooltip-append-to-body="true" tooltip-placement="top" title="TOOLTIP">{{COL_FIELD CUSTOM_FILTERS}}</div>')}]);