/*!
 * ui-grid - v4.12.7 - 2024-04-12
* http://ui-grid.info/
 * Copyright (c) 2024 ; License: MIT 
 */
!function(){"use strict";var i=angular.module("ui.grid.pagination",["ng","ui.grid"]);i.service("uiGridPaginationService",["gridUtil",function(a){var i={initializeGrid:function(e){i.defaultGridOptions(e.options);var o={events:{pagination:{paginationChanged:function(i,a){}}},methods:{pagination:{getPage:function(){return e.options.enablePagination?e.options.paginationCurrentPage:null},getFirstRowIndex:function(){return e.options.useCustomPagination?e.options.paginationPageSizes.reduce(function(i,a,n){return n<e.options.paginationCurrentPage-1?i+a:i},0):(e.options.paginationCurrentPage-1)*e.options.paginationPageSize},getLastRowIndex:function(){return e.options.useCustomPagination?o.methods.pagination.getFirstRowIndex()+e.options.paginationPageSizes[e.options.paginationCurrentPage-1]-1:Math.min(e.options.paginationCurrentPage*e.options.paginationPageSize,e.options.totalItems)-1},getTotalPages:function(){return e.options.enablePagination?e.options.useCustomPagination?e.options.paginationPageSizes.length:0===e.options.totalItems?1:Math.ceil(e.options.totalItems/e.options.paginationPageSize):null},nextPage:function(){e.options.enablePagination&&(0<e.options.totalItems?e.options.paginationCurrentPage=Math.min(e.options.paginationCurrentPage+1,o.methods.pagination.getTotalPages()):e.options.paginationCurrentPage++)},previousPage:function(){e.options.enablePagination&&(e.options.paginationCurrentPage=Math.max(e.options.paginationCurrentPage-1,1))},seek:function(i){if(e.options.enablePagination){if(!angular.isNumber(i)||i<1)throw"Invalid page number: "+i;e.options.paginationCurrentPage=Math.min(i,o.methods.pagination.getTotalPages())}}}}};e.api.registerEventsFromObject(o.events),e.api.registerMethodsFromObject(o.methods);e.registerRowsProcessor(function(i){var a,n,t;return e.options.useExternalPagination||!e.options.enablePagination?i:(a=parseInt(e.options.paginationPageSize,10),parseInt(e.options.paginationCurrentPage,10),i=i.filter(function(i){return i.visible}),e.options.totalItems=i.length,n=o.methods.pagination.getFirstRowIndex(),t=o.methods.pagination.getLastRowIndex(),n>i.length&&(e.options.paginationCurrentPage=1,n=0*a),i.slice(n,t+1))},900)},defaultGridOptions:function(i){i.enablePagination=!1!==i.enablePagination,i.enablePaginationControls=!1!==i.enablePaginationControls,i.useExternalPagination=!0===i.useExternalPagination,i.useCustomPagination=!0===i.useCustomPagination,a.isNullOrUndefined(i.totalItems)&&(i.totalItems=0),a.isNullOrUndefined(i.paginationPageSizes)&&(i.paginationPageSizes=[250,500,1e3]),a.isNullOrUndefined(i.paginationPageSize)&&(0<i.paginationPageSizes.length?i.paginationPageSize=i.paginationPageSizes[0]:i.paginationPageSize=0),a.isNullOrUndefined(i.paginationCurrentPage)&&(i.paginationCurrentPage=1),a.isNullOrUndefined(i.paginationTemplate)&&(i.paginationTemplate="ui-grid/pagination")},onPaginationChanged:function(i,a,n){i.api.pagination.raise.paginationChanged(a,n),i.options.useExternalPagination||i.queueGridRefresh()}};return i}]),i.directive("uiGridPagination",["gridUtil","uiGridPaginationService",function(e,o){return{priority:-200,scope:!1,require:"uiGrid",link:{pre:function(i,a,n,t){o.initializeGrid(t.grid),e.getTemplate(t.grid.options.paginationTemplate).then(function(i){i=angular.element(i);a.append(i),t.innerCompile(i)})}}}}]),i.directive("uiGridPager",["uiGridPaginationService","uiGridConstants","gridUtil","i18nService","i18nConstants",function(p,l,u,d,c){return{priority:-200,scope:!0,require:"^uiGrid",link:function(n,a,i,t){function e(){n.paginationApi=t.grid.api.pagination,n.sizesLabel=d.getSafeText("pagination.sizes"),n.totalItemsLabel=d.getSafeText("pagination.totalItems"),n.paginationOf=d.getSafeText("pagination.of"),n.paginationThrough=d.getSafeText("pagination.through")}n.aria=d.getSafeText("pagination.aria");function o(i){i&&u.focus.bySelector(a,".ui-grid-pager-control-input")}e(),n.$on(c.UPDATE_EVENT,e);var g=t.grid.options,r=(t.grid.renderContainers.body.registerViewportAdjuster(function(i){return g.enablePaginationControls&&(i.height=i.height-u.elementHeight(a,"padding")),i}),t.grid.registerDataChangeCallback(function(i){i.options.useExternalPagination||(i.options.totalItems=i.rows.length)},[l.dataChange.ROW])),s=(n.$on("$destroy",r),n.$watch("grid.options.paginationCurrentPage + grid.options.paginationPageSize",function(i,a){i!==a&&void 0!==a&&(!angular.isNumber(g.paginationCurrentPage)||g.paginationCurrentPage<1?g.paginationCurrentPage=1:0<g.totalItems&&g.paginationCurrentPage>n.paginationApi.getTotalPages()?g.paginationCurrentPage=n.paginationApi.getTotalPages():p.onPaginationChanged(n.grid,g.paginationCurrentPage,g.paginationPageSize))}));n.$on("$destroy",function(){s()}),n.cantPageForward=function(){return n.paginationApi.getTotalPages()?n.cantPageToLast():g.data.length<1},n.cantPageToLast=function(){var i=n.paginationApi.getTotalPages();return!i||g.paginationCurrentPage>=i},n.cantPageBackward=function(){return g.paginationCurrentPage<=1};n.pageFirstPageClick=function(){n.paginationApi.seek(1),o(n.cantPageBackward())},n.pagePreviousPageClick=function(){n.paginationApi.previousPage(),o(n.cantPageBackward())},n.pageNextPageClick=function(){n.paginationApi.nextPage(),o(n.cantPageForward())},n.pageLastPageClick=function(){n.paginationApi.seek(n.paginationApi.getTotalPages()),o(n.cantPageToLast())}}}}])}(),angular.module("ui.grid.pagination").run(["$templateCache",function(i){"use strict";i.put("ui-grid/pagination",'<div class="ui-grid-pager-panel" ui-grid-pager ng-show="grid.options.enablePaginationControls"><div role="navigation" class="ui-grid-pager-container"><div class="ui-grid-pager-control"><button type="button" class="ui-grid-pager-first" ui-grid-one-bind-title="aria.pageToFirst" ui-grid-one-bind-aria-label="aria.pageToFirst" ng-click="pageFirstPageClick()" ng-disabled="cantPageBackward()"><div ng-class="grid.isRTL() ? \'last-triangle\' : \'first-triangle\'"><div ng-class="grid.isRTL() ? \'last-bar-rtl\' : \'first-bar\'"></div></div></button> <button type="button" class="ui-grid-pager-previous" ui-grid-one-bind-title="aria.pageBack" ui-grid-one-bind-aria-label="aria.pageBack" ng-click="pagePreviousPageClick()" ng-disabled="cantPageBackward()"><div ng-class="grid.isRTL() ? \'last-triangle prev-triangle\' : \'first-triangle prev-triangle\'"></div></button> <input type="number" ui-grid-one-bind-title="aria.pageSelected" ui-grid-one-bind-aria-label="aria.pageSelected" class="ui-grid-pager-control-input" ng-model="grid.options.paginationCurrentPage" min="1" max="{{ paginationApi.getTotalPages() }}" step="1" required> <span class="ui-grid-pager-max-pages-number" ng-show="paginationApi.getTotalPages() > 0"><abbr ui-grid-one-bind-title="paginationOf">/ </abbr>{{ paginationApi.getTotalPages() }} </span><button type="button" class="ui-grid-pager-next" ui-grid-one-bind-title="aria.pageForward" ui-grid-one-bind-aria-label="aria.pageForward" ng-click="pageNextPageClick()" ng-disabled="cantPageForward()"><div ng-class="grid.isRTL() ? \'first-triangle next-triangle\' : \'last-triangle next-triangle\'"></div></button> <button type="button" class="ui-grid-pager-last" ui-grid-one-bind-title="aria.pageToLast" ui-grid-one-bind-aria-label="aria.pageToLast" ng-click="pageLastPageClick()" ng-disabled="cantPageToLast()"><div ng-class="grid.isRTL() ? \'first-triangle\' : \'last-triangle\'"><div ng-class="grid.isRTL() ? \'first-bar-rtl\' : \'last-bar\'"></div></div></button></div><div class="ui-grid-pager-row-count-picker" ng-if="grid.options.paginationPageSizes.length > 1 && !grid.options.useCustomPagination"><select ui-grid-one-bind-aria-labelledby-grid="\'items-per-page-label\'" ng-model="grid.options.paginationPageSize" ng-options="o as o for o in grid.options.paginationPageSizes"></select> <span ui-grid-one-bind-id-grid="\'items-per-page-label\'" class="ui-grid-pager-row-count-label">&nbsp;{{sizesLabel}}</span></div><span ng-if="grid.options.paginationPageSizes.length <= 1" class="ui-grid-pager-row-count-label">{{grid.options.paginationPageSize}}&nbsp;{{sizesLabel}}</span></div><div class="ui-grid-pager-count-container"><div class="ui-grid-pager-count"><span ng-show="grid.options.totalItems > 0">{{ 1 + paginationApi.getFirstRowIndex() }} <abbr ui-grid-one-bind-title="paginationThrough">- </abbr>{{ 1 + paginationApi.getLastRowIndex() }} {{paginationOf}} {{grid.options.totalItems}} {{totalItemsLabel}}</span></div></div></div>')}]);