# This file was generated by the `rspec --init` command. Conventionally, all
# specs live under a `spec` directory, which RSpec adds to the `$LOAD_PATH`.
# Require this file using `require "spec_helper.rb"` to ensure that it is only
# loaded once.
#
# See http://rubydoc.info/gems/rspec-core/RSpec/Core/Configuration
RSpec.configure do |config|
  config.treat_symbols_as_metadata_keys_with_true_values = true
  config.run_all_when_everything_filtered = true
  config.filter_run :focus
end

require 'awesome_print'
require 'tmpdir'
require 'nokogiri'

def project_root
  File.join(File.expand_path(File.dirname(__FILE__)), '..')
end

require "#{project_root}/tasks/jasmine_dev"

def capture_output(capture = true)
  if capture
    output = StringIO.new
    $stdout = output
  end
  yield
  if capture
    output.string
  end
ensure
  $stdout = STDOUT
end

def reset_dir(dir)
  FileUtils.rm_r dir if File.exists?(dir)
  FileUtils.mkdir_p dir
end

def jasmine_version
  version = jasmine_version_object

  version_string = "#{version['major']}.#{version['minor']}.#{version['build']}"
  version_string += ".rc#{version['release_candidate']}" if version['release_candidate']
  version_string
end

def jasmine_version_object
  @version_object ||= JSON.parse(File.read(File.join(JasmineDev.project_root, 'src', 'version.json')))
end