// Type definitions for Dojo v1.9
// Project: http://dojotoolkit.org
// Definitions by: Michael Van Sickle <https://github.com/vansimke>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

/// <reference path="./dojo.d.ts" />

declare module dijit {
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_BidiSupport.html
     *
     * Deprecated module for enabling textdir support in the dijit widgets.   New code should just define
     * has("dojo-bidi") to return true, rather than manually requiring this module.
     * 
     */
    interface _BidiSupport{(): void}
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/BackgroundIframe.html
     *
     * For IE/FF z-index shenanigans. id attribute is required.
     * new dijit.BackgroundIframe(node).
     * 
     * Makes a background iframe as a child of node, that fills
     * area (and position) of node
     * 
     * @param node     
     */
    interface BackgroundIframe{(node: HTMLElement): void}
    module BackgroundIframe {
        /**
         * destroy the iframe
         * 
         */
        interface destroy{(): void}
        /**
         * Resize the iframe so it's the same size as node.
         * Needed on IE6 and IE/quirks because height:100% doesn't work right.
         * 
         * @param node             
         */
        interface resize{(node: any): void}
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/hccss.html
     *
     * Test if computer is in high contrast mode, and sets dijit_a11y flag on <body> if it is.
     * Deprecated, use dojo/hccss instead.
     * 
     */
    interface hccss{(): void}
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_AttachMixin.html
     *
     * Mixin for widgets to attach to dom nodes and setup events via
     * convenient data-dojo-attach-point and data-dojo-attach-event DOM attributes.
     * 
     * Superclass of _TemplatedMixin, and can also be used standalone when templates are pre-rendered on the
     * server.
     * 
     * Does not [yet] handle widgets like ContentPane with this.containerNode set.   It should skip
     * scanning for data-dojo-attach-point and data-dojo-attach-event inside this.containerNode, but it
     * doesn't.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree.     
     */
    class _AttachMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        /**
         * Search descendants of this.containerNode for data-dojo-attach-point and data-dojo-attach-event.
         * Should generally be left false (the default value) both for performance and to avoid failures when
         * this.containerNode holds other _AttachMixin instances with their own attach points and events.
         * 
         */
        "searchContainerNode": boolean;
        /**
         * Attach to DOM nodes marked with special attributes.
         * 
         */
        buildRendering(): void;
        /**
         * 
         */
        destroyRendering(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_Container.html
     *
     * Mixin for widgets that contain HTML and/or a set of widget children.
     * 
     */
    class _Container {
        constructor();
        /**
         * Makes the given widget a child of this widget.
         * Inserts specified child widget's dom node as a child of this widget's
         * container node, and possibly does other processing (such as layout).
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex?: number): void;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;

    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_Contained.html
     *
     * Mixin for widgets that are children of a container widget
     * 
     */
    class _Contained {
        constructor();
        /**
         * Returns the index of this widget within its container parent.
         * It returns -1 if the parent does not exist, or if the parent
         * is not a dijit/_Container
         * 
         */
        getIndexInParent(): any;
        /**
         * Returns null if this is the last child of the parent,
         * otherwise returns the next element sibling to the "right".
         * 
         */
        getNextSibling(): any;
        /**
         * Returns null if this is the first child of the parent,
         * otherwise returns the next element sibling to the "left".
         * 
         */
        getPreviousSibling(): any;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_DialogMixin.html
     *
     * This provides functions useful to Dialog and TooltipDialog
     * 
     */
    class _DialogMixin {
        constructor();
        /**
         * Callback when the user hits the submit button.
         * Override this method to handle Dialog execution.
         * After the user has pressed the submit button, the Dialog
         * first calls onExecute() to notify the container to hide the
         * dialog and restore focus to wherever it used to be.
         * 
         * Then this method is called.
         * 
         * @param formContents             
         */
        execute(formContents: Object): void;
        /**
         * Called when user has pressed the Dialog's cancel button, to notify container.
         * Developer shouldn't override or connect to this method;
         * it's a private communication device between the TooltipDialog
         * and the thing that opened it (ex: dijit/form/DropDownButton)
         * 
         */
        onCancel(): void;
        /**
         * Called when user has pressed the dialog's OK button, to notify container.
         * Developer shouldn't override or connect to this method;
         * it's a private communication device between the TooltipDialog
         * and the thing that opened it (ex: dijit/form/DropDownButton)
         * 
         */
        onExecute(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_CssStateMixin.html
     *
     * Mixin for widgets to set CSS classes on the widget DOM nodes depending on hover/mouse press/focus
     * state changes, and also higher-level state changes such becoming disabled or selected.
     * By mixing this class into your widget, and setting the this.baseClass attribute, it will automatically
     * maintain CSS classes on the widget root node (this.domNode) depending on hover,
     * active, focus, etc. state.   Ex: with a baseClass of dijitButton, it will apply the classes
     * dijitButtonHovered and dijitButtonActive, as the user moves the mouse over the widget and clicks it.
     * 
     * It also sets CSS like dijitButtonDisabled based on widget semantic state.
     * 
     * By setting the cssStateNodes attribute, a widget can also track events on subnodes (like buttons
     * within the widget).
     * 
     */
    class _CssStateMixin {
        constructor();
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_FocusMixin.html
     *
     * Mixin to widget to provide _onFocus() and _onBlur() methods that
     * fire when a widget or its descendants get/lose focus
     * 
     */
    class _FocusMixin {
        constructor();
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_HasDropDown.html
     *
     * Mixin for widgets that need drop down ability.
     * 
     */
    class _HasDropDown extends dijit._FocusMixin {
        constructor();
        /**
         * Set to true to make the drop down at least as wide as this
         * widget.  Set to false if the drop down should just be its
         * default width.
         * 
         */
        "autoWidth": boolean;
        /**
         * The widget to display as a popup.  This widget must be
         * defined before the startup function is called.
         * 
         */
        "dropDown": Object;
        /**
         * This variable controls the position of the drop down.
         * It's an array of strings with the following values:
         * 
         * before: places drop down to the left of the target node/widget, or to the right in
         * the case of RTL scripts like Hebrew and Arabic
         * after: places drop down to the right of the target node/widget, or to the left in
         * the case of RTL scripts like Hebrew and Arabic
         * above: drop down goes above target node
         * below: drop down goes below target node
         * The list is positions is tried, in order, until a position is found where the drop down fits
         * within the viewport.
         * 
         */
        "dropDownPosition": Object;
        /**
         * Set to true to make the drop down exactly as wide as this
         * widget.  Overrides autoWidth.
         * 
         */
        "forceWidth": boolean;
        /**
         * The max height for our dropdown.
         * Any dropdown taller than this will have scrollbars.
         * Set to 0 for no max height, or -1 to limit height to available space in viewport
         * 
         */
        "maxHeight": number;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Closes the drop down on this widget
         * 
         * @param focus If true, refocuses the button widget             
         */
        closeDropDown(focus: boolean): void;
        /**
         * 
         */
        destroy(): void;
        /**
         * Returns true if the dropdown exists and it's data is loaded.  This can
         * be overridden in order to force a call to loadDropDown().
         * 
         */
        isLoaded(): boolean;
        /**
         * Creates the drop down if it doesn't exist, loads the data
         * if there's an href and it hasn't been loaded yet, and
         * then opens the drop down.  This is basically a callback when the
         * user presses the down arrow button to open the drop down.
         * 
         */
        loadAndOpenDropDown(): any;
        /**
         * Creates the drop down if it doesn't exist, loads the data
         * if there's an href and it hasn't been loaded yet, and then calls
         * the given callback.
         * 
         * @param loadCallback             
         */
        loadDropDown(loadCallback: Function): void;
        /**
         * Opens the dropdown for this widget.   To be called only when this.dropDown
         * has been created and is ready to display (ie, it's data is loaded).
         * 
         */
        openDropDown(): any;
        /**
         * set up nodes and connect our mouse and keyboard events
         * 
         */
        postCreate(): void;
        /**
         * Callback when the user presses the down arrow button or presses
         * the down arrow key to open/close the drop down.
         * Toggle the drop-down widget; if it is up, close it, if not, open it
         * 
         */
        toggleDropDown(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_KeyNavMixin.html
     *
     * A mixin to allow arrow key and letter key navigation of child or descendant widgets.
     * It can be used by dijit/_Container based widgets with a flat list of children,
     * or more complex widgets like dijit/Tree.
     * 
     * To use this mixin, the subclass must:
     * 
     * - Implement  _getNext(), _getFirst(), _getLast(), _onLeftArrow(), _onRightArrow()
     *   _onDownArrow(), _onUpArrow() methods to handle home/end/left/right/up/down keystrokes.
     *   Next and previous in this context refer to a linear ordering of the descendants used
     *   by letter key search.
     * - Set all descendants' initial tabIndex to "-1"; both initial descendants and any
     *   descendants added later, by for example addChild()
     * - Define childSelector to a function or string that identifies focusable descendant widgets
     * Also, child widgets must implement a focus() method.
     * 
     */
    class _KeyNavMixin extends dijit._FocusMixin {
        constructor();
        /**
         * Selector (passed to on.selector()) used to identify what to treat as a child widget.   Used to monitor
         * focus events and set this.focusedChild.   Must be set by implementing class.   If this is a string
         * (ex: "> *") then the implementing class must require dojo/query.
         * 
         */
        "childSelector": any;
        /**
         * The currently focused child widget, or null if there isn't one
         * 
         */
        "focusedChild": Object;
        /**
         * If multiple characters are typed where each keystroke happens within
         * multiCharSearchDuration of the previous keystroke,
         * search for nodes matching all the keystrokes.
         * 
         * For example, typing "ab" will search for entries starting with
         * "ab" unless the delay between "a" and "b" is greater than multiCharSearchDuration.
         * 
         */
        "multiCharSearchDuration": number;
        /**
         * Tab index of the container; same as HTML tabIndex attribute.
         * Note then when user tabs into the container, focus is immediately
         * moved to the first item in the container.
         * 
         */
        "tabIndex": string;
        /**
         * Default focus() implementation: focus the first child.
         * 
         */
        focus(): void;
        /**
         * Focus specified child widget.
         * 
         * @param widget Reference to container's child widget             
         * @param last If true and if widget has multiple focusable nodes, focus thelast one instead of the first one             
         */
        focusChild(widget: dijit._WidgetBase, last: boolean): void;
        /**
         * Focus the first focusable child in the container.
         * 
         */
        focusFirstChild(): void;
        /**
         * Focus the last focusable child in the container.
         * 
         */
        focusLastChild(): void;
        /**
         * 
         */
        postCreate(): void;
        /**
         * When a key is pressed that matches a child item,
         * this method is called so that a widget can take appropriate action is necessary.
         * 
         * @param item             
         * @param evt             
         * @param searchString             
         * @param numMatches             
         */
        onKeyboardSearch(item: dijit._WidgetBase, evt: Event, searchString: String, numMatches: number): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_KeyNavContainer.html
     *
     * A _Container with keyboard navigation of its children.
     * Provides normalized keyboard and focusing code for Container widgets.
     * To use this mixin, call connectKeyNavHandlers() in postCreate().
     * Also, child widgets must implement a focus() method.
     * 
     */
    class _KeyNavContainer extends dijit._FocusMixin implements dijit._KeyNavMixin, dijit._Container {
        constructor();
        /**
         * The currently focused child widget, or null if there isn't one
         * 
         */
        "focusedChild": Object;
        /**
         * If multiple characters are typed where each keystroke happens within
         * multiCharSearchDuration of the previous keystroke,
         * search for nodes matching all the keystrokes.
         * 
         * For example, typing "ab" will search for entries starting with
         * "ab" unless the delay between "a" and "b" is greater than multiCharSearchDuration.
         * 
         */
        "multiCharSearchDuration": number;
        /**
         * Tab index of the container; same as HTML tabIndex attribute.
         * Note then when user tabs into the container, focus is immediately
         * moved to the first item in the container.
         * 
         */
        "tabIndex": string;
        /**
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex: number): void;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * 
         * @param node             
         */
        childSelector(node: HTMLElement): any;
        /**
         * Deprecated.  You can call this in postCreate() to attach the keyboard handlers to the container,
         * but the preferred method is to override _onLeftArrow() and _onRightArrow(), or
         * _onUpArrow() and _onDownArrow(), to call focusPrev() and focusNext().
         * 
         * @param prevKeyCodes Key codes for navigating to the previous child.             
         * @param nextKeyCodes Key codes for navigating to the next child.             
         */
        connectKeyNavHandlers(prevKeyCodes: dojo.keys, nextKeyCodes: dojo.keys): void;
        /**
         * Default focus() implementation: focus the first child.
         * 
         */
        focus(): void;
        /**
         * Focus specified child widget.
         * 
         * @param widget Reference to container's child widget             
         * @param last If true and if widget has multiple focusable nodes, focus thelast one instead of the first one             
         */
        focusChild(widget: dijit._WidgetBase, last: boolean): void;
        /**
         * Focus the first focusable child in the container.
         * 
         */
        focusFirstChild(): void;
        /**
         * Focus the last focusable child in the container.
         * 
         */
        focusLastChild(): void;
        /**
         * Focus the next widget
         * 
         */
        focusNext(): void;
        /**
         * Focus the last focusable node in the previous widget
         * (ex: go to the ComboButton icon section rather than button section)
         * 
         */
        focusPrev(): void;
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;
        /**
         * 
         */
        startup(): void;
        /**
         * 
         */
        startupKeyNavChildren(): void;
        /**
         * When a key is pressed that matches a child item,
         * this method is called so that a widget can take appropriate action is necessary.
         * 
         * @param item             
         * @param evt             
         * @param searchString             
         * @param numMatches             
         */
        onKeyboardSearch(item: dijit._WidgetBase, evt: Event, searchString: String, numMatches: number): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_OnDijitClickMixin.html
     *
     * Deprecated.   New code should access the dijit/a11yclick event directly, ex:
     * 
     * this.own(on(node, a11yclick, function(){ ... }));
     * Mixing in this class will make _WidgetBase.connect(node, "ondijitclick", ...) work.
     * It also used to be necessary to make templates with ondijitclick work, but now you can just require
     * dijit/a11yclick.
     * 
     */
    class _OnDijitClickMixin {
        constructor();
        /**
         * Custom press, release, and click synthetic events
         * which trigger on a left mouse click, touch, or space/enter keyup.
         * 
         */
        "a11yclick": Object;
        /**
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: any, method: any): any;
    }
    module _OnDijitClickMixin {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/_OnDijitClickMixin.a11yclick.html
         *
         * Custom press, release, and click synthetic events
         * which trigger on a left mouse click, touch, or space/enter keyup.
         * 
         */
        interface a11yclick {
            /**
             * Logical click operation for mouse, touch, or keyboard (space/enter key)
             * 
             * @param node             
             * @param listener             
             */
            click(node: any, listener: any): void;
            /**
             * Mouse cursor or a finger is dragged over the given node.
             * 
             * @param node             
             * @param listener             
             */
            move(node: any, listener: any): void;
            /**
             * Mousedown (left button), touchstart, or keydown (space or enter) corresponding to logical click operation.
             * 
             * @param node             
             * @param listener             
             */
            press(node: any, listener: any): void;
            /**
             * Mouseup (left button), touchend, or keyup (space or enter) corresponding to logical click operation.
             * 
             * @param node             
             * @param listener             
             */
            release(node: any, listener: any): void;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_PaletteMixin.html
     *
     * A keyboard accessible palette, for picking a color/emoticon/etc.
     * A mixin for a grid showing various entities, so the user can pick a certain entity.
     * 
     */
    class _PaletteMixin extends dijit._CssStateMixin {
        constructor();
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        /**
         * CSS class applied to each cell in the palette
         * 
         */
        "cellClass": string;
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        /**
         * Number of milliseconds before a held key or button becomes typematic
         * 
         */
        "defaultTimeout": number;
        /**
         * Constructor for Object created for each cell of the palette.
         * dyeClass should implement the dijit/_PaletteMixin.__Dye interface.
         * 
         */
        "dyeClass": Object;
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        /**
         * Widget tab index.
         * 
         */
        "tabIndex": string;
        /**
         * Fraction of time used to change the typematic timer between events
         * 1.0 means that each typematic event fires at defaultTimeout intervals
         * Less than 1.0 means that each typematic event fires at an increasing faster rate
         * 
         */
        "timeoutChangeRate": number;
        /**
         * Currently selected color/emoticon/etc.
         * 
         */
        "value": string;
        /**
         * Focus this widget.  Puts focus on the most recently focused cell.
         * 
         */
        focus(): void;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Callback when a cell is selected.
         * 
         * @param value Value corresponding to cell.             
         */
        onChange(value: String): void;
    }
    module _PaletteMixin {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/_PaletteMixin.__Dye.html
         *
         * Interface for the JS Object associated with a palette cell (i.e. DOMNode)
         * 
         * @param alias     
         * @param row     
         * @param col     
         */
        class __Dye {
            constructor(alias: String, row: any, col: any);
            /**
             * Add cell DOMNode inner structure
             * 
             * @param cell The surrounding cell             
             * @param blankGif URL for blank cell image             
             */
            fillCell(cell: HTMLElement, blankGif: String): void;
            /**
             * Return "value" of cell; meaning of "value" varies by subclass.
             * For example color hex value, emoticon ascii value etc, entity hex value.
             * 
             */
            getValue(): void;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_TemplatedMixin.html
     *
     * Mixin for widgets that are instantiated from a template
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree.     
     */
    class _TemplatedMixin extends dijit._AttachMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        /**
         * 
         */
        "searchContainerNode": boolean;
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        /**
         * A string that represents the widget template.
         * Use in conjunction with dojo.cache() to load from a file.
         * 
         */
        "templateString": string;
        /**
         * Construct the UI for this widget from a template, setting this.domNode.
         * 
         */
        buildRendering(): void;
        /**
         * 
         */
        destroyRendering(): void;
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         * 
         * @param templateString The template             
         * @param alwaysUseString Don't cache the DOM tree for this template, even if it doesn't have any variables             
         * @param doc               OptionalThe target document.   Defaults to document global if unspecified.             
         */
        getCachedTemplate(templateString: String, alwaysUseString: boolean, doc: HTMLDocument): any;
    }
    module _TemplatedMixin {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/_TemplatedMixin._templateCache.html
         *
         * 
         */
        interface _templateCache {
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_Templated.html
     *
     * Deprecated mixin for widgets that are instantiated from a template.
     * Widgets should use _TemplatedMixin plus if necessary _WidgetsInTemplateMixin instead.
     * 
     */
    class _Templated extends dijit._TemplatedMixin implements dijit._WidgetsInTemplateMixin {
        constructor();
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        /**
         * Used to provide a context require to the dojo/parser in order to be
         * able to use relative MIDs (e.g. ./Widget) in the widget's template.
         * 
         */
        "contextRequire": Function;
        /**
         * 
         */
        "searchContainerNode": boolean;
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        /**
         * A string that represents the widget template.
         * Use in conjunction with dojo.cache() to load from a file.
         * 
         */
        "templateString": string;
        /**
         * Should we parse the template to find widgets that might be
         * declared in markup inside it?  False by default.
         * 
         */
        "widgetsInTemplate": boolean;
        /**
         * Construct the UI for this widget from a template, setting this.domNode.
         * 
         */
        buildRendering(): void;
        /**
         * 
         */
        destroyRendering(): void;
        /**
         * 
         */
        startup(): void;
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_MenuBase.html
     *
     * Abstract base class for Menu and MenuBar.
     * Subclass should implement _onUpArrow(), _onDownArrow(), _onLeftArrow(), and _onRightArrow().
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class _MenuBase extends dijit._Widget implements dijit._TemplatedMixin, dijit._KeyNavContainer, dijit._CssStateMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * This Menu has been clicked (mouse or via space/arrow key) or opened as a submenu,
         * so mere mouseover will open submenus.  Focusing a menu via TAB does NOT automatically make it active
         * since TAB is a navigation operation and not a selection one.
         * For Windows apps, pressing the ALT key focuses the menubar menus (similar to TAB navigation) but the
         * menu is not active (ie no dropdown) until an item is clicked.
         * 
         */
        "activated": boolean;
        set(property:"activated", value: boolean): void;
        get(property:"activated"): boolean;
        watch(property:"activated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * A toggle to control whether or not a Menu gets focused when opened as a drop down from a MenuBar
         * or DropDownButton/ComboButton.   Note though that it always get focused when opened via the keyboard.
         * 
         */
        "autoFocus": boolean;
        set(property:"autoFocus", value: boolean): void;
        get(property:"autoFocus"): boolean;
        watch(property:"autoFocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The currently focused child widget, or null if there isn't one
         * 
         */
        "focusedChild": Object;
        set(property:"focusedChild", value: Object): void;
        get(property:"focusedChild"): Object;
        watch(property:"focusedChild", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * If multiple characters are typed where each keystroke happens within
         * multiCharSearchDuration of the previous keystroke,
         * search for nodes matching all the keystrokes.
         * 
         * For example, typing "ab" will search for entries starting with
         * "ab" unless the delay between "a" and "b" is greater than multiCharSearchDuration.
         * 
         */
        "multiCharSearchDuration": number;
        set(property:"multiCharSearchDuration", value: number): void;
        get(property:"multiCharSearchDuration"): number;
        watch(property:"multiCharSearchDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to menu that displayed me
         * 
         */
        "parentMenu": Object;
        set(property:"parentMenu", value: Object): void;
        get(property:"parentMenu"): Object;
        watch(property:"parentMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * For a passive (unclicked) Menu, number of milliseconds before hovering (without clicking) will cause
         * the popup to open.  Default is Infinity, meaning you need to click the menu to open it.
         * 
         */
        "passivePopupDelay": number;
        set(property:"passivePopupDelay", value: number): void;
        get(property:"passivePopupDelay"): number;
        watch(property:"passivePopupDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * After a menu has been activated (by clicking on it etc.), number of milliseconds before hovering
         * (without clicking) another MenuItem causes that MenuItem's popup to automatically open.
         * 
         */
        "popupDelay": number;
        set(property:"popupDelay", value: number): void;
        get(property:"popupDelay"): number;
        watch(property:"popupDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Currently selected (a.k.a. highlighted) MenuItem, or null if no MenuItem is selected.
         * If a submenu is open, will be set to MenuItem that displayed the submenu.   OTOH, if
         * this Menu is in passive mode (i.e. hasn't been clicked yet), will be null, because
         * "selected" is not merely "hovered".
         * 
         */
        "selected": Object;
        set(property:"selected", value: Object): void;
        get(property:"selected"): Object;
        watch(property:"selected", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Tab index of the container; same as HTML tabIndex attribute.
         * Note then when user tabs into the container, focus is immediately
         * moved to the first item in the container.
         * 
         */
        "tabIndex": string;
        set(property:"tabIndex", value: string): void;
        get(property:"tabIndex"): string;
        watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * A string that represents the widget template.
         * Use in conjunction with dojo.cache() to load from a file.
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex: number): void;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Selector (passed to on.selector()) used to identify MenuItem child widgets, but exclude inert children
         * like MenuSeparator.  If subclass overrides to a string (ex: "> *"), the subclass must require dojo/query.
         * 
         * @param node             
         */
        childSelector(node: HTMLElement): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Deprecated.  You can call this in postCreate() to attach the keyboard handlers to the container,
         * but the preferred method is to override _onLeftArrow() and _onRightArrow(), or
         * _onUpArrow() and _onDownArrow(), to call focusPrev() and focusNext().
         * 
         * @param prevKeyCodes Key codes for navigating to the previous child.             
         * @param nextKeyCodes Key codes for navigating to the next child.             
         */
        connectKeyNavHandlers(prevKeyCodes: dojo.keys, nextKeyCodes: dojo.keys): void;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Default focus() implementation: focus the first child.
         * 
         */
        focus(): void;
        /**
         * Focus specified child widget.
         * 
         * @param widget Reference to container's child widget             
         * @param last If true and if widget has multiple focusable nodes, focus thelast one instead of the first one             
         */
        focusChild(widget: dijit._WidgetBase, last: boolean): void;
        /**
         * Focus the first focusable child in the container.
         * 
         */
        focusFirstChild(): void;
        /**
         * Focus the last focusable child in the container.
         * 
         */
        focusLastChild(): void;
        /**
         * Focus the next widget
         * 
         */
        focusNext(): void;
        /**
         * Focus the last focusable node in the previous widget
         * (ex: go to the ComboButton icon section rather than button section)
         * 
         */
        focusPrev(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * 
         */
        startupKeyNavChildren(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Attach point for notification about when the user cancels the current menu
         * This is an internal mechanism used for Menus to signal to their parent to
         * close them.  In general developers should not attach to or override this method.
         * 
         * @param closeAll             
         */
        onCancel(closeAll: boolean): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Attach point for notification about when a menu item has been executed.
         * This is an internal mechanism used for Menus to signal to their parent to
         * close them, because they are about to execute the onClick handler.  In
         * general developers should not attach to or override this method.
         * 
         */
        onExecute(): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Called when cursor is over a MenuItem.
         * 
         * @param item             
         */
        onItemHover(item: dijit.MenuItem): void;
        /**
         * Callback fires when mouse exits a MenuItem
         * 
         * @param item             
         */
        onItemUnhover(item: dijit.MenuItem): void;
        /**
         * Attach point for notification about when a menu item has been searched for
         * via the keyboard search mechanism.
         * 
         * @param item             
         * @param evt             
         * @param searchString             
         * @param numMatches             
         */
        onKeyboardSearch(item: dijit.MenuItem, evt: Event, searchString: String, numMatches: number): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_WidgetsInTemplateMixin.html
     *
     * Mixin to supplement _TemplatedMixin when template contains widgets
     * 
     */
    class _WidgetsInTemplateMixin {
        constructor();
        /**
         * Used to provide a context require to the dojo/parser in order to be
         * able to use relative MIDs (e.g. ./Widget) in the widget's template.
         * 
         */
        "contextRequire": Function;
        /**
         * Should we parse the template to find widgets that might be
         * declared in markup inside it?  (Remove for 2.0 and assume true)
         * 
         */
        "widgetsInTemplate": boolean;
        /**
         * 
         */
        startup(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_WidgetBase.html
     *
     * Future base class for all Dijit widgets.
     * Future base class for all Dijit widgets.
     * _Widget extends this class adding support for various features needed by desktop.
     * 
     * Provides stubs for widget lifecycle methods for subclasses to extend, like postMixInProperties(), buildRendering(),
     * postCreate(), startup(), and destroy(), and also public API methods like set(), get(), and watch().
     * 
     * Widgets can provide custom setters/getters for widget attributes, which are called automatically by set(name, value).
     * For an attribute XXX, define methods _setXXXAttr() and/or _getXXXAttr().
     * 
     * _setXXXAttr can also be a string/hash/array mapping from a widget attribute XXX to the widget's DOMNodes:
     * 
     * DOM node attribute
     *   _setFocusAttr: {node: "focusNode", type: "attribute"}
     *   _setFocusAttr: "focusNode"  (shorthand)
     *   _setFocusAttr: ""       (shorthand, maps to this.domNode)
     * Maps this.focus to this.focusNode.focus, or (last example) this.domNode.focus
     * 
     * DOM node innerHTML
     *   _setTitleAttr: { node: "titleNode", type: "innerHTML" }
     * Maps this.title to this.titleNode.innerHTML
     * 
     * DOM node innerText
     *   _setTitleAttr: { node: "titleNode", type: "innerText" }
     * Maps this.title to this.titleNode.innerText
     * 
     * DOM node CSS class
     *   _setMyClassAttr: { node: "domNode", type: "class" }
     * Maps this.myClass to this.domNode.className
     * 
     * If the value of _setXXXAttr is an array, then each element in the array matches one of the
     * formats of the above list.
     * 
     * If the custom setter is null, no action is performed other than saving the new value
     * in the widget (in this).
     * 
     * If no custom setter is defined for an attribute, then it will be copied
     * to this.focusNode (if the widget defines a focusNode), or this.domNode otherwise.
     * That's only done though for attributes that match DOMNode attributes (title,
     * alt, aria-labelledby, etc.)
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class _WidgetBase extends dojo.Stateful implements dijit.Destroyable {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": Object;
        set(property:"style", value: Object): void;
        get(property:"style"): Object;
        watch(property:"style", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj?: Object, callbackArgs?: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         */
        isValid: any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: String, func: Function): {remove:{():void}};
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: Function, func: Function): {remove:{():void}};
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(handle:any): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position?: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position?: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position?: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position?: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position?: number): any;
        /**
         * Processing after the DOM fragment is created
         * Called after the DOM fragment has been created, but not necessarily
         * added to the document.  Do not include any operations which rely on
         * node dimensions or placement.
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_Widget.html
     *
     * Old base class for widgets.   New widgets should extend dijit/_WidgetBase instead
     * Old Base class for Dijit widgets.
     * 
     * Extends _WidgetBase, adding support for:
     * 
     * declaratively/programatically specifying widget initialization parameters like
     *   onMouseMove="foo" that call foo when this.domNode gets a mousemove event
     * ondijitclick:
     *   Support new data-dojo-attach-event="ondijitclick: ..." that is triggered by a mouse click or a SPACE/ENTER keypress
     * focus related functions:
     *   In particular, the onFocus()/onBlur() callbacks.   Driven internally by
     *   dijit/_base/focus.js.
     * deprecated methods
     * onShow(), onHide(), onClose()
     * Also, by loading code in dijit/_base, turns on:
     * 
     * browser sniffing (putting browser class like dj_ie on <html> node)
     * high contrast mode sniffing (add dijit_a11y class to <body> if machine is in high contrast mode)
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class _Widget extends dijit._WidgetBase implements dijit._OnDijitClickMixin, dijit._FocusMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Custom press, release, and click synthetic events
         * which trigger on a left mouse click, touch, or space/enter keyup.
         * 
         */
        "a11yclick": Object;
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Defines a type of widget.
         * 
         */
        "dndType": string;
        set(property:"dndType", value: string): void;
        get(property:"dndType"): string;
        watch(property:"dndType", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "observer": string;
        set(property:"observer", value: string): void;
        get(property:"observer"): string;
        watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * A parameter needed by RadioGroupSlide only. An optional paramter to force
         * the ContentPane to slide in from a set direction. Defaults
         * to "random", or specify one of "top", "left", "right", "bottom"
         * to slideFrom top, left, right, or bottom.
         * 
         */
        "slideFrom": string;
        set(property:"slideFrom", value: string): void;
        get(property:"slideFrom"): string;
        watch(property:"slideFrom", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": Object;
        set(property:"style", value: Object): void;
        get(property:"style"): Object;
        watch(property:"style", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/_TimePicker.html
     *
     * A time picker dropdown, used by dijit/form/TimeTextBox.
     * This widget is not available as a standalone widget due to lack of accessibility support.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree     
     */
    class _TimePicker extends dijit._WidgetBase implements dijit.form._ListMouseMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * The root className to use for the various states of this widget
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * ISO-8601 string representing the amount by which
         * every clickable element in the time picker increases.
         * Set in local time, without a time zone.
         * Example: T00:15:00 creates 15 minute increments
         * Must divide dijit/_TimePicker.visibleIncrement evenly
         * 
         */
        "clickableIncrement": string;
        set(property:"clickableIncrement", value: string): void;
        get(property:"clickableIncrement"): string;
        watch(property:"clickableIncrement", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Specifies valid range of times (start time, end time)
         * 
         */
        "constraints": Object;
        set(property:"constraints", value: Object): void;
        get(property:"constraints"): Object;
        watch(property:"constraints", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * The string to filter by
         * 
         */
        "filterString": string;
        set(property:"filterString", value: string): void;
        get(property:"filterString"): string;
        watch(property:"filterString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * currently selected node
         * 
         */
        "selected": HTMLElement;
        set(property:"selected", value: HTMLElement): void;
        get(property:"selected"): HTMLElement;
        watch(property:"selected", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Date to display.
         * Defaults to current time and date.
         * Can be a Date object or an ISO-8601 string.
         * If you specify the GMT time zone (-01:00),
         * the time will be converted to the local time in the local time zone.
         * Otherwise, the time is considered to be in the local time zone.
         * If you specify the date and isDate is true, the date is used.
         * Example: if your local time zone is GMT -05:00,
         * T10:00:00 becomes T10:00:00-05:00 (considered to be local time),
         * T10:00:00-01:00 becomes T06:00:00-05:00 (4 hour difference),
         * T10:00:00Z becomes T05:00:00-05:00 (5 hour difference between Zulu and local time)
         * yyyy-mm-ddThh:mm:ss is the format to set the date and time
         * Example: 2007-06-01T09:00:00
         * 
         */
        "value": string;
        set(property:"value", value: string): void;
        get(property:"value"): string;
        watch(property:"value", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * ISO-8601 string representing the amount by which
         * every element with a visible time in the time picker increases.
         * Set in local time, without a time zone.
         * Example: T01:00:00 creates text in every 1 hour increment
         * 
         */
        "visibleIncrement": string;
        set(property:"visibleIncrement", value: string): void;
        get(property:"visibleIncrement"): string;
        watch(property:"visibleIncrement", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Called from dijit/form/_DateTimeTextBox to pass a keypress event
         * from the dijit/form/TimeTextBox to be handled in this widget
         * 
         * @param e             
         */
        handleKey(e: Event): any;
        /**
         * May be overridden to disable certain dates in the TimePicker e.g. isDisabledDate=locale.isWeekend
         * 
         * @param dateObject             
         * @param locale               Optional            
         */
        isDisabledDate(dateObject: Date, locale: String): boolean;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * Processing after the DOM fragment is created
         * Called after the DOM fragment has been created, but not necessarily
         * added to the document.  Do not include any operations which rely on
         * node dimensions or placement.
         * 
         */
        postCreate(): void;
        /**
         * 
         */
        postMixInProperties(): void;
        /**
         * Select the first displayed item in the list.
         * 
         */
        selectFirstNode(): void;
        /**
         * Select the last displayed item in the list
         * 
         */
        selectLastNode(): void;
        /**
         * Select the item just below the current selection.
         * If nothing selected, select first node.
         * 
         */
        selectNextNode(): void;
        /**
         * Select the item just above the current selection.
         * If nothing selected, select last node (if
         * you select Previous and try to keep scrolling up the list).
         * 
         */
        selectPreviousNode(): void;
        /**
         * Format a Date object as a string according a subset of the ISO-8601 standard
         * When options.selector is omitted, output follows RFC3339
         * The local time zone is included as an offset from GMT, except when selector=='time' (time without a date)
         * Does not check bounds.  Only years between 100 and 9999 are supported.
         * 
         * @param dateObject A Date object             
         * @param options               OptionalAn object with the following properties:selector (String): "date" or "time" for partial formatting of the Date object.Both date and time will be formatted by default.zulu (Boolean): if true, UTC/GMT is used for a timezonemilliseconds (Boolean): if true, output milliseconds            
         */
        serialize(dateObject: Date, options: Object): any;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Used set('value') instead.
         * 
         * @param value             
         */
        setValue(value: Date): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Notification that a time was selected.  It may be the same as the previous value.
         * 
         * @param time             
         */
        onChange(time: Date): void;
        /**
         * 
         * @param node             
         */
        onClick(node: HTMLElement): void;
        /**
         * 
         * @param node             
         */
        onDeselect(node: HTMLElement): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * 
         * @param node             
         */
        onHover(node: HTMLElement): void;
        /**
         * 
         */
        onOpen(): void;
        /**
         * 
         * @param node             
         */
        onSelect(node: HTMLElement): void;
        /**
         * 
         * @param node             
         */
        onUnhover(node: HTMLElement): void;
    }
    module _TimePicker {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/_TimePicker.__Constraints.html
         *
         * 
         */
        class __Constraints {
            constructor();
            /**
             * override strings for am in times
             * 
             */
            "am": string;
            /**
             * See dijit/_TimePicker.clickableIncrement
             * 
             */
            "clickableIncrement": string;
            /**
             * override pattern with this string
             * 
             */
            "datePattern": string;
            /**
             * choice of long, short, medium or full (plus any custom additions).  Defaults to 'short'
             * 
             */
            "formatLength": string;
            /**
             * (format only) use 4 digit years whenever 2 digit years are called for
             * 
             */
            "fullYear": boolean;
            /**
             * override the locale used to determine formatting rules
             * 
             */
            "locale": string;
            /**
             * override strings for pm in times
             * 
             */
            "pm": string;
            /**
             * choice of 'time','date' (default: date and time)
             * 
             */
            "selector": string;
            /**
             * (parse only) strict parsing, off by default
             * 
             */
            "strict": boolean;
            /**
             * override pattern with this string
             * 
             */
            "timePattern": string;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/Destroyable.html
     *
     * Mixin to track handles and release them when instance is destroyed.
     * Call this.own(...) on list of handles (returned from dojo/aspect, dojo/on,
     * dojo/Stateful::watch, or any class (including widgets) with a destroyRecursive() or destroy() method.
     * Then call destroy() later to destroy this instance and release the resources.
     * 
     */
    class Destroyable {
        constructor();
        /**
         * Destroy this class, releasing any resources registered via own().
         * 
         * @param preserveDom             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(handle:any): any;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/CalendarLite.html
     *
     * Lightweight version of Calendar widget aimed towards mobile use
     * A simple GUI for choosing a date in the context of a monthly calendar.
     * This widget can't be used in a form because it doesn't serialize the date to an
     * <input> field.  For a form element, use dijit/form/DateTextBox instead.
     * 
     * Note that the parser takes all dates attributes passed in the
     * RFC 3339 format, e.g. 2005-06-30T08:05:00-07:00
     * so that they are serializable and locale-independent.
     * 
     * Also note that this widget isn't keyboard accessible; use dijit.Calendar for that
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree     
     */
    class CalendarLite extends dijit._WidgetBase implements dijit._TemplatedMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Date object containing the currently focused date, or the date which would be focused
         * if the calendar itself was focused.   Also indicates which year and month to display,
         * i.e. the current "page" the calendar is on.
         * 
         */
        "currentFocus": Date;
        set(property:"currentFocus", value: Date): void;
        get(property:"currentFocus"): Date;
        watch(property:"currentFocus", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
        /**
         * JavaScript namespace to find calendar routines.  If unspecified, uses Gregorian calendar routines
         * at dojo/date and dojo/date/locale.
         * 
         */
        "datePackage": string;
        set(property:"datePackage", value: string): void;
        get(property:"datePackage"): string;
        watch(property:"datePackage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "dateTemplateString": string;
        set(property:"dateTemplateString", value: string): void;
        get(property:"dateTemplateString"): string;
        watch(property:"dateTemplateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * How to represent the days of the week in the calendar header. See locale
         * 
         */
        "dayWidth": string;
        set(property:"dayWidth", value: string): void;
        get(property:"dayWidth"): string;
        watch(property:"dayWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * 
         */
        "dowTemplateString": string;
        set(property:"dowTemplateString", value: string): void;
        get(property:"dowTemplateString"): string;
        watch(property:"dowTemplateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Order fields are traversed when user hits the tab key
         * 
         */
        "tabIndex": string;
        set(property:"tabIndex", value: string): void;
        get(property:"tabIndex"): string;
        watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The currently selected Date, initially set to invalid date to indicate no selection.
         * 
         */
        "value": Date;
        set(property:"value", value: Date): void;
        get(property:"value"): Date;
        watch(property:"value", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
        /**
         * 
         */
        "weekTemplateString": string;
        set(property:"weekTemplateString", value: string): void;
        get(property:"weekTemplateString"): string;
        watch(property:"weekTemplateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Focus the calendar by focusing one of the calendar cells
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * May be overridden to return CSS classes to associate with the date entry for the given dateObject,
         * for example to indicate a holiday in specified locale.
         * 
         * @param dateObject             
         * @param locale               Optional            
         */
        getClassForDate(dateObject: Date, locale: String): String;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Sets calendar's value to today's date
         * 
         */
        goToToday(): void;
        /**
         * May be overridden to disable certain dates in the calendar e.g. isDisabledDate=dojo.date.locale.isWeekend
         * 
         * @param dateObject             
         * @param locale               Optional            
         */
        isDisabledDate(dateObject: Date, locale: String): boolean;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called only when the selected date has changed
         * 
         * @param date             
         */
        onChange(date: Date): void;
    }
    module CalendarLite {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/CalendarLite._MonthWidget.html
         *
         * Displays name of current month padded to the width of the month
         * w/the longest name, so that changing months doesn't change width.
         * 
         * Create as:
         * 
         * new Calendar._MonthWidget({
         *         lang: ...,
         *         dateLocaleModule: ...
         *     })
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _MonthWidget extends dijit._WidgetBase {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom?: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom?: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * Processing after the DOM fragment is created
             * Called after the DOM fragment has been created, but not necessarily
             * added to the document.  Do not include any operations which rely on
             * node dimensions or placement.
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/Declaration.html
     *
     * The Declaration widget allows a developer to declare new widget
     * classes directly from a snippet of markup.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class Declaration extends dijit._Widget {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * 
         */
        "defaults": Object;
        set(property:"defaults", value: Object): void;
        get(property:"defaults"): Object;
        watch(property:"defaults", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * List containing the prototype for this widget, and also any mixins,
         * ex: ["dijit._Widget", "dijit._Container"]
         * 
         */
        "mixins": Object;
        set(property:"mixins", value: Object): void;
        get(property:"mixins"): Object;
        watch(property:"mixins", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Name of class being declared, ex: "acme.myWidget"
         * 
         */
        "widgetClass": string;
        set(property:"widgetClass", value: string): void;
        get(property:"widgetClass"): string;
        watch(property:"widgetClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/Calendar.html
     *
     * A simple GUI for choosing a date in the context of a monthly calendar.
     * See CalendarLite for general description.   Calendar extends CalendarLite, adding:
     * 
     * month drop down list
     * keyboard navigation
     * CSS classes for hover/mousepress on date, month, and year nodes
     * support of deprecated methods (will be removed in 2.0)
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree     
     */
    class Calendar extends dijit.CalendarLite implements dijit._Widget, dijit._CssStateMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        		/**
         * Custom press, release, and click synthetic events
         * which trigger on a left mouse click, touch, or space/enter keyup.
         * 
         */
        "a11yclick": Object;
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Date object containing the currently focused date, or the date which would be focused
         * if the calendar itself was focused.   Also indicates which year and month to display,
         * i.e. the current "page" the calendar is on.
         * 
         */
        "currentFocus": Date;
        set(property:"currentFocus", value: Date): void;
        get(property:"currentFocus"): Date;
        watch(property:"currentFocus", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
        /**
         * JavaScript namespace to find calendar routines.  If unspecified, uses Gregorian calendar routines
         * at dojo/date and dojo/date/locale.
         * 
         */
        "datePackage": string;
        set(property:"datePackage", value: string): void;
        get(property:"datePackage"): string;
        watch(property:"datePackage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "dateTemplateString": string;
        set(property:"dateTemplateString", value: string): void;
        get(property:"dateTemplateString"): string;
        watch(property:"dateTemplateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * How to represent the days of the week in the calendar header. See locale
         * 
         */
        "dayWidth": string;
        set(property:"dayWidth", value: string): void;
        get(property:"dayWidth"): string;
        watch(property:"dayWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * 
         */
        "dowTemplateString": string;
        set(property:"dowTemplateString", value: string): void;
        get(property:"dowTemplateString"): string;
        watch(property:"dowTemplateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Defines a type of widget.
         * 
         */
        "dndType": string;
        set(property:"dndType", value: string): void;
        get(property:"dndType"): string;
        watch(property:"dndType", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "observer": string;
        set(property:"observer", value: string): void;
        get(property:"observer"): string;
        watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A parameter needed by RadioGroupSlide only. An optional paramter to force
         * the ContentPane to slide in from a set direction. Defaults
         * to "random", or specify one of "top", "left", "right", "bottom"
         * to slideFrom top, left, right, or bottom.
         * 
         */
        "slideFrom": string;
        set(property:"slideFrom", value: string): void;
        get(property:"slideFrom"): string;
        watch(property:"slideFrom", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Order fields are traversed when user hits the tab key
         * 
         */
        "tabIndex": string;
        set(property:"tabIndex", value: string): void;
        get(property:"tabIndex"): string;
        watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The currently selected Date, initially set to invalid date to indicate no selection.
         * 
         */
        "value": Date;
        set(property:"value", value: Date): void;
        get(property:"value"): Date;
        watch(property:"value", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
        /**
         * 
         */
        "weekTemplateString": string;
        set(property:"weekTemplateString", value: string): void;
        get(property:"weekTemplateString"): string;
        watch(property:"weekTemplateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Focus the calendar by focusing one of the calendar cells
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * May be overridden to return CSS classes to associate with the date entry for the given dateObject,
         * for example to indicate a holiday in specified locale.
         * 
         * @param dateObject             
         * @param locale               Optional            
         */
        getClassForDate(dateObject: Date, locale: String): String;
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Sets calendar's value to today's date
         * 
         */
        goToToday(): void;
        /**
         * Provides keyboard navigation of calendar.
         * Called from _onKeyDown() to handle keydown on a stand alone Calendar,
         * and also from dijit/form/_DateTimeTextBox to pass a keydown event
         * from the dijit/form/DateTextBox to be handled in this widget
         * 
         * @param evt             
         */
        handleKey(evt: Event): any;
        /**
         * May be overridden to disable certain dates in the calendar e.g. isDisabledDate=dojo.date.locale.isWeekend
         * 
         * @param dateObject             
         * @param locale               Optional            
         */
        isDisabledDate(dateObject: Date, locale: String): boolean;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
         * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
         * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
         * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
         * 
         * @param type Name of event (ex: "click") or extension event like touch.press.             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated.   Use set('value', ...) instead.
         * 
         * @param value             
         */
        setValue(value: Date): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * 
         * @param value             
         */
        onChange(value: any): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
        /**
         * Deprecated.   Notification that a date cell was selected.  It may be the same as the previous value.
         * Formerly used by dijit/form/_DateTimeTextBox (and thus dijit/form/DateTextBox)
         * to get notification when the user has clicked a date.  Now onExecute() (above) is used.
         * 
         * @param date             
         */
        onValueSelected(date: Date): void;
    }
    module Calendar {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/Calendar._MonthDropDown.html
         *
         * The list-of-months drop down from the MonthDropDownButton
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _MonthDropDown extends dijit._Widget implements dijit._TemplatedMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * List of names of months, possibly w/some undefined entries for Hebrew leap months
             * (ex: ["January", "February", undefined, "April", ...])
             * 
             */
            "months": Object;
            set(property:"months", value: Object): void;
            get(property:"months"): Object;
            watch(property:"months", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom?: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom?: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Callback when month is selected from drop down
             * 
             * @param month             
             */
            onChange(month: number): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/Calendar._MonthDropDownButton.html
         *
         * DropDownButton for the current month.    Displays name of current month
         * and a list of month names in the drop down
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _MonthDropDownButton extends dijit.form.DropDownButton {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * True if mouse was pressed while over this widget, and hasn't been released yet
             * 
             */
            "active": boolean;
            set(property:"active", value: boolean): void;
            get(property:"active"): boolean;
            watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Corresponds to the native HTML <input> element's attribute.
             * 
             */
            "alt": string;
            set(property:"alt", value: string): void;
            get(property:"alt"): string;
            watch(property:"alt", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "aria-label": string;
            set(property:"aria-label", value: string): void;
            get(property:"aria-label"): string;
            watch(property:"aria-label", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Set to true to make the drop down at least as wide as this
             * widget.  Set to false if the drop down should just be its
             * default width.
             * 
             */
            "autoWidth": boolean;
            set(property:"autoWidth", value: boolean): void;
            get(property:"autoWidth"): boolean;
            watch(property:"autoWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
             * need CSS classes applied on mouse hover/press and focus.
             * 
             * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
             * (like "dijitUpArrowButton"). Example:
             * 
             * {
             *     "upArrowButton": "dijitUpArrowButton",
             *     "downArrowButton": "dijitDownArrowButton"
             * }
             * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
             * 
             * is hovered, etc.
             * 
             */
            "cssStateNodes": Object;
            set(property:"cssStateNodes", value: Object): void;
            get(property:"cssStateNodes"): Object;
            watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Should this widget respond to user input?
             * In markup, this is specified as "disabled='disabled'", or just "disabled".
             * 
             */
            "disabled": boolean;
            set(property:"disabled", value: boolean): void;
            get(property:"disabled"): boolean;
            watch(property:"disabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The widget to display as a popup.  This widget must be
             * defined before the startup function is called.
             * 
             */
            "dropDown": Object;
            set(property:"dropDown", value: Object): void;
            get(property:"dropDown"): Object;
            watch(property:"dropDown", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * This variable controls the position of the drop down.
             * It's an array of strings with the following values:
             * 
             * before: places drop down to the left of the target node/widget, or to the right in
             * the case of RTL scripts like Hebrew and Arabic
             * after: places drop down to the right of the target node/widget, or to the left in
             * the case of RTL scripts like Hebrew and Arabic
             * above: drop down goes above target node
             * below: drop down goes below target node
             * The list is positions is tried, in order, until a position is found where the drop down fits
             * within the viewport.
             * 
             */
            "dropDownPosition": Object;
            set(property:"dropDownPosition", value: Object): void;
            get(property:"dropDownPosition"): Object;
            watch(property:"dropDownPosition", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set to true to make the drop down exactly as wide as this
             * widget.  Overrides autoWidth.
             * 
             */
            "forceWidth": boolean;
            set(property:"forceWidth", value: boolean): void;
            get(property:"forceWidth"): boolean;
            watch(property:"forceWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * True if cursor is over this widget
             * 
             */
            "hovering": boolean;
            set(property:"hovering", value: boolean): void;
            get(property:"hovering"): boolean;
            watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Class to apply to DOMNode in button to make it display an icon
             * 
             */
            "iconClass": string;
            set(property:"iconClass", value: string): void;
            get(property:"iconClass"): string;
            watch(property:"iconClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Fires onChange for each value change or only on demand
             * 
             */
            "intermediateChanges": boolean;
            set(property:"intermediateChanges", value: boolean): void;
            get(property:"intermediateChanges"): boolean;
            watch(property:"intermediateChanges", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Content to display in button.
             * 
             */
            "label": string;
            set(property:"label", value: string): void;
            get(property:"label"): string;
            watch(property:"label", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The max height for our dropdown.
             * Any dropdown taller than this will have scrollbars.
             * Set to 0 for no max height, or -1 to limit height to available space in viewport
             * 
             */
            "maxHeight": number;
            set(property:"maxHeight", value: number): void;
            get(property:"maxHeight"): number;
            watch(property:"maxHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Name used when submitting form; same as "name" attribute or plain HTML elements
             * 
             */
            "name": string;
            set(property:"name", value: string): void;
            get(property:"name"): string;
            watch(property:"name", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * On focus, should this widget scroll into view?
             * 
             */
            "scrollOnFocus": boolean;
            set(property:"scrollOnFocus", value: boolean): void;
            get(property:"scrollOnFocus"): boolean;
            watch(property:"scrollOnFocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set this to true to hide the label text and display only the icon.
             * (If showLabel=false then iconClass must be specified.)
             * Especially useful for toolbars.
             * If showLabel=true, the label will become the title (a.k.a. tooltip/hint) of the icon.
             * 
             * The exception case is for computers in high-contrast mode, where the label
             * will still be displayed, since the icon doesn't appear.
             * 
             */
            "showLabel": boolean;
            set(property:"showLabel", value: boolean): void;
            get(property:"showLabel"): boolean;
            watch(property:"showLabel", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Order fields are traversed when user hits the tab key
             * 
             */
            "tabIndex": string;
            set(property:"tabIndex", value: string): void;
            get(property:"tabIndex"): string;
            watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Corresponds to the native HTML <input> element's attribute.
             * 
             */
            "type": string;
            set(property:"type", value: string): void;
            get(property:"type"): string;
            watch(property:"type", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Corresponds to the native HTML <input> element's attribute.
             * 
             */
            "value": string;
            set(property:"value", value: string): void;
            get(property:"value"): string;
            watch(property:"value", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Makes the given widget a child of this widget.
             * Inserts specified child widget's dom node as a child of this widget's
             * container node, and possibly does other processing (such as layout).
             * 
             * @param widget             
             * @param insertIndex               Optional            
             */
            addChild(widget: dijit._WidgetBase, insertIndex: number): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Closes the drop down on this widget
             * 
             * @param focus If true, refocuses the button widget             
             */
            closeDropDown(focus: boolean): void;
            /**
             * Compare 2 values (as returned by get('value') for this widget).
             * 
             * @param val1             
             * @param val2             
             */
            compare(val1: any, val2: any): number;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom?: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom?: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Put focus on this widget
             * 
             */
            focus(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * Gets the index of the child in this container or -1 if not found
             * 
             * @param child             
             */
            getIndexOfChild(child: dijit._WidgetBase): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Deprecated.  Use get('value') instead.
             * 
             */
            getValue(): any;
            /**
             * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
             * 
             */
            hasChildren(): boolean;
            /**
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             */
            isLoaded(): boolean;
            /**
             * Creates the drop down if it doesn't exist, loads the data
             * if there's an href and it hasn't been loaded yet, and
             * then opens the drop down.  This is basically a callback when the
             * user presses the down arrow button to open the drop down.
             * 
             */
            loadAndOpenDropDown(): any;
            /**
             * 
             * @param callback             
             */
            loadDropDown(callback: Function): void;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Opens the dropdown for this widget.   To be called only when this.dropDown
             * has been created and is ready to display (ie, it's data is loaded).
             * 
             */
            openDropDown(): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * Removes the passed widget instance from this widget but does
             * not destroy it.  You can also pass in an integer indicating
             * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
             * 
             * @param widget             
             */
            removeChild(widget: dijit._WidgetBase): void;
            /**
             * Removes the passed widget instance from this widget but does
             * not destroy it.  You can also pass in an integer indicating
             * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
             * 
             * @param widget             
             */
            removeChild(widget: number): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * Deprecated.  Use set('disabled', ...) instead.
             * 
             * @param disabled             
             */
            setDisabled(disabled: boolean): void;
            /**
             * Deprecated.  Use set('label', ...) instead.
             * 
             * @param content             
             */
            setLabel(content: String): void;
            /**
             * Deprecated.  Use set('value', ...) instead.
             * 
             * @param value             
             */
            setValue(value: String): void;
            /**
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Callback when the user presses the down arrow button or presses
             * the down arrow key to open/close the drop down.
             * Toggle the drop-down widget; if it is up, close it, if not, open it
             * 
             */
            toggleDropDown(): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Callback when this widget's value is changed.
             * 
             * @param newValue             
             */
            onChange(newValue: any): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): boolean;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * 
             */
            onMonthSelect(): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/CheckedMenuItem.html
     *
     * A checkbox-like menu item for toggling on and off
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class CheckedMenuItem extends dijit.MenuItem {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Text for the accelerator (shortcut) key combination, a control, alt, etc. modified keystroke meant to
         * execute the menu item regardless of where the focus is on the page.
         * 
         * Note that although Menu can display accelerator keys, there is no infrastructure to actually catch and
         * execute those accelerators.
         * 
         */
        "accelKey": string;
        set(property:"accelKey", value: string): void;
        get(property:"accelKey"): string;
        watch(property:"accelKey", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Our checked state
         * 
         */
        "checked": boolean;
        set(property:"checked", value: boolean): void;
        get(property:"checked"): boolean;
        watch(property:"checked", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Character (or string) used in place of checkbox icon when display in high contrast mode
         * 
         */
        "checkedChar": string;
        set(property:"checkedChar", value: string): void;
        get(property:"checkedChar"): string;
        watch(property:"checkedChar", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * If true, the menu item is disabled.
         * If false, the menu item is enabled.
         * 
         */
        "disabled": boolean;
        set(property:"disabled", value: boolean): void;
        get(property:"disabled"): boolean;
        watch(property:"disabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "iconClass": string;
        set(property:"iconClass", value: string): void;
        get(property:"iconClass"): string;
        watch(property:"iconClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Menu text as HTML
         * 
         */
        "label": string;
        set(property:"label", value: string): void;
        get(property:"label"): string;
        watch(property:"label", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "role": string;
        set(property:"role", value: string): void;
        get(property:"role"): string;
        watch(property:"role", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Single character (underlined when the parent Menu is focused) used to navigate directly to this widget,
         * also known as a mnemonic.
         * This is denoted in the label by surrounding the single character with {}.
         * For example, if label="{F}ile", then shortcutKey="F".
         * 
         */
        "shortcutKey": string;
        set(property:"shortcutKey", value: string): void;
        get(property:"shortcutKey"): string;
        watch(property:"shortcutKey", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Focus on this MenuItem
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the index of this widget within its container parent.
         * It returns -1 if the parent does not exist, or if the parent
         * is not a dijit/_Container
         * 
         */
        getIndexInParent(): any;
        /**
         * Returns null if this is the last child of the parent,
         * otherwise returns the next element sibling to the "right".
         * 
         */
        getNextSibling(): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Returns null if this is the first child of the parent,
         * otherwise returns the next element sibling to the "left".
         * 
         */
        getPreviousSibling(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated.   Use set('disabled', bool) instead.
         * 
         * @param disabled             
         */
        setDisabled(disabled: boolean): void;
        /**
         * Deprecated.   Use set('label', ...) instead.
         * 
         * @param content             
         */
        setLabel(content: String): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * User defined function to handle check/uncheck events
         * 
         * @param checked             
         */
        onChange(checked: boolean): void;
        /**
         * User defined function to handle clicks
         * 
         */
        onClick(): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/DialogUnderlay.html
     *
     * A component used to block input behind a dijit/Dialog.
     * 
     * Normally this class should not be instantiated directly, but rather shown and hidden via
     * DialogUnderlay.show() and DialogUnderlay.hide().  And usually the module is not accessed directly
     * at all, since the underlay is shown and hidden by Dialog.DialogLevelManager.
     * 
     * The underlay itself can be styled based on and id:
     * 
     * #myDialog_underlay { background-color:red; }
     * In the case of dijit.Dialog, this id is based on the id of the Dialog,
     * suffixed with _underlay.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class DialogUnderlay extends dijit._Widget implements dijit._TemplatedMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Id of the dialog.... DialogUnderlay's id is based on this id
         * 
         */
        "dialogId": string;
        set(property:"dialogId", value: string): void;
        get(property:"dialogId"): string;
        watch(property:"dialogId", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * 
         */
        destroy(): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Hide the underlay.
         * 
         */
        hide(): void;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Show the dialog underlay
         * 
         */
        show(): void;
        /**
         * Display the underlay with the given attributes set.  If the underlay is already displayed,
         * then adjust it's attributes as specified.
         * 
         * @param attrs The parameters to create DialogUnderlay with.             
         * @param zIndex zIndex of the underlay             
         */
        show(attrs: Object, zIndex: number): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.10/dijit/_ConfirmDialogMixin.html
     *
     * Mixin for Dialog/TooltipDialog with OK/Cancel buttons.
     * 
     */
    class _ConfirmDialogMixin extends dijit._WidgetsInTemplateMixin {
        constructor();
        /**
         * 
         */
        "actionBarTemplate": Object;
        /**
         * Label of cancel button
         * 
         */
        "buttonCancel": string;
        /**
         * Label of OK button
         * 
         */
        "buttonOk": string;
        /**
         * Used to provide a context require to the dojo/parser in order to be
         * able to use relative MIDs (e.g. ./Widget) in the widget's template.
         * 
         */
        "contextRequire": Function;
        /**
         * Should we parse the template to find widgets that might be
         * declared in markup inside it?  (Remove for 2.0 and assume true)
         * 
         */
        "widgetsInTemplate": boolean;
        /**
         * 
         */
        startup(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.10/dijit/ConfirmDialog.html
     *
     * A Dialog with OK/Cancel buttons.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class ConfirmDialog extends dijit.Dialog implements dijit._ConfirmDialogMixin {
        constructor(params: Object, srcNodeRef?: HTMLElement);
        okButton: dijit.form.Button;
        cancelButon: dijit.form.Button;

        /**
         * HTML snippet to show the action bar (gray bar with OK/cancel buttons).
         * Blank by default, but used by ConfirmDialog/ConfirmTooltipDialog subclasses.
         * 
         */
        "actionBarTemplate": string;
        set(property:"actionBarTemplate", value: string): void;
        get(property:"actionBarTemplate"): string;
        watch(property:"actionBarTemplate", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * A Toggle to modify the default focus behavior of a Dialog, which
         * is to focus on the first dialog element after opening the dialog.
         * False will disable autofocusing. Default: true
         * 
         */
        "autofocus": boolean;
        set(property:"autofocus", value: boolean): void;
        get(property:"autofocus"): boolean;
        watch(property:"autofocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Label of cancel button
         * 
         */
        "buttonCancel": string;
        set(property:"buttonCancel", value: string): void;
        get(property:"buttonCancel"): string;
        watch(property:"buttonCancel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Label of OK button
         * 
         */
        "buttonOk": string;
        set(property:"buttonOk", value: string): void;
        get(property:"buttonOk"): string;
        watch(property:"buttonOk", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Dialog show [x] icon to close itself, and ESC key will close the dialog.
         * 
         */
        "closable": boolean;
        set(property:"closable", value: boolean): void;
        get(property:"closable"): boolean;
        watch(property:"closable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * The innerHTML of the ContentPane.
         * Note that the initialization parameter / argument to set("content", ...)
         * can be a String, DomNode, Nodelist, or _Widget.
         * 
         */
        "content": string;
        set(property:"content", value: string): void;
        get(property:"content"): string;
        watch(property:"content", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Used to provide a context require to the dojo/parser in order to be
         * able to use relative MIDs (e.g. ./Widget) in the widget's template.
         * 
         */
        "contextRequire": Function;
        set(property:"contextRequire", value: Function): void;
        get(property:"contextRequire"): Function;
        watch(property:"contextRequire", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
        /**
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         * false - don't adjust size of children
         * true - if there is a single visible child widget, set it's size to however big the ContentPane is
         * 
         */
        "doLayout": boolean;
        set(property:"doLayout", value: boolean): void;
        get(property:"doLayout"): boolean;
        watch(property:"doLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Toggles the movable aspect of the Dialog. If true, Dialog
         * can be dragged by it's title. If false it will remain centered
         * in the viewport.
         * 
         */
        "draggable": boolean;
        set(property:"draggable", value: boolean): void;
        get(property:"draggable"): boolean;
        watch(property:"draggable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The time in milliseconds it takes the dialog to fade in and out
         * 
         */
        "duration": number;
        set(property:"duration", value: number): void;
        get(property:"duration"): number;
        watch(property:"duration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * Message that shows if an error occurs
         * 
         */
        "errorMessage": string;
        set(property:"errorMessage", value: string): void;
        get(property:"errorMessage"): string;
        watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Extract visible content from inside of <body> .... </body>.
         * I.e., strip <html> and <head> (and it's contents) from the href
         * 
         */
        "extractContent": boolean;
        set(property:"extractContent", value: boolean): void;
        get(property:"extractContent"): boolean;
        watch(property:"extractContent", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The href of the content that displays now.
         * Set this at construction if you want to load data externally when the
         * pane is shown.  (Set preload=true to load it immediately.)
         * Changing href after creation doesn't have any effect; Use set('href', ...);
         * 
         */
        "href": string;
        set(property:"href", value: string): void;
        get(property:"href"): string;
        watch(property:"href", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Parameters to pass to xhrGet() request, for example:
         * 
         * <div data-dojo-type="dijit/layout/ContentPane" data-dojo-props="href: './bar', ioArgs: {timeout: 500}">
         * 
         */
        "ioArgs": Object;
        set(property:"ioArgs", value: Object): void;
        get(property:"ioArgs"): Object;
        watch(property:"ioArgs", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Indicates that this widget will call resize() on it's child widgets
         * when they become visible.
         * 
         */
        "isLayoutContainer": boolean;
        set(property:"isLayoutContainer", value: boolean): void;
        get(property:"isLayoutContainer"): boolean;
        watch(property:"isLayoutContainer", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if the ContentPane has data in it, either specified
         * during initialization (via href or inline content), or set
         * via set('content', ...) / set('href', ...)
         * 
         * False if it doesn't have any content, or if ContentPane is
         * still in the process of downloading href.
         * 
         */
        "isLoaded": boolean;
        set(property:"isLoaded", value: boolean): void;
        get(property:"isLoaded"): boolean;
        watch(property:"isLoaded", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Message that shows while downloading
         * 
         */
        "loadingMessage": string;
        set(property:"loadingMessage", value: string): void;
        get(property:"loadingMessage"): string;
        watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Maximum size to allow the dialog to expand to, relative to viewport size
         * 
         */
        "maxRatio": number;
        set(property:"maxRatio", value: number): void;
        get(property:"maxRatio"): number;
        watch(property:"maxRatio", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * This is the dojo.Deferred returned by set('href', ...) and refresh().
         * Calling onLoadDeferred.then() registers your
         * callback to be called only once, when the prior set('href', ...) call or
         * the initial href parameter to the constructor finishes loading.
         * 
         * This is different than an onLoad() handler which gets called any time any href
         * or content is loaded.
         * 
         */
        "onLoadDeferred": Object;
        set(property:"onLoadDeferred", value: Object): void;
        get(property:"onLoadDeferred"): Object;
        watch(property:"onLoadDeferred", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * True if Dialog is currently displayed on screen.
         * 
         */
        "open": boolean;
        set(property:"open", value: boolean): void;
        get(property:"open"): boolean;
        watch(property:"open", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Parse content and create the widgets, if any.
         * 
         */
        "parseOnLoad": boolean;
        set(property:"parseOnLoad", value: boolean): void;
        get(property:"parseOnLoad"): boolean;
        watch(property:"parseOnLoad", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Flag passed to parser.  Root for attribute names to search for.   If scopeName is dojo,
         * will search for data-dojo-type (or dojoType).  For backwards compatibility
         * reasons defaults to dojo._scopeName (which is "dojo" except when
         * multi-version support is used, when it will be something like dojo16, dojo20, etc.)
         * 
         */
        "parserScope": string;
        set(property:"parserScope", value: string): void;
        get(property:"parserScope"): string;
        watch(property:"parserScope", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Force load of data on initialization even if pane is hidden.
         * 
         */
        "preload": boolean;
        set(property:"preload", value: boolean): void;
        get(property:"preload"): boolean;
        watch(property:"preload", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Prevent caching of data from href's by appending a timestamp to the href.
         * 
         */
        "preventCache": boolean;
        set(property:"preventCache", value: boolean): void;
        get(property:"preventCache"): boolean;
        watch(property:"preventCache", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A Toggle to modify the default focus behavior of a Dialog, which
         * is to re-focus the element which had focus before being opened.
         * False will disable refocusing. Default: true
         * 
         */
        "refocus": boolean;
        set(property:"refocus", value: boolean): void;
        get(property:"refocus"): boolean;
        watch(property:"refocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Refresh (re-download) content when pane goes from hidden to shown
         * 
         */
        "refreshOnShow": boolean;
        set(property:"refreshOnShow", value: boolean): void;
        get(property:"refreshOnShow"): boolean;
        watch(property:"refreshOnShow", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Will be "Error" if one or more of the child widgets has an invalid value,
         * "Incomplete" if not all of the required child widgets are filled in.  Otherwise, "",
         * which indicates that the form is ready to be submitted.
         * 
         */
        "state": string;
        set(property:"state", value: string): void;
        get(property:"state"): string;
        watch(property:"state", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "stopParser": boolean;
        set(property:"stopParser", value: boolean): void;
        get(property:"stopParser"): boolean;
        watch(property:"stopParser", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Should we parse the template to find widgets that might be
         * declared in markup inside it?  (Remove for 2.0 and assume true)
         * 
         */
        "widgetsInTemplate": boolean;
        set(property:"widgetsInTemplate", value: boolean): void;
        get(property:"widgetsInTemplate"): boolean;
        watch(property:"widgetsInTemplate", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Makes the given widget a child of this widget.
         * Inserts specified child widget's dom node as a child of this widget's
         * container node, and possibly does other processing (such as layout).
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex: number): void;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Cancels an in-flight download of content
         * 
         */
        cancel(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * You can call this function directly, ex. in the event that you
         * programmatically add a widget to the form after the form has been
         * initialized.
         * 
         * @param inStartup             
         */
        connectChildren(inStartup: boolean): void;
        /**
         * 
         * @param params             
         * @param srcNodeRef             
         */
        create(params: any, srcNodeRef: any): void;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * 
         */
        destroy(): void;
        /**
         * Destroy all the widgets inside the ContentPane and empty containerNode
         * 
         * @param preserveDom             
         */
        destroyDescendants(preserveDom: boolean): void;
        /**
         * Destroy the ContentPane and its contents
         * 
         * @param preserveDom             
         */
        destroyRecursive(preserveDom: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Deprecated method.   Applications no longer need to call this.   Remove for 2.0.
         * 
         */
        disconnectChildren(): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Callback when the user hits the submit button.
         * Override this method to handle Dialog execution.
         * After the user has pressed the submit button, the Dialog
         * first calls onExecute() to notify the container to hide the
         * dialog and restore focus to wherever it used to be.
         * 
         * Then this method is called.
         * 
         * @param formContents             
         */
        execute(formContents: Object): void;
        /**
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * 
         */
        getValues(): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * Hide the dialog
         * 
         */
        hide(): any;
        /**
         * Function that should grab the content specified via href.
         * 
         * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
         */
        ioMethod(args: Object): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * Returns true if all of the widgets are valid.
         * Deprecated, will be removed in 2.0.  Use get("state") instead.
         * 
         */
        isValid: {(): boolean};
        /**
         * 
         * @param params             
         * @param node             
         * @param ctor             
         */
        markupFactory(params: any, node: any, ctor: any): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, DocumentFragment, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, DocumentFragment, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, DocumentFragment, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference:  dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, DocumentFragment, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, DocumentFragment, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, DocumentFragment, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference:  dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * 
         */
        postMixInProperties(): void;
        /**
         * [Re]download contents of href and display
         * cancels any currently in-flight requests
         * posts "loading..." message
         * sends XHR to download new data
         * 
         */
        refresh(): any;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;
        /**
         * 
         */
        reset(): void;
        /**
         * See dijit/layout/_LayoutWidget.resize() for description.
         * Although ContentPane doesn't extend _LayoutWidget, it does implement
         * the same API.
         * 
         * @param changeSize             
         * @param resultSize             
         */
        resize(changeSize: any, resultSize: any): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: String): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: HTMLElement): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: NodeList): void;
        /**
         * Deprecated.   Use set('href', ...) instead.
         * 
         * @param href             
         */
        setHref(href: String): any;
        /**
         * Deprecated.   Use set('href', ...) instead.
         * 
         * @param href             
         */
        setHref(href: URL): any;
        /**
         * 
         * @param val             
         */
        setValues(val: any): any;
        /**
         * Display the dialog
         * 
         */
        show(): any;
        /**
         * Call startup() on all children including non _Widget ones like dojo/dnd/Source objects
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * returns if the form is valid - same as isValid - but
         * provides a few additional (ui-specific) features:
         * 
         * it will highlight any sub-widgets that are not valid
         * it will call focus() on the first invalid sub-widget
         * 
         */
        validate(): any;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Called when user has pressed the Dialog's cancel button, to notify container.
         * Developer shouldn't override or connect to this method;
         * it's a private communication device between the TooltipDialog
         * and the thing that opened it (ex: dijit/form/DropDownButton)
         * 
         */
        onCancel(): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Called on DOM faults, require faults etc. in content.
         * 
         * In order to display an error message in the pane, return
         * the error message from this method, as an HTML string.
         * 
         * By default (if this method is not overriden), it returns
         * nothing, so the error message is just printed to the console.
         * 
         * @param error             
         */
        onContentError(error: Error): void;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when download is finished.
         * 
         */
        onDownloadEnd(): void;
        /**
         * Called when download error occurs.
         * 
         * In order to display an error message in the pane, return
         * the error message from this method, as an HTML string.
         * 
         * Default behavior (if this method is not overriden) is to display
         * the error message inside the pane.
         * 
         * @param error             
         */
        onDownloadError(error: Error): any;
        /**
         * Called before download starts.
         * The string returned by this function will be the html
         * that tells the user we are loading something.
         * Override with your own function if you want to change text.
         * 
         */
        onDownloadStart(): any;
        /**
         * Called when user has pressed the dialog's OK button, to notify container.
         * Developer shouldn't override or connect to this method;
         * it's a private communication device between the TooltipDialog
         * and the thing that opened it (ex: dijit/form/DropDownButton)
         * 
         */
        onExecute(): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Event hook, is called after everything is loaded and widgetified
         * 
         * @param data             
         */
        onLoad(data: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
        /**
         * Event hook, is called before old content is cleared
         * 
         */
        onUnload(): void;
        /**
         * Stub function to connect to if you want to do something
         * (like disable/enable a submit button) when the valid
         * state changes on the form as a whole.
         * 
         * Deprecated.  Will be removed in 2.0.  Use watch("state", ...) instead.
         * 
         * @param isValid             
         */
        onValidStateChange(isValid: boolean): void;
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/Dialog.html
     *
     * A modal dialog Widget.
     * Pops up a modal dialog window, blocking access to the screen
     * and also graying out the screen Dialog is extended from
     * ContentPane so it supports all the same parameters (href, etc.).
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class Dialog extends dijit.layout.ContentPane implements dijit._TemplatedMixin, dijit.form._FormMixin, dijit._DialogMixin, dijit._CssStateMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * A Toggle to modify the default focus behavior of a Dialog, which
         * is to focus on the first dialog element after opening the dialog.
         * False will disable autofocusing. Default: true
         * 
         */
        "autofocus": boolean;
        set(property:"autofocus", value: boolean): void;
        get(property:"autofocus"): boolean;
        watch(property:"autofocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Dialog show [x] icon to close itself, and ESC key will close the dialog.
         * 
         */
        "closable": boolean;
        set(property:"closable", value: boolean): void;
        get(property:"closable"): boolean;
        watch(property:"closable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * The innerHTML of the ContentPane.
         * Note that the initialization parameter / argument to set("content", ...)
         * can be a String, DomNode, Nodelist, or _Widget.
         * 
         */
        "content": string;
        set(property:"content", value: string): void;
        get(property:"content"): string;
        watch(property:"content", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         * false - don't adjust size of children
         * true - if there is a single visible child widget, set it's size to however big the ContentPane is
         * 
         */
        "doLayout": boolean;
        set(property:"doLayout", value: boolean): void;
        get(property:"doLayout"): boolean;
        watch(property:"doLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Toggles the movable aspect of the Dialog. If true, Dialog
         * can be dragged by it's title. If false it will remain centered
         * in the viewport.
         * 
         */
        "draggable": boolean;
        set(property:"draggable", value: boolean): void;
        get(property:"draggable"): boolean;
        watch(property:"draggable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The time in milliseconds it takes the dialog to fade in and out
         * 
         */
        "duration": number;
        set(property:"duration", value: number): void;
        get(property:"duration"): number;
        watch(property:"duration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * Message that shows if an error occurs
         * 
         */
        "errorMessage": string;
        set(property:"errorMessage", value: string): void;
        get(property:"errorMessage"): string;
        watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Extract visible content from inside of <body> .... </body>.
         * I.e., strip <html> and <head> (and it's contents) from the href
         * 
         */
        "extractContent": boolean;
        set(property:"extractContent", value: boolean): void;
        get(property:"extractContent"): boolean;
        watch(property:"extractContent", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The href of the content that displays now.
         * Set this at construction if you want to load data externally when the
         * pane is shown.  (Set preload=true to load it immediately.)
         * Changing href after creation doesn't have any effect; Use set('href', ...);
         * 
         */
        "href": string;
        set(property:"href", value: string): void;
        get(property:"href"): string;
        watch(property:"href", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Parameters to pass to xhrGet() request, for example:
         * 
         * <div data-dojo-type="dijit/layout/ContentPane" data-dojo-props="href: './bar', ioArgs: {timeout: 500}">
         * 
         */
        "ioArgs": Object;
        set(property:"ioArgs", value: Object): void;
        get(property:"ioArgs"): Object;
        watch(property:"ioArgs", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Indicates that this widget will call resize() on it's child widgets
         * when they become visible.
         * 
         */
        "isLayoutContainer": boolean;
        set(property:"isLayoutContainer", value: boolean): void;
        get(property:"isLayoutContainer"): boolean;
        watch(property:"isLayoutContainer", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if the ContentPane has data in it, either specified
         * during initialization (via href or inline content), or set
         * via set('content', ...) / set('href', ...)
         * 
         * False if it doesn't have any content, or if ContentPane is
         * still in the process of downloading href.
         * 
         */
        "isLoaded": boolean;
        set(property:"isLoaded", value: boolean): void;
        get(property:"isLoaded"): boolean;
        watch(property:"isLoaded", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Message that shows while downloading
         * 
         */
        "loadingMessage": string;
        set(property:"loadingMessage", value: string): void;
        get(property:"loadingMessage"): string;
        watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Maximum size to allow the dialog to expand to, relative to viewport size
         * 
         */
        "maxRatio": number;
        set(property:"maxRatio", value: number): void;
        get(property:"maxRatio"): number;
        watch(property:"maxRatio", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * This is the dojo.Deferred returned by set('href', ...) and refresh().
         * Calling onLoadDeferred.then() registers your
         * callback to be called only once, when the prior set('href', ...) call or
         * the initial href parameter to the constructor finishes loading.
         * 
         * This is different than an onLoad() handler which gets called any time any href
         * or content is loaded.
         * 
         */
        "onLoadDeferred": Object;
        set(property:"onLoadDeferred", value: Object): void;
        get(property:"onLoadDeferred"): Object;
        watch(property:"onLoadDeferred", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * True if Dialog is currently displayed on screen.
         * 
         */
        "open": boolean;
        set(property:"open", value: boolean): void;
        get(property:"open"): boolean;
        watch(property:"open", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Parse content and create the widgets, if any.
         * 
         */
        "parseOnLoad": boolean;
        set(property:"parseOnLoad", value: boolean): void;
        get(property:"parseOnLoad"): boolean;
        watch(property:"parseOnLoad", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Flag passed to parser.  Root for attribute names to search for.   If scopeName is dojo,
         * will search for data-dojo-type (or dojoType).  For backwards compatibility
         * reasons defaults to dojo._scopeName (which is "dojo" except when
         * multi-version support is used, when it will be something like dojo16, dojo20, etc.)
         * 
         */
        "parserScope": string;
        set(property:"parserScope", value: string): void;
        get(property:"parserScope"): string;
        watch(property:"parserScope", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Force load of data on initialization even if pane is hidden.
         * 
         */
        "preload": boolean;
        set(property:"preload", value: boolean): void;
        get(property:"preload"): boolean;
        watch(property:"preload", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Prevent caching of data from href's by appending a timestamp to the href.
         * 
         */
        "preventCache": boolean;
        set(property:"preventCache", value: boolean): void;
        get(property:"preventCache"): boolean;
        watch(property:"preventCache", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A Toggle to modify the default focus behavior of a Dialog, which
         * is to re-focus the element which had focus before being opened.
         * False will disable refocusing. Default: true
         * 
         */
        "refocus": boolean;
        set(property:"refocus", value: boolean): void;
        get(property:"refocus"): boolean;
        watch(property:"refocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Refresh (re-download) content when pane goes from hidden to shown
         * 
         */
        "refreshOnShow": boolean;
        set(property:"refreshOnShow", value: boolean): void;
        get(property:"refreshOnShow"): boolean;
        watch(property:"refreshOnShow", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Will be "Error" if one or more of the child widgets has an invalid value,
         * "Incomplete" if not all of the required child widgets are filled in.  Otherwise, "",
         * which indicates that the form is ready to be submitted.
         * 
         */
        "state": string;
        set(property:"state", value: string): void;
        get(property:"state"): string;
        watch(property:"state", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "stopParser": boolean;
        set(property:"stopParser", value: boolean): void;
        get(property:"stopParser"): boolean;
        watch(property:"stopParser", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Makes the given widget a child of this widget.
         * Inserts specified child widget's dom node as a child of this widget's
         * container node, and possibly does other processing (such as layout).
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex: number): void;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Cancels an in-flight download of content
         * 
         */
        cancel(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * You can call this function directly, ex. in the event that you
         * programmatically add a widget to the form after the form has been
         * initialized.
         * 
         * @param inStartup             
         */
        connectChildren(inStartup: boolean): void;
        /**
         * 
         * @param params             
         * @param srcNodeRef             
         */
        create(params: any, srcNodeRef: any): void;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * 
         */
        destroy(): void;
        /**
         * Destroy all the widgets inside the ContentPane and empty containerNode
         * 
         * @param preserveDom             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy the ContentPane and its contents
         * 
         * @param preserveDom             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Deprecated method.   Applications no longer need to call this.   Remove for 2.0.
         * 
         */
        disconnectChildren(): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Callback when the user hits the submit button.
         * Override this method to handle Dialog execution.
         * After the user has pressed the submit button, the Dialog
         * first calls onExecute() to notify the container to hide the
         * dialog and restore focus to wherever it used to be.
         * 
         * Then this method is called.
         * 
         * @param formContents             
         */
        execute(formContents: Object): void;
        /**
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * 
         */
        getValues(): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * Hide the dialog
         * 
         */
        hide(): any;
        /**
         * Function that should grab the content specified via href.
         * 
         * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
         */
        ioMethod(args: Object): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * Returns true if all of the widgets are valid.
         * Deprecated, will be removed in 2.0.  Use get("state") instead.
         * 
         */
        isValid: {(): boolean};
        /**
         * 
         * @param params             
         * @param node             
         * @param ctor             
         */
        markupFactory(params: any, node: any, ctor: any): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * 
         */
        postMixInProperties(): void;
        /**
         * [Re]download contents of href and display
         * cancels any currently in-flight requests
         * posts "loading..." message
         * sends XHR to download new data
         * 
         */
        refresh(): any;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;
        /**
         * 
         */
        reset(): void;
        /**
         * See dijit/layout/_LayoutWidget.resize() for description.
         * Although ContentPane doesn't extend _LayoutWidget, it does implement
         * the same API.
         * 
         * @param changeSize             
         * @param resultSize             
         */
        resize(changeSize: any, resultSize: any): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: String): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: HTMLElement): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: NodeList): void;
        /**
         * Deprecated.   Use set('href', ...) instead.
         * 
         * @param href             
         */
        setHref(href: String): any;
        /**
         * Deprecated.   Use set('href', ...) instead.
         * 
         * @param href             
         */
        setHref(href: URL): any;
        /**
         * 
         * @param val             
         */
        setValues(val: any): any;
        /**
         * Display the dialog
         * 
         */
        show(): any;
        /**
         * Call startup() on all children including non _Widget ones like dojo/dnd/Source objects
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * returns if the form is valid - same as isValid - but
         * provides a few additional (ui-specific) features:
         * 
         * it will highlight any sub-widgets that are not valid
         * it will call focus() on the first invalid sub-widget
         * 
         */
        validate(): any;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Called when user has pressed the Dialog's cancel button, to notify container.
         * Developer shouldn't override or connect to this method;
         * it's a private communication device between the TooltipDialog
         * and the thing that opened it (ex: dijit/form/DropDownButton)
         * 
         */
        onCancel(): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Called on DOM faults, require faults etc. in content.
         * 
         * In order to display an error message in the pane, return
         * the error message from this method, as an HTML string.
         * 
         * By default (if this method is not overriden), it returns
         * nothing, so the error message is just printed to the console.
         * 
         * @param error             
         */
        onContentError(error: Error): void;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when download is finished.
         * 
         */
        onDownloadEnd(): void;
        /**
         * Called when download error occurs.
         * 
         * In order to display an error message in the pane, return
         * the error message from this method, as an HTML string.
         * 
         * Default behavior (if this method is not overriden) is to display
         * the error message inside the pane.
         * 
         * @param error             
         */
        onDownloadError(error: Error): any;
        /**
         * Called before download starts.
         * The string returned by this function will be the html
         * that tells the user we are loading something.
         * Override with your own function if you want to change text.
         * 
         */
        onDownloadStart(): any;
        /**
         * Called when user has pressed the dialog's OK button, to notify container.
         * Developer shouldn't override or connect to this method;
         * it's a private communication device between the TooltipDialog
         * and the thing that opened it (ex: dijit/form/DropDownButton)
         * 
         */
        onExecute(): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Event hook, is called after everything is loaded and widgetified
         * 
         * @param data             
         */
        onLoad(data: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
        /**
         * Event hook, is called before old content is cleared
         * 
         */
        onUnload(): void;
        /**
         * Stub function to connect to if you want to do something
         * (like disable/enable a submit button) when the valid
         * state changes on the form as a whole.
         * 
         * Deprecated.  Will be removed in 2.0.  Use watch("state", ...) instead.
         * 
         * @param isValid             
         */
        onValidStateChange(isValid: boolean): void;
    }
    module Dialog {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/Dialog._DialogBase.html
         *
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified, replace srcNodeRef with my generated DOM tree.     
         */
        class _DialogBase extends dijit._TemplatedMixin implements dijit.form._FormMixin, dijit._DialogMixin, dijit._CssStateMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * True if mouse was pressed while over this widget, and hasn't been released yet
             * 
             */
            "active": boolean;
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            /**
             * A Toggle to modify the default focus behavior of a Dialog, which
             * is to focus on the first dialog element after opening the dialog.
             * False will disable autofocusing. Default: true
             * 
             */
            "autofocus": boolean;
            /**
             * 
             */
            "baseClass": string;
            /**
             * Dialog show [x] icon to close itself, and ESC key will close the dialog.
             * 
             */
            "closable": boolean;
            /**
             * 
             */
            "cssStateNodes": Object;
            /**
             * Don't change this parameter from the default value.
             * This ContentPane parameter doesn't make sense for Dialog, since Dialog
             * is never a child of a layout container, nor can you specify the size of
             * Dialog in order to control the size of an inner widget.
             * 
             */
            "doLayout": boolean;
            /**
             * Toggles the movable aspect of the Dialog. If true, Dialog
             * can be dragged by it's title. If false it will remain centered
             * in the viewport.
             * 
             */
            "draggable": boolean;
            /**
             * The time in milliseconds it takes the dialog to fade in and out
             * 
             */
            "duration": number;
            /**
             * True if cursor is over this widget
             * 
             */
            "hovering": boolean;
            /**
             * Maximum size to allow the dialog to expand to, relative to viewport size
             * 
             */
            "maxRatio": number;
            /**
             * True if Dialog is currently displayed on screen.
             * 
             */
            "open": boolean;
            /**
             * A Toggle to modify the default focus behavior of a Dialog, which
             * is to re-focus the element which had focus before being opened.
             * False will disable refocusing. Default: true
             * 
             */
            "refocus": boolean;
            /**
             * 
             */
            "searchContainerNode": boolean;
            /**
             * Will be "Error" if one or more of the child widgets has an invalid value,
             * "Incomplete" if not all of the required child widgets are filled in.  Otherwise, "",
             * which indicates that the form is ready to be submitted.
             * 
             */
            "state": string;
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            /**
             * 
             */
            "templateString": string;
            /**
             * Construct the UI for this widget from a template, setting this.domNode.
             * 
             */
            buildRendering(): void;
            /**
             * You can call this function directly, ex. in the event that you
             * programmatically add a widget to the form after the form has been
             * initialized.
             * 
             * @param inStartup             
             */
            connectChildren(inStartup: boolean): void;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             */
            destroyRendering(): void;
            /**
             * Deprecated method.   Applications no longer need to call this.   Remove for 2.0.
             * 
             */
            disconnectChildren(): void;
            /**
             * Callback when the user hits the submit button.
             * Override this method to handle Dialog execution.
             * After the user has pressed the submit button, the Dialog
             * first calls onExecute() to notify the container to hide the
             * dialog and restore focus to wherever it used to be.
             * 
             * Then this method is called.
             * 
             * @param formContents             
             */
            execute(formContents: Object): void;
            /**
             * 
             */
            focus(): void;
            /**
             * 
             */
            getValues(): any;
            /**
             * Hide the dialog
             * 
             */
            hide(): any;
            /**
             * Returns true if all of the widgets are valid.
             * Deprecated, will be removed in 2.0.  Use get("state") instead.
             * 
             */
            isValid: {(): boolean};
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            reset(): void;
            /**
             * 
             * @param val             
             */
            setValues(val: any): any;
            /**
             * Display the dialog
             * 
             */
            show(): any;
            /**
             * 
             */
            startup(): void;
            /**
             * returns if the form is valid - same as isValid - but
             * provides a few additional (ui-specific) features:
             * 
             * it will highlight any sub-widgets that are not valid
             * it will call focus() on the first invalid sub-widget
             * 
             */
            validate(): any;
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when user has pressed the Dialog's cancel button, to notify container.
             * Developer shouldn't override or connect to this method;
             * it's a private communication device between the TooltipDialog
             * and the thing that opened it (ex: dijit/form/DropDownButton)
             * 
             */
            onCancel(): void;
            /**
             * Called when user has pressed the dialog's OK button, to notify container.
             * Developer shouldn't override or connect to this method;
             * it's a private communication device between the TooltipDialog
             * and the thing that opened it (ex: dijit/form/DropDownButton)
             * 
             */
            onExecute(): void;
            /**
             * Called when data has been loaded from an href.
             * Unlike most other callbacks, this function can be connected to (via dojo.connect)
             * but should not be overridden.
             * 
             */
            onLoad(): void;
            /**
             * Stub function to connect to if you want to do something
             * (like disable/enable a submit button) when the valid
             * state changes on the form as a whole.
             * 
             * Deprecated.  Will be removed in 2.0.  Use watch("state", ...) instead.
             * 
             * @param isValid             
             */
            onValidStateChange(isValid: boolean): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/Dialog._DialogLevelManager.html
         *
         * Controls the various active "levels" on the page, starting with the
         * stuff initially visible on the page (at z-index 0), and then having an entry for
         * each Dialog shown.
         * 
         */
        interface _DialogLevelManager {
            /**
             * Called when the specified dialog is hidden/destroyed, after the fade-out
             * animation ends, in order to reset page focus, fix the underlay, etc.
             * If the specified dialog isn't open then does nothing.
             * 
             * Caller is responsible for either setting display:none on the dialog domNode,
             * or calling dijit/popup.hide(), or removing it from the page DOM.
             * 
             * @param dialog             
             */
            hide(dialog: dijit._WidgetBase): void;
            /**
             * Returns true if specified Dialog is the top in the task
             * 
             * @param dialog             
             */
            isTop(dialog: dijit._WidgetBase): boolean;
            /**
             * Call right before fade-in animation for new dialog.
             * Saves current focus, displays/adjusts underlay for new dialog,
             * and sets the z-index of the dialog itself.
             * 
             * New dialog will be displayed on top of all currently displayed dialogs.
             * 
             * Caller is responsible for setting focus in new dialog after the fade-in
             * animation completes.
             * 
             * @param dialog             
             * @param underlayAttrs             
             */
            show(dialog: dijit._WidgetBase, underlayAttrs: Object): void;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/ColorPalette.html
     *
     * A keyboard accessible color-picking widget
     * Grid showing various colors, so the user can pick a certain color.
     * Can be used standalone, or as a popup.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class ColorPalette extends dijit._Widget implements dijit._TemplatedMixin, dijit._PaletteMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * CSS class applied to each cell in the palette
         * 
         */
        "cellClass": string;
        set(property:"cellClass", value: string): void;
        get(property:"cellClass"): string;
        watch(property:"cellClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Number of milliseconds before a held key or button becomes typematic
         * 
         */
        "defaultTimeout": number;
        set(property:"defaultTimeout", value: number): void;
        get(property:"defaultTimeout"): number;
        watch(property:"defaultTimeout", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Constructor for Object created for each cell of the palette.
         * dyeClass should implement the dijit/_PaletteMixin.__Dye interface.
         * 
         */
        "dyeClass": Function;
        set(property:"dyeClass", value: Function): void;
        get(property:"dyeClass"): Function;
        watch(property:"dyeClass", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Size of grid, either "7x10" or "3x4".
         * 
         */
        "palette": string;
        set(property:"palette", value: string): void;
        get(property:"palette"): string;
        watch(property:"palette", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Widget tab index.
         * 
         */
        "tabIndex": string;
        set(property:"tabIndex", value: string): void;
        get(property:"tabIndex"): string;
        watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The template of this widget.
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Fraction of time used to change the typematic timer between events
         * 1.0 means that each typematic event fires at defaultTimeout intervals
         * Less than 1.0 means that each typematic event fires at an increasing faster rate
         * 
         */
        "timeoutChangeRate": number;
        set(property:"timeoutChangeRate", value: number): void;
        get(property:"timeoutChangeRate"): number;
        watch(property:"timeoutChangeRate", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Currently selected color/emoticon/etc.
         * 
         */
        "value": string;
        set(property:"value", value: string): void;
        get(property:"value"): string;
        watch(property:"value", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Focus this widget.  Puts focus on the most recently focused cell.
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Callback when a cell is selected.
         * 
         * @param value Value corresponding to cell.             
         */
        onChange(value: String): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    module ColorPalette {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/ColorPalette._Color.html
         *
         * Object associated with each cell in a ColorPalette palette.
         * Implements dijit/Dye.
         * 
         * @param alias English name of the color.     
         * @param row Vertical position in grid.     
         * @param col     
         * @param title Localized name of the color.     
         */
        class _Color extends dojo._base.Color {
            constructor(alias: String, row: number, col: any, title: String);
            /**
             * 
             */
            "a": number;
            /**
             * 
             */
            "b": number;
            /**
             * 
             */
            "g": number;
            /**
             * 
             */
            "hcTemplate": string;
            /**
             * 
             */
            "r": number;
            /**
             * 
             */
            "template": string;
            /**
             * 
             * @param cell             
             * @param blankGif             
             */
            fillCell(cell: HTMLElement, blankGif: String): void;
            /**
             * Note that although dijit._Color is initialized with a value like "white" getValue() always
             * returns a hex value
             * 
             */
            getValue(): any;
            /**
             * makes sure that the object has correct attributes
             * 
             */
            sanitize(): void;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and sets this color instance to that value.
             * 
             * @param color             
             */
            setColor(color: any[]): Function;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and sets this color instance to that value.
             * 
             * @param color             
             */
            setColor(color: String): Function;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and sets this color instance to that value.
             * 
             * @param color             
             */
            setColor(color: Object): Function;
            /**
             * Returns a css color string in rgb(a) representation
             * 
             * @param includeAlpha               Optional            
             */
            toCss(includeAlpha: boolean): String;
            /**
             * Returns a CSS color string in hexadecimal representation
             * 
             */
            toHex(): String;
            /**
             * Returns 3 component array of rgb values
             * 
             */
            toRgb(): any[];
            /**
             * Returns a 4 component array of rgba values from the color
             * represented by this object.
             * 
             */
            toRgba(): any[];
            /**
             * Returns a visual representation of the color
             * 
             */
            toString(): any;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/Fieldset.html
     *
     * An accessible fieldset that can be expanded or collapsed via
     * its legend.  Fieldset extends dijit.TitlePane.
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class Fieldset extends dijit.TitlePane {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * The root className to use for the various states of this widget
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * The innerHTML of the ContentPane.
         * Note that the initialization parameter / argument to set("content", ...)
         * can be a String, DomNode, Nodelist, or _Widget.
         * 
         */
        "content": string;
        set(property:"content", value: string): void;
        get(property:"content"): string;
        watch(property:"content", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Don't change this parameter from the default value.
         * This ContentPane parameter doesn't make sense for TitlePane, since TitlePane
         * is never a child of a layout container, nor should TitlePane try to control
         * the size of an inner widget.
         * 
         */
        "doLayout": boolean;
        set(property:"doLayout", value: boolean): void;
        get(property:"doLayout"): boolean;
        watch(property:"doLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Time in milliseconds to fade in/fade out
         * 
         */
        "duration": number;
        set(property:"duration", value: number): void;
        get(property:"duration"): number;
        watch(property:"duration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * Message that shows if an error occurs
         * 
         */
        "errorMessage": string;
        set(property:"errorMessage", value: string): void;
        get(property:"errorMessage"): string;
        watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Extract visible content from inside of <body> .... </body>.
         * I.e., strip <html> and <head> (and it's contents) from the href
         * 
         */
        "extractContent": boolean;
        set(property:"extractContent", value: boolean): void;
        get(property:"extractContent"): boolean;
        watch(property:"extractContent", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The href of the content that displays now.
         * Set this at construction if you want to load data externally when the
         * pane is shown.  (Set preload=true to load it immediately.)
         * Changing href after creation doesn't have any effect; Use set('href', ...);
         * 
         */
        "href": string;
        set(property:"href", value: string): void;
        get(property:"href"): string;
        watch(property:"href", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Parameters to pass to xhrGet() request, for example:
         * 
         * <div data-dojo-type="dijit/layout/ContentPane" data-dojo-props="href: './bar', ioArgs: {timeout: 500}">
         * 
         */
        "ioArgs": Object;
        set(property:"ioArgs", value: Object): void;
        get(property:"ioArgs"): Object;
        watch(property:"ioArgs", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Indicates that this widget will call resize() on it's child widgets
         * when they become visible.
         * 
         */
        "isLayoutContainer": boolean;
        set(property:"isLayoutContainer", value: boolean): void;
        get(property:"isLayoutContainer"): boolean;
        watch(property:"isLayoutContainer", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if the ContentPane has data in it, either specified
         * during initialization (via href or inline content), or set
         * via set('content', ...) / set('href', ...)
         * 
         * False if it doesn't have any content, or if ContentPane is
         * still in the process of downloading href.
         * 
         */
        "isLoaded": boolean;
        set(property:"isLoaded", value: boolean): void;
        get(property:"isLoaded"): boolean;
        watch(property:"isLoaded", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Message that shows while downloading
         * 
         */
        "loadingMessage": string;
        set(property:"loadingMessage", value: string): void;
        get(property:"loadingMessage"): string;
        watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is the dojo.Deferred returned by set('href', ...) and refresh().
         * Calling onLoadDeferred.then() registers your
         * callback to be called only once, when the prior set('href', ...) call or
         * the initial href parameter to the constructor finishes loading.
         * 
         * This is different than an onLoad() handler which gets called any time any href
         * or content is loaded.
         * 
         */
        "onLoadDeferred": Object;
        set(property:"onLoadDeferred", value: Object): void;
        get(property:"onLoadDeferred"): Object;
        watch(property:"onLoadDeferred", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Whether fieldset is opened or closed.
         * 
         */
        "open": boolean;
        set(property:"open", value: boolean): void;
        get(property:"open"): boolean;
        watch(property:"open", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Parse content and create the widgets, if any.
         * 
         */
        "parseOnLoad": boolean;
        set(property:"parseOnLoad", value: boolean): void;
        get(property:"parseOnLoad"): boolean;
        watch(property:"parseOnLoad", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Flag passed to parser.  Root for attribute names to search for.   If scopeName is dojo,
         * will search for data-dojo-type (or dojoType).  For backwards compatibility
         * reasons defaults to dojo._scopeName (which is "dojo" except when
         * multi-version support is used, when it will be something like dojo16, dojo20, etc.)
         * 
         */
        "parserScope": string;
        set(property:"parserScope", value: string): void;
        get(property:"parserScope"): string;
        watch(property:"parserScope", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Force load of data on initialization even if pane is hidden.
         * 
         */
        "preload": boolean;
        set(property:"preload", value: boolean): void;
        get(property:"preload"): boolean;
        watch(property:"preload", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Prevent caching of data from href's by appending a timestamp to the href.
         * 
         */
        "preventCache": boolean;
        set(property:"preventCache", value: boolean): void;
        get(property:"preventCache"): boolean;
        watch(property:"preventCache", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Refresh (re-download) content when pane goes from hidden to shown
         * 
         */
        "refreshOnShow": boolean;
        set(property:"refreshOnShow", value: boolean): void;
        get(property:"refreshOnShow"): boolean;
        watch(property:"refreshOnShow", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * 
         */
        "stopParser": boolean;
        set(property:"stopParser", value: boolean): void;
        get(property:"stopParser"): boolean;
        watch(property:"stopParser", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Tabindex setting for the title (so users can tab to the title then
         * use space/enter to open/close the title pane)
         * 
         */
        "tabIndex": string;
        set(property:"tabIndex", value: string): void;
        get(property:"tabIndex"): string;
        watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Content of the legend tag. Overrides  tag if not empty.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Whether pane can be opened or closed by clicking the title bar.
         * 
         */
        "toggleable": boolean;
        set(property:"toggleable", value: boolean): void;
        get(property:"toggleable"): boolean;
        watch(property:"toggleable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Makes the given widget a child of this widget.
         * Inserts specified child widget's dom node as a child of this widget's
         * container node, and possibly does other processing (such as layout).
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex: number): void;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Cancels an in-flight download of content
         * 
         */
        cancel(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * 
         * @param params             
         * @param srcNodeRef             
         */
        create(params: any, srcNodeRef: any): void;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * 
         */
        destroy(): void;
        /**
         * Destroy all the widgets inside the ContentPane and empty containerNode
         * 
         * @param preserveDom             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy the ContentPane and its contents
         * 
         * @param preserveDom             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * Function that should grab the content specified via href.
         * 
         * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
         */
        ioMethod(args: Object): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param params             
         * @param node             
         * @param ctor             
         */
        markupFactory(params: any, node: any, ctor: any): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * 
         */
        postMixInProperties(): void;
        /**
         * [Re]download contents of href and display
         * cancels any currently in-flight requests
         * posts "loading..." message
         * sends XHR to download new data
         * 
         */
        refresh(): any;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;
        /**
         * See dijit/layout/_LayoutWidget.resize() for description.
         * Although ContentPane doesn't extend _LayoutWidget, it does implement
         * the same API.
         * 
         * @param changeSize             
         * @param resultSize             
         */
        resize(changeSize: any, resultSize: any): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: String): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: HTMLElement): void;
        /**
         * Deprecated.   Use set('content', ...) instead.
         * 
         * @param data             
         */
        setContent(data: NodeList): void;
        /**
         * Deprecated.   Use set('href', ...) instead.
         * 
         * @param href             
         */
        setHref(href: String): any;
        /**
         * Deprecated.   Use set('href', ...) instead.
         * 
         * @param href             
         */
        setHref(href: URL): any;
        /**
         * Deprecated.  Use set('title', ...) instead.
         * 
         * @param title             
         */
        setTitle(title: String): void;
        /**
         * Call startup() on all children including non _Widget ones like dojo/dnd/Source objects
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Called on DOM faults, require faults etc. in content.
         * 
         * In order to display an error message in the pane, return
         * the error message from this method, as an HTML string.
         * 
         * By default (if this method is not overriden), it returns
         * nothing, so the error message is just printed to the console.
         * 
         * @param error             
         */
        onContentError(error: Error): void;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when download is finished.
         * 
         */
        onDownloadEnd(): void;
        /**
         * Called when download error occurs.
         * 
         * In order to display an error message in the pane, return
         * the error message from this method, as an HTML string.
         * 
         * Default behavior (if this method is not overriden) is to display
         * the error message inside the pane.
         * 
         * @param error             
         */
        onDownloadError(error: Error): any;
        /**
         * Called before download starts.
         * The string returned by this function will be the html
         * that tells the user we are loading something.
         * Override with your own function if you want to change text.
         * 
         */
        onDownloadStart(): any;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Event hook, is called after everything is loaded and widgetified
         * 
         * @param data             
         */
        onLoad(data: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
        /**
         * Event hook, is called before old content is cleared
         * 
         */
        onUnload(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/DropDownMenu.html
     *
     * A menu, without features for context menu (Meaning, drop down menu)
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class DropDownMenu extends dijit._MenuBase implements dijit._OnDijitClickMixin {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * This Menu has been clicked (mouse or via space/arrow key) or opened as a submenu,
         * so mere mouseover will open submenus.  Focusing a menu via TAB does NOT automatically make it active
         * since TAB is a navigation operation and not a selection one.
         * For Windows apps, pressing the ALT key focuses the menubar menus (similar to TAB navigation) but the
         * menu is not active (ie no dropdown) until an item is clicked.
         * 
         */
        "activated": boolean;
        set(property:"activated", value: boolean): void;
        get(property:"activated"): boolean;
        watch(property:"activated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * A toggle to control whether or not a Menu gets focused when opened as a drop down from a MenuBar
         * or DropDownButton/ComboButton.   Note though that it always get focused when opened via the keyboard.
         * 
         */
        "autoFocus": boolean;
        set(property:"autoFocus", value: boolean): void;
        get(property:"autoFocus"): boolean;
        watch(property:"autoFocus", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * The currently focused child widget, or null if there isn't one
         * 
         */
        "focusedChild": Object;
        set(property:"focusedChild", value: Object): void;
        get(property:"focusedChild"): Object;
        watch(property:"focusedChild", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * If multiple characters are typed where each keystroke happens within
         * multiCharSearchDuration of the previous keystroke,
         * search for nodes matching all the keystrokes.
         * 
         * For example, typing "ab" will search for entries starting with
         * "ab" unless the delay between "a" and "b" is greater than multiCharSearchDuration.
         * 
         */
        "multiCharSearchDuration": number;
        set(property:"multiCharSearchDuration", value: number): void;
        get(property:"multiCharSearchDuration"): number;
        watch(property:"multiCharSearchDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to menu that displayed me
         * 
         */
        "parentMenu": Object;
        set(property:"parentMenu", value: Object): void;
        get(property:"parentMenu"): Object;
        watch(property:"parentMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * For a passive (unclicked) Menu, number of milliseconds before hovering (without clicking) will cause
         * the popup to open.  Default is Infinity, meaning you need to click the menu to open it.
         * 
         */
        "passivePopupDelay": number;
        set(property:"passivePopupDelay", value: number): void;
        get(property:"passivePopupDelay"): number;
        watch(property:"passivePopupDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * After a menu has been activated (by clicking on it etc.), number of milliseconds before hovering
         * (without clicking) another MenuItem causes that MenuItem's popup to automatically open.
         * 
         */
        "popupDelay": number;
        set(property:"popupDelay", value: number): void;
        get(property:"popupDelay"): number;
        watch(property:"popupDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Currently selected (a.k.a. highlighted) MenuItem, or null if no MenuItem is selected.
         * If a submenu is open, will be set to MenuItem that displayed the submenu.   OTOH, if
         * this Menu is in passive mode (i.e. hasn't been clicked yet), will be null, because
         * "selected" is not merely "hovered".
         * 
         */
        "selected": Object;
        set(property:"selected", value: Object): void;
        get(property:"selected"): Object;
        watch(property:"selected", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Tab index of the container; same as HTML tabIndex attribute.
         * Note then when user tabs into the container, focus is immediately
         * moved to the first item in the container.
         * 
         */
        "tabIndex": string;
        set(property:"tabIndex", value: string): void;
        get(property:"tabIndex"): string;
        watch(property:"tabIndex", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         * @param widget             
         * @param insertIndex               Optional            
         */
        addChild(widget: dijit._WidgetBase, insertIndex: number): void;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Selector (passed to on.selector()) used to identify MenuItem child widgets, but exclude inert children
         * like MenuSeparator.  If subclass overrides to a string (ex: "> *"), the subclass must require dojo/query.
         * 
         * @param node             
         */
        childSelector(node: HTMLElement): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Deprecated.  You can call this in postCreate() to attach the keyboard handlers to the container,
         * but the preferred method is to override _onLeftArrow() and _onRightArrow(), or
         * _onUpArrow() and _onDownArrow(), to call focusPrev() and focusNext().
         * 
         * @param prevKeyCodes Key codes for navigating to the previous child.             
         * @param nextKeyCodes Key codes for navigating to the next child.             
         */
        connectKeyNavHandlers(prevKeyCodes: dojo.keys, nextKeyCodes: dojo.keys): void;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Default focus() implementation: focus the first child.
         * 
         */
        focus(): void;
        /**
         * Focus specified child widget.
         * 
         * @param widget Reference to container's child widget             
         * @param last If true and if widget has multiple focusable nodes, focus thelast one instead of the first one             
         */
        focusChild(widget: dijit._WidgetBase, last: boolean): void;
        /**
         * Focus the first focusable child in the container.
         * 
         */
        focusFirstChild(): void;
        /**
         * Focus the last focusable child in the container.
         * 
         */
        focusLastChild(): void;
        /**
         * Focus the next widget
         * 
         */
        focusNext(): void;
        /**
         * Focus the last focusable node in the previous widget
         * (ex: go to the ComboButton icon section rather than button section)
         * 
         */
        focusPrev(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Gets the index of the child in this container or -1 if not found
         * 
         * @param child             
         */
        getIndexOfChild(child: dijit._WidgetBase): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
         * 
         */
        hasChildren(): boolean;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Called after the parameters to the widget have been read-in,
         * but before the widget template is instantiated. Especially
         * useful to set properties that are referenced in the widget
         * template.
         * 
         */
        postMixInProperties(): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: dijit._WidgetBase): void;
        /**
         * Removes the passed widget instance from this widget but does
         * not destroy it.  You can also pass in an integer indicating
         * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
         * 
         * @param widget             
         */
        removeChild(widget: number): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * 
         */
        startupKeyNavChildren(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Static method to get a template based on the templatePath or
         * templateString key
         */
        getCachedTemplate(): any;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Attach point for notification about when the user cancels the current menu
         * This is an internal mechanism used for Menus to signal to their parent to
         * close them.  In general developers should not attach to or override this method.
         * 
         * @param closeAll             
         */
        onCancel(closeAll: boolean): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Attach point for notification about when a menu item has been executed.
         * This is an internal mechanism used for Menus to signal to their parent to
         * close them, because they are about to execute the onClick handler.  In
         * general developers should not attach to or override this method.
         * 
         */
        onExecute(): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Called when cursor is over a MenuItem.
         * 
         * @param item             
         */
        onItemHover(item: dijit.MenuItem): void;
        /**
         * Callback fires when mouse exits a MenuItem
         * 
         * @param item             
         */
        onItemUnhover(item: dijit.MenuItem): void;
        /**
         * Attach point for notification about when a menu item has been searched for
         * via the keyboard search mechanism.
         * 
         * @param item             
         * @param evt             
         * @param searchString             
         * @param numMatches             
         */
        onKeyboardSearch(item: dijit.MenuItem, evt: Event, searchString: String, numMatches: number): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/Editor.html
     *
     * A rich text Editing widget
     * This widget provides basic WYSIWYG editing features, based on the browser's
     * underlying rich text editing capability, accompanied by a toolbar (dijit.Toolbar).
     * A plugin model is available to extend the editor's capabilities as well as the
     * the options available in the toolbar.  Content generation may vary across
     * browsers, and clipboard operations may have different results, to name
     * a few limitations.  Note: this widget should not be used with the HTML
     * <TEXTAREA> tag -- see dijit/_editor/RichText for details.
     * 
     * @param params Initial settings for any of the attributes, except readonly attributes.     
     * @param srcNodeRef The editor replaces the specified DOMNode.     
     */
    class Editor extends dijit._editor.RichText {
        constructor(params: Object, srcNodeRef: HTMLElement);
        /**
         * True if mouse was pressed while over this widget, and hasn't been released yet
         * 
         */
        "active": boolean;
        set(property:"active", value: boolean): void;
        get(property:"active"): boolean;
        watch(property:"active", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Events which should be connected to the underlying editing
         * area, events in this array will be addListener with
         * capture=true.
         * 
         */
        "captureEvents": Object;
        set(property:"captureEvents", value: Object): void;
        get(property:"captureEvents"): Object;
        watch(property:"captureEvents", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Subclasses may define a cssStateNodes property that lists sub-nodes within the widget that
         * need CSS classes applied on mouse hover/press and focus.
         * 
         * Each entry in this optional hash is a an attach-point name (like "upArrowButton") mapped to a CSS class name
         * (like "dijitUpArrowButton"). Example:
         * 
         * {
         *     "upArrowButton": "dijitUpArrowButton",
         *     "downArrowButton": "dijitDownArrowButton"
         * }
         * The above will set the CSS class dijitUpArrowButton to the this.upArrowButton DOMNode when it
         * 
         * is hovered, etc.
         * 
         */
        "cssStateNodes": Object;
        set(property:"cssStateNodes", value: Object): void;
        get(property:"cssStateNodes"): Object;
        watch(property:"cssStateNodes", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Whether we shall use custom undo/redo support instead of the native
         * browser support. By default, we now use custom undo.  It works better
         * than native browser support and provides a consistent behavior across
         * browsers with a minimal performance hit.  We already had the hit on
         * the slowest browser, IE, anyway.
         * 
         */
        "customUndo": boolean;
        set(property:"customUndo", value: boolean): void;
        get(property:"customUndo"): boolean;
        watch(property:"customUndo", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The editor is disabled; the text cannot be changed.
         * 
         */
        "disabled": boolean;
        set(property:"disabled", value: boolean): void;
        get(property:"disabled"): boolean;
        watch(property:"disabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * When true, disables the browser's native spell checking, if supported.
         * Works only in Firefox.
         * 
         */
        "disableSpellCheck": boolean;
        set(property:"disableSpellCheck", value: boolean): void;
        get(property:"disableSpellCheck"): boolean;
        watch(property:"disableSpellCheck", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * When using customUndo, not every keystroke will be saved as a step.
         * Instead typing (including delete) will be grouped together: after
         * a user stops typing for editActionInterval seconds, a step will be
         * saved; if a user resume typing within editActionInterval seconds,
         * the timeout will be restarted. By default, editActionInterval is 3
         * seconds.
         * 
         */
        "editActionInterval": number;
        set(property:"editActionInterval", value: number): void;
        get(property:"editActionInterval"): number;
        watch(property:"editActionInterval", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * A list of extra plugin names which will be appended to plugins array
         * 
         */
        "extraPlugins": Object;
        set(property:"extraPlugins", value: Object): void;
        get(property:"extraPlugins"): Object;
        watch(property:"extraPlugins", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Focus into this widget when the page is loaded
         * 
         */
        "focusOnLoad": boolean;
        set(property:"focusOnLoad", value: boolean): void;
        get(property:"focusOnLoad"): boolean;
        watch(property:"focusOnLoad", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Set height to fix the editor at a specific height, with scrolling.
         * By default, this is 300px.  If you want to have the editor always
         * resizes to accommodate the content, use AlwaysShowToolbar plugin
         * and set height="".  If this editor is used within a layout widget,
         * set height="100%".
         * 
         */
        "height": string;
        set(property:"height", value: string): void;
        get(property:"height"): string;
        watch(property:"height", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * True if cursor is over this widget
         * 
         */
        "hovering": boolean;
        set(property:"hovering", value: boolean): void;
        get(property:"hovering"): boolean;
        watch(property:"hovering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * whether to inherit the parent's width or simply use 100%
         * 
         */
        "inheritWidth": boolean;
        set(property:"inheritWidth", value: boolean): void;
        get(property:"inheritWidth"): boolean;
        watch(property:"inheritWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "isClosed": boolean;
        set(property:"isClosed", value: boolean): void;
        get(property:"isClosed"): boolean;
        watch(property:"isClosed", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * 
         */
        "isLoaded": boolean;
        set(property:"isLoaded", value: boolean): void;
        get(property:"isLoaded"): boolean;
        watch(property:"isLoaded", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Make tab key and shift-tab indent and outdent rather than navigating.
         * Caution: sing this makes web pages inaccessible to users unable to use a mouse.
         * 
         */
        "isTabIndent": boolean;
        set(property:"isTabIndent", value: boolean): void;
        get(property:"isTabIndent"): boolean;
        watch(property:"isTabIndent", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The minimum height that the editor should have.
         * 
         */
        "minHeight": string;
        set(property:"minHeight", value: string): void;
        get(property:"minHeight"): string;
        watch(property:"minHeight", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Specifies the name of a (hidden) <textarea> node on the page that's used to save
         * the editor content on page leave.   Used to restore editor contents after navigating
         * to a new page and then hitting the back button.
         * 
         */
        "name": Object;
        set(property:"name", value: Object): void;
        get(property:"name"): Object;
        watch(property:"name", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deferred which is fired when the editor finishes loading.
         * Call myEditor.onLoadDeferred.then(callback) it to be informed
         * when the rich-text area initialization is finalized.
         * 
         */
        "onLoadDeferred": Object;
        set(property:"onLoadDeferred", value: Object): void;
        get(property:"onLoadDeferred"): Object;
        watch(property:"onLoadDeferred", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * A list of plugin names (as strings) or instances (as objects)
         * for this widget.
         * 
         * When declared in markup, it might look like:
         * 
         * plugins="['bold',{name:'dijit._editor.plugins.FontChoice', command:'fontName', generic:true}]"
         * 
         */
        "plugins": Object;
        set(property:"plugins", value: Object): void;
        get(property:"plugins"): Object;
        watch(property:"plugins", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * semicolon (";") separated list of css files for the editing area
         * 
         */
        "styleSheets": string;
        set(property:"styleSheets", value: string): void;
        get(property:"styleSheets"): string;
        watch(property:"styleSheets", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "updateInterval": number;
        set(property:"updateInterval", value: number): void;
        get(property:"updateInterval"): number;
        watch(property:"updateInterval", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
        /**
         * Add a handler for a keyboard shortcut
         * 
         * @param key             
         * @param ctrl             
         * @param shift             
         * @param handler             
         */
        addKeyHandler(key: String, ctrl: boolean, shift: boolean, handler: Function): void;
        /**
         * Add a handler for a keyboard shortcut
         * 
         * @param key             
         * @param ctrl             
         * @param shift             
         * @param handler             
         */
        addKeyHandler(key: number, ctrl: boolean, shift: boolean, handler: Function): void;
        /**
         * takes a plugin name as a string or a plugin instance and
         * adds it to the toolbar and associates it with this editor
         * instance. The resulting plugin is added to the Editor's
         * plugins array. If index is passed, it's placed in the plugins
         * array at that index. No big magic, but a nice helper for
         * passing in plugin names via markup.
         * 
         * @param plugin String, args object, plugin instance, or plugin constructor             
         * @param index               OptionalUsed when creating an instance fromsomething already in this.plugins. Ensures that the newinstance is assigned to this.plugins at that index.             
         */
        addPlugin(plugin: String, index: number): void;
        /**
         * takes a plugin name as a string or a plugin instance and
         * adds it to the toolbar and associates it with this editor
         * instance. The resulting plugin is added to the Editor's
         * plugins array. If index is passed, it's placed in the plugins
         * array at that index. No big magic, but a nice helper for
         * passing in plugin names via markup.
         * 
         * @param plugin String, args object, plugin instance, or plugin constructor             
         * @param index               OptionalUsed when creating an instance fromsomething already in this.plugins. Ensures that the newinstance is assigned to this.plugins at that index.             
         */
        addPlugin(plugin: Object, index: number): void;
        /**
         * takes a plugin name as a string or a plugin instance and
         * adds it to the toolbar and associates it with this editor
         * instance. The resulting plugin is added to the Editor's
         * plugins array. If index is passed, it's placed in the plugins
         * array at that index. No big magic, but a nice helper for
         * passing in plugin names via markup.
         * 
         * @param plugin String, args object, plugin instance, or plugin constructor             
         * @param index               OptionalUsed when creating an instance fromsomething already in this.plugins. Ensures that the newinstance is assigned to this.plugins at that index.             
         */
        addPlugin(plugin: Function, index: number): void;
        /**
         * add an external stylesheet for the editing area
         * 
         * @param uri Url of the external css file             
         */
        addStyleSheet(uri: dojo._base.url): void;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * Remove focus from this instance.
         * 
         */
        blur(): void;
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * 
         */
        destroy(): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Main handler for executing any commands to the editor, like paste, bold, etc.
         * Called by plugins, but not meant to be called by end users.
         * 
         * @param cmd             
         */
        execCommand(cmd: any): any;
        /**
         * Move focus to this editor
         * 
         */
        focus(): void;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * A function for obtaining the height of the footer node
         * 
         */
        getFooterHeight(): any;
        /**
         * A function for obtaining the height of the header node
         * 
         */
        getHeaderHeight(): any;
        /**
         * Deprecated.   Use dijit/_editor/html::getChildrenHtml() instead.
         * 
         * @param dom             
         */
        getNodeChildrenHtml(dom: HTMLElement): any;
        /**
         * Deprecated.   Use dijit/_editor/html::_getNodeHtml() instead.
         * 
         * @param node             
         */
        getNodeHtml(node: HTMLElement): any;
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * Called from dijit/layout/_LayoutWidget.resize().  This shouldn't be called directly
         * 
         */
        layout(): void;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * Extension to make sure a deferred is in place before certain functions
         * execute, like making sure all the plugins are properly inserted.
         * 
         */
        postMixInProperties(): void;
        /**
         * Returns true if specified editor command is enabled.
         * Used by the plugins to know when to highlight/not highlight buttons.
         * 
         * @param cmd             
         */
        queryCommandEnabled(cmd: any): any;
        /**
         * Check the state of a given command and returns true or false.
         * 
         * @param command             
         */
        queryCommandState(command: any): any;
        /**
         * Check the value of a given command. This matters most for
         * custom selections and complex values like font value setting.
         * 
         * @param command             
         */
        queryCommandValue(command: any): any;
        /**
         * remove an external stylesheet for the editing area
         * 
         * @param uri             
         */
        removeStyleSheet(uri: dojo._base.url): void;
        /**
         * over-ride of replaceValue to support custom undo and stack maintenance.
         * 
         * @param html             
         */
        replaceValue(html: String): void;
        /**
         * Resize the editor to the specified size, see dijit/layout/_LayoutWidget.resize()
         * 
         * @param size             
         */
        resize(size: any): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated, use set('disabled', ...) instead.
         * 
         * @param disabled             
         */
        setDisabled(disabled: boolean): void;
        /**
         * Add some default key handlers
         * Overwrite this to setup your own handlers. The default
         * implementation does not use Editor commands, but directly
         * executes the builtin commands within the underlying browser
         * support.
         * 
         */
        setupDefaultShortcuts(): void;
        /**
         * This function sets the content. No undo history is preserved.
         * Users should use set('value', ...) instead.
         * 
         * @param html             
         */
        setValue(html: String): void;
        /**
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * 
         */
        onBeforeActivate(): void;
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * This is fired if and only if the editor loses focus and
         * the content is changed.
         * 
         * @param newContent             
         */
        onChange(newContent: any): void;
        /**
         * Handler for when editor is clicked
         * 
         */
        onClick(): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Handler for onkeyup event
         * 
         * @param e             
         */
        onKeyUp(e: any): void;
        /**
         * Handler after the iframe finishes loading.
         * 
         * @param html Editor contents should be set to this value             
         */
        onLoad(html: String): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/InlineEditBox.html
     *
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my valuereplace srcNodeRef with my generated DOM tree     
     */
    class InlineEditBox extends dijit._Widget {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Changing the value automatically saves it; don't have to push save button
         * (and save button isn't even displayed)
         * 
         */
        "autoSave": boolean;
        set(property:"autoSave", value: boolean): void;
        get(property:"autoSave"): boolean;
        watch(property:"autoSave", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Cancel button label
         * 
         */
        "buttonCancel": string;
        set(property:"buttonCancel", value: string): void;
        get(property:"buttonCancel"): string;
        watch(property:"buttonCancel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Save button label
         * 
         */
        "buttonSave": string;
        set(property:"buttonSave", value: string): void;
        get(property:"buttonSave"): string;
        watch(property:"buttonSave", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * If true, clicking the InlineEditBox to edit it will have no effect.
         * 
         */
        "disabled": boolean;
        set(property:"disabled", value: boolean): void;
        get(property:"disabled"): boolean;
        watch(property:"disabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Is the node currently in edit mode?
         * 
         */
        "editing": boolean;
        set(property:"editing", value: boolean): void;
        get(property:"editing"): boolean;
        watch(property:"editing", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * Set of parameters for editor, like {required: true}
         * 
         */
        "editorParams": Object;
        set(property:"editorParams", value: Object): void;
        get(property:"editorParams"): Object;
        watch(property:"editorParams", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The text that gets displayed when there is no value (so that the user has a place to click to edit)
         * 
         */
        "noValueIndicator": string;
        set(property:"noValueIndicator", value: string): void;
        get(property:"noValueIndicator"): string;
        watch(property:"noValueIndicator", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Set this to true if the specified Editor's value should be interpreted as HTML
         * rather than plain text (ex: dijit.Editor)
         * 
         */
        "renderAsHtml": boolean;
        set(property:"renderAsHtml", value: boolean): void;
        get(property:"renderAsHtml"): boolean;
        watch(property:"renderAsHtml", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The display value of the widget in read-only mode
         * 
         */
        "value": string;
        set(property:"value", value: string): void;
        get(property:"value"): string;
        watch(property:"value", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Width of editor.  By default it's width=100% (ie, block mode).
         * 
         */
        "width": string;
        set(property:"width", value: string): void;
        get(property:"width"): string;
        watch(property:"width", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: String, value: Object): any;
        /**
         * This method is deprecated, use get() or set() directly.
         * 
         * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
         * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
         */
        attr(name: Object, value: Object): any;
        /**
         * Construct the UI for this widget, setting this.domNode.
         * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * 
         */
        destroy(): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * MID (ex: "dijit/form/TextBox") or constructor for editor widget
         * 
         */
        editor(): void;
        /**
         * Class name (or reference to the Class) for widget that wraps the editor widget, displaying save/cancel
         * buttons.
         * 
         */
        editorWrapper(): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
         * is this widget.   Note that it does not return all descendants, but rather just direct children.
         * Analogous to Node.childNodes,
         * except containing widgets rather than DOMNodes.
         * 
         * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
         * outside of this.containerNode.
         * 
         * Note that the array returned is a simple array.  Application code should not assume
         * existence of methods like forEach().
         * 
         */
        getChildren(): any[];
        /**
         * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
         * This method should generally be avoided as it returns widgets declared in templates, which are
         * supposed to be internal/hidden, but it's left here for back-compat reasons.
         * 
         */
        getDescendants(): any[];
        /**
         * Returns the parent widget of this widget.
         * 
         */
        getParent(): any;
        /**
         * Deprecated.   Use get('value') instead.
         * 
         */
        getValue(): any;
        /**
         * Return true if this widget can currently be focused
         * and false if not
         * 
         */
        isFocusable(): any;
        /**
         * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
         * 
         */
        isLeftToRight(): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: String, func: Function): any;
        /**
         * 
         * @param type protected             
         * @param func             
         */
        on(type: Function, func: Function): any;
        /**
         * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
         * already removed/destroyed manually.
         * 
         */
        own(): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: String): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: String, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: HTMLElement, position: number): any;
        /**
         * Place this widget somewhere in the DOM based
         * on standard domConstruct.place() conventions.
         * A convenience function provided in all _Widgets, providing a simple
         * shorthand mechanism to put an existing (or newly created) Widget
         * somewhere in the dom, and allow chaining.
         * 
         * @param reference Widget, DOMNode, or id of widget or DOMNode             
         * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
         */
        placeAt(reference: dijit._WidgetBase, position: number): any;
        /**
         * 
         */
        postCreate(): void;
        /**
         * 
         */
        postMixInProperties(): void;
        /**
         * Set a property on a widget
         * Sets named properties on a widget which may potentially be handled by a
         * setter in the widget.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _setFooAttr(), calling
         * myWidget.set("foo", "Howdy!") would be equivalent to calling
         * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
         * would be equivalent to the statement widget.bar = 3;
         * 
         * set() may also be called with a hash of name/value pairs, ex:
         * 
         * myWidget.set({
         *     foo: "Howdy",
         *     bar: 3
         * });
         * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: any, value: any): any;
        /**
         * Deprecated.  Use set() instead.
         * 
         * @param attr             
         * @param value             
         */
        setAttribute(attr: String, value: any): void;
        /**
         * Deprecated.   Use set('disabled', ...) instead.
         * 
         * @param disabled             
         */
        setDisabled(disabled: boolean): void;
        /**
         * Deprecated.   Use set('value', ...) instead.
         * 
         * @param val             
         */
        setValue(val: String): any;
        /**
         * Processing after the DOM fragment is added to the document
         * Called after a widget and its children have been created and added to the page,
         * and all related widgets have finished their create() cycle, up through postCreate().
         * 
         * Note that startup() may be called while the widget is still hidden, for example if the widget is
         * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
         * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
         * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
         * 
         */
        startup(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
         * 
         * Subscribes to the specified topic and calls the specified method
         * of this object and registers for unsubscribe() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.subscribe, except with the
         * implicit use of this widget as the target object.
         * 
         * @param t The topic             
         * @param method The callback             
         */
        subscribe(t: String, method: Function): any;
        /**
         * Returns a string that represents the widget.
         * When a widget is cast to a string, this method will be used to generate the
         * output. Currently, it does not implement any sort of reversible
         * serialization.
         * 
         */
        toString(): string;
        /**
         * Deprecated. Override destroy() instead to implement custom widget tear-down
         * behavior.
         * 
         */
        uninitialize(): boolean;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Unsubscribes handle created by this.subscribe.
         * Also removes handle from this widget's list of subscriptions
         * 
         * @param handle             
         */
        unsubscribe(handle: Object): void;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        /**
         * Called when the widget stops being "active" because
         * focus moved to something outside of it, or the user
         * clicked somewhere outside of it, or the widget was
         * hidden.
         * 
         */
        onBlur(): void;
        /**
         * Set this handler to be notified when editing is cancelled.
         * 
         */
        onCancel(): void;
        /**
         * Set this handler to be notified of changes to value.
         * 
         * @param value             
         */
        onChange(value: any): void;
        /**
         * Connect to this function to receive notifications of mouse click events.
         * 
         * @param event mouse Event             
         */
        onClick(event: any): void;
        /**
         * Called when this widget is being displayed as a popup (ex: a Calendar popped
         * up from a DateTextBox), and it is hidden.
         * This is called from the dijit.popup code, and should not be called directly.
         * 
         * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
         * Callback if a user tries to close the child.   Child will be closed if this function returns true.
         * 
         */
        onClose(): boolean;
        /**
         * Connect to this function to receive notifications of mouse double click events.
         * 
         * @param event mouse Event             
         */
        onDblClick(event: any): void;
        /**
         * Called when the widget becomes "active" because
         * it or a widget inside of it either has focus, or has recently
         * been clicked.
         * 
         */
        onFocus(): void;
        /**
         * Called when another widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onHide(): void;
        /**
         * Connect to this function to receive notifications of keys being pressed down.
         * 
         * @param event key Event             
         */
        onKeyDown(event: any): void;
        /**
         * Connect to this function to receive notifications of printable keys being typed.
         * 
         * @param event key Event             
         */
        onKeyPress(event: any): void;
        /**
         * Connect to this function to receive notifications of keys being released.
         * 
         * @param event key Event             
         */
        onKeyUp(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is pressed down.
         * 
         * @param event mouse Event             
         */
        onMouseDown(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto this widget.
         * 
         * @param event mouse Event             
         */
        onMouseEnter(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of this widget.
         * 
         * @param event mouse Event             
         */
        onMouseLeave(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseMove(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOut(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
         * 
         * @param event mouse Event             
         */
        onMouseOver(event: any): void;
        /**
         * Connect to this function to receive notifications of when the mouse button is released.
         * 
         * @param event mouse Event             
         */
        onMouseUp(event: any): void;
        /**
         * Called when this widget becomes the selected pane in a
         * dijit/layout/TabContainer, dijit/layout/StackContainer,
         * dijit/layout/AccordionContainer, etc.
         * 
         * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
         * 
         */
        onShow(): void;
    }
    module InlineEditBox {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dijit/InlineEditBox._InlineEditor.html
         *
         * Internal widget used by InlineEditBox, displayed when in editing mode
         * to display the editor and maybe save/cancel buttons.  Calling code should
         * connect to save/cancel methods to detect when editing is finished
         * 
         * Has mainly the same parameters as InlineEditBox, plus these values:
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _InlineEditor extends dijit._Widget implements dijit._TemplatedMixin, dijit._WidgetsInTemplateMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Set of CSS attributes of display node, to replicate in editor
             * 
             */
            "style": Object;
            set(property:"style", value: Object): void;
            get(property:"style"): Object;
            watch(property:"style", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Value as an HTML string or plain text string, depending on renderAsHTML flag
             * 
             */
            "value": string;
            set(property:"value", value: string): void;
            get(property:"value"): string;
            watch(property:"value", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Should we parse the template to find widgets that might be
             * declared in markup inside it?  (Remove for 2.0 and assume true)
             * 
             */
            "widgetsInTemplate": boolean;
            set(property:"widgetsInTemplate", value: boolean): void;
            get(property:"widgetsInTemplate"): boolean;
            watch(property:"widgetsInTemplate", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * 
             */
            contextRequire(): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom?: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom?: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * User overridable function returning a Boolean to indicate
             * if the Save button should be enabled or not - usually due to invalid conditions
             * 
             */
            enableSave(): boolean;
            /**
             * Focus the edit widget.
             * 
             */
            focus(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return the [display] value of the edit widget
             * 
             */
            getValue(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dijit/MenuSeparator.html
     *
     * A line between two menu items
     * 
     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
     */
    class MenuSeparator extends dijit._WidgetBase implements dijit._TemplatedMixin, dijit._Contained {
        constructor(params?: Object, srcNodeRef?: HTMLElement);
        /**
         * Object to which attach points and events will be scoped.  Defaults
         * to 'this'.
         * 
         */
        "attachScope": Object;
        set(property:"attachScope", value: Object): void;
        get(property:"attachScope"): Object;
        watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
         * for each XXX attribute to be mapped to the DOM.
         * 
         * attributeMap sets up a "binding" between attributes (aka properties)
         * of the widget and the widget's DOM.
         * Changes to widget attributes listed in attributeMap will be
         * reflected into the DOM.
         * 
         * For example, calling set('title', 'hello')
         * on a TitlePane will automatically cause the TitlePane's DOM to update
         * with the new title.
         * 
         * attributeMap is a hash where the key is an attribute of the widget,
         * and the value reflects a binding to a:
         * 
         * DOM node attribute
         *   focus: {node: "focusNode", type: "attribute"}
         * Maps this.focus to this.focusNode.focus
         * 
         * DOM node innerHTML
         *   title: { node: "titleNode", type: "innerHTML" }
         * Maps this.title to this.titleNode.innerHTML
         * 
         * DOM node innerText
         *   title: { node: "titleNode", type: "innerText" }
         * Maps this.title to this.titleNode.innerText
         * 
         * DOM node CSS class
         *   myClass: { node: "domNode", type: "class" }
         * Maps this.myClass to this.domNode.className
         * 
         * If the value is an array, then each element in the array matches one of the
         * formats of the above list.
         * 
         * There are also some shorthands for backwards compatibility:
         * 
         * string --> { node: string, type: "attribute" }, for example:
         * "focusNode" ---> { node: "focusNode", type: "attribute" }
         * "" --> { node: "domNode", type: "attribute" }
         * 
         */
        "attributeMap": Object;
        set(property:"attributeMap", value: Object): void;
        get(property:"attributeMap"): Object;
        watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
         * widget state.
         * 
         */
        "baseClass": string;
        set(property:"baseClass", value: string): void;
        get(property:"baseClass"): string;
        watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "class": string;
        set(property:"class", value: string): void;
        get(property:"class"): string;
        watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Designates where children of the source DOM node will be placed.
         * "Children" in this case refers to both DOM nodes and widgets.
         * For example, for myWidget:
         * 
         * <div data-dojo-type=myWidget>
         *     <b> here's a plain DOM node
         *     <span data-dojo-type=subWidget>and a widget</span>
         *     <i> and another plain DOM node </i>
         * </div>
         * containerNode would point to:
         * 
         * <b> here's a plain DOM node
         * <span data-dojo-type=subWidget>and a widget</span>
         * <i> and another plain DOM node </i>
         * In templated widgets, "containerNode" is set via a
         * data-dojo-attach-point assignment.
         * 
         * containerNode must be defined for any widget that accepts innerHTML
         * (like ContentPane or BorderContainer or even Button), and conversely
         * is null for widgets that don't, like TextBox.
         * 
         */
        "containerNode": HTMLElement;
        set(property:"containerNode", value: HTMLElement): void;
        get(property:"containerNode"): HTMLElement;
        watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * Bi-directional support, as defined by the HTML DIR
         * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
         * default direction.
         * 
         */
        "dir": string;
        set(property:"dir", value: string): void;
        get(property:"dir"): string;
        watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * This is our visible representation of the widget! Other DOM
         * Nodes may by assigned to other properties, usually through the
         * template system's data-dojo-attach-point syntax, but the domNode
         * property is the canonical "top level" node in widget UI.
         * 
         */
        "domNode": HTMLElement;
        set(property:"domNode", value: HTMLElement): void;
        get(property:"domNode"): HTMLElement;
        watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * This widget or a widget it contains has focus, or is "active" because
         * it was recently clicked.
         * 
         */
        "focused": boolean;
        set(property:"focused", value: boolean): void;
        get(property:"focused"): boolean;
        watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * A unique, opaque ID string that can be assigned by users or by the
         * system. If the developer passes an ID which is known not to be
         * unique, the specified ID is ignored and the system-generated ID is
         * used instead.
         * 
         */
        "id": string;
        set(property:"id", value: string): void;
        get(property:"id"): string;
        watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Rarely used.  Overrides the default Dojo locale used to render this widget,
         * as defined by the HTML LANG attribute.
         * Value must be among the list of locales specified during by the Dojo bootstrap,
         * formatted according to RFC 3066 (like en-us).
         * 
         */
        "lang": string;
        set(property:"lang", value: string): void;
        get(property:"lang"): string;
        watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * The document this widget belongs to.  If not specified to constructor, will default to
         * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
         * 
         */
        "ownerDocument": Object;
        set(property:"ownerDocument", value: Object): void;
        get(property:"ownerDocument"): Object;
        watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
        /**
         * 
         */
        "searchContainerNode": boolean;
        set(property:"searchContainerNode", value: boolean): void;
        get(property:"searchContainerNode"): boolean;
        watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
        /**
         * pointer to original DOM node
         * 
         */
        "srcNodeRef": HTMLElement;
        set(property:"srcNodeRef", value: HTMLElement): void;
        get(property:"srcNodeRef"): HTMLElement;
        watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
        /**
         * HTML style attributes as cssText string or name/value hash
         * 
         */
        "style": string;
        set(property:"style", value: string): void;
        get(property:"style"): string;
        watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * Path to template (HTML file) for this widget relative to dojo.baseUrl.
         * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
         * 
         */
        "templatePath": string;
        set(property:"templatePath", value: string): void;
        get(property:"templatePath"): string;
        watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        "templateString": string;
        set(property:"templateString", value: string): void;
        get(property:"templateString"): string;
        watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * HTML title attribute.
         * 
         * For form widgets this specifies a tooltip to display when hovering over
         * the widget (just like the native HTML title attribute).
         * 
         * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
         * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
         * interpreted as HTML.
         * 
         */
        "title": string;
        set(property:"title", value: string): void;
        get(property:"title"): string;
        watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
         * this specifies the tooltip to appear when the mouse is hovered over that text.
         * 
         */
        "tooltip": string;
        set(property:"tooltip", value: string): void;
        get(property:"tooltip"): string;
        watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
        /**
         * 
         */
        buildRendering(): void;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: String): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: String, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: Object, event: Function, method: Function): any;
        /**
         * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
         * 
         * Connects specified obj/event to specified method of this object
         * and registers for disconnect() on widget destroy.
         * 
         * Provide widget-specific analog to dojo.connect, except with the
         * implicit use of this widget as the target object.
         * Events connected with this.connect are disconnected upon
         * destruction.
         * 
         * @param obj             
         * @param event             
         * @param method             
         */
        connect(obj: any, event: Function, method: Function): any;
        /**
         * Wrapper to setTimeout to avoid deferred functions executing
         * after the originating widget has been destroyed.
         * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
         * 
         * @param fcn Function reference.             
         * @param delay               OptionalDelay, defaults to 0.             
         */
        defer(fcn: Function, delay: number): Object;
        /**
         * Destroy this widget, but not its descendants.  Descendants means widgets inside of
         * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
         * 
         * This method will also destroy internal widgets such as those created from a template,
         * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
         * 
         * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
         * depend on the current ability to destroy a widget without destroying its descendants.   Generally
         * they should use destroyRecursive() for widgets with children.
         * 
         * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
         */
        destroy(preserveDom?: boolean): void;
        /**
         * Recursively destroy the children of this widget and their
         * descendants.
         * 
         * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
         */
        destroyDescendants(preserveDom?: boolean): void;
        /**
         * Destroy this widget and its descendants
         * This is the generic "destructor" function that all widget users
         * should call to cleanly discard with a widget. Once a widget is
         * destroyed, it is removed from the manager object.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
         */
        destroyRecursive(preserveDom?: boolean): void;
        /**
         * Destroys the DOM nodes associated with this widget.
         * 
         * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
         */
        destroyRendering(preserveDom?: boolean): void;
        /**
         * Deprecated, will be removed in 2.0, use handle.remove() instead.
         * 
         * Disconnects handle created by connect.
         * 
         * @param handle             
         */
        disconnect(handle: any): void;
        /**
         * Used by widgets to signal that a synthetic event occurred, ex:
         * 
         * myWidget.emit("attrmodified-selectedChildWidget", {}).
         * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
         * Also calls onType() method, if present, and returns value from that method.
         * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
         * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
         * 
         * @param type             
         * @param eventObj               Optional            
         * @param callbackArgs               Optional            
         */
        emit(type: String, eventObj: Object, callbackArgs: any[]): any;
        /**
         * Get a property from a widget.
         * Get a named property from a widget. The property may
         * potentially be retrieved via a getter method. If no getter is defined, this
         * just retrieves the object's property.
         * 
         * For example, if the widget has properties foo and bar
         * and a method named _getFooAttr(), calling:
         * myWidget.get("foo") would be equivalent to calling
         * widget._getFooAttr() and myWidget.get("bar")
         * would be equivalent to the expression
         * widget.bar2
         * 
         * @param name The property to get.             
         */
        get(name: any): any;
        /**
         * Returns all direct children of this widget, i.e. all widgets underneath this.con