// Type definitions for Dojo v1.9
// Project: http://dojotoolkit.org
// Definitions by: Michael Van Sickle <https://github.com/vansimke>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

declare function define(dependencies: String[], factory: Function): any;
declare function require(config?:Object, dependencies?: String[], callback?: Function): any;

declare module dojox.dtl {
    interface __StringArgs { }
    interface __ObjectArgs { }
}

declare module dojo {
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/request.html
     *
     * Send a request using the default transport for the current platform.
     * 
     * @param url The URL to request.     
     * @param options       OptionalOptions for the request.     
     */
    interface request { (url: String, options?: dojo.request.__Options): void }
    interface request {
        /**
         * Send an HTTP DELETE request using the default transport for the current platform.
         * 
         * @param url URL to request             
         * @param options               OptionalOptions for the request.             
         */
        del(url: String, options?: dojo.request.__BaseOptions): dojo.request.__Promise;
        /**
         * Send an HTTP GET request using the default transport for the current platform.
         * 
         * @param url URL to request             
         * @param options               OptionalOptions for the request.             
         */
        get(url: String, options?: dojo.request.__BaseOptions): dojo.request.__Promise;
        /**
         * Send an HTTP POST request using the default transport for the current platform.
         * 
         * @param url URL to request             
         * @param options               OptionalOptions for the request.             
         */
        post(url: String, options?: dojo.request.__BaseOptions): any;
        /**
         * Send an HTTP POST request using the default transport for the current platform.
         * 
         * @param url URL to request             
         * @param options               OptionalOptions for the request.             
         */
        put(url: String, options?: dojo.request.__BaseOptions): dojo.request.__Promise;
    }

    module request {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/handlers.html
         *
         * 
         * @param response     
         */
        interface handlers { (response: any): void }
        interface handlers {
            /**
             * 
             * @param name             
             * @param handler             
             */
            register(name: any, handler: any): void;
        }

        module handlers {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/iframe.html
         *
         * Sends a request using an iframe element with the given URL and options.
         * 
         * @param url URL to request     
         * @param options       OptionalOptions for the request.     
         */
        interface iframe { (url: String, options?: dojo.request.iframe.__Options): void }
        interface iframe {
            /**
             * 
             * @param name             
             * @param onloadstr             
             * @param uri             
             */
            create(name: any, onloadstr: any, uri: any): any;
            /**
             * 
             * @param iframeNode             
             */
            doc(iframeNode: any): any;
            /**
             * Send an HTTP GET request using an iframe element with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            get(url: String, options: dojo.request.iframe.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP POST request using an iframe element with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            post(url: String, options: dojo.request.iframe.__BaseOptions): dojo.request.__Promise;
            /**
             * 
             * @param _iframe             
             * @param src             
             * @param replace             
             */
            setSrc(_iframe: any, src: any, replace: any): void;
        }

        module iframe {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/iframe.__MethodOptions.html
             *
             * 
             */
            class __MethodOptions {
                constructor();
                /**
                 * The HTTP method to use to make the request. Must be
                 * uppercase. Only "GET" and "POST" are accepted.
                 * Default is "POST".
                 * 
                 */
                "method": string;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/iframe.__BaseOptions.html
             *
             * 
             */
            class __BaseOptions {
                constructor();
                /**
                 * Data to transfer. When making a GET request, this will
                 * be converted to key=value parameters and appended to the
                 * URL.
                 * 
                 */
                "data": string;
                /**
                 * A form node to use to submit data to the server.
                 * 
                 */
                "form": HTMLElement;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/iframe.__Options.html
             *
             * 
             */
            class __Options {
                constructor();
                /**
                 * Data to transfer. When making a GET request, this will
                 * be converted to key=value parameters and appended to the
                 * URL.
                 * 
                 */
                "data": string;
                /**
                 * A form node to use to submit data to the server.
                 * 
                 */
                "form": HTMLElement;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * The HTTP method to use to make the request. Must be
                 * uppercase. Only "GET" and "POST" are accepted.
                 * Default is "POST".
                 * 
                 */
                "method": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/notify.html
         *
         * Register a listener to be notified when an event
         * in dojo/request happens.
         * 
         * @param type       OptionalThe event to listen for. Events emitted: "start", "send","load", "error", "done", "stop".     
         * @param listener       OptionalA callback to be run when an event happens.     
         */
        interface notify { (type?: String, listener?: Function): void }
        interface notify {
            /**
             * 
             * @param type             
             * @param event             
             * @param cancel             
             */
            emit(type: any, event: any, cancel: any): void;
        }

        module notify {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/registry.html
         *
         * 
         * @param url     
         * @param options     
         */
        interface registry { (url: any, options: any): void }
        interface registry {
            /**
             * 
             * @param id             
             * @param parentRequire             
             * @param loaded             
             * @param config             
             */
            load(id: any, parentRequire: any, loaded: any, config: any): void;
            /**
             * 
             * @param url             
             * @param provider             
             * @param first             
             */
            register(url: any, provider: any, first: any): void;
        }

        module registry {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/node.html
         *
         * Sends a request using the included http or https interface from node.js
         * with the given URL and options.
         * 
         * @param url URL to request     
         * @param options       OptionalOptions for the request.     
         */
        interface node { (url: String, options?: dojo.request.node.__Options): void }
        interface node {
            /**
             * Send an HTTP DELETE request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            del(url: String, options: dojo.request.node.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP GET request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            get(url: String, options: dojo.request.node.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP POST request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            post(url: String, options: dojo.request.node.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP PUT request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            put(url: String, options: dojo.request.node.__BaseOptions): dojo.request.__Promise;
        }

        module node {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/node.__MethodOptions.html
             *
             * 
             */
            class __MethodOptions {
                constructor();
                /**
                 * The HTTP method to use to make the request. Must be
                 * uppercase. Default is "GET".
                 * 
                 */
                "method": string;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/node.__Options.html
             *
             * 
             */
            class __Options {
                constructor();
                /**
                 * Data to transfer. This is ignored for GET and DELETE
                 * requests.
                 * 
                 */
                "data": string;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * Headers to use for the request.
                 * 
                 */
                "headers": Object;
                /**
                 * The HTTP method to use to make the request. Must be
                 * uppercase. Default is "GET".
                 * 
                 */
                "method": string;
                /**
                 * Password to use during the request.
                 * 
                 */
                "password": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
                /**
                 * Username to use during the request.
                 * 
                 */
                "user": string;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/node.__BaseOptions.html
             *
             * 
             */
            class __BaseOptions {
                constructor();
                /**
                 * Data to transfer. This is ignored for GET and DELETE
                 * requests.
                 * 
                 */
                "data": string;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * Headers to use for the request.
                 * 
                 */
                "headers": Object;
                /**
                 * Password to use during the request.
                 * 
                 */
                "password": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
                /**
                 * Username to use during the request.
                 * 
                 */
                "user": string;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/watch.html
         *
         * Watches the io request represented by dfd to see if it completes.
         * 
         * @param dfd The Deferred object to watch.     
         */
        interface watch { (dfd: dojo.Deferred): void }
        interface watch {
            /**
             * Function used to check if basic IO call worked. Gets the dfd
             * object as its only argument.
             * 
             */
            ioCheck: Function;
            /**
             * Function used to process response. Gets the dfd
             * object as its only argument.
             * 
             */
            resHandle: Function;
            /**
             * Function used to check if the IO request is still valid. Gets the dfd
             * object as its only argument.
             * 
             */
            validCheck: Function;
            /**
             * Cancels all pending IO requests, regardless of IO type
             * 
             */
            cancelAll(): void;
        }

        module watch {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/script.html
         *
         * Sends a request using a script element with the given URL and options.
         * 
         * @param url URL to request     
         * @param options       OptionalOptions for the request.     
         */
        interface script { (url: String, options?: dojo.request.script.__Options): void }
        interface script {
            /**
             * Send an HTTP GET request using a script element with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            get(url: String, options: dojo.request.script.__BaseOptions): dojo.request.__Promise;
        }

        module script {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/script.__MethodOptions.html
             *
             * 
             */
            class __MethodOptions {
                constructor();
                /**
                 * This option is ignored. All requests using this transport are
                 * GET requests.
                 * 
                 */
                "method": string;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/script.__BaseOptions.html
             *
             * 
             */
            class __BaseOptions {
                constructor();
                /**
                 * A string of JavaScript that when evaluated like so:
                 * "typeof(" + checkString + ") != 'undefined'"
                 * being true means that the script fetched has been loaded.
                 * Do not use this if doing a JSONP type of call (use jsonp instead).
                 * 
                 */
                "checkString": string;
                /**
                 * Data to transfer.  This is ignored for GET and DELETE
                 * requests.
                 * 
                 */
                "data": string;
                /**
                 * The Document object of a child iframe. If this is passed in, the script
                 * will be attached to that document. This can be helpful in some comet long-polling
                 * scenarios with Firefox and Opera.
                 * 
                 */
                "frameDoc": Object;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * The URL parameter name that indicates the JSONP callback string.
                 * For instance, when using Yahoo JSONP calls it is normally,
                 * jsonp: "callback". For AOL JSONP calls it is normally
                 * jsonp: "c".
                 * 
                 */
                "jsonp": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/script.__Options.html
             *
             * 
             */
            class __Options {
                constructor();
                /**
                 * A string of JavaScript that when evaluated like so:
                 * "typeof(" + checkString + ") != 'undefined'"
                 * being true means that the script fetched has been loaded.
                 * Do not use this if doing a JSONP type of call (use jsonp instead).
                 * 
                 */
                "checkString": string;
                /**dojo
                 * Data to transfer.  This is ignored for GET and DELETE
                 * requests.
                 * 
                 */
                "data": string;
                /**
                 * The Document object of a child iframe. If this is passed in, the script
                 * will be attached to that document. This can be helpful in some comet long-polling
                 * scenarios with Firefox and Opera.
                 * 
                 */
                "frameDoc": Object;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * The URL parameter name that indicates the JSONP callback string.
                 * For instance, when using Yahoo JSONP calls it is normally,
                 * jsonp: "callback". For AOL JSONP calls it is normally
                 * jsonp: "c".
                 * 
                 */
                "jsonp": string;
                /**
                 * This option is ignored. All requests using this transport are
                 * GET requests.
                 * 
                 */
                "method": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/xhr.html
         *
         * Sends a request using XMLHttpRequest with the given URL and options.
         * 
         * @param url URL to request     
         * @param options       OptionalOptions for the request.     
         */
        interface xhr { (url: String, options?: dojo.request.xhr.__Options): void }
        interface xhr {
            /**
             * Send an HTTP DELETE request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            del(url: String, options: dojo.request.xhr.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP GET request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            get(url: String, options: dojo.request.xhr.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP POST request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            post(url: String, options: dojo.request.xhr.__BaseOptions): dojo.request.__Promise;
            /**
             * Send an HTTP PUT request using XMLHttpRequest with the given URL and options.
             * 
             * @param url URL to request             
             * @param options               OptionalOptions for the request.             
             */
            put(url: String, options: dojo.request.xhr.__BaseOptions): dojo.request.__Promise;
        }

        module xhr {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/xhr.__BaseOptions.html
             *
             * 
             */
            class __BaseOptions {
                constructor();
                /**
                 * Data to transfer. This is ignored for GET and DELETE
                 * requests.
                 * 
                 */
                "data": string;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * Headers to use for the request.
                 * 
                 */
                "headers": Object;
                /**
                 * Password to use during the request.
                 * 
                 */
                "password": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Whether to make a synchronous request or not. Default
                 * is false (asynchronous).
                 * 
                 */
                "sync": boolean;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
                /**
                 * Username to use during the request.
                 * 
                 */
                "user": string;
                /**
                 * For cross-site requests, whether to send credentials
                 * or not.
                 * 
                 */
                "withCredentials": boolean;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/xhr.__MethodOptions.html
             *
             * 
             */
            class __MethodOptions {
                constructor();
                /**
                 * The HTTP method to use to make the request. Must be
                 * uppercase. Default is "GET".
                 * 
                 */
                "method": string;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/xhr.__Options.html
             *
             * 
             */
            class __Options {
                constructor();
                /**
                 * Data to transfer. This is ignored for GET and DELETE
                 * requests.
                 * 
                 */
                "data": string;
                /**
                 * How to handle the response from the server.  Default is
                 * 'text'.  Other values are 'json', 'javascript', and 'xml'.
                 * 
                 */
                "handleAs": string;
                /**
                 * Headers to use for the request.
                 * 
                 */
                "headers": Object;
                /**
                 * The HTTP method to use to make the request. Must be
                 * uppercase. Default is "GET".
                 * 
                 */
                "method": string;
                /**
                 * Password to use during the request.
                 * 
                 */
                "password": string;
                /**
                 * Whether to append a cache-busting parameter to the URL.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Query parameters to append to the URL.
                 * 
                 */
                "query": string;
                /**
                 * Whether to make a synchronous request or not. Default
                 * is false (asynchronous).
                 * 
                 */
                "sync": boolean;
                /**
                 * Milliseconds to wait for the response.  If this time
                 * passes, the then the promise is rejected.
                 * 
                 */
                "timeout": number;
                /**
                 * Username to use during the request.
                 * 
                 */
                "user": string;
                /**
                 * For cross-site requests, whether to send credentials
                 * or not.
                 * 
                 */
                "withCredentials": boolean;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request.__BaseOptions.html
         *
         * 
         */
        class __BaseOptions {
            constructor();
            /**
             * Data to transfer.  This is ignored for GET and DELETE
             * requests.
             * 
             */
            "data": string;
            /**
             * How to handle the response from the server.  Default is
             * 'text'.  Other values are 'json', 'javascript', and 'xml'.
             * 
             */
            "handleAs": string;
            /**
             * Whether to append a cache-busting parameter to the URL.
             * 
             */
            "preventCache": boolean;
            /**
             * Query parameters to append to the URL.
             * 
             */
            "query": string;
            /**
             * Milliseconds to wait for the response.  If this time
             * passes, the then the promise is rejected.
             * 
             */
            "timeout": number;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request.__MethodOptions.html
         *
         * 
         */
        class __MethodOptions {
            constructor();
            /**
             * The HTTP method to use to make the request.  Must be
             * uppercase.
             * 
             */
            "method": string;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request.__Options.html
         *
         * 
         */
        class __Options {
            constructor();
            /**
             * Data to transfer.  This is ignored for GET and DELETE
             * requests.
             * 
             */
            "data": string;
            /**
             * How to handle the response from the server.  Default is
             * 'text'.  Other values are 'json', 'javascript', and 'xml'.
             * 
             */
            "handleAs": string;
            /**
             * The HTTP method to use to make the request.  Must be
             * uppercase.
             * 
             */
            "method": string;
            /**
             * Whether to append a cache-busting parameter to the URL.
             * 
             */
            "preventCache": boolean;
            /**
             * Query parameters to append to the URL.
             * 
             */
            "query": string;
            /**
             * Milliseconds to wait for the response.  If this time
             * passes, the then the promise is rejected.
             * 
             */
            "timeout": number;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request.__Promise.html
         *
         * 
         */
        class __Promise implements dojo.promise.Promise<any> {
            constructor();
            /**
             * A promise resolving to an object representing
             * the response from the server.
             * 
             */
            "response": Object;
            /**
             * Add a callback to be invoked when the promise is resolved
             * or rejected.
             * 
             * @param callbackOrErrback               OptionalA function that is used both as a callback and errback.             
             */
            always(callbackOrErrback: Function): any;
            /**
             * Inform the deferred it may cancel its asynchronous operation.
             * Inform the deferred it may cancel its asynchronous operation.
             * The deferred's (optional) canceler is invoked and the
             * deferred will be left in a rejected state. Can affect other
             * promises that originate with the same deferred.
             * 
             * @param reason A message that may be sent to the deferred's canceler,explaining why it's being canceled.             
             * @param strict               OptionalIf strict, will throw an error if the deferred has alreadybeen fulfilled and consequently cannot be canceled.             
             */
            cancel(reason: any, strict: boolean): any;
            /**
             * Checks whether the promise has been canceled.
             * 
             */
            isCanceled(): boolean;
            /**
             * Checks whether the promise has been resolved or rejected.
             * 
             */
            isFulfilled(): boolean;
            /**
             * Checks whether the promise has been rejected.
             * 
             */
            isRejected(): boolean;
            /**
             * Checks whether the promise has been resolved.
             * 
             */
            isResolved(): boolean;
            /**
             * Add new errbacks to the promise.
             * 
             * @param errback               OptionalCallback to be invoked when the promise is rejected.             
             */
            otherwise(errback: Function): any;
            /**
             * Add new callbacks to the promise.
             * Add new callbacks to the deferred. Callbacks can be added
             * before or after the deferred is fulfilled.
             * 
             * @param callback               OptionalCallback to be invoked when the promise is resolved.Receives the resolution value.             
             * @param errback               OptionalCallback to be invoked when the promise is rejected.Receives the rejection error.             
             * @param progback               OptionalCallback to be invoked when the promise emits a progressupdate. Receives the progress update.             
             */
            then(callback?: Function, errback?: Function, progback?: Function): dojo.promise.Promise<any>;
            /**
             * 
             */
            toString(): String;
            /**
             * 
             */
            trace(): dojo.promise.Promise<any>;
            /**
             * 
             */
            traceRejected(): dojo.promise.Promise<any>;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/default.html
         *
         * 
         */
        interface default_ {
            /**
             * 
             */
            getPlatformDefaultId(): void;
            /**
             * 
             * @param id             
             * @param parentRequire             
             * @param loaded             
             * @param config             
             */
            load(id: any, parentRequire: any, loaded: any, config: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/request/util.html
         *
         * 
         */
        interface util {
            /**
             * 
             * @param provider             
             * @param methods             
             */
            addCommonMethods(provider: any, methods: any): void;
            /**
             * 
             * @param stat             
             */
            checkStatus(stat: any): boolean;
            /**
             * 
             * @param target             
             * @param source             
             */
            deepCopy(target: any, source: any): any;
            /**
             * 
             * @param source             
             * @param properties             
             */
            deepCreate(source: any, properties: any): any;
            /**
             * 
             * @param response The object used as the value of the request promise.             
             * @param cancel             
             * @param isValid             
             * @param isReady             
             * @param handleResponse             
             * @param last             
             */
            deferred(response: Object, cancel: any, isValid: any, isReady: any, handleResponse: any, last: any): any;
            /**
             * Register a listener to be notified when an event
             * in dojo/request happens.
             * 
             * @param type               OptionalThe event to listen for. Events emitted: "start", "send","load", "error", "done", "stop".             
             * @param listener               OptionalA callback to be run when an event happens.             
             */
            notify(type: String, listener: Function): any;
            /**
             * 
             * @param url             
             * @param options             
             * @param skipData             
             */
            parseArgs(url: any, options: any, skipData: any): Object;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/AdapterRegistry.html
     *
     * A registry to make contextual calling/searching easier.
     * Objects of this class keep list of arrays in the form [name, check,
     * wrap, directReturn] that are used to determine what the contextual
     * result of a set of checked arguments is. All check/wrap functions
     * in this registry should be of the same arity.
     * 
     * @param returnWrappers       Optional    
     */
    interface AdapterRegistry { (returnWrappers?: boolean): void }
    interface AdapterRegistry {
        /**
         * 
         */
        pairs: any[];
        /**
         * 
         */
        returnWrappers: boolean;
        /**
         * Find an adapter for the given arguments. If no suitable adapter
         * is found, throws an exception. match() accepts any number of
         * arguments, all of which are passed to all matching functions
         * from the registered pairs.
         * 
         */
        match(): any;
        /**
         * register a check function to determine if the wrap function or
         * object gets selected
         * 
         * @param name a way to identify this matcher.             
         * @param check a function that arguments are passed to from the adapter'smatch() function.  The check function should return true if thegiven arguments are appropriate for the wrap function.             
         * @param wrap             
         * @param directReturn               OptionalIf directReturn is true, the value passed in for wrap will bereturned instead of being called. Alternately, theAdapterRegistry can be set globally to "return not call" usingthe returnWrappers property. Either way, this behavior allowsthe registry to act as a "search" function instead of afunction interception library.             
         * @param override               OptionalIf override is given and true, the check function will be givenhighest priority. Otherwise, it will be the lowest priorityadapter.             
         */
        register(name: String, check: Function, wrap: Function, directReturn: boolean, override: boolean): void;
        /**
         * Remove a named adapter from the registry
         * 
         * @param name The name of the adapter.             
         */
        unregister(name: String): any;
    }

    module AdapterRegistry {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/cache.html
     *
     * A getter and setter for storing the string content associated with the
     * module and url arguments.
     * If module is a string that contains slashes, then it is interpretted as a fully
     * resolved path (typically a result returned by require.toUrl), and url should not be
     * provided. This is the preferred signature. If module is a string that does not
     * contain slashes, then url must also be provided and module and url are used to
     * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
     * If value is specified, the cache value for the moduleUrl will be set to
     * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
     * in its internal cache and return that cached value for the URL. To clear
     * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
     * the URL contents, only modules on the same domain of the page can use this capability.
     * The build system can inline the cache values though, to allow for xdomain hosting.
     * 
     * @param module dojo/cldr/supplemental     
     * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.     
     * @param value       OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.     
     */
    interface cache { (module: String, url: String, value?: String): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/cache.html
     *
     * A getter and setter for storing the string content associated with the
     * module and url arguments.
     * If module is a string that contains slashes, then it is interpretted as a fully
     * resolved path (typically a result returned by require.toUrl), and url should not be
     * provided. This is the preferred signature. If module is a string that does not
     * contain slashes, then url must also be provided and module and url are used to
     * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
     * If value is specified, the cache value for the moduleUrl will be set to
     * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
     * in its internal cache and return that cached value for the URL. To clear
     * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
     * the URL contents, only modules on the same domain of the page can use this capability.
     * The build system can inline the cache values though, to allow for xdomain hosting.
     * 
     * @param module dojo/cldr/supplemental     
     * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.     
     * @param value       OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.     
     */
    interface cache { (module: Object, url: String, value?: String): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/cache.html
     *
     * A getter and setter for storing the string content associated with the
     * module and url arguments.
     * If module is a string that contains slashes, then it is interpretted as a fully
     * resolved path (typically a result returned by require.toUrl), and url should not be
     * provided. This is the preferred signature. If module is a string that does not
     * contain slashes, then url must also be provided and module and url are used to
     * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
     * If value is specified, the cache value for the moduleUrl will be set to
     * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
     * in its internal cache and return that cached value for the URL. To clear
     * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
     * the URL contents, only modules on the same domain of the page can use this capability.
     * The build system can inline the cache values though, to allow for xdomain hosting.
     * 
     * @param module dojo/cldr/supplemental     
     * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.     
     * @param value       OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.     
     */
    interface cache { (module: String, url: String, value?: Object): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/cache.html
     *
     * A getter and setter for storing the string content associated with the
     * module and url arguments.
     * If module is a string that contains slashes, then it is interpretted as a fully
     * resolved path (typically a result returned by require.toUrl), and url should not be
     * provided. This is the preferred signature. If module is a string that does not
     * contain slashes, then url must also be provided and module and url are used to
     * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
     * If value is specified, the cache value for the moduleUrl will be set to
     * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
     * in its internal cache and return that cached value for the URL. To clear
     * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
     * the URL contents, only modules on the same domain of the page can use this capability.
     * The build system can inline the cache values though, to allow for xdomain hosting.
     * 
     * @param module dojo/cldr/supplemental     
     * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.     
     * @param value       OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.     
     */
    interface cache { (module: Object, url: String, value?: Object): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/cookie.html
     *
     * Get or set a cookie.
     * If one argument is passed, returns the value of the cookie
     * For two or more arguments, acts as a setter.
     * 
     * @param name Name of the cookie     
     * @param value       OptionalValue for the cookie     
     * @param props       OptionalProperties for the cookie     
     */
    interface cookie { (name: String, value?: String, props?: Object): void }
    interface cookie {
        /**
         * Use to determine if the current browser supports cookies or not.
         * 
         * Returns true if user allows cookies.
         * Returns false if user doesn't allow cookies.
         * 
         */
        isSupported(): void;
    }

    module cookie {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/domReady.html
     *
     * Plugin to delay require()/define() callback from firing until the DOM has finished loading.
     * 
     * @param callback     
     */
    interface domReady { (callback: any): void }
    interface domReady {
        /**
         * 
         * @param id             
         * @param req             
         * @param load             
         */
        load(id: any, req: any, load: any): void;
    }

    module domReady {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/hash.html
     *
     * Gets or sets the hash string in the browser URL.
     * Handles getting and setting of location.hash.
     * 
     * If no arguments are passed, acts as a getter.
     * If a string is passed, acts as a setter.
     * 
     * @param hash       Optionalthe hash is set - #string.     
     * @param replace       OptionalIf true, updates the hash value in the current historystate instead of creating a new history state.     
     */
    interface hash { (hash?: String, replace?: boolean): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/has.html
     *
     * Return the current value of the named feature.
     * Returns the value of the feature named by name. The feature must have been
     * previously added to the cache by has.add.
     * 
     * @param name The name (if a string) or identifier (if an integer) of the feature to test.     
     */
    interface has { (name: String): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/has.html
     *
     * Return the current value of the named feature.
     * Returns the value of the feature named by name. The feature must have been
     * previously added to the cache by has.add.
     * 
     * @param name The name (if a string) or identifier (if an integer) of the feature to test.     
     */
    interface has { (name: number): void }
    interface has {
        /**
         * 
         */
        cache: string;
        /**
         * Register a new feature test for some named feature.
         * 
         * @param name The name (if a string) or identifier (if an integer) of the feature to test.             
         * @param test A test function to register. If a function, queued for testing until actuallyneeded. The test function should return a boolean indicatingthe presence of a feature or bug.             
         * @param now               OptionalOptional. Omit if test is not a function. Provides a way to immediatelyrun the test and cache the result.             
         * @param force               OptionalOptional. If the test already exists and force is truthy, then the existingtest will be replaced; otherwise, add does not replace an existing test (thatis, by default, the first test advice wins).             
         */
        add(name: String, test: Function, now: boolean, force: boolean): any;
        /**
         * Register a new feature test for some named feature.
         * 
         * @param name The name (if a string) or identifier (if an integer) of the feature to test.             
         * @param test A test function to register. If a function, queued for testing until actuallyneeded. The test function should return a boolean indicatingthe presence of a feature or bug.             
         * @param now               OptionalOptional. Omit if test is not a function. Provides a way to immediatelyrun the test and cache the result.             
         * @param force               OptionalOptional. If the test already exists and force is truthy, then the existingtest will be replaced; otherwise, add does not replace an existing test (thatis, by default, the first test advice wins).             
         */
        add(name: number, test: Function, now: boolean, force: boolean): any;
        /**
         * Deletes the contents of the element passed to test functions.
         * 
         * @param element             
         */
        clearElement(element: any): void;
        /**
         * Conditional loading of AMD modules based on a has feature test value.
         * 
         * @param id Gives the resolved module id to load.             
         * @param parentRequire The loader require function with respect to the module that contained the plugin resource in it'sdependency list.             
         * @param loaded Callback to loader that consumes result of plugin demand.             
         */
        load(id: String, parentRequire: Function, loaded: Function): void;
        /**
         * Resolves id into a module id based on possibly-nested tenary expression that branches on has feature test value(s).
         * 
         * @param id             
         * @param toAbsMid Resolves a relative module id into an absolute module id             
         */
        normalize(id: any, toAbsMid: Function): void;
    }

    module has {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/hccss.html
     *
     * Test if computer is in high contrast mode (i.e. if browser is not displaying background images).
     * Defines has("highcontrast") and sets dj_a11y CSS class on <body> if machine is in high contrast mode.
     * Returns has() method;
     * 
     */
    interface hccss { (): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList-data.html
     *
     * Adds data() and removeData() methods to NodeList, and returns NodeList constructor.
     * 
     */
    interface NodeList_data { (): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList-html.html
     *
     * Adds a chainable html method to dojo/query() / NodeList instances for setting/replacing node content
     * 
     */
    interface NodeList_html { (): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList-fx.html
     *
     * Adds dojo.fx animation support to dojo.query() by extending the NodeList class
     * with additional FX functions.  NodeList is the array-like object used to hold query results.
     * 
     */
    interface NodeList_fx { (): void }
    interface NodeList_fx {
        /**
         * fade all elements of the node list to a specified opacity
         * 
         * @param args             
         */
        fadeTo(args: any): any;
        /**
         * highlight all elements of the node list.
         * Returns an instance of dojo.Animation
         * 
         * @param args             
         */
        highlight(args: any): any;
        /**
         * size all elements of this NodeList. Returns an instance of dojo.Animation
         * 
         * @param args             
         */
        sizeTo(args: any): any;
        /**
         * slide all elements of this NodeList. Returns an instance of dojo.Animation
         * 
         * @param args             
         */
        slideBy(args: any): any;
        /**
         * Wipe all elements of the NodeList to a specified width: or height:
         * 
         * @param args             
         */
        wipeTo(args: any): any;
    }

    module NodeList_fx {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList-dom.html
     *
     * Adds DOM related methods to NodeList, and returns NodeList constructor.
     * 
     */
    interface NodeList_dom { (): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList-manipulate.html
     *
     * Adds chainable methods to dojo.query() / NodeList instances for manipulating HTML
     * and DOM nodes and their properties.
     * 
     */
    interface NodeList_manipulate { (): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList-traverse.html
     *
     * Adds chainable methods to dojo/query() / NodeList instances for traversing the DOM
     * 
     */
    interface NodeList_traverse { (): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/on.html
     *
     * A function that provides core event listening functionality. With this function
     * you can provide a target, event type, and listener to be notified of
     * future matching events that are fired.
     * To listen for "click" events on a button node, we can do:
     * 
     * define(["dojo/on"], function(listen){
     *     on(button, "click", clickHandler);
     *     ...
     * Evented JavaScript objects can also have their own events.
     * 
     * var obj = new Evented;
     * on(obj, "foo", fooHandler);
     * And then we could publish a "foo" event:
     * 
     * on.emit(obj, "foo", {key: "value"});
     * We can use extension events as well. For example, you could listen for a tap gesture:
     * 
     * define(["dojo/on", "dojo/gesture/tap", function(listen, tap){
     *     on(button, tap, tapHandler);
     *     ...
     * which would trigger fooHandler. Note that for a simple object this is equivalent to calling:
     * 
     * obj.onfoo({key:"value"});
     * If you use on.emit on a DOM node, it will use native event dispatching when possible.
     * 
     * @param target This is the target object or DOM element that to receive events from     
     * @param type This is the name of the event to listen for or an extension event type.     
     * @param listener This is the function that should be called when the event fires.     
     * @param dontFix     
     */
    interface on { (target: HTMLElement, type: String, listener: Function, dontFix: any): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/on.html
     *
     * A function that provides core event listening functionality. With this function
     * you can provide a target, event type, and listener to be notified of
     * future matching events that are fired.
     * To listen for "click" events on a button node, we can do:
     * 
     * define(["dojo/on"], function(listen){
     *     on(button, "click", clickHandler);
     *     ...
     * Evented JavaScript objects can also have their own events.
     * 
     * var obj = new Evented;
     * on(obj, "foo", fooHandler);
     * And then we could publish a "foo" event:
     * 
     * on.emit(obj, "foo", {key: "value"});
     * We can use extension events as well. For example, you could listen for a tap gesture:
     * 
     * define(["dojo/on", "dojo/gesture/tap", function(listen, tap){
     *     on(button, tap, tapHandler);
     *     ...
     * which would trigger fooHandler. Note that for a simple object this is equivalent to calling:
     * 
     * obj.onfoo({key:"value"});
     * If you use on.emit on a DOM node, it will use native event dispatching when possible.
     * 
     * @param target This is the target object or DOM element that to receive events from     
     * @param type This is the name of the event to listen for or an extension event type.     
     * @param listener This is the function that should be called when the event fires.     
     * @param dontFix     
     */
    interface on { (target: Object, type: String, listener: Function, dontFix: any): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/on.html
     *
     * A function that provides core event listening functionality. With this function
     * you can provide a target, event type, and listener to be notified of
     * future matching events that are fired.
     * To listen for "click" events on a button node, we can do:
     * 
     * define(["dojo/on"], function(listen){
     *     on(button, "click", clickHandler);
     *     ...
     * Evented JavaScript objects can also have their own events.
     * 
     * var obj = new Evented;
     * on(obj, "foo", fooHandler);
     * And then we could publish a "foo" event:
     * 
     * on.emit(obj, "foo", {key: "value"});
     * We can use extension events as well. For example, you could listen for a tap gesture:
     * 
     * define(["dojo/on", "dojo/gesture/tap", function(listen, tap){
     *     on(button, tap, tapHandler);
     *     ...
     * which would trigger fooHandler. Note that for a simple object this is equivalent to calling:
     * 
     * obj.onfoo({key:"value"});
     * If you use on.emit on a DOM node, it will use native event dispatching when possible.
     * 
     * @param target This is the target object or DOM element that to receive events from     
     * @param type This is the name of the event to listen for or an extension event type.     
     * @param listener This is the function that should be called when the event fires.     
     * @param dontFix     
     */
    interface on { (target: HTMLElement, type: Function, listener: Function, dontFix: any): void }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/on.html
     *
     * A function that provides core event listening functionality. With this function
     * you can provide a target, event type, and listener to be notified of
     * future matching events that are fired.
     * To listen for "click" events on a button node, we can do:
     * 
     * define(["dojo/on"], function(listen){
     *     on(button, "click", clickHandler);
     *     ...
     * Evented JavaScript objects can also have their own events.
     * 
     * var obj = new Evented;
     * on(obj, "foo", fooHandler);
     * And then we could publish a "foo" event:
     * 
     * on.emit(obj, "foo", {key: "value"});
     * We can use extension events as well. For example, you could listen for a tap gesture:
     * 
     * define(["dojo/on", "dojo/gesture/tap", function(listen, tap){
     *     on(button, tap, tapHandler);
     *     ...
     * which would trigger fooHandler. Note that for a simple object this is equivalent to calling:
     * 
     * obj.onfoo({key:"value"});
     * If you use on.emit on a DOM node, it will use native event dispatching when possible.
     * 
     * @param target This is the target object or DOM element that to receive events from     
     * @param type This is the name of the event to listen for or an extension event type.     
     * @param listener This is the function that should be called when the event fires.     
     * @param dontFix     
     */
    interface on { (target: Object, type: String, listener: Function, dontFix?: any): { remove: { (): void } } }
    interface on {
        /**
         * 
         * @param target             
         * @param type             
         * @param event             
         */
        emit(target: any, type: any, event: any): any;
        /**
         * This function acts the same as on(), but will only call the listener once. The 
         * listener will be called for the first
         * event that takes place and then listener will automatically be removed.
         * 
         * @param target             
         * @param type             
         * @param listener             
         * @param dontFix             
         */
        once(target: any, type: any, listener: any, dontFix?: any): any;
        /**
         * 
         * @param target             
         * @param type             
         * @param listener             
         * @param addListener             
         * @param dontFix             
         * @param matchesTarget             
         */
        parse(target: any, type: any, listener: any, addListener: any, dontFix: any, matchesTarget: any): any;
        /**
         * This function acts the same as on(), but with pausable functionality. The
         * returned signal object has pause() and resume() functions. Calling the
         * pause() method will cause the listener to not be called for future events. Calling the
         * resume() method will cause the listener to again be called for future events.
         * 
         * @param target             
         * @param type             
         * @param listener             
         * @param dontFix             
         */
        pausable(target: any, type: any, listener: any, dontFix: any): any;
        /**
         * Creates a new extension event with event delegation. This is based on
         * the provided event type (can be extension event) that
         * only calls the listener when the CSS selector matches the target of the event.
         * 
         * The application must require() an appropriate level of dojo/query to handle the selector.
         * 
         * @param selector The CSS selector to use for filter events and determine the |this| of the event listener.             
         * @param eventType The event to listen for             
         * @param children Indicates if children elements of the selector should be allowed. This defaults to true             
         */
        selector(selector: any, eventType: any, children: any): Function;
    }

    module on {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/query.html
     *
     * This modules provides DOM querying functionality. The module export is a function
     * that can be used to query for DOM nodes by CSS selector and returns a NodeList
     * representing the matching nodes.
     * dojo/query is responsible for loading the appropriate query engine and wrapping
     * its results with a NodeList. You can use dojo/query with a specific selector engine
     * by using it as a plugin. For example, if you installed the sizzle package, you could
     * use it as the selector engine with:
     * 
     * require(["dojo/query!sizzle"], function(query){
     *     query("div")...
     * The id after the ! can be a module id of the selector engine or one of the following values:
     * 
     * acme: This is the default engine used by Dojo base, and will ensure that the full
     * Acme engine is always loaded.
     * css2: If the browser has a native selector engine, this will be used, otherwise a
     * very minimal lightweight selector engine will be loaded that can do simple CSS2 selectors
     * (by #id, .class, tag, and [name=value] attributes, with standard child or descendant (>)
     * operators) and nothing more.
     * css2.1: If the browser has a native selector engine, this will be used, otherwise the
     * full Acme engine will be loaded.
     * css3: If the browser has a native selector engine with support for CSS3 pseudo
     * selectors (most modern browsers except IE8), this will be used, otherwise the
     * full Acme engine will be loaded.
     * Or the module id of a selector engine can be used to explicitly choose the selector engine
     * 
     * For example, if you are using CSS3 pseudo selectors in module, you can specify that
     * you will need support them with:
     * 
     * require(["dojo/query!css3"], function(query){
     *     query('#t > h3:nth-child(odd)')...
     * You can also choose the selector engine/load configuration by setting the query-selector:
     * For example:
     * 
     * <script data-dojo-config="query-selector:'css3'" src="dojo.js"></script>
     * 
     * @param selector A CSS selector to search for.     
     * @param context       OptionalAn optional context to limit the searching scope. Only nodes under context will bescanned.     
     */
    interface query{(selector: String, context?: String): NodeList}
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/query.html
     *
     * This modules provides DOM querying functionality. The module export is a function
     * that can be used to query for DOM nodes by CSS selector and returns a NodeList
     * representing the matching nodes.
     * dojo/query is responsible for loading the appropriate query engine and wrapping
     * its results with a NodeList. You can use dojo/query with a specific selector engine
     * by using it as a plugin. For example, if you installed the sizzle package, you could
     * use it as the selector engine with:
     * 
     * require(["dojo/query!sizzle"], function(query){
     *     query("div")...
     * The id after the ! can be a module id of the selector engine or one of the following values:
     * 
     * acme: This is the default engine used by Dojo base, and will ensure that the full
     * Acme engine is always loaded.
     * css2: If the browser has a native selector engine, this will be used, otherwise a
     * very minimal lightweight selector engine will be loaded that can do simple CSS2 selectors
     * (by #id, .class, tag, and [name=value] attributes, with standard child or descendant (>)
     * operators) and nothing more.
     * css2.1: If the browser has a native selector engine, this will be used, otherwise the
     * full Acme engine will be loaded.
     * css3: If the browser has a native selector engine with support for CSS3 pseudo
     * selectors (most modern browsers except IE8), this will be used, otherwise the
     * full Acme engine will be loaded.
     * Or the module id of a selector engine can be used to explicitly choose the selector engine
     * 
     * For example, if you are using CSS3 pseudo selectors in module, you can specify that
     * you will need support them with:
     * 
     * require(["dojo/query!css3"], function(query){
     *     query('#t > h3:nth-child(odd)')...
     * You can also choose the selector engine/load configuration by setting the query-selector:
     * For example:
     * 
     * <script data-dojo-config="query-selector:'css3'" src="dojo.js"></script>
     * 
     * @param selector A CSS selector to search for.     
     * @param context       OptionalAn optional context to limit the searching scope. Only nodes under context will bescanned.     
     */
    interface query{(selector: String, context?: HTMLElement): NodeList}
    interface query {
        /**
         * can be used as AMD plugin to conditionally load new query engine
         * 
         * @param id             
         * @param parentRequire             
         * @param loaded             
         */
        load(id: any, parentRequire: any, loaded: any): void;
        /**
         * Array-like object which adds syntactic
         * sugar for chaining, common iteration operations, animation, and
         * node manipulation. NodeLists are most often returned as the
         * result of dojo/query() calls.
         * NodeList instances provide many utilities that reflect
         * core Dojo APIs for Array iteration and manipulation, DOM
         * manipulation, and event handling. Instead of needing to dig up
         * functions in the dojo package, NodeLists generally make the
         * full power of Dojo available for DOM manipulation tasks in a
         * simple, chainable way.
         * 
         * @param array             
         */
        NodeList(array: any): any[];
    }

    module query {
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/ready.html
     *
     * Add a function to execute on DOM content loaded and all requested modules have arrived and been evaluated.
     * In most cases, the domReady plug-in should suffice and this method should not be needed.
     * 
     * When called in a non-browser environment, just checks that all requested modules have arrived and been
     * evaluated.
     * 
     * @param priority       OptionalThe order in which to exec this callback relative to other callbacks, defaults to 1000     
     * @param context The context in which to run execute callback, or a callback if not using context     
     * @param callback       OptionalThe function to execute.     
     */
    interface ready{(priority?: number, context?: any, callback?: Function): void}
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/sniff.html
     *
     * This module sets has() flags based on the current browser.
     * It returns the has() function.
     * 
     */
    interface sniff{(): void}
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/when.html
     *
     * Transparently applies callbacks to values and/or promises.
     * Accepts promises but also transparently handles non-promises. If no
     * callbacks are provided returns a promise, regardless of the initial
     * value. Foreign promises are converted.
     * 
     * If callbacks are provided and the initial value is not a promise,
     * the callback is executed immediately with no error handling. Returns
     * a promise if the initial value is a promise, or the result of the
     * callback otherwise.
     * 
     * @param valueOrPromise Either a regular value or an object with a then() method thatfollows the Promises/A specification.     
     * @param callback       OptionalCallback to be invoked when the promise is resolved, or a non-promiseis received.     
     * @param errback       OptionalCallback to be invoked when the promise is rejected.     
     * @param progback       OptionalCallback to be invoked when the promise emits a progress update.     
     */
    interface when { <T, U>(value: T|dojo.promise.Promise<T>, callback: dojo.promise.Callback<T, U>, errback?: any, progback?: any): U|dojo.promise.Promise<U> }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/DeferredList.html
     *
     * Deprecated, use dojo/promise/all instead.
     * Provides event handling for a group of Deferred objects.
     * DeferredList takes an array of existing deferreds and returns a new deferred of its own
     * this new deferred will typically have its callback fired when all of the deferreds in
     * the given list have fired their own deferreds.  The parameters fireOnOneCallback and
     * fireOnOneErrback, will fire before all the deferreds as appropriate
     * 
     */
    class DeferredList {
        constructor();
        /**
         * Gathers the results of the deferreds for packaging
         * as the parameters to the Deferred Lists' callback
         * 
         * @param deferredList The deferred list from which this function gathers results.             
         */
        gatherResults(deferredList: dojo.DeferredList): any;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/Deferred.html
     *
     * Creates a new deferred. This API is preferred over
     * dojo/_base/Deferred.
     * Creates a new deferred, as an abstraction over (primarily)
     * asynchronous operations. The deferred is the private interface
     * that should not be returned to calling code. That's what the
     * promise is for. See dojo/promise/Promise.
     * 
     * @param canceler       OptionalWill be invoked if the deferred is canceled. The cancelerreceives the reason the deferred was canceled as its argument.The deferred is rejected with its return value, or a newdojo/errors/CancelError instance.     
     */
    class Deferred {
        constructor(canceler?: Function);
        /**
         * 
         */
        "promise": dojo.promise.Promise<any>;
        /**
         * Inform the deferred it may cancel its asynchronous operation.
         * Inform the deferred it may cancel its asynchronous operation.
         * The deferred's (optional) canceler is invoked and the
         * deferred will be left in a rejected state. Can affect other
         * promises that originate with the same deferred.
         * 
         * @param reason A message that may be sent to the deferred's canceler,explaining why it's being canceled.             
         * @param strict               OptionalIf strict, will throw an error if the deferred has alreadybeen fulfilled and consequently cannot be canceled.             
         */
        cancel(reason: any, strict: boolean): any;
        /**
         * Checks whether the deferred has been canceled.
         * 
         */
        isCanceled(): boolean;
        /**
         * Checks whether the deferred has been resolved or rejected.
         * 
         */
        isFulfilled(): boolean;
        /**
         * Checks whether the deferred has been rejected.
         * 
         */
        isRejected(): boolean;
        /**
         * Checks whether the deferred has been resolved.
         * 
         */
        isResolved(): boolean;
        /**
         * Emit a progress update on the deferred.
         * Emit a progress update on the deferred. Progress updates
         * can be used to communicate updates about the asynchronous
         * operation before it has finished.
         * 
         * @param update The progress update. Passed to progbacks.             
         * @param strict               OptionalIf strict, will throw an error if the deferred has alreadybeen fulfilled and consequently no progress can be emitted.             
         */
        progress(update: any, strict: boolean): dojo.promise.Promise<any>;
        /**
         * Reject the deferred.
         * Reject the deferred, putting it in an error state.
         * 
         * @param error The error result of the deferred. Passed to errbacks.             
         * @param strict               OptionalIf strict, will throw an error if the deferred has alreadybeen fulfilled and consequently cannot be rejected.             
         */
        reject(error: any, strict: boolean): any;
        /**
         * Resolve the deferred.
         * Resolve the deferred, putting it in a success state.
         * 
         * @param value The result of the deferred. Passed to callbacks.             
         * @param strict               OptionalIf strict, will throw an error if the deferred has alreadybeen fulfilled and consequently cannot be resolved.             
         */
        resolve(value: any, strict?: boolean): dojo.promise.Promise<any>;
        /**
         * Add new callbacks to the deferred.
         * Add new callbacks to the deferred. Callbacks can be added
         * before or after the deferred is fulfilled.
         * 
         * @param callback               OptionalCallback to be invoked when the promise is resolved.Receives the resolution value.             
         * @param errback               OptionalCallback to be invoked when the promise is rejected.Receives the rejection error.             
         * @param progback               OptionalCallback to be invoked when the promise emits a progressupdate. Receives the progress update.             
         */
        then(callback: Function, errback: Function, progback: Function): dojo.promise.Promise<any>;
        /**
         * 
         */
        toString(): String;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/Evented.html
     *
     * A class that can be used as a mixin or base class,
     * to add on() and emit() methods to a class
     * for listening for events and emitting events:
     * 
     */
    class Evented {
        constructor();
        /**
         * 
         * @param type             
         * @param event             
         */
        emit(type: String, data: any): any;
        /**
         * 
         * @param type             
         * @param listener             
         */
        on(type: String, listener: {(e:any):void}): {remove: {():void}};
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList.html
     *
     * Array-like object which adds syntactic
     * sugar for chaining, common iteration operations, animation, and
     * node manipulation. NodeLists are most often returned as the
     * result of dojo/query() calls.
     * NodeList instances provide many utilities that reflect
     * core Dojo APIs for Array iteration and manipulation, DOM
     * manipulation, and event handling. Instead of needing to dig up
     * functions in the dojo package, NodeLists generally make the
     * full power of Dojo available for DOM manipulation tasks in a
     * simple, chainable way.
     * 
     * @param array     
     */
    class NodeList {
        constructor(array: any);
        /**
         * 
         */
        "events": any[];
        /**
         * adds the specified class to every node in the list
         * 
         * @param className A String class name to add, or several space-separated class names,or an array of class names.             
         */
        addClass(className: String): void;
        /**
         * adds the specified class to every node in the list
         * 
         * @param className A String class name to add, or several space-separated class names,or an array of class names.             
         */
        addClass(className: any[]): void;
        /**
         * Animate the effects of adding a class to all nodes in this list.
         * see dojox.fx.addClass
         * 
         * @param cssClass             
         * @param args             
         */
        addClassFx(cssClass: any, args: any): {type:Function;value:any};
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content: String, position: String): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content: HTMLElement, position: String): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content: Object, position: String): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content:  dojo.NodeList, position: String): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content: String, position: number): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content: HTMLElement, position: number): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content: Object, position: number): Function;
        /**
         * add a node, NodeList or some HTML as a string to every item in the
         * list.  Returns the original list.
         * a copy of the HTML content is added to each item in the
         * list, with an optional position argument. If no position
         * argument is provided, the content is appended to the end of
         * each item.
         * 
         * @param content the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
         * @param position               Optionalcan be one of:"last"||"end" (default)"first||"start""before""after""replace" (replaces nodes in this NodeList with new content)"only" (removes other children of the nodes so new content is the only child)or an offset in the childNodes property             
         */
        addContent(content:  dojo.NodeList, position: number): Function;
        /**
         * places any/all elements in queryOrListOrNode at a
         * position relative to the first element in this list.
         * Returns a dojo/NodeList of the adopted elements.
         * 
         * @param queryOrListOrNode a DOM node or a query string or a query result.Represents the nodes to be adopted relative to thefirst element of this NodeList.             
         * @param position               Optionalcan be one of:"last" (default)"first""before""after""only""replace"or an offset in the childNodes property             
         */
        adopt(queryOrListOrNode: String, position: String): any;
        /**
         * places any/all elements in queryOrListOrNode at a
         * position relative to the first element in this list.
         * Returns a dojo/NodeList of the adopted elements.
         * 
         * @param queryOrListOrNode a DOM node or a query string or a query result.Represents the nodes to be adopted relative to thefirst element of this NodeList.             
         * @param position               Optionalcan be one of:"last" (default)"first""before""after""only""replace"or an offset in the childNodes property             
         */
        adopt(queryOrListOrNode: any[], position: String): any;
        /**
         * places any/all elements in queryOrListOrNode at a
         * position relative to the first element in this list.
         * Returns a dojo/NodeList of the adopted elements.
         * 
         * @param queryOrListOrNode a DOM node or a query string or a query result.Represents the nodes to be adopted relative to thefirst element of this NodeList.             
         * @param position               Optionalcan be one of:"last" (default)"first""before""after""only""replace"or an offset in the childNodes property             
         */
        adopt(queryOrListOrNode: HTMLElement, position: String): any;
        /**
         * Places the content after every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        after(content: String): any;
        /**
         * Places the content after every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        after(content: HTMLElement): any;
        /**
         * Places the content after every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        after(content: NodeList): any;
        /**
         * Adds the nodes from the previous dojo/NodeList to the current dojo/NodeList.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         */
        andSelf(): any;
        /**
         * Animate one or more CSS properties for all nodes in this list.
         * The returned animation object will already be playing when it
         * is returned. See the docs for dojo.anim for full details.
         * 
         * @param properties the properties to animate. does NOT support the auto parameter like otherNodeList-fx methods.             
         * @param duration               OptionalOptional. The time to run the animations for             
         * @param easing               OptionalOptional. The easing function to use.             
         * @param onEnd               OptionalA function to be called when the animation ends             
         * @param delay               Optionalhow long to delay playing the returned animation             
         */
        anim(properties: Object, duration: number, easing: Function, onEnd: Function, delay: number): any;
        /**
         * Animate all elements of this NodeList across the properties specified.
         * syntax identical to dojo.animateProperty
         * 
         * @param args               OptionalAdditional dojo/_base/fx.Animation arguments to mix into this set with the addition ofan auto parameter.             
         */
        animateProperty(args: Object): any;
        /**
         * appends the content to every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        append(content: String): any;
        /**
         * appends the content to every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        append(content: HTMLElement): any;
        /**
         * appends the content to every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        append(content: NodeList): any;
        /**
         * appends nodes in this NodeList to the nodes matched by
         * the query passed to appendTo.
         * The nodes in this NodeList will be cloned if the query
         * matches more than one element. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param query             
         */
        appendTo(query: String): any;
        /**
         * Returns a new NodeList comprised of items in this NodeList
         * at the given index or indices.
         * 
         * @param index One or more 0-based indices of items in the currentNodeList. A negative index will start at the end of thelist and go backwards.             
         */
        at(index: number[]): any;
        /**
         * gets or sets the DOM attribute for every element in the
         * NodeList. See also dojo/dom-attr
         * 
         * @param property the attribute to get/set             
         * @param value               Optionaloptional. The value to set the property to             
         */
        attr(property: String, value: String): any;
        /**
         * Places the content before every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        before(content: String): any;
        /**
         * Places the content before every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        before(content: HTMLElement): any;
        /**
         * Places the content before every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        before(content: NodeList): any;
        /**
         * Returns all immediate child elements for nodes in this dojo/NodeList.
         * Optionally takes a query to filter the child elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        children(query: String): any;
        /**
         * Clones all the nodes in this NodeList and returns them as a new NodeList.
         * Only the DOM nodes are cloned, not any attached event handlers.
         * 
         */
        clone(): any;
        /**
         * Returns closest parent that matches query, including current node in this
         * dojo/NodeList if it matches the query.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query a CSS selector.             
         * @param root               OptionalIf specified, query is relative to "root" rather than document body.             
         */
        closest(query: String, root: String): any;
        /**
         * Returns closest parent that matches query, including current node in this
         * dojo/NodeList if it matches the query.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query a CSS selector.             
         * @param root               OptionalIf specified, query is relative to "root" rather than document body.             
         */
        closest(query: String, root: HTMLElement): any;
        /**
         * Returns a new NodeList comprised of items in this NodeList
         * as well as items passed in as parameters
         * This method behaves exactly like the Array.concat method
         * with the caveat that it returns a NodeList and not a
         * raw Array. For more details, see the Array.concat
         * docs
         * 
         * @param item               OptionalAny number of optional parameters may be passed in to bespliced into the NodeList             
         */
        concat(item: Object): any;
        /**
         * Attach event handlers to every item of the NodeList. Uses dojo.connect()
         * so event properties are normalized.
         * 
         * Application must manually require() "dojo/_base/connect" before using this method.
         * 
         * @param methodName the name of the method to attach to. For DOM events, this should bethe lower-case name of the event             
         * @param objOrFunc if 2 arguments are passed (methodName, objOrFunc), objOrFunc shouldreference a function or be the name of the function in the globalnamespace to attach. If 3 arguments are provided(methodName, objOrFunc, funcName), objOrFunc must be the scope tolocate the bound function in             
         * @param funcName               Optionaloptional. A string naming the function in objOrFunc to bind to theevent. May also be a function reference.             
         */
        connect(methodName: String, objOrFunc: Object, funcName: String): void;
        /**
         * Attach event handlers to every item of the NodeList. Uses dojo.connect()
         * so event properties are normalized.
         * 
         * Application must manually require() "dojo/_base/connect" before using this method.
         * 
         * @param methodName the name of the method to attach to. For DOM events, this should bethe lower-case name of the event             
         * @param objOrFunc if 2 arguments are passed (methodName, objOrFunc), objOrFunc shouldreference a function or be the name of the function in the globalnamespace to attach. If 3 arguments are provided(methodName, objOrFunc, funcName), objOrFunc must be the scope tolocate the bound function in             
         * @param funcName               Optionaloptional. A string naming the function in objOrFunc to bind to theevent. May also be a function reference.             
         */
        connect(methodName: String, objOrFunc: Function, funcName: String): void;
        /**
         * Attach event handlers to every item of the NodeList. Uses dojo.connect()
         * so event properties are normalized.
         * 
         * Application must manually require() "dojo/_base/connect" before using this method.
         * 
         * @param methodName the name of the method to attach to. For DOM events, this should bethe lower-case name of the event             
         * @param objOrFunc if 2 arguments are passed (methodName, objOrFunc), objOrFunc shouldreference a function or be the name of the function in the globalnamespace to attach. If 3 arguments are provided(methodName, objOrFunc, funcName), objOrFunc must be the scope tolocate the bound function in             
         * @param funcName               Optionaloptional. A string naming the function in objOrFunc to bind to theevent. May also be a function reference.             
         */
        connect(methodName: String, objOrFunc: String, funcName: String): void;
        /**
         * Deprecated: Use position() for border-box x/y/w/h
         * or marginBox() for margin-box w/h/l/t.
         * Returns the box objects of all elements in a node list as
         * an Array (not a NodeList). Acts like domGeom.coords, though assumes
         * the node passed is each node in this list.
         * 
         */
        coords(): void;
        /**
         * stash or get some arbitrary data on/from these nodes.
         * Stash or get some arbitrary data on/from these nodes. This private _data function is
         * exposed publicly on dojo/NodeList, eg: as the result of a dojo/query call.
         * DIFFERS from jQuery.data in that when used as a getter, the entire list is ALWAYS
         * returned. EVEN WHEN THE LIST IS length == 1.
         * 
         * A single-node version of this function is provided as dojo._nodeData, which follows
         * the same signature, though expects a String ID or DomNode reference in the first
         * position, before key/value arguments.
         * 
         * @param key               OptionalIf an object, act as a setter and iterate over said object setting data items as defined.If a string, and value present, set the data for defined key to valueIf a string, and value absent, act as a getter, returning the data associated with said key             
         * @param value               OptionalThe value to set for said key, provided key is a string (and not an object)             
         */
        data(key: Object, value: any): any;
        /**
         * stash or get some arbitrary data on/from these nodes.
         * Stash or get some arbitrary data on/from these nodes. This private _data function is
         * exposed publicly on dojo/NodeList, eg: as the result of a dojo/query call.
         * DIFFERS from jQuery.data in that when used as a getter, the entire list is ALWAYS
         * returned. EVEN WHEN THE LIST IS length == 1.
         * 
         * A single-node version of this function is provided as dojo._nodeData, which follows
         * the same signature, though expects a String ID or DomNode reference in the first
         * position, before key/value arguments.
         * 
         * @param key               OptionalIf an object, act as a setter and iterate over said object setting data items as defined.If a string, and value present, set the data for defined key to valueIf a string, and value absent, act as a getter, returning the data associated with said key             
         * @param value               OptionalThe value to set for said key, provided key is a string (and not an object)             
         */
        data(key: String, value: any): any;
        /**
         * Monitor nodes in this NodeList for [bubbled] events on nodes that match selector.
         * Calls fn(evt) for those events, where (inside of fn()), this == the node
         * that matches the selector.
         * Sets up event handlers that can catch events on any subnodes matching a given selector,
         * including nodes created after delegate() has been called.
         * 
         * This allows an app to setup a single event handler on a high level node, rather than many
         * event handlers on subnodes. For example, one onclick handler for a Tree widget, rather than separate
         * handlers for each node in the tree.
         * Since setting up many event handlers is expensive, this can increase performance.
         * 
         * Note that delegate() will not work for events that don't bubble, like focus.
         * onmouseenter/onmouseleave also don't currently work.
         * 
         * @param selector CSS selector valid to dojo.query, like ".foo" or "div > span".  Theselector is relative to the nodes in this NodeList, not the document root.For example myNodeList.delegate("> a", "onclick", ...) will catch events onanchor nodes which are (immediate) children of the nodes in myNodeList.             
         * @param eventName Standard event name used as an argument to dojo.connect, like "onclick".             
         * @param fn Callback function passed the event object, and where this == the node that matches the selector.That means that for example, after setting up a handler viadojo.query("body").delegate("fieldset", "onclick", ...)clicking on a fieldset or any nodes inside of a fieldset will be reportedas a click on the fieldset itself.             
         */
        delegate(selector: String, eventName: String, fn: Function): any;
        /**
         * Renders the specified template in each of the NodeList entries.
         * 
         * @param template The template string or location             
         * @param context The context object or location             
         */
        dtl(template: dojox.dtl.__StringArgs , context: dojox.dtl.__ObjectArgs ): Function;
        /**
         * Renders the specified template in each of the NodeList entries.
         * 
         * @param template The template string or location             
         * @param context The context object or location             
         */
        dtl(template: String, context: dojox.dtl.__ObjectArgs ): Function;
        /**
         * Renders the specified template in each of the NodeList entries.
         * 
         * @param template The template string or location             
         * @param context The context object or location             
         */
        dtl(template: dojox.dtl.__StringArgs , context: Object): Function;
        /**
         * Renders the specified template in each of the NodeList entries.
         * 
         * @param template The template string or location             
         * @param context The context object or location             
         */
        dtl(template: String, context: Object): Function;
        /**
         * clears all content from each node in the list. Effectively
         * equivalent to removing all child nodes from every item in
         * the list.
         * 
         */
        empty(): any;
        /**
         * Ends use of the current NodeList by returning the previous NodeList
         * that generated the current NodeList.
         * Returns the NodeList that generated the current NodeList. If there
         * is no parent NodeList, an empty NodeList is returned.
         * 
         */
        end(): any;
        /**
         * Returns the even nodes in this dojo/NodeList as a dojo/NodeList.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         */
        even(): any;
        /**
         * see dojo/_base/array.every() and the Array.every
         * docs.
         * Takes the same structure of arguments and returns as
         * dojo/_base/array.every() with the caveat that the passed array is
         * implicitly this NodeList
         * 
         * @param callback the callback             
         * @param thisObject               Optionalthe context             
         */
        every(callback: Function, thisObject: Object): any;
        /**
         * fade in all elements of this NodeList via dojo.fadeIn
         * 
         * @param args               OptionalAdditional dojo/_base/fx.Animation arguments to mix into this set with the addition ofan auto parameter.             
         */
        fadeIn(args: Object): any;
        /**
         * fade out all elements of this NodeList via dojo.fadeOut
         * 
         * @param args               OptionalAdditional dojo/_base/fx.Animation arguments to mix into this set with the addition ofan auto parameter.             
         */
        fadeOut(args: Object): any;
        /**
         * "masks" the built-in javascript filter() method (supported
         * in Dojo via dojo.filter) to support passing a simple
         * string filter in addition to supporting filtering function
         * objects.
         * 
         * @param filter If a string, a CSS rule like ".thinger" or "div > span".             
         */
        filter(filter: String): any;
        /**
         * "masks" the built-in javascript filter() method (supported
         * in Dojo via dojo.filter) to support passing a simple
         * string filter in addition to supporting filtering function
         * objects.
         * 
         * @param filter If a string, a CSS rule like ".thinger" or "div > span".             
         */
        filter(filter: Function): any;
        /**
         * Returns the first node in this dojo/NodeList as a dojo/NodeList.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         */
        first(): any;
        /**
         * see dojo/_base/array.forEach(). The primary difference is that the acted-on
         * array is implicitly this NodeList. If you want the option to break out
         * of the forEach loop, use every() or some() instead.
         * 
         * @param callback             
         * @param thisObj             
         */
        forEach(callback: any, thisObj: any): Function;
        /**
         * allows setting the innerHTML of each node in the NodeList,
         * if there is a value passed in, otherwise, reads the innerHTML value of the first node.
         * This method is simpler than the dojo/NodeList.html() method provided by
         * dojo/NodeList-html. This method just does proper innerHTML insertion of HTML fragments,
         * and it allows for the innerHTML to be read for the first node in the node list.
         * Since dojo/NodeList-html already took the "html" name, this method is called
         * "innerHTML". However, if dojo/NodeList-html has not been loaded yet, this
         * module will define an "html" method that can be used instead. Be careful if you
         * are working in an environment where it is possible that dojo/NodeList-html could
         * have been loaded, since its definition of "html" will take precedence.
         * The nodes represented by the value argument will be cloned if more than one
         * node is in this NodeList. The nodes in this NodeList are returned in the "set"
         * usage of this method, not the HTML that was inserted.
         * 
         * @param value               Optional            
         */
        html(value: String): any;
        /**
         * allows setting the innerHTML of each node in the NodeList,
         * if there is a value passed in, otherwise, reads the innerHTML value of the first node.
         * This method is simpler than the dojo/NodeList.html() method provided by
         * dojo/NodeList-html. This method just does proper innerHTML insertion of HTML fragments,
         * and it allows for the innerHTML to be read for the first node in the node list.
         * Since dojo/NodeList-html already took the "html" name, this method is called
         * "innerHTML". However, if dojo/NodeList-html has not been loaded yet, this
         * module will define an "html" method that can be used instead. Be careful if you
         * are working in an environment where it is possible that dojo/NodeList-html could
         * have been loaded, since its definition of "html" will take precedence.
         * The nodes represented by the value argument will be cloned if more than one
         * node is in this NodeList. The nodes in this NodeList are returned in the "set"
         * usage of this method, not the HTML that was inserted.
         * 
         * @param value               Optional            
         */
        html(value: HTMLElement): any;
        /**
         * allows setting the innerHTML of each node in the NodeList,
         * if there is a value passed in, otherwise, reads the innerHTML value of the first node.
         * This method is simpler than the dojo/NodeList.html() method provided by
         * dojo/NodeList-html. This method just does proper innerHTML insertion of HTML fragments,
         * and it allows for the innerHTML to be read for the first node in the node list.
         * Since dojo/NodeList-html already took the "html" name, this method is called
         * "innerHTML". However, if dojo/NodeList-html has not been loaded yet, this
         * module will define an "html" method that can be used instead. Be careful if you
         * are working in an environment where it is possible that dojo/NodeList-html could
         * have been loaded, since its definition of "html" will take precedence.
         * The nodes represented by the value argument will be cloned if more than one
         * node is in this NodeList. The nodes in this NodeList are returned in the "set"
         * usage of this method, not the HTML that was inserted.
         * 
         * @param value               Optional            
         */
        html(value: NodeList): any;
        /**
         * see dojo/_base/array.indexOf(). The primary difference is that the acted-on
         * array is implicitly this NodeList
         * For more details on the behavior of indexOf, see Mozilla's
         * indexOf
         * docs
         * 
         * @param value The value to search for.             
         * @param fromIndex               OptionalThe location to start searching from. Optional. Defaults to 0.             
         */
        indexOf(value: Object, fromIndex: number): any;
        /**
         * allows setting the innerHTML of each node in the NodeList,
         * if there is a value passed in, otherwise, reads the innerHTML value of the first node.
         * This method is simpler than the dojo/NodeList.html() method provided by
         * dojo/NodeList-html. This method just does proper innerHTML insertion of HTML fragments,
         * and it allows for the innerHTML to be read for the first node in the node list.
         * Since dojo/NodeList-html already took the "html" name, this method is called
         * "innerHTML". However, if dojo/NodeList-html has not been loaded yet, this
         * module will define an "html" method that can be used instead. Be careful if you
         * are working in an environment where it is possible that dojo/NodeList-html could
         * have been loaded, since its definition of "html" will take precedence.
         * The nodes represented by the value argument will be cloned if more than one
         * node is in this NodeList. The nodes in this NodeList are returned in the "set"
         * usage of this method, not the HTML that was inserted.
         * 
         * @param value               Optional            
         */
        innerHTML(value: String): any;
        /**
         * allows setting the innerHTML of each node in the NodeList,
         * if there is a value passed in, otherwise, reads the innerHTML value of the first node.
         * This method is simpler than the dojo/NodeList.html() method provided by
         * dojo/NodeList-html. This method just does proper innerHTML insertion of HTML fragments,
         * and it allows for the innerHTML to be read for the first node in the node list.
         * Since dojo/NodeList-html already took the "html" name, this method is called
         * "innerHTML". However, if dojo/NodeList-html has not been loaded yet, this
         * module will define an "html" method that can be used instead. Be careful if you
         * are working in an environment where it is possible that dojo/NodeList-html could
         * have been loaded, since its definition of "html" will take precedence.
         * The nodes represented by the value argument will be cloned if more than one
         * node is in this NodeList. The nodes in this NodeList are returned in the "set"
         * usage of this method, not the HTML that was inserted.
         * 
         * @param value               Optional            
         */
        innerHTML(value: HTMLElement): any;
        /**
         * allows setting the innerHTML of each node in the NodeList,
         * if there is a value passed in, otherwise, reads the innerHTML value of the first node.
         * This method is simpler than the dojo/NodeList.html() method provided by
         * dojo/NodeList-html. This method just does proper innerHTML insertion of HTML fragments,
         * and it allows for the innerHTML to be read for the first node in the node list.
         * Since dojo/NodeList-html already took the "html" name, this method is called
         * "innerHTML". However, if dojo/NodeList-html has not been loaded yet, this
         * module will define an "html" method that can be used instead. Be careful if you
         * are working in an environment where it is possible that dojo/NodeList-html could
         * have been loaded, since its definition of "html" will take precedence.
         * The nodes represented by the value argument will be cloned if more than one
         * node is in this NodeList. The nodes in this NodeList are returned in the "set"
         * usage of this method, not the HTML that was inserted.
         * 
         * @param value               Optional            
         */
        innerHTML(value: NodeList): any;
        /**
         * The nodes in this NodeList will be placed after the nodes
         * matched by the query passed to insertAfter.
         * The nodes in this NodeList will be cloned if the query
         * matches more than one element. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param query             
         */
        insertAfter(query: String): any;
        /**
         * The nodes in this NodeList will be placed after the nodes
         * matched by the query passed to insertAfter.
         * The nodes in this NodeList will be cloned if the query
         * matches more than one element. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param query             
         */
        insertBefore(query: String): any;
        /**
         * Create a new instance of a specified class, using the
         * specified properties and each node in the NodeList as a
         * srcNodeRef.
         * 
         * @param declaredClass             
         * @param properties               Optional            
         */
        instantiate(declaredClass: String, properties: Object): any;
        /**
         * Create a new instance of a specified class, using the
         * specified properties and each node in the NodeList as a
         * srcNodeRef.
         * 
         * @param declaredClass             
         * @param properties               Optional            
         */
        instantiate(declaredClass: Object, properties: Object): any;
        /**
         * Returns the last node in this dojo/NodeList as a dojo/NodeList.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         */
        last(): any;
        /**
         * see dojo/_base/array.lastIndexOf(). The primary difference is that the
         * acted-on array is implicitly this NodeList
         * For more details on the behavior of lastIndexOf, see
         * Mozilla's lastIndexOf
         * docs
         * 
         * @param value The value to search for.             
         * @param fromIndex               OptionalThe location to start searching from. Optional. Defaults to 0.             
         */
        lastIndexOf(value: Object, fromIndex: number): any;
        /**
         * see dojo/_base/array.map(). The primary difference is that the acted-on
         * array is implicitly this NodeList and the return is a
         * NodeList (a subclass of Array)
         * 
         * @param func             
         * @param obj               Optional            
         */
        map(func: Function, obj: Function): any;
        /**
         * Returns margin-box size of nodes
         * 
         */
        marginBox(): void;
        /**
         * Returns the next element for nodes in this dojo/NodeList.
         * Optionally takes a query to filter the next elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        next(query: String): any;
        /**
         * Returns all sibling elements that come after the nodes in this dojo/NodeList.
         * Optionally takes a query to filter the sibling elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        nextAll(query: String): any;
        /**
         * Returns the odd nodes in this dojo/NodeList as a dojo/NodeList.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         */
        odd(): any;
        /**
         * Listen for events on the nodes in the NodeList. Basic usage is:
         * 
         * @param eventName             
         * @param listener             
         */
        on(eventName: any, listener: any): any;
        /**
         * removes elements in this list that match the filter
         * from their parents and returns them as a new NodeList.
         * 
         * @param filter               OptionalCSS selector like ".foo" or "div > span"             
         */
        orphan(filter: String): any;
        /**
         * Returns immediate parent elements for nodes in this dojo/NodeList.
         * Optionally takes a query to filter the parent elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        parent(query: String): any;
        /**
         * Returns all parent elements for nodes in this dojo/NodeList.
         * Optionally takes a query to filter the child elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        parents(query: String): any;
        /**
         * places elements of this node list relative to the first element matched
         * by queryOrNode. Returns the original NodeList. See: dojo/dom-construct.place
         * 
         * @param queryOrNode may be a string representing any valid CSS3 selector or a DOM node.In the selector case, only the first matching element will be usedfor relative positioning.             
         * @param position can be one of:"last" (default)"first""before""after""only""replace"or an offset in the childNodes property             
         */
        place(queryOrNode: String, position: String): any;
        /**
         * places elements of this node list relative to the first element matched
         * by queryOrNode. Returns the original NodeList. See: dojo/dom-construct.place
         * 
         * @param queryOrNode may be a string representing any valid CSS3 selector or a DOM node.In the selector case, only the first matching element will be usedfor relative positioning.             
         * @param position can be one of:"last" (default)"first""before""after""only""replace"or an offset in the childNodes property             
         */
        place(queryOrNode: HTMLElement, position: String): any;
        /**
         * Returns border-box objects (x/y/w/h) of all elements in a node list
         * as an Array (not a NodeList). Acts like dojo/dom-geometry-position, though
         * assumes the node passed is each node in this list.
         * 
         */
        position(): any;
        /**
         * prepends the content to every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        prepend(content: String): any;
        /**
         * prepends the content to every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        prepend(content: HTMLElement): any;
        /**
         * prepends the content to every node in the NodeList.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        prepend(content: NodeList): any;
        /**
         * prepends nodes in this NodeList to the nodes matched by
         * the query passed to prependTo.
         * The nodes in this NodeList will be cloned if the query
         * matches more than one element. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param query             
         */
        prependTo(query: String): any;
        /**
         * Returns the previous element for nodes in this dojo/NodeList.
         * Optionally takes a query to filter the previous elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        prev(query: String): any;
        /**
         * Returns all sibling elements that come before the nodes in this dojo/NodeList.
         * Optionally takes a query to filter the sibling elements.
         * The returned nodes will be in reverse DOM order -- the first node in the list will
         * be the node closest to the original node/NodeList.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        prevAll(query: String): any;
        /**
         * Returns a new list whose members match the passed query,
         * assuming elements of the current NodeList as the root for
         * each search.
         * 
         * @param queryStr             
         */
        query(queryStr: String): any;
        /**
         * removes elements in this list that match the filter
         * from their parents and returns them as a new NodeList.
         * 
         * @param filter               OptionalCSS selector like ".foo" or "div > span"             
         */
        remove(filter: String): any;
        /**
         * Removes an attribute from each node in the list.
         * 
         * @param name the name of the attribute to remove             
         */
        removeAttr(name: String): void;
        /**
         * removes the specified class from every node in the list
         * 
         * @param className               OptionalAn optional String class name to remove, or several space-separatedclass names, or an array of class names. If omitted, all class nameswill be deleted.             
         */
        removeClass(className: String): any;
        /**
         * removes the specified class from every node in the list
         * 
         * @param className               OptionalAn optional String class name to remove, or several space-separatedclass names, or an array of class names. If omitted, all class nameswill be deleted.             
         */
        removeClass(className: any[]): any;
        /**
         * Animate the effect of removing a class to all nodes in this list.
         * see dojox.fx.removeClass
         * 
         * @param cssClass             
         * @param args             
         */
        removeClassFx(cssClass: any, args: any): {type:Function;value:any};
        /**
         * Remove the data associated with these nodes.
         * 
         * @param key               OptionalIf omitted, clean all data for this node.If passed, remove the data item found at key             
         */
        removeData(key: String): void;
        /**
         * replaces nodes matched by the query passed to replaceAll with the nodes
         * in this NodeList.
         * The nodes in this NodeList will be cloned if the query
         * matches more than one element. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param query             
         */
        replaceAll(query: String): any;
        /**
         * Replaces one or more classes on a node if not present.
         * Operates more quickly than calling removeClass() and addClass()
         * 
         * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
         * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
         */
        replaceClass(addClassStr: String, removeClassStr: String): void;
        /**
         * Replaces one or more classes on a node if not present.
         * Operates more quickly than calling removeClass() and addClass()
         * 
         * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
         * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
         */
        replaceClass(addClassStr: any[], removeClassStr: String): void;
        /**
         * Replaces one or more classes on a node if not present.
         * Operates more quickly than calling removeClass() and addClass()
         * 
         * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
         * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
         */
        replaceClass(addClassStr: String, removeClassStr: any[]): void;
        /**
         * Replaces one or more classes on a node if not present.
         * Operates more quickly than calling removeClass() and addClass()
         * 
         * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
         * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
         */
        replaceClass(addClassStr: any[], removeClassStr: any[]): void;
        /**
         * Replaces each node in ths NodeList with the content passed to replaceWith.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        replaceWith(content: String): any;
        /**
         * Replaces each node in ths NodeList with the content passed to replaceWith.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        replaceWith(content: HTMLElement): any;
        /**
         * Replaces each node in ths NodeList with the content passed to replaceWith.
         * The content will be cloned if the length of NodeList
         * is greater than 1. Only the DOM nodes are cloned, not
         * any attached event handlers.
         * 
         * @param content             
         */
        replaceWith(content: NodeList): any;
        /**
         * Returns all sibling elements for nodes in this dojo/NodeList.
         * Optionally takes a query to filter the sibling elements.
         * .end() can be used on the returned dojo/NodeList to get back to the
         * original dojo/NodeList.
         * 
         * @param query               Optionala CSS selector.             
         */
        siblings(query: String): any;
        /**
         * Returns a new NodeList, maintaining this one in place
         * This method behaves exactly like the Array.slice method
         * with the caveat that it returns a dojo/NodeList and not a
         * raw Array. For more details, see Mozilla's slice
         * documentation
         * 
         * @param begin Can be a positive or negative integer, with positiveintegers noting the offset to begin at, and negativeintegers denoting an offset from the end (i.e., to the leftof the end)             
         * @param end               OptionalOptional parameter to describe what position relative tothe NodeList's zero index to end the slice at. Like begin,can be positive or negative.             
         */
        slice(begin: number, end: number): any;
        /**
         * slide all elements of the node list to the specified place via dojo/fx.slideTo()
         * 
         * @param args               OptionalAdditional dojo/_base/fx.Animation arguments to mix into this set with the addition ofan auto parameter.             
         */
        slideTo(args: Object): any;
        /**
         * Takes the same structure of arguments and returns as
         * dojo/_base/array.some() with the caveat that the passed array is
         * implicitly this NodeList.  See dojo/_base/array.some() and Mozilla's
         * Array.some
         * documentation.
         * 
         * @param callback the callback             
         * @param thisObject               Optionalthe context             
         */
        some(callback: Function, thisObject: Object): any;
        /**
         * Returns a new NodeList, manipulating this NodeList based on
         * the arguments passed, potentially splicing in new elements
         * at an offset, optionally deleting elements
         * This method behaves exactly like the Array.splice method
         * with the caveat that it returns a dojo/NodeList and not a
         * raw Array. For more details, see Mozilla's splice
         * documentation
         * For backwards compatibility, calling .end() on the spliced NodeList
         * does not return the original NodeList -- splice alters the NodeList in place.
         * 
         * @param index begin can be a positive or negative integer, with positiveintegers noting the offset to begin at, and negativeintegers denoting an offset from the end (i.e., to the leftof the end)             
         * @param howmany               OptionalOptional parameter to describe what position relative tothe NodeList's zero index to end the slice at. Like begin,can be positive or negative.             
         * @param item               OptionalAny number of optional parameters may be passed in to bespliced into the NodeList             
         */
        splice(index: number, howmany: number, item: Object[]): any;
        /**
         * gets or sets the CSS property for every element in the NodeList
         * 
         * @param property the CSS property to get/set, in JavaScript notation("lineHieght" instead of "line-height")             
         * @param value               Optionaloptional. The value to set the property to             
         */
        style(property: String, value: String): any;
        /**
         * allows setting the text value of each node in the NodeList,
         * if there is a value passed in, otherwise, returns the text value for all the
         * nodes in the NodeList in one string.
         * 
         * @param value             
         */
        text(value: String): any;
        /**
         * Adds a class to node if not present, or removes if present.
         * Pass a boolean condition if you want to explicitly add or remove.
         * 
         * @param className the CSS class to add             
         * @param condition               OptionalIf passed, true means to add the class, false means to remove.             
         */
        toggleClass(className: String, condition: boolean): void;
        /**
         * Animate the effect of adding or removing a class to all nodes in this list.
         * see dojox.fx.toggleClass
         * 
         * @param cssClass             
         * @param force             
         * @param args             
         */
        toggleClassFx(cssClass: any, force: any, args: any): {type:Function;value:any};
        /**
         * 
         */
        toString(): any;
        /**
         * If a value is passed, allows seting the value property of form elements in this
         * NodeList, or properly selecting/checking the right value for radio/checkbox/select
         * elements. If no value is passed, the value of the first node in this NodeList
         * is returned.
         * 
         * @param value             
         */
        val(value: String): any;
        /**
         * If a value is passed, allows seting the value property of form elements in this
         * NodeList, or properly selecting/checking the right value for radio/checkbox/select
         * elements. If no value is passed, the value of the first node in this NodeList
         * is returned.
         * 
         * @param value             
         */
        val(value: any[]): any;
        /**
         * wipe in all elements of this NodeList via dojo/fx.wipeIn()
         * 
         * @param args               OptionalAdditional dojo/_base/fx.Animation arguments to mix into this set with the addition ofan auto parameter.             
         */
        wipeIn(args: Object): any;
        /**
         * wipe out all elements of this NodeList via dojo/fx.wipeOut()
         * 
         * @param args               OptionalAdditional dojo/_base/fx.Animation arguments to mix into this set with the addition ofan auto parameter.             
         */
        wipeOut(args: Object): any;
        /**
         * Wrap each node in the NodeList with html passed to wrap.
         * html will be cloned if the NodeList has more than one
         * element. Only DOM nodes are cloned, not any attached
         * event handlers.
         * 
         * @param html             
         */
        wrap(html: String): any;
        /**
         * Wrap each node in the NodeList with html passed to wrap.
         * html will be cloned if the NodeList has more than one
         * element. Only DOM nodes are cloned, not any attached
         * event handlers.
         * 
         * @param html             
         */
        wrap(html: HTMLElement): any;
        /**
         * Insert html where the first node in this NodeList lives, then place all
         * nodes in this NodeList as the child of the html.
         * 
         * @param html             
         */
        wrapAll(html: String): any;
        /**
         * Insert html where the first node in this NodeList lives, then place all
         * nodes in this NodeList as the child of the html.
         * 
         * @param html             
         */
        wrapAll(html: HTMLElement): any;
        /**
         * For each node in the NodeList, wrap all its children with the passed in html.
         * html will be cloned if the NodeList has more than one
         * element. Only DOM nodes are cloned, not any attached
         * event handlers.
         * 
         * @param html             
         */
        wrapInner(html: String): any;
        /**
         * For each node in the NodeList, wrap all its children with the passed in html.
         * html will be cloned if the NodeList has more than one
         * element. Only DOM nodes are cloned, not any attached
         * event handlers.
         * 
         * @param html             
         */
        wrapInner(html: HTMLElement): any;
    }
    module NodeList {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/NodeList._nodeDataCache.html
         *
         * 
         */
        interface _nodeDataCache {
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/Stateful.html
     *
     * Base class for objects that provide named properties with optional getter/setter
     * control and the ability to watch for property changes
     * 
     * The class also provides the functionality to auto-magically manage getters
     * and setters for object attributes/properties.
     * 
     * Getters and Setters should follow the format of _xxxGetter or _xxxSetter where 
     * the xxx is a name of the attribute to handle.  So an attribute of "foo" 
     * would have a custom getter of _fooGetter and a custom setter of _fooSetter.
     * 
     */
    class Stateful {
        constructor();
        inherited: {(args: IArguments): any};
        /**
         * Get a property on a Stateful instance.
         * Get a named property on a Stateful object. The property may
         * potentially be retrieved via a getter method in subclasses. In the base class
         * this just retrieves the object's property.
         * 
         * @param name The property to get.             
         */
        get(name: String): any;
        /**
         * 
         * @param params               Optional            
         */
        postscript(params: Object): void;
        /**
         * Set a property on a Stateful instance
         * Sets named properties on a stateful object and notifies any watchers of
         * the property. A programmatic setter may be defined in subclasses.
         * 
         * @param name The property to set.             
         * @param value The value to set in the property.             
         */
        set(name: String, value: Object): any;
        /**
         * Watches a property for changes
         * 
         * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
         * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
         */
        watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
    }
    module _base {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/declare.html
         *
         * Create a feature-rich constructor from compact notation.
         * Create a constructor using a compact notation for inheritance and
         * prototype extension.
         * 
         * Mixin ancestors provide a type of multiple inheritance.
         * Prototypes of mixin ancestors are copied to the new class:
         * changes to mixin prototypes will not affect classes to which
         * they have been mixed in.
         * 
         * Ancestors can be compound classes created by this version of
         * declare(). In complex cases all base classes are going to be
         * linearized according to C3 MRO algorithm
         * (see http://www.python.org/download/releases/2.3/mro/ for more
         * details).
         * 
         * "className" is cached in "declaredClass" property of the new class,
         * if it was supplied. The immediate super class will be cached in
         * "superclass" property of the new class.
         * 
         * Methods in "props" will be copied and modified: "nom" property
         * (the declared name of the method) will be added to all copied
         * functions to help identify them for the internal machinery. Be
         * very careful, while reusing methods: if you use the same
         * function under different names, it can produce errors in some
         * cases.
         * 
         * It is possible to use constructors created "manually" (without
         * declare()) as bases. They will be called as usual during the
         * creation of an instance, their methods will be chained, and even
         * called by "this.inherited()".
         * 
         * Special property "-chains-" governs how to chain methods. It is
         * a dictionary, which uses method names as keys, and hint strings
         * as values. If a hint string is "after", this method will be
         * called after methods of its base classes. If a hint string is
         * "before", this method will be called before methods of its base
         * classes.
         * 
         * If "constructor" is not mentioned in "-chains-" property, it will
         * be chained using the legacy mode: using "after" chaining,
         * calling preamble() method before each constructor, if available,
         * and calling postscript() after all constructors were executed.
         * If the hint is "after", it is chained as a regular method, but
         * postscript() will be called after the chain of constructors.
         * "constructor" cannot be chained "before", but it allows
         * a special hint string: "manual", which means that constructors
         * are not going to be chained in any way, and programmer will call
         * them manually using this.inherited(). In the latter case
         * postscript() will be called after the construction.
         * 
         * All chaining hints are "inherited" from base classes and
         * potentially can be overridden. Be very careful when overriding
         * hints! Make sure that all chained methods can work in a proposed
         * manner of chaining.
         * 
         * Once a method was chained, it is impossible to unchain it. The
         * only exception is "constructor". You don't need to define a
         * method in order to supply a chaining hint.
         * 
         * If a method is chained, it cannot use this.inherited() because
         * all other methods in the hierarchy will be called automatically.
         * 
         * Usually constructors and initializers of any kind are chained
         * using "after" and destructors of any kind are chained as
         * "before". Note that chaining assumes that chained methods do not
         * return any value: any returned value will be discarded.
         * 
         * @param className       OptionalThe optional name of the constructor (loosely, a "class")stored in the "declaredClass" property in the created prototype.It will be used as a global name for a created constructor.     
         * @param superclass May be null, a Function, or an Array of Functions. This argumentspecifies a list of bases (the left-most one is the most deepestbase).     
         * @param props An object whose properties are copied to the created prototype.Add an instance-initialization function by making it a propertynamed "constructor".     
         */
        interface declare { (className?: String, superclass?: any, props?: Object): any}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/declare.html
         *
         * Create a feature-rich constructor from compact notation.
         * Create a constructor using a compact notation for inheritance and
         * prototype extension.
         * 
         * Mixin ancestors provide a type of multiple inheritance.
         * Prototypes of mixin ancestors are copied to the new class:
         * changes to mixin prototypes will not affect classes to which
         * they have been mixed in.
         * 
         * Ancestors can be compound classes created by this version of
         * declare(). In complex cases all base classes are going to be
         * linearized according to C3 MRO algorithm
         * (see http://www.python.org/download/releases/2.3/mro/ for more
         * details).
         * 
         * "className" is cached in "declaredClass" property of the new class,
         * if it was supplied. The immediate super class will be cached in
         * "superclass" property of the new class.
         * 
         * Methods in "props" will be copied and modified: "nom" property
         * (the declared name of the method) will be added to all copied
         * functions to help identify them for the internal machinery. Be
         * very careful, while reusing methods: if you use the same
         * function under different names, it can produce errors in some
         * cases.
         * 
         * It is possible to use constructors created "manually" (without
         * declare()) as bases. They will be called as usual during the
         * creation of an instance, their methods will be chained, and even
         * called by "this.inherited()".
         * 
         * Special property "-chains-" governs how to chain methods. It is
         * a dictionary, which uses method names as keys, and hint strings
         * as values. If a hint string is "after", this method will be
         * called after methods of its base classes. If a hint string is
         * "before", this method will be called before methods of its base
         * classes.
         * 
         * If "constructor" is not mentioned in "-chains-" property, it will
         * be chained using the legacy mode: using "after" chaining,
         * calling preamble() method before each constructor, if available,
         * and calling postscript() after all constructors were executed.
         * If the hint is "after", it is chained as a regular method, but
         * postscript() will be called after the chain of constructors.
         * "constructor" cannot be chained "before", but it allows
         * a special hint string: "manual", which means that constructors
         * are not going to be chained in any way, and programmer will call
         * them manually using this.inherited(). In the latter case
         * postscript() will be called after the construction.
         * 
         * All chaining hints are "inherited" from base classes and
         * potentially can be overridden. Be very careful when overriding
         * hints! Make sure that all chained methods can work in a proposed
         * manner of chaining.
         * 
         * Once a method was chained, it is impossible to unchain it. The
         * only exception is "constructor". You don't need to define a
         * method in order to supply a chaining hint.
         * 
         * If a method is chained, it cannot use this.inherited() because
         * all other methods in the hierarchy will be called automatically.
         * 
         * Usually constructors and initializers of any kind are chained
         * using "after" and destructors of any kind are chained as
         * "before". Note that chaining assumes that chained methods do not
         * return any value: any returned value will be discarded.
         * 
         * @param className       OptionalThe optional name of the constructor (loosely, a "class")stored in the "declaredClass" property in the created prototype.It will be used as a global name for a created constructor.     
         * @param superclass May be null, a Function, or an Array of Functions. This argumentspecifies a list of bases (the left-most one is the most deepestbase).     
         * @param props An object whose properties are copied to the created prototype.Add an instance-initialization function by making it a propertynamed "constructor".     
         */
        interface declare{(className?: String, superclass?: any[], props?: Object): any}
        interface declare {
            /**
             * Mix in properties skipping a constructor and decorating functions
             * like it is done by declare().
             * This function is used to mix in properties like lang.mixin does,
             * but it skips a constructor property and decorates functions like
             * declare() does.
             * 
             * It is meant to be used with classes and objects produced with
             * declare. Functions mixed in with dojo.safeMixin can use
             * this.inherited() like normal methods.
             * 
             * This function is used to implement extend() method of a constructor
             * produced with declare().
             * 
             * @param target Target object to accept new properties.             
             * @param source Source object for new properties.             
             */
            safeMixin(target: Object, source: Object): Object;
        }

        module declare {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/declare.__DeclareCreatedObject.html
             *
             * dojo/_base/declare() returns a constructor C.   new C() returns an Object with the following
             * methods, in addition to the methods and properties specified via the arguments passed to declare().
             * 
             */
            class __DeclareCreatedObject {
                constructor();
                /**
                 * Create a subclass of the declared class from a list of base classes.
                 * Create a constructor using a compact notation for inheritance and
                 * prototype extension.
                 * 
                 * Mixin ancestors provide a type of multiple inheritance.
                 * Prototypes of mixin ancestors are copied to the new class:
                 * changes to mixin prototypes will not affect classes to which
                 * they have been mixed in.
                 * 
                 * @param mixins Specifies a list of bases (the left-most one is the most deepestbase).             
                 * @param props               OptionalAn optional object whose properties are copied to the created prototype.             
                 */
                createSubclass(mixins: Function[], props: Object): dojo._base.declare.__DeclareCreatedObject;
                /**
                 * Adds all properties and methods of source to constructor's
                 * prototype, making them available to all instances created with
                 * constructor. This method is specific to constructors created with
                 * declare().
                 * Adds source properties to the constructor's prototype. It can
                 * override existing properties.
                 * 
                 * This method is similar to dojo.extend function, but it is specific
                 * to constructors produced by declare(). It is implemented
                 * using dojo.safeMixin, and it skips a constructor property,
                 * and properly decorates copied functions.
                 * 
                 * @param source Source object which properties are going to be copied to theconstructor's prototype.             
                 */
                extend(source: Object): void;
                /**
                 * Returns a super method.
                 * This method is a convenience method for "this.inherited()".
                 * It uses the same algorithm but instead of executing a super
                 * method, it returns it, or "undefined" if not found.
                 * 
                 * @param name               OptionalThe optional method name. Should be the same as the caller'sname. Usually "name" is specified in complex dynamic cases, whenthe calling method was dynamically added, undecorated bydeclare(), and it cannot be determined.             
                 * @param args The caller supply this argument, which should be the original"arguments".             
                 */
                getInherited(name: String, args: Object): any;
                /**
                 * Calls a super method.
                 * This method is used inside method of classes produced with
                 * declare() to call a super method (next in the chain). It is
                 * used for manually controlled chaining. Consider using the regular
                 * chaining, because it is faster. Use "this.inherited()" only in
                 * complex cases.
                 * 
                 * This method cannot me called from automatically chained
                 * constructors including the case of a special (legacy)
                 * constructor chaining. It cannot be called from chained methods.
                 * 
                 * If "this.inherited()" cannot find the next-in-chain method, it
                 * does nothing and returns "undefined". The last method in chain
                 * can be a default method implemented in Object, which will be
                 * called last.
                 * 
                 * If "name" is specified, it is assumed that the method that
                 * received "args" is the parent method for this call. It is looked
                 * up in the chain list and if it is found the next-in-chain method
                 * is called. If it is not found, the first-in-chain method is
                 * called.
                 * 
                 * If "name" is not specified, it will be derived from the calling
                 * method (using a methoid property "nom").
                 * 
                 * @param name               OptionalThe optional method name. Should be the same as the caller'sname. Usually "name" is specified in complex dynamic cases, whenthe calling method was dynamically added, undecorated bydeclare(), and it cannot be determined.             
                 * @param args The caller supply this argument, which should be the original"arguments".             
                 * @param newArgs               OptionalIf "true", the found function will be returned withoutexecuting it.If Array, it will be used to call a super method. Otherwise"args" will be used.             
                 */
                inherited(name: String, args: Object, newArgs: Object): any;
                /**
                 * Checks the inheritance chain to see if it is inherited from this
                 * class.
                 * This method is used with instances of classes produced with
                 * declare() to determine of they support a certain interface or
                 * not. It models "instanceof" operator.
                 * 
                 * @param cls Class constructor.             
                 */
                isInstanceOf(cls: Function): any;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/Deferred.html
         *
         * Deprecated.   This module defines the legacy dojo/_base/Deferred API.
         * New code should use dojo/Deferred instead.
         * The Deferred API is based on the concept of promises that provide a
         * generic interface into the eventual completion of an asynchronous action.
         * The motivation for promises fundamentally is about creating a
         * separation of concerns that allows one to achieve the same type of
         * call patterns and logical data flow in asynchronous code as can be
         * achieved in synchronous code. Promises allows one
         * to be able to call a function purely with arguments needed for
         * execution, without conflating the call with concerns of whether it is
         * sync or async. One shouldn't need to alter a call's arguments if the
         * implementation switches from sync to async (or vice versa). By having
         * async functions return promises, the concerns of making the call are
         * separated from the concerns of asynchronous interaction (which are
         * handled by the promise).
         * 
         * The Deferred is a type of promise that provides methods for fulfilling the
         * promise with a successful result or an error. The most important method for
         * working with Dojo's promises is the then() method, which follows the
         * CommonJS proposed promise API. An example of using a Dojo promise:
         * 
         * var resultingPromise = someAsyncOperation.then(function(result){
         *     ... handle result ...
         * },
         * function(error){
         *     ... handle error ...
         * });
         * The .then() call returns a new promise that represents the result of the
         * execution of the callback. The callbacks will never affect the original promises value.
         * 
         * The Deferred instances also provide the following functions for backwards compatibility:
         * 
         * addCallback(handler)
         * addErrback(handler)
         * callback(result)
         * errback(result)
         * Callbacks are allowed to return promises themselves, so
         * you can build complicated sequences of events with ease.
         * 
         * The creator of the Deferred may specify a canceller.  The canceller
         * is a function that will be called if Deferred.cancel is called
         * before the Deferred fires. You can use this to implement clean
         * aborting of an XMLHttpRequest, etc. Note that cancel will fire the
         * deferred with a CancelledError (unless your canceller returns
         * another kind of error), so the errbacks should be prepared to
         * handle that error for cancellable Deferreds.
         * 
         * @param canceller       Optional    
         */
        interface Deferred{(canceller?: Function): void}
        interface Deferred {
            /**
             * 
             */
            fired: number;
            /**
             * 
             */
            promise: Object;
            /**
             * Add handler as both successful callback and error callback for this deferred instance.
             * 
             * @param callback             
             */
            addBoth(callback: Function): any;
            /**
             * Adds successful callback for this deferred instance.
             * 
             * @param callback             
             */
            addCallback(callback: Function): any;
            /**
             * Adds callback and error callback for this deferred instance.
             * 
             * @param callback               OptionalThe callback attached to this deferred object.             
             * @param errback               OptionalThe error callback attached to this deferred object.             
             */
            addCallbacks(callback: Function, errback: Function): any;
            /**
             * Adds error callback for this deferred instance.
             * 
             * @param errback             
             */
            addErrback(errback: Function): any;
            /**
             * Fulfills the Deferred instance successfully with the provide value
             * 
             * @param value             
             */
            callback(value: any): void;
            /**
             * Cancels the asynchronous operation
             * 
             */
            cancel(): void;
            /**
             * Fulfills the Deferred instance as an error with the provided error
             * 
             * @param error             
             */
            errback(error: any): void;
            /**
             * Checks whether the deferred has been canceled.
             * 
             */
            isCanceled(): boolean;
            /**
             * Checks whether the deferred has been resolved or rejected.
             * 
             */
            isFulfilled(): boolean;
            /**
             * Checks whether the deferred has been rejected.
             * 
             */
            isRejected(): boolean;
            /**
             * Checks whether the deferred has been resolved.
             * 
             */
            isResolved(): boolean;
            /**
             * Send progress events to all listeners
             * 
             * @param update             
             */
            progress(update: any): void;
            /**
             * Fulfills the Deferred instance as an error with the provided error
             * 
             * @param error             
             */
            reject(error: any): void;
            /**
             * Fulfills the Deferred instance successfully with the provide value
             * 
             * @param value             
             */
            resolve(value: any): void;
            /**
             * Adds a fulfilledHandler, errorHandler, and progressHandler to be called for
             * completion of a promise. The fulfilledHandler is called when the promise
             * is fulfilled. The errorHandler is called when a promise fails. The
             * progressHandler is called for progress events. All arguments are optional
             * and non-function values are ignored. The progressHandler is not only an
             * optional argument, but progress events are purely optional. Promise
             * providers are not required to ever create progress events.
             * 
             * This function will return a new promise that is fulfilled when the given
             * fulfilledHandler or errorHandler callback is finished. This allows promise
             * operations to be chained together. The value returned from the callback
             * handler is the fulfillment value for the returned promise. If the callback
             * throws an error, the returned promise will be moved to failed state.
             * 
             * @param resolvedCallback               Optional            
             * @param errorCallback               Optional            
             * @param progressCallback               Optional            
             */
            then(resolvedCallback: Function, errorCallback: Function, progressCallback: Function): any;
            /**
             * Transparently applies callbacks to values and/or promises.
             * Accepts promises but also transparently handles non-promises. If no
             * callbacks are provided returns a promise, regardless of the initial
             * value. Foreign promises are converted.
             * 
             * If callbacks are provided and the initial value is not a promise,
             * the callback is executed immediately with no error handling. Returns
             * a promise if the initial value is a promise, or the result of the
             * callback otherwise.
             * 
             * @param valueOrPromise Either a regular value or an object with a then() method thatfollows the Promises/A specification.             
             * @param callback               OptionalCallback to be invoked when the promise is resolved, or a non-promiseis received.             
             * @param errback               OptionalCallback to be invoked when the promise is rejected.             
             * @param progback               OptionalCallback to be invoked when the promise emits a progress update.             
             */
            when(valueOrPromise: any, callback: Function, errback: Function, progback: Function): any;
        }

        module Deferred {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.html
         *
         * 
         */
        interface url{(): void}
        interface url {
            /**
             * 
             */
            authority: Object;
            /**
             * 
             */
            fragment: Object;
            /**
             * 
             */
            host: Object;
            /**
             * 
             */
            password: Object;
            /**
             * 
             */
            path: Object;
            /**
             * 
             */
            port: Object;
            /**
             * 
             */
            query: Object;
            /**
             * 
             */
            scheme: Object;
            /**
             * 
             */
            uri: Object;
            /**
             * 
             */
            user: Object;
            /**
             * 
             */
            toString(): void;
        }

        module url {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.authority.html
             *
             * 
             */
            interface authority {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.password.html
             *
             * 
             */
            interface password {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.port.html
             *
             * 
             */
            interface port {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.fragment.html
             *
             * 
             */
            interface fragment {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.query.html
             *
             * 
             */
            interface query {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.user.html
             *
             * 
             */
            interface user {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/url.scheme.html
             *
             * 
             */
            interface scheme {
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/xhr.html
         *
         * Deprecated.   Use dojo/request instead.
         * Sends an HTTP request with the given method.
         * See also dojo.xhrGet(), xhrPost(), xhrPut() and dojo.xhrDelete() for shortcuts
         * for those HTTP methods. There are also methods for "raw" PUT and POST methods
         * via dojo.rawXhrPut() and dojo.rawXhrPost() respectively.
         * 
         * @param method HTTP method to be used, such as GET, POST, PUT, DELETE. Should be uppercase.     
         * @param args     
         * @param hasBody       OptionalIf the request has an HTTP body, then pass true for hasBody.     
         */
        interface xhr{(method: String, args: Object, hasBody?: boolean): void}
        interface xhr {
            /**
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls.
             * 
             */
            contentHandlers: Object;
            /**
             * Sends an HTTP DELETE request to the server.
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            del(args: Object): any;
            /**
             * Serialize a form field to a JavaScript object.
             * Returns the value encoded in a form field as
             * as a string or an array of strings. Disabled form elements
             * and unchecked radio and checkboxes are skipped. Multi-select
             * elements are returned as an array of string values.
             * 
             * @param inputNode             
             */
            fieldToObject(inputNode: HTMLElement): any;
            /**
             * Serialize a form field to a JavaScript object.
             * Returns the value encoded in a form field as
             * as a string or an array of strings. Disabled form elements
             * and unchecked radio and checkboxes are skipped. Multi-select
             * elements are returned as an array of string values.
             * 
             * @param inputNode             
             */
            fieldToObject(inputNode: String): any;
            /**
             * Create a serialized JSON string from a form node or string
             * ID identifying the form to serialize
             * 
             * @param formNode             
             * @param prettyPrint               Optional            
             */
            formToJson(formNode: HTMLElement, prettyPrint: boolean): any;
            /**
             * Create a serialized JSON string from a form node or string
             * ID identifying the form to serialize
             * 
             * @param formNode             
             * @param prettyPrint               Optional            
             */
            formToJson(formNode: String, prettyPrint: boolean): any;
            /**
             * Serialize a form node to a JavaScript object.
             * Returns the values encoded in an HTML form as
             * string properties in an object which it then returns. Disabled form
             * elements, buttons, and other non-value form elements are skipped.
             * Multi-select elements are returned as an array of string values.
             * 
             * @param formNode             
             */
            formToObject(formNode: HTMLElement): Object;
            /**
             * Serialize a form node to a JavaScript object.
             * Returns the values encoded in an HTML form as
             * string properties in an object which it then returns. Disabled form
             * elements, buttons, and other non-value form elements are skipped.
             * Multi-select elements are returned as an array of string values.
             * 
             * @param formNode             
             */
            formToObject(formNode: String): Object;
            /**
             * Returns a URL-encoded string representing the form passed as either a
             * node or string ID identifying the form to serialize
             * 
             * @param formNode             
             */
            formToQuery(formNode: HTMLElement): any;
            /**
             * Returns a URL-encoded string representing the form passed as either a
             * node or string ID identifying the form to serialize
             * 
             * @param formNode             
             */
            formToQuery(formNode: String): any;
            /**
             * Sends an HTTP GET request to the server.
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            get(args: Object): any;
            /**
             * takes a name/value mapping object and returns a string representing
             * a URL-encoded version of that object.
             * 
             * @param map             
             */
            objectToQuery(map: Object): any;
            /**
             * Sends an HTTP POST request to the server. In addition to the properties
             * listed for the dojo.__XhrArgs type, the following property is allowed:
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            post(args: Object): any;
            /**
             * Sends an HTTP PUT request to the server. In addition to the properties
             * listed for the dojo.__XhrArgs type, the following property is allowed:
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            put(args: Object): any;
            /**
             * Create an object representing a de-serialized query section of a
             * URL. Query keys with multiple values are returned in an array.
             * 
             * @param str             
             */
            queryToObject(str: String): Object;
        }

        module xhr {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/xhr.contentHandlers.html
             *
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls.
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls. Each contentHandler is
             * called, passing the xhr object for manipulation. The return value
             * from the contentHandler will be passed to the load or handle
             * functions defined in the original xhr call.
             * 
             */
            interface contentHandlers {
                /**
                 * 
                 * @param xhr             
                 */
                auto(xhr: any): void;
                /**
                 * A contentHandler which evaluates the response data, expecting it to be valid JavaScript
                 * 
                 * @param xhr             
                 */
                javascript(xhr: any): any;
                /**
                 * A contentHandler which returns a JavaScript object created from the response data
                 * 
                 * @param xhr             
                 */
                json(xhr: any): any;
                /**
                 * A contentHandler which expects comment-filtered JSON.
                 * A contentHandler which expects comment-filtered JSON.
                 * the json-comment-filtered option was implemented to prevent
                 * "JavaScript Hijacking", but it is less secure than standard JSON. Use
                 * standard JSON instead. JSON prefixing can be used to subvert hijacking.
                 * 
                 * Will throw a notice suggesting to use application/json mimetype, as
                 * json-commenting can introduce security issues. To decrease the chances of hijacking,
                 * use the standard json contentHandler, and prefix your "JSON" with: {}&&
                 * 
                 * use djConfig.useCommentedJson = true to turn off the notice
                 * 
                 * @param xhr             
                 */
                json_comment_filtered(xhr: any): any;
                /**
                 * A contentHandler which checks the presence of comment-filtered JSON and
                 * alternates between the json and json-comment-filtered contentHandlers.
                 * 
                 * @param xhr             
                 */
                json_comment_optional(xhr: any): any;
                /**
                 * 
                 * @param xhr             
                 */
                olson_zoneinfo(xhr: any): void;
                /**
                 * A contentHandler which simply returns the plaintext response data
                 * 
                 * @param xhr             
                 */
                text(xhr: any): any;
                /**
                 * A contentHandler returning an XML Document parsed from the response data
                 * 
                 * @param xhr             
                 */
                xml(xhr: any): any;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/config.html
         *
         * This module defines the user configuration during bootstrap.
         * By defining user configuration as a module value, an entire configuration can be specified in a build,
         * thereby eliminating the need for sniffing and or explicitly setting in the global variable dojoConfig.
         * Also, when multiple instances of dojo exist in a single application, each will necessarily be located
         * at an unique absolute module identifier as given by the package configuration. Implementing configuration
         * as a module allows for specifying unique, per-instance configurations.
         * 
         */
        class config {
            constructor();
            /**
             * Adds a callback via dojo/ready. Useful when Dojo is added after
             * the page loads and djConfig.afterOnLoad is true. Supports the same
             * arguments as dojo/ready. When using a function reference, use
             * djConfig.addOnLoad = function(){};. For object with function name use
             * djConfig.addOnLoad = [myObject, "functionName"]; and for object with
             * function reference use
             * djConfig.addOnLoad = [myObject, function(){}];
             * 
             */
            "addOnLoad": Function;
            /**
             * 
             */
            "afterOnLoad": boolean;
            /**
             * 
             */
            "baseUrl": Object;
            /**
             * Defines a callback to be used when dependencies are defined before 
             * the loader has been loaded. When provided, they cause the loader to 
             * execute require(deps, callback) once it has finished loading. 
             * Should be used with deps.
             * 
             */
            "callback": Function;
            /**
             * 
             */
            "debugContainerId": string;
            /**
             * 
             */
            "debugHeight": number;
            /**
             * Default duration, in milliseconds, for wipe and fade animations within dijits.
             * Assigned to dijit.defaultDuration.
             * 
             */
            "defaultDuration": number;
            /**
             * Whether deferred instrumentation should be loaded or included
             * in builds.
             * 
             */
            "deferredInstrumentation": boolean;
            /**
             * Defines dependencies to be used before the loader has been loaded.
             * When provided, they cause the loader to execute require(deps, callback) 
             * once it has finished loading. Should be used with callback.
             * 
             */
            "deps": Function;
            /**
             * Used by some modules to configure an empty iframe. Used by dojo/io/iframe and
             * dojo/back, and dijit/popup support in IE where an iframe is needed to make sure native
             * controls do not bleed through the popups. Normally this configuration variable
             * does not need to be set, except when using cross-domain/CDN Dojo builds.
             * Save dojo/resources/blank.html to your domain and set djConfig.dojoBlankHtmlUrl
             * to the path on your domain your copy of blank.html.
             * 
             */
            "dojoBlankHtmlUrl": string;
            /**
             * No default value. Specifies additional locales whose
             * resources should also be loaded alongside the default locale when
             * calls to dojo.requireLocalization() are processed.
             * 
             */
            "extraLocale": any[];
            /**
             * Set this to true to enable publishing of topics for the different phases of
             * IO operations. Publishing is done via dojo/topic.publish(). See dojo/main.__IoPublish for a list
             * of topics that are published.
             * 
             */
            "ioPublish": Object;
            /**
             * Defaults to false. If set to true, ensures that Dojo provides
             * extended debugging feedback via Firebug. If Firebug is not available
             * on your platform, setting isDebug to true will force Dojo to
             * pull in (and display) the version of Firebug Lite which is
             * integrated into the Dojo distribution, thereby always providing a
             * debugging/logging console when isDebug is enabled. Note that
             * Firebug's console.* methods are ALWAYS defined by Dojo. If
             * isDebug is false and you are on a platform without Firebug, these
             * methods will be defined as no-ops.
             * 
             */
            "isDebug": boolean;
            /**
             * The locale to assume for loading localized resources in this page,
             * specified according to RFC 3066.
             * Must be specified entirely in lowercase, e.g. en-us and zh-cn.
             * See the documentation for dojo.i18n and dojo.requireLocalization
             * for details on loading localized resources. If no locale is specified,
             * Dojo assumes the locale of the user agent, according to navigator.userLanguage
             * or navigator.language properties.
             * 
             */
            "locale": string;
            /**
             * A map of module names to paths relative to dojo.baseUrl. The
             * key/value pairs correspond directly to the arguments which
             * dojo.registerModulePath accepts. Specifying
             * djConfig.modulePaths = { "foo": "../../bar" } is the equivalent
             * of calling dojo.registerModulePath("foo", "../../bar");. Multiple
             * modules may be configured via djConfig.modulePaths.
             * 
             */
            "modulePaths": Object;
            /**
             * Run the parser after the page is loaded
             * 
             */
            "parseOnLoad": boolean;
            /**
             * An array of module names to be loaded immediately after dojo.js has been included
             * in a page.
             * 
             */
            "require": Object;
            /**
             * Array containing the r, g, b components used as transparent color in dojo.Color;
             * if undefined, [255,255,255] (white) will be used.
             * 
             */
            "transparentColor": any[];
            /**
             * Used by dojox.analytics.Urchin as the default UA-123456-7 account
             * number used when being created. Alternately, you can pass an acct:""
             * parameter to the constructor a la: new dojox.analytics.Urchin({ acct:"UA-123456-7" });
             * 
             */
            "urchin": string;
            /**
             * If set to a value that evaluates to true such as a string or array and
             * isDebug is true and Firebug is not available or running, then it bypasses
             * the creation of Firebug Lite allowing you to define your own console object.
             * 
             */
            "useCustomLogger": Object;
            /**
             * Whether the deferred instrumentation should be used.
             * 
             * "report-rejections": report each rejection as it occurs.
             * true or 1 or "report-unhandled-rejections": wait 1 second
             *   in an attempt to detect unhandled rejections.
             * 
             */
            "useDeferredInstrumentation": boolean;
        }
        module config {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/config.modulePaths.html
             *
             * A map of module names to paths relative to dojo.baseUrl. The
             * key/value pairs correspond directly to the arguments which
             * dojo.registerModulePath accepts. Specifying
             * djConfig.modulePaths = { "foo": "../../bar" } is the equivalent
             * of calling dojo.registerModulePath("foo", "../../bar");. Multiple
             * modules may be configured via djConfig.modulePaths.
             * 
             */
            interface modulePaths {
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/Color.html
         *
         * Takes a named string, hex string, array of rgb or rgba values,
         * an object with r, g, b, and a properties, or another Color object
         * and creates a new Color instance to work from.
         * 
         * @param color     
         */
        class Color {
            constructor(color: any[]);
            /**
             * 
             */
            "a": number;
            /**
             * 
             */
            "b": number;
            /**
             * 
             */
            "g": number;
            /**
             * Dictionary list of all CSS named colors, by name. Values are 3-item arrays with corresponding RG and B values.
             * 
             */
            "named": Object;
            /**
             * 
             */
            "r": number;
            /**
             * Blend colors end and start with weight from 0 to 1, 0.5 being a 50/50 blend,
             * can reuse a previously allocated Color object for the result
             * 
             * @param start             
             * @param end             
             * @param weight             
             * @param obj               Optional            
             */
            blendColors(start: dojo._base.Color, end: dojo._base.Color, weight: number, obj: dojo._base.Color): any;
            /**
             * Builds a Color from a 3 or 4 element array, mapping each
             * element in sequence to the rgb(a) values of the color.
             * 
             * @param a             
             * @param obj               Optional            
             */
            fromArray(a: any[], obj: dojo._base.Color): any;
            /**
             * Converts a hex string with a '#' prefix to a color object.
             * Supports 12-bit #rgb shorthand. Optionally accepts a
             * Color object to update with the parsed value.
             * 
             * @param color             
             * @param obj               Optional            
             */
            fromHex(color: String, obj: dojo._base.Color): any;
            /**
             * get rgb(a) array from css-style color declarations
             * this function can handle all 4 CSS3 Color Module formats: rgb,
             * rgba, hsl, hsla, including rgb(a) with percentage values.
             * 
             * @param color             
             * @param obj               Optional            
             */
            fromRgb(color: String, obj: dojo._base.Color): any;
            /**
             * Parses str for a color value. Accepts hex, rgb, and rgba
             * style color values.
             * Acceptable input values for str may include arrays of any form
             * accepted by dojo.colorFromArray, hex strings such as "#aaaaaa", or
             * rgb or rgba strings such as "rgb(133, 200, 16)" or "rgba(10, 10,
             * 10, 50)"
             * 
             * @param str             
             * @param obj               Optional            
             */
            fromString(str: String, obj: dojo._base.Color): any;
            /**
             * creates a greyscale color with an optional alpha
             * 
             * @param g             
             * @param a               Optional            
             */
            makeGrey(g: number, a: number): void;
            /**
             * makes sure that the object has correct attributes
             * 
             */
            sanitize(): void;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and sets this color instance to that value.
             * 
             * @param color             
             */
            setColor(color: any[]): Function;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and sets this color instance to that value.
             * 
             * @param color             
             */
            setColor(color: String): Function;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and sets this color instance to that value.
             * 
             * @param color             
             */
            setColor(color: Object): Function;
            /**
             * Convert this Color to a CMY definition.
             * 
             */
            toCmy(): Object;
            /**
             * Convert this Color to a CMYK definition.
             * 
             */
            toCmyk(): Object;
            /**
             * Returns a css color string in rgb(a) representation
             * 
             * @param includeAlpha               Optional            
             */
            toCss(includeAlpha: boolean): String;
            /**
             * Returns a CSS color string in hexadecimal representation
             * 
             */
            toHex(): String;
            /**
             * Convert this Color to an HSL definition.
             * 
             */
            toHsl(): Object;
            /**
             * Convert this Color to an HSV definition.
             * 
             */
            toHsv(): Object;
            /**
             * Returns 3 component array of rgb values
             * 
             */
            toRgb(): any[];
            /**
             * Returns a 4 component array of rgba values from the color
             * represented by this object.
             * 
             */
            toRgba(): any[];
            /**
             * Returns a visual representation of the color
             * 
             */
            toString(): any;
        }
        module Color {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/Color.named.html
             *
             * Dictionary list of all CSS named colors, by name. Values are 3-item arrays with corresponding RG and B values.
             * 
             */
            interface named {
                /**
                 * 
                 */
                aliceblue: any[];
                /**
                 * 
                 */
                antiquewhite: any[];
                /**
                 * 
                 */
                aqua: any[];
                /**
                 * 
                 */
                aquamarine: any[];
                /**
                 * 
                 */
                azure: any[];
                /**
                 * 
                 */
                beige: any[];
                /**
                 * 
                 */
                bisque: any[];
                /**
                 * 
                 */
                black: any[];
                /**
                 * 
                 */
                blanchedalmond: any[];
                /**
                 * 
                 */
                blue: any[];
                /**
                 * 
                 */
                blueviolet: any[];
                /**
                 * 
                 */
                brown: any[];
                /**
                 * 
                 */
                burlywood: any[];
                /**
                 * 
                 */
                cadetblue: any[];
                /**
                 * 
                 */
                chartreuse: any[];
                /**
                 * 
                 */
                chocolate: any[];
                /**
                 * 
                 */
                coral: any[];
                /**
                 * 
                 */
                cornflowerblue: any[];
                /**
                 * 
                 */
                cornsilk: any[];
                /**
                 * 
                 */
                crimson: any[];
                /**
                 * 
                 */
                cyan: any[];
                /**
                 * 
                 */
                darkblue: any[];
                /**
                 * 
                 */
                darkcyan: any[];
                /**
                 * 
                 */
                darkgoldenrod: any[];
                /**
                 * 
                 */
                darkgray: any[];
                /**
                 * 
                 */
                darkgreen: any[];
                /**
                 * 
                 */
                darkgrey: any[];
                /**
                 * 
                 */
                darkkhaki: any[];
                /**
                 * 
                 */
                darkmagenta: any[];
                /**
                 * 
                 */
                darkolivegreen: any[];
                /**
                 * 
                 */
                darkorange: any[];
                /**
                 * 
                 */
                darkorchid: any[];
                /**
                 * 
                 */
                darkred: any[];
                /**
                 * 
                 */
                darksalmon: any[];
                /**
                 * 
                 */
                darkseagreen: any[];
                /**
                 * 
                 */
                darkslateblue: any[];
                /**
                 * 
                 */
                darkslategray: any[];
                /**
                 * 
                 */
                darkslategrey: any[];
                /**
                 * 
                 */
                darkturquoise: any[];
                /**
                 * 
                 */
                darkviolet: any[];
                /**
                 * 
                 */
                deeppink: any[];
                /**
                 * 
                 */
                deepskyblue: any[];
                /**
                 * 
                 */
                dimgray: any[];
                /**
                 * 
                 */
                dimgrey: any[];
                /**
                 * 
                 */
                dodgerblue: any[];
                /**
                 * 
                 */
                firebrick: any[];
                /**
                 * 
                 */
                floralwhite: any[];
                /**
                 * 
                 */
                forestgreen: any[];
                /**
                 * 
                 */
                fuchsia: any[];
                /**
                 * 
                 */
                gainsboro: any[];
                /**
                 * 
                 */
                ghostwhite: any[];
                /**
                 * 
                 */
                gold: any[];
                /**
                 * 
                 */
                goldenrod: any[];
                /**
                 * 
                 */
                gray: any[];
                /**
                 * 
                 */
                green: any[];
                /**
                 * 
                 */
                greenyellow: any[];
                /**
                 * 
                 */
                grey: any[];
                /**
                 * 
                 */
                honeydew: any[];
                /**
                 * 
                 */
                hotpink: any[];
                /**
                 * 
                 */
                indianred: any[];
                /**
                 * 
                 */
                indigo: any[];
                /**
                 * 
                 */
                ivory: any[];
                /**
                 * 
                 */
                khaki: any[];
                /**
                 * 
                 */
                lavender: any[];
                /**
                 * 
                 */
                lavenderblush: any[];
                /**
                 * 
                 */
                lawngreen: any[];
                /**
                 * 
                 */
                lemonchiffon: any[];
                /**
                 * 
                 */
                lightblue: any[];
                /**
                 * 
                 */
                lightcoral: any[];
                /**
                 * 
                 */
                lightcyan: any[];
                /**
                 * 
                 */
                lightgoldenrodyellow: any[];
                /**
                 * 
                 */
                lightgray: any[];
                /**
                 * 
                 */
                lightgreen: any[];
                /**
                 * 
                 */
                lightgrey: any[];
                /**
                 * 
                 */
                lightpink: any[];
                /**
                 * 
                 */
                lightsalmon: any[];
                /**
                 * 
                 */
                lightseagreen: any[];
                /**
                 * 
                 */
                lightskyblue: any[];
                /**
                 * 
                 */
                lightslategray: any[];
                /**
                 * 
                 */
                lightslategrey: any[];
                /**
                 * 
                 */
                lightsteelblue: any[];
                /**
                 * 
                 */
                lightyellow: any[];
                /**
                 * 
                 */
                lime: any[];
                /**
                 * 
                 */
                limegreen: any[];
                /**
                 * 
                 */
                linen: any[];
                /**
                 * 
                 */
                magenta: any[];
                /**
                 * 
                 */
                maroon: any[];
                /**
                 * 
                 */
                mediumaquamarine: any[];
                /**
                 * 
                 */
                mediumblue: any[];
                /**
                 * 
                 */
                mediumorchid: any[];
                /**
                 * 
                 */
                mediumpurple: any[];
                /**
                 * 
                 */
                mediumseagreen: any[];
                /**
                 * 
                 */
                mediumslateblue: any[];
                /**
                 * 
                 */
                mediumspringgreen: any[];
                /**
                 * 
                 */
                mediumturquoise: any[];
                /**
                 * 
                 */
                mediumvioletred: any[];
                /**
                 * 
                 */
                midnightblue: any[];
                /**
                 * 
                 */
                mintcream: any[];
                /**
                 * 
                 */
                mistyrose: any[];
                /**
                 * 
                 */
                moccasin: any[];
                /**
                 * 
                 */
                navajowhite: any[];
                /**
                 * 
                 */
                navy: any[];
                /**
                 * 
                 */
                oldlace: any[];
                /**
                 * 
                 */
                olive: any[];
                /**
                 * 
                 */
                olivedrab: any[];
                /**
                 * 
                 */
                orange: any[];
                /**
                 * 
                 */
                orangered: any[];
                /**
                 * 
                 */
                orchid: any[];
                /**
                 * 
                 */
                palegoldenrod: any[];
                /**
                 * 
                 */
                palegreen: any[];
                /**
                 * 
                 */
                paleturquoise: any[];
                /**
                 * 
                 */
                palevioletred: any[];
                /**
                 * 
                 */
                papayawhip: any[];
                /**
                 * 
                 */
                peachpuff: any[];
                /**
                 * 
                 */
                peru: any[];
                /**
                 * 
                 */
                pink: any[];
                /**
                 * 
                 */
                plum: any[];
                /**
                 * 
                 */
                powderblue: any[];
                /**
                 * 
                 */
                purple: any[];
                /**
                 * 
                 */
                red: any[];
                /**
                 * 
                 */
                rosybrown: any[];
                /**
                 * 
                 */
                royalblue: any[];
                /**
                 * 
                 */
                saddlebrown: any[];
                /**
                 * 
                 */
                salmon: any[];
                /**
                 * 
                 */
                sandybrown: any[];
                /**
                 * 
                 */
                seagreen: any[];
                /**
                 * 
                 */
                seashell: any[];
                /**
                 * 
                 */
                sienna: any[];
                /**
                 * 
                 */
                silver: any[];
                /**
                 * 
                 */
                skyblue: any[];
                /**
                 * 
                 */
                slateblue: any[];
                /**
                 * 
                 */
                slategray: any[];
                /**
                 * 
                 */
                slategrey: any[];
                /**
                 * 
                 */
                snow: any[];
                /**
                 * 
                 */
                springgreen: any[];
                /**
                 * 
                 */
                steelblue: any[];
                /**
                 * 
                 */
                tan: any[];
                /**
                 * 
                 */
                teal: any[];
                /**
                 * 
                 */
                thistle: any[];
                /**
                 * 
                 */
                tomato: any[];
                /**
                 * 
                 */
                transparent: Object;
                /**
                 * 
                 */
                turquoise: any[];
                /**
                 * 
                 */
                violet: any[];
                /**
                 * 
                 */
                wheat: any[];
                /**
                 * 
                 */
                white: any[];
                /**
                 * 
                 */
                whitesmoke: any[];
                /**
                 * 
                 */
                yellow: any[];
                /**
                 * 
                 */
                yellowgreen: any[];
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/browser.html
         *
         * This module causes the browser-only base modules to be loaded.
         * 
         */
        interface browser {
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/array.html
         *
         * The Javascript v1.6 array extensions.
         * 
         */
        interface array {
            /**
             * 
             */
            clearCache(): void;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: any[], callback: Function, thisObject?: Object): boolean;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: String, callback: Function, thisObject?: Object): boolean;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: any[], callback: String, thisObject?: Object): boolean;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: String, callback: String, thisObject?: Object): boolean;
            /**
             * Returns a new Array with those items from arr that match the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.filter() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's filter skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/filter
             * 
             * @param arr the array to iterate over.             
             * @param callback a function that is invoked with three arguments (item,index, array). The return of this function is expected tobe a boolean which determines whether the passed-in itemwill be included in the returned array.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            filter(arr: any[], callback: Function, thisObject?: Object): any[];
            /**
             * Returns a new Array with those items from arr that match the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.filter() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's filter skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/filter
             * 
             * @param arr the array to iterate over.             
             * @param callback a function that is invoked with three arguments (item,index, array). The return of this function is expected tobe a boolean which determines whether the passed-in itemwill be included in the returned array.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            filter(arr: any[], callback: String, thisObject?: Object): any[];
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: any[], callback: Function, thisObject?: Object): void;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: String, callback: Function, thisObject?: Object): void;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: any[], callback: String, thisObject?: Object): void;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: String, callback: String, thisObject?: Object): void;
            /**
             * locates the first index of the provided value in the
             * passed array. If the value is not found, -1 is returned.
             * This method corresponds to the JavaScript 1.6 Array.indexOf method, with two differences:
             * 
             * when run over sparse arrays, the Dojo function invokes the callback for every index
             * whereas JavaScript 1.6's indexOf skips the holes in the sparse array.
             * uses equality (==) rather than strict equality (===)
             * For details on this method, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/indexOf
             * 
             * @param arr             
             * @param value             
             * @param fromIndex               Optional            
             * @param findLast               OptionalMakes indexOf() work like lastIndexOf().  Used internally; not meant for external usage.             
             */
            indexOf(arr: any[], value: Object, fromIndex?: number, findLast?: boolean): number;
            /**
             * locates the last index of the provided value in the passed
             * array. If the value is not found, -1 is returned.
             * This method corresponds to the JavaScript 1.6 Array.lastIndexOf method, with two differences:
             * 
             * when run over sparse arrays, the Dojo function invokes the callback for every index
             * whereas JavaScript 1.6's lasIndexOf skips the holes in the sparse array.
             * uses equality (==) rather than strict equality (===)
             * For details on this method, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/lastIndexOf
             * 
             * @param arr             
             * @param value             
             * @param fromIndex               Optional            
             */
            lastIndexOf(arr: any, value: any, fromIndex?: number): number;
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: any[], callback: Function, thisObject: Object, Ctr: any): any[];
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: String, callback: Function, thisObject: Object, Ctr: any): any[];
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: any[], callback: String, thisObject: Object, Ctr: any): any[];
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: String, callback: String, thisObject: Object, Ctr: any): any[];
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: any[], callback: Function, thisObject?: Object): boolean;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: String, callback: Function, thisObject?: Object): boolean;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: any[], callback: String, thisObject?: Object): boolean;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: String, callback: String, thisObject?: Object): boolean;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/connect.html
         *
         * This module defines the dojo.connect API.
         * This modules also provides keyboard event handling helpers.
         * This module exports an extension event for emulating Firefox's keypress handling.
         * However, this extension event exists primarily for backwards compatibility and
         * is not recommended. WebKit and IE uses an alternate keypress handling (only
         * firing for printable characters, to distinguish from keydown events), and most
         * consider the WebKit/IE behavior more desirable.
         * 
         */
        interface connect {
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: Object, method: String, dontFix: boolean): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: any, method: String, dontFix: boolean): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: Object, method: Function, dontFix: boolean): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: any, method: Function, dontFix: boolean): any;
            /**
             * Ensure that every time obj.event() is called, a message is published
             * on the topic. Returns a handle which can be passed to
             * dojo.disconnect() to disable subsequent automatic publication on
             * the topic.
             * 
             * @param topic The name of the topic to publish.             
             * @param obj               OptionalThe source object for the event function. Defaults to kernel.globalif null.             
             * @param event The name of the event function in obj.I.e. identifies a property obj[event].             
             */
            connectPublisher(topic: String, obj: Object, event: String): any;
            /**
             * Remove a link created by dojo.connect.
             * Removes the connection between event and the method referenced by handle.
             * 
             * @param handle the return value of the dojo.connect call that created the connection.             
             */
            disconnect(handle: Object): void;
            /**
             * Checks an event for the copy key (meta on Mac, and ctrl anywhere else)
             * 
             * @param e Event object to examine             
             */
            isCopyKey(e: Event): any;
            /**
             * Invoke all listener method subscribed to topic.
             * 
             * @param topic The name of the topic to publish.             
             * @param args               OptionalAn array of arguments. The arguments will be appliedto each topic subscriber (as first class parameters, via apply).             
             */
            publish(topic: String, args: any[]): any;
            /**
             * Attach a listener to a named topic. The listener function is invoked whenever the
             * named topic is published (see: dojo.publish).
             * Returns a handle which is needed to unsubscribe this listener.
             * 
             * @param topic The topic to which to subscribe.             
             * @param context               OptionalScope in which method will be invoked, or null for default scope.             
             * @param method The name of a function in context, or a function reference. This is the function thatis invoked when topic is published.             
             */
            subscribe(topic: String, context: Object, method: String): any;
            /**
             * Attach a listener to a named topic. The listener function is invoked whenever the
             * named topic is published (see: dojo.publish).
             * Returns a handle which is needed to unsubscribe this listener.
             * 
             * @param topic The topic to which to subscribe.             
             * @param context               OptionalScope in which method will be invoked, or null for default scope.             
             * @param method The name of a function in context, or a function reference. This is the function thatis invoked when topic is published.             
             */
            subscribe(topic: String, context: Object, method: Function): any;
            /**
             * Remove a topic listener.
             * 
             * @param handle The handle returned from a call to subscribe.             
             */
            unsubscribe(handle: Object): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/event.html
         *
         * This module defines dojo DOM event API.   Usually you should use dojo/on, and evt.stopPropagation() +
         * evt.preventDefault(), rather than this module.
         * 
         */
        interface event {
            /**
             * normalizes properties on the event object including event
             * bubbling methods, keystroke normalization, and x/y positions
             * 
             * @param evt native event object             
             * @param sender node to treat as "currentTarget"             
             */
            fix(evt: Event, sender: HTMLElement): Event;
            /**
             * prevents propagation and clobbers the default action of the
             * passed event
             * 
             * @param evt The event object. If omitted, window.event is used on IE.             
             */
            stop(evt: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/html.html
         *
         * This module is a stub for the core dojo DOM API.
         * 
         */
        interface html {
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/json.html
         *
         * This module defines the dojo JSON API.
         * 
         */
        interface json {
        }

        module fx {
            /**
             * A generic animation class that fires callbacks into its handlers
             * object at various states.
             * A generic animation class that fires callbacks into its handlers
             * object at various states. Nearly all dojo animation functions
             * return an instance of this method, usually without calling the
             * .play() method beforehand. Therefore, you will likely need to
             * call .play() on instances of Animation when one is
             * returned.
             * 
             * @param args The 'magic argument', mixing all the properties into thisanimation instance.             
             */
            interface Animation { }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/fx.html
         *
         * This module defines the base dojo/_base/fx implementation.
         * 
         */
        interface fx {
            /**
             * A simpler interface to animateProperty(), also returns
             * an instance of Animation but begins the animation
             * immediately, unlike nearly every other Dojo animation API.
             * Simpler (but somewhat less powerful) version
             * of animateProperty.  It uses defaults for many basic properties
             * and allows for positional parameters to be used in place of the
             * packed "property bag" which is used for other Dojo animation
             * methods.
             * 
             * The Animation object returned will be already playing, so
             * calling play() on it again is (usually) a no-op.
             * 
             * @param node a DOM node or the id of a node to animate CSS properties on             
             * @param properties             
             * @param duration               OptionalThe number of milliseconds over which the animationshould run. Defaults to the global animation default duration(350ms).             
             * @param easing               OptionalAn easing function over which to calculate accelerationand deceleration of the animation through its duration.A default easing algorithm is provided, but you mayplug in any you wish. A large selection of easing algorithmsare available in dojo/fx/easing.             
             * @param onEnd               OptionalA function to be called when the animation finishesrunning.             
             * @param delay               OptionalThe number of milliseconds to delay beginning theanimation by. The default is 0.             
             */
            anim  (node: HTMLElement, properties: Object, duration: number, easing: Function, onEnd: Function, delay: number): any ;
            /**
             * A simpler interface to animateProperty(), also returns
             * an instance of Animation but begins the animation
             * immediately, unlike nearly every other Dojo animation API.
             * Simpler (but somewhat less powerful) version
             * of animateProperty.  It uses defaults for many basic properties
             * and allows for positional parameters to be used in place of the
             * packed "property bag" which is used for other Dojo animation
             * methods.
             * 
             * The Animation object returned will be already playing, so
             * calling play() on it again is (usually) a no-op.
             * 
             * @param node a DOM node or the id of a node to animate CSS properties on             
             * @param properties             
             * @param duration               OptionalThe number of milliseconds over which the animationshould run. Defaults to the global animation default duration(350ms).             
             * @param easing               OptionalAn easing function over which to calculate accelerationand deceleration of the animation through its duration.A default easing algorithm is provided, but you mayplug in any you wish. A large selection of easing algorithmsare available in dojo/fx/easing.             
             * @param onEnd               OptionalA function to be called when the animation finishesrunning.             
             * @param delay               OptionalThe number of milliseconds to delay beginning theanimation by. The default is 0.             
             */
            anim  (node: String, properties: Object, duration: number, easing: Function, onEnd: Function, delay: number): any ;
            /**
             * Returns an animation that will transition the properties of
             * node defined in args depending how they are defined in
             * args.properties
             * Foundation of most dojo/_base/fx
             * animations. It takes an object of "properties" corresponding to
             * style properties, and animates them in parallel over a set
             * duration.
             * 
             * @param args An object with the following properties:properties (Object, optional): A hash map of style properties to Objects describing the transition,such as the properties of _Line with an additional 'units' propertynode (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            animateProperty  (args: Object): any ;
            
            /**
             * Returns an animation that will fade node defined in 'args' from
             * its current opacity to fully opaque.
             * 
             * @param args An object with the following properties:node (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            fadeIn  (args: Object): any ;
            /**
             * Returns an animation that will fade node defined in 'args'
             * from its current opacity to fully transparent.
             * 
             * @param args An object with the following properties:node (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
             fadeOut  (args: Object): any ;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/query.html
         *
         * Deprecated.   Use dojo/query instead.
         * 
         */
        interface query {
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/NodeList.html
         *
         * This module extends dojo/NodeList with the legacy connect(), coords(),
         * blur(), focus(), change(), click(), error(), keydown(), keypress(),
         * keyup(), load(), mousedown(), mouseenter(), mouseleave(), mousemove(),
         * mouseout(), mouseover(), mouseup(), and submit() methods.
         * 
         */
        interface NodeList {
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/sniff.html
         *
         * Deprecated.   New code should use dojo/sniff.
         * This module populates the dojo browser version sniffing properties like dojo.isIE.
         * 
         */
        interface sniff {
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/lang.html
         *
         * This module defines Javascript language extensions.
         * 
         */
        interface lang {
            /**
             * Clones objects (including DOM nodes) and all children.
             * Warning: do not clone cyclic structures.
             * 
             * @param src The object to clone             
             */
            clone(src: any): any;
            /**
             * Returns a new object which "looks" to obj for properties which it
             * does not have a value for. Optionally takes a bag of properties to
             * seed the returned object with initially.
             * This is a small implementation of the Boodman/Crockford delegation
             * pattern in JavaScript. An intermediate object constructor mediates
             * the prototype chain for the returned object, using it to delegate
             * down to obj for property lookup when object-local lookup fails.
             * This can be thought of similarly to ES4's "wrap", save that it does
             * not act on types but rather on pure objects.
             * 
             * @param obj The object to delegate to for properties not found directly on thereturn object or in props.             
             * @param props an object containing properties to assign to the returned object             
             */
            delegate(obj: Object, props: Object[]): any;
            /**
             * determine if an object supports a given method
             * useful for longer api chains where you have to test each object in
             * the chain. Useful for object and method detection.
             * 
             * @param name Path to an object, in the form "A.B.C".             
             * @param obj               OptionalObject to use as root of path. Defaults to'dojo.global'. Null may be passed.             
             */
            exists(name: String, obj: Object): boolean;
            /**
             * Adds all properties and methods of props to constructor's
             * prototype, making them available to all instances created with
             * constructor.
             * 
             * @param ctor Target constructor to extend.             
             * @param props One or more objects to mix into ctor.prototype             
             */
            extend(ctor: Object, props: Object): Object;
            /**
             * Get a property from a dot-separated string, such as "A.B.C"
             * Useful for longer api chains where you have to test each object in
             * the chain, or when you have an object reference in string format.
             * 
             * @param name Path to an property, in the form "A.B.C".             
             * @param create               OptionalOptional. Defaults to false. If true, Objects will becreated at any point along the 'path' that is undefined.             
             * @param context               OptionalOptional. Object to use as root of path. Defaults to'dojo.global'. Null may be passed.             
             */
            getObject(name: String, create: boolean, context: Object): any;
            /**
             * Returns a function that will only ever execute in the a given scope.
             * This allows for easy use of object member functions
             * in callbacks and other places in which the "this" keyword may
             * otherwise not reference the expected scope.
             * Any number of default positional arguments may be passed as parameters
             * beyond "method".
             * Each of these values will be used to "placehold" (similar to curry)
             * for the hitched function.
             * 
             * @param scope The scope to use when method executes. If method is a string,scope is also the object containing method.             
             * @param method A function to be hitched to scope, or the name of the method inscope to be hitched.             
             */
            hitch(scope: Object, method: Function): any;
            /**
             * Returns a function that will only ever execute in the a given scope.
             * This allows for easy use of object member functions
             * in callbacks and other places in which the "this" keyword may
             * otherwise not reference the expected scope.
             * Any number of default positional arguments may be passed as parameters
             * beyond "method".
             * Each of these values will be used to "placehold" (similar to curry)
             * for the hitched function.
             * 
             * @param scope The scope to use when method executes. If method is a string,scope is also the object containing method.             
             * @param method A function to be hitched to scope, or the name of the method inscope to be hitched.             
             */
            hitch(scope: Object, method: String[]): any;
            /**
             * Returns true if it is a built-in function or some other kind of
             * oddball that should report as a function but doesn't
             * 
             * @param it             
             */
            isAlien(it: any): any;
            /**
             * Return true if it is an Array.
             * Does not work on Arrays created in other windows.
             * 
             * @param it Item to test.             
             */
            isArray(it: any): any;
            /**
             * similar to isArray() but more permissive
             * Doesn't strongly test for "arrayness".  Instead, settles for "isn't
             * a string or number and has a length property". Arguments objects
             * and DOM collections will return true when passed to
             * isArrayLike(), but will return false when passed to
             * isArray().
             * 
             * @param it Item to test.             
             */
            isArrayLike(it: any): any;
            /**
             * Return true if it is a Function
             * 
             * @param it Item to test.             
             */
            isFunction(it: any): boolean;
            /**
             * Returns true if it is a JavaScript object (or an Array, a Function
             * or null)
             * 
             * @param it Item to test.             
             */
            isObject(it: any): boolean;
            /**
             * Return true if it is a String
             * 
             * @param it Item to test.             
             */
            isString(it: any): boolean;
            /**
             * Copies/adds all properties of one or more sources to dest; returns dest.
             * All properties, including functions (sometimes termed "methods"), excluding any non-standard extensions
             * found in Object.prototype, are copied/added from sources to dest. sources are processed left to right.
             * The Javascript assignment operator is used to copy/add each property; therefore, by default, mixin
             * executes a so-called "shallow copy" and aggregate types are copied/added by reference.
             * 
             * @param dest The object to which to copy/add all properties contained in source. If dest is falsy, thena new object is manufactured before copying/adding properties begins.             
             * @param sources One of more objects from which to draw all properties to copy into dest. sources are processedleft-to-right and if more than one of these objects contain the same property name, the right-mostvalue "wins".             
             */
            mixin(dest: Object, sources: Object[]): Object;
            /**
             * similar to hitch() except that the scope object is left to be
             * whatever the execution context eventually becomes.
             * Calling lang.partial is the functional equivalent of calling:
             * 
             * lang.hitch(null, funcName, ...);
             * 
             * @param method The function to "wrap"             
             */
            partial(method: Function): any;
            /**
             * similar to hitch() except that the scope object is left to be
             * whatever the execution context eventually becomes.
             * Calling lang.partial is the functional equivalent of calling:
             * 
             * lang.hitch(null, funcName, ...);
             * 
             * @param method The function to "wrap"             
             */
            partial(method: String): any;
            /**
             * Performs parameterized substitutions on a string. Throws an
             * exception if any parameter is unmatched.
             * 
             * @param tmpl String to be used as a template.             
             * @param map If an object, it is used as a dictionary to look up substitutions.If a function, it is called for every substitution with following parameters:a whole match, a name, an offset, and the whole templatestring (see https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/String/replacefor more details).             
             * @param pattern               OptionalOptional regular expression objects that overrides the default pattern.Must be global and match one item. The default is: /{([^}]+)}/g,which matches patterns like that: "{xxx}", where "xxx" is any sequenceof characters, which doesn't include "}".             
             */
            replace(tmpl: String, map: Object, pattern: RegExp): String;
            /**
             * Performs parameterized substitutions on a string. Throws an
             * exception if any parameter is unmatched.
             * 
             * @param tmpl String to be used as a template.             
             * @param map If an object, it is used as a dictionary to look up substitutions.If a function, it is called for every substitution with following parameters:a whole match, a name, an offset, and the whole templatestring (see https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/String/replacefor more details).             
             * @param pattern               OptionalOptional regular expression objects that overrides the default pattern.Must be global and match one item. The default is: /{([^}]+)}/g,which matches patterns like that: "{xxx}", where "xxx" is any sequenceof characters, which doesn't include "}".             
             */
            replace(tmpl: String, map: Function, pattern: RegExp): String;
            /**
             * Set a property from a dot-separated string, such as "A.B.C"
             * Useful for longer api chains where you have to test each object in
             * the chain, or when you have an object reference in string format.
             * Objects are created as needed along path. Returns the passed
             * value if setting is successful or undefined if not.
             * 
             * @param name Path to a property, in the form "A.B.C".             
             * @param value value or object to place at location given by name             
             * @param context               OptionalOptional. Object to use as root of path. Defaults todojo.global.             
             */
            setObject(name: String, value: any, context: Object): any;
            /**
             * Trims whitespace from both sides of the string
             * This version of trim() was selected for inclusion into the base due
             * to its compact size and relatively good performance
             * (see Steven Levithan's blog
             * Uses String.prototype.trim instead, if available.
             * The fastest but longest version of this function is located at
             * lang.string.trim()
             * 
             * @param str String to be trimmed             
             */
            trim(str: String): String;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/unload.html
         *
         * This module contains the document and window unload detection API.
         * 
         */
        interface unload {
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Object, functionName: String): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Function, functionName: String): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Object, functionName: Function): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Function, functionName: Function): void;
            /**
             * registers a function to be triggered when window.onunload
             * fires.
             * The first time that addOnWindowUnload is called Dojo
             * will register a page listener to trigger your unload
             * handler with. Note that registering these handlers may
             * destroy "fastback" page caching in browsers that support
             * it. Be careful trying to modify the DOM or access
             * JavaScript properties during this phase of page unloading:
             * they may not always be available. Consider
             * addOnUnload() if you need to modify the DOM or do
             * heavy JavaScript work since it fires at the equivalent of
             * the page's "onbeforeunload" event.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnWindowUnload(obj: Object, functionName: String): void;
            /**
             * registers a function to be triggered when window.onunload
             * fires.
             * The first time that addOnWindowUnload is called Dojo
             * will register a page listener to trigger your unload
             * handler with. Note that registering these handlers may
             * destroy "fastback" page caching in browsers that support
             * it. Be careful trying to modify the DOM or access
             * JavaScript properties during this phase of page unloading:
             * they may not always be available. Consider
             * addOnUnload() if you need to modify the DOM or do
             * heavy JavaScript work since it fires at the equivalent of
             * the page's "onbeforeunload" event.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnWindowUnload(obj: Function, functionName: String): void;
            /**
             * registers a function to be triggered when window.onunload
             * fires.
             * The first time that addOnWindowUnload is called Dojo
             * will register a page listener to trigger your unload
             * handler with. Note that registering these handlers may
             * destroy "fastback" page caching in browsers that support
             * it. Be careful trying to modify the DOM or access
             * JavaScript properties during this phase of page unloading:
             * they may not always be available. Consider
             * addOnUnload() if you need to modify the DOM or do
             * heavy JavaScript work since it fires at the equivalent of
             * the page's "onbeforeunload" event.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnWindowUnload(obj: Object, functionName: Function): void;
            /**
             * registers a function to be triggered when window.onunload
             * fires.
             * The first time that addOnWindowUnload is called Dojo
             * will register a page listener to trigger your unload
             * handler with. Note that registering these handlers may
             * destroy "fastback" page caching in browsers that support
             * it. Be careful trying to modify the DOM or access
             * JavaScript properties during this phase of page unloading:
             * they may not always be available. Consider
             * addOnUnload() if you need to modify the DOM or do
             * heavy JavaScript work since it fires at the equivalent of
             * the page's "onbeforeunload" event.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnWindowUnload(obj: Function, functionName: Function): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/window.html
         *
         * API to save/set/restore the global/document scope.
         * 
         */
        interface window {
            /**
             * Alias for the current document. 'doc' can be modified
             * for temporary context shifting. See also withDoc().
             * 
             */
            doc: Object;
            /**
             * Alias for the current window. 'global' can be modified
             * for temporary context shifting. See also withGlobal().
             * 
             */
            global: Object;
            /**
             * Return the body element of the specified document or of dojo/_base/window::doc.
             * 
             * @param doc               Optional            
             */
            body(doc: HTMLDocument): any;
            /**
             * changes the behavior of many core Dojo functions that deal with
             * namespace and DOM lookup, changing them to work in a new global
             * context (e.g., an iframe). The varibles dojo.global and dojo.doc
             * are modified as a result of calling this function and the result of
             * dojo.body() likewise differs.
             * 
             * @param globalObject             
             * @param globalDocument             
             */
            setContext(globalObject: Object, globalDocument: HTMLDocument): void;
            /**
             * Invoke callback with documentObject as dojo/_base/window::doc.
             * Invoke callback with documentObject as dojo/_base/window::doc. If provided,
             * callback will be executed in the context of object thisObject
             * When callback() returns or throws an error, the dojo/_base/window::doc will
             * be restored to its previous state.
             * 
             * @param documentObject             
             * @param callback             
             * @param thisObject               Optional            
             * @param cbArguments               Optional            
             */
            withDoc(documentObject: HTMLDocument, callback: Function, thisObject: Object, cbArguments: any[]): any;
            /**
             * Invoke callback with globalObject as dojo.global and
             * globalObject.document as dojo.doc.
             * Invoke callback with globalObject as dojo.global and
             * globalObject.document as dojo.doc. If provided, globalObject
             * will be executed in the context of object thisObject
             * When callback() returns or throws an error, the dojo.global
             * and dojo.doc will be restored to its previous state.
             * 
             * @param globalObject             
             * @param callback             
             * @param thisObject               Optional            
             * @param cbArguments               Optional            
             */
            withGlobal(globalObject: Object, callback: Function, thisObject: Object, cbArguments: any[]): any;
        }
        module window {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/window.doc.html
             *
             * Alias for the current document. 'doc' can be modified
             * for temporary context shifting. See also withDoc().
             * Use this rather than referring to 'window.document' to ensure your code runs
             * correctly in managed contexts.
             * 
             */
            interface doc {
                /**
                 * 
                 */
                documentElement: Object;
                /**
                 * 
                 */
                dojoClick: boolean;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/window.global.html
             *
             * Alias for the current window. 'global' can be modified
             * for temporary context shifting. See also withGlobal().
             * Use this rather than referring to 'window' to ensure your code runs
             * correctly in managed contexts.
             * 
             */
            interface global {
                /**
                 * 
                 */
                $(): any;
                /**
                 * 
                 * @param start             
                 * @param data             
                 * @param responseCode             
                 * @param errorMsg             
                 */
                GoogleSearchStoreCallback_undefined_NaN(start: any, data: any, responseCode: any, errorMsg: any): void;
                /**
                 * 
                 */
                jQuery(): any;
                /**
                 * 
                 */
                swfIsInHTML(): void;
                /**
                 * 
                 */
                undefined_onload(): void;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.html
         *
         * This module is the foundational module of the dojo boot sequence; it defines the dojo object.
         * 
         */
        interface kernel {
            /**
             * Browser history management resources
             * 
             */
            back: Object;
            /**
             * 
             */
            baseUrl: string;
            /**
             * 
             */
            behavior: Object;
            /**
             * 
             */
            cldr: Object;
            /**
             * 
             */
            colors: Object;
            /**
             * This module defines the user configuration during bootstrap.
             * 
             */
            config: Object;
            /**
             * 
             */
            connectPublisher: Object;
            /**
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls.
             * 
             */
            contentHandlers: Object;
            /**
             * localized formatting and parsing routines for currencies
             * 
             */
            currency: Object;
            /**
             * 
             */
            data: Object;
            /**
             * 
             */
            date: Object;
            /**
             * 
             */
            dijit: Object;
            /**
             * 
             */
            dnd: Object;
            /**
             * Alias for the current document. 'doc' can be modified
             * for temporary context shifting. See also withDoc().
             * 
             */
            doc: Object;
            /**
             * 
             */
            dojox: Object;
            /**
             * Effects library on top of Base animations
             * 
             */
            fx: Object;
            /**
             * TODOC
             * 
             */
            gears: Object;
            /**
             * Alias for the current window. 'global' can be modified
             * for temporary context shifting. See also withGlobal().
             * 
             */
            global: Object;
            /**
             * TODOC
             * 
             */
            html: Object;
            /**
             * This module implements the dojo/i18n! plugin and the v1.6- i18n API
             * 
             */
            i18n: Object;
            /**
             * 
             */
            io: Object;
            /**
             * True if client is Adobe Air
             * 
             */
            isAir: boolean;
            /**
             * Version as a Number if client is android browser. undefined otherwise.
             * 
             */
            isAndroid: number;
            /**
             * 
             */
            isAsync: boolean;
            /**
             * 
             */
            isBrowser: boolean;
            /**
             * Version as a Number if client is Chrome browser. undefined otherwise.
             * 
             */
            isChrome: number;
            /**
             * 
             */
            isCopyKey: Object;
            /**
             * 
             */
            isFF: Object;
            /**
             * Version as a Number if client is MSIE(PC). undefined otherwise. Corresponds to
             * major detected IE version (6, 7, 8, etc.)
             * 
             */
            isIE: number;
            /**
             * Version as a Number if client is iPhone, iPod, or iPad. undefined otherwise.
             * 
             */
            isIos: number;
            /**
             * Version as a Number if client is a KHTML browser. undefined otherwise. Corresponds to major
             * detected version.
             * 
             */
            isKhtml: number;
            /**
             * True if the client runs on Mac
             * 
             */
            isMac: boolean;
            /**
             * 
             */
            isMoz: Object;
            /**
             * 
             */
            isMozilla: Object;
            /**
             * Version as a Number if client is Opera. undefined otherwise. Corresponds to
             * major detected version.
             * 
             */
            isOpera: number;
            /**
             * 
             */
            isQuirks: boolean;
            /**
             * Version as a Number if client is Safari or iPhone. undefined otherwise.
             * 
             */
            isSafari: number;
            /**
             * 
             */
            isSpidermonkey: boolean;
            /**
             * Version as a Number if client is a WebKit-derived browser (Konqueror,
             * Safari, Chrome, etc.). undefined otherwise.
             * 
             */
            isWebKit: number;
            /**
             * True if client is Wii
             * 
             */
            isWii: boolean;
            /**
             * Definitions for common key values.  Client code should test keyCode against these named constants,
             * as the actual codes can vary by browser.
             * 
             */
            keys: Object;
            /**
             * 
             */
            locale: Object;
            /**
             * 
             */
            mouseButtons: Object;
            /**
             * localized formatting and parsing routines for Number
             * 
             */
            number: Object;
            /**
             * 
             */
            parser: string;
            /**
             * 
             */
            publish: Object;
            /**
             * 
             */
            query: Object;
            /**
             * Regular expressions and Builder resources
             * 
             */
            regexp: Object;
            /**
             * 
             */
            rpc: Object;
            /**
             * 
             */
            scopeMap: Object;
            /**
             * 
             */
            store: Object;
            /**
             * String utilities for Dojo
             * 
             */
            string: Object;
            /**
             * 
             */
            subscribe: Object;
            /**
             * D.O.H. Test files for Dojo unit testing.
             * 
             */
            tests: Object;
            /**
             * 
             */
            toJsonIndentStr: string;
            /**
             * This module provides unified touch event handlers by exporting
             * press, move, release and cancel which can also run well on desktop.
             * Based on http://dvcs.w3.org/hg/webevents/raw-file/tip/touchevents.html
             * Also, if the dojoClick property is set to truthy on a DOM node, dojo/touch generates
             * click events immediately for this node and its descendants (except for descendants that
             * have a dojoClick property set to falsy), to avoid the delay before native browser click events,
             * and regardless of whether evt.preventDefault() was called in a touch.press event listener.
             * 
             */
            touch: Object;
            /**
             * Version number of the Dojo Toolkit
             * 
             */
            version: Object;
            /**
             * TODOC
             * 
             */
            window: Object;
            /**
             * A registry to make contextual calling/searching easier.
             * Objects of this class keep list of arrays in the form [name, check,
             * wrap, directReturn] that are used to determine what the contextual
             * result of a set of checked arguments is. All check/wrap functions
             * in this registry should be of the same arity.
             * 
             * @param returnWrappers               Optional            
             */
            AdapterRegistry(returnWrappers: boolean): void;
            /**
             * Adds the specified classes to the end of the class list on the
             * passed node. Will not re-apply duplicate classes.
             * 
             * @param node String ID or DomNode reference to add a class string too             
             * @param classStr A String class name to add, or several space-separated class names,or an array of class names.             
             */
            addClass(node: String, classStr: String): void;
            /**
             * Adds the specified classes to the end of the class list on the
             * passed node. Will not re-apply duplicate classes.
             * 
             * @param node String ID or DomNode reference to add a class string too             
             * @param classStr A String class name to add, or several space-separated class names,or an array of class names.             
             */
            addClass(node: HTMLElement, classStr: String): void;
            /**
             * Adds the specified classes to the end of the class list on the
             * passed node. Will not re-apply duplicate classes.
             * 
             * @param node String ID or DomNode reference to add a class string too             
             * @param classStr A String class name to add, or several space-separated class names,or an array of class names.             
             */
            addClass(node: String, classStr: any[]): void;
            /**
             * Adds the specified classes to the end of the class list on the
             * passed node. Will not re-apply duplicate classes.
             * 
             * @param node String ID or DomNode reference to add a class string too             
             * @param classStr A String class name to add, or several space-separated class names,or an array of class names.             
             */
            addClass(node: HTMLElement, classStr: any[]): void;
            /**
             * Add a function to execute on DOM content loaded and all requested modules have arrived and been evaluated.
             * In most cases, the domReady plug-in should suffice and this method should not be needed.
             * 
             * When called in a non-browser environment, just checks that all requested modules have arrived and been
             * evaluated.
             * 
             * @param priority               OptionalThe order in which to exec this callback relative to other callbacks, defaults to 1000             
             * @param context The context in which to run execute callback, or a callback if not using context             
             * @param callback               OptionalThe function to execute.             
             */
            addOnLoad(priority: number, context: any, callback: Function): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Object, functionName: String): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Function, functionName: String): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Object, functionName: Function): void;
            /**
             * registers a function to be triggered when the page unloads.
             * The first time that addOnUnload is called Dojo will
             * register a page listener to trigger your unload handler
             * with.
             * 
             * In a browser environment, the functions will be triggered
             * during the window.onbeforeunload event. Be careful of doing
             * too much work in an unload handler. onbeforeunload can be
             * triggered if a link to download a file is clicked, or if
             * the link is a javascript: link. In these cases, the
             * onbeforeunload event fires, but the document is not
             * actually destroyed. So be careful about doing destructive
             * operations in a dojo.addOnUnload callback.
             * 
             * Further note that calling dojo.addOnUnload will prevent
             * browsers from using a "fast back" cache to make page
             * loading via back button instantaneous.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnUnload(obj: Function, functionName: Function): void;
            /**
             * registers a function to be triggered when window.onunload fires.
             * Be careful trying to modify the DOM or access JavaScript properties
             * during this phase of page unloading: they may not always be available.
             * Consider dojo.addOnUnload() if you need to modify the DOM or do heavy
             * JavaScript work.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnWindowUnload(obj: Object, functionName: String): void;
            /**
             * registers a function to be triggered when window.onunload fires.
             * Be careful trying to modify the DOM or access JavaScript properties
             * during this phase of page unloading: they may not always be available.
             * Consider dojo.addOnUnload() if you need to modify the DOM or do heavy
             * JavaScript work.
             * 
             * @param obj               Optional            
             * @param functionName               Optional            
             */
            addOnWindowUnload(obj: Object, functionName: Function): void;
            /**
             * A simpler interface to animateProperty(), also returns
             * an instance of Animation but begins the animation
             * immediately, unlike nearly every other Dojo animation API.
             * Simpler (but somewhat less powerful) version
             * of animateProperty.  It uses defaults for many basic properties
             * and allows for positional parameters to be used in place of the
             * packed "property bag" which is used for other Dojo animation
             * methods.
             * 
             * The Animation object returned will be already playing, so
             * calling play() on it again is (usually) a no-op.
             * 
             * @param node a DOM node or the id of a node to animate CSS properties on             
             * @param properties             
             * @param duration               OptionalThe number of milliseconds over which the animationshould run. Defaults to the global animation default duration(350ms).             
             * @param easing               OptionalAn easing function over which to calculate accelerationand deceleration of the animation through its duration.A default easing algorithm is provided, but you mayplug in any you wish. A large selection of easing algorithmsare available in dojo/fx/easing.             
             * @param onEnd               OptionalA function to be called when the animation finishesrunning.             
             * @param delay               OptionalThe number of milliseconds to delay beginning theanimation by. The default is 0.             
             */
            anim(node: HTMLElement, properties: Object, duration: number, easing: Function, onEnd: Function, delay: number): any;
            /**
             * A simpler interface to animateProperty(), also returns
             * an instance of Animation but begins the animation
             * immediately, unlike nearly every other Dojo animation API.
             * Simpler (but somewhat less powerful) version
             * of animateProperty.  It uses defaults for many basic properties
             * and allows for positional parameters to be used in place of the
             * packed "property bag" which is used for other Dojo animation
             * methods.
             * 
             * The Animation object returned will be already playing, so
             * calling play() on it again is (usually) a no-op.
             * 
             * @param node a DOM node or the id of a node to animate CSS properties on             
             * @param properties             
             * @param duration               OptionalThe number of milliseconds over which the animationshould run. Defaults to the global animation default duration(350ms).             
             * @param easing               OptionalAn easing function over which to calculate accelerationand deceleration of the animation through its duration.A default easing algorithm is provided, but you mayplug in any you wish. A large selection of easing algorithmsare available in dojo/fx/easing.             
             * @param onEnd               OptionalA function to be called when the animation finishesrunning.             
             * @param delay               OptionalThe number of milliseconds to delay beginning theanimation by. The default is 0.             
             */
            anim(node: String, properties: Object, duration: number, easing: Function, onEnd: Function, delay: number): any;
            /**
             * Returns an animation that will transition the properties of
             * node defined in args depending how they are defined in
             * args.properties
             * Foundation of most dojo/_base/fx
             * animations. It takes an object of "properties" corresponding to
             * style properties, and animates them in parallel over a set
             * duration.
             * 
             * @param args An object with the following properties:properties (Object, optional): A hash map of style properties to Objects describing the transition,such as the properties of _Line with an additional 'units' propertynode (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            animateProperty(args: Object): any;
            /**
             * A generic animation class that fires callbacks into its handlers
             * object at various states.
             * A generic animation class that fires callbacks into its handlers
             * object at various states. Nearly all dojo animation functions
             * return an instance of this method, usually without calling the
             * .play() method beforehand. Therefore, you will likely need to
             * call .play() on instances of Animation when one is
             * returned.
             * 
             * @param args The 'magic argument', mixing all the properties into thisanimation instance.             
             */
            Animation(args: Object): void;
            /**
             * Gets or sets an attribute on an HTML element.
             * Handles normalized getting and setting of attributes on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the attribute on             
             * @param name the name of the attribute to get or set.             
             * @param value               OptionalThe value to set for the attribute             
             */
            attr(node: HTMLElement, name: String, value: String): any;
            /**
             * Gets or sets an attribute on an HTML element.
             * Handles normalized getting and setting of attributes on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the attribute on             
             * @param name the name of the attribute to get or set.             
             * @param value               OptionalThe value to set for the attribute             
             */
            attr(node: String, name: String, value: String): any;
            /**
             * Gets or sets an attribute on an HTML element.
             * Handles normalized getting and setting of attributes on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the attribute on             
             * @param name the name of the attribute to get or set.             
             * @param value               OptionalThe value to set for the attribute             
             */
            attr(node: HTMLElement, name: Object, value: String): any;
            /**
             * Gets or sets an attribute on an HTML element.
             * Handles normalized getting and setting of attributes on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the attribute on             
             * @param name the name of the attribute to get or set.             
             * @param value               OptionalThe value to set for the attribute             
             */
            attr(node: String, name: Object, value: String): any;
            /**
             * Blend colors end and start with weight from 0 to 1, 0.5 being a 50/50 blend,
             * can reuse a previously allocated Color object for the result
             * 
             * @param start             
             * @param end             
             * @param weight             
             * @param obj               Optional            
             */
            blendColors(start: dojo._base.Color, end: dojo._base.Color, weight: number, obj: dojo._base.Color): any;
            /**
             * Return the body element of the specified document or of dojo/_base/window::doc.
             * 
             * @param doc               Optional            
             */
            body(doc: HTMLDocument): any;
            /**
             * Returns DOM node with matching id attribute or falsy value (ex: null or undefined)
             * if not found.  If id is a DomNode, this function is a no-op.
             * 
             * @param id A string to match an HTML id attribute or a reference to a DOM Node             
             * @param doc               OptionalDocument to work in. Defaults to the current value ofdojo/_base/window.doc.  Can be used to retrievenode references from other documents.             
             */
            byId(id: String, doc: HTMLDocument): any;
            /**
             * Returns DOM node with matching id attribute or falsy value (ex: null or undefined)
             * if not found.  If id is a DomNode, this function is a no-op.
             * 
             * @param id A string to match an HTML id attribute or a reference to a DOM Node             
             * @param doc               OptionalDocument to work in. Defaults to the current value ofdojo/_base/window.doc.  Can be used to retrievenode references from other documents.             
             */
            byId(id: HTMLElement, doc: HTMLDocument): any;
            /**
             * A getter and setter for storing the string content associated with the
             * module and url arguments.
             * If module is a string that contains slashes, then it is interpretted as a fully
             * resolved path (typically a result returned by require.toUrl), and url should not be
             * provided. This is the preferred signature. If module is a string that does not
             * contain slashes, then url must also be provided and module and url are used to
             * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
             * If value is specified, the cache value for the moduleUrl will be set to
             * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
             * in its internal cache and return that cached value for the URL. To clear
             * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
             * the URL contents, only modules on the same domain of the page can use this capability.
             * The build system can inline the cache values though, to allow for xdomain hosting.
             * 
             * @param module dojo/cldr/supplemental             
             * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.             
             * @param value               OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.             
             */
            cache(module: String, url: String, value: String): any;
            /**
             * A getter and setter for storing the string content associated with the
             * module and url arguments.
             * If module is a string that contains slashes, then it is interpretted as a fully
             * resolved path (typically a result returned by require.toUrl), and url should not be
             * provided. This is the preferred signature. If module is a string that does not
             * contain slashes, then url must also be provided and module and url are used to
             * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
             * If value is specified, the cache value for the moduleUrl will be set to
             * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
             * in its internal cache and return that cached value for the URL. To clear
             * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
             * the URL contents, only modules on the same domain of the page can use this capability.
             * The build system can inline the cache values though, to allow for xdomain hosting.
             * 
             * @param module dojo/cldr/supplemental             
             * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.             
             * @param value               OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.             
             */
            cache(module: Object, url: String, value: String): any;
            /**
             * A getter and setter for storing the string content associated with the
             * module and url arguments.
             * If module is a string that contains slashes, then it is interpretted as a fully
             * resolved path (typically a result returned by require.toUrl), and url should not be
             * provided. This is the preferred signature. If module is a string that does not
             * contain slashes, then url must also be provided and module and url are used to
             * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
             * If value is specified, the cache value for the moduleUrl will be set to
             * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
             * in its internal cache and return that cached value for the URL. To clear
             * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
             * the URL contents, only modules on the same domain of the page can use this capability.
             * The build system can inline the cache values though, to allow for xdomain hosting.
             * 
             * @param module dojo/cldr/supplemental             
             * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.             
             * @param value               OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.             
             */
            cache(module: String, url: String, value: Object): any;
            /**
             * A getter and setter for storing the string content associated with the
             * module and url arguments.
             * If module is a string that contains slashes, then it is interpretted as a fully
             * resolved path (typically a result returned by require.toUrl), and url should not be
             * provided. This is the preferred signature. If module is a string that does not
             * contain slashes, then url must also be provided and module and url are used to
             * call dojo.moduleUrl() to generate a module URL. This signature is deprecated.
             * If value is specified, the cache value for the moduleUrl will be set to
             * that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
             * in its internal cache and return that cached value for the URL. To clear
             * a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
             * the URL contents, only modules on the same domain of the page can use this capability.
             * The build system can inline the cache values though, to allow for xdomain hosting.
             * 
             * @param module dojo/cldr/supplemental             
             * @param url The rest of the path to append to the path derived from the module argument. Ifmodule is an object, then this second argument should be the "value" argument instead.             
             * @param value               OptionalIf a String, the value to use in the cache for the module/url combination.If an Object, it can have two properties: value and sanitize. The value propertyshould be the value to use in the cache, and sanitize can be set to true or false,to indicate if XML declarations should be removed from the value and if the HTMLinside a body tag in the value should be extracted as the real value. The value argumentor the value property on the value argument are usually only used by the build systemas it inlines cache content.             
             */
            cache(module: Object, url: String, value: Object): any;
            /**
             * 
             */
            clearCache(): void;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and creates a new Color instance to work from.
             * 
             * @param color             
             */
            Color(color: any[]): void;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and creates a new Color instance to work from.
             * 
             * @param color             
             */
            Color(color: String): void;
            /**
             * Takes a named string, hex string, array of rgb or rgba values,
             * an object with r, g, b, and a properties, or another Color object
             * and creates a new Color instance to work from.
             * 
             * @param color             
             */
            Color(color: Object): void;
            /**
             * Builds a Color from a 3 or 4 element array, mapping each
             * element in sequence to the rgb(a) values of the color.
             * 
             * @param a             
             * @param obj               Optional            
             */
            colorFromArray(a: any[], obj: dojo._base.Color): any;
            /**
             * Converts a hex string with a '#' prefix to a color object.
             * Supports 12-bit #rgb shorthand. Optionally accepts a
             * Color object to update with the parsed value.
             * 
             * @param color             
             * @param obj               Optional            
             */
            colorFromHex(color: String, obj: dojo._base.Color): any;
            /**
             * get rgb(a) array from css-style color declarations
             * this function can handle all 4 CSS3 Color Module formats: rgb,
             * rgba, hsl, hsla, including rgb(a) with percentage values.
             * 
             * @param color             
             * @param obj               Optional            
             */
            colorFromRgb(color: String, obj: dojo._base.Color): any;
            /**
             * Parses str for a color value. Accepts hex, rgb, and rgba
             * style color values.
             * Acceptable input values for str may include arrays of any form
             * accepted by dojo.colorFromArray, hex strings such as "#aaaaaa", or
             * rgb or rgba strings such as "rgb(133, 200, 16)" or "rgba(10, 10,
             * 10, 50)"
             * 
             * @param str             
             * @param obj               Optional            
             */
            colorFromString(str: String, obj: dojo._base.Color): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: Object, method: String, dontFix: boolean): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: any, method: String, dontFix: boolean): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: Object, method: Function, dontFix: boolean): any;
            /**
             * dojo.connect is a deprecated event handling and delegation method in
             * Dojo. It allows one function to "listen in" on the execution of
             * any other, triggering the second whenever the first is called. Many
             * listeners may be attached to a function, and source functions may
             * be either regular function calls or DOM events.
             * Connects listeners to actions, so that after event fires, a
             * listener is called with the same arguments passed to the original
             * function.
             * 
             * Since dojo.connect allows the source of events to be either a
             * "regular" JavaScript function or a DOM event, it provides a uniform
             * interface for listening to all the types of events that an
             * application is likely to deal with though a single, unified
             * interface. DOM programmers may want to think of it as
             * "addEventListener for everything and anything".
             * 
             * When setting up a connection, the event parameter must be a
             * string that is the name of the method/event to be listened for. If
             * obj is null, kernel.global is assumed, meaning that connections
             * to global methods are supported but also that you may inadvertently
             * connect to a global by passing an incorrect object name or invalid
             * reference.
             * 
             * dojo.connect generally is forgiving. If you pass the name of a
             * function or method that does not yet exist on obj, connect will
             * not fail, but will instead set up a stub method. Similarly, null
             * arguments may simply be omitted such that fewer than 4 arguments
             * may be required to set up a connection See the examples for details.
             * 
             * The return value is a handle that is needed to
             * remove this connection with dojo.disconnect.
             * 
             * @param obj               OptionalThe source object for the event function.Defaults to kernel.global if null.If obj is a DOM node, the connection is delegatedto the DOM event manager (unless dontFix is true).             
             * @param event String name of the event function in obj.I.e. identifies a property obj[event].             
             * @param context The object that method will receive as "this".If context is null and method is a function, then methodinherits the context of event.If method is a string then context must be the sourceobject object for method (context[method]). If context is null,kernel.global is used.             
             * @param method A function reference, or name of a function in context.The function identified by method fires after event does.method receives the same arguments as the event.See context argument comments for information on method's scope.             
             * @param dontFix               OptionalIf obj is a DOM node, set dontFix to true to prevent delegationof this connection to the DOM event manager.             
             */
            connect(obj: Object, event: String, context: any, method: Function, dontFix: boolean): any;
            /**
             * Getter/setter for the content-box of node.
             * Returns an object in the expected format of box (regardless if box is passed).
             * The object might look like:
             * { l: 50, t: 200, w: 300: h: 150 }
             * for a node offset from its parent 50px to the left, 200px from
             * the top with a content width of 300px and a content-height of
             * 150px. Note that the content box may have a much larger border
             * or margin box, depending on the box model currently in use and
             * CSS values set/inherited for node.
             * While the getter will return top and left values, the
             * setter only accepts setting the width and height.
             * 
             * @param node id or reference to DOM Node to get/set box for             
             * @param box               OptionalIf passed, denotes that dojo.contentBox() shouldupdate/set the content box for node. Box is an object in theabove format, but only w (width) and h (height) are supported.All properties are optional if passed.             
             */
            contentBox(node: HTMLElement, box: Object): any;
            /**
             * Getter/setter for the content-box of node.
             * Returns an object in the expected format of box (regardless if box is passed).
             * The object might look like:
             * { l: 50, t: 200, w: 300: h: 150 }
             * for a node offset from its parent 50px to the left, 200px from
             * the top with a content width of 300px and a content-height of
             * 150px. Note that the content box may have a much larger border
             * or margin box, depending on the box model currently in use and
             * CSS values set/inherited for node.
             * While the getter will return top and left values, the
             * setter only accepts setting the width and height.
             * 
             * @param node id or reference to DOM Node to get/set box for             
             * @param box               OptionalIf passed, denotes that dojo.contentBox() shouldupdate/set the content box for node. Box is an object in theabove format, but only w (width) and h (height) are supported.All properties are optional if passed.             
             */
            contentBox(node: String, box: Object): any;
            /**
             * Get or set a cookie.
             * If one argument is passed, returns the value of the cookie
             * For two or more arguments, acts as a setter.
             * 
             * @param name Name of the cookie             
             * @param value               OptionalValue for the cookie             
             * @param props               OptionalProperties for the cookie             
             */
            cookie(name: String, value: String, props: Object): any;
            /**
             * Deprecated: Use position() for border-box x/y/w/h
             * or marginBox() for margin-box w/h/l/t.
             * 
             * Returns an object that measures margin-box (w)idth/(h)eight
             * and absolute position x/y of the border-box. Also returned
             * is computed (l)eft and (t)op values in pixels from the
             * node's offsetParent as returned from marginBox().
             * Return value will be in the form:
             * 
             * { l: 50, t: 200, w: 300: h: 150, x: 100, y: 300 }
             * Does not act as a setter. If includeScroll is passed, the x and
             * 
             * y params are affected as one would expect in dojo.position().
             * 
             * @param node             
             * @param includeScroll               Optional            
             */
            coords(node: HTMLElement, includeScroll: boolean): any;
            /**
             * Deprecated: Use position() for border-box x/y/w/h
             * or marginBox() for margin-box w/h/l/t.
             * 
             * Returns an object that measures margin-box (w)idth/(h)eight
             * and absolute position x/y of the border-box. Also returned
             * is computed (l)eft and (t)op values in pixels from the
             * node's offsetParent as returned from marginBox().
             * Return value will be in the form:
             * 
             * { l: 50, t: 200, w: 300: h: 150, x: 100, y: 300 }
             * Does not act as a setter. If includeScroll is passed, the x and
             * 
             * y params are affected as one would expect in dojo.position().
             * 
             * @param node             
             * @param includeScroll               Optional            
             */
            coords(node: String, includeScroll: boolean): any;
            /**
             * Create an element, allowing for optional attribute decoration
             * and placement.
             * A DOM Element creation function. A shorthand method for creating a node or
             * a fragment, and allowing for a convenient optional attribute setting step,
             * as well as an optional DOM placement reference.
             * 
             * Attributes are set by passing the optional object through dojo.setAttr.
             * See dojo.setAttr for noted caveats and nuances, and API if applicable.
             * 
             * Placement is done via dojo.place, assuming the new node to be the action
             * node, passing along the optional reference node and position.
             * 
             * @param tag A string of the element to create (eg: "div", "a", "p", "li", "script", "br"),or an existing DOM node to process.             
             * @param attrs An object-hash of attributes to set on the newly created node.Can be null, if you don't want to set any attributes/styles.See: dojo.setAttr for a description of available attributes.             
             * @param refNode               OptionalOptional reference node. Used by dojo.place to place the newly creatednode somewhere in the dom relative to refNode. Can be a DomNode referenceor String ID of a node.             
             * @param pos               OptionalOptional positional reference. Defaults to "last" by way of dojo.place,though can be set to "first","after","before","last", "replace" or "only"to further control the placement of the new node relative to the refNode.'refNode' is required if a 'pos' is specified.             
             */
            create(tag: HTMLElement, attrs: Object, refNode: HTMLElement, pos: String): any;
            /**
             * Create an element, allowing for optional attribute decoration
             * and placement.
             * A DOM Element creation function. A shorthand method for creating a node or
             * a fragment, and allowing for a convenient optional attribute setting step,
             * as well as an optional DOM placement reference.
             * 
             * Attributes are set by passing the optional object through dojo.setAttr.
             * See dojo.setAttr for noted caveats and nuances, and API if applicable.
             * 
             * Placement is done via dojo.place, assuming the new node to be the action
             * node, passing along the optional reference node and position.
             * 
             * @param tag A string of the element to create (eg: "div", "a", "p", "li", "script", "br"),or an existing DOM node to process.             
             * @param attrs An object-hash of attributes to set on the newly created node.Can be null, if you don't want to set any attributes/styles.See: dojo.setAttr for a description of available attributes.             
             * @param refNode               OptionalOptional reference node. Used by dojo.place to place the newly creatednode somewhere in the dom relative to refNode. Can be a DomNode referenceor String ID of a node.             
             * @param pos               OptionalOptional positional reference. Defaults to "last" by way of dojo.place,though can be set to "first","after","before","last", "replace" or "only"to further control the placement of the new node relative to the refNode.'refNode' is required if a 'pos' is specified.             
             */
            create(tag: String, attrs: Object, refNode: HTMLElement, pos: String): any;
            /**
             * Create an element, allowing for optional attribute decoration
             * and placement.
             * A DOM Element creation function. A shorthand method for creating a node or
             * a fragment, and allowing for a convenient optional attribute setting step,
             * as well as an optional DOM placement reference.
             * 
             * Attributes are set by passing the optional object through dojo.setAttr.
             * See dojo.setAttr for noted caveats and nuances, and API if applicable.
             * 
             * Placement is done via dojo.place, assuming the new node to be the action
             * node, passing along the optional reference node and position.
             * 
             * @param tag A string of the element to create (eg: "div", "a", "p", "li", "script", "br"),or an existing DOM node to process.             
             * @param attrs An object-hash of attributes to set on the newly created node.Can be null, if you don't want to set any attributes/styles.See: dojo.setAttr for a description of available attributes.             
             * @param refNode               OptionalOptional reference node. Used by dojo.place to place the newly creatednode somewhere in the dom relative to refNode. Can be a DomNode referenceor String ID of a node.             
             * @param pos               OptionalOptional positional reference. Defaults to "last" by way of dojo.place,though can be set to "first","after","before","last", "replace" or "only"to further control the placement of the new node relative to the refNode.'refNode' is required if a 'pos' is specified.             
             */
            create(tag: HTMLElement, attrs: Object, refNode: String, pos: String): any;
            /**
             * Create an element, allowing for optional attribute decoration
             * and placement.
             * A DOM Element creation function. A shorthand method for creating a node or
             * a fragment, and allowing for a convenient optional attribute setting step,
             * as well as an optional DOM placement reference.
             * 
             * Attributes are set by passing the optional object through dojo.setAttr.
             * See dojo.setAttr for noted caveats and nuances, and API if applicable.
             * 
             * Placement is done via dojo.place, assuming the new node to be the action
             * node, passing along the optional reference node and position.
             * 
             * @param tag A string of the element to create (eg: "div", "a", "p", "li", "script", "br"),or an existing DOM node to process.             
             * @param attrs An object-hash of attributes to set on the newly created node.Can be null, if you don't want to set any attributes/styles.See: dojo.setAttr for a description of available attributes.             
             * @param refNode               OptionalOptional reference node. Used by dojo.place to place the newly creatednode somewhere in the dom relative to refNode. Can be a DomNode referenceor String ID of a node.             
             * @param pos               OptionalOptional positional reference. Defaults to "last" by way of dojo.place,though can be set to "first","after","before","last", "replace" or "only"to further control the placement of the new node relative to the refNode.'refNode' is required if a 'pos' is specified.             
             */
            create(tag: String, attrs: Object, refNode: String, pos: String): any;
            /**
             * Create a feature-rich constructor from compact notation.
             * Create a constructor using a compact notation for inheritance and
             * prototype extension.
             * 
             * Mixin ancestors provide a type of multiple inheritance.
             * Prototypes of mixin ancestors are copied to the new class:
             * changes to mixin prototypes will not affect classes to which
             * they have been mixed in.
             * 
             * Ancestors can be compound classes created by this version of
             * declare(). In complex cases all base classes are going to be
             * linearized according to C3 MRO algorithm
             * (see http://www.python.org/download/releases/2.3/mro/ for more
             * details).
             * 
             * "className" is cached in "declaredClass" property of the new class,
             * if it was supplied. The immediate super class will be cached in
             * "superclass" property of the new class.
             * 
             * Methods in "props" will be copied and modified: "nom" property
             * (the declared name of the method) will be added to all copied
             * functions to help identify them for the internal machinery. Be
             * very careful, while reusing methods: if you use the same
             * function under different names, it can produce errors in some
             * cases.
             * 
             * It is possible to use constructors created "manually" (without
             * declare()) as bases. They will be called as usual during the
             * creation of an instance, their methods will be chained, and even
             * called by "this.inherited()".
             * 
             * Special property "-chains-" governs how to chain methods. It is
             * a dictionary, which uses method names as keys, and hint strings
             * as values. If a hint string is "after", this method will be
             * called after methods of its base classes. If a hint string is
             * "before", this method will be called before methods of its base
             * classes.
             * 
             * If "constructor" is not mentioned in "-chains-" property, it will
             * be chained using the legacy mode: using "after" chaining,
             * calling preamble() method before each constructor, if available,
             * and calling postscript() after all constructors were executed.
             * If the hint is "after", it is chained as a regular method, but
             * postscript() will be called after the chain of constructors.
             * "constructor" cannot be chained "before", but it allows
             * a special hint string: "manual", which means that constructors
             * are not going to be chained in any way, and programmer will call
             * them manually using this.inherited(). In the latter case
             * postscript() will be called after the construction.
             * 
             * All chaining hints are "inherited" from base classes and
             * potentially can be overridden. Be very careful when overriding
             * hints! Make sure that all chained methods can work in a proposed
             * manner of chaining.
             * 
             * Once a method was chained, it is impossible to unchain it. The
             * only exception is "constructor". You don't need to define a
             * method in order to supply a chaining hint.
             * 
             * If a method is chained, it cannot use this.inherited() because
             * all other methods in the hierarchy will be called automatically.
             * 
             * Usually constructors and initializers of any kind are chained
             * using "after" and destructors of any kind are chained as
             * "before". Note that chaining assumes that chained methods do not
             * return any value: any returned value will be discarded.
             * 
             * @param className               OptionalThe optional name of the constructor (loosely, a "class")stored in the "declaredClass" property in the created prototype.It will be used as a global name for a created constructor.             
             * @param superclass May be null, a Function, or an Array of Functions. This argumentspecifies a list of bases (the left-most one is the most deepestbase).             
             * @param props An object whose properties are copied to the created prototype.Add an instance-initialization function by making it a propertynamed "constructor".             
             */
            declare(className: String, superclass: Function, props: Object): dojo._base.declare.__DeclareCreatedObject;
            /**
             * Create a feature-rich constructor from compact notation.
             * Create a constructor using a compact notation for inheritance and
             * prototype extension.
             * 
             * Mixin ancestors provide a type of multiple inheritance.
             * Prototypes of mixin ancestors are copied to the new class:
             * changes to mixin prototypes will not affect classes to which
             * they have been mixed in.
             * 
             * Ancestors can be compound classes created by this version of
             * declare(). In complex cases all base classes are going to be
             * linearized according to C3 MRO algorithm
             * (see http://www.python.org/download/releases/2.3/mro/ for more
             * details).
             * 
             * "className" is cached in "declaredClass" property of the new class,
             * if it was supplied. The immediate super class will be cached in
             * "superclass" property of the new class.
             * 
             * Methods in "props" will be copied and modified: "nom" property
             * (the declared name of the method) will be added to all copied
             * functions to help identify them for the internal machinery. Be
             * very careful, while reusing methods: if you use the same
             * function under different names, it can produce errors in some
             * cases.
             * 
             * It is possible to use constructors created "manually" (without
             * declare()) as bases. They will be called as usual during the
             * creation of an instance, their methods will be chained, and even
             * called by "this.inherited()".
             * 
             * Special property "-chains-" governs how to chain methods. It is
             * a dictionary, which uses method names as keys, and hint strings
             * as values. If a hint string is "after", this method will be
             * called after methods of its base classes. If a hint string is
             * "before", this method will be called before methods of its base
             * classes.
             * 
             * If "constructor" is not mentioned in "-chains-" property, it will
             * be chained using the legacy mode: using "after" chaining,
             * calling preamble() method before each constructor, if available,
             * and calling postscript() after all constructors were executed.
             * If the hint is "after", it is chained as a regular method, but
             * postscript() will be called after the chain of constructors.
             * "constructor" cannot be chained "before", but it allows
             * a special hint string: "manual", which means that constructors
             * are not going to be chained in any way, and programmer will call
             * them manually using this.inherited(). In the latter case
             * postscript() will be called after the construction.
             * 
             * All chaining hints are "inherited" from base classes and
             * potentially can be overridden. Be very careful when overriding
             * hints! Make sure that all chained methods can work in a proposed
             * manner of chaining.
             * 
             * Once a method was chained, it is impossible to unchain it. The
             * only exception is "constructor". You don't need to define a
             * method in order to supply a chaining hint.
             * 
             * If a method is chained, it cannot use this.inherited() because
             * all other methods in the hierarchy will be called automatically.
             * 
             * Usually constructors and initializers of any kind are chained
             * using "after" and destructors of any kind are chained as
             * "before". Note that chaining assumes that chained methods do not
             * return any value: any returned value will be discarded.
             * 
             * @param className               OptionalThe optional name of the constructor (loosely, a "class")stored in the "declaredClass" property in the created prototype.It will be used as a global name for a created constructor.             
             * @param superclass May be null, a Function, or an Array of Functions. This argumentspecifies a list of bases (the left-most one is the most deepestbase).             
             * @param props An object whose properties are copied to the created prototype.Add an instance-initialization function by making it a propertynamed "constructor".             
             */
            declare(className: String, superclass: Function[], props: Object): dojo._base.declare.__DeclareCreatedObject;
            /**
             * Deprecated.   This module defines the legacy dojo/_base/Deferred API.
             * New code should use dojo/Deferred instead.
             * The Deferred API is based on the concept of promises that provide a
             * generic interface into the eventual completion of an asynchronous action.
             * The motivation for promises fundamentally is about creating a
             * separation of concerns that allows one to achieve the same type of
             * call patterns and logical data flow in asynchronous code as can be
             * achieved in synchronous code. Promises allows one
             * to be able to call a function purely with arguments needed for
             * execution, without conflating the call with concerns of whether it is
             * sync or async. One shouldn't need to alter a call's arguments if the
             * implementation switches from sync to async (or vice versa). By having
             * async functions return promises, the concerns of making the call are
             * separated from the concerns of asynchronous interaction (which are
             * handled by the promise).
             * 
             * The Deferred is a type of promise that provides methods for fulfilling the
             * promise with a successful result or an error. The most important method for
             * working with Dojo's promises is the then() method, which follows the
             * CommonJS proposed promise API. An example of using a Dojo promise:
             * 
             * var resultingPromise = someAsyncOperation.then(function(result){
             *     ... handle result ...
             * },
             * function(error){
             *     ... handle error ...
             * });
             * The .then() call returns a new promise that represents the result of the
             * execution of the callback. The callbacks will never affect the original promises value.
             * 
             * The Deferred instances also provide the following functions for backwards compatibility:
             * 
             * addCallback(handler)
             * addErrback(handler)
             * callback(result)
             * errback(result)
             * Callbacks are allowed to return promises themselves, so
             * you can build complicated sequences of events with ease.
             * 
             * The creator of the Deferred may specify a canceller.  The canceller
             * is a function that will be called if Deferred.cancel is called
             * before the Deferred fires. You can use this to implement clean
             * aborting of an XMLHttpRequest, etc. Note that cancel will fire the
             * deferred with a CancelledError (unless your canceller returns
             * another kind of error), so the errbacks should be prepared to
             * handle that error for cancellable Deferreds.
             * 
             * @param canceller               Optional            
             */
            Deferred(canceller: Function): void;
            /**
             * Deprecated, use dojo/promise/all instead.
             * Provides event handling for a group of Deferred objects.
             * DeferredList takes an array of existing deferreds and returns a new deferred of its own
             * this new deferred will typically have its callback fired when all of the deferreds in
             * the given list have fired their own deferreds.  The parameters fireOnOneCallback and
             * fireOnOneErrback, will fire before all the deferreds as appropriate
             * 
             * @param list The list of deferreds to be synchronizied with this DeferredList             
             * @param fireOnOneCallback               OptionalWill cause the DeferredLists callback to be fired as soon as anyof the deferreds in its list have been fired instead of waiting untilthe entire list has finished             
             * @param fireOnOneErrback               Optional            
             * @param consumeErrors               Optional            
             * @param canceller               OptionalA deferred canceller function, see dojo.Deferred             
             */
            DeferredList(list: any[], fireOnOneCallback: boolean, fireOnOneErrback: boolean, consumeErrors: boolean, canceller: Function): void;
            /**
             * Log a debug message to indicate that a behavior has been
             * deprecated.
             * 
             * @param behaviour The API or behavior being deprecated. Usually in the formof "myApp.someFunction()".             
             * @param extra               OptionalText to append to the message. Often provides advice on anew function or facility to achieve the same goal duringthe deprecation period.             
             * @param removal               OptionalText to indicate when in the future the behavior will beremoved. Usually a version number.             
             */
            deprecated(behaviour: String, extra: String, removal: String): void;
            /**
             * 
             * @param node             
             */
            destroy(node: any): void;
            /**
             * Remove a link created by dojo.connect.
             * Removes the connection between event and the method referenced by handle.
             * 
             * @param handle the return value of the dojo.connect call that created the connection.             
             */
            disconnect(handle: Object): void;
            /**
             * Returns an object with {node, x, y} with corresponding offsets.
             * 
             * @param doc               OptionalOptional document to query.   If unspecified, use win.doc.             
             */
            docScroll(doc: HTMLDocument): Object;
            /**
             * 
             * @param node             
             */
            empty(node: any): void;
            /**
             * A legacy method created for use exclusively by internal Dojo methods. Do not use this method
             * directly unless you understand its possibly-different implications on the platforms your are targeting.
             * Makes an attempt to evaluate scriptText in the global scope. The function works correctly for browsers
             * that support indirect eval.
             * 
             * As usual, IE does not. On IE, the only way to implement global eval is to
             * use execScript. Unfortunately, execScript does not return a value and breaks some current usages of dojo.eval.
             * This implementation uses the technique of executing eval in the scope of a function that is a single scope
             * frame below the global scope; thereby coming close to the global scope. Note carefully that
             * 
             * dojo.eval("var pi = 3.14;");
             * 
             * will define global pi in non-IE environments, but define pi only in a temporary local scope for IE. If you want
             * to define a global variable using dojo.eval, write something like
             * 
             * dojo.eval("window.pi = 3.14;")
             * 
             * @param scriptText The text to evaluation.             
             */
            eval(scriptText: any): any;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: any[], callback: Function, thisObject: Object): boolean;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: String, callback: Function, thisObject: Object): boolean;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: any[], callback: String, thisObject: Object): boolean;
            /**
             * Determines whether or not every item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.every() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's every skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/every
             * 
             * @param arr the array to iterate on. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            every(arr: String, callback: String, thisObject: Object): boolean;
            /**
             * 
             * @param exitcode             
             */
            exit(exitcode: any): void;
            /**
             * Marks code as experimental.
             * This can be used to mark a function, file, or module as
             * experimental.    Experimental code is not ready to be used, and the
             * APIs are subject to change without notice.  Experimental code may be
             * completed deleted without going through the normal deprecation
             * process.
             * 
             * @param moduleName The name of a module, or the name of a module file or a specificfunction             
             * @param extra               Optionalsome additional message for the user             
             */
            experimental(moduleName: String, extra: String): void;
            /**
             * Returns an animation that will fade node defined in 'args' from
             * its current opacity to fully opaque.
             * 
             * @param args An object with the following properties:node (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            fadeIn(args: Object): any;
            /**
             * Returns an animation that will fade node defined in 'args'
             * from its current opacity to fully transparent.
             * 
             * @param args An object with the following properties:node (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            fadeOut(args: Object): any;
            /**
             * Serialize a form field to a JavaScript object.
             * Returns the value encoded in a form field as
             * as a string or an array of strings. Disabled form elements
             * and unchecked radio and checkboxes are skipped. Multi-select
             * elements are returned as an array of string values.
             * 
             * @param inputNode             
             */
            fieldToObject(inputNode: HTMLElement): Object;
            /**
             * Serialize a form field to a JavaScript object.
             * Returns the value encoded in a form field as
             * as a string or an array of strings. Disabled form elements
             * and unchecked radio and checkboxes are skipped. Multi-select
             * elements are returned as an array of string values.
             * 
             * @param inputNode             
             */
            fieldToObject(inputNode: String): Object;
            /**
             * Returns a new Array with those items from arr that match the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.filter() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's filter skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/filter
             * 
             * @param arr the array to iterate over.             
             * @param callback a function that is invoked with three arguments (item,index, array). The return of this function is expected tobe a boolean which determines whether the passed-in itemwill be included in the returned array.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            filter(arr: any[], callback: Function, thisObject: Object): any[];
            /**
             * Returns a new Array with those items from arr that match the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.filter() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's filter skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/filter
             * 
             * @param arr the array to iterate over.             
             * @param callback a function that is invoked with three arguments (item,index, array). The return of this function is expected tobe a boolean which determines whether the passed-in itemwill be included in the returned array.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            filter(arr: any[], callback: String, thisObject: Object): any[];
            /**
             * normalizes properties on the event object including event
             * bubbling methods, keystroke normalization, and x/y positions
             * 
             * @param evt native event object             
             * @param sender node to treat as "currentTarget"             
             */
            fixEvent(evt: Event, sender: HTMLElement): Event;
            /**
             * In RTL direction, scrollLeft should be a negative value, but IE
             * returns a positive one. All codes using documentElement.scrollLeft
             * must call this function to fix this error, otherwise the position
             * will offset to right when there is a horizontal scrollbar.
             * 
             * @param scrollLeft             
             * @param doc               OptionalOptional document to query.   If unspecified, use win.doc.             
             */
            fixIeBiDiScrollLeft(scrollLeft: number, doc: HTMLDocument): number;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: any[], callback: Function, thisObject: Object): void;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: String, callback: Function, thisObject: Object): void;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: any[], callback: String, thisObject: Object): void;
            /**
             * for every item in arr, callback is invoked. Return values are ignored.
             * If you want to break out of the loop, consider using array.every() or array.some().
             * forEach does not allow breaking out of the loop over the items in arr.
             * This function corresponds to the JavaScript 1.6 Array.forEach() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's forEach skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach
             * 
             * @param arr             
             * @param callback             
             * @param thisObject               Optional            
             */
            forEach(arr: String, callback: String, thisObject: Object): void;
            /**
             * Create a serialized JSON string from a form node or string
             * ID identifying the form to serialize
             * 
             * @param formNode             
             * @param prettyPrint               Optional            
             */
            formToJson(formNode: HTMLElement, prettyPrint: boolean): String;
            /**
             * Create a serialized JSON string from a form node or string
             * ID identifying the form to serialize
             * 
             * @param formNode             
             * @param prettyPrint               Optional            
             */
            formToJson(formNode: String, prettyPrint: boolean): String;
            /**
             * Serialize a form node to a JavaScript object.
             * Returns the values encoded in an HTML form as
             * string properties in an object which it then returns. Disabled form
             * elements, buttons, and other non-value form elements are skipped.
             * Multi-select elements are returned as an array of string values.
             * 
             * @param formNode             
             */
            formToObject(formNode: HTMLElement): Object;
            /**
             * Serialize a form node to a JavaScript object.
             * Returns the values encoded in an HTML form as
             * string properties in an object which it then returns. Disabled form
             * elements, buttons, and other non-value form elements are skipped.
             * Multi-select elements are returned as an array of string values.
             * 
             * @param formNode             
             */
            formToObject(formNode: String): Object;
            /**
             * Returns a URL-encoded string representing the form passed as either a
             * node or string ID identifying the form to serialize
             * 
             * @param formNode             
             */
            formToQuery(formNode: HTMLElement): String;
            /**
             * Returns a URL-encoded string representing the form passed as either a
             * node or string ID identifying the form to serialize
             * 
             * @param formNode             
             */
            formToQuery(formNode: String): String;
            /**
             * Parses a JavaScript expression and returns a JavaScript value.
             * Throws for invalid JavaScript expressions. It does not use a strict JSON parser. It
             * always delegates to eval(). The content passed to this method must therefore come
             * from a trusted source.
             * It is recommend that you use dojo/json's parse function for an
             * implementation uses the (faster) native JSON parse when available.
             * 
             * @param js a string literal of a JavaScript expression, for instance:'{ "foo": [ "bar", 1, { "baz": "thud" } ] }'             
             */
            fromJson(js: String): any;
            /**
             * Gets an attribute on an HTML element.
             * Handles normalized getting of attributes on DOM Nodes.
             * 
             * @param node id or reference to the element to get the attribute on             
             * @param name the name of the attribute to get.             
             */
            getAttr(node: HTMLElement, name: String): any;
            /**
             * Gets an attribute on an HTML element.
             * Handles normalized getting of attributes on DOM Nodes.
             * 
             * @param node id or reference to the element to get the attribute on             
             * @param name the name of the attribute to get.             
             */
            getAttr(node: String, name: String): any;
            /**
             * returns an object with properties useful for noting the border
             * dimensions.
             * l/t/r/b = the sum of left/top/right/bottom border (respectively)
             * w = the sum of the left and right border
             * h = the sum of the top and bottom border
             * The w/h are used for calculating boxes.
             * Normally application code will not need to invoke this
             * directly, and will use the ...box... functions instead.
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getBorderExtents(node: HTMLElement, computedStyle: Object): Object;
            /**
             * Returns a "computed style" object.
             * Gets a "computed style" object which can be used to gather
             * information about the current state of the rendered node.
             * 
             * Note that this may behave differently on different browsers.
             * Values may have different formats and value encodings across
             * browsers.
             * 
             * Note also that this method is expensive.  Wherever possible,
             * reuse the returned object.
             * 
             * Use the dojo/dom-style.get() method for more consistent (pixelized)
             * return values.
             * 
             * @param node A reference to a DOM node. Does NOT support taking anID string for speed reasons.             
             */
            getComputedStyle(node: HTMLElement): void;
            /**
             * Returns an object that encodes the width, height, left and top
             * positions of the node's content box, irrespective of the
             * current box model.
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getContentBox(node: HTMLElement, computedStyle: Object): Object;
            /**
             * returns the offset in x and y from the document body to the
             * visual edge of the page for IE
             * The following values in IE contain an offset:
             * 
             * event.clientX
             * event.clientY
             * node.getBoundingClientRect().left
             * node.getBoundingClientRect().top
             * But other position related values do not contain this offset,
             * 
             * such as node.offsetLeft, node.offsetTop, node.style.left and
             * node.style.top. The offset is always (2, 2) in LTR direction.
             * When the body is in RTL direction, the offset counts the width
             * of left scroll bar's width.  This function computes the actual
             * offset.
             * 
             * @param doc               OptionalOptional document to query.   If unspecified, use win.doc.             
             */
            getIeDocumentElementOffset(doc: HTMLDocument): Object;
            /**
             * 
             * @param moduleName             
             * @param bundleName             
             * @param locale             
             */
            getL10nName(moduleName: any, bundleName: any, locale: any): String;
            /**
             * returns an object that encodes the width, height, left and top
             * positions of the node's margin box.
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getMarginBox(node: HTMLElement, computedStyle: Object): Object;
            /**
             * returns object with properties useful for box fitting with
             * regards to box margins (i.e., the outer-box).
             * 
             * l/t = marginLeft, marginTop, respectively
             * w = total width, margin inclusive
             * h = total height, margin inclusive
             * The w/h are used for calculating boxes.
             * Normally application code will not need to invoke this
             * directly, and will use the ...box... functions instead.
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getMarginExtents(node: HTMLElement, computedStyle: Object): Object;
            /**
             * returns an object that encodes the width and height of
             * the node's margin box
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getMarginSize(node: HTMLElement, computedStyle: Object): Object;
            /**
             * returns an object that encodes the width and height of
             * the node's margin box
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getMarginSize(node: String, computedStyle: Object): Object;
            /**
             * Returns an effective value of a property or an attribute.
             * 
             * @param node id or reference to the element to remove the attribute from             
             * @param name the name of the attribute             
             */
            getNodeProp(node: HTMLElement, name: String): any;
            /**
             * Returns an effective value of a property or an attribute.
             * 
             * @param node id or reference to the element to remove the attribute from             
             * @param name the name of the attribute             
             */
            getNodeProp(node: String, name: String): any;
            /**
             * Returns object with properties useful for box fitting with
             * regards to padding.
             * l/t/r/b = the sum of left/top/right/bottom padding and left/top/right/bottom border (respectively)
             * w = the sum of the left and right padding and border
             * h = the sum of the top and bottom padding and border
             * The w/h are used for calculating boxes.
             * Normally application code will not need to invoke this
             * directly, and will use the ...box... functions instead.
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getPadBorderExtents(node: HTMLElement, computedStyle: Object): Object;
            /**
             * Returns object with special values specifically useful for node
             * fitting.
             * Returns an object with w, h, l, t properties:
             * 
             * l/t/r/b = left/top/right/bottom padding (respectively)
             * w = the total of the left and right padding
             * h = the total of the top and bottom padding
             * If 'node' has position, l/t forms the origin for child nodes.
             * 
             * The w/h are used for calculating boxes.
             * Normally application code will not need to invoke this
             * directly, and will use the ...box... functions instead.
             * 
             * @param node             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            getPadExtents(node: HTMLElement, computedStyle: Object): Object;
            /**
             * Gets a property on an HTML element.
             * Handles normalized getting of properties on DOM nodes.
             * 
             * @param node id or reference to the element to get the property on             
             * @param name the name of the property to get.             
             */
            getProp(node: HTMLElement, name: String): any;
            /**
             * Gets a property on an HTML element.
             * Handles normalized getting of properties on DOM nodes.
             * 
             * @param node id or reference to the element to get the property on             
             * @param name the name of the property to get.             
             */
            getProp(node: String, name: String): any;
            /**
             * Accesses styles on a node.
             * Getting the style value uses the computed style for the node, so the value
             * will be a calculated value, not just the immediate node.style value.
             * Also when getting values, use specific style names,
             * like "borderBottomWidth" instead of "border" since compound values like
             * "border" are not necessarily reflected as expected.
             * If you want to get node dimensions, use dojo/dom-geometry.getMarginBox(),
             * dojo/dom-geometry.getContentBox() or dojo/dom-geometry.getPosition().
             * 
             * @param node id or reference to node to get style for             
             * @param name               Optionalthe style property to get             
             */
            getStyle(node: HTMLElement, name: String): any;
            /**
             * Accesses styles on a node.
             * Getting the style value uses the computed style for the node, so the value
             * will be a calculated value, not just the immediate node.style value.
             * Also when getting values, use specific style names,
             * like "borderBottomWidth" instead of "border" since compound values like
             * "border" are not necessarily reflected as expected.
             * If you want to get node dimensions, use dojo/dom-geometry.getMarginBox(),
             * dojo/dom-geometry.getContentBox() or dojo/dom-geometry.getPosition().
             * 
             * @param node id or reference to node to get style for             
             * @param name               Optionalthe style property to get             
             */
            getStyle(node: String, name: String): any;
            /**
             * Returns true if the requested attribute is specified on the
             * given element, and false otherwise.
             * 
             * @param node id or reference to the element to check             
             * @param name the name of the attribute             
             */
            hasAttr(node: HTMLElement, name: String): boolean;
            /**
             * Returns true if the requested attribute is specified on the
             * given element, and false otherwise.
             * 
             * @param node id or reference to the element to check             
             * @param name the name of the attribute             
             */
            hasAttr(node: String, name: String): boolean;
            /**
             * Returns whether or not the specified classes are a portion of the
             * class list currently applied to the node.
             * 
             * @param node String ID or DomNode reference to check the class for.             
             * @param classStr A string class name to look for.             
             */
            hasClass(node: String, classStr: String): boolean;
            /**
             * Returns whether or not the specified classes are a portion of the
             * class list currently applied to the node.
             * 
             * @param node String ID or DomNode reference to check the class for.             
             * @param classStr A string class name to look for.             
             */
            hasClass(node: HTMLElement, classStr: String): boolean;
            /**
             * Gets or sets the hash string in the browser URL.
             * Handles getting and setting of location.hash.
             * 
             * If no arguments are passed, acts as a getter.
             * If a string is passed, acts as a setter.
             * 
             * @param hash               Optionalthe hash is set - #string.             
             * @param replace               OptionalIf true, updates the hash value in the current historystate instead of creating a new history state.             
             */
            hash(hash: String, replace: boolean): any;
            /**
             * locates the first index of the provided value in the
             * passed array. If the value is not found, -1 is returned.
             * This method corresponds to the JavaScript 1.6 Array.indexOf method, with two differences:
             * 
             * when run over sparse arrays, the Dojo function invokes the callback for every index
             * whereas JavaScript 1.6's indexOf skips the holes in the sparse array.
             * uses equality (==) rather than strict equality (===)
             * For details on this method, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/indexOf
             * 
             * @param arr             
             * @param value             
             * @param fromIndex               Optional            
             * @param findLast               OptionalMakes indexOf() work like lastIndexOf().  Used internally; not meant for external usage.             
             */
            indexOf(arr: any[], value: Object, fromIndex: number, findLast: boolean): number;
            /**
             * Returns true if the current language is left-to-right, and false otherwise.
             * 
             * @param doc               OptionalOptional document to query.   If unspecified, use win.doc.             
             */
            isBodyLtr(doc: HTMLDocument): boolean;
            /**
             * Returns true if node is a descendant of ancestor
             * 
             * @param node string id or node reference to test             
             * @param ancestor string id or node reference of potential parent to test against             
             */
            isDescendant(node: HTMLElement, ancestor: HTMLElement): boolean;
            /**
             * Returns true if node is a descendant of ancestor
             * 
             * @param node string id or node reference to test             
             * @param ancestor string id or node reference of potential parent to test against             
             */
            isDescendant(node: String, ancestor: HTMLElement): boolean;
            /**
             * Returns true if node is a descendant of ancestor
             * 
             * @param node string id or node reference to test             
             * @param ancestor string id or node reference of potential parent to test against             
             */
            isDescendant(node: HTMLElement, ancestor: String): boolean;
            /**
             * Returns true if node is a descendant of ancestor
             * 
             * @param node string id or node reference to test             
             * @param ancestor string id or node reference of potential parent to test against             
             */
            isDescendant(node: String, ancestor: String): boolean;
            /**
             * locates the last index of the provided value in the passed
             * array. If the value is not found, -1 is returned.
             * This method corresponds to the JavaScript 1.6 Array.lastIndexOf method, with two differences:
             * 
             * when run over sparse arrays, the Dojo function invokes the callback for every index
             * whereas JavaScript 1.6's lasIndexOf skips the holes in the sparse array.
             * uses equality (==) rather than strict equality (===)
             * For details on this method, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/lastIndexOf
             * 
             * @param arr             
             * @param value             
             * @param fromIndex               Optional            
             */
            lastIndexOf(arr: any, value: any, fromIndex: number): number;
            /**
             * 
             * @param f             
             */
            loadInit(f: any): void;
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: any[], callback: Function, thisObject: Object, Ctr: any): any[];
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: String, callback: Function, thisObject: Object, Ctr: any): any[];
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: any[], callback: String, thisObject: Object, Ctr: any): any[];
            /**
             * applies callback to each element of arr and returns
             * an Array with the results
             * This function corresponds to the JavaScript 1.6 Array.map() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's map skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
             * 
             * @param arr the array to iterate on. If a string, operates onindividual characters.             
             * @param callback a function is invoked with three arguments, (item, index,array),  and returns a value             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             * @param Ctr             
             */
            map(arr: String, callback: String, thisObject: Object, Ctr: any): any[];
            /**
             * Getter/setter for the margin-box of node.
             * Getter/setter for the margin-box of node.
             * Returns an object in the expected format of box (regardless
             * if box is passed). The object might look like:
             * { l: 50, t: 200, w: 300: h: 150 }
             * for a node offset from its parent 50px to the left, 200px from
             * the top with a margin width of 300px and a margin-height of
             * 150px.
             * 
             * @param node id or reference to DOM Node to get/set box for             
             * @param box               OptionalIf passed, denotes that dojo.marginBox() shouldupdate/set the margin box for node. Box is an object in theabove format. All properties are optional if passed.             
             */
            marginBox(node: HTMLElement, box: Object): any;
            /**
             * Getter/setter for the margin-box of node.
             * Getter/setter for the margin-box of node.
             * Returns an object in the expected format of box (regardless
             * if box is passed). The object might look like:
             * { l: 50, t: 200, w: 300: h: 150 }
             * for a node offset from its parent 50px to the left, 200px from
             * the top with a margin width of 300px and a margin-height of
             * 150px.
             * 
             * @param node id or reference to DOM Node to get/set box for             
             * @param box               OptionalIf passed, denotes that dojo.marginBox() shouldupdate/set the margin box for node. Box is an object in theabove format. All properties are optional if passed.             
             */
            marginBox(node: String, box: Object): any;
            /**
             * Returns a URL relative to a module.
             * 
             * @param module dojo/dom-class             
             * @param url               Optional            
             */
            moduleUrl(module: String, url: String): String;
            /**
             * Array-like object which adds syntactic
             * sugar for chaining, common iteration operations, animation, and
             * node manipulation. NodeLists are most often returned as the
             * result of dojo/query() calls.
             * NodeList instances provide many utilities that reflect
             * core Dojo APIs for Array iteration and manipulation, DOM
             * manipulation, and event handling. Instead of needing to dig up
             * functions in the dojo package, NodeLists generally make the
             * full power of Dojo available for DOM manipulation tasks in a
             * simple, chainable way.
             * 
             * @param array             
             */
            NodeList(array: any): any[];
            /**
             * takes a name/value mapping object and returns a string representing
             * a URL-encoded version of that object.
             * 
             * @param map             
             */
            objectToQuery(map: Object): any;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: HTMLElement, refNode: HTMLElement, position: String): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: String, refNode: HTMLElement, position: String): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: HTMLElement, refNode: String, position: String): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: String, refNode: String, position: String): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: HTMLElement, refNode: HTMLElement, position: number): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: String, refNode: HTMLElement, position: number): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: HTMLElement, refNode: String, position: number): HTMLElement;
            /**
             * Attempt to insert node into the DOM, choosing from various positioning options.
             * Returns the first argument resolved to a DOM node.
             * 
             * @param node id or node reference, or HTML fragment starting with "<" to place relative to refNode             
             * @param refNode id or node reference to use as basis for placement             
             * @param position               Optionalstring noting the position of node relative to refNode or anumber indicating the location in the childNodes collection of refNode.Accepted string values are:beforeafterreplaceonlyfirstlast"first" and "last" indicate positions as children of refNode, "replace" replaces refNode,"only" replaces all children.  position defaults to "last" if not specified             
             */
            place(node: String, refNode: String, position: number): HTMLElement;
            /**
             * require one or more modules based on which host environment
             * Dojo is currently operating in
             * This method takes a "map" of arrays which one can use to
             * optionally load dojo modules. The map is indexed by the
             * possible dojo.name values, with two additional values:
             * "default" and "common". The items in the "default" array will
             * be loaded if none of the other items have been choosen based on
             * dojo.name, set by your host environment. The items in the
             * "common" array will always be loaded, regardless of which
             * list is chosen.
             * 
             * @param modMap             
             */
            platformRequire(modMap: Object): void;
            /**
             * If the context stack contains elements, ensure that
             * subsequent code executes in the previous context to the
             * current context. The current context set ([global,
             * document]) is returned.
             * 
             */
            popContext(): void;
            /**
             * Gets the position and size of the passed element relative to
             * the viewport (if includeScroll==false), or relative to the
             * document root (if includeScroll==true).
             * Returns an object of the form:
             * { x: 100, y: 300, w: 20, h: 15 }.
             * If includeScroll==true, the x and y values will include any
             * document offsets that may affect the position relative to the
             * viewport.
             * Uses the border-box model (inclusive of border and padding but
             * not margin).  Does not act as a setter.
             * 
             * @param node             
             * @param includeScroll               Optional            
             */
            position(node: HTMLElement, includeScroll: boolean): Object;
            /**
             * Gets the position and size of the passed element relative to
             * the viewport (if includeScroll==false), or relative to the
             * document root (if includeScroll==true).
             * Returns an object of the form:
             * { x: 100, y: 300, w: 20, h: 15 }.
             * If includeScroll==true, the x and y values will include any
             * document offsets that may affect the position relative to the
             * viewport.
             * Uses the border-box model (inclusive of border and padding but
             * not margin).  Does not act as a setter.
             * 
             * @param node             
             * @param includeScroll               Optional            
             */
            position(node: String, includeScroll: boolean): Object;
            /**
             * Gets or sets a property on an HTML element.
             * Handles normalized getting and setting of properties on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the property on             
             * @param name the name of the property to get or set.             
             * @param value               OptionalThe value to set for the property             
             */
            prop(node: HTMLElement, name: String, value: String): any;
            /**
             * Gets or sets a property on an HTML element.
             * Handles normalized getting and setting of properties on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the property on             
             * @param name the name of the property to get or set.             
             * @param value               OptionalThe value to set for the property             
             */
            prop(node: String, name: String, value: String): any;
            /**
             * Gets or sets a property on an HTML element.
             * Handles normalized getting and setting of properties on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the property on             
             * @param name the name of the property to get or set.             
             * @param value               OptionalThe value to set for the property             
             */
            prop(node: HTMLElement, name: Object, value: String): any;
            /**
             * Gets or sets a property on an HTML element.
             * Handles normalized getting and setting of properties on DOM
             * Nodes. If 2 arguments are passed, and a the second argument is a
             * string, acts as a getter.
             * 
             * If a third argument is passed, or if the second argument is a
             * map of attributes, acts as a setter.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to get or set the property on             
             * @param name the name of the property to get or set.             
             * @param value               OptionalThe value to set for the property             
             */
            prop(node: String, name: Object, value: String): any;
            /**
             * 
             * @param mid             
             */
            provide(mid: any): void;
            /**
             * causes subsequent calls to Dojo methods to assume the
             * passed object and, optionally, document as the default
             * scopes to use. A 2-element array of the previous global and
             * document are returned.
             * dojo.pushContext treats contexts as a stack. The
             * auto-detected contexts which are initially provided using
             * dojo.setContext() require authors to keep state in order to
             * "return" to a previous context, whereas the
             * dojo.pushContext and dojo.popContext methods provide a more
             * natural way to augment blocks of code to ensure that they
             * execute in a different window or frame without issue. If
             * called without any arguments, the default context (the
             * context when Dojo is first loaded) is instead pushed into
             * the stack. If only a single string is passed, a node in the
             * intitial context's document is looked up and its
             * contextWindow and contextDocument properties are used as
             * the context to push. This means that iframes can be given
             * an ID and code can be executed in the scope of the iframe's
             * document in subsequent calls easily.
             * 
             * @param g               OptionalThe global context. If a string, the id of the frame tosearch for a context and document.             
             * @param d               OptionalThe document element to execute subsequent code with.             
             */
            pushContext(g: Object, d: HTMLDocument): void;
            /**
             * causes subsequent calls to Dojo methods to assume the
             * passed object and, optionally, document as the default
             * scopes to use. A 2-element array of the previous global and
             * document are returned.
             * dojo.pushContext treats contexts as a stack. The
             * auto-detected contexts which are initially provided using
             * dojo.setContext() require authors to keep state in order to
             * "return" to a previous context, whereas the
             * dojo.pushContext and dojo.popContext methods provide a more
             * natural way to augment blocks of code to ensure that they
             * execute in a different window or frame without issue. If
             * called without any arguments, the default context (the
             * context when Dojo is first loaded) is instead pushed into
             * the stack. If only a single string is passed, a node in the
             * intitial context's document is looked up and its
             * contextWindow and contextDocument properties are used as
             * the context to push. This means that iframes can be given
             * an ID and code can be executed in the scope of the iframe's
             * document in subsequent calls easily.
             * 
             * @param g               OptionalThe global context. If a string, the id of the frame tosearch for a context and document.             
             * @param d               OptionalThe document element to execute subsequent code with.             
             */
            pushContext(g: String, d: HTMLDocument): void;
            /**
             * Create an object representing a de-serialized query section of a
             * URL. Query keys with multiple values are returned in an array.
             * 
             * @param str             
             */
            queryToObject(str: String): Object;
            /**
             * Sends an HTTP POST request to the server. In addition to the properties
             * listed for the dojo.__XhrArgs type, the following property is allowed:
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            rawXhrPost(args: Object): any;
            /**
             * Sends an HTTP PUT request to the server. In addition to the properties
             * listed for the dojo.__XhrArgs type, the following property is allowed:
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            rawXhrPut(args: Object): any;
            /**
             * Add a function to execute on DOM content loaded and all requested modules have arrived and been evaluated.
             * In most cases, the domReady plug-in should suffice and this method should not be needed.
             * 
             * When called in a non-browser environment, just checks that all requested modules have arrived and been
             * evaluated.
             * 
             * @param priority               OptionalThe order in which to exec this callback relative to other callbacks, defaults to 1000             
             * @param context The context in which to run execute callback, or a callback if not using context             
             * @param callback               OptionalThe function to execute.             
             */
            ready(priority: number, context: any, callback: Function): void;
            /**
             * Maps a module name to a path
             * An unregistered module is given the default path of ../[module],
             * relative to Dojo root. For example, module acme is mapped to
             * ../acme.  If you want to use a different module name, use
             * dojo.registerModulePath.
             * 
             * @param moduleName             
             * @param prefix             
             */
            registerModulePath(moduleName: String, prefix: String): void;
            /**
             * Removes an attribute from an HTML element.
             * 
             * @param node id or reference to the element to remove the attribute from             
             * @param name the name of the attribute to remove             
             */
            removeAttr(node: HTMLElement, name: String): void;
            /**
             * Removes an attribute from an HTML element.
             * 
             * @param node id or reference to the element to remove the attribute from             
             * @param name the name of the attribute to remove             
             */
            removeAttr(node: String, name: String): void;
            /**
             * Removes the specified classes from node. No contains()
             * check is required.
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param classStr               OptionalAn optional String class name to remove, or several space-separatedclass names, or an array of class names. If omitted, all class nameswill be deleted.             
             */
            removeClass(node: String, classStr: String): void;
            /**
             * Removes the specified classes from node. No contains()
             * check is required.
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param classStr               OptionalAn optional String class name to remove, or several space-separatedclass names, or an array of class names. If omitted, all class nameswill be deleted.             
             */
            removeClass(node: HTMLElement, classStr: String): void;
            /**
             * Removes the specified classes from node. No contains()
             * check is required.
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param classStr               OptionalAn optional String class name to remove, or several space-separatedclass names, or an array of class names. If omitted, all class nameswill be deleted.             
             */
            removeClass(node: String, classStr: any[]): void;
            /**
             * Removes the specified classes from node. No contains()
             * check is required.
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param classStr               OptionalAn optional String class name to remove, or several space-separatedclass names, or an array of class names. If omitted, all class nameswill be deleted.             
             */
            removeClass(node: HTMLElement, classStr: any[]): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: String, addClassStr: String, removeClassStr: String): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: HTMLElement, addClassStr: String, removeClassStr: String): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: String, addClassStr: any[], removeClassStr: String): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: HTMLElement, addClassStr: any[], removeClassStr: String): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: String, addClassStr: String, removeClassStr: any[]): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: HTMLElement, addClassStr: String, removeClassStr: any[]): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: String, addClassStr: any[], removeClassStr: any[]): void;
            /**
             * Replaces one or more classes on a node if not present.
             * Operates more quickly than calling dojo.removeClass and dojo.addClass
             * 
             * @param node String ID or DomNode reference to remove the class from.             
             * @param addClassStr A String class name to add, or several space-separated class names,or an array of class names.             
             * @param removeClassStr               OptionalA String class name to remove, or several space-separated class names,or an array of class names.             
             */
            replaceClass(node: HTMLElement, addClassStr: any[], removeClassStr: any[]): void;
            /**
             * loads a Javascript module from the appropriate URI
             * Modules are loaded via dojo.require by using one of two loaders: the normal loader
             * and the xdomain loader. The xdomain loader is used when dojo was built with a
             * custom build that specified loader=xdomain and the module lives on a modulePath
             * that is a whole URL, with protocol and a domain. The versions of Dojo that are on
             * the Google and AOL CDNs use the xdomain loader.
             * 
             * If the module is loaded via the xdomain loader, it is an asynchronous load, since
             * the module is added via a dynamically created script tag. This
             * means that dojo.require() can return before the module has loaded. However, this
             * should only happen in the case where you do dojo.require calls in the top-level
             * HTML page, or if you purposely avoid the loader checking for dojo.require
             * dependencies in your module by using a syntax like dojo["require"] to load the module.
             * 
             * Sometimes it is useful to not have the loader detect the dojo.require calls in the
             * module so that you can dynamically load the modules as a result of an action on the
             * page, instead of right at module load time.
             * 
             * Also, for script blocks in an HTML page, the loader does not pre-process them, so
             * it does not know to download the modules before the dojo.require calls occur.
             * 
             * So, in those two cases, when you want on-the-fly module loading or for script blocks
             * in the HTML page, special care must be taken if the dojo.required code is loaded
             * asynchronously. To make sure you can execute code that depends on the dojo.required
             * modules, be sure to add the code that depends on the modules in a dojo.addOnLoad()
             * callback. dojo.addOnLoad waits for all outstanding modules to finish loading before
             * executing.
             * 
             * This type of syntax works with both xdomain and normal loaders, so it is good
             * practice to always use this idiom for on-the-fly code loading and in HTML script
             * blocks. If at some point you change loaders and where the code is loaded from,
             * it will all still work.
             * 
             * More on how dojo.require
             * dojo.require("A.B") first checks to see if symbol A.B is
             * defined. If it is, it is simply returned (nothing to do).
             * 
             * If it is not defined, it will look for A/B.js in the script root
             * directory.
             * 
             * dojo.require throws an exception if it cannot find a file
             * to load, or if the symbol A.B is not defined after loading.
             * 
             * It returns the object A.B, but note the caveats above about on-the-fly loading and
             * HTML script blocks when the xdomain loader is loading a module.
             * 
             * dojo.require() does nothing about importing symbols into
             * the current namespace.  It is presumed that the caller will
             * take care of that.
             * 
             * @param moduleName module name to load, using periods for separators, e.g. "dojo.date.locale".  Module paths are de-referenced by dojo'sinternal mapping of locations to names and are disambiguated bylongest prefix. See dojo.registerModulePath() for details onregistering new modules.             
             * @param omitModuleCheck               Optionalif true, omitModuleCheck skips the step of ensuring that theloaded file actually defines the symbol it is referenced by.For example if it called as dojo.require("a.b.c") and thefile located at a/b/c.js does not define an object a.b.c,and exception will be throws whereas no exception is raisedwhen called as dojo.require("a.b.c", true)             
             */
            require(moduleName: String, omitModuleCheck: boolean): any;
            /**
             * If the condition is true then call dojo.require() for the specified
             * resource
             * 
             * @param condition             
             * @param moduleName             
             * @param omitModuleCheck               Optional            
             */
            requireAfterIf(condition: boolean, moduleName: String, omitModuleCheck: boolean): void;
            /**
             * If the condition is true then call dojo.require() for the specified
             * resource
             * 
             * @param condition             
             * @param moduleName             
             * @param omitModuleCheck               Optional            
             */
            requireIf(condition: boolean, moduleName: String, omitModuleCheck: boolean): void;
            /**
             * 
             * @param moduleName             
             * @param bundleName             
             * @param locale               Optional            
             */
            requireLocalization(moduleName: String, bundleName: String, locale: String): void;
            /**
             * Mix in properties skipping a constructor and decorating functions
             * like it is done by declare().
             * This function is used to mix in properties like lang.mixin does,
             * but it skips a constructor property and decorates functions like
             * declare() does.
             * 
             * It is meant to be used with classes and objects produced with
             * declare. Functions mixed in with dojo.safeMixin can use
             * this.inherited() like normal methods.
             * 
             * This function is used to implement extend() method of a constructor
             * produced with declare().
             * 
             * @param target Target object to accept new properties.             
             * @param source Source object for new properties.             
             */
            safeMixin(target: Object, source: Object): Object;
            /**
             * Sets an attribute on an HTML element.
             * Handles normalized setting of attributes on DOM Nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the attribute on             
             * @param name the name of the attribute to set, or a hash of key-value pairs to set.             
             * @param value               Optionalthe value to set for the attribute, if the name is a string.             
             */
            setAttr(node: HTMLElement, name: String, value: String): any;
            /**
             * Sets an attribute on an HTML element.
             * Handles normalized setting of attributes on DOM Nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the attribute on             
             * @param name the name of the attribute to set, or a hash of key-value pairs to set.             
             * @param value               Optionalthe value to set for the attribute, if the name is a string.             
             */
            setAttr(node: String, name: String, value: String): any;
            /**
             * Sets an attribute on an HTML element.
             * Handles normalized setting of attributes on DOM Nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the attribute on             
             * @param name the name of the attribute to set, or a hash of key-value pairs to set.             
             * @param value               Optionalthe value to set for the attribute, if the name is a string.             
             */
            setAttr(node: HTMLElement, name: Object, value: String): any;
            /**
             * Sets an attribute on an HTML element.
             * Handles normalized setting of attributes on DOM Nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the attribute on             
             * @param name the name of the attribute to set, or a hash of key-value pairs to set.             
             * @param value               Optionalthe value to set for the attribute, if the name is a string.             
             */
            setAttr(node: String, name: Object, value: String): any;
            /**
             * Sets the size of the node's contents, irrespective of margins,
             * padding, or borders.
             * 
             * @param node             
             * @param box hash with optional "w", and "h" properties for "width", and "height"respectively. All specified properties should have numeric values in whole pixels.             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            setContentSize(node: HTMLElement, box: Object, computedStyle: Object): void;
            /**
             * changes the behavior of many core Dojo functions that deal with
             * namespace and DOM lookup, changing them to work in a new global
             * context (e.g., an iframe). The varibles dojo.global and dojo.doc
             * are modified as a result of calling this function and the result of
             * dojo.body() likewise differs.
             * 
             * @param globalObject             
             * @param globalDocument             
             */
            setContext(globalObject: Object, globalDocument: HTMLDocument): void;
            /**
             * sets the size of the node's margin box and placement
             * (left/top), irrespective of box model. Think of it as a
             * passthrough to setBox that handles box-model vagaries for
             * you.
             * 
             * @param node             
             * @param box hash with optional "l", "t", "w", and "h" properties for "left", "right", "width", and "height"respectively. All specified properties should have numeric values in whole pixels.             
             * @param computedStyle               OptionalThis parameter accepts computed styles object.If this parameter is omitted, the functions will calldojo/dom-style.getComputedStyle to get one. It is a better way, callingdojo/dom-style.getComputedStyle once, and then pass the reference to thiscomputedStyle parameter. Wherever possible, reuse the returnedobject of dojo/dom-style.getComputedStyle().             
             */
            setMarginBox(node: HTMLElement, box: Object, computedStyle: Object): void;
            /**
             * Sets a property on an HTML element.
             * Handles normalized setting of properties on DOM nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the property on             
             * @param name the name of the property to set, or a hash object to setmultiple properties at once.             
             * @param value               OptionalThe value to set for the property             
             */
            setProp(node: HTMLElement, name: String, value: String): any;
            /**
             * Sets a property on an HTML element.
             * Handles normalized setting of properties on DOM nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the property on             
             * @param name the name of the property to set, or a hash object to setmultiple properties at once.             
             * @param value               OptionalThe value to set for the property             
             */
            setProp(node: String, name: String, value: String): any;
            /**
             * Sets a property on an HTML element.
             * Handles normalized setting of properties on DOM nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the property on             
             * @param name the name of the property to set, or a hash object to setmultiple properties at once.             
             * @param value               OptionalThe value to set for the property             
             */
            setProp(node: HTMLElement, name: Object, value: String): any;
            /**
             * Sets a property on an HTML element.
             * Handles normalized setting of properties on DOM nodes.
             * 
             * When passing functions as values, note that they will not be
             * directly assigned to slots on the node, but rather the default
             * behavior will be removed and the new behavior will be added
             * using dojo.connect(), meaning that event handler properties
             * will be normalized and that some caveats with regards to
             * non-standard behaviors for onsubmit apply. Namely that you
             * should cancel form submission using dojo.stopEvent() on the
             * passed event object instead of returning a boolean value from
             * the handler itself.
             * 
             * @param node id or reference to the element to set the property on             
             * @param name the name of the property to set, or a hash object to setmultiple properties at once.             
             * @param value               OptionalThe value to set for the property             
             */
            setProp(node: String, name: Object, value: String): any;
            /**
             * 
             * @param node             
             * @param selectable             
             */
            setSelectable(node: any, selectable: any): void;
            /**
             * Sets styles on a node.
             * 
             * @param node id or reference to node to set style for             
             * @param name the style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            setStyle(node: HTMLElement, name: String, value: String): String;
            /**
             * Sets styles on a node.
             * 
             * @param node id or reference to node to set style for             
             * @param name the style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            setStyle(node: String, name: String, value: String): String;
            /**
             * Sets styles on a node.
             * 
             * @param node id or reference to node to set style for             
             * @param name the style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            setStyle(node: HTMLElement, name: Object, value: String): String;
            /**
             * Sets styles on a node.
             * 
             * @param node id or reference to node to set style for             
             * @param name the style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            setStyle(node: String, name: Object, value: String): String;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: any[], callback: Function, thisObject: Object): boolean;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: String, callback: Function, thisObject: Object): boolean;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: any[], callback: String, thisObject: Object): boolean;
            /**
             * Determines whether or not any item in arr satisfies the
             * condition implemented by callback.
             * This function corresponds to the JavaScript 1.6 Array.some() method, with one difference: when
             * run over sparse arrays, this implementation passes the "holes" in the sparse array to
             * the callback function with a value of undefined. JavaScript 1.6's some skips the holes in the sparse array.
             * For more details, see:
             * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/some
             * 
             * @param arr the array to iterate over. If a string, operates on individual characters.             
             * @param callback a function is invoked with three arguments: item, index,and array and returns true if the condition is met.             
             * @param thisObject               Optionalmay be used to scope the call to callback             
             */
            some(arr: String, callback: String, thisObject: Object): boolean;
            /**
             * 
             */
            Stateful(): void;
            /**
             * prevents propagation and clobbers the default action of the
             * passed event
             * 
             * @param evt The event object. If omitted, window.event is used on IE.             
             */
            stopEvent(evt: Event): void;
            /**
             * Accesses styles on a node. If 2 arguments are
             * passed, acts as a getter. If 3 arguments are passed, acts
             * as a setter.
             * Getting the style value uses the computed style for the node, so the value
             * will be a calculated value, not just the immediate node.style value.
             * Also when getting values, use specific style names,
             * like "borderBottomWidth" instead of "border" since compound values like
             * "border" are not necessarily reflected as expected.
             * If you want to get node dimensions, use dojo.marginBox(),
             * dojo.contentBox() or dojo.position().
             * 
             * @param node id or reference to node to get/set style for             
             * @param name               Optionalthe style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            style(node: HTMLElement, name: String, value: String): any;
            /**
             * Accesses styles on a node. If 2 arguments are
             * passed, acts as a getter. If 3 arguments are passed, acts
             * as a setter.
             * Getting the style value uses the computed style for the node, so the value
             * will be a calculated value, not just the immediate node.style value.
             * Also when getting values, use specific style names,
             * like "borderBottomWidth" instead of "border" since compound values like
             * "border" are not necessarily reflected as expected.
             * If you want to get node dimensions, use dojo.marginBox(),
             * dojo.contentBox() or dojo.position().
             * 
             * @param node id or reference to node to get/set style for             
             * @param name               Optionalthe style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            style(node: String, name: String, value: String): any;
            /**
             * Accesses styles on a node. If 2 arguments are
             * passed, acts as a getter. If 3 arguments are passed, acts
             * as a setter.
             * Getting the style value uses the computed style for the node, so the value
             * will be a calculated value, not just the immediate node.style value.
             * Also when getting values, use specific style names,
             * like "borderBottomWidth" instead of "border" since compound values like
             * "border" are not necessarily reflected as expected.
             * If you want to get node dimensions, use dojo.marginBox(),
             * dojo.contentBox() or dojo.position().
             * 
             * @param node id or reference to node to get/set style for             
             * @param name               Optionalthe style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            style(node: HTMLElement, name: Object, value: String): any;
            /**
             * Accesses styles on a node. If 2 arguments are
             * passed, acts as a getter. If 3 arguments are passed, acts
             * as a setter.
             * Getting the style value uses the computed style for the node, so the value
             * will be a calculated value, not just the immediate node.style value.
             * Also when getting values, use specific style names,
             * like "borderBottomWidth" instead of "border" since compound values like
             * "border" are not necessarily reflected as expected.
             * If you want to get node dimensions, use dojo.marginBox(),
             * dojo.contentBox() or dojo.position().
             * 
             * @param node id or reference to node to get/set style for             
             * @param name               Optionalthe style property to set in DOM-accessor format("borderWidth", not "border-width") or an object with key/valuepairs suitable for setting each property.             
             * @param value               OptionalIf passed, sets value on the node for style, handlingcross-browser concerns.  When setting a pixel value,be sure to include "px" in the value. For instance, top: "200px".Otherwise, in some cases, some browsers will not apply the style.             
             */
            style(node: String, name: Object, value: String): any;
            /**
             * instantiates an HTML fragment returning the corresponding DOM.
             * 
             * @param frag the HTML fragment             
             * @param doc               Optionaloptional document to use when creating DOM nodes, defaults todojo/_base/window.doc if not specified.             
             */
            toDom(frag: String, doc: HTMLDocument): any;
            /**
             * Adds a class to node if not present, or removes if present.
             * Pass a boolean condition if you want to explicitly add or remove.
             * Returns the condition that was specified directly or indirectly.
             * 
             * @param node String ID or DomNode reference to toggle a class string             
             * @param classStr A String class name to toggle, or several space-separated class names,or an array of class names.             
             * @param condition               OptionalIf passed, true means to add the class, false means to remove.Otherwise dojo.hasClass(node, classStr) is used to detect the class presence.             
             */
            toggleClass(node: String, classStr: String, condition: boolean): boolean;
            /**
             * Adds a class to node if not present, or removes if present.
             * Pass a boolean condition if you want to explicitly add or remove.
             * Returns the condition that was specified directly or indirectly.
             * 
             * @param node String ID or DomNode reference to toggle a class string             
             * @param classStr A String class name to toggle, or several space-separated class names,or an array of class names.             
             * @param condition               OptionalIf passed, true means to add the class, false means to remove.Otherwise dojo.hasClass(node, classStr) is used to detect the class presence.             
             */
            toggleClass(node: HTMLElement, classStr: String, condition: boolean): boolean;
            /**
             * Adds a class to node if not present, or removes if present.
             * Pass a boolean condition if you want to explicitly add or remove.
             * Returns the condition that was specified directly or indirectly.
             * 
             * @param node String ID or DomNode reference to toggle a class string             
             * @param classStr A String class name to toggle, or several space-separated class names,or an array of class names.             
             * @param condition               OptionalIf passed, true means to add the class, false means to remove.Otherwise dojo.hasClass(node, classStr) is used to detect the class presence.             
             */
            toggleClass(node: String, classStr: any[], condition: boolean): boolean;
            /**
             * Adds a class to node if not present, or removes if present.
             * Pass a boolean condition if you want to explicitly add or remove.
             * Returns the condition that was specified directly or indirectly.
             * 
             * @param node String ID or DomNode reference to toggle a class string             
             * @param classStr A String class name to toggle, or several space-separated class names,or an array of class names.             
             * @param condition               OptionalIf passed, true means to add the class, false means to remove.Otherwise dojo.hasClass(node, classStr) is used to detect the class presence.             
             */
            toggleClass(node: HTMLElement, classStr: any[], condition: boolean): boolean;
            /**
             * Returns a JSON serialization of an object.
             * Returns a JSON serialization of an object.
             * Note that this doesn't check for infinite recursion, so don't do that!
             * It is recommend that you use dojo/json's stringify function for an lighter
             * and faster implementation that matches the native JSON API and uses the
             * native JSON serializer when available.
             * 
             * @param it an object to be serialized. Objects may define their ownserialization via a special "json" or "json" functionproperty. If a specialized serializer has been defined, it willbe used as a fallback.Note that in 1.6, toJson would serialize undefined, but this no longer supportedsince it is not supported by native JSON serializer.             
             * @param prettyPrint               Optionalif true, we indent objects and arrays to make the output prettier.The variable dojo.toJsonIndentStr is used as the indent string --to use something other than the default (tab), change that variablebefore calling dojo.toJson().Note that if native JSON support is available, it will be used for serialization,and native implementations vary on the exact spacing used in pretty printing.             
             */
            toJson(it: Object, prettyPrint: boolean): any;
            /**
             * converts style value to pixels on IE or return a numeric value.
             * 
             * @param node             
             * @param value             
             */
            toPixelValue(node: HTMLElement, value: String): number;
            /**
             * Remove a topic listener.
             * 
             * @param handle The handle returned from a call to subscribe.             
             */
            unsubscribe(handle: Object): void;
            /**
             * Transparently applies callbacks to values and/or promises.
             * Accepts promises but also transparently handles non-promises. If no
             * callbacks are provided returns a promise, regardless of the initial
             * value. Foreign promises are converted.
             * 
             * If callbacks are provided and the initial value is not a promise,
             * the callback is executed immediately with no error handling. Returns
             * a promise if the initial value is a promise, or the result of the
             * callback otherwise.
             * 
             * @param valueOrPromise Either a regular value or an object with a then() method thatfollows the Promises/A specification.             
             * @param callback               OptionalCallback to be invoked when the promise is resolved, or a non-promiseis received.             
             * @param errback               OptionalCallback to be invoked when the promise is rejected.             
             * @param progback               OptionalCallback to be invoked when the promise emits a progress update.             
             */
            when(valueOrPromise: any, callback: Function, errback: Function, progback: Function): dojo.promise.Promise<any>;
            /**
             * signal fired by impending window destruction. You may use
             * dojo.addOnWIndowUnload() or dojo.connect() to this method to perform
             * page/application cleanup methods. See dojo.addOnWindowUnload for more info.
             * 
             */
            windowUnloaded(): void;
            /**
             * Invoke callback with documentObject as dojo/_base/window::doc.
             * Invoke callback with documentObject as dojo/_base/window::doc. If provided,
             * callback will be executed in the context of object thisObject
             * When callback() returns or throws an error, the dojo/_base/window::doc will
             * be restored to its previous state.
             * 
             * @param documentObject             
             * @param callback             
             * @param thisObject               Optional            
             * @param cbArguments               Optional            
             */
            withDoc(documentObject: HTMLDocument, callback: Function, thisObject: Object, cbArguments: any[]): any;
            /**
             * Invoke callback with globalObject as dojo.global and
             * globalObject.document as dojo.doc.
             * Invoke callback with globalObject as dojo.global and
             * globalObject.document as dojo.doc. If provided, globalObject
             * will be executed in the context of object thisObject
             * When callback() returns or throws an error, the dojo.global
             * and dojo.doc will be restored to its previous state.
             * 
             * @param globalObject             
             * @param callback             
             * @param thisObject               Optional            
             * @param cbArguments               Optional            
             */
            withGlobal(globalObject: Object, callback: Function, thisObject: Object, cbArguments: any[]): any;
            /**
             * 
             * @param method             
             * @param args             
             */
            xhr(method: any, args: any): any;
            /**
             * Sends an HTTP DELETE request to the server.
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            xhrDelete(args: Object): any;
            /**
             * Sends an HTTP GET request to the server.
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            xhrGet(args: Object): any;
            /**
             * Sends an HTTP POST request to the server. In addition to the properties
             * listed for the dojo.__XhrArgs type, the following property is allowed:
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            xhrPost(args: Object): any;
            /**
             * Sends an HTTP PUT request to the server. In addition to the properties
             * listed for the dojo.__XhrArgs type, the following property is allowed:
             * 
             * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            xhrPut(args: Object): any;
        }
        module kernel {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.__IoCallbackArgs.html
             *
             * 
             */
            class __IoCallbackArgs {
                constructor();
                /**
                 * the original object argument to the IO call.
                 * 
                 */
                "args": Object;
                /**
                 * For dojo/io/script calls only, indicates
                 * whether the script tag that represents the
                 * request can be deleted after callbacks have
                 * been called. Used internally to know when
                 * cleanup can happen on JSONP-type requests.
                 * 
                 */
                "canDelete": boolean;
                /**
                 * The final indicator on how the response will be
                 * handled.
                 * 
                 */
                "handleAs": string;
                /**
                 * For dojo/io/script calls only, the internal
                 * script ID used for the request.
                 * 
                 */
                "id": string;
                /**
                 * For dojo/io/script calls only: holds the JSON
                 * response for JSONP-type requests. Used
                 * internally to hold on to the JSON responses.
                 * You should not need to access it directly --
                 * the same object should be passed to the success
                 * callbacks directly.
                 * 
                 */
                "json": Object;
                /**
                 * For non-GET requests, the
                 * name1=value1&name2=value2 parameters sent up in
                 * the request.
                 * 
                 */
                "query": string;
                /**
                 * The final URL used for the call. Many times it
                 * will be different than the original args.url
                 * value.
                 * 
                 */
                "url": string;
                /**
                 * For XMLHttpRequest calls only, the
                 * XMLHttpRequest object that was used for the
                 * request.
                 * 
                 */
                "xhr": Object;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.__IoPublish.html
             *
             * This is a list of IO topics that can be published
             * if djConfig.ioPublish is set to true. IO topics can be
             * published for any Input/Output, network operation. So,
             * dojo.xhr, dojo.io.script and dojo.io.iframe can all
             * trigger these topics to be published.
             * 
             */
            class __IoPublish {
                constructor();
                /**
                 * "/dojo/io/done" is sent whenever an IO request has completed,
                 * either by loading or by erroring. It passes the error and
                 * the dojo.Deferred for the request with the topic.
                 * 
                 */
                "done": string;
                /**
                 * "/dojo/io/error" is sent whenever an IO request has errored.
                 * It passes the error and the dojo.Deferred
                 * for the request with the topic.
                 * 
                 */
                "error": string;
                /**
                 * "/dojo/io/load" is sent whenever an IO request has loaded
                 * successfully. It passes the response and the dojo.Deferred
                 * for the request with the topic.
                 * 
                 */
                "load": string;
                /**
                 * "/dojo/io/send" is sent whenever a new IO request is started.
                 * It passes the dojo.Deferred for the request with the topic.
                 * 
                 */
                "send": string;
                /**
                 * "/dojo/io/start" is sent when there are no outstanding IO
                 * requests, and a new IO request is started. No arguments
                 * are passed with this topic.
                 * 
                 */
                "start": string;
                /**
                 * "/dojo/io/stop" is sent when all outstanding IO requests have
                 * finished. No arguments are passed with this topic.
                 * 
                 */
                "stop": string;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.__IoArgs.html
             *
             * 
             */
            class __IoArgs {
                constructor();
                /**
                 * Contains properties with string values. These
                 * properties will be serialized as name1=value2 and
                 * passed in the request.
                 * 
                 */
                "content": Object;
                /**
                 * DOM node for a form. Used to extract the form values
                 * and send to the server.
                 * 
                 */
                "form": HTMLElement;
                /**
                 * Acceptable values depend on the type of IO
                 * transport (see specific IO calls for more information).
                 * 
                 */
                "handleAs": string;
                /**
                 * Set this explicitly to false to prevent publishing of topics related to
                 * IO operations. Otherwise, if djConfig.ioPublish is set to true, topics
                 * will be published via dojo/topic.publish() for different phases of an IO operation.
                 * See dojo/main.__IoPublish for a list of topics that are published.
                 * 
                 */
                "ioPublish": boolean;
                /**
                 * Default is false. If true, then a
                 * "dojo.preventCache" parameter is sent in the request
                 * with a value that changes with each request
                 * (timestamp). Useful only with GET-type requests.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Sets the raw body for an HTTP request. If this is used, then the content
                 * property is ignored. This is mostly useful for HTTP methods that have
                 * a body to their requests, like PUT or POST. This property can be used instead
                 * of postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.
                 * 
                 */
                "rawBody": string;
                /**
                 * Milliseconds to wait for the response. If this time
                 * passes, the then error callbacks are called.
                 * 
                 */
                "timeout": number;
                /**
                 * URL to server endpoint.
                 * 
                 */
                "url": string;
                /**
                 * This function will
                 * be called when the request fails due to a network or server error, the url
                 * is invalid, etc. It will also be called if the load or handle callback throws an
                 * exception, unless djConfig.debugAtAllCosts is true.  This allows deployed applications
                 * to continue to run even when a logic error happens in the callback, while making
                 * it easier to troubleshoot while in debug mode.
                 * 
                 * @param response The response in the format as defined with handleAs.             
                 * @param ioArgs Provides additional information about the request.             
                 */
                error(response: Object, ioArgs: dojo.main.__IoCallbackArgs): void;
                /**
                 * This function will
                 * be called at the end of every request, whether or not an error occurs.
                 * 
                 * @param loadOrError Provides a string that tells you whether this functionwas called because of success (load) or failure (error).             
                 * @param response The response in the format as defined with handleAs.             
                 * @param ioArgs Provides additional information about the request.             
                 */
                handle(loadOrError: String, response: Object, ioArgs: dojo.main.__IoCallbackArgs): void;
                /**
                 * This function will be
                 * called on a successful HTTP response code.
                 * 
                 * @param response The response in the format as defined with handleAs.             
                 * @param ioArgs Provides additional information about the request.             
                 */
                load(response: Object, ioArgs: dojo.main.__IoCallbackArgs): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.__XhrArgs.html
             *
             * In addition to the properties listed for the dojo._IoArgs type,
             * the following properties are allowed for dojo.xhr* methods.
             * 
             */
            class __XhrArgs {
                constructor();
                /**
                 * Contains properties with string values. These
                 * properties will be serialized as name1=value2 and
                 * passed in the request.
                 * 
                 */
                "content": Object;
                /**
                 * "application/x-www-form-urlencoded" is default. Set to false to
                 * prevent a Content-Type header from being sent, or to a string
                 * to send a different Content-Type.
                 * 
                 */
                "contentType": string;
                /**
                 * false is default. Indicates whether a request should be
                 * allowed to fail (and therefore no console error message in
                 * the event of a failure)
                 * 
                 */
                "failOk": boolean;
                /**
                 * DOM node for a form. Used to extract the form values
                 * and send to the server.
                 * 
                 */
                "form": HTMLElement;
                /**
                 * Acceptable values are: text (default), json, json-comment-optional,
                 * json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlers
                 * 
                 */
                "handleAs": string;
                /**
                 * Additional HTTP headers to send in the request.
                 * 
                 */
                "headers": Object;
                /**
                 * Set this explicitly to false to prevent publishing of topics related to
                 * IO operations. Otherwise, if djConfig.ioPublish is set to true, topics
                 * will be published via dojo/topic.publish() for different phases of an IO operation.
                 * See dojo/main.__IoPublish for a list of topics that are published.
                 * 
                 */
                "ioPublish": boolean;
                /**
                 * Default is false. If true, then a
                 * "dojo.preventCache" parameter is sent in the request
                 * with a value that changes with each request
                 * (timestamp). Useful only with GET-type requests.
                 * 
                 */
                "preventCache": boolean;
                /**
                 * Sets the raw body for an HTTP request. If this is used, then the content
                 * property is ignored. This is mostly useful for HTTP methods that have
                 * a body to their requests, like PUT or POST. This property can be used instead
                 * of postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.
                 * 
                 */
                "rawBody": string;
                /**
                 * false is default. Indicates whether the request should
                 * be a synchronous (blocking) request.
                 * 
                 */
                "sync": boolean;
                /**
                 * Milliseconds to wait for the response. If this time
                 * passes, the then error callbacks are called.
                 * 
                 */
                "timeout": number;
                /**
                 * URL to server endpoint.
                 * 
                 */
                "url": string;
                /**
                 * This function will
                 * be called when the request fails due to a network or server error, the url
                 * is invalid, etc. It will also be called if the load or handle callback throws an
                 * exception, unless djConfig.debugAtAllCosts is true.  This allows deployed applications
                 * to continue to run even when a logic error happens in the callback, while making
                 * it easier to troubleshoot while in debug mode.
                 * 
                 * @param response The response in the format as defined with handleAs.             
                 * @param ioArgs Provides additional information about the request.             
                 */
                error(response: Object, ioArgs: dojo.main.__IoCallbackArgs): void;
                /**
                 * This function will
                 * be called at the end of every request, whether or not an error occurs.
                 * 
                 * @param loadOrError Provides a string that tells you whether this functionwas called because of success (load) or failure (error).             
                 * @param response The response in the format as defined with handleAs.             
                 * @param ioArgs Provides additional information about the request.             
                 */
                handle(loadOrError: String, response: Object, ioArgs: dojo.main.__IoCallbackArgs): void;
                /**
                 * This function will be
                 * called on a successful HTTP response code.
                 * 
                 * @param response The response in the format as defined with handleAs.             
                 * @param ioArgs Provides additional information about the request.             
                 */
                load(response: Object, ioArgs: dojo.main.__IoCallbackArgs): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.Stateful.html
             *
             * Base class for objects that provide named properties with optional getter/setter
             * control and the ability to watch for property changes
             * 
             * The class also provides the functionality to auto-magically manage getters
             * and setters for object attributes/properties.
             * 
             * Getters and Setters should follow the format of _xxxGetter or _xxxSetter where 
             * the xxx is a name of the attribute to handle.  So an attribute of "foo" 
             * would have a custom getter of _fooGetter and a custom setter of _fooSetter.
             * 
             */
            class Stateful {
                constructor();
                /**
                 * Get a property on a Stateful instance.
                 * Get a named property on a Stateful object. The property may
                 * potentially be retrieved via a getter method in subclasses. In the base class
                 * this just retrieves the object's property.
                 * 
                 * @param name The property to get.             
                 */
                get(name: String): any;
                /**
                 * 
                 * @param params               Optional            
                 */
                postscript(params: Object): void;
                /**
                 * Set a property on a Stateful instance
                 * Sets named properties on a stateful object and notifies any watchers of
                 * the property. A programmatic setter may be defined in subclasses.
                 * 
                 * @param name The property to set.             
                 * @param value The value to set in the property.             
                 */
                set(name: String, value: Object): any;
                /**
                 * Watches a property for changes
                 * 
                 * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
                 * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
                 */
                watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel._contentHandlers.html
             *
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls.
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls. Each contentHandler is
             * called, passing the xhr object for manipulation. The return value
             * from the contentHandler will be passed to the load or handle
             * functions defined in the original xhr call.
             * 
             */
            interface _contentHandlers {
                /**
                 * 
                 * @param xhr             
                 */
                auto(xhr: any): void;
                /**
                 * A contentHandler which evaluates the response data, expecting it to be valid JavaScript
                 * 
                 * @param xhr             
                 */
                javascript(xhr: any): any;
                /**
                 * A contentHandler which returns a JavaScript object created from the response data
                 * 
                 * @param xhr             
                 */
                json(xhr: any): any;
                /**
                 * A contentHandler which expects comment-filtered JSON.
                 * A contentHandler which expects comment-filtered JSON.
                 * the json-comment-filtered option was implemented to prevent
                 * "JavaScript Hijacking", but it is less secure than standard JSON. Use
                 * standard JSON instead. JSON prefixing can be used to subvert hijacking.
                 * 
                 * Will throw a notice suggesting to use application/json mimetype, as
                 * json-commenting can introduce security issues. To decrease the chances of hijacking,
                 * use the standard json contentHandler, and prefix your "JSON" with: {}&&
                 * 
                 * use djConfig.useCommentedJson = true to turn off the notice
                 * 
                 * @param xhr             
                 */
                json_comment_filtered(xhr: any): any;
                /**
                 * A contentHandler which checks the presence of comment-filtered JSON and
                 * alternates between the json and json-comment-filtered contentHandlers.
                 * 
                 * @param xhr             
                 */
                json_comment_optional(xhr: any): any;
                /**
                 * 
                 * @param xhr             
                 */
                olson_zoneinfo(xhr: any): void;
                /**
                 * A contentHandler which simply returns the plaintext response data
                 * 
                 * @param xhr             
                 */
                text(xhr: any): any;
                /**
                 * A contentHandler returning an XML Document parsed from the response data
                 * 
                 * @param xhr             
                 */
                xml(xhr: any): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel._hasResource.html
             *
             * 
             */
            interface _hasResource {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel._nodeDataCache.html
             *
             * 
             */
            interface _nodeDataCache {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.back.html
             *
             * Browser history management resources
             * 
             */
            interface back {
                /**
                 * adds a state object (args) to the history list.
                 * To support getting back button notifications, the object
                 * argument should implement a function called either "back",
                 * "backButton", or "handle". The string "back" will be passed as
                 * the first and only argument to this callback.
                 * 
                 * To support getting forward button notifications, the object
                 * argument should implement a function called either "forward",
                 * "forwardButton", or "handle". The string "forward" will be
                 * passed as the first and only argument to this callback.
                 * 
                 * If you want the browser location string to change, define "changeUrl" on the object. If the
                 * value of "changeUrl" is true, then a unique number will be appended to the URL as a fragment
                 * identifier (http://some.domain.com/path#uniquenumber). If it is any other value that does
                 * not evaluate to false, that value will be used as the fragment identifier. For example,
                 * if changeUrl: 'page1', then the URL will look like: http://some.domain.com/path#page1
                 * 
                 * There are problems with using dojo/back with semantically-named fragment identifiers
                 * ("hash values" on an URL). In most browsers it will be hard for dojo/back to know
                 * distinguish a back from a forward event in those cases. For back/forward support to
                 * work best, the fragment ID should always be a unique value (something using new Date().getTime()
                 * for example). If you want to detect hash changes using semantic fragment IDs, then
                 * consider using dojo/hash instead (in Dojo 1.4+).
                 * 
                 * @param args The state object that will be added to the history list.             
                 */
                addToHistory(args: Object): void;
                /**
                 * 
                 */
                getHash(): any;
                /**
                 * private method. Do not call this directly.
                 * 
                 */
                goBack(): void;
                /**
                 * private method. Do not call this directly.
                 * 
                 */
                goForward(): void;
                /**
                 * Initializes the undo stack. This must be called from a 
                 * block that lives inside the <code>&lt;body&gt;</code> tag to prevent bugs on IE.
                 * </p>
                 * <p>Only call this method before the page&#39;s DOM is finished loading. Otherwise
                 * it will not work. Be careful with xdomain loading or djConfig.debugAtAllCosts scenarios,
                 * in order for this method to work, dojo/back will need to be part of a build layer.</p>
                 * </div>
                 *       </div>
                 *       <div class="jsdoc-field extension-module">
                 *         <div class="jsdoc-title"><a name="1_9dojo__base_kernel_back_setHash"></a><span class="functionIcon">setHash</span><span class="parameters">(h)</span> 
                 *         </div>
                 *         <div class="jsdoc-inheritance">Defined by <a href="/api/1.9/dojo/back" class="jsdoc-link">dojo/back</a><span title="Must manually require () dojo/back to access" class="jsdoc-extension"></span>
                 *         </div>
                 *         <div class="jsdoc-full-summary"></div>
                 *         <table class="jsdoc-parameters">
                 *           <tr>
                 *             <th>Parameter</th>
                 *             <th>Type</th>
                 *             <th>Description</th>
                 *           </tr>
                 *           <tr>
                 *             <td class="jsdoc-param-name">h</td>
                 *             <td class="jsdoc-param-type">undefined</td>
                 *             <td class="jsdoc-param-description">
                 *             </td>
                 *           </tr>
                 *         </table>
                 *       </div>
                 *       <div class="jsdoc-field extension-module">
                 *         <div class="jsdoc-title"><a name="1_9dojo__base_kernel_back_setInitialState"></a><span class="functionIcon">setInitialState</span><span class="parameters">(args)</span> 
                 *         </div>
                 *         <div class="jsdoc-inheritance">Defined by <a href="/api/1.9/dojo/back" class="jsdoc-link">dojo/back</a><span title="Must manually require () dojo/back to access" class="jsdoc-extension"></span>
                 *         </div>
                 *         <div class="jsdoc-full-summary"><p>Sets the state object and back callback for the very first page
                 * that is loaded.
                 * </p>
                 * <p>It is recommended that you call this method as part of an event
                 * listener that is registered via dojo/ready.</p>
                 * </div>
                 *         <table class="jsdoc-parameters">
                 *           <tr>
                 *             <th>Parameter</th>
                 *             <th>Type</th>
                 *             <th>Description</th>
                 *           </tr>
                 *           <tr>
                 *             <td class="jsdoc-param-name">args</td>
                 *             <td class="jsdoc-param-type">Object</td>
                 *             <td class="jsdoc-param-description"><p>See the addToHistory() function for the list of valid args properties.</p>
                 *  
                 *             </td>
                 *           </tr>
                 *         </table>
                 *       </div>
                 *     </div>
                 *   </div>
                 * </div><a href="https://docs.google.com/spreadsheet/viewform?hl=en_US&amp;formkey=dFlDcHEyaHMwbEd4MFBObkNrX0E1MFE6MQ&amp;entry_0=/api/1.9/dojo/_base/kernel.back" class="feedback">Error in the documentation? Can't find what you are looking for? Let us know!</a>
                 */
                init(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.cldr.html
             *
             * 
             */
            interface cldr {
                /**
                 * TODOC
                 * 
                 */
                monetary: Object;
                /**
                 * TODOC
                 * 
                 */
                supplemental: Object;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.colors.html
             *
             * 
             */
            interface colors {
                /**
                 * creates a greyscale color with an optional alpha
                 * 
                 * @param g             
                 * @param a               Optional            
                 */
                makeGrey(g: number, a: number): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.config.html
             *
             * This module defines the user configuration during bootstrap.
             * By defining user configuration as a module value, an entire configuration can be specified in a build,
             * thereby eliminating the need for sniffing and or explicitly setting in the global variable dojoConfig.
             * Also, when multiple instances of dojo exist in a single application, each will necessarily be located
             * at an unique absolute module identifier as given by the package configuration. Implementing configuration
             * as a module allows for specifying unique, per-instance configurations.
             * 
             */
            interface config {
                /**
                 * Adds a callback via dojo/ready. Useful when Dojo is added after
                 * the page loads and djConfig.afterOnLoad is true. Supports the same
                 * arguments as dojo/ready. When using a function reference, use
                 * djConfig.addOnLoad = function(){};. For object with function name use
                 * djConfig.addOnLoad = [myObject, "functionName"]; and for object with
                 * function reference use
                 * djConfig.addOnLoad = [myObject, function(){}];
                 * 
                 */
                addOnLoad: Function;
                /**
                 * 
                 */
                afterOnLoad: boolean;
                /**
                 * 
                 */
                baseUrl: Object;
                /**
                 * Defines a callback to be used when dependencies are defined before 
                 * the loader has been loaded. When provided, they cause the loader to 
                 * execute require(deps, callback) once it has finished loading. 
                 * Should be used with deps.
                 * 
                 */
                callback: Function;
                /**
                 * 
                 */
                debugContainerId: string;
                /**
                 * 
                 */
                debugHeight: number;
                /**
                 * Default duration, in milliseconds, for wipe and fade animations within dijits.
                 * Assigned to dijit.defaultDuration.
                 * 
                 */
                defaultDuration: number;
                /**
                 * Whether deferred instrumentation should be loaded or included
                 * in builds.
                 * 
                 */
                deferredInstrumentation: boolean;
                /**
                 * Defines dependencies to be used before the loader has been loaded.
                 * When provided, they cause the loader to execute require(deps, callback) 
                 * once it has finished loading. Should be used with callback.
                 * 
                 */
                deps: Function;
                /**
                 * Used by some modules to configure an empty iframe. Used by dojo/io/iframe and
                 * dojo/back, and dijit/popup support in IE where an iframe is needed to make sure native
                 * controls do not bleed through the popups. Normally this configuration variable
                 * does not need to be set, except when using cross-domain/CDN Dojo builds.
                 * Save dojo/resources/blank.html to your domain and set djConfig.dojoBlankHtmlUrl
                 * to the path on your domain your copy of blank.html.
                 * 
                 */
                dojoBlankHtmlUrl: string;
                /**
                 * No default value. Specifies additional locales whose
                 * resources should also be loaded alongside the default locale when
                 * calls to dojo.requireLocalization() are processed.
                 * 
                 */
                extraLocale: any[];
                /**
                 * Set this to true to enable publishing of topics for the different phases of
                 * IO operations. Publishing is done via dojo/topic.publish(). See dojo/main.__IoPublish for a list
                 * of topics that are published.
                 * 
                 */
                ioPublish: Object;
                /**
                 * Defaults to false. If set to true, ensures that Dojo provides
                 * extended debugging feedback via Firebug. If Firebug is not available
                 * on your platform, setting isDebug to true will force Dojo to
                 * pull in (and display) the version of Firebug Lite which is
                 * integrated into the Dojo distribution, thereby always providing a
                 * debugging/logging console when isDebug is enabled. Note that
                 * Firebug's console.* methods are ALWAYS defined by Dojo. If
                 * isDebug is false and you are on a platform without Firebug, these
                 * methods will be defined as no-ops.
                 * 
                 */
                isDebug: boolean;
                /**
                 * The locale to assume for loading localized resources in this page,
                 * specified according to RFC 3066.
                 * Must be specified entirely in lowercase, e.g. en-us and zh-cn.
                 * See the documentation for dojo.i18n and dojo.requireLocalization
                 * for details on loading localized resources. If no locale is specified,
                 * Dojo assumes the locale of the user agent, according to navigator.userLanguage
                 * or navigator.language properties.
                 * 
                 */
                locale: string;
                /**
                 * A map of module names to paths relative to dojo.baseUrl. The
                 * key/value pairs correspond directly to the arguments which
                 * dojo.registerModulePath accepts. Specifying
                 * djConfig.modulePaths = { "foo": "../../bar" } is the equivalent
                 * of calling dojo.registerModulePath("foo", "../../bar");. Multiple
                 * modules may be configured via djConfig.modulePaths.
                 * 
                 */
                modulePaths: Object;
                /**
                 * Run the parser after the page is loaded
                 * 
                 */
                parseOnLoad: boolean;
                /**
                 * An array of module names to be loaded immediately after dojo.js has been included
                 * in a page.
                 * 
                 */
                require: Object;
                /**
                 * Array containing the r, g, b components used as transparent color in dojo.Color;
                 * if undefined, [255,255,255] (white) will be used.
                 * 
                 */
                transparentColor: any[];
                /**
                 * Used by dojox.analytics.Urchin as the default UA-123456-7 account
                 * number used when being created. Alternately, you can pass an acct:""
                 * parameter to the constructor a la: new dojox.analytics.Urchin({ acct:"UA-123456-7" });
                 * 
                 */
                urchin: string;
                /**
                 * If set to a value that evaluates to true such as a string or array and
                 * isDebug is true and Firebug is not available or running, then it bypasses
                 * the creation of Firebug Lite allowing you to define your own console object.
                 * 
                 */
                useCustomLogger: Object;
                /**
                 * Whether the deferred instrumentation should be used.
                 * 
                 * "report-rejections": report each rejection as it occurs.
                 * true or 1 or "report-unhandled-rejections": wait 1 second
                 *   in an attempt to detect unhandled rejections.
                 * 
                 */
                useDeferredInstrumentation: boolean;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.contentHandlers.html
             *
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls.
             * A map of available XHR transport handle types. Name matches the
             * handleAs attribute passed to XHR calls. Each contentHandler is
             * called, passing the xhr object for manipulation. The return value
             * from the contentHandler will be passed to the load or handle
             * functions defined in the original xhr call.
             * 
             */
            interface contentHandlers {
                /**
                 * 
                 * @param xhr             
                 */
                auto(xhr: any): void;
                /**
                 * A contentHandler which evaluates the response data, expecting it to be valid JavaScript
                 * 
                 * @param xhr             
                 */
                javascript(xhr: any): any;
                /**
                 * A contentHandler which returns a JavaScript object created from the response data
                 * 
                 * @param xhr             
                 */
                json(xhr: any): any;
                /**
                 * A contentHandler which expects comment-filtered JSON.
                 * A contentHandler which expects comment-filtered JSON.
                 * the json-comment-filtered option was implemented to prevent
                 * "JavaScript Hijacking", but it is less secure than standard JSON. Use
                 * standard JSON instead. JSON prefixing can be used to subvert hijacking.
                 * 
                 * Will throw a notice suggesting to use application/json mimetype, as
                 * json-commenting can introduce security issues. To decrease the chances of hijacking,
                 * use the standard json contentHandler, and prefix your "JSON" with: {}&&
                 * 
                 * use djConfig.useCommentedJson = true to turn off the notice
                 * 
                 * @param xhr             
                 */
                json_comment_filtered(xhr: any): any;
                /**
                 * A contentHandler which checks the presence of comment-filtered JSON and
                 * alternates between the json and json-comment-filtered contentHandlers.
                 * 
                 * @param xhr             
                 */
                json_comment_optional(xhr: any): any;
                /**
                 * 
                 * @param xhr             
                 */
                olson_zoneinfo(xhr: any): void;
                /**
                 * A contentHandler which simply returns the plaintext response data
                 * 
                 * @param xhr             
                 */
                text(xhr: any): any;
                /**
                 * A contentHandler returning an XML Document parsed from the response data
                 * 
                 * @param xhr             
                 */
                xml(xhr: any): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.dnd.html
             *
             * 
             */
            interface dnd {
                /**
                 * Used by dojo/dnd/Manager to scroll document or internal node when the user
                 * drags near the edge of the viewport or a scrollable node
                 * 
                 */
                autoscroll: Object;
                /**
                 * 
                 */
                move: Object;
                /**
                 * 
                 */
                AutoSource(): void;
                /**
                 * 
                 */
                Avatar(): void;
                /**
                 * 
                 */
                Container(): void;
                /**
                 * 
                 */
                Manager(): void;
                /**
                 * 
                 */
                Moveable(): void;
                /**
                 * 
                 */
                Mover(): void;
                /**
                 * 
                 */
                Selector(): void;
                /**
                 * 
                 */
                Source(): void;
                /**
                 * 
                 */
                Target(): void;
                /**
                 * 
                 */
                TimedMoveable(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.date.html
             *
             * 
             */
            interface date {
                /**
                 * TODOC
                 * 
                 */
                stamp: Object;
                /**
                 * Add to a Date in intervals of different size, from milliseconds to years
                 * 
                 * @param date Date object to start with             
                 * @param interval A string representing the interval.  One of the following:"year", "month", "day", "hour", "minute", "second","millisecond", "quarter", "week", "weekday"             
                 * @param amount How much to add to the date.             
                 */
                add(date: Date, interval: String, amount: number): any;
                /**
                 * Compare two date objects by date, time, or both.
                 * Returns 0 if equal, positive if a > b, else negative.
                 * 
                 * @param date1 Date object             
                 * @param date2               OptionalDate object.  If not specified, the current Date is used.             
                 * @param portion               OptionalA string indicating the "date" or "time" portion of a Date object.Compares both "date" and "time" by default.  One of the following:"date", "time", "datetime"             
                 */
                compare(date1: Date, date2: Date, portion: String): number;
                /**
                 * Get the difference in a specific unit of time (e.g., number of
                 * months, weeks, days, etc.) between two dates, rounded to the
                 * nearest integer.
                 * 
                 * @param date1 Date object             
                 * @param date2               OptionalDate object.  If not specified, the current Date is used.             
                 * @param interval               OptionalA string representing the interval.  One of the following:"year", "month", "day", "hour", "minute", "second","millisecond", "quarter", "week", "weekday"Defaults to "day".             
                 */
                difference(date1: Date, date2: Date, interval: String): any;
                /**
                 * Returns the number of days in the month used by dateObject
                 * 
                 * @param dateObject             
                 */
                getDaysInMonth(dateObject: Date): number;
                /**
                 * Get the user's time zone as provided by the browser
                 * Try to get time zone info from toString or toLocaleString method of
                 * the Date object -- UTC offset is not a time zone.  See
                 * http://www.twinsun.com/tz/tz-link.htm Note: results may be
                 * inconsistent across browsers.
                 * 
                 * @param dateObject Needed because the timezone may vary with time (daylight savings)             
                 */
                getTimezoneName(dateObject: Date): any;
                /**
                 * Determines if the year of the dateObject is a leap year
                 * Leap years are years with an additional day YYYY-02-29, where the
                 * year number is a multiple of four with the following exception: If
                 * a year is a multiple of 100, then it is only a leap year if it is
                 * also a multiple of 400. For example, 1900 was not a leap year, but
                 * 2000 is one.
                 * 
                 * @param dateObject             
                 */
                isLeapYear(dateObject: Date): boolean;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.doc.html
             *
             * Alias for the current document. 'doc' can be modified
             * for temporary context shifting. See also withDoc().
             * Use this rather than referring to 'window.document' to ensure your code runs
             * correctly in managed contexts.
             * 
             */
            interface doc {
                /**
                 * 
                 */
                documentElement: Object;
                /**
                 * 
                 */
                dojoClick: boolean;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.data.html
             *
             * 
             */
            interface data {
                /**
                 * 
                 */
                api: Object;
                /**
                 * 
                 */
                util: Object;
                /**
                 * 
                 */
                ItemFileReadStore(): void;
                /**
                 * 
                 */
                ItemFileWriteStore(): void;
                /**
                 * 
                 */
                ObjectStore(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.currency.html
             *
             * localized formatting and parsing routines for currencies
             * extends dojo.number to provide culturally-appropriate formatting of values
             * in various world currencies, including use of a currency symbol.  The currencies are specified
             * by a three-letter international symbol in all uppercase, and support for the currencies is
             * provided by the data in dojo.cldr.  The scripts generating dojo.cldr specify which
             * currency support is included.  A fixed number of decimal places is determined based
             * on the currency type and is not determined by the 'pattern' argument.  The fractional
             * portion is optional, by default, and variable length decimals are not supported.
             * 
             */
            interface currency {
                /**
                 * Format a Number as a currency, using locale-specific settings
                 * Create a string from a Number using a known, localized pattern.
                 * Formatting patterns
                 * appropriate to the locale are chosen from the CLDR
                 * as well as the appropriate symbols and delimiters and number of decimal places.
                 * 
                 * @param value the number to be formatted.             
                 * @param options               Optional            
                 */
                format(value: number, options: dojo.currency.__FormatOptions): any;
                /**
                 * 
                 * @param expression             
                 * @param options               OptionalAn object with the following properties:type (String, optional): Should not be set.  Value is assumed to be currency.currency (String, optional): an ISO4217 currency code, a three letter sequence like "USD".For use with dojo.currency only.symbol (String, optional): localized currency symbol. The default will be looked up in table of supported currencies in dojo.cldrA ISO4217 currency code will be used if not found.places (Number, optional): fixed number of decimal places to accept.  The default is determined based on which currency is used.fractional (Boolean|Array, optional): Whether to include the fractional portion, where the number of decimal places are implied by the currencyor explicit 'places' parameter.  The value [true,false] makes the fractional portion optional.By default for currencies, it the fractional portion is optional.pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.  Literal characters in patterns are not supported.locale (String, optional): override the locale used to determine formatting rulesstrict (Boolean, optional): strict parsing, false by default.  Strict parsing requires input as produced by the format() method.Non-strict is more permissive, e.g. flexible on white space, omitting thousands separators            
                 */
                parse(expression: String, options: Object): any;
                /**
                 * 
                 * @param options               OptionalAn object with the following properties:pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.type (String, optional): choose a format type based on the locale from the following:decimal, scientific (not yet supported), percent, currency. decimal by default.locale (String, optional): override the locale used to determine formatting rulesstrict (Boolean, optional): strict parsing, false by default.  Strict parsing requires input as produced by the format() method.Non-strict is more permissive, e.g. flexible on white space, omitting thousands separatorsplaces (Number|String, optional): number of decimal places to accept: Infinity, a positive number, ora range "n,m".  Defined by pattern or Infinity if pattern not provided.            
                 */
                regexp(options: Object): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.dijit.html
             *
             * 
             */
            interface dijit {
                /**
                 * 
                 */
                form: Object;
                /**
                 * 
                 */
                layout: Object;
                /**
                 * W3C range API
                 * 
                 */
                range: Object;
                /**
                 * 
                 */
                registry: Object;
                /**
                 * 
                 */
                tree: Object;
                /**
                 * 
                 * @param id             
                 */
                byId(id: any): any;
                /**
                 * 
                 */
                Calendar(): void;
                /**
                 * 
                 */
                CalendarLite(): void;
                /**
                 * 
                 */
                CheckedMenuItem(): void;
                /**
                 * 
                 */
                ColorPalette(): void;
                /**
                 * 
                 */
                Declaration(): void;
                /**
                 * 
                 */
                Destroyable(): void;
                /**
                 * 
                 */
                Dialog(): void;
                /**
                 * 
                 */
                DialogUnderlay(): void;
                /**
                 * 
                 */
                DropDownMenu(): void;
                /**
                 * 
                 */
                Dye(): void;
                /**
                 * 
                 */
                Editor(): void;
                /**
                 * 
                 */
                Fieldset(): void;
                /**
                 * 
                 */
                InlineEditBox(): void;
                /**
                 * 
                 */
                Menu(): void;
                /**
                 * 
                 */
                MenuBar(): void;
                /**
                 * 
                 */
                MenuBarItem(): void;
                /**
                 * 
                 */
                MenuItem(): void;
                /**
                 * 
                 */
                MenuSeparator(): void;
                /**
                 * 
                 */
                PopupMenuBarItem(): void;
                /**
                 * 
                 */
                PopupMenuItem(): void;
                /**
                 * 
                 */
                ProgressBar(): void;
                /**
                 * 
                 */
                RadioButtonMenuItem(): void;
                /**
                 * 
                 */
                TitlePane(): void;
                /**
                 * 
                 */
                Toolbar(): void;
                /**
                 * 
                 */
                ToolbarSeparator(): void;
                /**
                 * 
                 */
                Tooltip(): void;
                /**
                 * 
                 */
                TooltipDialog(): void;
                /**
                 * 
                 */
                Tree(): void;
                /**
                 * 
                 */
                WidgetSet(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.global.html
             *
             * Alias for the current window. 'global' can be modified
             * for temporary context shifting. See also withGlobal().
             * Use this rather than referring to 'window' to ensure your code runs
             * correctly in managed contexts.
             * 
             */
            interface global {
                /**
                 * 
                 */
                $(): any;
                /**
                 * 
                 * @param start             
                 * @param data             
                 * @param responseCode             
                 * @param errorMsg             
                 */
                GoogleSearchStoreCallback_undefined_NaN(start: any, data: any, responseCode: any, errorMsg: any): void;
                /**
                 * 
                 */
                jQuery(): any;
                /**
                 * 
                 */
                swfIsInHTML(): void;
                /**
                 * 
                 */
                undefined_onload(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.gears.html
             *
             * TODOC
             * 
             */
            interface gears {
                /**
                 * True if client is using Google Gears
                 * 
                 */
                available: Object;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.fx.html
             *
             * Effects library on top of Base animations
             * 
             */
            interface fx {
                /**
                 * Collection of easing functions to use beyond the default
                 * dojo._defaultEasing function.
                 * 
                 */
                easing: Object;
                /**
                 * Chain a list of dojo/_base/fx.Animations to run in sequence
                 * Return a dojo/_base/fx.Animation which will play all passed
                 * dojo/_base/fx.Animation instances in sequence, firing its own
                 * synthesized events simulating a single animation. (eg:
                 * onEnd of this animation means the end of the chain,
                 * not the individual animations within)
                 * 
                 * @param animations             
                 */
                chain(animations: dojo._base.fx.Animation[]): any;
                /**
                 * Combine a list of dojo/_base/fx.Animations to run in parallel
                 * Combine an array of dojo/_base/fx.Animations to run in parallel,
                 * providing a new dojo/_base/fx.Animation instance encompasing each
                 * animation, firing standard animation events.
                 * 
                 * @param animations             
                 */
                combine(animations: dojo._base.fx.Animation[]): any;
                /**
                 * Slide a node to a new top/left position
                 * Returns an animation that will slide "node"
                 * defined in args Object from its current position to
                 * the position defined by (args.left, args.top).
                 * 
                 * @param args A hash-map of standard dojo/_base/fx.Animation constructor properties(such as easing: node: duration: and so on). Special args membersare top and left, which indicate the new position to slide to.             
                 */
                slideTo(args: Object): any;
                /**
                 * 
                 */
                Toggler(): void;
                /**
                 * Expand a node to it's natural height.
                 * Returns an animation that will expand the
                 * node defined in 'args' object from it's current height to
                 * it's natural height (with no scrollbar).
                 * Node must have no margin/border/padding.
                 * 
                 * @param args A hash-map of standard dojo/_base/fx.Animation constructor properties(such as easing: node: duration: and so on)             
                 */
                wipeIn(args: Object): any;
                /**
                 * Shrink a node to nothing and hide it.
                 * Returns an animation that will shrink node defined in "args"
                 * from it's current height to 1px, and then hide it.
                 * 
                 * @param args A hash-map of standard dojo/_base/fx.Animation constructor properties(such as easing: node: duration: and so on)             
                 */
                wipeOut(args: Object): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.html.html
             *
             * TODOC
             * 
             */
            interface html {
                /**
                 * inserts (replaces) the given content into the given node. dojo/dom-construct.place(cont, node, "only")
                 * may be a better choice for simple HTML insertion.
                 * Unless you need to use the params capabilities of this method, you should use
                 * dojo/dom-construct.place(cont, node, "only"). dojo/dom-construct..place() has more robust support for injecting
                 * an HTML string into the DOM, but it only handles inserting an HTML string as DOM
                 * elements, or inserting a DOM node. dojo/dom-construct..place does not handle NodeList insertions
                 * dojo/dom-construct.place(cont, node, "only"). dojo/dom-construct.place() has more robust support for injecting
                 * an HTML string into the DOM, but it only handles inserting an HTML string as DOM
                 * elements, or inserting a DOM node. dojo/dom-construct.place does not handle NodeList insertions
                 * or the other capabilities as defined by the params object for this method.
                 * 
                 * @param node the parent element that will receive the content             
                 * @param cont the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
                 * @param params               OptionalOptional flags/properties to configure the content-setting. See dojo/html/_ContentSetter             
                 */
                set(node: HTMLElement, cont: String, params: Object): any;
                /**
                 * inserts (replaces) the given content into the given node. dojo/dom-construct.place(cont, node, "only")
                 * may be a better choice for simple HTML insertion.
                 * Unless you need to use the params capabilities of this method, you should use
                 * dojo/dom-construct.place(cont, node, "only"). dojo/dom-construct..place() has more robust support for injecting
                 * an HTML string into the DOM, but it only handles inserting an HTML string as DOM
                 * elements, or inserting a DOM node. dojo/dom-construct..place does not handle NodeList insertions
                 * dojo/dom-construct.place(cont, node, "only"). dojo/dom-construct.place() has more robust support for injecting
                 * an HTML string into the DOM, but it only handles inserting an HTML string as DOM
                 * elements, or inserting a DOM node. dojo/dom-construct.place does not handle NodeList insertions
                 * or the other capabilities as defined by the params object for this method.
                 * 
                 * @param node the parent element that will receive the content             
                 * @param cont the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
                 * @param params               OptionalOptional flags/properties to configure the content-setting. See dojo/html/_ContentSetter             
                 */
                set(node: HTMLElement, cont: HTMLElement, params: Object): any;
                /**
                 * inserts (replaces) the given content into the given node. dojo/dom-construct.place(cont, node, "only")
                 * may be a better choice for simple HTML insertion.
                 * Unless you need to use the params capabilities of this method, you should use
                 * dojo/dom-construct.place(cont, node, "only"). dojo/dom-construct..place() has more robust support for injecting
                 * an HTML string into the DOM, but it only handles inserting an HTML string as DOM
                 * elements, or inserting a DOM node. dojo/dom-construct..place does not handle NodeList insertions
                 * dojo/dom-construct.place(cont, node, "only"). dojo/dom-construct.place() has more robust support for injecting
                 * an HTML string into the DOM, but it only handles inserting an HTML string as DOM
                 * elements, or inserting a DOM node. dojo/dom-construct.place does not handle NodeList insertions
                 * or the other capabilities as defined by the params object for this method.
                 * 
                 * @param node the parent element that will receive the content             
                 * @param cont the content to be set on the parent element.This can be an html string, a node reference or a NodeList, dojo/NodeList, Array or other enumerable list of nodes             
                 * @param params               OptionalOptional flags/properties to configure the content-setting. See dojo/html/_ContentSetter             
                 */
                set(node: HTMLElement, cont: NodeList, params: Object): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.io.html
             *
             * 
             */
            interface io {
                /**
                 * 
                 */
                iframe: Object;
                /**
                 * TODOC
                 * 
                 */
                script: Object;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.dojox.html
             *
             * 
             */
            interface dojox {
                /**
                 * 
                 */
                analytics: Object;
                /**
                 * 
                 */
                app: Object;
                /**
                 * 
                 */
                atom: Object;
                /**
                 * 
                 */
                av: Object;
                /**
                 * 
                 */
                BidiComplex: Object;
                /**
                 * 
                 */
                calc: Object;
                /**
                 * 
                 */
                calendar: Object;
                /**
                 * 
                 */
                charting: Object;
                /**
                 * 
                 */
                collections: Object;
                /**
                 * 
                 */
                color: Object;
                /**
                 * 
                 */
                css3: Object;
                /**
                 * 
                 */
                data: Object;
                /**
                 * 
                 */
                date: Object;
                /**
                 * 
                 */
                dgauges: Object;
                /**
                 * 
                 */
                dnd: Object;
                /**
                 * 
                 */
                drawing: Object;
                /**
                 * 
                 */
                dtl: Object;
                /**
                 * 
                 */
                editor: Object;
                /**
                 * 
                 */
                embed: Object;
                /**
                 * 
                 */
                encoding: Object;
                /**
                 * 
                 */
                enhanced: Object;
                /**
                 * Utilities to embed and communicate with the Flash player from Javascript
                 * 
                 */
                flash: Object;
                /**
                 * 
                 */
                form: Object;
                /**
                 * 
                 */
                fx: Object;
                /**
                 * 
                 */
                gantt: Object;
                /**
                 * 
                 */
                gauges: Object;
                /**
                 * 
                 */
                geo: Object;
                /**
                 * 
                 */
                gesture: Object;
                /**
                 * 
                 */
                gfx: Object;
                /**
                 * 
                 */
                gfx3d: Object;
                /**
                 * 
                 */
                grid: Object;
                /**
                 * 
                 */
                help: Object;
                /**
                 * 
                 */
                highlight: Object;
                /**
                 * 
                 */
                html: Object;
                /**
                 * 
                 */
                image: Object;
                /**
                 * 
                 */
                io: Object;
                /**
                 * 
                 */
                jq: Object;
                /**
                 * 
                 */
                json: Object;
                /**
                 * 
                 */
                jsonPath: Object;
                /**
                 * 
                 */
                lang: Object;
                /**
                 * 
                 */
                layout: Object;
                /**
                 * 
                 */
                math: Object;
                /**
                 * 
                 */
                mdnd: Object;
                /**
                 * 
                 */
                mobile: Object;
                /**
                 * 
                 */
                mvc: Object;
                /**
                 * 
                 */
                openlayers: Object;
                /**
                 * 
                 */
                rails: Object;
                /**
                 * 
                 */
                robot: Object;
                /**
                 * 
                 */
                rpc: Object;
                /**
                 * 
                 */
                secure: Object;
                /**
                 * 
                 */
                sketch: Object;
                /**
                 * 
                 */
                sql: Object;
                /**
                 * 
                 */
                string: Object;
                /**
                 * 
                 */
                testing: Object;
                /**
                 * 
                 */
                timing: Object;
                /**
                 * 
                 */
                treemap: Object;
                /**
                 * 
                 */
                uuid: Object;
                /**
                 * 
                 */
                validate: Object;
                /**
                 * 
                 */
                widget: Object;
                /**
                 * 
                 */
                xml: Object;
                /**
                 * Provides a simple socket connection using WebSocket, or alternate
                 * communication mechanisms in legacy browsers for comet-style communication. This is based
                 * on the WebSocket API and returns an object that implements the WebSocket interface:
                 * http://dev.w3.org/html5/websockets/#websocket
                 * Provides socket connections. This can be used with virtually any Comet protocol.
                 * 
                 * @param argsOrUrl This uses the same arguments as the other I/O functions in Dojo, or aURL to connect to. The URL should be a relative URL in order to properlywork with WebSockets (it can still be host relative, like //other-site.org/endpoint)             
                 */
                socket(argsOrUrl: Object): any;
                /**
                 * 
                 * @param format             
                 * @param filler             
                 */
                sprintf(format: String, filler: any): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.i18n.html
             *
             * This module implements the dojo/i18n! plugin and the v1.6- i18n API
             * We choose to include our own plugin to leverage functionality already contained in dojo
             * and thereby reduce the size of the plugin compared to various loader implementations. Also, this
             * allows foreign AMD loaders to be used without their plugins.
             * 
             */
            interface i18n {
                /**
                 * 
                 */
                cache: Object;
                /**
                 * 
                 */
                dynamic: boolean;
                /**
                 * 
                 */
                unitTests: any[];
                /**
                 * 
                 * @param moduleName             
                 * @param bundleName             
                 * @param locale             
                 */
                getL10nName(moduleName: any, bundleName: any, locale: any): String;
                /**
                 * 
                 * @param moduleName             
                 * @param bundleName             
                 * @param locale             
                 */
                getLocalization(moduleName: any, bundleName: any, locale: any): any;
                /**
                 * id is in one of the following formats
                 * 
                 * /nls/
                 *  => load the bundle, localized to config.locale; load all bundles localized to
                 *  config.extraLocale (if any); return the loaded bundle localized to config.locale.
                 * /nls//
                 *  => load then return the bundle localized to 
                 * preload/nls//
                 *  => for config.locale and all config.extraLocale, load all bundles found
                 *  in the best-matching bundle rollup. A value of 1 is returned, which
                 *  is meaningless other than to say the plugin is executing the requested
                 *  preloads
                 * 
                 * In cases 1 and 2,  is always normalized to an absolute module id upon entry; see
                 * normalize. In case 3, it  is assumed to be absolute; this is arranged by the builder.
                 * 
                 * To load a bundle means to insert the bundle into the plugin's cache and publish the bundle
                 * value to the loader. Given , , and a particular , the cache key
                 * 
                 * <path>/nls/<bundle>/<locale>
                 * will hold the value. Similarly, then plugin will publish this value to the loader by
                 * 
                 * define("<path>/nls/<bundle>/<locale>", <bundle-value>);
                 * Given this algorithm, other machinery can provide fast load paths be preplacing
                 * values in the plugin's cache, which is public. When a load is demanded the
                 * cache is inspected before starting any loading. Explicitly placing values in the plugin
                 * cache is an advanced/experimental feature that should not be needed; use at your own risk.
                 * 
                 * For the normal AMD algorithm, the root bundle is loaded first, which instructs the
                 * plugin what additional localized bundles are required for a particular locale. These
                 * additional locales are loaded and a mix of the root and each progressively-specific
                 * locale is returned. For example:
                 * 
                 * The client demands "dojo/i18n!some/path/nls/someBundle
                 * The loader demands load(some/path/nls/someBundle)
                 * This plugin require's "some/path/nls/someBundle", which is the root bundle.
                 * Assuming config.locale is "ab-cd-ef" and the root bundle indicates that localizations
                 * are available for "ab" and "ab-cd-ef" (note the missing "ab-cd", then the plugin
                 * requires "some/path/nls/ab/someBundle" and "some/path/nls/ab-cd-ef/someBundle"
                 * Upon receiving all required bundles, the plugin constructs the value of the bundle
                 * ab-cd-ef as...
                 *  mixin(mixin(mixin({}, require("some/path/nls/someBundle"),
                 *      require("some/path/nls/ab/someBundle")),
                 *      require("some/path/nls/ab-cd-ef/someBundle"));
                 * 
                 * This value is inserted into the cache and published to the loader at the
                 * key/module-id some/path/nls/someBundle/ab-cd-ef.
                 * 
                 * The special preload signature (case 3) instructs the plugin to stop servicing all normal requests
                 * (further preload requests will be serviced) until all ongoing preloading has completed.
                 * 
                 * The preload signature instructs the plugin that a special rollup module is available that contains
                 * one or more flattened, localized bundles. The JSON array of available locales indicates which locales
                 * are available. Here is an example:
                 * 
                 * *preload*some/path/nls/someModule*["root", "ab", "ab-cd-ef"]
                 * This indicates the following rollup modules are available:
                 * 
                 * some/path/nls/someModule_ROOT
                 * some/path/nls/someModule_ab
                 * some/path/nls/someModule_ab-cd-ef
                 * Each of these modules is a normal AMD module that contains one or more flattened bundles in a hash.
                 * For example, assume someModule contained the bundles some/bundle/path/someBundle and
                 * some/bundle/path/someOtherBundle, then some/path/nls/someModule_ab would be expressed as follows:
                 * 
                 * define({
                 *     some/bundle/path/someBundle:<value of someBundle, flattened with respect to locale ab>,
                 *     some/bundle/path/someOtherBundle:<value of someOtherBundle, flattened with respect to locale ab>,
                 * });
                 * E.g., given this design, preloading for locale=="ab" can execute the following algorithm:
                 * 
                 * require(["some/path/nls/someModule_ab"], function(rollup){
                 *     for(var p in rollup){
                 *         var id = p + "/ab",
                 *         cache[id] = rollup[p];
                 *         define(id, rollup[p]);
                 *     }
                 * });
                 * Similarly, if "ab-cd" is requested, the algorithm can determine that "ab" is the best available and
                 * load accordingly.
                 * 
                 * The builder will write such rollups for every layer if a non-empty localeList  profile property is
                 * provided. Further, the builder will include the following cache entry in the cache associated with
                 * any layer.
                 * 
                 * "*now":function(r){r(['dojo/i18n!*preload*<path>/nls/<module>*<JSON array of available locales>']);}
                 * The *now special cache module instructs the loader to apply the provided function to context-require
                 * with respect to the particular layer being defined. This causes the plugin to hold all normal service
                 * requests until all preloading is complete.
                 * 
                 * Notice that this algorithm is rarely better than the standard AMD load algorithm. Consider the normal case
                 * where the target locale has a single segment and a layer depends on a single bundle:
                 * 
                 * Without Preloads:
                 * 
                 * Layer loads root bundle.
                 * bundle is demanded; plugin loads single localized bundle.
                 * With Preloads:
                 * 
                 * Layer causes preloading of target bundle.
                 * bundle is demanded; service is delayed until preloading complete; bundle is returned.
                 * In each case a single transaction is required to load the target bundle. In cases where multiple bundles
                 * are required and/or the locale has multiple segments, preloads still requires a single transaction whereas
                 * the normal path requires an additional transaction for each additional bundle/locale-segment. However all
                 * of these additional transactions can be done concurrently. Owing to this analysis, the entire preloading
                 * algorithm can be discard during a build by setting the has feature dojo-preload-i18n-Api to false.
                 * 
                 * @param id             
                 * @param require             
                 * @param load             
                 */
                load(id: any, require: any, load: any): void;
                /**
                 * id may be relative.
                 * preload has form *preload*<path>/nls/<module>*<flattened locales> and
                 * therefore never looks like a relative
                 * 
                 * @param id             
                 * @param toAbsMid             
                 */
                normalize(id: any, toAbsMid: any): any;
                /**
                 * 
                 * @param locale             
                 */
                normalizeLocale(locale: any): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.mouseButtons.html
             *
             * 
             */
            interface mouseButtons {
                /**
                 * Numeric value of the left mouse button for the platform.
                 * 
                 */
                LEFT: number;
                /**
                 * Numeric value of the middle mouse button for the platform.
                 * 
                 */
                MIDDLE: number;
                /**
                 * Numeric value of the right mouse button for the platform.
                 * 
                 */
                RIGHT: number;
                /**
                 * Checks an event object for a pressed button
                 * 
                 * @param e Event object to examine             
                 * @param button The button value (example: dojo.mouseButton.LEFT)             
                 */
                isButton(e: Event, button: number): boolean;
                /**
                 * Checks an event object for the pressed left button
                 * 
                 * @param e Event object to examine             
                 */
                isLeft(e: Event): boolean;
                /**
                 * Checks an event object for the pressed middle button
                 * 
                 * @param e Event object to examine             
                 */
                isMiddle(e: Event): boolean;
                /**
                 * Checks an event object for the pressed right button
                 * 
                 * @param e Event object to examine             
                 */
                isRight(e: Event): boolean;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.rpc.html
             *
             * 
             */
            interface rpc {
                /**
                 * 
                 */
                JsonpService(): void;
                /**
                 * 
                 */
                JsonService(): void;
                /**
                 * 
                 */
                RpcService(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.regexp.html
             *
             * Regular expressions and Builder resources
             * 
             */
            interface regexp {
                /**
                 * Builds a regular expression that groups subexpressions
                 * A utility function used by some of the RE generators. The
                 * subexpressions are constructed by the function, re, in the second
                 * parameter.  re builds one subexpression for each elem in the array
                 * a, in the first parameter. Returns a string for a regular
                 * expression that groups all the subexpressions.
                 * 
                 * @param arr A single value or an array of values.             
                 * @param re A function. Takes one parameter and converts it to a regularexpression.             
                 * @param nonCapture               OptionalIf true, uses non-capturing match, otherwise matches are retainedby regular expression. Defaults to false             
                 */
                buildGroupRE(arr: Object, re: Function, nonCapture: boolean): any;
                /**
                 * Builds a regular expression that groups subexpressions
                 * A utility function used by some of the RE generators. The
                 * subexpressions are constructed by the function, re, in the second
                 * parameter.  re builds one subexpression for each elem in the array
                 * a, in the first parameter. Returns a string for a regular
                 * expression that groups all the subexpressions.
                 * 
                 * @param arr A single value or an array of values.             
                 * @param re A function. Takes one parameter and converts it to a regularexpression.             
                 * @param nonCapture               OptionalIf true, uses non-capturing match, otherwise matches are retainedby regular expression. Defaults to false             
                 */
                buildGroupRE(arr: any[], re: Function, nonCapture: boolean): any;
                /**
                 * Adds escape sequences for special characters in regular expressions
                 * 
                 * @param str             
                 * @param except               Optionala String with special characters to be left unescaped             
                 */
                escapeString(str: String, except: String): any;
                /**
                 * adds group match to expression
                 * 
                 * @param expression             
                 * @param nonCapture               OptionalIf true, uses non-capturing match, otherwise matches are retainedby regular expression.             
                 */
                group(expression: String, nonCapture: boolean): String;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.number.html
             *
             * localized formatting and parsing routines for Number
             * 
             */
            interface number_ {
                /**
                 * Format a Number as a String, using locale-specific settings
                 * Create a string from a Number using a known localized pattern.
                 * Formatting patterns appropriate to the locale are chosen from the
                 * Common Locale Data Repository as well as the appropriate symbols and
                 * delimiters.
                 * If value is Infinity, -Infinity, or is not a valid JavaScript number, return null.
                 * 
                 * @param value the number to be formatted             
                 * @param options               OptionalAn object with the following properties:pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.  Literal characters in patterns are not supported.type (String, optional): choose a format type based on the locale from the following:decimal, scientific (not yet supported), percent, currency. decimal by default.places (Number, optional): fixed number of decimal places to show.  This overrides anyinformation in the provided pattern.round (Number, optional): 5 rounds to nearest .5; 0 rounds to nearest whole (default). -1means do not round.locale (String, optional): override the locale used to determine formatting rulesfractional (Boolean, optional): If false, show no decimal places, overriding places and pattern settings.            
                 */
                format(value: number, options: Object): any;
                /**
                 * Convert a properly formatted string to a primitive Number, using
                 * locale-specific settings.
                 * Create a Number from a string using a known localized pattern.
                 * Formatting patterns are chosen appropriate to the locale
                 * and follow the syntax described by
                 * unicode.org TR35
                 * Note that literal characters in patterns are not supported.
                 * 
                 * @param expression A string representation of a Number             
                 * @param options               OptionalAn object with the following properties:pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.  Literal characters in patterns are not supported.type (String, optional): choose a format type based on the locale from the following:decimal, scientific (not yet supported), percent, currency. decimal by default.locale (String, optional): override the locale used to determine formatting rulesstrict (Boolean, optional): strict parsing, false by default.  Strict parsing requires input as produced by the format() method.Non-strict is more permissive, e.g. flexible on white space, omitting thousands separatorsfractional (Boolean|Array, optional): Whether to include the fractional portion, where the number of decimal places are implied by patternor explicit 'places' parameter.  The value [true,false] makes the fractional portion optional.            
                 */
                parse(expression: String, options: Object): number;
                /**
                 * Builds the regular needed to parse a number
                 * Returns regular expression with positive and negative match, group
                 * and decimal separators
                 * 
                 * @param options               OptionalAn object with the following properties:pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.type (String, optional): choose a format type based on the locale from the following:decimal, scientific (not yet supported), percent, currency. decimal by default.locale (String, optional): override the locale used to determine formatting rulesstrict (Boolean, optional): strict parsing, false by default.  Strict parsing requires input as produced by the format() method.Non-strict is more permissive, e.g. flexible on white space, omitting thousands separatorsplaces (Number|String, optional): number of decimal places to accept: Infinity, a positive number, ora range "n,m".  Defined by pattern or Infinity if pattern not provided.            
                 */
                regexp(options: Object): any;
                /**
                 * Rounds to the nearest value with the given number of decimal places, away from zero
                 * Rounds to the nearest value with the given number of decimal places, away from zero if equal.
                 * Similar to Number.toFixed(), but compensates for browser quirks. Rounding can be done by
                 * fractional increments also, such as the nearest quarter.
                 * NOTE: Subject to floating point errors.  See dojox/math/round for experimental workaround.
                 * 
                 * @param value The number to round             
                 * @param places               OptionalThe number of decimal places where rounding takes place.  Defaults to 0 for whole rounding.Must be non-negative.             
                 * @param increment               OptionalRounds next place to nearest value of increment/10.  10 by default.             
                 */
                round(value: number, places: number, increment: number): number;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.scopeMap.html
             *
             * 
             */
            interface scopeMap {
                /**
                 * 
                 */
                dijit: any[];
                /**
                 * 
                 */
                dojo: any[];
                /**
                 * 
                 */
                dojox: any[];
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.tests.html
             *
             * D.O.H. Test files for Dojo unit testing.
             * 
             */
            interface tests {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.keys.html
             *
             * Definitions for common key values.  Client code should test keyCode against these named constants,
             * as the actual codes can vary by browser.
             * 
             */
            interface keys {
                /**
                 * 
                 */
                ALT: number;
                /**
                 * 
                 */
                BACKSPACE: number;
                /**
                 * 
                 */
                CAPS_LOCK: number;
                /**
                 * 
                 */
                CLEAR: number;
                /**
                 * 
                 */
                copyKey: number;
                /**
                 * 
                 */
                CTRL: number;
                /**
                 * 
                 */
                DELETE: number;
                /**
                 * 
                 */
                DOWN_ARROW: number;
                /**
                 * 
                 */
                DOWN_DPAD: number;
                /**
                 * 
                 */
                END: number;
                /**
                 * 
                 */
                ENTER: number;
                /**
                 * 
                 */
                ESCAPE: number;
                /**
                 * 
                 */
                F1: number;
                /**
                 * 
                 */
                F10: number;
                /**
                 * 
                 */
                F11: number;
                /**
                 * 
                 */
                F12: number;
                /**
                 * 
                 */
                F13: number;
                /**
                 * 
                 */
                F14: number;
                /**
                 * 
                 */
                F15: number;
                /**
                 * 
                 */
                F2: number;
                /**
                 * 
                 */
                F3: number;
                /**
                 * 
                 */
                F4: number;
                /**
                 * 
                 */
                F5: number;
                /**
                 * 
                 */
                F6: number;
                /**
                 * 
                 */
                F7: number;
                /**
                 * 
                 */
                F8: number;
                /**
                 * 
                 */
                F9: number;
                /**
                 * 
                 */
                HELP: number;
                /**
                 * 
                 */
                HOME: number;
                /**
                 * 
                 */
                INSERT: number;
                /**
                 * 
                 */
                LEFT_ARROW: number;
                /**
                 * 
                 */
                LEFT_DPAD: number;
                /**
                 * 
                 */
                LEFT_WINDOW: number;
                /**
                 * 
                 */
                META: number;
                /**
                 * 
                 */
                NUM_LOCK: number;
                /**
                 * 
                 */
                NUMPAD_0: number;
                /**
                 * 
                 */
                NUMPAD_1: number;
                /**
                 * 
                 */
                NUMPAD_2: number;
                /**
                 * 
                 */
                NUMPAD_3: number;
                /**
                 * 
                 */
                NUMPAD_4: number;
                /**
                 * 
                 */
                NUMPAD_5: number;
                /**
                 * 
                 */
                NUMPAD_6: number;
                /**
                 * 
                 */
                NUMPAD_7: number;
                /**
                 * 
                 */
                NUMPAD_8: number;
                /**
                 * 
                 */
                NUMPAD_9: number;
                /**
                 * 
                 */
                NUMPAD_DIVIDE: number;
                /**
                 * 
                 */
                NUMPAD_ENTER: number;
                /**
                 * 
                 */
                NUMPAD_MINUS: number;
                /**
                 * 
                 */
                NUMPAD_MULTIPLY: number;
                /**
                 * 
                 */
                NUMPAD_PERIOD: number;
                /**
                 * 
                 */
                NUMPAD_PLUS: number;
                /**
                 * 
                 */
                PAGE_DOWN: number;
                /**
                 * 
                 */
                PAGE_UP: number;
                /**
                 * 
                 */
                PAUSE: number;
                /**
                 * 
                 */
                RIGHT_ARROW: number;
                /**
                 * 
                 */
                RIGHT_DPAD: number;
                /**
                 * 
                 */
                RIGHT_WINDOW: number;
                /**
                 * 
                 */
                SCROLL_LOCK: number;
                /**
                 * 
                 */
                SELECT: number;
                /**
                 * 
                 */
                SHIFT: number;
                /**
                 * 
                 */
                SPACE: number;
                /**
                 * 
                 */
                TAB: number;
                /**
                 * 
                 */
                UP_ARROW: number;
                /**
                 * 
                 */
                UP_DPAD: number;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.store.html
             *
             * 
             */
            interface store {
                /**
                 * 
                 */
                util: Object;
                /**
                 * 
                 * @param masterStore             
                 * @param cachingStore             
                 * @param options             
                 */
                Cache(masterStore: any, cachingStore: any, options: any): any;
                /**
                 * 
                 */
                DataStore(): void;
                /**
                 * 
                 */
                JsonRest(): void;
                /**
                 * 
                 */
                Memory(): void;
                /**
                 * The Observable store wrapper takes a store and sets an observe method on query()
                 * results that can be used to monitor results for changes.
                 * Observable wraps an existing store so that notifications can be made when a query
                 * is performed.
                 * 
                 * @param store             
                 */
                Observable(store: dojo.store.api.Store): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.string.html
             *
             * String utilities for Dojo
             * 
             */
            interface string_ {
                /**
                 * Pad a string to guarantee that it is at least size length by
                 * filling with the character ch at either the start or end of the
                 * string. Pads at the start, by default.
                 * 
                 * @param text the string to pad             
                 * @param size length to provide padding             
                 * @param ch               Optionalcharacter to pad, defaults to '0'             
                 * @param end               Optionaladds padding at the end if true, otherwise pads at start             
                 */
                pad(text: String, size: number, ch: String, end: boolean): number;
                /**
                 * Efficiently replicate a string n times.
                 * 
                 * @param str the string to replicate             
                 * @param num number of times to replicate the string             
                 */
                rep(str: String, num: number): String;
                /**
                 * Performs parameterized substitutions on a string. Throws an
                 * exception if any parameter is unmatched.
                 * 
                 * @param template a string with expressions in the form ${key} to be replaced or${key:format} which specifies a format function. keys are case-sensitive.             
                 * @param map hash to search for substitutions             
                 * @param transform               Optionala function to process all parameters before substitution takesplace, e.g. mylib.encodeXML             
                 * @param thisObject               Optionalwhere to look for optional format function; default to the globalnamespace             
                 */
                substitute(template: String, map: Object, transform: Function, thisObject: Object): any;
                /**
                 * Performs parameterized substitutions on a string. Throws an
                 * exception if any parameter is unmatched.
                 * 
                 * @param template a string with expressions in the form ${key} to be replaced or${key:format} which specifies a format function. keys are case-sensitive.             
                 * @param map hash to search for substitutions             
                 * @param transform               Optionala function to process all parameters before substitution takesplace, e.g. mylib.encodeXML             
                 * @param thisObject               Optionalwhere to look for optional format function; default to the globalnamespace             
                 */
                substitute(template: String, map: any[], transform: Function, thisObject: Object): any;
                /**
                 * Trims whitespace from both sides of the string
                 * This version of trim() was taken from Steven Levithan's blog.
                 * The short yet performant version of this function is dojo/_base/lang.trim(),
                 * which is part of Dojo base.  Uses String.prototype.trim instead, if available.
                 * 
                 * @param str String to be trimmed             
                 */
                trim(str: String): String;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.version.html
             *
             * Version number of the Dojo Toolkit
             * Hash about the version, including
             * 
             * major: Integer: Major version. If total version is "1.2.0beta1", will be 1
             * minor: Integer: Minor version. If total version is "1.2.0beta1", will be 2
             * patch: Integer: Patch version. If total version is "1.2.0beta1", will be 0
             * flag: String: Descriptor flag. If total version is "1.2.0beta1", will be "beta1"
             * revision: Number: The Git rev from which dojo was pulled
             * 
             */
            interface version {
                /**
                 * 
                 */
                flag: string;
                /**
                 * 
                 */
                major: number;
                /**
                 * 
                 */
                minor: number;
                /**
                 * 
                 */
                patch: number;
                /**
                 * 
                 */
                revision: number;
                /**
                 * 
                 */
                toString(): String;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.touch.html
             *
             * This module provides unified touch event handlers by exporting
             * press, move, release and cancel which can also run well on desktop.
             * Based on http://dvcs.w3.org/hg/webevents/raw-file/tip/touchevents.html
             * Also, if the dojoClick property is set to truthy on a DOM node, dojo/touch generates
             * click events immediately for this node and its descendants (except for descendants that
             * have a dojoClick property set to falsy), to avoid the delay before native browser click events,
             * and regardless of whether evt.preventDefault() was called in a touch.press event listener.
             * 
             */
            interface touch {
                /**
                 * Register a listener to 'touchcancel'|'mouseleave' for the given node
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                cancel(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener to mouse.enter or touch equivalent for the given node
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                enter(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener to mouse.leave or touch equivalent for the given node
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                leave(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener that fires when the mouse cursor or a finger is dragged over the given node.
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                move(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener to 'mouseout' or touch equivalent for the given node
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                out(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener to 'mouseover' or touch equivalent for the given node
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                over(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener to 'touchstart'|'mousedown' for the given node
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                press(node: HTMLElement, listener: Function): any;
                /**
                 * Register a listener to releasing the mouse button while the cursor is over the given node
                 * (i.e. "mouseup") or for removing the finger from the screen while touching the given node.
                 * 
                 * @param node Target node to listen to             
                 * @param listener Callback function             
                 */
                release(node: HTMLElement, listener: Function): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/_base/kernel.window.html
             *
             * TODOC
             * 
             */
            interface window {
                /**
                 * Get window object associated with document doc.
                 * 
                 * @param doc The document to get the associated window for.             
                 */
                get(doc: HTMLDocument): any;
                /**
                 * Returns the dimensions and scroll position of the viewable area of a browser window
                 * 
                 * @param doc               Optional            
                 */
                getBox(doc: HTMLDocument): Object;
                /**
                 * Scroll the passed node into view using minimal movement, if it is not already.
                 * 
                 * @param node             
                 * @param pos               Optional            
                 */
                scrollIntoView(node: HTMLElement, pos: Object): void;
            }
        }

    }

    module _firebug {
        module firebug {
        }

    }

    module cldr {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/cldr/monetary.html
         *
         * TODOC
         * 
         */
        interface monetary {
            /**
             * A mapping of currency code to currency-specific formatting information. Returns a unique object with properties: places, round.
             * 
             * @param code an ISO 4217 currency code             
             */
            getData(code: String): Object;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/cldr/supplemental.html
         *
         * TODOC
         * 
         */
        interface supplemental {
            /**
             * Returns a zero-based index for first day of the week
             * Returns a zero-based index for first day of the week, as used by the local (Gregorian) calendar.
             * e.g. Sunday (returns 0), or Monday (returns 1)
             * 
             * @param locale               Optional            
             */
            getFirstDayOfWeek(locale: String): number;
            /**
             * Returns a hash containing the start and end days of the weekend
             * Returns a hash containing the start and end days of the weekend according to local custom using locale,
             * or by default in the user's locale.
             * e.g. {start:6, end:0}
             * 
             * @param locale               Optional            
             */
            getWeekend(locale: String): Object;
        }
    }

    module data {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/ItemFileReadStore.html
         *
         * The ItemFileReadStore implements the dojo/data/api/Read API and reads
         * data from JSON files that have contents in this format --
         * 
         * { items: [
         *     { name:'Kermit', color:'green', age:12, friends:['Gonzo', {_reference:{name:'Fozzie Bear'}}]},
         *     { name:'Fozzie Bear', wears:['hat', 'tie']},
         *     { name:'Miss Piggy', pets:'Foo-Foo'}
         * ]}
         * Note that it can also contain an 'identifier' property that specified which attribute on the items
         * 
         * in the array of items that acts as the unique identifier for that item.
         * 
         * @param keywordParameters {url: String} {data: jsonObject} {typeMap: object}The structure of the typeMap object is as follows:{    type0: function || object,    type1: function || object,    ...    typeN: function || object}Where if it is a function, it is assumed to be an object constructor that takes thevalue of _value as the initialization parameters.  If it is an object, then it is assumedto be an object of general form:{    type: function, //constructor.    deserialize:    function(value) //The function that parses the value and constructs the object defined by type appropriately.}     
         */
        class ItemFileReadStore extends dojo.Evented {
            constructor(keywordParameters: Object);
            /**
             * Parameter to allow users to specify if a close call should force a reload or not.
             * By default, it retains the old behavior of not clearing if close is called.  But
             * if set true, the store will be reset to default state.  Note that by doing this,
             * all item handles will become invalid and a new fetch must be issued.
             * 
             */
            "clearOnClose": boolean;
            /**
             * 
             */
            "data": Object;
            /**
             * Parameter for specifying that it is OK for the xhrGet call to fail silently.
             * 
             */
            "failOk": boolean;
            /**
             * Parameter to indicate to process data from the url as hierarchical
             * (data items can contain other data items in js form).  Default is true
             * for backwards compatibility.  False means only root items are processed
             * as items, all child objects outside of type-mapped objects and those in
             * specific reference format, are left straight JS data objects.
             * 
             */
            "hierarchical": boolean;
            /**
             * 
             */
            "typeMap": Object;
            /**
             * 
             */
            "url": string;
            /**
             * Parameter to allow specifying if preventCache should be passed to the xhrGet call or not when loading data from a url.
             * Note this does not mean the store calls the server on each fetch, only that the data load has preventCache set as an option.
             * Added for tracker: #6072
             * 
             */
            "urlPreventCache": boolean;
            /**
             * See dojo/data/api/Read.close()
             * 
             * @param request               Optional            
             */
            close(request: dojo.data.api.Request ): void;
            /**
             * See dojo/data/api/Read.close()
             * 
             * @param request               Optional            
             */
            close(request: Object): void;
            /**
             * See dojo/data/api/Read.containsValue()
             * 
             * @param item             
             * @param attribute             
             * @param value             
             */
            containsValue(item: dojo.data.api.Item, attribute: String, value: any): any;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * The error handler when there is an error fetching items.  This function should not be called
             * directly and is used by simpleFetch.fetch().
             * 
             * @param errorData             
             * @param requestObject             
             */
            errorHandler(errorData: Object, requestObject: Object): void;
            /**
             * The simpleFetch mixin is designed to serve as a set of function(s) that can
             * be mixed into other datastore implementations to accelerate their development.
             * The simpleFetch mixin should work well for any datastore that can respond to a _fetchItems()
             * call by returning an array of all the found items that matched the query.  The simpleFetch mixin
             * is not designed to work for datastores that respond to a fetch() call by incrementally
             * loading items, or sequentially loading partial batches of the result
             * set.  For datastores that mixin simpleFetch, simpleFetch
             * implements a fetch method that automatically handles eight of the fetch()
             * arguments -- onBegin, onItem, onComplete, onError, start, count, sort and scope
             * The class mixing in simpleFetch should not implement fetch(),
             * but should instead implement a _fetchItems() method.  The _fetchItems()
             * method takes three arguments, the keywordArgs object that was passed
             * to fetch(), a callback function to be called when the result array is
             * available, and an error callback to be called if something goes wrong.
             * The _fetchItems() method should ignore any keywordArgs parameters for
             * start, count, onBegin, onItem, onComplete, onError, sort, and scope.
             * The _fetchItems() method needs to correctly handle any other keywordArgs
             * parameters, including the query parameter and any optional parameters
             * (such as includeChildren).  The _fetchItems() method should create an array of
             * result items and pass it to the fetchHandler along with the original request object --
             * or, the _fetchItems() method may, if it wants to, create an new request object
             * with other specifics about the request that are specific to the datastore and pass
             * that as the request object to the handler.
             * 
             * For more information on this specific function, see dojo/data/api/Read.fetch()
             * 
             * @param request               OptionalThe keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
             */
            fetch(request: Object): void;
            /**
             * The handler when items are sucessfully fetched.  This function should not be called directly
             * and is used by simpleFetch.fetch().
             * 
             * @param items             
             * @param requestObject             
             */
            fetchHandler(items: any[], requestObject: Object): void;
            /**
             * See dojo/data/api/Identity.fetchItemByIdentity()
             * 
             * @param keywordArgs             
             */
            fetchItemByIdentity(keywordArgs: Object): void;
            /**
             * This method handles the basic filtering needs for ItemFile* based stores.
             * 
             * @param requestArgs             
             * @param arrayOfItems             
             * @param findCallback             
             */
            filter(requestArgs: Object, arrayOfItems: any[], findCallback: Function): void;
            /**
             * See dojo/data/api/Read.getAttributes()
             * 
             * @param item             
             */
            getAttributes(item: dojo.data.api.Item): any[];
            /**
             * See dojo/data/api/Read.getFeatures()
             * 
             */
            getFeatures(): any;
            /**
             * See dojo/data/api/Identity.getIdentity()
             * 
             * @param item             
             */
            getIdentity(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Identity.getIdentityAttributes()
             * 
             * @param item             
             */
            getIdentityAttributes(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getLabel()
             * 
             * @param item             
             */
            getLabel(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getLabelAttributes()
             * 
             * @param item             
             */
            getLabelAttributes(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getValue()
             * 
             * @param item             
             * @param attribute             
             * @param defaultValue               Optional            
             */
            getValue(item: dojo.data.api.Item, attribute: String, defaultValue: any): any;
            /**
             * See dojo/data/api/Read.getValues()
             * 
             * @param item             
             * @param attribute             
             */
            getValues(item: dojo.data.api.Item, attribute: String): any;
            /**
             * See dojo/data/api/Read.hasAttribute()
             * 
             * @param item             
             * @param attribute             
             */
            hasAttribute(item: dojo.data.api.Item, attribute: String): boolean;
            /**
             * See dojo/data/api/Read.isItem()
             * 
             * @param something             
             */
            isItem(something: any): boolean;
            /**
             * See dojo/data/api/Read.isItemLoaded()
             * 
             * @param something             
             */
            isItemLoaded(something: any): any;
            /**
             * See dojo/data/api/Read.loadItem()
             * 
             * @param keywordArgs             
             */
            loadItem(keywordArgs: Object): void;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/ObjectStore.html
         *
         * A Dojo Data implementation that wraps Dojo object stores for backwards
         * compatibility.
         * 
         * @param options The configuration information to pass into the data store.options.objectStore:The object store to use as the source provider for this data store     
         */
        class ObjectStore extends dojo.Evented {
            constructor(options: any);
            /**
             * 
             */
            "labelProperty": string;
            /**
             * 
             */
            "objectStore": Object;
            /**
             * adds an object to the list of dirty objects.  This object
             * contains a reference to the object itself as well as a
             * cloned and trimmed version of old object for use with
             * revert.
             * 
             * @param object Indicates that the given object is changing and should be marked as dirty for the next save             
             * @param _deleting             
             */
            changing(object: Object, _deleting: boolean): void;
            /**
             * See dojo/data/api/Read.close()
             * 
             * @param request             
             */
            close(request: any): any;
            /**
             * Checks to see if 'item' has 'value' at 'attribute'
             * 
             * @param item The item to check             
             * @param attribute The attribute to check             
             * @param value The value to look for             
             */
            containsValue(item: Object, attribute: String, value: any): boolean;
            /**
             * deletes item and any references to that item from the store.
             * 
             * @param item item to delete             
             */
            deleteItem(item: any): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * See dojo/data/api/Read.fetch()
             * 
             * @param args             
             */
            fetch(args: any): any;
            /**
             * fetch an item by its identity, by looking in our index of what we have loaded
             * 
             * @param args             
             */
            fetchItemByIdentity(args: any): any;
            /**
             * Gets the available attributes of an item's 'property' and returns
             * it as an array.
             * 
             * @param item             
             */
            getAttributes(item: Object): any[];
            /**
             * return the store feature set
             * 
             */
            getFeatures(): Object;
            /**
             * returns the identity of the given item
             * See dojo/data/api/Read.getIdentity()
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * returns the attributes which are used to make up the
             * identity of an item.    Basically returns this.objectStore.idProperty
             * See dojo/data/api/Read.getIdentityAttributes()
             * 
             * @param item             
             */
            getIdentityAttributes(item: any): any[];
            /**
             * See dojo/data/api/Read.getLabel()
             * 
             * @param item             
             */
            getLabel(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getLabelAttributes()
             * 
             * @param item             
             */
            getLabelAttributes(item: dojo.data.api.Item): any[];
            /**
             * Gets the value of an item's 'property'
             * 
             * @param item The item to get the value from             
             * @param property property to look up value for             
             * @param defaultValue               Optionalthe default value             
             */
            getValue(item: Object, property: String, defaultValue: any): any;
            /**
             * Gets the value of an item's 'property' and returns
             * it. If this value is an array it is just returned,
             * if not, the value is added to an array and that is returned.
             * 
             * @param item             
             * @param property property to look up value for             
             */
            getValues(item: Object, property: String): any[];
            /**
             * Checks to see if item has attribute
             * 
             * @param item The item to check             
             * @param attribute The attribute to check             
             */
            hasAttribute(item: Object, attribute: String): boolean;
            /**
             * returns true if the item is marked as dirty or true if there are any dirty items
             * 
             * @param item The item to check             
             */
            isDirty(item: Object): any;
            /**
             * Checks to see if the argument is an item
             * 
             * @param item The item to check             
             */
            isItem(item: Object): boolean;
            /**
             * Checks to see if the item is loaded.
             * 
             * @param item The item to check             
             */
            isItemLoaded(item: Object): any;
            /**
             * Loads an item and calls the callback handler. Note, that this will call the callback
             * handler even if the item is loaded. Consequently, you can use loadItem to ensure
             * that an item is loaded is situations when the item may or may not be loaded yet.
             * If you access a value directly through property access, you can use this to load
             * a lazy value as well (doesn't need to be an item).
             * 
             * @param args See dojo/data/api/Read.fetch()             
             */
            loadItem(args: Object): any;
            /**
             * adds a new item to the store at the specified point.
             * Takes two parameters, data, and options.
             * 
             * @param data See dojo/data/api/Write.newItem()             
             * @param parentInfo             
             */
            newItem(data: Object, parentInfo: any): Object;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * returns any modified data to its original state prior to a save();
             * 
             */
            revert(): void;
            /**
             * Saves the dirty data using object store provider. See dojo/data/api/Write for API.
             * 
             * @param kwArgs kwArgs.global:This will cause the save to commit the dirty data for allObjectStores as a single transaction.kwArgs.revertOnError:This will cause the changes to be reverted if there is anerror on the save. By default a revert is executed unlessa value of false is provide for this parameter.kwArgs.onError:Called when an error occurs in the commitkwArgs.onComplete:Called when an the save/commit is completed             
             */
            save(kwArgs: any): void;
            /**
             * sets 'attribute' on 'item' to 'value'
             * See dojo/data/api/Write.setValue()
             * 
             * @param item             
             * @param attribute             
             * @param value             
             */
            setValue(item: any, attribute: any, value: any): void;
            /**
             * sets 'attribute' on 'item' to 'value' value
             * must be an array.
             * See dojo/data/api/Write.setValues()
             * 
             * @param item             
             * @param attribute             
             * @param values             
             */
            setValues(item: any, attribute: any, values: any): void;
            /**
             * unsets 'attribute' on 'item'
             * See dojo/data/api/Write.unsetAttribute()
             * 
             * @param item             
             * @param attribute             
             */
            unsetAttribute(item: any, attribute: any): void;
            /**
             * See dojo/data/api/Notification.onDelete()
             * 
             */
            onDelete(): void;
            /**
             * Called when a fetch occurs          
             * 
             * @param results             
             */
            onFetch(results: any): void;
            /**
             * See dojo/data/api/Notification.onNew()
             * 
             */
            onNew(): void;
            /**
             * See dojo/data/api/Notification.onSet()
             * 
             */
            onSet(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/ItemFileWriteStore.html
         *
         * TODOC
         * 
         * @param keywordParameters The structure of the typeMap object is as follows:{    type0: function || object,    type1: function || object,    ...    typeN: function || object}Where if it is a function, it is assumed to be an object constructor that takes thevalue of _value as the initialization parameters.  It is serialized assuming object.toString()serialization.  If it is an object, then it is assumedto be an object of general form:{    type: function, //constructor.    deserialize:    function(value) //The function that parses the value and constructs the object defined by type appropriately.    serialize:  function(object) //The function that converts the object back into the proper file format form.}     
         */
        class ItemFileWriteStore extends dojo.data.ItemFileReadStore {
            constructor(keywordParameters: Object);
            /**
             * Parameter to allow users to specify if a close call should force a reload or not.
             * By default, it retains the old behavior of not clearing if close is called.  But
             * if set true, the store will be reset to default state.  Note that by doing this,
             * all item handles will become invalid and a new fetch must be issued.
             * 
             */
            "clearOnClose": boolean;
            /**
             * 
             */
            "data": Object;
            /**
             * Parameter for specifying that it is OK for the xhrGet call to fail silently.
             * 
             */
            "failOk": boolean;
            /**
             * Parameter to indicate to process data from the url as hierarchical
             * (data items can contain other data items in js form).  Default is true
             * for backwards compatibility.  False means only root items are processed
             * as items, all child objects outside of type-mapped objects and those in
             * specific reference format, are left straight JS data objects.
             * 
             */
            "hierarchical": boolean;
            /**
             * 
             */
            "referenceIntegrity": boolean;
            /**
             * 
             */
            "typeMap": Object;
            /**
             * 
             */
            "url": string;
            /**
             * Parameter to allow specifying if preventCache should be passed to the xhrGet call or not when loading data from a url.
             * Note this does not mean the store calls the server on each fetch, only that the data load has preventCache set as an option.
             * Added for tracker: #6072
             * 
             */
            "urlPreventCache": boolean;
            /**
             * Over-ride of base close function of ItemFileReadStore to add in check for store state.
             * Over-ride of base close function of ItemFileReadStore to add in check for store state.
             * If the store is still dirty (unsaved changes), then an error will be thrown instead of
             * clearing the internal state for reload from the url.
             * 
             * @param request               Optional            
             */
            close(request: Object): void;
            /**
             * See dojo/data/api/Read.containsValue()
             * 
             * @param item             
             * @param attribute             
             * @param value             
             */
            containsValue(item: dojo.data.api.Item, attribute: String, value: any): any;
            /**
             * See dojo/data/api/Write.deleteItem()
             * 
             * @param item             
             */
            deleteItem(item: dojo.data.api.Item): boolean;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * The error handler when there is an error fetching items.  This function should not be called
             * directly and is used by simpleFetch.fetch().
             * 
             * @param errorData             
             * @param requestObject             
             */
            errorHandler(errorData: Object, requestObject: Object): void;
            /**
             * The simpleFetch mixin is designed to serve as a set of function(s) that can
             * be mixed into other datastore implementations to accelerate their development.
             * The simpleFetch mixin should work well for any datastore that can respond to a _fetchItems()
             * call by returning an array of all the found items that matched the query.  The simpleFetch mixin
             * is not designed to work for datastores that respond to a fetch() call by incrementally
             * loading items, or sequentially loading partial batches of the result
             * set.  For datastores that mixin simpleFetch, simpleFetch
             * implements a fetch method that automatically handles eight of the fetch()
             * arguments -- onBegin, onItem, onComplete, onError, start, count, sort and scope
             * The class mixing in simpleFetch should not implement fetch(),
             * but should instead implement a _fetchItems() method.  The _fetchItems()
             * method takes three arguments, the keywordArgs object that was passed
             * to fetch(), a callback function to be called when the result array is
             * available, and an error callback to be called if something goes wrong.
             * The _fetchItems() method should ignore any keywordArgs parameters for
             * start, count, onBegin, onItem, onComplete, onError, sort, and scope.
             * The _fetchItems() method needs to correctly handle any other keywordArgs
             * parameters, including the query parameter and any optional parameters
             * (such as includeChildren).  The _fetchItems() method should create an array of
             * result items and pass it to the fetchHandler along with the original request object --
             * or, the _fetchItems() method may, if it wants to, create an new request object
             * with other specifics about the request that are specific to the datastore and pass
             * that as the request object to the handler.
             * 
             * For more information on this specific function, see dojo/data/api/Read.fetch()
             * 
             * @param request               OptionalThe keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
             */
            fetch(request: Object): void;
            /**
             * The handler when items are sucessfully fetched.  This function should not be called directly
             * and is used by simpleFetch.fetch().
             * 
             * @param items             
             * @param requestObject             
             */
            fetchHandler(items: any[], requestObject: Object): void;
            /**
             * See dojo/data/api/Identity.fetchItemByIdentity()
             * 
             * @param keywordArgs             
             */
            fetchItemByIdentity(keywordArgs: Object): void;
            /**
             * This method handles the basic filtering needs for ItemFile* based stores.
             * 
             * @param requestArgs             
             * @param arrayOfItems             
             * @param findCallback             
             */
            filter(requestArgs: Object, arrayOfItems: any[], findCallback: Function): void;
            /**
             * See dojo/data/api/Read.getAttributes()
             * 
             * @param item             
             */
            getAttributes(item: dojo.data.api.Item): any[];
            /**
             * See dojo/data/api/Read.getFeatures()
             * 
             */
            getFeatures(): any;
            /**
             * See dojo/data/api/Identity.getIdentity()
             * 
             * @param item             
             */
            getIdentity(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Identity.getIdentityAttributes()
             * 
             * @param item             
             */
            getIdentityAttributes(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getLabel()
             * 
             * @param item             
             */
            getLabel(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getLabelAttributes()
             * 
             * @param item             
             */
            getLabelAttributes(item: dojo.data.api.Item): any;
            /**
             * See dojo/data/api/Read.getValue()
             * 
             * @param item             
             * @param attribute             
             * @param defaultValue               Optional            
             */
            getValue(item: dojo.data.api.Item, attribute: String, defaultValue: any): any;
            /**
             * See dojo/data/api/Read.getValues()
             * 
             * @param item             
             * @param attribute             
             */
            getValues(item: dojo.data.api.Item, attribute: String): any;
            /**
             * See dojo/data/api/Read.hasAttribute()
             * 
             * @param item             
             * @param attribute             
             */
            hasAttribute(item: dojo.data.api.Item, attribute: String): boolean;
            /**
             * See dojo/data/api/Write.isDirty()
             * 
             * @param item               Optional            
             */
            isDirty(item: any): any;
            /**
             * See dojo/data/api/Read.isItem()
             * 
             * @param something             
             */
            isItem(something: any): boolean;
            /**
             * See dojo/data/api/Read.isItemLoaded()
             * 
             * @param something             
             */
            isItemLoaded(something: any): any;
            /**
             * See dojo/data/api/Read.loadItem()
             * 
             * @param keywordArgs             
             */
            loadItem(keywordArgs: Object): void;
            /**
             * See dojo/data/api/Write.newItem()
             * 
             * @param keywordArgs               Optional            
             * @param parentInfo               Optional            
             */
            newItem(keywordArgs: Object, parentInfo: Object): Object;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * See dojo/data/api/Write.revert()
             * 
             */
            revert(): boolean;
            /**
             * See dojo/data/api/Write.save()
             * 
             * @param keywordArgs             
             */
            save(keywordArgs: Object): void;
            /**
             * See dojo/data/api/Write.set()
             * 
             * @param item             
             * @param attribute             
             * @param value             
             */
            setValue(item: dojo.data.api.Item, attribute: String, value: any): any;
            /**
             * See dojo/data/api/Write.setValues()
             * 
             * @param item             
             * @param attribute             
             * @param values             
             */
            setValues(item: dojo.data.api.Item, attribute: String, values: any[]): any;
            /**
             * See dojo/data/api/Write.unsetAttribute()
             * 
             * @param item             
             * @param attribute             
             */
            unsetAttribute(item: dojo.data.api.Item, attribute: String): any;
            /**
             * See dojo/data/api/Notification.onDelete()
             * 
             * @param deletedItem             
             */
            onDelete(deletedItem: dojo.data.api.Item): void;
            /**
             * See dojo/data/api/Notification.onNew()
             * 
             * @param newItem             
             * @param parentInfo               Optional            
             */
            onNew(newItem: dojo.data.api.Item, parentInfo: Object): void;
            /**
             * See dojo/data/api/Notification.onSet()
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSet(item: dojo.data.api.Item, attribute: String, oldValue: Object, newValue: Object): void;
            /**
             * See dojo/data/api/Notification.onSet()
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSet(item: dojo.data.api.Item, attribute: String, oldValue: any[], newValue: Object): void;
            /**
             * See dojo/data/api/Notification.onSet()
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSet(item: dojo.data.api.Item, attribute: String, oldValue: Object, newValue: any[]): void;
            /**
             * See dojo/data/api/Notification.onSet()
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSet(item: dojo.data.api.Item, attribute: String, oldValue: any[], newValue: any[]): void;
        }
        module api {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/api/Item.html
             *
             * An item in a dojo/data store
             * Class for documentation purposes only. An item can take any form, so no 
             * properties or methods are defined here.
             * 
             */
            class Item {
                constructor();
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/api/Identity.html
             *
             * This is an abstract API that data provider implementations conform to.
             * This file defines methods signatures and intentionally leaves all the
             * methods unimplemented.
             * 
             */
            class Identity extends dojo.data.api.Read {
                constructor();
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: dojo.data.api.Request ): void;
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: Object): void;
                /**
                 * Returns true if the given value is one of the values that getValues()
                 * would return.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param value The value to match as a value for the attribute.             
                 */
                containsValue(item: dojo.data.api.Item, attribute: String, value: any): void;
                /**
                 * Given a query and set of defined options, such as a start and count of items to return,
                 * this method executes the query and makes the results available as data items.
                 * The format and expectations of stores is that they operate in a generally asynchronous
                 * manner, therefore callbacks are always used to return items located by the fetch parameters.
                 * A Request object will always be returned and is returned immediately.
                 * The basic request is nothing more than the keyword args passed to fetch and
                 * an additional function attached, abort().  The returned request object may then be used
                 * to cancel a fetch.  All data items returns are passed through the callbacks defined in the
                 * fetch parameters and are not present on the 'request' object.
                 * 
                 * This does not mean that custom stores can not add methods and properties to the request object
                 * returned, only that the API does not require it.  For more info about the Request API,
                 * see dojo/data/api/Request
                 * 
                 * @param keywordArgs The keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
                 */
                fetch(keywordArgs: Object): any;
                /**
                 * Given the identity of an item, this method returns the item that has
                 * that identity through the onItem callback.  Conforming implementations
                 * should return null if there is no item with the given identity.
                 * Implementations of fetchItemByIdentity() may sometimes return an item
                 * from a local cache and may sometimes fetch an item from a remote server,
                 * 
                 * @param keywordArgs An anonymous object that defines the item to locate and callbacks to invoke when theitem has been located and load has completed.  The format of the object is as follows:{    identity: string|object,    onItem: Function,    onError: Function,    scope: object}The identity parameterThe identity parameter is the identity of the item you wish to locate and loadThis attribute is required.  It should be a string or an object that toString()can be called on.The onItem parameterFunction(item)The onItem parameter is the callback to invoke when the item has been loaded.  It takes only oneparameter, the item located, or null if none found.The onError parameterFunction(error)The onError parameter is the callback to invoke when the item load encountered an error.  It takes only oneparameter, the error objectThe scope parameterIf a scope object is provided, all of the callback functions (onItem,onError, etc) will be invoked in the context of the scope object.In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global.For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global, item, request)             
                 */
                fetchItemByIdentity(keywordArgs: Object): void;
                /**
                 * Returns an array with all the attributes that this item has.  This
                 * method will always return an array; if the item has no attributes
                 * at all, getAttributes() will return an empty array: [].
                 * 
                 * @param item The item to access attributes on.             
                 */
                getAttributes(item: dojo.data.api.Item): void;
                /**
                 * See dojo/data/api/Read.getFeatures()
                 * 
                 */
                getFeatures(): Object;
                /**
                 * Returns a unique identifier for an item.  The return value will be
                 * either a string or something that has a toString() method (such as,
                 * for example, a dojox/uuid object).
                 * 
                 * @param item The item from the store from which to obtain its identifier.             
                 */
                getIdentity(item: dojo.data.api.Item): void;
                /**
                 * Returns an array of attribute names that are used to generate the identity.
                 * For most stores, this is a single attribute, but for some complex stores
                 * such as RDB backed stores that use compound (multi-attribute) identifiers
                 * it can be more than one.  If the identity is not composed of attributes
                 * on the item, it will return null.  This function is intended to identify
                 * the attributes that comprise the identity so that so that during a render
                 * of all attributes, the UI can hide the the identity information if it
                 * chooses.
                 * 
                 * @param item The item from the store from which to obtain the array of public attributes thatcompose the identifier, if any.             
                 */
                getIdentityAttributes(item: dojo.data.api.Item): void;
                /**
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.  In general
                 * most labels will be a specific attribute value or collection of the attribute
                 * values that combine to label the item in some manner.  For example for an item
                 * that represents a person it may return the label as:  "firstname lastlame" where
                 * the firstname and lastname are attributes on the item.  If the store is unable
                 * to determine an adequate human readable label, it should return undefined.  Users that wish
                 * to customize how a store instance labels items should replace the getLabel() function on
                 * their instance of the store, or extend the store and replace the function in
                 * the extension class.
                 * 
                 * @param item The item to return the label for.             
                 */
                getLabel(item: dojo.data.api.Item): any;
                /**
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.  This function is to assist UI developers in knowing what
                 * attributes can be ignored out of the attributes an item has when displaying it, in cases
                 * where the UI is using the label as an overall identifer should they wish to hide
                 * redundant information.
                 * 
                 * @param item The item to return the list of label attributes for.             
                 */
                getLabelAttributes(item: dojo.data.api.Item): any;
                /**
                 * Returns a single attribute value.
                 * Returns defaultValue if and only if item does not have a value for attribute.
                 * Returns null if and only if null was explicitly set as the attribute value.
                 * Returns undefined if and only if the item does not have a value for the
                 * given attribute (which is the same as saying the item does not have the attribute).
                 * Saying that an "item x does not have a value for an attribute y"
                 * is identical to saying that an "item x does not have attribute y".
                 * It is an oxymoron to say "that attribute is present but has no values"
                 * or "the item has that attribute but does not have any attribute values".
                 * If store.hasAttribute(item, attribute) returns false, then
                 * store.getValue(item, attribute) will return undefined.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param defaultValue               OptionalOptional.  A default value to use for the getValue return in the attribute does not exist or has no value.             
                 */
                getValue(item: dojo.data.api.Item, attribute: String, defaultValue: any): any;
                /**
                 * This getValues() method works just like the getValue() method, but getValues()
                 * always returns an array rather than a single attribute value.  The array
                 * may be empty, may contain a single attribute value, or may contain
                 * many attribute values.
                 * If the item does not have a value for the given attribute, then getValues()
                 * will return an empty array: [].  (So, if store.hasAttribute(item, attribute)
                 * has a return of false, then store.getValues(item, attribute) will return [].)
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                getValues(item: dojo.data.api.Item, attribute: String): any;
                /**
                 * Returns true if the given item has a value for the given attribute.
                 * 
                 * @param item The item to access attributes on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                hasAttribute(item: dojo.data.api.Item, attribute: String): void;
                /**
                 * Returns true if something is an item and came from the store instance.
                 * Returns false if something is a literal, an item from another store instance,
                 * or is any object other than an item.
                 * 
                 * @param something Can be anything.             
                 */
                isItem(something: any): void;
                /**
                 * Returns false if isItem(something) is false.  Returns false if
                 * if isItem(something) is true but the the item is not yet loaded
                 * in local memory (for example, if the item has not yet been read
                 * from the server).
                 * 
                 * @param something Can be anything.             
                 */
                isItemLoaded(something: any): void;
                /**
                 * Given an item, this method loads the item so that a subsequent call
                 * to store.isItemLoaded(item) will return true.  If a call to
                 * isItemLoaded() returns true before loadItem() is even called,
                 * then loadItem() need not do any work at all and will not even invoke
                 * the callback handlers.  So, before invoking this method, check that
                 * the item has not already been loaded.
                 * 
                 * @param keywordArgs An anonymous object that defines the item to load and callbacks to invoke when theload has completed.  The format of the object is as follows:{    item: object,    onItem: Function,    onError: Function,    scope: object}The item parameterThe item parameter is an object that represents the item in question that should becontained by the store.  This attribute is required.The onItem parameterFunction(item)The onItem parameter is the callback to invoke when the item has been loaded.  It takes only oneparameter, the fully loaded item.The onError parameterFunction(error)The onError parameter is the callback to invoke when the item load encountered an error.  It takes only oneparameter, the error objectThe scope parameterIf a scope object is provided, all of the callback functions (onItem,onError, etc) will be invoked in the context of the scope object.In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)             
                 */
                loadItem(keywordArgs: Object): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/api/Request.html
             *
             * This class defines out the semantics of what a 'Request' object looks like
             * when returned from a fetch() method.  In general, a request object is
             * nothing more than the original keywordArgs from fetch with an abort function
             * attached to it to allow users to abort a particular request if they so choose.
             * No other functions are required on a general Request object return.  That does not
             * inhibit other store implementations from adding extensions to it, of course.
             * 
             * This is an abstract API that data provider implementations conform to.
             * This file defines methods signatures and intentionally leaves all the
             * methods unimplemented.
             * 
             * For more details on fetch, see dojo/data/api/Read.fetch().
             * 
             */
            class Request {
                constructor();
                /**
                 * This function is a hook point for stores to provide as a way for
                 * a fetch to be halted mid-processing.
                 * This function is a hook point for stores to provide as a way for
                 * a fetch to be halted mid-processing.  For more details on the fetch() api,
                 * please see dojo/data/api/Read.fetch().
                 * 
                 */
                abort(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/api/Notification.html
             *
             * This is an abstract API that data provider implementations conform to.
             * This file defines functions signatures and intentionally leaves all the
             * functions unimplemented.
             * This API defines a set of APIs that all datastores that conform to the
             * Notifications API must implement.  In general, most stores will implement
             * these APIs as no-op functions for users who wish to monitor them to be able
             * to connect to then via dojo.connect().  For non-users of dojo.connect,
             * they should be able to just replace the function on the store to obtain
             *  notifications.  Both read-only and read-write stores may implement
             * this feature.  In the case of a read-only store, this feature makes sense if
             * the store itself does internal polling to a back-end server and periodically updates
             * its cache of items (deletes, adds, and updates).
             * 
             */
            class Notification extends dojo.data.api.Read {
                constructor();
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: dojo.data.api.Request ): void;
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: Object): void;
                /**
                 * Returns true if the given value is one of the values that getValues()
                 * would return.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param value The value to match as a value for the attribute.             
                 */
                containsValue(item: dojo.data.api.Item, attribute: String, value: any): void;
                /**
                 * Given a query and set of defined options, such as a start and count of items to return,
                 * this method executes the query and makes the results available as data items.
                 * The format and expectations of stores is that they operate in a generally asynchronous
                 * manner, therefore callbacks are always used to return items located by the fetch parameters.
                 * A Request object will always be returned and is returned immediately.
                 * The basic request is nothing more than the keyword args passed to fetch and
                 * an additional function attached, abort().  The returned request object may then be used
                 * to cancel a fetch.  All data items returns are passed through the callbacks defined in the
                 * fetch parameters and are not present on the 'request' object.
                 * 
                 * This does not mean that custom stores can not add methods and properties to the request object
                 * returned, only that the API does not require it.  For more info about the Request API,
                 * see dojo/data/api/Request
                 * 
                 * @param keywordArgs The keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
                 */
                fetch(keywordArgs: Object): any;
                /**
                 * Returns an array with all the attributes that this item has.  This
                 * method will always return an array; if the item has no attributes
                 * at all, getAttributes() will return an empty array: [].
                 * 
                 * @param item The item to access attributes on.             
                 */
                getAttributes(item: dojo.data.api.Item): void;
                /**
                 * See dojo/data/api/Read.getFeatures()
                 * 
                 */
                getFeatures(): Object;
                /**
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.  In general
                 * most labels will be a specific attribute value or collection of the attribute
                 * values that combine to label the item in some manner.  For example for an item
                 * that represents a person it may return the label as:  "firstname lastlame" where
                 * the firstname and lastname are attributes on the item.  If the store is unable
                 * to determine an adequate human readable label, it should return undefined.  Users that wish
                 * to customize how a store instance labels items should replace the getLabel() function on
                 * their instance of the store, or extend the store and replace the function in
                 * the extension class.
                 * 
                 * @param item The item to return the label for.             
                 */
                getLabel(item: dojo.data.api.Item): any;
                /**
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.  This function is to assist UI developers in knowing what
                 * attributes can be ignored out of the attributes an item has when displaying it, in cases
                 * where the UI is using the label as an overall identifer should they wish to hide
                 * redundant information.
                 * 
                 * @param item The item to return the list of label attributes for.             
                 */
                getLabelAttributes(item: dojo.data.api.Item): any;
                /**
                 * Returns a single attribute value.
                 * Returns defaultValue if and only if item does not have a value for attribute.
                 * Returns null if and only if null was explicitly set as the attribute value.
                 * Returns undefined if and only if the item does not have a value for the
                 * given attribute (which is the same as saying the item does not have the attribute).
                 * Saying that an "item x does not have a value for an attribute y"
                 * is identical to saying that an "item x does not have attribute y".
                 * It is an oxymoron to say "that attribute is present but has no values"
                 * or "the item has that attribute but does not have any attribute values".
                 * If store.hasAttribute(item, attribute) returns false, then
                 * store.getValue(item, attribute) will return undefined.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param defaultValue               OptionalOptional.  A default value to use for the getValue return in the attribute does not exist or has no value.             
                 */
                getValue(item: dojo.data.api.Item, attribute: String, defaultValue: any): any;
                /**
                 * This getValues() method works just like the getValue() method, but getValues()
                 * always returns an array rather than a single attribute value.  The array
                 * may be empty, may contain a single attribute value, or may contain
                 * many attribute values.
                 * If the item does not have a value for the given attribute, then getValues()
                 * will return an empty array: [].  (So, if store.hasAttribute(item, attribute)
                 * has a return of false, then store.getValues(item, attribute) will return [].)
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                getValues(item: dojo.data.api.Item, attribute: String): any;
                /**
                 * Returns true if the given item has a value for the given attribute.
                 * 
                 * @param item The item to access attributes on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                hasAttribute(item: dojo.data.api.Item, attribute: String): void;
                /**
                 * Returns true if something is an item and came from the store instance.
                 * Returns false if something is a literal, an item from another store instance,
                 * or is any object other than an item.
                 * 
                 * @param something Can be anything.             
                 */
                isItem(something: any): void;
                /**
                 * Returns false if isItem(something) is false.  Returns false if
                 * if isItem(something) is true but the the item is not yet loaded
                 * in local memory (for example, if the item has not yet been read
                 * from the server).
                 * 
                 * @param something Can be anything.             
                 */
                isItemLoaded(something: any): void;
                /**
                 * Given an item, this method loads the item so that a subsequent call
                 * to store.isItemLoaded(item) will return true.  If a call to
                 * isItemLoaded() returns true before loadItem() is even called,
                 * then loadItem() need not do any work at all and will not even invoke
                 * the callback handlers.  So, before invoking this method, check that
                 * the item has not already been loaded.
                 * 
                 * @param keywordArgs An anonymous object that defines the item to load and callbacks to invoke when theload has completed.  The format of the object is as follows:{    item: object,    onItem: Function,    onError: Function,    scope: object}The item parameterThe item parameter is an object that represents the item in question that should becontained by the store.  This attribute is required.The onItem parameterFunction(item)The onItem parameter is the callback to invoke when the item has been loaded.  It takes only oneparameter, the fully loaded item.The onError parameterFunction(error)The onError parameter is the callback to invoke when the item load encountered an error.  It takes only oneparameter, the error objectThe scope parameterIf a scope object is provided, all of the callback functions (onItem,onError, etc) will be invoked in the context of the scope object.In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)             
                 */
                loadItem(keywordArgs: Object): void;
                /**
                 * This function is called any time an item is deleted from the store.
                 * It is called immediately after the store deleteItem processing has completed.
                 * This function is called any time an item is deleted from the store.
                 * It is called immediately after the store deleteItem processing has completed.
                 * 
                 * @param deletedItem The item deleted.             
                 */
                onDelete(deletedItem: dojo.data.api.Item): any;
                /**
                 * This function is called any time a new item is created in the store.
                 * It is called immediately after the store newItem processing has completed.
                 * This function is called any time a new item is created in the store.
                 * It is called immediately after the store newItem processing has completed.
                 * 
                 * @param newItem The item created.             
                 * @param parentInfo               OptionalAn optional javascript object that is passed when the item created was placed in the storehierarchy as a value f another item's attribute, instead of a root level item.  Note that if thisfunction is invoked with a value for parentInfo, then onSet is not invoked stating the attribute ofthe parent item was modified.  This is to avoid getting two notification  events occurring when a new itemwith a parent is created.  The structure passed in is as follows:{    item: someItem,                         //The parent item    attribute:  "attribute-name-string",    //The attribute the new item was assigned to.    oldValue: something //Whatever was the previous value for the attribute.                //If it is a single-value attribute only, then this value will be a single value.                //If it was a multi-valued attribute, then this will be an array of all the values minus the new one.    newValue: something //The new value of the attribute.  In the case of single value calls, such as setValue, this value will be                //generally be an atomic value of some sort (string, int, etc, object).  In the case of multi-valued attributes,                //it will be an array.}             
                 */
                onNew(newItem: dojo.data.api.Item, parentInfo: Object): any;
                /**
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * Its purpose is to provide a hook point for those who wish to monitor actions on items in the store
                 * in a simple manner.  The general expected usage is to dojo.connect() to the store's
                 * implementation and be called after the store function is called.
                 * 
                 * @param item The item being modified.             
                 * @param attribute The attribute being changed represented as a string name.             
                 * @param oldValue The old value of the attribute.  In the case of single value calls, such as setValue, unsetAttribute, etc,this value will be generally be an atomic value of some sort (string, int, etc, object).  In the case ofmulti-valued attributes, it will be an array.             
                 * @param newValue The new value of the attribute.  In the case of single value calls, such as setValue, this value will begenerally be an atomic value of some sort (string, int, etc, object).  In the case of multi-valued attributes,it will be an array.  In the case of unsetAttribute, the new value will be 'undefined'.             
                 */
                onSet(item: dojo.data.api.Item, attribute: String, oldValue: Object, newValue: Object): any;
                /**
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * Its purpose is to provide a hook point for those who wish to monitor actions on items in the store
                 * in a simple manner.  The general expected usage is to dojo.connect() to the store's
                 * implementation and be called after the store function is called.
                 * 
                 * @param item The item being modified.             
                 * @param attribute The attribute being changed represented as a string name.             
                 * @param oldValue The old value of the attribute.  In the case of single value calls, such as setValue, unsetAttribute, etc,this value will be generally be an atomic value of some sort (string, int, etc, object).  In the case ofmulti-valued attributes, it will be an array.             
                 * @param newValue The new value of the attribute.  In the case of single value calls, such as setValue, this value will begenerally be an atomic value of some sort (string, int, etc, object).  In the case of multi-valued attributes,it will be an array.  In the case of unsetAttribute, the new value will be 'undefined'.             
                 */
                onSet(item: dojo.data.api.Item, attribute: String, oldValue: any[], newValue: Object): any;
                /**
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * Its purpose is to provide a hook point for those who wish to monitor actions on items in the store
                 * in a simple manner.  The general expected usage is to dojo.connect() to the store's
                 * implementation and be called after the store function is called.
                 * 
                 * @param item The item being modified.             
                 * @param attribute The attribute being changed represented as a string name.             
                 * @param oldValue The old value of the attribute.  In the case of single value calls, such as setValue, unsetAttribute, etc,this value will be generally be an atomic value of some sort (string, int, etc, object).  In the case ofmulti-valued attributes, it will be an array.             
                 * @param newValue The new value of the attribute.  In the case of single value calls, such as setValue, this value will begenerally be an atomic value of some sort (string, int, etc, object).  In the case of multi-valued attributes,it will be an array.  In the case of unsetAttribute, the new value will be 'undefined'.             
                 */
                onSet(item: dojo.data.api.Item, attribute: String, oldValue: Object, newValue: any[]): any;
                /**
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc.
                 * Its purpose is to provide a hook point for those who wish to monitor actions on items in the store
                 * in a simple manner.  The general expected usage is to dojo.connect() to the store's
                 * implementation and be called after the store function is called.
                 * 
                 * @param item The item being modified.             
                 * @param attribute The attribute being changed represented as a string name.             
                 * @param oldValue The old value of the attribute.  In the case of single value calls, such as setValue, unsetAttribute, etc,this value will be generally be an atomic value of some sort (string, int, etc, object).  In the case ofmulti-valued attributes, it will be an array.             
                 * @param newValue The new value of the attribute.  In the case of single value calls, such as setValue, this value will begenerally be an atomic value of some sort (string, int, etc, object).  In the case of multi-valued attributes,it will be an array.  In the case of unsetAttribute, the new value will be 'undefined'.             
                 */
                onSet(item: dojo.data.api.Item, attribute: String, oldValue: any[], newValue: any[]): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/api/Read.html
             *
             * This is an abstract API that data provider implementations conform to.
             * This file defines methods signatures and intentionally leaves all the
             * methods unimplemented.  For more information on the dojo.data APIs,
             * please visit: http://www.dojotoolkit.org/node/98
             * 
             */
            class Read {
                constructor();
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: dojo.data.api.Request ): void;
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: Object): void;
                /**
                 * Returns true if the given value is one of the values that getValues()
                 * would return.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param value The value to match as a value for the attribute.             
                 */
                containsValue(item: dojo.data.api.Item, attribute: String, value: any): void;
                /**
                 * Given a query and set of defined options, such as a start and count of items to return,
                 * this method executes the query and makes the results available as data items.
                 * The format and expectations of stores is that they operate in a generally asynchronous
                 * manner, therefore callbacks are always used to return items located by the fetch parameters.
                 * A Request object will always be returned and is returned immediately.
                 * The basic request is nothing more than the keyword args passed to fetch and
                 * an additional function attached, abort().  The returned request object may then be used
                 * to cancel a fetch.  All data items returns are passed through the callbacks defined in the
                 * fetch parameters and are not present on the 'request' object.
                 * 
                 * This does not mean that custom stores can not add methods and properties to the request object
                 * returned, only that the API does not require it.  For more info about the Request API,
                 * see dojo/data/api/Request
                 * 
                 * @param keywordArgs The keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
                 */
                fetch(keywordArgs: Object): any;
                /**
                 * Returns an array with all the attributes that this item has.  This
                 * method will always return an array; if the item has no attributes
                 * at all, getAttributes() will return an empty array: [].
                 * 
                 * @param item The item to access attributes on.             
                 */
                getAttributes(item: dojo.data.api.Item): void;
                /**
                 * The getFeatures() method returns an simple keyword values object
                 * that specifies what interface features the datastore implements.
                 * A simple CsvStore may be read-only, and the only feature it
                 * implements will be the 'dojo/data/api/Read' interface, so the
                 * getFeatures() method will return an object like this one:
                 * {'dojo.data.api.Read': true}.
                 * A more sophisticated datastore might implement a variety of
                 * interface features, like 'dojo.data.api.Read', 'dojo/data/api/Write',
                 * 'dojo.data.api.Identity', and 'dojo/data/api/Attribution'.
                 * 
                 */
                getFeatures(): Object;
                /**
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.  In general
                 * most labels will be a specific attribute value or collection of the attribute
                 * values that combine to label the item in some manner.  For example for an item
                 * that represents a person it may return the label as:  "firstname lastlame" where
                 * the firstname and lastname are attributes on the item.  If the store is unable
                 * to determine an adequate human readable label, it should return undefined.  Users that wish
                 * to customize how a store instance labels items should replace the getLabel() function on
                 * their instance of the store, or extend the store and replace the function in
                 * the extension class.
                 * 
                 * @param item The item to return the label for.             
                 */
                getLabel(item: dojo.data.api.Item): any;
                /**
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.  This function is to assist UI developers in knowing what
                 * attributes can be ignored out of the attributes an item has when displaying it, in cases
                 * where the UI is using the label as an overall identifer should they wish to hide
                 * redundant information.
                 * 
                 * @param item The item to return the list of label attributes for.             
                 */
                getLabelAttributes(item: dojo.data.api.Item): any;
                /**
                 * Returns a single attribute value.
                 * Returns defaultValue if and only if item does not have a value for attribute.
                 * Returns null if and only if null was explicitly set as the attribute value.
                 * Returns undefined if and only if the item does not have a value for the
                 * given attribute (which is the same as saying the item does not have the attribute).
                 * Saying that an "item x does not have a value for an attribute y"
                 * is identical to saying that an "item x does not have attribute y".
                 * It is an oxymoron to say "that attribute is present but has no values"
                 * or "the item has that attribute but does not have any attribute values".
                 * If store.hasAttribute(item, attribute) returns false, then
                 * store.getValue(item, attribute) will return undefined.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param defaultValue               OptionalOptional.  A default value to use for the getValue return in the attribute does not exist or has no value.             
                 */
                getValue(item: dojo.data.api.Item, attribute: String, defaultValue: any): any;
                /**
                 * This getValues() method works just like the getValue() method, but getValues()
                 * always returns an array rather than a single attribute value.  The array
                 * may be empty, may contain a single attribute value, or may contain
                 * many attribute values.
                 * If the item does not have a value for the given attribute, then getValues()
                 * will return an empty array: [].  (So, if store.hasAttribute(item, attribute)
                 * has a return of false, then store.getValues(item, attribute) will return [].)
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                getValues(item: dojo.data.api.Item, attribute: String): any;
                /**
                 * Returns true if the given item has a value for the given attribute.
                 * 
                 * @param item The item to access attributes on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                hasAttribute(item: dojo.data.api.Item, attribute: String): void;
                /**
                 * Returns true if something is an item and came from the store instance.
                 * Returns false if something is a literal, an item from another store instance,
                 * or is any object other than an item.
                 * 
                 * @param something Can be anything.             
                 */
                isItem(something: any): void;
                /**
                 * Returns false if isItem(something) is false.  Returns false if
                 * if isItem(something) is true but the the item is not yet loaded
                 * in local memory (for example, if the item has not yet been read
                 * from the server).
                 * 
                 * @param something Can be anything.             
                 */
                isItemLoaded(something: any): void;
                /**
                 * Given an item, this method loads the item so that a subsequent call
                 * to store.isItemLoaded(item) will return true.  If a call to
                 * isItemLoaded() returns true before loadItem() is even called,
                 * then loadItem() need not do any work at all and will not even invoke
                 * the callback handlers.  So, before invoking this method, check that
                 * the item has not already been loaded.
                 * 
                 * @param keywordArgs An anonymous object that defines the item to load and callbacks to invoke when theload has completed.  The format of the object is as follows:{    item: object,    onItem: Function,    onError: Function,    scope: object}The item parameterThe item parameter is an object that represents the item in question that should becontained by the store.  This attribute is required.The onItem parameterFunction(item)The onItem parameter is the callback to invoke when the item has been loaded.  It takes only oneparameter, the fully loaded item.The onError parameterFunction(error)The onError parameter is the callback to invoke when the item load encountered an error.  It takes only oneparameter, the error objectThe scope parameterIf a scope object is provided, all of the callback functions (onItem,onError, etc) will be invoked in the context of the scope object.In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)             
                 */
                loadItem(keywordArgs: Object): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/api/Write.html
             *
             * This is an abstract API that data provider implementations conform to.
             * This file defines function signatures and intentionally leaves all the
             * functions unimplemented.
             * 
             */
            class Write extends dojo.data.api.Read {
                constructor();
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: dojo.data.api.Request ): void;
                /**
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.
                 * The close() method is intended for instructing the store to 'close' out
                 * any information associated with a particular request.  In general, this API
                 * expects to receive as a parameter a request object returned from a fetch.
                 * It will then close out anything associated with that request, such as
                 * clearing any internal datastore caches and closing any 'open' connections.
                 * For some store implementations, this call may be a no-op.
                 * 
                 * @param request               OptionalAn instance of a request for the store to use to identify what to close out.If no request is passed, then the store should clear all internal caches (if any)and close out all 'open' connections.  It does not render the store unusable fromthere on, it merely cleans out any current data and resets the store to initialstate.             
                 */
                close(request: Object): void;
                /**
                 * Returns true if the given value is one of the values that getValues()
                 * would return.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param value The value to match as a value for the attribute.             
                 */
                containsValue(item: dojo.data.api.Item, attribute: String, value: any): void;
                /**
                 * Deletes an item from the store.
                 * 
                 * @param item The item to delete.             
                 */
                deleteItem(item: dojo.data.api.Item): void;
                /**
                 * Given a query and set of defined options, such as a start and count of items to return,
                 * this method executes the query and makes the results available as data items.
                 * The format and expectations of stores is that they operate in a generally asynchronous
                 * manner, therefore callbacks are always used to return items located by the fetch parameters.
                 * A Request object will always be returned and is returned immediately.
                 * The basic request is nothing more than the keyword args passed to fetch and
                 * an additional function attached, abort().  The returned request object may then be used
                 * to cancel a fetch.  All data items returns are passed through the callbacks defined in the
                 * fetch parameters and are not present on the 'request' object.
                 * 
                 * This does not mean that custom stores can not add methods and properties to the request object
                 * returned, only that the API does not require it.  For more info about the Request API,
                 * see dojo/data/api/Request
                 * 
                 * @param keywordArgs The keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
                 */
                fetch(keywordArgs: Object): any;
                /**
                 * Returns an array with all the attributes that this item has.  This
                 * method will always return an array; if the item has no attributes
                 * at all, getAttributes() will return an empty array: [].
                 * 
                 * @param item The item to access attributes on.             
                 */
                getAttributes(item: dojo.data.api.Item): void;
                /**
                 * See dojo/data/api/Read.getFeatures()
                 * 
                 */
                getFeatures(): Object;
                /**
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.
                 * Method to inspect the item and return a user-readable 'label' for the item
                 * that provides a general/adequate description of what the item is.  In general
                 * most labels will be a specific attribute value or collection of the attribute
                 * values that combine to label the item in some manner.  For example for an item
                 * that represents a person it may return the label as:  "firstname lastlame" where
                 * the firstname and lastname are attributes on the item.  If the store is unable
                 * to determine an adequate human readable label, it should return undefined.  Users that wish
                 * to customize how a store instance labels items should replace the getLabel() function on
                 * their instance of the store, or extend the store and replace the function in
                 * the extension class.
                 * 
                 * @param item The item to return the label for.             
                 */
                getLabel(item: dojo.data.api.Item): any;
                /**
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.
                 * Method to inspect the item and return an array of what attributes of the item were used
                 * to generate its label, if any.  This function is to assist UI developers in knowing what
                 * attributes can be ignored out of the attributes an item has when displaying it, in cases
                 * where the UI is using the label as an overall identifer should they wish to hide
                 * redundant information.
                 * 
                 * @param item The item to return the list of label attributes for.             
                 */
                getLabelAttributes(item: dojo.data.api.Item): any;
                /**
                 * Returns a single attribute value.
                 * Returns defaultValue if and only if item does not have a value for attribute.
                 * Returns null if and only if null was explicitly set as the attribute value.
                 * Returns undefined if and only if the item does not have a value for the
                 * given attribute (which is the same as saying the item does not have the attribute).
                 * Saying that an "item x does not have a value for an attribute y"
                 * is identical to saying that an "item x does not have attribute y".
                 * It is an oxymoron to say "that attribute is present but has no values"
                 * or "the item has that attribute but does not have any attribute values".
                 * If store.hasAttribute(item, attribute) returns false, then
                 * store.getValue(item, attribute) will return undefined.
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 * @param defaultValue               OptionalOptional.  A default value to use for the getValue return in the attribute does not exist or has no value.             
                 */
                getValue(item: dojo.data.api.Item, attribute: String, defaultValue: any): any;
                /**
                 * This getValues() method works just like the getValue() method, but getValues()
                 * always returns an array rather than a single attribute value.  The array
                 * may be empty, may contain a single attribute value, or may contain
                 * many attribute values.
                 * If the item does not have a value for the given attribute, then getValues()
                 * will return an empty array: [].  (So, if store.hasAttribute(item, attribute)
                 * has a return of false, then store.getValues(item, attribute) will return [].)
                 * 
                 * @param item The item to access values on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                getValues(item: dojo.data.api.Item, attribute: String): any;
                /**
                 * Returns true if the given item has a value for the given attribute.
                 * 
                 * @param item The item to access attributes on.             
                 * @param attribute The attribute to access represented as a string.             
                 */
                hasAttribute(item: dojo.data.api.Item, attribute: String): void;
                /**
                 * Given an item, isDirty() returns true if the item has been modified
                 * since the last save().  If isDirty() is called with no item argument,
                 * then this function returns true if any item has been modified since
                 * the last save().
                 * 
                 * @param item               OptionalThe item to check.             
                 */
                isDirty(item: any): void;
                /**
                 * Returns true if something is an item and came from the store instance.
                 * Returns false if something is a literal, an item from another store instance,
                 * or is any object other than an item.
                 * 
                 * @param something Can be anything.             
                 */
                isItem(something: any): void;
                /**
                 * Returns false if isItem(something) is false.  Returns false if
                 * if isItem(something) is true but the the item is not yet loaded
                 * in local memory (for example, if the item has not yet been read
                 * from the server).
                 * 
                 * @param something Can be anything.             
                 */
                isItemLoaded(something: any): void;
                /**
                 * Given an item, this method loads the item so that a subsequent call
                 * to store.isItemLoaded(item) will return true.  If a call to
                 * isItemLoaded() returns true before loadItem() is even called,
                 * then loadItem() need not do any work at all and will not even invoke
                 * the callback handlers.  So, before invoking this method, check that
                 * the item has not already been loaded.
                 * 
                 * @param keywordArgs An anonymous object that defines the item to load and callbacks to invoke when theload has completed.  The format of the object is as follows:{    item: object,    onItem: Function,    onError: Function,    scope: object}The item parameterThe item parameter is an object that represents the item in question that should becontained by the store.  This attribute is required.The onItem parameterFunction(item)The onItem parameter is the callback to invoke when the item has been loaded.  It takes only oneparameter, the fully loaded item.The onError parameterFunction(error)The onError parameter is the callback to invoke when the item load encountered an error.  It takes only oneparameter, the error objectThe scope parameterIf a scope object is provided, all of the callback functions (onItem,onError, etc) will be invoked in the context of the scope object.In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)             
                 */
                loadItem(keywordArgs: Object): void;
                /**
                 * Returns a newly created item.  Sets the attributes of the new
                 * item based on the keywordArgs provided.  In general, the attribute
                 * names in the keywords become the attributes in the new item and as for
                 * the attribute values in keywordArgs, they become the values of the attributes
                 * in the new item.  In addition, for stores that support hierarchical item
                 * creation, an optional second parameter is accepted that defines what item is the parent
                 * of the new item and what attribute of that item should the new item be assigned to.
                 * In general, this will assume that the attribute targeted is multi-valued and a new item
                 * is appended onto the list of values for that attribute.
                 * 
                 * @param keywordArgs               OptionalA javascript object defining the initial content of the item as a set of JavaScript 'property name: value' pairs.             
                 * @param parentInfo               OptionalAn optional javascript object defining what item is the parent of this item (in a hierarchical store.  Not all stores do hierarchical items),and what attribute of that parent to assign the new item to.  If this is present, and the attribute specifiedis a multi-valued attribute, it will append this item into the array of values for that attribute.  The structureof the object is as follows:{    parent: someItem,    attribute: "attribute-name-string"}             
                 */
                newItem(keywordArgs: Object, parentInfo: Object): void;
                /**
                 * Discards any unsaved changes.
                 * Discards any unsaved changes.
                 * 
                 */
                revert(): void;
                /**
                 * Saves to the server all the changes that have been made locally.
                 * The save operation may take some time and is generally performed
                 * in an asynchronous fashion.  The outcome of the save action is
                 * is passed into the set of supported callbacks for the save.
                 * 
                 * @param keywordArgs {    onComplete: function    onError: function    scope: object} ####The *onComplete* parameter. function(); If an onComplete callback function is provided, the callback function will be called just once, after the save has completed.  No parameters are generally passed to the onComplete. ####The *onError* parameter. function(errorData); If an onError callback function is provided, the callback function will be called if there is any sort of error while attempting to execute the save.  The onError function will be based one parameter, the error. ####The *scope* parameter. If a scope object is provided, all of the callback function ( onComplete, onError, etc) will be invoked in the context of the scope object.  In the body of the callback function, the value of the "this" keyword will be the scope object.   If no scope object is provided, the callback functions will be called in the context of dojo.global. For example, onComplete.call(scope) vs. onComplete.call(dojo.global)             
                 */
                save(keywordArgs: Object): any;
                /**
                 * Sets the value of an attribute on an item.
                 * Replaces any previous value or values.
                 * 
                 * @param item The item to modify.             
                 * @param attribute The attribute of the item to change represented as a string name.             
                 * @param value The value to assign to the item.             
                 */
                setValue(item: dojo.data.api.Item, attribute: String, value: any): void;
                /**
                 * Adds each value in the values array as a value of the given
                 * attribute on the given item.
                 * Replaces any previous value or values.
                 * Calling store.setValues(x, y, []) (with values as an empty array) has
                 * the same effect as calling store.unsetAttribute(x, y).
                 * 
                 * @param item The item to modify.             
                 * @param attribute The attribute of the item to change represented as a string name.             
                 * @param values An array of values to assign to the attribute..             
                 */
                setValues(item: dojo.data.api.Item, attribute: String, values: any[]): void;
                /**
                 * Deletes all the values of an attribute on an item.
                 * 
                 * @param item The item to modify.             
                 * @param attribute The attribute of the item to unset represented as a string.             
                 */
                unsetAttribute(item: dojo.data.api.Item, attribute: String): void;
            }
        }

        module util {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/util/filter.html
             *
             * 
             */
            interface filter {
                /**
                 * Helper function to convert a simple pattern to a regular expression for matching.
                 * Returns a regular expression object that conforms to the defined conversion rules.
                 * For example:
                 * 
                 * ca   -> /^ca.$/
                 * ca  -> /^.ca.$/
                 * c\a  -> /^.c*a.*$/
                 * c\a?  -> /^.c*a..*$/
                 * and so on.
                 * 
                 * @param pattern A simple matching pattern to convert that follows basic rules:Means match anything, so ca* means match anything starting with ca? Means match single character.  So, b?b will match to bob and bab, and so on.\ is an escape character.  So for example, * means do not treat  as a match, but literal character .To use a \ as a character in the string, it must be escaped.  So in the pattern it should berepresented by \ to be treated as an ordinary \ character instead of an escape.             
                 * @param ignoreCase               OptionalAn optional flag to indicate if the pattern matching should be treated as case-sensitive or not when comparingBy default, it is assumed case sensitive.             
                 */
                patternToRegExp(pattern: String, ignoreCase: boolean): any;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/util/simpleFetch.html
             *
             * 
             */
            interface simpleFetch {
                /**
                 * The error handler when there is an error fetching items.  This function should not be called
                 * directly and is used by simpleFetch.fetch().
                 * 
                 * @param errorData             
                 * @param requestObject             
                 */
                errorHandler(errorData: Object, requestObject: Object): void;
                /**
                 * The simpleFetch mixin is designed to serve as a set of function(s) that can
                 * be mixed into other datastore implementations to accelerate their development.
                 * The simpleFetch mixin should work well for any datastore that can respond to a _fetchItems()
                 * call by returning an array of all the found items that matched the query.  The simpleFetch mixin
                 * is not designed to work for datastores that respond to a fetch() call by incrementally
                 * loading items, or sequentially loading partial batches of the result
                 * set.  For datastores that mixin simpleFetch, simpleFetch
                 * implements a fetch method that automatically handles eight of the fetch()
                 * arguments -- onBegin, onItem, onComplete, onError, start, count, sort and scope
                 * The class mixing in simpleFetch should not implement fetch(),
                 * but should instead implement a _fetchItems() method.  The _fetchItems()
                 * method takes three arguments, the keywordArgs object that was passed
                 * to fetch(), a callback function to be called when the result array is
                 * available, and an error callback to be called if something goes wrong.
                 * The _fetchItems() method should ignore any keywordArgs parameters for
                 * start, count, onBegin, onItem, onComplete, onError, sort, and scope.
                 * The _fetchItems() method needs to correctly handle any other keywordArgs
                 * parameters, including the query parameter and any optional parameters
                 * (such as includeChildren).  The _fetchItems() method should create an array of
                 * result items and pass it to the fetchHandler along with the original request object --
                 * or, the _fetchItems() method may, if it wants to, create an new request object
                 * with other specifics about the request that are specific to the datastore and pass
                 * that as the request object to the handler.
                 * 
                 * For more information on this specific function, see dojo/data/api/Read.fetch()
                 * 
                 * @param request               OptionalThe keywordArgs parameter may either be an instance ofconforming to dojo/data/api/Request or may be a simple anonymous objectthat may contain any of the following:{    query: query-object or query-string,    queryOptions: object,    onBegin: Function,    onItem: Function,    onComplete: Function,    onError: Function,    scope: object,    start: int    count: int    sort: array}All implementations should accept keywordArgs objects with any ofthe 9 standard properties: query, onBegin, onItem, onComplete, onErrorscope, sort, start, and count.  Some implementations may accept additionalproperties in the keywordArgs object as valid parameters, such as{includeOutliers:true}.The query parameterThe query may be optional in some data store implementations.The dojo/data/api/Read API does not specify the syntax or semanticsof the query itself -- each different data store implementationmay have its own notion of what a query should look like.However, as of dojo 0.9, 1.0, and 1.1, all the provided datastores in dojo.dataand dojox.data support an object structure query, where the object is a set ofname/value parameters such as { attrFoo: valueBar, attrFoo1: valueBar1}.  Most of thedijit widgets, such as ComboBox assume this to be the case when working with a datastorewhen they dynamically update the query.  Therefore, for maximum compatibility with dijitwidgets the recommended query parameter is a key/value object.  That does not mean that thethe datastore may not take alternative query forms, such as a simple string, a Date, a number,or a mix of such.  Ultimately, The dojo/data/api/Read API is agnostic about what the queryformat.Further note:  In general for query objects that accept strings as attributevalue matches, the store should also support basic filtering capability, such as (match any character) and ? (match single character).  An example query that is a query objectwould be like: { attrFoo: "value"}.  Which generally means match all items where they havean attribute named attrFoo, with a value that starts with 'value'.The queryOptions parameterThe queryOptions parameter is an optional parameter used to specify options that may modifythe query in some fashion, such as doing a case insensitive search, or doing a deep searchwhere all items in a hierarchical representation of data are scanned instead of just the rootitems.  It currently defines two options that all datastores should attempt to honor if possible:{    ignoreCase: boolean, // Whether or not the query should match case sensitively or not.  Default behaviour is false.    deep: boolean   // Whether or not a fetch should do a deep search of items and all child                    // items instead of just root-level items in a datastore.  Default is false.}The onBegin parameter.function(size, request);If an onBegin callback function is provided, the callback functionwill be called just once, before the first onItem callback is called.The onBegin callback function will be passed two arguments, thethe total number of items identified and the Request object.  If the total number isunknown, then size will be -1.  Note that size is not necessarily the size of thecollection of items returned from the query, as the request may have specified to return only asubset of the total set of items through the use of the start and count parameters.The onItem parameter.function(item, request);If an onItem callback function is provided, the callback functionwill be called as each item in the result is received. The callbackfunction will be passed two arguments: the item itself, and theRequest object.The onComplete parameter.function(items, request);If an onComplete callback function is provided, the callback functionwill be called just once, after the last onItem callback is called.Note that if the onItem callback is not present, then onComplete will be passedan array containing all items which matched the query and the request object.If the onItem callback is present, then onComplete is called as:onComplete(null, request).The onError parameter.function(errorData, request);If an onError callback function is provided, the callback functionwill be called if there is any sort of error while attempting toexecute the query.The onError callback function will be passed two arguments:an Error object and the Request object.The scope parameter.If a scope object is provided, all of the callback functions (onItem,onComplete, onError, etc) will be invoked in the context of the scopeobject.  In the body of the callback function, the value of the "this"keyword will be the scope object.   If no scope object is provided,the callback functions will be called in the context of dojo.global().For example, onItem.call(scope, item, request) vs.onItem.call(dojo.global(), item, request)The start parameter.If a start parameter is specified, this is a indication to the datastore toonly start returning items once the start number of items have been located andskipped.  When this parameter is paired with 'count', the store should be ableto page across queries with millions of hits by only returning subsets of thehits for each queryThe count parameter.If a count parameter is specified, this is a indication to the datastore toonly return up to that many items.  This allows a fetch call that may havemillions of item matches to be paired down to something reasonable.The sort parameter.If a sort parameter is specified, this is a indication to the datastore tosort the items in some manner before returning the items.  The array is an array ofjavascript objects that must conform to the following format to be applied to thefetching of items:{    attribute: attribute || attribute-name-string,    descending: true|false;   // Optional.  Default is false.}Note that when comparing attributes, if an item contains no value for the attribute(undefined), then it the default ascending sort logic should push it to the bottomof the list.  In the descending order case, it such items should appear at the top of the list.             
                 */
                fetch(request: Object): void;
                /**
                 * The handler when items are sucessfully fetched.  This function should not be called directly
                 * and is used by simpleFetch.fetch().
                 * 
                 * @param items             
                 * @param requestObject             
                 */
                fetchHandler(items: any[], requestObject: Object): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/data/util/sorter.html
             *
             * 
             */
            interface sorter {
                /**
                 * Basic comparison function that compares if an item is greater or less than another item
                 * returns 1 if a > b, -1 if a < b, 0 if equal.
                 * 'null' values (null, undefined) are treated as larger values so that they're pushed to the end of the list.
                 * And compared to each other, null is equivalent to undefined.
                 * 
                 * @param a             
                 * @param b             
                 */
                basicComparator(a: any, b: any): number;
                /**
                 * Helper function to generate the sorting function based off the list of sort attributes.
                 * The sort function creation will look for a property on the store called 'comparatorMap'.  If it exists
                 * it will look in the mapping for comparisons function for the attributes.  If one is found, it will
                 * use it instead of the basic comparator, which is typically used for strings, ints, booleans, and dates.
                 * Returns the sorting function for this particular list of attributes and sorting directions.
                 * 
                 * @param sortSpec A JS object that array that defines out what attribute names to sort on and whether it should be descenting or asending.The objects should be formatted as follows:{    attribute: "attributeName-string" || attribute,    descending: true|false;   // Default is false.}             
                 * @param store The datastore object to look up item values from.             
                 */
                createSortFunction(sortSpec: Object, store: dojo.data.api.Read): String[];
            }
        }

    }

    module dnd {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Avatar.html
         *
         * Object that represents transferred DnD items visually
         * 
         * @param manager     
         */
        class Avatar {
            constructor(manager: any);
            /**
             * a DnD manager object
             * 
             */
            "manager": Object;
            /**
             * constructor function;
             * it is separate so it can be (dynamically) overwritten in case of need
             * 
             */
            construct(): void;
            /**
             * destructor for the avatar; called to remove all references so it can be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * updates the avatar to reflect the current DnD state
             * 
             */
            update(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Manager.html
         *
         * the manager of DnD operations (usually a singleton)
         * 
         */
        class Manager extends dojo.Evented {
            constructor();
            /**
             * 
             */
            "OFFSET_X": number;
            /**
             * 
             */
            "OFFSET_Y": number;
            /**
             * called to notify if the current target can accept items
             * 
             * @param flag             
             */
            canDrop(flag: any): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * makes the avatar; it is separate to be overwritten dynamically, if needed
             * 
             */
            makeAvatar(): any;
            /**
             * Returns the current DnD manager.  Creates one if it is not created yet.
             * 
             */
            manager(): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * called when a source detected a mouse-out condition
             * 
             * @param source the reporter             
             */
            outSource(source: Object): void;
            /**
             * called when a source detected a mouse-over condition
             * 
             * @param source the reporter             
             */
            overSource(source: Object): void;
            /**
             * called to initiate the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            startDrag(source: Object, nodes: any[], copy: boolean): void;
            /**
             * stop the DnD in progress
             * 
             */
            stopDrag(): void;
            /**
             * updates the avatar; it is separate to be overwritten dynamically, if needed
             * 
             */
            updateAvatar(): void;
            /**
             * event processor for onkeydown:
             * watching for CTRL for copy/move status, watching for ESCAPE to cancel the drag
             * 
             * @param e keyboard event             
             */
            onKeyDown(e: Event): void;
            /**
             * event processor for onkeyup, watching for CTRL for copy/move status
             * 
             * @param e keyboard event             
             */
            onKeyUp(e: Event): void;
            /**
             * event processor for onmousemove
             * 
             * @param e mouse event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseup
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Container.html
         *
         * a Container object, which knows when mouse hovers over it,
         * and over which element it hovers
         * 
         * @param node node or node's id to build the container on     
         * @param params a dictionary of parameters     
         */
        class Container extends dojo.Evented {
            constructor(node: HTMLElement, params: Object);
            /**
             * Indicates whether to allow dnd item nodes to be nested within other elements.
             * By default this is false, indicating that only direct children of the container can
             * be draggable dnd item nodes
             * 
             */
            "allowNested": boolean;
            /**
             * The DOM node the mouse is currently hovered over
             * 
             */
            "current": HTMLElement;
            /**
             * Map from an item's id (which is also the DOMNode's id) to
             * the dojo/dnd/Container.Item itself.
             * 
             */
            "map": Object;

            node: HTMLElement;
            /**
             * 
             */
            "skipForm": boolean;
            /**
             * removes all data items from the map
             * 
             */
            clearItems(): void;
            /**
             * creator function, dummy at the moment
             * 
             */
            creator(): void;
            /**
             * removes a data item from the map by its key (id)
             * 
             * @param key             
             */
            delItem(key: String): void;
            /**
             * prepares this object to be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * iterates over a data map skipping members that
             * are present in the empty object (IE and/or 3rd-party libraries).
             * 
             * @param f             
             * @param o               Optional            
             */
            forInItems(f: Function, o: Object): String;
            /**
             * returns a list (an array) of all valid child nodes
             * 
             */
            getAllNodes(): any;
            /**
             * returns a data item by its key (id)
             * 
             * @param key             
             */
            getItem(key: String): any;
            /**
             * inserts an array of new nodes before/after an anchor node
             * 
             * @param data Logical representation of the object being dragged.If the drag object's type is "text" then data is a String,if it's another type then data could be a different Object,perhaps a name/value hash.             
             * @param before insert before the anchor, if true, and after the anchor otherwise             
             * @param anchor the anchor node to be used as a point of insertion             
             */
            insertNodes(addSelected?: boolean, data?: any[], before?: boolean, anchor?: HTMLElement): Function;
            /**
             * Represents (one of) the source node(s) being dragged.
             * Contains (at least) the "type" and "data" attributes.
             * 
             */
            Item(): void;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * associates a data item with its key (id)
             * 
             * @param key             
             * @param data             
             */
            setItem(key: String, data: any): void;
            /**
             * collects valid child items and populate the map
             * 
             */
            startup(): void;
            /**
             * sync up the node list with the data map
             * 
             */
            sync(): Function;
            /**
             * event processor for onmouseout
             * 
             * @param e mouse event             
             */
            onMouseOut(e: Event): void;
            /**
             * event processor for onmouseover or touch, to mark that element as the current element
             * 
             * @param e mouse event             
             */
            onMouseOver(e: Event): void;
            /**
             * this function is called once, when mouse is out of our container
             * 
             */
            onOutEvent(): void;
            /**
             * this function is called once, when mouse is over our container
             * 
             */
            onOverEvent(): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        module Container {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Container.__ContainerArgs.html
             *
             * 
             */
            class __ContainerArgs {
                constructor();
                /**
                 * node or node's id to use as the parent node for dropped items
                 * (must be underneath the 'node' parameter in the DOM)
                 * 
                 */
                "dropParent": HTMLElement;
                /**
                 * don't start the drag operation, if clicked on form elements
                 * 
                 */
                "skipForm": boolean;
                /**
                 * a creator function, which takes a data item, and returns an object like that:
                 * {node: newNode, data: usedData, type: arrayOfStrings}
                 * 
                 */
                creator(): void;


            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/AutoSource.html
         *
         * a source that syncs its DnD nodes by default
         * 
         * @param node     
         * @param params     
         */
        class AutoSource extends dojo.dnd.Source {
            constructor(node: any, params: any);
            /**
             * 
             */
            "accept": any[];
            /**
             * Indicates whether to allow dnd item nodes to be nested within other elements.
             * By default this is false, indicating that only direct children of the container can
             * be draggable dnd item nodes
             * 
             */
            "allowNested": boolean;
            /**
             * 
             */
            "autoSync": boolean;
            /**
             * 
             */
            "copyOnly": boolean;
            /**
             * The DOM node the mouse is currently hovered over
             * 
             */
            "current": HTMLElement;
            /**
             * 
             */
            "delay": number;
            /**
             * 
             */
            "generateText": boolean;
            /**
             * 
             */
            "horizontal": boolean;
            /**
             * 
             */
            "isSource": boolean;
            /**
             * Map from an item's id (which is also the DOMNode's id) to
             * the dojo/dnd/Container.Item itself.
             * 
             */
            "map": Object;
            /**
             * The set of id's that are currently selected, such that this.selection[id] == 1
             * if the node w/that id is selected.  Can iterate over selected node's id's like:
             * 
             * for(var id in this.selection)
             * 
             */
            "selection": Object;
            /**
             * 
             */
            "selfAccept": boolean;
            /**
             * 
             */
            "selfCopy": boolean;
            /**
             * 
             */
            "singular": boolean;
            /**
             * 
             */
            "skipForm": boolean;
            /**
             * 
             */
            "withHandles": boolean;
            /**
             * checks if the target can accept nodes from this source
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             */
            checkAcceptance(source: Object, nodes: any[]): boolean;
            /**
             * removes all data items from the map
             * 
             */
            clearItems(): void;
            /**
             * Returns true if we need to copy items, false to move.
             * It is separated to be overwritten dynamically, if needed.
             * 
             * @param keyPressed the "copy" key was pressed             
             * @param self               Optionaloptional flag that means that we are about to drop on itself             
             */
            copyState(keyPressed: boolean, self: boolean): any;
            /**
             * creator function, dummy at the moment
             * 
             */
            creator(): void;
            /**
             * deletes all selected items
             * 
             */
            deleteSelectedNodes(): Function;
            /**
             * removes a data item from the map by its key (id)
             * 
             * @param key             
             */
            delItem(key: String): void;
            /**
             * prepares the object to be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * iterates over a data map skipping members that
             * are present in the empty object (IE and/or 3rd-party libraries).
             * 
             * @param f             
             * @param o               Optional            
             */
            forInItems(f: Function, o: Object): String;
            /**
             * iterates over selected items;
             * see dojo/dnd/Container.forInItems() for details
             * 
             * @param f             
             * @param o               Optional            
             */
            forInSelectedItems(f: Function, o: Object): void;
            /**
             * returns a list (an array) of all valid child nodes
             * 
             */
            getAllNodes(): any;
            /**
             * returns a data item by its key (id)
             * 
             * @param key             
             */
            getItem(key: String): any;
            /**
             * returns a list (an array) of selected nodes
             * 
             */
            getSelectedNodes(): any;
            /**
             * inserts new data items (see dojo/dnd/Container.insertNodes() method for details)
             * 
             * @param addSelected all new nodes will be added to selected items, if true, no selection change otherwise             
             * @param data a list of data items, which should be processed by the creator function             
             * @param before insert before the anchor, if true, and after the anchor otherwise             
             * @param anchor the anchor node to be used as a point of insertion             
             */
            insertNodes(addSelected: boolean, data: any[], before: boolean, anchor: HTMLElement): Function;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * selects all items
             * 
             */
            selectAll(): any;
            /**
             * unselects all items
             * 
             */
            selectNone(): any;
            /**
             * associates a data item with its key (id)
             * 
             * @param key             
             * @param data             
             */
            setItem(key: String, data: any): void;
            /**
             * collects valid child items and populate the map
             * 
             */
            startup(): void;
            /**
             * sync up the node list with the data map
             * 
             */
            sync(): Function;
            /**
             * topic event processor for /dnd/cancel, called to cancel the DnD operation
             * 
             */
            onDndCancel(): void;
            /**
             * topic event processor for /dnd/drop, called to finish the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             * @param target the target which accepts items             
             */
            onDndDrop(source: Object, nodes: any[], copy: boolean, target: Object): void;
            /**
             * topic event processor for /dnd/source/over, called when detected a current source
             * 
             * @param source the source which has the mouse over it             
             */
            onDndSourceOver(source: Object): void;
            /**
             * topic event processor for /dnd/start, called to initiate the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDndStart(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called during the active DnD operation, when items
             * are dragged away from this target, and it is not disabled
             * 
             */
            onDraggingOut(): void;
            /**
             * called during the active DnD operation, when items
             * are dragged over this target, and it is not disabled
             * 
             */
            onDraggingOver(): void;
            /**
             * called only on the current target, when drop is performed
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDrop(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called only on the current target, when drop is performed
             * from an external source
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDropExternal(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called only on the current target, when drop is performed
             * from the same target/source
             * 
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDropInternal(nodes: any[], copy: boolean): void;
            /**
             * event processor for onmousedown
             * 
             * @param e mouse event             
             */
            onMouseDown(e: Event): void;
            /**
             * event processor for onmousemove
             * 
             * @param e mouse event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseout
             * 
             * @param e mouse event             
             */
            onMouseOut(e: Event): void;
            /**
             * event processor for onmouseover or touch, to mark that element as the current element
             * 
             * @param e mouse event             
             */
            onMouseOver(e: Event): void;
            /**
             * event processor for onmouseup
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
            /**
             * this function is called once, when mouse is out of our container
             * 
             */
            onOutEvent(): void;
            /**
             * this function is called once, when mouse is over our container
             * 
             */
            onOverEvent(): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Mover.html
         *
         * an object which makes a node follow the mouse, or touch-drag on touch devices.
         * Used as a default mover, and as a base class for custom movers.
         * 
         * @param node a node (or node's id) to be moved     
         * @param e a mouse event, which started the move;only pageX and pageY properties are used     
         * @param host       Optionalobject which implements the functionality of the move,and defines proper events (onMoveStart and onMoveStop)     
         */
        class Mover extends dojo.Evented {
            constructor(node: HTMLElement, e: Event, host?: Object);
            /**
             * stops the move, deletes all references, so the object can be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * makes the node absolute; it is meant to be called only once.
             * relative and absolutely positioned nodes are assumed to use pixel units
             * 
             * @param e             
             */
            onFirstMove(e: any): void;
            /**
             * event processor for onmousemove/ontouchmove
             * 
             * @param e mouse/touch event             
             */
            onMouseMove(e: Event): void;
            /**
             * 
             * @param e             
             */
            onMouseUp(e: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Moveable.html
         *
         * an object, which makes a node movable
         * 
         * @param node a node (or node's id) to be moved     
         * @param params       Optionaloptional parameters     
         */
        class Moveable extends dojo.Evented {
            constructor(node: HTMLElement, params?: Object);
            /**
             * 
             */
            "delay": number;
            /**
             * 
             */
            "handle": string;
            /**
             * 
             */
            "skip": boolean;
            /**
             * stops watching for possible move, deletes all references, so the object can be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * called when the drag is detected;
             * responsible for creation of the mover
             * 
             * @param e             
             */
            onDragDetected(e: Event): void;
            /**
             * called during the very first move notification;
             * can be used to initialize coordinates, can be overwritten.
             * 
             * @param mover             
             * @param e             
             */
            onFirstMove(mover: dojo.dnd.Mover, e: Event): void;
            /**
             * event processor for onmousedown/ontouchstart, creates a Mover for the node
             * 
             * @param e mouse/touch event             
             */
            onMouseDown(e: Event): void;
            /**
             * event processor for onmousemove/ontouchmove, used only for delayed drags
             * 
             * @param e mouse/touch event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseup, used only for delayed drags
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
            /**
             * called during every move notification;
             * should actually move the node; can be overwritten.
             * 
             * @param mover             
             * @param leftTop             
             * @param e             
             */
            onMove(mover: dojo.dnd.Mover, leftTop: Object, e: Event): void;
            /**
             * called after every incremental move; can be overwritten.
             * 
             * @param mover             
             * @param leftTop             
             */
            onMoved(mover: dojo.dnd.Mover, leftTop: Object): void;
            /**
             * called before every move operation
             * 
             * @param mover             
             */
            onMoveStart(mover: dojo.dnd.Mover): void;
            /**
             * called after every move operation
             * 
             * @param mover             
             */
            onMoveStop(mover: dojo.dnd.Mover): void;
            /**
             * called before every incremental move; can be overwritten.
             * 
             * @param mover             
             * @param leftTop             
             */
            onMoving(mover: dojo.dnd.Mover, leftTop: Object): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        module Moveable {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Moveable.__MoveableArgs.html
             *
             * 
             */
            class __MoveableArgs {
                constructor();
                /**
                 * delay move by this number of pixels
                 * 
                 */
                "delay": number;
                /**
                 * A node (or node's id), which is used as a mouse handle.
                 * If omitted, the node itself is used as a handle.
                 * 
                 */
                "handle": HTMLElement;
                /**
                 * a constructor of custom Mover
                 * 
                 */
                "mover": Object;
                /**
                 * skip move of form elements
                 * 
                 */
                "skip": boolean;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Selector.html
         *
         * a Selector object, which knows how to select its children
         * 
         * @param node node or node's id to build the selector on     
         * @param params       Optionala dictionary of parameters     
         */
        class Selector extends dojo.dnd.Container {
            constructor(node: HTMLElement, params?: Object);
            /**
             * Indicates whether to allow dnd item nodes to be nested within other elements.
             * By default this is false, indicating that only direct children of the container can
             * be draggable dnd item nodes
             * 
             */
            "allowNested": boolean;
            /**
             * The DOM node the mouse is currently hovered over
             * 
             */
            "current": HTMLElement;
            /**
             * Map from an item's id (which is also the DOMNode's id) to
             * the dojo/dnd/Container.Item itself.
             * 
             */
            "map": Object;
            /**
             * The set of id's that are currently selected, such that this.selection[id] == 1
             * if the node w/that id is selected.  Can iterate over selected node's id's like:
             * 
             * for(var id in this.selection)
             * 
             */
            "selection": Object;
            /**
             * 
             */
            "singular": boolean;
            /**
             * 
             */
            "skipForm": boolean;
            /**
             * removes all data items from the map
             * 
             */
            clearItems(): void;
            /**
             * creator function, dummy at the moment
             * 
             */
            creator(): void;
            /**
             * deletes all selected items
             * 
             */
            deleteSelectedNodes(): Function;
            /**
             * removes a data item from the map by its key (id)
             * 
             * @param key             
             */
            delItem(key: String): void;
            /**
             * prepares the object to be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * iterates over a data map skipping members that
             * are present in the empty object (IE and/or 3rd-party libraries).
             * 
             * @param f             
             * @param o               Optional            
             */
            forInItems(f: Function, o: Object): String;
            /**
             * iterates over selected items;
             * see dojo/dnd/Container.forInItems() for details
             * 
             * @param f             
             * @param o               Optional            
             */
            forInSelectedItems(f: Function, o: Object): void;
            /**
             * returns a list (an array) of all valid child nodes
             * 
             */
            getAllNodes(): any;
            /**
             * returns a data item by its key (id)
             * 
             * @param key             
             */
            getItem(key: String): any;
            /**
             * returns a list (an array) of selected nodes
             * 
             */
            getSelectedNodes(): any;
            /**
             * inserts new data items (see dojo/dnd/Container.insertNodes() method for details)
             * 
             * @param addSelected all new nodes will be added to selected items, if true, no selection change otherwise             
             * @param data a list of data items, which should be processed by the creator function             
             * @param before insert before the anchor, if true, and after the anchor otherwise             
             * @param anchor the anchor node to be used as a point of insertion             
             */
            insertNodes(addSelected?: boolean, data?: any[], before?: boolean, anchor?: HTMLElement): Function;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * selects all items
             * 
             */
            selectAll(): any;
            /**
             * unselects all items
             * 
             */
            selectNone(): any;
            /**
             * associates a data item with its key (id)
             * 
             * @param key             
             * @param data             
             */
            setItem(key: String, data: any): void;
            /**
             * collects valid child items and populate the map
             * 
             */
            startup(): void;
            /**
             * sync up the node list with the data map
             * 
             */
            sync(): Function;
            /**
             * event processor for onmousedown
             * 
             * @param e mouse event             
             */
            onMouseDown(e: Event): void;
            /**
             * event processor for onmousemove
             * 
             * @param e mouse event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseout
             * 
             * @param e mouse event             
             */
            onMouseOut(e: Event): void;
            /**
             * event processor for onmouseover or touch, to mark that element as the current element
             * 
             * @param e mouse event             
             */
            onMouseOver(e: Event): void;
            /**
             * event processor for onmouseup
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
            /**
             * this function is called once, when mouse is out of our container
             * 
             */
            onOutEvent(): void;
            /**
             * this function is called once, when mouse is over our container
             * 
             */
            onOverEvent(): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/TimedMoveable.html
         *
         * A specialized version of Moveable to support an FPS throttling.
         * This class puts an upper restriction on FPS, which may reduce
         * the CPU load. The additional parameter "timeout" regulates
         * the delay before actually moving the moveable object.
         * 
         * @param node a node (or node's id) to be moved     
         * @param params object with additional parameters.     
         */
        class TimedMoveable extends dojo.dnd.Moveable {
            constructor(node: HTMLElement, params: Object);
            /**
             * 
             */
            "delay": number;
            /**
             * 
             */
            "handle": string;
            /**
             * 
             */
            "skip": boolean;
            /**
             * 
             */
            "timeout": number;
            /**
             * stops watching for possible move, deletes all references, so the object can be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * called when the drag is detected;
             * responsible for creation of the mover
             * 
             * @param e             
             */
            onDragDetected(e: Event): void;
            /**
             * called during the very first move notification;
             * can be used to initialize coordinates, can be overwritten.
             * 
             * @param mover             
             * @param e             
             */
            onFirstMove(mover: dojo.dnd.Mover, e: Event): void;
            /**
             * event processor for onmousedown/ontouchstart, creates a Mover for the node
             * 
             * @param e mouse/touch event             
             */
            onMouseDown(e: Event): void;
            /**
             * event processor for onmousemove/ontouchmove, used only for delayed drags
             * 
             * @param e mouse/touch event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseup, used only for delayed drags
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
            /**
             * 
             * @param mover             
             * @param leftTop             
             */
            onMove(mover: dojo.dnd.Mover, leftTop: Object): void;
            /**
             * called after every incremental move; can be overwritten.
             * 
             * @param mover             
             * @param leftTop             
             */
            onMoved(mover: dojo.dnd.Mover, leftTop: Object): void;
            /**
             * called before every move operation
             * 
             * @param mover             
             */
            onMoveStart(mover: dojo.dnd.Mover): void;
            /**
             * 
             * @param mover             
             */
            onMoveStop(mover: dojo.dnd.Mover): void;
            /**
             * called before every incremental move; can be overwritten.
             * 
             * @param mover             
             * @param leftTop             
             */
            onMoving(mover: dojo.dnd.Mover, leftTop: Object): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Target.html
         *
         * a Target object, which can be used as a DnD target
         * 
         * @param node     
         * @param params     
         */
        class Target extends dojo.dnd.Source {
            constructor(node: any, params: any);
            /**
             * 
             */
            "accept": any[];
            /**
             * Indicates whether to allow dnd item nodes to be nested within other elements.
             * By default this is false, indicating that only direct children of the container can
             * be draggable dnd item nodes
             * 
             */
            "allowNested": boolean;
            /**
             * 
             */
            "autoSync": boolean;
            /**
             * 
             */
            "copyOnly": boolean;
            /**
             * The DOM node the mouse is currently hovered over
             * 
             */
            "current": HTMLElement;
            /**
             * 
             */
            "delay": number;
            /**
             * 
             */
            "generateText": boolean;
            /**
             * 
             */
            "horizontal": boolean;
            /**
             * 
             */
            "isSource": boolean;
            /**
             * Map from an item's id (which is also the DOMNode's id) to
             * the dojo/dnd/Container.Item itself.
             * 
             */
            "map": Object;
            /**
             * The set of id's that are currently selected, such that this.selection[id] == 1
             * if the node w/that id is selected.  Can iterate over selected node's id's like:
             * 
             * for(var id in this.selection)
             * 
             */
            "selection": Object;
            /**
             * 
             */
            "selfAccept": boolean;
            /**
             * 
             */
            "selfCopy": boolean;
            /**
             * 
             */
            "singular": boolean;
            /**
             * 
             */
            "skipForm": boolean;
            /**
             * 
             */
            "withHandles": boolean;
            /**
             * checks if the target can accept nodes from this source
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             */
            checkAcceptance(source: Object, nodes: any[]): boolean;
            /**
             * removes all data items from the map
             * 
             */
            clearItems(): void;
            /**
             * Returns true if we need to copy items, false to move.
             * It is separated to be overwritten dynamically, if needed.
             * 
             * @param keyPressed the "copy" key was pressed             
             * @param self               Optionaloptional flag that means that we are about to drop on itself             
             */
            copyState(keyPressed: boolean, self: boolean): any;
            /**
             * creator function, dummy at the moment
             * 
             */
            creator(): void;
            /**
             * deletes all selected items
             * 
             */
            deleteSelectedNodes(): Function;
            /**
             * removes a data item from the map by its key (id)
             * 
             * @param key             
             */
            delItem(key: String): void;
            /**
             * prepares the object to be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * iterates over a data map skipping members that
             * are present in the empty object (IE and/or 3rd-party libraries).
             * 
             * @param f             
             * @param o               Optional            
             */
            forInItems(f: Function, o: Object): String;
            /**
             * iterates over selected items;
             * see dojo/dnd/Container.forInItems() for details
             * 
             * @param f             
             * @param o               Optional            
             */
            forInSelectedItems(f: Function, o: Object): void;
            /**
             * returns a list (an array) of all valid child nodes
             * 
             */
            getAllNodes(): any;
            /**
             * returns a data item by its key (id)
             * 
             * @param key             
             */
            getItem(key: String): any;
            /**
             * returns a list (an array) of selected nodes
             * 
             */
            getSelectedNodes(): any;
            /**
             * inserts new data items (see dojo/dnd/Container.insertNodes() method for details)
             * 
             * @param addSelected all new nodes will be added to selected items, if true, no selection change otherwise             
             * @param data a list of data items, which should be processed by the creator function             
             * @param before insert before the anchor, if true, and after the anchor otherwise             
             * @param anchor the anchor node to be used as a point of insertion             
             */
            insertNodes(addSelected: boolean, data: any[], before?: boolean, anchor?: HTMLElement): Function;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * selects all items
             * 
             */
            selectAll(): any;
            /**
             * unselects all items
             * 
             */
            selectNone(): any;
            /**
             * associates a data item with its key (id)
             * 
             * @param key             
             * @param data             
             */
            setItem(key: String, data: any): void;
            /**
             * collects valid child items and populate the map
             * 
             */
            startup(): void;
            /**
             * sync up the node list with the data map
             * 
             */
            sync(): Function;
            /**
             * topic event processor for /dnd/cancel, called to cancel the DnD operation
             * 
             */
            onDndCancel(): void;
            /**
             * topic event processor for /dnd/drop, called to finish the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             * @param target the target which accepts items             
             */
            onDndDrop(source: Object, nodes: any[], copy: boolean, target: Object): void;
            /**
             * topic event processor for /dnd/source/over, called when detected a current source
             * 
             * @param source the source which has the mouse over it             
             */
            onDndSourceOver(source: Object): void;
            /**
             * topic event processor for /dnd/start, called to initiate the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDndStart(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called during the active DnD operation, when items
             * are dragged away from this target, and it is not disabled
             * 
             */
            onDraggingOut(): void;
            /**
             * called during the active DnD operation, when items
             * are dragged over this target, and it is not disabled
             * 
             */
            onDraggingOver(): void;
            /**
             * called only on the current target, when drop is performed
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDrop(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called only on the current target, when drop is performed
             * from an external source
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDropExternal(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called only on the current target, when drop is performed
             * from the same target/source
             * 
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDropInternal(nodes: any[], copy: boolean): void;
            /**
             * event processor for onmousedown
             * 
             * @param e mouse event             
             */
            onMouseDown(e: Event): void;
            /**
             * event processor for onmousemove
             * 
             * @param e mouse event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseout
             * 
             * @param e mouse event             
             */
            onMouseOut(e: Event): void;
            /**
             * event processor for onmouseover or touch, to mark that element as the current element
             * 
             * @param e mouse event             
             */
            onMouseOver(e: Event): void;
            /**
             * event processor for onmouseup
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
            /**
             * this function is called once, when mouse is out of our container
             * 
             */
            onOutEvent(): void;
            /**
             * this function is called once, when mouse is over our container
             * 
             */
            onOverEvent(): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/Source.html
         *
         * a Source object, which can be used as a DnD source, or a DnD target
         * 
         * @param node node or node's id to build the source on     
         * @param params       Optionalany property of this class may be configured via the paramsobject which is mixed-in to the dojo/dnd/Source instance     
         */
        class Source extends dojo.dnd.Selector {
            constructor(node: HTMLElement, params?: Object);
            /**
             * 
             */
            "accept": any[];
            /**
             * Indicates whether to allow dnd item nodes to be nested within other elements.
             * By default this is false, indicating that only direct children of the container can
             * be draggable dnd item nodes
             * 
             */
            "allowNested": boolean;
            /**
             * 
             */
            "autoSync": boolean;
            /**
             * 
             */
            "copyOnly": boolean;
            /**
             * The DOM node the mouse is currently hovered over
             * 
             */
            "current": HTMLElement;
            /**
             * 
             */
            "delay": number;
            /**
             * 
             */
            "generateText": boolean;
            /**
             * 
             */
            "horizontal": boolean;
            /**
             * 
             */
            "isSource": boolean;
            /**
             * Map from an item's id (which is also the DOMNode's id) to
             * the dojo/dnd/Container.Item itself.
             * 
             */
            "map": Object;
            /**
             * The set of id's that are currently selected, such that this.selection[id] == 1
             * if the node w/that id is selected.  Can iterate over selected node's id's like:
             * 
             * for(var id in this.selection)
             * 
             */
            "selection": Object;
            /**
             * 
             */
            "selfAccept": boolean;
            /**
             * 
             */
            "selfCopy": boolean;
            /**
             * 
             */
            "singular": boolean;
            /**
             * 
             */
            "skipForm": boolean;
            /**
             * 
             */
            "withHandles": boolean;
            /**
             * checks if the target can accept nodes from this source
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             */
            checkAcceptance(source: Object, nodes: any[]): boolean;
            /**
             * removes all data items from the map
             * 
             */
            clearItems(): void;
            /**
             * Returns true if we need to copy items, false to move.
             * It is separated to be overwritten dynamically, if needed.
             * 
             * @param keyPressed the "copy" key was pressed             
             * @param self               Optionaloptional flag that means that we are about to drop on itself             
             */
            copyState(keyPressed: boolean, self: boolean): any;
            /**
             * creator function, dummy at the moment
             * 
             */
            creator(): void;
            /**
             * deletes all selected items
             * 
             */
            deleteSelectedNodes(): Function;
            /**
             * removes a data item from the map by its key (id)
             * 
             * @param key             
             */
            delItem(key: String): void;
            /**
             * prepares the object to be garbage-collected
             * 
             */
            destroy(): void;
            /**
             * 
             * @param type             
             * @param event             
             */
            emit(type: any, event: any): any;
            /**
             * iterates over a data map skipping members that
             * are present in the empty object (IE and/or 3rd-party libraries).
             * 
             * @param f             
             * @param o               Optional            
             */
            forInItems(f: Function, o: Object): String;
            /**
             * iterates over selected items;
             * see dojo/dnd/Container.forInItems() for details
             * 
             * @param f             
             * @param o               Optional            
             */
            forInSelectedItems(f: Function, o: Object): void;
            /**
             * returns a list (an array) of all valid child nodes
             * 
             */
            getAllNodes(): any;
            /**
             * returns a data item by its key (id)
             * 
             * @param key             
             */
            getItem(key: String): any;
            /**
             * returns a list (an array) of selected nodes
             * 
             */
            getSelectedNodes(): any;
            /**
             * inserts new data items (see dojo/dnd/Container.insertNodes() method for details)
             * 
             * @param addSelected all new nodes will be added to selected items, if true, no selection change otherwise             
             * @param data a list of data items, which should be processed by the creator function             
             * @param before insert before the anchor, if true, and after the anchor otherwise             
             * @param anchor the anchor node to be used as a point of insertion             
             */
            insertNodes(addSelected: boolean, data: any[], before?: boolean, anchor?: HTMLElement): Function;
            /**
             * 
             * @param params             
             * @param node             
             * @param Ctor             
             */
            markupFactory(params: any, node: any, Ctor: any): any;
            /**
             * 
             * @param type             
             * @param listener             
             */
            on(type: any, listener: any): any;
            /**
             * selects all items
             * 
             */
            selectAll(): any;
            /**
             * unselects all items
             * 
             */
            selectNone(): any;
            /**
             * associates a data item with its key (id)
             * 
             * @param key             
             * @param data             
             */
            setItem(key: String, data: any): void;
            /**
             * collects valid child items and populate the map
             * 
             */
            startup(): void;
            /**
             * sync up the node list with the data map
             * 
             */
            sync(): Function;
            /**
             * topic event processor for /dnd/cancel, called to cancel the DnD operation
             * 
             */
            onDndCancel(): void;
            /**
             * topic event processor for /dnd/drop, called to finish the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             * @param target the target which accepts items             
             */
            onDndDrop(source: Object, nodes: any[], copy: boolean, target: Object): void;
            /**
             * topic event processor for /dnd/source/over, called when detected a current source
             * 
             * @param source the source which has the mouse over it             
             */
            onDndSourceOver(source: Object): void;
            /**
             * topic event processor for /dnd/start, called to initiate the DnD operation
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDndStart(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called during the active DnD operation, when items
             * are dragged away from this target, and it is not disabled
             * 
             */
            onDraggingOut(): void;
            /**
             * called during the active DnD operation, when items
             * are dragged over this target, and it is not disabled
             * 
             */
            onDraggingOver(): void;
            /**
             * called only on the current target, when drop is performed
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDrop(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called only on the current target, when drop is performed
             * from an external source
             * 
             * @param source the source which provides items             
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDropExternal(source: Object, nodes: any[], copy: boolean): void;
            /**
             * called only on the current target, when drop is performed
             * from the same target/source
             * 
             * @param nodes the list of transferred items             
             * @param copy copy items, if true, move items otherwise             
             */
            onDropInternal(nodes: any[], copy: boolean): void;
            /**
             * event processor for onmousedown
             * 
             * @param e mouse event             
             */
            onMouseDown(e: Event): void;
            /**
             * event processor for onmousemove
             * 
             * @param e mouse event             
             */
            onMouseMove(e: Event): void;
            /**
             * event processor for onmouseout
             * 
             * @param e mouse event             
             */
            onMouseOut(e: Event): void;
            /**
             * event processor for onmouseover or touch, to mark that element as the current element
             * 
             * @param e mouse event             
             */
            onMouseOver(e: Event): void;
            /**
             * event processor for onmouseup
             * 
             * @param e mouse event             
             */
            onMouseUp(e: Event): void;
            /**
             * this function is called once, when mouse is out of our container
             * 
             */
            onOutEvent(): void;
            /**
             * this function is called once, when mouse is over our container
             * 
             */
            onOverEvent(): void;
            /**
             * event processor for onselectevent and ondragevent
             * 
             * @param e mouse event             
             */
            onSelectStart(e: Event): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/autoscroll.html
         *
         * Used by dojo/dnd/Manager to scroll document or internal node when the user
         * drags near the edge of the viewport or a scrollable node
         * 
         */
        interface autoscroll {
            /**
             * 
             */
            H_AUTOSCROLL_VALUE: number;
            /**
             * 
             */
            H_TRIGGER_AUTOSCROLL: number;
            /**
             * 
             */
            V_AUTOSCROLL_VALUE: number;
            /**
             * 
             */
            V_TRIGGER_AUTOSCROLL: number;
            /**
             * a handler for mousemove and touchmove events, which scrolls the window, if
             * necessary
             * 
             * @param e mousemove/touchmove event             
             */
            autoScroll(e: Event): void;
            /**
             * a handler for mousemove and touchmove events, which scrolls the first available
             * Dom element, it falls back to exports.autoScroll()
             * 
             * @param e mousemove/touchmove event             
             */
            autoScrollNodes(e: Event): void;
            /**
             * Called at the start of a drag.
             * 
             * @param d The document of the node being dragged.             
             */
            autoScrollStart(d: HTMLDocument): void;
            /**
             * Returns the dimensions and scroll position of the viewable area of a browser window
             * 
             * @param doc               Optional            
             */
            getViewport(doc: HTMLDocument): Object;
        }
        module autoscroll {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/autoscroll._validOverflow.html
             *
             * 
             */
            interface _validOverflow {
                /**
                 * 
                 */
                auto: number;
                /**
                 * 
                 */
                scroll: number;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/autoscroll._validNodes.html
             *
             * 
             */
            interface _validNodes {
                /**
                 * 
                 */
                div: number;
                /**
                 * 
                 */
                p: number;
                /**
                 * 
                 */
                td: number;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/common.html
         *
         * TODOC
         * 
         */
        interface common {
            /**
             * 
             * @param evt             
             */
            getCopyKeyState(evt: any): any;
            /**
             * returns a unique string for use with any DOM element
             * 
             */
            getUniqueId(): String;
            /**
             * returns true if user clicked on a form element
             * 
             * @param e             
             */
            isFormElement(e: Event): void;
            /**
             * Returns the current DnD manager.  Creates one if it is not created yet.
             * 
             */
            manager(): any;
        }
        module common {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/common._empty.html
             *
             * 
             */
            interface _empty {
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/common._defaultCreatorNodes.html
             *
             * 
             */
            interface _defaultCreatorNodes {
                /**
                 * 
                 */
                div: string;
                /**
                 * 
                 */
                ol: string;
                /**
                 * 
                 */
                p: string;
                /**
                 * 
                 */
                ul: string;
            }
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/move.html
         *
         * TODOC
         * 
         */
        interface move {
            /**
             * 
             */
            boxConstrainedMoveable(): void;
            /**
             * 
             */
            constrainedMoveable(): void;
            /**
             * 
             */
            parentConstrainedMoveable(): void;
        }
        module move {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/move.parentConstrainedMoveable.html
             *
             * 
             * @param node a node (or node's id) to be moved     
             * @param params       Optionalan optional object with parameters     
             */
            class parentConstrainedMoveable extends dojo.dnd.Moveable {
                constructor(node: HTMLElement, params?: Object);
                /**
                 * object attributes (for markup)
                 * 
                 */
                "area": string;
                /**
                 * 
                 */
                "delay": number;
                /**
                 * 
                 */
                "handle": string;
                /**
                 * 
                 */
                "skip": boolean;
                /**
                 * 
                 */
                "within": boolean;
                /**
                 * 
                 */
                constraints(): void;
                /**
                 * stops watching for possible move, deletes all references, so the object can be garbage-collected
                 * 
                 */
                destroy(): void;
                /**
                 * 
                 * @param type             
                 * @param event             
                 */
                emit(type: any, event: any): any;
                /**
                 * 
                 * @param params             
                 * @param node             
                 * @param Ctor             
                 */
                markupFactory(params: any, node: any, Ctor: any): any;
                /**
                 * 
                 * @param type             
                 * @param listener             
                 */
                on(type: any, listener: any): any;
                /**
                 * called when the drag is detected;
                 * responsible for creation of the mover
                 * 
                 * @param e             
                 */
                onDragDetected(e: Event): void;
                /**
                 * called during the very first move notification;
                 * can be used to initialize coordinates, can be overwritten.
                 * 
                 * @param mover             
                 */
                onFirstMove(mover: dojo.dnd.Mover): void;
                /**
                 * event processor for onmousedown/ontouchstart, creates a Mover for the node
                 * 
                 * @param e mouse/touch event             
                 */
                onMouseDown(e: Event): void;
                /**
                 * event processor for onmousemove/ontouchmove, used only for delayed drags
                 * 
                 * @param e mouse/touch event             
                 */
                onMouseMove(e: Event): void;
                /**
                 * event processor for onmouseup, used only for delayed drags
                 * 
                 * @param e mouse event             
                 */
                onMouseUp(e: Event): void;
                /**
                 * called during every move notification;
                 * should actually move the node; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMove(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * called after every incremental move; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMoved(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * called before every move operation
                 * 
                 * @param mover             
                 */
                onMoveStart(mover: dojo.dnd.Mover): void;
                /**
                 * called after every move operation
                 * 
                 * @param mover             
                 */
                onMoveStop(mover: dojo.dnd.Mover): void;
                /**
                 * called before every incremental move; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMoving(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * event processor for onselectevent and ondragevent
                 * 
                 * @param e mouse event             
                 */
                onSelectStart(e: Event): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/move.boxConstrainedMoveable.html
             *
             * 
             * @param node a node (or node's id) to be moved     
             * @param params       Optionalan optional object with parameters     
             */
            class boxConstrainedMoveable extends dojo.dnd.Moveable {
                constructor(node: HTMLElement, params?: Object);
                /**
                 * object attributes (for markup)
                 * 
                 */
                "box": Object;
                /**
                 * 
                 */
                "delay": number;
                /**
                 * 
                 */
                "handle": string;
                /**
                 * 
                 */
                "skip": boolean;
                /**
                 * 
                 */
                "within": boolean;
                /**
                 * 
                 */
                constraints(): void;
                /**
                 * stops watching for possible move, deletes all references, so the object can be garbage-collected
                 * 
                 */
                destroy(): void;
                /**
                 * 
                 * @param type             
                 * @param event             
                 */
                emit(type: any, event: any): any;
                /**
                 * 
                 * @param params             
                 * @param node             
                 * @param Ctor             
                 */
                markupFactory(params: any, node: any, Ctor: any): any;
                /**
                 * 
                 * @param type             
                 * @param listener             
                 */
                on(type: any, listener: any): any;
                /**
                 * called when the drag is detected;
                 * responsible for creation of the mover
                 * 
                 * @param e             
                 */
                onDragDetected(e: Event): void;
                /**
                 * called during the very first move notification;
                 * can be used to initialize coordinates, can be overwritten.
                 * 
                 * @param mover             
                 */
                onFirstMove(mover: dojo.dnd.Mover): void;
                /**
                 * event processor for onmousedown/ontouchstart, creates a Mover for the node
                 * 
                 * @param e mouse/touch event             
                 */
                onMouseDown(e: Event): void;
                /**
                 * event processor for onmousemove/ontouchmove, used only for delayed drags
                 * 
                 * @param e mouse/touch event             
                 */
                onMouseMove(e: Event): void;
                /**
                 * event processor for onmouseup, used only for delayed drags
                 * 
                 * @param e mouse event             
                 */
                onMouseUp(e: Event): void;
                /**
                 * called during every move notification;
                 * should actually move the node; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMove(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * called after every incremental move; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMoved(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * called before every move operation
                 * 
                 * @param mover             
                 */
                onMoveStart(mover: dojo.dnd.Mover): void;
                /**
                 * called after every move operation
                 * 
                 * @param mover             
                 */
                onMoveStop(mover: dojo.dnd.Mover): void;
                /**
                 * called before every incremental move; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMoving(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * event processor for onselectevent and ondragevent
                 * 
                 * @param e mouse event             
                 */
                onSelectStart(e: Event): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/dnd/move.constrainedMoveable.html
             *
             * 
             * @param node a node (or node's id) to be moved     
             * @param params       Optionalan optional object with additional parameters;the rest is passed to the base class     
             */
            class constrainedMoveable extends dojo.dnd.Moveable {
                constructor(node: HTMLElement, params?: Object);
                /**
                 * 
                 */
                "delay": number;
                /**
                 * 
                 */
                "handle": string;
                /**
                 * 
                 */
                "skip": boolean;
                /**
                 * 
                 */
                "within": boolean;
                /**
                 * 
                 */
                constraints(): void;
                /**
                 * stops watching for possible move, deletes all references, so the object can be garbage-collected
                 * 
                 */
                destroy(): void;
                /**
                 * 
                 * @param type             
                 * @param event             
                 */
                emit(type: any, event: any): any;
                /**
                 * 
                 * @param params             
                 * @param node             
                 * @param Ctor             
                 */
                markupFactory(params: any, node: any, Ctor: any): any;
                /**
                 * 
                 * @param type             
                 * @param listener             
                 */
                on(type: any, listener: any): any;
                /**
                 * called when the drag is detected;
                 * responsible for creation of the mover
                 * 
                 * @param e             
                 */
                onDragDetected(e: Event): void;
                /**
                 * called during the very first move notification;
                 * can be used to initialize coordinates, can be overwritten.
                 * 
                 * @param mover             
                 */
                onFirstMove(mover: dojo.dnd.Mover): void;
                /**
                 * event processor for onmousedown/ontouchstart, creates a Mover for the node
                 * 
                 * @param e mouse/touch event             
                 */
                onMouseDown(e: Event): void;
                /**
                 * event processor for onmousemove/ontouchmove, used only for delayed drags
                 * 
                 * @param e mouse/touch event             
                 */
                onMouseMove(e: Event): void;
                /**
                 * event processor for onmouseup, used only for delayed drags
                 * 
                 * @param e mouse event             
                 */
                onMouseUp(e: Event): void;
                /**
                 * called during every move notification;
                 * should actually move the node; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMove(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * called after every incremental move; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMoved(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * called before every move operation
                 * 
                 * @param mover             
                 */
                onMoveStart(mover: dojo.dnd.Mover): void;
                /**
                 * called after every move operation
                 * 
                 * @param mover             
                 */
                onMoveStop(mover: dojo.dnd.Mover): void;
                /**
                 * called before every incremental move; can be overwritten.
                 * 
                 * @param mover             
                 * @param leftTop             
                 */
                onMoving(mover: dojo.dnd.Mover, leftTop: Object): void;
                /**
                 * event processor for onselectevent and ondragevent
                 * 
                 * @param e mouse event             
                 */
                onSelectStart(e: Event): void;
            }
        }

    }

    module errors {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/errors/create.html
         *
         * 
         * @param name     
         * @param ctor     
         * @param base     
         * @param props     
         */
        interface create{(name: any, ctor: any, base: any, props: any): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/errors/CancelError.html
         *
         * Default error if a promise is canceled without a reason.
         * 
         */
        interface CancelError{(): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/errors/RequestError.html
         *
         * TODOC
         * 
         */
        interface RequestError{(): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/errors/RequestTimeoutError.html
         *
         * TODOC
         * 
         */
        interface RequestTimeoutError{(): void}
    }

    module io {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/io/iframe.html
         *
         * Deprecated, use dojo/request/iframe instead.
         * Sends an Ajax I/O call using and Iframe (for instance, to upload files)
         * 
         */
        interface iframe {
            /**
             * Creates a hidden iframe in the page. Used mostly for IO
             * transports.  You do not need to call this to start a
             * dojo/io/iframe request. Just call send().
             * 
             * @param fname The name of the iframe. Used for the name attribute on theiframe.             
             * @param onloadstr A string of JavaScript that will be executed when the contentin the iframe loads.             
             * @param uri The value of the src attribute on the iframe element. If avalue is not given, then dojo/resources/blank.html will beused.             
             */
            create(fname: String, onloadstr: String, uri: String): void;
            /**
             * Returns the document object associated with the iframe DOM Node argument.
             * 
             * @param iframeNode             
             */
            doc(iframeNode: any): void;
            /**
             * Sets the URL that is loaded in an IFrame. The replace parameter
             * indicates whether location.replace() should be used when
             * changing the location of the iframe.
             * 
             * @param iframe             
             * @param src             
             * @param replace             
             */
            setSrc(iframe: any, src: any, replace: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/io/script.html
         *
         * TODOC
         * 
         */
        interface script {
            /**
             * creates a new <script> tag pointing to the specified URL and
             * adds it to the document.
             * Attaches the script element to the DOM. Use this method if you
             * just want to attach a script to the DOM and do not care when or
             * if it loads.
             * 
             * @param id             
             * @param url             
             * @param frameDocument             
             */
            attach(id: any, url: any, frameDocument: any): void;
            /**
             * sends a get request using a dynamically created script tag.
             * 
             * @param args An object with the following properties:callbackParamName (String): Deprecated as of Dojo 1.4 in favor of "jsonp", but still supported forlegacy code. See notes for jsonp property.jsonp (String): The URL parameter name that indicates the JSONP callback string.For instance, when using Yahoo JSONP calls it is normally,jsonp: "callback". For AOL JSONP calls it is normallyjsonp: "c".checkString (String): A string of JavaScript that when evaluated like so:"typeof(" + checkString + ") != 'undefined'"being true means that the script fetched has been loaded.Do not use this if doing a JSONP type of call (use callbackParamName instead).frameDoc (Document): The Document object for a child iframe. If this is passed in, the scriptwill be attached to that document. This can be helpful in some comet long-pollingscenarios with Firefox and Opera.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.handleAs (String, optional): Acceptable values depend on the type of IOtransport (see specific IO calls for more information).rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
             */
            get(args: Object): any;
            /**
             * removes the script element with the given id, from the given frameDocument.
             * If no frameDocument is passed, the current document is used.
             * 
             * @param id             
             * @param frameDocument             
             */
            remove(id: any, frameDocument: any): void;
        }
    }

    module promise {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/all.html
         *
         * Takes multiple promises and returns a new promise that is fulfilled
         * when all promises have been fulfilled.
         * Takes multiple promises and returns a new promise that is fulfilled
         * when all promises have been fulfilled. If one of the promises is rejected,
         * the returned promise is also rejected. Canceling the returned promise will
         * not cancel any passed promises.
         * 
         * @param objectOrArray       OptionalThe promise will be fulfilled with a list of results if invoked with anarray, or an object of results when passed an object (using the samekeys). If passed neither an object or array it is resolved with anundefined value.     
         */
        interface all{<T>(value: Promise<T>[]): Promise<T[]>}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/all.html
         *
         * Takes multiple promises and returns a new promise that is fulfilled
         * when all promises have been fulfilled.
         * Takes multiple promises and returns a new promise that is fulfilled
         * when all promises have been fulfilled. If one of the promises is rejected,
         * the returned promise is also rejected. Canceling the returned promise will
         * not cancel any passed promises.
         * 
         * @param objectOrArray       OptionalThe promise will be fulfilled with a list of results if invoked with anarray, or an object of results when passed an object (using the samekeys). If passed neither an object or array it is resolved with anundefined value.     
         */
        interface all{(value: Object): Promise<any>}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/first.html
         *
         * Takes multiple promises and returns a new promise that is fulfilled
         * when the first of these promises is fulfilled.
         * Takes multiple promises and returns a new promise that is fulfilled
         * when the first of these promises is fulfilled. Canceling the returned
         * promise will not cancel any passed promises. The promise will be
         * fulfilled with the value of the first fulfilled promise.
         * 
         * @param objectOrArray       OptionalThe promises are taken from the array or object values. If no valueis passed, the returned promise is resolved with an undefined value.     
         */
        interface first{(objectOrArray?: Object): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/first.html
         *
         * Takes multiple promises and returns a new promise that is fulfilled
         * when the first of these promises is fulfilled.
         * Takes multiple promises and returns a new promise that is fulfilled
         * when the first of these promises is fulfilled. Canceling the returned
         * promise will not cancel any passed promises. The promise will be
         * fulfilled with the value of the first fulfilled promise.
         * 
         * @param objectOrArray       OptionalThe promises are taken from the array or object values. If no valueis passed, the returned promise is resolved with an undefined value.     
         */
        interface first{(objectOrArray?: any[]): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/instrumentation.html
         *
         * Initialize instrumentation for the Deferred class.
         * Initialize instrumentation for the Deferred class.
         * Done automatically by dojo/Deferred if the
         * deferredInstrumentation and useDeferredInstrumentation
         * config options are set.
         * 
         * Sets up dojo/promise/tracer to log to the console.
         * 
         * Sets up instrumentation of rejected deferreds so unhandled
         * errors are logged to the console.
         * 
         * @param Deferred     
         */
        interface instrumentation{(Deferred: any): void}

        interface Callback<T, U> {
            (arg: T): U|Promise<U>;
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/Promise.html
         *
         * The public interface to a deferred.
         * The public interface to a deferred. All promises in Dojo are
         * instances of this class.
         * 
         */
        interface Promise<T> {
            /**
             * Add a callback to be invoked when the promise is resolved
             * or rejected.
             * 
             * @param callbackOrErrback               OptionalA function that is used both as a callback and errback.             
             */
            always<U>(callbackOrErrback: Callback<any, U>): Promise<U>;
            /**
             * Inform the deferred it may cancel its asynchronous operation.
             * Inform the deferred it may cancel its asynchronous operation.
             * The deferred's (optional) canceler is invoked and the
             * deferred will be left in a rejected state. Can affect other
             * promises that originate with the same deferred.
             * 
             * @param reason A message that may be sent to the deferred's canceler,explaining why it's being canceled.             
             * @param strict               OptionalIf strict, will throw an error if the deferred has alreadybeen fulfilled and consequently cannot be canceled.             
             */
            cancel(reason: any, strict: boolean): any;
            /**
             * Checks whether the promise has been canceled.
             * 
             */
            isCanceled(): boolean;
            /**
             * Checks whether the promise has been resolved or rejected.
             * 
             */
            isFulfilled(): boolean;
            /**
             * Checks whether the promise has been rejected.
             * 
             */
            isRejected(): boolean;
            /**
             * Checks whether the promise has been resolved.
             * 
             */
            isResolved(): boolean;
            /**
             * Add new errbacks to the promise.
             * 
             * @param errback               OptionalCallback to be invoked when the promise is rejected.             
             */
            otherwise<U>(errback: Callback<any, U>): Promise<U>;
            /**
             * Add new callbacks to the promise.
             * Add new callbacks to the deferred. Callbacks can be added
             * before or after the deferred is fulfilled.
             * 
             * @param callback               OptionalCallback to be invoked when the promise is resolved.Receives the resolution value.             
             * @param errback               OptionalCallback to be invoked when the promise is rejected.Receives the rejection error.             
             * @param progback               OptionalCallback to be invoked when the promise emits a progressupdate. Receives the progress update.             
             */
            then<U>(callback: Callback<T, U>, errback?: Callback<any, U>, progback?: Callback<any, U>): Promise<U>;
            /**
             * 
             */
            toString(): String;
            /**
             * Trace the promise.
             * Tracing allows you to transparently log progress,
             * resolution and rejection of promises, without affecting the
             * promise itself. Any arguments passed to trace() are
             * emitted in trace events. See dojo/promise/tracer on how
             * to handle traces.
             * 
             */
            trace(): Promise<T>;
            /**
             * Trace rejection of the promise.
             * Tracing allows you to transparently log progress,
             * resolution and rejection of promises, without affecting the
             * promise itself. Any arguments passed to trace() are
             * emitted in trace events. See dojo/promise/tracer on how
             * to handle traces.
             * 
             */
            traceRejected(): Promise<T>;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/promise/tracer.html
         *
         * Trace promise fulfillment.
         * Trace promise fulfillment. Calling .trace() or .traceError() on a
         * promise enables tracing. Will emit resolved, rejected or progress
         * events.
         * 
         */
        interface tracer {
            /**
             * Subscribe to traces.
             * See dojo/Evented#on().
             * 
             * @param type resolved, rejected, or progress             
             * @param listener The listener is passed the traced value and any argumentsthat were used with the .trace() call.             
             */
            on(type: String, listener: Function): void;
        }
    }

    module rpc {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/rpc/JsonpService.html
         *
         * Generic JSONP service.  Minimally extends RpcService to allow
         * easy definition of nearly any JSONP style service. Example
         * SMD files exist in dojox.data
         * 
         * @param args     
         * @param requiredArgs     
         */
        class JsonpService extends dojo.rpc.RpcService {
            constructor(args: any, requiredArgs: any);
            /**
             * 
             */
            "serviceUrl": string;
            /**
             * 
             */
            "strictArgChecks": boolean;
            /**
             * JSONP bind method. Takes remote method, parameters,
             * deferred, and a url, calls createRequest to make a JSON-RPC
             * envelope and passes that off with bind.
             * 
             * @param method The name of the method we are calling             
             * @param parameters The parameters we are passing off to the method             
             * @param deferredRequestHandler The Deferred object for this particular request             
             * @param url             
             */
            bind(method: String, parameters: dojo._base.array, deferredRequestHandler: dojo.Deferred, url: any): void;
            /**
             * create a JSONP req
             * 
             * @param parameters             
             */
            createRequest(parameters: any): Object;
            /**
             * create callback that calls the Deferred errback method
             * 
             * @param deferredRequestHandler The deferred object handling a request.             
             */
            errorCallback(deferredRequestHandler: dojo._base.Deferred): Function;
            /**
             * generate the local bind methods for the remote object
             * 
             * @param method The name of the method we are generating             
             * @param parameters the array of parameters for this call.             
             * @param url the service url for this call             
             */
            generateMethod(method: String, parameters: dojo._base.array, url: String): any;
            /**
             * parse the results coming back from an rpc request.  this
             * base implementation, just returns the full object
             * subclasses should parse and only return the actual results
             * 
             * @param obj Object that is the return results from an rpc request             
             */
            parseResults(obj: Object): Object;
            /**
             * callback method for receipt of a smd object.  Parse the smd
             * and generate functions based on the description
             * 
             * @param object smd object defining this service.             
             */
            processSmd(object: any): void;
            /**
             * create callback that calls the Deferred's callback method
             * 
             * @param deferredRequestHandler The deferred object handling a request.             
             */
            resultCallback(deferredRequestHandler: dojo._base.Deferred): any;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/rpc/JsonService.html
         *
         * TODOC
         * 
         * @param args Takes a number of properties as kwArgs for defining the service.  It alsoaccepts a string.  When passed a string, it is treated as a url fromwhich it should synchronously retrieve an smd file.  Otherwise it is a kwArgsobject.  It accepts serviceUrl, to manually define a url for the rpc serviceallowing the rpc system to be used without an smd definition. strictArgChecksforces the system to verify that the # of arguments provided in a callmatches those defined in the smd.  smdString allows a developer to passa jsonString directly, which will be converted into an object or alternativelysmdObject is accepts an smdObject directly.     
         */
        class JsonService extends dojo.rpc.RpcService {
            constructor(args: Object);
            /**
             * 
             */
            "bustCache": boolean;
            /**
             * 
             */
            "contentType": string;
            /**
             * 
             */
            "lastSubmissionId": number;
            /**
             * 
             */
            "serviceUrl": string;
            /**
             * 
             */
            "strictArgChecks": boolean;
            /**
             * JSON-RPC bind method. Takes remote method, parameters,
             * deferred, and a url, calls createRequest to make a JSON-RPC
             * envelope and passes that off with bind.
             * 
             * @param method The name of the method we are calling             
             * @param parameters The parameters we are passing off to the method             
             * @param deferredRequestHandler The Deferred object for this particular request             
             * @param url             
             */
            bind(method: String, parameters: any[], deferredRequestHandler: dojo.Deferred, url: any): void;
            /**
             * call an arbitrary remote method without requiring it to be
             * predefined with SMD
             * 
             * @param method the name of the remote method you want to call.             
             * @param params array of parameters to pass to method             
             */
            callRemote(method: String, params: any[]): any;
            /**
             * create a JSON-RPC envelope for the request
             * 
             * @param method The name of the method we are creating the request for             
             * @param params The array of parameters for this request;             
             */
            createRequest(method: String, params: dojo._base.array): any;
            /**
             * create callback that calls the Deferred errback method
             * 
             * @param deferredRequestHandler The deferred object handling a request.             
             */
            errorCallback(deferredRequestHandler: dojo._base.Deferred): Function;
            /**
             * generate the local bind methods for the remote object
             * 
             * @param method The name of the method we are generating             
             * @param parameters the array of parameters for this call.             
             * @param url the service url for this call             
             */
            generateMethod(method: String, parameters: dojo._base.array, url: String): any;
            /**
             * parse the result envelope and pass the results back to
             * the callback function
             * 
             * @param obj Object containing envelope of data we receive from the server             
             */
            parseResults(obj: Object): any;
            /**
             * callback method for receipt of a smd object.  Parse the smd
             * and generate functions based on the description
             * 
             * @param object smd object defining this service.             
             */
            processSmd(object: any): void;
            /**
             * create callback that calls the Deferred's callback method
             * 
             * @param deferredRequestHandler The deferred object handling a request.             
             */
            resultCallback(deferredRequestHandler: dojo._base.Deferred): any;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/rpc/RpcService.html
         *
         * TODOC
         * 
         * @param args Takes a number of properties as kwArgs for defining the service.  It alsoaccepts a string.  When passed a string, it is treated as a url fromwhich it should synchronously retrieve an smd file.  Otherwise it is a kwArgsobject.  It accepts serviceUrl, to manually define a url for the rpc serviceallowing the rpc system to be used without an smd definition. strictArgChecksforces the system to verify that the # of arguments provided in a callmatches those defined in the smd.  smdString allows a developer to passa jsonString directly, which will be converted into an object or alternativelysmdObject is accepts an smdObject directly.     
         */
        class RpcService {
            constructor(args: Object);
            /**
             * 
             */
            "serviceUrl": string;
            /**
             * 
             */
            "strictArgChecks": boolean;
            /**
             * create callback that calls the Deferred errback method
             * 
             * @param deferredRequestHandler The deferred object handling a request.             
             */
            errorCallback(deferredRequestHandler: dojo._base.Deferred): Function;
            /**
             * generate the local bind methods for the remote object
             * 
             * @param method The name of the method we are generating             
             * @param parameters the array of parameters for this call.             
             * @param url the service url for this call             
             */
            generateMethod(method: String, parameters: dojo._base.array, url: String): any;
            /**
             * parse the results coming back from an rpc request.  this
             * base implementation, just returns the full object
             * subclasses should parse and only return the actual results
             * 
             * @param obj Object that is the return results from an rpc request             
             */
            parseResults(obj: Object): Object;
            /**
             * callback method for receipt of a smd object.  Parse the smd
             * and generate functions based on the description
             * 
             * @param object smd object defining this service.             
             */
            processSmd(object: any): void;
            /**
             * create callback that calls the Deferred's callback method
             * 
             * @param deferredRequestHandler The deferred object handling a request.             
             */
            resultCallback(deferredRequestHandler: dojo._base.Deferred): any;
        }
    }

    module selector {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/selector/lite.html
         *
         * A small lightweight query selector engine that implements CSS2.1 selectors
         * minus pseudo-classes and the sibling combinator, plus CSS3 attribute selectors
         * 
         * @param selector     
         * @param root     
         */
        interface lite{(selector: any, root: any): void}
        interface lite {
            /**
             * 
             */
            match: Object;
        }

        module lite {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/selector/acme.html
         *
         * Returns nodes which match the given CSS3 selector, searching the
         * entire document by default but optionally taking a node to scope
         * the search by. Returns an array.
         * dojo.query() is the swiss army knife of DOM node manipulation in
         * Dojo. Much like Prototype's "$$" (bling-bling) function or JQuery's
         * "$" function, dojo.query provides robust, high-performance
         * CSS-based node selector support with the option of scoping searches
         * to a particular sub-tree of a document.
         * 
         * Supported Selectors:
         * acme supports a rich set of CSS3 selectors, including:
         * 
         * class selectors (e.g., .foo)
         * node type selectors like span
         *   descendant selectors
         * > child element selectors
         * #foo style ID selectors
         * * universal selector
         * ~, the preceded-by sibling selector
         * +, the immediately preceded-by sibling selector
         * attribute queries:
         * [foo] attribute presence selector
         * [foo='bar'] attribute value exact match
         * [foo~='bar'] attribute value list item match
         * [foo^='bar'] attribute start match
         * [foo$='bar'] attribute end match
         * [foo*='bar'] attribute substring match
         * 
         * :first-child, :last-child, and :only-child positional selectors
         * :empty content emtpy selector
         * :checked pseudo selector
         * :nth-child(n), :nth-child(2n+1) style positional calculations
         * :nth-child(even), :nth-child(odd) positional selectors
         * :not(...) negation pseudo selectors
         * Any legal combination of these selectors will work with
         * dojo.query(), including compound selectors ("," delimited).
         * Very complex and useful searches can be constructed with this
         * palette of selectors and when combined with functions for
         * manipulation presented by dojo/NodeList, many types of DOM
         * manipulation operations become very straightforward.
         * 
         * Unsupported Selectors:
         * While dojo.query handles many CSS3 selectors, some fall outside of
         * what's reasonable for a programmatic node querying engine to
         * handle. Currently unsupported selectors include:
         * 
         * namespace-differentiated selectors of any form
         * all :: pseduo-element selectors
         * certain pseudo-selectors which don't get a lot of day-to-day use:
         * :root, :lang(), :target, :focus
         * 
         * all visual and state selectors:
         * :root, :active, :hover, :visited, :link,`:enabled`, `:disabled`
         * :*-of-type pseudo selectors
         * 
         * dojo.query and XML Documents:
         * dojo.query (as of dojo 1.2) supports searching XML documents
         * in a case-sensitive manner. If an HTML document is served with
         * a doctype that forces case-sensitivity (e.g., XHTML 1.1
         * Strict), dojo.query() will detect this and "do the right
         * thing". Case sensitivity is dependent upon the document being
         * searched and not the query used. It is therefore possible to
         * use case-sensitive queries on strict sub-documents (iframes,
         * etc.) or XML documents while still assuming case-insensitivity
         * for a host/root document.
         * 
         * Non-selector Queries:
         * If something other than a String is passed for the query,
         * dojo.query will return a new dojo/NodeList instance
         * constructed from that parameter alone and all further
         * processing will stop. This means that if you have a reference
         * to a node or NodeList, you can quickly construct a new NodeList
         * from the original by calling dojo.query(node) or
         * dojo.query(list).
         * 
         * @param query The CSS3 expression to match against. For details on the syntax ofCSS3 selectors, see http://www.w3.org/TR/css3-selectors/#selectors     
         * @param root       OptionalA DOMNode (or node id) to scope the search from. Optional.     
         */
        interface acme{(query: String, root?: String): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/selector/acme.html
         *
         * Returns nodes which match the given CSS3 selector, searching the
         * entire document by default but optionally taking a node to scope
         * the search by. Returns an array.
         * dojo.query() is the swiss army knife of DOM node manipulation in
         * Dojo. Much like Prototype's "$$" (bling-bling) function or JQuery's
         * "$" function, dojo.query provides robust, high-performance
         * CSS-based node selector support with the option of scoping searches
         * to a particular sub-tree of a document.
         * 
         * Supported Selectors:
         * acme supports a rich set of CSS3 selectors, including:
         * 
         * class selectors (e.g., .foo)
         * node type selectors like span
         *   descendant selectors
         * > child element selectors
         * #foo style ID selectors
         * * universal selector
         * ~, the preceded-by sibling selector
         * +, the immediately preceded-by sibling selector
         * attribute queries:
         * [foo] attribute presence selector
         * [foo='bar'] attribute value exact match
         * [foo~='bar'] attribute value list item match
         * [foo^='bar'] attribute start match
         * [foo$='bar'] attribute end match
         * [foo*='bar'] attribute substring match
         * 
         * :first-child, :last-child, and :only-child positional selectors
         * :empty content emtpy selector
         * :checked pseudo selector
         * :nth-child(n), :nth-child(2n+1) style positional calculations
         * :nth-child(even), :nth-child(odd) positional selectors
         * :not(...) negation pseudo selectors
         * Any legal combination of these selectors will work with
         * dojo.query(), including compound selectors ("," delimited).
         * Very complex and useful searches can be constructed with this
         * palette of selectors and when combined with functions for
         * manipulation presented by dojo/NodeList, many types of DOM
         * manipulation operations become very straightforward.
         * 
         * Unsupported Selectors:
         * While dojo.query handles many CSS3 selectors, some fall outside of
         * what's reasonable for a programmatic node querying engine to
         * handle. Currently unsupported selectors include:
         * 
         * namespace-differentiated selectors of any form
         * all :: pseduo-element selectors
         * certain pseudo-selectors which don't get a lot of day-to-day use:
         * :root, :lang(), :target, :focus
         * 
         * all visual and state selectors:
         * :root, :active, :hover, :visited, :link,`:enabled`, `:disabled`
         * :*-of-type pseudo selectors
         * 
         * dojo.query and XML Documents:
         * dojo.query (as of dojo 1.2) supports searching XML documents
         * in a case-sensitive manner. If an HTML document is served with
         * a doctype that forces case-sensitivity (e.g., XHTML 1.1
         * Strict), dojo.query() will detect this and "do the right
         * thing". Case sensitivity is dependent upon the document being
         * searched and not the query used. It is therefore possible to
         * use case-sensitive queries on strict sub-documents (iframes,
         * etc.) or XML documents while still assuming case-insensitivity
         * for a host/root document.
         * 
         * Non-selector Queries:
         * If something other than a String is passed for the query,
         * dojo.query will return a new dojo/NodeList instance
         * constructed from that parameter alone and all further
         * processing will stop. This means that if you have a reference
         * to a node or NodeList, you can quickly construct a new NodeList
         * from the original by calling dojo.query(node) or
         * dojo.query(list).
         * 
         * @param query The CSS3 expression to match against. For details on the syntax ofCSS3 selectors, see http://www.w3.org/TR/css3-selectors/#selectors     
         * @param root       OptionalA DOMNode (or node id) to scope the search from. Optional.     
         */
        interface acme{(query: String, root?: HTMLElement): void}
        interface acme {
            /**
             * function for filtering a NodeList based on a selector, optimized for simple selectors
             * 
             * @param nodeList             
             * @param filter             
             * @param root               Optional            
             */
            filter(nodeList: HTMLElement[], filter: String, root: String): void;
            /**
             * function for filtering a NodeList based on a selector, optimized for simple selectors
             * 
             * @param nodeList             
             * @param filter             
             * @param root               Optional            
             */
            filter(nodeList: HTMLElement[], filter: String, root: HTMLElement): void;
        }

        module acme {
        }

        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/selector/_loader.html
         *
         * This module handles loading the appropriate selector engine for the given browser
         * 
         */
        interface _loader {
            /**
             * 
             * @param id             
             * @param parentRequire             
             * @param loaded             
             * @param config             
             */
            load(id: any, parentRequire: any, loaded: any, config: any): any;
        }
    }

    module store {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/Observable.html
         *
         * The Observable store wrapper takes a store and sets an observe method on query()
         * results that can be used to monitor results for changes.
         * Observable wraps an existing store so that notifications can be made when a query
         * is performed.
         * 
         * @param store     
         */
        interface Observable{(store: dojo.store.api.Store): void}
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/Cache.html
         *
         * The Cache store wrapper takes a master store and a caching store,
         * caches data from the master into the caching store for faster
         * lookup. Normally one would use a memory store for the caching
         * store and a server store like JsonRest for the master store.
         * 
         * @param masterStore This is the authoritative store, all uncached requests or non-safe requests willbe made against this store.     
         * @param cachingStore This is the caching store that will be used to store responses for quick access.Typically this should be a local store.     
         * @param options       OptionalThese are additional options for how caching is handled.     
         */
        class Cache extends dojo.store.api.Store {
            constructor(masterStore: any, cachingStore: any, options?: Object);
            /**
             * If the store has a single primary key, this indicates the property to use as the
             * identity property. The values of this property should be unique.
             * 
             */
            "idProperty": string;
            /**
             * If the store can be queried locally (on the client side in JS), this defines
             * the query engine to use for querying the data store.
             * This takes a query and query options and returns a function that can execute
             * the provided query on a JavaScript array. The queryEngine may be replace to
             * provide more sophisticated querying capabilities. For example:
             * 
             * var query = store.queryEngine({foo:"bar"}, {count:10});
             * query(someArray) -> filtered array
             * The returned query function may have a "matches" property that can be
             * 
             * used to determine if an object matches the query. For example:
             * 
             * query.matches({id:"some-object", foo:"bar"}) -> true
             * query.matches({id:"some-object", foo:"something else"}) -> false
             * 
             */
            queryEngine(query: Object, options: dojo.store.api.Store.QueryOptions): any;
            /**
             * Add the given object to the store.
             * 
             * @param object The object to add to the store.             
             * @param directives               OptionalAny additional parameters needed to describe how the add should be performed.             
             */
            add(object: Object, directives: any): number;
            /**
             * Remove the object with the given id from the underlying caching store.
             * 
             * @param id The identifier for the object in question.             
             */
            evict(id: number): void;
            /**
             * Get the object with the specific id.
             * 
             * @param id The identifier for the object in question.             
             * @param directives               OptionalAny additional parameters needed to describe how the get should be performed.             
             */
            get(id: number, directives?: Object): dojo.store.api.Store.QueryResults;
            /**
             * Retrieves the children of an object.
             * 
             * @param parent The object to find the children of.             
             * @param options               OptionalAdditional options to apply to the retrieval of the children.             
             */
            getChildren(parent: Object, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
            /**
             * Returns an object's identity
             * 
             * @param object The object to get the identity from             
             */
            getIdentity(object: Object): any;
            /**
             * Returns any metadata about the object. This may include attribution,
             * cache directives, history, or version information.
             * 
             * @param object The object to return metadata for.             
             */
            getMetadata(object: Object): Object;
            /**
             * Put the object into the store (similar to an HTTP PUT).
             * 
             * @param object The object to put to the store.             
             * @param directives               OptionalAny additional parameters needed to describe how the put should be performed.             
             */
            put(object: Object, directives: dojo.store.api.Store.PutDirectives): number;
            /**
             * Query the underlying master store and cache any results.
             * 
             * @param query The object or string containing query information. Dependent on the query engine used.             
             * @param directives               OptionalAn optional keyword arguments object with additional parameters describing the query.             
             */
            query(query: Object, directives: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
            /**
             * Query the underlying master store and cache any results.
             * 
             * @param query The object or string containing query information. Dependent on the query engine used.             
             * @param directives               OptionalAn optional keyword arguments object with additional parameters describing the query.             
             */
            query(query: String, directives: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
            /**
             * Remove the object with the specific id.
             * 
             * @param id The identifier for the object in question.             
             */
            remove(id: number): void;
            /**
             * Starts a new transaction.
             * Note that a store user might not call transaction() prior to using put,
             * delete, etc. in which case these operations effectively could be thought of
             * as "auto-commit" style actions.
             * 
             */
            transaction(): dojo.store.api.Store.Transaction;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/DataStore.html
         *
         * This is an adapter for using Dojo Data stores with an object store consumer.
         * You can provide a Dojo data store and use this adapter to interact with it through
         * the Dojo object store API
         * 
         * @param options       OptionalThis provides any configuration information that will be mixed into the store,including a reference to the Dojo data store under the property "store".     
         */
        class DataStore extends dojo.store.api.Store {
            constructor(options?: Object);
            /**
             * The object property to use to store the identity of the store items.
             * 
             */
            "idProperty": string;
            /**
             * The object store to convert to a data store
             * 
             */
            "store": Object;
            /**
             * 
             */
            "target": string;
            /**
             * Creates an object, throws an error if the object already exists
             * 
             * @param object The object to store.             
             * @param directives               OptionalAdditional directives for creating objects.             
             */
            add(object: Object, directives: dojo.store.api.Store.PutDirectives): any;
            /**
             * Retrieves an object by it's identity. This will trigger a fetchItemByIdentity
             * 
             * @param id               OptionalThe identity to use to lookup the object             
             * @param options             
             */
            get(id: Object, options?: any): any;
            /**
             * Retrieves the children of an object.
             * 
             * @param parent The object to find the children of.             
             * @param options               OptionalAdditional options to apply to the retrieval of the children.             
             */
            getChildren(parent: Object, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
            /**
             * Fetch the identity for the given object.
             * 
             * @param object The data object to get the identity from.             
             */
            getIdentity(object: Object): any;
            /**
             * Returns any metadata about the object. This may include attribution,
             * cache directives, history, or version information.
             * 
             * @param object The object to return metadata for.             
             */
            getMetadata(object: Object): Object;
            /**
             * Stores an object by its identity.
             * 
             * @param object The object to store.             
             * @param options               OptionalAdditional metadata for storing the data.  Includes a reference to an idthat the object may be stored with (i.e. { id: "foo" }).             
             */
            put(object: Object, options: Object): void;
            /**
             * Queries the store for objects.
             * 
             * @param query The query to use for retrieving objects from the store             
             * @param options               OptionalOptional options object as used by the underlying dojo.data Store.             
             */
            query(query: Object, options: Object): any;
            /**
             * Defines the query engine to use for querying the data store
             * 
             * @param query An object hash with fields that may match fields of items in the store.Values in the hash will be compared by normal == operator, but regular expressionsor any object that provides a test() method are also supported and can beused to match strings by more complex expressions(and then the regex's or object's test() method will be used to match values).             
             * @param options               OptionalAn object that contains optional information such as sort, start, and count.             
             */
            queryEngine(query: Object, options: dojo.store.api.Store.QueryOptions): any;
            /**
             * Deletes an object by its identity.
             * 
             * @param id The identity to use to delete the object             
             */
            remove(id: Object): void;
            /**
             * Starts a new transaction.
             * Note that a store user might not call transaction() prior to using put,
             * delete, etc. in which case these operations effectively could be thought of
             * as "auto-commit" style actions.
             * 
             */
            transaction(): dojo.store.api.Store.Transaction;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/Memory.html
         *
         * This is a basic in-memory object store. It implements dojo/store/api/Store.
         * 
         * @param options This provides any configuration information that will be mixed into the store.This should generally include the data property to provide the starting set of data.     
         */
        class Memory extends dojo.store.api.Store {
            constructor(options: dojo.store.Memory);
            /**
             * The array of all the objects in the memory store
             * 
             */
            "data": any[];
            /**
             * Indicates the property to use as the identity property. The values of this
             * property should be unique.
             * 
             */
            "idProperty": string;
            /**
             * An index of data indices into the data array by id
             * 
             */
            "index": Object;
            /**
             * Creates an object, throws an error if the object already exists
             * 
             * @param object The object to store.             
             * @param options               OptionalAdditional metadata for storing the data.  Includes an "id"property if a specific id is to be used.             
             */
            add(object: Object, options: dojo.store.api.Store.PutDirectives): any;
            /**
             * Retrieves an object by its identity
             * 
             * @param id The identity to use to lookup the object             
             */
            get(id: number): any;
            /**
             * Retrieves the children of an object.
             * 
             * @param parent The object to find the children of.             
             * @param options               OptionalAdditional options to apply to the retrieval of the children.             
             */
            getChildren(parent: Object, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
            /**
             * Returns an object's identity
             * 
             * @param object The object to get the identity from             
             */
            getIdentity(object: Object): any;
            /**
             * Returns any metadata about the object. This may include attribution,
             * cache directives, history, or version information.
             * 
             * @param object The object to return metadata for.             
             */
            getMetadata(object: Object): Object;
            /**
             * Stores an object
             * 
             * @param object The object to store.             
             * @param options               OptionalAdditional metadata for storing the data.  Includes an "id"property if a specific id is to be used.             
             */
            put(object: Object, options: dojo.store.api.Store.PutDirectives): any;
            /**
             * Queries the store for objects.
             * 
             * @param query The query to use for retrieving objects from the store.             
             * @param options               OptionalThe optional arguments to apply to the resultset.             
             */
            query(query: Object, options: dojo.store.api.Store.QueryOptions): any;
            /**
             * Defines the query engine to use for querying the data store
             * 
             * @param query An object hash with fields that may match fields of items in the store.Values in the hash will be compared by normal == operator, but regular expressionsor any object that provides a test() method are also supported and can beused to match strings by more complex expressions(and then the regex's or object's test() method will be used to match values).             
             * @param options               OptionalAn object that contains optional information such as sort, start, and count.             
             */
            queryEngine(query: Object, options: dojo.store.api.Store.QueryOptions): any;
            /**
             * Deletes an object by its identity
             * 
             * @param id The identity to use to delete the object             
             */
            remove(id: number): any;
            /**
             * Sets the given data as the source for this store, and indexes it
             * 
             * @param data An array of objects to use as the source of data.             
             */
            setData(data: Object[]): void;
            /**
             * Starts a new transaction.
             * Note that a store user might not call transaction() prior to using put,
             * delete, etc. in which case these operations effectively could be thought of
             * as "auto-commit" style actions.
             * 
             */
            transaction(): dojo.store.api.Store.Transaction;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/JsonRest.html
         *
         * This is a basic store for RESTful communicating with a server through JSON
         * formatted data. It implements dojo/store/api/Store.
         * 
         * @param options This provides any configuration information that will be mixed into the store     
         */
        class JsonRest extends dojo.store.api.Store {
            constructor(options: dojo.store.JsonRest);
            /**
             * Defines the Accept header to use on HTTP requests
             * 
             */
            "accepts": string;
            /**
             * The prefix to apply to sort attribute names that are ascending
             * 
             */
            "ascendingPrefix": string;
            /**
             * The prefix to apply to sort attribute names that are ascending
             * 
             */
            "descendingPrefix": string;
            /**
             * Additional headers to pass in all requests to the server. These can be overridden
             * by passing additional headers to calls to the store.
             * 
             */
            "headers": Object;
            /**
             * Indicates the property to use as the identity property. The values of this
             * property should be unique.
             * 
             */
            "idProperty": string;
            /**
             * If the store can be queried locally (on the client side in JS), this defines
             * the query engine to use for querying the data store.
             * This takes a query and query options and returns a function that can execute
             * the provided query on a JavaScript array. The queryEngine may be replace to
             * provide more sophisticated querying capabilities. For example:
             * 
             * var query = store.queryEngine({foo:"bar"}, {count:10});
             * query(someArray) -> filtered array
             * The returned query function may have a "matches" property that can be
             * 
             * used to determine if an object matches the query. For example:
             * 
             * query.matches({id:"some-object", foo:"bar"}) -> true
             * query.matches({id:"some-object", foo:"something else"}) -> false
             * 
             */
            queryEngine(query: Object, options: dojo.store.api.Store.QueryOptions): any;
            /**
             * The target base URL to use for all requests to the server. This string will be
             * prepended to the id to generate the URL (relative or absolute) for requests
             * sent to the server
             * 
             */
            "target": string;
            /**
             * Adds an object. This will trigger a PUT request to the server
             * if the object has an id, otherwise it will trigger a POST request.
             * 
             * @param object The object to store.             
             * @param options               OptionalAdditional metadata for storing the data.  Includes an "id"property if a specific id is to be used.             
             */
            add(object: Object, options: Object): any;
            /**
             * Retrieves an object by its identity. This will trigger a GET request to the server using
             * the url this.target + id.
             * 
             * @param id The identity to use to lookup the object             
             * @param options               OptionalHTTP headers. For consistency with other methods, if a headers key exists on this object, it will beused to provide HTTP headers instead.             
             */
            get(id: number, options?: Object): any;
            /**
             * Retrieves the children of an object.
             * 
             * @param parent The object to find the children of.             
             * @param options               OptionalAdditional options to apply to the retrieval of the children.             
             */
            getChildren(parent: Object, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
            /**
             * Returns an object's identity
             * 
             * @param object The object to get the identity from             
             */
            getIdentity(object: Object): any;
            /**
             * Returns any metadata about the object. This may include attribution,
             * cache directives, history, or version information.
             * 
             * @param object The object to return metadata for.             
             */
            getMetadata(object: Object): Object;
            /**
             * Stores an object. This will trigger a PUT request to the server
             * if the object has an id, otherwise it will trigger a POST request.
             * 
             * @param object The object to store.             
             * @param options               OptionalAdditional metadata for storing the data.  Includes an "id"property if a specific id is to be used.             
             */
            put(object: Object, options: Object): any;
            /**
             * Queries the store for objects. This will trigger a GET request to the server, with the
             * query added as a query string.
             * 
             * @param query The query to use for retrieving objects from the store.             
             * @param options               OptionalThe optional arguments to apply to the resultset.             
             */
            query(query: Object, options: Object): any;
            /**
             * Deletes an object by its identity. This will trigger a DELETE request to the server.
             * 
             * @param id The identity to use to delete the object             
             * @param options               OptionalHTTP headers.             
             */
            remove(id: number, options?: Object): any;
            /**
             * Starts a new transaction.
             * Note that a store user might not call transaction() prior to using put,
             * delete, etc. in which case these operations effectively could be thought of
             * as "auto-commit" style actions.
             * 
             */
            transaction(): dojo.store.api.Store.Transaction;
        }
        module api {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/api/Store.html
             *
             * This is an abstract API that data provider implementations conform to.
             * This file defines methods signatures and intentionally leaves all the
             * methods unimplemented.  For more information on the ,
             * please visit: http://dojotoolkit.org/reference-guide/dojo/store.html
             * Every method and property is optional, and is only needed if the functionality
             * it provides is required.
             * Every method may return a promise for the specified return value if the
             * execution of the operation is asynchronous (except
             * for query() which already defines an async return value).
             * 
             */
            class Store {
                constructor();
                /**
                 * If the store has a single primary key, this indicates the property to use as the
                 * identity property. The values of this property should be unique.
                 * 
                 */
                "idProperty": string;
                /**
                 * If the store can be queried locally (on the client side in JS), this defines
                 * the query engine to use for querying the data store.
                 * This takes a query and query options and returns a function that can execute
                 * the provided query on a JavaScript array. The queryEngine may be replace to
                 * provide more sophisticated querying capabilities. For example:
                 * 
                 * var query = store.queryEngine({foo:"bar"}, {count:10});
                 * query(someArray) -> filtered array
                 * The returned query function may have a "matches" property that can be
                 * 
                 * used to determine if an object matches the query. For example:
                 * 
                 * query.matches({id:"some-object", foo:"bar"}) -> true
                 * query.matches({id:"some-object", foo:"something else"}) -> false
                 * 
                 */
                queryEngine(query: Object, options: dojo.store.api.Store.QueryOptions): any;
                /**
                 * Creates an object, throws an error if the object already exists
                 * 
                 * @param object The object to store.             
                 * @param directives               OptionalAdditional directives for creating objects.             
                 */
                add(object: Object, directives: dojo.store.api.Store.PutDirectives): any;
                /**
                 * Retrieves an object by its identity
                 * 
                 * @param id The identity to use to lookup the object             
                 */
                get(id: number): Object;
                /**
                 * Retrieves the children of an object.
                 * 
                 * @param parent The object to find the children of.             
                 * @param options               OptionalAdditional options to apply to the retrieval of the children.             
                 */
                getChildren(parent: Object, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
                /**
                 * Returns an object's identity
                 * 
                 * @param object The object to get the identity from             
                 */
                getIdentity(object: Object): any;
                /**
                 * Returns any metadata about the object. This may include attribution,
                 * cache directives, history, or version information.
                 * 
                 * @param object The object to return metadata for.             
                 */
                getMetadata(object: Object): Object;
                /**
                 * Stores an object
                 * 
                 * @param object The object to store.             
                 * @param directives               OptionalAdditional directives for storing objects.             
                 */
                put(object: Object, directives: dojo.store.api.Store.PutDirectives): any;
                /**
                 * 
                 */
                PutDirectives(): void;
                /**
                 * Queries the store for objects. This does not alter the store, but returns a
                 * set of data from the store.
                 * 
                 * @param query The query to use for retrieving objects from the store.             
                 * @param options The optional arguments to apply to the resultset.             
                 */
                query(query: String, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
                /**
                 * Queries the store for objects. This does not alter the store, but returns a
                 * set of data from the store.
                 * 
                 * @param query The query to use for retrieving objects from the store.             
                 * @param options The optional arguments to apply to the resultset.             
                 */
                query(query: Object, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
                /**
                 * Queries the store for objects. This does not alter the store, but returns a
                 * set of data from the store.
                 * 
                 * @param query The query to use for retrieving objects from the store.             
                 * @param options The optional arguments to apply to the resultset.             
                 */
                query(query: Function, options: dojo.store.api.Store.QueryOptions): dojo.store.api.Store.QueryResults;
                /**
                 * 
                 */
                QueryOptions(): void;
                /**
                 * 
                 */
                QueryResults(): void;
                /**
                 * Deletes an object by its identity
                 * 
                 * @param id The identity to use to delete the object             
                 */
                remove(id: number): void;
                /**
                 * 
                 */
                SortInformation(): void;
                /**
                 * Starts a new transaction.
                 * Note that a store user might not call transaction() prior to using put,
                 * delete, etc. in which case these operations effectively could be thought of
                 * as "auto-commit" style actions.
                 * 
                 */
                transaction(): dojo.store.api.Store.Transaction;
                /**
                 * 
                 */
                Transaction(): void;
            }
            module Store {
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/api/Store.PutDirectives.html
                 *
                 * Directives passed to put() and add() handlers for guiding the update and
                 * creation of stored objects.
                 * 
                 */
                class PutDirectives {
                    constructor();
                    /**
                     * If the collection of objects in the store has a natural ordering,
                     * this indicates that the created or updated object should be placed before the
                     * object specified by the value of this property. A value of null indicates that the
                     * object should be last.
                     * 
                     */
                    "before": Object;
                    /**
                     * Indicates the identity of the object if a new object is created
                     * 
                     */
                    "id": string;
                    /**
                     * If this is provided as a boolean it indicates that the object should or should not
                     * overwrite an existing object. A value of true indicates that a new object
                     * should not be created, the operation should update an existing object. A
                     * value of false indicates that an existing object should not be updated, a new
                     * object should be created (which is the same as an add() operation). When
                     * this property is not provided, either an update or creation is acceptable.
                     * 
                     */
                    "overwrite": boolean;
                    /**
                     * If the store is hierarchical (with single parenting) this property indicates the
                     * new parent of the created or updated object.
                     * 
                     */
                    "parent": Object;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/api/Store.QueryOptions.html
                 *
                 * Optional object with additional parameters for query results.
                 * 
                 */
                class QueryOptions {
                    constructor();
                    /**
                     * The number of how many results should be returned.
                     * 
                     */
                    "count": number;
                    /**
                     * A list of attributes to sort on, as well as direction
                     * For example:
                     * 
                     * [{attribute:"price, descending: true}].
                     * If the sort parameter is omitted, then the natural order of the store may be
                     * 
                     * applied if there is a natural order.
                     * 
                     */
                    "sort": Object;
                    /**
                     * The first result to begin iteration on
                     * 
                     */
                    "start": number;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/api/Store.QueryResults.html
                 *
                 * This is an object returned from query() calls that provides access to the results
                 * of a query. Queries may be executed asynchronously.
                 * 
                 */
                class QueryResults {
                    constructor();
                    /**
                     * This property should be included in if the query options included the "count"
                     * property limiting the result set. This property indicates the total number of objects
                     * matching the query (as if "start" and "count" weren't present). This may be
                     * a promise if the query is asynchronous.
                     * 
                     */
                    "total": number;
                    /**
                     * Filters the query results, based on
                     * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/filter.
                     * Note that this may executed asynchronously. The callback may be called
                     * after this function returns.
                     * 
                     * @param callback Function that is called for each object in the query results             
                     * @param thisObject The object to use as |this| in the callback.             
                     */
                    filter(callback: any, thisObject: any): dojo.store.api.Store.QueryResults;
                    /**
                     * Iterates over the query results, based on
                     * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/forEach.
                     * Note that this may executed asynchronously. The callback may be called
                     * after this function returns.
                     * 
                     * @param callback Function that is called for each object in the query results             
                     * @param thisObject The object to use as |this| in the callback.             
                     */
                    forEach(callback: any, thisObject: any): void;
                    /**
                     * Maps the query results, based on
                     * https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map.
                     * Note that this may executed asynchronously. The callback may be called
                     * after this function returns.
                     * 
                     * @param callback Function that is called for each object in the query results             
                     * @param thisObject The object to use as |this| in the callback.             
                     */
                    map(callback: any, thisObject: any): dojo.store.api.Store.QueryResults;
                    /**
                     * This registers a callback for notification of when data is modified in the query results.
                     * This is an optional method, and is usually provided by dojo/store/Observable.
                     * 
                     * @param listener The listener function is called when objects in the query results are modifiedto affect the query result. The listener function is called with the following arguments:listener(object, removedFrom, insertedInto);The object parameter indicates the object that was create, modified, or deleted.The removedFrom parameter indicates the index in the result array wherethe object used to be. If the value is -1, then the object is an addition tothis result set (due to a new object being created, or changed such that itis a part of the result set).The insertedInto parameter indicates the index in the result array wherethe object should be now. If the value is -1, then the object is a removalfrom this result set (due to an object being deleted, or changed such that itis not a part of the result set).             
                     * @param includeAllUpdates This indicates whether or not to include object updates that do not affectthe inclusion or order of the object in the query results. By default this is false,which means that if any object is updated in such a way that it remainsin the result set and it's position in result sets is not affected, then the listenerwill not be fired.             
                     */
                    observe(listener: Function, includeAllUpdates: any): void;
                    /**
                     * This registers a callback for when the query is complete, if the query is asynchronous.
                     * This is an optional method, and may not be present for synchronous queries.
                     * 
                     * @param callback This is called when the query is completed successfully, and is passed a single argumentthat is an array representing the query results.             
                     * @param errorHandler This is called if the query failed, and is passed a single argument that is the errorfor the failure.             
                     */
                    then(callback: any, errorHandler: any): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/api/Store.SortInformation.html
                 *
                 * An object describing what attribute to sort on, and the direction of the sort.
                 * 
                 */
                class SortInformation {
                    constructor();
                    /**
                     * The name of the attribute to sort on.
                     * 
                     */
                    "attribute": string;
                    /**
                     * The direction of the sort.  Default is false.
                     * 
                     */
                    "descending": boolean;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/api/Store.Transaction.html
                 *
                 * This is an object returned from transaction() calls that represents the current
                 * transaction.
                 * 
                 */
                class Transaction {
                    constructor();
                    /**
                     * Aborts the transaction. This may throw an error if it fails. Of if the operation
                     * is asynchronous, it may return a promise that represents the eventual success
                     * or failure of the abort.
                     * 
                     * @param callback             
                     * @param thisObject             
                     */
                    abort(callback: any, thisObject: any): void;
                    /**
                     * Commits the transaction. This may throw an error if it fails. Of if the operation
                     * is asynchronous, it may return a promise that represents the eventual success
                     * or failure of the commit.
                     * 
                     */
                    commit(): void;
                }
            }

        }

        module util {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/util/QueryResults.html
             *
             * A function that wraps the results of a store query with additional
             * methods.
             * QueryResults is a basic wrapper that allows for array-like iteration
             * over any kind of returned data from a query.  While the simplest store
             * will return a plain array of data, other stores may return deferreds or
             * promises; this wrapper makes sure that all results can be treated
             * the same.
             * 
             * Additional methods include forEach, filter and map.
             * 
             * @param results The result set as an array, or a promise for an array.     
             */
            interface QueryResults{(results: any[]): void}
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/util/QueryResults.html
             *
             * A function that wraps the results of a store query with additional
             * methods.
             * QueryResults is a basic wrapper that allows for array-like iteration
             * over any kind of returned data from a query.  While the simplest store
             * will return a plain array of data, other stores may return deferreds or
             * promises; this wrapper makes sure that all results can be treated
             * the same.
             * 
             * Additional methods include forEach, filter and map.
             * 
             * @param results The result set as an array, or a promise for an array.     
             */
            interface QueryResults{(results: dojo.promise.Promise<any>): void}
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/store/util/SimpleQueryEngine.html
             *
             * Simple query engine that matches using filter functions, named filter
             * functions or objects by name-value on a query object hash
             * The SimpleQueryEngine provides a way of getting a QueryResults through
             * the use of a simple object hash as a filter.  The hash will be used to
             * match properties on data objects with the corresponding value given. In
             * other words, only exact matches will be returned.
             * 
             * This function can be used as a template for more complex query engines;
             * for example, an engine can be created that accepts an object hash that
             * contains filtering functions, or a string that gets evaluated, etc.
             * 
             * When creating a new dojo.store, simply set the store's queryEngine
             * field as a reference to this function.
             * 
             * @param query An object hash with fields that may match fields of items in the store.Values in the hash will be compared by normal == operator, but regular expressionsor any object that provides a test() method are also supported and can beused to match strings by more complex expressions(and then the regex's or object's test() method will be used to match values).     
             * @param options       OptionalAn object that contains optional information such as sort, start, and count.     
             */
            interface SimpleQueryEngine{(query: Object, options?: dojo.store.api.Store.QueryOptions): void}
        }

    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/date.html
     *
     * Date manipulation utilities
     * 
     */
    interface date {
        /**
         * Add to a Date in intervals of different size, from milliseconds to years
         * 
         * @param date Date object to start with             
         * @param interval A string representing the interval.  One of the following:"year", "month", "day", "hour", "minute", "second","millisecond", "quarter", "week", "weekday"             
         * @param amount How much to add to the date.             
         */
        add(date: Date, interval: String, amount: number): any;
        /**
         * Compare two date objects by date, time, or both.
         * Returns 0 if equal, positive if a > b, else negative.
         * 
         * @param date1 Date object             
         * @param date2               OptionalDate object.  If not specified, the current Date is used.             
         * @param portion               OptionalA string indicating the "date" or "time" portion of a Date object.Compares both "date" and "time" by default.  One of the following:"date", "time", "datetime"             
         */
        compare(date1: Date, date2: Date, portion: String): number;
        /**
         * Get the difference in a specific unit of time (e.g., number of
         * months, weeks, days, etc.) between two dates, rounded to the
         * nearest integer.
         * 
         * @param date1 Date object             
         * @param date2               OptionalDate object.  If not specified, the current Date is used.             
         * @param interval               OptionalA string representing the interval.  One of the following:"year", "month", "day", "hour", "minute", "second","millisecond", "quarter", "week", "weekday"Defaults to "day".             
         */
        difference(date1: Date, date2: Date, interval: String): any;
        /**
         * Returns the number of days in the month used by dateObject
         * 
         * @param dateObject             
         */
        getDaysInMonth(dateObject: Date): number;
        /**
         * Get the user's time zone as provided by the browser
         * Try to get time zone info from toString or toLocaleString method of
         * the Date object -- UTC offset is not a time zone.  See
         * http://www.twinsun.com/tz/tz-link.htm Note: results may be
         * inconsistent across browsers.
         * 
         * @param dateObject Needed because the timezone may vary with time (daylight savings)             
         */
        getTimezoneName(dateObject: Date): any;
        /**
         * Determines if the year of the dateObject is a leap year
         * Leap years are years with an additional day YYYY-02-29, where the
         * year number is a multiple of four with the following exception: If
         * a year is a multiple of 100, then it is only a leap year if it is
         * also a multiple of 400. For example, 1900 was not a leap year, but
         * 2000 is one.
         * 
         * @param dateObject             
         */
        isLeapYear(dateObject: Date): boolean;
    }
    module date {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/date/stamp.html
         *
         * TODOC
         * 
         */
        interface stamp {
            /**
             * Returns a Date object given a string formatted according to a subset of the ISO-8601 standard.
             * Accepts a string formatted according to a profile of ISO8601 as defined by
             * RFC3339, except that partial input is allowed.
             * Can also process dates as specified by the W3C
             * The following combinations are valid:
             * 
             * dates only
             * yyyy
             * yyyy-MM
             * yyyy-MM-dd
             * 
             * times only, with an optional time zone appended
             * THH:mm
             * THH:mm:ss
             * THH:mm:ss.SSS
             * 
             * and "datetimes" which could be any combination of the above
             * timezones may be specified as Z (for UTC) or +/- followed by a time expression HH:mm
             * Assumes the local time zone if not specified.  Does not validate.  Improperly formatted
             * input may return null.  Arguments which are out of bounds will be handled
             * by the Date constructor (e.g. January 32nd typically gets resolved to February 1st)
             * Only years between 100 and 9999 are supported.
             * 
             * @param formattedString A string such as 2005-06-30T08:05:00-07:00 or 2005-06-30 or T08:05:00             
             * @param defaultTime               OptionalUsed for defaults for fields omitted in the formattedString.Uses 1970-01-01T00:00:00.0Z by default.             
             */
            fromISOString(formattedString: String, defaultTime: number): any;
            /**
             * Format a Date object as a string according a subset of the ISO-8601 standard
             * When options.selector is omitted, output follows RFC3339
             * The local time zone is included as an offset from GMT, except when selector=='time' (time without a date)
             * Does not check bounds.  Only years between 100 and 9999 are supported.
             * 
             * @param dateObject A Date object             
             * @param options               OptionalAn object with the following properties:selector (String): "date" or "time" for partial formatting of the Date object.Both date and time will be formatted by default.zulu (Boolean): if true, UTC/GMT is used for a timezonemilliseconds (Boolean): if true, output milliseconds            
             */
            toISOString(dateObject: Date, options: Object): any;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/date/locale.html
         *
         * This modules defines dojo/date/locale, localization methods for Date.
         * 
         */
        interface locale {
            /**
             * Add a reference to a bundle containing localized custom formats to be
             * used by date/time formatting and parsing routines.
             * The user may add custom localized formats where the bundle has properties following the
             * same naming convention used by dojo.cldr: dateFormat-xxxx / timeFormat-xxxx
             * The pattern string should match the format used by the CLDR.
             * See dojo/date/locale.format() for details.
             * The resources must be loaded by dojo.requireLocalization() prior to use
             * 
             * @param packageName             
             * @param bundleName             
             */
            addCustomFormats(packageName: String, bundleName: String): void;
            /**
             * Format a Date object as a String, using locale-specific settings.
             * Create a string from a Date object using a known localized pattern.
             * By default, this method formats both date and time from dateObject.
             * Formatting patterns are chosen appropriate to the locale.  Different
             * formatting lengths may be chosen, with "full" used by default.
             * Custom patterns may be used or registered with translations using
             * the dojo/date/locale.addCustomFormats() method.
             * Formatting patterns are implemented using the syntax described at
             * unicode.org
             * 
             * @param dateObject the date and/or time to be formatted.  If a time only is formatted,the values in the year, month, and day fields are irrelevant.  Theopposite is true when formatting only dates.             
             * @param options               OptionalAn object with the following properties:selector (String): choice of 'time','date' (default: date and time)formatLength (String): choice of long, short, medium or full (plus any custom additions).  Defaults to 'short'datePattern (String): override pattern with this stringtimePattern (String): override pattern with this stringam (String): override strings for am in timespm (String): override strings for pm in timeslocale (String): override the locale used to determine formatting rulesfullYear (Boolean): (format only) use 4 digit years whenever 2 digit years are called forstrict (Boolean): (parse only) strict parsing, off by default            
             */
            format(dateObject: Date, options: Object): any;
            /**
             * Used to get localized strings from dojo.cldr for day or month names.
             * 
             * @param item 'months' || 'days'             
             * @param type 'wide' || 'abbr' || 'narrow' (e.g. "Monday", "Mon", or "M" respectively, in English)             
             * @param context               Optional'standAlone' || 'format' (default)             
             * @param locale               Optionaloverride locale used to find the names             
             */
            getNames(item: String, type: String, context: String, locale: String): any;
            /**
             * Determines if the date falls on a weekend, according to local custom.
             * 
             * @param dateObject               Optional            
             * @param locale               Optional            
             */
            isWeekend(dateObject: Date, locale: String): boolean;
            /**
             * Convert a properly formatted string to a primitive Date object,
             * using locale-specific settings.
             * Create a Date object from a string using a known localized pattern.
             * By default, this method parses looking for both date and time in the string.
             * Formatting patterns are chosen appropriate to the locale.  Different
             * formatting lengths may be chosen, with "full" used by default.
             * Custom patterns may be used or registered with translations using
             * the dojo/date/locale.addCustomFormats() method.
             * 
             * Formatting patterns are implemented using the syntax described at
             * unicode.org
             * When two digit years are used, a century is chosen according to a sliding
             * window of 80 years before and 20 years after present year, for both yy and yyyy patterns.
             * year < 100CE requires strict mode.
             * 
             * @param value A string representation of a date             
             * @param options               OptionalAn object with the following properties:selector (String): choice of 'time','date' (default: date and time)formatLength (String): choice of long, short, medium or full (plus any custom additions).  Defaults to 'short'datePattern (String): override pattern with this stringtimePattern (String): override pattern with this stringam (String): override strings for am in timespm (String): override strings for pm in timeslocale (String): override the locale used to determine formatting rulesfullYear (Boolean): (format only) use 4 digit years whenever 2 digit years are called forstrict (Boolean): (parse only) strict parsing, off by default            
             */
            parse(value: String, options: Object): any;
            /**
             * Builds the regular needed to parse a localized date
             * 
             * @param options               OptionalAn object with the following properties:selector (String): choice of 'time','date' (default: date and time)formatLength (String): choice of long, short, medium or full (plus any custom additions).  Defaults to 'short'datePattern (String): override pattern with this stringtimePattern (String): override pattern with this stringam (String): override strings for am in timespm (String): override strings for pm in timeslocale (String): override the locale used to determine formatting rulesfullYear (Boolean): (format only) use 4 digit years whenever 2 digit years are called forstrict (Boolean): (parse only) strict parsing, off by default            
             */
            regexp(options: Object): any;
        }
        module locale {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojo/date/locale.__FormatOptions.html
             *
             * 
             */
            class __FormatOptions {
                constructor();
                /**
                 * override strings for am in times
                 * 
                 */
                "am": string;
                /**
                 * override pattern with this string
                 * 
                 */
                "datePattern": string;
                /**
                 * choice of long, short, medium or full (plus any custom additions).  Defaults to 'short'
                 * 
                 */
                "formatLength": string;
                /**
                 * (format only) use 4 digit years whenever 2 digit years are called for
                 * 
                 */
                "fullYear": boolean;
                /**
                 * override the locale used to determine formatting rules
                 * 
                 */
                "locale": string;
                /**
                 * override strings for pm in times
                 * 
                 */
                "pm": string;
                /**
                 * choice of 'time','date' (default: date and time)
                 * 
                 */
                "selector": string;
                /**
                 * (parse only) strict parsing, off by default
                 * 
                 */
                "strict": boolean;
                /**
                 * override pattern with this string
                 * 
                 */
                "timePattern": string;
            }
        }

    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/fx.html
     *
     * Effects library on top of Base animations
     * 
     */
    interface fx {
        /**
         * Collection of easing functions to use beyond the default
         * dojo._defaultEasing function.
         * 
         */
        easing: Object;
        /**
         * Chain a list of dojo/_base/fx.Animations to run in sequence
         * Return a dojo/_base/fx.Animation which will play all passed
         * dojo/_base/fx.Animation instances in sequence, firing its own
         * synthesized events simulating a single animation. (eg:
         * onEnd of this animation means the end of the chain,
         * not the individual animations within)
         * 
         * @param animations             
         */
        chain(animations: dojo._base.fx.Animation[]): any;
        /**
         * Combine a list of dojo/_base/fx.Animations to run in parallel
         * Combine an array of dojo/_base/fx.Animations to run in parallel,
         * providing a new dojo/_base/fx.Animation instance encompasing each
         * animation, firing standard animation events.
         * 
         * @param animations             
         */
        combine(animations: dojo._base.fx.Animation[]): any;
        /**
         * Slide a node to a new top/left position
         * Returns an animation that will slide "node"
         * defined in args Object from its current position to
         * the position defined by (args.left, args.top).
         * 
         * @param args A hash-map of standard dojo/_base/fx.Animation constructor properties(such as easing: node: duration: and so on). Special args membersare top and left, which indicate the new position to slide to.             
         */
        slideTo(args: Object): any;
        /**
         * 
         */
        Toggler(): void;
        /**
         * Expand a node to it's natural height.
         * Returns an animation that will expand the
         * node defined in 'args' object from it's current height to
         * it's natural height (with no scrollbar).
         * Node must have no margin/border/padding.
         * 
         * @param args A hash-map of standard dojo/_base/fx.Animation constructor properties(such as easing: node: duration: and so on)             
         */
        wipeIn(args: Object): any;
        /**
         * Shrink a node to nothing and hide it.
         * Returns an animation that will shrink node defined in "args"
         * from it's current height to 1px, and then hide it.
         * 
         * @param args A hash-map of standard dojo/_base/fx.Animation constructor properties(such as easing: node: duration: and so on)             
         */
        wipeOut(args: Object): any;
    }
    module fx {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/fx/Toggler.html
         *
         * A simple dojo.Animation toggler API.
         * class constructor for an animation toggler. It accepts a packed
         * set of arguments about what type of animation to use in each
         * direction, duration, etc. All available members are mixed into
         * these animations from the constructor (for example, node,
         * showDuration, hideDuration).
         * 
         * @param args     
         */
        class Toggler {
            constructor(args: any);
            /**
             * Time in milliseconds to run the hide Animation
             * 
             */
            "hideDuration": number;
            /**
             * the node to target for the showing and hiding animations
             * 
             */
            "node": HTMLElement;
            /**
             * Time in milliseconds to run the show Animation
             * 
             */
            "showDuration": number;
            /**
             * Toggle the node to hidden
             * 
             * @param delay               OptionalAmount of time to stall playing the hide animation             
             */
            hide(delay: number): any;
            /**
             * The function that returns the dojo.Animation to hide the node
             * 
             * @param args An object with the following properties:node (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            hideFunc(args: Object): any;
            /**
             * Toggle the node to showing
             * 
             * @param delay               OptionalAmount of time to stall playing the show animation             
             */
            show(delay: number): any;
            /**
             * The function that returns the dojo.Animation to show the node
             * 
             * @param args An object with the following properties:node (DOMNode|String): The node referenced in the animationduration (Integer, optional): Duration of the animation in milliseconds.easing (Function, optional): An easing function.            
             */
            showFunc(args: Object): any;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/fx/easing.html
         *
         * Collection of easing functions to use beyond the default
         * dojo._defaultEasing function.
         * Easing functions are used to manipulate the iteration through
         * an dojo.Animations _Line. _Line being the properties of an Animation,
         * and the easing function progresses through that Line determining
         * how quickly (or slowly) it should go. Or more accurately: modify
         * the value of the _Line based on the percentage of animation completed.
         * 
         * All functions follow a simple naming convention of "ease type" + "when".
         * If the name of the function ends in Out, the easing described appears
         * towards the end of the animation. "In" means during the beginning,
         * and InOut means both ranges of the Animation will applied, both
         * beginning and end.
         * 
         * One does not call the easing function directly, it must be passed to
         * the easing property of an animation.
         * 
         */
        interface easing {
            /**
             * An easing function that starts away from the target,
             * and quickly accelerates towards the end value.
             * 
             * Use caution when the easing will cause values to become
             * negative as some properties cannot be set to negative values.
             * 
             * @param n               Optional            
             */
            backIn(n: number): number;
            /**
             * An easing function combining the effects of backIn and backOut
             * An easing function combining the effects of backIn and backOut.
             * Use caution when the easing will cause values to become negative
             * as some properties cannot be set to negative values.
             * 
             * @param n               Optional            
             */
            backInOut(n: number): number;
            /**
             * An easing function that pops past the range briefly, and slowly comes back.
             * An easing function that pops past the range briefly, and slowly comes back.
             * 
             * Use caution when the easing will cause values to become negative as some
             * properties cannot be set to negative values.
             * 
             * @param n               Optional            
             */
            backOut(n: number): number;
            /**
             * An easing function that 'bounces' near the beginning of an Animation
             * 
             * @param n               Optional            
             */
            bounceIn(n: number): number;
            /**
             * An easing function that 'bounces' at the beginning and end of the Animation
             * 
             * @param n               Optional            
             */
            bounceInOut(n: number): number;
            /**
             * An easing function that 'bounces' near the end of an Animation
             * 
             * @param n               Optional            
             */
            bounceOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            circIn(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            circInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            circOut(n: number): any;
            /**
             * 
             * @param n               Optional            
             */
            cubicIn(n: number): any;
            /**
             * 
             * @param n               Optional            
             */
            cubicInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            cubicOut(n: number): number;
            /**
             * An easing function the elastically snaps from the start value
             * An easing function the elastically snaps from the start value
             * 
             * Use caution when the elasticity will cause values to become negative
             * as some properties cannot be set to negative values.
             * 
             * @param n               Optional            
             */
            elasticIn(n: number): number;
            /**
             * An easing function that elasticly snaps around the value, near
             * the beginning and end of the Animation.
             * An easing function that elasticly snaps around the value, near
             * the beginning and end of the Animation.
             * 
             * Use caution when the elasticity will cause values to become
             * negative as some properties cannot be set to negative values.
             * 
             * @param n               Optional            
             */
            elasticInOut(n: number): number;
            /**
             * An easing function that elasticly snaps around the target value,
             * near the end of the Animation
             * An easing function that elasticly snaps around the target value,
             * near the end of the Animation
             * 
             * Use caution when the elasticity will cause values to become
             * negative as some properties cannot be set to negative values.
             * 
             * @param n               Optional            
             */
            elasticOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            expoIn(n: number): any;
            /**
             * 
             * @param n               Optional            
             */
            expoInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            expoOut(n: number): number;
            /**
             * A linear easing function
             * 
             * @param n               Optional            
             */
            linear(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            quadIn(n: number): any;
            /**
             * 
             * @param n               Optional            
             */
            quadInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            quadOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            quartIn(n: number): any;
            /**
             * 
             * @param n               Optional            
             */
            quartInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            quartOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            quintIn(n: number): any;
            /**
             * 
             * @param n               Optional            
             */
            quintInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            quintOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            sineIn(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            sineInOut(n: number): number;
            /**
             * 
             * @param n               Optional            
             */
            sineOut(n: number): any;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/router.html
     *
     * A singleton-style instance of dojo/router/RouterBase. See that
     * module for specifics.
     * 
     */
    interface router extends dojo.router.RouterBase {
    }
    module router {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/router/RouterBase.html
         *
         * A module that allows one to easily map hash-based structures into
         * callbacks. The router module is a singleton, offering one central
         * point for all registrations of this type.
         * 
         * @param kwArgs     
         */
        class RouterBase {
            constructor(kwArgs: any);
            /**
             * 
             */
            "globMatch": RegExp;
            /**
             * 
             */
            "globReplacement": string;
            /**
             * 
             */
            "idMatch": RegExp;
            /**
             * 
             */
            "idReplacement": string;
            /**
             * 
             */
            destroy(): void;
            /**
             * A simple pass-through to make changing the hash easy,
             * without having to require dojo/hash directly. It also
             * synchronously fires off any routes that match.
             * 
             * @param path             
             * @param replace             
             */
            go(path: string, replace?: boolean): any;
            /**
             * Registers a route to a handling callback
             * Given either a string or a regular expression, the router
             * will monitor the page's hash and respond to changes that
             * match the string or regex as provided.
             * 
             * When provided a regex for the route:
             * 
             * Matching is performed, and the resulting capture groups
             * are passed through to the callback as an array.
             * When provided a string for the route:
             * 
             * The string is parsed as a URL-like structure, like
             * "/foo/bar"
             * If any portions of that URL are prefixed with a colon
             * (:), they will be parsed out and provided to the callback
             * as properties of an object.
             * If the last piece of the URL-like structure is prefixed
             * with a star (*) instead of a colon, it will be replaced in
             * the resulting regex with a greedy (.+) match and
             * anything remaining on the hash will be provided as a
             * property on the object passed into the callback. Think of
             * it like a basic means of globbing the end of a route.
             * 
             * @param route A string or regular expression which will be used whenmonitoring hash changes.             
             * @param callback When the hash matches a pattern as described in the route,this callback will be executed. It will receive an eventobject that will have several properties:params: Either an array or object of properties pulledfrom the new hasholdPath: The hash in its state before the changenewPath: The new hash being shifted topreventDefault: A method that will stop hash changesfrom being actually applied to the active hash. This onlyworks if the hash change was initiated using router.go,as changes initiated more directly to the location.hashproperty will already be in placestopImmediatePropagation: When called, will stop anyfurther bound callbacks on this particular route frombeing executed. If two distinct routes are bound that aredifferent, but both happen to match the current hash insome way, this will not keep other routes from receivingnotice of the change.             
             */
            register(route: String, callback: Function): any;
            /**
             * Registers a route to a handling callback
             * Given either a string or a regular expression, the router
             * will monitor the page's hash and respond to changes that
             * match the string or regex as provided.
             * 
             * When provided a regex for the route:
             * 
             * Matching is performed, and the resulting capture groups
             * are passed through to the callback as an array.
             * When provided a string for the route:
             * 
             * The string is parsed as a URL-like structure, like
             * "/foo/bar"
             * If any portions of that URL are prefixed with a colon
             * (:), they will be parsed out and provided to the callback
             * as properties of an object.
             * If the last piece of the URL-like structure is prefixed
             * with a star (*) instead of a colon, it will be replaced in
             * the resulting regex with a greedy (.+) match and
             * anything remaining on the hash will be provided as a
             * property on the object passed into the callback. Think of
             * it like a basic means of globbing the end of a route.
             * 
             * @param route A string or regular expression which will be used whenmonitoring hash changes.             
             * @param callback When the hash matches a pattern as described in the route,this callback will be executed. It will receive an eventobject that will have several properties:params: Either an array or object of properties pulledfrom the new hasholdPath: The hash in its state before the changenewPath: The new hash being shifted topreventDefault: A method that will stop hash changesfrom being actually applied to the active hash. This onlyworks if the hash change was initiated using router.go,as changes initiated more directly to the location.hashproperty will already be in placestopImmediatePropagation: When called, will stop anyfurther bound callbacks on this particular route frombeing executed. If two distinct routes are bound that aredifferent, but both happen to match the current hash insome way, this will not keep other routes from receivingnotice of the change.             
             */
            register(route: RegExp, callback: Function): any;
            /**
             * Registers a route to a handling callback, except before
             * any previously registered callbacks
             * Much like the register method, registerBefore allows
             * us to register route callbacks to happen before any
             * previously registered callbacks. See the documentation for
             * register for more details and examples.
             * 
             * @param route             
             * @param callback             
             */
            registerBefore(route: String, callback: Function): any;
            /**
             * Registers a route to a handling callback, except before
             * any previously registered callbacks
             * Much like the register method, registerBefore allows
             * us to register route callbacks to happen before any
             * previously registered callbacks. See the documentation for
             * register for more details and examples.
             * 
             * @param route             
             * @param callback             
             */
            registerBefore(route: RegExp, callback: Function): any;
            /**
             * This method must be called to activate the router. Until
             * startup is called, no hash changes will trigger route
             * callbacks.
             * 
             * @param defaultPath             
             */
            startup(defaultPath: any): void;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/aspect.html
     *
     * provides aspect oriented programming functionality, allowing for
     * one to add before, around, or after advice on existing methods.
     * 
     */
    interface aspect {
        /**
         * The "after" export of the aspect module is a function that can be used to attach
         * "after" advice to a method. This function will be executed after the original method
         * is executed. By default the function will be called with a single argument, the return
         * value of the original method, or the the return value of the last executed advice (if a previous one exists).
         * The fourth (optional) argument can be set to true to so the function receives the original
         * arguments (from when the original method was called) rather than the return value.
         * If there are multiple "after" advisors, they are executed in the order they were registered.
         * 
         * @param target This is the target object             
         * @param methodName This is the name of the method to attach to.             
         * @param advice This is function to be called after the original method             
         * @param receiveArguments               OptionalIf this is set to true, the advice function receives the original arguments (from when the original mehtodwas called) rather than the return value of the original/previous method.             
         */
        after(target: Object, methodName: String, advice: Function, receiveArguments: boolean): any;
        /**
         * The "around" export of the aspect module is a function that can be used to attach
         * "around" advice to a method. The advisor function is immediately executed when
         * the around() is called, is passed a single argument that is a function that can be
         * called to continue execution of the original method (or the next around advisor).
         * The advisor function should return a function, and this function will be called whenever
         * the method is called. It will be called with the arguments used to call the method.
         * Whatever this function returns will be returned as the result of the method call (unless after advise changes it).
         * 
         * @param target This is the target object             
         * @param methodName This is the name of the method to attach to.             
         * @param advice This is function to be called around the original method             
         */
        around(target: Object, methodName: String, advice: Function): void;
        /**
         * The "before" export of the aspect module is a function that can be used to attach
         * "before" advice to a method. This function will be executed before the original method
         * is executed. This function will be called with the arguments used to call the method.
         * This function may optionally return an array as the new arguments to use to call
         * the original method (or the previous, next-to-execute before advice, if one exists).
         * If the before method doesn't return anything (returns undefined) the original arguments
         * will be preserved.
         * If there are multiple "before" advisors, they are executed in the reverse order they were registered.
         * 
         * @param target This is the target object             
         * @param methodName This is the name of the method to attach to.             
         * @param advice This is function to be called before the original method             
         */
        before(target: Object, methodName: String, advice: Function): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/back.html
     *
     * Browser history management resources
     * 
     */
    interface back {
        /**
         * adds a state object (args) to the history list.
         * To support getting back button notifications, the object
         * argument should implement a function called either "back",
         * "backButton", or "handle". The string "back" will be passed as
         * the first and only argument to this callback.
         * 
         * To support getting forward button notifications, the object
         * argument should implement a function called either "forward",
         * "forwardButton", or "handle". The string "forward" will be
         * passed as the first and only argument to this callback.
         * 
         * If you want the browser location string to change, define "changeUrl" on the object. If the
         * value of "changeUrl" is true, then a unique number will be appended to the URL as a fragment
         * identifier (http://some.domain.com/path#uniquenumber). If it is any other value that does
         * not evaluate to false, that value will be used as the fragment identifier. For example,
         * if changeUrl: 'page1', then the URL will look like: http://some.domain.com/path#page1
         * 
         * There are problems with using dojo/back with semantically-named fragment identifiers
         * ("hash values" on an URL). In most browsers it will be hard for dojo/back to know
         * distinguish a back from a forward event in those cases. For back/forward support to
         * work best, the fragment ID should always be a unique value (something using new Date().getTime()
         * for example). If you want to detect hash changes using semantic fragment IDs, then
         * consider using dojo/hash instead (in Dojo 1.4+).
         * 
         * @param args The state object that will be added to the history list.             
         */
        addToHistory(args: Object): void;
        /**
         * 
         */
        getHash(): any;
        /**
         * private method. Do not call this directly.
         * 
         */
        goBack(): void;
        /**
         * private method. Do not call this directly.
         * 
         */
        goForward(): void;
        /**
         * Initializes the undo stack. This must be called from a 
         * block that lives inside the <code>&lt;body&gt;</code> tag to prevent bugs on IE.
         * </p>
         * <p>Only call this method before the page&#39;s DOM is finished loading. Otherwise
         * it will not work. Be careful with xdomain loading or djConfig.debugAtAllCosts scenarios,
         * in order for this method to work, dojo/back will need to be part of a build layer.</p>
         * </div>
         *       </div>
         *       <div class="jsdoc-field">
         *         <div class="jsdoc-title"><a name="1_9dojo_back_setHash"></a><span class="functionIcon">setHash</span><span class="parameters">(h)</span> 
         *         </div>
         *         <div class="jsdoc-inheritance">Defined by <a href="/api/1.9/dojo/back" class="jsdoc-link">dojo/back</a>
         *         </div>
         *         <div class="jsdoc-full-summary"></div>
         *         <table class="jsdoc-parameters">
         *           <tr>
         *             <th>Parameter</th>
         *             <th>Type</th>
         *             <th>Description</th>
         *           </tr>
         *           <tr>
         *             <td class="jsdoc-param-name">h</td>
         *             <td class="jsdoc-param-type">undefined</td>
         *             <td class="jsdoc-param-description">
         *             </td>
         *           </tr>
         *         </table>
         *       </div>
         *       <div class="jsdoc-field">
         *         <div class="jsdoc-title"><a name="1_9dojo_back_setInitialState"></a><span class="functionIcon">setInitialState</span><span class="parameters">(args)</span> 
         *         </div>
         *         <div class="jsdoc-inheritance">Defined by <a href="/api/1.9/dojo/back" class="jsdoc-link">dojo/back</a>
         *         </div>
         *         <div class="jsdoc-full-summary"><p>Sets the state object and back callback for the very first page
         * that is loaded.
         * </p>
         * <p>It is recommended that you call this method as part of an event
         * listener that is registered via dojo/ready.</p>
         * </div>
         *         <table class="jsdoc-parameters">
         *           <tr>
         *             <th>Parameter</th>
         *             <th>Type</th>
         *             <th>Description</th>
         *           </tr>
         *           <tr>
         *             <td class="jsdoc-param-name">args</td>
         *             <td class="jsdoc-param-type">Object</td>
         *             <td class="jsdoc-param-description"><p>See the addToHistory() function for the list of valid args properties.</p>
         *  
         *             </td>
         *           </tr>
         *         </table>
         *       </div>
         *     </div>
         *   </div>
         * </div><a href="https://docs.google.com/spreadsheet/viewform?hl=en_US&amp;formkey=dFlDcHEyaHMwbEd4MFBObkNrX0E1MFE6MQ&amp;entry_0=/api/1.9/dojo/back" class="feedback">Error in the documentation? Can't find what you are looking for? Let us know!</a>
         */
        init(): void;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/colors.html
     *
     * Color utilities, extending Base dojo.Color
     * 
     */
    interface colors {
        /**
         * 
         */
        ThreeD: Object;
    }
    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/currency.html
     *
     * localized formatting and parsing routines for currencies
     * extends dojo.number to provide culturally-appropriate formatting of values
     * in various world currencies, including use of a currency symbol.  The currencies are specified
     * by a three-letter international symbol in all uppercase, and support for the currencies is
     * provided by the data in dojo.cldr.  The scripts generating dojo.cldr specify which
     * currency support is included.  A fixed number of decimal places is determined based
     * on the currency type and is not determined by the 'pattern' argument.  The fractional
     * portion is optional, by default, and variable length decimals are not supported.
     * 
     */
    interface currency {
        /**
         * Format a Number as a currency, using locale-specific settings
         * Create a string from a Number using a known, localized pattern.
         * Formatting patterns
         * appropriate to the locale are chosen from the CLDR
         * as well as the appropriate symbols and delimiters and number of decimal places.
         * 
         * @param value the number to be formatted.             
         * @param options               Optional            
         */
        format(value: number, options: dojo.currency.__FormatOptions): any;
        /**
         * 
         * @param expression             
         * @param options               OptionalAn object with the following properties:type (String, optional): Should not be set.  Value is assumed to be currency.currency (String, optional): an ISO4217 currency code, a three letter sequence like "USD".For use with dojo.currency only.symbol (String, optional): localized currency symbol. The default will be looked up in table of supported currencies in dojo.cldrA ISO4217 currency code will be used if not found.places (Number, optional): fixed number of decimal places to accept.  The default is determined based on which currency is used.fractional (Boolean|Array, optional): Whether to include the fractional portion, where the number of decimal places are implied by the currencyor explicit 'places' parameter.  The value [true,false] makes the fractional portion optional.By default for currencies, it the fractional portion is optional.pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.  Literal characters in patterns are not supported.locale (String, optional): override the locale used to determine formatting rulesstrict (Boolean, optional): strict parsing, false by default.  Strict parsing requires input as produced by the format() method.Non-strict is more permissive, e.g. flexible on white space, omitting thousands separators            
         */
        parse(expression: String, options: Object): any;
        /**
         * 
         * @param options               OptionalAn object with the following properties:pattern (String, optional): override formatting patternwith this string.  Default value is based on locale.  Overriding this property will defeatlocalization.type (String, optional): choose a format type based on the locale from the following:decimal, scientific (not yet supported), percent, currency. decimal by default.locale (String, optional): override the locale used to determine formatting rulesstrict (Boolean, optional): strict parsing, false by default.  Strict parsing requires input as produced by the format() method.Non-strict is more permissive, e.g. flexible on white space, omitting thousands separatorsplaces (Number|String, optional): number of decimal places to accept: Infinity, a positive number, ora range "n,m".  Defined by pattern or Infinity if pattern not provided.            
         */
        regexp(options: Object): any;
    }
    module currency {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/currency.__FormatOptions.html
         *
         * 
         */
        class __FormatOptions {
            constructor();
            /**
             * an ISO4217 currency code, a three letter sequence like "USD".
             * For use with dojo.currency only.
             * 
             */
            "currency": string;
            /**
             * If false, show no decimal places, overriding places and pattern settings.
             * 
             */
            "fractional": boolean;
            /**
             * override the locale used to determine formatting rules
             * 
             */
            "locale": string;
            /**
             * override formatting pattern
             * with this string.  Default value is based on locale.  Overriding this property will defeat
             * localization.  Literal characters in patterns are not supported.
             * 
             */
            "pattern": string;
            /**
             * number of decimal places to show.  Default is defined based on which currency is used.
             * 
             */
            "places": number;
            /**
             * 5 rounds to nearest .5; 0 rounds to nearest whole (default). -1
             * means do not round.
             * 
             */
            "round": number;
            /**
             * localized currency symbol. The default will be looked up in table of supported currencies in dojo.cldr
             * A ISO4217 currency code will be used if not found.
             * 
             */
            "symbol": string;
            /**
             * Should not be set.  Value is assumed to be "currency".
             * 
             */
            "type": string;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojo/currency.__ParseOptions.html
         *
         * 
         */
        class __ParseOptions {
            constructor();
            /**
             * an ISO4217 currency code, a three letter sequence like "USD".
             * For use with dojo.currency only.
             * 
             */
            "currency": string;
            /**
             * Whether to include the fractional portion, where the number of decimal places are implied by the currency
             * or explicit 'places' parameter.  The value [true,false] makes the fractional portion optional.
             * By default for currencies, it the fractional portion is optional.
             * 
             */
            "fractional": boolean;
            /**
             * override the locale used to determine formatting rules
             * 
             */
            "locale": string;
            /**
             * override formatting pattern
             * with this string.  Default value is based on locale.  Overriding this property will defeat
             * localization.  Literal characters in patterns are not supported.
             * 
             */
            "pattern": string;
            /**
             * fixed number of decimal places to accept.  The default is determined based on which currency is used.
             * 
             */
            "places": number;
            /**
             * strict parsing, false by default.  Strict parsing requires input as produced by the format() method.
             * Non-strict is more permissive, e.g. flexible on white space, omitting thousands separators
             * 
             */
            "strict": boolean;
            /**
             * localized currency symbol. The default will be looked up in table of supported currencies in dojo.cldr
             * A ISO4217 currency code will be used if not found.
             * 
             */
            "symbol": string;
            /**
             * Should not be set.  Value is assumed to be currency.
             * 
             */
            "type": string;
        }
    }

    /**
     * Permalink: http://dojotoolkit.org/api/1.9/dojo/dom.html
     *
     * This module defines the core dojo DOM API.
     * 
     */
    interface dom {
        /**
         * Returns DOM node with matching id attribute or falsy value (ex: null or undefined)
         * if not found.  If id is a DomNode, this function is a no-op.
         * 
         * @param id A string to match an HTML id attribute or a reference to a DOM Node             
         * @param doc               OptionalDocument to work in. Defaults to the current value ofdojo/_base/window.doc.  Can be used to retrievenode references from other documents.             
         */
        byId(id: String, doc?: HTMLDocument): any;
        /**
         * Returns DOM node with matching id attribute or falsy value (ex: null or undefined)
         * if not found.  If id is a DomNode, this function is a no-op.
         * 
         * @param id A string to match an HTML id attribute or a reference to a DOM Node             
         * @param doc               OptionalDocument to work in. Defaults to the current value ofdojo/_base/window.doc.  Can be used to retrievenode references from other documents.             
         */
        byId(id: HTMLElement, doc?: HTMLDocument): any;
        /**
         * Returns true if node is a descendant of ancestor
         * 
         * @param node string id or node reference to test             
         * @param ancestor string id or node reference of potential parent to test against             
         */
        isDescendant(node: HTMLElement, ancestor: HTMLElement): boo