﻿// Type definitions for Dojo v1.9
// Project: http://dojotoolkit.org
// Definitions by: Michael Van Sickle <https://github.com/vansimke>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

/// <reference path="dojo.d.ts" />
/// <reference path="dijit.d.ts" />
/// <reference path="dojox.widget.d.ts" />
declare module dojox {
    
    module calendar {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/_RendererMixin.html
         *
         * This class is the base class of calendar renderers.
         * 
         */
        class _RendererMixin extends dojo.Stateful { 
            constructor();
            /**
             * Indicates that the item displayed by this renderer is in editing mode.
             * 
             */
            "edited": boolean;
            set(property:"edited", value: boolean): void;
            get(property:"edited"): boolean;
            watch(property:"edited", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is focused.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is hovered.
             * 
             */
            "hovered": boolean;
            set(property:"hovered", value: boolean): void;
            get(property:"hovered"): boolean;
            watch(property:"hovered", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The layout item displayed by this renderer.
             * 
             */
            "item": Object;
            set(property:"item", value: Object): void;
            get(property:"item"): Object;
            watch(property:"item", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be moved.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be resized.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is selected.
             * 
             */
            "selected": boolean;
            set(property:"selected", value: boolean): void;
            get(property:"selected"): boolean;
            watch(property:"selected", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is not in the store, being saved to the store or in the store.
             * 
             */
            "storeState": boolean;
            set(property:"storeState", value: boolean): void;
            get(property:"storeState"): boolean;
            watch(property:"storeState", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "visibilityLimits": Object;
            set(property:"visibilityLimits", value: Object): void;
            get(property:"visibilityLimits"): Object;
            watch(property:"visibilityLimits", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Get a property on a Stateful instance.
             * Get a named property on a Stateful object. The property may
             * potentially be retrieved via a getter method in subclasses. In the base class
             * this just retrieves the object's property.
             * 
             * @param name The property to get.             
             */
            get(name: string): any;
            /**
             * 
             * @param part             
             */
            getDisplayValue(part: any): any;
            /**
             * 
             * @param params               Optional            
             */
            postscript(params: Object): void;
            /**
             * Set a property on a Stateful instance
             * Sets named properties on a stateful object and notifies any watchers of
             * the property. A programmatic setter may be defined in subclasses.
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: string, value: Object): any;
            /**
             * Updates the visual appearance of the renderer according the new values of the properties and the new size of the component.
             * 
             * @param w               OptionalThe width in pixels of the renderer.             
             * @param h               OptionalThe height in pixels of the renderer.             
             */
            updateRendering(w: number, h: number): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/_ScrollBarBase.html
         *
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _ScrollBarBase extends dijit._WidgetBase {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "containerSize": number;
            set(property:"containerSize", value: number): void;
            get(property:"containerSize"): number;
            watch(property:"containerSize", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Direction of the scroll bar. Valid values are "vertical" or "horizontal".
             * 
             */
            "direction": string;
            set(property:"direction", value: string): void;
            get(property:"direction"): string;
            watch(property:"direction", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The maximum value of the scroll bar.
             * 
             */
            "maximum": number;
            set(property:"maximum", value: number): void;
            get(property:"maximum"): number;
            watch(property:"maximum", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The minimum value of the scroll bar.
             * 
             */
            "minimum": number;
            set(property:"minimum", value: number): void;
            get(property:"minimum"): number;
            watch(property:"minimum", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The value of the scroll bar in pixel offset.
             * 
             */
            "value": number;
            set(property:"value", value: number): void;
            get(property:"value"): number;
            watch(property:"value", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * Processing after the DOM fragment is created
             * Called after the DOM fragment has been created, but not necessarily
             * added to the document.  Do not include any operations which rely on
             * node dimensions or placement.
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * An extension point invoked when the value has changed.
             * 
             * @param value The position of the scroll bar in pixels.             
             */
            onChange(value: number): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * An extension point invoked when the user scrolls with the mouse.
             * 
             * @param value The position of the scroll bar in pixels.             
             */
            onScroll(value: number): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/Calendar.html
         *
         * 
         * @param args     
         */
        class Calendar extends dojox.calendar.CalendarBase {
            constructor(args: Object);
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Indicates that the previous/next range method will be animated.
             * 
             */
            "animateRange": boolean;
            set(property:"animateRange", value: boolean): void;
            get(property:"animateRange"): boolean;
            watch(property:"animateRange", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The duration of the next/previous range animation.
             * 
             */
            "animationRangeDuration": number;
            set(property:"animationRangeDuration", value: number): void;
            get(property:"animationRangeDuration"): number;
            watch(property:"animationRangeDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The column view is displaying one day to seven days time intervals.
             * 
             */
            "columnView": Object;
            set(property:"columnView", value: Object): void;
            get(property:"columnView"): Object;
            watch(property:"columnView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Map of property/value passed to the constructor of the column view.
             * 
             */
            "columnViewProps": Object;
            set(property:"columnViewProps", value: Object): void;
            get(property:"columnViewProps"): Object;
            watch(property:"columnViewProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Used to provide a context require to the dojo/parser in order to be
             * able to use relative MIDs (e.g. ./Widget) in the widget's template.
             * 
             */
            "contextRequire": Function;
            set(property:"contextRequire", value: Function): void;
            get(property:"contextRequire"): Function;
            watch(property:"contextRequire", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * A user supplied function that creates a new event.
             * This function is used when createOnGridClick is set to true and the user is clicking and dragging on the grid.
             * This view takes two parameters:
             * 
             * view: the current view,
             * d: the date at the clicked location.
             * 
             */
            "createItemFunc": Function;
            set(property:"createItemFunc", value: Function): void;
            get(property:"createItemFunc"): Function;
            watch(property:"createItemFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The current view displayed by the Calendar object.
             * The currentViewChange event can be used to react on a view change.
             * 
             */
            "currentView": Object;
            set(property:"currentView", value: Object): void;
            get(property:"currentView"): Object;
            watch(property:"currentView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The reference date used to determine along with the dateInterval 
             * and dateIntervalSteps properties the time interval to display.
             * 
             */
            "date": Date;
            set(property:"date", value: Date): void;
            get(property:"date"): Date;
            watch(property:"date", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The date interval used to compute along with the date and 
             * dateIntervalSteps the time interval to display.
             * Valid values are "day", "week" (default value) and "month".
             * 
             */
            "dateInterval": string;
            set(property:"dateInterval", value: string): void;
            get(property:"dateInterval"): string;
            watch(property:"dateInterval", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of date intervals used to compute along with the date and 
             * dateInterval the time interval to display.
             * Default value is 1.     
             * 
             */
            "dateIntervalSteps": number;
            set(property:"dateIntervalSteps", value: number): void;
            get(property:"dateIntervalSteps"): number;
            watch(property:"dateIntervalSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The end date of the displayed time interval (included).     
             * 
             */
            "endDate": Date;
            set(property:"endDate", value: Date): void;
            get(property:"endDate"): Date;
            watch(property:"endDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * (Optional) The first day of week override. By default the first day of week is determined 
             * for the current locale (extracted from the CLDR).
             * Special value -1 (default value), means use locale dependent value.
             * 
             */
            "firstDayOfWeek": number;
            set(property:"firstDayOfWeek", value: number): void;
            get(property:"firstDayOfWeek"): number;
            watch(property:"firstDayOfWeek", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Object;
            set(property:"formatItemTimeFunc", value: Object): void;
            get(property:"formatItemTimeFunc"): Object;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Current render item which is under the mouse cursor.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The column view is displaying time intervals that lasts more than seven days.
             * 
             */
            "matrixView": Object;
            set(property:"matrixView", value: Object): void;
            get(property:"matrixView"): Object;
            watch(property:"matrixView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Map of property/value passed to the constructor of the matrix view.
             * 
             */
            "matrixViewProps": Object;
            set(property:"matrixViewProps", value: Object): void;
            get(property:"matrixViewProps"): Object;
            watch(property:"matrixViewProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The maximum date. 
             * If date is set, the displayed time interval the most in the future
             * will the time interval containing this date.
             * If endDate property is set, this mininum value of endDate.
             * 
             */
            "maxDate": Date;
            set(property:"maxDate", value: Date): void;
            get(property:"maxDate"): Date;
            watch(property:"maxDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The minimum date. 
             * If date property is set, the displayed time interval the most in the past 
             * will the time interval containing this date.
             * If startDate property is set, this mininum value of startDate. 
             * 
             */
            "minDate": Date;
            set(property:"minDate", value: Date): void;
            get(property:"minDate"): Date;
            watch(property:"minDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the displayed time interval.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "viewChangeDuration": number;
            set(property:"viewChangeDuration", value: number): void;
            get(property:"viewChangeDuration"): number;
            watch(property:"viewChangeDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The DOM node that will contains the views.
             * 
             */
            "viewContainer": HTMLElement;
            set(property:"viewContainer", value: HTMLElement): void;
            get(property:"viewContainer"): HTMLElement;
            watch(property:"viewContainer", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The views displayed by the widget.
             * To add/remove only one view, prefer, respectively, the addView() or removeView() methods.
             * 
             */
            "views": Object;
            set(property:"views", value: Object): void;
            get(property:"views"): Object;
            watch(property:"views", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Should we parse the template to find widgets that might be
             * declared in markup inside it?  (Remove for 2.0 and assume true)
             * 
             */
            "widgetsInTemplate": boolean;
            set(property:"widgetsInTemplate", value: boolean): void;
            get(property:"widgetsInTemplate"): boolean;
            watch(property:"widgetsInTemplate", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Add a view to the calendar's view list.
             * 
             * @param view The view to add to the calendar.             
             * @param index Optional, the index where to insert the view in current view list.             
             */
            addView(view: dojox.calendar.ViewBase, index: number): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Function called when the cell of a column header of the column view is clicked.
             * Show the time range defined by the clicked date.
             * 
             * @param e The column header click event.             
             */
            columnViewColumnHeaderClick(e: Object): void;
            /**
             * 
             */
            computeTimeInterval(): any;
            /**
             * Set the localized labels of the buttons and the event handlers.
             * 
             */
            configureButtons(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * The action triggerred when the day button is clicked.
             * By default, sets the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            dayButtonClick(e: any): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date Date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the beginning of week.
             * 
             * @param d             
             */
            floorToWeek(d: any): any;
            /**
             * The action triggerred when the 4 days button is clicked.
             * By default, sets the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 4.
             * 
             * @param e             
             */
            fourDaysButtonClick(e: any): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Changes the displayed time interval to show the current day.
             * Sets the date property to the current day, the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 1.
             * 
             */
            goToday(): void;
            /**
             * Installs the default actions on newly created default views.
             * By default this action is registering:
             * - the matrixViewRowHeaderClick method on the rowHeaderClick event of the matrix view.
             * - the columnViewColumnHeaderClick method on the columnHeaderClick event of the column view.
             * 
             * @param views             
             */
            installDefaultViewsActions(views: any): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Computes whether particular item renderer can be edited.
             * By default it is using the editable property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * Returns wether an item is selected or not.
             * 
             * @param item The item to test the selection for.                      
             */
            isItemSelected(item: Object): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Function called when the cell of a row header of the matrix view is clicked.
             * The implementation is doing the foolowing actions:
             * - If another row is already expanded, collapse it and then expand the clicked row.
             * - If the clicked row is already expadned, collapse it.
             * - If no row is expanded, expand the click row.
             * 
             * @param e The row header click event.             
             */
            matrixViewRowHeaderClick(e: Object): void;
            /**
             * The action triggered when the month button is clicked.
             * By default, sets the dateInterval property to "month" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            monthButtonClick(e: any): void;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:- the time in milliseconds since gregorian epoch.- a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * 
             */
            nextRange(): void;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            previousRange(): void;
            /**
             * Refreshes all the visual rendering of the calendar. 
             * 
             */
            refreshRendering(): void;
            /**
             * Removes a view from the calendar's view list.
             * 
             * @param view The view to remove from the calendar.             
             */
            removeView(view: dojox.calendar.ViewBase): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             */
            resize(): void;
            /**
             * Applies selection triggered by an user interaction
             * 
             * @param e The source event of the user interaction.             
             * @param item The render item that has been selected/deselected.             
             * @param renderer The visual renderer of the selected/deselected item.                         
             * @param dispatch Whether an event must be dispatched or not.             
             */
            selectFromEvent(e: Event, item: Object, renderer: Object, dispatch: boolean): any;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Change the selection state of an item.
             * 
             * @param item The item to change the selection state for.             
             * @param value True to select the item, false to deselect it.              
             */
            setItemSelected(item: Object, value: boolean): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * The action triggered when the today button is clicked.
             * By default, calls the goToday() method.
             * 
             * @param e             
             */
            todayButtonClick(e: any): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             * @param obj             
             * @param stateOnly             
             */
            updateRenderers(obj: any, stateOnly: any): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * The action triggered when the week button is clicked.
             * By default, sets the dateInterval property to "week" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            weekButtonClick(e: any): void;
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Event dispatched when a column header cell is dispatched.
             * 
             * @param e Header click event.             
             */
            onColumnHeaderClick(e: Object): void;
            /**
             * Event dispatched when the current view has changed.
             * 
             * @param e Object that contains the oldView and newView properties.             
             */
            onCurrentViewChange(e: Event): void;
            /**
             * Event dispatched when an expand renderer is clicked.
             * 
             * @param e Expand renderer click event.             
             */
            onExpandRendererClick(e: Object): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked. 
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e The editing event.             
             */
            onItemEditBegin(e: Object): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e The editing event.             
             */
            onItemEditEnd(e: Object): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.     
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOut(e: Object): void;
            /**
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOver(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view The view that has been laid-out.             
             */
            onRenderersLayoutDone(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when a row header cell is clicked.
             * 
             * @param e Header click event.             
             */
            onRowHeaderClick(e: Object): void;
            /**
             * Event dispatched when the displayed time interval has changed.
             * 
             * @param e The time interval change event.             
             */
            onTimeIntervalChange(e: Object): void;
            /**
             * Event dispatched when a view is added from the calendar.
             * 
             * @param view The view that has been added to the calendar.             
             */
            onViewAdded(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when the view has been configured after the queried 
             * time range and before the current view is changed (if needed).
             * 
             * @param view The view that has been configured.              
             */
            onViewConfigurationChange(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when a view is removed from the calendar.
             * 
             * @param view The view that has been removed from the calendar.             
             */
            onViewRemoved(view: dojox.calendar.ViewBase): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/CalendarBase.html
         *
         * This class defines a generic calendar widget that manages several views to display event in time.
         * 
         * @param args     
         */
        class CalendarBase extends dijit._WidgetBase implements dijit._TemplatedMixin, dijit._WidgetsInTemplateMixin, dojox.calendar.StoreMixin, dojox.widget._Invalidating, dojox.widget.Selection {
            constructor(args: Object);
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Indicates that the previous/next range method will be animated.
             * 
             */
            "animateRange": boolean;
            set(property:"animateRange", value: boolean): void;
            get(property:"animateRange"): boolean;
            watch(property:"animateRange", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The duration of the next/previous range animation.
             * 
             */
            "animationRangeDuration": number;
            set(property:"animationRangeDuration", value: number): void;
            get(property:"animationRangeDuration"): number;
            watch(property:"animationRangeDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The column view is displaying one day to seven days time intervals.
             * 
             */
            "columnView": Object;
            set(property:"columnView", value: Object): void;
            get(property:"columnView"): Object;
            watch(property:"columnView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Map of property/value passed to the constructor of the column view.
             * 
             */
            "columnViewProps": Object;
            set(property:"columnViewProps", value: Object): void;
            get(property:"columnViewProps"): Object;
            watch(property:"columnViewProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Used to provide a context require to the dojo/parser in order to be
             * able to use relative MIDs (e.g. ./Widget) in the widget's template.
             * 
             */
            "contextRequire": Function;
            set(property:"contextRequire", value: Function): void;
            get(property:"contextRequire"): Function;
            watch(property:"contextRequire", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * A user supplied function that creates a new event.
             * This function is used when createOnGridClick is set to true and the user is clicking and dragging on the grid.
             * This view takes two parameters:
             * 
             * view: the current view,
             * d: the date at the clicked location.
             * 
             */
            "createItemFunc": Function;
            set(property:"createItemFunc", value: Function): void;
            get(property:"createItemFunc"): Function;
            watch(property:"createItemFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The current view displayed by the Calendar object.
             * The currentViewChange event can be used to react on a view change.
             * 
             */
            "currentView": Object;
            set(property:"currentView", value: Object): void;
            get(property:"currentView"): Object;
            watch(property:"currentView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The reference date used to determine along with the dateInterval 
             * and dateIntervalSteps properties the time interval to display.
             * 
             */
            "date": Date;
            set(property:"date", value: Date): void;
            get(property:"date"): Date;
            watch(property:"date", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The date interval used to compute along with the date and 
             * dateIntervalSteps the time interval to display.
             * Valid values are "day", "week" (default value) and "month".
             * 
             */
            "dateInterval": string;
            set(property:"dateInterval", value: string): void;
            get(property:"dateInterval"): string;
            watch(property:"dateInterval", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of date intervals used to compute along with the date and 
             * dateInterval the time interval to display.
             * Default value is 1.     
             * 
             */
            "dateIntervalSteps": number;
            set(property:"dateIntervalSteps", value: number): void;
            get(property:"dateIntervalSteps"): number;
            watch(property:"dateIntervalSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The end date of the displayed time interval (included).     
             * 
             */
            "endDate": Date;
            set(property:"endDate", value: Date): void;
            get(property:"endDate"): Date;
            watch(property:"endDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * (Optional) The first day of week override. By default the first day of week is determined 
             * for the current locale (extracted from the CLDR).
             * Special value -1 (default value), means use locale dependent value.
             * 
             */
            "firstDayOfWeek": number;
            set(property:"firstDayOfWeek", value: number): void;
            get(property:"firstDayOfWeek"): number;
            watch(property:"firstDayOfWeek", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Object;
            set(property:"formatItemTimeFunc", value: Object): void;
            get(property:"formatItemTimeFunc"): Object;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Current render item which is under the mouse cursor.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The column view is displaying time intervals that lasts more than seven days.
             * 
             */
            "matrixView": Object;
            set(property:"matrixView", value: Object): void;
            get(property:"matrixView"): Object;
            watch(property:"matrixView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Map of property/value passed to the constructor of the matrix view.
             * 
             */
            "matrixViewProps": Object;
            set(property:"matrixViewProps", value: Object): void;
            get(property:"matrixViewProps"): Object;
            watch(property:"matrixViewProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The maximum date. 
             * If date is set, the displayed time interval the most in the future
             * will the time interval containing this date.
             * If endDate property is set, this mininum value of endDate.
             * 
             */
            "maxDate": Date;
            set(property:"maxDate", value: Date): void;
            get(property:"maxDate"): Date;
            watch(property:"maxDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The minimum date. 
             * If date property is set, the displayed time interval the most in the past 
             * will the time interval containing this date.
             * If startDate property is set, this mininum value of startDate. 
             * 
             */
            "minDate": Date;
            set(property:"minDate", value: Date): void;
            get(property:"minDate"): Date;
            watch(property:"minDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the displayed time interval.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A string that represents the widget template.
             * Use in conjunction with dojo.cache() to load from a file.
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "viewChangeDuration": number;
            set(property:"viewChangeDuration", value: number): void;
            get(property:"viewChangeDuration"): number;
            watch(property:"viewChangeDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The DOM node that will contains the views.
             * 
             */
            "viewContainer": HTMLElement;
            set(property:"viewContainer", value: HTMLElement): void;
            get(property:"viewContainer"): HTMLElement;
            watch(property:"viewContainer", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The views displayed by the widget.
             * To add/remove only one view, prefer, respectively, the addView() or removeView() methods.
             * 
             */
            "views": Object;
            set(property:"views", value: Object): void;
            get(property:"views"): Object;
            watch(property:"views", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Should we parse the template to find widgets that might be
             * declared in markup inside it?  (Remove for 2.0 and assume true)
             * 
             */
            "widgetsInTemplate": boolean;
            set(property:"widgetsInTemplate", value: boolean): void;
            get(property:"widgetsInTemplate"): boolean;
            watch(property:"widgetsInTemplate", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Add a view to the calendar's view list.
             * 
             * @param view The view to add to the calendar.             
             * @param index Optional, the index where to insert the view in current view list.             
             */
            addView(view: dojox.calendar.ViewBase, index: number): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Function called when the cell of a column header of the column view is clicked.
             * Show the time range defined by the clicked date.
             * 
             * @param e The column header click event.             
             */
            columnViewColumnHeaderClick(e: Object): void;
            /**
             * 
             */
            computeTimeInterval(): any;
            /**
             * Set the localized labels of the buttons and the event handlers.
             * 
             */
            configureButtons(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * The action triggerred when the day button is clicked.
             * By default, sets the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            dayButtonClick(e: any): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date Date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the beginning of week.
             * 
             * @param d             
             */
            floorToWeek(d: any): any;
            /**
             * The action triggerred when the 4 days button is clicked.
             * By default, sets the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 4.
             * 
             * @param e             
             */
            fourDaysButtonClick(e: any): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Changes the displayed time interval to show the current day.
             * Sets the date property to the current day, the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 1.
             * 
             */
            goToday(): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Computes whether particular item renderer can be edited.
             * By default it is using the editable property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * Returns wether an item is selected or not.
             * 
             * @param item The item to test the selection for.                      
             */
            isItemSelected(item: Object): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Function called when the cell of a row header of the matrix view is clicked.
             * The implementation is doing the foolowing actions:
             * - If another row is already expanded, collapse it and then expand the clicked row.
             * - If the clicked row is already expadned, collapse it.
             * - If no row is expanded, expand the click row.
             * 
             * @param e The row header click event.             
             */
            matrixViewRowHeaderClick(e: Object): void;
            /**
             * The action triggered when the month button is clicked.
             * By default, sets the dateInterval property to "month" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            monthButtonClick(e: any): void;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:- the time in milliseconds since gregorian epoch.- a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * 
             */
            nextRange(): void;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            previousRange(): void;
            /**
             * Refreshes all the visual rendering of the calendar. 
             * 
             */
            refreshRendering(): void;
            /**
             * Removes a view from the calendar's view list.
             * 
             * @param view The view to remove from the calendar.             
             */
            removeView(view: dojox.calendar.ViewBase): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             */
            resize(): void;
            /**
             * Applies selection triggered by an user interaction
             * 
             * @param e The source event of the user interaction.             
             * @param item The render item that has been selected/deselected.             
             * @param renderer The visual renderer of the selected/deselected item.                         
             * @param dispatch Whether an event must be dispatched or not.             
             */
            selectFromEvent(e: Event, item: Object, renderer: Object, dispatch: boolean): any;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Change the selection state of an item.
             * 
             * @param item The item to change the selection state for.             
             * @param value True to select the item, false to deselect it.              
             */
            setItemSelected(item: Object, value: boolean): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * The action triggered when the today button is clicked.
             * By default, calls the goToday() method.
             * 
             * @param e             
             */
            todayButtonClick(e: any): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             * @param obj             
             * @param stateOnly             
             */
            updateRenderers(obj: any, stateOnly: any): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * The action triggered when the week button is clicked.
             * By default, sets the dateInterval property to "week" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            weekButtonClick(e: any): void;
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Event dispatched when a column header cell is dispatched.
             * 
             * @param e Header click event.             
             */
            onColumnHeaderClick(e: Object): void;
            /**
             * Event dispatched when the current view has changed.
             * 
             * @param e Object that contains the oldView and newView properties.             
             */
            onCurrentViewChange(e: Event): void;
            /**
             * Event dispatched when an expand renderer is clicked.
             * 
             * @param e Expand renderer click event.             
             */
            onExpandRendererClick(e: Object): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked. 
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e The editing event.             
             */
            onItemEditBegin(e: Object): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e The editing event.             
             */
            onItemEditEnd(e: Object): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.     
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOut(e: Object): void;
            /**
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOver(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view The view that has been laid-out.             
             */
            onRenderersLayoutDone(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when a row header cell is clicked.
             * 
             * @param e Header click event.             
             */
            onRowHeaderClick(e: Object): void;
            /**
             * Event dispatched when the displayed time interval has changed.
             * 
             * @param e The time interval change event.             
             */
            onTimeIntervalChange(e: Object): void;
            /**
             * Event dispatched when a view is added from the calendar.
             * 
             * @param view The view that has been added to the calendar.             
             */
            onViewAdded(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when the view has been configured after the queried 
             * time range and before the current view is changed (if needed).
             * 
             * @param view The view that has been configured.              
             */
            onViewConfigurationChange(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when a view is removed from the calendar.
             * 
             * @param view The view that has been removed from the calendar.             
             */
            onViewRemoved(view: dojox.calendar.ViewBase): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/ExpandRenderer.html
         *
         * The default renderer display in MatrixView cells where some item renderers cannot be displayed because of size constraints.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class ExpandRenderer extends dijit._WidgetBase implements dijit._TemplatedMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Column index where this renderer is used.
             * 
             */
            "columnIndex": number;
            set(property:"columnIndex", value: number): void;
            get(property:"columnIndex"): number;
            watch(property:"columnIndex", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The date displayed by the cell where this renderer is used.
             * 
             */
            "date": Date;
            set(property:"date", value: Date): void;
            get(property:"date"): Date;
            watch(property:"date", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the renderer is pressed.
             * 
             */
            "down": boolean;
            set(property:"down", value: boolean): void;
            get(property:"down"): boolean;
            watch(property:"down", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the renderer is focused.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * List of items that are not displayed in the cell because of the size constraints.
             * 
             */
            "items": Object;
            set(property:"items", value: Object): void;
            get(property:"items"): Object;
            watch(property:"items", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Row index where this renderer is used.
             * 
             */
            "rowIndex": number;
            set(property:"rowIndex", value: number): void;
            get(property:"rowIndex"): number;
            watch(property:"rowIndex", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Indicates that the mouse cursor is over renderer.
             * 
             */
            "up": boolean;
            set(property:"up", value: boolean): void;
            get(property:"up"): boolean;
            watch(property:"up", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * Processing after the DOM fragment is created
             * Called after the DOM fragment has been created, but not necessarily
             * added to the document.  Do not include any operations which rely on
             * node dimensions or placement.
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/HorizontalRenderer.html
         *
         * The default item horizontal renderer. 
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class HorizontalRenderer extends dijit._WidgetBase implements dijit._TemplatedMixin, dojox.calendar._RendererMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * The padding size in pixels to apply to the label container on left and/or right side, to show the arrows correctly.
             * 
             */
            "arrowPadding": number;
            set(property:"arrowPadding", value: number): void;
            get(property:"arrowPadding"): number;
            watch(property:"arrowPadding", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is in editing mode.
             * 
             */
            "edited": boolean;
            set(property:"edited", value: boolean): void;
            get(property:"edited"): boolean;
            watch(property:"edited", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is hovered.
             * 
             */
            "hovered": boolean;
            set(property:"hovered", value: boolean): void;
            get(property:"hovered"): boolean;
            watch(property:"hovered", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The layout item displayed by this renderer.
             * 
             */
            "item": Object;
            set(property:"item", value: Object): void;
            get(property:"item"): Object;
            watch(property:"item", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be moved.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be resized.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is selected.
             * 
             */
            "selected": boolean;
            set(property:"selected", value: boolean): void;
            get(property:"selected"): boolean;
            watch(property:"selected", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is not in the store, being saved to the store or in the store.
             * 
             */
            "storeState": boolean;
            set(property:"storeState", value: boolean): void;
            get(property:"storeState"): boolean;
            watch(property:"storeState", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "visibilityLimits": Object;
            set(property:"visibilityLimits", value: Object): void;
            get(property:"visibilityLimits"): Object;
            watch(property:"visibilityLimits", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param part             
             */
            getDisplayValue(part: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates the visual appearance of the renderer according the new values of the properties and the new size of the component.
             * 
             * @param w               OptionalThe width in pixels of the renderer.             
             * @param h               OptionalThe height in pixels of the renderer.             
             */
            updateRendering(w: number, h: number): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/Keyboard.html
         *
         * This mixin is managing the keyboard interactions on a calendar view.
         * 
         */
        class Keyboard {
            constructor();
            /**
             * Unit used during editing of an all day event using the keyboard and the left or right keys were pressed. Valid values are "week", "day", "hours" "minute".
             * 
             */
            "allDayKeyboardLeftRightSteps": string;
            /**
             * Steps used during editing of an all day event using the keyboard and the up or down keys were pressed.
             * 
             */
            "allDayKeyboardLeftRightUnit": number;
            /**
             * Unit used during editing of an all day event using the keyboard and the up or down keys were pressed. Valid values are "week", "day", "hours" "minute".     
             * 
             */
            "allDayKeyboardUpDownSteps": string;
            /**
             * Steps used during editing of an all day event using the keyboard and the up or down keys were pressed.
             * 
             */
            "allDayKeyboardUpDownUnit": number;
            /**
             * The data item that currently has the focus.
             * 
             */
            "focusedItem": Object;
            /**
             * Unit used during editing of an event using the keyboard and the left or right keys were pressed.        
             * 
             */
            "keyboardLeftRightSteps": number;
            /**
             * Unit used during editing of an event using the keyboard and the left or right keys were pressed. Valid values are "week", "day", "hours" "minute".
             * 
             */
            "keyboardLeftRightUnit": string;
            /**
             * Steps used during editing of an event using the keyboard and the up or down keys were pressed.      
             * 
             */
            "keyboardUpDownSteps": number;
            /**
             * Unit used during editing of an event using the keyboard and the up or down keys were pressed. Valid values are "week", "day", "hours" "minute".
             * 
             */
            "keyboardUpDownUnit": string;
            /**
             * The duration in milliseconds to scroll the entire view. 
             * The scroll speed is constant when scrolling to show an item renderer. 
             * 
             */
            "maxScrollAnimationDuration": number;
            /**
             * 
             */
            "resizeModifier": string;
            /**
             * Show or hide the focus graphic feedback on item renderers.
             * 
             */
            "showFocus": boolean;
            /**
             * Order fields are traversed when user hits the tab key
             * 
             */
            "tabIndex": string;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Event dispatched when the focus has changed.
             * 
             * @param e             
             */
            onFocusChange(e: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/LabelRenderer.html
         *
         * The default item label renderer. 
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class LabelRenderer extends dijit._WidgetBase implements dijit._TemplatedMixin, dojox.calendar._RendererMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is in editing mode.
             * 
             */
            "edited": boolean;
            set(property:"edited", value: boolean): void;
            get(property:"edited"): boolean;
            watch(property:"edited", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is hovered.
             * 
             */
            "hovered": boolean;
            set(property:"hovered", value: boolean): void;
            get(property:"hovered"): boolean;
            watch(property:"hovered", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The layout item displayed by this renderer.
             * 
             */
            "item": Object;
            set(property:"item", value: Object): void;
            get(property:"item"): Object;
            watch(property:"item", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be moved.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is selected.
             * 
             */
            "selected": boolean;
            set(property:"selected", value: boolean): void;
            get(property:"selected"): boolean;
            watch(property:"selected", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is not in the store, being saved to the store or in the store.
             * 
             */
            "storeState": boolean;
            set(property:"storeState", value: boolean): void;
            get(property:"storeState"): boolean;
            watch(property:"storeState", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "visibilityLimits": Object;
            set(property:"visibilityLimits", value: Object): void;
            get(property:"visibilityLimits"): Object;
            watch(property:"visibilityLimits", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param part             
             */
            getDisplayValue(part: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates the visual appearance of the renderer according the new values of the properties and the new size of the component.
             * 
             * @param w               OptionalThe width in pixels of the renderer.             
             * @param h               OptionalThe height in pixels of the renderer.             
             */
            updateRendering(w: number, h: number): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/MobileCalendar.html
         *
         * This class defines a calendar widget that display events in time designed to be used in mobile environment.
         * 
         * @param args     
         */
        class MobileCalendar extends dojox.calendar.CalendarBase {
            constructor(args: Object);
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Indicates that the previous/next range method will be animated.
             * 
             */
            "animateRange": boolean;
            set(property:"animateRange", value: boolean): void;
            get(property:"animateRange"): boolean;
            watch(property:"animateRange", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The duration of the next/previous range animation.
             * 
             */
            "animationRangeDuration": number;
            set(property:"animationRangeDuration", value: number): void;
            get(property:"animationRangeDuration"): number;
            watch(property:"animationRangeDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The column view is displaying one day to seven days time intervals.
             * 
             */
            "columnView": Object;
            set(property:"columnView", value: Object): void;
            get(property:"columnView"): Object;
            watch(property:"columnView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Map of property/value passed to the constructor of the column view.
             * 
             */
            "columnViewProps": Object;
            set(property:"columnViewProps", value: Object): void;
            get(property:"columnViewProps"): Object;
            watch(property:"columnViewProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Used to provide a context require to the dojo/parser in order to be
             * able to use relative MIDs (e.g. ./Widget) in the widget's template.
             * 
             */
            "contextRequire": Function;
            set(property:"contextRequire", value: Function): void;
            get(property:"contextRequire"): Function;
            watch(property:"contextRequire", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * A user supplied function that creates a new event.
             * This function is used when createOnGridClick is set to true and the user is clicking and dragging on the grid.
             * This view takes two parameters:
             * 
             * view: the current view,
             * d: the date at the clicked location.
             * 
             */
            "createItemFunc": Function;
            set(property:"createItemFunc", value: Function): void;
            get(property:"createItemFunc"): Function;
            watch(property:"createItemFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The current view displayed by the Calendar object.
             * The currentViewChange event can be used to react on a view change.
             * 
             */
            "currentView": Object;
            set(property:"currentView", value: Object): void;
            get(property:"currentView"): Object;
            watch(property:"currentView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The reference date used to determine along with the dateInterval 
             * and dateIntervalSteps properties the time interval to display.
             * 
             */
            "date": Date;
            set(property:"date", value: Date): void;
            get(property:"date"): Date;
            watch(property:"date", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The date interval used to compute along with the date and 
             * dateIntervalSteps the time interval to display.
             * Valid values are "day", "week" (default value) and "month".
             * 
             */
            "dateInterval": string;
            set(property:"dateInterval", value: string): void;
            get(property:"dateInterval"): string;
            watch(property:"dateInterval", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of date intervals used to compute along with the date and 
             * dateInterval the time interval to display.
             * Default value is 1.     
             * 
             */
            "dateIntervalSteps": number;
            set(property:"dateIntervalSteps", value: number): void;
            get(property:"dateIntervalSteps"): number;
            watch(property:"dateIntervalSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The end date of the displayed time interval (included).     
             * 
             */
            "endDate": Date;
            set(property:"endDate", value: Date): void;
            get(property:"endDate"): Date;
            watch(property:"endDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * (Optional) The first day of week override. By default the first day of week is determined 
             * for the current locale (extracted from the CLDR).
             * Special value -1 (default value), means use locale dependent value.
             * 
             */
            "firstDayOfWeek": number;
            set(property:"firstDayOfWeek", value: number): void;
            get(property:"firstDayOfWeek"): number;
            watch(property:"firstDayOfWeek", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Object;
            set(property:"formatItemTimeFunc", value: Object): void;
            get(property:"formatItemTimeFunc"): Object;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Current render item which is under the mouse cursor.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The column view is displaying time intervals that lasts more than seven days.
             * 
             */
            "matrixView": Object;
            set(property:"matrixView", value: Object): void;
            get(property:"matrixView"): Object;
            watch(property:"matrixView", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Map of property/value passed to the constructor of the matrix view.
             * 
             */
            "matrixViewProps": Object;
            set(property:"matrixViewProps", value: Object): void;
            get(property:"matrixViewProps"): Object;
            watch(property:"matrixViewProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The maximum date. 
             * If date is set, the displayed time interval the most in the future
             * will the time interval containing this date.
             * If endDate property is set, this mininum value of endDate.
             * 
             */
            "maxDate": Date;
            set(property:"maxDate", value: Date): void;
            get(property:"maxDate"): Date;
            watch(property:"maxDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The minimum date. 
             * If date property is set, the displayed time interval the most in the past 
             * will the time interval containing this date.
             * If startDate property is set, this mininum value of startDate. 
             * 
             */
            "minDate": Date;
            set(property:"minDate", value: Date): void;
            get(property:"minDate"): Date;
            watch(property:"minDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the displayed time interval.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "viewChangeDuration": number;
            set(property:"viewChangeDuration", value: number): void;
            get(property:"viewChangeDuration"): number;
            watch(property:"viewChangeDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The DOM node that will contains the views.
             * 
             */
            "viewContainer": HTMLElement;
            set(property:"viewContainer", value: HTMLElement): void;
            get(property:"viewContainer"): HTMLElement;
            watch(property:"viewContainer", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The views displayed by the widget.
             * To add/remove only one view, prefer, respectively, the addView() or removeView() methods.
             * 
             */
            "views": Object;
            set(property:"views", value: Object): void;
            get(property:"views"): Object;
            watch(property:"views", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Should we parse the template to find widgets that might be
             * declared in markup inside it?  (Remove for 2.0 and assume true)
             * 
             */
            "widgetsInTemplate": boolean;
            set(property:"widgetsInTemplate", value: boolean): void;
            get(property:"widgetsInTemplate"): boolean;
            watch(property:"widgetsInTemplate", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Add a view to the calendar's view list.
             * 
             * @param view The view to add to the calendar.             
             * @param index Optional, the index where to insert the view in current view list.             
             */
            addView(view: dojox.calendar.ViewBase, index: number): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Function called when the cell of a column header of the column view is clicked.
             * Show the time range defined by the clicked date.
             * 
             * @param e The column header click event.             
             */
            columnViewColumnHeaderClick(e: Object): void;
            /**
             * 
             */
            computeTimeInterval(): any;
            /**
             * Set the localized labels of the buttons and the event handlers.
             * 
             */
            configureButtons(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * The action triggerred when the day button is clicked.
             * By default, sets the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            dayButtonClick(e: any): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date Date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the beginning of week.
             * 
             * @param d             
             */
            floorToWeek(d: any): any;
            /**
             * The action triggerred when the 4 days button is clicked.
             * By default, sets the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 4.
             * 
             * @param e             
             */
            fourDaysButtonClick(e: any): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Changes the displayed time interval to show the current day.
             * Sets the date property to the current day, the dateInterval property to "day" and 
             * the "dateIntervalSteps" to 1.
             * 
             */
            goToday(): void;
            /**
             * Installs the default actions on newly created default views.
             * By default this action is registering:
             * - the matrixViewRowHeaderClick method   on the rowHeaderClick event of the matrix view.
             * - the columnViewColumnHeaderClick method    on the columnHeaderClick event of the column view.
             * 
             * @param views             
             */
            installDefaultViewsActions(views: any): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Computes whether particular item renderer can be edited.
             * By default it is using the editable property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The data item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * Returns wether an item is selected or not.
             * 
             * @param item The item to test the selection for.                      
             */
            isItemSelected(item: Object): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Function called when the cell of a row header of the matrix view is clicked.
             * The implementation is doing the foolowing actions:
             * - If another row is already expanded, collapse it and then expand the clicked row.
             * - If the clicked row is already expadned, collapse it.
             * - If no row is expanded, expand the click row.
             * 
             * @param e The row header click event.             
             */
            matrixViewRowHeaderClick(e: Object): void;
            /**
             * The action triggered when the month button is clicked.
             * By default, sets the dateInterval property to "month" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            monthButtonClick(e: any): void;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:- the time in milliseconds since gregorian epoch.- a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * 
             */
            nextRange(): void;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            previousRange(): void;
            /**
             * Refreshes all the visual rendering of the calendar. 
             * 
             */
            refreshRendering(): void;
            /**
             * Removes a view from the calendar's view list.
             * 
             * @param view The view to remove from the calendar.             
             */
            removeView(view: dojox.calendar.ViewBase): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             */
            resize(): void;
            /**
             * Applies selection triggered by an user interaction
             * 
             * @param e The source event of the user interaction.             
             * @param item The render item that has been selected/deselected.             
             * @param renderer The visual renderer of the selected/deselected item.                         
             * @param dispatch Whether an event must be dispatched or not.             
             */
            selectFromEvent(e: Event, item: Object, renderer: Object, dispatch: boolean): any;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Change the selection state of an item.
             * 
             * @param item The item to change the selection state for.             
             * @param value True to select the item, false to deselect it.              
             */
            setItemSelected(item: Object, value: boolean): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * The action triggered when the today button is clicked.
             * By default, calls the goToday() method.
             * 
             * @param e             
             */
            todayButtonClick(e: any): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             * @param obj             
             * @param stateOnly             
             */
            updateRenderers(obj: any, stateOnly: any): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * The action triggered when the week button is clicked.
             * By default, sets the dateInterval property to "week" and 
             * the "dateIntervalSteps" to 1.
             * 
             * @param e             
             */
            weekButtonClick(e: any): void;
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Event dispatched when a column header cell is dispatched.
             * 
             * @param e Header click event.             
             */
            onColumnHeaderClick(e: Object): void;
            /**
             * Event dispatched when the current view has changed.
             * 
             * @param e Object that contains the oldView and newView properties.             
             */
            onCurrentViewChange(e: Event): void;
            /**
             * Event dispatched when an expand renderer is clicked.
             * 
             * @param e Expand renderer click event.             
             */
            onExpandRendererClick(e: Object): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked. 
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e The editing event.             
             */
            onItemEditBegin(e: Object): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e The editing event.             
             */
            onItemEditEnd(e: Object): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.     
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOut(e: Object): void;
            /**
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOver(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view The view that has been laid-out.             
             */
            onRenderersLayoutDone(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when a row header cell is clicked.
             * 
             * @param e Header click event.             
             */
            onRowHeaderClick(e: Object): void;
            /**
             * Event dispatched when the displayed time interval has changed.
             * 
             * @param e The time interval change event.             
             */
            onTimeIntervalChange(e: Object): void;
            /**
             * Event dispatched when a view is added from the calendar.
             * 
             * @param view The view that has been added to the calendar.             
             */
            onViewAdded(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when the view has been configured after the queried 
             * time range and before the current view is changed (if needed).
             * 
             * @param view The view that has been configured.              
             */
            onViewConfigurationChange(view: dojox.calendar.ViewBase): void;
            /**
             * Event dispatched when a view is removed from the calendar.
             * 
             * @param view The view that has been removed from the calendar.             
             */
            onViewRemoved(view: dojox.calendar.ViewBase): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/MobileHorizontalRenderer.html
         *
         * The mobile specific item horizontal renderer.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class MobileHorizontalRenderer extends dijit._WidgetBase implements dijit._TemplatedMixin, dojox.calendar._RendererMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * The padding size in pixels to apply to the label container on left and/or right side, to show the arrows correctly.
             * 
             */
            "arrowPadding": number;
            set(property:"arrowPadding", value: number): void;
            get(property:"arrowPadding"): number;
            watch(property:"arrowPadding", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is in editing mode.
             * 
             */
            "edited": boolean;
            set(property:"edited", value: boolean): void;
            get(property:"edited"): boolean;
            watch(property:"edited", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is hovered.
             * 
             */
            "hovered": boolean;
            set(property:"hovered", value: boolean): void;
            get(property:"hovered"): boolean;
            watch(property:"hovered", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The layout item displayed by this renderer.
             * 
             */
            "item": Object;
            set(property:"item", value: Object): void;
            get(property:"item"): Object;
            watch(property:"item", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "mobile": boolean;
            set(property:"mobile", value: boolean): void;
            get(property:"mobile"): boolean;
            watch(property:"mobile", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be moved.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be resized.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is selected.
             * 
             */
            "selected": boolean;
            set(property:"selected", value: boolean): void;
            get(property:"selected"): boolean;
            watch(property:"selected", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is not in the store, being saved to the store or in the store.
             * 
             */
            "storeState": boolean;
            set(property:"storeState", value: boolean): void;
            get(property:"storeState"): boolean;
            watch(property:"storeState", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "visibilityLimits": Object;
            set(property:"visibilityLimits", value: Object): void;
            get(property:"visibilityLimits"): Object;
            watch(property:"visibilityLimits", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param part             
             */
            getDisplayValue(part: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates the visual appearance of the renderer according the new values of the properties and the new size of the component.
             * 
             * @param w               OptionalThe width in pixels of the renderer.             
             * @param h               OptionalThe height in pixels of the renderer.             
             */
            updateRendering(w: number, h: number): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/MobileVerticalRenderer.html
         *
         * The mobile specific item vertical renderer.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class MobileVerticalRenderer extends dijit._WidgetBase implements dijit._TemplatedMixin, dojox.calendar._RendererMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is in editing mode.
             * 
             */
            "edited": boolean;
            set(property:"edited", value: boolean): void;
            get(property:"edited"): boolean;
            watch(property:"edited", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is hovered.
             * 
             */
            "hovered": boolean;
            set(property:"hovered", value: boolean): void;
            get(property:"hovered"): boolean;
            watch(property:"hovered", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The layout item displayed by this renderer.
             * 
             */
            "item": Object;
            set(property:"item", value: Object): void;
            get(property:"item"): Object;
            watch(property:"item", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "mobile": boolean;
            set(property:"mobile", value: boolean): void;
            get(property:"mobile"): boolean;
            watch(property:"mobile", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be moved.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be resized.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is selected.
             * 
             */
            "selected": boolean;
            set(property:"selected", value: boolean): void;
            get(property:"selected"): boolean;
            watch(property:"selected", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is not in the store, being saved to the store or in the store.
             * 
             */
            "storeState": boolean;
            set(property:"storeState", value: boolean): void;
            get(property:"storeState"): boolean;
            watch(property:"storeState", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "visibilityLimits": Object;
            set(property:"visibilityLimits", value: Object): void;
            get(property:"visibilityLimits"): Object;
            watch(property:"visibilityLimits", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param part             
             */
            getDisplayValue(part: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates the visual appearance of the renderer according the new values of the properties and the new size of the component.
             * 
             * @param w               OptionalThe width in pixels of the renderer.             
             * @param h               OptionalThe height in pixels of the renderer.             
             */
            updateRendering(w: number, h: number): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/Mouse.html
         *
         * This plugin is managing the mouse interactions on item renderers displayed by a calendar view.      
         * 
         */
        class Mouse {
            constructor();
            /**
             * The distance in pixels along the vertical or horizontal axis to cover with the 
             * mouse button down before triggering the editing gesture.
             * 
             */
            "triggerExtent": number;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * Event dispatched when the mouse cursor in leaving an item renderer.
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOut(e: Object): void;
            /**
             * Event dispatched when the mouse cursor in going over an item renderer.
             * 
             * @param e The event dispatched when the mouse cursor enters in the item renderer.             
             */
            onItemRollOver(e: Object): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/StoreMixin.html
         *
         * This mixin contains the store management.
         * 
         */
        class StoreMixin extends dojo.Stateful {
            constructor();
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Get a property on a Stateful instance.
             * Get a named property on a Stateful object. The property may
             * potentially be retrieved via a getter method in subclasses. In the base class
             * this just retrieves the object's property.
             * 
             * @param name The property to get.             
             */
            get(name: string): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * 
             * @param params               Optional            
             */
            postscript(params: Object): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * Set a property on a Stateful instance
             * Sets named properties on a stateful object and notifies any watchers of
             * the property. A programmatic setter may be defined in subclasses.
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: string, value: Object): any;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/Touch.html
         *
         * This plugin is managing the touch interactions on item renderers displayed by a calendar view.      
         * 
         */
        class Touch {
            constructor();
            /**
             * The minimum number of minutes of margin around the edited event. 
             * 
             */
            "autoScrollTouchMargin": number;
            /**
             * The delay after which the item is leaving the editing mode after the previous editing gesture, in touch context.
             * 
             */
            "touchEndEditingTimer": number;
            /**
             * The delay of one touch over the renderer before setting the item in editing mode.       
             * 
             */
            "touchStartEditingTimer": number;
            /**
             * 
             */
            postMixInProperties(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/VerticalRenderer.html
         *
         * The default item vertical renderer.     
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class VerticalRenderer extends dijit._WidgetBase implements dijit._TemplatedMixin, dojox.calendar._RendererMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is in editing mode.
             * 
             */
            "edited": boolean;
            set(property:"edited", value: boolean): void;
            get(property:"edited"): boolean;
            watch(property:"edited", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is hovered.
             * 
             */
            "hovered": boolean;
            set(property:"hovered", value: boolean): void;
            get(property:"hovered"): boolean;
            watch(property:"hovered", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The layout item displayed by this renderer.
             * 
             */
            "item": Object;
            set(property:"item", value: Object): void;
            get(property:"item"): Object;
            watch(property:"item", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be moved.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The view that contains this renderer.
             * 
             */
            "owner": Object;
            set(property:"owner", value: Object): void;
            get(property:"owner"): Object;
            watch(property:"owner", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Whether the event displayed by this renderer can be resized.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is selected.
             * 
             */
            "selected": boolean;
            set(property:"selected", value: boolean): void;
            get(property:"selected"): boolean;
            watch(property:"selected", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates that the item displayed by this renderer is not in the store, being saved to the store or in the store.
             * 
             */
            "storeState": boolean;
            set(property:"storeState", value: boolean): void;
            get(property:"storeState"): boolean;
            watch(property:"storeState", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "visibilityLimits": Object;
            set(property:"visibilityLimits", value: Object): void;
            get(property:"visibilityLimits"): Object;
            watch(property:"visibilityLimits", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy this widget, but not its descendants.  Descendants means widgets inside of
             * this.containerNode.   Will also destroy any resources (including widgets) registered via this.own().
             * 
             * This method will also destroy internal widgets such as those created from a template,
             * assuming those widgets exist inside of this.domNode but outside of this.containerNode.
             * 
             * For 2.0 it's planned that this method will also destroy descendant widgets, so apps should not
             * depend on the current ability to destroy a widget without destroying its descendants.   Generally
             * they should use destroyRecursive() for widgets with children.
             * 
             * @param preserveDom If true, this method will leave the original DOM structure alone.Note: This will not yet work with _TemplatedMixin widgets             
             */
            destroy(preserveDom?: boolean): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             * @param part             
             */
            getDisplayValue(part: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates the visual appearance of the renderer according the new values of the properties and the new size of the component.
             * 
             * @param w               OptionalThe width in pixels of the renderer.             
             * @param h               OptionalThe height in pixels of the renderer.             
             */
            updateRendering(w: number, h: number): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/ViewBase.html
         *
         * The dojox.calendar.ViewBase widget is the base of calendar view widgets
         * 
         * @param args     
         */
        class ViewBase extends dijit._WidgetBase implements dojox.calendar.StoreMixin, dojox.widget._Invalidating, dojox.widget.Selection {
            constructor(args: Object);
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * If an event has a duration greater than 24 hours, indicates if using a resize gesture, it can be resized to last less than 24 hours.
             * This flag is usually used when two different kind of renderers are used (MatrixView) to prevent changing the kind of renderer during an editing gesture.
             * 
             */
            "allowResizeLessThan24H": boolean;
            set(property:"allowResizeLessThan24H", value: boolean): void;
            get(property:"allowResizeLessThan24H"): boolean;
            watch(property:"allowResizeLessThan24H", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Specifies if the start and end time of an item can be swapped during an editing gesture. Note that using the keyboard this property is ignored. 
             * 
             */
            "allowStartEndSwap": boolean;
            set(property:"allowStartEndSwap", value: boolean): void;
            get(property:"allowStartEndSwap"): boolean;
            watch(property:"allowStartEndSwap", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If several sub columns are displayed, indicated if the data item can be reassigned to another sub column by an editing gesture.
             * 
             */
            "allowSubColumnMove": boolean;
            set(property:"allowSubColumnMove", value: boolean): void;
            get(property:"allowSubColumnMove"): boolean;
            watch(property:"allowSubColumnMove", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled automatically. 
             * Auto scrolling is used when moving focus to a non visible renderer using keyboard 
             * and while editing an item. 
             * 
             */
            "autoScroll": boolean;
            set(property:"autoScroll", value: boolean): void;
            get(property:"autoScroll"): boolean;
            watch(property:"autoScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The maximum delay between two taps needed to trigger an "itemDoubleClick" event, in touch context.      
             * 
             */
            "doubleTapDelay": number;
            set(property:"doubleTapDelay", value: number): void;
            get(property:"doubleTapDelay"): number;
            watch(property:"doubleTapDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Function;
            set(property:"formatItemTimeFunc", value: Function): void;
            get(property:"formatItemTimeFunc"): Function;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The currently hovered data item.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The associated array item to renderer list.
             * 
             */
            "itemToRenderer": Object;
            set(property:"itemToRenderer", value: Object): void;
            get(property:"itemToRenderer"): Object;
            watch(property:"itemToRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to associate a kind of renderer ("horizontal", "label" or null) with the specified item.
             * By default, if an item is lasting more that 24 hours an horizontal item is used, otherwise a label is used.
             * 
             */
            "itemToRendererKindFunc": Function;
            set(property:"itemToRendererKindFunc", value: Function): void;
            get(property:"itemToRendererKindFunc"): Function;
            watch(property:"itemToRendererKindFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * An optional comparison function use to determine the order the item will be laid out
             * The function is used to sort an array and must, as any sorting function, take two items 
             * as argument and must return an integer whose sign define order between arguments.
             * By default, a comparison by start time then end time is used.
             * 
             */
            "layoutPriorityFunction": Function;
            set(property:"layoutPriorityFunction", value: Function): void;
            get(property:"layoutPriorityFunction"): Function;
            watch(property:"layoutPriorityFunction", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * If true, all the events are laid out during the editing gesture. If false, only the edited event is laid out.
             * 
             */
            "liveLayout": boolean;
            set(property:"liveLayout", value: boolean): void;
            get(property:"liveLayout"): boolean;
            watch(property:"liveLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The number of units used to define the minimal duration of the edited item.
             * 
             */
            "minDurationSteps": number;
            set(property:"minDurationSteps", value: number): void;
            get(property:"minDurationSteps"): number;
            watch(property:"minDurationSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The unit used to define the minimal duration of the edited item.
             * "day", "hour" and "minute" are valid values.
             * 
             */
            "minDurationUnit": string;
            set(property:"minDurationUnit", value: string): void;
            get(property:"minDurationUnit"): string;
            watch(property:"minDurationUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of used renderers
             * 
             */
            "rendererList": any[];
            set(property:"rendererList", value: any[]): void;
            get(property:"rendererList"): any[];
            watch(property:"rendererList", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The stack of recycled renderers available.
             * 
             */
            "rendererPool": any[];
            set(property:"rendererPool", value: any[]): void;
            get(property:"rendererPool"): any[];
            watch(property:"rendererPool", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * CSS value to apply to the cursor while resizing an item renderer. 
             * 
             */
            "resizeCursor": string;
            set(property:"resizeCursor", value: string): void;
            get(property:"resizeCursor"): string;
            watch(property:"resizeCursor", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled or not.
             * 
             */
            "scrollable": boolean;
            set(property:"scrollable", value: boolean): void;
            get(property:"scrollable"): boolean;
            watch(property:"scrollable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Method used to scroll the view, for example the scroll of column view.
             * Valid value are:
             * 
             * "auto": let the view decide (default),
             * "css": use css 3d transform,
             * "dom": use the scrollTop property.
             * 
             */
            "scrollMethod": string;
            set(property:"scrollMethod", value: string): void;
            get(property:"scrollMethod"): string;
            watch(property:"scrollMethod", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of units used to compute the snapping of the edited item.
             * 
             */
            "snapSteps": number;
            set(property:"snapSteps", value: number): void;
            get(property:"snapSteps"): number;
            watch(property:"snapSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The unit of the snapping to apply during the editing of an event.
             * "day", "hour" and "minute" are valid values. 
             * 
             */
            "snapUnit": string;
            set(property:"snapUnit", value: string): void;
            get(property:"snapUnit"): string;
            watch(property:"snapUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Specifies during editing, if the item is already in view, if the item must stay in the time range defined by the view or not.       
             * 
             */
            "stayInView": boolean;
            set(property:"stayInView", value: boolean): void;
            get(property:"stayInView"): boolean;
            watch(property:"stayInView", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Kind of the view. Used by the calendar widget to determine how to configure the view.
             * 
             */
            "viewKind": string;
            set(property:"viewKind", value: string): void;
            get(property:"viewKind"): string;
            watch(property:"viewKind", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Function invoked just after the view is displayed by the calendar.
             * 
             */
            afterActivate(): void;
            /**
             * Function invoked just after the view is the view is hidden or removed by the calendar.
             * 
             */
            afterDeactivate(): void;
            /**
             * Applies the z-index to the renderer based on the state of the item.
             * This methods is setting a z-index of 20 is the item is selected or edited 
             * and the current lane value computed by the overlap layout (i.e. the renderers 
             * are stacked according to their lane).
             * 
             * @param item The render item.             
             * @param renderer A renderer associated with the render item.             
             * @param hovered Whether the item is hovered or not.             
             * @param selected Whether the item is selected or not.             
             * @param edited Whether the item is being edited not not.             
             * @param focused Whether the item is focused not not.             
             */
            applyRendererZIndex(item: Object, renderer: Object, hovered: boolean, selected: boolean, edited: boolean, focused: boolean): void;
            /**
             * Function invoked just before the view is displayed by the calendar.
             * 
             */
            beforeActivate(): void;
            /**
             * Function invoked just before the view is hidden or removed by the calendar.
             * 
             */
            beforeDeactivate(): void;
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Computes the overlap layout of a list of items. A lane and extent properties are added to each layout item.
             * 
             * @param layoutItems List of layout items, each item must have a start and end properties.             
             * @param func             
             */
            computeOverlapping(layoutItems: Object[], func: any): any;
            /**
             * Computes the time to pixel projection in a day.
             * 
             * @param renderData The render data.             
             * @param refDate The reference date that defines the destination date.             
             * @param date The reference dates (at least one).              
             * @param max The size in pixels of the representation of a day.             
             */
            computeProjectionOnDate(renderData: Object, refDate: Date, date: Date[], max: number): any;
            /**
             * Computes the overlap time range of the time ranges.
             * Returns a vector of Date with at index 0 the start time and at index 1 the end time.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            computeRangeOverlap(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * A user supplied function that creates a new event.
             * 
             * @param view the current view,             
             * @param d the date at the clicked location.             
             * @param e the mouse event (can be used to return null for example)             
             */
            createItemFunc(view: dojox.calendar.ViewBase, d: Date, e: MouseEvent): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             * @param preserveDom             
             */
            destroy(preserveDom?: any): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * During the resize editing gesture, ensures that the item has the specified minimal duration.
             * 
             * @param renderData The render data.             
             * @param item The edited item.             
             * @param unit The unit used to define the minimal duration.             
             * @param steps The number of time units.             
             * @param editKind The edit kind: "resizeStart" or "resizeEnd".             
             */
            ensureMinimalDuration(renderData: Object, item: Object, unit: String, steps: number, editKind: String): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param margin Margin in minutes around the time range.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, margin: number, visibilityTarget: String, duration: number): void;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the start of the date's month.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToMonth(date: Date, reuse: boolean): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Utility method that return the specific CSS prefix
             * for non standard CSS properties. Ex: -moz-border-radius.
             * 
             */
            getCSSPrefix(): String;
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Returns the renderers that are currently used to displayed the speficied item.
             * Returns an array of objects that contains two properties:
             * - container: The DOM node that contains the renderer.
             * - renderer: The dojox.calendar._RendererMixin instance.
             * Do not keep references on the renderers are they are recycled and reused for other items.
             * 
             * @param item The data or render item.             
             */
            getRenderers(item: Object): any;
            /**
             * Returns the sub column at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getSubColumn(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the sub column index that has the specified value, if any. -1 otherwise. 
             * 
             * @param value The sub column index.             
             */
            getSubColumnIndex(value: String): number;
            /**
             * Returns the time displayed at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getTime(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the week number string from dojo.date.locale.format() method as
             * dojox.date.XXXX calendar are not supporting the "w" pattern.
             * 
             * @param date The date to format.             
             */
            getWeekNumberLabel(date: Date): any;
            /**
             * Triggers a re-layout of the renderers.
             * 
             */
            invalidateLayout(): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Determines if a node has an ascendant node that has the css class specified.
             * 
             * @param node The DOM node.             
             * @param ancestor The ancestor node used to limit the search in hierarchy.             
             * @param className The css class name.             
             */
            isAscendantHasClass(node: HTMLElement, ancestor: HTMLElement, className: String): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Returns whether an item is being edited or not.
             * 
             * @param item The item to test.             
             */
            isItemBeingEdited(item: Object): any;
            /**
             * Computes whether particular item renderer can be edited or not.
             * By default it is using the editable property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is focused or not.
             * 
             * @param item The item.             
             */
            isItemFocused(item: Object): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * 
             * @param item             
             */
            isItemSelected(item: any): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Computes if the first time range defined by the start1 and end1 parameters 
             * is overlapping the second time range defined by the start2 and end2 parameters.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            isOverlapping(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Tests if the specified dates are in the same day.
             * 
             * @param date1 The first date.             
             * @param date2 The second date.             
             */
            isSameDay(date1: Date, date2: Date): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Determines whether the specified date is a week-end.
             * This method is using dojo.date.locale.isWeekend() method as
             * dojox.date.XXXX calendars are not supporting this method.
             * 
             * @param date The date to test.               
             */
            isWeekEnd(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:the time in milliseconds since gregorian epoch.a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * Processing after the DOM fragment is created
             * Called after the DOM fragment has been created, but not necessarily
             * added to the document.  Do not include any operations which rely on
             * node dimensions or placement.
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * Actually refresh the rendering. Implementation should implement that method.
             * 
             */
            refreshRendering(): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             */
            resize(): void;
            /**
             * If the view is scrollable, scrolls it vertically to the specified direction.
             * 
             * @param dir Direction of the scroll. Valid values are -1 and 1.             
             */
            scrollView(dir: number): void;
            /**
             * 
             * @param e             
             * @param item             
             * @param renderer             
             * @param dispatch             
             */
            selectFromEvent(e: any, item: any, renderer: any, dispatch: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * 
             * @param item             
             * @param value             
             */
            setItemSelected(item: any, value: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates all the renderers that represents the specified item(s).
             * 
             * @param obj A render item or an array of render items.             
             * @param stateOnly Whether only the state of the item has changed (selected, edited, edited, focused) or a more global change has occured.             
             */
            updateRenderers(obj: Object, stateOnly: boolean): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked.
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e             
             */
            onItemEditBegin(e: any): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e             
             */
            onItemEditEnd(e: any): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view             
             */
            onRenderersLayoutDone(view: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/ColumnViewSecondarySheet.html
         *
         * This class defines a matrix view designed to be embedded in a column view, 
         * usually to display long or all day events on one row. 
         * 
         */
        class ColumnViewSecondarySheet extends dojox.calendar.MatrixView {
            constructor();
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "allowResizeLessThan24H": boolean;
            set(property:"allowResizeLessThan24H", value: boolean): void;
            get(property:"allowResizeLessThan24H"): boolean;
            watch(property:"allowResizeLessThan24H", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "allowStartEndSwap": boolean;
            set(property:"allowStartEndSwap", value: boolean): void;
            get(property:"allowStartEndSwap"): boolean;
            watch(property:"allowStartEndSwap", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If several sub columns are displayed, indicated if the data item can be reassigned to another sub column by an editing gesture.
             * 
             */
            "allowSubColumnMove": boolean;
            set(property:"allowSubColumnMove", value: boolean): void;
            get(property:"allowSubColumnMove"): boolean;
            watch(property:"allowSubColumnMove", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled automatically. 
             * Auto scrolling is used when moving focus to a non visible renderer using keyboard 
             * and while editing an item. 
             * 
             */
            "autoScroll": boolean;
            set(property:"autoScroll", value: boolean): void;
            get(property:"autoScroll"): boolean;
            watch(property:"autoScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for grid cell label to override default one coming from the CLDR.
             * The long pattern is used for the first day of month or the first displayed day of a month.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "cellHeaderLongPattern": string;
            set(property:"cellHeaderLongPattern", value: string): void;
            get(property:"cellHeaderLongPattern"): string;
            watch(property:"cellHeaderLongPattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for grid cell label to override default one coming from the CLDR.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "cellHeaderShortPattern": string;
            set(property:"cellHeaderShortPattern", value: string): void;
            get(property:"cellHeaderShortPattern"): string;
            watch(property:"cellHeaderShortPattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "cellPaddingTop": number;
            set(property:"cellPaddingTop", value: number): void;
            get(property:"cellPaddingTop"): number;
            watch(property:"cellPaddingTop", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of column to display (from the startDate).
             * 
             */
            "columnCount": number;
            set(property:"columnCount", value: number): void;
            get(property:"columnCount"): number;
            watch(property:"columnCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The maximum delay between two taps needed to trigger an "itemDoubleClick" event, in touch context.      
             * 
             */
            "doubleTapDelay": number;
            set(property:"doubleTapDelay", value: number): void;
            get(property:"doubleTapDelay"): number;
            watch(property:"doubleTapDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Duration of the animation when expanding or collapsing a row.
             * 
             */
            "expandDuration": number;
            set(property:"expandDuration", value: number): void;
            get(property:"expandDuration"): number;
            watch(property:"expandDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Easing function of the animation when expanding or collapsing a row (null by default).
             * 
             */
            "expandEasing": Function;
            set(property:"expandEasing", value: Function): void;
            get(property:"expandEasing"): Function;
            watch(property:"expandEasing", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The class use to create drill down renderers.       
             * 
             */
            "expandRenderer": Object;
            set(property:"expandRenderer", value: Object): void;
            get(property:"expandRenderer"): Object;
            watch(property:"expandRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The height in pixels of the expand/collapse renderers that is applied by the layout.
             * 
             */
            "expandRendererHeight": number;
            set(property:"expandRendererHeight", value: number): void;
            get(property:"expandRendererHeight"): number;
            watch(property:"expandRendererHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Function;
            set(property:"formatItemTimeFunc", value: Function): void;
            get(property:"formatItemTimeFunc"): Function;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The class use to create horizontal renderers.
             * 
             */
            "horizontalRenderer": Object;
            set(property:"horizontalRenderer", value: Object): void;
            get(property:"horizontalRenderer"): Object;
            watch(property:"horizontalRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The height in pixels of the horizontal and label renderers that is applied by the layout.
             * 
             */
            "horizontalRendererHeight": number;
            set(property:"horizontalRendererHeight", value: number): void;
            get(property:"horizontalRendererHeight"): number;
            watch(property:"horizontalRendererHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The currently hovered data item.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The associated array item to renderer list.
             * 
             */
            "itemToRenderer": Object;
            set(property:"itemToRenderer", value: Object): void;
            get(property:"itemToRenderer"): Object;
            watch(property:"itemToRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to associate a kind of renderer ("horizontal", "label" or null) with the specified item.
             * By default, if an item is lasting more that 24 hours an horizontal item is used, otherwise a label is used.
             * 
             */
            "itemToRendererKindFunc": Function;
            set(property:"itemToRendererKindFunc", value: Function): void;
            get(property:"itemToRendererKindFunc"): Function;
            watch(property:"itemToRendererKindFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The class use to create label renderers.
             * 
             */
            "labelRenderer": Object;
            set(property:"labelRenderer", value: Object): void;
            get(property:"labelRenderer"): Object;
            watch(property:"labelRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "labelRendererHeight": number;
            set(property:"labelRendererHeight", value: number): void;
            get(property:"labelRendererHeight"): number;
            watch(property:"labelRendererHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "layoutDuringResize": boolean;
            set(property:"layoutDuringResize", value: boolean): void;
            get(property:"layoutDuringResize"): boolean;
            watch(property:"layoutDuringResize", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional comparison function use to determine the order the item will be laid out
             * The function is used to sort an array and must, as any sorting function, take two items 
             * as argument and must return an integer whose sign define order between arguments.
             * By default, a comparison by start time then end time is used.
             * 
             */
            "layoutPriorityFunction": Function;
            set(property:"layoutPriorityFunction", value: Function): void;
            get(property:"layoutPriorityFunction"): Function;
            watch(property:"layoutPriorityFunction", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * 
             */
            "liveLayout": boolean;
            set(property:"liveLayout", value: boolean): void;
            get(property:"liveLayout"): boolean;
            watch(property:"liveLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationSteps": number;
            set(property:"minDurationSteps", value: number): void;
            get(property:"minDurationSteps"): number;
            watch(property:"minDurationSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationUnit": string;
            set(property:"minDurationUnit", value: string): void;
            get(property:"minDurationUnit"): string;
            watch(property:"minDurationUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "naturalRowsHeight": Object;
            set(property:"naturalRowsHeight", value: Object): void;
            get(property:"naturalRowsHeight"): Object;
            watch(property:"naturalRowsHeight", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The percentage of the renderer width used to superimpose one item renderers on another 
             * when two events are overlapping. By default 0.
             * 
             */
            "percentOverlap": number;
            set(property:"percentOverlap", value: number): void;
            get(property:"percentOverlap"): number;
            watch(property:"percentOverlap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "refEndTime": Object;
            set(property:"refEndTime", value: Object): void;
            get(property:"refEndTime"): Object;
            watch(property:"refEndTime", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * (Optional) Start of the time interval of interest. 
             * It is used to style differently the displayed rows out of the 
             * time interval of interest.          
             * 
             */
            "refStartTime": Object;
            set(property:"refStartTime", value: Object): void;
            get(property:"refStartTime"): Object;
            watch(property:"refStartTime", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The render data object contains all the data needed to render the widget.
             * 
             */
            "renderData": Object;
            set(property:"renderData", value: Object): void;
            get(property:"renderData"): Object;
            watch(property:"renderData", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of used renderers
             * 
             */
            "rendererList": any[];
            set(property:"rendererList", value: any[]): void;
            get(property:"rendererList"): any[];
            watch(property:"rendererList", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The stack of recycled renderers available.
             * 
             */
            "rendererPool": any[];
            set(property:"rendererPool", value: any[]): void;
            get(property:"rendererPool"): any[];
            watch(property:"rendererPool", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * Duration, in milliseconds, of the fade animation showing the item renderers after a widget resize.
             * 
             */
            "resizeAnimationDuration": number;
            set(property:"resizeAnimationDuration", value: number): void;
            get(property:"resizeAnimationDuration"): number;
            watch(property:"resizeAnimationDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "resizeCursor": string;
            set(property:"resizeCursor", value: string): void;
            get(property:"resizeCursor"): string;
            watch(property:"resizeCursor", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "roundToDay": boolean;
            set(property:"roundToDay", value: boolean): void;
            get(property:"roundToDay"): boolean;
            watch(property:"roundToDay", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "scrollable": boolean;
            set(property:"scrollable", value: boolean): void;
            get(property:"scrollable"): boolean;
            watch(property:"scrollable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Method used to scroll the view, for example the scroll of column view.
             * Valid value are:
             * 
             * "auto": let the view decide (default),
             * "css": use css 3d transform,
             * "dom": use the scrollTop property.
             * 
             */
            "scrollMethod": string;
            set(property:"scrollMethod", value: string): void;
            get(property:"scrollMethod"): string;
            watch(property:"scrollMethod", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether display or not the grid cells label (usually the day of month).
             * 
             */
            "showCellLabel": boolean;
            set(property:"showCellLabel", value: boolean): void;
            get(property:"showCellLabel"): boolean;
            watch(property:"showCellLabel", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "snapSteps": number;
            set(property:"snapSteps", value: number): void;
            get(property:"snapSteps"): number;
            watch(property:"snapSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "snapUnit": string;
            set(property:"snapUnit", value: string): void;
            get(property:"snapUnit"): string;
            watch(property:"snapUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the time interval displayed.
             * If not set at initialization time, will be set to current day.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "stayInView": boolean;
            set(property:"stayInView", value: boolean): void;
            get(property:"stayInView"): boolean;
            watch(property:"stayInView", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom function to customize the appearance of a grid cell by installing custom CSS class on the node.
             * The signature of the function must be the same then the styleGridCell one.
             * By default the defaultStyleGridCell function is used.
             * 
             */
            "styleGridCellFunc": Function;
            set(property:"styleGridCellFunc", value: Function): void;
            get(property:"styleGridCellFunc"): Function;
            watch(property:"styleGridCellFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "triggerExtent": number;
            set(property:"triggerExtent", value: number): void;
            get(property:"triggerExtent"): number;
            watch(property:"triggerExtent", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The number of pixels between two item renderers that are overlapping each other if the percentOverlap property is 0.
             * 
             */
            "verticalGap": number;
            set(property:"verticalGap", value: number): void;
            get(property:"verticalGap"): number;
            watch(property:"verticalGap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Type of the view. Used by the calendar widget to determine how to configure the view.
             * This view kind is "matrix".
             * 
             */
            "viewKind": string;
            set(property:"viewKind", value: string): void;
            get(property:"viewKind"): string;
            watch(property:"viewKind", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Function invoked just after the view is displayed by the calendar.
             * 
             */
            afterActivate(): void;
            /**
             * Function invoked just after the view is the view is hidden or removed by the calendar.
             * 
             */
            afterDeactivate(): void;
            /**
             * Function invoked just before the view is displayed by the calendar.
             * 
             */
            beforeActivate(): void;
            /**
             * Function invoked just before the view is hidden or removed by the calendar.
             * 
             */
            beforeDeactivate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Collapses the expanded row, if any.
             * 
             * @param duration Duration in milliseconds of the optional animation.             
             * @param easing Easing function of the optional animation.             
             * @param apply             
             */
            collapseRow(duration: number, easing: Function, apply: any): void;
            /**
             * Computes the overlap layout of a list of items. A lane and extent properties are added to each layout item.
             * 
             * @param layoutItems List of layout items, each item must have a start and end properties.             
             * @param func             
             */
            computeOverlapping(layoutItems: Object[], func: any): any;
            /**
             * Computes the time to pixel projection in a day.
             * 
             * @param renderData The render data.             
             * @param refDate The reference date that defines the destination date.             
             * @param date The reference dates (at least one).              
             * @param max The size in pixels of the representation of a day.             
             */
            computeProjectionOnDate(renderData: Object, refDate: Date, date: Date[], max: number): any;
            /**
             * Computes the overlap time range of the time ranges.
             * Returns a vector of Date with at index 0 the start time and at index 1 the end time.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            computeRangeOverlap(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * A user supplied function that creates a new event.
             * 
             * @param view the current view,             
             * @param d the date at the clicked location.             
             * @param e the mouse event (can be used to return null for example)             
             */
            createItemFunc(view: dojox.calendar.ViewBase, d: Date, e: MouseEvent): void;
            /**
             * Styles the CSS classes to the node that displays a cell.
             * By default this method is setting the following CSS classes:
             * - "dojoxCalendarToday" class name if the date displayed is the current date, 
             * - "dojoxCalendarWeekend" if the date represents a weekend or
             * - "dojoxCalendarDayDisabled" if the date is out of the [refStartTime, refEndTime] interval.
             * - the CSS class corresponding of the displayed day of week ("Sun", "Mon" and so on).            
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param renderData The render data.             
             */
            defaultStyleGridCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             * @param preserveDom             
             */
            destroy(preserveDom?: any): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * During the resize editing gesture, ensures that the item has the specified minimal duration.
             * 
             * @param renderData The render data.             
             * @param item The edited item.             
             * @param unit The unit used to define the minimal duration.             
             * @param steps The number of time units.             
             * @param editKind The edit kind: "resizeStart" or "resizeEnd".             
             */
            ensureMinimalDuration(renderData: Object, item: Object, unit: String, steps: number, editKind: String): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param margin Margin in minutes around the time range.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, margin: number, visibilityTarget: String, duration: number): void;
            /**
             * Default action when an expand renderer is clicked.
             * This method will expand the secondary sheet to show all the events.
             * 
             * @param e The mouse event.             
             * @param renderer The renderer that was clicked.             
             */
            expandRendererClickHandler(e: Event, renderer: Object): void;
            /**
             * Expands the specified row.
             * 
             * @param rowIndex The index of the row to expand.             
             * @param colIndex               OptionalThe column index of the expand renderer that triggers the action, optional.              
             * @param duration               OptionalDuration in milliseconds of the optional animation.             
             * @param easing               OptionalEasing function of the optional animation.             
             * @param apply             
             */
            expandRow(rowIndex: number, colIndex: number, duration: number, easing: Function, apply: any): number;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the start of the date's month.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToMonth(date: Date, reuse: boolean): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Utility method that return the specific CSS prefix
             * for non standard CSS properties. Ex: -moz-border-radius.
             * 
             */
            getCSSPrefix(): String;
            /**
             * Returns the index of the expanded row or -1 if there's no row expanded.
             * 
             */
            getExpandedRowIndex(): number;
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Returns the renderers that are currently used to displayed the speficied item.
             * Returns an array of objects that contains two properties:
             * - container: The DOM node that contains the renderer.
             * - renderer: The dojox.calendar._RendererMixin instance.
             * Do not keep references on the renderers are they are recycled and reused for other items.
             * 
             * @param item The data or render item.             
             */
            getRenderers(item: Object): any;
            /**
             * Returns the sub column at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getSubColumn(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the sub column index that has the specified value, if any. -1 otherwise. 
             * 
             * @param value The sub column index.             
             */
            getSubColumnIndex(value: String): number;
            /**
             * Returns the time displayed at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getTime(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the week number string from dojo.date.locale.format() method as
             * dojox.date.XXXX calendar are not supporting the "w" pattern.
             * 
             * @param date The date to format.             
             */
            getWeekNumberLabel(date: Date): any;
            /**
             * Triggers a re-layout of the renderers.
             * 
             */
            invalidateLayout(): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Determines if a node has an ascendant node that has the css class specified.
             * 
             * @param node The DOM node.             
             * @param ancestor The ancestor node used to limit the search in hierarchy.             
             * @param className The css class name.             
             */
            isAscendantHasClass(node: HTMLElement, ancestor: HTMLElement, className: String): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Returns whether an item is being edited or not.
             * 
             * @param item The item to test.             
             */
            isItemBeingEdited(item: Object): any;
            /**
             * Computes whether particular item renderer can be edited or not.
             * By default it is using the editable property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is focused or not.
             * 
             * @param item The item.             
             */
            isItemFocused(item: Object): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * 
             * @param item             
             */
            isItemSelected(item: any): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Computes if the first time range defined by the start1 and end1 parameters 
             * is overlapping the second time range defined by the start2 and end2 parameters.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            isOverlapping(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Tests if the specified dates are in the same day.
             * 
             * @param date1 The first date.             
             * @param date2 The second date.             
             */
            isSameDay(date1: Date, date2: Date): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Determines whether the specified date is a week-end.
             * This method is using dojo.date.locale.isWeekend() method as
             * dojox.date.XXXX calendars are not supporting this method.
             * 
             * @param date The date to test.               
             */
            isWeekEnd(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:the time in milliseconds since gregorian epoch.a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            refreshRendering(): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             * @param e             
             */
            resize(e: any): void;
            /**
             * If the view is scrollable, scrolls it vertically to the specified direction.
             * 
             * @param dir Direction of the scroll. Valid values are -1 and 1.             
             */
            scrollView(dir: number): void;
            /**
             * 
             * @param e             
             * @param item             
             * @param renderer             
             * @param dispatch             
             */
            selectFromEvent(e: any, item: any, renderer: any, dispatch: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * 
             * @param item             
             * @param value             
             */
            setItemSelected(item: any, value: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Styles the CSS classes to the node that displays a column header cell.
             * By default this method is setting the "dojoxCalendarWeekend" if the day of week represents a weekend.
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date The date displayed by this column             
             * @param renderData The render data.             
             */
            styleColumnHeaderCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a cell.
             * Delegates to styleGridCellFunc if defined or defaultStyleGridCell otherwise.
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param renderData The render data.             
             */
            styleGridCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a row header cell.
             * By default this method is doing nothing.
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date The date in the week.             
             * @param renderData The render data.             
             */
            styleRowHeaderCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates all the renderers that represents the specified item(s).
             * 
             * @param obj A render item or an array of render items.             
             * @param stateOnly Whether only the state of the item has changed (selected, edited, edited, focused) or a more global change has occured.             
             */
            updateRenderers(obj: Object, stateOnly: boolean): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Event dispatched at the end of an expand or collapse animation.
             * 
             * @param expand Whether the finished animation was an expand or a collapse animation.             
             */
            onExpandAnimationEnd(expand: boolean): void;
            /**
             * Event dispatched when an expand renderer is clicked.
             * 
             * @param e Expand renderer click event.             
             */
            onExpandRendererClick(e: Object): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked.
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e             
             */
            onItemEditBegin(e: any): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e             
             */
            onItemEditEnd(e: any): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view             
             */
            onRenderersLayoutDone(view: any): void;
            /**
             * Event dispatched when a row header cell is clicked.
             * 
             * @param e Header click event.             
             */
            onRowHeaderClick(e: Object): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/ColumnView.html
         *
         * This class defines a simple column view that also uses a secondary 
         * sheet to display long or all day events. 
         * By default an dojox.calendar.ColumnViewSecondarySheet instance is created.
         * Set the secondarySheetClass property to define the class to instantiate,
         * for example to mix the default class with Mouse, Keyboard or Touch plugins. 
         * 
         */
        class ColumnView extends dojox.calendar.SimpleColumnView {
            constructor();
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "allowResizeLessThan24H": boolean;
            set(property:"allowResizeLessThan24H", value: boolean): void;
            get(property:"allowResizeLessThan24H"): boolean;
            watch(property:"allowResizeLessThan24H", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "allowStartEndSwap": boolean;
            set(property:"allowStartEndSwap", value: boolean): void;
            get(property:"allowStartEndSwap"): boolean;
            watch(property:"allowStartEndSwap", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If several sub columns are displayed, indicated if the data item can be reassigned to another sub column by an editing gesture.
             * 
             */
            "allowSubColumnMove": boolean;
            set(property:"allowSubColumnMove", value: boolean): void;
            get(property:"allowSubColumnMove"): boolean;
            watch(property:"allowSubColumnMove", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled automatically. 
             * Auto scrolling is used when moving focus to a non visible renderer using keyboard 
             * and while editing an item. 
             * 
             */
            "autoScroll": boolean;
            set(property:"autoScroll", value: boolean): void;
            get(property:"autoScroll"): boolean;
            watch(property:"autoScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of column to display (from the startDate).
             * 
             */
            "columnCount": number;
            set(property:"columnCount", value: number): void;
            get(property:"columnCount"): number;
            watch(property:"columnCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for column header labels to override default one coming from the CLDR.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "columnHeaderDatePattern": string;
            set(property:"columnHeaderDatePattern", value: string): void;
            get(property:"columnHeaderDatePattern"): string;
            watch(property:"columnHeaderDatePattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The maximum delay between two taps needed to trigger an "itemDoubleClick" event, in touch context.      
             * 
             */
            "doubleTapDelay": number;
            set(property:"doubleTapDelay", value: number): void;
            get(property:"doubleTapDelay"): number;
            watch(property:"doubleTapDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Function;
            set(property:"formatItemTimeFunc", value: Function): void;
            get(property:"formatItemTimeFunc"): Function;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Padding between the header (composed of the secondary sheet and the column header) 
             * and the primary sheet.
             * 
             */
            "headerPadding": number;
            set(property:"headerPadding", value: number): void;
            get(property:"headerPadding"): number;
            watch(property:"headerPadding", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The number of pixels between two item renderers that are overlapping each other if the percentOverlap property is 0.
             * 
             */
            "horizontalGap": number;
            set(property:"horizontalGap", value: number): void;
            get(property:"horizontalGap"): number;
            watch(property:"horizontalGap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The desired size in pixels of an hour on the screen.
             * Note that the effective size may be different as the time slot size must be an integer.
             * 
             */
            "hourSize": number;
            set(property:"hourSize", value: number): void;
            get(property:"hourSize"): number;
            watch(property:"hourSize", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The currently hovered data item.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The associated array item to renderer list.
             * 
             */
            "itemToRenderer": Object;
            set(property:"itemToRenderer", value: Object): void;
            get(property:"itemToRenderer"): Object;
            watch(property:"itemToRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to associate a kind of renderer ("horizontal", "label" or null) with the specified item.
             * By default, if an item is lasting more that 24 hours an horizontal item is used, otherwise a label is used.
             * 
             */
            "itemToRendererKindFunc": Function;
            set(property:"itemToRendererKindFunc", value: Function): void;
            get(property:"itemToRendererKindFunc"): Function;
            watch(property:"itemToRendererKindFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * An optional comparison function use to determine the order the item will be laid out
             * The function is used to sort an array and must, as any sorting function, take two items 
             * as argument and must return an integer whose sign define order between arguments.
             * By default, a comparison by start time then end time is used.
             * 
             */
            "layoutPriorityFunction": Function;
            set(property:"layoutPriorityFunction", value: Function): void;
            get(property:"layoutPriorityFunction"): Function;
            watch(property:"layoutPriorityFunction", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * 
             */
            "liveLayout": boolean;
            set(property:"liveLayout", value: boolean): void;
            get(property:"liveLayout"): boolean;
            watch(property:"liveLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The maximum hour to be displayed. It must be in the [1,36] interval and must be greater than the minHours.  
             * 
             */
            "maxHours": number;
            set(property:"maxHours", value: number): void;
            get(property:"maxHours"): number;
            watch(property:"maxHours", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The minimum column width. If the number of columns and sub columns displayed makes the
             * width of a column greater than this property, a horizontal scroll bar is displayed.
             * If value <= 0, this constraint is ignored and the columns are using the available space.
             * 
             */
            "minColumnWidth": number;
            set(property:"minColumnWidth", value: number): void;
            get(property:"minColumnWidth"): number;
            watch(property:"minColumnWidth", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationSteps": number;
            set(property:"minDurationSteps", value: number): void;
            get(property:"minDurationSteps"): number;
            watch(property:"minDurationSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationUnit": string;
            set(property:"minDurationUnit", value: string): void;
            get(property:"minDurationUnit"): string;
            watch(property:"minDurationUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The minimum hour to be displayed. It must be in the [0,23] interval and must be lower than the maxHours.
             * 
             */
            "minHours": number;
            set(property:"minHours", value: number): void;
            get(property:"minHours"): number;
            watch(property:"minHours", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The percentage of the renderer width used to superimpose one item renderer on another 
             * when two events are overlapping.
             * 
             */
            "percentOverlap": number;
            set(property:"percentOverlap", value: number): void;
            get(property:"percentOverlap"): number;
            watch(property:"percentOverlap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The render data is the object that contains all the properties needed to render the component.
             * 
             */
            "renderData": Object;
            set(property:"renderData", value: Object): void;
            get(property:"renderData"): Object;
            watch(property:"renderData", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of used renderers
             * 
             */
            "rendererList": any[];
            set(property:"rendererList", value: any[]): void;
            get(property:"rendererList"): any[];
            watch(property:"rendererList", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The stack of recycled renderers available.
             * 
             */
            "rendererPool": any[];
            set(property:"rendererPool", value: any[]): void;
            get(property:"rendererPool"): any[];
            watch(property:"rendererPool", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * CSS value to apply to the cursor while resizing an item renderer. 
             * 
             */
            "resizeCursor": string;
            set(property:"resizeCursor", value: string): void;
            get(property:"resizeCursor"): string;
            watch(property:"resizeCursor", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Offset of the first row label from the top of the first row header cell in pixels.
             * 
             */
            "rowHeaderFirstLabelOffset": number;
            set(property:"rowHeaderFirstLabelOffset", value: number): void;
            get(property:"rowHeaderFirstLabelOffset"): number;
            watch(property:"rowHeaderFirstLabelOffset", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Duration of the time slot in minutes in the row header. Must be a divisor of 60 and a multiple/divisor of timeSlotDuration.
             * 
             */
            "rowHeaderGridSlotDuration": number;
            set(property:"rowHeaderGridSlotDuration", value: number): void;
            get(property:"rowHeaderGridSlotDuration"): number;
            watch(property:"rowHeaderGridSlotDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Offset of the row label from the top of the row header cell in pixels.
             * 
             */
            "rowHeaderLabelOffset": number;
            set(property:"rowHeaderLabelOffset", value: number): void;
            get(property:"rowHeaderLabelOffset"): number;
            watch(property:"rowHeaderLabelOffset", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Duration of the time slot in minutes in the row header labels. Must be a divisor of 60 and a multiple/divisor of timeSlotDuration.
             * 
             */
            "rowHeaderLabelSlotDuration": number;
            set(property:"rowHeaderLabelSlotDuration", value: number): void;
            get(property:"rowHeaderLabelSlotDuration"): number;
            watch(property:"rowHeaderLabelSlotDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for the row header labels to override default one coming from the CLDR.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "rowHeaderTimePattern": string;
            set(property:"rowHeaderTimePattern", value: string): void;
            get(property:"rowHeaderTimePattern"): string;
            watch(property:"rowHeaderTimePattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled or not.
             * 
             */
            "scrollable": boolean;
            set(property:"scrollable", value: boolean): void;
            get(property:"scrollable"): boolean;
            watch(property:"scrollable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Position of the scroll bar in right-to-left display.
             * Valid values are "left" and "right", default value is "left".
             * 
             */
            "scrollBarRTLPosition": string;
            set(property:"scrollBarRTLPosition", value: string): void;
            get(property:"scrollBarRTLPosition"): string;
            watch(property:"scrollBarRTLPosition", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Method used to scroll the view, for example the scroll of column view.
             * Valid value are:
             * 
             * "auto": let the view decide (default),
             * "css": use css 3d transform,
             * "dom": use the scrollTop property.
             * 
             */
            "scrollMethod": string;
            set(property:"scrollMethod", value: string): void;
            get(property:"scrollMethod"): string;
            watch(property:"scrollMethod", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Secondary sheet constructor parameters.
             * 
             */
            "secondarySheetProps": Object;
            set(property:"secondarySheetProps", value: Object): void;
            get(property:"secondarySheetProps"): Object;
            watch(property:"secondarySheetProps", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether show or not an indicator (default a red line) at the current time.
             * 
             */
            "showTimeIndicator": boolean;
            set(property:"showTimeIndicator", value: boolean): void;
            get(property:"showTimeIndicator"): boolean;
            watch(property:"showTimeIndicator", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "snapSteps": number;
            set(property:"snapSteps", value: number): void;
            get(property:"snapSteps"): number;
            watch(property:"snapSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "snapUnit": string;
            set(property:"snapUnit", value: string): void;
            get(property:"snapUnit"): string;
            watch(property:"snapUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the time interval displayed.
             * If not set at initialization time, will be set to current day.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * First time (hour/minute) of day displayed, if reachable. 
             * An object containing "hours" and "minutes" properties.
             * 
             */
            "startTimeOfDay": Object;
            set(property:"startTimeOfDay", value: Object): void;
            get(property:"startTimeOfDay"): Object;
            watch(property:"startTimeOfDay", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "stayInView": boolean;
            set(property:"stayInView", value: boolean): void;
            get(property:"stayInView"): boolean;
            watch(property:"stayInView", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom function to customize the appearance of a grid cell by installing custom CSS class on the node.
             * The signature of the function must be the same then the styleGridCell one.
             * By default the defaultStyleGridCell function is used.
             * 
             */
            "styleGridCellFunc": Function;
            set(property:"styleGridCellFunc", value: Function): void;
            get(property:"styleGridCellFunc"): Function;
            watch(property:"styleGridCellFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "subColumns": Object;
            set(property:"subColumns", value: Object): void;
            get(property:"subColumns"): Object;
            watch(property:"subColumns", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Maximal interval between two refreshes of time indicator.
             * 
             */
            "timeIndicatorRefreshInterval": number;
            set(property:"timeIndicatorRefreshInterval", value: number): void;
            get(property:"timeIndicatorRefreshInterval"): number;
            watch(property:"timeIndicatorRefreshInterval", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Duration of the time slot in minutes. Must be a divisor of 60.
             * 
             */
            "timeSlotDuration": number;
            set(property:"timeSlotDuration", value: number): void;
            get(property:"timeSlotDuration"): number;
            watch(property:"timeSlotDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The class use to create vertical renderers.
             * 
             */
            "verticalRenderer": Object;
            set(property:"verticalRenderer", value: Object): void;
            get(property:"verticalRenderer"): Object;
            watch(property:"verticalRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Type of the view. Used by the calendar widget to determine how to configure the view.
             * This view kind is "columns".
             * 
             */
            "viewKind": string;
            set(property:"viewKind", value: string): void;
            get(property:"viewKind"): string;
            watch(property:"viewKind", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Function invoked just after the view is displayed by the calendar.
             * 
             */
            afterActivate(): void;
            /**
             * Function invoked just after the view is the view is hidden or removed by the calendar.
             * 
             */
            afterDeactivate(): void;
            /**
             * Applies the z-index to the renderer based on the state of the item.
             * This methods is setting a z-index of 20 is the item is selected or edited 
             * and the current lane value computed by the overlap layout (i.e. the renderers 
             * are stacked according to their lane).
             * 
             * @param item The render item.             
             * @param renderer A renderer associated with the render item.             
             * @param hovered Whether the item is hovered or not.             
             * @param selected Whether the item is selected or not.             
             * @param edited Whether the item is being edited not not.             
             * @param focused Whether the item is focused not not.             
             */
            applyRendererZIndex(item: Object, renderer: Object, hovered: boolean, selected: boolean, edited: boolean, focused: boolean): void;
            /**
             * Function invoked just before the view is displayed by the calendar.
             * 
             */
            beforeActivate(): void;
            /**
             * 
             */
            beforeDeactivate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * Computes the overlap layout of a list of items. A lane and extent properties are added to each layout item.
             * 
             * @param layoutItems List of layout items, each item must have a start and end properties.             
             * @param func             
             */
            computeOverlapping(layoutItems: Object[], func: any): any;
            /**
             * Computes the time to pixel projection in a day.
             * 
             * @param renderData The render data.             
             * @param refDate The reference date that defines the destination date.             
             * @param date The reference dates (at least one).              
             * @param max The size in pixels of the representation of a day.             
             */
            computeProjectionOnDate(renderData: Object, refDate: Date, date: Date[], max: number): any;
            /**
             * Computes the overlap time range of the time ranges.
             * Returns a vector of Date with at index 0 the start time and at index 1 the end time.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            computeRangeOverlap(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * A user supplied function that creates a new event.
             * 
             * @param view the current view,             
             * @param d the date at the clicked location.             
             * @param e the mouse event (can be used to return null for example)             
             */
            createItemFunc(view: dojox.calendar.ViewBase, d: Date, e: MouseEvent): void;
            /**
             * Styles the CSS classes to the node that displays a cell.
             * By default this method is setting:
             * - "dojoxCalendarToday" class name if the date displayed is the current date,
             * - "dojoxCalendarWeekend" if the date represents a weekend,
             * - the CSS class corresponding of the displayed day of week ("Sun", "Mon" and so on),
             * - the CSS classes corresponfing to the time of day (e.g. "H14" and "M30" for for 2:30pm).   
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param hours The hours part of time of day displayed by the start of this cell.             
             * @param minutes The minutes part of time of day displayed by the start of this cell.             
             * @param renderData The render data object.             
             */
            defaultStyleGridCell(node: HTMLElement, date: Date, hours: number, minutes: number, renderData: Object): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             * @param preserveDom             
             */
            destroy(preserveDom?: any): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * During the resize editing gesture, ensures that the item has the specified minimal duration.
             * 
             * @param renderData The render data.             
             * @param item The edited item.             
             * @param unit The unit used to define the minimal duration.             
             * @param steps The number of time units.             
             * @param editKind The edit kind: "resizeStart" or "resizeEnd".             
             */
            ensureMinimalDuration(renderData: Object, item: Object, unit: String, steps: number, editKind: String): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param margin Margin in minutes around the time range.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, margin: number, visibilityTarget: String, duration: number): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param margin Margin in minutes around the time range.             
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, visibilityTarget: String, margin: number, duration: number): void;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the start of the date's month.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToMonth(date: Date, reuse: boolean): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Utility method that return the specific CSS prefix
             * for non standard CSS properties. Ex: -moz-border-radius.
             * 
             */
            getCSSPrefix(): String;
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Returns the renderers that are currently used to displayed the speficied item.
             * Returns an array of objects that contains two properties:
             * - container: The DOM node that contains the renderer.
             * - renderer: The dojox.calendar._RendererMixin instance.
             * Do not keep references on the renderers are they are recycled and reused for other items.
             * 
             * @param item The data or render item.             
             */
            getRenderers(item: Object): any;
            /**
             * Returns the secondary sheet
             * 
             */
            getSecondarySheet(): any;
            /**
             * Returns the sub column at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getSubColumn(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the sub column index that has the specified value, if any. -1 otherwise. 
             * 
             * @param value The sub column index.             
             */
            getSubColumnIndex(value: String): number;
            /**
             * Returns the time displayed at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getTime(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Return the time of day associated to the specified position.
             * 
             * @param pos The position in pixels.             
             * @param rd The render data.             
             */
            getTimeOfDay(pos: number, rd: Object): Object;
            /**
             * Returns the week number string from dojo.date.locale.format() method as
             * dojox.date.XXXX calendar are not supporting the "w" pattern.
             * 
             * @param date The date to format.             
             */
            getWeekNumberLabel(date: Date): any;
            /**
             * 
             */
            invalidateRendering(): void;
            /**
             * Determines if a node has an ascendant node that has the css class specified.
             * 
             * @param node The DOM node.             
             * @param ancestor The ancestor node used to limit the search in hierarchy.             
             * @param className The css class name.             
             */
            isAscendantHasClass(node: HTMLElement, ancestor: HTMLElement, className: String): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Returns whether an item is being edited or not.
             * 
             * @param item The item to test.             
             */
            isItemBeingEdited(item: Object): any;
            /**
             * Computes whether particular item renderer can be edited or not.
             * By default it is using the editable property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is focused or not.
             * 
             * @param item The item.             
             */
            isItemFocused(item: Object): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * 
             * @param item             
             */
            isItemSelected(item: any): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Computes if the first time range defined by the start1 and end1 parameters 
             * is overlapping the second time range defined by the start2 and end2 parameters.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            isOverlapping(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Tests if the specified dates are in the same day.
             * 
             * @param date1 The first date.             
             * @param date2 The second date.             
             */
            isSameDay(date1: Date, date2: Date): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Determines whether the specified date is a week-end.
             * This method is using dojo.date.locale.isWeekend() method as
             * dojox.date.XXXX calendars are not supporting this method.
             * 
             * @param date The date to test.               
             */
            isWeekEnd(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:the time in milliseconds since gregorian epoch.a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * Processing after the DOM fragment is created
             * Called after the DOM fragment has been created, but not necessarily
             * added to the document.  Do not include any operations which rely on
             * node dimensions or placement.
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postscript(): void;
            /**
             * 
             */
            refreshRendering(): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * Resizes the secondary sheet header and relayout the other sub components according this new height.
             * Warning: this method is only available for the default template and default CSS.
             * 
             * @param height The new height in pixels.             
             */
            resizeSecondarySheet(height: number): void;
            /**
             * Scrolls the view to the specified direction of one time slot duration.
             * 
             * @param dir Direction of the scroll. Valid values are -1 and 1.             
             */
            scrollView(dir: number): void;
            /**
             * Scrolls the view horizontally to the specified direction of one column or sub column (if set).
             * 
             * @param dir Direction of the scroll. Valid values are -1 and 1.             
             */
            scrollViewHorizontal(dir: number): void;
            /**
             * The secondary sheet class, by default dojox.calendar.ColumnViewSecondarySheet.
             * 
             */
            secondarySheetClass(): void;
            /**
             * 
             * @param e             
             * @param item             
             * @param renderer             
             * @param dispatch             
             */
            selectFromEvent(e: any, item: any, renderer: any, dispatch: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * 
             * @param item             
             * @param value             
             */
            setItemSelected(item: any, value: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Styles the CSS classes to the node that displays a column header cell.
             * By default this method is setting:
             * - "dojoxCalendarToday" class name if the date displayed is the current date,
             * - "dojoxCalendarWeekend" if the date represents a weekend,
             * - the CSS class corresponding of the displayed day of week ("Sun", "Mon" and so on).
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date The date displayed by this column             
             * @param renderData The render data.             
             */
            styleColumnHeaderCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a cell.
             * Delegates to styleGridCellFunc if defined or defaultStyleGridCell otherwise.
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this column             
             * @param hours             
             * @param minutes             
             * @param renderData The render data object.             
             */
            styleGridCell(node: HTMLElement, date: Date, hours: any, minutes: any, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a row header cell.
             * By default this method is doing nothing.
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param h The time of day displayed by this row header cell.             
             * @param m             
             * @param renderData The render data.             
             */
            styleRowHeaderCell(node: HTMLElement, h: number, m: any, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a sub column header cell.
             * By default this method is not setting anythin:
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date             
             * @param renderData The render data.             
             */
            styleSubColumnHeaderCell(node: HTMLElement, date: any, renderData: Object): void;
            /**
             * Computes the label for a sub column from the subColumns property.
             * By default, return the value.
             * 
             * @param value             
             */
            subColumnLabelFunc(value: any): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             * @param obj             
             * @param stateOnly             
             */
            updateRenderers(obj: any, stateOnly: any): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Event dispatched when a column header cell is dispatched.
             * 
             * @param e The event has the following properties             
             */
            onColumnHeaderClick(e: Object): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked.
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e             
             */
            onItemEditBegin(e: any): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e             
             */
            onItemEditEnd(e: any): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view             
             */
            onRenderersLayoutDone(view: any): void;
            /**
             * Event dispatched when the row header cell of the secondary sheet is clicked.
             * 
             * @param e             
             */
            onRowHeaderClick(e: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/MatrixView.html
         *
         * The matrix view is a calendar view that displaying a matrix where each cell is a day.
         * 
         */
        class MatrixView extends dojox.calendar.ViewBase implements dijit._TemplatedMixin {
            constructor();
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "allowResizeLessThan24H": boolean;
            set(property:"allowResizeLessThan24H", value: boolean): void;
            get(property:"allowResizeLessThan24H"): boolean;
            watch(property:"allowResizeLessThan24H", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "allowStartEndSwap": boolean;
            set(property:"allowStartEndSwap", value: boolean): void;
            get(property:"allowStartEndSwap"): boolean;
            watch(property:"allowStartEndSwap", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If several sub columns are displayed, indicated if the data item can be reassigned to another sub column by an editing gesture.
             * 
             */
            "allowSubColumnMove": boolean;
            set(property:"allowSubColumnMove", value: boolean): void;
            get(property:"allowSubColumnMove"): boolean;
            watch(property:"allowSubColumnMove", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled automatically. 
             * Auto scrolling is used when moving focus to a non visible renderer using keyboard 
             * and while editing an item. 
             * 
             */
            "autoScroll": boolean;
            set(property:"autoScroll", value: boolean): void;
            get(property:"autoScroll"): boolean;
            watch(property:"autoScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for grid cell label to override default one coming from the CLDR.
             * The long pattern is used for the first day of month or the first displayed day of a month.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "cellHeaderLongPattern": string;
            set(property:"cellHeaderLongPattern", value: string): void;
            get(property:"cellHeaderLongPattern"): string;
            watch(property:"cellHeaderLongPattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for grid cell label to override default one coming from the CLDR.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "cellHeaderShortPattern": string;
            set(property:"cellHeaderShortPattern", value: string): void;
            get(property:"cellHeaderShortPattern"): string;
            watch(property:"cellHeaderShortPattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The top offset in pixels of each cell applied by the layout.
             * 
             */
            "cellPaddingTop": number;
            set(property:"cellPaddingTop", value: number): void;
            get(property:"cellPaddingTop"): number;
            watch(property:"cellPaddingTop", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of column to display (from the startDate).
             * 
             */
            "columnCount": number;
            set(property:"columnCount", value: number): void;
            get(property:"columnCount"): number;
            watch(property:"columnCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The maximum delay between two taps needed to trigger an "itemDoubleClick" event, in touch context.      
             * 
             */
            "doubleTapDelay": number;
            set(property:"doubleTapDelay", value: number): void;
            get(property:"doubleTapDelay"): number;
            watch(property:"doubleTapDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Duration of the animation when expanding or collapsing a row.
             * 
             */
            "expandDuration": number;
            set(property:"expandDuration", value: number): void;
            get(property:"expandDuration"): number;
            watch(property:"expandDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Easing function of the animation when expanding or collapsing a row (null by default).
             * 
             */
            "expandEasing": Function;
            set(property:"expandEasing", value: Function): void;
            get(property:"expandEasing"): Function;
            watch(property:"expandEasing", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The class use to create drill down renderers.       
             * 
             */
            "expandRenderer": Object;
            set(property:"expandRenderer", value: Object): void;
            get(property:"expandRenderer"): Object;
            watch(property:"expandRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The height in pixels of the expand/collapse renderers that is applied by the layout.
             * 
             */
            "expandRendererHeight": number;
            set(property:"expandRendererHeight", value: number): void;
            get(property:"expandRendererHeight"): number;
            watch(property:"expandRendererHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Function;
            set(property:"formatItemTimeFunc", value: Function): void;
            get(property:"formatItemTimeFunc"): Function;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The class use to create horizontal renderers.
             * 
             */
            "horizontalRenderer": Object;
            set(property:"horizontalRenderer", value: Object): void;
            get(property:"horizontalRenderer"): Object;
            watch(property:"horizontalRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The height in pixels of the horizontal and label renderers that is applied by the layout.
             * 
             */
            "horizontalRendererHeight": number;
            set(property:"horizontalRendererHeight", value: number): void;
            get(property:"horizontalRendererHeight"): number;
            watch(property:"horizontalRendererHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The currently hovered data item.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The associated array item to renderer list.
             * 
             */
            "itemToRenderer": Object;
            set(property:"itemToRenderer", value: Object): void;
            get(property:"itemToRenderer"): Object;
            watch(property:"itemToRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to associate a kind of renderer ("horizontal", "label" or null) with the specified item.
             * By default, if an item is lasting more that 24 hours an horizontal item is used, otherwise a label is used.
             * 
             */
            "itemToRendererKindFunc": Function;
            set(property:"itemToRendererKindFunc", value: Function): void;
            get(property:"itemToRendererKindFunc"): Function;
            watch(property:"itemToRendererKindFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The class use to create label renderers.
             * 
             */
            "labelRenderer": Object;
            set(property:"labelRenderer", value: Object): void;
            get(property:"labelRenderer"): Object;
            watch(property:"labelRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "labelRendererHeight": number;
            set(property:"labelRendererHeight", value: number): void;
            get(property:"labelRendererHeight"): number;
            watch(property:"labelRendererHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Indicates if the item renderers' position and size is updated or if they are hidden during a resize of the widget. 
             * 
             */
            "layoutDuringResize": boolean;
            set(property:"layoutDuringResize", value: boolean): void;
            get(property:"layoutDuringResize"): boolean;
            watch(property:"layoutDuringResize", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional comparison function use to determine the order the item will be laid out
             * The function is used to sort an array and must, as any sorting function, take two items 
             * as argument and must return an integer whose sign define order between arguments.
             * By default, a comparison by start time then end time is used.
             * 
             */
            "layoutPriorityFunction": Function;
            set(property:"layoutPriorityFunction", value: Function): void;
            get(property:"layoutPriorityFunction"): Function;
            watch(property:"layoutPriorityFunction", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * 
             */
            "liveLayout": boolean;
            set(property:"liveLayout", value: boolean): void;
            get(property:"liveLayout"): boolean;
            watch(property:"liveLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationSteps": number;
            set(property:"minDurationSteps", value: number): void;
            get(property:"minDurationSteps"): number;
            watch(property:"minDurationSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationUnit": string;
            set(property:"minDurationUnit", value: string): void;
            get(property:"minDurationUnit"): string;
            watch(property:"minDurationUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "naturalRowsHeight": Object;
            set(property:"naturalRowsHeight", value: Object): void;
            get(property:"naturalRowsHeight"): Object;
            watch(property:"naturalRowsHeight", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The percentage of the renderer width used to superimpose one item renderers on another 
             * when two events are overlapping. By default 0.
             * 
             */
            "percentOverlap": number;
            set(property:"percentOverlap", value: number): void;
            get(property:"percentOverlap"): number;
            watch(property:"percentOverlap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "refEndTime": Object;
            set(property:"refEndTime", value: Object): void;
            get(property:"refEndTime"): Object;
            watch(property:"refEndTime", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * (Optional) Start of the time interval of interest. 
             * It is used to style differently the displayed rows out of the 
             * time interval of interest.          
             * 
             */
            "refStartTime": Object;
            set(property:"refStartTime", value: Object): void;
            get(property:"refStartTime"): Object;
            watch(property:"refStartTime", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The render data object contains all the data needed to render the widget.
             * 
             */
            "renderData": Object;
            set(property:"renderData", value: Object): void;
            get(property:"renderData"): Object;
            watch(property:"renderData", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of used renderers
             * 
             */
            "rendererList": any[];
            set(property:"rendererList", value: any[]): void;
            get(property:"rendererList"): any[];
            watch(property:"rendererList", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The stack of recycled renderers available.
             * 
             */
            "rendererPool": any[];
            set(property:"rendererPool", value: any[]): void;
            get(property:"rendererPool"): any[];
            watch(property:"rendererPool", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * Duration, in milliseconds, of the fade animation showing the item renderers after a widget resize.
             * 
             */
            "resizeAnimationDuration": number;
            set(property:"resizeAnimationDuration", value: number): void;
            get(property:"resizeAnimationDuration"): number;
            watch(property:"resizeAnimationDuration", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "resizeCursor": string;
            set(property:"resizeCursor", value: string): void;
            get(property:"resizeCursor"): string;
            watch(property:"resizeCursor", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * For horizontal renderers that are not filling entire days, whether fill the day or not.
             * 
             */
            "roundToDay": boolean;
            set(property:"roundToDay", value: boolean): void;
            get(property:"roundToDay"): boolean;
            watch(property:"roundToDay", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The number of rows to display (from the startDate).
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "scrollable": boolean;
            set(property:"scrollable", value: boolean): void;
            get(property:"scrollable"): boolean;
            watch(property:"scrollable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Method used to scroll the view, for example the scroll of column view.
             * Valid value are:
             * 
             * "auto": let the view decide (default),
             * "css": use css 3d transform,
             * "dom": use the scrollTop property.
             * 
             */
            "scrollMethod": string;
            set(property:"scrollMethod", value: string): void;
            get(property:"scrollMethod"): string;
            watch(property:"scrollMethod", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether display or not the grid cells label (usually the day of month).
             * 
             */
            "showCellLabel": boolean;
            set(property:"showCellLabel", value: boolean): void;
            get(property:"showCellLabel"): boolean;
            watch(property:"showCellLabel", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "snapSteps": number;
            set(property:"snapSteps", value: number): void;
            get(property:"snapSteps"): number;
            watch(property:"snapSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "snapUnit": string;
            set(property:"snapUnit", value: string): void;
            get(property:"snapUnit"): string;
            watch(property:"snapUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the time interval displayed.
             * If not set at initialization time, will be set to current day.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "stayInView": boolean;
            set(property:"stayInView", value: boolean): void;
            get(property:"stayInView"): boolean;
            watch(property:"stayInView", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom function to customize the appearance of a grid cell by installing custom CSS class on the node.
             * The signature of the function must be the same then the styleGridCell one.
             * By default the defaultStyleGridCell function is used.
             * 
             */
            "styleGridCellFunc": Function;
            set(property:"styleGridCellFunc", value: Function): void;
            get(property:"styleGridCellFunc"): Function;
            watch(property:"styleGridCellFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "triggerExtent": number;
            set(property:"triggerExtent", value: number): void;
            get(property:"triggerExtent"): number;
            watch(property:"triggerExtent", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The number of pixels between two item renderers that are overlapping each other if the percentOverlap property is 0.
             * 
             */
            "verticalGap": number;
            set(property:"verticalGap", value: number): void;
            get(property:"verticalGap"): number;
            watch(property:"verticalGap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Type of the view. Used by the calendar widget to determine how to configure the view.
             * This view kind is "matrix".
             * 
             */
            "viewKind": string;
            set(property:"viewKind", value: string): void;
            get(property:"viewKind"): string;
            watch(property:"viewKind", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Function invoked just after the view is displayed by the calendar.
             * 
             */
            afterActivate(): void;
            /**
             * Function invoked just after the view is the view is hidden or removed by the calendar.
             * 
             */
            afterDeactivate(): void;
            /**
             * Function invoked just before the view is displayed by the calendar.
             * 
             */
            beforeActivate(): void;
            /**
             * Function invoked just before the view is hidden or removed by the calendar.
             * 
             */
            beforeDeactivate(): void;
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * Collapses the expanded row, if any.
             * 
             * @param duration Duration in milliseconds of the optional animation.             
             * @param easing Easing function of the optional animation.             
             * @param apply             
             */
            collapseRow(duration: number, easing: Function, apply: any): void;
            /**
             * Computes the overlap layout of a list of items. A lane and extent properties are added to each layout item.
             * 
             * @param layoutItems List of layout items, each item must have a start and end properties.             
             * @param func             
             */
            computeOverlapping(layoutItems: Object[], func: any): any;
            /**
             * Computes the time to pixel projection in a day.
             * 
             * @param renderData The render data.             
             * @param refDate The reference date that defines the destination date.             
             * @param date The reference dates (at least one).              
             * @param max The size in pixels of the representation of a day.             
             */
            computeProjectionOnDate(renderData: Object, refDate: Date, date: Date[], max: number): any;
            /**
             * Computes the overlap time range of the time ranges.
             * Returns a vector of Date with at index 0 the start time and at index 1 the end time.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            computeRangeOverlap(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * A user supplied function that creates a new event.
             * 
             * @param view the current view,             
             * @param d the date at the clicked location.             
             * @param e the mouse event (can be used to return null for example)             
             */
            createItemFunc(view: dojox.calendar.ViewBase, d: Date, e: MouseEvent): void;
            /**
             * Styles the CSS classes to the node that displays a cell.
             * By default this method is setting the following CSS classes:
             * - "dojoxCalendarToday" class name if the date displayed is the current date, 
             * - "dojoxCalendarWeekend" if the date represents a weekend or
             * - "dojoxCalendarDayDisabled" if the date is out of the [refStartTime, refEndTime] interval.
             * - the CSS class corresponding of the displayed day of week ("Sun", "Mon" and so on).            
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param renderData The render data.             
             */
            defaultStyleGridCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             * @param preserveDom             
             */
            destroy(preserveDom?: any): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * During the resize editing gesture, ensures that the item has the specified minimal duration.
             * 
             * @param renderData The render data.             
             * @param item The edited item.             
             * @param unit The unit used to define the minimal duration.             
             * @param steps The number of time units.             
             * @param editKind The edit kind: "resizeStart" or "resizeEnd".             
             */
            ensureMinimalDuration(renderData: Object, item: Object, unit: String, steps: number, editKind: String): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param margin Margin in minutes around the time range.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, margin: number, visibilityTarget: String, duration: number): void;
            /**
             * Default action when an expand renderer is clicked.
             * 
             * @param e The mouse event.             
             * @param renderer The expand renderer.             
             */
            expandRendererClickHandler(e: Event, renderer: Object): void;
            /**
             * Expands the specified row.
             * 
             * @param rowIndex The index of the row to expand.             
             * @param colIndex               OptionalThe column index of the expand renderer that triggers the action, optional.              
             * @param duration               OptionalDuration in milliseconds of the optional animation.             
             * @param easing               OptionalEasing function of the optional animation.             
             * @param apply             
             */
            expandRow(rowIndex: number, colIndex: number, duration: number, easing: Function, apply: any): number;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the start of the date's month.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToMonth(date: Date, reuse: boolean): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Utility method that return the specific CSS prefix
             * for non standard CSS properties. Ex: -moz-border-radius.
             * 
             */
            getCSSPrefix(): String;
            /**
             * Returns the index of the expanded row or -1 if there's no row expanded.
             * 
             */
            getExpandedRowIndex(): number;
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Returns the renderers that are currently used to displayed the speficied item.
             * Returns an array of objects that contains two properties:
             * - container: The DOM node that contains the renderer.
             * - renderer: The dojox.calendar._RendererMixin instance.
             * Do not keep references on the renderers are they are recycled and reused for other items.
             * 
             * @param item The data or render item.             
             */
            getRenderers(item: Object): any;
            /**
             * Returns the sub column at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getSubColumn(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the sub column index that has the specified value, if any. -1 otherwise. 
             * 
             * @param value The sub column index.             
             */
            getSubColumnIndex(value: String): number;
            /**
             * Returns the time displayed at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getTime(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the week number string from dojo.date.locale.format() method as
             * dojox.date.XXXX calendar are not supporting the "w" pattern.
             * 
             * @param date The date to format.             
             */
            getWeekNumberLabel(date: Date): any;
            /**
             * Triggers a re-layout of the renderers.
             * 
             */
            invalidateLayout(): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Determines if a node has an ascendant node that has the css class specified.
             * 
             * @param node The DOM node.             
             * @param ancestor The ancestor node used to limit the search in hierarchy.             
             * @param className The css class name.             
             */
            isAscendantHasClass(node: HTMLElement, ancestor: HTMLElement, className: String): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Returns whether an item is being edited or not.
             * 
             * @param item The item to test.             
             */
            isItemBeingEdited(item: Object): any;
            /**
             * Computes whether particular item renderer can be edited or not.
             * By default it is using the editable property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is focused or not.
             * 
             * @param item The item.             
             */
            isItemFocused(item: Object): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * 
             * @param item             
             */
            isItemSelected(item: any): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Computes if the first time range defined by the start1 and end1 parameters 
             * is overlapping the second time range defined by the start2 and end2 parameters.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            isOverlapping(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Tests if the specified dates are in the same day.
             * 
             * @param date1 The first date.             
             * @param date2 The second date.             
             */
            isSameDay(date1: Date, date2: Date): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Determines whether the specified date is a week-end.
             * This method is using dojo.date.locale.isWeekend() method as
             * dojox.date.XXXX calendars are not supporting this method.
             * 
             * @param date The date to test.               
             */
            isWeekEnd(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:the time in milliseconds since gregorian epoch.a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            refreshRendering(): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             * @param e             
             */
            resize(e?: any): void;
            /**
             * If the view is scrollable, scrolls it vertically to the specified direction.
             * 
             * @param dir Direction of the scroll. Valid values are -1 and 1.             
             */
            scrollView(dir: number): void;
            /**
             * 
             * @param e             
             * @param item             
             * @param renderer             
             * @param dispatch             
             */
            selectFromEvent(e: any, item: any, renderer: any, dispatch: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * 
             * @param item             
             * @param value             
             */
            setItemSelected(item: any, value: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Styles the CSS classes to the node that displays a column header cell.
             * By default this method is setting the "dojoxCalendarWeekend" if the day of week represents a weekend.
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date The date displayed by this column             
             * @param renderData The render data.             
             */
            styleColumnHeaderCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a cell.
             * Delegates to styleGridCellFunc if defined or defaultStyleGridCell otherwise.
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param renderData The render data.             
             */
            styleGridCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a row header cell.
             * By default this method is doing nothing.
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date The date in the week.             
             * @param renderData The render data.             
             */
            styleRowHeaderCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates all the renderers that represents the specified item(s).
             * 
             * @param obj A render item or an array of render items.             
             * @param stateOnly Whether only the state of the item has changed (selected, edited, edited, focused) or a more global change has occured.             
             */
            updateRenderers(obj: Object, stateOnly: boolean): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Called when the selection changed.
             * 
             */
            onChange(): void;
            /**
             * Event dispatched at the end of an expand or collapse animation.
             * 
             * @param expand Whether the finished animation was an expand or a collapse animation.             
             */
            onExpandAnimationEnd(expand: boolean): void;
            /**
             * Event dispatched when an expand renderer is clicked.
             * 
             * @param e Expand renderer click event.             
             */
            onExpandRendererClick(e: Object): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event dispatched when the grid has been clicked.
             * 
             * @param e The event dispatched when the grid is clicked.             
             */
            onGridClick(e: Object): void;
            /**
             * Event dispatched when the grid has been double-clicked.
             * 
             * @param e The event dispatched when the grid is double-clicked.             
             */
            onGridDoubleClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been clicked.
             * 
             * @param e The event dispatched when an item is clicked.             
             */
            onItemClick(e: Object): void;
            /**
             * Event dispatched when an item renderer has been context-clicked.
             * 
             * @param e The event dispatched when an item is context-clicked.             
             */
            onItemContextMenu(e: Object): void;
            /**
             * Event dispatched when an item renderer has been double-clicked.
             * 
             * @param e The event dispatched when an item is double-clicked.             
             */
            onItemDoubleClick(e: Object): void;
            /**
             * Event dispatched when the item is entering the editing mode.
             * 
             * @param e             
             */
            onItemEditBegin(e: any): void;
            /**
             * Event dispatched when an editing gesture is beginning.
             * 
             * @param e The editing event.             
             */
            onItemEditBeginGesture(e: Object): void;
            /**
             * Event dispatched when the item is leaving the editing mode.
             * 
             * @param e             
             */
            onItemEditEnd(e: any): void;
            /**
             * Event dispatched at the end of an editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditEndGesture(e: Object): void;
            /**
             * Event dispatched during a move editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditMoveGesture(e: Object): void;
            /**
             * Event dispatched during a resize editing gesture.
             * 
             * @param e The editing event.             
             */
            onItemEditResizeGesture(e: Object): void;
            /**
             * Event dispatched when an item renderer has been created.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererCreated(e: Object): void;
            /**
             * Event dispatched when an item renderer is destroyed.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererDestroyed(e: Object): void;
            /**
             * Event dispatched when an item renderer has been recycled.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererRecycled(e: Object): void;
            /**
             * Event dispatched when an item renderer that was recycled is reused.
             * 
             * @param e The renderer lifecycle event.             
             */
            onRendererReused(e: Object): void;
            /**
             * Event triggered when item renderers layout has been done.
             * 
             * @param view             
             */
            onRenderersLayoutDone(view: any): void;
            /**
             * Event dispatched when a row header cell is clicked.
             * 
             * @param e Header click event.             
             */
            onRowHeaderClick(e: Object): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/calendar/MonthColumnView.html
         *
         * The month column view is a calendar view used to display a month per column where each cell of the column is a day.
         * 
         */
        class MonthColumnView extends dojox.calendar.ViewBase implements dijit._TemplatedMixin {
            constructor();
            /**
             * The attribute of the store item that contains the all day state of 
             * the events represented by this item.    Default is "allDay".
             * 
             */
            "allDayAttr": string;
            set(property:"allDayAttr", value: string): void;
            get(property:"allDayAttr"): string;
            watch(property:"allDayAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "allowResizeLessThan24H": boolean;
            set(property:"allowResizeLessThan24H", value: boolean): void;
            get(property:"allowResizeLessThan24H"): boolean;
            watch(property:"allowResizeLessThan24H", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "allowStartEndSwap": boolean;
            set(property:"allowStartEndSwap", value: boolean): void;
            get(property:"allowStartEndSwap"): boolean;
            watch(property:"allowStartEndSwap", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If several sub columns are displayed, indicated if the data item can be reassigned to another sub column by an editing gesture.
             * 
             */
            "allowSubColumnMove": boolean;
            set(property:"allowSubColumnMove", value: boolean): void;
            get(property:"allowSubColumnMove"): boolean;
            watch(property:"allowSubColumnMove", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled automatically. 
             * Auto scrolling is used when moving focus to a non visible renderer using keyboard 
             * and while editing an item. 
             * 
             */
            "autoScroll": boolean;
            set(property:"autoScroll", value: boolean): void;
            get(property:"autoScroll"): boolean;
            watch(property:"autoScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of column to display (from the startDate).
             * 
             */
            "columnCount": number;
            set(property:"columnCount", value: number): void;
            get(property:"columnCount"): number;
            watch(property:"columnCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Length of the column labels. Valid values are "wide" or "abbr".
             * 
             */
            "columnHeaderFormatLength": string;
            set(property:"columnHeaderFormatLength", value: string): void;
            get(property:"columnHeaderFormatLength"): string;
            watch(property:"columnHeaderFormatLength", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Indicates whether the user can create new event by clicking and dragging the grid.
             * A createItem function must be defined on the view or the calendar object.
             * 
             */
            "createOnGridClick": boolean;
            set(property:"createOnGridClick", value: boolean): void;
            get(property:"createOnGridClick"): boolean;
            watch(property:"createOnGridClick", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function that returns a css class name to apply to item renderers that are displaying the specified item in parameter. 
             * 
             */
            "cssClassFunc": Function;
            set(property:"cssClassFunc", value: Function): void;
            get(property:"cssClassFunc"): Function;
            watch(property:"cssClassFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * JavaScript namespace to find Calendar routines. Uses Gregorian Calendar routines at dojo.date by default.
             * 
             */
            "datePackage": Object;
            set(property:"datePackage", value: Object): void;
            get(property:"datePackage"): Object;
            watch(property:"datePackage", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The desired size in pixels of an hour on the screen.
             * Note that the effective size may be different as the time slot size must be an integer.
             * 
             */
            "daySize": number;
            set(property:"daySize", value: number): void;
            get(property:"daySize"): number;
            watch(property:"daySize", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * An optional function to transform store date into Date objects. Default is null. 
             * 
             */
            "decodeDate": Object;
            set(property:"decodeDate", value: Object): void;
            get(property:"decodeDate"): Object;
            watch(property:"decodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether the data items displayed must be recomputed, usually after the displayed 
             * time range has changed. 
             * 
             */
            "displayedItemsInvalidated": boolean;
            set(property:"displayedItemsInvalidated", value: boolean): void;
            get(property:"displayedItemsInvalidated"): boolean;
            watch(property:"displayedItemsInvalidated", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The maximum delay between two taps needed to trigger an "itemDoubleClick" event, in touch context.      
             * 
             */
            "doubleTapDelay": number;
            set(property:"doubleTapDelay", value: number): void;
            get(property:"doubleTapDelay"): number;
            watch(property:"doubleTapDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A flag that indicates whether or not the user can edit
             * items in the data provider.
             * If true, the item renderers in the control are editable.
             * The user can click on an item renderer, or use the keyboard or touch devices, to move or resize the associated event.
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An optional function to transform Date objects into store date. Default is null. 
             * 
             */
            "encodeDate": Object;
            set(property:"encodeDate", value: Object): void;
            get(property:"encodeDate"): Object;
            watch(property:"encodeDate", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the end time of 
             * the events represented by this item.    Default is "endTime".
             * 
             */
            "endTimeAttr": string;
            set(property:"endTimeAttr", value: string): void;
            get(property:"endTimeAttr"): string;
            watch(property:"endTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Optional function to format the time of day of the item renderers.
             * The function takes the date and render data object as arguments and returns a String.
             * 
             */
            "formatItemTimeFunc": Function;
            set(property:"formatItemTimeFunc", value: Function): void;
            get(property:"formatItemTimeFunc"): Function;
            watch(property:"formatItemTimeFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Custom date/time pattern for cell labels to override default one coming from the CLDR.
             * See dojo/date/locale documentation for format string.
             * 
             */
            "gridCellDatePattern": string;
            set(property:"gridCellDatePattern", value: string): void;
            get(property:"gridCellDatePattern"): string;
            watch(property:"gridCellDatePattern", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The number of pixels between two item renderers.
             * 
             */
            "horizontalGap": number;
            set(property:"horizontalGap", value: number): void;
            get(property:"horizontalGap"): number;
            watch(property:"horizontalGap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * The currently hovered data item.
             * 
             */
            "hoveredItem": Object;
            set(property:"hoveredItem", value: Object): void;
            get(property:"hoveredItem"): Object;
            watch(property:"hoveredItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidatingProperties": Object;
            set(property:"invalidatingProperties", value: Object): void;
            get(property:"invalidatingProperties"): Object;
            watch(property:"invalidatingProperties", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidRendering": boolean;
            set(property:"invalidRendering", value: boolean): void;
            get(property:"invalidRendering"): boolean;
            watch(property:"invalidRendering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The associated array item to renderer list.
             * 
             */
            "itemToRenderer": Object;
            set(property:"itemToRenderer", value: Object): void;
            get(property:"itemToRenderer"): Object;
            watch(property:"itemToRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * An optional function to associate a kind of renderer ("horizontal", "label" or null) with the specified item.
             * By default, if an item is lasting more that 24 hours an horizontal item is used, otherwise a label is used.
             * 
             */
            "itemToRendererKindFunc": Function;
            set(property:"itemToRendererKindFunc", value: Function): void;
            get(property:"itemToRendererKindFunc"): Function;
            watch(property:"itemToRendererKindFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * An optional comparison function use to determine the order the item will be laid out
             * The function is used to sort an array and must, as any sorting function, take two items 
             * as argument and must return an integer whose sign define order between arguments.
             * By default, a comparison by start time then end time is used.
             * 
             */
            "layoutPriorityFunction": Function;
            set(property:"layoutPriorityFunction", value: Function): void;
            get(property:"layoutPriorityFunction"): Function;
            watch(property:"layoutPriorityFunction", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * 
             */
            "liveLayout": boolean;
            set(property:"liveLayout", value: boolean): void;
            get(property:"liveLayout"): boolean;
            watch(property:"liveLayout", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationSteps": number;
            set(property:"minDurationSteps", value: number): void;
            get(property:"minDurationSteps"): number;
            watch(property:"minDurationSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "minDurationUnit": string;
            set(property:"minDurationUnit", value: string): void;
            get(property:"minDurationUnit"): string;
            watch(property:"minDurationUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the user can move items displayed.
             * If true, the user can move the items.
             * 
             */
            "moveEnabled": boolean;
            set(property:"moveEnabled", value: boolean): void;
            get(property:"moveEnabled"): boolean;
            watch(property:"moveEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The percentage of the renderer width used to superimpose one item renderer on another 
             * when two events are overlapping.
             * 
             */
            "percentOverlap": number;
            set(property:"percentOverlap", value: number): void;
            get(property:"percentOverlap"): number;
            watch(property:"percentOverlap", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * A query that can be passed to when querying the store.
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Options to be applied when querying the store.
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The render data is the object that contains all the properties needed to render the component.
             * 
             */
            "renderData": Object;
            set(property:"renderData", value: Object): void;
            get(property:"renderData"): Object;
            watch(property:"renderData", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of used renderers
             * 
             */
            "rendererList": any[];
            set(property:"rendererList", value: any[]): void;
            get(property:"rendererList"): any[];
            watch(property:"rendererList", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The stack of recycled renderers available.
             * 
             */
            "rendererPool": any[];
            set(property:"rendererPool", value: any[]): void;
            get(property:"rendererPool"): any[];
            watch(property:"rendererPool", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * CSS value to apply to the cursor while resizing an item renderer. 
             * 
             */
            "resizeCursor": string;
            set(property:"resizeCursor", value: string): void;
            get(property:"resizeCursor"): string;
            watch(property:"resizeCursor", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A flag that indicates whether the items can be resized.
             * If true, the control supports resizing of items.
             * 
             */
            "resizeEnabled": boolean;
            set(property:"resizeEnabled", value: boolean): void;
            get(property:"resizeEnabled"): boolean;
            watch(property:"resizeEnabled", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "roundToDay": boolean;
            set(property:"roundToDay", value: boolean): void;
            get(property:"roundToDay"): boolean;
            watch(property:"roundToDay", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Indicates whether the view can be scrolled or not.
             * 
             */
            "scrollable": boolean;
            set(property:"scrollable", value: boolean): void;
            get(property:"scrollable"): boolean;
            watch(property:"scrollable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Position of the scroll bar in right-to-left display.
             * Valid values are "left" and "right", default value is "left".
             * 
             */
            "scrollBarRTLPosition": string;
            set(property:"scrollBarRTLPosition", value: string): void;
            get(property:"scrollBarRTLPosition"): string;
            watch(property:"scrollBarRTLPosition", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Method used to scroll the view, for example the scroll of column view.
             * Valid value are:
             * 
             * "auto": let the view decide (default),
             * "css": use css 3d transform,
             * "dom": use the scrollTop property.
             * 
             */
            "scrollMethod": string;
            set(property:"scrollMethod", value: string): void;
            get(property:"scrollMethod"): string;
            watch(property:"scrollMethod", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The scroll position of the view. 
             * 
             */
            "scrollPosition": number;
            set(property:"scrollPosition", value: number): void;
            get(property:"scrollPosition"): number;
            watch(property:"scrollPosition", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * In single selection mode, the selected item or in multiple selection mode the last selected item.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItem": Object;
            set(property:"selectedItem", value: Object): void;
            get(property:"selectedItem"): Object;
            watch(property:"selectedItem", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * The list of selected items.
             * Warning: Do not use this property directly, make sure to call set() or get() methods.
             * 
             */
            "selectedItems": Object;
            set(property:"selectedItems", value: Object): void;
            get(property:"selectedItems"): Object;
            watch(property:"selectedItems", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Valid values are:
             * 
             * "none": No selection can be done.
             * "single": Only one item can be selected at a time.
             * "multiple": Several item can be selected using the control key modifier.
             * Default value is "single".
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether display or not the grid cells label (usually the day of month).
             * 
             */
            "showCellLabel": boolean;
            set(property:"showCellLabel", value: boolean): void;
            get(property:"showCellLabel"): boolean;
            watch(property:"showCellLabel", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Whether show or not the hidden items.
             * By default the events that are shorter than a day are not displayed using vertical renderers by this widget.
             * But the grid cells that contains one or several hidden items display a decoration.
             * 
             */
            "showHiddenItems": boolean;
            set(property:"showHiddenItems", value: boolean): void;
            get(property:"showHiddenItems"): boolean;
            watch(property:"showHiddenItems", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "snapSteps": number;
            set(property:"snapSteps", value: number): void;
            get(property:"snapSteps"): number;
            watch(property:"snapSteps", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "snapUnit": string;
            set(property:"snapUnit", value: string): void;
            get(property:"snapUnit"): string;
            watch(property:"snapUnit", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * The start date of the time interval displayed.
             * If not set at initialization time, will be set to current day.
             * 
             */
            "startDate": Date;
            set(property:"startDate", value: Date): void;
            get(property:"startDate"): Date;
            watch(property:"startDate", callback:{(property?:string, oldValue?:Date, newValue?: Date):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the start time of 
             * the events represented by this item.    Default is "startTime". 
             * 
             */
            "startTimeAttr": string;
            set(property:"startTimeAttr", value: string): void;
            get(property:"startTimeAttr"): string;
            watch(property:"startTimeAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "stayInView": boolean;
            set(property:"stayInView", value: boolean): void;
            get(property:"stayInView"): boolean;
            watch(property:"stayInView", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * The store that contains the events to display.
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Custom function to customize the appearance of a grid cell by installing custom CSS class on the node.
             * The signature of the function must be the same then the styleGridCell one.
             * By default the defaultStyleGridCell function is used.
             * 
             */
            "styleGridCellFunc": Function;
            set(property:"styleGridCellFunc", value: Function): void;
            get(property:"styleGridCellFunc"): Function;
            watch(property:"styleGridCellFunc", callback:{(property?:string, oldValue?:Function, newValue?: Function):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the sub column name of 
             * the events represented by this item.    Default is "calendar".
             * 
             */
            "subColumnAttr": string;
            set(property:"subColumnAttr", value: string): void;
            get(property:"subColumnAttr"): string;
            watch(property:"subColumnAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The attribute of the store item that contains the summary of 
             * the events represented by this item.    Default is "summary".
             * 
             */
            "summaryAttr": string;
            set(property:"summaryAttr", value: string): void;
            get(property:"summaryAttr"): string;
            watch(property:"summaryAttr", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The class use to create vertical renderers.
             * 
             */
            "verticalRenderer": Object;
            set(property:"verticalRenderer", value: Object): void;
            get(property:"verticalRenderer"): Object;
            watch(property:"verticalRenderer", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Type of the view. Used by the calendar widget to determine how to configure the view.
             * This view kind is "columns".
             * 
             */
            "viewKind": string;
            set(property:"viewKind", value: string): void;
            get(property:"viewKind"): string;
            watch(property:"viewKind", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Add properties to the watched properties to trigger invalidation. This method must be called in
             * the constructor. It is typically used by subclasses of a _Invalidating class to add more properties
             * to watch for.
             * 
             * @param properties The list of properties to watch for.             
             */
            addInvalidatingProperties(properties: String[]): void;
            /**
             * Function invoked just after the view is displayed by the calendar.
             * 
             */
            afterActivate(): void;
            /**
             * Function invoked just after the view is the view is hidden or removed by the calendar.
             * 
             */
            afterDeactivate(): void;
            /**
             * Applies the z-index to the renderer based on the state of the item.
             * This methods is setting a z-index of 20 is the item is selected or edited 
             * and the current lane value computed by the overlap layout (i.e. the renderers 
             * are stacked according to their lane).
             * 
             * @param item The render item.             
             * @param renderer A renderer associated with the render item.             
             * @param hovered Whether the item is hovered or not.             
             * @param selected Whether the item is selected or not.             
             * @param edited Whether the item is being edited not not.             
             * @param focused Whether the item is focused not not.             
             */
            applyRendererZIndex(item: Object, renderer: Object, hovered: boolean, selected: boolean, edited: boolean, focused: boolean): void;
            /**
             * Function invoked just before the view is displayed by the calendar.
             * 
             */
            beforeActivate(): void;
            /**
             * Function invoked just before the view is hidden or removed by the calendar.
             * 
             */
            beforeDeactivate(): void;
            /**
             * Computes the overlap layout of a list of items. A lane and extent properties are added to each layout item.
             * 
             * @param layoutItems List of layout items, each item must have a start and end properties.             
             * @param func             
             */
            computeOverlapping(layoutItems: Object[], func: any): any;
            /**
             * Computes the time to pixel projection in a day.
             * 
             * @param renderData The render data.             
             * @param refDate The reference date that defines the destination date.             
             * @param date The reference dates (at least one).              
             * @param max The size in pixels of the representation of a day.             
             */
            computeProjectionOnDate(renderData: Object, refDate: Date, date: Date[], max: number): any;
            /**
             * Computes the overlap time range of the time ranges.
             * Returns a vector of Date with at index 0 the start time and at index 1 the end time.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            computeRangeOverlap(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * A user supplied function that creates a new event.
             * 
             * @param view the current view,             
             * @param d the date at the clicked location.             
             * @param e the mouse event (can be used to return null for example)             
             */
            createItemFunc(view: dojox.calendar.ViewBase, d: Date, e: MouseEvent): void;
            /**
             * Styles the CSS classes to the node that displays a column.
             * By default this method is setting the following CSS classes:
             * - "dojoxCalendarToday" class name if the date displayed is the current date,
             * - "dojoxCalendarWeekend" if the date represents a weekend,
             * - the CSS class corresponding of the displayed day of week ("Sun", "Mon" and so on),
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param col The column index of this cell.             
             * @param row The row index of this cell.             
             * @param renderData The render data.             
             */
            defaultStyleGridCell(node: HTMLElement, date: Date, col: number, row: number, renderData: Object): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             * @param preserveDom             
             */
            destroy(preserveDom?: any): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * Dispatch a selection change event.
             * 
             * @param oldSelectedItem The previously selectedItem.             
             * @param newSelectedItem The new selectedItem.             
             * @param renderer The visual renderer of the selected/deselected item.             
             * @param triggerEvent The event that lead to the selection of the item.                        
             */
            dispatchChange(oldSelectedItem: Object, newSelectedItem: Object, renderer: Object, triggerEvent: Event): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * During the resize editing gesture, ensures that the item has the specified minimal duration.
             * 
             * @param renderData The render data.             
             * @param item The edited item.             
             * @param unit The unit used to define the minimal duration.             
             * @param steps The number of time units.             
             * @param editKind The edit kind: "resizeStart" or "resizeEnd".             
             */
            ensureMinimalDuration(renderData: Object, item: Object, unit: String, steps: number, editKind: String): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param margin Margin in minutes around the time range.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, margin: number, visibilityTarget: String, duration: number): void;
            /**
             * Scrolls the view if the [start, end] time range is not visible or only partially visible.
             * 
             * @param start Start time of the range of interest.             
             * @param end End time of the range of interest.             
             * @param visibilityTarget The end(s) of the time range to make visible.Valid values are: "start", "end", "both".                
             * @param margin Margin in minutes around the time range.             
             * @param duration Optional, the maximum duration of the scroll animation.             
             */
            ensureVisibility(start: Date, end: Date, visibilityTarget: String, margin: number, duration: number): void;
            /**
             * floors the date to the unit.
             * 
             * @param date The date/time to floor.             
             * @param unit The unit. Valid values are "minute", "hour", "day".             
             * @param steps For "day" only 1 is valid.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.                        
             */
            floorDate(date: Date, unit: String, steps: number, reuse: boolean): any;
            /**
             * Floors the specified date to the start of day.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToDay(date: Date, reuse: boolean): any;
            /**
             * Floors the specified date to the start of the date's month.
             * 
             * @param date The date to floor.             
             * @param reuse Whether use the specified instance or create a new one. Default is false.             
             */
            floorToMonth(date: Date, reuse: boolean): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * Utility method that return the specific CSS prefix
             * for non standard CSS properties. Ex: -moz-border-radius.
             * 
             */
            getCSSPrefix(): String;
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * Returns the creation state of an item. 
             * This state is changing during the interactive creation of an item.
             * Valid values are:
             * - "unstored": The event is being interactively created. It is not in the store yet.
             * - "storing": The creation gesture has ended, the event is being added to the store.
             * - "stored": The event is not in the two previous states, and is assumed to be in the store 
             * (not checking because of performance reasons, use store API for testing existence in store).
             * item: Object
             * The item.
             * returns: String
             * 
             * @param item             
             */
            getItemStoreState(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * Returns the renderers that are currently used to displayed the speficied item.
             * Returns an array of objects that contains two properties:
             * - container: The DOM node that contains the renderer.
             * - renderer: The dojox.calendar._RendererMixin instance.
             * Do not keep references on the renderers are they are recycled and reused for other items.
             * 
             * @param item The data or render item.             
             */
            getRenderers(item: Object): any;
            /**
             * Returns the sub column at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getSubColumn(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the sub column index that has the specified value, if any. -1 otherwise. 
             * 
             * @param value The sub column index.             
             */
            getSubColumnIndex(value: String): number;
            /**
             * Returns the time displayed at the specified point by this component.
             * 
             * @param e Optional mouse event.             
             * @param x Position along the x-axis with respect to the sheet container used if event is not defined.             
             * @param y Position along the y-axis with respect to the sheet container (scroll included) used if event is not defined.             
             * @param touchIndex If parameter 'e' is not null and a touch event, the index of the touch to use.             
             */
            getTime(e: Event, x: number, y: number, touchIndex: number): any;
            /**
             * Returns the week number string from dojo.date.locale.format() method as
             * dojox.date.XXXX calendar are not supporting the "w" pattern.
             * 
             * @param date The date to format.             
             */
            getWeekNumberLabel(date: Date): any;
            /**
             * 
             */
            invalidateLayout(): void;
            /**
             * Invalidating the rendering for the next executation frame.
             * 
             */
            invalidateRendering(): void;
            /**
             * Determines if a node has an ascendant node that has the css class specified.
             * 
             * @param node The DOM node.             
             * @param ancestor The ancestor node used to limit the search in hierarchy.             
             * @param className The css class name.             
             */
            isAscendantHasClass(node: HTMLElement, ancestor: HTMLElement, className: String): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Returns whether an item is being edited or not.
             * 
             * @param item The item to test.             
             */
            isItemBeingEdited(item: Object): any;
            /**
             * Computes whether particular item renderer can be edited or not.
             * By default it is using the editable property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemEditable(item: Object, rendererKind: String): any;
            /**
             * Returns whether the specified item is focused or not.
             * 
             * @param item The item.             
             */
            isItemFocused(item: Object): any;
            /**
             * Returns whether the specified item is hovered or not.
             * 
             * @param item The item.             
             */
            isItemHovered(item: Object): any;
            /**
             * Computes whether particular item renderer can be moved.
             * By default it is using the moveEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemMoveEnabled(item: Object, rendererKind: String): any;
            /**
             * Computes whether particular item renderer can be resized.
             * By default it is using the resizedEnabled property value.
             * 
             * @param item The item represented by the renderer.             
             * @param rendererKind The kind of renderer.             
             */
            isItemResizeEnabled(item: Object, rendererKind: String): any;
            /**
             * 
             * @param item             
             */
            isItemSelected(item: any): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * Computes if the first time range defined by the start1 and end1 parameters 
             * is overlapping the second time range defined by the start2 and end2 parameters.
             * 
             * @param renderData The render data.             
             * @param start1 The start time of the first time range.             
             * @param end1 The end time of the first time range.             
             * @param start2 The start time of the second time range.             
             * @param end2 The end time of the second time range.             
             * @param includeLimits Whether include the end time or not.             
             */
            isOverlapping(renderData: Object, start1: Date, end1: Date, start2: Date, end2: Date, includeLimits: boolean): any;
            /**
             * Tests if the specified dates are in the same day.
             * 
             * @param date1 The first date.             
             * @param date2 The second date.             
             */
            isSameDay(date1: Date, date2: Date): any;
            /**
             * Tests if the specified date represents the starts of day. 
             * 
             * @param d The date to test.             
             */
            isStartOfDay(d: Date): any;
            /**
             * Returns whether the specified date is in the current day.
             * 
             * @param date The date to test.             
             */
            isToday(date: Date): any;
            /**
             * Determines whether the specified date is a week-end.
             * This method is using dojo.date.locale.isWeekend() method as
             * dojox.date.XXXX calendars are not supporting this method.
             * 
             * @param date The date to test.               
             */
            isWeekEnd(date: Date): any;
            /**
             * Creates the render item based on the dojo.store item. It must be of the form:
             * 
             * {
             *     id: Object,
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the store id, the summaryAttr, 
             * 
             * startTimeAttr and endTimeAttr properties as well as decodeDate property if not null. 
             * Other fields or way to query fields can be used if needed.
             * 
             * @param item The store item.              
             * @param store The store.             
             */
            itemToRenderItem(item: Object, store: dojo.store.api.Store): any;
            /**
             * Creates a new Date object.
             * 
             * @param obj This object can have several values:the time in milliseconds since gregorian epoch.a Date instance             
             */
            newDate(obj: Object): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * Call specified function when event occurs, ex: myWidget.on("click", function(){ ... }).
             * Call specified function when event type occurs, ex: myWidget.on("click", function(){ ... }).
             * Note that the function is not run in any particular scope, so if (for example) you want it to run in the
             * widget's scope you must do myWidget.on("click", lang.hitch(myWidget, func)).
             * 
             * @param type Name of event (ex: "click") or extension event like touch.press.             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * Called after the parameters to the widget have been read-in,
             * but before the widget template is instantiated. Especially
             * useful to set properties that are referenced in the widget
             * template.
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postscript(): void;
            /**
             * 
             */
            refreshRendering(): void;
            /**
             * Create a store item based on the render item. It must be of the form:
             * 
             * {
             *     id: Object
             *     startTime: Date,
             *     endTime: Date,
             *     summary: String
             * }
             * By default it is building an object using the summaryAttr, startTimeAttr and endTimeAttr properties
             * 
             * and encodeDate property if not null. If the encodeDate property is null a Date object will be set in the start and end time.
             * When using a JsonRest store, for example, it is recommended to transfer dates using the ISO format (see dojo.date.stamp).
             * In that case, provide a custom function to the encodeDate property that is using the date ISO encoding provided by Dojo. 
             * 
             * @param renderItem The render item.              
             * @param store The store.             
             */
            renderItemToItem(renderItem: Object, store: dojo.store.api.Store): any;
            /**
             * 
             */
            resize(): void;
            /**
             * Scrolls the view to the specified direction of one time slot duration.
             * 
             * @param dir Direction of the scroll. Valid values are -1 and 1.             
             */
            scrollView(dir: number): void;
            /**
             * 
             * @param e             
             * @param item             
             * @param renderer             
             * @param dispatch             
             */
            selectFromEvent(e: any, item: any, renderer: any, dispatch: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * 
             * @param item             
             * @param value             
             */
            setItemSelected(item: any, value: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * Styles the CSS classes to the node that displays a column header cell.
             * By default this method is does nothing and is designed to be overridden.
             * 
             * @param node The DOM node that displays the column in the grid.             
             * @param date The date displayed by this column             
             * @param renderData The render data.                         
             */
            styleColumnHeaderCell(node: HTMLElement, date: Date, renderData: Object): void;
            /**
             * Styles the CSS classes to the node that displays a column.
             * Delegates to styleGridCellFunc if defined or defaultStyleGridCell otherwise.
             * 
             * @param node The DOM node that displays the cell in the grid.             
             * @param date The date displayed by this cell.             
             * @param col The column index of this cell.             
             * @param row The row index of this cell.             
             * @param renderData The render data.             
             */
            styleGridCell(node: HTMLElement, date: Date, col: number, row: number, renderData: Object): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Updates all the renderers that represents the specified item(s).
             * 
             * @param obj A render item or an array of render items.             
             * @param stateOnly Whether only the state of the item has changed (selected, edited, edited, focused) or a more global change has occured.             
             */
            updateRenderers(obj: Object, stateOnly: boolean): void;
            /**
             * Immediately validate the rendering if it has been invalidated. You generally do not call that method yourself.
             * 
             */
            validateRendering(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond ar