﻿// Type definitions for Dojo v1.9
// Project: http://dojotoolkit.org
// Definitions by: Michael Van Sickle <https://github.com/vansimke>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

/// <reference path="dijit.d.ts" />
declare module dojox {
    
    module grid {
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_EditManager.html
         *
         * Controls grid cell editing process. Owned by grid and used internally for editing.
         * 
         * @param inGrid The dojox.Grid this editor should be attached to     
         */
        class _EditManager {
            constructor(inGrid: dojox.grid._Grid);
            /**
             * 
             */
            "info": Object;
            /**
             * Apply a grid edit
             * 
             */
            apply(): void;
            /**
             * 
             * @param inValue             
             * @param inCell             
             * @param inRowIndex             
             */
            applyCellEdit(inValue: any, inCell: any, inRowIndex: any): void;
            /**
             * 
             */
            applyRowEdit(): void;
            /**
             * Cancel a grid edit
             * 
             */
            cancel(): void;
            /**
             * Invoke editing when cell is focused
             * 
             * @param inCell Grid cell object             
             * @param inRowIndex Grid row index             
             */
            cellFocus(inCell: any, inRowIndex: number): void;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             * @param e             
             */
            dispatchEvent(e: any): number;
            /**
             * 
             */
            editorApply(): void;
            /**
             * 
             */
            editorCancel(): void;
            /**
             * 
             */
            focusEditor(): void;
            /**
             * Indicates if the given cell is being edited.
             * 
             * @param inRowIndex Grid row index             
             * @param inCellIndex Grid cell index             
             */
            isEditCell(inRowIndex: number, inCellIndex: number): any;
            /**
             * Indicates editing state of the grid.
             * 
             */
            isEditing(): any;
            /**
             * Indicates if the given row is being edited.
             * 
             * @param inRowIndex Grid row index             
             */
            isEditRow(inRowIndex: number): any;
            /**
             * Restores the grid editing state
             * 
             * @param inView Grid view             
             * @param inRowIndex Grid row index             
             */
            restore(inView: Object, inRowIndex: number): void;
            /**
             * 
             * @param e             
             */
            rowClick(e: any): void;
            /**
             * Save the grid editing state
             * 
             * @param inRowIndex Grid row index             
             * @param inView Grid view             
             */
            save(inRowIndex: number, inView: Object): void;
            /**
             * Set the given cell to be edited
             * 
             * @param inCell Grid cell object             
             * @param inRowIndex Grid row index             
             */
            setEditCell(inCell: Object, inRowIndex: number): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             * @param inEditing             
             */
            start(inCell: any, inRowIndex: any, inEditing: any): void;
            /**
             * 
             * @param inRow             
             */
            styleRow(inRow: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_Layout.html
         *
         * Controls grid cell layout. Owned by grid and used internally.
         * 
         * @param inGrid     
         */
        class _Layout {
            constructor(inGrid: any);
            /**
             * 
             */
            "cells": any[];
            /**
             * 
             */
            "defaultWidth": string;
            /**
             * 
             */
            "structure": Object;
            /**
             * 
             * @param inRowIndex             
             * @param inCellIndex             
             * @param inDef             
             */
            addCellDef(inRowIndex: any, inCellIndex: any, inDef: any): any;
            /**
             * 
             * @param inRowIndex             
             * @param inDef             
             */
            addRowDef(inRowIndex: any, inDef: any): any[];
            /**
             * 
             * @param inDef             
             */
            addRowsDef(inDef: any): any[];
            /**
             * 
             * @param inDef             
             */
            addViewDef(inDef: any): Object;
            /**
             * 
             * @param sourceViewIndex             
             * @param destViewIndex             
             * @param cellIndex             
             * @param targetIndex             
             * @param before             
             */
            moveColumn(sourceViewIndex: any, destViewIndex: any, cellIndex: any, targetIndex: any, before: any): void;
            /**
             * 
             * @param columnIndex             
             * @param visible             
             */
            setColumnVisibility(columnIndex: any, visible: any): boolean;
            /**
             * 
             * @param inStructure             
             */
            setStructure(inStructure: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_FocusManager.html
         *
         * Controls grid cell focus. Owned by grid and used internally for focusing.
         * Note: grid cell actually receives keyboard input only when cell is being edited.
         * 
         * @param inGrid     
         */
        class _FocusManager {
            constructor(inGrid: any);
            /**
             * 
             */
            "focusClass": string;
            /**
             * 
             */
            "focusView": Object;
            /**
             * 
             */
            "tabbingOut": boolean;
            /**
             * 
             */
            blurHeader(): void;
            /**
             * 
             * @param e             
             * @param colIdx             
             * @param delta             
             */
            colSizeAdjust(e: any, colIdx: any, delta: any): void;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             * @param e             
             */
            doBlur(e: any): void;
            /**
             * 
             * @param e             
             */
            doColHeaderBlur(e: any): void;
            /**
             * 
             * @param e             
             */
            doColHeaderFocus(e: any): void;
            /**
             * 
             * @param e             
             */
            doContextMenu(e: any): void;
            /**
             * 
             * @param e             
             */
            doFocus(e: any): void;
            /**
             * 
             * @param e             
             */
            doLastNodeBlur(e: any): void;
            /**
             * 
             * @param e             
             */
            doLastNodeFocus(e: any): void;
            /**
             * find the first focusable grid cell
             * 
             */
            findAndFocusGridCell(): any;
            /**
             * 
             * @param inSkipFocusCell             
             */
            focusGrid(inSkipFocusCell: any): void;
            /**
             * 
             */
            focusGridView(): void;
            /**
             * 
             */
            focusHeader(): void;
            /**
             * if one of the column headers currently has focus, return its index.
             * 
             */
            getHeaderIndex(): any;
            /**
             * 
             */
            initFocusView(): void;
            /**
             * 
             */
            isFirstFocusCell(): boolean;
            /**
             * states if the given cell is focused
             * 
             * @param inCell grid cell object             
             * @param inRowIndex grid row index             
             */
            isFocusCell(inCell: Object, inRowIndex: number): any;
            /**
             * 
             */
            isLastFocusCell(): boolean;
            /**
             * states whether currently navigating among column headers.
             * 
             */
            isNavHeader(): any;
            /**
             * 
             */
            isNoFocusCell(): boolean;
            /**
             * focus grid cell or  simulate focus to column header based on position relative to current focus
             * 
             * @param inRowDelta vertical distance from current focus             
             * @param inColDelta horizontal distance from current focus             
             */
            move(inRowDelta: number, inColDelta: number): void;
            /**
             * focus next grid cell
             * 
             */
            next(): void;
            /**
             * 
             * @param e             
             */
            nextKey(e: any): void;
            /**
             * focus previous grid cell
             * 
             */
            previous(): void;
            /**
             * 
             * @param e             
             */
            previousKey(e: any): void;
            /**
             * 
             */
            scrollIntoView(): any;
            /**
             * focuses the given grid cell
             * 
             * @param inCell grid cell object             
             * @param inRowIndex grid row index             
             */
            setFocusCell(inCell: Object, inRowIndex: number): void;
            /**
             * focuses the given grid cell
             * 
             * @param inRowIndex grid row index             
             * @param inCellIndex grid cell index             
             */
            setFocusIndex(inRowIndex: number, inCellIndex: number): void;
            /**
             * 
             * @param inRow             
             */
            styleRow(inRow: any): void;
            /**
             * 
             * @param inFocusNode             
             */
            tabOut(inFocusNode: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_Events.html
         *
         * _Grid mixin that provides default implementations for grid events.
         * Default synthetic events dispatched for _Grid. dojo.connect to events to
         * retain default implementation or override them for custom handling.
         * 
         */
        class _Events {
            constructor();
            /**
             * css class to apply to grid cells over which the cursor is placed.
             * 
             */
            "cellOverClass": string;
            /**
             * Event fired when editing is applied for a given grid cell
             * 
             * @param inValue Value from cell editor             
             * @param inRowIndex Index of the grid row             
             * @param inFieldIndex Index in the grid's data store             
             */
            onApplyCellEdit(inValue: String, inRowIndex: number, inFieldIndex: number): void;
            /**
             * Event fired when editing is applied for a given grid row
             * 
             * @param inRowIndex Index of the grid row             
             */
            onApplyEdit(inRowIndex: number): void;
            /**
             * Event fired when editing is cancelled for a given grid cell
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCancelEdit(inRowIndex: number): void;
            /**
             * Event to determine if a grid row may be deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanDeselect(inRowIndex: number): any;
            /**
             * Event to determine if a grid row may be selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanSelect(inRowIndex: number): any;
            /**
             * Event fired when a cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellClick(e: Event): void;
            /**
             * Event fired when a cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellContextMenu(e: Event): void;
            /**
             * Event fired when a cell is double-clicked.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellDblClick(e: Event): void;
            /**
             * Event fired when a cell receives focus.
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onCellFocus(inCell: Object, inRowIndex: number): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse is over a cell.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOver(e: Event): void;
            /**
             * Top level handler for Content events
             * 
             * @param e             
             */
            onContentEvent(e: any): void;
            /**
             * Event fired when a grid row is deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onDeselected(inRowIndex: number): void;
            /**
             * Event fired when a header cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellClick(e: Event): void;
            /**
             * Event fired when a header cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellContextMenu(e: Event): void;
            /**
             * Event fired when a header cell is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOver(e: Event): void;
            /**
             * Event fired when the grid header is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderClick(e: Event): void;
            /**
             * Event fired when the grid header context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderContextMenu(e: Event): void;
            /**
             * Event fired when the grid header is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderDblClick(e: Event): void;
            /**
             * Top level handler for header events
             * 
             * @param e             
             */
            onHeaderEvent(e: any): void;
            /**
             * Event fired when mouse moves out of the grid header.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over the grid header.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOver(e: Event): void;
            /**
             * Grid key event handler. By default enter begins editing and applies edits, escape cancels an edit,
             * tab, shift-tab, and arrow keys move grid cell focus.
             * 
             * @param e             
             */
            onKeyDown(e: any): void;
            /**
             * top level handler for Key Events
             * 
             * @param e             
             */
            onKeyEvent(e: any): void;
            /**
             * Event fired when mouse is down inside grid.
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDown(e: Event): void;
            /**
             * Event fired when mouse is down inside grid row
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDownRow(e: Event): void;
            /**
             * Event fired when mouse moves out of the grid.
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves out of any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOutRow(e: Event): void;
            /**
             * Event fired when mouse is over the grid.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOver(e: Event): void;
            /**
             * Event fired when mouse is over any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOverRow(e: Event): void;
            /**
             * Event fired when a row is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowClick(e: Event): void;
            /**
             * Event fired when a row context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowContextMenu(e: Event): void;
            /**
             * Event fired when a row is double clicked.
             * 
             * @param e decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a data row.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a data row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOver(e: Event): void;
            /**
             * Event fired when a grid row is selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onSelected(inRowIndex: number): void;
            /**
             * 
             */
            onSelectionChanged(): void;
            /**
             * Event fired when editing is started for a given grid cell
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onStartEdit(inCell: Object, inRowIndex: number): void;
            /**
             * Perform row styling on a given row. Called whenever row styling is updated.
             * 
             * @param inRow Object containing row state information: selected, true if the row is selcted; over:true of the mouse is over the row; odd: true if the row is odd. Use customClasses andcustomStyles to control row css classes and styles; both properties are strings.             
             */
            onStyleRow(inRow: Object): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_RowManager.html
         *
         * 
         * @param inGrid     
         */
        class _RowManager {
            constructor(inGrid: any);
            /**
             * 
             */
            "linesToEms": number;
            /**
             * 
             */
            "overRow": number;
            /**
             * 
             * @param inRow             
             */
            applyStyles(inRow: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            isOver(inRowIndex: any): boolean;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            prepareStylingRow(inRowIndex: any, inRowNode: any): Object;
            /**
             * 
             * @param inRowIndex             
             */
            setOverRow(inRowIndex: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            updateStyles(inRowIndex: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_SelectionPreserver.html
         *
         * Preserve selections across various user actions.
         * When this feature is turned on, Grid will try to preserve selections across actions, e.g. sorting, filtering etc.
         * 
         * Precondition - Identifier(id) is required for store since id is the only way for differentiating row items.
         * Known issue - The preserved selections might be inaccurate if some unloaded rows are previously selected by range(e.g.SHIFT + click)
         * 
         * @param selection     
         */
        class _SelectionPreserver {
            constructor(selection: any);
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             */
            reset(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_Scroller.html
         *
         * 
         * @param inContentNodes     
         */
        class _Scroller {
            constructor(inContentNodes: any);
            /**
             * 
             */
            "averageRowHeight": number;
            /**
             * 
             */
            "contentNode": Object;
            /**
             * 
             */
            "defaultPageHeight": number;
            /**
             * 
             */
            "defaultRowHeight": number;
            /**
             * 
             */
            "dummy": number;
            /**
             * 
             */
            "firstVisibleRow": number;
            /**
             * 
             */
            "keepPages": number;
            /**
             * 
             */
            "keepRows": number;
            /**
             * 
             */
            "lastVisibleRow": number;
            /**
             * 
             */
            "pacifying": boolean;
            /**
             * 
             */
            "pacifyTicks": number;
            /**
             * 
             */
            "page": number;
            /**
             * 
             */
            "pageCount": number;
            /**
             * 
             */
            "pageTop": number;
            /**
             * 
             */
            "rowCount": number;
            /**
             * 
             */
            "scrollboxNode": Object;
            /**
             * 
             */
            "windowHeight": number;
            /**
             * 
             * @param inPageIndex             
             * @param inReuseNode             
             * @param inPos             
             */
            buildPage(inPageIndex: any, inReuseNode: any, inPos: any): void;
            /**
             * 
             */
            calcLastPageHeight(): number;
            /**
             * 
             */
            createPageNode(): any;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             * @param inPageIndex             
             */
            destroyPage(inPageIndex: any): void;
            /**
             * 
             */
            doPacify(): boolean;
            /**
             * 
             */
            endPacify(): void;
            /**
             * 
             * @param inTop             
             */
            findPage(inTop: any): void;
            /**
             * 
             * @param inRow             
             */
            findScrollTop(inRow: any): number;
            /**
             * 
             * @param inScrollTop             
             */
            findTopRow(inScrollTop: any): number;
            /**
             * 
             */
            getDefaultNodes(): Object;
            /**
             * 
             * @param inPageIndex             
             */
            getDefaultPageNode(inPageIndex: any): any;
            /**
             * 
             * @param inPage             
             * @param inPageTop             
             * @param inScrollTop             
             */
            getFirstVisibleRow(inPage: any, inPageTop: number, inScrollTop: any): any;
            /**
             * 
             * @param inPage             
             */
            getLastPageRow(inPage: any): number;
            /**
             * 
             * @param inPage             
             * @param inBottom             
             * @param inScrollBottom             
             */
            getLastVisibleRow(inPage: any, inBottom: number, inScrollBottom: any): number;
            /**
             * 
             * @param inPageIndex             
             */
            getPageHeight(inPageIndex: any): any;
            /**
             * 
             * @param inNode             
             */
            getPageNodePosition(inNode: any): any;
            /**
             * 
             * @param inPage             
             */
            getPageRow(inPage: any): number;
            /**
             * 
             * @param inTop             
             */
            getScrollBottom(inTop: any): number;
            /**
             * 
             * @param inRowCount             
             * @param inKeepRows             
             * @param inRowsPerPage             
             */
            init(inRowCount: any, inKeepRows: any, inRowsPerPage: any): void;
            /**
             * 
             * @param inPageIndex             
             */
            installPage(inPageIndex: any): void;
            /**
             * 
             */
            invalidate(): void;
            /**
             * 
             */
            invalidateNodes(): void;
            /**
             * 
             * @param inPageIndex             
             * @param inNodes             
             */
            invalidatePageNode(inPageIndex: any, inNodes: any): any;
            /**
             * 
             * @param inPageIndex             
             */
            measurePage(inPageIndex: any): any;
            /**
             * 
             * @param inPageIndex             
             * @param inPos             
             */
            needPage(inPageIndex: any, inPos: any): any;
            /**
             * 
             */
            onscroll(): void;
            /**
             * 
             * @param inShouldPacify             
             */
            pacify(inShouldPacify: any): void;
            /**
             * 
             * @param inPageIndex             
             */
            pageExists(inPageIndex: any): any;
            /**
             * 
             */
            popPage(): any;
            /**
             * 
             * @param inPageIndex             
             * @param inPos             
             */
            positionPage(inPageIndex: any, inPos: any): void;
            /**
             * 
             * @param inNode             
             * @param inPos             
             */
            positionPageNode(inNode: any, inPos: any): void;
            /**
             * 
             * @param inPageIndex             
             * @param inReuseNode             
             */
            preparePage(inPageIndex: any, inReuseNode: any): void;
            /**
             * 
             * @param e             
             */
            processEvent(e: any): any;
            /**
             * 
             * @param e             
             * @param inNode             
             */
            processNodeEvent(e: any, inNode: any): boolean;
            /**
             * 
             * @param inPageIndex             
             */
            pushPage(inPageIndex: any): any;
            /**
             * 
             * @param inPageIndex             
             */
            removePage(inPageIndex: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            removeRow(inRowIndex: any): void;
            /**
             * 
             * @param inPageIndex             
             */
            renderPage(inPageIndex: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inPageNode             
             */
            renderRow(inRowIndex: any, inPageNode: any): void;
            /**
             * 
             * @param inPageIndex             
             */
            repositionPages(inPageIndex: any): void;
            /**
             * 
             */
            resize(): void;
            /**
             * 
             * @param inRowIndex             
             * @param fromAsynRendering             
             */
            rowHeightChanged(inRowIndex: any, fromAsynRendering: any): void;
            /**
             * 
             * @param inTop             
             */
            scroll(inTop: any): void;
            /**
             * 
             * @param inNodes             
             */
            setContentNodes(inNodes: any): void;
            /**
             * 
             * @param inKeepRows             
             */
            setKeepInfo(inKeepRows: any): void;
            /**
             * 
             * @param inPacifying             
             */
            setPacifying(inPacifying: any): void;
            /**
             * 
             */
            startPacify(): void;
            /**
             * 
             * @param inDh             
             */
            updateContentHeight(inDh: any): void;
            /**
             * 
             * @param inPageIndex             
             * @param fromBuild             
             * @param fromAsynRendering             
             */
            updatePageHeight(inPageIndex: any, fromBuild: any, fromAsynRendering: any): any;
            /**
             * 
             * @param inRowCount             
             */
            updateRowCount(inRowCount: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_Grid.html
         *
         * A grid widget with virtual scrolling, cell editing, complex rows,
         * sorting, fixed columns, sizeable columns, etc.
         * _Grid provides the full set of grid features without any
         * direct connection to a data store.
         * 
         * The grid exposes a get function for the grid, or optionally
         * individual columns, to populate cell contents.
         * 
         * The grid is rendered based on its structure, an object describing
         * column and cell layout.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _Grid extends dijit._Widget implements dijit._TemplatedMixin, dojox.grid._Events {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If autoHeight is true, grid height is automatically set to fit the data.
             * If it is an integer, the height will be automatically set to fit the data
             * if there are fewer than that many rows - and the height will be set to show
             * that many rows if there are more
             * 
             */
            "autoHeight": boolean;
            set(property:"autoHeight", value: boolean): void;
            get(property:"autoHeight"): boolean;
            watch(property:"autoHeight", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoRender is true, grid will render itself after initialization.
             * 
             */
            "autoRender": boolean;
            set(property:"autoRender", value: boolean): void;
            get(property:"autoRender"): boolean;
            watch(property:"autoRender", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoWidth is true, grid width is automatically set to fit the data.
             * 
             */
            "autoWidth": boolean;
            set(property:"autoWidth", value: boolean): void;
            get(property:"autoWidth"): boolean;
            watch(property:"autoWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * css class to apply to grid cells over which the cursor is placed.
             * 
             */
            "cellOverClass": string;
            set(property:"cellOverClass", value: string): void;
            get(property:"cellOverClass"): string;
            watch(property:"cellOverClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * CSS class applied to the grid's domNode
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * If set to true, will add drag and drop reordering to views with one row of columns.
             * 
             */
            "columnReordering": boolean;
            set(property:"columnReordering", value: boolean): void;
            get(property:"columnReordering"): boolean;
            watch(property:"columnReordering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * default height of the grid, measured in any valid css unit.
             * 
             */
            "defaultHeight": string;
            set(property:"defaultHeight", value: string): void;
            get(property:"defaultHeight"): string;
            watch(property:"defaultHeight", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "delayScroll": boolean;
            set(property:"delayScroll", value: boolean): void;
            get(property:"delayScroll"): boolean;
            watch(property:"delayScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * indicates if the grid contains editable cells, default is false
             * set to true if editable cell encountered during rendering
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Override defaults and make the indexed grid view elastic, thus filling available horizontal space.
             * 
             */
            "elasticView": number;
            set(property:"elasticView", value: number): void;
            get(property:"elasticView"): number;
            watch(property:"elasticView", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Message that shows when the grid encounters an error loading
             * 
             */
            "errorMessage": string;
            set(property:"errorMessage", value: string): void;
            get(property:"errorMessage"): string;
            watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This will escape HTML brackets from the data to prevent HTML from
             * user-inputted data being rendered with may contain JavaScript and result in
             * XSS attacks. This is true by default, and it is recommended that it remain
             * true. Setting this to false will allow data to be displayed in the grid without
             * filtering, and should be only used if it is known that the data won't contain
             * malicious scripts. If HTML is needed in grid cells, it is recommended that
             * you use the formatter function to generate the HTML (the output of
             * formatter functions is not filtered, even with escapeHTMLInData set to true).
             * 
             */
            "escapeHTMLInData": boolean;
            set(property:"escapeHTMLInData", value: boolean): void;
            get(property:"escapeHTMLInData"): boolean;
            watch(property:"escapeHTMLInData", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * flag modifies vertical scrolling behavior. Defaults to true but set to false for slower
             * scroll performance but more immediate scrolling feedback
             * 
             */
            "fastScroll": boolean;
            set(property:"fastScroll", value: boolean): void;
            get(property:"fastScroll"): boolean;
            watch(property:"fastScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An object to execute format functions within.  If not set, the
             * format functions will execute within the scope of the cell that
             * has a format function.
             * 
             */
            "formatterScope": Object;
            set(property:"formatterScope", value: Object): void;
            get(property:"formatterScope"): Object;
            watch(property:"formatterScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If set to a dijit.Menu, will use this as a context menu for the grid headers.
             * 
             */
            "headerMenu": Object;
            set(property:"headerMenu", value: Object): void;
            get(property:"headerMenu"): Object;
            watch(property:"headerMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * explicit height of the grid, measured in any valid css unit.  This will be populated (and overridden)
             * if the height: css attribute exists on the source node.
             * 
             */
            "height": string;
            set(property:"height", value: string): void;
            get(property:"height"): string;
            watch(property:"height", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A css string to use to set our initial width (only used if autoWidth
             * is true).  The first rendering of the grid will be this width, any
             * resizing of columns, etc will result in the grid switching to
             * autoWidth mode.  Note, this width will override any styling in a
             * stylesheet or directly on the node.
             * 
             */
            "initialWidth": string;
            set(property:"initialWidth", value: string): void;
            get(property:"initialWidth"): string;
            watch(property:"initialWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidated": Object;
            set(property:"invalidated", value: Object): void;
            get(property:"invalidated"): Object;
            watch(property:"invalidated", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Number of rows to keep in the rendering cache.
             * 
             */
            "keepRows": number;
            set(property:"keepRows", value: number): void;
            get(property:"keepRows"): number;
            watch(property:"keepRows", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows while the grid is loading
             * 
             */
            "loadingMessage": string;
            set(property:"loadingMessage", value: string): void;
            get(property:"loadingMessage"): string;
            watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows if the grid has no data - wrap it in a
             * span with class 'dojoxGridNoData' if you want it to be
             * styled similar to the loading and error messages
             * 
             */
            "noDataMessage": string;
            set(property:"noDataMessage", value: string): void;
            get(property:"noDataMessage"): string;
            watch(property:"noDataMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Label of placeholders to search for in the header menu to replace with column toggling
             * menu items.
             * 
             */
            "placeholderLabel": string;
            set(property:"placeholderLabel", value: string): void;
            get(property:"placeholderLabel"): string;
            watch(property:"placeholderLabel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If rowHeight is set to a positive number, it will define the height of the rows
             * in pixels. This can provide a significant performance advantage, since it
             * eliminates the need to measure row sizes during rendering, which is one
             * the primary bottlenecks in the DataGrid's performance.
             * 
             */
            "rowHeight": number;
            set(property:"rowHeight", value: number): void;
            get(property:"rowHeight"): number;
            watch(property:"rowHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If set to true, will add a row selector view to this grid.  If set to a CSS width, will add
             * a row selector of that width to this grid.
             * 
             */
            "rowSelector": boolean;
            set(property:"rowSelector", value: boolean): void;
            get(property:"rowSelector"): boolean;
            watch(property:"rowSelector", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Number of rows to render at a time.
             * 
             */
            "rowsPerPage": number;
            set(property:"rowsPerPage", value: number): void;
            get(property:"rowsPerPage"): number;
            watch(property:"rowsPerPage", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pixel distance a user must scroll vertically to trigger grid scrolling.
             * 
             */
            "scrollRedrawThreshold": number;
            set(property:"scrollRedrawThreshold", value: number): void;
            get(property:"scrollRedrawThreshold"): number;
            watch(property:"scrollRedrawThreshold", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set to true if you want to be able to select the text within the grid.
             * 
             */
            "selectable": boolean;
            set(property:"selectable", value: boolean): void;
            get(property:"selectable"): boolean;
            watch(property:"selectable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set the selection mode of grid's Selection.  Value must be 'single', 'multiple',
             * or 'extended'.  Default is 'extended'.
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Single-click starts editing. Default is double-click
             * 
             */
            "singleClickEdit": boolean;
            set(property:"singleClickEdit", value: boolean): void;
            get(property:"singleClickEdit"): boolean;
            watch(property:"singleClickEdit", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "sortInfo": number;
            set(property:"sortInfo", value: number): void;
            get(property:"sortInfo"): number;
            watch(property:"sortInfo", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * View layout defintion.
             * 
             */
            "structure": Object;
            set(property:"structure", value: Object): void;
            get(property:"structure"): Object;
            watch(property:"structure", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Customizable summary descriptions which will be added to grid.domNode
             * 
             */
            "summary": string;
            set(property:"summary", value: string): void;
            get(property:"summary"): string;
            watch(property:"summary", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "updating": boolean;
            set(property:"updating", value: boolean): void;
            get(property:"updating"): boolean;
            watch(property:"updating", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add a row to the grid.
             * 
             */
            addRow(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Use to make multiple changes to rows while queueing row updating.
             * 
             */
            beginUpdate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             */
            buildViews(): void;
            /**
             * Determines if the grid can be sorted
             * 
             * @param inSortInfo Sort information, 1-based index of column on which to sort, positive for an ascending sortand negative for a descending sort             
             */
            canSort(inSortInfo: number): boolean;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Creates a new Grid layout
             * 
             */
            createLayout(): void;
            /**
             * create grid managers for various tasks including rows, focus, selection, editing
             * 
             */
            createManagers(): void;
            /**
             * Creates a new virtual scroller
             * 
             */
            createScroller(): void;
            /**
             * 
             */
            createSelection(): void;
            /**
             * 
             * @param inClass             
             * @param idx             
             */
            createView(inClass: any, idx: any): any;
            /**
             * 
             */
            createViews(): void;
            /**
             * 
             */
            defaultUpdate(): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchKeyEvent(e: any): void;
            /**
             * 
             * @param inValue             
             * @param inRowIndex             
             * @param inFieldIndex             
             */
            doApplyCellEdit(inValue: any, inRowIndex: any, inFieldIndex: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            doApplyEdit(inRowIndex: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            doCancelEdit(inRowIndex: any): void;
            /**
             * 
             * @param e             
             */
            doclick(e: any): void;
            /**
             * 
             * @param e             
             */
            docontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            dodblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheadercontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderdblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            dokeydown(e: any): void;
            /**
             * 
             * @param e             
             */
            doKeyEvent(e: any): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            doStartEdit(inCell: any, inRowIndex: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Use after calling beginUpdate to render any changes made to rows.
             * 
             */
            endUpdate(): void;
            /**
             * 
             */
            finishScrollJob(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Retrieves the cell object for a given grid column.
             * 
             * @param inIndex Grid column index of cell to retrieve             
             */
            getCell(inIndex: number): any;
            /**
             * Returns the cell name of a passed cell
             * 
             * @param inCell             
             */
            getCellName(inCell: any): String;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             */
            getCellNodeTextDirection(inColIndex: any, inRowIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * returns an array of dijit.CheckedMenuItem widgets that can be
             * added to a menu for toggling columns on and off.
             * 
             */
            getColumnTogglingItems(): any;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param inRowIndex             
             */
            getItem(inRowIndex: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * find the rowNode that is not a rowSelector
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * Returns true if grid is sorted in an ascending direction.
             * 
             * @param inSortInfo             
             */
            getSortAsc(inSortInfo: any): any;
            /**
             * Returns the index of the column on which the grid is sorted
             * 
             * @param inSortInfo             
             */
            getSortIndex(inSortInfo: any): number;
            /**
             * 
             */
            hasLayout(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param props             
             * @param node             
             * @param ctor             
             * @param cellFunc             
             */
            markupFactory(props: any, node: any, ctor: any, cellFunc: any): void;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postrender(): void;
            /**
             * 
             */
            postresize(): void;
            /**
             * 
             */
            prerender(): void;
            /**
             * Remove the selected rows from the grid.
             * 
             */
            removeSelectedRows(): void;
            /**
             * Render the grid, headers, and views. Edit and scrolling states are reset. To retain edit and
             * scrolling states, see Update.
             * 
             */
            render(): void;
            /**
             * Update the grid's rendering dimensions and resize it
             * 
             * @param changeSize             
             * @param resultSize             
             */
            resize(changeSize: any, resultSize: any): void;
            /**
             * Update grid when the height of a row has changed. Row height is handled automatically as rows
             * are rendered. Use this function only to update a row's height outside the normal rendering process.
             * 
             * @param inRowIndex index of the row that has changed height             
             */
            rowHeightChanged(inRowIndex: number): void;
            /**
             * Vertically scroll the grid to a given pixel position
             * 
             * @param inTop vertical position of the grid in pixels             
             */
            scrollTo(inTop: number): void;
            /**
             * Scroll the grid to a specific row.
             * 
             * @param inRowIndex grid row index             
             */
            scrollToRow(inRowIndex: number): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             * @param textDir             
             */
            setCellNodeTextDirection(inColIndex: any, inRowIndex: any, textDir: any): void;
            /**
             * 
             * @param inIndex             
             * @param inUnitWidth             
             */
            setCellWidth(inIndex: any, inUnitWidth: any): void;
            /**
             * 
             * @param menu             
             */
            setHeaderMenu(menu: dijit.Menu): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): void;
            /**
             * Sort the grid on a column in a specified direction
             * 
             * @param inIndex Column index on which to sort.             
             * @param inAsc If true, sort the grid in ascending order, otherwise in descending order             
             */
            setSortIndex(inIndex: number, inAsc: boolean): void;
            /**
             * 
             * @param inSortInfo             
             */
            setSortInfo(inSortInfo: any): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure:  Object[] ): void;
            /**
             * 
             */
            setupHeaderMenu(): void;
            /**
             * 
             * @param message             
             */
            showMessage(message: any): void;
            /**
             * 
             */
            sizeChange(): void;
            /**
             * 
             */
            sort(): void;
            /**
             * 
             */
            startup(): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            textSizeChanged(): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Update the grid, retaining edit and scrolling states.
             * 
             */
            update(): void;
            /**
             * Render a single row.
             * 
             * @param inRowIndex Index of the row to render             
             */
            updateRow(inRowIndex: number): void;
            /**
             * Change the number of rows.
             * 
             * @param inRowCount Number of rows in the grid.             
             */
            updateRowCount(inRowCount: number): void;
            /**
             * Render consecutive rows at once.
             * 
             * @param startIndex Index of the starting row to render             
             * @param howMany How many rows to update.             
             */
            updateRows(startIndex: number, howMany: number): void;
            /**
             * Update the styles for a row after it's state has changed.
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Event fired when editing is applied for a given grid cell
             * 
             * @param inValue Value from cell editor             
             * @param inRowIndex Index of the grid row             
             * @param inFieldIndex Index in the grid's data store             
             */
            onApplyCellEdit(inValue: String, inRowIndex: number, inFieldIndex: number): void;
            /**
             * Event fired when editing is applied for a given grid row
             * 
             * @param inRowIndex Index of the grid row             
             */
            onApplyEdit(inRowIndex: number): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Event fired when editing is cancelled for a given grid cell
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCancelEdit(inRowIndex: number): void;
            /**
             * Event to determine if a grid row may be deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanDeselect(inRowIndex: number): any;
            /**
             * Event to determine if a grid row may be selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanSelect(inRowIndex: number): any;
            /**
             * Event fired when a cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellClick(e: Event): void;
            /**
             * Event fired when a cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellContextMenu(e: Event): void;
            /**
             * Event fired when a cell is double-clicked.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellDblClick(e: Event): void;
            /**
             * Event fired when a cell receives focus.
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onCellFocus(inCell: Object, inRowIndex: number): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse is over a cell.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOver(e: Event): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Top level handler for Content events
             * 
             * @param e             
             */
            onContentEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Event fired when a grid row is deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onDeselected(inRowIndex: number): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event fired when a header cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellClick(e: Event): void;
            /**
             * Event fired when a header cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellContextMenu(e: Event): void;
            /**
             * Event fired when a header cell is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOver(e: Event): void;
            /**
             * Event fired when the grid header is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderClick(e: Event): void;
            /**
             * Event fired when the grid header context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderContextMenu(e: Event): void;
            /**
             * Event fired when the grid header is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderDblClick(e: Event): void;
            /**
             * Top level handler for header events
             * 
             * @param e             
             */
            onHeaderEvent(e: any): void;
            /**
             * Event fired when mouse moves out of the grid header.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over the grid header.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOver(e: Event): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * top level handler for Key Events
             * 
             * @param e             
             */
            onKeyEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Event fired when mouse is down inside grid row
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDownRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Event fired when mouse moves out of any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOutRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Event fired when mouse is over any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOverRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * 
             */
            onMoveColumn(): void;
            /**
             * 
             * @param cellIdx             
             */
            onResizeColumn(cellIdx: number): void;
            /**
             * Event fired when a row is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowClick(e: Event): void;
            /**
             * Event fired when a row context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowContextMenu(e: Event): void;
            /**
             * Event fired when a row is double clicked.
             * 
             * @param e decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a data row.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a data row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOver(e: Event): void;
            /**
             * Event fired when a grid row is selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onSelected(inRowIndex: number): void;
            /**
             * 
             */
            onSelectionChanged(): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
            /**
             * Event fired when editing is started for a given grid cell
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onStartEdit(inCell: Object, inRowIndex: number): void;
            /**
             * Perform row styling on a given row. Called whenever row styling is updated.
             * 
             * @param inRow Object containing row state information: selected, true if the row is selcted; over:true of the mouse is over the row; odd: true if the row is odd. Use customClasses andcustomStyles to control row css classes and styles; both properties are strings.             
             */
            onStyleRow(inRow: Object): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_ViewManager.html
         *
         * A collection of grid views. Owned by grid and used internally for managing grid views.
         * Grid creates views automatically based on grid's layout structure.
         * Users should typically not need to access individual views or the views collection directly.
         * 
         * @param inGrid     
         */
        class _ViewManager {
            constructor(inGrid: any);
            /**
             * 
             */
            "defaultWidth": number;
            /**
             * 
             */
            "views": any[];
            /**
             * 
             * @param inView             
             */
            addView(inView: any): void;
            /**
             * 
             * @param l             
             * @param w             
             */
            arrange(l: number, w: number): number;
            /**
             * 
             */
            destroyViews(): void;
            /**
             * 
             * @param inAutoWidth             
             */
            findClient(inAutoWidth: any): any;
            /**
             * 
             * @param inCallback             
             */
            forEach(inCallback: any): void;
            /**
             * 
             */
            getContentNodes(): any[];
            /**
             * Returns the first grid view with a scroll bar
             * 
             */
            getFirstScrollingView(): any;
            /**
             * 
             * @param inIndex             
             */
            getViewWidth(inIndex: any): any;
            /**
             * 
             */
            measureContent(): number;
            /**
             * 
             */
            measureHeader(): number;
            /**
             * 
             */
            normalizeHeaderNodeHeight(): void;
            /**
             * 
             * @param inRowNodes             
             */
            normalizeRowNodeHeights(inRowNodes: any): void;
            /**
             * 
             */
            render(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inNodes             
             * @param skipRenorm             
             */
            renderRow(inRowIndex: any, inNodes: any, skipRenorm: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            renormalizeRow(inRowIndex: any): void;
            /**
             * 
             */
            resetHeaderNodeHeight(): void;
            /**
             * 
             */
            resize(): void;
            /**
             * 
             * @param inRowIndex             
             */
            rowRemoved(inRowIndex: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): any;
            /**
             * 
             * @param inRowIndex             
             * @param skipRenorm             
             */
            updateRow(inRowIndex: any, skipRenorm: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * 
             * @param inMethod             
             * @param inArgs             
             */
            onEach(inMethod: any, inArgs: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_TreeView.html
         *
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _TreeView extends dojox.grid._View {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Default width of the view
             * 
             */
            "defaultWidth": string;
            set(property:"defaultWidth", value: string): void;
            get(property:"defaultWidth"): string;
            watch(property:"defaultWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "firstScroll": number;
            set(property:"firstScroll", value: number): void;
            get(property:"firstScroll"): number;
            watch(property:"firstScroll", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "lastTop": number;
            set(property:"lastTop", value: number): void;
            get(property:"lastTop"): number;
            watch(property:"lastTop", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "marginBottom": number;
            set(property:"marginBottom", value: number): void;
            get(property:"marginBottom"): number;
            watch(property:"marginBottom", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "rowPad": number;
            set(property:"rowPad", value: number): void;
            get(property:"rowPad"): number;
            watch(property:"rowPad", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Width for the view, in valid css unit
             * 
             */
            "viewWidth": string;
            set(property:"viewWidth", value: string): void;
            get(property:"viewWidth"): string;
            watch(property:"viewWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             * @param minusScroll             
             */
            adaptHeight(minusScroll: any): void;
            /**
             * 
             */
            adaptWidth(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRowContent(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * 
             */
            convertColPctToFixed(): boolean;
            /**
             * 
             * @param inRowIndex             
             */
            createRowNode(inRowIndex: any): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            doContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            doHeaderEvent(e: any): void;
            /**
             * 
             * @param inEvent             
             */
            doscroll(inEvent: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            doStyleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * 
             */
            focus(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * 
             * @param inRowIndex             
             * @param inCellIndex             
             */
            getCellNode(inRowIndex: any, inCellIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             */
            getColumnsWidth(): number;
            /**
             * 
             */
            getContentWidth(): String;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param inCellIndex             
             */
            getHeaderCellNode(inCellIndex: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * 
             */
            getScrollbarWidth(): any;
            /**
             * 
             */
            getWidth(): String;
            /**
             * 
             * @param reset             
             */
            hasHScrollbar(reset: any): boolean;
            /**
             * 
             * @param reset             
             */
            hasVScrollbar(reset: any): boolean;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            render(): void;
            /**
             * 
             */
            renderHeader(): void;
            /**
             * 
             * @param inRowIndex             
             */
            renderRow(inRowIndex: any): any;
            /**
             * 
             */
            resize(): void;
            /**
             * 
             * @param inRowIndex             
             */
            rowRemoved(inRowIndex: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param width             
             */
            setColumnsWidth(width: any): void;
            /**
             * 
             * @param inIndex             
             * @param inWidth             
             */
            setColWidth(inIndex: any, inWidth: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): any;
            /**
             * 
             * @param w             
             * @param h             
             */
            setSize(w: any, h: any): void;
            /**
             * 
             * @param inStructure             
             */
            setStructure(inStructure: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            testFlexCells(): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             */
            update(): void;
            /**
             * 
             * @param inRowIndex             
             */
            updateRow(inRowIndex: any): any;
            /**
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * 
             */
            updateStructure(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * 
             * @param inRowIndex             
             * @param cells             
             * @param inRowNode             
             */
            onAfterRow(inRowIndex: any, cells: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param cells             
             */
            onBeforeRow(inRowIndex: any, cells: any): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_Selector.html
         *
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _Selector extends dojox.grid._View {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "defaultWidth": string;
            set(property:"defaultWidth", value: string): void;
            get(property:"defaultWidth"): string;
            watch(property:"defaultWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "firstScroll": number;
            set(property:"firstScroll", value: number): void;
            get(property:"firstScroll"): number;
            watch(property:"firstScroll", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "inputType": string;
            set(property:"inputType", value: string): void;
            get(property:"inputType"): string;
            watch(property:"inputType", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "lastTop": number;
            set(property:"lastTop", value: number): void;
            get(property:"lastTop"): number;
            watch(property:"lastTop", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "marginBottom": number;
            set(property:"marginBottom", value: number): void;
            get(property:"marginBottom"): number;
            watch(property:"marginBottom", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "noscroll": boolean;
            set(property:"noscroll", value: boolean): void;
            get(property:"noscroll"): boolean;
            watch(property:"noscroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "padBorderWidth": number;
            set(property:"padBorderWidth", value: number): void;
            get(property:"padBorderWidth"): number;
            watch(property:"padBorderWidth", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "rowPad": number;
            set(property:"rowPad", value: number): void;
            get(property:"rowPad"): number;
            watch(property:"rowPad", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Width for the view, in valid css unit
             * 
             */
            "viewWidth": string;
            set(property:"viewWidth", value: string): void;
            get(property:"viewWidth"): string;
            watch(property:"viewWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             * @param minusScroll             
             */
            adaptHeight(minusScroll: any): void;
            /**
             * 
             */
            adaptWidth(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRowContent(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * 
             */
            convertColPctToFixed(): boolean;
            /**
             * 
             * @param inRowIndex             
             */
            createRowNode(inRowIndex: any): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            doContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            doHeaderEvent(e: any): void;
            /**
             * 
             * @param inEvent             
             */
            doscroll(inEvent: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            doStyleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * 
             */
            focus(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * 
             * @param inRowIndex             
             * @param inCellIndex             
             */
            getCellNode(inRowIndex: any, inCellIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             */
            getColumnsWidth(): number;
            /**
             * 
             */
            getContentWidth(): String;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param inCellIndex             
             */
            getHeaderCellNode(inCellIndex: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * 
             */
            getScrollbarWidth(): any;
            /**
             * 
             */
            getWidth(): any;
            /**
             * 
             * @param reset             
             */
            hasHScrollbar(reset: any): boolean;
            /**
             * 
             * @param reset             
             */
            hasVScrollbar(reset: any): boolean;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            render(): void;
            /**
             * 
             */
            renderHeader(): void;
            /**
             * 
             * @param inRowIndex             
             */
            renderRow(inRowIndex: any): any;
            /**
             * 
             */
            resize(): void;
            /**
             * 
             * @param inRowIndex             
             */
            rowRemoved(inRowIndex: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param width             
             */
            setColumnsWidth(width: any): void;
            /**
             * 
             * @param inIndex             
             * @param inWidth             
             */
            setColWidth(inIndex: any, inWidth: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): any;
            /**
             * 
             * @param w             
             * @param h             
             */
            setSize(w: any, h: any): void;
            /**
             * 
             * @param s             
             */
            setStructure(s: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            testFlexCells(): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             */
            update(): void;
            /**
             * 
             * @param inRowIndex             
             */
            updateRow(inRowIndex: any): any;
            /**
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * 
             */
            updateStructure(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * 
             * @param inRowIndex             
             * @param cells               OptionalThe structure of the cells within this grid.             
             * @param inRowNode             
             */
            onAfterRow(inRowIndex: any, cells: Object[] , inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param cells             
             */
            onBeforeRow(inRowIndex: any, cells: any): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * 
             * @param inIndex             
             */
            onDeselected(inIndex: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * 
             * @param inIndex             
             */
            onSelected(inIndex: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_RowSelector.html
         *
         * Custom grid view. If used in a grid structure, provides a small selectable region for grid rows.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _RowSelector extends dojox.grid._View {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "defaultWidth": string;
            set(property:"defaultWidth", value: string): void;
            get(property:"defaultWidth"): string;
            watch(property:"defaultWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "firstScroll": number;
            set(property:"firstScroll", value: number): void;
            get(property:"firstScroll"): number;
            watch(property:"firstScroll", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "lastTop": number;
            set(property:"lastTop", value: number): void;
            get(property:"lastTop"): number;
            watch(property:"lastTop", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "marginBottom": number;
            set(property:"marginBottom", value: number): void;
            get(property:"marginBottom"): number;
            watch(property:"marginBottom", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "noscroll": boolean;
            set(property:"noscroll", value: boolean): void;
            get(property:"noscroll"): boolean;
            watch(property:"noscroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "padBorderWidth": number;
            set(property:"padBorderWidth", value: number): void;
            get(property:"padBorderWidth"): number;
            watch(property:"padBorderWidth", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "rowPad": number;
            set(property:"rowPad", value: number): void;
            get(property:"rowPad"): number;
            watch(property:"rowPad", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Width for the view, in valid css unit
             * 
             */
            "viewWidth": string;
            set(property:"viewWidth", value: string): void;
            get(property:"viewWidth"): string;
            watch(property:"viewWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             * @param minusScroll             
             */
            adaptHeight(minusScroll: any): void;
            /**
             * 
             */
            adaptWidth(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRowContent(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * 
             */
            convertColPctToFixed(): boolean;
            /**
             * 
             * @param inRowIndex             
             */
            createRowNode(inRowIndex: any): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            doContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            doHeaderEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            domouseout(e: any): void;
            /**
             * 
             * @param e             
             */
            domouseover(e: any): void;
            /**
             * 
             * @param inEvent             
             */
            doscroll(inEvent: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            doStyleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * 
             */
            focus(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * 
             * @param inRowIndex             
             * @param inCellIndex             
             */
            getCellNode(inRowIndex: any, inCellIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             */
            getColumnsWidth(): number;
            /**
             * 
             */
            getContentWidth(): String;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param inCellIndex             
             */
            getHeaderCellNode(inCellIndex: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * 
             */
            getScrollbarWidth(): any;
            /**
             * 
             */
            getWidth(): any;
            /**
             * 
             * @param reset             
             */
            hasHScrollbar(reset: any): boolean;
            /**
             * 
             * @param reset             
             */
            hasVScrollbar(reset: any): boolean;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            render(): void;
            /**
             * 
             */
            renderHeader(): void;
            /**
             * 
             * @param inRowIndex             
             */
            renderRow(inRowIndex: any): any;
            /**
             * 
             */
            resize(): void;
            /**
             * 
             * @param inRowIndex             
             */
            rowRemoved(inRowIndex: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param width             
             */
            setColumnsWidth(width: any): void;
            /**
             * 
             * @param inIndex             
             * @param inWidth             
             */
            setColWidth(inIndex: any, inWidth: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): any;
            /**
             * 
             * @param w             
             * @param h             
             */
            setSize(w: any, h: any): void;
            /**
             * 
             * @param inStructure             
             */
            setStructure(inStructure: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            testFlexCells(): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             */
            update(): void;
            /**
             * 
             */
            updateRow(): void;
            /**
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * 
             */
            updateStructure(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * 
             * @param inRowIndex             
             * @param cells               OptionalThe structure of the cells within this grid.             
             * @param inRowNode             
             */
            onAfterRow(inRowIndex: any, cells: Object[] , inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param cells               OptionalThe structure of the cells within this grid.             
             * @param inRowNode             
             */
            onAfterRow(inRowIndex: any, cells: Object[][], inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param cells             
             */
            onBeforeRow(inRowIndex: any, cells: any): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/DataSelection.html
         *
         * 
         * @param grid     
         */
        class DataSelection extends dojox.grid.Selection {
            constructor(grid: any);
            /**
             * 
             */
            "mode": string;
            /**
             * 
             */
            "rangeStartIndex": number;
            /**
             * 
             */
            "selected": Object;
            /**
             * 
             */
            "selectedIndex": number;
            /**
             * 
             */
            "updating": number;
            /**
             * 
             * @param inItemOrIndex             
             */
            addToSelection(inItemOrIndex: any): void;
            /**
             * 
             */
            clear(): void;
            /**
             * 
             * @param inIndex             
             * @param inCtrlKey             
             * @param inShiftKey             
             */
            clickSelect(inIndex: any, inCtrlKey: any, inShiftKey: any): void;
            /**
             * 
             * @param e             
             */
            clickSelectEvent(e: any): void;
            /**
             * 
             * @param inItemOrIndex             
             */
            deselect(inItemOrIndex: any): void;
            /**
             * 
             * @param inItemOrIndex             
             */
            deselectAll(inItemOrIndex: any): void;
            /**
             * 
             * @param inFrom             
             * @param inTo             
             */
            deselectRange(inFrom: any, inTo: any): void;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             */
            getFirstSelected(): any;
            /**
             * 
             * @param inPrev             
             */
            getNextSelected(inPrev: any): any;
            /**
             * 
             */
            getSelected(): any[];
            /**
             * 
             */
            getSelectedCount(): number;
            /**
             * 
             * @param inIndex             
             */
            insert(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            isSelected(inIndex: any): any;
            /**
             * 
             * @param inIndex             
             */
            remove(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            select(inIndex: any): void;
            /**
             * 
             * @param inFrom             
             * @param inTo             
             */
            selectRange(inFrom: any, inTo: any): void;
            /**
             * 
             * @param mode             
             */
            setMode(mode: any): void;
            /**
             * 
             * @param inIndex             
             * @param inSelect             
             */
            setSelected(inIndex: any, inSelect: any): void;
            /**
             * 
             * @param inIndex             
             */
            toggleSelect(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            onCanDeselect(inIndex: any): any;
            /**
             * 
             * @param inIndex             
             */
            onCanSelect(inIndex: any): any;
            /**
             * 
             */
            onChanged(): void;
            /**
             * 
             */
            onChanging(): void;
            /**
             * 
             * @param inIndex             
             */
            onDeselected(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            onSelected(inIndex: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/_View.html
         *
         * A collection of grid columns. A grid is comprised of a set of views that stack horizontally.
         * Grid creates views automatically based on grid's layout structure.
         * Users should typically not need to access individual views directly.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class _View extends dijit._Widget implements dijit._TemplatedMixin {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * Default width of the view
             * 
             */
            "defaultWidth": string;
            set(property:"defaultWidth", value: string): void;
            get(property:"defaultWidth"): string;
            watch(property:"defaultWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "firstScroll": number;
            set(property:"firstScroll", value: number): void;
            get(property:"firstScroll"): number;
            watch(property:"firstScroll", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "lastTop": number;
            set(property:"lastTop", value: number): void;
            get(property:"lastTop"): number;
            watch(property:"lastTop", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "marginBottom": number;
            set(property:"marginBottom", value: number): void;
            get(property:"marginBottom"): number;
            watch(property:"marginBottom", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "rowPad": number;
            set(property:"rowPad", value: number): void;
            get(property:"rowPad"): number;
            watch(property:"rowPad", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Width for the view, in valid css unit
             * 
             */
            "viewWidth": string;
            set(property:"viewWidth", value: string): void;
            get(property:"viewWidth"): string;
            watch(property:"viewWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             * @param minusScroll             
             */
            adaptHeight(minusScroll: any): void;
            /**
             * 
             */
            adaptWidth(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Construct the UI for this widget, setting this.domNode.
             * Most widgets will mixin dijit._TemplatedMixin, which implements this method.
             * 
             */
            buildRendering(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            buildRowContent(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * 
             */
            convertColPctToFixed(): boolean;
            /**
             * 
             * @param inRowIndex             
             */
            createRowNode(inRowIndex: any): any;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): any;
            /**
             * 
             * @param e             
             */
            doContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            doHeaderEvent(e: any): void;
            /**
             * 
             * @param inEvent             
             */
            doscroll(inEvent: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            doStyleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * 
             */
            focus(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * 
             * @param inRowIndex             
             * @param inCellIndex             
             */
            getCellNode(inRowIndex: any, inCellIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * 
             */
            getColumnsWidth(): number;
            /**
             * 
             */
            getContentWidth(): String;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param inCellIndex             
             */
            getHeaderCellNode(inCellIndex: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * 
             */
            getScrollbarWidth(): any;
            /**
             * 
             */
            getWidth(): String;
            /**
             * 
             * @param reset             
             */
            hasHScrollbar(reset: any): boolean;
            /**
             * 
             * @param reset             
             */
            hasVScrollbar(reset: any): boolean;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            render(): void;
            /**
             * 
             */
            renderHeader(): void;
            /**
             * 
             * @param inRowIndex             
             */
            renderRow(inRowIndex: any): any;
            /**
             * 
             */
            resize(): void;
            /**
             * 
             * @param inRowIndex             
             */
            rowRemoved(inRowIndex: any): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param width             
             */
            setColumnsWidth(width: any): void;
            /**
             * 
             * @param inIndex             
             * @param inWidth             
             */
            setColWidth(inIndex: any, inWidth: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): any;
            /**
             * 
             * @param w             
             * @param h             
             */
            setSize(w: any, h: any): void;
            /**
             * 
             * @param inStructure             
             */
            setStructure(inStructure: any): void;
            /**
             * Processing after the DOM fragment is added to the document
             * Called after a widget and its children have been created and added to the page,
             * and all related widgets have finished their create() cycle, up through postCreate().
             * 
             * Note that startup() may be called while the widget is still hidden, for example if the widget is
             * inside a hidden dijit/Dialog or an unselected tab of a dijit/layout/TabContainer.
             * For widgets that need to do layout, it's best to put that layout code inside resize(), and then
             * extend dijit/layout/_LayoutWidget so that resize() is called when the widget is visible.
             * 
             */
            startup(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRow(inRowIndex: any, inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            testFlexCells(): any;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * 
             */
            update(): void;
            /**
             * 
             * @param inRowIndex             
             */
            updateRow(inRowIndex: any): any;
            /**
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * 
             */
            updateStructure(): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * 
             * @param inRowIndex             
             * @param cells               OptionalThe structure of the cells within this grid.             
             * @param inRowNode             
             */
            onAfterRow(inRowIndex: any, cells: Object[] , inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param cells               OptionalThe structure of the cells within this grid.             
             * @param inRowNode             
             */
            onAfterRow(inRowIndex: any, cells: Object[][], inRowNode: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param cells             
             */
            onBeforeRow(inRowIndex: any, cells: any): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/LazyTreeGridStoreModel.html
         *
         * 
         * @param args     
         */
        class LazyTreeGridStoreModel extends dijit.tree.ForestStoreModel {
            constructor(args: Object);
            /**
             * One or more attribute names (attributes in the dojo.data item) that specify that item's children
             * 
             */
            "childrenAttrs": Object;
            /**
             * Setting this to true will cause the TreeStoreModel to defer calling loadItem on nodes
             * until they are expanded. This allows for lazying loading where only one
             * loadItem (and generally one network call, consequently) per expansion
             * (rather than one for each child).
             * This relies on partial loading of the children items; each children item of a
             * fully loaded item should contain the label and info about having children.
             * 
             */
            "deferItemLoadingUntilExpand": boolean;
            /**
             * If specified, get label for tree node from this attribute, rather
             * than by calling store.getLabel()
             * 
             */
            "labelAttr": string;
            /**
             * Name of attribute in the Object passed to newItem() that specifies the id.
             * 
             * If newItemIdAttr is set then it's used when newItem() is called to see if an
             * item with the same id already exists, and if so just links to the old item
             * (so that the old item ends up with two parents).
             * 
             * Setting this to null or "" will make every drop create a new item.
             * 
             */
            "newItemIdAttr": string;
            /**
             * Specifies the set of children of the root item.
             * 
             */
            "query": string;
            /**
             * Pointer to the root item (read only, not a parameter)
             * 
             */
            "root": Object;
            /**
             * ID of fabricated root item
             * 
             */
            "rootId": string;
            /**
             * Label of fabricated root item
             * 
             */
            "rootLabel": string;
            /**
             * 
             */
            "serverStore": boolean;
            /**
             * Underlying store
             * 
             */
            "store": Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             * @param keywordArgs             
             */
            fetchItemByIdentity(keywordArgs: Object): void;
            /**
             * 
             * @param parentItem             
             * @param onComplete             
             * @param onError             
             * @param queryObj             
             */
            getChildren(parentItem: dojo.data.api.Item, onComplete: {(items:Object[], size?:number): any;}, onError: Function, queryObj?: Object): void;
            /**
             * 
             * @param item             
             */
            getIdentity(item: any): any;
            /**
             * 
             * @param item             
             */
            getLabel(item: any): any;
            /**
             * Calls onItem with the root item for the tree, possibly a fabricated item.
             * Calls onError on error.
             * 
             * @param onItem             
             * @param onError             
             */
            getRoot(onItem: any, onError: any): void;
            /**
             * 
             * @param something             
             */
            isItem(something: any): boolean;
            /**
             * 
             * @param item             
             */
            mayHaveChildren(item: dojo.data.api.Item): any;
            /**
             * Creates a new item.   See dojo/data/api/Write for details on args.
             * Used in drag & drop when item from external source dropped onto tree.
             * 
             * @param args             
             * @param parent             
             * @param insertIndex               Optional            
             */
            newItem(args: dijit.tree.dndSource.__Item, parent: any, insertIndex: number): any;
            /**
             * Move or copy an item from one parent item to another.
             * Used in drag & drop
             * 
             * @param childItem             
             * @param oldParentItem             
             * @param newParentItem             
             * @param bCopy             
             * @param insertIndex               Optional            
             */
            pasteItem(childItem: any, oldParentItem: any, newParentItem: any, bCopy: boolean, insertIndex: number): void;
            /**
             * Called when item added to root of tree; user must override this method
             * to modify the item so that it matches the query for top level items
             * 
             * @param item             
             */
            onAddToRoot(item: any): void;
            /**
             * Callback whenever an item has changed, so that Tree
             * can update the label, icon, etc.   Note that changes
             * to an item's children or parent(s) will trigger an
             * onChildrenChange() so you can ignore those changes here.
             * 
             * @param item             
             */
            onChange(item: dojo.data.api.Item): void;
            /**
             * Callback to do notifications about new, updated, or deleted items.
             * 
             * @param parent             
             * @param newChildrenList             
             */
            onChildrenChange(parent: dojo.data.api.Item, newChildrenList: dojo.data.api.Item[]): void;
            /**
             * Callback when an item has been deleted.
             * Note that there will also be an onChildrenChange() callback for the parent
             * of this item.
             * 
             * @param item             
             */
            onDelete(item: dojo.data.api.Item): void;
            /**
             * 
             * @param item             
             */
            onDeleteItem(item: any): void;
            /**
             * Called when item removed from root of tree; user must override this method
             * to modify the item so it doesn't match the query for top level items
             * 
             * @param item             
             */
            onLeaveRoot(item: any): void;
            /**
             * 
             * @param item             
             * @param parentInfo             
             */
            onNewItem(item: any, parentInfo: any): void;
            /**
             * User can override this method to modify a new element that's being
             * added to the root of the tree, for example to add a flag like root=true
             * 
             * @param args             
             */
            onNewRootItem(args: dijit.tree.dndSource.__Item): void;
            /**
             * Updates the tree view according to changes to an item in the data store.
             * Developers should override this method to be more efficient based on their app/data.
             * Handles updates to an item's children by calling onChildrenChange(), and
             * other updates to an item by calling onChange().
             * 
             * Also, any change to any item re-executes the query for the tree's top-level items,
             * since this modified item may have started/stopped matching the query for top level items.
             * 
             * If possible, developers should override this function to only call _requeryTop() when
             * the change to the item has caused it to stop/start being a top level item in the tree.
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSetItem(item: any, attribute: String, oldValue: Object, newValue: Object): void;
            /**
             * Updates the tree view according to changes to an item in the data store.
             * Developers should override this method to be more efficient based on their app/data.
             * Handles updates to an item's children by calling onChildrenChange(), and
             * other updates to an item by calling onChange().
             * 
             * Also, any change to any item re-executes the query for the tree's top-level items,
             * since this modified item may have started/stopped matching the query for top level items.
             * 
             * If possible, developers should override this function to only call _requeryTop() when
             * the change to the item has caused it to stop/start being a top level item in the tree.
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSetItem(item: any, attribute: String, oldValue: any[], newValue: Object): void;
            /**
             * Updates the tree view according to changes to an item in the data store.
             * Developers should override this method to be more efficient based on their app/data.
             * Handles updates to an item's children by calling onChildrenChange(), and
             * other updates to an item by calling onChange().
             * 
             * Also, any change to any item re-executes the query for the tree's top-level items,
             * since this modified item may have started/stopped matching the query for top level items.
             * 
             * If possible, developers should override this function to only call _requeryTop() when
             * the change to the item has caused it to stop/start being a top level item in the tree.
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSetItem(item: any, attribute: String, oldValue: Object, newValue: any[]): void;
            /**
             * Updates the tree view according to changes to an item in the data store.
             * Developers should override this method to be more efficient based on their app/data.
             * Handles updates to an item's children by calling onChildrenChange(), and
             * other updates to an item by calling onChange().
             * 
             * Also, any change to any item re-executes the query for the tree's top-level items,
             * since this modified item may have started/stopped matching the query for top level items.
             * 
             * If possible, developers should override this function to only call _requeryTop() when
             * the change to the item has caused it to stop/start being a top level item in the tree.
             * 
             * @param item             
             * @param attribute             
             * @param oldValue             
             * @param newValue             
             */
            onSetItem(item: any, attribute: String, oldValue: any[], newValue: any[]): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/Selection.html
         *
         * Manages row selection for grid. Owned by grid and used internally
         * for selection. Override to implement custom selection.
         * 
         * @param inGrid     
         */
        class Selection {
            constructor(inGrid: any);
            /**
             * 
             */
            "mode": string;
            /**
             * 
             */
            "rangeStartIndex": number;
            /**
             * 
             */
            "selected": Object;
            /**
             * 
             */
            "selectedIndex": number;
            /**
             * 
             */
            "updating": number;
            /**
             * 
             * @param inIndex             
             */
            addToSelection(inIndex: any): void;
            /**
             * 
             */
            clear(): void;
            /**
             * 
             * @param inIndex             
             * @param inCtrlKey             
             * @param inShiftKey             
             */
            clickSelect(inIndex: any, inCtrlKey: any, inShiftKey: any): void;
            /**
             * 
             * @param e             
             */
            clickSelectEvent(e: any): void;
            /**
             * 
             * @param inIndex             
             */
            deselect(inIndex: any): void;
            /**
             * 
             * @param inExcept             
             */
            deselectAll(inExcept: any): void;
            /**
             * 
             * @param inFrom             
             * @param inTo             
             */
            deselectRange(inFrom: any, inTo: any): void;
            /**
             * 
             */
            getFirstSelected(): number;
            /**
             * 
             * @param inPrev             
             */
            getNextSelected(inPrev: any): number;
            /**
             * 
             */
            getSelected(): any[];
            /**
             * 
             */
            getSelectedCount(): number;
            /**
             * 
             * @param inIndex             
             */
            insert(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            isSelected(inIndex: any): any;
            /**
             * 
             * @param inIndex             
             */
            remove(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            select(inIndex: any): void;
            /**
             * 
             * @param inFrom             
             * @param inTo             
             */
            selectRange(inFrom: any, inTo: any): void;
            /**
             * 
             * @param mode             
             */
            setMode(mode: any): void;
            /**
             * 
             * @param inIndex             
             * @param inSelect             
             */
            setSelected(inIndex: any, inSelect: any): void;
            /**
             * 
             * @param inIndex             
             */
            toggleSelect(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            onCanDeselect(inIndex: any): any;
            /**
             * 
             * @param inIndex             
             */
            onCanSelect(inIndex: any): any;
            /**
             * 
             */
            onChanged(): void;
            /**
             * 
             */
            onChanging(): void;
            /**
             * 
             * @param inIndex             
             */
            onDeselected(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            onSelected(inIndex: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/TreeSelection.html
         *
         * 
         * @param grid     
         */
        class TreeSelection extends dojox.grid.DataSelection {
            constructor(grid: any);
            /**
             * 
             */
            "mode": string;
            /**
             * 
             */
            "rangeStartIndex": number;
            /**
             * 
             */
            "selected": Object;
            /**
             * 
             */
            "selectedIndex": number;
            /**
             * 
             */
            "updating": number;
            /**
             * 
             * @param inItemOrIndex             
             */
            addToSelection(inItemOrIndex: any): void;
            /**
             * 
             */
            clear(): void;
            /**
             * 
             * @param inIndex             
             * @param inCtrlKey             
             * @param inShiftKey             
             */
            clickSelect(inIndex: any, inCtrlKey: any, inShiftKey: any): void;
            /**
             * 
             * @param e             
             */
            clickSelectEvent(e: any): void;
            /**
             * 
             * @param inItemOrIndex             
             */
            deselect(inItemOrIndex: any): void;
            /**
             * 
             * @param inItemOrIndex             
             */
            deselectAll(inItemOrIndex: any): void;
            /**
             * 
             * @param inFrom             
             * @param inTo             
             */
            deselectRange(inFrom: any, inTo: any): void;
            /**
             * 
             */
            destroy(): void;
            /**
             * 
             */
            getFirstSelected(): any;
            /**
             * 
             * @param inPrev             
             */
            getNextSelected(inPrev: any): any;
            /**
             * 
             */
            getSelected(): any[];
            /**
             * 
             */
            getSelectedCount(): number;
            /**
             * 
             * @param inIndex             
             */
            insert(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            isSelected(inIndex: any): any;
            /**
             * 
             * @param inIndex             
             */
            remove(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            select(inIndex: any): void;
            /**
             * 
             * @param inFrom             
             * @param inTo             
             */
            selectRange(inFrom: any, inTo: any): void;
            /**
             * 
             * @param mode             
             */
            setMode(mode: any): void;
            /**
             * 
             * @param inIndex             
             * @param inSelect             
             */
            setSelected(inIndex: any, inSelect: any): void;
            /**
             * 
             * @param inIndex             
             */
            toggleSelect(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            onCanDeselect(inIndex: any): any;
            /**
             * 
             * @param inIndex             
             */
            onCanSelect(inIndex: any): any;
            /**
             * 
             */
            onChanged(): void;
            /**
             * 
             */
            onChanging(): void;
            /**
             * 
             * @param inIndex             
             */
            onDeselected(inIndex: any): void;
            /**
             * 
             * @param inIndex             
             */
            onSelected(inIndex: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/DataGrid.html
         *
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class DataGrid extends dojox.grid._Grid {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If autoHeight is true, grid height is automatically set to fit the data.
             * If it is an integer, the height will be automatically set to fit the data
             * if there are fewer than that many rows - and the height will be set to show
             * that many rows if there are more
             * 
             */
            "autoHeight": boolean;
            set(property:"autoHeight", value: boolean): void;
            get(property:"autoHeight"): boolean;
            watch(property:"autoHeight", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoRender is true, grid will render itself after initialization.
             * 
             */
            "autoRender": boolean;
            set(property:"autoRender", value: boolean): void;
            get(property:"autoRender"): boolean;
            watch(property:"autoRender", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoWidth is true, grid width is automatically set to fit the data.
             * 
             */
            "autoWidth": boolean;
            set(property:"autoWidth", value: boolean): void;
            get(property:"autoWidth"): boolean;
            watch(property:"autoWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * css class to apply to grid cells over which the cursor is placed.
             * 
             */
            "cellOverClass": string;
            set(property:"cellOverClass", value: string): void;
            get(property:"cellOverClass"): string;
            watch(property:"cellOverClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * CSS class applied to the grid's domNode
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * If set to true, will add drag and drop reordering to views with one row of columns.
             * 
             */
            "columnReordering": boolean;
            set(property:"columnReordering", value: boolean): void;
            get(property:"columnReordering"): boolean;
            watch(property:"columnReordering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * default height of the grid, measured in any valid css unit.
             * 
             */
            "defaultHeight": string;
            set(property:"defaultHeight", value: string): void;
            get(property:"defaultHeight"): string;
            watch(property:"defaultHeight", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "delayScroll": boolean;
            set(property:"delayScroll", value: boolean): void;
            get(property:"delayScroll"): boolean;
            watch(property:"delayScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * indicates if the grid contains editable cells, default is false
             * set to true if editable cell encountered during rendering
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Override defaults and make the indexed grid view elastic, thus filling available horizontal space.
             * 
             */
            "elasticView": number;
            set(property:"elasticView", value: number): void;
            get(property:"elasticView"): number;
            watch(property:"elasticView", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Message that shows when the grid encounters an error loading
             * 
             */
            "errorMessage": string;
            set(property:"errorMessage", value: string): void;
            get(property:"errorMessage"): string;
            watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This will escape HTML brackets from the data to prevent HTML from
             * user-inputted data being rendered with may contain JavaScript and result in
             * XSS attacks. This is true by default, and it is recommended that it remain
             * true. Setting this to false will allow data to be displayed in the grid without
             * filtering, and should be only used if it is known that the data won't contain
             * malicious scripts. If HTML is needed in grid cells, it is recommended that
             * you use the formatter function to generate the HTML (the output of
             * formatter functions is not filtered, even with escapeHTMLInData set to true).
             * 
             */
            "escapeHTMLInData": boolean;
            set(property:"escapeHTMLInData", value: boolean): void;
            get(property:"escapeHTMLInData"): boolean;
            watch(property:"escapeHTMLInData", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * flag modifies vertical scrolling behavior. Defaults to true but set to false for slower
             * scroll performance but more immediate scrolling feedback
             * 
             */
            "fastScroll": boolean;
            set(property:"fastScroll", value: boolean): void;
            get(property:"fastScroll"): boolean;
            watch(property:"fastScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "fetchText": string;
            set(property:"fetchText", value: string): void;
            get(property:"fetchText"): string;
            watch(property:"fetchText", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An object to execute format functions within.  If not set, the
             * format functions will execute within the scope of the cell that
             * has a format function.
             * 
             */
            "formatterScope": Object;
            set(property:"formatterScope", value: Object): void;
            get(property:"formatterScope"): Object;
            watch(property:"formatterScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If set to a dijit.Menu, will use this as a context menu for the grid headers.
             * 
             */
            "headerMenu": Object;
            set(property:"headerMenu", value: Object): void;
            get(property:"headerMenu"): Object;
            watch(property:"headerMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * explicit height of the grid, measured in any valid css unit.  This will be populated (and overridden)
             * if the height: css attribute exists on the source node.
             * 
             */
            "height": string;
            set(property:"height", value: string): void;
            get(property:"height"): string;
            watch(property:"height", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A css string to use to set our initial width (only used if autoWidth
             * is true).  The first rendering of the grid will be this width, any
             * resizing of columns, etc will result in the grid switching to
             * autoWidth mode.  Note, this width will override any styling in a
             * stylesheet or directly on the node.
             * 
             */
            "initialWidth": string;
            set(property:"initialWidth", value: string): void;
            get(property:"initialWidth"): string;
            watch(property:"initialWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidated": Object;
            set(property:"invalidated", value: Object): void;
            get(property:"invalidated"): Object;
            watch(property:"invalidated", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "items": Object;
            set(property:"items", value: Object): void;
            get(property:"items"): Object;
            watch(property:"items", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Number of rows to keep in the rendering cache.
             * 
             */
            "keepRows": number;
            set(property:"keepRows", value: number): void;
            get(property:"keepRows"): number;
            watch(property:"keepRows", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Whether keep selection after sort, filter etc.
             * 
             */
            "keepSelection": boolean;
            set(property:"keepSelection", value: boolean): void;
            get(property:"keepSelection"): boolean;
            watch(property:"keepSelection", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows while the grid is loading
             * 
             */
            "loadingMessage": string;
            set(property:"loadingMessage", value: string): void;
            get(property:"loadingMessage"): string;
            watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows if the grid has no data - wrap it in a
             * span with class 'dojoxGridNoData' if you want it to be
             * styled similar to the loading and error messages
             * 
             */
            "noDataMessage": string;
            set(property:"noDataMessage", value: string): void;
            get(property:"noDataMessage"): string;
            watch(property:"noDataMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Label of placeholders to search for in the header menu to replace with column toggling
             * menu items.
             * 
             */
            "placeholderLabel": string;
            set(property:"placeholderLabel", value: string): void;
            get(property:"placeholderLabel"): string;
            watch(property:"placeholderLabel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If rowHeight is set to a positive number, it will define the height of the rows
             * in pixels. This can provide a significant performance advantage, since it
             * eliminates the need to measure row sizes during rendering, which is one
             * the primary bottlenecks in the DataGrid's performance.
             * 
             */
            "rowHeight": number;
            set(property:"rowHeight", value: number): void;
            get(property:"rowHeight"): number;
            watch(property:"rowHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If set to true, will add a row selector view to this grid.  If set to a CSS width, will add
             * a row selector of that width to this grid.
             * 
             */
            "rowSelector": boolean;
            set(property:"rowSelector", value: boolean): void;
            get(property:"rowSelector"): boolean;
            watch(property:"rowSelector", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Number of rows to render at a time.
             * 
             */
            "rowsPerPage": number;
            set(property:"rowsPerPage", value: number): void;
            get(property:"rowsPerPage"): number;
            watch(property:"rowsPerPage", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pixel distance a user must scroll vertically to trigger grid scrolling.
             * 
             */
            "scrollRedrawThreshold": number;
            set(property:"scrollRedrawThreshold", value: number): void;
            get(property:"scrollRedrawThreshold"): number;
            watch(property:"scrollRedrawThreshold", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set to true if you want to be able to select the text within the grid.
             * 
             */
            "selectable": boolean;
            set(property:"selectable", value: boolean): void;
            get(property:"selectable"): boolean;
            watch(property:"selectable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set the selection mode of grid's Selection.  Value must be 'single', 'multiple',
             * or 'extended'.  Default is 'extended'.
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Single-click starts editing. Default is double-click
             * 
             */
            "singleClickEdit": boolean;
            set(property:"singleClickEdit", value: boolean): void;
            get(property:"singleClickEdit"): boolean;
            watch(property:"singleClickEdit", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "sortFields": Object;
            set(property:"sortFields", value: Object): void;
            get(property:"sortFields"): Object;
            watch(property:"sortFields", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "sortInfo": number;
            set(property:"sortInfo", value: number): void;
            get(property:"sortInfo"): number;
            watch(property:"sortInfo", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * View layout definition.
             * 
             */
            "structure": Object;
            set(property:"structure", value: Object): void;
            get(property:"structure"): Object;
            watch(property:"structure", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Customizable summary descriptions which will be added to grid.domNode
             * 
             */
            "summary": string;
            set(property:"summary", value: string): void;
            get(property:"summary"): string;
            watch(property:"summary", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Time, in milliseconds, to delay updates automatically so that multiple
             * calls to onSet/onNew/onDelete don't keep rerendering the grid.  Set
             * to 0 to immediately cause updates.  A higher value will result in
             * better performance at the expense of responsiveness of the grid.
             * 
             */
            "updateDelay": number;
            set(property:"updateDelay", value: number): void;
            get(property:"updateDelay"): number;
            watch(property:"updateDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "updating": boolean;
            set(property:"updating", value: boolean): void;
            get(property:"updating"): boolean;
            watch(property:"updating", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add a row to the grid.
             * 
             */
            addRow(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Use to make multiple changes to rows while queueing row updating.
             * 
             */
            beginUpdate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             */
            buildViews(): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            canEdit(inCell: any, inRowIndex: any): any;
            /**
             * 
             */
            canSort(): boolean;
            /**
             * 
             * @param cellFunc             
             * @param node             
             * @param cellDef             
             */
            cell_markupFactory(cellFunc: any, node: any, cellDef: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Creates a new Grid layout
             * 
             */
            createLayout(): void;
            /**
             * create grid managers for various tasks including rows, focus, selection, editing
             * 
             */
            createManagers(): void;
            /**
             * Creates a new virtual scroller
             * 
             */
            createScroller(): void;
            /**
             * 
             */
            createSelection(): void;
            /**
             * 
             * @param inClass             
             * @param idx             
             */
            createView(inClass: any, idx: any): any;
            /**
             * 
             */
            createViews(): void;
            /**
             * 
             */
            defaultUpdate(): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchKeyEvent(e: any): void;
            /**
             * 
             * @param inValue             
             * @param inRowIndex             
             * @param inAttrName             
             */
            doApplyCellEdit(inValue: any, inRowIndex: any, inAttrName: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inDataAttr             
             */
            doApplyEdit(inRowIndex: any, inDataAttr?: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            doCancelEdit(inRowIndex: any): void;
            /**
             * 
             * @param e             
             */
            doclick(e: any): void;
            /**
             * 
             * @param e             
             */
            docontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            dodblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheadercontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderdblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            dokeydown(e: any): void;
            /**
             * 
             * @param e             
             */
            doKeyEvent(e: any): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            doStartEdit(inCell: any, inRowIndex: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Use after calling beginUpdate to render any changes made to rows.
             * 
             */
            endUpdate(): void;
            /**
             * 
             * @param query             
             * @param reRender             
             */
            filter(query: any, reRender: any): void;
            /**
             * 
             */
            finishScrollJob(): void;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Default data getter.
             * Provides data to display in a grid cell. Called in grid cell context.
             * So this.cell.index is the column index.
             * 
             * @param inRowIndex Row for which to provide data             
             * @param inItem             
             */
            get(inRowIndex: number, inItem: any): any;
            /**
             * Retrieves the cell object for a given grid column.
             * 
             * @param inIndex Grid column index of cell to retrieve             
             */
            getCell(inIndex: number): any;
            /**
             * 
             * @param inCell             
             */
            getCellName(inCell: any): any;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             */
            getCellNodeTextDirection(inColIndex: any, inRowIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * returns an array of dijit.CheckedMenuItem widgets that can be
             * added to a menu for toggling columns on and off.
             * 
             */
            getColumnTogglingItems(): any;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param idx             
             */
            getItem(idx: any): any;
            /**
             * 
             * @param item             
             */
            getItemIndex(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * find the rowNode that is not a rowSelector
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * Returns true if grid is sorted in an ascending direction.
             * 
             * @param inSortInfo             
             */
            getSortAsc(inSortInfo: any): any;
            /**
             * Returns the index of the column on which the grid is sorted
             * 
             * @param inSortInfo             
             */
            getSortIndex(inSortInfo: any): number;
            /**
             * 
             */
            getSortProps(): any;
            /**
             * 
             */
            hasLayout(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param props             
             * @param node             
             * @param ctor             
             * @param cellFunc             
             */
            markupFactory(props: any, node: any, ctor: any, cellFunc: any): void;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postrender(): void;
            /**
             * 
             */
            postresize(): void;
            /**
             * 
             */
            prerender(): void;
            /**
             * Remove the selected rows from the grid.
             * 
             */
            removeSelectedRows(): void;
            /**
             * Render the grid, headers, and views. Edit and scrolling states are reset. To retain edit and
             * scrolling states, see Update.
             * 
             */
            render(): void;
            /**
             * Update the grid's rendering dimensions and resize it
             * 
             * @param changeSize             
             * @param resultSize             
             */
            resize(changeSize: any, resultSize: any): void;
            /**
             * Update grid when the height of a row has changed. Row height is handled automatically as rows
             * are rendered. Use this function only to update a row's height outside the normal rendering process.
             * 
             * @param inRowIndex index of the row that has changed height             
             */
            rowHeightChanged(inRowIndex: number): void;
            /**
             * Vertically scroll the grid to a given pixel position
             * 
             * @param inTop vertical position of the grid in pixels             
             */
            scrollTo(inTop: number): void;
            /**
             * Scroll the grid to a specific row.
             * 
             * @param inRowIndex grid row index             
             */
            scrollToRow(inRowIndex: number): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             * @param textDir             
             */
            setCellNodeTextDirection(inColIndex: any, inRowIndex: any, textDir: any): void;
            /**
             * 
             * @param inIndex             
             * @param inUnitWidth             
             */
            setCellWidth(inIndex: any, inUnitWidth: any): void;
            /**
             * 
             * @param menu             
             */
            setHeaderMenu(menu: dijit.Menu): void;
            /**
             * 
             * @param items             
             */
            setItems(items: any): void;
            /**
             * 
             * @param query             
             * @param queryOptions             
             */
            setQuery(query: any, queryOptions: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): void;
            /**
             * Sort the grid on a column in a specified direction
             * 
             * @param inIndex Column index on which to sort.             
             * @param inAsc If true, sort the grid in ascending order, otherwise in descending order             
             */
            setSortIndex(inIndex: number, inAsc: boolean): void;
            /**
             * 
             * @param inSortInfo             
             */
            setSortInfo(inSortInfo: any): void;
            /**
             * 
             * @param store             
             * @param query             
             * @param queryOptions             
             */
            setStore(store: any, query: any, queryOptions: any): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure:  Object[] ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object[][]): void;
            /**
             * 
             */
            setupHeaderMenu(): void;
            /**
             * 
             * @param message             
             */
            showMessage(message: any): void;
            /**
             * 
             */
            sizeChange(): void;
            /**
             * 
             */
            sort(): void;
            /**
             * 
             */
            startup(): void;
            /**
             * Perform row styling
             * 
             * @param inRow             
             */
            styleRowState(inRow: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            textSizeChanged(): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Update the grid, retaining edit and scrolling states.
             * 
             */
            update(): void;
            /**
             * Render a single row.
             * 
             * @param inRowIndex Index of the row to render             
             */
            updateRow(inRowIndex: number): void;
            /**
             * Change the number of rows.
             * 
             * @param inRowCount Number of rows in the grid.             
             */
            updateRowCount(inRowCount: number): void;
            /**
             * Render consecutive rows at once.
             * 
             * @param startIndex Index of the starting row to render             
             * @param howMany How many rows to update.             
             */
            updateRows(startIndex: number, howMany: number): void;
            /**
             * Update the styles for a row after it's state has changed.
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Event fired when editing is applied for a given grid cell
             * 
             * @param inValue Value from cell editor             
             * @param inRowIndex Index of the grid row             
             * @param inFieldIndex Index in the grid's data store             
             */
            onApplyCellEdit(inValue: String, inRowIndex: number, inFieldIndex: number): void;
            /**
             * Event fired when editing is applied for a given grid row
             * 
             * @param inRowIndex Index of the grid row             
             */
            onApplyEdit(inRowIndex: number): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Event fired when editing is cancelled for a given grid cell
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCancelEdit(inRowIndex: number): void;
            /**
             * Event to determine if a grid row may be deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanDeselect(inRowIndex: number): any;
            /**
             * Event to determine if a grid row may be selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanSelect(inRowIndex: number): any;
            /**
             * Event fired when a cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellClick(e: Event): void;
            /**
             * Event fired when a cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellContextMenu(e: Event): void;
            /**
             * Event fired when a cell is double-clicked.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellDblClick(e: Event): void;
            /**
             * Event fired when a cell receives focus.
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onCellFocus(inCell: Object, inRowIndex: number): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse is over a cell.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOver(e: Event): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Top level handler for Content events
             * 
             * @param e             
             */
            onContentEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Event fired when a grid row is deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onDeselected(inRowIndex: number): void;
            /**
             * 
             * @param err             
             * @param req             
             */
            onFetchError(err: any, req: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event fired when a header cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellClick(e: Event): void;
            /**
             * Event fired when a header cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellContextMenu(e: Event): void;
            /**
             * Event fired when a header cell is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOver(e: Event): void;
            /**
             * Event fired when the grid header is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderClick(e: Event): void;
            /**
             * Event fired when the grid header context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderContextMenu(e: Event): void;
            /**
             * Event fired when the grid header is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderDblClick(e: Event): void;
            /**
             * Top level handler for header events
             * 
             * @param e             
             */
            onHeaderEvent(e: any): void;
            /**
             * Event fired when mouse moves out of the grid header.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over the grid header.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOver(e: Event): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * top level handler for Key Events
             * 
             * @param e             
             */
            onKeyEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Event fired when mouse is down inside grid row
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDownRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Event fired when mouse moves out of any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOutRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Event fired when mouse is over any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOverRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * 
             */
            onMoveColumn(): void;
            /**
             * 
             * @param cellIdx             
             */
            onResizeColumn(cellIdx: number): void;
            /**
             * Event fired when a row is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowClick(e: Event): void;
            /**
             * Event fired when a row context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowContextMenu(e: Event): void;
            /**
             * Event fired when a row is double clicked.
             * 
             * @param e decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a data row.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a data row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOver(e: Event): void;
            /**
             * Event fired when a grid row is selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onSelected(inRowIndex: number): void;
            /**
             * 
             */
            onSelectionChanged(): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
            /**
             * Event fired when editing is started for a given grid cell
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onStartEdit(inCell: Object, inRowIndex: number): void;
            /**
             * 
             * @param inRow             
             */
            onStyleRow(inRow: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/EnhancedGrid.html
         *
         * Provides enhanced features based on DataGrid
         * EnhancedGrid features are implemented as plugins that could be loaded on demand.
         * Explicit dojo.require() is needed to use these feature plugins.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class EnhancedGrid extends dojox.grid.DataGrid {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If autoHeight is true, grid height is automatically set to fit the data.
             * If it is an integer, the height will be automatically set to fit the data
             * if there are fewer than that many rows - and the height will be set to show
             * that many rows if there are more
             * 
             */
            "autoHeight": boolean;
            set(property:"autoHeight", value: boolean): void;
            get(property:"autoHeight"): boolean;
            watch(property:"autoHeight", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoRender is true, grid will render itself after initialization.
             * 
             */
            "autoRender": boolean;
            set(property:"autoRender", value: boolean): void;
            get(property:"autoRender"): boolean;
            watch(property:"autoRender", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoWidth is true, grid width is automatically set to fit the data.
             * 
             */
            "autoWidth": boolean;
            set(property:"autoWidth", value: boolean): void;
            get(property:"autoWidth"): boolean;
            watch(property:"autoWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * css class to apply to grid cells over which the cursor is placed.
             * 
             */
            "cellOverClass": string;
            set(property:"cellOverClass", value: string): void;
            get(property:"cellOverClass"): string;
            watch(property:"cellOverClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * CSS class applied to the grid's domNode
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * If set to true, will add drag and drop reordering to views with one row of columns.
             * 
             */
            "columnReordering": boolean;
            set(property:"columnReordering", value: boolean): void;
            get(property:"columnReordering"): boolean;
            watch(property:"columnReordering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * default height of the grid, measured in any valid css unit.
             * 
             */
            "defaultHeight": string;
            set(property:"defaultHeight", value: string): void;
            get(property:"defaultHeight"): string;
            watch(property:"defaultHeight", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "delayScroll": boolean;
            set(property:"delayScroll", value: boolean): void;
            get(property:"delayScroll"): boolean;
            watch(property:"delayScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * indicates if the grid contains editable cells, default is false
             * set to true if editable cell encountered during rendering
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Override defaults and make the indexed grid view elastic, thus filling available horizontal space.
             * 
             */
            "elasticView": number;
            set(property:"elasticView", value: number): void;
            get(property:"elasticView"): number;
            watch(property:"elasticView", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Message that shows when the grid encounters an error loading
             * 
             */
            "errorMessage": string;
            set(property:"errorMessage", value: string): void;
            get(property:"errorMessage"): string;
            watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This will escape HTML brackets from the data to prevent HTML from
             * user-inputted data being rendered with may contain JavaScript and result in
             * XSS attacks. This is true by default, and it is recommended that it remain
             * true. Setting this to false will allow data to be displayed in the grid without
             * filtering, and should be only used if it is known that the data won't contain
             * malicious scripts. If HTML is needed in grid cells, it is recommended that
             * you use the formatter function to generate the HTML (the output of
             * formatter functions is not filtered, even with escapeHTMLInData set to true).
             * 
             */
            "escapeHTMLInData": boolean;
            set(property:"escapeHTMLInData", value: boolean): void;
            get(property:"escapeHTMLInData"): boolean;
            watch(property:"escapeHTMLInData", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * flag modifies vertical scrolling behavior. Defaults to true but set to false for slower
             * scroll performance but more immediate scrolling feedback
             * 
             */
            "fastScroll": boolean;
            set(property:"fastScroll", value: boolean): void;
            get(property:"fastScroll"): boolean;
            watch(property:"fastScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "fetchText": string;
            set(property:"fetchText", value: string): void;
            get(property:"fetchText"): string;
            watch(property:"fetchText", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An object to execute format functions within.  If not set, the
             * format functions will execute within the scope of the cell that
             * has a format function.
             * 
             */
            "formatterScope": Object;
            set(property:"formatterScope", value: Object): void;
            get(property:"formatterScope"): Object;
            watch(property:"formatterScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If set to a dijit.Menu, will use this as a context menu for the grid headers.
             * 
             */
            "headerMenu": Object;
            set(property:"headerMenu", value: Object): void;
            get(property:"headerMenu"): Object;
            watch(property:"headerMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * explicit height of the grid, measured in any valid css unit.  This will be populated (and overridden)
             * if the height: css attribute exists on the source node.
             * 
             */
            "height": string;
            set(property:"height", value: string): void;
            get(property:"height"): string;
            watch(property:"height", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A css string to use to set our initial width (only used if autoWidth
             * is true).  The first rendering of the grid will be this width, any
             * resizing of columns, etc will result in the grid switching to
             * autoWidth mode.  Note, this width will override any styling in a
             * stylesheet or directly on the node.
             * 
             */
            "initialWidth": string;
            set(property:"initialWidth", value: string): void;
            get(property:"initialWidth"): string;
            watch(property:"initialWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidated": Object;
            set(property:"invalidated", value: Object): void;
            get(property:"invalidated"): Object;
            watch(property:"invalidated", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "items": Object;
            set(property:"items", value: Object): void;
            get(property:"items"): Object;
            watch(property:"items", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Number of rows to keep in the rendering cache.
             * 
             */
            "keepRows": number;
            set(property:"keepRows", value: number): void;
            get(property:"keepRows"): number;
            watch(property:"keepRows", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Whether keep selection after sort, filter etc.
             * 
             */
            "keepSelection": boolean;
            set(property:"keepSelection", value: boolean): void;
            get(property:"keepSelection"): boolean;
            watch(property:"keepSelection", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows while the grid is loading
             * 
             */
            "loadingMessage": string;
            set(property:"loadingMessage", value: string): void;
            get(property:"loadingMessage"): string;
            watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows if the grid has no data - wrap it in a
             * span with class 'dojoxGridNoData' if you want it to be
             * styled similar to the loading and error messages
             * 
             */
            "noDataMessage": string;
            set(property:"noDataMessage", value: string): void;
            get(property:"noDataMessage"): string;
            watch(property:"noDataMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Label of placeholders to search for in the header menu to replace with column toggling
             * menu items.
             * 
             */
            "placeholderLabel": string;
            set(property:"placeholderLabel", value: string): void;
            get(property:"placeholderLabel"): string;
            watch(property:"placeholderLabel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Singleton plugin manager
             * 
             */
            "pluginMgr": Object;
            set(property:"pluginMgr", value: Object): void;
            get(property:"pluginMgr"): Object;
            watch(property:"pluginMgr", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Plugin properties, e.g. {nestedSorting: true, dnd: true, ...}
             * 
             */
            "plugins": Object;
            set(property:"plugins", value: Object): void;
            get(property:"plugins"): Object;
            watch(property:"plugins", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If rowHeight is set to a positive number, it will define the height of the rows
             * in pixels. This can provide a significant performance advantage, since it
             * eliminates the need to measure row sizes during rendering, which is one
             * the primary bottlenecks in the DataGrid's performance.
             * 
             */
            "rowHeight": number;
            set(property:"rowHeight", value: number): void;
            get(property:"rowHeight"): number;
            watch(property:"rowHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If set to true, will add a row selector view to this grid.  If set to a CSS width, will add
             * a row selector of that width to this grid.
             * 
             */
            "rowSelector": boolean;
            set(property:"rowSelector", value: boolean): void;
            get(property:"rowSelector"): boolean;
            watch(property:"rowSelector", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Number of rows to render at a time.
             * 
             */
            "rowsPerPage": number;
            set(property:"rowsPerPage", value: number): void;
            get(property:"rowsPerPage"): number;
            watch(property:"rowsPerPage", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pixel distance a user must scroll vertically to trigger grid scrolling.
             * 
             */
            "scrollRedrawThreshold": number;
            set(property:"scrollRedrawThreshold", value: number): void;
            get(property:"scrollRedrawThreshold"): number;
            watch(property:"scrollRedrawThreshold", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set to true if you want to be able to select the text within the grid.
             * 
             */
            "selectable": boolean;
            set(property:"selectable", value: boolean): void;
            get(property:"selectable"): boolean;
            watch(property:"selectable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set the selection mode of grid's Selection.  Value must be 'single', 'multiple',
             * or 'extended'.  Default is 'extended'.
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Single-click starts editing. Default is double-click
             * 
             */
            "singleClickEdit": boolean;
            set(property:"singleClickEdit", value: boolean): void;
            get(property:"singleClickEdit"): boolean;
            watch(property:"singleClickEdit", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "sortFields": Object;
            set(property:"sortFields", value: Object): void;
            get(property:"sortFields"): Object;
            watch(property:"sortFields", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "sortInfo": number;
            set(property:"sortInfo", value: number): void;
            get(property:"sortInfo"): number;
            watch(property:"sortInfo", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * View layout definition.
             * 
             */
            "structure": Object;
            set(property:"structure", value: Object): void;
            get(property:"structure"): Object;
            watch(property:"structure", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Customizable summary descriptions which will be added to grid.domNode
             * 
             */
            "summary": string;
            set(property:"summary", value: string): void;
            get(property:"summary"): string;
            watch(property:"summary", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Time, in milliseconds, to delay updates automatically so that multiple
             * calls to onSet/onNew/onDelete don't keep rerendering the grid.  Set
             * to 0 to immediately cause updates.  A higher value will result in
             * better performance at the expense of responsiveness of the grid.
             * 
             */
            "updateDelay": number;
            set(property:"updateDelay", value: number): void;
            get(property:"updateDelay"): number;
            watch(property:"updateDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "updating": boolean;
            set(property:"updating", value: boolean): void;
            get(property:"updating"): boolean;
            watch(property:"updating", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add a row to the grid.
             * 
             */
            addRow(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Use to make multiple changes to rows while queueing row updating.
             * 
             */
            beginUpdate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             */
            buildViews(): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            canEdit(inCell: any, inRowIndex: any): any;
            /**
             * Overwritten
             * 
             * @param colIndex             
             * @param field             
             */
            canSort(colIndex?: any, field?: any): boolean;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Creates a new Grid layout
             * 
             */
            createLayout(): void;
            /**
             * create grid managers for various tasks including rows, focus, selection, editing
             * 
             */
            createManagers(): void;
            /**
             * Creates a new virtual scroller
             * 
             */
            createScroller(): void;
            /**
             * 
             */
            createSelection(): void;
            /**
             * Overwrite: rewrite getCellX of view.header
             * 
             */
            createView(): any;
            /**
             * 
             */
            createViews(): void;
            /**
             * 
             */
            defaultUpdate(): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * Destroy all resources
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchKeyEvent(e: any): void;
            /**
             * Overwritten, see DataGrid.doApplyCellEdit()
             * 
             * @param inValue             
             * @param inRowIndex             
             * @param inAttrName             
             */
            doApplyCellEdit(inValue: any, inRowIndex: any, inAttrName: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inDataAttr             
             */
            doApplyEdit(inRowIndex: any, inDataAttr: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            doCancelEdit(inRowIndex: any): void;
            /**
             * 
             * @param e             
             */
            doclick(e: any): void;
            /**
             * 
             * @param e             
             */
            docontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            dodblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheadercontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderdblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            dokeydown(e: any): void;
            /**
             * Overwritten, see _Grid.doKeyEvent()
             * 
             * @param e             
             */
            doKeyEvent(e: any): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            doStartEdit(inCell: any, inRowIndex: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Use after calling beginUpdate to render any changes made to rows.
             * 
             */
            endUpdate(): void;
            /**
             * 
             * @param query             
             * @param reRender             
             */
            filter(query: any, reRender: any): void;
            /**
             * 
             */
            finishScrollJob(): void;
            /**
             * Default data getter.
             * Provides data to display in a grid cell. Called in grid cell context.
             * So this.cell.index is the column index.
             * 
             * @param inRowIndex Row for which to provide data             
             * @param inItem             
             */
            get(inRowIndex: number, inItem: any): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Retrieves the cell object for a given grid column.
             * 
             * @param inIndex Grid column index of cell to retrieve             
             */
            getCell(inIndex: number): any;
            /**
             * 
             * @param field             
             */
            getCellByField(field: any): any;
            /**
             * 
             * @param inCell             
             */
            getCellName(inCell: any): any;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             */
            getCellNodeTextDirection(inColIndex: any, inRowIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * returns an array of dijit.CheckedMenuItem widgets that can be
             * added to a menu for toggling columns on and off.
             * 
             */
            getColumnTogglingItems(): any;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * 
             * @param idx             
             */
            getItem(idx: any): any;
            /**
             * 
             * @param item             
             */
            getItemIndex(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * find the rowNode that is not a rowSelector
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * Returns true if grid is sorted in an ascending direction.
             * 
             * @param inSortInfo             
             */
            getSortAsc(inSortInfo: any): any;
            /**
             * Returns the index of the column on which the grid is sorted
             * 
             * @param inSortInfo             
             */
            getSortIndex(inSortInfo: any): number;
            /**
             * 
             */
            getSortProps(): any;
            /**
             * 
             */
            hasLayout(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param props             
             * @param node             
             * @param ctor             
             * @param cellFunc             
             */
            markupFactory(props: any, node: any, ctor: any, cellFunc: any): void;
            /**
             * 
             * @param target             
             * @param source             
             */
            mixin(target: any, source: any): void;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * An easier way for getting a plugin, e.g. grid.plugin('dnd')
             * 
             * @param name             
             */
            plugin(name: String): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postrender(): void;
            /**
             * 
             */
            postresize(): void;
            /**
             * 
             */
            prerender(): void;
            /**
             * 
             * @param clazz             
             * @param props             
             */
            registerPlugin(clazz: any, props: any): void;
            /**
             * Remove the selected rows from the grid.
             * 
             */
            removeSelectedRows(): void;
            /**
             * Render the grid, headers, and views. Edit and scrolling states are reset. To retain edit and
             * scrolling states, see Update.
             * 
             */
            render(): void;
            /**
             * Update the grid's rendering dimensions and resize it
             * 
             * @param changeSize             
             * @param resultSize             
             */
            resize(changeSize: any, resultSize: any): void;
            /**
             * Update grid when the height of a row has changed. Row height is handled automatically as rows
             * are rendered. Use this function only to update a row's height outside the normal rendering process.
             * 
             * @param inRowIndex index of the row that has changed height             
             */
            rowHeightChanged(inRowIndex: number): void;
            /**
             * Vertically scroll the grid to a given pixel position
             * 
             * @param inTop vertical position of the grid in pixels             
             */
            scrollTo(inTop: number): void;
            /**
             * Scroll the grid to a specific row.
             * 
             * @param inRowIndex grid row index             
             */
            scrollToRow(inRowIndex: number): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             * @param textDir             
             */
            setCellNodeTextDirection(inColIndex: any, inRowIndex: any, textDir: any): void;
            /**
             * 
             * @param inIndex             
             * @param inUnitWidth             
             */
            setCellWidth(inIndex: any, inUnitWidth: any): void;
            /**
             * 
             * @param menu             
             */
            setHeaderMenu(menu: dijit.Menu): void;
            /**
             * 
             * @param items             
             */
            setItems(items: any): void;
            /**
             * 
             * @param query             
             * @param queryOptions             
             */
            setQuery(query: any, queryOptions: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): void;
            /**
             * Sort the grid on a column in a specified direction
             * 
             * @param inIndex Column index on which to sort.             
             * @param inAsc If true, sort the grid in ascending order, otherwise in descending order             
             */
            setSortIndex(inIndex: number, inAsc: boolean): void;
            /**
             * 
             * @param inSortInfo             
             */
            setSortInfo(inSortInfo: any): void;
            /**
             * 
             * @param store             
             * @param query             
             * @param queryOptions             
             */
            setStore(store: any, query: any, queryOptions: any): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure:  Object[] ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object[][]): void;
            /**
             * 
             */
            setupHeaderMenu(): void;
            /**
             * 
             * @param message             
             */
            showMessage(message: any): void;
            /**
             * 
             */
            sizeChange(): void;
            /**
             * 
             */
            sort(): void;
            /**
             * 
             */
            startup(): void;
            /**
             * Perform row styling
             * 
             * @param inRow             
             */
            styleRowState(inRow: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            textSizeChanged(): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Update the grid, retaining edit and scrolling states.
             * 
             */
            update(): void;
            /**
             * Render a single row.
             * 
             * @param inRowIndex Index of the row to render             
             */
            updateRow(inRowIndex: number): void;
            /**
             * Change the number of rows.
             * 
             * @param inRowCount Number of rows in the grid.             
             */
            updateRowCount(inRowCount: number): void;
            /**
             * Render consecutive rows at once.
             * 
             * @param startIndex Index of the starting row to render             
             * @param howMany How many rows to update.             
             */
            updateRows(startIndex: number, howMany: number): void;
            /**
             * Update the styles for a row after it's state has changed.
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Event fired when editing is applied for a given grid cell
             * 
             * @param inValue Value from cell editor             
             * @param inRowIndex Index of the grid row             
             * @param inFieldIndex Index in the grid's data store             
             */
            onApplyCellEdit(inValue: String, inRowIndex: number, inFieldIndex: number): void;
            /**
             * Event fired when editing is applied for a given grid row
             * 
             * @param inRowIndex Index of the grid row             
             */
            onApplyEdit(inRowIndex: number): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Event fired when editing is cancelled for a given grid cell
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCancelEdit(inRowIndex: number): void;
            /**
             * Event to determine if a grid row may be deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanDeselect(inRowIndex: number): any;
            /**
             * Event to determine if a grid row may be selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanSelect(inRowIndex: number): any;
            /**
             * Event fired when a cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellClick(e: Event): void;
            /**
             * Event fired when a cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellContextMenu(e: Event): void;
            /**
             * Event fired when a cell is double-clicked.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellDblClick(e: Event): void;
            /**
             * Event fired when a cell receives focus.
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onCellFocus(inCell: Object, inRowIndex: number): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse is over a cell.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOver(e: Event): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Top level handler for Content events
             * 
             * @param e             
             */
            onContentEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Event fired when a grid row is deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onDeselected(inRowIndex: number): void;
            /**
             * 
             * @param err             
             * @param req             
             */
            onFetchError(err: any, req: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event fired when a header cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellClick(e: Event): void;
            /**
             * Event fired when a header cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellContextMenu(e: Event): void;
            /**
             * Event fired when a header cell is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOver(e: Event): void;
            /**
             * Event fired when the grid header is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderClick(e: Event): void;
            /**
             * Event fired when the grid header context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderContextMenu(e: Event): void;
            /**
             * Event fired when the grid header is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderDblClick(e: Event): void;
            /**
             * Top level handler for header events
             * 
             * @param e             
             */
            onHeaderEvent(e: any): void;
            /**
             * Event fired when mouse moves out of the grid header.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over the grid header.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOver(e: Event): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * Connect to this function to receive notifications of keys being pressed down.
             * 
             * @param event key Event             
             */
            onKeyDown(event: any): void;
            /**
             * top level handler for Key Events
             * 
             * @param e             
             */
            onKeyEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Event fired when mouse is down inside grid row
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDownRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Event fired when mouse moves out of any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOutRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Event fired when mouse is over any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOverRow(e: Event): void;
            /**
             * 
             * @param e             
             */
            onMouseUp(e: any): void;
            /**
             * 
             */
            onMoveColumn(): void;
            /**
             * 
             * @param cellIdx             
             */
            onResizeColumn(cellIdx: number): void;
            /**
             * Event fired when a row is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowClick(e: Event): void;
            /**
             * Event fired when a row context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowContextMenu(e: Event): void;
            /**
             * Event fired when a row is double clicked.
             * 
             * @param e decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a data row.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a data row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOver(e: Event): void;
            /**
             * Event fired when a grid row is selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onSelected(inRowIndex: number): void;
            /**
             * 
             */
            onSelectionChanged(): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
            /**
             * Event fired when editing is started for a given grid cell
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onStartEdit(inCell: Object, inRowIndex: number): void;
            /**
             * 
             * @param inRow             
             */
            onStyleRow(inRow: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/TreeGrid.html
         *
         * A grid that supports nesting rows - it provides an expando function
         * similar to dijit.Tree.  It also provides mechanisms for aggregating
         * the values of subrows
         * TreeGrid currently only works on "simple" structures.  That is,
         * single-view structures with a single row in them.
         * 
         * The TreeGrid works using the concept of "levels" - level 0 are the
         * top-level items.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class TreeGrid extends dojox.grid.DataGrid {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * The aggregator class - it will be populated automatically if we
             * are a collapsible grid
             * 
             */
            "aggregator": Object;
            set(property:"aggregator", value: Object): void;
            get(property:"aggregator"): Object;
            watch(property:"aggregator", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If autoHeight is true, grid height is automatically set to fit the data.
             * If it is an integer, the height will be automatically set to fit the data
             * if there are fewer than that many rows - and the height will be set to show
             * that many rows if there are more
             * 
             */
            "autoHeight": boolean;
            set(property:"autoHeight", value: boolean): void;
            get(property:"autoHeight"): boolean;
            watch(property:"autoHeight", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoRender is true, grid will render itself after initialization.
             * 
             */
            "autoRender": boolean;
            set(property:"autoRender", value: boolean): void;
            get(property:"autoRender"): boolean;
            watch(property:"autoRender", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoWidth is true, grid width is automatically set to fit the data.
             * 
             */
            "autoWidth": boolean;
            set(property:"autoWidth", value: boolean): void;
            get(property:"autoWidth"): boolean;
            watch(property:"autoWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * css class to apply to grid cells over which the cursor is placed.
             * 
             */
            "cellOverClass": string;
            set(property:"cellOverClass", value: string): void;
            get(property:"cellOverClass"): string;
            watch(property:"cellOverClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * CSS class applied to the grid's domNode
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * If set to true, will add drag and drop reordering to views with one row of columns.
             * 
             */
            "columnReordering": boolean;
            set(property:"columnReordering", value: boolean): void;
            get(property:"columnReordering"): boolean;
            watch(property:"columnReordering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * default height of the grid, measured in any valid css unit.
             * 
             */
            "defaultHeight": string;
            set(property:"defaultHeight", value: string): void;
            get(property:"defaultHeight"): string;
            watch(property:"defaultHeight", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether or not we default to open (all levels).  This defaults to
             * false for grids with a treeModel.
             * 
             */
            "defaultOpen": boolean;
            set(property:"defaultOpen", value: boolean): void;
            get(property:"defaultOpen"): boolean;
            watch(property:"defaultOpen", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "delayScroll": boolean;
            set(property:"delayScroll", value: boolean): void;
            get(property:"delayScroll"): boolean;
            watch(property:"delayScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * indicates if the grid contains editable cells, default is false
             * set to true if editable cell encountered during rendering
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Override defaults and make the indexed grid view elastic, thus filling available horizontal space.
             * 
             */
            "elasticView": number;
            set(property:"elasticView", value: number): void;
            get(property:"elasticView"): number;
            watch(property:"elasticView", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Message that shows when the grid encounters an error loading
             * 
             */
            "errorMessage": string;
            set(property:"errorMessage", value: string): void;
            get(property:"errorMessage"): string;
            watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This will escape HTML brackets from the data to prevent HTML from
             * user-inputted data being rendered with may contain JavaScript and result in
             * XSS attacks. This is true by default, and it is recommended that it remain
             * true. Setting this to false will allow data to be displayed in the grid without
             * filtering, and should be only used if it is known that the data won't contain
             * malicious scripts. If HTML is needed in grid cells, it is recommended that
             * you use the formatter function to generate the HTML (the output of
             * formatter functions is not filtered, even with escapeHTMLInData set to true).
             * 
             */
            "escapeHTMLInData": boolean;
            set(property:"escapeHTMLInData", value: boolean): void;
            get(property:"escapeHTMLInData"): boolean;
            watch(property:"escapeHTMLInData", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * When used in conjunction with a treeModel (see above), this is a 0-based
             * index of the cell in which to place the actual expando
             * 
             */
            "expandoCell": number;
            set(property:"expandoCell", value: number): void;
            get(property:"expandoCell"): number;
            watch(property:"expandoCell", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * flag modifies vertical scrolling behavior. Defaults to true but set to false for slower
             * scroll performance but more immediate scrolling feedback
             * 
             */
            "fastScroll": boolean;
            set(property:"fastScroll", value: boolean): void;
            get(property:"fastScroll"): boolean;
            watch(property:"fastScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "fetchText": string;
            set(property:"fetchText", value: string): void;
            get(property:"fetchText"): string;
            watch(property:"fetchText", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An object to execute format functions within.  If not set, the
             * format functions will execute within the scope of the cell that
             * has a format function.
             * 
             */
            "formatterScope": Object;
            set(property:"formatterScope", value: Object): void;
            get(property:"formatterScope"): Object;
            watch(property:"formatterScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If set to a dijit.Menu, will use this as a context menu for the grid headers.
             * 
             */
            "headerMenu": Object;
            set(property:"headerMenu", value: Object): void;
            get(property:"headerMenu"): Object;
            watch(property:"headerMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * explicit height of the grid, measured in any valid css unit.  This will be populated (and overridden)
             * if the height: css attribute exists on the source node.
             * 
             */
            "height": string;
            set(property:"height", value: string): void;
            get(property:"height"): string;
            watch(property:"height", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A css string to use to set our initial width (only used if autoWidth
             * is true).  The first rendering of the grid will be this width, any
             * resizing of columns, etc will result in the grid switching to
             * autoWidth mode.  Note, this width will override any styling in a
             * stylesheet or directly on the node.
             * 
             */
            "initialWidth": string;
            set(property:"initialWidth", value: string): void;
            get(property:"initialWidth"): string;
            watch(property:"initialWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidated": Object;
            set(property:"invalidated", value: Object): void;
            get(property:"invalidated"): Object;
            watch(property:"invalidated", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "items": Object;
            set(property:"items", value: Object): void;
            get(property:"items"): Object;
            watch(property:"items", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Number of rows to keep in the rendering cache.
             * 
             */
            "keepRows": number;
            set(property:"keepRows", value: number): void;
            get(property:"keepRows"): number;
            watch(property:"keepRows", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Whether keep selection after sort, filter etc.
             * 
             */
            "keepSelection": boolean;
            set(property:"keepSelection", value: boolean): void;
            get(property:"keepSelection"): boolean;
            watch(property:"keepSelection", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows while the grid is loading
             * 
             */
            "loadingMessage": string;
            set(property:"loadingMessage", value: string): void;
            get(property:"loadingMessage"): string;
            watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows if the grid has no data - wrap it in a
             * span with class 'dojoxGridNoData' if you want it to be
             * styled similar to the loading and error messages
             * 
             */
            "noDataMessage": string;
            set(property:"noDataMessage", value: string): void;
            get(property:"noDataMessage"): string;
            watch(property:"noDataMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Which levels we are open at (overrides defaultOpen for the values
             * that exist here).  Its values can be a boolean (true/false) or an
             * integer (for the # of children to be closed if there are more than
             * that)
             * 
             */
            "openAtLevels": any[];
            set(property:"openAtLevels", value: any[]): void;
            get(property:"openAtLevels"): any[];
            watch(property:"openAtLevels", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Label of placeholders to search for in the header menu to replace with column toggling
             * menu items.
             * 
             */
            "placeholderLabel": string;
            set(property:"placeholderLabel", value: string): void;
            get(property:"placeholderLabel"): string;
            watch(property:"placeholderLabel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If rowHeight is set to a positive number, it will define the height of the rows
             * in pixels. This can provide a significant performance advantage, since it
             * eliminates the need to measure row sizes during rendering, which is one
             * the primary bottlenecks in the DataGrid's performance.
             * 
             */
            "rowHeight": number;
            set(property:"rowHeight", value: number): void;
            get(property:"rowHeight"): number;
            watch(property:"rowHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If set to true, will add a row selector view to this grid.  If set to a CSS width, will add
             * a row selector of that width to this grid.
             * 
             */
            "rowSelector": boolean;
            set(property:"rowSelector", value: boolean): void;
            get(property:"rowSelector"): boolean;
            watch(property:"rowSelector", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Number of rows to render at a time.
             * 
             */
            "rowsPerPage": number;
            set(property:"rowsPerPage", value: number): void;
            get(property:"rowsPerPage"): number;
            watch(property:"rowsPerPage", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pixel distance a user must scroll vertically to trigger grid scrolling.
             * 
             */
            "scrollRedrawThreshold": number;
            set(property:"scrollRedrawThreshold", value: number): void;
            get(property:"scrollRedrawThreshold"): number;
            watch(property:"scrollRedrawThreshold", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set to true if you want to be able to select the text within the grid.
             * 
             */
            "selectable": boolean;
            set(property:"selectable", value: boolean): void;
            get(property:"selectable"): boolean;
            watch(property:"selectable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set the selection mode of grid's Selection.  Value must be 'single', 'multiple',
             * or 'extended'.  Default is 'extended'.
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Single-click starts editing. Default is double-click
             * 
             */
            "singleClickEdit": boolean;
            set(property:"singleClickEdit", value: boolean): void;
            get(property:"singleClickEdit"): boolean;
            watch(property:"singleClickEdit", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If true, child items will be returned sorted according to the sorting
             * properties of the grid.
             * 
             */
            "sortChildItems": boolean;
            set(property:"sortChildItems", value: boolean): void;
            get(property:"sortChildItems"): boolean;
            watch(property:"sortChildItems", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "sortFields": Object;
            set(property:"sortFields", value: Object): void;
            get(property:"sortFields"): Object;
            watch(property:"sortFields", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "sortInfo": number;
            set(property:"sortInfo", value: number): void;
            get(property:"sortInfo"): number;
            watch(property:"sortInfo", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * View layout definition.
             * 
             */
            "structure": Object;
            set(property:"structure", value: Object): void;
            get(property:"structure"): Object;
            watch(property:"structure", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Customizable summary descriptions which will be added to grid.domNode
             * 
             */
            "summary": string;
            set(property:"summary", value: string): void;
            get(property:"summary"): string;
            watch(property:"summary", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A dijit.Tree model that will be used instead of using aggregates.
             * Setting this value will make the TreeGrid behave like a columnar
             * tree.  When setting this value, defaultOpen will default to false,
             * and openAtLevels will be ignored.
             * 
             */
            "treeModel": Object;
            set(property:"treeModel", value: Object): void;
            get(property:"treeModel"): Object;
            watch(property:"treeModel", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Time, in milliseconds, to delay updates automatically so that multiple
             * calls to onSet/onNew/onDelete don't keep rerendering the grid.  Set
             * to 0 to immediately cause updates.  A higher value will result in
             * better performance at the expense of responsiveness of the grid.
             * 
             */
            "updateDelay": number;
            set(property:"updateDelay", value: number): void;
            get(property:"updateDelay"): number;
            watch(property:"updateDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "updating": boolean;
            set(property:"updating", value: boolean): void;
            get(property:"updating"): boolean;
            watch(property:"updating", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add a row to the grid.
             * 
             */
            addRow(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Use to make multiple changes to rows while queueing row updating.
             * 
             */
            beginUpdate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             */
            buildViews(): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            canEdit(inCell: any, inRowIndex: any): any;
            /**
             * 
             */
            canSort(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Creates a new Grid layout
             * 
             */
            createLayout(): void;
            /**
             * create grid managers for various tasks including rows, focus, selection, editing
             * 
             */
            createManagers(): void;
            /**
             * 
             */
            createScroller(): void;
            /**
             * 
             */
            createSelection(): void;
            /**
             * 
             * @param inClass             
             * @param idx             
             */
            createView(inClass: any, idx: any): any;
            /**
             * 
             */
            createViews(): void;
            /**
             * 
             */
            defaultUpdate(): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchKeyEvent(e: any): void;
            /**
             * 
             * @param inValue             
             * @param inRowIndex             
             * @param inAttrName             
             */
            doApplyCellEdit(inValue: any, inRowIndex: any, inAttrName: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inDataAttr             
             */
            doApplyEdit(inRowIndex: any, inDataAttr: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            doCancelEdit(inRowIndex: any): void;
            /**
             * 
             * @param e             
             */
            doclick(e: any): void;
            /**
             * 
             * @param e             
             */
            docontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            dodblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheadercontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderdblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            dokeydown(e: any): void;
            /**
             * 
             * @param e             
             */
            doKeyEvent(e: any): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            doStartEdit(inCell: any, inRowIndex: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Use after calling beginUpdate to render any changes made to rows.
             * 
             */
            endUpdate(): void;
            /**
             * 
             * @param query             
             * @param reRender             
             */
            filter(query: any, reRender: any): void;
            /**
             * 
             */
            finishScrollJob(): void;
            /**
             * Default data getter.
             * Provides data to display in a grid cell. Called in grid cell context.
             * So this.cell.index is the column index.
             * 
             * @param inRowIndex Row for which to provide data             
             * @param inItem             
             */
            get(inRowIndex: number, inItem: any): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Retrieves the cell object for a given grid column.
             * 
             * @param inIndex Grid column index of cell to retrieve             
             */
            getCell(inIndex: number): any;
            /**
             * 
             * @param inCell             
             */
            getCellName(inCell: any): any;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             */
            getCellNodeTextDirection(inColIndex: any, inRowIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * returns an array of dijit.CheckedMenuItem widgets that can be
             * added to a menu for toggling columns on and off.
             * 
             */
            getColumnTogglingItems(): any;
            /**
             * Returns the default open state for the given definition and item
             * It reads from the openAtLevels and defaultOpen values of the
             * grid to calculate if the given item should default to open or
             * not.
             * 
             * @param cellDef             
             * @param item             
             */
            getDefaultOpenState(cellDef: any, item: any): any;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * overridden so that you can pass in a '/' delimited string of indexes to get the
             * item based off its path...that is, passing in "1/3/2" will get the
             * 3rd (0-based) child from the 4th child of the 2nd top-level item.
             * 
             * @param idx             
             */
            getItem(idx: number): any;
            /**
             * overridden so that you can pass in a '/' delimited string of indexes to get the
             * item based off its path...that is, passing in "1/3/2" will get the
             * 3rd (0-based) child from the 4th child of the 2nd top-level item.
             * 
             * @param idx             
             */
            getItem(idx: any[]): any;
            /**
             * overridden so that you can pass in a '/' delimited string of indexes to get the
             * item based off its path...that is, passing in "1/3/2" will get the
             * 3rd (0-based) child from the 4th child of the 2nd top-level item.
             * 
             * @param idx             
             */
            getItem(idx: String): any;
            /**
             * 
             * @param item             
             */
            getItemIndex(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * find the rowNode that is not a rowSelector
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * Returns true if grid is sorted in an ascending direction.
             * 
             * @param inSortInfo             
             */
            getSortAsc(inSortInfo: any): any;
            /**
             * Returns the index of the column on which the grid is sorted
             * 
             * @param inSortInfo             
             */
            getSortIndex(inSortInfo: any): number;
            /**
             * 
             */
            getSortProps(): any;
            /**
             * 
             */
            hasLayout(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param props             
             * @param node             
             * @param ctor             
             * @param cellFunc             
             */
            markupFactory(props: any, node: any, ctor: any, cellFunc: any): void;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postrender(): void;
            /**
             * 
             */
            postresize(): void;
            /**
             * 
             */
            prerender(): void;
            /**
             * Remove the selected rows from the grid.
             * 
             */
            removeSelectedRows(): void;
            /**
             * Render the grid, headers, and views. Edit and scrolling states are reset. To retain edit and
             * scrolling states, see Update.
             * 
             */
            render(): void;
            /**
             * Update the grid's rendering dimensions and resize it
             * 
             * @param changeSize             
             * @param resultSize             
             */
            resize(changeSize: any, resultSize: any): void;
            /**
             * Update grid when the height of a row has changed. Row height is handled automatically as rows
             * are rendered. Use this function only to update a row's height outside the normal rendering process.
             * 
             * @param inRowIndex index of the row that has changed height             
             */
            rowHeightChanged(inRowIndex: number): void;
            /**
             * Vertically scroll the grid to a given pixel position
             * 
             * @param inTop vertical position of the grid in pixels             
             */
            scrollTo(inTop: number): void;
            /**
             * Scroll the grid to a specific row.
             * 
             * @param inRowIndex grid row index             
             */
            scrollToRow(inRowIndex: number): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             * @param textDir             
             */
            setCellNodeTextDirection(inColIndex: any, inRowIndex: any, textDir: any): void;
            /**
             * 
             * @param inIndex             
             * @param inUnitWidth             
             */
            setCellWidth(inIndex: any, inUnitWidth: any): void;
            /**
             * 
             * @param menu             
             */
            setHeaderMenu(menu: dijit.Menu): void;
            /**
             * 
             * @param items             
             */
            setItems(items: any): void;
            /**
             * 
             * @param treeModel             
             */
            setModel(treeModel: any): void;
            /**
             * 
             * @param query             
             * @param queryOptions             
             */
            setQuery(query: any, queryOptions: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): void;
            /**
             * Sort the grid on a column in a specified direction
             * 
             * @param inIndex Column index on which to sort.             
             * @param inAsc If true, sort the grid in ascending order, otherwise in descending order             
             */
            setSortIndex(inIndex: number, inAsc: boolean): void;
            /**
             * 
             * @param inSortInfo             
             */
            setSortInfo(inSortInfo: any): void;
            /**
             * 
             * @param store             
             * @param query             
             * @param queryOptions             
             */
            setStore(store: any, query: any, queryOptions: any): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure:  Object[] ): void;

            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object[][]): void;
            /**
             * 
             */
            setupHeaderMenu(): void;
            /**
             * 
             * @param message             
             */
            showMessage(message: any): void;
            /**
             * 
             */
            sizeChange(): void;
            /**
             * 
             */
            sort(): void;
            /**
             * 
             */
            startup(): void;
            /**
             * 
             * @param inRowIndex             
             * @param inRowNode             
             */
            styleRowNode(inRowIndex: any, inRowNode: any): void;
            /**
             * Perform row styling
             * 
             * @param inRow             
             */
            styleRowState(inRow: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            textSizeChanged(): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Update the grid, retaining edit and scrolling states.
             * 
             */
            update(): void;
            /**
             * Render a single row.
             * 
             * @param inRowIndex Index of the row to render             
             */
            updateRow(inRowIndex: number): void;
            /**
             * Change the number of rows.
             * 
             * @param inRowCount Number of rows in the grid.             
             */
            updateRowCount(inRowCount: number): void;
            /**
             * Render consecutive rows at once.
             * 
             * @param startIndex Index of the starting row to render             
             * @param howMany How many rows to update.             
             */
            updateRows(startIndex: number, howMany: number): void;
            /**
             * Update the styles for a row after it's state has changed.
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Event fired when editing is applied for a given grid cell
             * 
             * @param inValue Value from cell editor             
             * @param inRowIndex Index of the grid row             
             * @param inFieldIndex Index in the grid's data store             
             */
            onApplyCellEdit(inValue: String, inRowIndex: number, inFieldIndex: number): void;
            /**
             * Event fired when editing is applied for a given grid row
             * 
             * @param inRowIndex Index of the grid row             
             */
            onApplyEdit(inRowIndex: number): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Event fired when editing is cancelled for a given grid cell
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCancelEdit(inRowIndex: number): void;
            /**
             * Event to determine if a grid row may be deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanDeselect(inRowIndex: number): any;
            /**
             * 
             * @param inRowIndex             
             */
            onCanSelect(inRowIndex: any): any;
            /**
             * Event fired when a cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellClick(e: Event): void;
            /**
             * Event fired when a cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellContextMenu(e: Event): void;
            /**
             * Event fired when a cell is double-clicked.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellDblClick(e: Event): void;
            /**
             * Event fired when a cell receives focus.
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onCellFocus(inCell: Object, inRowIndex: number): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse is over a cell.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOver(e: Event): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Top level handler for Content events
             * 
             * @param e             
             */
            onContentEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Event fired when a grid row is deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onDeselected(inRowIndex: number): void;
            /**
             * 
             * @param err             
             * @param req             
             */
            onFetchError(err: any, req: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event fired when a header cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellClick(e: Event): void;
            /**
             * Event fired when a header cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellContextMenu(e: Event): void;
            /**
             * Event fired when a header cell is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOver(e: Event): void;
            /**
             * Event fired when the grid header is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderClick(e: Event): void;
            /**
             * Event fired when the grid header context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderContextMenu(e: Event): void;
            /**
             * Event fired when the grid header is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderDblClick(e: Event): void;
            /**
             * Top level handler for header events
             * 
             * @param e             
             */
            onHeaderEvent(e: any): void;
            /**
             * Event fired when mouse moves out of the grid header.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over the grid header.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOver(e: Event): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * 
             * @param e             
             */
            onKeyDown(e: any): void;
            /**
             * top level handler for Key Events
             * 
             * @param e             
             */
            onKeyEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Event fired when mouse is down inside grid row
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDownRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Event fired when mouse moves out of any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOutRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Event fired when mouse is over any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOverRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * 
             */
            onMoveColumn(): void;
            /**
             * 
             * @param cellIdx             
             */
            onResizeColumn(cellIdx: number): void;
            /**
             * Event fired when a row is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowClick(e: Event): void;
            /**
             * Event fired when a row context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowContextMenu(e: Event): void;
            /**
             * Event fired when a row is double clicked.
             * 
             * @param e decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a data row.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a data row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOver(e: Event): void;
            /**
             * Event fired when a grid row is selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onSelected(inRowIndex: number): void;
            /**
             * 
             */
            onSelectionChanged(): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
            /**
             * Event fired when editing is started for a given grid cell
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onStartEdit(inCell: Object, inRowIndex: number): void;
            /**
             * 
             * @param row             
             */
            onStyleRow(row: any): void;
        }
        /**
         * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/LazyTreeGrid.html
         *
         * An enhanced TreeGrid widget which supports lazy-loading for nested children items
         * LazyTreeGrid inherits from dojo.grid.TreeGrid and applies virtual scrolling mechanism
         * to nested children rows so that it's possible to deal with complex tree structure data set
         * with nested and huge children rows. It's also compatible with dijit.tree.ForestStoreModel
         * 
         * Most methods and properties pertaining to dojox.grid.DataGrid
         * and dojox.grid.TreeGrid also apply here
         * 
         * LazyTreeGrid does not support summary row/items aggregate due to the lazy-loading rationale.
         * 
         * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
         * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
         */
        class LazyTreeGrid extends dojox.grid.TreeGrid {
            constructor(params?: Object, srcNodeRef?: HTMLElement);
            /**
             * The aggregator class - it will be populated automatically if we
             * are a collapsible grid
             * 
             */
            "aggregator": Object;
            set(property:"aggregator", value: Object): void;
            get(property:"aggregator"): Object;
            watch(property:"aggregator", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Object to which attach points and events will be scoped.  Defaults
             * to 'this'.
             * 
             */
            "attachScope": Object;
            set(property:"attachScope", value: Object): void;
            get(property:"attachScope"): Object;
            watch(property:"attachScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
             * for each XXX attribute to be mapped to the DOM.
             * 
             * attributeMap sets up a "binding" between attributes (aka properties)
             * of the widget and the widget's DOM.
             * Changes to widget attributes listed in attributeMap will be
             * reflected into the DOM.
             * 
             * For example, calling set('title', 'hello')
             * on a TitlePane will automatically cause the TitlePane's DOM to update
             * with the new title.
             * 
             * attributeMap is a hash where the key is an attribute of the widget,
             * and the value reflects a binding to a:
             * 
             * DOM node attribute
             *   focus: {node: "focusNode", type: "attribute"}
             * Maps this.focus to this.focusNode.focus
             * 
             * DOM node innerHTML
             *   title: { node: "titleNode", type: "innerHTML" }
             * Maps this.title to this.titleNode.innerHTML
             * 
             * DOM node innerText
             *   title: { node: "titleNode", type: "innerText" }
             * Maps this.title to this.titleNode.innerText
             * 
             * DOM node CSS class
             *   myClass: { node: "domNode", type: "class" }
             * Maps this.myClass to this.domNode.className
             * 
             * If the value is an array, then each element in the array matches one of the
             * formats of the above list.
             * 
             * There are also some shorthands for backwards compatibility:
             * 
             * string --> { node: string, type: "attribute" }, for example:
             * "focusNode" ---> { node: "focusNode", type: "attribute" }
             * "" --> { node: "domNode", type: "attribute" }
             * 
             */
            "attributeMap": Object;
            set(property:"attributeMap", value: Object): void;
            get(property:"attributeMap"): Object;
            watch(property:"attributeMap", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If autoHeight is true, grid height is automatically set to fit the data.
             * If it is an integer, the height will be automatically set to fit the data
             * if there are fewer than that many rows - and the height will be set to show
             * that many rows if there are more
             * 
             */
            "autoHeight": boolean;
            set(property:"autoHeight", value: boolean): void;
            get(property:"autoHeight"): boolean;
            watch(property:"autoHeight", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoRender is true, grid will render itself after initialization.
             * 
             */
            "autoRender": boolean;
            set(property:"autoRender", value: boolean): void;
            get(property:"autoRender"): boolean;
            watch(property:"autoRender", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If autoWidth is true, grid width is automatically set to fit the data.
             * 
             */
            "autoWidth": boolean;
            set(property:"autoWidth", value: boolean): void;
            get(property:"autoWidth"): boolean;
            watch(property:"autoWidth", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Root CSS class of the widget (ex: dijitTextBox), used to construct CSS classes to indicate
             * widget state.
             * 
             */
            "baseClass": string;
            set(property:"baseClass", value: string): void;
            get(property:"baseClass"): string;
            watch(property:"baseClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * css class to apply to grid cells over which the cursor is placed.
             * 
             */
            "cellOverClass": string;
            set(property:"cellOverClass", value: string): void;
            get(property:"cellOverClass"): string;
            watch(property:"cellOverClass", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "class": string;
            set(property:"class", value: string): void;
            get(property:"class"): string;
            watch(property:"class", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * CSS class applied to the grid's domNode
             * 
             */
            "classTag": string;
            set(property:"classTag", value: string): void;
            get(property:"classTag"): string;
            watch(property:"classTag", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A json object that defines column span of each level rows.  Attributes:
             * 
             * 0/1/..: which level need to colspan
             * start: start column index of colspan
             * end: end column index of colspan
             * primary: index of column which content will be displayed (default is value of start).
             * example:
             * 
             * colSpans = {
             * 0:  [
             *         {start: 0, end: 1, primary: 0},
             *         {start: 2, end: 4, primary: 3}
             *     ],
             * 1:  [
             *         {start: 0, end: 3, primary: 1}
             *     ]
             * };
             * 
             */
            "colSpans": Object;
            set(property:"colSpans", value: Object): void;
            get(property:"colSpans"): Object;
            watch(property:"colSpans", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If set to true, will add drag and drop reordering to views with one row of columns.
             * 
             */
            "columnReordering": boolean;
            set(property:"columnReordering", value: boolean): void;
            get(property:"columnReordering"): boolean;
            watch(property:"columnReordering", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Designates where children of the source DOM node will be placed.
             * "Children" in this case refers to both DOM nodes and widgets.
             * For example, for myWidget:
             * 
             * <div data-dojo-type=myWidget>
             *     <b> here's a plain DOM node
             *     <span data-dojo-type=subWidget>and a widget</span>
             *     <i> and another plain DOM node </i>
             * </div>
             * containerNode would point to:
             * 
             * <b> here's a plain DOM node
             * <span data-dojo-type=subWidget>and a widget</span>
             * <i> and another plain DOM node </i>
             * In templated widgets, "containerNode" is set via a
             * data-dojo-attach-point assignment.
             * 
             * containerNode must be defined for any widget that accepts innerHTML
             * (like ContentPane or BorderContainer or even Button), and conversely
             * is null for widgets that don't, like TextBox.
             * 
             */
            "containerNode": HTMLElement;
            set(property:"containerNode", value: HTMLElement): void;
            get(property:"containerNode"): HTMLElement;
            watch(property:"containerNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * default height of the grid, measured in any valid css unit.
             * 
             */
            "defaultHeight": string;
            set(property:"defaultHeight", value: string): void;
            get(property:"defaultHeight"): string;
            watch(property:"defaultHeight", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Whether or not we default to open (all levels).  This defaults to
             * false for grids with a treeModel.
             * 
             */
            "defaultOpen": boolean;
            set(property:"defaultOpen", value: boolean): void;
            get(property:"defaultOpen"): boolean;
            watch(property:"defaultOpen", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Used to restore the state of LazyTreeGrid.
             * This object should ONLY be obtained from LazyTreeGrid.getState().
             * 
             */
            "defaultState": Object;
            set(property:"defaultState", value: Object): void;
            get(property:"defaultState"): Object;
            watch(property:"defaultState", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "delayScroll": boolean;
            set(property:"delayScroll", value: boolean): void;
            get(property:"delayScroll"): boolean;
            watch(property:"delayScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Bi-directional support, as defined by the HTML DIR
             * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
             * default direction.
             * 
             */
            "dir": string;
            set(property:"dir", value: string): void;
            get(property:"dir"): string;
            watch(property:"dir", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This is our visible representation of the widget! Other DOM
             * Nodes may by assigned to other properties, usually through the
             * template system's data-dojo-attach-point syntax, but the domNode
             * property is the canonical "top level" node in widget UI.
             * 
             */
            "domNode": HTMLElement;
            set(property:"domNode", value: HTMLElement): void;
            get(property:"domNode"): HTMLElement;
            watch(property:"domNode", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * indicates if the grid contains editable cells, default is false
             * set to true if editable cell encountered during rendering
             * 
             */
            "editable": boolean;
            set(property:"editable", value: boolean): void;
            get(property:"editable"): boolean;
            watch(property:"editable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Override defaults and make the indexed grid view elastic, thus filling available horizontal space.
             * 
             */
            "elasticView": number;
            set(property:"elasticView", value: number): void;
            get(property:"elasticView"): number;
            watch(property:"elasticView", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Message that shows when the grid encounters an error loading
             * 
             */
            "errorMessage": string;
            set(property:"errorMessage", value: string): void;
            get(property:"errorMessage"): string;
            watch(property:"errorMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This will escape HTML brackets from the data to prevent HTML from
             * user-inputted data being rendered with may contain JavaScript and result in
             * XSS attacks. This is true by default, and it is recommended that it remain
             * true. Setting this to false will allow data to be displayed in the grid without
             * filtering, and should be only used if it is known that the data won't contain
             * malicious scripts. If HTML is needed in grid cells, it is recommended that
             * you use the formatter function to generate the HTML (the output of
             * formatter functions is not filtered, even with escapeHTMLInData set to true).
             * 
             */
            "escapeHTMLInData": boolean;
            set(property:"escapeHTMLInData", value: boolean): void;
            get(property:"escapeHTMLInData"): boolean;
            watch(property:"escapeHTMLInData", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * When used in conjunction with a treeModel (see above), this is a 0-based
             * index of the cell in which to place the actual expando
             * 
             */
            "expandoCell": number;
            set(property:"expandoCell", value: number): void;
            get(property:"expandoCell"): number;
            watch(property:"expandoCell", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * flag modifies vertical scrolling behavior. Defaults to true but set to false for slower
             * scroll performance but more immediate scrolling feedback
             * 
             */
            "fastScroll": boolean;
            set(property:"fastScroll", value: boolean): void;
            get(property:"fastScroll"): boolean;
            watch(property:"fastScroll", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "fetchText": string;
            set(property:"fetchText", value: string): void;
            get(property:"fetchText"): string;
            watch(property:"fetchText", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * This widget or a widget it contains has focus, or is "active" because
             * it was recently clicked.
             * 
             */
            "focused": boolean;
            set(property:"focused", value: boolean): void;
            get(property:"focused"): boolean;
            watch(property:"focused", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * An object to execute format functions within.  If not set, the
             * format functions will execute within the scope of the cell that
             * has a format function.
             * 
             */
            "formatterScope": Object;
            set(property:"formatterScope", value: Object): void;
            get(property:"formatterScope"): Object;
            watch(property:"formatterScope", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * If set to a dijit.Menu, will use this as a context menu for the grid headers.
             * 
             */
            "headerMenu": Object;
            set(property:"headerMenu", value: Object): void;
            get(property:"headerMenu"): Object;
            watch(property:"headerMenu", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * explicit height of the grid, measured in any valid css unit.  This will be populated (and overridden)
             * if the height: css attribute exists on the source node.
             * 
             */
            "height": string;
            set(property:"height", value: string): void;
            get(property:"height"): string;
            watch(property:"height", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A unique, opaque ID string that can be assigned by users or by the
             * system. If the developer passes an ID which is known not to be
             * unique, the specified ID is ignored and the system-generated ID is
             * used instead.
             * 
             */
            "id": string;
            set(property:"id", value: string): void;
            get(property:"id"): string;
            watch(property:"id", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A css string to use to set our initial width (only used if autoWidth
             * is true).  The first rendering of the grid will be this width, any
             * resizing of columns, etc will result in the grid switching to
             * autoWidth mode.  Note, this width will override any styling in a
             * stylesheet or directly on the node.
             * 
             */
            "initialWidth": string;
            set(property:"initialWidth", value: string): void;
            get(property:"initialWidth"): string;
            watch(property:"initialWidth", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "invalidated": Object;
            set(property:"invalidated", value: Object): void;
            get(property:"invalidated"): Object;
            watch(property:"invalidated", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "items": Object;
            set(property:"items", value: Object): void;
            get(property:"items"): Object;
            watch(property:"items", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Number of rows to keep in the rendering cache.
             * 
             */
            "keepRows": number;
            set(property:"keepRows", value: number): void;
            get(property:"keepRows"): number;
            watch(property:"keepRows", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * Whether keep selection after sort, filter etc.
             * 
             */
            "keepSelection": boolean;
            set(property:"keepSelection", value: boolean): void;
            get(property:"keepSelection"): boolean;
            watch(property:"keepSelection", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Rarely used.  Overrides the default Dojo locale used to render this widget,
             * as defined by the HTML LANG attribute.
             * Value must be among the list of locales specified during by the Dojo bootstrap,
             * formatted according to RFC 3066 (like en-us).
             * 
             */
            "lang": string;
            set(property:"lang", value: string): void;
            get(property:"lang"): string;
            watch(property:"lang", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows while the grid is loading
             * 
             */
            "loadingMessage": string;
            set(property:"loadingMessage", value: string): void;
            get(property:"loadingMessage"): string;
            watch(property:"loadingMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Message that shows if the grid has no data - wrap it in a
             * span with class 'dojoxGridNoData' if you want it to be
             * styled similar to the loading and error messages
             * 
             */
            "noDataMessage": string;
            set(property:"noDataMessage", value: string): void;
            get(property:"noDataMessage"): string;
            watch(property:"noDataMessage", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "observer": string;
            set(property:"observer", value: string): void;
            get(property:"observer"): string;
            watch(property:"observer", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Which levels we are open at (overrides defaultOpen for the values
             * that exist here).  Its values can be a boolean (true/false) or an
             * integer (for the # of children to be closed if there are more than
             * that)
             * 
             */
            "openAtLevels": any[];
            set(property:"openAtLevels", value: any[]): void;
            get(property:"openAtLevels"): any[];
            watch(property:"openAtLevels", callback:{(property?:string, oldValue?:any[], newValue?: any[]):void}) :{unwatch():void}
            /**
             * The document this widget belongs to.  If not specified to constructor, will default to
             * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
             * 
             */
            "ownerDocument": Object;
            set(property:"ownerDocument", value: Object): void;
            get(property:"ownerDocument"): Object;
            watch(property:"ownerDocument", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Label of placeholders to search for in the header menu to replace with column toggling
             * menu items.
             * 
             */
            "placeholderLabel": string;
            set(property:"placeholderLabel", value: string): void;
            get(property:"placeholderLabel"): string;
            watch(property:"placeholderLabel", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "query": Object;
            set(property:"query", value: Object): void;
            get(property:"query"): Object;
            watch(property:"query", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "queryOptions": Object;
            set(property:"queryOptions", value: Object): void;
            get(property:"queryOptions"): Object;
            watch(property:"queryOptions", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "rowCount": number;
            set(property:"rowCount", value: number): void;
            get(property:"rowCount"): number;
            watch(property:"rowCount", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If rowHeight is set to a positive number, it will define the height of the rows
             * in pixels. This can provide a significant performance advantage, since it
             * eliminates the need to measure row sizes during rendering, which is one
             * the primary bottlenecks in the DataGrid's performance.
             * 
             */
            "rowHeight": number;
            set(property:"rowHeight", value: number): void;
            get(property:"rowHeight"): number;
            watch(property:"rowHeight", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * If set to true, will add a row selector view to this grid.  If set to a CSS width, will add
             * a row selector of that width to this grid.
             * 
             */
            "rowSelector": boolean;
            set(property:"rowSelector", value: boolean): void;
            get(property:"rowSelector"): boolean;
            watch(property:"rowSelector", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Number of rows to render at a time.
             * 
             */
            "rowsPerPage": number;
            set(property:"rowsPerPage", value: number): void;
            get(property:"rowsPerPage"): number;
            watch(property:"rowsPerPage", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pixel distance a user must scroll vertically to trigger grid scrolling.
             * 
             */
            "scrollRedrawThreshold": number;
            set(property:"scrollRedrawThreshold", value: number): void;
            get(property:"scrollRedrawThreshold"): number;
            watch(property:"scrollRedrawThreshold", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "searchContainerNode": boolean;
            set(property:"searchContainerNode", value: boolean): void;
            get(property:"searchContainerNode"): boolean;
            watch(property:"searchContainerNode", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set to true if you want to be able to select the text within the grid.
             * 
             */
            "selectable": boolean;
            set(property:"selectable", value: boolean): void;
            get(property:"selectable"): boolean;
            watch(property:"selectable", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Set the selection mode of grid's Selection.  Value must be 'single', 'multiple',
             * or 'extended'.  Default is 'extended'.
             * 
             */
            "selectionMode": string;
            set(property:"selectionMode", value: string): void;
            get(property:"selectionMode"): string;
            watch(property:"selectionMode", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Single-click starts editing. Default is double-click
             * 
             */
            "singleClickEdit": boolean;
            set(property:"singleClickEdit", value: boolean): void;
            get(property:"singleClickEdit"): boolean;
            watch(property:"singleClickEdit", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * If true, child items will be returned sorted according to the sorting
             * properties of the grid.
             * 
             */
            "sortChildItems": boolean;
            set(property:"sortChildItems", value: boolean): void;
            get(property:"sortChildItems"): boolean;
            watch(property:"sortChildItems", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * 
             */
            "sortFields": Object;
            set(property:"sortFields", value: Object): void;
            get(property:"sortFields"): Object;
            watch(property:"sortFields", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * 
             */
            "sortInfo": number;
            set(property:"sortInfo", value: number): void;
            get(property:"sortInfo"): number;
            watch(property:"sortInfo", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * pointer to original DOM node
             * 
             */
            "srcNodeRef": HTMLElement;
            set(property:"srcNodeRef", value: HTMLElement): void;
            get(property:"srcNodeRef"): HTMLElement;
            watch(property:"srcNodeRef", callback:{(property?:string, oldValue?:HTMLElement, newValue?: HTMLElement):void}) :{unwatch():void}
            /**
             * 
             */
            "store": Object;
            set(property:"store", value: Object): void;
            get(property:"store"): Object;
            watch(property:"store", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * View layout definition.
             * 
             */
            "structure": Object;
            set(property:"structure", value: Object): void;
            get(property:"structure"): Object;
            watch(property:"structure", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * HTML style attributes as cssText string or name/value hash
             * 
             */
            "style": string;
            set(property:"style", value: string): void;
            get(property:"style"): string;
            watch(property:"style", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Customizable summary descriptions which will be added to grid.domNode
             * 
             */
            "summary": string;
            set(property:"summary", value: string): void;
            get(property:"summary"): string;
            watch(property:"summary", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * Path to template (HTML file) for this widget relative to dojo.baseUrl.
             * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
             * 
             */
            "templatePath": string;
            set(property:"templatePath", value: string): void;
            get(property:"templatePath"): string;
            watch(property:"templatePath", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * 
             */
            "templateString": string;
            set(property:"templateString", value: string): void;
            get(property:"templateString"): string;
            watch(property:"templateString", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * HTML title attribute.
             * 
             * For form widgets this specifies a tooltip to display when hovering over
             * the widget (just like the native HTML title attribute).
             * 
             * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
             * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
             * interpreted as HTML.
             * 
             */
            "title": string;
            set(property:"title", value: string): void;
            get(property:"title"): string;
            watch(property:"title", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
             * this specifies the tooltip to appear when the mouse is hovered over that text.
             * 
             */
            "tooltip": string;
            set(property:"tooltip", value: string): void;
            get(property:"tooltip"): string;
            watch(property:"tooltip", callback:{(property?:string, oldValue?:string, newValue?: string):void}) :{unwatch():void}
            /**
             * A tree store model object.
             * 
             */
            "treeModel": Object;
            set(property:"treeModel", value: Object): void;
            get(property:"treeModel"): Object;
            watch(property:"treeModel", callback:{(property?:string, oldValue?:Object, newValue?: Object):void}) :{unwatch():void}
            /**
             * Time, in milliseconds, to delay updates automatically so that multiple
             * calls to onSet/onNew/onDelete don't keep rerendering the grid.  Set
             * to 0 to immediately cause updates.  A higher value will result in
             * better performance at the expense of responsiveness of the grid.
             * 
             */
            "updateDelay": number;
            set(property:"updateDelay", value: number): void;
            get(property:"updateDelay"): number;
            watch(property:"updateDelay", callback:{(property?:string, oldValue?:number, newValue?: number):void}) :{unwatch():void}
            /**
             * 
             */
            "updating": boolean;
            set(property:"updating", value: boolean): void;
            get(property:"updating"): boolean;
            watch(property:"updating", callback:{(property?:string, oldValue?:boolean, newValue?: boolean):void}) :{unwatch():void}
            /**
             * Add a row to the grid.
             * 
             */
            addRow(): void;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: String, value: Object): any;
            /**
             * This method is deprecated, use get() or set() directly.
             * 
             * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
             * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
             */
            attr(name: Object, value: Object): any;
            /**
             * Use to make multiple changes to rows while queueing row updating.
             * 
             */
            beginUpdate(): void;
            /**
             * 
             */
            buildRendering(): void;
            /**
             * 
             */
            buildViews(): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            canEdit(inCell: any, inRowIndex: any): any;
            /**
             * 
             */
            canSort(): boolean;
            /**
             * Collapse the row with the given itemId.
             * 
             * @param itemId               Optional            
             */
            collapse(itemId: String): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: String): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: String, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: Object, event: Function, method: Function): any;
            /**
             * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
             * 
             * Connects specified obj/event to specified method of this object
             * and registers for disconnect() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.connect, except with the
             * implicit use of this widget as the target object.
             * Events connected with this.connect are disconnected upon
             * destruction.
             * 
             * @param obj             
             * @param event             
             * @param method             
             */
            connect(obj: any, event: Function, method: Function): any;
            /**
             * Creates a new Grid layout
             * 
             */
            createLayout(): void;
            /**
             * 
             */
            createManagers(): void;
            /**
             * 
             */
            createScroller(): void;
            /**
             * 
             */
            createSelection(): void;
            /**
             * 
             * @param inClass             
             * @param idx             
             */
            createView(inClass: any, idx: any): any;
            /**
             * 
             */
            createViews(): void;
            /**
             * 
             */
            defaultUpdate(): void;
            /**
             * Wrapper to setTimeout to avoid deferred functions executing
             * after the originating widget has been destroyed.
             * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
             * 
             * @param fcn Function reference.             
             * @param delay               OptionalDelay, defaults to 0.             
             */
            defer(fcn: Function, delay: number): Object;
            /**
             * 
             */
            destroy(): void;
            /**
             * Recursively destroy the children of this widget and their
             * descendants.
             * 
             * @param preserveDom               OptionalIf true, the preserveDom attribute is passed to all descendantwidget's .destroy() method. Not for use with _Templatedwidgets.             
             */
            destroyDescendants(preserveDom: boolean): void;
            /**
             * Destroy this widget and its descendants
             * This is the generic "destructor" function that all widget users
             * should call to cleanly discard with a widget. Once a widget is
             * destroyed, it is removed from the manager object.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structurealone of descendant Widgets. Note: This will NOT work withdijit._TemplatedMixin widgets.             
             */
            destroyRecursive(preserveDom: boolean): void;
            /**
             * Destroys the DOM nodes associated with this widget.
             * 
             * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
             */
            destroyRendering(preserveDom?: boolean): void;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Disconnects handle created by connect.
             * 
             * @param handle             
             */
            disconnect(handle: any): void;
            /**
             * 
             * @param e             
             */
            dispatchContentEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchHeaderEvent(e: any): void;
            /**
             * 
             * @param e             
             */
            dispatchKeyEvent(e: any): void;
            /**
             * 
             * @param inValue             
             * @param inRowIndex             
             * @param inAttrName             
             */
            doApplyCellEdit(inValue: any, inRowIndex: any, inAttrName: any): void;
            /**
             * 
             * @param inRowIndex             
             * @param inDataAttr             
             */
            doApplyEdit(inRowIndex: any, inDataAttr: any): void;
            /**
             * 
             * @param inRowIndex             
             */
            doCancelEdit(inRowIndex: any): void;
            /**
             * 
             * @param e             
             */
            doclick(e: any): void;
            /**
             * 
             * @param e             
             */
            docontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            dodblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderclick(e: any): void;
            /**
             * 
             * @param e             
             */
            doheadercontextmenu(e: any): void;
            /**
             * 
             * @param e             
             */
            doheaderdblclick(e: any): void;
            /**
             * 
             * @param e             
             */
            dokeydown(e: any): void;
            /**
             * 
             * @param e             
             */
            doKeyEvent(e: any): void;
            /**
             * 
             * @param inCell             
             * @param inRowIndex             
             */
            doStartEdit(inCell: any, inRowIndex: any): void;
            /**
             * Used by widgets to signal that a synthetic event occurred, ex:
             * 
             * myWidget.emit("attrmodified-selectedChildWidget", {}).
             * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
             * Also calls onType() method, if present, and returns value from that method.
             * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
             * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
             * 
             * @param type             
             * @param eventObj               Optional            
             * @param callbackArgs               Optional            
             */
            emit(type: String, eventObj: Object, callbackArgs: any[]): any;
            /**
             * Use after calling beginUpdate to render any changes made to rows.
             * 
             */
            endUpdate(): void;
            /**
             * Expand the row with the given itemId.
             * 
             * @param itemId               Optional            
             */
            expand(itemId: String): void;
            /**
             * Function for fetch children of a given row
             * 
             * @param rowIndex             
             * @param open             
             */
            expandoFetch(rowIndex: any, open: any): void;
            /**
             * 
             * @param query             
             * @param reRender             
             */
            filter(query: any, reRender: any): void;
            /**
             * 
             */
            finishScrollJob(): void;
            /**
             * Default data getter.
             * Provides data to display in a grid cell. Called in grid cell context.
             * So this.cell.index is the column index.
             * 
             * @param inRowIndex Row for which to provide data             
             * @param inItem             
             */
            get(inRowIndex: number, inItem: any): any;
            /**
             * Get a property from a widget.
             * Get a named property from a widget. The property may
             * potentially be retrieved via a getter method. If no getter is defined, this
             * just retrieves the object's property.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _getFooAttr(), calling:
             * myWidget.get("foo") would be equivalent to calling
             * widget._getFooAttr() and myWidget.get("bar")
             * would be equivalent to the expression
             * widget.bar2
             * 
             * @param name The property to get.             
             */
            get(name: any): any;
            /**
             * Retrieves the cell object for a given grid column.
             * 
             * @param inIndex Grid column index of cell to retrieve             
             */
            getCell(inIndex: number): any;
            /**
             * 
             * @param inCell             
             */
            getCellName(inCell: any): any;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             */
            getCellNodeTextDirection(inColIndex: any, inRowIndex: any): any;
            /**
             * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
             * is this widget.   Note that it does not return all descendants, but rather just direct children.
             * Analogous to Node.childNodes,
             * except containing widgets rather than DOMNodes.
             * 
             * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
             * outside of this.containerNode.
             * 
             * Note that the array returned is a simple array.  Application code should not assume
             * existence of methods like forEach().
             * 
             */
            getChildren(): any[];
            /**
             * returns an array of dijit.CheckedMenuItem widgets that can be
             * added to a menu for toggling columns on and off.
             * 
             */
            getColumnTogglingItems(): any;
            /**
             * Returns the default open state for the given definition and item
             * It reads from the openAtLevels and defaultOpen values of the
             * grid to calculate if the given item should default to open or
             * not.
             * 
             * @param cellDef             
             * @param item             
             */
            getDefaultOpenState(cellDef: any, item: any): any;
            /**
             * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
             * This method should generally be avoided as it returns widgets declared in templates, which are
             * supposed to be internal/hidden, but it's left here for back-compat reasons.
             * 
             */
            getDescendants(): any[];
            /**
             * overridden so that you can pass in a '/' delimited string of indexes to get the
             * item based off its path...that is, passing in "1/3/2" will get the
             * 3rd (0-based) child from the 4th child of the 2nd top-level item.
             * 
             * @param idx             
             */
            getItem(idx: number): any;
            /**
             * overridden so that you can pass in a '/' delimited string of indexes to get the
             * item based off its path...that is, passing in "1/3/2" will get the
             * 3rd (0-based) child from the 4th child of the 2nd top-level item.
             * 
             * @param idx             
             */
            getItem(idx: any[]): any;
            /**
             * overridden so that you can pass in a '/' delimited string of indexes to get the
             * item based off its path...that is, passing in "1/3/2" will get the
             * 3rd (0-based) child from the 4th child of the 2nd top-level item.
             * 
             * @param idx             
             */
            getItem(idx: String): any;
            /**
             * 
             * @param item             
             */
            getItemIndex(item: any): any;
            /**
             * Returns the parent widget of this widget.
             * 
             */
            getParent(): any;
            /**
             * find the rowNode that is not a rowSelector
             * 
             * @param inRowIndex             
             */
            getRowNode(inRowIndex: any): any;
            /**
             * Returns true if grid is sorted in an ascending direction.
             * 
             * @param inSortInfo             
             */
            getSortAsc(inSortInfo: any): any;
            /**
             * Returns the index of the column on which the grid is sorted
             * 
             * @param inSortInfo             
             */
            getSortIndex(inSortInfo: any): number;
            /**
             * 
             */
            getSortProps(): any;
            /**
             * Get the current state of LazyTreeGrid including expanding, sorting, selection and scroll top state.
             * 
             */
            getState(): Object;
            /**
             * 
             */
            hasLayout(): any;
            /**
             * Return true if this widget can currently be focused
             * and false if not
             * 
             */
            isFocusable(): any;
            /**
             * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
             * 
             */
            isLeftToRight(): any;
            /**
             * 
             * @param props             
             * @param node             
             * @param ctor             
             * @param cellFunc             
             */
            markupFactory(props: any, node: any, ctor: any, cellFunc: any): void;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: String, func: Function): any;
            /**
             * 
             * @param type protected             
             * @param func             
             */
            on(type: Function, func: Function): any;
            /**
             * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
             * already removed/destroyed manually.
             * 
             */
            own(): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: String): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: String, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: HTMLElement, position: number): any;
            /**
             * Place this widget somewhere in the DOM based
             * on standard domConstruct.place() conventions.
             * A convenience function provided in all _Widgets, providing a simple
             * shorthand mechanism to put an existing (or newly created) Widget
             * somewhere in the dom, and allow chaining.
             * 
             * @param reference Widget, DOMNode, or id of widget or DOMNode             
             * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
             */
            placeAt(reference: dijit._WidgetBase, position: number): any;
            /**
             * 
             */
            postCreate(): void;
            /**
             * 
             */
            postMixInProperties(): void;
            /**
             * 
             */
            postrender(): void;
            /**
             * 
             */
            postresize(): void;
            /**
             * 
             */
            prerender(): void;
            /**
             * Refresh, and persist the expand/collapse state when keepState equals true
             * 
             * @param keepState             
             */
            refresh(keepState: boolean): void;
            /**
             * Remove the selected rows from the grid.
             * 
             */
            removeSelectedRows(): void;
            /**
             * 
             */
            render(): void;
            /**
             * Update the grid's rendering dimensions and resize it
             * 
             * @param changeSize             
             * @param resultSize             
             */
            resize(changeSize: any, resultSize: any): void;
            /**
             * Update grid when the height of a row has changed. Row height is handled automatically as rows
             * are rendered. Use this function only to update a row's height outside the normal rendering process.
             * 
             * @param inRowIndex index of the row that has changed height             
             */
            rowHeightChanged(inRowIndex: number): void;
            /**
             * Vertically scroll the grid to a given pixel position
             * 
             * @param inTop vertical position of the grid in pixels             
             */
            scrollTo(inTop: number): void;
            /**
             * Scroll the grid to a specific row.
             * 
             * @param inRowIndex grid row index             
             */
            scrollToRow(inRowIndex: number): void;
            /**
             * Set a property on a widget
             * Sets named properties on a widget which may potentially be handled by a
             * setter in the widget.
             * 
             * For example, if the widget has properties foo and bar
             * and a method named _setFooAttr(), calling
             * myWidget.set("foo", "Howdy!") would be equivalent to calling
             * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
             * would be equivalent to the statement widget.bar = 3;
             * 
             * set() may also be called with a hash of name/value pairs, ex:
             * 
             * myWidget.set({
             *     foo: "Howdy",
             *     bar: 3
             * });
             * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
             * 
             * @param name The property to set.             
             * @param value The value to set in the property.             
             */
            set(name: any, value: any): any;
            /**
             * Deprecated.  Use set() instead.
             * 
             * @param attr             
             * @param value             
             */
            setAttribute(attr: String, value: any): void;
            /**
             * 
             * @param inColIndex             
             * @param inRowIndex             
             * @param textDir             
             */
            setCellNodeTextDirection(inColIndex: any, inRowIndex: any, textDir: any): void;
            /**
             * 
             * @param inIndex             
             * @param inUnitWidth             
             */
            setCellWidth(inIndex: any, inUnitWidth: any): void;
            /**
             * 
             * @param menu             
             */
            setHeaderMenu(menu: dijit.Menu): void;
            /**
             * 
             * @param items             
             */
            setItems(items: any): void;
            /**
             * 
             * @param treeModel             
             */
            setModel(treeModel: any): void;
            /**
             * 
             * @param query             
             * @param queryOptions             
             */
            setQuery(query: any, queryOptions: any): void;
            /**
             * 
             * @param inTop             
             */
            setScrollTop(inTop: any): void;
            /**
             * 
             * @param inIndex             
             * @param inAsc             
             */
            setSortIndex(inIndex: any, inAsc: any): void;
            /**
             * 
             * @param inSortInfo             
             */
            setSortInfo(inSortInfo: any): void;
            /**
             * 
             * @param store             
             * @param query             
             * @param queryOptions             
             */
            setStore(store: any, query: any, queryOptions: any): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object ): void;
            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure:  Object[] ): void;

            /**
             * Install a new structure and rebuild the grid.
             * 
             * @param inStructure             
             */
            setStructure(inStructure: Object[][]): void;
            /**
             * 
             */
            setupHeaderMenu(): void;
            /**
             * 
             * @param message             
             */
            showMessage(message: any): void;
            /**
             * 
             */
            sizeChange(): void;
            /**
             * 
             */
            sort(): void;
            /**
             * 
             */
            startup(): void;
            /**
             * 
             * @param rowIndex             
             * @param rowNode             
             */
            styleRowNode(rowIndex: any, rowNode: any): void;
            /**
             * Perform row styling
             * 
             * @param inRow             
             */
            styleRowState(inRow: any): void;
            /**
             * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
             * 
             * Subscribes to the specified topic and calls the specified method
             * of this object and registers for unsubscribe() on widget destroy.
             * 
             * Provide widget-specific analog to dojo.subscribe, except with the
             * implicit use of this widget as the target object.
             * 
             * @param t The topic             
             * @param method The callback             
             */
            subscribe(t: String, method: Function): any;
            /**
             * 
             */
            textSizeChanged(): void;
            /**
             * Returns a string that represents the widget.
             * When a widget is cast to a string, this method will be used to generate the
             * output. Currently, it does not implement any sort of reversible
             * serialization.
             * 
             */
            toString(): string;
            /**
             * Deprecated. Override destroy() instead to implement custom widget tear-down
             * behavior.
             * 
             */
            uninitialize(): boolean;
            /**
             * Deprecated, will be removed in 2.0, use handle.remove() instead.
             * 
             * Unsubscribes handle created by this.subscribe.
             * Also removes handle from this widget's list of subscriptions
             * 
             * @param handle             
             */
            unsubscribe(handle: Object): void;
            /**
             * Update the grid, retaining edit and scrolling states.
             * 
             */
            update(): void;
            /**
             * Render a single row.
             * 
             * @param inRowIndex Index of the row to render             
             */
            updateRow(inRowIndex: number): void;
            /**
             * Change the number of rows.
             * 
             * @param inRowCount Number of rows in the grid.             
             */
            updateRowCount(inRowCount: number): void;
            /**
             * Render consecutive rows at once.
             * 
             * @param startIndex Index of the starting row to render             
             * @param howMany How many rows to update.             
             */
            updateRows(startIndex: number, howMany: number): void;
            /**
             * Update the styles for a row after it's state has changed.
             * 
             * @param inRowIndex             
             */
            updateRowStyles(inRowIndex: any): void;
            /**
             * Watches a property for changes
             * 
             * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
             * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
             */
            watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
            /**
             * Static method to get a template based on the templatePath or
             * templateString key
             */
            getCachedTemplate(): any;
            /**
             * Event fired when editing is applied for a given grid cell
             * 
             * @param inValue Value from cell editor             
             * @param inRowIndex Index of the grid row             
             * @param inFieldIndex Index in the grid's data store             
             */
            onApplyCellEdit(inValue: String, inRowIndex: number, inFieldIndex: number): void;
            /**
             * Event fired when editing is applied for a given grid row
             * 
             * @param inRowIndex Index of the grid row             
             */
            onApplyEdit(inRowIndex: number): void;
            /**
             * Called when the widget stops being "active" because
             * focus moved to something outside of it, or the user
             * clicked somewhere outside of it, or the widget was
             * hidden.
             * 
             */
            onBlur(): void;
            /**
             * Event fired when editing is cancelled for a given grid cell
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCancelEdit(inRowIndex: number): void;
            /**
             * Event to determine if a grid row may be deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onCanDeselect(inRowIndex: number): any;
            /**
             * 
             * @param inRowIndex             
             */
            onCanSelect(inRowIndex: any): any;
            /**
             * Event fired when a cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellClick(e: Event): void;
            /**
             * Event fired when a cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellContextMenu(e: Event): void;
            /**
             * Event fired when a cell is double-clicked.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellDblClick(e: Event): void;
            /**
             * Event fired when a cell receives focus.
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onCellFocus(inCell: Object, inRowIndex: number): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse is over a cell.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onCellMouseOver(e: Event): void;
            /**
             * Connect to this function to receive notifications of mouse click events.
             * 
             * @param event mouse Event             
             */
            onClick(event: any): void;
            /**
             * Called when this widget is being displayed as a popup (ex: a Calendar popped
             * up from a DateTextBox), and it is hidden.
             * This is called from the dijit.popup code, and should not be called directly.
             * 
             * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
             * Callback if a user tries to close the child.   Child will be closed if this function returns true.
             * 
             */
            onClose(): boolean;
            /**
             * Top level handler for Content events
             * 
             * @param e             
             */
            onContentEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of mouse double click events.
             * 
             * @param event mouse Event             
             */
            onDblClick(event: any): void;
            /**
             * Event fired when a grid row is deselected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onDeselected(inRowIndex: number): void;
            /**
             * 
             * @param err             
             * @param req             
             */
            onFetchError(err: any, req: any): void;
            /**
             * Called when the widget becomes "active" because
             * it or a widget inside of it either has focus, or has recently
             * been clicked.
             * 
             */
            onFocus(): void;
            /**
             * Event fired when a header cell is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellClick(e: Event): void;
            /**
             * Event fired when a header cell context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellContextMenu(e: Event): void;
            /**
             * Event fired when a header cell is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a header cell.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderCellMouseOver(e: Event): void;
            /**
             * Event fired when the grid header is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderClick(e: Event): void;
            /**
             * Event fired when the grid header context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderContextMenu(e: Event): void;
            /**
             * Event fired when the grid header is double clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderDblClick(e: Event): void;
            /**
             * Top level handler for header events
             * 
             * @param e             
             */
            onHeaderEvent(e: any): void;
            /**
             * Event fired when mouse moves out of the grid header.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over the grid header.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onHeaderMouseOver(e: Event): void;
            /**
             * Called when another widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onHide(): void;
            /**
             * 
             * @param e             
             */
            onKeyDown(e: any): void;
            /**
             * top level handler for Key Events
             * 
             * @param e             
             */
            onKeyEvent(e: any): void;
            /**
             * Connect to this function to receive notifications of printable keys being typed.
             * 
             * @param event key Event             
             */
            onKeyPress(event: any): void;
            /**
             * Connect to this function to receive notifications of keys being released.
             * 
             * @param event key Event             
             */
            onKeyUp(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is pressed down.
             * 
             * @param event mouse Event             
             */
            onMouseDown(event: any): void;
            /**
             * Event fired when mouse is down inside grid row
             * 
             * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
             */
            onMouseDownRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto this widget.
             * 
             * @param event mouse Event             
             */
            onMouseEnter(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of this widget.
             * 
             * @param event mouse Event             
             */
            onMouseLeave(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseMove(event: any): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOut(event: any): void;
            /**
             * Event fired when mouse moves out of any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOutRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
             * 
             * @param event mouse Event             
             */
            onMouseOver(event: any): void;
            /**
             * Event fired when mouse is over any row (data or header).
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onMouseOverRow(e: Event): void;
            /**
             * Connect to this function to receive notifications of when the mouse button is released.
             * 
             * @param event mouse Event             
             */
            onMouseUp(event: any): void;
            /**
             * 
             */
            onMoveColumn(): void;
            /**
             * 
             * @param cellIdx             
             */
            onResizeColumn(cellIdx: number): void;
            /**
             * Event fired when a row is clicked.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowClick(e: Event): void;
            /**
             * Event fired when a row context menu is accessed via mouse right click.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowContextMenu(e: Event): void;
            /**
             * Event fired when a row is double clicked.
             * 
             * @param e decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowDblClick(e: Event): void;
            /**
             * Event fired when mouse is down in a row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseDown(e: Event): void;
            /**
             * Event fired when mouse moves out of a data row.
             * 
             * @param e Decorated event object contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOut(e: Event): void;
            /**
             * Event fired when mouse moves over a data row.
             * 
             * @param e Decorated event object which contains reference to grid, cell, and rowIndex             
             */
            onRowMouseOver(e: Event): void;
            /**
             * Event fired when a grid row is selected
             * 
             * @param inRowIndex Index of the grid row             
             */
            onSelected(inRowIndex: number): void;
            /**
             * 
             */
            onSelectionChanged(): void;
            /**
             * Event fired when a default state being set.
             * 
             */
            onSetState(): void;
            /**
             * Called when this widget becomes the selected pane in a
             * dijit/layout/TabContainer, dijit/layout/StackContainer,
             * dijit/layout/AccordionContainer, etc.
             * 
             * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
             * 
             */
            onShow(): void;
            /**
             * Event fired when editing is started for a given grid cell
             * 
             * @param inCell Cell object containing properties of the grid column.             
             * @param inRowIndex Index of the grid row             
             */
            onStartEdit(inCell: Object, inRowIndex: number): void;
            /**
             * 
             * @param row             
             */
            onStyleRow(row: any): void;
        }
        module _CheckBoxSelector {
        }

        module _RadioSelector {
        }

        module bidi {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/bidi/_BidiMixin.html
             *
             * Module that deals with BIDI for Grid
             * There's a special need for displaying BIDI text in rtl direction in ltr GUI, or sometimes needed auto support.
             * "textDir" attribute should be set on Grid so that this class can be activated and responsible for text direction
             * Allowed values:
             * 1. "ltr"
             * 2. "rtl"
             * 3. "auto" - contextual the direction of a text defined by first strong letter.
             * By default the same as the page direction.
             * 
             */
            interface _BidiMixin {
            }
        }

        module BidiSupport {
        }

        module cells {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/_base.html
             *
             * Represents a grid cell and contains information about column options and methods
             * for retrieving cell related information.
             * Each column in a grid layout has a cell object and most events and many methods
             * provide access to these objects.
             * 
             * @param inProps     
             */
            class _base {
                constructor(inProps: any);
                /**
                 * 
                 */
                "alwaysEditing": boolean;
                /**
                 * 
                 */
                "classes": string;
                /**
                 * 
                 */
                "defaultValue": string;
                /**
                 * 
                 */
                "draggable": boolean;
                /**
                 * 
                 */
                "editable": boolean;
                /**
                 * 
                 */
                "formatter": Object;
                /**
                 * 
                 */
                "hidden": boolean;
                /**
                 * 
                 */
                "noresize": boolean;
                /**
                 * 
                 */
                "styles": string;
                /**
                 * 
                 */
                "value": Object;
                /**
                 * 
                 */
                AlwaysEdit(): void;
                /**
                 * apply edit from cell editor
                 * 
                 * @param inRowIndex grid row index             
                 */
                apply(inRowIndex: number): void;
                /**
                 * 
                 * @param inValue             
                 * @param inRowIndex             
                 */
                applyEdit(inValue: any, inRowIndex: any): void;
                /**
                 * 
                 */
                Bool(): void;
                /**
                 * cancel cell edit
                 * 
                 * @param inRowIndex grid row index             
                 */
                cancel(inRowIndex: number): void;
                /**
                 * 
                 * @param inRowIndex             
                 */
                cancelEdit(inRowIndex: any): void;
                /**
                 * 
                 */
                cancelFormatNode(): void;
                /**
                 * 
                 */
                canResize(): any;
                /**
                 * 
                 */
                Cell(): void;
                /**
                 * 
                 * @param m             
                 * @param e             
                 */
                dispatchEvent(m: any, e: any): any;
                /**
                 * focus the grid editor
                 * 
                 * @param inRowIndex grid row index             
                 * @param inNode editor node             
                 */
                focus(inRowIndex: number, inNode: any): void;
                /**
                 * provides the html for a given grid cell.
                 * 
                 * @param inRowIndex grid row index             
                 * @param inItem             
                 */
                format(inRowIndex: number, inItem: any): any;
                /**
                 * formats the cell for editing
                 * 
                 * @param inDatum cell data to edit             
                 * @param inRowIndex grid row index             
                 */
                formatEditing(inDatum: any, inRowIndex: number): any;
                /**
                 * format the editing dom node. Use when editor is a widget.
                 * 
                 * @param inNode dom node for the editor             
                 * @param inDatum cell data to edit             
                 * @param inRowIndex grid row index             
                 */
                formatNode(inNode: any, inDatum: any, inRowIndex: number): void;
                /**
                 * 
                 * @param inRowIndex             
                 */
                getEditNode(inRowIndex: any): number;
                /**
                 * 
                 */
                getHeaderNode(): any;
                /**
                 * gets the dom node for a given grid cell.
                 * 
                 * @param inRowIndex grid row index             
                 */
                getNode(inRowIndex: number): any;
                /**
                 * returns value entered into editor
                 * 
                 * @param inRowIndex grid row index             
                 */
                getValue(inRowIndex: number): any;
                /**
                 * 
                 */
                isFlex(): any;
                /**
                 * 
                 * @param node             
                 * @param cellDef             
                 */
                markupFactory(node: any, cellDef: any): void;
                /**
                 * 
                 * @param inDatum             
                 * @param inRowIndex             
                 */
                needFormatNode(inDatum: any, inRowIndex: any): void;
                /**
                 * 
                 * @param inNode             
                 * @param inRowIndex             
                 */
                registerOnBlur(inNode: any, inRowIndex: any): void;
                /**
                 * restore editor state
                 * 
                 * @param inRowIndex grid row index             
                 */
                restore(inRowIndex: number): void;
                /**
                 * 
                 */
                RowIndex(): void;
                /**
                 * save editor state
                 * 
                 * @param inRowIndex grid row index             
                 */
                save(inRowIndex: number): void;
                /**
                 * 
                 */
                Select(): void;
                /**
                 * set the value of the grid editor
                 * 
                 * @param inRowIndex grid row index             
                 * @param inValue value of editor             
                 */
                setValue(inRowIndex: number, inValue: any): void;
            }
            module _base {
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/_base.Cell.html
                 *
                 * grid cell that provides a standard text input box upon editing
                 * 
                 */
                class Cell {
                    constructor();
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * 
                     */
                    "KEY_HANDLER": string;
                    /**
                     * optional regex for disallowing keypresses
                     * 
                     */
                    "keyFilter": RegExp;
                    /**
                     * 
                     */
                    "LRE": string;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "PDF": string;
                    /**
                     * 
                     */
                    "RLE": string;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param e             
                     */
                    doKey(e: any): void;
                    /**
                     * focus the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inNode editor node             
                     */
                    focus(inRowIndex: number, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * returns value entered into editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getValue(inRowIndex: number): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cellDef             
                     */
                    markupFactory(node: any, cellDef: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * set the value of the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inValue value of editor             
                     */
                    setValue(inRowIndex: number, inValue: any): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/_base.AlwaysEdit.html
                 *
                 * grid cell that is always in an editable state, regardless of grid editing state
                 * 
                 */
                class AlwaysEdit {
                    constructor();
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * optional regex for disallowing keypresses
                     * 
                     */
                    "keyFilter": RegExp;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    applyStaticValue(inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param e             
                     */
                    doKey(e: any): void;
                    /**
                     * focus the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inNode editor node             
                     */
                    focus(inRowIndex: number, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * returns value entered into editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getValue(inRowIndex: number): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * set the value of the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inValue value of editor             
                     */
                    setValue(inRowIndex: number, inValue: any): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/_base.Bool.html
                 *
                 * grid cell that provides a standard checkbox that is always on for editing
                 * 
                 */
                class Bool {
                    constructor();
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * optional regex for disallowing keypresses
                     * 
                     */
                    "keyFilter": RegExp;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    applyStaticValue(inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param e             
                     */
                    doclick(e: any): void;
                    /**
                     * 
                     * @param e             
                     */
                    doKey(e: any): void;
                    /**
                     * focus the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inNode editor node             
                     */
                    focus(inRowIndex: number, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * returns value entered into editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getValue(inRowIndex: number): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * set the value of the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inValue value of editor             
                     */
                    setValue(inRowIndex: number, inValue: any): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/_base.RowIndex.html
                 *
                 * 
                 */
                class RowIndex {
                    constructor();
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * optional regex for disallowing keypresses
                     * 
                     */
                    "keyFilter": RegExp;
                    /**
                     * 
                     */
                    "name": string;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param e             
                     */
                    doKey(e: any): void;
                    /**
                     * focus the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inNode editor node             
                     */
                    focus(inRowIndex: number, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    get(inRowIndex: any): number;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * returns value entered into editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getValue(inRowIndex: number): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cellDef             
                     */
                    markupFactory(node: any, cellDef: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    postscript(): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * set the value of the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inValue value of editor             
                     */
                    setValue(inRowIndex: number, inValue: any): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/_base.Select.html
                 *
                 * grid cell that provides a standard select for editing
                 * 
                 * @param inCell     
                 */
                class Select {
                    constructor(inCell: any);
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * optional regex for disallowing keypresses
                     * 
                     */
                    "keyFilter": RegExp;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * text of each item
                     * 
                     */
                    "options": any[];
                    /**
                     * editor returns only the index of the selected option and not the value
                     * 
                     */
                    "returnIndex": number;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * value for each item
                     * 
                     */
                    "values": any[];
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param e             
                     */
                    doKey(e: any): void;
                    /**
                     * focus the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inNode editor node             
                     */
                    focus(inRowIndex: number, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getValue(inRowIndex: any): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * set the value of the grid editor
                     * 
                     * @param inRowIndex grid row index             
                     * @param inValue value of editor             
                     */
                    setValue(inRowIndex: number, inValue: any): void;
                }
            }

            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/dijit.html
             *
             * 
             */
            interface dijit {
                /**
                 * 
                 */
                CheckBox(): void;
                /**
                 * 
                 */
                ComboBox(): void;
                /**
                 * 
                 */
                DateTextBox(): void;
                /**
                 * 
                 */
                Editor(): void;
            }
            module dijit {
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/dijit._Widget.html
                 *
                 * 
                 * @param inCell     
                 */
                class _Widget extends dojox.grid.cells._base {
                    constructor(inCell: any);
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "getWidgetPropsCallOrig": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    attachWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    createWidget(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inNode             
                     */
                    focus(inRowIndex: any, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getValue(inRowIndex: any): any;
                    /**
                     * 
                     * @param inDatum             
                     */
                    getWidgetProps(inDatum: any): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inValue             
                     */
                    setValue(inRowIndex: any, inValue: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    sizeWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    widgetClass(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/dijit.CheckBox.html
                 *
                 * 
                 * @param inCell     
                 */
                class CheckBox extends dojox.grid.cells._base {
                    constructor(inCell: any);
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    attachWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    createWidget(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inNode             
                     */
                    focus(inRowIndex: any, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * 
                     */
                    getValue(): any;
                    /**
                     * 
                     * @param inDatum             
                     */
                    getWidgetProps(inDatum: any): Object;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inValue             
                     */
                    setValue(inRowIndex: any, inValue: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    sizeWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    widgetClass(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/dijit.Editor.html
                 *
                 * 
                 * @param inCell     
                 */
                class Editor extends dojox.grid.cells._base {
                    constructor(inCell: any);
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    attachWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    createWidget(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inNode             
                     */
                    focus(inRowIndex: any, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getValue(inRowIndex: any): any;
                    /**
                     * 
                     * @param inDatum             
                     */
                    getWidgetProps(inDatum: any): Object;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    populateEditor(): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inValue             
                     */
                    setValue(inRowIndex: any, inValue: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    sizeWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    widgetClass(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/dijit.DateTextBox.html
                 *
                 * 
                 * @param inCell     
                 */
                class DateTextBox extends dojox.grid.cells._base {
                    constructor(inCell: any);
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    attachWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    createWidget(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inNode             
                     */
                    focus(inRowIndex: any, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getValue(inRowIndex: any): any;
                    /**
                     * 
                     * @param inDatum             
                     */
                    getWidgetProps(inDatum: any): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inValue             
                     */
                    setValue(inRowIndex: any, inValue: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    sizeWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    widgetClass(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/dijit.ComboBox.html
                 *
                 * 
                 * @param inCell     
                 */
                class ComboBox extends dojox.grid.cells._base {
                    constructor(inCell: any);
                    /**
                     * 
                     */
                    "alwaysEditing": boolean;
                    /**
                     * 
                     */
                    "classes": string;
                    /**
                     * 
                     */
                    "defaultValue": string;
                    /**
                     * 
                     */
                    "draggable": boolean;
                    /**
                     * 
                     */
                    "editable": boolean;
                    /**
                     * 
                     */
                    "formatter": Object;
                    /**
                     * 
                     */
                    "getWidgetPropsCallOrig": Object;
                    /**
                     * 
                     */
                    "hidden": boolean;
                    /**
                     * 
                     */
                    "noresize": boolean;
                    /**
                     * 
                     */
                    "styles": string;
                    /**
                     * 
                     */
                    "value": Object;
                    /**
                     * apply edit from cell editor
                     * 
                     * @param inRowIndex grid row index             
                     */
                    apply(inRowIndex: number): void;
                    /**
                     * 
                     * @param inValue             
                     * @param inRowIndex             
                     */
                    applyEdit(inValue: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    attachWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * cancel cell edit
                     * 
                     * @param inRowIndex grid row index             
                     */
                    cancel(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    cancelEdit(inRowIndex: any): void;
                    /**
                     * 
                     */
                    cancelFormatNode(): void;
                    /**
                     * 
                     */
                    canResize(): any;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    createWidget(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param m             
                     * @param e             
                     */
                    dispatchEvent(m: any, e: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inNode             
                     */
                    focus(inRowIndex: any, inNode: any): void;
                    /**
                     * provides the html for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     * @param inItem             
                     */
                    format(inRowIndex: number, inItem: any): any;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatEditing(inDatum: any, inRowIndex: any): String;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    formatNode(inNode: any, inDatum: any, inRowIndex: any): any;
                    /**
                     * 
                     * @param inRowIndex             
                     */
                    getEditNode(inRowIndex: any): number;
                    /**
                     * 
                     */
                    getHeaderNode(): any;
                    /**
                     * gets the dom node for a given grid cell.
                     * 
                     * @param inRowIndex grid row index             
                     */
                    getNode(inRowIndex: number): any;
                    /**
                     * 
                     */
                    getValue(): any;
                    /**
                     * 
                     * @param inDatum             
                     */
                    getWidgetProps(inDatum: any): any;
                    /**
                     * 
                     */
                    isFlex(): any;
                    /**
                     * 
                     * @param node             
                     * @param cell             
                     */
                    markupFactory(node: any, cell: any): void;
                    /**
                     * 
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    needFormatNode(inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inRowIndex             
                     */
                    registerOnBlur(inNode: any, inRowIndex: any): void;
                    /**
                     * restore editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    restore(inRowIndex: number): void;
                    /**
                     * save editor state
                     * 
                     * @param inRowIndex grid row index             
                     */
                    save(inRowIndex: number): void;
                    /**
                     * 
                     * @param inRowIndex             
                     * @param inValue             
                     */
                    setValue(inRowIndex: any, inValue: any): void;
                    /**
                     * 
                     * @param inNode             
                     * @param inDatum             
                     * @param inRowIndex             
                     */
                    sizeWidget(inNode: any, inDatum: any, inRowIndex: any): void;
                    /**
                     * 
                     */
                    widgetClass(): void;
                }
            }

            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/cells/tree.html
             *
             * 
             */
            interface tree {
                /**
                 * 
                 * @param inItem             
                 * @param level             
                 * @param inRowIndexes             
                 */
                formatAggregate(inItem: any, level: any, inRowIndexes: any): any;
                /**
                 * 
                 * @param inRowIndexes             
                 * @param inItem             
                 * @param level             
                 * @param summaryRow             
                 * @param toggleClass             
                 * @param cellClasses             
                 */
                formatAtLevel(inRowIndexes: any, inItem: any, level: any, summaryRow: any, toggleClass: any, cellClasses: any): String;
                /**
                 * 
                 * @param inRowIndexes             
                 * @param inItem             
                 */
                formatIndexes(inRowIndexes: any, inItem: any): any;
                /**
                 * 
                 * @param itemId             
                 */
                getOpenState(itemId: any): any;
            }
        }

        module enhanced {
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/_Plugin.html
             *
             * Base class for all plugins.
             * Provides common plugin functionality and basic life cycle management.
             * 
             * Each concrete plugin must have a name field and is responsible for registering itself to the global plugin registry
             * e.g. for dnd plugin:
             * 
             * dojox.grid.EnhancedGrid.registerPlugin("dnd" //plugin name//,
             *                                         dojox.grid.enhanced.plugins.DnD //full class name of a plugin//
             *                                         {"preInit": false, "dependency": ["nestedSorting"]} //properties//);
             * [Keywords] of plugin properties (case sensitive):
             * 
             * "preInit": boolean, whether a plugin should be created before EnhancedGrid.postCreate(),
             *  false by default(plugins are created after EnhancedGrid.postCreate()).
             * "dependency": array or string, plugin(s) indicated by "dependency" will be created before the current one.
             *  Note: recursive cycle dependencies are not supported e.g. following dependency is invalid:
             *  pluginA -> pluginB -> pluginA
             * 
             * @param inGrid The grid to plug in to.     
             * @param option     
             */
            class _Plugin {
                constructor(inGrid: dojox.grid.EnhancedGrid, option: any);
                /**
                 * Grid that the plugin belongs to
                 * 
                 */
                "grid": Object;
                /**
                 * Plugin name, e.g. 'nestedSorting', 'dnd'...
                 * 
                 */
                "name": string;
                /**
                 * Plugin properties - leveraged with default and user specified properties.
                 * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                 * 
                 */
                "option": Object;
                /**
                 * Private properties/methods shouldn't be mixin-ed anytime.
                 * 
                 */
                "privates": Object;
                /**
                 * Connects specified obj/event to specified method of this object.
                 * 
                 * @param obj             
                 * @param event             
                 * @param method             
                 */
                connect(obj: any, event: any, method: any): any;
                /**
                 * Destroy all resources.
                 * 
                 */
                destroy(): void;
                /**
                 * Disconnects handle and removes it from connection list.
                 * 
                 * @param handle             
                 */
                disconnect(handle: any): void;
                /**
                 * 
                 */
                init(): void;
                /**
                 * Subscribes to the specified topic and calls the specified method
                 * of this object.
                 * 
                 * @param topic             
                 * @param method             
                 */
                subscribe(topic: any, method: any): any;
                /**
                 * Un-subscribes handle and removes it from subscriptions list.
                 * 
                 * @param handle             
                 */
                unsubscribe(handle: any): void;
                /**
                 * 
                 */
                onPostInit(): void;
                /**
                 * 
                 */
                onPreInit(): void;
                /**
                 * Called when store is changed.
                 * 
                 * @param store             
                 */
                onSetStore(store: any): void;
                /**
                 * 
                 */
                onStartUp(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/_Events.html
             *
             * Overwrite some default events of DataGrid
             * Methods are copied or replaced for overwriting, this might be refined once
             * an overall plugin architecture is set up for DataGrid.
             * 
             * @param inGrid     
             */
            class _Events {
                constructor(inGrid: any);
                /**
                 * css class to apply to grid content cells when activated(mouse down)
                 * 
                 */
                "cellActiveClass": string;
                /**
                 * css class to apply to grid header cells when activated(mouse down)
                 * 
                 */
                "headerCellActiveClass": string;
                /**
                 * css class to apply to grid rows when activated(mouse down)
                 * 
                 */
                "rowActiveClass": string;
                /**
                 * Grid key up event handler.
                 * 
                 * @param e Un-decorated event object             
                 */
                dokeyup(e: Event): void;
                /**
                 * 
                 * @param e             
                 */
                domousedown(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                domouseup(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onCellClick()
                 * 
                 * @param e             
                 */
                onCellClick(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onCellDblClick()
                 * 
                 * @param e             
                 */
                onCellDblClick(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onCellMouseDown()
                 * 
                 * @param e             
                 */
                onCellMouseDown(e: any): void;
                /**
                 * New - Event fired when mouse is up inside content cell.
                 * 
                 * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
                 */
                onCellMouseUp(e: Event): void;
                /**
                 * Overwritten, see dojox.grid._Events.onHeaderCellClick()
                 * 
                 * @param e             
                 */
                onHeaderCellClick(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onHeaderCellMouseDown()
                 * 
                 * @param e             
                 */
                onHeaderCellMouseDown(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onHeaderCellMouseOut()
                 * 
                 * @param e             
                 */
                onHeaderCellMouseOut(e: any): void;
                /**
                 * New event
                 * 
                 * @param e             
                 */
                onHeaderCellMouseUp(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onKeyDown();
                 * 
                 * @param e             
                 */
                onKeyDown(e: any): void;
                /**
                 * New - Event fired when mouse is up inside grid.
                 * 
                 * @param e Decorated event object that contains reference to grid, cell, and rowIndex             
                 */
                onMouseUp(e: Event): void;
                /**
                 * 
                 * @param e             
                 */
                onMouseUpRow(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onRowClick()
                 * 
                 * @param e             
                 */
                onRowClick(e: any): void;
                /**
                 * Overwritten, see dojox.grid._Events.onRowContextMenu()
                 * 
                 * @param e             
                 */
                onRowContextMenu(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                onRowMouseUp(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                onRowSelectorMouseDown(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                onRowSelectorMouseUp(e: any): void;
                /**
                 * New - Event fired when a selected region context menu is accessed via mouse right click.
                 * 
                 * @param e Decorated event object which contains reference to grid and info of selectedregions(selection type - row|column, selected index - [...])             
                 */
                onSelectedRegionContextMenu(e: Event): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/_PluginManager.html
             *
             * Singleton plugin manager
             * Plugin manager is responsible for:
             * 
             * Loading required plugins
             * Handling collaboration and dependencies among plugins
             * Some plugin dependencies:
             * 
             * "columnReordering" attribute won't work when either DnD or Indirect Selections plugin is on.
             * 
             * @param inGrid     
             */
            class _PluginManager {
                constructor(inGrid: any);
                /**
                 * 
                 */
                "registry": string;
                /**
                 * Destroy all resources
                 * 
                 */
                destroy(): void;
                /**
                 * 
                 * @param func             
                 * @param args             
                 */
                forEach(func: any, args: any): void;
                /**
                 * Get plugin("name")
                 * 
                 * @param name Plugin name             
                 */
                getPlugin(name: String): any;
                /**
                 * Load target plugin which must be already required (require(..))
                 * 
                 * @param clazz Plugin class             
                 */
                getPluginClazz(clazz: Function): any;
                /**
                 * Load target plugin which must be already required (require(..))
                 * 
                 * @param clazz Plugin class             
                 */
                getPluginClazz(clazz: String): any;
                /**
                 * See if target cell(column) is fixed or not.
                 * 
                 * @param cell Target cell(column)             
                 */
                isFixedCell(cell: Object): any;
                /**
                 * Load required plugin("name")
                 * 
                 * @param name Plugin name             
                 */
                loadPlugin(name: String): any;
                /**
                 * Check if plugin("name") existed
                 * 
                 * @param name Plugin name             
                 */
                pluginExisted(name: String): any;
                /**
                 * Load plugins after DataGrid.postCreate() - the default phase when plugins are created
                 * See EnhancedGrid.postCreate()
                 * 
                 */
                postInit(): void;
                /**
                 * Load appropriate plugins before DataGrid.postCreate().
                 * See EnhancedGrid.postCreate()
                 * 
                 */
                preInit(): void;
                /**
                 * Register plugins - TODO, a better way rather than global registry?
                 * 
                 * @param clazz Full class name, e.g. "dojox.grid.enhanced.plugins.DnD"             
                 * @param props               OptionalPlugin properties e.g. {"dependency": ["nestedSorting"], ...}             
                 */
                registerPlugin(clazz: String, props: Object): void;
                /**
                 * 
                 */
                startup(): void;
            }
            /**
             * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/_FocusManager.html
             *
             * 
             * @param grid     
             */
            class _FocusManager extends dojox.grid._FocusManager {
                constructor(grid: any);
                /**
                 * 
                 */
                "focusClass": string;
                /**
                 * 
                 */
                "focusView": Object;
                /**
                 * 
                 */
                "tabbingOut": boolean;
                /**
                 * 
                 * @param area             
                 */
                addArea(area: any): void;
                /**
                 * 
                 */
                blurHeader(): void;
                /**
                 * 
                 * @param e             
                 * @param colIdx             
                 * @param delta             
                 */
                colSizeAdjust(e: any, colIdx: any, delta: any): void;
                /**
                 * 
                 * @param evt             
                 */
                contentMouseEvent(evt: any): void;
                /**
                 * Set current area to the one areaName refers.
                 * 
                 * @param areaName             
                 * @param toBlurOld             
                 */
                currentArea(areaName: String, toBlurOld: any): any;
                /**
                 * 
                 */
                destroy(): void;
                /**
                 * 
                 * @param e             
                 */
                doBlur(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                doColHeaderBlur(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                doColHeaderFocus(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                doContextMenu(e: any): void;
                /**
                 * Overwritten
                 * trap focus only for grid dom node
                 * do not focus for scrolling if grid is about to blur
                 * 
                 * @param e             
                 */
                doFocus(e: any): void;
                /**
                 * 
                 * @param e             
                 */
                doLastNodeBlur(e: any): void;
                /**
                 * Overwritten
                 * 
                 * @param e             
                 */
                doLastNodeFocus(e: any): void;
                /**
                 * Overwritten
                 * 
                 */
                findAndFocusGridCell(): void;
                /**
                 * 
                 * @param areaId             
                 * @param evt             
                 */
                focusArea(areaId?: number, evt?: any): boolean;
                /**
                 * 
                 * @param areaId             
                 * @param evt             
                 */
                focusArea(areaId: String, evt: any): void;
                /**
                 * 
                 * @param areaId             
                 * @param evt             
                 */
                focusArea(areaId: Object, evt: any): void;
                /**
                 * 
                 * @param inSkipFocusCell             
                 */
                focusGrid(inSkipFocusCell: any): void;
                /**
                 * 
                 */
                focusGridView(): void;
                /**
                 * 
                 * @param evt             
                 * @param step             
                 */
                focusHeader(evt?: any, step?: any): boolean;
                /**
                 * 
                 * @param areaName             
                 */
                getArea(areaName: any): any;
                /**
                 * if one of the column headers currently has focus, return its index.
                 * 
                 */
                getHeaderIndex(): any;
                /**
                 * 
                 * @param evt             
                 */
                headerMouseEvent(evt: any): void;
                /**
                 * 
                 * @param name             
                 */
                ignoreArea(name: any): void;
                /**
                 * Overwritten
                 * 
                 */
                initFocusView(): void;
                /**
                 * 
                 */
                isFirstFocusCell(): boolean;
                /**
                 * states if the given cell is focused
                 * 
                 * @param inCell grid cell object             
                 * @param inRowIndex grid row index             
                 */
                isFocusCell(inCell: Object, inRowIndex: number): any;
                /**
                 * 
                 */
                isLastFocusCell(): boolean;
                /**
                 * Overwritten
                 * Check whether currently navigating among column headers.
                 * 
                 */
                isNavHeader(): any;
                /**
                 * 
                 */
                isNoFocusCell(): boolean;
                /**
                 * focus grid cell or  simulate focus to column header based on position relative to current focus
                 * 
                 * @param inRowDelta vertical distance from current focus             
                 * @param inColDelta horizontal distance from current focus             
                 */
                move(inRowDelta: number, inColDelta: number): void;
                /**
                 * focus next grid cell
                 * 
                 */
                next(): void;
                /**
                 * Overwritten
                 * 
                 * @param e             
                 */
                nextKey(e: any): void;
                /**
                 * Place the area refered by name at some logical position relative to an existing area.
                 * 
                 * @param name             
                 * @param pos             
                 * @param otherAreaName             
                 */
                placeArea(name: any, pos: any, otherAreaName: any): void;
                /**
                 * focus previous grid cell
                 * 
                 */
                previous(): void;
                /**
                 * Overwritten
                 * 
                 * @param e             
                 */
                previousKey(e: any): void;
                /**
                 * 
                 * @param areaName             
                 */
                removeArea(areaName: any): void;
                /**
                 * 
                 */
                scrollIntoView(): any;
                /**
                 * Overwritten - focuses the given grid cell
                 * 
                 * @param inCell             
                 * @param inRowIndex             
                 */
                setFocusCell(inCell: Object, inRowIndex: number): void;
                /**
                 * focuses the given grid cell
                 * 
                 * @param inRowIndex grid row index             
                 * @param inCellIndex grid cell index             
                 */
                setFocusIndex(inRowIndex: number, inCellIndex: number): void;
                /**
                 * 
                 * @param inRow             
                 */
                styleRow(inRow: any): void;
                /**
                 * 
                 * @param step             
                 * @param evt             
                 */
                tab(step: any, evt: any): void;
                /**
                 * 
                 * @param inFocusNode             
                 */
                tabOut(inFocusNode: any): void;
            }
            module plugins {
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/_SelectionPreserver.html
                 *
                 * Preserve selections across various user actions.
                 * Extends dojox.grid._SelectionPreserver adding a bit more support to make selection persistence working well
                 * with various EnhancedGrid features, e.g. filtering, nested sorting, pagination, select all etc.
                 * 
                 * Precondition - Identifier(id) is required for store, as id is used for differentiating row items.
                 * Known issue - The preserved selections might be inaccurate if some unloaded rows are previously selected by range(e.g.SHIFT + click)
                 * 
                 * @param selection     
                 */
                class _SelectionPreserver extends dojox.grid._SelectionPreserver {
                    constructor(selection: any);
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * 
                     */
                    reset(): void;
                    /**
                     * 
                     * @param id             
                     * @param rowIndex             
                     * @param value             
                     */
                    onSelectedById(id: any, rowIndex: any, value: any): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/_RowMapLayer.html
                 *
                 * 
                 * @param grid     
                 */
                class _RowMapLayer {
                    constructor(grid: any);
                    /**
                     * 
                     */
                    "layerFuncName": string;
                    /**
                     * 
                     */
                    "tags": any[];
                    /**
                     * 
                     */
                    clearMapping(): void;
                    /**
                     * The get/set function of the enabled status of this layer
                     * 
                     * @param toEnable               OptionalIf given, is a setter, otherwise, it's getter.             
                     */
                    enabled(toEnable: boolean): boolean;
                    /**
                     * 
                     * @param store             
                     */
                    initialize(store: any): void;
                    /**
                     * 
                     */
                    invalidate(): void;
                    /**
                     * Get the name of this store layer.
                     * The default name retrieved from class name, which should have a pattern of "{name}Layer".
                     * If this pattern does not exist, the whole class name will be this layer's name.
                     * It's better to override this method if your class name is too complicated.
                     * 
                     */
                    name(): any;
                    /**
                     * 
                     */
                    originFetch(): any;
                    /**
                     * Remember the row mapping.
                     * 
                     * @param mapping keys are original rowIndexes, values are new rowIndexes.             
                     */
                    setMapping(mapping: Object): void;
                    /**
                     * 
                     */
                    uninitialize(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/AutoScroll.html
                 *
                 * Provides horizontal and vertical auto-scroll for grid.
                 * 
                 * @param grid     
                 * @param args     
                 */
                class AutoScroll extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * The time interval (in miliseconds) between 2 scrolling.
                     * 
                     */
                    "autoScrollInterval": number;
                    /**
                     * The width (in pixel) of the margin area where autoscroll can be triggered.
                     * 
                     */
                    "autoScrollMargin": number;
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Destroy all resources.
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Cookie.html
                 *
                 * This plugin provides a way to persist some grid features in cookie.
                 * Default persistable features are:
                 * column width:   "columnWidth" (handler name)
                 * column order:   "columnOrder"
                 * sorting order:  "sortOrder"
                 * 
                 * Grid users can define new persistable features
                 * by calling the following before grid is initialized (that is, during "preInit");
                 * 
                 * grid.addCookieHandler({
                 *     name: "a name for the new persistable feature",
                 *     onLoad: function(savedObject, grid){
                 *         //load the cookie.
                 *     },
                 *     onSave: function(grid){
                 *         //save the cookie.
                 *     }
                 * });
                 * 
                 * @param grid     
                 * @param args     
                 */
                class Cookie extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * If a grid plugin wants cookie service, call this.
                     * This must be called during preInit.
                     * 
                     * @param args An object with the following structure:{    name: "some-string",    onLoad: // void // function(// object //partOfCookie, // EDG //grid){...},    onSave: // object // function(// EDG //grid){...}}             
                     */
                    addCookieHandler(args: Object): void;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * A getter to check cookie support of a particular Grid feature.
                     * 
                     * @param cookieName               OptionalName of a cookie handler if provided, otherwise for all cookies.             
                     */
                    getCookieEnabled(cookieName: String): any;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Remove cookie for this grid.
                     * 
                     */
                    removeCookie(): void;
                    /**
                     * A setter to enable|disable cookie support for a particular Grid feature.
                     * 
                     * @param cookieName               OptionalName of a cookie handler if provided, otherwise for all cookies.             
                     * @param enabled             
                     */
                    setCookieEnabled(cookieName: String, enabled: boolean): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/CellMerge.html
                 *
                 * This plugin provides functions to merge(un-merge) adjacent cells within one row.
                 * Acceptable plugin parameters:
                 * 
                 * mergedCells: Array: An array of objects with structure:
                 * {
                 *     row: function(Integer)|Integer
                 *         If it's a function, it's a predicate to decide which rows are to be merged.
                 *         It takes an integer (the row index), and should return true or false;
                 *     start: Integer
                 *         The column index of the left most cell that shall be merged.
                 *     end: Integer
                 *         The column index of the right most cell that shall be merged.
                 *     major: Integer
                 *         The column index of the cell whose content should be used as the content of the merged cell.
                 *         It must be larger than or equal to the startColumnIndex, and less than or equal to the endColumnIndex.
                 *         If it is omitted, the content of the leading edge (left-most for ltr, right most for rtl) cell will be used.
                 * }
                 * 
                 * @param grid     
                 * @param args     
                 */
                class CellMerge extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Destroy all resources.
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Get all records of currently merged cells.
                     * 
                     */
                    getMergedCells(): any;
                    /**
                     * Get the records of currently merged cells at the given row.
                     * 
                     * @param rowIndex             
                     */
                    getMergedCellsByRow(rowIndex: any): any;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Merge cells from startColumnIndex to endColumnIndex at rows that make rowTester return true,
                     * using the content of the cell at majorColumnIndex
                     * 
                     * @param rowTester If it's a function, it's a predicate to decide which rows are to be merged.It takes an integer (the row index), and should return true or false;             
                     * @param startColumnIndex The column index of the left most cell that shall be merged.             
                     * @param endColumnIndex The column index of the right most cell that shall be merged.             
                     * @param majorColumnIndex               OptionalThe column index of the cell whose content should be used as the content of the merged cell.It must be larger than or equal to the startColumnIndex, and less than or equal to the endColumnIndex.If it is omitted, the content of the leading edge (left-most for ltr, right most for rtl) cell will be used.             
                     */
                    mergeCells(rowTester: any, startColumnIndex: number, endColumnIndex: number, majorColumnIndex: number): any;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Unmerge the cells that are merged by the mergeHandler, which represents a call to the function mergeCells.
                     * 
                     * @param mergeHandler A handler for the merged cells created by a call of function mergeCells.             
                     */
                    unmergeCells(mergeHandler: Object): void;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Exporter.html
                 *
                 * Provide functions to export the grid data into a given format.
                 * 
                 * Acceptable plugin parameters:
                 * 
                 * exportFormatter: function(data, cell, rowIndex, item)
                 *  Provide a way to customize how data should look in exported string.
                 *  Note that usually the formatter of grid cell should not be used here (it can return HTML or even widget).
                 * 
                 * @param grid The grid to plug in to.     
                 * @param args     
                 */
                class Exporter extends dojox.grid.enhanced._Plugin {
                    constructor(grid: dojox.grid.EnhancedGrid, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name.
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * 
                     */
                    "writerNames": string;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Destroy all resources.
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Export required rows(fetchArgs) to a kind of format(type)
                     * using the corresponding writer with given arguments(writerArgs),
                     * then pass the exported text to a given function(onExported).
                     * 
                     * @param type A registered export format name             
                     * @param args               Optionalincludes:{    fetchArgs: object?        Any arguments for store.fetch    writerArgs: object?        Arguments for the given format writer}             
                     * @param onExported Call back function when export result is ready             
                     */
                    exportGrid(type: String, args: Object, onExported: any): void;
                    /**
                     * Only export selected rows.
                     * 
                     * @param type A registered export format name             
                     * @param writerArgs               OptionalArguments for the given format writer             
                     * @param onExported             
                     */
                    exportSelected(type: String, writerArgs: Object, onExported: any): any;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Register a writer(writerClsName) to a export format type(fileType).
                     * This function separates the Exporter from all kinds of writers.
                     * 
                     * @param fileType             
                     * @param writerClsName             
                     */
                    registerWriter(fileType: String, writerClsName: String): void;
                    /**
                     * 
                     * @param formatter             
                     */
                    setExportFormatter(formatter: any): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/DnD.html
                 *
                 * Provide drag and drop for grid columns/rows/cells within grid and out of grid.
                 * The store of grid must implement dojo.data.api.Write.
                 * 
                 * DnD selected columns:
                 * Support moving within grid, moving/copying out of grid to a non-grid DnD target.
                 * 
                 * DnD selected rows:
                 * Support moving within grid, moving/copying out of grid to any DnD target.
                 * 
                 * DnD selected cells (in rectangle shape only):
                 * Support moving/copying within grid, moving/copying out of grid to any DnD target.
                 * 
                 * @param grid     
                 * @param args     
                 */
                class DnD extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * plugin name;
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Setter/getter of this._copyOnly.
                     * 
                     * @param isCopyOnly             
                     */
                    copyOnly(isCopyOnly: any): boolean;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Configure which DnD functionalities are needed.
                     * Combination of any item from type set ("row", "col", "cell")
                     * and any item from mode set("within", "in", "out") is configurable.
                     * 
                     * "row", "col", "cell" are straightforward, while the other 3 are explained below:
                     * 
                     * "within": DnD within grid, that is, column/row reordering and cell moving/copying.
                     * "in": Whether allowed to accept rows/cells (currently not support columns) from another grid.
                     * "out": Whether allowed to drag out of grid, to another grid or even to any other DnD target.
                     * If not provided in the config, will use the default.
                     * When declared together, Mode set has higher priority than type set.
                     * 
                     * @param config DnD configuration object.See the examples below.             
                     */
                    setupConfig(config: Object): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     * @param sourcePlugin             
                     */
                    onDraggingOut(sourcePlugin: any): void;
                    /**
                     * 
                     * @param sourcePlugin             
                     */
                    onDraggingOver(sourcePlugin: any): void;
                    /**
                     * 
                     * @param sourcePlugin             
                     * @param isCopy             
                     */
                    onDragIn(sourcePlugin: any, isCopy: any): void;
                    /**
                     * 
                     * @param isMove             
                     */
                    onDragOut(isMove: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Filter.html
                 *
                 * Provide filter functionality for grid.
                 * 
                 * Acceptable plugin parameters:
                 * 
                 * itemsName: string:
                 *  the name shown on the filter bar.
                 * statusTipTimeout: number:
                 *  when does the status tip show.
                 * ruleCount: number:
                 *  default to 3, should not change to more. The Claro theme limits it.
                 * disabledConditions: object:
                 *  If you don't need all of the conditions provided for a data type,
                 *  you can explicitly declare them here:
                 *  e.g.: disabledConditions: {string: ["contains", "is"], number: ["equalto"], ...}
                 * isServerSide: boolean:
                 *  Whether to use server side filtering. Default to false.
                 * isStateful: boolean:
                 *  If isServerSide is true, set the server side filter to be stateful or not. default to false.
                 * url: string:
                 *  If using stateful, this is the url to send commands. default to store.url.
                 * ruleCountToConfirmClearFilter: Integer | null |Infinity:
                 *  If the filter rule count is larger than or equal to this value, then a confirm dialog will show when clearing filter.
                 *  If set to less than 1 or null, then always show the confirm dialog.
                 *  If set to Infinity, then never show the confirm dialog.
                 *  Default value is 2.
                 * Acceptable cell parameters defined in layout:
                 * 
                 * filterable: boolean:
                 *  The column is not filterable only when this is set to false explicitly.
                 * datatype: string:
                 *  The data type of this column. Can be "string", "number", "date", "time", "boolean".
                 *  Default to "string".
                 * autoComplete: boolean:
                 *  If need auto-complete in the ComboBox for String type, set this to true.
                 * dataTypeArgs: object:
                 *  Some arguments helping convert store data to something the filter UI understands.
                 *  Different data type arguments can be provided to different data types.
                 *  For date/time, this is a dojo.date.locale.__FormatOptions, so the DataTimeBox can understand the store data.
                 *  For boolean, this object contains:
                 * trueLabel: string:
                 *   A label to display in the filter definition dialog for true value. Default to "True".
                 * falseLabel: string:
                 *   A label to display in the filter definition dialog for false value. Default to "False".
                 * 
                 * disabledConditions: object:
                 *  If you don't need all of the conditions provided by the filter UI on this column, you can explicitly say it out here.
                 *  e.g.: disabledConditions: ["contains", "is"]
                 *  This will disable the "contains" condition for this column, if this column is of string type.
                 *  For full set of conditions, please refer to dojox.grid.enhanced.plugins.filter.FilterDefDialog._setupData.
                 * 
                 * 
                 * @param grid     
                 * @param args     
                 */
                class Filter extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Dialog.html
                 *
                 * 
                 * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
                 * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
                 */
                class Dialog extends dijit.Dialog {
                    constructor(params?: Object, srcNodeRef?: HTMLElement);
                    /**
                     * True if mouse was pressed while over this widget, and hasn't been released yet
                     * 
                     */
                    "active": boolean;
                    set(property: "active", value: boolean): void;
                    get(property: "active"): boolean;
                    watch(property: "active", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * Object to which attach points and events will be scoped.  Defaults
                     * to 'this'.
                     * 
                     */
                    "attachScope": Object;
                    set(property: "attachScope", value: Object): void;
                    get(property: "attachScope"): Object;
                    watch(property: "attachScope", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * Deprecated. Instead of attributeMap, widget should have a _setXXXAttr attribute
                     * for each XXX attribute to be mapped to the DOM.
                     * 
                     * attributeMap sets up a "binding" between attributes (aka properties)
                     * of the widget and the widget's DOM.
                     * Changes to widget attributes listed in attributeMap will be
                     * reflected into the DOM.
                     * 
                     * For example, calling set('title', 'hello')
                     * on a TitlePane will automatically cause the TitlePane's DOM to update
                     * with the new title.
                     * 
                     * attributeMap is a hash where the key is an attribute of the widget,
                     * and the value reflects a binding to a:
                     * 
                     * DOM node attribute
                     *   focus: {node: "focusNode", type: "attribute"}
                     * Maps this.focus to this.focusNode.focus
                     * 
                     * DOM node innerHTML
                     *   title: { node: "titleNode", type: "innerHTML" }
                     * Maps this.title to this.titleNode.innerHTML
                     * 
                     * DOM node innerText
                     *   title: { node: "titleNode", type: "innerText" }
                     * Maps this.title to this.titleNode.innerText
                     * 
                     * DOM node CSS class
                     *   myClass: { node: "domNode", type: "class" }
                     * Maps this.myClass to this.domNode.className
                     * 
                     * If the value is an array, then each element in the array matches one of the
                     * formats of the above list.
                     * 
                     * There are also some shorthands for backwards compatibility:
                     * 
                     * string --> { node: string, type: "attribute" }, for example:
                     * "focusNode" ---> { node: "focusNode", type: "attribute" }
                     * "" --> { node: "domNode", type: "attribute" }
                     * 
                     */
                    "attributeMap": Object;
                    set(property: "attributeMap", value: Object): void;
                    get(property: "attributeMap"): Object;
                    watch(property: "attributeMap", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * A Toggle to modify the default focus behavior of a Dialog, which
                     * is to focus on the first dialog element after opening the dialog.
                     * False will disable autofocusing. Default: true
                     * 
                     */
                    "autofocus": boolean;
                    set(property: "autofocus", value: boolean): void;
                    get(property: "autofocus"): boolean;
                    watch(property: "autofocus", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "baseClass": string;
                    set(property: "baseClass", value: string): void;
                    get(property: "baseClass"): string;
                    watch(property: "baseClass", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "class": string;
                    set(property: "class", value: string): void;
                    get(property: "class"): string;
                    watch(property: "class", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Dialog show [x] icon to close itself, and ESC key will close the dialog.
                     * 
                     */
                    "closable": boolean;
                    set(property: "closable", value: boolean): void;
                    get(property: "closable"): boolean;
                    watch(property: "closable", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * Designates where children of the source DOM node will be placed.
                     * "Children" in this case refers to both DOM nodes and widgets.
                     * For example, for myWidget:
                     * 
                     * <div data-dojo-type=myWidget>
                     *     <b> here's a plain DOM node
                     *     <span data-dojo-type=subWidget>and a widget</span>
                     *     <i> and another plain DOM node </i>
                     * </div>
                     * containerNode would point to:
                     * 
                     * <b> here's a plain DOM node
                     * <span data-dojo-type=subWidget>and a widget</span>
                     * <i> and another plain DOM node </i>
                     * In templated widgets, "containerNode" is set via a
                     * data-dojo-attach-point assignment.
                     * 
                     * containerNode must be defined for any widget that accepts innerHTML
                     * (like ContentPane or BorderContainer or even Button), and conversely
                     * is null for widgets that don't, like TextBox.
                     * 
                     */
                    "containerNode": HTMLElement;
                    set(property: "containerNode", value: HTMLElement): void;
                    get(property: "containerNode"): HTMLElement;
                    watch(property: "containerNode", callback: { (property?: string, oldValue?: HTMLElement, newValue?: HTMLElement): void }): { unwatch(): void }
                    /**
                     * The innerHTML of the ContentPane.
                     * Note that the initialization parameter / argument to set("content", ...)
                     * can be a String, DomNode, Nodelist, or _Widget.
                     * 
                     */
                    "content": string;
                    set(property: "content", value: string): void;
                    get(property: "content"): string;
                    watch(property: "content", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "cssStateNodes": Object;
                    set(property: "cssStateNodes", value: Object): void;
                    get(property: "cssStateNodes"): Object;
                    watch(property: "cssStateNodes", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * Bi-directional support, as defined by the HTML DIR
                     * attribute. Either left-to-right "ltr" or right-to-left "rtl".  If undefined, widgets renders in page's
                     * default direction.
                     * 
                     */
                    "dir": string;
                    set(property: "dir", value: string): void;
                    get(property: "dir"): string;
                    watch(property: "dir", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * 
                     * false - don't adjust size of children
                     * true - if there is a single visible child widget, set it's size to however big the ContentPane is
                     * 
                     */
                    "doLayout": boolean;
                    set(property: "doLayout", value: boolean): void;
                    get(property: "doLayout"): boolean;
                    watch(property: "doLayout", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * This is our visible representation of the widget! Other DOM
                     * Nodes may by assigned to other properties, usually through the
                     * template system's data-dojo-attach-point syntax, but the domNode
                     * property is the canonical "top level" node in widget UI.
                     * 
                     */
                    "domNode": HTMLElement;
                    set(property: "domNode", value: HTMLElement): void;
                    get(property: "domNode"): HTMLElement;
                    watch(property: "domNode", callback: { (property?: string, oldValue?: HTMLElement, newValue?: HTMLElement): void }): { unwatch(): void }
                    /**
                     * Toggles the movable aspect of the Dialog. If true, Dialog
                     * can be dragged by it's title. If false it will remain centered
                     * in the viewport.
                     * 
                     */
                    "draggable": boolean;
                    set(property: "draggable", value: boolean): void;
                    get(property: "draggable"): boolean;
                    watch(property: "draggable", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * The time in milliseconds it takes the dialog to fade in and out
                     * 
                     */
                    "duration": number;
                    set(property: "duration", value: number): void;
                    get(property: "duration"): number;
                    watch(property: "duration", callback: { (property?: string, oldValue?: number, newValue?: number): void }): { unwatch(): void }
                    /**
                     * Message that shows if an error occurs
                     * 
                     */
                    "errorMessage": string;
                    set(property: "errorMessage", value: string): void;
                    get(property: "errorMessage"): string;
                    watch(property: "errorMessage", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Extract visible content from inside of <body> .... </body>.
                     * I.e., strip <html> and <head> (and it's contents) from the href
                     * 
                     */
                    "extractContent": boolean;
                    set(property: "extractContent", value: boolean): void;
                    get(property: "extractContent"): boolean;
                    watch(property: "extractContent", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * This widget or a widget it contains has focus, or is "active" because
                     * it was recently clicked.
                     * 
                     */
                    "focused": boolean;
                    set(property: "focused", value: boolean): void;
                    get(property: "focused"): boolean;
                    watch(property: "focused", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * True if cursor is over this widget
                     * 
                     */
                    "hovering": boolean;
                    set(property: "hovering", value: boolean): void;
                    get(property: "hovering"): boolean;
                    watch(property: "hovering", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * The href of the content that displays now.
                     * Set this at construction if you want to load data externally when the
                     * pane is shown.  (Set preload=true to load it immediately.)
                     * Changing href after creation doesn't have any effect; Use set('href', ...);
                     * 
                     */
                    "href": string;
                    set(property: "href", value: string): void;
                    get(property: "href"): string;
                    watch(property: "href", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * A unique, opaque ID string that can be assigned by users or by the
                     * system. If the developer passes an ID which is known not to be
                     * unique, the specified ID is ignored and the system-generated ID is
                     * used instead.
                     * 
                     */
                    "id": string;
                    set(property: "id", value: string): void;
                    get(property: "id"): string;
                    watch(property: "id", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Parameters to pass to xhrGet() request, for example:
                     * 
                     * <div data-dojo-type="dijit/layout/ContentPane" data-dojo-props="href: './bar', ioArgs: {timeout: 500}">
                     * 
                     */
                    "ioArgs": Object;
                    set(property: "ioArgs", value: Object): void;
                    get(property: "ioArgs"): Object;
                    watch(property: "ioArgs", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * Indicates that this widget will call resize() on it's child widgets
                     * when they become visible.
                     * 
                     */
                    "isLayoutContainer": boolean;
                    set(property: "isLayoutContainer", value: boolean): void;
                    get(property: "isLayoutContainer"): boolean;
                    watch(property: "isLayoutContainer", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * True if the ContentPane has data in it, either specified
                     * during initialization (via href or inline content), or set
                     * via set('content', ...) / set('href', ...)
                     * 
                     * False if it doesn't have any content, or if ContentPane is
                     * still in the process of downloading href.
                     * 
                     */
                    "isLoaded": boolean;
                    set(property: "isLoaded", value: boolean): void;
                    get(property: "isLoaded"): boolean;
                    watch(property: "isLoaded", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * Rarely used.  Overrides the default Dojo locale used to render this widget,
                     * as defined by the HTML LANG attribute.
                     * Value must be among the list of locales specified during by the Dojo bootstrap,
                     * formatted according to RFC 3066 (like en-us).
                     * 
                     */
                    "lang": string;
                    set(property: "lang", value: string): void;
                    get(property: "lang"): string;
                    watch(property: "lang", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Message that shows while downloading
                     * 
                     */
                    "loadingMessage": string;
                    set(property: "loadingMessage", value: string): void;
                    get(property: "loadingMessage"): string;
                    watch(property: "loadingMessage", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Maximum size to allow the dialog to expand to, relative to viewport size
                     * 
                     */
                    "maxRatio": number;
                    set(property: "maxRatio", value: number): void;
                    get(property: "maxRatio"): number;
                    watch(property: "maxRatio", callback: { (property?: string, oldValue?: number, newValue?: number): void }): { unwatch(): void }
                    /**
                     * This is the dojo.Deferred returned by set('href', ...) and refresh().
                     * Calling onLoadDeferred.then() registers your
                     * callback to be called only once, when the prior set('href', ...) call or
                     * the initial href parameter to the constructor finishes loading.
                     * 
                     * This is different than an onLoad() handler which gets called any time any href
                     * or content is loaded.
                     * 
                     */
                    "onLoadDeferred": Object;
                    set(property: "onLoadDeferred", value: Object): void;
                    get(property: "onLoadDeferred"): Object;
                    watch(property: "onLoadDeferred", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * True if Dialog is currently displayed on screen.
                     * 
                     */
                    "open": boolean;
                    set(property: "open", value: boolean): void;
                    get(property: "open"): boolean;
                    watch(property: "open", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * The document this widget belongs to.  If not specified to constructor, will default to
                     * srcNodeRef.ownerDocument, or if no sourceRef specified, then to the document global
                     * 
                     */
                    "ownerDocument": Object;
                    set(property: "ownerDocument", value: Object): void;
                    get(property: "ownerDocument"): Object;
                    watch(property: "ownerDocument", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * Parse content and create the widgets, if any.
                     * 
                     */
                    "parseOnLoad": boolean;
                    set(property: "parseOnLoad", value: boolean): void;
                    get(property: "parseOnLoad"): boolean;
                    watch(property: "parseOnLoad", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * Flag passed to parser.  Root for attribute names to search for.   If scopeName is dojo,
                     * will search for data-dojo-type (or dojoType).  For backwards compatibility
                     * reasons defaults to dojo._scopeName (which is "dojo" except when
                     * multi-version support is used, when it will be something like dojo16, dojo20, etc.)
                     * 
                     */
                    "parserScope": string;
                    set(property: "parserScope", value: string): void;
                    get(property: "parserScope"): string;
                    watch(property: "parserScope", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Force load of data on initialization even if pane is hidden.
                     * 
                     */
                    "preload": boolean;
                    set(property: "preload", value: boolean): void;
                    get(property: "preload"): boolean;
                    watch(property: "preload", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * Prevent caching of data from href's by appending a timestamp to the href.
                     * 
                     */
                    "preventCache": boolean;
                    set(property: "preventCache", value: boolean): void;
                    get(property: "preventCache"): boolean;
                    watch(property: "preventCache", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "refNode": Object;
                    set(property: "refNode", value: Object): void;
                    get(property: "refNode"): Object;
                    watch(property: "refNode", callback: { (property?: string, oldValue?: Object, newValue?: Object): void }): { unwatch(): void }
                    /**
                     * A Toggle to modify the default focus behavior of a Dialog, which
                     * is to re-focus the element which had focus before being opened.
                     * False will disable refocusing. Default: true
                     * 
                     */
                    "refocus": boolean;
                    set(property: "refocus", value: boolean): void;
                    get(property: "refocus"): boolean;
                    watch(property: "refocus", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * Refresh (re-download) content when pane goes from hidden to shown
                     * 
                     */
                    "refreshOnShow": boolean;
                    set(property: "refreshOnShow", value: boolean): void;
                    get(property: "refreshOnShow"): boolean;
                    watch(property: "refreshOnShow", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "searchContainerNode": boolean;
                    set(property: "searchContainerNode", value: boolean): void;
                    get(property: "searchContainerNode"): boolean;
                    watch(property: "searchContainerNode", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * pointer to original DOM node
                     * 
                     */
                    "srcNodeRef": HTMLElement;
                    set(property: "srcNodeRef", value: HTMLElement): void;
                    get(property: "srcNodeRef"): HTMLElement;
                    watch(property: "srcNodeRef", callback: { (property?: string, oldValue?: HTMLElement, newValue?: HTMLElement): void }): { unwatch(): void }
                    /**
                     * Will be "Error" if one or more of the child widgets has an invalid value,
                     * "Incomplete" if not all of the required child widgets are filled in.  Otherwise, "",
                     * which indicates that the form is ready to be submitted.
                     * 
                     */
                    "state": string;
                    set(property: "state", value: string): void;
                    get(property: "state"): string;
                    watch(property: "state", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "stopParser": boolean;
                    set(property: "stopParser", value: boolean): void;
                    get(property: "stopParser"): boolean;
                    watch(property: "stopParser", callback: { (property?: string, oldValue?: boolean, newValue?: boolean): void }): { unwatch(): void }
                    /**
                     * HTML style attributes as cssText string or name/value hash
                     * 
                     */
                    "style": string;
                    set(property: "style", value: string): void;
                    get(property: "style"): string;
                    watch(property: "style", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Path to template (HTML file) for this widget relative to dojo.baseUrl.
                     * Deprecated: use templateString with require([... "dojo/text!..."], ...) instead
                     * 
                     */
                    "templatePath": string;
                    set(property: "templatePath", value: string): void;
                    get(property: "templatePath"): string;
                    watch(property: "templatePath", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * 
                     */
                    "templateString": string;
                    set(property: "templateString", value: string): void;
                    get(property: "templateString"): string;
                    watch(property: "templateString", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * HTML title attribute.
                     * 
                     * For form widgets this specifies a tooltip to display when hovering over
                     * the widget (just like the native HTML title attribute).
                     * 
                     * For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
                     * etc., it's used to specify the tab label, accordion pane title, etc.  In this case it's
                     * interpreted as HTML.
                     * 
                     */
                    "title": string;
                    set(property: "title", value: string): void;
                    get(property: "title"): string;
                    watch(property: "title", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
                     * this specifies the tooltip to appear when the mouse is hovered over that text.
                     * 
                     */
                    "tooltip": string;
                    set(property: "tooltip", value: string): void;
                    get(property: "tooltip"): string;
                    watch(property: "tooltip", callback: { (property?: string, oldValue?: string, newValue?: string): void }): { unwatch(): void }
                    /**
                     * Makes the given widget a child of this widget.
                     * Inserts specified child widget's dom node as a child of this widget's
                     * container node, and possibly does other processing (such as layout).
                     * 
                     * @param widget             
                     * @param insertIndex               Optional            
                     */
                    addChild(widget: dijit._WidgetBase, insertIndex: number): void;
                    /**
                     * This method is deprecated, use get() or set() directly.
                     * 
                     * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
                     * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
                     */
                    attr(name: String, value: Object): any;
                    /**
                     * This method is deprecated, use get() or set() directly.
                     * 
                     * @param name The property to get or set. If an object is passed here and nota string, its keys are used as names of attributes to be setand the value of the object as values to set in the widget.             
                     * @param value               OptionalOptional. If provided, attr() operates as a setter. If omitted,the current value of the named property is returned.             
                     */
                    attr(name: Object, value: Object): any;
                    /**
                     * 
                     */
                    buildRendering(): void;
                    /**
                     * Cancels an in-flight download of content
                     * 
                     */
                    cancel(): void;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: Object, event: String, method: String): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: String, method: String): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: Object, event: Function, method: String): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: Function, method: String): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: Object, event: String, method: Function): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: String, method: Function): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: Object, event: Function, method: Function): any;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(on(...)) or this.own(aspect.after(...)) instead.
                     * 
                     * Connects specified obj/event to specified method of this object
                     * and registers for disconnect() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.connect, except with the
                     * implicit use of this widget as the target object.
                     * Events connected with this.connect are disconnected upon
                     * destruction.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: Function, method: Function): any;
                    /**
                     * You can call this function directly, ex. in the event that you
                     * programmatically add a widget to the form after the form has been
                     * initialized.
                     * 
                     * @param inStartup             
                     */
                    connectChildren(inStartup: boolean): void;
                    /**
                     * 
                     * @param params             
                     * @param srcNodeRef             
                     */
                    create(params: any, srcNodeRef: any): void;
                    /**
                     * Wrapper to setTimeout to avoid deferred functions executing
                     * after the originating widget has been destroyed.
                     * Returns an object handle with a remove method (that returns null) (replaces clearTimeout).
                     * 
                     * @param fcn Function reference.             
                     * @param delay               OptionalDelay, defaults to 0.             
                     */
                    defer(fcn: Function, delay: number): Object;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Destroy all the widgets inside the ContentPane and empty containerNode
                     * 
                     * @param preserveDom             
                     */
                    destroyDescendants(preserveDom: boolean): void;
                    /**
                     * Destroy the ContentPane and its contents
                     * 
                     * @param preserveDom             
                     */
                    destroyRecursive(preserveDom: boolean): void;
                    /**
                     * Destroys the DOM nodes associated with this widget.
                     * 
                     * @param preserveDom               OptionalIf true, this method will leave the original DOM structure aloneduring tear-down. Note: this will not work with _Templatedwidgets yet.             
                     */
                    destroyRendering(preserveDom?: boolean): void;
                    /**
                     * Deprecated, will be removed in 2.0, use handle.remove() instead.
                     * 
                     * Disconnects handle created by connect.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Deprecated method.   Applications no longer need to call this.   Remove for 2.0.
                     * 
                     */
                    disconnectChildren(): void;
                    /**
                     * Used by widgets to signal that a synthetic event occurred, ex:
                     * 
                     * myWidget.emit("attrmodified-selectedChildWidget", {}).
                     * Emits an event on this.domNode named type.toLowerCase(), based on eventObj.
                     * Also calls onType() method, if present, and returns value from that method.
                     * By default passes eventObj to callback, but will pass callbackArgs instead, if specified.
                     * Modifies eventObj by adding missing parameters (bubbles, cancelable, widget).
                     * 
                     * @param type             
                     * @param eventObj               Optional            
                     * @param callbackArgs               Optional            
                     */
                    emit(type: String, eventObj: Object, callbackArgs: any[]): any;
                    /**
                     * Callback when the user hits the submit button.
                     * Override this method to handle Dialog execution.
                     * After the user has pressed the submit button, the Dialog
                     * first calls onExecute() to notify the container to hide the
                     * dialog and restore focus to wherever it used to be.
                     * 
                     * Then this method is called.
                     * 
                     * @param formContents             
                     */
                    execute(formContents: Object): void;
                    /**
                     * 
                     */
                    focus(): void;
                    /**
                     * Get a property from a widget.
                     * Get a named property from a widget. The property may
                     * potentially be retrieved via a getter method. If no getter is defined, this
                     * just retrieves the object's property.
                     * 
                     * For example, if the widget has properties foo and bar
                     * and a method named _getFooAttr(), calling:
                     * myWidget.get("foo") would be equivalent to calling
                     * widget._getFooAttr() and myWidget.get("bar")
                     * would be equivalent to the expression
                     * widget.bar2
                     * 
                     * @param name The property to get.             
                     */
                    get(name: any): any;
                    /**
                     * Returns all direct children of this widget, i.e. all widgets underneath this.containerNode whose parent
                     * is this widget.   Note that it does not return all descendants, but rather just direct children.
                     * Analogous to Node.childNodes,
                     * except containing widgets rather than DOMNodes.
                     * 
                     * The result intentionally excludes internally created widgets (a.k.a. supporting widgets)
                     * outside of this.containerNode.
                     * 
                     * Note that the array returned is a simple array.  Application code should not assume
                     * existence of methods like forEach().
                     * 
                     */
                    getChildren(): any[];
                    /**
                     * Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
                     * This method should generally be avoided as it returns widgets declared in templates, which are
                     * supposed to be internal/hidden, but it's left here for back-compat reasons.
                     * 
                     */
                    getDescendants(): any[];
                    /**
                     * Gets the index of the child in this container or -1 if not found
                     * 
                     * @param child             
                     */
                    getIndexOfChild(child: dijit._WidgetBase): any;
                    /**
                     * Returns the parent widget of this widget.
                     * 
                     */
                    getParent(): any;
                    /**
                     * 
                     */
                    getValues(): any;
                    /**
                     * Returns true if widget has child widgets, i.e. if this.containerNode contains widgets.
                     * 
                     */
                    hasChildren(): boolean;
                    /**
                     * Hide the dialog
                     * 
                     */
                    hide(): any;
                    /**
                     * Function that should grab the content specified via href.
                     * 
                     * @param args An object with the following properties:handleAs (String, optional): Acceptable values are: text (default), json, json-comment-optional,json-comment-filtered, javascript, xml. See dojo/_base/xhr.contentHandlerssync (Boolean, optional): false is default. Indicates whether the request shouldbe a synchronous (blocking) request.headers (Object, optional): Additional HTTP headers to send in the request.failOk (Boolean, optional): false is default. Indicates whether a request should beallowed to fail (and therefore no console error message inthe event of a failure)contentType (String|Boolean): "application/x-www-form-urlencoded" is default. Set to false toprevent a Content-Type header from being sent, or to a stringto send a different Content-Type.load: This function will becalled on a successful HTTP response code.error: This function willbe called when the request fails due to a network or server error, the urlis invalid, etc. It will also be called if the load or handle callback throws anexception, unless djConfig.debugAtAllCosts is true.  This allows deployed applicationsto continue to run even when a logic error happens in the callback, while makingit easier to troubleshoot while in debug mode.handle: This function willbe called at the end of every request, whether or not an error occurs.url (String): URL to server endpoint.content (Object, optional): Contains properties with string values. Theseproperties will be serialized as name1=value2 andpassed in the request.timeout (Integer, optional): Milliseconds to wait for the response. If this timepasses, the then error callbacks are called.form (DOMNode, optional): DOM node for a form. Used to extract the form valuesand send to the server.preventCache (Boolean, optional): Default is false. If true, then a"dojo.preventCache" parameter is sent in the requestwith a value that changes with each request(timestamp). Useful only with GET-type requests.rawBody (String, optional): Sets the raw body for an HTTP request. If this is used, then the contentproperty is ignored. This is mostly useful for HTTP methods that havea body to their requests, like PUT or POST. This property can be used insteadof postData and putData for dojo/_base/xhr.rawXhrPost and dojo/_base/xhr.rawXhrPut respectively.ioPublish (Boolean, optional): Set this explicitly to false to prevent publishing of topics related toIO operations. Otherwise, if djConfig.ioPublish is set to true, topicswill be published via dojo/topic.publish() for different phases of an IO operation.See dojo/main.__IoPublish for a list of topics that are published.            
                     */
                    ioMethod(args: Object): any;
                    /**
                     * Return true if this widget can currently be focused
                     * and false if not
                     * 
                     */
                    isFocusable(): any;
                    /**
                     * Return this widget's explicit or implicit orientation (true for LTR, false for RTL)
                     * 
                     */
                    isLeftToRight(): any;
                    /**
                     * Returns true if all of the widgets are valid.
                     * Deprecated, will be removed in 2.0.  Use get("state") instead.
                     * 
                     */
                    isValid: { (): boolean };
                    /**
                     * 
                     * @param params             
                     * @param node             
                     * @param ctor             
                     */
                    markupFactory(params: any, node: any, ctor: any): any;
                    /**
                     * 
                     * @param type protected             
                     * @param func             
                     */
                    on(type: String, func: Function): any;
                    /**
                     * 
                     * @param type protected             
                     * @param func             
                     */
                    on(type: Function, func: Function): any;
                    /**
                     * Track specified handles and remove/destroy them when this instance is destroyed, unless they were
                     * already removed/destroyed manually.
                     * 
                     */
                    own(): any;
                    /**
                     * Place this widget somewhere in the DOM based
                     * on standard domConstruct.place() conventions.
                     * A convenience function provided in all _Widgets, providing a simple
                     * shorthand mechanism to put an existing (or newly created) Widget
                     * somewhere in the dom, and allow chaining.
                     * 
                     * @param reference Widget, DOMNode, or id of widget or DOMNode             
                     * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
                     */
                    placeAt(reference: String, position: String): any;
                    /**
                     * Place this widget somewhere in the DOM based
                     * on standard domConstruct.place() conventions.
                     * A convenience function provided in all _Widgets, providing a simple
                     * shorthand mechanism to put an existing (or newly created) Widget
                     * somewhere in the dom, and allow chaining.
                     * 
                     * @param reference Widget, DOMNode, or id of widget or DOMNode             
                     * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
                     */
                    placeAt(reference: HTMLElement, position: String): any;
                    /**
                     * Place this widget somewhere in the DOM based
                     * on standard domConstruct.place() conventions.
                     * A convenience function provided in all _Widgets, providing a simple
                     * shorthand mechanism to put an existing (or newly created) Widget
                     * somewhere in the dom, and allow chaining.
                     * 
                     * @param reference Widget, DOMNode, or id of widget or DOMNode             
                     * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
                     */
                    placeAt(reference: dijit._WidgetBase, position: String): any;
                    /**
                     * Place this widget somewhere in the DOM based
                     * on standard domConstruct.place() conventions.
                     * A convenience function provided in all _Widgets, providing a simple
                     * shorthand mechanism to put an existing (or newly created) Widget
                     * somewhere in the dom, and allow chaining.
                     * 
                     * @param reference Widget, DOMNode, or id of widget or DOMNode             
                     * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
                     */
                    placeAt(reference: String, position: number): any;
                    /**
                     * Place this widget somewhere in the DOM based
                     * on standard domConstruct.place() conventions.
                     * A convenience function provided in all _Widgets, providing a simple
                     * shorthand mechanism to put an existing (or newly created) Widget
                     * somewhere in the dom, and allow chaining.
                     * 
                     * @param reference Widget, DOMNode, or id of widget or DOMNode             
                     * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
                     */
                    placeAt(reference: HTMLElement, position: number): any;
                    /**
                     * Place this widget somewhere in the DOM based
                     * on standard domConstruct.place() conventions.
                     * A convenience function provided in all _Widgets, providing a simple
                     * shorthand mechanism to put an existing (or newly created) Widget
                     * somewhere in the dom, and allow chaining.
                     * 
                     * @param reference Widget, DOMNode, or id of widget or DOMNode             
                     * @param position               OptionalIf reference is a widget (or id of widget), and that widget has an ".addChild" method,it will be called passing this widget instance into that method, supplying the optionalposition index passed.  In this case position (if specified) should be an integer.If reference is a DOMNode (or id matching a DOMNode but not a widget),the position argument can be a numeric index or a string"first", "last", "before", or "after", same as dojo/dom-construct::place().             
                     */
                    placeAt(reference: dijit._WidgetBase, position: number): any;
                    /**
                     * 
                     */
                    postCreate(): void;
                    /**
                     * 
                     */
                    postMixInProperties(): void;
                    /**
                     * [Re]download contents of href and display
                     * cancels any currently in-flight requests
                     * posts "loading..." message
                     * sends XHR to download new data
                     * 
                     */
                    refresh(): any;
                    /**
                     * Removes the passed widget instance from this widget but does
                     * not destroy it.  You can also pass in an integer indicating
                     * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
                     * 
                     * @param widget             
                     */
                    removeChild(widget: dijit._WidgetBase): void;
                    /**
                     * Removes the passed widget instance from this widget but does
                     * not destroy it.  You can also pass in an integer indicating
                     * the index within the container to remove (ie, removeChild(5) removes the sixth widget).
                     * 
                     * @param widget             
                     */
                    removeChild(widget: number): void;
                    /**
                     * 
                     */
                    reset(): void;
                    /**
                     * See dijit/layout/_LayoutWidget.resize() for description.
                     * Although ContentPane doesn't extend _LayoutWidget, it does implement
                     * the same API.
                     * 
                     * @param changeSize             
                     * @param resultSize             
                     */
                    resize(changeSize: any, resultSize: any): void;
                    /**
                     * Set a property on a widget
                     * Sets named properties on a widget which may potentially be handled by a
                     * setter in the widget.
                     * 
                     * For example, if the widget has properties foo and bar
                     * and a method named _setFooAttr(), calling
                     * myWidget.set("foo", "Howdy!") would be equivalent to calling
                     * widget._setFooAttr("Howdy!") and myWidget.set("bar", 3)
                     * would be equivalent to the statement widget.bar = 3;
                     * 
                     * set() may also be called with a hash of name/value pairs, ex:
                     * 
                     * myWidget.set({
                     *     foo: "Howdy",
                     *     bar: 3
                     * });
                     * This is equivalent to calling set(foo, "Howdy") and set(bar, 3)
                     * 
                     * @param name The property to set.             
                     * @param value The value to set in the property.             
                     */
                    set(name: any, value: any): any;
                    /**
                     * Deprecated.  Use set() instead.
                     * 
                     * @param attr             
                     * @param value             
                     */
                    setAttribute(attr: String, value: any): void;
                    /**
                     * Deprecated.   Use set('content', ...) instead.
                     * 
                     * @param data             
                     */
                    setContent(data: String): void;
                    /**
                     * Deprecated.   Use set('content', ...) instead.
                     * 
                     * @param data             
                     */
                    setContent(data: HTMLElement): void;
                    /**
                     * Deprecated.   Use set('content', ...) instead.
                     * 
                     * @param data             
                     */
                    setContent(data: NodeList): void;
                    /**
                     * Deprecated.   Use set('href', ...) instead.
                     * 
                     * @param href             
                     */
                    setHref(href: String): any;
                    /**
                     * Deprecated.   Use set('href', ...) instead.
                     * 
                     * @param href             
                     */
                    setHref(href: URL): any;
                    /**
                     * 
                     * @param val             
                     */
                    setValues(val: any): any;
                    /**
                     * Display the dialog
                     * 
                     */
                    show(): any;
                    /**
                     * Call startup() on all children including non _Widget ones like dojo/dnd/Source objects
                     * 
                     */
                    startup(): void;
                    /**
                     * Deprecated, will be removed in 2.0, use this.own(topic.subscribe()) instead.
                     * 
                     * Subscribes to the specified topic and calls the specified method
                     * of this object and registers for unsubscribe() on widget destroy.
                     * 
                     * Provide widget-specific analog to dojo.subscribe, except with the
                     * implicit use of this widget as the target object.
                     * 
                     * @param t The topic             
                     * @param method The callback             
                     */
                    subscribe(t: String, method: Function): any;
                    /**
                     * Returns a string that represents the widget.
                     * When a widget is cast to a string, this method will be used to generate the
                     * output. Currently, it does not implement any sort of reversible
                     * serialization.
                     * 
                     */
                    toString(): string;
                    /**
                     * Deprecated. Override destroy() instead to implement custom widget tear-down
                     * behavior.
                     * 
                     */
                    uninitialize(): boolean;
                    /**
                     * Deprecated, will be removed in 2.0, use handle.remove() instead.
                     * 
                     * Unsubscribes handle created by this.subscribe.
                     * Also removes handle from this widget's list of subscriptions
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: Object): void;
                    /**
                     * returns if the form is valid - same as isValid - but
                     * provides a few additional (ui-specific) features:
                     * 
                     * it will highlight any sub-widgets that are not valid
                     * it will call focus() on the first invalid sub-widget
                     * 
                     */
                    validate(): any;
                    /**
                     * Watches a property for changes
                     * 
                     * @param name               OptionalIndicates the property to watch. This is optional (the callback may be theonly parameter), and if omitted, all the properties will be watched             
                     * @param callback The function to execute when the property changes. This will be called afterthe property has been changed. The callback will be called with the |this|set to the instance, the first argument as the name of the property, thesecond argument as the old value and the third argument as the new value.             
                     */
                    watch(property: string, callback:{(property?:string, oldValue?:any, newValue?: any):void}) :{unwatch():void};
                    /**
                     * Static method to get a template based on the templatePath or
                     * templateString key
                     */
                    getCachedTemplate(): any;
                    /**
                     * Called when the widget stops being "active" because
                     * focus moved to something outside of it, or the user
                     * clicked somewhere outside of it, or the widget was
                     * hidden.
                     * 
                     */
                    onBlur(): void;
                    /**
                     * Called when user has pressed the Dialog's cancel button, to notify container.
                     * Developer shouldn't override or connect to this method;
                     * it's a private communication device between the TooltipDialog
                     * and the thing that opened it (ex: dijit/form/DropDownButton)
                     * 
                     */
                    onCancel(): void;
                    /**
                     * Connect to this function to receive notifications of mouse click events.
                     * 
                     * @param event mouse Event             
                     */
                    onClick(event: any): void;
                    /**
                     * Called when this widget is being displayed as a popup (ex: a Calendar popped
                     * up from a DateTextBox), and it is hidden.
                     * This is called from the dijit.popup code, and should not be called directly.
                     * 
                     * Also used as a parameter for children of dijit/layout/StackContainer or subclasses.
                     * Callback if a user tries to close the child.   Child will be closed if this function returns true.
                     * 
                     */
                    onClose(): boolean;
                    /**
                     * Called on DOM faults, require faults etc. in content.
                     * 
                     * In order to display an error message in the pane, return
                     * the error message from this method, as an HTML string.
                     * 
                     * By default (if this method is not overriden), it returns
                     * nothing, so the error message is just printed to the console.
                     * 
                     * @param error             
                     */
                    onContentError(error: Error): void;
                    /**
                     * Connect to this function to receive notifications of mouse double click events.
                     * 
                     * @param event mouse Event             
                     */
                    onDblClick(event: any): void;
                    /**
                     * Called when download is finished.
                     * 
                     */
                    onDownloadEnd(): void;
                    /**
                     * Called when download error occurs.
                     * 
                     * In order to display an error message in the pane, return
                     * the error message from this method, as an HTML string.
                     * 
                     * Default behavior (if this method is not overriden) is to display
                     * the error message inside the pane.
                     * 
                     * @param error             
                     */
                    onDownloadError(error: Error): any;
                    /**
                     * Called before download starts.
                     * The string returned by this function will be the html
                     * that tells the user we are loading something.
                     * Override with your own function if you want to change text.
                     * 
                     */
                    onDownloadStart(): any;
                    /**
                     * Called when user has pressed the dialog's OK button, to notify container.
                     * Developer shouldn't override or connect to this method;
                     * it's a private communication device between the TooltipDialog
                     * and the thing that opened it (ex: dijit/form/DropDownButton)
                     * 
                     */
                    onExecute(): void;
                    /**
                     * Called when the widget becomes "active" because
                     * it or a widget inside of it either has focus, or has recently
                     * been clicked.
                     * 
                     */
                    onFocus(): void;
                    /**
                     * Called when another widget becomes the selected pane in a
                     * dijit/layout/TabContainer, dijit/layout/StackContainer,
                     * dijit/layout/AccordionContainer, etc.
                     * 
                     * Also called to indicate hide of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
                     * 
                     */
                    onHide(): void;
                    /**
                     * Connect to this function to receive notifications of keys being pressed down.
                     * 
                     * @param event key Event             
                     */
                    onKeyDown(event: any): void;
                    /**
                     * Connect to this function to receive notifications of printable keys being typed.
                     * 
                     * @param event key Event             
                     */
                    onKeyPress(event: any): void;
                    /**
                     * Connect to this function to receive notifications of keys being released.
                     * 
                     * @param event key Event             
                     */
                    onKeyUp(event: any): void;
                    /**
                     * Event hook, is called after everything is loaded and widgetified
                     * 
                     * @param data             
                     */
                    onLoad(data: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse button is pressed down.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseDown(event: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse moves onto this widget.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseEnter(event: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse moves off of this widget.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseLeave(event: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseMove(event: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseOut(event: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseOver(event: any): void;
                    /**
                     * Connect to this function to receive notifications of when the mouse button is released.
                     * 
                     * @param event mouse Event             
                     */
                    onMouseUp(event: any): void;
                    /**
                     * Called when this widget becomes the selected pane in a
                     * dijit/layout/TabContainer, dijit/layout/StackContainer,
                     * dijit/layout/AccordionContainer, etc.
                     * 
                     * Also called to indicate display of a dijit.Dialog, dijit.TooltipDialog, or dijit.TitlePane.
                     * 
                     */
                    onShow(): void;
                    /**
                     * Event hook, is called before old content is cleared
                     * 
                     */
                    onUnload(): void;
                    /**
                     * Stub function to connect to if you want to do something
                     * (like disable/enable a submit button) when the valid
                     * state changes on the form as a whole.
                     * 
                     * Deprecated.  Will be removed in 2.0.  Use watch("state", ...) instead.
                     * 
                     * @param isValid             
                     */
                    onValidStateChange(isValid: boolean): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/IndirectSelection.html
                 *
                 * A handy way for adding check boxe/radio button for rows, and selecting rows by swiping(or keyboard)
                 * 
                 */
                class IndirectSelection extends dojox.grid.enhanced._Plugin {
                    constructor();
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Add indirectSelection cell(mapped to a column of radio button|check boxes)
                     * 
                     * @param option             
                     */
                    addRowSelectCell(option: any): void;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/GridSource.html
                 *
                 * A special source that can accept grid contents.
                 * Only for non-grid widgets or domNodes.
                 * 
                 * @param node node or node's id to build the source on     
                 * @param params       Optionalany property of this class may be configured via the paramsobject which is mixed-in to the dojo/dnd/Source instance     
                 */
                class GridSource extends dojo.dnd.Source {
                    constructor(node: HTMLElement, params?: Object);
                    /**
                     * 
                     */
                    "accept": any[];
                    /**
                     * Indicates whether to allow dnd item nodes to be nested within other elements.
                     * By default this is false, indicating that only direct children of the container can
                     * be draggable dnd item nodes
                     * 
                     */
                    "allowNested": boolean;
                    /**
                     * 
                     */
                    "autoSync": boolean;
                    /**
                     * 
                     */
                    "copyOnly": boolean;
                    /**
                     * The DOM node the mouse is currently hovered over
                     * 
                     */
                    "current": HTMLElement;
                    /**
                     * 
                     */
                    "delay": number;
                    /**
                     * 
                     */
                    "generateText": boolean;
                    /**
                     * 
                     */
                    "horizontal": boolean;
                    /**
                     * If you'd like to insert some sort of nodes into your dnd source, turn this on,
                     * and override getCellContent/getRowContent/getColumnContent
                     * to populate the dnd data in your desired format.
                     * 
                     */
                    "insertNodesForGrid": boolean;
                    /**
                     * 
                     */
                    "isSource": boolean;
                    /**
                     * Map from an item's id (which is also the DOMNode's id) to
                     * the dojo/dnd/Container.Item itself.
                     * 
                     */
                    "map": Object;
                    /**
                     * The set of id's that are currently selected, such that this.selection[id] == 1
                     * if the node w/that id is selected.  Can iterate over selected node's id's like:
                     * 
                     * for(var id in this.selection)
                     * 
                     */
                    "selection": Object;
                    /**
                     * 
                     */
                    "selfAccept": boolean;
                    /**
                     * 
                     */
                    "selfCopy": boolean;
                    /**
                     * 
                     */
                    "singular": boolean;
                    /**
                     * 
                     */
                    "skipForm": boolean;
                    /**
                     * 
                     */
                    "withHandles": boolean;
                    /**
                     * 
                     * @param source             
                     * @param nodes             
                     */
                    checkAcceptance(source: any, nodes: any): any;
                    /**
                     * removes all data items from the map
                     * 
                     */
                    clearItems(): void;
                    /**
                     * Returns true if we need to copy items, false to move.
                     * It is separated to be overwritten dynamically, if needed.
                     * 
                     * @param keyPressed the "copy" key was pressed             
                     * @param self               Optionaloptional flag that means that we are about to drop on itself             
                     */
                    copyState(keyPressed: boolean, self: boolean): any;
                    /**
                     * creator function, dummy at the moment
                     * 
                     */
                    creator(): void;
                    /**
                     * deletes all selected items
                     * 
                     */
                    deleteSelectedNodes(): Function;
                    /**
                     * removes a data item from the map by its key (id)
                     * 
                     * @param key             
                     */
                    delItem(key: String): void;
                    /**
                     * prepares the object to be garbage-collected
                     * 
                     */
                    destroy(): void;
                    /**
                     * 
                     * @param type             
                     * @param event             
                     */
                    emit(type: any, event: any): any;
                    /**
                     * iterates over a data map skipping members that
                     * are present in the empty object (IE and/or 3rd-party libraries).
                     * 
                     * @param f             
                     * @param o               Optional            
                     */
                    forInItems(f: Function, o: Object): String;
                    /**
                     * iterates over selected items;
                     * see dojo/dnd/Container.forInItems() for details
                     * 
                     * @param f             
                     * @param o               Optional            
                     */
                    forInSelectedItems(f: Function, o: Object): void;
                    /**
                     * returns a list (an array) of all valid child nodes
                     * 
                     */
                    getAllNodes(): any;
                    /**
                     * Fill node innerHTML for dnd grid cells.
                     * 
                     * @param grid             
                     * @param leftTopCell             
                     * @param rightBottomCell             
                     */
                    getCellContent(grid: any, leftTopCell: any, rightBottomCell: any): void;
                    /**
                     * Fill node innerHTML for dnd grid columns.
                     * 
                     * @param grid             
                     * @param colIndexes             
                     */
                    getColumnContent(grid: any, colIndexes: any): void;
                    /**
                     * returns a data item by its key (id)
                     * 
                     * @param key             
                     */
                    getItem(key: String): any;
                    /**
                     * Fill node innerHTML for dnd grid rows.
                     * 
                     * @param grid             
                     * @param rowIndexes             
                     */
                    getRowContent(grid: any, rowIndexes: any): void;
                    /**
                     * returns a list (an array) of selected nodes
                     * 
                     */
                    getSelectedNodes(): any;
                    /**
                     * inserts an array of new nodes before/after an anchor node
                     * 
                     * @param data Logical representation of the object being dragged.If the drag object's type is "text" then data is a String,if it's another type then data could be a different Object,perhaps a name/value hash.             
                     * @param before insert before the anchor, if true, and after the anchor otherwise             
                     * @param anchor the anchor node to be used as a point of insertion             
                     */
                    insertNodes(data: Object, before: boolean, anchor: HTMLElement): Function;
                    /**
                     * inserts new data items (see dojo/dnd/Container.insertNodes() method for details)
                     * 
                     * @param addSelected all new nodes will be added to selected items, if true, no selection change otherwise             
                     * @param data a list of data items, which should be processed by the creator function             
                     * @param before insert before the anchor, if true, and after the anchor otherwise             
                     * @param anchor the anchor node to be used as a point of insertion             
                     */
                    insertNodes(addSelected: boolean, data: any[], before: boolean, anchor: HTMLElement): Function;
                    /**
                     * 
                     * @param params             
                     * @param node             
                     */
                    markupFactory(params: any, node: any): any;
                    /**
                     * 
                     * @param type             
                     * @param listener             
                     */
                    on(type: any, listener: any): any;
                    /**
                     * selects all items
                     * 
                     */
                    selectAll(): any;
                    /**
                     * unselects all items
                     * 
                     */
                    selectNone(): any;
                    /**
                     * associates a data item with its key (id)
                     * 
                     * @param key             
                     * @param data             
                     */
                    setItem(key: String, data: any): void;
                    /**
                     * collects valid child items and populate the map
                     * 
                     */
                    startup(): void;
                    /**
                     * sync up the node list with the data map
                     * 
                     */
                    sync(): Function;
                    /**
                     * topic event processor for /dnd/cancel, called to cancel the DnD operation
                     * 
                     */
                    onDndCancel(): void;
                    /**
                     * topic event processor for /dnd/drop, called to finish the DnD operation
                     * 
                     * @param source the source which provides items             
                     * @param nodes the list of transferred items             
                     * @param copy copy items, if true, move items otherwise             
                     * @param target the target which accepts items             
                     */
                    onDndDrop(source: Object, nodes: any[], copy: boolean, target: Object): void;
                    /**
                     * topic event processor for /dnd/source/over, called when detected a current source
                     * 
                     * @param source the source which has the mouse over it             
                     */
                    onDndSourceOver(source: Object): void;
                    /**
                     * topic event processor for /dnd/start, called to initiate the DnD operation
                     * 
                     * @param source the source which provides items             
                     * @param nodes the list of transferred items             
                     * @param copy copy items, if true, move items otherwise             
                     */
                    onDndStart(source: Object, nodes: any[], copy: boolean): void;
                    /**
                     * 
                     */
                    onDraggingOut(): void;
                    /**
                     * 
                     */
                    onDraggingOver(): void;
                    /**
                     * called only on the current target, when drop is performed
                     * 
                     * @param source the source which provides items             
                     * @param nodes the list of transferred items             
                     * @param copy copy items, if true, move items otherwise             
                     */
                    onDrop(source: Object, nodes: any[], copy: boolean): void;
                    /**
                     * 
                     * @param source             
                     * @param nodes             
                     * @param copy             
                     */
                    onDropExternal(source: any, nodes: any, copy: any): void;
                    /**
                     * 
                     * @param grid             
                     * @param leftTopCell             
                     * @param rightBottomCell             
                     */
                    onDropGridCells(grid: any, leftTopCell: any, rightBottomCell: any): void;
                    /**
                     * 
                     * @param grid             
                     * @param colIndexes             
                     */
                    onDropGridColumns(grid: any, colIndexes: any): void;
                    /**
                     * 
                     * @param grid             
                     * @param rowIndexes             
                     */
                    onDropGridRows(grid: any, rowIndexes: any): void;
                    /**
                     * called only on the current target, when drop is performed
                     * from the same target/source
                     * 
                     * @param nodes the list of transferred items             
                     * @param copy copy items, if true, move items otherwise             
                     */
                    onDropInternal(nodes: any[], copy: boolean): void;
                    /**
                     * event processor for onmousedown
                     * 
                     * @param e mouse event             
                     */
                    onMouseDown(e: Event): void;
                    /**
                     * event processor for onmousemove
                     * 
                     * @param e mouse event             
                     */
                    onMouseMove(e: Event): void;
                    /**
                     * event processor for onmouseout
                     * 
                     * @param e mouse event             
                     */
                    onMouseOut(e: Event): void;
                    /**
                     * event processor for onmouseover or touch, to mark that element as the current element
                     * 
                     * @param e mouse event             
                     */
                    onMouseOver(e: Event): void;
                    /**
                     * event processor for onmouseup
                     * 
                     * @param e mouse event             
                     */
                    onMouseUp(e: Event): void;
                    /**
                     * this function is called once, when mouse is out of our container
                     * 
                     */
                    onOutEvent(): void;
                    /**
                     * this function is called once, when mouse is over our container
                     * 
                     */
                    onOverEvent(): void;
                    /**
                     * event processor for onselectevent and ondragevent
                     * 
                     * @param e mouse event             
                     */
                    onSelectStart(e: Event): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Menu.html
                 *
                 * Provides context menu support, including header menu, row menu, cell menu and selected region menu
                 * 
                 */
                class Menu extends dojox.grid.enhanced._Plugin {
                    constructor();
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * menu types
                     * 
                     */
                    "types": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Destroy all resources.
                     * _Grid.destroy() will unbind headerMenu
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Show appropriate context menu
                     * Fired from dojox.grid.enhanced._Events.onRowContextMenu, 'this' scope - Grid
                     * 
                     * @param e             
                     */
                    showMenu(e: Event): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Pagination.html
                 *
                 * The typical pagination way to deal with huge dataset
                 * an alternative for the default virtual scrolling manner.
                 * 
                 * @param inGrid The grid to plug in to.     
                 * @param option     
                 */
                class Pagination extends dojox.grid.enhanced._Plugin {
                    constructor(inGrid: dojox.grid.EnhancedGrid, option: any);
                    /**
                     * Which page will be displayed initially, 1st page by default.
                     * 
                     */
                    "defaultPage": number;
                    /**
                     * Number of rows in a page, 25 by default.
                     * 
                     */
                    "defaultPageSize": number;
                    /**
                     * Whether the description information will be displayed, true by default.
                     * 
                     */
                    "description": boolean;
                    /**
                     * Whether the goto page button will be displayed, false by default.
                     * 
                     */
                    "gotoButton": boolean;
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * The max number of page sizes to be displayed, 7 by default.
                     * 
                     */
                    "maxPageStep": number;
                    /**
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Array of page sizes for switching, e.g. [10, 25, 50, 100, Infinity] by default,
                     * Infinity or any NaN value will be treated as "all".
                     * 
                     */
                    "pageSizes": any[];
                    /**
                     * Whether the page switch options will be displayed, true by default.
                     * 
                     */
                    "pageStepper": boolean;
                    /**
                     * The position of the pagination bar - "top"|"bottom", "bottom" by default.
                     * 
                     */
                    "position": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Whether the page size switch options will be displayed, true by default.
                     * 
                     */
                    "sizeSwitch": boolean;
                    /**
                     * 
                     * @param size             
                     */
                    changePageSize(size: any): void;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Shift to the given page, return current page number. If there 
                     * is no valid page was passed in, just return current page num.
                     * 
                     * @param page The page to go to, starting at 1.             
                     */
                    currentPage(page: number): any;
                    /**
                     * Change the size of current page or return the current page size.
                     * 
                     * @param size An integer identifying the number of rows per page. If the sizeis an Infinity, all rows will be displayed; if an invalid value passedin, the current page size will be returned.             
                     */
                    currentPageSize(size: number): any;
                    /**
                     * Change the size of current page or return the current page size.
                     * 
                     * @param size An integer identifying the number of rows per page. If the sizeis an Infinity, all rows will be displayed; if an invalid value passedin, the current page size will be returned.             
                     */
                    currentPageSize(size: any): any;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Go to the first page
                     * 
                     */
                    firstPage(): void;
                    /**
                     * Get total page number
                     * 
                     */
                    getTotalPageNum(): any;
                    /**
                     * Function for get total row count
                     * 
                     */
                    getTotalRowCount(): any;
                    /**
                     * 
                     */
                    gotoFirstPage(): void;
                    /**
                     * 
                     */
                    gotoLastPage(): void;
                    /**
                     * 
                     * @param page             
                     */
                    gotoPage(page: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Go to the last page
                     * 
                     */
                    lastPage(): void;
                    /**
                     * Go to the next page.
                     * 
                     */
                    nextPage(): void;
                    /**
                     * Go to the previous page.
                     * 
                     */
                    prevPage(): void;
                    /**
                     * 
                     */
                    removeSelectedRows(): void;
                    /**
                     * Override the grid.scrollToRow(), could jump to the right page
                     * and scroll to the specific row
                     * 
                     * @param inRowIndex The row index             
                     */
                    scrollToRow(inRowIndex: number): any;
                    /**
                     * For show/hide the go to page button dynamically
                     * 
                     * @param flag Show the go to page button when flag is true, otherwise hide it             
                     */
                    showGotoPageButton(flag: boolean): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/NestedSorting.html
                 *
                 * Provides nested sorting feature
                 * A flexible way to control multiple column sorting, including
                 * 
                 * Set default sorting order
                 * Disable sorting for certain columns
                 * Set sorting order dynamically with JS API
                 * 
                 */
                class NestedSorting extends dojox.grid.enhanced._Plugin {
                    constructor();
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * 
                     */
                    clearSort(): void;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Overwritten, see DataGrid.getSortProps()
                     * 
                     */
                    getSortProps(): any;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * 
                     */
                    initCookieHandler(): void;
                    /**
                     * 
                     * @param cellIndex             
                     */
                    isAsc(cellIndex: any): boolean;
                    /**
                     * 
                     * @param cellIndex             
                     */
                    isDesc(cellIndex: any): boolean;
                    /**
                     * 
                     * @param cellIdx             
                     */
                    removeSortData(cellIdx: any): void;
                    /**
                     * Set sorting data for a column.
                     * 
                     * @param cellIdx             
                     * @param attr             
                     * @param value             
                     */
                    setSortData(cellIdx: any, attr: any, value: any): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Printer.html
                 *
                 * Provide printGrid function to the grid.
                 * 
                 * @param grid     
                 */
                class Printer extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * Plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Destroy all resources.
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Export selected rows to HTML string, but do NOT print.
                     * Users can use this to implement print preview.
                     * For meaning of arguments see function printGrid
                     * 
                     * @param args               OptionalArguments for print.             
                     * @param onExported             
                     */
                    exportSelectedToHTML(args: Object, onExported: any): void;
                    /**
                     * Export to HTML string, but do NOT print.
                     * Users can use this to implement print preview.
                     * For meaning of the 1st-3rd arguments see function printGrid.
                     * 
                     * @param args               OptionalArguments for print.             
                     * @param onExported call back function             
                     */
                    exportToHTML(args: Object, onExported: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * 
                     * @param doc             
                     */
                    normalizeRowHeight(doc: any): void;
                    /**
                     * Print all the data in the grid, using title as a title,
                     * decorating generated html by cssFiles,
                     * using tagName:"attrbuteList" pairs(writerArgs) to control html tags
                     * in the generated html string.
                     * 
                     * @param args               OptionalArguments for print.             
                     */
                    printGrid(args: Object): void;
                    /**
                     * Print selected data. All other features are the same as printGrid.
                     * For meaning of arguments see function printGrid
                     * 
                     * @param args               OptionalArguments for print.             
                     */
                    printSelected(args: Object): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Rearrange.html
                 *
                 * Provides a set of method to re-arrange the structure of grid.
                 * 
                 * @param grid     
                 * @param args     
                 */
                class Rearrange extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * 
                     * @param sourceGrid             
                     * @param cellsToMove             
                     * @param target             
                     */
                    changeCells(sourceGrid: any, cellsToMove: any, target: any): void;
                    /**
                     * 
                     * @param cellsToClear             
                     */
                    clearCells(cellsToClear: any): void;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * 
                     * @param cellsToMove             
                     * @param target             
                     */
                    copyCells(cellsToMove: any, target: any): void;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * 
                     * @param sourceGrid             
                     * @param rowsToMove             
                     * @param targetPos             
                     */
                    insertRows(sourceGrid: any, rowsToMove: any, targetPos: any): void;
                    /**
                     * 
                     * @param cellsToMove             
                     * @param target             
                     */
                    moveCells(cellsToMove: any, target: any): void;
                    /**
                     * Move a set of columns to a given position.
                     * 
                     * @param colsToMove Array of column indexes.             
                     * @param targetPos The target position             
                     */
                    moveColumns(colsToMove: number[], targetPos: number): void;
                    /**
                     * Move a set of rows to a given position
                     * 
                     * @param rowsToMove Array of row indexes.             
                     * @param targetPos The target position             
                     */
                    moveRows(rowsToMove: number[], targetPos: number): void;
                    /**
                     * 
                     * @param rowsToRemove             
                     */
                    removeRows(rowsToRemove: any): void;
                    /**
                     * 
                     * @param args             
                     */
                    setArgs(args: any): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Search.html
                 *
                 * Search the grid using wildcard string or Regular Expression.
                 * 
                 * @param grid     
                 * @param args     
                 */
                class Search extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * Destroy all resources.
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * 
                     * @param searchArgs             
                     * @param onSearched             
                     */
                    searchRow(searchArgs: Object, onSearched: {(index:number,item:Object): any;}): void;
                    /**
                     * 
                     * @param searchArgs             
                     * @param onSearched             
                     */
                    searchRow(searchArgs: RegExp, onSearched: {(index:number,item:Object): any;}): void;
                    /**
                     * 
                     * @param searchArgs             
                     * @param onSearched             
                     */
                    searchRow(searchArgs: String, onSearched: {(index:number,item:Object): any;}): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * Called when store is changed.
                     * 
                     * @param store             
                     */
                    onSetStore(store: any): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                /**
                 * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/Selector.html
                 *
                 * Provides standard extended selection for grid.
                 * Supports mouse/keyboard selection, multi-selection, and de-selection.
                 * 
                 * Acceptable plugin parameters:
                 * The whole plugin parameter object is a config object passed to the setupConfig function.
                 * 
                 * Acceptable cell parameters defined in layout:
                 * 
                 * notselectable: Boolean: Whether this column is (and all the cells in it are) selectable.
                 * 
                 * @param grid     
                 * @param args     
                 */
                class Selector extends dojox.grid.enhanced._Plugin {
                    constructor(grid: any, args: any);
                    /**
                     * Grid that the plugin belongs to
                     * 
                     */
                    "grid": Object;
                    /**
                     * plugin name
                     * 
                     */
                    "name": string;
                    /**
                     * Plugin properties - leveraged with default and user specified properties.
                     * e.g. for dnd plugin, it may look like {"class": dojox.grid.enhanced.plugins.DnD, "dependency": ["nestedSorting"], ...}
                     * 
                     */
                    "option": Object;
                    /**
                     * Private properties/methods shouldn't be mixin-ed anytime.
                     * 
                     */
                    "privates": Object;
                    /**
                     * Clear all selections.
                     * 
                     * @param type               Optional"row" or "col" or "cell". If omitted, clear all.             
                     */
                    clear(type: String): void;
                    /**
                     * Connects specified obj/event to specified method of this object.
                     * 
                     * @param obj             
                     * @param event             
                     * @param method             
                     */
                    connect(obj: any, event: any, method: any): any;
                    /**
                     * 
                     * @param type             
                     * @param rowIndex             
                     * @param colIndex             
                     */
                    deselect(type: any, rowIndex: any, colIndex: any): void;
                    /**
                     * 
                     */
                    destroy(): void;
                    /**
                     * Disconnects handle and removes it from connection list.
                     * 
                     * @param handle             
                     */
                    disconnect(handle: any): void;
                    /**
                     * Get last selected range of the given type.
                     * 
                     * @param type             
                     */
                    getLastSelectedRange(type: any): any;
                    /**
                     * Get an array of selected locations.
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param includeExceptions Only meaningful for rows/columns. If true, all selected rows/cols, even they are partly selected, are all returned.             
                     */
                    getSelected(type: String, includeExceptions: boolean): any;
                    /**
                     * Get the number of selected items.
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param includeExceptions Only meaningful for rows/columns. If true, all selected rows/cols, even they are partly selected, are all returned.             
                     */
                    getSelectedCount(type: String, includeExceptions: boolean): any;
                    /**
                     * Get the type of selected items.
                     * 
                     */
                    getSelectedType(): any;
                    /**
                     * 
                     */
                    init(): void;
                    /**
                     * Check whether a location (a cell, a column or a row) is selected.
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param rowIndex If type is "row" or "cell", this is the row index.If type if "col", this is the column index.             
                     * @param colIndex               OptionalOnly valid when type is "cell"             
                     */
                    isSelected(type: String, rowIndex: number, colIndex: number): any;
                    /**
                     * Check whether the user is currently selecting something.
                     * 
                     * @param type "row" or "col" or "cell"             
                     */
                    isSelecting(type: String): any;
                    /**
                     * Select a location (a cell, a column or a row).
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param rowIndex If type is "row" or "cell", this is the row index.If type if "col", this is the column index.             
                     * @param colIndex               OptionalOnly valid when type is "cell"             
                     */
                    select(type: String, rowIndex: number, colIndex: number): void;
                    /**
                     * Turn on/off this selection functionality if toEnable is provided.
                     * Check whether this selection functionality is enabled if nothing is passed in.
                     * 
                     * @param toEnable               OptionalTo enable or not.             
                     */
                    selectEnabled(toEnable: boolean): any;
                    /**
                     * Select a continuous range (a block of cells, a set of continuous columns or rows)
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param start If type is "row" or "col", this is the index of the starting row or column.If type if "cell", this is the left-top cell of the range.             
                     * @param end If type is "row" or "col", this is the index of the ending row or column.If type if "cell", this is the right-bottom cell of the range.             
                     * @param toSelect             
                     */
                    selectRange(type: String, start: number, end: number, toSelect: any): void;
                    /**
                     * Select a continuous range (a block of cells, a set of continuous columns or rows)
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param start If type is "row" or "col", this is the index of the starting row or column.If type if "cell", this is the left-top cell of the range.             
                     * @param end If type is "row" or "col", this is the index of the ending row or column.If type if "cell", this is the right-bottom cell of the range.             
                     * @param toSelect             
                     */
                    selectRange(type: String, start: Object, end: number, toSelect: any): void;
                    /**
                     * Select a continuous range (a block of cells, a set of continuous columns or rows)
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param start If type is "row" or "col", this is the index of the starting row or column.If type if "cell", this is the left-top cell of the range.             
                     * @param end If type is "row" or "col", this is the index of the ending row or column.If type if "cell", this is the right-bottom cell of the range.             
                     * @param toSelect             
                     */
                    selectRange(type: String, start: number, end: Object, toSelect: any): void;
                    /**
                     * Select a continuous range (a block of cells, a set of continuous columns or rows)
                     * 
                     * @param type "row" or "col" or "cell"             
                     * @param start If type is "row" or "col", this is the index of the starting row or column.If type if "cell", this is the left-top cell of the range.             
                     * @param end If type is "row" or "col", this is the index of the ending row or column.If type if "cell", this is the right-bottom cell of the range.             
                     * @param toSelect             
                     */
                    selectRange(type: String, start: Object, end: Object, toSelect: any): void;
                    /**
                     * Set selection mode for row/col/cell.
                     * 
                     * @param config An object with the following structure (all properties are optional):{    //Default is "multi", all other values are same as "multi".    row: false|"disabled"|"single",    col: false|"disabled"|"single",    cell: false|"disabled"|"single"}             
                     */
                    setupConfig(config: Object): void;
                    /**
                     * Subscribes to the specified topic and calls the specified method
                     * of this object.
                     * 
                     * @param topic             
                     * @param method             
                     */
                    subscribe(topic: any, method: any): any;
                    /**
                     * 
                     * @param type             
                     * @param rowIndex             
                     * @param colIndex             
                     */
                    toggleSelect(type: any, rowIndex: any, colIndex: any): void;
                    /**
                     * Un-subscribes handle and removes it from subscriptions list.
                     * 
                     * @param handle             
                     */
                    unsubscribe(handle: any): void;
                    /**
                     * 
                     */
                    onPostInit(): void;
                    /**
                     * 
                     */
                    onPreInit(): void;
                    /**
                     * 
                     */
                    onSetStore(): void;
                    /**
                     * 
                     */
                    onStartUp(): void;
                }
                module exporter {
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/exporter/_ExportWriter.html
                     *
                     * This is an abstract class for all kinds of writers used in the Exporter plugin.
                     * It utilizes the strategy pattern to break the export work into several stages,
                     * and provide interfaces for all of them.
                     * 
                     * Implementations might choose some of the functions in this class to override,
                     * thus providing their own functionalities.
                     * 
                     * The Exporter will go through the grid line by line. So in every line, all the Views
                     * will be reached, and the header line is only handled once.
                     * 
                     * An argObj object is passed to most functions of this class.
                     * It carries context arguments that make sense when they are called.
                     * 
                     * @param writerArgs       OptionalAny implementation of this class might accept a writerArgs object (optional),which contains some writer-specific arguments given by the user.     
                     */
                    class _ExportWriter {
                        constructor(writerArgs?: Object);
                        /**
                         * 
                         */
                        "argObj": Object;
                        /**
                         * We have finished the entire grid travel.
                         * Do some clean up work if you need to.
                         * 
                         */
                        afterContent(): any;
                        /**
                         * After handling a line of data (not header).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    spCols}             
                         */
                        afterContentRow(argObj: Object): any;
                        /**
                         * The header line has been handled.
                         * 
                         */
                        afterHeader(): any;
                        /**
                         * Before handling a subrow in a line (defined in the grid structure).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    view,viewIdx,    subrow,subrowIdx,    spCols(if isHeader==false)}             
                         */
                        afterSubrow(argObj: Object): any;
                        /**
                         * After handling a view.
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    view,viewIdx,    spCols(if isHeader==false)}             
                         */
                        afterView(argObj: Object): any;
                        /**
                         * We are ready to go through all the contents(items).
                         * 
                         * @param items All the items fetched from the store             
                         */
                        beforeContent(items: any[]): any;
                        /**
                         * Before handling a line of data (not header).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    spCols}             
                         */
                        beforeContentRow(argObj: Object): any;
                        /**
                         * We are going to start the travel in the grid.
                         * Is there anything we should do now?
                         * 
                         * @param grid             
                         */
                        beforeHeader(grid: dojox.grid.EnhancedGrid): any;
                        /**
                         * Before handling a subrow in a line (defined in the grid structure).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    view,viewIdx,    subrow,subrowIdx,    spCols(if isHeader==false)}             
                         */
                        beforeSubrow(argObj: Object): any;
                        /**
                         * Before handling a view.
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    view,viewIdx,    spCols(if isHeader==false)}             
                         */
                        beforeView(argObj: Object): any;
                        /**
                         * Handle a header cell or data cell.
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    view,viewIdx,    subrow,subrowIdx,    cell,cellIdx,    spCols(if isHeader==false)}             
                         */
                        handleCell(argObj: Object): any;
                        /**
                         * Export to a string.
                         * 
                         */
                        toString(): any;
                    }
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/exporter/CSVWriter.html
                     *
                     * Export grid to CSV format.
                     * 
                     * @param writerArgs       Optional{separator:'...'}     
                     */
                    class CSVWriter extends dojox.grid.enhanced.plugins.exporter._ExportWriter {
                        constructor(writerArgs?: Object);
                        /**
                         * 
                         */
                        "argObj": Object;
                        /**
                         * We have finished the entire grid travel.
                         * Do some clean up work if you need to.
                         * 
                         */
                        afterContent(): any;
                        /**
                         * After handling a line of data (not header).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    spCols}             
                         */
                        afterContentRow(argObj: Object): any;
                        /**
                         * The header line has been handled.
                         * 
                         */
                        afterHeader(): any;
                        /**
                         * Before handling a subrow in a line (defined in the grid structure).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    view,viewIdx,    subrow,subrowIdx,    spCols(if isHeader==false)}             
                         */
                        afterSubrow(argObj: Object): any;
                        /**
                         * After handling a view.
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    view,viewIdx,    spCols(if isHeader==false)}             
                         */
                        afterView(argObj: Object): any;
                        /**
                         * We are ready to go through all the contents(items).
                         * 
                         * @param items All the items fetched from the store             
                         */
                        beforeContent(items: any[]): any;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        beforeContentRow(arg_obj: Object): boolean;
                        /**
                         * We are going to start the travel in the grid.
                         * Is there anything we should do now?
                         * 
                         * @param grid             
                         */
                        beforeHeader(grid: dojox.grid.EnhancedGrid): any;
                        /**
                         * Before handling a subrow in a line (defined in the grid structure).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    view,viewIdx,    subrow,subrowIdx,    spCols(if isHeader==false)}             
                         */
                        beforeSubrow(argObj: Object): any;
                        /**
                         * Before handling a view.
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    view,viewIdx,    spCols(if isHeader==false)}             
                         */
                        beforeView(argObj: Object): any;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        handleCell(arg_obj: Object): void;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         */
                        toString(): number;
                    }
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/exporter/TableWriter.html
                     *
                     * Export grid to HTML table format. Primarily used by Printer plugin.
                     * 
                     * @param writerArgs       Optional    
                     */
                    class TableWriter extends dojox.grid.enhanced.plugins.exporter._ExportWriter {
                        constructor(writerArgs?: Object);
                        /**
                         * 
                         */
                        "argObj": Object;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         */
                        afterContent(): void;
                        /**
                         * After handling a line of data (not header).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    spCols}             
                         */
                        afterContentRow(argObj: Object): any;
                        /**
                         * The header line has been handled.
                         * 
                         */
                        afterHeader(): any;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        afterSubrow(arg_obj: Object): void;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        afterView(arg_obj: Object): void;
                        /**
                         * We are ready to go through all the contents(items).
                         * 
                         * @param items All the items fetched from the store             
                         */
                        beforeContent(items: any[]): any;
                        /**
                         * Before handling a line of data (not header).
                         * 
                         * @param argObj An object with at least the following context properties available:{    grid,isHeader,    row,rowIdx,    spCols}             
                         */
                        beforeContentRow(argObj: Object): any;
                        /**
                         * We are going to start the travel in the grid.
                         * Is there anything we should do now?
                         * 
                         * @param grid             
                         */
                        beforeHeader(grid: dojox.grid.EnhancedGrid): any;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        beforeSubrow(arg_obj: Object): boolean;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        beforeView(arg_obj: Object): boolean;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         * @param arg_obj             
                         */
                        handleCell(arg_obj: Object): void;
                        /**
                         * Overrided from _ExportWriter
                         * 
                         */
                        toString(): any;
                    }
                }

                module filter {
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/filter/FilterBuilder.html
                     *
                     * Create filter expression from a JSON object.
                     * 
                     */
                    class FilterBuilder {
                        constructor();
                        /**
                         * 
                         */
                        "defaultArgs": Object;
                        /**
                         * The builders of all supported operations
                         * 
                         */
                        "supportedOps": Object;
                        /**
                         * 
                         */
                        "supportedTypes": Object;
                        /**
                         * 
                         * @param def             
                         */
                        buildExpression(def: any): any;
                    }
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/filter/FilterDefDialog.html
                     *
                     * Create the filter definition UI.
                     * 
                     * @param args     
                     */
                    class FilterDefDialog {
                        constructor(args: any);
                        /**
                         * 
                         */
                        "curColIdx": number;
                        /**
                         * 
                         */
                        "plugin": Object;
                        /**
                         * Add cnt criteria boxes to the filter definition pane.
                         * Check overflow if necessary.
                         * 
                         * @param cnt             
                         */
                        addCriteriaBoxes(cnt: number): void;
                        /**
                         * 
                         */
                        canFilter(): boolean;
                        /**
                         * Clear filter definition.
                         * 
                         * @param noRefresh             
                         */
                        clearFilter(noRefresh: any): void;
                        /**
                         * Close the filter definition dialog.
                         * 
                         */
                        closeDialog(): void;
                        /**
                         * 
                         */
                        destroy(): void;
                        /**
                         * 
                         * @param v             
                         */
                        getColumnLabelByValue(v: any): any;
                        /**
                         * 
                         * @param colIndex             
                         */
                        getColumnType(colIndex: number): any;
                        /**
                         * 
                         * @param type             
                         * @param c             
                         */
                        getConditionLabelByValue(type: any, c: any): any;
                        /**
                         * Get the idx-th criteria.
                         * 
                         * @param idx             
                         */
                        getCriteria(idx: number): any;
                        /**
                         * 
                         * @param value             
                         * @param colIdx             
                         * @param type             
                         * @param condition             
                         */
                        getExprForColumn(value: any, colIdx: any, type: any, condition: any): Object;
                        /**
                         * 
                         * @param rule             
                         */
                        getExprForCriteria(rule: any): any;
                        /**
                         * 
                         */
                        getFilter(): Object;
                        /**
                         * Remove criteria boxes from the filter definition pane.
                         * 
                         * @param cnt             
                         * @param isIdx               Optional            
                         */
                        removeCriteriaBoxes(cnt: number, isIdx: boolean): void;
                        /**
                         * Remove criteria boxes from the filter definition pane.
                         * 
                         * @param cnt             
                         * @param isIdx               Optional            
                         */
                        removeCriteriaBoxes(cnt: Object, isIdx: boolean): void;
                        /**
                         * Remove criteria boxes from the filter definition pane.
                         * 
                         * @param cnt             
                         * @param isIdx               Optional            
                         */
                        removeCriteriaBoxes(cnt: number[], isIdx: boolean): void;
                        /**
                         * 
                         * @param rules             
                         * @param ruleRelation             
                         */
                        setFilter(rules: any, ruleRelation: any): void;
                        /**
                         * Show the filter defintion dialog.
                         * 
                         * @param colIndex             
                         */
                        showDialog(colIndex: number): void;
                        /**
                         * Triggered when the "Cancel" buttton is clicked.
                         * 
                         * @param e             
                         */
                        onCancel(e: any): void;
                        /**
                         * Triggered when the "Clear" button is clicked.
                         * 
                         * @param e             
                         */
                        onClearFilter(e: any): void;
                        /**
                         * Triggered when the "Filter" button is clicked.
                         * 
                         * @param e             
                         */
                        onFilter(e: any): void;
                        /**
                         * 
                         * @param sourceViewIndex             
                         * @param destViewIndex             
                         * @param cellIndex             
                         * @param targetIndex             
                         * @param before             
                         */
                        onMoveColumn(sourceViewIndex: any, destViewIndex: any, cellIndex: any, targetIndex: any, before: any): void;
                        /**
                         * Triggered when the rendering of the filter definition dialog is completely finished.
                         * 
                         * @param cbox Current visible criteria box             
                         */
                        onRendered(cbox: any): void;
                    }
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/filter/FilterStatusTip.html
                     *
                     * Create the status tip UI.
                     * 
                     * @param args     
                     */
                    class FilterStatusTip {
                        constructor(args: any);
                        /**
                         * 
                         */
                        closeDialog(): void;
                        /**
                         * 
                         */
                        destroy(): void;
                        /**
                         * 
                         * @param pos_x             
                         * @param pos_y             
                         * @param columnIdx             
                         */
                        showDialog(pos_x: number, pos_y: number, columnIdx: any): void;
                    }
                    /**
                     * Permalink: http://dojotoolkit.org/api/1.9/dojox/grid/enhanced/plugins/filter/ClearFilterConfirm.html
                     *
                     * The UI for user to confirm the operation of clearing filter.
                     * 
                     * @param params Hash of initialization parameters for widget, including scalar values (like title, duration etc.)and functions, typically callbacks like onClick.The hash can contain any of the widget's properties, excluding read-only properties.     
                     * @param srcNodeRef       OptionalIf a srcNodeRef (DOM node) is specified:use srcNodeRef.innerHTML as my contentsif this is a behavioral widget then apply behavior to that srcNodeRefotherwise, replace srcNodeRef with my generated DOM tree     
                     */
                    class ClearFilterConfirm extends dijit._Widget implements dijit._TemplatedMixin, dijit._WidgetsInTemplateMixin {
                        constructor(params?: Object, srcNodeRef?: HTMLElement);
                        /**
                         * Object to which attach points and events will be scoped.  Defaults
                         * to 'this'.
                         * 
                         */
                        "attachScope": Object;
               