// Type definitions for ExtJS 4.2.1
// Project: http://www.sencha.com/products/extjs/
// Definitions by: Brian Kotek <https://github.com/brian428/>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

declare module Ext {
	export interface IAbstractComponent extends Ext.IBase,Ext.util.IPositionable,Ext.util.IObservable,Ext.util.IAnimate,Ext.util.IElementContainer,Ext.util.IRenderable,Ext.state.IStateful {
		/** [Config Option] (String/Object) */
		autoEl?: any;
		/** [Config Option] (Ext.ComponentLoader/Object/String/Boolean) */
		autoLoad?: any;
		/** [Config Option] (Boolean/String/HTMLElement/Ext.Element) */
		autoRender?: any;
		/** [Config Option] (Boolean) */
		autoShow?: boolean;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Number/String/Boolean) */
		border?: any;
		/** [Config Option] (Object[]) */
		childEls?: any[];
		/** [Config Option] (String) */
		cls?: string;
		/** [Config Option] (String) */
		componentCls?: string;
		/** [Config Option] (String/Object) */
		componentLayout?: any;
		/** [Config Option] (String) */
		contentEl?: string;
		/** [Config Option] (Object) */
		data?: any;
		/** [Config Option] (Boolean) */
		disabled?: boolean;
		/** [Config Option] (String) */
		disabledCls?: string;
		/** [Config Option] (Boolean) */
		draggable?: boolean;
		/** [Config Option] (Boolean) */
		floating?: boolean;
		/** [Config Option] (Boolean) */
		frame?: boolean;
		/** [Config Option] (Number) */
		height?: number;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (String) */
		hideMode?: string;
		/** [Config Option] (String/Object) */
		html?: any;
		/** [Config Option] (String) */
		id?: string;
		/** [Config Option] (String) */
		itemId?: string;
		/** [Config Option] (Ext.ComponentLoader/Object) */
		loader?: any;
		/** [Config Option] (Number/String) */
		margin?: any;
		/** [Config Option] (Number) */
		maxHeight?: number;
		/** [Config Option] (Number) */
		maxWidth?: number;
		/** [Config Option] (Number) */
		minHeight?: number;
		/** [Config Option] (Number) */
		minWidth?: number;
		/** [Config Option] (String) */
		overCls?: string;
		/** [Config Option] (Number/String) */
		padding?: any;
		/** [Config Option] (Ext.AbstractPlugin[]/Ext.AbstractPlugin/Object[]/Object/Ext.enums.Plugin[]/Ext.enums.Plugin) */
		plugins?: any;
		/** [Config Option] (Object) */
		renderData?: any;
		/** [Config Option] (Object) */
		renderSelectors?: any;
		/** [Config Option] (String/HTMLElement/Ext.Element) */
		renderTo?: any;
		/** [Config Option] (Ext.XTemplate/String/String[]) */
		renderTpl?: any;
		/** [Config Option] (Boolean) */
		rtl?: boolean;
		/** [Config Option] (Boolean/Number) */
		shrinkWrap?: any;
		/** [Config Option] (String/Object) */
		style?: any;
		/** [Config Option] (Ext.XTemplate/Ext.Template/String/String[]) */
		tpl?: any;
		/** [Config Option] (String) */
		tplWriteMode?: string;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Number) */
		width?: number;
		/** [Config Option] (Ext.enums.Widget) */
		xtype?: Ext.enums.IWidget;
		/** [Property] (Boolean) */
		_isLayoutRoot?: boolean;
		/** [Property] (String) */
		contentPaddingProperty?: string;
		/** [Property] (Object) */
		frameSize?: any;
		/** [Property] (Boolean) */
		isComponent?: boolean;
		/** [Property] (Boolean) */
		maskOnDisable?: boolean;
		/** [Property] (Ext.Container) */
		ownerCt?: Ext.IContainer;
		/** [Property] (Boolean) */
		rendered?: boolean;
		/** [Method] Adds each argument passed to this method to the childEls array  */
		addChildEls?(): void;
		/** [Method] Adds a CSS class to the top level element representing this component  
		* @param cls String/String[] The CSS class name to add. 
		* @returns Ext.Component Returns the Component to allow method chaining. 
		*/
		addClass?( cls?:any ): Ext.IComponent;
		/** [Method] Adds a CSS class to the top level element representing this component  
		* @param cls String/String[] The CSS class name to add. 
		* @returns Ext.Component Returns the Component to allow method chaining. 
		*/
		addCls?( cls?:any ): Ext.IComponent;
		/** [Method] Adds a cls to the uiCls array which will also call addUIClsToElement and adds to all elements of this component  
		* @param classes String/String[] A string or an array of strings to add to the uiCls. 
		* @param skip Object (Boolean) skip true to skip adding it to the class and do it later (via the return). 
		*/
		addClsWithUI?( classes?:any, skip?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param element Object 
		* @param listeners Object 
		* @param scope Object 
		* @param options Object 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( element?:any, listeners?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Save a property to the given state object if it is not its default or configured value  
		* @param state Object The state object. 
		* @param propName String The name of the property on this object to save. 
		* @param value String The value of the state property (defaults to this[propName]). 
		* @returns Boolean The state object or a new object if state was null and the property was saved. 
		*/
		addPropertyToState?( state?:any, propName?:string, value?:string ): boolean;
		/** [Method] Add events that will trigger the state to be saved  
		* @param events String/String[] The event name or an array of event names. 
		*/
		addStateEvents?( events?:any ): void;
		/** [Method] Method which adds a specified UI  uiCls to the components element  
		* @param ui String The UI to remove from the element. 
		*/
		addUIClsToElement?( ui?:string ): void;
		/** [Method] Called by the layout system after the Component has been laid out  
		* @param width Number The width that was set 
		* @param height Number The height that was set 
		* @param oldWidth Number/undefined The old width, or undefined if this was the initial layout. 
		* @param oldHeight Number/undefined The old height, or undefined if this was the initial layout. 
		*/
		afterComponentLayout?( width?:number, height?:number, oldWidth?:any, oldHeight?:any ): void;
		/** [Method] Allows addition of behavior after rendering is complete  */
		afterRender?(): void;
		/** [Method] Template method called after a Component has been positioned  
		* @param x Number 
		* @param y Number 
		*/
		afterSetPosition?( x?:number, y?:number ): void;
		/** [Method] Aligns the element with another element relative to the specified anchor points  
		* @param element Ext.util.Positionable/HTMLElement/String The Positionable, HTMLElement, or id of the element to align to. 
		* @param position String The position to align to 
		* @param offsets Number[] Offset the positioning by [x, y] 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.util.Positionable this 
		*/
		alignTo?( element?:any, position?:string, offsets?:number[], animate?:any ): Ext.util.IPositionable;
		/** [Method] Anchors an element to another element and realigns it when the window is resized  
		* @param element Ext.util.Positionable/HTMLElement/String The Positionable, HTMLElement, or id of the element to align to. 
		* @param position String The position to align to 
		* @param offsets Number[] Offset the positioning by [x, y] 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @param monitorScroll Boolean/Number True to monitor body scroll and reposition. If this parameter is a number, it is used as the buffer delay in milliseconds. 
		* @param callback Function The function to call after the animation finishes 
		* @returns Ext.util.Positionable this 
		*/
		anchorTo?( element?:any, position?:string, offsets?:number[], animate?:any, monitorScroll?:any, callback?:any ): Ext.util.IPositionable;
		/** [Method] Performs custom animation on this object. ... */
		animate?: any;
		/** [Method] Applies the state to the object  
		* @param state Object The state 
		*/
		applyState?( state?:any ): void;
		/** [Method] Template method to do any pre blur processing  
		* @param e Ext.EventObject The event object 
		*/
		beforeBlur?( e?:Ext.IEventObject ): void;
		/** [Method] Occurs before componentLayout is run  
		* @param adjWidth Number The box-adjusted width that was set. 
		* @param adjHeight Number The box-adjusted height that was set. 
		*/
		beforeComponentLayout?( adjWidth?:number, adjHeight?:number ): void;
		/** [Method] Invoked before the Component is destroyed  */
		beforeDestroy?(): void;
		/** [Method] Template method to do any pre focus processing  
		* @param e Ext.EventObject The event object 
		*/
		beforeFocus?( e?:Ext.IEventObject ): void;
		/** [Method] Occurs before componentLayout is run  */
		beforeLayout?(): void;
		/** [Method] Calculates the new x y position to move this Positionable into a constrain region  
		* @param constrainTo String/HTMLElement/Ext.Element/Ext.util.Region The Element or Region into which this Component is to be constrained. Defaults to the element into which this Positionable was rendered, or this Component's {@link Ext.Component.constrainTo. 
		* @param proposedPosition Number[] A proposed [X, Y] position to test for validity and to coerce into constraints instead of using this Positionable's current position. 
		* @param local Boolean The proposedPosition is local (relative to floatParent if a floating Component) 
		* @param proposedSize Number[] A proposed [width, height] size to use when calculating constraints instead of using this Positionable's current size. 
		* @returns Number[] If the element needs to be translated, the new [X, Y] position within constraints if possible, giving priority to keeping the top and left edge in the constrain region. Otherwise, false. 
		*/
		calculateConstrainedPosition?( constrainTo?:any, proposedPosition?:number[], local?:boolean, proposedSize?:number[] ): number[];
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Destroys the Component  */
		destroy?(): void;
		/** [Method] Disable the component  
		* @param silent Boolean Passing true will suppress the disable event from being fired. 
		*/
		disable?( silent?:boolean ): void;
		/** [Method] Handles autoRender  */
		doAutoRender?(): void;
		/** [Method] This method needs to be called whenever you change something on this component that requires the Component s layout t  
		* @returns Ext.container.Container this 
		*/
		doComponentLayout?(): Ext.container.IContainer;
		/** [Method] Enable the component 
		* @param silent Boolean Passing true will suppress the enable event from being fired. 
		*/
		enable?( silent?:boolean ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Ensures that this component is attached to document body  
		* @param runLayout Boolean True to run the component's layout. 
		*/
		ensureAttachedToBody?( runLayout?:boolean ): void;
		/** [Method] Retrieves plugin from this component s collection by its ptype  
		* @param ptype String The Plugin's ptype as specified by the class's alias configuration. 
		* @returns Ext.AbstractPlugin plugin instance. 
		*/
		findPlugin?( ptype?:string ): Ext.IAbstractPlugin;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Forces this component to redo its componentLayout  */
		forceComponentLayout?(): void;
		/** [Method] Returns the current animation if this object has any effects actively running or queued else returns false  
		* @returns Ext.fx.Anim/Boolean Anim if element has active effects, else false 
		*/
		getActiveAnimation?(): any;
		/** [Method] Gets the x y coordinates to align this element with another element  
		* @param element Ext.util.Positionable/HTMLElement/String The Positionable, HTMLElement, or id of the element to align to. 
		* @param position String The position to align to 
		* @param offsets Number[] Offset the positioning by [x, y] 
		* @returns Number[] [x, y] 
		*/
		getAlignToXY?( element?:any, position?:string, offsets?:number[] ): number[];
		/** [Method] Gets the x y coordinates specified by the anchor position on the element  
		* @param anchor String The specified anchor position. See alignTo for details on supported anchor positions. 
		* @param local Boolean True to get the local (element top/left-relative) anchor position instead of page coordinates 
		* @param size Object An object containing the size to use for calculating anchor position {width: (target width), height: (target height)} (defaults to the element's current size) 
		* @returns Number[] [x, y] An array containing the element's x and y coordinates 
		*/
		getAnchorXY?( anchor?:string, local?:boolean, size?:any ): number[];
		/** [Method] Return an object defining the area of this Element which can be passed to setBox to set another Element s size locati  
		* @param contentBox Boolean If true a box for the content of the element is returned. 
		* @param local Boolean If true the element's left and top relative to its offsetParent are returned instead of page x/y. 
		* @returns Object box An object in the format: {  x: &lt;Element's X position&gt;,  y: &lt;Element's Y position&gt;,  left: &lt;Element's X position (an alias for x)&gt;,  top: &lt;Element's Y position (an alias for y)&gt;,  width: &lt;Element's width&gt;,  height: &lt;Element's height&gt;,  bottom: &lt;Element's lower bound&gt;,  right: &lt;Element's rightmost bound&gt; }  The returned object may also be addressed as an Array where index 0 contains the X position and index 1 contains the Y position. The result may also be used for setXY 
		*/
		getBox?( contentBox?:boolean, local?:boolean ): any;
		/** [Method] Provides the link for Observable s fireEvent method to bubble up the ownership hierarchy  
		* @returns Ext.container.Container the Container which owns this Component. 
		*/
		getBubbleTarget?(): Ext.container.IContainer;
		/** [Method] Returns the X Y vector by which this Positionable s element must be translated to make a best attempt to constrain  
		* @param constrainTo Ext.util.Positionable/HTMLElement/String/Ext.util.Region The Positionable, HTMLElement, element id, or Region into which the element is to be constrained. 
		* @param proposedPosition Number[] A proposed [X, Y] position to test for validity and to produce a vector for instead of using the element's current position 
		* @param proposedSize Number[] A proposed [width, height] size to constrain instead of using the element's current size 
		* @returns Number[]/Boolean If the element needs to be translated, an [X, Y] vector by which this element must be translated. Otherwise, false. 
		*/
		getConstrainVector?( constrainTo?:any, proposedPosition?:number[], proposedSize?:number[] ): any;
		/** [Method] Retrieves the top level element representing this component  
		* @returns Ext.dom.Element 
		*/
		getEl?(): Ext.dom.IElement;
		/** [Method] Gets the current height of the component s underlying element  
		* @returns Number 
		*/
		getHeight?(): number;
		/** [Method] Retrieves the id of this component  
		* @returns String 
		*/
		getId?(): string;
		/** [Method] This function takes the position argument passed to onRender and returns a DOM element that you can use in the insert  
		* @param position String/Number/Ext.dom.Element/HTMLElement Index, element id or element you want to put this component before. 
		* @returns HTMLElement DOM element that you can use in the insertBefore 
		*/
		getInsertPosition?( position?:any ): HTMLElement;
		/** [Method] Returns the value of itemId assigned to this component or when that is not set returns the value of id  
		* @returns String 
		*/
		getItemId?(): string;
		/** [Method] Gets the Ext ComponentLoader for this Component  
		* @returns Ext.ComponentLoader The loader instance, null if it doesn't exist. 
		*/
		getLoader?(): Ext.IComponentLoader;
		/** [Method] Overridden in Ext rtl AbstractComponent  
		* @returns Number The local x coordinate 
		*/
		getLocalX?(): number;
		/** [Method] Overridden in Ext rtl AbstractComponent  
		* @returns Number[] The local XY position of the element 
		*/
		getLocalXY?(): number[];
		/** [Method] Returns the y coordinate of this element reletive to its offsetParent  
		* @returns Number The local y coordinate 
		*/
		getLocalY?(): number;
		/** [Method] Returns the offsets of this element from the passed element  
		* @param offsetsTo Ext.util.Positionable/HTMLElement/String The Positionable, HTMLElement, or element id to get get the offsets from. 
		* @returns Number[] The XY page offsets (e.g. [100, -200]) 
		*/
		getOffsetsTo?( offsetsTo?:any ): number[];
		/** [Method] Retrieves a plugin from this component s collection by its pluginId  
		* @param pluginId String 
		* @returns Ext.AbstractPlugin plugin instance. 
		*/
		getPlugin?( pluginId?:string ): Ext.IAbstractPlugin;
		/** [Method] Returns a region object that defines the area of this element  
		* @returns Ext.util.Region A Region containing "top, left, bottom, right" properties. 
		*/
		getRegion?(): Ext.util.IRegion;
		/** [Method] Gets the current size of the component s underlying element  
		* @returns Object An object containing the element's size {width: (element width), height: (element height)} 
		*/
		getSize?(): any;
		/** [Method] Returns an object that describes how this component s width and height are managed  
		* @param ownerCtSizeModel Object 
		* @returns Object The size model for this component. 
		*/
		getSizeModel?( ownerCtSizeModel?:any ): any;
		/** [Method] The supplied default state gathering method for the AbstractComponent class  
		* @returns Object 
		*/
		getState?(): any;
		/** [Method] Returns the content region of this element  
		* @returns Ext.util.Region A Region containing "top, left, bottom, right" member data. 
		*/
		getViewRegion?(): Ext.util.IRegion;
		/** [Method] Gets the current width of the component s underlying element  
		* @returns Number 
		*/
		getWidth?(): number;
		/** [Method] Gets the current X position of the DOM element based on page coordinates  
		* @returns Number The X position of the element 
		*/
		getX?(): number;
		/** [Method] Returns this Component s xtype hierarchy as a slash delimited string  
		* @returns String The xtype hierarchy string 
		*/
		getXTypes?(): string;
		/** [Method] Gets the current position of the DOM element based on page coordinates  
		* @returns Number[] The XY position of the element 
		*/
		getXY?(): number[];
		/** [Method] Gets the current Y position of the DOM element based on page coordinates  
		* @returns Number The Y position of the element 
		*/
		getY?(): number;
		/** [Method] Returns the current animation if this object has any effects actively running or queued else returns false  
		* @returns Ext.fx.Anim/Boolean Anim if element has active effects, else false 
		*/
		hasActiveFx?(): any;
		/** [Method] Checks if the specified CSS class exists on this element s DOM node  
		* @param className String The CSS class to check for. 
		* @returns Boolean true if the class exists, else false. 
		*/
		hasCls?( className?:string ): boolean;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Checks if there is currently a specified uiCls  
		* @param cls String The cls to check. 
		*/
		hasUICls?( cls?:string ): void;
		/** [Method] Initialize any events on this component */
		initEvents?(): void;
		/** [Method] Initialized the renderData to be used when rendering the renderTpl  
		* @returns Object Object with keys and values that are going to be applied to the renderTpl 
		*/
		initRenderData?(): any;
		/** [Method] Tests whether this Component matches the selector string  
		* @param selector String The selector string to test against. 
		* @returns Boolean true if this Component matches the selector. 
		*/
		is?( selector?:string ): boolean;
		/** [Method] Determines whether this component is the descendant of a particular container  
		* @param container Ext.Container 
		* @returns Boolean true if the component is the descendant of a particular container, otherwise false. 
		*/
		isDescendantOf?( container?:Ext.IContainer ): boolean;
		/** [Method] Method to determine whether this Component is currently disabled  
		* @returns Boolean the disabled state of this Component. 
		*/
		isDisabled?(): boolean;
		/** [Method] Method to determine whether this Component is draggable  
		* @returns Boolean the draggable state of this component. 
		*/
		isDraggable?(): boolean;
		/** [Method] Method to determine whether this Component is droppable  
		* @returns Boolean the droppable state of this component. 
		*/
		isDroppable?(): boolean;
		/** [Method] Method to determine whether this Component is floating  
		* @returns Boolean the floating state of this component. 
		*/
		isFloating?(): boolean;
		/** [Method] Method to determine whether this Component is currently set to hidden  
		* @returns Boolean the hidden state of this Component. 
		*/
		isHidden?(): boolean;
		/** [Method] Determines whether this Component is the root of a layout  */
		isLayoutRoot?(): void;
		/** [Method] Returns true if layout is suspended for this component  
		* @returns Boolean true layout of this component is suspended. 
		*/
		isLayoutSuspended?(): boolean;
		/** [Method] Returns true if this component is visible  
		* @param deep Boolean Pass true to interrogate the visibility status of all parent Containers to determine whether this Component is truly visible to the user. Generally, to determine whether a Component is hidden, the no argument form is needed. For example when creating dynamically laid out UIs in a hidden Container before showing them. 
		* @returns Boolean true if this component is visible, false otherwise. 
		*/
		isVisible?( deep?:boolean ): boolean;
		/** [Method] Tests whether or not this Component is of a specific xtype  
		* @param xtype String The xtype to check for this Component 
		* @param shallow Boolean true to check whether this Component is directly of the specified xtype, false to check whether this Component is descended from the xtype. 
		* @returns Boolean true if this component descends from the specified xtype, false otherwise. 
		*/
		isXType?( xtype?:string, shallow?:boolean ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Move the element relative to its current position  
		* @param direction String Possible values are:  "l" (or "left") "r" (or "right") "t" (or "top", or "up") "b" (or "bottom", or "down")  
		* @param distance Number How far to move the element in pixels 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		*/
		move?( direction?:string, distance?:number, animate?:any ): void;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Returns the next node in the Component tree in tree traversal order  
		* @param selector String A ComponentQuery selector to filter the following nodes. 
		* @returns Ext.Component The next node (or the next node which matches the selector). Returns null if there is no matching node. 
		*/
		nextNode?( selector?:string ): Ext.IComponent;
		/** [Method] Returns the next sibling of this Component  
		* @param selector String A ComponentQuery selector to filter the following items. 
		* @returns Ext.Component The next sibling (or the next sibling which matches the selector). Returns null if there is no matching sibling. 
		*/
		nextSibling?( selector?:string ): Ext.IComponent;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Method to manage awareness of when components are added to their respective Container firing an added event  
		* @param container Ext.container.Container Container which holds the component. 
		* @param pos Number Position at which the component was added. 
		*/
		onAdded?( container?:Ext.container.IContainer, pos?:number ): void;
		/** [Method] Allows addition of behavior to the disable operation  */
		onDisable?(): void;
		/** [Method] Allows addition of behavior to the enable operation  */
		onEnable?(): void;
		/** [Method] Called after the component is moved this method is empty by default but can be implemented by any subclass that need  
		* @param x Number The new x position. 
		* @param y Number The new y position. 
		*/
		onPosition?( x?:number, y?:number ): void;
		/** [Method] Method to manage awareness of when components are removed from their respective Container firing a removed event  
		* @param destroying Boolean Will be passed as true if the Container performing the remove operation will delete this Component upon remove. 
		*/
		onRemoved?( destroying?:boolean ): void;
		/** [Method] Template method called when this Component s DOM structure is created  
		* @param parentNode Ext.core.Element The parent Element in which this Component's encapsulating element is contained. 
		* @param containerIdx Number The index within the parent Container's child collection of this Component. 
		*/
		onRender?( parentNode?:Ext.core.IElement, containerIdx?:number ): void;
		/** [Method] Allows addition of behavior to the resize operation  
		* @param width Object 
		* @param height Object 
		* @param oldWidth Object 
		* @param oldHeight Object 
		*/
		onResize?( width?:any, height?:any, oldWidth?:any, oldHeight?:any ): void;
		/** [Method] Template method to do any post blur processing  
		* @param e Ext.EventObject The event object 
		*/
		postBlur?( e?:Ext.IEventObject ): void;
		/** [Method] Returns the previous node in the Component tree in tree traversal order  
		* @param selector String A ComponentQuery selector to filter the preceding nodes. 
		* @returns Ext.Component The previous node (or the previous node which matches the selector). Returns null if there is no matching node. 
		*/
		previousNode?( selector?:string ): Ext.IComponent;
		/** [Method] Returns the previous sibling of this Component  
		* @param selector String A ComponentQuery selector to filter the preceding items. 
		* @returns Ext.Component The previous sibling (or the previous sibling which matches the selector). Returns null if there is no matching sibling. 
		*/
		previousSibling?( selector?:string ): Ext.IComponent;
		/** [Method] Called by Component doAutoRender Register a Container configured floating true with this Component s ZIndexManager  
		* @param cmp Object 
		*/
		registerFloatingItem?( cmp?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Remove any anchor to this element  
		* @returns Ext.util.Positionable this 
		*/
		removeAnchor?(): Ext.util.IPositionable;
		/** [Method] Removes items in the childEls array based on the return value of a supplied test function  
		* @param testFn Function The test function. 
		*/
		removeChildEls?( testFn?:any ): void;
		/** [Method] Removes a CSS class from the top level element representing this component  
		* @param cls String/String[] The CSS class name to remove. 
		* @returns Ext.Component Returns the Component to allow method chaining. 
		*/
		removeCls?( cls?:any ): Ext.IComponent;
		/** [Method] Removes a cls to the uiCls array which will also call removeUIClsFromElement and removes it from all elements of thi  
		* @param cls String/String[] A string or an array of strings to remove to the uiCls. 
		*/
		removeClsWithUI?( cls?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Method which removes a specified UI  uiCls from the components element  
		* @param ui String The UI to add to the element. 
		*/
		removeUIClsFromElement?( ui?:string ): void;
		/** [Method] Renders the Component into the passed HTML element  
		* @param container Ext.Element/HTMLElement/String The element this Component should be rendered into. If it is being created from existing markup, this should be omitted. 
		* @param position String/Number The element ID or DOM node index within the container before which this component will be inserted (defaults to appending to the end of the container) 
		*/
		render?( container?:any, position?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Conditionally saves a single property from this object to the given state object  
		* @param propName String The name of the property to save. 
		* @param state Object The state object in to which to save the property. 
		* @param stateName String The name to use for the property in state. 
		* @returns Boolean True if the property was saved, false if not. 
		*/
		savePropToState?( propName?:string, state?:any, stateName?:string ): boolean;
		/** [Method] Gathers additional named properties of the instance and adds their current values to the passed state object  
		* @param propNames String/String[] The name (or array of names) of the property to save. 
		* @param state Object The state object in to which to save the property values. 
		* @returns Object state 
		*/
		savePropsToState?( propNames?:any, state?:any ): any;
		/** [Method] Saves the state of the object to the persistence store  */
		saveState?(): void;
		/** [Method] Ensures that all effects queued after sequenceFx is called on this object are run in sequence  
		* @returns Object this 
		*/
		sequenceFx?(): any;
		/** [Method]  
		* @param border String/Number The border, see border. If a falsey value is passed the border will be removed. 
		*/
		setBorder?( border?:any ): void;
		/** [Method] Sets the element s box  
		* @param box Object The box to fill {x, y, width, height} 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.util.Positionable this 
		*/
		setBox?( box?:any, animate?:any ): Ext.util.IPositionable;
		/** [Method] Enable or disable the component  
		* @param disabled Boolean true to disable. 
		*/
		setDisabled?( disabled?:boolean ): void;
		/** [Method] Sets the dock position of this component in its parent panel  
		* @param dock Object The dock position. 
		* @param layoutParent Boolean true to re-layout parent. 
		* @returns Ext.Component this 
		*/
		setDocked?( dock?:any, layoutParent?:boolean ): Ext.IComponent;
		/** [Method] Sets the height of the component  
		* @param height Number The new height to set. This may be one of:  A Number specifying the new height in the Element's Ext.Element.defaultUnits (by default, pixels). A String used to set the CSS height style. undefined to leave the height unchanged.  
		* @returns Ext.Component this 
		*/
		setHeight?( height?:number ): Ext.IComponent;
		/** [Method] Overridden in Ext rtl AbstractComponent  
		* @param x Object 
		* @returns Ext.util.Positionable this 
		*/
		setLocalX?( x?:any ): Ext.util.IPositionable;
		/** [Method] Overridden in Ext rtl AbstractComponent  
		* @param x Object 
		* @param y Object 
		* @returns Ext.util.Positionable this 
		*/
		setLocalXY?( x?:any, y?:any ): Ext.util.IPositionable;
		/** [Method] Sets the local y coordinate of this element using CSS style  
		* @param y Object 
		* @returns Ext.util.Positionable this 
		*/
		setLocalY?( y?:any ): Ext.util.IPositionable;
		/** [Method] Sets the margin on the target element  
		* @param margin Number/String The margin to set. See the margin config. 
		*/
		setMargin?( margin?:any ): void;
		/** [Method] Sets the element s position and size to the specified region  
		* @param region Ext.util.Region The region to fill 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.util.Positionable this 
		*/
		setRegion?( region?:Ext.util.IRegion, animate?:any ): Ext.util.IPositionable;
		/** [Method] Sets the width and height of this Component  
		* @param width Number/String/Object The new width to set. This may be one of:  A Number specifying the new width in the Element's Ext.Element.defaultUnits (by default, pixels). A String used to set the CSS width style. A size object in the format {width: widthValue, height: heightValue}. undefined to leave the width unchanged.  
		* @param height Number/String The new height to set (not required if a size object is passed as the first arg). This may be one of:  A Number specifying the new height in the Element's Ext.Element.defaultUnits (by default, pixels). A String used to set the CSS height style. Animation may not be used. undefined to leave the height unchanged.  
		* @returns Ext.Component this 
		*/
		setSize?( width?:any, height?:any ): Ext.IComponent;
		/** [Method] Sets the UI for the component  
		* @param ui String The new UI for the component. 
		*/
		setUI?( ui?:string ): void;
		/** [Method] Convenience function to hide or show this component by Boolean  
		* @param visible Boolean true to show, false to hide. 
		* @returns Ext.Component this 
		*/
		setVisible?( visible?:boolean ): Ext.IComponent;
		/** [Method] Sets the width of the component  
		* @param width Number The new width to setThis may be one of:  A Number specifying the new width in the Element's Ext.Element.defaultUnits (by default, pixels). A String used to set the CSS width style.  
		* @returns Ext.Component this 
		*/
		setWidth?( width?:number ): Ext.IComponent;
		/** [Method] Sets the X position of the DOM element based on page coordinates  
		* @param x Object 
		* @param animate Object 
		* @returns Ext.util.Positionable this 
		*/
		setX?( x?:any, animate?:any ): Ext.util.IPositionable;
		/** [Method] Sets the position of the DOM element in page coordinates  
		* @param xy Object 
		* @param animate Object 
		* @returns Ext.util.Positionable this 
		*/
		setXY?( xy?:any, animate?:any ): Ext.util.IPositionable;
		/** [Method] Sets the Y position of the DOM element based on page coordinates  
		* @param y Object 
		* @param animate Object 
		* @returns Ext.util.Positionable this 
		*/
		setY?( y?:any, animate?:any ): Ext.util.IPositionable;
		/** [Method] Stops any running effects and clears this object s internal effects queue if it contains any additional effects that 
		* @returns Ext.Element The Element 
		*/
		stopAnimation?(): Ext.IElement;
		/** [Method] Stops any running effects and clears this object s internal effects queue if it contains any additional effects that 
		* @returns Ext.Element The Element 
		*/
		stopFx?(): Ext.IElement;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Ensures that all effects queued after syncFx is called on this object are run concurrently  
		* @returns Object this 
		*/
		syncFx?(): any;
		/** [Method] Translates the passed page coordinates into left top css values for the element 
		* @param x Number/Array The page x or an array containing [x, y] 
		* @param y Number The page y, required if x is not an array 
		* @returns Object An object with left and top properties. e.g. {left: (value), top: (value)} 
		*/
		translatePoints?( x?:any, y?:number ): any;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Navigates up the ownership hierarchy searching for an ancestor Container which matches any passed simple selector or 
		* @param selector String/Ext.Component The simple selector component or actual component to test. If not passed the immediate owner/activater is returned. 
		* @param limit String/Number/Ext.Component This may be a selector upon which to stop the upward scan, or a limit of teh number of steps, or Component reference to stop on. 
		* @returns Ext.container.Container The matching ancestor Container (or undefined if no match was found). 
		*/
		up?( selector?:any, limit?:any ): Ext.container.IContainer;
		/** [Method] Update the content area of a component  
		* @param htmlOrData String/Object If this component has been configured with a template via the tpl config then it will use this argument as data to populate the template. If this component was not configured with a template, the components content area will be updated via Ext.Element update. 
		* @param loadScripts Boolean Only legitimate when using the html configuration. 
		* @param callback Function Only legitimate when using the html configuration. Callback to execute when scripts have finished loading. 
		*/
		update?( htmlOrData?:any, loadScripts?:boolean, callback?:any ): void;
		/** [Method] Updates this component s layout  
		* @param options Object An object with layout options. 
		*/
		updateLayout?( options?:any ): void;
	}
	export class AbstractComponent {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Cancels layout of a component  
		* @param comp Ext.Component 
		*/
		static cancelLayout( comp?:Ext.IComponent ): void;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Performs all pending layouts that were scheduled while suspendLayouts was in effect  */
		static flushLayouts(): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Resumes layout activity in the whole framework  
		* @param flush Boolean true to perform all the pending layouts. This can also be achieved by calling flushLayouts directly. 
		*/
		static resumeLayouts( flush?:boolean ): void;
		/** [Method] Stops layouts from happening in the whole framework  */
		static suspendLayouts(): void;
		/** [Method] Updates layout of a component  
		* @param comp Ext.Component The component to update. 
		* @param defer Boolean true to just queue the layout if this component. 
		*/
		static updateLayout( comp?:Ext.IComponent, defer?:boolean ): void;
	}
}
declare module Ext {
	export interface IAbstractManager extends Ext.IBase {
		/** [Property] (Ext.util.HashMap) */
		all?: Ext.util.IHashMap;
		/** [Method] Creates and returns an instance of whatever this manager manages based on the supplied type and config object  
		* @param config Object The config object 
		* @param defaultType String If no type is discovered in the config object, we fall back to this type 
		* @returns Object The instance of whatever this manager is managing 
		*/
		create?( config?:any, defaultType?:string ): any;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. Defaults to this. 
		*/
		each?( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item 
		* @returns Object The item, undefined if not found. 
		*/
		get?( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		getCount?(): number;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up 
		* @returns Boolean Whether the type is registered. 
		*/
		isRegistered?( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		onAvailable?( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed 
		* @param item Object The item to register 
		*/
		register?( item?:any ): void;
		/** [Method] Registers a new item constructor keyed by a type key  
		* @param type String The mnemonic string by which the class may be looked up. 
		* @param cls Function The new instance class. 
		*/
		registerType?( type?:string, cls?:any ): void;
		/** [Method] Unregisters an item by removing it from this manager 
		* @param item Object The item to unregister 
		*/
		unregister?( item?:any ): void;
	}
}
declare module Ext {
	export interface IAbstractPlugin extends Ext.IBase {
		/** [Config Option] (String) */
		pluginId?: string;
		/** [Property] (Boolean) */
		isPlugin?: boolean;
		/** [Method] Creates clone of the plugin  
		* @param overrideCfg Object Additional config for the derived plugin. 
		*/
		clonePlugin?( overrideCfg?:any ): void;
		/** [Method] The destroy method is invoked by the owning Component at the time the Component is being destroyed  */
		destroy?(): void;
		/** [Method] The base implementation just sets the plugin s disabled flag to true Plugin subclasses which need more complex proce  */
		disable?(): void;
		/** [Method] The base implementation just sets the plugin s disabled flag to false Plugin subclasses which need more complex proc  */
		enable?(): void;
		/** [Method] Returns the component to which this plugin is attached  
		* @returns Ext.Component Owner component. 
		*/
		getCmp?(): Ext.IComponent;
		/** [Method] The init method is invoked after initComponent method has been run for the client Component  
		* @param client Ext.Component The client Component which owns this plugin. 
		*/
		init?( client?:Ext.IComponent ): void;
		/** [Method] Sets the component to which this plugin is attached  
		* @param cmp Ext.Component Owner component. 
		*/
		setCmp?( cmp?:Ext.IComponent ): void;
	}
}
declare module Ext {
	export interface IAction extends Ext.IBase {
		/** [Config Option] (Boolean) */
		disabled?: boolean;
		/** [Config Option] (Function) */
		handler?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (String) */
		iconCls?: string;
		/** [Config Option] (String) */
		itemId?: string;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (String) */
		text?: string;
		/** [Method] Disables all components configured by this Action  */
		disable?(): void;
		/** [Method] Executes the specified function once for each Component currently tied to this Action  
		* @param fn Function The function to execute for each component 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Component. 
		*/
		each?( fn?:any, scope?:any ): void;
		/** [Method] Enables all components configured by this Action  */
		enable?(): void;
		/** [Method] Executes this Action manually using the handler function specified in the original config object or the handler funct  
		* @param args Object... Variable number of arguments passed to the handler function 
		*/
		execute?( ...args:any[] ): void;
		/** [Method] Gets the icon CSS class currently used by all components configured by this Action  */
		getIconCls?(): void;
		/** [Method] Gets the text currently displayed by all components configured by this Action  */
		getText?(): void;
		/** [Method] Hides all components configured by this Action  */
		hide?(): void;
		/** [Method] Returns true if the components using this Action are currently disabled else returns false  */
		isDisabled?(): void;
		/** [Method] Returns true if the components configured by this Action are currently hidden else returns false  */
		isHidden?(): void;
		/** [Method] Sets the disabled state of all components configured by this Action  
		* @param disabled Boolean True to disable the component, false to enable it 
		*/
		setDisabled?( disabled?:boolean ): void;
		/** [Method] Sets the function that will be called by each Component using this action when its primary event is triggered  
		* @param fn Function The function that will be invoked by the action's components. The function will be called with no arguments. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Component firing the event. 
		*/
		setHandler?( fn?:any, scope?:any ): void;
		/** [Method] Sets the hidden state of all components configured by this Action  
		* @param hidden Boolean True to hide the component, false to show it. 
		*/
		setHidden?( hidden?:boolean ): void;
		/** [Method] Sets the icon CSS class for all components configured by this Action  
		* @param cls String The CSS class supplying the icon image 
		*/
		setIconCls?( cls?:string ): void;
		/** [Method] Sets the text to be displayed by all components configured by this Action  
		* @param text String The text to display 
		*/
		setText?( text?:string ): void;
		/** [Method] Shows all components configured by this Action  */
		show?(): void;
	}
}
declare module Ext {
	export interface IAjax extends Ext.data.IConnection {
	}
	export class Ajax {
		/** [Property] (Boolean) */
		static autoAbort: boolean;
		/** [Property] (Object) */
		static defaultHeaders: any;
		/** [Property] (Boolean) */
		static disableCaching: boolean;
		/** [Property] (Object) */
		static extraParams: any;
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (String) */
		static method: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Number) */
		static timeout: number;
		/** [Property] (String) */
		static url: string;
		/** [Method] Aborts an active request  
		* @param request Object Defaults to the last request 
		*/
		static abort( request?:any ): void;
		/** [Method] Aborts all active requests */
		static abortAll(): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Determines whether this object has a request outstanding  
		* @param request Object Defaults to the last transaction 
		* @returns Boolean True if there is an outstanding request. 
		*/
		static isLoading( request?:any ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Checks if the response status was successful 
		* @param status Number The status code 
		* @returns Object An object containing success/status state 
		*/
		static parseStatus( status?:number ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Sends an HTTP request to a remote server  
		* @param options Object An object which may contain the following properties: (The options object may also contain any other property which might be needed to perform postprocessing in a callback because it is passed to callback functions.) 
		* @returns Object The request object. This may be used to cancel the request. 
		*/
		static request( options?:any ): any;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Sets various options such as the url params for the request 
		* @param options Object The initial options 
		* @param scope Object The scope to execute in 
		* @returns Object The params for the request 
		*/
		static setOptions( options?:any, scope?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Uploads a form using a hidden iframe  
		* @param form String/HTMLElement/Ext.Element The form to upload 
		* @param url String The url to post to 
		* @param params String Any extra parameters to pass 
		* @param options Object The initial options 
		*/
		static upload( form?:any, url?:string, params?:string, options?:any ): void;
	}
}
declare module Ext.app {
	export interface IApplication extends Ext.app.IController {
		/** [Config Option] (String) */
		appFolder?: string;
		/** [Config Option] (String) */
		appProperty?: string;
		/** [Config Option] (Boolean) */
		autoCreateViewport?: boolean;
		/** [Config Option] (String/String[]) */
		controllers?: any;
		/** [Config Option] (Boolean) */
		enableQuickTips?: boolean;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (String/String[]) */
		namespaces?: any;
		/** [Config Option] (Object) */
		paths?: any;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Method] Returns the base Ext app Application for this controller  
		* @returns Ext.app.Application the application 
		*/
		getApplication?(): Ext.app.IApplication;
		/** [Method] Returns instance of a Controller with the given id  
		* @param name Object 
		* @returns Ext.app.Controller controller instance or undefined. 
		*/
		getController?( name?:any ): Ext.app.IController;
		/** [Method] Called automatically when the page has completely loaded  
		* @param profile String The detected application profile 
		* @returns Boolean By default, the Application will dispatch to the configured startup controller and action immediately after running the launch function. Return false to prevent this behavior. 
		*/
		launch?( profile?:string ): boolean;
	}
}
declare module Ext.app {
	export interface IController extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (String) */
		id?: string;
		/** [Config Option] (String/String[]) */
		models?: any;
		/** [Config Option] (Object[]) */
		refs?: any[];
		/** [Config Option] (String/String[]) */
		stores?: any;
		/** [Config Option] (String/String[]) */
		views?: any;
		/** [Property] (Ext.app.Application) */
		application?: Ext.app.IApplication;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Registers one or more references  
		* @param refs Object/Object[] 
		*/
		addRef?( refs?:any ): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Adds listeners to components selected via Ext ComponentQuery  
		* @param selectors String/Object If a String, the second argument is used as the listeners, otherwise an object of selectors -> listeners is assumed 
		* @param listeners Object Config for listeners. 
		*/
		control?( selectors?:any, listeners?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the base Ext app Application for this controller  
		* @returns Ext.app.Application the application 
		*/
		getApplication?(): Ext.app.IApplication;
		/** [Method] Returns instance of a Controller with the given id  
		* @param id String 
		* @returns Ext.app.Controller controller instance or undefined. 
		*/
		getController?( id?:string ): Ext.app.IController;
		/** [Method] Returns a Model class with the given name  
		* @param name String 
		* @returns Ext.data.Model a model class. 
		*/
		getModel?( name?:string ): Ext.data.IModel;
		/** [Method] Returns instance of a Store with the given name  
		* @param name String 
		* @returns Ext.data.Store a store instance. 
		*/
		getStore?( name?:string ): Ext.data.IStore;
		/** [Method] Returns a View class with the given name  
		* @param name String 
		* @returns Ext.Base a view class. 
		*/
		getView?( name?:string ): Ext.IBase;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Returns true if a reference is registered  
		* @param ref Object 
		* @returns Boolean 
		*/
		hasRef?( ref?:any ): boolean;
		/** [Method] A template method that is called when your application boots  
		* @param application Ext.app.Application 
		*/
		init?( application?:Ext.app.IApplication ): void;
		/** [Method] Adds listeners to different event sources also called event domains  
		* @param to Object Config object containing domains, selectors and listeners. 
		*/
		listen?( to?:any ): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] A template method like init but called after the viewport is created  
		* @param application Ext.app.Application 
		*/
		onLaunch?( application?:Ext.app.IApplication ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.app.domain {
	export interface IComponent extends Ext.app.IEventDomain {
	}
	export class Component {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] This method matches the firer of the event the target to the given selector  
		* @param target Object 
		* @param selector Object 
		* @returns Boolean true if the target matches the selector. 
		*/
		static match( target?:any, selector?:any ): boolean;
		/** [Method] This method is called by the derived class to monitor fireEvent calls  
		* @param observable Ext.Class The Observable to monitor for events. 
		*/
		static monitor( observable?:Ext.IClass ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.app.domain {
	export interface IController extends Ext.app.IEventDomain {
	}
	export class Controller {
		/** [Config Option] (String) */
		static idProperty: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] This method matches the firer of the event the target to the given selector  
		* @param target Object The firer of the event. 
		* @param selector String The selector to which to match the target. 
		* @returns Boolean true if the target matches the selector. 
		*/
		static match( target?:any, selector?:string ): boolean;
		/** [Method] This method is called by the derived class to monitor fireEvent calls  
		* @param observable Ext.Class The Observable to monitor for events. 
		*/
		static monitor( observable?:Ext.IClass ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.app.domain {
	export interface IDirect extends Ext.app.IEventDomain {
	}
	export class Direct {
		/** [Config Option] (String) */
		static idProperty: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] This method matches the firer of the event the target to the given selector  
		* @param target Object The firer of the event. 
		* @param selector String The selector to which to match the target. 
		* @returns Boolean true if the target matches the selector. 
		*/
		static match( target?:any, selector?:string ): boolean;
		/** [Method] This method is called by the derived class to monitor fireEvent calls  
		* @param observable Ext.Class The Observable to monitor for events. 
		*/
		static monitor( observable?:Ext.IClass ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.app.domain {
	export interface IGlobal extends Ext.app.IEventDomain {
	}
	export class Global {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] This method matches the firer of the event the target to the given selector  
		* @returns Boolean true if the target matches the selector. 
		*/
		static match(): boolean;
		/** [Method] This method is called by the derived class to monitor fireEvent calls  
		* @param observable Ext.Class The Observable to monitor for events. 
		*/
		static monitor( observable?:Ext.IClass ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.app.domain {
	export interface IStore extends Ext.app.IEventDomain {
	}
	export class Store {
		/** [Config Option] (String) */
		static idProperty: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] This method matches the firer of the event the target to the given selector  
		* @param target Object The firer of the event. 
		* @param selector String The selector to which to match the target. 
		* @returns Boolean true if the target matches the selector. 
		*/
		static match( target?:any, selector?:string ): boolean;
		/** [Method] This method is called by the derived class to monitor fireEvent calls  
		* @param observable Ext.Class The Observable to monitor for events. 
		*/
		static monitor( observable?:Ext.IClass ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.app {
	export interface IEventBus extends Ext.IBase {
	}
	export class EventBus {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Adds a set of component event listeners for a controller  
		* @param selectors Object Config object containing selectors and listeners. 
		* @param controller Ext.app.Controller The listening controller instance. 
		*/
		static control( selectors?:any, controller?:Ext.app.IController ): void;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Adds a set of event domain listeners for a controller  
		* @param to Object Config object containing domains, selectors and listeners. 
		* @param controller Ext.app.Controller The listening controller instance. 
		*/
		static listen( to?:any, controller?:Ext.app.IController ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Removes all of a controller s attached listeners  
		* @param controllerId String The id of the controller. 
		*/
		static unlisten( controllerId?:string ): void;
	}
}
declare module Ext.app {
	export interface IEventDomain extends Ext.IBase {
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Property] (Object) */
		instances?: any;
		/** [Method] This method matches the firer of the event the target to the given selector  
		* @param target Object The firer of the event. 
		* @param selector String The selector to which to match the target. 
		* @returns Boolean true if the target matches the selector. 
		*/
		match?( target?:any, selector?:string ): boolean;
		/** [Method] This method is called by the derived class to monitor fireEvent calls  
		* @param observable Ext.Class The Observable to monitor for events. 
		*/
		monitor?( observable?:Ext.IClass ): void;
	}
}
declare module Ext {
	export interface IArray {
	}
	export class Array {
		/** [Method] Filter through an array and remove empty item as defined in Ext isEmpty See filter 
		* @param array Array 
		* @returns Array results 
		*/
		static clean( array?:any[] ): any[];
		/** [Method] Clone a flat array without referencing the previous one  
		* @param array Array The array 
		* @returns Array The clone array 
		*/
		static clone( array?:any[] ): any[];
		/** [Method] Checks whether or not the given array contains the specified item 
		* @param array Array The array to check 
		* @param item Object The item to look for 
		* @returns Boolean True if the array contains the item, false otherwise 
		*/
		static contains( array?:any[], item?:any ): boolean;
		/** [Method] Perform a set difference A B by subtracting all items in array B from array A  
		* @param arrayA Array 
		* @param arrayB Array 
		* @returns Array difference 
		*/
		static difference( arrayA?:any[], arrayB?:any[] ): any[];
		/** [Method] Iterates an array or an iterable value and invoke the given callback function for each item  
		* @param iterable Array/NodeList/Object The value to be iterated. If this argument is not iterable, the callback function is called once. 
		* @param fn Function The callback function. If it returns false, the iteration stops and this method returns the current index. 
		* @param scope Object The scope (this reference) in which the specified function is executed. 
		* @param reverse Boolean Reverse the iteration order (loop from the end to the beginning) Defaults false 
		* @returns Boolean See description for the fn parameter. 
		*/
		static each( iterable?:any, fn?:any, scope?:any, reverse?:boolean ): boolean;
		/** [Method] Shallow compares the contents of 2 arrays using strict equality  
		* @param array1 Array 
		* @param array2 Array 
		* @returns Boolean true if the arrays are equal. 
		*/
		static equals( array1?:any[], array2?:any[] ): boolean;
		/** [Method] Removes items from an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param removeCount Number The number of items to remove at index. 
		* @returns Array The array passed. 
		*/
		static erase( array?:any[], index?:number, removeCount?:number ): any[];
		/** [Method] Executes the specified function for each array element until the function returns a falsy value  
		* @param array Array 
		* @param fn Function Callback function for each item 
		* @param scope Object Callback function scope 
		* @returns Boolean True if no false value is returned by the callback function. 
		*/
		static every( array?:any[], fn?:any, scope?:any ): boolean;
		/** [Method] Creates a new array with all of the elements of this array for which the provided filtering function returns true  
		* @param array Array 
		* @param fn Function Callback function for each item 
		* @param scope Object Callback function scope 
		* @returns Array results 
		*/
		static filter( array?:any[], fn?:any, scope?:any ): any[];
		/** [Method] Returns the first item in the array which elicits a true return value from the passed selection function  
		* @param array Array The array to search 
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the array 
		* @returns Object The first item in the array which returned true from the selection function, or null if none was found. 
		*/
		static findBy( array?:any[], fn?:any, scope?:any ): any;
		/** [Method] Recursively flattens into 1 d Array  
		* @param array Array The array to flatten 
		* @returns Array The 1-d array. 
		*/
		static flatten( array?:any[] ): any[];
		/** [Method] Iterates an array and invoke the given callback function for each item  
		* @param array Array The array to iterate 
		* @param fn Function The callback function. 
		* @param scope Object The execution scope (this) in which the specified function is executed. 
		*/
		static forEach( array?:any[], fn?:any, scope?:any ): void;
		/** [Method] Converts a value to an array if it s not already an array returns An empty array if given value is undefined or n  
		* @param value Object The value to convert to an array if it's not already is an array 
		* @param newReference Boolean True to clone the given array and return a new reference if necessary, defaults to false 
		* @returns Array array 
		*/
		static from( value?:any, newReference?:boolean ): any[];
		/** [Method] Push an item into the array only if the array doesn t contain it yet 
		* @param array Array The array 
		* @param item Object The item to include 
		*/
		static include( array?:any[], item?:any ): void;
		/** [Method] Get the index of the provided item in the given array a supplement for the missing arrayPrototype indexOf in Interne  
		* @param array Array The array to check 
		* @param item Object The item to look for 
		* @param from Number The index at which to begin the search 
		* @returns Number The index of item in the array (or -1 if it is not found) 
		*/
		static indexOf( array?:any[], item?:any, from?:number ): number;
		/** [Method] Inserts items in to an array  
		* @param array Array The Array in which to insert. 
		* @param index Number The index in the array at which to operate. 
		* @param items Array The array of items to insert at index. 
		* @returns Array The array passed. 
		*/
		static insert( array?:any[], index?:number, items?:any[] ): any[];
		/** [Method] Merge multiple arrays into one with unique items that exist in all of the arrays  
		* @param array1 Array 
		* @param array2 Array 
		* @param etc Array 
		* @returns Array intersect 
		*/
		static intersect( array1?:any[], array2?:any[], etc?:any[] ): any[];
		/** [Method] Creates a new array with the results of calling a provided function on every element in this array  
		* @param array Array 
		* @param fn Function Callback function for each item 
		* @param scope Object Callback function scope 
		* @returns Array results 
		*/
		static map( array?:any[], fn?:any, scope?:any ): any[];
		/** [Method] Returns the maximum value in the Array  
		* @param array Array/NodeList The Array from which to select the maximum value. 
		* @param comparisonFn Function a function to perform the comparision which determines maximization. If omitted the ">" operator will be used. Note: gt = 1; eq = 0; lt = -1 
		* @returns Object maxValue The maximum value 
		*/
		static max( array?:any, comparisonFn?:any ): any;
		/** [Method] Calculates the mean of all items in the array  
		* @param array Array The Array to calculate the mean value of. 
		* @returns Number The mean. 
		*/
		static mean( array?:any[] ): number;
		/** [Method] Merge multiple arrays into one with unique items  
		* @param array1 Array 
		* @param array2 Array 
		* @param etc Array 
		* @returns Array merged 
		*/
		static merge( array1?:any[], array2?:any[], etc?:any[] ): any[];
		/** [Method] Returns the minimum value in the Array  
		* @param array Array/NodeList The Array from which to select the minimum value. 
		* @param comparisonFn Function a function to perform the comparision which determines minimization. If omitted the "&lt;" operator will be used. Note: gt = 1; eq = 0; lt = -1 
		* @returns Object minValue The minimum value 
		*/
		static min( array?:any, comparisonFn?:any ): any;
		/** [Method] Plucks the value of a property from each item in the Array  
		* @param array Array/NodeList The Array of items to pluck the value from. 
		* @param propertyName String The property name to pluck from each element. 
		* @returns Array The value from each item in the Array. 
		*/
		static pluck( array?:any, propertyName?:string ): any[];
		/** [Method] Pushes new items onto the end of an Array  
		* @param target Array The Array onto which to push new items 
		* @param elements Object... The elements to add to the array. Each parameter may be an Array, in which case all the elements of that Array will be pushed into the end of the destination Array. 
		* @returns Array An array containing all the new items push onto the end. 
		*/
		static push( target:any[], ...elements:any[] ): any[];
		/** [Method] Removes the specified item from the array if it exists 
		* @param array Array The array 
		* @param item Object The item to remove 
		* @returns Array The passed array itself 
		*/
		static remove( array?:any[], item?:any ): any[];
		/** [Method] Replaces items in an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param removeCount Number The number of items to remove at index (can be 0). 
		* @param insert Array An array of items to insert at index. 
		* @returns Array The array passed. 
		*/
		static replace( array?:any[], index?:number, removeCount?:number, insert?:any[] ): any[];
		/** [Method] Returns a shallow copy of a part of an array  
		* @param array Array The array (or arguments object). 
		* @param begin Number The index at which to begin. Negative values are offsets from the end of the array. 
		* @param end Number The index at which to end. The copied items do not include end. Negative values are offsets from the end of the array. If end is omitted, all items up to the end of the array are copied. 
		* @returns Array The copied piece of the array. 
		*/
		static slice( array?:any[], begin?:number, end?:number ): any[];
		/** [Method] Executes the specified function for each array element until the function returns a truthy value  
		* @param array Array 
		* @param fn Function Callback function for each item 
		* @param scope Object Callback function scope 
		* @returns Boolean True if the callback function returns a truthy value. 
		*/
		static some( array?:any[], fn?:any, scope?:any ): boolean;
		/** [Method] Sorts the elements of an Array  
		* @param array Array The array to sort. 
		* @param sortFn Function The comparison function. 
		* @returns Array The sorted array. 
		*/
		static sort( array?:any[], sortFn?:any ): any[];
		/** [Method] Replaces items in an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param removeCount Number The number of items to remove at index (can be 0). 
		* @param elements Object... The elements to add to the array. If you don't specify any elements, splice simply removes elements from the array. 
		* @returns Array An array containing the removed items. 
		*/
		static splice( array:any[], index:number, removeCount:number, ...elements:any[] ): any[];
		/** [Method] Calculates the sum of all items in the given array  
		* @param array Array The Array to calculate the sum value of. 
		* @returns Number The sum. 
		*/
		static sum( array?:any[] ): number;
		/** [Method] Converts any iterable numeric indices and a length property into a true array  
		* @param iterable Object the iterable object to be turned into a true Array. 
		* @param start Number a zero-based index that specifies the start of extraction. Defaults to 0 
		* @param end Number a 1-based index that specifies the end of extraction. Defaults to the last index of the iterable value 
		* @returns Array array 
		*/
		static toArray( iterable?:any, start?:number, end?:number ): any[];
		/** [Method] Creates a map object keyed by the elements of the given array  
		* @param array Array The Array to create the map from. 
		* @param getKey String/Function Name of the object property to use as a key or a function to extract the key. 
		* @param scope Object Value of this inside callback. 
		* @returns Object The resulting map. 
		*/
		static toMap( array?:any[], getKey?:any, scope?:any ): any;
		/** [Method] Creates a map object keyed by a property of elements of the given array  
		* @param array Array The Array to create the map from. 
		* @param getKey String/Function Name of the object property to use as a key or a function to extract the key. 
		* @param scope Object Value of this inside callback. 
		* @returns Object The resulting map. 
		*/
		static toValueMap( array?:any[], getKey?:any, scope?:any ): any;
		/** [Method] Merge multiple arrays into one with unique items  
		* @param array1 Array 
		* @param array2 Array 
		* @param etc Array 
		* @returns Array merged 
		*/
		static union( array1?:any[], array2?:any[], etc?:any[] ): any[];
		/** [Method] Returns a new array with unique items 
		* @param array Array 
		* @returns Array results 
		*/
		static unique( array?:any[] ): any[];
	}
}
declare module Ext {
	export interface IBase extends Ext.IClass {
		/** [Property] (Ext.Class) */
		self?: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		callOverridden?( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		callParent?( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		callSuper?( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		getInitialConfig?( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		initConfig?( config?:any ): Ext.IBase;
	}
	export class Base {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.button {
	export interface IButton extends Ext.IComponent,Ext.IQueryable {
		/** [Config Option] (Boolean) */
		allowDepress?: boolean;
		/** [Config Option] (String) */
		arrowAlign?: string;
		/** [Config Option] (String) */
		arrowCls?: string;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Object) */
		baseParams?: any;
		/** [Config Option] (String) */
		clickEvent?: string;
		/** [Config Option] (String) */
		cls?: string;
		/** [Config Option] (String/Object) */
		componentLayout?: any;
		/** [Config Option] (Boolean) */
		destroyMenu?: boolean;
		/** [Config Option] (Boolean) */
		disabled?: boolean;
		/** [Config Option] (Boolean) */
		enableToggle?: boolean;
		/** [Config Option] (String) */
		focusCls?: string;
		/** [Config Option] (Boolean) */
		frame?: boolean;
		/** [Config Option] (Number/String) */
		glyph?: any;
		/** [Config Option] (Boolean) */
		handleMouseEvents?: boolean;
		/** [Config Option] (Function) */
		handler?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (String) */
		href?: string;
		/** [Config Option] (String) */
		hrefTarget?: string;
		/** [Config Option] (String) */
		icon?: string;
		/** [Config Option] (String) */
		iconAlign?: string;
		/** [Config Option] (String) */
		iconCls?: string;
		/** [Config Option] (Ext.menu.Menu/String/Object) */
		menu?: any;
		/** [Config Option] (String) */
		menuActiveCls?: string;
		/** [Config Option] (String) */
		menuAlign?: string;
		/** [Config Option] (Number) */
		minWidth?: number;
		/** [Config Option] (String) */
		overCls?: string;
		/** [Config Option] (String) */
		overflowText?: string;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (Boolean) */
		pressed?: boolean;
		/** [Config Option] (String) */
		pressedCls?: string;
		/** [Config Option] (Boolean) */
		preventDefault?: boolean;
		/** [Config Option] (Ext.XTemplate/String/String[]) */
		renderTpl?: any;
		/** [Config Option] (Boolean/Object) */
		repeat?: any;
		/** [Config Option] ("small"/"medium"/"large") */
		scale?: any;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (Boolean) */
		showEmptyMenu?: boolean;
		/** [Config Option] (Boolean/Number) */
		shrinkWrap?: any;
		/** [Config Option] (Number) */
		tabIndex?: number;
		/** [Config Option] (String) */
		text?: string;
		/** [Config Option] (String) */
		textAlign?: string;
		/** [Config Option] (String) */
		toggleGroup?: string;
		/** [Config Option] (Function) */
		toggleHandler?: any;
		/** [Config Option] (String/Object) */
		tooltip?: any;
		/** [Config Option] (String) */
		tooltipType?: string;
		/** [Property] (Boolean) */
		isAction?: boolean;
		/** [Property] (Ext.Template) */
		template?: Ext.ITemplate;
		/** [Method] Retrieves the first direct child of this container which matches the passed selector or component  
		* @param selector String/Ext.Component An Ext.ComponentQuery selector. If no selector is specified, the first child will be returned. 
		* @returns Object Ext.Component The matching child Ext.Component (or null if no match was found). 
		*/
		child?( selector?:any ): any;
		/** [Method] inherit docs 
		* @param silent Object 
		*/
		disable?( silent?:any ): void;
		/** [Method] Retrieves the first descendant of this container which matches the passed selector  
		* @param selector String/Ext.Component An Ext.ComponentQuery selector or Ext.Component. If no selector is specified, the first child will be returned. 
		* @returns Object Ext.Component The matching descendant Ext.Component (or null if no match was found). 
		*/
		down?( selector?:any ): any;
		/** [Method] inherit docs 
		* @param silent Object 
		*/
		enable?( silent?:any ): void;
		/** [Method] This method returns an object which provides substitution parameters for the XTemplate used to create this Button s D  
		* @returns Object Substitution data for a Template. The default implementation which provides data for the default template returns an Object containing the following properties: 
		*/
		getTemplateArgs?(): any;
		/** [Method] Gets the text for this Button 
		* @returns String The button text 
		*/
		getText?(): string;
		/** [Method] Returns true if the button has a menu and it is visible 
		* @returns Boolean 
		*/
		hasVisibleMenu?(): boolean;
		/** [Method] Hides this button s menu if it has one  
		* @returns Ext.button.Button this 
		*/
		hideMenu?(): Ext.button.IButton;
		/** [Method] inherit docs */
		initComponent?(): void;
		/** [Method] See comments in onFocus */
		onDisable?(): void;
		/** [Method] Retrieves all descendant components which match the passed selector  
		* @param selector String Selector complying to an Ext.ComponentQuery selector. If no selector is specified all items will be returned. 
		* @returns Ext.Component[] Components which matched the selector 
		*/
		query?( selector?:string ): Ext.IComponent[];
		/** [Method] Retrieves all descendant components which match the passed function  
		* @param fn Function The matcher function. It will be called with a single argument, the component being tested. 
		* @param scope Object The scope in which to run the function. If not specified, it will default to the active component. 
		* @returns Ext.Component[] Components matched by the passed function 
		*/
		queryBy?( fn?:any, scope?:any ): Ext.IComponent[];
		/** [Method] Finds a component at any level under this container matching the id itemId  
		* @param id String The id to find 
		* @returns Ext.Component The matching id, null if not found 
		*/
		queryById?( id?:string ): Ext.IComponent;
		/** [Method] Sets this button s glyph 
		* @param glyph Number/String the numeric charCode or string charCode/font-family. This parameter expects a format consistent with that of glyph 
		* @returns Ext.button.Button this 
		*/
		setGlyph?( glyph?:any ): Ext.button.IButton;
		/** [Method] Assigns this Button s click handler 
		* @param handler Function The function to call when the button is clicked 
		* @param scope Object The scope (this reference) in which the handler function is executed. Defaults to this Button. 
		* @returns Ext.button.Button this 
		*/
		setHandler?( handler?:any, scope?:any ): Ext.button.IButton;
		/** [Method] Sets the href of the embedded anchor element to the passed URL  
		* @param href String The URL to set in the anchor element. 
		*/
		setHref?( href?:string ): void;
		/** [Method] Sets the background image inline style of the button  
		* @param icon String The path to an image to display in the button 
		* @returns Ext.button.Button this 
		*/
		setIcon?( icon?:string ): Ext.button.IButton;
		/** [Method] Sets the CSS class that provides a background image to use as the button s icon  
		* @param cls String The CSS class providing the icon image 
		* @returns Ext.button.Button this 
		*/
		setIconCls?( cls?:string ): Ext.button.IButton;
		/** [Method] Sets the href of the link dynamically according to the params passed and any baseParams configured  
		* @param params Object Parameters to use in the href URL. 
		*/
		setParams?( params?:any ): void;
		/** [Method] Method to change the scale of the button  
		* @param scale String The scale to change to. 
		*/
		setScale?( scale?:string ): void;
		/** [Method] Sets this Button s text 
		* @param text String The button text 
		* @returns Ext.button.Button this 
		*/
		setText?( text?:string ): Ext.button.IButton;
		/** [Method] Sets the text alignment for this button  
		* @param align String The new alignment of the button text. See textAlign. 
		*/
		setTextAlign?( align?:string ): void;
		/** [Method] Sets the tooltip for this Button  
		* @param tooltip String/Object This may be:  String : A string to be used as innerHTML (html tags are accepted) to show in a tooltip Object : A configuration object for Ext.tip.QuickTipManager.register.  
		* @returns Ext.button.Button this 
		*/
		setTooltip?( tooltip?:any ): Ext.button.IButton;
		/** [Method] inherit docs 
		* @param ui Object 
		*/
		setUI?( ui?:any ): void;
		/** [Method] Shows this button s menu if it has one  
		* @param fromEvent Object 
		*/
		showMenu?( fromEvent?:any ): void;
		/** [Method] If a state it passed it becomes the pressed state otherwise the current state is toggled  
		* @param state Boolean Force a particular state 
		* @param suppressEvent Boolean True to stop events being fired when calling this method. 
		* @returns Ext.button.Button this 
		*/
		toggle?( state?:boolean, suppressEvent?:boolean ): Ext.button.IButton;
	}
}
declare module Ext {
	export interface IButton extends Ext.IComponent,Ext.IQueryable {
		/** [Config Option] (Boolean) */
		allowDepress?: boolean;
		/** [Config Option] (String) */
		arrowAlign?: string;
		/** [Config Option] (String) */
		arrowCls?: string;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Object) */
		baseParams?: any;
		/** [Config Option] (String) */
		clickEvent?: string;
		/** [Config Option] (String) */
		cls?: string;
		/** [Config Option] (String/Object) */
		componentLayout?: any;
		/** [Config Option] (Boolean) */
		destroyMenu?: boolean;
		/** [Config Option] (Boolean) */
		disabled?: boolean;
		/** [Config Option] (Boolean) */
		enableToggle?: boolean;
		/** [Config Option] (String) */
		focusCls?: string;
		/** [Config Option] (Boolean) */
		frame?: boolean;
		/** [Config Option] (Number/String) */
		glyph?: any;
		/** [Config Option] (Boolean) */
		handleMouseEvents?: boolean;
		/** [Config Option] (Function) */
		handler?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (String) */
		href?: string;
		/** [Config Option] (String) */
		hrefTarget?: string;
		/** [Config Option] (String) */
		icon?: string;
		/** [Config Option] (String) */
		iconAlign?: string;
		/** [Config Option] (String) */
		iconCls?: string;
		/** [Config Option] (Ext.menu.Menu/String/Object) */
		menu?: any;
		/** [Config Option] (String) */
		menuActiveCls?: string;
		/** [Config Option] (String) */
		menuAlign?: string;
		/** [Config Option] (Number) */
		minWidth?: number;
		/** [Config Option] (String) */
		overCls?: string;
		/** [Config Option] (String) */
		overflowText?: string;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (Boolean) */
		pressed?: boolean;
		/** [Config Option] (String) */
		pressedCls?: string;
		/** [Config Option] (Boolean) */
		preventDefault?: boolean;
		/** [Config Option] (Ext.XTemplate/String/String[]) */
		renderTpl?: any;
		/** [Config Option] (Boolean/Object) */
		repeat?: any;
		/** [Config Option] ("small"/"medium"/"large") */
		scale?: any;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (Boolean) */
		showEmptyMenu?: boolean;
		/** [Config Option] (Boolean/Number) */
		shrinkWrap?: any;
		/** [Config Option] (Number) */
		tabIndex?: number;
		/** [Config Option] (String) */
		text?: string;
		/** [Config Option] (String) */
		textAlign?: string;
		/** [Config Option] (String) */
		toggleGroup?: string;
		/** [Config Option] (Function) */
		toggleHandler?: any;
		/** [Config Option] (String/Object) */
		tooltip?: any;
		/** [Config Option] (String) */
		tooltipType?: string;
		/** [Property] (Boolean) */
		isAction?: boolean;
		/** [Property] (Ext.Template) */
		template?: Ext.ITemplate;
		/** [Method] Retrieves the first direct child of this container which matches the passed selector or component  
		* @param selector String/Ext.Component An Ext.ComponentQuery selector. If no selector is specified, the first child will be returned. 
		* @returns Object Ext.Component The matching child Ext.Component (or null if no match was found). 
		*/
		child?( selector?:any ): any;
		/** [Method] inherit docs 
		* @param silent Object 
		*/
		disable?( silent?:any ): void;
		/** [Method] Retrieves the first descendant of this container which matches the passed selector  
		* @param selector String/Ext.Component An Ext.ComponentQuery selector or Ext.Component. If no selector is specified, the first child will be returned. 
		* @returns Object Ext.Component The matching descendant Ext.Component (or null if no match was found). 
		*/
		down?( selector?:any ): any;
		/** [Method] inherit docs 
		* @param silent Object 
		*/
		enable?( silent?:any ): void;
		/** [Method] This method returns an object which provides substitution parameters for the XTemplate used to create this Button s D  
		* @returns Object Substitution data for a Template. The default implementation which provides data for the default template returns an Object containing the following properties: 
		*/
		getTemplateArgs?(): any;
		/** [Method] Gets the text for this Button 
		* @returns String The button text 
		*/
		getText?(): string;
		/** [Method] Returns true if the button has a menu and it is visible 
		* @returns Boolean 
		*/
		hasVisibleMenu?(): boolean;
		/** [Method] Hides this button s menu if it has one  
		* @returns Ext.button.Button this 
		*/
		hideMenu?(): Ext.button.IButton;
		/** [Method] inherit docs */
		initComponent?(): void;
		/** [Method] See comments in onFocus */
		onDisable?(): void;
		/** [Method] Retrieves all descendant components which match the passed selector  
		* @param selector String Selector complying to an Ext.ComponentQuery selector. If no selector is specified all items will be returned. 
		* @returns Ext.Component[] Components which matched the selector 
		*/
		query?( selector?:string ): Ext.IComponent[];
		/** [Method] Retrieves all descendant components which match the passed function  
		* @param fn Function The matcher function. It will be called with a single argument, the component being tested. 
		* @param scope Object The scope in which to run the function. If not specified, it will default to the active component. 
		* @returns Ext.Component[] Components matched by the passed function 
		*/
		queryBy?( fn?:any, scope?:any ): Ext.IComponent[];
		/** [Method] Finds a component at any level under this container matching the id itemId  
		* @param id String The id to find 
		* @returns Ext.Component The matching id, null if not found 
		*/
		queryById?( id?:string ): Ext.IComponent;
		/** [Method] Sets this button s glyph 
		* @param glyph Number/String the numeric charCode or string charCode/font-family. This parameter expects a format consistent with that of glyph 
		* @returns Ext.button.Button this 
		*/
		setGlyph?( glyph?:any ): Ext.button.IButton;
		/** [Method] Assigns this Button s click handler 
		* @param handler Function The function to call when the button is clicked 
		* @param scope Object The scope (this reference) in which the handler function is executed. Defaults to this Button. 
		* @returns Ext.button.Button this 
		*/
		setHandler?( handler?:any, scope?:any ): Ext.button.IButton;
		/** [Method] Sets the href of the embedded anchor element to the passed URL  
		* @param href String The URL to set in the anchor element. 
		*/
		setHref?( href?:string ): void;
		/** [Method] Sets the background image inline style of the button  
		* @param icon String The path to an image to display in the button 
		* @returns Ext.button.Button this 
		*/
		setIcon?( icon?:string ): Ext.button.IButton;
		/** [Method] Sets the CSS class that provides a background image to use as the button s icon  
		* @param cls String The CSS class providing the icon image 
		* @returns Ext.button.Button this 
		*/
		setIconCls?( cls?:string ): Ext.button.IButton;
		/** [Method] Sets the href of the link dynamically according to the params passed and any baseParams configured  
		* @param params Object Parameters to use in the href URL. 
		*/
		setParams?( params?:any ): void;
		/** [Method] Method to change the scale of the button  
		* @param scale String The scale to change to. 
		*/
		setScale?( scale?:string ): void;
		/** [Method] Sets this Button s text 
		* @param text String The button text 
		* @returns Ext.button.Button this 
		*/
		setText?( text?:string ): Ext.button.IButton;
		/** [Method] Sets the text alignment for this button  
		* @param align String The new alignment of the button text. See textAlign. 
		*/
		setTextAlign?( align?:string ): void;
		/** [Method] Sets the tooltip for this Button  
		* @param tooltip String/Object This may be:  String : A string to be used as innerHTML (html tags are accepted) to show in a tooltip Object : A configuration object for Ext.tip.QuickTipManager.register.  
		* @returns Ext.button.Button this 
		*/
		setTooltip?( tooltip?:any ): Ext.button.IButton;
		/** [Method] inherit docs 
		* @param ui Object 
		*/
		setUI?( ui?:any ): void;
		/** [Method] Shows this button s menu if it has one  
		* @param fromEvent Object 
		*/
		showMenu?( fromEvent?:any ): void;
		/** [Method] If a state it passed it becomes the pressed state otherwise the current state is toggled  
		* @param state Boolean Force a particular state 
		* @param suppressEvent Boolean True to stop events being fired when calling this method. 
		* @returns Ext.button.Button this 
		*/
		toggle?( state?:boolean, suppressEvent?:boolean ): Ext.button.IButton;
	}
}
declare module Ext.button {
	export interface ICycle extends Ext.button.ISplit {
		/** [Config Option] (Function) */
		changeHandler?: any;
		/** [Config Option] (Number/String) */
		forceGlyph?: any;
		/** [Config Option] (String) */
		forceIcon?: string;
		/** [Config Option] (Object[]) */
		items?: any[];
		/** [Config Option] (String) */
		prependText?: string;
		/** [Config Option] (Boolean) */
		showText?: boolean;
		/** [Property] (Ext.menu.Menu) */
		menu?: Ext.menu.IMenu;
		/** [Method] Gets the currently active menu item  
		* @returns Ext.menu.CheckItem The active item 
		*/
		getActiveItem?(): Ext.menu.ICheckItem;
		/** [Method] Sets the button s active menu item  
		* @param item Ext.menu.CheckItem The item to activate 
		* @param suppressEvent Boolean True to prevent the button's change event from firing. 
		*/
		setActiveItem?( item?:Ext.menu.ICheckItem, suppressEvent?:boolean ): void;
		/** [Method] This is normally called internally on button click but can be called externally to advance the button s active item */
		toggleSelected?(): void;
	}
}
declare module Ext {
	export interface ICycleButton extends Ext.button.ISplit {
		/** [Config Option] (Function) */
		changeHandler?: any;
		/** [Config Option] (Number/String) */
		forceGlyph?: any;
		/** [Config Option] (String) */
		forceIcon?: string;
		/** [Config Option] (Object[]) */
		items?: any[];
		/** [Config Option] (String) */
		prependText?: string;
		/** [Config Option] (Boolean) */
		showText?: boolean;
		/** [Property] (Ext.menu.Menu) */
		menu?: Ext.menu.IMenu;
		/** [Method] Gets the currently active menu item  
		* @returns Ext.menu.CheckItem The active item 
		*/
		getActiveItem?(): Ext.menu.ICheckItem;
		/** [Method] Sets the button s active menu item  
		* @param item Ext.menu.CheckItem The item to activate 
		* @param suppressEvent Boolean True to prevent the button's change event from firing. 
		*/
		setActiveItem?( item?:Ext.menu.ICheckItem, suppressEvent?:boolean ): void;
		/** [Method] This is normally called internally on button click but can be called externally to advance the button s active item */
		toggleSelected?(): void;
	}
}
declare module Ext.button {
	export interface IManager extends Ext.IBase {
	}
	export class Manager {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext {
	export interface IButtonToggleManager extends Ext.IBase {
	}
	export class ButtonToggleManager {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.button {
	export interface ISplit extends Ext.button.IButton {
		/** [Config Option] (Function) */
		arrowHandler?: any;
		/** [Config Option] (String) */
		arrowTooltip?: string;
		/** [Method] Sets this button s arrow click handler  
		* @param handler Function The function to call when the arrow is clicked. 
		* @param scope Object Scope for the function passed above. 
		*/
		setArrowHandler?( handler?:any, scope?:any ): void;
	}
}
declare module Ext {
	export interface ISplitButton extends Ext.button.IButton {
		/** [Config Option] (Function) */
		arrowHandler?: any;
		/** [Config Option] (String) */
		arrowTooltip?: string;
		/** [Method] Sets this button s arrow click handler  
		* @param handler Function The function to call when the arrow is clicked. 
		* @param scope Object Scope for the function passed above. 
		*/
		setArrowHandler?( handler?:any, scope?:any ): void;
	}
}
declare module Ext.chart.axis {
	export interface IAbstract extends Ext.IBase {
		/** [Config Option] (String[]) */
		fields?: string[];
		/** [Config Option] (Ext.chart.Label) */
		label?: Ext.chart.ILabel;
	}
}
declare module Ext.chart.axis {
	export interface IAxis extends Ext.chart.axis.IAbstract {
		/** [Config Option] (Boolean) */
		adjustEnd?: boolean;
		/** [Config Option] (Number) */
		dashSize?: number;
		/** [Config Option] (Boolean/Object) */
		grid?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (Number) */
		length?: number;
		/** [Config Option] (Number) */
		majorTickSteps?: number;
		/** [Config Option] (Number) */
		minorTickSteps?: number;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (String) */
		title?: string;
		/** [Config Option] (Number) */
		width?: number;
		/** [Method] Renders the axis into the screen and updates its position  
		* @param init Object 
		*/
		drawAxis?( init?:any ): void;
		/** [Method] Renders an horizontal and or vertical grid into the Surface  */
		drawGrid?(): void;
		/** [Method] Renders the labels in the axes  */
		drawLabel?(): void;
		/** [Method] Updates the title of this axis  
		* @param title String 
		*/
		setTitle?( title?:string ): void;
	}
}
declare module Ext.chart {
	export interface IAxis extends Ext.chart.axis.IAbstract {
		/** [Config Option] (Boolean) */
		adjustEnd?: boolean;
		/** [Config Option] (Number) */
		dashSize?: number;
		/** [Config Option] (Boolean/Object) */
		grid?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (Number) */
		length?: number;
		/** [Config Option] (Number) */
		majorTickSteps?: number;
		/** [Config Option] (Number) */
		minorTickSteps?: number;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (String) */
		title?: string;
		/** [Config Option] (Number) */
		width?: number;
		/** [Method] Renders the axis into the screen and updates its position  
		* @param init Object 
		*/
		drawAxis?( init?:any ): void;
		/** [Method] Renders an horizontal and or vertical grid into the Surface  */
		drawGrid?(): void;
		/** [Method] Renders the labels in the axes  */
		drawLabel?(): void;
		/** [Method] Updates the title of this axis  
		* @param title String 
		*/
		setTitle?( title?:string ): void;
	}
}
declare module Ext.chart.axis {
	export interface ICategory extends Ext.chart.axis.IAxis {
		/** [Config Option] (Boolean) */
		calculateCategoryCount?: boolean;
		/** [Config Option] (String) */
		categoryNames?: string;
	}
}
declare module Ext.chart {
	export interface ICategoryAxis extends Ext.chart.axis.IAxis {
		/** [Config Option] (Boolean) */
		calculateCategoryCount?: boolean;
		/** [Config Option] (String) */
		categoryNames?: string;
	}
}
declare module Ext.chart.axis {
	export interface IGauge extends Ext.chart.axis.IAbstract {
		/** [Config Option] (Number) */
		margin?: number;
		/** [Config Option] (Number) */
		maximum?: number;
		/** [Config Option] (Number) */
		minimum?: number;
		/** [Config Option] (Number) */
		steps?: number;
		/** [Config Option] (String) */
		title?: string;
		/** [Method] Updates the title of this axis  
		* @param title String 
		*/
		setTitle?( title?:string ): void;
	}
}
declare module Ext.chart.axis {
	export interface INumeric extends Ext.chart.axis.IAxis {
		/** [Config Option] (Boolean) */
		adjustMaximumByMajorUnit?: boolean;
		/** [Config Option] (Boolean) */
		adjustMinimumByMajorUnit?: boolean;
		/** [Config Option] (Boolean) */
		constrain?: boolean;
		/** [Config Option] (Number) */
		decimals?: number;
		/** [Config Option] (Number) */
		maximum?: number;
		/** [Config Option] (Number) */
		minimum?: number;
		/** [Config Option] (String) */
		position?: string;
	}
}
declare module Ext.chart {
	export interface INumericAxis extends Ext.chart.axis.IAxis {
		/** [Config Option] (Boolean) */
		adjustMaximumByMajorUnit?: boolean;
		/** [Config Option] (Boolean) */
		adjustMinimumByMajorUnit?: boolean;
		/** [Config Option] (Boolean) */
		constrain?: boolean;
		/** [Config Option] (Number) */
		decimals?: number;
		/** [Config Option] (Number) */
		maximum?: number;
		/** [Config Option] (Number) */
		minimum?: number;
		/** [Config Option] (String) */
		position?: string;
	}
}
declare module Ext.chart.axis {
	export interface IRadial extends Ext.chart.axis.INumeric {
		/** [Config Option] (Number) */
		maximum?: number;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (Number) */
		steps?: number;
		/** [Method] Renders the labels in the axes  */
		drawLabel?(): void;
	}
}
declare module Ext.chart.axis {
	export interface ITime extends Ext.chart.axis.INumeric {
		/** [Config Option] (Boolean) */
		constrain?: boolean;
		/** [Config Option] (String/Boolean) */
		dateFormat?: any;
		/** [Config Option] (Date) */
		fromDate?: any;
		/** [Config Option] (Array) */
		step?: any[];
		/** [Config Option] (Date) */
		toDate?: any;
	}
}
declare module Ext.chart {
	export interface ITimeAxis extends Ext.chart.axis.INumeric {
		/** [Config Option] (Boolean) */
		constrain?: boolean;
		/** [Config Option] (String/Boolean) */
		dateFormat?: any;
		/** [Config Option] (Date) */
		fromDate?: any;
		/** [Config Option] (Array) */
		step?: any[];
		/** [Config Option] (Date) */
		toDate?: any;
	}
}
declare module Ext.chart {
	export interface ICallout extends Ext.IBase {
	}
}
declare module Ext.chart {
	export interface IChart extends Ext.draw.IComponent,Ext.chart.theme.ITheme,Ext.chart.IMask,Ext.chart.INavigation,Ext.util.IBindable,Ext.util.IObservable {
		/** [Config Option] (Boolean/Object) */
		animate?: any;
		/** [Config Option] (Ext.chart.axis.Axis[]) */
		axes?: Ext.chart.axis.IAxis[];
		/** [Config Option] (Object/Boolean) */
		background?: any;
		/** [Config Option] (Object[]) */
		gradients?: any[];
		/** [Config Option] (Number) */
		insetPadding?: number;
		/** [Config Option] (Boolean/Object) */
		legend?: any;
		/** [Config Option] (Ext.chart.series.Series[]) */
		series?: Ext.chart.series.ISeries[];
		/** [Config Option] (Ext.data.Store) */
		store?: Ext.data.IStore;
		/** [Config Option] (String) */
		theme?: string;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Binds a store to this instance  
		* @param store Object 
		* @param initial Object 
		*/
		bindStore?( store?:any, initial?:any ): void;
		/** [Method] Binds listeners for this component to the store  
		* @param store Ext.data.AbstractStore The store to bind to 
		*/
		bindStoreListeners?( store?:Ext.data.IAbstractStore ): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Gets the current store instance  
		* @returns Ext.data.AbstractStore The store, null if one does not exist. 
		*/
		getStore?(): Ext.data.IAbstractStore;
		/** [Method] Gets the listeners to bind to a new store  
		* @returns Object The listeners to be bound to the store in object literal form. The scope may be omitted, it is assumed to be the current instance. 
		*/
		getStoreListeners?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] The initComponent template method is an important initialization step for a Component  */
		initComponent?(): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Template method it is called when a new store is bound to the current instance  
		* @param store Ext.data.AbstractStore The store being bound 
		* @param initial Boolean True if this store is being bound as initialization of the instance. 
		*/
		onBindStore?( store?:Ext.data.IAbstractStore, initial?:boolean ): void;
		/** [Method] Allows addition of behavior to the show operation  */
		onShow?(): void;
		/** [Method] Template method it is called when an existing store is unbound from the current instance  
		* @param store Ext.data.AbstractStore The store being unbound 
		* @param initial Boolean True if this store is being bound as initialization of the instance. 
		*/
		onUnbindStore?( store?:Ext.data.IAbstractStore, initial?:boolean ): void;
		/** [Method] Redraws the chart  
		* @param resize Boolean flag which changes the default origin points of the chart for animations. 
		*/
		redraw?( resize?:boolean ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Restores the zoom to the original value  */
		restoreZoom?(): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Saves the chart by either triggering a download or returning a string containing the chart data as SVG  
		* @param config Object The configuration to be passed to the exporter. See the export method for the appropriate exporter for the relevant configuration options 
		* @returns Object See the return types for the appropriate exporter 
		*/
		save?( config?:any ): any;
		/** [Method] Zooms the chart to the specified selection range  
		* @param zoomConfig Object 
		*/
		setZoom?( zoomConfig?:any ): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Unbinds listeners from this component to the store  
		* @param store Ext.data.AbstractStore The store to unbind from 
		*/
		unbindStoreListeners?( store?:Ext.data.IAbstractStore ): void;
	}
}
declare module Ext.chart {
	export interface IHighlight extends Ext.IBase {
		/** [Config Option] (Boolean/Object) */
		highlight?: any;
		/** [Property] (Object) */
		highlightCfg?: any;
		/** [Method] Highlight the given series item  
		* @param item Object Info about the item; same format as returned by #getItemForPoint. 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlight any existing highlights */
		unHighlightItem?(): void;
	}
}
declare module Ext.chart {
	export interface ILabel extends Ext.IBase {
		/** [Config Option] (Object) */
		label?: any;
		/** [Method] Called each time a new label is created  
		* @param storeItem Ext.data.Model The element of the store that is related to the sprite. 
		* @param item Object The item related to the sprite. An item is an object containing the position of the shape used to describe the visualization and also pointing to the actual shape (circle, rectangle, path, etc). 
		* @param i Number The index of the element created (i.e the first created label, second created label, etc). 
		* @param display String The label.display type. May be false if the label is hidden 
		* @returns Ext.draw.Sprite The created sprite that will draw the label. 
		*/
		onCreateLabel?( storeItem?:Ext.data.IModel, item?:any, i?:number, display?:string ): Ext.draw.ISprite;
		/** [Method] Called for updating the position of the label  
		* @param label Ext.draw.Sprite The sprite that draws the label. 
		* @param storeItem Ext.data.Model The element of the store that is related to the sprite. 
		* @param item Object The item related to the sprite. An item is an object containing the position of the shape used to describe the visualization and also pointing to the actual shape (circle, rectangle, path, etc). 
		* @param i Number The index of the element to be updated (i.e. whether it is the first, second, third from the labelGroup) 
		* @param display String The label.display type. May be false if the label is hidden 
		* @param animate Boolean A boolean value to set or unset animations for the labels. 
		* @param index Number The series index. 
		*/
		onPlaceLabel?( label?:Ext.draw.ISprite, storeItem?:Ext.data.IModel, item?:any, i?:number, display?:string, animate?:boolean, index?:number ): void;
	}
}
declare module Ext.chart {
	export interface ILegend extends Ext.IBase {
		/** [Config Option] (String) */
		boxFill?: string;
		/** [Config Option] (String) */
		boxStroke?: string;
		/** [Config Option] (String) */
		boxStrokeWidth?: string;
		/** [Config Option] (Number) */
		boxZIndex?: number;
		/** [Config Option] (Number) */
		itemSpacing?: number;
		/** [Config Option] (String) */
		labelColor?: string;
		/** [Config Option] (String) */
		labelFont?: string;
		/** [Config Option] (Number) */
		padding?: number;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (Boolean) */
		update?: boolean;
		/** [Config Option] (Boolean) */
		visible?: boolean;
		/** [Config Option] (Number) */
		x?: number;
		/** [Config Option] (Number) */
		y?: number;
		/** [Property] (Boolean) */
		isVertical?: boolean;
		/** [Method] toggle 
		* @param show Boolean Whether to show or hide the legend. 
		*/
		toggle?( show?:boolean ): void;
	}
}
declare module Ext.chart {
	export interface ILegendItem extends Ext.draw.ICompositeSprite {
		/** [Method] Creates all the individual sprites for this legend item 
		* @param config Object 
		*/
		createLegend?( config?:any ): void;
		/** [Method] Update the positions of all this item s sprites to match the root position of the legend box  
		* @param relativeTo Object If specified, this object's 'x' and 'y' values will be used as the reference point for the relative positioning. Defaults to the Legend. 
		*/
		updatePosition?( relativeTo?:any ): void;
	}
}
declare module Ext.chart {
	export interface IMask extends Ext.IBase {
		/** [Config Option] (Boolean/String) */
		mask?: any;
	}
}
declare module Ext.chart {
	export interface IMaskLayer extends Ext.IComponent {
		/** [Method] The initComponent template method is an important initialization step for a Component  */
		initComponent?(): void;
	}
}
declare module Ext.chart {
	export interface INavigation extends Ext.IBase {
		/** [Method] Restores the zoom to the original value  */
		restoreZoom?(): void;
		/** [Method] Zooms the chart to the specified selection range  
		* @param zoomConfig Object 
		*/
		setZoom?( zoomConfig?:any ): void;
	}
}
declare module Ext.chart.series {
	export interface IArea extends Ext.chart.series.ICartesian {
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns the color of the series to be displayed as color for the series legend item 
		* @param item Object Info about the item; same format as returned by getItemForPoint 
		*/
		getLegendColor?( item?:any ): void;
		/** [Method] Highlight the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Highlight this entire series  
		* @param item Object Info about the item; same format as returned by getItemForPoint. 
		*/
		highlightSeries?( item?:any ): void;
		/** [Method] Un highlights the specified item  
		* @param item Object Info about the item; same format as returned by getItemForPoint 
		*/
		unHighlightItem?( item?:any ): void;
		/** [Method] UnHighlight this entire series  
		* @param item Object Info about the item; same format as returned by getItemForPoint. 
		*/
		unHighlightSeries?( item?:any ): void;
	}
}
declare module Ext.chart.series {
	export interface IBar extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (Number) */
		groupGutter?: number;
		/** [Config Option] (Number) */
		gutter?: number;
		/** [Config Option] (Boolean) */
		stacked?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns a string with the color to be used for the series legend item  
		* @param index Object 
		*/
		getLegendColor?( index?:any ): void;
		/** [Method] Highlight the given series item  
		* @param item Object 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlight any existing highlights */
		unHighlightItem?(): void;
	}
}
declare module Ext.chart {
	export interface IBarSeries extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (Number) */
		groupGutter?: number;
		/** [Config Option] (Number) */
		gutter?: number;
		/** [Config Option] (Boolean) */
		stacked?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns a string with the color to be used for the series legend item  
		* @param index Object 
		*/
		getLegendColor?( index?:any ): void;
		/** [Method] Highlight the given series item  
		* @param item Object 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlight any existing highlights */
		unHighlightItem?(): void;
	}
}
declare module Ext.chart {
	export interface IBarChart extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (Number) */
		groupGutter?: number;
		/** [Config Option] (Number) */
		gutter?: number;
		/** [Config Option] (Boolean) */
		stacked?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns a string with the color to be used for the series legend item  
		* @param index Object 
		*/
		getLegendColor?( index?:any ): void;
		/** [Method] Highlight the given series item  
		* @param item Object 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlight any existing highlights */
		unHighlightItem?(): void;
	}
}
declare module Ext.chart {
	export interface IStackedBarChart extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (Number) */
		groupGutter?: number;
		/** [Config Option] (Number) */
		gutter?: number;
		/** [Config Option] (Boolean) */
		stacked?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns a string with the color to be used for the series legend item  
		* @param index Object 
		*/
		getLegendColor?( index?:any ): void;
		/** [Method] Highlight the given series item  
		* @param item Object 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlight any existing highlights */
		unHighlightItem?(): void;
	}
}
declare module Ext.chart.series {
	export interface ICartesian extends Ext.chart.series.ISeries {
		/** [Config Option] (String/String[]) */
		axis?: any;
		/** [Config Option] (String) */
		xField?: string;
		/** [Config Option] (String/String[]) */
		yField?: any;
		/** [Method] Iterates over a given record s values for each of this series s yFields executing a given function for each value  
		* @param record Ext.data.Model 
		* @param fn Function 
		* @param scope Object 
		*/
		eachYValue?( record?:Ext.data.IModel, fn?:any, scope?:any ): void;
		/** [Method] Calculate the min and max values for this series s xField  
		* @returns Array [min, max] 
		*/
		getMinMaxXValues?(): any[];
		/** [Method] Calculate the min and max values for this series s yField s 
		* @returns Array [min, max] 
		*/
		getMinMaxYValues?(): any[];
		/** [Method] Returns an array of functions each of which returns the value of the yField corresponding to function s index in the  
		* @returns Array array of accessor functions 
		*/
		getYValueAccessors?(): any[];
		/** [Method] Returns the number of yField values taking into account fields combined via legend drag drop  
		* @returns Number 
		*/
		getYValueCount?(): number;
	}
}
declare module Ext.chart {
	export interface ICartesianSeries extends Ext.chart.series.ISeries {
		/** [Config Option] (String/String[]) */
		axis?: any;
		/** [Config Option] (String) */
		xField?: string;
		/** [Config Option] (String/String[]) */
		yField?: any;
		/** [Method] Iterates over a given record s values for each of this series s yFields executing a given function for each value  
		* @param record Ext.data.Model 
		* @param fn Function 
		* @param scope Object 
		*/
		eachYValue?( record?:Ext.data.IModel, fn?:any, scope?:any ): void;
		/** [Method] Calculate the min and max values for this series s xField  
		* @returns Array [min, max] 
		*/
		getMinMaxXValues?(): any[];
		/** [Method] Calculate the min and max values for this series s yField s 
		* @returns Array [min, max] 
		*/
		getMinMaxYValues?(): any[];
		/** [Method] Returns an array of functions each of which returns the value of the yField corresponding to function s index in the  
		* @returns Array array of accessor functions 
		*/
		getYValueAccessors?(): any[];
		/** [Method] Returns the number of yField values taking into account fields combined via legend drag drop  
		* @returns Number 
		*/
		getYValueCount?(): number;
	}
}
declare module Ext.chart {
	export interface ICartesianChart extends Ext.chart.series.ISeries {
		/** [Config Option] (String/String[]) */
		axis?: any;
		/** [Config Option] (String) */
		xField?: string;
		/** [Config Option] (String/String[]) */
		yField?: any;
		/** [Method] Iterates over a given record s values for each of this series s yFields executing a given function for each value  
		* @param record Ext.data.Model 
		* @param fn Function 
		* @param scope Object 
		*/
		eachYValue?( record?:Ext.data.IModel, fn?:any, scope?:any ): void;
		/** [Method] Calculate the min and max values for this series s xField  
		* @returns Array [min, max] 
		*/
		getMinMaxXValues?(): any[];
		/** [Method] Calculate the min and max values for this series s yField s 
		* @returns Array [min, max] 
		*/
		getMinMaxYValues?(): any[];
		/** [Method] Returns an array of functions each of which returns the value of the yField corresponding to function s index in the  
		* @returns Array array of accessor functions 
		*/
		getYValueAccessors?(): any[];
		/** [Method] Returns the number of yField values taking into account fields combined via legend drag drop  
		* @returns Number 
		*/
		getYValueCount?(): number;
	}
}
declare module Ext.chart.series {
	export interface IColumn extends Ext.chart.series.IBar {
		/** [Config Option] (String) */
		axis?: string;
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
	}
}
declare module Ext.chart {
	export interface IColumnSeries extends Ext.chart.series.IBar {
		/** [Config Option] (String) */
		axis?: string;
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
	}
}
declare module Ext.chart {
	export interface IColumnChart extends Ext.chart.series.IBar {
		/** [Config Option] (String) */
		axis?: string;
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
	}
}
declare module Ext.chart {
	export interface IStackedColumnChart extends Ext.chart.series.IBar {
		/** [Config Option] (String) */
		axis?: string;
		/** [Config Option] (Boolean) */
		column?: boolean;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number/Object) */
		xPadding?: any;
		/** [Config Option] (Number/Object) */
		yPadding?: any;
	}
}
declare module Ext.chart.series {
	export interface IGauge extends Ext.chart.series.ISeries {
		/** [Config Option] (String) */
		angleField?: string;
		/** [Config Option] (Boolean/Number) */
		donut?: any;
		/** [Config Option] (Number) */
		highlightDuration?: number;
		/** [Config Option] (Boolean) */
		needle?: boolean;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns the color of the series to be displayed as color for the series legend item 
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		getLegendColor?( item?:any ): void;
		/** [Method] Sets the Gauge chart to the current specified value  
		* @param value Object 
		*/
		setValue?( value?:any ): void;
	}
}
declare module Ext.chart.series {
	export interface ILine extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		fill?: boolean;
		/** [Config Option] (Object) */
		markerConfig?: any;
		/** [Config Option] (Number) */
		selectionTolerance?: number;
		/** [Config Option] (Boolean) */
		showMarkers?: boolean;
		/** [Config Option] (Boolean/Number) */
		smooth?: any;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
	}
}
declare module Ext.chart {
	export interface ILineSeries extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		fill?: boolean;
		/** [Config Option] (Object) */
		markerConfig?: any;
		/** [Config Option] (Number) */
		selectionTolerance?: number;
		/** [Config Option] (Boolean) */
		showMarkers?: boolean;
		/** [Config Option] (Boolean/Number) */
		smooth?: any;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
	}
}
declare module Ext.chart {
	export interface ILineChart extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		fill?: boolean;
		/** [Config Option] (Object) */
		markerConfig?: any;
		/** [Config Option] (Number) */
		selectionTolerance?: number;
		/** [Config Option] (Boolean) */
		showMarkers?: boolean;
		/** [Config Option] (Boolean/Number) */
		smooth?: any;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
	}
}
declare module Ext.chart.series {
	export interface IPie extends Ext.chart.series.ISeries {
		/** [Config Option] (String) */
		angleField?: string;
		/** [Config Option] (Array) */
		colorSet?: any[];
		/** [Config Option] (Boolean/Number) */
		donut?: any;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Number) */
		highlightDuration?: number;
		/** [Config Option] (String) */
		lengthField?: string;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (String) */
		xField?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns the color of the series to be displayed as color for the series legend item 
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		getLegendColor?( item?:any ): void;
		/** [Method] Highlight the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlights the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		unHighlightItem?( item?:any ): void;
	}
}
declare module Ext.chart {
	export interface IPieSeries extends Ext.chart.series.ISeries {
		/** [Config Option] (String) */
		angleField?: string;
		/** [Config Option] (Array) */
		colorSet?: any[];
		/** [Config Option] (Boolean/Number) */
		donut?: any;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Number) */
		highlightDuration?: number;
		/** [Config Option] (String) */
		lengthField?: string;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (String) */
		xField?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns the color of the series to be displayed as color for the series legend item 
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		getLegendColor?( item?:any ): void;
		/** [Method] Highlight the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlights the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		unHighlightItem?( item?:any ): void;
	}
}
declare module Ext.chart {
	export interface IPieChart extends Ext.chart.series.ISeries {
		/** [Config Option] (String) */
		angleField?: string;
		/** [Config Option] (Array) */
		colorSet?: any[];
		/** [Config Option] (Boolean/Number) */
		donut?: any;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Number) */
		highlightDuration?: number;
		/** [Config Option] (String) */
		lengthField?: string;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (String) */
		xField?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
		/** [Method] Returns the color of the series to be displayed as color for the series legend item 
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		getLegendColor?( item?:any ): void;
		/** [Method] Highlight the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Un highlights the specified item  
		* @param item Object {Object} Info about the item; same format as returned by getItemForPoint 
		*/
		unHighlightItem?( item?:any ): void;
	}
}
declare module Ext.chart.series {
	export interface IRadar extends Ext.chart.series.ISeries {
		/** [Config Option] (Object) */
		markerConfig?: any;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Boolean) */
		showMarkers?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (String) */
		xField?: string;
		/** [Config Option] (String) */
		yField?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
	}
}
declare module Ext.chart.series {
	export interface IScatter extends Ext.chart.series.ICartesian {
		/** [Config Option] (Object) */
		markerConfig?: any;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Draws the series for the current chart  */
		drawSeries?(): void;
	}
}
declare module Ext.chart.series {
	export interface ISeries extends Ext.IBase,Ext.util.IObservable,Ext.chart.ILabel,Ext.chart.IHighlight,Ext.chart.ITip,Ext.chart.ICallout {
		/** [Config Option] (Boolean/Object) */
		highlight?: any;
		/** [Config Option] (Object) */
		listeners?: any;
		/** [Config Option] (Function) */
		renderer?: any;
		/** [Config Option] (Array) */
		shadowAttributes?: any[];
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Object) */
		tips?: any;
		/** [Config Option] (String) */
		title?: string;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Iterate over each of the records for this series  
		* @param fn Function The function to execute for each record. 
		* @param scope Object Scope for the fn. 
		*/
		eachRecord?( fn?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] For a given x y point relative to the Surface find a corresponding item from this series if any  
		* @param x Number 
		* @param y Number 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain the following: 
		*/
		getItemForPoint?( x?:number, y?:number ): any;
		/** [Method] Returns a string with the color to be used for the series legend item  
		* @param index Object 
		*/
		getLegendColor?( index?:any ): void;
		/** [Method] Return the number of records being displayed in this series  */
		getRecordCount?(): void;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Hides all the elements in the series  */
		hideAll?(): void;
		/** [Method] Highlight the given series item  
		* @param item Object Info about the item; same format as returned by #getItemForPoint. 
		*/
		highlightItem?( item?:any ): void;
		/** [Method] Determines whether the series item at the given index has been excluded i e  
		* @param index Object 
		*/
		isExcluded?( index?:any ): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Called each time a new label is created  
		* @param storeItem Ext.data.Model The element of the store that is related to the sprite. 
		* @param item Object The item related to the sprite. An item is an object containing the position of the shape used to describe the visualization and also pointing to the actual shape (circle, rectangle, path, etc). 
		* @param i Number The index of the element created (i.e the first created label, second created label, etc). 
		* @param display String The label.display type. May be false if the label is hidden 
		* @returns Ext.draw.Sprite The created sprite that will draw the label. 
		*/
		onCreateLabel?( storeItem?:Ext.data.IModel, item?:any, i?:number, display?:string ): Ext.draw.ISprite;
		/** [Method] Called for updating the position of the label  
		* @param label Ext.draw.Sprite The sprite that draws the label. 
		* @param storeItem Ext.data.Model The element of the store that is related to the sprite. 
		* @param item Object The item related to the sprite. An item is an object containing the position of the shape used to describe the visualization and also pointing to the actual shape (circle, rectangle, path, etc). 
		* @param i Number The index of the element to be updated (i.e. whether it is the first, second, third from the labelGroup) 
		* @param display String The label.display type. May be false if the label is hidden 
		* @param animate Boolean A boolean value to set or unset animations for the labels. 
		* @param index Number The series index. 
		*/
		onPlaceLabel?( label?:Ext.draw.ISprite, storeItem?:Ext.data.IModel, item?:any, i?:number, display?:string, animate?:boolean, index?:number ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Changes the value of the title for the series  
		* @param index Number 
		* @param title String 
		*/
		setTitle?( index?:number, title?:string ): void;
		/** [Method] Shows all the elements in the series  */
		showAll?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Un highlight any existing highlights */
		unHighlightItem?(): void;
	}
}
declare module Ext.chart {
	export interface IShape extends Ext.IBase {
	}
	export class Shape {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.chart.theme {
	export interface IBase extends Ext.IBase {
	}
}
declare module Ext.chart.theme {
	export interface ITheme {
	}
}
declare module Ext.chart {
	export interface ITip extends Ext.IBase {
	}
}
declare module Ext.chart {
	export interface ITipSurface extends Ext.draw.IComponent {
	}
}
declare module Ext {
	export interface IClass {
		/** [Config Option] (String[]) */
		alias?: string[];
		/** [Config Option] (String/String[]) */
		alternateClassName?: any;
		/** [Config Option] (Object) */
		config?: any;
		/** [Config Option] (String) */
		extend?: string;
		/** [Config Option] (Object) */
		inheritableStatics?: any;
		/** [Config Option] (String[]/Object) */
		mixins?: any;
		/** [Config Option] (String[]) */
		requires?: string[];
		/** [Config Option] (Boolean) */
		singleton?: boolean;
		/** [Config Option] (Object) */
		statics?: any;
		/** [Config Option] (String[]) */
		uses?: string[];
	}
}
declare module Ext {
	export interface IClassManager {
	}
	export class ClassManager {
		/** [Method] Adds a batch of class name to alias mappings 
		* @param aliases Object The set of mappings of the form className : [values...] 
		* @returns Ext.ClassManager this 
		*/
		static addNameAliasMappings( aliases?:any ): Ext.IClassManager;
		/** [Method]  
		* @param alternates Object The set of mappings of the form className : [values...] 
		* @returns Ext.ClassManager this 
		*/
		static addNameAlternateMappings( alternates?:any ): Ext.IClassManager;
		/** [Method] Defines a class  
		* @param className Object 
		* @param data Object 
		* @param createdFn Object 
		*/
		static create( className?:any, data?:any, createdFn?:any ): void;
		/** [Method] Retrieve a class by its name  
		* @param name String 
		* @returns Ext.Class class 
		*/
		static get( name?:string ): Ext.IClass;
		/** [Method] Get the aliases of a class by the class name 
		* @param name String 
		* @returns Array aliases 
		*/
		static getAliasesByName( name?:string ): any[];
		/** [Method] Get a reference to the class by its alias  
		* @param alias String 
		* @returns Ext.Class class 
		*/
		static getByAlias( alias?:string ): Ext.IClass;
		/** [Method] Get the class of the provided object returns null if it s not an instance of any class created with Ext define  
		* @param object Object 
		* @returns Ext.Class class 
		*/
		static getClass( object?:any ): Ext.IClass;
		/** [Method] Returns the displayName property or className or object  
		* @param object Object 
		* @returns String 
		*/
		static getDisplayName( object?:any ): string;
		/** [Method] Get the name of the class by its reference or its instance  getName is usually invoked by the shorthand Ext getClass  
		* @param object Ext.Class/Object 
		* @returns String className 
		*/
		static getName( object?:any ): string;
		/** [Method] Get the name of a class by its alias  
		* @param alias String 
		* @returns String className 
		*/
		static getNameByAlias( alias?:string ): string;
		/** [Method] Get the name of a class by its alternate name  
		* @param alternate String 
		* @returns String className 
		*/
		static getNameByAlternate( alternate?:string ): string;
		/** [Method] Converts a string expression to an array of matching class names  
		* @param expression String 
		* @returns String[] classNames 
		*/
		static getNamesByExpression( expression?:string ): string[];
		/** [Method] Instantiate a class by its alias  
		* @param alias String 
		* @param args Object... Additional arguments after the alias will be passed to the class constructor. 
		* @returns Object instance 
		*/
		static instantiateByAlias( alias:string, ...args:any[] ): any;
		/** [Method] Checks if a class has already been created  
		* @param className String 
		* @returns Boolean exist 
		*/
		static isCreated( className?:string ): boolean;
		/** [Method] Sets a name reference to a class  
		* @param name String 
		* @param value Object 
		* @returns Ext.ClassManager this 
		*/
		static set( name?:string, value?:any ): Ext.IClassManager;
		/** [Method] Register the alias for a class  
		* @param cls Ext.Class/String a reference to a class or a className 
		* @param alias String Alias to use when referring to this class 
		* @returns Ext.ClassManager this 
		*/
		static setAlias( cls?:any, alias?:string ): Ext.IClassManager;
		/** [Method] Creates a namespace and assign the value to the created object Ext ClassManager setNamespace MyCompany pkg Example 
		* @param name String 
		* @param value Object 
		*/
		static setNamespace( name?:string, value?:any ): void;
	}
}
declare module Ext {
	export interface IComponent extends Ext.IAbstractComponent,Ext.util.IFloating {
		/** [Config Option] (Boolean) */
		autoScroll?: boolean;
		/** [Config Option] (Number/String) */
		columnWidth?: any;
		/** [Config Option] (Ext.util.Region/Ext.Element) */
		constrainTo?: any;
		/** [Config Option] (Object/String) */
		constraintInsets?: any;
		/** [Config Option] (String) */
		defaultAlign?: string;
		/** [Config Option] (Boolean) */
		floating?: boolean;
		/** [Config Option] (Boolean) */
		formBind?: boolean;
		/** [Config Option] (String) */
		overflowX?: string;
		/** [Config Option] (String) */
		overflowY?: string;
		/** [Config Option] ("north"/"south"/"east"/"west"/"center") */
		region?: any;
		/** [Config Option] (Boolean/Object) */
		resizable?: any;
		/** [Config Option] (String) */
		resizeHandles?: string;
		/** [Config Option] (Boolean) */
		toFrontOnShow?: boolean;
		/** [Property] (Ext.Container) */
		floatParent?: Ext.IContainer;
		/** [Property] (Object) */
		scrollFlags?: any;
		/** [Property] (Ext.ZIndexManager) */
		zIndexManager?: Ext.IZIndexManager;
		/** [Property] (Ext.Container) */
		zIndexParent?: Ext.IContainer;
		/** [Method] Called by the layout system after the Component has been laid out  */
		afterComponentLayout?(): void;
		/** [Method] Invoked after the Component has been hidden  
		* @param callback Function 
		* @param scope Object 
		*/
		afterHide?( callback?:any, scope?:any ): void;
		/** [Method] Allows addition of behavior after rendering is complete  */
		afterRender?(): void;
		/** [Method] Template method called after a Component has been positioned  
		* @param ax Object 
		* @param ay Object 
		*/
		afterSetPosition?( ax?:any, ay?:any ): void;
		/** [Method] Invoked after the Component is shown after onShow is called 
		* @param animateTarget String/Ext.Element 
		* @param callback Function 
		* @param scope Object 
		*/
		afterShow?( animateTarget?:any, callback?:any, scope?:any ): void;
		/** [Method] Occurs before componentLayout is run  */
		beforeLayout?(): void;
		/** [Method] Invoked before the Component is shown  */
		beforeShow?(): void;
		/** [Method] Bubbles up the component container heirarchy calling the specified function with each component  
		* @param fn Function The function to call 
		* @param scope Object The scope of the function. Defaults to current node. 
		* @param args Array The args to call the function with. Defaults to passing the current component. 
		* @returns Ext.Component this 
		*/
		bubble?( fn?:any, scope?:any, args?:any[] ): Ext.IComponent;
		/** [Method] Cancel any deferred focus on this component */
		cancelFocus?(): void;
		/** [Method] Center this Component in its container  
		* @returns Ext.Component this 
		*/
		center?(): Ext.IComponent;
		/** [Method] Clone the current component using the original config values passed into this instance by default  
		* @param overrides Object A new config containing any properties to override in the cloned version. An id property can be passed on this object, otherwise one will be generated to avoid duplicates. 
		* @returns Ext.Component clone The cloned copy of this component 
		*/
		cloneConfig?( overrides?:any ): Ext.IComponent;
		/** [Method] Moves this floating Component into a constrain region  
		* @param constrainTo String/HTMLElement/Ext.Element/Ext.util.Region The Element or Region into which this Component is to be constrained. Defaults to the element into which this floating Component was rendered. 
		*/
		doConstrain?( constrainTo?:any ): void;
		/** [Method] Find a container above this component at any level by a custom function  
		* @param fn Function The custom function to call with the arguments (container, this component). 
		* @returns Ext.container.Container The first Container for which the custom function returns true 
		*/
		findParentBy?( fn?:any ): Ext.container.IContainer;
		/** [Method] Find a container above this component at any level by xtype or class See also the up method  
		* @param xtype String/Ext.Class The xtype string for a component, or the class of the component directly 
		* @returns Ext.container.Container The first Container which matches the given xtype or class 
		*/
		findParentByType?( xtype?:any ): Ext.container.IContainer;
		/** [Method] Try to focus this component  
		* @param selectText Boolean If applicable, true to also select the text in this component 
		* @param delay Boolean/Number Delay the focus this number of milliseconds (true for 10 milliseconds). 
		* @param callback Function Only needed if the delay parameter is used. A function to call upon focus. 
		* @param scope Function Only needed if the delay parameter is used. The scope (this reference) in which to execute the callback. 
		* @returns Ext.Component The focused Component. Usually this Component. Some Containers may delegate focus to a descendant Component (Windows can do this through their defaultFocus config option. 
		*/
		focus?( selectText?:boolean, delay?:any, callback?:any, scope?:any ): Ext.IComponent;
		/** [Method] Retrieves the top level element representing this component  
		* @returns Ext.dom.Element 
		*/
		getEl?(): Ext.dom.IElement;
		/** [Method] Retrieves the id of this component  
		* @returns String 
		*/
		getId?(): string;
		/** [Method] Gets the current XY position of the component s underlying element  
		* @param local Boolean If true the element's left and top are returned instead of page XY. 
		* @returns Number[] The XY position of the element (e.g., [100, 200]) 
		*/
		getPosition?( local?:boolean ): number[];
		/** [Method] Gets the xtype for this component as registered with Ext ComponentManager  
		* @returns String The xtype 
		*/
		getXType?(): string;
		/** [Method] Hides this Component setting it to invisible using the configured hideMode  
		* @param animateTarget String/Ext.Element/Ext.Component only valid for floating Components such as Windows or ToolTips, or regular Components which have been configured with floating: true.. The target to which the Component should animate while hiding. 
		* @param callback Function A callback function to call after the Component is hidden. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to this Component. 
		* @returns Ext.Component this 
		*/
		hide?( animateTarget?:any, callback?:any, scope?:any ): Ext.IComponent;
		/** [Method] The initComponent template method is an important initialization step for a Component  */
		initComponent?(): void;
		/** [Method] Method to manage awareness of when components are added to their respective Container firing an added event  */
		onAdded?(): void;
		/** [Method] Allows addition of behavior to the destroy operation  */
		onDestroy?(): void;
		/** [Method] Possibly animates down to a target element  
		* @param animateTarget String/Ext.Element/Ext.Component 
		* @param callback Function 
		* @param scope Object 
		*/
		onHide?( animateTarget?:any, callback?:any, scope?:any ): void;
		/** [Method] Allows addition of behavior to the show operation  
		* @param animateTarget String/Ext.Element 
		* @param callback Function 
		* @param scope Object 
		*/
		onShow?( animateTarget?:any, callback?:any, scope?:any ): void;
		/** [Method] Invoked after the afterShow method is complete  
		* @param callback Function 
		* @param scope Object 
		*/
		onShowComplete?( callback?:any, scope?:any ): void;
		/** [Method] Scrolls this Component s target element by the passed delta values optionally animating  
		* @param deltaX Number/Number[]/Object Either the x delta, an Array specifying x and y deltas or an object with "x" and "y" properties. 
		* @param deltaY Number/Boolean/Object Either the y delta, or an animate flag or config object. 
		* @param animate Boolean/Object Animate flag/config object if the delta values were passed separately. 
		*/
		scrollBy?( deltaX?:any, deltaY?:any, animate?:any ): void;
		/** [Method] This method is called internally by Ext ZIndexManager to signal that a floating Component has either been moved to th  
		* @param active Boolean True to activate the Component, false to deactivate it. 
		* @param newActive Ext.Component The newly active Component which is taking over topmost zIndex position. 
		*/
		setActive?( active?:boolean, newActive?:Ext.IComponent ): void;
		/** [Method] Sets the overflow on the content element of the component  
		* @param scroll Boolean True to allow the Component to auto scroll. 
		* @returns Ext.Component this 
		*/
		setAutoScroll?( scroll?:boolean ): Ext.IComponent;
		/** [Method] This method changes the region config property for this border region  
		* @param region String The new region value ("north", "south", "east" or "west"). 
		* @returns String The previous value of the region property. 
		*/
		setBorderRegion?( region?:string ): string;
		/** [Method] This method allows you to show or hide a LoadMask on top of this component  
		* @param load Boolean/Object/String True to show the default LoadMask, a config object that will be passed to the LoadMask constructor, or a message String to show. False to hide the current LoadMask. 
		* @param targetEl Boolean True to mask the targetEl of this Component instead of the this.el. For example, setting this to true on a Panel will cause only the body to be masked. 
		* @returns Ext.LoadMask The LoadMask instance that has just been shown. 
		*/
		setLoading?( load?:any, targetEl?:boolean ): Ext.ILoadMask;
		/** [Method] Sets the overflow x y on the content element of the component  
		* @param overflowX String The overflow-x value. 
		* @param overflowY String The overflow-y value. 
		* @returns Ext.Component this 
		*/
		setOverflowXY?( overflowX?:string, overflowY?:string ): Ext.IComponent;
		/** [Method] Sets the page XY position of the component  
		* @param x Number/Number[] The new x position or an array of [x,y]. 
		* @param y Number The new y position. 
		* @param animate Boolean/Object True to animate the Component into its new position. You may also pass an animation configuration. 
		* @returns Ext.Component this 
		*/
		setPagePosition?( x?:any, y?:number, animate?:any ): Ext.IComponent;
		/** [Method] Sets the left and top of the component  
		* @param x Number/Number[]/Object The new left, an array of [x,y], or animation config object containing x and y properties. 
		* @param y Number The new top. 
		* @param animate Boolean/Object If true, the Component is animated into its new position. You may also pass an animation configuration. 
		* @returns Ext.Component this 
		*/
		setPosition?( x?:any, y?:number, animate?:any ): Ext.IComponent;
		/** [Method] Sets the weight config property for this component  
		* @param weight Number The new weight value. 
		* @returns Number The previous value of the weight property. 
		*/
		setRegionWeight?( weight?:number ): number;
		/** [Method] Shows this Component rendering it first if autoRender or floating are true  
		* @param animateTarget String/Ext.Element only valid for floating Components such as Windows or ToolTips, or regular Components which have been configured with floating: true. The target from which the Component should animate from while opening. 
		* @param callback Function A callback function to call after the Component is displayed. Only necessary if animation was specified. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to this Component. 
		* @returns Ext.Component this 
		*/
		show?( animateTarget?:any, callback?:any, scope?:any ): Ext.IComponent;
		/** [Method] Displays component at specific xy position  
		* @param x Number/Number[] The new x position or array of [x,y]. 
		* @param y Number The new y position 
		* @param animate Boolean/Object True to animate the Component into its new position. You may also pass an animation configuration. 
		* @returns Ext.Component this 
		*/
		showAt?( x?:any, y?:number, animate?:any ): Ext.IComponent;
		/** [Method] Shows this component by the specified Component or Element  
		* @param component Ext.Component/Ext.dom.Element The Ext.Component or Ext.Element to show the component by. 
		* @param position String Alignment position as used by Ext.util.Positionable.getAlignToXY. Defaults to defaultAlign. 
		* @param offsets Number[] Alignment offsets as used by Ext.util.Positionable.getAlignToXY. 
		* @returns Ext.Component this 
		*/
		showBy?( component?:any, position?:string, offsets?:number[] ): Ext.IComponent;
		/** [Method] Sends this Component to the back of lower z index than any other visible windows 
		* @returns Ext.Component this 
		*/
		toBack?(): Ext.IComponent;
		/** [Method] Brings this floating Component to the front of any other visible floating Components managed by the same ZIndexManag  
		* @param preventFocus Boolean Specify true to prevent the Component from being focused. 
		* @returns Ext.Component this 
		*/
		toFront?( preventFocus?:boolean ): Ext.IComponent;
		/** [Method] Sets the current box measurements of the component s underlying element  
		* @param box Object An object in the format {x, y, width, height} 
		* @returns Ext.Component this 
		*/
		updateBox?( box?:any ): Ext.IComponent;
	}
}
declare module Ext {
	export interface IComponentLoader extends Ext.IElementLoader {
		/** [Config Option] (Boolean/Object) */
		loadMask?: any;
		/** [Config Option] (Boolean) */
		scripts?: boolean;
		/** [Config Option] (Ext.Component/String) */
		target?: any;
		/** [Method] Set a Ext Component as the target of this loader  
		* @param target String/Ext.Component The component to be the target of this loader. If a string is passed it will be looked up via its id. 
		*/
		setTarget?( target?:any ): void;
	}
}
declare module Ext {
	export interface IComponentManager extends Ext.IAbstractManager {
	}
	export class ComponentManager {
		/** [Property] (Ext.util.HashMap) */
		static all: Ext.util.IHashMap;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new Component from the specified config object using the config object s xtype to determine the class to in  
		* @param config Object A configuration object for the Component you wish to create. 
		* @param defaultType String The xtype to use if the config object does not contain a xtype. (Optional if the config contains a xtype). 
		* @returns Ext.Component The newly instantiated Component. 
		*/
		static create( config?:any, defaultType?:string ): Ext.IComponent;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. Defaults to this. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item 
		* @returns Object The item, undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		static onAvailable( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed 
		* @param item Object The item to register 
		*/
		static register( item?:any ): void;
		/** [Method] Registers a new item constructor keyed by a type key  
		* @param type Object 
		* @param cls Object 
		*/
		static registerType( type?:any, cls?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager 
		* @param item Object The item to unregister 
		*/
		static unregister( item?:any ): void;
	}
}
declare module Ext {
	export interface IComponentMgr extends Ext.IAbstractManager {
	}
	export class ComponentMgr {
		/** [Property] (Ext.util.HashMap) */
		static all: Ext.util.IHashMap;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new Component from the specified config object using the config object s xtype to determine the class to in  
		* @param config Object A configuration object for the Component you wish to create. 
		* @param defaultType String The xtype to use if the config object does not contain a xtype. (Optional if the config contains a xtype). 
		* @returns Ext.Component The newly instantiated Component. 
		*/
		static create( config?:any, defaultType?:string ): Ext.IComponent;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. Defaults to this. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item 
		* @returns Object The item, undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		static onAvailable( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed 
		* @param item Object The item to register 
		*/
		static register( item?:any ): void;
		/** [Method] Registers a new item constructor keyed by a type key  
		* @param type Object 
		* @param cls Object 
		*/
		static registerType( type?:any, cls?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager 
		* @param item Object The item to unregister 
		*/
		static unregister( item?:any ): void;
	}
}
declare module Ext {
	export interface IComponentQuery extends Ext.IBase {
	}
	export class ComponentQuery {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Tests whether the passed Component matches the selector string  
		* @param component Ext.Component The Component to test 
		* @param selector String The selector string to test against. 
		* @returns Boolean True if the Component matches the selector. 
		*/
		static is( component?:Ext.IComponent, selector?:string ): boolean;
		/** [Method] Returns an array of matched Components from within the passed root object  
		* @param selector String The selector string to filter returned Components 
		* @param root Ext.container.Container The Container within which to perform the query. If omitted, all Components within the document are included in the search. This parameter may also be an array of Components to filter according to the selector. 
		* @returns Ext.Component[] The matched Components. 
		*/
		static query( selector?:string, root?:Ext.container.IContainer ): Ext.IComponent[];
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.container {
	export interface IAbstractContainer extends Ext.IComponent,Ext.IQueryable {
		/** [Config Option] (String/Number) */
		activeItem?: any;
		/** [Config Option] (Boolean) */
		autoDestroy?: boolean;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String[]) */
		bubbleEvents?: string[];
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Object/Function) */
		defaults?: any;
		/** [Config Option] (Boolean) */
		detachOnRemove?: boolean;
		/** [Config Option] (Object/Object[]) */
		items?: any;
		/** [Config Option] (Ext.enums.Layout/Object) */
		layout?: any;
		/** [Config Option] (Ext.XTemplate/String/String[]) */
		renderTpl?: any;
		/** [Config Option] (Boolean) */
		suspendLayout?: boolean;
		/** [Method] Adds Component s to this Container  
		* @param component Ext.Component[]|Object[]/Ext.Component.../Object... Either one or more Components to add or an Array of Components to add. See items for additional information. 
		* @returns Ext.Component[]/Ext.Component The Components that were added. 
		*/
		add?( component?:any ): any;
		/** [Method] Called by the layout system after the Component has been laid out  */
		afterComponentLayout?(): void;
		/** [Method] Invoked after the Container has laid out and rendered if necessary its child Components  
		* @param layout Ext.layout.container.Container 
		*/
		afterLayout?( layout?:Ext.layout.container.IContainer ): void;
		/** [Method] Cascades down the component container heirarchy from this component passed in the first call  calling the specified  
		* @param fn Function The function to call 
		* @param scope Object The scope of the function (defaults to current component) 
		* @param args Array The args to call the function with. The current component always passed as the last argument. 
		* @returns Ext.Container this 
		*/
		cascade?( fn?:any, scope?:any, args?:any[] ): Ext.IContainer;
		/** [Method] Retrieves the first direct child of this container which matches the passed selector or component  
		* @param selector String/Ext.Component An Ext.ComponentQuery selector. If no selector is specified, the first child will be returned. 
		* @returns Object Ext.Component The matching child Ext.Component (or null if no match was found). 
		*/
		child?( selector?:any ): any;
		/** [Method] Determines whether the passed Component is either an immediate child of this Container or whether it is a descendant  
		* @param comp Ext.Component The Component to test. 
		* @param deep Boolean Pass true to test for the Component being a descendant at any level. 
		* @returns Boolean true if the passed Component is contained at the specified level. 
		*/
		contains?( comp?:Ext.IComponent, deep?:boolean ): boolean;
		/** [Method] Inherit docs Disable all immediate children that was previously disabled Override disable because onDisable only gets  
		* @returns Ext.container.AbstractContainer this 
		*/
		disable?(): Ext.container.IAbstractContainer;
		/** [Method] Manually force this container s layout to be recalculated  
		* @returns Ext.container.Container this 
		*/
		doLayout?(): Ext.container.IContainer;
		/** [Method] Retrieves the first descendant of this container which matches the passed selector  
		* @param selector String/Ext.Component An Ext.ComponentQuery selector or Ext.Component. If no selector is specified, the first child will be returned. 
		* @returns Object Ext.Component The matching descendant Ext.Component (or null if no match was found). 
		*/
		down?( selector?:any ): any;
		/** [Method] Examines this container s items property and gets a direct child component of this container  
		* @param comp String/Number This parameter may be any of the following:  a String : representing the itemId or id of the child component. a Number : representing the position of the child component within the items property For additional information see Ext.util.MixedCollection.get. 
		* @returns Ext.Component The component (if found). 
		*/
		getComponent?( comp?:any ): Ext.IComponent;
		/** [Method] Returns the layout instance currently associated with this Container  
		* @returns Ext.layout.container.Container The layout 
		*/
		getLayout?(): Ext.layout.container.IContainer;
		/** [Method] Used by ComponentQuery child and down to retrieve all of the items which can potentially be considered a child of th  
		* @param deep Object 
		*/
		getRefItems?( deep?:any ): void;
		/** [Method] Inserts a Component into this Container at a specified index  
		* @param index Number The index at which the Component will be inserted into the Container's items collection 
		* @param component Ext.Component/Object The child Component to insert. Ext uses lazy rendering, and will only render the inserted Component should it become necessary. A Component config object may be passed in order to avoid the overhead of constructing a real Component object if lazy rendering might mean that the inserted Component will not be rendered immediately. To take advantage of this 'lazy instantiation', set the Ext.Component.xtype config property to the registered type of the Component wanted. For a list of all available xtypes, see Ext.enums.Widget. 
		* @returns Ext.Component component The Component (or config object) that was inserted with the Container's default config values applied. 
		*/
		insert?( index?:number, component?:any ): Ext.IComponent;
		/** [Method] Determines whether this Container is an ancestor of the passed Component  
		* @param possibleDescendant Ext.Component The Component to test for presence within this Container's subtree. 
		*/
		isAncestor?( possibleDescendant?:Ext.IComponent ): void;
		/** [Method] Moves a Component within the Container 
		* @param fromIdx Number/Ext.Component The index/component to move. 
		* @param toIdx Number The new index for the Component. 
		* @returns Ext.Component component The Component that was moved. 
		*/
		move?( fromIdx?:any, toIdx?:number ): Ext.IComponent;
		/** [Method] This method is invoked after a new Component has been added  
		* @param component Ext.Component 
		* @param position Number 
		*/
		onAdd?( component?:Ext.IComponent, position?:number ): void;
		/** [Method] This method is invoked before adding a new child Component  
		* @param item Ext.Component 
		*/
		onBeforeAdd?( item?:Ext.IComponent ): void;
		/** [Method] Called after the component is moved this method is empty by default but can be implemented by any subclass that need  */
		onPosition?(): void;
		/** [Method] This method is invoked after a new Component has been removed  
		* @param component Ext.Component 
		* @param autoDestroy Boolean 
		*/
		onRemove?( component?:Ext.IComponent, autoDestroy?:boolean ): void;
		/** [Method] Allows addition of behavior to the resize operation  */
		onResize?(): void;
		/** [Method] Retrieves all descendant components which match the passed selector  
		* @param selector String Selector complying to an Ext.ComponentQuery selector. If no selector is specified all items will be returned. 
		* @returns Ext.Component[] Components which matched the selector 
		*/
		query?( selector?:string ): Ext.IComponent[];
		/** [Method] Retrieves all descendant components which match the passed function  
		* @param fn Function The matcher function. It will be called with a single argument, the component being tested. 
		* @param scope Object The scope in which to run the function. If not specified, it will default to the active component. 
		* @returns Ext.Component[] Components matched by the passed function 
		*/
		queryBy?( fn?:any, scope?:any ): Ext.IComponent[];
		/** [Method] Finds a component at any level under this container matching the id itemId  
		* @param id String The id to find 
		* @returns Ext.Component The matching id, null if not found 
		*/
		queryById?( id?:string ): Ext.IComponent;
		/** [Method] Removes a component from this container  
		* @param component Ext.Component/String The component reference or id to remove. 
		* @param autoDestroy Boolean True to automatically invoke the removed Component's Ext.Component.destroy function. Defaults to the value of this Container's autoDestroy config. 
		* @returns Ext.Component component The Component that was removed. 
		*/
		remove?( component?:any, autoDestroy?:boolean ): Ext.IComponent;
		/** [Method] Removes all components from this container  
		* @param autoDestroy Boolean True to automatically invoke the removed Component's Ext.Component.destroy function. Defaults to the value of this Container's autoDestroy config. 
		* @returns Ext.Component[] Array of the removed components 
		*/
		removeAll?( autoDestroy?:boolean ): Ext.IComponent[];
	}
}
declare module Ext.container {
	export interface IButtonGroup extends Ext.panel.IPanel {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Number) */
		columns?: number;
		/** [Config Option] (String) */
		defaultButtonUI?: string;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Boolean) */
		frame?: boolean;
		/** [Config Option] (Ext.enums.Layout/Object) */
		layout?: any;
		/** [Config Option] (String) */
		titleAlign?: string;
		/** [Method] private 
		* @param component Object 
		*/
		onBeforeAdd?( component?:any ): void;
	}
}
declare module Ext {
	export interface IButtonGroup extends Ext.panel.IPanel {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Number) */
		columns?: number;
		/** [Config Option] (String) */
		defaultButtonUI?: string;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Boolean) */
		frame?: boolean;
		/** [Config Option] (Ext.enums.Layout/Object) */
		layout?: any;
		/** [Config Option] (String) */
		titleAlign?: string;
		/** [Method] private 
		* @param component Object 
		*/
		onBeforeAdd?( component?:any ): void;
	}
}
declare module Ext.container {
	export interface IContainer extends Ext.container.IAbstractContainer {
		/** [Config Option] (Number/Object) */
		anchorSize?: any;
		/** [Method] Return the immediate child Component in which the passed element is located  
		* @param el Ext.Element/HTMLElement/String The element to test (or ID of element). 
		* @param deep Boolean If true, returns the deepest descendant Component which contains the passed element. 
		* @returns Ext.Component The child item which contains the passed element. 
		*/
		getChildByElement?( el?:any, deep?:boolean ): Ext.IComponent;
	}
}
declare module Ext {
	export interface IContainer extends Ext.container.IAbstractContainer {
		/** [Config Option] (Number/Object) */
		anchorSize?: any;
		/** [Method] Return the immediate child Component in which the passed element is located  
		* @param el Ext.Element/HTMLElement/String The element to test (or ID of element). 
		* @param deep Boolean If true, returns the deepest descendant Component which contains the passed element. 
		* @returns Ext.Component The child item which contains the passed element. 
		*/
		getChildByElement?( el?:any, deep?:boolean ): Ext.IComponent;
	}
}
declare module Ext.container {
	export interface IDockingContainer extends Ext.IBase {
		/** [Config Option] (Object) */
		defaultDockWeights?: any;
		/** [Method] Adds docked item s to the container  
		* @param component Object/Object[] The Component or array of components to add. The components must include a 'dock' parameter on each component to indicate where it should be docked ('top', 'right', 'bottom', 'left'). 
		* @param pos Number The index at which the Component will be added 
		* @returns Ext.Component[] The added components. 
		*/
		addDocked?( component?:any, pos?:number ): Ext.IComponent[];
		/** [Method] Finds a docked component by id itemId or position  
		* @param comp String/Number The id, itemId or position of the docked component (see getComponent for details) 
		* @returns Ext.Component The docked component (if found) 
		*/
		getDockedComponent?( comp?:any ): Ext.IComponent;
		/** [Method] Retrieves an array of all currently docked Components  
		* @param selector String A ComponentQuery selector string to filter the returned items. 
		* @param beforeBody Boolean An optional flag to limit the set of items to only those before the body (true) or after the body (false). All components are returned by default. 
		* @returns Ext.Component[] The array of docked components meeting the specified criteria. 
		*/
		getDockedItems?( selector?:string, beforeBody?:boolean ): Ext.IComponent[];
		/** [Method] Inserts docked item s to the panel at the indicated position  
		* @param pos Number The index at which the Component will be inserted 
		* @param component Object/Object[] The Component or array of components to add. The components must include a 'dock' paramater on each component to indicate where it should be docked ('top', 'right', 'bottom', 'left'). 
		*/
		insertDocked?( pos?:number, component?:any ): void;
		/** [Method] Invoked after a docked item is added to the Panel  
		* @param component Ext.Component 
		*/
		onDockedAdd?( component?:Ext.IComponent ): void;
		/** [Method] Invoked after a docked item is removed from the Panel  
		* @param component Ext.Component 
		*/
		onDockedRemove?( component?:Ext.IComponent ): void;
		/** [Method] Removes the docked item from the panel  
		* @param item Ext.Component The Component to remove. 
		* @param autoDestroy Boolean Destroy the component after removal. 
		*/
		removeDocked?( item?:Ext.IComponent, autoDestroy?:boolean ): void;
	}
}
declare module Ext.container {
	export interface IMonitor extends Ext.IBase {
	}
}
declare module Ext.container {
	export interface IViewport extends Ext.container.IContainer {
		/** [Property] (Boolean) */
		isViewport?: boolean;
		/** [Method] Template method called when this Component s DOM structure is created  */
		onRender?(): void;
	}
}
declare module Ext {
	export interface IViewport extends Ext.container.IContainer {
		/** [Property] (Boolean) */
		isViewport?: boolean;
		/** [Method] Template method called when this Component s DOM structure is created  */
		onRender?(): void;
	}
}
declare module Ext.data {
	export interface IAbstractStore extends Ext.IBase,Ext.util.IObservable,Ext.util.ISortable {
		/** [Config Option] (Boolean/Object) */
		autoLoad?: any;
		/** [Config Option] (Boolean) */
		autoSync?: boolean;
		/** [Config Option] (String) */
		batchUpdateMode?: string;
		/** [Config Option] (Object[]) */
		fields?: any[];
		/** [Config Option] (Boolean) */
		filterOnLoad?: boolean;
		/** [Config Option] (Object[]/Function[]) */
		filters?: any;
		/** [Config Option] (String) */
		model?: string;
		/** [Config Option] (String/Ext.data.proxy.Proxy/Object) */
		proxy?: any;
		/** [Config Option] (Boolean) */
		remoteFilter?: boolean;
		/** [Config Option] (Boolean) */
		remoteSort?: boolean;
		/** [Config Option] (Boolean) */
		sortOnLoad?: boolean;
		/** [Config Option] (Boolean) */
		statefulFilters?: boolean;
		/** [Config Option] (String) */
		storeId?: string;
		/** [Property] (String) */
		defaultProxyType?: string;
		/** [Property] (Boolean) */
		isDestroyed?: boolean;
		/** [Property] (Boolean) */
		isStore?: boolean;
		/** [Property] (Ext.data.Model[]) */
		removed?: Ext.data.IModel[];
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns a comparator function which compares two items and returns 1 0 or 1 depending on the currently defined set  */
		generateComparator?(): void;
		/** [Method] Gets the first sorter from the sorters collection excluding any groupers that may be in place 
		* @returns Ext.util.Sorter The sorter, null if none exist 
		*/
		getFirstSorter?(): Ext.util.ISorter;
		/** [Method] Gets all records added or updated since the last commit  
		* @returns Ext.data.Model[] The added and updated Model instances 
		*/
		getModifiedRecords?(): Ext.data.IModel[];
		/** [Method] Returns all Model instances that are either currently a phantom e g  
		* @returns Ext.data.Model[] The Model instances 
		*/
		getNewRecords?(): Ext.data.IModel[];
		/** [Method] Returns the proxy currently attached to this proxy instance 
		* @returns Ext.data.proxy.Proxy The Proxy instance 
		*/
		getProxy?(): Ext.data.proxy.IProxy;
		/** [Method] Returns any records that have been removed from the store but not yet destroyed on the proxy  
		* @returns Ext.data.Model[] The removed Model instances 
		*/
		getRemovedRecords?(): Ext.data.IModel[];
		/** [Method] Returns all Model instances that have been updated in the Store but not yet synchronized with the Proxy 
		* @returns Ext.data.Model[] The updated Model instances 
		*/
		getUpdatedRecords?(): Ext.data.IModel[];
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Performs initialization of this mixin  */
		initSortable?(): void;
		/** [Method] Returns true if the Store is currently performing a load operation 
		* @returns Boolean True if the Store is currently loading 
		*/
		isLoading?(): boolean;
		/** [Method] Loads the Store using its configured proxy  
		* @param options Object config object. This is passed into the Operation object that is created and then sent to the proxy's Ext.data.proxy.Proxy.read function 
		* @returns void this 
		*/
		load?( options?:any ): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Reloads the store using the last options passed to the load method  
		* @param options Object A config object which contains options which may override the options passed to the previous load call. 
		*/
		reload?( options?:any ): void;
		/** [Method] Removes all records from the store  */
		removeAll?(): void;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes automatically syncing the Store with its Proxy  */
		resumeAutoSync?(): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Saves all pending changes via the configured proxy  */
		save?(): void;
		/** [Method] Sets the Store s Proxy by string config object or Proxy instance 
		* @param proxy String/Object/Ext.data.proxy.Proxy The new Proxy, which can be either a type string, a configuration object or an Ext.data.proxy.Proxy instance 
		* @returns Ext.data.proxy.Proxy The attached Proxy object 
		*/
		setProxy?( proxy?:any ): Ext.data.proxy.IProxy;
		/** [Method] Sorts the data in the Store by one or more of its properties  
		* @param sorters String/Ext.util.Sorter[] Either a string name of one of the fields in this Store's configured Model, or an array of sorter configurations. 
		* @param direction String The overall direction to sort the data by. 
		* @returns Ext.util.Sorter[] 
		*/
		sort?( sorters?:any, direction?:string ): Ext.util.ISorter[];
		/** [Method] Suspends automatically syncing the Store with its Proxy  */
		suspendAutoSync?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Synchronizes the store with its proxy  
		* @param options Object Object containing one or more properties supported by the sync method (these get passed along to the underlying proxy's batch method): 
		* @returns Ext.data.Store this 
		*/
		sync?( options?:any ): Ext.data.IStore;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
	export class AbstractStore {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Creates a store from config object  
		* @param store Object/Ext.data.AbstractStore A config for the store to be created. It may contain a type field which defines the particular type of store to create. Alteratively passing an actual store to this method will just return it, no changes made. 
		* @returns Ext.data.AbstractStore The created store. 
		*/
		static create( store?:any ): Ext.data.IAbstractStore;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface IArrayStore extends Ext.data.IStore {
		/** [Method] Loads an array of data straight into the Store  
		* @param data Object 
		* @param append Object 
		*/
		loadData?( data?:any, append?:any ): void;
	}
}
declare module Ext.data.association {
	export interface IAssociation extends Ext.IBase {
		/** [Config Option] (String) */
		associatedModel?: string;
		/** [Config Option] (String) */
		associationKey?: string;
		/** [Config Option] (String) */
		model?: string;
		/** [Config Option] (String) */
		ownerModel?: string;
		/** [Config Option] (String) */
		primaryKey?: string;
		/** [Config Option] (Ext.data.reader.Reader) */
		reader?: Ext.data.reader.IReader;
		/** [Property] (String) */
		associatedName?: string;
		/** [Property] (String) */
		ownerName?: string;
		/** [Method] Get a specialized reader for reading associated data 
		* @returns Ext.data.reader.Reader The reader, null if not supplied 
		*/
		getReader?(): Ext.data.reader.IReader;
	}
}
declare module Ext.data {
	export interface IAssociation extends Ext.IBase {
		/** [Config Option] (String) */
		associatedModel?: string;
		/** [Config Option] (String) */
		associationKey?: string;
		/** [Config Option] (String) */
		model?: string;
		/** [Config Option] (String) */
		ownerModel?: string;
		/** [Config Option] (String) */
		primaryKey?: string;
		/** [Config Option] (Ext.data.reader.Reader) */
		reader?: Ext.data.reader.IReader;
		/** [Property] (String) */
		associatedName?: string;
		/** [Property] (String) */
		ownerName?: string;
		/** [Method] Get a specialized reader for reading associated data 
		* @returns Ext.data.reader.Reader The reader, null if not supplied 
		*/
		getReader?(): Ext.data.reader.IReader;
	}
}
declare module Ext.data.association {
	export interface IBelongsTo extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Config Option] (String) */
		type?: string;
	}
}
declare module Ext.data {
	export interface IBelongsToAssociation extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Config Option] (String) */
		type?: string;
	}
}
declare module Ext.data.association {
	export interface IHasMany extends Ext.data.association.IAssociation {
		/** [Config Option] (Boolean) */
		autoLoad?: boolean;
		/** [Config Option] (String) */
		filterProperty?: string;
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (Object) */
		storeConfig?: any;
		/** [Config Option] (String) */
		type?: string;
	}
}
declare module Ext.data {
	export interface IHasManyAssociation extends Ext.data.association.IAssociation {
		/** [Config Option] (Boolean) */
		autoLoad?: boolean;
		/** [Config Option] (String) */
		filterProperty?: string;
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (Object) */
		storeConfig?: any;
		/** [Config Option] (String) */
		type?: string;
	}
}
declare module Ext.data.association {
	export interface IHasOne extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Config Option] (String) */
		type?: string;
	}
}
declare module Ext.data {
	export interface IHasOneAssociation extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Config Option] (String) */
		type?: string;
	}
}
declare module Ext.data {
	export interface IBatch extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Boolean) */
		autoStart?: boolean;
		/** [Config Option] (Boolean) */
		pauseOnException?: boolean;
		/** [Property] (Number) */
		current?: number;
		/** [Property] (Ext.data.Operation[]) */
		exceptions?: Ext.data.IOperation[];
		/** [Property] (Boolean) */
		hasException?: boolean;
		/** [Property] (Boolean) */
		isComplete?: boolean;
		/** [Property] (Boolean) */
		isRunning?: boolean;
		/** [Property] (Ext.data.Operation[]) */
		operations?: Ext.data.IOperation[];
		/** [Property] (Number) */
		total?: number;
		/** [Method] Adds a new operation to this batch at the end of the operations array 
		* @param operation Object The Operation object 
		* @returns Ext.data.Batch this 
		*/
		add?( operation?:any ): Ext.data.IBatch;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Pauses execution of the batch but does not cancel the current operation 
		* @returns Ext.data.Batch this 
		*/
		pause?(): Ext.data.IBatch;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Kicks off execution of the batch continuing from the current operation  
		* @returns Ext.data.Batch this 
		*/
		retry?(): Ext.data.IBatch;
		/** [Method] Executes an operation by its numeric index in the operations array 
		* @param index Number The operation index to run 
		* @returns Ext.data.Batch this 
		*/
		runOperation?( index?:number ): Ext.data.IBatch;
		/** [Method] Kicks off execution of the batch continuing from the next operation if the previous operation encountered an excepti  
		* @param index Object 
		* @returns Ext.data.Batch this 
		*/
		start?( index?:any ): Ext.data.IBatch;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IBufferStore extends Ext.data.IStore {
		/** [Config Option] (Boolean) */
		filterOnLoad?: boolean;
		/** [Config Option] (Boolean) */
		sortOnLoad?: boolean;
	}
}
declare module Ext.data {
	export interface IConnection extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Boolean) */
		autoAbort?: boolean;
		/** [Config Option] (Boolean) */
		binary?: boolean;
		/** [Config Option] (Boolean) */
		cors?: boolean;
		/** [Config Option] (Object) */
		defaultHeaders?: any;
		/** [Config Option] (Boolean) */
		disableCaching?: boolean;
		/** [Config Option] (String) */
		disableCachingParam?: string;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String) */
		method?: string;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (Boolean) */
		withCredentials?: boolean;
		/** [Method] Aborts an active request  
		* @param request Object Defaults to the last request 
		*/
		abort?( request?:any ): void;
		/** [Method] Aborts all active requests */
		abortAll?(): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Determines whether this object has a request outstanding  
		* @param request Object Defaults to the last transaction 
		* @returns Boolean True if there is an outstanding request. 
		*/
		isLoading?( request?:any ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Checks if the response status was successful 
		* @param status Number The status code 
		* @returns Object An object containing success/status state 
		*/
		parseStatus?( status?:number ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Sends an HTTP request to a remote server  
		* @param options Object An object which may contain the following properties: (The options object may also contain any other property which might be needed to perform postprocessing in a callback because it is passed to callback functions.) 
		* @returns Object The request object. This may be used to cancel the request. 
		*/
		request?( options?:any ): any;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Sets various options such as the url params for the request 
		* @param options Object The initial options 
		* @param scope Object The scope to execute in 
		* @returns Object The params for the request 
		*/
		setOptions?( options?:any, scope?:any ): any;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Uploads a form using a hidden iframe  
		* @param form String/HTMLElement/Ext.Element The form to upload 
		* @param url String The url to post to 
		* @param params String Any extra parameters to pass 
		* @param options Object The initial options 
		*/
		upload?( form?:any, url?:string, params?:string, options?:any ): void;
	}
}
declare module Ext.data {
	export interface IDirectStore extends Ext.data.IStore {
	}
}
declare module Ext.data {
	export interface IErrors extends Ext.util.IMixedCollection {
		/** [Method] Returns all of the errors for the given field 
		* @param fieldName String The field to get errors for 
		* @returns Object[] All errors for the given field 
		*/
		getByField?( fieldName?:string ): any[];
		/** [Method] Returns true if there are no errors in the collection 
		* @returns Boolean 
		*/
		isValid?(): boolean;
	}
}
declare module Ext.data {
	export interface IField extends Ext.IBase {
		/** [Config Option] (Function) */
		convert?: any;
		/** [Config Option] (String) */
		dateFormat?: string;
		/** [Config Option] (String) */
		dateReadFormat?: string;
		/** [Config Option] (String) */
		dateWriteFormat?: string;
		/** [Config Option] (Object) */
		defaultValue?: any;
		/** [Config Option] (String/Number) */
		mapping?: any;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (Boolean) */
		persist?: boolean;
		/** [Config Option] (Function) */
		serialize?: any;
		/** [Config Option] (String) */
		sortDir?: string;
		/** [Config Option] (Function/String) */
		sortType?: any;
		/** [Config Option] (String/Object) */
		type?: any;
		/** [Config Option] (Boolean) */
		useNull?: boolean;
	}
}
declare module Ext.data.flash {
	export interface IBinaryXhr extends Ext.IBase {
		/** [Property] (number) */
		readyState?: number;
		/** [Property] (Array) */
		responseBytes?: any[];
		/** [Property] (number) */
		status?: number;
		/** [Property] (String) */
		statusText?: string;
		/** [Method] Abort this connection  */
		abort?(): void;
		/** [Method] As in XMLHttpRequest  */
		getAllResponseHeaders?(): void;
		/** [Method] As in XMLHttpRequest  
		* @param header Object 
		*/
		getResponseHeader?( header?:any ): void;
		/** [Method] As in XMLHttpRequest  */
		onreadystatechange?(): void;
		/** [Method] As in XMLHttpRequest  
		* @param method Object 
		* @param url Object 
		* @param async Object 
		* @param user Object 
		* @param password Object 
		*/
		open?( method?:any, url?:any, async?:any, user?:any, password?:any ): void;
		/** [Method] As in XMLHttpRequest  
		* @param mimeType Object 
		*/
		overrideMimeType?( mimeType?:any ): void;
		/** [Method] Initiate the request  
		* @param body Array an array of byte values to send. 
		*/
		send?( body?:any[] ): void;
		/** [Method] As in XMLHttpRequest  
		* @param header Object 
		* @param value Object 
		*/
		setRequestHeader?( header?:any, value?:any ): void;
	}
}
declare module Ext.data {
	export interface IGroup extends Ext.util.IObservable {
	}
}
declare module Ext.data {
	export interface IIdGenerator extends Ext.IBase {
		/** [Config Option] (String) */
		id?: string;
		/** [Property] (Boolean) */
		isGenerator?: boolean;
		/** [Method] Generates and returns the next id  
		* @returns String The next id. 
		*/
		generate?(): string;
	}
	export class IdGenerator {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Returns the IdGenerator given its config description  
		* @param config String/Object If this parameter is an IdGenerator instance, it is simply returned. If this is a string, it is first used as an id for lookup and then, if there is no match, as a type to create a new instance. This parameter can also be a config object that contains a type property (among others) that are used to create and configure the instance. 
		*/
		static get( config?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface IJsonP extends Ext.IBase {
	}
	export class JsonP {
		/** [Property] (String) */
		static callbackKey: string;
		/** [Property] (Boolean) */
		static disableCaching: boolean;
		/** [Property] (String) */
		static disableCachingParam: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Number) */
		static timeout: number;
		/** [Method] Abort a request  
		* @param request Object/String The request to abort 
		*/
		static abort( request?:any ): void;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Makes a JSONP request  
		* @param options Object An object which may contain the following properties. Note that options will take priority over any defaults that are specified in the class.  url : String The URL to request. params : Object (Optional)An object containing a series of key value pairs that will be sent along with the request. timeout : Number (Optional) See timeout callbackKey : String (Optional) See callbackKey callbackName : String (Optional) The function name to use for this request. By default this name will be auto-generated: Ext.data.JsonP.callback1, Ext.data.JsonP.callback2, etc. Setting this option to "my_name" will force the function name to be Ext.data.JsonP.my_name. Use this if you want deterministic behavior, but be careful - the callbackName should be different in each JsonP request that you make. disableCaching : Boolean (Optional) See disableCaching disableCachingParam : String (Optional) See disableCachingParam success : Function (Optional) A function to execute if the request succeeds. failure : Function (Optional) A function to execute if the request fails. callback : Function (Optional) A function to execute when the request completes, whether it is a success or failure. scope : Object (Optional)The scope in which to execute the callbacks: The "this" object for the callback function. Defaults to the browser window.  
		* @returns Object request An object containing the request details. 
		*/
		static request( options?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data {
	export interface IJsonPStore extends Ext.data.IStore {
	}
}
declare module Ext.data {
	export interface IJsonStore extends Ext.data.IStore {
	}
}
declare module Ext.data {
	export interface IModel extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Object[]) */
		associations?: any[];
		/** [Config Option] (String/Object/String[]/Object[]) */
		belongsTo?: any;
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (String) */
		defaultProxyType?: string;
		/** [Config Option] (Object[]/String[]) */
		fields?: any;
		/** [Config Option] (String/Object/String[]/Object[]) */
		hasMany?: any;
		/** [Config Option] (String/Object/Ext.data.Field) */
		idProperty?: any;
		/** [Config Option] (String/Object) */
		idgen?: any;
		/** [Config Option] (String) */
		persistenceProperty?: string;
		/** [Config Option] (String/Object/Ext.data.proxy.Proxy) */
		proxy?: any;
		/** [Config Option] (Object[]) */
		validations?: any[];
		/** [Property] (Boolean) */
		dirty?: boolean;
		/** [Property] (Boolean) */
		editing?: boolean;
		/** [Property] (Boolean) */
		isModel?: boolean;
		/** [Property] (Object) */
		modified?: any;
		/** [Property] (Boolean) */
		phantom?: boolean;
		/** [Property] (Object) */
		raw?: any;
		/** [Property] (Ext.data.Store) */
		store?: Ext.data.IStore;
		/** [Property] (Ext.data.Store[]) */
		stores?: Ext.data.IStore[];
		/** [Property] (String) */
		COMMIT?: string;
		/** [Property] (String) */
		EDIT?: string;
		/** [Property] (String) */
		REJECT?: string;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Begins an edit  */
		beginEdit?(): void;
		/** [Method] Cancels all changes made in the current edit operation  */
		cancelEdit?(): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Usually called by the Ext data Store which owns the model instance  
		* @param silent Boolean Pass true to skip notification of the owning store of the change. 
		* @param modifiedFieldNames String[] Array of field names changed during sync with server if known. Omit or pass null if unknown. An empty array means that it is known that no fields were modified by the server's response. Defaults to false. 
		*/
		commit?( silent?:boolean, modifiedFieldNames?:string[] ): void;
		/** [Method] Creates a copy clone of this Model instance  
		* @param id String A new id, defaults to the id of the instance being copied. See id. To generate a phantom instance with a new id use: var rec = record.copy(); // clone the record Ext.data.Model.id(rec); // automatically generate a unique sequential id 
		* @returns Ext.data.Model 
		*/
		copy?( id?:string ): Ext.data.IModel;
		/** [Method] Destroys the model using the configured proxy  
		* @param options Object Options to pass to the proxy. Config object for Ext.data.Operation. 
		* @returns Ext.data.Model The Model instance 
		*/
		destroy?( options?:any ): Ext.data.IModel;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Ends an edit  
		* @param silent Boolean True to not notify the store of the change 
		* @param modifiedFieldNames String[] Array of field names changed during edit. 
		*/
		endEdit?( silent?:boolean, modifiedFieldNames?:string[] ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the value of the given field 
		* @param fieldName String The field to fetch the value for 
		* @returns Object The value 
		*/
		get?( fieldName?:string ): any;
		/** [Method] Gets all of the data from this Models loaded associations  
		* @returns Object The nested data set for the Model's loaded associations 
		*/
		getAssociatedData?(): any;
		/** [Method] Gets a hash of only the fields that have been modified since this Model was created or commited  
		* @returns Object 
		*/
		getChanges?(): any;
		/** [Method] Gets all values for each field in this model and returns an object containing the current data  
		* @param includeAssociated Boolean True to also include associated data. Defaults to false. 
		* @returns Object An object hash containing all the values in this model 
		*/
		getData?( includeAssociated?:boolean ): any;
		/** [Method] Returns the unique ID allocated to this model instance as defined by idProperty  
		* @returns Number/String The id 
		*/
		getId?(): any;
		/** [Method] Returns the configured Proxy for this Model  
		* @returns Ext.data.proxy.Proxy The proxy 
		*/
		getProxy?(): Ext.data.proxy.IProxy;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Returns true if the passed field name has been modified since the load or last commit  
		* @param fieldName String Ext.data.Field.name 
		* @returns Boolean 
		*/
		isModified?( fieldName?:string ): boolean;
		/** [Method] Checks if the model is valid  
		* @returns Boolean True if the model is valid. 
		*/
		isValid?(): boolean;
		/** [Method] Tells this model instance that it has been added to a store  
		* @param store Ext.data.Store The store to which this model has been added. 
		*/
		join?( store?:Ext.data.IStore ): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Usually called by the Ext data Store to which this model instance has been joined  
		* @param silent Boolean True to skip notification of the owning store of the change. Defaults to false. 
		*/
		reject?( silent?:boolean ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Saves the model instance using the configured proxy  
		* @param options Object Options to pass to the proxy. Config object for Ext.data.Operation. 
		* @returns Ext.data.Model The Model instance 
		*/
		save?( options?:any ): Ext.data.IModel;
		/** [Method] Sets the given field to the given value marks the instance as dirty 
		* @param fieldName String/Object The field to set, or an object containing key/value pairs 
		* @param newValue Object The value to set 
		* @returns String[] The array of modified field names or null if nothing was modified. 
		*/
		set?( fieldName?:any, newValue?:any ): string[];
		/** [Method] Marks this Record as dirty  */
		setDirty?(): void;
		/** [Method] Sets the model instance s id field to the given id  
		* @param id Number/String The new id 
		*/
		setId?( id?:any ): void;
		/** [Method] Sets the Proxy to use for this model  
		* @param proxy String/Object/Ext.data.proxy.Proxy The proxy 
		* @returns Ext.data.proxy.Proxy 
		*/
		setProxy?( proxy?:any ): Ext.data.proxy.IProxy;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Tells this model instance that it has been removed from the store  
		* @param store Ext.data.Store The store from which this model has been removed. 
		*/
		unjoin?( store?:Ext.data.IStore ): void;
		/** [Method] Validates the current data against all of its configured validations  
		* @returns Ext.data.Errors The errors object 
		*/
		validate?(): Ext.data.IErrors;
	}
	export class Model {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Returns an Array of Field definitions which define this Model s structure Fields are sorted upon Model class definit  
		* @returns Ext.data.Field[] The defined Fields for this Model. 
		*/
		static getFields(): Ext.data.IField[];
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Returns the configured Proxy for this Model 
		* @returns Ext.data.proxy.Proxy The proxy 
		*/
		static getProxy(): Ext.data.proxy.IProxy;
		/** [Method] Generates a sequential id  
		* @param rec Ext.data.Model The record being created. The record does not exist, it's a phantom. 
		* @returns String auto-generated string id, "ext-record-i++"; 
		*/
		static id( rec?:Ext.data.IModel ): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Asynchronously loads a model instance by id  
		* @param id Number/String The id of the model to load 
		* @param config Object config object containing success, failure and callback functions, plus optional scope 
		*/
		static load( id?:any, config?:any ): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Apply a new set of field and or property definitions to the existing model  
		* @param fields Object 
		* @param idProperty Object 
		* @param clientIdProperty Object 
		*/
		static setFields( fields?:any, idProperty?:any, clientIdProperty?:any ): void;
		/** [Method] Sets the Proxy to use for this model  
		* @param proxy String/Object/Ext.data.proxy.Proxy The proxy 
		* @returns Ext.data.proxy.Proxy 
		*/
		static setProxy( proxy?:any ): Ext.data.proxy.IProxy;
	}
}
declare module Ext.data {
	export interface IRecord extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Object[]) */
		associations?: any[];
		/** [Config Option] (String/Object/String[]/Object[]) */
		belongsTo?: any;
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (String) */
		defaultProxyType?: string;
		/** [Config Option] (Object[]/String[]) */
		fields?: any;
		/** [Config Option] (String/Object/String[]/Object[]) */
		hasMany?: any;
		/** [Config Option] (String/Object/Ext.data.Field) */
		idProperty?: any;
		/** [Config Option] (String/Object) */
		idgen?: any;
		/** [Config Option] (String) */
		persistenceProperty?: string;
		/** [Config Option] (String/Object/Ext.data.proxy.Proxy) */
		proxy?: any;
		/** [Config Option] (Object[]) */
		validations?: any[];
		/** [Property] (Boolean) */
		dirty?: boolean;
		/** [Property] (Boolean) */
		editing?: boolean;
		/** [Property] (Boolean) */
		isModel?: boolean;
		/** [Property] (Object) */
		modified?: any;
		/** [Property] (Boolean) */
		phantom?: boolean;
		/** [Property] (Object) */
		raw?: any;
		/** [Property] (Ext.data.Store) */
		store?: Ext.data.IStore;
		/** [Property] (Ext.data.Store[]) */
		stores?: Ext.data.IStore[];
		/** [Property] (String) */
		COMMIT?: string;
		/** [Property] (String) */
		EDIT?: string;
		/** [Property] (String) */
		REJECT?: string;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Begins an edit  */
		beginEdit?(): void;
		/** [Method] Cancels all changes made in the current edit operation  */
		cancelEdit?(): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Usually called by the Ext data Store which owns the model instance  
		* @param silent Boolean Pass true to skip notification of the owning store of the change. 
		* @param modifiedFieldNames String[] Array of field names changed during sync with server if known. Omit or pass null if unknown. An empty array means that it is known that no fields were modified by the server's response. Defaults to false. 
		*/
		commit?( silent?:boolean, modifiedFieldNames?:string[] ): void;
		/** [Method] Creates a copy clone of this Model instance  
		* @param id String A new id, defaults to the id of the instance being copied. See id. To generate a phantom instance with a new id use: var rec = record.copy(); // clone the record Ext.data.Model.id(rec); // automatically generate a unique sequential id 
		* @returns Ext.data.Model 
		*/
		copy?( id?:string ): Ext.data.IModel;
		/** [Method] Destroys the model using the configured proxy  
		* @param options Object Options to pass to the proxy. Config object for Ext.data.Operation. 
		* @returns Ext.data.Model The Model instance 
		*/
		destroy?( options?:any ): Ext.data.IModel;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Ends an edit  
		* @param silent Boolean True to not notify the store of the change 
		* @param modifiedFieldNames String[] Array of field names changed during edit. 
		*/
		endEdit?( silent?:boolean, modifiedFieldNames?:string[] ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the value of the given field 
		* @param fieldName String The field to fetch the value for 
		* @returns Object The value 
		*/
		get?( fieldName?:string ): any;
		/** [Method] Gets all of the data from this Models loaded associations  
		* @returns Object The nested data set for the Model's loaded associations 
		*/
		getAssociatedData?(): any;
		/** [Method] Gets a hash of only the fields that have been modified since this Model was created or commited  
		* @returns Object 
		*/
		getChanges?(): any;
		/** [Method] Gets all values for each field in this model and returns an object containing the current data  
		* @param includeAssociated Boolean True to also include associated data. Defaults to false. 
		* @returns Object An object hash containing all the values in this model 
		*/
		getData?( includeAssociated?:boolean ): any;
		/** [Method] Returns the unique ID allocated to this model instance as defined by idProperty  
		* @returns Number/String The id 
		*/
		getId?(): any;
		/** [Method] Returns the configured Proxy for this Model  
		* @returns Ext.data.proxy.Proxy The proxy 
		*/
		getProxy?(): Ext.data.proxy.IProxy;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Returns true if the passed field name has been modified since the load or last commit  
		* @param fieldName String Ext.data.Field.name 
		* @returns Boolean 
		*/
		isModified?( fieldName?:string ): boolean;
		/** [Method] Checks if the model is valid  
		* @returns Boolean True if the model is valid. 
		*/
		isValid?(): boolean;
		/** [Method] Tells this model instance that it has been added to a store  
		* @param store Ext.data.Store The store to which this model has been added. 
		*/
		join?( store?:Ext.data.IStore ): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Usually called by the Ext data Store to which this model instance has been joined  
		* @param silent Boolean True to skip notification of the owning store of the change. Defaults to false. 
		*/
		reject?( silent?:boolean ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Saves the model instance using the configured proxy  
		* @param options Object Options to pass to the proxy. Config object for Ext.data.Operation. 
		* @returns Ext.data.Model The Model instance 
		*/
		save?( options?:any ): Ext.data.IModel;
		/** [Method] Sets the given field to the given value marks the instance as dirty 
		* @param fieldName String/Object The field to set, or an object containing key/value pairs 
		* @param newValue Object The value to set 
		* @returns String[] The array of modified field names or null if nothing was modified. 
		*/
		set?( fieldName?:any, newValue?:any ): string[];
		/** [Method] Marks this Record as dirty  */
		setDirty?(): void;
		/** [Method] Sets the model instance s id field to the given id  
		* @param id Number/String The new id 
		*/
		setId?( id?:any ): void;
		/** [Method] Sets the Proxy to use for this model  
		* @param proxy String/Object/Ext.data.proxy.Proxy The proxy 
		* @returns Ext.data.proxy.Proxy 
		*/
		setProxy?( proxy?:any ): Ext.data.proxy.IProxy;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Tells this model instance that it has been removed from the store  
		* @param store Ext.data.Store The store from which this model has been removed. 
		*/
		unjoin?( store?:Ext.data.IStore ): void;
		/** [Method] Validates the current data against all of its configured validations  
		* @returns Ext.data.Errors The errors object 
		*/
		validate?(): Ext.data.IErrors;
	}
	export class Record {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Returns an Array of Field definitions which define this Model s structure Fields are sorted upon Model class definit  
		* @returns Ext.data.Field[] The defined Fields for this Model. 
		*/
		static getFields(): Ext.data.IField[];
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Returns the configured Proxy for this Model 
		* @returns Ext.data.proxy.Proxy The proxy 
		*/
		static getProxy(): Ext.data.proxy.IProxy;
		/** [Method] Generates a sequential id  
		* @param rec Ext.data.Model The record being created. The record does not exist, it's a phantom. 
		* @returns String auto-generated string id, "ext-record-i++"; 
		*/
		static id( rec?:Ext.data.IModel ): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Asynchronously loads a model instance by id  
		* @param id Number/String The id of the model to load 
		* @param config Object config object containing success, failure and callback functions, plus optional scope 
		*/
		static load( id?:any, config?:any ): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Apply a new set of field and or property definitions to the existing model  
		* @param fields Object 
		* @param idProperty Object 
		* @param clientIdProperty Object 
		*/
		static setFields( fields?:any, idProperty?:any, clientIdProperty?:any ): void;
		/** [Method] Sets the Proxy to use for this model  
		* @param proxy String/Object/Ext.data.proxy.Proxy The proxy 
		* @returns Ext.data.proxy.Proxy 
		*/
		static setProxy( proxy?:any ): Ext.data.proxy.IProxy;
	}
}
declare module Ext.data {
	export interface INodeInterface extends Ext.IBase {
		/** [Config Option] (Boolean) */
		allowDrag?: boolean;
		/** [Config Option] (Boolean) */
		allowDrop?: boolean;
		/** [Config Option] (Boolean) */
		checked?: boolean;
		/** [Config Option] (Ext.data.NodeInterface[]) */
		children?: Ext.data.INodeInterface[];
		/** [Config Option] (String) */
		cls?: string;
		/** [Config Option] (Number) */
		depth?: number;
		/** [Config Option] (Boolean) */
		expandable?: boolean;
		/** [Config Option] (Boolean) */
		expanded?: boolean;
		/** [Config Option] (String) */
		href?: string;
		/** [Config Option] (String) */
		hrefTarget?: string;
		/** [Config Option] (String) */
		icon?: string;
		/** [Config Option] (String) */
		iconCls?: string;
		/** [Config Option] (Number) */
		index?: number;
		/** [Config Option] (Boolean) */
		isFirst?: boolean;
		/** [Config Option] (Boolean) */
		isLast?: boolean;
		/** [Config Option] (Boolean) */
		leaf?: boolean;
		/** [Config Option] (Boolean) */
		loaded?: boolean;
		/** [Config Option] (Boolean) */
		loading?: boolean;
		/** [Config Option] (String) */
		parentId?: string;
		/** [Config Option] (Number) */
		qshowDelay?: number;
		/** [Config Option] (String) */
		qtip?: string;
		/** [Config Option] (String) */
		qtitle?: string;
		/** [Config Option] (Boolean) */
		root?: boolean;
		/** [Config Option] (String) */
		text?: string;
		/** [Property] (Ext.data.NodeInterface[]) */
		childNodes?: Ext.data.INodeInterface[];
		/** [Property] (Ext.data.NodeInterface) */
		firstChild?: Ext.data.INodeInterface;
		/** [Property] (Boolean) */
		isNode?: boolean;
		/** [Property] (Ext.data.NodeInterface) */
		lastChild?: Ext.data.INodeInterface;
		/** [Property] (Ext.data.NodeInterface) */
		nextSibling?: Ext.data.INodeInterface;
		/** [Property] (Ext.data.NodeInterface) */
		parentNode?: Ext.data.INodeInterface;
		/** [Property] (Ext.data.NodeInterface) */
		previousSibling?: Ext.data.INodeInterface;
		/** [Method] Inserts node s as the last child node of this node  
		* @param node Ext.data.NodeInterface/Ext.data.NodeInterface[]/Object The node or Array of nodes to append 
		* @param suppressEvents Boolean True to suppress firering of events. 
		* @param commit Boolean 
		* @returns Ext.data.NodeInterface The appended node if single append, or null if an array was passed 
		*/
		appendChild?( node?:any, suppressEvents?:boolean, commit?:boolean ): Ext.data.INodeInterface;
		/** [Method] Bubbles up the tree from this node calling the specified function with each node  
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node. 
		* @param args Array The args to call the function with. Defaults to passing the current Node. 
		*/
		bubble?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Cascades down the tree from this node calling the specified function with each node  
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node. 
		* @param args Array The args to call the function with. Defaults to passing the current Node. 
		*/
		cascadeBy?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Collapse this node  
		* @param recursive Boolean True to recursively collapse all the children 
		* @param callback Function The function to execute once the collapse completes 
		* @param scope Object The scope to run the callback in 
		*/
		collapse?( recursive?:boolean, callback?:any, scope?:any ): void;
		/** [Method] Collapse all the children of this node  
		* @param recursive Function True to recursively collapse all the children 
		* @param callback Function The function to execute once all the children are collapsed 
		* @param scope Object The scope to run the callback in 
		*/
		collapseChildren?( recursive?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns true if this node is an ancestor at any point of the passed node  
		* @param node Ext.data.NodeInterface 
		* @returns Boolean 
		*/
		contains?( node?:Ext.data.INodeInterface ): boolean;
		/** [Method] Creates a copy clone of this Node  
		* @param id String A new id, defaults to this Node's id. 
		* @param deep Boolean True to recursively copy all child Nodes into the new Node. False to copy without child Nodes. 
		* @returns Ext.data.NodeInterface A copy of this Node. 
		*/
		copy?( id?:string, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Ensures that the passed object is an instance of a Record with the NodeInterface applied 
		* @param node Object 
		* @returns Ext.data.NodeInterface 
		*/
		createNode?( node?:any ): Ext.data.INodeInterface;
		/** [Method] Destroys the node  
		* @param silent Object 
		*/
		destroy?( silent?:any ): void;
		/** [Method] Interates the child nodes of this node calling the specified function with each node  
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node in iteration. 
		* @param args Array The args to call the function with. Defaults to passing the current Node. 
		*/
		eachChild?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Expand this node  
		* @param recursive Boolean True to recursively expand all the children 
		* @param callback Function The function to execute once the expand completes 
		* @param scope Object The scope to run the callback in 
		*/
		expand?( recursive?:boolean, callback?:any, scope?:any ): void;
		/** [Method] Expand all the children of this node  
		* @param recursive Boolean True to recursively expand all the children 
		* @param callback Function The function to execute once all the children are expanded 
		* @param scope Object The scope to run the callback in 
		*/
		expandChildren?( recursive?:boolean, callback?:any, scope?:any ): void;
		/** [Method] Finds the first child that has the attribute with the specified value  
		* @param attribute String The attribute name 
		* @param value Object The value to search for 
		* @param deep Boolean True to search through nodes deeper than the immediate children 
		* @returns Ext.data.NodeInterface The found child or null if none was found 
		*/
		findChild?( attribute?:string, value?:any, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Finds the first child by a custom function  
		* @param fn Function A function which must return true if the passed Node is the required Node. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Node being tested. 
		* @param deep Boolean True to search through nodes deeper than the immediate children 
		* @returns Ext.data.NodeInterface The found child or null if none was found 
		*/
		findChildBy?( fn?:any, scope?:any, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Returns the child node at the specified index  
		* @param index Number 
		* @returns Ext.data.NodeInterface 
		*/
		getChildAt?( index?:number ): Ext.data.INodeInterface;
		/** [Method] Returns depth of this node the root node has a depth of 0  
		* @returns Number 
		*/
		getDepth?(): number;
		/** [Method] Returns the tree this node is in  
		* @returns Ext.tree.Panel The tree panel which owns this node. 
		*/
		getOwnerTree?(): Ext.tree.IPanel;
		/** [Method] Gets the hierarchical path from the root of the current node  
		* @param field String The field to construct the path from. Defaults to the model idProperty. 
		* @param separator String A separator to use. 
		* @returns String The node path 
		*/
		getPath?( field?:string, separator?:string ): string;
		/** [Method] Returns true if this node has one or more child nodes else false  
		* @returns Boolean 
		*/
		hasChildNodes?(): boolean;
		/** [Method] Returns the index of a child node 
		* @param node Ext.data.NodeInterface 
		* @returns Number The index of the node or -1 if it was not found 
		*/
		indexOf?( node?:Ext.data.INodeInterface ): number;
		/** [Method] Returns the index of a child node that matches the id 
		* @param id String The id of the node to find 
		* @returns Number The index of the node or -1 if it was not found 
		*/
		indexOfId?( id?:string ): number;
		/** [Method] Inserts the first node before the second node in this nodes childNodes collection  
		* @param node Ext.data.NodeInterface The node to insert 
		* @param refNode Ext.data.NodeInterface The node to insert before (if null the node is appended) 
		* @returns Ext.data.NodeInterface The inserted node 
		*/
		insertBefore?( node?:Ext.data.INodeInterface, refNode?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Inserts a node into this node  
		* @param index Number The zero-based index to insert the node at 
		* @param node Ext.data.NodeInterface The node to insert 
		* @returns Ext.data.NodeInterface The node you just inserted 
		*/
		insertChild?( index?:number, node?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Returns true if the passed node is an ancestor at any point of this node  
		* @param node Ext.data.NodeInterface 
		* @returns Boolean 
		*/
		isAncestor?( node?:Ext.data.INodeInterface ): boolean;
		/** [Method] Returns true if this node has one or more child nodes or if the expandable node attribute is explicitly specified as  
		* @returns Boolean 
		*/
		isExpandable?(): boolean;
		/** [Method] Returns true if this node is expaned 
		* @returns Boolean 
		*/
		isExpanded?(): boolean;
		/** [Method] Returns true if this node is a leaf 
		* @returns Boolean 
		*/
		isLeaf?(): boolean;
		/** [Method] Returns true if this node is loaded 
		* @returns Boolean 
		*/
		isLoaded?(): boolean;
		/** [Method] Returns true if this node is loading 
		* @returns Boolean 
		*/
		isLoading?(): boolean;
		/** [Method] Returns true if this node is the root node 
		* @returns Boolean 
		*/
		isRoot?(): boolean;
		/** [Method] Returns true if this node is visible  
		* @returns Boolean 
		*/
		isVisible?(): boolean;
		/** [Method] Removes this node from its parent 
		* @param destroy Boolean True to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface this 
		*/
		remove?( destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Removes all child nodes from this node  
		* @param destroy Boolean True to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface this 
		*/
		removeAll?( destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Removes a child node from this node  
		* @param node Ext.data.NodeInterface The node to remove 
		* @param destroy Boolean True to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface The removed node 
		*/
		removeChild?( node?:Ext.data.INodeInterface, destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Replaces one child node in this node with another  
		* @param newChild Ext.data.NodeInterface The replacement node 
		* @param oldChild Ext.data.NodeInterface The node to replace 
		* @returns Ext.data.NodeInterface The replaced node 
		*/
		replaceChild?( newChild?:Ext.data.INodeInterface, oldChild?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Creates an object representation of this node including its children  */
		serialize?(): void;
		/** [Method] Sorts this nodes children using the supplied sort function  
		* @param fn Function A function which, when passed two Nodes, returns -1, 0 or 1 depending upon required sort order. 
		* @param recursive Boolean True to apply this sort recursively 
		* @param suppressEvent Boolean True to not fire a sort event. 
		*/
		sort?( fn?:any, recursive?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Updates general data of this node like isFirst isLast depth  
		* @param commit Boolean 
		* @param info Object The info to update. May contain any of the following 
		*/
		updateInfo?( commit?:boolean, info?:any ): void;
	}
	export class NodeInterface {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] This method allows you to decorate a Model s class to implement the NodeInterface  
		* @param modelClass Ext.Class/Ext.data.Model The Model class or an instance of the Model class you want to decorate the prototype of. 
		*/
		static decorate( modelClass?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface INodeStore extends Ext.data.IStore {
		/** [Config Option] (Ext.data.Model) */
		node?: Ext.data.IModel;
		/** [Config Option] (Boolean) */
		recursive?: boolean;
		/** [Config Option] (Boolean) */
		rootVisible?: boolean;
		/** [Config Option] (Ext.data.TreeStore) */
		treeStore?: Ext.data.ITreeStore;
		/** [Property] (Number) */
		isExpandingOrCollapsing?: number;
		/** [Property] (Boolean) */
		isNodeStore?: boolean;
		/** [Method] NodeStores are never buffered or paged  
		* @returns Number The total number of Model instances available via the Proxy. 0 returned if no value has been set via the reader. 
		*/
		getTotalCount?(): number;
	}
}
declare module Ext.data {
	export interface IOperation extends Ext.IBase {
		/** [Config Option] (String) */
		action?: string;
		/** [Config Option] (Ext.data.Batch) */
		batch?: Ext.data.IBatch;
		/** [Config Option] (Function) */
		callback?: any;
		/** [Config Option] (Ext.util.Filter[]) */
		filters?: Ext.util.IFilter[];
		/** [Config Option] (Ext.util.Grouper[]) */
		groupers?: Ext.util.IGrouper[];
		/** [Config Option] (Number) */
		limit?: number;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (Ext.util.Sorter[]) */
		sorters?: Ext.util.ISorter[];
		/** [Config Option] (Number) */
		start?: number;
		/** [Config Option] (Boolean) */
		synchronous?: boolean;
		/** [Property] (RegExp) */
		actionCommitRecordsRe?: RegExp;
		/** [Property] (RegExp) */
		actionSkipSyncRe?: RegExp;
		/** [Method] Checks whether this operation should cause writing to occur  
		* @returns Boolean Whether the operation should cause a write to occur. 
		*/
		allowWrite?(): boolean;
		/** [Method] This method is called to commit data to this instance s records given the records in the server response  
		* @param serverRecords Ext.data.Model[] An array of Ext.data.Model objects returned by the server. 
		*/
		commitRecords?( serverRecords?:Ext.data.IModel[] ): void;
		/** [Method] Returns the error string or object that was set using setException 
		* @returns String/Object The error object 
		*/
		getError?(): any;
		/** [Method] Returns the records associated with this operation  
		* @returns Ext.data.Model[] 
		*/
		getRecords?(): Ext.data.IModel[];
		/** [Method] Returns the ResultSet object if set by the Proxy 
		* @returns Ext.data.ResultSet The ResultSet object 
		*/
		getResultSet?(): Ext.data.IResultSet;
		/** [Method] Returns true if this Operation encountered an exception see also getError  
		* @returns Boolean True if there was an exception 
		*/
		hasException?(): boolean;
		/** [Method] Returns true if the Operation has been completed 
		* @returns Boolean True if the Operation is complete 
		*/
		isComplete?(): boolean;
		/** [Method] Returns true if the Operation has been started but has not yet completed  
		* @returns Boolean True if the Operation is currently running 
		*/
		isRunning?(): boolean;
		/** [Method] Returns true if the Operation has been started  
		* @returns Boolean True if the Operation has started 
		*/
		isStarted?(): boolean;
		/** [Method] Marks the Operation as completed  */
		setCompleted?(): void;
		/** [Method] Marks the Operation as having experienced an exception  
		* @param error String/Object error string/object 
		*/
		setException?( error?:any ): void;
		/** [Method] Marks the Operation as started  */
		setStarted?(): void;
		/** [Method] Marks the Operation as successful  */
		setSuccessful?(): void;
		/** [Method] Returns true if the Operation has completed and was successful 
		* @returns Boolean True if successful 
		*/
		wasSuccessful?(): boolean;
	}
}
declare module Ext.data {
	export interface IPageMap extends Ext.util.ILruCache {
		/** [Method] Maintain a generation counter so that the Store can reject incoming pages destined for the previous generation 
		* @param initial Object 
		* @returns Ext.util.HashMap this 
		*/
		clear?( initial?:any ): Ext.util.IHashMap;
		/** [Method] Returns the first record in this page map which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this PageMap. 
		* @returns Object The first record in this page map which returned true from the selection function, or null if none was found. 
		*/
		findBy?( fn?:any, scope?:any ): any;
		/** [Method] Returns the index in the whole dataset of the first record in this page map which elicits a true return value from th  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this PageMap. 
		* @returns Number The index first record in this page map which returned true from the selection function, or -1 if none was found. 
		*/
		findIndexBy?( fn?:any, scope?:any ): number;
		/** [Method] Gets the number of items in the hash  
		* @returns Number The number of items in the hash. 
		*/
		getCount?(): number;
		/** [Method] Remove an item from the hash  
		* @returns Boolean True if the item was successfully removed. 
		*/
		remove?(): boolean;
	}
}
declare module Ext.data.proxy {
	export interface IAjax extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		binary?: boolean;
		/** [Config Option] (Object) */
		headers?: any;
		/** [Property] (Object) */
		actionMethods?: any;
		/** [Method] Returns the HTTP method name for a given request  
		* @param request Ext.data.Request The request object 
		* @returns String The HTTP method to use (should be one of 'GET', 'POST', 'PUT' or 'DELETE') 
		*/
		getMethod?( request?:Ext.data.IRequest ): string;
	}
}
declare module Ext.data {
	export interface IHttpProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		binary?: boolean;
		/** [Config Option] (Object) */
		headers?: any;
		/** [Property] (Object) */
		actionMethods?: any;
		/** [Method] Returns the HTTP method name for a given request  
		* @param request Ext.data.Request The request object 
		* @returns String The HTTP method to use (should be one of 'GET', 'POST', 'PUT' or 'DELETE') 
		*/
		getMethod?( request?:Ext.data.IRequest ): string;
	}
}
declare module Ext.data {
	export interface IAjaxProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		binary?: boolean;
		/** [Config Option] (Object) */
		headers?: any;
		/** [Property] (Object) */
		actionMethods?: any;
		/** [Method] Returns the HTTP method name for a given request  
		* @param request Ext.data.Request The request object 
		* @returns String The HTTP method to use (should be one of 'GET', 'POST', 'PUT' or 'DELETE') 
		*/
		getMethod?( request?:Ext.data.IRequest ): string;
	}
}
declare module Ext.data.proxy {
	export interface IClient extends Ext.data.proxy.IProxy {
		/** [Property] (Boolean) */
		isSynchronous?: boolean;
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
	}
}
declare module Ext.data {
	export interface IClientProxy extends Ext.data.proxy.IProxy {
		/** [Property] (Boolean) */
		isSynchronous?: boolean;
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
	}
}
declare module Ext.data.proxy {
	export interface IDirect extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (Function/String) */
		directFn?: any;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String/String[]) */
		paramOrder?: any;
		/** [Config Option] (Boolean) */
		paramsAsHash?: boolean;
		/** [Method] inherit docs 
		* @returns String The url 
		*/
		buildUrl?(): string;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		doRequest?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IDirectProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (Function/String) */
		directFn?: any;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String/String[]) */
		paramOrder?: any;
		/** [Config Option] (Boolean) */
		paramsAsHash?: boolean;
		/** [Method] inherit docs 
		* @returns String The url 
		*/
		buildUrl?(): string;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		doRequest?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.proxy {
	export interface IJsonP extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		autoAppendParams?: boolean;
		/** [Config Option] (String) */
		callbackKey?: string;
		/** [Config Option] (String) */
		recordParam?: string;
		/** [Method] Aborts the current server request if one is currently running */
		abort?(): void;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object 
		* @returns String The url 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] Encodes an array of records into a value suitable to be added to the request params as the recordParam parameter  
		* @param records Ext.data.Model[] The records array 
		* @returns Array An array of record data objects 
		*/
		encodeRecords?( records?:Ext.data.IModel[] ): any[];
	}
}
declare module Ext.data {
	export interface IScriptTagProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		autoAppendParams?: boolean;
		/** [Config Option] (String) */
		callbackKey?: string;
		/** [Config Option] (String) */
		recordParam?: string;
		/** [Method] Aborts the current server request if one is currently running */
		abort?(): void;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object 
		* @returns String The url 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] Encodes an array of records into a value suitable to be added to the request params as the recordParam parameter  
		* @param records Ext.data.Model[] The records array 
		* @returns Array An array of record data objects 
		*/
		encodeRecords?( records?:Ext.data.IModel[] ): any[];
	}
}
declare module Ext.data.proxy {
	export interface ILocalStorage extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data {
	export interface ILocalStorageProxy extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data.proxy {
	export interface IMemory extends Ext.data.proxy.IClient {
		/** [Config Option] (Object) */
		data?: any;
		/** [Config Option] (Boolean) */
		enablePaging?: boolean;
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Reads data from the configured data object  
		* @param operation Ext.data.Operation The read Operation 
		* @param callback Function The callback to call when reading has completed 
		* @param scope Object The scope to call the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IMemoryProxy extends Ext.data.proxy.IClient {
		/** [Config Option] (Object) */
		data?: any;
		/** [Config Option] (Boolean) */
		enablePaging?: boolean;
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Reads data from the configured data object  
		* @param operation Ext.data.Operation The read Operation 
		* @param callback Function The callback to call when reading has completed 
		* @param scope Object The scope to call the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.proxy {
	export interface IProxy extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		batchOrder?: string;
		/** [Config Option] (String/Ext.data.Model) */
		model?: any;
		/** [Config Option] (Object/String/Ext.data.reader.Reader) */
		reader?: any;
		/** [Config Option] (Object/String/Ext.data.writer.Writer) */
		writer?: any;
		/** [Property] (Boolean) */
		isProxy?: boolean;
		/** [Property] (Boolean) */
		isSynchronous?: boolean;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs a batch of Operations in the order specified by batchOrder  
		* @param options Object Object containing one or more properties supported by the batch method: 
		* @returns Ext.data.Batch The newly created Batch 
		*/
		batch?( options?:any ): Ext.data.IBatch;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Performs the given create operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the model attached to this Proxy 
		* @returns Ext.data.Model The model 
		*/
		getModel?(): Ext.data.IModel;
		/** [Method] Returns the reader currently attached to this proxy instance 
		* @returns Ext.data.reader.Reader The Reader instance 
		*/
		getReader?(): Ext.data.reader.IReader;
		/** [Method] Returns the writer currently attached to this proxy instance 
		* @returns Ext.data.writer.Writer The Writer instance 
		*/
		getWriter?(): Ext.data.writer.IWriter;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs the given read operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Sets the model associated with this proxy  
		* @param model String/Ext.data.Model The new model. Can be either the model name string, or a reference to the model's constructor 
		* @param setOnStore Boolean Sets the new model on the associated Store, if one is present 
		*/
		setModel?( model?:any, setOnStore?:boolean ): void;
		/** [Method] Sets the Proxy s Reader by string config object or Reader instance 
		* @param reader String/Object/Ext.data.reader.Reader The new Reader, which can be either a type string, a configuration object or an Ext.data.reader.Reader instance 
		* @returns Ext.data.reader.Reader The attached Reader object 
		*/
		setReader?( reader?:any ): Ext.data.reader.IReader;
		/** [Method] Sets the Proxy s Writer by string config object or Writer instance 
		* @param writer String/Object/Ext.data.writer.Writer The new Writer, which can be either a type string, a configuration object or an Ext.data.writer.Writer instance 
		* @returns Ext.data.writer.Writer The attached Writer object 
		*/
		setWriter?( writer?:any ): Ext.data.writer.IWriter;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Performs the given update operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IDataProxy extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		batchOrder?: string;
		/** [Config Option] (String/Ext.data.Model) */
		model?: any;
		/** [Config Option] (Object/String/Ext.data.reader.Reader) */
		reader?: any;
		/** [Config Option] (Object/String/Ext.data.writer.Writer) */
		writer?: any;
		/** [Property] (Boolean) */
		isProxy?: boolean;
		/** [Property] (Boolean) */
		isSynchronous?: boolean;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs a batch of Operations in the order specified by batchOrder  
		* @param options Object Object containing one or more properties supported by the batch method: 
		* @returns Ext.data.Batch The newly created Batch 
		*/
		batch?( options?:any ): Ext.data.IBatch;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Performs the given create operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the model attached to this Proxy 
		* @returns Ext.data.Model The model 
		*/
		getModel?(): Ext.data.IModel;
		/** [Method] Returns the reader currently attached to this proxy instance 
		* @returns Ext.data.reader.Reader The Reader instance 
		*/
		getReader?(): Ext.data.reader.IReader;
		/** [Method] Returns the writer currently attached to this proxy instance 
		* @returns Ext.data.writer.Writer The Writer instance 
		*/
		getWriter?(): Ext.data.writer.IWriter;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs the given read operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Sets the model associated with this proxy  
		* @param model String/Ext.data.Model The new model. Can be either the model name string, or a reference to the model's constructor 
		* @param setOnStore Boolean Sets the new model on the associated Store, if one is present 
		*/
		setModel?( model?:any, setOnStore?:boolean ): void;
		/** [Method] Sets the Proxy s Reader by string config object or Reader instance 
		* @param reader String/Object/Ext.data.reader.Reader The new Reader, which can be either a type string, a configuration object or an Ext.data.reader.Reader instance 
		* @returns Ext.data.reader.Reader The attached Reader object 
		*/
		setReader?( reader?:any ): Ext.data.reader.IReader;
		/** [Method] Sets the Proxy s Writer by string config object or Writer instance 
		* @param writer String/Object/Ext.data.writer.Writer The new Writer, which can be either a type string, a configuration object or an Ext.data.writer.Writer instance 
		* @returns Ext.data.writer.Writer The attached Writer object 
		*/
		setWriter?( writer?:any ): Ext.data.writer.IWriter;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Performs the given update operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IProxy extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		batchOrder?: string;
		/** [Config Option] (String/Ext.data.Model) */
		model?: any;
		/** [Config Option] (Object/String/Ext.data.reader.Reader) */
		reader?: any;
		/** [Config Option] (Object/String/Ext.data.writer.Writer) */
		writer?: any;
		/** [Property] (Boolean) */
		isProxy?: boolean;
		/** [Property] (Boolean) */
		isSynchronous?: boolean;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs a batch of Operations in the order specified by batchOrder  
		* @param options Object Object containing one or more properties supported by the batch method: 
		* @returns Ext.data.Batch The newly created Batch 
		*/
		batch?( options?:any ): Ext.data.IBatch;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Performs the given create operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the model attached to this Proxy 
		* @returns Ext.data.Model The model 
		*/
		getModel?(): Ext.data.IModel;
		/** [Method] Returns the reader currently attached to this proxy instance 
		* @returns Ext.data.reader.Reader The Reader instance 
		*/
		getReader?(): Ext.data.reader.IReader;
		/** [Method] Returns the writer currently attached to this proxy instance 
		* @returns Ext.data.writer.Writer The Writer instance 
		*/
		getWriter?(): Ext.data.writer.IWriter;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs the given read operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Sets the model associated with this proxy  
		* @param model String/Ext.data.Model The new model. Can be either the model name string, or a reference to the model's constructor 
		* @param setOnStore Boolean Sets the new model on the associated Store, if one is present 
		*/
		setModel?( model?:any, setOnStore?:boolean ): void;
		/** [Method] Sets the Proxy s Reader by string config object or Reader instance 
		* @param reader String/Object/Ext.data.reader.Reader The new Reader, which can be either a type string, a configuration object or an Ext.data.reader.Reader instance 
		* @returns Ext.data.reader.Reader The attached Reader object 
		*/
		setReader?( reader?:any ): Ext.data.reader.IReader;
		/** [Method] Sets the Proxy s Writer by string config object or Writer instance 
		* @param writer String/Object/Ext.data.writer.Writer The new Writer, which can be either a type string, a configuration object or an Ext.data.writer.Writer instance 
		* @returns Ext.data.writer.Writer The attached Writer object 
		*/
		setWriter?( writer?:any ): Ext.data.writer.IWriter;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Performs the given update operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.proxy {
	export interface IRest extends Ext.data.proxy.IAjax {
		/** [Config Option] (Boolean) */
		appendId?: boolean;
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		format?: string;
		/** [Property] (Object) */
		actionMethods?: any;
	}
}
declare module Ext.data {
	export interface IRestProxy extends Ext.data.proxy.IAjax {
		/** [Config Option] (Boolean) */
		appendId?: boolean;
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		format?: string;
		/** [Property] (Object) */
		actionMethods?: any;
	}
}
declare module Ext.data.proxy {
	export interface IServer extends Ext.data.proxy.IProxy {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (String) */
		cacheString?: string;
		/** [Config Option] (String) */
		directionParam?: string;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String) */
		filterParam?: string;
		/** [Config Option] (String) */
		groupDirectionParam?: string;
		/** [Config Option] (String) */
		groupParam?: string;
		/** [Config Option] (String) */
		idParam?: string;
		/** [Config Option] (String) */
		limitParam?: string;
		/** [Config Option] (Boolean) */
		noCache?: boolean;
		/** [Config Option] (String) */
		pageParam?: string;
		/** [Config Option] (Boolean) */
		simpleGroupMode?: boolean;
		/** [Config Option] (Boolean) */
		simpleSortMode?: boolean;
		/** [Config Option] (String) */
		sortParam?: string;
		/** [Config Option] (String) */
		startParam?: string;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Optional callback function which can be used to clean up after a request has been completed  
		* @param request Ext.data.Request The Request object 
		* @param success Boolean True if the request was successful 
		*/
		afterRequest?( request?:Ext.data.IRequest, success?:boolean ): void;
		/** [Method] Creates an Request object from Operation  
		* @param operation Ext.data.Operation The operation to execute 
		* @returns Ext.data.Request The request object 
		*/
		buildRequest?( operation?:Ext.data.IOperation ): Ext.data.IRequest;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object 
		* @returns String The url 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] in a ServerProxy all four CRUD operations are executed in the same manner so we delegate to doRequest in each case */
		create?(): void;
		/** [Method] Performs the given destroy operation  */
		destroy?(): void;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Ext.data.Operation The Ext.data.Operation object 
		* @param callback Function The callback function to call when the Operation has completed 
		* @param scope Object The scope in which to execute the callback 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Encodes the array of Ext util Filter objects into a string to be sent in the request url  
		* @param filters Ext.util.Filter[] The array of Filter objects 
		* @returns String The encoded filters 
		*/
		encodeFilters?( filters?:Ext.util.IFilter[] ): string;
		/** [Method] Encodes the array of Ext util Sorter objects into a string to be sent in the request url  
		* @param sorters Ext.util.Sorter[] The array of Sorter objects 
		* @returns String The encoded sorters 
		*/
		encodeSorters?( sorters?:Ext.util.ISorter[] ): string;
		/** [Method] Performs the given read operation  */
		read?(): void;
		/** [Method] Sets a value in the underlying extraParams  
		* @param name String The key for the new value 
		* @param value Object The value 
		*/
		setExtraParam?( name?:string, value?:any ): void;
		/** [Method] Performs the given update operation  */
		update?(): void;
	}
}
declare module Ext.data {
	export interface IServerProxy extends Ext.data.proxy.IProxy {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (String) */
		cacheString?: string;
		/** [Config Option] (String) */
		directionParam?: string;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String) */
		filterParam?: string;
		/** [Config Option] (String) */
		groupDirectionParam?: string;
		/** [Config Option] (String) */
		groupParam?: string;
		/** [Config Option] (String) */
		idParam?: string;
		/** [Config Option] (String) */
		limitParam?: string;
		/** [Config Option] (Boolean) */
		noCache?: boolean;
		/** [Config Option] (String) */
		pageParam?: string;
		/** [Config Option] (Boolean) */
		simpleGroupMode?: boolean;
		/** [Config Option] (Boolean) */
		simpleSortMode?: boolean;
		/** [Config Option] (String) */
		sortParam?: string;
		/** [Config Option] (String) */
		startParam?: string;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Optional callback function which can be used to clean up after a request has been completed  
		* @param request Ext.data.Request The Request object 
		* @param success Boolean True if the request was successful 
		*/
		afterRequest?( request?:Ext.data.IRequest, success?:boolean ): void;
		/** [Method] Creates an Request object from Operation  
		* @param operation Ext.data.Operation The operation to execute 
		* @returns Ext.data.Request The request object 
		*/
		buildRequest?( operation?:Ext.data.IOperation ): Ext.data.IRequest;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object 
		* @returns String The url 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] in a ServerProxy all four CRUD operations are executed in the same manner so we delegate to doRequest in each case */
		create?(): void;
		/** [Method] Performs the given destroy operation  */
		destroy?(): void;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Ext.data.Operation The Ext.data.Operation object 
		* @param callback Function The callback function to call when the Operation has completed 
		* @param scope Object The scope in which to execute the callback 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Encodes the array of Ext util Filter objects into a string to be sent in the request url  
		* @param filters Ext.util.Filter[] The array of Filter objects 
		* @returns String The encoded filters 
		*/
		encodeFilters?( filters?:Ext.util.IFilter[] ): string;
		/** [Method] Encodes the array of Ext util Sorter objects into a string to be sent in the request url  
		* @param sorters Ext.util.Sorter[] The array of Sorter objects 
		* @returns String The encoded sorters 
		*/
		encodeSorters?( sorters?:Ext.util.ISorter[] ): string;
		/** [Method] Performs the given read operation  */
		read?(): void;
		/** [Method] Sets a value in the underlying extraParams  
		* @param name String The key for the new value 
		* @param value Object The value 
		*/
		setExtraParam?( name?:string, value?:any ): void;
		/** [Method] Performs the given update operation  */
		update?(): void;
	}
}
declare module Ext.data.proxy {
	export interface ISessionStorage extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data {
	export interface ISessionStorageProxy extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data.proxy {
	export interface IWebStorage extends Ext.data.proxy.IClient {
		/** [Config Option] (String) */
		id?: string;
		/** [Property] (Object) */
		cache?: any;
		/** [Method] Destroys all records stored in the proxy and removes all keys and values used to support the proxy from the storage o  */
		clear?(): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		create?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] inherit 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		destroy?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		read?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Saves the given record in the Proxy  
		* @param record Ext.data.Model The model instance 
		* @param id String The id to save the record under (defaults to the value of the record's getId() function) 
		*/
		setRecord?( record?:Ext.data.IModel, id?:string ): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		update?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IWebStorageProxy extends Ext.data.proxy.IClient {
		/** [Config Option] (String) */
		id?: string;
		/** [Property] (Object) */
		cache?: any;
		/** [Method] Destroys all records stored in the proxy and removes all keys and values used to support the proxy from the storage o  */
		clear?(): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		create?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] inherit 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		destroy?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		read?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Saves the given record in the Proxy  
		* @param record Ext.data.Model The model instance 
		* @param id String The id to save the record under (defaults to the value of the record's getId() function) 
		*/
		setRecord?( record?:Ext.data.IModel, id?:string ): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		update?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.reader {
	export interface IArray extends Ext.data.reader.IJson {
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
	}
}
declare module Ext.data {
	export interface IArrayReader extends Ext.data.reader.IJson {
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
	}
}
declare module Ext.data.reader {
	export interface IJson extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		metaProperty?: string;
		/** [Config Option] (String) */
		record?: string;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (Boolean) */
		useSimpleAccessors?: boolean;
		/** [Property] (Object) */
		jsonData?: any;
		/** [Method] inherit docs 
		* @param response Object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Reads a JSON object and returns a ResultSet  
		* @param data Object The raw JSON data 
		* @returns Ext.data.ResultSet A ResultSet containing model instances and meta data about the results 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
	}
}
declare module Ext.data {
	export interface IJsonReader extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		metaProperty?: string;
		/** [Config Option] (String) */
		record?: string;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (Boolean) */
		useSimpleAccessors?: boolean;
		/** [Property] (Object) */
		jsonData?: any;
		/** [Method] inherit docs 
		* @param response Object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Reads a JSON object and returns a ResultSet  
		* @param data Object The raw JSON data 
		* @returns Ext.data.ResultSet A ResultSet containing model instances and meta data about the results 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
	}
}
declare module Ext.data.reader {
	export interface IReader extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Boolean) */
		implicitIncludes?: boolean;
		/** [Config Option] (String) */
		messageProperty?: string;
		/** [Config Option] (Boolean) */
		readRecordsOnFailure?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Property] (Object) */
		metaData?: any;
		/** [Property] (Object) */
		rawData?: any;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Takes a raw response object as passed to the read method and returns the useful data segment from it  
		* @param response Object The response object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Reads the given response object  
		* @param response Object The response object. This may be either an XMLHttpRequest object or a plain JS object 
		* @returns Ext.data.ResultSet The parsed or default ResultSet object 
		*/
		read?( response?:any ): Ext.data.IResultSet;
		/** [Method] Abstracts common functionality used by all Reader subclasses  
		* @param data Object The raw data object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IReader extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Boolean) */
		implicitIncludes?: boolean;
		/** [Config Option] (String) */
		messageProperty?: string;
		/** [Config Option] (Boolean) */
		readRecordsOnFailure?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Property] (Object) */
		metaData?: any;
		/** [Property] (Object) */
		rawData?: any;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Takes a raw response object as passed to the read method and returns the useful data segment from it  
		* @param response Object The response object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Reads the given response object  
		* @param response Object The response object. This may be either an XMLHttpRequest object or a plain JS object 
		* @returns Ext.data.ResultSet The parsed or default ResultSet object 
		*/
		read?( response?:any ): Ext.data.IResultSet;
		/** [Method] Abstracts common functionality used by all Reader subclasses  
		* @param data Object The raw data object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IDataReader extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Boolean) */
		implicitIncludes?: boolean;
		/** [Config Option] (String) */
		messageProperty?: string;
		/** [Config Option] (Boolean) */
		readRecordsOnFailure?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Property] (Object) */
		metaData?: any;
		/** [Property] (Object) */
		rawData?: any;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Takes a raw response object as passed to the read method and returns the useful data segment from it  
		* @param response Object The response object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Reads the given response object  
		* @param response Object The response object. This may be either an XMLHttpRequest object or a plain JS object 
		* @returns Ext.data.ResultSet The parsed or default ResultSet object 
		*/
		read?( response?:any ): Ext.data.IResultSet;
		/** [Method] Abstracts common functionality used by all Reader subclasses  
		* @param data Object The raw data object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.data.reader {
	export interface IXml extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		namespace?: string;
		/** [Config Option] (String) */
		record?: string;
		/** [Property] (Object) */
		xmlData?: any;
		/** [Method] Normalizes the data object  
		* @param data Object The raw data object 
		* @returns Object The documentElement property of the data object if present, or the same object if not. 
		*/
		getData?( data?:any ): any;
		/** [Method] inherit docs 
		* @param response Object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Parses an XML document and returns a ResultSet containing the model instances  
		* @param doc Object Parsed XML document 
		* @returns Ext.data.ResultSet The parsed result set 
		*/
		readRecords?( doc?:any ): Ext.data.IResultSet;
	}
}
declare module Ext.data {
	export interface IXmlReader extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		namespace?: string;
		/** [Config Option] (String) */
		record?: string;
		/** [Property] (Object) */
		xmlData?: any;
		/** [Method] Normalizes the data object  
		* @param data Object The raw data object 
		* @returns Object The documentElement property of the data object if present, or the same object if not. 
		*/
		getData?( data?:any ): any;
		/** [Method] inherit docs 
		* @param response Object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		getResponseData?( response?:any ): Ext.data.IResultSet;
		/** [Method] Parses an XML document and returns a ResultSet containing the model instances  
		* @param doc Object Parsed XML document 
		* @returns Ext.data.ResultSet The parsed result set 
		*/
		readRecords?( doc?:any ): Ext.data.IResultSet;
	}
}
declare module Ext.data {
	export interface IRequest extends Ext.IBase {
		/** [Config Option] (String) */
		action?: string;
		/** [Config Option] (String) */
		method?: string;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (String) */
		url?: string;
	}
}
declare module Ext.data {
	export interface IResultSet extends Ext.IBase {
		/** [Config Option] (Number) */
		count?: number;
		/** [Config Option] (Boolean) */
		loaded?: boolean;
		/** [Config Option] (Ext.data.Model[]) */
		records?: Ext.data.IModel[];
		/** [Config Option] (Boolean) */
		success?: boolean;
		/** [Config Option] (Number) */
		total?: number;
		/** [Property] (Number) */
		totalRecords?: number;
	}
}
declare module Ext.data {
	export interface ISequentialIdGenerator extends Ext.data.IIdGenerator {
		/** [Config Option] (String) */
		prefix?: string;
		/** [Config Option] (Number) */
		seed?: number;
		/** [Method] Generates and returns the next id  
		* @returns String The next id. 
		*/
		generate?(): string;
	}
}
declare module Ext.data {
	export interface ISortTypes extends Ext.IBase {
	}
	export class SortTypes {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (RegExp) */
		static stripTagsRE: RegExp;
		/** [Method] Date sorting 
		* @param s Object The value being converted 
		* @returns Number The comparison value 
		*/
		static asDate( s?:any ): number;
		/** [Method] Float sorting 
		* @param s Object The value being converted 
		* @returns Number The comparison value 
		*/
		static asFloat( s?:any ): number;
		/** [Method] Integer sorting 
		* @param s Object The value being converted 
		* @returns Number The comparison value 
		*/
		static asInt( s?:any ): number;
		/** [Method] Strips all HTML tags to sort on text only 
		* @param s Object The value being converted 
		* @returns String The comparison value 
		*/
		static asText( s?:any ): string;
		/** [Method] Case insensitive string 
		* @param s Object The value being converted 
		* @returns String The comparison value 
		*/
		static asUCString( s?:any ): string;
		/** [Method] Strips all HTML tags to sort on text only  Case insensitive 
		* @param s Object The value being converted 
		* @returns String The comparison value 
		*/
		static asUCText( s?:any ): string;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Default sort that does nothing 
		* @param s Object The value being converted 
		* @returns Object The comparison value 
		*/
		static none( s?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data {
	export interface IStore extends Ext.data.IAbstractStore {
		/** [Config Option] (Boolean) */
		autoDestroy?: boolean;
		/** [Config Option] (Boolean) */
		buffered?: boolean;
		/** [Config Option] (Boolean) */
		clearOnPageLoad?: boolean;
		/** [Config Option] (Boolean) */
		clearRemovedOnLoad?: boolean;
		/** [Config Option] (Object[]/Ext.data.Model[]) */
		data?: any;
		/** [Config Option] (String) */
		groupDir?: string;
		/** [Config Option] (String) */
		groupField?: string;
		/** [Config Option] (Ext.util.MixedCollection) */
		groupers?: Ext.util.IMixedCollection;
		/** [Config Option] (Number) */
		leadingBufferZone?: number;
		/** [Config Option] (Number) */
		pageSize?: number;
		/** [Config Option] (String/Ext.data.proxy.Proxy/Object) */
		proxy?: any;
		/** [Config Option] (Number) */
		purgePageCount?: number;
		/** [Config Option] (Boolean) */
		remoteFilter?: boolean;
		/** [Config Option] (Boolean) */
		remoteGroup?: boolean;
		/** [Config Option] (Boolean) */
		remoteSort?: boolean;
		/** [Config Option] (Boolean) */
		sortOnFilter?: boolean;
		/** [Config Option] (Number) */
		trailingBufferZone?: number;
		/** [Property] (Number) */
		currentPage?: number;
		/** [Property] (Ext.util.MixedCollection) */
		snapshot?: Ext.util.IMixedCollection;
		/** [Method] Adds Model instance to the Store  
		* @param model Ext.data.Model[]/Ext.data.Model.../Object[]/Object... An array of Model instances or Model configuration objects, or variable number of Model instance or config arguments. 
		* @returns Ext.data.Model[] The model instances that were added 
		*/
		add?( model?:any ): Ext.data.IModel[];
		/** [Method] Adds a new Filter to this Store s filter set and by default applys the updated filter set to the Store s unfiltered 
		* @param filters Object[]/Ext.util.Filter[] The set of filters to add to the current filter set. 
		* @param applyFilters Boolean Pass as false to add the filter but not apply the updated filter set. 
		*/
		addFilter?( filters?:any, applyFilters?:boolean ): void;
		/** [Method] Local sort only Inserts the passed Record into the Store at the index where it should go based on the current sort 
		* @param record Ext.data.Record 
		*/
		addSorted?( record?:Ext.data.IRecord ): void;
		/** [Method] Runs the aggregate function for all the records in the store  
		* @param fn Function The function to execute. The function is called with a single parameter, an array of records for that group. 
		* @param scope Object The scope to execute the function in. Defaults to the store. 
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the group average being the value. The grouped parameter is only honored if the store has a groupField. 
		* @param args Array Any arguments to append to the function call 
		* @returns Object An object literal with the group names and their appropriate values. 
		*/
		aggregate?( fn?:any, scope?:any, grouped?:boolean, args?:any[] ): any;
		/** [Method] Gets the average value in the store  
		* @param field String The field in each record 
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the group average being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Object The average value, if no items exist, 0. 
		*/
		average?( field?:string, grouped?:boolean ): any;
		/** [Method] Reverts to a view of the Record cache with no filtering applied  
		* @param suppressEvent Boolean If true the filter is cleared silently. For a locally filtered Store, this means that the filter collection is cleared without firing the datachanged event. For a remotely filtered Store, this means that the filter collection is cleared, but the store is not reloaded from the server. 
		*/
		clearFilter?( suppressEvent?:boolean ): void;
		/** [Method] Clear any groupers in the store */
		clearGrouping?(): void;
		/** [Method] Collects unique values for a particular dataIndex from this store  
		* @param dataIndex String The property to collect 
		* @param allowNull Boolean Pass true to allow null, undefined or empty string values 
		* @param bypassFilter Boolean Pass true to collect from all records, even ones which are filtered. 
		* @returns Object[] An array of the unique values 
		*/
		collect?( dataIndex?:string, allowNull?:boolean, bypassFilter?:boolean ): any[];
		/** [Method] Commits all Records with outstanding changes  */
		commitChanges?(): void;
		/** [Method] Gets the count of items in the store  
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the count for each group being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Number the count 
		*/
		count?( grouped?:boolean ): number;
		/** [Method] Calls the specified function for each record in the store  
		* @param fn Function The function to call. The Record is passed as the first parameter. Returning false aborts and exits the iteration. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current record in the iteration. 
		*/
		each?( fn?:any, scope?:any ): void;
		/** [Method] Filters the loaded set of records by a given set of filters  
		* @param filters Object[]/Ext.util.Filter[]/String The set of filters to apply to the data. These are stored internally on the store, but the filtering itself is done on the Store's MixedCollection. See MixedCollection's filter method for filter syntax. Alternatively, pass in a property string. If no parameters are passed, the Store's existing filter set is applied. 
		* @param value String value to filter by (only if using a property string as the first argument) 
		*/
		filter?( filters?:any, value?:string ): void;
		/** [Method] Filters by a function  
		* @param fn Function The function to be called. It will be passed the following parameters: 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this Store. 
		*/
		filterBy?( fn?:any, scope?:any ): void;
		/** [Method] Finds the index of the first matching Record in this store by a specific field value  
		* @param fieldName String The name of the Record field to test. 
		* @param value String/RegExp Either a string that the field value should begin with, or a RegExp to test against the field. 
		* @param startIndex Number The index to start searching at 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning 
		* @param caseSensitive Boolean True for case sensitive comparison 
		* @param exactMatch Boolean True to force exact match (^ and $ characters added to the regex). 
		* @returns Number The matched index or -1 
		*/
		find?( fieldName?:string, value?:any, startIndex?:number, anyMatch?:boolean, caseSensitive?:boolean, exactMatch?:boolean ): number;
		/** [Method] Find the index of the first matching Record in this Store by a function  
		* @param fn Function The function to be called. It will be passed the following parameters: 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this Store. 
		* @param startIndex Number The index to start searching at 
		* @returns Number The matched index or -1 
		*/
		findBy?( fn?:any, scope?:any, startIndex?:number ): number;
		/** [Method] Finds the index of the first matching Record in this store by a specific field value  
		* @param fieldName String The name of the Record field to test. 
		* @param value Object The value to match the field against. 
		* @param startIndex Number The index to start searching at 
		* @returns Number The matched index or -1 
		*/
		findExact?( fieldName?:string, value?:any, startIndex?:number ): number;
		/** [Method] Finds the first matching Record in this store by a specific field value  
		* @param fieldName String The name of the Record field to test. 
		* @param value String/RegExp Either a string that the field value should begin with, or a RegExp to test against the field. 
		* @param startIndex Number The index to start searching at 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning 
		* @param caseSensitive Boolean True for case sensitive comparison 
		* @param exactMatch Boolean True to force exact match (^ and $ characters added to the regex). 
		* @returns Ext.data.Model The matched record or null 
		*/
		findRecord?( fieldName?:string, value?:any, startIndex?:number, anyMatch?:boolean, caseSensitive?:boolean, exactMatch?:boolean ): Ext.data.IModel;
		/** [Method] Convenience function for getting the first model instance in the store  
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the first record being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Ext.data.Model/undefined The first model instance in the store, or undefined 
		*/
		first?( grouped?:boolean ): any;
		/** [Method] Get the Record at the specified index  
		* @param index Number The index of the Record to find. 
		* @returns Ext.data.Model The Record at the passed index. Returns undefined if not found. 
		*/
		getAt?( index?:number ): Ext.data.IModel;
		/** [Method] Get the Record with the specified id  
		* @param id Mixed The id of the Record to find. 
		* @returns Ext.data.Model The Record with the passed id. Returns null if not found. 
		*/
		getById?( id?:any ): Ext.data.IModel;
		/** [Method] Gets the number of records in store  
		* @returns Number The number of Records in the Store. 
		*/
		getCount?(): number;
		/** [Method] Returns the string to group on for a given model instance  
		* @param instance Ext.data.Model The model instance 
		* @returns String The string to compare when forming groups 
		*/
		getGroupString?( instance?:Ext.data.IModel ): string;
		/** [Method] Returns an array containing the result of applying grouping to the records in this store  
		* @param groupName String Pass in an optional groupName argument to access a specific group as defined by getGroupString. 
		* @returns Object/Object[] The grouped data 
		*/
		getGroups?( groupName?:string ): any;
		/** [Method] inherit docs 
		* @returns Ext.data.Model[] The Model instances 
		*/
		getNewRecords?(): Ext.data.IModel[];
		/** [Method] Determines the page from a record index 
		* @param index Number The record index 
		* @returns Number The page the record belongs to 
		*/
		getPageFromRecordIndex?( index?:number ): number;
		/** [Method] Gathers a range of Records between specified indices  
		* @param start Number The starting index. Defaults to zero for non buffered Stores. 
		* @param end Number The ending index. Defaults to the last Record for non buffered Stores. 
		* @param options Object Used when the Store is {@link buffered] and the range may not be available synchronously. 
		* @returns Ext.data.Model[] An array of records if the records are immediately available. For buffered stores, you should pass the callback option unless you know that the range will be present - see rangeCached. 
		*/
		getRange?( start?:number, end?:number, options?:any ): Ext.data.IModel[];
		/** [Method] Returns the total number of Model instances that the Proxy indicates exist  
		* @returns Number The total number of Model instances available via the Proxy. 0 returned if no value has been set via the reader. 
		*/
		getTotalCount?(): number;
		/** [Method] inherit docs 
		* @returns Ext.data.Model[] The updated Model instances 
		*/
		getUpdatedRecords?(): Ext.data.IModel[];
		/** [Method] Groups data inside the store  
		* @param groupers String/Object[] Either a string name of one of the fields in this Store's configured Model, or an Array of grouper configurations. 
		* @param direction String The overall direction to group the data by. 
		*/
		group?( groupers?:any, direction?:string ): void;
		/** [Method] Guarantee a specific range this will load the store with a range that must be the pageSize or smaller and take car  
		* @param start Object 
		* @param end Object 
		* @param callback Object 
		* @param scope Object 
		* @param options Object 
		*/
		guaranteeRange?( start?:any, end?:any, callback?:any, scope?:any, options?:any ): void;
		/** [Method] Get the index of the record within the store  
		* @param record Ext.data.Model The Ext.data.Model object to find. 
		* @returns Number The index of the passed Record. Returns -1 if not found. 
		*/
		indexOf?( record?:Ext.data.IModel ): number;
		/** [Method] Get the index within the store of the Record with the passed id  
		* @param id String The id of the Record to find. 
		* @returns Number The index of the Record. Returns -1 if not found. 
		*/
		indexOfId?( id?:string ): number;
		/** [Method] Get the index within the entire dataset  
		* @param record Ext.data.Model The Ext.data.Model object to find. 
		* @returns Number The index of the passed Record. Returns -1 if not found. 
		*/
		indexOfTotal?( record?:Ext.data.IModel ): number;
		/** [Method] Inserts Model instances into the Store at the given index and fires the add event  
		* @param index Number The start index at which to insert the passed Records. 
		* @param records Ext.data.Model[] An Array of Ext.data.Model objects to add to the store. 
		* @returns Ext.data.Model[] records The added records 
		*/
		insert?( index?:number, records?:Ext.data.IModel[] ): Ext.data.IModel[];
		/** [Method] Returns true if this store is currently filtered 
		* @returns Boolean 
		*/
		isFiltered?(): boolean;
		/** [Method] Checks if the store is currently grouped 
		* @returns Boolean true if the store is grouped. 
		*/
		isGrouped?(): boolean;
		/** [Method] Convenience function for getting the last model instance in the store  
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the last record being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Ext.data.Model/undefined The last model instance in the store, or undefined 
		*/
		last?( grouped?:boolean ): any;
		/** [Method] Loads data into the Store via the configured proxy  
		* @param options Object/Function config object, passed into the Ext.data.Operation object before loading. Additionally addRecords: true can be specified to add these records to the existing records, default is to remove the Store's existing records first. 
		*/
		load?( options?:any ): void;
		/** [Method] Loads an array of data straight into the Store  
		* @param data Ext.data.Model[]/Object[] Array of data to load. Any non-model instances will be cast into model instances first. 
		* @param append Boolean true to add the records to the existing records in the store, false to remove the old ones first. 
		*/
		loadData?( data?:any, append?:boolean ): void;
		/** [Method] Loads a given page of data by setting the start and limit values appropriately  
		* @param page Number The number of the page to load. 
		* @param options Object See options for load. 
		*/
		loadPage?( page?:number, options?:any ): void;
		/** [Method] Loads data via the bound Proxy s reader Use this method if you are attempting to load data and want to utilize the c  
		* @param data Object[] The full JSON object you'd like to load into the Data store. 
		* @param append Boolean true to add the records to the existing records in the store, false to remove the old ones first. 
		*/
		loadRawData?( data?:any[], append?:boolean ): void;
		/** [Method] Loads an array of model instances into the store fires the datachanged event  
		* @param records Ext.data.Model[] The array of records to load 
		* @param options Object 
		*/
		loadRecords?( records?:Ext.data.IModel[], options?:any ): void;
		/** [Method] Gets the maximum value in the store  
		* @param field String The field in each record 
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the maximum in the group being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Object The maximum value, if no items exist, undefined. 
		*/
		max?( field?:string, grouped?:boolean ): any;
		/** [Method] Gets the minimum value in the store  
		* @param field String The field in each record 
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the minimum in the group being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Object The minimum value, if no items exist, undefined. 
		*/
		min?( field?:string, grouped?:boolean ): any;
		/** [Method] Loads the next page in the current data set 
		* @param options Object See options for load 
		*/
		nextPage?( options?:any ): void;
		/** [Method] Prefetches data into the store using its configured proxy  
		* @param options Object config object, passed into the Ext.data.Operation object before loading. See load 
		*/
		prefetch?( options?:any ): void;
		/** [Method] Prefetches a page of data  
		* @param page Number The page to prefetch 
		* @param options Object config object, passed into the Ext.data.Operation object before loading. See load 
		*/
		prefetchPage?( page?:number, options?:any ): void;
		/** [Method] Ensures that the specified range of rows is present in the cache  
		* @param start Object 
		* @param end Object 
		*/
		prefetchRange?( start?:any, end?:any ): void;
		/** [Method] Loads the previous page in the current data set 
		* @param options Object See options for load 
		*/
		previousPage?( options?:any ): void;
		/** [Method] Query all the cached records in this Store by name value pair  
		* @param property String The property to create the filter function for 
		* @param value String/RegExp The string/regex to compare the property value to 
		* @param anyMatch Boolean true if we don't care if the filter value is not the full value. 
		* @param caseSensitive Boolean true to create a case-sensitive regex. 
		* @param exactMatch Boolean true to force exact match (^ and $ characters added to the regex). Ignored if anyMatch is true. 
		* @returns Ext.util.MixedCollection Returns an Ext.util.MixedCollection of the matched records 
		*/
		query?( property?:string, value?:any, anyMatch?:boolean, caseSensitive?:boolean, exactMatch?:boolean ): Ext.util.IMixedCollection;
		/** [Method] Query all the cached records in this Store using a filtering function  
		* @param fn Function The function to be called. It will be passed the following parameters: 
		* @param scope Object The scope (this reference) in which the function is executed Defaults to this Store. 
		* @returns Ext.util.MixedCollection Returns an Ext.util.MixedCollection of the matched records 
		*/
		queryBy?( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Rejects outstanding changes on all modified records and re insert any records that were removed locally  */
		rejectChanges?(): void;
		/** [Method] Reloads the store using the last options passed to the load method  
		* @param options Object 
		*/
		reload?( options?:any ): void;
		/** [Method] Removes the specified record s from the Store firing the remove event for each instance that is removed  
		* @param records Ext.data.Model/Ext.data.Model[]/Number/Number[] Model instance or array of instances to remove or an array of indices from which to remove records. 
		*/
		remove?( records?:any ): void;
		/** [Method] Removes all items from the store  
		* @param silent Boolean Pass true to prevent the record bulkremove and clear events from being fired. 
		*/
		removeAll?( silent?:boolean ): void;
		/** [Method] Removes the model instance s at the given index 
		* @param index Number The record index 
		* @param count Number The number of records to delete 
		*/
		removeAt?( index?:number, count?:number ): void;
		/** [Method] Removes an individual Filter from the current filter set using the passed Filter Filter id and by default applys the  
		* @param toRemove Mixed The id of a Filter to remove from the filter set, or a Filter instance to remove. 
		* @param applyFilters Boolean Pass as false to remove the filter but not apply the updated filter set. If null is passed, all anonymous Filters (Filters with no id property) will be removed. 
		*/
		removeFilter?( toRemove?:any, applyFilters?:boolean ): void;
		/** [Method] because prefetchData is stored by index this invalidates all of the prefetchedData 
		* @returns Ext.util.Sorter[] 
		*/
		sort?(): Ext.util.ISorter[];
		/** [Method] Sums the value of field for each record in store and returns the result  
		* @param field String A field in each record 
		* @param grouped Boolean True to perform the operation for each group in the store. The value returned will be an object literal with the key being the group name and the sum for that group being the value. The grouped parameter is only honored if the store has a groupField. 
		* @returns Number The sum 
		*/
		sum?( field?:string, grouped?:boolean ): number;
	}
}
declare module Ext.data {
	export interface IStoreManager extends Ext.util.IMixedCollection {
	}
	export class StoreManager {
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isMixedCollection: boolean;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (Boolean) */
		static isSortable: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Ext.util.MixedCollection) */
		static sorters: Ext.util.IMixedCollection;
		/** [Method] Adds an item to the collection  
		* @param key String/Object The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param obj Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:any, obj?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param objs Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if allowFunctions has been set to true. 
		*/
		static addAll( objs?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Collects unique values of a particular property in this MixedCollection 
		* @param property String The property to collect on 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param allowBlank Boolean Pass true to allow null, undefined or empty string values 
		* @returns Array The unique values 
		*/
		static collect( property?:string, root?:string, allowBlank?:boolean ): any[];
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param o Object The Object to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as an item. 
		*/
		static contains( o?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Filters the objects in this collection by a set of Filters or by a single property value pair with optional paramete  
		* @param property Ext.util.Filter[]/String A property on your objects, or an array of Filter objects 
		* @param value String/RegExp Either string that the property values should start with or a RegExp to test against the property 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filter( property?:any, value?:any, anyMatch?:boolean, caseSensitive?:boolean ): Ext.util.IMixedCollection;
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  */
		static find(): void;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function, or null if none was found. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Finds the index of the first matching object in this collection by a specific property value  
		* @param property String The name of a property on your objects. 
		* @param value String/RegExp A string that the property values should start with or a RegExp to test against the property. 
		* @param start Number The index to start searching at. 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning. 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Number The matched index or -1 
		*/
		static findIndex( property?:string, value?:any, start?:number, anyMatch?:boolean, caseSensitive?:boolean ): number;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index or -1 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] Calculates the insertion index of the new item based upon the comparison function passed or the current sort order  
		* @param newItem Object The new object to find the insertion position of. 
		* @param sorterFn Function The function to sort by. This is the same as the sorting function passed to sortBy. It accepts 2 items from this MixedCollection, and returns -1 0, or 1 depending on the relative sort positions of the 2 compared items. If omitted, a function generated from the currently defined set of sorters will be used. 
		* @returns Number The insertion point to add the new item into this MixedCollection at using insert 
		*/
		static findInsertionIndex( newItem?:any, sorterFn?:any ): number;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection.. 
		*/
		static first(): any;
		/** [Method] Returns a comparator function which compares two items and returns 1 0 or 1 depending on the currently defined set  */
		static generateComparator(): void;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Gets the first sorter from the sorters collection excluding any groupers that may be in place 
		* @returns Ext.util.Sorter The sorter, null if none exist 
		*/
		static getFirstSorter(): Ext.util.ISorter;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param startIndex Number The starting index. Defaults to 0. 
		* @param endIndex Number The ending index. Defaults to the last item. 
		* @returns Array An array of items 
		*/
		static getRange( startIndex?:number, endIndex?:number ): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Returns index within the collection of the passed Object  
		* @param o Object The item to find the index of. 
		* @returns Number index of the item. Returns -1 if not found. 
		*/
		static indexOf( o?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Performs initialization of this mixin  */
		static initSortable(): void;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String/Object/String[]/Object[] The key to associate with the new item, or the item itself. May also be an array of either to insert multiple items at once. 
		* @param o Object/Object[] If the second parameter was a key, the new item. May also be an array to insert multiple items at once. 
		* @returns Object The item inserted or an array of items inserted. 
		*/
		static insert( index?:number, key?:any, o?:any ): any;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection.. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by id 
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Remove an item from the collection  
		* @param o Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( o?:any ): any;
		/** [Method] Remove all items in the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removes an item associated with the passed key fom the collection  
		* @param key String The key of the item to remove. If null is passed, all objects which yielded no key from the configured getKey function are removed. 
		* @returns Object Only returned if removing at a specified key. The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Remove a range of items starting at a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @param removeCount Number The nuber of items to remove beginning at the specified index. 
		* @returns Object The last item removed or false if no item was removed. 
		*/
		static removeRange( index?:number, removeCount?:number ): any;
		/** [Method] Reorders each of the items based on a mapping from old index to new index  
		* @param mapping Object Mapping from old item index to new item index 
		*/
		static reorder( mapping?:any ): void;
		/** [Method] Replaces an item in the collection  
		* @param key String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param o Object {Object} o (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( key?:string, o?:any ): any;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Sorts the data in the Store by one or more of its properties  
		* @param sorters String/Ext.util.Sorter[] Either a string name of one of the fields in this Store's configured Model, or an array of sorter configurations. 
		* @param direction String The overall direction to sort the data by. 
		* @returns Ext.util.Sorter[] 
		*/
		static sort( sorters?:any, direction?:string ): Ext.util.ISorter[];
		/** [Method] Sorts the collection by a single sorter function 
		* @param sorterFn Function The function to sort by 
		*/
		static sortBy( sorterFn?:any ): void;
		/** [Method] Sorts this collection by keys  
		* @param direction String 'ASC' or 'DESC'. Defaults to 'ASC'. 
		* @param fn Function Comparison function that defines the sort order. Defaults to sorting by case insensitive string. 
		*/
		static sortByKey( direction?:string, fn?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Collects all of the values of the given property and returns their sum 
		* @param property String The property to sum by 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param start Number The record index to start at 
		* @param end Number The record index to end at 
		* @returns Number The total 
		*/
		static sum( property?:string, root?:string, start?:number, end?:number ): number;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Unregisters one or more Stores with the StoreManager 
		* @param stores String/Object... Any number of Store instances or ID-s 
		*/
		static unregister( stores?:any ): void;
		/** [Method] Change the key for an existing item in the collection  
		* @param oldKey Object The old key 
		* @param newKey Object The new key 
		*/
		static updateKey( oldKey?:any, newKey?:any ): void;
	}
}
declare module Ext {
	export interface IStoreMgr extends Ext.util.IMixedCollection {
	}
	export class StoreMgr {
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isMixedCollection: boolean;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (Boolean) */
		static isSortable: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Ext.util.MixedCollection) */
		static sorters: Ext.util.IMixedCollection;
		/** [Method] Adds an item to the collection  
		* @param key String/Object The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param obj Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:any, obj?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param objs Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if allowFunctions has been set to true. 
		*/
		static addAll( objs?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Collects unique values of a particular property in this MixedCollection 
		* @param property String The property to collect on 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param allowBlank Boolean Pass true to allow null, undefined or empty string values 
		* @returns Array The unique values 
		*/
		static collect( property?:string, root?:string, allowBlank?:boolean ): any[];
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param o Object The Object to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as an item. 
		*/
		static contains( o?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Filters the objects in this collection by a set of Filters or by a single property value pair with optional paramete  
		* @param property Ext.util.Filter[]/String A property on your objects, or an array of Filter objects 
		* @param value String/RegExp Either string that the property values should start with or a RegExp to test against the property 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filter( property?:any, value?:any, anyMatch?:boolean, caseSensitive?:boolean ): Ext.util.IMixedCollection;
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  */
		static find(): void;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function, or null if none was found. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Finds the index of the first matching object in this collection by a specific property value  
		* @param property String The name of a property on your objects. 
		* @param value String/RegExp A string that the property values should start with or a RegExp to test against the property. 
		* @param start Number The index to start searching at. 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning. 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Number The matched index or -1 
		*/
		static findIndex( property?:string, value?:any, start?:number, anyMatch?:boolean, caseSensitive?:boolean ): number;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index or -1 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] Calculates the insertion index of the new item based upon the comparison function passed or the current sort order  
		* @param newItem Object The new object to find the insertion position of. 
		* @param sorterFn Function The function to sort by. This is the same as the sorting function passed to sortBy. It accepts 2 items from this MixedCollection, and returns -1 0, or 1 depending on the relative sort positions of the 2 compared items. If omitted, a function generated from the currently defined set of sorters will be used. 
		* @returns Number The insertion point to add the new item into this MixedCollection at using insert 
		*/
		static findInsertionIndex( newItem?:any, sorterFn?:any ): number;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection.. 
		*/
		static first(): any;
		/** [Method] Returns a comparator function which compares two items and returns 1 0 or 1 depending on the currently defined set  */
		static generateComparator(): void;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Gets the first sorter from the sorters collection excluding any groupers that may be in place 
		* @returns Ext.util.Sorter The sorter, null if none exist 
		*/
		static getFirstSorter(): Ext.util.ISorter;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param startIndex Number The starting index. Defaults to 0. 
		* @param endIndex Number The ending index. Defaults to the last item. 
		* @returns Array An array of items 
		*/
		static getRange( startIndex?:number, endIndex?:number ): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Returns index within the collection of the passed Object  
		* @param o Object The item to find the index of. 
		* @returns Number index of the item. Returns -1 if not found. 
		*/
		static indexOf( o?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Performs initialization of this mixin  */
		static initSortable(): void;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String/Object/String[]/Object[] The key to associate with the new item, or the item itself. May also be an array of either to insert multiple items at once. 
		* @param o Object/Object[] If the second parameter was a key, the new item. May also be an array to insert multiple items at once. 
		* @returns Object The item inserted or an array of items inserted. 
		*/
		static insert( index?:number, key?:any, o?:any ): any;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection.. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by id 
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Remove an item from the collection  
		* @param o Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( o?:any ): any;
		/** [Method] Remove all items in the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removes an item associated with the passed key fom the collection  
		* @param key String The key of the item to remove. If null is passed, all objects which yielded no key from the configured getKey function are removed. 
		* @returns Object Only returned if removing at a specified key. The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Remove a range of items starting at a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @param removeCount Number The nuber of items to remove beginning at the specified index. 
		* @returns Object The last item removed or false if no item was removed. 
		*/
		static removeRange( index?:number, removeCount?:number ): any;
		/** [Method] Reorders each of the items based on a mapping from old index to new index  
		* @param mapping Object Mapping from old item index to new item index 
		*/
		static reorder( mapping?:any ): void;
		/** [Method] Replaces an item in the collection  
		* @param key String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param o Object {Object} o (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( key?:string, o?:any ): any;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Sorts the data in the Store by one or more of its properties  
		* @param sorters String/Ext.util.Sorter[] Either a string name of one of the fields in this Store's configured Model, or an array of sorter configurations. 
		* @param direction String The overall direction to sort the data by. 
		* @returns Ext.util.Sorter[] 
		*/
		static sort( sorters?:any, direction?:string ): Ext.util.ISorter[];
		/** [Method] Sorts the collection by a single sorter function 
		* @param sorterFn Function The function to sort by 
		*/
		static sortBy( sorterFn?:any ): void;
		/** [Method] Sorts this collection by keys  
		* @param direction String 'ASC' or 'DESC'. Defaults to 'ASC'. 
		* @param fn Function Comparison function that defines the sort order. Defaults to sorting by case insensitive string. 
		*/
		static sortByKey( direction?:string, fn?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Collects all of the values of the given property and returns their sum 
		* @param property String The property to sum by 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param start Number The record index to start at 
		* @param end Number The record index to end at 
		* @returns Number The total 
		*/
		static sum( property?:string, root?:string, start?:number, end?:number ): number;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Unregisters one or more Stores with the StoreManager 
		* @param stores String/Object... Any number of Store instances or ID-s 
		*/
		static unregister( stores?:any ): void;
		/** [Method] Change the key for an existing item in the collection  
		* @param oldKey Object The old key 
		* @param newKey Object The new key 
		*/
		static updateKey( oldKey?:any, newKey?:any ): void;
	}
}
declare module Ext.data {
	export interface IStoreMgr extends Ext.util.IMixedCollection {
	}
	export class StoreMgr {
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isMixedCollection: boolean;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (Boolean) */
		static isSortable: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Ext.util.MixedCollection) */
		static sorters: Ext.util.IMixedCollection;
		/** [Method] Adds an item to the collection  
		* @param key String/Object The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param obj Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:any, obj?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param objs Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if allowFunctions has been set to true. 
		*/
		static addAll( objs?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Collects unique values of a particular property in this MixedCollection 
		* @param property String The property to collect on 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param allowBlank Boolean Pass true to allow null, undefined or empty string values 
		* @returns Array The unique values 
		*/
		static collect( property?:string, root?:string, allowBlank?:boolean ): any[];
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param o Object The Object to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as an item. 
		*/
		static contains( o?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Filters the objects in this collection by a set of Filters or by a single property value pair with optional paramete  
		* @param property Ext.util.Filter[]/String A property on your objects, or an array of Filter objects 
		* @param value String/RegExp Either string that the property values should start with or a RegExp to test against the property 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filter( property?:any, value?:any, anyMatch?:boolean, caseSensitive?:boolean ): Ext.util.IMixedCollection;
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  */
		static find(): void;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function, or null if none was found. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Finds the index of the first matching object in this collection by a specific property value  
		* @param property String The name of a property on your objects. 
		* @param value String/RegExp A string that the property values should start with or a RegExp to test against the property. 
		* @param start Number The index to start searching at. 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning. 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Number The matched index or -1 
		*/
		static findIndex( property?:string, value?:any, start?:number, anyMatch?:boolean, caseSensitive?:boolean ): number;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index or -1 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] Calculates the insertion index of the new item based upon the comparison function passed or the current sort order  
		* @param newItem Object The new object to find the insertion position of. 
		* @param sorterFn Function The function to sort by. This is the same as the sorting function passed to sortBy. It accepts 2 items from this MixedCollection, and returns -1 0, or 1 depending on the relative sort positions of the 2 compared items. If omitted, a function generated from the currently defined set of sorters will be used. 
		* @returns Number The insertion point to add the new item into this MixedCollection at using insert 
		*/
		static findInsertionIndex( newItem?:any, sorterFn?:any ): number;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection.. 
		*/
		static first(): any;
		/** [Method] Returns a comparator function which compares two items and returns 1 0 or 1 depending on the currently defined set  */
		static generateComparator(): void;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Gets the first sorter from the sorters collection excluding any groupers that may be in place 
		* @returns Ext.util.Sorter The sorter, null if none exist 
		*/
		static getFirstSorter(): Ext.util.ISorter;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param startIndex Number The starting index. Defaults to 0. 
		* @param endIndex Number The ending index. Defaults to the last item. 
		* @returns Array An array of items 
		*/
		static getRange( startIndex?:number, endIndex?:number ): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Returns index within the collection of the passed Object  
		* @param o Object The item to find the index of. 
		* @returns Number index of the item. Returns -1 if not found. 
		*/
		static indexOf( o?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Performs initialization of this mixin  */
		static initSortable(): void;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String/Object/String[]/Object[] The key to associate with the new item, or the item itself. May also be an array of either to insert multiple items at once. 
		* @param o Object/Object[] If the second parameter was a key, the new item. May also be an array to insert multiple items at once. 
		* @returns Object The item inserted or an array of items inserted. 
		*/
		static insert( index?:number, key?:any, o?:any ): any;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection.. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by id 
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Remove an item from the collection  
		* @param o Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( o?:any ): any;
		/** [Method] Remove all items in the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removes an item associated with the passed key fom the collection  
		* @param key String The key of the item to remove. If null is passed, all objects which yielded no key from the configured getKey function are removed. 
		* @returns Object Only returned if removing at a specified key. The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Remove a range of items starting at a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @param removeCount Number The nuber of items to remove beginning at the specified index. 
		* @returns Object The last item removed or false if no item was removed. 
		*/
		static removeRange( index?:number, removeCount?:number ): any;
		/** [Method] Reorders each of the items based on a mapping from old index to new index  
		* @param mapping Object Mapping from old item index to new item index 
		*/
		static reorder( mapping?:any ): void;
		/** [Method] Replaces an item in the collection  
		* @param key String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param o Object {Object} o (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( key?:string, o?:any ): any;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Sorts the data in the Store by one or more of its properties  
		* @param sorters String/Ext.util.Sorter[] Either a string name of one of the fields in this Store's configured Model, or an array of sorter configurations. 
		* @param direction String The overall direction to sort the data by. 
		* @returns Ext.util.Sorter[] 
		*/
		static sort( sorters?:any, direction?:string ): Ext.util.ISorter[];
		/** [Method] Sorts the collection by a single sorter function 
		* @param sorterFn Function The function to sort by 
		*/
		static sortBy( sorterFn?:any ): void;
		/** [Method] Sorts this collection by keys  
		* @param direction String 'ASC' or 'DESC'. Defaults to 'ASC'. 
		* @param fn Function Comparison function that defines the sort order. Defaults to sorting by case insensitive string. 
		*/
		static sortByKey( direction?:string, fn?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Collects all of the values of the given property and returns their sum 
		* @param property String The property to sum by 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param start Number The record index to start at 
		* @param end Number The record index to end at 
		* @returns Number The total 
		*/
		static sum( property?:string, root?:string, start?:number, end?:number ): number;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Unregisters one or more Stores with the StoreManager 
		* @param stores String/Object... Any number of Store instances or ID-s 
		*/
		static unregister( stores?:any ): void;
		/** [Method] Change the key for an existing item in the collection  
		* @param oldKey Object The old key 
		* @param newKey Object The new key 
		*/
		static updateKey( oldKey?:any, newKey?:any ): void;
	}
}
declare module Ext {
	export interface IStoreManager extends Ext.util.IMixedCollection {
	}
	export class StoreManager {
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isMixedCollection: boolean;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (Boolean) */
		static isSortable: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Ext.util.MixedCollection) */
		static sorters: Ext.util.IMixedCollection;
		/** [Method] Adds an item to the collection  
		* @param key String/Object The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param obj Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:any, obj?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param objs Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if allowFunctions has been set to true. 
		*/
		static addAll( objs?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Collects unique values of a particular property in this MixedCollection 
		* @param property String The property to collect on 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param allowBlank Boolean Pass true to allow null, undefined or empty string values 
		* @returns Array The unique values 
		*/
		static collect( property?:string, root?:string, allowBlank?:boolean ): any[];
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param o Object The Object to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as an item. 
		*/
		static contains( o?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean True if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Filters the objects in this collection by a set of Filters or by a single property value pair with optional paramete  
		* @param property Ext.util.Filter[]/String A property on your objects, or an array of Filter objects 
		* @param value String/RegExp Either string that the property values should start with or a RegExp to test against the property 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filter( property?:any, value?:any, anyMatch?:boolean, caseSensitive?:boolean ): Ext.util.IMixedCollection;
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  */
		static find(): void;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function, or null if none was found. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Finds the index of the first matching object in this collection by a specific property value  
		* @param property String The name of a property on your objects. 
		* @param value String/RegExp A string that the property values should start with or a RegExp to test against the property. 
		* @param start Number The index to start searching at. 
		* @param anyMatch Boolean True to match any part of the string, not just the beginning. 
		* @param caseSensitive Boolean True for case sensitive comparison. 
		* @returns Number The matched index or -1 
		*/
		static findIndex( property?:string, value?:any, start?:number, anyMatch?:boolean, caseSensitive?:boolean ): number;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index or -1 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] Calculates the insertion index of the new item based upon the comparison function passed or the current sort order  
		* @param newItem Object The new object to find the insertion position of. 
		* @param sorterFn Function The function to sort by. This is the same as the sorting function passed to sortBy. It accepts 2 items from this MixedCollection, and returns -1 0, or 1 depending on the relative sort positions of the 2 compared items. If omitted, a function generated from the currently defined set of sorters will be used. 
		* @returns Number The insertion point to add the new item into this MixedCollection at using insert 
		*/
		static findInsertionIndex( newItem?:any, sorterFn?:any ): number;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection.. 
		*/
		static first(): any;
		/** [Method] Returns a comparator function which compares two items and returns 1 0 or 1 depending on the currently defined set  */
		static generateComparator(): void;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Gets the first sorter from the sorters collection excluding any groupers that may be in place 
		* @returns Ext.util.Sorter The sorter, null if none exist 
		*/
		static getFirstSorter(): Ext.util.ISorter;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param startIndex Number The starting index. Defaults to 0. 
		* @param endIndex Number The ending index. Defaults to the last item. 
		* @returns Array An array of items 
		*/
		static getRange( startIndex?:number, endIndex?:number ): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Returns index within the collection of the passed Object  
		* @param o Object The item to find the index of. 
		* @returns Number index of the item. Returns -1 if not found. 
		*/
		static indexOf( o?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Performs initialization of this mixin  */
		static initSortable(): void;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String/Object/String[]/Object[] The key to associate with the new item, or the item itself. May also be an array of either to insert multiple items at once. 
		* @param o Object/Object[] If the second parameter was a key, the new item. May also be an array to insert multiple items at once. 
		* @returns Object The item inserted or an array of items inserted. 
		*/
		static insert( index?:number, key?:any, o?:any ): any;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection.. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by id 
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Remove an item from the collection  
		* @param o Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( o?:any ): any;
		/** [Method] Remove all items in the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removes an item associated with the passed key fom the collection  
		* @param key String The key of the item to remove. If null is passed, all objects which yielded no key from the configured getKey function are removed. 
		* @returns Object Only returned if removing at a specified key. The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Remove a range of items starting at a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @param removeCount Number The nuber of items to remove beginning at the specified index. 
		* @returns Object The last item removed or false if no item was removed. 
		*/
		static removeRange( index?:number, removeCount?:number ): any;
		/** [Method] Reorders each of the items based on a mapping from old index to new index  
		* @param mapping Object Mapping from old item index to new item index 
		*/
		static reorder( mapping?:any ): void;
		/** [Method] Replaces an item in the collection  
		* @param key String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param o Object {Object} o (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( key?:string, o?:any ): any;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Sorts the data in the Store by one or more of its properties  
		* @param sorters String/Ext.util.Sorter[] Either a string name of one of the fields in this Store's configured Model, or an array of sorter configurations. 
		* @param direction String The overall direction to sort the data by. 
		* @returns Ext.util.Sorter[] 
		*/
		static sort( sorters?:any, direction?:string ): Ext.util.ISorter[];
		/** [Method] Sorts the collection by a single sorter function 
		* @param sorterFn Function The function to sort by 
		*/
		static sortBy( sorterFn?:any ): void;
		/** [Method] Sorts this collection by keys  
		* @param direction String 'ASC' or 'DESC'. Defaults to 'ASC'. 
		* @param fn Function Comparison function that defines the sort order. Defaults to sorting by case insensitive string. 
		*/
		static sortByKey( direction?:string, fn?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Collects all of the values of the given property and returns their sum 
		* @param property String The property to sum by 
		* @param root String 'root' property to extract the first argument from. This is used mainly when summing fields in records, where the fields are all stored inside the 'data' object 
		* @param start Number The record index to start at 
		* @param end Number The record index to end at 
		* @returns Number The total 
		*/
		static sum( property?:string, root?:string, start?:number, end?:number ): number;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Unregisters one or more Stores with the StoreManager 
		* @param stores String/Object... Any number of Store instances or ID-s 
		*/
		static unregister( stores?:any ): void;
		/** [Method] Change the key for an existing item in the collection  
		* @param oldKey Object The old key 
		* @param newKey Object The new key 
		*/
		static updateKey( oldKey?:any, newKey?:any ): void;
	}
}
declare module Ext.data {
	export interface ITree extends Ext.IBase,Ext.util.IObservable {
		/** [Property] (Ext.data.NodeInterface) */
		root?: Ext.data.INodeInterface;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Gets a node in this tree by its id  
		* @param id String 
		* @returns Ext.data.NodeInterface The match node. 
		*/
		getNodeById?( id?:string ): Ext.data.INodeInterface;
		/** [Method] Returns the root node for this tree  
		* @returns Ext.data.NodeInterface 
		*/
		getRootNode?(): Ext.data.INodeInterface;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Removes the root node from this tree  
		* @returns Ext.data.NodeInterface The root node 
		*/
		removeRootNode?(): Ext.data.INodeInterface;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Sets the root node for this tree  
		* @param node Ext.data.NodeInterface 
		* @returns Ext.data.NodeInterface The root node 
		*/
		setRootNode?( node?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface ITreeModel extends Ext.data.IModel {
	}
}
declare module Ext.data {
	export interface ITreeStore extends Ext.data.IAbstractStore {
		/** [Config Option] (Boolean) */
		clearOnLoad?: boolean;
		/** [Config Option] (Boolean) */
		clearRemovedOnLoad?: boolean;
		/** [Config Option] (String) */
		defaultRootId?: string;
		/** [Config Option] (String) */
		defaultRootProperty?: string;
		/** [Config Option] (String) */
		defaultRootText?: string;
		/** [Config Option] (Boolean) */
		folderSort?: boolean;
		/** [Config Option] (String) */
		nodeParam?: string;
		/** [Config Option] (Ext.data.Model/Ext.data.NodeInterface/Object) */
		root?: any;
		/** [Method] inherit docs 
		* @returns Ext.data.Model[] The Model instances 
		*/
		getNewRecords?(): Ext.data.IModel[];
		/** [Method] Returns the record node by id 
		* @param id Object 
		* @returns Ext.data.NodeInterface 
		*/
		getNodeById?( id?:any ): Ext.data.INodeInterface;
		/** [Method] Returns the root node for this tree  
		* @returns Ext.data.NodeInterface 
		*/
		getRootNode?(): Ext.data.INodeInterface;
		/** [Method] inherit docs 
		* @returns Ext.data.Model[] The updated Model instances 
		*/
		getUpdatedRecords?(): Ext.data.IModel[];
		/** [Method] Loads the Store using its configured proxy  
		* @param options Object config object. This is passed into the Operation object that is created and then sent to the proxy's Ext.data.proxy.Proxy.read function. The options can also contain a node, which indicates which node is to be loaded. If not specified, it will default to the root node. 
		*/
		load?( options?:any ): void;
		/** [Method] inherit docs */
		removeAll?(): void;
		/** [Method] inherit docs 
		* @param proxy Object 
		* @returns Ext.data.proxy.Proxy The attached Proxy object 
		*/
		setProxy?( proxy?:any ): Ext.data.proxy.IProxy;
		/** [Method] Sets the root node for this store  
		* @param root Ext.data.Model/Ext.data.NodeInterface/Object 
		* @returns Ext.data.NodeInterface The new root 
		*/
		setRootNode?( root?:any ): Ext.data.INodeInterface;
	}
}
declare module Ext.data {
	export interface ITypes extends Ext.IBase {
	}
	export class Types {
		/** [Property] (Object) */
		static AUTO: any;
		/** [Property] (Object) */
		static BOOL: any;
		/** [Property] (Object) */
		static BOOLEAN: any;
		/** [Property] (Object) */
		static DATE: any;
		/** [Property] (Object) */
		static FLOAT: any;
		/** [Property] (Object) */
		static INT: any;
		/** [Property] (Object) */
		static INTEGER: any;
		/** [Property] (Object) */
		static NUMBER: any;
		/** [Property] (Object) */
		static STRING: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (RegExp) */
		static stripRe: RegExp;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data {
	export interface IUuidGenerator extends Ext.data.IIdGenerator {
		/** [Config Option] (Number) */
		version?: number;
		/** [Property] (Number/Object) */
		salt?: any;
		/** [Property] (Number/Object) */
		timestamp?: any;
		/** [Method] Reconfigures this generator given new config properties  
		* @param config Object 
		*/
		reconfigure?( config?:any ): void;
	}
}
declare module Ext.data {
	export interface IValidations extends Ext.IBase {
	}
	export class Validations {
		/** [Property] (String) */
		static emailMessage: string;
		/** [Property] (RegExp) */
		static emailRe: RegExp;
		/** [Property] (String) */
		static exclusionMessage: string;
		/** [Property] (String) */
		static formatMessage: string;
		/** [Property] (String) */
		static inclusionMessage: string;
		/** [Property] (String) */
		static lengthMessage: string;
		/** [Property] (String) */
		static presenceMessage: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Validates that an email string is in the correct format 
		* @param config Object Config object 
		* @param email String The email address 
		* @returns Boolean True if the value passes validation 
		*/
		static email( config?:any, email?:string ): boolean;
		/** [Method] Validates that the given value is not present in the configured list  
		* @param config Object Config object 
		* @param value String The value to validate 
		* @returns Boolean True if the value is not present in the list 
		*/
		static exclusion( config?:any, value?:string ): boolean;
		/** [Method] Returns true if the given value passes validation against the configured matcher regex  
		* @param config Object Config object 
		* @param value String The value to validate 
		* @returns Boolean True if the value passes the format validation 
		*/
		static format( config?:any, value?:string ): boolean;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Validates that the given value is present in the configured list  
		* @param config Object Config object 
		* @param value String The value to validate 
		* @returns Boolean True if the value is present in the list 
		*/
		static inclusion( config?:any, value?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Returns true if the given value is between the configured min and max values  
		* @param config Object Config object 
		* @param value String The value to validate 
		* @returns Boolean True if the value passes validation 
		*/
		static length( config?:any, value?:string ): boolean;
		/** [Method] Validates that the given value is present  
		* @param config Object Config object 
		* @param value Object The value to validate 
		* @returns Boolean True if validation passed 
		*/
		static presence( config?:any, value?:any ): boolean;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data.writer {
	export interface IJson extends Ext.data.writer.IWriter {
		/** [Config Option] (Boolean) */
		allowSingle?: boolean;
		/** [Config Option] (Boolean) */
		encode?: boolean;
		/** [Config Option] (Boolean) */
		expandData?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Method] The Reader classes support dot delimited data mappings for extracting nested raw data into fields so the writer must  
		* @param data Object 
		*/
		getExpandedData?( data?:any ): void;
	}
}
declare module Ext.data {
	export interface IJsonWriter extends Ext.data.writer.IWriter {
		/** [Config Option] (Boolean) */
		allowSingle?: boolean;
		/** [Config Option] (Boolean) */
		encode?: boolean;
		/** [Config Option] (Boolean) */
		expandData?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Method] The Reader classes support dot delimited data mappings for extracting nested raw data into fields so the writer must  
		* @param data Object 
		*/
		getExpandedData?( data?:any ): void;
	}
}
declare module Ext.data.writer {
	export interface IWriter extends Ext.IBase {
		/** [Config Option] (String) */
		dateFormat?: string;
		/** [Config Option] (String) */
		nameProperty?: string;
		/** [Config Option] (Boolean) */
		writeAllFields?: boolean;
		/** [Config Option] (Boolean) */
		writeRecordId?: boolean;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Ext.data.Model The record that we are writing to the server. 
		* @param operation Ext.data.Operation An operation object. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:Ext.data.IModel, operation?:Ext.data.IOperation ): any;
		/** [Method] Prepares a Proxy s Ext data Request object 
		* @param request Ext.data.Request The request object 
		* @returns Ext.data.Request The modified request object 
		*/
		write?( request?:Ext.data.IRequest ): Ext.data.IRequest;
	}
}
declare module Ext.data {
	export interface IDataWriter extends Ext.IBase {
		/** [Config Option] (String) */
		dateFormat?: string;
		/** [Config Option] (String) */
		nameProperty?: string;
		/** [Config Option] (Boolean) */
		writeAllFields?: boolean;
		/** [Config Option] (Boolean) */
		writeRecordId?: boolean;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Ext.data.Model The record that we are writing to the server. 
		* @param operation Ext.data.Operation An operation object. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:Ext.data.IModel, operation?:Ext.data.IOperation ): any;
		/** [Method] Prepares a Proxy s Ext data Request object 
		* @param request Ext.data.Request The request object 
		* @returns Ext.data.Request The modified request object 
		*/
		write?( request?:Ext.data.IRequest ): Ext.data.IRequest;
	}
}
declare module Ext.data {
	export interface IWriter extends Ext.IBase {
		/** [Config Option] (String) */
		dateFormat?: string;
		/** [Config Option] (String) */
		nameProperty?: string;
		/** [Config Option] (Boolean) */
		writeAllFields?: boolean;
		/** [Config Option] (Boolean) */
		writeRecordId?: boolean;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Ext.data.Model The record that we are writing to the server. 
		* @param operation Ext.data.Operation An operation object. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:Ext.data.IModel, operation?:Ext.data.IOperation ): any;
		/** [Method] Prepares a Proxy s Ext data Request object 
		* @param request Ext.data.Request The request object 
		* @returns Ext.data.Request The modified request object 
		*/
		write?( request?:Ext.data.IRequest ): Ext.data.IRequest;
	}
}
declare module Ext.data.writer {
	export interface IXml extends Ext.data.writer.IWriter {
		/** [Config Option] (String) */
		defaultDocumentRoot?: string;
		/** [Config Option] (String) */
		documentRoot?: string;
		/** [Config Option] (String) */
		header?: string;
		/** [Config Option] (String) */
		record?: string;
	}
}
declare module Ext.data {
	export interface IXmlWriter extends Ext.data.writer.IWriter {
		/** [Config Option] (String) */
		defaultDocumentRoot?: string;
		/** [Config Option] (String) */
		documentRoot?: string;
		/** [Config Option] (String) */
		header?: string;
		/** [Config Option] (String) */
		record?: string;
	}
}
declare module Ext.data {
	export interface IXmlStore extends Ext.data.IStore {
	}
}
declare module Ext {
	export interface IDate {
	}
	export class Date {
		/** [Property] (String) */
		static DAY: string;
		/** [Property] (String) */
		static HOUR: string;
		/** [Property] (String) */
		static MILLI: string;
		/** [Property] (String) */
		static MINUTE: string;
		/** [Property] (String) */
		static MONTH: string;
		/** [Property] (String) */
		static SECOND: string;
		/** [Property] (String) */
		static YEAR: string;
		/** [Property] (String[]) */
		static dayNames: string[];
		/** [Property] (String) */
		static defaultFormat: string;
		/** [Property] (Object) */
		static defaults: any;
		/** [Property] (Object) */
		static formatCodes: any;
		/** [Property] (Object) */
		static formatFunctions: any;
		/** [Property] (String[]) */
		static monthNames: string[];
		/** [Property] (Object) */
		static monthNumbers: any;
		/** [Property] (Object) */
		static parseFunctions: any;
		/** [Property] (Boolean) */
		static useStrict: boolean;
		/** [Method] Provides a convenient method for performing basic date arithmetic  
		* @param date Date The date to modify 
		* @param interval String A valid date interval enum value. 
		* @param value Number The amount to add to the current date. 
		* @returns Date The new Date instance. 
		*/
		static add( date?:any, interval?:string, value?:number ): any;
		/** [Method] Checks if a date falls on or between the given start and end dates  
		* @param date Date The date to check 
		* @param start Date Start date 
		* @param end Date End date 
		* @returns Boolean true if this date falls on or between the given start and end dates. 
		*/
		static between( date?:any, start?:any, end?:any ): boolean;
		/** [Method] Attempts to clear all time information from this Date by setting the time to midnight of the same day automatically 
		* @param date Date The date 
		* @param clone Boolean true to create a clone of this date, clear the time and return it. 
		* @returns Date this or the clone. 
		*/
		static clearTime( date?:any, clone?:boolean ): any;
		/** [Method] Creates and returns a new Date instance with the exact same date value as the called instance  
		* @param date Date The date. 
		* @returns Date The new Date instance. 
		*/
		static clone( date?:any ): any;
		/** [Method] Formats a date given the supplied format string  
		* @param date Date The date to format 
		* @param format String The format string 
		* @returns String The formatted date or an empty string if date parameter is not a JavaScript Date object 
		*/
		static format( date?:any, format?:string ): string;
		/** [Method] Checks if the specified format contains information about anything other than the time  
		* @param format String The format to check 
		* @returns Boolean True if the format contains information about date/day information. 
		*/
		static formatContainsDateInfo( format?:string ): boolean;
		/** [Method] Checks if the specified format contains hour information 
		* @param format String The format to check 
		* @returns Boolean True if the format contains hour information 
		*/
		static formatContainsHourInfo( format?:string ): boolean;
		/** [Method] Get the numeric day number of the year adjusted for leap year  
		* @param date Date The date 
		* @returns Number 0 to 364 (365 in leap years). 
		*/
		static getDayOfYear( date?:any ): number;
		/** [Method] Get the number of days in the current month adjusted for leap year  
		* @param date Date The date 
		* @returns Number The number of days in the month. 
		*/
		static getDaysInMonth( date?:any ): number;
		/** [Method] Returns the number of milliseconds between two dates  
		* @param dateA Date The first date. 
		* @param dateB Date The second date. 
		* @returns Number The difference in milliseconds 
		*/
		static getElapsed( dateA?:any, dateB?:any ): number;
		/** [Method] Get the date of the first day of the month in which this date resides  
		* @param date Date The date 
		* @returns Date 
		*/
		static getFirstDateOfMonth( date?:any ): any;
		/** [Method] Get the first day of the current month adjusted for leap year  
		* @param date Date The date 
		* @returns Number The day number (0-6). 
		*/
		static getFirstDayOfMonth( date?:any ): number;
		/** [Method] Get the offset from GMT of the current date equivalent to the format specifier O  
		* @param date Date The date 
		* @param colon Boolean true to separate the hours and minutes with a colon. 
		* @returns String The 4-character offset string prefixed with + or - (e.g. '-0600'). 
		*/
		static getGMTOffset( date?:any, colon?:boolean ): string;
		/** [Method] Get the date of the last day of the month in which this date resides  
		* @param date Date The date 
		* @returns Date 
		*/
		static getLastDateOfMonth( date?:any ): any;
		/** [Method] Get the last day of the current month adjusted for leap year  
		* @param date Date The date 
		* @returns Number The day number (0-6). 
		*/
		static getLastDayOfMonth( date?:any ): number;
		/** [Method] Get the zero based JavaScript month number for the given short full month name  
		* @param name String The short/full month name. 
		* @returns Number The zero-based JavaScript month number. 
		*/
		static getMonthNumber( name?:string ): number;
		/** [Method] Get the short day name for the given day number  
		* @param day Number A zero-based JavaScript day number. 
		* @returns String The short day name. 
		*/
		static getShortDayName( day?:number ): string;
		/** [Method] Get the short month name for the given month number  
		* @param month Number A zero-based JavaScript month number. 
		* @returns String The short month name. 
		*/
		static getShortMonthName( month?:number ): string;
		/** [Method] Get the English ordinal suffix of the current day equivalent to the format specifier S  
		* @param date Date The date 
		* @returns String 'st, 'nd', 'rd' or 'th'. 
		*/
		static getSuffix( date?:any ): string;
		/** [Method] Get the timezone abbreviation of the current date equivalent to the format specifier T  
		* @param date Date The date 
		* @returns String The abbreviated timezone name (e.g. 'CST', 'PDT', 'EDT', 'MPST' ...). 
		*/
		static getTimezone( date?:any ): string;
		/** [Method] Get the numeric ISO 8601 week number of the year  
		* @param date Date The date 
		* @returns Number 1 to 53 
		*/
		static getWeekOfYear( date?:any ): number;
		/** [Method] Checks if the current date is affected by Daylight Saving Time DST 
		* @param date Date The date 
		* @returns Boolean true if the current date is affected by DST. 
		*/
		static isDST( date?:any ): boolean;
		/** [Method] Compares if two dates are equal by comparing their values  
		* @param date1 Date 
		* @param date2 Date 
		* @returns Boolean true if the date values are equal 
		*/
		static isEqual( date1?:any, date2?:any ): boolean;
		/** [Method] Checks if the current date falls within a leap year  
		* @param date Date The date 
		* @returns Boolean True if the current date falls within a leap year, false otherwise. 
		*/
		static isLeapYear( date?:any ): boolean;
		/** [Method] Checks if the passed Date parameters will cause a JavaScript Date rollover 
		* @param year Number 4-digit year 
		* @param month Number 1-based month-of-year 
		* @param day Number Day of month 
		* @param hour Number Hour 
		* @param minute Number Minute 
		* @param second Number Second 
		* @param millisecond Number Millisecond 
		* @returns Boolean true if the passed parameters do not cause a Date "rollover", false otherwise. 
		*/
		static isValid( year?:number, month?:number, day?:number, hour?:number, minute?:number, second?:number, millisecond?:number ): boolean;
		/** [Method] Returns the current timestamp  
		* @returns Number Milliseconds since UNIX epoch. 
		*/
		static now(): number;
		/** [Method] Parses the passed string using the specified date format  
		* @param input String The raw date string. 
		* @param format String The expected date string format. 
		* @param strict Boolean true to validate date strings while parsing (i.e. prevents JavaScript Date "rollover"). Invalid date strings will return null when parsed. 
		* @returns Date The parsed Date. 
		*/
		static parse( input?:string, format?:string, strict?:boolean ): any;
		/** [Method] Provides a convenient method for performing basic date arithmetic  
		* @param date Date The date to modify 
		* @param interval String A valid date interval enum value. 
		* @param value Number The amount to subtract from the current date. 
		* @returns Date The new Date instance. 
		*/
		static subtract( date?:any, interval?:string, value?:number ): any;
		/** [Method] Removes all escaping for a date format string  
		* @param format String The format to unescape 
		* @returns String The unescaped format 
		*/
		static unescapeFormat( format?:string ): string;
	}
}
declare module Ext.dd {
	export interface IDD extends Ext.dd.IDragDrop {
		/** [Property] (Boolean) */
		scroll?: boolean;
		/** [Method] Sets the element to the location of the mousedown or click event maintaining the cursor location relative to the loc  
		* @param el HTMLElement the element to move 
		* @param iPageX Number the X coordinate of the mousedown or drag event 
		* @param iPageY Number the Y coordinate of the mousedown or drag event 
		*/
		alignElWithMouse?( el?:HTMLElement, iPageX?:number, iPageY?:number ): void;
		/** [Method] Sets up config options specific to this class  */
		applyConfig?(): void;
		/** [Method] Sets the pointer offset to the distance between the linked element s top left corner and the location the element was  
		* @param iPageX Number the X coordinate of the click 
		* @param iPageY Number the Y coordinate of the click 
		*/
		autoOffset?( iPageX?:number, iPageY?:number ): void;
		/** [Method] Event that fires prior to the onDrag event  
		* @param e Object 
		*/
		b4Drag?( e?:any ): void;
		/** [Method] Event that fires prior to the onMouseDown event  
		* @param e Object 
		*/
		b4MouseDown?( e?:any ): void;
		/** [Method] Saves the most recent position so that we can reset the constraints and tick marks on demand  
		* @param iPageX Number the current x position (this just makes it so we don't have to look it up again) 
		* @param iPageY Number the current y position (this just makes it so we don't have to look it up again) 
		*/
		cachePosition?( iPageX?:number, iPageY?:number ): void;
		/** [Method] Sets the pointer offset  
		* @param iDeltaX Number the distance from the left 
		* @param iDeltaY Number the distance from the top 
		*/
		setDelta?( iDeltaX?:number, iDeltaY?:number ): void;
		/** [Method] Sets the drag element to the location of the mousedown or click event maintaining the cursor location relative to th  
		* @param iPageX Number the X coordinate of the mousedown or drag event 
		* @param iPageY Number the Y coordinate of the mousedown or drag event 
		*/
		setDragElPos?( iPageX?:number, iPageY?:number ): void;
		/** [Method] toString method 
		* @returns String string representation of the dd obj 
		*/
		toString?(): string;
	}
}
declare module Ext.dd {
	export interface IDDProxy extends Ext.dd.IDD {
		/** [Property] (Boolean) */
		centerFrame?: boolean;
		/** [Property] (Boolean) */
		resizeFrame?: boolean;
		/** [Property] (String) */
		dragElId?: string;
		/** [Method] Sets up config options specific to this class  */
		applyConfig?(): void;
		/** [Method] overrides Ext dd DragDrop 
		* @param e Object 
		*/
		b4MouseDown?( e?:any ): void;
		/** [Method] Creates the proxy element if it does not yet exist */
		createFrame?(): void;
		/** [Method] overrides Ext dd DragDrop By default we try to move the element to the last location of the frame  
		* @param e Object 
		*/
		endDrag?( e?:any ): void;
		/** [Method] Initialization for the drag frame element  */
		initFrame?(): void;
		/** [Method] toString method 
		* @returns String string representation of the dd obj 
		*/
		toString?(): string;
	}
}
declare module Ext.dd {
	export interface IDDTarget extends Ext.dd.IDragDrop {
		/** [Method] toString method 
		* @returns String string representation of the dd obj 
		*/
		toString?(): string;
	}
}
declare module Ext.dd {
	export interface IDragDrop extends Ext.IBase {
		/** [Property] (Boolean) */
		available?: boolean;
		/** [Property] (Object) */
		config?: any;
		/** [Property] (Object) */
		defaultPadding?: any;
		/** [Property] (Object) */
		groups?: any;
		/** [Property] (Boolean) */
		hasOuterHandles?: boolean;
		/** [Property] (String) */
		id?: string;
		/** [Property] (Boolean) */
		ignoreSelf?: boolean;
		/** [Property] (String[]) */
		invalidHandleClasses?: string[];
		/** [Property] (Object) */
		invalidHandleIds?: any;
		/** [Property] (Object) */
		invalidHandleTypes?: any;
		/** [Property] (Boolean) */
		isTarget?: boolean;
		/** [Property] (Boolean) */
		maintainOffset?: boolean;
		/** [Property] (Boolean) */
		moveOnly?: boolean;
		/** [Property] (Number[]) */
		padding?: number[];
		/** [Property] (Boolean) */
		primaryButtonOnly?: boolean;
		/** [Property] (Number[]) */
		xTicks?: number[];
		/** [Property] (Number[]) */
		yTicks?: number[];
		/** [Method] Lets you specify a css class of elements that will not initiate a drag 
		* @param cssClass String the class of the elements you wish to ignore 
		*/
		addInvalidHandleClass?( cssClass?:string ): void;
		/** [Method] Lets you to specify an element id for a child of a drag handle that should not initiate a drag 
		* @param id String the element id of the element you wish to ignore 
		*/
		addInvalidHandleId?( id?:string ): void;
		/** [Method] Allows you to specify a tag name that should not start a drag operation when clicked  
		* @param tagName String the type of element to exclude 
		*/
		addInvalidHandleType?( tagName?:string ): void;
		/** [Method] Adds this instance to a group of related drag drop objects  
		* @param sGroup String the name of the group 
		*/
		addToGroup?( sGroup?:string ): void;
		/** [Method] Applies the configuration parameters that were passed into the constructor  */
		applyConfig?(): void;
		/** [Method] Clears any constraints applied to this instance  */
		clearConstraints?(): void;
		/** [Method] Clears any tick interval defined for this instance */
		clearTicks?(): void;
		/** [Method] Initializes the drag drop object s constraints to restrict movement to a certain element  
		* @param constrainTo String/HTMLElement/Ext.Element The element or element ID to constrain to. 
		* @param pad Object/Number Pad provides a way to specify "padding" of the constraints, and can be either a number for symmetrical padding (4 would be equal to {left:4, right:4, top:4, bottom:4}) or an object containing the sides to pad. For example: {right:10, bottom:10} 
		* @param inContent Boolean Constrain the draggable in the content box of the element (inside padding and borders) 
		*/
		constrainTo?( constrainTo?:any, pad?:any, inContent?:boolean ): void;
		/** [Method] Destroy this DragDrop instance */
		destroy?(): void;
		/** [Method] Called when we are done dragging the object 
		* @param e Event the mouseup event 
		*/
		endDrag?( e?:Event ): void;
		/** [Method] Returns a reference to the actual element to drag  
		* @returns HTMLElement the html element 
		*/
		getDragEl?(): HTMLElement;
		/** [Method] Returns a reference to the linked element 
		* @returns HTMLElement the html element 
		*/
		getEl?(): HTMLElement;
		/** [Method] Sets up the DragDrop object  
		* @param id String the id of the linked element 
		* @param sGroup String the group of related items 
		* @param config Object configuration attributes 
		*/
		init?( id?:string, sGroup?:string, config?:any ): void;
		/** [Method] Initializes Targeting functionality only  
		* @param id String the id of the linked element 
		* @param sGroup String the group of related items 
		* @param config Object configuration attributes 
		*/
		initTarget?( id?:string, sGroup?:string, config?:any ): void;
		/** [Method] Returns true if this instance is locked or the drag drop mgr is locked meaning that all drag drop is disabled on th  
		* @returns Boolean true if this obj or all drag/drop is locked, else false 
		*/
		isLocked?(): boolean;
		/** [Method] Checks the tag exclusion list to see if this click should be ignored 
		* @param node HTMLElement the HTMLElement to evaluate 
		* @returns Boolean true if this is a valid tag type, false if not 
		*/
		isValidHandleChild?( node?:HTMLElement ): boolean;
		/** [Method] Locks this instance */
		lock?(): void;
		/** [Method] Override the onAvailable method to do what is needed after the initial position was determined  */
		onAvailable?(): void;
		/** [Method] Abstract method called during the onMouseMove event while dragging an object  
		* @param e Event the mousemove event 
		*/
		onDrag?( e?:Event ): void;
		/** [Method] Abstract method called when this item is dropped on another DragDrop obj 
		* @param e Event the mouseup event 
		* @param id String/Ext.dd.DragDrop[] In POINT mode, the element id this was dropped on. In INTERSECT mode, an array of dd items this was dropped on. 
		*/
		onDragDrop?( e?:Event, id?:any ): void;
		/** [Method] Abstract method called when this element fist begins hovering over another DragDrop obj 
		* @param e Event the mousemove event 
		* @param id String/Ext.dd.DragDrop[] In POINT mode, the element id this is hovering over. In INTERSECT mode, an array of one or more dragdrop items being hovered over. 
		*/
		onDragEnter?( e?:Event, id?:any ): void;
		/** [Method] Abstract method called when we are no longer hovering over an element 
		* @param e Event the mousemove event 
		* @param id String/Ext.dd.DragDrop[] In POINT mode, the element id this was hovering over. In INTERSECT mode, an array of dd items that the mouse is no longer over. 
		*/
		onDragOut?( e?:Event, id?:any ): void;
		/** [Method] Abstract method called when this element is hovering over another DragDrop obj 
		* @param e Event the mousemove event 
		* @param id String/Ext.dd.DragDrop[] In POINT mode, the element id this is hovering over. In INTERSECT mode, an array of dd items being hovered over. 
		*/
		onDragOver?( e?:Event, id?:any ): void;
		/** [Method] Abstract method called when this item is dropped on an area with no drop target 
		* @param e Event the mouseup event 
		*/
		onInvalidDrop?( e?:Event ): void;
		/** [Method] Called when a drag drop obj gets a mousedown 
		* @param e Event the mousedown event 
		*/
		onMouseDown?( e?:Event ): void;
		/** [Method] Called when a drag drop obj gets a mouseup 
		* @param e Event the mouseup event 
		*/
		onMouseUp?( e?:Event ): void;
		/** [Method] Removes this instance from the supplied interaction group 
		* @param sGroup String The group to drop 
		*/
		removeFromGroup?( sGroup?:string ): void;
		/** [Method] Unsets an invalid css class 
		* @param cssClass String the class of the element(s) you wish to re-enable 
		*/
		removeInvalidHandleClass?( cssClass?:string ): void;
		/** [Method] Unsets an invalid handle id 
		* @param id String the id of the element to re-enable 
		*/
		removeInvalidHandleId?( id?:string ): void;
		/** [Method] Unsets an excluded tag name set by addInvalidHandleType 
		* @param tagName String the type of element to unexclude 
		*/
		removeInvalidHandleType?( tagName?:string ): void;
		/** [Method] Must be called if you manually reposition a dd element  
		* @param maintainOffset Boolean 
		*/
		resetConstraints?( maintainOffset?:boolean ): void;
		/** [Method] Allows you to specify that an element other than the linked element will be moved with the cursor during a drag 
		* @param id String the id of the element that will be used to initiate the drag 
		*/
		setDragElId?( id?:string ): void;
		/** [Method] Allows you to specify a child of the linked element that should be used to initiate the drag operation  
		* @param id String the id of the element that will be used to initiate the drag. 
		*/
		setHandleElId?( id?:string ): void;
		/** [Method] Stores the initial placement of the linked element  
		* @param diffX Number the X offset, default 0 
		* @param diffY Number the Y offset, default 0 
		*/
		setInitPosition?( diffX?:number, diffY?:number ): void;
		/** [Method] Allows you to set an element outside of the linked element as a drag handle 
		* @param id String the id of the element that will be used to initiate the drag 
		*/
		setOuterHandleElId?( id?:string ): void;
		/** [Method] Configures the padding for the target zone in px  
		* @param iTop Number Top pad 
		* @param iRight Number Right pad 
		* @param iBot Number Bot pad 
		* @param iLeft Number Left pad 
		*/
		setPadding?( iTop?:number, iRight?:number, iBot?:number, iLeft?:number ): void;
		/** [Method] By default the element can be dragged any place on the screen  
		* @param iLeft Number the number of pixels the element can move to the left 
		* @param iRight Number the number of pixels the element can move to the right 
		* @param iTickSize Number parameter for specifying that the element should move iTickSize pixels at a time. 
		*/
		setXConstraint?( iLeft?:number, iRight?:number, iTickSize?:number ): void;
		/** [Method] By default the element can be dragged any place on the screen  
		* @param iUp Number the number of pixels the element can move up 
		* @param iDown Number the number of pixels the element can move down 
		* @param iTickSize Number parameter for specifying that the element should move iTickSize pixels at a time. 
		*/
		setYConstraint?( iUp?:number, iDown?:number, iTickSize?:number ): void;
		/** [Method] Abstract method called after a drag drop object is clicked and the drag or mousedown time thresholds have beeen met  
		* @param x Number X click location 
		* @param y Number Y click location 
		*/
		startDrag?( x?:number, y?:number ): void;
		/** [Method] toString method 
		* @returns String string representation of the dd obj 
		*/
		toString?(): string;
		/** [Method] Unlocks this instace */
		unlock?(): void;
		/** [Method] Removes all drag and drop hooks for this element */
		unreg?(): void;
	}
}
declare module Ext.dd {
	export interface IDragDropElement {
		/** [Method] Returns the X position of an html element 
		* @param el HTMLElement the element for which to get the position 
		* @returns Number the X coordinate 
		*/
		getPosX?( el?:HTMLElement ): number;
		/** [Method] Returns the Y position of an html element 
		* @param el HTMLElement the element for which to get the position 
		* @returns Number the Y coordinate 
		*/
		getPosY?( el?:HTMLElement ): number;
		/** [Method] Gets the scrollLeft 
		* @returns Number the document's scrollTop 
		*/
		getScrollLeft?(): number;
		/** [Method] Gets the scrollTop 
		* @returns Number the document's scrollTop 
		*/
		getScrollTop?(): number;
		/** [Method] Returns the specified element style property 
		* @param el HTMLElement the element 
		* @param styleProp String the style property 
		* @returns String The value of the style property 
		*/
		getStyle?( el?:HTMLElement, styleProp?:string ): string;
		/** [Method] Recursively searches the immediate parent and all child nodes for the handle element in order to determine wheter or 
		* @param node HTMLElement the html element to inspect 
		*/
		handleWasClicked?( node?:HTMLElement ): void;
		/** [Method] Sets the x y position of an element to the location of the target element  
		* @param moveEl HTMLElement The element to move 
		* @param targetEl HTMLElement The position reference element 
		*/
		moveToEl?( moveEl?:HTMLElement, targetEl?:HTMLElement ): void;
		/** [Method] Numeric array sort function 
		* @param a Number 
		* @param b Number 
		* @returns Number positive, negative or 0 
		*/
		numericSort?( a?:number, b?:number ): number;
		/** [Method] Swap two nodes  
		* @param n1 HTMLElement the first node to swap 
		* @param n2 HTMLElement the other node to swap 
		*/
		swapNode?( n1?:HTMLElement, n2?:HTMLElement ): void;
	}
}
declare module Ext.dd.dragdropmanager {
	export interface IElementWrapper {
		/** [Property] (Object) */
		css?: any;
		/** [Property] (Object) */
		el?: any;
		/** [Property] (Object) */
		id?: any;
	}
}
declare module Ext.dd {
	export interface IDragDropManager extends Ext.IBase {
	}
	export class DragDropManager {
		/** [Property] (Number) */
		static INTERSECT: number;
		/** [Property] (Number) */
		static POINT: number;
		/** [Property] (Number) */
		static clickPixelThresh: number;
		/** [Property] (Number) */
		static clickTimeThresh: number;
		/** [Property] (String) */
		static dragCls: string;
		/** [Property] (Number) */
		static mode: number;
		/** [Property] (Boolean) */
		static notifyOccluded: boolean;
		/** [Property] (Boolean) */
		static preventDefault: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static stopPropagation: boolean;
		/** [Property] (Boolean) */
		static useCache: boolean;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Helper function for getting the best match from the list of drag and drop objects returned by the drag and drop event  
		* @param dds Ext.dd.DragDrop[] The array of drag and drop objects targeted 
		* @returns Ext.dd.DragDrop The best single match 
		*/
		static getBestMatch( dds?:Ext.dd.IDragDrop[] ): Ext.dd.IDragDrop;
		/** [Method] Returns the style property for the DOM element i e  document getElById id style  
		* @param id String the id of the elment to get 
		* @returns Object The style property of the element 
		*/
		static getCss( id?:string ): any;
		/** [Method] Returns the DragDrop instance for a given id 
		* @param id String the id of the DragDrop object 
		* @returns Ext.dd.DragDrop the drag drop object, null if it is not found 
		*/
		static getDDById( id?:string ): Ext.dd.IDragDrop;
		/** [Method] Returns the actual DOM element 
		* @param id String the id of the elment to get 
		* @returns Object The element 
		*/
		static getElement( id?:string ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns a Region object containing the drag and drop element s position and size including the padding configured fo  
		* @param oDD Ext.dd.DragDrop the drag and drop object to get the location for. 
		* @returns Ext.util.Region a Region object representing the total area the element occupies, including any padding the instance is configured for. 
		*/
		static getLocation( oDD?:Ext.dd.IDragDrop ): Ext.util.IRegion;
		/** [Method] Returns the drag and drop instances that are in all groups the passed in instance belongs to  
		* @param p_oDD Ext.dd.DragDrop the obj to get related data for 
		* @param bTargetsOnly Boolean if true, only return targetable objs 
		* @returns Ext.dd.DragDrop[] the related instances 
		*/
		static getRelated( p_oDD?:Ext.dd.IDragDrop, bTargetsOnly?:boolean ): Ext.dd.IDragDrop[];
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Utility function to determine if a given element has been registered as a drag drop item  
		* @param id String the element id to check 
		* @returns Boolean true if this element is a DragDrop item, false otherwise 
		*/
		static isDragDrop( id?:string ): boolean;
		/** [Method] Utility function to determine if a given element has been registered as a drag drop handle for the given Drag Drop ob  
		* @param id String the element id to check 
		* @returns Boolean true if this element is a DragDrop handle, false otherwise 
		*/
		static isHandle( id?:string ): boolean;
		/** [Method] Returns true if the specified dd target is a legal target for the specifice drag obj 
		* @param oDD Ext.dd.DragDrop the drag obj 
		* @param oTargetDD Ext.dd.DragDrop the target 
		* @returns Boolean true if the target is a legal target for the dd obj 
		*/
		static isLegalTarget( oDD?:Ext.dd.IDragDrop, oTargetDD?:Ext.dd.IDragDrop ): boolean;
		/** [Method] Is drag and drop locked  
		* @returns Boolean True if drag and drop is locked, false otherwise. 
		*/
		static isLocked(): boolean;
		/** [Method] My goal is to be able to transparently determine if an object is typeof DragDrop and the exact subclass of DragDrop  
		* @param the Object object to evaluate 
		* @returns Boolean true if typeof oDD = DragDrop 
		*/
		static isTypeOfDD( the?:any ): boolean;
		/** [Method] Lock all drag and drop functionality */
		static lock(): void;
		/** [Method] Refreshes the cache of the top left and bottom right points of the drag and drop objects in the specified group s 
		* @param groups Object an associative array of groups to refresh 
		*/
		static refreshCache( groups?:any ): void;
		/** [Method] Each DragDrop instance must be registered with the DragDropManager  
		* @param oDD Ext.dd.DragDrop the DragDrop object to register 
		* @param sGroup String the name of the group this element belongs to 
		*/
		static regDragDrop( oDD?:Ext.dd.IDragDrop, sGroup?:string ): void;
		/** [Method] Each DragDrop handle element must be registered  
		* @param sDDId String the DragDrop id this element is a handle for 
		* @param sHandleId String the id of the element that is the drag handle 
		*/
		static regHandle( sDDId?:string, sHandleId?:string ): void;
		/** [Method] Fired when either the drag pixel threshold or the mousedown hold time threshold has been met  
		* @param x Number the X position of the original mousedown 
		* @param y Number the Y position of the original mousedown 
		*/
		static startDrag( x?:number, y?:number ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Utility to stop event propagation and event default if these features are turned on  
		* @param e Event the event as returned by this.getEvent() 
		*/
		static stopEvent( e?:Event ): void;
		/** [Method] Unlock all drag and drop functionality */
		static unlock(): void;
		/** [Method] This checks to make sure an element exists and is in the DOM  
		* @param el HTMLElement the element to check 
		* @returns Boolean true if the element looks usable 
		*/
		static verifyEl( el?:HTMLElement ): boolean;
	}
}
declare module Ext.dd {
	export interface IDragDropMgr extends Ext.IBase {
	}
	export class DragDropMgr {
		/** [Property] (Number) */
		static INTERSECT: number;
		/** [Property] (Number) */
		static POINT: number;
		/** [Property] (Number) */
		static clickPixelThresh: number;
		/** [Property] (Number) */
		static clickTimeThresh: number;
		/** [Property] (String) */
		static dragCls: string;
		/** [Property] (Number) */
		static mode: number;
		/** [Property] (Boolean) */
		static notifyOccluded: boolean;
		/** [Property] (Boolean) */
		static preventDefault: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static stopPropagation: boolean;
		/** [Property] (Boolean) */
		static useCache: boolean;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Helper function for getting the best match from the list of drag and drop objects returned by the drag and drop event  
		* @param dds Ext.dd.DragDrop[] The array of drag and drop objects targeted 
		* @returns Ext.dd.DragDrop The best single match 
		*/
		static getBestMatch( dds?:Ext.dd.IDragDrop[] ): Ext.dd.IDragDrop;
		/** [Method] Returns the style property for the DOM element i e  document getElById id style  
		* @param id String the id of the elment to get 
		* @returns Object The style property of the element 
		*/
		static getCss( id?:string ): any;
		/** [Method] Returns the DragDrop instance for a given id 
		* @param id String the id of the DragDrop object 
		* @returns Ext.dd.DragDrop the drag drop object, null if it is not found 
		*/
		static getDDById( id?:string ): Ext.dd.IDragDrop;
		/** [Method] Returns the actual DOM element 
		* @param id String the id of the elment to get 
		* @returns Object The element 
		*/
		static getElement( id?:string ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns a Region object containing the drag and drop element s position and size including the padding configured fo  
		* @param oDD Ext.dd.DragDrop the drag and drop object to get the location for. 
		* @returns Ext.util.Region a Region object representing the total area the element occupies, including any padding the instance is configured for. 
		*/
		static getLocation( oDD?:Ext.dd.IDragDrop ): Ext.util.IRegion;
		/** [Method] Returns the drag and drop instances that are in all groups the passed in instance belongs to  
		* @param p_oDD Ext.dd.DragDrop the obj to get related data for 
		* @param bTargetsOnly Boolean if true, only return targetable objs 
		* @returns Ext.dd.DragDrop[] the related instances 
		*/
		static getRelated( p_oDD?:Ext.dd.IDragDrop, bTargetsOnly?:boolean ): Ext.dd.IDragDrop[];
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Utility function to determine if a given element has been registered as a drag drop item  
		* @param id String the element id to check 
		* @returns Boolean true if this element is a DragDrop item, false otherwise 
		*/
		static isDragDrop( id?:string ): boolean;
		/** [Method] Utility function to determine if a given element has been registered as a drag drop handle for the given Drag Drop ob  
		* @param id String the element id to check 
		* @returns Boolean true if this element is a DragDrop handle, false otherwise 
		*/
		static isHandle( id?:string ): boolean;
		/** [Method] Returns true if the specified dd target is a legal target for the specifice drag obj 
		* @param oDD Ext.dd.DragDrop the drag obj 
		* @param oTargetDD Ext.dd.DragDrop the target 
		* @returns Boolean true if the target is a legal target for the dd obj 
		*/
		static isLegalTarget( oDD?:Ext.dd.IDragDrop, oTargetDD?:Ext.dd.IDragDrop ): boolean;
		/** [Method] Is drag and drop locked  
		* @returns Boolean True if drag and drop is locked, false otherwise. 
		*/
		static isLocked(): boolean;
		/** [Method] My goal is to be able to transparently determine if an object is typeof DragDrop and the exact subclass of DragDrop  
		* @param the Object object to evaluate 
		* @returns Boolean true if typeof oDD = DragDrop 
		*/
		static isTypeOfDD( the?:any ): boolean;
		/** [Method] Lock all drag and drop functionality */
		static lock(): void;
		/** [Method] Refreshes the cache of the top left and bottom right points of the drag and drop objects in the specified group s 
		* @param groups Object an associative array of groups to refresh 
		*/
		static refreshCache( groups?:any ): void;
		/** [Method] Each DragDrop instance must be registered with the DragDropManager  
		* @param oDD Ext.dd.DragDrop the DragDrop object to register 
		* @param sGroup String the name of the group this element belongs to 
		*/
		static regDragDrop( oDD?:Ext.dd.IDragDrop, sGroup?:string ): void;
		/** [Method] Each DragDrop handle element must be registered  
		* @param sDDId String the DragDrop id this element is a handle for 
		* @param sHandleId String the id of the element that is the drag handle 
		*/
		static regHandle( sDDId?:string, sHandleId?:string ): void;
		/** [Method] Fired when either the drag pixel threshold or the mousedown hold time threshold has been met  
		* @param x Number the X position of the original mousedown 
		* @param y Number the Y position of the original mousedown 
		*/
		static startDrag( x?:number, y?:number ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Utility to stop event propagation and event default if these features are turned on  
		* @param e Event the event as returned by this.getEvent() 
		*/
		static stopEvent( e?:Event ): void;
		/** [Method] Unlock all drag and drop functionality */
		static unlock(): void;
		/** [Method] This checks to make sure an element exists and is in the DOM  
		* @param el HTMLElement the element to check 
		* @returns Boolean true if the element looks usable 
		*/
		static verifyEl( el?:HTMLElement ): boolean;
	}
}
declare module Ext.dd {
	export interface IDDM extends Ext.IBase {
	}
	export class DDM {
		/** [Property] (Number) */
		static INTERSECT: number;
		/** [Property] (Number) */
		static POINT: number;
		/** [Property] (Number) */
		static clickPixelThresh: number;
		/** [Property] (Number) */
		static clickTimeThresh: number;
		/** [Property] (String) */
		static dragCls: string;
		/** [Property] (Number) */
		static mode: number;
		/** [Property] (Boolean) */
		static notifyOccluded: boolean;
		/** [Property] (Boolean) */
		static preventDefault: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static stopPropagation: boolean;
		/** [Property] (Boolean) */
		static useCache: boolean;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Helper function for getting the best match from the list of drag and drop objects returned by the drag and drop event  
		* @param dds Ext.dd.DragDrop[] The array of drag and drop objects targeted 
		* @returns Ext.dd.DragDrop The best single match 
		*/
		static getBestMatch( dds?:Ext.dd.IDragDrop[] ): Ext.dd.IDragDrop;
		/** [Method] Returns the style property for the DOM element i e  document getElById id style  
		* @param id String the id of the elment to get 
		* @returns Object The style property of the element 
		*/
		static getCss( id?:string ): any;
		/** [Method] Returns the DragDrop instance for a given id 
		* @param id String the id of the DragDrop object 
		* @returns Ext.dd.DragDrop the drag drop object, null if it is not found 
		*/
		static getDDById( id?:string ): Ext.dd.IDragDrop;
		/** [Method] Returns the actual DOM element 
		* @param id String the id of the elment to get 
		* @returns Object The element 
		*/
		static getElement( id?:string ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns a Region object containing the drag and drop element s position and size including the padding configured fo  
		* @param oDD Ext.dd.DragDrop the drag and drop object to get the location for. 
		* @returns Ext.util.Region a Region object representing the total area the element occupies, including any padding the instance is configured for. 
		*/
		static getLocation( oDD?:Ext.dd.IDragDrop ): Ext.util.IRegion;
		/** [Method] Returns the drag and drop instances that are in all groups the passed in instance belongs to  
		* @param p_oDD Ext.dd.DragDrop the obj to get related data for 
		* @param bTargetsOnly Boolean if true, only return targetable objs 
		* @returns Ext.dd.DragDrop[] the related instances 
		*/
		static getRelated( p_oDD?:Ext.dd.IDragDrop, bTargetsOnly?:boolean ): Ext.dd.IDragDrop[];
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Utility function to determine if a given element has been registered as a drag drop item  
		* @param id String the element id to check 
		* @returns Boolean true if this element is a DragDrop item, false otherwise 
		*/
		static isDragDrop( id?:string ): boolean;
		/** [Method] Utility function to determine if a given element has been registered as a drag drop handle for the given Drag Drop ob  
		* @param id String the element id to check 
		* @returns Boolean true if this element is a DragDrop handle, false otherwise 
		*/
		static isHandle( id?:string ): boolean;
		/** [Method] Returns true if the specified dd target is a legal target for the specifice drag obj 
		* @param oDD Ext.dd.DragDrop the drag obj 
		* @param oTargetDD Ext.dd.DragDrop the target 
		* @returns Boolean true if the target is a legal target for the dd obj 
		*/
		static isLegalTarget( oDD?:Ext.dd.IDragDrop, oTargetDD?:Ext.dd.IDragDrop ): boolean;
		/** [Method] Is drag and drop locked  
		* @returns Boolean True if drag and drop is locked, false otherwise. 
		*/
		static isLocked(): boolean;
		/** [Method] My goal is to be able to transparently determine if an object is typeof DragDrop and the exact subclass of DragDrop  
		* @param the Object object to evaluate 
		* @returns Boolean true if typeof oDD = DragDrop 
		*/
		static isTypeOfDD( the?:any ): boolean;
		/** [Method] Lock all drag and drop functionality */
		static lock(): void;
		/** [Method] Refreshes the cache of the top left and bottom right points of the drag and drop objects in the specified group s 
		* @param groups Object an associative array of groups to refresh 
		*/
		static refreshCache( groups?:any ): void;
		/** [Method] Each DragDrop instance must be registered with the DragDropManager  
		* @param oDD Ext.dd.DragDrop the DragDrop object to register 
		* @param sGroup String the name of the group this element belongs to 
		*/
		static regDragDrop( oDD?:Ext.dd.IDragDrop, sGroup?:string ): void;
		/** [Method] Each DragDrop handle element must be registered  
		* @param sDDId String the DragDrop id this element is a handle for 
		* @param sHandleId String the id of the element that is the drag handle 
		*/
		static regHandle( sDDId?:string, sHandleId?:string ): void;
		/** [Method] Fired when either the drag pixel threshold or the mousedown hold time threshold has been met  
		* @param x Number the X position of the original mousedown 
		* @param y Number the Y position of the original mousedown 
		*/
		static startDrag( x?:number, y?:number ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Utility to stop event propagation and event default if these features are turned on  
		* @param e Event the event as returned by this.getEvent() 
		*/
		static stopEvent( e?:Event ): void;
		/** [Method] Unlock all drag and drop functionality */
		static unlock(): void;
		/** [Method] This checks to make sure an element exists and is in the DOM  
		* @param el HTMLElement the element to check 
		* @returns Boolean true if the element looks usable 
		*/
		static verifyEl( el?:HTMLElement ): boolean;
	}
}
declare module Ext.dd {
	export interface IDragSource extends Ext.dd.IDDProxy {
		/** [Config Option] (Boolean) */
		animRepair?: boolean;
		/** [Config Option] (String) */
		ddGroup?: string;
		/** [Config Option] (String) */
		dropAllowed?: string;
		/** [Config Option] (String) */
		dropNotAllowed?: string;
		/** [Config Option] (String) */
		repairHighlightColor?: string;
		/** [Property] (Object) */
		dragData?: any;
		/** [Method] An empty function by default but provided so that you can perform a custom action after a valid drag drop has occurr  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dropped element 
		*/
		afterDragDrop?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action when the dragged item enters the d  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		*/
		afterDragEnter?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action after the dragged item is dragged 
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		*/
		afterDragOut?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action while the dragged item is over the  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		*/
		afterDragOver?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action after an invalid drop has occurred  
		* @param e Event The event object 
		* @param id String The id of the dropped element 
		*/
		afterInvalidDrop?( e?:Event, id?:string ): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action after a valid drop has occurred by  
		* @param target Object The target DD 
		* @param e Event The event object 
		* @param id String The id of the dropped element 
		*/
		afterValidDrop?( target?:any, e?:Event, id?:string ): void;
		/** [Method] Sets the element to the location of the mousedown or click event maintaining the cursor location relative to the loc  */
		alignElWithMouse?(): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action before the dragged item is dropped  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		* @returns Boolean isValid True if the drag drop event is valid, else false to cancel 
		*/
		beforeDragDrop?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): boolean;
		/** [Method] An empty function by default but provided so that you can perform a custom action before the dragged item enters the  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		* @returns Boolean isValid True if the drag event is valid, else false to cancel 
		*/
		beforeDragEnter?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): boolean;
		/** [Method] An empty function by default but provided so that you can perform a custom action before the dragged item is dragged  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		* @returns Boolean isValid True if the drag event is valid, else false to cancel 
		*/
		beforeDragOut?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): boolean;
		/** [Method] An empty function by default but provided so that you can perform a custom action while the dragged item is over the  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		* @returns Boolean isValid True if the drag event is valid, else false to cancel 
		*/
		beforeDragOver?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): boolean;
		/** [Method] An empty function by default but provided so that you can perform a custom action after an invalid drop has occurred  
		* @param target Ext.dd.DragDrop The drop target 
		* @param e Event The event object 
		* @param id String The id of the dragged element 
		* @returns Boolean isValid True if the invalid drop should proceed, else false to cancel 
		*/
		beforeInvalidDrop?( target?:Ext.dd.IDragDrop, e?:Event, id?:string ): boolean;
		/** [Method] Destroy this DragDrop instance */
		destroy?(): void;
		/** [Method] Returns the data object associated with this drag source 
		* @param e Object 
		* @returns Object data An object containing arbitrary data 
		*/
		getDragData?( e?:any ): any;
		/** [Method] Returns the drag source s underlying Ext dd StatusProxy 
		* @returns Ext.dd.StatusProxy proxy The StatusProxy 
		*/
		getProxy?(): Ext.dd.IStatusProxy;
		/** [Method] Hides the drag source s Ext dd StatusProxy */
		hideProxy?(): void;
		/** [Method] An empty function by default but provided so that you can perform a custom action before the initial drag event begi  
		* @param data Object An object containing arbitrary data to be shared with drop targets 
		* @param e Event The event object 
		* @returns Boolean isValid True if the drag event is valid, else false to cancel 
		*/
		onBeforeDrag?( data?:any, e?:Event ): boolean;
		/** [Method] An empty function by default but provided so that you can perform a custom action once the initial drag event has be  
		* @param x Number The x position of the click on the dragged object 
		* @param y Number The y position of the click on the dragged object 
		*/
		onStartDrag?( x?:number, y?:number ): void;
	}
}
declare module Ext.dd {
	export interface IDragTracker extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (Boolean/Number) */
		autoStart?: any;
		/** [Config Option] (Ext.util.Region/Ext.Element) */
		constrainTo?: any;
		/** [Config Option] (String) */
		delegate?: string;
		/** [Config Option] (String) */
		overCls?: string;
		/** [Config Option] (Boolean) */
		preventDefault?: boolean;
		/** [Config Option] (Boolean) */
		stopEvent?: boolean;
		/** [Config Option] (Number) */
		tolerance?: number;
		/** [Config Option] (Boolean) */
		trackOver?: boolean;
		/** [Property] (Boolean) */
		active?: boolean;
		/** [Property] (HTMLElement) */
		dragTarget?: HTMLElement;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the drag target  
		* @returns Ext.Element The element currently being tracked. 
		*/
		getDragTarget?(): Ext.IElement;
		/** [Method] Returns the X Y offset of the current mouse position from the mousedown point  
		* @param constrainMode String If omitted the true mouse position is returned. May be passed as point or dragTarget. See above. 
		* @returns Number[] The X, Y offset from the mousedown point, optionally constrained. 
		*/
		getOffset?( constrainMode?:string ): number[];
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Initializes the DragTracker on a given element  
		* @param el Ext.Element/HTMLElement The element 
		*/
		initEl?( el?:any ): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Template method which should be overridden by each DragTracker instance  
		* @param e Ext.EventObject The event object 
		*/
		onBeforeStart?( e?:Ext.IEventObject ): void;
		/** [Method] Template method which should be overridden by each DragTracker instance  
		* @param e Ext.EventObject The event object 
		*/
		onDrag?( e?:Ext.IEventObject ): void;
		/** [Method] Template method which should be overridden by each DragTracker instance  
		* @param e Ext.EventObject The event object 
		*/
		onEnd?( e?:Ext.IEventObject ): void;
		/** [Method] Template method which should be overridden by each DragTracker instance  
		* @param e Ext.EventObject The event object 
		*/
		onStart?( e?:Ext.IEventObject ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.dd {
	export interface IDragZone extends Ext.dd.IDragSource {
		/** [Config Option] (Object/Boolean) */
		containerScroll?: any;
		/** [Config Option] (String/HTMLElement/Ext.dom.Element) */
		scrollEl?: any;
		/** [Method] Destroy this DragDrop instance */
		destroy?(): void;
		/** [Method] Called when a mousedown occurs in this container  
		* @param e Event The mouse down event 
		* @returns Object The dragData 
		*/
		getDragData?( e?:Event ): any;
		/** [Method] Called before a repair of an invalid drop to get the XY to animate to  
		* @param e Event The mouse up event 
		* @returns Number[] The xy location (e.g. [100, 200]) 
		*/
		getRepairXY?( e?:Event ): number[];
		/** [Method] Called once drag threshold has been reached to initialize the proxy element  
		* @param x Number The x position of the click on the dragged object 
		* @param y Number The y position of the click on the dragged object 
		* @returns Boolean true to continue the drag, false to cancel 
		*/
		onInitDrag?( x?:number, y?:number ): boolean;
	}
}
declare module Ext.dd {
	export interface IDropTarget extends Ext.dd.IDDTarget {
		/** [Config Option] (String) */
		ddGroup?: string;
		/** [Config Option] (String) */
		dropAllowed?: string;
		/** [Config Option] (String) */
		dropNotAllowed?: string;
		/** [Config Option] (String) */
		overClass?: string;
		/** [Property] (Boolean) */
		isTarget?: boolean;
		/** [Method] Destroy this DragDrop instance */
		destroy?(): void;
		/** [Method] The function a Ext dd DragSource calls once to notify this drop target that the dragged item has been dropped on it  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop target 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns Boolean False if the drop was invalid. 
		*/
		notifyDrop?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): boolean;
		/** [Method] The function a Ext dd DragSource calls once to notify this drop target that the source is now over the target  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop target 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns String status The CSS class that communicates the drop status back to the source so that the underlying Ext.dd.StatusProxy can be updated 
		*/
		notifyEnter?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): string;
		/** [Method] The function a Ext dd DragSource calls once to notify this drop target that the source has been dragged out of the ta  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop target 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		*/
		notifyOut?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): void;
		/** [Method] The function a Ext dd DragSource calls continuously while it is being dragged over the target  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop target 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns String status The CSS class that communicates the drop status back to the source so that the underlying Ext.dd.StatusProxy can be updated 
		*/
		notifyOver?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): string;
	}
}
declare module Ext.dd {
	export interface IDropZone extends Ext.dd.IDropTarget {
		/** [Method] Returns a custom data object associated with the DOM node that is the target of the event  
		* @param e Event The event 
		* @returns Object data The custom data 
		*/
		getTargetFromEvent?( e?:Event ): any;
		/** [Method] The function a Ext dd DragSource calls once to notify this drop zone that the dragged item has been dropped on it  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns Boolean False if the drop was invalid. 
		*/
		notifyDrop?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): boolean;
		/** [Method] The function a Ext dd DragSource calls once to notify this drop zone that the source is now over the zone  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns String status The CSS class that communicates the drop status back to the source so that the underlying Ext.dd.StatusProxy can be updated 
		*/
		notifyEnter?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): string;
		/** [Method] The function a Ext dd DragSource calls once to notify this drop zone that the source has been dragged out of the zone  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop target 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag zone 
		*/
		notifyOut?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): void;
		/** [Method] The function a Ext dd DragSource calls continuously while it is being dragged over the drop zone  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns String status The CSS class that communicates the drop status back to the source so that the underlying Ext.dd.StatusProxy can be updated 
		*/
		notifyOver?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): string;
		/** [Method] Called when the DropZone determines that a Ext dd DragSource has been dropped on it but not on any of its registered  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns Boolean True if the drop was valid, else false 
		*/
		onContainerDrop?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): boolean;
		/** [Method] Called while the DropZone determines that a Ext dd DragSource is being dragged over it but not over any of its regis  
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns String status The CSS class that communicates the drop status back to the source so that the underlying Ext.dd.StatusProxy can be updated 
		*/
		onContainerOver?( source?:Ext.dd.IDragSource, e?:Event, data?:any ): string;
		/** [Method] Called when the DropZone determines that a Ext dd DragSource has been dropped onto the drop node  
		* @param nodeData Object The custom data associated with the drop node (this is the same value returned from getTargetFromEvent for this node) 
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns Boolean True if the drop was valid, else false 
		*/
		onNodeDrop?( nodeData?:any, source?:Ext.dd.IDragSource, e?:Event, data?:any ): boolean;
		/** [Method] Called when the DropZone determines that a Ext dd DragSource has entered a drop node that has either been registered 
		* @param nodeData Object The custom data associated with the drop node (this is the same value returned from getTargetFromEvent for this node) 
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		*/
		onNodeEnter?( nodeData?:any, source?:Ext.dd.IDragSource, e?:Event, data?:any ): void;
		/** [Method] Called when the DropZone determines that a Ext dd DragSource has been dragged out of the drop node without dropping  
		* @param nodeData Object The custom data associated with the drop node (this is the same value returned from getTargetFromEvent for this node) 
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		*/
		onNodeOut?( nodeData?:any, source?:Ext.dd.IDragSource, e?:Event, data?:any ): void;
		/** [Method] Called while the DropZone determines that a Ext dd DragSource is over a drop node that has either been registered or 
		* @param nodeData Object The custom data associated with the drop node (this is the same value returned from getTargetFromEvent for this node) 
		* @param source Ext.dd.DragSource The drag source that was dragged over this drop zone 
		* @param e Event The event 
		* @param data Object An object containing arbitrary data supplied by the drag source 
		* @returns String status The CSS class that communicates the drop status back to the source so that the underlying Ext.dd.StatusProxy can be updated 
		*/
		onNodeOver?( nodeData?:any, source?:Ext.dd.IDragSource, e?:Event, data?:any ): string;
	}
}
declare module Ext.dd {
	export interface IRegistry extends Ext.IBase {
	}
	export class Registry {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the handle registered for a DOM Node by id 
		* @param id String/HTMLElement The DOM node or id to look up 
		* @returns Object handle The custom handle data 
		*/
		static getHandle( id?:any ): any;
		/** [Method] Returns the handle that is registered for the DOM node that is the target of the event 
		* @param e Event The event 
		* @returns Object handle The custom handle data 
		*/
		static getHandleFromEvent( e?:Event ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns a custom data object that is registered for a DOM node by id 
		* @param id String/HTMLElement The DOM node or id to look up 
		* @returns Object data The custom data 
		*/
		static getTarget( id?:any ): any;
		/** [Method] Returns a custom data object that is registered for the DOM node that is the target of the event 
		* @param e Event The event 
		* @returns Object data The custom data 
		*/
		static getTargetFromEvent( e?:Event ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Registers a drag drop element  
		* @param element String/HTMLElement The id or DOM node to register 
		* @param data Object An custom data object that will be passed between the elements that are involved in drag drop operations. You can populate this object with any arbitrary properties that your own code knows how to interpret, plus there are some specific properties known to the Registry that should be populated in the data object (if applicable): 
		*/
		static register( element?:any, data?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregister a drag drop element 
		* @param element String/HTMLElement The id or DOM node to unregister 
		*/
		static unregister( element?:any ): void;
	}
}
declare module Ext.dd {
	export interface IScrollManager extends Ext.IBase {
	}
	export class ScrollManager {
		/** [Property] (Number) */
		static animDuration: number;
		/** [Property] (Boolean) */
		static animate: boolean;
		/** [Property] (String) */
		static ddGroup: string;
		/** [Property] (Number) */
		static frequency: number;
		/** [Property] (Number) */
		static hthresh: number;
		/** [Property] (Number) */
		static increment: number;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Number) */
		static vthresh: number;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Manually trigger a cache refresh  */
		static refreshCache(): void;
		/** [Method] Registers new overflow element s to auto scroll 
		* @param el String/HTMLElement/Ext.Element/String[]/HTMLElement[]/Ext.Element[] The id of or the element to be scrolled or an array of either 
		*/
		static register( el?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters overflow element s so they are no longer scrolled 
		* @param el String/HTMLElement/Ext.Element/String[]/HTMLElement[]/Ext.Element[] The id of or the element to be removed or an array of either 
		*/
		static unregister( el?:any ): void;
	}
}
declare module Ext.dd {
	export interface IStatusProxy extends Ext.IComponent {
		/** [Config Option] (String) */
		dropAllowed?: string;
		/** [Config Option] (String) */
		dropNotAllowed?: string;
		/** [Config Option] (Ext.XTemplate/String/String[]) */
		renderTpl?: any;
		/** [Method] Returns the ghost element 
		* @returns Ext.Element el 
		*/
		getGhost?(): Ext.IElement;
		/** [Method] Causes the proxy to return to its position of origin via an animation  
		* @param xy Number[] The XY position of the element ([x, y]) 
		* @param callback Function The function to call after the repair is complete. 
		* @param scope Object The scope (this reference) in which the callback function is executed. Defaults to the browser window. 
		*/
		repair?( xy?:number[], callback?:any, scope?:any ): void;
		/** [Method] Resets the status indicator to the default dropNotAllowed value 
		* @param clearGhost Boolean True to also remove all content from the ghost, false to preserve it 
		*/
		reset?( clearGhost?:boolean ): void;
		/** [Method] Updates the proxy s visual element to indicate the status of whether or not drop is allowed over the current target e  
		* @param cssClass String The css class for the new drop status indicator image 
		*/
		setStatus?( cssClass?:string ): void;
		/** [Method] Stops the repair animation if it s currently running */
		stop?(): void;
		/** [Method] Force the Layer to sync its shadow and shim positions to the element */
		sync?(): void;
		/** [Method] Updates the contents of the ghost element 
		* @param html String/HTMLElement The html that will replace the current innerHTML of the ghost element, or a DOM node to append as the child of the ghost element (in which case the innerHTML will be cleared first). 
		*/
		update?( html?:any ): void;
	}
}
declare module Ext.direct {
	export interface IEvent extends Ext.IBase {
		/** [Method] Return the raw data for this event  
		* @returns Mixed The data from the event 
		*/
		getData?(): any;
		/** [Method] Return the name for this event  
		* @returns String The name of event 
		*/
		getName?(): string;
	}
}
declare module Ext.direct {
	export interface IExceptionEvent extends Ext.direct.IRemotingEvent {
	}
}
declare module Ext.direct {
	export interface IJsonProvider extends Ext.direct.IProvider {
		/** [Method] Create an event from a response object 
		* @param response Object Response object 
		* @returns Ext.direct.Event The event 
		*/
		createEvent?( response?:any ): Ext.direct.IEvent;
		/** [Method] Creates a set of events based on the XHR response 
		* @param response Object The XHR response 
		* @returns Ext.direct.Event[] An array of Ext.direct.Event 
		*/
		createEvents?( response?:any ): Ext.direct.IEvent[];
	}
}
declare module Ext.direct {
	export interface IManager extends Ext.IBase,Ext.util.IObservable {
	}
	export class Manager {
		/** [Property] (Object) */
		static exceptions: any;
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds an Ext Direct Provider and creates the proxy or stub methods to execute server side methods  
		* @param provider Ext.direct.Provider/Object... Accepts any number of Provider descriptions (an instance or config object for a Provider). Each Provider description instructs Ext.Direct how to create client-side stub methods. 
		*/
		static addProvider( provider?:any ): void;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Retrieves a provider by the id specified when the provider is added  
		* @param id String/Ext.direct.Provider The id of the provider, or the provider instance. 
		*/
		static getProvider( id?:any ): void;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Parses a direct function  
		* @param fn String/Function The direct function 
		* @returns Function The function to use in the direct call. Null if not found 
		*/
		static parseMethod( fn?:any ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Removes the provider  
		* @param provider String/Ext.direct.Provider The provider instance or the id of the provider. 
		* @returns Ext.direct.Provider The provider, null if not found. 
		*/
		static removeProvider( provider?:any ): Ext.direct.IProvider;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext {
	export interface IDirect extends Ext.IBase,Ext.util.IObservable {
	}
	export class Direct {
		/** [Property] (Object) */
		static exceptions: any;
		/** [Property] (Object) */
		static hasListeners: any;
		/** [Property] (Boolean) */
		static isObservable: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static addManagedListener( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds an Ext Direct Provider and creates the proxy or stub methods to execute server side methods  
		* @param provider Ext.direct.Provider/Object... Accepts any number of Provider descriptions (an instance or config object for a Provider). Each Provider description instructs Ext.Direct how to create client-side stub methods. 
		*/
		static addProvider( provider?:any ): void;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		static clearListeners(): void;
		/** [Method] Removes all managed listeners for this object  */
		static clearManagedListeners(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		static fireEventArgs( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Retrieves a provider by the id specified when the provider is added  
		* @param id String/Ext.direct.Provider The id of the provider, or the provider instance. 
		*/
		static getProvider( id?:any ): void;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static mon( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static mun( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Parses a direct function  
		* @param fn String/Function The direct function 
		* @returns Function The function to use in the direct call. Null if not found 
		*/
		static parseMethod( fn?:any ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		static relayEvents( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static removeListener( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		static removeManagedListener( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Removes the provider  
		* @param provider String/Ext.direct.Provider The provider instance or the id of the provider. 
		* @returns Ext.direct.Provider The provider, null if not found. 
		*/
		static removeProvider( provider?:any ): Ext.direct.IProvider;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		static resumeEvent( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		static resumeEvents(): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		static suspendEvent( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		static suspendEvents( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		static un( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.direct {
	export interface IPollingProvider extends Ext.direct.IJsonProvider {
		/** [Config Option] (Object) */
		baseParams?: any;
		/** [Config Option] (Number) */
		interval?: number;
		/** [Config Option] (String/Function) */
		url?: any;
		/** [Method] Connect to the server side and begin the polling process  */
		connect?(): void;
		/** [Method] Disconnect from the server side and stop the polling process  */
		disconnect?(): void;
		/** [Method] Returns whether or not the server side is currently connected  */
		isConnected?(): void;
	}
}
declare module Ext.direct {
	export interface IProvider extends Ext.IBase,Ext.util.IObservable {
		/** [Config Option] (String) */
		id?: string;
		/** [Config Option] (String[]) */
		relayedEvents?: string[];
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Abstract method for subclasses to implement  */
		connect?(): void;
		/** [Method] Abstract method for subclasses to implement  */
		disconnect?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Returns whether or not the server side is currently connected  */
		isConnected?(): void;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes an event handler  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): void;
		/** [Method] Removes listeners that were added by the mon method  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		removeManagedListener?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing of the named event s 
		* @param eventName String... Multiple event names to resume. 
		*/
		resumeEvent?( ...eventName:any[] ): void;
		/** [Method] Resumes firing events see suspendEvents */
		resumeEvents?(): void;
		/** [Method] Suspends firing of the named event s 
		* @param eventName String... Multiple event names to suspend. 
		*/
		suspendEvent?( ...eventName:any[] ): void;
		/** [Method] Suspends the firing of all events  
		* @param queueSuspended Boolean Pass as true to queue up suspended events to be fired after the resumeEvents call instead of discarding all suspended events. 
		*/
		suspendEvents?( queueSuspended?:boolean ): void;
		/** [Method] Shorthand for removeListener  
		* @param eventName String The type of event the handler was associated with. 
		* @param fn Function The handler to remove. This must be a reference to the function passed into the Ext.util.Observable.addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to Ext.util.Observable.addListener or the listener will not be removed. 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): void;
	}
}
declare module Ext.direct {
	export interface IRemotingEvent extends Ext.direct.IEvent {
		/** [Method] Get the transaction associated with this event  
		* @returns Ext.direct.Transaction The transaction 
		*/
		getTransaction?(): Ext.direct.ITransaction;
	}
}
declare module Ext.direct {
	export interface IRemotingMethod extends Ext.IBase {
		/** [Method] Takes the arguments for the Direct function and splits the arguments from the scope and the callback  
		* @param args Array The arguments passed to the direct call 
		* @returns Object An object with 3 properties: args, callback &amp; scope. 
		*/
		getCallData?( args?:any[] ): any;
	}
}
declare module Ext.direct {
	export interface IRemotingProvider extends Ext.direct.IJsonProvider {
		/** [Config Option] (Object) */
		actions?: any;
		/** [Config Option] (Boolean) */
		disableNestedActions?: boolean;
		/** [Config Option] (Number/Boolean) */
		enableBuffer?: any;
		/** [Config Option] (String) */
		enableUrlEncode?: string;
		/** [Config Option] (Number) */
		maxRetries?: number;
		/** [Config Option] (String/Object) */
		namespace?: any;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Abstract method for subclasses to implement  */
		connect?(): void;
		/** [Method] Abstract method for subclasses to implement  */
		disconnect?(): void;
		/** [Method] Returns whether or not the server side is currently connected  */
		isConnected?(): void;
	}
}
declare module Ext.direct {
	export interface ITransaction extends Ext.IBase {
		/** [Config Option] (Ext.direct.Provider) */
		provider?: Ext.direct.IProvider;
	}
}
declare module Ext.dom {
	export interface IAbstractElement extends Ext.IBase {
		/** [Property] (String) */
		defaultUnit?: string;
		/** [Property] (HTMLElement) */
		dom?: HTMLElement;
		/** [Property] (String) */
		id?: string;
		/** [Property] (Number) */
		ASCLASS?: number;
		/** [Property] (Number) */
		DISPLAY?: number;
		/** [Property] (Number) */
		OFFSETS?: number;
		/** [Property] (Number) */
		VISIBILITY?: number;
		/** [Method] Adds one or more CSS classes to the element  
		* @param className String/String[] The CSS classes to add separated by space, or an array of classes 
		* @returns Ext.dom.Element this 
		*/
		addCls?( className?:any ): Ext.dom.IElement;
		/** [Method] Appends the passed element s to this element Defined in override Ext dom AbstractElement_insertion  
		* @param el String/HTMLElement/Ext.dom.AbstractElement/Object The id or element to insert or a DomHelper config The id of the node, a DOM Node or an existing Element. 
		* @param returnDom Boolean True to return the raw DOM element instead of Ext.dom.AbstractElement 
		* @returns Ext.dom.AbstractElement The inserted Element. 
		*/
		appendChild?( el?:any, returnDom?:boolean ): Ext.dom.IAbstractElement;
		/** [Method] Appends this element to the passed element Defined in override Ext dom AbstractElement_insertion  
		* @param el String/HTMLElement/Ext.dom.AbstractElement The new parent element. The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.AbstractElement This element 
		*/
		appendTo?( el?:any ): Ext.dom.IAbstractElement;
		/** [Method] More flexible version of setStyle for setting style properties  
		* @param styles String/Object/Function A style specification string, e.g. "width:100px", or object in the form {width:"100px"}, or a function which returns such a specification. 
		* @returns Ext.dom.Element this 
		*/
		applyStyles?( styles?:any ): Ext.dom.IElement;
		/** [Method] Selects a single direct child based on the passed CSS selector the selector should not contain an id 
		* @param selector String The CSS selector 
		* @param returnDom Boolean True to return the DOM node instead of Ext.dom.Element. 
		* @returns HTMLElement/Ext.dom.Element The child Ext.dom.Element (or DOM node if returnDom = true) 
		*/
		child?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Returns true if this element is an ancestor of the passed element 
		* @param el HTMLElement/String The element to check 
		* @returns Boolean True if this element is an ancestor of el, else false 
		*/
		contains?( el?:any ): boolean;
		/** [Method] Creates the passed DomHelper config and appends it to this element or optionally inserts it before the passed child e  
		* @param config Object DomHelper element config object. If no tag is specified (e.g., {tag:'input'}) then a div will be automatically generated with the specified attributes. 
		* @param insertBefore HTMLElement a child element of this element 
		* @param returnDom Boolean true to return the dom node instead of creating an Element 
		* @returns Ext.dom.AbstractElement The new child element 
		*/
		createChild?( config?:any, insertBefore?:HTMLElement, returnDom?:boolean ): Ext.dom.IAbstractElement;
		/** [Method] Alias to remove  */
		destroy?(): void;
		/** [Method] Selects a single child at any depth below this element based on the passed CSS selector the selector should not cont  
		* @param selector String The CSS selector 
		* @param returnDom Boolean True to return the DOM node instead of Ext.dom.Element 
		* @returns HTMLElement/Ext.dom.Element The child Ext.dom.Element (or DOM node if returnDom = true) 
		*/
		down?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Looks at this node and then at parent nodes for a match of the passed simple selector e g  
		* @param selector String The simple selector to test 
		* @param limit Number/String/HTMLElement/Ext.Element The max depth to search as a number or an element which causes the upward traversal to stop and is not considered for inclusion as the result. (defaults to 50 || document.documentElement) 
		* @param returnEl Boolean True to return a Ext.Element object instead of DOM node 
		* @returns HTMLElement The matching DOM node (or null if no match was found) 
		*/
		findParent?( selector?:string, limit?:any, returnEl?:boolean ): HTMLElement;
		/** [Method] Looks at parent nodes for a match of the passed simple selector e g  
		* @param selector String The simple selector to test 
		* @param limit Number/String/HTMLElement/Ext.Element The max depth to search as a number or an element which causes the upward traversal to stop and is not considered for inclusion as the result. (defaults to 50 || document.documentElement) 
		* @param returnEl Boolean True to return a Ext.Element object instead of DOM node 
		* @returns HTMLElement The matching DOM node (or null if no match was found) 
		*/
		findParentNode?( selector?:string, limit?:any, returnEl?:boolean ): HTMLElement;
		/** [Method] Gets the first child skipping text nodes Defined in override Ext dom AbstractElement_traversal  
		* @param selector String Find the next sibling that matches the passed simple selector 
		* @param returnDom Boolean True to return a raw dom node instead of an Ext.dom.Element 
		* @returns Ext.dom.Element/HTMLElement The first child or null 
		*/
		first?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Returns the active element in the DOM  
		* @returns HTMLElement The active (focused) element in the document. 
		*/
		getActiveElement?(): HTMLElement;
		/** [Method] Returns the value of an attribute from the element s underlying DOM node  
		* @param name String The attribute name 
		* @param namespace String The namespace in which to look for the attribute 
		* @returns String The attribute value 
		*/
		getAttribute?( name?:string, namespace?:string ): string;
		/** [Method] Gets the width of the border s for the specified side s  Defined in override Ext dom AbstractElement_style  
		* @param side String Can be t, l, r, b or any combination of those to add multiple values. For example, passing 'lr' would get the border left width + the border right width. 
		* @returns Number The width of the sides passed added together 
		*/
		getBorderWidth?( side?:string ): number;
		/** [Method] Returns a child element of this element given its id  
		* @param id String The id of the desired child element. 
		* @param asDom Boolean True to return the DOM element, false to return a wrapped Element object. 
		*/
		getById?( id?:string, asDom?:boolean ): void;
		/** [Method] Returns the innerHTML of an Element or an empty string if the element s dom no longer exists  */
		getHTML?(): void;
		/** [Method] Returns the offset height of the element Defined in override Ext dom AbstractElement_style  
		* @param contentHeight Boolean true to get the height minus borders and padding 
		* @returns Number The element's height 
		*/
		getHeight?( contentHeight?:boolean ): number;
		/** [Method] Returns an object with properties top left right and bottom representing the margins of this element unless sides i  
		* @param sides String Any combination of l, r, t, b to get the sum of those sides 
		* @returns Object/Number 
		*/
		getMargin?( sides?:string ): any;
		/** [Method] Gets the width of the padding s for the specified side s  Defined in override Ext dom AbstractElement_style  
		* @param side String Can be t, l, r, b or any combination of those to add multiple values. For example, passing 'lr' would get the padding left + the padding right. 
		* @returns Number The padding of the sides passed added together 
		*/
		getPadding?( side?:string ): number;
		/** [Method] Returns the size of the element  
		* @param contentSize Boolean true to get the width/size minus borders and padding 
		* @returns Object An object containing the element's size: 
		*/
		getSize?( contentSize?:boolean ): any;
		/** [Method] Returns a named style property based on computed currentStyle primary and inline style if primary is not available  
		* @param property String/String[] The style property (or multiple property names in an array) whose value is returned. 
		* @param inline Boolean if true only inline styles will be returned. 
		* @returns String/Object The current value of the style property for this element (or a hash of named style values if multiple property arguments are requested). 
		*/
		getStyle?( property?:any, inline?:boolean ): any;
		/** [Method] Returns the value of the value attribute 
		* @param asNumber Boolean true to parse the value as a number 
		* @returns String/Number 
		*/
		getValue?( asNumber?:boolean ): any;
		/** [Method] Returns the dimensions of the element available to lay content out in  
		* @returns Object Object describing width and height. 
		*/
		getViewSize?(): any;
		/** [Method] Returns the offset width of the element Defined in override Ext dom AbstractElement_style  
		* @param contentWidth Boolean true to get the width minus borders and padding 
		* @returns Number The element's width 
		*/
		getWidth?( contentWidth?:boolean ): number;
		/** [Method] Checks if the specified CSS class exists on this element s DOM node  
		* @param className String The CSS class to check for 
		* @returns Boolean True if the class exists, else false 
		*/
		hasCls?( className?:string ): boolean;
		/** [Method] Hide this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		hide?( animate?:any ): Ext.dom.IElement;
		/** [Method] Inserts this element after the passed element in the DOM Defined in override Ext dom AbstractElement_insertion  
		* @param el String/HTMLElement/Ext.dom.AbstractElement The element to insert after. The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.AbstractElement This element 
		*/
		insertAfter?( el?:any ): Ext.dom.IAbstractElement;
		/** [Method] Inserts this element before the passed element in the DOM Defined in override Ext dom AbstractElement_insertion  
		* @param el String/HTMLElement/Ext.dom.AbstractElement The element before which this element will be inserted. The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.AbstractElement This element 
		*/
		insertBefore?( el?:any ): Ext.dom.IAbstractElement;
		/** [Method] Inserts or creates an element or DomHelper config as the first child of this element Defined in override Ext dom  
		* @param el String/HTMLElement/Ext.dom.AbstractElement/Object The id or element to insert or a DomHelper config to create and insert 
		* @returns Ext.dom.AbstractElement The new child 
		*/
		insertFirst?( el?:any ): Ext.dom.IAbstractElement;
		/** [Method] Inserts an html fragment into this element Defined in override Ext dom AbstractElement_insertion  
		* @param where String Where to insert the html in relation to this element - beforeBegin, afterBegin, beforeEnd, afterEnd. See Ext.dom.Helper.insertHtml for details. 
		* @param html String The HTML fragment 
		* @param returnEl Boolean True to return an Ext.dom.AbstractElement 
		* @returns HTMLElement/Ext.dom.AbstractElement The inserted node (or nearest related if more than 1 inserted) 
		*/
		insertHtml?( where?:string, html?:string, returnEl?:boolean ): any;
		/** [Method] Inserts or creates the passed element or DomHelper config as a sibling of this element Defined in override Ext d  
		* @param el String/HTMLElement/Ext.dom.AbstractElement/Object/Array The id, element to insert or a DomHelper config to create and insert or an array of any of those. 
		* @param where String 'before' or 'after' 
		* @param returnDom Boolean True to return the raw DOM element instead of Ext.dom.AbstractElement 
		* @returns Ext.dom.AbstractElement The inserted Element. If an array is passed, the last inserted element is returned. 
		*/
		insertSibling?( el?:any, where?:string, returnDom?:boolean ): Ext.dom.IAbstractElement;
		/** [Method] Returns true if this element matches the passed simple selector e g  
		* @param selector String The simple selector to test 
		* @returns Boolean True if this element matches the selector, else false 
		*/
		is?( selector?:string ): boolean;
		/** [Method] Checks if the current value of a style is equal to a given value  
		* @param style String property whose value is returned. 
		* @param value String to check against. 
		* @returns Boolean true for when the current value equals the given value. 
		*/
		isStyle?( style?:string, value?:string ): boolean;
		/** [Method] Returns true if the value of the given property is visually transparent  
		* @param prop String The style property whose value is to be tested. 
		* @returns Boolean True if the style property is visually transparent. 
		*/
		isTransparent?( prop?:string ): boolean;
		/** [Method] Gets the last child skipping text nodes Defined in override Ext dom AbstractElement_traversal  
		* @param selector String Find the previous sibling that matches the passed simple selector 
		* @param returnDom Boolean True to return a raw dom node instead of an Ext.dom.Element 
		* @returns Ext.dom.Element/HTMLElement The last child or null 
		*/
		last?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Puts a mask over this element to disable user interaction  
		* @param msg String A message to display in the mask 
		* @param msgCls String A css class to apply to the msg element 
		*/
		mask?( msg?:string, msgCls?:string ): void;
		/** [Method] Gets the next sibling skipping text nodes Defined in override Ext dom AbstractElement_traversal  
		* @param selector String Find the next sibling that matches the passed simple selector 
		* @param returnDom Boolean True to return a raw dom node instead of an Ext.dom.Element 
		* @returns Ext.dom.Element/HTMLElement The next sibling or null 
		*/
		next?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Gets the parent node for this element optionally chaining up trying to match a selector Defined in override Ext dom  
		* @param selector String Find a parent node that matches the passed simple selector 
		* @param returnDom Boolean True to return a raw dom node instead of an Ext.dom.Element 
		* @returns Ext.dom.Element/HTMLElement The parent node or null 
		*/
		parent?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Gets the previous sibling skipping text nodes Defined in override Ext dom AbstractElement_traversal  
		* @param selector String Find the previous sibling that matches the passed simple selector 
		* @param returnDom Boolean True to return a raw dom node instead of an Ext.dom.Element 
		* @returns Ext.dom.Element/HTMLElement The previous sibling or null 
		*/
		prev?( selector?:string, returnDom?:boolean ): any;
		/** [Method] Selects child nodes based on the passed CSS selector the selector should not contain an id 
		* @param selector String The CSS selector 
		* @returns HTMLElement[] An array of the matched nodes 
		*/
		query?( selector?:string ): HTMLElement[];
		/** [Method] Adds one or more CSS classes to this element and removes the same class es from all siblings  
		* @param className String/String[] The CSS class to add, or an array of classes 
		* @returns Ext.dom.Element this 
		*/
		radioCls?( className?:any ): Ext.dom.IElement;
		/** [Method] Removes this element s dom reference  */
		remove?(): void;
		/** [Method] Removes one or more CSS classes from the element  
		* @param className String/String[] The CSS classes to remove separated by space, or an array of classes 
		* @returns Ext.dom.Element this 
		*/
		removeCls?( className?:any ): Ext.dom.IElement;
		/** [Method] Forces the browser to repaint this element Defined in override Ext dom AbstractElement_style  
		* @returns Ext.dom.Element this 
		*/
		repaint?(): Ext.dom.IElement;
		/** [Method] Replaces the passed element with this element Defined in override Ext dom AbstractElement_insertion  
		* @param el String/HTMLElement/Ext.dom.AbstractElement The element to replace. The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.AbstractElement This element 
		*/
		replace?( el?:any ): Ext.dom.IAbstractElement;
		/** [Method] Replaces a CSS class on the element with another  
		* @param oldClassName String The CSS class to replace 
		* @param newClassName String The replacement CSS class 
		* @returns Ext.dom.Element this 
		*/
		replaceCls?( oldClassName?:string, newClassName?:string ): Ext.dom.IElement;
		/** [Method] Replaces this element with the passed element Defined in override Ext dom AbstractElement_insertion  
		* @param el String/HTMLElement/Ext.dom.AbstractElement/Object The new element (id of the node, a DOM Node or an existing Element) or a DomHelper config of an element to create 
		* @returns Ext.dom.AbstractElement This element 
		*/
		replaceWith?( el?:any ): Ext.dom.IAbstractElement;
		/** [Method] Creates a Ext CompositeElement for child nodes based on the passed CSS selector the selector should not contain an id 
		* @param selector String The CSS selector 
		* @param unique Boolean True to create a unique Ext.Element for each element. Defaults to a shared flyweight object. 
		* @returns Ext.CompositeElement The composite element 
		*/
		select?( selector?:string, unique?:boolean ): Ext.ICompositeElement;
		/** [Method] Serializes a DOM form into a url encoded string Defined in override Ext dom AbstractElement_static  
		* @param form Object The form 
		* @returns String The url encoded form 
		*/
		serializeForm?( form?:any ): string;
		/** [Method] Sets the passed attributes as attributes of this element a style attribute can be a string object or function  
		* @param o Object The object with the attributes 
		* @param useSet Boolean false to override the default setAttribute to use expandos. 
		* @returns Ext.dom.Element this 
		*/
		set?( o?:any, useSet?:boolean ): Ext.dom.IElement;
		/** [Method] Set the innerHTML of this element 
		* @param html String The new HTML 
		* @returns Ext.Element this 
		*/
		setHTML?( html?:string ): Ext.IElement;
		/** [Method] Set the height of this Element  
		* @param height Number/String The new height. This may be one of:  A Number specifying the new height in this Element's defaultUnits (by default, pixels.) A String used to set the CSS height style. Animation may not be used.  
		* @returns Ext.dom.Element this 
		*/
		setHeight?( height?:any ): Ext.dom.IElement;
		/** [Method] Set the size of this Element  
		* @param width Number/String The new width. This may be one of:  A Number specifying the new width in this Element's defaultUnits (by default, pixels). A String used to set the CSS width style. Animation may not be used. A size object in the format {width: widthValue, height: heightValue}.  
		* @param height Number/String The new height. This may be one of:  A Number specifying the new height in this Element's defaultUnits (by default, pixels). A String used to set the CSS height style. Animation may not be used.  
		* @returns Ext.dom.Element this 
		*/
		setSize?( width?:any, height?:any ): Ext.dom.IElement;
		/** [Method] Wrapper for setting style properties also takes single object parameter of multiple styles  
		* @param property String/Object The style property to be set, or an object of multiple styles. 
		* @param value String The value to apply to the given property, or null if an object was passed. 
		* @returns Ext.dom.Element this 
		*/
		setStyle?( property?:any, value?:string ): Ext.dom.IElement;
		/** [Method] Use this to change the visibility mode between VISIBILITY DISPLAY OFFSETS or ASCLASS  
		* @param mode Object 
		* @returns Ext.dom.AbstractElement this 
		*/
		setVisibilityMode?( mode?:any ): Ext.dom.IAbstractElement;
		/** [Method] Sets the visibility of the element see details 
		* @param visible Boolean Whether the element is visible 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setVisible?( visible?:boolean, animate?:any ): Ext.dom.IElement;
		/** [Method] Set the width of this Element  
		* @param width Number/String The new width. This may be one of:  A Number specifying the new width in this Element's defaultUnits (by default, pixels). A String used to set the CSS width style. Animation may not be used.  
		* @returns Ext.dom.Element this 
		*/
		setWidth?( width?:any ): Ext.dom.IElement;
		/** [Method] Show this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		show?( animate?:any ): Ext.dom.IElement;
		/** [Method] Toggles the specified CSS class on this element removes it if it already exists otherwise adds it 
		* @param className String The CSS class to toggle 
		* @returns Ext.dom.Element this 
		*/
		toggleCls?( className?:string ): Ext.dom.IElement;
		/** [Method] Removes a previously applied mask  */
		unmask?(): void;
		/** [Method] Walks up the DOM looking for a parent node that matches the passed simple selector e g  
		* @param selector String The simple selector to test 
		* @param limit Number/String/HTMLElement/Ext.Element The max depth to search as a number or an element which causes the upward traversal to stop and is not considered for inclusion as the result. (defaults to 50 || document.documentElement) 
		* @param returnDom Boolean True to return the DOM node instead of Ext.dom.Element 
		* @returns Ext.Element The matching DOM node (or null if no match was found) 
		*/
		up?( selector?:string, limit?:any, returnDom?:boolean ): Ext.IElement;
		/** [Method] Update the innerHTML of this element 
		* @param html String The new HTML 
		* @returns Ext.dom.Element this 
		*/
		update?( html?:string ): Ext.dom.IElement;
		/** [Method] Creates and wraps this element with another element Defined in override Ext dom AbstractElement_insertion  
		* @param config Object DomHelper element config object for the wrapper element or null for an empty div 
		* @param returnDom Boolean True to return the raw DOM element instead of Ext.dom.AbstractElement 
		* @param selector String A DomQuery selector to select a descendant node within the created element to use as the wrapping element. 
		* @returns HTMLElement/Ext.dom.AbstractElement The newly created wrapper element 
		*/
		wrap?( config?:any, returnDom?:boolean, selector?:string ): any;
	}
	export class AbstractElement {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Gets the singleton flyweight element with the passed node as the active element  
		* @param dom String/HTMLElement The dom node or id 
		* @param named String Allows for creation of named reusable flyweights to prevent conflicts (e.g. internally Ext uses "_global") 
		* @returns Ext.dom.Element.Fly The singleton flyweight object (or null if no matching element was found) 
		*/
		static fly( dom?:any, named?:string ): Ext.dom.element.IFly;
		/** [Method] Returns the top Element that is located at the passed coordinates Defined in override Ext dom AbstractElement_static  
		* @param x Number The x coordinate 
		* @param y Number The y coordinate 
		* @returns String The found Element 
		*/
		static fromPoint( x?:number, y?:number ): string;
		/** [Method] Retrieves Ext dom Element objects  
		* @param el String/HTMLElement/Ext.Element The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.Element The Element object (or null if no matching element was found) 
		*/
		static get( el?:any ): Ext.dom.IElement;
		/** [Method] Retrieves the document height Defined in override Ext dom AbstractElement_static  
		* @returns Number documentHeight 
		*/
		static getDocumentHeight(): number;
		/** [Method] Retrieves the document width Defined in override Ext dom AbstractElement_static  
		* @returns Number documentWidth 
		*/
		static getDocumentWidth(): number;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Retrieves the current orientation of the window  
		* @returns String Orientation of window: 'portrait' or 'landscape' 
		*/
		static getOrientation(): string;
		/** [Method] Retrieves the viewport size of the window  
		* @returns Object object containing width and height properties 
		*/
		static getViewSize(): any;
		/** [Method] Retrieves the viewport height of the window  
		* @returns Number viewportHeight 
		*/
		static getViewportHeight(): number;
		/** [Method] Retrieves the viewport width of the window  
		* @returns Number viewportWidth 
		*/
		static getViewportWidth(): number;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Returns an array of unique class names based upon the input strings or string arrays  
		* @param clsList1 Mixed A string of class names, or an array of class names. 
		* @param clsList2 Mixed A string of class names, or an array of class names. 
		* @returns Array An array of strings representing remaining unique, merged class names. If class names were added to the first list, the changed property will be true. 
		*/
		static mergeClsList( clsList1?:any, clsList2?:any ): any[];
		/** [Method] Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax  
		* @param prop String The property to normalize 
		* @returns String The normalized string 
		*/
		static normalize( prop?:string ): string;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String The encoded margins 
		* @returns Object An object with margin sizes for top, right, bottom and left 
		*/
		static parseBox( box?:any ): any;
		/** [Method] Converts a CSS string into an object with a property for each style  
		* @param styles String A CSS string 
		* @returns Object styles 
		*/
		static parseStyles( styles?:string ): any;
		/** [Method] Returns an array of unique class names deom the first parameter with all class names from the second parameter removed  
		* @param existingClsList Mixed A string of class names, or an array of class names. 
		* @param removeClsList Mixed A string of class names, or an array of class names to remove from existingClsList. 
		* @returns Array An array of strings representing remaining class names. If class names were removed, the changed property will be true. 
		*/
		static removeCls( existingClsList?:any, removeClsList?:any ): any[];
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String/Object The encoded margins, or an object with top, right, bottom, and left properties 
		* @param units String The type of units to add 
		* @returns String An string with unitized (px if units is not specified) metrics for top, right, bottom and left 
		*/
		static unitizeBox( box?:any, units?:string ): string;
	}
}
declare module Ext.dom {
	export interface IAbstractHelper extends Ext.IBase {
		/** [Method] Creates new DOM element s and appends them to el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		append?( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Applies a style specification to an element  
		* @param el String/HTMLElement The element to apply styles to 
		* @param styles String/Object/Function A style specification string e.g. 'width:100px', or object in the form {width:'100px'}, or a function which returns such a specification. 
		*/
		applyStyles?( el?:any, styles?:any ): void;
		/** [Method] Converts the styles from the given object to text  
		* @param styles Object The object describing the styles. 
		* @param buffer String[] The output buffer. 
		* @returns String/String[] If buffer is passed, it is returned. Otherwise the style string is returned. 
		*/
		generateStyles?( styles?:any, buffer?:string[] ): any;
		/** [Method] Creates new DOM element s and inserts them after el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object The DOM object spec (and children) 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		insertAfter?( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Creates new DOM element s and inserts them before el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		insertBefore?( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Creates new DOM element s and inserts them as the first child of el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		insertFirst?( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Inserts an HTML fragment into the DOM  
		* @param where String Where to insert the html in relation to el - beforeBegin, afterBegin, beforeEnd, afterEnd. For example take the following HTML: &lt;div&gt;Contents&lt;/div&gt; Using different where values inserts element to the following places:  beforeBegin: &lt;HERE&gt;&lt;div&gt;Contents&lt;/div&gt; afterBegin: &lt;div&gt;&lt;HERE&gt;Contents&lt;/div&gt; beforeEnd: &lt;div&gt;Contents&lt;HERE&gt;&lt;/div&gt; afterEnd: &lt;div&gt;Contents&lt;/div&gt;&lt;HERE&gt;  
		* @param el HTMLElement/TextNode The context element 
		* @param html String The HTML fragment 
		* @returns HTMLElement The new node 
		*/
		insertHtml?( where?:string, el?:any, html?:string ): HTMLElement;
		/** [Method] Returns the markup for the passed Element s config  
		* @param spec Object The DOM object spec (and children) 
		* @returns String 
		*/
		markup?( spec?:any ): string;
		/** [Method] Creates new DOM element s and overwrites the contents of el with them  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		overwrite?( el?:any, o?:any, returnElement?:boolean ): any;
	}
}
declare module Ext.dom {
	export interface IAbstractQuery extends Ext.IBase {
		/** [Method] Returns true if the passed element s match the passed simple selector e g  
		* @param el String/HTMLElement/Array An element id, element or array of elements 
		* @param selector String The simple selector to test 
		* @returns Boolean 
		*/
		is?( el?:any, selector?:string ): boolean;
		/** [Method] Selects a group of elements  
		* @param selector String The selector/xpath query (can be a comma separated list of selectors) 
		* @param root HTMLElement/String The start of the query (defaults to document). 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		select?( selector?:string, root?:any ): HTMLElement[];
		/** [Method] Selects a single element  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement/String The start of the query (defaults to document). 
		* @returns HTMLElement The DOM element which matched the selector. 
		*/
		selectNode?( selector?:string, root?:any ): HTMLElement;
	}
}
declare module Ext.dom {
	export interface ICompositeElement extends Ext.dom.ICompositeElementLite {
	}
}
declare module Ext {
	export interface ICompositeElement extends Ext.dom.ICompositeElementLite {
	}
}
declare module Ext.dom {
	export interface ICompositeElementLite extends Ext.IBase {
		/** [Property] (HTMLElement[]) */
		elements?: HTMLElement[];
		/** [Property] (Boolean) */
		isComposite?: boolean;
		/** [Method] Adds elements to this Composite object  
		* @param els HTMLElement[]/Ext.dom.CompositeElement Either an Array of DOM elements to add, or another Composite object who's elements should be added. 
		* @returns Ext.dom.CompositeElement This Composite object. 
		*/
		add?( els?:any ): Ext.dom.ICompositeElement;
		/** [Method] Removes all elements from this Composite  
		* @param removeDom Boolean True to also remove the elements from the document. 
		*/
		clear?( removeDom?:boolean ): void;
		/** [Method] Returns true if this composite contains the passed element  
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, or an Ext.Element, or an HtmlElement to find within the composite collection. 
		* @returns Boolean 
		*/
		contains?( el?:any ): boolean;
		/** [Method] Calls the passed function for each element in this composite  
		* @param fn Function The function to call. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Element. 
		* @returns Ext.dom.CompositeElement this 
		*/
		each?( fn?:any, scope?:any ): Ext.dom.ICompositeElement;
		/** [Method] Clears this Composite and adds the elements passed  
		* @param els HTMLElement[]/Ext.dom.CompositeElement Either an array of DOM elements, or another Composite from which to fill this Composite. 
		* @returns Ext.dom.CompositeElement this 
		*/
		fill?( els?:any ): Ext.dom.ICompositeElement;
		/** [Method] Filters this composite to only elements that match the passed selector  
		* @param selector String/Function A string CSS selector or a comparison function. The comparison function will be called with the following arguments: 
		* @returns Ext.dom.CompositeElement this 
		*/
		filter?( selector?:any ): Ext.dom.ICompositeElement;
		/** [Method] Returns the first Element 
		* @returns Ext.dom.Element 
		*/
		first?(): Ext.dom.IElement;
		/** [Method] Returns the number of elements in this Composite  
		* @returns Number 
		*/
		getCount?(): number;
		/** [Method] Find the index of the passed element within the composite collection  
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, or an Ext.dom.Element, or an HtmlElement to find within the composite collection. 
		* @returns Number The index of the passed Ext.dom.Element in the composite collection, or -1 if not found. 
		*/
		indexOf?( el?:any ): number;
		/** [Method] Returns a flyweight Element of the dom element object at the specified index 
		* @param index Number 
		* @returns Ext.dom.Element 
		*/
		item?( index?:number ): Ext.dom.IElement;
		/** [Method] Returns the last Element 
		* @returns Ext.dom.Element 
		*/
		last?(): Ext.dom.IElement;
		/** [Method] Removes the specified element s 
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, the Element itself, the index of the element in this composite or an array of any of those. 
		* @param removeDom Boolean True to also remove the element from the document. 
		* @returns Ext.dom.CompositeElement this 
		*/
		removeElement?( el?:any, removeDom?:boolean ): Ext.dom.ICompositeElement;
		/** [Method] Replaces the specified element with the passed element  
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, the Element itself, the index of the element in this composite to replace. 
		* @param replacement String/Ext.Element The id of an element or the Element itself. 
		* @param domReplace Boolean True to remove and replace the element in the document too. 
		* @returns Ext.dom.CompositeElement this 
		*/
		replaceElement?( el?:any, replacement?:any, domReplace?:boolean ): Ext.dom.ICompositeElement;
		/** [Method] Gets a range nodes  
		* @param start Number The index of the first node in the range 
		* @param end Number The index of the last node in the range 
		* @returns HTMLElement[] An array of nodes 
		*/
		slice?( start?:number, end?:number ): HTMLElement[];
	}
}
declare module Ext {
	export interface ICompositeElementLite extends Ext.IBase {
		/** [Property] (HTMLElement[]) */
		elements?: HTMLElement[];
		/** [Property] (Boolean) */
		isComposite?: boolean;
		/** [Method] Adds elements to this Composite object  
		* @param els HTMLElement[]/Ext.dom.CompositeElement Either an Array of DOM elements to add, or another Composite object who's elements should be added. 
		* @returns Ext.dom.CompositeElement This Composite object. 
		*/
		add?( els?:any ): Ext.dom.ICompositeElement;
		/** [Method] Removes all elements from this Composite  
		* @param removeDom Boolean True to also remove the elements from the document. 
		*/
		clear?( removeDom?:boolean ): void;
		/** [Method] Returns true if this composite contains the passed element  
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, or an Ext.Element, or an HtmlElement to find within the composite collection. 
		* @returns Boolean 
		*/
		contains?( el?:any ): boolean;
		/** [Method] Calls the passed function for each element in this composite  
		* @param fn Function The function to call. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Element. 
		* @returns Ext.dom.CompositeElement this 
		*/
		each?( fn?:any, scope?:any ): Ext.dom.ICompositeElement;
		/** [Method] Clears this Composite and adds the elements passed  
		* @param els HTMLElement[]/Ext.dom.CompositeElement Either an array of DOM elements, or another Composite from which to fill this Composite. 
		* @returns Ext.dom.CompositeElement this 
		*/
		fill?( els?:any ): Ext.dom.ICompositeElement;
		/** [Method] Filters this composite to only elements that match the passed selector  
		* @param selector String/Function A string CSS selector or a comparison function. The comparison function will be called with the following arguments: 
		* @returns Ext.dom.CompositeElement this 
		*/
		filter?( selector?:any ): Ext.dom.ICompositeElement;
		/** [Method] Returns the first Element 
		* @returns Ext.dom.Element 
		*/
		first?(): Ext.dom.IElement;
		/** [Method] Returns the number of elements in this Composite  
		* @returns Number 
		*/
		getCount?(): number;
		/** [Method] Find the index of the passed element within the composite collection  
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, or an Ext.dom.Element, or an HtmlElement to find within the composite collection. 
		* @returns Number The index of the passed Ext.dom.Element in the composite collection, or -1 if not found. 
		*/
		indexOf?( el?:any ): number;
		/** [Method] Returns a flyweight Element of the dom element object at the specified index 
		* @param index Number 
		* @returns Ext.dom.Element 
		*/
		item?( index?:number ): Ext.dom.IElement;
		/** [Method] Returns the last Element 
		* @returns Ext.dom.Element 
		*/
		last?(): Ext.dom.IElement;
		/** [Method] Removes the specified element s 
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, the Element itself, the index of the element in this composite or an array of any of those. 
		* @param removeDom Boolean True to also remove the element from the document. 
		* @returns Ext.dom.CompositeElement this 
		*/
		removeElement?( el?:any, removeDom?:boolean ): Ext.dom.ICompositeElement;
		/** [Method] Replaces the specified element with the passed element  
		* @param el String/HTMLElement/Ext.Element/Number The id of an element, the Element itself, the index of the element in this composite to replace. 
		* @param replacement String/Ext.Element The id of an element or the Element itself. 
		* @param domReplace Boolean True to remove and replace the element in the document too. 
		* @returns Ext.dom.CompositeElement this 
		*/
		replaceElement?( el?:any, replacement?:any, domReplace?:boolean ): Ext.dom.ICompositeElement;
		/** [Method] Gets a range nodes  
		* @param start Number The index of the first node in the range 
		* @param end Number The index of the last node in the range 
		* @returns HTMLElement[] An array of nodes 
		*/
		slice?( start?:number, end?:number ): HTMLElement[];
	}
}
declare module Ext.dom.element {
	export interface IFly extends Ext.dom.IElement {
		/** [Property] (Boolean) */
		isFly?: boolean;
	}
}
declare module Ext.dom.abstractelement {
	export interface IFly extends Ext.dom.IElement {
		/** [Property] (Boolean) */
		isFly?: boolean;
	}
}
declare module Ext.dom {
	export interface IElement extends Ext.dom.IAbstractElement {
		/** [Property] (Boolean) */
		autoBoxAdjust?: boolean;
		/** [Property] (String) */
		originalDisplay?: string;
		/** [Method] Sets up event handlers to add and remove a css class when the mouse is down and then up on this element a click effe  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnClick?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to add and remove a css class when this element has the focus Defined in override Ext dom Ele  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnFocus?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to add and remove a css class when the mouse is over this element Defined in override Ext dom  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnOver?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Convenience method for constructing a KeyMap 
		* @param key String/Number/Number[]/Object Either a string with the keys to listen for, the numeric key code, array of key codes or an object with the following options: 
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the specified function is executed. Defaults to this Element. 
		* @returns Ext.util.KeyMap The KeyMap created 
		*/
		addKeyListener?( key?:any, fn?:any, scope?:any ): Ext.util.IKeyMap;
		/** [Method] Creates a KeyMap for this element 
		* @param config Object The KeyMap config. See Ext.util.KeyMap for more details 
		* @returns Ext.util.KeyMap The KeyMap created 
		*/
		addKeyMap?( config?:any ): Ext.util.IKeyMap;
		/** [Method] Shorthand for on  
		* @param eventName String The name of event to handle. 
		* @param fn Function The handler function the event invokes. This function is passed the following parameters: evt : EventObject The EventObject describing the event. el : HtmlElement The DOM element which was the target of the event. Note that this may be filtered by using the delegate option. o : Object The options object from the call that setup the listener.  
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. 
		* @param options Object An object containing handler configuration properties. This may contain any of the following properties: scope Object : The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. delegate String: A simple selector to filter the target or look for a descendant of the target. See below for additional details. stopEvent Boolean: True to stop the event. That is stop propagation, and prevent the default action. preventDefault Boolean: True to prevent the default action stopPropagation Boolean: True to prevent event propagation normalized Boolean: False to pass a browser event to the handler function instead of an Ext.EventObject target Ext.dom.Element: Only call the handler if the event was fired on the target Element, not if the event was bubbled up from a child node. delay Number: The number of milliseconds to delay the invocation of the handler after the event fires. single Boolean: True to add a handler to handle just the next firing of the event, and then remove itself. buffer Number: Causes the handler to be scheduled to run in an Ext.util.DelayedTask delayed by the specified number of milliseconds. If the event fires again within that time, the original handler is not invoked, but the new handler is scheduled in its place. Combining Options  Using the options argument, it is possible to combine different types of listeners:  A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options object. The options object is available as the third parameter in the handler function.  Code:  el.on('click', this.onClick, this, {  single: true,  delay: 100,  stopEvent : true,  forumId: 4 }); Attaching multiple handlers in 1 call  The method also allows for a single argument to be passed which is a config object containing properties which specify multiple handlers.  Code:  el.on({  'click' : {  fn: this.onClick,  scope: this,  delay: 100  },  'mouseover' : {  fn: this.onMouseOver,  scope: this  },  'mouseout' : {  fn: this.onMouseOut,  scope: this  } }); Or a shorthand syntax:  Code:  el.on({  'click' : this.onClick,  'mouseover' : this.onMouseOver,  'mouseout' : this.onMouseOut,  scope: this }); delegate  This is a configuration option that you can pass along when registering a handler for an event to assist with event delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure to memory-leaks. By registering an event for a container element as opposed to each element within a container. By setting this configuration option to a simple selector, the target element will be filtered to look for a descendant of the target. For example:  // using this markup: &lt;div id='elId'&gt;  &lt;p id='p1'&gt;paragraph one&lt;/p&gt;  &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;  &lt;p id='p3'&gt;paragraph three&lt;/p&gt; &lt;/div&gt; // utilize event delegation to registering just one handler on the container element: el = Ext.get('elId'); el.on(  'click',  function(e,t) {  // handle click  console.info(t.id); // 'p2'  },  this,  {  // filter the target element to be a descendant with the class 'clickable'  delegate: '.clickable'  } );  
		* @returns Ext.dom.Element this 
		*/
		addListener?( eventName?:string, fn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Performs custom animation on this Element  
		* @param config Object Configuration for Ext.fx.Anim. Note that the to config is required. 
		* @returns Ext.dom.Element this 
		*/
		animate?( config?:any ): Ext.dom.IElement;
		/** [Method] Tries to blur the element  
		* @returns Ext.dom.Element this 
		*/
		blur?(): Ext.dom.IElement;
		/** [Method] Wraps the specified element with a special 9 element markup CSS block that renders by default as a gray container wit  
		* @param class String A base CSS class to apply to the containing wrapper element. Note that there are a number of CSS rules that are dependent on this name to make the overall effect work, so if you supply an alternate base class, make sure you also supply all of the necessary rules. 
		* @returns Ext.dom.Element The outermost wrapping element of the created box structure. 
		*/
		boxWrap?( clazz?:string ): Ext.dom.IElement;
		/** [Method] When an element is moved around in the DOM or is hidden using display none it loses layout and therefore all scrol  
		* @returns Function A function which will restore all descentant elements of this Element to their scroll positions recorded when this function was executed. Be aware that the returned function is a closure which has captured the scope of cacheScrollValues, so take care to derefence it as soon as not needed - if is it is a var it will drop out of scope, and the reference will be freed. 
		*/
		cacheScrollValues?(): any;
		/** [Method] Centers the Element in either the viewport or another Element  
		* @param centerIn String/HTMLElement/Ext.dom.Element element in which to center the element. 
		*/
		center?( centerIn?:any ): void;
		/** [Method] Removes Empty or whitespace filled text nodes  
		* @param forceReclean Boolean By default the element keeps track if it has been cleaned already so you can call this over and over. However, if you update the element and need to force a reclean, you can pass true. 
		*/
		clean?( forceReclean?:boolean ): void;
		/** [Method] Alias for removeAllListeners  
		* @returns Ext.dom.Element this 
		*/
		clearListeners?(): Ext.dom.IElement;
		/** [Method] Clears any opacity settings from this element  
		* @returns Ext.dom.Element this 
		*/
		clearOpacity?(): Ext.dom.IElement;
		/** [Method] Clears positioning back to the default when the document was loaded  
		* @param value String The value to use for the left, right, top, bottom. You could use 'auto'. 
		* @returns Ext.dom.Element this 
		*/
		clearPositioning?( value?:string ): Ext.dom.IElement;
		/** [Method] Store the current overflow setting and clip overflow on the element  use unclip to remove Defined in override Ext d  
		* @returns Ext.dom.Element this 
		*/
		clip?(): Ext.dom.IElement;
		/** [Method] Creates a proxy element of this element 
		* @param config String/Object The class name of the proxy element or a DomHelper config object 
		* @param renderTo String/HTMLElement The element or element id to render the proxy to. Defaults to: document.body. 
		* @param matchBox Boolean True to align and size the proxy to this element now. 
		* @returns Ext.dom.Element The new proxy element 
		*/
		createProxy?( config?:any, renderTo?:any, matchBox?:boolean ): Ext.dom.IElement;
		/** [Method] Creates an iframe shim for this element to keep selects and other windowed objects from showing through  
		* @returns Ext.dom.Element The new shim element 
		*/
		createShim?(): Ext.dom.IElement;
		/** [Method] Convenience method for setVisibilityMode Element DISPLAY  
		* @param display String What to set display to when visible 
		* @returns Ext.dom.Element this 
		*/
		enableDisplayMode?( display?:string ): Ext.dom.IElement;
		/** [Method] Fade an element in from transparent to opaque 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		fadeIn?( options?:any ): Ext.IElement;
		/** [Method] Fade an element out from opaque to transparent 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		fadeOut?( options?:any ): Ext.IElement;
		/** [Method] Tries to focus the element  
		* @param defer Number Milliseconds to defer the focus 
		* @returns Ext.dom.Element this 
		*/
		focus?( defer?:number ): Ext.dom.IElement;
		/** [Method] Alias for isFocusable  
		* @returns Boolean True if the element is focusable 
		*/
		focusable?(): boolean;
		/** [Method] Shows a ripple of exploding attenuating borders to draw attention to an Element  
		* @param color String The hex color value for the border. 
		* @param count Number The number of ripples to display. 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		frame?( color?:string, count?:number, options?:any ): Ext.dom.IElement;
		/** [Method] Returns the value of a namespaced attribute from the element s underlying DOM node  
		* @param namespace String The namespace in which to look for the attribute 
		* @param name String The attribute name 
		* @returns String The attribute value 
		*/
		getAttributeNS?( namespace?:string, name?:string ): string;
		/** [Method] Gets the bottom Y coordinate of the element element Y position  element height  Defined in override Ext dom Elemen  
		* @param local Boolean True to get the local css position instead of page coordinate 
		* @returns Number 
		*/
		getBottom?( local?:boolean ): number;
		/** [Method] Calculates the x y to center this element on the screen Defined in override Ext dom Element_position  
		* @returns Number[] The x, y values [x, y] 
		*/
		getCenterXY?(): number[];
		/** [Method] Return the CSS color for the specified CSS attribute  
		* @param attr String The css attribute 
		* @param defaultValue String The default value to use when a valid color isn't found 
		* @param prefix String defaults to #. Use an empty string when working with color anims. 
		*/
		getColor?( attr?:string, defaultValue?:string, prefix?:string ): void;
		/** [Method] Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders when  
		* @returns Number 
		*/
		getComputedHeight?(): number;
		/** [Method] Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders when ne  
		* @returns Number 
		*/
		getComputedWidth?(): number;
		/** [Method] Returns the sum width of the padding and borders for the passed sides 
		* @param sides String 
		* @returns Number 
		*/
		getFrameWidth?( sides?:string ): number;
		/** [Method] Gets the left X coordinate Defined in override Ext dom Element_position  
		* @param local Boolean True to get the local css position instead of page coordinate 
		* @returns Number 
		*/
		getLeft?( local?:boolean ): number;
		/** [Method] Gets this element s ElementLoader 
		* @returns Ext.ElementLoader The loader 
		*/
		getLoader?(): Ext.IElementLoader;
		/** [Method] Gets the local CSS X position for the element Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getLocalX?(): number;
		/** [Method] Gets the local CSS X and Y position for the element Defined in override Ext dom Element_position  
		* @returns Array [x, y] 
		*/
		getLocalXY?(): any[];
		/** [Method] Gets the local CSS Y position for the element Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getLocalY?(): number;
		/** [Method] Returns an object defining the area of this Element which can be passed to Ext util Positionable setBox to set anothe  
		* @param asRegion Boolean If true an Ext.util.Region will be returned 
		* @returns Object/Ext.util.Region box An object in the following format: {  left: &lt;Element's X position&gt;,  top: &lt;Element's Y position&gt;,  width: &lt;Element's width&gt;,  height: &lt;Element's height&gt;,  bottom: &lt;Element's lower bound&gt;,  right: &lt;Element's rightmost bound&gt; }  The returned object may also be addressed as an Array where index 0 contains the X position and index 1 contains the Y position. So the result may also be used for setXY 
		*/
		getPageBox?( asRegion?:boolean ): any;
		/** [Method] Gets an object with all CSS positioning properties  
		* @param autoPx Boolean true to return pixel values for "auto" styles. 
		* @returns Object 
		*/
		getPositioning?( autoPx?:boolean ): any;
		/** [Method] Gets the right X coordinate of the element element X position  element width  Defined in override Ext dom Element_  
		* @param local Boolean True to get the local css position instead of page coordinates 
		* @returns Number 
		*/
		getRight?( local?:boolean ): number;
		/** [Method] Returns the current scroll position of the element  
		* @returns Object An object containing the scroll position in the format {left: (scrollLeft), top: (scrollTop)} 
		*/
		getScroll?(): any;
		/** [Method] Gets the left scroll position Defined in override Ext dom Element_scroll  
		* @returns Number The left scroll position 
		*/
		getScrollLeft?(): number;
		/** [Method] Gets the top scroll position Defined in override Ext dom Element_scroll  
		* @returns Number The top scroll position 
		*/
		getScrollTop?(): number;
		/** [Method] Returns the dimensions of the element available to lay content out in  
		* @returns Object Object describing width and height. 
		*/
		getStyleSize?(): any;
		/** [Method] Returns the width in pixels of the passed text or the width of the text in this Element  
		* @param text String The text to measure. Defaults to the innerHTML of the element. 
		* @param min Number The minumum value to return. 
		* @param max Number The maximum value to return. 
		* @returns Number The text width in pixels. 
		*/
		getTextWidth?( text?:string, min?:number, max?:number ): number;
		/** [Method] Gets the top Y coordinate Defined in override Ext dom Element_position  
		* @param local Boolean True to get the local css position instead of page coordinates 
		* @returns Number 
		*/
		getTop?( local?:boolean ): number;
		/** [Method] Gets element X position in page coordinates Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getX?(): number;
		/** [Method] Gets element X and Y positions in page coordinates Defined in override Ext dom Element_position  
		* @returns Array [x, y] 
		*/
		getXY?(): any[];
		/** [Method] Gets element Y position in page coordinates Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getY?(): number;
		/** [Method] Slides the element while fading it out of view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to bottom: 'b') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		ghost?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Hide this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		hide?( animate?:any ): Ext.dom.IElement;
		/** [Method] Highlights the Element by setting a color applies to the background color by default but can be changed using the  
		* @param color String The highlight color. Should be a 6 char hex color without the leading # (defaults to yellow: 'ffff9c') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		highlight?( color?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element  
		* @param overFn Function The function to call when the mouse enters the Element. 
		* @param outFn Function The function to call when the mouse leaves the Element. 
		* @param scope Object The scope (this reference) in which the functions are executed. Defaults to the Element's DOM element. 
		* @param options Object Options for the listener. See the options parameter. 
		* @returns Ext.dom.Element this 
		*/
		hover?( overFn?:any, outFn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Initializes a Ext dd DD drag drop object for this element  
		* @param group String The group the DD object is member of 
		* @param config Object The DD config object 
		* @param overrides Object An object containing methods to override/implement on the DD object 
		* @returns Ext.dd.DD The DD object 
		*/
		initDD?( group?:string, config?:any, overrides?:any ): Ext.dd.IDD;
		/** [Method] Initializes a Ext dd DDProxy object for this element  
		* @param group String The group the DDProxy object is member of 
		* @param config Object The DDProxy config object 
		* @param overrides Object An object containing methods to override/implement on the DDProxy object 
		* @returns Ext.dd.DDProxy The DDProxy object 
		*/
		initDDProxy?( group?:string, config?:any, overrides?:any ): Ext.dd.IDDProxy;
		/** [Method] Initializes a Ext dd DDTarget object for this element  
		* @param group String The group the DDTarget object is member of 
		* @param config Object The DDTarget config object 
		* @param overrides Object An object containing methods to override/implement on the DDTarget object 
		* @returns Ext.dd.DDTarget The DDTarget object 
		*/
		initDDTarget?( group?:string, config?:any, overrides?:any ): Ext.dd.IDDTarget;
		/** [Method] Tests various css rules browsers to determine if this element uses a border box 
		* @returns Boolean 
		*/
		isBorderBox?(): boolean;
		/** [Method] Returns true if display is not none  
		* @returns Boolean 
		*/
		isDisplayed?(): boolean;
		/** [Method] Checks whether this element can be focused  
		* @param asFocusEl Object 
		* @returns Boolean True if the element is focusable 
		*/
		isFocusable?( asFocusEl?:any ): boolean;
		/** [Method] Returns true if this element is masked  
		* @returns Boolean 
		*/
		isMasked?(): boolean;
		/** [Method] Returns true if this element is scrollable  
		* @returns Boolean 
		*/
		isScrollable?(): boolean;
		/** [Method] Checks whether the element is currently visible using both visibility and display properties  
		* @param deep Boolean True to walk the dom and see if parent elements are hidden. If false, the function only checks the visibility of the element itself and it may return true even though a parent is not visible. 
		* @returns Boolean true if the element is currently visible, else false 
		*/
		isVisible?( deep?:boolean ): boolean;
		/** [Method] Direct access to the Ext ElementLoader Ext ElementLoader load method  
		* @param options Object 
		* @returns Ext.dom.Element this 
		*/
		load?( options?:any ): Ext.dom.IElement;
		/** [Method] Puts a mask over this element to disable user interaction  
		* @param msg String A message to display in the mask 
		* @param msgCls String A css class to apply to the msg element 
		* @returns Ext.dom.Element The mask element 
		*/
		mask?( msg?:string, msgCls?:string ): Ext.dom.IElement;
		/** [Method] Monitors this Element for the mouse leaving  
		* @param delay Number The delay in milliseconds to wait for possible mouse re-entry before calling the handler function. 
		* @param handler Function The function to call if the mouse remains outside of this Element for the specified time. 
		* @param scope Object The scope (this reference) in which the handler function executes. Defaults to this Element. 
		* @returns Object The listeners object which was added to this element so that monitoring can be stopped. Example usage: // Hide the menu if the mouse moves out for 250ms or more this.mouseLeaveMonitor = this.menuEl.monitorMouseLeave(250, this.hideMenu, this); ... // Remove mouseleave monitor on menu destroy this.menuEl.un(this.mouseLeaveMonitor); 
		*/
		monitorMouseLeave?( delay?:number, handler?:any, scope?:any ): any;
		/** [Method] Sets the position of the element in page coordinates  
		* @param x Number X value for new position (coordinates are page-based) 
		* @param y Number Y value for new position (coordinates are page-based) 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		moveTo?( x?:number, y?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Returns true if this element needs an explicit tabIndex to make it focusable  */
		needsTabIndex?(): void;
		/** [Method] Appends an event handler to this element  
		* @param eventName String The name of event to handle. 
		* @param fn Function The handler function the event invokes. This function is passed the following parameters: evt : EventObject The EventObject describing the event. el : HtmlElement The DOM element which was the target of the event. Note that this may be filtered by using the delegate option. o : Object The options object from the call that setup the listener.  
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. 
		* @param options Object An object containing handler configuration properties. This may contain any of the following properties: scope Object : The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. delegate String: A simple selector to filter the target or look for a descendant of the target. See below for additional details. stopEvent Boolean: True to stop the event. That is stop propagation, and prevent the default action. preventDefault Boolean: True to prevent the default action stopPropagation Boolean: True to prevent event propagation normalized Boolean: False to pass a browser event to the handler function instead of an Ext.EventObject target Ext.dom.Element: Only call the handler if the event was fired on the target Element, not if the event was bubbled up from a child node. delay Number: The number of milliseconds to delay the invocation of the handler after the event fires. single Boolean: True to add a handler to handle just the next firing of the event, and then remove itself. buffer Number: Causes the handler to be scheduled to run in an Ext.util.DelayedTask delayed by the specified number of milliseconds. If the event fires again within that time, the original handler is not invoked, but the new handler is scheduled in its place. Combining Options  Using the options argument, it is possible to combine different types of listeners:  A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options object. The options object is available as the third parameter in the handler function.  Code:  el.on('click', this.onClick, this, {  single: true,  delay: 100,  stopEvent : true,  forumId: 4 }); Attaching multiple handlers in 1 call  The method also allows for a single argument to be passed which is a config object containing properties which specify multiple handlers.  Code:  el.on({  'click' : {  fn: this.onClick,  scope: this,  delay: 100  },  'mouseover' : {  fn: this.onMouseOver,  scope: this  },  'mouseout' : {  fn: this.onMouseOut,  scope: this  } }); Or a shorthand syntax:  Code:  el.on({  'click' : this.onClick,  'mouseover' : this.onMouseOver,  'mouseout' : this.onMouseOut,  scope: this }); delegate  This is a configuration option that you can pass along when registering a handler for an event to assist with event delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure to memory-leaks. By registering an event for a container element as opposed to each element within a container. By setting this configuration option to a simple selector, the target element will be filtered to look for a descendant of the target. For example:  // using this markup: &lt;div id='elId'&gt;  &lt;p id='p1'&gt;paragraph one&lt;/p&gt;  &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;  &lt;p id='p3'&gt;paragraph three&lt;/p&gt; &lt;/div&gt; // utilize event delegation to registering just one handler on the container element: el = Ext.get('elId'); el.on(  'click',  function(e,t) {  // handle click  console.info(t.id); // 'p2'  },  this,  {  // filter the target element to be a descendant with the class 'clickable'  delegate: '.clickable'  } );  
		* @returns Ext.dom.Element this 
		*/
		on?( eventName?:string, fn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Creates a pause before any subsequent queued effects begin  
		* @param seconds Number The length of time to pause (in seconds) 
		* @returns Ext.Element The Element 
		*/
		pause?( seconds?:number ): Ext.IElement;
		/** [Method] Initializes positioning on this element  
		* @param pos String Positioning to use "relative", "absolute" or "fixed" 
		* @param zIndex Number The zIndex to apply 
		* @param x Number Set the page X position 
		* @param y Number Set the page Y position 
		*/
		position?( pos?:string, zIndex?:number, x?:number, y?:number ): void;
		/** [Method] Fades the element out while slowly expanding it in all directions  
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		puff?( options?:any ): Ext.dom.IElement;
		/** [Method] Recursively removes all previous added listeners from this element and its children 
		* @returns Ext.dom.Element this 
		*/
		purgeAllListeners?(): Ext.dom.IElement;
		/** [Method] Create an event handler on this element such that when the event fires and is handled by this element it will be rel  
		* @param eventName String The type of event to relay 
		* @param observable Object Any object that extends Ext.util.Observable that will provide the context for firing the relayed event 
		*/
		relayEvent?( eventName?:string, observable?:any ): void;
		/** [Method] Removes all previous added listeners from this element 
		* @returns Ext.dom.Element this 
		*/
		removeAllListeners?(): Ext.dom.IElement;
		/** [Method] Shorthand for un  
		* @param eventName String The name of the event from which to remove the handler. 
		* @param fn Function The handler function to remove. This must be a reference to the function passed into the on call. 
		* @param scope Object If a scope (this reference) was specified when the listener was added, then this must refer to the same object. 
		* @returns Ext.dom.Element this 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Animates the transition of an element s dimensions from a starting height width to an ending height width  
		* @param width Number The new width (pass undefined to keep the original width) 
		* @param height Number The new height (pass undefined to keep the original height) 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		scale?( width?:number, height?:number, options?:any ): Ext.IElement;
		/** [Method] Scrolls this element the specified direction  
		* @param direction String Possible values are:  "l" (or "left") "r" (or "right") "t" (or "top", or "up") "b" (or "bottom", or "down")  
		* @param distance Number How far to scroll the element in pixels 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Boolean Returns true if a scroll was triggered or false if the element was scrolled as far as it could go. 
		*/
		scroll?( direction?:string, distance?:number, animate?:any ): boolean;
		/** [Method] Scrolls this element by the passed delta values optionally animating  
		* @param deltaX Number/Number[]/Object Either the x delta, an Array specifying x and y deltas or an object with "x" and "y" properties. 
		* @param deltaY Number/Boolean/Object Either the y delta, or an animate flag or config object. 
		* @param animate Boolean/Object Animate flag/config object if the delta values were passed separately. 
		* @returns Ext.Element this 
		*/
		scrollBy?( deltaX?:any, deltaY?:any, animate?:any ): Ext.IElement;
		/** [Method] Scrolls this element into view within the passed container  
		* @param container String/HTMLElement/Ext.Element The container element to scroll. Should be a string (id), dom node, or Ext.Element. 
		* @param hscroll Boolean False to disable horizontal scroll. 
		* @param animate Boolean/Object true for the default animation or a standard Element 
		* @param highlight Boolean true to highlight the element when it is in view. animation config object 
		* @returns Ext.dom.Element this 
		*/
		scrollIntoView?( container?:any, hscroll?:boolean, animate?:any, highlight?:boolean ): Ext.dom.IElement;
		/** [Method] Scrolls this element the specified scroll point  
		* @param side String Either "left" for scrollLeft values or "top" for scrollTop values. 
		* @param value Number The new scroll value 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.Element this 
		*/
		scrollTo?( side?:string, value?:number, animate?:any ): Ext.IElement;
		/** [Method] Enable text selection for this element normalized across browsers  Defined in override Ext dom Element_style  
		* @returns Ext.Element this 
		*/
		selectable?(): Ext.IElement;
		/** [Method] Sets the element s CSS bottom style  
		* @param bottom Number/String Number of pixels or CSS string value to set as the bottom CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setBottom?( bottom?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s position and size in one shot  
		* @param x Number X value for new position (coordinates are page-based) 
		* @param y Number Y value for new position (coordinates are page-based) 
		* @param width Number/String The new width. This may be one of:  A Number specifying the new width in this Element's defaultUnits (by default, pixels) A String used to set the CSS width style. Animation may not be used.  
		* @param height Number/String The new height. This may be one of:  A Number specifying the new height in this Element's defaultUnits (by default, pixels) A String used to set the CSS height style. Animation may not be used.  
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setBounds?( x?:number, y?:number, width?:any, height?:any, animate?:any ): Ext.dom.IElement;
		/** [Method] Sets the CSS display property  
		* @param value Boolean/String Boolean value to display the element using its default display, or a string to set the display directly. 
		* @returns Ext.dom.Element this 
		*/
		setDisplayed?( value?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left position directly using CSS style instead of setX 
		* @param left Number/String Number of pixels or CSS string value to set as the left CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setLeft?( left?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left and top positions directly using CSS style Defined in override Ext dom Element_position  
		* @param left Number/String Number of pixels or CSS string value to set as the left CSS property value 
		* @param top Number/String Number of pixels or CSS string value to set as the top CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setLeftTop?( left?:any, top?:any ): Ext.dom.IElement;
		/** [Method] Sets the position of the element in page coordinates  
		* @param x Number X value for new position 
		* @param y Number Y value for new position 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setLocation?( x?:number, y?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Set the opacity of the element Defined in override Ext dom Element_style  
		* @param opacity Number The new opacity. 0 = transparent, .5 = 50% visibile, 1 = fully visible, etc 
		* @param animate Boolean/Object a standard Element animation config object or true for the default animation ({duration: 350, easing: 'easeIn'}) 
		* @returns Ext.dom.Element this 
		*/
		setOpacity?( opacity?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Set positioning with an object returned by getPositioning  
		* @param posCfg Object 
		* @returns Ext.dom.Element this 
		*/
		setPositioning?( posCfg?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s CSS right style  
		* @param right Number/String Number of pixels or CSS string value to set as the right CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setRight?( right?:any ): Ext.dom.IElement;
		/** [Method] Sets the left scroll position Defined in override Ext dom Element_scroll  
		* @param left Number The left scroll position 
		* @returns Ext.dom.Element this 
		*/
		setScrollLeft?( left?:number ): Ext.dom.IElement;
		/** [Method] Sets the top scroll position Defined in override Ext dom Element_scroll  
		* @param top Number The top scroll position 
		* @returns Ext.dom.Element this 
		*/
		setScrollTop?( top?:number ): Ext.dom.IElement;
		/** [Method] Sets the element s top position directly using CSS style instead of setY 
		* @param top Number/String Number of pixels or CSS string value to set as the top CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setTop?( top?:any ): Ext.dom.IElement;
		/** [Method] Sets the visibility of the element see details 
		* @param visible Boolean Whether the element is visible 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setVisible?( visible?:boolean, animate?:any ): Ext.dom.IElement;
		/** [Method] Animates the transition of any combination of an element s dimensions xy position and or opacity  
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		shift?( options?:any ): Ext.IElement;
		/** [Method] Show this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		show?( animate?:any ): Ext.dom.IElement;
		/** [Method] Slides the element into view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to top: 't') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		slideIn?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Slides the element out of view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to top: 't') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		slideOut?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Stops the specified event s from bubbling and optionally prevents the default action 
		* @param eventName String/String[] an event / array of events to stop from bubbling 
		* @param preventDefault Boolean true to prevent the default action too 
		* @returns Ext.dom.Element this 
		*/
		swallowEvent?( eventName?:any, preventDefault?:boolean ): Ext.dom.IElement;
		/** [Method] Blinks the element as if it was clicked and then collapses on its center similar to switching off a television 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		switchOff?( options?:any ): Ext.dom.IElement;
		/** [Method] Toggles the element s visibility or display depending on visibility mode  
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		toggle?( animate?:any ): Ext.dom.IElement;
		/** [Method] Removes an event handler from this element  
		* @param eventName String The name of the event from which to remove the handler. 
		* @param fn Function The handler function to remove. This must be a reference to the function passed into the on call. 
		* @param scope Object If a scope (this reference) was specified when the listener was added, then this must refer to the same object. 
		* @returns Ext.dom.Element this 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Return clipping overflow to original clipping before clip was called Defined in override Ext dom Element_style  
		* @returns Ext.dom.Element this 
		*/
		unclip?(): Ext.dom.IElement;
		/** [Method] Hides a previously applied mask  */
		unmask?(): void;
		/** [Method] Disables text selection for this element normalized across browsers  Defined in override Ext dom Element_style  
		* @returns Ext.dom.Element this 
		*/
		unselectable?(): Ext.dom.IElement;
		/** [Method] Updates the innerHTML of this element optionally searching for and processing scripts  
		* @param html String The new HTML 
		* @param loadScripts Boolean True to look for and process scripts (defaults to false) 
		* @param callback Function For async script loading you can be notified when the update completes 
		* @returns Ext.dom.Element this 
		*/
		update?( html?:string, loadScripts?:boolean, callback?:any ): Ext.dom.IElement;
	}
	export class Element {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Returns the top Element that is located at the passed coordinates Defined in override Ext dom AbstractElement_static  
		* @param x Number The x coordinate 
		* @param y Number The y coordinate 
		* @returns String The found Element 
		*/
		static fromPoint( x?:number, y?:number ): string;
		/** [Method] Retrieves Ext dom Element objects  
		* @param el String/HTMLElement/Ext.Element The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.Element The Element object (or null if no matching element was found) 
		*/
		static get( el?:any ): Ext.dom.IElement;
		/** [Method] Retrieves the document height Defined in override Ext dom AbstractElement_static  
		* @returns Number documentHeight 
		*/
		static getDocumentHeight(): number;
		/** [Method] Retrieves the document width Defined in override Ext dom AbstractElement_static  
		* @returns Number documentWidth 
		*/
		static getDocumentWidth(): number;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Retrieves the current orientation of the window  
		* @returns String Orientation of window: 'portrait' or 'landscape' 
		*/
		static getOrientation(): string;
		/** [Method] Retrieves the viewport size of the window  
		* @returns Object object containing width and height properties 
		*/
		static getViewSize(): any;
		/** [Method] Retrieves the viewport height of the window  
		* @returns Number viewportHeight 
		*/
		static getViewportHeight(): number;
		/** [Method] Retrieves the viewport width of the window  
		* @returns Number viewportWidth 
		*/
		static getViewportWidth(): number;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Returns an array of unique class names based upon the input strings or string arrays  
		* @param clsList1 Mixed A string of class names, or an array of class names. 
		* @param clsList2 Mixed A string of class names, or an array of class names. 
		* @returns Array An array of strings representing remaining unique, merged class names. If class names were added to the first list, the changed property will be true. 
		*/
		static mergeClsList( clsList1?:any, clsList2?:any ): any[];
		/** [Method] Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax  
		* @param prop String The property to normalize 
		* @returns String The normalized string 
		*/
		static normalize( prop?:string ): string;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String The encoded margins 
		* @returns Object An object with margin sizes for top, right, bottom and left 
		*/
		static parseBox( box?:any ): any;
		/** [Method] Converts a CSS string into an object with a property for each style  
		* @param styles String A CSS string 
		* @returns Object styles 
		*/
		static parseStyles( styles?:string ): any;
		/** [Method] Returns an array of unique class names deom the first parameter with all class names from the second parameter removed  
		* @param existingClsList Mixed A string of class names, or an array of class names. 
		* @param removeClsList Mixed A string of class names, or an array of class names to remove from existingClsList. 
		* @returns Array An array of strings representing remaining class names. If class names were removed, the changed property will be true. 
		*/
		static removeCls( existingClsList?:any, removeClsList?:any ): any[];
		/** [Method] Selects elements based on the passed CSS selector to enable Element methods to be applied to many related elements in  
		* @param selector String/HTMLElement[] The CSS selector or an array of elements 
		* @param unique Boolean true to create a unique Ext.Element for each element (defaults to a shared flyweight object) 
		* @param root HTMLElement/String The root element of the query or id of the root 
		* @returns Ext.CompositeElementLite/Ext.CompositeElement 
		*/
		static select( selector?:any, unique?:boolean, root?:any ): any;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String/Object The encoded margins, or an object with top, right, bottom, and left properties 
		* @param units String The type of units to add 
		* @returns String An string with unitized (px if units is not specified) metrics for top, right, bottom and left 
		*/
		static unitizeBox( box?:any, units?:string ): string;
	}
}
declare module Ext {
	export interface IElement extends Ext.dom.IAbstractElement {
		/** [Property] (Boolean) */
		autoBoxAdjust?: boolean;
		/** [Property] (String) */
		originalDisplay?: string;
		/** [Method] Sets up event handlers to add and remove a css class when the mouse is down and then up on this element a click effe  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnClick?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to add and remove a css class when this element has the focus Defined in override Ext dom Ele  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnFocus?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to add and remove a css class when the mouse is over this element Defined in override Ext dom  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnOver?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Convenience method for constructing a KeyMap 
		* @param key String/Number/Number[]/Object Either a string with the keys to listen for, the numeric key code, array of key codes or an object with the following options: 
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the specified function is executed. Defaults to this Element. 
		* @returns Ext.util.KeyMap The KeyMap created 
		*/
		addKeyListener?( key?:any, fn?:any, scope?:any ): Ext.util.IKeyMap;
		/** [Method] Creates a KeyMap for this element 
		* @param config Object The KeyMap config. See Ext.util.KeyMap for more details 
		* @returns Ext.util.KeyMap The KeyMap created 
		*/
		addKeyMap?( config?:any ): Ext.util.IKeyMap;
		/** [Method] Shorthand for on  
		* @param eventName String The name of event to handle. 
		* @param fn Function The handler function the event invokes. This function is passed the following parameters: evt : EventObject The EventObject describing the event. el : HtmlElement The DOM element which was the target of the event. Note that this may be filtered by using the delegate option. o : Object The options object from the call that setup the listener.  
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. 
		* @param options Object An object containing handler configuration properties. This may contain any of the following properties: scope Object : The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. delegate String: A simple selector to filter the target or look for a descendant of the target. See below for additional details. stopEvent Boolean: True to stop the event. That is stop propagation, and prevent the default action. preventDefault Boolean: True to prevent the default action stopPropagation Boolean: True to prevent event propagation normalized Boolean: False to pass a browser event to the handler function instead of an Ext.EventObject target Ext.dom.Element: Only call the handler if the event was fired on the target Element, not if the event was bubbled up from a child node. delay Number: The number of milliseconds to delay the invocation of the handler after the event fires. single Boolean: True to add a handler to handle just the next firing of the event, and then remove itself. buffer Number: Causes the handler to be scheduled to run in an Ext.util.DelayedTask delayed by the specified number of milliseconds. If the event fires again within that time, the original handler is not invoked, but the new handler is scheduled in its place. Combining Options  Using the options argument, it is possible to combine different types of listeners:  A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options object. The options object is available as the third parameter in the handler function.  Code:  el.on('click', this.onClick, this, {  single: true,  delay: 100,  stopEvent : true,  forumId: 4 }); Attaching multiple handlers in 1 call  The method also allows for a single argument to be passed which is a config object containing properties which specify multiple handlers.  Code:  el.on({  'click' : {  fn: this.onClick,  scope: this,  delay: 100  },  'mouseover' : {  fn: this.onMouseOver,  scope: this  },  'mouseout' : {  fn: this.onMouseOut,  scope: this  } }); Or a shorthand syntax:  Code:  el.on({  'click' : this.onClick,  'mouseover' : this.onMouseOver,  'mouseout' : this.onMouseOut,  scope: this }); delegate  This is a configuration option that you can pass along when registering a handler for an event to assist with event delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure to memory-leaks. By registering an event for a container element as opposed to each element within a container. By setting this configuration option to a simple selector, the target element will be filtered to look for a descendant of the target. For example:  // using this markup: &lt;div id='elId'&gt;  &lt;p id='p1'&gt;paragraph one&lt;/p&gt;  &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;  &lt;p id='p3'&gt;paragraph three&lt;/p&gt; &lt;/div&gt; // utilize event delegation to registering just one handler on the container element: el = Ext.get('elId'); el.on(  'click',  function(e,t) {  // handle click  console.info(t.id); // 'p2'  },  this,  {  // filter the target element to be a descendant with the class 'clickable'  delegate: '.clickable'  } );  
		* @returns Ext.dom.Element this 
		*/
		addListener?( eventName?:string, fn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Performs custom animation on this Element  
		* @param config Object Configuration for Ext.fx.Anim. Note that the to config is required. 
		* @returns Ext.dom.Element this 
		*/
		animate?( config?:any ): Ext.dom.IElement;
		/** [Method] Tries to blur the element  
		* @returns Ext.dom.Element this 
		*/
		blur?(): Ext.dom.IElement;
		/** [Method] Wraps the specified element with a special 9 element markup CSS block that renders by default as a gray container wit  
		* @param class String A base CSS class to apply to the containing wrapper element. Note that there are a number of CSS rules that are dependent on this name to make the overall effect work, so if you supply an alternate base class, make sure you also supply all of the necessary rules. 
		* @returns Ext.dom.Element The outermost wrapping element of the created box structure. 
		*/
		boxWrap?( clazz?:string ): Ext.dom.IElement;
		/** [Method] When an element is moved around in the DOM or is hidden using display none it loses layout and therefore all scrol  
		* @returns Function A function which will restore all descentant elements of this Element to their scroll positions recorded when this function was executed. Be aware that the returned function is a closure which has captured the scope of cacheScrollValues, so take care to derefence it as soon as not needed - if is it is a var it will drop out of scope, and the reference will be freed. 
		*/
		cacheScrollValues?(): any;
		/** [Method] Centers the Element in either the viewport or another Element  
		* @param centerIn String/HTMLElement/Ext.dom.Element element in which to center the element. 
		*/
		center?( centerIn?:any ): void;
		/** [Method] Removes Empty or whitespace filled text nodes  
		* @param forceReclean Boolean By default the element keeps track if it has been cleaned already so you can call this over and over. However, if you update the element and need to force a reclean, you can pass true. 
		*/
		clean?( forceReclean?:boolean ): void;
		/** [Method] Alias for removeAllListeners  
		* @returns Ext.dom.Element this 
		*/
		clearListeners?(): Ext.dom.IElement;
		/** [Method] Clears any opacity settings from this element  
		* @returns Ext.dom.Element this 
		*/
		clearOpacity?(): Ext.dom.IElement;
		/** [Method] Clears positioning back to the default when the document was loaded  
		* @param value String The value to use for the left, right, top, bottom. You could use 'auto'. 
		* @returns Ext.dom.Element this 
		*/
		clearPositioning?( value?:string ): Ext.dom.IElement;
		/** [Method] Store the current overflow setting and clip overflow on the element  use unclip to remove Defined in override Ext d  
		* @returns Ext.dom.Element this 
		*/
		clip?(): Ext.dom.IElement;
		/** [Method] Creates a proxy element of this element 
		* @param config String/Object The class name of the proxy element or a DomHelper config object 
		* @param renderTo String/HTMLElement The element or element id to render the proxy to. Defaults to: document.body. 
		* @param matchBox Boolean True to align and size the proxy to this element now. 
		* @returns Ext.dom.Element The new proxy element 
		*/
		createProxy?( config?:any, renderTo?:any, matchBox?:boolean ): Ext.dom.IElement;
		/** [Method] Creates an iframe shim for this element to keep selects and other windowed objects from showing through  
		* @returns Ext.dom.Element The new shim element 
		*/
		createShim?(): Ext.dom.IElement;
		/** [Method] Convenience method for setVisibilityMode Element DISPLAY  
		* @param display String What to set display to when visible 
		* @returns Ext.dom.Element this 
		*/
		enableDisplayMode?( display?:string ): Ext.dom.IElement;
		/** [Method] Fade an element in from transparent to opaque 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		fadeIn?( options?:any ): Ext.IElement;
		/** [Method] Fade an element out from opaque to transparent 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		fadeOut?( options?:any ): Ext.IElement;
		/** [Method] Tries to focus the element  
		* @param defer Number Milliseconds to defer the focus 
		* @returns Ext.dom.Element this 
		*/
		focus?( defer?:number ): Ext.dom.IElement;
		/** [Method] Alias for isFocusable  
		* @returns Boolean True if the element is focusable 
		*/
		focusable?(): boolean;
		/** [Method] Shows a ripple of exploding attenuating borders to draw attention to an Element  
		* @param color String The hex color value for the border. 
		* @param count Number The number of ripples to display. 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		frame?( color?:string, count?:number, options?:any ): Ext.dom.IElement;
		/** [Method] Returns the value of a namespaced attribute from the element s underlying DOM node  
		* @param namespace String The namespace in which to look for the attribute 
		* @param name String The attribute name 
		* @returns String The attribute value 
		*/
		getAttributeNS?( namespace?:string, name?:string ): string;
		/** [Method] Gets the bottom Y coordinate of the element element Y position  element height  Defined in override Ext dom Elemen  
		* @param local Boolean True to get the local css position instead of page coordinate 
		* @returns Number 
		*/
		getBottom?( local?:boolean ): number;
		/** [Method] Calculates the x y to center this element on the screen Defined in override Ext dom Element_position  
		* @returns Number[] The x, y values [x, y] 
		*/
		getCenterXY?(): number[];
		/** [Method] Return the CSS color for the specified CSS attribute  
		* @param attr String The css attribute 
		* @param defaultValue String The default value to use when a valid color isn't found 
		* @param prefix String defaults to #. Use an empty string when working with color anims. 
		*/
		getColor?( attr?:string, defaultValue?:string, prefix?:string ): void;
		/** [Method] Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders when  
		* @returns Number 
		*/
		getComputedHeight?(): number;
		/** [Method] Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders when ne  
		* @returns Number 
		*/
		getComputedWidth?(): number;
		/** [Method] Returns the sum width of the padding and borders for the passed sides 
		* @param sides String 
		* @returns Number 
		*/
		getFrameWidth?( sides?:string ): number;
		/** [Method] Gets the left X coordinate Defined in override Ext dom Element_position  
		* @param local Boolean True to get the local css position instead of page coordinate 
		* @returns Number 
		*/
		getLeft?( local?:boolean ): number;
		/** [Method] Gets this element s ElementLoader 
		* @returns Ext.ElementLoader The loader 
		*/
		getLoader?(): Ext.IElementLoader;
		/** [Method] Gets the local CSS X position for the element Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getLocalX?(): number;
		/** [Method] Gets the local CSS X and Y position for the element Defined in override Ext dom Element_position  
		* @returns Array [x, y] 
		*/
		getLocalXY?(): any[];
		/** [Method] Gets the local CSS Y position for the element Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getLocalY?(): number;
		/** [Method] Returns an object defining the area of this Element which can be passed to Ext util Positionable setBox to set anothe  
		* @param asRegion Boolean If true an Ext.util.Region will be returned 
		* @returns Object/Ext.util.Region box An object in the following format: {  left: &lt;Element's X position&gt;,  top: &lt;Element's Y position&gt;,  width: &lt;Element's width&gt;,  height: &lt;Element's height&gt;,  bottom: &lt;Element's lower bound&gt;,  right: &lt;Element's rightmost bound&gt; }  The returned object may also be addressed as an Array where index 0 contains the X position and index 1 contains the Y position. So the result may also be used for setXY 
		*/
		getPageBox?( asRegion?:boolean ): any;
		/** [Method] Gets an object with all CSS positioning properties  
		* @param autoPx Boolean true to return pixel values for "auto" styles. 
		* @returns Object 
		*/
		getPositioning?( autoPx?:boolean ): any;
		/** [Method] Gets the right X coordinate of the element element X position  element width  Defined in override Ext dom Element_  
		* @param local Boolean True to get the local css position instead of page coordinates 
		* @returns Number 
		*/
		getRight?( local?:boolean ): number;
		/** [Method] Returns the current scroll position of the element  
		* @returns Object An object containing the scroll position in the format {left: (scrollLeft), top: (scrollTop)} 
		*/
		getScroll?(): any;
		/** [Method] Gets the left scroll position Defined in override Ext dom Element_scroll  
		* @returns Number The left scroll position 
		*/
		getScrollLeft?(): number;
		/** [Method] Gets the top scroll position Defined in override Ext dom Element_scroll  
		* @returns Number The top scroll position 
		*/
		getScrollTop?(): number;
		/** [Method] Returns the dimensions of the element available to lay content out in  
		* @returns Object Object describing width and height. 
		*/
		getStyleSize?(): any;
		/** [Method] Returns the width in pixels of the passed text or the width of the text in this Element  
		* @param text String The text to measure. Defaults to the innerHTML of the element. 
		* @param min Number The minumum value to return. 
		* @param max Number The maximum value to return. 
		* @returns Number The text width in pixels. 
		*/
		getTextWidth?( text?:string, min?:number, max?:number ): number;
		/** [Method] Gets the top Y coordinate Defined in override Ext dom Element_position  
		* @param local Boolean True to get the local css position instead of page coordinates 
		* @returns Number 
		*/
		getTop?( local?:boolean ): number;
		/** [Method] Gets element X position in page coordinates Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getX?(): number;
		/** [Method] Gets element X and Y positions in page coordinates Defined in override Ext dom Element_position  
		* @returns Array [x, y] 
		*/
		getXY?(): any[];
		/** [Method] Gets element Y position in page coordinates Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getY?(): number;
		/** [Method] Slides the element while fading it out of view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to bottom: 'b') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		ghost?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Hide this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		hide?( animate?:any ): Ext.dom.IElement;
		/** [Method] Highlights the Element by setting a color applies to the background color by default but can be changed using the  
		* @param color String The highlight color. Should be a 6 char hex color without the leading # (defaults to yellow: 'ffff9c') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		highlight?( color?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element  
		* @param overFn Function The function to call when the mouse enters the Element. 
		* @param outFn Function The function to call when the mouse leaves the Element. 
		* @param scope Object The scope (this reference) in which the functions are executed. Defaults to the Element's DOM element. 
		* @param options Object Options for the listener. See the options parameter. 
		* @returns Ext.dom.Element this 
		*/
		hover?( overFn?:any, outFn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Initializes a Ext dd DD drag drop object for this element  
		* @param group String The group the DD object is member of 
		* @param config Object The DD config object 
		* @param overrides Object An object containing methods to override/implement on the DD object 
		* @returns Ext.dd.DD The DD object 
		*/
		initDD?( group?:string, config?:any, overrides?:any ): Ext.dd.IDD;
		/** [Method] Initializes a Ext dd DDProxy object for this element  
		* @param group String The group the DDProxy object is member of 
		* @param config Object The DDProxy config object 
		* @param overrides Object An object containing methods to override/implement on the DDProxy object 
		* @returns Ext.dd.DDProxy The DDProxy object 
		*/
		initDDProxy?( group?:string, config?:any, overrides?:any ): Ext.dd.IDDProxy;
		/** [Method] Initializes a Ext dd DDTarget object for this element  
		* @param group String The group the DDTarget object is member of 
		* @param config Object The DDTarget config object 
		* @param overrides Object An object containing methods to override/implement on the DDTarget object 
		* @returns Ext.dd.DDTarget The DDTarget object 
		*/
		initDDTarget?( group?:string, config?:any, overrides?:any ): Ext.dd.IDDTarget;
		/** [Method] Tests various css rules browsers to determine if this element uses a border box 
		* @returns Boolean 
		*/
		isBorderBox?(): boolean;
		/** [Method] Returns true if display is not none  
		* @returns Boolean 
		*/
		isDisplayed?(): boolean;
		/** [Method] Checks whether this element can be focused  
		* @param asFocusEl Object 
		* @returns Boolean True if the element is focusable 
		*/
		isFocusable?( asFocusEl?:any ): boolean;
		/** [Method] Returns true if this element is masked  
		* @returns Boolean 
		*/
		isMasked?(): boolean;
		/** [Method] Returns true if this element is scrollable  
		* @returns Boolean 
		*/
		isScrollable?(): boolean;
		/** [Method] Checks whether the element is currently visible using both visibility and display properties  
		* @param deep Boolean True to walk the dom and see if parent elements are hidden. If false, the function only checks the visibility of the element itself and it may return true even though a parent is not visible. 
		* @returns Boolean true if the element is currently visible, else false 
		*/
		isVisible?( deep?:boolean ): boolean;
		/** [Method] Direct access to the Ext ElementLoader Ext ElementLoader load method  
		* @param options Object 
		* @returns Ext.dom.Element this 
		*/
		load?( options?:any ): Ext.dom.IElement;
		/** [Method] Puts a mask over this element to disable user interaction  
		* @param msg String A message to display in the mask 
		* @param msgCls String A css class to apply to the msg element 
		* @returns Ext.dom.Element The mask element 
		*/
		mask?( msg?:string, msgCls?:string ): Ext.dom.IElement;
		/** [Method] Monitors this Element for the mouse leaving  
		* @param delay Number The delay in milliseconds to wait for possible mouse re-entry before calling the handler function. 
		* @param handler Function The function to call if the mouse remains outside of this Element for the specified time. 
		* @param scope Object The scope (this reference) in which the handler function executes. Defaults to this Element. 
		* @returns Object The listeners object which was added to this element so that monitoring can be stopped. Example usage: // Hide the menu if the mouse moves out for 250ms or more this.mouseLeaveMonitor = this.menuEl.monitorMouseLeave(250, this.hideMenu, this); ... // Remove mouseleave monitor on menu destroy this.menuEl.un(this.mouseLeaveMonitor); 
		*/
		monitorMouseLeave?( delay?:number, handler?:any, scope?:any ): any;
		/** [Method] Sets the position of the element in page coordinates  
		* @param x Number X value for new position (coordinates are page-based) 
		* @param y Number Y value for new position (coordinates are page-based) 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		moveTo?( x?:number, y?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Returns true if this element needs an explicit tabIndex to make it focusable  */
		needsTabIndex?(): void;
		/** [Method] Appends an event handler to this element  
		* @param eventName String The name of event to handle. 
		* @param fn Function The handler function the event invokes. This function is passed the following parameters: evt : EventObject The EventObject describing the event. el : HtmlElement The DOM element which was the target of the event. Note that this may be filtered by using the delegate option. o : Object The options object from the call that setup the listener.  
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. 
		* @param options Object An object containing handler configuration properties. This may contain any of the following properties: scope Object : The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. delegate String: A simple selector to filter the target or look for a descendant of the target. See below for additional details. stopEvent Boolean: True to stop the event. That is stop propagation, and prevent the default action. preventDefault Boolean: True to prevent the default action stopPropagation Boolean: True to prevent event propagation normalized Boolean: False to pass a browser event to the handler function instead of an Ext.EventObject target Ext.dom.Element: Only call the handler if the event was fired on the target Element, not if the event was bubbled up from a child node. delay Number: The number of milliseconds to delay the invocation of the handler after the event fires. single Boolean: True to add a handler to handle just the next firing of the event, and then remove itself. buffer Number: Causes the handler to be scheduled to run in an Ext.util.DelayedTask delayed by the specified number of milliseconds. If the event fires again within that time, the original handler is not invoked, but the new handler is scheduled in its place. Combining Options  Using the options argument, it is possible to combine different types of listeners:  A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options object. The options object is available as the third parameter in the handler function.  Code:  el.on('click', this.onClick, this, {  single: true,  delay: 100,  stopEvent : true,  forumId: 4 }); Attaching multiple handlers in 1 call  The method also allows for a single argument to be passed which is a config object containing properties which specify multiple handlers.  Code:  el.on({  'click' : {  fn: this.onClick,  scope: this,  delay: 100  },  'mouseover' : {  fn: this.onMouseOver,  scope: this  },  'mouseout' : {  fn: this.onMouseOut,  scope: this  } }); Or a shorthand syntax:  Code:  el.on({  'click' : this.onClick,  'mouseover' : this.onMouseOver,  'mouseout' : this.onMouseOut,  scope: this }); delegate  This is a configuration option that you can pass along when registering a handler for an event to assist with event delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure to memory-leaks. By registering an event for a container element as opposed to each element within a container. By setting this configuration option to a simple selector, the target element will be filtered to look for a descendant of the target. For example:  // using this markup: &lt;div id='elId'&gt;  &lt;p id='p1'&gt;paragraph one&lt;/p&gt;  &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;  &lt;p id='p3'&gt;paragraph three&lt;/p&gt; &lt;/div&gt; // utilize event delegation to registering just one handler on the container element: el = Ext.get('elId'); el.on(  'click',  function(e,t) {  // handle click  console.info(t.id); // 'p2'  },  this,  {  // filter the target element to be a descendant with the class 'clickable'  delegate: '.clickable'  } );  
		* @returns Ext.dom.Element this 
		*/
		on?( eventName?:string, fn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Creates a pause before any subsequent queued effects begin  
		* @param seconds Number The length of time to pause (in seconds) 
		* @returns Ext.Element The Element 
		*/
		pause?( seconds?:number ): Ext.IElement;
		/** [Method] Initializes positioning on this element  
		* @param pos String Positioning to use "relative", "absolute" or "fixed" 
		* @param zIndex Number The zIndex to apply 
		* @param x Number Set the page X position 
		* @param y Number Set the page Y position 
		*/
		position?( pos?:string, zIndex?:number, x?:number, y?:number ): void;
		/** [Method] Fades the element out while slowly expanding it in all directions  
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		puff?( options?:any ): Ext.dom.IElement;
		/** [Method] Recursively removes all previous added listeners from this element and its children 
		* @returns Ext.dom.Element this 
		*/
		purgeAllListeners?(): Ext.dom.IElement;
		/** [Method] Create an event handler on this element such that when the event fires and is handled by this element it will be rel  
		* @param eventName String The type of event to relay 
		* @param observable Object Any object that extends Ext.util.Observable that will provide the context for firing the relayed event 
		*/
		relayEvent?( eventName?:string, observable?:any ): void;
		/** [Method] Removes all previous added listeners from this element 
		* @returns Ext.dom.Element this 
		*/
		removeAllListeners?(): Ext.dom.IElement;
		/** [Method] Shorthand for un  
		* @param eventName String The name of the event from which to remove the handler. 
		* @param fn Function The handler function to remove. This must be a reference to the function passed into the on call. 
		* @param scope Object If a scope (this reference) was specified when the listener was added, then this must refer to the same object. 
		* @returns Ext.dom.Element this 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Animates the transition of an element s dimensions from a starting height width to an ending height width  
		* @param width Number The new width (pass undefined to keep the original width) 
		* @param height Number The new height (pass undefined to keep the original height) 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		scale?( width?:number, height?:number, options?:any ): Ext.IElement;
		/** [Method] Scrolls this element the specified direction  
		* @param direction String Possible values are:  "l" (or "left") "r" (or "right") "t" (or "top", or "up") "b" (or "bottom", or "down")  
		* @param distance Number How far to scroll the element in pixels 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Boolean Returns true if a scroll was triggered or false if the element was scrolled as far as it could go. 
		*/
		scroll?( direction?:string, distance?:number, animate?:any ): boolean;
		/** [Method] Scrolls this element by the passed delta values optionally animating  
		* @param deltaX Number/Number[]/Object Either the x delta, an Array specifying x and y deltas or an object with "x" and "y" properties. 
		* @param deltaY Number/Boolean/Object Either the y delta, or an animate flag or config object. 
		* @param animate Boolean/Object Animate flag/config object if the delta values were passed separately. 
		* @returns Ext.Element this 
		*/
		scrollBy?( deltaX?:any, deltaY?:any, animate?:any ): Ext.IElement;
		/** [Method] Scrolls this element into view within the passed container  
		* @param container String/HTMLElement/Ext.Element The container element to scroll. Should be a string (id), dom node, or Ext.Element. 
		* @param hscroll Boolean False to disable horizontal scroll. 
		* @param animate Boolean/Object true for the default animation or a standard Element 
		* @param highlight Boolean true to highlight the element when it is in view. animation config object 
		* @returns Ext.dom.Element this 
		*/
		scrollIntoView?( container?:any, hscroll?:boolean, animate?:any, highlight?:boolean ): Ext.dom.IElement;
		/** [Method] Scrolls this element the specified scroll point  
		* @param side String Either "left" for scrollLeft values or "top" for scrollTop values. 
		* @param value Number The new scroll value 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.Element this 
		*/
		scrollTo?( side?:string, value?:number, animate?:any ): Ext.IElement;
		/** [Method] Enable text selection for this element normalized across browsers  Defined in override Ext dom Element_style  
		* @returns Ext.Element this 
		*/
		selectable?(): Ext.IElement;
		/** [Method] Sets the element s CSS bottom style  
		* @param bottom Number/String Number of pixels or CSS string value to set as the bottom CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setBottom?( bottom?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s position and size in one shot  
		* @param x Number X value for new position (coordinates are page-based) 
		* @param y Number Y value for new position (coordinates are page-based) 
		* @param width Number/String The new width. This may be one of:  A Number specifying the new width in this Element's defaultUnits (by default, pixels) A String used to set the CSS width style. Animation may not be used.  
		* @param height Number/String The new height. This may be one of:  A Number specifying the new height in this Element's defaultUnits (by default, pixels) A String used to set the CSS height style. Animation may not be used.  
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setBounds?( x?:number, y?:number, width?:any, height?:any, animate?:any ): Ext.dom.IElement;
		/** [Method] Sets the CSS display property  
		* @param value Boolean/String Boolean value to display the element using its default display, or a string to set the display directly. 
		* @returns Ext.dom.Element this 
		*/
		setDisplayed?( value?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left position directly using CSS style instead of setX 
		* @param left Number/String Number of pixels or CSS string value to set as the left CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setLeft?( left?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left and top positions directly using CSS style Defined in override Ext dom Element_position  
		* @param left Number/String Number of pixels or CSS string value to set as the left CSS property value 
		* @param top Number/String Number of pixels or CSS string value to set as the top CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setLeftTop?( left?:any, top?:any ): Ext.dom.IElement;
		/** [Method] Sets the position of the element in page coordinates  
		* @param x Number X value for new position 
		* @param y Number Y value for new position 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setLocation?( x?:number, y?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Set the opacity of the element Defined in override Ext dom Element_style  
		* @param opacity Number The new opacity. 0 = transparent, .5 = 50% visibile, 1 = fully visible, etc 
		* @param animate Boolean/Object a standard Element animation config object or true for the default animation ({duration: 350, easing: 'easeIn'}) 
		* @returns Ext.dom.Element this 
		*/
		setOpacity?( opacity?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Set positioning with an object returned by getPositioning  
		* @param posCfg Object 
		* @returns Ext.dom.Element this 
		*/
		setPositioning?( posCfg?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s CSS right style  
		* @param right Number/String Number of pixels or CSS string value to set as the right CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setRight?( right?:any ): Ext.dom.IElement;
		/** [Method] Sets the left scroll position Defined in override Ext dom Element_scroll  
		* @param left Number The left scroll position 
		* @returns Ext.dom.Element this 
		*/
		setScrollLeft?( left?:number ): Ext.dom.IElement;
		/** [Method] Sets the top scroll position Defined in override Ext dom Element_scroll  
		* @param top Number The top scroll position 
		* @returns Ext.dom.Element this 
		*/
		setScrollTop?( top?:number ): Ext.dom.IElement;
		/** [Method] Sets the element s top position directly using CSS style instead of setY 
		* @param top Number/String Number of pixels or CSS string value to set as the top CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setTop?( top?:any ): Ext.dom.IElement;
		/** [Method] Sets the visibility of the element see details 
		* @param visible Boolean Whether the element is visible 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setVisible?( visible?:boolean, animate?:any ): Ext.dom.IElement;
		/** [Method] Animates the transition of any combination of an element s dimensions xy position and or opacity  
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		shift?( options?:any ): Ext.IElement;
		/** [Method] Show this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		show?( animate?:any ): Ext.dom.IElement;
		/** [Method] Slides the element into view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to top: 't') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		slideIn?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Slides the element out of view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to top: 't') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		slideOut?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Stops the specified event s from bubbling and optionally prevents the default action 
		* @param eventName String/String[] an event / array of events to stop from bubbling 
		* @param preventDefault Boolean true to prevent the default action too 
		* @returns Ext.dom.Element this 
		*/
		swallowEvent?( eventName?:any, preventDefault?:boolean ): Ext.dom.IElement;
		/** [Method] Blinks the element as if it was clicked and then collapses on its center similar to switching off a television 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		switchOff?( options?:any ): Ext.dom.IElement;
		/** [Method] Toggles the element s visibility or display depending on visibility mode  
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		toggle?( animate?:any ): Ext.dom.IElement;
		/** [Method] Removes an event handler from this element  
		* @param eventName String The name of the event from which to remove the handler. 
		* @param fn Function The handler function to remove. This must be a reference to the function passed into the on call. 
		* @param scope Object If a scope (this reference) was specified when the listener was added, then this must refer to the same object. 
		* @returns Ext.dom.Element this 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Return clipping overflow to original clipping before clip was called Defined in override Ext dom Element_style  
		* @returns Ext.dom.Element this 
		*/
		unclip?(): Ext.dom.IElement;
		/** [Method] Hides a previously applied mask  */
		unmask?(): void;
		/** [Method] Disables text selection for this element normalized across browsers  Defined in override Ext dom Element_style  
		* @returns Ext.dom.Element this 
		*/
		unselectable?(): Ext.dom.IElement;
		/** [Method] Updates the innerHTML of this element optionally searching for and processing scripts  
		* @param html String The new HTML 
		* @param loadScripts Boolean True to look for and process scripts (defaults to false) 
		* @param callback Function For async script loading you can be notified when the update completes 
		* @returns Ext.dom.Element this 
		*/
		update?( html?:string, loadScripts?:boolean, callback?:any ): Ext.dom.IElement;
	}
	export class Element {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Returns the top Element that is located at the passed coordinates Defined in override Ext dom AbstractElement_static  
		* @param x Number The x coordinate 
		* @param y Number The y coordinate 
		* @returns String The found Element 
		*/
		static fromPoint( x?:number, y?:number ): string;
		/** [Method] Retrieves Ext dom Element objects  
		* @param el String/HTMLElement/Ext.Element The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.Element The Element object (or null if no matching element was found) 
		*/
		static get( el?:any ): Ext.dom.IElement;
		/** [Method] Retrieves the document height Defined in override Ext dom AbstractElement_static  
		* @returns Number documentHeight 
		*/
		static getDocumentHeight(): number;
		/** [Method] Retrieves the document width Defined in override Ext dom AbstractElement_static  
		* @returns Number documentWidth 
		*/
		static getDocumentWidth(): number;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Retrieves the current orientation of the window  
		* @returns String Orientation of window: 'portrait' or 'landscape' 
		*/
		static getOrientation(): string;
		/** [Method] Retrieves the viewport size of the window  
		* @returns Object object containing width and height properties 
		*/
		static getViewSize(): any;
		/** [Method] Retrieves the viewport height of the window  
		* @returns Number viewportHeight 
		*/
		static getViewportHeight(): number;
		/** [Method] Retrieves the viewport width of the window  
		* @returns Number viewportWidth 
		*/
		static getViewportWidth(): number;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Returns an array of unique class names based upon the input strings or string arrays  
		* @param clsList1 Mixed A string of class names, or an array of class names. 
		* @param clsList2 Mixed A string of class names, or an array of class names. 
		* @returns Array An array of strings representing remaining unique, merged class names. If class names were added to the first list, the changed property will be true. 
		*/
		static mergeClsList( clsList1?:any, clsList2?:any ): any[];
		/** [Method] Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax  
		* @param prop String The property to normalize 
		* @returns String The normalized string 
		*/
		static normalize( prop?:string ): string;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String The encoded margins 
		* @returns Object An object with margin sizes for top, right, bottom and left 
		*/
		static parseBox( box?:any ): any;
		/** [Method] Converts a CSS string into an object with a property for each style  
		* @param styles String A CSS string 
		* @returns Object styles 
		*/
		static parseStyles( styles?:string ): any;
		/** [Method] Returns an array of unique class names deom the first parameter with all class names from the second parameter removed  
		* @param existingClsList Mixed A string of class names, or an array of class names. 
		* @param removeClsList Mixed A string of class names, or an array of class names to remove from existingClsList. 
		* @returns Array An array of strings representing remaining class names. If class names were removed, the changed property will be true. 
		*/
		static removeCls( existingClsList?:any, removeClsList?:any ): any[];
		/** [Method] Selects elements based on the passed CSS selector to enable Element methods to be applied to many related elements in  
		* @param selector String/HTMLElement[] The CSS selector or an array of elements 
		* @param unique Boolean true to create a unique Ext.Element for each element (defaults to a shared flyweight object) 
		* @param root HTMLElement/String The root element of the query or id of the root 
		* @returns Ext.CompositeElementLite/Ext.CompositeElement 
		*/
		static select( selector?:any, unique?:boolean, root?:any ): any;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String/Object The encoded margins, or an object with top, right, bottom, and left properties 
		* @param units String The type of units to add 
		* @returns String An string with unitized (px if units is not specified) metrics for top, right, bottom and left 
		*/
		static unitizeBox( box?:any, units?:string ): string;
	}
}
declare module Ext.core {
	export interface IElement extends Ext.dom.IAbstractElement {
		/** [Property] (Boolean) */
		autoBoxAdjust?: boolean;
		/** [Property] (String) */
		originalDisplay?: string;
		/** [Method] Sets up event handlers to add and remove a css class when the mouse is down and then up on this element a click effe  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnClick?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to add and remove a css class when this element has the focus Defined in override Ext dom Ele  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnFocus?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to add and remove a css class when the mouse is over this element Defined in override Ext dom  
		* @param className String The class to add 
		* @param testFn Function A test function to execute before adding the class. The passed parameter will be the Element instance. If this functions returns false, the class will not be added. 
		* @param scope Object The scope to execute the testFn in. 
		* @returns Ext.dom.Element this 
		*/
		addClsOnOver?( className?:string, testFn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Convenience method for constructing a KeyMap 
		* @param key String/Number/Number[]/Object Either a string with the keys to listen for, the numeric key code, array of key codes or an object with the following options: 
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the specified function is executed. Defaults to this Element. 
		* @returns Ext.util.KeyMap The KeyMap created 
		*/
		addKeyListener?( key?:any, fn?:any, scope?:any ): Ext.util.IKeyMap;
		/** [Method] Creates a KeyMap for this element 
		* @param config Object The KeyMap config. See Ext.util.KeyMap for more details 
		* @returns Ext.util.KeyMap The KeyMap created 
		*/
		addKeyMap?( config?:any ): Ext.util.IKeyMap;
		/** [Method] Shorthand for on  
		* @param eventName String The name of event to handle. 
		* @param fn Function The handler function the event invokes. This function is passed the following parameters: evt : EventObject The EventObject describing the event. el : HtmlElement The DOM element which was the target of the event. Note that this may be filtered by using the delegate option. o : Object The options object from the call that setup the listener.  
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. 
		* @param options Object An object containing handler configuration properties. This may contain any of the following properties: scope Object : The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. delegate String: A simple selector to filter the target or look for a descendant of the target. See below for additional details. stopEvent Boolean: True to stop the event. That is stop propagation, and prevent the default action. preventDefault Boolean: True to prevent the default action stopPropagation Boolean: True to prevent event propagation normalized Boolean: False to pass a browser event to the handler function instead of an Ext.EventObject target Ext.dom.Element: Only call the handler if the event was fired on the target Element, not if the event was bubbled up from a child node. delay Number: The number of milliseconds to delay the invocation of the handler after the event fires. single Boolean: True to add a handler to handle just the next firing of the event, and then remove itself. buffer Number: Causes the handler to be scheduled to run in an Ext.util.DelayedTask delayed by the specified number of milliseconds. If the event fires again within that time, the original handler is not invoked, but the new handler is scheduled in its place. Combining Options  Using the options argument, it is possible to combine different types of listeners:  A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options object. The options object is available as the third parameter in the handler function.  Code:  el.on('click', this.onClick, this, {  single: true,  delay: 100,  stopEvent : true,  forumId: 4 }); Attaching multiple handlers in 1 call  The method also allows for a single argument to be passed which is a config object containing properties which specify multiple handlers.  Code:  el.on({  'click' : {  fn: this.onClick,  scope: this,  delay: 100  },  'mouseover' : {  fn: this.onMouseOver,  scope: this  },  'mouseout' : {  fn: this.onMouseOut,  scope: this  } }); Or a shorthand syntax:  Code:  el.on({  'click' : this.onClick,  'mouseover' : this.onMouseOver,  'mouseout' : this.onMouseOut,  scope: this }); delegate  This is a configuration option that you can pass along when registering a handler for an event to assist with event delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure to memory-leaks. By registering an event for a container element as opposed to each element within a container. By setting this configuration option to a simple selector, the target element will be filtered to look for a descendant of the target. For example:  // using this markup: &lt;div id='elId'&gt;  &lt;p id='p1'&gt;paragraph one&lt;/p&gt;  &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;  &lt;p id='p3'&gt;paragraph three&lt;/p&gt; &lt;/div&gt; // utilize event delegation to registering just one handler on the container element: el = Ext.get('elId'); el.on(  'click',  function(e,t) {  // handle click  console.info(t.id); // 'p2'  },  this,  {  // filter the target element to be a descendant with the class 'clickable'  delegate: '.clickable'  } );  
		* @returns Ext.dom.Element this 
		*/
		addListener?( eventName?:string, fn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Performs custom animation on this Element  
		* @param config Object Configuration for Ext.fx.Anim. Note that the to config is required. 
		* @returns Ext.dom.Element this 
		*/
		animate?( config?:any ): Ext.dom.IElement;
		/** [Method] Tries to blur the element  
		* @returns Ext.dom.Element this 
		*/
		blur?(): Ext.dom.IElement;
		/** [Method] Wraps the specified element with a special 9 element markup CSS block that renders by default as a gray container wit  
		* @param class String A base CSS class to apply to the containing wrapper element. Note that there are a number of CSS rules that are dependent on this name to make the overall effect work, so if you supply an alternate base class, make sure you also supply all of the necessary rules. 
		* @returns Ext.dom.Element The outermost wrapping element of the created box structure. 
		*/
		boxWrap?( clazz?:string ): Ext.dom.IElement;
		/** [Method] When an element is moved around in the DOM or is hidden using display none it loses layout and therefore all scrol  
		* @returns Function A function which will restore all descentant elements of this Element to their scroll positions recorded when this function was executed. Be aware that the returned function is a closure which has captured the scope of cacheScrollValues, so take care to derefence it as soon as not needed - if is it is a var it will drop out of scope, and the reference will be freed. 
		*/
		cacheScrollValues?(): any;
		/** [Method] Centers the Element in either the viewport or another Element  
		* @param centerIn String/HTMLElement/Ext.dom.Element element in which to center the element. 
		*/
		center?( centerIn?:any ): void;
		/** [Method] Removes Empty or whitespace filled text nodes  
		* @param forceReclean Boolean By default the element keeps track if it has been cleaned already so you can call this over and over. However, if you update the element and need to force a reclean, you can pass true. 
		*/
		clean?( forceReclean?:boolean ): void;
		/** [Method] Alias for removeAllListeners  
		* @returns Ext.dom.Element this 
		*/
		clearListeners?(): Ext.dom.IElement;
		/** [Method] Clears any opacity settings from this element  
		* @returns Ext.dom.Element this 
		*/
		clearOpacity?(): Ext.dom.IElement;
		/** [Method] Clears positioning back to the default when the document was loaded  
		* @param value String The value to use for the left, right, top, bottom. You could use 'auto'. 
		* @returns Ext.dom.Element this 
		*/
		clearPositioning?( value?:string ): Ext.dom.IElement;
		/** [Method] Store the current overflow setting and clip overflow on the element  use unclip to remove Defined in override Ext d  
		* @returns Ext.dom.Element this 
		*/
		clip?(): Ext.dom.IElement;
		/** [Method] Creates a proxy element of this element 
		* @param config String/Object The class name of the proxy element or a DomHelper config object 
		* @param renderTo String/HTMLElement The element or element id to render the proxy to. Defaults to: document.body. 
		* @param matchBox Boolean True to align and size the proxy to this element now. 
		* @returns Ext.dom.Element The new proxy element 
		*/
		createProxy?( config?:any, renderTo?:any, matchBox?:boolean ): Ext.dom.IElement;
		/** [Method] Creates an iframe shim for this element to keep selects and other windowed objects from showing through  
		* @returns Ext.dom.Element The new shim element 
		*/
		createShim?(): Ext.dom.IElement;
		/** [Method] Convenience method for setVisibilityMode Element DISPLAY  
		* @param display String What to set display to when visible 
		* @returns Ext.dom.Element this 
		*/
		enableDisplayMode?( display?:string ): Ext.dom.IElement;
		/** [Method] Fade an element in from transparent to opaque 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		fadeIn?( options?:any ): Ext.IElement;
		/** [Method] Fade an element out from opaque to transparent 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		fadeOut?( options?:any ): Ext.IElement;
		/** [Method] Tries to focus the element  
		* @param defer Number Milliseconds to defer the focus 
		* @returns Ext.dom.Element this 
		*/
		focus?( defer?:number ): Ext.dom.IElement;
		/** [Method] Alias for isFocusable  
		* @returns Boolean True if the element is focusable 
		*/
		focusable?(): boolean;
		/** [Method] Shows a ripple of exploding attenuating borders to draw attention to an Element  
		* @param color String The hex color value for the border. 
		* @param count Number The number of ripples to display. 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		frame?( color?:string, count?:number, options?:any ): Ext.dom.IElement;
		/** [Method] Returns the value of a namespaced attribute from the element s underlying DOM node  
		* @param namespace String The namespace in which to look for the attribute 
		* @param name String The attribute name 
		* @returns String The attribute value 
		*/
		getAttributeNS?( namespace?:string, name?:string ): string;
		/** [Method] Gets the bottom Y coordinate of the element element Y position  element height  Defined in override Ext dom Elemen  
		* @param local Boolean True to get the local css position instead of page coordinate 
		* @returns Number 
		*/
		getBottom?( local?:boolean ): number;
		/** [Method] Calculates the x y to center this element on the screen Defined in override Ext dom Element_position  
		* @returns Number[] The x, y values [x, y] 
		*/
		getCenterXY?(): number[];
		/** [Method] Return the CSS color for the specified CSS attribute  
		* @param attr String The css attribute 
		* @param defaultValue String The default value to use when a valid color isn't found 
		* @param prefix String defaults to #. Use an empty string when working with color anims. 
		*/
		getColor?( attr?:string, defaultValue?:string, prefix?:string ): void;
		/** [Method] Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders when  
		* @returns Number 
		*/
		getComputedHeight?(): number;
		/** [Method] Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders when ne  
		* @returns Number 
		*/
		getComputedWidth?(): number;
		/** [Method] Returns the sum width of the padding and borders for the passed sides 
		* @param sides String 
		* @returns Number 
		*/
		getFrameWidth?( sides?:string ): number;
		/** [Method] Gets the left X coordinate Defined in override Ext dom Element_position  
		* @param local Boolean True to get the local css position instead of page coordinate 
		* @returns Number 
		*/
		getLeft?( local?:boolean ): number;
		/** [Method] Gets this element s ElementLoader 
		* @returns Ext.ElementLoader The loader 
		*/
		getLoader?(): Ext.IElementLoader;
		/** [Method] Gets the local CSS X position for the element Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getLocalX?(): number;
		/** [Method] Gets the local CSS X and Y position for the element Defined in override Ext dom Element_position  
		* @returns Array [x, y] 
		*/
		getLocalXY?(): any[];
		/** [Method] Gets the local CSS Y position for the element Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getLocalY?(): number;
		/** [Method] Returns an object defining the area of this Element which can be passed to Ext util Positionable setBox to set anothe  
		* @param asRegion Boolean If true an Ext.util.Region will be returned 
		* @returns Object/Ext.util.Region box An object in the following format: {  left: &lt;Element's X position&gt;,  top: &lt;Element's Y position&gt;,  width: &lt;Element's width&gt;,  height: &lt;Element's height&gt;,  bottom: &lt;Element's lower bound&gt;,  right: &lt;Element's rightmost bound&gt; }  The returned object may also be addressed as an Array where index 0 contains the X position and index 1 contains the Y position. So the result may also be used for setXY 
		*/
		getPageBox?( asRegion?:boolean ): any;
		/** [Method] Gets an object with all CSS positioning properties  
		* @param autoPx Boolean true to return pixel values for "auto" styles. 
		* @returns Object 
		*/
		getPositioning?( autoPx?:boolean ): any;
		/** [Method] Gets the right X coordinate of the element element X position  element width  Defined in override Ext dom Element_  
		* @param local Boolean True to get the local css position instead of page coordinates 
		* @returns Number 
		*/
		getRight?( local?:boolean ): number;
		/** [Method] Returns the current scroll position of the element  
		* @returns Object An object containing the scroll position in the format {left: (scrollLeft), top: (scrollTop)} 
		*/
		getScroll?(): any;
		/** [Method] Gets the left scroll position Defined in override Ext dom Element_scroll  
		* @returns Number The left scroll position 
		*/
		getScrollLeft?(): number;
		/** [Method] Gets the top scroll position Defined in override Ext dom Element_scroll  
		* @returns Number The top scroll position 
		*/
		getScrollTop?(): number;
		/** [Method] Returns the dimensions of the element available to lay content out in  
		* @returns Object Object describing width and height. 
		*/
		getStyleSize?(): any;
		/** [Method] Returns the width in pixels of the passed text or the width of the text in this Element  
		* @param text String The text to measure. Defaults to the innerHTML of the element. 
		* @param min Number The minumum value to return. 
		* @param max Number The maximum value to return. 
		* @returns Number The text width in pixels. 
		*/
		getTextWidth?( text?:string, min?:number, max?:number ): number;
		/** [Method] Gets the top Y coordinate Defined in override Ext dom Element_position  
		* @param local Boolean True to get the local css position instead of page coordinates 
		* @returns Number 
		*/
		getTop?( local?:boolean ): number;
		/** [Method] Gets element X position in page coordinates Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getX?(): number;
		/** [Method] Gets element X and Y positions in page coordinates Defined in override Ext dom Element_position  
		* @returns Array [x, y] 
		*/
		getXY?(): any[];
		/** [Method] Gets element Y position in page coordinates Defined in override Ext dom Element_position  
		* @returns Number 
		*/
		getY?(): number;
		/** [Method] Slides the element while fading it out of view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to bottom: 'b') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		ghost?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Hide this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		hide?( animate?:any ): Ext.dom.IElement;
		/** [Method] Highlights the Element by setting a color applies to the background color by default but can be changed using the  
		* @param color String The highlight color. Should be a 6 char hex color without the leading # (defaults to yellow: 'ffff9c') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		highlight?( color?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element  
		* @param overFn Function The function to call when the mouse enters the Element. 
		* @param outFn Function The function to call when the mouse leaves the Element. 
		* @param scope Object The scope (this reference) in which the functions are executed. Defaults to the Element's DOM element. 
		* @param options Object Options for the listener. See the options parameter. 
		* @returns Ext.dom.Element this 
		*/
		hover?( overFn?:any, outFn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Initializes a Ext dd DD drag drop object for this element  
		* @param group String The group the DD object is member of 
		* @param config Object The DD config object 
		* @param overrides Object An object containing methods to override/implement on the DD object 
		* @returns Ext.dd.DD The DD object 
		*/
		initDD?( group?:string, config?:any, overrides?:any ): Ext.dd.IDD;
		/** [Method] Initializes a Ext dd DDProxy object for this element  
		* @param group String The group the DDProxy object is member of 
		* @param config Object The DDProxy config object 
		* @param overrides Object An object containing methods to override/implement on the DDProxy object 
		* @returns Ext.dd.DDProxy The DDProxy object 
		*/
		initDDProxy?( group?:string, config?:any, overrides?:any ): Ext.dd.IDDProxy;
		/** [Method] Initializes a Ext dd DDTarget object for this element  
		* @param group String The group the DDTarget object is member of 
		* @param config Object The DDTarget config object 
		* @param overrides Object An object containing methods to override/implement on the DDTarget object 
		* @returns Ext.dd.DDTarget The DDTarget object 
		*/
		initDDTarget?( group?:string, config?:any, overrides?:any ): Ext.dd.IDDTarget;
		/** [Method] Tests various css rules browsers to determine if this element uses a border box 
		* @returns Boolean 
		*/
		isBorderBox?(): boolean;
		/** [Method] Returns true if display is not none  
		* @returns Boolean 
		*/
		isDisplayed?(): boolean;
		/** [Method] Checks whether this element can be focused  
		* @param asFocusEl Object 
		* @returns Boolean True if the element is focusable 
		*/
		isFocusable?( asFocusEl?:any ): boolean;
		/** [Method] Returns true if this element is masked  
		* @returns Boolean 
		*/
		isMasked?(): boolean;
		/** [Method] Returns true if this element is scrollable  
		* @returns Boolean 
		*/
		isScrollable?(): boolean;
		/** [Method] Checks whether the element is currently visible using both visibility and display properties  
		* @param deep Boolean True to walk the dom and see if parent elements are hidden. If false, the function only checks the visibility of the element itself and it may return true even though a parent is not visible. 
		* @returns Boolean true if the element is currently visible, else false 
		*/
		isVisible?( deep?:boolean ): boolean;
		/** [Method] Direct access to the Ext ElementLoader Ext ElementLoader load method  
		* @param options Object 
		* @returns Ext.dom.Element this 
		*/
		load?( options?:any ): Ext.dom.IElement;
		/** [Method] Puts a mask over this element to disable user interaction  
		* @param msg String A message to display in the mask 
		* @param msgCls String A css class to apply to the msg element 
		* @returns Ext.dom.Element The mask element 
		*/
		mask?( msg?:string, msgCls?:string ): Ext.dom.IElement;
		/** [Method] Monitors this Element for the mouse leaving  
		* @param delay Number The delay in milliseconds to wait for possible mouse re-entry before calling the handler function. 
		* @param handler Function The function to call if the mouse remains outside of this Element for the specified time. 
		* @param scope Object The scope (this reference) in which the handler function executes. Defaults to this Element. 
		* @returns Object The listeners object which was added to this element so that monitoring can be stopped. Example usage: // Hide the menu if the mouse moves out for 250ms or more this.mouseLeaveMonitor = this.menuEl.monitorMouseLeave(250, this.hideMenu, this); ... // Remove mouseleave monitor on menu destroy this.menuEl.un(this.mouseLeaveMonitor); 
		*/
		monitorMouseLeave?( delay?:number, handler?:any, scope?:any ): any;
		/** [Method] Sets the position of the element in page coordinates  
		* @param x Number X value for new position (coordinates are page-based) 
		* @param y Number Y value for new position (coordinates are page-based) 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		moveTo?( x?:number, y?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Returns true if this element needs an explicit tabIndex to make it focusable  */
		needsTabIndex?(): void;
		/** [Method] Appends an event handler to this element  
		* @param eventName String The name of event to handle. 
		* @param fn Function The handler function the event invokes. This function is passed the following parameters: evt : EventObject The EventObject describing the event. el : HtmlElement The DOM element which was the target of the event. Note that this may be filtered by using the delegate option. o : Object The options object from the call that setup the listener.  
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. 
		* @param options Object An object containing handler configuration properties. This may contain any of the following properties: scope Object : The scope (this reference) in which the handler function is executed. If omitted, defaults to this Element. delegate String: A simple selector to filter the target or look for a descendant of the target. See below for additional details. stopEvent Boolean: True to stop the event. That is stop propagation, and prevent the default action. preventDefault Boolean: True to prevent the default action stopPropagation Boolean: True to prevent event propagation normalized Boolean: False to pass a browser event to the handler function instead of an Ext.EventObject target Ext.dom.Element: Only call the handler if the event was fired on the target Element, not if the event was bubbled up from a child node. delay Number: The number of milliseconds to delay the invocation of the handler after the event fires. single Boolean: True to add a handler to handle just the next firing of the event, and then remove itself. buffer Number: Causes the handler to be scheduled to run in an Ext.util.DelayedTask delayed by the specified number of milliseconds. If the event fires again within that time, the original handler is not invoked, but the new handler is scheduled in its place. Combining Options  Using the options argument, it is possible to combine different types of listeners:  A delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the options object. The options object is available as the third parameter in the handler function.  Code:  el.on('click', this.onClick, this, {  single: true,  delay: 100,  stopEvent : true,  forumId: 4 }); Attaching multiple handlers in 1 call  The method also allows for a single argument to be passed which is a config object containing properties which specify multiple handlers.  Code:  el.on({  'click' : {  fn: this.onClick,  scope: this,  delay: 100  },  'mouseover' : {  fn: this.onMouseOver,  scope: this  },  'mouseout' : {  fn: this.onMouseOut,  scope: this  } }); Or a shorthand syntax:  Code:  el.on({  'click' : this.onClick,  'mouseover' : this.onMouseOver,  'mouseout' : this.onMouseOut,  scope: this }); delegate  This is a configuration option that you can pass along when registering a handler for an event to assist with event delegation. Event delegation is a technique that is used to reduce memory consumption and prevent exposure to memory-leaks. By registering an event for a container element as opposed to each element within a container. By setting this configuration option to a simple selector, the target element will be filtered to look for a descendant of the target. For example:  // using this markup: &lt;div id='elId'&gt;  &lt;p id='p1'&gt;paragraph one&lt;/p&gt;  &lt;p id='p2' class='clickable'&gt;paragraph two&lt;/p&gt;  &lt;p id='p3'&gt;paragraph three&lt;/p&gt; &lt;/div&gt; // utilize event delegation to registering just one handler on the container element: el = Ext.get('elId'); el.on(  'click',  function(e,t) {  // handle click  console.info(t.id); // 'p2'  },  this,  {  // filter the target element to be a descendant with the class 'clickable'  delegate: '.clickable'  } );  
		* @returns Ext.dom.Element this 
		*/
		on?( eventName?:string, fn?:any, scope?:any, options?:any ): Ext.dom.IElement;
		/** [Method] Creates a pause before any subsequent queued effects begin  
		* @param seconds Number The length of time to pause (in seconds) 
		* @returns Ext.Element The Element 
		*/
		pause?( seconds?:number ): Ext.IElement;
		/** [Method] Initializes positioning on this element  
		* @param pos String Positioning to use "relative", "absolute" or "fixed" 
		* @param zIndex Number The zIndex to apply 
		* @param x Number Set the page X position 
		* @param y Number Set the page Y position 
		*/
		position?( pos?:string, zIndex?:number, x?:number, y?:number ): void;
		/** [Method] Fades the element out while slowly expanding it in all directions  
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		puff?( options?:any ): Ext.dom.IElement;
		/** [Method] Recursively removes all previous added listeners from this element and its children 
		* @returns Ext.dom.Element this 
		*/
		purgeAllListeners?(): Ext.dom.IElement;
		/** [Method] Create an event handler on this element such that when the event fires and is handled by this element it will be rel  
		* @param eventName String The type of event to relay 
		* @param observable Object Any object that extends Ext.util.Observable that will provide the context for firing the relayed event 
		*/
		relayEvent?( eventName?:string, observable?:any ): void;
		/** [Method] Removes all previous added listeners from this element 
		* @returns Ext.dom.Element this 
		*/
		removeAllListeners?(): Ext.dom.IElement;
		/** [Method] Shorthand for un  
		* @param eventName String The name of the event from which to remove the handler. 
		* @param fn Function The handler function to remove. This must be a reference to the function passed into the on call. 
		* @param scope Object If a scope (this reference) was specified when the listener was added, then this must refer to the same object. 
		* @returns Ext.dom.Element this 
		*/
		removeListener?( eventName?:string, fn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Animates the transition of an element s dimensions from a starting height width to an ending height width  
		* @param width Number The new width (pass undefined to keep the original width) 
		* @param height Number The new height (pass undefined to keep the original height) 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		scale?( width?:number, height?:number, options?:any ): Ext.IElement;
		/** [Method] Scrolls this element the specified direction  
		* @param direction String Possible values are:  "l" (or "left") "r" (or "right") "t" (or "top", or "up") "b" (or "bottom", or "down")  
		* @param distance Number How far to scroll the element in pixels 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Boolean Returns true if a scroll was triggered or false if the element was scrolled as far as it could go. 
		*/
		scroll?( direction?:string, distance?:number, animate?:any ): boolean;
		/** [Method] Scrolls this element by the passed delta values optionally animating  
		* @param deltaX Number/Number[]/Object Either the x delta, an Array specifying x and y deltas or an object with "x" and "y" properties. 
		* @param deltaY Number/Boolean/Object Either the y delta, or an animate flag or config object. 
		* @param animate Boolean/Object Animate flag/config object if the delta values were passed separately. 
		* @returns Ext.Element this 
		*/
		scrollBy?( deltaX?:any, deltaY?:any, animate?:any ): Ext.IElement;
		/** [Method] Scrolls this element into view within the passed container  
		* @param container String/HTMLElement/Ext.Element The container element to scroll. Should be a string (id), dom node, or Ext.Element. 
		* @param hscroll Boolean False to disable horizontal scroll. 
		* @param animate Boolean/Object true for the default animation or a standard Element 
		* @param highlight Boolean true to highlight the element when it is in view. animation config object 
		* @returns Ext.dom.Element this 
		*/
		scrollIntoView?( container?:any, hscroll?:boolean, animate?:any, highlight?:boolean ): Ext.dom.IElement;
		/** [Method] Scrolls this element the specified scroll point  
		* @param side String Either "left" for scrollLeft values or "top" for scrollTop values. 
		* @param value Number The new scroll value 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.Element this 
		*/
		scrollTo?( side?:string, value?:number, animate?:any ): Ext.IElement;
		/** [Method] Enable text selection for this element normalized across browsers  Defined in override Ext dom Element_style  
		* @returns Ext.Element this 
		*/
		selectable?(): Ext.IElement;
		/** [Method] Sets the element s CSS bottom style  
		* @param bottom Number/String Number of pixels or CSS string value to set as the bottom CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setBottom?( bottom?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s position and size in one shot  
		* @param x Number X value for new position (coordinates are page-based) 
		* @param y Number Y value for new position (coordinates are page-based) 
		* @param width Number/String The new width. This may be one of:  A Number specifying the new width in this Element's defaultUnits (by default, pixels) A String used to set the CSS width style. Animation may not be used.  
		* @param height Number/String The new height. This may be one of:  A Number specifying the new height in this Element's defaultUnits (by default, pixels) A String used to set the CSS height style. Animation may not be used.  
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setBounds?( x?:number, y?:number, width?:any, height?:any, animate?:any ): Ext.dom.IElement;
		/** [Method] Sets the CSS display property  
		* @param value Boolean/String Boolean value to display the element using its default display, or a string to set the display directly. 
		* @returns Ext.dom.Element this 
		*/
		setDisplayed?( value?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left position directly using CSS style instead of setX 
		* @param left Number/String Number of pixels or CSS string value to set as the left CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setLeft?( left?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left and top positions directly using CSS style Defined in override Ext dom Element_position  
		* @param left Number/String Number of pixels or CSS string value to set as the left CSS property value 
		* @param top Number/String Number of pixels or CSS string value to set as the top CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setLeftTop?( left?:any, top?:any ): Ext.dom.IElement;
		/** [Method] Sets the position of the element in page coordinates  
		* @param x Number X value for new position 
		* @param y Number Y value for new position 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setLocation?( x?:number, y?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Set the opacity of the element Defined in override Ext dom Element_style  
		* @param opacity Number The new opacity. 0 = transparent, .5 = 50% visibile, 1 = fully visible, etc 
		* @param animate Boolean/Object a standard Element animation config object or true for the default animation ({duration: 350, easing: 'easeIn'}) 
		* @returns Ext.dom.Element this 
		*/
		setOpacity?( opacity?:number, animate?:any ): Ext.dom.IElement;
		/** [Method] Set positioning with an object returned by getPositioning  
		* @param posCfg Object 
		* @returns Ext.dom.Element this 
		*/
		setPositioning?( posCfg?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s CSS right style  
		* @param right Number/String Number of pixels or CSS string value to set as the right CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setRight?( right?:any ): Ext.dom.IElement;
		/** [Method] Sets the left scroll position Defined in override Ext dom Element_scroll  
		* @param left Number The left scroll position 
		* @returns Ext.dom.Element this 
		*/
		setScrollLeft?( left?:number ): Ext.dom.IElement;
		/** [Method] Sets the top scroll position Defined in override Ext dom Element_scroll  
		* @param top Number The top scroll position 
		* @returns Ext.dom.Element this 
		*/
		setScrollTop?( top?:number ): Ext.dom.IElement;
		/** [Method] Sets the element s top position directly using CSS style instead of setY 
		* @param top Number/String Number of pixels or CSS string value to set as the top CSS property value 
		* @returns Ext.dom.Element this 
		*/
		setTop?( top?:any ): Ext.dom.IElement;
		/** [Method] Sets the visibility of the element see details 
		* @param visible Boolean Whether the element is visible 
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		setVisible?( visible?:boolean, animate?:any ): Ext.dom.IElement;
		/** [Method] Animates the transition of any combination of an element s dimensions xy position and or opacity  
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.Element The Element 
		*/
		shift?( options?:any ): Ext.IElement;
		/** [Method] Show this element  Uses display mode to determine whether to use display or visibility 
		* @param animate Boolean/Object true for the default animation or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		show?( animate?:any ): Ext.dom.IElement;
		/** [Method] Slides the element into view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to top: 't') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		slideIn?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Slides the element out of view  
		* @param anchor String One of the valid Ext.fx.Anim anchor positions (defaults to top: 't') 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		slideOut?( anchor?:string, options?:any ): Ext.dom.IElement;
		/** [Method] Stops the specified event s from bubbling and optionally prevents the default action 
		* @param eventName String/String[] an event / array of events to stop from bubbling 
		* @param preventDefault Boolean true to prevent the default action too 
		* @returns Ext.dom.Element this 
		*/
		swallowEvent?( eventName?:any, preventDefault?:boolean ): Ext.dom.IElement;
		/** [Method] Blinks the element as if it was clicked and then collapses on its center similar to switching off a television 
		* @param options Object Object literal with any of the Ext.fx.Anim config options 
		* @returns Ext.dom.Element The Element 
		*/
		switchOff?( options?:any ): Ext.dom.IElement;
		/** [Method] Toggles the element s visibility or display depending on visibility mode  
		* @param animate Boolean/Object True for the default animation, or a standard Element animation config object 
		* @returns Ext.dom.Element this 
		*/
		toggle?( animate?:any ): Ext.dom.IElement;
		/** [Method] Removes an event handler from this element  
		* @param eventName String The name of the event from which to remove the handler. 
		* @param fn Function The handler function to remove. This must be a reference to the function passed into the on call. 
		* @param scope Object If a scope (this reference) was specified when the listener was added, then this must refer to the same object. 
		* @returns Ext.dom.Element this 
		*/
		un?( eventName?:string, fn?:any, scope?:any ): Ext.dom.IElement;
		/** [Method] Return clipping overflow to original clipping before clip was called Defined in override Ext dom Element_style  
		* @returns Ext.dom.Element this 
		*/
		unclip?(): Ext.dom.IElement;
		/** [Method] Hides a previously applied mask  */
		unmask?(): void;
		/** [Method] Disables text selection for this element normalized across browsers  Defined in override Ext dom Element_style  
		* @returns Ext.dom.Element this 
		*/
		unselectable?(): Ext.dom.IElement;
		/** [Method] Updates the innerHTML of this element optionally searching for and processing scripts  
		* @param html String The new HTML 
		* @param loadScripts Boolean True to look for and process scripts (defaults to false) 
		* @param callback Function For async script loading you can be notified when the update completes 
		* @returns Ext.dom.Element this 
		*/
		update?( html?:string, loadScripts?:boolean, callback?:any ): Ext.dom.IElement;
	}
	export class Element {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Returns the top Element that is located at the passed coordinates Defined in override Ext dom AbstractElement_static  
		* @param x Number The x coordinate 
		* @param y Number The y coordinate 
		* @returns String The found Element 
		*/
		static fromPoint( x?:number, y?:number ): string;
		/** [Method] Retrieves Ext dom Element objects  
		* @param el String/HTMLElement/Ext.Element The id of the node, a DOM Node or an existing Element. 
		* @returns Ext.dom.Element The Element object (or null if no matching element was found) 
		*/
		static get( el?:any ): Ext.dom.IElement;
		/** [Method] Retrieves the document height Defined in override Ext dom AbstractElement_static  
		* @returns Number documentHeight 
		*/
		static getDocumentHeight(): number;
		/** [Method] Retrieves the document width Defined in override Ext dom AbstractElement_static  
		* @returns Number documentWidth 
		*/
		static getDocumentWidth(): number;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Retrieves the current orientation of the window  
		* @returns String Orientation of window: 'portrait' or 'landscape' 
		*/
		static getOrientation(): string;
		/** [Method] Retrieves the viewport size of the window  
		* @returns Object object containing width and height properties 
		*/
		static getViewSize(): any;
		/** [Method] Retrieves the viewport height of the window  
		* @returns Number viewportHeight 
		*/
		static getViewportHeight(): number;
		/** [Method] Retrieves the viewport width of the window  
		* @returns Number viewportWidth 
		*/
		static getViewportWidth(): number;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Returns an array of unique class names based upon the input strings or string arrays  
		* @param clsList1 Mixed A string of class names, or an array of class names. 
		* @param clsList2 Mixed A string of class names, or an array of class names. 
		* @returns Array An array of strings representing remaining unique, merged class names. If class names were added to the first list, the changed property will be true. 
		*/
		static mergeClsList( clsList1?:any, clsList2?:any ): any[];
		/** [Method] Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax  
		* @param prop String The property to normalize 
		* @returns String The normalized string 
		*/
		static normalize( prop?:string ): string;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String The encoded margins 
		* @returns Object An object with margin sizes for top, right, bottom and left 
		*/
		static parseBox( box?:any ): any;
		/** [Method] Converts a CSS string into an object with a property for each style  
		* @param styles String A CSS string 
		* @returns Object styles 
		*/
		static parseStyles( styles?:string ): any;
		/** [Method] Returns an array of unique class names deom the first parameter with all class names from the second parameter removed  
		* @param existingClsList Mixed A string of class names, or an array of class names. 
		* @param removeClsList Mixed A string of class names, or an array of class names to remove from existingClsList. 
		* @returns Array An array of strings representing remaining class names. If class names were removed, the changed property will be true. 
		*/
		static removeCls( existingClsList?:any, removeClsList?:any ): any[];
		/** [Method] Selects elements based on the passed CSS selector to enable Element methods to be applied to many related elements in  
		* @param selector String/HTMLElement[] The CSS selector or an array of elements 
		* @param unique Boolean true to create a unique Ext.Element for each element (defaults to a shared flyweight object) 
		* @param root HTMLElement/String The root element of the query or id of the root 
		* @returns Ext.CompositeElementLite/Ext.CompositeElement 
		*/
		static select( selector?:any, unique?:boolean, root?:any ): any;
		/** [Method] Parses a number or string representing margin sizes into an object  
		* @param box Number/String/Object The encoded margins, or an object with top, right, bottom, and left properties 
		* @param units String The type of units to add 
		* @returns String An string with unitized (px if units is not specified) metrics for top, right, bottom and left 
		*/
		static unitizeBox( box?:any, units?:string ): string;
	}
}
declare module Ext.dom {
	export interface IHelper extends Ext.dom.IAbstractHelper {
		/** [Property] (Boolean) */
		useDom?: boolean;
		/** [Method] Creates new DOM element s without inserting them to the document  
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @returns HTMLElement The new uninserted node 
		*/
		createDom?( o?:any ): HTMLElement;
		/** [Method] Alias for markup  
		* @param spec Object The DOM object spec (and children) 
		* @returns String 
		*/
		createHtml?( spec?:any ): string;
		/** [Method] Creates a new Ext Template from the DOM object spec  
		* @param o Object The DOM object spec (and children) 
		* @returns Ext.Template The new template 
		*/
		createTemplate?( o?:any ): Ext.ITemplate;
		/** [Method] Creates new DOM element s and overwrites the contents of el with them  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return an Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		overwrite?( el?:any, o?:any, returnElement?:boolean ): any;
	}
}
declare module Ext.dom {
	export interface ILayer extends Ext.IElement {
		/** [Config Option] (String) */
		cls?: string;
		/** [Config Option] (Boolean) */
		constrain?: boolean;
		/** [Config Option] (Object) */
		dh?: any;
		/** [Config Option] (String) */
		hideMode?: string;
		/** [Config Option] (String/Boolean) */
		shadow?: any;
		/** [Config Option] (Number) */
		shadowOffset?: number;
		/** [Config Option] (Boolean) */
		shim?: boolean;
		/** [Config Option] (Boolean) */
		useDisplay?: boolean;
		/** [Config Option] (String) */
		visibilityCls?: string;
		/** [Config Option] (Number) */
		zindex?: number;
		/** [Method] Removes this element s dom reference  */
		remove?(): void;
		/** [Method] overridden Element method 
		* @param x Object 
		* @param y Object 
		* @param width Object 
		* @param height Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setBounds?( x?:any, y?:any, width?:any, height?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param h Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setHeight?( h?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param left Object 
		* @returns Ext.dom.Element this 
		*/
		setLeft?( left?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left and top positions directly using CSS style Defined in override Ext dom Element_position  
		* @param left Object 
		* @param top Object 
		* @returns Ext.dom.Element this 
		*/
		setLeftTop?( left?:any, top?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param w Object 
		* @param h Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setSize?( w?:any, h?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s top position directly using CSS style instead of setY 
		* @param top Object 
		* @returns Ext.dom.Element this 
		*/
		setTop?( top?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param visible Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setVisible?( visible?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param w Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setWidth?( w?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] Sets the z index of this layer and adjusts any shadow and shim z indexes  
		* @param zindex Number The new z-index to set 
		* @returns Ext.Layer The Layer 
		*/
		setZIndex?( zindex?:number ): Ext.ILayer;
	}
}
declare module Ext {
	export interface ILayer extends Ext.IElement {
		/** [Config Option] (String) */
		cls?: string;
		/** [Config Option] (Boolean) */
		constrain?: boolean;
		/** [Config Option] (Object) */
		dh?: any;
		/** [Config Option] (String) */
		hideMode?: string;
		/** [Config Option] (String/Boolean) */
		shadow?: any;
		/** [Config Option] (Number) */
		shadowOffset?: number;
		/** [Config Option] (Boolean) */
		shim?: boolean;
		/** [Config Option] (Boolean) */
		useDisplay?: boolean;
		/** [Config Option] (String) */
		visibilityCls?: string;
		/** [Config Option] (Number) */
		zindex?: number;
		/** [Method] Removes this element s dom reference  */
		remove?(): void;
		/** [Method] overridden Element method 
		* @param x Object 
		* @param y Object 
		* @param width Object 
		* @param height Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setBounds?( x?:any, y?:any, width?:any, height?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param h Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setHeight?( h?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param left Object 
		* @returns Ext.dom.Element this 
		*/
		setLeft?( left?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s left and top positions directly using CSS style Defined in override Ext dom Element_position  
		* @param left Object 
		* @param top Object 
		* @returns Ext.dom.Element this 
		*/
		setLeftTop?( left?:any, top?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param w Object 
		* @param h Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setSize?( w?:any, h?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] Sets the element s top position directly using CSS style instead of setY 
		* @param top Object 
		* @returns Ext.dom.Element this 
		*/
		setTop?( top?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param visible Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setVisible?( visible?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] overridden Element method 
		* @param w Object 
		* @param animate Object 
		* @param duration Object 
		* @param callback Object 
		* @param easing Object 
		* @returns Ext.dom.Element this 
		*/
		setWidth?( w?:any, animate?:any, duration?:any, callback?:any, easing?:any ): Ext.dom.IElement;
		/** [Method] Sets the z index of this layer and adjusts any shadow and shim z indexes  
		* @param zindex Number The new z-index to set 
		* @returns Ext.Layer The Layer 
		*/
		setZIndex?( zindex?:number ): Ext.ILayer;
	}
}
declare module Ext.dom {
	export interface IQuery {
	}
	export class Query {
		/** [Property] (Object) */
		static matchers: any;
		/** [Property] (Object) */
		static operators: any;
		/** [Property] (Object) */
		static pseudos: any;
		/** [Method] Compiles a selector xpath query into a reusable function  
		* @param selector String The selector/xpath query 
		* @param type String Either "select" or "simple" for a simple selector match 
		* @returns Function 
		*/
		static compile( selector?:string, type?:string ): any;
		/** [Method] Filters an array of elements to only include matches of a simple selector e g  
		* @param el HTMLElement[] An array of elements to filter 
		* @param selector String The simple selector to test 
		* @param nonMatches Boolean If true, it returns the elements that DON'T match the selector instead of the ones that match 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		static filter( el?:HTMLElement[], selector?:string, nonMatches?:boolean ): HTMLElement[];
		/** [Method] Returns true if the passed element s match the passed simple selector e g  
		* @param el String/HTMLElement/HTMLElement[] An element id, element or array of elements 
		* @param selector String The simple selector to test 
		* @returns Boolean 
		*/
		static is( el?:any, selector?:string ): boolean;
		/** [Method] Selects an array of DOM nodes using JavaScript only implementation  
		* @param selector String The selector/xpath query (can be a comma separated list of selectors) 
		* @param root HTMLElement/String The start of the query. 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		static jsSelect( selector?:string, root?:any ): HTMLElement[];
		/** [Method] Selects an array of DOM nodes by CSS XPath selector  
		* @param path String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param type String Either "select" or "simple" for a simple selector match (only valid when used when the call is deferred to the jsSelect method) 
		* @param single Boolean Pass true to select only the first matching node using document.querySelector (where available) 
		* @returns HTMLElement[] An array of DOM elements (not a NodeList as returned by querySelectorAll). 
		*/
		static select( path?:string, root?:HTMLElement, type?:string, single?:boolean ): HTMLElement[];
		/** [Method] Selects a single element  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @returns HTMLElement The DOM element which matched the selector. 
		*/
		static selectNode( selector?:string, root?:HTMLElement ): HTMLElement;
		/** [Method] Selects the value of a node parsing integers and floats  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param defaultValue Number When specified, this is return as empty value. 
		* @returns Number 
		*/
		static selectNumber( selector?:string, root?:HTMLElement, defaultValue?:number ): number;
		/** [Method] Selects the value of a node optionally replacing null with the defaultValue  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param defaultValue String When specified, this is return as empty value. 
		* @returns String 
		*/
		static selectValue( selector?:string, root?:HTMLElement, defaultValue?:string ): string;
	}
}
declare module Ext {
	export interface IDomQuery {
	}
	export class DomQuery {
		/** [Property] (Object) */
		static matchers: any;
		/** [Property] (Object) */
		static operators: any;
		/** [Property] (Object) */
		static pseudos: any;
		/** [Method] Compiles a selector xpath query into a reusable function  
		* @param selector String The selector/xpath query 
		* @param type String Either "select" or "simple" for a simple selector match 
		* @returns Function 
		*/
		static compile( selector?:string, type?:string ): any;
		/** [Method] Filters an array of elements to only include matches of a simple selector e g  
		* @param el HTMLElement[] An array of elements to filter 
		* @param selector String The simple selector to test 
		* @param nonMatches Boolean If true, it returns the elements that DON'T match the selector instead of the ones that match 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		static filter( el?:HTMLElement[], selector?:string, nonMatches?:boolean ): HTMLElement[];
		/** [Method] Returns true if the passed element s match the passed simple selector e g  
		* @param el String/HTMLElement/HTMLElement[] An element id, element or array of elements 
		* @param selector String The simple selector to test 
		* @returns Boolean 
		*/
		static is( el?:any, selector?:string ): boolean;
		/** [Method] Selects an array of DOM nodes using JavaScript only implementation  
		* @param selector String The selector/xpath query (can be a comma separated list of selectors) 
		* @param root HTMLElement/String The start of the query. 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		static jsSelect( selector?:string, root?:any ): HTMLElement[];
		/** [Method] Selects an array of DOM nodes by CSS XPath selector  
		* @param path String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param type String Either "select" or "simple" for a simple selector match (only valid when used when the call is deferred to the jsSelect method) 
		* @param single Boolean Pass true to select only the first matching node using document.querySelector (where available) 
		* @returns HTMLElement[] An array of DOM elements (not a NodeList as returned by querySelectorAll). 
		*/
		static select( path?:string, root?:HTMLElement, type?:string, single?:boolean ): HTMLElement[];
		/** [Method] Selects a single element  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @returns HTMLElement The DOM element which matched the selector. 
		*/
		static selectNode( selector?:string, root?:HTMLElement ): HTMLElement;
		/** [Method] Selects the value of a node parsing integers and floats  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param defaultValue Number When specified, this is return as empty value. 
		* @returns Number 
		*/
		static selectNumber( selector?:string, root?:HTMLElement, defaultValue?:number ): number;
		/** [Method] Selects the value of a node optionally replacing null with the defaultValue  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param defaultValue String When specified, this is return as empty value. 
		* @returns String 
		*/
		static selectValue( selector?:string, root?:HTMLElement, defaultValue?:string ): string;
	}
}
declare module Ext.core {
	export interface IDomQuery {
	}
	export class DomQuery {
		/** [Property] (Object) */
		static matchers: any;
		/** [Property] (Object) */
		static operators: any;
		/** [Property] (Object) */
		static pseudos: any;
		/** [Method] Compiles a selector xpath query into a reusable function  
		* @param selector String The selector/xpath query 
		* @param type String Either "select" or "simple" for a simple selector match 
		* @returns Function 
		*/
		static compile( selector?:string, type?:string ): any;
		/** [Method] Filters an array of elements to only include matches of a simple selector e g  
		* @param el HTMLElement[] An array of elements to filter 
		* @param selector String The simple selector to test 
		* @param nonMatches Boolean If true, it returns the elements that DON'T match the selector instead of the ones that match 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		static filter( el?:HTMLElement[], selector?:string, nonMatches?:boolean ): HTMLElement[];
		/** [Method] Returns true if the passed element s match the passed simple selector e g  
		* @param el String/HTMLElement/HTMLElement[] An element id, element or array of elements 
		* @param selector String The simple selector to test 
		* @returns Boolean 
		*/
		static is( el?:any, selector?:string ): boolean;
		/** [Method] Selects an array of DOM nodes using JavaScript only implementation  
		* @param selector String The selector/xpath query (can be a comma separated list of selectors) 
		* @param root HTMLElement/String The start of the query. 
		* @returns HTMLElement[] An Array of DOM elements which match the selector. If there are no matches, and empty Array is returned. 
		*/
		static jsSelect( selector?:string, root?:any ): HTMLElement[];
		/** [Method] Selects an array of DOM nodes by CSS XPath selector  
		* @param path String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param type String Either "select" or "simple" for a simple selector match (only valid when used when the call is deferred to the jsSelect method) 
		* @param single Boolean Pass true to select only the first matching node using document.querySelector (where available) 
		* @returns HTMLElement[] An array of DOM elements (not a NodeList as returned by querySelectorAll). 
		*/
		static select( path?:string, root?:HTMLElement, type?:string, single?:boolean ): HTMLElement[];
		/** [Method] Selects a single element  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @returns HTMLElement The DOM element which matched the selector. 
		*/
		static selectNode( selector?:string, root?:HTMLElement ): HTMLElement;
		/** [Method] Selects the value of a node parsing integers and floats  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param defaultValue Number When specified, this is return as empty value. 
		* @returns Number 
		*/
		static selectNumber( selector?:string, root?:HTMLElement, defaultValue?:number ): number;
		/** [Method] Selects the value of a node optionally replacing null with the defaultValue  
		* @param selector String The selector/xpath query 
		* @param root HTMLElement The start of the query. 
		* @param defaultValue String When specified, this is return as empty value. 
		* @returns String 
		*/
		static selectValue( selector?:string, root?:HTMLElement, defaultValue?:string ): string;
	}
}
declare module Ext {
	export interface IDomHelper extends Ext.dom.IHelper {
	}
	export class DomHelper {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static useDom: boolean;
		/** [Method] Creates new DOM element s and appends them to el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static append( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Applies a style specification to an element  
		* @param el String/HTMLElement The element to apply styles to 
		* @param styles String/Object/Function A style specification string e.g. 'width:100px', or object in the form {width:'100px'}, or a function which returns such a specification. 
		*/
		static applyStyles( el?:any, styles?:any ): void;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates new DOM element s without inserting them to the document  
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @returns HTMLElement The new uninserted node 
		*/
		static createDom( o?:any ): HTMLElement;
		/** [Method] Alias for markup  
		* @param spec Object The DOM object spec (and children) 
		* @returns String 
		*/
		static createHtml( spec?:any ): string;
		/** [Method] Creates a new Ext Template from the DOM object spec  
		* @param o Object The DOM object spec (and children) 
		* @returns Ext.Template The new template 
		*/
		static createTemplate( o?:any ): Ext.ITemplate;
		/** [Method] Converts the styles from the given object to text  
		* @param styles Object The object describing the styles. 
		* @param buffer String[] The output buffer. 
		* @returns String/String[] If buffer is passed, it is returned. Otherwise the style string is returned. 
		*/
		static generateStyles( styles?:any, buffer?:string[] ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Creates new DOM element s and inserts them after el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object The DOM object spec (and children) 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static insertAfter( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Creates new DOM element s and inserts them before el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static insertBefore( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Creates new DOM element s and inserts them as the first child of el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static insertFirst( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Inserts an HTML fragment into the DOM  
		* @param where String Where to insert the html in relation to el - beforeBegin, afterBegin, beforeEnd, afterEnd. For example take the following HTML: &lt;div&gt;Contents&lt;/div&gt; Using different where values inserts element to the following places:  beforeBegin: &lt;HERE&gt;&lt;div&gt;Contents&lt;/div&gt; afterBegin: &lt;div&gt;&lt;HERE&gt;Contents&lt;/div&gt; beforeEnd: &lt;div&gt;Contents&lt;HERE&gt;&lt;/div&gt; afterEnd: &lt;div&gt;Contents&lt;/div&gt;&lt;HERE&gt;  
		* @param el HTMLElement/TextNode The context element 
		* @param html String The HTML fragment 
		* @returns HTMLElement The new node 
		*/
		static insertHtml( where?:string, el?:any, html?:string ): HTMLElement;
		/** [Method] Returns the markup for the passed Element s config  
		* @param spec Object The DOM object spec (and children) 
		* @returns String 
		*/
		static markup( spec?:any ): string;
		/** [Method] Creates new DOM element s and overwrites the contents of el with them  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return an Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static overwrite( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.core {
	export interface IDomHelper extends Ext.dom.IHelper {
	}
	export class DomHelper {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static useDom: boolean;
		/** [Method] Creates new DOM element s and appends them to el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static append( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Applies a style specification to an element  
		* @param el String/HTMLElement The element to apply styles to 
		* @param styles String/Object/Function A style specification string e.g. 'width:100px', or object in the form {width:'100px'}, or a function which returns such a specification. 
		*/
		static applyStyles( el?:any, styles?:any ): void;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates new DOM element s without inserting them to the document  
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @returns HTMLElement The new uninserted node 
		*/
		static createDom( o?:any ): HTMLElement;
		/** [Method] Alias for markup  
		* @param spec Object The DOM object spec (and children) 
		* @returns String 
		*/
		static createHtml( spec?:any ): string;
		/** [Method] Creates a new Ext Template from the DOM object spec  
		* @param o Object The DOM object spec (and children) 
		* @returns Ext.Template The new template 
		*/
		static createTemplate( o?:any ): Ext.ITemplate;
		/** [Method] Converts the styles from the given object to text  
		* @param styles Object The object describing the styles. 
		* @param buffer String[] The output buffer. 
		* @returns String/String[] If buffer is passed, it is returned. Otherwise the style string is returned. 
		*/
		static generateStyles( styles?:any, buffer?:string[] ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Creates new DOM element s and inserts them after el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object The DOM object spec (and children) 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static insertAfter( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Creates new DOM element s and inserts them before el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static insertBefore( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Creates new DOM element s and inserts them as the first child of el  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return a Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static insertFirst( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Inserts an HTML fragment into the DOM  
		* @param where String Where to insert the html in relation to el - beforeBegin, afterBegin, beforeEnd, afterEnd. For example take the following HTML: &lt;div&gt;Contents&lt;/div&gt; Using different where values inserts element to the following places:  beforeBegin: &lt;HERE&gt;&lt;div&gt;Contents&lt;/div&gt; afterBegin: &lt;div&gt;&lt;HERE&gt;Contents&lt;/div&gt; beforeEnd: &lt;div&gt;Contents&lt;HERE&gt;&lt;/div&gt; afterEnd: &lt;div&gt;Contents&lt;/div&gt;&lt;HERE&gt;  
		* @param el HTMLElement/TextNode The context element 
		* @param html String The HTML fragment 
		* @returns HTMLElement The new node 
		*/
		static insertHtml( where?:string, el?:any, html?:string ): HTMLElement;
		/** [Method] Returns the markup for the passed Element s config  
		* @param spec Object The DOM object spec (and children) 
		* @returns String 
		*/
		static markup( spec?:any ): string;
		/** [Method] Creates new DOM element s and overwrites the contents of el with them  
		* @param el String/HTMLElement/Ext.Element The context element 
		* @param o Object/String The DOM object spec (and children) or raw HTML blob 
		* @param returnElement Boolean true to return an Ext.Element 
		* @returns HTMLElement/Ext.Element The new node 
		*/
		static overwrite( el?:any, o?:any, returnElement?:boolean ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.draw {
	export interface IColor extends Ext.IBase {
		/** [Config Option] (Number) */
		lightnessFactor?: number;
		/** [Method] Get the blue component of the color in the range 0 255  
		* @returns Number 
		*/
		getBlue?(): number;
		/** [Method] Return a new color that is darker than this color  
		* @param factor Number Darker factor (0..1), default to 0.2 
		* @returns Object Ext.draw.Color 
		*/
		getDarker?( factor?:number ): any;
		/** [Method] Returns the gray value 0 to 255 of the color  
		* @returns Number 
		*/
		getGrayscale?(): number;
		/** [Method] Get the green component of the color in the range 0 255  
		* @returns Number 
		*/
		getGreen?(): number;
		/** [Method] Get the equivalent HSL components of the color  
		* @returns Number[] 
		*/
		getHSL?(): number[];
		/** [Method] Return a new color that is lighter than this color  
		* @param factor Number Lighter factor (0..1), default to 0.2 
		* @returns Object Ext.draw.Color 
		*/
		getLighter?( factor?:number ): any;
		/** [Method] Get the RGB values  
		* @returns Number[] 
		*/
		getRGB?(): number[];
		/** [Method] Get the red component of the color in the range 0 255  
		* @returns Number 
		*/
		getRed?(): number;
		/** [Method] Return the color in the hex format i e  
		* @returns String 
		*/
		toString?(): string;
	}
	export class Color {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Create a new color based on the specified HSL values  
		* @param h Number Hue component (0..359) 
		* @param s Number Saturation component (0..1) 
		* @param l Number Lightness component (0..1) 
		* @returns Object Ext.draw.Color 
		*/
		static fromHSL( h?:number, s?:number, l?:number ): any;
		/** [Method] Parse the string and create a new color  
		* @param str String Color in string. 
		* @returns Object Ext.draw.Color 
		*/
		static fromString( str?:string ): any;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Adds members to class  */
		static implement(): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
		/** [Method] Convert a color to hexadecimal format  
		* @param color String/String[] The color value (i.e 'rgb(255, 255, 255)', 'color: #ffffff'). Can also be an Array, in this case the function handles the first member. 
		* @returns String The color in hexadecimal format. 
		*/
		static toHex( color?:any ): string;
	}
}
declare module Ext.draw {
	export interface IComponent extends Ext.IComponent {
		/** [Config Option] (Boolean) */
		autoSize?: boolean;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String/Object) */
		componentLayout?: any;
		/** [Config Option] (String[]) */
		enginePriority?: string[];
		/** [Config Option] (Object[]) */
		gradients?: any[];
		/** [Config Option] (Ext.draw.Sprite[]) */
		items?: Ext.draw.ISprite[];
		/** [Config Option] (Boolean/Number) */
		shrinkWrap?: any;
		/** [Config Option] (Boolean) */
		viewBox?: boolean;
		/** [Property] (Ext.draw.Surface) */
		surface?: Ext.draw.ISurface;
	}
}
declare module Ext.draw {
	export interface ICompositeSprite extends Ext.util.IMixedCollection,Ext.util.IAnimate {
		/** [Method] Inherit docs from MixedCollection 
		* @param key Object 
		* @param o Object 
		* @returns Object The item added. 
		*/
		add?( key?:any, o?:any ): any;
		/** [Method] Adds class to all sprites  
		* @param cls String CSS class name 
		*/
		addCls?( cls?:string ): void;
		/** [Method] Performs custom animation on this object  
		* @param config Object Configuration for Ext.fx.Anim. Note that the to config is required. 
		* @returns Object this 
		*/
		animate?( config?:any ): any;
		/** [Method] Destroys this CompositeSprite  */
		destroy?(): void;
		/** [Method] Returns the current animation if this object has any effects actively running or queued else returns false  
		* @returns Ext.fx.Anim/Boolean Anim if element has active effects, else false 
		*/
		getActiveAnimation?(): any;
		/** [Method] Returns the group bounding box  
		* @returns Object an object with x, y, width, and height properties. 
		*/
		getBBox?(): any;
		/** [Method] Returns the current animation if this object has any effects actively running or queued else returns false  
		* @returns Ext.fx.Anim/Boolean Anim if element has active effects, else false 
		*/
		hasActiveFx?(): any;
		/** [Method] Hides all sprites  
		* @param redraw Boolean Flag to immediately draw the change. 
		* @returns Ext.draw.CompositeSprite this 
		*/
		hide?( redraw?:boolean ): Ext.draw.ICompositeSprite;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Object 
		* @param key Object 
		* @param o Object 
		* @returns Object The item inserted or an array of items inserted. 
		*/
		insert?( index?:any, key?:any, o?:any ): any;
		/** [Method] Force redraw of all sprites  */
		redraw?(): void;
		/** [Method] Inherit docs from MixedCollection 
		* @param o Object 
		* @returns Object The item removed or false if no item was removed. 
		*/
		remove?( o?:any ): any;
		/** [Method] Removes class from all sprites  
		* @param cls String CSS class name 
		*/
		removeCls?( cls?:string ): void;
		/** [Method] Ensures that all effects queued after sequenceFx is called on this object are run in sequence  
		* @returns Object this 
		*/
		sequenceFx?(): any;
		/** [Method] Iterates through all sprites calling setAttributes on each one  
		* @param attrs Object Attributes to be changed on the sprite. 
		* @param redraw Boolean Flag to immediately draw the change. 
		* @returns Ext.draw.CompositeSprite this 
		*/
		setAttributes?( attrs?:any, redraw?:boolean ): Ext.draw.ICompositeSprite;
		/** [Method] Sets style for all sprites  
		* @param style String CSS Style definition. 
		*/
		setStyle?( style?:string ): void;
		/** [Method] Shows all sprites  
		* @param redraw Boolean Flag to immediately draw the change. 
		* @returns Ext.draw.CompositeSprite this 
		*/
		show?( redraw?:boolean ): Ext.draw.ICompositeSprite;
		/** [Method] Stops any running effects and clears this object s internal effects queue if it contains any additional effects that 
		* @returns Ext.Element The Element 
		*/
		stopAnimation?(): Ext.IElement;
		/** [Method] Stops any running effects and clears this object s internal effects queue if it contains any additional effects that 
		* @returns Ext.Element The Element 
		*/
		stopFx?(): Ext.IElement;
		/** [Method] Ensures that all effects queued after syncFx is called on this object are run concurrently  
		* @returns Object this 
		*/
		syncFx?(): any;
	}
}
declare module Ext.draw {
	export interface IDraw extends Ext.IBase {
	}
	export class Draw {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] snapEndsByDate is a utility method to deduce an appropriate tick configuration for the data set of given feature  
		* @param from Date The minimum value in the data 
		* @param to Date The maximum value in the data 
		* @param stepsMax Number The maximum number of ticks 
		* @param lockEnds Boolean If true, the 'from' and 'to' parameters will be used as fixed end values and will not be adjusted 
		* @returns Object The calculated step and ends info; properties are: - from: The result start value, which may be lower than the original start value - to: The result end value, which may be higher than the original end value - step: The fixed value size of each step, or undefined if the steps are not fixed. - steps: The number of steps if the steps are fixed, or an array of step values. NOTE: Even when the steps have a fixed value, they may not divide the from/to range perfectly evenly; there may be a smaller distance between the last step and the end value than between prior steps, particularly when the endsLocked param is true. Therefore it is best to not use the steps result when finding the axis tick points, instead use the step, to, and from to find the correct point for each tick. 
		*/
		static snapEndsByDate( from?:any, to?:any, stepsMax?:number, lockEnds?:boolean ): any;
		/** [Method] snapEndsByDateAndStep is a utility method to deduce an appropriate tick configuration for the data set of given featu  
		* @param from Date The minimum value in the data 
		* @param to Date The maximum value in the data 
		* @param step Array An array with two components: The first is the unit of the step (day, month, year, etc). The second is the number of units for the step (1, 2, etc.). If the number is an integer, it represents the number of units for the step ([Ext.Date.DAY, 2] means "Every other day"). If the number is a fraction, it represents the number of steps per unit ([Ext.Date.DAY, 1/2] means "Twice a day"). If the unit is the month, the steps may be adjusted depending on the month. For instance [Ext.Date.MONTH, 1/3], which means "Three times a month", generates steps on the 1st, the 10th and the 20th of every month regardless of whether a month has 28 days or 31 days. The steps are generated as follows: - [Ext.Date.MONTH, n]: on the current date every 'n' months, maxed to the number of days in the month. - [Ext.Date.MONTH, 1/2]: on the 1st and 15th of every month. - [Ext.Date.MONTH, 1/3]: on the 1st, 10th and 20th of every month. - [Ext.Date.MONTH, 1/4]: on the 1st, 8th, 15th and 22nd of every month. 
		* @param lockEnds Boolean If true, the 'from' and 'to' parameters will be used as fixed end values  and will not be adjusted 
		* @returns Object The calculated step and ends info; properties are: - from: The result start value, which may be lower than the original start value - to: The result end value, which may be higher than the original end value - step: The fixed value size of each step, or undefined if the steps are not fixed. - steps: The number of steps if the steps are fixed, or an array of step values. NOTE: Even when the steps have a fixed value, they may not divide the from/to range perfectly evenly; there may be a smaller distance between the last step and the end value than between prior steps, particularly when the endsLocked param is true. Therefore it is best to not use the steps result when finding the axis tick points, instead use the step, to, and from to find the correct point for each tick. 
		*/
		static snapEndsByDateAndStep( from?:any, to?:any, step?:any[], lockEnds?:boolean ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.draw.engine {
	export interface IImageExporter extends Ext.IBase {
	}
	export class ImageExporter {
		/** [Property] (String) */
		static defaultUrl: string;
		/** [Property] (String) */
		static heightParam: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Array) */
		static supportedTypes: any[];
		/** [Property] (String) */
		static svgParam: string;
		/** [Property] (String) */
		static typeParam: string;
		/** [Property] (String) */
		static widthParam: string;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Exports the surface to an image 
		* @param surface Ext.draw.Surface The surface to export 
		* @param config Object The following config options are supported: 
		* @returns Boolean True if the surface was successfully sent to the server. 
		*/
		static generate( surface?:Ext.draw.ISurface, config?:any ): boolean;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.draw.engine {
	export interface ISvg extends Ext.draw.ISurface {
		/** [Method] Adds one or more CSS classes to the element  
		* @param sprite Object 
		* @param className Object 
		*/
		addCls?( sprite?:any, className?:any ): void;
		/** [Method] Adds a gradient definition to the Surface  
		* @param gradient Object 
		*/
		addGradient?( gradient?:any ): void;
		/** [Method] Insert or move a given sprite s element to the correct place in the DOM list for its zIndex 
		* @param sprite Ext.draw.Sprite 
		*/
		applyZIndex?( sprite?:Ext.draw.ISprite ): void;
		/** [Method] Destroys the surface  */
		destroy?(): void;
		/** [Method] Get the region for the surface s canvas area 
		* @returns Ext.util.Region 
		*/
		getRegion?(): Ext.util.IRegion;
		/** [Method] Checks if the specified CSS class exists on this element s DOM node  
		* @param sprite Ext.draw.Sprite The sprite to look into. 
		* @param className String The CSS class to check for 
		* @returns Boolean True if the class exists, else false 
		*/
		hasCls?( sprite?:Ext.draw.ISprite, className?:string ): boolean;
		/** [Method] Removes one or more CSS classes from the element  
		* @param sprite Object 
		* @param className Object 
		*/
		removeCls?( sprite?:any, className?:any ): void;
		/** [Method] Sets the size of the surface  
		* @param width Object 
		* @param height Object 
		*/
		setSize?( width?:any, height?:any ): void;
		/** [Method] Changes the text in the sprite element  
		* @param sprite Object 
		* @param textString Object 
		*/
		setText?( sprite?:any, textString?:any ): void;
	}
}
declare module Ext.draw.engine {
	export interface ISvgExporter extends Ext.IBase {
	}
	export class SvgExporter {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override Ext define My Cat  constructor functi  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Exports the passed surface to a SVG string representation 
		* @param surface Ext.draw.Surface The surface to export 
		* @param config Object Any configuration for the export. Currently this is unused but may provide more options in the future 
		* @returns String The SVG as a string 
		*/
		static generate( surface?:Ext.draw.ISurface, config?:any ): string;
		/** [Method] Returns the initial configuration passed to constructor when instantiating this class  
		* @param name String Name of the config option to return. 
		* @returns Object/Mixed The full config object or a single config value when name parameter specified. 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param config Object 
		* @returns Ext.Base this 
		*/
		static initConfig( config?:any ): Ext.IBase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.draw.engine {
	export interface IVml extends Ext.draw.ISurface {
		/** [Method] Adds one or more CSS classes to the element  
		* @param sprite Object 
		* @param className Object 
		*/
		addCls?( sprite?:any, className?:any ): void;
		/** [Method] Adds a definition to this Surface for a linear gradient  
		* @param gradient Object 
		*/
		addGradient?( gradient?:any ): void;
		/** [Method] Destroys the surface  */
		destroy?(): void;
		/** [Method] Removes one or more CSS classes from the element  
		* @param sprite Object 
		* @param className Object 
		*/
		removeCls?( sprite?:any, className?:any ): void;
		/** [Method] Sets the size of the surface  
		* @param width Object 
		* @param height Object 
		*/
		setSize?( width?:any, height?:any ): void;
		/** [Method] Changes the text in the sprite element  
		* @param sprite Object 
		* @param text Object 
		*/
		setText?( sprite?:any, text?:any ): void;
	}
}
declare module Ext.draw {
	export interface IMatrix extends Ext.IBase {
	}
}
declare module Ext.draw {
	export interface ISprite extends Ext.IBase,Ext.util.IObservable,Ext.util.IAnimate {
		/** [Config Option] (Boolean) */
		draggable?: boolean;
		/** [Config Option] (String) */
		fill?: string;
		/** [Config Option] (String) */
		font?: string;
		/** [Config Option] (String/String[]) */
		group?: any;
		/** [Config Option] (Number) */
		height?: number;
		/** [Config Option] (Number) */
		opacity?: number;
		/** [Config Option] (String) */
		path?: string;
		/** [Config Option] (Number) */
		radius?: number;
		/** [Config Option] (Number) */
		radiusX?: number;
		/** [Config Option] (Number) */
		radiusY?: number;
		/** [Config Option] (String) */
		src?: string;
		/** [Config Option] (String) */
		stroke?: string;
		/** [Config Option] (Number) */
		strokewidth?: number;
		/** [Config Option] (String) */
		text?: string;
		/** [Config Option] (String) */
		type?: string;
		/** [Config Option] (Number) */
		width?: number;
		/** [Config Option] (Number) */
		x?: number;
		/** [Config Option] (Number) */
		y?: number;
		/** [Property] (Ext.dd.DragSource) */
		dd?: Ext.dd.IDragSource;
		/** [Property] (Boolean) */
		isSprite?: boolean;
		/** [Method] Adds one or more CSS classes to the element  
		* @param className String/String[] The CSS class to add, or an array of classes 
		* @returns Ext.draw.Sprite this 
		*/
		addCls?( className?:any ): Ext.draw.ISprite;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true. For example: this.addEvents({  storeloaded: true,  storecleared: true });  Or any number of event names as separate parameters. For example: this.addEvents('storeloaded', 'storecleared'); 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Adds listeners to any Observable object or Ext Element which are automatically removed when this Component is destr  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		addManagedListener?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Performs custom animation on this object  
		* @param config Object Configuration for Ext.fx.Anim. Note that the to config is required. 
		* @returns Object this 
		*/
		animate?( config?:any ): any;
		/** [Method] Removes all listeners for this object including the managed listeners */
		clearListeners?(): void;
		/** [Method] Removes all managed listeners for this object  */
		clearManagedListeners?(): void;
		/** [Method] Removes the sprite and clears all listeners  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param eventNames String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( eventNames?:any ): void;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Fires the specified event with the passed parameter list  
		* @param eventName String The name of the event to fire. 
		* @param args Object[] An array of parameters which are passed to handlers. 
		* @returns Boolean returns false if any of the handlers return false otherwise it returns true. 
		*/
		fireEventArgs?( eventName?:string, args?:any[] ): boolean;
		/** [Method] Returns the current animation if this object has any effects actively running or queued else returns false  
		* @returns Ext.fx.Anim/Boolean Anim if element has active effects, else false 
		*/
		getActiveAnimation?(): any;
		/** [Method] Retrieves the bounding box of the sprite  
		* @returns Object bbox 
		*/
		getBBox?(): any;
		/** [Method] Returns the current animation if this object has any effects actively running or queued else returns false  
		* @returns Ext.fx.Anim/Boolean Anim if element has active effects, else false 
		*/
		hasActiveFx?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event or whether the event bubbles  
		* @param eventName String The name of the event to check for 
		* @returns Boolean true if the event is being listened for or bubbles, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Hides the sprite  
		* @param redraw Boolean Flag to immediately draw the change. 
		* @returns Ext.draw.Sprite this 
		*/
		hide?( redraw?:boolean ): Ext.draw.ISprite;
		/** [Method] Shorthand for addManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item to which to add a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		* @param options Object If the ename parameter was an event name, this is the addListener options. 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.mon({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		mon?( item?:any, ename?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Shorthand for removeManagedListener  
		* @param item Ext.util.Observable/Ext.Element The item from which to remove a listener/listeners. 
		* @param ename Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the ename parameter was an event name, this is the handler function. 
		* @param scope Object If the ename parameter was an event name, this is the scope (this reference) in which the handler function is executed. 
		*/
		mun?( item?:any, ename?:any, fn?:any, scope?:any ): void;
		/** [Method] Shorthand for addListener  
		* @param eventName String/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function The method the event invokes, or if scope is specified, the name* of the method within the specified scope. Will be called with arguments given to Ext.util.Observable.fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  Note: Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.  This object may contain any of the following properties: 
		* @returns Object Only when the destroyable option is specified.  A Destroyable object. An object which implements the destroy method which removes all listeners added in this call. For example:  this.btnListeners = = myButton.on({  destroyable: true  mouseover:  function() { console.log('mouseover'); },  mouseout: function() { console.log('mouseout'); },  click:  function() { console.log('click'); } }); And when those listeners need to be removed:  Ext.destroy(this.btnListeners); or  this.btnListeners.destroy();  
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any ): any;
		/** [Method] Redraws the sprite  
		* @returns Ext.draw.Sprite this 
		*/
		redraw?(): Ext.draw.ISprite;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param origin Object The Observable whose events this object is to relay. 
		* @param events String[] Array of event names to relay. 
		* @param prefix String A common prefix to prepend to the event names. For example: this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Now the grid will forward 'load' and 'clear' events of store as 'storeload' and 'storeclear'. 
		* @returns Object A Destroyable object. An object which implements the destroy method which, when destroyed, removes all relayers. For example: this.storeRelayers = this.relayEvents(this.getStore(), ['load', 'clear'], 'store');  Can be undone by calling Ext.destroy(this.storeRelayers);  or this.store.relayers.destroy(); 
		*/
		relayEvents?( origin?:any, events?:string[], prefix?:string ): any;
		/** [Method] Removes the sprite  
		* @returns Boolean True if sprite was successfully removed. False when there was no surface to remove it from. 
		*/
		remove?(): boolean;
		/** [Method] Removes one or more CSS classes from the element  
		* @param className String/String[] The CSS class to remove, or an array of classes. Note this method is severly limited in VML. 
		* @returns Ext.draw.Sprite this 
		*/
		removeCls?( clas