/// <reference path="./fhir.d.ts" />

var example1: fhir.AllergyIntolerance = {
    "category": "food",
    "criticality": "high",
    "event": [
        {
            "description": "Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered",
            "manifestation": [
                {
                    "coding": [
                        {
                            "code": "39579001",
                            "display": "Anaphylactic reaction",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                }
            ],
            "onset": "2012-06-12",
            "severity": "severe",
            "substance": {
                "coding": [
                    {
                        "code": "C3214954",
                        "display": "cashew nut allergenic extract Injectable Product",
                        "system": "http://www.nlm.nih.gov/research/umls/rxnorm"
                    }
                ]
            }
        },
        {
            "certainty": "likely",
            "manifestation": [
                {
                    "coding": [
                        {
                            "code": "64305001",
                            "display": "Urticaria",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                }
            ],
            "onset": "2004",
            "severity": "moderate"
        }
    ],
    "id": "example",
    "identifier": [
        {
            "system": "http://acme.com/ids/patients/risks",
            "value": "49476534"
        }
    ],
    "lastOccurence": "2012-06",
    "patient": {
        "reference": "Patient/example"
    },
    "recordedDate": "2014-10-09T14:58:00+11:00",
    "recorder": {
        "reference": "Practitioner/example"
    },
    "resourceType": "AllergyIntolerance",
    "status": "confirmed",
    "substance": {
        "coding": [
            {
                "code": "227493005",
                "display": "Cashew nuts",
                "system": "http://snomed.info/sct"
            }
        ]
    },
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>identifier</b>: 49476534\n      </p>\n      <p>\n        <b>recordedDate</b>: Oct 9, 2014 2:58:00 PM\n      </p>\n      <p>\n        <b>recorder</b>: \n        <a href=\"Practitioner/example\">Generated Summary: 23; Adam Careful </a>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>substance</b>: Cashew nuts \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '227493005' = 'Cashew nut (substance)', given as 'Cashew nuts'})</span>\n      </p>\n      <p>\n        <b>status</b>: CONFIRMED\n      </p>\n      <p>\n        <b>criticality</b>: HIGH\n      </p>\n      <p>\n        <b>type</b>: IMMUNE\n      </p>\n      <p>\n        <b>category</b>: FOOD\n      </p>\n      <p>\n        <b>lastOccurence</b>: Jun 1, 2012\n      </p>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>substance</b>: cashew nut allergenic extract Injectable Product \n          <span style=\"background: LightGoldenRodYellow \">(Details : {RxNorm code 'C3214954' = 'C3214954', given as 'cashew nut allergenic extract Injectable Product'})</span>\n        </p>\n        <p>\n          <b>manifestation</b>: Anaphylactic reaction \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '39579001' = 'Anaphylactic reaction', given as 'Anaphylactic reaction'})</span>\n        </p>\n        <p>\n          <b>description</b>: Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered\n        </p>\n        <p>\n          <b>onset</b>: Jun 12, 2012\n        </p>\n        <p>\n          <b>severity</b>: SEVERE\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>certainty</b>: LIKELY\n        </p>\n        <p>\n          <b>manifestation</b>: Urticaria \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '64305001' = 'Hive', given as 'Urticaria'})</span>\n        </p>\n        <p>\n          <b>onset</b>: Jan 1, 2004\n        </p>\n        <p>\n          <b>severity</b>: MODERATE\n        </p>\n      </blockquote>\n    </div>",
        "status": "generated"
    },
    "type": "immune"
};

var example2: fhir.AllergyIntolerance = {
    "resourceType": "AllergyIntolerance",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>identifier</b>: 49476534\n      </p>\n      <p>\n        <b>recordedDate</b>: Oct 9, 2014 2:58:00 PM\n      </p>\n      <p>\n        <b>recorder</b>: \n        <a href=\"Practitioner/example\">Generated Summary: 23; Adam Careful </a>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>substance</b>: Cashew nuts \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '227493005' = 'Cashew nut (substance)', given as 'Cashew nuts'})</span>\n      </p>\n      <p>\n        <b>status</b>: CONFIRMED\n      </p>\n      <p>\n        <b>criticality</b>: HIGH\n      </p>\n      <p>\n        <b>type</b>: IMMUNE\n      </p>\n      <p>\n        <b>category</b>: FOOD\n      </p>\n      <p>\n        <b>lastOccurence</b>: Jun 1, 2012\n      </p>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>substance</b>: cashew nut allergenic extract Injectable Product \n          <span style=\"background: LightGoldenRodYellow \">(Details : {RxNorm code 'C3214954' = 'C3214954', given as 'cashew nut allergenic extract Injectable Product'})</span>\n        </p>\n        <p>\n          <b>manifestation</b>: Anaphylactic reaction \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '39579001' = 'Anaphylactic reaction', given as 'Anaphylactic reaction'})</span>\n        </p>\n        <p>\n          <b>description</b>: Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered\n        </p>\n        <p>\n          <b>onset</b>: Jun 12, 2012\n        </p>\n        <p>\n          <b>severity</b>: SEVERE\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>certainty</b>: LIKELY\n        </p>\n        <p>\n          <b>manifestation</b>: Urticaria \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '64305001' = 'Hive', given as 'Urticaria'})</span>\n        </p>\n        <p>\n          <b>onset</b>: Jan 1, 2004\n        </p>\n        <p>\n          <b>severity</b>: MODERATE\n        </p>\n      </blockquote>\n    </div>"
    },
    "identifier": [
        {
            "system": "http://acme.com/ids/patients/risks",
            "value": "49476534"
        }
    ],
    "recordedDate": "2014-10-09T14:58:00+11:00",
    "recorder": {
        "reference": "Practitioner/example"
    },
    "patient": {
        "reference": "Patient/example"
    },
    "substance": {
        "coding": [
            {
                "system": "http://snomed.info/sct",
                "code": "227493005",
                "display": "Cashew nuts"
            }
        ]
    },
    "status": "confirmed",
    "criticality": "high",
    "type": "immune",
    "category": "food",
    "lastOccurence": "2012-06",
    "event": [
        {
            "substance": {
                "coding": [
                    {
                        "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                        "code": "C3214954",
                        "display": "cashew nut allergenic extract Injectable Product"
                    }
                ]
            },
            "manifestation": [
                {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "39579001",
                            "display": "Anaphylactic reaction"
                        }
                    ]
                }
            ],
            "description": "Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered",
            "onset": "2012-06-12",
            "severity": "severe"
        },
        {
            "certainty": "likely",
            "manifestation": [
                {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "64305001",
                            "display": "Urticaria"
                        }
                    ]
                }
            ],
            "onset": "2004",
            "severity": "moderate"
        }
    ]
};

var example3: fhir.AllergyIntolerance = {
    "category": "food",
    "criticality": "high",
    "event": [
        {
            "certainty": "confirmed",
            "description": "Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered",
            "manifestation": [
                {
                    "coding": [
                        {
                            "code": "39579001",
                            "display": "Anaphylactic reaction",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                }
            ],
            "onset": "2012-06-12",
            "severity": "severe",
            "substance": {
                "coding": [
                    {
                        "code": "C3214954",
                        "display": "cashew nut allergenic extract Injectable Product",
                        "system": "http://www.nlm.nih.gov/research/umls/rxnorm"
                    }
                ]
            }
        },
        {
            "certainty": "likely",
            "manifestation": [
                {
                    "coding": [
                        {
                            "code": "64305001",
                            "display": "Urticaria",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                }
            ],
            "onset": "2004",
            "severity": "moderate"
        }
    ],
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/allergyintolerance-reasonRefuted",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "code": "MED",
                        "display": "Medical Status Altered",
                        "system": "http://hl7.org/fhir/v3/ActReason"
                    }
                ]
            }
        }
    ],
    "id": "qicore",
    "identifier": [
        {
            "system": "http://acme.com/ids/patients/risks",
            "value": "49476534"
        }
    ],
    "lastOccurence": "2012-06",
    "patient": {
        "reference": "Patient/example"
    },
    "recordedDate": "2014-10-09T14:58:00+11:00",
    "recorder": {
        "reference": "Practitioner/example"
    },
    "resourceType": "AllergyIntolerance",
    "status": "confirmed",
    "substance": {
        "coding": [
            {
                "code": "227493005",
                "display": "Cashew nuts",
                "system": "http://snomed.info/sct"
            }
        ]
    },
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>identifier</b>: 49476534\n      </p>\n      <p>\n        <b>recordedDate</b>: Oct 9, 2014 2:58:00 PM\n      </p>\n      <p>\n        <b>recorder</b>: \n        <a href=\"Practitioner/example\">Generated Summary: 23; Adam Careful </a>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>substance</b>: Cashew nuts \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '227493005' = 'Cashew nut (substance)', given as 'Cashew nuts'})</span>\n      </p>\n      <p>\n        <b>status</b>: CONFIRMED\n      </p>\n      <p>\n        <b>criticality</b>: HIGH\n      </p>\n      <p>\n        <b>type</b>: IMMUNE\n      </p>\n      <p>\n        <b>category</b>: FOOD\n      </p>\n      <p>\n        <b>lastOccurence</b>: Jun 1, 2012\n      </p>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>substance</b>: cashew nut allergenic extract Injectable Product \n          <span style=\"background: LightGoldenRodYellow \">(Details : {RxNorm code 'C3214954' = 'C3214954', given as 'cashew nut allergenic extract Injectable Product'})</span>\n        </p>\n        <p>\n          <b>certainty</b>: CONFIRMED\n        </p>\n        <p>\n          <b>manifestation</b>: Anaphylactic reaction \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '39579001' = 'Anaphylactic reaction', given as 'Anaphylactic reaction'})</span>\n        </p>\n        <p>\n          <b>description</b>: Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered\n        </p>\n        <p>\n          <b>onset</b>: Jun 12, 2012\n        </p>\n        <p>\n          <b>severity</b>: SEVERE\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>certainty</b>: LIKELY\n        </p>\n        <p>\n          <b>manifestation</b>: Urticaria \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '64305001' = 'Hive', given as 'Urticaria'})</span>\n        </p>\n        <p>\n          <b>onset</b>: Jan 1, 2004\n        </p>\n        <p>\n          <b>severity</b>: MODERATE\n        </p>\n      </blockquote>\n    </div>",
        "status": "generated"
    },
    "type": "immune"
};

var example4: fhir.AllergyIntolerance = {
    "resourceType": "AllergyIntolerance",
    "id": "qicore",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>identifier</b>: 49476534\n      </p>\n      <p>\n        <b>recordedDate</b>: Oct 9, 2014 2:58:00 PM\n      </p>\n      <p>\n        <b>recorder</b>: \n        <a href=\"Practitioner/example\">Generated Summary: 23; Adam Careful </a>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>substance</b>: Cashew nuts \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '227493005' = 'Cashew nut (substance)', given as 'Cashew nuts'})</span>\n      </p>\n      <p>\n        <b>status</b>: CONFIRMED\n      </p>\n      <p>\n        <b>criticality</b>: HIGH\n      </p>\n      <p>\n        <b>type</b>: IMMUNE\n      </p>\n      <p>\n        <b>category</b>: FOOD\n      </p>\n      <p>\n        <b>lastOccurence</b>: Jun 1, 2012\n      </p>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>substance</b>: cashew nut allergenic extract Injectable Product \n          <span style=\"background: LightGoldenRodYellow \">(Details : {RxNorm code 'C3214954' = 'C3214954', given as 'cashew nut allergenic extract Injectable Product'})</span>\n        </p>\n        <p>\n          <b>certainty</b>: CONFIRMED\n        </p>\n        <p>\n          <b>manifestation</b>: Anaphylactic reaction \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '39579001' = 'Anaphylactic reaction', given as 'Anaphylactic reaction'})</span>\n        </p>\n        <p>\n          <b>description</b>: Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered\n        </p>\n        <p>\n          <b>onset</b>: Jun 12, 2012\n        </p>\n        <p>\n          <b>severity</b>: SEVERE\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>event</b>\n        </p>\n        <p>\n          <b>certainty</b>: LIKELY\n        </p>\n        <p>\n          <b>manifestation</b>: Urticaria \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '64305001' = 'Hive', given as 'Urticaria'})</span>\n        </p>\n        <p>\n          <b>onset</b>: Jan 1, 2004\n        </p>\n        <p>\n          <b>severity</b>: MODERATE\n        </p>\n      </blockquote>\n    </div>"
    },
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/allergyintolerance-reasonRefuted",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "system": "http://hl7.org/fhir/v3/ActReason",
                        "code": "MED",
                        "display": "Medical Status Altered"
                    }
                ]
            }
        }
    ],
    "identifier": [
        {
            "system": "http://acme.com/ids/patients/risks",
            "value": "49476534"
        }
    ],
    "recordedDate": "2014-10-09T14:58:00+11:00",
    "recorder": {
        "reference": "Practitioner/example"
    },
    "patient": {
        "reference": "Patient/example"
    },
    "substance": {
        "coding": [
            {
                "system": "http://snomed.info/sct",
                "code": "227493005",
                "display": "Cashew nuts"
            }
        ]
    },
    "status": "confirmed",
    "criticality": "high",
    "type": "immune",
    "category": "food",
    "lastOccurence": "2012-06",
    "event": [
        {
            "substance": {
                "coding": [
                    {
                        "system": "http://www.nlm.nih.gov/research/umls/rxnorm",
                        "code": "C3214954",
                        "display": "cashew nut allergenic extract Injectable Product"
                    }
                ]
            },
            "certainty": "confirmed",
            "manifestation": [
                {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "39579001",
                            "display": "Anaphylactic reaction"
                        }
                    ]
                }
            ],
            "description": "Challenge Protocol. Severe Reaction to 1/8 cashew. Epinephrine administered",
            "onset": "2012-06-12",
            "severity": "severe"
        },
        {
            "certainty": "likely",
            "manifestation": [
                {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "64305001",
                            "display": "Urticaria"
                        }
                    ]
                }
            ],
            "onset": "2004",
            "severity": "moderate"
        }
    ]
};

var example5: fhir.Appointment = {
    "comment": "Further expand on the results of the MRI and determine the next actions that may be appropriate.",
    "description": "Discussion on the results of your recent MRI",
    "end": "2013-12-10T11:00:00Z",
    "id": "example",
    "participant": [
        {
            "actor": {
                "display": "Peter James Chalmers",
                "reference": "Patient/example"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "actor": {
                "display": "Dr Adam Careful",
                "reference": "Practitioner/example"
            },
            "required": "required",
            "status": "accepted",
            "type": [
                {
                    "coding": [
                        {
                            "code": "attending"
                        }
                    ]
                }
            ]
        },
        {
            "actor": {
                "display": "South Wing, second floor",
                "reference": "Location/1"
            },
            "required": "required",
            "status": "accepted"
        }
    ],
    "priority": 5,
    "resourceType": "Appointment",
    "start": "2013-12-10T09:00:00Z",
    "status": "booked",
    "text": {
        "div": "<div>Brian MRI results discussion</div>",
        "status": "generated"
    },
    "type": {
        "coding": [
            {
                "code": "52",
                "display": "General Discussion"
            }
        ]
    }
};

var example6: fhir.Appointment = {
    "resourceType": "Appointment",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>Brian MRI results discussion</div>"
    },
    "status": "booked",
    "type": {
        "coding": [
            {
                "code": "52",
                "display": "General Discussion"
            }
        ]
    },
    "priority": 5,
    "description": "Discussion on the results of your recent MRI",
    "start": "2013-12-10T09:00:00Z",
    "end": "2013-12-10T11:00:00Z",
    "comment": "Further expand on the results of the MRI and determine the next actions that may be appropriate.",
    "participant": [
        {
            "actor": {
                "reference": "Patient/example",
                "display": "Peter James Chalmers"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "type": [
                {
                    "coding": [
                        {
                            "code": "attending"
                        }
                    ]
                }
            ],
            "actor": {
                "reference": "Practitioner/example",
                "display": "Dr Adam Careful"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "actor": {
                "reference": "Location/1",
                "display": "South Wing, second floor"
            },
            "required": "required",
            "status": "accepted"
        }
    ]
};

var example7: fhir.Appointment = {
    "comment": "Clarify the results of the MRI to ensure context of test was correct",
    "description": "Discussion about Peter Chalmers MRI results",
    "end": "2013-12-09T11:00:00Z",
    "id": "2docs",
    "participant": [
        {
            "actor": {
                "display": "Peter James Chalmers",
                "reference": "Patient/example"
            },
            "required": "information-only",
            "status": "accepted"
        },
        {
            "actor": {
                "display": "Dr Adam Careful",
                "reference": "Practitioner/example"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "actor": {
                "display": "Luigi Maas",
                "reference": "Practitioner/f202"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "actor": {
                "display": "Phone Call"
            },
            "required": "information-only",
            "status": "accepted"
        }
    ],
    "priority": 5,
    "resourceType": "Appointment",
    "start": "2013-12-09T09:00:00Z",
    "status": "booked",
    "text": {
        "div": "<div>Brian MRI results discussion</div>",
        "status": "generated"
    },
    "type": {
        "coding": [
            {
                "code": "52",
                "display": "General Discussion"
            }
        ]
    }
};

var example8: fhir.Appointment = {
    "resourceType": "Appointment",
    "id": "2docs",
    "text": {
        "status": "generated",
        "div": "<div>Brian MRI results discussion</div>"
    },
    "status": "booked",
    "type": {
        "coding": [
            {
                "code": "52",
                "display": "General Discussion"
            }
        ]
    },
    "priority": 5,
    "description": "Discussion about Peter Chalmers MRI results",
    "start": "2013-12-09T09:00:00Z",
    "end": "2013-12-09T11:00:00Z",
    "comment": "Clarify the results of the MRI to ensure context of test was correct",
    "participant": [
        {
            "actor": {
                "reference": "Patient/example",
                "display": "Peter James Chalmers"
            },
            "required": "information-only",
            "status": "accepted"
        },
        {
            "actor": {
                "reference": "Practitioner/example",
                "display": "Dr Adam Careful"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "actor": {
                "reference": "Practitioner/f202",
                "display": "Luigi Maas"
            },
            "required": "required",
            "status": "accepted"
        },
        {
            "actor": {
                "display": "Phone Call"
            },
            "required": "information-only",
            "status": "accepted"
        }
    ]
};

var example9: fhir.AppointmentResponse = {
    "actor": {
        "display": "Peter James Chalmers",
        "reference": "Patient/example"
    },
    "appointment": {
        "display": "Brian MRI results discussion",
        "reference": "Appointment/example"
    },
    "id": "example",
    "participantStatus": "accepted",
    "resourceType": "AppointmentResponse",
    "text": {
        "div": "<div>Accept Brian MRI results discussion</div>",
        "status": "generated"
    }
};

var example10: fhir.AppointmentResponse = {
    "resourceType": "AppointmentResponse",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>Accept Brian MRI results discussion</div>"
    },
    "appointment": {
        "reference": "Appointment/example",
        "display": "Brian MRI results discussion"
    },
    "actor": {
        "reference": "Patient/example",
        "display": "Peter James Chalmers"
    },
    "participantStatus": "accepted"
};

var example11: fhir.AuditEvent = {
    "event": {
        "action": "E",
        "dateTime": "2013-06-20T23:41:23Z",
        "outcome": "0",
        "subtype": [
            {
                "coding": [
                    {
                        "code": "110122",
                        "display": "Login",
                        "system": "http://nema.org/dicom/dicm"
                    }
                ]
            }
        ],
        "type": {
            "coding": [
                {
                    "code": "110114",
                    "display": "User Authentication",
                    "system": "http://nema.org/dicom/dicm"
                }
            ]
        }
    },
    "id": "example-login",
    "participant": [
        {
            "altId": "601847123",
            "name": "Grahame Grieve",
            "network": {
                "identifier": "127.0.0.1",
                "type": "2"
            },
            "requestor": true,
            "userId": "95"
        }
    ],
    "resourceType": "AuditEvent",
    "source": {
        "identifier": "hl7connect.healthintersections.com.au",
        "site": "Cloud",
        "type": [
            {
                "code": "3",
                "display": "Web Server",
                "system": "http://hl7.org/fhir/security-source-type"
            }
        ]
    },
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <h3>Events</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Subtype</b>\n          </td>\n          <td>\n            <b>Action</b>\n          </td>\n          <td>\n            <b>DateTime</b>\n          </td>\n          <td>\n            <b>Outcome</b>\n          </td>\n          <td>\n            <b>OutcomeDesc</b>\n          </td>\n          <td>\n            <b>PurposeOfEvent</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>User Authentication \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110114' = 'User Authentication', given as 'User Authentication'})</span>\n          </td>\n          <td>Login \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110122' = 'Login', given as 'Login'})</span>\n          </td>\n          <td>E</td>\n          <td>Jun 21, 2013 9:41:23 AM</td>\n          <td>_0</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>userId</b>: 95\n        </p>\n        <p>\n          <b>altId</b>: 601847123\n        </p>\n        <p>\n          <b>name</b>: Grahame Grieve\n        </p>\n        <p>\n          <b>requestor</b>: true\n        </p>\n        <h3>Networks</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Identifier</b>\n            </td>\n            <td>\n              <b>Type</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>127.0.0.1</td>\n            <td>_2</td>\n          </tr>\n        </table>\n      </blockquote>\n      <h3>Sources</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Identifier</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Cloud</td>\n          <td>hl7connect.healthintersections.com.au</td>\n          <td>Web Server (Details: http://hl7.org/fhir/security-source-type code 3 = 'Web Server', stated as 'Web Server')</td>\n        </tr>\n      </table>\n    </div>",
        "status": "generated"
    }
};

var example12: fhir.AuditEvent = {
    "resourceType": "AuditEvent",
    "id": "example-login",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <h3>Events</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Subtype</b>\n          </td>\n          <td>\n            <b>Action</b>\n          </td>\n          <td>\n            <b>DateTime</b>\n          </td>\n          <td>\n            <b>Outcome</b>\n          </td>\n          <td>\n            <b>OutcomeDesc</b>\n          </td>\n          <td>\n            <b>PurposeOfEvent</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>User Authentication \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110114' = 'User Authentication', given as 'User Authentication'})</span>\n          </td>\n          <td>Login \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110122' = 'Login', given as 'Login'})</span>\n          </td>\n          <td>E</td>\n          <td>Jun 21, 2013 9:41:23 AM</td>\n          <td>_0</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>userId</b>: 95\n        </p>\n        <p>\n          <b>altId</b>: 601847123\n        </p>\n        <p>\n          <b>name</b>: Grahame Grieve\n        </p>\n        <p>\n          <b>requestor</b>: true\n        </p>\n        <h3>Networks</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Identifier</b>\n            </td>\n            <td>\n              <b>Type</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>127.0.0.1</td>\n            <td>_2</td>\n          </tr>\n        </table>\n      </blockquote>\n      <h3>Sources</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Identifier</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Cloud</td>\n          <td>hl7connect.healthintersections.com.au</td>\n          <td>Web Server (Details: http://hl7.org/fhir/security-source-type code 3 = 'Web Server', stated as 'Web Server')</td>\n        </tr>\n      </table>\n    </div>"
    },
    "event": {
        "type": {
            "coding": [
                {
                    "system": "http://nema.org/dicom/dicm",
                    "code": "110114",
                    "display": "User Authentication"
                }
            ]
        },
        "subtype": [
            {
                "coding": [
                    {
                        "system": "http://nema.org/dicom/dicm",
                        "code": "110122",
                        "display": "Login"
                    }
                ]
            }
        ],
        "action": "E",
        "dateTime": "2013-06-20T23:41:23Z",
        "outcome": "0"
    },
    "participant": [
        {
            "userId": "95",
            "altId": "601847123",
            "name": "Grahame Grieve",
            "requestor": true,
            "network": {
                "identifier": "127.0.0.1",
                "type": "2"
            }
        }
    ],
    "source": {
        "site": "Cloud",
        "identifier": "hl7connect.healthintersections.com.au",
        "type": [
            {
                "system": "http://hl7.org/fhir/security-source-type",
                "code": "3",
                "display": "Web Server"
            }
        ]
    }
};

var example13: fhir.AuditEvent = {
    "event": {
        "action": "E",
        "dateTime": "2013-06-20T23:46:41Z",
        "outcome": "0",
        "subtype": [
            {
                "coding": [
                    {
                        "code": "110123",
                        "display": "Logout",
                        "system": "http://nema.org/dicom/dicm"
                    }
                ]
            }
        ],
        "type": {
            "coding": [
                {
                    "code": "110114",
                    "display": "User Authentication",
                    "system": "http://nema.org/dicom/dicm"
                }
            ]
        }
    },
    "id": "example-logout",
    "participant": [
        {
            "altId": "601847123",
            "name": "Grahame Grieve",
            "network": {
                "identifier": "127.0.0.1",
                "type": "2"
            },
            "requestor": true,
            "userId": "95"
        }
    ],
    "resourceType": "AuditEvent",
    "source": {
        "identifier": "hl7connect.healthintersections.com.au",
        "site": "Cloud",
        "type": [
            {
                "code": "3",
                "display": "Web Server",
                "system": "http://hl7.org/fhir/security-source-type"
            }
        ]
    },
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <h3>Events</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Subtype</b>\n          </td>\n          <td>\n            <b>Action</b>\n          </td>\n          <td>\n            <b>DateTime</b>\n          </td>\n          <td>\n            <b>Outcome</b>\n          </td>\n          <td>\n            <b>OutcomeDesc</b>\n          </td>\n          <td>\n            <b>PurposeOfEvent</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>User Authentication \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110114' = 'User Authentication', given as 'User Authentication'})</span>\n          </td>\n          <td>Logout \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110123' = 'Logout', given as 'Logout'})</span>\n          </td>\n          <td>E</td>\n          <td>Jun 21, 2013 9:46:41 AM</td>\n          <td>_0</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>userId</b>: 95\n        </p>\n        <p>\n          <b>altId</b>: 601847123\n        </p>\n        <p>\n          <b>name</b>: Grahame Grieve\n        </p>\n        <p>\n          <b>requestor</b>: true\n        </p>\n        <h3>Networks</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Identifier</b>\n            </td>\n            <td>\n              <b>Type</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>127.0.0.1</td>\n            <td>_2</td>\n          </tr>\n        </table>\n      </blockquote>\n      <h3>Sources</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Identifier</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Cloud</td>\n          <td>hl7connect.healthintersections.com.au</td>\n          <td>Web Server (Details: http://hl7.org/fhir/security-source-type code 3 = 'Web Server', stated as 'Web Server')</td>\n        </tr>\n      </table>\n    </div>",
        "status": "generated"
    }
};

var example14: fhir.AuditEvent = {
    "resourceType": "AuditEvent",
    "id": "example-logout",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <h3>Events</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Subtype</b>\n          </td>\n          <td>\n            <b>Action</b>\n          </td>\n          <td>\n            <b>DateTime</b>\n          </td>\n          <td>\n            <b>Outcome</b>\n          </td>\n          <td>\n            <b>OutcomeDesc</b>\n          </td>\n          <td>\n            <b>PurposeOfEvent</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>User Authentication \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110114' = 'User Authentication', given as 'User Authentication'})</span>\n          </td>\n          <td>Logout \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://nema.org/dicom/dicm code '110123' = 'Logout', given as 'Logout'})</span>\n          </td>\n          <td>E</td>\n          <td>Jun 21, 2013 9:46:41 AM</td>\n          <td>_0</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>userId</b>: 95\n        </p>\n        <p>\n          <b>altId</b>: 601847123\n        </p>\n        <p>\n          <b>name</b>: Grahame Grieve\n        </p>\n        <p>\n          <b>requestor</b>: true\n        </p>\n        <h3>Networks</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Identifier</b>\n            </td>\n            <td>\n              <b>Type</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>127.0.0.1</td>\n            <td>_2</td>\n          </tr>\n        </table>\n      </blockquote>\n      <h3>Sources</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Identifier</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Cloud</td>\n          <td>hl7connect.healthintersections.com.au</td>\n          <td>Web Server (Details: http://hl7.org/fhir/security-source-type code 3 = 'Web Server', stated as 'Web Server')</td>\n        </tr>\n      </table>\n    </div>"
    },
    "event": {
        "type": {
            "coding": [
                {
                    "system": "http://nema.org/dicom/dicm",
                    "code": "110114",
                    "display": "User Authentication"
                }
            ]
        },
        "subtype": [
            {
                "coding": [
                    {
                        "system": "http://nema.org/dicom/dicm",
                        "code": "110123",
                        "display": "Logout"
                    }
                ]
            }
        ],
        "action": "E",
        "dateTime": "2013-06-20T23:46:41Z",
        "outcome": "0"
    },
    "participant": [
        {
            "userId": "95",
            "altId": "601847123",
            "name": "Grahame Grieve",
            "requestor": true,
            "network": {
                "identifier": "127.0.0.1",
                "type": "2"
            }
        }
    ],
    "source": {
        "site": "Cloud",
        "identifier": "hl7connect.healthintersections.com.au",
        "type": [
            {
                "system": "http://hl7.org/fhir/security-source-type",
                "code": "3",
                "display": "Web Server"
            }
        ]
    }
};

var example15: fhir.AuditEvent = {
    "event": {
        "action": "R",
        "dateTime": "2013-06-20T23:42:24Z",
        "outcome": "0",
        "subtype": [
            {
                "coding": [
                    {
                        "code": "vread",
                        "display": "vread",
                        "system": "http://hl7.org/fhir/restful-interaction"
                    }
                ]
            }
        ],
        "type": {
            "coding": [
                {
                    "code": "rest",
                    "display": "Restful Operation",
                    "system": "http://hl7.org/fhir/audit-event-type"
                }
            ]
        }
    },
    "id": "example-rest",
    "object": [
        {
            "lifecycle": "6",
            "reference": {
                "reference": "Patient/example/_history/1"
            },
            "type": "2"
        }
    ],
    "participant": [
        {
            "altId": "601847123",
            "name": "Grahame Grieve",
            "requestor": true,
            "userId": "95"
        }
    ],
    "resourceType": "AuditEvent",
    "source": {
        "identifier": "hl7connect.healthintersections.com.au",
        "site": "Cloud",
        "type": [
            {
                "code": "3",
                "display": "Web Server",
                "system": "http://hl7.org/fhir/security-source-type"
            }
        ]
    },
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <h3>Events</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Subtype</b>\n          </td>\n          <td>\n            <b>Action</b>\n          </td>\n          <td>\n            <b>DateTime</b>\n          </td>\n          <td>\n            <b>Outcome</b>\n          </td>\n          <td>\n            <b>OutcomeDesc</b>\n          </td>\n          <td>\n            <b>PurposeOfEvent</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Restful Operation \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://hl7.org/fhir/audit-event-type code 'rest' = 'RESTful Operation', given as 'Restful Operation'})</span>\n          </td>\n          <td>vread \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://hl7.org/fhir/restful-interaction code 'vread' = 'vread', given as 'vread'})</span>\n          </td>\n          <td>R</td>\n          <td>Jun 21, 2013 9:42:24 AM</td>\n          <td>_0</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>userId</b>: 95\n        </p>\n        <p>\n          <b>altId</b>: 601847123\n        </p>\n        <p>\n          <b>name</b>: Grahame Grieve\n        </p>\n        <p>\n          <b>requestor</b>: true\n        </p>\n      </blockquote>\n      <h3>Sources</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Identifier</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Cloud</td>\n          <td>hl7connect.healthintersections.com.au</td>\n          <td>Web Server (Details: http://hl7.org/fhir/security-source-type code 3 = 'Web Server', stated as 'Web Server')</td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>object</b>\n        </p>\n        <p>\n          <b>reference</b>: \n          <a href=\"Patient/example/_history/1\">Patient/example/_history/1</a>\n        </p>\n        <p>\n          <b>type</b>: _2\n        </p>\n        <p>\n          <b>lifecycle</b>: _6\n        </p>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example16: fhir.AuditEvent = {
    "resourceType": "AuditEvent",
    "id": "example-rest",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <h3>Events</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Subtype</b>\n          </td>\n          <td>\n            <b>Action</b>\n          </td>\n          <td>\n            <b>DateTime</b>\n          </td>\n          <td>\n            <b>Outcome</b>\n          </td>\n          <td>\n            <b>OutcomeDesc</b>\n          </td>\n          <td>\n            <b>PurposeOfEvent</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Restful Operation \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://hl7.org/fhir/audit-event-type code 'rest' = 'RESTful Operation', given as 'Restful Operation'})</span>\n          </td>\n          <td>vread \n            <span style=\"background: LightGoldenRodYellow \">(Details : {http://hl7.org/fhir/restful-interaction code 'vread' = 'vread', given as 'vread'})</span>\n          </td>\n          <td>R</td>\n          <td>Jun 21, 2013 9:42:24 AM</td>\n          <td>_0</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>userId</b>: 95\n        </p>\n        <p>\n          <b>altId</b>: 601847123\n        </p>\n        <p>\n          <b>name</b>: Grahame Grieve\n        </p>\n        <p>\n          <b>requestor</b>: true\n        </p>\n      </blockquote>\n      <h3>Sources</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Identifier</b>\n          </td>\n          <td>\n            <b>Type</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Cloud</td>\n          <td>hl7connect.healthintersections.com.au</td>\n          <td>Web Server (Details: http://hl7.org/fhir/security-source-type code 3 = 'Web Server', stated as 'Web Server')</td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>object</b>\n        </p>\n        <p>\n          <b>reference</b>: \n          <a href=\"Patient/example/_history/1\">Patient/example/_history/1</a>\n        </p>\n        <p>\n          <b>type</b>: _2\n        </p>\n        <p>\n          <b>lifecycle</b>: _6\n        </p>\n      </blockquote>\n    </div>"
    },
    "event": {
        "type": {
            "coding": [
                {
                    "system": "http://hl7.org/fhir/audit-event-type",
                    "code": "rest",
                    "display": "Restful Operation"
                }
            ]
        },
        "subtype": [
            {
                "coding": [
                    {
                        "system": "http://hl7.org/fhir/restful-interaction",
                        "code": "vread",
                        "display": "vread"
                    }
                ]
            }
        ],
        "action": "R",
        "dateTime": "2013-06-20T23:42:24Z",
        "outcome": "0"
    },
    "participant": [
        {
            "userId": "95",
            "altId": "601847123",
            "name": "Grahame Grieve",
            "requestor": true
        }
    ],
    "source": {
        "site": "Cloud",
        "identifier": "hl7connect.healthintersections.com.au",
        "type": [
            {
                "system": "http://hl7.org/fhir/security-source-type",
                "code": "3",
                "display": "Web Server"
            }
        ]
    },
    "object": [
        {
            "reference": {
                "reference": "Patient/example/_history/1"
            },
            "type": "2",
            "lifecycle": "6"
        }
    ]
};

var example17: fhir.AuditEvent = {
    "event": {
        "action": "E",
        "dateTime": "2012-10-25T22:04:27+11:00",
        "outcome": "0",
        "subtype": [
            {
                "coding": [
                    {
                        "code": "110120",
                        "display": "Application Start",
                        "system": "http://nema.org/dicom/dicm"
                    }
                ]
            }
        ],
        "type": {
            "coding": [
                {
                    "code": "110100",
                    "display": "Application Activity",
                    "system": "http://nema.org/dicom/dicm"
                }
            ]
        }
    },
    "id": "example",
    "object": [
        {
            "identifier": {
                "type": {
                    "coding": [
                        {
                            "code": "SNO",
                            "system": "http://hl7.org/fhir/v2/0203"
                        }
                    ],
                    "text": "Dell Serial Number"
                },
                "value": "ABCDEF"
            },
            "lifecycle": "6",
            "name": "Grahame's Laptop",
            "role": "4",
            "type": "4"
        }
    ],
    "participant": [
        {
            "network": {
                "identifier": "127.0.0.1",
                "type": "2"
            },
            "requestor": false,
            "role": [
                {
                    "text": "Service User (Logon)"
                }
            ],
            "userId": "Grahame"
        }
    ],
    "resourceType": "AuditEvent",
    "source": {
        "identifier": "Grahame's Laptop",
        "site": "Development",
        "type": [
            {
                "code": "1",
                "system": "http://hl7.org/fhir/audit-event-sub-type"
            }
        ]
    },
    "text": {
        "div": "<div>Application Start for under service login &quot;Grahame&quot; (id: Grahame's Test HL7Connect)</div>",
        "status": "generated"
    }
};

var example18: fhir.AuditEvent = {
    "resourceType": "AuditEvent",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>Application Start for under service login &quot;Grahame&quot; (id: Grahame's Test HL7Connect)</div>"
    },
    "event": {
        "type": {
            "coding": [
                {
                    "system": "http://nema.org/dicom/dicm",
                    "code": "110100",
                    "display": "Application Activity"
                }
            ]
        },
        "subtype": [
            {
                "coding": [
                    {
                        "system": "http://nema.org/dicom/dicm",
                        "code": "110120",
                        "display": "Application Start"
                    }
                ]
            }
        ],
        "action": "E",
        "dateTime": "2012-10-25T22:04:27+11:00",
        "outcome": "0"
    },
    "participant": [
        {
            "role": [
                {
                    "text": "Service User (Logon)"
                }
            ],
            "userId": "Grahame",
            "requestor": false,
            "network": {
                "identifier": "127.0.0.1",
                "type": "2"
            }
        }
    ],
    "source": {
        "site": "Development",
        "identifier": "Grahame's Laptop",
        "type": [
            {
                "system": "http://hl7.org/fhir/audit-event-sub-type",
                "code": "1"
            }
        ]
    },
    "object": [
        {
            "identifier": {
                "type": {
                    "coding": [
                        {
                            "system": "http://hl7.org/fhir/v2/0203",
                            "code": "SNO"
                        }
                    ],
                    "text": "Dell Serial Number"
                },
                "value": "ABCDEF"
            },
            "type": "4",
            "role": "4",
            "lifecycle": "6",
            "name": "Grahame's Laptop"
        }
    ]
};

var example19: fhir.Basic = {
    "code": {
        "coding": [
            {
                "code": "ADVEVENT",
                "system": "http://hl7.org/fhir/other-resource-type"
            }
        ]
    },
    "extension": [
        {
            "extension": [
                {
                    "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-cause-item",
                    "valueReference": {
                        "reference": "Medication/example"
                    }
                },
                {
                    "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-cause-certainty",
                    "valueCodeableConcept": {
                        "coding": [
                            {
                                "code": "415684004",
                                "display": "Suspected (qualifier)",
                                "system": "http://snomed.info/sct"
                            }
                        ]
                    }
                }
            ],
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-cause"
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-type",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "code": "28926001",
                        "display": "Eruption due to drug (disorder)",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-period",
            "valuePeriod": {
                "end": "2014-01-15",
                "start": "2014-01-14"
            }
        }
    ],
    "id": "qicore",
    "modifierExtension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-didNotOccur",
            "valueBoolean": false
        }
    ],
    "resourceType": "Basic",
    "subject": {
        "display": "Peter Patient",
        "reference": "Patient/example"
    },
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>code</b>: ADVEVENT \n        <span style=\"background: LightGoldenRodYellow \">(Details : {http://hl7.org/fhir/other-resource-type code 'ADVEVENT' = 'ADVEVENT)</span>\n      </p>\n      <p>\n        <b>subject</b>: \n        <a href=\"Patient/example\">Peter Patient. Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n    </div>",
        "status": "generated"
    }
};

var example20: fhir.Basic = {
    "resourceType": "Basic",
    "id": "qicore",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>code</b>: ADVEVENT \n        <span style=\"background: LightGoldenRodYellow \">(Details : {http://hl7.org/fhir/other-resource-type code 'ADVEVENT' = 'ADVEVENT)</span>\n      </p>\n      <p>\n        <b>subject</b>: \n        <a href=\"Patient/example\">Peter Patient. Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n    </div>"
    },
    "extension": [
        {
            "extension": [
                {
                    "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-cause-item",
                    "valueReference": {
                        "reference": "Medication/example"
                    }
                },
                {
                    "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-cause-certainty",
                    "valueCodeableConcept": {
                        "coding": [
                            {
                                "system": "http://snomed.info/sct",
                                "code": "415684004",
                                "display": "Suspected (qualifier)"
                            }
                        ]
                    }
                }
            ],
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-cause"
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-type",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "28926001",
                        "display": "Eruption due to drug (disorder)"
                    }
                ]
            }
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-period",
            "valuePeriod": {
                "start": "2014-01-14",
                "end": "2014-01-15"
            }
        }
    ],
    "modifierExtension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/adverseevent-qicore-didNotOccur",
            "valueBoolean": false
        }
    ],
    "code": {
        "coding": [
            {
                "system": "http://hl7.org/fhir/other-resource-type",
                "code": "ADVEVENT"
            }
        ]
    },
    "subject": {
        "reference": "Patient/example",
        "display": "Peter Patient"
    }
};

var example21: fhir.Basic = {
    "code": {
        "text": "Example Narrative Tester"
    },
    "id": "basic-example-narrative",
    "resourceType": "Basic",
    "text": {
        "div": "<div>\n      \n      <h1>Example Narrative</h1> \n      \n      <h2>Plain HTML, No Styles</h2> \n      \n      <h3>Heading 3</h3>\n      \n      <h4>Heading 4</h4>\n      \n      <h5>Heading 5</h5>\n      \n      <h6>Heading 6</h6>\n      \n      <p>\n        Paragraph. \n        <span>span</span>. \n        <a href=\"#link\">Link</a>. \n        <b>Bold</b>, br:\n        <br/> \n        <em>em</em>, \n        <i>Italics</i>,\n        \n        <strong>strong</strong>, \n        <small>small</small>, \n        <big>big</big> \n        <tt>Teletype Text</tt>, \n        <small>small</small>, \n        \n        <dfn>Definition term</dfn>, \n        <q>q</q>, \n        <var>var</var>.\n        All provided by \n        \n        <abbr title=\"Health Level 7\">HL7</abbr>, for \n        <acronym title=\"Fast Healthcare Interoperability Resources\">FHIR</acronym> (\n        <cite>cite</cite>).\n      \n      </p>\n      \n      <blockquote>\n        \n        <p>Paragraph in a blockquote, with an hr after it:</p>\n      \n      </blockquote>\n      \n      <hr/>\n      \n      <div>\n      \n        <p>Paragraph in a div (\n          <a name=\"link\">Link Target</a>)\n        </p>\n      \n      </div>   \n      \n      <ul>\n        \n        <li>Unordered List Item</li>      \n      \n      </ul>   \n      \n      <ol>\n        \n        <li>Ordered List Item</li>\n      \n      </ol>\n      \n      <dl>\n        \n        <dt>DT Item</dt>\n        <dd>DD Item</dd>\n      \n      </dl>\n      \n      <pre>\n        Some Pre Text\n          with a line break\n      </pre>\n      \n      <p>Table:</p>\n      \n      <table>\n        \n        <caption>Table Caption</caption>\n        \n        <colgroup>\n          \n          <col style=\"background-color:red\" span=\"2\"/>\n          \n          <col style=\"background-color:yellow\"/>\n        \n        </colgroup>      \n        \n        <thead>\n          \n          <tr>\n            \n            <th>Head Cell 1</th>\n            \n            <th>Head Cell 2</th>\n            \n            <th>Head Cell 3</th>\n          \n          </tr>\n        \n        </thead>\n        \n        <tfoot>\n          \n          <tr>\n            \n            <td>Foot Cell 1</td>\n            \n            <td>Foot Cell 2</td>\n            \n            <td>Foot Cell 3</td>\n          \n          </tr>\n        \n        </tfoot>\n        \n        <tbody>\n          \n          <tr>\n            \n            <td>Body Cell 1</td>\n            \n            <td>Body Cell 2</td>\n            \n            <td>Body Cell 3</td>\n          \n          </tr>\n        \n        </tbody>\n      \n      </table>\n      \n      <code>Code Block</code>\n      \n      <samp>Sample Block</samp>\n      \n      <h2>External Styles</h2> \n      \n      <h3>Text:</h3> \n      \n      <p>Example Text: \n        <span class=\"bold\">bold</span>, \n        <span class=\"italics\">italics</span>, \n        <span class=\"underline\">underline</span> \n        and \n        <span class=\"strikethrough\">strikethrough</span>\n      </p>\n      \n      <p class=\"left\">This paragraph is left aligned. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. </p>  \n      \n      <p class=\"right\">This paragraph is right aligned. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. </p>  \n      \n      <p class=\"center\">This paragraph is center aligned. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. </p>  \n      \n      <p class=\"justify\">This paragraph is justified. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen.  </p>  \n      \n      <h3>Table:</h3> \n      \n      <table>\n        \n        <tr>\n          \n          <td class=\"border-left\">Border Left</td>\n          \n          <td class=\"border-right\">Border Right</td>\n          \n          <td class=\"border-top\">Border Top</td>\n          \n          <td class=\"border-bottom\">Border Bottom</td>\n        \n        </tr>\n      \n      </table>\n      \n      <h3>List:</h3> \n      \n      <ol class=\"arabic\">\n        \n        <li>arabic (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"little-roman\">\n        \n        <li>little-roman (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"big-roman\">\n        \n        <li>big-roman (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"little-alpha\">\n        \n        <li>little-alpha (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"big-alpha\">\n        \n        <li>big-alpha (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ul class=\"disc\">\n        \n        <li>disc (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ul>\n      \n      <ul class=\"circle\">\n        \n        <li>circle (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ul>\n      \n      <ul class=\"square\">\n        \n        <li>square (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ul>\n      \n      <h2>Internal Styles</h2>\n      \n      <p>Example Text: \n        <span style=\"font-weight: bold\">bold</span>, \n        <span style=\"font-style: italics\">italics</span>, \n        <span style=\"text-decoration: underline\">underline</span> \n        and \n        <span style=\"text-decoration: line-through\">strikethrough</span>. \n        Font-Family \n        <span style=\"font-family: serif\">Serif</span> and \n        <span style=\"font-family: sans-serif\">Sans Serif</span>, \n        Font-size \n        <span style=\"font-size: 50%\">50%</span> \n        <span style=\"font-size: 80%\">80%</span> \n        <span style=\"font-size: 150%\">150%</span>, \n        Font-Color  \n        <span style=\"color: navy\">Navy</span> \n        <span style=\"color: maroon\">Maroon</span> \n        <span style=\"color: brown\">Brown</span>,\n        Background-color \n        <span style=\"background-color: aqua\">Aqua</span> \n        <span style=\"color: silver\">Silver</span> \n        <span style=\"color: pink\">Pink</span>.\n       \n      </p>\n       \n      <p>\n         Whitespace Control:\n       </p>\n       \n      <p style=\"white-space: normal\">Normal    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: nowrap\">No-Wrap    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: pre\">Pre    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: pre-line\">Pre-Line    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: pre-wrap\">Pre-Wrap    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n        \n      \n      <p style=\"text-align: left\">This paragraph is left aligned. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. </p>  \n      \n      <p style=\"text-align: right\">This paragraph is right aligned. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. </p>  \n      \n      <p style=\"text-align: center\">This paragraph is center aligned. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. </p>  \n      \n      <p style=\"text-align: justify\">This paragraph is justified. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen.  </p>  \n      \n      \n      <ol style=\"list-style-type: armenian\">\n        \n        <li>armenian (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>      \t\n      \n      <ol style=\"list-style-type: cjk-ideographic\">\n        \n        <li>cjk-ideographic\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: decimal\">\n        \n        <li>decimal\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: decimal-leading-zero\">\n        \n        <li>decimal-leading-zero\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: georgian\">\n        \n        <li>georgian\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: hebrew\">\n        \n        <li>hebrew\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: hiragana\">\n        \n        <li>hiragana\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: hiragana-iroha\">\n        \n        <li>hiragana-iroha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: inherit\">\n        \n        <li>inherit\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: katakana\">\n        \n        <li>katakana\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: katakana-iroha\">\n        \n        <li>katakana-iroha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-alpha\">\n        \n        <li>lower-alpha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-greek\">\n        \n        <li>lower-greek\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-latin\">\n        \n        <li>lower-latin\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-roman\">\n        \n        <li>lower-roman\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: none\">\n        \n        <li>none\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-alpha\">\n        \n        <li>upper-alpha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-latin\">\n        \n        <li>upper-latin\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-roman\">\n        \n        <li>upper-roman\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-roman\">\n        \n        <li>upper-roman\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n    \n    </div>",
        "status": "additional"
    }
};

var example22: fhir.Basic = {
    "resourceType": "Basic",
    "id": "basic-example-narrative",
    "text": {
        "status": "additional",
        "div": "<div>\n      \n      <h1>Example Narrative</h1> \n      \n      <h2>Plain HTML, No Styles</h2> \n      \n      <h3>Heading 3</h3>\n      \n      <h4>Heading 4</h4>\n      \n      <h5>Heading 5</h5>\n      \n      <h6>Heading 6</h6>\n      \n      <p>\n        Paragraph. \n        <span>span</span>. \n        <a href=\"#link\">Link</a>. \n        <b>Bold</b>, br:\n        <br/> \n        <em>em</em>, \n        <i>Italics</i>,\n        \n        <strong>strong</strong>, \n        <small>small</small>, \n        <big>big</big> \n        <tt>Teletype Text</tt>, \n        <small>small</small>, \n        \n        <dfn>Definition term</dfn>, \n        <q>q</q>, \n        <var>var</var>.\n        All provided by \n        \n        <abbr title=\"Health Level 7\">HL7</abbr>, for \n        <acronym title=\"Fast Healthcare Interoperability Resources\">FHIR</acronym> (\n        <cite>cite</cite>).\n      \n      </p>\n      \n      <blockquote>\n        \n        <p>Paragraph in a blockquote, with an hr after it:</p>\n      \n      </blockquote>\n      \n      <hr/>\n      \n      <div>\n      \n        <p>Paragraph in a div (\n          <a name=\"link\">Link Target</a>)\n        </p>\n      \n      </div>   \n      \n      <ul>\n        \n        <li>Unordered List Item</li>      \n      \n      </ul>   \n      \n      <ol>\n        \n        <li>Ordered List Item</li>\n      \n      </ol>\n      \n      <dl>\n        \n        <dt>DT Item</dt>\n        <dd>DD Item</dd>\n      \n      </dl>\n      \n      <pre>\n        Some Pre Text\n          with a line break\n      </pre>\n      \n      <p>Table:</p>\n      \n      <table>\n        \n        <caption>Table Caption</caption>\n        \n        <colgroup>\n          \n          <col style=\"background-color:red\" span=\"2\"/>\n          \n          <col style=\"background-color:yellow\"/>\n        \n        </colgroup>      \n        \n        <thead>\n          \n          <tr>\n            \n            <th>Head Cell 1</th>\n            \n            <th>Head Cell 2</th>\n            \n            <th>Head Cell 3</th>\n          \n          </tr>\n        \n        </thead>\n        \n        <tfoot>\n          \n          <tr>\n            \n            <td>Foot Cell 1</td>\n            \n            <td>Foot Cell 2</td>\n            \n            <td>Foot Cell 3</td>\n          \n          </tr>\n        \n        </tfoot>\n        \n        <tbody>\n          \n          <tr>\n            \n            <td>Body Cell 1</td>\n            \n            <td>Body Cell 2</td>\n            \n            <td>Body Cell 3</td>\n          \n          </tr>\n        \n        </tbody>\n      \n      </table>\n      \n      <code>Code Block</code>\n      \n      <samp>Sample Block</samp>\n      \n      <h2>External Styles</h2> \n      \n      <h3>Text:</h3> \n      \n      <p>Example Text: \n        <span class=\"bold\">bold</span>, \n        <span class=\"italics\">italics</span>, \n        <span class=\"underline\">underline</span> \n        and \n        <span class=\"strikethrough\">strikethrough</span>\n      </p>\n      \n      <p class=\"left\">This paragraph is left aligned. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. </p>  \n      \n      <p class=\"right\">This paragraph is right aligned. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. </p>  \n      \n      <p class=\"center\">This paragraph is center aligned. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. </p>  \n      \n      <p class=\"justify\">This paragraph is justified. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen.  </p>  \n      \n      <h3>Table:</h3> \n      \n      <table>\n        \n        <tr>\n          \n          <td class=\"border-left\">Border Left</td>\n          \n          <td class=\"border-right\">Border Right</td>\n          \n          <td class=\"border-top\">Border Top</td>\n          \n          <td class=\"border-bottom\">Border Bottom</td>\n        \n        </tr>\n      \n      </table>\n      \n      <h3>List:</h3> \n      \n      <ol class=\"arabic\">\n        \n        <li>arabic (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"little-roman\">\n        \n        <li>little-roman (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"big-roman\">\n        \n        <li>big-roman (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"little-alpha\">\n        \n        <li>little-alpha (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol class=\"big-alpha\">\n        \n        <li>big-alpha (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ul class=\"disc\">\n        \n        <li>disc (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ul>\n      \n      <ul class=\"circle\">\n        \n        <li>circle (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ul>\n      \n      <ul class=\"square\">\n        \n        <li>square (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ul>\n      \n      <h2>Internal Styles</h2>\n      \n      <p>Example Text: \n        <span style=\"font-weight: bold\">bold</span>, \n        <span style=\"font-style: italics\">italics</span>, \n        <span style=\"text-decoration: underline\">underline</span> \n        and \n        <span style=\"text-decoration: line-through\">strikethrough</span>. \n        Font-Family \n        <span style=\"font-family: serif\">Serif</span> and \n        <span style=\"font-family: sans-serif\">Sans Serif</span>, \n        Font-size \n        <span style=\"font-size: 50%\">50%</span> \n        <span style=\"font-size: 80%\">80%</span> \n        <span style=\"font-size: 150%\">150%</span>, \n        Font-Color  \n        <span style=\"color: navy\">Navy</span> \n        <span style=\"color: maroon\">Maroon</span> \n        <span style=\"color: brown\">Brown</span>,\n        Background-color \n        <span style=\"background-color: aqua\">Aqua</span> \n        <span style=\"color: silver\">Silver</span> \n        <span style=\"color: pink\">Pink</span>.\n       \n      </p>\n       \n      <p>\n         Whitespace Control:\n       </p>\n       \n      <p style=\"white-space: normal\">Normal    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: nowrap\">No-Wrap    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: pre\">Pre    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: pre-line\">Pre-Line    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n       \n      <p style=\"white-space: pre-wrap\">Pre-Wrap    Whitespace\n          Test, long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long long sentence</p>\n        \n      \n      <p style=\"text-align: left\">This paragraph is left aligned. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. The content should be laid out aligned at the left of the screen. </p>  \n      \n      <p style=\"text-align: right\">This paragraph is right aligned. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. The content should be laid out aligned at the right of the screen. </p>  \n      \n      <p style=\"text-align: center\">This paragraph is center aligned. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. The content should be laid out aligned at the center of the screen. </p>  \n      \n      <p style=\"text-align: justify\">This paragraph is justified. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen. The content should be laid out aligned at both the left and right of the screen.  </p>  \n      \n      \n      <ol style=\"list-style-type: armenian\">\n        \n        <li>armenian (Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>      \t\n      \n      <ol style=\"list-style-type: cjk-ideographic\">\n        \n        <li>cjk-ideographic\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: decimal\">\n        \n        <li>decimal\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: decimal-leading-zero\">\n        \n        <li>decimal-leading-zero\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: georgian\">\n        \n        <li>georgian\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: hebrew\">\n        \n        <li>hebrew\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: hiragana\">\n        \n        <li>hiragana\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: hiragana-iroha\">\n        \n        <li>hiragana-iroha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: inherit\">\n        \n        <li>inherit\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: katakana\">\n        \n        <li>katakana\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: katakana-iroha\">\n        \n        <li>katakana-iroha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-alpha\">\n        \n        <li>lower-alpha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-greek\">\n        \n        <li>lower-greek\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-latin\">\n        \n        <li>lower-latin\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: lower-roman\">\n        \n        <li>lower-roman\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: none\">\n        \n        <li>none\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-alpha\">\n        \n        <li>upper-alpha\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-latin\">\n        \n        <li>upper-latin\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-roman\">\n        \n        <li>upper-roman\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n      <ol style=\"list-style-type: upper-roman\">\n        \n        <li>upper-roman\t(Item 1)</li>\n        \n        <li>Item Two</li>\n      \n      </ol>\n      \n    \n    </div>"
    },
    "code": {
        "text": "Example Narrative Tester"
    }
};

var example23: fhir.Basic = {
    "code": {
        "coding": [
            {
                "code": "REFERRAL",
                "system": "http://hl7.org/fhir/basic-resource-type"
            }
        ]
    },
    "extension": [
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#requestingPractitioner",
            "valueReference": {
                "display": "Dokter Bronsig",
                "reference": "Practitioner/f201"
            }
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#notes",
            "valueString": "The patient had fever peaks over the last couple of days. He is worried about these peaks."
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#fulfillingEncounter",
            "valueReference": {
                "reference": "Encounter/f201"
            }
        }
    ],
    "id": "referral",
    "modifierExtension": [
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#referredForService",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "code": "11429006",
                        "display": "Consultation",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#targetDate",
            "valuePeriod": {
                "end": "2013-04-15",
                "start": "2013-04-01"
            }
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#status",
            "valueCode": "complete"
        }
    ],
    "resourceType": "Basic",
    "subject": {
        "display": "Roel",
        "reference": "Patient/f201"
    },
    "text": {
        "div": "<div>\n      \n      <p>\n        <b>Patient:</b>Roel\n      </p>\n      \n      <p>\n        <b>Requestor:</b>Dokter Bronsig\n      </p>\n      \n      <p>\n        <b>Type:</b>Consultation\n      </p>\n      \n      <p>\n        <b>Target Date:</b>April 1 - April 31\n      </p>\n      \n      <p>COMPLETED</p>\n      \n      <b>The patient had fever peaks over the last couple of days. He is worried about these peaks.</b>\n    \n    </div>",
        "status": "generated"
    }
};

var example24: fhir.Basic = {
    "resourceType": "Basic",
    "id": "referral",
    "text": {
        "status": "generated",
        "div": "<div>\n      \n      <p>\n        <b>Patient:</b>Roel\n      </p>\n      \n      <p>\n        <b>Requestor:</b>Dokter Bronsig\n      </p>\n      \n      <p>\n        <b>Type:</b>Consultation\n      </p>\n      \n      <p>\n        <b>Target Date:</b>April 1 - April 31\n      </p>\n      \n      <p>COMPLETED</p>\n      \n      <b>The patient had fever peaks over the last couple of days. He is worried about these peaks.</b>\n    \n    </div>"
    },
    "extension": [
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#requestingPractitioner",
            "valueReference": {
                "reference": "Practitioner/f201",
                "display": "Dokter Bronsig"
            }
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#notes",
            "valueString": "The patient had fever peaks over the last couple of days. He is worried about these peaks."
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#fulfillingEncounter",
            "valueReference": {
                "reference": "Encounter/f201"
            }
        }
    ],
    "modifierExtension": [
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#referredForService",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "11429006",
                        "display": "Consultation"
                    }
                ]
            }
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#targetDate",
            "valuePeriod": {
                "start": "2013-04-01",
                "end": "2013-04-15"
            }
        },
        {
            "url": "http://example.org/do-not-use/fhir-extensions/referral#status",
            "valueCode": "complete"
        }
    ],
    "code": {
        "coding": [
            {
                "system": "http://hl7.org/fhir/basic-resource-type",
                "code": "REFERRAL"
            }
        ]
    },
    "subject": {
        "reference": "Patient/f201",
        "display": "Roel"
    }
};

var example25: fhir.Basic = {
    "code": {
        "coding": [
            {
                "code": "UMLCLASSMODEL",
                "system": "http://example.org/do-not-use/fhir-codes#resourceTypes"
            }
        ]
    },
    "extension": [
        {
            "extension": [
                {
                    "url": "name",
                    "valueString": "Class1"
                },
                {
                    "extension": [
                        {
                            "url": "name",
                            "valueString": "attribute1"
                        },
                        {
                            "url": "minOccurs",
                            "valueInteger": 1
                        },
                        {
                            "url": "maxOccurs",
                            "valueCode": "*"
                        }
                    ],
                    "url": "attribute"
                },
                {
                    "extension": [
                        {
                            "url": "name",
                            "valueString": "attribute2"
                        },
                        {
                            "url": "minOccurs",
                            "valueInteger": 0
                        },
                        {
                            "url": "maxOccurs",
                            "valueInteger": 1
                        }
                    ],
                    "url": "attribute"
                }
            ],
            "url": "http://example.org/do-not-use/fhir-extensions/UMLclass"
        }
    ],
    "id": "classModel",
    "resourceType": "Basic",
    "text": {
        "div": "<div>\n      \n      <p>\n        <b>Class1</b>\n      </p>\n      \n      <ul>\n        \n        <li>Attribute1: 1..*</li>\n        \n        <li>Attribute2: 0..1</li>\n      \n      </ul>\n    \n    </div>",
        "status": "generated"
    }
};

var example26: fhir.Basic = {
    "resourceType": "Basic",
    "id": "classModel",
    "text": {
        "status": "generated",
        "div": "<div>\n      \n      <p>\n        <b>Class1</b>\n      </p>\n      \n      <ul>\n        \n        <li>Attribute1: 1..*</li>\n        \n        <li>Attribute2: 0..1</li>\n      \n      </ul>\n    \n    </div>"
    },
    "extension": [
        {
            "extension": [
                {
                    "url": "name",
                    "valueString": "Class1"
                },
                {
                    "extension": [
                        {
                            "url": "name",
                            "valueString": "attribute1"
                        },
                        {
                            "url": "minOccurs",
                            "valueInteger": 1
                        },
                        {
                            "url": "maxOccurs",
                            "valueCode": "*"
                        }
                    ],
                    "url": "attribute"
                },
                {
                    "extension": [
                        {
                            "url": "name",
                            "valueString": "attribute2"
                        },
                        {
                            "url": "minOccurs",
                            "valueInteger": 0
                        },
                        {
                            "url": "maxOccurs",
                            "valueInteger": 1
                        }
                    ],
                    "url": "attribute"
                }
            ],
            "url": "http://example.org/do-not-use/fhir-extensions/UMLclass"
        }
    ],
    "code": {
        "coding": [
            {
                "system": "http://example.org/do-not-use/fhir-codes#resourceTypes",
                "code": "UMLCLASSMODEL"
            }
        ]
    }
};

var example27: fhir.Binary = {
    "content": "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",
    "contentType": "application/pdf",
    "id": "example",
    "resourceType": "Binary"
};

var example28: fhir.Binary = {
    "resourceType": "Binary",
    "id": "example",
    "contentType": "application/pdf",
    "content": "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"
};

var example29: fhir.BodySite = {
    "code": {
        "coding": [
            {
                "code": "53120007",
                "display": "Arm",
                "system": "http://snomed.info/sct"
            }
        ],
        "text": "Arm"
    },
    "description": "front of upper left arm directly below the tattoo",
    "id": "example",
    "identifier": [
        {
            "system": "http://www.acmehosp.com/bodysites",
            "use": "official",
            "value": "12345"
        }
    ],
    "image": [
        {
            "contentType": "image/png;base64",
            "data": "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",
            "title": "ARM"
        }
    ],
    "modifier": [
        {
            "coding": [
                {
                    "code": "419161000",
                    "display": "Unilateral left",
                    "system": "http://snomed.info/sct"
                }
            ],
            "text": "Left"
        },
        {
            "coding": [
                {
                    "code": "261183002",
                    "display": "Upper",
                    "system": "http://snomed.info/sct"
                }
            ],
            "text": "Upper"
        },
        {
            "coding": [
                {
                    "code": "255549009",
                    "display": "Anterior",
                    "system": "http://snomed.info/sct"
                }
            ],
            "text": "Anterior"
        }
    ],
    "patient": {
        "reference": "Patient/example"
    },
    "resourceType": "BodySite",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>identifier</b>: 12345 (OFFICIAL)\n      </p>\n      <p>\n        <b>code</b>: Arm \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '53120007' = 'Upper limb structure (body structure)', given as 'Arm'})</span>\n      </p>\n      <p>\n        <b>modifier</b>: Left \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '419161000' = 'Unilateral left (qualifier value)', given as 'Unilateral left'})</span>, Upper \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '261183002' = 'Upper (qualifier value)', given as 'Upper'})</span>, Anterior \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '255549009' = 'Anterior (qualifier value)', given as 'Anterior'})</span>\n      </p>\n      <p>\n        <b>description</b>: front of upper left arm directly below the tattoo\n      </p>\n      <p>\n        <b>image</b>: \n      </p>\n    </div>",
        "status": "generated"
    }
};

var example30: fhir.BodySite = {
    "resourceType": "BodySite",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>identifier</b>: 12345 (OFFICIAL)\n      </p>\n      <p>\n        <b>code</b>: Arm \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '53120007' = 'Upper limb structure (body structure)', given as 'Arm'})</span>\n      </p>\n      <p>\n        <b>modifier</b>: Left \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '419161000' = 'Unilateral left (qualifier value)', given as 'Unilateral left'})</span>, Upper \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '261183002' = 'Upper (qualifier value)', given as 'Upper'})</span>, Anterior \n        <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '255549009' = 'Anterior (qualifier value)', given as 'Anterior'})</span>\n      </p>\n      <p>\n        <b>description</b>: front of upper left arm directly below the tattoo\n      </p>\n      <p>\n        <b>image</b>: \n      </p>\n    </div>"
    },
    "patient": {
        "reference": "Patient/example"
    },
    "identifier": [
        {
            "use": "official",
            "system": "http://www.acmehosp.com/bodysites",
            "value": "12345"
        }
    ],
    "code": {
        "coding": [
            {
                "system": "http://snomed.info/sct",
                "code": "53120007",
                "display": "Arm"
            }
        ],
        "text": "Arm"
    },
    "modifier": [
        {
            "coding": [
                {
                    "system": "http://snomed.info/sct",
                    "code": "419161000",
                    "display": "Unilateral left"
                }
            ],
            "text": "Left"
        },
        {
            "coding": [
                {
                    "system": "http://snomed.info/sct",
                    "code": "261183002",
                    "display": "Upper"
                }
            ],
            "text": "Upper"
        },
        {
            "coding": [
                {
                    "system": "http://snomed.info/sct",
                    "code": "255549009",
                    "display": "Anterior"
                }
            ],
            "text": "Anterior"
        }
    ],
    "description": "front of upper left arm directly below the tattoo",
    "image": [
        {
            "contentType": "image/png;base64",
            "data": "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",
            "title": "ARM"
        }
    ]
};

var example31: fhir.Bundle = {
    "base": "http://example.com/base",
    "entry": [
        {
            "resource": {
                "id": "3123",
                "medication": {
                    "reference": "Medication/example"
                },
                "patient": {
                    "reference": "Patient/347"
                },
                "resourceType": "MedicationPrescription",
                "text": {
                    "div": "<div>\n            <p>\n              <b>Generated Narrative with Details</b>\n            </p>\n            <p>\n              <b>patient</b>: \n              <a href=\"Patient/347\">Patient/347</a>\n            </p>\n            <p>\n              <b>medication</b>: \n              <a href=\"Medication/example\">Medication/example</a>\n            </p>\n          </div>",
                    "status": "generated"
                }
            },
            "search": {
                "mode": "match",
                "score": 1
            }
        },
        {
            "resource": {
                "id": "example",
                "resourceType": "Medication",
                "text": {
                    "div": "<div>\n            <p>\n              <b>Generated Narrative with Details</b>\n            </p>\n          </div>",
                    "status": "generated"
                }
            },
            "search": {
                "mode": "include"
            }
        }
    ],
    "id": "bundle-example",
    "link": [
        {
            "relation": "self",
            "url": "https://example.com/base/MedicationPrescription?patient=347&_include=MedicationPrescription.medication"
        },
        {
            "relation": "next",
            "url": "https://example.com/base/MedicationPrescription?patient=347&searchId=ff15fd40-ff71-4b48-b366-09c706bed9d0&page=2"
        }
    ],
    "meta": {
        "lastUpdated": "2014-08-18T01:43:30Z"
    },
    "resourceType": "Bundle",
    "total": 3,
    "type": "searchset"
};

var example32: fhir.Bundle = {
    "resourceType": "Bundle",
    "id": "bundle-example",
    "meta": {
        "lastUpdated": "2014-08-18T01:43:30Z"
    },
    "type": "searchset",
    "base": "http://example.com/base",
    "total": 3,
    "link": [
        {
            "relation": "self",
            "url": "https://example.com/base/MedicationPrescription?patient=347&_include=MedicationPrescription.medication"
        },
        {
            "relation": "next",
            "url": "https://example.com/base/MedicationPrescription?patient=347&searchId=ff15fd40-ff71-4b48-b366-09c706bed9d0&page=2"
        }
    ],
    "entry": [
        {
            "resource": {
                "resourceType": "MedicationPrescription",
                "id": "3123",
                "text": {
                    "status": "generated",
                    "div": "<div>\n            <p>\n              <b>Generated Narrative with Details</b>\n            </p>\n            <p>\n              <b>patient</b>: \n              <a href=\"Patient/347\">Patient/347</a>\n            </p>\n            <p>\n              <b>medication</b>: \n              <a href=\"Medication/example\">Medication/example</a>\n            </p>\n          </div>"
                },
                "patient": {
                    "reference": "Patient/347"
                },
                "medication": {
                    "reference": "Medication/example"
                }
            },
            "search": {
                "mode": "match",
                "score": 1
            }
        },
        {
            "resource": {
                "resourceType": "Medication",
                "id": "example",
                "text": {
                    "status": "generated",
                    "div": "<div>\n            <p>\n              <b>Generated Narrative with Details</b>\n            </p>\n          </div>"
                }
            },
            "search": {
                "mode": "include"
            }
        }
    ]
};

var example33: fhir.CarePlan = {
    "activity": [
        {
            "actionResulting": [
                {
                    "reference": "Encounter/example"
                }
            ],
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "code": "nursecon",
                            "system": "http://example.org/local"
                        }
                    ],
                    "text": "Nurse Consultation"
                },
                "performer": [
                    {
                        "display": "Nurse Nancy",
                        "reference": "Practitioner/13"
                    }
                ],
                "prohibited": false,
                "scheduledPeriod": {
                    "end": "2013-01-01T10:50:00+00:00",
                    "start": "2013-01-01T10:38:00+00:00"
                },
                "status": "completed"
            }
        },
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "code": "doccon",
                            "system": "http://example.org/local"
                        }
                    ],
                    "text": "Doctor Consultation"
                },
                "performer": [
                    {
                        "display": "Doctor Dave",
                        "reference": "Practitioner/14"
                    }
                ],
                "prohibited": false,
                "status": "scheduled"
            }
        }
    ],
    "concern": [
        {
            "display": "obesity",
            "reference": "#p1"
        }
    ],
    "contained": [
        {
            "clinicalStatus": "confirmed",
            "code": {
                "text": "Overseas encounter"
            },
            "id": "p1",
            "patient": {
                "display": "Peter James Chalmers",
                "reference": "Patient/100"
            },
            "resourceType": "Condition"
        },
        {
            "description": "Complete consultation",
            "id": "goal",
            "patient": {
                "display": "Peter James Chalmers",
                "reference": "Patient/100"
            },
            "resourceType": "Goal",
            "status": "planned"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "gpvisit",
    "participant": [
        {
            "id": "part1",
            "member": {
                "display": "Nurse Nancy",
                "reference": "Practitioner/13"
            },
            "role": {
                "coding": [
                    {
                        "code": "nur",
                        "system": "http://example.org/local"
                    }
                ],
                "text": "nurse"
            }
        },
        {
            "id": "part2",
            "member": {
                "display": "Doctor Dave",
                "reference": "Practitioner/14"
            },
            "role": {
                "coding": [
                    {
                        "code": "doc",
                        "system": "http://example.org/local"
                    }
                ],
                "text": "doctor"
            }
        }
    ],
    "patient": {
        "display": "Peter James Chalmers",
        "reference": "Patient/100"
    },
    "period": {
        "start": "2013-01-01T10:30:00+00:00"
    },
    "resourceType": "CarePlan",
    "status": "active",
    "text": {
        "div": "<div>\n      \n      <p>  Represents the flow of a patient within a practice. The plan is created when\n        they arrive and represents the 'care' of the patient over the course of that encounter.\n        They first see the nurse for basic observations (BP, pulse, temp) then the doctor for\n        the consultation and finally the nurse again for a tetanus immunization. As the plan is\n        updated (e.g. a new activity added), different versions of the plan exist, and workflow timings\n        for reporting can be gained by examining the plan history. This example is the version after\n        seeing the doctor, and waiting for the nurse.The plan can either be created 'ad hoc' and modified as\n        the parient progresses, or start with a standard template (which can, of course, be altered to suit the patient.</p>\n    \n    </div>",
        "status": "additional"
    }
};

var example34: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "gpvisit",
    "text": {
        "status": "additional",
        "div": "<div>\n      \n      <p>  Represents the flow of a patient within a practice. The plan is created when\n        they arrive and represents the 'care' of the patient over the course of that encounter.\n        They first see the nurse for basic observations (BP, pulse, temp) then the doctor for\n        the consultation and finally the nurse again for a tetanus immunization. As the plan is\n        updated (e.g. a new activity added), different versions of the plan exist, and workflow timings\n        for reporting can be gained by examining the plan history. This example is the version after\n        seeing the doctor, and waiting for the nurse.The plan can either be created 'ad hoc' and modified as\n        the parient progresses, or start with a standard template (which can, of course, be altered to suit the patient.</p>\n    \n    </div>"
    },
    "contained": [
        {
            "resourceType": "Condition",
            "id": "p1",
            "patient": {
                "reference": "Patient/100",
                "display": "Peter James Chalmers"
            },
            "code": {
                "text": "Overseas encounter"
            },
            "clinicalStatus": "confirmed"
        },
        {
            "resourceType": "Goal",
            "id": "goal",
            "patient": {
                "reference": "Patient/100",
                "display": "Peter James Chalmers"
            },
            "description": "Complete consultation",
            "status": "planned"
        }
    ],
    "patient": {
        "reference": "Patient/100",
        "display": "Peter James Chalmers"
    },
    "status": "active",
    "period": {
        "start": "2013-01-01T10:30:00+00:00"
    },
    "concern": [
        {
            "reference": "#p1",
            "display": "obesity"
        }
    ],
    "participant": [
        {
            "id": "part1",
            "role": {
                "coding": [
                    {
                        "system": "http://example.org/local",
                        "code": "nur"
                    }
                ],
                "text": "nurse"
            },
            "member": {
                "reference": "Practitioner/13",
                "display": "Nurse Nancy"
            }
        },
        {
            "id": "part2",
            "role": {
                "coding": [
                    {
                        "system": "http://example.org/local",
                        "code": "doc"
                    }
                ],
                "text": "doctor"
            },
            "member": {
                "reference": "Practitioner/14",
                "display": "Doctor Dave"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "actionResulting": [
                {
                    "reference": "Encounter/example"
                }
            ],
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "system": "http://example.org/local",
                            "code": "nursecon"
                        }
                    ],
                    "text": "Nurse Consultation"
                },
                "status": "completed",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2013-01-01T10:38:00+00:00",
                    "end": "2013-01-01T10:50:00+00:00"
                },
                "performer": [
                    {
                        "reference": "Practitioner/13",
                        "display": "Nurse Nancy"
                    }
                ]
            }
        },
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "system": "http://example.org/local",
                            "code": "doccon"
                        }
                    ],
                    "text": "Doctor Consultation"
                },
                "status": "scheduled",
                "prohibited": false,
                "performer": [
                    {
                        "reference": "Practitioner/14",
                        "display": "Doctor Dave"
                    }
                ]
            }
        }
    ]
};

var example35: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "code": "64915003",
                            "display": "Operation on heart",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "performer": [
                    {
                        "display": "P. Voigt",
                        "reference": "Practitioner/f002"
                    }
                ],
                "prohibited": true,
                "scheduledString": "2011-06-27T09:30:10+01:00",
                "status": "completed"
            }
        }
    ],
    "concern": [
        {
            "display": "?????",
            "reference": "Condition/f201"
        }
    ],
    "contained": [
        {
            "description": "recovery surgery on heart of patient",
            "id": "goal",
            "notes": "goal accomplished without complications",
            "resourceType": "Goal",
            "status": "achieved"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "f001",
    "identifier": [
        {
            "system": "http://www.bmc.nl/zorgportal/identifiers/careplans",
            "use": "official",
            "value": "CP2903"
        }
    ],
    "modified": "2011-06-27T09:30:10+01:00",
    "participant": [
        {
            "member": {
                "display": "P. Voigt",
                "reference": "Practitioner/f002"
            }
        }
    ],
    "patient": {
        "display": "P. van de Heuvel",
        "reference": "Patient/f001"
    },
    "period": {
        "end": "2011-06-27",
        "start": "2011-06-26"
    },
    "resourceType": "CarePlan",
    "status": "completed",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>identifier</b>: CP2903 (OFFICIAL)\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f001\">P. van de Heuvel. Generated Summary: 738472983 (USUAL), ?? (USUAL); Pieter van de Heuvel ; ph: 0648352638(MOBILE), p.heuvel@gmail.com(HOME); MALE; birthDate: Nov 17, 1944; \n          <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>; multipleBirth; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Jun 26, 2011 --&gt; Jun 27, 2011\n      </p>\n      <p>\n        <b>modified</b>: Jun 27, 2011 6:30:10 PM\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f201\">?????. Generated Summary: ????; dateAsserted: Apr 4, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>; onset: Apr 2, 2013\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <a href=\"Practitioner/f002\">P. Voigt. Generated Summary: 730291637 (OFFICIAL), 174BIP3JH438 (USUAL); Pieter Voigt (OFFICIAL); ph: 0205569336(WORK), p.voigt@bmc.nl(WORK), fax: 0205669382(WORK); MALE; birthDate: Apr 29, 1979</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: recovery surgery on heart of patient; ACHIEVED; notes: goal accomplished without complications\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Operation on heart \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '64915003' = 'Operation on heart', given as 'Operation on heart'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>true</td>\n            <td>2011-06-27T09:30:10+01:00</td>\n            <td> </td>\n            <td>\n              <a href=\"Practitioner/f002\">P. Voigt. Generated Summary: 730291637 (OFFICIAL), 174BIP3JH438 (USUAL); Pieter Voigt (OFFICIAL); ph: 0205569336(WORK), p.voigt@bmc.nl(WORK), fax: 0205669382(WORK); MALE; birthDate: Apr 29, 1979</a>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example36: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "f001",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>identifier</b>: CP2903 (OFFICIAL)\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f001\">P. van de Heuvel. Generated Summary: 738472983 (USUAL), ?? (USUAL); Pieter van de Heuvel ; ph: 0648352638(MOBILE), p.heuvel@gmail.com(HOME); MALE; birthDate: Nov 17, 1944; \n          <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>; multipleBirth; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Jun 26, 2011 --&gt; Jun 27, 2011\n      </p>\n      <p>\n        <b>modified</b>: Jun 27, 2011 6:30:10 PM\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f201\">?????. Generated Summary: ????; dateAsserted: Apr 4, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>; onset: Apr 2, 2013\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <a href=\"Practitioner/f002\">P. Voigt. Generated Summary: 730291637 (OFFICIAL), 174BIP3JH438 (USUAL); Pieter Voigt (OFFICIAL); ph: 0205569336(WORK), p.voigt@bmc.nl(WORK), fax: 0205669382(WORK); MALE; birthDate: Apr 29, 1979</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: recovery surgery on heart of patient; ACHIEVED; notes: goal accomplished without complications\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Operation on heart \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '64915003' = 'Operation on heart', given as 'Operation on heart'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>true</td>\n            <td>2011-06-27T09:30:10+01:00</td>\n            <td> </td>\n            <td>\n              <a href=\"Practitioner/f002\">P. Voigt. Generated Summary: 730291637 (OFFICIAL), 174BIP3JH438 (USUAL); Pieter Voigt (OFFICIAL); ph: 0205569336(WORK), p.voigt@bmc.nl(WORK), fax: 0205669382(WORK); MALE; birthDate: Apr 29, 1979</a>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>"
    },
    "contained": [
        {
            "resourceType": "Goal",
            "id": "goal",
            "description": "recovery surgery on heart of patient",
            "status": "achieved",
            "notes": "goal accomplished without complications"
        }
    ],
    "identifier": [
        {
            "use": "official",
            "system": "http://www.bmc.nl/zorgportal/identifiers/careplans",
            "value": "CP2903"
        }
    ],
    "patient": {
        "reference": "Patient/f001",
        "display": "P. van de Heuvel"
    },
    "status": "completed",
    "period": {
        "start": "2011-06-26",
        "end": "2011-06-27"
    },
    "modified": "2011-06-27T09:30:10+01:00",
    "concern": [
        {
            "reference": "Condition/f201",
            "display": "?????"
        }
    ],
    "participant": [
        {
            "member": {
                "reference": "Practitioner/f002",
                "display": "P. Voigt"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "64915003",
                            "display": "Operation on heart"
                        }
                    ]
                },
                "status": "completed",
                "prohibited": true,
                "scheduledString": "2011-06-27T09:30:10+01:00",
                "performer": [
                    {
                        "reference": "Practitioner/f002",
                        "display": "P. Voigt"
                    }
                ]
            }
        }
    ]
};

var example37: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "code": "359615001",
                            "display": "Partial lobectomy of lung",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "performer": [
                    {
                        "display": "M.I.M. Versteegh",
                        "reference": "Practitioner/f003"
                    }
                ],
                "prohibited": true,
                "scheduledString": "2011-07-07T09:30:10+01:00",
                "status": "completed"
            }
        }
    ],
    "concern": [
        {
            "display": "?????",
            "reference": "Condition/f201"
        }
    ],
    "contained": [
        {
            "description": "succesful surgery on lung of patient",
            "id": "goal",
            "notes": "goal accomplished with minor complications",
            "resourceType": "Goal",
            "status": "achieved"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "f002",
    "identifier": [
        {
            "system": "http://www.bmc.nl/zorgportal/identifiers/careplans",
            "use": "official",
            "value": "CP2934"
        }
    ],
    "modified": "2011-07-07T09:30:10+01:00",
    "participant": [
        {
            "member": {
                "display": "M.I.M. Versteegh",
                "reference": "Practitioner/f003"
            }
        }
    ],
    "patient": {
        "display": "P. van de Heuvel",
        "reference": "Patient/f001"
    },
    "period": {
        "end": "2013-07-07",
        "start": "2011-07-06"
    },
    "resourceType": "CarePlan",
    "status": "completed",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>identifier</b>: CP2934 (OFFICIAL)\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f001\">P. van de Heuvel. Generated Summary: 738472983 (USUAL), ?? (USUAL); Pieter van de Heuvel ; ph: 0648352638(MOBILE), p.heuvel@gmail.com(HOME); MALE; birthDate: Nov 17, 1944; \n          <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>; multipleBirth; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Jul 6, 2011 --&gt; Jul 7, 2013\n      </p>\n      <p>\n        <b>modified</b>: Jul 7, 2011 6:30:10 PM\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f201\">?????. Generated Summary: ????; dateAsserted: Apr 4, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>; onset: Apr 2, 2013\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <a href=\"Practitioner/f003\">M.I.M. Versteegh. Generated Summary: 846100293 (OFFICIAL), 243HID3RT938 (USUAL); Marc Versteegh (OFFICIAL); ph: 0205562431(WORK), m.versteegh@bmc.nl(WORK), fax: 0205662948(WORK); MALE; birthDate: Jul 1, 1963; \n              <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 nl}\">Dutch</span>\n            </a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: succesful surgery on lung of patient; ACHIEVED; notes: goal accomplished with minor complications\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Partial lobectomy of lung \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '359615001' = 'Partial lobectomy of lung', given as 'Partial lobectomy of lung'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>true</td>\n            <td>2011-07-07T09:30:10+01:00</td>\n            <td> </td>\n            <td>\n              <a href=\"Practitioner/f003\">M.I.M. Versteegh. Generated Summary: 846100293 (OFFICIAL), 243HID3RT938 (USUAL); Marc Versteegh (OFFICIAL); ph: 0205562431(WORK), m.versteegh@bmc.nl(WORK), fax: 0205662948(WORK); MALE; birthDate: Jul 1, 1963; \n                <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 nl}\">Dutch</span>\n              </a>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example38: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "f002",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>identifier</b>: CP2934 (OFFICIAL)\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f001\">P. van de Heuvel. Generated Summary: 738472983 (USUAL), ?? (USUAL); Pieter van de Heuvel ; ph: 0648352638(MOBILE), p.heuvel@gmail.com(HOME); MALE; birthDate: Nov 17, 1944; \n          <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>; multipleBirth; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Jul 6, 2011 --&gt; Jul 7, 2013\n      </p>\n      <p>\n        <b>modified</b>: Jul 7, 2011 6:30:10 PM\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f201\">?????. Generated Summary: ????; dateAsserted: Apr 4, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>; onset: Apr 2, 2013\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <a href=\"Practitioner/f003\">M.I.M. Versteegh. Generated Summary: 846100293 (OFFICIAL), 243HID3RT938 (USUAL); Marc Versteegh (OFFICIAL); ph: 0205562431(WORK), m.versteegh@bmc.nl(WORK), fax: 0205662948(WORK); MALE; birthDate: Jul 1, 1963; \n              <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 nl}\">Dutch</span>\n            </a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: succesful surgery on lung of patient; ACHIEVED; notes: goal accomplished with minor complications\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Partial lobectomy of lung \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '359615001' = 'Partial lobectomy of lung', given as 'Partial lobectomy of lung'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>true</td>\n            <td>2011-07-07T09:30:10+01:00</td>\n            <td> </td>\n            <td>\n              <a href=\"Practitioner/f003\">M.I.M. Versteegh. Generated Summary: 846100293 (OFFICIAL), 243HID3RT938 (USUAL); Marc Versteegh (OFFICIAL); ph: 0205562431(WORK), m.versteegh@bmc.nl(WORK), fax: 0205662948(WORK); MALE; birthDate: Jul 1, 1963; \n                <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 nl}\">Dutch</span>\n              </a>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>"
    },
    "contained": [
        {
            "resourceType": "Goal",
            "id": "goal",
            "description": "succesful surgery on lung of patient",
            "status": "achieved",
            "notes": "goal accomplished with minor complications"
        }
    ],
    "identifier": [
        {
            "use": "official",
            "system": "http://www.bmc.nl/zorgportal/identifiers/careplans",
            "value": "CP2934"
        }
    ],
    "patient": {
        "reference": "Patient/f001",
        "display": "P. van de Heuvel"
    },
    "status": "completed",
    "period": {
        "start": "2011-07-06",
        "end": "2013-07-07"
    },
    "modified": "2011-07-07T09:30:10+01:00",
    "concern": [
        {
            "reference": "Condition/f201",
            "display": "?????"
        }
    ],
    "participant": [
        {
            "member": {
                "reference": "Practitioner/f003",
                "display": "M.I.M. Versteegh"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "359615001",
                            "display": "Partial lobectomy of lung"
                        }
                    ]
                },
                "status": "completed",
                "prohibited": true,
                "scheduledString": "2011-07-07T09:30:10+01:00",
                "performer": [
                    {
                        "reference": "Practitioner/f003",
                        "display": "M.I.M. Versteegh"
                    }
                ]
            }
        }
    ]
};

var example39: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "code": "172960003",
                            "display": "Incision of retropharyngeal abscess",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "performer": [
                    {
                        "display": "E.M. van den broek",
                        "reference": "Practitioner/f001"
                    }
                ],
                "prohibited": true,
                "scheduledString": "2011-06-27T09:30:10+01:00",
                "status": "completed"
            }
        }
    ],
    "concern": [
        {
            "display": "?????",
            "reference": "Condition/f201"
        }
    ],
    "contained": [
        {
            "description": "Retropharyngeal abscess removal",
            "id": "goal",
            "notes": "goal accomplished without complications",
            "patient": {
                "display": "P. van de Heuvel",
                "reference": "Patient/f001"
            },
            "resourceType": "Goal",
            "status": "achieved"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "f003",
    "identifier": [
        {
            "system": "http://www.bmc.nl/zorgportal/identifiers/careplans",
            "use": "official",
            "value": "CP3953"
        }
    ],
    "modified": "2013-06-27T09:30:10+01:00",
    "participant": [
        {
            "member": {
                "display": "E.M. van den broek",
                "reference": "Practitioner/f001"
            }
        }
    ],
    "patient": {
        "display": "P. van de Heuvel",
        "reference": "Patient/f001"
    },
    "period": {
        "end": "2013-03-08T09:30:10+01:00",
        "start": "2013-03-08T09:00:10+01:00"
    },
    "resourceType": "CarePlan",
    "status": "completed",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>identifier</b>: CP3953 (OFFICIAL)\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f001\">P. van de Heuvel. Generated Summary: 738472983 (USUAL), ?? (USUAL); Pieter van de Heuvel ; ph: 0648352638(MOBILE), p.heuvel@gmail.com(HOME); MALE; birthDate: Nov 17, 1944; \n          <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>; multipleBirth; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Mar 8, 2013 7:00:10 PM --&gt; Mar 8, 2013 7:30:10 PM\n      </p>\n      <p>\n        <b>modified</b>: Jun 27, 2013 6:30:10 PM\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f201\">?????. Generated Summary: ????; dateAsserted: Apr 4, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>; onset: Apr 2, 2013\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <a href=\"Practitioner/f001\">E.M. van den broek. Generated Summary: 938273695 (OFFICIAL), 129IDH4OP733 (USUAL); Eric van den broek (OFFICIAL); ph: 0205568263(WORK), E.M.vandenbroek@bmc.nl(WORK), fax: 0205664440(WORK); MALE; birthDate: Dec 7, 1975</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: Retropharyngeal abscess removal; ACHIEVED; notes: goal accomplished without complications\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Incision of retropharyngeal abscess \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '172960003' = 'Incision of retropharyngeal abscess', given as 'Incision of retropharyngeal abscess'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>true</td>\n            <td>2011-06-27T09:30:10+01:00</td>\n            <td> </td>\n            <td>\n              <a href=\"Practitioner/f001\">E.M. van den broek. Generated Summary: 938273695 (OFFICIAL), 129IDH4OP733 (USUAL); Eric van den broek (OFFICIAL); ph: 0205568263(WORK), E.M.vandenbroek@bmc.nl(WORK), fax: 0205664440(WORK); MALE; birthDate: Dec 7, 1975</a>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example40: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "f003",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>identifier</b>: CP3953 (OFFICIAL)\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f001\">P. van de Heuvel. Generated Summary: 738472983 (USUAL), ?? (USUAL); Pieter van de Heuvel ; ph: 0648352638(MOBILE), p.heuvel@gmail.com(HOME); MALE; birthDate: Nov 17, 1944; \n          <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>; multipleBirth; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Mar 8, 2013 7:00:10 PM --&gt; Mar 8, 2013 7:30:10 PM\n      </p>\n      <p>\n        <b>modified</b>: Jun 27, 2013 6:30:10 PM\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f201\">?????. Generated Summary: ????; dateAsserted: Apr 4, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>; onset: Apr 2, 2013\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <a href=\"Practitioner/f001\">E.M. van den broek. Generated Summary: 938273695 (OFFICIAL), 129IDH4OP733 (USUAL); Eric van den broek (OFFICIAL); ph: 0205568263(WORK), E.M.vandenbroek@bmc.nl(WORK), fax: 0205664440(WORK); MALE; birthDate: Dec 7, 1975</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: Retropharyngeal abscess removal; ACHIEVED; notes: goal accomplished without complications\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Incision of retropharyngeal abscess \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '172960003' = 'Incision of retropharyngeal abscess', given as 'Incision of retropharyngeal abscess'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>true</td>\n            <td>2011-06-27T09:30:10+01:00</td>\n            <td> </td>\n            <td>\n              <a href=\"Practitioner/f001\">E.M. van den broek. Generated Summary: 938273695 (OFFICIAL), 129IDH4OP733 (USUAL); Eric van den broek (OFFICIAL); ph: 0205568263(WORK), E.M.vandenbroek@bmc.nl(WORK), fax: 0205664440(WORK); MALE; birthDate: Dec 7, 1975</a>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>"
    },
    "contained": [
        {
            "resourceType": "Goal",
            "id": "goal",
            "patient": {
                "reference": "Patient/f001",
                "display": "P. van de Heuvel"
            },
            "description": "Retropharyngeal abscess removal",
            "status": "achieved",
            "notes": "goal accomplished without complications"
        }
    ],
    "identifier": [
        {
            "use": "official",
            "system": "http://www.bmc.nl/zorgportal/identifiers/careplans",
            "value": "CP3953"
        }
    ],
    "patient": {
        "reference": "Patient/f001",
        "display": "P. van de Heuvel"
    },
    "status": "completed",
    "period": {
        "start": "2013-03-08T09:00:10+01:00",
        "end": "2013-03-08T09:30:10+01:00"
    },
    "modified": "2013-06-27T09:30:10+01:00",
    "concern": [
        {
            "reference": "Condition/f201",
            "display": "?????"
        }
    ],
    "participant": [
        {
            "member": {
                "reference": "Practitioner/f001",
                "display": "E.M. van den broek"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "172960003",
                            "display": "Incision of retropharyngeal abscess"
                        }
                    ]
                },
                "status": "completed",
                "prohibited": true,
                "scheduledString": "2011-06-27T09:30:10+01:00",
                "performer": [
                    {
                        "reference": "Practitioner/f001",
                        "display": "E.M. van den broek"
                    }
                ]
            }
        }
    ]
};

var example41: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "diet",
                "code": {
                    "coding": [
                        {
                            "code": "284093001",
                            "display": "Potassium supplementation",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "dailyAmount": {
                    "code": "258718000",
                    "system": "http://snomed.info/sct",
                    "units": "mmol",
                    "value": 80
                },
                "product": {
                    "display": "Potassium",
                    "reference": "Substance/f203"
                },
                "prohibited": false,
                "scheduledString": "daily",
                "status": "completed"
            }
        },
        {
            "detail": {
                "category": "observation",
                "code": {
                    "coding": [
                        {
                            "code": "306005",
                            "display": "Echography of kidney",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "prohibited": false,
                "status": "completed"
            }
        }
    ],
    "concern": [
        {
            "display": "Roel's renal insufficiency",
            "reference": "Condition/f204"
        }
    ],
    "contained": [
        {
            "description": "Re-established renal function with at least healthy nutrients.",
            "id": "goal",
            "patient": {
                "display": "Roel",
                "reference": "Patient/f201"
            },
            "resourceType": "Goal",
            "status": "achieved"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "f201",
    "modified": "2013-03-11",
    "participant": [
        {
            "member": {
                "display": "Dokter Bronsig",
                "reference": "Practitioner/f201"
            },
            "role": {
                "coding": [
                    {
                        "code": "425268008",
                        "display": "Review of care plan",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        },
        {
            "member": {
                "display": "Nurse Carla Espinosa",
                "reference": "Practitioner/f204"
            },
            "role": {
                "coding": [
                    {
                        "code": "229774002",
                        "display": "Carer",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        }
    ],
    "patient": {
        "display": "Roel",
        "reference": "Patient/f201"
    },
    "period": {
        "end": "2013-03-13",
        "start": "2013-03-11"
    },
    "resourceType": "CarePlan",
    "status": "planned",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f201\">Roel. Generated Summary: BSN = 123456789 (OFFICIAL), BSN = 123456789 (OFFICIAL); Roel(OFFICIAL); ph: +31612345678(MOBILE), ph: +31201234567(HOME); MALE; birthDate: Mar 13, 1960; \n          <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: PLANNED\n      </p>\n      <p>\n        <b>period</b>: Mar 11, 2013 --&gt; Mar 13, 2013\n      </p>\n      <p>\n        <b>modified</b>: Mar 11, 2013\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f204\">Roel's renal insufficiency. Generated Summary: ????; dateAsserted: Mar 11, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 36225005}\">Acute renal insufficiency specified as due to procedure</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; WORKING; \n          <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>; onset: Mar 11, 2013; abatement: Mar 20, 2013\n        </a>\n      </p>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Review of care plan \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '425268008' = 'Review of care plan', given as 'Review of care plan'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f201\">Dokter Bronsig. Generated Summary: UZI-nummer = 12345678901 (OFFICIAL); Dokter Bronsig(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Dec 24, 1956</a>\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Carer \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '229774002' = 'Carer', given as 'Carer'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f204\">Nurse Carla Espinosa. Generated Summary: UZI-nummer = 12345678904 (OFFICIAL); Carla Espinosa; ph: +31715262169(WORK); FEMALE; birthDate: Nov 5, 1967</a>\n        </p>\n      </blockquote>\n      <p>\n        <b>goal</b>: description: Re-established renal function with at least healthy nutrients.; ACHIEVED\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>DIET</td>\n            <td>Potassium supplementation \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '284093001' = 'Potassium supplementation', given as 'Potassium supplementation'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>false</td>\n            <td>daily</td>\n            <td> </td>\n            <td> </td>\n            <td>\n              <a href=\"Substance/f203\">Potassium. Generated Summary: \n                <span title=\"Codes: {http://snomed.info/sct 88480006}\">Potassium</span>\n              </a>\n            </td>\n            <td>80 mmol\n              <span style=\"background: LightGoldenRodYellow \"> (Details: SNOMED CT code 258718000 = 'millimole (qualifier value)')</span>\n            </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>OBSERVATION</td>\n            <td>Echography of kidney \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '306005' = 'US kidneys', given as 'Echography of kidney'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>false</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example42: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "f201",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f201\">Roel. Generated Summary: BSN = 123456789 (OFFICIAL), BSN = 123456789 (OFFICIAL); Roel(OFFICIAL); ph: +31612345678(MOBILE), ph: +31201234567(HOME); MALE; birthDate: Mar 13, 1960; \n          <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: PLANNED\n      </p>\n      <p>\n        <b>period</b>: Mar 11, 2013 --&gt; Mar 13, 2013\n      </p>\n      <p>\n        <b>modified</b>: Mar 11, 2013\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f204\">Roel's renal insufficiency. Generated Summary: ????; dateAsserted: Mar 11, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 36225005}\">Acute renal insufficiency specified as due to procedure</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>; WORKING; \n          <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>; onset: Mar 11, 2013; abatement: Mar 20, 2013\n        </a>\n      </p>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Review of care plan \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '425268008' = 'Review of care plan', given as 'Review of care plan'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f201\">Dokter Bronsig. Generated Summary: UZI-nummer = 12345678901 (OFFICIAL); Dokter Bronsig(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Dec 24, 1956</a>\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Carer \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '229774002' = 'Carer', given as 'Carer'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f204\">Nurse Carla Espinosa. Generated Summary: UZI-nummer = 12345678904 (OFFICIAL); Carla Espinosa; ph: +31715262169(WORK); FEMALE; birthDate: Nov 5, 1967</a>\n        </p>\n      </blockquote>\n      <p>\n        <b>goal</b>: description: Re-established renal function with at least healthy nutrients.; ACHIEVED\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>DIET</td>\n            <td>Potassium supplementation \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '284093001' = 'Potassium supplementation', given as 'Potassium supplementation'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>false</td>\n            <td>daily</td>\n            <td> </td>\n            <td> </td>\n            <td>\n              <a href=\"Substance/f203\">Potassium. Generated Summary: \n                <span title=\"Codes: {http://snomed.info/sct 88480006}\">Potassium</span>\n              </a>\n            </td>\n            <td>80 mmol\n              <span style=\"background: LightGoldenRodYellow \"> (Details: SNOMED CT code 258718000 = 'millimole (qualifier value)')</span>\n            </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>OBSERVATION</td>\n            <td>Echography of kidney \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '306005' = 'US kidneys', given as 'Echography of kidney'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>COMPLETED</td>\n            <td> </td>\n            <td>false</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>"
    },
    "contained": [
        {
            "resourceType": "Goal",
            "id": "goal",
            "patient": {
                "reference": "Patient/f201",
                "display": "Roel"
            },
            "description": "Re-established renal function with at least healthy nutrients.",
            "status": "achieved"
        }
    ],
    "patient": {
        "reference": "Patient/f201",
        "display": "Roel"
    },
    "status": "planned",
    "period": {
        "start": "2013-03-11",
        "end": "2013-03-13"
    },
    "modified": "2013-03-11",
    "concern": [
        {
            "reference": "Condition/f204",
            "display": "Roel's renal insufficiency"
        }
    ],
    "participant": [
        {
            "role": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "425268008",
                        "display": "Review of care plan"
                    }
                ]
            },
            "member": {
                "reference": "Practitioner/f201",
                "display": "Dokter Bronsig"
            }
        },
        {
            "role": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "229774002",
                        "display": "Carer"
                    }
                ]
            },
            "member": {
                "reference": "Practitioner/f204",
                "display": "Nurse Carla Espinosa"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "detail": {
                "category": "diet",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "284093001",
                            "display": "Potassium supplementation"
                        }
                    ]
                },
                "status": "completed",
                "prohibited": false,
                "scheduledString": "daily",
                "product": {
                    "reference": "Substance/f203",
                    "display": "Potassium"
                },
                "dailyAmount": {
                    "value": 80,
                    "units": "mmol",
                    "system": "http://snomed.info/sct",
                    "code": "258718000"
                }
            }
        },
        {
            "detail": {
                "category": "observation",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "306005",
                            "display": "Echography of kidney"
                        }
                    ]
                },
                "status": "completed",
                "prohibited": false
            }
        }
    ]
};

var example43: fhir.CarePlan = {
    "activity": [
        {
            "actionResulting": [
                {
                    "display": "Roel's Chemotherapy",
                    "reference": "Procedure/f201"
                }
            ],
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "code": "367336001",
                            "display": "Chemotherapy",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "product": {
                    "reference": "#tpf"
                },
                "prohibited": false,
                "status": "in-progress"
            }
        }
    ],
    "concern": [
        {
            "display": "Roel's head-neck tumor",
            "reference": "Condition/f202"
        }
    ],
    "contained": [
        {
            "code": {
                "coding": [
                    {
                        "code": "108806006",
                        "system": "http://snomed.info/sct"
                    }
                ]
            },
            "id": "doce",
            "name": "Docetaxel",
            "resourceType": "Medication"
        },
        {
            "code": {
                "coding": [
                    {
                        "code": "57066004",
                        "system": "http://snomed.info/sct"
                    }
                ]
            },
            "id": "cisp",
            "name": "Cisplatin",
            "resourceType": "Medication"
        },
        {
            "code": {
                "coding": [
                    {
                        "code": "3127006",
                        "system": "http://snomed.info/sct"
                    }
                ]
            },
            "id": "fluo",
            "name": "5-Fluorouracil",
            "resourceType": "Medication"
        },
        {
            "id": "tpf",
            "name": "TPF",
            "product": {
                "ingredient": [
                    {
                        "item": {
                            "reference": "#doce"
                        }
                    },
                    {
                        "item": {
                            "reference": "#cisp"
                        }
                    },
                    {
                        "item": {
                            "reference": "#fluo"
                        }
                    }
                ]
            },
            "resourceType": "Medication"
        },
        {
            "description": "Elimination of the spenoid bone tumor",
            "id": "goal",
            "patient": {
                "display": "Roel",
                "reference": "Patient/f201"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "f202",
    "participant": [
        {
            "member": {
                "display": "Dokter Bronsig",
                "reference": "Practitioner/f201"
            },
            "role": {
                "coding": [
                    {
                        "code": "28995006",
                        "display": "Treated with",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        }
    ],
    "patient": {
        "display": "Roel",
        "reference": "Patient/f201"
    },
    "resourceType": "CarePlan",
    "status": "active",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: , , , , \n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f201\">Roel. Generated Summary: BSN = 123456789 (OFFICIAL), BSN = 123456789 (OFFICIAL); Roel(OFFICIAL); ph: +31612345678(MOBILE), ph: +31201234567(HOME); MALE; birthDate: Mar 13, 1960; \n          <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: ACTIVE\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f202\">Roel's head-neck tumor. Generated Summary: dateAsserted: Dec 1, 2012; \n          <span title=\"Codes: {http://snomed.info/sct 363346000}\">Malignant neoplastic disease</span>; \n          <span title=\"Codes: {http://hl7.org/fhir/condition-category diagnose}\">diagnose</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>; 52 years\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Treated with \n            <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '28995006' = 'TW', given as 'Treated with'})</span>\n          </td>\n          <td>\n            <a href=\"Practitioner/f201\">Dokter Bronsig. Generated Summary: UZI-nummer = 12345678901 (OFFICIAL); Dokter Bronsig(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Dec 24, 1956</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: Elimination of the spenoid bone tumor; INPROGRESS\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>actionResulting</b>: \n          <a href=\"Procedure/f201\">Roel's Chemotherapy. Generated Summary: COMPLETED; \n            <span title=\"Codes: {http://snomed.info/sct 367336001}\">Chemotherapy</span>; \n            <span title=\"Codes: \">DiagnosticReport/f201</span>; performed: Jan 28, 2013 11:31:00 PM --&gt; Jan 29, 2013 12:27:00 AM; notes: Eerste neo-adjuvante TPF-kuur bij groot proces in sphenoid met intracraniale uitbreiding.\n          </a>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Chemotherapy \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '367336001' = 'Chemotherapy', given as 'Chemotherapy'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>INPROGRESS</td>\n            <td> </td>\n            <td>false</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>name: TPF</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example44: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "f202",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: , , , , \n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f201\">Roel. Generated Summary: BSN = 123456789 (OFFICIAL), BSN = 123456789 (OFFICIAL); Roel(OFFICIAL); ph: +31612345678(MOBILE), ph: +31201234567(HOME); MALE; birthDate: Mar 13, 1960; \n          <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: ACTIVE\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f202\">Roel's head-neck tumor. Generated Summary: dateAsserted: Dec 1, 2012; \n          <span title=\"Codes: {http://snomed.info/sct 363346000}\">Malignant neoplastic disease</span>; \n          <span title=\"Codes: {http://hl7.org/fhir/condition-category diagnose}\">diagnose</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>; 52 years\n        </a>\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Treated with \n            <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '28995006' = 'TW', given as 'Treated with'})</span>\n          </td>\n          <td>\n            <a href=\"Practitioner/f201\">Dokter Bronsig. Generated Summary: UZI-nummer = 12345678901 (OFFICIAL); Dokter Bronsig(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Dec 24, 1956</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>goal</b>: description: Elimination of the spenoid bone tumor; INPROGRESS\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>actionResulting</b>: \n          <a href=\"Procedure/f201\">Roel's Chemotherapy. Generated Summary: COMPLETED; \n            <span title=\"Codes: {http://snomed.info/sct 367336001}\">Chemotherapy</span>; \n            <span title=\"Codes: \">DiagnosticReport/f201</span>; performed: Jan 28, 2013 11:31:00 PM --&gt; Jan 29, 2013 12:27:00 AM; notes: Eerste neo-adjuvante TPF-kuur bij groot proces in sphenoid met intracraniale uitbreiding.\n          </a>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>PROCEDURE</td>\n            <td>Chemotherapy \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '367336001' = 'Chemotherapy', given as 'Chemotherapy'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>INPROGRESS</td>\n            <td> </td>\n            <td>false</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>name: TPF</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>"
    },
    "contained": [
        {
            "resourceType": "Medication",
            "id": "doce",
            "name": "Docetaxel",
            "code": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "108806006"
                    }
                ]
            }
        },
        {
            "resourceType": "Medication",
            "id": "cisp",
            "name": "Cisplatin",
            "code": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "57066004"
                    }
                ]
            }
        },
        {
            "resourceType": "Medication",
            "id": "fluo",
            "name": "5-Fluorouracil",
            "code": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "3127006"
                    }
                ]
            }
        },
        {
            "resourceType": "Medication",
            "id": "tpf",
            "name": "TPF",
            "product": {
                "ingredient": [
                    {
                        "item": {
                            "reference": "#doce"
                        }
                    },
                    {
                        "item": {
                            "reference": "#cisp"
                        }
                    },
                    {
                        "item": {
                            "reference": "#fluo"
                        }
                    }
                ]
            }
        },
        {
            "resourceType": "Goal",
            "id": "goal",
            "patient": {
                "reference": "Patient/f201",
                "display": "Roel"
            },
            "description": "Elimination of the spenoid bone tumor",
            "status": "in-progress"
        }
    ],
    "patient": {
        "reference": "Patient/f201",
        "display": "Roel"
    },
    "status": "active",
    "concern": [
        {
            "reference": "Condition/f202",
            "display": "Roel's head-neck tumor"
        }
    ],
    "participant": [
        {
            "role": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "28995006",
                        "display": "Treated with"
                    }
                ]
            },
            "member": {
                "reference": "Practitioner/f201",
                "display": "Dokter Bronsig"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "actionResulting": [
                {
                    "reference": "Procedure/f201",
                    "display": "Roel's Chemotherapy"
                }
            ],
            "detail": {
                "category": "procedure",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "367336001",
                            "display": "Chemotherapy"
                        }
                    ]
                },
                "status": "in-progress",
                "prohibited": false,
                "product": {
                    "reference": "#tpf"
                }
            }
        }
    ]
};

var example45: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "observation",
                "code": {
                    "coding": [
                        {
                            "code": "241541005",
                            "display": "High resolution computed tomography of lungs",
                            "system": "http://snomed.info/sct"
                        }
                    ]
                },
                "prohibited": false,
                "status": "not-started"
            }
        }
    ],
    "concern": [
        {
            "display": "Roel's sepsis",
            "reference": "Condition/f203"
        }
    ],
    "contained": [
        {
            "description": "Check whether further treatment of sepsis/pulmonary abcess is required",
            "id": "goal",
            "patient": {
                "display": "Roel",
                "reference": "Patient/f201"
            },
            "resourceType": "Goal",
            "status": "cancelled"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "f203",
    "modified": "2013-03-11",
    "participant": [
        {
            "member": {
                "display": "Dokter Bronsig",
                "reference": "Practitioner/f201"
            },
            "role": {
                "coding": [
                    {
                        "code": "425268008",
                        "display": "Review of care plan",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        },
        {
            "member": {
                "display": "Luigi Maas",
                "reference": "Practitioner/f202"
            },
            "role": {
                "coding": [
                    {
                        "code": "278110001",
                        "display": "Radiographic imaging",
                        "system": "http://snomed.info/sct"
                    }
                ]
            }
        }
    ],
    "patient": {
        "display": "Roel",
        "reference": "Patient/f201"
    },
    "period": {
        "end": "2013-04-21",
        "start": "2013-04-14"
    },
    "resourceType": "CarePlan",
    "status": "completed",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f201\">Roel. Generated Summary: BSN = 123456789 (OFFICIAL), BSN = 123456789 (OFFICIAL); Roel(OFFICIAL); ph: +31612345678(MOBILE), ph: +31201234567(HOME); MALE; birthDate: Mar 13, 1960; \n          <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Apr 14, 2013 --&gt; Apr 21, 2013\n      </p>\n      <p>\n        <b>modified</b>: Mar 11, 2013\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f203\">Roel's sepsis. Generated Summary: ????; dateAsserted: Mar 11, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 10001005}\">Bacterial sepsis</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category finding}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 371924009}\">Moderate to severe</span>; onset: Mar 8, 2013\n        </a>\n      </p>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Review of care plan \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '425268008' = 'Review of care plan', given as 'Review of care plan'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f201\">Dokter Bronsig. Generated Summary: UZI-nummer = 12345678901 (OFFICIAL); Dokter Bronsig(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Dec 24, 1956</a>\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Radiographic imaging \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '278110001' = 'Radiographic imaging', given as 'Radiographic imaging'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f202\">Luigi Maas. Generated Summary: UZI-nummer = 12345678902 (OFFICIAL), BIG-nummer = 12345678902 (OFFICIAL); Luigi Maas(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Jun 12, 1960</a>\n        </p>\n      </blockquote>\n      <p>\n        <b>goal</b>: description: Check whether further treatment of sepsis/pulmonary abcess is required; CANCELLED\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>OBSERVATION</td>\n            <td>High resolution computed tomography of lungs \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '241541005' = 'High resolution CT of lungs', given as 'High resolution computed tomography of lungs'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>NOTSTARTED</td>\n            <td> </td>\n            <td>false</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>",
        "status": "generated"
    }
};

var example46: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "f203",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>contained</b>: \n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/f201\">Roel. Generated Summary: BSN = 123456789 (OFFICIAL), BSN = 123456789 (OFFICIAL); Roel(OFFICIAL); ph: +31612345678(MOBILE), ph: +31201234567(HOME); MALE; birthDate: Mar 13, 1960; \n          <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>; active\n        </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>period</b>: Apr 14, 2013 --&gt; Apr 21, 2013\n      </p>\n      <p>\n        <b>modified</b>: Mar 11, 2013\n      </p>\n      <p>\n        <b>concern</b>: \n        <a href=\"Condition/f203\">Roel's sepsis. Generated Summary: ????; dateAsserted: Mar 11, 2013; \n          <span title=\"Codes: {http://snomed.info/sct 10001005}\">Bacterial sepsis</span>; \n          <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category finding}\">Problem</span>; CONFIRMED; \n          <span title=\"Codes: {http://snomed.info/sct 371924009}\">Moderate to severe</span>; onset: Mar 8, 2013\n        </a>\n      </p>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Review of care plan \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '425268008' = 'Review of care plan', given as 'Review of care plan'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f201\">Dokter Bronsig. Generated Summary: UZI-nummer = 12345678901 (OFFICIAL); Dokter Bronsig(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Dec 24, 1956</a>\n        </p>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>participant</b>\n        </p>\n        <p>\n          <b>role</b>: Radiographic imaging \n          <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '278110001' = 'Radiographic imaging', given as 'Radiographic imaging'})</span>\n        </p>\n        <p>\n          <b>member</b>: \n          <a href=\"Practitioner/f202\">Luigi Maas. Generated Summary: UZI-nummer = 12345678902 (OFFICIAL), BIG-nummer = 12345678902 (OFFICIAL); Luigi Maas(OFFICIAL); ph: +31715269111(WORK); MALE; birthDate: Jun 12, 1960</a>\n        </p>\n      </blockquote>\n      <p>\n        <b>goal</b>: description: Check whether further treatment of sepsis/pulmonary abcess is required; CANCELLED\n      </p>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <h3>Details</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Id</b>\n            </td>\n            <td>\n              <b>Extension</b>\n            </td>\n            <td>\n              <b>ModifierExtension</b>\n            </td>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Reason[x]</b>\n            </td>\n            <td>\n              <b>Goal</b>\n            </td>\n            <td>\n              <b>Status</b>\n            </td>\n            <td>\n              <b>StatusReason</b>\n            </td>\n            <td>\n              <b>Prohibited</b>\n            </td>\n            <td>\n              <b>Scheduled[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Note</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>OBSERVATION</td>\n            <td>High resolution computed tomography of lungs \n              <span style=\"background: LightGoldenRodYellow \">(Details : {SNOMED CT code '241541005' = 'High resolution CT of lungs', given as 'High resolution computed tomography of lungs'})</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td>NOTSTARTED</td>\n            <td> </td>\n            <td>false</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>"
    },
    "contained": [
        {
            "resourceType": "Goal",
            "id": "goal",
            "patient": {
                "reference": "Patient/f201",
                "display": "Roel"
            },
            "description": "Check whether further treatment of sepsis/pulmonary abcess is required",
            "status": "cancelled"
        }
    ],
    "patient": {
        "reference": "Patient/f201",
        "display": "Roel"
    },
    "status": "completed",
    "period": {
        "start": "2013-04-14",
        "end": "2013-04-21"
    },
    "modified": "2013-03-11",
    "concern": [
        {
            "reference": "Condition/f203",
            "display": "Roel's sepsis"
        }
    ],
    "participant": [
        {
            "role": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "425268008",
                        "display": "Review of care plan"
                    }
                ]
            },
            "member": {
                "reference": "Practitioner/f201",
                "display": "Dokter Bronsig"
            }
        },
        {
            "role": {
                "coding": [
                    {
                        "system": "http://snomed.info/sct",
                        "code": "278110001",
                        "display": "Radiographic imaging"
                    }
                ]
            },
            "member": {
                "reference": "Practitioner/f202",
                "display": "Luigi Maas"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "detail": {
                "category": "observation",
                "code": {
                    "coding": [
                        {
                            "system": "http://snomed.info/sct",
                            "code": "241541005",
                            "display": "High resolution computed tomography of lungs"
                        }
                    ]
                },
                "status": "not-started",
                "prohibited": false
            }
        }
    ]
};

var example47: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/StructureDefinition/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g1"
                    }
                ],
                "note": "Eve will review photos of high and low density foods and share with her parents",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-09-10"
                },
                "status": "not-started"
            },
            "notes": "9/10/12 Eve eats one meal a day with her parents"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g1"
                    }
                ],
                "note": "Eve will ask her dad to asist her to put the head of her bed on blocks",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-09-10"
                },
                "status": "not-started"
            },
            "notes": "9/10/12 Eve will sleep in her bed more often than the couch"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g2"
                    }
                ],
                "note": "Eve will reduce her intake of coffee and chocolate",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-09-10"
                },
                "status": "in-progress"
            }
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "note": "Eve will walk her friend's dog up and down a big hill 15-30 minutes 3 days a week",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-08-27"
                },
                "status": "in-progress"
            },
            "notes": "8/27/12 Eve would like to try for 5 days a week.  9/10/12 Eve is still walking the dogs."
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "note": "Eve will walk 3 blocks to her parents house twice a week",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "status": "in-progress"
            },
            "notes": "8/13/12 Eve walked 4 times the last week.  9/10/12 Eve did not walk to her parents the last week, but has plans to start again"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-13"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "note": "Eve will us a calendar to check off after medications are taken",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "status": "in-progress"
            }
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-27"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g5"
                    }
                ],
                "note": "Eve will use her lights MWF after her shower for 3 minutes",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "status": "in-progress"
            },
            "notes": "8/13/12 After restarting the vinegar soaks the psoriasis is improved and Eve plans to treat the remainder with light treatments.  She plans to start this week.  8/27/12 Since her skin is improved Eve has not been using the light treatment as often, maybe once a week.  She would like to increase to 3 times a week again"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "note": "Eve will use a calendar of a chart to help her remember when to take her medications",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-10"
                },
                "status": "in-progress"
            },
            "notes": "7/23/12 Eve created a chart as a reminer to take the medications that do not fit in her pill box"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-23"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "note": "Eve will start using stretch bands and one step 2 days a week Mon/Wed 6-7am and maybe Friday afternoon",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "status": "on-hold"
            },
            "notes": "7/30/12 will be able to esume exercise.  8/13/12 Eve prefers to focus on walking at this time"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-07-23"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "note": "Eve will match a printed medication worksheet with the medication bottles at home",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-10"
                },
                "status": "completed"
            }
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-07-16"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "note": "Eve will get a medication box to sort her pills.  She will have one for scheduled medications and one for as needed",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-10"
                },
                "status": "completed"
            },
            "notes": "7/16/12 Eve now has some of her medications set up in pill packs by her pharmacist"
        },
        {
            "detail": {
                "category": "other",
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-13"
                    }
                ],
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "note": "Eve will open \"The Firm\" DVD workout package and listen to it",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "status": "on-hold"
            },
            "notes": "7/30/12 Eve will be able to resume exercise on 7/30/12.  8/13/12 -hold until \"less busy\""
        }
    ],
    "concern": [
        {
            "display": "GERDS",
            "reference": "#p1"
        },
        {
            "display": "Obesity",
            "reference": "#p2"
        },
        {
            "display": "Psoriasis",
            "reference": "#p3"
        }
    ],
    "contained": [
        {
            "clinicalStatus": "confirmed",
            "code": {
                "text": "GERDS"
            },
            "id": "p1",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Condition"
        },
        {
            "clinicalStatus": "confirmed",
            "code": {
                "text": "Obesity"
            },
            "id": "p2",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Condition"
        },
        {
            "clinicalStatus": "confirmed",
            "code": {
                "text": "Psoriasis"
            },
            "id": "p3",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Condition"
        },
        {
            "description": "Eve will lose weight and reduce her GERDS symptoms by improving her diet",
            "id": "g1",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        },
        {
            "description": "Eve will improve her GERDS symptoms",
            "id": "g2",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        },
        {
            "description": "Eve will increase her energy by being more active",
            "id": "g3",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        },
        {
            "description": "Eve will set up her medications and take as prescribed",
            "id": "g4",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        },
        {
            "description": "Eve will restart her light treatments",
            "id": "g5",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        }
    ],
    "goal": [
        {
            "reference": "#g1"
        },
        {
            "reference": "#g2"
        },
        {
            "reference": "#g3"
        },
        {
            "reference": "#g4"
        },
        {
            "reference": "#g5"
        }
    ],
    "id": "integrate",
    "modified": "2012-09-10",
    "notes": "Patient family is not ready to commit to goal setting at this time.  Goal setting will be addressed in the future",
    "patient": {
        "display": "Eve Everywoman",
        "reference": "Patient/1"
    },
    "resourceType": "CarePlan",
    "status": "active",
    "text": {
        "div": "<div>\n      \n      <p>Patient family is not ready to commit to goal setting at this time.  Goal setting will be addressed in the future</p>\n      \n      <table>\n        \n        <thead>\n          \n          <tr>\n            \n            <th>Start Date</th>\n            \n            <th>Goal</th>\n            \n            <th>Action Steps</th>\n            \n            <th>Status</th>\n            \n            <th>Date Last Updated</th>\n            \n            <th>Comments</th>\n          \n          </tr>\n        \n        </thead>\n        \n        <tbody>\n          \n          <tr>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>Eve will lose weight and reduce her GERDS symptoms by improving her diet</td>\n            \n            <td>Eve will review photos of high and low density foods and share with her parents</td>\n            \n            <td>New Goal</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>9/10/12 Eve eats one meal a day with her parents</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>Eve will lose weight and reduce her GERDS symptoms by improving her diet</td>\n            \n            <td>Eve will ask her dad to asist her to put the head of her bed on blocks</td>\n            \n            <td>New Goal</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>9/10/12 Eve will sleep in her bed more often than the couch</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>Eve will improve her GERDS symptoms</td>\n            \n            <td>Eve will reduce her intake of coffee and chocolate</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td/>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>27 Aug 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will walk her friend's dog up and down a big hill 15-30 minutes 3 days a week</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>8/27/12 Eve would like to try for 5 days a week.  9/10/12 Eve is still walking the dogs.</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will walk 3 blocks to her parents house twice a week</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>8/13/12 Eve walked 4 times the last week.  9/10/12 Eve did not walk to her parents the last week, but has plans to start again</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will us a calendar to check off after medications are taken</td>\n            \n            <td>In Process</td>\n            \n            <td>13 Aug 2012</td>\n            \n            <td/>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will restart her light treatments</td>\n            \n            <td>Eve will use her lights MWF after her shower for 3 minutes</td>\n            \n            <td>In Process</td>\n            \n            <td>27 Aug 2012</td>\n            \n            <td>8/13/12 After restarting the vinegar soaks the psoriasis is improved and Eve plans to treat the remainder with light treatments.  She plans to start this week.  8/27/12 Since her skin is improved Eve has not been using the light treatment as often, maybe once a week.  She would like to increase to 3 times a week again</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will use a calendar of a chart to help her remember when to take her medications</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>7/23/12 Eve created a chart as a reminer to take the medications that do not fit in her pill box</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will start using stretch bands and one step 2 days a week Mon/Wed 6-7am and maybe Friday afternoon</td>\n            \n            <td>On-Hold</td>\n            \n            <td>23 Aug 2012</td>\n            \n            <td>7/30/12 will be able to esume exercise.  8/13/12 Eve prefers to focus on walking at this time</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will match a printed medication worksheet with the medication bottles at home</td>\n            \n            <td>Completed</td>\n            \n            <td>23 Jul 2012</td>\n            \n            <td/>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will get a medication box to sort her pills.  She will have one for scheduled medications and one for as needed</td>\n            \n            <td>Completed</td>\n            \n            <td>16 Jul 2012</td>\n            \n            <td>7/16/12 Eve now has some of her medications set up in pill packs by her pharmacist</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will open &quot;The Firm&quot; DVD workout package and listen to it</td>\n            \n            <td>Discontinued</td>\n            \n            <td>13 Aug 2012</td>\n            \n            <td>7/30/12 Eve will be able to resume exercise on 7/30/12.  8/13/12 -hold until &quot;less busy&quot;</td>\n          \n          </tr>\n        \n        </tbody>\n      \n      </table>\n    \n    </div>",
        "status": "generated"
    }
};

var example48: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "integrate",
    "text": {
        "status": "generated",
        "div": "<div>\n      \n      <p>Patient family is not ready to commit to goal setting at this time.  Goal setting will be addressed in the future</p>\n      \n      <table>\n        \n        <thead>\n          \n          <tr>\n            \n            <th>Start Date</th>\n            \n            <th>Goal</th>\n            \n            <th>Action Steps</th>\n            \n            <th>Status</th>\n            \n            <th>Date Last Updated</th>\n            \n            <th>Comments</th>\n          \n          </tr>\n        \n        </thead>\n        \n        <tbody>\n          \n          <tr>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>Eve will lose weight and reduce her GERDS symptoms by improving her diet</td>\n            \n            <td>Eve will review photos of high and low density foods and share with her parents</td>\n            \n            <td>New Goal</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>9/10/12 Eve eats one meal a day with her parents</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>Eve will lose weight and reduce her GERDS symptoms by improving her diet</td>\n            \n            <td>Eve will ask her dad to asist her to put the head of her bed on blocks</td>\n            \n            <td>New Goal</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>9/10/12 Eve will sleep in her bed more often than the couch</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>Eve will improve her GERDS symptoms</td>\n            \n            <td>Eve will reduce her intake of coffee and chocolate</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td/>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>27 Aug 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will walk her friend's dog up and down a big hill 15-30 minutes 3 days a week</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>8/27/12 Eve would like to try for 5 days a week.  9/10/12 Eve is still walking the dogs.</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will walk 3 blocks to her parents house twice a week</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>8/13/12 Eve walked 4 times the last week.  9/10/12 Eve did not walk to her parents the last week, but has plans to start again</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will us a calendar to check off after medications are taken</td>\n            \n            <td>In Process</td>\n            \n            <td>13 Aug 2012</td>\n            \n            <td/>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will restart her light treatments</td>\n            \n            <td>Eve will use her lights MWF after her shower for 3 minutes</td>\n            \n            <td>In Process</td>\n            \n            <td>27 Aug 2012</td>\n            \n            <td>8/13/12 After restarting the vinegar soaks the psoriasis is improved and Eve plans to treat the remainder with light treatments.  She plans to start this week.  8/27/12 Since her skin is improved Eve has not been using the light treatment as often, maybe once a week.  She would like to increase to 3 times a week again</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will use a calendar of a chart to help her remember when to take her medications</td>\n            \n            <td>In Process</td>\n            \n            <td>10 Sep 2012</td>\n            \n            <td>7/23/12 Eve created a chart as a reminer to take the medications that do not fit in her pill box</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will start using stretch bands and one step 2 days a week Mon/Wed 6-7am and maybe Friday afternoon</td>\n            \n            <td>On-Hold</td>\n            \n            <td>23 Aug 2012</td>\n            \n            <td>7/30/12 will be able to esume exercise.  8/13/12 Eve prefers to focus on walking at this time</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will match a printed medication worksheet with the medication bottles at home</td>\n            \n            <td>Completed</td>\n            \n            <td>23 Jul 2012</td>\n            \n            <td/>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>10 Jul 2012</td>\n            \n            <td>Eve will set up her medications and take as prescribed</td>\n            \n            <td>Eve will get a medication box to sort her pills.  She will have one for scheduled medications and one for as needed</td>\n            \n            <td>Completed</td>\n            \n            <td>16 Jul 2012</td>\n            \n            <td>7/16/12 Eve now has some of her medications set up in pill packs by her pharmacist</td>\n          \n          </tr>\n          \n          <tr>\n            \n            <td>23 Jul 2012</td>\n            \n            <td>Eve will increase her energy by being more active</td>\n            \n            <td>Eve will open &quot;The Firm&quot; DVD workout package and listen to it</td>\n            \n            <td>Discontinued</td>\n            \n            <td>13 Aug 2012</td>\n            \n            <td>7/30/12 Eve will be able to resume exercise on 7/30/12.  8/13/12 -hold until &quot;less busy&quot;</td>\n          \n          </tr>\n        \n        </tbody>\n      \n      </table>\n    \n    </div>"
    },
    "contained": [
        {
            "resourceType": "Condition",
            "id": "p1",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "code": {
                "text": "GERDS"
            },
            "clinicalStatus": "confirmed"
        },
        {
            "resourceType": "Condition",
            "id": "p2",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "code": {
                "text": "Obesity"
            },
            "clinicalStatus": "confirmed"
        },
        {
            "resourceType": "Condition",
            "id": "p3",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "code": {
                "text": "Psoriasis"
            },
            "clinicalStatus": "confirmed"
        },
        {
            "resourceType": "Goal",
            "id": "g1",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "description": "Eve will lose weight and reduce her GERDS symptoms by improving her diet",
            "status": "in-progress"
        },
        {
            "resourceType": "Goal",
            "id": "g2",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "description": "Eve will improve her GERDS symptoms",
            "status": "in-progress"
        },
        {
            "resourceType": "Goal",
            "id": "g3",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "description": "Eve will increase her energy by being more active",
            "status": "in-progress"
        },
        {
            "resourceType": "Goal",
            "id": "g4",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "description": "Eve will set up her medications and take as prescribed",
            "status": "in-progress"
        },
        {
            "resourceType": "Goal",
            "id": "g5",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "description": "Eve will restart her light treatments",
            "status": "in-progress"
        }
    ],
    "patient": {
        "reference": "Patient/1",
        "display": "Eve Everywoman"
    },
    "status": "active",
    "modified": "2012-09-10",
    "concern": [
        {
            "reference": "#p1",
            "display": "GERDS"
        },
        {
            "reference": "#p2",
            "display": "Obesity"
        },
        {
            "reference": "#p3",
            "display": "Psoriasis"
        }
    ],
    "goal": [
        {
            "reference": "#g1"
        },
        {
            "reference": "#g2"
        },
        {
            "reference": "#g3"
        },
        {
            "reference": "#g4"
        },
        {
            "reference": "#g5"
        }
    ],
    "activity": [
        {
            "notes": "9/10/12 Eve eats one meal a day with her parents",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/StructureDefinition/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g1"
                    }
                ],
                "status": "not-started",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-09-10"
                },
                "note": "Eve will review photos of high and low density foods and share with her parents"
            }
        },
        {
            "notes": "9/10/12 Eve will sleep in her bed more often than the couch",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g1"
                    }
                ],
                "status": "not-started",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-09-10"
                },
                "note": "Eve will ask her dad to asist her to put the head of her bed on blocks"
            }
        },
        {
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g2"
                    }
                ],
                "status": "in-progress",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-09-10"
                },
                "note": "Eve will reduce her intake of coffee and chocolate"
            }
        },
        {
            "notes": "8/27/12 Eve would like to try for 5 days a week.  9/10/12 Eve is still walking the dogs.",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "status": "in-progress",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-08-27"
                },
                "note": "Eve will walk her friend's dog up and down a big hill 15-30 minutes 3 days a week"
            }
        },
        {
            "notes": "8/13/12 Eve walked 4 times the last week.  9/10/12 Eve did not walk to her parents the last week, but has plans to start again",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "status": "in-progress",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "note": "Eve will walk 3 blocks to her parents house twice a week"
            }
        },
        {
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-13"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "status": "in-progress",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "note": "Eve will us a calendar to check off after medications are taken"
            }
        },
        {
            "notes": "8/13/12 After restarting the vinegar soaks the psoriasis is improved and Eve plans to treat the remainder with light treatments.  She plans to start this week.  8/27/12 Since her skin is improved Eve has not been using the light treatment as often, maybe once a week.  She would like to increase to 3 times a week again",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-27"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g5"
                    }
                ],
                "status": "in-progress",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "note": "Eve will use her lights MWF after her shower for 3 minutes"
            }
        },
        {
            "notes": "7/23/12 Eve created a chart as a reminer to take the medications that do not fit in her pill box",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-09-10"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "status": "in-progress",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-10"
                },
                "note": "Eve will use a calendar of a chart to help her remember when to take her medications"
            }
        },
        {
            "notes": "7/30/12 will be able to esume exercise.  8/13/12 Eve prefers to focus on walking at this time",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-23"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "status": "on-hold",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "note": "Eve will start using stretch bands and one step 2 days a week Mon/Wed 6-7am and maybe Friday afternoon"
            }
        },
        {
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-07-23"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "status": "completed",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-10"
                },
                "note": "Eve will match a printed medication worksheet with the medication bottles at home"
            }
        },
        {
            "notes": "7/16/12 Eve now has some of her medications set up in pill packs by her pharmacist",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-07-16"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g4"
                    }
                ],
                "status": "completed",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-10"
                },
                "note": "Eve will get a medication box to sort her pills.  She will have one for scheduled medications and one for as needed"
            }
        },
        {
            "notes": "7/30/12 Eve will be able to resume exercise on 7/30/12.  8/13/12 -hold until \"less busy\"",
            "detail": {
                "extension": [
                    {
                        "url": "http://example.org/DoNotUse/General/RevisionDate",
                        "valueDate": "2012-08-13"
                    }
                ],
                "category": "other",
                "goal": [
                    {
                        "reference": "#g3"
                    }
                ],
                "status": "on-hold",
                "prohibited": false,
                "scheduledPeriod": {
                    "start": "2012-07-23"
                },
                "note": "Eve will open \"The Firm\" DVD workout package and listen to it"
            }
        }
    ],
    "notes": "Patient family is not ready to commit to goal setting at this time.  Goal setting will be addressed in the future"
};

var example49: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "code": "1an",
                            "system": "http://example.org/mySystem"
                        }
                    ],
                    "text": "First Antenatal encounter"
                },
                "note": "The first antenatal encounter. This is where a detailed physical examination is performed.             and the pregnanacy discussed with the mother-to-be.",
                "performer": [
                    {
                        "display": "Mavis Midwife",
                        "reference": "#pr1"
                    }
                ],
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "bounds": {
                            "end": "2013-02-28",
                            "start": "2013-02-14"
                        }
                    }
                },
                "status": "scheduled"
            },
            "extension": [
                {
                    "url": "http://example.org/DoNotUse/careplan#andetails",
                    "valueUri": "http://orionhealth.com/fhir/careplan/1andetails"
                }
            ]
        },
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "code": "an",
                            "system": "http://example.org/mySystem"
                        }
                    ],
                    "text": "Follow-up Antenatal encounter"
                },
                "note": "The second antenatal encounter. Discuss any issues that arose from the first antenatal encounter",
                "performer": [
                    {
                        "display": "Mavis Midwife",
                        "reference": "#pr1"
                    }
                ],
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "bounds": {
                            "end": "2013-03-14",
                            "start": "2013-03-01"
                        }
                    }
                },
                "status": "not-started"
            }
        },
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "code": "del",
                            "system": "http://example.org/mySystem"
                        }
                    ],
                    "text": "Delivery"
                },
                "note": "The delivery.",
                "performer": [
                    {
                        "display": "Mavis Midwife",
                        "reference": "#pr1"
                    }
                ],
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "bounds": {
                            "end": "2013-09-14",
                            "start": "2013-09-01"
                        }
                    }
                },
                "status": "not-started"
            }
        }
    ],
    "concern": [
        {
            "display": "pregnancy",
            "reference": "#p1"
        }
    ],
    "contained": [
        {
            "clinicalStatus": "confirmed",
            "code": {
                "text": "pregnancy"
            },
            "id": "p1",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Condition"
        },
        {
            "id": "pr1",
            "name": {
                "family": [
                    "Midwife"
                ],
                "given": [
                    "Mavis"
                ]
            },
            "practitionerRole": [
                {
                    "specialty": [
                        {
                            "text": "Midwife"
                        }
                    ]
                }
            ],
            "resourceType": "Practitioner"
        },
        {
            "id": "pr2",
            "name": {
                "family": [
                    "Obstetrician"
                ],
                "given": [
                    "Oscar"
                ]
            },
            "practitionerRole": [
                {
                    "specialty": [
                        {
                            "text": "Obstetrician"
                        }
                    ]
                }
            ],
            "resourceType": "Practitioner"
        },
        {
            "description": "Maintain patient's health throughout pregnancy and ensure a healthy child",
            "id": "goal",
            "patient": {
                "display": "Eve Everywoman",
                "reference": "Patient/1"
            },
            "resourceType": "Goal",
            "status": "in-progress"
        }
    ],
    "extension": [
        {
            "url": "http://example.org/DoNotUse/careplan#lmp",
            "valueDateTime": "2013-01-01"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "preg",
    "participant": [
        {
            "member": {
                "display": "Mavis Midwife",
                "reference": "#pr1"
            },
            "role": {
                "coding": [
                    {
                        "code": "lmc",
                        "system": "http://example.org/mysys"
                    }
                ],
                "text": "Midwife"
            }
        },
        {
            "member": {
                "display": "Oscar Obstetrician",
                "reference": "#pr2"
            },
            "role": {
                "coding": [
                    {
                        "code": "obs",
                        "system": "http://example.org/mysys"
                    }
                ],
                "text": "Obstretitian"
            }
        }
    ],
    "patient": {
        "display": "Eve Everywoman",
        "reference": "Patient/1"
    },
    "period": {
        "end": "2013-10-01",
        "start": "2013-01-01"
    },
    "resourceType": "CarePlan",
    "status": "active",
    "text": {
        "div": "<div>\n      \n      <p>A maternity care plan (for a pregnant woman).</p>\n      \n      <p>LMP is 1st Jan, 2013 (a greaat new years party!) The plan has a scheduled first antenatal,\n            and 'placeholders' for the second antenatal and delivery (there would be lots of others of course)</p>\n      \n      <p>Note that where is a proposed 'status' element against each activity</p>\n    \n    </div>",
        "status": "additional"
    }
};

var example50: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "preg",
    "text": {
        "status": "additional",
        "div": "<div>\n      \n      <p>A maternity care plan (for a pregnant woman).</p>\n      \n      <p>LMP is 1st Jan, 2013 (a greaat new years party!) The plan has a scheduled first antenatal,\n            and 'placeholders' for the second antenatal and delivery (there would be lots of others of course)</p>\n      \n      <p>Note that where is a proposed 'status' element against each activity</p>\n    \n    </div>"
    },
    "contained": [
        {
            "resourceType": "Condition",
            "id": "p1",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "code": {
                "text": "pregnancy"
            },
            "clinicalStatus": "confirmed"
        },
        {
            "resourceType": "Practitioner",
            "id": "pr1",
            "name": {
                "family": [
                    "Midwife"
                ],
                "given": [
                    "Mavis"
                ]
            },
            "practitionerRole": [
                {
                    "specialty": [
                        {
                            "text": "Midwife"
                        }
                    ]
                }
            ]
        },
        {
            "resourceType": "Practitioner",
            "id": "pr2",
            "name": {
                "family": [
                    "Obstetrician"
                ],
                "given": [
                    "Oscar"
                ]
            },
            "practitionerRole": [
                {
                    "specialty": [
                        {
                            "text": "Obstetrician"
                        }
                    ]
                }
            ]
        },
        {
            "resourceType": "Goal",
            "id": "goal",
            "patient": {
                "reference": "Patient/1",
                "display": "Eve Everywoman"
            },
            "description": "Maintain patient's health throughout pregnancy and ensure a healthy child",
            "status": "in-progress"
        }
    ],
    "extension": [
        {
            "url": "http://example.org/DoNotUse/careplan#lmp",
            "valueDateTime": "2013-01-01"
        }
    ],
    "patient": {
        "reference": "Patient/1",
        "display": "Eve Everywoman"
    },
    "status": "active",
    "period": {
        "start": "2013-01-01",
        "end": "2013-10-01"
    },
    "concern": [
        {
            "reference": "#p1",
            "display": "pregnancy"
        }
    ],
    "participant": [
        {
            "role": {
                "coding": [
                    {
                        "system": "http://example.org/mysys",
                        "code": "lmc"
                    }
                ],
                "text": "Midwife"
            },
            "member": {
                "reference": "#pr1",
                "display": "Mavis Midwife"
            }
        },
        {
            "role": {
                "coding": [
                    {
                        "system": "http://example.org/mysys",
                        "code": "obs"
                    }
                ],
                "text": "Obstretitian"
            },
            "member": {
                "reference": "#pr2",
                "display": "Oscar Obstetrician"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "extension": [
                {
                    "url": "http://example.org/DoNotUse/careplan#andetails",
                    "valueUri": "http://orionhealth.com/fhir/careplan/1andetails"
                }
            ],
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "system": "http://example.org/mySystem",
                            "code": "1an"
                        }
                    ],
                    "text": "First Antenatal encounter"
                },
                "status": "scheduled",
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "bounds": {
                            "start": "2013-02-14",
                            "end": "2013-02-28"
                        }
                    }
                },
                "performer": [
                    {
                        "reference": "#pr1",
                        "display": "Mavis Midwife"
                    }
                ],
                "note": "The first antenatal encounter. This is where a detailed physical examination is performed.             and the pregnanacy discussed with the mother-to-be."
            }
        },
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "system": "http://example.org/mySystem",
                            "code": "an"
                        }
                    ],
                    "text": "Follow-up Antenatal encounter"
                },
                "status": "not-started",
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "bounds": {
                            "start": "2013-03-01",
                            "end": "2013-03-14"
                        }
                    }
                },
                "performer": [
                    {
                        "reference": "#pr1",
                        "display": "Mavis Midwife"
                    }
                ],
                "note": "The second antenatal encounter. Discuss any issues that arose from the first antenatal encounter"
            }
        },
        {
            "detail": {
                "category": "encounter",
                "code": {
                    "coding": [
                        {
                            "system": "http://example.org/mySystem",
                            "code": "del"
                        }
                    ],
                    "text": "Delivery"
                },
                "status": "not-started",
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "bounds": {
                            "start": "2013-09-01",
                            "end": "2013-09-14"
                        }
                    }
                },
                "performer": [
                    {
                        "reference": "#pr1",
                        "display": "Mavis Midwife"
                    }
                ],
                "note": "The delivery."
            }
        }
    ]
};

var example51: fhir.CarePlan = {
    "activity": [
        {
            "detail": {
                "category": "observation",
                "code": {
                    "text": "a code for weight measurement"
                },
                "performer": [
                    {
                        "display": "Peter James Chalmers",
                        "reference": "Patient/example"
                    }
                ],
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "frequency": 1,
                        "period": 1,
                        "periodUnits": "d"
                    }
                }
            }
        }
    ],
    "concern": [
        {
            "display": "obesity",
            "reference": "#p1"
        }
    ],
    "contained": [
        {
            "clinicalStatus": "confirmed",
            "code": {
                "text": "Obesity"
            },
            "id": "p1",
            "patient": {
                "display": "Peter James Chalmers",
                "reference": "Patient/example"
            },
            "resourceType": "Condition"
        },
        {
            "id": "pr1",
            "name": {
                "family": [
                    "Dietician"
                ],
                "given": [
                    "Dorothy"
                ]
            },
            "practitionerRole": [
                {
                    "specialty": [
                        {
                            "text": "Dietician"
                        }
                    ]
                }
            ],
            "resourceType": "Practitioner"
        },
        {
            "description": "Target weight is 80 kg",
            "extension": [
                {
                    "extension": [
                        {
                            "url": "goal-target.measure",
                            "valueCodeableConcept": {
                                "coding": [
                                    {
                                        "code": "29463-7",
                                        "display": "Body weight",
                                        "system": "http://loinc.org"
                                    }
                                ]
                            }
                        },
                        {
                            "url": "goal-target.detail",
                            "valueQuantity": {
                                "code": "kg",
                                "system": "http://units-of-measure.org",
                                "value": 80
                            }
                        }
                    ],
                    "url": "http://hl7.org/fhir/StructureDefinition/goal-target"
                }
            ],
            "id": "goal",
            "patient": {
                "display": "Peter James Chalmers",
                "reference": "Patient/example"
            },
            "resourceType": "Goal",
            "status": "planned"
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "id": "example",
    "participant": [
        {
            "member": {
                "display": "Peter James Chalmers",
                "reference": "Patient/example"
            },
            "role": {
                "text": "responsiblePerson"
            }
        },
        {
            "member": {
                "display": "Dorothy Dietition",
                "reference": "#pr1"
            },
            "role": {
                "text": "adviser"
            }
        }
    ],
    "patient": {
        "display": "Peter James Chalmers",
        "reference": "Patient/example"
    },
    "period": {
        "end": "2013-01-01"
    },
    "resourceType": "CarePlan",
    "status": "active",
    "text": {
        "div": "<div>\n      \n      <p> A simple care plan to indicate a patient taking their weight once a day because of obesity.\n            Some Notes: </p>\n      \n      <ul>\n        \n        <li>It would be good to have some way of specifying/coding a goal. e.g. what the target weight is</li>\n        \n        <li>In the codeable concepts I've been lazy and just put the text. There should, of course, be a code behind these</li>\n      \n      </ul>\n    \n    </div>",
        "status": "additional"
    }
};

var example52: fhir.CarePlan = {
    "resourceType": "CarePlan",
    "id": "example",
    "text": {
        "status": "additional",
        "div": "<div>\n      \n      <p> A simple care plan to indicate a patient taking their weight once a day because of obesity.\n            Some Notes: </p>\n      \n      <ul>\n        \n        <li>It would be good to have some way of specifying/coding a goal. e.g. what the target weight is</li>\n        \n        <li>In the codeable concepts I've been lazy and just put the text. There should, of course, be a code behind these</li>\n      \n      </ul>\n    \n    </div>"
    },
    "contained": [
        {
            "resourceType": "Condition",
            "id": "p1",
            "patient": {
                "reference": "Patient/example",
                "display": "Peter James Chalmers"
            },
            "code": {
                "text": "Obesity"
            },
            "clinicalStatus": "confirmed"
        },
        {
            "resourceType": "Practitioner",
            "id": "pr1",
            "name": {
                "family": [
                    "Dietician"
                ],
                "given": [
                    "Dorothy"
                ]
            },
            "practitionerRole": [
                {
                    "specialty": [
                        {
                            "text": "Dietician"
                        }
                    ]
                }
            ]
        },
        {
            "resourceType": "Goal",
            "id": "goal",
            "extension": [
                {
                    "extension": [
                        {
                            "url": "goal-target.measure",
                            "valueCodeableConcept": {
                                "coding": [
                                    {
                                        "system": "http://loinc.org",
                                        "code": "29463-7",
                                        "display": "Body weight"
                                    }
                                ]
                            }
                        },
                        {
                            "url": "goal-target.detail",
                            "valueQuantity": {
                                "value": 80,
                                "system": "http://units-of-measure.org",
                                "code": "kg"
                            }
                        }
                    ],
                    "url": "http://hl7.org/fhir/StructureDefinition/goal-target"
                }
            ],
            "patient": {
                "reference": "Patient/example",
                "display": "Peter James Chalmers"
            },
            "description": "Target weight is 80 kg",
            "status": "planned"
        }
    ],
    "patient": {
        "reference": "Patient/example",
        "display": "Peter James Chalmers"
    },
    "status": "active",
    "period": {
        "end": "2013-01-01"
    },
    "concern": [
        {
            "reference": "#p1",
            "display": "obesity"
        }
    ],
    "participant": [
        {
            "role": {
                "text": "responsiblePerson"
            },
            "member": {
                "reference": "Patient/example",
                "display": "Peter James Chalmers"
            }
        },
        {
            "role": {
                "text": "adviser"
            },
            "member": {
                "reference": "#pr1",
                "display": "Dorothy Dietition"
            }
        }
    ],
    "goal": [
        {
            "reference": "#goal"
        }
    ],
    "activity": [
        {
            "detail": {
                "category": "observation",
                "code": {
                    "text": "a code for weight measurement"
                },
                "prohibited": false,
                "scheduledTiming": {
                    "repeat": {
                        "frequency": 1,
                        "period": 1,
                        "periodUnits": "d"
                    }
                },
                "performer": [
                    {
                        "reference": "Patient/example",
                        "display": "Peter James Chalmers"
                    }
                ]
            }
        }
    ]
};

var example53: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "654456"
            },
            "sequence": 1
        }
    ],
    "id": "960150",
    "identifier": [
        {
            "system": "http://happyhospital.com/claim",
            "value": "9612345"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 125
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "exam",
                "system": "http://hl7.org/fhir/ex-serviceproduct"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 125
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Claim</div>",
        "status": "generated"
    },
    "type": "institutional",
    "use": "complete"
};

var example54: fhir.Claim = {
    "resourceType": "Claim",
    "id": "960150",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Claim</div>"
    },
    "type": "institutional",
    "identifier": [
        {
            "system": "http://happyhospital.com/claim",
            "value": "9612345"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "654456"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/ex-serviceproduct",
                "code": "exam"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 125,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 125,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        }
    ]
};

var example55: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "123456"
            },
            "sequence": 1
        }
    ],
    "id": "100151",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12346"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 135.57
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "1200",
                "system": "http://hl7.org/fhir/oralservicecodes"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 135.57
            }
        },
        {
            "bodySite": {
                "code": "21",
                "system": "http://fdi.org/fhir/oraltoothcodes"
            },
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 105
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 2,
            "service": {
                "code": "21211",
                "system": "http://hl7.org/fhir/oralservicecodes"
            },
            "serviceDate": "2014-08-16",
            "subSite": [
                {
                    "code": "L",
                    "system": "http://fdi.org/fhir/oralsurfacecodes"
                }
            ],
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 105
            }
        },
        {
            "bodySite": {
                "code": "36",
                "system": "http://fdi.org/fhir/oraltoothcodes"
            },
            "detail": [
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 750
                    },
                    "sequence": 1,
                    "service": {
                        "code": "27211",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 750
                    }
                },
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 350
                    },
                    "sequence": 2,
                    "service": {
                        "code": "lab",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 350
                    }
                }
            ],
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 1100
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 3,
            "service": {
                "code": "27211",
                "system": "http://hl7.org/fhir/oralservicecodes"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "group"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 1100
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>",
        "status": "generated"
    },
    "type": "oral",
    "use": "complete"
};

var example56: fhir.Claim = {
    "resourceType": "Claim",
    "id": "100151",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>"
    },
    "type": "oral",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12346"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "123456"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/oralservicecodes",
                "code": "1200"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 135.57,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 135.57,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        },
        {
            "sequence": 2,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/oralservicecodes",
                "code": "21211"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 105,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 105,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "bodySite": {
                "system": "http://fdi.org/fhir/oraltoothcodes",
                "code": "21"
            },
            "subSite": [
                {
                    "system": "http://fdi.org/fhir/oralsurfacecodes",
                    "code": "L"
                }
            ]
        },
        {
            "sequence": 3,
            "type": {
                "code": "group"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/oralservicecodes",
                "code": "27211"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 1100,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 1100,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "bodySite": {
                "system": "http://fdi.org/fhir/oraltoothcodes",
                "code": "36"
            },
            "detail": [
                {
                    "sequence": 1,
                    "type": {
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "27211"
                    },
                    "unitPrice": {
                        "value": 750,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 750,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 2,
                    "type": {
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "lab"
                    },
                    "unitPrice": {
                        "value": 350,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 350,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                }
            ]
        }
    ]
};

var example57: fhir.Claim = {
    "contained": [
        {
            "id": "organization-1",
            "identifier": [
                {
                    "system": "http://www.jurisdiction.com/oralhealthoffices",
                    "value": "3456"
                }
            ],
            "resourceType": "Organization"
        },
        {
            "id": "organization-2",
            "identifier": [
                {
                    "system": "http://www.bindb.com/bin",
                    "value": "123456"
                }
            ],
            "resourceType": "Organization"
        },
        {
            "id": "practitioner-1",
            "identifier": [
                {
                    "system": "http://www.jurisdiction.com/oralhealthproviders",
                    "value": "123456789"
                }
            ],
            "resourceType": "Practitioner"
        },
        {
            "address": [
                {
                    "city": "Vancouver",
                    "country": "CAD",
                    "line": [
                        "1234 Main Street"
                    ],
                    "postalCode": "V2H1Y3",
                    "use": "home"
                }
            ],
            "birthDate": "1986-05-17",
            "gender": "male",
            "id": "patient-1",
            "name": [
                {
                    "family": [
                        "Donald"
                    ],
                    "given": [
                        "Duck"
                    ],
                    "use": "official"
                }
            ],
            "resourceType": "Patient"
        },
        {
            "dependent": 1,
            "id": "coverage-1",
            "identifier": [
                {
                    "system": "http://benefitsinc.com/certificate",
                    "value": "12345"
                }
            ],
            "issuer": {
                "reference": "#organization-2"
            },
            "plan": "CBI35",
            "resourceType": "Coverage",
            "sequence": 1,
            "subPlan": "123",
            "subscriber": {
                "reference": "#patient-1"
            },
            "type": {
                "code": "EHCPOL",
                "system": "http://hl7.org/fhir/v3/ActCode"
            }
        }
    ],
    "coverage": [
        {
            "coverage": {
                "reference": "#coverage-1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "123456"
            },
            "sequence": 1
        }
    ],
    "id": "100152",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12347"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 135.57
            },
            "provider": {
                "reference": "#practitioner-1"
            },
            "sequence": 1,
            "service": {
                "code": "1200"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 135.57
            }
        }
    ],
    "organization": {
        "reference": "#organization-1"
    },
    "patient": {
        "reference": "#patient-1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "#organization-2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>",
        "status": "generated"
    },
    "type": "oral",
    "use": "complete"
};

var example58: fhir.Claim = {
    "resourceType": "Claim",
    "id": "100152",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>"
    },
    "contained": [
        {
            "resourceType": "Organization",
            "id": "organization-1",
            "identifier": [
                {
                    "system": "http://www.jurisdiction.com/oralhealthoffices",
                    "value": "3456"
                }
            ]
        },
        {
            "resourceType": "Organization",
            "id": "organization-2",
            "identifier": [
                {
                    "system": "http://www.bindb.com/bin",
                    "value": "123456"
                }
            ]
        },
        {
            "resourceType": "Practitioner",
            "id": "practitioner-1",
            "identifier": [
                {
                    "system": "http://www.jurisdiction.com/oralhealthproviders",
                    "value": "123456789"
                }
            ]
        },
        {
            "resourceType": "Patient",
            "id": "patient-1",
            "name": [
                {
                    "use": "official",
                    "family": [
                        "Donald"
                    ],
                    "given": [
                        "Duck"
                    ]
                }
            ],
            "gender": "male",
            "birthDate": "1986-05-17",
            "address": [
                {
                    "use": "home",
                    "line": [
                        "1234 Main Street"
                    ],
                    "city": "Vancouver",
                    "postalCode": "V2H1Y3",
                    "country": "CAD"
                }
            ]
        },
        {
            "resourceType": "Coverage",
            "id": "coverage-1",
            "issuer": {
                "reference": "#organization-2"
            },
            "type": {
                "system": "http://hl7.org/fhir/v3/ActCode",
                "code": "EHCPOL"
            },
            "identifier": [
                {
                    "system": "http://benefitsinc.com/certificate",
                    "value": "12345"
                }
            ],
            "plan": "CBI35",
            "subPlan": "123",
            "dependent": 1,
            "sequence": 1,
            "subscriber": {
                "reference": "#patient-1"
            }
        }
    ],
    "type": "oral",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12347"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "#organization-2"
    },
    "organization": {
        "reference": "#organization-1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "123456"
            }
        }
    ],
    "patient": {
        "reference": "#patient-1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "#coverage-1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "#practitioner-1"
            },
            "service": {
                "code": "1200"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 135.57,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 135.57,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        }
    ]
};

var example59: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2015-03-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "123457",
                "system": "http://hl7.org/fhir/icd-10"
            },
            "sequence": 1
        }
    ],
    "id": "100153",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12355"
        }
    ],
    "item": [
        {
            "detail": [
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 1000
                    },
                    "sequence": 1,
                    "service": {
                        "code": "ORTHOEXAM",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service",
                        "system": "http://hl7.org/fhir/actinvoicegroupcode"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 1000
                    }
                },
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 1500
                    },
                    "sequence": 2,
                    "service": {
                        "code": "ORTHODIAG",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service",
                        "system": "http://hl7.org/fhir/actinvoicegroupcode"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 1500
                    }
                },
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 500
                    },
                    "sequence": 3,
                    "service": {
                        "code": "ORTHOINITIAL",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service",
                        "system": "http://hl7.org/fhir/actinvoicegroupcode"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 500
                    }
                },
                {
                    "quantity": {
                        "value": 24
                    },
                    "sequence": 4,
                    "service": {
                        "code": "ORTHOMONTHS",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service",
                        "system": "http://hl7.org/fhir/actinvoicegroupcode"
                    }
                },
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 250
                    },
                    "quantity": {
                        "value": 24
                    },
                    "sequence": 5,
                    "service": {
                        "code": "ORTHOPERIODIC",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service",
                        "system": "http://hl7.org/fhir/actinvoicegroupcode"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 250
                    }
                }
            ],
            "diagnosisLinkId": [
                1
            ],
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 9000
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "ORTHPLAN",
                "system": "http://hl7.org/fhir/oralservicecodes"
            },
            "serviceDate": "2015-05-16",
            "type": {
                "code": "group",
                "system": "http://hl7.org/fhir/actinvoicegroupcode"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 9000
            }
        },
        {
            "bodySite": {
                "code": "21",
                "system": "http://fdi.org/fhir/oraltoothcodes"
            },
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 105
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 2,
            "service": {
                "code": "21211",
                "system": "http://hl7.org/fhir/oralservicecodes"
            },
            "serviceDate": "2014-08-16",
            "subSite": [
                {
                    "code": "L",
                    "system": "http://fdi.org/fhir/oralsurfacecodes"
                }
            ],
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 105
            }
        },
        {
            "bodySite": {
                "code": "36",
                "system": "http://fdi.org/fhir/oraltoothcodes"
            },
            "detail": [
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 750
                    },
                    "sequence": 1,
                    "service": {
                        "code": "27211",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 750
                    }
                },
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 350
                    },
                    "sequence": 2,
                    "service": {
                        "code": "lab",
                        "system": "http://hl7.org/fhir/oralservicecodes"
                    },
                    "type": {
                        "code": "service"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 350
                    }
                }
            ],
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 1100
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 3,
            "service": {
                "code": "27211",
                "system": "http://hl7.org/fhir/oralservicecodes"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "group"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 1100
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>",
        "status": "generated"
    },
    "type": "oral",
    "use": "proposed"
};

var example60: fhir.Claim = {
    "resourceType": "Claim",
    "id": "100153",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>"
    },
    "type": "oral",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12355"
        }
    ],
    "created": "2015-03-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "proposed",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "system": "http://hl7.org/fhir/icd-10",
                "code": "123457"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "system": "http://hl7.org/fhir/actinvoicegroupcode",
                "code": "group"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "diagnosisLinkId": [
                1
            ],
            "service": {
                "system": "http://hl7.org/fhir/oralservicecodes",
                "code": "ORTHPLAN"
            },
            "serviceDate": "2015-05-16",
            "unitPrice": {
                "value": 9000,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 9000,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "detail": [
                {
                    "sequence": 1,
                    "type": {
                        "system": "http://hl7.org/fhir/actinvoicegroupcode",
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "ORTHOEXAM"
                    },
                    "unitPrice": {
                        "value": 1000,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 1000,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 2,
                    "type": {
                        "system": "http://hl7.org/fhir/actinvoicegroupcode",
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "ORTHODIAG"
                    },
                    "unitPrice": {
                        "value": 1500,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 1500,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 3,
                    "type": {
                        "system": "http://hl7.org/fhir/actinvoicegroupcode",
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "ORTHOINITIAL"
                    },
                    "unitPrice": {
                        "value": 500,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 500,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 4,
                    "type": {
                        "system": "http://hl7.org/fhir/actinvoicegroupcode",
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "ORTHOMONTHS"
                    },
                    "quantity": {
                        "value": 24
                    }
                },
                {
                    "sequence": 5,
                    "type": {
                        "system": "http://hl7.org/fhir/actinvoicegroupcode",
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "ORTHOPERIODIC"
                    },
                    "quantity": {
                        "value": 24
                    },
                    "unitPrice": {
                        "value": 250,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 250,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                }
            ]
        },
        {
            "sequence": 2,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/oralservicecodes",
                "code": "21211"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 105,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 105,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "bodySite": {
                "system": "http://fdi.org/fhir/oraltoothcodes",
                "code": "21"
            },
            "subSite": [
                {
                    "system": "http://fdi.org/fhir/oralsurfacecodes",
                    "code": "L"
                }
            ]
        },
        {
            "sequence": 3,
            "type": {
                "code": "group"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/oralservicecodes",
                "code": "27211"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 1100,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 1100,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "bodySite": {
                "system": "http://fdi.org/fhir/oraltoothcodes",
                "code": "36"
            },
            "detail": [
                {
                    "sequence": 1,
                    "type": {
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "27211"
                    },
                    "unitPrice": {
                        "value": 750,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 750,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 2,
                    "type": {
                        "code": "service"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/oralservicecodes",
                        "code": "lab"
                    },
                    "unitPrice": {
                        "value": 350,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 350,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                }
            ]
        }
    ]
};

var example61: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "654456"
            },
            "sequence": 1
        }
    ],
    "id": "760150",
    "identifier": [
        {
            "system": "http://happypharma.com/claim",
            "value": "7612345"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 60
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "smokecess",
                "system": "http://hl7.org/fhir/ex-pharmaservice"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 60
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "stat"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Pharmacy Claim</div>",
        "status": "generated"
    },
    "type": "pharmacy",
    "use": "complete"
};

var example62: fhir.Claim = {
    "resourceType": "Claim",
    "id": "760150",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Pharmacy Claim</div>"
    },
    "type": "pharmacy",
    "identifier": [
        {
            "system": "http://happypharma.com/claim",
            "value": "7612345"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "stat"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "654456"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/ex-pharmaservice",
                "code": "smokecess"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 60,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 60,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        }
    ]
};

var example63: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "654456"
            },
            "sequence": 1
        }
    ],
    "id": "860150",
    "identifier": [
        {
            "system": "http://happypdocs.com/claim",
            "value": "8612345"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 75
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "exam",
                "system": "http://hl7.org/fhir/ex-serviceproduct"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 75
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Claim</div>",
        "status": "generated"
    },
    "type": "professional",
    "use": "complete"
};

var example64: fhir.Claim = {
    "resourceType": "Claim",
    "id": "860150",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Claim</div>"
    },
    "type": "professional",
    "identifier": [
        {
            "system": "http://happypdocs.com/claim",
            "value": "8612345"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "654456"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/ex-serviceproduct",
                "code": "exam"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 75,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 75,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        }
    ]
};

var example65: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "654321"
            },
            "sequence": 1
        }
    ],
    "id": "660151",
    "identifier": [
        {
            "system": "http://happysight.com/claim",
            "value": "6612346"
        }
    ],
    "item": [
        {
            "detail": [
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 100
                    },
                    "sequence": 1,
                    "service": {
                        "code": "frame",
                        "system": "http://hl7.org/fhir/ex-visionservice"
                    },
                    "type": {
                        "code": "product"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 100
                    }
                },
                {
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 100
                    },
                    "quantity": {
                        "value": 2
                    },
                    "sequence": 2,
                    "service": {
                        "code": "lens",
                        "system": "http://hl7.org/fhir/ex-visionservice"
                    },
                    "type": {
                        "code": "product"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 50
                    }
                },
                {
                    "factor": 0.07,
                    "net": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 14
                    },
                    "sequence": 3,
                    "service": {
                        "code": "fst",
                        "system": "http://hl7.org/fhir/ex-visionservice"
                    },
                    "type": {
                        "code": "tax"
                    },
                    "unitPrice": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 200
                    }
                }
            ],
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 214
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "glasses",
                "system": "http://hl7.org/fhir/ex-visionservice"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "group"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 214
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "prescription": {
        "reference": "http://www.optdocs.com/prescription/12345"
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Vision Claim for Glasses</div>",
        "status": "generated"
    },
    "type": "vision",
    "use": "complete"
};

var example66: fhir.Claim = {
    "resourceType": "Claim",
    "id": "660151",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Vision Claim for Glasses</div>"
    },
    "type": "vision",
    "identifier": [
        {
            "system": "http://happysight.com/claim",
            "value": "6612346"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "prescription": {
        "reference": "http://www.optdocs.com/prescription/12345"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "654321"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "group"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/ex-visionservice",
                "code": "glasses"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 214,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 214,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "detail": [
                {
                    "sequence": 1,
                    "type": {
                        "code": "product"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/ex-visionservice",
                        "code": "frame"
                    },
                    "unitPrice": {
                        "value": 100,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 100,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 2,
                    "type": {
                        "code": "product"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/ex-visionservice",
                        "code": "lens"
                    },
                    "quantity": {
                        "value": 2
                    },
                    "unitPrice": {
                        "value": 50,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "net": {
                        "value": 100,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "sequence": 3,
                    "type": {
                        "code": "tax"
                    },
                    "service": {
                        "system": "http://hl7.org/fhir/ex-visionservice",
                        "code": "fst"
                    },
                    "unitPrice": {
                        "value": 200,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    },
                    "factor": 0.07,
                    "net": {
                        "value": 14,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                }
            ]
        }
    ]
};

var example67: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "654321"
            },
            "sequence": 1
        }
    ],
    "id": "660150",
    "identifier": [
        {
            "system": "http://happysight.com/claim",
            "value": "6612345"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 80
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "exam",
                "system": "http://hl7.org/fhir/ex-visionservice"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 80
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Vision Claim</div>",
        "status": "generated"
    },
    "type": "vision",
    "use": "complete"
};

var example68: fhir.Claim = {
    "resourceType": "Claim",
    "id": "660150",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Vision Claim</div>"
    },
    "type": "vision",
    "identifier": [
        {
            "system": "http://happysight.com/claim",
            "value": "6612345"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "654321"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "system": "http://hl7.org/fhir/ex-visionservice",
                "code": "exam"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 80,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 80,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        }
    ]
};

var example69: fhir.Claim = {
    "coverage": [
        {
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "focal": true,
            "relationship": {
                "code": "self"
            },
            "sequence": 1
        }
    ],
    "created": "2014-08-16",
    "diagnosis": [
        {
            "diagnosis": {
                "code": "123456"
            },
            "sequence": 1
        }
    ],
    "id": "100150",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12345"
        }
    ],
    "item": [
        {
            "net": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 135.57
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "sequence": 1,
            "service": {
                "code": "1200"
            },
            "serviceDate": "2014-08-16",
            "type": {
                "code": "service"
            },
            "unitPrice": {
                "code": "USD",
                "system": "urn:std:iso:4217",
                "value": 135.57
            }
        }
    ],
    "organization": {
        "reference": "Organization/1"
    },
    "patient": {
        "reference": "Patient/1"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "priority": {
        "code": "normal"
    },
    "resourceType": "Claim",
    "target": {
        "reference": "Organization/2"
    },
    "text": {
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>",
        "status": "generated"
    },
    "type": "oral",
    "use": "complete"
};

var example70: fhir.Claim = {
    "resourceType": "Claim",
    "id": "100150",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the Oral Health Claim</div>"
    },
    "type": "oral",
    "identifier": [
        {
            "system": "http://happyvalley.com/claim",
            "value": "12345"
        }
    ],
    "created": "2014-08-16",
    "target": {
        "reference": "Organization/2"
    },
    "organization": {
        "reference": "Organization/1"
    },
    "use": "complete",
    "priority": {
        "code": "normal"
    },
    "payee": {
        "type": {
            "code": "provider"
        }
    },
    "diagnosis": [
        {
            "sequence": 1,
            "diagnosis": {
                "code": "123456"
            }
        }
    ],
    "patient": {
        "reference": "Patient/1"
    },
    "coverage": [
        {
            "sequence": 1,
            "focal": true,
            "coverage": {
                "reference": "Coverage/9876B1"
            },
            "relationship": {
                "code": "self"
            }
        }
    ],
    "item": [
        {
            "sequence": 1,
            "type": {
                "code": "service"
            },
            "provider": {
                "reference": "Practitioner/1"
            },
            "service": {
                "code": "1200"
            },
            "serviceDate": "2014-08-16",
            "unitPrice": {
                "value": 135.57,
                "system": "urn:std:iso:4217",
                "code": "USD"
            },
            "net": {
                "value": 135.57,
                "system": "urn:std:iso:4217",
                "code": "USD"
            }
        }
    ]
};

var example71: fhir.ClaimResponse = {
    "created": "2014-08-16",
    "disposition": "Claim settled as per contract.",
    "id": "R3500",
    "identifier": [
        {
            "system": "http://www.BenefitsInc.com/fhir/remittance",
            "value": "R3500"
        }
    ],
    "item": [
        {
            "adjudication": [
                {
                    "amount": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 135.57
                    },
                    "code": {
                        "code": "eligible"
                    }
                },
                {
                    "amount": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 10
                    },
                    "code": {
                        "code": "copay"
                    }
                },
                {
                    "code": {
                        "code": "eligpercent"
                    },
                    "value": 80
                },
                {
                    "amount": {
                        "code": "USD",
                        "system": "urn:std:iso:4217",
                        "value": 100.47
                    },
                    "code": {
                        "code": "benefit"
                    }
                }
            ],
            "sequenceLinkId": 1
        }
    ],
    "organization": {
        "reference": "Organization/2"
    },
    "outcome": "complete",
    "payeeType": {
        "code": "provider",
        "system": "http://hl7.org/fhir/payeetype"
    },
    "paymentAmount": {
        "code": "USD",
        "system": "urn:std:iso:4217",
        "value": 100.47
    },
    "paymentDate": "2014-08-31",
    "paymentRef": {
        "system": "http://www.BenefitsInc.com/fhir/paymentRef",
        "value": "201408-2-1569478"
    },
    "request": {
        "reference": "http://www.BenefitsInc.com/fhir/oralhealthclaim/15476332402"
    },
    "requestOrganization": {
        "reference": "Organization/1"
    },
    "resourceType": "ClaimResponse",
    "text": {
        "div": "<div>A human-readable rendering of the ClaimResponse</div>",
        "status": "generated"
    },
    "totalBenefit": {
        "code": "USD",
        "system": "urn:std:iso:4217",
        "value": 100.47
    },
    "totalCost": {
        "code": "USD",
        "system": "urn:std:iso:4217",
        "value": 135.57
    }
};

var example72: fhir.ClaimResponse = {
    "resourceType": "ClaimResponse",
    "id": "R3500",
    "text": {
        "status": "generated",
        "div": "<div>A human-readable rendering of the ClaimResponse</div>"
    },
    "identifier": [
        {
            "system": "http://www.BenefitsInc.com/fhir/remittance",
            "value": "R3500"
        }
    ],
    "request": {
        "reference": "http://www.BenefitsInc.com/fhir/oralhealthclaim/15476332402"
    },
    "created": "2014-08-16",
    "organization": {
        "reference": "Organization/2"
    },
    "requestOrganization": {
        "reference": "Organization/1"
    },
    "outcome": "complete",
    "disposition": "Claim settled as per contract.",
    "payeeType": {
        "system": "http://hl7.org/fhir/payeetype",
        "code": "provider"
    },
    "item": [
        {
            "sequenceLinkId": 1,
            "adjudication": [
                {
                    "code": {
                        "code": "eligible"
                    },
                    "amount": {
                        "value": 135.57,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "code": {
                        "code": "copay"
                    },
                    "amount": {
                        "value": 10,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                },
                {
                    "code": {
                        "code": "eligpercent"
                    },
                    "value": 80
                },
                {
                    "code": {
                        "code": "benefit"
                    },
                    "amount": {
                        "value": 100.47,
                        "system": "urn:std:iso:4217",
                        "code": "USD"
                    }
                }
            ]
        }
    ],
    "totalCost": {
        "value": 135.57,
        "system": "urn:std:iso:4217",
        "code": "USD"
    },
    "totalBenefit": {
        "value": 100.47,
        "system": "urn:std:iso:4217",
        "code": "USD"
    },
    "paymentDate": "2014-08-31",
    "paymentAmount": {
        "value": 100.47,
        "system": "urn:std:iso:4217",
        "code": "USD"
    },
    "paymentRef": {
        "system": "http://www.BenefitsInc.com/fhir/paymentRef",
        "value": "201408-2-1569478"
    }
};

var example73: fhir.ClinicalImpression = {
    "assessor": {
        "reference": "Practitioner/example"
    },
    "date": "2014-12-06T22:33:00+11:00",
    "description": "This 26 yo male patient is brought into ER by ambulance after being involved in a motor vehicle accident",
    "finding": [
        {
            "item": {
                "coding": [
                    {
                        "code": "850.0",
                        "system": "http://hl7.org/fhir/sid/icd-9"
                    }
                ]
            }
        }
    ],
    "id": "example",
    "investigations": [
        {
            "code": {
                "text": "Initial Examination"
            },
            "item": [
                {
                    "display": "deep laceration of the scalp (left temporo-occipital)"
                },
                {
                    "display": "decreased level of consciousness"
                },
                {
                    "display": "disoriented to time and place"
                },
                {
                    "display": "restless"
                }
            ]
        }
    ],
    "patient": {
        "reference": "Patient/example"
    },
    "plan": [
        {
            "display": "hospital standard closed head injury management protocol "
        }
    ],
    "problem": [
        {
            "display": "MVA"
        }
    ],
    "resourceType": "ClinicalImpression",
    "status": "completed",
    "summary": "provisional diagnoses of laceration of head and traumatic brain injury (TBI)",
    "text": {
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>assessor</b>: \n        <a href=\"Practitioner/example\">Generated Summary: 23; Adam Careful </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>date</b>: Dec 6, 2014 10:33:00 PM\n      </p>\n      <p>\n        <b>description</b>: This 26 yo male patient is brought into ER by ambulance after being involved in a motor vehicle accident\n      </p>\n      <p>\n        <b>problem</b>: MVA\n      </p>\n      <h3>Investigations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Item</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Initial Examination \n            <span style=\"background: LightGoldenRodYellow \">(Details )</span>\n          </td>\n          <td>deep laceration of the scalp (left temporo-occipital)</td>\n        </tr>\n      </table>\n      <p>\n        <b>summary</b>: provisional diagnoses of laceration of head and traumatic brain injury (TBI)\n      </p>\n      <h3>Findings</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Item</b>\n          </td>\n          <td>\n            <b>Cause</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>850.0 \n            <span style=\"background: LightGoldenRodYellow \">(Details : {ICD-9 code '850.0' = '850.0)</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <p>\n        <b>plan</b>: hospital standard closed head injury management protocol \n      </p>\n    </div>",
        "status": "generated"
    }
};

var example74: fhir.ClinicalImpression = {
    "resourceType": "ClinicalImpression",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>\n      <p>\n        <b>Generated Narrative with Details</b>\n      </p>\n      <p>\n        <b>patient</b>: \n        <a href=\"Patient/example\">Generated Summary: Extensions: todo; MRN = 12345 (USUAL); Peter James Chalmers (OFFICIAL), Jim ; -unknown-(HOME), ph: (03) 5555 6473(WORK); MALE; birthDate: Dec 25, 1974; active</a>\n      </p>\n      <p>\n        <b>assessor</b>: \n        <a href=\"Practitioner/example\">Generated Summary: 23; Adam Careful </a>\n      </p>\n      <p>\n        <b>status</b>: COMPLETED\n      </p>\n      <p>\n        <b>date</b>: Dec 6, 2014 10:33:00 PM\n      </p>\n      <p>\n        <b>description</b>: This 26 yo male patient is brought into ER by ambulance after being involved in a motor vehicle accident\n      </p>\n      <p>\n        <b>problem</b>: MVA\n      </p>\n      <h3>Investigations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Item</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>Initial Examination \n            <span style=\"background: LightGoldenRodYellow \">(Details )</span>\n          </td>\n          <td>deep laceration of the scalp (left temporo-occipital)</td>\n        </tr>\n      </table>\n      <p>\n        <b>summary</b>: provisional diagnoses of laceration of head and traumatic brain injury (TBI)\n      </p>\n      <h3>Findings</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Id</b>\n          </td>\n          <td>\n            <b>Extension</b>\n          </td>\n          <td>\n            <b>ModifierExtension</b>\n          </td>\n          <td>\n            <b>Item</b>\n          </td>\n          <td>\n            <b>Cause</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>850.0 \n            <span style=\"background: LightGoldenRodYellow \">(Details : {ICD-9 code '850.0' = '850.0)</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <p>\n        <b>plan</b>: hospital standard closed head injury management protocol \n      </p>\n    </div>"
    },
    "patient": {
        "reference": "Patient/example"
    },
    "assessor": {
        "reference": "Practitioner/example"
    },
    "status": "completed",
    "date": "2014-12-06T22:33:00+11:00",
    "description": "This 26 yo male patient is brought into ER by ambulance after being involved in a motor vehicle accident",
    "problem": [
        {
            "display": "MVA"
        }
    ],
    "investigations": [
        {
            "code": {
                "text": "Initial Examination"
            },
            "item": [
                {
                    "display": "deep laceration of the scalp (left temporo-occipital)"
                },
                {
                    "display": "decreased level of consciousness"
                },
                {
                    "display": "disoriented to time and place"
                },
                {
                    "display": "restless"
                }
            ]
        }
    ],
    "summary": "provisional diagnoses of laceration of head and traumatic brain injury (TBI)",
    "finding": [
        {
            "item": {
                "coding": [
                    {
                        "system": "http://hl7.org/fhir/sid/icd-9",
                        "code": "850.0"
                    }
                ]
            }
        }
    ],
    "plan": [
        {
            "display": "hospital standard closed head injury management protocol "
        }
    ]
};

var example75: fhir.Communication = {
    "category": {
        "coding": [
            {
                "code": "Alert",
                "system": "http://acme.org/messagetypes"
            }
        ],
        "text": "Alert"
    },
    "id": "example",
    "identifier": [
        {
            "system": "urn:oid:1.3.4.5.6.7",
            "type": {
                "text": "Paging System"
            },
            "value": "2345678901"
        }
    ],
    "payload": [
        {
            "contentString": "Patient 1 has a very high serum potassium value (7.2 mmol/L on 2014-Dec-12 at 5:55 pm)"
        },
        {
            "contentReference": {
                "reference": "Observation/643666aa12f"
            }
        }
    ],
    "recipient": [
        {
            "reference": "Practitioner/21"
        }
    ],
    "resourceType": "Communication",
    "sender": {
        "reference": "Device/1234"
    },
    "sent": "2014-12-12T18:01:10-08:00",
    "status": "completed",
    "subject": {
        "reference": "Patient/1"
    },
    "text": {
        "div": "<div>Patient has very high serum potassium</div>",
        "status": "generated"
    }
};

var example76: fhir.Communication = {
    "resourceType": "Communication",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>Patient has very high serum potassium</div>"
    },
    "identifier": [
        {
            "type": {
                "text": "Paging System"
            },
            "system": "urn:oid:1.3.4.5.6.7",
            "value": "2345678901"
        }
    ],
    "category": {
        "coding": [
            {
                "system": "http://acme.org/messagetypes",
                "code": "Alert"
            }
        ],
        "text": "Alert"
    },
    "sender": {
        "reference": "Device/1234"
    },
    "recipient": [
        {
            "reference": "Practitioner/21"
        }
    ],
    "payload": [
        {
            "contentString": "Patient 1 has a very high serum potassium value (7.2 mmol/L on 2014-Dec-12 at 5:55 pm)"
        },
        {
            "contentReference": {
                "reference": "Observation/643666aa12f"
            }
        }
    ],
    "status": "completed",
    "sent": "2014-12-12T18:01:10-08:00",
    "subject": {
        "reference": "Patient/1"
    }
};

var example77: fhir.Communication = {
    "category": {
        "coding": [
            {
                "code": "Alert",
                "system": "http://acme.org/messagetypes"
            }
        ],
        "text": "Alert"
    },
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/communication-reasonNotPerformed",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "code": "EIE",
                        "display": "entered in error",
                        "system": "http://hl7.org/fhir/v3/ActReason"
                    }
                ]
            }
        }
    ],
    "id": "qicore",
    "identifier": [
        {
            "system": "urn:oid:1.3.4.5.6.7",
            "type": {
                "text": "Paging System"
            },
            "value": "2345678901"
        }
    ],
    "payload": [
        {
            "contentString": "Patient 1 has a very high serum potassium value (7.2 mmol/L on 2014-Dec-12 at 5:55 pm)"
        },
        {
            "contentReference": {
                "reference": "Observation/643666aa12f"
            }
        }
    ],
    "recipient": [
        {
            "reference": "Practitioner/21"
        }
    ],
    "resourceType": "Communication",
    "sender": {
        "reference": "Device/1234"
    },
    "sent": "2014-12-12T18:01:10-08:00",
    "status": "suspended",
    "subject": {
        "reference": "Patient/1"
    },
    "text": {
        "div": "<div>Patient has very high serum potassium</div>",
        "status": "generated"
    }
};

var example78: fhir.Communication = {
    "resourceType": "Communication",
    "id": "qicore",
    "text": {
        "status": "generated",
        "div": "<div>Patient has very high serum potassium</div>"
    },
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/communication-reasonNotPerformed",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "system": "http://hl7.org/fhir/v3/ActReason",
                        "code": "EIE",
                        "display": "entered in error"
                    }
                ]
            }
        }
    ],
    "identifier": [
        {
            "type": {
                "text": "Paging System"
            },
            "system": "urn:oid:1.3.4.5.6.7",
            "value": "2345678901"
        }
    ],
    "category": {
        "coding": [
            {
                "system": "http://acme.org/messagetypes",
                "code": "Alert"
            }
        ],
        "text": "Alert"
    },
    "sender": {
        "reference": "Device/1234"
    },
    "recipient": [
        {
            "reference": "Practitioner/21"
        }
    ],
    "payload": [
        {
            "contentString": "Patient 1 has a very high serum potassium value (7.2 mmol/L on 2014-Dec-12 at 5:55 pm)"
        },
        {
            "contentReference": {
                "reference": "Observation/643666aa12f"
            }
        }
    ],
    "status": "suspended",
    "sent": "2014-12-12T18:01:10-08:00",
    "subject": {
        "reference": "Patient/1"
    }
};

var example79: fhir.CommunicationRequest = {
    "id": "example",
    "resourceType": "CommunicationRequest",
    "subject": {
        "reference": "Patient/example"
    },
    "text": {
        "div": "<div>To be filled out at a later time</div>",
        "status": "generated"
    }
};

var example80: fhir.CommunicationRequest = {
    "resourceType": "CommunicationRequest",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>To be filled out at a later time</div>"
    },
    "subject": {
        "reference": "Patient/example"
    }
};

var example81: fhir.CommunicationRequest = {
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/communicationrequest-orderedBy",
            "valueReference": {
                "reference": "Practitioner/example"
            }
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/communicationrequest-reasonRejected",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "code": "NON-AVAIL",
                        "display": "patient not-available",
                        "system": "http://hl7.org/fhir/v3/ActReason"
                    }
                ]
            }
        }
    ],
    "id": "qicore",
    "resourceType": "CommunicationRequest",
    "status": "rejected",
    "subject": {
        "reference": "Patient/example"
    },
    "text": {
        "div": "<div>To be filled out at a later time</div>",
        "status": "generated"
    }
};

var example82: fhir.CommunicationRequest = {
    "resourceType": "CommunicationRequest",
    "id": "qicore",
    "text": {
        "status": "generated",
        "div": "<div>To be filled out at a later time</div>"
    },
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/communicationrequest-orderedBy",
            "valueReference": {
                "reference": "Practitioner/example"
            }
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/communicationrequest-reasonRejected",
            "valueCodeableConcept": {
                "coding": [
                    {
                        "system": "http://hl7.org/fhir/v3/ActReason",
                        "code": "NON-AVAIL",
                        "display": "patient not-available"
                    }
                ]
            }
        }
    ],
    "status": "rejected",
    "subject": {
        "reference": "Patient/example"
    }
};

var example83: fhir.Composition = {
    "attester": [
        {
            "mode": [
                "legal"
            ],
            "party": {
                "display": "Robert Dolin MD",
                "reference": "Practitioner/xcda-author"
            }
        }
    ],
    "author": [
        {
            "display": "Robert Dolin MD",
            "reference": "Practitioner/xcda-author"
        }
    ],
    "confidentiality": "N",
    "custodian": {
        "display": "Good Health Clinic",
        "reference": "Organization/2.16.840.1.113883.19.5"
    },
    "date": "2012-01-04T09:10:14Z",
    "id": "example",
    "identifier": {
        "system": "http://healthintersections.com.au/test",
        "value": "1"
    },
    "resourceType": "Composition",
    "section": [
        {
            "content": {
                "reference": "List/example"
            },
            "title": "History of present illness"
        }
    ],
    "status": "final",
    "subject": {
        "display": "Henry Levin the 7th",
        "reference": "Patient/xcda"
    },
    "text": {
        "div": "<div>\n      \n      <p>Consultation note for Henry Levin the 7th</p>\n    \n    </div>",
        "status": "generated"
    },
    "type": {
        "coding": [
            {
                "code": "11488-4",
                "display": "Consult note",
                "system": "http://loinc.org"
            }
        ]
    }
};

var example84: fhir.Composition = {
    "resourceType": "Composition",
    "id": "example",
    "text": {
        "status": "generated",
        "div": "<div>\n      \n      <p>Consultation note for Henry Levin the 7th</p>\n    \n    </div>"
    },
    "identifier": {
        "system": "http://healthintersections.com.au/test",
        "value": "1"
    },
    "date": "2012-01-04T09:10:14Z",
    "type": {
        "coding": [
            {
                "system": "http://loinc.org",
                "code": "11488-4",
                "display": "Consult note"
            }
        ]
    },
    "status": "final",
    "confidentiality": "N",
    "subject": {
        "reference": "Patient/xcda",
        "display": "Henry Levin the 7th"
    },
    "author": [
        {
            "reference": "Practitioner/xcda-author",
            "display": "Robert Dolin MD"
        }
    ],
    "attester": [
        {
            "mode": [
                "legal"
            ],
            "party": {
                "reference": "Practitioner/xcda-author",
                "display": "Robert Dolin MD"
            }
        }
    ],
    "custodian": {
        "reference": "Organization/2.16.840.1.113883.19.5",
        "display": "Good Health Clinic"
    },
    "section": [
        {
            "title": "History of present illness",
            "content": {
                "reference": "List/example"
            }
        }
    ]
};

var example85: fhir.ConceptMap = {
    "contact": [
        {
            "telecom": [
                {
                    "system": "url",
                    "value": "http://hl7.org/fhir"
                }
            ]
        },
        {
            "telecom": [
                {
                    "system": "url",
                    "value": "http://www.phconnect.org/group/laboratorymessagingcommunityofpractice/forum/attachment/download?id=3649725%3AUploadedFile%3A145786"
                }
            ]
        }
    ],
    "date": "2013-07-25",
    "element": [
        {
            "code": "ACNE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309068002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ACNFLD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119323008",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "HL7 term is a historical term. mapped to Pus",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "47002008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "AIRS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "446302006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ALL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "7970006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "AMP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "408654003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "81723002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "ANGI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ARTC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ASERU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "pending",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "ASP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119295008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "ATTE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "AUTOC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "AUTP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "This really is not a specimen per se - it is the state of the subject from whom the specimen is collected, so it should be used as a  specimen type modifier ONLY!. Often this is indicated with a special medical record number or other notation on the patient. needs to have specimen type (SPM-4) and source site (SPM.8) and spatial orientation (SPM.9)",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "BBL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119304001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "BCYST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "submitted (PLR155) with parent of  167874004^knee joint synovial fluid (specimen), with specimen source topography 32361000^Popliteal fossa structure (body structure)",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "32361000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Submit for new term with parent 119365002",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "BLEB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309049000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "339008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BLIST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309049000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "339008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BOIL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119295008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "59843005",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BON",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "430268003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "BOWL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Don't use this term for human samples - use Stool instead. animal would use small intestinal contents, large intestinal contents",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "BPU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119300005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "BRN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119367005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "BRSH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258415003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "439336003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BRTH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119336008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "BRUS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309176002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "80657008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BUB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "302795002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "11585000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BULLA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258482009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "339008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "BX",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258415003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "86273004",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CALC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119350003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CARBU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "41570003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CAT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119311002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CBITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Submit for new term with parent 119365002",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "CLIPP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119327009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Be more specific use either: 119326000^hair specimen or 119327009^nail specimen",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CNJT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119401005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CNJT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "128160006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CNJT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258498002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "COL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119329007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CONE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "399713008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "54535009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "71252005",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CSCR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "submit for new term with parent 119365002^Specimen from wound (specimen)",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "CSERU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "pending",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "CSITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258507003",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora       ",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "386144009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "285570007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CSMY",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258453008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CSVR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD - may use blood and SPM-6",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "CTP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CVPS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258507003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "CVPT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "445085009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CYN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119368000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "27925004",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CYST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119368000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "DBITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Submit for new term with parent 119365002",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "DCS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119335007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "DEC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258505006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "DEION",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "DIA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119360007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "DISCHG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258439008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "DIV",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "31113003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "DRN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119306004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "DRNG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258455001",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead: not an acceptible specimen for micro - not specific enough term",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "DRNGP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "EARW",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122580007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "EBRUSH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309210009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "36213007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "32849002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "EEYE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "EFF",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "EFFUS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258440005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "EFOD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119320006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "EISO",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258536003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ELT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119314005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ENVIR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119324002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "EOTH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "ESOI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "ESOS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "ETA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119307008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "321667001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "ETTP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ETTUB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119307008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "321667001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "EWHI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "EXG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119336008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "EXS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "EXUDTE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258441009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "FAW",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "FBLOOD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119297000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "303112003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "FGA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "168139001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "83670000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "FIST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119370009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "FLD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "FLT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "FLU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "FLUID",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258442002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "FOLEY",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "FRS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258442002",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "this term is not specific enough, choose from terms that more accurately describe the specimen",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "272626006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "FSCLP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309502007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "41695006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "FUR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119295008",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Further describe the sample as tissue or pus. or by the collection method. The term boil is not specifc to a body site - need to indicate source site (spm.8). preferred term is Aspirate_Boil",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "59843005",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GAS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119317003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "GASA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "168137004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GASAN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119379005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "66051006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GASBR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309213006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "235157009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GASD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258459007",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GAST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258459007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "GENV",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119394009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "GRAFT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440493002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "GRANU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "45647009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GROSH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119311002",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "GSOL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "GSPEC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309211008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "79121003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "GT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "GTUBE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258459007",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "127490009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "HBITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Submit for new term with parent 119365002",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "HBLUD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119297000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "303113008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "HEMAQ",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "HEMO",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "HERNI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "HEV",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119306004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "HIC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "445085009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "HYDC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "55434001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "IBITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Submit for new term with parent 119365002",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "ICYST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309075001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "IDC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "IHG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119337004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ILEO",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258455001",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "419954003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "ILLEG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "IMP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "439961009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "INCI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "INFIL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "This describes a morphologic abnormality, not a sample",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "INS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258614005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "INTRD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "IT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119307008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "IUD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "pending",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "IVCAT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "255560000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "IVFLD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258649003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "IVTIP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "JEJU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258463000",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "21306003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "JNTFLD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119332005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "JP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "KELOI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440674008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "67889009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "KIDFLD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309051001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "64033007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "LAVG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258607008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "397394009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "LAVGG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "168138009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "173830003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "LAVGP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440137008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "LAVPG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440674008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "67889009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "44567001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "LENS1",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440473005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "LENS2",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "LESN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309049000",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "should be more specific what kind of lesion is observed - be more specific is it a wound, abscess, mass - specify! Ask SNOMED CT to mark it as a grouper term only (309049000)",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "LIQ",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258442002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "LIQO",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "LSAC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258450006",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "The HL7 term is a historical term Mapped to CSF obtained by lumbar puncture",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "303949008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "MAHUR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "MASS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "420548004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "4147007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "MBLD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119345009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "MUCOS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "414781009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "MUCUS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258483004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "NASDR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258474009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "2095001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "NEDL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "NEPH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "NGASP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "302794003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "6853008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "NGAST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258459007",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "127492001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "69695003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "NGS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "NODUL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "pending",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "NSECR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "168141000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ORH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "123038009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "ORL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "be more precise use ulcer, tumor, vesicle",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "74262004",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "OTH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "123038009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PACEM",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "PCFL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122571007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PDSIT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PDTS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "submitted for code",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "PELVA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "12921003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "PENIL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "need to know what kind of lesion, so map to: UlcerTissue_penile, VesicleFluid_penile, Wound_penile, Mass tissue_penile, Necrotic tissue_penile, AbscessAspirate_penile, Anything else?",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "18911002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "PERIA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "397158004",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "PILOC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119368000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PINS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PIS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258507003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PLAN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119301009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PLAS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119361006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PLB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119305000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PLEVS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119364003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "255587001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "PND",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258439008",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term -though in this case more often used for discharge",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "13648007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "POL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "41329004",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "POPGS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440493002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "6902008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "POPLG",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440493002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "6902008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "POPLV",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "PORTA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119311002",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PPP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119362004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PROST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PRP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119363009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PSC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119368000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PUNCT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119365002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "129300006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "PUS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119323008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "PUSFR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119323008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "47002008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "PUST",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119323008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "47002008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "QC3",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "RANDU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "278020009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "RBITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Submit for new term with parent: 119365002",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "RECT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119339001",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "34402009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "RECTA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "34402009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "RENALC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258420003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "64033007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "RENC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258453008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "64033007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "RES",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258603007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SAL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119342007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SCAR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SCLV",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "9454009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SCROA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "20233005",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SECRE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "432825001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SER",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119364003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SHU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119295008",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Preferred is aspiration with sterile syringe from inflamed area. Specify body location of shunt site",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "257351008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SHUNF",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "446861007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "446860008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "279107003",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SHUNT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "SITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "SKBP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309066003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "240977001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SKN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119325001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SMM",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "420548004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "4147007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SNV",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119332005",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPRM",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119349003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPRP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPRPB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "SPT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119334006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPTC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119335007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPTT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258609006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPUT1",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "SPUTIN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258610001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "SPUTSP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119335007",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "STER",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "STL",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119339001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "STONE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119350003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "64033007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SUBMA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "5713008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SUBMX",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "4335006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SUMP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "446562005",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Historical term - consider what is being drained and indicate that in SPM-4 instead",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SUP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122575003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "58088002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SUTUR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "SWGZ",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TASP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122877000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "129112001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "44567001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "TISS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119376003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TISU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122593002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TLC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TRAC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "438660002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TRANS",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258538002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TSERU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119364003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "255588006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "TSTES",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119371008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "279572002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "TTRA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258480001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "129112001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "TUBES",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119310001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TUMOR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258435002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "TZANC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "This is the name of a lab test. A skin sample is examined for viral inclusions.",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "UDENT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "123038009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "UR",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122575003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "URC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122880004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "URINB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122575003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "78533007",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "URINC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "446846006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "URINM",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258574006",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "225271002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "431938005",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "URINN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "446277003",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "225109005",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "25990002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "URINP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "URT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122565001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "USCOP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "NEW specimenTERM 7",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "176178006",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "89837001",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "USPEC",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "123038009",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "VASTIP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "VENT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119312009",
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD in detail",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "VITF",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258438000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "VOM",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122572000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WASH",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "440674008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WASI",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122609004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WAT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119318008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WB",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Bloodbanking term ONLY now map to blood and the respective preservative",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "WEN",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309075001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WICK",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "WND",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119365002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WNDA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119366001",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WNDD",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122566000",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent",
                    "product": [
                        {
                            "code": "122462000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        },
        {
            "code": "WNDE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "122568004",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WORM",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "258618008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WRT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "309068002",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WWA",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "code": "119318008",
                    "codeSystem": "http://snomed.info/sct",
                    "equivalence": "equivalent"
                }
            ]
        },
        {
            "code": "WWO",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "WWT",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "TBD",
                    "equivalence": "unmatched"
                }
            ]
        },
        {
            "code": "CSITE",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "119295008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "386144009",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        },
                        {
                            "code": "14766002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-8"
                        }
                    ]
                }
            ]
        },
        {
            "code": "CLIPP",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "Be more specific use either: 119326000^hair specimen, or 119327009^nail specimen",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "119326000",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        }
                    ]
                }
            ]
        },
        {
            "code": "SHU",
            "codeSystem": "http://hl7.org/fhir/v2/0487",
            "map": [
                {
                    "codeSystem": "http://snomed.info/sct",
                    "comments": "assume swab from shunt site for mapping here - clean surface of skin prior to expressing the shunt site - preferred is aspiration with sterile syringe should use SPM.8 to specify body approximate match location of shunt site",
                    "equivalence": "unmatched",
                    "product": [
                        {
                            "code": "438660002",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-5"
                        },
                        {
                            "code": "257351008",
                            "codeSystem": "http://snomed.info/sct",
                            "element": "http://hl7.org/fhir/v2/element/SPM-7"
                        }
                    ]
                }
            ]
        }
    ],
    "experimental": false,
    "id": "102",
    "name": "Specimen mapping from v2 table 0487 to SNOMED CT",
    "publisher": "FHIR project team (original source: LabMCoP)",
    "resourceType": "ConceptMap",
    "sourceReference": {
        "reference": "http://hl7.org/fhir/v2/vs/0487"
    },
    "status": "draft",
    "targetReference": {
        "reference": "http://snomed.info/id"
    },
    "text": {
        "div": "<div>\n      <h2>Specimen mapping from v2 table 0487 to SNOMED CT (http://hl7.org/fhir/conceptmap-example-specimen-type.html)</h2>\n      <p>Mapping from \n        <a href=\"v2/0487/index.html\">http://hl7.org/fhir/v2/vs/0487</a> to \n        <a href=\"http://snomed.info/id\">SNOMED-CT</a>\n      </p>\n      <p>DRAFT. Published on Jul 25, 2013 by FHIR project team (original source: LabMCoP) (\n        <a href=\"http://hl7.org/fhir\">http://hl7.org/fhir</a>; , \n        <a href=\"http://www.phconnect.org/group/laboratorymessagingcommunityofpractice/forum/attachment/download?id=3649725%3AUploadedFile%3A145786\">http://www.phconnect.org/group...</a>; ). \n      </p>\n      <br/>\n      <table class=\"grid\">\n        <tr>\n          <td colspan=\"1\">\n            <b>Source Concept</b>\n          </td>\n          <td>\n            <b>Equivalence</b>\n          </td>\n          <td colspan=\"4\">\n            <b>Destination Concept</b>\n          </td>\n          <td>\n            <b>Comments</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <b>Code [http://hl7.org/fhir/v2/0487]</b>\n          </td>\n          <td/>\n          <td>\n            <b>Code [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-7 [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-8 [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-5 [http://snomed.info/sct]</b>\n          </td>\n          <td/>\n        </tr>\n        <tr>\n          <td>ACNE (Tissue, Acne)</td>\n          <td>EQUIVALENT</td>\n          <td>309068002 (Skin lesion sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ACNFLD (Fluid, Acne)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td>HL7 term is a historical term. mapped to Pus</td>\n        </tr>\n        <tr>\n          <td>AIRS (Air Sample)</td>\n          <td>EQUIVALENT</td>\n          <td>446302006 (Air sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ALL (Allograft)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>7970006 (Allograft)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>AMP (Amputation)</td>\n          <td>EQUIVALENT</td>\n          <td>408654003 (Specimen obtained by amputation)</td>\n          <td>81723002 (Amputation)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ANGI (Catheter Tip, Angio)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ARTC (Catheter Tip, Arterial)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ASERU (Serum, Acute)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>ASP (Aspirate)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ATTE (Environment, Attest)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>AUTOC (Environmental, Autoclave Capsule)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>AUTP (Autopsy)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This really is not a specimen per se - it is the state of the subject from whom the specimen is collected, so it should be used as a  specimen type modifier ONLY!. Often this is indicated with a special medical record number or other notation on the patient. needs to have specimen type (SPM-4) and source site (SPM.8) and spatial orientation (SPM.9)</td>\n        </tr>\n        <tr>\n          <td>BBL (Blood bag)</td>\n          <td>EQUIVALENT</td>\n          <td>119304001 (Blood bag specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BCYST (Cyst, Baker's)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td>32361000 (Popliteal fossa structure (body structure))</td>\n          <td/>\n          <td>submitted (PLR155) with parent of  167874004^knee joint synovial fluid (specimen), with specimen source topography 32361000^Popliteal fossa structure (body structure)</td>\n        </tr>\n        <tr>\n          <td>BITE (Bite)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>BLEB (Bleb)</td>\n          <td>EQUIVALENT</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BLIST (Blister)</td>\n          <td>EQUIVALENT</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BOIL (Boil)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>59843005 (Furuncle (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BON (Bone)</td>\n          <td>EQUIVALENT</td>\n          <td>430268003 (Specimen from bone (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BOWL (Bowel contents)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Don't use this term for human samples - use Stool instead. animal would use small intestinal contents, large intestinal contents</td>\n        </tr>\n        <tr>\n          <td>BPU (Blood product unit)</td>\n          <td>EQUIVALENT</td>\n          <td>119300005 (Specimen from blood product (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRN (Burn)</td>\n          <td>EQUIVALENT</td>\n          <td>119367005 (Specimen from burn injury (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRSH (Brush)</td>\n          <td>EQUIVALENT</td>\n          <td>258415003 (Biopsy sample (specimen))</td>\n          <td>439336003 (Brush biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRTH (Breath (use EXHLD))</td>\n          <td>EQUIVALENT</td>\n          <td>119336008 (Exhaled air specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRUS (Brushing)</td>\n          <td>EQUIVALENT</td>\n          <td>309176002 (Bronchial brushings sample (specimen))</td>\n          <td>80657008 (Bronchoscopy with brush biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BUB (Bubo)</td>\n          <td>EQUIVALENT</td>\n          <td>302795002 (Lymph node aspirate (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>11585000 (Bubo (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BULLA (Bulla/Bullae)</td>\n          <td>EQUIVALENT</td>\n          <td>258482009 (Vesicle fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BX (Biopsy)</td>\n          <td>EQUIVALENT</td>\n          <td>258415003 (Biopsy sample (specimen))</td>\n          <td>86273004 (Biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CALC (Calculus (=Stone))</td>\n          <td>EQUIVALENT</td>\n          <td>119350003 (Calculus specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CARBU (Carbuncle)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>41570003 (Carbuncle (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>CAT (Catheter)</td>\n          <td>EQUIVALENT</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CBITE (Bite, Cat)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>CLIPP (Clippings)</td>\n          <td>EQUIVALENT</td>\n          <td>119327009 (Nail specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>Be more specific use either: 119326000^hair specimen or 119327009^nail specimen</td>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>EQUIVALENT</td>\n          <td>119401005 (Specimen from conjunctiva (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>EQUIVALENT</td>\n          <td>128160006 (Tissue specimen from conjunctiva (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>EQUIVALENT</td>\n          <td>258498002 (Conjunctival swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>COL (Colostrum)</td>\n          <td>EQUIVALENT</td>\n          <td>119329007 (Colostrum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CONE (Biospy, Cone)</td>\n          <td>EQUIVALENT</td>\n          <td>399713008 (Specimen from uterine cervix obtained by cone biopsy (specimen))</td>\n          <td>54535009 (Cone biopsy of cervix (procedure))</td>\n          <td>71252005 (Cervix uteri structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CSCR (Scratch, Cat)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>submit for new term with parent 119365002^Specimen from wound (specimen)</td>\n        </tr>\n        <tr>\n          <td>CSERU (Serum, Convalescent)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>CSITE (Catheter Insertion Site)</td>\n          <td>EQUIVALENT</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td>285570007 (Taking of swab (procedure))</td>\n          <td/>\n          <td>386144009 (Line insertion site (morphologic abnormality))</td>\n          <td>Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora       </td>\n        </tr>\n        <tr>\n          <td>CSMY (Fluid,  Cystostomy Tube)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CST (Fluid, Cyst)</td>\n          <td>EQUIVALENT</td>\n          <td>258453008 (Cyst fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CSVR (Blood, Cell Saver)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD - may use blood and SPM-6</td>\n        </tr>\n        <tr>\n          <td>CTP (Catheter tip)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>CVPS (Site, CVP)</td>\n          <td>EQUIVALENT</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CVPT (Catheter Tip, CVP)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>445085009 (Tunneled central venous catheter (physical object))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>CYN (Nodule, Cystic)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td>27925004 (Nodule (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>CYST (Cyst)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DBITE (Bite, Dog)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>DCS (Sputum, Deep Cough)</td>\n          <td>EQUIVALENT</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DEC (Ulcer, Decubitus)</td>\n          <td>EQUIVALENT</td>\n          <td>258505006 (Skin ulcer swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DEION (Environmental, Water  (Deionized))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>DIA (Dialysate)</td>\n          <td>EQUIVALENT</td>\n          <td>119360007 (Dialysis fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DISCHG (Discharge)</td>\n          <td>EQUIVALENT</td>\n          <td>258439008 (Discharge specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DIV (Diverticulum)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>31113003 (Diverticulum (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>DRN (Drain)</td>\n          <td>EQUIVALENT</td>\n          <td>119306004 (Drain device specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DRNG (Drainage, Tube)</td>\n          <td>EQUIVALENT</td>\n          <td>258455001 (Drainage fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: not an acceptible specimen for micro - not specific enough term</td>\n        </tr>\n        <tr>\n          <td>DRNGP (Drainage, Penrose)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>EARW (Ear wax (cerumen))</td>\n          <td>EQUIVALENT</td>\n          <td>122580007 (Cerumen specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EBRUSH (Brush, Esophageal)</td>\n          <td>EQUIVALENT</td>\n          <td>309210009 (Esophageal brushings sample (specimen))</td>\n          <td>36213007 (Endoscopy and brush biopsy (procedure))</td>\n          <td>32849002 (Esophageal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EEYE (Environmental, Eye Wash)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EFF (Environmental, Effluent)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EFFUS (Effusion)</td>\n          <td>EQUIVALENT</td>\n          <td>258440005 (Effusion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EFOD (Environmental, Food)</td>\n          <td>EQUIVALENT</td>\n          <td>119320006 (Food specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EISO (Environmental, Isolette)</td>\n          <td>EQUIVALENT</td>\n          <td>258536003 (Incubator swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ELT (Electrode)</td>\n          <td>EQUIVALENT</td>\n          <td>119314005 (Electrode specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ENVIR (Environmental, Unidentified Substance)</td>\n          <td>EQUIVALENT</td>\n          <td>119324002 (Specimen of unknown material (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EOTH (Environmental, Other Substance)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ESOI (Environmental, Soil)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ESOS (Environmental, Solution (Sterile))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ETA (Aspirate,  Endotrach)</td>\n          <td>EQUIVALENT</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>321667001 (Respiratory tract)</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ETTP (Catheter Tip, Endotracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ETTUB (Tube, Endotracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>321667001 (Respiratory tract)</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EWHI (Environmental, Whirlpool)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EXG (Gas, exhaled (=breath))</td>\n          <td>EQUIVALENT</td>\n          <td>119336008 (Exhaled air specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EXS (Shunt, External)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EXUDTE (Exudate)</td>\n          <td>EQUIVALENT</td>\n          <td>258441009 (Exudate sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FAW (Environmental, Water  (Well))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>FBLOOD (Blood, Fetal)</td>\n          <td>EQUIVALENT</td>\n          <td>119297000 (Blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td>303112003 (Fetal period (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>FGA (Fluid,  Abdomen)</td>\n          <td>EQUIVALENT</td>\n          <td>168139001 (Peritoneal fluid sample (specimen))</td>\n          <td/>\n          <td>83670000 (Peritoneal cavity structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FIST (Fistula)</td>\n          <td>EQUIVALENT</td>\n          <td>119370009 (Specimen from fistula (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLD (Fluid, Other)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLT (Filter)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>FLU (Fluid, Body unsp)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLUID (Fluid)</td>\n          <td>EQUIVALENT</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FOLEY (Catheter Tip, Foley)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>FRS (Fluid, Respiratory)</td>\n          <td>EQUIVALENT</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td>272626006 (Respiratory organ (body structure))</td>\n          <td/>\n          <td>this term is not specific enough, choose from terms that more accurately describe the specimen</td>\n        </tr>\n        <tr>\n          <td>FSCLP (Scalp, Fetal)</td>\n          <td>EQUIVALENT</td>\n          <td>309502007 (Fetus specimen (specimen))</td>\n          <td/>\n          <td>41695006 (Scalp structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FUR (Furuncle)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td/>\n          <td/>\n          <td>59843005 (Furuncle (morphologic abnormality))</td>\n          <td>Further describe the sample as tissue or pus. or by the collection method. The term boil is not specifc to a body site - need to indicate source site (spm.8). preferred term is Aspirate_Boil</td>\n        </tr>\n        <tr>\n          <td>GAS (Gas)</td>\n          <td>EQUIVALENT</td>\n          <td>119317003 (Gaseous material specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASA (Aspirate, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>168137004 (Gastric aspirate sample (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASAN (Antrum, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>119379005 (Specimen from stomach (specimen))</td>\n          <td/>\n          <td>66051006 (Pyloric antrum structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASBR (Brushing, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>309213006 (Gastric brushings sample (specimen))</td>\n          <td>235157009 (Endoscopic brushings of gastrointestinal tract (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASD (Drainage, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>GAST (Fluid/contents, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GENV (Genital vaginal)</td>\n          <td>EQUIVALENT</td>\n          <td>119394009 (Specimen from vagina)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GRAFT (Graft)</td>\n          <td>EQUIVALENT</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GRANU (Granuloma)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>45647009 (Granuloma (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>GROSH (Catheter, Groshong)</td>\n          <td>EQUIVALENT</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>GSOL (Solution, Gastrostomy)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>GSPEC (Biopsy, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>309211008 (Gastric biopsy sample (specimen))</td>\n          <td>79121003 (Biopsy of stomach (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GT (Tube, Gastric)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>GTUBE (Drainage Tube, Drainage (Gastrostomy))</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td>127490009 (Gastrostomy route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>HBITE (Bite, Human)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>HBLUD (Blood, Autopsy)</td>\n          <td>EQUIVALENT</td>\n          <td>119297000 (Blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td>303113008 (Postmortem period (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>HEMAQ (Catheter Tip, Hemaquit)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HEMO (Catheter Tip, Hemovac)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HERNI (Tissue, Herniated)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>HEV (Drain, Hemovac)</td>\n          <td>EQUIVALENT</td>\n          <td>119306004 (Drain device specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>HIC (Catheter, Hickman)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>445085009 (Tunneled central venous catheter (physical object))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HYDC (Fluid, Hydrocele)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>55434001 (Hydrocele (disorder))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>IBITE (Bite, Insect)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>ICYST (Cyst, Inclusion)</td>\n          <td>EQUIVALENT</td>\n          <td>309075001 (Skin cyst sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IDC (Catheter Tip, Indwelling)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IHG (Gas, Inhaled)</td>\n          <td>EQUIVALENT</td>\n          <td>119337004 (Inhaled gas specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ILEO (Drainage, Ileostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>258455001 (Drainage fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>419954003 (Ileostomy route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>ILLEG (Source of Specimen Is Illegible)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>IMP (Implant)</td>\n          <td>EQUIVALENT</td>\n          <td>439961009 (Implant submitted as specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INCI (Site, Incision/Surgical)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INFIL (Infiltrate)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This describes a morphologic abnormality, not a sample</td>\n        </tr>\n        <tr>\n          <td>INS (Insect)</td>\n          <td>EQUIVALENT</td>\n          <td>258614005 (Insect sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INTRD (Catheter Tip, Introducer)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IT (Intubation tube)</td>\n          <td>EQUIVALENT</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IUD (Intrauterine Device)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>IVCAT (Catheter Tip, IV)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>255560000 (Intravenous (qualifier value))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IVFLD (Fluid, IV)</td>\n          <td>EQUIVALENT</td>\n          <td>258649003 (Intravenous infusion fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IVTIP (Tubing Tip, IV)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>JEJU (Drainage, Jejunal)</td>\n          <td>EQUIVALENT</td>\n          <td>258463000 (Jejunal fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>21306003 (Jejunal structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>JNTFLD (Fluid, Joint)</td>\n          <td>EQUIVALENT</td>\n          <td>119332005 (Synovial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>JP (Drainage, Jackson Pratt)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>KELOI (Lavage)</td>\n          <td>EQUIVALENT</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td>67889009 (Lavage)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>KIDFLD (Fluid, Kidney)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVG (Lavage, Bronhial)</td>\n          <td>EQUIVALENT</td>\n          <td>258607008 (Bronchoalveolar lavage fluid sample (specimen))</td>\n          <td>397394009 (Bronchoalveolar lavage (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVGG (Lavage, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>168138009 (Gastric lavage aspirate sample)</td>\n          <td>173830003 (Gastric lavage (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVGP (Lavage, Peritoneal)</td>\n          <td>EQUIVALENT</td>\n          <td>440137008 (Specimen obtained by peritoneal lavage (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVPG (Lavage, Pre-Bronch)</td>\n          <td>EQUIVALENT</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td>67889009 (Lavage)</td>\n          <td>44567001 (Tracheal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LENS1 (Contact Lens)</td>\n          <td>EQUIVALENT</td>\n          <td>440473005 (Contact lens submitted as specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LENS2 (Contact Lens Case)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>LESN (Lesion)</td>\n          <td>EQUIVALENT</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>should be more specific what kind of lesion is observed - be more specific is it a wound, abscess, mass - specify! Ask SNOMED CT to mark it as a grouper term only (309049000)</td>\n        </tr>\n        <tr>\n          <td>LIQ (Liquid, Unspecified)</td>\n          <td>EQUIVALENT</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LIQO (Liquid, Other)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>LSAC (Fluid, Lumbar Sac)</td>\n          <td>EQUIVALENT</td>\n          <td>258450006 (Cerebrospinal fluid sample (specimen))</td>\n          <td/>\n          <td>303949008 (Lumbar spinal cerebrospinal fluid pathway (body structure))</td>\n          <td/>\n          <td>The HL7 term is a historical term Mapped to CSF obtained by lumbar puncture</td>\n        </tr>\n        <tr>\n          <td>MAHUR (Catheter Tip, Makurkour)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>MASS (Mass)</td>\n          <td>EQUIVALENT</td>\n          <td>420548004 (Specimen from mass lesion (specimen))</td>\n          <td/>\n          <td/>\n          <td>4147007 (Mass (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>MBLD (Blood, Menstrual)</td>\n          <td>EQUIVALENT</td>\n          <td>119345009 (Menstrual blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>MUCOS (Mucosa)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td>414781009 (Mucous membrane structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>MUCUS (Mucus)</td>\n          <td>EQUIVALENT</td>\n          <td>258483004 (Mucus sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NASDR (Drainage, Nasal)</td>\n          <td>EQUIVALENT</td>\n          <td>258474009 (Sinus fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>2095001 (Nasal sinus structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>NEDL (Needle)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>NEPH (Site, Nephrostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NGASP (Aspirate, Nasogastric)</td>\n          <td>EQUIVALENT</td>\n          <td>302794003 (Nasogastric aspirate (specimen))</td>\n          <td>6853008 (Nasogastric tube aspiration (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NGAST (Drainage, Nasogastric)</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td>127492001 (Nasogastric route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>NGS (Site, Naso/Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NODUL (Nodule(s))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>NSECR (Secretion, Nasal)</td>\n          <td>EQUIVALENT</td>\n          <td>168141000 (Nasal fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ORH (Other)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ORL (Lesion, Oral)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td>74262004 (Oral cavity)</td>\n          <td/>\n          <td>be more precise use ulcer, tumor, vesicle</td>\n        </tr>\n        <tr>\n          <td>OTH (Source, Other)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PACEM (Pacemaker)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>PCFL (Fluid, Pericardial)</td>\n          <td>EQUIVALENT</td>\n          <td>122571007 (Pericardial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PDSIT (Site, Peritoneal Dialysis)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PDTS (Site, Peritoneal Dialysis Tunnel)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>submitted for code</td>\n        </tr>\n        <tr>\n          <td>PELVA (Abscess, Pelvic)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>12921003 (Pelvic structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PENIL (Lesion, Penile)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td>18911002 (Penile structure (body structure))</td>\n          <td/>\n          <td>need to know what kind of lesion, so map to: UlcerTissue_penile, VesicleFluid_penile, Wound_penile, Mass tissue_penile, Necrotic tissue_penile, AbscessAspirate_penile, Anything else?</td>\n        </tr>\n        <tr>\n          <td>PERIA (Abscess, Perianal)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>397158004 (Perianal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PILOC (Cyst, Pilonidal)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PINS (Site, Pin)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PIS (Site, Pacemaker Insetion)</td>\n          <td>EQUIVALENT</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLAN (Plant Material)</td>\n          <td>EQUIVALENT</td>\n          <td>119301009 (Plant specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLAS (Plasma)</td>\n          <td>EQUIVALENT</td>\n          <td>119361006 (Plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLB (Plasma bag)</td>\n          <td>EQUIVALENT</td>\n          <td>119305000 (Plasma bag specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLEVS (Serum, Peak Level)</td>\n          <td>EQUIVALENT</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td>255587001 (Peak (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PND (Drainage, Penile)</td>\n          <td>EQUIVALENT</td>\n          <td>258439008 (Discharge specimen (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>13648007 (Urethral structure (body structure))</td>\n          <td/>\n          <td>Historical term -though in this case more often used for discharge</td>\n        </tr>\n        <tr>\n          <td>POL (Polyps)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>41329004 (Polyp (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPGS (Graft Site, Popliteal)</td>\n          <td>EQUIVALENT</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td>6902008 (Popliteal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPLG (Graft, Popliteal)</td>\n          <td>EQUIVALENT</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td>6902008 (Popliteal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPLV (Site, Popliteal Vein)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>PORTA (Catheter, Porta)</td>\n          <td>EQUIVALENT</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>PPP (Plasma, Platelet poor)</td>\n          <td>EQUIVALENT</td>\n          <td>119362004 (Platelet poor plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PROST (Prosthetic Device)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PRP (Plasma, Platelet rich)</td>\n          <td>EQUIVALENT</td>\n          <td>119363009 (Platelet rich plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PSC (Pseudocyst)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUNCT (Wound, Puncture)</td>\n          <td>EQUIVALENT</td>\n          <td>119365002 (Specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td>129300006 (Puncture - action (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUS (Pus)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUSFR (Pustule)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUST (Pus)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>QC3 (Quality Control)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>RANDU (Urine, Random)</td>\n          <td>EQUIVALENT</td>\n          <td>278020009 (Spot urine sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RBITE (Bite, Reptile)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent: 119365002</td>\n        </tr>\n        <tr>\n          <td>RECT (Drainage, Rectal)</td>\n          <td>EQUIVALENT</td>\n          <td>119339001 (Stool specimen (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>34402009 (Rectum structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>RECTA (Abscess, Rectal)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>34402009 (Rectum structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RENALC (Cyst, Renal)</td>\n          <td>EQUIVALENT</td>\n          <td>258420003 (Cyst tissue (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RENC (Fluid, Renal Cyst)</td>\n          <td>EQUIVALENT</td>\n          <td>258453008 (Cyst fluid sample (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RES (Respiratory)</td>\n          <td>EQUIVALENT</td>\n          <td>258603007 (Respiratory sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SAL (Saliva)</td>\n          <td>EQUIVALENT</td>\n          <td>119342007 (Saliva specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SCAR (Tissue, Keloid (Scar))</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SCLV (Catheter Tip, Subclavian)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td>9454009 (Structure of subclavian vein (body structure))</td>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SCROA (Abscess, Scrotal)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>20233005 (Scrotal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SECRE (Secretion(s))</td>\n          <td>EQUIVALENT</td>\n          <td>432825001 (Body secretion specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SER (Serum)</td>\n          <td>EQUIVALENT</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SHU (Site, Shunt)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>257351008 (Shunt (physical object))</td>\n          <td>Preferred is aspiration with sterile syringe from inflamed area. Specify body location of shunt site</td>\n        </tr>\n        <tr>\n          <td>SHUNF (Fluid, Shunt)</td>\n          <td>EQUIVALENT</td>\n          <td>446861007 (Cerebrospinal fluid specimen obtained via ventriculoperitoneal shunt (specimen))</td>\n          <td>446860008 (Collection of cerebrospinal fluid via ventriculoperitoneal shunt (procedure))</td>\n          <td>279107003 (Central nervous system space (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SHUNT (Shunt)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SITE (Site)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SKBP (Biopsy, Skin)</td>\n          <td>EQUIVALENT</td>\n          <td>309066003 (Skin biopsy sample (specimen))</td>\n          <td>240977001 (Biopsy of skin)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SKN (Skin)</td>\n          <td>EQUIVALENT</td>\n          <td>119325001 (Skin (tissue) specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SMM (Mass, Sub-Mandibular)</td>\n          <td>EQUIVALENT</td>\n          <td>420548004 (Specimen from mass lesion (specimen))</td>\n          <td/>\n          <td/>\n          <td>4147007 (Mass (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>SNV (Fluid, synovial (Joint fluid))</td>\n          <td>EQUIVALENT</td>\n          <td>119332005 (Synovial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPRM (Spermatozoa)</td>\n          <td>EQUIVALENT</td>\n          <td>119349003 (Spermatozoa specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPRP (Catheter Tip, Suprapubic)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SPRPB (Cathether Tip, Suprapubic)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SPS (Environmental, Spore Strip)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SPT (Sputum)</td>\n          <td>EQUIVALENT</td>\n          <td>119334006 (Sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPTC (Sputum - coughed)</td>\n          <td>EQUIVALENT</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPTT (Sputum - tracheal aspirate)</td>\n          <td>EQUIVALENT</td>\n          <td>258609006 (Sputum specimen obtained by aspiration from trachea (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPUT1 (Sputum, Simulated)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SPUTIN (Sputum, Inducted)</td>\n          <td>EQUIVALENT</td>\n          <td>258610001 (Sputum specimen obtained by sputum induction (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPUTSP (Sputum, Spontaneous)</td>\n          <td>EQUIVALENT</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>STER (Environmental, Sterrad)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>STL (Stool = Fecal)</td>\n          <td>EQUIVALENT</td>\n          <td>119339001 (Stool specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>STONE (Stone, Kidney)</td>\n          <td>EQUIVALENT</td>\n          <td>119350003 (Calculus specimen (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUBMA (Abscess, Submandibular)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>5713008 (Submandibular triangle structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUBMX (Abscess, Submaxillary)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>4335006 (Upper jaw region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUMP (Drainage, Sump)</td>\n          <td>EQUIVALENT</td>\n          <td>446562005 (Body fluid specimen obtained via sump drain (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>SUP (Suprapubic Tap)</td>\n          <td>EQUIVALENT</td>\n          <td>122575003 (Urine sample)</td>\n          <td>58088002 (Urine specimen collection, suprapubic (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUTUR (Suture)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SWGZ (Catheter Tip, Swan Gantz)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>TASP (Aspirate, Tracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>122877000 (Upper respiratory fluid specimen obtained by tracheal aspiration (specimen))</td>\n          <td>129112001 (Aspiration from trachea (procedure))</td>\n          <td>44567001 (Tracheal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TISS (Tissue)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TISU (Tissue ulcer)</td>\n          <td>EQUIVALENT</td>\n          <td>122593002 (Tissue specimen obtained from ulcer (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TLC (Cathether Tip, Triple Lumen)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>TRAC (Site, Tracheostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TRANS (Transudate)</td>\n          <td>EQUIVALENT</td>\n          <td>258538002 (Transudate sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TSERU (Serum, Trough)</td>\n          <td>EQUIVALENT</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td>255588006 (Trough (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>TSTES (Abscess, Testicular)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>279572002 (Testicular structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TTRA (Aspirate, Transtracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>258480001 (Transtracheal aspirate sample (specimen))</td>\n          <td>129112001 (Aspiration from trachea (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TUBES (Tubes)</td>\n          <td>EQUIVALENT</td>\n          <td>119310001 (Tube specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TUMOR (Tumor)</td>\n          <td>EQUIVALENT</td>\n          <td>258435002 (Tumor tissue sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TZANC (Smear, Tzanck)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This is the name of a lab test. A skin sample is examined for viral inclusions.</td>\n        </tr>\n        <tr>\n          <td>UDENT (Source, Unidentified)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>UR (Urine)</td>\n          <td>EQUIVALENT</td>\n          <td>122575003 (Urine sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URC (Urine clean catch)</td>\n          <td>EQUIVALENT</td>\n          <td>122880004 (Urine specimen obtained by clean catch procedure (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINB (Urine, Bladder Washings)</td>\n          <td>EQUIVALENT</td>\n          <td>122575003 (Urine sample)</td>\n          <td>78533007 (Irrigation of urinary bladder (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINC (Urine, Catheterized)</td>\n          <td>EQUIVALENT</td>\n          <td>446846006 (Urine specimen obtained via indwelling urinary catheter (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINM (Urine, Midstream)</td>\n          <td>EQUIVALENT</td>\n          <td>258574006 (Mid-stream urine sample (specimen))</td>\n          <td>225271002 (Collection of mid-stream specimen of urine (procedure))</td>\n          <td>431938005 (Structure of urinary tract proper (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINN (Urine, Nephrostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>446277003 (Urine specimen obtained from nephrostomy tube after percutaneous insertion (specimen))</td>\n          <td>225109005 (Collection of nephrostomy urine specimen (procedure))</td>\n          <td>25990002 (Renal pelvis structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINP (Urine, Pedibag)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>URT (Urine catheter)</td>\n          <td>EQUIVALENT</td>\n          <td>122565001 (Urinary catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>USCOP (Urine, Cystoscopy)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td>176178006 (Diagnostic cystoscopy (procedure))</td>\n          <td>89837001 (Urinary bladder structure (body structure))</td>\n          <td/>\n          <td>NEW specimenTERM 7</td>\n        </tr>\n        <tr>\n          <td>USPEC (Source, Unspecified)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>VASTIP (Catheter Tip, Vas)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>VENT (Catheter Tip, Ventricular)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>VITF (Vitreous Fluid)</td>\n          <td>EQUIVALENT</td>\n          <td>258438000 (Vitreous humor sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>VOM (Vomitus)</td>\n          <td>EQUIVALENT</td>\n          <td>122572000 (Vomitus specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WASH (Wash)</td>\n          <td>EQUIVALENT</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WASI (Washing, e.g. bronchial washing)</td>\n          <td>EQUIVALENT</td>\n          <td>122609004 (Specimen from lung obtained by bronchial washing procedure (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WAT (Water)</td>\n          <td>EQUIVALENT</td>\n          <td>119318008 (Water specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WB (Blood, Whole)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Bloodbanking term ONLY now map to blood and the respective preservative</td>\n        </tr>\n        <tr>\n          <td>WEN (Wen)</td>\n          <td>EQUIVALENT</td>\n          <td>309075001 (Skin cyst sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WICK (Wick)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>WND (Wound)</td>\n          <td>EQUIVALENT</td>\n          <td>119365002 (Specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WNDA (Wound abscess)</td>\n          <td>EQUIVALENT</td>\n          <td>119366001 (Specimen from wound abscess (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WNDD (Wound drainage)</td>\n          <td>EQUIVALENT</td>\n          <td>122566000 (Fluid specimen from wound (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WNDE (Wound exudate)</td>\n          <td>EQUIVALENT</td>\n          <td>122568004 (Exudate specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WORM (Worm)</td>\n          <td>EQUIVALENT</td>\n          <td>258618008 (Helminth sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WRT (Wart)</td>\n          <td>EQUIVALENT</td>\n          <td>309068002 (Skin lesion sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WWA (Environmental, Water)</td>\n          <td>EQUIVALENT</td>\n          <td>119318008 (Water specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WWO (Environmental, Water (Ocean))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>WWT (Environmental, Water  (Tap))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>CSITE (Catheter Insertion Site)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td>386144009 (Line insertion site (morphologic abnormality))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>119295008 (Aspirate)</td>\n          <td>Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora</td>\n        </tr>\n        <tr>\n          <td>CLIPP (Clippings)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>119326000 (Hair specimen (specimen))</td>\n          <td>Be more specific use either: 119326000^hair specimen, or 119327009^nail specimen</td>\n        </tr>\n        <tr>\n          <td>SHU (Site, Shunt)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td>257351008 (Shunt (physical object))</td>\n          <td/>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td>assume swab from shunt site for mapping here - clean surface of skin prior to expressing the shunt site - preferred is aspiration with sterile syringe should use SPM.8 to specify body approximate match location of shunt site</td>\n        </tr>\n      </table>\n    </div>",
        "status": "generated"
    },
    "url": "http://hl7.org/fhir/conceptmap-example-specimen-type.html",
    "version": "20130725"
};

var example86: fhir.ConceptMap = {
    "resourceType": "ConceptMap",
    "id": "102",
    "text": {
        "status": "generated",
        "div": "<div>\n      <h2>Specimen mapping from v2 table 0487 to SNOMED CT (http://hl7.org/fhir/conceptmap-example-specimen-type.html)</h2>\n      <p>Mapping from \n        <a href=\"v2/0487/index.html\">http://hl7.org/fhir/v2/vs/0487</a> to \n        <a href=\"http://snomed.info/id\">SNOMED-CT</a>\n      </p>\n      <p>DRAFT. Published on Jul 25, 2013 by FHIR project team (original source: LabMCoP) (\n        <a href=\"http://hl7.org/fhir\">http://hl7.org/fhir</a>; , \n        <a href=\"http://www.phconnect.org/group/laboratorymessagingcommunityofpractice/forum/attachment/download?id=3649725%3AUploadedFile%3A145786\">http://www.phconnect.org/group...</a>; ). \n      </p>\n      <br/>\n      <table class=\"grid\">\n        <tr>\n          <td colspan=\"1\">\n            <b>Source Concept</b>\n          </td>\n          <td>\n            <b>Equivalence</b>\n          </td>\n          <td colspan=\"4\">\n            <b>Destination Concept</b>\n          </td>\n          <td>\n            <b>Comments</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <b>Code [http://hl7.org/fhir/v2/0487]</b>\n          </td>\n          <td/>\n          <td>\n            <b>Code [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-7 [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-8 [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-5 [http://snomed.info/sct]</b>\n          </td>\n          <td/>\n        </tr>\n        <tr>\n          <td>ACNE (Tissue, Acne)</td>\n          <td>EQUIVALENT</td>\n          <td>309068002 (Skin lesion sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ACNFLD (Fluid, Acne)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td>HL7 term is a historical term. mapped to Pus</td>\n        </tr>\n        <tr>\n          <td>AIRS (Air Sample)</td>\n          <td>EQUIVALENT</td>\n          <td>446302006 (Air sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ALL (Allograft)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>7970006 (Allograft)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>AMP (Amputation)</td>\n          <td>EQUIVALENT</td>\n          <td>408654003 (Specimen obtained by amputation)</td>\n          <td>81723002 (Amputation)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ANGI (Catheter Tip, Angio)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ARTC (Catheter Tip, Arterial)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ASERU (Serum, Acute)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>ASP (Aspirate)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ATTE (Environment, Attest)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>AUTOC (Environmental, Autoclave Capsule)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>AUTP (Autopsy)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This really is not a specimen per se - it is the state of the subject from whom the specimen is collected, so it should be used as a  specimen type modifier ONLY!. Often this is indicated with a special medical record number or other notation on the patient. needs to have specimen type (SPM-4) and source site (SPM.8) and spatial orientation (SPM.9)</td>\n        </tr>\n        <tr>\n          <td>BBL (Blood bag)</td>\n          <td>EQUIVALENT</td>\n          <td>119304001 (Blood bag specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BCYST (Cyst, Baker's)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td>32361000 (Popliteal fossa structure (body structure))</td>\n          <td/>\n          <td>submitted (PLR155) with parent of  167874004^knee joint synovial fluid (specimen), with specimen source topography 32361000^Popliteal fossa structure (body structure)</td>\n        </tr>\n        <tr>\n          <td>BITE (Bite)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>BLEB (Bleb)</td>\n          <td>EQUIVALENT</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BLIST (Blister)</td>\n          <td>EQUIVALENT</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BOIL (Boil)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>59843005 (Furuncle (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BON (Bone)</td>\n          <td>EQUIVALENT</td>\n          <td>430268003 (Specimen from bone (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BOWL (Bowel contents)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Don't use this term for human samples - use Stool instead. animal would use small intestinal contents, large intestinal contents</td>\n        </tr>\n        <tr>\n          <td>BPU (Blood product unit)</td>\n          <td>EQUIVALENT</td>\n          <td>119300005 (Specimen from blood product (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRN (Burn)</td>\n          <td>EQUIVALENT</td>\n          <td>119367005 (Specimen from burn injury (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRSH (Brush)</td>\n          <td>EQUIVALENT</td>\n          <td>258415003 (Biopsy sample (specimen))</td>\n          <td>439336003 (Brush biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRTH (Breath (use EXHLD))</td>\n          <td>EQUIVALENT</td>\n          <td>119336008 (Exhaled air specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRUS (Brushing)</td>\n          <td>EQUIVALENT</td>\n          <td>309176002 (Bronchial brushings sample (specimen))</td>\n          <td>80657008 (Bronchoscopy with brush biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BUB (Bubo)</td>\n          <td>EQUIVALENT</td>\n          <td>302795002 (Lymph node aspirate (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>11585000 (Bubo (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BULLA (Bulla/Bullae)</td>\n          <td>EQUIVALENT</td>\n          <td>258482009 (Vesicle fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BX (Biopsy)</td>\n          <td>EQUIVALENT</td>\n          <td>258415003 (Biopsy sample (specimen))</td>\n          <td>86273004 (Biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CALC (Calculus (=Stone))</td>\n          <td>EQUIVALENT</td>\n          <td>119350003 (Calculus specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CARBU (Carbuncle)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>41570003 (Carbuncle (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>CAT (Catheter)</td>\n          <td>EQUIVALENT</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CBITE (Bite, Cat)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>CLIPP (Clippings)</td>\n          <td>EQUIVALENT</td>\n          <td>119327009 (Nail specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>Be more specific use either: 119326000^hair specimen or 119327009^nail specimen</td>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>EQUIVALENT</td>\n          <td>119401005 (Specimen from conjunctiva (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>EQUIVALENT</td>\n          <td>128160006 (Tissue specimen from conjunctiva (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>EQUIVALENT</td>\n          <td>258498002 (Conjunctival swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>COL (Colostrum)</td>\n          <td>EQUIVALENT</td>\n          <td>119329007 (Colostrum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CONE (Biospy, Cone)</td>\n          <td>EQUIVALENT</td>\n          <td>399713008 (Specimen from uterine cervix obtained by cone biopsy (specimen))</td>\n          <td>54535009 (Cone biopsy of cervix (procedure))</td>\n          <td>71252005 (Cervix uteri structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CSCR (Scratch, Cat)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>submit for new term with parent 119365002^Specimen from wound (specimen)</td>\n        </tr>\n        <tr>\n          <td>CSERU (Serum, Convalescent)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>CSITE (Catheter Insertion Site)</td>\n          <td>EQUIVALENT</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td>285570007 (Taking of swab (procedure))</td>\n          <td/>\n          <td>386144009 (Line insertion site (morphologic abnormality))</td>\n          <td>Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora       </td>\n        </tr>\n        <tr>\n          <td>CSMY (Fluid,  Cystostomy Tube)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CST (Fluid, Cyst)</td>\n          <td>EQUIVALENT</td>\n          <td>258453008 (Cyst fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CSVR (Blood, Cell Saver)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD - may use blood and SPM-6</td>\n        </tr>\n        <tr>\n          <td>CTP (Catheter tip)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>CVPS (Site, CVP)</td>\n          <td>EQUIVALENT</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CVPT (Catheter Tip, CVP)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>445085009 (Tunneled central venous catheter (physical object))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>CYN (Nodule, Cystic)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td>27925004 (Nodule (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>CYST (Cyst)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DBITE (Bite, Dog)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>DCS (Sputum, Deep Cough)</td>\n          <td>EQUIVALENT</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DEC (Ulcer, Decubitus)</td>\n          <td>EQUIVALENT</td>\n          <td>258505006 (Skin ulcer swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DEION (Environmental, Water  (Deionized))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>DIA (Dialysate)</td>\n          <td>EQUIVALENT</td>\n          <td>119360007 (Dialysis fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DISCHG (Discharge)</td>\n          <td>EQUIVALENT</td>\n          <td>258439008 (Discharge specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DIV (Diverticulum)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>31113003 (Diverticulum (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>DRN (Drain)</td>\n          <td>EQUIVALENT</td>\n          <td>119306004 (Drain device specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DRNG (Drainage, Tube)</td>\n          <td>EQUIVALENT</td>\n          <td>258455001 (Drainage fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: not an acceptible specimen for micro - not specific enough term</td>\n        </tr>\n        <tr>\n          <td>DRNGP (Drainage, Penrose)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>EARW (Ear wax (cerumen))</td>\n          <td>EQUIVALENT</td>\n          <td>122580007 (Cerumen specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EBRUSH (Brush, Esophageal)</td>\n          <td>EQUIVALENT</td>\n          <td>309210009 (Esophageal brushings sample (specimen))</td>\n          <td>36213007 (Endoscopy and brush biopsy (procedure))</td>\n          <td>32849002 (Esophageal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EEYE (Environmental, Eye Wash)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EFF (Environmental, Effluent)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EFFUS (Effusion)</td>\n          <td>EQUIVALENT</td>\n          <td>258440005 (Effusion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EFOD (Environmental, Food)</td>\n          <td>EQUIVALENT</td>\n          <td>119320006 (Food specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EISO (Environmental, Isolette)</td>\n          <td>EQUIVALENT</td>\n          <td>258536003 (Incubator swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ELT (Electrode)</td>\n          <td>EQUIVALENT</td>\n          <td>119314005 (Electrode specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ENVIR (Environmental, Unidentified Substance)</td>\n          <td>EQUIVALENT</td>\n          <td>119324002 (Specimen of unknown material (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EOTH (Environmental, Other Substance)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ESOI (Environmental, Soil)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ESOS (Environmental, Solution (Sterile))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ETA (Aspirate,  Endotrach)</td>\n          <td>EQUIVALENT</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>321667001 (Respiratory tract)</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ETTP (Catheter Tip, Endotracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ETTUB (Tube, Endotracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>321667001 (Respiratory tract)</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EWHI (Environmental, Whirlpool)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EXG (Gas, exhaled (=breath))</td>\n          <td>EQUIVALENT</td>\n          <td>119336008 (Exhaled air specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EXS (Shunt, External)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EXUDTE (Exudate)</td>\n          <td>EQUIVALENT</td>\n          <td>258441009 (Exudate sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FAW (Environmental, Water  (Well))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>FBLOOD (Blood, Fetal)</td>\n          <td>EQUIVALENT</td>\n          <td>119297000 (Blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td>303112003 (Fetal period (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>FGA (Fluid,  Abdomen)</td>\n          <td>EQUIVALENT</td>\n          <td>168139001 (Peritoneal fluid sample (specimen))</td>\n          <td/>\n          <td>83670000 (Peritoneal cavity structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FIST (Fistula)</td>\n          <td>EQUIVALENT</td>\n          <td>119370009 (Specimen from fistula (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLD (Fluid, Other)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLT (Filter)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>FLU (Fluid, Body unsp)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLUID (Fluid)</td>\n          <td>EQUIVALENT</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FOLEY (Catheter Tip, Foley)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>FRS (Fluid, Respiratory)</td>\n          <td>EQUIVALENT</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td>272626006 (Respiratory organ (body structure))</td>\n          <td/>\n          <td>this term is not specific enough, choose from terms that more accurately describe the specimen</td>\n        </tr>\n        <tr>\n          <td>FSCLP (Scalp, Fetal)</td>\n          <td>EQUIVALENT</td>\n          <td>309502007 (Fetus specimen (specimen))</td>\n          <td/>\n          <td>41695006 (Scalp structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FUR (Furuncle)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td/>\n          <td/>\n          <td>59843005 (Furuncle (morphologic abnormality))</td>\n          <td>Further describe the sample as tissue or pus. or by the collection method. The term boil is not specifc to a body site - need to indicate source site (spm.8). preferred term is Aspirate_Boil</td>\n        </tr>\n        <tr>\n          <td>GAS (Gas)</td>\n          <td>EQUIVALENT</td>\n          <td>119317003 (Gaseous material specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASA (Aspirate, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>168137004 (Gastric aspirate sample (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASAN (Antrum, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>119379005 (Specimen from stomach (specimen))</td>\n          <td/>\n          <td>66051006 (Pyloric antrum structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASBR (Brushing, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>309213006 (Gastric brushings sample (specimen))</td>\n          <td>235157009 (Endoscopic brushings of gastrointestinal tract (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASD (Drainage, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>GAST (Fluid/contents, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GENV (Genital vaginal)</td>\n          <td>EQUIVALENT</td>\n          <td>119394009 (Specimen from vagina)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GRAFT (Graft)</td>\n          <td>EQUIVALENT</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GRANU (Granuloma)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>45647009 (Granuloma (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>GROSH (Catheter, Groshong)</td>\n          <td>EQUIVALENT</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>GSOL (Solution, Gastrostomy)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>GSPEC (Biopsy, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>309211008 (Gastric biopsy sample (specimen))</td>\n          <td>79121003 (Biopsy of stomach (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GT (Tube, Gastric)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>GTUBE (Drainage Tube, Drainage (Gastrostomy))</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td>127490009 (Gastrostomy route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>HBITE (Bite, Human)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>HBLUD (Blood, Autopsy)</td>\n          <td>EQUIVALENT</td>\n          <td>119297000 (Blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td>303113008 (Postmortem period (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>HEMAQ (Catheter Tip, Hemaquit)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HEMO (Catheter Tip, Hemovac)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HERNI (Tissue, Herniated)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>HEV (Drain, Hemovac)</td>\n          <td>EQUIVALENT</td>\n          <td>119306004 (Drain device specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>HIC (Catheter, Hickman)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>445085009 (Tunneled central venous catheter (physical object))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HYDC (Fluid, Hydrocele)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>55434001 (Hydrocele (disorder))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>IBITE (Bite, Insect)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>ICYST (Cyst, Inclusion)</td>\n          <td>EQUIVALENT</td>\n          <td>309075001 (Skin cyst sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IDC (Catheter Tip, Indwelling)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IHG (Gas, Inhaled)</td>\n          <td>EQUIVALENT</td>\n          <td>119337004 (Inhaled gas specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ILEO (Drainage, Ileostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>258455001 (Drainage fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>419954003 (Ileostomy route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>ILLEG (Source of Specimen Is Illegible)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>IMP (Implant)</td>\n          <td>EQUIVALENT</td>\n          <td>439961009 (Implant submitted as specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INCI (Site, Incision/Surgical)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INFIL (Infiltrate)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This describes a morphologic abnormality, not a sample</td>\n        </tr>\n        <tr>\n          <td>INS (Insect)</td>\n          <td>EQUIVALENT</td>\n          <td>258614005 (Insect sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INTRD (Catheter Tip, Introducer)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IT (Intubation tube)</td>\n          <td>EQUIVALENT</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IUD (Intrauterine Device)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>IVCAT (Catheter Tip, IV)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>255560000 (Intravenous (qualifier value))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IVFLD (Fluid, IV)</td>\n          <td>EQUIVALENT</td>\n          <td>258649003 (Intravenous infusion fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IVTIP (Tubing Tip, IV)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>JEJU (Drainage, Jejunal)</td>\n          <td>EQUIVALENT</td>\n          <td>258463000 (Jejunal fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>21306003 (Jejunal structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>JNTFLD (Fluid, Joint)</td>\n          <td>EQUIVALENT</td>\n          <td>119332005 (Synovial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>JP (Drainage, Jackson Pratt)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>KELOI (Lavage)</td>\n          <td>EQUIVALENT</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td>67889009 (Lavage)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>KIDFLD (Fluid, Kidney)</td>\n          <td>EQUIVALENT</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVG (Lavage, Bronhial)</td>\n          <td>EQUIVALENT</td>\n          <td>258607008 (Bronchoalveolar lavage fluid sample (specimen))</td>\n          <td>397394009 (Bronchoalveolar lavage (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVGG (Lavage, Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>168138009 (Gastric lavage aspirate sample)</td>\n          <td>173830003 (Gastric lavage (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVGP (Lavage, Peritoneal)</td>\n          <td>EQUIVALENT</td>\n          <td>440137008 (Specimen obtained by peritoneal lavage (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVPG (Lavage, Pre-Bronch)</td>\n          <td>EQUIVALENT</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td>67889009 (Lavage)</td>\n          <td>44567001 (Tracheal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LENS1 (Contact Lens)</td>\n          <td>EQUIVALENT</td>\n          <td>440473005 (Contact lens submitted as specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LENS2 (Contact Lens Case)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>LESN (Lesion)</td>\n          <td>EQUIVALENT</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>should be more specific what kind of lesion is observed - be more specific is it a wound, abscess, mass - specify! Ask SNOMED CT to mark it as a grouper term only (309049000)</td>\n        </tr>\n        <tr>\n          <td>LIQ (Liquid, Unspecified)</td>\n          <td>EQUIVALENT</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LIQO (Liquid, Other)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>LSAC (Fluid, Lumbar Sac)</td>\n          <td>EQUIVALENT</td>\n          <td>258450006 (Cerebrospinal fluid sample (specimen))</td>\n          <td/>\n          <td>303949008 (Lumbar spinal cerebrospinal fluid pathway (body structure))</td>\n          <td/>\n          <td>The HL7 term is a historical term Mapped to CSF obtained by lumbar puncture</td>\n        </tr>\n        <tr>\n          <td>MAHUR (Catheter Tip, Makurkour)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>MASS (Mass)</td>\n          <td>EQUIVALENT</td>\n          <td>420548004 (Specimen from mass lesion (specimen))</td>\n          <td/>\n          <td/>\n          <td>4147007 (Mass (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>MBLD (Blood, Menstrual)</td>\n          <td>EQUIVALENT</td>\n          <td>119345009 (Menstrual blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>MUCOS (Mucosa)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td>414781009 (Mucous membrane structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>MUCUS (Mucus)</td>\n          <td>EQUIVALENT</td>\n          <td>258483004 (Mucus sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NASDR (Drainage, Nasal)</td>\n          <td>EQUIVALENT</td>\n          <td>258474009 (Sinus fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>2095001 (Nasal sinus structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>NEDL (Needle)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>NEPH (Site, Nephrostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NGASP (Aspirate, Nasogastric)</td>\n          <td>EQUIVALENT</td>\n          <td>302794003 (Nasogastric aspirate (specimen))</td>\n          <td>6853008 (Nasogastric tube aspiration (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NGAST (Drainage, Nasogastric)</td>\n          <td>EQUIVALENT</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td>127492001 (Nasogastric route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>NGS (Site, Naso/Gastric)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NODUL (Nodule(s))</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>NSECR (Secretion, Nasal)</td>\n          <td>EQUIVALENT</td>\n          <td>168141000 (Nasal fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ORH (Other)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ORL (Lesion, Oral)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td>74262004 (Oral cavity)</td>\n          <td/>\n          <td>be more precise use ulcer, tumor, vesicle</td>\n        </tr>\n        <tr>\n          <td>OTH (Source, Other)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PACEM (Pacemaker)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>PCFL (Fluid, Pericardial)</td>\n          <td>EQUIVALENT</td>\n          <td>122571007 (Pericardial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PDSIT (Site, Peritoneal Dialysis)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PDTS (Site, Peritoneal Dialysis Tunnel)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>submitted for code</td>\n        </tr>\n        <tr>\n          <td>PELVA (Abscess, Pelvic)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>12921003 (Pelvic structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PENIL (Lesion, Penile)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td>18911002 (Penile structure (body structure))</td>\n          <td/>\n          <td>need to know what kind of lesion, so map to: UlcerTissue_penile, VesicleFluid_penile, Wound_penile, Mass tissue_penile, Necrotic tissue_penile, AbscessAspirate_penile, Anything else?</td>\n        </tr>\n        <tr>\n          <td>PERIA (Abscess, Perianal)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>397158004 (Perianal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PILOC (Cyst, Pilonidal)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PINS (Site, Pin)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PIS (Site, Pacemaker Insetion)</td>\n          <td>EQUIVALENT</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLAN (Plant Material)</td>\n          <td>EQUIVALENT</td>\n          <td>119301009 (Plant specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLAS (Plasma)</td>\n          <td>EQUIVALENT</td>\n          <td>119361006 (Plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLB (Plasma bag)</td>\n          <td>EQUIVALENT</td>\n          <td>119305000 (Plasma bag specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLEVS (Serum, Peak Level)</td>\n          <td>EQUIVALENT</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td>255587001 (Peak (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PND (Drainage, Penile)</td>\n          <td>EQUIVALENT</td>\n          <td>258439008 (Discharge specimen (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>13648007 (Urethral structure (body structure))</td>\n          <td/>\n          <td>Historical term -though in this case more often used for discharge</td>\n        </tr>\n        <tr>\n          <td>POL (Polyps)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>41329004 (Polyp (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPGS (Graft Site, Popliteal)</td>\n          <td>EQUIVALENT</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td>6902008 (Popliteal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPLG (Graft, Popliteal)</td>\n          <td>EQUIVALENT</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td>6902008 (Popliteal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPLV (Site, Popliteal Vein)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>PORTA (Catheter, Porta)</td>\n          <td>EQUIVALENT</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>PPP (Plasma, Platelet poor)</td>\n          <td>EQUIVALENT</td>\n          <td>119362004 (Platelet poor plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PROST (Prosthetic Device)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PRP (Plasma, Platelet rich)</td>\n          <td>EQUIVALENT</td>\n          <td>119363009 (Platelet rich plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PSC (Pseudocyst)</td>\n          <td>EQUIVALENT</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUNCT (Wound, Puncture)</td>\n          <td>EQUIVALENT</td>\n          <td>119365002 (Specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td>129300006 (Puncture - action (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUS (Pus)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUSFR (Pustule)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUST (Pus)</td>\n          <td>EQUIVALENT</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>QC3 (Quality Control)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>RANDU (Urine, Random)</td>\n          <td>EQUIVALENT</td>\n          <td>278020009 (Spot urine sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RBITE (Bite, Reptile)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent: 119365002</td>\n        </tr>\n        <tr>\n          <td>RECT (Drainage, Rectal)</td>\n          <td>EQUIVALENT</td>\n          <td>119339001 (Stool specimen (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>34402009 (Rectum structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>RECTA (Abscess, Rectal)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>34402009 (Rectum structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RENALC (Cyst, Renal)</td>\n          <td>EQUIVALENT</td>\n          <td>258420003 (Cyst tissue (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RENC (Fluid, Renal Cyst)</td>\n          <td>EQUIVALENT</td>\n          <td>258453008 (Cyst fluid sample (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RES (Respiratory)</td>\n          <td>EQUIVALENT</td>\n          <td>258603007 (Respiratory sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SAL (Saliva)</td>\n          <td>EQUIVALENT</td>\n          <td>119342007 (Saliva specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SCAR (Tissue, Keloid (Scar))</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SCLV (Catheter Tip, Subclavian)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td>9454009 (Structure of subclavian vein (body structure))</td>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SCROA (Abscess, Scrotal)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>20233005 (Scrotal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SECRE (Secretion(s))</td>\n          <td>EQUIVALENT</td>\n          <td>432825001 (Body secretion specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SER (Serum)</td>\n          <td>EQUIVALENT</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SHU (Site, Shunt)</td>\n          <td>EQUIVALENT</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>257351008 (Shunt (physical object))</td>\n          <td>Preferred is aspiration with sterile syringe from inflamed area. Specify body location of shunt site</td>\n        </tr>\n        <tr>\n          <td>SHUNF (Fluid, Shunt)</td>\n          <td>EQUIVALENT</td>\n          <td>446861007 (Cerebrospinal fluid specimen obtained via ventriculoperitoneal shunt (specimen))</td>\n          <td>446860008 (Collection of cerebrospinal fluid via ventriculoperitoneal shunt (procedure))</td>\n          <td>279107003 (Central nervous system space (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SHUNT (Shunt)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SITE (Site)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SKBP (Biopsy, Skin)</td>\n          <td>EQUIVALENT</td>\n          <td>309066003 (Skin biopsy sample (specimen))</td>\n          <td>240977001 (Biopsy of skin)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SKN (Skin)</td>\n          <td>EQUIVALENT</td>\n          <td>119325001 (Skin (tissue) specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SMM (Mass, Sub-Mandibular)</td>\n          <td>EQUIVALENT</td>\n          <td>420548004 (Specimen from mass lesion (specimen))</td>\n          <td/>\n          <td/>\n          <td>4147007 (Mass (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>SNV (Fluid, synovial (Joint fluid))</td>\n          <td>EQUIVALENT</td>\n          <td>119332005 (Synovial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPRM (Spermatozoa)</td>\n          <td>EQUIVALENT</td>\n          <td>119349003 (Spermatozoa specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPRP (Catheter Tip, Suprapubic)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SPRPB (Cathether Tip, Suprapubic)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SPS (Environmental, Spore Strip)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SPT (Sputum)</td>\n          <td>EQUIVALENT</td>\n          <td>119334006 (Sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPTC (Sputum - coughed)</td>\n          <td>EQUIVALENT</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPTT (Sputum - tracheal aspirate)</td>\n          <td>EQUIVALENT</td>\n          <td>258609006 (Sputum specimen obtained by aspiration from trachea (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPUT1 (Sputum, Simulated)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SPUTIN (Sputum, Inducted)</td>\n          <td>EQUIVALENT</td>\n          <td>258610001 (Sputum specimen obtained by sputum induction (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPUTSP (Sputum, Spontaneous)</td>\n          <td>EQUIVALENT</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>STER (Environmental, Sterrad)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>STL (Stool = Fecal)</td>\n          <td>EQUIVALENT</td>\n          <td>119339001 (Stool specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>STONE (Stone, Kidney)</td>\n          <td>EQUIVALENT</td>\n          <td>119350003 (Calculus specimen (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUBMA (Abscess, Submandibular)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>5713008 (Submandibular triangle structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUBMX (Abscess, Submaxillary)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>4335006 (Upper jaw region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUMP (Drainage, Sump)</td>\n          <td>EQUIVALENT</td>\n          <td>446562005 (Body fluid specimen obtained via sump drain (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>SUP (Suprapubic Tap)</td>\n          <td>EQUIVALENT</td>\n          <td>122575003 (Urine sample)</td>\n          <td>58088002 (Urine specimen collection, suprapubic (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUTUR (Suture)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SWGZ (Catheter Tip, Swan Gantz)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>TASP (Aspirate, Tracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>122877000 (Upper respiratory fluid specimen obtained by tracheal aspiration (specimen))</td>\n          <td>129112001 (Aspiration from trachea (procedure))</td>\n          <td>44567001 (Tracheal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TISS (Tissue)</td>\n          <td>EQUIVALENT</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TISU (Tissue ulcer)</td>\n          <td>EQUIVALENT</td>\n          <td>122593002 (Tissue specimen obtained from ulcer (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TLC (Cathether Tip, Triple Lumen)</td>\n          <td>EQUIVALENT</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>TRAC (Site, Tracheostomy)</td>\n          <td>EQUIVALENT</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TRANS (Transudate)</td>\n          <td>EQUIVALENT</td>\n          <td>258538002 (Transudate sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TSERU (Serum, Trough)</td>\n          <td>EQUIVALENT</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td>255588006 (Trough (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>TSTES (Abscess, Testicular)</td>\n          <td>EQUIVALENT</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>279572002 (Testicular structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TTRA (Aspirate, Transtracheal)</td>\n          <td>EQUIVALENT</td>\n          <td>258480001 (Transtracheal aspirate sample (specimen))</td>\n          <td>129112001 (Aspiration from trachea (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TUBES (Tubes)</td>\n          <td>EQUIVALENT</td>\n          <td>119310001 (Tube specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TUMOR (Tumor)</td>\n          <td>EQUIVALENT</td>\n          <td>258435002 (Tumor tissue sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TZANC (Smear, Tzanck)</td>\n          <td>UNMATCHED</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This is the name of a lab test. A skin sample is examined for viral inclusions.</td>\n        </tr>\n        <tr>\n          <td>UDENT (Source, Unidentified)</td>\n          <td>EQUIVALENT</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>UR (Urine)</td>\n          <td>EQUIVALENT</td>\n          <td>122575003 (Urine sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URC (Urine clean catch)</td>\n          <td>EQUIVALENT</td>\n          <td>122880004 (Urine specimen obtained by clean catch procedure (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n 