// Type definitions for Touch 2.3.1
// Project: http://www.sencha.com/products/touch/
// Definitions by: Brian Kotek <https://github.com/brian428/>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

declare module Ext {
	export interface IAbstractComponent extends Ext.IEvented {
	}
}
declare module Ext {
	export interface IAbstractManager extends Ext.IBase {
		/** [Property] (Ext.util.HashMap) */
		all?: Ext.util.IHashMap;
		/** [Method] Creates and returns an instance of whatever this manager manages based on the supplied type and config object  
		* @param config Object The config object. 
		* @param defaultType String If no type is discovered in the config object, we fall back to this type. 
		* @returns Object The instance of whatever this manager is managing. 
		*/
		create?( config?:any, defaultType?:string ): any;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. 
		*/
		each?( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item. 
		* @returns Object The item, undefined if not found. 
		*/
		get?( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		getCount?(): number;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up. 
		* @returns Boolean Whether the type is registered. 
		*/
		isRegistered?( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id. 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		onAvailable?( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed  
		* @param item Object The item to register. 
		*/
		register?( item?:any ): void;
		/** [Method] Registers a new item constructor keyed by a type key  
		* @param type String The mnemonic string by which the class may be looked up. 
		* @param cls Function The new instance class. 
		*/
		registerType?( type?:string, cls?:any ): void;
		/** [Method] Unregisters an item by removing it from this manager  
		* @param item Object The item to unregister. 
		*/
		unregister?( item?:any ): void;
	}
}
declare module Ext {
	export interface IAbstractPlugin extends Ext.IBase {
	}
}
declare module Ext {
	export interface IActionSheet extends Ext.ISheet {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Number/String) */
		bottom?: any;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Number/String) */
		height?: any;
		/** [Config Option] (Number/String) */
		left?: any;
		/** [Config Option] (Number/String) */
		right?: any;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of bottom  
		* @returns Number 
		*/
		getBottom?(): number;
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of height  
		* @returns String 
		*/
		getHeight?(): string;
		/** [Method] Returns the value of left  
		* @returns Number 
		*/
		getLeft?(): number;
		/** [Method] Returns the value of right  
		* @returns Number 
		*/
		getRight?(): number;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of bottom  
		* @param bottom Number The new value. 
		*/
		setBottom?( bottom?:number ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of height  
		* @param height String The new value. 
		*/
		setHeight?( height?:string ): void;
		/** [Method] Sets the value of left  
		* @param left Number The new value. 
		*/
		setLeft?( left?:number ): void;
		/** [Method] Sets the value of right  
		* @param right Number The new value. 
		*/
		setRight?( right?:number ): void;
	}
}
declare module Ext {
	export interface IAjax extends Ext.data.IConnection {
	}
	export class Ajax {
		/** [Property] (Boolean) */
		static autoAbort: boolean;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Aborts any outstanding request  
		* @param request Object Defaults to the last request. 
		*/
		static abort( request?:any ): void;
		/** [Method] Aborts all outstanding requests  */
		static abortAll(): void;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object  */
		static clearListeners(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		static fireAction( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of async  
		* @returns Boolean 
		*/
		static getAsync(): boolean;
		/** [Method] Returns the value of autoAbort  
		* @returns Boolean 
		*/
		static getAutoAbort(): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		static getBubbleEvents(): any;
		/** [Method] Returns the value of defaultHeaders  
		* @returns Object 
		*/
		static getDefaultHeaders(): any;
		/** [Method] Returns the value of defaultPostHeader  
		* @returns String 
		*/
		static getDefaultPostHeader(): string;
		/** [Method] Returns the value of defaultXhrHeader  
		* @returns String 
		*/
		static getDefaultXhrHeader(): string;
		/** [Method] Returns the value of disableCaching  
		* @returns Boolean 
		*/
		static getDisableCaching(): boolean;
		/** [Method] Returns the value of disableCachingParam  
		* @returns String 
		*/
		static getDisableCachingParam(): string;
		/** [Method] Returns the value of extraParams  
		* @returns Object 
		*/
		static getExtraParams(): any;
		/** [Method] Retrieves the id of this component  
		* @returns String id 
		*/
		static getId(): string;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		static getListeners(): any;
		/** [Method] Returns the value of method  
		* @returns String 
		*/
		static getMethod(): string;
		/** [Method] Returns the value of password  
		* @returns String 
		*/
		static getPassword(): string;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		static getTimeout(): number;
		/** [Method] Returns the value of url  
		* @returns String 
		*/
		static getUrl(): string;
		/** [Method] Returns the value of useDefaultHeader  
		* @returns Boolean 
		*/
		static getUseDefaultHeader(): boolean;
		/** [Method] Returns the value of useDefaultXhrHeader  
		* @returns Boolean 
		*/
		static getUseDefaultXhrHeader(): boolean;
		/** [Method] Returns the value of username  
		* @returns String 
		*/
		static getUsername(): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Determines whether this object has a request outstanding  
		* @param request Object The request to check. 
		* @returns Boolean True if there is an outstanding request. 
		*/
		static isLoading( request?:any ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static mon( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static mun( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Checks if the response status was successful  
		* @param status Number The status code. 
		* @param xhr XMLHttpRequest 
		* @returns Object An object containing success/status state. 
		*/
		static parseStatus( status?:number, xhr?:XMLHttpRequest ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		static relayEvents( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static removeListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static removeManagedListener( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Sends an HTTP request to a remote server  
		* @param options Object An object which may contain the following properties: (The options object may also contain any other property which might be needed to perform post-processing in a callback because it is passed to callback functions.) 
		* @returns Object/null The request object. This may be used to cancel the request. 
		*/
		static request( options?:any ): any;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		static resumeEvents( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of async  
		* @param async Boolean The new value. 
		*/
		static setAsync( async?:boolean ): void;
		/** [Method] Sets the value of autoAbort  
		* @param autoAbort Boolean The new value. 
		*/
		static setAutoAbort( autoAbort?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		static setBubbleEvents( bubbleEvents?:any ): void;
		/** [Method] Sets the value of defaultHeaders  
		* @param defaultHeaders Object The new value. 
		*/
		static setDefaultHeaders( defaultHeaders?:any ): void;
		/** [Method] Sets the value of defaultPostHeader  
		* @param defaultPostHeader String The new value. 
		*/
		static setDefaultPostHeader( defaultPostHeader?:string ): void;
		/** [Method] Sets the value of defaultXhrHeader  
		* @param defaultXhrHeader String The new value. 
		*/
		static setDefaultXhrHeader( defaultXhrHeader?:string ): void;
		/** [Method] Sets the value of disableCaching  
		* @param disableCaching Boolean The new value. 
		*/
		static setDisableCaching( disableCaching?:boolean ): void;
		/** [Method] Sets the value of disableCachingParam  
		* @param disableCachingParam String The new value. 
		*/
		static setDisableCachingParam( disableCachingParam?:string ): void;
		/** [Method] Sets the value of extraParams  
		* @param extraParams Object The new value. 
		*/
		static setExtraParams( extraParams?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		static setListeners( listeners?:any ): void;
		/** [Method] Sets the value of method  
		* @param method String The new value. 
		*/
		static setMethod( method?:string ): void;
		/** [Method] Sets various options such as the url params for the request  
		* @param options Object The initial options. 
		* @param scope Object The scope to execute in. 
		* @returns Object The params for the request. 
		*/
		static setOptions( options?:any, scope?:any ): any;
		/** [Method] Sets the value of password  
		* @param password String The new value. 
		*/
		static setPassword( password?:string ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		static setTimeout( timeout?:number ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		static setUrl( url?:string ): void;
		/** [Method] Sets the value of useDefaultHeader  
		* @param useDefaultHeader Boolean The new value. 
		*/
		static setUseDefaultHeader( useDefaultHeader?:boolean ): void;
		/** [Method] Sets the value of useDefaultXhrHeader  
		* @param useDefaultXhrHeader Boolean The new value. 
		*/
		static setUseDefaultXhrHeader( useDefaultXhrHeader?:boolean ): void;
		/** [Method] Sets the value of username  
		* @param username String The new value. 
		*/
		static setUsername( username?:string ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends the firing of all events  */
		static suspendEvents(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static un( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Uploads a form using a hidden iframe  
		* @param form String/HTMLElement/Ext.Element The form to upload. 
		* @param url String The url to post to. 
		* @param params String Any extra parameters to pass. 
		* @param options Object The initial options. 
		*/
		static upload( form?:any, url?:string, params?:string, options?:any ): void;
	}
}
declare module Ext {
	export interface IAnim extends Ext.IBase {
	}
	export class Anim {
		/** [Config Option] (Function) */
		static after: any;
		/** [Config Option] (Boolean) */
		static autoClear: boolean;
		/** [Config Option] (Function) */
		static before: any;
		/** [Config Option] (Number) */
		static delay: number;
		/** [Config Option] (String) */
		static direction: string;
		/** [Config Option] (Boolean) */
		static disableAnimations: boolean;
		/** [Config Option] (Number) */
		static duration: number;
		/** [Config Option] (String) */
		static easing: string;
		/** [Config Option] (Object) */
		static from: any;
		/** [Config Option] (Boolean) */
		static out: boolean;
		/** [Config Option] (Boolean) */
		static reverse: boolean;
		/** [Config Option] (Object) */
		static scope: any;
		/** [Config Option] (Object) */
		static to: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param el Object 
		* @param runConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( el?:any, runConfig?:any ): any;
		/** [Method] Used to run an animation on a specific element  
		* @param el Ext.Element/HTMLElement The element to animate. 
		* @param anim String The animation type, defined in Ext.anims. 
		* @param config Object The config object for the animation. 
		*/
		static run( el?:any, anim?:string, config?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext {
	export interface IAnimationQueue extends Ext.IBase {
	}
	export class AnimationQueue {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method]  
		* @param fn Function 
		* @param scope Object 
		* @param args Object 
		*/
		static start( fn?:any, scope?:any, args?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method]  
		* @param fn Function 
		* @param scope Object 
		* @param args Object 
		*/
		static stop( fn?:any, scope?:any, args?:any ): void;
	}
}
declare module Ext {
	export interface IAnims {
	}
	export class Anims {
		/** [Property] (Object) */
		static cube: any;
		/** [Property] (Object) */
		static fade: any;
		/** [Property] (Object) */
		static flip: any;
		/** [Property] (Object) */
		static pop: any;
		/** [Property] (Object) */
		static slide: any;
		/** [Property] (Object) */
		static wipe: any;
	}
}
declare module Ext.app {
	export interface IAction extends Ext.IBase {
		/** [Config Option] (String) */
		action?: string;
		/** [Config Option] (Ext.app.Application) */
		application?: Ext.app.IApplication;
		/** [Config Option] (Array) */
		args?: any[];
		/** [Config Option] (Array) */
		beforeFilters?: any[];
		/** [Config Option] (Ext.app.Controller) */
		controller?: Ext.app.IController;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Starts execution of this Action by calling each of the beforeFilters in turn if any are specified  before calling t  */
		execute?(): void;
		/** [Method] Returns the value of action  
		* @returns String 
		*/
		getAction?(): string;
		/** [Method] Returns the value of application  
		* @returns Ext.app.Application 
		*/
		getApplication?(): Ext.app.IApplication;
		/** [Method] Returns the value of args  
		* @returns Array 
		*/
		getArgs?(): any[];
		/** [Method] Returns the value of beforeFilters  
		* @returns Array 
		*/
		getBeforeFilters?(): any[];
		/** [Method] Returns the value of controller  
		* @returns Ext.app.Controller 
		*/
		getController?(): Ext.app.IController;
		/** [Method] Returns the value of data  
		* @returns Object 
		*/
		getData?(): any;
		/** [Method] Returns the value of scope  
		* @returns Object 
		*/
		getScope?(): any;
		/** [Method] Returns the value of title  
		* @returns Object 
		*/
		getTitle?(): any;
		/** [Method] Returns the value of url  
		* @returns String 
		*/
		getUrl?(): string;
		/** [Method] Resumes the execution of this Action or starts it if it had not been started already */
		resume?(): void;
		/** [Method] Sets the value of action  
		* @param action String The new value. 
		*/
		setAction?( action?:string ): void;
		/** [Method] Sets the value of application  
		* @param application Ext.app.Application The new value. 
		*/
		setApplication?( application?:Ext.app.IApplication ): void;
		/** [Method] Sets the value of args  
		* @param args Array The new value. 
		*/
		setArgs?( args?:any[] ): void;
		/** [Method] Sets the value of beforeFilters  
		* @param beforeFilters Array The new value. 
		*/
		setBeforeFilters?( beforeFilters?:any[] ): void;
		/** [Method] Sets the value of controller  
		* @param controller Ext.app.Controller The new value. 
		*/
		setController?( controller?:Ext.app.IController ): void;
		/** [Method] Sets the value of data  
		* @param data Object The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Sets the value of scope  
		* @param scope Object The new value. 
		*/
		setScope?( scope?:any ): void;
		/** [Method] Sets the value of title  
		* @param title Object The new value. 
		*/
		setTitle?( title?:any ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
	}
}
declare module Ext.app {
	export interface IApplication extends Ext.app.IController {
		/** [Config Option] (String) */
		appFolder?: string;
		/** [Config Option] (Array) */
		controllers?: any[];
		/** [Config Option] (Ext.app.Profile) */
		currentProfile?: Ext.app.IProfile;
		/** [Config Option] (Boolean) */
		glossOnIcon?: boolean;
		/** [Config Option] (Ext.app.History) */
		history?: Ext.app.IHistory;
		/** [Config Option] (String/Object) */
		icon?: any;
		/** [Config Option] (Boolean) */
		isIconPrecomposed?: boolean;
		/** [Config Option] (Function) */
		launch?: any;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (String) */
		phoneIcon?: string;
		/** [Config Option] (String) */
		phoneStartupScreen?: string;
		/** [Config Option] (Array) */
		profiles?: any[];
		/** [Config Option] (String[]) */
		requires?: string[];
		/** [Config Option] (Ext.app.Router) */
		router?: Ext.app.IRouter;
		/** [Config Option] (Object) */
		startupImage?: any;
		/** [Config Option] (String) */
		statusBarStyle?: string;
		/** [Config Option] (String) */
		tabletIcon?: string;
		/** [Config Option] (String) */
		tabletStartupScreen?: string;
		/** [Config Option] (String/Function) */
		themeVariation?: any;
		/** [Config Option] (String) */
		themeVariationPrefix?: string;
		/** [Config Option] (String) */
		themeVariationTransitionCls?: string;
		/** [Method] Dispatches a given Ext app Action to the relevant Controller instance  
		* @param action Ext.app.Action The action to dispatch. 
		* @param addToHistory Boolean Sets the browser's url to the action's url. 
		*/
		dispatch?( action?:Ext.app.IAction, addToHistory?:boolean ): void;
		/** [Method] Returns the value of appFolder  
		* @returns String 
		*/
		getAppFolder?(): string;
		/** [Method] Returns the Controller instance for the given controller name  
		* @param name String The name of the Controller. 
		* @param profileName String Optional profile name. If passed, this is the same as calling getController('profileName.controllerName'). 
		* @returns Ext.app.Controller controller instance or undefined. 
		*/
		getController?( name?:string, profileName?:string ): Ext.app.IController;
		/** [Method] Returns the value of controllers  
		* @returns Array 
		*/
		getControllers?(): any[];
		/** [Method] Returns the value of currentProfile  
		* @returns Ext.app.Profile 
		*/
		getCurrentProfile?(): Ext.app.IProfile;
		/** [Method] Returns the value of history  
		* @returns Ext.app.History 
		*/
		getHistory?(): Ext.app.IHistory;
		/** [Method] Returns the value of launch  
		* @returns Function 
		*/
		getLaunch?(): any;
		/** [Method] Returns the value of name  
		* @returns String 
		*/
		getName?(): string;
		/** [Method] Returns the value of profiles  
		* @returns Array 
		*/
		getProfiles?(): any[];
		/** [Method] Returns the value of requires  
		* @returns String[] 
		*/
		getRequires?(): string[];
		/** [Method] Returns the value of router  
		* @returns Ext.app.Router 
		*/
		getRouter?(): Ext.app.IRouter;
		/** [Method] Returns the value of themeVariation  
		* @returns String/Function 
		*/
		getThemeVariation?(): any;
		/** [Method] Returns the value of themeVariationPrefix  
		* @returns String 
		*/
		getThemeVariationPrefix?(): string;
		/** [Method] Returns the value of themeVariationTransitionCls  
		* @returns String 
		*/
		getThemeVariationTransitionCls?(): string;
		/** [Method] Redirects the browser to the given url  
		* @param url String/Ext.data.Model The String url to redirect to. 
		*/
		redirectTo?( url?:any ): void;
		/** [Method] Sets the value of appFolder  
		* @param appFolder String The new value. 
		*/
		setAppFolder?( appFolder?:string ): void;
		/** [Method] Sets the value of controllers  
		* @param controllers Array The new value. 
		*/
		setControllers?( controllers?:any[] ): void;
		/** [Method] Sets the value of currentProfile  
		* @param currentProfile Ext.app.Profile The new value. 
		*/
		setCurrentProfile?( currentProfile?:Ext.app.IProfile ): void;
		/** [Method] Sets the value of history  
		* @param history Ext.app.History The new value. 
		*/
		setHistory?( history?:Ext.app.IHistory ): void;
		/** [Method] Sets the value of launch  
		* @param launch Function The new value. 
		*/
		setLaunch?( launch?:any ): void;
		/** [Method] Sets the value of name  
		* @param name String The new value. 
		*/
		setName?( name?:string ): void;
		/** [Method] Sets the value of profiles  
		* @param profiles Array The new value. 
		*/
		setProfiles?( profiles?:any[] ): void;
		/** [Method] Sets the value of requires  
		* @param requires String[] The new value. 
		*/
		setRequires?( requires?:string[] ): void;
		/** [Method] Sets the value of router  
		* @param router Ext.app.Router The new value. 
		*/
		setRouter?( router?:Ext.app.IRouter ): void;
		/** [Method] Sets the value of themeVariation  
		* @param themeVariation String/Function The new value. 
		*/
		setThemeVariation?( themeVariation?:any ): void;
		/** [Method] Sets the value of themeVariationPrefix  
		* @param themeVariationPrefix String The new value. 
		*/
		setThemeVariationPrefix?( themeVariationPrefix?:string ): void;
		/** [Method] Sets the value of themeVariationTransitionCls  
		* @param themeVariationTransitionCls String The new value. 
		*/
		setThemeVariationTransitionCls?( themeVariationTransitionCls?:string ): void;
	}
}
declare module Ext.app {
	export interface IController extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Ext.app.Application) */
		application?: Ext.app.IApplication;
		/** [Config Option] (Object) */
		before?: any;
		/** [Config Option] (Object) */
		control?: any;
		/** [Config Option] (Function) */
		init?: any;
		/** [Config Option] (Function) */
		launch?: any;
		/** [Config Option] (String[]) */
		models?: string[];
		/** [Config Option] (Object) */
		refs?: any;
		/** [Config Option] (Object) */
		routes?: any;
		/** [Config Option] (String[]) */
		stores?: string[];
		/** [Config Option] (Array) */
		views?: any[];
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of application  
		* @returns Ext.app.Application 
		*/
		getApplication?(): Ext.app.IApplication;
		/** [Method] Returns the value of before  
		* @returns Object 
		*/
		getBefore?(): any;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of control  
		* @returns Object 
		*/
		getControl?(): any;
		/** [Method] Returns a reference to another Controller  
		* @param controllerName String 
		* @param profile String 
		* @returns Object 
		*/
		getController?( controllerName?:string, profile?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns a reference to a Model  
		* @param modelName String 
		* @returns Object 
		*/
		getModel?( modelName?:string ): any;
		/** [Method] Returns the value of models  
		* @returns String[] 
		*/
		getModels?(): string[];
		/** [Method] Returns the value of refs  
		* @returns Object 
		*/
		getRefs?(): any;
		/** [Method] Returns the value of routes  
		* @returns Object 
		*/
		getRoutes?(): any;
		/** [Method] Returns the value of stores  
		* @returns String[] 
		*/
		getStores?(): string[];
		/** [Method] Returns the value of views  
		* @returns Array 
		*/
		getViews?(): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Convenient way to redirect to a new url  
		* @param place Object 
		* @returns Object 
		*/
		redirectTo?( place?:any ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of application  
		* @param application Ext.app.Application The new value. 
		*/
		setApplication?( application?:Ext.app.IApplication ): void;
		/** [Method] Sets the value of before  
		* @param before Object The new value. 
		*/
		setBefore?( before?:any ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of control  
		* @param control Object The new value. 
		*/
		setControl?( control?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of models  
		* @param models String[] The new value. 
		*/
		setModels?( models?:string[] ): void;
		/** [Method] Sets the value of refs  
		* @param refs Object The new value. 
		*/
		setRefs?( refs?:any ): void;
		/** [Method] Sets the value of routes  
		* @param routes Object The new value. 
		*/
		setRoutes?( routes?:any ): void;
		/** [Method] Sets the value of stores  
		* @param stores String[] The new value. 
		*/
		setStores?( stores?:string[] ): void;
		/** [Method] Sets the value of views  
		* @param views Array The new value. 
		*/
		setViews?( views?:any[] ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.app {
	export interface IHistory extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Array) */
		actions?: any[];
		/** [Config Option] (String) */
		token?: string;
		/** [Config Option] (Boolean) */
		updateUrl?: boolean;
		/** [Method] Adds an Action to the stack optionally updating the browser s url and firing the change event  
		* @param action Ext.app.Action The Action to add to the stack. 
		* @param silent Boolean Cancels the firing of the change event if true. 
		*/
		add?( action?:Ext.app.IAction, silent?:boolean ): void;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Navigate to the previous active action  */
		back?(): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of actions  
		* @returns Array 
		*/
		getActions?(): any[];
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of token  
		* @returns String 
		*/
		getToken?(): string;
		/** [Method] Returns the value of updateUrl  
		* @returns Boolean 
		*/
		getUpdateUrl?(): boolean;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of actions  
		* @param actions Array The new value. 
		*/
		setActions?( actions?:any[] ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of token  
		* @param token String The new value. 
		*/
		setToken?( token?:string ): void;
		/** [Method] Sets the value of updateUrl  
		* @param updateUrl Boolean The new value. 
		*/
		setUpdateUrl?( updateUrl?:boolean ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.app {
	export interface IProfile extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Ext.app.Application) */
		application?: Ext.app.IApplication;
		/** [Config Option] (Array) */
		controllers?: any[];
		/** [Config Option] (Array) */
		models?: any[];
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (String) */
		namespace?: string;
		/** [Config Option] (Array) */
		stores?: any[];
		/** [Config Option] (Array) */
		views?: any[];
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of application  
		* @returns Ext.app.Application 
		*/
		getApplication?(): Ext.app.IApplication;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of controllers  
		* @returns Array 
		*/
		getControllers?(): any[];
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of models  
		* @returns Array 
		*/
		getModels?(): any[];
		/** [Method] Returns the value of name  
		* @returns String 
		*/
		getName?(): string;
		/** [Method] Returns the value of namespace  
		* @returns String 
		*/
		getNamespace?(): string;
		/** [Method] Returns the value of stores  
		* @returns Array 
		*/
		getStores?(): any[];
		/** [Method] Returns the value of views  
		* @returns Array 
		*/
		getViews?(): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Determines whether or not this Profile is active on the device isActive is executed on  
		* @returns Boolean True if this Profile should be activated on the device it is running on, false otherwise 
		*/
		isActive?(): boolean;
		/** [Method] The launch function is called by the Application if this Profile s isActive function returned true  */
		launch?(): void;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of application  
		* @param application Ext.app.Application The new value. 
		*/
		setApplication?( application?:Ext.app.IApplication ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of controllers  
		* @param controllers Array The new value. 
		*/
		setControllers?( controllers?:any[] ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of models  
		* @param models Array The new value. 
		*/
		setModels?( models?:any[] ): void;
		/** [Method] Sets the value of name  
		* @param name String The new value. 
		*/
		setName?( name?:string ): void;
		/** [Method] Sets the value of namespace  
		* @param namespace String The new value. 
		*/
		setNamespace?( namespace?:string ): void;
		/** [Method] Sets the value of stores  
		* @param stores Array The new value. 
		*/
		setStores?( stores?:any[] ): void;
		/** [Method] Sets the value of views  
		* @param views Array The new value. 
		*/
		setViews?( views?:any[] ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.app {
	export interface IRoute extends Ext.IBase {
		/** [Config Option] (String) */
		action?: string;
		/** [Config Option] (Object) */
		conditions?: any;
		/** [Config Option] (String) */
		controller?: string;
		/** [Config Option] (String) */
		url?: string;
		/** [Property] (Object) */
		paramsInMatchString?: any;
		/** [Method] Returns the value of action  
		* @returns String 
		*/
		getAction?(): string;
		/** [Method] Returns the value of conditions  
		* @returns Object 
		*/
		getConditions?(): any;
		/** [Method] Returns the value of controller  
		* @returns String 
		*/
		getController?(): string;
		/** [Method] Returns the value of url  
		* @returns String 
		*/
		getUrl?(): string;
		/** [Method] Attempts to recognize a given url string and return controller action pair for it  
		* @param url String The url to recognize. 
		* @returns Object/Boolean The matched data, or false if no match. 
		*/
		recognize?( url?:string ): any;
		/** [Method] Sets the value of action  
		* @param action String The new value. 
		*/
		setAction?( action?:string ): void;
		/** [Method] Sets the value of conditions  
		* @param conditions Object The new value. 
		*/
		setConditions?( conditions?:any ): void;
		/** [Method] Sets the value of controller  
		* @param controller String The new value. 
		*/
		setController?( controller?:string ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
	}
}
declare module Ext.app {
	export interface IRouter extends Ext.IBase {
		/** [Config Option] (Object) */
		defaults?: any;
		/** [Config Option] (Array) */
		routes?: any[];
		/** [Method] Connects a url based route to a controller action pair plus additional params  
		* @param url String The url to recognize. 
		* @param params Object Additional parameters. 
		*/
		connect?( url?:string, params?:any ): void;
		/** [Method] Convenience method which just calls the supplied function with the Router instance  
		* @param fn Function The fn to call 
		*/
		draw?( fn?:any ): void;
		/** [Method] Returns the value of defaults  
		* @returns Object 
		*/
		getDefaults?(): any;
		/** [Method] Returns the value of routes  
		* @returns Array 
		*/
		getRoutes?(): any[];
		/** [Method] Recognizes a url string connected to the Router return the controller action pair plus any additional config associa  
		* @param url String The url to recognize. 
		* @returns Object/undefined If the url was recognized, the controller and action to call, else undefined. 
		*/
		recognize?( url?:string ): any;
		/** [Method] Sets the value of defaults  
		* @param defaults Object The new value. 
		*/
		setDefaults?( defaults?:any ): void;
		/** [Method] Sets the value of routes  
		* @param routes Array The new value. 
		*/
		setRoutes?( routes?:any[] ): void;
	}
}
declare module Ext {
	export interface IArray {
	}
	export class Array {
		/** [Method] Filter through an array and remove empty item as defined in Ext isEmpty  
		* @param array Array 
		* @returns Array results 
		*/
		static clean( array?:any[] ): any[];
		/** [Method] Clone a flat array without referencing the previous one  
		* @param array Array The array 
		* @returns Array The clone array 
		*/
		static clone( array?:any[] ): any[];
		/** [Method] Checks whether or not the given array contains the specified item  
		* @param array Array The array to check. 
		* @param item Object The item to look for. 
		* @returns Boolean true if the array contains the item, false otherwise. 
		*/
		static contains( array?:any[], item?:any ): boolean;
		/** [Method] Perform a set difference A B by subtracting all items in array B from array A  
		* @param arrayA Array 
		* @param arrayB Array 
		* @returns Array difference 
		*/
		static difference( arrayA?:any[], arrayB?:any[] ): any[];
		/** [Method] Iterates an array or an iterable value and invoke the given callback function for each item  
		* @param iterable Array/NodeList/Object The value to be iterated. If this argument is not iterable, the callback function is called once. 
		* @param fn Function The callback function. If it returns false, the iteration stops and this method returns the current index. 
		* @param scope Object The scope (this reference) in which the specified function is executed. 
		* @param reverse Boolean Reverse the iteration order (loop from the end to the beginning). 
		* @returns Boolean See description for the fn parameter. 
		*/
		static each( iterable?:any, fn?:any, scope?:any, reverse?:boolean ): boolean;
		/** [Method] Removes items from an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param removeCount Number The number of items to remove at index. 
		* @returns Array The array passed. 
		*/
		static erase( array?:any[], index?:number, removeCount?:number ): any[];
		/** [Method] Executes the specified function for each array element until the function returns a falsy value  
		* @param array Array 
		* @param fn Function Callback function for each item. 
		* @param scope Object Callback function scope. 
		* @returns Boolean true if no false value is returned by the callback function. 
		*/
		static every( array?:any[], fn?:any, scope?:any ): boolean;
		/** [Method] Creates a new array with all of the elements of this array for which the provided filtering function returns true  
		* @param array Array 
		* @param fn Function Callback function for each item. 
		* @param scope Object Callback function scope. 
		* @returns Array results 
		*/
		static filter( array?:any[], fn?:any, scope?:any ): any[];
		/** [Method] Recursively flattens into 1 d Array  
		* @param array Array The array to flatten 
		* @returns Array The 1-d array. 
		*/
		static flatten( array?:any[] ): any[];
		/** [Method] Iterates an array and invoke the given callback function for each item  
		* @param array Array The array to iterate. 
		* @param fn Function The callback function. 
		* @param scope Object The execution scope (this) in which the specified function is executed. 
		*/
		static forEach( array?:any[], fn?:any, scope?:any ): void;
		/** [Method] Converts a value to an array if it s not already an array returns An empty array if given value is undefined or n  
		* @param value Object The value to convert to an array if it's not already is an array. 
		* @param newReference Boolean true to clone the given array and return a new reference if necessary. 
		* @returns Array array 
		*/
		static from( value?:any, newReference?:boolean ): any[];
		/** [Method] Push an item into the array only if the array doesn t contain it yet  
		* @param array Array The array. 
		* @param item Object The item to include. 
		*/
		static include( array?:any[], item?:any ): void;
		/** [Method] Get the index of the provided item in the given array a supplement for the missing arrayPrototype indexOf in Interne  
		* @param array Array The array to check. 
		* @param item Object The item to look for. 
		* @param from Number The index at which to begin the search. 
		* @returns Number The index of item in the array (or -1 if it is not found). 
		*/
		static indexOf( array?:any[], item?:any, from?:number ): number;
		/** [Method] Inserts items in to an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param items Array The array of items to insert at index. 
		* @returns Array The array passed. 
		*/
		static insert( array?:any[], index?:number, items?:any[] ): any[];
		/** [Method] Merge multiple arrays into one with unique items that exist in all of the arrays  
		* @param array1 Array 
		* @param array2 Array 
		* @param etc Array 
		* @returns Array intersect 
		*/
		static intersect( array1?:any[], array2?:any[], etc?:any[] ): any[];
		/** [Method] Creates a new array with the results of calling a provided function on every element in this array  
		* @param array Array 
		* @param fn Function Callback function for each item. 
		* @param scope Object Callback function scope. 
		* @returns Array results 
		*/
		static map( array?:any[], fn?:any, scope?:any ): any[];
		/** [Method] Returns the maximum value in the Array  
		* @param array Array/NodeList The Array from which to select the maximum value. 
		* @param comparisonFn Function a function to perform the comparison which determines maximization. If omitted the ">" operator will be used. Note: gt = 1; eq = 0; lt = -1 
		* @returns Object maxValue The maximum value 
		*/
		static max( array?:any, comparisonFn?:any ): any;
		/** [Method] Calculates the mean of all items in the array  
		* @param array Array The Array to calculate the mean value of. 
		* @returns Number The mean. 
		*/
		static mean( array?:any[] ): number;
		/** [Method] Merge multiple arrays into one with unique items  
		* @param array1 Array 
		* @param array2 Array 
		* @param etc Array 
		* @returns Array merged 
		*/
		static merge( array1?:any[], array2?:any[], etc?:any[] ): any[];
		/** [Method] Returns the minimum value in the Array  
		* @param array Array/NodeList The Array from which to select the minimum value. 
		* @param comparisonFn Function a function to perform the comparison which determines minimization. If omitted the "&lt;" operator will be used. Note: gt = 1; eq = 0; lt = -1 
		* @returns Object minValue The minimum value. 
		*/
		static min( array?:any, comparisonFn?:any ): any;
		/** [Method] Plucks the value of a property from each item in the Array  
		* @param array Array/NodeList The Array of items to pluck the value from. 
		* @param propertyName String The property name to pluck from each element. 
		* @returns Array The value from each item in the Array. 
		*/
		static pluck( array?:any, propertyName?:string ): any[];
		/** [Method] Removes the specified item from the array if it exists  
		* @param array Array The array. 
		* @param item Object The item to remove. 
		* @returns Array The passed array itself. 
		*/
		static remove( array?:any[], item?:any ): any[];
		/** [Method] Replaces items in an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param removeCount Number The number of items to remove at index (can be 0). 
		* @param insert Array An array of items to insert at index. 
		* @returns Array The array passed. 
		*/
		static replace( array?:any[], index?:number, removeCount?:number, insert?:any[] ): any[];
		/** [Method] Returns a shallow copy of a part of an array  
		* @param array Array The array (or arguments object). 
		* @param begin Number The index at which to begin. Negative values are offsets from the end of the array. 
		* @param end Number The index at which to end. The copied items do not include end. Negative values are offsets from the end of the array. If end is omitted, all items up to the end of the array are copied. 
		* @returns Array The copied piece of the array. 
		*/
		static slice( array?:any[], begin?:number, end?:number ): any[];
		/** [Method] Executes the specified function for each array element until the function returns a truthy value  
		* @param array Array 
		* @param fn Function Callback function for each item. 
		* @param scope Object Callback function scope. 
		* @returns Boolean true if the callback function returns a truthy value. 
		*/
		static some( array?:any[], fn?:any, scope?:any ): boolean;
		/** [Method] Sorts the elements of an Array  
		* @param array Array The array to sort. 
		* @param sortFn Function The comparison function. 
		* @returns Array The sorted array. 
		*/
		static sort( array?:any[], sortFn?:any ): any[];
		/** [Method] Replaces items in an array  
		* @param array Array The Array on which to replace. 
		* @param index Number The index in the array at which to operate. 
		* @param removeCount Number The number of items to remove at index (can be 0). 
		* @returns Array An array containing the removed items. 
		*/
		static splice( array?:any[], index?:number, removeCount?:number ): any[];
		/** [Method] Calculates the sum of all items in the given array  
		* @param array Array The Array to calculate the sum value of. 
		* @returns Number The sum. 
		*/
		static sum( array?:any[] ): number;
		/** [Method] Converts any iterable numeric indices and a length property into a true array  
		* @param iterable Object the iterable object to be turned into a true Array. 
		* @param start Number a zero-based index that specifies the start of extraction. 
		* @param end Number a zero-based index that specifies the end of extraction. 
		* @returns Array 
		*/
		static toArray( iterable?:any, start?:number, end?:number ): any[];
		/** [Method] Merge multiple arrays into one with unique items  
		* @param array1 Array 
		* @param array2 Array 
		* @param etc Array 
		* @returns Array merged 
		*/
		static union( array1?:any[], array2?:any[], etc?:any[] ): any[];
		/** [Method] Returns a new array with unique items  
		* @param array Array 
		* @returns Array results 
		*/
		static unique( array?:any[] ): any[];
	}
}
declare module Ext {
	export interface IAudio extends Ext.IMedia {
		/** [Config Option] (String/String[]) */
		cls?: any;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Returns the value of cls  
		* @returns String 
		*/
		getCls?(): string;
		/** [Method] Returns the value of url  
		* @returns String 
		*/
		getUrl?(): string;
		/** [Method] Sets the value of cls  
		* @param cls String The new value. 
		*/
		setCls?( cls?:string ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
	}
}
declare module Ext {
	export interface IBase extends Ext.IClass {
		/** [Property] (Ext.Class) */
		self?: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		callOverridden?( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		callParent?( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		callSuper?( args?:any ): any;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		getInitialConfig?( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		initConfig?( instanceConfig?:any ): any;
	}
	export class Base {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method]  
		* @param args Object 
		*/
		static callParent( args?:any ): void;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns any className 
		*/
		static getName(): any;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.behavior {
	export interface IBehavior extends Ext.IBase {
	}
}
declare module Ext.behavior {
	export interface IDraggable extends Ext.behavior.IBehavior {
	}
}
declare module Ext.behavior {
	export interface IScrollable extends Ext.behavior.IBehavior {
	}
}
declare module Ext.behavior {
	export interface ITranslatable extends Ext.behavior.IBehavior {
	}
}
declare module Ext {
	export interface IBrowser extends Ext.env.IBrowser {
	}
	export class Browser {
		/** [Property] (String) */
		static engineName: string;
		/** [Property] (Ext.Version) */
		static engineVersion: Ext.IVersion;
		/** [Property] (Boolean) */
		static isSecure: boolean;
		/** [Property] (Boolean) */
		static isStrict: boolean;
		/** [Property] (String) */
		static name: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (String) */
		static userAgent: string;
		/** [Property] (Ext.Version) */
		static version: Ext.IVersion;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] A hybrid property can be either accessed as a method call for example  if Ext browser is IE 
		* @param value String The OS name to check. 
		* @returns Boolean 
		*/
		static is( value?:string ): boolean;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext {
	export interface IButton extends Ext.IComponent {
		/** [Config Option] (String) */
		autoEvent?: string;
		/** [Config Option] (String) */
		badge?: string;
		/** [Config Option] (String) */
		badgeCls?: string;
		/** [Config Option] (String) */
		badgeText?: string;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Function) */
		handler?: any;
		/** [Config Option] (String) */
		html?: string;
		/** [Config Option] (String) */
		icon?: string;
		/** [Config Option] (String) */
		iconAlign?: string;
		/** [Config Option] (String) */
		iconCls?: string;
		/** [Config Option] (String) */
		labelCls?: string;
		/** [Config Option] (String) */
		pressedCls?: string;
		/** [Config Option] (Number/Boolean) */
		pressedDelay?: any;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (String) */
		text?: string;
		/** [Config Option] (String) */
		ui?: string;
		/** [Method] Returns the value of autoEvent  
		* @returns String 
		*/
		getAutoEvent?(): string;
		/** [Method] Returns the value of badgeCls  
		* @returns String 
		*/
		getBadgeCls?(): string;
		/** [Method] Returns the value of badgeText  
		* @returns String 
		*/
		getBadgeText?(): string;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of handler  
		* @returns Function 
		*/
		getHandler?(): any;
		/** [Method] Returns the value of icon  
		* @returns String 
		*/
		getIcon?(): string;
		/** [Method] Returns the value of iconAlign  
		* @returns String 
		*/
		getIconAlign?(): string;
		/** [Method] Returns the value of iconCls  
		* @returns String 
		*/
		getIconCls?(): string;
		/** [Method] Returns the value of labelCls  
		* @returns String 
		*/
		getLabelCls?(): string;
		/** [Method] Returns the value of pressedCls  
		* @returns String 
		*/
		getPressedCls?(): string;
		/** [Method] Returns the value of pressedDelay  
		* @returns Number/Boolean 
		*/
		getPressedDelay?(): any;
		/** [Method] Returns the value of scope  
		* @returns Object 
		*/
		getScope?(): any;
		/** [Method] Returns the value of text  
		* @returns String 
		*/
		getText?(): string;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Sets the value of autoEvent  
		* @param autoEvent String The new value. 
		*/
		setAutoEvent?( autoEvent?:string ): void;
		/** [Method] Updates the badge text  
		* @param text String 
		*/
		setBadge?( text?:string ): void;
		/** [Method] Sets the value of badgeCls  
		* @param badgeCls String The new value. 
		*/
		setBadgeCls?( badgeCls?:string ): void;
		/** [Method] Sets the value of badgeText  
		* @param badgeText String The new value. 
		*/
		setBadgeText?( badgeText?:string ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of handler  
		* @param handler Function The new value. 
		*/
		setHandler?( handler?:any ): void;
		/** [Method] Sets the value of icon  
		* @param icon String The new value. 
		*/
		setIcon?( icon?:string ): void;
		/** [Method] Sets the value of iconAlign  
		* @param iconAlign String The new value. 
		*/
		setIconAlign?( iconAlign?:string ): void;
		/** [Method] Updates the icon class 
		* @param iconClass String 
		*/
		setIconClass?( iconClass?:string ): void;
		/** [Method] Sets the value of iconCls  
		* @param iconCls String The new value. 
		*/
		setIconCls?( iconCls?:string ): void;
		/** [Method] Sets the value of labelCls  
		* @param labelCls String The new value. 
		*/
		setLabelCls?( labelCls?:string ): void;
		/** [Method] Sets the value of pressedCls  
		* @param pressedCls String The new value. 
		*/
		setPressedCls?( pressedCls?:string ): void;
		/** [Method] Sets the value of pressedDelay  
		* @param pressedDelay Number/Boolean The new value. 
		*/
		setPressedDelay?( pressedDelay?:any ): void;
		/** [Method] Sets the value of scope  
		* @param scope Object The new value. 
		*/
		setScope?( scope?:any ): void;
		/** [Method] Sets the value of text  
		* @param text String The new value. 
		*/
		setText?( text?:string ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
	}
}
declare module Ext.carousel {
	export interface ICarousel extends Ext.IContainer {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String) */
		direction?: string;
		/** [Config Option] (Boolean) */
		indicator?: boolean;
		/** [Config Option] (String) */
		ui?: string;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the index of the currently active card  
		* @returns Number The index of the currently active card. 
		*/
		getActiveIndex?(): number;
		/** [Method] Returns the value of animation  
		* @returns Object 
		*/
		getAnimation?(): any;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of bufferSize  
		* @returns Number 
		*/
		getBufferSize?(): number;
		/** [Method] Returns the value of direction  
		* @returns String 
		*/
		getDirection?(): string;
		/** [Method] Returns the value of directionLock  
		* @returns Boolean 
		*/
		getDirectionLock?(): boolean;
		/** [Method] Returns the value of indicator  
		* @returns any 
		*/
		getIndicator?(): any;
		/** [Method] Returns the value of itemConfig  
		* @returns Object 
		*/
		getItemConfig?(): any;
		/** [Method] Returns the value of itemLength  
		* @returns Object 
		*/
		getItemLength?(): any;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns true when direction is horizontal 
		* @returns Boolean 
		*/
		isHorizontal?(): boolean;
		/** [Method] Returns true when direction is vertical 
		* @returns Boolean 
		*/
		isVertical?(): boolean;
		/** [Method] Switches to the next card  
		* @returns Ext.carousel.Carousel this 
		*/
		next?(): Ext.carousel.ICarousel;
		/** [Method] Switches to the previous card  
		* @returns Ext.carousel.Carousel this 
		*/
		prev?(): Ext.carousel.ICarousel;
		/** [Method] Switches to the previous card  
		* @returns Ext.carousel.Carousel this 
		*/
		previous?(): Ext.carousel.ICarousel;
		/** [Method] Sets the value of animation  
		* @param animation Object The new value. 
		*/
		setAnimation?( animation?:any ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of bufferSize  
		* @param bufferSize Number The new value. 
		*/
		setBufferSize?( bufferSize?:number ): void;
		/** [Method] Sets the value of direction  
		* @param direction String The new value. 
		*/
		setDirection?( direction?:string ): void;
		/** [Method] Sets the value of directionLock  
		* @param directionLock Boolean The new value. 
		*/
		setDirectionLock?( directionLock?:boolean ): void;
		/** [Method] Sets the value of indicator  
		* @param indicator Boolean The new value. 
		*/
		setIndicator?( indicator?:boolean ): void;
		/** [Method] Sets the value of itemConfig  
		* @param itemConfig Object The new value. 
		*/
		setItemConfig?( itemConfig?:any ): void;
		/** [Method] Sets the value of itemLength  
		* @param itemLength Object The new value. 
		*/
		setItemLength?( itemLength?:any ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
	}
}
declare module Ext {
	export interface ICarousel extends Ext.IContainer {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String) */
		direction?: string;
		/** [Config Option] (Boolean) */
		indicator?: boolean;
		/** [Config Option] (String) */
		ui?: string;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the index of the currently active card  
		* @returns Number The index of the currently active card. 
		*/
		getActiveIndex?(): number;
		/** [Method] Returns the value of animation  
		* @returns Object 
		*/
		getAnimation?(): any;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of bufferSize  
		* @returns Number 
		*/
		getBufferSize?(): number;
		/** [Method] Returns the value of direction  
		* @returns String 
		*/
		getDirection?(): string;
		/** [Method] Returns the value of directionLock  
		* @returns Boolean 
		*/
		getDirectionLock?(): boolean;
		/** [Method] Returns the value of indicator  
		* @returns any 
		*/
		getIndicator?(): any;
		/** [Method] Returns the value of itemConfig  
		* @returns Object 
		*/
		getItemConfig?(): any;
		/** [Method] Returns the value of itemLength  
		* @returns Object 
		*/
		getItemLength?(): any;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns true when direction is horizontal 
		* @returns Boolean 
		*/
		isHorizontal?(): boolean;
		/** [Method] Returns true when direction is vertical 
		* @returns Boolean 
		*/
		isVertical?(): boolean;
		/** [Method] Switches to the next card  
		* @returns Ext.carousel.Carousel this 
		*/
		next?(): Ext.carousel.ICarousel;
		/** [Method] Switches to the previous card  
		* @returns Ext.carousel.Carousel this 
		*/
		prev?(): Ext.carousel.ICarousel;
		/** [Method] Switches to the previous card  
		* @returns Ext.carousel.Carousel this 
		*/
		previous?(): Ext.carousel.ICarousel;
		/** [Method] Sets the value of animation  
		* @param animation Object The new value. 
		*/
		setAnimation?( animation?:any ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of bufferSize  
		* @param bufferSize Number The new value. 
		*/
		setBufferSize?( bufferSize?:number ): void;
		/** [Method] Sets the value of direction  
		* @param direction String The new value. 
		*/
		setDirection?( direction?:string ): void;
		/** [Method] Sets the value of directionLock  
		* @param directionLock Boolean The new value. 
		*/
		setDirectionLock?( directionLock?:boolean ): void;
		/** [Method] Sets the value of indicator  
		* @param indicator Boolean The new value. 
		*/
		setIndicator?( indicator?:boolean ): void;
		/** [Method] Sets the value of itemConfig  
		* @param itemConfig Object The new value. 
		*/
		setItemConfig?( itemConfig?:any ): void;
		/** [Method] Sets the value of itemLength  
		* @param itemLength Object The new value. 
		*/
		setItemLength?( itemLength?:any ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
	}
}
declare module Ext.carousel {
	export interface IIndicator extends Ext.IComponent {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of direction  
		* @returns String 
		*/
		getDirection?(): string;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of direction  
		* @param direction String The new value. 
		*/
		setDirection?( direction?:string ): void;
	}
}
declare module Ext.carousel {
	export interface IInfinite extends Ext.carousel.ICarousel {
		/** [Config Option] (Boolean) */
		indicator?: boolean;
		/** [Method] Returns the value of indicator  
		* @returns Object 
		*/
		getIndicator?(): any;
		/** [Method] Returns the value of innerItemConfig  
		* @returns Object 
		*/
		getInnerItemConfig?(): any;
		/** [Method] Returns the value of maxItemIndex  
		* @returns Object 
		*/
		getMaxItemIndex?(): any;
		/** [Method] Sets the value of indicator  
		* @param indicator Object The new value. 
		*/
		setIndicator?( indicator?:any ): void;
		/** [Method] Sets the value of innerItemConfig  
		* @param innerItemConfig Object The new value. 
		*/
		setInnerItemConfig?( innerItemConfig?:any ): void;
		/** [Method] Sets the value of maxItemIndex  
		* @param maxItemIndex Object The new value. 
		*/
		setMaxItemIndex?( maxItemIndex?:any ): void;
	}
}
declare module Ext.carousel {
	export interface IItem extends Ext.IDecorator {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Object) */
		component?: any;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of component  
		* @returns Object 
		*/
		getComponent?(): any;
		/** [Method] Returns the value of translatable  
		* @returns Boolean 
		*/
		getTranslatable?(): boolean;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of component  
		* @param component Object The new value. 
		*/
		setComponent?( component?:any ): void;
		/** [Method] Sets the value of translatable  
		* @param translatable Boolean The new value. 
		*/
		setTranslatable?( translatable?:boolean ): void;
	}
}
declare module Ext.chart {
	export interface IAbstractChart extends Ext.draw.IComponent {
		/** [Config Option] (Boolean/Object) */
		animate?: any;
		/** [Config Option] (Ext.chart.axis.Axis/Array/Object) */
		axes?: any;
		/** [Config Option] (Object) */
		background?: any;
		/** [Config Option] (Boolean/Array) */
		colors?: any;
		/** [Config Option] (Object) */
		highlightItem?: any;
		/** [Config Option] (Object) */
		innerPadding?: any;
		/** [Config Option] (Object|Number) */
		insetPadding?: any;
		/** [Config Option] (Array) */
		interactions?: any[];
		/** [Config Option] (Ext.chart.Legend/Object) */
		legend?: any;
		/** [Config Option] (Ext.chart.series.Series/Array) */
		series?: any;
		/** [Config Option] (Boolean/Object) */
		shadow?: any;
		/** [Config Option] (Ext.data.Store) */
		store?: Ext.data.IStore;
		/** [Property] (String) */
		version?: string;
		/** [Method] Changes the data store bound to this chart and refreshes it  
		* @param store Ext.data.Store The store to bind to this chart. 
		*/
		bindStore?( store?:Ext.data.IStore ): void;
		/** [Method] Cancel a scheduled layout  */
		cancelLayout?(): void;
		/** [Method] Flattens the given chart surfaces into a single image  
		* @param surfaces Array A list of chart's surfaces to flatten. 
		* @param format String If set to 'image', the method will return an Image object. Otherwise, the dataURL  of the flattened image will be returned. 
		* @returns String|Image An Image DOM element containing the flattened image or its dataURL. 
		*/
		flatten?( surfaces?:any[], format?:string ): any;
		/** [Method] Returns the value of axes  
		* @returns Ext.chart.axis.Axis/Array/Object 
		*/
		getAxes?(): any;
		/** [Method] Returns the value of background  
		* @returns Object 
		*/
		getBackground?(): any;
		/** [Method] Returns the value of colors  
		* @returns Boolean/Array 
		*/
		getColors?(): any;
		/** [Method] Returns the value of highlightItem  
		* @returns Object 
		*/
		getHighlightItem?(): any;
		/** [Method] Returns the value of innerPadding  
		* @returns Object 
		*/
		getInnerPadding?(): any;
		/** [Method] Returns the value of insetPadding  
		* @returns Object|Number 
		*/
		getInsetPadding?(): any;
		/** [Method] Returns the value of interactions  
		* @returns Array 
		*/
		getInteractions?(): any[];
		/** [Method] Given an x y point relative to the chart find and return the first series item that matches that point  
		* @param x Number 
		* @param y Number 
		* @returns Object An object with series and item properties, or false if no item found. 
		*/
		getItemForPoint?( x?:number, y?:number ): any;
		/** [Method] Given an x y point relative to the chart find and return all series items that match that point  
		* @param x Number 
		* @param y Number 
		* @returns Array An array of objects with series and item properties. 
		*/
		getItemsForPoint?( x?:number, y?:number ): any[];
		/** [Method] Returns the value of legend  
		* @returns Ext.chart.Legend/Object 
		*/
		getLegend?(): any;
		/** [Method] Return the legend store that contains all the legend information  
		* @returns Ext.data.Store 
		*/
		getLegendStore?(): Ext.data.IStore;
		/** [Method] Returns the value of series  
		* @returns Ext.chart.series.Series/Array 
		*/
		getSeries?(): any;
		/** [Method] Returns the value of shadow  
		* @returns Boolean/Object 
		*/
		getShadow?(): any;
		/** [Method] Returns the value of store  
		* @returns Ext.data.Store 
		*/
		getStore?(): Ext.data.IStore;
		/** [Method] Get a surface by the given id or create one if it doesn t exist  
		* @param name Object 
		* @param type Object 
		* @returns Ext.draw.Surface 
		*/
		getSurface?( name?:any, type?:any ): Ext.draw.ISurface;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Redraw the chart  */
		redraw?(): void;
		/** [Method] Resume the layout initialized by thickness change */
		resumeThicknessChanged?(): void;
		/** [Method] Schedule a layout at next frame  */
		scheduleLayout?(): void;
		/** [Method] Sets the value of animate  
		* @param animate Boolean/Object The new value. 
		*/
		setAnimate?( animate?:any ): void;
		/** [Method] Sets the value of axes  
		* @param axes Ext.chart.axis.Axis/Array/Object The new value. 
		*/
		setAxes?( axes?:any ): void;
		/** [Method] Sets the value of background  
		* @param background Object The new value. 
		*/
		setBackground?( background?:any ): void;
		/** [Method] Sets the value of colors  
		* @param colors Boolean/Array The new value. 
		*/
		setColors?( colors?:any ): void;
		/** [Method] Sets the value of highlightItem  
		* @param highlightItem Object The new value. 
		*/
		setHighlightItem?( highlightItem?:any ): void;
		/** [Method] Sets the value of innerPadding  
		* @param innerPadding Object The new value. 
		*/
		setInnerPadding?( innerPadding?:any ): void;
		/** [Method] Sets the value of insetPadding  
		* @param insetPadding Object|Number The new value. 
		*/
		setInsetPadding?( insetPadding?:any ): void;
		/** [Method] Sets the value of interactions  
		* @param interactions Array The new value. 
		*/
		setInteractions?( interactions?:any[] ): void;
		/** [Method] Sets the value of legend  
		* @param legend Ext.chart.Legend/Object The new value. 
		*/
		setLegend?( legend?:any ): void;
		/** [Method] Sets the value of series  
		* @param series Ext.chart.series.Series/Array The new value. 
		*/
		setSeries?( series?:any ): void;
		/** [Method] Sets the value of shadow  
		* @param shadow Boolean/Object The new value. 
		*/
		setShadow?( shadow?:any ): void;
		/** [Method] Sets the value of store  
		* @param store Ext.data.Store The new value. 
		*/
		setStore?( store?:Ext.data.IStore ): void;
		/** [Method] Suspend the layout initialized by thickness change */
		suspendThicknessChanged?(): void;
	}
}
declare module Ext.chart.axis {
	export interface IAxis extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Object) */
		background?: any;
		/** [Config Option] (Ext.chart.AbstractChart) */
		chart?: Ext.chart.IAbstractChart;
		/** [Config Option] (Array) */
		fields?: any[];
		/** [Config Option] (Object) */
		grid?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (Number) */
		increment?: number;
		/** [Config Option] (Object) */
		label?: any;
		/** [Config Option] (Boolean) */
		labelInSpan?: boolean;
		/** [Config Option] (Object|Ext.chart.axis.layout.Layout) */
		layout?: any;
		/** [Config Option] (Number) */
		majorTickSteps?: number;
		/** [Config Option] (Number) */
		maxZoom?: number;
		/** [Config Option] (Number) */
		maximum?: number;
		/** [Config Option] (Number) */
		minZoom?: number;
		/** [Config Option] (Number) */
		minimum?: number;
		/** [Config Option] (Number) */
		minorTickSteps?: number;
		/** [Config Option] (Boolean) */
		needHighPrecision?: boolean;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (Function) */
		renderer?: any;
		/** [Config Option] (Object|Ext.chart.axis.segmenter.Segmenter) */
		segmenter?: any;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (String|Object) */
		title?: any;
		/** [Config Option] (Number) */
		titleMargin?: number;
		/** [Config Option] (Array) */
		visibleRange?: any[];
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of background  
		* @returns Object 
		*/
		getBackground?(): any;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of chart  
		* @returns Ext.chart.AbstractChart 
		*/
		getChart?(): Ext.chart.IAbstractChart;
		/** [Method] Mapping data value into coordinate  
		* @param value * 
		* @param field String 
		* @param idx Number 
		* @param items Ext.util.MixedCollection 
		* @returns Number 
		*/
		getCoordFor?( value?:any, field?:string, idx?:number, items?:Ext.util.IMixedCollection ): number;
		/** [Method] Returns the value of fields  
		* @returns Array 
		*/
		getFields?(): any[];
		/** [Method] Returns the value of grid  
		* @returns Object 
		*/
		getGrid?(): any;
		/** [Method] Returns the value of hidden  
		* @returns Boolean 
		*/
		getHidden?(): boolean;
		/** [Method] Returns the value of increment  
		* @returns Number 
		*/
		getIncrement?(): number;
		/** [Method] Returns the value of label  
		* @returns Object 
		*/
		getLabel?(): any;
		/** [Method] Returns the value of labelInSpan  
		* @returns Boolean 
		*/
		getLabelInSpan?(): boolean;
		/** [Method] Returns the value of layout  
		* @returns Object|Ext.chart.axis.layout.Layout 
		*/
		getLayout?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of majorTickSteps  
		* @returns Number 
		*/
		getMajorTickSteps?(): number;
		/** [Method] Returns the value of maxZoom  
		* @returns Number 
		*/
		getMaxZoom?(): number;
		/** [Method] Returns the value of maximum  
		* @returns Number 
		*/
		getMaximum?(): number;
		/** [Method] Returns the value of minZoom  
		* @returns Number 
		*/
		getMinZoom?(): number;
		/** [Method] Returns the value of minimum  
		* @returns Number 
		*/
		getMinimum?(): number;
		/** [Method] Returns the value of minorTickSteps  
		* @returns Number 
		*/
		getMinorTickSteps?(): number;
		/** [Method] Returns the value of needHighPrecision  
		* @returns Boolean 
		*/
		getNeedHighPrecision?(): boolean;
		/** [Method] Returns the value of position  
		* @returns String 
		*/
		getPosition?(): string;
		/** [Method] Get the range derived from all the bound series  
		* @returns Array 
		*/
		getRange?(): any[];
		/** [Method] Returns the value of renderer  
		* @returns Function 
		*/
		getRenderer?(): any;
		/** [Method] Returns the value of segmenter  
		* @returns Object|Ext.chart.axis.segmenter.Segmenter 
		*/
		getSegmenter?(): any;
		/** [Method] Returns the value of style  
		* @returns Object 
		*/
		getStyle?(): any;
		/** [Method] Returns the value of title  
		* @returns String|Object 
		*/
		getTitle?(): any;
		/** [Method] Returns the value of titleMargin  
		* @returns Number 
		*/
		getTitleMargin?(): number;
		/** [Method] Returns the value of visibleRange  
		* @returns Array 
		*/
		getVisibleRange?(): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Invoked when data has changed  */
		processData?(): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Invokes renderFrame on this axis s surface s  */
		renderFrame?(): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of background  
		* @param background Object The new value. 
		*/
		setBackground?( background?:any ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of chart  
		* @param chart Ext.chart.AbstractChart The new value. 
		*/
		setChart?( chart?:Ext.chart.IAbstractChart ): void;
		/** [Method] Sets the value of fields  
		* @param fields Array The new value. 
		*/
		setFields?( fields?:any[] ): void;
		/** [Method] Sets the value of grid  
		* @param grid Object The new value. 
		*/
		setGrid?( grid?:any ): void;
		/** [Method] Sets the value of hidden  
		* @param hidden Boolean The new value. 
		*/
		setHidden?( hidden?:boolean ): void;
		/** [Method] Sets the value of increment  
		* @param increment Number The new value. 
		*/
		setIncrement?( increment?:number ): void;
		/** [Method] Sets the value of label  
		* @param label Object The new value. 
		*/
		setLabel?( label?:any ): void;
		/** [Method] Sets the value of labelInSpan  
		* @param labelInSpan Boolean The new value. 
		*/
		setLabelInSpan?( labelInSpan?:boolean ): void;
		/** [Method] Sets the value of layout  
		* @param layout Object|Ext.chart.axis.layout.Layout The new value. 
		*/
		setLayout?( layout?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of majorTickSteps  
		* @param majorTickSteps Number The new value. 
		*/
		setMajorTickSteps?( majorTickSteps?:number ): void;
		/** [Method] Sets the value of maxZoom  
		* @param maxZoom Number The new value. 
		*/
		setMaxZoom?( maxZoom?:number ): void;
		/** [Method] Sets the value of maximum  
		* @param maximum Number The new value. 
		*/
		setMaximum?( maximum?:number ): void;
		/** [Method] Sets the value of minZoom  
		* @param minZoom Number The new value. 
		*/
		setMinZoom?( minZoom?:number ): void;
		/** [Method] Sets the value of minimum  
		* @param minimum Number The new value. 
		*/
		setMinimum?( minimum?:number ): void;
		/** [Method] Sets the value of minorTickSteps  
		* @param minorTickSteps Number The new value. 
		*/
		setMinorTickSteps?( minorTickSteps?:number ): void;
		/** [Method] Sets the value of needHighPrecision  
		* @param needHighPrecision Boolean The new value. 
		*/
		setNeedHighPrecision?( needHighPrecision?:boolean ): void;
		/** [Method] Sets the value of position  
		* @param position String The new value. 
		*/
		setPosition?( position?:string ): void;
		/** [Method] Sets the value of renderer  
		* @param renderer Function The new value. 
		* @returns String The label to display. 
		*/
		setRenderer?( renderer?:any ): string;
		/** [Method] Sets the value of segmenter  
		* @param segmenter Object|Ext.chart.axis.segmenter.Segmenter The new value. 
		*/
		setSegmenter?( segmenter?:any ): void;
		/** [Method] Sets the value of style  
		* @param style Object The new value. 
		*/
		setStyle?( style?:any ): void;
		/** [Method] Sets the value of title  
		* @param title String|Object The new value. 
		*/
		setTitle?( title?:any ): void;
		/** [Method] Sets the value of titleMargin  
		* @param titleMargin Number The new value. 
		*/
		setTitleMargin?( titleMargin?:number ): void;
		/** [Method] Sets the value of visibleRange  
		* @param visibleRange Array The new value. 
		*/
		setVisibleRange?( visibleRange?:any[] ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.chart.axis {
	export interface ICategory extends Ext.chart.axis.IAxis {
		/** [Config Option] (Object|Ext.chart.axis.layout.Layout) */
		layout?: any;
		/** [Config Option] (Object|Ext.chart.axis.segmenter.Segmenter) */
		segmenter?: any;
		/** [Method] Returns the value of layout  
		* @returns String 
		*/
		getLayout?(): string;
		/** [Method] Returns the value of segmenter  
		* @returns String 
		*/
		getSegmenter?(): string;
		/** [Method] Sets the value of layout  
		* @param layout String The new value. 
		*/
		setLayout?( layout?:string ): void;
		/** [Method] Sets the value of segmenter  
		* @param segmenter String The new value. 
		*/
		setSegmenter?( segmenter?:string ): void;
	}
}
declare module Ext.chart.axis.layout {
	export interface ICombineDuplicate extends Ext.chart.axis.layout.IDiscrete {
	}
}
declare module Ext.chart.axis.layout {
	export interface IContinuous extends Ext.chart.axis.layout.ILayout {
		/** [Method] Returns the value of adjustMaximumByMajorUnit  
		* @returns Boolean 
		*/
		getAdjustMaximumByMajorUnit?(): boolean;
		/** [Method] Returns the value of adjustMinimumByMajorUnit  
		* @returns Boolean 
		*/
		getAdjustMinimumByMajorUnit?(): boolean;
		/** [Method] Sets the value of adjustMaximumByMajorUnit  
		* @param adjustMaximumByMajorUnit Boolean The new value. 
		*/
		setAdjustMaximumByMajorUnit?( adjustMaximumByMajorUnit?:boolean ): void;
		/** [Method] Sets the value of adjustMinimumByMajorUnit  
		* @param adjustMinimumByMajorUnit Boolean The new value. 
		*/
		setAdjustMinimumByMajorUnit?( adjustMinimumByMajorUnit?:boolean ): void;
		/** [Method] Snaps the data bound to the axis to meaningful tick marks  
		* @param context Object 
		* @param min Object 
		* @param max Object 
		* @param estStepSize Object 
		*/
		snapEnds?( context?:any, min?:any, max?:any, estStepSize?:any ): void;
	}
}
declare module Ext.chart.axis.layout {
	export interface IDiscrete extends Ext.chart.axis.layout.ILayout {
		/** [Method] Calculates the position of tick marks for the axis  
		* @param context Object 
		* @returns * 
		*/
		calculateLayout?( context?:any ): any;
		/** [Method] Calculates the position of major ticks for the axis  
		* @param context Object 
		*/
		calculateMajorTicks?( context?:any ): void;
		/** [Method] Processes the data of the series bound to the axis  */
		processData?(): void;
		/** [Method] Snaps the data bound to the axis to meaningful tick marks  
		* @param context Object 
		* @param min Object 
		* @param max Object 
		* @param estStepSize Object 
		*/
		snapEnds?( context?:any, min?:any, max?:any, estStepSize?:any ): void;
		/** [Method] Trims the layout of the axis by the defined minimum and maximum  
		* @param context Object 
		* @param out Object 
		* @param trimMin Object 
		* @param trimMax Object 
		*/
		trimByRange?( context?:any, out?:any, trimMin?:any, trimMax?:any ): void;
	}
}
declare module Ext.chart.axis.layout {
	export interface ILayout extends Ext.IBase {
		/** [Config Option] (Ext.chart.axis.Axis) */
		axis?: Ext.chart.axis.IAxis;
		/** [Method] Calculates the position of tick marks for the axis  
		* @param context Object 
		* @returns * 
		*/
		calculateLayout?( context?:any ): any;
		/** [Method] Calculates the position of major ticks for the axis  
		* @param context Object 
		*/
		calculateMajorTicks?( context?:any ): void;
		/** [Method] Calculates the position of sub ticks for the axis  
		* @param context Object 
		*/
		calculateMinorTicks?( context?:any ): void;
		/** [Method] Returns the value of axis  
		* @returns Ext.chart.axis.Axis 
		*/
		getAxis?(): Ext.chart.axis.IAxis;
		/** [Method] Processes the data of the series bound to the axis  
		* @param series Ext.chart.series.Series The bound series. 
		*/
		processData?( series?:Ext.chart.series.ISeries ): void;
		/** [Method] Sets the value of axis  
		* @param axis Ext.chart.axis.Axis The new value. 
		*/
		setAxis?( axis?:Ext.chart.axis.IAxis ): void;
		/** [Method] Snaps the data bound to the axis to meaningful tick marks  
		* @param context Object 
		* @param min Number 
		* @param max Number 
		* @param estStepSize Number 
		*/
		snapEnds?( context?:any, min?:number, max?:number, estStepSize?:number ): void;
		/** [Method] Trims the layout of the axis by the defined minimum and maximum  
		* @param context Object 
		* @param out Object 
		* @param trimMin Number 
		* @param trimMax Number 
		*/
		trimByRange?( context?:any, out?:any, trimMin?:number, trimMax?:number ): void;
	}
}
declare module Ext.chart.axis {
	export interface INumeric extends Ext.chart.axis.IAxis {
		/** [Config Option] (Object|Ext.chart.axis.layout.Layout) */
		layout?: any;
		/** [Config Option] (Object|Ext.chart.axis.segmenter.Segmenter) */
		segmenter?: any;
		/** [Method] Returns the value of aggregator  
		* @returns String 
		*/
		getAggregator?(): string;
		/** [Method] Returns the value of layout  
		* @returns String 
		*/
		getLayout?(): string;
		/** [Method] Returns the value of segmenter  
		* @returns String 
		*/
		getSegmenter?(): string;
		/** [Method] Sets the value of aggregator  
		* @param aggregator String The new value. 
		*/
		setAggregator?( aggregator?:string ): void;
		/** [Method] Sets the value of layout  
		* @param layout String The new value. 
		*/
		setLayout?( layout?:string ): void;
		/** [Method] Sets the value of segmenter  
		* @param segmenter String The new value. 
		*/
		setSegmenter?( segmenter?:string ): void;
	}
}
declare module Ext.chart.axis.segmenter {
	export interface INames extends Ext.chart.axis.segmenter.ISegmenter {
		/** [Method] Add step units to the value  
		* @param value Object 
		* @param step Object 
		* @param unit Object 
		*/
		add?( value?:any, step?:any, unit?:any ): void;
		/** [Method] Align value with step of units  
		* @param value Object 
		* @param step Object 
		* @param unit Object 
		* @returns * Aligned value. 
		*/
		align?( value?:any, step?:any, unit?:any ): any;
		/** [Method] Returns the difference between the min and max value based on the given unit scale  
		* @param min Object 
		* @param max Object 
		* @param unit Object 
		* @returns Number The number of units between min and max. It is the minimum n that min + n * unit >= max. 
		*/
		diff?( min?:any, max?:any, unit?:any ): number;
		/** [Method] Given a start point and estimated step size of a range determine the preferred step size  
		* @param min Object 
		* @param estStepSize Object 
		* @param minIdx Object 
		* @param data Object 
		* @returns Object Return the step size by an object of step x unit. 
		*/
		preferredStep?( min?:any, estStepSize?:any, minIdx?:any, data?:any ): any;
		/** [Method] This method formats the value  
		* @param value Object 
		* @param context Object 
		* @returns String 
		*/
		renderer?( value?:any, context?:any ): string;
	}
}
declare module Ext.chart.axis.segmenter {
	export interface INumeric extends Ext.chart.axis.segmenter.ISegmenter {
		/** [Method] Add step units to the value  
		* @param value Object 
		* @param step Object 
		* @param unit Object 
		*/
		add?( value?:any, step?:any, unit?:any ): void;
		/** [Method] Align value with step of units  
		* @param value Object 
		* @param step Object 
		* @param unit Object 
		* @returns * Aligned value. 
		*/
		align?( value?:any, step?:any, unit?:any ): any;
		/** [Method] Returns the difference between the min and max value based on the given unit scale  
		* @param min Object 
		* @param max Object 
		* @param unit Object 
		* @returns Number The number of units between min and max. It is the minimum n that min + n * unit >= max. 
		*/
		diff?( min?:any, max?:any, unit?:any ): number;
		/** [Method] Wraps the provided estimated step size of a range without altering it into a step size object  
		* @param start * The start point of range. 
		* @param estStepSize * The estimated step size. 
		* @returns Object Return the step size by an object of step x unit. 
		*/
		exactStep?( start?:any, estStepSize?:any ): any;
		/** [Method] Given a start point and estimated step size of a range determine the preferred step size  
		* @param min Object 
		* @param estStepSize Object 
		* @returns Object Return the step size by an object of step x unit. 
		*/
		preferredStep?( min?:any, estStepSize?:any ): any;
		/** [Method] This method formats the value  
		* @param value Object 
		* @param context Object 
		* @returns String 
		*/
		renderer?( value?:any, context?:any ): string;
	}
}
declare module Ext.chart.axis.segmenter {
	export interface ISegmenter extends Ext.IBase {
		/** [Config Option] (Ext.chart.axis.Axis) */
		axis?: Ext.chart.axis.IAxis;
		/** [Method] Add step units to the value  
		* @param value * The value to be added. 
		* @param step Number The step of units. Negative value are allowed. 
		* @param unit * The unit. 
		*/
		add?( value?:any, step?:number, unit?:any ): void;
		/** [Method] Align value with step of units  
		* @param value * The value to be aligned. 
		* @param step Number The step of units. 
		* @param unit * The unit. 
		* @returns * Aligned value. 
		*/
		align?( value?:any, step?:number, unit?:any ): any;
		/** [Method] Returns the difference between the min and max value based on the given unit scale  
		* @param min * The smaller value. 
		* @param max * The larger value. 
		* @param unit * The unit scale. Unit can be any type. 
		* @returns Number The number of units between min and max. It is the minimum n that min + n * unit >= max. 
		*/
		diff?( min?:any, max?:any, unit?:any ): number;
		/** [Method] Convert from any data into the target type  
		* @param value * The value to convert from 
		* @returns * The converted value. 
		*/
		from?( value?:any ): any;
		/** [Method] Returns the value of axis  
		* @returns Ext.chart.axis.Axis 
		*/
		getAxis?(): Ext.chart.axis.IAxis;
		/** [Method] Given a start point and estimated step size of a range determine the preferred step size  
		* @param start * The start point of range. 
		* @param estStepSize * The estimated step size. 
		* @returns Object Return the step size by an object of step x unit. 
		*/
		preferredStep?( start?:any, estStepSize?:any ): any;
		/** [Method] This method formats the value  
		* @param value * The value to format. 
		* @param context Object Axis layout context. 
		* @returns String 
		*/
		renderer?( value?:any, context?:any ): string;
		/** [Method] Sets the value of axis  
		* @param axis Ext.chart.axis.Axis The new value. 
		*/
		setAxis?( axis?:Ext.chart.axis.IAxis ): void;
	}
}
declare module Ext.chart.axis.segmenter {
	export interface ITime extends Ext.chart.axis.segmenter.ISegmenter {
		/** [Config Option] (Object) */
		step?: any;
		/** [Method] Add step units to the value  
		* @param value Object 
		* @param step Object 
		* @param unit Object 
		*/
		add?( value?:any, step?:any, unit?:any ): void;
		/** [Method] Align value with step of units  
		* @param date Object 
		* @param step Object 
		* @param unit Object 
		* @returns * Aligned value. 
		*/
		align?( date?:any, step?:any, unit?:any ): any;
		/** [Method] Returns the difference between the min and max value based on the given unit scale  
		* @param min Object 
		* @param max Object 
		* @param unit Object 
		* @returns Number The number of units between min and max. It is the minimum n that min + n * unit >= max. 
		*/
		diff?( min?:any, max?:any, unit?:any ): number;
		/** [Method] Convert from any data into the target type  
		* @param value Object 
		* @returns * The converted value. 
		*/
		from?( value?:any ): any;
		/** [Method] Returns the value of step  
		* @returns Object 
		*/
		getStep?(): any;
		/** [Method] Given a start point and estimated step size of a range determine the preferred step size  
		* @param min Object 
		* @param estStepSize Object 
		* @returns Object Return the step size by an object of step x unit. 
		*/
		preferredStep?( min?:any, estStepSize?:any ): any;
		/** [Method] This method formats the value  
		* @param value Object 
		* @param context Object 
		* @returns String 
		*/
		renderer?( value?:any, context?:any ): string;
		/** [Method] Sets the value of step  
		* @param step Object The new value. 
		*/
		setStep?( step?:any ): void;
	}
}
declare module Ext.chart.axis.sprite {
	export interface IAxis extends Ext.draw.sprite.ISprite,Ext.chart.IMarkerHolder {
		/** [Config Option] (Number) */
		The?: number;
		/** [Config Option] (Ext.chart.axis.Axis) */
		axis?: Ext.chart.axis.IAxis;
		/** [Config Option] (Boolean) */
		axisLine?: boolean;
		/** [Config Option] (Number) */
		centerX?: number;
		/** [Config Option] (Number) */
		centerY?: number;
		/** [Config Option] (Number) */
		dataMax?: number;
		/** [Config Option] (Number) */
		dataMin?: number;
		/** [Config Option] (Boolean) */
		enlargeEstStepSizeByText?: boolean;
		/** [Config Option] (Boolean) */
		grid?: boolean;
		/** [Config Option] (Object) */
		label?: any;
		/** [Config Option] (Object|Ext.chart.axis.layout.Layout) */
		layout?: any;
		/** [Config Option] (Number) */
		length?: number;
		/** [Config Option] (Number) */
		majorTickSize?: number;
		/** [Config Option] (Boolean) */
		majorTicks?: boolean;
		/** [Config Option] (Number) */
		max?: number;
		/** [Config Option] (Number) */
		min?: number;
		/** [Config Option] (Number) */
		minStepSize?: number;
		/** [Config Option] (Number) */
		minorTickSize?: number;
		/** [Config Option] (Boolean) */
		minorTricks?: boolean;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (Function) */
		renderer?: any;
		/** [Config Option] (Object|Ext.chart.axis.segmenter.Segmenter) */
		segmenter?: any;
		/** [Config Option] (Number) */
		textPadding?: number;
		/** [Config Option] (Number) */
		visibleMax?: number;
		/** [Config Option] (Number) */
		visibleMin?: number;
		/** [Method]  
		* @param name String 
		* @param marker Ext.chart.Markers 
		*/
		bindMarker?( name?:string, marker?:Ext.chart.IMarkers ): void;
		/** [Method] Returns the value of axis  
		* @returns Ext.chart.axis.Axis 
		*/
		getAxis?(): Ext.chart.axis.IAxis;
		/** [Method] Returns the bounding box for the given Sprite as calculated with the Canvas engine  */
		getBBox?(): void;
		/** [Method] Returns the value of label  
		* @returns Object 
		*/
		getLabel?(): any;
		/** [Method] Returns the value of layout  
		* @returns Object|Ext.chart.axis.layout.Layout 
		*/
		getLayout?(): any;
		/** [Method] Returns the value of renderer  
		* @returns Function 
		*/
		getRenderer?(): any;
		/** [Method] Returns the value of segmenter  
		* @returns Object|Ext.chart.axis.segmenter.Segmenter 
		*/
		getSegmenter?(): any;
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @param clipRegion Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any, clipRegion?:any ): any;
		/** [Method] Sets the value of axis  
		* @param axis Ext.chart.axis.Axis The new value. 
		*/
		setAxis?( axis?:Ext.chart.axis.IAxis ): void;
		/** [Method] Sets the value of label  
		* @param label Object The new value. 
		*/
		setLabel?( label?:any ): void;
		/** [Method] Sets the value of layout  
		* @param layout Object|Ext.chart.axis.layout.Layout The new value. 
		*/
		setLayout?( layout?:any ): void;
		/** [Method] Sets the value of renderer  
		* @param renderer Function The new value. 
		*/
		setRenderer?( renderer?:any ): void;
		/** [Method] Sets the value of segmenter  
		* @param segmenter Object|Ext.chart.axis.segmenter.Segmenter The new value. 
		*/
		setSegmenter?( segmenter?:any ): void;
	}
}
declare module Ext.chart.axis {
	export interface ITime extends Ext.chart.axis.INumeric {
		/** [Config Option] (Boolean) */
		calculateByLabelSize?: boolean;
		/** [Config Option] (String/Boolean) */
		dateFormat?: any;
		/** [Config Option] (Date) */
		fromDate?: any;
		/** [Config Option] (Object|Ext.chart.axis.layout.Layout) */
		layout?: any;
		/** [Config Option] (Object|Ext.chart.axis.segmenter.Segmenter) */
		segmenter?: any;
		/** [Config Option] (Array) */
		step?: any[];
		/** [Config Option] (Date) */
		toDate?: any;
		/** [Method] Returns the value of aggregator  
		* @returns String 
		*/
		getAggregator?(): string;
		/** [Method] Returns the value of calculateByLabelSize  
		* @returns Boolean 
		*/
		getCalculateByLabelSize?(): boolean;
		/** [Method] Mapping data value into coordinate  
		* @param value Object 
		* @returns Number 
		*/
		getCoordFor?( value?:any ): number;
		/** [Method] Returns the value of dateFormat  
		* @returns String/Boolean 
		*/
		getDateFormat?(): any;
		/** [Method] Returns the value of fromDate  
		* @returns Date 
		*/
		getFromDate?(): any;
		/** [Method] Returns the value of layout  
		* @returns String 
		*/
		getLayout?(): string;
		/** [Method] Returns the value of segmenter  
		* @returns String 
		*/
		getSegmenter?(): string;
		/** [Method] Returns the value of step  
		* @returns Array 
		*/
		getStep?(): any[];
		/** [Method] Returns the value of toDate  
		* @returns Date 
		*/
		getToDate?(): any;
		/** [Method] Sets the value of aggregator  
		* @param aggregator String The new value. 
		*/
		setAggregator?( aggregator?:string ): void;
		/** [Method] Sets the value of calculateByLabelSize  
		* @param calculateByLabelSize Boolean The new value. 
		*/
		setCalculateByLabelSize?( calculateByLabelSize?:boolean ): void;
		/** [Method] Sets the value of dateFormat  
		* @param dateFormat String/Boolean The new value. 
		*/
		setDateFormat?( dateFormat?:any ): void;
		/** [Method] Sets the value of fromDate  
		* @param fromDate Date The new value. 
		*/
		setFromDate?( fromDate?:any ): void;
		/** [Method] Sets the value of layout  
		* @param layout String The new value. 
		*/
		setLayout?( layout?:string ): void;
		/** [Method] Sets the value of segmenter  
		* @param segmenter String The new value. 
		*/
		setSegmenter?( segmenter?:string ): void;
		/** [Method] Sets the value of step  
		* @param step Array The new value. 
		*/
		setStep?( step?:any[] ): void;
		/** [Method] Sets the value of toDate  
		* @param toDate Date The new value. 
		*/
		setToDate?( toDate?:any ): void;
	}
}
declare module Ext.chart {
	export interface ICartesianChart extends Ext.chart.IAbstractChart {
		/** [Config Option] (Boolean) */
		flipXY?: boolean;
		/** [Method] Returns the value of flipXY  
		* @returns Boolean 
		*/
		getFlipXY?(): boolean;
		/** [Method] Returns the value of innerRegion  
		* @returns Array 
		*/
		getInnerRegion?(): any[];
		/** [Method] Place water mark after resize  */
		onPlaceWatermark?(): void;
		/** [Method] Layout the axes and series  */
		performLayout?(): void;
		/** [Method] Redraw the chart  */
		redraw?(): void;
		/** [Method] Sets the value of flipXY  
		* @param flipXY Boolean The new value. 
		*/
		setFlipXY?( flipXY?:boolean ): void;
		/** [Method] Sets the value of innerRegion  
		* @param innerRegion Array The new value. 
		*/
		setInnerRegion?( innerRegion?:any[] ): void;
	}
}
declare module Ext.chart {
	export interface IChart extends Ext.chart.IAbstractChart {
		/** [Config Option] (Boolean) */
		flipXY?: boolean;
		/** [Method] Returns the value of flipXY  
		* @returns Boolean 
		*/
		getFlipXY?(): boolean;
		/** [Method] Returns the value of innerRegion  
		* @returns Array 
		*/
		getInnerRegion?(): any[];
		/** [Method] Place water mark after resize  */
		onPlaceWatermark?(): void;
		/** [Method] Layout the axes and series  */
		performLayout?(): void;
		/** [Method] Redraw the chart  */
		redraw?(): void;
		/** [Method] Sets the value of flipXY  
		* @param flipXY Boolean The new value. 
		*/
		setFlipXY?( flipXY?:boolean ): void;
		/** [Method] Sets the value of innerRegion  
		* @param innerRegion Array The new value. 
		*/
		setInnerRegion?( innerRegion?:any[] ): void;
	}
}
declare module Ext.chart.grid {
	export interface ICircularGrid extends Ext.draw.sprite.ICircle {
	}
}
declare module Ext.chart.grid {
	export interface IHorizontalGrid extends Ext.draw.sprite.ISprite {
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @param clipRegion Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any, clipRegion?:any ): any;
	}
}
declare module Ext.chart.grid {
	export interface IRadialGrid extends Ext.draw.sprite.IPath {
		/** [Method] Render method  
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?(): any;
		/** [Method] Update the path  
		* @param path Object 
		* @param attr Object 
		*/
		updatePath?( path?:any, attr?:any ): void;
	}
}
declare module Ext.chart.grid {
	export interface IVerticalGrid extends Ext.draw.sprite.ISprite {
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @param clipRegion Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any, clipRegion?:any ): any;
	}
}
declare module Ext.chart.interactions {
	export interface IAbstract extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Ext.chart.AbstractChart) */
		chart?: Ext.chart.IAbstractChart;
		/** [Config Option] (Boolean) */
		enabled?: boolean;
		/** [Config Option] (String) */
		gesture?: string;
		/** [Property] (Number) */
		throttleGap?: number;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of chart  
		* @returns Ext.chart.AbstractChart 
		*/
		getChart?(): Ext.chart.IAbstractChart;
		/** [Method] Returns the value of enabled  
		* @returns Boolean 
		*/
		getEnabled?(): boolean;
		/** [Method] Returns the value of gesture  
		* @returns String 
		*/
		getGesture?(): string;
		/** [Method] Find and return a single series item corresponding to the given event or null if no matching item is found  
		* @param e Event 
		* @returns Object the item object or null if none found. 
		*/
		getItemForEvent?( e?:Event ): any;
		/** [Method] Find and return all series items corresponding to the given event  
		* @param e Event 
		* @returns Array array of matching item objects 
		*/
		getItemsForEvent?( e?:Event ): any[];
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] A method to be implemented by subclasses where all event attachment should occur  */
		initialize?(): void;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Placeholder method  */
		onGesture?(): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of chart  
		* @param chart Ext.chart.AbstractChart The new value. 
		*/
		setChart?( chart?:Ext.chart.IAbstractChart ): void;
		/** [Method] Sets the value of enabled  
		* @param enabled Boolean The new value. 
		*/
		setEnabled?( enabled?:boolean ): void;
		/** [Method] Sets the value of gesture  
		* @param gesture String The new value. 
		*/
		setGesture?( gesture?:string ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.chart.interactions {
	export interface ICrosshair extends Ext.chart.interactions.IAbstract {
		/** [Config Option] (Object) */
		axes?: any;
		/** [Config Option] (String) */
		gesture?: string;
		/** [Config Option] (Object) */
		lines?: any;
		/** [Method] Returns the value of axes  
		* @returns Object 
		*/
		getAxes?(): any;
		/** [Method] Returns the value of gesture  
		* @returns String 
		*/
		getGesture?(): string;
		/** [Method] Returns the value of lines  
		* @returns Object 
		*/
		getLines?(): any;
		/** [Method] Placeholder method  
		* @param e Object 
		*/
		onGesture?( e?:any ): void;
		/** [Method] Sets the value of axes  
		* @param axes Object The new value. 
		*/
		setAxes?( axes?:any ): void;
		/** [Method] Sets the value of gesture  
		* @param gesture String The new value. 
		*/
		setGesture?( gesture?:string ): void;
		/** [Method] Sets the value of lines  
		* @param lines Object The new value. 
		*/
		setLines?( lines?:any ): void;
	}
}
declare module Ext.chart.interactions {
	export interface ICrossZoom extends Ext.chart.interactions.IAbstract {
		/** [Config Option] (Object/Array) */
		axes?: any;
		/** [Config Option] (String) */
		gesture?: string;
		/** [Method] Returns the value of axes  
		* @returns Object/Array 
		*/
		getAxes?(): any;
		/** [Method] Returns the value of gesture  
		* @returns String 
		*/
		getGesture?(): string;
		/** [Method] Returns the value of undoButton  
		* @returns Object 
		*/
		getUndoButton?(): any;
		/** [Method] Placeholder method  
		* @param e Object 
		*/
		onGesture?( e?:any ): void;
		/** [Method] Sets the value of axes  
		* @param axes Object/Array The new value. 
		*/
		setAxes?( axes?:any ): void;
		/** [Method] Sets the value of gesture  
		* @param gesture String The new value. 
		*/
		setGesture?( gesture?:string ): void;
		/** [Method] Sets the value of undoButton  
		* @param undoButton Object The new value. 
		*/
		setUndoButton?( undoButton?:any ): void;
	}
}
declare module Ext.chart.interactions {
	export interface IItemHighlight extends Ext.chart.interactions.IAbstract {
		/** [Config Option] (String) */
		gesture?: string;
		/** [Method] Returns the value of gesture  
		* @returns String 
		*/
		getGesture?(): string;
		/** [Method] Placeholder method  
		* @param series Object 
		* @param item Object 
		* @param e Object 
		*/
		onGesture?( series?:any, item?:any, e?:any ): void;
		/** [Method] Sets the value of gesture  
		* @param gesture String The new value. 
		*/
		setGesture?( gesture?:string ): void;
	}
}
declare module Ext.chart.interactions {
	export interface IItemInfo extends Ext.chart.interactions.IAbstract {
		/** [Config Option] (String) */
		gesture?: string;
		/** [Config Option] (Object) */
		panel?: any;
		/** [Method] Returns the value of gesture  
		* @returns String 
		*/
		getGesture?(): string;
		/** [Method] Returns the value of panel  
		* @returns Object 
		*/
		getPanel?(): any;
		/** [Method] Placeholder method  
		* @param series Object 
		* @param item Object 
		*/
		onGesture?( series?:any, item?:any ): void;
		/** [Method] Sets the value of gesture  
		* @param gesture String The new value. 
		*/
		setGesture?( gesture?:string ): void;
		/** [Method] Sets the value of panel  
		* @param panel Object The new value. 
		*/
		setPanel?( panel?:any ): void;
	}
}
declare module Ext.chart.interactions {
	export interface IPanZoom extends Ext.chart.interactions.IAbstract {
		/** [Config Option] (Object/Array) */
		axes?: any;
		/** [Config Option] (Object) */
		overflowArrowOptions?: any;
		/** [Config Option] (Boolean) */
		showOverflowArrows?: boolean;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the value of axes  
		* @returns Object/Array 
		*/
		getAxes?(): any;
		/** [Method] Returns the value of hideLabelInGesture  
		* @returns Boolean 
		*/
		getHideLabelInGesture?(): boolean;
		/** [Method] Returns the value of maxZoom  
		* @returns Object 
		*/
		getMaxZoom?(): any;
		/** [Method] Returns the value of minZoom  
		* @returns Object 
		*/
		getMinZoom?(): any;
		/** [Method] Returns the value of modeToggleButton  
		* @returns Object 
		*/
		getModeToggleButton?(): any;
		/** [Method] Returns the value of panGesture  
		* @returns String 
		*/
		getPanGesture?(): string;
		/** [Method] Returns the value of showOverflowArrows  
		* @returns Boolean 
		*/
		getShowOverflowArrows?(): boolean;
		/** [Method] Returns the value of zoomOnPanGesture  
		* @returns Boolean 
		*/
		getZoomOnPanGesture?(): boolean;
		/** [Method] Placeholder method  
		* @param e Object 
		*/
		onGesture?( e?:any ): void;
		/** [Method] Sets the value of axes  
		* @param axes Object/Array The new value. 
		*/
		setAxes?( axes?:any ): void;
		/** [Method] Sets the value of hideLabelInGesture  
		* @param hideLabelInGesture Boolean The new value. 
		*/
		setHideLabelInGesture?( hideLabelInGesture?:boolean ): void;
		/** [Method] Sets the value of maxZoom  
		* @param maxZoom Object The new value. 
		*/
		setMaxZoom?( maxZoom?:any ): void;
		/** [Method] Sets the value of minZoom  
		* @param minZoom Object The new value. 
		*/
		setMinZoom?( minZoom?:any ): void;
		/** [Method] Sets the value of modeToggleButton  
		* @param modeToggleButton Object The new value. 
		*/
		setModeToggleButton?( modeToggleButton?:any ): void;
		/** [Method] Sets the value of panGesture  
		* @param panGesture String The new value. 
		*/
		setPanGesture?( panGesture?:string ): void;
		/** [Method] Sets the value of showOverflowArrows  
		* @param showOverflowArrows Boolean The new value. 
		*/
		setShowOverflowArrows?( showOverflowArrows?:boolean ): void;
		/** [Method] Sets the value of zoomOnPanGesture  
		* @param zoomOnPanGesture Boolean The new value. 
		*/
		setZoomOnPanGesture?( zoomOnPanGesture?:boolean ): void;
	}
}
declare module Ext.chart.interactions {
	export interface IRotate extends Ext.chart.interactions.IAbstract {
		/** [Config Option] (String) */
		gesture?: string;
		/** [Method] Returns the value of gesture  
		* @returns String 
		*/
		getGesture?(): string;
		/** [Method] Placeholder method  
		* @param e Object 
		*/
		onGesture?( e?:any ): void;
		/** [Method] Sets the value of gesture  
		* @param gesture String The new value. 
		*/
		setGesture?( gesture?:string ): void;
	}
}
declare module Ext.chart.interactions {
	export interface IRotatePie3D extends Ext.chart.interactions.IRotate {
	}
}
declare module Ext.chart.label {
	export interface ICallout extends Ext.draw.modifier.IModifier {
		/** [Method] Invoked when changes need to be popped up to the top  
		* @param attr Object 
		* @param changes Object 
		*/
		popUp?( attr?:any, changes?:any ): void;
		/** [Method] Validate attribute set before use  
		* @param attr Object 
		*/
		prepareAttributes?( attr?:any ): void;
		/** [Method] Invoked when changes need to be pushed down to the sprite  
		* @param attr Object 
		* @param changes Object 
		* @returns Mixed 
		*/
		pushDown?( attr?:any, changes?:any ): any;
	}
}
declare module Ext.chart.label {
	export interface ILabel extends Ext.draw.sprite.IText {
		/** [Config Option] (Object) */
		fx?: any;
		/** [Method] Returns the value of field  
		* @returns Object 
		*/
		getField?(): any;
		/** [Method] Returns the value of fx  
		* @returns Object 
		*/
		getFx?(): any;
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @param clipRegion Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any, clipRegion?:any ): any;
		/** [Method] Sets the value of field  
		* @param field Object The new value. 
		*/
		setField?( field?:any ): void;
		/** [Method] Sets the value of fx  
		* @param fx Object The new value. 
		*/
		setFx?( fx?:any ): void;
	}
}
declare module Ext.chart {
	export interface ILegend extends Ext.dataview.IDataView {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Boolean) */
		disableSelection?: boolean;
		/** [Config Option] (String) */
		docked?: string;
		/** [Config Option] (Boolean/Object) */
		inline?: any;
		/** [Config Option] (String/String[]/Ext.XTemplate) */
		itemTpl?: any;
		/** [Config Option] (Number/String) */
		padding?: any;
		/** [Config Option] (String) */
		position?: string;
		/** [Config Option] (Boolean) */
		toggleable?: boolean;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of disableSelection  
		* @returns Boolean 
		*/
		getDisableSelection?(): boolean;
		/** [Method] Returns the value of docked  
		* @returns String 
		*/
		getDocked?(): string;
		/** [Method] Returns the value of horizontalHeight  
		* @returns Number 
		*/
		getHorizontalHeight?(): number;
		/** [Method] Returns the value of inline  
		* @returns Boolean 
		*/
		getInline?(): boolean;
		/** [Method] Returns the value of itemTpl  
		* @returns Array 
		*/
		getItemTpl?(): any[];
		/** [Method] Returns the value of padding  
		* @returns Number 
		*/
		getPadding?(): number;
		/** [Method] Returns the value of toggleable  
		* @returns Boolean 
		*/
		getToggleable?(): boolean;
		/** [Method] Returns the value of verticalWidth  
		* @returns Number 
		*/
		getVerticalWidth?(): number;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of disableSelection  
		* @param disableSelection Boolean The new value. 
		*/
		setDisableSelection?( disableSelection?:boolean ): void;
		/** [Method] Sets the value of docked  
		* @param docked String The new value. 
		*/
		setDocked?( docked?:string ): void;
		/** [Method] Sets the value of horizontalHeight  
		* @param horizontalHeight Number The new value. 
		*/
		setHorizontalHeight?( horizontalHeight?:number ): void;
		/** [Method] Sets the value of inline  
		* @param inline Boolean The new value. 
		*/
		setInline?( inline?:boolean ): void;
		/** [Method] Sets the value of itemTpl  
		* @param itemTpl Array The new value. 
		*/
		setItemTpl?( itemTpl?:any[] ): void;
		/** [Method] Sets the value of padding  
		* @param padding Number The new value. 
		*/
		setPadding?( padding?:number ): void;
		/** [Method] Sets the value of toggleable  
		* @param toggleable Boolean The new value. 
		*/
		setToggleable?( toggleable?:boolean ): void;
		/** [Method] Sets the value of verticalWidth  
		* @param verticalWidth Number The new value. 
		*/
		setVerticalWidth?( verticalWidth?:number ): void;
	}
}
declare module Ext.chart {
	export interface IMarkerHolder extends Ext.mixin.IMixin {
		/** [Method]  
		* @param name String 
		* @param marker Ext.chart.Markers 
		*/
		bindMarker?( name?:string, marker?:Ext.chart.IMarkers ): void;
	}
}
declare module Ext.chart {
	export interface IMarkers extends Ext.draw.sprite.IInstancing {
		/** [Method] Clear the markers in the category 
		* @param category String 
		*/
		clear?( category?:string ): void;
		/** [Method] Not supported  
		* @returns null 
		*/
		getBBox?(): any;
		/** [Method]  
		* @param category String 
		* @param index Mixed 
		* @param isWithoutTransform Boolean 
		*/
		getMarkerBBoxFor?( category?:string, index?:any, isWithoutTransform?:boolean ): void;
		/** [Method] Put a marker in the category with additional attributes  
		* @param category String 
		* @param markerAttr Object 
		* @param index String|Number 
		* @param canonical Boolean 
		* @param keepRevision Boolean 
		*/
		putMarkerFor?( category?:string, markerAttr?:any, index?:any, canonical?:boolean, keepRevision?:boolean ): void;
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @param clipRegion Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any, clipRegion?:any ): any;
	}
}
declare module Ext.chart {
	export interface IPolarChart extends Ext.chart.IAbstractChart {
		/** [Config Option] (Array) */
		center?: any[];
		/** [Config Option] (Number) */
		radius?: number;
		/** [Method] Returns the value of center  
		* @returns Array 
		*/
		getCenter?(): any[];
		/** [Method] Returns the value of radius  
		* @returns Number 
		*/
		getRadius?(): number;
		/** [Method] Redraw the chart  */
		redraw?(): void;
		/** [Method] Sets the value of center  
		* @param center Array The new value. 
		*/
		setCenter?( center?:any[] ): void;
		/** [Method] Sets the value of radius  
		* @param radius Number The new value. 
		*/
		setRadius?( radius?:number ): void;
	}
}
declare module Ext.chart.series {
	export interface IArea extends Ext.chart.series.IStackedCartesian {
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
	}
}
declare module Ext.chart.series {
	export interface IBar extends Ext.chart.series.IStackedCartesian {
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] For a given x y point relative to the main region find a corresponding item from this series if any  
		* @param x Object 
		* @param y Object 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain at least the following: 
		*/
		getItemForPoint?( x?:any, y?:any ): any;
	}
}
declare module Ext.chart.series {
	export interface ICandleStick extends Ext.chart.series.ICartesian {
		/** [Config Option] (String) */
		closeField?: string;
		/** [Config Option] (String) */
		highField?: string;
		/** [Config Option] (String) */
		lowField?: string;
		/** [Config Option] (String) */
		openField?: string;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Returns the value of closeField  
		* @returns String 
		*/
		getCloseField?(): string;
		/** [Method] Returns the value of highField  
		* @returns String 
		*/
		getHighField?(): string;
		/** [Method] Returns the value of lowField  
		* @returns String 
		*/
		getLowField?(): string;
		/** [Method] Returns the value of openField  
		* @returns String 
		*/
		getOpenField?(): string;
		/** [Method] Sets the value of closeField  
		* @param closeField String The new value. 
		*/
		setCloseField?( closeField?:string ): void;
		/** [Method] Sets the value of highField  
		* @param highField String The new value. 
		*/
		setHighField?( highField?:string ): void;
		/** [Method] Sets the value of lowField  
		* @param lowField String The new value. 
		*/
		setLowField?( lowField?:string ): void;
		/** [Method] Sets the value of openField  
		* @param openField String The new value. 
		*/
		setOpenField?( openField?:string ): void;
	}
}
declare module Ext.chart.series {
	export interface ICartesian extends Ext.chart.series.ISeries {
		/** [Config Option] (Ext.chart.axis.Axis) */
		xAxis?: Ext.chart.axis.IAxis;
		/** [Config Option] (String) */
		xField?: string;
		/** [Config Option] (Ext.chart.axis.Axis) */
		yAxis?: Ext.chart.axis.IAxis;
		/** [Config Option] (String) */
		yField?: string;
		/** [Method] For a given x y point relative to the main region find a corresponding item from this series if any  
		* @param x Object 
		* @param y Object 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain at least the following: 
		*/
		getItemForPoint?( x?:any, y?:any ): any;
		/** [Method] Performs drawing of this series  */
		getSprites?(): void;
		/** [Method] Returns the value of xAxis  
		* @returns Ext.chart.axis.Axis 
		*/
		getXAxis?(): Ext.chart.axis.IAxis;
		/** [Method] Returns the value of xField  
		* @returns String 
		*/
		getXField?(): string;
		/** [Method] Returns the value of yAxis  
		* @returns Ext.chart.axis.Axis 
		*/
		getYAxis?(): Ext.chart.axis.IAxis;
		/** [Method] Returns the value of yField  
		* @returns String 
		*/
		getYField?(): string;
		/** [Method] Provide legend information to target array  
		* @param target Object 
		*/
		provideLegendInfo?( target?:any ): void;
		/** [Method] Sets the value of xAxis  
		* @param xAxis Ext.chart.axis.Axis The new value. 
		*/
		setXAxis?( xAxis?:Ext.chart.axis.IAxis ): void;
		/** [Method] Sets the value of xField  
		* @param xField String The new value. 
		*/
		setXField?( xField?:string ): void;
		/** [Method] Sets the value of yAxis  
		* @param yAxis Ext.chart.axis.Axis The new value. 
		*/
		setYAxis?( yAxis?:Ext.chart.axis.IAxis ): void;
		/** [Method] Sets the value of yField  
		* @param yField String The new value. 
		*/
		setYField?( yField?:string ): void;
	}
}
declare module Ext.chart.series {
	export interface IGauge extends Ext.chart.series.ISeries {
		/** [Config Option] (String) */
		angleField?: string;
		/** [Config Option] (Array) */
		colors?: any[];
		/** [Config Option] (Number) */
		donut?: number;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Number) */
		maximum?: number;
		/** [Config Option] (Number) */
		minimum?: number;
		/** [Config Option] (Boolean) */
		needle?: boolean;
		/** [Config Option] (Number) */
		needleLength?: number;
		/** [Config Option] (Number) */
		needleLengthRatio?: number;
		/** [Config Option] (Number) */
		needleWidth?: number;
		/** [Config Option] (Array) */
		sectors?: any[];
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Number) */
		value?: number;
		/** [Config Option] (Boolean) */
		wholeDisk?: boolean;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Returns the value of angleField  
		* @returns String 
		*/
		getAngleField?(): string;
		/** [Method] Returns the value of center  
		* @returns Array 
		*/
		getCenter?(): any[];
		/** [Method] Returns the value of colors  
		* @returns Array 
		*/
		getColors?(): any[];
		/** [Method] Returns the value of donut  
		* @returns Number 
		*/
		getDonut?(): number;
		/** [Method] Returns the value of field  
		* @returns String 
		*/
		getField?(): string;
		/** [Method] Returns the value of maximum  
		* @returns Number 
		*/
		getMaximum?(): number;
		/** [Method] Returns the value of minimum  
		* @returns Number 
		*/
		getMinimum?(): number;
		/** [Method] Returns the value of needle  
		* @returns Boolean 
		*/
		getNeedle?(): boolean;
		/** [Method] Returns the value of needleLength  
		* @returns Number 
		*/
		getNeedleLength?(): number;
		/** [Method] Returns the value of needleLengthRatio  
		* @returns Number 
		*/
		getNeedleLengthRatio?(): number;
		/** [Method] Returns the value of needleWidth  
		* @returns Number 
		*/
		getNeedleWidth?(): number;
		/** [Method] Returns the value of radius  
		* @returns Number 
		*/
		getRadius?(): number;
		/** [Method] Returns the value of region  
		* @returns Array 
		*/
		getRegion?(): any[];
		/** [Method] Returns the value of rotation  
		* @returns Number 
		*/
		getRotation?(): number;
		/** [Method] Returns the value of sectors  
		* @returns Array 
		*/
		getSectors?(): any[];
		/** [Method] Returns the value of showInLegend  
		* @returns Boolean 
		*/
		getShowInLegend?(): boolean;
		/** [Method] Performs drawing of this series  */
		getSprites?(): void;
		/** [Method] Returns the value of totalAngle  
		* @returns Object 
		*/
		getTotalAngle?(): any;
		/** [Method] Returns the value of value  
		* @returns Number 
		*/
		getValue?(): number;
		/** [Method] Returns the value of wholeDisk  
		* @returns Boolean 
		*/
		getWholeDisk?(): boolean;
		/** [Method] Sets the value of angleField  
		* @param angleField String The new value. 
		*/
		setAngleField?( angleField?:string ): void;
		/** [Method] Sets the value of center  
		* @param center Array The new value. 
		*/
		setCenter?( center?:any[] ): void;
		/** [Method] Sets the value of colors  
		* @param colors Array The new value. 
		*/
		setColors?( colors?:any[] ): void;
		/** [Method] Sets the value of donut  
		* @param donut Number The new value. 
		*/
		setDonut?( donut?:number ): void;
		/** [Method] Sets the value of field  
		* @param field String The new value. 
		*/
		setField?( field?:string ): void;
		/** [Method] Sets the value of maximum  
		* @param maximum Number The new value. 
		*/
		setMaximum?( maximum?:number ): void;
		/** [Method] Sets the value of minimum  
		* @param minimum Number The new value. 
		*/
		setMinimum?( minimum?:number ): void;
		/** [Method] Sets the value of needle  
		* @param needle Boolean The new value. 
		*/
		setNeedle?( needle?:boolean ): void;
		/** [Method] Sets the value of needleLength  
		* @param needleLength Number The new value. 
		*/
		setNeedleLength?( needleLength?:number ): void;
		/** [Method] Sets the value of needleLengthRatio  
		* @param needleLengthRatio Number The new value. 
		*/
		setNeedleLengthRatio?( needleLengthRatio?:number ): void;
		/** [Method] Sets the value of needleWidth  
		* @param needleWidth Number The new value. 
		*/
		setNeedleWidth?( needleWidth?:number ): void;
		/** [Method] Sets the value of radius  
		* @param radius Number The new value. 
		*/
		setRadius?( radius?:number ): void;
		/** [Method] Sets the value of region  
		* @param region Array The new value. 
		*/
		setRegion?( region?:any[] ): void;
		/** [Method] Sets the value of rotation  
		* @param rotation Number The new value. 
		*/
		setRotation?( rotation?:number ): void;
		/** [Method] Sets the value of sectors  
		* @param sectors Array The new value. 
		*/
		setSectors?( sectors?:any[] ): void;
		/** [Method] Sets the value of showInLegend  
		* @param showInLegend Boolean The new value. 
		*/
		setShowInLegend?( showInLegend?:boolean ): void;
		/** [Method] Sets the value of totalAngle  
		* @param totalAngle Object The new value. 
		*/
		setTotalAngle?( totalAngle?:any ): void;
		/** [Method] Sets the value of value  
		* @param value Number The new value. 
		*/
		setValue?( value?:number ): void;
		/** [Method] Sets the value of wholeDisk  
		* @param wholeDisk Boolean The new value. 
		*/
		setWholeDisk?( wholeDisk?:boolean ): void;
	}
}
declare module Ext.chart.series {
	export interface IItemPublisher extends Ext.event.publisher.IPublisher {
	}
}
declare module Ext.chart.series {
	export interface ILine extends Ext.chart.series.ICartesian {
		/** [Config Option] (Boolean) */
		fill?: boolean;
		/** [Config Option] (Number) */
		selectionTolerance?: number;
		/** [Config Option] (Boolean/Number) */
		smooth?: any;
		/** [Config Option] (Boolean) */
		step?: boolean;
		/** [Config Option] (Object) */
		style?: any;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Returns the value of aggregator  
		* @returns Object 
		*/
		getAggregator?(): any;
		/** [Method] Returns the value of fill  
		* @returns Boolean 
		*/
		getFill?(): boolean;
		/** [Method] Returns the value of selectionTolerance  
		* @returns Number 
		*/
		getSelectionTolerance?(): number;
		/** [Method] Returns the value of smooth  
		* @returns Boolean/Number 
		*/
		getSmooth?(): any;
		/** [Method] Returns the value of step  
		* @returns Boolean 
		*/
		getStep?(): boolean;
		/** [Method] Sets the value of aggregator  
		* @param aggregator Object The new value. 
		*/
		setAggregator?( aggregator?:any ): void;
		/** [Method] Sets the value of fill  
		* @param fill Boolean The new value. 
		*/
		setFill?( fill?:boolean ): void;
		/** [Method] Sets the value of selectionTolerance  
		* @param selectionTolerance Number The new value. 
		*/
		setSelectionTolerance?( selectionTolerance?:number ): void;
		/** [Method] Sets the value of smooth  
		* @param smooth Boolean/Number The new value. 
		*/
		setSmooth?( smooth?:any ): void;
		/** [Method] Sets the value of step  
		* @param step Boolean The new value. 
		*/
		setStep?( step?:boolean ): void;
	}
}
declare module Ext.chart.series {
	export interface IPie extends Ext.chart.series.IPolar {
		/** [Config Option] (Number) */
		Allows?: number;
		/** [Config Option] (Boolean/Number) */
		donut?: any;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Array) */
		hidden?: any[];
		/** [Config Option] (String) */
		labelField?: string;
		/** [Config Option] (Number) */
		rotation?: number;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (Number) */
		totalAngle?: number;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Returns the value of donut  
		* @returns Boolean/Number 
		*/
		getDonut?(): any;
		/** [Method] Returns the pie slice for a given angle 
		* @param angle Number The angle to search for the slice 
		* @returns Object An object containing the reocord, sprite, scope etc. 
		*/
		getItemForAngle?( angle?:number ): any;
		/** [Method] For a given x y point relative to the main region find a corresponding item from this series if any  
		* @param x Object 
		* @param y Object 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain at least the following: 
		*/
		getItemForPoint?( x?:any, y?:any ): any;
		/** [Method] Returns the value of labelField  
		* @returns String 
		*/
		getLabelField?(): string;
		/** [Method] Returns the value of rotation  
		* @returns Number 
		*/
		getRotation?(): number;
		/** [Method] Performs drawing of this series  */
		getSprites?(): void;
		/** [Method] Returns the value of style  
		* @returns Object 
		*/
		getStyle?(): any;
		/** [Method] Returns the value of totalAngle  
		* @returns Number 
		*/
		getTotalAngle?(): number;
		/** [Method] Provide legend information to target array  
		* @param target Object 
		*/
		provideLegendInfo?( target?:any ): void;
		/** [Method] Sets the value of donut  
		* @param donut Boolean/Number The new value. 
		*/
		setDonut?( donut?:any ): void;
		/** [Method] Sets the value of hidden  
		* @param hidden Array The new value. 
		*/
		setHidden?( hidden?:any[] ): void;
		/** [Method] Sets the value of labelField  
		* @param labelField String The new value. 
		*/
		setLabelField?( labelField?:string ): void;
		/** [Method] Sets the value of rotation  
		* @param rotation Number The new value. 
		*/
		setRotation?( rotation?:number ): void;
		/** [Method] Sets the value of style  
		* @param style Object The new value. 
		*/
		setStyle?( style?:any ): void;
		/** [Method] Sets the value of totalAngle  
		* @param totalAngle Number The new value. 
		*/
		setTotalAngle?( totalAngle?:number ): void;
	}
}
declare module Ext.chart.series {
	export interface IPie3D extends Ext.chart.series.IPolar {
		/** [Config Option] (Boolean/Number) */
		donut?: any;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Number) */
		rotation?: number;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Returns the value of distortion  
		* @returns Number 
		*/
		getDistortion?(): number;
		/** [Method] Returns the value of donut  
		* @returns Boolean/Number 
		*/
		getDonut?(): any;
		/** [Method] Returns the value of field  
		* @returns String 
		*/
		getField?(): string;
		/** [Method] Returns the value of region  
		* @returns Array 
		*/
		getRegion?(): any[];
		/** [Method] Returns the value of rotation  
		* @returns Number 
		*/
		getRotation?(): number;
		/** [Method] Performs drawing of this series  */
		getSprites?(): void;
		/** [Method] Returns the value of thickness  
		* @returns Number 
		*/
		getThickness?(): number;
		/** [Method] Sets the value of distortion  
		* @param distortion Number The new value. 
		*/
		setDistortion?( distortion?:number ): void;
		/** [Method] Sets the value of donut  
		* @param donut Boolean/Number The new value. 
		*/
		setDonut?( donut?:any ): void;
		/** [Method] Sets the value of field  
		* @param field String The new value. 
		*/
		setField?( field?:string ): void;
		/** [Method] Sets the value of region  
		* @param region Array The new value. 
		*/
		setRegion?( region?:any[] ): void;
		/** [Method] Sets the value of rotation  
		* @param rotation Number The new value. 
		*/
		setRotation?( rotation?:number ): void;
		/** [Method] Sets the value of thickness  
		* @param thickness Number The new value. 
		*/
		setThickness?( thickness?:number ): void;
	}
}
declare module Ext.chart.series {
	export interface IPolar extends Ext.chart.series.ISeries {
		/** [Config Option] (Array) */
		center?: any[];
		/** [Config Option] (Number) */
		offsetX?: number;
		/** [Config Option] (Number) */
		offsetY?: number;
		/** [Config Option] (Number) */
		radius?: number;
		/** [Config Option] (Number) */
		rotation?: number;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (String) */
		xField?: string;
		/** [Config Option] (String) */
		yField?: string;
		/** [Method] Returns the value of center  
		* @returns Array 
		*/
		getCenter?(): any[];
		/** [Method] Returns the value of offsetX  
		* @returns Number 
		*/
		getOffsetX?(): number;
		/** [Method] Returns the value of offsetY  
		* @returns Number 
		*/
		getOffsetY?(): number;
		/** [Method] Returns the value of radius  
		* @returns Number 
		*/
		getRadius?(): number;
		/** [Method] Returns the value of rotation  
		* @returns Number 
		*/
		getRotation?(): number;
		/** [Method] Returns the value of showInLegend  
		* @returns Boolean 
		*/
		getShowInLegend?(): boolean;
		/** [Method] Returns the value of xAxis  
		* @returns Object 
		*/
		getXAxis?(): any;
		/** [Method] Returns the value of xField  
		* @returns String 
		*/
		getXField?(): string;
		/** [Method] Returns the value of yAxis  
		* @returns Object 
		*/
		getYAxis?(): any;
		/** [Method] Returns the value of yField  
		* @returns String 
		*/
		getYField?(): string;
		/** [Method] Sets the value of center  
		* @param center Array The new value. 
		*/
		setCenter?( center?:any[] ): void;
		/** [Method] Sets the value of offsetX  
		* @param offsetX Number The new value. 
		*/
		setOffsetX?( offsetX?:number ): void;
		/** [Method] Sets the value of offsetY  
		* @param offsetY Number The new value. 
		*/
		setOffsetY?( offsetY?:number ): void;
		/** [Method] Sets the value of radius  
		* @param radius Number The new value. 
		*/
		setRadius?( radius?:number ): void;
		/** [Method] Sets the value of rotation  
		* @param rotation Number The new value. 
		*/
		setRotation?( rotation?:number ): void;
		/** [Method] Sets the value of showInLegend  
		* @param showInLegend Boolean The new value. 
		*/
		setShowInLegend?( showInLegend?:boolean ): void;
		/** [Method] Sets the value of xAxis  
		* @param xAxis Object The new value. 
		*/
		setXAxis?( xAxis?:any ): void;
		/** [Method] Sets the value of xField  
		* @param xField String The new value. 
		*/
		setXField?( xField?:string ): void;
		/** [Method] Sets the value of yAxis  
		* @param yAxis Object The new value. 
		*/
		setYAxis?( yAxis?:any ): void;
		/** [Method] Sets the value of yField  
		* @param yField String The new value. 
		*/
		setYField?( yField?:string ): void;
	}
}
declare module Ext.chart.series {
	export interface IRadar extends Ext.chart.series.IPolar {
		/** [Config Option] (Object) */
		style?: any;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] For a given x y point relative to the main region find a corresponding item from this series if any  
		* @param x Object 
		* @param y Object 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain at least the following: 
		*/
		getItemForPoint?( x?:any, y?:any ): any;
	}
}
declare module Ext.chart.series {
	export interface IScatter extends Ext.chart.series.ICartesian {
		/** [Config Option] (Object) */
		itemInstancing?: any;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Returns the value of itemInstancing  
		* @returns Object 
		*/
		getItemInstancing?(): any;
		/** [Method] Provide legend information to target array  
		* @param target Object 
		*/
		provideLegendInfo?( target?:any ): void;
		/** [Method] Sets the value of itemInstancing  
		* @param itemInstancing Object The new value. 
		*/
		setItemInstancing?( itemInstancing?:any ): void;
	}
}
declare module Ext.chart.series {
	export interface ISeries extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Object) */
		animate?: any;
		/** [Config Option] (Object) */
		background?: any;
		/** [Config Option] (Array) */
		colors?: any[];
		/** [Config Option] (Boolean|Array) */
		hidden?: any;
		/** [Config Option] (Object) */
		highlightCfg?: any;
		/** [Config Option] (Object) */
		highlightItem?: any;
		/** [Config Option] (Object) */
		itemInstancing?: any;
		/** [Config Option] (Object) */
		label?: any;
		/** [Config Option] (String/String[]) */
		labelField?: any;
		/** [Config Option] (Number) */
		labelOverflowPadding?: number;
		/** [Config Option] (Object) */
		marker?: any;
		/** [Config Option] (Object) */
		markerSubStyle?: any;
		/** [Config Option] (Object) */
		overlaySurface?: any;
		/** [Config Option] (Function) */
		renderer?: any;
		/** [Config Option] (Boolean) */
		showInLegend?: boolean;
		/** [Config Option] (Object) */
		store?: any;
		/** [Config Option] (Object) */
		style?: any;
		/** [Config Option] (Object) */
		subStyle?: any;
		/** [Config Option] (Object) */
		surface?: any;
		/** [Config Option] (String) */
		title?: string;
		/** [Property] (String) */
		seriesType?: string;
		/** [Property] (String) */
		type?: string;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of animate  
		* @returns Object 
		*/
		getAnimate?(): any;
		/** [Method] Returns the value of background  
		* @returns Object 
		*/
		getBackground?(): any;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of colors  
		* @returns Array 
		*/
		getColors?(): any[];
		/** [Method] Returns the value of hidden  
		* @returns Boolean|Array 
		*/
		getHidden?(): any;
		/** [Method] Returns the value of highlightCfg  
		* @returns Object 
		*/
		getHighlightCfg?(): any;
		/** [Method] Returns the value of highlightItem  
		* @returns Object 
		*/
		getHighlightItem?(): any;
		/** [Method] For a given x y point relative to the main region find a corresponding item from this series if any  
		* @param x Number 
		* @param y Number 
		* @param target Object optional target to receive the result 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain at least the following: 
		*/
		getItemForPoint?( x?:number, y?:number, target?:any ): any;
		/** [Method] Returns the value of itemInstancing  
		* @returns Object 
		*/
		getItemInstancing?(): any;
		/** [Method] Returns the value of label  
		* @returns Object 
		*/
		getLabel?(): any;
		/** [Method] Returns the value of labelField  
		* @returns String/String[] 
		*/
		getLabelField?(): any;
		/** [Method] Returns the value of labelOverflowPadding  
		* @returns Number 
		*/
		getLabelOverflowPadding?(): number;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of marker  
		* @returns Object 
		*/
		getMarker?(): any;
		/** [Method] Returns the value of markerSubStyle  
		* @returns Object 
		*/
		getMarkerSubStyle?(): any;
		/** [Method] Returns the value of overlaySurface  
		* @returns Object 
		*/
		getOverlaySurface?(): any;
		/** [Method] Returns the value of renderer  
		* @returns Function 
		*/
		getRenderer?(): any;
		/** [Method] Returns the value of showInLegend  
		* @returns Boolean 
		*/
		getShowInLegend?(): boolean;
		/** [Method] Performs drawing of this series  */
		getSprites?(): void;
		/** [Method] Returns the value of style  
		* @returns Object 
		*/
		getStyle?(): any;
		/** [Method] Returns the value of subStyle  
		* @returns Object 
		*/
		getSubStyle?(): any;
		/** [Method] Returns the value of surface  
		* @returns Object 
		*/
		getSurface?(): any;
		/** [Method] Returns the value of title  
		* @returns String 
		*/
		getTitle?(): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Provide legend information to target array  
		* @param target Array The information consists: 
		*/
		provideLegendInfo?( target?:any[] ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of animate  
		* @param animate Object The new value. 
		*/
		setAnimate?( animate?:any ): void;
		/** [Method] Sets the value of background  
		* @param background Object The new value. 
		*/
		setBackground?( background?:any ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of colors  
		* @param colors Array The new value. 
		*/
		setColors?( colors?:any[] ): void;
		/** [Method] Sets the value of hidden  
		* @param hidden Boolean|Array The new value. 
		*/
		setHidden?( hidden?:any ): void;
		/** [Method]  
		* @param index Number 
		* @param value Boolean 
		*/
		setHiddenByIndex?( index?:number, value?:boolean ): void;
		/** [Method] Sets the value of highlightCfg  
		* @param highlightCfg Object The new value. 
		*/
		setHighlightCfg?( highlightCfg?:any ): void;
		/** [Method] Sets the value of highlightItem  
		* @param highlightItem Object The new value. 
		*/
		setHighlightItem?( highlightItem?:any ): void;
		/** [Method] Sets the value of itemInstancing  
		* @param itemInstancing Object The new value. 
		*/
		setItemInstancing?( itemInstancing?:any ): void;
		/** [Method] Sets the value of label  
		* @param label Object The new value. 
		* @returns Object/String The attributes that have been changed or added, or the text for the label. Example to enclose every other label in parentheses: renderer: function (text) { if (index % 2 == 0) { return '(' + text + ')' } } Default value: null. 
		*/
		setLabel?( label?:any ): any;
		/** [Method] Sets the value of labelField  
		* @param labelField String/String[] The new value. 
		*/
		setLabelField?( labelField?:any ): void;
		/** [Method] Sets the value of labelOverflowPadding  
		* @param labelOverflowPadding Number The new value. 
		*/
		setLabelOverflowPadding?( labelOverflowPadding?:number ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of marker  
		* @param marker Object The new value. 
		*/
		setMarker?( marker?:any ): void;
		/** [Method] Sets the value of markerSubStyle  
		* @param markerSubStyle Object The new value. 
		*/
		setMarkerSubStyle?( markerSubStyle?:any ): void;
		/** [Method] Sets the value of overlaySurface  
		* @param overlaySurface Object The new value. 
		*/
		setOverlaySurface?( overlaySurface?:any ): void;
		/** [Method] Sets the value of renderer  
		* @param renderer Function The new value. 
		* @returns Object The attributes that have been changed or added. Note: it is usually possible to add or modify the attributes directly into the config parameter and not return anything, but returning an object with only those attributes that have been changed may allow for optimizations in the rendering of some series. Example to draw every other item in red: renderer: function (sprite, config, rendererData, index) { if (index % 2 == 0) { return { strokeStyle: 'red' }; } }  
		*/
		setRenderer?( renderer?:any ): any;
		/** [Method] Sets the value of showInLegend  
		* @param showInLegend Boolean The new value. 
		*/
		setShowInLegend?( showInLegend?:boolean ): void;
		/** [Method] Sets the value of store  
		* @param store Object The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of style  
		* @param style Object The new value. 
		*/
		setStyle?( style?:any ): void;
		/** [Method] Sets the value of subStyle  
		* @param subStyle Object The new value. 
		*/
		setSubStyle?( subStyle?:any ): void;
		/** [Method] Sets the value of surface  
		* @param surface Object The new value. 
		*/
		setSurface?( surface?:any ): void;
		/** [Method] Sets the value of title  
		* @param title String The new value. 
		*/
		setTitle?( title?:string ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IAggregative extends Ext.chart.series.sprite.ICartesian {
		/** [Config Option] (Object) */
		dataClose?: any;
		/** [Config Option] (Object) */
		dataHigh?: any;
		/** [Config Option] (Object) */
		dataLow?: any;
		/** [Config Option] (Object) */
		dataOpen?: any;
		/** [Method] Returns the value of aggregator  
		* @returns Object 
		*/
		getAggregator?(): any;
		/** [Method] Render the given visible clip range  
		* @param surface Object 
		* @param ctx Object 
		* @param clip Object 
		* @param region Object 
		*/
		renderClipped?( surface?:any, ctx?:any, clip?:any, region?:any ): void;
		/** [Method] Sets the value of aggregator  
		* @param aggregator Object The new value. 
		*/
		setAggregator?( aggregator?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IArea extends Ext.chart.series.sprite.IStackedCartesian {
		/** [Config Option] (Boolean) */
		step?: boolean;
		/** [Method] Render the given visible clip range  
		* @param surface Object 
		* @param ctx Object 
		* @param clip Object 
		* @param clipRegion Object 
		*/
		renderClipped?( surface?:any, ctx?:any, clip?:any, clipRegion?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IBar extends Ext.chart.series.sprite.IStackedCartesian {
		/** [Config Option] (Number) */
		inGroupGapWidth?: number;
		/** [Config Option] (Number) */
		maxBarWidth?: number;
		/** [Config Option] (Number) */
		minBarWidth?: number;
		/** [Config Option] (Number) */
		minGapWidth?: number;
		/** [Config Option] (Number) */
		radius?: number;
		/** [Method] Get the nearest item index from point x y 
		* @param x Object 
		* @param y Object 
		* @returns Number The index 
		*/
		getIndexNearPoint?( x?:any, y?:any ): number;
		/** [Method] Render the given visible clip range  
		* @param surface Object 
		* @param ctx Object 
		* @param clip Object 
		*/
		renderClipped?( surface?:any, ctx?:any, clip?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface ICandleStick extends Ext.chart.series.sprite.IAggregative {
		/** [Config Option] (Number) */
		barWidth?: number;
		/** [Config Option] (String) */
		ohlcType?: string;
		/** [Config Option] (Number) */
		padding?: number;
	}
}
declare module Ext.chart.series.sprite {
	export interface ICartesian extends Ext.draw.sprite.ISprite,Ext.chart.IMarkerHolder {
		/** [Config Option] (Array) */
		Data?: any[];
		/** [Config Option] (Boolean) */
		If?: boolean;
		/** [Config Option] (Number) */
		dataMaxX?: number;
		/** [Config Option] (Number) */
		dataMaxY?: number;
		/** [Config Option] (Number) */
		dataMinX?: number;
		/** [Config Option] (Number) */
		dataMinY?: number;
		/** [Config Option] (Object) */
		dataX?: any;
		/** [Config Option] (Object) */
		dataY?: any;
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (Number) */
		labelOverflowPadding?: number;
		/** [Config Option] (Object) */
		labels?: any;
		/** [Config Option] (Number) */
		selectionTolerance?: number;
		/** [Method] Does a binary search of the data on the x axis using the given key  
		* @param key String 
		* @returns * 
		*/
		binarySearch?( key?:string ): any;
		/** [Method]  
		* @param name String 
		* @param marker Ext.chart.Markers 
		*/
		bindMarker?( name?:string, marker?:Ext.chart.IMarkers ): void;
		/** [Method] Returns the value of field  
		* @returns String 
		*/
		getField?(): string;
		/** [Method] Get the nearest item index from point x y 
		* @param x Number 
		* @param y Number 
		* @returns Number The index 
		*/
		getIndexNearPoint?( x?:number, y?:number ): number;
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @param region Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any, region?:any ): any;
		/** [Method] Render the given visible clip range  
		* @param surface Ext.draw.Surface 
		* @param ctx Ext.draw.engine.Canvas/Ext.draw.engine.SvgContext 
		* @param clip Array 
		* @param region Arrary 
		*/
		renderClipped?( surface?:Ext.draw.ISurface, ctx?:any, clip?:any[], region?:any[] ): void;
		/** [Method] Sets the value of field  
		* @param field String The new value. 
		*/
		setField?( field?:string ): void;
		/** [Method] Subclass will fill the plain object with x y width height information of the plain bounding box of this sprite  
		* @param plain Object 
		*/
		updatePlainBBox?( plain?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface ILine extends Ext.chart.series.sprite.IAggregative {
		/** [Config Option] (Boolean) */
		fillArea?: boolean;
		/** [Config Option] (Boolean) */
		preciseStroke?: boolean;
		/** [Config Option] (Boolean) */
		smooth?: boolean;
		/** [Config Option] (Boolean) */
		step?: boolean;
		/** [Method] Subclass will fill the plain object with x y width height information of the plain bounding box of this sprite  
		* @param plain Object 
		*/
		updatePlainBBox?( plain?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IPie3DPart extends Ext.draw.sprite.IPath,Ext.chart.IMarkerHolder {
		/** [Config Option] (Object) */
		baseColor?: any;
		/** [Config Option] (Number) */
		baseRotation?: number;
		/** [Config Option] (Number) */
		centerX?: number;
		/** [Config Option] (Number) */
		centerY?: number;
		/** [Config Option] (Number) */
		distortion?: number;
		/** [Config Option] (Number) */
		endAngle?: number;
		/** [Config Option] (Number) */
		endRho?: number;
		/** [Config Option] (Number) */
		margin?: number;
		/** [Config Option] (String) */
		part?: string;
		/** [Config Option] (Number) */
		startAngle?: number;
		/** [Config Option] (Number) */
		startRho?: number;
		/** [Config Option] (Number) */
		thickness?: number;
		/** [Method]  
		* @param name String 
		* @param marker Ext.chart.Markers 
		*/
		bindMarker?( name?:string, marker?:Ext.chart.IMarkers ): void;
		/** [Method] Update the path  
		* @param path Object 
		*/
		updatePath?( path?:any ): void;
		/** [Method] Subclass will fill the plain object with x y width height information of the plain bounding box of this sprite  
		* @param plain Object 
		*/
		updatePlainBBox?( plain?:any ): void;
		/** [Method] Subclass will fill the plain object with x y width height information of the transformed bounding box of this sprite  
		* @param transform Object 
		*/
		updateTransformedBBox?( transform?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IPieSlice extends Ext.draw.sprite.ISector,Ext.chart.IMarkerHolder {
		/** [Config Option] (Boolean) */
		doCallout?: boolean;
		/** [Config Option] (String) */
		label?: string;
		/** [Config Option] (Number) */
		labelOverflowPadding?: number;
		/** [Config Option] (Boolean) */
		rotateLabels?: boolean;
		/** [Method]  
		* @param name String 
		* @param marker Ext.chart.Markers 
		*/
		bindMarker?( name?:string, marker?:Ext.chart.IMarkers ): void;
		/** [Method] Returns the value of rendererIndex  
		* @returns Number 
		*/
		getRendererIndex?(): number;
		/** [Method] Render method  
		* @param ctx Object 
		* @param surface Object 
		* @param clipRegion Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( ctx?:any, surface?:any, clipRegion?:any ): any;
		/** [Method] Sets the value of rendererIndex  
		* @param rendererIndex Number The new value. 
		*/
		setRendererIndex?( rendererIndex?:number ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IPolar extends Ext.draw.sprite.ISprite,Ext.chart.IMarkerHolder {
		/** [Config Option] (Array) */
		Data?: any[];
		/** [Config Option] (Number) */
		baseRotation?: number;
		/** [Config Option] (Number) */
		centerX?: number;
		/** [Config Option] (Number) */
		centerY?: number;
		/** [Config Option] (Number) */
		dataMaxX?: number;
		/** [Config Option] (Number) */
		dataMaxY?: number;
		/** [Config Option] (Number) */
		dataMinX?: number;
		/** [Config Option] (Number) */
		dataMinY?: number;
		/** [Config Option] (Object) */
		dataX?: any;
		/** [Config Option] (Object) */
		dataY?: any;
		/** [Config Option] (Number) */
		endAngle?: number;
		/** [Config Option] (Number) */
		endRho?: number;
		/** [Config Option] (Number) */
		labelOverflowPadding?: number;
		/** [Config Option] (Object) */
		labels?: any;
		/** [Config Option] (Number) */
		startAngle?: number;
		/** [Config Option] (Number) */
		startRho?: number;
		/** [Method]  
		* @param name String 
		* @param marker Ext.chart.Markers 
		*/
		bindMarker?( name?:string, marker?:Ext.chart.IMarkers ): void;
		/** [Method] Returns the value of field  
		* @returns Object 
		*/
		getField?(): any;
		/** [Method] Sets the value of field  
		* @param field Object The new value. 
		*/
		setField?( field?:any ): void;
		/** [Method] Subclass will fill the plain object with x y width height information of the plain bounding box of this sprite  
		* @param plain Object 
		*/
		updatePlainBBox?( plain?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IRadar extends Ext.chart.series.sprite.IPolar {
		/** [Method] Render method  
		* @param surface Object 
		* @param ctx Object 
		* @returns * returns false to stop rendering in this frame. All the sprite haven't been rendered will have their dirty flag untouched. 
		*/
		render?( surface?:any, ctx?:any ): any;
	}
}
declare module Ext.chart.series.sprite {
	export interface IScatter extends Ext.chart.series.sprite.ICartesian {
		/** [Method] Render the given visible clip range  
		* @param surface Object 
		* @param ctx Object 
		* @param clip Object 
		* @param clipRegion Object 
		*/
		renderClipped?( surface?:any, ctx?:any, clip?:any, clipRegion?:any ): void;
	}
}
declare module Ext.chart.series.sprite {
	export interface IStackedCartesian extends Ext.chart.series.sprite.ICartesian {
		/** [Method] Get the nearest item index from point x y 
		* @param x Object 
		* @param y Object 
		* @returns Number The index 
		*/
		getIndexNearPoint?( x?:any, y?:any ): number;
	}
}
declare module Ext.chart.series {
	export interface IStackedCartesian extends Ext.chart.series.ICartesian {
		/** [Config Option] (Array) */
		hidden?: any[];
		/** [Config Option] (Boolean) */
		stacked?: boolean;
		/** [Method] For a given x y point relative to the main region find a corresponding item from this series if any  
		* @param x Object 
		* @param y Object 
		* @returns Object An object describing the item, or null if there is no matching item. The exact contents of this object will vary by series type, but should always contain at least the following: 
		*/
		getItemForPoint?( x?:any, y?:any ): any;
		/** [Method] Performs drawing of this series  */
		getSprites?(): void;
		/** [Method] Returns the value of stacked  
		* @returns Boolean 
		*/
		getStacked?(): boolean;
		/** [Method] Provide legend information to target array  
		* @param target Object 
		*/
		provideLegendInfo?( target?:any ): void;
		/** [Method] Sets the value of hidden  
		* @param hidden Array The new value. 
		*/
		setHidden?( hidden?:any[] ): void;
		/** [Method] Sets the value of stacked  
		* @param stacked Boolean The new value. 
		*/
		setStacked?( stacked?:boolean ): void;
	}
}
declare module Ext.chart {
	export interface ISpaceFillingChart extends Ext.chart.IAbstractChart {
		/** [Method] Redraw the chart  */
		redraw?(): void;
	}
}
declare module Ext {
	export interface IClass {
		/** [Config Option] (String[]) */
		alias?: string[];
		/** [Config Option] (String/String[]) */
		alternateClassName?: any;
		/** [Config Option] (Object) */
		config?: any;
		/** [Config Option] (String) */
		extend?: string;
		/** [Config Option] (Object) */
		inheritableStatics?: any;
		/** [Config Option] (Object) */
		mixins?: any;
		/** [Config Option] (Object) */
		platformConfig?: any;
		/** [Config Option] (Boolean) */
		singleton?: boolean;
		/** [Config Option] (Object) */
		statics?: any;
		/** [Config Option] (String[]) */
		uses?: string[];
	}
}
declare module Ext {
	export interface IClassManager {
	}
	export class ClassManager {
		/** [Method] Adds a batch of class name to alias mappings 
		* @param aliases Object The set of mappings of the form className : [values...] 
		* @returns Ext.ClassManager this 
		*/
		static addNameAliasMappings( aliases?:any ): Ext.IClassManager;
		/** [Method]  
		* @param alternates Object The set of mappings of the form className : [values...] 
		* @returns Ext.ClassManager this 
		*/
		static addNameAlternateMappings( alternates?:any ): Ext.IClassManager;
		/** [Method] Retrieve a class by its name  
		* @param name String 
		* @returns Ext.Class class 
		*/
		static get( name?:string ): Ext.IClass;
		/** [Method] Get the aliases of a class by the class name 
		* @param name String 
		* @returns Array aliases 
		*/
		static getAliasesByName( name?:string ): any[];
		/** [Method] Get a reference to the class by its alias  
		* @param alias String 
		* @returns Ext.Class class 
		*/
		static getByAlias( alias?:string ): Ext.IClass;
		/** [Method] Get the class of the provided object returns null if it s not an instance of any class created with Ext define  
		* @param object Object 
		* @returns Ext.Class class 
		*/
		static getClass( object?:any ): Ext.IClass;
		/** [Method] Get the name of the class by its reference or its instance usually invoked by the shorthand Ext getClassName Ext Cl  
		* @param object Ext.Class/Object 
		* @returns String className 
		*/
		static getName( object?:any ): string;
		/** [Method] Get the name of a class by its alias  
		* @param alias String 
		* @returns String className 
		*/
		static getNameByAlias( alias?:string ): string;
		/** [Method] Get the name of a class by its alternate name  
		* @param alternate String 
		* @returns String className 
		*/
		static getNameByAlternate( alternate?:string ): string;
		/** [Method] Converts a string expression to an array of matching class names  
		* @param expression String 
		* @returns Array classNames 
		*/
		static getNamesByExpression( expression?:string ): any[];
		/** [Method] Instantiate a class by either full name alias or alternate name usually invoked by the convenient shorthand Ext cre  
		* @param name String 
		* @param args Mixed Additional arguments after the name will be passed to the class' constructor. 
		* @returns Object instance 
		*/
		static instantiate( name?:string, args?:any ): any;
		/** [Method] Instantiate a class by its alias usually invoked by the convenient shorthand Ext createByAlias If Ext Loader is enab  
		* @param alias String 
		* @param args Mixed... Additional arguments after the alias will be passed to the class constructor. 
		* @returns Object instance 
		*/
		static instantiateByAlias( alias:string, ...args:any[] ): any;
		/** [Method] Checks if a class has already been created  
		* @param className String 
		* @returns Boolean exist 
		*/
		static isCreated( className?:string ): boolean;
		/** [Method] Sets a name reference to a class  
		* @param name String 
		* @param value Object 
		* @returns Ext.ClassManager this 
		*/
		static set( name?:string, value?:any ): Ext.IClassManager;
		/** [Method] Register the alias for a class  
		* @param cls Ext.Class/String a reference to a class or a className. 
		* @param alias String Alias to use when referring to this class. 
		* @returns Ext.ClassManager this 
		*/
		static setAlias( cls?:any, alias?:string ): Ext.IClassManager;
		/** [Method] Creates a namespace and assign the value to the created object  
		* @param name String 
		* @param value Mixed 
		*/
		static setNamespace( name?:string, value?:any ): void;
	}
}
declare module Ext {
	export interface IComponent extends Ext.IAbstractComponent,Ext.mixin.ITraversable {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Number/String) */
		border?: any;
		/** [Config Option] (Number/String) */
		bottom?: any;
		/** [Config Option] (Boolean) */
		centered?: boolean;
		/** [Config Option] (String/String[]) */
		cls?: any;
		/** [Config Option] (String) */
		componentCls?: string;
		/** [Config Option] (Ext.Element/HTMLElement/String) */
		contentEl?: any;
		/** [Config Option] (Object) */
		data?: any;
		/** [Config Option] (Boolean) */
		disabled?: boolean;
		/** [Config Option] (String) */
		disabledCls?: string;
		/** [Config Option] (String) */
		dock?: string;
		/** [Config Option] (String) */
		docked?: string;
		/** [Config Option] (String/Mixed) */
		enterAnimation?: any;
		/** [Config Option] (String/Mixed) */
		exitAnimation?: any;
		/** [Config Option] (Number) */
		flex?: number;
		/** [Config Option] (Boolean) */
		floating?: boolean;
		/** [Config Option] (String) */
		floatingCls?: string;
		/** [Config Option] (Boolean) */
		fullscreen?: boolean;
		/** [Config Option] (Number/String) */
		height?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (String) */
		hiddenCls?: string;
		/** [Config Option] (String/Mixed) */
		hideAnimation?: any;
		/** [Config Option] (Boolean) */
		hideOnMaskTap?: boolean;
		/** [Config Option] (String/Ext.Element/HTMLElement) */
		html?: any;
		/** [Config Option] (String) */
		id?: string;
		/** [Config Option] (String) */
		itemId?: string;
		/** [Config Option] (Boolean) */
		layoutOnOrientationChange?: boolean;
		/** [Config Option] (Number/String) */
		left?: any;
		/** [Config Option] (Number/String) */
		margin?: any;
		/** [Config Option] (Number/String) */
		maxHeight?: any;
		/** [Config Option] (Number/String) */
		maxWidth?: any;
		/** [Config Option] (Number/String) */
		minHeight?: any;
		/** [Config Option] (Number/String) */
		minWidth?: any;
		/** [Config Option] (Boolean) */
		modal?: boolean;
		/** [Config Option] (Boolean) */
		monitorOrientation?: boolean;
		/** [Config Option] (Number/String) */
		padding?: any;
		/** [Config Option] (Object/Array) */
		plugins?: any;
		/** [Config Option] (Ext.data.Model) */
		record?: Ext.data.IModel;
		/** [Config Option] (Ext.Element) */
		renderTo?: Ext.IElement;
		/** [Config Option] (Number/String) */
		right?: any;
		/** [Config Option] (Boolean/String/Object) */
		scroll?: any;
		/** [Config Option] (String/Mixed) */
		showAnimation?: any;
		/** [Config Option] (Boolean) */
		stopMaskTapEvent?: boolean;
		/** [Config Option] (String/Object) */
		style?: any;
		/** [Config Option] (String) */
		styleHtmlCls?: string;
		/** [Config Option] (Boolean) */
		styleHtmlContent?: boolean;
		/** [Config Option] (Number/String) */
		top?: any;
		/** [Config Option] (String/String[]/Ext.Template/Ext.XTemplate[]) */
		tpl?: any;
		/** [Config Option] (String) */
		tplWriteMode?: string;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Number/String) */
		width?: any;
		/** [Config Option] (String[]) */
		xtype?: string;
		/** [Config Option] (Number) */
		zIndex?: number;
		/** [Method] Adds a CSS class or classes to this Component s rendered element  
		* @param cls String The CSS class to add. 
		* @param prefix String Optional prefix to add to each class. 
		* @param suffix String Optional suffix to add to each class. 
		*/
		addCls?( cls?:string, prefix?:string, suffix?:string ): void;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Disables this Component */
		disable?(): void;
		/** [Method] Enables this Component */
		enable?(): void;
		/** [Method] Prepares information on aligning this to component using alignment  
		* @param component Object 
		* @param alignment Object 
		*/
		getAlignmentInfo?( component?:any, alignment?:any ): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of border  
		* @returns Number/String 
		*/
		getBorder?(): any;
		/** [Method] Returns the value of bottom  
		* @returns any 
		*/
		getBottom?(): any;
		/** [Method] Returns the value of centered  
		* @returns Boolean 
		*/
		getCentered?(): boolean;
		/** [Method] Returns the value of cls  
		* @returns any 
		*/
		getCls?(): any;
		/** [Method] Returns the value of contentEl  
		* @returns Ext.Element/HTMLElement/String 
		*/
		getContentEl?(): any;
		/** [Method] Returns the value of data  
		* @returns Object 
		*/
		getData?(): any;
		/** [Method] Returns the value of disabled  
		* @returns Boolean 
		*/
		getDisabled?(): boolean;
		/** [Method] Returns the value of disabledCls  
		* @returns String 
		*/
		getDisabledCls?(): string;
		/** [Method] Returns the value of docked  
		* @returns String 
		*/
		getDocked?(): string;
		/** [Method] Retrieves the top level element representing this component  
		* @returns Ext.dom.Element 
		*/
		getEl?(): Ext.dom.IElement;
		/** [Method] Returns the value of enterAnimation  
		* @returns String/Mixed 
		*/
		getEnterAnimation?(): any;
		/** [Method] Returns the value of exitAnimation  
		* @returns String/Mixed 
		*/
		getExitAnimation?(): any;
		/** [Method] Returns the value of flex  
		* @returns Number 
		*/
		getFlex?(): number;
		/** [Method] Returns the value of floatingCls  
		* @returns String 
		*/
		getFloatingCls?(): string;
		/** [Method] Returns the value of height  
		* @returns Number/String 
		*/
		getHeight?(): any;
		/** [Method] Returns the value of hidden  
		* @returns Boolean 
		*/
		getHidden?(): boolean;
		/** [Method] Returns the value of hiddenCls  
		* @returns String 
		*/
		getHiddenCls?(): string;
		/** [Method] Returns the value of hideAnimation  
		* @returns String/Mixed 
		*/
		getHideAnimation?(): any;
		/** [Method] Returns the value of html  
		* @returns String/Ext.Element/HTMLElement 
		*/
		getHtml?(): any;
		/** [Method] Returns the value of itemId  
		* @returns String 
		*/
		getItemId?(): string;
		/** [Method] Returns the value of left  
		* @returns Number/String 
		*/
		getLeft?(): any;
		/** [Method] Returns the value of margin  
		* @returns Number/String 
		*/
		getMargin?(): any;
		/** [Method] Returns the value of maxHeight  
		* @returns Number/String 
		*/
		getMaxHeight?(): any;
		/** [Method] Returns the value of maxWidth  
		* @returns Number/String 
		*/
		getMaxWidth?(): any;
		/** [Method] Returns the value of minHeight  
		* @returns Number/String 
		*/
		getMinHeight?(): any;
		/** [Method] Returns the value of minWidth  
		* @returns Number/String 
		*/
		getMinWidth?(): any;
		/** [Method] Returns the value of padding  
		* @returns Number/String 
		*/
		getPadding?(): any;
		/** [Method] Returns the parent of this component if it has one  
		* @returns Ext.Component The parent of this component. 
		*/
		getParent?(): Ext.IComponent;
		/** [Method] Returns the value of plugins  
		* @returns Object/Array 
		*/
		getPlugins?(): any;
		/** [Method] Returns the value of record  
		* @returns Ext.data.Model 
		*/
		getRecord?(): Ext.data.IModel;
		/** [Method] Returns the value of renderTo  
		* @returns Ext.Element 
		*/
		getRenderTo?(): Ext.IElement;
		/** [Method] Returns the value of right  
		* @returns Number/String 
		*/
		getRight?(): any;
		/** [Method] Returns the value of showAnimation  
		* @returns String/Mixed 
		*/
		getShowAnimation?(): any;
		/** [Method] Returns the height and width of the Component  
		* @returns Object The current height and width of the Component. 
		*/
		getSize?(): any;
		/** [Method] Returns the value of style  
		* @returns String/Object 
		*/
		getStyle?(): any;
		/** [Method] Returns the value of styleHtmlCls  
		* @returns String 
		*/
		getStyleHtmlCls?(): string;
		/** [Method] Returns the value of styleHtmlContent  
		* @returns Boolean 
		*/
		getStyleHtmlContent?(): boolean;
		/** [Method] Returns the value of top  
		* @returns Number/String 
		*/
		getTop?(): any;
		/** [Method] Returns the value of tpl  
		* @returns String/String[]/Ext.Template/Ext.XTemplate[] 
		*/
		getTpl?(): any;
		/** [Method] Returns the value of tplWriteMode  
		* @returns String 
		*/
		getTplWriteMode?(): string;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns the value of width  
		* @returns Number/String 
		*/
		getWidth?(): any;
		/** [Method] Returns this Component s xtype hierarchy as a slash delimited string  
		* @returns String The xtype hierarchy string. 
		*/
		getXTypes?(): string;
		/** [Method] Returns the value of zIndex  
		* @returns Number 
		*/
		getZIndex?(): number;
		/** [Method] Returns true if this component has a parent  
		* @returns Boolean true if this component has a parent. 
		*/
		hasParent?(): boolean;
		/** [Method] Hides this Component optionally using an animation  
		* @param animation Object/Boolean You can specify an animation here or a bool to use the hideAnimation config. 
		* @returns Ext.Component 
		*/
		hide?( animation?:any ): Ext.IComponent;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Returns true if this Component is currently disabled  
		* @returns Boolean true if currently disabled. 
		*/
		isDisabled?(): boolean;
		/** [Method] Returns true if this Component is currently hidden  
		* @returns Boolean true if currently hidden. 
		*/
		isHidden?(): boolean;
		/** [Method] Tests whether or not this Component is of a specific xtype  
		* @param xtype String The xtype to check for this Component. 
		* @param shallow Boolean false to check whether this Component is descended from the xtype (this is the default), or true to check whether this Component is directly of the specified xtype. 
		* @returns Boolean true if this component descends from the specified xtype, false otherwise. 
		*/
		isXType?( xtype?:string, shallow?:boolean ): boolean;
		/** [Method] Removes the given CSS class es from this Component s rendered element  
		* @param cls String The class(es) to remove. 
		* @param prefix String Optional prefix to prepend before each class. 
		* @param suffix String Optional suffix to append to each class. 
		*/
		removeCls?( cls?:string, prefix?:string, suffix?:string ): void;
		/** [Method] Replaces specified classes with the newly specified classes  
		* @param oldCls String The class(es) to remove. 
		* @param newCls String The class(es) to add. 
		* @param prefix String Optional prefix to prepend before each class. 
		* @param suffix String Optional suffix to append to each class. 
		*/
		replaceCls?( oldCls?:string, newCls?:string, prefix?:string, suffix?:string ): void;
		/** [Method] Resets top right bottom and left configurations to null which will un float this component  */
		resetFloating?(): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of border  
		* @param border Number/String The new value. 
		*/
		setBorder?( border?:any ): void;
		/** [Method] Sets the value of bottom  
		* @param bottom Number/String The new value. 
		*/
		setBottom?( bottom?:any ): void;
		/** [Method] Sets the value of centered  
		* @param centered Boolean The new value. 
		*/
		setCentered?( centered?:boolean ): void;
		/** [Method] Sets the value of cls  
		* @param cls String/String[] The new value. 
		*/
		setCls?( cls?:any ): void;
		/** [Method] Sets the value of contentEl  
		* @param contentEl Ext.Element/HTMLElement/String The new value. 
		*/
		setContentEl?( contentEl?:any ): void;
		/** [Method] Sets the value of data  
		* @param data Object The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Sets the value of disabled  
		* @param disabled Boolean The new value. 
		*/
		setDisabled?( disabled?:boolean ): void;
		/** [Method] Sets the value of disabledCls  
		* @param disabledCls String The new value. 
		*/
		setDisabledCls?( disabledCls?:string ): void;
		/** [Method] Sets the value of docked  
		* @param docked String The new value. 
		*/
		setDocked?( docked?:string ): void;
		/** [Method] Sets the value of draggable  
		* @param draggable Object The new value. 
		*/
		setDraggable?( draggable?:any ): void;
		/** [Method] Sets the value of enterAnimation  
		* @param enterAnimation String/Mixed The new value. 
		*/
		setEnterAnimation?( enterAnimation?:any ): void;
		/** [Method] Sets the value of exitAnimation  
		* @param exitAnimation String/Mixed The new value. 
		*/
		setExitAnimation?( exitAnimation?:any ): void;
		/** [Method] Sets the value of flex  
		* @param flex Number The new value. 
		*/
		setFlex?( flex?:number ): void;
		/** [Method] Used to update the floating state of this component  
		* @param floating Boolean true if you want to float this component. 
		*/
		setFloating?( floating?:boolean ): void;
		/** [Method] Sets the value of floatingCls  
		* @param floatingCls String The new value. 
		*/
		setFloatingCls?( floatingCls?:string ): void;
		/** [Method] Sets the value of height  
		* @param height Number/String The new value. 
		*/
		setHeight?( height?:any ): void;
		/** [Method] Sets the value of hidden  
		* @param hidden Boolean The new value. 
		*/
		setHidden?( hidden?:boolean ): void;
		/** [Method] Sets the value of hiddenCls  
		* @param hiddenCls String The new value. 
		*/
		setHiddenCls?( hiddenCls?:string ): void;
		/** [Method] Sets the value of hideAnimation  
		* @param hideAnimation String/Mixed The new value. 
		*/
		setHideAnimation?( hideAnimation?:any ): void;
		/** [Method] Sets the value of html  
		* @param html String/Ext.Element/HTMLElement The new value. 
		*/
		setHtml?( html?:any ): void;
		/** [Method] Sets the value of itemId  
		* @param itemId String The new value. 
		*/
		setItemId?( itemId?:string ): void;
		/** [Method] Sets the value of left  
		* @param left Number/String The new value. 
		*/
		setLeft?( left?:any ): void;
		/** [Method] Sets the value of margin  
		* @param margin Number/String The new value. 
		*/
		setMargin?( margin?:any ): void;
		/** [Method] Sets the value of maxHeight  
		* @param maxHeight Number/String The new value. 
		*/
		setMaxHeight?( maxHeight?:any ): void;
		/** [Method] Sets the value of maxWidth  
		* @param maxWidth Number/String The new value. 
		*/
		setMaxWidth?( maxWidth?:any ): void;
		/** [Method] Sets the value of minHeight  
		* @param minHeight Number/String The new value. 
		*/
		setMinHeight?( minHeight?:any ): void;
		/** [Method] Sets the value of minWidth  
		* @param minWidth Number/String The new value. 
		*/
		setMinWidth?( minWidth?:any ): void;
		/** [Method] Sets the value of padding  
		* @param padding Number/String The new value. 
		*/
		setPadding?( padding?:any ): void;
		/** [Method] Sets the value of plugins  
		* @param plugins Object/Array The new value. 
		*/
		setPlugins?( plugins?:any ): void;
		/** [Method] Sets the value of record  
		* @param record Ext.data.Model The new value. 
		*/
		setRecord?( record?:Ext.data.IModel ): void;
		/** [Method] Sets the value of renderTo  
		* @param renderTo Ext.Element The new value. 
		*/
		setRenderTo?( renderTo?:Ext.IElement ): void;
		/** [Method] Sets the value of right  
		* @param right Number/String The new value. 
		*/
		setRight?( right?:any ): void;
		/** [Method] This method has moved to Ext Container  */
		setScrollable?(): void;
		/** [Method] Sets the value of showAnimation  
		* @param showAnimation String/Mixed The new value. 
		*/
		setShowAnimation?( showAnimation?:any ): void;
		/** [Method] Sets the size of the Component  
		* @param width Number The new width for the Component. 
		* @param height Number The new height for the Component. 
		*/
		setSize?( width?:number, height?:number ): void;
		/** [Method] Sets the value of style  
		* @param style String/Object The new value. 
		*/
		setStyle?( style?:any ): void;
		/** [Method] Sets the value of styleHtmlCls  
		* @param styleHtmlCls String The new value. 
		*/
		setStyleHtmlCls?( styleHtmlCls?:string ): void;
		/** [Method] Sets the value of styleHtmlContent  
		* @param styleHtmlContent Boolean The new value. 
		*/
		setStyleHtmlContent?( styleHtmlContent?:boolean ): void;
		/** [Method] Sets the value of top  
		* @param top Number/String The new value. 
		*/
		setTop?( top?:any ): void;
		/** [Method] Sets the value of tpl  
		* @param tpl String/String[]/Ext.Template/Ext.XTemplate[] The new value. 
		*/
		setTpl?( tpl?:any ): void;
		/** [Method] Sets the value of tplWriteMode  
		* @param tplWriteMode String The new value. 
		*/
		setTplWriteMode?( tplWriteMode?:string ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
		/** [Method] Sets the value of width  
		* @param width Number/String The new value. 
		*/
		setWidth?( width?:any ): void;
		/** [Method] Sets the value of zIndex  
		* @param zIndex Number The new value. 
		*/
		setZIndex?( zIndex?:number ): void;
		/** [Method] Shows this component optionally using an animation  
		* @param animation Object/Boolean You can specify an animation here or a bool to use the showAnimation config. 
		* @returns Ext.Component 
		*/
		show?( animation?:any ): Ext.IComponent;
		/** [Method] Shows this component by another component  
		* @param component Ext.Component The target component to show this component by. 
		* @param alignment String The specific alignment. 
		*/
		showBy?( component?:Ext.IComponent, alignment?:string ): void;
		/** [Method] Walks up the ownerCt axis looking for an ancestor Container which matches the passed simple selector  
		* @param selector String The simple selector to test. 
		* @returns Ext.Container The matching ancestor Container (or undefined if no match was found). 
		*/
		up?( selector?:string ): Ext.IContainer;
		/** [Method] Updates the HTML content of the Component  */
		update?(): void;
		/** [Method] Updates the styleHtmlCls configuration 
		* @param newHtmlCls Object 
		* @param oldHtmlCls Object 
		*/
		updateStyleHtmlCls?( newHtmlCls?:any, oldHtmlCls?:any ): void;
	}
}
declare module Ext.lib {
	export interface IComponent extends Ext.IAbstractComponent,Ext.mixin.ITraversable {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Number/String) */
		border?: any;
		/** [Config Option] (Number/String) */
		bottom?: any;
		/** [Config Option] (Boolean) */
		centered?: boolean;
		/** [Config Option] (String/String[]) */
		cls?: any;
		/** [Config Option] (String) */
		componentCls?: string;
		/** [Config Option] (Ext.Element/HTMLElement/String) */
		contentEl?: any;
		/** [Config Option] (Object) */
		data?: any;
		/** [Config Option] (Boolean) */
		disabled?: boolean;
		/** [Config Option] (String) */
		disabledCls?: string;
		/** [Config Option] (String) */
		dock?: string;
		/** [Config Option] (String) */
		docked?: string;
		/** [Config Option] (String/Mixed) */
		enterAnimation?: any;
		/** [Config Option] (String/Mixed) */
		exitAnimation?: any;
		/** [Config Option] (Number) */
		flex?: number;
		/** [Config Option] (Boolean) */
		floating?: boolean;
		/** [Config Option] (String) */
		floatingCls?: string;
		/** [Config Option] (Boolean) */
		fullscreen?: boolean;
		/** [Config Option] (Number/String) */
		height?: any;
		/** [Config Option] (Boolean) */
		hidden?: boolean;
		/** [Config Option] (String) */
		hiddenCls?: string;
		/** [Config Option] (String/Mixed) */
		hideAnimation?: any;
		/** [Config Option] (Boolean) */
		hideOnMaskTap?: boolean;
		/** [Config Option] (String/Ext.Element/HTMLElement) */
		html?: any;
		/** [Config Option] (String) */
		id?: string;
		/** [Config Option] (String) */
		itemId?: string;
		/** [Config Option] (Boolean) */
		layoutOnOrientationChange?: boolean;
		/** [Config Option] (Number/String) */
		left?: any;
		/** [Config Option] (Number/String) */
		margin?: any;
		/** [Config Option] (Number/String) */
		maxHeight?: any;
		/** [Config Option] (Number/String) */
		maxWidth?: any;
		/** [Config Option] (Number/String) */
		minHeight?: any;
		/** [Config Option] (Number/String) */
		minWidth?: any;
		/** [Config Option] (Boolean) */
		modal?: boolean;
		/** [Config Option] (Boolean) */
		monitorOrientation?: boolean;
		/** [Config Option] (Number/String) */
		padding?: any;
		/** [Config Option] (Object/Array) */
		plugins?: any;
		/** [Config Option] (Ext.data.Model) */
		record?: Ext.data.IModel;
		/** [Config Option] (Ext.Element) */
		renderTo?: Ext.IElement;
		/** [Config Option] (Number/String) */
		right?: any;
		/** [Config Option] (Boolean/String/Object) */
		scroll?: any;
		/** [Config Option] (String/Mixed) */
		showAnimation?: any;
		/** [Config Option] (Boolean) */
		stopMaskTapEvent?: boolean;
		/** [Config Option] (String/Object) */
		style?: any;
		/** [Config Option] (String) */
		styleHtmlCls?: string;
		/** [Config Option] (Boolean) */
		styleHtmlContent?: boolean;
		/** [Config Option] (Number/String) */
		top?: any;
		/** [Config Option] (String/String[]/Ext.Template/Ext.XTemplate[]) */
		tpl?: any;
		/** [Config Option] (String) */
		tplWriteMode?: string;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Number/String) */
		width?: any;
		/** [Config Option] (String[]) */
		xtype?: string;
		/** [Config Option] (Number) */
		zIndex?: number;
		/** [Method] Adds a CSS class or classes to this Component s rendered element  
		* @param cls String The CSS class to add. 
		* @param prefix String Optional prefix to add to each class. 
		* @param suffix String Optional suffix to add to each class. 
		*/
		addCls?( cls?:string, prefix?:string, suffix?:string ): void;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Disables this Component */
		disable?(): void;
		/** [Method] Enables this Component */
		enable?(): void;
		/** [Method] Prepares information on aligning this to component using alignment  
		* @param component Object 
		* @param alignment Object 
		*/
		getAlignmentInfo?( component?:any, alignment?:any ): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of border  
		* @returns Number/String 
		*/
		getBorder?(): any;
		/** [Method] Returns the value of bottom  
		* @returns any 
		*/
		getBottom?(): any;
		/** [Method] Returns the value of centered  
		* @returns Boolean 
		*/
		getCentered?(): boolean;
		/** [Method] Returns the value of cls  
		* @returns any 
		*/
		getCls?(): any;
		/** [Method] Returns the value of contentEl  
		* @returns Ext.Element/HTMLElement/String 
		*/
		getContentEl?(): any;
		/** [Method] Returns the value of data  
		* @returns Object 
		*/
		getData?(): any;
		/** [Method] Returns the value of disabled  
		* @returns Boolean 
		*/
		getDisabled?(): boolean;
		/** [Method] Returns the value of disabledCls  
		* @returns String 
		*/
		getDisabledCls?(): string;
		/** [Method] Returns the value of docked  
		* @returns String 
		*/
		getDocked?(): string;
		/** [Method] Retrieves the top level element representing this component  
		* @returns Ext.dom.Element 
		*/
		getEl?(): Ext.dom.IElement;
		/** [Method] Returns the value of enterAnimation  
		* @returns String/Mixed 
		*/
		getEnterAnimation?(): any;
		/** [Method] Returns the value of exitAnimation  
		* @returns String/Mixed 
		*/
		getExitAnimation?(): any;
		/** [Method] Returns the value of flex  
		* @returns Number 
		*/
		getFlex?(): number;
		/** [Method] Returns the value of floatingCls  
		* @returns String 
		*/
		getFloatingCls?(): string;
		/** [Method] Returns the value of height  
		* @returns Number/String 
		*/
		getHeight?(): any;
		/** [Method] Returns the value of hidden  
		* @returns Boolean 
		*/
		getHidden?(): boolean;
		/** [Method] Returns the value of hiddenCls  
		* @returns String 
		*/
		getHiddenCls?(): string;
		/** [Method] Returns the value of hideAnimation  
		* @returns String/Mixed 
		*/
		getHideAnimation?(): any;
		/** [Method] Returns the value of html  
		* @returns String/Ext.Element/HTMLElement 
		*/
		getHtml?(): any;
		/** [Method] Returns the value of itemId  
		* @returns String 
		*/
		getItemId?(): string;
		/** [Method] Returns the value of left  
		* @returns Number/String 
		*/
		getLeft?(): any;
		/** [Method] Returns the value of margin  
		* @returns Number/String 
		*/
		getMargin?(): any;
		/** [Method] Returns the value of maxHeight  
		* @returns Number/String 
		*/
		getMaxHeight?(): any;
		/** [Method] Returns the value of maxWidth  
		* @returns Number/String 
		*/
		getMaxWidth?(): any;
		/** [Method] Returns the value of minHeight  
		* @returns Number/String 
		*/
		getMinHeight?(): any;
		/** [Method] Returns the value of minWidth  
		* @returns Number/String 
		*/
		getMinWidth?(): any;
		/** [Method] Returns the value of padding  
		* @returns Number/String 
		*/
		getPadding?(): any;
		/** [Method] Returns the parent of this component if it has one  
		* @returns Ext.Component The parent of this component. 
		*/
		getParent?(): Ext.IComponent;
		/** [Method] Returns the value of plugins  
		* @returns Object/Array 
		*/
		getPlugins?(): any;
		/** [Method] Returns the value of record  
		* @returns Ext.data.Model 
		*/
		getRecord?(): Ext.data.IModel;
		/** [Method] Returns the value of renderTo  
		* @returns Ext.Element 
		*/
		getRenderTo?(): Ext.IElement;
		/** [Method] Returns the value of right  
		* @returns Number/String 
		*/
		getRight?(): any;
		/** [Method] Returns the value of showAnimation  
		* @returns String/Mixed 
		*/
		getShowAnimation?(): any;
		/** [Method] Returns the height and width of the Component  
		* @returns Object The current height and width of the Component. 
		*/
		getSize?(): any;
		/** [Method] Returns the value of style  
		* @returns String/Object 
		*/
		getStyle?(): any;
		/** [Method] Returns the value of styleHtmlCls  
		* @returns String 
		*/
		getStyleHtmlCls?(): string;
		/** [Method] Returns the value of styleHtmlContent  
		* @returns Boolean 
		*/
		getStyleHtmlContent?(): boolean;
		/** [Method] Returns the value of top  
		* @returns Number/String 
		*/
		getTop?(): any;
		/** [Method] Returns the value of tpl  
		* @returns String/String[]/Ext.Template/Ext.XTemplate[] 
		*/
		getTpl?(): any;
		/** [Method] Returns the value of tplWriteMode  
		* @returns String 
		*/
		getTplWriteMode?(): string;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns the value of width  
		* @returns Number/String 
		*/
		getWidth?(): any;
		/** [Method] Returns this Component s xtype hierarchy as a slash delimited string  
		* @returns String The xtype hierarchy string. 
		*/
		getXTypes?(): string;
		/** [Method] Returns the value of zIndex  
		* @returns Number 
		*/
		getZIndex?(): number;
		/** [Method] Returns true if this component has a parent  
		* @returns Boolean true if this component has a parent. 
		*/
		hasParent?(): boolean;
		/** [Method] Hides this Component optionally using an animation  
		* @param animation Object/Boolean You can specify an animation here or a bool to use the hideAnimation config. 
		* @returns Ext.Component 
		*/
		hide?( animation?:any ): Ext.IComponent;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Returns true if this Component is currently disabled  
		* @returns Boolean true if currently disabled. 
		*/
		isDisabled?(): boolean;
		/** [Method] Returns true if this Component is currently hidden  
		* @returns Boolean true if currently hidden. 
		*/
		isHidden?(): boolean;
		/** [Method] Tests whether or not this Component is of a specific xtype  
		* @param xtype String The xtype to check for this Component. 
		* @param shallow Boolean false to check whether this Component is descended from the xtype (this is the default), or true to check whether this Component is directly of the specified xtype. 
		* @returns Boolean true if this component descends from the specified xtype, false otherwise. 
		*/
		isXType?( xtype?:string, shallow?:boolean ): boolean;
		/** [Method] Removes the given CSS class es from this Component s rendered element  
		* @param cls String The class(es) to remove. 
		* @param prefix String Optional prefix to prepend before each class. 
		* @param suffix String Optional suffix to append to each class. 
		*/
		removeCls?( cls?:string, prefix?:string, suffix?:string ): void;
		/** [Method] Replaces specified classes with the newly specified classes  
		* @param oldCls String The class(es) to remove. 
		* @param newCls String The class(es) to add. 
		* @param prefix String Optional prefix to prepend before each class. 
		* @param suffix String Optional suffix to append to each class. 
		*/
		replaceCls?( oldCls?:string, newCls?:string, prefix?:string, suffix?:string ): void;
		/** [Method] Resets top right bottom and left configurations to null which will un float this component  */
		resetFloating?(): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of border  
		* @param border Number/String The new value. 
		*/
		setBorder?( border?:any ): void;
		/** [Method] Sets the value of bottom  
		* @param bottom Number/String The new value. 
		*/
		setBottom?( bottom?:any ): void;
		/** [Method] Sets the value of centered  
		* @param centered Boolean The new value. 
		*/
		setCentered?( centered?:boolean ): void;
		/** [Method] Sets the value of cls  
		* @param cls String/String[] The new value. 
		*/
		setCls?( cls?:any ): void;
		/** [Method] Sets the value of contentEl  
		* @param contentEl Ext.Element/HTMLElement/String The new value. 
		*/
		setContentEl?( contentEl?:any ): void;
		/** [Method] Sets the value of data  
		* @param data Object The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Sets the value of disabled  
		* @param disabled Boolean The new value. 
		*/
		setDisabled?( disabled?:boolean ): void;
		/** [Method] Sets the value of disabledCls  
		* @param disabledCls String The new value. 
		*/
		setDisabledCls?( disabledCls?:string ): void;
		/** [Method] Sets the value of docked  
		* @param docked String The new value. 
		*/
		setDocked?( docked?:string ): void;
		/** [Method] Sets the value of draggable  
		* @param draggable Object The new value. 
		*/
		setDraggable?( draggable?:any ): void;
		/** [Method] Sets the value of enterAnimation  
		* @param enterAnimation String/Mixed The new value. 
		*/
		setEnterAnimation?( enterAnimation?:any ): void;
		/** [Method] Sets the value of exitAnimation  
		* @param exitAnimation String/Mixed The new value. 
		*/
		setExitAnimation?( exitAnimation?:any ): void;
		/** [Method] Sets the value of flex  
		* @param flex Number The new value. 
		*/
		setFlex?( flex?:number ): void;
		/** [Method] Used to update the floating state of this component  
		* @param floating Boolean true if you want to float this component. 
		*/
		setFloating?( floating?:boolean ): void;
		/** [Method] Sets the value of floatingCls  
		* @param floatingCls String The new value. 
		*/
		setFloatingCls?( floatingCls?:string ): void;
		/** [Method] Sets the value of height  
		* @param height Number/String The new value. 
		*/
		setHeight?( height?:any ): void;
		/** [Method] Sets the value of hidden  
		* @param hidden Boolean The new value. 
		*/
		setHidden?( hidden?:boolean ): void;
		/** [Method] Sets the value of hiddenCls  
		* @param hiddenCls String The new value. 
		*/
		setHiddenCls?( hiddenCls?:string ): void;
		/** [Method] Sets the value of hideAnimation  
		* @param hideAnimation String/Mixed The new value. 
		*/
		setHideAnimation?( hideAnimation?:any ): void;
		/** [Method] Sets the value of html  
		* @param html String/Ext.Element/HTMLElement The new value. 
		*/
		setHtml?( html?:any ): void;
		/** [Method] Sets the value of itemId  
		* @param itemId String The new value. 
		*/
		setItemId?( itemId?:string ): void;
		/** [Method] Sets the value of left  
		* @param left Number/String The new value. 
		*/
		setLeft?( left?:any ): void;
		/** [Method] Sets the value of margin  
		* @param margin Number/String The new value. 
		*/
		setMargin?( margin?:any ): void;
		/** [Method] Sets the value of maxHeight  
		* @param maxHeight Number/String The new value. 
		*/
		setMaxHeight?( maxHeight?:any ): void;
		/** [Method] Sets the value of maxWidth  
		* @param maxWidth Number/String The new value. 
		*/
		setMaxWidth?( maxWidth?:any ): void;
		/** [Method] Sets the value of minHeight  
		* @param minHeight Number/String The new value. 
		*/
		setMinHeight?( minHeight?:any ): void;
		/** [Method] Sets the value of minWidth  
		* @param minWidth Number/String The new value. 
		*/
		setMinWidth?( minWidth?:any ): void;
		/** [Method] Sets the value of padding  
		* @param padding Number/String The new value. 
		*/
		setPadding?( padding?:any ): void;
		/** [Method] Sets the value of plugins  
		* @param plugins Object/Array The new value. 
		*/
		setPlugins?( plugins?:any ): void;
		/** [Method] Sets the value of record  
		* @param record Ext.data.Model The new value. 
		*/
		setRecord?( record?:Ext.data.IModel ): void;
		/** [Method] Sets the value of renderTo  
		* @param renderTo Ext.Element The new value. 
		*/
		setRenderTo?( renderTo?:Ext.IElement ): void;
		/** [Method] Sets the value of right  
		* @param right Number/String The new value. 
		*/
		setRight?( right?:any ): void;
		/** [Method] This method has moved to Ext Container  */
		setScrollable?(): void;
		/** [Method] Sets the value of showAnimation  
		* @param showAnimation String/Mixed The new value. 
		*/
		setShowAnimation?( showAnimation?:any ): void;
		/** [Method] Sets the size of the Component  
		* @param width Number The new width for the Component. 
		* @param height Number The new height for the Component. 
		*/
		setSize?( width?:number, height?:number ): void;
		/** [Method] Sets the value of style  
		* @param style String/Object The new value. 
		*/
		setStyle?( style?:any ): void;
		/** [Method] Sets the value of styleHtmlCls  
		* @param styleHtmlCls String The new value. 
		*/
		setStyleHtmlCls?( styleHtmlCls?:string ): void;
		/** [Method] Sets the value of styleHtmlContent  
		* @param styleHtmlContent Boolean The new value. 
		*/
		setStyleHtmlContent?( styleHtmlContent?:boolean ): void;
		/** [Method] Sets the value of top  
		* @param top Number/String The new value. 
		*/
		setTop?( top?:any ): void;
		/** [Method] Sets the value of tpl  
		* @param tpl String/String[]/Ext.Template/Ext.XTemplate[] The new value. 
		*/
		setTpl?( tpl?:any ): void;
		/** [Method] Sets the value of tplWriteMode  
		* @param tplWriteMode String The new value. 
		*/
		setTplWriteMode?( tplWriteMode?:string ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
		/** [Method] Sets the value of width  
		* @param width Number/String The new value. 
		*/
		setWidth?( width?:any ): void;
		/** [Method] Sets the value of zIndex  
		* @param zIndex Number The new value. 
		*/
		setZIndex?( zIndex?:number ): void;
		/** [Method] Shows this component optionally using an animation  
		* @param animation Object/Boolean You can specify an animation here or a bool to use the showAnimation config. 
		* @returns Ext.Component 
		*/
		show?( animation?:any ): Ext.IComponent;
		/** [Method] Shows this component by another component  
		* @param component Ext.Component The target component to show this component by. 
		* @param alignment String The specific alignment. 
		*/
		showBy?( component?:Ext.IComponent, alignment?:string ): void;
		/** [Method] Walks up the ownerCt axis looking for an ancestor Container which matches the passed simple selector  
		* @param selector String The simple selector to test. 
		* @returns Ext.Container The matching ancestor Container (or undefined if no match was found). 
		*/
		up?( selector?:string ): Ext.IContainer;
		/** [Method] Updates the HTML content of the Component  */
		update?(): void;
		/** [Method] Updates the styleHtmlCls configuration 
		* @param newHtmlCls Object 
		* @param oldHtmlCls Object 
		*/
		updateStyleHtmlCls?( newHtmlCls?:any, oldHtmlCls?:any ): void;
	}
}
declare module Ext {
	export interface IComponentManager extends Ext.IBase {
	}
	export class ComponentManager {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new Component from the specified config object using the config object s xtype to determine the class to in  
		* @param component Object A configuration object for the Component you wish to create. 
		* @param defaultType Function The constructor to provide the default Component type if the config object does not contain a xtype. (Optional if the config contains an xtype). 
		* @returns Ext.Component The newly instantiated Component. 
		*/
		static create( component?:any, defaultType?:any ): Ext.IComponent;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item. 
		* @returns Object The item, or undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Checks if an item type is registered  
		* @param component String The mnemonic string by which the class may be looked up. 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( component?:string ): boolean;
		/** [Method] Registers an item to be managed  
		* @param component Object The item to register. 
		*/
		static register( component?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager  
		* @param component Object The item to unregister. 
		*/
		static unregister( component?:any ): void;
	}
}
declare module Ext {
	export interface IComponentMgr extends Ext.IBase {
	}
	export class ComponentMgr {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new Component from the specified config object using the config object s xtype to determine the class to in  
		* @param component Object A configuration object for the Component you wish to create. 
		* @param defaultType Function The constructor to provide the default Component type if the config object does not contain a xtype. (Optional if the config contains an xtype). 
		* @returns Ext.Component The newly instantiated Component. 
		*/
		static create( component?:any, defaultType?:any ): Ext.IComponent;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item. 
		* @returns Object The item, or undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Checks if an item type is registered  
		* @param component String The mnemonic string by which the class may be looked up. 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( component?:string ): boolean;
		/** [Method] Registers an item to be managed  
		* @param component Object The item to register. 
		*/
		static register( component?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager  
		* @param component Object The item to unregister. 
		*/
		static unregister( component?:any ): void;
	}
}
declare module Ext {
	export interface IComponentQuery {
	}
	export class ComponentQuery {
		/** [Method] Tests whether the passed Component matches the selector string  
		* @param component Ext.Component The Component to test. 
		* @param selector String The selector string to test against. 
		* @returns Boolean true if the Component matches the selector. 
		*/
		static is( component?:Ext.IComponent, selector?:string ): boolean;
		/** [Method] Returns an array of matched Components from within the passed root object  
		* @param selector String The selector string to filter returned Components 
		* @param root Ext.Container The Container within which to perform the query. If omitted, all Components within the document are included in the search. This parameter may also be an array of Components to filter according to the selector. 
		* @returns Ext.Component[] The matched Components. 
		*/
		static query( selector?:string, root?:Ext.IContainer ): Ext.IComponent[];
	}
}
declare module Ext {
	export interface IContainer extends Ext.IComponent {
		/** [Config Option] (Object/String/Number) */
		activeItem?: any;
		/** [Config Option] (Boolean) */
		autoDestroy?: boolean;
		/** [Config Option] (String/Object/Boolean) */
		cardSwitchAnimation?: any;
		/** [Config Option] (Object) */
		control?: any;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Object) */
		defaults?: any;
		/** [Config Option] (Boolean) */
		hideOnMaskTap?: boolean;
		/** [Config Option] (Array/Object) */
		items?: any;
		/** [Config Option] (Object/String) */
		layout?: any;
		/** [Config Option] (Boolean/Object/Ext.Mask/Ext.LoadMask) */
		masked?: any;
		/** [Config Option] (Boolean) */
		modal?: boolean;
		/** [Config Option] (Boolean/String/Object) */
		scroll?: any;
		/** [Config Option] (Boolean/String/Object) */
		scrollable?: any;
		/** [Method] Adds one or more Components to this Container  
		* @param newItems Object/Object[]/Ext.Component/Ext.Component[] The new items to add to the Container. 
		* @returns Ext.Component The last item added to the Container from the newItems array. 
		*/
		add?( newItems?:any ): Ext.IComponent;
		/** [Method] Adds an array of Components to this Container  
		* @param items Array The array of items to add to this container. 
		* @returns Array The array of items after they have been added. 
		*/
		addAll?( items?:any[] ): any[];
		/** [Method] Animates to the supplied activeItem with a specified animation  
		* @param activeItem Object/Number The item or item index to make active. 
		* @param animation Object/Ext.fx.layout.Card Card animation configuration or instance. 
		*/
		animateActiveItem?( activeItem?:any, animation?:any ): void;
		/** [Method] Changes the masked configuration when its setter is called which will convert the value into a proper object instanc  
		* @param masked Boolean/Object/Ext.Mask/Ext.LoadMask 
		* @returns Object 
		*/
		applyMasked?( masked?:any ): any;
		/** [Method] Retrieves the first direct child of this container which matches the passed selector  
		* @param selector String An Ext.ComponentQuery selector. 
		* @returns Ext.Component 
		*/
		child?( selector?:string ): Ext.IComponent;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Retrieves the first descendant of this container which matches the passed selector  
		* @param selector String An Ext.ComponentQuery selector. 
		* @returns Ext.Component 
		*/
		down?( selector?:string ): Ext.IComponent;
		/** [Method] Returns the value of activeItem  
		* @returns Object/String/Number 
		*/
		getActiveItem?(): any;
		/** [Method] Returns the Component for a given index in the Container s items  
		* @param index Number The index of the Component to return. 
		* @returns Ext.Component The item at the specified index, if found. 
		*/
		getAt?( index?:number ): Ext.IComponent;
		/** [Method] Returns the value of autoDestroy  
		* @returns Boolean 
		*/
		getAutoDestroy?(): boolean;
		/** [Method] Examines this container s items property and gets a direct child component of this container  
		* @param component String/Number This parameter may be any of the following:  {String} : representing the itemId or id of the child component. {Number} : representing the position of the child component within the items property. For additional information see Ext.util.MixedCollection.get. 
		* @returns Ext.Component The component (if found). 
		*/
		getComponent?( component?:any ): Ext.IComponent;
		/** [Method] Returns the value of control  
		* @returns Object 
		*/
		getControl?(): any;
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of defaults  
		* @returns Object 
		*/
		getDefaults?(): any;
		/** [Method] Finds a docked item of this container using a reference idor an index of its location in getDockedItems  
		* @param component String/Number The id or index of the component to find. 
		* @returns Ext.Component/Boolean The docked component, if found. 
		*/
		getDockedComponent?( component?:any ): any;
		/** [Method] Returns all the Ext Component docked items in this container  
		* @returns Array The docked items of this container. 
		*/
		getDockedItems?(): any[];
		/** [Method] Returns the value of hideOnMaskTap  
		* @returns Boolean 
		*/
		getHideOnMaskTap?(): boolean;
		/** [Method] Returns all inner items of this container  
		* @returns Array The inner items of this container. 
		*/
		getInnerItems?(): any[];
		/** [Method] Returns the value of items  
		* @returns Array/Object 
		*/
		getItems?(): any;
		/** [Method] Returns the value of masked  
		* @returns Boolean/Object/Ext.Mask/Ext.LoadMask 
		*/
		getMasked?(): any;
		/** [Method] Returns the value of modal  
		* @returns Boolean 
		*/
		getModal?(): boolean;
		/** [Method] Returns an the scrollable instance for this container which is a Ext scroll View class  
		* @returns Ext.scroll.View The scroll view. 
		*/
		getScrollable?(): Ext.scroll.IView;
		/** [Method] Hides this Component optionally using an animation  
		* @returns Ext.Component 
		*/
		hide?(): Ext.IComponent;
		/** [Method] Adds a child Component at the given index  
		* @param index Number The index to insert the Component at. 
		* @param item Object The Component to insert. 
		*/
		insert?( index?:number, item?:any ): void;
		/** [Method] Convenience method which calls setMasked with a value of true to show the mask 
		* @param mask Object 
		*/
		mask?( mask?:any ): void;
		/** [Method] Retrieves all descendant components which match the passed selector  
		* @param selector String Selector complying to an Ext.ComponentQuery selector. 
		* @returns Array Ext.Component's which matched the selector. 
		*/
		query?( selector?:string ): any[];
		/** [Method] Removes an item from this Container optionally destroying it  
		* @param item Object The item to remove. 
		* @param destroy Boolean Calls the Component's destroy method if true. 
		* @returns Ext.Component this 
		*/
		remove?( item?:any, destroy?:boolean ): Ext.IComponent;
		/** [Method] Removes all items currently in the Container optionally destroying them all  
		* @param destroy Boolean If true, destroys each removed Component. 
		* @param everything Boolean If true, completely remove all items including docked / centered and floating items. 
		* @returns Ext.Component this 
		*/
		removeAll?( destroy?:boolean, everything?:boolean ): Ext.IComponent;
		/** [Method] Removes the Component at the specified index  myContainer removeAt 0 removes the first item 
		* @param index Number The index of the Component to remove. 
		* @returns Ext.Container this 
		*/
		removeAt?( index?:number ): Ext.IContainer;
		/** [Method] Removes a docked item from this Container  
		* @param item Object The item to remove. 
		* @param destroy Boolean Calls the Component's destroy method if true. 
		* @returns Ext.Component this 
		*/
		removeDocked?( item?:any, destroy?:boolean ): Ext.IComponent;
		/** [Method] Removes an inner Component at the specified index  myContainer removeInnerAt 0 removes the first item of the in  
		* @param index Number The index of the Component to remove. 
		* @returns Ext.Container this 
		*/
		removeInnerAt?( index?:number ): Ext.IContainer;
		/** [Method] Sets the value of activeItem  
		* @param activeItem Object/String/Number The new value. 
		*/
		setActiveItem?( activeItem?:any ): void;
		/** [Method] Sets the value of autoDestroy  
		* @param autoDestroy Boolean The new value. 
		*/
		setAutoDestroy?( autoDestroy?:boolean ): void;
		/** [Method] Sets the value of control  
		* @param control Object The new value. 
		*/
		setControl?( control?:any ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of defaults  
		* @param defaults Object The new value. 
		*/
		setDefaults?( defaults?:any ): void;
		/** [Method] Sets the value of hideOnMaskTap  
		* @param hideOnMaskTap Boolean The new value. 
		*/
		setHideOnMaskTap?( hideOnMaskTap?:boolean ): void;
		/** [Method] Sets the value of items  
		* @param items Array/Object The new value. 
		*/
		setItems?( items?:any ): void;
		/** [Method] Sets the value of layout  
		* @param layout Object/String The new value. 
		*/
		setLayout?( layout?:any ): void;
		/** [Method] Sets the value of masked  
		* @param masked Boolean/Object/Ext.Mask/Ext.LoadMask The new value. 
		*/
		setMasked?( masked?:any ): void;
		/** [Method] Sets the value of modal  
		* @param modal Boolean The new value. 
		*/
		setModal?( modal?:boolean ): void;
		/** [Method] Sets the value of scrollable  
		* @param scrollable Boolean/String/Object The new value. 
		* @returns Ext.scroll.View The scroll view. 
		*/
		setScrollable?( scrollable?:any ): Ext.scroll.IView;
		/** [Method] Shows this component optionally using an animation  
		* @returns Ext.Component 
		*/
		show?(): Ext.IComponent;
		/** [Method] Convenience method which calls setMasked with a value of false to hide the mask */
		unmask?(): void;
	}
}
declare module Ext.lib {
	export interface IContainer extends Ext.IComponent {
		/** [Config Option] (Object/String/Number) */
		activeItem?: any;
		/** [Config Option] (Boolean) */
		autoDestroy?: boolean;
		/** [Config Option] (String/Object/Boolean) */
		cardSwitchAnimation?: any;
		/** [Config Option] (Object) */
		control?: any;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Object) */
		defaults?: any;
		/** [Config Option] (Boolean) */
		hideOnMaskTap?: boolean;
		/** [Config Option] (Array/Object) */
		items?: any;
		/** [Config Option] (Object/String) */
		layout?: any;
		/** [Config Option] (Boolean/Object/Ext.Mask/Ext.LoadMask) */
		masked?: any;
		/** [Config Option] (Boolean) */
		modal?: boolean;
		/** [Config Option] (Boolean/String/Object) */
		scroll?: any;
		/** [Config Option] (Boolean/String/Object) */
		scrollable?: any;
		/** [Method] Adds one or more Components to this Container  
		* @param newItems Object/Object[]/Ext.Component/Ext.Component[] The new items to add to the Container. 
		* @returns Ext.Component The last item added to the Container from the newItems array. 
		*/
		add?( newItems?:any ): Ext.IComponent;
		/** [Method] Adds an array of Components to this Container  
		* @param items Array The array of items to add to this container. 
		* @returns Array The array of items after they have been added. 
		*/
		addAll?( items?:any[] ): any[];
		/** [Method] Animates to the supplied activeItem with a specified animation  
		* @param activeItem Object/Number The item or item index to make active. 
		* @param animation Object/Ext.fx.layout.Card Card animation configuration or instance. 
		*/
		animateActiveItem?( activeItem?:any, animation?:any ): void;
		/** [Method] Changes the masked configuration when its setter is called which will convert the value into a proper object instanc  
		* @param masked Boolean/Object/Ext.Mask/Ext.LoadMask 
		* @returns Object 
		*/
		applyMasked?( masked?:any ): any;
		/** [Method] Retrieves the first direct child of this container which matches the passed selector  
		* @param selector String An Ext.ComponentQuery selector. 
		* @returns Ext.Component 
		*/
		child?( selector?:string ): Ext.IComponent;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Retrieves the first descendant of this container which matches the passed selector  
		* @param selector String An Ext.ComponentQuery selector. 
		* @returns Ext.Component 
		*/
		down?( selector?:string ): Ext.IComponent;
		/** [Method] Returns the value of activeItem  
		* @returns Object/String/Number 
		*/
		getActiveItem?(): any;
		/** [Method] Returns the Component for a given index in the Container s items  
		* @param index Number The index of the Component to return. 
		* @returns Ext.Component The item at the specified index, if found. 
		*/
		getAt?( index?:number ): Ext.IComponent;
		/** [Method] Returns the value of autoDestroy  
		* @returns Boolean 
		*/
		getAutoDestroy?(): boolean;
		/** [Method] Examines this container s items property and gets a direct child component of this container  
		* @param component String/Number This parameter may be any of the following:  {String} : representing the itemId or id of the child component. {Number} : representing the position of the child component within the items property. For additional information see Ext.util.MixedCollection.get. 
		* @returns Ext.Component The component (if found). 
		*/
		getComponent?( component?:any ): Ext.IComponent;
		/** [Method] Returns the value of control  
		* @returns Object 
		*/
		getControl?(): any;
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of defaults  
		* @returns Object 
		*/
		getDefaults?(): any;
		/** [Method] Finds a docked item of this container using a reference idor an index of its location in getDockedItems  
		* @param component String/Number The id or index of the component to find. 
		* @returns Ext.Component/Boolean The docked component, if found. 
		*/
		getDockedComponent?( component?:any ): any;
		/** [Method] Returns all the Ext Component docked items in this container  
		* @returns Array The docked items of this container. 
		*/
		getDockedItems?(): any[];
		/** [Method] Returns the value of hideOnMaskTap  
		* @returns Boolean 
		*/
		getHideOnMaskTap?(): boolean;
		/** [Method] Returns all inner items of this container  
		* @returns Array The inner items of this container. 
		*/
		getInnerItems?(): any[];
		/** [Method] Returns the value of items  
		* @returns Array/Object 
		*/
		getItems?(): any;
		/** [Method] Returns the value of masked  
		* @returns Boolean/Object/Ext.Mask/Ext.LoadMask 
		*/
		getMasked?(): any;
		/** [Method] Returns the value of modal  
		* @returns Boolean 
		*/
		getModal?(): boolean;
		/** [Method] Returns an the scrollable instance for this container which is a Ext scroll View class  
		* @returns Ext.scroll.View The scroll view. 
		*/
		getScrollable?(): Ext.scroll.IView;
		/** [Method] Hides this Component optionally using an animation  
		* @returns Ext.Component 
		*/
		hide?(): Ext.IComponent;
		/** [Method] Adds a child Component at the given index  
		* @param index Number The index to insert the Component at. 
		* @param item Object The Component to insert. 
		*/
		insert?( index?:number, item?:any ): void;
		/** [Method] Convenience method which calls setMasked with a value of true to show the mask 
		* @param mask Object 
		*/
		mask?( mask?:any ): void;
		/** [Method] Retrieves all descendant components which match the passed selector  
		* @param selector String Selector complying to an Ext.ComponentQuery selector. 
		* @returns Array Ext.Component's which matched the selector. 
		*/
		query?( selector?:string ): any[];
		/** [Method] Removes an item from this Container optionally destroying it  
		* @param item Object The item to remove. 
		* @param destroy Boolean Calls the Component's destroy method if true. 
		* @returns Ext.Component this 
		*/
		remove?( item?:any, destroy?:boolean ): Ext.IComponent;
		/** [Method] Removes all items currently in the Container optionally destroying them all  
		* @param destroy Boolean If true, destroys each removed Component. 
		* @param everything Boolean If true, completely remove all items including docked / centered and floating items. 
		* @returns Ext.Component this 
		*/
		removeAll?( destroy?:boolean, everything?:boolean ): Ext.IComponent;
		/** [Method] Removes the Component at the specified index  myContainer removeAt 0 removes the first item 
		* @param index Number The index of the Component to remove. 
		* @returns Ext.Container this 
		*/
		removeAt?( index?:number ): Ext.IContainer;
		/** [Method] Removes a docked item from this Container  
		* @param item Object The item to remove. 
		* @param destroy Boolean Calls the Component's destroy method if true. 
		* @returns Ext.Component this 
		*/
		removeDocked?( item?:any, destroy?:boolean ): Ext.IComponent;
		/** [Method] Removes an inner Component at the specified index  myContainer removeInnerAt 0 removes the first item of the in  
		* @param index Number The index of the Component to remove. 
		* @returns Ext.Container this 
		*/
		removeInnerAt?( index?:number ): Ext.IContainer;
		/** [Method] Sets the value of activeItem  
		* @param activeItem Object/String/Number The new value. 
		*/
		setActiveItem?( activeItem?:any ): void;
		/** [Method] Sets the value of autoDestroy  
		* @param autoDestroy Boolean The new value. 
		*/
		setAutoDestroy?( autoDestroy?:boolean ): void;
		/** [Method] Sets the value of control  
		* @param control Object The new value. 
		*/
		setControl?( control?:any ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of defaults  
		* @param defaults Object The new value. 
		*/
		setDefaults?( defaults?:any ): void;
		/** [Method] Sets the value of hideOnMaskTap  
		* @param hideOnMaskTap Boolean The new value. 
		*/
		setHideOnMaskTap?( hideOnMaskTap?:boolean ): void;
		/** [Method] Sets the value of items  
		* @param items Array/Object The new value. 
		*/
		setItems?( items?:any ): void;
		/** [Method] Sets the value of layout  
		* @param layout Object/String The new value. 
		*/
		setLayout?( layout?:any ): void;
		/** [Method] Sets the value of masked  
		* @param masked Boolean/Object/Ext.Mask/Ext.LoadMask The new value. 
		*/
		setMasked?( masked?:any ): void;
		/** [Method] Sets the value of modal  
		* @param modal Boolean The new value. 
		*/
		setModal?( modal?:boolean ): void;
		/** [Method] Sets the value of scrollable  
		* @param scrollable Boolean/String/Object The new value. 
		* @returns Ext.scroll.View The scroll view. 
		*/
		setScrollable?( scrollable?:any ): Ext.scroll.IView;
		/** [Method] Shows this component optionally using an animation  
		* @returns Ext.Component 
		*/
		show?(): Ext.IComponent;
		/** [Method] Convenience method which calls setMasked with a value of false to hide the mask */
		unmask?(): void;
	}
}
declare module Ext.data {
	export interface IArrayStore extends Ext.data.IStore {
		/** [Config Option] (String/Ext.data.proxy.Proxy/Object) */
		proxy?: any;
		/** [Method] Returns the value of proxy  
		* @returns Object 
		*/
		getProxy?(): any;
		/** [Method] Loads an array of data straight into the Store  
		* @param data Object 
		* @param append Object 
		*/
		loadData?( data?:any, append?:any ): void;
		/** [Method] Sets the value of proxy  
		* @param proxy Object The new value. 
		*/
		setProxy?( proxy?:any ): void;
	}
}
declare module Ext.data.association {
	export interface IAssociation extends Ext.IBase {
		/** [Config Option] (String) */
		associatedModel?: string;
		/** [Config Option] (String) */
		associatedName?: string;
		/** [Config Option] (String) */
		associationKey?: string;
		/** [Config Option] (Ext.data.Model/String) */
		ownerModel?: any;
		/** [Config Option] (String) */
		primaryKey?: string;
		/** [Config Option] (Ext.data.reader.Reader) */
		reader?: Ext.data.reader.IReader;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Returns the value of associatedModel  
		* @returns String 
		*/
		getAssociatedModel?(): string;
		/** [Method] Returns the value of associatedName  
		* @returns String 
		*/
		getAssociatedName?(): string;
		/** [Method] Returns the value of associationKey  
		* @returns String 
		*/
		getAssociationKey?(): string;
		/** [Method] Returns the value of name  
		* @returns Object 
		*/
		getName?(): any;
		/** [Method] Returns the value of ownerModel  
		* @returns Ext.data.Model/String 
		*/
		getOwnerModel?(): any;
		/** [Method] Returns the value of ownerName  
		* @returns String 
		*/
		getOwnerName?(): string;
		/** [Method] Returns the value of primaryKey  
		* @returns String 
		*/
		getPrimaryKey?(): string;
		/** [Method] Returns the value of reader  
		* @returns Ext.data.reader.Reader 
		*/
		getReader?(): Ext.data.reader.IReader;
		/** [Method] Returns the value of type  
		* @returns String 
		*/
		getType?(): string;
		/** [Method] Sets the value of associatedModel  
		* @param associatedModel String The new value. 
		*/
		setAssociatedModel?( associatedModel?:string ): void;
		/** [Method] Sets the value of associatedName  
		* @param associatedName String The new value. 
		*/
		setAssociatedName?( associatedName?:string ): void;
		/** [Method] Sets the value of associationKey  
		* @param associationKey String The new value. 
		*/
		setAssociationKey?( associationKey?:string ): void;
		/** [Method] Sets the value of name  
		* @param name Object The new value. 
		*/
		setName?( name?:any ): void;
		/** [Method] Sets the value of ownerModel  
		* @param ownerModel Ext.data.Model/String The new value. 
		*/
		setOwnerModel?( ownerModel?:any ): void;
		/** [Method] Sets the value of ownerName  
		* @param ownerName String The new value. 
		*/
		setOwnerName?( ownerName?:string ): void;
		/** [Method] Sets the value of primaryKey  
		* @param primaryKey String The new value. 
		*/
		setPrimaryKey?( primaryKey?:string ): void;
		/** [Method] Sets the value of reader  
		* @param reader Ext.data.reader.Reader The new value. 
		*/
		setReader?( reader?:Ext.data.reader.IReader ): void;
		/** [Method] Sets the value of type  
		* @param type String The new value. 
		*/
		setType?( type?:string ): void;
	}
}
declare module Ext.data {
	export interface IAssociation extends Ext.IBase {
		/** [Config Option] (String) */
		associatedModel?: string;
		/** [Config Option] (String) */
		associatedName?: string;
		/** [Config Option] (String) */
		associationKey?: string;
		/** [Config Option] (Ext.data.Model/String) */
		ownerModel?: any;
		/** [Config Option] (String) */
		primaryKey?: string;
		/** [Config Option] (Ext.data.reader.Reader) */
		reader?: Ext.data.reader.IReader;
		/** [Config Option] (String) */
		type?: string;
		/** [Method] Returns the value of associatedModel  
		* @returns String 
		*/
		getAssociatedModel?(): string;
		/** [Method] Returns the value of associatedName  
		* @returns String 
		*/
		getAssociatedName?(): string;
		/** [Method] Returns the value of associationKey  
		* @returns String 
		*/
		getAssociationKey?(): string;
		/** [Method] Returns the value of name  
		* @returns Object 
		*/
		getName?(): any;
		/** [Method] Returns the value of ownerModel  
		* @returns Ext.data.Model/String 
		*/
		getOwnerModel?(): any;
		/** [Method] Returns the value of ownerName  
		* @returns String 
		*/
		getOwnerName?(): string;
		/** [Method] Returns the value of primaryKey  
		* @returns String 
		*/
		getPrimaryKey?(): string;
		/** [Method] Returns the value of reader  
		* @returns Ext.data.reader.Reader 
		*/
		getReader?(): Ext.data.reader.IReader;
		/** [Method] Returns the value of type  
		* @returns String 
		*/
		getType?(): string;
		/** [Method] Sets the value of associatedModel  
		* @param associatedModel String The new value. 
		*/
		setAssociatedModel?( associatedModel?:string ): void;
		/** [Method] Sets the value of associatedName  
		* @param associatedName String The new value. 
		*/
		setAssociatedName?( associatedName?:string ): void;
		/** [Method] Sets the value of associationKey  
		* @param associationKey String The new value. 
		*/
		setAssociationKey?( associationKey?:string ): void;
		/** [Method] Sets the value of name  
		* @param name Object The new value. 
		*/
		setName?( name?:any ): void;
		/** [Method] Sets the value of ownerModel  
		* @param ownerModel Ext.data.Model/String The new value. 
		*/
		setOwnerModel?( ownerModel?:any ): void;
		/** [Method] Sets the value of ownerName  
		* @param ownerName String The new value. 
		*/
		setOwnerName?( ownerName?:string ): void;
		/** [Method] Sets the value of primaryKey  
		* @param primaryKey String The new value. 
		*/
		setPrimaryKey?( primaryKey?:string ): void;
		/** [Method] Sets the value of reader  
		* @param reader Ext.data.reader.Reader The new value. 
		*/
		setReader?( reader?:Ext.data.reader.IReader ): void;
		/** [Method] Sets the value of type  
		* @param type String The new value. 
		*/
		setType?( type?:string ): void;
	}
}
declare module Ext.data.association {
	export interface IBelongsTo extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Method] Returns the value of foreignKey  
		* @returns String 
		*/
		getForeignKey?(): string;
		/** [Method] Returns the value of getterName  
		* @returns String 
		*/
		getGetterName?(): string;
		/** [Method] Returns the value of instanceName  
		* @returns Object 
		*/
		getInstanceName?(): any;
		/** [Method] Returns the value of setterName  
		* @returns String 
		*/
		getSetterName?(): string;
		/** [Method] Sets the value of foreignKey  
		* @param foreignKey String The new value. 
		*/
		setForeignKey?( foreignKey?:string ): void;
		/** [Method] Sets the value of getterName  
		* @param getterName String The new value. 
		*/
		setGetterName?( getterName?:string ): void;
		/** [Method] Sets the value of instanceName  
		* @param instanceName Object The new value. 
		*/
		setInstanceName?( instanceName?:any ): void;
		/** [Method] Sets the value of setterName  
		* @param setterName String The new value. 
		*/
		setSetterName?( setterName?:string ): void;
	}
}
declare module Ext.data {
	export interface IBelongsToAssociation extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Method] Returns the value of foreignKey  
		* @returns String 
		*/
		getForeignKey?(): string;
		/** [Method] Returns the value of getterName  
		* @returns String 
		*/
		getGetterName?(): string;
		/** [Method] Returns the value of instanceName  
		* @returns Object 
		*/
		getInstanceName?(): any;
		/** [Method] Returns the value of setterName  
		* @returns String 
		*/
		getSetterName?(): string;
		/** [Method] Sets the value of foreignKey  
		* @param foreignKey String The new value. 
		*/
		setForeignKey?( foreignKey?:string ): void;
		/** [Method] Sets the value of getterName  
		* @param getterName String The new value. 
		*/
		setGetterName?( getterName?:string ): void;
		/** [Method] Sets the value of instanceName  
		* @param instanceName Object The new value. 
		*/
		setInstanceName?( instanceName?:any ): void;
		/** [Method] Sets the value of setterName  
		* @param setterName String The new value. 
		*/
		setSetterName?( setterName?:string ): void;
	}
}
declare module Ext.data.association {
	export interface IHasMany extends Ext.data.association.IAssociation {
		/** [Config Option] (Boolean) */
		autoLoad?: boolean;
		/** [Config Option] (Boolean) */
		autoSync?: boolean;
		/** [Config Option] (String) */
		filterProperty?: string;
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (Object) */
		store?: any;
		/** [Config Option] (Object) */
		storeConfig?: any;
		/** [Config Option] (String) */
		storeName?: string;
		/** [Method] Returns the value of autoLoad  
		* @returns Boolean 
		*/
		getAutoLoad?(): boolean;
		/** [Method] Returns the value of autoSync  
		* @returns Boolean 
		*/
		getAutoSync?(): boolean;
		/** [Method] Returns the value of filterProperty  
		* @returns String 
		*/
		getFilterProperty?(): string;
		/** [Method] Returns the value of foreignKey  
		* @returns String 
		*/
		getForeignKey?(): string;
		/** [Method] Returns the value of store  
		* @returns Object 
		*/
		getStore?(): any;
		/** [Method] Returns the value of storeName  
		* @returns String 
		*/
		getStoreName?(): string;
		/** [Method] Sets the value of autoLoad  
		* @param autoLoad Boolean The new value. 
		*/
		setAutoLoad?( autoLoad?:boolean ): void;
		/** [Method] Sets the value of autoSync  
		* @param autoSync Boolean The new value. 
		*/
		setAutoSync?( autoSync?:boolean ): void;
		/** [Method] Sets the value of filterProperty  
		* @param filterProperty String The new value. 
		*/
		setFilterProperty?( filterProperty?:string ): void;
		/** [Method] Sets the value of foreignKey  
		* @param foreignKey String The new value. 
		*/
		setForeignKey?( foreignKey?:string ): void;
		/** [Method] Sets the value of store  
		* @param store Object The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of storeName  
		* @param storeName String The new value. 
		*/
		setStoreName?( storeName?:string ): void;
	}
}
declare module Ext.data {
	export interface IHasManyAssociation extends Ext.data.association.IAssociation {
		/** [Config Option] (Boolean) */
		autoLoad?: boolean;
		/** [Config Option] (Boolean) */
		autoSync?: boolean;
		/** [Config Option] (String) */
		filterProperty?: string;
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (Object) */
		store?: any;
		/** [Config Option] (Object) */
		storeConfig?: any;
		/** [Config Option] (String) */
		storeName?: string;
		/** [Method] Returns the value of autoLoad  
		* @returns Boolean 
		*/
		getAutoLoad?(): boolean;
		/** [Method] Returns the value of autoSync  
		* @returns Boolean 
		*/
		getAutoSync?(): boolean;
		/** [Method] Returns the value of filterProperty  
		* @returns String 
		*/
		getFilterProperty?(): string;
		/** [Method] Returns the value of foreignKey  
		* @returns String 
		*/
		getForeignKey?(): string;
		/** [Method] Returns the value of store  
		* @returns Object 
		*/
		getStore?(): any;
		/** [Method] Returns the value of storeName  
		* @returns String 
		*/
		getStoreName?(): string;
		/** [Method] Sets the value of autoLoad  
		* @param autoLoad Boolean The new value. 
		*/
		setAutoLoad?( autoLoad?:boolean ): void;
		/** [Method] Sets the value of autoSync  
		* @param autoSync Boolean The new value. 
		*/
		setAutoSync?( autoSync?:boolean ): void;
		/** [Method] Sets the value of filterProperty  
		* @param filterProperty String The new value. 
		*/
		setFilterProperty?( filterProperty?:string ): void;
		/** [Method] Sets the value of foreignKey  
		* @param foreignKey String The new value. 
		*/
		setForeignKey?( foreignKey?:string ): void;
		/** [Method] Sets the value of store  
		* @param store Object The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of storeName  
		* @param storeName String The new value. 
		*/
		setStoreName?( storeName?:string ): void;
	}
}
declare module Ext.data.association {
	export interface IHasOne extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Method] Returns the value of foreignKey  
		* @returns String 
		*/
		getForeignKey?(): string;
		/** [Method] Returns the value of getterName  
		* @returns String 
		*/
		getGetterName?(): string;
		/** [Method] Returns the value of instanceName  
		* @returns Object 
		*/
		getInstanceName?(): any;
		/** [Method] Returns the value of setterName  
		* @returns String 
		*/
		getSetterName?(): string;
		/** [Method] Sets the value of foreignKey  
		* @param foreignKey String The new value. 
		*/
		setForeignKey?( foreignKey?:string ): void;
		/** [Method] Sets the value of getterName  
		* @param getterName String The new value. 
		*/
		setGetterName?( getterName?:string ): void;
		/** [Method] Sets the value of instanceName  
		* @param instanceName Object The new value. 
		*/
		setInstanceName?( instanceName?:any ): void;
		/** [Method] Sets the value of setterName  
		* @param setterName String The new value. 
		*/
		setSetterName?( setterName?:string ): void;
	}
}
declare module Ext.data {
	export interface IHasOneAssociation extends Ext.data.association.IAssociation {
		/** [Config Option] (String) */
		foreignKey?: string;
		/** [Config Option] (String) */
		getterName?: string;
		/** [Config Option] (String) */
		setterName?: string;
		/** [Method] Returns the value of foreignKey  
		* @returns String 
		*/
		getForeignKey?(): string;
		/** [Method] Returns the value of getterName  
		* @returns String 
		*/
		getGetterName?(): string;
		/** [Method] Returns the value of instanceName  
		* @returns Object 
		*/
		getInstanceName?(): any;
		/** [Method] Returns the value of setterName  
		* @returns String 
		*/
		getSetterName?(): string;
		/** [Method] Sets the value of foreignKey  
		* @param foreignKey String The new value. 
		*/
		setForeignKey?( foreignKey?:string ): void;
		/** [Method] Sets the value of getterName  
		* @param getterName String The new value. 
		*/
		setGetterName?( getterName?:string ): void;
		/** [Method] Sets the value of instanceName  
		* @param instanceName Object The new value. 
		*/
		setInstanceName?( instanceName?:any ): void;
		/** [Method] Sets the value of setterName  
		* @param setterName String The new value. 
		*/
		setSetterName?( setterName?:string ): void;
	}
}
declare module Ext.data {
	export interface IBatch extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Boolean) */
		autoStart?: boolean;
		/** [Config Option] (Boolean) */
		pauseOnException?: boolean;
		/** [Config Option] (Ext.data.Proxy) */
		proxy?: Ext.data.IProxy;
		/** [Property] (Number) */
		current?: number;
		/** [Property] (Boolean) */
		hasException?: boolean;
		/** [Property] (Boolean) */
		isComplete?: boolean;
		/** [Property] (Boolean) */
		isRunning?: boolean;
		/** [Property] (Ext.data.Operation[]) */
		operations?: Ext.data.IOperation[];
		/** [Property] (Number) */
		total?: number;
		/** [Method] Adds a new operation to this batch  
		* @param operation Object The Operation object. 
		*/
		add?( operation?:any ): void;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of autoStart  
		* @returns Boolean 
		*/
		getAutoStart?(): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of pauseOnException  
		* @returns Boolean 
		*/
		getPauseOnException?(): boolean;
		/** [Method] Returns the value of proxy  
		* @returns Ext.data.Proxy 
		*/
		getProxy?(): Ext.data.IProxy;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Pauses execution of the batch but does not cancel the current operation  */
		pause?(): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Executes a operation by its numeric index  
		* @param index Number The operation index to run. 
		*/
		runOperation?( index?:number ): void;
		/** [Method] Sets the value of autoStart  
		* @param autoStart Boolean The new value. 
		*/
		setAutoStart?( autoStart?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of pauseOnException  
		* @param pauseOnException Boolean The new value. 
		*/
		setPauseOnException?( pauseOnException?:boolean ): void;
		/** [Method] Sets the value of proxy  
		* @param proxy Ext.data.Proxy The new value. 
		*/
		setProxy?( proxy?:Ext.data.IProxy ): void;
		/** [Method] Kicks off the execution of the batch continuing from the next operation if the previous operation encountered an exc  */
		start?(): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.data {
	export interface IConnection extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Object) */
		defaultHeaders?: any;
		/** [Config Option] (String) */
		defaultXhrHeader?: string;
		/** [Config Option] (Boolean) */
		disableCaching?: boolean;
		/** [Config Option] (String) */
		disableCachingParam?: string;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String) */
		method?: string;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (String) */
		url?: string;
		/** [Config Option] (Boolean) */
		useDefaultXhrHeader?: boolean;
		/** [Method] Aborts any outstanding request  
		* @param request Object Defaults to the last request. 
		*/
		abort?( request?:any ): void;
		/** [Method] Aborts all outstanding requests  */
		abortAll?(): void;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of async  
		* @returns Boolean 
		*/
		getAsync?(): boolean;
		/** [Method] Returns the value of autoAbort  
		* @returns Boolean 
		*/
		getAutoAbort?(): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of defaultHeaders  
		* @returns Object 
		*/
		getDefaultHeaders?(): any;
		/** [Method] Returns the value of defaultPostHeader  
		* @returns String 
		*/
		getDefaultPostHeader?(): string;
		/** [Method] Returns the value of defaultXhrHeader  
		* @returns String 
		*/
		getDefaultXhrHeader?(): string;
		/** [Method] Returns the value of disableCaching  
		* @returns Boolean 
		*/
		getDisableCaching?(): boolean;
		/** [Method] Returns the value of disableCachingParam  
		* @returns String 
		*/
		getDisableCachingParam?(): string;
		/** [Method] Returns the value of extraParams  
		* @returns Object 
		*/
		getExtraParams?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of method  
		* @returns String 
		*/
		getMethod?(): string;
		/** [Method] Returns the value of password  
		* @returns String 
		*/
		getPassword?(): string;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		getTimeout?(): number;
		/** [Method] Returns the value of url  
		* @returns String 
		*/
		getUrl?(): string;
		/** [Method] Returns the value of useDefaultHeader  
		* @returns Boolean 
		*/
		getUseDefaultHeader?(): boolean;
		/** [Method] Returns the value of useDefaultXhrHeader  
		* @returns Boolean 
		*/
		getUseDefaultXhrHeader?(): boolean;
		/** [Method] Returns the value of username  
		* @returns String 
		*/
		getUsername?(): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Determines whether this object has a request outstanding  
		* @param request Object The request to check. 
		* @returns Boolean True if there is an outstanding request. 
		*/
		isLoading?( request?:any ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Checks if the response status was successful  
		* @param status Number The status code. 
		* @param xhr XMLHttpRequest 
		* @returns Object An object containing success/status state. 
		*/
		parseStatus?( status?:number, xhr?:XMLHttpRequest ): any;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Sends an HTTP request to a remote server  
		* @param options Object An object which may contain the following properties: (The options object may also contain any other property which might be needed to perform post-processing in a callback because it is passed to callback functions.) 
		* @returns Object/null The request object. This may be used to cancel the request. 
		*/
		request?( options?:any ): any;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of async  
		* @param async Boolean The new value. 
		*/
		setAsync?( async?:boolean ): void;
		/** [Method] Sets the value of autoAbort  
		* @param autoAbort Boolean The new value. 
		*/
		setAutoAbort?( autoAbort?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of defaultHeaders  
		* @param defaultHeaders Object The new value. 
		*/
		setDefaultHeaders?( defaultHeaders?:any ): void;
		/** [Method] Sets the value of defaultPostHeader  
		* @param defaultPostHeader String The new value. 
		*/
		setDefaultPostHeader?( defaultPostHeader?:string ): void;
		/** [Method] Sets the value of defaultXhrHeader  
		* @param defaultXhrHeader String The new value. 
		*/
		setDefaultXhrHeader?( defaultXhrHeader?:string ): void;
		/** [Method] Sets the value of disableCaching  
		* @param disableCaching Boolean The new value. 
		*/
		setDisableCaching?( disableCaching?:boolean ): void;
		/** [Method] Sets the value of disableCachingParam  
		* @param disableCachingParam String The new value. 
		*/
		setDisableCachingParam?( disableCachingParam?:string ): void;
		/** [Method] Sets the value of extraParams  
		* @param extraParams Object The new value. 
		*/
		setExtraParams?( extraParams?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of method  
		* @param method String The new value. 
		*/
		setMethod?( method?:string ): void;
		/** [Method] Sets various options such as the url params for the request  
		* @param options Object The initial options. 
		* @param scope Object The scope to execute in. 
		* @returns Object The params for the request. 
		*/
		setOptions?( options?:any, scope?:any ): any;
		/** [Method] Sets the value of password  
		* @param password String The new value. 
		*/
		setPassword?( password?:string ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		setTimeout?( timeout?:number ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
		/** [Method] Sets the value of useDefaultHeader  
		* @param useDefaultHeader Boolean The new value. 
		*/
		setUseDefaultHeader?( useDefaultHeader?:boolean ): void;
		/** [Method] Sets the value of useDefaultXhrHeader  
		* @param useDefaultXhrHeader Boolean The new value. 
		*/
		setUseDefaultXhrHeader?( useDefaultXhrHeader?:boolean ): void;
		/** [Method] Sets the value of username  
		* @param username String The new value. 
		*/
		setUsername?( username?:string ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Uploads a form using a hidden iframe  
		* @param form String/HTMLElement/Ext.Element The form to upload. 
		* @param url String The url to post to. 
		* @param params String Any extra parameters to pass. 
		* @param options Object The initial options. 
		*/
		upload?( form?:any, url?:string, params?:string, options?:any ): void;
	}
}
declare module Ext.data {
	export interface IDirectStore extends Ext.data.IStore {
		/** [Config Option] (String/Ext.data.proxy.Proxy/Object) */
		proxy?: any;
		/** [Method] Returns the value of proxy  
		* @returns Object 
		*/
		getProxy?(): any;
		/** [Method] Sets the value of proxy  
		* @param proxy Object The new value. 
		*/
		setProxy?( proxy?:any ): void;
	}
}
declare module Ext.data {
	export interface IError extends Ext.IBase {
		/** [Config Option] (String) */
		field?: string;
		/** [Config Option] (String) */
		message?: string;
		/** [Method] Returns the value of field  
		* @returns String 
		*/
		getField?(): string;
		/** [Method] Returns the value of message  
		* @returns String 
		*/
		getMessage?(): string;
		/** [Method] Sets the value of field  
		* @param field String The new value. 
		*/
		setField?( field?:string ): void;
		/** [Method] Sets the value of message  
		* @param message String The new value. 
		*/
		setMessage?( message?:string ): void;
	}
}
declare module Ext.data {
	export interface IErrors extends Ext.util.ICollection {
		/** [Method] Adds an item to the collection  
		* @returns Object The item added. 
		*/
		add?(): any;
		/** [Method] Returns all of the errors for the given field  
		* @param fieldName String The field to get errors for. 
		* @returns Object[] All errors for the given field. 
		*/
		getByField?( fieldName?:string ): any[];
		/** [Method] Returns true if there are no errors in the collection  
		* @returns Boolean 
		*/
		isValid?(): boolean;
	}
}
declare module Ext.data {
	export interface IField extends Ext.IBase {
		/** [Config Option] (Boolean) */
		allowNull?: boolean;
		/** [Config Option] (Function) */
		convert?: any;
		/** [Config Option] (String) */
		dateFormat?: string;
		/** [Config Option] (Object) */
		defaultValue?: any;
		/** [Config Option] (String/Number) */
		mapping?: any;
		/** [Config Option] (String) */
		name?: string;
		/** [Config Option] (Boolean) */
		persist?: boolean;
		/** [Config Option] (String) */
		sortDir?: string;
		/** [Config Option] (Function) */
		sortType?: any;
		/** [Config Option] (String/Object) */
		type?: any;
		/** [Config Option] (Boolean) */
		useNull?: boolean;
		/** [Method] Returns the value of allowNull  
		* @returns Boolean 
		*/
		getAllowNull?(): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String 
		*/
		getBubbleEvents?(): string;
		/** [Method] Returns the value of convert  
		* @returns Function 
		*/
		getConvert?(): any;
		/** [Method] Returns the value of dateFormat  
		* @returns String 
		*/
		getDateFormat?(): string;
		/** [Method] Returns the value of decode  
		* @returns Object 
		*/
		getDecode?(): any;
		/** [Method] Returns the value of defaultValue  
		* @returns Object 
		*/
		getDefaultValue?(): any;
		/** [Method] Returns the value of encode  
		* @returns Object 
		*/
		getEncode?(): any;
		/** [Method] Returns the value of mapping  
		* @returns String/Number 
		*/
		getMapping?(): any;
		/** [Method] Returns the value of name  
		* @returns String 
		*/
		getName?(): string;
		/** [Method] Returns the value of persist  
		* @returns Boolean 
		*/
		getPersist?(): boolean;
		/** [Method] Returns the value of sortDir  
		* @returns String 
		*/
		getSortDir?(): string;
		/** [Method] Returns the value of sortType  
		* @returns Function 
		*/
		getSortType?(): any;
		/** [Method] Returns the value of type  
		* @returns String/Object 
		*/
		getType?(): any;
		/** [Method] Sets the value of allowNull  
		* @param allowNull Boolean The new value. 
		*/
		setAllowNull?( allowNull?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:string ): void;
		/** [Method] Sets the value of convert  
		* @param convert Function The new value. 
		*/
		setConvert?( convert?:any ): void;
		/** [Method] Sets the value of dateFormat  
		* @param dateFormat String The new value. 
		*/
		setDateFormat?( dateFormat?:string ): void;
		/** [Method] Sets the value of decode  
		* @param decode Object The new value. 
		*/
		setDecode?( decode?:any ): void;
		/** [Method] Sets the value of defaultValue  
		* @param defaultValue Object The new value. 
		*/
		setDefaultValue?( defaultValue?:any ): void;
		/** [Method] Sets the value of encode  
		* @param encode Object The new value. 
		*/
		setEncode?( encode?:any ): void;
		/** [Method] Sets the value of mapping  
		* @param mapping String/Number The new value. 
		*/
		setMapping?( mapping?:any ): void;
		/** [Method] Sets the value of name  
		* @param name String The new value. 
		*/
		setName?( name?:string ): void;
		/** [Method] Sets the value of persist  
		* @param persist Boolean The new value. 
		*/
		setPersist?( persist?:boolean ): void;
		/** [Method] Sets the value of sortDir  
		* @param sortDir String The new value. 
		*/
		setSortDir?( sortDir?:string ): void;
		/** [Method] Sets the value of sortType  
		* @param sortType Function The new value. 
		*/
		setSortType?( sortType?:any ): void;
		/** [Method] Sets the value of type  
		* @param type String/Object The new value. 
		*/
		setType?( type?:any ): void;
	}
}
declare module Ext.data.identifier {
	export interface ISequential extends Ext.data.identifier.ISimple {
		/** [Config Option] (String) */
		prefix?: string;
		/** [Config Option] (Number) */
		seed?: number;
		/** [Method] Returns the value of prefix  
		* @returns String 
		*/
		getPrefix?(): string;
		/** [Method] Returns the value of seed  
		* @returns Number 
		*/
		getSeed?(): number;
		/** [Method] Sets the value of prefix  
		* @param prefix String The new value. 
		*/
		setPrefix?( prefix?:string ): void;
		/** [Method] Sets the value of seed  
		* @param seed Number The new value. 
		*/
		setSeed?( seed?:number ): void;
	}
}
declare module Ext.data.identifier {
	export interface ISimple extends Ext.IBase {
		/** [Method] Returns the value of prefix  
		* @returns String 
		*/
		getPrefix?(): string;
		/** [Method] Sets the value of prefix  
		* @param prefix String The new value. 
		*/
		setPrefix?( prefix?:string ): void;
	}
}
declare module Ext.data.identifier {
	export interface IUuid extends Ext.data.identifier.ISimple {
		/** [Config Option] (Object) */
		id?: any;
		/** [Config Option] (Number) */
		version?: number;
		/** [Property] (Number/Object) */
		salt?: any;
		/** [Property] (Number/Object) */
		timestamp?: any;
		/** [Method] Returns the value of id  
		* @returns Object 
		*/
		getId?(): any;
		/** [Method] Returns the value of version  
		* @returns Number 
		*/
		getVersion?(): number;
		/** [Method] Reconfigures this generator given new config properties  
		* @param config Object 
		*/
		reconfigure?( config?:any ): void;
		/** [Method] Sets the value of id  
		* @param id Object The new value. 
		*/
		setId?( id?:any ): void;
		/** [Method] Sets the value of version  
		* @param version Number The new value. 
		*/
		setVersion?( version?:number ): void;
	}
}
declare module Ext.data {
	export interface IJsonP extends Ext.IBase {
	}
	export class JsonP {
		/** [Property] (String) */
		static callbackKey: string;
		/** [Property] (Boolean) */
		static disableCaching: boolean;
		/** [Property] (String) */
		static disableCachingParam: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Number) */
		static timeout: number;
		/** [Method] Abort a request  
		* @param request Object/String The request to abort. 
		*/
		static abort( request?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Makes a JSONP request  
		* @param options Object An object which may contain the following properties. Note that options will take priority over any defaults that are specified in the class. 
		* @returns Object request An object containing the request details. 
		*/
		static request( options?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.util {
	export interface IJSONP extends Ext.IBase {
	}
	export class JSONP {
		/** [Property] (String) */
		static callbackKey: string;
		/** [Property] (Boolean) */
		static disableCaching: boolean;
		/** [Property] (String) */
		static disableCachingParam: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Number) */
		static timeout: number;
		/** [Method] Abort a request  
		* @param request Object/String The request to abort. 
		*/
		static abort( request?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Makes a JSONP request  
		* @param options Object An object which may contain the following properties. Note that options will take priority over any defaults that are specified in the class. 
		* @returns Object request An object containing the request details. 
		*/
		static request( options?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data {
	export interface IJsonStore extends Ext.data.IStore {
		/** [Config Option] (String/Ext.data.proxy.Proxy/Object) */
		proxy?: any;
		/** [Method] Returns the value of proxy  
		* @returns Object 
		*/
		getProxy?(): any;
		/** [Method] Sets the value of proxy  
		* @param proxy Object The new value. 
		*/
		setProxy?( proxy?:any ): void;
	}
}
declare module Ext.data {
	export interface IModel extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Object[]) */
		associations?: any[];
		/** [Config Option] (String/Object/String[]/Object[]) */
		belongsTo?: any;
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (Object[]/String[]) */
		fields?: any;
		/** [Config Option] (String/Object/String[]/Object[]) */
		hasMany?: any;
		/** [Config Option] (String/Object/String[]/Object[]) */
		hasOne?: any;
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Object/String) */
		identifier?: any;
		/** [Config Option] (Object/Ext.data.Proxy) */
		proxy?: any;
		/** [Config Option] (Boolean) */
		useCache?: boolean;
		/** [Config Option] (Object[]) */
		validations?: any[];
		/** [Property] (Boolean) */
		dirty?: boolean;
		/** [Property] (Boolean) */
		editing?: boolean;
		/** [Property] (Object) */
		modified?: any;
		/** [Property] (Boolean) */
		phantom?: boolean;
		/** [Property] (Object) */
		raw?: any;
		/** [Property] (Array) */
		stores?: any[];
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Begins an edit  */
		beginEdit?(): void;
		/** [Method] Cancels all changes made in the current edit operation  */
		cancelEdit?(): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method] Usually called by the Ext data Store which owns the model instance  
		* @param silent Boolean true to skip notification of the owning store of the change. 
		*/
		commit?( silent?:boolean ): void;
		/** [Method] Creates a copy clone of this Model instance  
		* @param id String A new id. If you don't specify this a new id will be generated for you. To generate a phantom instance with a new id use: var rec = record.copy(); // clone the record with a new id 
		* @returns Ext.data.Model 
		*/
		copy?( id?:string ): Ext.data.IModel;
		/** [Method] Destroys this model instance  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Ends an edit  
		* @param silent Boolean true to not notify the store of the change. 
		* @param modifiedFieldNames String[] Array of field names changed during edit. 
		*/
		endEdit?( silent?:boolean, modifiedFieldNames?:string[] ): void;
		/** [Method] Destroys the record using the configured proxy  
		* @param options Object/Function Options to pass to the proxy. Config object for Ext.data.Operation. If you pass a function, this will automatically become the callback method. For convenience the config object may also contain success and failure methods in addition to callback - they will all be invoked with the Model and Operation as arguments. 
		* @param scope Object The scope to run your callback method in. This is only used if you passed a function as the first argument. 
		* @returns Ext.data.Model The Model instance. 
		*/
		erase?( options?:any, scope?:any ): Ext.data.IModel;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of the given field  
		* @param fieldName String The field to fetch the value for. 
		* @returns Object The value. 
		*/
		get?( fieldName?:string ): any;
		/** [Method] Gets all of the data from this Models loaded associations  
		* @returns Object The nested data set for the Model's loaded associations. 
		*/
		getAssociatedData?(): any;
		/** [Method] Returns the value of associations  
		* @returns Object[] 
		*/
		getAssociations?(): any[];
		/** [Method] Returns the value of belongsTo  
		* @returns String/Object/String[]/Object[] 
		*/
		getBelongsTo?(): any;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Gets a hash of only the fields that have been modified since this Model was created or committed  
		* @returns Object 
		*/
		getChanges?(): any;
		/** [Method] Returns the value of clientIdProperty  
		* @returns String 
		*/
		getClientIdProperty?(): string;
		/** [Method] Returns an object containing the data set on this record  
		* @param includeAssociated Boolean true to include the associated data. 
		* @returns Object The data. 
		*/
		getData?( includeAssociated?:boolean ): any;
		/** [Method] Returns the value of fields  
		* @returns Object[]/String[] 
		*/
		getFields?(): any;
		/** [Method] Returns the value of hasMany  
		* @returns String/Object/String[]/Object[] 
		*/
		getHasMany?(): any;
		/** [Method] Returns the value of hasOne  
		* @returns String/Object/String[]/Object[] 
		*/
		getHasOne?(): any;
		/** [Method] Returns the unique ID allocated to this model instance as defined by idProperty  
		* @returns Number/String The id. 
		*/
		getId?(): any;
		/** [Method] Returns the value of idProperty  
		* @returns String 
		*/
		getIdProperty?(): string;
		/** [Method] Returns the value of identifier  
		* @returns Object/String 
		*/
		getIdentifier?(): any;
		/** [Method] Returns true if the record has been erased on the server  */
		getIsErased?(): void;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of proxy  
		* @returns Object/Ext.data.Proxy 
		*/
		getProxy?(): any;
		/** [Method] Returns the value of useCache  
		* @returns Boolean 
		*/
		getUseCache?(): boolean;
		/** [Method] Returns the value of validations  
		* @returns Object[] 
		*/
		getValidations?(): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Returns true if the passed field name has been modified since the load or last commit  
		* @param fieldName String Ext.data.Field.name 
		* @returns Boolean 
		*/
		isModified?( fieldName?:string ): boolean;
		/** [Method] Checks if the model is valid  
		* @returns Boolean true if the model is valid. 
		*/
		isValid?(): boolean;
		/** [Method] By joining this model to an instance of a class this model will automatically try to call certain template methods o  
		* @param store Ext.data.Store The store to which this model has been added. 
		*/
		join?( store?:Ext.data.IStore ): void;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Usually called by the Ext data Store to which this model instance has been joined  
		* @param silent Boolean true to skip notification of the owning store of the change. 
		*/
		reject?( silent?:boolean ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Saves the model instance using the configured proxy  
		* @param options Object/Function Options to pass to the proxy. Config object for Ext.data.Operation. If you pass a function, this will automatically become the callback method. For convenience the config object may also contain success and failure methods in addition to callback - they will all be invoked with the Model and Operation as arguments. 
		* @param scope Object The scope to run your callback method in. This is only used if you passed a function as the first argument. 
		* @returns Ext.data.Model The Model instance 
		*/
		save?( options?:any, scope?:any ): Ext.data.IModel;
		/** [Method] Sets the given field to the given value marks the instance as dirty  
		* @param fieldName String/Object The field to set, or an object containing key/value pairs. 
		* @param value Object The value to set. 
		*/
		set?( fieldName?:any, value?:any ): void;
		/** [Method] Sets the value of associations  
		* @param associations Object[] The new value. 
		*/
		setAssociations?( associations?:any[] ): void;
		/** [Method] Sets the value of belongsTo  
		* @param belongsTo String/Object/String[]/Object[] The new value. 
		*/
		setBelongsTo?( belongsTo?:any ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of clientIdProperty  
		* @param clientIdProperty String The new value. 
		*/
		setClientIdProperty?( clientIdProperty?:string ): void;
		/** [Method] This sets the data directly without converting and applying default values  
		* @param data Object 
		* @returns Ext.data.Model This Record. 
		*/
		setConvertedData?( data?:any ): Ext.data.IModel;
		/** [Method] This method is used to set the data for this Record instance  
		* @param rawData Object 
		* @returns Ext.data.Model This record. 
		*/
		setData?( rawData?:any ): Ext.data.IModel;
		/** [Method] Marks this Record as dirty  */
		setDirty?(): void;
		/** [Method] Updates the collection of Fields that all instances of this Model use  
		* @param fields Array 
		* @returns any 
		*/
		setFields?( fields?:any[] ): any;
		/** [Method] Sets the value of hasMany  
		* @param hasMany String/Object/String[]/Object[] The new value. 
		*/
		setHasMany?( hasMany?:any ): void;
		/** [Method] Sets the value of hasOne  
		* @param hasOne String/Object/String[]/Object[] The new value. 
		*/
		setHasOne?( hasOne?:any ): void;
		/** [Method] Sets the model instance s id field to the given id  
		* @param id Number/String The new id 
		*/
		setId?( id?:any ): void;
		/** [Method] Sets the value of idProperty  
		* @param idProperty String The new value. 
		*/
		setIdProperty?( idProperty?:string ): void;
		/** [Method] Sets the value of identifier  
		* @param identifier Object/String The new value. 
		*/
		setIdentifier?( identifier?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of proxy  
		* @param proxy Object/Ext.data.Proxy The new value. 
		*/
		setProxy?( proxy?:any ): void;
		/** [Method] Sets the value of useCache  
		* @param useCache Boolean The new value. 
		*/
		setUseCache?( useCache?:boolean ): void;
		/** [Method] Sets the value of validations  
		* @param validations Object[] The new value. 
		*/
		setValidations?( validations?:any[] ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Returns a url suitable string for this model instance  
		* @returns String The url string for this model instance. 
		*/
		toUrl?(): string;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] This un joins this record from an instance of a class  
		* @param store Ext.data.Store The store from which this model has been removed. 
		*/
		unjoin?( store?:Ext.data.IStore ): void;
		/** [Method] Validates the current data against all of its configured validations  
		* @returns Ext.data.Errors The errors object. 
		*/
		validate?(): Ext.data.IErrors;
	}
	export class Model {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method]  
		* @param args Object 
		*/
		static callParent( args?:any ): void;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Asynchronously loads a model instance by id  
		* @param id Number The id of the model to load 
		* @param config Object Config object containing fields: 
		* @param scope Object Same as config.scope. 
		*/
		static load( id?:number, config?:any, scope?:any ): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface IRecord extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Object[]) */
		associations?: any[];
		/** [Config Option] (String/Object/String[]/Object[]) */
		belongsTo?: any;
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (Object[]/String[]) */
		fields?: any;
		/** [Config Option] (String/Object/String[]/Object[]) */
		hasMany?: any;
		/** [Config Option] (String/Object/String[]/Object[]) */
		hasOne?: any;
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Object/String) */
		identifier?: any;
		/** [Config Option] (Object/Ext.data.Proxy) */
		proxy?: any;
		/** [Config Option] (Boolean) */
		useCache?: boolean;
		/** [Config Option] (Object[]) */
		validations?: any[];
		/** [Property] (Boolean) */
		dirty?: boolean;
		/** [Property] (Boolean) */
		editing?: boolean;
		/** [Property] (Object) */
		modified?: any;
		/** [Property] (Boolean) */
		phantom?: boolean;
		/** [Property] (Object) */
		raw?: any;
		/** [Property] (Array) */
		stores?: any[];
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Begins an edit  */
		beginEdit?(): void;
		/** [Method] Cancels all changes made in the current edit operation  */
		cancelEdit?(): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method] Usually called by the Ext data Store which owns the model instance  
		* @param silent Boolean true to skip notification of the owning store of the change. 
		*/
		commit?( silent?:boolean ): void;
		/** [Method] Creates a copy clone of this Model instance  
		* @param id String A new id. If you don't specify this a new id will be generated for you. To generate a phantom instance with a new id use: var rec = record.copy(); // clone the record with a new id 
		* @returns Ext.data.Model 
		*/
		copy?( id?:string ): Ext.data.IModel;
		/** [Method] Destroys this model instance  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Ends an edit  
		* @param silent Boolean true to not notify the store of the change. 
		* @param modifiedFieldNames String[] Array of field names changed during edit. 
		*/
		endEdit?( silent?:boolean, modifiedFieldNames?:string[] ): void;
		/** [Method] Destroys the record using the configured proxy  
		* @param options Object/Function Options to pass to the proxy. Config object for Ext.data.Operation. If you pass a function, this will automatically become the callback method. For convenience the config object may also contain success and failure methods in addition to callback - they will all be invoked with the Model and Operation as arguments. 
		* @param scope Object The scope to run your callback method in. This is only used if you passed a function as the first argument. 
		* @returns Ext.data.Model The Model instance. 
		*/
		erase?( options?:any, scope?:any ): Ext.data.IModel;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of the given field  
		* @param fieldName String The field to fetch the value for. 
		* @returns Object The value. 
		*/
		get?( fieldName?:string ): any;
		/** [Method] Gets all of the data from this Models loaded associations  
		* @returns Object The nested data set for the Model's loaded associations. 
		*/
		getAssociatedData?(): any;
		/** [Method] Returns the value of associations  
		* @returns Object[] 
		*/
		getAssociations?(): any[];
		/** [Method] Returns the value of belongsTo  
		* @returns String/Object/String[]/Object[] 
		*/
		getBelongsTo?(): any;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Gets a hash of only the fields that have been modified since this Model was created or committed  
		* @returns Object 
		*/
		getChanges?(): any;
		/** [Method] Returns the value of clientIdProperty  
		* @returns String 
		*/
		getClientIdProperty?(): string;
		/** [Method] Returns an object containing the data set on this record  
		* @param includeAssociated Boolean true to include the associated data. 
		* @returns Object The data. 
		*/
		getData?( includeAssociated?:boolean ): any;
		/** [Method] Returns the value of fields  
		* @returns Object[]/String[] 
		*/
		getFields?(): any;
		/** [Method] Returns the value of hasMany  
		* @returns String/Object/String[]/Object[] 
		*/
		getHasMany?(): any;
		/** [Method] Returns the value of hasOne  
		* @returns String/Object/String[]/Object[] 
		*/
		getHasOne?(): any;
		/** [Method] Returns the unique ID allocated to this model instance as defined by idProperty  
		* @returns Number/String The id. 
		*/
		getId?(): any;
		/** [Method] Returns the value of idProperty  
		* @returns String 
		*/
		getIdProperty?(): string;
		/** [Method] Returns the value of identifier  
		* @returns Object/String 
		*/
		getIdentifier?(): any;
		/** [Method] Returns true if the record has been erased on the server  */
		getIsErased?(): void;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of proxy  
		* @returns Object/Ext.data.Proxy 
		*/
		getProxy?(): any;
		/** [Method] Returns the value of useCache  
		* @returns Boolean 
		*/
		getUseCache?(): boolean;
		/** [Method] Returns the value of validations  
		* @returns Object[] 
		*/
		getValidations?(): any[];
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Returns true if the passed field name has been modified since the load or last commit  
		* @param fieldName String Ext.data.Field.name 
		* @returns Boolean 
		*/
		isModified?( fieldName?:string ): boolean;
		/** [Method] Checks if the model is valid  
		* @returns Boolean true if the model is valid. 
		*/
		isValid?(): boolean;
		/** [Method] By joining this model to an instance of a class this model will automatically try to call certain template methods o  
		* @param store Ext.data.Store The store to which this model has been added. 
		*/
		join?( store?:Ext.data.IStore ): void;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Usually called by the Ext data Store to which this model instance has been joined  
		* @param silent Boolean true to skip notification of the owning store of the change. 
		*/
		reject?( silent?:boolean ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Saves the model instance using the configured proxy  
		* @param options Object/Function Options to pass to the proxy. Config object for Ext.data.Operation. If you pass a function, this will automatically become the callback method. For convenience the config object may also contain success and failure methods in addition to callback - they will all be invoked with the Model and Operation as arguments. 
		* @param scope Object The scope to run your callback method in. This is only used if you passed a function as the first argument. 
		* @returns Ext.data.Model The Model instance 
		*/
		save?( options?:any, scope?:any ): Ext.data.IModel;
		/** [Method] Sets the given field to the given value marks the instance as dirty  
		* @param fieldName String/Object The field to set, or an object containing key/value pairs. 
		* @param value Object The value to set. 
		*/
		set?( fieldName?:any, value?:any ): void;
		/** [Method] Sets the value of associations  
		* @param associations Object[] The new value. 
		*/
		setAssociations?( associations?:any[] ): void;
		/** [Method] Sets the value of belongsTo  
		* @param belongsTo String/Object/String[]/Object[] The new value. 
		*/
		setBelongsTo?( belongsTo?:any ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of clientIdProperty  
		* @param clientIdProperty String The new value. 
		*/
		setClientIdProperty?( clientIdProperty?:string ): void;
		/** [Method] This sets the data directly without converting and applying default values  
		* @param data Object 
		* @returns Ext.data.Model This Record. 
		*/
		setConvertedData?( data?:any ): Ext.data.IModel;
		/** [Method] This method is used to set the data for this Record instance  
		* @param rawData Object 
		* @returns Ext.data.Model This record. 
		*/
		setData?( rawData?:any ): Ext.data.IModel;
		/** [Method] Marks this Record as dirty  */
		setDirty?(): void;
		/** [Method] Updates the collection of Fields that all instances of this Model use  
		* @param fields Array 
		* @returns any 
		*/
		setFields?( fields?:any[] ): any;
		/** [Method] Sets the value of hasMany  
		* @param hasMany String/Object/String[]/Object[] The new value. 
		*/
		setHasMany?( hasMany?:any ): void;
		/** [Method] Sets the value of hasOne  
		* @param hasOne String/Object/String[]/Object[] The new value. 
		*/
		setHasOne?( hasOne?:any ): void;
		/** [Method] Sets the model instance s id field to the given id  
		* @param id Number/String The new id 
		*/
		setId?( id?:any ): void;
		/** [Method] Sets the value of idProperty  
		* @param idProperty String The new value. 
		*/
		setIdProperty?( idProperty?:string ): void;
		/** [Method] Sets the value of identifier  
		* @param identifier Object/String The new value. 
		*/
		setIdentifier?( identifier?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of proxy  
		* @param proxy Object/Ext.data.Proxy The new value. 
		*/
		setProxy?( proxy?:any ): void;
		/** [Method] Sets the value of useCache  
		* @param useCache Boolean The new value. 
		*/
		setUseCache?( useCache?:boolean ): void;
		/** [Method] Sets the value of validations  
		* @param validations Object[] The new value. 
		*/
		setValidations?( validations?:any[] ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Returns a url suitable string for this model instance  
		* @returns String The url string for this model instance. 
		*/
		toUrl?(): string;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] This un joins this record from an instance of a class  
		* @param store Ext.data.Store The store from which this model has been removed. 
		*/
		unjoin?( store?:Ext.data.IStore ): void;
		/** [Method] Validates the current data against all of its configured validations  
		* @returns Ext.data.Errors The errors object. 
		*/
		validate?(): Ext.data.IErrors;
	}
	export class Record {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method]  
		* @param args Object 
		*/
		static callParent( args?:any ): void;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Asynchronously loads a model instance by id  
		* @param id Number The id of the model to load 
		* @param config Object Config object containing fields: 
		* @param scope Object Same as config.scope. 
		*/
		static load( id?:number, config?:any, scope?:any ): void;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface IModelManager extends Ext.IAbstractManager {
	}
	export class ModelManager {
		/** [Property] (Ext.util.HashMap) */
		static all: Ext.util.IHashMap;
		/** [Property] (Object) */
		static associationStack: any;
		/** [Property] (Object) */
		static defaultProxyType: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new instance of a Model using the given data  
		* @param data Object Data to initialize the Model's fields with. 
		* @param name String The name of the model to create. 
		* @param id Number Unique id of the Model instance (see Ext.data.Model). 
		* @returns Object 
		*/
		static create( data?:any, name?:string, id?:number ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item. 
		* @returns Object The item, undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the Ext data Model for a given model name  
		* @param id String/Object The id of the model or the model instance. 
		* @returns Ext.data.Model A model class. 
		*/
		static getModel( id?:any ): Ext.data.IModel;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up. 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id. 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		static onAvailable( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed  
		* @param item Object The item to register. 
		*/
		static register( item?:any ): void;
		/** [Method] Registers a model definition  
		* @param name String 
		* @param config Object 
		* @returns Object 
		*/
		static registerType( name?:string, config?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager  
		* @param item Object The item to unregister. 
		*/
		static unregister( item?:any ): void;
	}
}
declare module Ext {
	export interface IModelMgr extends Ext.IAbstractManager {
	}
	export class ModelMgr {
		/** [Property] (Ext.util.HashMap) */
		static all: Ext.util.IHashMap;
		/** [Property] (Object) */
		static associationStack: any;
		/** [Property] (Object) */
		static defaultProxyType: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new instance of a Model using the given data  
		* @param data Object Data to initialize the Model's fields with. 
		* @param name String The name of the model to create. 
		* @param id Number Unique id of the Model instance (see Ext.data.Model). 
		* @returns Object 
		*/
		static create( data?:any, name?:string, id?:number ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item. 
		* @returns Object The item, undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the Ext data Model for a given model name  
		* @param id String/Object The id of the model or the model instance. 
		* @returns Ext.data.Model A model class. 
		*/
		static getModel( id?:any ): Ext.data.IModel;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up. 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id. 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		static onAvailable( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed  
		* @param item Object The item to register. 
		*/
		static register( item?:any ): void;
		/** [Method] Registers a model definition  
		* @param name String 
		* @param config Object 
		* @returns Object 
		*/
		static registerType( name?:string, config?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager  
		* @param item Object The item to unregister. 
		*/
		static unregister( item?:any ): void;
	}
}
declare module Ext {
	export interface IModelManager extends Ext.IAbstractManager {
	}
	export class ModelManager {
		/** [Property] (Ext.util.HashMap) */
		static all: Ext.util.IHashMap;
		/** [Property] (Object) */
		static associationStack: any;
		/** [Property] (Object) */
		static defaultProxyType: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Creates a new instance of a Model using the given data  
		* @param data Object Data to initialize the Model's fields with. 
		* @param name String The name of the model to create. 
		* @param id Number Unique id of the Model instance (see Ext.data.Model). 
		* @returns Object 
		*/
		static create( data?:any, name?:string, id?:number ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for each item in the collection  
		* @param fn Function The function to execute. 
		* @param scope Object The scope to execute in. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Returns an item by id  
		* @param id String The id of the item. 
		* @returns Object The item, undefined if not found. 
		*/
		static get( id?:string ): any;
		/** [Method] Gets the number of items in the collection  
		* @returns Number The number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the Ext data Model for a given model name  
		* @param id String/Object The id of the model or the model instance. 
		* @returns Ext.data.Model A model class. 
		*/
		static getModel( id?:any ): Ext.data.IModel;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Checks if an item type is registered  
		* @param type String The mnemonic string by which the class may be looked up. 
		* @returns Boolean Whether the type is registered. 
		*/
		static isRegistered( type?:string ): boolean;
		/** [Method] Registers a function that will be called when an item with the specified id is added to the manager  
		* @param id String The item id. 
		* @param fn Function The callback function. Called with a single parameter, the item. 
		* @param scope Object The scope (this reference) in which the callback is executed. Defaults to the item. 
		*/
		static onAvailable( id?:string, fn?:any, scope?:any ): void;
		/** [Method] Registers an item to be managed  
		* @param item Object The item to register. 
		*/
		static register( item?:any ): void;
		/** [Method] Registers a model definition  
		* @param name String 
		* @param config Object 
		* @returns Object 
		*/
		static registerType( name?:string, config?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters an item by removing it from this manager  
		* @param item Object The item to unregister. 
		*/
		static unregister( item?:any ): void;
	}
}
declare module Ext.data {
	export interface INodeInterface extends Ext.IBase {
		/** [Property] (Object) */
		childNodes?: any;
		/** [Property] (Object) */
		firstChild?: any;
		/** [Property] (Object) */
		lastChild?: any;
		/** [Property] (Object) */
		nextSibling?: any;
		/** [Property] (Object) */
		parentNode?: any;
		/** [Property] (Object) */
		previousSibling?: any;
		/** [Method] Insert node s as the last child node of this node  
		* @param node Ext.data.NodeInterface/Ext.data.NodeInterface[] The node or Array of nodes to append. 
		* @returns Ext.data.NodeInterface The appended node if single append, or null if an array was passed. 
		*/
		appendChild?( node?:any ): Ext.data.INodeInterface;
		/** [Method] Bubbles up the tree from this node calling the specified function with each node  
		* @param fn Function The function to call. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node. 
		* @param args Array The args to call the function with (default to passing the current Node). 
		*/
		bubble?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Cascades down the tree from this node calling the specified function with each node  
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node. 
		* @param args Array The args to call the function with (default to passing the current Node). 
		*/
		cascadeBy?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Collapse this node  
		* @param recursive Function true to recursively collapse all the children. 
		* @param callback Function The function to execute once the collapse completes. 
		* @param scope Object The scope to run the callback in. 
		*/
		collapse?( recursive?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns true if this node is an ancestor at any point of the passed node  
		* @param node Ext.data.NodeInterface 
		* @returns Boolean 
		*/
		contains?( node?:Ext.data.INodeInterface ): boolean;
		/** [Method] Creates a copy clone of this Node  
		* @param newId String A new id, defaults to this Node's id. 
		* @param deep Boolean If passed as true, all child Nodes are recursively copied into the new Node. If omitted or false, the copy will have no child Nodes. 
		* @returns Ext.data.NodeInterface A copy of this Node. 
		*/
		copy?( newId?:string, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Destroys the node  
		* @param silent Object 
		*/
		destroy?( silent?:any ): void;
		/** [Method] Iterates the child nodes of this node calling the specified function with each node  
		* @param fn Function The function to call. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node in the iteration. 
		* @param args Array The args to call the function with (default to passing the current Node). 
		*/
		eachChild?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Expand this node  
		* @param recursive Function true to recursively expand all the children. 
		* @param callback Function The function to execute once the expand completes. 
		* @param scope Object The scope to run the callback in. 
		*/
		expand?( recursive?:any, callback?:any, scope?:any ): void;
		/** [Method] Finds the first child that has the attribute with the specified value  
		* @param attribute String The attribute name. 
		* @param value Object The value to search for. 
		* @param deep Boolean true to search through nodes deeper than the immediate children. 
		* @returns Ext.data.NodeInterface The found child or null if none was found. 
		*/
		findChild?( attribute?:string, value?:any, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Finds the first child by a custom function  
		* @param fn Function A function which must return true if the passed Node is the required Node. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Node being tested. 
		* @param deep Boolean True to search through nodes deeper than the immediate children. 
		* @returns Ext.data.NodeInterface The found child or null if none was found. 
		*/
		findChildBy?( fn?:any, scope?:any, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Returns the child node at the specified index  
		* @param index Number 
		* @returns Ext.data.NodeInterface 
		*/
		getChildAt?( index?:number ): Ext.data.INodeInterface;
		/** [Method] Returns depth of this node the root node has a depth of 0 
		* @returns Number 
		*/
		getDepth?(): number;
		/** [Method] Gets the hierarchical path from the root of the current node  
		* @param field String The field to construct the path from. Defaults to the model idProperty. 
		* @param separator String A separator to use. 
		* @returns String The node path 
		*/
		getPath?( field?:string, separator?:string ): string;
		/** [Method] Returns true if this node has one or more child nodes else false  
		* @returns Boolean 
		*/
		hasChildNodes?(): boolean;
		/** [Method] Returns the index of a child node  
		* @param child Ext.data.NodeInterface 
		* @returns Number The index of the node or -1 if it was not found. 
		*/
		indexOf?( child?:Ext.data.INodeInterface ): number;
		/** [Method] Inserts the first node before the second node in this nodes childNodes collection  
		* @param node Ext.data.NodeInterface The node to insert. 
		* @param refNode Ext.data.NodeInterface The node to insert before (if null the node is appended). 
		* @returns Ext.data.NodeInterface The inserted node. 
		*/
		insertBefore?( node?:Ext.data.INodeInterface, refNode?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Insert a node into this node  
		* @param index Number The zero-based index to insert the node at. 
		* @param node Ext.data.Model The node to insert. 
		* @returns Ext.data.Model The record you just inserted. 
		*/
		insertChild?( index?:number, node?:Ext.data.IModel ): Ext.data.IModel;
		/** [Method] Returns true if the passed node is an ancestor at any point of this node  
		* @param node Ext.data.NodeInterface 
		* @returns Boolean 
		*/
		isAncestor?( node?:Ext.data.INodeInterface ): boolean;
		/** [Method] Returns true if this node has one or more child nodes or if the expandable node attribute is explicitly specified as  
		* @returns Boolean 
		*/
		isExpandable?(): boolean;
		/** [Method] Returns true if this node is expanded  
		* @returns Boolean 
		*/
		isExpanded?(): boolean;
		/** [Method] Returns true if this node is the first child of its parent  
		* @returns Boolean 
		*/
		isFirst?(): boolean;
		/** [Method] Returns true if this node is the last child of its parent  
		* @returns Boolean 
		*/
		isLast?(): boolean;
		/** [Method] Returns true if this node is a leaf 
		* @returns Boolean 
		*/
		isLeaf?(): boolean;
		/** [Method] Returns true if this node is loaded  
		* @returns Boolean 
		*/
		isLoaded?(): boolean;
		/** [Method] Returns true if this node is loading  
		* @returns Boolean 
		*/
		isLoading?(): boolean;
		/** [Method] Returns true if this node is the root node  
		* @returns Boolean 
		*/
		isRoot?(): boolean;
		/** [Method] Returns true if this node is visible  
		* @returns Boolean 
		*/
		isVisible?(): boolean;
		/** [Method] Removes this node from its parent  
		* @param destroy Boolean true to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface this 
		*/
		remove?( destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Removes all child nodes from this node  
		* @param destroy Boolean true to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface this 
		*/
		removeAll?( destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Removes a child node from this node  
		* @param node Ext.data.NodeInterface The node to remove. 
		* @param destroy Boolean true to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface The removed node. 
		*/
		removeChild?( node?:Ext.data.INodeInterface, destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Replaces one child node in this node with another  
		* @param newChild Ext.data.NodeInterface The replacement node. 
		* @param oldChild Ext.data.NodeInterface The node to replace. 
		* @returns Ext.data.NodeInterface The replaced node. 
		*/
		replaceChild?( newChild?:Ext.data.INodeInterface, oldChild?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Sorts this nodes children using the supplied sort function  
		* @param sortFn Function A function which, when passed two Nodes, returns -1, 0 or 1 depending upon required sort order. 
		* @param recursive Boolean Whether or not to apply this sort recursively. 
		* @param suppressEvent Boolean Set to true to not fire a sort event. 
		*/
		sort?( sortFn?:any, recursive?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Updates general data of this node like isFirst isLast depth  
		* @param silent Object 
		* @returns Boolean 
		*/
		updateInfo?( silent?:any ): boolean;
	}
	export class NodeInterface {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method]  
		* @param args Object 
		*/
		static callParent( args?:any ): void;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] This method allows you to decorate a Record s prototype to implement the NodeInterface  
		* @param record Ext.data.Model The Record you want to decorate the prototype of. 
		*/
		static decorate( record?:Ext.data.IModel ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface INode extends Ext.IBase {
		/** [Property] (Object) */
		childNodes?: any;
		/** [Property] (Object) */
		firstChild?: any;
		/** [Property] (Object) */
		lastChild?: any;
		/** [Property] (Object) */
		nextSibling?: any;
		/** [Property] (Object) */
		parentNode?: any;
		/** [Property] (Object) */
		previousSibling?: any;
		/** [Method] Insert node s as the last child node of this node  
		* @param node Ext.data.NodeInterface/Ext.data.NodeInterface[] The node or Array of nodes to append. 
		* @returns Ext.data.NodeInterface The appended node if single append, or null if an array was passed. 
		*/
		appendChild?( node?:any ): Ext.data.INodeInterface;
		/** [Method] Bubbles up the tree from this node calling the specified function with each node  
		* @param fn Function The function to call. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node. 
		* @param args Array The args to call the function with (default to passing the current Node). 
		*/
		bubble?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Cascades down the tree from this node calling the specified function with each node  
		* @param fn Function The function to call 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node. 
		* @param args Array The args to call the function with (default to passing the current Node). 
		*/
		cascadeBy?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Collapse this node  
		* @param recursive Function true to recursively collapse all the children. 
		* @param callback Function The function to execute once the collapse completes. 
		* @param scope Object The scope to run the callback in. 
		*/
		collapse?( recursive?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns true if this node is an ancestor at any point of the passed node  
		* @param node Ext.data.NodeInterface 
		* @returns Boolean 
		*/
		contains?( node?:Ext.data.INodeInterface ): boolean;
		/** [Method] Creates a copy clone of this Node  
		* @param newId String A new id, defaults to this Node's id. 
		* @param deep Boolean If passed as true, all child Nodes are recursively copied into the new Node. If omitted or false, the copy will have no child Nodes. 
		* @returns Ext.data.NodeInterface A copy of this Node. 
		*/
		copy?( newId?:string, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Destroys the node  
		* @param silent Object 
		*/
		destroy?( silent?:any ): void;
		/** [Method] Iterates the child nodes of this node calling the specified function with each node  
		* @param fn Function The function to call. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Node in the iteration. 
		* @param args Array The args to call the function with (default to passing the current Node). 
		*/
		eachChild?( fn?:any, scope?:any, args?:any[] ): void;
		/** [Method] Expand this node  
		* @param recursive Function true to recursively expand all the children. 
		* @param callback Function The function to execute once the expand completes. 
		* @param scope Object The scope to run the callback in. 
		*/
		expand?( recursive?:any, callback?:any, scope?:any ): void;
		/** [Method] Finds the first child that has the attribute with the specified value  
		* @param attribute String The attribute name. 
		* @param value Object The value to search for. 
		* @param deep Boolean true to search through nodes deeper than the immediate children. 
		* @returns Ext.data.NodeInterface The found child or null if none was found. 
		*/
		findChild?( attribute?:string, value?:any, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Finds the first child by a custom function  
		* @param fn Function A function which must return true if the passed Node is the required Node. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the Node being tested. 
		* @param deep Boolean True to search through nodes deeper than the immediate children. 
		* @returns Ext.data.NodeInterface The found child or null if none was found. 
		*/
		findChildBy?( fn?:any, scope?:any, deep?:boolean ): Ext.data.INodeInterface;
		/** [Method] Returns the child node at the specified index  
		* @param index Number 
		* @returns Ext.data.NodeInterface 
		*/
		getChildAt?( index?:number ): Ext.data.INodeInterface;
		/** [Method] Returns depth of this node the root node has a depth of 0 
		* @returns Number 
		*/
		getDepth?(): number;
		/** [Method] Gets the hierarchical path from the root of the current node  
		* @param field String The field to construct the path from. Defaults to the model idProperty. 
		* @param separator String A separator to use. 
		* @returns String The node path 
		*/
		getPath?( field?:string, separator?:string ): string;
		/** [Method] Returns true if this node has one or more child nodes else false  
		* @returns Boolean 
		*/
		hasChildNodes?(): boolean;
		/** [Method] Returns the index of a child node  
		* @param child Ext.data.NodeInterface 
		* @returns Number The index of the node or -1 if it was not found. 
		*/
		indexOf?( child?:Ext.data.INodeInterface ): number;
		/** [Method] Inserts the first node before the second node in this nodes childNodes collection  
		* @param node Ext.data.NodeInterface The node to insert. 
		* @param refNode Ext.data.NodeInterface The node to insert before (if null the node is appended). 
		* @returns Ext.data.NodeInterface The inserted node. 
		*/
		insertBefore?( node?:Ext.data.INodeInterface, refNode?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Insert a node into this node  
		* @param index Number The zero-based index to insert the node at. 
		* @param node Ext.data.Model The node to insert. 
		* @returns Ext.data.Model The record you just inserted. 
		*/
		insertChild?( index?:number, node?:Ext.data.IModel ): Ext.data.IModel;
		/** [Method] Returns true if the passed node is an ancestor at any point of this node  
		* @param node Ext.data.NodeInterface 
		* @returns Boolean 
		*/
		isAncestor?( node?:Ext.data.INodeInterface ): boolean;
		/** [Method] Returns true if this node has one or more child nodes or if the expandable node attribute is explicitly specified as  
		* @returns Boolean 
		*/
		isExpandable?(): boolean;
		/** [Method] Returns true if this node is expanded  
		* @returns Boolean 
		*/
		isExpanded?(): boolean;
		/** [Method] Returns true if this node is the first child of its parent  
		* @returns Boolean 
		*/
		isFirst?(): boolean;
		/** [Method] Returns true if this node is the last child of its parent  
		* @returns Boolean 
		*/
		isLast?(): boolean;
		/** [Method] Returns true if this node is a leaf 
		* @returns Boolean 
		*/
		isLeaf?(): boolean;
		/** [Method] Returns true if this node is loaded  
		* @returns Boolean 
		*/
		isLoaded?(): boolean;
		/** [Method] Returns true if this node is loading  
		* @returns Boolean 
		*/
		isLoading?(): boolean;
		/** [Method] Returns true if this node is the root node  
		* @returns Boolean 
		*/
		isRoot?(): boolean;
		/** [Method] Returns true if this node is visible  
		* @returns Boolean 
		*/
		isVisible?(): boolean;
		/** [Method] Removes this node from its parent  
		* @param destroy Boolean true to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface this 
		*/
		remove?( destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Removes all child nodes from this node  
		* @param destroy Boolean true to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface this 
		*/
		removeAll?( destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Removes a child node from this node  
		* @param node Ext.data.NodeInterface The node to remove. 
		* @param destroy Boolean true to destroy the node upon removal. 
		* @returns Ext.data.NodeInterface The removed node. 
		*/
		removeChild?( node?:Ext.data.INodeInterface, destroy?:boolean ): Ext.data.INodeInterface;
		/** [Method] Replaces one child node in this node with another  
		* @param newChild Ext.data.NodeInterface The replacement node. 
		* @param oldChild Ext.data.NodeInterface The node to replace. 
		* @returns Ext.data.NodeInterface The replaced node. 
		*/
		replaceChild?( newChild?:Ext.data.INodeInterface, oldChild?:Ext.data.INodeInterface ): Ext.data.INodeInterface;
		/** [Method] Sorts this nodes children using the supplied sort function  
		* @param sortFn Function A function which, when passed two Nodes, returns -1, 0 or 1 depending upon required sort order. 
		* @param recursive Boolean Whether or not to apply this sort recursively. 
		* @param suppressEvent Boolean Set to true to not fire a sort event. 
		*/
		sort?( sortFn?:any, recursive?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Updates general data of this node like isFirst isLast depth  
		* @param silent Object 
		* @returns Boolean 
		*/
		updateInfo?( silent?:any ): boolean;
	}
	export class Node {
		/** [Method] Add methods  properties to the prototype of this class  
		* @param members Object 
		*/
		static addMembers( members?:any ): void;
		/** [Method] Add  override static properties of this class  
		* @param members Object 
		* @returns Ext.Base this 
		*/
		static addStatics( members?:any ): Ext.IBase;
		/** [Method]  
		* @param args Object 
		*/
		static callParent( args?:any ): void;
		/** [Method] Create a new instance of this Class  
		* @returns Object the created instance. 
		*/
		static create(): any;
		/** [Method] Create aliases for existing prototype methods  
		* @param alias String/Object The new method name, or an object to set multiple aliases. See flexSetter 
		* @param origin String/Object The original method name 
		*/
		static createAlias( alias?:any, origin?:any ): void;
		/** [Method] This method allows you to decorate a Record s prototype to implement the NodeInterface  
		* @param record Ext.data.Model The Record you want to decorate the prototype of. 
		*/
		static decorate( record?:Ext.data.IModel ): void;
		/** [Method] Get the current class name in string format  
		* @returns String className 
		*/
		static getName(): string;
		/** [Method] Override members of this class  
		* @param members Object The properties to add to this class. This should be specified as an object literal containing one or more properties. 
		* @returns Ext.Base this class 
		*/
		static override( members?:any ): Ext.IBase;
	}
}
declare module Ext.data {
	export interface INodeStore extends Ext.data.IStore {
		/** [Config Option] (Object[]) */
		filters?: any[];
		/** [Config Option] (Boolean) */
		folderSort?: boolean;
		/** [Config Option] (Ext.data.Model) */
		node?: Ext.data.IModel;
		/** [Config Option] (Boolean) */
		recursive?: boolean;
		/** [Config Option] (Boolean) */
		rootVisible?: boolean;
		/** [Config Option] (Object[]) */
		sorters?: any[];
		/** [Method] Returns the value of filters  
		* @returns Object 
		*/
		getFilters?(): any;
		/** [Method] Returns the value of folderSort  
		* @returns Boolean 
		*/
		getFolderSort?(): boolean;
		/** [Method] Returns the value of node  
		* @returns Ext.data.Model 
		*/
		getNode?(): Ext.data.IModel;
		/** [Method] Returns the value of recursive  
		* @returns Boolean 
		*/
		getRecursive?(): boolean;
		/** [Method] Returns the value of rootVisible  
		* @returns Boolean 
		*/
		getRootVisible?(): boolean;
		/** [Method] Returns the value of sorters  
		* @returns Object 
		*/
		getSorters?(): any;
		/** [Method]  
		* @param node Object 
		* @returns Boolean 
		*/
		isVisible?( node?:any ): boolean;
		/** [Method] Sets the value of filters  
		* @param filters Object The new value. 
		*/
		setFilters?( filters?:any ): void;
		/** [Method] Sets the value of folderSort  
		* @param folderSort Boolean The new value. 
		*/
		setFolderSort?( folderSort?:boolean ): void;
		/** [Method] Sets the value of node  
		* @param node Ext.data.Model The new value. 
		*/
		setNode?( node?:Ext.data.IModel ): void;
		/** [Method] Sets the value of recursive  
		* @param recursive Boolean The new value. 
		*/
		setRecursive?( recursive?:boolean ): void;
		/** [Method] Sets the value of rootVisible  
		* @param rootVisible Boolean The new value. 
		*/
		setRootVisible?( rootVisible?:boolean ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Object The new value. 
		*/
		setSorters?( sorters?:any ): void;
	}
}
declare module Ext.data {
	export interface IOperation extends Ext.IBase {
		/** [Config Option] (String) */
		action?: string;
		/** [Config Option] (Ext.data.Batch) */
		batch?: Ext.data.IBatch;
		/** [Config Option] (Function) */
		callback?: any;
		/** [Config Option] (Ext.util.Filter[]) */
		filters?: Ext.util.IFilter[];
		/** [Config Option] (Boolean) */
		group?: boolean;
		/** [Config Option] (Ext.util.Grouper) */
		grouper?: Ext.util.IGrouper;
		/** [Config Option] (Number) */
		limit?: number;
		/** [Config Option] (Ext.data.Model) */
		model?: Ext.data.IModel;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (Array) */
		records?: any[];
		/** [Config Option] (Ext.data.Request) */
		request?: Ext.data.IRequest;
		/** [Config Option] (Object) */
		response?: any;
		/** [Config Option] (Ext.data.ResultSet) */
		resultSet?: Ext.data.IResultSet;
		/** [Config Option] (Object) */
		scope?: any;
		/** [Config Option] (Ext.util.Sorter[]) */
		sorters?: Ext.util.ISorter[];
		/** [Config Option] (Number) */
		start?: number;
		/** [Config Option] (Boolean) */
		synchronous?: boolean;
		/** [Config Option] (Boolean) */
		withCredentials?: boolean;
		/** [Method] Checks whether this operation should cause writing to occur  
		* @returns Boolean Whether the operation should cause a write to occur. 
		*/
		allowWrite?(): boolean;
		/** [Method] Returns the value of action  
		* @returns String 
		*/
		getAction?(): string;
		/** [Method] Returns the value of addRecords  
		* @returns Boolean 
		*/
		getAddRecords?(): boolean;
		/** [Method] Returns the value of batch  
		* @returns Ext.data.Batch 
		*/
		getBatch?(): Ext.data.IBatch;
		/** [Method] Returns the value of callback  
		* @returns Function 
		*/
		getCallback?(): any;
		/** [Method] Returns the error string or object that was set using setException  
		* @returns String/Object The error object. 
		*/
		getError?(): any;
		/** [Method] Returns the value of filters  
		* @returns Ext.util.Filter[] 
		*/
		getFilters?(): Ext.util.IFilter[];
		/** [Method] Returns the value of grouper  
		* @returns Ext.util.Grouper 
		*/
		getGrouper?(): Ext.util.IGrouper;
		/** [Method] Returns the value of limit  
		* @returns Number 
		*/
		getLimit?(): number;
		/** [Method] Returns the value of model  
		* @returns Ext.data.Model 
		*/
		getModel?(): Ext.data.IModel;
		/** [Method] Returns the value of node  
		* @returns Object 
		*/
		getNode?(): any;
		/** [Method] Returns the value of page  
		* @returns Object 
		*/
		getPage?(): any;
		/** [Method] Returns the value of params  
		* @returns Object 
		*/
		getParams?(): any;
		/** [Method] Returns the value of request  
		* @returns Ext.data.Request 
		*/
		getRequest?(): Ext.data.IRequest;
		/** [Method] Returns the value of response  
		* @returns Object 
		*/
		getResponse?(): any;
		/** [Method] Returns the value of resultSet  
		* @returns Ext.data.ResultSet 
		*/
		getResultSet?(): Ext.data.IResultSet;
		/** [Method] Returns the value of scope  
		* @returns Object 
		*/
		getScope?(): any;
		/** [Method] Returns the value of sorters  
		* @returns Ext.util.Sorter[] 
		*/
		getSorters?(): Ext.util.ISorter[];
		/** [Method] Returns the value of start  
		* @returns Number 
		*/
		getStart?(): number;
		/** [Method] Returns the value of synchronous  
		* @returns Boolean 
		*/
		getSynchronous?(): boolean;
		/** [Method] Returns the value of url  
		* @returns Object 
		*/
		getUrl?(): any;
		/** [Method] Returns the value of withCredentials  
		* @returns Boolean 
		*/
		getWithCredentials?(): boolean;
		/** [Method] Returns true if this Operation encountered an exception see also getError 
		* @returns Boolean true if there was an exception. 
		*/
		hasException?(): boolean;
		/** [Method] Returns true if the Operation has been completed 
		* @returns Boolean true if the Operation is complete 
		*/
		isComplete?(): boolean;
		/** [Method] Returns true if the Operation has been started but has not yet completed  
		* @returns Boolean true if the Operation is currently running 
		*/
		isRunning?(): boolean;
		/** [Method] Returns true if the Operation has been started  
		* @returns Boolean true if the Operation has started 
		*/
		isStarted?(): boolean;
		/** [Method] Sets the value of action  
		* @param action String The new value. 
		*/
		setAction?( action?:string ): void;
		/** [Method] Sets the value of addRecords  
		* @param addRecords Boolean The new value. 
		*/
		setAddRecords?( addRecords?:boolean ): void;
		/** [Method] Sets the value of batch  
		* @param batch Ext.data.Batch The new value. 
		*/
		setBatch?( batch?:Ext.data.IBatch ): void;
		/** [Method] Sets the value of callback  
		* @param callback Function The new value. 
		*/
		setCallback?( callback?:any ): void;
		/** [Method] Marks the Operation as completed  */
		setCompleted?(): void;
		/** [Method] Marks the Operation as having experienced an exception  
		* @param error String/Object error string/object 
		*/
		setException?( error?:any ): void;
		/** [Method] Sets the value of filters  
		* @param filters Ext.util.Filter[] The new value. 
		*/
		setFilters?( filters?:Ext.util.IFilter[] ): void;
		/** [Method] Sets the value of grouper  
		* @param grouper Ext.util.Grouper The new value. 
		*/
		setGrouper?( grouper?:Ext.util.IGrouper ): void;
		/** [Method] Sets the value of limit  
		* @param limit Number The new value. 
		*/
		setLimit?( limit?:number ): void;
		/** [Method] Sets the value of model  
		* @param model Ext.data.Model The new value. 
		*/
		setModel?( model?:Ext.data.IModel ): void;
		/** [Method] Sets the value of node  
		* @param node Object The new value. 
		*/
		setNode?( node?:any ): void;
		/** [Method] Sets the value of page  
		* @param page Object The new value. 
		*/
		setPage?( page?:any ): void;
		/** [Method] Sets the value of params  
		* @param params Object The new value. 
		*/
		setParams?( params?:any ): void;
		/** [Method] Sets the value of records  
		* @param records Array The new value. 
		*/
		setRecords?( records?:any[] ): void;
		/** [Method] Sets the value of request  
		* @param request Ext.data.Request The new value. 
		*/
		setRequest?( request?:Ext.data.IRequest ): void;
		/** [Method] Sets the value of response  
		* @param response Object The new value. 
		*/
		setResponse?( response?:any ): void;
		/** [Method] Sets the value of resultSet  
		* @param resultSet Ext.data.ResultSet The new value. 
		*/
		setResultSet?( resultSet?:Ext.data.IResultSet ): void;
		/** [Method] Sets the value of scope  
		* @param scope Object The new value. 
		*/
		setScope?( scope?:any ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Ext.util.Sorter[] The new value. 
		*/
		setSorters?( sorters?:Ext.util.ISorter[] ): void;
		/** [Method] Sets the value of start  
		* @param start Number The new value. 
		*/
		setStart?( start?:number ): void;
		/** [Method] Marks the Operation as started  */
		setStarted?(): void;
		/** [Method] Marks the Operation as successful  */
		setSuccessful?(): void;
		/** [Method] Sets the value of synchronous  
		* @param synchronous Boolean The new value. 
		*/
		setSynchronous?( synchronous?:boolean ): void;
		/** [Method] Sets the value of url  
		* @param url Object The new value. 
		*/
		setUrl?( url?:any ): void;
		/** [Method] Sets the value of withCredentials  
		* @param withCredentials Boolean The new value. 
		*/
		setWithCredentials?( withCredentials?:boolean ): void;
		/** [Method] Returns true if the Operation has completed and was successful 
		* @returns Boolean true if successful 
		*/
		wasSuccessful?(): boolean;
	}
}
declare module Ext.data.plugin {
	export interface IBuffered extends Ext.IEvented {
		/** [Config Option] (Number) */
		leadingBufferZone?: number;
		/** [Config Option] (Number) */
		purgePageCount?: number;
		/** [Config Option] (Number) */
		trailingBufferZone?: number;
		/** [Method] Returns the value of bufferedCollection  
		* @returns Object 
		*/
		getBufferedCollection?(): any;
		/** [Method] Returns the value of leadingBufferZone  
		* @returns Number 
		*/
		getLeadingBufferZone?(): number;
		/** [Method] Determines the page from a record index 
		* @param index Number The record index 
		* @returns Number The page the record belongs to 
		*/
		getPageFromRecordIndex?( index?:number ): number;
		/** [Method] Returns the value of purgePageCount  
		* @returns Number 
		*/
		getPurgePageCount?(): number;
		/** [Method] Returns the value of store  
		* @returns Object 
		*/
		getStore?(): any;
		/** [Method] Returns the value of trailingBufferZone  
		* @returns Number 
		*/
		getTrailingBufferZone?(): number;
		/** [Method] Returns the value of viewSize  
		* @returns Number 
		*/
		getViewSize?(): number;
		/** [Method] Prefetches data into the store using its configured proxy  
		* @param options Object config object, passed into the Ext.data.Operation object before loading. See load 
		*/
		prefetch?( options?:any ): void;
		/** [Method] Prefetches a page of data  
		* @param page Number The page to prefetch 
		* @param options Object config object, passed into the Ext.data.Operation object before loading. See load 
		*/
		prefetchPage?( page?:number, options?:any ): void;
		/** [Method] Sets the value of bufferedCollection  
		* @param bufferedCollection Object The new value. 
		*/
		setBufferedCollection?( bufferedCollection?:any ): void;
		/** [Method] Sets the value of leadingBufferZone  
		* @param leadingBufferZone Number The new value. 
		*/
		setLeadingBufferZone?( leadingBufferZone?:number ): void;
		/** [Method] Sets the value of purgePageCount  
		* @param purgePageCount Number The new value. 
		*/
		setPurgePageCount?( purgePageCount?:number ): void;
		/** [Method] Sets the value of store  
		* @param store Object The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of trailingBufferZone  
		* @param trailingBufferZone Number The new value. 
		*/
		setTrailingBufferZone?( trailingBufferZone?:number ): void;
		/** [Method] Sets the value of viewSize  
		* @param viewSize Number The new value. 
		*/
		setViewSize?( viewSize?:number ): void;
	}
}
declare module Ext.data.proxy {
	export interface IAjax extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		headers?: any;
		/** [Config Option] (String) */
		password?: string;
		/** [Config Option] (Boolean) */
		useDefaultXhrHeader?: boolean;
		/** [Config Option] (String) */
		username?: string;
		/** [Config Option] (Boolean) */
		withCredentials?: boolean;
		/** [Property] (Object) */
		actionMethods?: any;
		/** [Method] Performs Ajax request  
		* @param operation Ext.data.Operation 
		* @param callback Function 
		* @param scope Object 
		* @returns Object 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): any;
		/** [Method] Returns the value of headers  
		* @returns Object 
		*/
		getHeaders?(): any;
		/** [Method] Returns the HTTP method name for a given request  
		* @param request Ext.data.Request The request object. 
		* @returns String The HTTP method to use (should be one of 'GET', 'POST', 'PUT' or 'DELETE'). 
		*/
		getMethod?( request?:Ext.data.IRequest ): string;
		/** [Method] Returns the value of password  
		* @returns String 
		*/
		getPassword?(): string;
		/** [Method] Returns the value of useDefaultXhrHeader  
		* @returns Boolean 
		*/
		getUseDefaultXhrHeader?(): boolean;
		/** [Method] Returns the value of username  
		* @returns String 
		*/
		getUsername?(): string;
		/** [Method] Returns the value of withCredentials  
		* @returns Boolean 
		*/
		getWithCredentials?(): boolean;
		/** [Method] Sets the value of headers  
		* @param headers Object The new value. 
		*/
		setHeaders?( headers?:any ): void;
		/** [Method] Sets the value of password  
		* @param password String The new value. 
		*/
		setPassword?( password?:string ): void;
		/** [Method] Sets the value of useDefaultXhrHeader  
		* @param useDefaultXhrHeader Boolean The new value. 
		*/
		setUseDefaultXhrHeader?( useDefaultXhrHeader?:boolean ): void;
		/** [Method] Sets the value of username  
		* @param username String The new value. 
		*/
		setUsername?( username?:string ): void;
		/** [Method] Sets the value of withCredentials  
		* @param withCredentials Boolean The new value. 
		*/
		setWithCredentials?( withCredentials?:boolean ): void;
	}
}
declare module Ext.data {
	export interface IHttpProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		headers?: any;
		/** [Config Option] (String) */
		password?: string;
		/** [Config Option] (Boolean) */
		useDefaultXhrHeader?: boolean;
		/** [Config Option] (String) */
		username?: string;
		/** [Config Option] (Boolean) */
		withCredentials?: boolean;
		/** [Property] (Object) */
		actionMethods?: any;
		/** [Method] Performs Ajax request  
		* @param operation Ext.data.Operation 
		* @param callback Function 
		* @param scope Object 
		* @returns Object 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): any;
		/** [Method] Returns the value of headers  
		* @returns Object 
		*/
		getHeaders?(): any;
		/** [Method] Returns the HTTP method name for a given request  
		* @param request Ext.data.Request The request object. 
		* @returns String The HTTP method to use (should be one of 'GET', 'POST', 'PUT' or 'DELETE'). 
		*/
		getMethod?( request?:Ext.data.IRequest ): string;
		/** [Method] Returns the value of password  
		* @returns String 
		*/
		getPassword?(): string;
		/** [Method] Returns the value of useDefaultXhrHeader  
		* @returns Boolean 
		*/
		getUseDefaultXhrHeader?(): boolean;
		/** [Method] Returns the value of username  
		* @returns String 
		*/
		getUsername?(): string;
		/** [Method] Returns the value of withCredentials  
		* @returns Boolean 
		*/
		getWithCredentials?(): boolean;
		/** [Method] Sets the value of headers  
		* @param headers Object The new value. 
		*/
		setHeaders?( headers?:any ): void;
		/** [Method] Sets the value of password  
		* @param password String The new value. 
		*/
		setPassword?( password?:string ): void;
		/** [Method] Sets the value of useDefaultXhrHeader  
		* @param useDefaultXhrHeader Boolean The new value. 
		*/
		setUseDefaultXhrHeader?( useDefaultXhrHeader?:boolean ): void;
		/** [Method] Sets the value of username  
		* @param username String The new value. 
		*/
		setUsername?( username?:string ): void;
		/** [Method] Sets the value of withCredentials  
		* @param withCredentials Boolean The new value. 
		*/
		setWithCredentials?( withCredentials?:boolean ): void;
	}
}
declare module Ext.data {
	export interface IAjaxProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		headers?: any;
		/** [Config Option] (String) */
		password?: string;
		/** [Config Option] (Boolean) */
		useDefaultXhrHeader?: boolean;
		/** [Config Option] (String) */
		username?: string;
		/** [Config Option] (Boolean) */
		withCredentials?: boolean;
		/** [Property] (Object) */
		actionMethods?: any;
		/** [Method] Performs Ajax request  
		* @param operation Ext.data.Operation 
		* @param callback Function 
		* @param scope Object 
		* @returns Object 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): any;
		/** [Method] Returns the value of headers  
		* @returns Object 
		*/
		getHeaders?(): any;
		/** [Method] Returns the HTTP method name for a given request  
		* @param request Ext.data.Request The request object. 
		* @returns String The HTTP method to use (should be one of 'GET', 'POST', 'PUT' or 'DELETE'). 
		*/
		getMethod?( request?:Ext.data.IRequest ): string;
		/** [Method] Returns the value of password  
		* @returns String 
		*/
		getPassword?(): string;
		/** [Method] Returns the value of useDefaultXhrHeader  
		* @returns Boolean 
		*/
		getUseDefaultXhrHeader?(): boolean;
		/** [Method] Returns the value of username  
		* @returns String 
		*/
		getUsername?(): string;
		/** [Method] Returns the value of withCredentials  
		* @returns Boolean 
		*/
		getWithCredentials?(): boolean;
		/** [Method] Sets the value of headers  
		* @param headers Object The new value. 
		*/
		setHeaders?( headers?:any ): void;
		/** [Method] Sets the value of password  
		* @param password String The new value. 
		*/
		setPassword?( password?:string ): void;
		/** [Method] Sets the value of useDefaultXhrHeader  
		* @param useDefaultXhrHeader Boolean The new value. 
		*/
		setUseDefaultXhrHeader?( useDefaultXhrHeader?:boolean ): void;
		/** [Method] Sets the value of username  
		* @param username String The new value. 
		*/
		setUsername?( username?:string ): void;
		/** [Method] Sets the value of withCredentials  
		* @param withCredentials Boolean The new value. 
		*/
		setWithCredentials?( withCredentials?:boolean ): void;
	}
}
declare module Ext.data.proxy {
	export interface IClient extends Ext.data.proxy.IProxy {
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
	}
}
declare module Ext.proxy {
	export interface IClientProxy extends Ext.data.proxy.IProxy {
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
	}
}
declare module Ext.data.proxy {
	export interface IDirect extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (Function/String) */
		directFn?: any;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String/String[]) */
		paramOrder?: any;
		/** [Config Option] (Boolean) */
		paramsAsHash?: boolean;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @returns String The url 
		*/
		buildUrl?(): string;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		doRequest?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of api  
		* @returns Object 
		*/
		getApi?(): any;
		/** [Method] Returns the value of directFn  
		* @returns Function/String 
		*/
		getDirectFn?(): any;
		/** [Method] Returns the value of extraParams  
		* @returns Object 
		*/
		getExtraParams?(): any;
		/** [Method] Returns the value of paramOrder  
		* @returns String/String[] 
		*/
		getParamOrder?(): any;
		/** [Method] Returns the value of paramsAsHash  
		* @returns Boolean 
		*/
		getParamsAsHash?(): boolean;
		/** [Method] Sets the value of api  
		* @param api Object The new value. 
		*/
		setApi?( api?:any ): void;
		/** [Method] Sets the value of directFn  
		* @param directFn Function/String The new value. 
		*/
		setDirectFn?( directFn?:any ): void;
		/** [Method] Sets the value of extraParams  
		* @param extraParams Object The new value. 
		*/
		setExtraParams?( extraParams?:any ): void;
		/** [Method] Sets the value of paramOrder  
		* @param paramOrder String/String[] The new value. 
		*/
		setParamOrder?( paramOrder?:any ): void;
		/** [Method] Sets the value of paramsAsHash  
		* @param paramsAsHash Boolean The new value. 
		*/
		setParamsAsHash?( paramsAsHash?:boolean ): void;
	}
}
declare module Ext.data {
	export interface IDirectProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (Function/String) */
		directFn?: any;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String/String[]) */
		paramOrder?: any;
		/** [Config Option] (Boolean) */
		paramsAsHash?: boolean;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @returns String The url 
		*/
		buildUrl?(): string;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		doRequest?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of api  
		* @returns Object 
		*/
		getApi?(): any;
		/** [Method] Returns the value of directFn  
		* @returns Function/String 
		*/
		getDirectFn?(): any;
		/** [Method] Returns the value of extraParams  
		* @returns Object 
		*/
		getExtraParams?(): any;
		/** [Method] Returns the value of paramOrder  
		* @returns String/String[] 
		*/
		getParamOrder?(): any;
		/** [Method] Returns the value of paramsAsHash  
		* @returns Boolean 
		*/
		getParamsAsHash?(): boolean;
		/** [Method] Sets the value of api  
		* @param api Object The new value. 
		*/
		setApi?( api?:any ): void;
		/** [Method] Sets the value of directFn  
		* @param directFn Function/String The new value. 
		*/
		setDirectFn?( directFn?:any ): void;
		/** [Method] Sets the value of extraParams  
		* @param extraParams Object The new value. 
		*/
		setExtraParams?( extraParams?:any ): void;
		/** [Method] Sets the value of paramOrder  
		* @param paramOrder String/String[] The new value. 
		*/
		setParamOrder?( paramOrder?:any ): void;
		/** [Method] Sets the value of paramsAsHash  
		* @param paramsAsHash Boolean The new value. 
		*/
		setParamsAsHash?( paramsAsHash?:boolean ): void;
	}
}
declare module Ext.data.proxy {
	export interface IJsonP extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		autoAppendParams?: boolean;
		/** [Config Option] (String) */
		callbackKey?: string;
		/** [Config Option] (String) */
		recordParam?: string;
		/** [Method] Aborts the current server request if one is currently running  */
		abort?(): void;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object. 
		* @returns String The url. 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] Performs the given destroy operation  */
		destroy?(): void;
		/** [Method] Performs the read request to the remote domain  
		* @param operation Ext.data.Operation The Operation object to execute. 
		* @param callback Function A callback function to execute when the Operation has been completed. 
		* @param scope Object The scope to execute the callback in. 
		* @returns Object 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): any;
		/** [Method] Returns the value of autoAppendParams  
		* @returns Boolean 
		*/
		getAutoAppendParams?(): boolean;
		/** [Method] Returns the value of callbackKey  
		* @returns String 
		*/
		getCallbackKey?(): string;
		/** [Method] Returns the value of defaultWriterType  
		* @returns String 
		*/
		getDefaultWriterType?(): string;
		/** [Method] Returns the value of recordParam  
		* @returns String 
		*/
		getRecordParam?(): string;
		/** [Method] Sets the value of autoAppendParams  
		* @param autoAppendParams Boolean The new value. 
		*/
		setAutoAppendParams?( autoAppendParams?:boolean ): void;
		/** [Method] Sets the value of callbackKey  
		* @param callbackKey String The new value. 
		*/
		setCallbackKey?( callbackKey?:string ): void;
		/** [Method] Sets the value of defaultWriterType  
		* @param defaultWriterType String The new value. 
		*/
		setDefaultWriterType?( defaultWriterType?:string ): void;
		/** [Method] Sets the value of recordParam  
		* @param recordParam String The new value. 
		*/
		setRecordParam?( recordParam?:string ): void;
	}
}
declare module Ext.data {
	export interface IScriptTagProxy extends Ext.data.proxy.IServer {
		/** [Config Option] (Boolean) */
		autoAppendParams?: boolean;
		/** [Config Option] (String) */
		callbackKey?: string;
		/** [Config Option] (String) */
		recordParam?: string;
		/** [Method] Aborts the current server request if one is currently running  */
		abort?(): void;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object. 
		* @returns String The url. 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] Performs the given destroy operation  */
		destroy?(): void;
		/** [Method] Performs the read request to the remote domain  
		* @param operation Ext.data.Operation The Operation object to execute. 
		* @param callback Function A callback function to execute when the Operation has been completed. 
		* @param scope Object The scope to execute the callback in. 
		* @returns Object 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): any;
		/** [Method] Returns the value of autoAppendParams  
		* @returns Boolean 
		*/
		getAutoAppendParams?(): boolean;
		/** [Method] Returns the value of callbackKey  
		* @returns String 
		*/
		getCallbackKey?(): string;
		/** [Method] Returns the value of defaultWriterType  
		* @returns String 
		*/
		getDefaultWriterType?(): string;
		/** [Method] Returns the value of recordParam  
		* @returns String 
		*/
		getRecordParam?(): string;
		/** [Method] Sets the value of autoAppendParams  
		* @param autoAppendParams Boolean The new value. 
		*/
		setAutoAppendParams?( autoAppendParams?:boolean ): void;
		/** [Method] Sets the value of callbackKey  
		* @param callbackKey String The new value. 
		*/
		setCallbackKey?( callbackKey?:string ): void;
		/** [Method] Sets the value of defaultWriterType  
		* @param defaultWriterType String The new value. 
		*/
		setDefaultWriterType?( defaultWriterType?:string ): void;
		/** [Method] Sets the value of recordParam  
		* @param recordParam String The new value. 
		*/
		setRecordParam?( recordParam?:string ): void;
	}
}
declare module Ext.data.proxy {
	export interface ILocalStorage extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data {
	export interface ILocalStorageProxy extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data.proxy {
	export interface IMemory extends Ext.data.proxy.IClient {
		/** [Config Option] (Object) */
		data?: any;
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of data  
		* @returns Object 
		*/
		getData?(): any;
		/** [Method] Reads data from the configured data object  
		* @param operation Ext.data.Operation The read Operation 
		* @param callback Function The callback to call when reading has completed 
		* @param scope Object The scope to call the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of data  
		* @param data Object The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IMemoryProxy extends Ext.data.proxy.IClient {
		/** [Config Option] (Object) */
		data?: any;
		/** [Method] Abstract function that must be implemented by each ClientProxy subclass  */
		clear?(): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of data  
		* @returns Object 
		*/
		getData?(): any;
		/** [Method] Reads data from the configured data object  
		* @param operation Ext.data.Operation The read Operation 
		* @param callback Function The callback to call when reading has completed 
		* @param scope Object The scope to call the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of data  
		* @param data Object The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Currently this is a hard coded method that simply commits any records and sets the operation to successful then call  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.proxy {
	export interface IProxy extends Ext.IEvented {
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		batchOrder?: string;
		/** [Config Option] (String/Ext.data.Model) */
		model?: any;
		/** [Config Option] (Object/String/Ext.data.reader.Reader) */
		reader?: any;
		/** [Config Option] (Object/String/Ext.data.writer.Writer) */
		writer?: any;
		/** [Method] Performs a batch of Operations in the order specified by batchOrder  
		* @param options Object Object containing one or more properties supported by the batch method: 
		* @returns Ext.data.Batch The newly created Batch 
		*/
		batch?( options?:any ): Ext.data.IBatch;
		/** [Method] Performs the given create operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of batchActions  
		* @returns Boolean 
		*/
		getBatchActions?(): boolean;
		/** [Method] Returns the value of batchOrder  
		* @returns String 
		*/
		getBatchOrder?(): string;
		/** [Method] Returns the value of model  
		* @returns String/Ext.data.Model 
		*/
		getModel?(): any;
		/** [Method] Returns the value of reader  
		* @returns Object/String/Ext.data.reader.Reader 
		*/
		getReader?(): any;
		/** [Method] Returns the value of writer  
		* @returns Object/String/Ext.data.writer.Writer 
		*/
		getWriter?(): any;
		/** [Method] Performs the given read operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of batchActions  
		* @param batchActions Boolean The new value. 
		*/
		setBatchActions?( batchActions?:boolean ): void;
		/** [Method] Sets the value of batchOrder  
		* @param batchOrder String The new value. 
		*/
		setBatchOrder?( batchOrder?:string ): void;
		/** [Method] Sets the value of model  
		* @param model String/Ext.data.Model The new value. 
		*/
		setModel?( model?:any ): void;
		/** [Method] Sets the value of reader  
		* @param reader Object/String/Ext.data.reader.Reader The new value. 
		*/
		setReader?( reader?:any ): void;
		/** [Method] Sets the value of writer  
		* @param writer Object/String/Ext.data.writer.Writer The new value. 
		*/
		setWriter?( writer?:any ): void;
		/** [Method] Performs the given update operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IDataProxy extends Ext.IEvented {
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		batchOrder?: string;
		/** [Config Option] (String/Ext.data.Model) */
		model?: any;
		/** [Config Option] (Object/String/Ext.data.reader.Reader) */
		reader?: any;
		/** [Config Option] (Object/String/Ext.data.writer.Writer) */
		writer?: any;
		/** [Method] Performs a batch of Operations in the order specified by batchOrder  
		* @param options Object Object containing one or more properties supported by the batch method: 
		* @returns Ext.data.Batch The newly created Batch 
		*/
		batch?( options?:any ): Ext.data.IBatch;
		/** [Method] Performs the given create operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of batchActions  
		* @returns Boolean 
		*/
		getBatchActions?(): boolean;
		/** [Method] Returns the value of batchOrder  
		* @returns String 
		*/
		getBatchOrder?(): string;
		/** [Method] Returns the value of model  
		* @returns String/Ext.data.Model 
		*/
		getModel?(): any;
		/** [Method] Returns the value of reader  
		* @returns Object/String/Ext.data.reader.Reader 
		*/
		getReader?(): any;
		/** [Method] Returns the value of writer  
		* @returns Object/String/Ext.data.writer.Writer 
		*/
		getWriter?(): any;
		/** [Method] Performs the given read operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of batchActions  
		* @param batchActions Boolean The new value. 
		*/
		setBatchActions?( batchActions?:boolean ): void;
		/** [Method] Sets the value of batchOrder  
		* @param batchOrder String The new value. 
		*/
		setBatchOrder?( batchOrder?:string ): void;
		/** [Method] Sets the value of model  
		* @param model String/Ext.data.Model The new value. 
		*/
		setModel?( model?:any ): void;
		/** [Method] Sets the value of reader  
		* @param reader Object/String/Ext.data.reader.Reader The new value. 
		*/
		setReader?( reader?:any ): void;
		/** [Method] Sets the value of writer  
		* @param writer Object/String/Ext.data.writer.Writer The new value. 
		*/
		setWriter?( writer?:any ): void;
		/** [Method] Performs the given update operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IProxy extends Ext.IEvented {
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		batchOrder?: string;
		/** [Config Option] (String/Ext.data.Model) */
		model?: any;
		/** [Config Option] (Object/String/Ext.data.reader.Reader) */
		reader?: any;
		/** [Config Option] (Object/String/Ext.data.writer.Writer) */
		writer?: any;
		/** [Method] Performs a batch of Operations in the order specified by batchOrder  
		* @param options Object Object containing one or more properties supported by the batch method: 
		* @returns Ext.data.Batch The newly created Batch 
		*/
		batch?( options?:any ): Ext.data.IBatch;
		/** [Method] Performs the given create operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		create?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		destroy?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of batchActions  
		* @returns Boolean 
		*/
		getBatchActions?(): boolean;
		/** [Method] Returns the value of batchOrder  
		* @returns String 
		*/
		getBatchOrder?(): string;
		/** [Method] Returns the value of model  
		* @returns String/Ext.data.Model 
		*/
		getModel?(): any;
		/** [Method] Returns the value of reader  
		* @returns Object/String/Ext.data.reader.Reader 
		*/
		getReader?(): any;
		/** [Method] Returns the value of writer  
		* @returns Object/String/Ext.data.writer.Writer 
		*/
		getWriter?(): any;
		/** [Method] Performs the given read operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		read?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of batchActions  
		* @param batchActions Boolean The new value. 
		*/
		setBatchActions?( batchActions?:boolean ): void;
		/** [Method] Sets the value of batchOrder  
		* @param batchOrder String The new value. 
		*/
		setBatchOrder?( batchOrder?:string ): void;
		/** [Method] Sets the value of model  
		* @param model String/Ext.data.Model The new value. 
		*/
		setModel?( model?:any ): void;
		/** [Method] Sets the value of reader  
		* @param reader Object/String/Ext.data.reader.Reader The new value. 
		*/
		setReader?( reader?:any ): void;
		/** [Method] Sets the value of writer  
		* @param writer Object/String/Ext.data.writer.Writer The new value. 
		*/
		setWriter?( writer?:any ): void;
		/** [Method] Performs the given update operation  
		* @param operation Ext.data.Operation The Operation to perform 
		* @param callback Function Callback function to be called when the Operation has completed (whether successful or not) 
		* @param scope Object Scope to execute the callback function in 
		*/
		update?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.proxy {
	export interface IRest extends Ext.data.proxy.IAjax {
		/** [Config Option] (Boolean) */
		appendId?: boolean;
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		format?: string;
		/** [Method] Returns the value of actionMethods  
		* @returns Object 
		*/
		getActionMethods?(): any;
		/** [Method] Returns the value of appendId  
		* @returns Boolean 
		*/
		getAppendId?(): boolean;
		/** [Method] Returns the value of batchActions  
		* @returns Boolean 
		*/
		getBatchActions?(): boolean;
		/** [Method] Returns the value of format  
		* @returns String 
		*/
		getFormat?(): string;
		/** [Method] Sets the value of actionMethods  
		* @param actionMethods Object The new value. 
		*/
		setActionMethods?( actionMethods?:any ): void;
		/** [Method] Sets the value of appendId  
		* @param appendId Boolean The new value. 
		*/
		setAppendId?( appendId?:boolean ): void;
		/** [Method] Sets the value of batchActions  
		* @param batchActions Boolean The new value. 
		*/
		setBatchActions?( batchActions?:boolean ): void;
		/** [Method] Sets the value of format  
		* @param format String The new value. 
		*/
		setFormat?( format?:string ): void;
	}
}
declare module Ext.data {
	export interface IRestProxy extends Ext.data.proxy.IAjax {
		/** [Config Option] (Boolean) */
		appendId?: boolean;
		/** [Config Option] (Boolean) */
		batchActions?: boolean;
		/** [Config Option] (String) */
		format?: string;
		/** [Method] Returns the value of actionMethods  
		* @returns Object 
		*/
		getActionMethods?(): any;
		/** [Method] Returns the value of appendId  
		* @returns Boolean 
		*/
		getAppendId?(): boolean;
		/** [Method] Returns the value of batchActions  
		* @returns Boolean 
		*/
		getBatchActions?(): boolean;
		/** [Method] Returns the value of format  
		* @returns String 
		*/
		getFormat?(): string;
		/** [Method] Sets the value of actionMethods  
		* @param actionMethods Object The new value. 
		*/
		setActionMethods?( actionMethods?:any ): void;
		/** [Method] Sets the value of appendId  
		* @param appendId Boolean The new value. 
		*/
		setAppendId?( appendId?:boolean ): void;
		/** [Method] Sets the value of batchActions  
		* @param batchActions Boolean The new value. 
		*/
		setBatchActions?( batchActions?:boolean ): void;
		/** [Method] Sets the value of format  
		* @param format String The new value. 
		*/
		setFormat?( format?:string ): void;
	}
}
declare module Ext.data.proxy {
	export interface IServer extends Ext.data.proxy.IProxy {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (String) */
		cacheString?: string;
		/** [Config Option] (String) */
		directionParam?: string;
		/** [Config Option] (Boolean) */
		enablePagingParams?: boolean;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String) */
		filterParam?: string;
		/** [Config Option] (String) */
		groupParam?: string;
		/** [Config Option] (String) */
		limitParam?: string;
		/** [Config Option] (Boolean) */
		noCache?: boolean;
		/** [Config Option] (String) */
		pageParam?: string;
		/** [Config Option] (Boolean) */
		simpleSortMode?: boolean;
		/** [Config Option] (String) */
		sortParam?: string;
		/** [Config Option] (String) */
		startParam?: string;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Optional callback function which can be used to clean up after a request has been completed  
		* @param request Ext.data.Request The Request object 
		* @param success Boolean True if the request was successful 
		*/
		afterRequest?( request?:Ext.data.IRequest, success?:boolean ): void;
		/** [Method] Creates and returns an Ext data Request object based on the options passed by the Store that this Proxy is attached to  
		* @param operation Ext.data.Operation The Operation object to execute 
		* @returns Ext.data.Request The request object 
		*/
		buildRequest?( operation?:Ext.data.IOperation ): Ext.data.IRequest;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object 
		* @returns String The url 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] in a ServerProxy all four CRUD operations are executed in the same manner so we delegate to doRequest in each case */
		create?(): void;
		/** [Method] Performs the given destroy operation  */
		destroy?(): void;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Ext.data.Operation The Ext.data.Operation object 
		* @param callback Function The callback function to call when the Operation has completed 
		* @param scope Object The scope in which to execute the callback 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Encodes the array of Ext util Filter objects into a string to be sent in the request url  
		* @param filters Ext.util.Filter[] The array of Filter objects 
		* @returns String The encoded filters 
		*/
		encodeFilters?( filters?:Ext.util.IFilter[] ): string;
		/** [Method] Encodes the array of Ext util Sorter objects into a string to be sent in the request url  
		* @param sorters Ext.util.Sorter[] The array of Sorter objects 
		* @returns String The encoded sorters 
		*/
		encodeSorters?( sorters?:Ext.util.ISorter[] ): string;
		/** [Method] Returns the value of api  
		* @returns Object 
		*/
		getApi?(): any;
		/** [Method] Returns the value of cacheString  
		* @returns String 
		*/
		getCacheString?(): string;
		/** [Method] Returns the value of directionParam  
		* @returns String 
		*/
		getDirectionParam?(): string;
		/** [Method] Returns the value of enablePagingParams  
		* @returns Boolean 
		*/
		getEnablePagingParams?(): boolean;
		/** [Method] Returns the value of extraParams  
		* @returns Object 
		*/
		getExtraParams?(): any;
		/** [Method] Returns the value of filterParam  
		* @returns String 
		*/
		getFilterParam?(): string;
		/** [Method] Returns the value of groupParam  
		* @returns String 
		*/
		getGroupParam?(): string;
		/** [Method] Returns the value of limitParam  
		* @returns String 
		*/
		getLimitParam?(): string;
		/** [Method] Returns the value of noCache  
		* @returns Boolean 
		*/
		getNoCache?(): boolean;
		/** [Method] Returns the value of pageParam  
		* @returns String 
		*/
		getPageParam?(): string;
		/** [Method] Returns the value of simpleSortMode  
		* @returns Boolean 
		*/
		getSimpleSortMode?(): boolean;
		/** [Method] Returns the value of sortParam  
		* @returns String 
		*/
		getSortParam?(): string;
		/** [Method] Returns the value of startParam  
		* @returns String 
		*/
		getStartParam?(): string;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		getTimeout?(): number;
		/** [Method] This method handles the processing of the response and is usually overridden by subclasses to do additional processing  
		* @param success Boolean Whether or not this request was successful 
		* @param operation Ext.data.Operation The operation we made this request for 
		* @param request Ext.data.Request The request that was made 
		* @param response Object The response that we got 
		* @param callback Function The callback to be fired onces the response is processed 
		* @param scope Object The scope in which we call the callback 
		*/
		processResponse?( success?:boolean, operation?:Ext.data.IOperation, request?:Ext.data.IRequest, response?:any, callback?:any, scope?:any ): void;
		/** [Method] Performs the given read operation  */
		read?(): void;
		/** [Method] Sets the value of api  
		* @param api Object The new value. 
		*/
		setApi?( api?:any ): void;
		/** [Method] Sets the value of cacheString  
		* @param cacheString String The new value. 
		*/
		setCacheString?( cacheString?:string ): void;
		/** [Method] Sets the value of directionParam  
		* @param directionParam String The new value. 
		*/
		setDirectionParam?( directionParam?:string ): void;
		/** [Method] Sets the value of enablePagingParams  
		* @param enablePagingParams Boolean The new value. 
		*/
		setEnablePagingParams?( enablePagingParams?:boolean ): void;
		/** [Method] Sets a value in the underlying extraParams  
		* @param name String The key for the new value 
		* @param value Object The value 
		*/
		setExtraParam?( name?:string, value?:any ): void;
		/** [Method] Sets the value of extraParams  
		* @param extraParams Object The new value. 
		*/
		setExtraParams?( extraParams?:any ): void;
		/** [Method] Sets the value of filterParam  
		* @param filterParam String The new value. 
		*/
		setFilterParam?( filterParam?:string ): void;
		/** [Method] Sets the value of groupParam  
		* @param groupParam String The new value. 
		*/
		setGroupParam?( groupParam?:string ): void;
		/** [Method] Sets the value of limitParam  
		* @param limitParam String The new value. 
		*/
		setLimitParam?( limitParam?:string ): void;
		/** [Method] Sets the value of noCache  
		* @param noCache Boolean The new value. 
		*/
		setNoCache?( noCache?:boolean ): void;
		/** [Method] Sets the value of pageParam  
		* @param pageParam String The new value. 
		*/
		setPageParam?( pageParam?:string ): void;
		/** [Method] Sets the value of simpleSortMode  
		* @param simpleSortMode Boolean The new value. 
		*/
		setSimpleSortMode?( simpleSortMode?:boolean ): void;
		/** [Method] Sets the value of sortParam  
		* @param sortParam String The new value. 
		*/
		setSortParam?( sortParam?:string ): void;
		/** [Method] Sets the value of startParam  
		* @param startParam String The new value. 
		*/
		setStartParam?( startParam?:string ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		setTimeout?( timeout?:number ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
		/** [Method] Performs the given update operation  */
		update?(): void;
	}
}
declare module Ext.data {
	export interface IServerProxy extends Ext.data.proxy.IProxy {
		/** [Config Option] (Object) */
		api?: any;
		/** [Config Option] (String) */
		cacheString?: string;
		/** [Config Option] (String) */
		directionParam?: string;
		/** [Config Option] (Boolean) */
		enablePagingParams?: boolean;
		/** [Config Option] (Object) */
		extraParams?: any;
		/** [Config Option] (String) */
		filterParam?: string;
		/** [Config Option] (String) */
		groupParam?: string;
		/** [Config Option] (String) */
		limitParam?: string;
		/** [Config Option] (Boolean) */
		noCache?: boolean;
		/** [Config Option] (String) */
		pageParam?: string;
		/** [Config Option] (Boolean) */
		simpleSortMode?: boolean;
		/** [Config Option] (String) */
		sortParam?: string;
		/** [Config Option] (String) */
		startParam?: string;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Config Option] (String) */
		url?: string;
		/** [Method] Optional callback function which can be used to clean up after a request has been completed  
		* @param request Ext.data.Request The Request object 
		* @param success Boolean True if the request was successful 
		*/
		afterRequest?( request?:Ext.data.IRequest, success?:boolean ): void;
		/** [Method] Creates and returns an Ext data Request object based on the options passed by the Store that this Proxy is attached to  
		* @param operation Ext.data.Operation The Operation object to execute 
		* @returns Ext.data.Request The request object 
		*/
		buildRequest?( operation?:Ext.data.IOperation ): Ext.data.IRequest;
		/** [Method] Generates a url based on a given Ext data Request object  
		* @param request Ext.data.Request The request object 
		* @returns String The url 
		*/
		buildUrl?( request?:Ext.data.IRequest ): string;
		/** [Method] in a ServerProxy all four CRUD operations are executed in the same manner so we delegate to doRequest in each case */
		create?(): void;
		/** [Method] Performs the given destroy operation  */
		destroy?(): void;
		/** [Method] In ServerProxy subclasses the create read update and destroy methods all pass through to doRequest  
		* @param operation Ext.data.Operation The Ext.data.Operation object 
		* @param callback Function The callback function to call when the Operation has completed 
		* @param scope Object The scope in which to execute the callback 
		*/
		doRequest?( operation?:Ext.data.IOperation, callback?:any, scope?:any ): void;
		/** [Method] Encodes the array of Ext util Filter objects into a string to be sent in the request url  
		* @param filters Ext.util.Filter[] The array of Filter objects 
		* @returns String The encoded filters 
		*/
		encodeFilters?( filters?:Ext.util.IFilter[] ): string;
		/** [Method] Encodes the array of Ext util Sorter objects into a string to be sent in the request url  
		* @param sorters Ext.util.Sorter[] The array of Sorter objects 
		* @returns String The encoded sorters 
		*/
		encodeSorters?( sorters?:Ext.util.ISorter[] ): string;
		/** [Method] Returns the value of api  
		* @returns Object 
		*/
		getApi?(): any;
		/** [Method] Returns the value of cacheString  
		* @returns String 
		*/
		getCacheString?(): string;
		/** [Method] Returns the value of directionParam  
		* @returns String 
		*/
		getDirectionParam?(): string;
		/** [Method] Returns the value of enablePagingParams  
		* @returns Boolean 
		*/
		getEnablePagingParams?(): boolean;
		/** [Method] Returns the value of extraParams  
		* @returns Object 
		*/
		getExtraParams?(): any;
		/** [Method] Returns the value of filterParam  
		* @returns String 
		*/
		getFilterParam?(): string;
		/** [Method] Returns the value of groupParam  
		* @returns String 
		*/
		getGroupParam?(): string;
		/** [Method] Returns the value of limitParam  
		* @returns String 
		*/
		getLimitParam?(): string;
		/** [Method] Returns the value of noCache  
		* @returns Boolean 
		*/
		getNoCache?(): boolean;
		/** [Method] Returns the value of pageParam  
		* @returns String 
		*/
		getPageParam?(): string;
		/** [Method] Returns the value of simpleSortMode  
		* @returns Boolean 
		*/
		getSimpleSortMode?(): boolean;
		/** [Method] Returns the value of sortParam  
		* @returns String 
		*/
		getSortParam?(): string;
		/** [Method] Returns the value of startParam  
		* @returns String 
		*/
		getStartParam?(): string;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		getTimeout?(): number;
		/** [Method] This method handles the processing of the response and is usually overridden by subclasses to do additional processing  
		* @param success Boolean Whether or not this request was successful 
		* @param operation Ext.data.Operation The operation we made this request for 
		* @param request Ext.data.Request The request that was made 
		* @param response Object The response that we got 
		* @param callback Function The callback to be fired onces the response is processed 
		* @param scope Object The scope in which we call the callback 
		*/
		processResponse?( success?:boolean, operation?:Ext.data.IOperation, request?:Ext.data.IRequest, response?:any, callback?:any, scope?:any ): void;
		/** [Method] Performs the given read operation  */
		read?(): void;
		/** [Method] Sets the value of api  
		* @param api Object The new value. 
		*/
		setApi?( api?:any ): void;
		/** [Method] Sets the value of cacheString  
		* @param cacheString String The new value. 
		*/
		setCacheString?( cacheString?:string ): void;
		/** [Method] Sets the value of directionParam  
		* @param directionParam String The new value. 
		*/
		setDirectionParam?( directionParam?:string ): void;
		/** [Method] Sets the value of enablePagingParams  
		* @param enablePagingParams Boolean The new value. 
		*/
		setEnablePagingParams?( enablePagingParams?:boolean ): void;
		/** [Method] Sets a value in the underlying extraParams  
		* @param name String The key for the new value 
		* @param value Object The value 
		*/
		setExtraParam?( name?:string, value?:any ): void;
		/** [Method] Sets the value of extraParams  
		* @param extraParams Object The new value. 
		*/
		setExtraParams?( extraParams?:any ): void;
		/** [Method] Sets the value of filterParam  
		* @param filterParam String The new value. 
		*/
		setFilterParam?( filterParam?:string ): void;
		/** [Method] Sets the value of groupParam  
		* @param groupParam String The new value. 
		*/
		setGroupParam?( groupParam?:string ): void;
		/** [Method] Sets the value of limitParam  
		* @param limitParam String The new value. 
		*/
		setLimitParam?( limitParam?:string ): void;
		/** [Method] Sets the value of noCache  
		* @param noCache Boolean The new value. 
		*/
		setNoCache?( noCache?:boolean ): void;
		/** [Method] Sets the value of pageParam  
		* @param pageParam String The new value. 
		*/
		setPageParam?( pageParam?:string ): void;
		/** [Method] Sets the value of simpleSortMode  
		* @param simpleSortMode Boolean The new value. 
		*/
		setSimpleSortMode?( simpleSortMode?:boolean ): void;
		/** [Method] Sets the value of sortParam  
		* @param sortParam String The new value. 
		*/
		setSortParam?( sortParam?:string ): void;
		/** [Method] Sets the value of startParam  
		* @param startParam String The new value. 
		*/
		setStartParam?( startParam?:string ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		setTimeout?( timeout?:number ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
		/** [Method] Performs the given update operation  */
		update?(): void;
	}
}
declare module Ext.data.proxy {
	export interface ISessionStorage extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data {
	export interface ISessionStorageProxy extends Ext.data.proxy.IWebStorage {
	}
}
declare module Ext.data.proxy {
	export interface ISql extends Ext.data.proxy.IClient {
		/** [Config Option] (String) */
		database?: string;
		/** [Config Option] (String) */
		table?: string;
		/** [Method] Performs the given create operation  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		create?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Performs the given destroy operation  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		destroy?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of columns  
		* @returns String 
		*/
		getColumns?(): string;
		/** [Method] Returns the value of database  
		* @returns String 
		*/
		getDatabase?(): string;
		/** [Method] Returns the value of defaultDateFormat  
		* @returns String 
		*/
		getDefaultDateFormat?(): string;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Object The record that we are writing to the server. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:any ): any;
		/** [Method] Returns the value of table  
		* @returns String 
		*/
		getTable?(): string;
		/** [Method] Returns the value of tableExists  
		* @returns Boolean 
		*/
		getTableExists?(): boolean;
		/** [Method] Returns the value of uniqueIdStrategy  
		* @returns Boolean 
		*/
		getUniqueIdStrategy?(): boolean;
		/** [Method] Performs the given read operation  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		read?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of columns  
		* @param columns String The new value. 
		*/
		setColumns?( columns?:string ): void;
		/** [Method] Sets the value of database  
		* @param database String The new value. 
		*/
		setDatabase?( database?:string ): void;
		/** [Method] Sets the value of defaultDateFormat  
		* @param defaultDateFormat String The new value. 
		*/
		setDefaultDateFormat?( defaultDateFormat?:string ): void;
		/** [Method] Sets the value of table  
		* @param table String The new value. 
		*/
		setTable?( table?:string ): void;
		/** [Method] Sets the value of tableExists  
		* @param tableExists Boolean The new value. 
		*/
		setTableExists?( tableExists?:boolean ): void;
		/** [Method] Sets the value of uniqueIdStrategy  
		* @param uniqueIdStrategy Boolean The new value. 
		*/
		setUniqueIdStrategy?( uniqueIdStrategy?:boolean ): void;
		/** [Method] Performs the given update operation  
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		update?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.proxy {
	export interface IWebStorage extends Ext.data.proxy.IClient {
		/** [Config Option] (Boolean) */
		enablePagingParams?: boolean;
		/** [Config Option] (String) */
		id?: string;
		/** [Property] (Object) */
		cache?: any;
		/** [Method] Destroys all records stored in the proxy and removes all keys and values used to support the proxy from the storage o  */
		clear?(): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		create?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] inherit 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		destroy?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of defaultDateFormat  
		* @returns String 
		*/
		getDefaultDateFormat?(): string;
		/** [Method] Returns the value of enablePagingParams  
		* @returns Boolean 
		*/
		getEnablePagingParams?(): boolean;
		/** [Method] Returns the value of id  
		* @returns String 
		*/
		getId?(): string;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		read?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of defaultDateFormat  
		* @param defaultDateFormat String The new value. 
		*/
		setDefaultDateFormat?( defaultDateFormat?:string ): void;
		/** [Method] Sets the value of enablePagingParams  
		* @param enablePagingParams Boolean The new value. 
		*/
		setEnablePagingParams?( enablePagingParams?:boolean ): void;
		/** [Method] Sets the value of id  
		* @param id String The new value. 
		*/
		setId?( id?:string ): void;
		/** [Method] Saves the given record in the Proxy  
		* @param record Ext.data.Model The model instance 
		* @param id String The id to save the record under (defaults to the value of the record's getId() function) 
		*/
		setRecord?( record?:Ext.data.IModel, id?:string ): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		update?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data {
	export interface IWebStorageProxy extends Ext.data.proxy.IClient {
		/** [Config Option] (Boolean) */
		enablePagingParams?: boolean;
		/** [Config Option] (String) */
		id?: string;
		/** [Property] (Object) */
		cache?: any;
		/** [Method] Destroys all records stored in the proxy and removes all keys and values used to support the proxy from the storage o  */
		clear?(): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		create?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] inherit 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		destroy?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Returns the value of defaultDateFormat  
		* @returns String 
		*/
		getDefaultDateFormat?(): string;
		/** [Method] Returns the value of enablePagingParams  
		* @returns Boolean 
		*/
		getEnablePagingParams?(): boolean;
		/** [Method] Returns the value of id  
		* @returns String 
		*/
		getId?(): string;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		read?( operation?:any, callback?:any, scope?:any ): void;
		/** [Method] Sets the value of defaultDateFormat  
		* @param defaultDateFormat String The new value. 
		*/
		setDefaultDateFormat?( defaultDateFormat?:string ): void;
		/** [Method] Sets the value of enablePagingParams  
		* @param enablePagingParams Boolean The new value. 
		*/
		setEnablePagingParams?( enablePagingParams?:boolean ): void;
		/** [Method] Sets the value of id  
		* @param id String The new value. 
		*/
		setId?( id?:string ): void;
		/** [Method] Saves the given record in the Proxy  
		* @param record Ext.data.Model The model instance 
		* @param id String The id to save the record under (defaults to the value of the record's getId() function) 
		*/
		setRecord?( record?:Ext.data.IModel, id?:string ): void;
		/** [Method] inherit docs 
		* @param operation Object 
		* @param callback Object 
		* @param scope Object 
		*/
		update?( operation?:any, callback?:any, scope?:any ): void;
	}
}
declare module Ext.data.reader {
	export interface IArray extends Ext.data.reader.IJson {
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Method] Returns the value of successProperty  
		* @returns Object 
		*/
		getSuccessProperty?(): any;
		/** [Method] Returns the value of totalProperty  
		* @returns Object 
		*/
		getTotalProperty?(): any;
		/** [Method] Sets the value of successProperty  
		* @param successProperty Object The new value. 
		*/
		setSuccessProperty?( successProperty?:any ): void;
		/** [Method] Sets the value of totalProperty  
		* @param totalProperty Object The new value. 
		*/
		setTotalProperty?( totalProperty?:any ): void;
	}
}
declare module Ext.data {
	export interface IArrayReader extends Ext.data.reader.IJson {
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Method] Returns the value of successProperty  
		* @returns Object 
		*/
		getSuccessProperty?(): any;
		/** [Method] Returns the value of totalProperty  
		* @returns Object 
		*/
		getTotalProperty?(): any;
		/** [Method] Sets the value of successProperty  
		* @param successProperty Object The new value. 
		*/
		setSuccessProperty?( successProperty?:any ): void;
		/** [Method] Sets the value of totalProperty  
		* @param totalProperty Object The new value. 
		*/
		setTotalProperty?( totalProperty?:any ): void;
	}
}
declare module Ext.data.reader {
	export interface IJson extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		record?: string;
		/** [Config Option] (Boolean) */
		useSimpleAccessors?: boolean;
		/** [Method] Returns the value of record  
		* @returns String 
		*/
		getRecord?(): string;
		/** [Method] Takes a raw response object as passed to this read and returns the useful data segment of it  
		* @param response Object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Returns the value of useSimpleAccessors  
		* @returns Boolean 
		*/
		getUseSimpleAccessors?(): boolean;
		/** [Method] Sets the value of record  
		* @param record String The new value. 
		*/
		setRecord?( record?:string ): void;
		/** [Method] Sets the value of useSimpleAccessors  
		* @param useSimpleAccessors Boolean The new value. 
		*/
		setUseSimpleAccessors?( useSimpleAccessors?:boolean ): void;
	}
}
declare module Ext.data {
	export interface IJsonReader extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		record?: string;
		/** [Config Option] (Boolean) */
		useSimpleAccessors?: boolean;
		/** [Method] Returns the value of record  
		* @returns String 
		*/
		getRecord?(): string;
		/** [Method] Takes a raw response object as passed to this read and returns the useful data segment of it  
		* @param response Object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Returns the value of useSimpleAccessors  
		* @returns Boolean 
		*/
		getUseSimpleAccessors?(): boolean;
		/** [Method] Sets the value of record  
		* @param record String The new value. 
		*/
		setRecord?( record?:string ): void;
		/** [Method] Sets the value of useSimpleAccessors  
		* @param useSimpleAccessors Boolean The new value. 
		*/
		setUseSimpleAccessors?( useSimpleAccessors?:boolean ): void;
	}
}
declare module Ext.data.reader {
	export interface IReader extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Boolean) */
		implicitIncludes?: boolean;
		/** [Config Option] (String) */
		messageProperty?: string;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		rootProperty?: string;
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Property] (Object) */
		metaData?: any;
		/** [Property] (Object) */
		rawData?: any;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of clientIdProperty  
		* @returns String 
		*/
		getClientIdProperty?(): string;
		/** [Method] Returns the value of idProperty  
		* @returns String 
		*/
		getIdProperty?(): string;
		/** [Method] Returns the value of implicitIncludes  
		* @returns Boolean 
		*/
		getImplicitIncludes?(): boolean;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of messageProperty  
		* @returns String 
		*/
		getMessageProperty?(): string;
		/** [Method] Returns the value of model  
		* @returns Object 
		*/
		getModel?(): any;
		/** [Method] Takes a raw response object as passed to this read and returns the useful data segment of it  
		* @param response Object The response object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Returns the value of rootProperty  
		* @returns String 
		*/
		getRootProperty?(): string;
		/** [Method] Returns the value of successProperty  
		* @returns any 
		*/
		getSuccessProperty?(): any;
		/** [Method] Returns the value of totalProperty  
		* @returns any 
		*/
		getTotalProperty?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Reads the given response object  
		* @param response Object The response object. This may be either an XMLHttpRequest object or a plain JS object 
		* @returns Ext.data.ResultSet The parsed ResultSet object 
		*/
		read?( response?:any ): Ext.data.IResultSet;
		/** [Method] Abstracts common functionality used by all Reader subclasses  
		* @param data Object The raw data object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of clientIdProperty  
		* @param clientIdProperty String The new value. 
		*/
		setClientIdProperty?( clientIdProperty?:string ): void;
		/** [Method] Sets the value of idProperty  
		* @param idProperty String The new value. 
		*/
		setIdProperty?( idProperty?:string ): void;
		/** [Method] Sets the value of implicitIncludes  
		* @param implicitIncludes Boolean The new value. 
		*/
		setImplicitIncludes?( implicitIncludes?:boolean ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of messageProperty  
		* @param messageProperty String The new value. 
		*/
		setMessageProperty?( messageProperty?:string ): void;
		/** [Method] Sets the value of model  
		* @param model Object The new value. 
		*/
		setModel?( model?:any ): void;
		/** [Method] Sets the value of rootProperty  
		* @param rootProperty String The new value. 
		*/
		setRootProperty?( rootProperty?:string ): void;
		/** [Method] Sets the value of successProperty  
		* @param successProperty String The new value. 
		*/
		setSuccessProperty?( successProperty?:string ): void;
		/** [Method] Sets the value of totalProperty  
		* @param totalProperty String The new value. 
		*/
		setTotalProperty?( totalProperty?:string ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.data {
	export interface IReader extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Boolean) */
		implicitIncludes?: boolean;
		/** [Config Option] (String) */
		messageProperty?: string;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		rootProperty?: string;
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Property] (Object) */
		metaData?: any;
		/** [Property] (Object) */
		rawData?: any;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of clientIdProperty  
		* @returns String 
		*/
		getClientIdProperty?(): string;
		/** [Method] Returns the value of idProperty  
		* @returns String 
		*/
		getIdProperty?(): string;
		/** [Method] Returns the value of implicitIncludes  
		* @returns Boolean 
		*/
		getImplicitIncludes?(): boolean;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of messageProperty  
		* @returns String 
		*/
		getMessageProperty?(): string;
		/** [Method] Returns the value of model  
		* @returns Object 
		*/
		getModel?(): any;
		/** [Method] Takes a raw response object as passed to this read and returns the useful data segment of it  
		* @param response Object The response object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Returns the value of rootProperty  
		* @returns String 
		*/
		getRootProperty?(): string;
		/** [Method] Returns the value of successProperty  
		* @returns any 
		*/
		getSuccessProperty?(): any;
		/** [Method] Returns the value of totalProperty  
		* @returns any 
		*/
		getTotalProperty?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Reads the given response object  
		* @param response Object The response object. This may be either an XMLHttpRequest object or a plain JS object 
		* @returns Ext.data.ResultSet The parsed ResultSet object 
		*/
		read?( response?:any ): Ext.data.IResultSet;
		/** [Method] Abstracts common functionality used by all Reader subclasses  
		* @param data Object The raw data object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of clientIdProperty  
		* @param clientIdProperty String The new value. 
		*/
		setClientIdProperty?( clientIdProperty?:string ): void;
		/** [Method] Sets the value of idProperty  
		* @param idProperty String The new value. 
		*/
		setIdProperty?( idProperty?:string ): void;
		/** [Method] Sets the value of implicitIncludes  
		* @param implicitIncludes Boolean The new value. 
		*/
		setImplicitIncludes?( implicitIncludes?:boolean ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of messageProperty  
		* @param messageProperty String The new value. 
		*/
		setMessageProperty?( messageProperty?:string ): void;
		/** [Method] Sets the value of model  
		* @param model Object The new value. 
		*/
		setModel?( model?:any ): void;
		/** [Method] Sets the value of rootProperty  
		* @param rootProperty String The new value. 
		*/
		setRootProperty?( rootProperty?:string ): void;
		/** [Method] Sets the value of successProperty  
		* @param successProperty String The new value. 
		*/
		setSuccessProperty?( successProperty?:string ): void;
		/** [Method] Sets the value of totalProperty  
		* @param totalProperty String The new value. 
		*/
		setTotalProperty?( totalProperty?:string ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.data {
	export interface IDataReader extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (String) */
		clientIdProperty?: string;
		/** [Config Option] (String) */
		idProperty?: string;
		/** [Config Option] (Boolean) */
		implicitIncludes?: boolean;
		/** [Config Option] (String) */
		messageProperty?: string;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		rootProperty?: string;
		/** [Config Option] (String) */
		successProperty?: string;
		/** [Config Option] (String) */
		totalProperty?: string;
		/** [Property] (Object) */
		metaData?: any;
		/** [Property] (Object) */
		rawData?: any;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of clientIdProperty  
		* @returns String 
		*/
		getClientIdProperty?(): string;
		/** [Method] Returns the value of idProperty  
		* @returns String 
		*/
		getIdProperty?(): string;
		/** [Method] Returns the value of implicitIncludes  
		* @returns Boolean 
		*/
		getImplicitIncludes?(): boolean;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of messageProperty  
		* @returns String 
		*/
		getMessageProperty?(): string;
		/** [Method] Returns the value of model  
		* @returns Object 
		*/
		getModel?(): any;
		/** [Method] Takes a raw response object as passed to this read and returns the useful data segment of it  
		* @param response Object The response object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Returns the value of rootProperty  
		* @returns String 
		*/
		getRootProperty?(): string;
		/** [Method] Returns the value of successProperty  
		* @returns any 
		*/
		getSuccessProperty?(): any;
		/** [Method] Returns the value of totalProperty  
		* @returns any 
		*/
		getTotalProperty?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Reads the given response object  
		* @param response Object The response object. This may be either an XMLHttpRequest object or a plain JS object 
		* @returns Ext.data.ResultSet The parsed ResultSet object 
		*/
		read?( response?:any ): Ext.data.IResultSet;
		/** [Method] Abstracts common functionality used by all Reader subclasses  
		* @param data Object The raw data object 
		* @returns Ext.data.ResultSet A ResultSet object 
		*/
		readRecords?( data?:any ): Ext.data.IResultSet;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of clientIdProperty  
		* @param clientIdProperty String The new value. 
		*/
		setClientIdProperty?( clientIdProperty?:string ): void;
		/** [Method] Sets the value of idProperty  
		* @param idProperty String The new value. 
		*/
		setIdProperty?( idProperty?:string ): void;
		/** [Method] Sets the value of implicitIncludes  
		* @param implicitIncludes Boolean The new value. 
		*/
		setImplicitIncludes?( implicitIncludes?:boolean ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of messageProperty  
		* @param messageProperty String The new value. 
		*/
		setMessageProperty?( messageProperty?:string ): void;
		/** [Method] Sets the value of model  
		* @param model Object The new value. 
		*/
		setModel?( model?:any ): void;
		/** [Method] Sets the value of rootProperty  
		* @param rootProperty String The new value. 
		*/
		setRootProperty?( rootProperty?:string ): void;
		/** [Method] Sets the value of successProperty  
		* @param successProperty String The new value. 
		*/
		setSuccessProperty?( successProperty?:string ): void;
		/** [Method] Sets the value of totalProperty  
		* @param totalProperty String The new value. 
		*/
		setTotalProperty?( totalProperty?:string ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.data.reader {
	export interface IXml extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		record?: string;
		/** [Method] Normalizes the data object  
		* @param data Object The raw data object. 
		* @returns Object Returns the documentElement property of the data object if present, or the same object if not. 
		*/
		getData?( data?:any ): any;
		/** [Method] Returns the value of record  
		* @returns String 
		*/
		getRecord?(): string;
		/** [Method] inherit docs 
		* @param response Object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Parses an XML document and returns a ResultSet containing the model instances  
		* @param doc Object Parsed XML document. 
		* @returns Ext.data.ResultSet The parsed result set. 
		*/
		readRecords?( doc?:any ): Ext.data.IResultSet;
		/** [Method] Sets the value of record  
		* @param record String The new value. 
		*/
		setRecord?( record?:string ): void;
	}
}
declare module Ext.data {
	export interface IXmlReader extends Ext.data.reader.IReader {
		/** [Config Option] (String) */
		record?: string;
		/** [Method] Normalizes the data object  
		* @param data Object The raw data object. 
		* @returns Object Returns the documentElement property of the data object if present, or the same object if not. 
		*/
		getData?( data?:any ): any;
		/** [Method] Returns the value of record  
		* @returns String 
		*/
		getRecord?(): string;
		/** [Method] inherit docs 
		* @param response Object 
		* @returns Object The useful data from the response 
		*/
		getResponseData?( response?:any ): any;
		/** [Method] Parses an XML document and returns a ResultSet containing the model instances  
		* @param doc Object Parsed XML document. 
		* @returns Ext.data.ResultSet The parsed result set. 
		*/
		readRecords?( doc?:any ): Ext.data.IResultSet;
		/** [Method] Sets the value of record  
		* @param record String The new value. 
		*/
		setRecord?( record?:string ): void;
	}
}
declare module Ext.data {
	export interface IRequest extends Ext.IBase {
		/** [Config Option] (String) */
		action?: string;
		/** [Config Option] (String) */
		callbackKey?: string;
		/** [Config Option] (Boolean) */
		disableCaching?: boolean;
		/** [Config Option] (Object) */
		headers?: any;
		/** [Config Option] (Object) */
		jsonData?: any;
		/** [Config Option] (Ext.data.JsonP) */
		jsonp?: Ext.data.IJsonP;
		/** [Config Option] (String) */
		method?: string;
		/** [Config Option] (Ext.data.Operation) */
		operation?: Ext.data.IOperation;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (String) */
		password?: string;
		/** [Config Option] (Ext.data.proxy.Proxy) */
		proxy?: Ext.data.proxy.IProxy;
		/** [Config Option] (String) */
		url?: string;
		/** [Config Option] (String) */
		username?: string;
		/** [Config Option] (Boolean) */
		withCredentials?: boolean;
		/** [Config Option] (Object) */
		xmlData?: any;
		/** [Method] Returns the value of action  
		* @returns String 
		*/
		getAction?(): string;
		/** [Method] Returns the value of args  
		* @returns Object 
		*/
		getArgs?(): any;
		/** [Method] Returns the value of callback  
		* @returns Object 
		*/
		getCallback?(): any;
		/** [Method] Returns the value of callbackKey  
		* @returns String 
		*/
		getCallbackKey?(): string;
		/** [Method] Returns the value of directFn  
		* @returns Object 
		*/
		getDirectFn?(): any;
		/** [Method] Returns the value of disableCaching  
		* @returns Boolean 
		*/
		getDisableCaching?(): boolean;
		/** [Method] Returns the value of headers  
		* @returns Object 
		*/
		getHeaders?(): any;
		/** [Method] Returns the value of jsonData  
		* @returns Object 
		*/
		getJsonData?(): any;
		/** [Method] Returns the value of method  
		* @returns String 
		*/
		getMethod?(): string;
		/** [Method] Returns the value of operation  
		* @returns Ext.data.Operation 
		*/
		getOperation?(): Ext.data.IOperation;
		/** [Method] Returns the value of params  
		* @returns Object 
		*/
		getParams?(): any;
		/** [Method] Returns the value of password  
		* @returns String 
		*/
		getPassword?(): string;
		/** [Method] Returns the value of proxy  
		* @returns Ext.data.proxy.Proxy 
		*/
		getProxy?(): Ext.data.proxy.IProxy;
		/** [Method] Returns the value of records  
		* @returns Object 
		*/
		getRecords?(): any;
		/** [Method] Returns the value of scope  
		* @returns Object 
		*/
		getScope?(): any;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		getTimeout?(): number;
		/** [Method] Returns the value of url  
		* @returns String 
		*/
		getUrl?(): string;
		/** [Method] Returns the value of useDefaultXhrHeader  
		* @returns Object 
		*/
		getUseDefaultXhrHeader?(): any;
		/** [Method] Returns the value of username  
		* @returns String 
		*/
		getUsername?(): string;
		/** [Method] Returns the value of withCredentials  
		* @returns Boolean 
		*/
		getWithCredentials?(): boolean;
		/** [Method] Returns the value of xmlData  
		* @returns Object 
		*/
		getXmlData?(): any;
		/** [Method] Sets the value of action  
		* @param action String The new value. 
		*/
		setAction?( action?:string ): void;
		/** [Method] Sets the value of args  
		* @param args Object The new value. 
		*/
		setArgs?( args?:any ): void;
		/** [Method] Sets the value of callback  
		* @param callback Object The new value. 
		*/
		setCallback?( callback?:any ): void;
		/** [Method] Sets the value of callbackKey  
		* @param callbackKey String The new value. 
		*/
		setCallbackKey?( callbackKey?:string ): void;
		/** [Method] Sets the value of directFn  
		* @param directFn Object The new value. 
		*/
		setDirectFn?( directFn?:any ): void;
		/** [Method] Sets the value of disableCaching  
		* @param disableCaching Boolean The new value. 
		*/
		setDisableCaching?( disableCaching?:boolean ): void;
		/** [Method] Sets the value of headers  
		* @param headers Object The new value. 
		*/
		setHeaders?( headers?:any ): void;
		/** [Method] Sets the value of jsonData  
		* @param jsonData Object The new value. 
		*/
		setJsonData?( jsonData?:any ): void;
		/** [Method] Sets the value of method  
		* @param method String The new value. 
		*/
		setMethod?( method?:string ): void;
		/** [Method] Sets the value of operation  
		* @param operation Ext.data.Operation The new value. 
		*/
		setOperation?( operation?:Ext.data.IOperation ): void;
		/** [Method] Sets the value of params  
		* @param params Object The new value. 
		*/
		setParams?( params?:any ): void;
		/** [Method] Sets the value of password  
		* @param password String The new value. 
		*/
		setPassword?( password?:string ): void;
		/** [Method] Sets the value of proxy  
		* @param proxy Ext.data.proxy.Proxy The new value. 
		*/
		setProxy?( proxy?:Ext.data.proxy.IProxy ): void;
		/** [Method] Sets the value of records  
		* @param records Object The new value. 
		*/
		setRecords?( records?:any ): void;
		/** [Method] Sets the value of scope  
		* @param scope Object The new value. 
		*/
		setScope?( scope?:any ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		setTimeout?( timeout?:number ): void;
		/** [Method] Sets the value of url  
		* @param url String The new value. 
		*/
		setUrl?( url?:string ): void;
		/** [Method] Sets the value of useDefaultXhrHeader  
		* @param useDefaultXhrHeader Object The new value. 
		*/
		setUseDefaultXhrHeader?( useDefaultXhrHeader?:any ): void;
		/** [Method] Sets the value of username  
		* @param username String The new value. 
		*/
		setUsername?( username?:string ): void;
		/** [Method] Sets the value of withCredentials  
		* @param withCredentials Boolean The new value. 
		*/
		setWithCredentials?( withCredentials?:boolean ): void;
		/** [Method] Sets the value of xmlData  
		* @param xmlData Object The new value. 
		*/
		setXmlData?( xmlData?:any ): void;
	}
}
declare module Ext.data {
	export interface IResultSet extends Ext.IBase {
		/** [Config Option] (Number) */
		count?: number;
		/** [Config Option] (Boolean) */
		loaded?: boolean;
		/** [Config Option] (String) */
		message?: string;
		/** [Config Option] (Ext.data.Model[]) */
		records?: Ext.data.IModel[];
		/** [Config Option] (Boolean) */
		success?: boolean;
		/** [Config Option] (Number) */
		total?: number;
		/** [Method] Returns the value of count  
		* @returns Number 
		*/
		getCount?(): number;
		/** [Method] Returns the value of loaded  
		* @returns Boolean 
		*/
		getLoaded?(): boolean;
		/** [Method] Returns the value of message  
		* @returns String 
		*/
		getMessage?(): string;
		/** [Method] Returns the value of records  
		* @returns Ext.data.Model[] 
		*/
		getRecords?(): Ext.data.IModel[];
		/** [Method] Returns the value of success  
		* @returns Boolean 
		*/
		getSuccess?(): boolean;
		/** [Method] Returns the value of total  
		* @returns Number 
		*/
		getTotal?(): number;
		/** [Method] Sets the value of count  
		* @param count Number The new value. 
		*/
		setCount?( count?:number ): void;
		/** [Method] Sets the value of loaded  
		* @param loaded Boolean The new value. 
		*/
		setLoaded?( loaded?:boolean ): void;
		/** [Method] Sets the value of message  
		* @param message String The new value. 
		*/
		setMessage?( message?:string ): void;
		/** [Method] Sets the value of records  
		* @param records Ext.data.Model[] The new value. 
		*/
		setRecords?( records?:Ext.data.IModel[] ): void;
		/** [Method] Sets the value of success  
		* @param success Boolean The new value. 
		*/
		setSuccess?( success?:boolean ): void;
		/** [Method] Sets the value of total  
		* @param total Number The new value. 
		*/
		setTotal?( total?:number ): void;
	}
}
declare module Ext.data {
	export interface ISortTypes extends Ext.IBase {
	}
	export class SortTypes {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (RegExp) */
		static stripTagsRE: RegExp;
		/** [Method] Date sorting  
		* @param value Object The value being converted. 
		* @returns Number The comparison value. 
		*/
		static asDate( value?:any ): number;
		/** [Method] Float sorting  
		* @param value Object The value being converted. 
		* @returns Number The comparison value. 
		*/
		static asFloat( value?:any ): number;
		/** [Method] Integer sorting  
		* @param value Object The value being converted. 
		* @returns Number The comparison value. 
		*/
		static asInt( value?:any ): number;
		/** [Method] Strips all HTML tags to sort on text only  
		* @param value Object The value being converted. 
		* @returns String The comparison value. 
		*/
		static asText( value?:any ): string;
		/** [Method] Case insensitive string  
		* @param value Object The value being converted. 
		* @returns String The comparison value. 
		*/
		static asUCString( value?:any ): string;
		/** [Method] Strips all HTML tags to sort on text only  case insensitive  
		* @param value Object The value being converted. 
		* @returns String The comparison value. 
		*/
		static asUCText( value?:any ): string;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Default sort that does nothing  
		* @param value Object The value being converted. 
		* @returns Object The comparison value. 
		*/
		static none( value?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data {
	export interface IStore extends Ext.IEvented {
		/** [Config Option] (Boolean/Object) */
		autoLoad?: any;
		/** [Config Option] (Boolean) */
		autoSync?: boolean;
		/** [Config Option] (Boolean) */
		buffered?: boolean;
		/** [Config Option] (Boolean) */
		clearOnPageLoad?: boolean;
		/** [Config Option] (Object[]/Ext.data.Model[]) */
		data?: any;
		/** [Config Option] (Boolean) */
		destroyRemovedRecords?: boolean;
		/** [Config Option] (Object[]/Ext.util.Collection) */
		fields?: any;
		/** [Config Option] (Object[]) */
		filters?: any[];
		/** [Config Option] (Function) */
		getGroupString?: any;
		/** [Config Option] (String) */
		groupDir?: string;
		/** [Config Option] (String) */
		groupField?: string;
		/** [Config Option] (Object) */
		grouper?: any;
		/** [Config Option] (String) */
		model?: string;
		/** [Config Option] (Number) */
		pageSize?: number;
		/** [Config Option] (Object) */
		params?: any;
		/** [Config Option] (Object/Array) */
		plugins?: any;
		/** [Config Option] (String/Ext.data.proxy.Proxy/Object) */
		proxy?: any;
		/** [Config Option] (Boolean) */
		remoteFilter?: boolean;
		/** [Config Option] (Boolean) */
		remoteGroup?: boolean;
		/** [Config Option] (Boolean) */
		remoteSort?: boolean;
		/** [Config Option] (Object[]) */
		sorters?: any[];
		/** [Config Option] (String) */
		storeId?: string;
		/** [Config Option] (Boolean) */
		syncRemovedRecords?: boolean;
		/** [Config Option] (Number) */
		totalCount?: number;
		/** [Property] (Number) */
		currentPage?: number;
		/** [Method] Adds Model instance to the Store  
		* @param model Ext.data.Model[]/Ext.data.Model... An array of Model instances or Model configuration objects, or variable number of Model instance or config arguments. 
		* @returns Ext.data.Model[] The model instances that were added. 
		*/
		add?( model?:any ): Ext.data.IModel[];
		/** [Method] Uses the configured reader to convert the data into records and adds it to the Store  
		* @param data Object[] Array of data to load 
		*/
		addData?( data?:any[] ): void;
		/** [Method] We are using applyData so that we can return nothing and prevent the this data property to be overridden  
		* @param data Array/Object 
		*/
		applyData?( data?:any ): void;
		/** [Method] Gets the average value in the store  
		* @param field String The field in each record you want to get the average for. 
		* @returns Number The average value, if no items exist, 0. 
		*/
		average?( field?:string ): number;
		/** [Method] Reverts to a view of the Record cache with no filtering applied  
		* @param suppressEvent Boolean true to clear silently without firing the refresh event. 
		*/
		clearFilter?( suppressEvent?:boolean ): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Calls the specified function for each of the Records in the cache  
		* @param fn Function The function to call. Returning false aborts and exits the iteration. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current Record in the iteration. 
		*/
		each?( fn?:any, scope?:any ): void;
		/** [Method] Filters the loaded set of records by a given set of filters  
		* @param filters Object[]/Ext.util.Filter[]/String The set of filters to apply to the data. These are stored internally on the store, but the filtering itself is done on the Store's MixedCollection. See MixedCollection's filter method for filter syntax. Alternatively, pass in a property string. 
		* @param value String value to filter by (only if using a property string as the first argument). 
		* @param anyMatch Boolean true to allow any match, false to anchor regex beginning with ^. 
		* @param caseSensitive Boolean true to make the filtering regex case sensitive. 
		*/
		filter?( filters?:any, value?:string, anyMatch?:boolean, caseSensitive?:boolean ): void;
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. It will be passed the following parameters: 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this Store. 
		*/
		filterBy?( fn?:any, scope?:any ): void;
		/** [Method] Finds the index of the first matching Record in this store by a specific field value  
		* @param fieldName String The name of the Record field to test. 
		* @param value String/RegExp Either a string that the field value should begin with, or a RegExp to test against the field. 
		* @param startIndex Number The index to start searching at. 
		* @param anyMatch Boolean true to match any part of the string, not just the beginning. 
		* @param caseSensitive Boolean true for case sensitive comparison. 
		* @param exactMatch Boolean true to force exact match (^ and $ characters added to the regex). 
		* @returns Number The matched index or -1 
		*/
		find?( fieldName?:string, value?:any, startIndex?:number, anyMatch?:boolean, caseSensitive?:boolean, exactMatch?:boolean ): number;
		/** [Method] Find the index of the first matching Record in this Store by a function  
		* @param fn Function The function to be called. It will be passed the following parameters: 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this Store. 
		* @param startIndex Number The index to start searching at. 
		* @returns Number The matched index or -1. 
		*/
		findBy?( fn?:any, scope?:any, startIndex?:number ): number;
		/** [Method] Finds the index of the first matching Record in this store by a specific field value  
		* @param fieldName String The name of the Record field to test. 
		* @param value Object The value to match the field against. 
		* @param startIndex Number The index to start searching at. 
		* @returns Number The matched index or -1. 
		*/
		findExact?( fieldName?:string, value?:any, startIndex?:number ): number;
		/** [Method] Finds the first matching Record in this store by a specific field value  
		* @param fieldName String The name of the Record field to test. 
		* @param value String/RegExp Either a string that the field value should begin with, or a RegExp to test against the field. 
		* @param startIndex Number The index to start searching at. 
		* @param anyMatch Boolean true to match any part of the string, not just the beginning. 
		* @param caseSensitive Boolean true for case sensitive comparison. 
		* @param exactMatch Boolean true to force exact match (^ and $ characters added to the regex). 
		* @returns Ext.data.Model The matched record or null. 
		*/
		findRecord?( fieldName?:string, value?:any, startIndex?:number, anyMatch?:boolean, caseSensitive?:boolean, exactMatch?:boolean ): Ext.data.IModel;
		/** [Method] Convenience function for getting the first model instance in the store  
		* @returns Ext.data.Model/undefined The first model instance in the store, or undefined. 
		*/
		first?(): any;
		/** [Method] Gets the number of all cached records including the ones currently filtered  
		* @returns Number The number of all Records in the Store's cache. 
		*/
		getAllCount?(): number;
		/** [Method] Get the Record at the specified index  
		* @param index Number The index of the Record to find. 
		* @returns Ext.data.Model/undefined The Record at the passed index. Returns undefined if not found. 
		*/
		getAt?( index?:number ): any;
		/** [Method] Returns the value of autoLoad  
		* @returns Boolean/Object 
		*/
		getAutoLoad?(): any;
		/** [Method] Returns the value of autoSync  
		* @returns Boolean 
		*/
		getAutoSync?(): boolean;
		/** [Method] Returns the value of buffered  
		* @returns Boolean 
		*/
		getBuffered?(): boolean;
		/** [Method] Get the Record with the specified id  
		* @param id String The id of the Record to find. 
		* @returns Ext.data.Model/undefined The Record with the passed id. Returns undefined if not found. 
		*/
		getById?( id?:string ): any;
		/** [Method] Returns the value of clearOnPageLoad  
		* @returns Boolean 
		*/
		getClearOnPageLoad?(): boolean;
		/** [Method] Gets the number of cached records  
		* @returns Number The number of Records in the Store's cache. 
		*/
		getCount?(): number;
		/** [Method] Returns the value of data  
		* @returns Object[]/Ext.data.Model[] 
		*/
		getData?(): any;
		/** [Method] Returns the value of destroyRemovedRecords  
		* @returns Boolean 
		*/
		getDestroyRemovedRecords?(): boolean;
		/** [Method] Returns the value of fields  
		* @returns Object[]/Ext.util.Collection 
		*/
		getFields?(): any;
		/** [Method] Returns the value of getGroupString  
		* @returns Function 
		*/
		getGetGroupString?(): any;
		/** [Method] Returns the value of groupDir  
		* @returns String 
		*/
		getGroupDir?(): string;
		/** [Method] Returns the value of groupField  
		* @returns String 
		*/
		getGroupField?(): string;
		/** [Method] Returns the value of grouper  
		* @returns Object 
		*/
		getGrouper?(): any;
		/** [Method] Returns an array containing the result of applying the grouper to the records in this store  
		* @param groupName String Pass in an optional groupName argument to access a specific group as defined by grouper. 
		* @returns Object/Object[] The grouped data. 
		*/
		getGroups?( groupName?:string ): any;
		/** [Method] Returns the value of model  
		* @returns String 
		*/
		getModel?(): string;
		/** [Method] Returns the value of modelDefaults  
		* @returns Object 
		*/
		getModelDefaults?(): any;
		/** [Method] Returns all Model instances that are either currently a phantom e g  
		* @returns Ext.data.Model[] The Model instances. 
		*/
		getNewRecords?(): Ext.data.IModel[];
		/** [Method] Returns the value of pageSize  
		* @returns Number 
		*/
		getPageSize?(): number;
		/** [Method] Returns the value of params  
		* @returns Object 
		*/
		getParams?(): any;
		/** [Method] Returns the value of plugins  
		* @returns Object/Array 
		*/
		getPlugins?(): any;
		/** [Method] Returns the value of proxy  
		* @returns String/Ext.data.proxy.Proxy/Object 
		*/
		getProxy?(): any;
		/** [Method] Returns a range of Records between specified indices  
		* @param startIndex Number The starting index. 
		* @param endIndex Number The ending index (defaults to the last Record in the Store). 
		* @returns Ext.data.Model[] An array of Records. 
		*/
		getRange?( startIndex?:number, endIndex?:number ): Ext.data.IModel[];
		/** [Method] Returns the value of remoteFilter  
		* @returns Boolean 
		*/
		getRemoteFilter?(): boolean;
		/** [Method] Returns the value of remoteGroup  
		* @returns Boolean 
		*/
		getRemoteGroup?(): boolean;
		/** [Method] Returns the value of remoteSort  
		* @returns Boolean 
		*/
		getRemoteSort?(): boolean;
		/** [Method] Returns any records that have been removed from the store but not yet destroyed on the proxy  
		* @returns Ext.data.Model[] The removed Model instances. 
		*/
		getRemovedRecords?(): Ext.data.IModel[];
		/** [Method] Returns the value of storeId  
		* @returns String 
		*/
		getStoreId?(): string;
		/** [Method] Returns the value of syncRemovedRecords  
		* @returns Boolean 
		*/
		getSyncRemovedRecords?(): boolean;
		/** [Method] Returns the value of totalCount  
		* @returns Number 
		*/
		getTotalCount?(): number;
		/** [Method] Returns all Model instances that have been updated in the Store but not yet synchronized with the Proxy  
		* @returns Ext.data.Model[] The updated Model instances. 
		*/
		getUpdatedRecords?(): Ext.data.IModel[];
		/** [Method] Get the index within the cache of the passed Record  
		* @param record Ext.data.Model The Ext.data.Model object to find. 
		* @returns Number The index of the passed Record. Returns -1 if not found. 
		*/
		indexOf?( record?:Ext.data.IModel ): number;
		/** [Method] Get the index within the cache of the Record with the passed id  
		* @param id String The id of the Record to find. 
		* @returns Number The index of the Record. Returns -1 if not found. 
		*/
		indexOfId?( id?:string ): number;
		/** [Method] Inserts Model instances into the Store at the given index and fires the add event  
		* @param index Number The start index at which to insert the passed Records. 
		* @param records Ext.data.Model[] An Array of Ext.data.Model objects to add to the cache. 
		* @returns Object 
		*/
		insert?( index?:number, records?:Ext.data.IModel[] ): any;
		/** [Method] Returns true if the Store is set to autoLoad or is a type which loads upon instantiation  
		* @returns Boolean 
		*/
		isAutoLoading?(): boolean;
		/** [Method] Returns true if this store is currently filtered  
		* @returns Boolean 
		*/
		isFiltered?(): boolean;
		/** [Method] This method tells you if this store has a grouper defined on it  
		* @returns Boolean true if this store has a grouper defined. 
		*/
		isGrouped?(): boolean;
		/** [Method] Returns true if the Store has been loaded  
		* @returns Boolean true if the Store has been loaded. 
		*/
		isLoaded?(): boolean;
		/** [Method] Returns true if the Store is currently performing a load operation  
		* @returns Boolean true if the Store is currently loading. 
		*/
		isLoading?(): boolean;
		/** [Method] Returns true if this store is currently sorted  
		* @returns Boolean 
		*/
		isSorted?(): boolean;
		/** [Method] Convenience function for getting the last model instance in the store  
		* @returns Ext.data.Model/undefined The last model instance in the store, or undefined. 
		*/
		last?(): any;
		/** [Method] Loads data into the Store via the configured proxy  
		* @param options Object/Function config object, passed into the Ext.data.Operation object before loading. 
		* @param scope Object Scope for the function. 
		* @returns Object 
		*/
		load?( options?:any, scope?:any ): any;
		/** [Method] Loads an array of data straight into the Store  
		* @param data Ext.data.Model[]/Object[] Array of data to load. Any non-model instances will be cast into model instances first. 
		* @param append Boolean true to add the records to the existing records in the store, false to remove the old ones first. 
		*/
		loadData?( data?:any, append?:boolean ): void;
		/** [Method] Loads a given page of data by setting the start and limit values appropriately  
		* @param page Number The number of the page to load. 
		* @param options Object See options for load. 
		* @param scope Object 
		*/
		loadPage?( page?:number, options?:any, scope?:any ): void;
		/** [Method] Adds Model instance to the Store  
		* @param model Ext.data.Model[]/Ext.data.Model... An array of Model instances or Model configuration objects, or variable number of Model instance or config arguments. 
		* @returns Ext.data.Model[] The model instances that were added. 
		*/
		loadRecords?( model?:any ): Ext.data.IModel[];
		/** [Method] Gets the maximum value in the store  
		* @param field String The field in each record. 
		* @returns Object/undefined The maximum value, if no items exist, undefined. 
		*/
		max?( field?:string ): any;
		/** [Method] Gets the minimum value in the store  
		* @param field String The field in each record. 
		* @returns Object/undefined The minimum value, if no items exist, undefined. 
		*/
		min?( field?:string ): any;
		/** [Method] Loads the next page in the current data set  
		* @param options Object See options for load. 
		*/
		nextPage?( options?:any ): void;
		/** [Method] Loads the previous page in the current data set  
		* @param options Object See options for load. 
		*/
		previousPage?( options?:any ): void;
		/** [Method] Query the cached records in this Store using a filtering function  
		* @param fn Function The function to be called. It will be passed the following parameters: 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this Store. 
		* @returns Ext.util.MixedCollection Returns an Ext.util.MixedCollection of the matched records. 
		*/
		queryBy?( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Removes the given record from the Store firing the removerecords event passing all the instances that are removed  
		* @param records Ext.data.Model/Ext.data.Model[] Model instance or array of instances to remove. 
		*/
		remove?( records?:any ): void;
		/** [Method] Remove all items from the store  
		* @param silent Boolean Prevent the clear event from being fired. 
		*/
		removeAll?( silent?:boolean ): void;
		/** [Method] Removes the model instance at the given index  
		* @param index Number The record index. 
		*/
		removeAt?( index?:number ): void;
		/** [Method] Sets the value of autoLoad  
		* @param autoLoad Boolean/Object The new value. 
		*/
		setAutoLoad?( autoLoad?:any ): void;
		/** [Method] Sets the value of autoSync  
		* @param autoSync Boolean The new value. 
		*/
		setAutoSync?( autoSync?:boolean ): void;
		/** [Method] Sets the value of buffered  
		* @param buffered Boolean The new value. 
		*/
		setBuffered?( buffered?:boolean ): void;
		/** [Method] Sets the value of clearOnPageLoad  
		* @param clearOnPageLoad Boolean The new value. 
		*/
		setClearOnPageLoad?( clearOnPageLoad?:boolean ): void;
		/** [Method] Sets the value of data  
		* @param data Object[]/Ext.data.Model[] The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Sets the value of destroyRemovedRecords  
		* @param destroyRemovedRecords Boolean The new value. 
		*/
		setDestroyRemovedRecords?( destroyRemovedRecords?:boolean ): void;
		/** [Method] Sets the value of fields  
		* @param fields Object[]/Ext.util.Collection The new value. 
		* @returns Object Ext.util.Collection 
		*/
		setFields?( fields?:any ): any;
		/** [Method] Sets the value of filters  
		* @param filters Object[] The new value. 
		*/
		setFilters?( filters?:any[] ): void;
		/** [Method] Sets the value of getGroupString  
		* @param getGroupString Function The new value. 
		*/
		setGetGroupString?( getGroupString?:any ): void;
		/** [Method] Sets the value of groupDir  
		* @param groupDir String The new value. 
		*/
		setGroupDir?( groupDir?:string ): void;
		/** [Method] Sets the value of groupField  
		* @param groupField String The new value. 
		*/
		setGroupField?( groupField?:string ): void;
		/** [Method] Sets the value of grouper  
		* @param grouper Object The new value. 
		*/
		setGrouper?( grouper?:any ): void;
		/** [Method] Sets the value of model  
		* @param model String The new value. 
		*/
		setModel?( model?:string ): void;
		/** [Method] Sets the value of modelDefaults  
		* @param modelDefaults Object The new value. 
		*/
		setModelDefaults?( modelDefaults?:any ): void;
		/** [Method] Sets the value of pageSize  
		* @param pageSize Number The new value. 
		*/
		setPageSize?( pageSize?:number ): void;
		/** [Method] Sets the value of params  
		* @param params Object The new value. 
		*/
		setParams?( params?:any ): void;
		/** [Method] Sets the value of plugins  
		* @param plugins Object/Array The new value. 
		*/
		setPlugins?( plugins?:any ): void;
		/** [Method] Sets the value of proxy  
		* @param proxy String/Ext.data.proxy.Proxy/Object The new value. 
		*/
		setProxy?( proxy?:any ): void;
		/** [Method] Sets the value of remoteFilter  
		* @param remoteFilter Boolean The new value. 
		*/
		setRemoteFilter?( remoteFilter?:boolean ): void;
		/** [Method] Sets the value of remoteGroup  
		* @param remoteGroup Boolean The new value. 
		*/
		setRemoteGroup?( remoteGroup?:boolean ): void;
		/** [Method] Sets the value of remoteSort  
		* @param remoteSort Boolean The new value. 
		*/
		setRemoteSort?( remoteSort?:boolean ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Object[] The new value. 
		*/
		setSorters?( sorters?:any[] ): void;
		/** [Method] Sets the value of storeId  
		* @param storeId String The new value. 
		*/
		setStoreId?( storeId?:string ): void;
		/** [Method] Sets the value of syncRemovedRecords  
		* @param syncRemovedRecords Boolean The new value. 
		*/
		setSyncRemovedRecords?( syncRemovedRecords?:boolean ): void;
		/** [Method] Sets the value of totalCount  
		* @param totalCount Number The new value. 
		*/
		setTotalCount?( totalCount?:number ): void;
		/** [Method] Sorts the data in the Store by one or more of its properties  
		* @param sorters String/Ext.util.Sorter[] Either a string name of one of the fields in this Store's configured Model, or an array of sorter configurations. 
		* @param defaultDirection String The default overall direction to sort the data by. 
		* @param where String This can be either 'prepend' or 'append'. If you leave this undefined it will clear the current sorters. 
		*/
		sort?( sorters?:any, defaultDirection?:string, where?:string ): void;
		/** [Method] Sums the value of property for each record between start and end and returns the result  
		* @param field String The field in each record. 
		* @returns Number The sum. 
		*/
		sum?( field?:string ): number;
		/** [Method] Synchronizes the Store with its Proxy  
		* @param options Object 
		* @returns Object 
		*/
		sync?( options?:any ): any;
	}
}
declare module Ext.data {
	export interface IStoreManager extends Ext.util.ICollection {
	}
	export class StoreManager {
		/** [Property] (Array) */
		static all: any[];
		/** [Property] (Object) */
		static currentSortFn: any;
		/** [Property] (Boolean) */
		static dirtyFilterFn: boolean;
		/** [Property] (Boolean) */
		static dirtySortFn: boolean;
		/** [Property] (Boolean) */
		static filtered: boolean;
		/** [Property] (Object) */
		static indices: any;
		/** [Property] (Array) */
		static items: any[];
		/** [Property] (Array) */
		static keys: any[];
		/** [Property] (Number) */
		static length: number;
		/** [Property] (Object) */
		static map: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static sorted: boolean;
		/** [Method] Adds an item to the collection  
		* @param key String The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param item Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:string, item?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param addItems Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if {@link} Ext.util.MixedCollection.allowFunctions allowFunctions} has been set to true. 
		*/
		static addAll( addItems?:any ): void;
		/** [Method] This method adds a filter  
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		*/
		static addFilter( filter?:any ): void;
		/** [Method] This method adds all the filters in a passed array  
		* @param filters Object 
		* @returns Object 
		*/
		static addFilters( filters?:any ): any;
		/** [Method] This method adds a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorter( sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method adds all the sorters in a passed array  
		* @param sorters Array An array with sorters. A sorter can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorters( sorters?:any[], defaultDirection?:string ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param item Object The Object to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as an item. 
		*/
		static contains( item?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] This method will sort a collection based on the currently configured sorters  
		* @param property Object 
		* @param value Object 
		* @param anyMatch Object 
		* @param caseSensitive Object 
		* @returns Array 
		*/
		static filter( property?:any, value?:any, anyMatch?:any, caseSensitive?:any ): any[];
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index, or -1 if the item was not found. 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] This method returns the index that a given item would be inserted into a given array based on the current sorters  
		* @param items Array The array that you want to insert the item into. 
		* @param item Mixed The item that you want to insert into the items array. 
		* @returns Number The index for the given item in the given array based on the current sorters. 
		*/
		static findInsertionIndex( items?:any[], item?:any ): number;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection. 
		*/
		static first(): any;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the value of autoFilter  
		* @returns Boolean 
		*/
		static getAutoFilter(): boolean;
		/** [Method] Returns the value of autoSort  
		* @returns Boolean 
		*/
		static getAutoSort(): boolean;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the value of defaultSortDirection  
		* @returns String 
		*/
		static getDefaultSortDirection(): string;
		/** [Method] Returns an up to date sort function  
		* @returns Function sortFn The sort function. 
		*/
		static getFilterFn(): any;
		/** [Method] Returns the value of filterRoot  
		* @returns String 
		*/
		static getFilterRoot(): string;
		/** [Method] Returns the value of filters  
		* @returns Array 
		*/
		static getFilters(): any[];
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param start Number The starting index. 
		* @param end Number The ending index. Defaults to the last item. 
		* @returns Array An array of items. 
		*/
		static getRange( start?:number, end?:number ): any[];
		/** [Method] Returns an up to date sort function  
		* @returns Function The sort function. 
		*/
		static getSortFn(): any;
		/** [Method] Returns the value of sortRoot  
		* @returns String 
		*/
		static getSortRoot(): string;
		/** [Method] Returns the value of sorters  
		* @returns Array 
		*/
		static getSorters(): any[];
		/** [Method] Returns index within the collection of the passed Object  
		* @param item Object The item to find the index of. 
		* @returns Number Index of the item. Returns -1 if not found. 
		*/
		static indexOf( item?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number Index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String The key to associate with the new item, or the item itself. 
		* @param item Object If the second parameter was a key, the new item. 
		* @returns Object The item inserted. 
		*/
		static insert( index?:number, key?:string, item?:any ): any;
		/** [Method] This method adds a filter at a given index  
		* @param index Number The index at which to insert the filter. 
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Object 
		*/
		static insertFilter( index?:number, filter?:any ): any;
		/** [Method] This method inserts all the filters in the passed array at the given index  
		* @param index Number The index at which to insert the filters. 
		* @param filters Array Each filter can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Array 
		*/
		static insertFilters( index?:number, filters?:any[] ): any[];
		/** [Method] This method adds a sorter at a given index  
		* @param index Number The index at which to insert the sorter. 
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static insertSorter( index?:number, sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method inserts all the sorters in the passed array at the given index  
		* @returns Ext.util.Collection this 
		*/
		static insertSorters(): Ext.util.ICollection;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by its id returns a passed store instance or returns a new instance of a store created with  
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration. 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances. 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Remove an item from the collection  
		* @param item Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( item?:any ): any;
		/** [Method] Remove all items in the passed array from the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removed an item associated with the passed key from the collection  
		* @param key String The key of the item to remove. 
		* @returns Object/Boolean The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] This method removes all the filters in a passed array  
		* @param filters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeFilters( filters?:any ): Ext.util.ICollection;
		/** [Method] This method removes a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		*/
		static removeSorter( sorter?:any ): void;
		/** [Method] This method removes all the sorters in a passed array  
		* @param sorters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeSorters( sorters?:any ): Ext.util.ICollection;
		/** [Method] Replaces an item in the collection  
		* @param oldKey String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param item Object {Object} item (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( oldKey?:string, item?:any ): any;
		/** [Method] Sets the value of autoFilter  
		* @param autoFilter Boolean The new value. 
		*/
		static setAutoFilter( autoFilter?:boolean ): void;
		/** [Method] Sets the value of autoSort  
		* @param autoSort Boolean The new value. 
		*/
		static setAutoSort( autoSort?:boolean ): void;
		/** [Method] Sets the value of defaultSortDirection  
		* @param defaultSortDirection String The new value. 
		*/
		static setDefaultSortDirection( defaultSortDirection?:string ): void;
		/** [Method] Sets the value of filterRoot  
		* @param filterRoot String The new value. 
		*/
		static setFilterRoot( filterRoot?:string ): void;
		/** [Method] Sets the value of filters  
		* @param filters Array The new value. 
		*/
		static setFilters( filters?:any[] ): void;
		/** [Method] Sets the value of sortRoot  
		* @param sortRoot String The new value. 
		*/
		static setSortRoot( sortRoot?:string ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Array The new value. 
		*/
		static setSorters( sorters?:any[] ): void;
		/** [Method] This method will sort an array based on the currently configured sorters  
		* @param sorters Object 
		* @param defaultDirection Object 
		* @returns Array The array you passed after it is sorted. 
		*/
		static sort( sorters?:any, defaultDirection?:any ): any[];
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters one or more Stores with the StoreManager  
		* @param stores String/Object... Any number of Store instances or ID-s. 
		*/
		static unregister( stores?:any ): void;
	}
}
declare module Ext {
	export interface IStoreMgr extends Ext.util.ICollection {
	}
	export class StoreMgr {
		/** [Property] (Array) */
		static all: any[];
		/** [Property] (Object) */
		static currentSortFn: any;
		/** [Property] (Boolean) */
		static dirtyFilterFn: boolean;
		/** [Property] (Boolean) */
		static dirtySortFn: boolean;
		/** [Property] (Boolean) */
		static filtered: boolean;
		/** [Property] (Object) */
		static indices: any;
		/** [Property] (Array) */
		static items: any[];
		/** [Property] (Array) */
		static keys: any[];
		/** [Property] (Number) */
		static length: number;
		/** [Property] (Object) */
		static map: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static sorted: boolean;
		/** [Method] Adds an item to the collection  
		* @param key String The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param item Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:string, item?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param addItems Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if {@link} Ext.util.MixedCollection.allowFunctions allowFunctions} has been set to true. 
		*/
		static addAll( addItems?:any ): void;
		/** [Method] This method adds a filter  
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		*/
		static addFilter( filter?:any ): void;
		/** [Method] This method adds all the filters in a passed array  
		* @param filters Object 
		* @returns Object 
		*/
		static addFilters( filters?:any ): any;
		/** [Method] This method adds a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorter( sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method adds all the sorters in a passed array  
		* @param sorters Array An array with sorters. A sorter can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorters( sorters?:any[], defaultDirection?:string ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param item Object The Object to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as an item. 
		*/
		static contains( item?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] This method will sort a collection based on the currently configured sorters  
		* @param property Object 
		* @param value Object 
		* @param anyMatch Object 
		* @param caseSensitive Object 
		* @returns Array 
		*/
		static filter( property?:any, value?:any, anyMatch?:any, caseSensitive?:any ): any[];
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index, or -1 if the item was not found. 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] This method returns the index that a given item would be inserted into a given array based on the current sorters  
		* @param items Array The array that you want to insert the item into. 
		* @param item Mixed The item that you want to insert into the items array. 
		* @returns Number The index for the given item in the given array based on the current sorters. 
		*/
		static findInsertionIndex( items?:any[], item?:any ): number;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection. 
		*/
		static first(): any;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the value of autoFilter  
		* @returns Boolean 
		*/
		static getAutoFilter(): boolean;
		/** [Method] Returns the value of autoSort  
		* @returns Boolean 
		*/
		static getAutoSort(): boolean;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the value of defaultSortDirection  
		* @returns String 
		*/
		static getDefaultSortDirection(): string;
		/** [Method] Returns an up to date sort function  
		* @returns Function sortFn The sort function. 
		*/
		static getFilterFn(): any;
		/** [Method] Returns the value of filterRoot  
		* @returns String 
		*/
		static getFilterRoot(): string;
		/** [Method] Returns the value of filters  
		* @returns Array 
		*/
		static getFilters(): any[];
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param start Number The starting index. 
		* @param end Number The ending index. Defaults to the last item. 
		* @returns Array An array of items. 
		*/
		static getRange( start?:number, end?:number ): any[];
		/** [Method] Returns an up to date sort function  
		* @returns Function The sort function. 
		*/
		static getSortFn(): any;
		/** [Method] Returns the value of sortRoot  
		* @returns String 
		*/
		static getSortRoot(): string;
		/** [Method] Returns the value of sorters  
		* @returns Array 
		*/
		static getSorters(): any[];
		/** [Method] Returns index within the collection of the passed Object  
		* @param item Object The item to find the index of. 
		* @returns Number Index of the item. Returns -1 if not found. 
		*/
		static indexOf( item?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number Index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String The key to associate with the new item, or the item itself. 
		* @param item Object If the second parameter was a key, the new item. 
		* @returns Object The item inserted. 
		*/
		static insert( index?:number, key?:string, item?:any ): any;
		/** [Method] This method adds a filter at a given index  
		* @param index Number The index at which to insert the filter. 
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Object 
		*/
		static insertFilter( index?:number, filter?:any ): any;
		/** [Method] This method inserts all the filters in the passed array at the given index  
		* @param index Number The index at which to insert the filters. 
		* @param filters Array Each filter can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Array 
		*/
		static insertFilters( index?:number, filters?:any[] ): any[];
		/** [Method] This method adds a sorter at a given index  
		* @param index Number The index at which to insert the sorter. 
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static insertSorter( index?:number, sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method inserts all the sorters in the passed array at the given index  
		* @returns Ext.util.Collection this 
		*/
		static insertSorters(): Ext.util.ICollection;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by its id returns a passed store instance or returns a new instance of a store created with  
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration. 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances. 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Remove an item from the collection  
		* @param item Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( item?:any ): any;
		/** [Method] Remove all items in the passed array from the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removed an item associated with the passed key from the collection  
		* @param key String The key of the item to remove. 
		* @returns Object/Boolean The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] This method removes all the filters in a passed array  
		* @param filters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeFilters( filters?:any ): Ext.util.ICollection;
		/** [Method] This method removes a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		*/
		static removeSorter( sorter?:any ): void;
		/** [Method] This method removes all the sorters in a passed array  
		* @param sorters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeSorters( sorters?:any ): Ext.util.ICollection;
		/** [Method] Replaces an item in the collection  
		* @param oldKey String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param item Object {Object} item (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( oldKey?:string, item?:any ): any;
		/** [Method] Sets the value of autoFilter  
		* @param autoFilter Boolean The new value. 
		*/
		static setAutoFilter( autoFilter?:boolean ): void;
		/** [Method] Sets the value of autoSort  
		* @param autoSort Boolean The new value. 
		*/
		static setAutoSort( autoSort?:boolean ): void;
		/** [Method] Sets the value of defaultSortDirection  
		* @param defaultSortDirection String The new value. 
		*/
		static setDefaultSortDirection( defaultSortDirection?:string ): void;
		/** [Method] Sets the value of filterRoot  
		* @param filterRoot String The new value. 
		*/
		static setFilterRoot( filterRoot?:string ): void;
		/** [Method] Sets the value of filters  
		* @param filters Array The new value. 
		*/
		static setFilters( filters?:any[] ): void;
		/** [Method] Sets the value of sortRoot  
		* @param sortRoot String The new value. 
		*/
		static setSortRoot( sortRoot?:string ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Array The new value. 
		*/
		static setSorters( sorters?:any[] ): void;
		/** [Method] This method will sort an array based on the currently configured sorters  
		* @param sorters Object 
		* @param defaultDirection Object 
		* @returns Array The array you passed after it is sorted. 
		*/
		static sort( sorters?:any, defaultDirection?:any ): any[];
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters one or more Stores with the StoreManager  
		* @param stores String/Object... Any number of Store instances or ID-s. 
		*/
		static unregister( stores?:any ): void;
	}
}
declare module Ext.data {
	export interface IStoreMgr extends Ext.util.ICollection {
	}
	export class StoreMgr {
		/** [Property] (Array) */
		static all: any[];
		/** [Property] (Object) */
		static currentSortFn: any;
		/** [Property] (Boolean) */
		static dirtyFilterFn: boolean;
		/** [Property] (Boolean) */
		static dirtySortFn: boolean;
		/** [Property] (Boolean) */
		static filtered: boolean;
		/** [Property] (Object) */
		static indices: any;
		/** [Property] (Array) */
		static items: any[];
		/** [Property] (Array) */
		static keys: any[];
		/** [Property] (Number) */
		static length: number;
		/** [Property] (Object) */
		static map: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static sorted: boolean;
		/** [Method] Adds an item to the collection  
		* @param key String The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param item Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:string, item?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param addItems Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if {@link} Ext.util.MixedCollection.allowFunctions allowFunctions} has been set to true. 
		*/
		static addAll( addItems?:any ): void;
		/** [Method] This method adds a filter  
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		*/
		static addFilter( filter?:any ): void;
		/** [Method] This method adds all the filters in a passed array  
		* @param filters Object 
		* @returns Object 
		*/
		static addFilters( filters?:any ): any;
		/** [Method] This method adds a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorter( sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method adds all the sorters in a passed array  
		* @param sorters Array An array with sorters. A sorter can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorters( sorters?:any[], defaultDirection?:string ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param item Object The Object to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as an item. 
		*/
		static contains( item?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] This method will sort a collection based on the currently configured sorters  
		* @param property Object 
		* @param value Object 
		* @param anyMatch Object 
		* @param caseSensitive Object 
		* @returns Array 
		*/
		static filter( property?:any, value?:any, anyMatch?:any, caseSensitive?:any ): any[];
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index, or -1 if the item was not found. 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] This method returns the index that a given item would be inserted into a given array based on the current sorters  
		* @param items Array The array that you want to insert the item into. 
		* @param item Mixed The item that you want to insert into the items array. 
		* @returns Number The index for the given item in the given array based on the current sorters. 
		*/
		static findInsertionIndex( items?:any[], item?:any ): number;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection. 
		*/
		static first(): any;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the value of autoFilter  
		* @returns Boolean 
		*/
		static getAutoFilter(): boolean;
		/** [Method] Returns the value of autoSort  
		* @returns Boolean 
		*/
		static getAutoSort(): boolean;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the value of defaultSortDirection  
		* @returns String 
		*/
		static getDefaultSortDirection(): string;
		/** [Method] Returns an up to date sort function  
		* @returns Function sortFn The sort function. 
		*/
		static getFilterFn(): any;
		/** [Method] Returns the value of filterRoot  
		* @returns String 
		*/
		static getFilterRoot(): string;
		/** [Method] Returns the value of filters  
		* @returns Array 
		*/
		static getFilters(): any[];
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param start Number The starting index. 
		* @param end Number The ending index. Defaults to the last item. 
		* @returns Array An array of items. 
		*/
		static getRange( start?:number, end?:number ): any[];
		/** [Method] Returns an up to date sort function  
		* @returns Function The sort function. 
		*/
		static getSortFn(): any;
		/** [Method] Returns the value of sortRoot  
		* @returns String 
		*/
		static getSortRoot(): string;
		/** [Method] Returns the value of sorters  
		* @returns Array 
		*/
		static getSorters(): any[];
		/** [Method] Returns index within the collection of the passed Object  
		* @param item Object The item to find the index of. 
		* @returns Number Index of the item. Returns -1 if not found. 
		*/
		static indexOf( item?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number Index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String The key to associate with the new item, or the item itself. 
		* @param item Object If the second parameter was a key, the new item. 
		* @returns Object The item inserted. 
		*/
		static insert( index?:number, key?:string, item?:any ): any;
		/** [Method] This method adds a filter at a given index  
		* @param index Number The index at which to insert the filter. 
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Object 
		*/
		static insertFilter( index?:number, filter?:any ): any;
		/** [Method] This method inserts all the filters in the passed array at the given index  
		* @param index Number The index at which to insert the filters. 
		* @param filters Array Each filter can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Array 
		*/
		static insertFilters( index?:number, filters?:any[] ): any[];
		/** [Method] This method adds a sorter at a given index  
		* @param index Number The index at which to insert the sorter. 
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static insertSorter( index?:number, sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method inserts all the sorters in the passed array at the given index  
		* @returns Ext.util.Collection this 
		*/
		static insertSorters(): Ext.util.ICollection;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by its id returns a passed store instance or returns a new instance of a store created with  
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration. 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances. 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Remove an item from the collection  
		* @param item Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( item?:any ): any;
		/** [Method] Remove all items in the passed array from the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removed an item associated with the passed key from the collection  
		* @param key String The key of the item to remove. 
		* @returns Object/Boolean The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] This method removes all the filters in a passed array  
		* @param filters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeFilters( filters?:any ): Ext.util.ICollection;
		/** [Method] This method removes a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		*/
		static removeSorter( sorter?:any ): void;
		/** [Method] This method removes all the sorters in a passed array  
		* @param sorters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeSorters( sorters?:any ): Ext.util.ICollection;
		/** [Method] Replaces an item in the collection  
		* @param oldKey String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param item Object {Object} item (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( oldKey?:string, item?:any ): any;
		/** [Method] Sets the value of autoFilter  
		* @param autoFilter Boolean The new value. 
		*/
		static setAutoFilter( autoFilter?:boolean ): void;
		/** [Method] Sets the value of autoSort  
		* @param autoSort Boolean The new value. 
		*/
		static setAutoSort( autoSort?:boolean ): void;
		/** [Method] Sets the value of defaultSortDirection  
		* @param defaultSortDirection String The new value. 
		*/
		static setDefaultSortDirection( defaultSortDirection?:string ): void;
		/** [Method] Sets the value of filterRoot  
		* @param filterRoot String The new value. 
		*/
		static setFilterRoot( filterRoot?:string ): void;
		/** [Method] Sets the value of filters  
		* @param filters Array The new value. 
		*/
		static setFilters( filters?:any[] ): void;
		/** [Method] Sets the value of sortRoot  
		* @param sortRoot String The new value. 
		*/
		static setSortRoot( sortRoot?:string ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Array The new value. 
		*/
		static setSorters( sorters?:any[] ): void;
		/** [Method] This method will sort an array based on the currently configured sorters  
		* @param sorters Object 
		* @param defaultDirection Object 
		* @returns Array The array you passed after it is sorted. 
		*/
		static sort( sorters?:any, defaultDirection?:any ): any[];
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters one or more Stores with the StoreManager  
		* @param stores String/Object... Any number of Store instances or ID-s. 
		*/
		static unregister( stores?:any ): void;
	}
}
declare module Ext {
	export interface IStoreManager extends Ext.util.ICollection {
	}
	export class StoreManager {
		/** [Property] (Array) */
		static all: any[];
		/** [Property] (Object) */
		static currentSortFn: any;
		/** [Property] (Boolean) */
		static dirtyFilterFn: boolean;
		/** [Property] (Boolean) */
		static dirtySortFn: boolean;
		/** [Property] (Boolean) */
		static filtered: boolean;
		/** [Property] (Object) */
		static indices: any;
		/** [Property] (Array) */
		static items: any[];
		/** [Property] (Array) */
		static keys: any[];
		/** [Property] (Number) */
		static length: number;
		/** [Property] (Object) */
		static map: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (Boolean) */
		static sorted: boolean;
		/** [Method] Adds an item to the collection  
		* @param key String The key to associate with the item, or the new item. If a getKey implementation was specified for this MixedCollection, or if the key of the stored items is in a property called id, the MixedCollection will be able to derive the key for the new item. In this case just pass the new item in this parameter. 
		* @param item Object The item to add. 
		* @returns Object The item added. 
		*/
		static add( key?:string, item?:any ): any;
		/** [Method] Adds all elements of an Array or an Object to the collection  
		* @param addItems Object/Array An Object containing properties which will be added to the collection, or an Array of values, each of which are added to the collection. Functions references will be added to the collection if {@link} Ext.util.MixedCollection.allowFunctions allowFunctions} has been set to true. 
		*/
		static addAll( addItems?:any ): void;
		/** [Method] This method adds a filter  
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		*/
		static addFilter( filter?:any ): void;
		/** [Method] This method adds all the filters in a passed array  
		* @param filters Object 
		* @returns Object 
		*/
		static addFilters( filters?:any ): any;
		/** [Method] This method adds a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorter( sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method adds all the sorters in a passed array  
		* @param sorters Array An array with sorters. A sorter can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static addSorters( sorters?:any[], defaultDirection?:string ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all items from the collection  */
		static clear(): void;
		/** [Method] Creates a shallow copy of this collection 
		* @returns Ext.util.MixedCollection 
		*/
		static clone(): Ext.util.IMixedCollection;
		/** [Method] Returns true if the collection contains the passed Object as an item  
		* @param item Object The Object to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as an item. 
		*/
		static contains( item?:any ): boolean;
		/** [Method] Returns true if the collection contains the passed Object as a key  
		* @param key String The key to look for in the collection. 
		* @returns Boolean true if the collection contains the Object as a key. 
		*/
		static containsKey( key?:string ): boolean;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Executes the specified function once for every item in the collection  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the current item in the iteration. 
		*/
		static each( fn?:any, scope?:any ): void;
		/** [Method] Executes the specified function once for every key in the collection passing each key and its associated item as th  
		* @param fn Function The function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		*/
		static eachKey( fn?:any, scope?:any ): void;
		/** [Method] This method will sort a collection based on the currently configured sorters  
		* @param property Object 
		* @param value Object 
		* @param anyMatch Object 
		* @param caseSensitive Object 
		* @returns Array 
		*/
		static filter( property?:any, value?:any, anyMatch?:any, caseSensitive?:any ): any[];
		/** [Method] Filter by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @returns Ext.util.MixedCollection The new filtered collection 
		*/
		static filterBy( fn?:any, scope?:any ): Ext.util.IMixedCollection;
		/** [Method] Returns the first item in the collection which elicits a true return value from the passed selection function  
		* @param fn Function The selection function to execute for each item. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to the browser window. 
		* @returns Object The first item in the collection which returned true from the selection function. 
		*/
		static findBy( fn?:any, scope?:any ): any;
		/** [Method] Find the index of the first matching object in this collection by a function  
		* @param fn Function The function to be called. 
		* @param scope Object The scope (this reference) in which the function is executed. Defaults to this MixedCollection. 
		* @param start Number The index to start searching at. 
		* @returns Number The matched index, or -1 if the item was not found. 
		*/
		static findIndexBy( fn?:any, scope?:any, start?:number ): number;
		/** [Method] This method returns the index that a given item would be inserted into a given array based on the current sorters  
		* @param items Array The array that you want to insert the item into. 
		* @param item Mixed The item that you want to insert into the items array. 
		* @returns Number The index for the given item in the given array based on the current sorters. 
		*/
		static findInsertionIndex( items?:any[], item?:any ): number;
		/** [Method] Returns the first item in the collection  
		* @returns Object the first item in the collection. 
		*/
		static first(): any;
		/** [Method] Returns the item associated with the passed key OR index  
		* @param key String/Number The key or index of the item. 
		* @returns Object If the item is found, returns the item. If the item was not found, returns undefined. If an item was found, but is a Class, returns null. 
		*/
		static get( key?:any ): any;
		/** [Method] Returns the item at the specified index  
		* @param index Number The index of the item. 
		* @returns Object The item at the specified index. 
		*/
		static getAt( index?:number ): any;
		/** [Method] Returns the value of autoFilter  
		* @returns Boolean 
		*/
		static getAutoFilter(): boolean;
		/** [Method] Returns the value of autoSort  
		* @returns Boolean 
		*/
		static getAutoSort(): boolean;
		/** [Method] Returns the item associated with the passed key  
		* @param key String/Number The key of the item. 
		* @returns Object The item associated with the passed key. 
		*/
		static getByKey( key?:any ): any;
		/** [Method] Returns the number of items in the collection  
		* @returns Number the number of items in the collection. 
		*/
		static getCount(): number;
		/** [Method] Returns the value of defaultSortDirection  
		* @returns String 
		*/
		static getDefaultSortDirection(): string;
		/** [Method] Returns an up to date sort function  
		* @returns Function sortFn The sort function. 
		*/
		static getFilterFn(): any;
		/** [Method] Returns the value of filterRoot  
		* @returns String 
		*/
		static getFilterRoot(): string;
		/** [Method] Returns the value of filters  
		* @returns Array 
		*/
		static getFilters(): any[];
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] getKey implementation for MixedCollection 
		* @param o Object 
		* @returns Object The key for the passed item. 
		*/
		static getKey( o?:any ): any;
		/** [Method] Returns a range of items in this collection 
		* @param start Number The starting index. 
		* @param end Number The ending index. Defaults to the last item. 
		* @returns Array An array of items. 
		*/
		static getRange( start?:number, end?:number ): any[];
		/** [Method] Returns an up to date sort function  
		* @returns Function The sort function. 
		*/
		static getSortFn(): any;
		/** [Method] Returns the value of sortRoot  
		* @returns String 
		*/
		static getSortRoot(): string;
		/** [Method] Returns the value of sorters  
		* @returns Array 
		*/
		static getSorters(): any[];
		/** [Method] Returns index within the collection of the passed Object  
		* @param item Object The item to find the index of. 
		* @returns Number Index of the item. Returns -1 if not found. 
		*/
		static indexOf( item?:any ): number;
		/** [Method] Returns index within the collection of the passed key  
		* @param key String The key to find the index of. 
		* @returns Number Index of the key. 
		*/
		static indexOfKey( key?:string ): number;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Inserts an item at the specified index in the collection  
		* @param index Number The index to insert the item at. 
		* @param key String The key to associate with the new item, or the item itself. 
		* @param item Object If the second parameter was a key, the new item. 
		* @returns Object The item inserted. 
		*/
		static insert( index?:number, key?:string, item?:any ): any;
		/** [Method] This method adds a filter at a given index  
		* @param index Number The index at which to insert the filter. 
		* @param filter Ext.util.Sorter/Function/Object Can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Object 
		*/
		static insertFilter( index?:number, filter?:any ): any;
		/** [Method] This method inserts all the filters in the passed array at the given index  
		* @param index Number The index at which to insert the filters. 
		* @param filters Array Each filter can be an instance of Ext.util.Filter, an object representing an Ext.util.Filter configuration, or a filter function. 
		* @returns Array 
		*/
		static insertFilters( index?:number, filters?:any[] ): any[];
		/** [Method] This method adds a sorter at a given index  
		* @param index Number The index at which to insert the sorter. 
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		* @param defaultDirection String The default direction for each sorter in the array. Defaults to the value of defaultSortDirection. Can be either 'ASC' or 'DESC'. 
		*/
		static insertSorter( index?:number, sorter?:any, defaultDirection?:string ): void;
		/** [Method] This method inserts all the sorters in the passed array at the given index  
		* @returns Ext.util.Collection this 
		*/
		static insertSorters(): Ext.util.ICollection;
		/** [Method] Returns the last item in the collection  
		* @returns Object the last item in the collection. 
		*/
		static last(): any;
		/** [Method] Gets a registered Store by its id returns a passed store instance or returns a new instance of a store created with  
		* @param store String/Object The id of the Store, or a Store instance, or a store configuration. 
		* @returns Ext.data.Store 
		*/
		static lookup( store?:any ): Ext.data.IStore;
		/** [Method] Registers one or more Stores with the StoreManager  
		* @param stores Ext.data.Store... Any number of Store instances. 
		*/
		static register( stores:Ext.data.IStore ): void;
		/** [Method] Remove an item from the collection  
		* @param item Object The item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static remove( item?:any ): any;
		/** [Method] Remove all items in the passed array from the collection  
		* @param items Array An array of items to be removed. 
		* @returns Ext.util.MixedCollection this object 
		*/
		static removeAll( items?:any[] ): Ext.util.IMixedCollection;
		/** [Method] Remove an item from a specified index in the collection  
		* @param index Number The index within the collection of the item to remove. 
		* @returns Object The item removed or false if no item was removed. 
		*/
		static removeAt( index?:number ): any;
		/** [Method] Removed an item associated with the passed key from the collection  
		* @param key String The key of the item to remove. 
		* @returns Object/Boolean The item removed or false if no item was removed. 
		*/
		static removeAtKey( key?:string ): any;
		/** [Method] This method removes all the filters in a passed array  
		* @param filters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeFilters( filters?:any ): Ext.util.ICollection;
		/** [Method] This method removes a sorter  
		* @param sorter Ext.util.Sorter/String/Function/Object Can be an instance of Ext.util.Sorter, a string indicating a property name, an object representing an Ext.util.Sorter configuration, or a sort function. 
		*/
		static removeSorter( sorter?:any ): void;
		/** [Method] This method removes all the sorters in a passed array  
		* @param sorters Object 
		* @returns Ext.util.Collection this 
		*/
		static removeSorters( sorters?:any ): Ext.util.ICollection;
		/** [Method] Replaces an item in the collection  
		* @param oldKey String The key associated with the item to replace, or the replacement item. If you supplied a getKey implementation for this MixedCollection, or if the key of your stored items is in a property called id, then the MixedCollection will be able to derive the key of the replacement item. If you want to replace an item with one having the same key value, then just pass the replacement item in this parameter. 
		* @param item Object {Object} item (optional) If the first parameter passed was a key, the item to associate with that key. 
		* @returns Object The new item. 
		*/
		static replace( oldKey?:string, item?:any ): any;
		/** [Method] Sets the value of autoFilter  
		* @param autoFilter Boolean The new value. 
		*/
		static setAutoFilter( autoFilter?:boolean ): void;
		/** [Method] Sets the value of autoSort  
		* @param autoSort Boolean The new value. 
		*/
		static setAutoSort( autoSort?:boolean ): void;
		/** [Method] Sets the value of defaultSortDirection  
		* @param defaultSortDirection String The new value. 
		*/
		static setDefaultSortDirection( defaultSortDirection?:string ): void;
		/** [Method] Sets the value of filterRoot  
		* @param filterRoot String The new value. 
		*/
		static setFilterRoot( filterRoot?:string ): void;
		/** [Method] Sets the value of filters  
		* @param filters Array The new value. 
		*/
		static setFilters( filters?:any[] ): void;
		/** [Method] Sets the value of sortRoot  
		* @param sortRoot String The new value. 
		*/
		static setSortRoot( sortRoot?:string ): void;
		/** [Method] Sets the value of sorters  
		* @param sorters Array The new value. 
		*/
		static setSorters( sorters?:any[] ): void;
		/** [Method] This method will sort an array based on the currently configured sorters  
		* @param sorters Object 
		* @param defaultDirection Object 
		* @returns Array The array you passed after it is sorted. 
		*/
		static sort( sorters?:any, defaultDirection?:any ): any[];
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Unregisters one or more Stores with the StoreManager  
		* @param stores String/Object... Any number of Store instances or ID-s. 
		*/
		static unregister( stores?:any ): void;
	}
}
declare module Ext.data {
	export interface ITreeStore extends Ext.data.INodeStore {
		/** [Config Option] (Boolean) */
		clearOnLoad?: boolean;
		/** [Config Option] (String) */
		defaultRootId?: string;
		/** [Config Option] (String) */
		defaultRootProperty?: string;
		/** [Config Option] (String) */
		nodeParam?: string;
		/** [Config Option] (Ext.data.Model/Ext.data.NodeInterface/Object) */
		root?: any;
		/** [Method] Get the Record with the specified id  
		* @param id Object 
		* @returns Ext.data.Model/undefined The Record with the passed id. Returns undefined if not found. 
		*/
		getById?( id?:any ): any;
		/** [Method] Returns the value of clearOnLoad  
		* @returns Boolean 
		*/
		getClearOnLoad?(): boolean;
		/** [Method] Returns the value of defaultRootId  
		* @returns String 
		*/
		getDefaultRootId?(): string;
		/** [Method] Returns the value of defaultRootProperty  
		* @returns String 
		*/
		getDefaultRootProperty?(): string;
		/** [Method] Returns the record node by id 
		* @param id Object 
		* @returns Ext.data.NodeInterface 
		*/
		getNodeById?( id?:any ): Ext.data.INodeInterface;
		/** [Method] Returns the value of nodeParam  
		* @returns String 
		*/
		getNodeParam?(): string;
		/** [Method] Returns the value of root  
		* @returns Ext.data.Model/Ext.data.NodeInterface/Object 
		*/
		getRoot?(): any;
		/** [Method] Returns the root node for this tree  
		* @param node Object 
		* @returns Ext.data.Model 
		*/
		getRootNode?( node?:any ): Ext.data.IModel;
		/** [Method] Loads the Store using its configured proxy  
		* @param options Object config object. This is passed into the Operation object that is created and then sent to the proxy's Ext.data.proxy.Proxy.read function. The options can also contain a node, which indicates which node is to be loaded. If not specified, it will default to the root node. 
		* @returns Object 
		*/
		load?( options?:any ): any;
		/** [Method] Called internally when a Proxy has completed a load request  
		* @param operation Object 
		*/
		onProxyLoad?( operation?:any ): void;
		/** [Method] Remove all items from the store  
		* @param silent Boolean Prevent the clear event from being fired. 
		*/
		removeAll?( silent?:boolean ): void;
		/** [Method] Sets the value of clearOnLoad  
		* @param clearOnLoad Boolean The new value. 
		*/
		setClearOnLoad?( clearOnLoad?:boolean ): void;
		/** [Method] Sets the value of defaultRootId  
		* @param defaultRootId String The new value. 
		*/
		setDefaultRootId?( defaultRootId?:string ): void;
		/** [Method] Sets the value of defaultRootProperty  
		* @param defaultRootProperty String The new value. 
		*/
		setDefaultRootProperty?( defaultRootProperty?:string ): void;
		/** [Method] Sets the value of nodeParam  
		* @param nodeParam String The new value. 
		*/
		setNodeParam?( nodeParam?:string ): void;
		/** [Method] Sets the value of root  
		* @param root Ext.data.Model/Ext.data.NodeInterface/Object The new value. 
		*/
		setRoot?( root?:any ): void;
		/** [Method] Sets the root node for this tree  
		* @param node Ext.data.Model 
		* @returns Ext.data.Model 
		*/
		setRootNode?( node?:Ext.data.IModel ): Ext.data.IModel;
	}
}
declare module Ext.data {
	export interface ITypes extends Ext.IBase {
	}
	export class Types {
		/** [Property] (Object) */
		static AUTO: any;
		/** [Property] (Object) */
		static BOOL: any;
		/** [Property] (Object) */
		static BOOLEAN: any;
		/** [Property] (Object) */
		static DATE: any;
		/** [Property] (Object) */
		static FLOAT: any;
		/** [Property] (Object) */
		static INT: any;
		/** [Property] (Object) */
		static INTEGER: any;
		/** [Property] (Object) */
		static NUMBER: any;
		/** [Property] (Object) */
		static STRING: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (RegExp) */
		static stripRe: RegExp;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data {
	export interface IValidations extends Ext.IBase {
	}
	export class Validations {
		/** [Property] (String) */
		static emailMessage: string;
		/** [Property] (RegExp) */
		static emailRe: RegExp;
		/** [Property] (String) */
		static exclusionMessage: string;
		/** [Property] (String) */
		static formatMessage: string;
		/** [Property] (String) */
		static inclusionMessage: string;
		/** [Property] (String) */
		static lengthMessage: string;
		/** [Property] (String) */
		static presenceMessage: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Validates that an email string is in the correct format  
		* @param config Object Config object. 
		* @param email String The email address. 
		* @returns Boolean true if the value passes validation. 
		*/
		static email( config?:any, email?:string ): boolean;
		/** [Method] Validates that the given value is present in the configured list  
		* @param config Object Config object. 
		* @param value String The value to validate. 
		* @returns Boolean true if the value is not present in the list. 
		*/
		static exclusion( config?:any, value?:string ): boolean;
		/** [Method] Returns true if the given value passes validation against the configured matcher regex  
		* @param config Object Config object. 
		* @param value String The value to validate. 
		* @returns Boolean true if the value passes the format validation. 
		*/
		static format( config?:any, value?:string ): boolean;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the configured error message for any of the validation types  
		* @param type String The type of validation you want to get the error message for. 
		* @returns Object 
		*/
		static getMessage( type?:string ): any;
		/** [Method] Validates that the given value is present in the configured list  
		* @param config Object Config object. 
		* @param value String The value to validate. 
		* @returns Boolean true if the value is present in the list. 
		*/
		static inclusion( config?:any, value?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Returns true if the given value is between the configured min and max values  
		* @param config Object Config object. 
		* @param value String The value to validate. 
		* @returns Boolean true if the value passes validation. 
		*/
		static length( config?:any, value?:string ): boolean;
		/** [Method] Validates that the given value is present  
		* @param config Object Config object. 
		* @param value Object The value to validate. 
		* @returns Boolean true if validation passed. 
		*/
		static presence( config?:any, value?:any ): boolean;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.data.writer {
	export interface IJson extends Ext.data.writer.IWriter {
		/** [Config Option] (Boolean) */
		allowSingle?: boolean;
		/** [Config Option] (Boolean) */
		encode?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		rootProperty?: string;
		/** [Method] Returns the value of allowSingle  
		* @returns Boolean 
		*/
		getAllowSingle?(): boolean;
		/** [Method] Returns the value of encode  
		* @returns Boolean 
		*/
		getEncode?(): boolean;
		/** [Method] Returns the value of encodeRequest  
		* @returns Boolean 
		*/
		getEncodeRequest?(): boolean;
		/** [Method] Returns the value of rootProperty  
		* @returns String 
		*/
		getRootProperty?(): string;
		/** [Method] Sets the value of allowSingle  
		* @param allowSingle Boolean The new value. 
		*/
		setAllowSingle?( allowSingle?:boolean ): void;
		/** [Method] Sets the value of encode  
		* @param encode Boolean The new value. 
		*/
		setEncode?( encode?:boolean ): void;
		/** [Method] Sets the value of encodeRequest  
		* @param encodeRequest Boolean The new value. 
		*/
		setEncodeRequest?( encodeRequest?:boolean ): void;
		/** [Method] Sets the value of rootProperty  
		* @param rootProperty String The new value. 
		*/
		setRootProperty?( rootProperty?:string ): void;
	}
}
declare module Ext.data {
	export interface IJsonWriter extends Ext.data.writer.IWriter {
		/** [Config Option] (Boolean) */
		allowSingle?: boolean;
		/** [Config Option] (Boolean) */
		encode?: boolean;
		/** [Config Option] (String) */
		root?: string;
		/** [Config Option] (String) */
		rootProperty?: string;
		/** [Method] Returns the value of allowSingle  
		* @returns Boolean 
		*/
		getAllowSingle?(): boolean;
		/** [Method] Returns the value of encode  
		* @returns Boolean 
		*/
		getEncode?(): boolean;
		/** [Method] Returns the value of encodeRequest  
		* @returns Boolean 
		*/
		getEncodeRequest?(): boolean;
		/** [Method] Returns the value of rootProperty  
		* @returns String 
		*/
		getRootProperty?(): string;
		/** [Method] Sets the value of allowSingle  
		* @param allowSingle Boolean The new value. 
		*/
		setAllowSingle?( allowSingle?:boolean ): void;
		/** [Method] Sets the value of encode  
		* @param encode Boolean The new value. 
		*/
		setEncode?( encode?:boolean ): void;
		/** [Method] Sets the value of encodeRequest  
		* @param encodeRequest Boolean The new value. 
		*/
		setEncodeRequest?( encodeRequest?:boolean ): void;
		/** [Method] Sets the value of rootProperty  
		* @param rootProperty String The new value. 
		*/
		setRootProperty?( rootProperty?:string ): void;
	}
}
declare module Ext.data.writer {
	export interface IWriter extends Ext.IBase {
		/** [Config Option] (String) */
		nameProperty?: string;
		/** [Config Option] (Boolean) */
		writeAllFields?: boolean;
		/** [Method] Returns the value of nameProperty  
		* @returns String 
		*/
		getNameProperty?(): string;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Object The record that we are writing to the server. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:any ): any;
		/** [Method] Returns the value of writeAllFields  
		* @returns Boolean 
		*/
		getWriteAllFields?(): boolean;
		/** [Method] Sets the value of nameProperty  
		* @param nameProperty String The new value. 
		*/
		setNameProperty?( nameProperty?:string ): void;
		/** [Method] Sets the value of writeAllFields  
		* @param writeAllFields Boolean The new value. 
		*/
		setWriteAllFields?( writeAllFields?:boolean ): void;
		/** [Method] Prepares a Proxy s Ext data Request object  
		* @param request Ext.data.Request The request object. 
		* @returns Ext.data.Request The modified request object. 
		*/
		write?( request?:Ext.data.IRequest ): Ext.data.IRequest;
	}
}
declare module Ext.data {
	export interface IDataWriter extends Ext.IBase {
		/** [Config Option] (String) */
		nameProperty?: string;
		/** [Config Option] (Boolean) */
		writeAllFields?: boolean;
		/** [Method] Returns the value of nameProperty  
		* @returns String 
		*/
		getNameProperty?(): string;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Object The record that we are writing to the server. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:any ): any;
		/** [Method] Returns the value of writeAllFields  
		* @returns Boolean 
		*/
		getWriteAllFields?(): boolean;
		/** [Method] Sets the value of nameProperty  
		* @param nameProperty String The new value. 
		*/
		setNameProperty?( nameProperty?:string ): void;
		/** [Method] Sets the value of writeAllFields  
		* @param writeAllFields Boolean The new value. 
		*/
		setWriteAllFields?( writeAllFields?:boolean ): void;
		/** [Method] Prepares a Proxy s Ext data Request object  
		* @param request Ext.data.Request The request object. 
		* @returns Ext.data.Request The modified request object. 
		*/
		write?( request?:Ext.data.IRequest ): Ext.data.IRequest;
	}
}
declare module Ext.data {
	export interface IWriter extends Ext.IBase {
		/** [Config Option] (String) */
		nameProperty?: string;
		/** [Config Option] (Boolean) */
		writeAllFields?: boolean;
		/** [Method] Returns the value of nameProperty  
		* @returns String 
		*/
		getNameProperty?(): string;
		/** [Method] Formats the data for each record before sending it to the server  
		* @param record Object The record that we are writing to the server. 
		* @returns Object An object literal of name/value keys to be written to the server. By default this method returns the data property on the record. 
		*/
		getRecordData?( record?:any ): any;
		/** [Method] Returns the value of writeAllFields  
		* @returns Boolean 
		*/
		getWriteAllFields?(): boolean;
		/** [Method] Sets the value of nameProperty  
		* @param nameProperty String The new value. 
		*/
		setNameProperty?( nameProperty?:string ): void;
		/** [Method] Sets the value of writeAllFields  
		* @param writeAllFields Boolean The new value. 
		*/
		setWriteAllFields?( writeAllFields?:boolean ): void;
		/** [Method] Prepares a Proxy s Ext data Request object  
		* @param request Ext.data.Request The request object. 
		* @returns Ext.data.Request The modified request object. 
		*/
		write?( request?:Ext.data.IRequest ): Ext.data.IRequest;
	}
}
declare module Ext.data.writer {
	export interface IXml extends Ext.data.writer.IWriter {
		/** [Config Option] (String) */
		defaultDocumentRoot?: string;
		/** [Config Option] (String) */
		documentRoot?: string;
		/** [Config Option] (String) */
		header?: string;
		/** [Config Option] (String) */
		record?: string;
		/** [Method] Returns the value of defaultDocumentRoot  
		* @returns String 
		*/
		getDefaultDocumentRoot?(): string;
		/** [Method] Returns the value of documentRoot  
		* @returns String 
		*/
		getDocumentRoot?(): string;
		/** [Method] Returns the value of header  
		* @returns String 
		*/
		getHeader?(): string;
		/** [Method] Returns the value of record  
		* @returns String 
		*/
		getRecord?(): string;
		/** [Method] Sets the value of defaultDocumentRoot  
		* @param defaultDocumentRoot String The new value. 
		*/
		setDefaultDocumentRoot?( defaultDocumentRoot?:string ): void;
		/** [Method] Sets the value of documentRoot  
		* @param documentRoot String The new value. 
		*/
		setDocumentRoot?( documentRoot?:string ): void;
		/** [Method] Sets the value of header  
		* @param header String The new value. 
		*/
		setHeader?( header?:string ): void;
		/** [Method] Sets the value of record  
		* @param record String The new value. 
		*/
		setRecord?( record?:string ): void;
		/** [Method]  
		* @param request Object 
		* @param data Array 
		* @returns Object 
		*/
		writeRecords?( request?:any, data?:any[] ): any;
	}
}
declare module Ext.data {
	export interface IXmlWriter extends Ext.data.writer.IWriter {
		/** [Config Option] (String) */
		defaultDocumentRoot?: string;
		/** [Config Option] (String) */
		documentRoot?: string;
		/** [Config Option] (String) */
		header?: string;
		/** [Config Option] (String) */
		record?: string;
		/** [Method] Returns the value of defaultDocumentRoot  
		* @returns String 
		*/
		getDefaultDocumentRoot?(): string;
		/** [Method] Returns the value of documentRoot  
		* @returns String 
		*/
		getDocumentRoot?(): string;
		/** [Method] Returns the value of header  
		* @returns String 
		*/
		getHeader?(): string;
		/** [Method] Returns the value of record  
		* @returns String 
		*/
		getRecord?(): string;
		/** [Method] Sets the value of defaultDocumentRoot  
		* @param defaultDocumentRoot String The new value. 
		*/
		setDefaultDocumentRoot?( defaultDocumentRoot?:string ): void;
		/** [Method] Sets the value of documentRoot  
		* @param documentRoot String The new value. 
		*/
		setDocumentRoot?( documentRoot?:string ): void;
		/** [Method] Sets the value of header  
		* @param header String The new value. 
		*/
		setHeader?( header?:string ): void;
		/** [Method] Sets the value of record  
		* @param record String The new value. 
		*/
		setRecord?( record?:string ): void;
		/** [Method]  
		* @param request Object 
		* @param data Array 
		* @returns Object 
		*/
		writeRecords?( request?:any, data?:any[] ): any;
	}
}
declare module Ext.dataview.component {
	export interface IContainer extends Ext.IContainer {
		/** [Method]  */
		destroy?(): void;
	}
}
declare module Ext.dataview.component {
	export interface IDataItem extends Ext.IContainer {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Object) */
		dataMap?: any;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (String) */
		itemCls?: string;
		/** [Config Option] (Array/Object) */
		items?: any;
		/** [Config Option] (Ext.data.Model) */
		record?: Ext.data.IModel;
		/** [Config Option] (Number/String) */
		width?: any;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of dataMap  
		* @returns Object 
		*/
		getDataMap?(): any;
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of itemCls  
		* @returns String 
		*/
		getItemCls?(): string;
		/** [Method] Returns the value of items  
		* @returns Array 
		*/
		getItems?(): any[];
		/** [Method] Returns the value of record  
		* @returns Ext.data.Model 
		*/
		getRecord?(): Ext.data.IModel;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of dataMap  
		* @param dataMap Object The new value. 
		*/
		setDataMap?( dataMap?:any ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of itemCls  
		* @param itemCls String The new value. 
		*/
		setItemCls?( itemCls?:string ): void;
		/** [Method] Sets the value of items  
		* @param items Array The new value. 
		*/
		setItems?( items?:any[] ): void;
		/** [Method] Sets the value of record  
		* @param record Ext.data.Model The new value. 
		*/
		setRecord?( record?:Ext.data.IModel ): void;
		/** [Method] Sets the value of width  
		* @param width String The new value. 
		*/
		setWidth?( width?:string ): void;
	}
}
declare module Ext.dataview.component {
	export interface IListItem extends Ext.dataview.component.IDataItem {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Object) */
		dataMap?: any;
		/** [Config Option] (Array/Object) */
		items?: any;
		/** [Config Option] (String/String[]/Ext.Template/Ext.XTemplate[]) */
		tpl?: any;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of body  
		* @returns Object 
		*/
		getBody?(): any;
		/** [Method] Returns the value of dataMap  
		* @returns Object 
		*/
		getDataMap?(): any;
		/** [Method] Returns the value of disclosure  
		* @returns Object 
		*/
		getDisclosure?(): any;
		/** [Method] Returns the value of header  
		* @returns Object 
		*/
		getHeader?(): any;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of body  
		* @param body Object The new value. 
		*/
		setBody?( body?:any ): void;
		/** [Method] Sets the value of dataMap  
		* @param dataMap Object The new value. 
		*/
		setDataMap?( dataMap?:any ): void;
		/** [Method] Sets the value of disclosure  
		* @param disclosure Object The new value. 
		*/
		setDisclosure?( disclosure?:any ): void;
		/** [Method] Sets the value of header  
		* @param header Object The new value. 
		*/
		setHeader?( header?:any ): void;
		/** [Method] Sets the value of items  
		* @param items Object The new value. 
		*/
		setItems?( items?:any ): void;
		/** [Method] Sets the value of tpl  
		* @param tpl Object The new value. 
		*/
		setTpl?( tpl?:any ): void;
	}
}
declare module Ext.dataview.component {
	export interface ISimpleListItem extends Ext.IComponent {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Ext.data.Model) */
		record?: Ext.data.IModel;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of disclosure  
		* @returns Object 
		*/
		getDisclosure?(): any;
		/** [Method] Returns the value of header  
		* @returns Object 
		*/
		getHeader?(): any;
		/** [Method] Returns the value of record  
		* @returns Ext.data.Model 
		*/
		getRecord?(): Ext.data.IModel;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of disclosure  
		* @param disclosure Object The new value. 
		*/
		setDisclosure?( disclosure?:any ): void;
		/** [Method] Sets the value of header  
		* @param header Object The new value. 
		*/
		setHeader?( header?:any ): void;
		/** [Method] Sets the value of record  
		* @param record Ext.data.Model The new value. 
		*/
		setRecord?( record?:Ext.data.IModel ): void;
	}
}
declare module Ext.dataview {
	export interface IDataView extends Ext.IContainer,Ext.mixin.ISelectable {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Boolean) */
		blockRefresh?: boolean;
		/** [Config Option] (Object[]) */
		data?: any[];
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Boolean) */
		deferEmptyText?: boolean;
		/** [Config Option] (Boolean) */
		deselectOnContainerClick?: boolean;
		/** [Config Option] (String) */
		emptyText?: string;
		/** [Config Option] (Boolean/Object) */
		inline?: any;
		/** [Config Option] (String) */
		itemCls?: string;
		/** [Config Option] (Object) */
		itemConfig?: any;
		/** [Config Option] (Boolean) */
		itemSelector?: boolean;
		/** [Config Option] (String/String[]/Ext.XTemplate) */
		itemTpl?: any;
		/** [Config Option] (String/Boolean) */
		loadingText?: any;
		/** [Config Option] (Number) */
		maxItemCache?: number;
		/** [Config Option] (Boolean) */
		multiSelect?: boolean;
		/** [Config Option] (Boolean) */
		overItemCls?: boolean;
		/** [Config Option] (String) */
		pressedCls?: string;
		/** [Config Option] (Number) */
		pressedDelay?: number;
		/** [Config Option] (Boolean) */
		scrollToTopOnRefresh?: boolean;
		/** [Config Option] (Boolean/String/Object) */
		scrollable?: any;
		/** [Config Option] (String) */
		selectedCls?: string;
		/** [Config Option] (Boolean) */
		selectedItemCls?: boolean;
		/** [Config Option] (Boolean) */
		simpleSelect?: boolean;
		/** [Config Option] (Boolean) */
		singleSelect?: boolean;
		/** [Config Option] (Ext.data.Store/Object) */
		store?: any;
		/** [Config Option] (Boolean) */
		trackOver?: boolean;
		/** [Config Option] (String) */
		triggerCtEvent?: string;
		/** [Config Option] (String) */
		triggerEvent?: string;
		/** [Config Option] (Boolean) */
		useComponents?: boolean;
		/** [Method] Binds a new Store to this DataView  */
		bindStore?(): void;
		/** [Method] Deselects any currently selected records and clears all stored selections  */
		clearSelections?(): void;
		/** [Method] Function which can be overridden which returns the data object passed to this DataView s template to render the whole  */
		collectData?(): void;
		/** [Method] Deselects the given record s 
		* @param records Number/Array/Ext.data.Model The record(s) to deselect. Can also be a number to reference by index. 
		* @param suppressEvent Boolean If true the deselect event will not be fired. 
		*/
		deselect?( records?:any, suppressEvent?:boolean ): void;
		/** [Method] Deselects all records  
		* @param supress Object 
		*/
		deselectAll?( supress?:any ): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Deselects a record instance by record instance or index  
		* @param records Ext.data.Model/Number An array of records or an index. 
		* @param suppressEvent Boolean Set to false to not fire a deselect event. 
		*/
		doDeselect?( records?:any, suppressEvent?:boolean ): void;
		/** [Method] Selects a record instance by record instance or index  
		* @param records Ext.data.Model/Number An array of records or an index. 
		* @param keepExisting Boolean 
		* @param suppressEvent Boolean Set to false to not fire a select event. 
		*/
		doSelect?( records?:any, keepExisting?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Returns the template node the passed child belongs to or null if it doesn t belong to one  */
		findItemByChild?(): void;
		/** [Method] Returns the template node by the Ext EventObject or null if it is not found  */
		findTargetByEvent?(): void;
		/** [Method] Returns the value of allowDeselect  
		* @returns Boolean 
		*/
		getAllowDeselect?(): boolean;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the number of selections  
		* @returns Number 
		*/
		getCount?(): number;
		/** [Method] Returns the value of data  
		* @returns Object[] 
		*/
		getData?(): any[];
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of deferEmptyText  
		* @returns Boolean 
		*/
		getDeferEmptyText?(): boolean;
		/** [Method] Returns the value of deselectOnContainerClick  
		* @returns Boolean 
		*/
		getDeselectOnContainerClick?(): boolean;
		/** [Method] Returns the value of disableSelection  
		* @returns Boolean 
		*/
		getDisableSelection?(): boolean;
		/** [Method] Returns the value of emptyText  
		* @returns String 
		*/
		getEmptyText?(): string;
		/** [Method] Returns the value of inline  
		* @returns Boolean/Object 
		*/
		getInline?(): any;
		/** [Method] Returns an item at the specified index  
		* @param index Number Index of the item. 
		* @returns Ext.dom.Element/Ext.dataview.component.DataItem item Item at the specified index. 
		*/
		getItemAt?( index?:number ): any;
		/** [Method] Returns the value of itemCls  
		* @returns String 
		*/
		getItemCls?(): string;
		/** [Method] Returns the value of itemConfig  
		* @returns Object 
		*/
		getItemConfig?(): any;
		/** [Method] Returns an index for the specified item  
		* @param item Number The item to locate. 
		* @returns Number Index for the specified item. 
		*/
		getItemIndex?( item?:number ): number;
		/** [Method] Returns the value of itemTpl  
		* @returns String/String[]/Ext.XTemplate 
		*/
		getItemTpl?(): any;
		/** [Method] Returns the array of previously selected items  
		* @returns Array The previous selection. 
		*/
		getLastSelected?(): any[];
		/** [Method] Returns the value of loadingText  
		* @returns String/Boolean 
		*/
		getLoadingText?(): any;
		/** [Method] Returns the value of maxItemCache  
		* @returns Number 
		*/
		getMaxItemCache?(): number;
		/** [Method] Returns the value of mode  
		* @returns String 
		*/
		getMode?(): string;
		/** [Method] Gets a template node  */
		getNode?(): void;
		/** [Method] Gets a range nodes  */
		getNodes?(): void;
		/** [Method] Returns the value of pressedCls  
		* @returns String 
		*/
		getPressedCls?(): string;
		/** [Method] Returns the value of pressedDelay  
		* @returns Number 
		*/
		getPressedDelay?(): number;
		/** [Method] Gets an array of the records from an array of nodes  */
		getRecords?(): void;
		/** [Method] Returns the value of scrollToTopOnRefresh  
		* @returns Boolean 
		*/
		getScrollToTopOnRefresh?(): boolean;
		/** [Method] Returns the value of scrollable  
		* @returns Boolean 
		*/
		getScrollable?(): boolean;
		/** [Method] Returns the value of selectedCls  
		* @returns String 
		*/
		getSelectedCls?(): string;
		/** [Method] Gets the currently selected nodes  */
		getSelectedNodes?(): void;
		/** [Method] Gets an array of the selected records  */
		getSelectedRecords?(): void;
		/** [Method] Returns an array of the currently selected records  
		* @returns Array An array of selected records. 
		*/
		getSelection?(): any[];
		/** [Method] Returns the number of selections  
		* @returns Number 
		*/
		getSelectionCount?(): number;
		/** [Method] Returns the selection mode currently used by this Selectable  
		* @returns String The current mode. 
		*/
		getSelectionMode?(): string;
		/** [Method] Returns the value of store  
		* @returns Ext.data.Store/Object 
		*/
		getStore?(): any;
		/** [Method] Returns the value of triggerCtEvent  
		* @returns String 
		*/
		getTriggerCtEvent?(): string;
		/** [Method] Returns the value of triggerEvent  
		* @returns String 
		*/
		getTriggerEvent?(): string;
		/** [Method] Returns the value of useComponents  
		* @returns Boolean 
		*/
		getUseComponents?(): boolean;
		/** [Method] Returns an array of the current items in the DataView  
		* @returns Ext.dom.Element[]/Ext.dataview.component.DataItem[] Array of Items. 
		*/
		getViewItems?(): any;
		/** [Method] Method called when the Store s Reader throws an exception */
		handleException?(): void;
		/** [Method] Returns true if there is a selected record  
		* @returns Boolean 
		*/
		hasSelection?(): boolean;
		/** [Method] Finds the index of the passed node  */
		indexOf?(): void;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Returns true if the Selectable is currently locked  
		* @returns Boolean True if currently locked 
		*/
		isLocked?(): boolean;
		/** [Method] Returns true if the specified row is selected  
		* @param record Ext.data.Model/Number The record or index of the record to check. 
		* @returns Boolean 
		*/
		isSelected?( record?:any ): boolean;
		/** [Method] Function which can be overridden to provide custom formatting for each Record that is used by this DataView s templat  
		* @param data Object/Object[] The raw data object that was used to create the Record. 
		* @param index Number the index number of the Record being prepared for rendering. 
		* @param record Ext.data.Model The Record being prepared for rendering. 
		* @returns Array/Object The formatted data in a format expected by the internal template's overwrite() method. (either an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})) 
		*/
		prepareData?( data?:any, index?:number, record?:Ext.data.IModel ): any;
		/** [Method] Refreshes the view by reloading the data from the store and re rendering the template  */
		refresh?(): void;
		/** [Method] Refreshes an individual node s data from the store  */
		refreshNode?(): void;
		/** [Method] Adds the given records to the currently selected set  
		* @param records Ext.data.Model/Array/Number The records to select. 
		* @param keepExisting Boolean If true, the existing selection will be added to (if not, the old selection is replaced). 
		* @param suppressEvent Boolean If true, the select event will not be fired. 
		*/
		select?( records?:any, keepExisting?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Selects all records  
		* @param silent Boolean true to suppress all select events. 
		*/
		selectAll?( silent?:boolean ): void;
		/** [Method] Selects a range of rows if the selection model getDisableSelection is not locked  
		* @param startRecord Number The index of the first row in the range. 
		* @param endRecord Number The index of the last row in the range. 
		* @param keepExisting Boolean true to retain existing selections. 
		*/
		selectRange?( startRecord?:number, endRecord?:number, keepExisting?:boolean ): void;
		/** [Method] Sets the value of allowDeselect  
		* @param allowDeselect Boolean The new value. 
		*/
		setAllowDeselect?( allowDeselect?:boolean ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of data  
		* @param data Object[] The new value. 
		*/
		setData?( data?:any[] ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of deferEmptyText  
		* @param deferEmptyText Boolean The new value. 
		*/
		setDeferEmptyText?( deferEmptyText?:boolean ): void;
		/** [Method] Sets the value of deselectOnContainerClick  
		* @param deselectOnContainerClick Boolean The new value. 
		*/
		setDeselectOnContainerClick?( deselectOnContainerClick?:boolean ): void;
		/** [Method] Sets the value of disableSelection  
		* @param disableSelection Boolean The new value. 
		*/
		setDisableSelection?( disableSelection?:boolean ): void;
		/** [Method] Sets the value of emptyText  
		* @param emptyText String The new value. 
		*/
		setEmptyText?( emptyText?:string ): void;
		/** [Method] Sets the value of inline  
		* @param inline Boolean/Object The new value. 
		*/
		setInline?( inline?:any ): void;
		/** [Method] Sets the value of itemCls  
		* @param itemCls String The new value. 
		*/
		setItemCls?( itemCls?:string ): void;
		/** [Method] Sets the value of itemConfig  
		* @param itemConfig Object The new value. 
		*/
		setItemConfig?( itemConfig?:any ): void;
		/** [Method] Sets the value of itemTpl  
		* @param itemTpl String/String[]/Ext.XTemplate The new value. 
		*/
		setItemTpl?( itemTpl?:any ): void;
		/** [Method] This was an internal function accidentally exposed in 1 x and now deprecated  */
		setLastFocused?(): void;
		/** [Method] Sets the value of loadingText  
		* @param loadingText String/Boolean The new value. 
		*/
		setLoadingText?( loadingText?:any ): void;
		/** [Method] Sets the value of maxItemCache  
		* @param maxItemCache Number The new value. 
		*/
		setMaxItemCache?( maxItemCache?:number ): void;
		/** [Method] Sets the value of mode  
		* @param mode String The new value. 
		*/
		setMode?( mode?:string ): void;
		/** [Method] Sets the value of pressedCls  
		* @param pressedCls String The new value. 
		*/
		setPressedCls?( pressedCls?:string ): void;
		/** [Method] Sets the value of pressedDelay  
		* @param pressedDelay Number The new value. 
		*/
		setPressedDelay?( pressedDelay?:number ): void;
		/** [Method] Sets the value of scrollToTopOnRefresh  
		* @param scrollToTopOnRefresh Boolean The new value. 
		*/
		setScrollToTopOnRefresh?( scrollToTopOnRefresh?:boolean ): void;
		/** [Method] Sets the value of selectedCls  
		* @param selectedCls String The new value. 
		*/
		setSelectedCls?( selectedCls?:string ): void;
		/** [Method] Sets the value of store  
		* @param store Ext.data.Store/Object The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of triggerCtEvent  
		* @param triggerCtEvent String The new value. 
		*/
		setTriggerCtEvent?( triggerCtEvent?:string ): void;
		/** [Method] Sets the value of triggerEvent  
		* @param triggerEvent String The new value. 
		*/
		setTriggerEvent?( triggerEvent?:string ): void;
		/** [Method] Sets the value of useComponents  
		* @param useComponents Boolean The new value. 
		*/
		setUseComponents?( useComponents?:boolean ): void;
		/** [Method] Sets a record as the last focused record  
		* @param newRecord Ext.data.Record 
		* @param oldRecord Ext.data.Record 
		*/
		updateLastFocused?( newRecord?:Ext.data.IRecord, oldRecord?:Ext.data.IRecord ): void;
	}
}
declare module Ext {
	export interface IDataView extends Ext.IContainer,Ext.mixin.ISelectable {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (Boolean) */
		blockRefresh?: boolean;
		/** [Config Option] (Object[]) */
		data?: any[];
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (Boolean) */
		deferEmptyText?: boolean;
		/** [Config Option] (Boolean) */
		deselectOnContainerClick?: boolean;
		/** [Config Option] (String) */
		emptyText?: string;
		/** [Config Option] (Boolean/Object) */
		inline?: any;
		/** [Config Option] (String) */
		itemCls?: string;
		/** [Config Option] (Object) */
		itemConfig?: any;
		/** [Config Option] (Boolean) */
		itemSelector?: boolean;
		/** [Config Option] (String/String[]/Ext.XTemplate) */
		itemTpl?: any;
		/** [Config Option] (String/Boolean) */
		loadingText?: any;
		/** [Config Option] (Number) */
		maxItemCache?: number;
		/** [Config Option] (Boolean) */
		multiSelect?: boolean;
		/** [Config Option] (Boolean) */
		overItemCls?: boolean;
		/** [Config Option] (String) */
		pressedCls?: string;
		/** [Config Option] (Number) */
		pressedDelay?: number;
		/** [Config Option] (Boolean) */
		scrollToTopOnRefresh?: boolean;
		/** [Config Option] (Boolean/String/Object) */
		scrollable?: any;
		/** [Config Option] (String) */
		selectedCls?: string;
		/** [Config Option] (Boolean) */
		selectedItemCls?: boolean;
		/** [Config Option] (Boolean) */
		simpleSelect?: boolean;
		/** [Config Option] (Boolean) */
		singleSelect?: boolean;
		/** [Config Option] (Ext.data.Store/Object) */
		store?: any;
		/** [Config Option] (Boolean) */
		trackOver?: boolean;
		/** [Config Option] (String) */
		triggerCtEvent?: string;
		/** [Config Option] (String) */
		triggerEvent?: string;
		/** [Config Option] (Boolean) */
		useComponents?: boolean;
		/** [Method] Binds a new Store to this DataView  */
		bindStore?(): void;
		/** [Method] Deselects any currently selected records and clears all stored selections  */
		clearSelections?(): void;
		/** [Method] Function which can be overridden which returns the data object passed to this DataView s template to render the whole  */
		collectData?(): void;
		/** [Method] Deselects the given record s 
		* @param records Number/Array/Ext.data.Model The record(s) to deselect. Can also be a number to reference by index. 
		* @param suppressEvent Boolean If true the deselect event will not be fired. 
		*/
		deselect?( records?:any, suppressEvent?:boolean ): void;
		/** [Method] Deselects all records  
		* @param supress Object 
		*/
		deselectAll?( supress?:any ): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Deselects a record instance by record instance or index  
		* @param records Ext.data.Model/Number An array of records or an index. 
		* @param suppressEvent Boolean Set to false to not fire a deselect event. 
		*/
		doDeselect?( records?:any, suppressEvent?:boolean ): void;
		/** [Method] Selects a record instance by record instance or index  
		* @param records Ext.data.Model/Number An array of records or an index. 
		* @param keepExisting Boolean 
		* @param suppressEvent Boolean Set to false to not fire a select event. 
		*/
		doSelect?( records?:any, keepExisting?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Returns the template node the passed child belongs to or null if it doesn t belong to one  */
		findItemByChild?(): void;
		/** [Method] Returns the template node by the Ext EventObject or null if it is not found  */
		findTargetByEvent?(): void;
		/** [Method] Returns the value of allowDeselect  
		* @returns Boolean 
		*/
		getAllowDeselect?(): boolean;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the number of selections  
		* @returns Number 
		*/
		getCount?(): number;
		/** [Method] Returns the value of data  
		* @returns Object[] 
		*/
		getData?(): any[];
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of deferEmptyText  
		* @returns Boolean 
		*/
		getDeferEmptyText?(): boolean;
		/** [Method] Returns the value of deselectOnContainerClick  
		* @returns Boolean 
		*/
		getDeselectOnContainerClick?(): boolean;
		/** [Method] Returns the value of disableSelection  
		* @returns Boolean 
		*/
		getDisableSelection?(): boolean;
		/** [Method] Returns the value of emptyText  
		* @returns String 
		*/
		getEmptyText?(): string;
		/** [Method] Returns the value of inline  
		* @returns Boolean/Object 
		*/
		getInline?(): any;
		/** [Method] Returns an item at the specified index  
		* @param index Number Index of the item. 
		* @returns Ext.dom.Element/Ext.dataview.component.DataItem item Item at the specified index. 
		*/
		getItemAt?( index?:number ): any;
		/** [Method] Returns the value of itemCls  
		* @returns String 
		*/
		getItemCls?(): string;
		/** [Method] Returns the value of itemConfig  
		* @returns Object 
		*/
		getItemConfig?(): any;
		/** [Method] Returns an index for the specified item  
		* @param item Number The item to locate. 
		* @returns Number Index for the specified item. 
		*/
		getItemIndex?( item?:number ): number;
		/** [Method] Returns the value of itemTpl  
		* @returns String/String[]/Ext.XTemplate 
		*/
		getItemTpl?(): any;
		/** [Method] Returns the array of previously selected items  
		* @returns Array The previous selection. 
		*/
		getLastSelected?(): any[];
		/** [Method] Returns the value of loadingText  
		* @returns String/Boolean 
		*/
		getLoadingText?(): any;
		/** [Method] Returns the value of maxItemCache  
		* @returns Number 
		*/
		getMaxItemCache?(): number;
		/** [Method] Returns the value of mode  
		* @returns String 
		*/
		getMode?(): string;
		/** [Method] Gets a template node  */
		getNode?(): void;
		/** [Method] Gets a range nodes  */
		getNodes?(): void;
		/** [Method] Returns the value of pressedCls  
		* @returns String 
		*/
		getPressedCls?(): string;
		/** [Method] Returns the value of pressedDelay  
		* @returns Number 
		*/
		getPressedDelay?(): number;
		/** [Method] Gets an array of the records from an array of nodes  */
		getRecords?(): void;
		/** [Method] Returns the value of scrollToTopOnRefresh  
		* @returns Boolean 
		*/
		getScrollToTopOnRefresh?(): boolean;
		/** [Method] Returns the value of scrollable  
		* @returns Boolean 
		*/
		getScrollable?(): boolean;
		/** [Method] Returns the value of selectedCls  
		* @returns String 
		*/
		getSelectedCls?(): string;
		/** [Method] Gets the currently selected nodes  */
		getSelectedNodes?(): void;
		/** [Method] Gets an array of the selected records  */
		getSelectedRecords?(): void;
		/** [Method] Returns an array of the currently selected records  
		* @returns Array An array of selected records. 
		*/
		getSelection?(): any[];
		/** [Method] Returns the number of selections  
		* @returns Number 
		*/
		getSelectionCount?(): number;
		/** [Method] Returns the selection mode currently used by this Selectable  
		* @returns String The current mode. 
		*/
		getSelectionMode?(): string;
		/** [Method] Returns the value of store  
		* @returns Ext.data.Store/Object 
		*/
		getStore?(): any;
		/** [Method] Returns the value of triggerCtEvent  
		* @returns String 
		*/
		getTriggerCtEvent?(): string;
		/** [Method] Returns the value of triggerEvent  
		* @returns String 
		*/
		getTriggerEvent?(): string;
		/** [Method] Returns the value of useComponents  
		* @returns Boolean 
		*/
		getUseComponents?(): boolean;
		/** [Method] Returns an array of the current items in the DataView  
		* @returns Ext.dom.Element[]/Ext.dataview.component.DataItem[] Array of Items. 
		*/
		getViewItems?(): any;
		/** [Method] Method called when the Store s Reader throws an exception */
		handleException?(): void;
		/** [Method] Returns true if there is a selected record  
		* @returns Boolean 
		*/
		hasSelection?(): boolean;
		/** [Method] Finds the index of the passed node  */
		indexOf?(): void;
		/** [Method] Allows addition of behavior to the rendering phase  */
		initialize?(): void;
		/** [Method] Returns true if the Selectable is currently locked  
		* @returns Boolean True if currently locked 
		*/
		isLocked?(): boolean;
		/** [Method] Returns true if the specified row is selected  
		* @param record Ext.data.Model/Number The record or index of the record to check. 
		* @returns Boolean 
		*/
		isSelected?( record?:any ): boolean;
		/** [Method] Function which can be overridden to provide custom formatting for each Record that is used by this DataView s templat  
		* @param data Object/Object[] The raw data object that was used to create the Record. 
		* @param index Number the index number of the Record being prepared for rendering. 
		* @param record Ext.data.Model The Record being prepared for rendering. 
		* @returns Array/Object The formatted data in a format expected by the internal template's overwrite() method. (either an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})) 
		*/
		prepareData?( data?:any, index?:number, record?:Ext.data.IModel ): any;
		/** [Method] Refreshes the view by reloading the data from the store and re rendering the template  */
		refresh?(): void;
		/** [Method] Refreshes an individual node s data from the store  */
		refreshNode?(): void;
		/** [Method] Adds the given records to the currently selected set  
		* @param records Ext.data.Model/Array/Number The records to select. 
		* @param keepExisting Boolean If true, the existing selection will be added to (if not, the old selection is replaced). 
		* @param suppressEvent Boolean If true, the select event will not be fired. 
		*/
		select?( records?:any, keepExisting?:boolean, suppressEvent?:boolean ): void;
		/** [Method] Selects all records  
		* @param silent Boolean true to suppress all select events. 
		*/
		selectAll?( silent?:boolean ): void;
		/** [Method] Selects a range of rows if the selection model getDisableSelection is not locked  
		* @param startRecord Number The index of the first row in the range. 
		* @param endRecord Number The index of the last row in the range. 
		* @param keepExisting Boolean true to retain existing selections. 
		*/
		selectRange?( startRecord?:number, endRecord?:number, keepExisting?:boolean ): void;
		/** [Method] Sets the value of allowDeselect  
		* @param allowDeselect Boolean The new value. 
		*/
		setAllowDeselect?( allowDeselect?:boolean ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of data  
		* @param data Object[] The new value. 
		*/
		setData?( data?:any[] ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of deferEmptyText  
		* @param deferEmptyText Boolean The new value. 
		*/
		setDeferEmptyText?( deferEmptyText?:boolean ): void;
		/** [Method] Sets the value of deselectOnContainerClick  
		* @param deselectOnContainerClick Boolean The new value. 
		*/
		setDeselectOnContainerClick?( deselectOnContainerClick?:boolean ): void;
		/** [Method] Sets the value of disableSelection  
		* @param disableSelection Boolean The new value. 
		*/
		setDisableSelection?( disableSelection?:boolean ): void;
		/** [Method] Sets the value of emptyText  
		* @param emptyText String The new value. 
		*/
		setEmptyText?( emptyText?:string ): void;
		/** [Method] Sets the value of inline  
		* @param inline Boolean/Object The new value. 
		*/
		setInline?( inline?:any ): void;
		/** [Method] Sets the value of itemCls  
		* @param itemCls String The new value. 
		*/
		setItemCls?( itemCls?:string ): void;
		/** [Method] Sets the value of itemConfig  
		* @param itemConfig Object The new value. 
		*/
		setItemConfig?( itemConfig?:any ): void;
		/** [Method] Sets the value of itemTpl  
		* @param itemTpl String/String[]/Ext.XTemplate The new value. 
		*/
		setItemTpl?( itemTpl?:any ): void;
		/** [Method] This was an internal function accidentally exposed in 1 x and now deprecated  */
		setLastFocused?(): void;
		/** [Method] Sets the value of loadingText  
		* @param loadingText String/Boolean The new value. 
		*/
		setLoadingText?( loadingText?:any ): void;
		/** [Method] Sets the value of maxItemCache  
		* @param maxItemCache Number The new value. 
		*/
		setMaxItemCache?( maxItemCache?:number ): void;
		/** [Method] Sets the value of mode  
		* @param mode String The new value. 
		*/
		setMode?( mode?:string ): void;
		/** [Method] Sets the value of pressedCls  
		* @param pressedCls String The new value. 
		*/
		setPressedCls?( pressedCls?:string ): void;
		/** [Method] Sets the value of pressedDelay  
		* @param pressedDelay Number The new value. 
		*/
		setPressedDelay?( pressedDelay?:number ): void;
		/** [Method] Sets the value of scrollToTopOnRefresh  
		* @param scrollToTopOnRefresh Boolean The new value. 
		*/
		setScrollToTopOnRefresh?( scrollToTopOnRefresh?:boolean ): void;
		/** [Method] Sets the value of selectedCls  
		* @param selectedCls String The new value. 
		*/
		setSelectedCls?( selectedCls?:string ): void;
		/** [Method] Sets the value of store  
		* @param store Ext.data.Store/Object The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of triggerCtEvent  
		* @param triggerCtEvent String The new value. 
		*/
		setTriggerCtEvent?( triggerCtEvent?:string ): void;
		/** [Method] Sets the value of triggerEvent  
		* @param triggerEvent String The new value. 
		*/
		setTriggerEvent?( triggerEvent?:string ): void;
		/** [Method] Sets the value of useComponents  
		* @param useComponents Boolean The new value. 
		*/
		setUseComponents?( useComponents?:boolean ): void;
		/** [Method] Sets a record as the last focused record  
		* @param newRecord Ext.data.Record 
		* @param oldRecord Ext.data.Record 
		*/
		updateLastFocused?( newRecord?:Ext.data.IRecord, oldRecord?:Ext.data.IRecord ): void;
	}
}
declare module Ext.dataview.element {
	export interface IContainer extends Ext.IComponent {
		/** [Method] Destroys this Component  */
		destroy?(): void;
	}
}
declare module Ext.dataview.element {
	export interface IList extends Ext.dataview.element.IContainer {
		/** [Method] Destroys this Component  */
		destroy?(): void;
	}
}
declare module Ext.dataview {
	export interface IIndexBar extends Ext.IComponent {
		/** [Config Option] (Boolean) */
		alphabet?: boolean;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String) */
		direction?: string;
		/** [Config Option] (Boolean) */
		itemSelector?: boolean;
		/** [Config Option] (Array) */
		letters?: any[];
		/** [Config Option] (String) */
		listPrefix?: string;
		/** [Config Option] (Boolean) */
		store?: boolean;
		/** [Config Option] (String) */
		ui?: string;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of direction  
		* @returns String 
		*/
		getDirection?(): string;
		/** [Method] Returns the value of letters  
		* @returns Array 
		*/
		getLetters?(): any[];
		/** [Method] Returns the value of listPrefix  
		* @returns String 
		*/
		getListPrefix?(): string;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns true when direction is horizontal  */
		isHorizontal?(): void;
		/** [Method] Returns true when direction is vertical  */
		isVertical?(): void;
		/** [Method] Refreshes the view by reloading the data from the store and re rendering the template  */
		refresh?(): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of direction  
		* @param direction String The new value. 
		*/
		setDirection?( direction?:string ): void;
		/** [Method] Sets the value of letters  
		* @param letters Array The new value. 
		*/
		setLetters?( letters?:any[] ): void;
		/** [Method] Sets the value of listPrefix  
		* @param listPrefix String The new value. 
		*/
		setListPrefix?( listPrefix?:string ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
	}
}
declare module Ext {
	export interface IIndexBar extends Ext.IComponent {
		/** [Config Option] (Boolean) */
		alphabet?: boolean;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String) */
		direction?: string;
		/** [Config Option] (Boolean) */
		itemSelector?: boolean;
		/** [Config Option] (Array) */
		letters?: any[];
		/** [Config Option] (String) */
		listPrefix?: string;
		/** [Config Option] (Boolean) */
		store?: boolean;
		/** [Config Option] (String) */
		ui?: string;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of direction  
		* @returns String 
		*/
		getDirection?(): string;
		/** [Method] Returns the value of letters  
		* @returns Array 
		*/
		getLetters?(): any[];
		/** [Method] Returns the value of listPrefix  
		* @returns String 
		*/
		getListPrefix?(): string;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns true when direction is horizontal  */
		isHorizontal?(): void;
		/** [Method] Returns true when direction is vertical  */
		isVertical?(): void;
		/** [Method] Refreshes the view by reloading the data from the store and re rendering the template  */
		refresh?(): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of direction  
		* @param direction String The new value. 
		*/
		setDirection?( direction?:string ): void;
		/** [Method] Sets the value of letters  
		* @param letters Array The new value. 
		*/
		setLetters?( letters?:any[] ): void;
		/** [Method] Sets the value of listPrefix  
		* @param listPrefix String The new value. 
		*/
		setListPrefix?( listPrefix?:string ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
	}
}
declare module Ext.dataview {
	export interface IList extends Ext.dataview.IDataView,Ext.mixin.IBindable {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (String) */
		disclosureProperty?: string;
		/** [Config Option] (Boolean) */
		grouped?: boolean;
		/** [Config Option] (Boolean/Object) */
		indexBar?: any;
		/** [Config Option] (Boolean) */
		infinite?: boolean;
		/** [Config Option] (Number) */
		itemHeight?: number;
		/** [Config Option] (Boolean/Function/Object) */
		onItemDisclosure?: any;
		/** [Config Option] (Boolean) */
		pinHeaders?: boolean;
		/** [Config Option] (Boolean) */
		preventSelectionOnDisclose?: boolean;
		/** [Config Option] (Boolean) */
		refreshHeightOnUpdate?: boolean;
		/** [Config Option] (Boolean) */
		striped?: boolean;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Boolean) */
		useSimpleItems?: boolean;
		/** [Config Option] (Boolean) */
		variableHeights?: boolean;
		/** [Property] (Number) */
		bufferSize?: number;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of disclosureProperty  
		* @returns String 
		*/
		getDisclosureProperty?(): string;
		/** [Method] Returns the value of grouped  
		* @returns Boolean 
		*/
		getGrouped?(): boolean;
		/** [Method] Returns the value of icon  
		* @returns Object 
		*/
		getIcon?(): any;
		/** [Method] Returns the value of indexBar  
		* @returns Boolean/Object 
		*/
		getIndexBar?(): any;
		/** [Method] Returns the value of infinite  
		* @returns Boolean 
		*/
		getInfinite?(): boolean;
		/** [Method] Returns an item at the specified index  
		* @param index Number Index of the item. 
		* @returns Ext.dom.Element/Ext.dataview.component.DataItem item Item at the specified index. 
		*/
		getItemAt?( index?:number ): any;
		/** [Method] Returns the value of itemHeight  
		* @returns Number 
		*/
		getItemHeight?(): number;
		/** [Method] Returns an index for the specified item  
		* @param item Number The item to locate. 
		* @returns Number Index for the specified item. 
		*/
		getItemIndex?( item?:number ): number;
		/** [Method] Returns the value of minimumBufferDistance  
		* @returns Number 
		*/
		getMinimumBufferDistance?(): number;
		/** [Method] Returns the value of onItemDisclosure  
		* @returns Boolean/Function/Object 
		*/
		getOnItemDisclosure?(): any;
		/** [Method] Returns the value of pinHeaders  
		* @returns Boolean 
		*/
		getPinHeaders?(): boolean;
		/** [Method] Returns the value of preventSelectionOnDisclose  
		* @returns Boolean 
		*/
		getPreventSelectionOnDisclose?(): boolean;
		/** [Method] Returns the value of refreshHeightOnUpdate  
		* @returns Boolean 
		*/
		getRefreshHeightOnUpdate?(): boolean;
		/** [Method] Returns all the items that are docked in the scroller in this list  
		* @returns Array An array of the scrollDock items 
		*/
		getScrollDockedItems?(): any[];
		/** [Method] Returns the value of striped  
		* @returns Boolean 
		*/
		getStriped?(): boolean;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns the value of useHeaders  
		* @returns Boolean 
		*/
		getUseHeaders?(): boolean;
		/** [Method] Returns the value of useSimpleItems  
		* @returns Boolean 
		*/
		getUseSimpleItems?(): boolean;
		/** [Method] Returns the value of variableHeights  
		* @returns Boolean 
		*/
		getVariableHeights?(): boolean;
		/** [Method] Returns an array of the current items in the DataView  
		* @returns Ext.dom.Element[]/Ext.dataview.component.DataItem[] Array of Items. 
		*/
		getViewItems?(): any;
		/** [Method] We override DataView s initialize method with an empty function */
		initialize?(): void;
		/** [Method] Scrolls the list so that the specified record is at the top  
		* @param record Object {Ext.data.Model} Record in the lists store to scroll to 
		* @param animate Object {Boolean} Determines if scrolling is animated to a cut 
		* @param overscroll Object {Boolean} Determines if list can be overscrolled 
		*/
		scrollToRecord?( record?:any, animate?:any, overscroll?:any ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of disclosureProperty  
		* @param disclosureProperty String The new value. 
		*/
		setDisclosureProperty?( disclosureProperty?:string ): void;
		/** [Method] Sets the value of grouped  
		* @param grouped Boolean The new value. 
		*/
		setGrouped?( grouped?:boolean ): void;
		/** [Method] Sets the value of icon  
		* @param icon Object The new value. 
		*/
		setIcon?( icon?:any ): void;
		/** [Method] Sets the value of indexBar  
		* @param indexBar Boolean/Object The new value. 
		*/
		setIndexBar?( indexBar?:any ): void;
		/** [Method] Sets the value of infinite  
		* @param infinite Boolean The new value. 
		*/
		setInfinite?( infinite?:boolean ): void;
		/** [Method] Sets the value of itemHeight  
		* @param itemHeight Number The new value. 
		*/
		setItemHeight?( itemHeight?:number ): void;
		/** [Method] Sets the value of minimumBufferDistance  
		* @param minimumBufferDistance Number The new value. 
		*/
		setMinimumBufferDistance?( minimumBufferDistance?:number ): void;
		/** [Method] Sets the value of onItemDisclosure  
		* @param onItemDisclosure Boolean/Function/Object The new value. 
		*/
		setOnItemDisclosure?( onItemDisclosure?:any ): void;
		/** [Method] Sets the value of pinHeaders  
		* @param pinHeaders Boolean The new value. 
		*/
		setPinHeaders?( pinHeaders?:boolean ): void;
		/** [Method] Sets the value of preventSelectionOnDisclose  
		* @param preventSelectionOnDisclose Boolean The new value. 
		*/
		setPreventSelectionOnDisclose?( preventSelectionOnDisclose?:boolean ): void;
		/** [Method] Sets the value of refreshHeightOnUpdate  
		* @param refreshHeightOnUpdate Boolean The new value. 
		*/
		setRefreshHeightOnUpdate?( refreshHeightOnUpdate?:boolean ): void;
		/** [Method] Sets the value of striped  
		* @param striped Boolean The new value. 
		*/
		setStriped?( striped?:boolean ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
		/** [Method] Sets the value of useHeaders  
		* @param useHeaders Boolean The new value. 
		*/
		setUseHeaders?( useHeaders?:boolean ): void;
		/** [Method] Sets the value of useSimpleItems  
		* @param useSimpleItems Boolean The new value. 
		*/
		setUseSimpleItems?( useSimpleItems?:boolean ): void;
		/** [Method] Sets the value of variableHeights  
		* @param variableHeights Boolean The new value. 
		*/
		setVariableHeights?( variableHeights?:boolean ): void;
	}
}
declare module Ext {
	export interface IList extends Ext.dataview.IDataView,Ext.mixin.IBindable {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String) */
		defaultType?: string;
		/** [Config Option] (String) */
		disclosureProperty?: string;
		/** [Config Option] (Boolean) */
		grouped?: boolean;
		/** [Config Option] (Boolean/Object) */
		indexBar?: any;
		/** [Config Option] (Boolean) */
		infinite?: boolean;
		/** [Config Option] (Number) */
		itemHeight?: number;
		/** [Config Option] (Boolean/Function/Object) */
		onItemDisclosure?: any;
		/** [Config Option] (Boolean) */
		pinHeaders?: boolean;
		/** [Config Option] (Boolean) */
		preventSelectionOnDisclose?: boolean;
		/** [Config Option] (Boolean) */
		refreshHeightOnUpdate?: boolean;
		/** [Config Option] (Boolean) */
		striped?: boolean;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Boolean) */
		useSimpleItems?: boolean;
		/** [Config Option] (Boolean) */
		variableHeights?: boolean;
		/** [Property] (Number) */
		bufferSize?: number;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of defaultType  
		* @returns String 
		*/
		getDefaultType?(): string;
		/** [Method] Returns the value of disclosureProperty  
		* @returns String 
		*/
		getDisclosureProperty?(): string;
		/** [Method] Returns the value of grouped  
		* @returns Boolean 
		*/
		getGrouped?(): boolean;
		/** [Method] Returns the value of icon  
		* @returns Object 
		*/
		getIcon?(): any;
		/** [Method] Returns the value of indexBar  
		* @returns Boolean/Object 
		*/
		getIndexBar?(): any;
		/** [Method] Returns the value of infinite  
		* @returns Boolean 
		*/
		getInfinite?(): boolean;
		/** [Method] Returns an item at the specified index  
		* @param index Number Index of the item. 
		* @returns Ext.dom.Element/Ext.dataview.component.DataItem item Item at the specified index. 
		*/
		getItemAt?( index?:number ): any;
		/** [Method] Returns the value of itemHeight  
		* @returns Number 
		*/
		getItemHeight?(): number;
		/** [Method] Returns an index for the specified item  
		* @param item Number The item to locate. 
		* @returns Number Index for the specified item. 
		*/
		getItemIndex?( item?:number ): number;
		/** [Method] Returns the value of minimumBufferDistance  
		* @returns Number 
		*/
		getMinimumBufferDistance?(): number;
		/** [Method] Returns the value of onItemDisclosure  
		* @returns Boolean/Function/Object 
		*/
		getOnItemDisclosure?(): any;
		/** [Method] Returns the value of pinHeaders  
		* @returns Boolean 
		*/
		getPinHeaders?(): boolean;
		/** [Method] Returns the value of preventSelectionOnDisclose  
		* @returns Boolean 
		*/
		getPreventSelectionOnDisclose?(): boolean;
		/** [Method] Returns the value of refreshHeightOnUpdate  
		* @returns Boolean 
		*/
		getRefreshHeightOnUpdate?(): boolean;
		/** [Method] Returns all the items that are docked in the scroller in this list  
		* @returns Array An array of the scrollDock items 
		*/
		getScrollDockedItems?(): any[];
		/** [Method] Returns the value of striped  
		* @returns Boolean 
		*/
		getStriped?(): boolean;
		/** [Method] Returns the value of ui  
		* @returns String 
		*/
		getUi?(): string;
		/** [Method] Returns the value of useHeaders  
		* @returns Boolean 
		*/
		getUseHeaders?(): boolean;
		/** [Method] Returns the value of useSimpleItems  
		* @returns Boolean 
		*/
		getUseSimpleItems?(): boolean;
		/** [Method] Returns the value of variableHeights  
		* @returns Boolean 
		*/
		getVariableHeights?(): boolean;
		/** [Method] Returns an array of the current items in the DataView  
		* @returns Ext.dom.Element[]/Ext.dataview.component.DataItem[] Array of Items. 
		*/
		getViewItems?(): any;
		/** [Method] We override DataView s initialize method with an empty function */
		initialize?(): void;
		/** [Method] Scrolls the list so that the specified record is at the top  
		* @param record Object {Ext.data.Model} Record in the lists store to scroll to 
		* @param animate Object {Boolean} Determines if scrolling is animated to a cut 
		* @param overscroll Object {Boolean} Determines if list can be overscrolled 
		*/
		scrollToRecord?( record?:any, animate?:any, overscroll?:any ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of defaultType  
		* @param defaultType String The new value. 
		*/
		setDefaultType?( defaultType?:string ): void;
		/** [Method] Sets the value of disclosureProperty  
		* @param disclosureProperty String The new value. 
		*/
		setDisclosureProperty?( disclosureProperty?:string ): void;
		/** [Method] Sets the value of grouped  
		* @param grouped Boolean The new value. 
		*/
		setGrouped?( grouped?:boolean ): void;
		/** [Method] Sets the value of icon  
		* @param icon Object The new value. 
		*/
		setIcon?( icon?:any ): void;
		/** [Method] Sets the value of indexBar  
		* @param indexBar Boolean/Object The new value. 
		*/
		setIndexBar?( indexBar?:any ): void;
		/** [Method] Sets the value of infinite  
		* @param infinite Boolean The new value. 
		*/
		setInfinite?( infinite?:boolean ): void;
		/** [Method] Sets the value of itemHeight  
		* @param itemHeight Number The new value. 
		*/
		setItemHeight?( itemHeight?:number ): void;
		/** [Method] Sets the value of minimumBufferDistance  
		* @param minimumBufferDistance Number The new value. 
		*/
		setMinimumBufferDistance?( minimumBufferDistance?:number ): void;
		/** [Method] Sets the value of onItemDisclosure  
		* @param onItemDisclosure Boolean/Function/Object The new value. 
		*/
		setOnItemDisclosure?( onItemDisclosure?:any ): void;
		/** [Method] Sets the value of pinHeaders  
		* @param pinHeaders Boolean The new value. 
		*/
		setPinHeaders?( pinHeaders?:boolean ): void;
		/** [Method] Sets the value of preventSelectionOnDisclose  
		* @param preventSelectionOnDisclose Boolean The new value. 
		*/
		setPreventSelectionOnDisclose?( preventSelectionOnDisclose?:boolean ): void;
		/** [Method] Sets the value of refreshHeightOnUpdate  
		* @param refreshHeightOnUpdate Boolean The new value. 
		*/
		setRefreshHeightOnUpdate?( refreshHeightOnUpdate?:boolean ): void;
		/** [Method] Sets the value of striped  
		* @param striped Boolean The new value. 
		*/
		setStriped?( striped?:boolean ): void;
		/** [Method] Sets the value of ui  
		* @param ui String The new value. 
		*/
		setUi?( ui?:string ): void;
		/** [Method] Sets the value of useHeaders  
		* @param useHeaders Boolean The new value. 
		*/
		setUseHeaders?( useHeaders?:boolean ): void;
		/** [Method] Sets the value of useSimpleItems  
		* @param useSimpleItems Boolean The new value. 
		*/
		setUseSimpleItems?( useSimpleItems?:boolean ): void;
		/** [Method] Sets the value of variableHeights  
		* @param variableHeights Boolean The new value. 
		*/
		setVariableHeights?( variableHeights?:boolean ): void;
	}
}
declare module Ext.dataview {
	export interface IListItemHeader extends Ext.IComponent {
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
	}
}
declare module Ext.dataview {
	export interface INestedList extends Ext.IContainer {
		/** [Config Option] (Boolean) */
		allowDeselect?: boolean;
		/** [Config Option] (Object) */
		backButton?: any;
		/** [Config Option] (String) */
		backText?: string;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String/Object/Boolean) */
		cardSwitchAnimation?: any;
		/** [Config Option] (Number) */
		clearSelectionDelay?: number;
		/** [Config Option] (Ext.Component) */
		detailCard?: Ext.IComponent;
		/** [Config Option] (Ext.Container) */
		detailContainer?: Ext.IContainer;
		/** [Config Option] (String) */
		displayField?: string;
		/** [Config Option] (String) */
		emptyText?: string;
		/** [Config Option] (Number) */
		itemHeight?: number;
		/** [Config Option] (Object) */
		listConfig?: any;
		/** [Config Option] (String) */
		loadingText?: string;
		/** [Config Option] (Boolean/Function) */
		onItemDisclosure?: any;
		/** [Config Option] (Ext.data.TreeStore/String) */
		store?: any;
		/** [Config Option] (String) */
		title?: string;
		/** [Config Option] (Ext.Toolbar/Object/Boolean) */
		toolbar?: any;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Boolean) */
		updateTitleText?: boolean;
		/** [Config Option] (Boolean) */
		useSimpleItems?: boolean;
		/** [Config Option] (Boolean) */
		useTitleAsBackText?: boolean;
		/** [Config Option] (Boolean) */
		useToolbar?: boolean;
		/** [Config Option] (Boolean) */
		variableHeights?: boolean;
		/** [Method] Returns the value of allowDeselect  
		* @returns Boolean 
		*/
		getAllowDeselect?(): boolean;
		/** [Method] Returns the value of backButton  
		* @returns Object 
		*/
		getBackButton?(): any;
		/** [Method] Returns the value of backText  
		* @returns String 
		*/
		getBackText?(): string;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of clearSelectionOnListChange  
		* @returns Boolean 
		*/
		getClearSelectionOnListChange?(): boolean;
		/** [Method] Returns the value of detailCard  
		* @returns Ext.Component 
		*/
		getDetailCard?(): Ext.IComponent;
		/** [Method] Returns the value of detailContainer  
		* @returns Ext.Container 
		*/
		getDetailContainer?(): Ext.IContainer;
		/** [Method] Returns the value of displayField  
		* @returns String 
		*/
		getDisplayField?(): string;
		/** [Method] Returns the value of emptyText  
		* @returns String 
		*/
		getEmptyText?(): string;
		/** [Method] Returns the value of itemHeight  
		* @returns Number 
		*/
		getItemHeight?(): number;
		/** [Method] Override this method to provide custom template rendering of individual nodes  
		* @param node Ext.data.Record 
		* @returns String 
		*/
		getItemTextTpl?( node?:Ext.data.IRecord ): string;
		/** [Method] Returns the value of listConfig  
		* @returns Object 
		*/
		getListConfig?(): any;
		/** [Method] Returns the value of loadingText  
		* @returns String 
		*/
		getLoadingText?(): string;
		/** [Method] Returns the value of onItemDisclosure  
		* @returns Boolean/Function 
		*/
		getOnItemDisclosure?(): any;
		/** [Method] Returns the value of store  
		* @returns Ext.data.TreeStore/String 
		*/
		getStore?(): any;
		/** [Method] Returns the subList for a specified node  */
		getSubList?(): void;
		/** [Method] Returns the value of title  
		* @returns String 
		*/
		getTitle?(): string;
		/** [Method] Override this method to provide custom template rendering of titles back buttons when useTitleAsBackText is enabled  
		* @param node Ext.data.Record 
		* @returns String 
		*/
		getTitleTextTpl?( node?:Ext.data.IRecord ): string;
		/** [Method] Returns the value of toolbar  
		* @returns Ext.Toolbar/Object/Boolean 
		*/
		getToolbar?(): any;
		/** [Method] Returns the value of updateTitleText  
		* @returns Boolean 
		*/
		getUpdateTitleText?(): boolean;
		/** [Method] Returns the value of useSimpleItems  
		* @returns Boolean 
		*/
		getUseSimpleItems?(): boolean;
		/** [Method] Returns the value of useTitleAsBackText  
		* @returns Boolean 
		*/
		getUseTitleAsBackText?(): boolean;
		/** [Method] Returns the value of useToolbar  
		* @returns Boolean 
		*/
		getUseToolbar?(): boolean;
		/** [Method] Returns the value of variableHeights  
		* @returns Boolean 
		*/
		getVariableHeights?(): boolean;
		/** [Method] The leaf you want to navigate to  
		* @param node Ext.data.NodeInterface The specified node to navigate to. 
		*/
		goToLeaf?( node?:Ext.data.INodeInterface ): void;
		/** [Method] Method to handle going to a specific node within this nested list  
		* @param node Ext.data.NodeInterface The specified node to navigate to. 
		*/
		goToNode?( node?:Ext.data.INodeInterface ): void;
		/** [Method] Called when the backButton has been tapped  */
		onBackTap?(): void;
		/** [Method] Called when an list item has been tapped  
		* @param list Ext.List The subList the item is on. 
		* @param index Number The id of the item tapped. 
		* @param target Ext.Element The list item tapped. 
		* @param record Ext.data.Record The record which as tapped. 
		* @param e Ext.event.Event The event. 
		*/
		onItemTap?( list?:Ext.IList, index?:number, target?:Ext.IElement, record?:Ext.data.IRecord, e?:Ext.event.IEvent ): void;
		/** [Method] Sets the value of allowDeselect  
		* @param allowDeselect Boolean The new value. 
		*/
		setAllowDeselect?( allowDeselect?:boolean ): void;
		/** [Method] Sets the value of backButton  
		* @param backButton Object The new value. 
		*/
		setBackButton?( backButton?:any ): void;
		/** [Method] Sets the value of backText  
		* @param backText String The new value. 
		*/
		setBackText?( backText?:string ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of clearSelectionOnListChange  
		* @param clearSelectionOnListChange Boolean The new value. 
		*/
		setClearSelectionOnListChange?( clearSelectionOnListChange?:boolean ): void;
		/** [Method] Sets the value of detailCard  
		* @param detailCard Ext.Component The new value. 
		*/
		setDetailCard?( detailCard?:Ext.IComponent ): void;
		/** [Method] Sets the value of detailContainer  
		* @param detailContainer Ext.Container The new value. 
		*/
		setDetailContainer?( detailContainer?:Ext.IContainer ): void;
		/** [Method] Sets the value of displayField  
		* @param displayField String The new value. 
		*/
		setDisplayField?( displayField?:string ): void;
		/** [Method] Sets the value of emptyText  
		* @param emptyText String The new value. 
		*/
		setEmptyText?( emptyText?:string ): void;
		/** [Method] Sets the value of itemHeight  
		* @param itemHeight Number The new value. 
		*/
		setItemHeight?( itemHeight?:number ): void;
		/** [Method] Sets the value of listConfig  
		* @param listConfig Object The new value. 
		*/
		setListConfig?( listConfig?:any ): void;
		/** [Method] Sets the value of loadingText  
		* @param loadingText String The new value. 
		*/
		setLoadingText?( loadingText?:string ): void;
		/** [Method] Sets the value of onItemDisclosure  
		* @param onItemDisclosure Boolean/Function The new value. 
		*/
		setOnItemDisclosure?( onItemDisclosure?:any ): void;
		/** [Method] Sets the value of store  
		* @param store Ext.data.TreeStore/String The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of title  
		* @param title String The new value. 
		*/
		setTitle?( title?:string ): void;
		/** [Method] Sets the value of toolbar  
		* @param toolbar Ext.Toolbar/Object/Boolean The new value. 
		*/
		setToolbar?( toolbar?:any ): void;
		/** [Method] Sets the value of ui  
		* @param ui Object The new value. 
		*/
		setUi?( ui?:any ): void;
		/** [Method] Sets the value of updateTitleText  
		* @param updateTitleText Boolean The new value. 
		*/
		setUpdateTitleText?( updateTitleText?:boolean ): void;
		/** [Method] Sets the value of useSimpleItems  
		* @param useSimpleItems Boolean The new value. 
		*/
		setUseSimpleItems?( useSimpleItems?:boolean ): void;
		/** [Method] Sets the value of useTitleAsBackText  
		* @param useTitleAsBackText Boolean The new value. 
		*/
		setUseTitleAsBackText?( useTitleAsBackText?:boolean ): void;
		/** [Method] Sets the value of useToolbar  
		* @param useToolbar Boolean The new value. 
		*/
		setUseToolbar?( useToolbar?:boolean ): void;
		/** [Method] Sets the value of variableHeights  
		* @param variableHeights Boolean The new value. 
		*/
		setVariableHeights?( variableHeights?:boolean ): void;
	}
}
declare module Ext {
	export interface INestedList extends Ext.IContainer {
		/** [Config Option] (Boolean) */
		allowDeselect?: boolean;
		/** [Config Option] (Object) */
		backButton?: any;
		/** [Config Option] (String) */
		backText?: string;
		/** [Config Option] (String) */
		baseCls?: string;
		/** [Config Option] (String/Object/Boolean) */
		cardSwitchAnimation?: any;
		/** [Config Option] (Number) */
		clearSelectionDelay?: number;
		/** [Config Option] (Ext.Component) */
		detailCard?: Ext.IComponent;
		/** [Config Option] (Ext.Container) */
		detailContainer?: Ext.IContainer;
		/** [Config Option] (String) */
		displayField?: string;
		/** [Config Option] (String) */
		emptyText?: string;
		/** [Config Option] (Number) */
		itemHeight?: number;
		/** [Config Option] (Object) */
		listConfig?: any;
		/** [Config Option] (String) */
		loadingText?: string;
		/** [Config Option] (Boolean/Function) */
		onItemDisclosure?: any;
		/** [Config Option] (Ext.data.TreeStore/String) */
		store?: any;
		/** [Config Option] (String) */
		title?: string;
		/** [Config Option] (Ext.Toolbar/Object/Boolean) */
		toolbar?: any;
		/** [Config Option] (String) */
		ui?: string;
		/** [Config Option] (Boolean) */
		updateTitleText?: boolean;
		/** [Config Option] (Boolean) */
		useSimpleItems?: boolean;
		/** [Config Option] (Boolean) */
		useTitleAsBackText?: boolean;
		/** [Config Option] (Boolean) */
		useToolbar?: boolean;
		/** [Config Option] (Boolean) */
		variableHeights?: boolean;
		/** [Method] Returns the value of allowDeselect  
		* @returns Boolean 
		*/
		getAllowDeselect?(): boolean;
		/** [Method] Returns the value of backButton  
		* @returns Object 
		*/
		getBackButton?(): any;
		/** [Method] Returns the value of backText  
		* @returns String 
		*/
		getBackText?(): string;
		/** [Method] Returns the value of baseCls  
		* @returns String 
		*/
		getBaseCls?(): string;
		/** [Method] Returns the value of clearSelectionOnListChange  
		* @returns Boolean 
		*/
		getClearSelectionOnListChange?(): boolean;
		/** [Method] Returns the value of detailCard  
		* @returns Ext.Component 
		*/
		getDetailCard?(): Ext.IComponent;
		/** [Method] Returns the value of detailContainer  
		* @returns Ext.Container 
		*/
		getDetailContainer?(): Ext.IContainer;
		/** [Method] Returns the value of displayField  
		* @returns String 
		*/
		getDisplayField?(): string;
		/** [Method] Returns the value of emptyText  
		* @returns String 
		*/
		getEmptyText?(): string;
		/** [Method] Returns the value of itemHeight  
		* @returns Number 
		*/
		getItemHeight?(): number;
		/** [Method] Override this method to provide custom template rendering of individual nodes  
		* @param node Ext.data.Record 
		* @returns String 
		*/
		getItemTextTpl?( node?:Ext.data.IRecord ): string;
		/** [Method] Returns the value of listConfig  
		* @returns Object 
		*/
		getListConfig?(): any;
		/** [Method] Returns the value of loadingText  
		* @returns String 
		*/
		getLoadingText?(): string;
		/** [Method] Returns the value of onItemDisclosure  
		* @returns Boolean/Function 
		*/
		getOnItemDisclosure?(): any;
		/** [Method] Returns the value of store  
		* @returns Ext.data.TreeStore/String 
		*/
		getStore?(): any;
		/** [Method] Returns the subList for a specified node  */
		getSubList?(): void;
		/** [Method] Returns the value of title  
		* @returns String 
		*/
		getTitle?(): string;
		/** [Method] Override this method to provide custom template rendering of titles back buttons when useTitleAsBackText is enabled  
		* @param node Ext.data.Record 
		* @returns String 
		*/
		getTitleTextTpl?( node?:Ext.data.IRecord ): string;
		/** [Method] Returns the value of toolbar  
		* @returns Ext.Toolbar/Object/Boolean 
		*/
		getToolbar?(): any;
		/** [Method] Returns the value of updateTitleText  
		* @returns Boolean 
		*/
		getUpdateTitleText?(): boolean;
		/** [Method] Returns the value of useSimpleItems  
		* @returns Boolean 
		*/
		getUseSimpleItems?(): boolean;
		/** [Method] Returns the value of useTitleAsBackText  
		* @returns Boolean 
		*/
		getUseTitleAsBackText?(): boolean;
		/** [Method] Returns the value of useToolbar  
		* @returns Boolean 
		*/
		getUseToolbar?(): boolean;
		/** [Method] Returns the value of variableHeights  
		* @returns Boolean 
		*/
		getVariableHeights?(): boolean;
		/** [Method] The leaf you want to navigate to  
		* @param node Ext.data.NodeInterface The specified node to navigate to. 
		*/
		goToLeaf?( node?:Ext.data.INodeInterface ): void;
		/** [Method] Method to handle going to a specific node within this nested list  
		* @param node Ext.data.NodeInterface The specified node to navigate to. 
		*/
		goToNode?( node?:Ext.data.INodeInterface ): void;
		/** [Method] Called when the backButton has been tapped  */
		onBackTap?(): void;
		/** [Method] Called when an list item has been tapped  
		* @param list Ext.List The subList the item is on. 
		* @param index Number The id of the item tapped. 
		* @param target Ext.Element The list item tapped. 
		* @param record Ext.data.Record The record which as tapped. 
		* @param e Ext.event.Event The event. 
		*/
		onItemTap?( list?:Ext.IList, index?:number, target?:Ext.IElement, record?:Ext.data.IRecord, e?:Ext.event.IEvent ): void;
		/** [Method] Sets the value of allowDeselect  
		* @param allowDeselect Boolean The new value. 
		*/
		setAllowDeselect?( allowDeselect?:boolean ): void;
		/** [Method] Sets the value of backButton  
		* @param backButton Object The new value. 
		*/
		setBackButton?( backButton?:any ): void;
		/** [Method] Sets the value of backText  
		* @param backText String The new value. 
		*/
		setBackText?( backText?:string ): void;
		/** [Method] Sets the value of baseCls  
		* @param baseCls String The new value. 
		*/
		setBaseCls?( baseCls?:string ): void;
		/** [Method] Sets the value of clearSelectionOnListChange  
		* @param clearSelectionOnListChange Boolean The new value. 
		*/
		setClearSelectionOnListChange?( clearSelectionOnListChange?:boolean ): void;
		/** [Method] Sets the value of detailCard  
		* @param detailCard Ext.Component The new value. 
		*/
		setDetailCard?( detailCard?:Ext.IComponent ): void;
		/** [Method] Sets the value of detailContainer  
		* @param detailContainer Ext.Container The new value. 
		*/
		setDetailContainer?( detailContainer?:Ext.IContainer ): void;
		/** [Method] Sets the value of displayField  
		* @param displayField String The new value. 
		*/
		setDisplayField?( displayField?:string ): void;
		/** [Method] Sets the value of emptyText  
		* @param emptyText String The new value. 
		*/
		setEmptyText?( emptyText?:string ): void;
		/** [Method] Sets the value of itemHeight  
		* @param itemHeight Number The new value. 
		*/
		setItemHeight?( itemHeight?:number ): void;
		/** [Method] Sets the value of listConfig  
		* @param listConfig Object The new value. 
		*/
		setListConfig?( listConfig?:any ): void;
		/** [Method] Sets the value of loadingText  
		* @param loadingText String The new value. 
		*/
		setLoadingText?( loadingText?:string ): void;
		/** [Method] Sets the value of onItemDisclosure  
		* @param onItemDisclosure Boolean/Function The new value. 
		*/
		setOnItemDisclosure?( onItemDisclosure?:any ): void;
		/** [Method] Sets the value of store  
		* @param store Ext.data.TreeStore/String The new value. 
		*/
		setStore?( store?:any ): void;
		/** [Method] Sets the value of title  
		* @param title String The new value. 
		*/
		setTitle?( title?:string ): void;
		/** [Method] Sets the value of toolbar  
		* @param toolbar Ext.Toolbar/Object/Boolean The new value. 
		*/
		setToolbar?( toolbar?:any ): void;
		/** [Method] Sets the value of ui  
		* @param ui Object The new value. 
		*/
		setUi?( ui?:any ): void;
		/** [Method] Sets the value of updateTitleText  
		* @param updateTitleText Boolean The new value. 
		*/
		setUpdateTitleText?( updateTitleText?:boolean ): void;
		/** [Method] Sets the value of useSimpleItems  
		* @param useSimpleItems Boolean The new value. 
		*/
		setUseSimpleItems?( useSimpleItems?:boolean ): void;
		/** [Method] Sets the value of useTitleAsBackText  
		* @param useTitleAsBackText Boolean The new value. 
		*/
		setUseTitleAsBackText?( useTitleAsBackText?:boolean ): void;
		/** [Method] Sets the value of useToolbar  
		* @param useToolbar Boolean The new value. 
		*/
		setUseToolbar?( useToolbar?:boolean ): void;
		/** [Method] Sets the value of variableHeights  
		* @param variableHeights Boolean The new value. 
		*/
		setVariableHeights?( variableHeights?:boolean ): void;
	}
}
declare module Ext {
	export interface IDate extends Ext.IDateExtras {
	}
	export class Date {
		/** [Property] (String) */
		static DAY: string;
		/** [Property] (String) */
		static HOUR: string;
		/** [Property] (String) */
		static MILLI: string;
		/** [Property] (String) */
		static MINUTE: string;
		/** [Property] (String) */
		static MONTH: string;
		/** [Property] (String) */
		static SECOND: string;
		/** [Property] (String) */
		static YEAR: string;
		/** [Property] (Array) */
		static dayNames: any[];
		/** [Property] (String) */
		static defaultFormat: string;
		/** [Property] (Object) */
		static defaults: any;
		/** [Property] (Object) */
		static formatCodes: any;
		/** [Property] (Object) */
		static formatFunctions: any;
		/** [Property] (Array) */
		static monthNames: any[];
		/** [Property] (Object) */
		static monthNumbers: any;
		/** [Property] (Object) */
		static parseFunctions: any;
		/** [Property] (Boolean) */
		static useStrict: boolean;
		/** [Method] Provides a convenient method for performing basic date arithmetic  
		* @param date Date The date to modify. 
		* @param interval String A valid date interval enum value. 
		* @param value Number The amount to add to the current date. 
		* @returns Date The new Date instance. 
		*/
		static add( date?:any, interval?:string, value?:number ): any;
		/** [Method] Align the date to unit  
		* @param date Date The date to be aligned. 
		* @param unit String The unit. This unit is compatible with the date interval constants. 
		* @returns Date The aligned date. 
		*/
		static align( date?:any, unit?:string ): any;
		/** [Method] Checks if a date falls on or between the given start and end dates  
		* @param date Date The date to check. 
		* @param start Date Start date. 
		* @param end Date End date. 
		* @returns Boolean true if this date falls on or between the given start and end dates. 
		*/
		static between( date?:any, start?:any, end?:any ): boolean;
		/** [Method] Attempts to clear all time information from this Date by setting the time to midnight of the same day automatically 
		* @param date Date The date. 
		* @param clone Boolean true to create a clone of this date, clear the time and return it. 
		* @returns Date this or the clone. 
		*/
		static clearTime( date?:any, clone?:boolean ): any;
		/** [Method] Creates and returns a new Date instance with the exact same date value as the called instance  
		* @param date Date The date. 
		* @returns Date The new Date instance. 
		*/
		static clone( date?:any ): any;
		/** [Method] Calculate how many units are there between two time  
		* @param min Date The first time. 
		* @param max Date The second time. 
		* @param unit String The unit. This unit is compatible with the date interval constants. 
		* @returns Number The maximum number n of units that min + n * unit &lt;= max. 
		*/
		static diff( min?:any, max?:any, unit?:string ): number;
		/** [Method] Formats a date given the supplied format string  
		* @param date Date The date to format. 
		* @param format String The format string. 
		* @returns String The formatted date. 
		*/
		static format( date?:any, format?:string ): string;
		/** [Method] Get the numeric day number of the year adjusted for leap year  
		* @param date Date The date. 
		* @returns Number 0 to 364 (365 in leap years). 
		*/
		static getDayOfYear( date?:any ): number;
		/** [Method] Get the number of days in the current month adjusted for leap year  
		* @param date Date The date. 
		* @returns Number The number of days in the month. 
		*/
		static getDaysInMonth( date?:any ): number;
		/** [Method] Returns the number of milliseconds between two dates  
		* @param dateA Date The first date. 
		* @param dateB Date The second date, defaults to now. 
		* @returns Number The difference in milliseconds. 
		*/
		static getElapsed( dateA?:any, dateB?:any ): number;
		/** [Method] Get the date of the first day of the month in which this date resides  
		* @param date Date The date. 
		* @returns Date 
		*/
		static getFirstDateOfMonth( date?:any ): any;
		/** [Method] Get the first day of the current month adjusted for leap year  
		* @param date Date The date 
		* @returns Number The day number (0-6). 
		*/
		static getFirstDayOfMonth( date?:any ): number;
		/** [Method] Get the offset from GMT of the current date equivalent to the format specifier O  
		* @param date Date The date. 
		* @param colon Boolean true to separate the hours and minutes with a colon. 
		* @returns String The 4-character offset string prefixed with + or - (e.g. '-0600'). 
		*/
		static getGMTOffset( date?:any, colon?:boolean ): string;
		/** [Method] Get the date of the last day of the month in which this date resides  
		* @param date Date The date. 
		* @returns Date 
		*/
		static getLastDateOfMonth( date?:any ): any;
		/** [Method] Get the last day of the current month adjusted for leap year  
		* @param date Date The date. 
		* @returns Number The day number (0-6). 
		*/
		static getLastDayOfMonth( date?:any ): number;
		/** [Method] Get the zero based JavaScript month number for the given short full month name  
		* @param name String The short/full month name. 
		* @returns Number The zero-based JavaScript month number. 
		*/
		static getMonthNumber( name?:string ): number;
		/** [Method] Get the short day name for the given day number  
		* @param day Number A zero-based JavaScript day number. 
		* @returns String The short day name. 
		*/
		static getShortDayName( day?:number ): string;
		/** [Method] Get the short month name for the given month number  
		* @param month Number A zero-based JavaScript month number. 
		* @returns String The short month name. 
		*/
		static getShortMonthName( month?:number ): string;
		/** [Method] Get the English ordinal suffix of the current day equivalent to the format specifier S  
		* @param date Date The date. 
		* @returns String 'st', 'nd', 'rd' or 'th'. 
		*/
		static getSuffix( date?:any ): string;
		/** [Method] Get the timezone abbreviation of the current date equivalent to the format specifier T  
		* @param date Date The date. 
		* @returns String The abbreviated timezone name (e.g. 'CST', 'PDT', 'EDT', 'MPST' ...). 
		*/
		static getTimezone( date?:any ): string;
		/** [Method] Get the numeric ISO 8601 week number of the year equivalent to the format specifier W  but without a leading zero 
		* @param date Date The date. 
		* @returns Number 1 to 53. 
		*/
		static getWeekOfYear( date?:any ): number;
		/** [Method] Checks if the current date is affected by Daylight Saving Time DST 
		* @param date Date The date. 
		* @returns Boolean true if the current date is affected by DST. 
		*/
		static isDST( date?:any ): boolean;
		/** [Method] Checks if the current date falls within a leap year  
		* @param date Date The date. 
		* @returns Boolean true if the current date falls within a leap year, false otherwise. 
		*/
		static isLeapYear( date?:any ): boolean;
		/** [Method] Checks if the passed Date parameters will cause a JavaScript Date rollover 
		* @param year Number 4-digit year. 
		* @param month Number 1-based month-of-year. 
		* @param day Number Day of month. 
		* @param hour Number Hour. 
		* @param minute Number Minute. 
		* @param second Number Second. 
		* @param millisecond Number Millisecond. 
		* @returns Boolean true if the passed parameters do not cause a Date "rollover", false otherwise. 
		*/
		static isValid( year?:number, month?:number, day?:number, hour?:number, minute?:number, second?:number, millisecond?:number ): boolean;
		/** [Method] Returns the current timestamp  
		* @returns Number The current timestamp. 
		*/
		static now(): number;
		/** [Method] Parses the passed string using the specified date format  
		* @param input String/Number The raw date string. 
		* @param format String The expected date string format. 
		* @param strict Boolean true to validate date strings while parsing (i.e. prevents JavaScript Date "rollover"). Invalid date strings will return null when parsed. 
		* @returns Date/null The parsed Date, or null if an invalid date string. 
		*/
		static parse( input?:any, format?:string, strict?:boolean ): any;
	}
}
declare module Ext {
	export interface IDateExtras {
	}
	export class DateExtras {
		/** [Property] (String) */
		static DAY: string;
		/** [Property] (String) */
		static HOUR: string;
		/** [Property] (String) */
		static MILLI: string;
		/** [Property] (String) */
		static MINUTE: string;
		/** [Property] (String) */
		static MONTH: string;
		/** [Property] (String) */
		static SECOND: string;
		/** [Property] (String) */
		static YEAR: string;
		/** [Property] (Array) */
		static dayNames: any[];
		/** [Property] (String) */
		static defaultFormat: string;
		/** [Property] (Object) */
		static defaults: any;
		/** [Property] (Object) */
		static formatCodes: any;
		/** [Property] (Object) */
		static formatFunctions: any;
		/** [Property] (Array) */
		static monthNames: any[];
		/** [Property] (Object) */
		static monthNumbers: any;
		/** [Property] (Object) */
		static parseFunctions: any;
		/** [Property] (Boolean) */
		static useStrict: boolean;
		/** [Method] Provides a convenient method for performing basic date arithmetic  
		* @param date Date The date to modify. 
		* @param interval String A valid date interval enum value. 
		* @param value Number The amount to add to the current date. 
		* @returns Date The new Date instance. 
		*/
		static add( date?:any, interval?:string, value?:number ): any;
		/** [Method] Align the date to unit  
		* @param date Date The date to be aligned. 
		* @param unit String The unit. This unit is compatible with the date interval constants. 
		* @returns Date The aligned date. 
		*/
		static align( date?:any, unit?:string ): any;
		/** [Method] Checks if a date falls on or between the given start and end dates  
		* @param date Date The date to check. 
		* @param start Date Start date. 
		* @param end Date End date. 
		* @returns Boolean true if this date falls on or between the given start and end dates. 
		*/
		static between( date?:any, start?:any, end?:any ): boolean;
		/** [Method] Attempts to clear all time information from this Date by setting the time to midnight of the same day automatically 
		* @param date Date The date. 
		* @param clone Boolean true to create a clone of this date, clear the time and return it. 
		* @returns Date this or the clone. 
		*/
		static clearTime( date?:any, clone?:boolean ): any;
		/** [Method] Creates and returns a new Date instance with the exact same date value as the called instance  
		* @param date Date The date. 
		* @returns Date The new Date instance. 
		*/
		static clone( date?:any ): any;
		/** [Method] Calculate how many units are there between two time  
		* @param min Date The first time. 
		* @param max Date The second time. 
		* @param unit String The unit. This unit is compatible with the date interval constants. 
		* @returns Number The maximum number n of units that min + n * unit &lt;= max. 
		*/
		static diff( min?:any, max?:any, unit?:string ): number;
		/** [Method] Formats a date given the supplied format string  
		* @param date Date The date to format. 
		* @param format String The format string. 
		* @returns String The formatted date. 
		*/
		static format( date?:any, format?:string ): string;
		/** [Method] Get the numeric day number of the year adjusted for leap year  
		* @param date Date The date. 
		* @returns Number 0 to 364 (365 in leap years). 
		*/
		static getDayOfYear( date?:any ): number;
		/** [Method] Get the number of days in the current month adjusted for leap year  
		* @param date Date The date. 
		* @returns Number The number of days in the month. 
		*/
		static getDaysInMonth( date?:any ): number;
		/** [Method] Returns the number of milliseconds between two dates  
		* @param dateA Date The first date. 
		* @param dateB Date The second date, defaults to now. 
		* @returns Number The difference in milliseconds. 
		*/
		static getElapsed( dateA?:any, dateB?:any ): number;
		/** [Method] Get the date of the first day of the month in which this date resides  
		* @param date Date The date. 
		* @returns Date 
		*/
		static getFirstDateOfMonth( date?:any ): any;
		/** [Method] Get the first day of the current month adjusted for leap year  
		* @param date Date The date 
		* @returns Number The day number (0-6). 
		*/
		static getFirstDayOfMonth( date?:any ): number;
		/** [Method] Get the offset from GMT of the current date equivalent to the format specifier O  
		* @param date Date The date. 
		* @param colon Boolean true to separate the hours and minutes with a colon. 
		* @returns String The 4-character offset string prefixed with + or - (e.g. '-0600'). 
		*/
		static getGMTOffset( date?:any, colon?:boolean ): string;
		/** [Method] Get the date of the last day of the month in which this date resides  
		* @param date Date The date. 
		* @returns Date 
		*/
		static getLastDateOfMonth( date?:any ): any;
		/** [Method] Get the last day of the current month adjusted for leap year  
		* @param date Date The date. 
		* @returns Number The day number (0-6). 
		*/
		static getLastDayOfMonth( date?:any ): number;
		/** [Method] Get the zero based JavaScript month number for the given short full month name  
		* @param name String The short/full month name. 
		* @returns Number The zero-based JavaScript month number. 
		*/
		static getMonthNumber( name?:string ): number;
		/** [Method] Get the short day name for the given day number  
		* @param day Number A zero-based JavaScript day number. 
		* @returns String The short day name. 
		*/
		static getShortDayName( day?:number ): string;
		/** [Method] Get the short month name for the given month number  
		* @param month Number A zero-based JavaScript month number. 
		* @returns String The short month name. 
		*/
		static getShortMonthName( month?:number ): string;
		/** [Method] Get the English ordinal suffix of the current day equivalent to the format specifier S  
		* @param date Date The date. 
		* @returns String 'st', 'nd', 'rd' or 'th'. 
		*/
		static getSuffix( date?:any ): string;
		/** [Method] Get the timezone abbreviation of the current date equivalent to the format specifier T  
		* @param date Date The date. 
		* @returns String The abbreviated timezone name (e.g. 'CST', 'PDT', 'EDT', 'MPST' ...). 
		*/
		static getTimezone( date?:any ): string;
		/** [Method] Get the numeric ISO 8601 week number of the year equivalent to the format specifier W  but without a leading zero 
		* @param date Date The date. 
		* @returns Number 1 to 53. 
		*/
		static getWeekOfYear( date?:any ): number;
		/** [Method] Checks if the current date is affected by Daylight Saving Time DST 
		* @param date Date The date. 
		* @returns Boolean true if the current date is affected by DST. 
		*/
		static isDST( date?:any ): boolean;
		/** [Method] Checks if the current date falls within a leap year  
		* @param date Date The date. 
		* @returns Boolean true if the current date falls within a leap year, false otherwise. 
		*/
		static isLeapYear( date?:any ): boolean;
		/** [Method] Checks if the passed Date parameters will cause a JavaScript Date rollover 
		* @param year Number 4-digit year. 
		* @param month Number 1-based month-of-year. 
		* @param day Number Day of month. 
		* @param hour Number Hour. 
		* @param minute Number Minute. 
		* @param second Number Second. 
		* @param millisecond Number Millisecond. 
		* @returns Boolean true if the passed parameters do not cause a Date "rollover", false otherwise. 
		*/
		static isValid( year?:number, month?:number, day?:number, hour?:number, minute?:number, second?:number, millisecond?:number ): boolean;
		/** [Method] Returns the current timestamp  
		* @returns Number The current timestamp. 
		*/
		static now(): number;
		/** [Method] Parses the passed string using the specified date format  
		* @param input String/Number The raw date string. 
		* @param format String The expected date string format. 
		* @param strict Boolean true to validate date strings while parsing (i.e. prevents JavaScript Date "rollover"). Invalid date strings will return null when parsed. 
		* @returns Date/null The parsed Date, or null if an invalid date string. 
		*/
		static parse( input?:any, format?:string, strict?:boolean ): any;
	}
}
declare module Ext {
	export interface IDecorator extends Ext.IComponent {
		/** [Config Option] (Object) */
		component?: any;
		/** [Method] Destroys this Component  */
		destroy?(): void;
		/** [Method] Returns the value of component  
		* @returns Object 
		*/
		getComponent?(): any;
		/** [Method] Sets the value of component  
		* @param component Object The new value. 
		*/
		setComponent?( component?:any ): void;
	}
}
declare module Ext.device.accelerometer {
	export interface IAbstract extends Ext.IBase {
		/** [Config Option] (Number) */
		frequency?: number;
		/** [Method] Returns the value of frequency  
		* @returns Number 
		*/
		getFrequency?(): number;
		/** [Method] Sets the value of frequency  
		* @param frequency Number The new value. 
		*/
		setFrequency?( frequency?:number ): void;
	}
}
declare module Ext.device.accelerometer {
	export interface ICordova extends Ext.device.accelerometer.IAbstract {
	}
}
declare module Ext.device.accelerometer {
	export interface IPhoneGap extends Ext.device.accelerometer.IAbstract {
	}
}
declare module Ext.device {
	export interface IAccelerometer extends Ext.IBase,Ext.device.accelerometer.IAbstract {
	}
	export class Accelerometer {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the value of frequency  
		* @returns Number 
		*/
		static getFrequency(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Sets the value of frequency  
		* @param frequency Number The new value. 
		*/
		static setFrequency( frequency?:number ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.accelerometer {
	export interface ISimulator extends Ext.device.accelerometer.IAbstract {
	}
}
declare module Ext.device.browser {
	export interface IAbstract extends Ext.IBase {
		/** [Method] Used to close the browser if one is opened  */
		close?(): void;
		/** [Method] Used to open a new browser window  
		* @param options Object The options to use when opening a new browser window. 
		*/
		open?( options?:any ): void;
	}
}
declare module Ext.device.browser {
	export interface ICordova extends Ext.device.browser.IAbstract {
		/** [Method] Used to close the browser if one is opened  */
		close?(): void;
		/** [Method] Used to open a new browser window  
		* @param config Object 
		*/
		open?( config?:any ): void;
	}
}
declare module Ext.device {
	export interface IBrowser extends Ext.IBase,Ext.device.browser.IAbstract {
	}
	export class Browser {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Used to close the browser if one is opened  */
		static close(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Used to open a new browser window  
		* @param options Object The options to use when opening a new browser window. 
		*/
		static open( options?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.browser {
	export interface ISimulator extends Ext.IBase {
	}
}
declare module Ext.device.browser {
	export interface IWindow extends Ext.IEvented {
	}
}
declare module Ext.device.camera {
	export interface IAbstract extends Ext.IBase {
		/** [Method] Allows you to capture a photo  
		* @param options Object The options to use when taking a photo. 
		* @param scope Object The scope in which to call the success and failure functions, if specified. 
		* @param destination String The destination of the image which is returned. Available options are:  data - returns a base64 encoded string file - returns the file's URI  
		* @param encoding String The encoding of the returned image. Available options are:  jpg png  
		* @param width Number The width of the image to return 
		* @param height Number The height of the image to return 
		*/
		capture?( options?:any, scope?:any, destination?:string, encoding?:string, width?:number, height?:number ): void;
	}
}
declare module Ext.device.camera {
	export interface ICordova extends Ext.device.camera.IAbstract {
		/** [Method] Allows you to capture a photo  
		* @param args Object 
		*/
		capture?( args?:any ): void;
	}
}
declare module Ext.device.camera {
	export interface IPhoneGap extends Ext.device.camera.IAbstract {
		/** [Method] Allows you to capture a photo  
		* @param args Object 
		*/
		capture?( args?:any ): void;
	}
}
declare module Ext.device {
	export interface ICamera extends Ext.IBase,Ext.device.camera.IAbstract {
	}
	export class Camera {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Allows you to capture a photo  
		* @param options Object The options to use when taking a photo. 
		* @param scope Object The scope in which to call the success and failure functions, if specified. 
		* @param destination String The destination of the image which is returned. Available options are:  data - returns a base64 encoded string file - returns the file's URI  
		* @param encoding String The encoding of the returned image. Available options are:  jpg png  
		* @param width Number The width of the image to return 
		* @param height Number The height of the image to return 
		*/
		static capture( options?:any, scope?:any, destination?:string, encoding?:string, width?:number, height?:number ): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.camera {
	export interface ISencha extends Ext.device.camera.IAbstract {
		/** [Method] Allows you to capture a photo  
		* @param options Object 
		*/
		capture?( options?:any ): void;
	}
}
declare module Ext.device.camera {
	export interface ISimulator extends Ext.device.camera.IAbstract {
		/** [Method] Allows you to capture a photo  
		* @param options Object 
		*/
		capture?( options?:any ): void;
		/** [Method] Returns the value of samples  
		* @returns Array 
		*/
		getSamples?(): any[];
		/** [Method] Sets the value of samples  
		* @param samples Array The new value. 
		*/
		setSamples?( samples?:any[] ): void;
	}
}
declare module Ext.device.capture {
	export interface IAbstract extends Ext.IBase {
		/** [Method] Start the audio recorder application and return information about captured audio clip file s 
		* @param config Object The configuration object to be passed: 
		*/
		captureAudio?( config?:any ): void;
		/** [Method] Start the video recorder application and return information about captured video clip file s 
		* @param config Object The configuration object to be passed: 
		*/
		captureVideo?( config?:any ): void;
	}
}
declare module Ext.device.capture {
	export interface ISimulator extends Ext.IBase {
		/** [Method] Start the audio recorder application and return information about captured audio clip file s 
		* @param config Object The configuration object to be passed: 
		*/
		captureAudio?( config?:any ): void;
		/** [Method] Start the video recorder application and return information about captured video clip file s 
		* @param config Object The configuration object to be passed: 
		*/
		captureVideo?( config?:any ): void;
	}
}
declare module Ext.device.capture {
	export interface ICordova extends Ext.IBase {
	}
}
declare module Ext.device {
	export interface ICapture extends Ext.IBase,Ext.device.capture.IAbstract {
	}
	export class Capture {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Start the audio recorder application and return information about captured audio clip file s 
		* @param config Object The configuration object to be passed: 
		*/
		static captureAudio( config?:any ): void;
		/** [Method] Start the video recorder application and return information about captured video clip file s 
		* @param config Object The configuration object to be passed: 
		*/
		static captureVideo( config?:any ): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.communicator {
	export interface IAndroid extends Ext.device.communicator.IDefault {
	}
}
declare module Ext.device.communicator {
	export interface IDefault extends Ext.IBase {
	}
}
declare module Ext.device {
	export interface ICommunicator extends Ext.IBase {
	}
	export class Communicator {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.compass {
	export interface IAbstract extends Ext.IBase {
		/** [Config Option] (Number) */
		frequency?: number;
		/** [Method] Returns the value of frequency  
		* @returns Number 
		*/
		getFrequency?(): number;
		/** [Method] Sets the value of frequency  
		* @param frequency Number The new value. 
		*/
		setFrequency?( frequency?:number ): void;
	}
}
declare module Ext.device.compass {
	export interface ICordova extends Ext.device.compass.IAbstract {
	}
}
declare module Ext.device.compass {
	export interface IPhoneGap extends Ext.device.compass.IAbstract {
	}
}
declare module Ext.device {
	export interface ICompass extends Ext.IBase,Ext.device.compass.IAbstract {
	}
	export class Compass {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the value of frequency  
		* @returns Number 
		*/
		static getFrequency(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Sets the value of frequency  
		* @param frequency Number The new value. 
		*/
		static setFrequency( frequency?:number ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.compass {
	export interface ISimulator extends Ext.device.compass.IAbstract {
	}
}
declare module Ext.device.connection {
	export interface IAbstract extends Ext.IEvented,Ext.mixin.IObservable {
		/** [Property] (String) */
		CELL_2G?: string;
		/** [Property] (String) */
		CELL_3G?: string;
		/** [Property] (String) */
		CELL_4G?: string;
		/** [Property] (String) */
		ETHERNET?: string;
		/** [Property] (String) */
		NONE?: string;
		/** [Property] (String) */
		UNKNOWN?: string;
		/** [Property] (String) */
		WIFI?: string;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of online  
		* @returns Boolean 
		*/
		getOnline?(): boolean;
		/** [Method] Returns the current connection type  
		* @returns String type 
		*/
		getType?(): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] True if the device is currently online 
		* @returns Boolean online 
		*/
		isOnline?(): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of online  
		* @param online Boolean The new value. 
		*/
		setOnline?( online?:boolean ): void;
		/** [Method] Sets the value of type  
		* @param type Object The new value. 
		*/
		setType?( type?:any ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.connection {
	export interface ICordova extends Ext.device.connection.IAbstract {
		/** [Method] Returns the value of online  
		* @returns Boolean 
		*/
		getOnline?(): boolean;
		/** [Method] Returns the current connection type  
		* @returns String type 
		*/
		getType?(): string;
	}
}
declare module Ext.device.connection {
	export interface IPhoneGap extends Ext.device.connection.IAbstract {
		/** [Method] Returns the value of online  
		* @returns Boolean 
		*/
		getOnline?(): boolean;
		/** [Method] Returns the current connection type  
		* @returns String type 
		*/
		getType?(): string;
	}
}
declare module Ext.device {
	export interface IConnection extends Ext.IBase,Ext.device.connection.IAbstract {
	}
	export class Connection {
		/** [Property] (String) */
		static CELL_2G: string;
		/** [Property] (String) */
		static CELL_3G: string;
		/** [Property] (String) */
		static CELL_4G: string;
		/** [Property] (String) */
		static ETHERNET: string;
		/** [Property] (String) */
		static NONE: string;
		/** [Property] (String) */
		static UNKNOWN: string;
		/** [Property] (String) */
		static WIFI: string;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object  */
		static clearListeners(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		static fireAction( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		static getBubbleEvents(): any;
		/** [Method] Retrieves the id of this component  
		* @returns String id 
		*/
		static getId(): string;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		static getListeners(): any;
		/** [Method] Returns the value of online  
		* @returns Boolean 
		*/
		static getOnline(): boolean;
		/** [Method] Returns the current connection type  
		* @returns String type 
		*/
		static getType(): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] True if the device is currently online 
		* @returns Boolean online 
		*/
		static isOnline(): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static mon( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static mun( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		static relayEvents( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static removeListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static removeManagedListener( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		static resumeEvents( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		static setBubbleEvents( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		static setListeners( listeners?:any ): void;
		/** [Method] Sets the value of online  
		* @param online Boolean The new value. 
		*/
		static setOnline( online?:boolean ): void;
		/** [Method] Sets the value of type  
		* @param type Object The new value. 
		*/
		static setType( type?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends the firing of all events  */
		static suspendEvents(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static un( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.connection {
	export interface ISencha extends Ext.device.connection.IAbstract {
	}
}
declare module Ext.device.connection {
	export interface ISimulator extends Ext.device.connection.IAbstract {
		/** [Method] Returns the value of online  
		* @returns Boolean 
		*/
		getOnline?(): boolean;
	}
}
declare module Ext.device.contacts {
	export interface IAbstract extends Ext.IBase,Ext.mixin.IObservable {
		/** [Config Option] (Boolean) */
		includeImages?: boolean;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns an Array of contact objects  
		* @param config Object 
		* @returns Object[] An array of contact objects. 
		*/
		getContacts?( config?:any ): any[];
		/** [Method] Returns the value of includeImages  
		* @returns Boolean 
		*/
		getIncludeImages?(): boolean;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns localized user readable label for a contact field i e  
		* @param config Object 
		* @returns String user readable string 
		*/
		getLocalizedLabel?( config?:any ): string;
		/** [Method] Returns base64 encoded image thumbnail for a contact specified in config id This method is for Sencha Native Packager  
		* @param config Object 
		* @returns String base64 string 
		*/
		getThumbnail?( config?:any ): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of includeImages  
		* @param includeImages Boolean The new value. 
		*/
		setIncludeImages?( includeImages?:boolean ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.contacts {
	export interface ICordova extends Ext.device.contacts.IAbstract {
		/** [Method] Returns an Array of contact objects  
		* @param config Object 
		* @returns Object[] An array of contact objects. 
		*/
		getContacts?( config?:any ): any[];
	}
}
declare module Ext.device.contacts {
	export interface IPhoneGap extends Ext.device.contacts.IAbstract {
		/** [Method] Returns an Array of contact objects  
		* @param config Object 
		* @returns Object[] An array of contact objects. 
		*/
		getContacts?( config?:any ): any[];
	}
}
declare module Ext.device {
	export interface IContacts extends Ext.IBase,Ext.device.contacts.IAbstract,Ext.device.contacts.ISencha,Ext.device.contacts.ICordova {
	}
	export class Contacts {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object  */
		static clearListeners(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		static fireAction( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		static getBubbleEvents(): any;
		/** [Method] Returns an Array of contact objects  
		* @param config Object 
		* @returns Object[] An array of contact objects. 
		*/
		static getContacts( config?:any ): any[];
		/** [Method] Retrieves the id of this component  
		* @returns String id 
		*/
		static getId(): string;
		/** [Method] Returns the value of includeImages  
		* @returns Boolean 
		*/
		static getIncludeImages(): boolean;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		static getListeners(): any;
		/** [Method] Returns localized user readable label for a contact field i e  
		* @param config Object 
		* @returns String user readable string 
		*/
		static getLocalizedLabel( config?:any ): string;
		/** [Method] Returns base64 encoded image thumbnail for a contact specified in config id This method is for Sencha Native Packager  
		* @param config Object 
		* @returns String base64 string 
		*/
		static getThumbnail( config?:any ): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static mon( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static mun( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		static relayEvents( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static removeListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static removeManagedListener( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		static resumeEvents( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		static setBubbleEvents( bubbleEvents?:any ): void;
		/** [Method] Sets the value of includeImages  
		* @param includeImages Boolean The new value. 
		*/
		static setIncludeImages( includeImages?:boolean ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		static setListeners( listeners?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends the firing of all events  */
		static suspendEvents(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static un( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.contacts {
	export interface ISencha extends Ext.device.contacts.IAbstract {
		/** [Method] Returns an Array of contact objects  
		* @param config Object 
		* @returns Object[] An array of contact objects. 
		*/
		getContacts?( config?:any ): any[];
		/** [Method] Returns localized user readable label for a contact field i e  
		* @param config Object 
		* @returns String user readable string 
		*/
		getLocalizedLabel?( config?:any ): string;
		/** [Method] Returns base64 encoded image thumbnail for a contact specified in config id This method is for Sencha Native Packager  
		* @param config Object 
		* @returns String base64 string 
		*/
		getThumbnail?( config?:any ): string;
	}
}
declare module Ext.device.device {
	export interface IAbstract extends Ext.IBase,Ext.mixin.IObservable {
		/** [Property] (String) */
		name?: string;
		/** [Property] (String) */
		platform?: string;
		/** [Property] (Object/Boolean) */
		scheme?: any;
		/** [Property] (String) */
		uuid?: string;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Opens a specified URL  
		* @param url String The URL to open 
		*/
		openURL?( url?:string ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.device {
	export interface ICordova extends Ext.device.device.IAbstract {
		/** [Property] (String) */
		cordova?: string;
		/** [Property] (String) */
		model?: string;
		/** [Property] (String) */
		version?: string;
	}
}
declare module Ext.device.device {
	export interface IPhoneGap extends Ext.device.device.IAbstract {
		/** [Property] (String) */
		cordova?: string;
		/** [Property] (String) */
		model?: string;
		/** [Property] (String) */
		version?: string;
	}
}
declare module Ext.device {
	export interface IDevice extends Ext.IBase,Ext.device.device.IAbstract {
	}
	export class Device {
		/** [Property] (String) */
		static name: string;
		/** [Property] (String) */
		static platform: string;
		/** [Property] (Object/Boolean) */
		static scheme: any;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Property] (String) */
		static uuid: string;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object  */
		static clearListeners(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		static fireAction( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		static getBubbleEvents(): any;
		/** [Method] Retrieves the id of this component  
		* @returns String id 
		*/
		static getId(): string;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		static getListeners(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static mon( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static mun( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Opens a specified URL  
		* @param url String The URL to open 
		*/
		static openURL( url?:string ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		static relayEvents( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static removeListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static removeManagedListener( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		static resumeEvents( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		static setBubbleEvents( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		static setListeners( listeners?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends the firing of all events  */
		static suspendEvents(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static un( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.device {
	export interface ISencha extends Ext.device.device.IAbstract {
		/** [Method] Opens a specified URL  
		* @param url Object 
		*/
		openURL?( url?:any ): void;
	}
}
declare module Ext.device.device {
	export interface ISimulator extends Ext.device.device.IAbstract {
	}
}
declare module Ext.device.filesystem {
	export interface IAbstract extends Ext.IBase {
		/** [Method] Returns the value of fileSystemSize  
		* @returns Number 
		*/
		getFileSystemSize?(): number;
		/** [Method] Returns the value of fileSystemType  
		* @returns Number 
		*/
		getFileSystemType?(): number;
		/** [Method] Returns the value of readerType  
		* @returns String 
		*/
		getReaderType?(): string;
		/** [Method] Returns the value of stringEncoding  
		* @returns String 
		*/
		getStringEncoding?(): string;
		/** [Method] Sets the value of fileSystemSize  
		* @param fileSystemSize Number The new value. 
		*/
		setFileSystemSize?( fileSystemSize?:number ): void;
		/** [Method] Sets the value of fileSystemType  
		* @param fileSystemType Number The new value. 
		*/
		setFileSystemType?( fileSystemType?:number ): void;
		/** [Method] Sets the value of readerType  
		* @param readerType String The new value. 
		*/
		setReaderType?( readerType?:string ): void;
		/** [Method] Sets the value of stringEncoding  
		* @param stringEncoding String The new value. 
		*/
		setStringEncoding?( stringEncoding?:string ): void;
	}
}
declare module Ext.device.filesystem {
	export interface IChrome extends Ext.device.filesystem.IHTML5 {
		/** [Method] Requests access to the Local File System  var me  this  var fs  Ext create Ext device File  fs requestFil  
		* @param config Object An object which contains the follow options 
		*/
		requestFileSystem?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface ICordova extends Ext.device.filesystem.IHTML5 {
		/** [Method] Downloads a file from the server saving it into the Local File System 
		* @param config Object 
		* @returns FileTransfer 
		*/
		download?( config?:any ): any;
		/** [Method]  
		* @param config Object 
		*/
		readMetadata?( config?:any ): void;
		/** [Method] Send a file to a server 
		* @param config Object 
		* @returns FileTransfer 
		*/
		upload?( config?:any ): any;
		/** [Method]  
		* @param config Object 
		*/
		writeMetadata?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface IPhoneGap extends Ext.device.filesystem.IHTML5 {
		/** [Method] Downloads a file from the server saving it into the Local File System 
		* @param config Object 
		* @returns FileTransfer 
		*/
		download?( config?:any ): any;
		/** [Method]  
		* @param config Object 
		*/
		readMetadata?( config?:any ): void;
		/** [Method] Send a file to a server 
		* @param config Object 
		* @returns FileTransfer 
		*/
		upload?( config?:any ): any;
		/** [Method]  
		* @param config Object 
		*/
		writeMetadata?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface IDirectoryEntry extends Ext.device.filesystem.IEntry {
		/** [Method] Works the same way as getFile but creates or looks up a directory  
		* @param config Object 
		*/
		getDirectory?( config?:any ): void;
		/** [Method] Requests a Directory from the Local File System 
		* @param config Object 
		*/
		getEntry?( config?:any ): void;
		/** [Method] Creates or looks up a file  
		* @param config Object The object which contains the following config options: 
		*/
		getFile?( config?:any ): void;
		/** [Method] Lists all the entries in the directory  
		* @param config Object The object which contains the following config options: 
		*/
		readEntries?( config?:any ): void;
		/** [Method] Works the same way as Ext device filesystem Entry remove but removes the directory and all of its contents if any  
		* @param config Object 
		*/
		removeRecursively?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface IEntry extends Ext.IBase {
		/** [Method] Works the same way as moveTo but copies the entry  
		* @param config Object 
		*/
		copyTo?( config?:any ): void;
		/** [Method] Returns the file system on which the entry resides  
		* @returns Ext.device.filesystem.FileSystem The entry file system. 
		*/
		getFileSystem?(): Ext.device.filesystem.IFileSystem;
		/** [Method] Returns the full absolute path from the root to the entry  
		* @returns String The entry full path. 
		*/
		getFullPath?(): string;
		/** [Method] Returns the name of the entry excluding the path leading to it  
		* @returns String The entry name. 
		*/
		getName?(): string;
		/** [Method] Looks up the parent directory containing the entry  
		* @param config Object The object which contains the following config options: 
		*/
		getParent?( config?:any ): void;
		/** [Method] Returns whether the entry is a directory  
		* @returns Boolean The entry is a directory. 
		*/
		isDirectory?(): boolean;
		/** [Method] Returns whether the entry is a file  
		* @returns Boolean The entry is a file. 
		*/
		isFile?(): boolean;
		/** [Method] Moves the entry to a different location on the file system  
		* @param config Object The object which contains the following config options: 
		*/
		moveTo?( config?:any ): void;
		/** [Method] Removes the entry from the file system  
		* @param config Object The object which contains the following config options: 
		*/
		remove?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface IFileEntry extends Ext.device.filesystem.IEntry {
		/** [Method] Requests a File Handle from the Local File System 
		* @param config Object 
		*/
		getEntry?( config?:any ): void;
		/** [Method] Returns the byte offset into the file at which the next read write will occur  
		* @returns Number The file offset. 
		*/
		getOffset?(): number;
		/** [Method] Reads the data from the file starting at the file offset  
		* @param config Object The object which contains the following config options: 
		*/
		read?( config?:any ): void;
		/** [Method] Sets the byte offset into the file at which the next read write will occur  
		* @param config Object The object which contains the following config options: 
		*/
		seek?( config?:any ): void;
		/** [Method] Truncates or extends the file to the specified size in bytes  
		* @param config Object The object which contains the following config options: 
		*/
		truncate?( config?:any ): void;
		/** [Method] Writes the data to the file starting at the file offset  
		* @param config Object The object which contains the following config options: 
		*/
		write?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface IFileSystem extends Ext.IBase {
		/** [Method] Returns a Ext device filesystem DirectoryEntry instance for the root of the file system  
		* @returns Ext.device.filesystem.DirectoryEntry The file system root directory. 
		*/
		getRoot?(): Ext.device.filesystem.IDirectoryEntry;
	}
}
declare module Ext.device.filesystem {
	export interface IHTML5 extends Ext.device.filesystem.IAbstract {
		/** [Method] Requests a Ext device filesystem FileSystem instance  
		* @param config Object The object which contains the following config options: 
		*/
		requestFileSystem?( config?:any ): void;
	}
}
declare module Ext.device {
	export interface IFileSystem extends Ext.IBase,Ext.device.filesystem.ISencha {
	}
	export class FileSystem {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the value of fileSystemSize  
		* @returns Number 
		*/
		static getFileSystemSize(): number;
		/** [Method] Returns the value of fileSystemType  
		* @returns Number 
		*/
		static getFileSystemType(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of readerType  
		* @returns String 
		*/
		static getReaderType(): string;
		/** [Method] Returns the value of stringEncoding  
		* @returns String 
		*/
		static getStringEncoding(): string;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Requests a Ext device filesystem FileSystem instance  
		* @param config Object The object which contains the following config options: 
		*/
		static requestFileSystem( config?:any ): void;
		/** [Method] Sets the value of fileSystemSize  
		* @param fileSystemSize Number The new value. 
		*/
		static setFileSystemSize( fileSystemSize?:number ): void;
		/** [Method] Sets the value of fileSystemType  
		* @param fileSystemType Number The new value. 
		*/
		static setFileSystemType( fileSystemType?:number ): void;
		/** [Method] Sets the value of readerType  
		* @param readerType String The new value. 
		*/
		static setReaderType( readerType?:string ): void;
		/** [Method] Sets the value of stringEncoding  
		* @param stringEncoding String The new value. 
		*/
		static setStringEncoding( stringEncoding?:string ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.filesystem {
	export interface ISencha extends Ext.device.filesystem.IAbstract {
		/** [Method] Requests a Ext device filesystem FileSystem instance  
		* @param config Object The object which contains the following config options: 
		*/
		requestFileSystem?( config?:any ): void;
	}
}
declare module Ext.device.filesystem {
	export interface ISimulator extends Ext.device.filesystem.IHTML5 {
	}
}
declare module Ext.device.geolocation {
	export interface IAbstract extends Ext.IBase {
		/** [Config Option] (Boolean) */
		allowHighAccuracy?: boolean;
		/** [Config Option] (Number) */
		frequency?: number;
		/** [Config Option] (Number) */
		maximumAge?: number;
		/** [Config Option] (Number) */
		timeout?: number;
		/** [Method] If you are currently watching for the current position this will stop that task  */
		clearWatch?(): void;
		/** [Method] Returns the value of allowHighAccuracy  
		* @returns Boolean 
		*/
		getAllowHighAccuracy?(): boolean;
		/** [Method] Attempts to get the current position of this device  
		* @param config Object An object which contains the following config options: 
		*/
		getCurrentPosition?( config?:any ): void;
		/** [Method] Returns the value of frequency  
		* @returns Number 
		*/
		getFrequency?(): number;
		/** [Method] Returns the value of maximumAge  
		* @returns Number 
		*/
		getMaximumAge?(): number;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		getTimeout?(): number;
		/** [Method] Sets the value of allowHighAccuracy  
		* @param allowHighAccuracy Boolean The new value. 
		*/
		setAllowHighAccuracy?( allowHighAccuracy?:boolean ): void;
		/** [Method] Sets the value of frequency  
		* @param frequency Number The new value. 
		*/
		setFrequency?( frequency?:number ): void;
		/** [Method] Sets the value of maximumAge  
		* @param maximumAge Number The new value. 
		*/
		setMaximumAge?( maximumAge?:number ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		setTimeout?( timeout?:number ): void;
		/** [Method] Watches for the current position and calls the callback when successful depending on the specified frequency  
		* @param config Object An object which contains the following config options: 
		*/
		watchPosition?( config?:any ): void;
	}
}
declare module Ext.device.geolocation {
	export interface ICordova extends Ext.device.geolocation.IAbstract {
		/** [Method] If you are currently watching for the current position this will stop that task  */
		clearWatch?(): void;
		/** [Method] Attempts to get the current position of this device  
		* @param config Object 
		*/
		getCurrentPosition?( config?:any ): void;
		/** [Method] Watches for the current position and calls the callback when successful depending on the specified frequency  
		* @param config Object 
		*/
		watchPosition?( config?:any ): void;
	}
}
declare module Ext.device.geolocation {
	export interface IPhoneGap extends Ext.device.geolocation.IAbstract {
		/** [Method] If you are currently watching for the current position this will stop that task  */
		clearWatch?(): void;
		/** [Method] Attempts to get the current position of this device  
		* @param config Object 
		*/
		getCurrentPosition?( config?:any ): void;
		/** [Method] Watches for the current position and calls the callback when successful depending on the specified frequency  
		* @param config Object 
		*/
		watchPosition?( config?:any ): void;
	}
}
declare module Ext.device {
	export interface IGeolocation extends Ext.IBase,Ext.device.geolocation.IAbstract {
	}
	export class Geolocation {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] If you are currently watching for the current position this will stop that task  */
		static clearWatch(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the value of allowHighAccuracy  
		* @returns Boolean 
		*/
		static getAllowHighAccuracy(): boolean;
		/** [Method] Attempts to get the current position of this device  
		* @param config Object An object which contains the following config options: 
		*/
		static getCurrentPosition( config?:any ): void;
		/** [Method] Returns the value of frequency  
		* @returns Number 
		*/
		static getFrequency(): number;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of maximumAge  
		* @returns Number 
		*/
		static getMaximumAge(): number;
		/** [Method] Returns the value of timeout  
		* @returns Number 
		*/
		static getTimeout(): number;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Sets the value of allowHighAccuracy  
		* @param allowHighAccuracy Boolean The new value. 
		*/
		static setAllowHighAccuracy( allowHighAccuracy?:boolean ): void;
		/** [Method] Sets the value of frequency  
		* @param frequency Number The new value. 
		*/
		static setFrequency( frequency?:number ): void;
		/** [Method] Sets the value of maximumAge  
		* @param maximumAge Number The new value. 
		*/
		static setMaximumAge( maximumAge?:number ): void;
		/** [Method] Sets the value of timeout  
		* @param timeout Number The new value. 
		*/
		static setTimeout( timeout?:number ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Watches for the current position and calls the callback when successful depending on the specified frequency  
		* @param config Object An object which contains the following config options: 
		*/
		static watchPosition( config?:any ): void;
	}
}
declare module Ext.device.geolocation {
	export interface ISencha extends Ext.device.geolocation.IAbstract {
		/** [Method] If you are currently watching for the current position this will stop that task  */
		clearWatch?(): void;
		/** [Method] Attempts to get the current position of this device  
		* @param config Object 
		*/
		getCurrentPosition?( config?:any ): void;
		/** [Method] Watches for the current position and calls the callback when successful depending on the specified frequency  
		* @param config Object 
		*/
		watchPosition?( config?:any ): void;
	}
}
declare module Ext.device.geolocation {
	export interface ISimulator extends Ext.device.geolocation.IAbstract {
		/** [Method] If you are currently watching for the current position this will stop that task  */
		clearWatch?(): void;
		/** [Method] Attempts to get the current position of this device  
		* @param config Object 
		*/
		getCurrentPosition?( config?:any ): void;
		/** [Method] Watches for the current position and calls the callback when successful depending on the specified frequency  
		* @param config Object 
		*/
		watchPosition?( config?:any ): void;
	}
}
declare module Ext.device.globalization {
	export interface IAbstract extends Ext.IBase,Ext.mixin.IObservable {
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of currencyCode  
		* @returns String 
		*/
		getCurrencyCode?(): string;
		/** [Method] Returns the value of dateType  
		* @returns String 
		*/
		getDateType?(): string;
		/** [Method] Returns the value of formatLength  
		* @returns String 
		*/
		getFormatLength?(): string;
		/** [Method] Returns the value of items  
		* @returns String 
		*/
		getItems?(): string;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of numberType  
		* @returns String 
		*/
		getNumberType?(): string;
		/** [Method] Returns the value of selector  
		* @returns String 
		*/
		getSelector?(): string;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of currencyCode  
		* @param currencyCode String The new value. 
		*/
		setCurrencyCode?( currencyCode?:string ): void;
		/** [Method] Sets the value of dateType  
		* @param dateType String The new value. 
		*/
		setDateType?( dateType?:string ): void;
		/** [Method] Sets the value of formatLength  
		* @param formatLength String The new value. 
		*/
		setFormatLength?( formatLength?:string ): void;
		/** [Method] Sets the value of items  
		* @param items String The new value. 
		*/
		setItems?( items?:string ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of numberType  
		* @param numberType String The new value. 
		*/
		setNumberType?( numberType?:string ): void;
		/** [Method] Sets the value of selector  
		* @param selector String The new value. 
		*/
		setSelector?( selector?:string ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.globalization {
	export interface ICordova extends Ext.device.globalization.IAbstract {
	}
}
declare module Ext.device.globalization {
	export interface IPhoneGap extends Ext.device.globalization.IAbstract {
	}
}
declare module Ext.device {
	export interface IGlobalization extends Ext.IBase {
	}
	export class Globalization {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.globalization {
	export interface ISimulator extends Ext.device.globalization.IAbstract {
	}
}
declare module Ext.device.media {
	export interface IAbstract extends Ext.IBase,Ext.mixin.IObservable {
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Returns the value of src  
		* @returns Object 
		*/
		getSrc?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Sets the value of src  
		* @param src Object The new value. 
		*/
		setSrc?( src?:any ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.media {
	export interface ICordova extends Ext.device.media.IAbstract {
		/** [Property] (String) */
		src?: string;
	}
}
declare module Ext.device.media {
	export interface IPhoneGap extends Ext.device.media.IAbstract {
		/** [Property] (String) */
		src?: string;
	}
}
declare module Ext.device {
	export interface IMedia extends Ext.IBase,Ext.device.media.IAbstract {
	}
	export class Media {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object  */
		static clearListeners(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		static fireAction( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		static getBubbleEvents(): any;
		/** [Method] Retrieves the id of this component  
		* @returns String id 
		*/
		static getId(): string;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		static getListeners(): any;
		/** [Method] Returns the value of src  
		* @returns Object 
		*/
		static getSrc(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static mon( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static mun( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		static relayEvents( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static removeListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static removeManagedListener( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		static resumeEvents( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		static setBubbleEvents( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		static setListeners( listeners?:any ): void;
		/** [Method] Sets the value of src  
		* @param src Object The new value. 
		*/
		static setSrc( src?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends the firing of all events  */
		static suspendEvents(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static un( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.notification {
	export interface IAbstract extends Ext.IBase {
		/** [Method] A simple way to show a notification  
		* @param config Object An object which contains the following config options: 
		*/
		show?( config?:any ): void;
		/** [Method] Vibrates the device  */
		vibrate?(): void;
	}
}
declare module Ext.device.notification {
	export interface ICordova extends Ext.device.notification.IAbstract {
		/** [Method] A simple way to show a notification  
		* @param config Object 
		*/
		show?( config?:any ): void;
		/** [Method] Vibrates the device  
		* @param time Object 
		*/
		vibrate?( time?:any ): void;
	}
}
declare module Ext.device.notification {
	export interface IPhoneGap extends Ext.device.notification.IAbstract {
		/** [Method] A simple way to show a notification  
		* @param config Object 
		*/
		show?( config?:any ): void;
		/** [Method] Vibrates the device  
		* @param time Object 
		*/
		vibrate?( time?:any ): void;
	}
}
declare module Ext.device {
	export interface INotification extends Ext.IBase,Ext.device.notification.IAbstract {
	}
	export class Notification {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] A simple way to show a notification  
		* @param config Object An object which contains the following config options: 
		*/
		static show( config?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Vibrates the device  */
		static vibrate(): void;
	}
}
declare module Ext.device.notification {
	export interface ISencha extends Ext.device.notification.IAbstract {
		/** [Method] A simple way to show a notification  */
		show?(): void;
		/** [Method] Vibrates the device  */
		vibrate?(): void;
	}
}
declare module Ext.device.notification {
	export interface ISimulator extends Ext.device.notification.IAbstract {
		/** [Method] A simple way to show a notification  */
		show?(): void;
		/** [Method] Vibrates the device  */
		vibrate?(): void;
	}
}
declare module Ext.device.orientation {
	export interface IAbstract extends Ext.IBase,Ext.mixin.IObservable {
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		addBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		addEvents?( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		addListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		addManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes all listeners for this object  */
		clearListeners?(): void;
		/** [Method]  */
		destroy?(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		enableBubble?( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		fireAction?( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		fireEvent?( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		getBubbleEvents?(): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		getListeners?(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		hasListener?( eventName?:string ): boolean;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		mon?( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		mun?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		on?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		onBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		relayEvents?( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeAfterListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		removeBeforeListener?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		removeListener?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		removeManagedListener?( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		resumeEvents?( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		setBubbleEvents?( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		setListeners?( listeners?:any ): void;
		/** [Method] Suspends the firing of all events  */
		suspendEvents?(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		un?( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unAfter?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		unBefore?( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.orientation {
	export interface IHTML5 extends Ext.device.orientation.IAbstract {
	}
}
declare module Ext.device {
	export interface IOrientation extends Ext.IBase,Ext.device.orientation.IAbstract {
	}
	export class Orientation {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Removes all listeners for this object  */
		static clearListeners(): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Enables events fired by this Observable to bubble up an owner hierarchy by calling this getBubbleTarget  if present  
		* @param events String/String[] The event name to bubble, or an Array of event names. 
		*/
		static enableBubble( events?:any ): void;
		/** [Method] Fires the specified event with the passed parameters and execute a function action at the end if there are no liste  
		* @param eventName String The name of the event to fire. 
		* @param args Array Arguments to pass to handers. 
		* @param fn Function Action. 
		* @param scope Object Scope of fn. 
		* @returns Object 
		*/
		static fireAction( eventName?:string, args?:any[], fn?:any, scope?:any ): any;
		/** [Method] Fires the specified event with the passed parameters minus the event name plus the options object passed to addList  
		* @param eventName String The name of the event to fire. 
		* @param args Object... Variable number of parameters are passed to handlers. 
		* @returns Boolean Returns false if any of the handlers return false. 
		*/
		static fireEvent( eventName:string, ...args:any[] ): boolean;
		/** [Method] Returns the value of bubbleEvents  
		* @returns String/String[] 
		*/
		static getBubbleEvents(): any;
		/** [Method] Retrieves the id of this component  
		* @returns String id 
		*/
		static getId(): string;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns the value of listeners  
		* @returns Object 
		*/
		static getListeners(): any;
		/** [Method] Checks to see if this object has any listeners for a specified event 
		* @param eventName String The name of the event to check for 
		* @returns Boolean True if the event is being listened for, else false 
		*/
		static hasListener( eventName?:string ): boolean;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Alias for addManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static mon( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeManagedListener  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static mun( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Alias for addListener  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static on( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for addAfterListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for addBeforeListener  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static onBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Relays selected events from the specified Observable as if the events were fired by this  
		* @param object Object The Observable whose events this object is to relay. 
		* @param events String/Array/Object Array of event names to relay. 
		* @returns Ext.mixin.Observable this 
		*/
		static relayEvents( object?:any, events?:any ): Ext.mixin.IObservable;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes a before event handler  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static removeBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Removes an event handler  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static removeListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		*/
		static removeManagedListener( object?:any, eventName?:any, fn?:any, scope?:any ): void;
		/** [Method] Resumes firing events see suspendEvents 
		* @param discardQueuedEvents Boolean Pass as true to discard any queued events. 
		*/
		static resumeEvents( discardQueuedEvents?:boolean ): void;
		/** [Method] Sets the value of bubbleEvents  
		* @param bubbleEvents String/String[] The new value. 
		*/
		static setBubbleEvents( bubbleEvents?:any ): void;
		/** [Method] Sets the value of listeners  
		* @param listeners Object The new value. 
		*/
		static setListeners( listeners?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
		/** [Method] Suspends the firing of all events  */
		static suspendEvents(): void;
		/** [Method] Alias for removeListener  
		* @param eventName String/String[]/Object The type of event the handler was associated with. 
		* @param fn Function/String The handler to remove. This must be a reference to the function passed into the addListener call. 
		* @param scope Object The scope originally specified for the handler. It must be the same as the scope argument specified in the original call to addListener or the listener will not be removed. 
		* @param options Object Extra options object. See addListener for details. 
		* @param order String The order of the listener to remove. Possible values are before, current and after. 
		*/
		static un( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Alias for removeAfterListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unAfter( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Alias for removeBeforeListener  
		* @param eventName String/String[]/Object The name of the event the handler was associated with. 
		* @param fn Function/String The handler to remove. 
		* @param scope Object The scope originally specified for fn. 
		* @param options Object Extra options object. 
		*/
		static unBefore( eventName?:any, fn?:any, scope?:any, options?:any ): void;
	}
}
declare module Ext.device.orientation {
	export interface ISencha extends Ext.device.orientation.IAbstract {
	}
}
declare module Ext.device {
	export interface IPurchases extends Ext.IBase,Ext.device.purchases.ISencha {
	}
	export class Purchases {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method] Checks if the current user is able to make payments  
		* @param config Object 
		*/
		static canMakePayments( config?:any ): void;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns a Ext data Store instance of all purchases delivered to the current user  
		* @param config Object 
		*/
		static getCompletedPurchases( config?:any ): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Returns a Ext data Store instance of all products available to purchase  
		* @param config Object 
		*/
		static getProducts( config?:any ): void;
		/** [Method] Returns a Ext data Store instance of all purchases the current user has been charged  
		* @param config Object 
		*/
		static getPurchases( config?:any ): void;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.purchases {
	export interface IProduct extends Ext.data.IModel {
		/** [Config Option] (Object[]/String[]) */
		fields?: any;
		/** [Method] Returns the value of fields  
		* @returns Array 
		*/
		getFields?(): any[];
		/** [Method] Will attempt to purchase this product  
		* @param config Object 
		*/
		purchase?( config?:any ): void;
		/** [Method] Sets the value of fields  
		* @param fields Array The new value. 
		*/
		setFields?( fields?:any[] ): void;
	}
}
declare module Ext.device.purchases {
	export interface IPurchase extends Ext.data.IModel {
		/** [Config Option] (Object[]/String[]) */
		fields?: any;
		/** [Method] Attempts to mark this purchase as complete 
		* @param config Object 
		*/
		complete?( config?:any ): void;
		/** [Method] Returns the value of fields  
		* @returns Array 
		*/
		getFields?(): any[];
		/** [Method] Sets the value of fields  
		* @param fields Array The new value. 
		*/
		setFields?( fields?:any[] ): void;
	}
}
declare module Ext.device.purchases {
	export interface ISencha extends Ext.IBase {
		/** [Method] Checks if the current user is able to make payments  
		* @param config Object 
		*/
		canMakePayments?( config?:any ): void;
		/** [Method] Returns a Ext data Store instance of all purchases delivered to the current user  
		* @param config Object 
		*/
		getCompletedPurchases?( config?:any ): void;
		/** [Method] Returns a Ext data Store instance of all products available to purchase  
		* @param config Object 
		*/
		getProducts?( config?:any ): void;
		/** [Method] Returns a Ext data Store instance of all purchases the current user has been charged  
		* @param config Object 
		*/
		getPurchases?( config?:any ): void;
	}
}
declare module Ext.device.push {
	export interface IAbstract extends Ext.IBase {
		/** [Property] (Number) */
		ALERT?: number;
		/** [Property] (Number) */
		BADGE?: number;
		/** [Property] (Number) */
		SOUND?: number;
		/** [Method] Registers a push notification  
		* @param config Object The configuration for to pass when registering this push notification service. 
		*/
		register?( config?:any ): void;
	}
}
declare module Ext.device.push {
	export interface ICordova extends Ext.device.push.IAbstract {
		/** [Method] Registers a push notification  */
		register?(): void;
	}
}
declare module Ext.device {
	export interface IPush extends Ext.IBase,Ext.device.push.IAbstract {
	}
	export class Push {
		/** [Property] (Number) */
		static ALERT: number;
		/** [Property] (Number) */
		static BADGE: number;
		/** [Property] (Number) */
		static SOUND: number;
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Registers a push notification  
		* @param config Object The configuration for to pass when registering this push notification service. 
		*/
		static register( config?:any ): void;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.push {
	export interface ISencha extends Ext.device.push.IAbstract {
		/** [Method] Registers a push notification  */
		register?(): void;
	}
}
declare module Ext.device.splashscreen {
	export interface IAbstract extends Ext.IBase {
	}
}
declare module Ext.device.splashscreen {
	export interface ICordova extends Ext.device.splashscreen.IAbstract {
	}
}
declare module Ext.device.splashscreen {
	export interface IPhoneGap extends Ext.device.splashscreen.IAbstract {
	}
}
declare module Ext.device {
	export interface ISplashscreen extends Ext.IBase {
	}
	export class Splashscreen {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.splashscreen {
	export interface ISimulator extends Ext.device.splashscreen.IAbstract {
	}
}
declare module Ext.device.sqlite {
	export interface IDatabase extends Ext.IBase {
		/** [Method] Verifies and changes the version of the database at the same time as doing a schema update with a Ext device sqlite S  
		* @param config Object The object which contains the following config options: 
		*/
		changeVersion?( config?:any ): void;
		/** [Method] Returns the current version of the database  
		* @returns String The database current version. 
		*/
		getVersion?(): string;
		/** [Method] Works the same way as transaction but performs a Ext device sqlite SQLTransaction instance in a read only mode  
		* @param config Object 
		*/
		readTransaction?( config?:any ): void;
		/** [Method] Performs a Ext device sqlite SQLTransaction instance in a read write mode  
		* @param config Object The object which contains the following config options: 
		*/
		transaction?( config?:any ): void;
	}
}
declare module Ext.device {
	export interface ISQLite extends Ext.IBase,Ext.device.sqlite.ISencha {
	}
	export class SQLite {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callSuper(arguments) 
		* @returns Object Returns the result of calling the superclass method 
		*/
		static callSuper( args?:any ): any;
		/** [Method]  */
		static destroy(): void;
		/** [Method] Returns the initial configuration passed to constructor  
		* @param name String When supplied, value for particular configuration option is returned, otherwise the full config object is returned. 
		* @returns Object/Mixed 
		*/
		static getInitialConfig( name?:string ): any;
		/** [Method] Initialize configuration for this class  
		* @param instanceConfig Object 
		* @returns Object mixins The mixin prototypes as key - value pairs 
		*/
		static initConfig( instanceConfig?:any ): any;
		/** [Method] Returns a Ext device sqlite Database instance  
		* @param config Object The object which contains the following config options: 
		* @returns Ext.device.sqlite.Database The opened database, null if an error occured. 
		*/
		static openDatabase( config?:any ): Ext.device.sqlite.IDatabase;
		/** [Method] Get the reference to the class from which this object was instantiated  
		* @returns Ext.Class 
		*/
		static statics(): Ext.IClass;
	}
}
declare module Ext.device.sqlite {
	export interface ISencha extends Ext.IBase {
		/** [Method] Returns a Ext device sqlite Database instance  
		* @param config Object The object which contains the following config options: 
		* @returns Ext.device.sqlite.Database The opened database, null if an error occured. 
		*/
		openDatabase?( config?:any ): Ext.device.sqlite.IDatabase;
	}
}
declare module Ext.device.sqlite {
	export interface ISQLResultSet extends Ext.IBase {
		/** [Method] Returns the row ID of the last row that the SQL statement inserted into the database if the statement inserted any r  
		* @returns Number The inserted row ID. 
		*/
		getInsertId?(): number;
		/** [Method] Returns a Ext device sqlite SQLResultSetRowList instance representing rows returned by the SQL statement  
		* @returns Ext.device.sqlite.SQLResultSetRowList The rows. 
		*/
		getRows?(): Ext.device.sqlite.ISQLResultSetRowList;
		/** [Method] Returns the number of rows that were changed by the SQL statement  
		* @returns Number The number of rows affected. 
		*/
		getRowsAffected?(): number;
	}
}
declare module Ext.device.sqlite {
	export interface ISQLResultSetRowList extends Ext.IBase {
		/** [Method] Returns the number of rows returned by the SQL statement  
		* @returns Number The number of rows. 
		*/
		getLength?(): number;
		/** [Method] Returns a row at specified index returned by the SQL statement  
		* @param index Number This is required. The index of a row. 
		* @returns Object The row. 
		*/
		item?( index?:number ): any;
	}
}
declare module Ext.device.sqlite {
	export interface ISQLTransaction extends Ext.IBase {
		/** [Method] Executes an SQL statement  
		* @param config Object The object which contains the following config options: 
		*/
		executeSql?( config?:any ): void;
	}
}
declare module Ext.device.storage {
	export interface IAbstract extends Ext.IBase {
		/** [Method] Returns the value of databaseDisplayName  
		* @returns String 
		*/
		getDatabaseDisplayName?(): string;
		/** [Method] Returns the value of databaseName  
		* @returns String 
		*/
		getDatabaseName?(): string;
		/** [Method] Returns the value of databaseSize  
		* @returns Object 
		*/
		getDatabaseSize?(): any;
		/** [Method] Returns the value of databaseVersion  
		* @returns String 
		*/
		getDatabaseVersion?(): string;
		/** [Method] Sets the value of databaseDisplayName  
		* @param databaseDisplayName String The new value. 
		*/
		setDatabaseDisplayName?( databaseDisplayName?:string ): void;
		/** [Method] Sets the value of databaseName  
		* @param databaseName String The new value. 
		*/
		setDatabaseName?( databaseName?:string ): void;
		/** [Method] Sets the value of databaseSize  
		* @param databaseSize Object The new value. 
		*/
		setDatabaseSize?( databaseSize?:any ): void;
		/** [Method] Sets the value of databaseVersion  
		* @param databaseVersion String The new value. 
		*/
		setDatabaseVersion?( databaseVersion?:string ): void;
	}
}
declare module Ext.device.storage {
	export interface ICordova extends Ext.device.storage.html5.IHTML5 {
	}
}
declare module Ext.device.storage {
	export interface IPhoneGap extends Ext.device.storage.html5.IHTML5 {
	}
}
declare module Ext.device.storage.html5 {
	export interface IDatabase extends Ext.IBase {
		/** [Method]  
		* @param sql String/String[]/Object/Object[]/SQLStatement/SQLStatement[] SQL Command to run with optional arguments and callbacks 
		* @param success Function callback for successful transaction 
		* @param failure Function callback for failed transaction 
		*/
		transaction?( sql?:any, success?:any, failure?:any ): void;
	}
}
declare module Ext.device.storage.html5 {
	export interface IHTML5 extends Ext.device.storage.IAbstract {
	}
}
declare module Ext.device.storage.html5 {
	export interface ISQLStatement extends Ext.IBase {
	}
}
declare module Ext.device.storage {
	export interface ISimulator extends Ext.device.storage.html5.IHTML5 {
	}
}
declare module Ext.device.tunnel {
	export interface IAbstract extends Ext.IBase {
		/** [Method] Broadcast a message intent to look for receivers who can respond to it 
		* @param message String 
		* @returns Ext.Promise A promise which provides an array of objects upon fulfilled. Each object contains information about a receiver, with 'id', 'name' and 'icon' keys. 
		*/
		broadcast?( message?:string ): Ext.IPromise;
		/** [Method] Create a connection to another application with the given id 
		* @param receiverId String The id of the application to connect to. Get this id from broadcast 
		* @returns Ext.Promise 
		*/
		connect?( receiverId?:string ): Ext.IPromise;
		/** [Method] Assign the callback to handle new connection  
		* @param callback Function 
		*/
		onConnect?( callback?:any ): void;
		/** [Method] Assign the callback to handling incoming messages  
		* @param callback Function 
		*/
		onMessage?( callback?:any ): void;
		/** [Method] Send a message 
		* @param receiverId String The id of the application to connect to. Get this id from broadcast 
		* @param message * The message to send, can be an object, as long as it is JSON-able. 
		* @param foreground Boolean Whether or not to bring the receiver app to the foreground 
		* @returns Ext.Promise 
		*/
		send?( receiverId?:string, message?:any, foreground?:boolean ): Ext.IPromise;
	}
}
declare module Ext.direct {
	export interface IEvent extends Ext.IBase {
		/** [Config Option] (Object) */
		data?: any;
		/** [Config Option] (String) */
		name?: string;
		/** [Method] Returns the value of code  
		* @returns Object 
		*/
		getCode?(): any;
		/** [Method] Returns the value of data  
		* @returns Object 
		*/
		getData?(): any;
		/** [Method] Returns the value of message  
		* @returns String 
		*/
		getMessage?(): string;
		/** [Method] Returns the value of name  
		* @returns String 
		*/
		getName?(): string;
		/** [Method] Returns the value of result  
		* @returns Object 
		*/
		getResult?(): any;
		/** [Method] Returns the value of status  
		* @returns Boolean 
		*/
		getStatus?(): boolean;
		/** [Method] Returns the value of transaction  
		* @returns Object 
		*/
		getTransaction?(): any;
		/** [Method] Returns the value of xhr  
		* @returns Object 
		*/
		getXhr?(): any;
		/** [Method] Sets the value of code  
		* @param code Object The new value. 
		*/
		setCode?( code?:any ): void;
		/** [Method] Sets the value of data  
		* @param data Object The new value. 
		*/
		setData?( data?:any ): void;
		/** [Method] Sets the value of message  
		* @param message String The new value. 
		*/
		setMessage?( message?:string ): void;
		/** [Method] Sets the value of name  
		* @param name String The new value. 
		*/
		setName?( name?:string ): void;
		/** [Method] Sets the value of result  
		* @param result Object The new value. 
		*/
		setResult?( result?:any ): void;
		/** [Method] Sets the value of status  
		* @param status Boolean The new value. 
		*/
		setStatus?( status?:boolean ): void;
		/** [Method] Sets the value of transaction  
		* @param transaction Object The new value. 
		*/
		setTransaction?( transaction?:any ): void;
		/** [Method] Sets the value of xhr  
		* @param xhr Object The new value. 
		*/
		setXhr?( xhr?:any ): void;
	}
}
declare module Ext.direct {
	export interface IExceptionEvent extends Ext.direct.IRemotingEvent {
		/** [Config Option] (String) */
		name?: string;
		/** [Method] Returns the value of error  
		* @returns Object 
		*/
		getError?(): any;
		/** [Method] Returns the value of name  
		* @returns String 
		*/
		getName?(): string;
		/** [Method] Returns the value of status  
		* @returns Boolean 
		*/
		getStatus?(): boolean;
		/** [Method] Sets the value of error  
		* @param error Object The new value. 
		*/
		setError?( error?:any ): void;
		/** [Method] Sets the value of name  
		* @param name String The new value. 
		*/
		setName?( name?:string ): void;
		/** [Method] Sets the value of status  
		* @param status Boolean The new value. 
		*/
		setStatus?( status?:boolean ): void;
	}
}
declare module Ext.direct {
	export interface IJsonProvider extends Ext.direct.IProvider {
		/** [Method] Create an event from a response object  
		* @param response Object The XHR response object. 
		* @returns Ext.direct.Event The event. 
		*/
		createEvent?( response?:any ): Ext.direct.IEvent;
	}
}
declare module Ext.direct {
	export interface IManager extends Ext.IBase,Ext.mixin.IObservable {
	}
	export class Manager {
		/** [Property] (Ext.Class) */
		static self: Ext.IClass;
		/** [Method] Appends an after event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addAfterListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Appends a before event handler  
		* @param eventName String/String[]/Object The name of the event to listen for. 
		* @param fn Function/String The method the event invokes. 
		* @param scope Object The scope for fn. 
		* @param options Object An object containing handler configuration. 
		*/
		static addBeforeListener( eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds the specified events to the list of events which this Observable may fire  
		* @param eventNames Object/String... Either an object with event names as properties with a value of true or the first event name string if multiple event names are being passed as separate parameters. 
		*/
		static addEvents( eventNames?:any ): void;
		/** [Method] Appends an event handler to this object  
		* @param eventName String/String[]/Object The name of the event to listen for. May also be an object who's property names are event names. 
		* @param fn Function/String The method the event invokes. Will be called with arguments given to fireEvent plus the options parameter described below. 
		* @param scope Object The scope (this reference) in which the handler function is executed. If omitted, defaults to the object which fired the event. 
		* @param options Object An object containing handler configuration.  This object may contain any of the following properties: 
		* @param order String The order of when the listener should be added into the listener queue. Possible values are before, current and after. 
		*/
		static addListener( eventName?:any, fn?:any, scope?:any, options?:any, order?:string ): void;
		/** [Method] Adds listeners to any Observable object or Element which are automatically removed when this Component is destroyed  
		* @param object Ext.mixin.Observable/HTMLElement The item to which to add a listener/listeners. 
		* @param eventName Object/String The event name, or an object containing event name properties. 
		* @param fn Function If the eventName parameter was an event name, this is the handler function. 
		* @param scope Object If the eventName parameter was an event name, this is the scope in which the handler function is executed. 
		* @param options Object If the eventName parameter was an event name, this is the addListener options. 
		*/
		static addManagedListener( object?:any, eventName?:any, fn?:any, scope?:any, options?:any ): void;
		/** [Method] Adds an Ext Direct Provider and creates the proxy or stub methods to execute server side methods  
		* @param provider Ext.direct.Provider/Object... Accepts any number of Provider descriptions (an instance or config object for a Provider). Each Provider description instructs Ext.Direct how to create client-side stub methods. 
		* @returns Object 
		*/
		static addProvider( provider?:any ): any;
		/** [Method] Call the original method that was previously overridden with override  This method is deprecated as callParent does 
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callOverridden(arguments) 
		* @returns Object Returns the result of calling the overridden method 
		*/
		static callOverridden( args?:any ): any;
		/** [Method] Call the parent method of the current method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, for example: this.callParent(arguments) 
		* @returns Object Returns the result of calling the parent method 
		*/
		static callParent( args?:any ): any;
		/** [Method] This method is used by an override to call the superclass method but bypass any overridden method  
		* @param args Array/Arguments The arguments, either an array or the arguments object from the current method, fo