"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require('@angular/core');
var apollo_client_rxjs_1 = require('apollo-client-rxjs');
var Observable_1 = require('rxjs/Observable');
var ApolloQueryObservable_1 = require('./ApolloQueryObservable');
require('rxjs/add/observable/from');
exports.angularApolloClient = new core_1.OpaqueToken('AngularApolloClient');
exports.defaultApolloClient = function (client) {
    return {
        provide: exports.angularApolloClient,
        useValue: client,
    };
};
var Angular2Apollo = (function () {
    function Angular2Apollo(client) {
        this.client = client;
    }
    Angular2Apollo.prototype.watchQuery = function (options) {
        return new ApolloQueryObservable_1.ApolloQueryObservable(apollo_client_rxjs_1.rxify(this.client.watchQuery)(options));
    };
    Angular2Apollo.prototype.query = function (options) {
        return this.client.query(options);
    };
    Angular2Apollo.prototype.mutate = function (options) {
        return this.client.mutate(options);
    };
    Angular2Apollo.prototype.subscribe = function (options) {
        if (typeof this.client.subscribe === 'undefined') {
            throw new Error("Your version of ApolloClient doesn't support subscriptions");
        }
        return Observable_1.Observable.from(this.client.subscribe(options));
    };
    Angular2Apollo = __decorate([
        core_1.Injectable(),
        __param(0, core_1.Inject(exports.angularApolloClient)), 
        __metadata('design:paramtypes', [Object])
    ], Angular2Apollo);
    return Angular2Apollo;
}());
exports.Angular2Apollo = Angular2Apollo;
//# sourceMappingURL=Angular2Apollo.js.map