"use strict";
var ApolloHandle_1 = require('./utils/ApolloHandle');
var forIn = require('lodash.forin');
function Apollo(_a) {
    var client = _a.client, queries = _a.queries, mutations = _a.mutations;
    var apolloProp = '__apolloHandle';
    return function (sourceTarget) {
        var target = sourceTarget;
        var oldHooks = {};
        var hooks = {
            /**
             * Initialize the component
             * after Angular initializes the data-bound input properties.
             */
            ngOnInit: function () {
                if (!this[apolloProp]) {
                    this[apolloProp] = new ApolloHandle_1.ApolloHandle({
                        component: this,
                        client: client,
                        queries: queries,
                        mutations: mutations,
                    });
                }
                this[apolloProp].handleQueries();
                this[apolloProp].handleMutations();
            },
            /**
             * Detect and act upon changes that Angular can or won't detect on its own.
             * Called every change detection run.
             */
            ngDoCheck: function () {
                this[apolloProp].handleQueries();
                this[apolloProp].handleMutations();
            },
            /**
             * Stop all of watchQuery subscriptions
             */
            ngOnDestroy: function () {
                this[apolloProp].unsubscribe();
            },
        };
        // attach hooks
        forIn(hooks, function (hook, name) {
            wrapPrototype(name, hook);
        });
        /**
         * Creates a new prototype method which is a wrapper function
         * that calls new function before old one.
         *
         * @param  {string}   name
         * @param  {Function} func
         */
        function wrapPrototype(name, func) {
            oldHooks[name] = sourceTarget.prototype[name];
            // create a wrapper
            target.prototype[name] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i - 0] = arguments[_i];
                }
                // to call a new prototype method
                func.apply(this, args);
                // call the old prototype method
                if (oldHooks[name]) {
                    oldHooks[name].apply(this, args);
                }
            };
        }
        // return decorated target
        return target;
    };
}
exports.Apollo = Apollo;
//# sourceMappingURL=ApolloDecorator.js.map