import { ApolloQueryResult } from 'apollo-client';
import { ApolloError } from 'apollo-client/errors';
import ApolloClient from 'apollo-client';
export interface ApolloQuery {
    errors: ApolloError;
    loading: boolean;
    refetch: (variables?: any) => Promise<ApolloQueryResult>;
    fetchMore: (options: any) => Promise<any>;
    stopPolling: () => void;
    startPolling: (pollInterval: number) => void;
    unsubscribe: () => void;
}
export interface ApolloOptions {
    client: ApolloClient;
    queries?: (component?: any) => any;
    mutations?: (component?: any) => any;
}
export interface ApolloHandleOptions extends ApolloOptions {
    component: any;
}
export declare class ApolloHandle {
    private lastQueryVariables;
    private queryHandles;
    private querySubscriptions;
    private component;
    private client;
    private queries;
    private mutations;
    constructor({component, client, queries, mutations}: ApolloHandleOptions);
    handleQueries(): void;
    handleMutations(): void;
    unsubscribe(queryName?: string): void;
    private setQuery(name, handle);
    private getQuery(name);
    private setQuerySub(name, sub);
    private getQuerySub(name);
    private getAllQueriesSubs();
    /**
     * Saves variables so they can be used in futher comparasion
     * @param {string} queryName Query's name
     * @param {any}    variables used variables
     */
    private saveVariables(queryName, variables);
    /**
     * Compares current variables with previous ones.
     * @param  {string}  queryName Query's name
     * @param  {any}     variables current variables
     * @return {boolean}           comparasion result
     */
    private hasVariablesChanged(queryName, variables);
    private hasDataChanged(queryName, data);
    private createQuery(queryName, options);
    private createMutation(mutationName, method);
    private backcompat(queryName, method, ...args);
    private missingCompat(queryName, method, ...args);
    private subscribe(queryName, obs);
    private reuseQuery(queryName, {variables});
}
