"use strict";
var index_1 = require('ts-smart-logger/index');
var Cache = (function () {
    function Cache(_cache) {
        this._cache = _cache;
        this.enabled = true;
        this.loggingEnable = true;
    }
    /**
     * @override
     */
    Cache.prototype.setCachedValue = function (key, value) {
        if (!this.enabled) {
            return;
        }
        this._cache.setCachedValue(key, value);
        if (this.isLoggingEnabled()) {
            Cache.logger.debug('[Cache][setCachedValue] Set value to the cache. Key:', key, ', value: ', value, ', cache: ', this.constructor.name);
        }
    };
    /**
     * @override
     */
    Cache.prototype.getCachedValue = function (key) {
        if (!this.enabled) {
            return undefined;
        }
        var value = this._cache.getCachedValue(key);
        if (this.isLoggingEnabled() && typeof value !== "undefined") {
            Cache.logger.debug('[Cache][getCachedValue] Get value from the cache. Key:', key, ', value: ', value, ', cache: ', this.constructor.name);
        }
        return value;
    };
    /**
     * @override
     */
    Cache.prototype.clear = function () {
        if (!this.enabled) {
            return;
        }
        if (this.isLoggingEnabled()) {
            Cache.logger.debug("[Cache][clear] Clear the cache. The cache has size " + this.size() + ", cache: " + this.constructor.name);
        }
        this._cache.clear();
    };
    /**
     * @override
     */
    Cache.prototype.size = function () {
        return this._cache.size();
    };
    /**
     * @override
     */
    Cache.prototype.setEnableLogging = function (enabled) {
        this.loggingEnable = enabled;
    };
    /**
     * @override
     */
    Cache.prototype.isLoggingEnabled = function () {
        return this.loggingEnable && Cache.logger.isDebugEnabled();
    };
    /**
     * @override
     */
    Cache.prototype.setEnable = function (enabled) {
        this.enabled = enabled;
    };
    Cache.logger = index_1.LoggerFactory.makeLogger(Cache);
    return Cache;
}());
exports.Cache = Cache;
//# sourceMappingURL=Cache.js.map