"use strict";
var CacheKeyBuilder = (function () {
    function CacheKeyBuilder(parts) {
        this.parts = [];
        this.append(parts);
    }
    CacheKeyBuilder.make = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i - 0] = arguments[_i];
        }
        return new CacheKeyBuilder(args);
    };
    /**
     * We must prevent recursion using this method if an object has an overridden method
     */
    CacheKeyBuilder.prototype.appendObjectName = function (userObject) {
        this.parts.push(userObject.constructor.name);
        return this;
    };
    CacheKeyBuilder.prototype.append = function () {
        var _this = this;
        var parts = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            parts[_i - 0] = arguments[_i];
        }
        parts.forEach(function (part) {
            if (isBlank(part)) {
                _this.parts.push(part === null ? "null" : "undefined");
            }
            else {
                if (Array.isArray(part)) {
                    part.forEach(function (partItem) { return _this.append(partItem); });
                }
                else if (isDate(part)) {
                    _this.parts.push(part.getTime());
                }
                else {
                    if (part.toString && part.toString !== CacheKeyBuilder.ORIGINAL_STR_FN) {
                        /**
                         * If we have overridden the original method, we must use toString() value for identifying the object
                         */
                        _this.parts.push(part);
                    }
                    else {
                        _this.appendObjectName(part);
                    }
                }
            }
        });
        return this;
    };
    CacheKeyBuilder.prototype.build = function () {
        return this.parts.join('.');
    };
    CacheKeyBuilder.ORIGINAL_STR_FN = Object.prototype.toString;
    return CacheKeyBuilder;
}());
exports.CacheKeyBuilder = CacheKeyBuilder;
function isDate(obj) {
    return obj instanceof Date && !isNaN(obj.valueOf());
}
exports.isDate = isDate;
function isBlank(obj) {
    return obj === undefined || obj === null;
}
exports.isBlank = isBlank;
function generateUUID() {
    var currentDate = Date.now();
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var result = (currentDate + Math.random() * 16) % 16 | 0;
        currentDate = Math.floor(currentDate / 16);
        return (c == 'x' ? result : (result & 0x3 | 0x8)).toString(16);
    });
}
exports.generateUUID = generateUUID;
//# sourceMappingURL=Utils.js.map