"use strict";
var Utils_1 = require('./Utils');
describe('Utils', function () {
    describe('Checking the CacheKeyBuilder', function () {
        describe('No constructor parameters', function () {
            it('No constructor parameters. Test1', function () {
                expect(Utils_1.CacheKeyBuilder.make().append(1).append(2).build()).toEqual('1.2');
            });
            it('No constructor parameters. Test2', function () {
                var date = new Date('01/01/2016');
                expect(Utils_1.CacheKeyBuilder.make().append('key').append(date).build()).toEqual('key.1451595600000');
            });
            it('No constructor parameters. Test3', function () {
                var date = new Date('01/01/2016');
                expect(Utils_1.CacheKeyBuilder.make().append(date).build()).toEqual('1451595600000');
            });
            it('No constructor parameters. Test4', function () {
                expect(Utils_1.CacheKeyBuilder.make().build()).toEqual('');
            });
        });
        describe('Constructor parameters are present', function () {
            it('Constructor parameters are present. Test1', function () {
                expect(Utils_1.CacheKeyBuilder.make(1).append(2).append(3).build()).toEqual('1.2.3');
            });
            it('Constructor parameters are present. Test2', function () {
                var date = new Date('01/01/2016');
                expect(Utils_1.CacheKeyBuilder.make("key").append(date).build()).toEqual('key.1451595600000');
            });
            it('Constructor parameters are present. Test3', function () {
                var date = new Date('01/01/2016');
                expect(Utils_1.CacheKeyBuilder.make([1, 2, 3]).append(date).build()).toEqual('1.2.3.1451595600000');
            });
            it('Constructor parameters are present. Test4', function () {
                expect(Utils_1.CacheKeyBuilder.make([[1, 2, 3], 4, [5, 6]]).append([7, 8, [9, 10]]).build()).toEqual('1.2.3.4.5.6.7.8.9.10');
            });
            it('Constructor parameters are present. Test5', function () {
                var date = new Date('01/01/2016');
                expect(Utils_1.CacheKeyBuilder.make(1, 2, 3, 4, 5).append(6, 7, 8, 9, date).build()).toEqual('1.2.3.4.5.6.7.8.9.1451595600000');
            });
        });
        describe('User instance of class as parameter', function () {
            it('User class as parameter. Test1', function () {
                var Test = (function () {
                    function Test() {
                    }
                    Test.prototype.toString = function () {
                        return "2";
                    };
                    return Test;
                }());
                expect(Utils_1.CacheKeyBuilder.make(1).append(new Test()).append(3).build()).toEqual('1.2.3');
            });
            it('User class as parameter. Test2', function () {
                var Test = (function () {
                    function Test() {
                    }
                    Test.prototype.toString = function () {
                        return Utils_1.CacheKeyBuilder.make()
                            .appendObjectName(this)
                            .append(2)
                            .build();
                    };
                    return Test;
                }());
                expect(Utils_1.CacheKeyBuilder.make(1).append(new Test()).append(3).build()).toEqual('1.Test.2.3');
            });
            it('User class as parameter. Test3', function () {
                var Test = (function () {
                    function Test() {
                    }
                    Test.prototype.toString = function () {
                        return Utils_1.CacheKeyBuilder.make()
                            .appendObjectName(this)
                            .build();
                    };
                    return Test;
                }());
                expect(Utils_1.CacheKeyBuilder.make(new Test()).append([new Test(), new Test()]).append(100500).build()).toEqual('Test.Test.Test.100500');
            });
            it('User class as parameter. Test4', function () {
                var Test = (function () {
                    function Test() {
                    }
                    return Test;
                }());
                expect(Utils_1.CacheKeyBuilder.make(1).append(new Test()).append(3).build()).toEqual('1.Test.3');
            });
        });
        describe('Primitive wrapper as parameter', function () {
            it('Primitive wrapper as parameter. Test1', function () {
                expect(Utils_1.CacheKeyBuilder.make(1).append("2").append(false).build()).toEqual('1.2.false');
            });
        });
        describe('Null and undefined as parameter', function () {
            it('Null and undefined as parameter. Test1', function () {
                expect(Utils_1.CacheKeyBuilder.make(null, null).append(null).append(undefined).build()).toEqual('null.null.null.undefined');
            });
        });
    });
});
//# sourceMappingURL=Utils.spec.js.map