"use strict";
var Utils_1 = require('../Utils');
var CacheTypeEnum_1 = require('../CacheTypeEnum');
var provider_1 = require('./provider');
function cache(cacheType) {
    var uniqueCacheKey = Utils_1.generateUUID();
    var cacheProvider = provider_1.getProviderByType(cacheType);
    return function (target, propertyKey, descriptor) {
        var originalMethod = descriptor.value;
        descriptor.value = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i - 0] = arguments[_i];
            }
            var cache = cacheProvider.provideCache();
            if (Utils_1.isBlank(cache)) {
                return originalMethod.apply(this, args);
            }
            var compositeKey = Utils_1.CacheKeyBuilder.make(uniqueCacheKey, this /** If there are no input arguments of the function, then we should override toString() with the specific object key **/)
                .append(args)
                .build();
            var result = cache.getCachedValue(compositeKey);
            if (typeof result !== "undefined") {
                return result;
            }
            cache.setCachedValue(compositeKey, result = originalMethod.apply(this, args));
            return result;
        };
        return descriptor;
    };
}
function ZoneCached() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
    }
    return cache(CacheTypeEnum_1.CacheTypeEnum.ZONE);
}
exports.ZoneCached = ZoneCached;
function MemoryCached() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
    }
    return cache(CacheTypeEnum_1.CacheTypeEnum.MEMORY);
}
exports.MemoryCached = MemoryCached;
function SessionCached() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
    }
    return cache(CacheTypeEnum_1.CacheTypeEnum.SESSION);
}
exports.SessionCached = SessionCached;
function StorageCached() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
    }
    return cache(CacheTypeEnum_1.CacheTypeEnum.STORAGE);
}
exports.StorageCached = StorageCached;
function FileCached() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
    }
    return cache(CacheTypeEnum_1.CacheTypeEnum.FILE);
}
exports.FileCached = FileCached;
//# sourceMappingURL=cache.js.map