"use strict";
var CacheTypeEnum_1 = require('../CacheTypeEnum');
var GlobalCachesInstances_1 = require('../GlobalCachesInstances');
/**
 * Zone cache provider
 */
var ZoneCacheProvider = (function () {
    function ZoneCacheProvider() {
    }
    /**
     * @override
     */
    ZoneCacheProvider.prototype.provideCache = function () {
        return GlobalCachesInstances_1.GlobalCachesInstances.ZONE_INSTANCE;
    };
    ZoneCacheProvider.INSTANCE = new ZoneCacheProvider();
    return ZoneCacheProvider;
}());
/**
 * Memory cache provider
 */
var MemoryCacheProvider = (function () {
    function MemoryCacheProvider() {
    }
    /**
     * @override
     */
    MemoryCacheProvider.prototype.provideCache = function () {
        return GlobalCachesInstances_1.GlobalCachesInstances.MEMORY_INSTANCE;
    };
    MemoryCacheProvider.INSTANCE = new MemoryCacheProvider();
    return MemoryCacheProvider;
}());
function getProviderByType(cacheType) {
    switch (cacheType) {
        case CacheTypeEnum_1.CacheTypeEnum.ZONE:
            return ZoneCacheProvider.INSTANCE;
        case CacheTypeEnum_1.CacheTypeEnum.MEMORY:
            return MemoryCacheProvider.INSTANCE;
    }
    return null;
}
exports.getProviderByType = getProviderByType;
//# sourceMappingURL=provider.js.map