"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var core_1 = require('@angular/core');
var index_1 = require('ts-smart-logger/index');
var MemoryCache_1 = require('../memory/MemoryCache');
var GlobalCachesInstances_1 = require('../GlobalCachesInstances');
var NgZoneGlobalCache = (function (_super) {
    __extends(NgZoneGlobalCache, _super);
    function NgZoneGlobalCache(ngZone) {
        var _this = this;
        _super.call(this);
        /**
         * The onUnstable & onStable are synchronized emitters, so we can use them.
         *
         * Consider the example:
         *
         *  setTimeout(() => {
         *      console.log('Zone 1');
         *      setTimeout(() => {
         *          console.log('Zone 2');
         *          setTimeout(() => {
         *              console.log('Zone 3');
         *          }, 10000);
         *      }, 10000);
         *  }, 10000);
         *
         * In the console we'll see:
         *
         *  [$NgZoneGlobalCache][onUnstable.subscribe] Initialize the cache context zone
         *  Zone 1
         *  [$NgZoneGlobalCache][setCachedValue]..
         *  ...
         *  [$NgZoneGlobalCache][onStable.subscribe] Destruction the cache context zone. The cache with size 14 will be cleared
         *  [$NgZoneGlobalCache][onUnstable.subscribe] Initialize the cache context zone
         *  Zone 2
         *  [$NgZoneGlobalCache][setCachedValue]..
         *  ...
         */
        /**
         * Notifies when code enters Angular Zone. This gets fired first on VM Turn.
         */
        ngZone.onUnstable.subscribe(function () {
            if (_this.isLoggingEnabled()) {
                NgZoneGlobalCache.zoneLogger.debug("[$NgZoneGlobalCache][onUnstable.subscribe] Initialize the cache context zone");
            }
            _this.clear();
        });
        /**
         * Notifies when the last `onMicrotaskEmpty` has run and there are no more microtasks, which
         * implies we are about to relinquish VM turn.
         * This event gets called just once.
         */
        ngZone.onStable.subscribe(function () {
            if (_this.isLoggingEnabled()) {
                NgZoneGlobalCache.zoneLogger.debug("[$NgZoneGlobalCache][onStable.subscribe] Destruction the cache context zone. The cache with size " + _this.size() + " will be cleared");
            }
            _this.clear();
        });
        GlobalCachesInstances_1.GlobalCachesInstances.ZONE_INSTANCE = this;
    }
    NgZoneGlobalCache.zoneLogger = index_1.LoggerFactory.makeLogger(NgZoneGlobalCache);
    NgZoneGlobalCache.decorators = [
        { type: core_1.Injectable },
    ];
    /** @nocollapse */
    NgZoneGlobalCache.ctorParameters = [
        { type: core_1.NgZone, decorators: [{ type: core_1.Inject, args: [core_1.NgZone,] },] },
    ];
    return NgZoneGlobalCache;
}(MemoryCache_1.MemoryCache));
exports.NgZoneGlobalCache = NgZoneGlobalCache;
//# sourceMappingURL=NgZoneGlobalCache.js.map