System.registerDynamic("angular2-cookie/services/cookies.service", ["angular2/core", "angular2/src/facade/lang", "angular2-cookie/services/base-cookie-options"], true, function($__require, exports, module) {
  "use strict";
  ;
  var global = this,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var core_1 = $__require('angular2/core');
  var lang_1 = $__require('angular2/src/facade/lang');
  var base_cookie_options_1 = $__require('angular2-cookie/services/base-cookie-options');
  var CookieService = (function() {
    function CookieService(_defaultOptions) {
      this._defaultOptions = _defaultOptions;
    }
    CookieService.prototype.get = function(key) {
      return this._cookieReader()[key];
    };
    CookieService.prototype.getObject = function(key) {
      var value = this.get(key);
      return value ? lang_1.Json.parse(value) : value;
    };
    CookieService.prototype.getAll = function() {
      return this._cookieReader();
    };
    CookieService.prototype.put = function(key, value, options) {
      this._cookieWriter()(key, value, options);
    };
    CookieService.prototype.putObject = function(key, value, options) {
      this.put(key, lang_1.Json.stringify(value), options);
    };
    CookieService.prototype.remove = function(key, options) {
      this._cookieWriter()(key, undefined, options);
    };
    CookieService.prototype.removeAll = function() {
      var _this = this;
      var cookies = this.getAll();
      Object.keys(cookies).forEach(function(key) {
        _this.remove(key);
      });
    };
    CookieService.prototype._cookieReader = function() {
      var rawDocument = document;
      var lastCookies = {};
      var lastCookieString = '';
      var that = this;
      var cookieArray,
          cookie,
          i,
          index,
          name;
      var currentCookieString = rawDocument.cookie || '';
      if (currentCookieString !== lastCookieString) {
        lastCookieString = currentCookieString;
        cookieArray = lastCookieString.split('; ');
        lastCookies = {};
        for (i = 0; i < cookieArray.length; i++) {
          cookie = cookieArray[i];
          index = cookie.indexOf('=');
          if (index > 0) {
            name = that._safeDecodeURIComponent(cookie.substring(0, index));
            if (lang_1.isBlank(lastCookies[name])) {
              lastCookies[name] = that._safeDecodeURIComponent(cookie.substring(index + 1));
            }
          }
        }
      }
      return lastCookies;
    };
    CookieService.prototype._cookieWriter = function() {
      var that = this;
      var rawDocument = document;
      return function(name, value, options) {
        rawDocument.cookie = that._buildCookieString(name, value, options);
      };
    };
    CookieService.prototype._safeDecodeURIComponent = function(str) {
      try {
        return decodeURIComponent(str);
      } catch (e) {
        return str;
      }
    };
    CookieService.prototype._buildCookieString = function(name, value, options) {
      var cookiePath = '/';
      var path,
          expires;
      var defaultOpts = this._defaultOptions || new base_cookie_options_1.CookieOptions({path: cookiePath});
      var opts = this._mergeOptions(defaultOpts, options);
      expires = opts.expires;
      if (lang_1.isBlank(value)) {
        expires = 'Thu, 01 Jan 1970 00:00:00 GMT';
        value = '';
      }
      if (lang_1.isString(expires)) {
        expires = new Date(expires);
      }
      var str = encodeURIComponent(name) + '=' + encodeURIComponent(value);
      str += opts.path ? ';path=' + opts.path : '';
      str += opts.domain ? ';domain=' + opts.domain : '';
      str += expires ? ';expires=' + expires.toUTCString() : '';
      str += opts.secure ? ';secure' : '';
      var cookieLength = str.length + 1;
      if (cookieLength > 4096) {
        console.log("Cookie '" + name + "' possibly not set or overflowed because it was too large (" + cookieLength + " > 4096 bytes)!");
      }
      return str;
    };
    CookieService.prototype._mergeOptions = function(defaultOpts, providedOpts) {
      var newOpts = defaultOpts;
      if (lang_1.isPresent(providedOpts)) {
        return newOpts.merge(new base_cookie_options_1.CookieOptions(providedOpts));
      }
      return newOpts;
    };
    CookieService = __decorate([core_1.Injectable(), __param(0, core_1.Optional()), __metadata('design:paramtypes', [base_cookie_options_1.CookieOptions])], CookieService);
    return CookieService;
  }());
  exports.CookieService = CookieService;
  global.define = __define;
  return module.exports;
});

System.registerDynamic("angular2-cookie/services/base-cookie-options", ["angular2/src/facade/lang", "angular2/core", "angular2/src/platform/dom/dom_adapter"], true, function($__require, exports, module) {
  "use strict";
  ;
  var global = this,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = $__require('angular2/src/facade/lang');
  var core_1 = $__require('angular2/core');
  var dom_adapter_1 = $__require('angular2/src/platform/dom/dom_adapter');
  var CookieOptions = (function() {
    function CookieOptions(_a) {
      var path = _a.path,
          domain = _a.domain,
          expires = _a.expires,
          secure = _a.secure;
      this.path = lang_1.isPresent(path) ? path : null;
      this.domain = lang_1.isPresent(domain) ? domain : null;
      this.expires = lang_1.isPresent(expires) ? expires : null;
      this.secure = lang_1.isPresent(secure) ? secure : false;
    }
    CookieOptions.prototype.merge = function(options) {
      return new CookieOptions({
        path: lang_1.isPresent(options) && lang_1.isPresent(options.path) ? options.path : this.path,
        domain: lang_1.isPresent(options) && lang_1.isPresent(options.domain) ? options.domain : this.domain,
        expires: lang_1.isPresent(options) && lang_1.isPresent(options.expires) ? options.expires : this.expires,
        secure: lang_1.isPresent(options) && lang_1.isPresent(options.secure) ? options.secure : this.secure
      });
    };
    return CookieOptions;
  }());
  exports.CookieOptions = CookieOptions;
  var BaseCookieOptions = (function(_super) {
    __extends(BaseCookieOptions, _super);
    function BaseCookieOptions() {
      _super.call(this, {path: dom_adapter_1.DOM.getBaseHref()});
    }
    BaseCookieOptions = __decorate([core_1.Injectable(), __metadata('design:paramtypes', [])], BaseCookieOptions);
    return BaseCookieOptions;
  }(CookieOptions));
  exports.BaseCookieOptions = BaseCookieOptions;
  global.define = __define;
  return module.exports;
});

System.registerDynamic("angular2-cookie/services", ["angular2-cookie/services/cookies.service", "angular2-cookie/services/base-cookie-options"], true, function($__require, exports, module) {
  "use strict";
  ;
  var global = this,
      __define = global.define;
  global.define = undefined;
  var cookies_service_1 = $__require('angular2-cookie/services/cookies.service');
  exports.CookieService = cookies_service_1.CookieService;
  var base_cookie_options_1 = $__require('angular2-cookie/services/base-cookie-options');
  exports.CookieOptions = base_cookie_options_1.CookieOptions;
  exports.BaseCookieOptions = base_cookie_options_1.BaseCookieOptions;
  global.define = __define;
  return module.exports;
});

System.registerDynamic("angular2-cookie/core", ["angular2/core", "angular2-cookie/services"], true, function($__require, exports, module) {
  "use strict";
  ;
  var global = this,
      __define = global.define;
  global.define = undefined;
  function __export(m) {
    for (var p in m)
      if (!exports.hasOwnProperty(p))
        exports[p] = m[p];
  }
  var core_1 = $__require('angular2/core');
  var services_1 = $__require('angular2-cookie/services');
  __export($__require('angular2-cookie/services'));
  exports.ANGULAR2_COOKIE_PROVIDERS = [core_1.provide(services_1.CookieOptions, {useClass: services_1.BaseCookieOptions})];
  global.define = __define;
  return module.exports;
});

//# sourceMappingURL=angular2-cookie.js.map