"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require("angular2/core");
var DataTable_1 = require("./DataTable");
var Paginator_1 = require("./Paginator");
var BootstrapPaginator = (function () {
    function BootstrapPaginator() {
        this.rowsOnPageSet = [];
        this.activePage = 1;
        this.onRowsPageChange = new core_1.EventEmitter();
        this.onActivePageChange = new core_1.EventEmitter();
    }
    BootstrapPaginator.prototype.addToActivePage = function (num) {
        this.changeActivePage(this.activePage + num);
    };
    BootstrapPaginator.prototype.changeActivePage = function (num) {
        this.activePage = num;
        this.onActivePageChange.emit(num);
    };
    BootstrapPaginator.prototype.changeRowsOnPage = function (num) {
        this.rowsOnPage = num;
        this.onRowsPageChange.emit(num);
    };
    __decorate([
        core_1.Input("rowsOnPageSet"), 
        __metadata('design:type', Object)
    ], BootstrapPaginator.prototype, "rowsOnPageSet", void 0);
    __decorate([
        core_1.Input("rowsOnPage"), 
        __metadata('design:type', Object)
    ], BootstrapPaginator.prototype, "rowsOnPage", void 0);
    __decorate([
        core_1.Input("activePage"), 
        __metadata('design:type', Object)
    ], BootstrapPaginator.prototype, "activePage", void 0);
    __decorate([
        core_1.Input("mfTable"), 
        __metadata('design:type', DataTable_1.DataTable)
    ], BootstrapPaginator.prototype, "mfTable", void 0);
    __decorate([
        core_1.Output("rowsOnPageChange"), 
        __metadata('design:type', Object)
    ], BootstrapPaginator.prototype, "onRowsPageChange", void 0);
    __decorate([
        core_1.Output("activePageChange"), 
        __metadata('design:type', Object)
    ], BootstrapPaginator.prototype, "onActivePageChange", void 0);
    BootstrapPaginator = __decorate([
        core_1.Component({
            selector: "mfBootstrapPaginator",
            template: "\n    <mfPaginator #p [rowsOnPage]=\"rowsOnPage\" (rowsOnPageChange)=\"changeRowsOnPage($event)\" [mfTable]=\"mfTable\"\n                    [activePage]=\"activePage\" (activePageChange)=\"changeActivePage($event)\">\n        <nav class=\"pagination\" *ngIf=\"p.lastPage>1\">\n            <li [class.disabled]=\"activePage <= 1\" (click)=\"activePage = 1\">\n                <a style=\"cursor: pointer\">&laquo;</a>\n            </li>\n            <li *ngIf=\"activePage > 4 && activePage + 1 > p.lastPage\" (click)=\"activePage = activePage - 4\">\n                <a style=\"cursor: pointer\">{{activePage-4}}</a>\n            </li>\n            <li *ngIf=\"activePage > 3 && activePage + 2 > p.lastPage\" (click)=\"activePage = activePage - 3\">\n                <a style=\"cursor: pointer\">{{activePage-3}}</a>\n            </li>\n            <li *ngIf=\"activePage > 2\" (click)=\"activePage = activePage - 2\">\n                <a style=\"cursor: pointer\">{{activePage-2}}</a>\n            </li>\n            <li *ngIf=\"activePage > 1\" (click)=\"activePage = activePage - 1\">\n                <a style=\"cursor: pointer\">{{activePage-1}}</a>\n            </li>\n            <li class=\"active\">\n                <a style=\"cursor: pointer\">{{activePage}}</a>\n            </li>\n            <li *ngIf=\"activePage + 1 <= p.lastPage\" (click)=\"activePage = activePage + 1\">\n                <a style=\"cursor: pointer\">{{activePage+1}}</a>\n            </li>\n            <li *ngIf=\"activePage + 2 <= p.lastPage\" (click)=\"activePage = activePage + 2\">\n                <a style=\"cursor: pointer\">{{activePage+2}}</a>\n            </li>\n            <li *ngIf=\"activePage + 3 <= p.lastPage && activePage < 3\" (click)=\"activePage = activePage + 3\">\n                <a style=\"cursor: pointer\">{{activePage+3}}</a>\n            </li>\n            <li *ngIf=\"activePage + 4 <= p.lastPage && activePage < 2\" (click)=\"activePage = activePage + 4\">\n                <a style=\"cursor: pointer\">{{activePage+4}}</a>\n            </li>\n            <li [class.disabled]=\"activePage >= p.lastPage\" (click)=\"activePage = p.lastPage\">\n                <a style=\"cursor: pointer\">&raquo;</a>\n            </li>\n        </nav>\n        <nav class=\"pagination pull-right\">\n            <li *ngFor=\"#rows of rowsOnPageSet\" [class.active]=\"rowsOnPage===rows\" (click)=\"changeRowsOnPage(rows)\">\n                <a style=\"cursor: pointer\">{{rows}}</a>\n            </li>\n        </nav>\n    </mfPaginator>\n    ",
            directives: [[Paginator_1.Paginator]]
        }), 
        __metadata('design:paramtypes', [])
    ], BootstrapPaginator);
    return BootstrapPaginator;
}());
exports.BootstrapPaginator = BootstrapPaginator;
//# sourceMappingURL=BootstrapPaginator.js.map