"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require("angular2/core");
var DataTable_1 = require("./DataTable");
var Paginator = (function () {
    function Paginator(injectMfTable) {
        var _this = this;
        this.injectMfTable = injectMfTable;
        this.onActivePageChange = new core_1.EventEmitter();
        this.onRowsOnPageChange = new core_1.EventEmitter();
        this.onPageChangeSubscriber = function (event) {
            if (_this._activePage !== event.activePage || _this._rowsOnPage !== event.rowsOnPage) {
                _this._activePage = event.activePage;
                _this._rowsOnPage = event.rowsOnPage;
                _this.onActivePageChange.emit(event.activePage);
                _this.onRowsOnPageChange.emit(event.rowsOnPage);
                _this.lastPage = Math.ceil(_this.dataLength / _this._rowsOnPage);
            }
        };
        this.onDataChangeSubscriber = function (event) {
            _this.dataLength = event.length;
            _this.lastPage = Math.ceil(event.length / _this._rowsOnPage);
        };
    }
    Paginator.prototype.ngOnChanges = function (changes) {
        this.mfTable = this.inputMfTable || this.injectMfTable;
        var rowsOnPage = changes["rowsOnPage"];
        var activePage = changes["activePage"];
        var rowsOnPageChanged = rowsOnPage && rowsOnPage.currentValue && rowsOnPage.currentValue !== this._rowsOnPage;
        var activePageChanged = activePage && activePage.currentValue && activePage.currentValue !== this._activePage;
        this._rowsOnPage = rowsOnPageChanged ? rowsOnPage.currentValue : this._rowsOnPage;
        this._activePage = activePageChanged ? activePage.currentValue : this._activePage;
        if (rowsOnPageChanged || activePageChanged) {
            var newActivePage = !activePageChanged ? this.calculateNewActivePage(rowsOnPage) : 0;
            this.mfTable.setPage(newActivePage || this._activePage, this._rowsOnPage);
            this.lastPage = Math.ceil(this.dataLength / this._rowsOnPage);
        }
    };
    Paginator.prototype.ngOnInit = function () {
        var page = this.mfTable.getPage();
        this.onPageChangeSubscriber(page);
        this.mfTable.onDataChange.subscribe(this.onDataChangeSubscriber);
        this.mfTable.onPageChange.subscribe(this.onPageChangeSubscriber);
    };
    Paginator.prototype.calculateNewActivePage = function (rowsOnPage) {
        var firstRowOnPage = (this._activePage - 1) * rowsOnPage.previousValue + 1;
        var newActivePage = Math.ceil(firstRowOnPage / rowsOnPage.currentValue);
        return newActivePage;
    };
    __decorate([
        core_1.Input("mfTable"), 
        __metadata('design:type', DataTable_1.DataTable)
    ], Paginator.prototype, "inputMfTable", void 0);
    __decorate([
        core_1.Output("activePageChange"), 
        __metadata('design:type', Object)
    ], Paginator.prototype, "onActivePageChange", void 0);
    __decorate([
        core_1.Output("rowsOnPageChange"), 
        __metadata('design:type', Object)
    ], Paginator.prototype, "onRowsOnPageChange", void 0);
    Paginator = __decorate([
        core_1.Component({
            selector: "mfPaginator",
            template: "<ng-content></ng-content>",
            inputs: ['activePage', 'rowsOnPage']
        }),
        __param(0, core_1.Optional()), 
        __metadata('design:paramtypes', [DataTable_1.DataTable])
    ], Paginator);
    return Paginator;
}());
exports.Paginator = Paginator;
//# sourceMappingURL=Paginator.js.map