"use strict";
var Dropzone = require('dropzone');
var core_1 = require('@angular/core');
var core_2 = require('@angular/core');
var core_3 = require('@angular/core');
var dropzone_interfaces_1 = require('./dropzone.interfaces');
var DropzoneComponent = (function () {
    function DropzoneComponent(zone, elementRef, differs, defaults) {
        this.zone = zone;
        this.elementRef = elementRef;
        this.differs = differs;
        this.defaults = defaults;
        this.disabled = false;
        this.runInsideAngular = false;
        this.message = 'Click or drag files to upload';
        this.placeholder = '';
        this.useDropzoneClass = true;
        this.useDzWrapperClass = true;
        this.dz_drop = new core_3.EventEmitter();
        this.dz_dragstart = new core_3.EventEmitter();
        this.dz_dragend = new core_3.EventEmitter();
        this.dz_dragenter = new core_3.EventEmitter();
        this.dz_dragover = new core_3.EventEmitter();
        this.dz_dragleave = new core_3.EventEmitter();
        this.dz_addedfile = new core_3.EventEmitter();
        this.dz_removedfile = new core_3.EventEmitter();
        this.dz_thumbnail = new core_3.EventEmitter();
        this.dz_error = new core_3.EventEmitter();
        this.dz_processing = new core_3.EventEmitter();
        this.dz_uploadprogress = new core_3.EventEmitter();
        this.dz_sending = new core_3.EventEmitter();
        this.dz_success = new core_3.EventEmitter();
        this.dz_complete = new core_3.EventEmitter();
        this.dz_canceled = new core_3.EventEmitter();
        this.dz_maxfilesreached = new core_3.EventEmitter();
        this.dz_maxfilesexceeded = new core_3.EventEmitter();
        this.dz_processingmultiple = new core_3.EventEmitter();
        this.dz_sendingmultiple = new core_3.EventEmitter();
        this.dz_successmultiple = new core_3.EventEmitter();
        this.dz_completemultiple = new core_3.EventEmitter();
        this.dz_canceledmultiple = new core_3.EventEmitter();
        this.dz_totaluploadprogress = new core_3.EventEmitter();
        this.dz_reset = new core_3.EventEmitter();
        this.dz_queuecomplete = new core_3.EventEmitter();
        Dropzone.autoDiscover = false;
    }
    DropzoneComponent.prototype.ngOnInit = function () {
        var _this = this;
        var element = this.elementRef.nativeElement;
        var options = new dropzone_interfaces_1.DropzoneConfig(this.defaults);
        options.assign(this.config); // Custom config
        if (this.runInsideAngular) {
            this.dropzone = new Dropzone(element, options);
        }
        else {
            this.zone.runOutsideAngular(function () {
                _this.dropzone = new Dropzone(element, options);
            });
        }
        if (this.disabled) {
            if (this.runInsideAngular) {
                this.dropzone.disable();
            }
            else {
                this.zone.runOutsideAngular(function () {
                    _this.dropzone.disable();
                });
            }
        }
        this.dropzone.on('error', function (err) {
            if (options.errorReset != null) {
                setTimeout(function () { return _this.reset(); }, options.errorReset);
            }
        });
        this.dropzone.on('success', function (res) {
            if (options.autoReset != null) {
                setTimeout(function () { return _this.reset(); }, options.autoReset);
            }
        });
        this.dropzone.on('canceled', function (res) {
            if (options.cancelReset != null) {
                setTimeout(function () { return _this.reset(); }, options.cancelReset);
            }
        });
        // Add native dropzone event handling
        dropzone_interfaces_1.DropzoneEvents.forEach(function (eventName) {
            var self = _this;
            _this.dropzone.on(eventName, function (event) {
                var args = Array.prototype.slice.call(arguments);
                if (args.length === 1) {
                    args = args[0];
                }
                self[("dz_" + eventName)].emit(args);
            });
        });
        if (!this.configDiff) {
            this.configDiff = this.differs.find(this.config || {}).create(null);
        }
    };
    DropzoneComponent.prototype.ngDoCheck = function () {
        var changes = this.configDiff.diff(this.config || {});
        if (changes) {
            this.ngOnDestroy();
            this.ngOnInit();
        }
    };
    DropzoneComponent.prototype.ngOnDestroy = function () {
        var _this = this;
        if (this.runInsideAngular) {
            this.dropzone.destroy();
        }
        else {
            this.zone.runOutsideAngular(function () {
                _this.dropzone.destroy();
            });
        }
    };
    DropzoneComponent.prototype.ngOnChanges = function (changes) {
        var _this = this;
        if (this.dropzone && changes['disabled']) {
            if (changes['disabled'].currentValue != changes['disabled'].previousValue) {
                if (changes['disabled'].currentValue === true) {
                    if (this.runInsideAngular) {
                        this.dropzone.enable();
                    }
                    else {
                        this.zone.runOutsideAngular(function () {
                            _this.dropzone.enable();
                        });
                    }
                }
                else if (changes['disabled'].currentValue === false) {
                    if (this.runInsideAngular) {
                        this.dropzone.disable();
                    }
                    else {
                        this.zone.runOutsideAngular(function () {
                            _this.dropzone.disable();
                        });
                    }
                }
            }
        }
    };
    DropzoneComponent.prototype.reset = function () {
        var _this = this;
        if (this.runInsideAngular) {
            this.dropzone.removeAllFiles();
        }
        else {
            this.zone.runOutsideAngular(function () {
                _this.dropzone.removeAllFiles();
            });
        }
    };
    DropzoneComponent.decorators = [
        { type: core_2.Component, args: [{
                    selector: 'dropzone',
                    template: '<div class="dz-message" [ngClass]="{\'disabled\': disabled, \'dz-placeholder\': placeholder}"><div class="dz-text" [innerHTML]="message || config?.dictDefaultMessage"></div><img *ngIf="placeholder" class="dz-image" [src]="placeholder"></div>',
                    styles: ['@-webkit-keyframes passing-through{0%{opacity:0;-webkit-transform:translateY(40px);-moz-transform:translateY(40px);-ms-transform:translateY(40px);-o-transform:translateY(40px);transform:translateY(40px)}30%,70%{opacity:1;-webkit-transform:translateY(0);-moz-transform:translateY(0);-ms-transform:translateY(0);-o-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-40px);-moz-transform:translateY(-40px);-ms-transform:translateY(-40px);-o-transform:translateY(-40px);transform:translateY(-40px)}}@-moz-keyframes passing-through{0%{opacity:0;-webkit-transform:translateY(40px);-moz-transform:translateY(40px);-ms-transform:translateY(40px);-o-transform:translateY(40px);transform:translateY(40px)}30%,70%{opacity:1;-webkit-transform:translateY(0);-moz-transform:translateY(0);-ms-transform:translateY(0);-o-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-40px);-moz-transform:translateY(-40px);-ms-transform:translateY(-40px);-o-transform:translateY(-40px);transform:translateY(-40px)}}@keyframes passing-through{0%{opacity:0;-webkit-transform:translateY(40px);-moz-transform:translateY(40px);-ms-transform:translateY(40px);-o-transform:translateY(40px);transform:translateY(40px)}30%,70%{opacity:1;-webkit-transform:translateY(0);-moz-transform:translateY(0);-ms-transform:translateY(0);-o-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-40px);-moz-transform:translateY(-40px);-ms-transform:translateY(-40px);-o-transform:translateY(-40px);transform:translateY(-40px)}}@-webkit-keyframes slide-in{0%{opacity:0;-webkit-transform:translateY(40px);-moz-transform:translateY(40px);-ms-transform:translateY(40px);-o-transform:translateY(40px);transform:translateY(40px)}30%{opacity:1;-webkit-transform:translateY(0);-moz-transform:translateY(0);-ms-transform:translateY(0);-o-transform:translateY(0);transform:translateY(0)}}@-moz-keyframes slide-in{0%{opacity:0;-webkit-transform:translateY(40px);-moz-transform:translateY(40px);-ms-transform:translateY(40px);-o-transform:translateY(40px);transform:translateY(40px)}30%{opacity:1;-webkit-transform:translateY(0);-moz-transform:translateY(0);-ms-transform:translateY(0);-o-transform:translateY(0);transform:translateY(0)}}@keyframes slide-in{0%{opacity:0;-webkit-transform:translateY(40px);-moz-transform:translateY(40px);-ms-transform:translateY(40px);-o-transform:translateY(40px);transform:translateY(40px)}30%{opacity:1;-webkit-transform:translateY(0);-moz-transform:translateY(0);-ms-transform:translateY(0);-o-transform:translateY(0);transform:translateY(0)}}@-webkit-keyframes pulse{0%,20%{-webkit-transform:scale(1);-moz-transform:scale(1);-ms-transform:scale(1);-o-transform:scale(1);transform:scale(1)}10%{-webkit-transform:scale(1.1);-moz-transform:scale(1.1);-ms-transform:scale(1.1);-o-transform:scale(1.1);transform:scale(1.1)}}@-moz-keyframes pulse{0%,20%{-webkit-transform:scale(1);-moz-transform:scale(1);-ms-transform:scale(1);-o-transform:scale(1);transform:scale(1)}10%{-webkit-transform:scale(1.1);-moz-transform:scale(1.1);-ms-transform:scale(1.1);-o-transform:scale(1.1);transform:scale(1.1)}}@keyframes pulse{0%,20%{-webkit-transform:scale(1);-moz-transform:scale(1);-ms-transform:scale(1);-o-transform:scale(1);transform:scale(1)}10%{-webkit-transform:scale(1.1);-moz-transform:scale(1.1);-ms-transform:scale(1.1);-o-transform:scale(1.1);transform:scale(1.1)}}.dropzone,.dropzone *{box-sizing:border-box}.dropzone{min-height:150px;border:2px solid rgba(0,0,0,.3);background:#fff;padding:20px}.dropzone.dz-clickable{cursor:pointer}.dropzone.dz-clickable *{cursor:default}.dropzone.dz-clickable .dz-message,.dropzone.dz-clickable .dz-message *{cursor:pointer}.dropzone.dz-started .dz-message{display:none}.dropzone.dz-drag-hover{border-style:solid}.dropzone.dz-drag-hover .dz-message{opacity:.5}.dropzone .dz-preview.dz-file-preview .dz-details,.dropzone .dz-preview:hover .dz-details{opacity:1}.dropzone .dz-message{text-align:center;margin:2em 0}.dropzone .dz-preview{position:relative;display:inline-block;vertical-align:top;margin:16px;min-height:100px}.dropzone .dz-preview:hover{z-index:1000}.dropzone .dz-preview.dz-file-preview .dz-image{border-radius:20px;background:#999;background:linear-gradient(to bottom,#eee,#ddd)}.dropzone .dz-preview.dz-image-preview{background:#fff}.dropzone .dz-preview.dz-image-preview .dz-details{-webkit-transition:opacity .2s linear;-moz-transition:opacity .2s linear;-ms-transition:opacity .2s linear;-o-transition:opacity .2s linear;transition:opacity .2s linear}.dropzone .dz-preview .dz-remove{font-size:14px;text-align:center;display:block;cursor:pointer;border:none}.dropzone .dz-preview .dz-remove:hover{text-decoration:underline}.dropzone .dz-preview .dz-details{z-index:20;position:absolute;top:0;left:0;opacity:0;font-size:13px;min-width:100%;max-width:100%;padding:2em 1em;text-align:center;color:rgba(0,0,0,.9);line-height:150%}.dropzone .dz-preview .dz-details .dz-size{margin-bottom:1em;font-size:16px}.dropzone .dz-preview .dz-details .dz-filename{white-space:nowrap}.dropzone .dz-preview .dz-details .dz-filename:hover span{border:1px solid rgba(200,200,200,.8);background-color:rgba(255,255,255,.8)}.dropzone .dz-preview .dz-details .dz-filename:not(:hover){overflow:hidden;text-overflow:ellipsis}.dropzone .dz-preview .dz-details .dz-filename:not(:hover) span{border:1px solid transparent}.dropzone .dz-preview .dz-details .dz-filename span,.dropzone .dz-preview .dz-details .dz-size span{background-color:rgba(255,255,255,.4);padding:0 .4em;border-radius:3px}.dropzone .dz-preview:hover .dz-image img{-webkit-transform:scale(1.05,1.05);-moz-transform:scale(1.05,1.05);-ms-transform:scale(1.05,1.05);-o-transform:scale(1.05,1.05);transform:scale(1.05,1.05);-webkit-filter:blur(8px);filter:blur(8px)}.dropzone .dz-preview .dz-image{border-radius:20px;overflow:hidden;width:120px;height:120px;position:relative;display:block;z-index:10}.dropzone .dz-preview .dz-image img{display:block}.dropzone .dz-preview.dz-success .dz-success-mark{-webkit-animation:passing-through 3s cubic-bezier(.77,0,.175,1);-moz-animation:passing-through 3s cubic-bezier(.77,0,.175,1);-ms-animation:passing-through 3s cubic-bezier(.77,0,.175,1);-o-animation:passing-through 3s cubic-bezier(.77,0,.175,1);animation:passing-through 3s cubic-bezier(.77,0,.175,1)}.dropzone .dz-preview.dz-error .dz-error-mark{opacity:1;-webkit-animation:slide-in 3s cubic-bezier(.77,0,.175,1);-moz-animation:slide-in 3s cubic-bezier(.77,0,.175,1);-ms-animation:slide-in 3s cubic-bezier(.77,0,.175,1);-o-animation:slide-in 3s cubic-bezier(.77,0,.175,1);animation:slide-in 3s cubic-bezier(.77,0,.175,1)}.dropzone .dz-preview .dz-error-mark,.dropzone .dz-preview .dz-success-mark{pointer-events:none;opacity:0;z-index:500;position:absolute;display:block;top:50%;left:50%;margin-left:-27px;margin-top:-27px}.dropzone .dz-preview .dz-error-mark svg,.dropzone .dz-preview .dz-success-mark svg{display:block;width:54px;height:54px}.dropzone .dz-preview.dz-processing .dz-progress{opacity:1;-webkit-transition:all .2s linear;-moz-transition:all .2s linear;-ms-transition:all .2s linear;-o-transition:all .2s linear;transition:all .2s linear}.dropzone .dz-preview.dz-complete .dz-progress{opacity:0;-webkit-transition:opacity .4s ease-in;-moz-transition:opacity .4s ease-in;-ms-transition:opacity .4s ease-in;-o-transition:opacity .4s ease-in;transition:opacity .4s ease-in}.dropzone .dz-preview:not(.dz-processing) .dz-progress{-webkit-animation:pulse 6s ease infinite;-moz-animation:pulse 6s ease infinite;-ms-animation:pulse 6s ease infinite;-o-animation:pulse 6s ease infinite;animation:pulse 6s ease infinite}.dropzone .dz-preview .dz-progress{opacity:1;z-index:1000;pointer-events:none;position:absolute;height:16px;left:50%;top:50%;margin-top:-8px;width:80px;margin-left:-40px;background:rgba(255,255,255,.9);-webkit-transform:scale(1);border-radius:8px;overflow:hidden}.dropzone.dz-wrapper .dz-message,.dropzone.dz-wrapper .dz-preview{overflow:auto;max-width:100%;max-height:320px;margin:0;min-height:40px}.dropzone .dz-preview .dz-progress .dz-upload{background:#333;background:linear-gradient(to bottom,#666,#444);position:absolute;top:0;left:0;bottom:0;width:0;-webkit-transition:width .3s ease-in-out;-moz-transition:width .3s ease-in-out;-ms-transition:width .3s ease-in-out;-o-transition:width .3s ease-in-out;transition:width .3s ease-in-out}.dropzone .dz-preview.dz-error .dz-error-message{display:block}.dropzone .dz-preview.dz-error:hover .dz-error-message{opacity:1;pointer-events:auto}.dropzone .dz-preview .dz-error-message{pointer-events:none;z-index:1000;position:absolute;display:block;display:none;opacity:0;-webkit-transition:opacity .3s ease;-moz-transition:opacity .3s ease;-ms-transition:opacity .3s ease;-o-transition:opacity .3s ease;transition:opacity .3s ease;border-radius:8px;font-size:13px;top:130px;left:-10px;width:140px;background:#be2626;background:linear-gradient(to bottom,#be2626,#a92222);padding:.5em 1.2em;color:#fff}.dropzone.dz-wrapper .dz-preview .dz-error-mark,.dropzone.dz-wrapper .dz-preview .dz-error-message::after,.dropzone.dz-wrapper .dz-preview .dz-success-mark,.dropzone.dz-wrapper .dz-preview.dz-file-preview .dz-details,.dropzone.dz-wrapper .dz-preview.dz-file-preview .dz-image{display:none}.dropzone .dz-preview .dz-error-message:after{content:\'\';position:absolute;top:-6px;left:64px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-bottom:6px solid #be2626}.dropzone.dz-wrapper{position:relative;padding:0;border:none;color:#666;background:0 0}.dropzone.dz-wrapper .dz-message{position:relative;border:2px dashed #aaa;background:#eee}.dropzone.dz-wrapper .dz-message .dz-text{padding:9px;text-align:center}.dropzone.dz-wrapper .dz-message .dz-image{width:100%;height:auto}.dropzone.dz-wrapper .dz-message.disabled{cursor:not-allowed}.dropzone.dz-wrapper .dz-message.disabled .dz-text{opacity:.5}.dropzone.dz-wrapper .dz-message.dz-placeholder{border-color:rgba(170,170,170,0)}.dropzone.dz-wrapper .dz-message.dz-placeholder .dz-text{position:absolute;z-index:1;top:50%;right:5%;left:5%;opacity:0;font-weight:700;background:rgba(255,255,255,.3);transform:translateY(-50%);transition:filter 150ms ease-in-out,opacity 150ms ease-in-out,border-color 150ms ease-in-out}.dropzone.dz-wrapper .dz-message.dz-placeholder:hover:not(.disabled){border-color:#aaa}.dropzone.dz-wrapper .dz-message.dz-placeholder:hover:not(.disabled) .dz-text{opacity:1}.dropzone.dz-wrapper .dz-message.dz-placeholder:hover:not(.disabled) .dz-image{-webkit-filter:blur(8px);filter:blur(8px)}.dropzone.dz-wrapper .dz-preview{width:100%;height:auto;padding:9px;background:0 0}.dropzone.dz-wrapper .dz-preview .dz-image{width:100%;height:auto;border-radius:0}.dropzone.dz-wrapper .dz-preview .dz-image img{width:100%;height:auto;margin:0 auto}.dropzone.dz-wrapper .dz-preview .dz-progress{width:90%;margin-left:-45%;border-radius:4px;border:1px solid #aaa}.dropzone.dz-wrapper .dz-preview .dz-progress .dz-upload{background:#666}.dropzone.dz-wrapper .dz-preview .dz-error-message{position:absolute;top:0;right:0;bottom:0;left:0;opacity:1;width:100%;min-height:40px;padding:10px;border-radius:0;border:2px solid #aaa;color:#666;font-weight:700;text-align:center;background:#eee}'],
                    encapsulation: core_3.ViewEncapsulation.None
                },] },
    ];
    /** @nocollapse */
    DropzoneComponent.ctorParameters = function () { return [
        { type: core_1.NgZone, },
        { type: core_3.ElementRef, },
        { type: core_1.KeyValueDiffers, },
        { type: dropzone_interfaces_1.DropzoneConfig, decorators: [{ type: core_2.Optional },] },
    ]; };
    DropzoneComponent.propDecorators = {
        'disabled': [{ type: core_3.Input },],
        'config': [{ type: core_3.Input },],
        'runInsideAngular': [{ type: core_3.Input },],
        'message': [{ type: core_3.Input },],
        'placeholder': [{ type: core_3.Input },],
        'useDropzoneClass': [{ type: core_3.HostBinding, args: ['class.dropzone',] }, { type: core_3.Input },],
        'useDzWrapperClass': [{ type: core_3.HostBinding, args: ['class.dz-wrapper',] }, { type: core_3.Input },],
        'dz_drop': [{ type: core_3.Output, args: ['drop',] },],
        'dz_dragstart': [{ type: core_3.Output, args: ['dragstart',] },],
        'dz_dragend': [{ type: core_3.Output, args: ['dragend',] },],
        'dz_dragenter': [{ type: core_3.Output, args: ['dragenter',] },],
        'dz_dragover': [{ type: core_3.Output, args: ['dragover',] },],
        'dz_dragleave': [{ type: core_3.Output, args: ['dragleave',] },],
        'dz_addedfile': [{ type: core_3.Output, args: ['addedfile',] },],
        'dz_removedfile': [{ type: core_3.Output, args: ['removedfile',] },],
        'dz_thumbnail': [{ type: core_3.Output, args: ['thumbnail',] },],
        'dz_error': [{ type: core_3.Output, args: ['error',] },],
        'dz_processing': [{ type: core_3.Output, args: ['processing',] },],
        'dz_uploadprogress': [{ type: core_3.Output, args: ['uploadprogress',] },],
        'dz_sending': [{ type: core_3.Output, args: ['sending',] },],
        'dz_success': [{ type: core_3.Output, args: ['success',] },],
        'dz_complete': [{ type: core_3.Output, args: ['complete',] },],
        'dz_canceled': [{ type: core_3.Output, args: ['canceled',] },],
        'dz_maxfilesreached': [{ type: core_3.Output, args: ['maxfilesreached',] },],
        'dz_maxfilesexceeded': [{ type: core_3.Output, args: ['maxfilesexceeded',] },],
        'dz_processingmultiple': [{ type: core_3.Output, args: ['processingmultiple',] },],
        'dz_sendingmultiple': [{ type: core_3.Output, args: ['sendingmultiple',] },],
        'dz_successmultiple': [{ type: core_3.Output, args: ['successmultiple',] },],
        'dz_completemultiple': [{ type: core_3.Output, args: ['completemultiple',] },],
        'dz_canceledmultiple': [{ type: core_3.Output, args: ['canceledmultiple',] },],
        'dz_totaluploadprogress': [{ type: core_3.Output, args: ['totaluploadprogress',] },],
        'dz_reset': [{ type: core_3.Output, args: ['reset',] },],
        'dz_queuecomplete': [{ type: core_3.Output, args: ['queuecomplete',] },],
    };
    return DropzoneComponent;
}());
exports.DropzoneComponent = DropzoneComponent;
//# sourceMappingURL=dropzone.component.js.map