"use strict";
var Dropzone = require('dropzone');
var core_1 = require('@angular/core');
var core_2 = require('@angular/core');
var dropzone_interfaces_1 = require('./dropzone.interfaces');
var DropzoneDirective = (function () {
    function DropzoneDirective(zone, renderer, elementRef, differs, defaults) {
        this.zone = zone;
        this.renderer = renderer;
        this.elementRef = elementRef;
        this.differs = differs;
        this.defaults = defaults;
        this.disabled = false;
        this.runInsideAngular = false;
        this.dz_drop = new core_2.EventEmitter();
        this.dz_dragstart = new core_2.EventEmitter();
        this.dz_dragend = new core_2.EventEmitter();
        this.dz_dragenter = new core_2.EventEmitter();
        this.dz_dragover = new core_2.EventEmitter();
        this.dz_dragleave = new core_2.EventEmitter();
        this.dz_addedfile = new core_2.EventEmitter();
        this.dz_removedfile = new core_2.EventEmitter();
        this.dz_thumbnail = new core_2.EventEmitter();
        this.dz_error = new core_2.EventEmitter();
        this.dz_processing = new core_2.EventEmitter();
        this.dz_uploadprogress = new core_2.EventEmitter();
        this.dz_sending = new core_2.EventEmitter();
        this.dz_success = new core_2.EventEmitter();
        this.dz_complete = new core_2.EventEmitter();
        this.dz_canceled = new core_2.EventEmitter();
        this.dz_maxfilesreached = new core_2.EventEmitter();
        this.dz_maxfilesexceeded = new core_2.EventEmitter();
        this.dz_processingmultiple = new core_2.EventEmitter();
        this.dz_sendingmultiple = new core_2.EventEmitter();
        this.dz_successmultiple = new core_2.EventEmitter();
        this.dz_completemultiple = new core_2.EventEmitter();
        this.dz_canceledmultiple = new core_2.EventEmitter();
        this.dz_totaluploadprogress = new core_2.EventEmitter();
        this.dz_reset = new core_2.EventEmitter();
        this.dz_queuecomplete = new core_2.EventEmitter();
        Dropzone.autoDiscover = false;
        renderer.setElementClass(elementRef.nativeElement, 'dropzone', true);
    }
    DropzoneDirective.prototype.ngOnInit = function () {
        var _this = this;
        var element = this.elementRef.nativeElement;
        var options = new dropzone_interfaces_1.DropzoneConfig(this.defaults);
        options.assign(this.config); // Custom config
        if (this.runInsideAngular) {
            this.dropzone = new Dropzone(element, options);
        }
        else {
            this.zone.runOutsideAngular(function () {
                _this.dropzone = new Dropzone(element, options);
            });
        }
        if (this.disabled) {
            if (this.runInsideAngular) {
                this.dropzone.disable();
            }
            else {
                this.zone.runOutsideAngular(function () {
                    _this.dropzone.disable();
                });
            }
        }
        // Add native dropzone event handling
        dropzone_interfaces_1.DropzoneEvents.forEach(function (eventName) {
            var self = _this;
            _this.dropzone.on(eventName, function (event) {
                var args = Array.prototype.slice.call(arguments);
                if (args.length === 1) {
                    args = args[0];
                }
                self[("dz_" + eventName)].emit(args);
            });
        });
        if (!this.configDiff) {
            this.configDiff = this.differs.find(this.config || {}).create(null);
        }
    };
    DropzoneDirective.prototype.ngDoCheck = function () {
        var changes = this.configDiff.diff(this.config || {});
        if (changes) {
            this.ngOnDestroy();
            this.ngOnInit();
        }
    };
    DropzoneDirective.prototype.ngOnDestroy = function () {
        var _this = this;
        if (this.runInsideAngular) {
            this.dropzone.destroy();
        }
        else {
            this.zone.runOutsideAngular(function () {
                _this.dropzone.destroy();
            });
        }
    };
    DropzoneDirective.prototype.ngOnChanges = function (changes) {
        var _this = this;
        if (this.dropzone && changes['disabled']) {
            if (changes['disabled'].currentValue != changes['disabled'].previousValue) {
                if (changes['disabled'].currentValue === true) {
                    if (this.runInsideAngular) {
                        this.dropzone.enable();
                    }
                    else {
                        this.zone.runOutsideAngular(function () {
                            _this.dropzone.enable();
                        });
                    }
                }
                else if (changes['disabled'].currentValue === false) {
                    if (this.runInsideAngular) {
                        this.dropzone.disable();
                    }
                    else {
                        this.zone.runOutsideAngular(function () {
                            _this.dropzone.disable();
                        });
                    }
                }
            }
        }
    };
    DropzoneDirective.prototype.reset = function () {
        var _this = this;
        if (this.runInsideAngular) {
            this.dropzone.removeAllFiles();
        }
        else {
            this.zone.runOutsideAngular(function () {
                _this.dropzone.removeAllFiles();
            });
        }
    };
    DropzoneDirective.decorators = [
        { type: core_2.Directive, args: [{
                    selector: '[dropzone]'
                },] },
    ];
    /** @nocollapse */
    DropzoneDirective.ctorParameters = function () { return [
        { type: core_1.NgZone, },
        { type: core_1.Renderer, },
        { type: core_2.ElementRef, },
        { type: core_1.KeyValueDiffers, },
        { type: dropzone_interfaces_1.DropzoneConfig, decorators: [{ type: core_2.Optional },] },
    ]; };
    DropzoneDirective.propDecorators = {
        'disabled': [{ type: core_2.Input },],
        'runInsideAngular': [{ type: core_2.Input },],
        'config': [{ type: core_2.Input, args: ['dropzone',] },],
        'dz_drop': [{ type: core_2.Output, args: ['drop',] },],
        'dz_dragstart': [{ type: core_2.Output, args: ['dragstart',] },],
        'dz_dragend': [{ type: core_2.Output, args: ['dragend',] },],
        'dz_dragenter': [{ type: core_2.Output, args: ['dragenter',] },],
        'dz_dragover': [{ type: core_2.Output, args: ['dragover',] },],
        'dz_dragleave': [{ type: core_2.Output, args: ['dragleave',] },],
        'dz_addedfile': [{ type: core_2.Output, args: ['addedfile',] },],
        'dz_removedfile': [{ type: core_2.Output, args: ['removedfile',] },],
        'dz_thumbnail': [{ type: core_2.Output, args: ['thumbnail',] },],
        'dz_error': [{ type: core_2.Output, args: ['error',] },],
        'dz_processing': [{ type: core_2.Output, args: ['processing',] },],
        'dz_uploadprogress': [{ type: core_2.Output, args: ['uploadprogress',] },],
        'dz_sending': [{ type: core_2.Output, args: ['sending',] },],
        'dz_success': [{ type: core_2.Output, args: ['success',] },],
        'dz_complete': [{ type: core_2.Output, args: ['complete',] },],
        'dz_canceled': [{ type: core_2.Output, args: ['canceled',] },],
        'dz_maxfilesreached': [{ type: core_2.Output, args: ['maxfilesreached',] },],
        'dz_maxfilesexceeded': [{ type: core_2.Output, args: ['maxfilesexceeded',] },],
        'dz_processingmultiple': [{ type: core_2.Output, args: ['processingmultiple',] },],
        'dz_sendingmultiple': [{ type: core_2.Output, args: ['sendingmultiple',] },],
        'dz_successmultiple': [{ type: core_2.Output, args: ['successmultiple',] },],
        'dz_completemultiple': [{ type: core_2.Output, args: ['completemultiple',] },],
        'dz_canceledmultiple': [{ type: core_2.Output, args: ['canceledmultiple',] },],
        'dz_totaluploadprogress': [{ type: core_2.Output, args: ['totaluploadprogress',] },],
        'dz_reset': [{ type: core_2.Output, args: ['reset',] },],
        'dz_queuecomplete': [{ type: core_2.Output, args: ['queuecomplete',] },],
    };
    return DropzoneDirective;
}());
exports.DropzoneDirective = DropzoneDirective;
//# sourceMappingURL=dropzone.directive.js.map