"use strict";
var fs = require('fs');
var angular2_universal_1 = require('angular2-universal');
exports.EXPRESS_PLATFORM = null;
function disposeExpressPlatform() {
    exports.EXPRESS_PLATFORM = null;
}
exports.disposeExpressPlatform = disposeExpressPlatform;
function expressEngine(filePath, options, done) {
    // defaults
    options = options || {};
    options.providers = options.providers || undefined;
    options.preboot = options.preboot || undefined;
    if ('App' in options) {
        throw new Error('Please provide an `directives` property with your Angular 2 application rather than `App`');
    }
    if (!('directives' in options)) {
        throw new Error('Please provide an `directives` property with your Angular 2 application');
    }
    // read file on disk
    try {
        fs.readFile(filePath, function (err, content) {
            if (err) {
                return done(err);
            }
            // convert to string
            var clientHtml = content.toString();
            // TODO: better build scripts abstraction
            if (options.server === false && options.client === false) {
                return done(null, clientHtml);
            }
            if (options.server === false && options.client !== false) {
                return done(null, buildClientScripts(clientHtml, options));
            }
            // bootstrap and render component to string
            var _options = options;
            if (!exports.EXPRESS_PLATFORM) {
                var _template = clientHtml;
                var _Bootloader = angular2_universal_1.Bootloader;
                var bootloader = _options.bootloader;
                if (_options.bootloader) {
                    bootloader = _Bootloader.create(_options.bootloader);
                }
                else {
                    var doc = _Bootloader.parseDocument(_template);
                    _options.document = doc;
                    _options.template = _options.template || _template;
                    bootloader = _Bootloader.create(_options);
                }
                exports.EXPRESS_PLATFORM = bootloader;
            }
            exports.EXPRESS_PLATFORM.serializeApplication(null, _options.reuseProviders === false ? null : _options.providers)
                .then(function (html) { return done(null, buildClientScripts(html, options)); })
                .catch(function (e) {
                console.error(e.stack);
                // if server fail then return client html
                done(null, buildClientScripts(clientHtml, options));
            });
        });
    }
    catch (e) {
        done(e);
    }
}
exports.expressEngine = expressEngine;
;
function ng2engine(filePath, options, done) {
    console.warn('DEPRECATION WARNING: `ng2engine` is no longer supported and will be removed in next release. use `expressEngine`');
    return expressEngine(filePath, options, done);
}
exports.ng2engine = ng2engine;
;
function ng2Engine(filePath, options, done) {
    console.warn('DEPRECATION WARNING: `ng2Engine` is no longer supported and will be removed in next release. use `expressEngine`');
    return expressEngine(filePath, options, done);
}
exports.ng2Engine = ng2Engine;
;
function ng2ExpressEngine(filePath, options, done) {
    console.warn('DEPRECATION WARNING: `ng2ExpressEngine` is no longer supported and will be removed in next release. use `expressEngine`');
    return expressEngine(filePath, options, done);
}
exports.ng2ExpressEngine = ng2ExpressEngine;
;
function simpleReplace(filePath, options, done) {
    // defaults
    options = options || {};
    // read file on disk
    try {
        fs.readFile(filePath, function (err, content) {
            if (err) {
                return done(err);
            }
            // convert to string
            var clientHtml = content.toString();
            // TODO: better build scripts abstraction
            if (options.server === false && options.client === false) {
                return done(null, clientHtml);
            }
            if (options.server === false && options.client !== false) {
                return done(null, buildClientScripts(clientHtml, options));
            }
            // selector replacer explained here
            // https://gist.github.com/gdi2290/c74afd9898d2279fef9f
            // replace our component with serialized version
            var rendered = clientHtml.replace(
            // <selector></selector>
            angular2_universal_1.selectorRegExpFactory(options.selector), 
            // <selector>{{ serializedCmp }}</selector>
            options.serializedCmp);
            done(null, buildClientScripts(rendered, options));
        });
    }
    catch (e) {
        done(e);
    }
}
exports.simpleReplace = simpleReplace;
function prebootScript(config) {
    var baseUrl = (config && config.preboot && config.preboot.baseUrl) || '/preboot';
    return "\n  <preboot>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"" + baseUrl + "/preboot.css\">\n    <script src=\"" + baseUrl + "/preboot.js\"></script>\n    <script>preboot.start()</script>\n  </preboot>\n  ";
}
function angularScript(config) {
    var systemConfig = (config && config.systemjs) || {};
    var baseUrl = systemConfig.nodeModules || '/node_modules';
    var newConfig = Object.assign({}, {
        baseURL: '/',
        defaultJSExtensions: true
    }, systemConfig);
    return "\n  <!-- Browser polyfills -->\n  <script src=\"" + baseUrl + "/es6-shim/es6-shim.min.js\"></script>\n  <script src=\"" + baseUrl + "/systemjs/dist/system-polyfills.js\"></script>\n  <script src=\"" + baseUrl + "/angular2/bundles/angular2-polyfills.min.js\"></script>\n  <!-- SystemJS -->\n  <script src=\"" + baseUrl + "/systemjs/dist/system.js\"></script>\n  <!-- Angular2: Bundle -->\n  <script src=\"" + baseUrl + "/rxjs/bundles/Rx.js\"></script>\n  <script src=\"" + baseUrl + "/angular2/bundles/angular2.dev.js\"></script>\n  <script src=\"" + baseUrl + "/angular2/bundles/router.dev.js\"></script>\n  <script src=\"" + baseUrl + "/angular2/bundles/http.dev.js\"></script>\n  <script type=\"text/javascript\">\n  System.config(" + JSON.stringify(newConfig) + ");\n  </script>\n  ";
}
;
var bootstrapButton = "\n  <div id=\"bootstrapButton\">\n    <style>\n     #bootstrapButton {\n      z-index:999999999;\n      position: absolute;\n      background-color: rgb(255, 255, 255);\n      padding: 0.5em;\n      border-radius: 3px;\n      border: 1px solid rgb(207, 206, 206);\n     }\n    </style>\n    <button onclick=\"bootstrap()\">\n      Bootstrap Angular2 Client\n    </button>\n  </div>\n";
var bootstrapApp = "\n  <script>\n    setTimeout(function() {\n      bootstrap();\n    });\n  </script>\n";
function bootstrapFunction(config) {
    var systemConfig = (config && config.systemjs) || {};
    var url = systemConfig.componentUrl;
    return "\n  <script>\n    function bootstrap() {\n      if (this.bootstraped) return;\n      this.bootstraped = true;\n      System.import(\"" + url + "\")\n        .then(function(module) {\n          return module.main();\n        })\n        .then(function() {\n          if ('preboot' in window) { preboot.complete(); }\n          var $bootstrapButton = document.getElementById(\"bootstrapButton\");\n          if ($bootstrapButton) { $bootstrapButton.remove(); }\n        });\n    }\n  </script>\n";
}
;
// TODO: find better ways to configure the App initial state
// to pay off this technical debt
// currently checking for explicit values
function buildClientScripts(html, options) {
    if (!options || !options.buildClientScripts) {
        return html;
    }
    return html
        .replace(angular2_universal_1.selectorRegExpFactory('preboot'), ((options.preboot === false) ? '' : prebootScript(options)))
        .replace(angular2_universal_1.selectorRegExpFactory('angular'), ((options.angular === false) ? '' : angularScript(options)))
        .replace(angular2_universal_1.selectorRegExpFactory('bootstrap'), ((options.bootstrap === false) ? (bootstrapButton +
        bootstrapFunction(options)) : (((options.client === undefined || options.server === undefined) ?
        '' : (options.client === false) ? '' : bootstrapButton) +
        bootstrapFunction(options) +
        ((options.client === false) ? '' : bootstrapApp))));
}
//# sourceMappingURL=engine.js.map