"use strict";
var fs = require('graceful-fs');
var node_1 = require('angular2-universal/node');
function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
}
function createEngine(options) {
    options = options || {};
    var cache = {};
    var _options = {
        precompile: true,
        time: false,
        asyncDestroy: true,
        id: function () { return s4(); },
        platform: function (providers) { return node_1.platformUniversalDynamic(providers); },
        providers: [],
        ngModule: null
    };
    _options.precompile = ('precompile' in options) ? options.precompile : _options.precompile;
    _options.time = ('time' in options) ? options.time : _options.time;
    _options.asyncDestroy = ('asyncDestroy' in options) ? options.asyncDestroy : _options.asyncDestroy;
    _options.id = options.id || _options.id;
    _options.ngModule = options.ngModule || _options.ngModule;
    var __platform = options.platform || _options.platform;
    var __providers = options.providers || _options.providers;
    delete _options.providers;
    delete _options.platform;
    var platformRef = __platform(__providers);
    var prom;
    if (_options.ngModule && _options.precompile) {
        prom = platformRef.cacheModuleFactory(_options.ngModule);
    }
    return function expressEngine(filePath, data, done) {
        if (data === void 0) { data = { ngModule: _options.ngModule }; }
        var ngModule = data.ngModule || _options.ngModule;
        if (!ngModule) {
            throw new Error('Please provide your main module as ngModule for example res.render("index", {ngModule: MainModule}) or in the engine as createEngine({ ngModule: MainModule })');
        }
        if (!data.req || !data.res) {
            throw new Error('Please provide the req, res arguments (request and response objects from express) in res.render("index", { req, res })');
        }
        var cancel = false;
        if (data.req) {
            data.req.on('close', function () { return cancel = true; });
        }
        var _data = Object.assign({
            get cancel() { return cancel; },
            set cancel(val) { cancel = val; },
            get requestUrl() { return data.requestUrl || data.req.originalUrl; },
            set requestUrl(_val) { },
            get originUrl() { return data.originUrl || data.req.hostname; },
            set originUrl(_val) { },
            get baseUrl() { return data.baseUrl || '/'; },
            set baseUrl(_val) { },
            get cookie() { return data.cookie || data.req.headers.cookie; },
            set cookie(_val) { },
        }, data);
        function readContent(content) {
            var DOCUMENT = content.toString();
            _data.document = DOCUMENT;
            _data.DOCUMENT = DOCUMENT;
            _data.cancelHandler = function () { return Zone.current.get('cancel'); };
            var zone = Zone.current.fork({
                name: 'UNIVERSAL request',
                properties: _data
            });
            return zone.run(function () { return (_options.precompile ?
                platformRef.serializeModule(ngModule, _data) :
                platformRef.serializeModuleFactory(ngModule, _data))
                .then(function (html) {
                if (typeof html !== 'string' || cancel) {
                    return done(null, DOCUMENT);
                }
                done(null, html);
            })
                .catch(function (e) {
                console.log(e.stack);
                done(null, DOCUMENT);
            }); });
        }
        try {
            if (cache[filePath]) {
                return readContent(cache[filePath]);
            }
            fs.readFile(filePath, function (err, content) {
                if (err) {
                    cancel = true;
                    return done(err);
                }
                cache[filePath] = content;
                return readContent(content);
            });
        }
        catch (e) {
            cancel = true;
            done(e);
        }
    };
}
exports.createEngine = createEngine;
//# sourceMappingURL=index.js.map