System.register(['angular2/core'], function(exports_1) {
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __metadata = (this && this.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
    };
    var core_1;
    var NgGrid, NgGridItem, NgGridPlaceholder;
    return {
        setters:[
            function (core_1_1) {
                core_1 = core_1_1;
            }],
        execute: function() {
            NgGrid = (function () {
                //	Constructor
                function NgGrid(_differs, _ngEl, _renderer, _loader) {
                    this._differs = _differs;
                    this._ngEl = _ngEl;
                    this._renderer = _renderer;
                    this._loader = _loader;
                    //	Event Emitters
                    this.dragStart = new core_1.EventEmitter();
                    this.drag = new core_1.EventEmitter();
                    this.dragStop = new core_1.EventEmitter();
                    this.resizeStart = new core_1.EventEmitter();
                    this.resize = new core_1.EventEmitter();
                    this.resizeStop = new core_1.EventEmitter();
                    //	Public variables
                    this.colWidth = 250;
                    this.rowHeight = 250;
                    this.minCols = 1;
                    this.minRows = 1;
                    this.marginTop = 10;
                    this.marginRight = 10;
                    this.marginBottom = 10;
                    this.marginLeft = 10;
                    this.isDragging = false;
                    this.isResizing = false;
                    this.autoStyle = true;
                    this.resizeEnable = true;
                    this.dragEnable = true;
                    this.cascade = 'up';
                    //	Private variables
                    this._items = [];
                    this._draggingItem = null;
                    this._resizingItem = null;
                    this._resizeDirection = null;
                    this._itemGrid = { 1: { 1: null } };
                    this._maxCols = 0;
                    this._maxRows = 0;
                    this._minWidth = 100;
                    this._minHeight = 100;
                    this._setWidth = 250;
                    this._setHeight = 250;
                    this._posOffset = null;
                    this._adding = false;
                    this._placeholderRef = null;
                    this._fixToGrid = false;
                    this._autoResize = false;
                    this._config = NgGrid.CONST_DEFAULT_CONFIG;
                }
                Object.defineProperty(NgGrid.prototype, "config", {
                    //	[ng-grid] attribute handler
                    set: function (v) {
                        this._config = v;
                        if (this._differ == null && v != null) {
                            this._differ = this._differs.find(this._config).create(null);
                        }
                        this.setConfig(this._config);
                    },
                    enumerable: true,
                    configurable: true
                });
                //	Public methods
                NgGrid.prototype.ngOnInit = function () {
                    this._renderer.setElementClass(this._ngEl.nativeElement, 'grid', true);
                    if (this.autoStyle)
                        this._renderer.setElementStyle(this._ngEl.nativeElement, 'position', 'relative');
                    this.setConfig(this._config);
                };
                NgGrid.prototype.setConfig = function (config) {
                    var maxColRowChanged = false;
                    for (var x in config) {
                        var val = config[x];
                        switch (x) {
                            case 'margins':
                                this.setMargins(val);
                                break;
                            case 'col_width':
                                this.colWidth = parseInt(val);
                                break;
                            case 'row_height':
                                this.rowHeight = parseInt(val);
                                break;
                            case 'auto_style':
                                this.autoStyle = val ? true : false;
                                break;
                            case 'auto_resize':
                                this._autoResize = val ? true : false;
                                break;
                            case 'draggable':
                                this.dragEnable = val ? true : false;
                                break;
                            case 'resizable':
                                this.resizeEnable = val ? true : false;
                                break;
                            case 'max_rows':
                                maxColRowChanged = maxColRowChanged || this._maxRows != parseInt(val);
                                this._maxRows = parseInt(val);
                                break;
                            case 'max_cols':
                                maxColRowChanged = maxColRowChanged || this._maxCols != parseInt(val);
                                this._maxCols = parseInt(val);
                                break;
                            case 'min_rows':
                                this.minRows = Math.max(parseInt(val), 1);
                                break;
                            case 'min_cols':
                                this.minCols = Math.max(parseInt(val), 1);
                                break;
                            case 'min_height':
                                this._minHeight = parseInt(val);
                                break;
                            case 'min_width':
                                this._minWidth = parseInt(val);
                                break;
                            case 'cascade':
                                if (this.cascade != val) {
                                    this.cascade = val;
                                    this._cascadeGrid();
                                }
                                break;
                            case 'fix_to_grid':
                                this._fixToGrid = val ? true : false;
                                break;
                        }
                    }
                    if (maxColRowChanged) {
                        if (this._maxCols > 0 && this._maxRows > 0) {
                            switch (this.cascade) {
                                case "left":
                                case "right":
                                    this._maxCols = 0;
                                    break;
                                case "up":
                                case "down":
                                default:
                                    this._maxRows = 0;
                                    break;
                            }
                        }
                        for (var x in this._items) {
                            var pos = this._items[x].getGridPosition();
                            var dims = this._items[x].getSize();
                            this._removeFromGrid(this._items[x]);
                            if (this._hasGridCollision(pos, dims) || !this._isWithinBounds(pos, dims)) {
                                var newPosition = this._fixGridPosition(pos, dims);
                                this._items[x].setGridPosition(newPosition.col, newPosition.row);
                            }
                            this._addToGrid(this._items[x]);
                        }
                        this._cascadeGrid();
                    }
                    if (this._autoResize && this._maxCols > 0) {
                        var maxWidth = this._ngEl.nativeElement.getBoundingClientRect().width;
                        var colWidth = Math.floor(maxWidth / this._maxCols);
                        colWidth -= (this.marginLeft + this.marginRight);
                        if (colWidth > 0)
                            this.colWidth = colWidth;
                    }
                    else if (this._autoResize && this._maxRows > 0) {
                        var maxHeight = window.innerHeight;
                        var rowHeight = Math.floor(maxHeight / this._maxRows);
                        rowHeight -= (this.marginTop + this.marginBottom);
                        if (rowHeight > 0)
                            this.rowHeight = rowHeight;
                    }
                    var maxWidth = this._maxCols * this.colWidth;
                    var maxHeight = this._maxRows * this.rowHeight;
                    if (maxWidth > 0 && this._minWidth > maxWidth)
                        this._minWidth = 0.75 * this.colWidth;
                    if (maxHeight > 0 && this._minHeight > maxHeight)
                        this._minHeight = 0.75 * this.rowHeight;
                    if (this._minWidth > this.colWidth)
                        this.minCols = Math.max(this.minCols, Math.ceil(this._minWidth / this.colWidth));
                    if (this._minHeight > this.rowHeight)
                        this.minRows = Math.max(this.minRows, Math.ceil(this._minHeight / this.rowHeight));
                    if (this._maxCols > 0 && this.minCols > this._maxCols)
                        this.minCols = 1;
                    if (this._maxRows > 0 && this.minRows > this._maxRows)
                        this.minRows = 1;
                    for (var x in this._items) {
                        this._removeFromGrid(this._items[x]);
                        this._items[x].recalculateSelf();
                        this._addToGrid(this._items[x]);
                    }
                    this._cascadeGrid();
                    this._updateSize();
                };
                NgGrid.prototype.getItemPosition = function (index) {
                    return this._items[index].getGridPosition();
                };
                NgGrid.prototype.getItemSize = function (index) {
                    return this._items[index].getSize();
                };
                NgGrid.prototype.ngDoCheck = function () {
                    if (this._differ != null) {
                        var changes = this._differ.diff(this._config);
                        if (changes != null) {
                            this._applyChanges(changes);
                            return true;
                        }
                    }
                    return false;
                };
                NgGrid.prototype.setMargins = function (margins) {
                    this.marginTop = parseInt(margins[0]);
                    this.marginRight = margins.length >= 2 ? parseInt(margins[1]) : this.marginTop;
                    this.marginBottom = margins.length >= 3 ? parseInt(margins[2]) : this.marginTop;
                    this.marginLeft = margins.length >= 4 ? parseInt(margins[3]) : this.marginRight;
                };
                NgGrid.prototype.enableDrag = function () {
                    this.dragEnable = true;
                };
                NgGrid.prototype.disableDrag = function () {
                    this.dragEnable = false;
                };
                NgGrid.prototype.enableResize = function () {
                    this.resizeEnable = true;
                };
                NgGrid.prototype.disableResize = function () {
                    this.resizeEnable = false;
                };
                NgGrid.prototype.addItem = function (ngItem) {
                    var newPos = this._fixGridPosition(ngItem.getGridPosition(), ngItem.getSize());
                    ngItem.setGridPosition(newPos.col, newPos.row);
                    this._items.push(ngItem);
                    this._addToGrid(ngItem);
                    ngItem.recalculateSelf();
                };
                NgGrid.prototype.removeItem = function (ngItem) {
                    this._removeFromGrid(ngItem);
                    for (var x in this._items)
                        if (this._items[x] == ngItem)
                            this._items.splice(x, 1);
                    // Update position of all items
                    this._cascadeGrid();
                    this._updateSize();
                    this._items.forEach(function (item) { return item.recalculateSelf(); });
                };
                //	Private methods
                NgGrid.prototype._onResize = function (e) {
                    if (this._autoResize && this._maxCols > 0) {
                        var maxWidth = this._ngEl.nativeElement.getBoundingClientRect().width;
                        var colWidth = Math.floor(maxWidth / this._maxCols);
                        colWidth -= (this.marginLeft + this.marginRight);
                        this.colWidth = colWidth;
                    }
                    else if (this._autoResize && this._maxRows > 0) {
                        var maxHeight = window.innerHeight;
                        var rowHeight = Math.floor(maxHeight / this._maxRows);
                        rowHeight -= (this.marginTop + this.marginBottom);
                        this.rowHeight = rowHeight;
                    }
                    for (var x in this._items) {
                        this._items[x].recalculateSelf();
                    }
                    this._updateSize();
                };
                NgGrid.prototype._applyChanges = function (changes) {
                    var _this = this;
                    changes.forEachAddedItem(function (record) { _this._config[record.key] = record.currentValue; });
                    changes.forEachChangedItem(function (record) { _this._config[record.key] = record.currentValue; });
                    changes.forEachRemovedItem(function (record) { delete _this._config[record.key]; });
                    this.setConfig(this._config);
                };
                NgGrid.prototype._onMouseDown = function (e) {
                    var mousePos = this._getMousePosition(e);
                    var item = this._getItemFromPosition(mousePos);
                    if (item != null) {
                        if (this.resizeEnable && item.canResize(e) != null) {
                            this._resizeStart(e);
                            return false;
                        }
                        else if (this.dragEnable && item.canDrag(e)) {
                            this._dragStart(e);
                            return false;
                        }
                    }
                    return true;
                };
                NgGrid.prototype._resizeStart = function (e) {
                    if (this.resizeEnable) {
                        var mousePos = this._getMousePosition(e);
                        var item = this._getItemFromPosition(mousePos);
                        item.startMoving();
                        this._resizingItem = item;
                        this._resizeDirection = item.canResize(e);
                        this._removeFromGrid(item);
                        this._createPlaceholder(item.getGridPosition(), item.getSize());
                        this.isResizing = true;
                        this.resizeStart.emit(item);
                        item.resizeStart.emit(item.getEventOutput());
                    }
                };
                NgGrid.prototype._dragStart = function (e) {
                    if (this.dragEnable) {
                        var mousePos = this._getMousePosition(e);
                        var item = this._getItemFromPosition(mousePos);
                        var itemPos = item.getPosition();
                        var pOffset = { 'left': (mousePos.left - itemPos.left), 'top': (mousePos.top - itemPos.top) };
                        item.startMoving();
                        this._draggingItem = item;
                        this._posOffset = pOffset;
                        this._removeFromGrid(item);
                        this._createPlaceholder(item.getGridPosition(), item.getSize());
                        this.isDragging = true;
                        this.dragStart.emit(item);
                        item.dragStart.emit(item.getEventOutput());
                    }
                };
                NgGrid.prototype._onMouseMove = function (e) {
                    if (e.buttons == 0 && this.isDragging) {
                        this._dragStop(e);
                    }
                    else if (e.buttons == 0 && this.isResizing) {
                        this._resizeStop(e);
                    }
                    else if (this.isDragging) {
                        this._drag(e);
                    }
                    else if (this.isResizing) {
                        this._resize(e);
                    }
                    else {
                        var mousePos = this._getMousePosition(e);
                        var item = this._getItemFromPosition(mousePos);
                        if (item) {
                            item.onMouseMove(e);
                        }
                    }
                };
                NgGrid.prototype._drag = function (e) {
                    if (this.isDragging) {
                        var mousePos = this._getMousePosition(e);
                        var newL = (mousePos.left - this._posOffset.left);
                        var newT = (mousePos.top - this._posOffset.top);
                        var itemPos = this._draggingItem.getGridPosition();
                        var gridPos = this._calculateGridPosition(newL, newT);
                        var dims = this._draggingItem.getSize();
                        if (!this._isWithinBoundsX(gridPos, dims))
                            gridPos.col = this._maxCols - (dims.x - 1);
                        if (!this._isWithinBoundsY(gridPos, dims))
                            gridPos.row = this._maxRows - (dims.y - 1);
                        if (gridPos.col != itemPos.col || gridPos.row != itemPos.row) {
                            this._draggingItem.setGridPosition(gridPos.col, gridPos.row);
                            this._placeholderRef.instance.setGridPosition(gridPos.col, gridPos.row);
                            if (['up', 'down', 'left', 'right'].indexOf(this.cascade) >= 0) {
                                this._fixGridCollisions(gridPos, dims);
                                this._cascadeGrid(gridPos, dims);
                            }
                        }
                        if (!this._fixToGrid) {
                            this._draggingItem.setPosition(newL, newT);
                        }
                        this.drag.emit(this._draggingItem);
                        this._draggingItem.drag.emit(this._draggingItem.getEventOutput());
                    }
                };
                NgGrid.prototype._resize = function (e) {
                    if (this.isResizing) {
                        var mousePos = this._getMousePosition(e);
                        var itemPos = this._resizingItem.getPosition();
                        var itemDims = this._resizingItem.getDimensions();
                        var newW = this._resizeDirection == 'height' ? itemDims.width : (mousePos.left - itemPos.left + 10);
                        var newH = this._resizeDirection == 'width' ? itemDims.height : (mousePos.top - itemPos.top + 10);
                        if (newW < this._minWidth)
                            newW = this._minWidth;
                        if (newH < this._minHeight)
                            newH = this._minHeight;
                        var calcSize = this._calculateGridSize(newW, newH);
                        var itemSize = this._resizingItem.getSize();
                        var iGridPos = this._resizingItem.getGridPosition();
                        if (!this._isWithinBoundsX(iGridPos, calcSize))
                            calcSize.x = (this._maxCols - iGridPos.col) + 1;
                        if (!this._isWithinBoundsY(iGridPos, calcSize))
                            calcSize.y = (this._maxRows - iGridPos.row) + 1;
                        if (calcSize.x != itemSize.x || calcSize.y != itemSize.y) {
                            this._resizingItem.setSize(calcSize.x, calcSize.y);
                            this._placeholderRef.instance.setSize(calcSize.x, calcSize.y);
                            if (['up', 'down', 'left', 'right'].indexOf(this.cascade) >= 0) {
                                this._fixGridCollisions(iGridPos, calcSize);
                                this._cascadeGrid(iGridPos, calcSize);
                            }
                        }
                        if (!this._fixToGrid)
                            this._resizingItem.setDimensions(newW, newH);
                        var bigGrid = this._maxGridSize(itemPos.left + newW + (2 * e.movementX), itemPos.top + newH + (2 * e.movementY));
                        if (this._resizeDirection == 'height')
                            bigGrid.x = iGridPos.col + itemSize.x;
                        if (this._resizeDirection == 'width')
                            bigGrid.y = iGridPos.row + itemSize.y;
                        this.resize.emit(this._resizingItem);
                        this._resizingItem.resize.emit(this._resizingItem.getEventOutput());
                    }
                };
                NgGrid.prototype._onMouseUp = function (e) {
                    if (this.isDragging) {
                        this._dragStop(e);
                        return false;
                    }
                    else if (this.isResizing) {
                        this._resizeStop(e);
                        return false;
                    }
                    return true;
                };
                NgGrid.prototype._dragStop = function (e) {
                    if (this.isDragging) {
                        this.isDragging = false;
                        var itemPos = this._draggingItem.getGridPosition();
                        this._draggingItem.setGridPosition(itemPos.col, itemPos.row);
                        this._addToGrid(this._draggingItem);
                        this._cascadeGrid();
                        this._draggingItem.stopMoving();
                        this._draggingItem.dragStop.emit(this._draggingItem.getEventOutput());
                        this.dragStop.emit(this._draggingItem);
                        this._draggingItem = null;
                        this._posOffset = null;
                        this._placeholderRef.dispose();
                    }
                };
                NgGrid.prototype._resizeStop = function (e) {
                    if (this.isResizing) {
                        this.isResizing = false;
                        var itemDims = this._resizingItem.getSize();
                        this._resizingItem.setSize(itemDims.x, itemDims.y);
                        this._addToGrid(this._resizingItem);
                        this._cascadeGrid();
                        this._resizingItem.stopMoving();
                        this._resizingItem.resizeStop.emit(this._resizingItem.getEventOutput());
                        this.resizeStop.emit(this._resizingItem);
                        this._resizingItem = null;
                        this._resizeDirection = null;
                        this._placeholderRef.dispose();
                    }
                };
                NgGrid.prototype._maxGridSize = function (w, h) {
                    var sizex = Math.ceil(w / (this.colWidth + this.marginLeft + this.marginRight));
                    var sizey = Math.ceil(h / (this.rowHeight + this.marginTop + this.marginBottom));
                    return { 'x': sizex, 'y': sizey };
                };
                NgGrid.prototype._calculateGridSize = function (width, height) {
                    width += this.marginLeft + this.marginRight;
                    height += this.marginTop + this.marginBottom;
                    var sizex = Math.max(this.minCols, Math.round(width / (this.colWidth + this.marginLeft + this.marginRight)));
                    var sizey = Math.max(this.minRows, Math.round(height / (this.rowHeight + this.marginTop + this.marginBottom)));
                    if (!this._isWithinBoundsX({ col: 1, row: 1 }, { x: sizex, y: sizey }))
                        sizex = this._maxCols;
                    if (!this._isWithinBoundsY({ col: 1, row: 1 }, { x: sizex, y: sizey }))
                        sizey = this._maxRows;
                    return { 'x': sizex, 'y': sizey };
                };
                NgGrid.prototype._calculateGridPosition = function (left, top) {
                    var col = Math.max(1, Math.round(left / (this.colWidth + this.marginLeft + this.marginRight)) + 1);
                    var row = Math.max(1, Math.round(top / (this.rowHeight + this.marginTop + this.marginBottom)) + 1);
                    if (!this._isWithinBoundsX({ col: col, row: row }, { x: 1, y: 1 }))
                        col = this._maxCols;
                    if (!this._isWithinBoundsY({ col: col, row: row }, { x: 1, y: 1 }))
                        row = this._maxRows;
                    return { 'col': col, 'row': row };
                };
                NgGrid.prototype._hasGridCollision = function (pos, dims) {
                    var positions = this._getCollisions(pos, dims);
                    if (positions == null || positions.length == 0)
                        return false;
                    return positions.some(function (v) {
                        return !(v === null);
                    });
                };
                NgGrid.prototype._getCollisions = function (pos, dims) {
                    var returns = [];
                    for (var j = 0; j < dims.y; j++)
                        if (this._itemGrid[pos.row + j] != null)
                            for (var i = 0; i < dims.x; i++)
                                if (this._itemGrid[pos.row + j][pos.col + i] != null)
                                    returns.push(this._itemGrid[pos.row + j][pos.col + i]);
                    return returns;
                };
                NgGrid.prototype._fixGridCollisions = function (pos, dims) {
                    while (this._hasGridCollision(pos, dims)) {
                        var collisions = this._getCollisions(pos, dims);
                        var me = this;
                        this._removeFromGrid(collisions[0]);
                        var itemPos = collisions[0].getGridPosition();
                        var itemDims = collisions[0].getSize();
                        switch (this.cascade) {
                            case "up":
                            case "down":
                            default:
                                if (!this._isWithinBoundsY(itemPos, itemDims)) {
                                    itemPos.col++;
                                }
                                else {
                                    itemPos.row++;
                                }
                                collisions[0].setGridPosition(itemPos.col, itemPos.row);
                                break;
                            case "left":
                            case "right":
                                if (!this._isWithinBoundsX(itemPos, itemDims)) {
                                    itemPos.row++;
                                }
                                else {
                                    itemPos.col++;
                                }
                                collisions[0].setGridPosition(itemPos.col, itemPos.row);
                                break;
                        }
                        this._fixGridCollisions(itemPos, itemDims);
                        this._addToGrid(collisions[0]);
                    }
                };
                NgGrid.prototype._cascadeGrid = function (pos, dims) {
                    if (pos && !dims)
                        throw new Error("Cannot cascade with only position and not dimensions");
                    switch (this.cascade) {
                        case "up":
                        case "down":
                            var lowRow = [0];
                            for (var i = 1; i <= this._getMaxCol(); i++)
                                lowRow[i] = 1;
                            for (var r = 1; r <= this._getMaxRow(); r++) {
                                if (this._itemGrid[r] == undefined)
                                    continue;
                                for (var c = 1; c <= this._getMaxCol(); c++) {
                                    if (this._itemGrid[r] == undefined)
                                        break;
                                    if (r < lowRow[c])
                                        continue;
                                    if (this._itemGrid[r][c] != null) {
                                        var item = this._itemGrid[r][c];
                                        if (item.isFixed)
                                            continue;
                                        var itemDims = item.getSize();
                                        var itemPos = item.getGridPosition();
                                        if (itemPos.col != c || itemPos.row != r)
                                            continue; //	If this is not the element's start
                                        var lowest = lowRow[c];
                                        for (var i = 1; i < itemDims.x; i++) {
                                            lowest = Math.max(lowRow[(c + i)], lowest);
                                        }
                                        if (pos && (c + itemDims.x) > pos.col && c < (pos.col + dims.x)) {
                                            if ((r >= pos.row && r < (pos.row + dims.y)) ||
                                                ((itemDims.y > (pos.row - lowest)) &&
                                                    (r >= (pos.row + dims.y) && lowest < (pos.row + dims.y)))) {
                                                lowest = Math.max(lowest, pos.row + dims.y); //	Set the lowest row to be below it
                                            }
                                        }
                                        if (lowest != itemPos.row) {
                                            this._removeFromGrid(item);
                                            item.setGridPosition(c, lowest);
                                            this._addToGrid(item);
                                        }
                                        for (var i = 0; i < itemDims.x; i++) {
                                            lowRow[c + i] = lowest + itemDims.y; //	Update the lowest row to be below the item
                                        }
                                    }
                                }
                            }
                            break;
                        case "left":
                        case "right":
                            var lowCol = [0];
                            for (var i = 1; i <= this._getMaxRow(); i++)
                                lowCol[i] = 1;
                            for (var r = 1; r <= this._getMaxRow(); r++) {
                                if (this._itemGrid[r] == undefined)
                                    continue;
                                for (var c = 1; c <= this._getMaxCol(); c++) {
                                    if (this._itemGrid[r] == undefined)
                                        break;
                                    if (c < lowCol[r])
                                        continue;
                                    if (this._itemGrid[r][c] != null) {
                                        var item = this._itemGrid[r][c];
                                        var itemDims = item.getSize();
                                        var itemPos = item.getGridPosition();
                                        if (itemPos.col != c || itemPos.row != r)
                                            continue; //	If this is not the element's start
                                        var lowest = lowCol[r];
                                        for (var i = 1; i < itemDims.y; i++) {
                                            lowest = Math.max(lowCol[(r + i)], lowest);
                                        }
                                        if (pos && (r + itemDims.y) > pos.row && r < (pos.row + dims.y)) {
                                            if ((c >= pos.col && c < (pos.col + dims.x)) ||
                                                ((itemDims.x > (pos.col - lowest)) &&
                                                    (c >= (pos.col + dims.x) && lowest < (pos.col + dims.x)))) {
                                                lowest = Math.max(lowest, pos.col + dims.x); //	Set the lowest col to be below it
                                            }
                                        }
                                        if (lowest != itemPos.col) {
                                            this._removeFromGrid(item);
                                            item.setGridPosition(lowest, r);
                                            this._addToGrid(item);
                                        }
                                        for (var i = 0; i < itemDims.y; i++) {
                                            lowCol[r + i] = lowest + itemDims.x; //	Update the lowest col to be below the item
                                        }
                                    }
                                }
                            }
                            break;
                        default:
                            break;
                    }
                };
                NgGrid.prototype._fixGridPosition = function (pos, dims) {
                    while (this._hasGridCollision(pos, dims) || !this._isWithinBounds(pos, dims)) {
                        if (this._hasGridCollision(pos, dims)) {
                            switch (this.cascade) {
                                case 'up':
                                case 'down':
                                    pos.row++;
                                    break;
                                case 'left':
                                case 'right':
                                    pos.col++;
                                    break;
                                default:
                                    break;
                            }
                        }
                        if (!this._isWithinBoundsY(pos, dims)) {
                            pos.col++;
                            pos.row = 1;
                        }
                        if (!this._isWithinBoundsX(pos, dims)) {
                            pos.row++;
                            pos.col = 1;
                        }
                    }
                    return pos;
                };
                NgGrid.prototype._isWithinBoundsX = function (pos, dims) {
                    return (this._maxCols == 0 || (pos.col + dims.x - 1) <= this._maxCols);
                };
                NgGrid.prototype._isWithinBoundsY = function (pos, dims) {
                    return (this._maxRows == 0 || (pos.row + dims.y - 1) <= this._maxRows);
                };
                NgGrid.prototype._isWithinBounds = function (pos, dims) {
                    return this._isWithinBoundsX(pos, dims) && this._isWithinBoundsY(pos, dims);
                };
                NgGrid.prototype._addToGrid = function (item) {
                    var pos = item.getGridPosition();
                    var dims = item.getSize();
                    if (this._hasGridCollision(pos, dims)) {
                        this._fixGridCollisions(pos, dims);
                        pos = item.getGridPosition();
                    }
                    for (var j = 0; j < dims.y; j++) {
                        if (this._itemGrid[pos.row + j] == null)
                            this._itemGrid[pos.row + j] = {};
                        for (var i = 0; i < dims.x; i++) {
                            this._itemGrid[pos.row + j][pos.col + i] = item;
                            this._updateSize(pos.col + dims.x - 1, pos.row + dims.y - 1);
                        }
                    }
                };
                NgGrid.prototype._removeFromGrid = function (item) {
                    for (var y in this._itemGrid)
                        for (var x in this._itemGrid[y])
                            if (this._itemGrid[y][x] == item)
                                this._itemGrid[y][x] = null;
                };
                NgGrid.prototype._updateSize = function (col, row) {
                    col = (col == undefined) ? 0 : col;
                    row = (row == undefined) ? 0 : row;
                    this._filterGrid();
                    var maxRow = Math.max(this._getMaxRow(), row);
                    var maxCol = Math.max(this._getMaxCol(), col);
                    this._renderer.setElementStyle(this._ngEl.nativeElement, 'width', "100%"); //(maxCol * (this.colWidth + this.marginLeft + this.marginRight))+"px");
                    this._renderer.setElementStyle(this._ngEl.nativeElement, 'height', (maxRow * (this.rowHeight + this.marginTop + this.marginBottom)) + "px");
                };
                NgGrid.prototype._filterGrid = function () {
                    var curMaxCol = this._getMaxCol();
                    var curMaxRow = this._getMaxRow();
                    var maxCol = 0;
                    var maxRow = 0;
                    for (var r = 1; r <= curMaxRow; r++) {
                        if (this._itemGrid[r] == undefined)
                            continue;
                        for (var c = 1; c <= curMaxCol; c++) {
                            if (this._itemGrid[r][c] != null) {
                                maxCol = Math.max(maxCol, c);
                                maxRow = Math.max(maxRow, r);
                            }
                        }
                    }
                    if (curMaxRow != maxRow)
                        for (var r = maxRow + 1; r <= curMaxRow; r++)
                            if (this._itemGrid[r] !== undefined)
                                delete this._itemGrid[r];
                    if (curMaxCol != maxCol)
                        for (var r = 1; r <= maxRow; r++) {
                            if (this._itemGrid[r] == undefined)
                                continue;
                            for (var c = maxCol + 1; c <= curMaxCol; c++)
                                if (this._itemGrid[r][c] !== undefined)
                                    delete this._itemGrid[r][c];
                        }
                };
                NgGrid.prototype._getMaxRow = function () {
                    return Math.max.apply(null, Object.keys(this._itemGrid));
                };
                NgGrid.prototype._getMaxCol = function () {
                    var me = this;
                    var maxes = [0];
                    Object.keys(me._itemGrid).map(function (v) { maxes.push(Math.max.apply(null, Object.keys(me._itemGrid[v]))); });
                    return Math.max.apply(null, maxes);
                };
                NgGrid.prototype._getMousePosition = function (e) {
                    if ((window.TouchEvent && e instanceof TouchEvent) || (e.touches || e.changedTouches)) {
                        e = e.touches.length > 0 ? e.touches[0] : e.changedTouches[0];
                    }
                    var refPos = this._ngEl.nativeElement.getBoundingClientRect();
                    var left = e.clientX - refPos.left;
                    var top = e.clientY - refPos.top;
                    if (this.cascade == "down")
                        top = refPos.top + refPos.height - e.clientY;
                    if (this.cascade == "right")
                        left = refPos.left + refPos.width - e.clientX;
                    return {
                        left: left,
                        top: top
                    };
                };
                NgGrid.prototype._getAbsoluteMousePosition = function (e) {
                    if ((window.TouchEvent && e instanceof TouchEvent) || (e.touches || e.changedTouches)) {
                        e = e.touches.length > 0 ? e.touches[0] : e.changedTouches[0];
                    }
                    return {
                        left: e.clientX,
                        top: e.clientY
                    };
                };
                NgGrid.prototype._getItemFromPosition = function (position) {
                    for (var x in this._items) {
                        var size = this._items[x].getDimensions();
                        var pos = this._items[x].getPosition();
                        if (position.left > (pos.left + this.marginLeft) && position.left < (pos.left + this.marginLeft + size.width) &&
                            position.top > (pos.top + this.marginTop) && position.top < (pos.top + this.marginTop + size.height)) {
                            return this._items[x];
                        }
                    }
                    return null;
                };
                NgGrid.prototype._createPlaceholder = function (pos, dims) {
                    var me = this;
                    this._loader.loadNextToLocation(NgGridPlaceholder, this._ngEl.internalElement.parentView.appElements[this._ngEl.internalElement.proto.index + 1].ref).then(function (componentRef) {
                        me._placeholderRef = componentRef;
                        var placeholder = componentRef.instance;
                        // me._placeholder.setGrid(me);
                        placeholder.setGridPosition(pos.col, pos.row);
                        placeholder.setSize(dims.x, dims.y);
                    });
                };
                //	Default config
                NgGrid.CONST_DEFAULT_CONFIG = {
                    'margins': [10],
                    'draggable': true,
                    'resizable': true,
                    'max_cols': 0,
                    'max_rows': 0,
                    'col_width': 250,
                    'row_height': 250,
                    'cascade': 'up',
                    'min_width': 100,
                    'min_height': 100,
                    'fix_to_grid': false,
                    'auto_style': true,
                    'auto_resize': false
                };
                NgGrid = __decorate([
                    core_1.Directive({
                        selector: '[ngGrid]',
                        inputs: ['config: ngGrid'],
                        host: {
                            '(mousedown)': '_onMouseDown($event)',
                            '(mousemove)': '_onMouseMove($event)',
                            '(mouseup)': '_onMouseUp($event)',
                            '(touchstart)': '_onMouseDown($event)',
                            '(touchmove)': '_onMouseMove($event)',
                            '(touchend)': '_onMouseUp($event)',
                            '(window:resize)': '_onResize($event)',
                            '(document:mousemove)': '_onMouseMove($event)',
                            '(document:mouseup)': '_onMouseUp($event)'
                        },
                        outputs: ['dragStart', 'drag', 'dragStop', 'resizeStart', 'resize', 'resizeStop']
                    }), 
                    __metadata('design:paramtypes', [core_1.KeyValueDiffers, core_1.ElementRef, core_1.Renderer, core_1.DynamicComponentLoader])
                ], NgGrid);
                return NgGrid;
            })();
            exports_1("NgGrid", NgGrid);
            NgGridItem = (function () {
                //	Constructor
                function NgGridItem(_ngEl, _renderer, _ngGrid) {
                    this._ngEl = _ngEl;
                    this._renderer = _renderer;
                    this._ngGrid = _ngGrid;
                    //	Event Emitters
                    this.itemChange = new core_1.EventEmitter();
                    this.dragStart = new core_1.EventEmitter();
                    this.drag = new core_1.EventEmitter();
                    this.dragStop = new core_1.EventEmitter();
                    this.resizeStart = new core_1.EventEmitter();
                    this.resize = new core_1.EventEmitter();
                    this.resizeStop = new core_1.EventEmitter();
                    this.gridPosition = { 'col': 1, 'row': 1 };
                    this.gridSize = { 'x': 1, 'y': 1 };
                    this.isFixed = false;
                    this.isDraggable = true;
                    this.isResizable = true;
                    //	Private variables
                    this._col = 1;
                    this._row = 1;
                    this._sizex = 1;
                    this._sizey = 1;
                    this._config = NgGridItem.CONST_DEFAULT_CONFIG;
                    this._added = false;
                }
                Object.defineProperty(NgGridItem.prototype, "config", {
                    //	[ng-grid-item] handler
                    set: function (v) {
                        var defaults = NgGridItem.CONST_DEFAULT_CONFIG;
                        for (var x in defaults)
                            if (v[x] == null)
                                v[x] = defaults[x];
                        this.setConfig(v);
                        if (!this._added) {
                            this._added = true;
                            this._ngGrid.addItem(this);
                        }
                        this._recalculateDimensions();
                        this._recalculatePosition();
                    },
                    enumerable: true,
                    configurable: true
                });
                NgGridItem.prototype.ngOnInit = function () {
                    this._renderer.setElementClass(this._ngEl.nativeElement, 'grid-item', true);
                    if (this._ngGrid.autoStyle)
                        this._renderer.setElementStyle(this._ngEl.nativeElement, 'position', 'absolute');
                    this._recalculateDimensions();
                    this._recalculatePosition();
                    if (!this._added) {
                        this._added = true;
                        this._ngGrid.addItem(this);
                    }
                };
                //	Public methods
                NgGridItem.prototype.canDrag = function (e) {
                    if (!this.isDraggable)
                        return false;
                    if (this._dragHandle) {
                        var parent = e.target.parentElement;
                        return parent.querySelector(this._dragHandle) == e.target;
                    }
                    return true;
                };
                NgGridItem.prototype.canResize = function (e) {
                    if (!this.isResizable)
                        return null;
                    if (this._resizeHandle) {
                        var parent = e.target.parentElement;
                        return parent.querySelector(this._resizeHandle) == e.target ? 'both' : null;
                    }
                    var mousePos = this._getMousePosition(e);
                    if (mousePos.left < this._elemWidth && mousePos.left > this._elemWidth - this._borderSize
                        && mousePos.top < this._elemHeight && mousePos.top > this._elemHeight - this._borderSize) {
                        return 'both';
                    }
                    else if (mousePos.left < this._elemWidth && mousePos.left > this._elemWidth - this._borderSize) {
                        return 'width';
                    }
                    else if (mousePos.top < this._elemHeight && mousePos.top > this._elemHeight - this._borderSize) {
                        return 'height';
                    }
                    return null;
                };
                NgGridItem.prototype.onMouseMove = function (e) {
                    if (this._ngGrid.autoStyle) {
                        if (this._ngGrid.dragEnable && this.canDrag(e)) {
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'move');
                        }
                        else if (this._ngGrid.resizeEnable && !this._resizeHandle && this.isResizable) {
                            var mousePos = this._getMousePosition(e);
                            if (mousePos.left < this._elemWidth && mousePos.left > this._elemWidth - this._borderSize
                                && mousePos.top < this._elemHeight && mousePos.top > this._elemHeight - this._borderSize) {
                                this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'nwse-resize');
                            }
                            else if (mousePos.left < this._elemWidth && mousePos.left > this._elemWidth - this._borderSize) {
                                this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'ew-resize');
                            }
                            else if (mousePos.top < this._elemHeight && mousePos.top > this._elemHeight - this._borderSize) {
                                this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'ns-resize');
                            }
                            else {
                                this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'default');
                            }
                        }
                        else if (this._ngGrid.resizeEnable && this.canResize(e)) {
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'nwse-resize');
                        }
                        else {
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'cursor', 'default');
                        }
                    }
                };
                NgGridItem.prototype.ngOnDestroy = function () {
                    if (this._added)
                        this._ngGrid.removeItem(this);
                };
                //	Getters
                NgGridItem.prototype.getElement = function () {
                    return this._ngEl;
                };
                NgGridItem.prototype.getDragHandle = function () {
                    return this._dragHandle;
                };
                NgGridItem.prototype.getResizeHandle = function () {
                    return this._resizeHandle;
                };
                NgGridItem.prototype.getDimensions = function () {
                    return { 'width': this._elemWidth, 'height': this._elemHeight };
                };
                NgGridItem.prototype.getSize = function () {
                    return { 'x': this._sizex, 'y': this._sizey };
                };
                NgGridItem.prototype.getPosition = function () {
                    return { 'left': this._elemLeft, 'top': this._elemTop };
                };
                NgGridItem.prototype.getGridPosition = function () {
                    return { 'col': this._col, 'row': this._row };
                };
                //	Setters
                NgGridItem.prototype.setConfig = function (config) {
                    this._col = config.col;
                    this._row = config.row;
                    this._sizex = config.sizex;
                    this._sizey = config.sizey;
                    this._dragHandle = config.dragHandle;
                    this._resizeHandle = config.resizeHandle;
                    this._borderSize = config.borderSize;
                    this.isDraggable = config.draggable ? true : false;
                    this.isResizable = config.resizable ? true : false;
                    this.isFixed = config.fixed ? true : false;
                    this._recalculatePosition();
                    this._recalculateDimensions();
                };
                NgGridItem.prototype.setSize = function (x, y) {
                    this._sizex = x;
                    this._sizey = y;
                    this.gridSize = { 'x': this._sizex, 'y': this._sizey };
                    this._recalculateDimensions();
                    this.itemChange.emit(this.getEventOutput());
                };
                NgGridItem.prototype.setGridPosition = function (col, row) {
                    this._col = col;
                    this._row = row;
                    this.gridPosition = { 'col': this._col, 'row': this._row };
                    this._recalculatePosition();
                    this.itemChange.emit(this.getEventOutput());
                };
                NgGridItem.prototype.getEventOutput = function () {
                    return {
                        col: this._col,
                        row: this._row,
                        sizex: this._sizex,
                        sizey: this._sizey,
                        width: this._elemWidth,
                        height: this._elemHeight,
                        left: this._elemLeft,
                        top: this._elemTop
                    };
                };
                NgGridItem.prototype.setPosition = function (x, y) {
                    switch (this._ngGrid.cascade) {
                        case 'up':
                        case 'left':
                        default:
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'left', x + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'top', y + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'right', null);
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'bottom', null);
                            break;
                        case 'right':
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'right', x + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'top', y + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'left', null);
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'bottom', null);
                            break;
                        case 'down':
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'left', x + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'bottom', y + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'right', null);
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'top', null);
                            break;
                    }
                    this._elemLeft = x;
                    this._elemTop = y;
                };
                NgGridItem.prototype.setDimensions = function (w, h) {
                    this._renderer.setElementStyle(this._ngEl.nativeElement, 'width', w + "px");
                    this._renderer.setElementStyle(this._ngEl.nativeElement, 'height', h + "px");
                    this._elemWidth = w;
                    this._elemHeight = h;
                };
                NgGridItem.prototype.startMoving = function () {
                    this._renderer.setElementClass(this._ngEl.nativeElement, 'moving', true);
                    var style = window.getComputedStyle(this._ngEl.nativeElement);
                    if (this._ngGrid.autoStyle)
                        this._renderer.setElementStyle(this._ngEl.nativeElement, 'z-index', (parseInt(style.getPropertyValue('z-index')) + 1).toString());
                };
                NgGridItem.prototype.stopMoving = function () {
                    this._renderer.setElementClass(this._ngEl.nativeElement, 'moving', false);
                    var style = window.getComputedStyle(this._ngEl.nativeElement);
                    if (this._ngGrid.autoStyle)
                        this._renderer.setElementStyle(this._ngEl.nativeElement, 'z-index', (parseInt(style.getPropertyValue('z-index')) - 1).toString());
                };
                NgGridItem.prototype.recalculateSelf = function () {
                    this._recalculatePosition();
                    this._recalculateDimensions();
                };
                //	Private methods
                NgGridItem.prototype._recalculatePosition = function () {
                    var x = (this._ngGrid.colWidth + this._ngGrid.marginLeft + this._ngGrid.marginRight) * (this._col - 1) + this._ngGrid.marginLeft;
                    var y = (this._ngGrid.rowHeight + this._ngGrid.marginTop + this._ngGrid.marginBottom) * (this._row - 1) + this._ngGrid.marginTop;
                    this.setPosition(x, y);
                };
                NgGridItem.prototype._recalculateDimensions = function () {
                    if (this._sizex < this._ngGrid.minCols)
                        this._sizex = this._ngGrid.minCols;
                    if (this._sizey < this._ngGrid.minRows)
                        this._sizey = this._ngGrid.minRows;
                    var w = (this._ngGrid.colWidth * this._sizex) + ((this._ngGrid.marginLeft + this._ngGrid.marginRight) * (this._sizex - 1));
                    var h = (this._ngGrid.rowHeight * this._sizey) + ((this._ngGrid.marginTop + this._ngGrid.marginBottom) * (this._sizey - 1));
                    this.setDimensions(w, h);
                };
                NgGridItem.prototype._getMousePosition = function (e) {
                    if (e.originalEvent && e.originalEvent.touches) {
                        var oe = e.originalEvent;
                        e = oe.touches.length ? oe.touches[0] : oe.changedTouches[0];
                    }
                    var refPos = this._ngEl.nativeElement.getBoundingClientRect();
                    return {
                        left: e.clientX - refPos.left,
                        top: e.clientY - refPos.top
                    };
                };
                //	Default config
                NgGridItem.CONST_DEFAULT_CONFIG = {
                    'col': 1,
                    'row': 1,
                    'sizex': 1,
                    'sizey': 1,
                    'dragHandle': null,
                    'resizeHandle': null,
                    'fixed': false,
                    'draggable': true,
                    'resizable': true,
                    'borderSize': 15
                };
                NgGridItem = __decorate([
                    core_1.Directive({
                        selector: '[ngGridItem]',
                        inputs: ['config: ngGridItem', 'gridPosition: ngGridPosition', 'gridSize: ngGridSize'],
                        outputs: ['itemChange', 'dragStart', 'drag', 'dragStop', 'resizeStart', 'resize', 'resizeStop']
                    }), 
                    __metadata('design:paramtypes', [core_1.ElementRef, core_1.Renderer, NgGrid])
                ], NgGridItem);
                return NgGridItem;
            })();
            exports_1("NgGridItem", NgGridItem);
            NgGridPlaceholder = (function () {
                function NgGridPlaceholder(_ngEl, _renderer, _ngGrid) {
                    this._ngEl = _ngEl;
                    this._renderer = _renderer;
                    this._ngGrid = _ngGrid;
                }
                NgGridPlaceholder.prototype.ngOnInit = function () {
                    this._renderer.setElementClass(this._ngEl.nativeElement, 'grid-placeholder', true);
                    if (this._ngGrid.autoStyle)
                        this._renderer.setElementStyle(this._ngEl.nativeElement, 'position', 'absolute');
                };
                NgGridPlaceholder.prototype.setSize = function (x, y) {
                    this._sizex = x;
                    this._sizey = y;
                    this._recalculateDimensions();
                };
                NgGridPlaceholder.prototype.setGridPosition = function (col, row) {
                    this._col = col;
                    this._row = row;
                    this._recalculatePosition();
                };
                NgGridPlaceholder.prototype._setPosition = function (x, y) {
                    switch (this._ngGrid.cascade) {
                        case 'up':
                        case 'left':
                        default:
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'left', x + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'top', y + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'right', null);
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'bottom', null);
                            break;
                        case 'right':
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'right', x + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'top', y + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'left', null);
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'bottom', null);
                            break;
                        case 'down':
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'left', x + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'bottom', y + "px");
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'right', null);
                            this._renderer.setElementStyle(this._ngEl.nativeElement, 'top', null);
                            break;
                    }
                };
                NgGridPlaceholder.prototype._setDimensions = function (w, h) {
                    this._renderer.setElementStyle(this._ngEl.nativeElement, 'width', w + "px");
                    this._renderer.setElementStyle(this._ngEl.nativeElement, 'height', h + "px");
                };
                //	Private methods
                NgGridPlaceholder.prototype._recalculatePosition = function () {
                    var x = (this._ngGrid.colWidth + this._ngGrid.marginLeft + this._ngGrid.marginRight) * (this._col - 1) + this._ngGrid.marginLeft;
                    var y = (this._ngGrid.rowHeight + this._ngGrid.marginTop + this._ngGrid.marginBottom) * (this._row - 1) + this._ngGrid.marginTop;
                    this._setPosition(x, y);
                };
                NgGridPlaceholder.prototype._recalculateDimensions = function () {
                    var w = (this._ngGrid.colWidth * this._sizex) + ((this._ngGrid.marginLeft + this._ngGrid.marginRight) * (this._sizex - 1));
                    var h = (this._ngGrid.rowHeight * this._sizey) + ((this._ngGrid.marginTop + this._ngGrid.marginBottom) * (this._sizey - 1));
                    this._setDimensions(w, h);
                };
                NgGridPlaceholder = __decorate([
                    core_1.Component({
                        selector: 'div'
                    }),
                    core_1.View({
                        template: ""
                    }), 
                    __metadata('design:paramtypes', [core_1.ElementRef, core_1.Renderer, NgGrid])
                ], NgGridPlaceholder);
                return NgGridPlaceholder;
            })();
            exports_1("NgGridPlaceholder", NgGridPlaceholder);
        }
    }
});

//# sourceMappingURL=data:application/json;base64,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
