"use strict";
var TsHoek = require('./ts-hoek');
var angular2_universal_1 = require('angular2-universal');
exports.HAPI_PLATFORM = null;
function disposeHapiPlatform() {
    exports.HAPI_PLATFORM = null;
}
exports.disposeHapiPlatform = disposeHapiPlatform;
var Runtime = (function () {
    function Runtime(options) {
        this.options = options;
        this.bootstrapButton = "\n    <div id=\"bootstrapButton\">\n      <style>\n       #bootstrapButton {\n        z-index:999999999;\n        position: absolute;\n        background-color: rgb(255, 255, 255);\n        padding: 0.5em;\n        border-radius: 3px;\n        border: 1px solid rgb(207, 206, 206);\n       }\n      </style>\n      <button onclick=\"bootstrap()\">\n        Bootstrap Angular2 Client\n      </button>\n    </div>\n  ";
        this.bootstrapApp = "\n    <script>\n      setTimeout(function() {\n        bootstrap();\n      });\n    </script>\n  ";
    }
    Runtime.prototype.render = function (template, context, done) {
        var _this = this;
        context = TsHoek.applyToDefaults(context, this.options);
        // bootstrap and render component to string
        var _options = this.options;
        var _template = template;
        var _Bootloader = angular2_universal_1.Bootloader;
        var bootloader = _options.bootloader;
        if (!exports.HAPI_PLATFORM) {
            if (_options.bootloader) {
                bootloader = _Bootloader.create(_options.bootloader);
            }
            else {
                var doc = _Bootloader.parseDocument(_template);
                _options.document = doc;
                _options.template = _options.template || _template;
                bootloader = _Bootloader.create(_options);
            }
            exports.HAPI_PLATFORM = bootloader;
        }
        exports.HAPI_PLATFORM.serializeApplication(null, (_options.reuseProviders === false) ? null : _options.providers)
            .then(function (html) { return done(null, _this.buildClientScripts(html, context)); })
            .catch(function (e) {
            console.error(e.stack);
            // if server fail then return client html
            done(null, _this.buildClientScripts(template, context));
        });
    };
    Runtime.prototype.bootstrapFunction = function (config) {
        var systemConfig = (config && config.systemjs) || {};
        var url = systemConfig.componentUrl;
        return "\n    <script>\n      function bootstrap() {\n        if (this.bootstraped) return;\n        this.bootstraped = true;\n        System.import(\"" + url + "\")\n          .then(function(module) {\n            return module.main();\n          })\n          .then(function() {\n            preboot.complete();\n            var $bootstrapButton = document.getElementById(\"bootstrapButton\");\n            if ($bootstrapButton) { $bootstrapButton.remove(); }\n          });\n      }\n    </script>\n  ";
    };
    // TODO: find better ways to configure the App initial state
    // to pay off this technical debt
    // currently checking for explicit values
    Runtime.prototype.buildClientScripts = function (html, options) {
        if (!options || !options.buildClientScripts) {
            return html;
        }
        return html
            .replace(angular2_universal_1.selectorRegExpFactory('preboot'), ((options.preboot === false) ? '' : this.prebootScript(options)))
            .replace(angular2_universal_1.selectorRegExpFactory('angular'), ((options.angular === false) ? '' : this.angularScript(options)))
            .replace(angular2_universal_1.selectorRegExpFactory('bootstrap'), ((options.bootstrap === false) ? (this.bootstrapButton +
            this.bootstrapFunction(options)) : (((options.client === undefined || options.server === undefined) ?
            '' : (options.client === false) ? '' : this.bootstrapButton) +
            this.bootstrapFunction(options.componentUrl) +
            ((options.client === false) ? '' : this.bootstrapApp))));
    };
    Runtime.prototype.prebootScript = function (config) {
        var baseUrl = (config && config.preboot && config.preboot.baseUrl) || '/preboot';
        return "\n    <preboot>\n      <link rel=\"stylesheet\" type=\"text/css\" href=\"" + baseUrl + "/preboot.css\">\n      <script src=\"" + baseUrl + "/preboot.js\"></script>\n      <script>preboot.start()</script>\n    </preboot>\n    ";
    };
    Runtime.prototype.angularScript = function (config) {
        var systemConfig = (config && config.systemjs) || {};
        var baseUrl = systemConfig.nodeModules || '/node_modules';
        var newConfig = Object.assign({}, {
            baseURL: '/',
            defaultJSExtensions: true
        }, systemConfig);
        return "\n    <!-- Browser polyfills -->\n    <script src=\"" + baseUrl + "/es6-shim/es6-shim.min.js\"></script>\n    <script src=\"" + baseUrl + "/systemjs/dist/system-polyfills.js\"></script>\n    <script src=\"" + baseUrl + "/angular2/bundles/angular2-polyfills.min.js\"></script>\n    <!-- SystemJS -->\n    <script src=\"" + baseUrl + "/systemjs/dist/system.js\"></script>\n    <!-- Angular2: Bundle -->\n    <script src=\"" + baseUrl + "/rxjs/bundles/Rx.js\"></script>\n    <script src=\"" + baseUrl + "/angular2/bundles/angular2.dev.js\"></script>\n    <script src=\"" + baseUrl + "/angular2/bundles/router.dev.js\"></script>\n    <script src=\"" + baseUrl + "/angular2/bundles/http.dev.js\"></script>\n    <script type=\"text/javascript\">\n    System.config(" + JSON.stringify(newConfig) + ");\n    </script>\n    ";
    };
    return Runtime;
}());
var hapiEngine = (function () {
    function hapiEngine() {
        this.helpers = {};
        this.partials = {};
    }
    hapiEngine.prototype.registerHelper = function (name, helper) {
        this.helpers[name] = helper;
    };
    hapiEngine.prototype.registerPartial = function (name, partial) {
        this.partials[name] = partial;
    };
    hapiEngine.prototype.compile = function (template, options, next) {
        var runtime = new Runtime(options);
        return next(null, function (context, options, callback) {
            return runtime.render(template, context, function (_, html) {
                return callback(_, html);
            });
        });
    };
    return hapiEngine;
}());
exports.hapiEngine = hapiEngine;
//# sourceMappingURL=engine.js.map