"use strict";
function clone(obj, seen) {
    if (typeof obj !== 'object' ||
        obj === null) {
        return obj;
    }
    seen = seen || { orig: [], copy: [] };
    var lookup = seen.orig.indexOf(obj);
    if (lookup !== -1) {
        return seen.copy[lookup];
    }
    var newObj;
    var cloneDeep = false;
    if (!Array.isArray(obj)) {
        if (Buffer.isBuffer(obj)) {
            newObj = new Buffer(obj);
        }
        else if (obj instanceof Date) {
            newObj = new Date(obj.getTime());
        }
        else if (obj instanceof RegExp) {
            newObj = new RegExp(obj);
        }
        else {
            var proto = Object.getPrototypeOf(obj);
            if (proto &&
                proto.isImmutable) {
                newObj = obj;
            }
            else {
                newObj = Object.create(proto);
                cloneDeep = true;
            }
        }
    }
    else {
        newObj = [];
        cloneDeep = true;
    }
    seen.orig.push(obj);
    seen.copy.push(newObj);
    if (cloneDeep) {
        var keys = Object.getOwnPropertyNames(obj);
        for (var i = 0; i < keys.length; ++i) {
            var key = keys[i];
            var descriptor = Object.getOwnPropertyDescriptor(obj, key);
            if (descriptor &&
                (descriptor.get ||
                    descriptor.set)) {
                Object.defineProperty(newObj, key, descriptor);
            }
            else {
                newObj[key] = exports.clone(obj[key], seen);
            }
        }
    }
    return newObj;
}
exports.clone = clone;
function stringify() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
    }
    try {
        return JSON.stringify.apply(null, args);
    }
    catch (err) {
        return '[Cannot display object: ' + err.message + ']';
    }
}
exports.stringify = stringify;
function assert(condition) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    if (condition) {
        return;
    }
    if (arguments.length === 2 && arguments[1] instanceof Error) {
        throw arguments[1];
    }
    var msgs = [];
    for (var i = 1; i < arguments.length; ++i) {
        if (arguments[i] !== '') {
            msgs.push(arguments[i]); // Avoids Array.slice arguments leak, allowing for V8 optimizations
        }
    }
    msgs = msgs.map(function (msg) {
        return typeof msg === 'string' ? msg : msg instanceof Error ? msg.message : stringify(msg);
    });
    throw new Error(msgs.join(' ') || 'Unknown error');
}
exports.assert = assert;
/*eslint-disable */
function merge(target, source, isNullOverride /* = true */, isMergeArrays /* = true */) {
    /*eslint-enable */
    assert(target && typeof target === 'object', 'Invalid target value: must be an object');
    assert(source === null ||
        source === undefined ||
        typeof source === 'object', 'Invalid source value: must be null, undefined, or an object');
    if (!source) {
        return target;
    }
    if (Array.isArray(source)) {
        assert(Array.isArray(target), 'Cannot merge array onto an object');
        if (isMergeArrays === false) {
            target.length = 0; // Must not change target assignment
        }
        for (var i = 0; i < source.length; ++i) {
            target.push(clone(source[i]));
        }
        return target;
    }
    var keys = Object.keys(source);
    for (var i = 0; i < keys.length; ++i) {
        var key = keys[i];
        var value = source[key];
        if (value &&
            typeof value === 'object') {
            /* tslint:disable */
            if (!target[key] ||
                typeof target[key] !== 'object' ||
                (Array.isArray(target[key]) !== Array.isArray(value)) ||
                value instanceof Date ||
                Buffer.isBuffer(value) ||
                value instanceof RegExp) {
                /* tslint:enable */
                target[key] = clone(value);
            }
            else {
                merge(target[key], value, isNullOverride, isMergeArrays);
            }
        }
        else {
            if (value !== null &&
                value !== undefined) {
                target[key] = value;
            }
            else if (isNullOverride !== false) {
                target[key] = value;
            }
        }
    }
    return target;
}
exports.merge = merge;
function applyToDefaults(defaults, options, isNullOverride) {
    assert(defaults && typeof defaults === 'object', 'Invalid defaults value: must be an object');
    assert(!options || options === true || typeof options === 'object', 'Invalid options value: must be true, falsy or an object');
    if (!options) {
        return null;
    }
    var copy = clone(defaults);
    if (options === true) {
        return copy;
    }
    return merge(copy, options, isNullOverride === true, false);
}
exports.applyToDefaults = applyToDefaults;
//# sourceMappingURL=ts-hoek.js.map