"use strict";
var testing_1 = require('@angular/core/testing');
var axis_resolver_1 = require('./axis-resolver');
var core_1 = require('@angular/core');
testing_1.describe('AxisResolver Class', function () {
    var makeMockElement = function () { return new core_1.ElementRef(document.createElement('div')); };
    var base_names = ['clientHeight', 'offsetHeight', 'scrollHeight'];
    testing_1.it('should create an instance of AxisResolver', function () {
        var testResolver = new axis_resolver_1.AxisResolver();
        testing_1.expect(testResolver).toEqual(jasmine.any(axis_resolver_1.AxisResolver));
    });
    testing_1.it('should default constructor arg to true', function () {
        var defaultResolver = new axis_resolver_1.AxisResolver();
        var verticalResolver = new axis_resolver_1.AxisResolver(true);
        var results = defaultResolver.topKey();
        testing_1.expect(results).toBe(verticalResolver.topKey());
    });
    testing_1.it('should change topKey() to "left" if created "horizontal"', function () {
        var horizontalResolver = new axis_resolver_1.AxisResolver(false);
        testing_1.expect(horizontalResolver.topKey()).toBe('left');
    });
    testing_1.it('should make Height into Width if created "horizontal"', function () {
        var horizontalResolver = new axis_resolver_1.AxisResolver(false);
        var methodNames = base_names.map(function (name) { return name + 'Key'; });
        var results = methodNames.map(function (mName) { return horizontalResolver[mName](); });
        var are_widths = results.map(function (result) { return result.match(/Width/); });
        testing_1.expect(are_widths.every(function (elt) { return elt; })).toBe(true);
    });
});
//# sourceMappingURL=data:application/json;base64,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